//FILENAME: gazelleModules/GazelleSCP.java
package gazelleModules;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;
import static loadableUtils.utils.l;
import loadableUtils.utils;
import static loadableUtils.utils.DynamicObject_loading;
import static loadableUtils.utils.rethrow;
import static loadableUtils.utils.add;
import static loadableUtils.utils._onJavaXSet;
import static loadableUtils.utils.a;
import static loadableUtils.utils.addAndReturn;
import static loadableUtils.utils.assertNotNull;
import static loadableUtils.utils.eq;
import static loadableUtils.utils.javaxSecretDir;
import static loadableUtils.utils.listDirs;
import static loadableUtils.utils.loadTextFile;
import static loadableUtils.utils.lock;
import static loadableUtils.utils.printStackTrace;
import static loadableUtils.utils.swing;
import static loadableUtils.utils.trim;
import static loadableUtils.utils.unlock;
import static loadableUtils.utils.scp;
import static loadableUtils.utils.zip;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;

public class GazelleSCP {

  static public String programID;

  static public void _onLoad_initUtils() {
    utils.__javax = javax();
  }

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public List<RemoteResourceInfo> scpLS(String user, String host, String remoteDir) {
    try {
      final SSHClient client = sshLogin(user, host);
      try {
        return client.newSFTPClient().ls(remoteDir);
      } finally {
        sshDisconnect(client);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class javax() {
    return getJavaX();
  }

  static public boolean sshLogin_keepOpen = false;

  static public String sshLogin_openUser;

  static public String sshLogin_openHost;

  static public SSHClient sshLogin_client;

  static public Lock sshLogin_lock = lock();

  static public SSHClient sshLogin(String user, String host) {
    try {
      {
        Lock __0 = sshLogin_lock;
        lock(__0);
        try {
          if (sshLogin_client != null && eq(sshLogin_openUser, user) && eq(sshLogin_openHost, host))
            return sshLogin_client;
        } finally {
          unlock(__0);
        }
      }
      String pass = findSSHPassword(user, host);
      final SSHClient client = new SSHClient();
      client.addHostKeyVerifier(new PromiscuousVerifier());
      client.connect(host);
      try {
        client.authPassword(user, pass);
      } catch (Throwable e) {
        client.disconnect();
        rethrow(e);
      }
      Lock __1 = sshLogin_lock;
      lock(__1);
      try {
        if (sshLogin_keepOpen && sshLogin_client == null) {
          sshLogin_openUser = user;
          sshLogin_openHost = host;
          sshLogin_client = client;
        }
        return client;
      } finally {
        unlock(__1);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanMeUp_sshLogin() {
    Lock __2 = sshLogin_lock;
    lock(__2);
    try {
      if (sshLogin_client != null) {
        try {
          sshLogin_client.disconnect();
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
        sshLogin_client = null;
      }
    } finally {
      unlock(__2);
    }
  }

  static public void sshDisconnect(SSHClient client) {
    try {
      if (client == null)
        return;
      {
        Lock __0 = sshLogin_lock;
        lock(__0);
        try {
          if (client == sshLogin_client)
            return;
        } finally {
          unlock(__0);
        }
      }
      client.disconnect();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void __setJavaX(Class j) {
    __javax = j;
    _onJavaXSet();
  }

  static public String findSSHPassword(String user, String server) {
    return trim(loadTextFile(orFail("SSH password for " + user + "@" + server + " not found on this machine (make a file called " + sshPasswordFileName(user, server) + " somewhere under " + javaxSecretDir() + ")", findSSHPasswordFile(user, server))));
  }

  static public <A> A orFail(String failMsg, A a) {
    return assertNotNull(failMsg, a);
  }

  static public String sshPasswordFileName(String user, String server) {
    return user + "@" + server + ".ssh.pass";
  }

  static public File findSSHPasswordFile(String user, String server) {
    return findSecretFile(sshPasswordFileName(user, server));
  }

  static public File findSecretFile(String name) {
    List<File> l = new ArrayList();
    for (File dir : allSecretDirs()) {
      File f = new File(dir, name);
      if (f.exists())
        return f;
    }
    return null;
  }

  static public List<File> allSecretDirs() {
    List<File> l = new ArrayList();
    for (File dir : listDirs(addAndReturn(l, javaxSecretDir()))) l.add(dir);
    return l;
  }
}








