import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.Const;
import org.apache.bcel.generic.*;
import static x30_pkg.x30_util.DynamicObject;
import java.awt.geom.*;

public class main {

  public static void main(final String[] args) throws Exception {
    ClassMaker<IF0> c = new ClassMaker<>(IF0.class);
    var m = new MethodMaker(c.cg, Object.class, "get");
    int buffer = m.newLocalVar();
    m.newObject(StringBuffer.class).astore(buffer);
    for (var string : ll("Hello ", "world")) {
      m.aload(buffer).stringConstant(string);
      m.il.append(m.factory.createAppend(org.apache.bcel.generic.Type.OBJECT));
    }
    m.aload(buffer);
    m.invokeVirtual(StringBuffer.class, String.class, "toString");
    m.areturn().done();
    c.printClassWithMethods();
    IF0 f = c.newInstance();
    print(f);
    assertEqualsVerbose("Hello world", f.get());
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static public boolean printAlsoToSystemOut = true;

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print(combinePrintParameters(s, o));
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    try {
      Object f = getThreadLocal(print_byThread_dontCreate());
      if (f == null)
        f = print_allThreads;
      if (f != null)
        if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
          return;
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
    }
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    if (printAlsoToSystemOut)
      System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((nempty(msg) ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public String combinePrintParameters(String s, Object o) {
    return (endsWithLetterOrDigit(s) ? s + ": " : s) + o;
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(A a, IVF1<A> f) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(IVF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF(Object f, Object... args) {
    return safeCallF(f, args);
  }

  static public Object safeCallF(Object f, Object... args) {
    if (f instanceof Runnable) {
      ((Runnable) f).run();
      return null;
    }
    if (f == null)
      return null;
    Class c = f.getClass();
    ArrayList<Method> methods;
    synchronized (callF_cache) {
      methods = callF_cache.get(c);
      if (methods == null)
        methods = callF_makeCache(c);
    }
    int n = l(methods);
    if (n == 0) {
      if (f instanceof String)
        throw fail("Legacy call: " + f);
      throw fail("No get method in " + getClassName(c));
    }
    if (n == 1)
      return invokeMethod(methods.get(0), f, args);
    for (int i = 0; i < n; i++) {
      Method m = methods.get(i);
      if (call_checkArgs(m, args, false))
        return invokeMethod(m, f, args);
    }
    throw fail("No matching get method in " + getClassName(c));
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public String getStackTrace(String msg) {
    return getStackTrace_noRecord(new Throwable(msg));
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
    pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public Class mc() {
    return main.class;
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public boolean eq(Symbol a, String b) {
    return eq(str(a), b);
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(Object... objects) {
    throw new Fail(objects);
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(BitSet bs) {
    return !empty(bs);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(MultiMap mm) {
    return mm != null && !mm.isEmpty();
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(Rect r) {
    return r != null && r.w != 0 && r.h != 0;
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(BitSet bs) {
    return bs == null || bs.isEmpty();
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiMap mm) {
    return mm == null || mm.isEmpty();
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(Rect r) {
    return !(r != null && r.w != 0 && r.h != 0);
  }

  static public String appendColonIfNempty(String s) {
    return empty(s) ? "" : s + ": ";
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping() {
    newPing();
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  static public int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  static public int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  static public int l(Map m) {
    return m == null ? 0 : m.size();
  }

  static public int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public long l(File f) {
    return f == null ? 0 : f.length();
  }

  static public int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : o instanceof Object[] ? l((Object[]) o) : o instanceof boolean[] ? l((boolean[]) o) : o instanceof byte[] ? l((byte[]) o) : o instanceof char[] ? l((char[]) o) : o instanceof short[] ? l((short[]) o) : o instanceof int[] ? l((int[]) o) : o instanceof float[] ? l((float[]) o) : o instanceof double[] ? l((double[]) o) : o instanceof long[] ? l((long[]) o) : (Integer) call(o, "size");
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  static public <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  static public <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  static public int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  static public int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  static public <A> int indexOf(Iterable<A> l, A a) {
    if (l == null)
      return -1;
    int i = 0;
    for (A x : l) {
      if (eq(x, a))
        return i;
      i++;
    }
    return -1;
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public void pcallFAll_minimalExceptionHandling(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        ping();
        pcallF_minimalExceptionHandling(f, args);
      }
  }

  static public void pcallFAll_minimalExceptionHandling(Iterator it, Object... args) {
    while (it.hasNext()) {
      ping();
      pcallF_minimalExceptionHandling(it.next(), args);
    }
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public void newPing() {
    var tl = newPing_actionTL();
    Runnable action = tl == null ? null : tl.get();
    {
      if (action != null)
        action.run();
    }
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  static public boolean isTrue(Boolean b) {
    return b != null && b.booleanValue();
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Map<String, Field> getOpt_getFieldMap(Object o) {
    Class c = _getClass(o);
    HashMap<String, Field> map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
    return map;
  }

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Map<String, Field> map = getOpt_getFieldMap(o);
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return syncMapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  static public <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public String hostNameFromURL(String url) {
    try {
      return empty(url) ? null : new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public Object pcallF_minimalExceptionHandling(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
      _storeException(e);
    }
    return null;
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (vm_generalMap()) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public List _registerWeakMap_preList;

  static public <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  static public void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL;

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL() {
    if (newPing_actionTL == null)
      newPing_actionTL = vm_generalMap_getOrCreate("newPing_actionTL", () -> {
        Runnable value = (Runnable) (callF_gen(vm_generalMap_get("newPing_valueForNewThread")));
        var tl = new x30_pkg.x30_util.BetterThreadLocal<Runnable>();
        tl.set(value);
        return tl;
      });
    return newPing_actionTL;
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  static public void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  static public boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  static public boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return classLoaderForObject(realm).loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public <A, B> B syncMapGet2(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (collectionMutex(map)) {
      return map.get(a);
    }
  }

  static public <A, B> B syncMapGet2(A a, Map<A, B> map) {
    return syncMapGet2(map, a);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public HashMap<String, List<Method>> callMC_cache = new HashMap();

  static public String callMC_key;

  static public Method callMC_value;

  static public Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  static public Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  static public Class javax() {
    return getJavaX();
  }

  static public <A> List<A> synchroList() {
    return synchroList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public Map synchroHashMap() {
    return synchronizedMap(new HashMap());
  }

  static public Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first((Collection) strings));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(String glue, Object... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Long> asList(long[] a) {
    if (a == null)
      return null;
    ArrayList<Long> l = emptyList(a.length);
    for (long i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public ArrayList<Short> asList(short[] a) {
    if (a == null)
      return null;
    ArrayList<Short> l = emptyList(a.length);
    for (short i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterator<A> it) {
    ArrayList l = new ArrayList();
    if (it != null)
      while (it.hasNext()) l.add(it.next());
    return l;
  }

  static public <A> ArrayList<A> asList(IterableIterator<A> s) {
    return asList((Iterator) s);
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A> List<A> asList(Pair<A, A> p) {
    return p == null ? null : ll(p.a, p.b);
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    return o;
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public Throwable _storeException_value;

  static public void _storeException(Throwable e) {
    _storeException_value = e;
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public Map syncHashMap() {
    return synchroHashMap();
  }

  static public <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  static public <A> A vm_generalMap_getOrCreate(Object key, F0<A> create) {
    return vm_generalMap_getOrCreate(key, f0ToIF0(create));
  }

  static public <A> A vm_generalMap_getOrCreate(Object key, IF0<A> create) {
    Map generalMap = vm_generalMap();
    if (generalMap == null)
      return null;
    synchronized (generalMap) {
      A a = (A) (vm_generalMap_get(key));
      if (a == null)
        vm_generalMap_put(key, a = create == null ? null : create.get());
      return a;
    }
  }

  static public <A> A callF_gen(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF_gen(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF_gen(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A> void callF_gen(VF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(A a, IVF1<A> f) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(IVF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public Object callF_gen(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF_gen(Object f, Object... args) {
    return callF(f, args);
  }

  static public ClassLoader classLoaderForObject(Object o) {
    if (o instanceof ClassLoader)
      return ((ClassLoader) o);
    if (o == null)
      return null;
    return _getClass(o).getClassLoader();
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(Object... c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void __setJavaX(Class j) {
    __javax = j;
    _onJavaXSet();
  }

  static public Map synchronizedMap() {
    return synchroMap();
  }

  static public <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
    return synchroMap(map);
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A, B> Pair<A, B> first(Map<A, B> map) {
    return mapEntryToPair(first(entrySet(map)));
  }

  static public <A, B> Pair<A, B> first(MultiMap<A, B> mm) {
    if (mm == null)
      return null;
    var e = first(mm.data.entrySet());
    if (e == null)
      return null;
    return pair(e.getKey(), first(e.getValue()));
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public <A> A first(A[] l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(pred, l);
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnull(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public int unnull(Integer i) {
    return i == null ? 0 : i;
  }

  static public long unnull(Long l) {
    return l == null ? 0L : l;
  }

  static public double unnull(Double l) {
    return l == null ? 0.0 : l;
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, lCharSequence(l));
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(Symbol a, Symbol b) {
    return eq(a, b);
  }

  static public boolean eqic(Symbol a, String b) {
    return eqic(asString(a), b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public boolean get(BitSet bs, int idx) {
    return bs != null && bs.get(idx);
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    if (e != null)
      print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public <A> IF0<A> f0ToIF0(F0<A> f) {
    return f == null ? null : () -> f.get();
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public void _onJavaXSet() {
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, int destPos, int n) {
    arraycopy(src, srcPos, src, destPos, n);
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public <A, B> Pair<A, B> mapEntryToPair(Map.Entry<A, B> e) {
    return e == null ? null : pair(e.getKey(), e.getValue());
  }

  static public <A, B> Set<Map.Entry<A, B>> entrySet(Map<A, B> map) {
    return _entrySet(map);
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, A[] l) {
    return firstThat(l, pred);
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public Symbol emptySymbol_value;

  static public Symbol emptySymbol() {
    if (emptySymbol_value == null)
      emptySymbol_value = symbol("");
    return emptySymbol_value;
  }

  static public int lCharSequence(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public <A extends Comparable<A>> A max(A a, A b) {
    return cmp(a, b) >= 0 ? a : b;
  }

  static public Object getOptDynOnly(DynamicObject o, String field) {
    if (o == null || o.fieldValues == null)
      return null;
    return o.fieldValues.get(field);
  }

  static public <A> Set<A> synchroHashSet() {
    return synchronizedSet(new HashSet<A>());
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public <A, B> Set<Map.Entry<A, B>> _entrySet(Map<A, B> map) {
    return map == null ? Collections.EMPTY_SET : map.entrySet();
  }

  static public String unnullForIteration(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnullForIteration(Collection<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public <A> List<A> unnullForIteration(List<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public int[] unnullForIteration(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnullForIteration(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnullForIteration(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public short[] unnullForIteration(short[] l) {
    return l == null ? emptyShortArray() : l;
  }

  static public <A, B> Map<A, B> unnullForIteration(Map<A, B> l) {
    return l == null ? immutableEmptyMap() : l;
  }

  static public <A> Iterable<A> unnullForIteration(Iterable<A> i) {
    return i == null ? immutableEmptyList() : i;
  }

  static public <A> A[] unnullForIteration(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnullForIteration(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnullForIteration(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnullForIteration(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnullForIteration(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public long unnullForIteration(Long l) {
    return l == null ? 0L : l;
  }

  static public WeakHasherMap<Symbol, Boolean> symbol_map = new WeakHasherMap(new Hasher<Symbol>() {

    public int hashCode(Symbol symbol) {
      return symbol.text.hashCode();
    }

    public boolean equals(Symbol a, Symbol b) {
      if (a == null)
        return b == null;
      return b != null && eq(a.text, b.text);
    }
  });

  static public Symbol symbol(String s) {
    if (s == null)
      return null;
    synchronized (symbol_map) {
      Symbol symbol = new Symbol(s, true);
      Symbol existingSymbol = symbol_map.findKey(symbol);
      if (existingSymbol == null)
        symbol_map.put(existingSymbol = symbol, true);
      return existingSymbol;
    }
  }

  static public Symbol symbol(CharSequence s) {
    if (s == null)
      return null;
    if (s instanceof Symbol)
      return (Symbol) s;
    if (s instanceof String)
      return symbol((String) s);
    return symbol(str(s));
  }

  static public Symbol symbol(Object o) {
    return symbol((CharSequence) o);
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public <A> List<A> immutableEmptyList() {
    return Collections.emptyList();
  }

  static public short[] emptyShortArray = new short[0];

  static public short[] emptyShortArray() {
    return emptyShortArray;
  }

  static public <A, B> Map<A, B> immutableEmptyMap() {
    return Collections.emptyMap();
  }

  static public class MethodMaker {

    public ClassGen cg;

    public MethodGen mg;

    public InstructionList il = new InstructionList();

    public ConstantPoolGen cp;

    public InstructionFactory factory;

    public int frameSize;

    public MethodMaker(ClassGen cg, Class returnType, String methodName, Class... argumentTypes) {
      this(cg, methodName, returnType, argumentTypes);
    }

    public MethodMaker(ClassGen cg, String methodName, Class returnType, Class... argumentTypes) {
      this.cg = cg;
      cp = cg.getConstantPool();
      factory = new InstructionFactory(cg);
      org.apache.bcel.generic.Type[] argTypes = wrapTypes(argumentTypes);
      mg = new MethodGen(Const.ACC_PUBLIC, wrapType(returnType), argTypes, null, methodName, cg.getClassName(), il, cp);
      frameSize = l(argTypes) + 1;
    }

    public org.apache.bcel.generic.Type[] wrapTypes(Class[] classes) {
      org.apache.bcel.generic.Type[] types = new org.apache.bcel.generic.Type[l(classes)];
      for (int i = 0; i < l(classes); i++) types[i] = wrapType(classes[i]);
      return types;
    }

    public org.apache.bcel.generic.Type wrapType(Class c) {
      return c == null ? null : new ObjectType(className(c));
    }

    public int newLocalVar() {
      return frameSize++;
    }

    public MethodMaker newObject(Class c, Class... argTypes) {
      il.append(factory.createNew(className(c)));
      il.append(InstructionConst.DUP);
      Constructor ctor = findConstructor_precise_onTypes(c, argTypes);
      il.append(factory.createInvoke(className(c), "<init>", org.apache.bcel.generic.Type.VOID, wrapTypes(ctor.getParameterTypes()), Const.INVOKESPECIAL));
      return this;
    }

    public MethodMaker dup() {
      il.append(InstructionConst.DUP);
      return this;
    }

    public MethodMaker astore(int var) {
      il.append(new ASTORE(var));
      return this;
    }

    public MethodMaker aload(int var) {
      il.append(new ALOAD(var));
      return this;
    }

    public MethodMaker stringConstant(String s) {
      il.append(new PUSH(cp, s));
      return this;
    }

    public MethodMaker invokeVirtual(Class c, Class returnType, String methodName, Class... argTypes) {
      return invokeVirtual(c, methodName, returnType, argTypes);
    }

    public MethodMaker invokeVirtual(Class c, String methodName, Class returnType, Class... argTypes) {
      Method m = findNonStaticMethod_precise_onTypes(c, methodName, argTypes);
      if (m == null)
        throw fail("Method not found: " + className(c) + "." + formatFunctionCall(methodName, argTypes) + " returning " + className(returnType));
      il.append(factory.createInvoke(className(c), methodName, wrapType(m.getReturnType()), wrapTypes(m.getParameterTypes()), Const.INVOKEVIRTUAL));
      return this;
    }

    public MethodMaker areturn() {
      il.append(InstructionConst.ARETURN);
      return this;
    }

    public void done() {
      mg.stripAttributes(true);
      mg.setMaxStack();
      mg.setMaxLocals();
      cg.addMethod(mg.getMethod());
    }
  }

  final static public class _MethodCache {

    final public Class c;

    final public HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      Module myModule = getClass().getModule();
      boolean anyHiddenClasses = false;
      while (_c != null) {
        boolean exported = classIsExportedTo(_c, myModule);
        if (!exported)
          anyHiddenClasses = true;
        else
          for (Method m : _c.getDeclaredMethods()) if ((anyHiddenClasses || !isAbstract(m)) && !reflection_isForbiddenMethod(m))
            multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if ((anyHiddenClasses || m.isDefault()) && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static abstract public class VF1<A> implements IVF1<A> {

    public abstract void get(A a);
  }

  static public class Matches {

    public String[] m;

    public Matches() {
    }

    public Matches(String... m) {
      this.m = m;
    }

    public String get(int i) {
      return i < m.length ? m[i] : null;
    }

    public String unq(int i) {
      return unquote(get(i));
    }

    public String tlc(int i) {
      return unq(i).toLowerCase();
    }

    public boolean bool(int i) {
      return "true".equals(unq(i));
    }

    public String rest() {
      return m[m.length - 1];
    }

    public int psi(int i) {
      return Integer.parseInt(unq(i));
    }

    public String toString() {
      return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")";
    }

    public int hashCode() {
      return _hashCode(toList(m));
    }

    public boolean equals(Object o) {
      return o instanceof Matches && arraysEqual(m, ((Matches) o).m);
    }
  }

  static public class Symbol implements CharSequence {

    public String text;

    public Symbol() {
    }

    public Symbol(String text, boolean dummy) {
      this.text = text;
    }

    public int hashCode() {
      return _hashCode(text);
    }

    public String toString() {
      return text;
    }

    public boolean equals(Object o) {
      return this == o;
    }

    public int length() {
      return text.length();
    }

    public char charAt(int index) {
      return text.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
      return text.substring(start, end);
    }
  }

  static abstract public class F0<A> {

    abstract public A get();
  }

  static abstract public class F1<A, B> {

    abstract public B get(A a);
  }

  static abstract public class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  static public class MultiMap<A, B> {

    public Map<A, List<B>> data = new HashMap<A, List<B>>();

    public int fullSize;

    public MultiMap() {
    }

    public MultiMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiMap(MultiMap<A, B> map) {
      putAll(map);
    }

    public MultiMap(Map<A, List<B>> data) {
      this.data = data;
    }

    public void put(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        list.add(value);
        ++fullSize;
      }
    }

    public void add(A key, B value) {
      put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      putAll(key, values);
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(Collection<A> keys, B value) {
      synchronized (data) {
        for (A key : unnullForIteration(keys)) put(key, value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        if (nempty(values))
          getActual(key).addAll(values);
      }
    }

    public void putAll(Iterable<Pair<A, B>> pairs) {
      synchronized (data) {
        for (Pair<A, B> p : unnullForIteration(pairs)) put(p.a, p.b);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public List<B> get(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        return list == null ? Collections.<B>emptyList() : list;
      }
    }

    public List<B> getOpt(A key) {
      synchronized (data) {
        return data.get(key);
      }
    }

    public List<B> getAndClear(A key) {
      synchronized (data) {
        List<B> l = cloneList(data.get(key));
        remove(key);
        return l;
      }
    }

    public List<B> getActual(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        return list;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null && list.isEmpty()) {
          fullSize -= l(list);
          data.remove(key);
        }
      }
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public Set<A> keys() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        fullSize -= l(this.getOpt(key));
        data.remove(key);
      }
    }

    final public void remove(Pair<A, B> p) {
      removePair(p);
    }

    public void removePair(Pair<A, B> p) {
      if (p != null)
        remove(p.a, p.b);
    }

    public void remove(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null) {
          if (list.remove(value))
            fullSize--;
          if (list.isEmpty())
            data.remove(key);
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        List<B> list = get(key);
        return list.isEmpty() ? null : list.get(0);
      }
    }

    public void addAll(MultiMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    final public int keyCount() {
      return keysSize();
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    final public int fullSize() {
      return size();
    }

    public int size() {
      synchronized (data) {
        return fullSize;
      }
    }

    public List<A> reverseGet(B b) {
      synchronized (data) {
        List<A> l = new ArrayList();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, List<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public List<B> _makeEmptyList() {
      return new ArrayList();
    }

    public Collection<List<B>> allLists() {
      synchronized (data) {
        return new ArrayList(data.values());
      }
    }

    public Collection<List<B>> values() {
      return allLists();
    }

    public List<B> allValues() {
      return concatLists(data.values());
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }
  }

  static public class ClassMaker<A> {

    public String className;

    public ClassGen cg;

    public JavaClass baked;

    public InMemoryClassLoader classLoader;

    public Class loadedClass;

    public ClassMaker(Class<A> interfaceToImplement) {
      className = randomClassName();
      cg = new ClassGen(className, "java.lang.Object", null, Const.ACC_PUBLIC, new String[] { className(interfaceToImplement) });
      cg.addEmptyConstructor(Const.ACC_PUBLIC);
    }

    public JavaClass bake() {
      if (baked == null)
        baked = cg.getJavaClass();
      return baked;
    }

    public void printClassWithMethods() {
      print(bake());
      for (var method : baked.getMethods()) {
        print("\n" + method);
        print(method.getCode());
      }
    }

    public byte[] toBytes_cache;

    public byte[] toBytes() {
      if (toBytes_cache == null)
        toBytes_cache = toBytes_load();
      return toBytes_cache;
    }

    public byte[] toBytes_load() {
      return bake().getBytes();
    }

    public Class<A> load() {
      if (loadedClass == null) {
        var bytes = toBytes();
        classLoader = new InMemoryClassLoader(myClassLoader());
        loadedClass = (Class) classLoader.defineAClass(className, bytes);
      }
      return loadedClass;
    }

    public A newInstance() {
      return main.newInstance(load());
    }
  }

  static public interface IF0<A> {

    public A get();
  }

  static public interface Hasher<A> {

    public int hashCode(A a);

    public boolean equals(A a, A b);
  }

  static public interface IF1<A, B> {

    public B get(A a);
  }

  static final public class WeakHasherMap<K, V> extends AbstractMap<K, V> implements Map<K, V> {

    public Hasher hasher = null;

    final public boolean keyEquals(Object k1, Object k2) {
      return (hasher == null ? k1.equals(k2) : hasher.equals(k1, k2));
    }

    final public int keyHashCode(Object k1) {
      return (hasher == null ? k1.hashCode() : hasher.hashCode(k1));
    }

    final public WeakKey WeakKeyCreate(K k) {
      if (k == null)
        return null;
      else
        return new WeakKey(k);
    }

    final public WeakKey WeakKeyCreate(K k, ReferenceQueue<? super K> q) {
      if (k == null)
        return null;
      else
        return new WeakKey(k, q);
    }

    final public class WeakKey extends WeakReference<K> {

      public int hash;

      public WeakKey(K k) {
        super(k);
        hash = keyHashCode(k);
      }

      final public WeakKey create(K k) {
        if (k == null)
          return null;
        else
          return new WeakKey(k);
      }

      public WeakKey(K k, ReferenceQueue<? super K> q) {
        super(k, q);
        hash = keyHashCode(k);
      }

      final public WeakKey create(K k, ReferenceQueue<? super K> q) {
        if (k == null)
          return null;
        else
          return new WeakKey(k, q);
      }

      @Override
      public boolean equals(Object o) {
        if (o == null)
          return false;
        if (this == o)
          return true;
        if (!(o.getClass().equals(WeakKey.class)))
          return false;
        Object t = this.get();
        @SuppressWarnings("unchecked")
        Object u = ((WeakKey) o).get();
        if ((t == null) || (u == null))
          return false;
        if (t == u)
          return true;
        return keyEquals(t, u);
      }

      @Override
      public int hashCode() {
        return hash;
      }
    }

    public HashMap<WeakKey, V> hash;

    public ReferenceQueue<? super K> queue = new ReferenceQueue<K>();

    @SuppressWarnings("unchecked")
    final public void processQueue() {
      WeakKey wk;
      while ((wk = (WeakKey) queue.poll()) != null) {
        hash.remove(wk);
      }
    }

    public WeakHasherMap(int initialCapacity, float loadFactor) {
      hash = new HashMap<WeakKey, V>(initialCapacity, loadFactor);
    }

    public WeakHasherMap(int initialCapacity) {
      hash = new HashMap<WeakKey, V>(initialCapacity);
    }

    public WeakHasherMap() {
      hash = new HashMap<WeakKey, V>();
    }

    public WeakHasherMap(Hasher h) {
      hash = new HashMap<WeakKey, V>();
      hasher = h;
    }

    @Override
    public int size() {
      return entrySet().size();
    }

    @Override
    public boolean isEmpty() {
      return entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.containsKey(WeakKeyCreate(kkey));
    }

    @Override
    public V get(Object key) {
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.get(WeakKeyCreate(kkey));
    }

    @Override
    public V put(K key, V value) {
      processQueue();
      return hash.put(WeakKeyCreate(key, queue), value);
    }

    @Override
    public V remove(Object key) {
      processQueue();
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.remove(WeakKeyCreate(kkey));
    }

    @Override
    public void clear() {
      processQueue();
      hash.clear();
    }

    @SuppressWarnings("TypeParameterShadowing")
    final public class Entry<K, V> implements Map.Entry<K, V> {

      public Map.Entry<WeakKey, V> ent;

      public K key;

      public Entry(Map.Entry<WeakKey, V> ent, K key) {
        this.ent = ent;
        this.key = key;
      }

      @Override
      public K getKey() {
        return key;
      }

      @Override
      public V getValue() {
        return ent.getValue();
      }

      @Override
      public V setValue(V value) {
        return ent.setValue(value);
      }

      final public boolean keyvalEquals(K o1, K o2) {
        return (o1 == null) ? (o2 == null) : keyEquals(o1, o2);
      }

      final public boolean valEquals(V o1, V o2) {
        return (o1 == null) ? (o2 == null) : o1.equals(o2);
      }

      @SuppressWarnings("NonOverridingEquals")
      public boolean equals(Map.Entry<K, V> e) {
        return (keyvalEquals(key, e.getKey()) && valEquals(getValue(), e.getValue()));
      }

      @Override
      public int hashCode() {
        V v;
        return (((key == null) ? 0 : keyHashCode(key)) ^ (((v = getValue()) == null) ? 0 : v.hashCode()));
      }
    }

    final public class EntrySet extends AbstractSet<Map.Entry<K, V>> {

      public Set<Map.Entry<WeakKey, V>> hashEntrySet = hash.entrySet();

      @Override
      public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>() {

          public Iterator<Map.Entry<WeakKey, V>> hashIterator = hashEntrySet.iterator();

          public Map.Entry<K, V> next = null;

          @Override
          public boolean hasNext() {
            while (hashIterator.hasNext()) {
              Map.Entry<WeakKey, V> ent = hashIterator.next();
              WeakKey wk = ent.getKey();
              K k = null;
              if ((wk != null) && ((k = wk.get()) == null)) {
                continue;
              }
              next = new Entry<K, V>(ent, k);
              return true;
            }
            return false;
          }

          @Override
          public Map.Entry<K, V> next() {
            if ((next == null) && !hasNext())
              throw new NoSuchElementException();
            Map.Entry<K, V> e = next;
            next = null;
            return e;
          }

          @Override
          public void remove() {
            hashIterator.remove();
          }
        };
      }

      @Override
      public boolean isEmpty() {
        return !(iterator().hasNext());
      }

      @Override
      public int size() {
        int j = 0;
        for (Iterator<Map.Entry<K, V>> i = iterator(); i.hasNext(); i.next()) j++;
        return j;
      }

      @Override
      public boolean remove(Object o) {
        processQueue();
        if (!(o instanceof Map.Entry<?, ?>))
          return false;
        @SuppressWarnings("unchecked")
        Map.Entry<K, V> e = (Map.Entry<K, V>) o;
        Object ev = e.getValue();
        WeakKey wk = WeakKeyCreate(e.getKey());
        Object hv = hash.get(wk);
        if ((hv == null) ? ((ev == null) && hash.containsKey(wk)) : hv.equals(ev)) {
          hash.remove(wk);
          return true;
        }
        return false;
      }

      @Override
      public int hashCode() {
        int h = 0;
        for (Iterator<Map.Entry<WeakKey, V>> i = hashEntrySet.iterator(); i.hasNext(); ) {
          Map.Entry<WeakKey, V> ent = i.next();
          WeakKey wk = ent.getKey();
          Object v;
          if (wk == null)
            continue;
          h += (wk.hashCode() ^ (((v = ent.getValue()) == null) ? 0 : v.hashCode()));
        }
        return h;
      }
    }

    public Set<Map.Entry<K, V>> entrySet = null;

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
      if (entrySet == null)
        entrySet = new EntrySet();
      return entrySet;
    }

    public K findKey(Object key) {
      processQueue();
      K kkey = (K) key;
      WeakKey wkey = WeakKeyCreate(kkey);
      WeakKey found = hashMap_findKey(hash, wkey);
      return found == null ? null : found.get();
    }
  }

  static public class PersistableThrowable extends DynamicObject {

    public String className;

    public String msg;

    public String stacktrace;

    public PersistableThrowable() {
    }

    public PersistableThrowable(Throwable e) {
      if (e == null)
        className = "Crazy Null Error";
      else {
        className = getClassName(e).replace('/', '.');
        msg = e.getMessage();
        stacktrace = getStackTrace_noRecord(e);
      }
    }

    public String toString() {
      return nempty(msg) ? className + ": " + msg : className;
    }
  }

  static public interface IVF1<A> {

    public void get(A a);
  }

  static public class Fail extends RuntimeException implements IFieldsToList {

    public Object[] objects;

    public Fail() {
    }

    public Fail(Object... objects) {
      this.objects = objects;
    }

    public Object[] _fieldsToList() {
      return new Object[] { objects };
    }

    public Fail(Throwable cause, Object... objects) {
      super(cause);
      this.objects = objects;
    }

    public String toString() {
      return joinNemptiesWithColon("Fail", commaCombine(getCause(), objects));
    }
  }

  static public class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  static public interface IFieldsToList {

    public Object[] _fieldsToList();
  }

  static public class InMemoryClassLoader extends ClassLoader {

    public InMemoryClassLoader(ClassLoader parent) {
      super(parent);
    }

    public Class<?> defineAClass(String name, byte[] bytes) {
      return defineClass(name, bytes, 0, bytes.length);
    }
  }

  static public <A> A newObject(Class<A> c, Object... args) {
    return (A) nuObject(c, args);
  }

  static public Object newObject(String className, Object... args) {
    return nuObject(className, args);
  }

  static public Constructor findConstructor_precise_onTypes(Class c, Class... argTypes) {
    try {
      List<Constructor> ctors = constructorsWithNumberOfArguments(c, l(argTypes));
      Lowest<Constructor> best = new Lowest();
      if (ctors != null)
        for (Constructor ctor : ctors) {
          int score = methodApplicabilityScore_onTypes(ctor, argTypes);
          if (score < Integer.MAX_VALUE)
            best.put(ctor, score);
        }
      return best.get();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Method findNonStaticMethod_precise_onTypes(Object o, String method, Class... argTypes) {
    try {
      Class c = _getClass(o);
      if (c == null)
        return null;
      _MethodCache cache = callOpt_getCache(c);
      List<Method> methods = cache.cache.get(method);
      Lowest<Method> best = new Lowest();
      if (methods != null)
        for (Method m : methods) {
          {
            if (isStaticMethod(m))
              continue;
          }
          int score = methodApplicabilityScore_onTypes(m, argTypes);
          if (score < Integer.MAX_VALUE)
            best.put(m, score);
        }
      return best.get();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String formatFunctionCall(String fname, Object... args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Object... args) {
    return fname + "(" + joinWithComma(allToString(args)) + ")";
  }

  static public String formatFunctionCall(String fname, Iterable args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Iterable args) {
    return formatFunctionCall(fname, toObjectArray(args));
  }

  static public Class<?> getClass(String name) {
    return _getClass(name);
  }

  static public Class getClass(Object o) {
    return _getClass(o);
  }

  static public Class getClass(Object realm, String name) {
    return _getClass(realm, name);
  }

  static public boolean classIsExportedTo(Class c, Module destModule) {
    if (c == null || destModule == null)
      return false;
    Module srcModule = c.getModule();
    String packageName = c.getPackageName();
    return srcModule.isExported(packageName, destModule);
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  static public void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public List<String> quoteAll(String[] l) {
    return quoteAll(asList(l));
  }

  static public List<String> quoteAll(Collection<String> l) {
    List<String> x = new ArrayList();
    for (String s : l) x.add(quote(s));
    return x;
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public boolean arraysEqual(Object[] a, Object[] b) {
    if (a.length != b.length)
      return false;
    for (int i = 0; i < a.length; i++) if (neq(a[i], b[i]))
      return false;
    return true;
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public UnsupportedOperationException unsupportedOperation() {
    throw new UnsupportedOperationException();
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll((Map) b);
    return a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
    if (a != null)
      litmap_impl(a, b);
    return a;
  }

  static public <A> void remove(List<A> l, int i) {
    if (l != null && i >= 0 && i < l(l))
      l.remove(i);
  }

  static public <A> void remove(Collection<A> l, A a) {
    if (l != null)
      l.remove(a);
  }

  static public <A, B> B remove(Map<A, B> map, Object a) {
    return map == null ? null : map.remove(a);
  }

  static public void remove(BitSet bs, int i) {
    bs.clear(i);
  }

  static public <A> A getAndClear(IVar<A> v) {
    A a = v.get();
    v.set(null);
    return a;
  }

  static public <A, B> Set<A> keySet(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keySet(Object map) {
    return keys((Map) map);
  }

  static public <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A, B> int keysSize(MultiMap<A, B> mm) {
    return lKeys(mm);
  }

  static public <A> A reverseGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    int n = l(l);
    return idx < n ? l.get(n - 1 - idx) : null;
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public AtomicLong randomClassName_counter = new AtomicLong();

  static public String randomClassName() {
    return "UserCode" + inc(randomClassName_counter);
  }

  static public Object load(String varName) {
    readLocally(varName);
    return get(mc(), varName);
  }

  static public Object load(String progID, String varName) {
    readLocally(progID, varName);
    return get(mc(), varName);
  }

  static public ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  static public <A> A newInstance(Class<A> c, Object... args) {
    return nuObject(c, args);
  }

  static public Object newInstance(String className, Object... args) {
    return nuObject(className, args);
  }

  static public Method hashMap_findKey_method;

  static public <A, B> A hashMap_findKey(HashMap<A, B> map, Object key) {
    try {
      if (hashMap_findKey_method == null)
        hashMap_findKey_method = findMethodNamed(HashMap.class, "getNode");
      Map.Entry<A, B> entry = (Map.Entry) hashMap_findKey_method.invoke(map, hashMap_internalHash(key), key);
      return entry == null ? null : entry.getKey();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String joinNemptiesWithColon(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColon(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public String commaCombine(Object... l) {
    return joinNemptiesWithComma(flattenCollectionsAndArrays(ll(l)));
  }

  static public int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public List<Constructor> constructorsWithNumberOfArguments(Class c, int n) {
    return filter(c.getDeclaredConstructors(), con -> l(con.getParameterTypes()) == n);
  }

  static public int methodApplicabilityScore_onTypes(Method m, Class[] argTypes) {
    return methodApplicabilityScore_onTypes((Executable) m, argTypes);
  }

  static public int methodApplicabilityScore_onTypes(Executable m, Class[] argTypes) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != argTypes.length)
      return Integer.MAX_VALUE;
    int score = 0;
    for (int i = 0; i < types.length; i++) {
      Class a = argTypes[i];
      Class c = types[i];
      if (c == a) {
      } else if (isSubclassOf(a, c))
        ++score;
      else
        return Integer.MAX_VALUE;
    }
    return score;
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public Object[] toObjectArray(Collection c) {
    return toObjectArray((Iterable) c);
  }

  static public Object[] toObjectArray(Iterable c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public <A, B> int lKeys(MultiMap<A, B> mm) {
    return mm == null ? 0 : mm.keysSize();
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && b != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public int inc(AtomicInteger i) {
    return incAtomicInt(i);
  }

  static public int inc(AtomicInteger i, int delta) {
    return incAtomicInt(i, delta);
  }

  static public long inc(AtomicLong l) {
    return incAtomicLong(l);
  }

  static public long inc(AtomicLong l, long b) {
    return l.addAndGet(b);
  }

  static public int inc(IntVar v) {
    synchronized (v) {
      int val = v.get() + 1;
      v.set(val);
      return val;
    }
  }

  static public void readLocally(String progID, String varNames) {
    readLocally2(mc(), progID, varNames);
  }

  static public void readLocally(String varNames) {
    readLocally2(mc(), programID(), varNames);
  }

  static public void readLocally2(Object obj, String varNames) {
    readLocally2(obj, programID(), varNames);
  }

  static public int readLocally_stringLength;

  static public ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

  static public ThreadLocal readLocally2_classFinder = new ThreadLocal();

  static public void readLocally2(Object obj, String progID, String varNames) {
    try {
      boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
      for (String variableName : javaTokC(varNames)) {
        File textFile = new File(programDir(progID), variableName + ".text");
        String value = loadTextFile(textFile);
        if (value != null)
          set(main.class, variableName, value);
        else {
          File structureFile = new File(programDir(progID), variableName + ".structure");
          value = loadTextFile(structureFile);
          if (value == null) {
            File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
            if (!structureGZFile.isFile())
              return;
            InputStream fis = new FileInputStream(structureGZFile);
            try {
              GZIPInputStream gis = newGZIPInputStream(fis);
              InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
              BufferedReader bufferedReader = new BufferedReader(reader);
              Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, readLocally2_classFinder.get());
              readLocally_set(obj, variableName, o);
              return;
            } finally {
              _close(fis);
            }
          }
          readLocally_stringLength = l(value);
          if (nempty(value))
            readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void readLocally_set(Object c, String varName, Object value) {
    Object oldValue = get(c, varName);
    if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
      value = synchroList((List) value);
    }
    set(c, varName, value);
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public int hashMap_internalHash(Object key) {
    int h;
    return (key == null) ? 0 : (h = key.hashCode()) ^ (h >>> 16);
  }

  static public String joinNempties(String sep, Object... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Iterable strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNemptiesWithComma(Object... strings) {
    return joinNempties(", ", strings);
  }

  static public String joinNemptiesWithComma(Iterable strings) {
    return joinNempties(", ", strings);
  }

  static public List flattenCollectionsAndArrays(Iterable a) {
    List l = new ArrayList();
    for (Object x : a) if (x instanceof Collection)
      l.addAll(flattenCollectionsAndArrays((Collection) x));
    else if (x instanceof Object[])
      l.addAll(flattenCollectionsAndArrays(asList((Object[]) x)));
    else
      l.add(x);
    return l;
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    return classForName(name, null);
  }

  static public Class classForName(String name, Object classFinder) {
    if (classForName_cache == null || classFinder != null)
      return classForName_uncached(name, classFinder);
    Class c = classForName_cache.get(name);
    if (c == null)
      classForName_cache.put(name, c = classForName_uncached(name, null));
    return c;
  }

  static public Class classForName_uncached(String name, Object classFinder) {
    try {
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public int incAtomicInt(AtomicInteger i) {
    return i.incrementAndGet();
  }

  static public int incAtomicInt(AtomicInteger i, int delta) {
    return i.addAndGet(delta);
  }

  static public long incAtomicLong(AtomicLong l) {
    return l.incrementAndGet();
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public void set(BitSet bs, int idx) {
    {
      if (bs != null)
        bs.set(idx);
    }
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public Object unstructure(String text, IF1<String, Class> classFinder) {
    return unstructure(text, false, classFinder);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public String mcDollar = actualMCDollar();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public Map<String, String> baseClassMap = new HashMap();

      public HashMap<Class, Constructor> innerClassConstructors = new HashMap();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public X() {
        try {
          Class mc = (Class) (callF(_classFinder, "<main>"));
          if (mc != null)
            mcDollar = mc.getName() + "$";
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }

      public Class findAClass(String fullClassName) {
        try {
          return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
        } catch (Throwable __e) {
          return null;
        }
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        } else
          refID = -1;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (refID >= 0)
              refs.put(refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, unstructure_Receiver out) {
        String t = t();
        String cname = t;
        Class c = classesMap.get(cname);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              warn("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              warn("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            LinkedList l = new LinkedList();
            if (refID >= 0)
              refs.put(refID, l);
            {
              parseList(l, out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(synchroNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(synchroSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(synchroMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(synchroList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            ArrayList l = new ArrayList();
            if (refID >= 0)
              refs.put(refID, l);
            this.parseList(l, out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray") || t.equals("dblarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = mcDollar + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume();
          out.set(parseJava());
          return;
        }
        if (eq(t, "bc")) {
          consume();
          String c1 = tpp();
          String c2 = tpp();
          baseClassMap.put(c1, c2);
          {
            parse_inner(refID, i, out);
            return;
          }
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = mcDollar + t;
        }
        if (c == null && !allDynamic) {
          c = findAClass(fullClassName);
          classesMap.put(className, c);
        }
        if (c == null && !allDynamic) {
          Set<String> seen = new HashSet();
          String parent = className;
          while (true) {
            String baseName = baseClassMap.get(parent);
            if (baseName == null)
              break;
            if (!seen.add(baseName))
              throw fail("Cyclic superclass info: " + baseName);
            c = findAClass(mcDollar + baseName);
            if (c == null)
              print("Base class " + baseName + " of " + parent + " doesn't exist either");
            else if (isAbstract(c))
              print("Can't instantiate abstract base class: " + c);
            else {
              printVars_str("Reverting to base class", "className", className, "baseName", baseName, "c", c);
              classesMap.put(className, c);
              break;
            }
            parent = baseName;
          }
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && startsWith(t(), "this$");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          if (hasOuter)
            try {
              Constructor ctor = innerClassConstructors.get(c);
              if (ctor == null)
                innerClassConstructors.put(c, ctor = nuStubInnerObject_findConstructor(c, classFinder));
              o = ctor.newInstance(new Object[] { null });
            } catch (Exception e) {
              print("Error deserializing " + c + ": " + e);
              o = nuEmptyObject(c);
            }
          else
            o = nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findAClass(mcDollar + "Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID >= 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        HashMap<String, Object> fields = new HashMap();
        Object _o = o;
        DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        Object outer = fields.get("this$0");
        if (outer != null)
          fields.put("this$1", outer);
        else {
          outer = fields.get("this$1");
          if (outer != null)
            fields.put("this$0", outer);
        }
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(unstructure_Receiver out) {
        String _type = tpp();
        int dims;
        if (eq(t(), "S")) {
          _type = "S";
          consume();
        }
        if (eq(t(), "/")) {
          consume();
          dims = parseInt(tpp());
        } else
          dims = 1;
        consume("{");
        List list = new ArrayList();
        String type = _type;
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                if (dims > 1) {
                  Class atype;
                  if (type.equals("intarray"))
                    atype = int.class;
                  else if (type.equals("S"))
                    atype = String.class;
                  else
                    throw todo("multi-dimensional arrays of other types");
                  out.set(list.toArray((Object[]) newMultiDimensionalOuterArray(atype, dims, l(list))));
                } else
                  out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : type.equals("S") ? toStringArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          if (dims > 1) {\r\n    ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix(mcDollar, name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public String joinStrings(String sep, Object... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Iterable strings) {
    StringBuilder buf = new StringBuilder();
    for (Object o : unnull(strings)) {
      String s = strOrNull(o);
      if (nempty(s)) {
        if (nempty(buf))
          buf.append(sep);
        buf.append(s);
      }
    }
    return str(buf);
  }

  static public boolean isSubclass(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, List<A> l) {
    return subList(l, startIndex);
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex > endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public String programID;

  static public String getProgramID() {
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long) {
        f.set(o, ((Long) value).intValue());
        return;
      }
      if (type == boolean.class && value instanceof String) {
        f.set(o, isTrueOrYes(((String) value)));
        return;
      }
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      throw e;
    }
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public String actualMCDollar() {
    return actualMC().getName() + "$";
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public double parseDouble(String s) {
    return empty(s) ? 0.0 : Double.parseDouble(s);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public <A> List<A> synchroLinkedList() {
    return synchroList(new LinkedList<A>());
  }

  static public <A, B> NavigableMap<A, B> synchroNavigableMap(NavigableMap<A, B> map) {
    return Collections.synchronizedNavigableMap(map);
  }

  static public <A, B> SortedMap<A, B> synchroSortedMap(SortedMap<A, B> map) {
    return Collections.synchronizedSortedMap(map);
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public void printVars_str(Object... params) {
    print(renderVars_str(params));
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c) {
    return nuStubInnerObject_findConstructor(c, null);
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      makeAccessible(m);
      return m;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null || o == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        Field f = fieldMap.get(field);
        if (f != null)
          smartSet(f, o, val);
        else {
          dynamicObject_setRawFieldValue(o, intern(field), val);
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    dynamicObject_setRawFieldValue(o, field, value);
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public Object newMultiDimensionalOuterArray(Class elementType, int dimensions, int length) {
    int[] dims = new int[dimensions];
    dims[0] = length;
    return Array.newInstance(elementType, dims);
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public ThreadLocal<Boolean> DynamicObject_loading = or((ThreadLocal) get(getClass("x30_pkg.x30_util"), "DynamicObject_loading"), new ThreadLocal());

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a) {
    return newObjectArrayOfSameType(a, a.length);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      ClassLoader cl = (o instanceof Class ? (Class) o : o.getClass()).getClassLoader();
      if (cl == null)
        return null;
      String name = mainClassNameForClassLoader(cl);
      return loadClassFromClassLoader_orNull(cl, name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public boolean isTrueOrYes(Object o) {
    return isTrueOpt(o) || o instanceof String && (eqicOneOf(((String) o), "1", "t", "true") || isYes(((String) o)));
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        Class c = get2(name);
        return c;
      }

      public Class get2(String name) {
        if (eq(name, "<main>"))
          return mc();
        {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
        }
        if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
          for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
            String newName = pkg + afterDollar(name);
            {
              Class c = findClass_fullName(newName);
              if (c != null)
                return c;
            }
          }
        return null;
      }
    };
  }

  static public Class actualMC() {
    return or((Class) realMC(), mc());
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public String dropSuffix(String suffix, String s) {
    return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public Object safeUnstructure(File f) {
    return safeUnstructureGZFile(f);
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(strOrNull(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      return classForName(name, classFinder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class getOuterClass(Object o) {
    return getOuterClass(o, null);
  }

  static public Class getOuterClass(Object o, Object classFinder) {
    return getOuterClass(_getClass(o), classFinder);
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    return (HashMap) getOpt_getFieldMap(o);
  }

  static public void dynamicObject_setRawFieldValue(DynamicObject o, Object key, Object value) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = syncMapPut2_createLinkedHashMap((LinkedHashMap) o.fieldValues, key, value);
    }
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject) {
        setDyn(((DynamicObject) o), field, value);
        return;
      }
      if (o instanceof IMeta)
        setDyn(((IMeta) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().startsWith("this$"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !regionMatches(s, j, "*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j < l && !regionMatches(s, j, "]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !regionMatches(s, j, "]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public String mainClassNameForClassLoader(ClassLoader cl) {
    return or((String) callOpt(cl, "mainClassName"), "main");
  }

  static public Class loadClassFromClassLoader_orNull(ClassLoader cl, String name) {
    try {
      return cl == null ? null : cl.loadClass(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public boolean isTrueOpt(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    return false;
  }

  static public boolean isTrueOpt(String field, Object o) {
    return isTrueOpt(getOpt(field, o));
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public List<String> isYes_yesses = litlist("y", "yes", "yeah", "y", "yup", "yo", "corect", "sure", "ok", "afirmative");

  static public boolean isYes(String s) {
    return isYes_yesses.contains(collapseWord(toLowerCase(firstWord2(s))));
  }

  static public Object get2(Object o, String field1, String field2) {
    return get(get(o, field1), field2);
  }

  static public boolean startsWithAny(String a, Collection<String> b) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, String... b) {
    if (b != null)
      for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
        return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b, Matches m) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix, m))
      return true;
    return false;
  }

  static public String mcDollar() {
    return mcName() + "$";
  }

  static public String afterDollar(String s) {
    return substring(s, smartIndexOf(s, '$') + 1);
  }

  static public Object realMC() {
    return getThreadLocal(realMC_tl());
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public Object safeUnstructureGZFile(File f) {
    try {
      if (!fileExists(f))
        return null;
      BufferedReader reader = utf8BufferedReader(gzInputStream(f));
      return unstructure_tok(javaTokC_noMLS_onReader(reader), true, null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    if (o instanceof Boolean)
      return boolToInt((Boolean) o);
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    setDynObjectValue(o, key, value);
    return o;
  }

  static public void setDyn(IMeta o, String key, Object value) {
    metaMapPut(o, key, value);
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Class<A> type, Iterable<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public Object callOpt(Object o, String method, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
  }

  static public boolean regionMatches(String a, int offsetA, String b) {
    return regionMatches(a, offsetA, b, 0, l(b));
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public String collapseWord(String s) {
    if (s == null)
      return "";
    StringBuilder buf = new StringBuilder();
    for (int i = 0; i < l(s); i++) if (i == 0 || !charactersEqualIC(s.charAt(i), s.charAt(i - 1)))
      buf.append(s.charAt(i));
    return buf.toString();
  }

  static public List<String> toLowerCase(List<String> strings) {
    List<String> x = new ArrayList();
    for (String s : strings) x.add(s.toLowerCase());
    return x;
  }

  static public String[] toLowerCase(String[] strings) {
    String[] x = new String[l(strings)];
    for (int i = 0; i < l(strings); i++) x[i] = strings[i].toLowerCase();
    return x;
  }

  static public String toLowerCase(String s) {
    return s == null ? "" : s.toLowerCase();
  }

  static public String firstWord2(String s) {
    s = xltrim(s);
    if (empty(s))
      return "";
    if (isLetterOrDigit(first(s)))
      return takeCharsWhile(__32 -> isLetterOrDigit(__32), s);
    else
      return "" + first(s);
  }

  static public String mcName() {
    return mc().getName();
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public ThreadLocal realMC_tl_tl = new ThreadLocal();

  static public ThreadLocal realMC_tl() {
    return realMC_tl_tl;
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public BufferedReader utf8BufferedReader(InputStream in) {
    return utf8bufferedReader(in);
  }

  static public BufferedReader utf8BufferedReader(File f) {
    return utf8bufferedReader(f);
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public void metaMapPut(IMeta o, Object key, Object value) {
    {
      if (o != null)
        o.metaPut(key, value);
    }
  }

  static public void metaMapPut(Object o, Object key, Object value) {
    var meta = initIMeta(o);
    {
      if (meta != null)
        meta.metaPut(key, value);
    }
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public boolean charactersEqualIC(char c1, char c2) {
    if (c1 == c2)
      return true;
    char u1 = Character.toUpperCase(c1);
    char u2 = Character.toUpperCase(c2);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public String xltrim(String s) {
    int i = 0, n = l(s);
    while (i < n && contains(" \t\r\n", s.charAt(i))) ++i;
    return substr(s, i);
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public String takeCharsWhile(String s, Object pred) {
    int i = 0;
    while (i < l(s) && isTrue(callF(pred, s.charAt(i)))) ++i;
    return substring(s, 0, i);
  }

  static public String takeCharsWhile(IF1<Character, Boolean> f, String s) {
    return takeCharsWhile(s, f);
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return in == null ? null : bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public IMeta initIMeta(Object o) {
    if (o == null)
      return null;
    if (o instanceof IMeta)
      return ((IMeta) o);
    if (o instanceof JComponent)
      return initMetaOfJComponent((JComponent) o);
    if (o instanceof BufferedImage)
      return optCast(IMeta.class, ((BufferedImage) o).getProperty("meta"));
    return null;
  }

  static public Class<?> hotwire(String src) {
    return hotwire(src, __1 -> mainClassNameForClassLoader(__1));
  }

  static public Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Iterable it, Object a) {
    if (it != null)
      for (Object o : it) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public boolean contains(Rect r, Pt p) {
    return rectContains(r, p);
  }

  static public String substr(String s, int x) {
    return substring(s, x);
  }

  static public String substr(String s, int x, int y) {
    return substring(s, x, y);
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    if (r == null)
      return null;
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public IMeta initMetaOfJComponent(JComponent c) {
    if (c == null)
      return null;
    IMeta meta = (IMeta) (c.getClientProperty(IMeta.class));
    if (meta == null)
      c.putClientProperty(IMeta.class, meta = new Meta());
    return meta;
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public boolean _inCore() {
    return false;
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, Rectangle b) {
    return rectContains(a, toRect(b));
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public boolean rectContains(Rect a, Pt p) {
    return a != null && p != null && a.contains(p);
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      {
        if (f != null)
          f.get(a);
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public Object pcallF(Runnable r) {
    try {
      {
        if (r != null)
          r.run();
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> A pcallF(IF0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(IF1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble((String) o);
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public class Meta implements IMeta {

    volatile public Object meta;

    public void _setMeta(Object meta) {
      this.meta = meta;
    }

    public Object _getMeta() {
      return meta;
    }
  }

  final static public class Rect implements IFieldsToList {

    static final public String _fieldOrder = "x y w h";

    public int x;

    public int y;

    public int w;

    public int h;

    public Rect() {
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Rect))
        return false;
      Rect __1 = (Rect) o;
      return x == __1.x && y == __1.y && w == __1.w && h == __1.h;
    }

    public int hashCode() {
      int h = 2543108;
      h = boostHashCombine(h, _hashCode(x));
      h = boostHashCombine(h, _hashCode(y));
      h = boostHashCombine(h, _hashCode(w));
      h = boostHashCombine(h, _hashCode(h));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { x, y, w, h };
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(Pt p, int w, int h) {
      this.h = h;
      this.w = w;
      x = p.x;
      y = p.y;
    }

    public Rect(Rect r) {
      x = r.x;
      y = r.y;
      w = r.w;
      h = r.h;
    }

    public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    public int x1() {
      return x;
    }

    public int y1() {
      return y;
    }

    public int x2() {
      return x + w;
    }

    public int y2() {
      return y + h;
    }

    public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    public boolean contains(Rectangle r) {
      return rectContains(this, r);
    }

    public boolean empty() {
      return w <= 0 || h <= 0;
    }

    public int getWidth() {
      return w;
    }

    public int getHeight() {
      return h;
    }
  }

  static public interface Producer<A> {

    public A next();
  }

  static public class Pt implements Comparable<Pt>, IDoublePt {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return o instanceof Pt && x == ((Pt) o).x && y == ((Pt) o).y;
    }

    public int hashCode() {
      return boostHashCombine(x, y);
    }

    public int compareTo(Pt p) {
      if (y != p.y)
        return cmp(y, p.y);
      return cmp(x, p.x);
    }

    public String toString() {
      return x + ", " + y;
    }

    public double length() {
      return sqrt(x * x + y * y);
    }

    public Pt minus(Pt p) {
      return ptMinus(this, p);
    }

    public double x_double() {
      return x;
    }

    public double y_double() {
      return y;
    }
  }

  static public class Lowest<A> {

    public A best;

    public double score;

    transient public Object onChange;

    synchronized public boolean isNewBest(double score) {
      return best == null || score < this.score;
    }

    synchronized public double bestScore() {
      return best == null ? Double.NaN : score;
    }

    public double score() {
      return bestScore();
    }

    synchronized public float floatScore() {
      return best == null ? Float.NaN : (float) score;
    }

    synchronized public float floatScoreOr(float defaultValue) {
      return best == null ? defaultValue : (float) score;
    }

    public boolean put(A a, double score) {
      boolean change = false;
      synchronized (this) {
        if (a != null && isNewBest(score)) {
          best = a;
          this.score = score;
          change = true;
        }
      }
      if (change)
        pcallF(onChange);
      return change;
    }

    synchronized public void clear() {
      best = null;
      score = 0;
    }

    synchronized public A get() {
      return best;
    }

    synchronized public boolean has() {
      return best != null;
    }

    synchronized public Pair<A, Double> pair() {
      return best == null ? null : new Pair(best, bestScore());
    }

    public String toString() {
      return "Score " + formatDouble_significant2(score, 4) + ": " + best;
    }
  }

  static public class Var<A> implements IVar<A>, ISetter<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public void clear() {
      set(null);
    }

    public String toString() {
      return str(this.get());
    }
  }

  static public interface IMeta {

    public void _setMeta(Object meta);

    public Object _getMeta();

    default public IAutoCloseableF0 _tempMetaMutex() {
      return new IAutoCloseableF0() {

        public Object get() {
          return IMeta.this;
        }

        public void close() {
        }
      };
    }

    default public Object getMeta(Object obj, Object key) {
      return metaGet(obj, key);
    }

    default public Object metaGet(Object obj, Object key) {
      return metaMapGet(obj, key);
    }

    default public Object metaGet(String key, Object obj) {
      return metaMapGet(obj, key);
    }

    default public Object getMeta(Object key) {
      return metaGet(key);
    }

    default public Object metaGet(Object key) {
      if (key == null)
        return null;
      Object meta = _getMeta();
      if (meta instanceof Map)
        return ((Map) meta).get(key);
      return null;
    }

    default public void metaSet(IMeta obj, Object key, Object value) {
      metaPut(obj, key, value);
    }

    default public void metaPut(IMeta obj, Object key, Object value) {
      metaMapPut(obj, key, value);
    }

    default public void metaSet(Object key, Object value) {
      metaPut(key, value);
    }

    default public void metaPut(Object key, Object value) {
      if (key == null)
        return;
      Map map = convertObjectMetaToMap(this);
      syncMapPutOrRemove(map, key, value);
    }
  }

  static public interface IVar<A> extends IF0<A> {

    public void set(A a);

    public A get();

    default public boolean has() {
      return get() != null;
    }

    default public void clear() {
      set(null);
    }
  }

  static public class IntVar {

    public int a;

    public synchronized void set(int v) {
      if (v != a) {
        a = v;
        notifyAll();
      }
    }

    public synchronized int get() {
      return a;
    }

    synchronized public int waitForValue(int x) {
      try {
        while (a != x) wait();
        return a;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public interface ISetter<A> {

    public void set(A a);
  }

  static public interface IAutoCloseableF0<A> extends IF0<A>, AutoCloseable {
  }

  public interface IDoublePt {

    public double x_double();

    public double y_double();
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  static public double sqrt(double x) {
    return Math.sqrt(x);
  }

  static public <A> List<A> minus(Collection<A> a, Object... b) {
    Set set = asSet(b);
    List l = new ArrayList();
    for (Object s : unnull(a)) if (!set.contains(s))
      l.add(s);
    return l;
  }

  static public BigInteger minus(BigInteger a, BigInteger b) {
    return a.subtract(b);
  }

  static public Complex minus(Complex c) {
    return c == null ? null : complex(-c.re(), -c.im());
  }

  static public Pt ptMinus(Pt a, Pt b) {
    if (b == null)
      return a;
    return new Pt(a.x - b.x, a.y - b.y);
  }

  static public String formatDouble_significant2(double d, int digits) {
    try {
      digits -= max(0, Math.floor(Math.log10(abs(d)) + 1));
      return formatDouble(d, digits);
    } catch (Throwable _e) {
      print("Had number: " + d + ", digits: " + digits);
      throw rethrow(_e);
    }
  }

  static public Object metaGet(IMeta o, Object key) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(Object o, Object key) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(String key, IMeta o) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(String key, Object o) {
    return metaMapGet(o, key);
  }

  static public Object metaMapGet(IMeta o, Object key) {
    return o == null ? null : o.metaGet(key);
  }

  static public Object metaMapGet(Object o, Object key) {
    return metaMapGet(toIMeta(o), key);
  }

  static public void metaPut(IMeta o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public void metaPut(Object o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public Map convertObjectMetaToMap(IMeta o) {
    return convertObjectMetaToMap(o, () -> makeObjectMetaMap());
  }

  static public Map convertObjectMetaToMap(IMeta o, IF0<Map> createEmptyMap) {
    if (o == null)
      return null;
    Object meta = o._getMeta();
    if (meta instanceof Map)
      return ((Map) meta);
    var mutex = tempMetaMutex(o);
    try {
      var actualMutex = mutex.get();
      synchronized (actualMutex) {
        meta = o._getMeta();
        if (meta instanceof Map)
          return ((Map) meta);
        Map map = createEmptyMap.get();
        if (meta != null)
          map.put("previousMeta", meta);
        o._setMeta(map);
        return map;
      }
    } finally {
      _close(mutex);
    }
  }

  static public <A, B> void syncMapPutOrRemove(Map<A, B> map, A key, B value) {
    syncMapPut2(map, key, value);
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public Complex complex(double re, double im) {
    return new Complex(re, im);
  }

  static public Complex complex(double re) {
    return new Complex(re, 0.0);
  }

  static public Complex complex(double[] reIm) {
    if (empty(reIm))
      return null;
    if (l(reIm) != 2)
      throw fail("Need 2 doubles to make complex number");
    return complex(reIm[0], reIm[1]);
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public double abs(Complex c) {
    return c.abs();
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String formatDouble(double d) {
    return str(d);
  }

  static public IMeta toIMeta(Object o) {
    if (o == null)
      return null;
    if (o instanceof IMeta)
      return ((IMeta) o);
    if (o instanceof JComponent)
      return initMetaOfJComponent((JComponent) o);
    if (o instanceof BufferedImage)
      return optCast(IMeta.class, ((BufferedImage) o).getProperty("meta"));
    return null;
  }

  static public Map makeObjectMetaMap() {
    return new CompactHashMap();
  }

  static public IAutoCloseableF0 tempMetaMutex(IMeta o) {
    return o == null ? null : o._tempMetaMutex();
  }

  static public <A, B> void syncMapPut2(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      synchronized (collectionMutex(map)) {
        if (value != null)
          map.put(key, value);
        else
          map.remove(key);
      }
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public String decimalFormatEnglish(String format, double d) {
    return decimalFormatEnglish(format).format(d);
  }

  static public java.text.DecimalFormat decimalFormatEnglish(String format) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public class CompactHashMap<K, V> extends CompactAbstractMap<K, V> {

    final static public int INITIAL_SIZE = 3;

    final static public double LOAD_FACTOR = 0.6;

    final static public Object nullObject = new Object();

    final static public Object deletedObject = new Object();

    public int elements;

    public int freecells;

    public Object[] table;

    public CompactHashMap() {
      this(INITIAL_SIZE);
    }

    public CompactHashMap(int size) {
      table = new Object[(size == 0 ? 1 : size) * 2];
      elements = 0;
      freecells = tableSize();
    }

    public CompactHashMap(Map<K, V> map) {
      this(0);
      if (map != null)
        putAll(map);
    }

    public synchronized int size() {
      return elements;
    }

    public synchronized boolean isEmpty() {
      return elements == 0;
    }

    public synchronized void clear() {
      elements = 0;
      for (int ix = 0; ix < tableSize(); ix++) {
        key(ix, null);
        value(ix, null);
      }
      freecells = tableSize();
    }

    public synchronized boolean containsKey(Object k) {
      return key(findKeyIndex(k)) != null;
    }

    public synchronized boolean containsValue(Object v) {
      if (v == null)
        v = (V) nullObject;
      for (int ix = 0; ix < tableSize(); ix++) if (value(ix) != null && value(ix).equals(v))
        return true;
      return false;
    }

    public synchronized Set<Entry<K, V>> entrySet() {
      throw new UnsupportedOperationException();
    }

    public synchronized V remove(Object k) {
      int index = findKeyIndex(k);
      if (key(index) != null) {
        V v = value(index);
        key(index, deletedObject);
        value(index, deletedObject);
        elements--;
        return v;
      } else
        return null;
    }

    public synchronized V put(K k, V v) {
      if (k == null)
        k = (K) nullObject;
      int hash = k.hashCode();
      int index = (hash & 0x7FFFFFFF) % tableSize();
      int offset = 1;
      int deletedix = -1;
      while (key(index) != null && !(key(index).hashCode() == hash && key(index).equals(k))) {
        if (key(index) == deletedObject)
          deletedix = index;
        index = ((index + offset) & 0x7FFFFFFF) % tableSize();
        offset = offset * 2 + 1;
        if (offset == -1)
          offset = 2;
      }
      if (key(index) == null) {
        if (deletedix != -1)
          index = deletedix;
        else
          freecells--;
        elements++;
        key(index, k);
        value(index, v);
        if (1 - (freecells / (double) tableSize()) > LOAD_FACTOR)
          rehash(tableSize() * 2 + 1);
        return null;
      } else {
        V oldv = value(index);
        value(index, v);
        return oldv;
      }
    }

    public void rehash(int newCapacity) {
      int oldCapacity = tableSize();
      Object[] newTable = new Object[newCapacity * 2];
      for (int ix = 0; ix < oldCapacity; ix++) {
        Object k = key(ix);
        if (k == null || k == deletedObject)
          continue;
        int hash = k.hashCode();
        int index = (hash & 0x7FFFFFFF) % newCapacity;
        int offset = 1;
        while (newTable[index * 2] != null) {
          index = ((index + offset) & 0x7FFFFFFF) % newCapacity;
          offset = offset * 2 + 1;
          if (offset == -1)
            offset = 2;
        }
        newTable[index * 2] = k;
        newTable[index * 2 + 1] = value(ix);
      }
      table = newTable;
      freecells = tableSize() - elements;
    }

    public synchronized V get(Object k) {
      return value(findKeyIndex(k));
    }

    public synchronized Collection<V> values() {
      return new ValueCollection();
    }

    public synchronized Set<K> keySet() {
      return new KeySet();
    }

    final public int findKeyIndex(Object k) {
      if (k == null)
        k = nullObject;
      int hash = k.hashCode();
      int index = (hash & 0x7FFFFFFF) % tableSize();
      int offset = 1;
      while (key(index) != null && !(key(index).hashCode() == hash && key(index).equals(k))) {
        index = ((index + offset) & 0x7FFFFFFF) % tableSize();
        offset = offset * 2 + 1;
        if (offset == -1)
          offset = 2;
      }
      return index;
    }

    public class KeySet<K> extends AbstractSet<K> {

      public synchronized int size() {
        return elements;
      }

      public synchronized boolean contains(Object k) {
        return containsKey(k);
      }

      public synchronized Iterator<K> iterator() {
        return new KeyIterator();
      }
    }

    public class KeyIterator<K> implements Iterator<K> {

      public int ix;

      public KeyIterator() {
        for (; ix < tableSize(); ix++) if (value(ix) != null && key(ix) != deletedObject)
          break;
      }

      public synchronized boolean hasNext() {
        return ix < tableSize();
      }

      public synchronized void remove() {
        throw new UnsupportedOperationException("Collection is read-only");
      }

      public synchronized K next() {
        if (ix >= tableSize())
          throw new NoSuchElementException();
        K key = (K) key(ix++);
        for (; ix < tableSize(); ix++) if (key(ix) != null && key(ix) != deletedObject)
          break;
        return key;
      }
    }

    public class ValueCollection<V> extends AbstractCollection<V> {

      public synchronized int size() {
        return elements;
      }

      public synchronized Iterator<V> iterator() {
        return new ValueIterator();
      }

      public synchronized boolean contains(Object v) {
        return containsValue(v);
      }
    }

    public class ValueIterator<V> implements Iterator<V> {

      public int ix;

      public ValueIterator() {
        for (; ix < table.length / 2; ix++) if (value(ix) != null && value(ix) != deletedObject)
          break;
      }

      public synchronized boolean hasNext() {
        return ix < tableSize();
      }

      public synchronized void remove() {
        throw new UnsupportedOperationException("Collection is read-only");
      }

      public synchronized V next() {
        if (ix >= tableSize())
          throw new NoSuchElementException();
        V value = (V) value(ix++);
        for (; ix < tableSize(); ix++) if (value(ix) != null && value(ix) != deletedObject)
          break;
        return value;
      }
    }

    public K key(int i) {
      return (K) table[i * 2];
    }

    public void key(int i, Object key) {
      table[i * 2] = key;
    }

    public V value(int i) {
      return (V) table[i * 2 + 1];
    }

    public void value(int i, Object value) {
      table[i * 2 + 1] = value;
    }

    public int tableSize() {
      return table.length / 2;
    }
  }

  static public class Complex implements IFieldsToList {

    static final public String _fieldOrder = "re im";

    public double re;

    public double im;

    public Complex() {
    }

    public Complex(double re, double im) {
      this.im = im;
      this.re = re;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Complex))
        return false;
      Complex __1 = (Complex) o;
      return re == __1.re && im == __1.im;
    }

    public int hashCode() {
      int h = -1679819632;
      h = boostHashCombine(h, _hashCode(re));
      h = boostHashCombine(h, _hashCode(im));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { re, im };
    }

    public double abs() {
      return sqrt(re * re + im * im);
    }

    public double re() {
      return re;
    }

    public double im() {
      return im;
    }

    final public double angle() {
      return phase();
    }

    public double phase() {
      return Math.atan2(im, re);
    }

    public double fracAngle() {
      return fracNonNeg(angle() / twoPi());
    }

    public String toString() {
      if (im != 0)
        return re == 0 ? im + "i" : re + plusPrefixUnlessMinus(str(im)) + "i";
      else
        return str(re);
    }
  }

  abstract static public class CompactAbstractMap<K, V> implements Map<K, V> {

    public int size() {
      return entrySet().size();
    }

    public boolean isEmpty() {
      return size() == 0;
    }

    public boolean containsValue(Object value) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (value == null) {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (e.getValue() == null)
            return true;
        }
      } else {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (value.equals(e.getValue()))
            return true;
        }
      }
      return false;
    }

    public boolean containsKey(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (key == null) {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (e.getKey() == null)
            return true;
        }
      } else {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (key.equals(e.getKey()))
            return true;
        }
      }
      return false;
    }

    public V get(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (key == null) {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (e.getKey() == null)
            return e.getValue();
        }
      } else {
        while (i.hasNext()) {
          Entry<K, V> e = i.next();
          if (key.equals(e.getKey()))
            return e.getValue();
        }
      }
      return null;
    }

    public V put(K key, V value) {
      throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      Entry<K, V> correctEntry = null;
      if (key == null) {
        while (correctEntry == null && i.hasNext()) {
          Entry<K, V> e = i.next();
          if (e.getKey() == null)
            correctEntry = e;
        }
      } else {
        while (correctEntry == null && i.hasNext()) {
          Entry<K, V> e = i.next();
          if (key.equals(e.getKey()))
            correctEntry = e;
        }
      }
      V oldValue = null;
      if (correctEntry != null) {
        oldValue = correctEntry.getValue();
        i.remove();
      }
      return oldValue;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
      for (Entry<? extends K, ? extends V> e : m.entrySet()) put(e.getKey(), e.getValue());
    }

    public void clear() {
      entrySet().clear();
    }

    public Set<K> keySet() {
      return new AbstractSet<K>() {

        public Iterator<K> iterator() {
          return new Iterator<K>() {

            public Iterator<Entry<K, V>> i = entrySet().iterator();

            public boolean hasNext() {
              return i.hasNext();
            }

            public K next() {
              return i.next().getKey();
            }

            public void remove() {
              i.remove();
            }
          };
        }

        public int size() {
          return CompactAbstractMap.this.size();
        }

        public boolean isEmpty() {
          return CompactAbstractMap.this.isEmpty();
        }

        public void clear() {
          CompactAbstractMap.this.clear();
        }

        public boolean contains(Object k) {
          return CompactAbstractMap.this.containsKey(k);
        }
      };
    }

    public Collection<V> values() {
      return new AbstractCollection<V>() {

        public Iterator<V> iterator() {
          return new Iterator<V>() {

            public Iterator<Entry<K, V>> i = entrySet().iterator();

            public boolean hasNext() {
              return i.hasNext();
            }

            public V next() {
              return i.next().getValue();
            }

            public void remove() {
              i.remove();
            }
          };
        }

        public int size() {
          return CompactAbstractMap.this.size();
        }

        public boolean isEmpty() {
          return CompactAbstractMap.this.isEmpty();
        }

        public void clear() {
          CompactAbstractMap.this.clear();
        }

        public boolean contains(Object v) {
          return CompactAbstractMap.this.containsValue(v);
        }
      };
    }

    public abstract Set<Entry<K, V>> entrySet();

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Map))
        return false;
      Map<?, ?> m = (Map<?, ?>) o;
      if (m.size() != size())
        return false;
      try {
        for (Entry<K, V> e : entrySet()) {
          K key = e.getKey();
          V value = e.getValue();
          if (value == null) {
            if (!(m.get(key) == null && m.containsKey(key)))
              return false;
          } else {
            if (!value.equals(m.get(key)))
              return false;
          }
        }
      } catch (ClassCastException unused) {
        return false;
      } catch (NullPointerException unused) {
        return false;
      }
      return true;
    }

    public int hashCode() {
      int h = 0;
      for (Entry<K, V> entry : entrySet()) h += entry.hashCode();
      return h;
    }

    public String toString() {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (!i.hasNext())
        return "{}";
      StringBuilder sb = new StringBuilder();
      sb.append('{');
      for (; ; ) {
        Entry<K, V> e = i.next();
        K key = e.getKey();
        V value = e.getValue();
        sb.append(key == this ? "(this Map)" : key);
        sb.append('=');
        sb.append(value == this ? "(this Map)" : value);
        if (!i.hasNext())
          return sb.append('}').toString();
        sb.append(',').append(' ');
      }
    }

    public Object clone() throws CloneNotSupportedException {
      CompactAbstractMap<?, ?> result = (CompactAbstractMap<?, ?>) super.clone();
      return result;
    }

    public static class SimpleEntry<K, V> implements Entry<K, V>, java.io.Serializable {

      @java.io.Serial
      static final public long serialVersionUID = -8499721149061103585L;

      @SuppressWarnings("serial")
      final public K key;

      @SuppressWarnings("serial")
      public V value;

      public SimpleEntry(K key, V value) {
        this.key = key;
        this.value = value;
      }

      public SimpleEntry(Entry<? extends K, ? extends V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
      }

      public K getKey() {
        return key;
      }

      public V getValue() {
        return value;
      }

      public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
      }

      public boolean equals(Object o) {
        if (!(o instanceof Map.Entry))
          return false;
        Entry<?, ?> e = (Entry<?, ?>) o;
        return eq(key, e.getKey()) && eq(value, e.getValue());
      }

      public int hashCode() {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
      }

      public String toString() {
        return key + "=" + value;
      }
    }

    public static class SimpleImmutableEntry<K, V> implements Entry<K, V>, java.io.Serializable {

      @java.io.Serial
      static final public long serialVersionUID = 7138329143949025153L;

      @SuppressWarnings("serial")
      final public K key;

      @SuppressWarnings("serial")
      final public V value;

      public SimpleImmutableEntry(K key, V value) {
        this.key = key;
        this.value = value;
      }

      public SimpleImmutableEntry(Entry<? extends K, ? extends V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
      }

      public K getKey() {
        return key;
      }

      public V getValue() {
        return value;
      }

      public V setValue(V value) {
        throw new UnsupportedOperationException();
      }

      public boolean equals(Object o) {
        if (!(o instanceof Map.Entry))
          return false;
        Entry<?, ?> e = (Entry<?, ?>) o;
        return eq(key, e.getKey()) && eq(value, e.getValue());
      }

      public int hashCode() {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
      }

      public String toString() {
        return key + "=" + value;
      }
    }
  }

  static public <A> Value<A> value(A a) {
    return new Value<A>(a);
  }

  static public <A, B> boolean containsKey(Map<A, B> map, A key) {
    return map != null && map.containsKey(key);
  }

  static public double fracNonNeg(double d) {
    return frac_nonNeg(d);
  }

  static public double twoPi() {
    return Math.PI * 2;
  }

  static public String plusPrefixUnlessMinus(String s) {
    return startsWith(s, "-") ? s : "+" + s;
  }

  static public double frac_nonNeg(double d) {
    return mod(d, 1);
  }

  static public int mod(int n, int m) {
    return (n % m + m) % m;
  }

  static public long mod(long n, long m) {
    return (n % m + m) % m;
  }

  static public BigInteger mod(BigInteger n, int m) {
    return n.mod(bigint(m));
  }

  static public double mod(double n, double m) {
    return (n % m + m) % m;
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public class Value<A> implements IF0<A>, IFieldsToList {

    public A value;

    public Value() {
    }

    public Value(A value) {
      this.value = value;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Value))
        return false;
      Value __1 = (Value) o;
      return eq(value, __1.value);
    }

    public int hashCode() {
      int h = 82420049;
      h = boostHashCombine(h, _hashCode(value));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { value };
    }

    public A get() {
      return value;
    }

    public String toString() {
      return str(get());
    }
  }
}

