import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;


class main {

public static void main(final String[] args) throws Exception {
  var screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
  System.out.println("Detected " + screens.length + " screen(s)");
  for (int iScreen = 0; iScreen < screens.length; iScreen++) {
    var screen = screens[iScreen].getDefaultConfiguration().getBounds();
    
    // make a grid of windows covering each screen
    
    int cols = 12, rows = 8;
    for (Rectangle r : gridOfRectangles(screen, cols, rows)) {
      JWindow window = new JWindow();
      window.setBounds(r);
        
      // faint (mostly translucent) blue background
      window.setBackground(new Color(0, 0, 255, 64));
      
      window.setAlwaysOnTop(true);
      //var label = new JLabel("Screen " + (iScreen+1) + " of " + screens.length);
      //label.setHorizontalAlignment(JLabel.CENTER);
      //window.add(label);
      disposeWindowOnClick(window);
      window.setVisible(true);
    }
  }
    
  System.out.println("Will exit in 10");
  Thread.sleep(10000);
  System.exit(0);
}
static List<Rectangle> gridOfRectangles(Rectangle r, int cols, int rows) {
  List<Rectangle> l = new ArrayList();
  for (int row = 0; row < rows; row++) {
    int y1 = r.y+(int) Math.round(r.height*(double) row/rows);
    int y2 = r.y+(int) Math.round(r.height*(double) (row+1)/rows);
    for (int col = 0; col < cols; col++) {
      int x1 = r.x+(int) Math.round(r.width*(double) col/cols);
      int x2 = r.x+(int) Math.round(r.width*(double) (col+1)/cols);
      l.add(new Rectangle(x1, y1, x2-x1, y2-y1));
    }
  }
  return l;
}


// Window must be made visible before calling this.
static void disposeWindowOnClick(final Window window) {
  AWTEventListener l = new AWTEventListener() {
    public void eventDispatched(AWTEvent evt) {
      if (!window.isVisible()) {
        //print("disposeWindowOnClick: Forgetting listener");
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        return;
      }
        
      if (!(evt instanceof MouseEvent)) return;
      Object source = evt.getSource();
      if (source == window && evt.getID() == MouseEvent.MOUSE_PRESSED) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        window.dispose();
      }
    }
  };
  Toolkit.getDefaultToolkit().addAWTEventListener(l, AWTEvent.MOUSE_EVENT_MASK);
}



}
class m1034016{}