//FILENAME: loadableUtils/utils.java
package loadableUtils;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;
import java.time.Duration;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.Const;
import org.apache.bcel.generic.*;
import java.lang.reflect.Type;
import org.ejml.data.*;
import org.ejml.dense.row.*;
import org.ejml.dense.row.decomposition.eig.*;
import me.saharnooby.qoi.plugin.*;
import javax.swing.border.TitledBorder;
import java.text.*;
import javax.swing.border.*;
import javax.swing.Timer;
import java.util.TimeZone;
import java.util.jar.*;
import java.awt.image.DataBufferByte;
import java.awt.geom.*;
import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.nio.file.Path;
import javax.swing.undo.UndoManager;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.*;
import java.awt.geom.Line2D;
import com.github.sarxos.webcam.*;
import org.fife.ui.rsyntaxtextarea.*;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.dnd.*;
import javax.swing.border.Border;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.*;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.PMVMatrix;
import javax.swing.plaf.basic.BasicSliderUI;
import java.awt.geom.Ellipse2D;
import java.awt.datatransfer.UnsupportedFlavorException;
import org.fife.ui.rsyntaxtextarea.TokenMakerBase;
import org.fife.ui.autocomplete.*;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.SizeGripIcon;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import net.lingala.zip4j.model.*;
import net.lingala.zip4j.io.outputstream.*;
import net.lingala.zip4j.model.enums.*;
import net.lingala.zip4j.headers.*;
import net.lingala.zip4j.util.*;
import java.util.zip.ZipOutputStream;
import java.nio.file.*;
import static java.nio.file.StandardWatchEventKinds.*;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import java.util.*;
import java.io.*;
import java.net.*;
import java.nio.channels.FileChannel;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.*;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.bytedeco.javacpp.*;
import static org.bytedeco.javacpp.avcodec.*;
import static org.bytedeco.javacpp.avformat.*;
import static org.bytedeco.javacpp.avutil.*;
import org.bytedeco.javacpp.presets.avutil;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.nio.charset.*;
import java.nio.*;

public class utils {

  static public String utilsSnippetID() {
    return "#1033861";
  }

  static public interface Derefable {

    public Concept get();
  }

  static public class DynamicObject {

    public String className;

    public LinkedHashMap fieldValues;

    public DynamicObject() {
    }

    public DynamicObject(String className) {
      this.className = className;
    }

    public Map<String, Object> _map() {
      return fieldValues;
    }

    public String toString() {
      return getClass() == DynamicObject.class ? "dyn " + className : super.toString();
    }
  }

  static public File nohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs);
  }

  static public File nohupJavax(String javaxargs, String vmArgs) {
    return directNohupJavax(javaxargs, vmArgs);
  }

  static public interface DynamicMethods {

    abstract public Object _dynCall(String methodName, Object[] args);
  }

  static public class BetterLabel extends JLabel {

    public boolean autoToolTip = true;

    public BetterLabel() {
      final WeakReference<BetterLabel> me = new WeakReference<>(this);
      componentPopupMenu(this, BetterLabel_menuItems(me));
    }

    public BetterLabel(String text) {
      this();
      this.setText(text);
    }

    public void setText(String text) {
      super.setText(text);
      if (autoToolTip)
        if (!swic(text, "<html>"))
          setToolTipText(nullIfEmpty(text));
    }
  }

  static public VF1<JPopupMenu> BetterLabel_menuItems(final WeakReference<BetterLabel> me) {
    return new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboard(me.get().getText());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboard(me.get().getText());";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, \"Copy text to clipboard\", r {\r\n      copyTextToClipboard(me...";
      }
    };
  }

  static public class SingleComponentPanel extends JPanel {

    public SingleComponentPanel() {
      super(new BorderLayout());
    }

    public SingleComponentPanel(Component component) {
      this();
      if (component != null)
        setComponent(component);
    }

    public void set(Swingable component) {
      set(wrap(component));
    }

    final public void set(Component component) {
      setComponent(component);
    }

    public void setComponent(Component component) {
      {
        swing(() -> {
          if (getComponent() == component)
            return;
          removeAll();
          if (component != null)
            add(BorderLayout.CENTER, wrap(component));
          _revalidate(SingleComponentPanel.this);
        });
      }
    }

    public void setComponentAndRevalidateParent(Component component) {
      setComponent(component);
      _revalidate(_getParent(this));
    }

    final public void clear() {
      noComponent();
    }

    public void noComponent() {
      setComponent(null);
    }

    final public Component get() {
      return getComponent();
    }

    public Component getComponent() {
      return swing(() -> getComponentCount() == 0 ? null : getComponent(0));
    }

    public boolean isEmpty() {
      return getComponent() == null;
    }

    public boolean hasComponent() {
      return getComponent() != null;
    }
  }

  static public class Snippet {

    public String id, title, md5, type, text;

    public boolean isPublic = false;

    public Snippet() {
    }

    public Snippet(String id, String title) {
      this.title = title;
      this.id = id;
    }

    public Snippet(String id, String title, String md5) {
      this.md5 = md5;
      this.title = title;
      this.id = id;
    }

    public String toString() {
      return id + " - " + title;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }
  }

  static final public class BWImage extends Meta implements MakesBufferedImage, IBWImage {

    public int width, height;

    public byte[] pixels;

    public float borderColor = 0.0f;

    public BWImage() {
    }

    public BWImage(int width, int height) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
    }

    public BWImage(int width, int height, float brightness) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
      fillArrayUnlessZero(pixels, _toByte(brightness));
    }

    public BWImage(int width, int height, float[] pixels) {
      this.pixels = new byte[pixels.length];
      this.height = height;
      this.width = width;
      for (int i = 0; i < pixels.length; i++) this.pixels[i] = _toByte(pixels[i]);
    }

    public BWImage(int width, int height, byte[] pixels) {
      this.height = height;
      this.width = width;
      this.pixels = pixels;
    }

    public BWImage(BWImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) pixels[y * width + x] = image.getByte(x, y);
    }

    public BWImage(RGBImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[height * width];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        pixels[y * width + x] = BWImage._toByte(rgb.getBrightness());
      }
    }

    public BWImage(BufferedImage image) {
      try {
        width = image.getWidth();
        height = image.getHeight();
        int[] pixels = new int[width * height];
        byte[] bytePixels = this.pixels = new byte[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        if (!pixelGrabber.grabPixels())
          throw fail("Could not grab pixels");
        int n = width * height;
        for (int i = 0; i < n; i++) {
          int packed = pixels[i];
          int r = ((packed >> 16) & 0xFF);
          int g = ((packed >> 8) & 0xFF);
          int b = (packed & 0xFF);
          bytePixels[i] = (byte) ((r + g + b + 1) / 3);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public byte pixelToByte(int packed) {
      float r = ((packed >> 16) & 0xFF) / 255f;
      float g = ((packed >> 8) & 0xFF) / 255f;
      float b = (packed & 0xFF) / 255f;
      return (byte) ((r + g + b) / 3.0f * 255f);
    }

    public byte getByte(int x, int y) {
      return inRange(x, y) ? getByte_noRangeCheck(x, y) : _toByte(borderColor);
    }

    public int getInt(int x, int y) {
      return ubyteToInt(getByte(x, y));
    }

    public int getInt_noRangeCheck(int idx) {
      return ubyteToInt(pixels[idx]);
    }

    public int getInt(int x, int y, int defaultValue) {
      return inRange(x, y) ? getInt(x, y) : defaultValue;
    }

    public double averageBrightness() {
      double sum = 0;
      int n = width * height;
      for (int i = 0; i < n; i++) sum += getInt_noRangeCheck(i);
      return sum / n;
    }

    public float minimumBrightness() {
      float min = 1;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) min = Math.min(min, getPixel(x, y));
      return min;
    }

    public float maximumBrightness() {
      float max = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) max = Math.max(max, getPixel(x, y));
      return max;
    }

    public float getPixel(int x, int y) {
      return inRange(x, y) ? _toFloat(getByte(x, y)) : borderColor;
    }

    public float getFloatPixel(int x, int y) {
      return getPixel(x, y);
    }

    public float getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    static public byte _toByte(float pixel) {
      return (byte) (pixel * 255f);
    }

    static public float _toFloat(byte pixel) {
      return (((int) pixel) & 255) / 255f;
    }

    private boolean inRange(int x, int y) {
      return x >= 0 && x < width && y >= 0 && y < height;
    }

    public int getWidth() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public RGBImage toRGB() {
      int[] rgbs = new int[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = getByte(x, y) & 0xFF;
        rgbs[y * width + x] = 0xFF000000 | b * 0x010101;
      }
      return new RGBImage(width, height, rgbs);
    }

    public RGBImage toRGB_slow() {
      RGB[] rgbs = new RGB[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y * width + x] = new RGB(p, p, p);
      }
      return new RGBImage(width, height, rgbs);
    }

    public BWImage clip(int x, int y, int w, int h) {
      return clip(new Rectangle(x, y, w, h));
    }

    private Rectangle fixClipRect(Rectangle r) {
      return r.intersection(new Rectangle(0, 0, width, height));
    }

    public BWImage clip(Rect r) {
      return clip(r.getRectangle());
    }

    public BWImage clip(Rectangle r) {
      r = fixClipRect(r);
      byte[] newPixels = new byte[r.height * r.width];
      for (int y = 0; y < r.height; y++) for (int x = 0; x < r.width; x++) newPixels[y * r.width + x] = getByte(r.x + x, r.y + y);
      return new BWImage(r.width, r.height, newPixels);
    }

    public void setPixel(int x, int y, float brightness) {
      setByte(x, y, _toByte(fixPixel(brightness)));
    }

    public void setInt(int x, int y, int i) {
      setByte(x, y, (byte) limitToUByte(i));
    }

    public void setInt(Pt p, int i) {
      setInt(p.x, p.y, i);
    }

    public void setByte(int x, int y, byte b) {
      if (x >= 0 && x < width && y >= 0 && y < height)
        pixels[y * width + x] = b;
    }

    public byte getByte_noRangeCheck(int x, int y) {
      return pixels[y * width + x];
    }

    public void setByte(int x, int y, int brightness) {
      setByte(x, y, (byte) brightness);
    }

    private float fixPixel(float pixel) {
      return Math.max(0, Math.min(1, pixel));
    }

    public float getBorderColor() {
      return borderColor;
    }

    public void setBorderColor(float borderColor) {
      this.borderColor = borderColor;
    }

    public boolean anyPixelBrighterThan(double threshold) {
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) if (getPixel(x, y) > threshold)
        return true;
      return false;
    }

    public int[] getRGBPixels() {
      int n = width * height;
      int[] out = new int[n];
      for (int i = 0; i < n; i++) {
        var b = ubyteToInt(pixels[i]);
        b |= (b << 8) | (b << 16);
        out[i] = b | 0xFF000000;
      }
      return out;
    }

    public BufferedImage getBufferedImage() {
      return bufferedImage(getRGBPixels(), width, height);
    }

    public byte[] getBytes() {
      return pixels;
    }
  }

  static public class Cache<A> {

    public Object maker;

    public A value;

    public long loaded;

    static public boolean debug = false;

    public long changeCount;

    public Lock lock = lock();

    public Cache() {
    }

    public Cache(Object maker) {
      this.maker = maker;
    }

    public Cache(IF0<A> maker) {
      this.maker = maker;
    }

    public A get() {
      if (hasLock(lock))
        return value;
      Lock __20 = lock;
      lock(__20);
      try {
        if (loaded == 0) {
          value = make();
          changeCount++;
          loaded = sysNow();
        }
        return value;
      } finally {
        unlock(__20);
      }
    }

    public void clear() {
      Lock __21 = lock;
      lock(__21);
      try {
        if (debug && loaded != 0)
          print("Clearing cache");
        value = null;
        changeCount++;
        loaded = 0;
      } finally {
        unlock(__21);
      }
    }

    public void clear(double seconds) {
      Lock __22 = lock;
      lock(__22);
      try {
        if (seconds != 0 && loaded != 0 && sysNow() >= loaded + seconds * 1000)
          clear();
      } finally {
        unlock(__22);
      }
    }

    public void set(A a) {
      Lock __23 = lock;
      lock(__23);
      try {
        value = a;
        ++changeCount;
        loaded = sysNow();
      } finally {
        unlock(__23);
      }
    }

    public A make() {
      return (A) callF(maker);
    }
  }

  static abstract public class DynModule extends DynamicObject implements Enterable, ChangeTriggerable, IHasChangeListeners {

    public String name, toolTip;

    public PersistableThrowable _error;

    public Map<String, Collection<String>> mechLists;

    public Map<String, Boolean> _persistenceInfo;

    transient public Object _host;

    transient public Map<Object, IVF1> timers = newWeakHashMap();

    transient public Set<AutoCloseable> _resources = synchroHashSet();

    transient public Lock lock;

    transient public boolean persistOnChangedField = true;

    transient public int changeCount;

    transient public Object changeCountSync = new Object();

    transient public List onChange;

    transient public List onTransientChange;

    transient public boolean verboseTimers = false;

    transient public ReliableSingleThread rstUpdate;

    transient public Set<String> componentFieldsToKeep;

    transient public Map<String, Object> transientGeneralMap = synchroHashMap();

    transient public Q q;

    transient public List onFieldChange;

    transient public boolean _hasPreviousBounds = false;

    transient public StringBuffer _printLog = new StringBuffer();

    transient public boolean deleted = false;

    public DynModule() {
      if (useErrorHandling())
        dm_initErrorHandling();
      setMainDesktopPane((JDesktopPane) getCreatorOpt("desktop"));
    }

    public boolean useErrorHandling() {
      return true;
    }

    public boolean isVisible() {
      return isTrue(getOpt(_host, "visible"));
    }

    public String moduleName() {
      return name;
    }

    public void setModuleName(String name) {
      String oldName = this.name;
      if (!eq(name, oldName)) {
        setField("name", name);
        possiblyInternalFrameTitle(vis(), name);
        vmBus_send("moduleNameChange", this, oldName, name);
      }
    }

    public void setModuleToolTip(String toolTip) {
      this.toolTip = toolTip;
    }

    public JComponent vis() {
      return (JComponent) getOpt(_host, "vis");
    }

    public <A extends AutoCloseable> A ownResource(A a) {
      if (a != null)
        _resources.add(a);
      return a;
    }

    public <A> A ownTimer(A timer) {
      if (timer instanceof AutoCloseable)
        ownResource((AutoCloseable) timer);
      else
        ownTimer(timer, __36 -> cancelTimerOrInterruptThread(__36));
      return timer;
    }

    public void ownTimer(Object timer, IVF1 closerHelper) {
      timers.put(timer, closerHelper);
    }

    public void singleTimer(java.util.Timer timer) {
      stopAllTimers();
      ownTimer(timer);
    }

    public void stopAllTimers() {
      for (AutoCloseable resource : getAndClearList(_resources)) {
        if (verboseTimers)
          print("Releasing resource: " + resource);
        try {
          resource.close();
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      }
      for (Map.Entry<? extends Object, ? extends IVF1> __26 : _entrySet(getAndClearMap(timers))) {
        Object timer = __26.getKey();
        IVF1 closerHelper = __26.getValue();
        if (verboseTimers)
          print("Stopping timer: " + closerHelper + " / " + timer);
        pcallF(closerHelper, timer);
      }
    }

    public boolean isDeleted() {
      return deleted;
    }

    public boolean deleted() {
      return deleted;
    }

    public void cleanMeUp_dynModule() {
      deleted = true;
      {
        cleanUp(q);
        q = null;
      }
      stopAllTimers();
    }

    public void persistMe() {
      synchronized (changeCountSync) {
        ++changeCount;
      }
      pcallFAll(onChange);
      callOpt(_host, "_change");
      updateMe();
    }

    public void fireChangeWithoutPersisting() {
      pcallFAll(onChange);
    }

    public void fireTransientChange() {
      pcallFAll(onTransientChange);
    }

    final public void _change() {
      persistMe();
    }

    final public void change() {
      persistMe();
    }

    public void updateMe() {
      rstUpdate().trigger();
    }

    public void changeAndUpdate() {
      _change();
      updateMe();
    }

    public boolean setField_noPersist(String name, Object value) {
      return setField(name, value, true);
    }

    public boolean _setField(String name, Object value) {
      return setField(name, value);
    }

    public boolean setField(String name, Object value) {
      return setField(name, value, false);
    }

    public boolean setField(String name, Object value, boolean noPersist) {
      AutoCloseable __32 = enter();
      try {
        try {
          if (eq(get(this, name), value))
            return false;
        } catch (Throwable __e) {
          pcallFail(__e);
        }
        return setField_noCheck(name, value, noPersist);
      } finally {
        _close(__32);
      }
    }

    public boolean setField_noCheck(String name, Object value) {
      return setField_noCheck(name, value, false);
    }

    public boolean setField_noCheck(String name, Object value, boolean noPersist) {
      AutoCloseable __33 = enter();
      try {
        setOpt(this, name, value);
        pcallFAll(onFieldChange, name);
        if (!noPersist && dm_isPersistentField(me(), name))
          _change();
        return true;
      } finally {
        _close(__33);
      }
    }

    public <A> A setFieldAndReturn(String name, A value) {
      setField(name, value);
      return value;
    }

    public boolean setFields(Object... params) {
      boolean change = false;
      for (int i = 0; i < l(params); i += 2) if (setField((String) params[i], params[i + 1]))
        change = true;
      return change;
    }

    public void start() {
      _hasPreviousBounds = dm_getBounds() != null;
      if (hasMethod_onTypes(this, "onTopInput", String.class))
        dm_onTopInput_q(new VF1<String>() {

          public void get(String s) {
            try {
              call(module(), "onTopInput", s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "call(module(), 'onTopInput, s)";
          }
        });
    }

    public void revisualize() {
      call(dm_os(), "revisualizeModule", _host);
    }

    public boolean useEnterShortcut() {
      return false;
    }

    public AutoCloseable enter() {
      AutoCloseable c = tempSetBetterThreadLocalIfNecessary_weakRef(dm_current_generic_tl(), this);
      if (c == null && useEnterShortcut())
        return null;
      Object realMC = getMainClass(this);
      if (printToModule())
        c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(_printToModuleInterceptor()));
      if (realMC != mc()) {
        if (printToModule())
          c = combineAutoCloseables(c, (AutoCloseable) callOpt(realMC, "tempInterceptPrintIfNotIntercepted", _printToModuleInterceptor()));
        else
          c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(new F1<String, Boolean>() {

            public Boolean get(String s) {
              try {
                {
                  call(realMC, "print", s);
                  return false;
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ret false with call(realMC, 'print, s);";
            }
          }));
        c = combineAutoCloseables(c, tempSetTL(realMC_tl(), realMC));
      }
      return c;
    }

    public F1<String, Boolean> _printToModuleInterceptor() {
      return new F1<String, Boolean>() {

        public Boolean get(String s) {
          try {
            if (print_preprocess != null)
              s = (String) callF(print_preprocess, s);
            s = fixNewLines(s);
            Appendable loc = _printLog;
            Appendable buf = print_log;
            int loc_max = print_log_max;
            if (buf != loc && buf != null) {
              print_append(buf, s, print_log_max);
              loc_max = local_log_max;
            }
            if (loc != null)
              print_append(loc, s, loc_max);
            if (printAlsoToSystemOut)
              System.out.print(s);
            return false;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (print_preprocess != null) s = (S) callF(print_preprocess, s);\r\n      s = ...";
        }
      };
    }

    public boolean printToModule() {
      return true;
    }

    public AutoCloseable enterAndLock() {
      return combineAutoCloseables(enter(), tempLock(lock));
    }

    public boolean setError(Throwable e) {
      setField("_error", persistableThrowable(e));
      return true;
    }

    public void clearError() {
      setField("_error", null);
    }

    public DynModule onChange(Runnable r) {
      Lock __27 = lock;
      lock(__27);
      try {
        if (onChange == null)
          onChange = synchroList();
        addIfNotThere(onChange, r);
        return this;
      } finally {
        unlock(__27);
      }
    }

    public DynModule removeChangeListener(Runnable r) {
      remove(onChange, r);
      return this;
    }

    public void onFieldChange(VF1<String> r) {
      Lock __29 = lock;
      lock(__29);
      try {
        if (onFieldChange == null)
          onFieldChange = synchroList();
        addIfNotThere(onFieldChange, r);
      } finally {
        unlock(__29);
      }
    }

    public void removeFieldChangeListener(VF1<String> r) {
      remove(onFieldChange, r);
    }

    public void onChangeAndNow(JComponent c, Object r) {
      onUpdateAndNow(c, r);
    }

    public void onChangeAndNow(List<? extends JComponent> l, Object r) {
      utils.onChangeAndNow(l, r);
    }

    public void onChangeAndNow(JTextComponent c, IVF1<String> r) {
      onUpdateAndNow(c, r);
    }

    public <A extends JComponent> A onChange(A tc, Object r) {
      onUpdate(tc, r);
      return tc;
    }

    public void update() {
    }

    public void unvisualize() {
      zeroAllFieldsOfTypeExcept(this, Component.class, componentFieldsToKeep);
    }

    public Object menuItems() {
      return null;
    }

    public void enhanceFrame(Container f) {
      Object items = menuItems();
      if (items instanceof Object[])
        items = paramsToAbstractActions((Object[]) items);
      internalFramePopupMenuFromActions_threaded(f, (List) items);
      String switchableFields = (String) (callOpt(this, "switchableFields"));
      Set<String> set = asLinkedHashSet(splitAtSpace(switchableFields));
      Matches m = new Matches();
      for (String field : allFields(getClass())) if (startsWith(field, "_switchableField_", m))
        set.add(m.rest());
      for (String field : set) {
        Class type = fieldType(this, field);
        if (eq(boolean.class, type))
          dm_boolFieldMenuItem(f, field);
        else if (eq(int.class, type))
          dm_intFieldMenuItem(f, field);
        else if (eq(long.class, type))
          dm_longFieldMenuItem(f, field);
        else if (eq(double.class, type))
          dm_doubleFieldMenuItem(f, field);
        else if (eq(float.class, type))
          dm_floatFieldMenuItem(f, field);
        else if (eq(String.class, type))
          dm_stringFieldMenuItem(f, field);
        else if (eq(File.class, type))
          dm_fileFieldMenuItem(f, field);
      }
    }

    public ReliableSingleThread rstUpdate() {
      if (rstUpdate == null)
        rstUpdate = dm_rst(this, new Runnable() {

          public void run() {
            try {
              AutoCloseable __34 = enter();
              try {
                update();
              } finally {
                _close(__34);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "temp enter(); update();";
          }
        });
      return rstUpdate;
    }

    public Q q() {
      AutoCloseable __35 = enter();
      try {
        if (q == null) {
          Lock __30 = lock;
          lock(__30);
          try {
            if (q == null)
              q = dm_startQ();
          } finally {
            unlock(__30);
          }
        }
        return q;
      } finally {
        _close(__35);
      }
    }

    public <A> A withUpdate(A a) {
      rstUpdate().trigger();
      return a;
    }

    public DynModule module() {
      return this;
    }

    public DynModule me() {
      return this;
    }

    public JComponent visualize() {
      return dm_noVisualisation();
    }

    public String programTitle_cache;

    public String programTitle() {
      if (programTitle_cache == null)
        programTitle_cache = snippetTitle(programID(mainClass(this)));
      return programTitle_cache;
    }

    public void doPersist(String field) {
      _persistenceInfo = mapMinus(_persistenceInfo, field);
    }

    public void dontPersist(String field) {
      _persistenceInfo = mapPlus(_persistenceInfo, "field", false);
    }

    public Appendable _actualPrintLog() {
      return printToModule() ? _printLog : print_log;
    }

    public Object getHost() {
      return _host;
    }

    public <A> boolean addAndChange(Collection<A> cl, A a) {
      if (cl == null || !cl.add(a))
        return false;
      change();
      return true;
    }

    public <A> void clearAndChange(Collection<A> cl) {
      if (cl == null)
        return;
      cl.clear();
      change();
    }

    public void addAndChange(LongBuffer buf, long a) {
      if (buf == null)
        return;
      buf.add(a);
      change();
    }

    public void clearAndChange(LongBuffer buf) {
      if (buf == null)
        return;
      buf.clear();
      change();
    }
  }

  static public void _registerTimer(java.util.Timer timer) {
    _registerTimer_original(timer);
    var mod = dm_currentModule();
    {
      if (mod != null)
        mod.ownTimer(timer);
    }
  }

  abstract static public class DynPrintLog extends DynModule {

    transient public JFastLogView_noWrap printLogView;

    transient public Lock updatePrintLog_lock = lock();

    transient public StringBuffer actualPrintLog;

    transient public int printLogUpdateInterval = 500;

    transient public JComponent printLogPanel;

    public JComponent visualize() {
      return makePrintLogPanel();
    }

    public JComponent makePrintLogPanel() {
      JComponent section = printLogPanel = jSection("Log", jscroll_copyBackground(printLogView = jFastLogView_noWrap(getPrintLog())));
      componentPopupMenuItem(section, "Clear", new Runnable() {

        public void run() {
          try {
            AutoCloseable __43 = enter();
            try {
              dm_clearModulePrintLog();
            } finally {
              _close(__43);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();  dm_clearModulePrintLog();";
        }
      });
      return awtEvery(section, printLogUpdateInterval, new Runnable() {

        public void run() {
          try {
            updatePrintLog();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "updatePrintLog();";
        }
      });
    }

    public void updatePrintLog() {
      swing(() -> {
        Lock __40 = updatePrintLog_lock;
        lock(__40);
        try {
          JFastLogView_noWrap _view = printLogView;
          if (_view == null)
            return;
          if (_view.setText(getPrintLog())) {
            scrollAllTheWayDown(_view);
            awtLater(100, new Runnable() {

              public void run() {
                try {
                  scrollAllTheWayDown(_view);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "scrollAllTheWayDown(_view)";
              }
            });
          }
        } finally {
          unlock(__40);
        }
      });
    }

    public JFastLogView_noWrap myPrintLogComponent() {
      return printLogView;
    }

    public void enableWordWrap() {
    }

    public String getPrintLog() {
      if (actualPrintLog == null) {
        if (printToModule())
          actualPrintLog = _printLog;
        else
          actualPrintLog = liveLocalPrintLog_realMC(this);
      }
      return str(actualPrintLog);
    }
  }

  abstract static public class DynObjectTable<A> extends DynModule {

    public List<A> data = new ArrayList();

    transient public JTable table;

    transient public F1<A, Map> itemToMap;

    transient public VF1<A> defaultAction;

    transient public boolean debug, fieldsInOrder = true, withSearcher;

    transient public TableSearcher searcher;

    transient public List onListChanged;

    transient public Set<String> hideFields;

    transient public boolean useStruct = false;

    public void start() {
      try {
        super.start();
        itemToMap = new F1<A, Map>() {

          public Map get(A a) {
            try {
              if (a instanceof String)
                return litorderedmap("", (String) a);
              Map map = humanizeKeys(fieldsInOrder ? objectToMap_inOrder_withoutFields(a, hideFields) : objectToMap(a));
              if (!useStruct)
                map = mapValues(__87 -> strOrEmpty(__87), map);
              return map;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (a instanceof S) ret litorderedmap(\"\" := (S) a);\r\n      Map map = humanize...";
          }
        };
        onChange(new Runnable() {

          public void run() {
            try {
              updateTable();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "updateTable();";
          }
        });
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void onListChanged(Runnable r) {
      if (r == null)
        return;
      onListChanged = addDyn_sync(onListChanged, r);
    }

    public void onListChangedAndNow(Runnable r) {
      if (r == null)
        return;
      onListChanged(r);
      r.run();
    }

    public void addCountToName() {
      onListChangedAndNow(new Runnable() {

        public void run() {
          try {
            addCountToNameNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "addCountToNameNow();";
        }
      });
    }

    public void addCountToNameNow() {
      AutoCloseable __47 = enter();
      try {
        setModuleName(programTitle() + " (" + count() + ")");
      } finally {
        _close(__47);
      }
    }

    public JComponent visualize() {
      List<Map> l = map(itemToMap, data);
      table = dataToTable_uneditable(sexyTable(), l);
      onDoubleClickOrEnter(table, new VF1<Integer>() {

        public void get(Integer row) {
          try {
            AutoCloseable __48 = enter();
            try {
              A a = _get(data, row);
              if (a != null)
                onDoubleClick(a);
            } finally {
              _close(__48);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();\r\n      A a = _get(data, row);\r\n      if (a != null) onDoubleCli...";
        }
      });
      if (withSearcher)
        return (searcher = tableWithSearcher2(table)).panel;
      return table;
    }

    public void unvisualize() {
      super.unvisualize();
      searcher = null;
    }

    public void onDoubleClick(A line) {
      callF(defaultAction, line);
    }

    public void updateTable() {
      AutoCloseable __49 = enter();
      try {
        if (table != null) {
          swing(() -> {
            Point scrollPosition = enclosingViewPosition(table);
            if (debug)
              print("Scroll position: " + scrollPosition);
            dataToTable_uneditable(table, map(itemToMap, data));
            setEnclosingViewPosition(table, scrollPosition);
            if (searcher != null)
              searcher.rowIndices = null;
            if (debug)
              print("dataToTable done, alerting " + n2(onListChanged, "listener"));
          });
        }
        pcallFAll(onListChanged);
      } finally {
        _close(__49);
      }
    }

    public void dontPersist() {
      _persistenceInfo = mapPlus(_persistenceInfo, "data", false);
    }

    public void clear() {
      syncClear(data);
      fireDataChanged();
    }

    public void add(A a) {
      syncAdd(data, a);
      fireDataChanged();
    }

    public A addAndReturn(A a) {
      add(a);
      return a;
    }

    public void add(int idx, A a) {
      syncAdd(data, idx, a);
      fireDataChanged();
    }

    public void addAll(Collection<A> l) {
      if (empty(l))
        return;
      syncAddAll(data, l);
      fireDataChanged();
    }

    public void addAndScrollDown(A a) {
      add(a);
      scrollDown();
    }

    public void remove(A a) {
      syncRemove(data, a);
      fireDataChanged();
    }

    public void removeAll(List<A> a) {
      syncRemoveAll(data, a);
      fireDataChanged();
    }

    public void setList(Iterable<A> data) {
      setData(data);
    }

    public void removeSelected() {
      removeAll(allSelected());
    }

    public void setData(Collection<A> data) {
      setData((Iterable) data);
    }

    public void setData(Iterable<A> data) {
      setData(data, false);
    }

    public void setData(Iterable<A> data, boolean force) {
      {
        swing(() -> {
          int[] selection = selectedTableRows_array(table);
          List<A> cloned = cloneList(data);
          if (setField("data", cloned) || force) {
            updateTable();
            dm_vmBus_send("listChanged", module(), cloned);
          }
          if (force)
            change();
          selectTableRows(table, selection);
        });
      }
    }

    public int count() {
      return syncL(data);
    }

    public void setData_force(Collection<A> data) {
      setData(data, true);
    }

    public void fireDataChanged() {
      setData_force(data);
    }

    public int rowFromSearcher(int i) {
      return searcher == null || searcher.rowIndices == null ? i : or(get(searcher.rowIndices, i), -1);
    }

    public A selected() {
      return syncGet(data, rowFromSearcher(selectedTableRowInModel(table)));
    }

    public List<A> allSelected() {
      return syncListGetMulti(data, selectedIndices());
    }

    public int selectedIndex() {
      return selectedTableRow(table);
    }

    public List<Integer> selectedIndices() {
      return map(i -> rowFromSearcher(i), selectedTableRowsInModel(table));
    }

    public boolean selectItem(A a) {
      int i = indexOf(data, a);
      selectRow(table, i);
      return i >= 0;
    }

    public void doubleClickItem(A a) {
      if (selectItem(a))
        onDoubleClick(a);
    }

    public void popupMenuItem(String text, Object r) {
      tablePopupMenuItemsThreaded(table, text, _convertRunnable(r));
    }

    public void popupMenuItem_top(String text, Object r) {
      tablePopupMenuItemsThreaded_top(table, text, _convertRunnable(r));
    }

    public Object _convertRunnable(final Object r) {
      if (r == null || r instanceof Runnable)
        return r;
      return new VF1<Integer>() {

        public void get(Integer idx) {
          try {
            callF(r, syncGet(data, idx));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r, syncGet(data, idx))";
        }
      };
    }

    public JTable table() {
      return table;
    }

    public void hideFields(String... fields) {
      if (hideFields == null)
        hideFields = new HashSet();
      _addAll(hideFields, fields);
    }

    public A getRow(int row) {
      return get(data, row);
    }

    public void scrollDown() {
      scrollTableDownNow(table);
    }

    public List<A> getData() {
      return data;
    }

    public List<A> data() {
      return getData();
    }

    public List<A> list() {
      return getData();
    }

    public List<A> getList() {
      return getData();
    }

    public List<A> clonedList() {
      return cloneList(data);
    }

    public File quickBackup() {
      File f = programFile("backup-" + ymd_minus_hms_minus_millis() + ".gz");
      saveGZStructToFile(f, module());
      printFileInfo(f);
      return f;
    }
  }

  abstract static public class DynImageSurface extends DynModule {

    transient public ImageSurface imageSurface;

    transient public BufferedImage image;

    transient public String imageID;

    transient public boolean useUpdateHack, zoomToWindowOnSetImage;

    transient public Object onNewImage;

    static public boolean _switchableField_autoSaveToDisk = true;

    public boolean autoSaveToDisk = autoSaveToDiskDefault();

    static public boolean _switchableField_pixelate = true;

    public boolean pixelate = false;

    public JComponent visualize() {
      return _visualize();
    }

    final private JComponent _visualize() {
      imageSurface = imageSurface(image);
      imageSurface.onNewImage = new Runnable() {

        public void run() {
          try {
            newImageFromSurface();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "newImageFromSurface();";
        }
      };
      imageSurface_pixelated(imageSurface, pixelate);
      return jscroll_center(imageSurface);
    }

    public void enableDoubleBuffering() {
      if (imageSurface != null)
        imageSurface.setDoubleBuffered(true);
    }

    public JComponent visualizeWithDoubleBuffering() {
      JComponent c = _visualize();
      enableDoubleBuffering();
      return c;
    }

    public Object _getReloadData() {
      return image;
    }

    public void _setReloadData(BufferedImage image) {
      this.image = image;
    }

    public void start() {
      try {
        super.start();
        dm_watchField("pixelate", () -> imageSurface_pixelated(imageSurface, pixelate));
        if (autoSaveToDisk)
          autoLoadNow();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void autoLoadNow() {
      AutoCloseable __54 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          if (fileExists(f)) {
            print("Auto-loading " + f);
            setImage(loadImage2(f), true);
          }
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      } finally {
        _close(__54);
      }
    }

    public void autoSaveNow() {
      AutoCloseable __55 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          savePNG(f, image);
          infoBox("Auto-saved " + renderFileInfo(f));
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      } finally {
        _close(__55);
      }
    }

    public boolean autoSaveToDiskDefault() {
      return false;
    }

    public void enhanceFrame(Container f) {
      super.enhanceFrame(f);
      internalFramePopupMenuItem(f, "Auto-save now", runnableThread(new Runnable() {

        public void run() {
          try {
            autoSaveNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "autoSaveNow();";
        }
      }));
    }

    public void setImage(MakesBufferedImage image) {
      imageID = null;
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void newImageFromSurface() {
      setImage(imageSurface.getImage());
    }

    public void setImage(BufferedImage image) {
      setImage(image, false);
    }

    public void setImage(BufferedImage image, boolean loadingFromAutoSave) {
      this.image = image;
      imageID = null;
      if (imageSurface != null) {
        AutoCloseable __56 = tempSetField(imageSurface, "onNewImage", null);
        try {
          imageSurface.setImage(image);
          if (zoomToWindowOnSetImage)
            imageSurface.zoomToWindow();
          if (autoSaveToDisk && !loadingFromAutoSave)
            autoSaveNow();
        } finally {
          _close(__56);
        }
      }
      vmBus_send("newImage", this);
      pcallF(onNewImage, image);
    }

    public void setImage(String imageID) {
      if (sameSnippetID(this.imageID, imageID))
        return;
      setImage(loadImage2(imageID));
      this.imageID = imageID;
    }

    public File autoSaveImageFile() {
      String id = dm_moduleID(me());
      return javaxDataDir("Image Autosaves/" + id + "-autosave.png");
    }

    public BufferedImage getImage() {
      if (useUpdateHack) {
        ImageSurface is = imageSurface;
        if (is != null && is.getImage() != image)
          setImage(is.getImage());
      }
      return image;
    }

    public boolean hasImage() {
      return image != null;
    }

    public void setZoom(double zoom) {
      if (imageSurface != null)
        imageSurface.setZoom(zoom);
    }

    public Rect getSelection() {
      return imageSurface == null ? null : toRect(imageSurface.getSelection());
    }

    public void setSelection(Rect r) {
      if (imageSurface != null)
        imageSurface.setSelection(toRectangle(r));
    }

    public int imageWidth() {
      return imageSurface.getImage().getWidth();
    }

    public int imageHeight() {
      return imageSurface.getImage().getHeight();
    }

    public void pixelate() {
      setField("pixelate", true);
    }
  }

  abstract static public class DynCalculatedList extends DynModule {

    transient public JList list;

    transient public List<String> results;

    transient public boolean calculateWhenHidden = false;

    public JComponent visualize() {
      return list = jlist(calc());
    }

    public void unvisualize() {
      list = null;
    }

    public void update() {
      AutoCloseable __61 = enter();
      try {
        if (list != null || calculateWhenHidden)
          fillListWithStrings(list, results = calc());
      } finally {
        _close(__61);
      }
    }

    abstract public List<String> calc();

    public void scrollDown() {
      scrollAllTheWayDown(list);
    }

    public String selected() {
      return selectedItem(list);
    }
  }

  static public Object creator() {
    return callOpt(assertNotNull("No real MC", realMC_tl()).get(), "creator");
  }

  static public String programID;

  static public String getProgramID() {
    Object mc = realMC_tl().get();
    if (mc != null)
      return getProgramID(mc);
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public Concepts db_mainConcepts() {
    throw fail("No db_mainConcepts");
  }

  static public JButton basicJButton(String text) {
    return swing(() -> {
      JButton btn = new JButton(text);
      setHorizontalMargin(btn, 4);
      return btn;
    });
  }

  static public String fastIntern(String s) {
    return s == null ? null : s.intern();
  }

  static public List<String> myInnerClasses_list = litlist(null, "IVarWithNotify", "NotifyingCollection", "Hi15Image", "DummyPosterizer", "StructureStringIndenter", "IImageRegion", "SnPSettings", "ImageSurface", "JOnScreenKeyboard", "ScreenShotMeta", "ArrayMatrix", "talkToThisVM_IO", "IFieldIndex", "AnimatedLine", "SimpleLiveValue", "GazellePresenceListener", "WebRequest", "WeakIdentityHashMap", "JForm", "SingleComponentPanel", "PosterizeBWImage", "IWebRequest", "RenamedLongIterator", "BackupThinner", "NumberPt", "HashBufferedImage", "AbstractLayoutManager", "TrayIconLastPosition", "IterableIterator", "betterCIComparator_C", "SynchronizedArrayList", "MakesBufferedImage", "DeleteFilesDialog", "IProbabilisticScheduler", "TextImageAction", "CloseableIterableIterator", "AbstractSSIList", "HuffmanTreeMaker", "PixelPreservingImageOpResult", "ShortBuffer", "HasBounds", "Enterable", "Matches", "WithTimestamp", "SynchronizedLongBuffer", "TableWithTooltips", "Dyn_FieldWatcher", "DoubleRect", "Surface", "WeakVar", "NotifyingList", "Q", "VectorSSIList", "ILongBuffer", "TailFile", "RenderRecognizedBox", "RestartableCountdown", "VStack", "TransientObject", "DynamicVStack", "FixedVarContext", "Htmlable", "DynObjectTable", "mapI_if1_It", "ConceptsComboBox", "HuffmanByteArray", "VarContext", "Average", "IConceptCounter", "IToolTipMaker", "OpenGL_DemoObjects", "RangeSliderUI", "BetterLabel", "componentPopupMenu_Adapter", "BWIntegralImage", "CompressToInterpolatedDoubleArray", "IVStack", "IF0_Pair", "FailedRule", "IHasTokenRangeWithSrc", "IF0_Bool", "IBinaryImage", "IImageRegions", "transpileOnServerWithErrorWindow_DaClass", "StefansOS_ConnectToServer", "LineThroughPoint", "JSection", "RecognizedRegion", "CollapsibleLeftPanel", "IF0WithChangeListeners", "FullChange", "GeneralSSIList", "JECompressionRegime", "WithSideValue", "IntegerIterator", "IStringifier", "CombinedStringifier", "MultiSleeper", "JFilePathLabel", "UTF8Processor", "ReliableSingleThread", "ListAndIndex", "WebSocketFactory", "JVideoLibDownloader", "WindowResizeDragger", "TranspileWithErrorWindow", "NESWDirection", "DoubleBuffer", "ProgramScan", "RegExp", "PersistableOKOrError", "JustCountingOutputStream", "DefaultButtonBorder", "F0", "Snippet", "F1", "DynImageSurface", "RandomAccessAbstractList", "F2", "RGB", "IntPair", "HasChangeListeners", "F3", "BoolVar", "WidthAndHeightFinal", "IHasGlobalID", "ConceptFieldIndexCI", "FormLayout1", "IRecognizedBox", "StringHead", "MakesBWImage", "CenteredComboBoxRenderer", "tablePopupMenu_Maker", "VirtualVar", "Cache", "SynchronizedList", "_MethodCache", "PingSourceCancelledException", "JForwardingLibDownloader", "LiveValue", "Eq", "AbstractHasHi15Color", "IDoubleBuffer", "proxy_InvocationHandler", "MethodMaker", "RunnableWithExceptions", "EphemeralObjectIDs", "JavaXClassLoader", "Probabilistic", "Flattener", "BackupFileAge", "FlexibleRateTimer", "RuleWithParams", "CachedPosterizer", "ByteBuffer", "RangeSlider", "WebSocket", "TransferableImage", "Sleeping", "IConceptIndex", "Updateable", "WithProbability", "BitIO", "SubList", "SecretValue", "GenericArrayTypeImpl", "JSelectableDirLabel", "AppendableChain", "CompactLinkedHashSet", "LoggingBitHead", "FixedRateTimer", "WholeImageFilter", "CompactLongSet", "GridCodec1", "IndexIterator", "GrabbableRGBBytePixels", "MethodOnObject", "MinimumFilter", "XRef", "JGallery", "IUnstructured", "IntegralImage", "ShortIterator", "IntBuffer", "DoublePt", "IIntPred", "SynchronizedNavigableSet", "SynchronizedCircularFifoBuffer", "AbstractMatrix", "Chain", "RegionToBWImage", "ThreadPool", "ComputerCountListener", "JS", "WidthAndHeightImpl", "RunnablesReferenceQueue", "JPopDownButton", "AbstractJavaXExpr", "SSIListFrame", "IDialogHandler", "AWTOnConceptChanges", "VariableSizeUIntForBitHead", "IHasChangeListeners", "JavaCodec", "ImageSurface_PositionToolTip", "TranslucentWindowTest", "FlexWebSocket", "IIntegralImage", "BitHead", "AbstractCompressor_AnyType", "DialogIO", "RegionToImage2B", "Stages", "SynchronizedArrayList_Base", "Scribble", "IAutoCloseableF0", "IPartialStringifier", "BitIOWrapper", "ISleeper_v2", "AlphanumComparator", "JExtendedTabbedPane", "PersistableThrowable", "Animation", "BlockDiff", "talkToSubBot_IO", "IDoublePt", "NumPadFixingInputMap", "PixelUtils", "HasIndex", "WidthAndHeight", "ISubList", "Responder", "TableSearcher", "IMultiSet", "WithToolTip", "VectorSSI", "mapI_It", "ConceptsChange", "JFilePathButton", "TokCondition", "HashRefTokenMaker", "JSyntaxTextFileEditor", "listPopupMenu_Maker", "WAndHImpl", "ConceptWithChangeListeners", "SynchronizedCollection", "OnePathWithOrigin", "TargetAndActual", "CleanExit", "IIntIntPred", "IntMinMax", "ImageSurfaceSelector", "Sentence", "ScreenCamStream", "Concept", "HashedBWImage", "RectAsRecognizedBox", "IRGBImage", "WeightlessShuffledIterator", "MyHTTPD", "RegisteredReference", "TreeMultiMap", "Range", "FreeOfLocalBlockedKeyword", "ContentsIndexedList", "FileTransferable", "AbstractSteppable", "ClassMaker", "IPixelSet", "IContentsIndexedList2", "And", "Value", "ChromeBookmark", "OKOrError", "ImageChooser", "FileBasedLock", "Symbol", "IMeta", "ListToMatrix", "BetterThread", "JFileDropTarget", "BetterThreadLocal", "JTargetAndActualSlider", "Lowest", "CollapsibleNorthPanel", "RegionBorder_innerPoints", "ChangeTrigger", "AnimatedImageSurface", "ScoredSearcher_stable", "DynPrintLog", "JMiniJavaIDE", "AutoVMExit", "BoundsFinder", "MinimalChain", "NamedConcept", "Image2B", "AbstractFastRegions", "SynchronizedSortedSet", "SSI", "IBest", "jLiveValueSection_class", "JE_CompressEachElementIndividually", "DoubleRange", "DynamicObject", "IntegrityCheckable", "DoubleFPSCounter", "Exp", "RenderText", "DynamicMethods", "EGDiff", "Meta", "BStack", "Derefable", "JVMStackCellType", "FastRegions_BWImage", "SingleThread", "JSelfSwingable", "InMemoryClassLoader", "DefunctClassLoader", "CutListToBudget", "IntVar", "BWImage", "PingSource", "Renderable", "jCenteredLiveValueSection_class", "ConceptFieldIndexDesc", "HasTokenRangeWithSrc", "VarMatches", "Best", "DynModule", "ConceptL", "BackgroundProcessesUI", "Rect", "Pt", "TimeoutException_Inner", "BufferedImageWithMeta", "LeftAlignedLine", "RemoteDB", "AverageAndMinMax", "SynchronizedNavigableMap", "Concepts", "RC", "PCallPolicy", "IVF1WithToString", "IBWIntegralImage", "Hasher", "PNGFile", "getOpt_Map", "IFieldsToList", "JTextFileEditor", "IResponder", "WeakValueMap", "structure_Data", "VarWithNotify", "jsonDecode_Y", "Zip4j_MergeZipFilesWithFilter", "JColorBar", "IVar", "DynPrintLogAndEnabled", "Gazelle22_GradientImage", "TokenRangeWithSrc", "ConceptWithGlobalID", "LiteralJavaXExpr", "DynCalculatedList", "SimpleOutlineWalker", "ParameterizedTypeImpl", "Timestamp", "DoLater", "ImageInfiller", "ConceptFieldIndexBase", "ManyCirclePainter", "LongRange", "SSIList", "RawBufferedImageDistance_sameSize", "JECompressionSearch", "OnEnclosingScrollPaneResize", "JComponentWithChangeListeners", "MultiSet", "RuntimeExceptionWithCustomStackTrace", "ListFromFunction", "T3", "IResourceHolder", "CloseablesHolder", "EvalJavaPrep", "SizeInInts", "DynamicStack", "OHLCEntry", "RegionHoleBounds", "IPersistenceInfo", "BoxBlurFilter", "IntRange", "ExtendedCSVParser", "HuffmanTree", "PleaseIncludeFunctionsStatement", "UnsynchronizedCompactHashSet", "ProbabilisticListListener", "TimestampRange", "CopyBlock", "NanoWebSocketServer", "JPaintTool", "Stringifier_ToString", "JavaXClassLoaderWithParent2", "AWTOnConceptChangesByClass", "PtBuffer", "SynchronizedDoubleBuffer", "Frequency", "CompressionRegime_AnyType", "RGBImage", "FileWatchService", "SmartTimerTask", "ComponentResizeDragger", "RegionBorder_innerPoints_v2", "ImageSurfaceScribbleTool", "SimpleCRUD_v2", "ConceptDelete", "SinglePixelPosterizer", "ScanlineBitMatrix", "GoodThingsToTrack", "Literal", "WindowDragger", "unstructure_Handler", "IF2_IntInt_Double", "IMultiMap", "RegionBorder_innerPoints_withDiagonals", "IF1_IntToInt", "ThrowableWithCustomStackTrace", "BoolVarWithNotify", "IBWImage", "PtInComponent", "JConceptsTable", "AutoComboBox", "WebSocketException", "Sentence2", "ConceptFieldIndex", "GrabbableGrayPixels", "IHasBackRefs", "StepperWithStats", "MapI", "VectorOptimizedSSIList", "IfThen", "unstructure_Receiver", "JDraggableBoxDemo", "IF0", "BaseXRef", "IF2", "IF1", "IPosterizer", "IVF3", "IVF1", "IVF2", "NewBlock", "IWithSideValue", "MultiPointGradient", "Options", "IConcept", "structure_ClassInfo", "Func", "ScoredStringSearcher", "TreeSetWithDuplicates", "ScreenOverlay", "TimedCache", "ISetAndGet", "ToJava", "JFFMPEGVideoPlayer", "AbstractSSI", "RSyntaxTextAreaWithSearch", "InterpolatedDoubleArray", "QuickException", "SynchronizedSet", "DialogHandler", "JObjectTable", "ProbabilisticList", "Steppable", "G2Drawable", "UIURLSystem", "ImageSurfaceMouseHandler", "Pair", "Swingable", "FastDownscale2x2", "SingleThreadProfiler", "Percent", "RSTADummyParser", "ProbabilisticListAdapter", "LineAndColumn", "UniqueString", "ICharPred", "ILongQueue", "ChangeTriggerable", "GrabbableIntPixels", "IIVirtualClip", "IBackgroundProcesses", "DynamicHStack", "MetaWithChangeListeners", "ReverseChain", "BresenhamLineDrawer", "ConceptCreate", "CheckerBoard2", "TokenRange", "Seconds", "SynchronizedSortedMap", "ScaledBWImageFromBWIntegralImage", "HInitWebSocket", "PtSet", "MultiSetMap", "Var", "ClassNameResolver", "Best_comparable", "Scorer", "ITokCondition", "PopupMenuMaker", "CountingOutputStream", "INumberOfPixels", "Matrix", "SynchronizedRandomAccessList", "PrecisePolygon", "RunResultWithTimestamps", "ConceptChange", "AbstractProfiler", "CompactAbstractMap", "ExpNot", "TripletLSFR", "BitBuffer", "Fail", "WeakIdentityHashSet", "FunctionTimings", "ISetter", "DoneFlag", "RSTOverQ", "AIStrategy", "IResolvableClass", "SubMatrix", "ScannedBot", "ByteIO", "SimplyLinkedList", "AIStrategy_RandomWithVariation", "WebServable", "FPSCounter", "MechMode", "NotifyingStringBuffer", "IF2_Int", "VolatileImageMakerForComponent", "CompactHashMap", "IProbabilistic", "JVolatileImageSurface", "Complex", "RasterBars", "MultiMap", "RSTVar", "ProbabilisticScheduler", "CriticalAction", "JImageSwitch", "IResourceLoader", "WeakHasherMap", "Either", "Ratio", "FunctionCall", "PosterizeBufferedImage", "NotifyingSet", "CompilerBot", "JMenuScroller", "CharInToken", "ImageFileFilter", "ScalingImageOpResult", "MRUCache", "Angle", "Scored", "IIBWVirtualClip", "HashBWImage", "PadImageToAspectRatio", "VF1", "VF2", "JE_RepElement", "SynchronizedFloatBufferPresentingAsDoubles", "ICachedJavaXExpr", "IStackWithOptions", "RightAlignedLine", "GlobalID", "FastRegions_Hi15Image", "findCodeTokens_Matcher", "Unstructurer", "IntSize", "tempAdd_undo", "FieldVar", "JFastLogView_noWrap", "SimpleLeftToRightParser", "WebSocketFrame", "TimeoutException", "JEInstantCompressor_AnyType", "IRef", "ByteHead", "NotifyingStringBufferRotator", "Flag", "generalizedCIComparator_C", "IRecognizedRegion", "UniquifyUsingHasher", "BijectiveMap", "VStackComputableWithStep", "Producer", "Gazelle22_ImageToRegions", "CountHolesInRegion", "SourceTriggeredStream", "IProgressShower", "tempRememberListener_c", "talkTo_IO", "FlexibleVarContext", "ButtonImageLoader", "RollingAverage", "Timed", "ECJError", "UpdateTrigger", "NanoHTTPD", "ImageStreamFromVideoFile", "IContentsIndexedList", "IMakeEmptyClone", "LetterLayout", "StringIO", "BlockDiffer", "DeQ", "IF1_ObjectToDouble", "SynchronizedMap", "Decolorizer", "CompressionSearch_AnyType", "InstantNeverHideToolTip", "AbstractBufferedImageOp", "WebSocketHTTPD", "Test_ImageInfiller", "WrappedMap", "LongBuffer", "IBStack", "ListCellRendererWithToolTip", "ImageSurfaceDragger", "AbstractBorderTracer", "JavaXPeepholeShortener", "JavaXClassLoaderWithParent", "Transformable", "ClearForAutoRun", "ExplodedLine", "SurfaceShowingAutoZoomedImage", "FitImageInComponentRenderable", "ScaledBufferedImageFromIntegralImage", "Android3", "ComponentDragger", "OnePath", "IBackgroundProcess");

  static public List<String> myInnerClasses() {
    return myInnerClasses_list;
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public void _handleError(Error e) {
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != l(args)) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(Object... objects) {
    throw new Fail(objects);
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return strOrEmpty(first((Collection) strings));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(strOrEmpty(i.next()));
      while (i.hasNext()) buf.append(glue).append(strOrEmpty(i.next()));
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(String glue, Object... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(Object... c) {
    return join(" ", c);
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !regionMatches(s, j, "*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j < l && !regionMatches(s, j, "]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !regionMatches(s, j, "]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public boolean get(BitSet bs, int idx) {
    return bs != null && bs.get(idx);
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public void set(BitSet bs, int idx) {
    {
      if (bs != null)
        bs.set(idx);
    }
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject) {
        setDyn(((DynamicObject) o), field, value);
        return;
      }
      if (o instanceof IMeta)
        setDyn(((IMeta) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(A a, IVF1<A> f) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(IVF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF(Object f, Object... args) {
    return safeCallF(f, args);
  }

  static public Object safeCallF(Object f, Object... args) {
    if (f instanceof Runnable) {
      ((Runnable) f).run();
      return null;
    }
    if (f == null)
      return null;
    Class c = f.getClass();
    ArrayList<Method> methods;
    synchronized (callF_cache) {
      methods = callF_cache.get(c);
      if (methods == null)
        methods = callF_makeCache(c);
    }
    int n = l(methods);
    if (n == 0) {
      if (f instanceof String)
        throw fail("Legacy call: " + f);
      throw fail("No get method in " + getClassName(c));
    }
    if (n == 1)
      return invokeMethod(methods.get(0), f, args);
    for (int i = 0; i < n; i++) {
      Method m = methods.get(i);
      if (call_checkArgs(m, args, false))
        return invokeMethod(m, f, args);
    }
    throw fail("No matching get method in " + getClassName(c));
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public Object callOpt(Object o, String method, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public Map<String, UniqueString> uniqueString_map = weakHashMap();

  static public UniqueString uniqueString(String s) {
    if (s == null)
      return null;
    synchronized (uniqueString_map) {
      UniqueString us = uniqueString_map.get(s);
      if (us == null)
        uniqueString_map.put(s, us = new UniqueString(s, true));
      return us;
    }
  }

  static public UniqueString uniqueString(CharSequence s) {
    return s == null ? null : uniqueString(str(s));
  }

  static public FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  static public FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return vmBus_timerStarted(timer);
  }

  static public FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  static public FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JLabel jlabel(final String text) {
    return swingConstruct(BetterLabel.class, text);
  }

  static public JLabel jlabel() {
    return jlabel(" ");
  }

  static public JTextArea newTypeWriterTextArea() {
    return newTypeWriterTextArea("");
  }

  static public JTextArea newTypeWriterTextArea(String text) {
    return withTypeWriterFont(jTextArea(text));
  }

  static public String struct(Object o) {
    return structure(o);
  }

  static public String struct(Object o, structure_Data data) {
    return structure(o, data);
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public String loadPageSilentlyWithTimeout(double timeoutSeconds, String url) {
    return loadPageSilentlyWithTimeout(url, toMS_int(timeoutSeconds));
  }

  static public String loadPageSilentlyWithTimeout(int timeout, String url) {
    return loadPageSilentlyWithTimeout(url, timeout);
  }

  static public String loadPageSilentlyWithTimeout(String url, int timeout) {
    try {
      url = loadPage_preprocess(url);
      URL _url = new URL(url);
      return loadPage(setURLConnectionTimeouts(_url.openConnection(), timeout), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean loadPageWithUserAgent_verbose = false;

  static public String loadPageWithUserAgent(String url, String userAgent) {
    try {
      URL tURL = new URL(url);
      URLConnection conn = tURL.openConnection();
      conn.setRequestProperty("User-Agent", userAgent);
      loadPage_anonymous = true;
      if (loadPageWithUserAgent_verbose)
        print("Loading as " + userAgent + ": " + hideCredentials(url));
      return loadPage(conn, tURL);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public Object cget(Object c, String field) {
    c = derefRef(c);
    Object o = getOpt(c, field);
    return derefRef(o);
  }

  static public Object cget(String field, Object c) {
    return cget(c, field);
  }

  static public int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_csetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cset(Iterable<? extends Concept> l, Object... values) {
    int changes = 0;
    for (Concept c : unnullForIteration(l)) changes += cset(c, values);
    return changes;
  }

  static public <A extends Concept> int cset(Concept.Ref<A> c, Object... values) {
    return cset(getVar(c), values);
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static public boolean printAlsoToSystemOut = true;

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print(combinePrintParameters(s, o));
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    try {
      Object f = getThreadLocal(print_byThread_dontCreate());
      if (f == null)
        f = print_allThreads;
      if (f != null)
        if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
          return;
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
    }
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    if (printAlsoToSystemOut)
      System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public List<VF1<Map>> _threadInfo_makers = synchroList();

  static public Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  static public List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  static public void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  static public void _threadInfo_addMakerAndRetriever(VF1<Map> maker, VF1<Map> retriever) {
    _threadInfo_makers.add(maker);
    _threadInheritInfo_retrievers.add(retriever);
  }

  static public boolean match(String pat, String s) {
    return match3(pat, s);
  }

  static public boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  static public boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  static public Field getField(Object o, String field) {
    if (o == null)
      return null;
    return setOpt_findField(_getClass(o), field);
  }

  static public Object getField(Field field, Object o) {
    return fieldGet(field, o);
  }

  static public Class fieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getType();
  }

  static public String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (vm_generalMap()) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public Map vm_generalWeakSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  static public <A extends JComponent> A bindToComponent(A component, Runnable onShow, Runnable onUnShow) {
    {
      swing(() -> {
        final Var<Boolean> flag = new Var<>(false);
        component.addAncestorListener(new AncestorListener() {

          public void ancestorAdded(AncestorEvent event) {
            if (flag.get())
              print("Warning: bindToComponent logic failure");
            flag.set(true);
            pcallF(onShow);
          }

          public void ancestorRemoved(AncestorEvent event) {
            if (!flag.get())
              print("Warning: bindToComponent logic failure");
            flag.set(false);
            pcallF(onUnShow);
          }

          public void ancestorMoved(AncestorEvent event) {
          }
        });
        if (component.isShowing()) {
          flag.set(true);
          pcallF(onShow);
        }
      });
    }
    return component;
  }

  static public <A extends JComponent> A bindToComponent(A component, Runnable onShow) {
    return bindToComponent(component, onShow, null);
  }

  static public <A extends JComponent, B> A bindToComponent(A component, IF0<B> onShow, IVF1<B> onUnShow) {
    Var<B> b = new Var();
    return bindToComponent(component, () -> b.set(onShow.get()), () -> {
      try {
        onUnShow.get(b.get());
      } finally {
        b.set(null);
      }
    });
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
      if (addHeaders)
        try {
          if (!loadPage_anonymous)
            setHeaders(con);
          if (loadPage_allowGzip)
            con.setRequestProperty("Accept-Encoding", "gzip");
          con.setRequestProperty("X-No-Cookies", "1");
          for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
        } catch (Throwable e) {
        }
      return loadPage(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URLConnection con) {
    try {
      Long limit = optPar(loadPage_sizeLimit);
      URL url = con.getURL();
      vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
      loadPage_responseHeaders.set(con.getHeaderFields());
      InputStream in = null;
      try {
        in = urlConnection_getInputStream(con);
        if (loadPage_debug)
          print("Put stream in map: " + currentThread());
        String contentType = con.getContentType();
        if (contentType == null) {
          throw new IOException("Page could not be read: " + hideCredentials(url));
        }
        String charset = loadPage_charset == null ? null : loadPage_charset.get();
        if (charset == null)
          charset = loadPage_guessCharset(contentType);
        if ("gzip".equals(con.getContentEncoding())) {
          if (loadPage_debug)
            print("loadPage: Using gzip.");
          in = newGZIPInputStream(in);
        }
        Reader r;
        try {
          r = new InputStreamReader(in, unquote(charset));
        } catch (UnsupportedEncodingException e) {
          print(toHex(utf8(charset)));
          throw e;
        }
        boolean silent = isTrue(loadPage_silent.get());
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (limit == null || n < limit) {
          ping();
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
          if (!silent && (n % loadPage_verboseness) == 0)
            print("  " + n + " chars read");
        }
        return buf.toString();
      } finally {
        if (loadPage_debug)
          print("loadPage done");
        vm_generalSubMap("URLConnection per thread").remove(currentThread());
        if (in != null)
          in.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public String loadPage_utf8(URL url) {
    return loadPage_utf8(url.toString());
  }

  static public String loadPage_utf8(String url) {
    AutoCloseable __1 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(url);
    } finally {
      _close(__1);
    }
  }

  static public String loadPage_utf8(URLConnection con, URL url, boolean addHeaders) throws IOException {
    AutoCloseable __2 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(con, url, addHeaders);
    } finally {
      _close(__2);
    }
  }

  static public boolean preferCached = false;

  static public boolean loadSnippet_debug = false;

  static public ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();

  static public ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();

  static public int loadSnippet_timeout = 30000;

  static public String loadSnippet(Snippet s) {
    return loadSnippet(s.id);
  }

  static public String loadSnippet(String snippetID) {
    try {
      if (snippetID == null)
        return null;
      return loadSnippet(parseSnippetID(snippetID), preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(String snippetID, boolean preferCached) throws IOException {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  }

  static public IF1<Long, String> loadSnippet;

  static public String loadSnippet(long snippetID) {
    return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID);
  }

  final static public String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) {
    return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID);
  }

  static public String loadSnippet_base(long snippetID) {
    try {
      return loadSnippet(snippetID, preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(long snippetID, boolean preferCached) throws IOException {
    if (isLocalSnippetID(snippetID))
      return loadLocalSnippet(snippetID);
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadSnippet(fsI(snippetID));
    return loadSnippet_noResourceLoader(snippetID, preferCached);
  }

  static public String loadSnippet_noResourceLoader(long snippetID, boolean preferCached) throws IOException {
    String text;
    initSnippetCache();
    text = DiskSnippetCache_get(snippetID);
    if (preferCached && text != null)
      return text;
    try {
      if (loadSnippet_debug && text != null)
        System.err.println("md5: " + md5(text));
      String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
      if (nempty(text))
        url += "&md5=" + md5(text);
      if (!isTrue(loadSnippet_publicOnly.get()))
        url += standardCredentials();
      String text2 = loadSnippet_loadFromServer(url);
      boolean same = eq(text2, "==*#*==");
      if (loadSnippet_debug)
        print("loadSnippet: same=" + same);
      if (!same)
        text = text2;
    } catch (RuntimeException e) {
      e.printStackTrace();
      throw new IOException("Snippet #" + snippetID + " not found or not public");
    }
    try {
      initSnippetCache();
      DiskSnippetCache_put(snippetID, text);
    } catch (IOException e) {
      System.err.println("Minor warning: Couldn't save snippet to cache (" + DiskSnippetCache_getDir() + ")");
    }
    return text;
  }

  static public File DiskSnippetCache_dir;

  public static void initDiskSnippetCache(File dir) {
    DiskSnippetCache_dir = dir;
    dir.mkdirs();
  }

  public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
    return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
  }

  private static File DiskSnippetCache_getFile(long snippetID) {
    return new File(DiskSnippetCache_dir, "" + snippetID);
  }

  public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
    saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
  }

  public static File DiskSnippetCache_getDir() {
    return DiskSnippetCache_dir;
  }

  public static void initSnippetCache() {
    if (DiskSnippetCache_dir == null)
      initDiskSnippetCache(getGlobalCache());
  }

  static public String loadSnippet_loadFromServer(String url) {
    Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
    try {
      return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
    } finally {
      loadPage_forcedTimeout_byThread.set(oldTimeout);
    }
  }

  static public String loadSnippetQuietly(Snippet s) {
    return loadSnippetQuietly(s.id);
  }

  static public String loadSnippetQuietly(String snippetID) {
    loadSnippet_silent.set(true);
    try {
      return loadSnippet(snippetID);
    } finally {
      loadSnippet_silent.set(null);
    }
  }

  static public String sendToLocalBot(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        print(bot + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(bot + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBot(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        print(port + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(port + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public JTable sexyTableWithoutDrag() {
    final JTable table = tableWithToolTips();
    tablePopupMenu(table, sexyTableWithoutDrag_popupMenuMaker(table));
    table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_FOCUSED).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    ((InputMap) UIManager.get("Table.ancestorInputMap")).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    return table;
  }

  static public VF2<JPopupMenu, Integer> sexyTableWithoutDrag_popupMenuMaker(JTable t) {
    final WeakReference<JTable> ref = weakRef(t);
    return new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, Integer row) {
        try {
          final JTable table = ref.get();
          final String item = first(getTableLine(table, row));
          MouseEvent e = tablePopupMenu_mouseEvent.get();
          final int col = table.columnAtPoint(e.getPoint());
          final Object value = table.getModel().getValueAt(row, col);
          if (value instanceof ImageIcon) {
            addMenuItem(menu, "Copy image to clipboard", new Runnable() {

              public void run() {
                try {
                  copyImageToClipboard(((ImageIcon) value).getImage());
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyImageToClipboard(((ImageIcon) value).getImage());";
              }
            });
          } else {
            final String text = str(value);
            addMenuItem(menu, "Copy text to clipboard", new Runnable() {

              public void run() {
                try {
                  copyTextToClipboard(text);
                  print("Copied text to clipboard: " + quote(text));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyTextToClipboard(text);\r\n        print(\"Copied text to clipboard: \" + quot...";
              }
            });
          }
          addMenuItem(menu, "Set row height...", new Runnable() {

            public void run() {
              try {
                final JTextField tf = jTextField(table.getRowHeight());
                showTitledForm("Set row height", "Pixels", tf, new Runnable() {

                  public void run() {
                    try {
                      table.setRowHeight(parseInt(trim(tf.getText())));
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "table.setRowHeight(parseInt(trim(tf.getText())))";
                  }
                });
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "final JTextField tf = jTextField(table.getRowHeight());\r\n      showTitledForm...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTable table = ref!;\r\n    final S item = first(getTableLine(table, row)...";
      }
    };
  }

  static public class tablePopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JTable, tablePopupMenu_Maker> tablePopupMenu_map = newWeakHashMap();

  static public ThreadLocal<MouseEvent> tablePopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> tablePopupMenu_first = new ThreadLocal();

  static public void tablePopupMenu(final JTable table, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(tablePopupMenu_first));
    {
      swing(() -> {
        tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);
        if (maker == null) {
          tablePopupMenu_map.put(table, maker = new tablePopupMenu_Maker());
          final tablePopupMenu_Maker _maker = maker;
          table.addMouseListener(new MouseAdapter() {

            public void mousePressed(MouseEvent e) {
              displayMenu(e);
            }

            public void mouseReleased(MouseEvent e) {
              displayMenu(e);
            }

            public void displayMenu(MouseEvent e) {
              if (!e.isPopupTrigger())
                return;
              JPopupMenu menu = new JPopupMenu();
              int row = table.rowAtPoint(e.getPoint());
              if (table.getSelectedRowCount() < 2)
                table.setRowSelectionInterval(row, row);
              int modelRow = convertTableRowToModel(table, row);
              int emptyCount = menu.getComponentCount();
              tablePopupMenu_mouseEvent.set(e);
              for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, modelRow);
              vmBus_send("showingPopupMenu", table, menu);
              if (menu.getComponentCount() != emptyCount)
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
          });
        }
        if (first)
          maker.menuMakers.add(0, menuMaker);
        else
          maker.menuMakers.add(menuMaker);
      });
    }
  }

  static public void tablePopupMenuFirst(JTable table, final Object menuMaker) {
    tablePopupMenu_first.set(true);
    tablePopupMenu(table, menuMaker);
  }

  static public void tablePopupMenuFirst(JTable table, IVF2<JPopupMenu, Integer> menuMaker) {
    tablePopupMenuFirst(table, (Object) menuMaker);
  }

  static public ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent;

  static public void componentPopupMenu_init() {
    {
      swing(() -> {
        if (componentPopupMenu_mouseEvent == null)
          componentPopupMenu_mouseEvent = (ThreadLocal<MouseEvent>) vm_generalMap_get("mouseEvent");
        if (componentPopupMenu_mouseEvent == null)
          vm_generalMap_put("componentPopupMenu_mouseEvent", componentPopupMenu_mouseEvent = new ThreadLocal());
      });
    }
  }

  static public void componentPopupMenu(final JComponent component, IVF1<JPopupMenu> menuMaker) {
    componentPopupMenu(component, (Object) menuMaker);
  }

  static public void componentPopupMenu(final JComponent component, final Object menuMaker) {
    if (component == null || menuMaker == null)
      return;
    {
      swing(() -> {
        Object adapter = componentPopupMenu_initForComponent(component);
        ((List) _get(adapter, "maker")).add(menuMaker);
      });
    }
  }

  static public Object componentPopupMenu_initForComponent(final JComponent component) {
    return component == null ? null : swing(new F0<Object>() {

      public Object get() {
        try {
          componentPopupMenu_init();
          Object adapter = findComponentPopupMenuListener_gen(component);
          if (adapter == null) {
            componentPopupMenu_Adapter a = new componentPopupMenu_Adapter();
            component.addMouseListener(a);
            adapter = a;
          }
          return adapter;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "componentPopupMenu_init();\r\n    O adapter = findComponentPopupMenuListener_ge...";
      }
    });
  }

  static public class componentPopupMenu_Adapter extends MouseAdapter {

    public List maker = new ArrayList();

    public boolean internalFrameLeftButtonMagic = false;

    public boolean allowScrolling = true;

    public Point pressedAt;

    public void mousePressed(MouseEvent e) {
      displayMenu(e);
      pressedAt = internalFrameLeftButtonMagic && e.getClickCount() == 1 && internalFrameActive(e.getComponent()) ? e.getLocationOnScreen() : null;
    }

    public void mouseReleased(MouseEvent e) {
      if (internalFrameLeftButtonMagic && eq(pressedAt, e.getLocationOnScreen()))
        displayMenu2(e);
      else
        displayMenu(e);
    }

    public void displayMenu(MouseEvent e) {
      if (e.getSource() instanceof JInternalFrame)
        return;
      if (e.isPopupTrigger())
        displayMenu2(e);
    }

    public void populate(JPopupMenu menu, MouseEvent e) {
      AutoCloseable __1 = tempSetTL(componentPopupMenu_mouseEvent, e);
      try {
        for (Object menuMaker : maker) pcallF(menuMaker, menu);
        vmBus_send("showingPopupMenu", e.getComponent(), menu);
      } finally {
        _close(__1);
      }
    }

    public void displayMenu2(MouseEvent e) {
      new PopupMenuMaker(e, menu -> populate(menu, e)).allowScrolling(allowScrolling).run();
    }
  }

  static public void componentPopupMenu_top(final JComponent component, final VF1<JPopupMenu> menuMaker) {
    if (component != null && menuMaker != null) {
      swing(() -> {
        Object adapter = componentPopupMenu_initForComponent(component);
        ((List) get(adapter, "maker")).add(0, menuMaker);
      });
    }
  }

  static public MouseEvent componentPopupMenu_getEvent() {
    return componentPopupMenu_mouseEvent.get();
  }

  static public Object dm_current_generic() {
    return getWeakRef(dm_current_generic_tl().get());
  }

  static public Object dm_current_mandatory_generic() {
    return assertNotNull("No module set", dm_current_generic());
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public void makePopupMenuConditional(JComponent c, F0<Boolean> condition) {
    if (c != null && condition != null) {
      swing(() -> {
        componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListeners(), componentPopupMenu_Adapter.class);
        c.removeMouseListener(adapter);
        c.addMouseListener(new MouseAdapter() {

          public void mousePressed(MouseEvent e) {
            if (!callF(condition))
              adapter.mousePressed(e);
          }

          public void mouseReleased(MouseEvent e) {
            if (!callF(condition))
              adapter.mouseReleased(e);
          }
        });
      });
    }
  }

  static public boolean dynamicObjectIsLoading() {
    return isUnstructuring();
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public void rowSorter_setComparators(JTable table, final Object... params) {
    setTableModel_fixSorter.put(table, new VF2<JTable, RowSorter>() {

      public void get(JTable table, RowSorter sorter) {
        try {
          if (sorter instanceof TableRowSorter) {
            for (Pair<Integer, Comparator> p : (List<Pair<Integer, Comparator>>) (List) paramsToPairs(params)) ((TableRowSorter) sorter).setComparator(p.a, p.b);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "//print(\"Fixing table sorter\");\r\n    if (sorter cast TableRowSorter) {\r\n     ...";
      }
    });
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public int year() {
    return localYear();
  }

  static public int year(Timestamp now) {
    return localYear(toLong(now));
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public <A> WithTimestamp<A> withTimestamp(A value) {
    return withTimestamp(now(), value);
  }

  static public <A> WithTimestamp<A> withTimestamp(long timestamp, A value) {
    return new WithTimestamp(timestamp, value);
  }

  static public ICachedJavaXExpr javaObjectToIJavaExpr(Object o) {
    if (isListOfElementType(Integer.class, o))
      return javaExpr(functionCall("lInts", naiveQuote(intsToHex_withLineBreaks((List<Integer>) o))), () -> o);
    if (o instanceof List)
      return javaExpr(functionCall("ll", map(__88 -> javaObjectToIJavaExpr(__88), (List) o)), () -> ((List) o));
    Object code = toJavaOpt(o);
    return javaExpr(code, () -> o);
  }

  static public <A, B> List<B> lambdaMapMethod(IF1<A, B> f, Iterable<A> l) {
    return lambdaMethodMap(f, l);
  }

  static public <A, B> List<B> lambdaMapMethod(IF1<A, B> f, A[] l) {
    return lambdaMethodMap(f, l);
  }

  static public double negativeInfinity() {
    return Double.NEGATIVE_INFINITY;
  }

  static public F1 mainFunctionToF1(final String fname) {
    return new F1<Object, Object>() {

      public Object get(Object a) {
        try {
          return callMC(fname, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callMC(fname, a)";
      }
    };
  }

  static public float score(Scored s) {
    return s == null ? 0 : s.score();
  }

  static public Set<String> isThreadRunnable_x_exclude = lithashset("sun.nio.fs.WindowsNativeDispatcher.GetQueuedCompletionStatus0", "Java.lang.Thread.start0", "java.lang.Object.wait", "java.net.Inet6AddressImpl.lookupAllHostAddr", "java.io.FileInputStream.readBytes", "jdk.internal.misc.Unsafe.park", "sun.misc.Unsafe.park", "java.net.SocketInputStream.socketRead0", "java.net.PlainSocketImpl.socketConnect", "java.net.PlainSocketImpl.socketAccept", "sun.awt.X11.XToolkit.waitForEvents", "java.net.DualStackPlainSocketImpl.accept0", "org.jnativehook.GlobalScreen$NativeHookThread.enable", "java.lang.Thread.sleep", "sun.nio.ch.EPollArrayWrapper.epollWait", "com.ibm.lang.management.internal.MemoryNotificationThread.processNotificationLoop", "com.ibm.tools.attach.target.IPC.waitSemaphore", "sun.nio.ch.Net.poll", "sun.nio.ch.Net.accept", "sun.nio.ch.Net.connect0", "sun.nio.ch.EPoll.wait", "sun.nio.ch.SocketDispatcher.read0", "sun.nio.fs.LinuxWatchService.poll", "java.lang.ref.Reference.waitForReferencePendingList", "com.sun.java.accessibility.internal.AccessBridge.runDLL", "java.lang.ProcessHandleImpl.waitForProcessExit0");

  static public boolean isThreadRunnable_x(StackTraceElement[] trace) {
    StackTraceElement e = first(trace);
    if (e == null)
      return false;
    String s = e.getClassName() + "." + e.getMethodName();
    return !isThreadRunnable_x_exclude.contains(s);
  }

  static public boolean isThreadRunnable_x(Thread t, StackTraceElement[] trace) {
    {
      Boolean __1 = (Boolean) vmBus_query("isThreadRunnable_x", t, trace);
      if (__1 != null)
        return __1;
    }
    if (t.getState() != Thread.State.RUNNABLE)
      return false;
    return isThreadRunnable_x(trace);
  }

  static public RuntimeException asQuickException(Throwable t) {
    return t instanceof RuntimeException ? (RuntimeException) t : new QuickException(t);
  }

  static public long stepAll(Steppable s) {
    long steps = 0;
    if (s != null) {
      var pingSource = pingSource();
      while (true) {
        ping(pingSource);
        if (s.step())
          ++steps;
        else
          break;
      }
    }
    return steps;
  }

  static public void poorMansProfiling_stopAndPrintResults() {
    poorMansProfiling_renderFullResults_backwards.set(true);
    print(poorMansProfiling_stopAndRenderResults());
  }

  static public boolean isRunnableX(Object o) {
    if (o == null)
      return false;
    if (o instanceof String)
      return hasMethod(mc(), (String) o);
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public JTextArea wrappedTextArea(final JTextArea ta) {
    enableWordWrapForTextArea(ta);
    return ta;
  }

  static public JTextArea wrappedTextArea() {
    return wrappedTextArea(jtextarea());
  }

  static public JTextArea wrappedTextArea(String text) {
    JTextArea ta = wrappedTextArea();
    setText(ta, text);
    return ta;
  }

  static public boolean infoMessage_alwaysOnTop = true;

  static public double infoMessage_defaultTime = 5.0;

  static public JWindow infoMessage(String text) {
    return infoMessage(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage(final String text, final double seconds) {
    printHidingCredentials(text);
    return infoMessage_noprint(text, seconds);
  }

  static public JWindow infoMessage_noprint(String text) {
    return infoMessage_noprint(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage_noprint(final String _text, final double seconds) {
    final String text = hideCredentials(_text);
    if (empty(text))
      return null;
    logQuotedWithDate(infoBoxesLogFile(), text);
    if (isHeadless())
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JWindow window = makeWindow(infoMessage_makePanel(text));
          window.setSize(300, 150);
          moveToTopRightCorner(window);
          if (infoMessage_alwaysOnTop)
            window.setAlwaysOnTop(true);
          if (vmBus_noObjections("shouldShowInfoBox", window, text))
            window.setVisible(true);
          if (seconds != 0)
            disposeWindowAfter(iround(seconds * 1000), window);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JWindow window = makeWindow(infoMessage_makePanel(text));\r\n    window.setSize...";
      }
    });
  }

  static public JWindow infoMessage(Throwable e) {
    printStackTrace(e);
    return infoMessage(exceptionToStringShort(e));
  }

  static public int brightnessToRGBA(int brightness) {
    return 0xFF000000 | clamp(brightness, 0, 255) * 0x010101;
  }

  static public JPanel withBorder(javax.swing.border.Border border, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(border);
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(border);\r\n    p.add...";
      }
    });
  }

  static public Set<String> getPlural_specials = litciset("sheep", "fish");

  static public String getPlural(String s) {
    if (contains(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public boolean hasLetters(String s) {
    for (int i = 0; i < s.length(); i++) if (Character.isLetter(s.charAt(i)))
      return true;
    return false;
  }

  static public <A> List<A> sorted(Collection<A> c, Object comparator) {
    List<A> l = cloneList(c);
    sort(l, makeComparator(comparator));
    return l;
  }

  static public <A> List<A> sorted(Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l);
    return l;
  }

  static public <A> List<A> sorted(Comparator<A> comparator, Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l, comparator);
    return l;
  }

  static public Map<String, Font> loadFont_cached_cache = new HashMap();

  static synchronized public Font loadFont_cached(String snippetID) {
    try {
      snippetID = formatSnippetID(snippetID);
      Font f = loadFont_cached_cache.get(snippetID);
      if (f == null)
        loadFont_cached_cache.put(snippetID, f = loadFont(snippetID, 12f));
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static synchronized public Font loadFont_cached(String snippetID, float size) {
    try {
      return loadFont_cached(snippetID).deriveFont(size);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public Object rcallOpt(String method, Object o, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public void hideConsole() {
    final JFrame frame = consoleFrame();
    if (frame != null) {
      autoVMExit();
      swingLater(new Runnable() {

        public void run() {
          try {
            frame.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setVisible(false);";
        }
      });
    }
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i >= j)
      return "";
    return s.substring(i, j);
  }

  static public boolean machineIsOffline() {
    return isFalse(callF(vmGeneralMap_get("areWeOnline")));
  }

  static public Set<String> getClassDeclarationName_skippables_cache;

  static public Set<String> getClassDeclarationName_skippables() {
    if (getClassDeclarationName_skippables_cache == null)
      getClassDeclarationName_skippables_cache = getClassDeclarationName_skippables_load();
    return getClassDeclarationName_skippables_cache;
  }

  static public Set<String> getClassDeclarationName_skippables_load() {
    return litset("noeq", "mapMethodLike");
  }

  static public <A> List<A> childrenOfType(Component c, Class<A> theClass) {
    List<A> l = new ArrayList();
    scanForComponents(c, theClass, l);
    return l;
  }

  static public <A> List<A> childrenOfType(Class<A> theClass, Component c) {
    return childrenOfType(c, theClass);
  }

  static public void dm_reloadModuleInBackground(Object module) {
    dm_callOS("reloadModuleInBackground", dm_getStem(module));
  }

  static public void dm_reloadModuleInBackground() {
    dm_reloadModuleInBackground(dm_current_mandatory_generic());
  }

  static public ThreadLocal<Boolean> poorMansProfiling_renderFullResults_backwards = new ThreadLocal();

  static public String poorMansProfiling_renderFullResults(final MultiSet<String> traces) {
    int samples = poorMansProfiling_samples;
    boolean backwards = isTrue(getAndClearThreadLocal(poorMansProfiling_renderFullResults_backwards));
    final int n = traces.size();
    int percent = ratioToIntPercent(l(traces), samples);
    return (samples == 0 ? "Nothing sampled" : percent + "% core activity [" + n2(samples, "sample") + " taken]") + "\n\n" + joinMap(backwards ? traces.lowestFirst() : traces.highestFirst(), new F1<String, Object>() {

      public Object get(String trace) {
        try {
          return traces.get(trace) + "/" + n + "\n" + trace + "\n\n";
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "traces.get(trace) + \"/\" + n + \"\\n\" + trace + \"\\n\\n\"";
      }
    });
  }

  static public String unCurlyBracket(String s) {
    return tok_unCurlyBracket(s);
  }

  static public Pair<File, String> compileSnippetThroughServer(String progID) {
    String transpiledSrc = getServerTranspiled2(progID);
    String md5 = md5(transpiledSrc + "\n" + progID);
    File jar = CompilerBot.getJarFile(md5);
    if (jar == null || jar.length() <= 22) {
      byte[] jarData = null;
      boolean dontLoad = false;
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null) {
        dontLoad = true;
        File jar2 = rl.getSnippetJar(progID, transpiledSrc);
        if (jar2 != null)
          return pair(jar2, transpiledSrc);
      }
      if (!dontLoad) {
        try {
          jarData = loadBinaryPage(jarBotURL() + psI(progID) + "?md5=" + md5(transpiledSrc));
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      }
      if (!isJAR(jarData)) {
        if (jarData != null) {
          print(bytesToHex(takeFirstOfByteArray(8, jarData)));
          print("fallback to CompilerBot: " + fromUtf8(takeFirstOfByteArray(80, jarData)));
        }
        return CompilerBot.compileSnippet2(progID);
      }
      saveBinaryFile(jar, jarData);
    }
    return pair(jar, transpiledSrc);
  }

  static public String dropSpaceEtc(String s) {
    if (empty(s))
      return null;
    int n = l(s), i = 0;
    char c = s.charAt(i);
    boolean totality = !isSpaceEtc(c);
    for (++i; i < n; i++) {
      c = s.charAt(i);
      boolean b = !isSpaceEtc(c);
      if (b != totality) {
        StringBuilder buf = new StringBuilder();
        if (totality)
          buf.append(substring(s, 0, i));
        while (true) {
          ping();
          if (b)
            buf.append(c);
          if (++i >= n)
            break;
          c = s.charAt(i);
          b = !isSpaceEtc(c);
        }
        return buf.toString();
      }
    }
    return totality ? s : "";
  }

  static public ClassLoader getVirtualParent(ClassLoader cl) {
    return (ClassLoader) rcallOpt("getVirtualParent", cl);
  }

  static public boolean titlePopupMenu(final Component c, final Object menuMaker) {
    JComponent titleBar = getTitlePaneComponent(getPossiblyInternalFrame(c));
    if (titleBar == null) {
      print("Can't add title right click!");
      return false;
    } else {
      componentPopupMenu(titleBar, menuMaker);
      return true;
    }
  }

  static public <A, B> boolean isA(Either<A, B> e) {
    return eitherIsA(e);
  }

  static public long nanoTime() {
    return System.nanoTime();
  }

  static public int activateFrame_v3_delay = 100;

  static public boolean activateFrame_v3(Component c, Object... __) {
    return swing(() -> {
      Frame f = getAWTFrame(c);
      if (f == null)
        return false;
      if (!f.isVisible())
        f.setVisible(true);
      int state = f.getState();
      boolean iconified = state == Frame.ICONIFIED;
      boolean maximize = boolPar("maximize", __);
      if (iconified)
        f.setState(maximize ? Frame.MAXIMIZED_BOTH : Frame.NORMAL);
      else {
        f.setState(Frame.ICONIFIED);
        print("Restoring frame in " + activateFrame_v3_delay + " ms");
        doLater(activateFrame_v3_delay, new Runnable() {

          public void run() {
            try {
              f.setState(state);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "f.setState(state)";
          }
        });
      }
      f.toFront();
      return true;
    });
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public Set vm_generalWeakSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = newWeakHashSet());
      return set;
    }
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public boolean isCurlyBraced(String s) {
    List<String> tok = tok_combineCurlyBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "{", "}");
  }

  static public String b(Object contents, Object... params) {
    return fulltag("b", contents, params);
  }

  static public File findCmdOnPATH(String cmd) {
    String path = System.getenv("PATH");
    List<String> dirs = splitAt(path, File.pathSeparator);
    String c = isWindows() ? addSuffix(cmd, ".exe") : cmd;
    for (String dir : dirs) {
      File f = new File(dir, c);
      if (f.isFile())
        return f;
    }
    return null;
  }

  static public File tempDirPossiblyInRAMDisk() {
    File f = linux_fileInRamDisk(aGlobalID());
    if (f != null) {
      f.mkdirs();
      return f;
    }
    return makeTempDir();
  }

  static public int javaxIncludeSnippetType() {
    return 42;
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public Pt bottomRightCorner(Rect r) {
    return r == null ? null : pt(r.x2(), r.y2());
  }

  static public FixedRateTimer doEvery_daemon(long delay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, final Object r) {
    return doEvery_daemon(timerName, delay, delay, r);
  }

  static public FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, firstDelay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(true);
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
    return timer;
  }

  static public FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
    return doEvery_daemon(toMS(delaySeconds), r);
  }

  static public void pClose(AutoCloseable c) {
    close_pcall(c);
  }

  static public void closeRandomAccessFile(RandomAccessFile f) {
    if (f != null)
      try {
        f.close();
        callJavaX("dropIO", f);
      } catch (Throwable e) {
        printStackTrace(e);
      }
  }

  static public JPanel jCenteredSection(Component c) {
    return jCenteredSection("", c);
  }

  static public JPanel jCenteredSection(String title, Swingable c) {
    return jCenteredSection(title, wrap(c));
  }

  static public JPanel jCenteredSection(String title, Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = jSection(title, c);
          ((TitledBorder) p.getBorder()).setTitleJustification(TitledBorder.CENTER);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = jSection(title, c);\r\n    ((TitledBorder) p.getBorder()).setTitleJu...";
      }
    });
  }

  static public JPanel jCenteredSection(String title) {
    return jCenteredSection(title, jpanel());
  }

  static public Comparator makeComparator(final Object f) {
    if (f instanceof Comparator)
      return (Comparator) f;
    return new Comparator() {

      public int compare(Object a, Object b) {
        return (Integer) callF(f, a, b);
      }
    };
  }

  static public String manifestTextForMainClass(String mainClass) {
    return "Manifest-Version: 1.0\n" + "Main-Class: " + mainClass + "\n\n";
  }

  static public JLabel dm_fieldLabel(String fieldName) {
    return jLiveValueLabel(dm_fieldLiveValue(fieldName));
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    int n = s.length();
    StringBuilder out = null;
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (c == '<') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&lt;");
      } else if (c == '>') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&gt;");
      } else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else {
        if (out != null)
          out.append(c);
      }
    }
    return out == null ? s : out.toString();
  }

  static public Window dm_window(Object module) {
    return getWindow(dm_vis(module));
  }

  static public class IVF1WithToString<A> implements IVF1<A>, IFieldsToList {

    static final public String _fieldOrder = "toString f";

    public String toString;

    public IVF1<A> f;

    public IVF1WithToString() {
    }

    public IVF1WithToString(String toString, IVF1<A> f) {
      this.f = f;
      this.toString = toString;
    }

    public boolean equals(Object o) {
      if (!(o instanceof IVF1WithToString))
        return false;
      IVF1WithToString __1 = (IVF1WithToString) o;
      return eq(toString, __1.toString) && eq(f, __1.f);
    }

    public int hashCode() {
      int h = 574155786;
      h = boostHashCombine(h, _hashCode(toString));
      h = boostHashCombine(h, _hashCode(f));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { toString, f };
    }

    public void get(A a) {
      f.get(a);
    }

    public String toString() {
      return toString;
    }
  }

  static public <A> IVF1<A> ivf1WithToString(String toString, IVF1<A> f) {
    return f == null ? null : new IVF1WithToString<A>(toString, f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public long abs(long i) {
    return Math.abs(i);
  }

  static public float abs(float i) {
    return Math.abs(i);
  }

  static public double abs(double i) {
    return Math.abs(i);
  }

  static public double abs(Complex c) {
    return c.abs();
  }

  static public <A> void forEachWithPosition(Matrix<A> m, IVF3<Integer, Integer, A> f) {
    if (m == null || f == null)
      return;
    int w = m.getWidth(), h = m.getHeight();
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) f.get(x, y, m.get(x, y));
  }

  static public Map<Thread, StackTraceElement[]> runnableThreadsWithStackTraces() {
    Map<Thread, StackTraceElement[]> map = filterMap((__154, __155) -> isThreadRunnable_x(__154, __155), Thread.getAllStackTraces());
    map.remove(currentThread());
    return map;
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(int w, BWIntegralImage img) {
    return scaledBufferedImageFromBWIntegralImage(img, w);
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(BWIntegralImage img, int w) {
    return scaledBufferedImageFromBWIntegralImage(img, w, heightForWidth(img.w, img.h, w));
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(BWIntegralImage img, int w, int h) {
    int w1 = img.w, h1 = img.h;
    int[] pixels = new int[w * h];
    int i = 0;
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int pixel = iround(img.getPixelAverage(x1, y1, x2, y2));
      pixels[i++] = brightnessToRGBA(pixel);
    }
    return bufferedImage(w, h, pixels);
  }

  public static String winQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String winQuote(File f) {
    return winQuote(f.getAbsolutePath());
  }

  static public Map<String, String> stdFunctions_uncached() {
    return stdFunctions_uncached(new HashMap());
  }

  static public Map<String, String> stdFunctions_uncached(Map<String, String> map) {
    for (var snippetID : stdFunctionListSnippetIDs()) parseStdFunctionsList(loadSnippet(snippetID), map);
    return map;
  }

  static public boolean isJavaxModuleSnippetType(int type) {
    return type == snippetType_javaxModule() || type == snippetType_javaxDesktopModule();
  }

  static public int findEndOfBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "("))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public File prepareProgramFile(String name) {
    return mkdirsForFile(getProgramFile(name));
  }

  static public File prepareProgramFile(String progID, String name) {
    return mkdirsForFile(getProgramFile(progID, name));
  }

  static public boolean rectEmpty(Rect r) {
    return r == null || r.w <= 0 || r.h <= 0;
  }

  static public Set<String> tok_returnTypesOfStaticFunction_uncleaned(List<String> tok, String functionName) {
    List<List<String>> funcs = findFullFunctionDefs(tok, true);
    TreeSet<String> out = new TreeSet();
    for (List<String> tokF : funcs) {
      int i = indexOfAny(tokF, 0, "(", "{");
      if (i < 0)
        continue;
      String fname = get(tokF, i - 2);
      if (!eq(fname, functionName))
        continue;
      out.add(joinSubList(tokF, 1, i - 3));
    }
    return out;
  }

  static public BufferedImage intMatrixToImage(Matrix<Integer> m) {
    return intMatrixToBufferedImage(m);
  }

  static public void interruptThreads(Collection<Thread> threads) {
    for (Thread t : unnull(threads)) interruptThread(t);
  }

  static public void interruptThreads(Class mainClass) {
    interruptThreads(registeredThreads(mainClass));
  }

  static public List<File> hotwire_collectJars(File jar) {
    List<String> libIDs = hotwire_libraryIDsFromJar_deleteJarOnFail(jar);
    List<File> files = ll(jar);
    for (String libID : libIDs) files.add(loadLibraryOrSrcLib(libID));
    return files;
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public <A, B> Either<A, B> eitherB(B b) {
    return new Either(2, b);
  }

  static public String evalJava_prep(String code) {
    return evalJava_prep(code, "calc");
  }

  static public String evalJava_prep(String code, String mainName) {
    return evalJava_prep(code, mainName, "");
  }

  static public ThreadLocal<String> evalJava_prep_args = new ThreadLocal();

  static public String evalJava_prep(String code, String mainName, String preCode) {
    EvalJavaPrep prep = new EvalJavaPrep();
    List<String> tok = evalJava_prePrep(code, prep);
    code = tok_addReturn(tok);
    String returnType = containsReturnWithArgument(code) ? "Object" : "void";
    String main = lines(prep.global) + "static " + returnType + " " + mainName + "(" + unnull(evalJava_prep_args.get()) + ") throws Exception {\n" + preCode + code + "\n" + "}";
    return main;
  }

  static public <A, B> Either<A, B> eitherA(A a) {
    return new Either(1, a);
  }

  static public void markAsSrcLib(String snippetID) {
    saveTextFile(javaxCodeDir("srclibs/" + psI(snippetID)), "");
  }

  static public int lIntArray(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public ThreadLocal<Long> evalJava_myProgramID_main_time = new ThreadLocal();

  static public ThreadLocal<Object> evalJava_myProgramID_main_mainClass = new ThreadLocal();

  static public Object evalJava_myProgramID_main(String main, Object... args) {
    Object obj = veryQuickJava(main);
    setOpt(obj, "programID", programID());
    makeDependent(obj);
    if (evalJava_myProgramID_main_mainClass.get() != null)
      evalJava_myProgramID_main_mainClass.set(obj);
    return evalJava_myProgramID_main_2(obj, args);
  }

  static public Object evalJava_myProgramID_main_2(Object obj, Object... args) {
    long time = sysNow();
    try {
      return callCalc(obj, args);
    } finally {
      evalJava_myProgramID_main_time.set(sysNow() - time);
    }
  }

  static public void addMouseAndMotionListener(Component c, MouseAdapter ma) {
    if (c != null && ma != null) {
      swing(() -> {
        c.addMouseListener(ma);
        c.addMouseMotionListener(ma);
      });
    }
  }

  static public void containerAddFirst(Container c, Component... l) {
    if (c != null) {
      swing(() -> {
        for (int i = 0; i < l(l); i++) c.add(l[i], i);
        revalidate(c);
      });
    }
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public String asciiHeading2(String title) {
    return asciiHeading(title) + "\n";
  }

  static public List<Component> getComponents(final Component c) {
    return !(c instanceof Container) ? emptyList() : asList(swing(new F0<Component[]>() {

      public Component[] get() {
        try {
          return ((Container) c).getComponents();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return ((Container) c).getComponents();";
      }
    }));
  }

  static public <A> List<Pair<A, A>> paramsToPairs(A... params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToPairs((Map) params[0]);
    List<Pair<A, A>> l = emptyList(l(params) / 2);
    for (int i = 0; i + 1 < l(params); i += 2) l.add(pair(params[i], params[i + 1]));
    return l;
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public int area(Rect r) {
    return rectArea(r);
  }

  static public double area(DoubleRect r) {
    return r == null ? 0 : r.w * r.h;
  }

  static public int area(WidthAndHeight img) {
    return img == null ? 0 : img.getWidth() * img.getHeight();
  }

  static public int area(BufferedImage img) {
    return img == null ? 0 : img.getWidth() * img.getHeight();
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public long add(AtomicLong l, long b) {
    return l.addAndGet(b);
  }

  static public SingleComponentPanel singleComponentPanel() {
    return singleComponentPanel(null);
  }

  static public SingleComponentPanel singleComponentPanel(final Component c) {
    return swing(new F0<SingleComponentPanel>() {

      public SingleComponentPanel get() {
        try {
          return new SingleComponentPanel(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return new SingleComponentPanel(c);";
      }
    });
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public int withMargin_defaultWidth = 6;

  static public JPanel withMargin(Component c) {
    return withMargin(withMargin_defaultWidth, c);
  }

  static public JPanel withMargin(int w, Component c) {
    return withMargin(w, w, c);
  }

  static public JPanel withMargin(int w, int h, Component c) {
    return withMargin(w, h, w, h, c);
  }

  static public JPanel withMargin(final int top, final int left, final int bottom, final int right, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(to...";
      }
    });
  }

  static public File getCodeProgramDir() {
    return getCodeProgramDir(getProgramID());
  }

  static public File getCodeProgramDir(String snippetID) {
    return new File(javaxCodeDir(), formatSnippetID(snippetID));
  }

  static public File getCodeProgramDir(long snippetID) {
    return getCodeProgramDir(formatSnippetID(snippetID));
  }

  static public void addActionListener(JTextField tf, final Runnable action) {
    onEnter(tf, action);
  }

  static public void addActionListener(final JComboBox cb, final Runnable action) {
    if (cb != null) {
      swing(() -> {
        cb.addActionListener(actionListener(action));
      });
    }
  }

  static public void addActionListener(final AbstractButton b, final Runnable action) {
    if (b != null) {
      swing(() -> {
        b.addActionListener(actionListener(action));
      });
    }
  }

  static public Matrix<Integer> imageToMatrix(MakesBufferedImage img) {
    return imageToMatrix(toBufferedImage(img));
  }

  static public Matrix<Integer> imageToMatrix(BufferedImage img) {
    if (img == null)
      return null;
    int _w = img.getWidth(), _h = img.getHeight();
    class ImageToMatrix extends AbstractMatrix<Integer> {

      public ImageToMatrix() {
        super(_w, _h);
      }

      public Integer get(int x, int y) {
        assertPointInBounds(x, y, w, h);
        return img.getRGB(x, y);
      }

      public void set(int x, int y, Integer val) {
        assertPointInBounds(x, y, w, h);
        img.setRGB(x, y, val);
      }
    }
    ;
    return new ImageToMatrix();
  }

  static public int hashAboutObjects(Object... l) {
    int hash = 0, n = l(l);
    for (int i = 0; i < n; i++) hash = boostHashCombine(hash, hashCode(l[i]));
    return hash;
  }

  static public boolean hasMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args) != null;
  }

  static public void clearTokens(List<String> tok) {
    clearAllTokens(tok);
  }

  static public void clearTokens(List<String> tok, int i, int j) {
    clearAllTokens(tok, i, j);
  }

  static public void clearTokens(List<String> tok, IntRange r) {
    clearAllTokens(tok, r.start, r.end);
  }

  static public KeyListener enterKeyListener(final Object action) {
    return new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == KeyEvent.VK_ENTER)
          pcallF(action);
      }
    };
  }

  static public String poorMansProfiling_stopAndRenderResults() {
    return poorMansProfiling_renderFullResults(poorMansProfiling_stopAndGetResults());
  }

  static public int areaFromPoints(int x1, int y1, int x2, int y2) {
    return (x1 - x1) * (y2 - y1);
  }

  static public List<Integer> countIteratorToList(int b) {
    return countIteratorToList(0, b);
  }

  static public List<Integer> countIteratorToList(int a, int b) {
    return asList(countIterator(a, b));
  }

  static public <A> List<A> countIteratorToList(int b, IF1<Integer, A> f) {
    return countIteratorToList(0, b, f);
  }

  static public <A> List<A> countIteratorToList(int a, int b, IF1<Integer, A> f) {
    return asList(countIterator(a, b, f));
  }

  static public List<Integer> countIteratorToList(int a, int b, int step) {
    return asList(countIterator(a, b, step));
  }

  static public <A> List<A> countIteratorToList(double a, double b, double step, IF1<Double, A> f) {
    return asList(countIterator(a, b, step, f));
  }

  static public <A> List<Double> countIteratorToList(double a, double b, double step) {
    return asList(countIterator(a, b, step));
  }

  static public <A> List<A> countIteratorToList(IF1<Double, A> f, double a, double b, double step) {
    return asList(countIterator(f, a, b, step));
  }

  static public <A> List<A> countIteratorToList(IF1<Integer, A> f, int b) {
    return countIteratorToList(f, 0, b);
  }

  static public <A> List<A> countIteratorToList(IF1<Integer, A> f, int a, int b) {
    return asList(countIterator(f, a, b));
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public Object hotwire_onCompile;

  static public boolean hotwire_serially = false;

  static public Lock hotwire_overInternalBot_lock = lock();

  static public boolean hotwire_compileOnServer = false;

  static public Class<?> hotwire_overInternalBot(String progID) {
    return hotwire_overInternalBot(progID, "main");
  }

  static public Class<?> hotwire_overInternalBot(String progID, String mainClass) {
    return hotwire_overInternalBot(progID, __ -> mainClass);
  }

  static public Class<?> hotwire_overInternalBot(String progID, IF1<ClassLoader, String> calculateMainClass) {
    try {
      Pair<File, String> p;
      try {
        p = hotwire_compile(progID);
      } catch (Throwable e) {
        throw rethrow("Error hotwiring " + progID, e);
      }
      File jar = p.a;
      assertTrue(jar.getAbsolutePath(), jar.isFile());
      List<File> files = hotwire_collectJars(jar);
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      classLoader.progID = progID;
      String mainClass = calculateMainClass == null ? "main" : calculateMainClass.get(classLoader);
      return hotwire_finish(classLoader, progID, p.b, mainClass);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pair<File, String> hotwire_compile(String progID) {
    Pair<File, String> p = hotwire_compileOnServer && !isLocalSnippetID(progID) ? compileSnippetThroughServer(progID) : CompilerBot.compileSnippet2(progID);
    Lock __0 = hotwire_serially ? hotwire_overInternalBot_lock : null;
    lock(__0);
    try {
      callF(hotwire_onCompile, p);
      return p;
    } finally {
      unlock(__0);
    }
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public <A> boolean containsOneOf(Collection<A> l, A... x) {
    if (l instanceof Set) {
      if (x != null)
        for (A a : x) if (l.contains(a))
          return true;
    } else {
      for (A a : unnull(l)) if (eqOneOf(a, x))
        return true;
    }
    return false;
  }

  static public <A> boolean containsOneOf(Collection<A> l, Set<A> set) {
    if (set == null)
      return false;
    for (A a : unnull(l)) if (set.contains(a))
      return true;
    return false;
  }

  static public boolean containsOneOf(String s, String... x) {
    for (String o : x) if (contains(s, o))
      return true;
    return false;
  }

  static public AutoCloseable dm_registerAs_direct(String... msgs) {
    return dm_registerAs_directLink(msgs);
  }

  static public JFrame setFrameIconLater(Component c, final String imageID) {
    final JFrame frame = getFrame(c);
    if (frame != null)
      startThread("Loading Icon", new Runnable() {

        public void run() {
          try {
            final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
            swingLater(new Runnable() {

              public void run() {
                try {
                  frame.setIconImage(i);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "frame.setIconImage(i);";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Image i = imageIcon(or2(imageID, \"#1005557\")).getImage();\r\n      swingL...";
        }
      });
    return frame;
  }

  static public Rect intersectRects(Rect a, Rect b) {
    int x = max(a.x, b.x), y = max(a.y, b.y);
    int x2 = min(a.x + a.w, b.x + b.w), y2 = min(a.y + a.h, b.y + b.h);
    return new Rect(x, y, x2 - x, y2 - y);
  }

  static public Rect intersectRects(Rect a, int x1, int y1, int w, int h) {
    if (a == null || a.x >= x1 && a.y >= y1 && a.x2() < x1 + w && a.y2() < y1 + h)
      return a;
    return rectFromPoints(max(a.x, x1), max(a.y, y1), min(a.x2(), x1 + w), min(a.y2(), y1 + h));
  }

  static public String loadCachedTranspilation(String id) {
    try {
      return loadTextFilePossiblyGZipped(getCachedTranspilationFile(id));
    } catch (Throwable __e) {
      return null;
    }
  }

  static public File infoBoxesLogFile() {
    return new File(javaxDataDir(), "Logs/infoBoxes.txt");
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public double minusInfinity() {
    return negativeInfinity();
  }

  static public boolean deleteFile(File file) {
    return file != null && file.delete();
  }

  static public <A> Matrix<A> listOfListsToMatrix(List<List<A>> data) {
    if (data == null)
      return null;
    int _h = l(data);
    if (_h == 0)
      return null;
    int _w = l(data.get(0));
    class ListsToMatrix extends AbstractMatrix<A> {

      public ListsToMatrix() {
        super(_w, _h);
      }

      public A get(int x, int y) {
        return data.get(y).get(x);
      }

      public void set(int x, int y, A a) {
        data.get(y).set(x, a);
      }
    }
    ;
    return new ListsToMatrix();
  }

  static public String firstToken(String s) {
    return firstJavaToken(s);
  }

  static public String firstToken(List<String> tok) {
    return get(tok, 1);
  }

  static public JPanel centerAndSouthWithMargins(Swingable c, Swingable s) {
    return centerAndSouthWithMargins(c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargins(Swingable c, Component s) {
    return centerAndSouthWithMargins(toComponent(c), s);
  }

  static public JPanel centerAndSouthWithMargins(Component c, Swingable s) {
    return centerAndSouthWithMargins(c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargins(Component c, Component s) {
    return applyDefaultMargin(centerAndSouth(c, withTopMargin(s)));
  }

  static public JPanel centerAndSouthWithMargins(int margin, Swingable c, Swingable s) {
    return centerAndSouthWithMargins(margin, c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargins(int margin, Swingable c, Component s) {
    return centerAndSouthWithMargins(margin, toComponent(c), s);
  }

  static public JPanel centerAndSouthWithMargins(int margin, Component c, Swingable s) {
    return centerAndSouthWithMargins(margin, c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargins(int margin, Component c, Component s) {
    return applyMargin(margin, centerAndSouth(c, withTopMargin(margin, s)));
  }

  static public void setSCPComponent(SingleComponentPanel scp, Component c) {
    if (scp != null)
      scp.setComponent(c);
  }

  static public void stopTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public Object dm_os() {
    {
      var __1 = vm_generalMap_get("stefansOS");
      if (__1 != null)
        return __1;
    }
    return creator();
  }

  static public void hideWindow(final Component c) {
    final Window w = getWindow(c);
    if (w != null) {
      swing(() -> {
        w.setVisible(false);
      });
    }
  }

  static public <A> A cyclicGet(List<A> l, int i) {
    return empty(l) ? null : get(l, mod(i, l(l)));
  }

  static public boolean cyclicGet(BitSet bs, int n, int i) {
    return bs != null && bs.get(mod(i, n));
  }

  static public long cyclicGet(LongBuffer l, int i) {
    return l.get(mod(i, l.size()));
  }

  static public String ymdMinusHMS() {
    return ymdMinusHMS(now());
  }

  static public String ymdMinusHMS(long now) {
    return ymd_minus_hms(now);
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public int toIntPercent(double ratio) {
    return roundToInt(ratio * 100);
  }

  static public int toIntPercent(float ratio) {
    return toIntPercent((double) ratio);
  }

  static public boolean tok_classHasModifier(List<String> classDecl, String modifier) {
    if (classDecl == null)
      return false;
    int i = classDecl.indexOf("class");
    return subList(classDecl, 0, i).contains(modifier);
  }

  static public String prependSquareBracketed(Object o) {
    String s = strOrEmpty(o);
    return empty(s) ? "" : squareBracketed(s) + " ";
  }

  static public int withLeftMargin_defaultWidth = 6;

  static public JPanel withLeftMargin(Swingable c) {
    return withLeftMargin(toComponent(c));
  }

  static public JPanel withLeftMargin(Component c) {
    return withLeftMargin(withLeftMargin_defaultWidth, c);
  }

  static public JPanel withLeftMargin(int margin, Swingable c) {
    return withLeftMargin(margin, toComponent(c));
  }

  static public JPanel withLeftMargin(int margin, Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, margin, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public BetterThreadLocal<PingSource> pingSource_tl_var = new BetterThreadLocal<PingSource>() {

    @Override
    public PingSource initialValue() {
      return ping_v3_pingSourceMaker().get();
    }
  };

  static public BetterThreadLocal<PingSource> pingSource_tl() {
    return pingSource_tl_var;
  }

  static public JPanel jSection(Component c) {
    return jSection("", c);
  }

  static public JPanel jSection(final String title, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
          border = BorderFactory.createTitledBorder(border, title);
          JSection panel = new JSection(c);
          panel.setBorder(border);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);\r\n    bo...";
      }
    });
  }

  static public JPanel jSection(String title) {
    return jSection(title, jpanel());
  }

  static public JPanel jSection(LiveValue<?> lv, Component c) {
    return jLiveValueSection(lv, c);
  }

  static public JButton jPopDownButton_noText(final Object... menuParams) {
    return toolTip("Additional commands", jPopDownButton("", menuParams));
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public <A> List<A> replaceElementsUsingMap(Iterable<A> l, final Map<A, A> map) {
    return map(l, new F1<A, A>() {

      public A get(A a) {
        try {
          return getOrKeep(map, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "getOrKeep(map, a)";
      }
    });
  }

  static public void swingLater(long delay, final Object r) {
    javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
    timer.setRepeats(false);
    timer.start();
  }

  static public void swingLater(Object r) {
    var runnable = toRunnable(r);
    executingSwingCode(runnable);
    SwingUtilities.invokeLater(runnable);
  }

  static public String tok_unCurlyBracket(String s) {
    return isCurlyBraced(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public boolean makeNotifyingStringBufferRotate_verbose = false;

  static public class NotifyingStringBufferRotator implements Runnable {

    public NotifyingStringBuffer buf;

    public IF0<Integer> getMaxChars;

    public boolean processing = false;

    public NotifyingStringBufferRotator(NotifyingStringBuffer buf, IF0<Integer> getMaxChars) {
      this.getMaxChars = getMaxChars;
      this.buf = buf;
    }

    public void run() {
      try {
        if (processing)
          return;
        AutoCloseable __1 = tempSet(this, "processing", true);
        try {
          Integer max = callF(getMaxChars);
          if (max == null || buf.length() <= max)
            return;
          if (makeNotifyingStringBufferRotate_verbose)
            print("Rotating NotifyingStringBuffer (" + buf.length() + "/" + max + ")");
          try {
            int newLength = max / 2;
            int ofs = buf.length() - newLength;
            String newString = buf.substring(ofs);
            buf.setLength(0);
            buf.append("[...] ").append(newString);
          } catch (Exception e) {
            buf.setLength(0);
          }
          buf.trimToSize();
        } finally {
          _close(__1);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public void makeNotifyingStringBufferRotate(NotifyingStringBuffer buf, IF0<Integer> getMaxChars) {
    if (hasElementWithClassShortNamed("NotifyingStringBufferRotator", buf.onChange))
      return;
    buf.onChange(new NotifyingStringBufferRotator(buf, getMaxChars));
  }

  static public <A> List<A> matrixToList(Matrix<A> m) {
    if (m == null)
      return null;
    int w = m.getWidth(), h = m.getHeight(), n = w * h;
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return n;
      }

      public A get(int i) {
        return m.get(i % w, i / w);
      }

      public A set(int i, A val) {
        A old = m.get(i % w, i % h);
        m.set(i % w, i / w, val);
        return old;
      }
    };
  }

  static public Object[] mapObjectArray(IF1 f, Object[] l) {
    if (empty(l))
      return l;
    int n = l.length;
    Object[] a2 = new Object[n];
    for (int i = 0; i < n; i++) a2[i] = f.get(l[i]);
    return a2;
  }

  static public String defaultTimerName_name;

  static public String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  static public ThreadLocal<BufferedImage> currentImage_var = new ThreadLocal();

  static public BufferedImage currentImage() {
    return currentImage_var.get();
  }

  static public void currentImage(BufferedImage img) {
    currentImage_var.set(img);
  }

  static public int imageMergeSpacing = 5;

  static public int imageMergeSpacing() {
    return imageMergeSpacing;
  }

  static public void imageMergeSpacing(int pixels) {
    imageMergeSpacing = pixels;
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  static public boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  static public boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  static public MultiSet<String> poorMansProfiling_results = new MultiSet();

  static public int poorMansProfiling_samples;

  static public java.util.Timer poorMansProfiling_timer;

  static public Lock poorMansProfiling_lock = lock();

  static public Thread poorMansProfiling_threadToSample;

  static public void poorMansProfiling() {
    poorMansProfiling(poorMansProfiling_defaultInterval());
  }

  static public void poorMansProfiling(Thread thread) {
    poorMansProfiling(poorMansProfiling_defaultInterval(), thread);
  }

  static public void poorMansProfiling(int interval) {
    poorMansProfiling(interval, null);
  }

  static public void poorMansProfiling(int interval, Thread thread) {
    Lock __0 = poorMansProfiling_lock;
    lock(__0);
    try {
      poorMansProfiling_threadToSample = thread;
      poorMansProfiling_stop();
      poorMansProfiling_clear();
      poorMansProfiling_timer = doEvery_daemon(interval, new Runnable() {

        public void run() {
          try {
            Map<Thread, StackTraceElement[]> map = poorMansProfiling_threadToSample != null ? litmap(poorMansProfiling_threadToSample, poorMansProfiling_threadToSample.getStackTrace()) : runnableThreadsWithStackTraces();
            Lock __1 = poorMansProfiling_lock;
            lock(__1);
            try {
              poorMansProfiling_samples++;
              for (Thread t : keys(map)) {
                {
                  if (isSystemThread(t))
                    continue;
                }
                StringBuilder buf = new StringBuilder();
                for (StackTraceElement e : map.get(t)) buf.append(e).append("\n");
                poorMansProfiling_results.add(str(buf));
              }
            } finally {
              unlock(__1);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Map<Thread, StackTraceElement[]> map =\r\n      poorMansProfiling_threadToSampl...";
        }
      });
    } finally {
      unlock(__0);
    }
  }

  static public void poorMansProfiling_stop() {
    Lock __2 = poorMansProfiling_lock;
    lock(__2);
    try {
      if (poorMansProfiling_timer != null) {
        stopTimer(poorMansProfiling_timer);
        poorMansProfiling_timer = null;
      }
    } finally {
      unlock(__2);
    }
  }

  static public void poorMansProfiling_clear() {
    Lock __3 = poorMansProfiling_lock;
    lock(__3);
    try {
      poorMansProfiling_results.clear();
      poorMansProfiling_samples = 0;
    } finally {
      unlock(__3);
    }
  }

  static public MultiSet<String> poorMansProfiling_results() {
    return new MultiSet(poorMansProfiling_results);
  }

  static public MultiSet<String> poorMansProfiling_stopAndGetResults() {
    Lock __4 = poorMansProfiling_lock;
    lock(__4);
    try {
      poorMansProfiling_stop();
      return poorMansProfiling_results();
    } finally {
      unlock(__4);
    }
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public JLabel setImage(final BufferedImage img, final JLabel lbl) {
    if (lbl != null) {
      swing(() -> {
        lbl.setIcon(imageIcon(img));
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, BufferedImage img) {
    return setImage(img, lbl);
  }

  static public JLabel setImage(final String imageID, final JLabel lbl) {
    if (lbl != null) {
      swing(() -> {
        lbl.setIcon(imageIcon(imageID));
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, String imageID) {
    return setImage(imageID, lbl);
  }

  static public <A extends ImageSurface> A setImage(A is, BufferedImage img) {
    {
      if (is != null)
        is.setImage(img);
    }
    return is;
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static public void bindTimerToComponent(final Timer timer, JFrame f) {
    bindTimerToComponent(timer, f.getRootPane());
  }

  static public void bindTimerToComponent(final Timer timer, JComponent c) {
    if (c.isShowing())
      timer.start();
    c.addAncestorListener(new AncestorListener() {

      public void ancestorAdded(AncestorEvent event) {
        timer.start();
      }

      public void ancestorRemoved(AncestorEvent event) {
        timer.stop();
      }

      public void ancestorMoved(AncestorEvent event) {
      }
    });
  }

  static public IntegerIterator integerIterator(int[] l) {
    return l == null ? null : new IntegerIterator() {

      public int i = 0;

      public boolean hasNext() {
        return i < l.length;
      }

      public int next() {
        return l[i++];
      }
    };
  }

  static public boolean containsRegexp(String s, String pat) {
    return regexpFinds(pat, s);
  }

  static public int numLines(String s) {
    return countLines(s);
  }

  static public String simpleQuote(String s) {
    return s == null ? "null" : "\"" + s + "\"";
  }

  static public <A> int indexOfAny(List<A> l, int i, A... x) {
    while (i < l(l)) if (eqOneOf(l.get(i), x))
      return i;
    else
      ++i;
    return -1;
  }

  static public <A> int indexOfAny(List<A> l, Collection<A> x) {
    return indexOfAny(l, 0, x);
  }

  static public <A> int indexOfAny(List<A> l, int i, Collection<A> x) {
    if (nempty(x))
      while (i < l(l)) if (x.contains(l.get(i)))
        return i;
      else
        ++i;
    return -1;
  }

  static public int indexOfAny(String s, int i, String chars) {
    for (; i < l(s); i++) if (chars.indexOf(s.charAt(i)) >= 0)
      return i;
    return -1;
  }

  static public int indexOfAny(String s, String chars) {
    return indexOfAny(s, 0, chars);
  }

  static public BufferedImage gridLOLToImage(List<Integer> cellWidths, List<Integer> cellHeights, List<List<Integer>> lol) {
    List<Matrix<Integer>> lom = mapWithIndex(lol, (i, m) -> listToMatrix(cyclicGet(cellWidths, i), m));
    Matrix<Matrix<Integer>> mom = listToMatrix_cols(l(cellWidths), lom);
    List<Integer> cellX1s = partialSums_firstIs0(cellWidths);
    List<Integer> cellY1s = partialSums_firstIs0(cellHeights);
    int w = last(cellX1s), h = last(cellY1s);
    BufferedImage restored = newBufferedImage(w, h);
    forEachWithPosition(mom, (x, y, cell) -> drawIntMatrix(restored, cell, cyclicGet(cellX1s, x), cyclicGet(cellY1s, y)));
    return restored;
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public Producer<String> javaTokC_iterator(String s) {
    return new Producer<String>() {

      final public int l = strL(s);

      public int i = 0;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else if (c == '[' && d == '[') {
          do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
          j = Math.min(j + 2, l);
        } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
          do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
          j = Math.min(j + 3, l);
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public <A extends Component> A alwaysOnTop(A c) {
    return alwaysOnTop(c, true);
  }

  static public <A extends Component> A alwaysOnTop(A c, boolean on) {
    {
      swing(() -> {
        Window w = getWindow(c);
        if (w != null && w.isAlwaysOnTop() != on)
          w.setAlwaysOnTop(on);
      });
    }
    return c;
  }

  static public <A> A setFrameTitle(A c, final String title) {
    final Frame f = getAWTFrame(c);
    if (f != null) {
      swing(() -> {
        f.setTitle(title);
      });
    }
    return c;
  }

  static public <A extends Component> A setFrameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public JFrame setFrameTitle(String title) {
    Object f = getOpt(mc(), "frame");
    if (f instanceof JFrame)
      return setFrameTitle((JFrame) f, title);
    return null;
  }

  static public boolean _inCore() {
    return false;
  }

  static public int getScreenWidth() {
    return getScreenSize().width;
  }

  static public Set<String> javaxVoidAliases_cache;

  static public Set<String> javaxVoidAliases() {
    if (javaxVoidAliases_cache == null)
      javaxVoidAliases_cache = javaxVoidAliases_load();
    return javaxVoidAliases_cache;
  }

  static public Set<String> javaxVoidAliases_load() {
    return litset("void", "svoid");
  }

  static public ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  static public Timestamp tsNow() {
    return new Timestamp();
  }

  static public Object makeDependent_postProcess;

  static public void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  static public Rectangle boundsOnScreen(Component c) {
    if (c == null)
      return null;
    if (c.getParent() instanceof JViewport && c.getParent().getParent() instanceof JScrollPane)
      c = c.getParent().getParent();
    try {
      return new Rectangle(c.getLocationOnScreen(), c.getSize());
    } catch (IllegalComponentStateException e) {
      return null;
    }
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, (ITokCondition) null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, String in, IIntPred condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, IIntPred condition) {
    return jfind(tok, startIndex, in, tokCondition(condition));
  }

  static public int jfind(List<String> tok, String in, ITokCondition condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, ITokCondition condition) {
    return jfind(tok, startIndex, in, (Object) condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public String formatFunctionCall(String fname, Object... args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Object... args) {
    return fname + "(" + joinWithComma(allToString(args)) + ")";
  }

  static public String formatFunctionCall(String fname, Iterable args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Iterable args) {
    return formatFunctionCall(fname, toObjectArray(args));
  }

  static public void copyBufferedImage(BufferedImage src, int srcx, int srcy, BufferedImage dest, int destx, int desty, int w, int h) {
    copyImagePart(src, srcx, srcy, dest, destx, desty, w, h);
  }

  static public void copyBufferedImage(BufferedImage src, BufferedImage dest, int destx, int desty) {
    if (src != null)
      copyBufferedImage(src, 0, 0, dest, destx, desty, src.getWidth(), src.getHeight());
  }

  static public void copyBufferedImage(BufferedImage src, BufferedImage dest, Pt destP) {
    copyBufferedImage(src, dest, destP.x, destP.y);
  }

  static public List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  static public Object dm_evalJava_veryQuickJava;

  static public Object dm_evalJava_withModule(String expression, Object... args) {
    Object m = dm_current_generic();
    String code = evalJava_prep(expression) + "\r\n    static new InheritableThreadLocal<WeakReference> dm_currentModule_value;\r\n    \r\n    sO dm_current_mandatory_generic_value;\r\n    \r\n    sO dm_current_mandatory_generic() { ret dm_current_mandatory_generic_value; }\r\n    sO dm_current_generic() { ret dm_current_mandatory_generic(); }\r\n  ";
    Object obj;
    if (dm_evalJava_veryQuickJava != null)
      obj = callF(dm_evalJava_veryQuickJava, code);
    else
      obj = veryQuickJava(code);
    setOpt(obj, "programID", programID());
    makeDependent(obj);
    setOpt(obj, "creator_class", newWeakReference(dm_os()));
    dm_pointSubmoduleToMe(obj, m);
    return evalJava_myProgramID_main_2(obj, args);
  }

  static public String localDateWithSeconds(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
    return format.format(time);
  }

  static public String localDateWithSeconds() {
    return localDateWithSeconds(now());
  }

  static public void dm_reload() {
    dm_reloadMe();
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, Iterable<B> l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(Object f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = (A) callF(f, a, b);
    return a;
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public ImageSurface doubleBufferedImageSurface() {
    ImageSurface is = imageSurface();
    setDoubleBuffered(is, true);
    return is;
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public String renderFunctionCall(String fname, Object... args) {
    return formatFunctionCall(fname, args);
  }

  static public <A extends JComponent> A addMargin(final int top, final int left, final int bottom, final int right, final A c) {
    if (c != null) {
      swing(() -> {
        Border margin = BorderFactory.createEmptyBorder(top, left, bottom, right);
        c.setBorder(jCompoundBorder(c.getBorder(), margin));
      });
    }
    return c;
  }

  static public <A extends JComponent> A addMargin(int w, A c) {
    return addMargin(w, w, w, w, c);
  }

  static public <A> A dm_getOSOpt(String field) {
    return (A) getOpt(dm_os(), field);
  }

  static public double[] subDoubleArray(double[] b, int start) {
    return subDoubleArray(b, start, l(b));
  }

  static public double[] subDoubleArray(double[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new double[0];
    double[] x = new double[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean isJavaxCompilableSnippetTypeExceptInclude(int type) {
    return isJavaxApplicationSnippetType(type) || isJavaxModuleSnippetType(type) || type == snippetType_dynModule();
  }

  static public <A extends Component> A setFrameIcon(A c, String imageID) {
    setFrameIconLater(c, imageID);
    return c;
  }

  static public <A extends Component> A setFrameIcon(String imageID, A c) {
    return setFrameIcon(c, imageID);
  }

  static public JDesktopPane dm_desktopPane() {
    return dm_getOSOpt("desktop");
  }

  static public boolean isListOfElementType(Object o, Class type) {
    if (!(o instanceof List))
      return false;
    return allElementsAreOfType((List) o, type);
  }

  static public boolean isListOfElementType(Class type, Object o) {
    return isListOfElementType(o, type);
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public String getSnippetTitle(String id) {
    if (id == null)
      return null;
    if (!isSnippetID(id))
      return "?";
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getSnippetTitle(id);
    return getSnippetTitle_noResourceLoader(id);
  }

  static public String getSnippetTitle_noResourceLoader(String id) {
    try {
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public JPanel jFullCenter(final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          panel.add(c);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    panel.add(c);\r\n    ret panel;";
      }
    });
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(final DynModule module, final Class type, final F0<A> calc) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      final SimpleLiveValue value = new SimpleLiveValue(type, callF(calc));
      module.onChange(new Runnable() {

        public void run() {
          try {
            value.set(callF(calc));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "value.set(callF(calc))";
        }
      });
      return value;
    } finally {
      unlock(__0);
    }
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(Class type, F0<A> calc) {
    return dm_calculatedLiveValue(dm_current_mandatory(), type, calc);
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(Class<A> type, IF0<A> calc) {
    return dm_calculatedLiveValue(type, if0ToF0(calc));
  }

  static public LiveValue<Object> dm_calculatedLiveValue(IF0<?> calc) {
    return dm_calculatedLiveValue(Object.class, (F0) if0ToF0(calc));
  }

  static public MouseAdapter leftClickMouseAdapter_noPt(final Object r) {
    return new MouseAdapter() {

      public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1)
          pcallF(r);
      }
    };
  }

  static public List<String> getJavaModifiers_list = litlist("static", "abstract", "public", "private", "protected", "final", "native", "volatile", "synchronized", "transient", "default");

  static public List<String> getJavaModifiers() {
    return getJavaModifiers_list;
  }

  static public boolean dm_setFlag(String flagName) {
    return dm_setFlag(flagName, true);
  }

  static public boolean dm_setFlag(String flagName, boolean value) {
    Object mod = dm_current_generic();
    Object stem = dm_stem(mod);
    Integer flagCode = (Integer) (getOpt("flagName", stem));
    if (flagCode == null)
      return false;
    call(stem, value ? "setFlag" : "clearFlag", flagCode);
    return true;
  }

  static public <A, B> boolean isEitherB(Either<A, B> e) {
    return eitherIsB(e);
  }

  static public DynModule dm_currentModuleMandatory() {
    return dm_current_mandatory();
  }

  static public Object quickEval(String t) {
    if (isQuoted(t))
      return unquote(t);
    if (isInteger(t))
      return parseIntOrLong(t);
    if (isLongConstant(t))
      return parseLong(t);
    if (eq(t, "null"))
      return null;
    if (eq(t, "false"))
      return false;
    if (eq(t, "true"))
      return true;
    if (isIdentifier(t))
      return getMC(t);
    if (isSnippetID(t))
      return t;
    throw quickFail("Can't quick eval: " + t);
  }

  static public IAutoCloseableF0 tempMetaMutex(IMeta o) {
    return o == null ? null : o._tempMetaMutex();
  }

  static public JCheckBox dm_fieldCheckBox(String field) {
    return dm_fieldCheckBox(humanizeFormLabel(field), field);
  }

  static public JCheckBox dm_fieldCheckBox(String text, String field) {
    if (isIdentifier(text) && !isIdentifier(field)) {
      String temp = field;
      field = text;
      text = temp;
    }
    return jLiveValueCheckBox(text, dm_fieldLiveValue(field));
  }

  static public boolean hasLettersAllUpperCase(String s) {
    return hasLetters(s) && !containsLowerCase(s);
  }

  static public JTextArea jTextArea() {
    return jTextArea("");
  }

  static public JTextArea jTextArea(final String text) {
    return jTextAreaWithUndo(text);
  }

  static public List<String> classNamesInJarOrDir(File dir) {
    return classNamesInJarOrDir(dir, "");
  }

  static public List<String> classNamesInJarOrDir(File dir, String prefixInJar) {
    List<String> classes = new ArrayList();
    if (dir == null) {
    } else if (dir.isDirectory()) {
      for (File f : listFiles(dir)) {
        String s = f.getName();
        if (s.endsWith(".class"))
          classes.add(dropSuffix(".class", s));
      }
    } else if (dir.isFile()) {
      try {
        JarFile jarFile = new JarFile(dir);
        try {
          Enumeration<JarEntry> e = jarFile.entries();
          while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || je.getName().startsWith("META-INF/") || !je.getName().endsWith(".class"))
              continue;
            String className = dropSuffix(".class", je.getName());
            className = dropPrefixOrNull(prefixInJar, className);
            if (className == null)
              continue;
            if (className.contains("-"))
              continue;
            className = className.replace('/', '.');
            classes.add(className);
          }
        } finally {
          jarFile.close();
        }
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
    return classes;
  }

  static public double toMinutes(long ms) {
    return ms / 60000.0;
  }

  static public void printShortenedFunctionCall(Object fname, Object... args) {
    printShortenedFunctionCall(100, fname, args);
  }

  static public void printShortenedFunctionCall(int len, Object fname, Object... args) {
    print(shorten(len, formatFunctionCall(fname, args)));
  }

  static public void dm_reloadMe() {
    dm_reloadModule(dm_currentModule());
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = f.get();
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF2();
  }

  static public JLabel dm_calculatedLabel(IF0<Object> calc) {
    return jLiveValueLabel(dm_calculatedLiveValue(Object.class, calc));
  }

  static public <A> void scanForComponents(final Component c, final Class<A> theClass, final List<A> l) {
    if (theClass.isInstance(c))
      l.add((A) c);
    if (c instanceof Container) {
      swing(() -> {
        for (Component comp : ((Container) c).getComponents()) scanForComponents(comp, theClass, l);
      });
    }
  }

  static public boolean scaffoldingEnabled(Object o) {
    return metaGet(o, "scaffolding") != null;
  }

  static public String defaultJavaXTranslatorID_value = "#759";

  static public String defaultJavaXTranslatorID() {
    return defaultJavaXTranslatorID_value;
  }

  static public List vmBus_queryAll(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    List out = new ArrayList();
    for (Object o : unnullForIteration(vm_busListeners_live())) addIfNotNull(out, pcallF(o, msg, arg));
    for (Object o : unnullForIteration(vm_busListenersByMessage_live().get(msg))) addIfNotNull(out, pcallF(o, msg, arg));
    return out;
  }

  static public List<String> hotwire_libraryIDsFromJar(File jar) {
    String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
    return regexpExtractAll("\\d+", dehlibs);
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + replace(unnull(s), "\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public boolean isAlwaysOnTop(JFrame f) {
    return f != null && swing(() -> f.isAlwaysOnTop());
  }

  static public boolean isAlwaysOnTop(Window w) {
    return w != null && swing(() -> w.isAlwaysOnTop());
  }

  static public <A> F0<A> f0_const(final A a) {
    return new F0<A>() {

      public A get() {
        try {
          return a;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return a;";
      }
    };
  }

  static public JWindow infoBox(Object text) {
    return infoMessage(strOrNull(text));
  }

  static public JWindow infoBox(String text) {
    return infoMessage(text);
  }

  static public JWindow infoBox(String text, double seconds) {
    return infoMessage(text, seconds);
  }

  static public JWindow infoBox(Throwable e) {
    return infoMessage(e);
  }

  static public double toSeconds(long ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(long ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toSeconds(double ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(double ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public Rect rect(int x, int y, int w, int h) {
    return new Rect(x, y, w, h);
  }

  static public Rect rect(Pt p, int w, int h) {
    return new Rect(p.x, p.y, w, h);
  }

  static public Rect rect(int w, int h) {
    return new Rect(0, 0, w, h);
  }

  static public <A> A navigableSet_find(NavigableSet<A> set, A a) {
    if (set == null || a == null)
      return null;
    A b = set.floor(a);
    return b != null && sortedSet_compare(set, a, b) == 0 ? b : null;
  }

  static public AutoCloseable tempCleaningUp() {
    AutoCloseable result = null;
    return result;
  }

  static public boolean cleanUp_interruptThreads = false;

  static public void cleanUp(Object c) {
    if (c == null)
      return;
    if (c instanceof AutoCloseable) {
      close_pcall((AutoCloseable) c);
      return;
    }
    if (c instanceof java.util.Timer) {
      ((java.util.Timer) c).cancel();
      return;
    }
    if (c instanceof Collection) {
      cleanUp((Collection) c);
      return;
    }
    if (c instanceof Map) {
      for (Object o : keysList((Map) c)) cleanUp(o);
      for (Object o : valuesList((Map) c)) cleanUp(o);
      syncClear((Map) c);
      return;
    }
    try {
      preCleanUp(c);
      setOpt_raw(c, "ping_pauseAll", false);
      innerCleanUp(c);
      List androids = (List) getOpt(c, "record_list");
      for (Object android : unnull(androids)) pcallOpt(android, "dispose");
      List<WeakReference> classes = (List<WeakReference>) (getOpt(c, "hotwire_classes"));
      if (classes != null)
        for (WeakReference cc : classes) {
          try {
            cleanUp(cc.get());
          } catch (Throwable __e) {
            pcallFail(__e);
          }
        }
      if (cleanUp_interruptThreads) {
        List<Thread> threads = registeredThreads(c);
        if (nempty(threads)) {
          print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
          interruptThreads(threads);
        }
      }
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    setOpt_raw(c, "cleaningUp_flag", false);
    if (c instanceof Class && ((Class) c).getName().equals("main"))
      retireClassLoader(((Class) c).getClassLoader());
  }

  static public void cleanUp(Collection l) {
    if (l == null)
      return;
    for (Object c : l) cleanUp(c);
    l.clear();
  }

  static public Object dm_stem() {
    return dm_stem(dm_current_generic());
  }

  static public Object dm_stem(Object moduleOrID) {
    return dm_getStem(moduleOrID);
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        name = replacePrefix("main$main$", "main$", name);
        Class c = get2(name);
        printVars_str("ddcf", "name", name, "c", c);
        return c;
      }

      public Class get2(String name) {
        if (eq(name, "<main>"))
          return mc();
        {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
        }
        if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
          for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
            String newName = pkg + afterDollar(name);
            print("ddcf looking for ", newName);
            {
              Class c = findClass_fullName(newName);
              if (c != null)
                return c;
            }
          }
        return null;
      }
    };
  }

  static public IterableIterator<Integer> countIterator_exclusive_step(final int a, final int b, final int step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Integer next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public IterableIterator<Double> countIterator_exclusive_step(double a, double b, double step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Double>() {

      public double i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Double next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_exclusive_step(double a, double b, double step, IF1<Double, A> f) {
    return mapI_if1(f, countIterator_exclusive_step(a, b, step));
  }

  static public <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  static public <A> void forEach(Iterable<A> l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public <A> void forEach(IVF1<A> f, Iterable<A> l) {
    forEach(l, f);
  }

  static public <A> void forEach(A[] l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public <A> void forEach(IVF1<A> f, A[] l) {
    forEach(l, f);
  }

  static public <A, B> void forEach(Map<A, B> map, IVF2<A, B> f) {
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A a = __0.getKey();
      B b = __0.getValue();
      f.get(a, b);
    }
  }

  static public boolean standardFunctionAlwaysReturnsVoid_uncached(String name) {
    return tok_staticFunctionAlwaysReturnsVoid(javaTok(textOfStandardFunction_uncached(name)), name);
  }

  static public int findEndOfBlock(List<String> tok, int i) {
    return tok_findEndOfBlock(tok, i);
  }

  static public void disposeWindow(final Window window) {
    if (window != null) {
      swing(() -> {
        window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING));
        myFrames_list.remove(window);
        window.dispose();
      });
    }
  }

  static public void disposeWindow(final Component c) {
    disposeWindow(getWindow(c));
  }

  static public void disposeWindow(Object o) {
    if (o != null)
      disposeWindow(((Component) o));
  }

  static public void disposeWindow() {
    disposeWindow(heldInstance(Component.class));
  }

  static public JTextField textFieldFromComboBox(JComboBox cb) {
    return (JTextField) cb.getEditor().getEditorComponent();
  }

  static public void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  static public void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  static public boolean isInRAMDisk(File f) {
    return startsWithOneOf(f2s(f), "/dev/shm/", "/run/shm/");
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public <A> float getScore(Scored<A> s) {
    return s == null ? 0 : s.score;
  }

  static public <A, B> String formatColonProperties_noNulls(Object... params) {
    return formatColonProperties(nonNullPairs(paramsToPairs(params)));
  }

  static public boolean containsNewLines(String s) {
    return containsNewLine(s);
  }

  static public int moveToTopRightCorner_inset = 20;

  static public <A extends Component> A moveToTopRightCorner(A a) {
    return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
  }

  static public <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
    {
      swing(() -> {
        Window w = getWindow(a);
        if (w != null) {
          var bounds = preferredScreenBounds();
          w.setLocation(bounds.x2() - w.getWidth() - insetX, bounds.y1() + insetY);
        }
      });
    }
    return a;
  }

  static public boolean objectArraysEqual(Object[] a, Object[] b) {
    return arraysEqual(a, b);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public JPanel centerAndEast(final Component c, final Component e) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.EAST, wrap(e));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public int preferredWidth(Component c) {
    return c == null ? 0 : getPreferredSize(c).width;
  }

  static public void metaMapPut(IMeta o, Object key, Object value) {
    {
      if (o != null)
        o.metaPut(key, value);
    }
  }

  static public void metaMapPut(Object o, Object key, Object value) {
    var meta = initIMeta(o);
    {
      if (meta != null)
        meta.metaPut(key, value);
    }
  }

  static public String quoteBorderless(Object o) {
    if (o == null)
      return "null";
    return quoteBorderless(str(o));
  }

  static public String quoteBorderless(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5));
    quoteBorderless_impl(s, out);
    return out.toString();
  }

  static public void quoteBorderless_impl(String s, StringBuilder out) {
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else
        out.append(c);
    }
  }

  static public <A> boolean eqGetOneOf(List<A> l, int i, A... options) {
    return eqOneOf(get(l, i), options);
  }

  static public String makeFrame_defaultIcon;

  static public boolean makeFrame_hideConsole = false;

  static public ThreadLocal<VF1<JFrame>> makeFrame_post = new ThreadLocal();

  static public JFrame makeFrame() {
    return makeFrame((Component) null);
  }

  static public JFrame makeFrame(Object content) {
    return makeFrame(programTitle(), content);
  }

  static public JFrame makeFrame(String title) {
    return makeFrame(title, null);
  }

  static public JFrame makeFrame(String title, Object content) {
    return makeFrame(title, content, true);
  }

  static public JFrame makeFrame(final String title, final Object content, final boolean showIt) {
    final VF1<JFrame> post = optParam(makeFrame_post);
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          if (getFrame(content) != null)
            return getFrame(setFrameTitle((Component) content, title));
          final JFrame frame = new JFrame(title);
          if (makeFrame_defaultIcon != null)
            setFrameIconLater(frame, makeFrame_defaultIcon);
          _initFrame(frame);
          Component wrapped = wrap(content);
          if (wrapped != null)
            frame.getContentPane().add(wrapped);
          restrictWindowToScreenSize(frame);
          frame.setBounds(defaultNewFrameBounds());
          callF(post, frame);
          if (showIt)
            frame.setVisible(true);
          if (showIt && makeFrame_hideConsole) {
            hideConsole();
            makeFrame_hideConsole = false;
          }
          return frame;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ...";
      }
    });
  }

  static public <A> OKOrError<A> okOrError(IF0<A> f) {
    return okOrError(f, true);
  }

  static public <A> OKOrError<A> okOrError(IF0<A> f, boolean printStackTrace) {
    try {
      return OKOrError_ok(f.get());
    } catch (Throwable e) {
      if (printStackTrace)
        printStackTrace(e);
      return OKOrError_error(e);
    }
  }

  static public <A> OKOrError<A> okOrError(Runnable r) {
    return okOrError(runnableToIF0(r));
  }

  static public <A extends JComponent> A setDoubleBuffered(A c) {
    return setDoubleBuffered(c, true);
  }

  static public <A extends JComponent> A setDoubleBuffered(A c, boolean b) {
    {
      swing(() -> {
        {
          if (c != null)
            c.setDoubleBuffered(b);
        }
      });
    }
    return c;
  }

  static public <A> List<A> asVirtualList(A[] a) {
    return wrapArrayAsList(a);
  }

  static public BufferedImage bufferedImage(int[] pixels, int w, int h) {
    return intArrayToBufferedImage(pixels, w, h);
  }

  static public BufferedImage bufferedImage(int[] pixels, WidthAndHeight size) {
    return bufferedImage(pixels, size.getWidth(), size.getHeight());
  }

  static public BufferedImage bufferedImage(int w, int h, int[] pixels) {
    return intArrayToBufferedImage(pixels, w, h);
  }

  static public BufferedImage bufferedImage(int w, int h) {
    return newBufferedImage(w, h);
  }

  static public BufferedImage bufferedImage(int w, int h, RGB rgb) {
    return newBufferedImage(w, h, rgb);
  }

  static public BufferedImage bufferedImage(int w, Color color) {
    return bufferedImage(w, w, color);
  }

  static public BufferedImage bufferedImage(int w, int h, Color color) {
    return newBufferedImage(w, h, color);
  }

  static public BufferedImage bufferedImage(Pt p, Color color) {
    return newBufferedImage(p, color);
  }

  static public BufferedImage bufferedImage(WidthAndHeight size, Color color) {
    return newBufferedImage(size.w(), size.h(), color);
  }

  static public BufferedImage bufferedImage(Color color, WidthAndHeight size) {
    return bufferedImage(size, color);
  }

  static public String asciiHeading(String title) {
    return "\n" + title + "\n" + rep(l(title), '-');
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(A[] l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, A[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = f.get(l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, Collection<A> l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  static public int maximumSafeArraySize() {
    return Integer.MAX_VALUE - 8;
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public Q dm_q() {
    return dm_current_mandatory().q();
  }

  static public void dm_q(Runnable r) {
    dm_inQ(r);
  }

  static public void dm_q(DynModule module, Runnable r) {
    module.q().add(r);
  }

  static public <A> A dm_q(IF0<A> f) {
    return dm_evalInQ(if0ToF0(f));
  }

  static public AutoCloseable tempActivity(Object r) {
    return null;
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int withLeftAndRightMargin_defaultWidth = 6;

  static public JPanel withLeftAndRightMargin(Component c) {
    return withLeftAndRightMargin(withLeftAndRightMargin_defaultWidth, c);
  }

  static public JPanel withLeftAndRightMargin(int w, Component c) {
    return withLeftAndRightMargin(w, w, c);
  }

  static public JPanel withLeftAndRightMargin(final int w1, final int w2, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(0, w1, 0, w2));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(0,...";
      }
    });
  }

  static public void preCleanUp(Object c) {
    if (c instanceof Collection) {
      for (Object o : ((Collection) c)) preCleanUp(o);
      return;
    }
    callOpt(c, "licensed_off");
    setOpt_raw(c, "ping_anyActions", true);
    setOpt_raw(c, "cleaningUp_flag", true);
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public <A> A getAndClearTL(ThreadLocal<A> tl) {
    return getAndClearThreadLocal(tl);
  }

  static public String getClassDeclarationName(List<String> tok) {
    if (tok != null)
      for (int i = 1; i + 2 < tok.size(); i += 2) if (allClasses_keywords.contains(tok.get(i)) && isIdentifier(tok.get(i + 2))) {
        while (contains(getClassDeclarationName_skippables(), get(tok, i + 2))) i += 2;
        return tok.get(i + 2);
      }
    return null;
  }

  static public AutoCloseable dm_registerAs_directLink(String... msgs) {
    Object mod = dm_current_mandatory_generic();
    return combineAutoCloseables(map(msgs, msg -> dm_vmBus_answerToMessage(msg, fConst(mod))));
  }

  static public String addPrefixIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty(prefix, s);
  }

  static public FixedRateTimer dm_doEvery(long delay, Runnable r) {
    return dm_ownTimer(doEvery(delay, delay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(long delay, long firstDelay, Runnable r) {
    return dm_ownTimer(doEvery(delay, firstDelay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double initialSeconds, double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(initialSeconds, delaySeconds, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(delaySeconds, dm_rEnter(r)));
  }

  static public String platformQuoteOpt(String s) {
    return empty(s) || containsUnsafePlatformCmdLineChar(s) ? platformQuote(s) : s;
  }

  static public String platformQuoteOpt(File f) {
    return platformQuoteOpt(f2s(f));
  }

  static public String platformQuoteOpt(Object o) {
    if (o instanceof File)
      return platformQuoteOpt((File) o);
    return platformQuoteOpt(strOrEmpty(o));
  }

  static public List<List<Rect>> gridOfRects3(int w, int h, int cols, int rows) {
    return gridOfRects3(new Rect(0, 0, w, h), cols, rows);
  }

  static public List<List<Rect>> gridOfRects3(Rect r, int cols, int rows) {
    List<List<Rect>> l = new ArrayList();
    for (int row = 0; row < rows; row++) {
      List<Rect> line = new ArrayList();
      int y1 = r.y + iround(r.h * (double) row / rows);
      int y2 = r.y + iround(r.h * (double) (row + 1) / rows);
      for (int col = 0; col < cols; col++) {
        int x1 = r.x + iround(r.w * (double) col / cols);
        int x2 = r.x + iround(r.w * (double) (col + 1) / cols);
        line.add(new Rect(x1, y1, x2 - x1, y2 - y1));
      }
      l.add(line);
    }
    return l;
  }

  static public BufferedImage mergeBufferedImagesHorizontally(BufferedImage... images) {
    return mergeBufferedImagesHorizontally(toList(images));
  }

  static public BufferedImage mergeBufferedImagesHorizontally(List<BufferedImage> images, Object... __) {
    if (empty(images))
      return null;
    int spacing = optPar("spacing", __, imageMergeSpacing());
    RGB spaceColor = new RGB(0.9f);
    int w = intSum(mapMethod("getWidth", images)) + (l(images) - 1) * spacing, h = intMax(mapMethod("getHeight", images));
    BufferedImage out = newBufferedImage(w, h, spaceColor);
    int x = 0;
    for (int i = 0; i < l(images); i++) {
      BufferedImage img = images.get(i);
      int y = (h - img.getHeight()) / 2;
      copyBufferedImage(img, out, x, y);
      x += img.getWidth() + spacing;
    }
    return out;
  }

  static public <A> IterableIterator<A> enumerationToIterator(final Enumeration<A> e) {
    return e == null ? null : new IterableIterator() {

      public boolean hasNext() {
        return e.hasMoreElements();
      }

      public A next() {
        return e.nextElement();
      }
    };
  }

  static public boolean allPaused() {
    return ping_pauseAll;
  }

  static public List<Integer> partialSums_firstIs0(List<Integer> l) {
    int n = l(l);
    IntBuffer out = new IntBuffer(n);
    int sum = 0;
    for (int i = 0; i < n; i++) {
      out.add(sum);
      sum += l.get(i);
    }
    out.add(sum);
    return out.asVirtualList();
  }

  static public Object[] params_unpackList(Object[] params) {
    if (l(params) == 1 && params[0] instanceof List)
      return toObjectArray((List) params[0]);
    return params;
  }

  static public Object pcallOpt(Object o, String method, Object... args) {
    try {
      return callOpt(o, method, args);
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A> A childOfType(Component c, Class<A> theClass) {
    return first(childrenOfType(c, theClass));
  }

  static public <A> A childOfType(Class<A> theClass, Component c) {
    return childOfType(c, theClass);
  }

  static public boolean isMac() {
    return System.getProperty("os.name").toLowerCase().contains("mac");
  }

  static public JLabel dm_centeredCalculatedLabel(IF0<Object> calc) {
    return centerLabel(dm_calculatedLabel(calc));
  }

  static public String shortName(Object o) {
    return shortClassName(o);
  }

  static public void copyStreamAndCloseAll(InputStream in, OutputStream out) {
    try {
      try {
        copyStreamAndCloseInput(in, out);
      } finally {
        out.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean md5OfFile_verbose = false;

  static public String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  static public String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel hgrid(final Object... parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel();
          Object[] _parts = flattenArray2(parts);
          panel.setLayout(new GridLayout(1, _parts.length));
          smartAdd(panel, _parts);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JPanel panel;\r\n    O[] _parts = flattenArray2(parts);\r\n    panel.setLayou...";
      }
    });
  }

  static public List<String> ai_splitCamelCase(String s) {
    int j = 0;
    List<String> l = new ArrayList();
    if (isAllUpperCase(s)) {
      l.add(s);
      return l;
    }
    for (int i = 0; i < l(s); i++) if (i > j && isUpperCaseLetter(s.charAt(i))) {
      l.add(substring(s, j, i));
      j = i;
    }
    if (j < l(s))
      l.add(substring(s, j));
    return l;
  }

  static public boolean containsLowerCase(String s) {
    for (int i = 0; i < l(s); i++) if (isLowerCase(s.charAt(i)))
      return true;
    return false;
  }

  static public String findTranslators2(String src, List<String> libsOut) {
    return join(findTranslators2(javaTok(src), libsOut));
  }

  static public List<String> findTranslators2(List<String> tok, List<String> libsOut) {
    int i;
    while ((i = jfind(tok, "!<int>")) >= 0) {
      setAdd(libsOut, tok.get(i + 2));
      clearTokens(tok, i, i + 3);
    }
    return tok;
  }

  static public Class getFieldType(Object o, String field) {
    return fieldType(o, field);
  }

  static public BufferedImage screenshot() {
    return shootScreen2();
  }

  static public BufferedImage screenshot(Rectangle area) {
    try {
      return shootScreen2(area);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage screenshot(Rect area) {
    return shootScreen2(area);
  }

  static public BufferedImage screenshot(int x, int y, int w, int h) {
    return shootScreen2(x, y, w, h);
  }

  static public String decimalFormatEnglish(String format, double d) {
    return decimalFormatEnglish(format).format(d);
  }

  static public java.text.DecimalFormat decimalFormatEnglish(String format) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
  }

  static public DynModule dm_current() {
    return dm_currentModule();
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public boolean ping_v3() {
    return ping_v3(pingSource());
  }

  static public boolean ping_v3(PingSource source) {
    {
      if (source != null)
        source.get();
    }
    return true;
  }

  static public File standardLogFile() {
    return getProgramFile("log");
  }

  static public IterableIterator emptyIterableIterator_instance = new IterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> IterableIterator<A> emptyIterableIterator() {
    return emptyIterableIterator_instance;
  }

  static public Object toJavaOpt(Object o) {
    return new ToJava().getOpt(o);
  }

  static public List<String> findBlock(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    int i = findCodeTokens(tok, toStringArray(codeTokensOnly(tokpat)));
    if (i < 0)
      return null;
    int bracketIdx = i + tokpat.size() - 3;
    assertEquals("{", tok.get(bracketIdx));
    int endIdx = findEndOfBlock(tok, bracketIdx);
    return subList(tok, i - 1, endIdx + 1);
  }

  static public JWindow showLoadingAnimation() {
    return showLoadingAnimation("Hold on user...");
  }

  static public JWindow showLoadingAnimation(String text) {
    try {
      return showAnimationInTopRightCorner("#1003543", text);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> List<List<B>> mapLevelTwo(IF1<A, B> f, Iterable<List<A>> l) {
    return mapTwoLevelsDown(f, l);
  }

  static public int[] hexToInts_dropSpaces(String s) {
    return hexToInts(dropSpaceEtc(s));
  }

  static public Object[] flattenArray2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Object[])
        l.addAll(asList((Object[]) x));
      else if (x instanceof Collection)
        l.addAll((Collection) x);
      else
        l.add(x);
    return asObjectArray(l);
  }

  static public ThreadLocal<Boolean> evalJava_prep_voidMagic = new ThreadLocal();

  static public List<String> evalJava_prePrep(String code) {
    return evalJava_prePrep(code, new EvalJavaPrep());
  }

  static public List<String> evalJava_prePrep(String code, EvalJavaPrep prep) {
    List<String> tok = javaTok(trim(code));
    int idx;
    while ((idx = jfind(tok, "global {")) >= 0) {
      int j = findEndOfBracketPart(tok, idx + 2);
      prep.global.add(joinSubList(tok, idx + 3, j - 1));
      clearTokens_reTok(tok, idx, j + 1);
    }
    if (eqGet(tok, 1, "="))
      tok = subList(tok, 2);
    if (tok_isStaticLevelCode(tok))
      return tok;
    if (!isFalse(evalJava_prep_voidMagic.get()) && tok_shouldAddReturn(tok) && eqGet(tok, 3, "(") && isIdentifier(get(tok, 1)) && isKnownVoidFunction_uncached(get(tok, 1)))
      tokAppend_reTok(tok, l(tok) - 2, ";");
    String name = null;
    if (l(tok) == 3 && isIdentifier(name = firstToken(tok)))
      tokAppend_reTok(tok, 1, "()" + (isKnownVoidFunction_uncached(name) ? ";" : ""));
    return tok;
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String formatDouble(double d) {
    return str(d);
  }

  static public String formatDouble(DoubleRange r, int digits) {
    return r == null ? "null" : "[" + formatDouble(r.start, digits) + ";" + formatDouble(r.end, digits) + "]";
  }

  static public Container getParent(final Component c) {
    return c == null ? null : swing(new F0<Container>() {

      public Container get() {
        try {
          return c.getParent();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getParent();";
      }
    });
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public boolean dir2zip_recurse_verbose = false;

  static public int dir2zip_recurse(File inDir, File zip) {
    return dir2zip_recurse(inDir, zip, "");
  }

  static public int dir2zip_recurse(File inDir, File zip, String outPrefix) {
    try {
      mkdirsForFile(zip);
      FileOutputStream fout = newFileOutputStream(zip);
      ZipOutputStream outZip = new ZipOutputStream(fout);
      try {
        return dir2zip_recurse(inDir, outZip, outPrefix, 0);
      } finally {
        outZip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip) {
    return dir2zip_recurse(inDir, outZip, "", 0);
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) {
    try {
      if (++level >= 20)
        throw fail("woot? 20 levels in zip?");
      List<File> files = new ArrayList();
      for (File f : listFiles(inDir)) files.add(f);
      int n = 0;
      sortFilesByName(files);
      for (File f : files) {
        if (f.isDirectory()) {
          if (dir2zip_recurse_verbose)
            print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
          n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
        } else {
          if (dir2zip_recurse_verbose)
            print("Copying " + f.getName());
          outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
          InputStream fin;
          try {
            fin = new FileInputStream(f);
          } catch (Throwable e) {
            print(e);
            continue;
          }
          AutoCloseable __1 = fin;
          try {
            copyStream(fin, outZip);
            ++n;
          } finally {
            _close(__1);
          }
        }
      }
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

  static public Rectangle defaultNewFrameBounds() {
    return swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          defaultNewFrameBounds_r.translate(60, 20);
          var bounds = preferredScreenBounds();
          if (!bounds.contains(defaultNewFrameBounds_r))
            defaultNewFrameBounds_r.setLocation(centerX(bounds) + random_incl(-30, 30), centerY(bounds) + random_incl(-20, 20));
          return new Rectangle(defaultNewFrameBounds_r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "defaultNewFrameBounds_r.translate(60, 20);\r\n    var bounds = preferredScreenB...";
      }
    });
  }

  static public byte[] hexToBytes_dropSpaces(String s) {
    return hexToBytes(dropSpaceEtc(s));
  }

  static public String pqO(String s) {
    return platformQuoteOpt(s);
  }

  static public String pqO(File f) {
    return platformQuoteOpt(f);
  }

  static public class jLiveValueSection_class extends SingleComponentPanel {

    public LiveValue<?> liveValue;

    public String getTitle() {
      return strOrEmpty(liveValue.get());
    }

    public jLiveValueSection_class(LiveValue<?> lv, Component c) {
      super(c);
      bindLiveValueListenerToComponent(this, liveValue = lv, new Runnable() {

        public void run() {
          try {
            swingLater(new Runnable() {

              public void run() {
                try {
                  setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), getTitle()));
                  revalidate();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "setBorder(BorderFactory.createTitledBorder(\r\n        BorderFactory.createBeve...";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "swingLater(r {\r\n      setBorder(BorderFactory.createTitledBorder(\r\n        Bo...";
        }
      });
    }
  }

  static public JPanel jLiveValueSection(LiveValue<?> lv, Component c) {
    return swingNu(jLiveValueSection_class.class, lv, c);
  }

  static public Producer<String> javaTokC_producer(String s) {
    return javaTokC_iterator(s);
  }

  static public <A> OKOrError<A> OKOrError_ok(A a) {
    return new OKOrError(a);
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public String toStringWithClassName(Object o) {
    return toStringWithClass(o);
  }

  static public File linux_fileInRamDisk(String name) {
    if (!isLinux())
      return null;
    File dir = newFile("/dev/shm");
    if (dir.isDirectory())
      return newFile(dir, name);
    return null;
  }

  static public ICachedJavaXExpr javaExpr(Object expr) {
    if (expr instanceof ICachedJavaXExpr)
      return ((ICachedJavaXExpr) expr);
    return new LiteralJavaXExpr(expr);
  }

  static public <A> ICachedJavaXExpr<A> javaExpr(Object expr, IF0<A> quickEval) {
    LiteralJavaXExpr<A> e = new LiteralJavaXExpr<>(expr);
    e.quickEval = quickEval;
    return e;
  }

  static public String shorten_str(Object o) {
    return shorten(str(o));
  }

  static public String shorten_str(Object o, int max) {
    return shorten(str(o), max);
  }

  static public String shorten_str(int max, Object o) {
    return shorten_str(o, max);
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource) {
    return hotwire_finish(classLoader, progID, javaSource, "main");
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource, String mainClass) {
    try {
      Class<?> theClass = classLoader.loadClass(mainClass);
      Class j = getJavaX();
      setOpt(theClass, "myJavaSource_code", javaSource);
      synchronized (j) {
        call(j, "setVars", theClass, progID);
        callOpt(j, "addInstance", progID, theClass);
      }
      hotwire_copyOver(theClass);
      vmBus_send("hotwireFinished", theClass, mc());
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pt topLeftCorner(Rect r) {
    return rectTopLeftCorner(r);
  }

  static public String platformQuote(String s) {
    return isWindows() ? winQuote(s) : bashQuote(s);
  }

  static public String platformQuote(File f) {
    return platformQuote(f2s(f));
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public HashSet<String> allClasses_keywords = lithashset("class", "interface", "enum", "sclass", "sinterface", "record", "srecord", "strecord", "asclass", "concept");

  static public List<List<String>> allClasses(List<String> tok) {
    List<List<String>> l = new ArrayList();
    int n = tok.size();
    HashSet<String> _allClasses_keywords = allClasses_keywords;
    for (int i = 1; i < n; i += 2) {
      String t = tok.get(i);
      if ("{".equals(t))
        i = findEndOfBlock(tok, i) - 1;
      else if (_allClasses_keywords.contains(t) && (tok_isJavaxMetaCommandLeftOf(tok, i) || !(eqGetOneOf(tok, i - 2, ".", "include") && !containsNewLine(tok.get(i - 1))))) {
        int j = i;
        while (j < n && !tok.get(j).equals("{")) j += 2;
        j = findEndOfBlock(tok, j) + 1;
        i = leftScanModifiers(tok, i);
        l.add(subList(tok, i - 1, Math.min(n, j)));
        i = j - 2;
      }
    }
    return l;
  }

  static public List<List<String>> allClasses(String text) {
    return allClasses(javaTok(text));
  }

  static public String getServerTranspiled(String snippetID) {
    return getServerTranspiled(snippetID, null);
  }

  static public boolean getServerTranspiled_printStackTrace = false;

  static public String getServerTranspiled(String snippetID, String expectedMD5) {
    try {
      if (getServerTranspiled_printStackTrace)
        printStackTrace();
      long id = parseSnippetID(snippetID);
      String text = loadPage_utf8(tb_mainServer() + "/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1" + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "") + standardCredentials());
      if (nempty(text) && neq(text, "SAME"))
        saveTranspiledCode(snippetID, text);
      return text;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> List<Pair<A, B>> nonNullPairs(Iterable<Pair<A, B>> l) {
    return filter(l, p -> p != null && p.a != null && p.b != null);
  }

  static public Boolean grabbableGrayPixels_succeeded;

  static public Throwable grabbableGrayPixels_error;

  static public boolean grabbableGrayPixels_enable = true;

  static public GrabbableGrayPixels grabbableGrayPixels(BufferedImage img) {
    if (img == null || !grabbableGrayPixels_enable)
      return null;
    try {
      var result = grabbableGrayPixels_impl(img);
      grabbableGrayPixels_succeeded = result != null;
      return result;
    } catch (Throwable e) {
      grabbableGrayPixels_error = e;
      grabbableGrayPixels_succeeded = false;
      throw rethrow(e);
    }
  }

  static public GrabbableGrayPixels grabbableGrayPixels_impl(BufferedImage img) {
    Raster raster = img.getRaster();
    SampleModel sampleModel = raster.getSampleModel();
    if (!(sampleModel instanceof PixelInterleavedSampleModel))
      return null;
    DataBufferByte dataBuffer = (DataBufferByte) (raster.getDataBuffer());
    assertEquals(1, dataBuffer.getNumBanks());
    assertEquals(DataBuffer.TYPE_BYTE, dataBuffer.getDataType());
    int w = img.getWidth(), h = img.getHeight();
    int scanlineStride = ((PixelInterleavedSampleModel) sampleModel).getScanlineStride();
    byte[] pixels = dataBuffer.getData();
    int offset = dataBuffer.getOffset();
    int translateX = raster.getSampleModelTranslateX();
    int translateY = raster.getSampleModelTranslateY();
    offset += -translateX - translateY * scanlineStride;
    return new GrabbableGrayPixels(pixels, w, h, offset, scanlineStride);
  }

  static public <A> List<WithSideValue<Integer, A>> indexAsSideValue(List<A> l) {
    List<WithSideValue<Integer, A>> out = emptyList(l);
    int n = l(l);
    for (int i = 0; i < n; i++) out.add(withSideValue(i, l.get(i)));
    return out;
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public Set<String> findFullFunctionDefs_keywords = new HashSet(splitAtSpace("static svoid ssvoid ssynchronized sbool sS sO sL"));

  static public List<List<String>> findFullFunctionDefs(List<String> tok, boolean topLevelOnly) {
    int n = l(tok);
    List<List<String>> functions = new ArrayList();
    for (int i = 1; i < n; i += 2) {
      String t = tok.get(i);
      if (topLevelOnly && eq(t, "{"))
        i = findEndOfBlock(tok, i) - 1;
      else if (findFullFunctionDefs_keywords.contains(t)) {
        int j = i + 2;
        while (j < n && !eqOneOf(tok.get(j), ";", "=", "(", "{")) j += 2;
        if ((eqGet(tok, j, "(") || eq(t, "svoid") && eqGet(tok, j, "{")) && isIdentifier(tok.get(j - 2)) && !contains(subList(tok, i, j), "new")) {
          int k = smartIndexOf(tok, "{", j);
          if (k < l(tok)) {
            k = findEndOfBlock(tok, k) + 1;
            functions.add(subList(tok, i - 1, k));
            i = k - 2;
          }
        }
      }
    }
    return functions;
  }

  static public List<List<String>> findFullFunctionDefs(String s, boolean topLevelOnly) {
    return findFullFunctionDefs(javaTok(s), topLevelOnly);
  }

  static public File makeFileNameUnique_withExtension(File f, String ext) {
    File orig = f;
    int n = 0;
    ext = addPrefixIfNempty(".", dropPrefix(".", ext));
    String name = dropSuffixIC(ext, orig.getName());
    f = new File(dirOfFile(orig), name + ext);
    while (f.exists()) f = new File(dirOfFile(orig), name + "." + (++n) + ext);
    return f;
  }

  static public boolean has(String a, String b, String c) {
    return false;
  }

  static public boolean has(T3<String, String, String> t) {
    return false;
  }

  static public OKOrError OKOrError_error(Throwable e) {
    return new OKOrError(false, e);
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public byte last(byte[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public long last(long[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last((List) l);
    if (l instanceof SortedSet)
      return (A) last((SortedSet) l);
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public <A> A last(ReverseChain<A> l) {
    return l == null ? null : l.element;
  }

  static public int last(IntBuffer buf) {
    return buf.get(buf.size() - 1);
  }

  static public byte last(ByteBuffer buf) {
    return buf.get(buf.size() - 1);
  }

  static public double last(DoubleBuffer l) {
    return l.last();
  }

  static public double last(IDoubleBuffer l) {
    return l.last();
  }

  static public long last(ILongBuffer l) {
    return l.last();
  }

  static public long last(LongBuffer l) {
    return l.last();
  }

  static public double last(SynchronizedDoubleBuffer l) {
    return l.last();
  }

  static public long last(SynchronizedLongBuffer l) {
    return l.last();
  }

  static public <A> A last(CompactLinkedHashSet<A> set) {
    return set == null ? null : set.last();
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public String intsToHex(List<Integer> l) {
    if (l == null)
      return null;
    return bytesToHex(intListToByteArray(l));
  }

  static public int intSum(Collection c, String field) {
    int sum = 0;
    for (Object o : unnull(c)) sum += toInt(getOpt(o, field));
    return sum;
  }

  static public int intSum(Iterable<Integer> l) {
    int sum = 0;
    for (Integer i : unnull(l)) if (i != null)
      sum += i;
    return sum;
  }

  static public int intSum(int... l) {
    int sum = 0;
    for (int i : unnull(l)) sum += i;
    return sum;
  }

  static public String formatDouble_noLeadingZero(double d, int digits) {
    String s = formatDouble(d, digits);
    if (startsWith(s, "-"))
      return startsWith(s, "-0.") ? "-." + dropFirst(3, s) : s;
    else
      return startsWith(s, "0.") ? dropFirst(s) : s;
  }

  static public byte[] takeFirstOfByteArray(byte[] b, int n) {
    return subByteArray(b, 0, n);
  }

  static public byte[] takeFirstOfByteArray(int n, byte[] b) {
    return takeFirstOfByteArray(b, n);
  }

  static public List<File> filesWithExtension(String ext, List<File> files) {
    return filesEndingWith(files, addPrefixIfNotEmpty2(".", ext));
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, A... keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, Iterable<A> keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public boolean dm_moduleIsPoppedOut() {
    return dm_moduleIsPoppedOut(dm_current_mandatory_generic());
  }

  static public boolean dm_moduleIsPoppedOut(Object mod) {
    return isTrue(dm_callOSOpt("stefansOS_moduleIsPoppedOut", dm_getStem(mod)));
  }

  static public File actualUserDir() {
    return new File(actualUserHome());
  }

  static public File actualUserDir(String path) {
    return new File(actualUserHome(), path);
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public double distance(double ax, double ay, double bx, double by) {
    return sqrt(sqr(bx - ax) + sqr(by - ay));
  }

  static public int distance(int a, int b) {
    return abs(a - b);
  }

  static public JPanel jrightAlignedLine(final Component... components) {
    return swing(new F0<RightAlignedLine>() {

      public RightAlignedLine get() {
        try {
          return new RightAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return RightAlignedLine(components);";
      }
    });
  }

  static public JPanel jrightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(asArray(Component.class, components));
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(DoubleRect r) {
    if (r == null)
      return null;
    int x = iround(r.x), y = iround(r.y);
    return new Rect(x, y, iround(r.x2()) - x, iround(r.y2()) - y);
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public <A> Set<A> synchroSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchroSet(Set<A> set) {
    return synchronizedSet(set);
  }

  static public String formatDouble_significant2(double d, int digits) {
    try {
      digits -= Math.floor(max(-10, Math.log10(abs(d)) + 1));
      return formatDouble(d, digits);
    } catch (Throwable _e) {
      print("Had number: " + d + ", digits: " + digits);
      throw rethrow(_e);
    }
  }

  static public Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  static public void assertPointInBounds(int x, int y, int w, int h) {
    if (x < 0)
      throw fail("x < 0", x);
    if (y < 0)
      throw fail("y < 0", y);
    if (x >= w)
      throw fail("x >= w", x, w);
    if (y >= h)
      throw fail("y >= h", y, h);
  }

  static public boolean isJavaxCompilableSnippetType(int type) {
    return isJavaxCompilableSnippetTypeExceptInclude(type) || type == javaxIncludeSnippetType();
  }

  static public <A extends JComponent> A installWindowDragger(A c) {
    onMouseDown(c, event -> new WindowDragger(event));
    return c;
  }

  static public <A extends JComponent> A onLeftClick(final A c, final Object runnable) {
    {
      swing(() -> {
        c.addMouseListener(leftClickMouseAdapter(runnable));
      });
    }
    return c;
  }

  static public TrayIcon onLeftClick(final TrayIcon c, final Object runnable) {
    {
      swing(() -> {
        c.addMouseListener(leftClickMouseAdapter_noPt(runnable));
      });
    }
    return c;
  }

  static public <A extends JComponent> A onLeftClick(final Object runnable, A c) {
    return onLeftClick(c, runnable);
  }

  static public <A extends JComponent> A onLeftClick(Runnable runnable, A c) {
    return onLeftClick((Object) runnable, c);
  }

  static public <A extends JComponent> A onLeftClick(A c, Runnable r) {
    return onLeftClick(r, c);
  }

  static public <A extends JComponent> A onLeftClick(A c, IVF1<Pt> r) {
    return onLeftClick(c, (Object) r);
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  static public class SmartTimerTask extends TimerTask implements IFieldsToList {

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { r, timer, delay, threadInfo };
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __1 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__1);
        }
      }
    }
  }

  static public boolean isString(Object o) {
    return o instanceof String;
  }

  static public Timer installTimer(JComponent component, Object r, long delay) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, Object r) {
    return installTimer(frame.getRootPane(), r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, Object r) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, long firstDelay, Object r) {
    return installTimer(component, r, delay, firstDelay);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay) {
    return installTimer(component, r, delay, firstDelay, true);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay, final boolean repeats) {
    if (component == null)
      return null;
    return (Timer) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          final Var<Timer> timer = new Var();
          timer.set(new Timer(toInt(delay), new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent _evt) {
              try {
                AutoCloseable __1 = tempActivity(r);
                try {
                  try {
                    if (!allPaused())
                      if (isFalse(callF(r)))
                        cancelTimer(timer.get());
                  } catch (Throwable __e) {
                    pcallFail(__e);
                  }
                } finally {
                  _close(__1);
                }
              } catch (Throwable __e) {
                messageBox(__e);
              }
            }
          }));
          timer.get().setInitialDelay(toInt(firstDelay));
          timer.get().setRepeats(repeats);
          bindTimerToComponent(timer.get(), component);
          return timer.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<Timer> timer;\r\n    timer.set(new Timer(toInt(delay), actionList...";
      }
    });
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    return installTimer(frame.getRootPane(), delay, firstDelay, r);
  }

  static public <A> boolean setAdd(Collection<A> c, A a) {
    if (c == null || c.contains(a))
      return false;
    c.add(a);
    return true;
  }

  static public <Data> JECompressionSearch<Data> jeCompressionSearch(Data data, long inputSize) {
    return new JECompressionSearch<Data>(data, inputSize);
  }

  static public <A, B> void syncMapPutOrRemove(Map<A, B> map, A key, B value) {
    syncMapPut2(map, key, value);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rectangle clip) {
    return clipBufferedImage(src, new Rect(clip));
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rect r) {
    if (src == null || r == null)
      return null;
    r = intersectRects(r, new Rect(0, 0, src.getWidth(), src.getHeight()));
    if (rectEmpty(r))
      return null;
    return src.getSubimage(r.x, r.y, r.w, r.h);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, int x, int y, int w, int h) {
    return clipBufferedImage(src, new Rect(x, y, w, h));
  }

  static public AutoCloseable temp_loadPage_silent() {
    return tempSetThreadLocal(loadPage_silent, true);
  }

  static public List<Integer> lInts(String hex) {
    return byteArrayToIntList_littleEndian(hexToBytes_dropSpaces(hex));
  }

  static public boolean veryQuickJava_silent = true;

  static public boolean veryQuickJava_useCompilerBot = true;

  static public ThreadLocal<String> veryQuickJava_transpiled = new ThreadLocal();

  static public Object veryQuickJava3_cacheFunction;

  static public ThreadLocal<IVF1<String>> veryQuickJava_onJavaSource = new ThreadLocal();

  static public Class veryQuickJava3(String mainJava) {
    return veryQuickJava3(mainJava, emptyList());
  }

  static public Class veryQuickJava3(String mainJava, List<String> libs) {
    Class c = (Class) (callF(veryQuickJava3_cacheFunction, mainJava, libs));
    if (c != null)
      return c;
    transpileRaw_silent = veryQuickJava_silent;
    String src = transpileRaw(mainJava);
    if (empty(src)) {
      printWithIndent("JAVAX> ", mainJava);
      throw fail("Transpiler returned empty result");
    }
    if (veryQuickJava_transpiled.get() != null)
      veryQuickJava_transpiled.set(src);
    callF(veryQuickJava_onJavaSource.get(), src);
    return veryQuickJava_finish(src, libs);
  }

  static public Border jCompoundBorder(Border inner, Border outer) {
    if (inner == null)
      return outer;
    if (outer == null)
      return inner;
    return BorderFactory.createCompoundBorder(inner, outer);
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public void dm_reloadModule(Object module) {
    dm_reloadModuleInBackground(module);
  }

  static public void dm_reloadModule() {
    dm_reloadModuleInBackground();
  }

  static public List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  static public List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  static public ThreadLocal<Boolean> htmlencode_forParams_useV2 = new ThreadLocal();

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    if (isTrue(htmlencode_forParams_useV2.get()))
      return htmlencode_forParams_v2(s);
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String formatDouble1(double d) {
    return formatDouble(d, 1);
  }

  static public <A> void methodForEach(IVF1<A> f, Iterable<A> l) {
    forEach(f, l);
  }

  static public <A> void methodForEach(IVF1<A> f, A[] l) {
    forEach(f, l);
  }

  static public File tempDir() {
    return makeTempDir();
  }

  static public JPanel centerAndNorth(final Component c, final Component n) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.NORTH, wrap(n));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public boolean setText_opt = true;

  static public <A extends JTextComponent> A setText(A c, Object text) {
    setText((JComponent) c, text);
    return c;
  }

  static public <A extends JComboBox> A setText(final A c, Object text) {
    final String s = strUnnull(text);
    {
      swing(() -> {
        c.getEditor().setItem(s);
      });
    }
    return c;
  }

  static public void setText(JLabel c, Object text) {
    setText((JComponent) c, text);
  }

  static public JButton setText(JButton c, Object text) {
    setText((JComponent) c, jlabel_textAsHTML_center_ifNeeded(strUnnull(text)));
    return c;
  }

  static public <A extends JComponent> A setText(final A c, Object text) {
    if (c == null)
      return null;
    final String s = strUnnull(text);
    {
      swing(() -> {
        if (!setText_opt || neq(callOpt(c, "getText"), s))
          call(c, "setText", s);
      });
    }
    return c;
  }

  static public String intToHex(int i) {
    return bytesToHex(intToBytes(i));
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public String jlabel_textAsHTML_center(String text) {
    return "<html><div style=\"text-align: center;\">" + replace(htmlencode2(text), "\n", "<br>") + "</div></html>";
  }

  static public int findBeginningOfBlock(List<String> cnc, int i) {
    int j = i - 2, level = 1;
    while (j > 0) {
      if (eq(cnc.get(j), "}"))
        ++level;
      else if (eq(cnc.get(j), "{"))
        --level;
      if (level == 0)
        return j;
      j -= 2;
    }
    return -1;
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public TreeSet<Symbol> litciset(Symbol... items) {
    TreeSet<Symbol> set = treeSet();
    for (Symbol a : items) set.add(a);
    return set;
  }

  static public JButton findButton(Component c, String name) {
    for (JButton b : childrenOfType(c, JButton.class)) if (eq(b.getText(), name))
      return b;
    for (JButton b : childrenOfType(getFrame(c), JButton.class)) if (eq(b.getText(), name))
      return b;
    return null;
  }

  static public JButton findButton(Component c) {
    return childOfType(c, JButton.class);
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public File getCanonicalFile(String path) {
    try {
      return path == null ? null : newFile(path).getCanonicalFile();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getCanonicalFile(File f) {
    try {
      return f == null ? null : f.getCanonicalFile();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public Number parseIntOrLong(String s) {
    long l = parseLong(s);
    return longIsInt(l) ? (Number) (int) l : (Number) l;
  }

  static public MouseAdapter leftClickMouseAdapter(final Object r) {
    return new MouseAdapter() {

      public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1)
          pcallF(r, new Pt(e.getPoint()));
      }
    };
  }

  static public String toJava(Object o) {
    return str(new ToJava().get(o));
  }

  static public Rectangle getBounds(final Component c) {
    return c == null ? null : swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          return c.getBounds();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getBounds();";
      }
    });
  }

  static public JPanel northAndCenterWithMargin(int margin, Swingable n, Swingable c) {
    return northAndCenterWithMargin(margin, n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargin(int margin, Swingable n, Component c) {
    return northAndCenterWithMargin(margin, toComponent(n), c);
  }

  static public JPanel northAndCenterWithMargin(int margin, Component n, Swingable c) {
    return northAndCenterWithMargin(margin, n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargin(int margin, Component n, Component c) {
    return northAndCenter(withBottomMargin(margin, n), c);
  }

  static public JPanel northAndCenterWithMargin(Swingable n, Swingable c) {
    return northAndCenterWithMargin(n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargin(Swingable n, Component c) {
    return northAndCenterWithMargin(toComponent(n), c);
  }

  static public JPanel northAndCenterWithMargin(Component n, Swingable c) {
    return northAndCenterWithMargin(n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargin(Component n, Component c) {
    return northAndCenter(withBottomMargin(n), c);
  }

  static public <A> A printIndent(A o) {
    print(indentx(str(o)));
    return o;
  }

  static public <A> A printIndent(String indent, A o) {
    print(indentx(indent, str(o)));
    return o;
  }

  static public void printIndent(int indent, Object o) {
    print(indentx(indent, str(o)));
  }

  static public <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  static public String loadTextFileResource(ClassLoader cl, String name) {
    return inputStreamToString(cl.getResourceAsStream(name));
  }

  static public int leftScanModifiers(List<String> tok, int i) {
    return leftScanModifiers(tok, i, getJavaModifiers());
  }

  static public int leftScanModifiers(List<String> tok, int i, Collection<String> modifiers) {
    while (i > 1 && contains(modifiers, tok.get(i - 2))) i -= 2;
    return i;
  }

  static public String renderUserThreadsWithStackTraces() {
    return renderUserThreadsWithStackTraces(mapWithout(Thread.getAllStackTraces(), currentThread()));
  }

  static public String renderUserThreadsWithStackTraces(Map<Thread, StackTraceElement[]> threadMap) {
    return renderUserThreadsWithStackTraces(threadMap, "thread");
  }

  static public String renderUserThreadsWithStackTraces(Map<Thread, StackTraceElement[]> threadMap, String threadDescription) {
    StringBuilder bufRunnable = new StringBuilder();
    StringBuilder bufWaiting = new StringBuilder();
    int nRunnable = 0, nWaiting = 0, nSystem = 0;
    for (var __0 : _entrySet(threadMap)) {
      var t = __0.getKey();
      var stackTrace = __0.getValue();
      boolean runnable = isThreadRunnable_x(t, stackTrace);
      var buf = runnable ? bufRunnable : bufWaiting;
      ThreadGroup g = t.getThreadGroup();
      if (g != null && g.getName().equals("system")) {
        ++nSystem;
        continue;
      }
      if (runnable)
        ++nRunnable;
      else
        ++nWaiting;
      printTo(buf, t);
      for (StackTraceElement e : threadMap.get(t)) printTo(buf, "  " + e);
      printTo(buf);
    }
    return asciiHeading2(n2(nRunnable, "runnable " + threadDescription)) + "\n" + bufRunnable + asciiHeading2(n2(nWaiting, "sleeping " + threadDescription) + " (+" + n2(nSystem, "system thread") + ")") + "\n" + bufWaiting;
  }

  static public String nBytes(long n) {
    return n2(n, "byte");
  }

  static public String nBytes(Collection l) {
    return nBytes(l(l));
  }

  static public String nBytes(byte[] l) {
    return nBytes(l(l));
  }

  static public String loadTextFilePossiblyGZipped(String fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
    File gz = new File(fileName + ".gz");
    return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
  }

  static public String loadTextFilePossiblyGZipped(File fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
    return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
  }

  static public Concepts newConceptsWithClassFinder(String progID) {
    Concepts cc = new Concepts(progID);
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public Concepts newConceptsWithClassFinder(File conceptsFile) {
    Concepts cc = new Concepts(assertNotNull(conceptsFile));
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public Concepts newConceptsWithClassFinder(File conceptsFile, IF1<String, Class> classFinder) {
    Concepts cc = new Concepts(assertNotNull(conceptsFile));
    cc.classFinder = classFinder;
    return cc;
  }

  static public float getSwingFontScale() {
    return or((Float) vm_generalMap_get("swingFontScale_value"), 1f);
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static public int snippetType_javaxDesktopModule() {
    return 58;
  }

  static public boolean substanceLookAndFeelEnabled() {
    return startsWith(getLookAndFeel(), "org.pushingpixels.");
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public String selectedItem(JList l) {
    return getSelectedItem(l);
  }

  static public String selectedItem(JComboBox cb) {
    return getSelectedItem(cb);
  }

  static public List<String> codeTokensOnly(List<String> tok) {
    int n = l(tok);
    List<String> l = emptyList(n / 2);
    for (int i = 1; i < n; i += 2) l.add(tok.get(i));
    return l;
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public int[] matrixToIntArray(Matrix<Integer> m) {
    int w = m.getWidth(), h = m.getHeight(), n = w * h;
    int[] a = new int[n];
    int i = 0;
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) a[i++] = m.get(x, y);
    return a;
  }

  static public void printTo(StringBuilder buf, Object o) {
    buf.append(str(o)).append("\n");
  }

  static public void printTo(StringBuilder buf) {
    printTo(buf, "");
  }

  static public File appendToFileNameBeforeExtension(File f, String s) {
    String ext = fileExtension(f);
    String name = dropSuffixIC(ext, f.getName());
    name += s;
    return newFile(parentFile(f), name + ext);
  }

  static public F1 functionToF1(final Object f) {
    if (isString(f))
      return mainFunctionToF1((String) f);
    if (f instanceof F1)
      return (F1) f;
    return new F1<Object, Object>() {

      public Object get(Object a) {
        try {
          return callF(f, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret callF(f, a);";
      }
    };
  }

  static public boolean isSpaceEtc(char c) {
    return c == ' ' || c == '\t' || c == '\r' || c == '\n';
  }

  static public long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1, n = s.length();
    while (i < n && s.charAt(i) == '=') ++i;
    return i < n && s.charAt(i) == '[';
  }

  static public JWindow loadingAnim() {
    return showLoadingAnimation();
  }

  static public JWindow loadingAnim(String text) {
    return showLoadingAnimation(text);
  }

  static public void saveGZTextFile(File file, String contents) {
    saveGZTextFile(file, contents, "UTF-8");
  }

  static public void saveGZTextFile(File file, String contents, String encoding) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = file.getPath() + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, encoding);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Frame getAWTFrame(final Object _o) {
    return swing(new F0<Frame>() {

      public Frame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof Frame)
              return (Frame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ...";
      }
    });
  }

  static public BufferedImage defaultScreenshot() {
    if (hasGlobalOption("canDefaultScreenshot"))
      return shootScreen2();
    return null;
  }

  static public <A> boolean setVar_trueIfChanged(IVar<A> v, A value) {
    if (v == null)
      return false;
    synchronized (v) {
      if (eq(v.get(), value))
        return false;
      v.set(value);
      return true;
    }
  }

  static public String nEntries(long n) {
    return n2(n, "entry", "entries");
  }

  static public String nEntries(Collection l) {
    return nEntries(l(l));
  }

  static public String nEntries(Map map) {
    return nEntries(l(map));
  }

  static public int[] hexToInts(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 8;
    int[] ints = new int[n];
    for (int i = 0; i < n; i++) {
      int value = 0;
      for (int j = 0; j < 4; j++) {
        int idx = i * 8 + j * 2;
        int a = parseHexChar(s.charAt(idx));
        int b = parseHexChar(s.charAt(idx + 1));
        if (a < 0 || b < 0)
          throw fail("Bad hex byte: " + quote(substring(s, idx, idx + 2)) + " at " + idx + "/" + l(s));
        value |= ((a << 4) | b) << (j * 8);
      }
      ints[i] = value;
    }
    return ints;
  }

  static public <A, B> void syncMapPut2(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      synchronized (collectionMutex(map)) {
        if (value != null)
          map.put(key, value);
        else
          map.remove(key);
      }
  }

  static public <A, B> List<Pair<A, B>> mapToPairs(Map<A, B> map) {
    List<Pair<A, B>> l = emptyList(l(map));
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) l.add(pair(e.getKey(), e.getValue()));
    return l;
  }

  static public boolean isJavaxApplicationSnippetType(int type) {
    return type == snippetType_javaxSource() || type == snippetType_JavaXDesktop();
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public JComboBox onSelectedItem(final JComboBox cb, final VF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public JComboBox onSelectedItem(final JComboBox cb, IVF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public Boolean askTripleBool(String q) {
    print(q + " no idea");
    return null;
  }

  static public <A extends AutoCloseable> A dm_ownResource(A resource) {
    dm_currentModuleMandatory().ownResource(resource);
    return resource;
  }

  static public int ratioToIntPercent(double x, double y) {
    return roundToInt(x * 100 / y);
  }

  static public BufferedImage loadPNG(File file) {
    return loadBufferedImage(file);
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, ITokCondition condition, String out) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public class tempRememberListener_c implements IFieldsToList {

    static final public String _fieldOrder = "mainObject removeMethod listener";

    public Object mainObject;

    public String removeMethod;

    public Object listener;

    public tempRememberListener_c() {
    }

    public tempRememberListener_c(Object mainObject, String removeMethod, Object listener) {
      this.listener = listener;
      this.removeMethod = removeMethod;
      this.mainObject = mainObject;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + mainObject + ", " + removeMethod + ", " + listener + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof tempRememberListener_c))
        return false;
      tempRememberListener_c __1 = (tempRememberListener_c) o;
      return eq(mainObject, __1.mainObject) && eq(removeMethod, __1.removeMethod) && eq(listener, __1.listener);
    }

    public int hashCode() {
      int h = 1262836985;
      h = boostHashCombine(h, _hashCode(mainObject));
      h = boostHashCombine(h, _hashCode(removeMethod));
      h = boostHashCombine(h, _hashCode(listener));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { mainObject, removeMethod, listener };
    }
  }

  static public AutoCloseable tempRememberListener(Object mainObject, String removeMethod, Object listener) {
    return tempHoldInstance(new tempRememberListener_c(mainObject, removeMethod, listener));
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public boolean newButton_autoToolTip = true;

  static public boolean newButton_autoToolTip() {
    return newButton_autoToolTip;
  }

  static public JButton newButton(final String text, final Object action) {
    return swing(new F0<JButton>() {

      public JButton get() {
        try {
          String text2 = dropPrefix("[disabled] ", text);
          JButton btn = basicJButton(text2);
          if (l(text2) < l(text))
            btn.setEnabled(false);
          if (newButton_autoToolTip) {
            btn.setToolTipText(btn.getText());
          }
          if (action != null)
            btn.addActionListener(actionListener(action, btn));
          return btn;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S text2 = dropPrefix(\"[disabled] \", text);\r\n    JButton btn = basicJButton(te...";
      }
    });
  }

  static public String smartJoin(String[] args) {
    if (empty(args))
      return "";
    if (args.length == 1)
      return args[0];
    String[] a = new String[args.length];
    for (int i = 0; i < a.length; i++) a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
    return join(" ", a);
  }

  static public String smartJoin(List<String> args) {
    return smartJoin(toStringArray(args));
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public void onUpdate(JComponent c, Runnable r) {
    onUpdate(c, (Object) r);
  }

  static public void onUpdate(JTextComponent c, IVF1<String> r) {
    if (c == null || r == null)
      return;
    c.getDocument().addDocumentListener(runnableToDocumentListener(() -> r.get(c.getText())));
  }

  static public void onUpdate(JComponent c, Object r) {
    if (c instanceof JTextComponent)
      ((JTextComponent) c).getDocument().addDocumentListener(runnableToDocumentListener(toRunnable(r)));
    else if (c instanceof ItemSelectable)
      ((ItemSelectable) c).addItemListener(new ItemListener() {

        public void itemStateChanged(ItemEvent e) {
          pcallF(r);
        }
      });
    else if (c instanceof JSpinner)
      onChange(((JSpinner) c), r);
    else
      print("Warning: onUpdate doesn't know " + getClassName(c));
  }

  static public void onUpdate(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public List flattenIterablesAndArrays(Iterable a) {
    List l = new ArrayList();
    for (Object x : a) if (x instanceof Iterable)
      l.addAll(flattenIterablesAndArrays((Iterable) x));
    else if (x instanceof Iterator)
      l.addAll(flattenIterablesAndArrays(asList((Iterator) x)));
    else if (x instanceof Object[])
      l.addAll(flattenIterablesAndArrays(asList((Object[]) x)));
    else
      l.add(x);
    return l;
  }

  static public int intMax(Collection c, String field) {
    int max = Integer.MIN_VALUE;
    for (Object o : c) max = Math.max(max, toInt(getOpt(o, field)));
    return max;
  }

  static public int intMax(Iterable<Integer> l) {
    int max = Integer.MIN_VALUE;
    for (int i : unnullForIteration(l)) max = Math.max(max, i);
    return max;
  }

  static public int intMax(int... l) {
    int max = Integer.MIN_VALUE;
    if (l != null)
      for (int i : l) max = Math.max(max, i);
    return max;
  }

  static public <B, A extends Collection<B>> A addAndReturnCollection(A c, B a) {
    if (c != null)
      c.add(a);
    return c;
  }

  static public boolean activateFrame(final Component c, Object... __) {
    return swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          Frame f = getAWTFrame(c);
          if (f == null)
            return false;
          if (!f.isVisible())
            f.setVisible(true);
          boolean windowsHack = optPar("windowsHack", __, true);
          boolean iconified = f.getState() == Frame.ICONIFIED;
          boolean maximize = boolPar("maximize", __);
          if (iconified)
            f.setState(maximize ? Frame.MAXIMIZED_BOTH : Frame.NORMAL);
          if (windowsHack && !iconified && isWindows()) {
            boolean fullscreen = f.getExtendedState() == Frame.MAXIMIZED_BOTH;
            f.setExtendedState(JFrame.ICONIFIED);
            f.setExtendedState(fullscreen ? JFrame.MAXIMIZED_BOTH : JFrame.NORMAL);
          }
          f.toFront();
          return true;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Frame f = getAWTFrame(c);\r\n    if (f == null) false;\r\n    if (!f.isVisible())...";
      }
    });
  }

  static public void awtLater(int delay, final Object r) {
    swingLater(delay, r);
  }

  static public void awtLater(int delay, Runnable r) {
    swingLater(delay, r);
  }

  static public void awtLater(Object r) {
    swingLater(r);
  }

  static public void awtLater(double delaySeconds, Runnable r) {
    swingLater(toMS(delaySeconds), r);
  }

  static public void awtLater(JComponent component, int delay, Object r) {
    installTimer(component, r, delay, delay, false);
  }

  static public void awtLater(JFrame frame, int delay, Object r) {
    awtLater(frame.getRootPane(), delay, r);
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public FunctionCall functionCall_list(Object fname, Iterable args) {
    return new FunctionCall(fname, toObjectArray(args));
  }

  static public ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  static public void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  static public boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public void profileToConsole(Runnable r) {
    poorMansProfileToConsole(r);
  }

  static public <A> A profileToConsole(IF0<A> r) {
    if (r == null)
      return null;
    Var<A> var = new Var();
    poorMansProfileToConsole(new Runnable() {

      public void run() {
        try {
          var.set(r.get());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var.set(r!)";
      }
    });
    return var.get();
  }

  static public boolean neqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return false;
    return true;
  }

  static public List<File> myLibraryFiles() {
    Collection<File> files = (Collection<File>) (getOpt(myClassLoader(), "files"));
    if (files != null)
      return asList(files);
    return ll(getBytecodePathForClass(mc()));
  }

  static public Object dm_javaEval(String expression) {
    return dm_evalJava_withModule(expression);
  }

  static public Object dm_javaEval(ICachedJavaXExpr expression) {
    return dm_evalJava_withModule(str(expression));
  }

  static public String nChars(long n) {
    return n2(n, "char");
  }

  static public String nChars(String s) {
    return nChars(l(s));
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    IContentsIndexedList2 indexedList = tok instanceof IContentsIndexedList2 ? (IContentsIndexedList2) tok : null;
    TreeSet<HasIndex> indices = null;
    int indicesOfs = 0;
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else {
        matcher = t -> t.equals(p);
        if (indexedList != null) {
          TreeSet<HasIndex> indices2 = indexedList.indicesOf_treeSetOfHasIndex(p);
          if (indices2 == null)
            return -1;
          if (indices == null || indices2.size() < indices.size()) {
            indices = indices2;
            indicesOfs = j;
          }
        }
      }
      matchers[j] = matcher;
    }
    if (indices != null) {
      int min = i + indicesOfs * 2;
      SortedSet<HasIndex> tailSet = min == 1 ? indices : indices.tailSet(new HasIndex(min));
      outer: for (HasIndex h : tailSet) {
        int idx = h.idx - indicesOfs * 2;
        if (idx >= end)
          break;
        for (int j = 0; j < nTokens; j++) try {
          if (!matchers[j].get(tok.get(idx + j * 2)))
            continue outer;
        } catch (IndexOutOfBoundsException e) {
          print("fct indicesOfs=" + indicesOfs + ", h=" + h + ", idx=" + idx);
          throw e;
        }
        if (condition == null || checkTokCondition(condition, tok, idx - 1))
          return idx;
      }
      return -1;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public <A extends JComponent> A withTypeWriterFont(A c) {
    return setFont(c, typeWriterFont());
  }

  static public String dropTranslators(String src) {
    return findTranslators2(src, null);
  }

  static public List<String> dropTranslators(List<String> tok) {
    return findTranslators2(tok, null);
  }

  static public <A> void printWithMS(A a) {
    printWithMS("", a);
  }

  static public <A> void printWithMS(String prefix, A a) {
    printWithMSTime(prefix, a);
  }

  static public void tokAppend(List<String> tok, int i, String s) {
    tok.set(i, tok.get(i) + s);
  }

  static public <A, B> List<B> lambdaMethodMap(IF1<A, B> f, Iterable<A> l) {
    return map(f, l);
  }

  static public <A, B> List<B> lambdaMethodMap(IF1<A, B> f, A[] l) {
    return map(f, l);
  }

  static public BufferedImage matrixToImage(Matrix<Integer> m) {
    return intMatrixToBufferedImage(m);
  }

  static public JSplitPane setSplitPaneOnFirstShowing(Component c, double value) {
    return setSplitPaneOnFirstShowing(c, value, 0);
  }

  static public JSplitPane setSplitPaneOnFirstShowing(Component c, double value, int delay) {
    final JSplitPane sp = first(childrenOfType(c, JSplitPane.class));
    if (sp != null)
      onFirstResize(sp, new Runnable() {

        public void run() {
          try {
            if (delay == 0)
              sp.setDividerLocation(value);
            else
              awtLater(delay, new Runnable() {

                public void run() {
                  try {
                    sp.setDividerLocation(value);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "sp.setDividerLocation(value);";
                }
              });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef setSplitPaneOnFirstShowing_debug\r\n        printVars setSplitPaneOnFirst...";
        }
      });
    return sp;
  }

  static public boolean vmBus_noObjections(String msg, Object... args) {
    return !vmBus_anyFalse(msg, args);
  }

  static public String format(String pat, Object... args) {
    return format3(pat, args);
  }

  static public Object vmGeneralMap_get(Object key) {
    return vm_generalMap_get(key);
  }

  static public int heightForWidth(int w, int h, int newWidth) {
    return iround(newWidth * doubleRatio(h, w));
  }

  static public int heightForWidth(BufferedImage img, int newWidth) {
    return heightForWidth(img.getWidth(), img.getHeight(), newWidth);
  }

  static public int heightForWidth(int newWidth, BufferedImage img) {
    return heightForWidth(img, newWidth);
  }

  static public int heightForWidth(WidthAndHeight img, int newWidth) {
    return heightForWidth(img.getWidth(), img.getHeight(), newWidth);
  }

  static public String strUnnull(Object o) {
    return o == null ? "" : str(o);
  }

  static public boolean isSymLink(File f) {
    return f != null && Files.isSymbolicLink(toPath(f));
  }

  static public Object get2(Object o, String field1, String field2) {
    return get(get(o, field1), field2);
  }

  static public <A, B> A eitherAOpt(Either<A, B> e) {
    return e != null && e.isA() ? e.a() : null;
  }

  static public JTextField onEnter(JTextField tf, JButton btn) {
    if (btn != null)
      onEnter(tf, new Runnable() {

        public void run() {
          try {
            clickButton(btn);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "clickButton(btn)";
        }
      });
    return tf;
  }

  static public JTextField onEnter(JTextField tf, Object action) {
    if (action == null || tf == null)
      return tf;
    tf.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          tf.selectAll();
          callF(action);
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    });
    return tf;
  }

  static public JButton onEnter(JButton btn, final Object action) {
    if (action == null || btn == null)
      return btn;
    btn.addActionListener(actionListener(action));
    return btn;
  }

  static public JList onEnter(JList list, Object action) {
    list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
    return list;
  }

  static public JComboBox onEnter(final JComboBox cb, Runnable action) {
    {
      swing(() -> {
        if (cb.isEditable()) {
          JTextField text = (JTextField) cb.getEditor().getEditorComponent();
          onEnter(text, action);
        } else {
          cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
          cb.getActionMap().put("enter", abstractAction("", new Runnable() {

            public void run() {
              try {
                cb.hidePopup();
                callF(action);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "cb.hidePopup(); callF(action);";
            }
          }));
        }
      });
    }
    return cb;
  }

  static public JTable onEnter(final JTable table, final Object action) {
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    table.getActionMap().put("Enter", new AbstractAction() {

      public void actionPerformed(ActionEvent e) {
        callF(action, table.getSelectedRow());
      }
    });
    return table;
  }

  static public JTextField onEnter(Runnable action, JTextField tf) {
    return onEnter(tf, action);
  }

  static public boolean vmBus_anyFalse(String msg, Object... args) {
    return contains(vmBus_queryAll(msg, args), false);
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public <A> Matrix<A> listToMatrix(int w, List<A> data) {
    int n = l(data);
    int h = n / w;
    if (w * h != n)
      throw fail("Bad size", "n", n, "w", w, "h", h);
    return new ListToMatrix(w, h, data);
  }

  static public JSplitPane hsplit(Component l, Component r) {
    return jhsplit(l, r);
  }

  static public JSplitPane hsplit(Component l, Component r, double splitPoint, int delay) {
    return jhsplit(l, r, splitPoint, delay);
  }

  static public JSplitPane hsplit(Component l, Component r, double splitPoint) {
    return jhsplit(l, r, splitPoint);
  }

  static public JSplitPane hsplit(double splitPoint, Component l, Component r) {
    return jhsplit(splitPoint, l, r);
  }

  static public String mcDollar() {
    return mcName() + "$";
  }

  static public ChangeListener changeListener(final Object r) {
    return new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(r);
      }
    };
  }

  static public Rectangle screenRectangle() {
    return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
  }

  static public Rectangle screenRectangle(GraphicsDevice device) {
    if (device == null)
      return null;
    DisplayMode mode = device.getDisplayMode();
    return new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
  }

  static public <A, B> List<B> mapWithIndex(List<A> l, IF2<Integer, A, B> f) {
    List<B> out = emptyList(l);
    for (int i = 0; i < l(l); i++) out.add(f.get(i, l.get(i)));
    return out;
  }

  static public <A, B> List<B> mapWithIndex(IF2<Integer, A, B> f, List<A> l) {
    return mapWithIndex(l, f);
  }

  static public boolean set_trueIfChanged(Object o, String field, Object value) {
    if (eq(get(o, field), value))
      return false;
    set(o, field, value);
    return true;
  }

  static public <A> boolean set_trueIfChanged(IVar<A> v, A value) {
    return setVar_trueIfChanged(v, value);
  }

  static public boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  static public void copyStreamAndCloseInput(InputStream in, OutputStream out) {
    try {
      try {
        copyStream(in, out);
      } finally {
        in.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel centerAndEastWithMargin(Swingable c, Swingable e) {
    return centerAndEastWithMargin(c, toComponent(e));
  }

  static public JPanel centerAndEastWithMargin(Swingable c, Component e) {
    return centerAndEastWithMargin(toComponent(c), e);
  }

  static public JPanel centerAndEastWithMargin(Component c, Swingable e) {
    return centerAndEastWithMargin(c, toComponent(e));
  }

  static public JPanel centerAndEastWithMargin(Component c, Component e) {
    return centerAndEastWithMarginInbetween(c, e);
  }

  static public void retireClassLoader(ClassLoader cl) {
    try {
      if (isJavaXClassLoader(cl))
        setOptAll(cl, "retired", true, "retiredMarker", new DefunctClassLoader());
    } catch (Throwable __e) {
      pcallFail(__e);
    }
  }

  static public JFrame getFrame(final Object _o) {
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JFrame)
              return (JFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A> A dm_evalInQ(F0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), f);
  }

  static public <A> A dm_evalInQ(IF0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), if0ToF0(f));
  }

  static public <A> A dm_evalInQ(DynModule module, F0<A> f) {
    return evalInQ(module.q(), f);
  }

  static public IterableIterator<Integer> countIterator_exclusive(int b) {
    return countIterator_exclusive(0, b);
  }

  static public IterableIterator<Integer> countIterator_exclusive(int a, int b) {
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Integer next() {
        return i++;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_exclusive(int b, IF1<Integer, A> f) {
    return countIterator_exclusive(0, b, f);
  }

  static public <A> IterableIterator<A> countIterator_exclusive(int a, int b, IF1<Integer, A> f) {
    return mapI_if1(f, countIterator_exclusive(a, b));
  }

  static public JPanel centerAndSouth(final Component c, final Component s) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          if (s != null)
            panel.add(BorderLayout.SOUTH, wrap(s));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public JScrollPane jscroll_center(Component c) {
    return jscroll_centered(c);
  }

  static public JSplitPane jhsplit(Swingable l, Swingable r) {
    return jhsplit(l, toComponent(r));
  }

  static public JSplitPane jhsplit(Swingable l, Component r) {
    return jhsplit(toComponent(l), r);
  }

  static public JSplitPane jhsplit(Component l, Swingable r) {
    return jhsplit(l, toComponent(r));
  }

  static public JSplitPane jhsplit(Component l, Component r) {
    return jhsplit(l, r, 0.5);
  }

  static public JSplitPane jhsplit(Swingable l, Swingable r, double splitPoint, int delay) {
    return jhsplit(l, toComponent(r), splitPoint, delay);
  }

  static public JSplitPane jhsplit(Swingable l, Component r, double splitPoint, int delay) {
    return jhsplit(toComponent(l), r, splitPoint, delay);
  }

  static public JSplitPane jhsplit(Component l, Swingable r, double splitPoint, int delay) {
    return jhsplit(l, toComponent(r), splitPoint, delay);
  }

  static public JSplitPane jhsplit(Component l, Component r, double splitPoint, int delay) {
    return jhsplit(l, r, splitPoint);
  }

  static public JSplitPane jhsplit(Swingable l, Swingable r, double splitPoint) {
    return jhsplit(l, toComponent(r), splitPoint);
  }

  static public JSplitPane jhsplit(Swingable l, Component r, double splitPoint) {
    return jhsplit(toComponent(l), r, splitPoint);
  }

  static public JSplitPane jhsplit(Component l, Swingable r, double splitPoint) {
    return jhsplit(l, toComponent(r), splitPoint);
  }

  static public JSplitPane jhsplit(Component l, Component r, double splitPoint) {
    return setSplitPaneOnFirstShowing(swingNu(JSplitPane.class, JSplitPane.HORIZONTAL_SPLIT, wrap(l), wrap(r)), splitPoint);
  }

  static public JSplitPane jhsplit(double splitPoint, Swingable l, Swingable r) {
    return jhsplit(splitPoint, l, toComponent(r));
  }

  static public JSplitPane jhsplit(double splitPoint, Swingable l, Component r) {
    return jhsplit(splitPoint, toComponent(l), r);
  }

  static public JSplitPane jhsplit(double splitPoint, Component l, Swingable r) {
    return jhsplit(splitPoint, l, toComponent(r));
  }

  static public JSplitPane jhsplit(double splitPoint, Component l, Component r) {
    return jhsplit(l, r, splitPoint);
  }

  static public SimpleLiveValue dm_fieldLiveValue(String fieldName) {
    return dm_fieldLiveValue(dm_current_mandatory(), fieldName);
  }

  static public SimpleLiveValue dm_fieldLiveValue(DynModule module, String fieldName) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      AutoCloseable __2 = module.enter();
      try {
        Class type = getFieldType(module, fieldName);
        final SimpleLiveValue value = new SimpleLiveValue(type, get(module, fieldName));
        dm_watchField(fieldName, new Runnable() {

          public void run() {
            try {
              Object o = get(module, fieldName);
              value.set(o);
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting \" + fi...";
          }
        });
        value.onChange(new Runnable() {

          public void run() {
            try {
              module.setField(fieldName, value.get());
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting 2 \" + ...";
          }
        });
        return value;
      } finally {
        _close(__2);
      }
    } finally {
      unlock(__0);
    }
  }

  static public SimpleLiveValue dm_fieldLiveValue(String fieldName, DynModule module) {
    return dm_fieldLiveValue(module, fieldName);
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public double elapsedMinutes_timestamp(long time) {
    return toMinutes(now() - time);
  }

  static public void toggleAlwaysOnTop(Window frame) {
    if (frame == null)
      return;
    {
      swing(() -> {
        frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
      });
    }
  }

  static public String percentRatioStrOneDigit(double x) {
    return percentRatioStrOneDigit(x, 1);
  }

  static public String percentRatioStrOneDigit(double x, double y) {
    return formatDouble1(doublePercentRatio(x, y)) + " %";
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public String ymd(Date date) {
    return date == null ? null : ymd(date.getTime());
  }

  static public Class veryQuickJava_finish(String src, List<String> libs) {
    libs = cloneList(libs);
    src = findTranslators2(src, libs);
    String dehlibs = join(" ", libs);
    File bytecode = null;
    bytecode = javaCompile_overInternalBot(src, dehlibs);
    return hotwireCore(concatLists(ll(bytecode), loadLibraries(libs)));
  }

  static public List<File> findAllFiles_noDirs(List dirs) {
    return findAllFiles_noDirs(asObjectArray(dirs));
  }

  static public List<File> findAllFiles_noDirs(Object... dirs) {
    List<File> l = new ArrayList();
    for (Object dir : dirs) {
      ping();
      if (dir instanceof String && ((String) dir).endsWith("/.")) {
        for (File f : listFiles(dropSuffix("/.", ((String) dir)))) {
          ping();
          if (f.isFile())
            l.add(f);
        }
      } else
        findAllFiles_noDirs_impl(toFile(dir), l);
    }
    return l;
  }

  static public void findAllFiles_noDirs_impl(File dir, List<File> l) {
    for (File f : listFiles(dir)) {
      ping();
      if (f.isDirectory())
        findAllFiles_noDirs_impl(f, l);
      else
        l.add(f);
    }
  }

  static public Object[] toObjectArray(Collection c) {
    return toObjectArray((Iterable) c);
  }

  static public Object[] toObjectArray(Iterable c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public double nanoSecondsToSeconds(double nanos) {
    return nanos * 1e-9;
  }

  static public Dimension getScreenSize() {
    return Toolkit.getDefaultToolkit().getScreenSize();
  }

  static public Dimension getScreenSize(int iScreen) {
    return toDimension(screenBounds(iScreen).widthAndHeight());
  }

  static public ImageSurface imageSurface(BufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface(MakesBufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface() {
    return swingNu(ImageSurface.class);
  }

  static public Rect rectFromPoints(int x1, int y1, int x2, int y2) {
    return pointsRect(x1, y1, x2, y2);
  }

  static public Rect rectFromPoints(Pt a, Pt b) {
    return pointsRect(a.x, a.y, b.x, b.y);
  }

  static public Runnable runnableThread(final Runnable r) {
    return new Runnable() {

      public void run() {
        try {
          startThread(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startThread(r)";
      }
    };
  }

  static public String addPrefixIfNotEmpty(String prefix, String s) {
    return empty(s) ? "" : prefix + s;
  }

  static public <A extends JComponent> A toolTip(A c, final Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A toolTip(Object toolTip, A c) {
    return setToolTipText(toolTip, c);
  }

  static public String getLine(String s, int lineNr) {
    return safeGet(toLines(s), lineNr - 1);
  }

  static public Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  static public List<Rect> allScreenBounds() {
    return map(__89 -> screenBounds(__89), screenDevices());
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public void rangeCheck(int i, int n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public void rangeCheck(long i, long n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public String compilerBotDestDirSubName() {
    return "JavaX-Caches/Compilations";
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public Runnable rCallOnSelectedListItem(final JList list, final Object action) {
    return new Runnable() {

      public void run() {
        try {
          pcallF(action, getSelectedItem(list));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(action, getSelectedItem(list))";
      }
    };
  }

  static public int withBottomMargin_defaultWidth = 6;

  static public JPanel withBottomMargin(Swingable c) {
    return withBottomMargin(toComponent(c));
  }

  static public JPanel withBottomMargin(Component c) {
    return withBottomMargin(withBottomMargin_defaultWidth, c);
  }

  static public JPanel withBottomMargin(int w, Swingable c) {
    return withBottomMargin(w, toComponent(c));
  }

  static public JPanel withBottomMargin(int w, Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, w, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public Font typeWriterFont() {
    return typeWriterFont(iround(14 * getSwingFontScale()));
  }

  static public Font typeWriterFont(int size) {
    return new Font(localCourierFontName(), Font.PLAIN, size);
  }

  static public <A extends JComponent> A typeWriterFont(A c) {
    return withTypeWriterFont(c);
  }

  static public List<WeakReference<Class>> hotwire_classes = synchroList();

  static public Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  static public File javaCompile_overInternalBot(String src) {
    return javaCompile_overInternalBot(src, "");
  }

  static synchronized public File javaCompile_overInternalBot(String src, String dehlibs) {
    return CompilerBot.compile(src, dehlibs);
  }

  static public <A> AutoCloseable tempLoadingAnim(String msg) {
    return tempDisposeWindow(loadingAnim(msg));
  }

  static public void removeMouseAdapter(Component c, MouseAdapter a) {
    if (c != null && a != null) {
      swing(() -> {
        c.removeMouseListener(a);
        c.removeMouseMotionListener(a);
      });
    }
  }

  static public <A extends Window> A disposeWindowAfter(int delay, final A w) {
    if (w != null)
      swingLater(delay, new Runnable() {

        public void run() {
          try {
            w.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.dispose();";
        }
      });
    return w;
  }

  static public <A extends Window> A disposeWindowAfter(A w, double seconds) {
    return disposeWindowAfter(toMS_int(seconds), w);
  }

  static public <A extends Window> A disposeWindowAfter(double seconds, A w) {
    return disposeWindowAfter(w, seconds);
  }

  static public int indexOfNonDigit(String s) {
    int n = l(s);
    for (int i = 0; i < n; i++) if (!isDigit(s.charAt(i)))
      return i;
    return -1;
  }

  static public List<String> tok_combineCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "{")) {
        int j = findEndOfCurlyBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public String hms() {
    return hms(now());
  }

  static public String hms(long time) {
    return new SimpleDateFormat("HHmmss").format(time);
  }

  static public <A, B> List<List<B>> mapTwoLevelsDown(F1<A, B> f, Iterable<List<A>> l) {
    List<List<B>> out = new ArrayList();
    if (l != null)
      for (List<A> x : l) out.add(map(f, x));
    return out;
  }

  static public <A, B> List<List<B>> mapTwoLevelsDown(IF1<A, B> f, Iterable<List<A>> l) {
    List<List<B>> out = new ArrayList();
    if (l != null)
      for (List<A> x : l) out.add(map(f, x));
    return out;
  }

  static public void copyLocalLog(Object src, Object dest) {
    Object log = getOpt(src, "local_log");
    if (log != null)
      setOpt(dest, "local_log", local_log);
  }

  static public <A> int compareWithComparator(Comparator<A> comparator, A a, A b) {
    return comparator == null ? cmp(a, b) : comparator.compare(a, b);
  }

  static public int tok_findEndOfMethodDecl(List<String> tok, int i) {
    i = tok_findEndOfMethodHeader(tok, i);
    return findEndOfBlock(tok, i);
  }

  static public JScrollPane jscroll_centered(Component c) {
    return c instanceof JScrollPane ? ((JScrollPane) c) : jscroll(jFullCenter(c));
  }

  static public Complex complex(double re, double im) {
    return new Complex(re, im);
  }

  static public Complex complex(double re) {
    return new Complex(re, 0.0);
  }

  static public Complex complex(double[] reIm) {
    if (empty(reIm))
      return null;
    if (l(reIm) != 2)
      throw fail("Need 2 doubles to make complex number");
    return complex(reIm[0], reIm[1]);
  }

  static public TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  static public Lock hotwireCached_lock = lock();

  static public Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  static public Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  static public Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __0 = hotwireCached_lock;
    lock(__0);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__0);
    }
  }

  public static boolean isWindows() {
    return System.getProperty("os.name").contains("Windows");
  }

  static public int rectArea(Rect r) {
    return r == null ? 0 : r.w * r.h;
  }

  static public String bashQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String bashQuote(File f) {
    return bashQuote(f.getAbsolutePath());
  }

  static public String tok_firstClassName(List<String> tok) {
    int i = jfind(tok, "class <id>");
    return i < 0 ? null : tok.get(i + 2);
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public void intToBytes_inArray_littleEndian(int i, byte[] array, int idx) {
    array[idx] = (byte) i;
    array[idx + 1] = (byte) (i >>> 8);
    array[idx + 2] = (byte) (i >>> 16);
    array[idx + 3] = (byte) (i >>> 24);
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public int roundToInt(double d) {
    return (int) Math.round(d);
  }

  static public <A> A evalInQ(Q q, IF0<A> f) {
    return evalInQ(q, if0ToF0(f));
  }

  static public <A> A evalInQ(Q q, F0<A> f) {
    if (isInQ(q))
      return callF(f);
    final Var<Either<A, Throwable>> var = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            var.set(eitherA(callF(f)));
          } catch (Throwable e) {
            var.set(eitherB(e));
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      var.set(eitherA(callF(f)));\r\n    } catch (Throwable e) {\r\n      ...";
      }
    });
    return returnOrThrow_either(waitForVarToBeNotNull(var));
  }

  static public List<String> regexpExtractAll(String pat, String s) {
    if (s == null)
      return null;
    Matcher m = regexpMatcher(pat, s);
    List<String> out = new ArrayList();
    while (m.find()) out.add(m.group());
    return out;
  }

  static public <A> AutoCloseable vmBus_addListener_basic(String msg, Object listener) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, listener);
    }
  }

  static public <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
    if (l == null)
      return new ArrayList();
    synchronized (mutex) {
      return new ArrayList<A>(l);
    }
  }

  static public Map synchroLinkedHashMap() {
    return synchronizedMap(new LinkedHashMap());
  }

  static public JWindow showInTopRightCorner(Component c) {
    return swing(() -> {
      JWindow w = new JWindow();
      w.add(c);
      w.pack();
      moveToTopRightCorner(w);
      w.setVisible(true);
      return w;
    });
  }

  static public byte[] intListToByteArray_littleEndian(List<Integer> l) {
    if (l == null)
      return null;
    int n1 = l(l), n = n1 * 4;
    byte[] a = new byte[n];
    for (int i = 0; i < n1; i++) intToBytes_inArray_littleEndian(l.get(i), a, i * 4);
    return a;
  }

  static public <A> void listSet(List<A> l, int i, A a, A emptyElement) {
    if (i < 0)
      return;
    while (i >= l(l)) l.add(emptyElement);
    l.set(i, a);
  }

  static public <A> void listSet(List<A> l, int i, A a) {
    listSet(l, i, a, null);
  }

  static public JComponent getTitlePaneComponent(RootPaneContainer window) {
    if (window instanceof JInternalFrame)
      return getInternalFrameTitlePaneComponent((JInternalFrame) window);
    if (!substanceLookAndFeelEnabled() || window == null)
      return null;
    JRootPane rootPane = window.getRootPane();
    if (rootPane != null) {
      Object ui = rootPane.getUI();
      return (JComponent) call(ui, "getTitlePane");
    }
    return null;
  }

  static public void deleteDirectory(File dir) {
    deleteDirectory(dir, false, false);
  }

  static public void deleteDirectory(File dir, boolean verbose, boolean testRun) {
    deleteAllFilesInDirectory(dir, verbose, testRun);
    if (verbose)
      print((testRun ? "Would delete " : "Deleting ") + dir.getAbsolutePath());
    if (!testRun)
      dir.delete();
  }

  static public int poorMansProfiling_defaultInterval() {
    return 25;
  }

  static public void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  static public int screenWidth() {
    return getScreenWidth();
  }

  static public int screenWidth(int iDevice) {
    return screenBounds(iDevice).getWidth();
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public double[] takeFirstOfDoubleArray(double[] b, int n) {
    return subDoubleArray(b, 0, n);
  }

  static public double[] takeFirstOfDoubleArray(int n, double[] b) {
    return takeFirstOfDoubleArray(b, n);
  }

  static public void showConsole() {
    callOpt(get(javax(), "console"), "showConsole");
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean isLowerCase(char c) {
    return Character.isLowerCase(c);
  }

  static public JComponent getInternalFrameTitlePaneComponent(JInternalFrame f) {
    return (JComponent) childWithClassNameEndingWith(f, "InternalFrameTitlePane");
  }

  static public Rect toRect_floor(DoubleRect r) {
    if (r == null)
      return null;
    int x = ifloor(r.x), y = ifloor(r.y);
    return new Rect(x, y, ifloor(r.x2()) - x, ifloor(r.y2()) - y);
  }

  static public F1 toF1(final Object f) {
    return functionToF1(f);
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public Object endMarker() {
    return iteratorFromFunction_endMarker;
  }

  static public void onFirstResize(Component c, Object r) {
    onFirstResize(c, toRunnable(r));
  }

  static public void onFirstResize(Component c, Runnable r) {
    if (c != null && r != null) {
      swing(() -> {
        c.addComponentListener(new ComponentAdapter() {

          public void componentResized(ComponentEvent e) {
            c.removeComponentListener(this);
            pcallF(r);
          }
        });
      });
    }
  }

  static public void duplicateThisProgram() {
    nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
  }

  static public JComponent gazelle_wavySpacer() {
    return gazelle_wavySpacer(gazelle_color1(), gazelle_color2());
  }

  static public JComponent gazelle_wavySpacer(Color color1, Color color2) {
    return jMinWidth(30, swing(() -> new JComponent() {

      public void paintComponent(Graphics g) {
        int w = getWidth(), h = getHeight();
        var points = graphAsPolygon(x -> 1 - sineSigmoid(x), w, h);
        fillRect(((Graphics2D) g), 0, 0, w, h, color2);
        fillPrecisePolygon(((Graphics2D) g), points, color1);
      }
    }));
  }

  static public String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  static public Object iteratorFromFunction_endMarker = new Object();

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = callF(f);
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
    return iteratorFromFunction_withEndMarker_f0(f);
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public void callOnLoadMethods(Class c) {
    for (String name : methodsStartingWith(c, "_onLoad_")) pcallOpt(c, name);
    pcallOpt(c, "_onLoad");
  }

  static public F0<AutoCloseable> dm_rEnter() {
    return dm_rEnter(dm_current());
  }

  static public F0<AutoCloseable> dm_rEnter(DynModule mod) {
    return mod == null ? null : new F0<AutoCloseable>() {

      public AutoCloseable get() {
        try {
          return mod.enter();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return mod.enter();";
      }
    };
  }

  static public Runnable dm_rEnter(Runnable r) {
    return dm_rEnter(dm_current(), r);
  }

  static public Runnable dm_rEnter(DynModule mod, Runnable r) {
    return mod == null || r == null ? r : new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = mod.enter();
          try {
            r.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp mod.enter(); r.run();";
      }
    };
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public boolean isOneOfSingleChars(String s, char... chars) {
    if (l(s) != 1)
      return false;
    char real = s.charAt(0);
    for (char c : unnullForIteration(chars)) if (real == c)
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, String... b) {
    if (b != null)
      for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
        return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b, Matches m) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix, m))
      return true;
    return false;
  }

  static public boolean getServerTranspiled2_allowLocalFallback = true, getServerTranspiled2_localFallbackVerbose = true;

  static public Map<String, String> getServerTranspiled2_tempCache;

  static public String getServerTranspiled2(String id) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getTranspiled(id);
    return getServerTranspiled2_noResourceLoader(id);
  }

  static public String getServerTranspiled2_noResourceLoader(String id) {
    id = fsIOpt(id);
    String transpiled = mapGet(getServerTranspiled2_tempCache, id);
    if (transpiled != null)
      return transpiled;
    transpiled = loadCachedTranspilation(id);
    String md5 = null;
    if (machineIsOffline() || isOfflineMode() || isLocalSnippet(id))
      return transpiled;
    if (transpiled != null)
      md5 = md5(transpiled);
    String transpiledSrc;
    try {
      transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
    } catch (Throwable e) {
      if (!getServerTranspiled2_allowLocalFallback)
        rethrow(e);
      printExceptionShort(e);
      if (getServerTranspiled2_localFallbackVerbose)
        print("Fallback to local code");
      return transpiled;
    }
    if (eq(transpiledSrc, "SAME")) {
      if (!isTrue(loadPage_silent.get()))
        printWithMS("SAME");
      return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiled);
    }
    return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiledSrc);
  }

  static public boolean loadLibraryOrSrcLib_srcLibsEnabled = true;

  static public ThreadLocal<Map<Long, File>> loadLibraryOrSrcLib_tempCache = new ThreadLocal();

  static public ThreadLocal<IF1<String, File>> loadLibraryOrSrcLib_compiler = new ThreadLocal();

  static public File loadLibraryOrSrcLib(String snippetID) {
    return loadLibraryOrSrcLib(snippetID, loadLibraryOrSrcLib_compiler.get());
  }

  static public File loadLibraryOrSrcLib(String snippetID, IF1<String, File> compiler) {
    try {
      vmBus_send("loadLibraryOrSrcLib", snippetID);
      long id = parseSnippetID(snippetID);
      if (loadLibraryOrSrcLib_tempCache.get() != null) {
        File f = loadLibraryOrSrcLib_tempCache.get().get(id);
        if (f != null) {
          print(snippetID + " from tempCache: " + f);
          return f;
        }
      }
      boolean srcLib = loadLibraryOrSrcLib_srcLibsEnabled && isMarkedAsSrcLib(snippetID);
      if (srcLib) {
        print(snippetID + " marked as src lib, compiling");
        File f;
        if (compiler != null)
          f = compiler.get(snippetID);
        else
          f = pairA(hotwire_compile(snippetID));
        print("Src lib: " + f);
        mapPut(loadLibraryOrSrcLib_tempCache.get(), id, f);
        return f;
      }
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) != 0)
        return f;
      try {
        print("Trying " + snippetID + " as binary library");
        return loadDataSnippetToFile(snippetID);
      } catch (Throwable e) {
        if (loadLibraryOrSrcLib_srcLibsEnabled) {
          print("Trying " + snippetID + " as src lib");
          if (nempty(loadSnippet(snippetID))) {
            print("Is src lib.");
            markAsSrcLib(snippetID);
            return pairA(hotwire_compile(snippetID));
          }
        }
        throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int fullAlphaMask() {
    return 0xFF000000;
  }

  static public List<String> findMainClass(List<String> tok) {
    for (List<String> c : reversedList(allClasses(tok))) {
      String name = getClassDeclarationName(c);
      if (eq(name, "main") || name.startsWith("x"))
        return c;
    }
    return findBlock("m {", tok);
  }

  static public String toString(Object o) {
    return strOrNull(o);
  }

  static public Object callCalc(Object o, Object... args) {
    return call(o, "calc", args);
  }

  static public void saveTranspiledCode(String progID, String code) {
    File dir = getCodeProgramDir(progID);
    new File(dir, "Transpilation").delete();
    saveGZTextFile(new File(dir, "Transpilation.gz"), code);
  }

  static public <A> Matrix<Matrix<A>> matrixToMNGrid(Matrix<A> m, int cols, int rows) {
    if (m == null)
      return null;
    cols = clamp(cols, 1, m.getWidth());
    rows = clamp(rows, 1, m.getHeight());
    List<List<Rect>> rects = gridOfRects3(m.getWidth(), m.getHeight(), cols, rows);
    List<List<Matrix<A>>> matrices = mapLevelTwo(r -> new SubMatrix(m, r), rects);
    return listOfListsToMatrix(matrices);
  }

  static public <A> List<A> colToList(Matrix<A> m, int x) {
    if (m == null)
      return null;
    rangeCheck(x, m.getWidth());
    int h = m.getHeight();
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return h;
      }

      public A get(int y) {
        return m.get(x, y);
      }

      public A set(int y, A val) {
        A old = m.get(x, y);
        m.set(x, y, val);
        return old;
      }
    };
  }

  static public class mapI_if1_It<A, B> extends IterableIterator<B> {

    public IF1<A, B> f;

    public Iterator<A> i;

    public mapI_if1_It() {
    }

    public mapI_if1_It(IF1<A, B> f, Iterator<A> i) {
      this.i = i;
      this.f = f;
    }

    public boolean hasNext() {
      return i.hasNext();
    }

    public B next() {
      return f.get(i.next());
    }

    public String toString() {
      return formatFunctionCall("mapI_if1", f, i);
    }
  }

  static public <A, B> IterableIterator<B> mapI_if1(IF1<A, B> f, Iterable<A> i) {
    return new mapI_if1_It(f, i.iterator());
  }

  static public <A, B> IterableIterator<B> mapI_if1(Iterable<A> i, IF1<A, B> f) {
    return mapI_if1(f, i);
  }

  static public boolean showAnimationInTopRightCorner_alwaysOnTop = true;

  static public boolean showAnimationInTopRightCorner_on = true;

  static public JWindow showAnimationInTopRightCorner(String imageID, String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(imageID), text);
  }

  static public JWindow showAnimationInTopRightCorner(final Image image, final String text) {
    if (image == null || isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(image), text);
  }

  static public JWindow showAnimationInTopRightCorner(final ImageIcon imageIcon, final String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JLabel label = new JLabel(imageIcon);
          if (nempty(text)) {
            label.setText(text);
            label.setVerticalTextPosition(SwingConstants.BOTTOM);
            label.setHorizontalTextPosition(SwingConstants.CENTER);
          }
          final JWindow window = showInTopRightCorner(label);
          onClick(label, new Runnable() {

            public void run() {
              try {
                window.dispose();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "window.dispose()";
            }
          });
          if (showAnimationInTopRightCorner_alwaysOnTop)
            window.setAlwaysOnTop(true);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JLabel label = new JLabel(imageIcon);\r\n    if (nempty(text)) {\r\n      label.s...";
      }
    });
  }

  static public JWindow showAnimationInTopRightCorner(final String imageID) {
    return showAnimationInTopRightCorner(imageID, "");
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, double seconds) {
    return showAnimationInTopRightCorner(imageID, "", seconds);
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, String text, double seconds) {
    if (isHeadless())
      return null;
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(imageID, text));
  }

  static public JWindow showAnimationInTopRightCorner(BufferedImage img, String text, double seconds) {
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(img, text));
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public Complex div(Complex a, double b) {
    return new Complex(a.re / b, a.im / b);
  }

  static public double div(double a, double b) {
    return a / b;
  }

  static public double div(double a, int b) {
    return a / b;
  }

  static public long div(long a, long b) {
    return a / b;
  }

  static public int div(int a, int b) {
    return a / b;
  }

  static public void addComponentsFirst(Container c, Component... l) {
    containerAddFirst(c, l);
  }

  static public String squareBracket(String s) {
    return "[" + s + "]";
  }

  static public File makeFileNameUnique_beforeExtension(File f) {
    File orig = f;
    int n = 0;
    while (f.exists()) f = appendToFileBaseName(orig, "." + ++n);
    return f;
  }

  static public void stepAllWithTimeout(double timeout, Steppable s) {
    if (s == null)
      return;
    long endTime = sysNow() + toMS(timeout);
    do {
      ping();
    } while (s.step() && sysNow() < endTime);
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public boolean tok_isJavaxMetaCommandLeftOf(List<String> tok, int i) {
    int j = i - 2 * 4 - 1;
    if (j >= 0 && jfind(subList(tok, j, i), "set flag <id> .") == 1)
      return true;
    return false;
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public void fixACCInClassLoader(Object o) {
  }

  static public String formatLocalDateWithSeconds(long time) {
    return localDateWithSeconds(time);
  }

  static public String formatLocalDateWithSeconds() {
    return localDateWithSeconds();
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public <A extends JComponent> A applyDefaultMargin(final A c) {
    if (c != null) {
      swing(() -> {
        c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth));
      });
    }
    return c;
  }

  static public void removeFromParent(final Component c) {
    if (c != null) {
      swing(() -> {
        Container cc = c.getParent();
        if (cc != null) {
          cc.remove(c);
          revalidate(cc);
        }
      });
    }
  }

  static public int month() {
    return localMonth();
  }

  static public int month(Timestamp now) {
    return localMonth(toLong(now));
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public boolean containsSpaces(String s) {
    return indexOf(s, ' ') >= 0;
  }

  static public boolean renameFile(File a, File b) {
    mkdirsForFile(b);
    return a.renameTo(b);
  }

  static public boolean renameFile(File a, String newName) {
    return renameFile(a, fileInSameDir(a, newName));
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public String flexLines(Object... l) {
    return lines(flattenIterablesAndArrays(ll(l)));
  }

  static public <A, B> boolean eitherIsA(Either<A, B> e) {
    return e != null && e.isA();
  }

  static public Object[] unrollParams(Object[] params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToParams((Map) params[0]);
    return params;
  }

  static public <A, B> boolean eitherIsB(Either<A, B> e) {
    return e != null && e.isB();
  }

  static public List mapQuickEval_javaExpr(Iterable<ICachedJavaXExpr> l) {
    return map(e -> e.quickEval(), l);
  }

  static public Object dm_callOS(String functionName, Object... args) {
    return call(dm_os(), functionName, args);
  }

  static public String tok_addReturn(List<String> tok) {
    if (tok_shouldAddReturn(tok)) {
      tokPrepend(tok, 1, "return ");
      tokAppend(tok, l(tok) - 2, ";");
    }
    return join(tok);
  }

  static public String tok_addReturn(String s) {
    return tok_addReturn(javaTok(s));
  }

  static public String loadTextFileFromZip(File inZip, String fileName) {
    return loadTextFileFromZipFile(inZip, fileName);
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public Object dm_current_generic_mandatory() {
    return dm_current_mandatory_generic();
  }

  static public boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
  }

  static public boolean regionMatches(String a, int offsetA, String b) {
    return regionMatches(a, offsetA, b, 0, l(b));
  }

  static public String naiveQuote(String s) {
    return simpleQuote(s);
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public int snippetType_javaxModule() {
    return 54;
  }

  static public void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  static public void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  static public <A, B> WithSideValue<A, B> withSideValue(A sideValue, B value) {
    return new WithSideValue(sideValue, value);
  }

  static public RandomAccessFile newRandomAccessFile(File path, String mode) {
    try {
      boolean forWrite = mode.indexOf('w') >= 0;
      if (forWrite)
        mkdirsForFile(path);
      RandomAccessFile f = new RandomAccessFile(path, mode);
      callJavaX("registerIO", f, path, forWrite);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Boolean grabbableIntPixels_succeeded;

  static public boolean grabbableIntPixels_enable = true;

  static public GrabbableIntPixels grabbableIntPixels(BufferedImage img) {
    if (img == null || !grabbableIntPixels_enable)
      return null;
    try {
      var result = grabbableIntPixels_impl(img);
      grabbableIntPixels_succeeded = result != null;
      return result;
    } catch (Throwable _e) {
      grabbableIntPixels_succeeded = false;
      throw rethrow(_e);
    }
  }

  static public GrabbableIntPixels grabbableIntPixels_impl(BufferedImage img) {
    Raster raster = img.getRaster();
    SampleModel _sampleModel = raster.getSampleModel();
    if (!(_sampleModel instanceof SinglePixelPackedSampleModel))
      return null;
    SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel) _sampleModel;
    DataBufferInt dataBuffer = (DataBufferInt) (raster.getDataBuffer());
    assertEquals(1, dataBuffer.getNumBanks());
    assertEquals(DataBuffer.TYPE_INT, dataBuffer.getDataType());
    int w = img.getWidth(), h = img.getHeight();
    int scanlineStride = sampleModel.getScanlineStride();
    int[] pixels = dataBuffer.getData();
    int offset = dataBuffer.getOffset();
    int translateX = raster.getSampleModelTranslateX();
    int translateY = raster.getSampleModelTranslateY();
    offset += -translateX - translateY * scanlineStride;
    return new GrabbableIntPixels(pixels, w, h, offset, scanlineStride);
  }

  static public double doublePercentRatio(double x, double y) {
    return doubleRatio(x, y) * 100;
  }

  static public double doublePercentRatio(Seconds x, Seconds y) {
    return doublePercentRatio(x.get(), y.get());
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public List<File> loadLibraries(List<String> snippetIDs) {
    return map(__90 -> loadLibrary(__90), snippetIDs);
  }

  static public void logQuotedWithDate(String s) {
    logQuotedWithTime(s);
  }

  static public void logQuotedWithDate(String logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public void logQuotedWithDate(File logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public File printFileInfo(File f) {
    return printFileInfo("", f);
  }

  static public File printFileInfo(String s, File f) {
    print(s, renderFileInfo(f));
    return f;
  }

  static public JComponent dm_getVisualization(Object module) {
    return (JComponent) callOpt(dm_getStem(module), "vis");
  }

  static public JComponent dm_getVisualization() {
    return dm_getVisualization(dm_current_mandatory_generic());
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public int snippetType_javaxSource() {
    return 34;
  }

  static public Object dm_callOSOpt(String functionName, Object... args) {
    return callOpt(dm_os(), functionName, args);
  }

  static public boolean interruptThread_verbose = false;

  static public void interruptThread(Thread t) {
    if (t == null)
      return;
    if (interruptThread_verbose)
      print("Interrupting thread " + t);
    vm_threadInterruptionReasonsMap().put(t, getStackTrace());
    t.interrupt();
    URLConnection c = (URLConnection) (vm_generalSubMap("URLConnection per thread").get(t));
    if (c != null) {
      try {
        print("Closing URLConnection of interrupted thread.");
        call(c, "disconnect");
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
  }

  static public <A extends JComponent> A bindLiveValueListenerToComponent(A component, IHasChangeListeners lv, Runnable listener) {
    return bindHasChangeListenersToComponent(component, lv, listener);
  }

  static public void setOptAll(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) setOpt(o, field, fields.get(field));
  }

  static public void setOptAll(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      setOpt(o, field, value);
    }
  }

  static public int screenHeight() {
    return getScreenHeight();
  }

  static public int getPreferredWidth(Component c) {
    return preferredWidth(c);
  }

  static public boolean isOfflineMode() {
    return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
  }

  static public Rect screenBounds(GraphicsDevice screen) {
    return screen == null ? null : toRect(screen.getDefaultConfiguration().getBounds());
  }

  static public Rect screenBounds(int iScreen) {
    return screenBounds(get(screenDevices(), iScreen));
  }

  static public Map<JFrame, Boolean> myFrames_list = weakHashMap();

  static public List<JFrame> myFrames() {
    return swing(new F0<List<JFrame>>() {

      public List<JFrame> get() {
        try {
          return keysList(myFrames_list);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return keysList(myFrames_list);";
      }
    });
  }

  static public String callStringifier(Object stringifier, Object o) {
    return stringifier != null ? str(callF(stringifier, o)) : str(o);
  }

  static public void metaSet(IMeta o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public void metaSet(Object o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public int calculateLengthOfFunctionCall(String fname, int... argLengths) {
    return l(fname) + 2 + intSum(argLengths);
  }

  static public String loadSnippetSilently(Snippet s) {
    return loadSnippetQuietly(s);
  }

  static public String loadSnippetSilently(String snippetID) {
    return loadSnippetQuietly(snippetID);
  }

  static public File touchFile(File file) {
    try {
      closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] paramsWithout(Object[] a1, Object... keys) {
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapMinus((Map) a1[0], keys) };
    Set set = lithashset(keys);
    List l = new ArrayList();
    int n = l(a1);
    for (int i = 0; i < n; i += 2) if (i == n - 1)
      l.add(a1[i]);
    else if (!set.contains(a1[i])) {
      l.add(a1[i]);
      l.add(a1[i + 1]);
    }
    return toObjectArray(l);
  }

  static public Rectangle toRectangle(Rect r) {
    return r == null ? null : r.getRectangle();
  }

  static public List<String> allMethodNames(Object o) {
    Class c = _getClass(o);
    TreeSet<String> names = new TreeSet();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) names.add(m.getName());
      c = c.getSuperclass();
    }
    return asList(names);
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  static public void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  static public void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  static public JFrame consoleFrame() {
    return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
  }

  static public JECompressionRegime jeCompressionRegime() {
    return new JECompressionRegime();
  }

  static public int widthForHeight(int w, int h, int newHeight) {
    return iround(newHeight * doubleRatio(w, h));
  }

  static public int widthForHeight(double w, double h, int newHeight) {
    return iround(newHeight * doubleRatio(w, h));
  }

  static public int widthForHeight(WidthAndHeight img, int newHeight) {
    return widthForHeight(img.getWidth(), img.getHeight(), newHeight);
  }

  static public Class hotwireCore(List<File> files) {
    try {
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      Class<?> theClass = classLoader.loadClass("main");
      setOpt(theClass, "__javax", getJavaX());
      if (getOpt(theClass, "programID") == null)
        setOpt(theClass, "programID", "#3999999");
      if (!_inCore())
        hotwire_copyOver(theClass);
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A returnOrThrow_either(Either<A, Throwable> e) {
    if (isEitherB(e))
      throw rethrow(e.b());
    return eitherAOpt(e);
  }

  static public int tok_findEndOfBlock(List<String> tok, int i) {
    if (tok instanceof IContentsIndexedList2)
      return tok_findEndOfBlock_IContentsIndexedList2_v2(((IContentsIndexedList2) tok), i);
    int j = i + 2, level = 1, n = l(tok);
    while (j < n) {
      String t = tok.get(j);
      if ("{".equals(t))
        ++level;
      else if ("}".equals(t))
        --level;
      if (level == 0)
        return j + 1;
      j += 2;
    }
    return n;
  }

  static public <A extends JLabel> A centerLabel(A l) {
    if (l != null)
      l.setHorizontalAlignment(SwingConstants.CENTER);
    return l;
  }

  static public String nohup_sanitize(String s) {
    return empty(s) ? s : takeFirst(50, s.replaceAll("[^.a-zA-Z0-9\\-_]", ""));
  }

  static public File javaxCodeDir_dir;

  static public File javaxCodeDir() {
    return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
  }

  static public File javaxCodeDir(String sub) {
    return newFile(javaxCodeDir(), sub);
  }

  static public BufferedImage imageFromHex(int w, int h, String pixelsAsHex) {
    return intArrayToBufferedImage(hexToInts_dropSpaces(pixelsAsHex), w, h);
  }

  static public JLabel jLiveValueLabel(IF0WithChangeListeners var) {
    return jVarLabel(var);
  }

  static public AutoCloseable tempSet(Object o, final String field, Object value) {
    return tempSetField(o, field, value);
  }

  static public AutoCloseable combineAutoCloseables(final AutoCloseable a, final AutoCloseable b) {
    return a == null ? b : b == null ? a : new AutoCloseable() {

      public String toString() {
        return "pClose(a); pClose(b);";
      }

      public void close() throws Exception {
        pClose(a);
        pClose(b);
      }
    };
  }

  static public AutoCloseable combineAutoCloseables(AutoCloseable a, AutoCloseable b, AutoCloseable c, AutoCloseable... more) {
    return combineAutoCloseables(concatLists(ll(a, b, c), asList(more)));
  }

  static public AutoCloseable combineAutoCloseables(Iterable<AutoCloseable> l) {
    return foldl(new F2<AutoCloseable, AutoCloseable, AutoCloseable>() {

      public AutoCloseable get(AutoCloseable a, AutoCloseable b) {
        try {
          return combineAutoCloseables(a, b);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "combineAutoCloseables(a,b)";
      }
    }, null, l);
  }

  static public String systemHashCodeHex(Object o) {
    return intToHex(identityHashCode(o));
  }

  static public String shortClassName_dropNumberPrefix(Object o) {
    return dropNumberPrefix(shortClassName(o));
  }

  static public int findEndOfCurlyBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eq(cnc.get(j), "{"))
        ++level;
      else if (eq(cnc.get(j), "}"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public int identityHashCode(Object o) {
    return System.identityHashCode(o);
  }

  static public void minimizeWindow(JFrame f) {
    if (f != null) {
      swing(() -> {
        f.setState(JFrame.ICONIFIED);
      });
    }
  }

  static public List<String> allClassNamesOnPath(Collection<File> files) {
    List<String> classes = new ArrayList();
    for (File dir : files) classes.addAll(classNamesInJarOrDir(dir));
    return classes;
  }

  static public double sqrt(double x) {
    return Math.sqrt(x);
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public List<File> listFilesWithSuffix(String suffix, File dir) {
    return listFilesWithSuffix(dir, suffix);
  }

  static public void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
  }

  static public int globalIDLength() {
    return 16;
  }

  static public boolean isSubstanceLAF() {
    return substanceLookAndFeelEnabled();
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static public File appendToFileBaseName(File f, String s) {
    return appendToFileNameBeforeExtension(f, s);
  }

  static public <A> Set<A> synchroLinkedHashSet() {
    return synchronizedSet(new CompactLinkedHashSet());
  }

  static public JButton jbutton(String text, Runnable action) {
    return newButton(text, action);
  }

  static public JButton jbutton(String text, Object action) {
    return newButton(text, action);
  }

  static public JButton jbutton(String text) {
    return newButton(text, null);
  }

  static public JButton jbutton(Action action) {
    return swingNu(JButton.class, action);
  }

  static public JTextArea jtextarea() {
    return jTextArea();
  }

  static public JTextArea jtextarea(String text) {
    return jTextArea(text);
  }

  static public <A> Matrix<A> listToMatrix_cols(int w, List<A> data) {
    return listToMatrix(w, data);
  }

  static public <A> Collection<A> addDyn(Collection<A> l, A a) {
    if (l == null)
      l = new ArrayList();
    l.add(a);
    return l;
  }

  static public <A> List<A> addDyn(List<A> l, A a) {
    if (l == null)
      l = new ArrayList();
    l.add(a);
    return l;
  }

  static public <A extends JComponent> A setEnabled(A c, boolean enable) {
    if (c != null) {
      swing(() -> {
        c.setEnabled(enable);
      });
    }
    return c;
  }

  static public <A extends JComponent> A setEnabled(boolean enable, A c) {
    return setEnabled(c, enable);
  }

  static public void setEnabled(boolean enable, JComponent... l) {
    for (var c : unnullForIteration(l)) setEnabled(c, enable);
  }

  static public FunctionCall functionCall(Object fname, Object... args) {
    return new FunctionCall(fname, args);
  }

  static public boolean isInstanceOf(Object o, Class type) {
    return type.isInstance(o);
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public boolean isMarkedAsSrcLib(String snippetID) {
    if (snippetID == null)
      return false;
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return isJavaxCompilableSnippetType(rl.getSnippetType(snippetID));
    return fileExists(javaxCodeDir("srclibs/" + psI(snippetID)));
  }

  static public byte[] intListToByteArray(List<Integer> l) {
    return intListToByteArray_littleEndian(l);
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public JPanel northAndCenter(Component n, Component c) {
    return centerAndNorth(c, n);
  }

  static public <A> Matrix<Matrix<A>> matrixToMNGrid_rows(Matrix<A> m, int rows) {
    if (m == null)
      return null;
    int cols = widthForHeight(m.getWidth(), m.getHeight(), rows);
    return matrixToMNGrid(m, cols, rows);
  }

  static public JPanel jline(final Component... components) {
    return swing(() -> {
      return new LeftAlignedLine(components);
    });
  }

  static public <A extends Component> JPanel jline(List<A> components) {
    return jline(asArray(Component.class, components));
  }

  static public ItemListener itemListener(final Object r) {
    return new ItemListener() {

      public void itemStateChanged(ItemEvent e) {
        pcallF(r);
      }
    };
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static public long toMS(Duration d) {
    return d == null ? 0 : d.toMillis();
  }

  static public void dm_pointSubmoduleToMe(Object subModule) {
    dm_pointSubmoduleToMe(subModule, dm_current_mandatory_generic());
  }

  static public void dm_pointSubmoduleToMe(Object subModule, Object me) {
    setOpt(subModule, "dm_current_mandatory_generic_value", me);
  }

  static public void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  static public void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public int bwIntegralImage_sumRect(BWIntegralImage img, int x1, int y1, int x2, int y2) {
    int bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    int bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    int topLeft = img.getIIValue(x1 - 1, y1 - 1);
    int topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public int bwIntegralImage_sumRect(IBWIntegralImage img, int x1, int y1, int x2, int y2) {
    int bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    int bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    int topLeft = img.getIIValue(x1 - 1, y1 - 1);
    int topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public double bwIntegralImage_sumRect(IBWIntegralImage img, double x1, double y1, double x2, double y2) {
    double bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    double bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    double topLeft = img.getIIValue(x1 - 1, y1 - 1);
    double topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public int intFromBytes_littleEndian_partial(byte[] a, int i) {
    return (ubyteToInt(i + 3 >= a.length ? 0 : a[i + 3]) << 24 | (ubyteToInt(i + 2 >= a.length ? 0 : a[i + 2]) << 16 | (ubyteToInt(i + 1 >= a.length ? 0 : a[i + 1]) << 8 | ubyteToInt(a[i]))));
  }

  static public boolean containsSpace(String s) {
    return containsSpaces(s);
  }

  static public Class<?> hotwireSharingLibraries(String progID) {
    try {
      Pair<File, String> p = CompilerBot.compileSnippet2(progID);
      File jar = p.a;
      assertTrue(f2s(jar), jar.isFile());
      List<File> files = ll(jar);
      String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
      List<File> myLibraries = myLibraryFiles();
      Matcher matcher = Pattern.compile("\\d+").matcher(dehlibs);
      while (matcher.find()) {
        String libID = matcher.group();
        File lib = loadLibrary(libID);
        if (myLibraries.contains(lib)) {
        } else {
          files.add(lib);
        }
      }
      JavaXClassLoaderWithParent classLoader = new JavaXClassLoaderWithParent(progID, files, myClassLoader());
      return hotwire_finish(classLoader, progID, p.b);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htmlencode_forParams_v2(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String forward(String bot, String msg, Object... args) {
    return format("please forward to bot *: *", bot, format(msg, args));
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      var __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public <A> A assertEquals(Object x, A y) {
    return assertEquals("", x, y);
  }

  static public <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  static public void assertEquals(Scorer scorer, Object x, Object y) {
    assertEquals(scorer, "", x, y);
  }

  static public void assertEquals(Scorer scorer, String msg, Object x, Object y) {
    if (scorer == null) {
      assertEquals(msg, x, y);
      return;
    }
    scorer.add(eq(x, y), nullIfEmpty(msg));
  }

  static public String joinMap(Object f, Iterable l) {
    return join(map(f, l));
  }

  static public String joinMap(Iterable l, Object f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(Iterable<A> l, IF1<A, String> f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(A[] l, IF1<A, String> f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(IF1<A, String> f, Iterable<A> l) {
    return join(map(f, l));
  }

  static public <A> String joinMap(IF1<A, String> f, A[] l) {
    return join(map(f, l));
  }

  static public <A, B> String joinMap(String separator, Map<A, B> map, IF2<A, B, String> f) {
    return join(separator, map(map, f));
  }

  static public byte[] isJAR_magic = bytesFromHex("504B0304");

  static public boolean isJAR(byte[] data) {
    return byteArrayStartsWith(data, isJAR_magic);
  }

  static public boolean isJAR(File f) {
    return isJAR(loadBeginningOfBinaryFile(f, l(isJAR_magic)));
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public String programTitle() {
    return getProgramName();
  }

  static public <A> WithProbability<A> withProbability(double probability, A a) {
    return new WithProbability(probability, a);
  }

  static public <A> List<WithProbability<A>> withProbability(IF1<A, Double> makeProbability, Iterable<A> l) {
    return map(a -> withProbability(makeProbability.get(a), a), l);
  }

  static public Path toPath(File f) {
    return f == null ? null : f.toPath();
  }

  static public JTextArea jTextAreaWithUndo() {
    return jTextAreaWithUndo("");
  }

  static public JTextArea jTextAreaWithUndo(final String text) {
    return jenableUndoRedo(swingNu(JTextArea.class, text));
  }

  static public Dimension getPreferredSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getPreferredSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getPreferredSize();";
      }
    });
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public String unicode_downPointingTriangle() {
    return charToString(0x25BC);
  }

  static public Window dm_windowIfSingleModule(Object module) {
    Window w = dm_window(module);
    return w == null || w != getWindow(dm_desktopPane()) ? w : null;
  }

  static public int backtick_exitValue;

  static public boolean backtick_verbose, backtick_keepScript;

  static public ThreadLocal<File> backtick_scriptFile = new ThreadLocal();

  static public ThreadLocal<Boolean> backtick_uninterruptable = new ThreadLocal();

  static public boolean backtick_win_cmd = false;

  static public String backtick(String cmd) {
    try {
      ping();
      File outFile = File.createTempFile("_backtick", "");
      backtickToFile(cmd, outFile);
      String result = loadTextFile(outFile.getPath(), "");
      if (backtick_verbose) {
        print("[[\n" + result + "]]");
      }
      outFile.delete();
      return result;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public java.lang.Process backtickToFile(String cmd, File outFile) {
    try {
      try {
        java.lang.Process process = backtickToFile_noWait(cmd, outFile);
        process.waitFor();
        backtick_exitValue = process.exitValue();
        if (backtick_verbose)
          System.out.println("Process return code: " + backtick_exitValue);
        return process;
      } finally {
        if (!backtick_keepScript)
          deleteFile(backtick_scriptFile.get());
        backtick_scriptFile.set(null);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public java.lang.Process backtickToFile_noWait(String cmd, File outFile) {
    try {
      ping();
      File scriptFile;
      String ext = isWindows() ? ".bat" : "";
      if (backtick_keepScript)
        scriptFile = makeFileNameUnique_withExtension(javaxCachesDir("Cmd Scripts/backtick"), ".bat");
      else
        scriptFile = File.createTempFile("_backtick", ext);
      backtick_scriptFile.set(scriptFile);
      if (backtick_verbose)
        print("backtick: scriptFile " + f2s(scriptFile));
      boolean makeInterruptable = !isTrue(backtick_uninterruptable.get()) && !isWindows();
      cmd = trim(cmd);
      if (makeInterruptable && numLines(cmd) > 1)
        throw fail("No multi-line commands allowed when making interruptable");
      String command = cmd + " >" + bashQuote(outFile.getPath()) + " 2>&1";
      if (makeInterruptable)
        command = fixNewLines("\r\ninterruptable() {\r\n\r\n    # handle options\r\n    local setsid=\"\"\r\n    local debug=false\r\n    while true; do\r\n        case \"${1:-}\" in\r\n            --killall)      setsid=setsid; shift ;;\r\n            --debug)        debug=true; shift ;;\r\n            --*)            echo \"Invalid option: $1\" 1>&2; exit 1;;\r\n            *)              break;; # no more options\r\n        esac\r\n    done\r\n\r\n    # start the specified command\r\n    $setsid \"$@\" &\r\n    local child_pid=$!\r\n\r\n    # arrange to propagate a signal to the child process\r\n    trap '\r\n        exec 1>&2\r\n        set +e\r\n        trap \"\" SIGPIPE # ensure a possible sigpipe from the echo does not prevent the kill\r\n        echo \"${BASH_SOURCE[0]} caught SIGTERM while executing $* (pid $child_pid), sending SIGTERM to it\"\r\n        # (race) child may have exited in which case kill will report an error\r\n        # if setsid is used then prefix the pid with a \"-\" to indicate that the signal\r\n        # should be sent to the entire process group\r\n        kill ${setsid:+-}$child_pid\r\n        exit 143\r\n    ' SIGTERM\r\n    # ensure that the trap doesn't persist after we return\r\n    trap 'trap - SIGTERM' RETURN\r\n\r\n    $debug && echo \"interruptable wait (child $child_pid, self $$) for: $*\"\r\n\r\n    # An error status from the child process will trigger an exception (via set -e)\r\n    # here unless the caller is checking the return status\r\n    wait $child_pid # last command, so status of waited for command is returned\r\n}\r\n\r\ninterruptable ") + command;
      if (backtick_verbose) {
        print("backtick: command " + command);
        print("backtick: saving to " + scriptFile.getPath());
      }
      saveTextFile(scriptFile.getPath(), command);
      if (backtick_verbose)
        print("backtick: command length=" + l(command) + ", file length=" + scriptFile.length());
      String[] command2;
      if (isWindows())
        if (backtick_win_cmd)
          command2 = new String[] { "cmd", "/c", scriptFile.getPath() };
        else
          command2 = new String[] { scriptFile.getPath() };
      else
        command2 = new String[] { "/bin/bash", scriptFile.getPath() };
      if (backtick_verbose)
        print("backtick: command2 " + structure(command2));
      return Runtime.getRuntime().exec(command2);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String textOfStandardFunction_uncached(String sfName) {
    return loadSnippet(stdFunctions_uncached().get(sfName));
  }

  static public JCheckBox jLiveValueCheckBox(String text, SimpleLiveValue<Boolean> lv) {
    JCheckBox cb = jCheckBox(text);
    bindCheckBoxToLiveValue(cb, lv);
    return cb;
  }

  static public JCheckBox jLiveValueCheckBox(String text, IVarWithNotify<Boolean> lv) {
    JCheckBox cb = jCheckBox(text);
    bindCheckBoxToLiveValue(cb, lv);
    return cb;
  }

  static public String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5AsByteArray(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5AsByteArray(data));
  }

  static public String md5(File file) {
    return md5OfFile(file);
  }

  static public Border getBorder(final JComponent c) {
    return c == null ? null : swing(new F0<Border>() {

      public Border get() {
        try {
          return c.getBorder();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getBorder();";
      }
    });
  }

  static public <A extends JComponent> A onClick(A c, IVF1<MouseEvent> runnable) {
    return onClick(c, (Object) runnable);
  }

  static public <A extends JComponent> A onClick(A c, Object runnable) {
    if (c != null) {
      swing(() -> {
        c.addMouseListener(new MouseAdapter() {

          public void mouseClicked(MouseEvent e) {
            callF(runnable, e);
          }
        });
      });
    }
    return c;
  }

  static public void onClick(JButton btn, Object runnable) {
    onEnter(btn, runnable);
  }

  static public List<GraphicsDevice> screenDevices() {
    return asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices());
  }

  static public boolean isAllUpperCase(String s) {
    return hasLettersAllUpperCase(s);
  }

  static public String getLookAndFeel() {
    return getClassName(UIManager.getLookAndFeel());
  }

  static public <A> List<A> rowToList(Matrix<A> m, int y) {
    if (m == null)
      return null;
    rangeCheck(y, m.getHeight());
    int w = m.getWidth();
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return w;
      }

      public A get(int x) {
        return m.get(x, y);
      }

      public A set(int x, A val) {
        A old = m.get(x, y);
        m.set(x, y, val);
        return old;
      }
    };
  }

  static public boolean allElementsAreOfType(Collection c, Class type) {
    for (Object o : c) if (!isInstanceX(type, o))
      return false;
    return true;
  }

  static public boolean containsUnsafePlatformCmdLineChar(String s) {
    return containsRegexp(s, "[\\|&;<>()\\$`\\\\\"' \t\r\n\\*\\?\\[#~=%]");
  }

  static public String renderFileInfo(File f) {
    return f == null ? "-" : f2s(f) + " " + (f.isFile() ? "(file, " + n2(fileSize(f)) + " bytes)" : f.isDirectory() ? "(dir)" : "(not found)");
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
    final JCheckBoxMenuItem mi = swing(() -> new JCheckBoxMenuItem(text, checked));
    addActionListener(mi, new Runnable() {

      public void run() {
        try {
          callF(r, isChecked(mi));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, isChecked(mi))";
      }
    });
    return mi;
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, IVF1<Boolean> r) {
    return jCheckBoxMenuItem(text, checked, (Object) r);
  }

  static public <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
    mapPut(map, key, value);
    return value;
  }

  static public Lock appendToFile_lock = lock();

  static public boolean appendToFile_keepOpen = false;

  static public HashMap<String, Writer> appendToFile_writers = new HashMap();

  static public void appendToFile(String path, String s) {
    try {
      Lock __0 = appendToFile_lock;
      lock(__0);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  static public void cleanMeUp_appendToFile() {
    AutoCloseable __3 = tempCleaningUp();
    try {
      Lock __1 = appendToFile_lock;
      lock(__1);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__1);
      }
    } finally {
      _close(__3);
    }
  }

  static public String find(String pattern, String text) {
    Matcher matcher = Pattern.compile(pattern).matcher(text);
    if (matcher.find())
      return matcher.group(1);
    return null;
  }

  static public <A> A find(Collection<A> c, Object... data) {
    for (A x : c) if (checkFields(x, data))
      return x;
    return null;
  }

  static public <A extends JTextComponent> A jenableUndoRedo(A textcomp) {
    {
      swing(() -> {
        UndoManager undo = new UndoManager();
        vm_generalWeakSet("Undo Managers").add(undo);
        setMeta(textcomp, "UndoManager", undo);
        textcomp.getDocument().addUndoableEditListener(new UndoableEditListener() {

          public void undoableEditHappened(UndoableEditEvent evt) {
            undo.addEdit(evt.getEdit());
          }
        });
        textcomp.getActionMap().put("Undo", abstractAction("Undo", new Runnable() {

          public void run() {
            try {
              if (undo.canUndo())
                undo.undo();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (undo.canUndo()) undo.undo()";
          }
        }));
        textcomp.getActionMap().put("Redo", abstractAction("Redo", new Runnable() {

          public void run() {
            try {
              if (undo.canRedo())
                undo.redo();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (undo.canRedo()) undo.redo()";
          }
        }));
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
      });
    }
    return textcomp;
  }

  static public void setChecked(JCheckBox checkBox, boolean b) {
    if (checkBox != null) {
      swing(() -> {
        if (isChecked(checkBox) != b)
          checkBox.setSelected(b);
      });
    }
  }

  static public void setChecked(JCheckBoxMenuItem mi, boolean b) {
    if (mi != null) {
      swing(() -> {
        mi.setSelected(b);
      });
    }
  }

  static public String joinPairWithColon(Pair p) {
    return p == null ? "" : str(p.a) + ": " + str(p.b);
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public <A extends JComponent> A setFont(final Font font, final A a) {
    if (a != null) {
      swing(() -> {
        a.setFont(font);
      });
    }
    return a;
  }

  static public <A extends JComponent> A setFont(A a, Font font) {
    return setFont(font, a);
  }

  static public <A extends JComponent> A setFont(final String fontID, float fontSize, final A a) {
    return setFont(loadFont_cached(fontID, fontSize), a);
  }

  static public <A> List<A> syncList() {
    return synchroList();
  }

  static public <A> List<A> syncList(List<A> l) {
    return synchroList(l);
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterator<A> it) {
    if (it == null)
      return null;
    List l = new ArrayList();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    return i == null ? null : takeFirst(n, i.iterator());
  }

  static public <A> List<A> takeFirst(int n, IterableIterator<A> i) {
    return takeFirst(n, (Iterator<A>) i);
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public short[] takeFirst(int n, short[] a) {
    return takeFirstOfShortArray(n, a);
  }

  static public byte[] takeFirst(int n, byte[] a) {
    return takeFirstOfByteArray(n, a);
  }

  static public byte[] takeFirst(byte[] a, int n) {
    return takeFirstOfByteArray(n, a);
  }

  static public double[] takeFirst(int n, double[] a) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public double[] takeFirst(double[] a, int n) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public <A, B> Map<A, B> takeFirst(int n, Map<A, B> map) {
    return takeFirstFromMap(n, map);
  }

  static public boolean isEditableComboBox(final JComboBox cb) {
    return cb != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return cb.isEditable();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return cb.isEditable();";
      }
    });
  }

  static public JPanel jrightalignedline(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jrightalignedline(List<Component> components) {
    return jrightAlignedLine(components);
  }

  static public <A, B> String formatColonProperties(Map<A, B> map) {
    return mapToLines(__91 -> joinPairWithColon(__91), mapToPairs(map));
  }

  static public <A, B> String formatColonProperties(List<Pair<A, B>> l) {
    return mapToLines(__92 -> joinPairWithColon(__92), l);
  }

  static public <A, B> String formatColonProperties(Object... params) {
    return formatColonProperties(paramsToPairs(params));
  }

  static volatile public int numberOfCores_value;

  static public int numberOfCores() {
    if (numberOfCores_value == 0)
      numberOfCores_value = Runtime.getRuntime().availableProcessors();
    return numberOfCores_value;
  }

  static public String cleanJavaCompilerOutput(String s) {
    return dropPrefixTrim("Annotation processing got disabled, since it requires a 1.6 compliant JVM", s);
  }

  static public <A extends Window> A showWindow(A w) {
    if (w != null) {
      swing(() -> {
        w.setVisible(true);
      });
    }
    return w;
  }

  static public BigInteger plus(BigInteger a, BigInteger b) {
    return a.add(b);
  }

  static public BigInteger plus(BigInteger a, long b) {
    return a.add(bigint(b));
  }

  static public long plus(long a, long b) {
    return a + b;
  }

  static public int plus(int a, int b) {
    return a + b;
  }

  static public float plus(float a, float b) {
    return a + b;
  }

  static public double plus(double a, double b) {
    return a + b;
  }

  static public <A> A optPar_ignoreOddLength(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    for (int i = 0; i + 1 < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optPar_ignoreOddLength(Object[] opt, String name) {
    return optPar_ignoreOddLength(opt, name, null);
  }

  static public Object optPar_ignoreOddLength(String name, Object[] params) {
    return optPar_ignoreOddLength(params, name);
  }

  static public int tok_findEndOfMethodHeader(List<String> tok, int i) {
    i |= 1;
    int level = 0;
    while (i < l(tok)) {
      String t = tok.get(i);
      if (eq(t, "("))
        ++level;
      else if (eq(t, ")"))
        --level;
      else if (level == 0 && eqOneOf(t, "{", ";"))
        return i;
      i += 2;
    }
    return i;
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, IF2<A, B, Boolean> f) {
    if (map == null)
      return null;
    Map<A, B> m2 = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A a = __0.getKey();
      B b = __0.getValue();
      if (f.get(a, b))
        m2.put(a, b);
    }
    return m2;
  }

  static public <A, B> Map<A, B> filterMap(IF2<A, B, Boolean> f, Map<A, B> map) {
    return filterMap(map, f);
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, A... keys) {
    return getMultipleKeys(map, keys);
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, Iterable<A> keys) {
    return getMultipleKeys(map, keys);
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public void dm_watchField(String field, Runnable onChange) {
    new Dyn_FieldWatcher(dm_current_mandatory(), field, onChange);
  }

  static public void fillJPopupMenu(JPopupMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof IVF1)
        callF(o, m);
      else if (o instanceof List)
        fillJPopupMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o))
        m.addSeparator();
      else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem("", y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv!;\r\n        if (isCurlyBracketed(s)) {\r\n          setEnabled(mi,...";
          }
        });
        m.add(mi);
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public JavaXClassLoader hotwire_makeClassLoader(List<File> files) {
    Collection<String> toShare = hotwire_classesToShare();
    return nempty(toShare) ? new JavaXClassLoaderWithParent2(null, files, myClassLoader(), cloneList(toShare)) : new JavaXClassLoader(null, files);
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public int ifloor(double d) {
    return (int) Math.floor(d);
  }

  static public IntRange ifloor(DoubleRange r) {
    return r == null ? null : intRange(ifloor(r.start), ifloor(r.end));
  }

  static public boolean tok_isStaticLevelCode(List<String> tok) {
    return eqOneOf(firstCodeToken(tok), "static", "sclass", "sinterface", "sS", "sO");
  }

  static public boolean tok_isStaticLevelCode(String src) {
    return tok_isStaticLevelCode(javaTok(src));
  }

  static public boolean isUpperCaseLetter(char c) {
    return Character.isUpperCase(c);
  }

  static public String hmsWithColonsAndMS() {
    return hmsWithColonsAndMS(now());
  }

  static public String hmsWithColonsAndMS(long time) {
    return simpleDateFormat_local("HH:mm:ss:SSS").format(time);
  }

  static public int blend(int x, int y, double yish) {
    double xish = 1 - yish;
    return (int) (x * xish + y * yish);
  }

  static public double blend(double x, double y, double yish) {
    double xish = 1 - yish;
    return x * xish + y * yish;
  }

  static public void scpSet(SingleComponentPanel scp, Component c) {
    setSCPComponent(scp, c);
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta) {
    return enableWordWrapForTextArea(ta, true);
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta, boolean enabled) {
    if (ta != null) {
      swing(() -> {
        ta.setLineWrap(enabled);
        ta.setWrapStyleWord(true);
      });
    }
    return ta;
  }

  static public boolean isSystemThread(Thread t) {
    ThreadGroup g = t.getThreadGroup();
    return g != null && g.getName().equals("system");
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public void tokAppend_reTok(List<String> tok, int i, String s) {
    tok.set(i, tok.get(i) + s);
    reTok(tok, i, i + 1);
  }

  static public JLabel dm_calculatedCenteredLabel(IF0<Object> calc) {
    return dm_centeredCalculatedLabel(calc);
  }

  static public <A> A printHidingCredentials(A o) {
    print(hideCredentials(str(o)));
    return o;
  }

  static public int sqr(int i) {
    return i * i;
  }

  static public long sqr(long l) {
    return l * l;
  }

  static public double sqr(double d) {
    return d * d;
  }

  static public float sqr(float f) {
    return f * f;
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public Component childWithClassNameEndingWith(Component c, String suffix) {
    if (endsWith(className(c), suffix))
      return c;
    Component x;
    for (Component comp : getComponents(c)) if ((x = childWithClassNameEndingWith(comp, suffix)) != null)
      return x;
    return null;
  }

  static public int stepMax(int max, Steppable s) {
    if (s == null)
      return 0;
    int steps = 0;
    while (max-- > 0 && s.step()) {
      ping();
      ++steps;
    }
    return steps;
  }

  static public int stepMax(Steppable s, int max) {
    return stepMax(max, s);
  }

  static public String structureForUser(Object o) {
    return structureForUser(o, new structure_Data());
  }

  static public String structureForUser(Object o, structure_Data d) {
    d.noStringSharing = true;
    d.warnIfUnpersistable(false);
    return beautifyStructure(structure(o, d));
  }

  static public String ok(Object o) {
    return format("ok *", o);
  }

  static public <A, B> Map<A, B> mapMinus(Map<A, B> map, Object... keys) {
    if (empty(keys))
      return map;
    Map<A, B> m2 = cloneMap(map);
    for (Object key : keys) m2.remove(key);
    return m2;
  }

  static public String firstCodeToken(String s) {
    return firstJavaToken(s);
  }

  static public String firstCodeToken(List<String> tok) {
    return get(tok, 1);
  }

  static public boolean nohup_debug = false;

  static public boolean nohup_noSlashB = false;

  static public boolean nohup_keepScriptFile = false;

  static public ThreadLocal<Integer> nohup_exitValue = new ThreadLocal();

  public static File nohup(File cmd) {
    return nohup(f2s(cmd));
  }

  public static File nohup(String cmd) {
    try {
      File outFile = File.createTempFile("nohup_" + nohup_sanitize(cmd) + "_", ".out");
      nohup(cmd, outFile, false);
      return outFile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void nohup(String cmd, File outFile, boolean append) {
    try {
      String command = nohup_makeNohupCommand(cmd, outFile, append);
      File scriptFile = File.createTempFile("_realnohup", isWindows() ? ".bat" : "");
      print("[nohup] " + command);
      try {
        if (nohup_debug)
          print("[nohup] Script file: " + scriptFile.getPath());
        saveTextFile(scriptFile.getPath(), command);
        String[] command2;
        if (isWindows())
          if (nohup_noSlashB)
            command2 = new String[] { "cmd", "/c", "start", scriptFile.getPath() };
          else
            command2 = new String[] { "cmd", "/c", "start", "/b", scriptFile.getPath() };
        else
          command2 = new String[] { "/bin/bash", scriptFile.getPath() };
        print("[nohup] " + joinWithSpace(quoteAll(command2)));
        Process process = Runtime.getRuntime().exec(command2);
        try {
          process.waitFor();
        } catch (InterruptedException e) {
          throw new RuntimeException(e);
        }
        int value = process.exitValue();
        nohup_exitValue.set(value);
        if (value != 0)
          warn("nohup exit value != 0: " + value);
      } finally {
        if (!nohup_keepScriptFile && !isWindows())
          scriptFile.delete();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String nohup_makeNohupCommand(String cmd, File outFile, boolean append) {
    mkdirsForFile(outFile);
    String command;
    if (isWindows())
      command = cmd + (append ? " >>" : " >") + winQuote(outFile.getPath()) + " 2>&1";
    else
      command = "nohup " + cmd + (append ? " >>" : " >") + bashQuote(outFile.getPath()) + " 2>&1 &";
    return command;
  }

  static public Rect pointsRect(int x1, int y1, int x2, int y2) {
    return new Rect(x1, y1, x2 - x1, y2 - y1);
  }

  static public JCheckBox jCheckBox() {
    return swingNu(JCheckBox.class);
  }

  static public JCheckBox jCheckBox(boolean checked) {
    return swingNu(JCheckBox.class, "", checked);
  }

  static public JCheckBox jCheckBox(String text, boolean checked) {
    return swingNu(JCheckBox.class, text, checked);
  }

  static public JCheckBox jCheckBox(String text) {
    return swingNu(JCheckBox.class, text);
  }

  static public JCheckBox jCheckBox(String text, boolean checked, Object onChange) {
    JCheckBox cb = jCheckBox(text, checked);
    cb.setText(text);
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, final Object onChange) {
    final JCheckBox cb = jCheckBox(checked);
    cb.addChangeListener(new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(onChange, cb.isSelected());
      }
    });
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, String text, IVF1<Boolean> onChangeAndNow) {
    var cb = jCheckBox(text, checked);
    onChangeAndNow(cb, new Runnable() {

      public void run() {
        try {
          onChangeAndNow.get(isChecked(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "onChangeAndNow.get(isChecked(cb));";
      }
    });
    return cb;
  }

  static public void poorMansProfileToConsole(Runnable r) {
    poorMansProfiling();
    try {
      r.run();
    } finally {
      poorMansProfiling_stopAndPrintResults();
    }
  }

  static public int toMS_int(double seconds) {
    return toInt_checked((long) (seconds * 1000));
  }

  static public String jlabel_textAsHTML_center_ifNeeded(String text) {
    if (swic(text, "<html>") && ewic(text, "</html>"))
      return text;
    if (!containsNewLines(text))
      return text;
    return jlabel_textAsHTML_center(text);
  }

  static public List<String> hotwire_libraryIDsFromJar_deleteJarOnFail(File jar) {
    try {
      return hotwire_libraryIDsFromJar(jar);
    } catch (Throwable _e) {
      jar.delete();
      throw rethrow(_e);
    }
  }

  static public IF0 runnableToIF0(Runnable r) {
    return r == null ? null : () -> {
      r.run();
      return null;
    };
  }

  static public Pt rectTopLeftCorner(Rect r) {
    return r == null ? null : pt(r.x, r.y);
  }

  static public <A> Scored<A> scored(A a, float score) {
    return new Scored(a, score);
  }

  static public <A> Scored<A> scored(A a, double score) {
    return new Scored(a, (float) score);
  }

  static public <A> Scored<A> scored(A a, Scored scored) {
    return new Scored(a, getScore(scored));
  }

  static public <A> Scored<A> scored(double score, A a) {
    return scored(a, score);
  }

  static public File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }

  static public <A extends Window> A onWindowClosing(A w, Object r) {
    return onWindowClosing(w, toRunnable(r));
  }

  static public <A extends Window> A onWindowClosing(A w, Runnable r) {
    if (w != null) {
      swing(() -> {
        w.addWindowListener(new WindowAdapter() {

          public void windowClosing(WindowEvent e) {
            AutoCloseable __1 = tempRememberListener(w, "removeWindowListener", this);
            try {
              pcallF(r);
            } finally {
              _close(__1);
            }
          }
        });
      });
    }
    return w;
  }

  static public <A extends Window> A onWindowClosing(Runnable r, A w) {
    return onWindowClosing(w, r);
  }

  static public List<File> filesEndingWith(File dir, String suffix) {
    return listFilesWithSuffix(dir, suffix);
  }

  static public List<File> filesEndingWith(List<File> l, String suffix) {
    List<File> out = new ArrayList();
    for (File f : unnull(l)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      out.add(f);
    return out;
  }

  static public List<File> filesEndingWith(String suffix, File dir) {
    return filesEndingWith(dir, suffix);
  }

  static public String manifestPathInJar() {
    return "META-INF/MANIFEST.MF";
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public Object[] asArray(List l) {
    return toObjectArray(l);
  }

  static public <A> A[] asArray(Class<A> type, List l) {
    return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
  }

  static public Pt pt(int x, int y) {
    return new Pt(x, y);
  }

  static public Pt pt(int x) {
    return new Pt(x, x);
  }

  static public List mapMethod(Object[] l, final String methodName) {
    return map(l, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(Iterable c, final String methodName) {
    return map(c, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(String methodName, Iterable c) {
    return mapMethod(c, methodName);
  }

  static public List mapMethod(String methodName, Enumeration c) {
    return mapMethod(methodName, enumerationToIterator(c));
  }

  static public JTextArea showText(final String title, Object text) {
    return showText(null, title, text);
  }

  static public JTextArea showText(JTextArea ta, final String title, Object text) {
    final String _text = str(text);
    if (ta != null)
      return activateFrameAndReturnComponent(setFrameTitle(title, setText(ta, _text)));
    return swing(new F0<JTextArea>() {

      public JTextArea get() {
        try {
          JTextArea textArea = newTypeWriterTextArea(_text);
          makeFrame(title, new JScrollPane(textArea));
          return textArea;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextArea textArea = newTypeWriterTextArea(_text);\r\n    makeFrame(title, new ...";
      }
    });
  }

  static public JTextArea showText(Object text) {
    return showText(str(text));
  }

  static public JTextArea showText(String text) {
    return showText(autoFrameTitle(), text);
  }

  static public JTextArea showText() {
    return showText("");
  }

  static public Map convertObjectMetaToMap(IMeta o) {
    return convertObjectMetaToMap(o, () -> makeObjectMetaMap());
  }

  static public Map convertObjectMetaToMap(IMeta o, IF0<Map> createEmptyMap) {
    if (o == null)
      return null;
    Object meta = o._getMeta();
    if (meta instanceof Map)
      return ((Map) meta);
    var mutex = tempMetaMutex(o);
    try {
      var actualMutex = mutex.get();
      synchronized (actualMutex) {
        meta = o._getMeta();
        if (meta instanceof Map)
          return ((Map) meta);
        Map map = createEmptyMap.get();
        if (meta != null)
          map.put("previousMeta", meta);
        o._setMeta(map);
        return map;
      }
    } finally {
      _close(mutex);
    }
  }

  static public String repSimple(int n, char c) {
    return repeat(c, n);
  }

  static public <A> List<A> repSimple(int n, A a) {
    return repeat(n, a);
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public JPanel infoMessage_makePanel(String text) {
    final JTextArea ta = wrappedTextArea(text);
    onClick(ta, new Runnable() {

      public void run() {
        try {
          disposeWindow(ta);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "disposeWindow(ta)";
      }
    });
    int size = 14;
    if (l(text) <= 50)
      size *= 2;
    else if (l(text) < 100)
      size = iround(size * 1.5);
    ta.setFont(typeWriterFont(size));
    JScrollPane sp = jscroll(ta);
    return withMargin(sp);
  }

  static public void setDefaultClassFinder(Object cf) {
    _defaultClassFinder_value = cf;
  }

  static public int countLines(String s) {
    return l(toLines(s));
  }

  static public boolean isCurlyBracketed(String s) {
    return isCurlyBraced(s);
  }

  static public String intsToHex_withLineBreaks(List<Integer> l) {
    return intsToHex_withLineBreaks(80, l);
  }

  static public String intsToHex_withLineBreaks(int charsPerLine, List<Integer> l) {
    return regularLineBreaks(charsPerLine, intsToHex(l));
  }

  static public String intsToHex_withLineBreaks(int... l) {
    return intsToHex_withLineBreaks(80, l);
  }

  static public String intsToHex_withLineBreaks(int charsPerLine, int... l) {
    return intsToHex_withLineBreaks(charsPerLine, wrapIntArrayAsList(l));
  }

  static public ImageSurface doubleBufferedImageSurface_noAlpha() {
    ImageSurface is = doubleBufferedImageSurface();
    is.noAlpha = true;
    return is;
  }

  static public int snippetType_dynModule() {
    return 57;
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final IF0 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __1 = m.enter();
          try {
            return callF(f);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final F0 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __2 = m.enter();
          try {
            return callF(f);
          } finally {
            _close(__2);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final F1 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __3 = m.enter();
          try {
            return callF(f, arg);
          } finally {
            _close(__3);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f, arg);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, F2 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          if (arg instanceof Object[]) {
            if (((Object[]) arg).length != 2)
              return null;
            AutoCloseable __4 = m.enter();
            try {
              return callF(f, ((Object[]) arg)[0], ((Object[]) arg)[1]);
            } finally {
              _close(__4);
            }
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (arg cast O[]) {\r\n      if (arg.length != 2) null;\r\n      temp m.enter();\r...";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, F3 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          if (arg instanceof Object[]) {
            if (((Object[]) arg).length != 3)
              return null;
            AutoCloseable __5 = m.enter();
            try {
              return callF(f, ((Object[]) arg)[0], ((Object[]) arg)[1], ((Object[]) arg)[2]);
            } finally {
              _close(__5);
            }
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (arg cast O[]) {\r\n      if (arg.length != 3) null;\r\n      temp m.enter();\r...";
      }
    }));
  }

  static public <A> A getOrKeep(Map<A, ? extends A> map, A a) {
    if (map == null)
      return a;
    A v = map.get(a);
    return v != null ? v : a;
  }

  static public List<Byte> toByteList(Object o) {
    if (o == null)
      return null;
    if (o instanceof List)
      return ((List) o);
    if (o instanceof Iterable)
      return toList((Iterable) o);
    if (o instanceof byte[])
      return wrapPrimitiveArrayAsImmutableList((byte[]) o);
    throw fail();
  }

  static public String afterDollar(String s) {
    return substring(s, smartIndexOf(s, '$') + 1);
  }

  static public String filterChars(IF1<Character, Boolean> pred, String s) {
    if (empty(s))
      return null;
    int n = l(s), i = 0;
    char c = s.charAt(i);
    boolean totality = pred.get(c);
    for (++i; i < n; i++) {
      c = s.charAt(i);
      boolean b = pred.get(c);
      if (b != totality) {
        StringBuilder buf = new StringBuilder();
        if (totality)
          buf.append(substring(s, 0, i));
        while (true) {
          ping();
          if (b)
            buf.append(c);
          if (++i >= n)
            break;
          c = s.charAt(i);
          b = pred.get(c);
        }
        return buf.toString();
      }
    }
    return totality ? s : "";
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public Object costCenter() {
    return mc();
  }

  static public File getBytecodePathForClass(Object o) {
    return getBytecodePathForClass(_getClass(o));
  }

  static public File getBytecodePathForClass(Class c) {
    try {
      return c == null ? null : new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel smartAdd(JPanel panel, List parts) {
    for (Object o : parts) addToContainer(panel, wrapForSmartAdd(o));
    return panel;
  }

  static public JPanel smartAdd(JPanel panel, Object... parts) {
    return smartAdd(panel, asList(parts));
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    if (src != null)
      dest.addAll(src);
  }

  static public Color gazelle_color2() {
    return awtColor("EEEEEE");
  }

  static public boolean transpileRaw_silent = true;

  static public boolean transpileRaw_useDiskCache = false;

  static public Class transpileRaw_trans;

  static public boolean transpileRaw_mine = true;

  static public boolean transpileRaw_verySilent = false;

  static public boolean transpileRaw_dontCopyFromCreator = false;

  static public Lock transpileRaw_lock = lock();

  static public ThreadLocal<Boolean> transpileRaw_asInclude = new ThreadLocal();

  static public ThreadLocal<String> transpileRaw_progID = new ThreadLocal();

  static public String transpileRaw(String mainJava) {
    return transpileRaw(mainJava, false, transpileRaw_useDiskCache);
  }

  static public String transpileRaw(String mainJava, boolean fragment) {
    return transpileRaw(mainJava, fragment, transpileRaw_useDiskCache);
  }

  static public String transpileRaw(String mainJava, boolean fragment, boolean useDiskCache) {
    mainJava = dropTranslators(mainJava);
    if (!transpileRaw_dontCopyFromCreator)
      transpileRaw_copyFromCreator();
    Lock __0 = transpileRaw_lock;
    lock(__0);
    try {
      File cacheFile = null;
      if (useDiskCache) {
        cacheFile = new File(javaxCodeDir(), "Transpilations/" + uniqueFileNameUsingMD5_80_v2(mainJava) + ".java");
        {
          String __3 = loadTextFile(cacheFile);
          if (!empty(__3))
            return __3;
        }
      }
      AutoCloseable __4 = transpileRaw_verySilent ? null : tempLoadingAnim("Transpiling...");
      try {
        transpileRaw_translator();
        setOpt(transpileRaw_trans, "localStuffOnly", fragment);
        setOpt(transpileRaw_trans, "asInclude", isTrue(transpileRaw_asInclude.get()));
        setOpt(transpileRaw_trans, "mainSnippetID", transpileRaw_progID.get());
        set(transpileRaw_trans, "mainJava", mainJava);
        set(transpileRaw_trans, "print_byThread", print_byThread);
        if (!transpileRaw_verySilent)
          print("Running translator " + getOpt(transpileRaw_trans, "programID"));
        callMain(transpileRaw_trans);
        String main = (String) (get(transpileRaw_trans, "mainJava"));
        if (useDiskCache) {
          saveTextFile(new File(cacheFile.getPath() + "x"), mainJava);
          saveTextFile(cacheFile, main);
        }
        return main;
      } finally {
        _close(__4);
      }
    } finally {
      unlock(__0);
    }
  }

  static public IF0<Class> transpileRaw_translator;

  static public Class transpileRaw_translator() {
    return transpileRaw_translator != null ? transpileRaw_translator.get() : transpileRaw_translator_base();
  }

  final static public Class transpileRaw_translator_fallback(IF0<Class> _f) {
    return _f != null ? _f.get() : transpileRaw_translator_base();
  }

  static public Class transpileRaw_translator_base() {
    if (transpileRaw_trans == null) {
      transpileRaw_trans = transpileRaw_makeTranslator();
      transpileRaw_mine = true;
      makeDependent(transpileRaw_trans);
    }
    setOpt(transpileRaw_trans, "print_silent", transpileRaw_silent);
    return transpileRaw_trans;
  }

  static public IF0<Class> transpileRaw_makeTranslator;

  static public Class transpileRaw_makeTranslator() {
    return transpileRaw_makeTranslator != null ? transpileRaw_makeTranslator.get() : transpileRaw_makeTranslator_base();
  }

  final static public Class transpileRaw_makeTranslator_fallback(IF0<Class> _f) {
    return _f != null ? _f.get() : transpileRaw_makeTranslator_base();
  }

  static public Class transpileRaw_makeTranslator_base() {
    return hotwireSharingLibraries_silently(defaultJavaXTranslatorID());
  }

  static public void transpileRaw_copyFromCreator() {
    Lock __1 = transpileRaw_lock;
    lock(__1);
    try {
      if (transpileRaw_trans != null)
        return;
      Object c = creator();
      if (c == null)
        return;
      Class trans = (Class) (getOpt(c, "transpileRaw_trans"));
      Lock lock = (Lock) (getOpt(c, "transpileRaw_lock"));
      if (trans != null && lock != null) {
        print("Using creator's transpiler: " + getProgramID(c) + " => " + programID());
        transpileRaw_lock = lock;
        transpileRaw_trans = trans;
        transpileRaw_mine = false;
      }
    } finally {
      unlock(__1);
    }
  }

  static public void cleanMeUp_transpileRaw() {
    if (transpileRaw_mine)
      cleanUp(transpileRaw_trans);
    transpileRaw_trans = null;
  }

  static public <A, B> B rCallF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A> void rCallF(A a, IVF1<A> f) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public void installWindowResizeDraggerOnBorder(JComponent c) {
    if (c != null) {
      swing(() -> {
        new WindowResizeDragger(c);
      });
    }
  }

  static public String linesLL(Object... x) {
    return lines(ll(x));
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public <A> A safeGet(List<A> l, int i) {
    return i >= 0 && i < l(l) ? l.get(i) : null;
  }

  static public void clearTokens_reTok(List<String> tok, int i, int j) {
    clearTokens(tok, i, j);
    reTok(tok, i, j);
  }

  static public void clearTokens_reTok(List<String> tok, IntRange r) {
    if (r != null)
      clearTokens_reTok(tok, r.start, r.end);
  }

  static public <A> int sortedSet_compare(SortedSet<A> set, A a, A b) {
    return compareWithComparator(set.comparator(), a, b);
  }

  static public void stepForNSeconds(double timeout, Steppable s) {
    stepAllWithTimeout(timeout, s);
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public boolean javaCompileToJar_useRAMDisk = false;

  static public ThreadLocal<List<File>> javaCompileToJar_localLibraries = new ThreadLocal();

  static public ThreadLocal<IVF1<File>> javaCompileToJar_addMoreFiles = new ThreadLocal();

  static public File javaCompileToJar_optionalRename(String src, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, "", destJar, progIDForRename);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, dehlibs, destJar, progIDForRename, null);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename, String progID) {
    String javaTarget = null;
    String dummyClass = "main";
    if (progIDForRename != null) {
      dummyClass = dummyMainClassName(progIDForRename);
      src += "\nclass " + dummyClass + "{}";
    }
    String md5 = md5(src);
    File jar = destJar;
    Class j = getJavaX();
    if (javaTarget != null)
      setOpt(j, "javaTarget", javaTarget);
    File srcDir = tempDir();
    String fileName = dummyClass + ".java";
    List<String> tok = javaTok(src);
    String packageName = tok_packageName(tok);
    if (packageName != null)
      fileName = packageName.replace(".", "/") + "/" + tok_firstClassName(tok) + ".java";
    File mainJava = new File(srcDir, fileName);
    saveTextFile(mainJava, src);
    File classesDir = javaCompileToJar_useRAMDisk ? tempDirPossiblyInRAMDisk() : tempDir();
    try {
      List<File> libraries = cloneList(getAndClearTL(javaCompileToJar_localLibraries));
      Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
      while (m.find()) {
        String libID = m.group();
        assertTrue(isSnippetID(libID));
        libraries.add(loadLibraryOrSrcLib(libID));
      }
      libraries.add(pathToJavaxJar());
      String compilerOutput;
      try {
        compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
      } catch (Throwable e) {
        compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
        if (!swic(e.getMessage(), "Java compiler returned errors."))
          compilerOutput = appendWithNewLine(compilerOutput, str(e));
        throw fail(compilerOutput, e);
      }
      compilerOutput = cleanJavaCompilerOutput("Annotation processing got disabled, since it requires a 1.6 compliant JVM");
      if (nempty(compilerOutput)) {
        print("Compiler said: " + compilerOutput);
      }
      if (!anyFileWithExtensionInDir(classesDir, ".class")) {
        printWithIndent("SRC> ", src);
        throw fail("No classes generated (was compiling " + nChars(src) + ")");
      }
      saveTextFile(new File(classesDir, "main.java"), src);
      if (nempty(dehlibs))
        saveTextFile(new File(classesDir, "libraries"), dehlibs);
      saveTextFile(new File(classesDir, "progID"), progID);
      callF(javaCompileToJar_addMoreFiles.get(), classesDir);
      dir2zip_recurse_verbose = false;
      int n = dir2zip_recurse(classesDir, jar);
      return jar;
    } finally {
      if (isInRAMDisk(classesDir))
        deleteDirectory(classesDir);
    }
  }

  static public File getCachedTranspilationFile(String id) {
    return newFile(getCodeProgramDir(id), "Transpilation");
  }

  static public void _initFrame(JFrame f) {
    myFrames_list.put(f, Boolean.TRUE);
    standardTitlePopupMenu(f);
  }

  static public <A> List<A> minus(Collection<A> a, Object... b) {
    Set set = asSet(b);
    List l = new ArrayList();
    for (Object s : unnull(a)) if (!set.contains(s))
      l.add(s);
    return l;
  }

  static public BigInteger minus(BigInteger a, BigInteger b) {
    return a.subtract(b);
  }

  static public Complex minus(Complex c) {
    return c == null ? null : complex(-c.re(), -c.im());
  }

  static public int minus(int a, int b) {
    return a - b;
  }

  static public int minus(int a) {
    return -a;
  }

  static public double minus(double a, double b) {
    return a - b;
  }

  static public double minus(double a) {
    return -a;
  }

  static public long minus(long a, long b) {
    return a - b;
  }

  static public long minus(long a) {
    return -a;
  }

  static public <A> A printWithIndent(A o) {
    return printIndent(o);
  }

  static public <A> A printWithIndent(String indent, A o) {
    return printIndent(indent, o);
  }

  static public void printWithIndent(int indent, Object o) {
    printIndent(indent, o);
  }

  static public <A> boolean hasElementWithClassShortNamed(String shortName, Iterable<A> l) {
    return firstWithClassShortNamed(shortName, l) != null;
  }

  static public <A> boolean hasElementWithClassShortNamed(String shortName, A[] l) {
    return firstWithClassShortNamed(shortName, l) != null;
  }

  static public <A> List<A> syncAddOrCreate(List<A> l, A a) {
    if (l == null)
      l = syncList();
    l.add(a);
    return l;
  }

  static public void tokPrepend(List<String> tok, String s) {
    tokPrepend(tok, 0, s);
  }

  static public void tokPrepend(List<String> tok, int i, String s) {
    tok.set(i, s + tok.get(i));
  }

  static public <A, B> List<A> keysList(Map<A, B> map) {
    return cloneListSynchronizingOn(keys(map), map);
  }

  static public <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

  static public boolean containsReturnWithArgument(List<String> tok) {
    for (int i = 1; i + 2 < l(tok); i += 2) {
      String t = tok.get(i);
      if (eqOneOf(t, "ret", "return") && neqOneOf(tok.get(i + 2), ";", "if", "unless", "with"))
        return true;
      if (eqOneOf(t, "embedded", "class") && isIdentifier(get(tok, i + 2)) || eq(t, "(") && eqGet(tok, i + 2, ")") && eqGet(tok, i + 4, "{"))
        i = tok_findEndOfMethodDecl(tok, i) - 1;
      if (eqOneOf(t, "r", ">") && eqGet(tok, i + 2, "{"))
        i = findEndOfBlock(tok, i + 2) - 1;
    }
    return false;
  }

  static public boolean containsReturnWithArgument(String code) {
    return containsReturnWithArgument(javaTok(code));
  }

  static public String fileNameEncode_safeChars = " ";

  static public String fileNameEncode(String s) {
    s = dropLeadingDots(s);
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (contains(fileNameEncode_safeChars, c))
        buf.append(c);
      else
        buf.append(urlencode(str(c)));
    }
    return str(buf);
  }

  static public AutoCloseable tempHoldInstance(Object o) {
    return holdInstance(o);
  }

  static public String getSnippetTitleOpt(String s) {
    try {
      return isSnippetID(s) ? getSnippetTitle(s) : s;
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return s;
  }

  static public <A> List<A> reversedList(Iterable<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public int getScreenHeight() {
    return getScreenSize().height;
  }

  static public List<Integer> byteArrayToIntList_littleEndian(byte[] a) {
    if (a == null)
      return null;
    int n = (a.length + 3) / 4;
    return new RandomAccessAbstractList<Integer>() {

      public int size() {
        return n;
      }

      public Integer get(int i) {
        return intFromBytes_littleEndian_partial(a, i * 4);
      }

      public Integer set(int i, Integer val) {
        Integer old = get(i);
        if ((int) old != (int) val)
          intToBytes_inArray_littleEndian_partial(val, a, i * 4);
        return old;
      }
    };
  }

  static public void dm_ownTimer(Object resource, Object closerHelper) {
    call(dm_current_generic(), "ownTimer", resource, closerHelper);
  }

  static public <A> A dm_ownTimer(A resource) {
    call(dm_current_generic(), "ownTimer", resource);
    return resource;
  }

  static public <A> void dm_ownTimer(IVF1<A> closerHelper, A resource) {
    dm_ownTimer(resource, closerHelper);
  }

  static public double ratio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public IterableIterator<Integer> countIterator(int b) {
    return countIterator(0, b);
  }

  static public IterableIterator<Integer> countIterator(int a, int b) {
    return countIterator_exclusive(a, b);
  }

  static public <A> IterableIterator<A> countIterator(int b, IF1<Integer, A> f) {
    return countIterator(0, b, f);
  }

  static public <A> IterableIterator<A> countIterator(int a, int b, IF1<Integer, A> f) {
    return countIterator_exclusive(a, b, f);
  }

  static public IterableIterator<Integer> countIterator(int a, int b, int step) {
    return countIterator_exclusive_step(a, b, step);
  }

  static public <A> IterableIterator<A> countIterator(double a, double b, double step, IF1<Double, A> f) {
    return countIterator_exclusive_step(a, b, step, f);
  }

  static public <A> IterableIterator<Double> countIterator(double a, double b, double step) {
    return countIterator_exclusive_step(a, b, step);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Double, A> f, double a, double b, double step) {
    return countIterator(a, b, step, f);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Integer, A> f, int b) {
    return countIterator(f, 0, b);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Integer, A> f, int a, int b) {
    return countIterator_exclusive(a, b, f);
  }

  static public <A> IterableIterator<Integer> countIterator(List l) {
    return countIterator(l(l));
  }

  static public PopupMenu makePopupMenu(Object... x) {
    if (x == null)
      return null;
    if (l(x) == 1 && x[0] instanceof PopupMenu)
      return (PopupMenu) x[0];
    PopupMenu m = new PopupMenu();
    for (int i = 0; i < l(x); i++) {
      Object o = x[i];
      if (eqOneOf(o, "***", "---", "===", ""))
        m.addSeparator();
      else if (o instanceof String && get(x, i + 1) instanceof Runnable)
        m.add(menuItem((String) o, get(x, ++i)));
      else if (o instanceof String || o instanceof Menu || o instanceof MenuItem)
        call(m, "add", o);
      else
        print("Unknown menu item: " + o);
    }
    return m;
  }

  static public List<String> methodsStartingWith(Object o, final String prefix) {
    return filter(allMethodNames(o), new F1<String, Object>() {

      public Object get(String s) {
        try {
          return startsWith(s, prefix);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startsWith(s, prefix)";
      }
    });
  }

  static public short[] subShortArray(short[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new short[0];
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  static public boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public boolean isNaN(double d) {
    return Double.isNaN(d);
  }

  static public boolean isNaN(float f) {
    return Float.isNaN(f);
  }

  static public void fillRect(BufferedImage image, int x, int y, int w, int h, Color color) {
    Graphics2D g = imageGraphics(image);
    fillRect(g, x, y, w, h, color);
    g.dispose();
  }

  static public void fillRect(Graphics g, Color color, int x, int y, int w, int h) {
    fillRect(g, x, y, w, h, color);
  }

  static public void fillRect(Graphics g, int x, int y, int w, int h, Color color) {
    g.setColor(color);
    g.fillRect(x, y, w, h);
  }

  static public void fillRect(int x, int y, int w, int h, Color color) {
    fillRect(currentImage(), x, y, w, h, color);
  }

  static public void fillRect(Rect r, Color color) {
    fillRect(r.x, r.y, r.w, r.h, color);
  }

  static public void fillRect(BufferedImage image, Rect r, Color c) {
    if (r != null)
      fillRect(image, r.x, r.y, r.w, r.h, c);
  }

  static public void fillRect(Graphics g, Rect r, Color c) {
    if (r != null)
      fillRect(g, r.x, r.y, r.w, r.h, c);
  }

  static public int[] resizeIntArray(int[] a, int n) {
    if (n == lIntArray(a))
      return a;
    int[] b = new int[n];
    arraycopy(a, 0, b, 0, Math.min(lIntArray(a), n));
    return b;
  }

  static public JPanel westCenterAndEastWithMargin(Component w, Component c, Component e) {
    return westCenterAndEast(w, withLeftAndRightMargin(c), e);
  }

  static public <A> A lookupDynamicInterface(Class<A> intrface, Object o) {
    if (o instanceof DynamicObject) {
      A a = (A) (mapGet((Map) ((DynamicObject) o).fieldValues, intrface));
      if (a != null)
        return a;
    }
    if (isInstance(intrface, o))
      return (A) o;
    return null;
  }

  static public <A> A lookupDynamicInterface(Object o, Class<A> intrface) {
    return lookupDynamicInterface(intrface, o);
  }

  static public String indentx(Object s) {
    return indentx(strOrEmpty(s));
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String getSelectedItem(JList l) {
    return (String) l.getSelectedValue();
  }

  static public String getSelectedItem(JComboBox cb) {
    return strOrNull(cb.getSelectedItem());
  }

  static public double elapsedSeconds_timestamp(long time) {
    return toSeconds(now() - time);
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public int loadAllClassesInByteCodePath(File path) {
    int n = 0;
    for (String name : allClassNamesOnPath(ll(path))) try {
      Class.forName(name);
      ++n;
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
    return n;
  }

  static public <A extends Component> A activateFrameAndReturnComponent(A c) {
    activateFrame(c);
    return c;
  }

  static public short[] takeFirstOfShortArray(short[] b, int n) {
    return subShortArray(b, 0, n);
  }

  static public short[] takeFirstOfShortArray(int n, short[] b) {
    return takeFirstOfShortArray(b, n);
  }

  static public boolean tok_shouldAddReturn(List<String> tok) {
    String lastToken = get(tok, l(tok) - 2);
    if (eqOneOf(lastToken, ";", null))
      return false;
    if (eq(lastToken, "}")) {
      int i = findBeginningOfBlock(tok, l(tok) - 2);
      return eqGet(tok, i - 4, "-") && eqGet(tok, i - 3, "") && eqGet(tok, i - 2, ">");
    }
    return true;
  }

  static public boolean tok_shouldAddReturn(String s) {
    return tok_shouldAddReturn(javaTok(s));
  }

  static public JLabel dm_centeredFieldLabel(String fieldName) {
    return centerLabel(dm_fieldLabel(fieldName));
  }

  static public String ymd_minus_hms() {
    return ymd_minus_hms(now());
  }

  static public String ymd_minus_hms(long now) {
    return ymd(now) + "-" + hms(now);
  }

  static public boolean isChecked(JCheckBox checkBox) {
    return checkBox != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return checkBox.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return checkBox.isSelected();";
      }
    });
  }

  static public boolean isChecked(JCheckBoxMenuItem mi) {
    return mi != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return mi.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return mi.isSelected();";
      }
    });
  }

  static public boolean isChecked(JRadioButton rb) {
    return rb != null && (boolean) swing(() -> rb.isSelected());
  }

  static public JButton jPopDownButton(String text, final Object... menuParams) {
    return jbutton((empty(text) ? "" : text + " ") + unicode_downPointingTriangle(), new Runnable() {

      public void run() {
        try {
          JPopupMenu menu = new JPopupMenu();
          int emptyCount = menu.getComponentCount();
          String position = (String) (optPar_ignoreOddLength("position", menuParams));
          fillJPopupMenu(menu, paramsWithout(menuParams, "position"));
          if (menu.getComponentCount() != emptyCount) {
            JButton btn = heldInstance(JButton.class);
            int x = 0;
            if (eq(position, "center"))
              x = (btn.getWidth() - getPreferredWidth(menu)) / 2;
            else if (eq(position, "right"))
              x = btn.getWidth() - getPreferredWidth(menu);
            menu.show(btn, x, btn.getHeight());
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JPopupMenu menu;\r\n    int emptyCount = menu.getComponentCount();\r\n    Str...";
      }
    });
  }

  static public void innerCleanUp(Object c) {
    if (!isFalse(pcallOpt(c, "cleanMeUp")))
      for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
        callOpt(c, name);
      } catch (Throwable e) {
        print("Error cleaning up: " + programID(c));
        _handleException(e);
      }
  }

  static public void innerCleanUp() {
    innerCleanUp(mc());
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Map similarEmptyMap(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeMap(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Object getMC(String field) {
    return get(mc(), field);
  }

  static public File toFile(Object o) {
    if (o instanceof File)
      return (File) o;
    if (o instanceof String)
      return new File((String) o);
    throw fail("Not a file: " + o);
  }

  static public byte[] gunzipBytes(byte[] data) {
    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      copyStreamAndCloseAll(newGZIPInputStream(new ByteArrayInputStream(data)), baos);
      return baos.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a) {
    if (a == null)
      return null;
    return intArrayToList(a, 0, a.length);
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a, int from, int to) {
    if (a == null)
      return null;
    ArrayList<Integer> l = new ArrayList<>(to - from);
    for (int i = from; i < to; i++) l.add(a[i]);
    return l;
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public <A> List<A> drop(Iterable<A> c, Object pred) {
    return antiFilter(c, pred);
  }

  static public List drop(Object pred, Iterable c) {
    return antiFilter(pred, c);
  }

  static public List drop(Object pred, Object[] c) {
    return antiFilter(pred, c);
  }

  static public <A, B extends A> List<B> drop(Iterable<B> c, F1<A, Boolean> pred) {
    return antiFilter(c, pred);
  }

  static public <A, B extends A> List<B> drop(F1<A, Boolean> pred, Iterable<B> c) {
    return antiFilter(pred, c);
  }

  static public <A, B extends A> List<B> drop(Iterable<B> c, IF1<A, Boolean> pred) {
    return antiFilter(c, pred);
  }

  static public <A, B extends A> List<B> drop(IF1<A, Boolean> pred, Iterable<B> c) {
    return antiFilter(pred, c);
  }

  static public int snippetType_JavaXDesktop() {
    return 55;
  }

  static public void intToBytes_inArray_littleEndian_partial(int i, byte[] array, int idx) {
    if (idx < array.length)
      array[idx] = (byte) i;
    if (idx + 1 < array.length)
      array[idx + 1] = (byte) (i >>> 8);
    if (idx + 2 < array.length)
      array[idx + 2] = (byte) (i >>> 16);
    if (idx + 3 < array.length)
      array[idx + 3] = (byte) (i >>> 24);
  }

  static public File compilerBotDestDir() {
    return actualUserDir(compilerBotDestDirSubName());
  }

  static public File compilerBotDestDir(String sub) {
    return newFile(compilerBotDestDir(), sub);
  }

  static public Object metaMapGet(IMeta o, Object key) {
    return o == null ? null : o.metaGet(key);
  }

  static public Object metaMapGet(Object o, Object key) {
    return metaMapGet(toIMeta(o), key);
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public void standardTitlePopupMenu(final JFrame frame) {
    if (!isSubstanceLAF())
      return;
    titlePopupMenu(frame, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          boolean alwaysOnTop = frame.isAlwaysOnTop();
          menu.add(jmenuItem("Restart Program", new Runnable() {

            public void run() {
              try {
                restart();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "restart();";
            }
          }));
          menu.add(jmenuItem("Duplicate Program", new Runnable() {

            public void run() {
              try {
                duplicateThisProgram();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "duplicateThisProgram();";
            }
          }));
          menu.add(jmenuItem("Show Console", new Runnable() {

            public void run() {
              try {
                showConsole();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "showConsole();";
            }
          }));
          menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() {

            public void run() {
              try {
                toggleAlwaysOnTop(frame);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "toggleAlwaysOnTop(frame)";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n    ifndef standardTitlePopupMenu_...";
      }
    });
  }

  static public <A> AutoCloseable tempAdd(Collection<A> l, A a) {
    if (l == null || l.contains(a))
      return null;
    l.add(a);
    return new tempAdd_undo(l, a);
  }

  static public class tempAdd_undo<A> implements AutoCloseable, IFieldsToList {

    public Collection<A> l;

    public A a;

    public tempAdd_undo() {
    }

    public tempAdd_undo(Collection<A> l, A a) {
      this.a = a;
      this.l = l;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + l + ", " + a + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { l, a };
    }

    public void close() {
      try {
        l.remove(a);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public AutoCloseable tempAdd(Container a, Component b) {
    if (a == null || b == null)
      return null;
    {
      return swing(() -> {
        if (b.getParent() == a)
          return null;
        a.add(b);
        return () -> {
          swing(() -> {
            if (b.getParent() == a)
              removeFromParent(b);
          });
        };
      });
    }
  }

  static public String loadProgramTextFile(String name) {
    return loadTextFile(getProgramFile(name));
  }

  static public String loadProgramTextFile(String progID, String name) {
    return loadTextFile(getProgramFile(progID, name));
  }

  static public String loadProgramTextFile(String progID, String name, String defaultText) {
    return loadTextFile(getProgramFile(progID, name), defaultText);
  }

  static public String mcName() {
    return mc().getName();
  }

  static public MouseAdapter onMouseDown(Component c, Runnable r) {
    return onMouseDown(c, runnableToIVF1(r));
  }

  static public MouseAdapter onMouseDown(Component c, IVF1<MouseEvent> f) {
    return c == null || f == null ? null : swing(() -> {
      MouseAdapter ma = new MouseAdapter() {

        public void mousePressed(MouseEvent e) {
          if (e.getButton() == MouseEvent.BUTTON1)
            f.get(e);
        }
      };
      c.addMouseListener(ma);
      return ma;
    });
  }

  static public <A> AutoCloseable tempDisposeWindow(final Window w) {
    return new AutoCloseable() {

      public void close() {
        disposeWindow(w);
      }
    };
  }

  static public Cache<Boolean> isLinux_cache = new Cache<>(() -> isLinux_load());

  static public boolean isLinux() {
    return isLinux_cache.get();
  }

  static public Boolean isLinux_load() {
    return !isWindows() && !isMac() && !isAndroid();
  }

  static public boolean checkFields(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public <A> IterableIterator<A> iff(Object f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public IterableIterator iff(F0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public <A> IterableIterator iff(IF0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public JWindow makeWindow(final Component c) {
    return swing(new F0<JWindow>() {

      public JWindow get() {
        try {
          JWindow w = new JWindow();
          w.add(wrap(c));
          return w;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JWindow w;\r\n    w.add(wrap(c));\r\n    ret w;";
      }
    });
  }

  static public int pixelCount(BufferedImage img) {
    return img == null ? 0 : img.getWidth() * img.getHeight();
  }

  static public <A> F0<A> if0ToF0(IF0<A> f) {
    return f == null ? null : new F0<A>() {

      public A get() {
        try {
          return f.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return f.get();";
      }
    };
  }

  static public <A, B> A pairA(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public void autoVMExit() {
    call(getJavaX(), "autoVMExit");
  }

  static public File appendToBaseName(File f, String s) {
    return appendToFileNameBeforeExtension(f, s);
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public <A> Chain<A> dropFirst(Chain<A> c) {
    return c == null ? null : c.next;
  }

  static volatile public PersistableThrowable _handleException_lastException;

  static public List _handleException_onException = synchroList(ll((IVF1<Throwable>) (__1 -> printStackTrace2(__1))));

  static public boolean _handleException_showThreadCancellations = false;

  static public void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException) {
      if (_handleException_showThreadCancellations)
        System.out.println(getStackTrace_noRecord(e2));
      return;
    }
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      try {
        printStackTrace2(e3);
      } catch (Throwable e4) {
        System.out.println(getStackTrace(e3));
        System.out.println(getStackTrace(e4));
      }
    }
  }

  static public <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  static public <A> A waitForVarToBeNotNull(Var<A> v) {
    try {
      synchronized (v) {
        while (!v.has()) v.wait();
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String nClasses(long n) {
    return n2(n, "class", "classes");
  }

  static public String nClasses(Collection l) {
    return nClasses(l(l));
  }

  static public String nClasses(Map map) {
    return nClasses(l(map));
  }

  static public String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  static public int mod(int n, int m) {
    return (n % m + m) % m;
  }

  static public long mod(long n, long m) {
    return (n % m + m) % m;
  }

  static public BigInteger mod(BigInteger n, int m) {
    return n.mod(bigint(m));
  }

  static public double mod(double n, double m) {
    return (n % m + m) % m;
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public <A> A lookupInterface(Class<A> intrface, Object o) {
    return lookupDynamicInterface(intrface, o);
  }

  static public <A> A lookupInterface(Object o, Class<A> intrface) {
    return lookupDynamicInterface(o, intrface);
  }

  static public String inputStreamToString(InputStream in) {
    return utf8streamToString(in);
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public String squareBracketed(String s) {
    return "[" + s + "]";
  }

  static public JFrame makeUndecoratedFrame(String title, Object content) {
    return swing(() -> {
      JFrame frame = new JFrame(title);
      frame.setUndecorated(true);
      Component wrapped = wrap(content);
      if (wrapped != null)
        frame.getContentPane().add(wrapped);
      frame.setBounds(defaultNewFrameBounds());
      return frame;
    });
  }

  static public JPanel centerAndEastWithMarginInbetween(Component c, final Component e) {
    return centerAndEast(c, withLeftMargin(e));
  }

  static public int seconds() {
    return seconds(java.util.Calendar.getInstance());
  }

  static public int seconds(java.util.Calendar c) {
    return c.get(java.util.Calendar.SECOND);
  }

  static public boolean regexpFinds(String pat, String s) {
    return regexp(pat, s).find();
  }

  static public boolean regexpFinds(Pattern pat, String s) {
    return regexp(pat, s).find();
  }

  static public boolean isLocalSnippet(String snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public boolean isLocalSnippet(long snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  static public boolean useDummyMainClasses() {
    return true;
  }

  static public boolean longIsInt(long l) {
    return l == (int) l;
  }

  static public byte[] subByteArray(byte[] b, int start) {
    return subByteArray(b, start, l(b));
  }

  static public byte[] subByteArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subByteArray(byte[] b, IntRange r) {
    return r == null ? null : subByteArray(b, r.start, r.end);
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        var __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      var __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public RuntimeException quickFail() {
    throw new QuickException("fail");
  }

  static public RuntimeException quickFail(Throwable e) {
    throw asQuickException(e);
  }

  static public RuntimeException quickFail(Object msg) {
    throw new QuickException(String.valueOf(msg));
  }

  static public RuntimeException quickFail(String msg) {
    throw new QuickException(unnull(msg));
  }

  static public RuntimeException quickFail(String msg, Throwable innerException) {
    throw new QuickException(msg, innerException);
  }

  static public boolean isJavaXClassLoader(ClassLoader cl) {
    return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public double nanosToSeconds(double nanos) {
    return nanoSecondsToSeconds(nanos);
  }

  static public boolean anyFileWithExtensionInDir(File dir, String ext) {
    return nempty(filesWithExtension(ext, findAllFiles_noDirs(dir)));
  }

  static public String readerToString(Reader r) {
    try {
      if (r == null)
        return null;
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void drawIntMatrix(BufferedImage g, Matrix<Integer> m, int x, int y) {
    drawIntMatrix(graphics(g), m, x, y);
  }

  static public void drawIntMatrix(Graphics2D g, Matrix<Integer> m, int x, int y) {
    if (g == null || m == null)
      return;
    drawImage(g, matrixToImage(m), x, y);
  }

  static public void dm_toggleAlwaysOnTop() {
    if (dm_moduleIsPoppedOut()) {
      boolean aot = !isTrue(dm_getFlag("ALWAYSONTOPWHENPOPPEDOUT"));
      dm_setFlag("ALWAYSONTOPWHENPOPPEDOUT", aot);
      alwaysOnTop(dm_windowIfSingleModule(dm_current_generic()), aot);
    }
  }

  static public String joinNemptiesWithDot(Object... strings) {
    return joinNempties(".", strings);
  }

  static public String joinNemptiesWithDot(Iterable strings) {
    return joinNempties(".", strings);
  }

  static public Map<String, String> humanizeFormLabel_replacements = litmap("id", "ID", "md5", "MD5");

  static public String humanizeFormLabel(String s) {
    if (!isIdentifier(s))
      return s;
    return firstToUpper(joinWithSpace(replaceElementsUsingMap(splitCamelCase(s), humanizeFormLabel_replacements)).replace("I D", "ID"));
  }

  static public java.util.Timer doLater_daemon(long delay, final Object r) {
    final java.util.Timer timer = new java.util.Timer(true);
    timer.schedule(timerTask(r, timer), delay);
    return timer;
  }

  static public java.util.Timer doLater_daemon(double delaySeconds, final Object r) {
    return doLater_daemon(toMS(delaySeconds), r);
  }

  static public Set<String> hotwire_classesToShare = synchroSet();

  static public Set<String> hotwire_classesToShare() {
    return hotwire_classesToShare;
  }

  static public GrabbableIntPixels grabbableIntPixels_fastOrSlow(BufferedImage image) {
    try {
      try {
        GrabbableIntPixels gp = grabbableIntPixels(image);
        if (gp != null)
          return gp;
      } catch (Throwable __e) {
        pcallFail(__e);
      }
      int w = image.getWidth(), h = image.getHeight();
      int[] data = new int[w * h];
      PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, w, h, data, 0, w);
      if (!pixelGrabber.grabPixels())
        throw fail("Could not grab pixels");
      return new GrabbableIntPixels(data, w, h, 0, w);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int countPred(Iterable c, Object pred) {
    return nfilter(c, pred);
  }

  static public int countPred(Object pred, Iterable c) {
    return nfilter(pred, c);
  }

  static public <A> int countPred(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(c, pred);
  }

  static public BWImage scaleDownUsingIntegralImageBW(int w, BWIntegralImage img) {
    return scaleDownUsingIntegralImageBW(img, w);
  }

  static public BWImage scaleDownUsingIntegralImageBW(BWIntegralImage img, int w) {
    return scaleDownUsingIntegralImageBW(img, w, iround(w * img.h / (double) img.w));
  }

  static public BWImage scaleDownUsingIntegralImageBW(BWIntegralImage img, int w, int h) {
    int w1 = img.w, h1 = img.h;
    BWImage out = new BWImage(w, h);
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int area = (x2 - x1) * (y2 - y1);
      int pixel = bwIntegralImage_sumRect(img, x1, y1, x2, y2) / area;
      out.setByte(x, y, (byte) pixel);
    }
    return out;
  }

  static public BWImage scaleDownUsingIntegralImageBW(IBWIntegralImage img, int w) {
    return scaleDownUsingIntegralImageBW(img, w, iround(w * img.getHeight() / (double) img.getWidth()));
  }

  static public BWImage scaleDownUsingIntegralImageBW(IBWIntegralImage img, int w, int h) {
    int w1 = img.getWidth(), h1 = img.getHeight();
    BWImage out = new BWImage(w, h);
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int area = (x2 - x1) * (y2 - y1);
      int pixel = bwIntegralImage_sumRect(img, x1, y1, x2, y2) / area;
      out.setByte(x, y, (byte) pixel);
    }
    return out;
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public RuntimeException augmentException(Throwable e, Object... info) {
    return new Fail(e, info);
  }

  static public String dummyMainClassName(String progID) {
    return "m" + psI(progID);
  }

  static public void printExceptionShort(Throwable e) {
    printExceptionShort("", e);
  }

  static public void printExceptionShort(String prefix, Throwable e) {
    print(prefix, exceptionToStringShort(e));
  }

  static public <A> void printWithMSTime(A a) {
    printWithMSTime("", a);
  }

  static public <A> void printWithMSTime(String prefix, A a) {
    print(hmsWithColonsAndMS() + ": " + combinePrintParameters(prefix, a));
  }

  static public void close_pcall(AutoCloseable c) {
    if (c != null) {
      try {
        c.close();
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
  }

  static public Component wrapForSmartAdd(Object o) {
    if (o == null)
      return jpanel();
    if (o instanceof String)
      return jlabel((String) o);
    return wrap(o);
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc) {
    return parseStdFunctionsList(snippetSrc, new LinkedHashMap());
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc, Map<String, String> map) {
    List<String> tok = javaTok(snippetSrc);
    int i = findCodeTokens(tok, "standardFunctions", "=", "litlist", "(");
    int opening = i + 6;
    int closing = indexOf(tok, ")", opening) - 1;
    for (i = opening + 2; i < closing; i += 4) {
      String[] f = unquote(tok.get(i)).split("/");
      map.put(f[1], f[0]);
    }
    return map;
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public String autoFrameTitle_value;

  static public String autoFrameTitle() {
    return autoFrameTitle_value != null ? autoFrameTitle_value : getProgramTitle();
  }

  static public void autoFrameTitle(Component c) {
    setFrameTitle(getFrame(c), autoFrameTitle());
  }

  static public JPanel westCenterAndEast(Component w, Component c, Component e) {
    JPanel panel = new JPanel(new BorderLayout());
    panel.add(BorderLayout.WEST, wrap(w));
    panel.add(BorderLayout.CENTER, wrap(c));
    panel.add(BorderLayout.EAST, wrap(e));
    return panel;
  }

  static public boolean hasLock(Lock lock) {
    return ((ReentrantLock) lock).isHeldByCurrentThread();
  }

  static public void scaffoldCalled(Object obj, Object function, Object... args) {
    printShortenedFunctionCall(200, (obj == null ? "" : shorten(20, str(obj)) + " :: ") + function, args);
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public boolean trayIcon_imageAutoSize = true;

  static public TrayIcon installTrayIcon(String imageID, String tooltip) {
    return installTrayIcon(imageID, tooltip, null);
  }

  static public TrayIcon installTrayIcon(String imageID, String tooltip, Object... menuItems) {
    try {
      if (!isSnippetID(imageID) && isSnippetID(tooltip)) {
        String s = tooltip;
        tooltip = imageID;
        imageID = s;
      }
      Image image = loadImage2(imageID);
      return installTrayIcon(image, tooltip, menuItems);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TrayIcon installTrayIcon(final Image image, final String tooltip, final Object... _menuItems) {
    try {
      return swing(new F0<TrayIcon>() {

        public TrayIcon get() {
          try {
            Runnable leftClick = null;
            Object[] menuItems = params_unpackList(_menuItems);
            if (l(menuItems) > 0 && menuItems[0] instanceof Runnable) {
              leftClick = (Runnable) menuItems[0];
              menuItems = dropFirst(menuItems);
            }
            PopupMenu menu = makePopupMenu(menuItems);
            TrayIcon trayIcon = new TrayIcon(image, tooltip, menu);
            trayIcon.setImageAutoSize(trayIcon_imageAutoSize);
            if (leftClick != null) {
              final Runnable _leftClick = leftClick;
              onLeftClick(trayIcon, _leftClick);
            }
            SystemTray.getSystemTray().add(trayIcon);
            return trayIcon;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Runnable leftClick = null;\r\n    O[] menuItems = params_unpackList(_menuItems)...";
        }
      });
    } catch (Throwable __e) {
      return null;
    }
  }

  static public BufferedImage shootScreen2() {
    return shootScreen2(screenRectangle());
  }

  static public BufferedImage shootScreen2(Rectangle area) {
    try {
      ping();
      return new Robot().createScreenCapture(area);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage shootScreen2(Rect area) {
    return shootScreen2(area.getRectangle());
  }

  static public BufferedImage shootScreen2(int x, int y, int w, int h) {
    return shootScreen2(new Rectangle(x, y, w, h));
  }

  static public String toStringWithClass(Object o) {
    return o == null ? null : className(o) + " - " + o;
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    params = unrollParams(params);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (eqOneOf(val, html_valueLessParam(), true))
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public String dropNumberPrefix(String s) {
    return dropFirst(s, indexOfNonDigit(s));
  }

  static public <A> F0<A> fConst(A a) {
    return f0_const(a);
  }

  static public AutoCloseable tempSetField(Object o, String field, Object value) {
    final Object oldValue = get(o, field);
    set(o, field, value);
    return () -> set(o, field, oldValue);
  }

  static public <A> AutoCloseable tempSetField(ISetAndGet<A> gs, A value) {
    if (gs == null)
      return null;
    A oldValue = gs.get();
    gs.set(value);
    return () -> gs.set(oldValue);
  }

  static public <A> AutoCloseable tempSetField(A value, ISetAndGet<A> gs) {
    return tempSetField(gs, value);
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A extends JCheckBox> A bindCheckBoxToLiveValue(A cb, SimpleLiveValue<Boolean> lv) {
    bindChangeListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          setChecked(cb, isTrue(lv.get()));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n        print(\"bindCheckBoxToLiveValue: ...";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          lv.set(isChecked(cb));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n        print(\"bindCheckBoxToLiveValue: ...";
      }
    });
    return cb;
  }

  static public <A extends JCheckBox> A bindCheckBoxToLiveValue(A cb, IVarWithNotify<Boolean> lv) {
    bindChangeListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          setChecked(cb, isTrue(lv.get()));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n        print(\"bindCheckBoxToLiveValue: ...";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          lv.set(isChecked(cb));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n        print(\"bindCheckBoxToLiveValue: ...";
      }
    });
    return cb;
  }

  static public String fsIOpt(String s) {
    return formatSnippetIDOpt(s);
  }

  static public int deleteAllFilesInDirectory_minPathLength = 10;

  static public void deleteAllFilesInDirectory(File dir) {
    deleteAllFilesInDirectory(dir, false, false);
  }

  static public void deleteAllFilesInDirectory(File dir, boolean verbose, boolean testRun) {
    dir = getCanonicalFile(dir);
    assertTrue(f2s(dir), l(f2s(dir)) >= deleteAllFilesInDirectory_minPathLength);
    File[] files = dir.listFiles();
    if (files == null)
      return;
    for (File f : files) {
      if (!isSymLink(f) && f.isDirectory())
        deleteDirectory(f, verbose, testRun);
      else {
        if (verbose)
          print((testRun ? "Would delete " : "Deleting ") + f.getAbsolutePath());
        if (!testRun)
          f.delete();
      }
    }
  }

  static public void copyImagePart(BufferedImage src, int srcx, int srcy, BufferedImage dest, int destx, int desty, int w, int h) {
    Graphics2D g = dest.createGraphics();
    BufferedImage sub = src.getSubimage(srcx, srcy, w, h);
    g.drawImage(sub, destx, desty, null);
    g.dispose();
  }

  static public String appendWithNewLine(String a, String b) {
    if (empty(b))
      return a;
    if (empty(a))
      return b;
    return addSuffix(a, "\n") + b;
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((nempty(msg) ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public void assertEqualsVerbose(Scorer scorer, Object x, Object y) {
    assertEqualsVerbose(scorer, "", x, y);
  }

  static public void assertEqualsVerbose(Scorer scorer, String msg, Object x, Object y) {
    if (scorer == null) {
      assertEqualsVerbose(x, y);
      return;
    }
    if (!eq(x, y)) {
      print(appendColonIfNempty(msg) + y + " != " + x);
      scorer.add(false);
    } else {
      print("OK: " + appendColonIfNempty(msg) + x);
      scorer.add(true);
    }
  }

  static public boolean isOnPATH(String cmd) {
    return findCmdOnPATH(cmd) != null;
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public <A> Set<A> syncLinkedHashSet() {
    return synchroLinkedHashSet();
  }

  static public Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  static public <A> int nfilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(pred, c);
  }

  static public <A> int nfilter(IF1<A, Boolean> pred, Iterable<A> c) {
    int n = 0;
    if (c != null)
      for (A o : c) if (pred.get(o))
        ++n;
    return n;
  }

  static public int nfilter(Iterable c, Object pred) {
    int n = 0;
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        ++n;
    return n;
  }

  static public int nfilter(Object pred, Iterable c) {
    return nfilter(c, pred);
  }

  static public List<File> sortFilesByName(List<File> l) {
    sort(l, (a, b) -> stdcompare(a.getName(), b.getName()));
    return l;
  }

  static public double fracNonNeg(double d) {
    return frac_nonNeg(d);
  }

  static public String plusPrefixUnlessMinus(String s) {
    return startsWith(s, "-") ? s : "+" + s;
  }

  static public boolean tok_staticFunctionAlwaysReturnsVoid(List<String> tok, String name) {
    Set<String> types = tok_returnTypesOfStaticFunction_uncleaned(tok, name);
    if (empty(types))
      return false;
    for (String type : types) if (!containsOneOf(javaTokC(type), javaxVoidAliases()))
      return false;
    return true;
  }

  static public boolean isKnownVoidFunction_uncached(String name) {
    return standardFunctionAlwaysReturnsVoid_uncached(name);
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(() -> {
        for (Component c : unnullForIteration(b)) if (c != null)
          a.add(c);
      });
    }
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public <A extends JSpinner> A onChange(A spinner, Object r) {
    return onChange(spinner, toRunnable(r));
  }

  static public <A extends JSpinner> A onChange(A spinner, Runnable r) {
    if (r != null) {
      swing(() -> {
        spinner.addChangeListener(changeListener(r));
      });
    }
    return spinner;
  }

  static public <A extends AbstractButton> A onChange(A b, Runnable r) {
    {
      swing(() -> {
        b.addItemListener(itemListener(r));
      });
    }
    return b;
  }

  static public void onChange(JTextComponent tc, Runnable r) {
    onUpdate(tc, r);
  }

  static public <A extends JSlider> A onChange(A slider, Runnable r) {
    {
      swing(() -> {
        slider.addChangeListener(changeListener(r));
      });
    }
    return slider;
  }

  static public <A> JComboBox<A> onChange(JComboBox<A> cb, ChangeTriggerable r) {
    return onChange(cb, new ChangeTrigger(r));
  }

  static public <A> JComboBox<A> onChange(JComboBox<A> cb, Updateable r) {
    return onChange(cb, new UpdateTrigger(r));
  }

  static public <A> JComboBox<A> onChange(JComboBox<A> cb, IVF1<A> f) {
    if (f != null)
      addActionListener(cb, () -> f.get(getSelectedItem_typed(cb)));
    return cb;
  }

  static public JComboBox onChange(JComboBox cb, Runnable r) {
    if (isEditableComboBox(cb))
      onChange(textFieldFromComboBox(cb), r);
    else
      onSelectedItem(cb, runnableToIVF1(r));
    return cb;
  }

  static public <A extends JTabbedPane> A onChange(A tabs, Runnable r) {
    {
      swing(() -> {
        tabs.addChangeListener(changeListener(r));
      });
    }
    return tabs;
  }

  static public <A extends JColorChooser> A onChange(Runnable r, A cc) {
    if (cc != null && r != null) {
      swing(() -> {
        cc.getSelectionModel().addChangeListener(changeListener(r));
      });
    }
    return cc;
  }

  static public <A extends IHasChangeListeners> A onChange(A a, ChangeTriggerable b) {
    if (a != null && b != null)
      a.onChange(new ChangeTrigger(b));
    return a;
  }

  static public <A extends IHasChangeListeners> A onChange(A a, Updateable b) {
    if (a != null && b != null)
      a.onChange(new UpdateTrigger(b));
    return a;
  }

  static public <A extends IHasChangeListeners> A onChange(A a, Runnable r) {
    if (a != null && r != null)
      a.onChange(r);
    return a;
  }

  static public List<String> splitCamelCase(String s) {
    return ai_splitCamelCase(s);
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public String appendColonIfNempty(String s) {
    return empty(s) ? "" : s + ": ";
  }

  static public PingSource pingSource() {
    return pingSource_tl().get();
  }

  static public PingSource pingSource(Thread thread) {
    return pingSource_tl().get(thread);
  }

  static public Font loadFont(String snippetID) {
    try {
      return loadFont(snippetID, 12f);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(String snippetID, float fontSize) {
    return loadFont(loadLibrary(snippetID), fontSize);
  }

  static public Font loadFont(File f, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, f).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class<?> hotwireSharingLibraries_silently(String progID) {
    AutoCloseable __1 = temp_loadPage_silent();
    try {
      return hotwireSharingLibraries(progID);
    } finally {
      _close(__1);
    }
  }

  static public String loadTextFileFromZipFile(File inZip, String fileName) {
    try {
      if (!fileExists(inZip))
        return null;
      try {
        ZipFile zip = new ZipFile(inZip);
        try {
          return loadTextFileFromZipFile(zip, fileName);
        } finally {
          _close(zip);
        }
      } catch (Throwable e) {
        throw fail(f2s(inZip), e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadTextFileFromZipFile(ZipFile zip, String fileName) {
    try {
      ZipEntry entry = zip.getEntry(fileName);
      if (entry == null)
        return null;
      InputStream fin = zip.getInputStream(entry);
      try {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        copyStream(fin, baos);
        return fromUTF8(baos.toByteArray());
      } finally {
        _close(fin);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void dm_popInModule(Object module) {
    dm_callOS("stefansOS_popInModule", dm_getStem(module));
  }

  static public void dm_popInModule() {
    dm_popInModule(dm_current_generic_mandatory());
  }

  static public String dropLeadingDots(String s) {
    int i = 0;
    while (charAt(s, i) == '.') ++i;
    return dropFirst(s, i);
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public String loadGZTextFile(File file) {
    try {
      if (!file.isFile())
        return null;
      ping();
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      InputStream fis = new FileInputStream(file);
      try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        byte[] buffer = new byte[1024];
        int len;
        while ((len = gis.read(buffer)) != -1) baos.write(buffer, 0, len);
        baos.close();
        return fromUtf8(baos.toByteArray());
      } finally {
        _close(fis);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] header = bytesFromHex("504B0304");

  static public boolean isNonEmptySingleZip_byMagicHeader(byte[] data) {
    return byteArrayStartsWith(data, header);
  }

  static public boolean isNonEmptySingleZip_byMagicHeader(File f) {
    return isNonEmptySingleZip_byMagicHeader(loadBeginningOfBinaryFile(f, l(header)));
  }

  static public JComponent dm_vis(Object module) {
    return dm_getVisualization(module);
  }

  static public JComponent dm_vis() {
    return dm_getVisualization();
  }

  static public <A> void probabilisticForEach(IProbabilisticScheduler scheduler, double pStart, double pEnd, Collection<A> l, IVF1<A> f) {
    if (scheduler == null || f == null)
      return;
    probabilisticForEach(scheduler, pStart, pEnd, iterator(l), 0, l(l), 1.0, f);
  }

  static public <A> void probabilisticForEach(IProbabilisticScheduler scheduler, double pStart, double pEnd, Iterator<A> it, int i, int n, double myProb, IVF1<A> f) {
    assertTrue(pEnd <= pStart);
    if (scheduler == null || f == null || !it.hasNext())
      return;
    A a = it.next();
    double p = blend(pStart, pEnd, doubleRatio(i, n - 1));
    scheduler.at(new Runnable() {

      public void run() {
        try {
          f.get(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return formatFunctionCall(f, a);
      }
    });
    scheduler.atRelative(doubleRatio(p, myProb), () -> probabilisticForEach(scheduler, pStart, pEnd, it, i + 1, n, p, f));
  }

  static public String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  static public double frac_nonNeg(double d) {
    return mod(d, 1);
  }

  static public boolean isInQ(Q q) {
    return q != null && isCurrentThread(q.rst.thread);
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName) {
    return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
    return takeFirst(80 - 33, fileNameEncode(fullName)) + " - " + md5;
  }

  static public boolean isMenuSeparatorIndicator(Object o) {
    return eqOneOf(o, "***", "---", "===", "");
  }

  static public <A extends JComponent> A applyMargin(int top, int left, int bottom, int right, A c) {
    return addMargin(top, left, bottom, right, c);
  }

  static public <A extends JComponent> A applyMargin(int w, A c) {
    return addMargin(w, c);
  }

  static public BufferedImage intMatrixToBufferedImage(Matrix<Integer> m) {
    if (m == null)
      return null;
    int w = m.getWidth(), h = m.getHeight();
    int[] pixels = matrixToIntArray(m);
    return newBufferedImage(w, h, pixels);
  }

  static public int withTopMargin_defaultWidth = 6;

  static public JPanel withTopMargin(Component c) {
    return withTopMargin(withTopMargin_defaultWidth, c);
  }

  static public JPanel withTopMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public Boolean hasGlobalOption(String option) {
    String question = print(option + "?");
    return askTripleBool(question);
  }

  static public void dm_inQ(Runnable r) {
    dm_q().add(r);
  }

  static public void dm_inQ(DynModule mod, Runnable r) {
    dm_q(mod, r);
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public <A extends JLabel> A bindJLabelToLiveValue(final A label, final LiveValue lv) {
    bindLiveValueListenerToComponent(label, lv, new Runnable() {

      public void run() {
        try {
          setText(label, strOrNull(lv.get()));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setText(label, strOrNull(lv!))";
      }
    });
    return label;
  }

  static public RuntimeException error() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException error(String msg) {
    throw new RuntimeException(msg);
  }

  static public <A extends JComponent> A setBackground(final Color color, final A a) {
    if (a != null) {
      swing(() -> {
        a.setBackground(color);
      });
    }
    return a;
  }

  static public <A extends JComponent> A setBackground(A a, Color color) {
    return setBackground(color, a);
  }

  static public Boolean dm_getFlag(String flagName) {
    Object mod = dm_current_generic();
    Object stem = dm_stem(mod);
    Integer flagCode = (Integer) (getOpt(flagName, stem));
    return flagCode == null ? null : (Boolean) call(stem, "hasFlag", flagCode);
  }

  static public String renderVars(Object... params) {
    return renderVars_str(params);
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static public Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  static public boolean isCurrentThread(Thread t) {
    return t != null && t == currentThread();
  }

  static public String dropPrefixTrim(String prefix, String s) {
    return trim(dropPrefix(prefix, s));
  }

  static public double elapsedSeconds(long time) {
    return toSeconds(sysNow() - time);
  }

  static public double elapsedSeconds(Timestamp ts) {
    return ts == null ? Double.NaN : toSeconds(now() - ts.date);
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public Class<?> hotwire(String src) {
    return hotwire(src, __1 -> mainClassNameForClassLoader(__1));
  }

  static public Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      return hotwire_overInternalBot(src, calculateMainClass);
    }
  }

  static public List wrapPrimitiveArrayAsImmutableList(Object array) {
    int n = Array.getLength(array);
    return new RandomAccessAbstractList() {

      public int size() {
        return n;
      }

      public Object get(int i) {
        return Array.get(array, i);
      }
    };
  }

  static public <A> List<List<A>> matrixOfMatricesToListOfLists(Matrix<Matrix<A>> mm) {
    return map(__93 -> matrixToList(__93), matrixToList(mm));
  }

  static public Object metaGet(IMeta o, Object key) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(Object o, Object key) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(String key, IMeta o) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(String key, Object o) {
    return metaMapGet(o, key);
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public <A> A heldInstance(Class<A> c) {
    List<Object> l = holdInstance_l.get();
    for (int i = l(l) - 1; i >= 0; i--) {
      Object o = l.get(i);
      if (isInstanceOf(o, c))
        return (A) o;
    }
    throw fail("No instance of " + className(c) + " held");
  }

  static public Class veryQuickJava(CharSequence mainJava) {
    return veryQuickJava3(str(mainJava));
  }

  static public String firstJavaToken(String s) {
    if (s == null)
      return null;
    int l = s.length();
    int j = 0;
    char c, d;
    while (j < l) {
      c = s.charAt(j);
      d = j + 1 >= l ? '\0' : s.charAt(j + 1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
        j = Math.min(j + 2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    if (j >= l)
      return null;
    int i = j;
    c = s.charAt(i);
    d = i + 1 >= l ? '\0' : s.charAt(i + 1);
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j + 1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L')
        ++j;
    } else if (c == '[' && d == '[') {
      do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
      j = Math.min(j + 2, l);
    } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
      do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
      j = Math.min(j + 3, l);
    } else
      ++j;
    return quickSubstring(s, i, j);
  }

  static public String fromUTF8(byte[] bytes) {
    return fromUtf8(bytes);
  }

  static public <A> List<A> listCreateAndAdd(List<A> l, A a) {
    return addDyn(l, a);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Iterable<A> c, final F1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Iterable<A> c, IF1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IterableIterator<A> c, IF1<A, C> makeInnerIterator) {
    return nestedIterator((Iterator<A>) c, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Iterator<A> it1, IF1<A, C> makeInnerIterator) {
    if (it1 == null || !it1.hasNext())
      return emptyItIt();
    return iff(new F0() {

      public A a;

      public Iterator<B> innerIterator;

      {
        nextOuter();
      }

      public void nextOuter() {
        a = it1.next();
        innerIterator = makeInnerIterator.get(a);
      }

      public Object get() {
        while (true) {
          ping();
          if (innerIterator != null && innerIterator.hasNext())
            return innerIterator.next();
          if (!it1.hasNext())
            return endMarker();
          nextOuter();
        }
      }
    });
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(final Iterator<A> it1, F1<A, C> makeInnerIterator) {
    if (it1 == null || !it1.hasNext())
      return emptyItIt();
    return iff(new F0() {

      public A a;

      public Iterator<B> innerIterator;

      {
        nextOuter();
      }

      public void nextOuter() {
        a = it1.next();
        innerIterator = makeInnerIterator.get(a);
      }

      public Object get() {
        while (true) {
          ping();
          if (innerIterator != null && innerIterator.hasNext())
            return innerIterator.next();
          if (!it1.hasNext())
            return endMarker();
          nextOuter();
        }
      }
    });
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Iterator<A> it1) {
    return nestedIterator(it1, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Collection<A> l) {
    return nestedIterator(l, makeInnerIterator);
  }

  static public String tok_packageName(List<String> tok) {
    int i = jfind(tok, "package");
    if (i < 0)
      return "";
    i += 2;
    int j = jfind(tok, i, ";");
    if (j < 0)
      return "";
    return join(codeTokensOnly(subList(tok, i - 1, j)));
  }

  static public String tok_packageName(String src) {
    Producer<String> p = javaTokC_producer(src);
    String t = p.next();
    if (!eq(t, "package"))
      return "";
    StringBuilder buf = new StringBuilder();
    while (!eqOneOf(t = p.next(), null, ";")) buf.append(t);
    return str(buf);
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public double twoPi() {
    return Math.PI * 2;
  }

  static public int defaultMargin() {
    return withMargin_defaultWidth;
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public String htmldecode(final String input) {
    if (input == null)
      return null;
    final int MIN_ESCAPE = 2;
    final int MAX_ESCAPE = 6;
    StringWriter writer = null;
    int len = input.length();
    int i = 1;
    int st = 0;
    while (true) {
      while (i < len && input.charAt(i - 1) != '&') i++;
      if (i >= len)
        break;
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';') j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
        i++;
        continue;
      }
      if (input.charAt(i) == '#') {
        int k = i + 1;
        int radix = 10;
        final char firstChar = input.charAt(k);
        if (firstChar == 'x' || firstChar == 'X') {
          k++;
          radix = 16;
        }
        try {
          int entityValue = Integer.parseInt(input.substring(k, j), radix);
          if (writer == null)
            writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));
          if (entityValue > 0xFFFF) {
            final char[] chrs = Character.toChars(entityValue);
            writer.write(chrs[0]);
            writer.write(chrs[1]);
          } else {
            writer.write(entityValue);
          }
        } catch (NumberFormatException ex) {
          i++;
          continue;
        }
      } else {
        CharSequence value = htmldecode_lookupMap().get(input.substring(i, j));
        if (value == null) {
          i++;
          continue;
        }
        if (writer == null)
          writer = new StringWriter(input.length());
        writer.append(input.substring(st, i - 1));
        writer.append(value);
      }
      st = j + 1;
      i = st;
    }
    if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
    }
    return input;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_cache;

  static public HashMap<String, CharSequence> htmldecode_lookupMap() {
    if (htmldecode_lookupMap_cache == null)
      htmldecode_lookupMap_cache = htmldecode_lookupMap_load();
    return htmldecode_lookupMap_cache;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_load() {
    var map = new HashMap<String, CharSequence>();
    for (CharSequence[] seq : htmldecode_escapes()) map.put(seq[1].toString(), seq[0]);
    return map;
  }

  static public boolean loadBufferedImageFixingGIFs_debug = false;

  static public ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

  static public Image loadBufferedImageFixingGIFs(File file) {
    try {
      if (!file.exists())
        return null;
      if (!isGIF(file))
        return ImageIO.read(file);
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": checking gif");
      ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
      reader.setInput(ImageIO.createImageInputStream(file));
      int numImages = reader.getNumImages(true);
      IIOMetadata imageMetaData = reader.getImageMetadata(0);
      String metaFormatName = imageMetaData.getNativeMetadataFormatName();
      boolean foundBug = false;
      for (int i = 0; i < numImages && !foundBug; i++) {
        IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
        int nNodes = root.getLength();
        for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
            String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
            if (Integer.parseInt(delay) == 0) {
              foundBug = true;
            }
            break;
          }
        }
      }
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
      Image image;
      if (!foundBug) {
        image = Toolkit.getDefaultToolkit().createImage(f2s(file));
      } else {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        {
          ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
          try {
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; i++) {
              BufferedImage frameIn = reader.read(i);
              IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
              int nNodes = root.getLength();
              for (int j = 0; j < nNodes; j++) {
                org.w3c.dom.Node node = root.item(j);
                if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
                  if (Integer.parseInt(delay) == 0) {
                    ((IIOMetadataNode) node).setAttribute("delayTime", "10");
                  }
                  break;
                }
              }
              IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
              metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
              IIOImage frameOut = new IIOImage(frameIn, null, metadata);
              writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
          } finally {
            _close(ios);
          }
        }
        byte[] data = baoStream.toByteArray();
        setVar(loadBufferedImageFixingGIFs_output.get(), data);
        if (loadBufferedImageFixingGIFs_debug)
          print("Data size: " + l(data));
        image = Toolkit.getDefaultToolkit().createImage(data);
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<TextImageAction> filesForNiceButtons(List<File> l, IVF1<File> action) {
    return map(l, f -> {
      var tia = textImageActionToolTip(f.getName(), isImageFile(f) ? "#1101250" : "#1101231", new Runnable() {

        public void run() {
          try {
            pcallF(action, f);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "pcallF(action, f)";
        }
      }, f2s(f) + " (" + toK(fileSize(f)) + " K)");
      tia.file = f;
      return tia;
    });
  }

  static public List<TextImageAction> filesForNiceButtons(List<File> l) {
    return filesForNiceButtons(l, f -> {
      {
        startThread(new Runnable() {

          public void run() {
            try {
              genericUI_openFile(f);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "genericUI_openFile(f);";
          }
        });
      }
    });
  }

  static public <A extends DynamicStack> A makeNiceButtons_usingStack(A stack, Object... params) {
    params = flattenArray2(params);
    for (int i = 0; i < l(params); ) {
      TextImageAction tia = null;
      if (params[i] instanceof TextImageAction) {
        tia = (TextImageAction) params[i];
        i++;
      } else {
        tia = new TextImageAction(str(get(params, i)), str(get(params, i + 1)), get(params, i + 2));
        i += 3;
      }
      final TextImageAction _tia = tia;
      Object action = tia.action;
      final String buttonDesc = action == null ? "actionless button " + sfu(_tia) : "button " + sfu(cloneWithoutField(_tia, "action")) + " with action " + trim(simpleSpaces(newLinesToSpaces(shorten(str(tia.action), 40))));
      action = new Runnable() {

        public void run() {
          try {
            appendToLocalMechLog("User actions", "User clicked on " + buttonDesc);
            callF(_tia.action);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "appendToLocalMechLog(\"User actions\", \"User clicked on \" + buttonDesc);\r\n     ...";
        }
      };
      JButton b = jImageAndTextButton(tia.imageID, tia.text, action);
      if (nempty(tia.toolTip))
        setToolTip(b, tia.toolTip);
      componentPopupMenu(b, tia.popupMenuMaker);
      resizeImageButtonToMax(b, niceButtons_maxImageSize());
      setVerticalTextPosition(JButton.TOP, setFontSize(15, makeBold(b)));
      setVerticalAlignment(JButton.TOP, b);
      setMargin(10, b);
      onMouseEnter(b, new Runnable() {

        public void run() {
          try {
            appendToLocalMechLog("Mouse hovers", "Mouse hovered over " + buttonDesc);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "appendToLocalMechLog(\"Mouse hovers\", \"Mouse hovered over \" + buttonDesc)";
        }
      });
      onMouseExit(b, new Runnable() {

        public void run() {
          try {
            appendToLocalMechLog("Mouse hovers", "Mouse no longer hovers over " + buttonDesc);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "appendToLocalMechLog(\"Mouse hovers\", \"Mouse no longer hovers over \" + buttonD...";
        }
      });
      metaSet(b, TextImageAction.class, tia);
      stack.addComponent(b);
    }
    return stack;
  }

  static public DynamicHStack makeNiceButtons(Object... params) {
    return makeNiceButtons_usingStack((DynamicHStack) dynamicHStack().spacing(20), params);
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    return unquoteSingleOrDoubleQuotes(s);
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public String aOrAn(String s) {
    return a(s);
  }

  static public AutoCloseable tempPingPrivileged() {
    return tempSetTL_noInit(pingSource_tl(), null);
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public String getTabTitle(JTabbedPane tabs, int idx) {
    return tabs == null || idx < 0 ? null : swing(() -> idx < tabs.getTabCount() ? tabs.getTitleAt(idx) : null);
  }

  static public JTable tablePopupMenuItemsThreaded_top(final JTable table, Object... params) {
    params = reverseParams(params);
    for (int i = 0; i + 1 < l(params); i += 2) {
      final Object action = params[i + 1];
      final Object threadInfo = _threadInfo();
      tablePopupMenuItem_top(table, str(params[i]), new VF1<Integer>() {

        public void get(final Integer row) {
          try {
            _threadInheritInfo(threadInfo);
            {
              startThread(new Runnable() {

                public void run() {
                  try {
                    try {
                      callF(action, row);
                    } catch (Throwable __e) {
                      messageBox(__e);
                    }
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "try {\r\n        callF(action, row);\r\n      } catch (Throwable __e) { messageBo...";
                }
              });
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "_threadInheritInfo(threadInfo);\r\n      thread-messagebox {\r\n        callF(act...";
        }
      });
    }
    return table;
  }

  static public Pair<JTabbedPane, Integer> enclosingTab(Component _c) {
    return swing(() -> {
      Component c = _c;
      while (c != null) {
        Container p = c.getParent();
        if (p instanceof JTabbedPane)
          return pair(((JTabbedPane) p), ((JTabbedPane) p).indexOfComponent(c));
        c = c.getParent();
      }
      return null;
    });
  }

  static public JLabel jImageLabel(Image img) {
    return swingNu(JLabel.class, imageIcon(img));
  }

  static public JLabel jImageLabel(javax.swing.Icon icon) {
    return swingNu(JLabel.class, icon);
  }

  static public JLabel jImageLabel(String imageID) {
    return jImageLabel(imageIcon(imageID));
  }

  static public JLabel jImageLabel(String text, String imageID) {
    final JLabel l = swingNu(JLabel.class, text, imageIcon(imageID), JLabel.CENTER);
    {
      swing(() -> {
        l.setVerticalTextPosition(SwingConstants.BOTTOM);
        l.setHorizontalTextPosition(SwingConstants.CENTER);
      });
    }
    return l;
  }

  static public RuntimeException unimplemented() {
    throw fail("TODO");
  }

  static public RuntimeException unimplemented(String msg) {
    throw fail("TODO: " + msg);
  }

  static public RuntimeException unimplemented(Object obj) {
    throw fail("TODO: implement method in " + className(obj));
  }

  static public String appendParamsToURL(String url, Map params) {
    return appendQueryToURL(url, params);
  }

  static public String appendParamsToURL(String url, Object... data) {
    return appendQueryToURL(url, data);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public Collection<Concept> findConceptsWhere(String c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFields(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConcepts(concepts.list(c), params);
  }

  static public Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
    return filterConcepts(concepts.list(c), params);
  }

  static public <A> A printStackTrace_gen(A e) {
    if (e instanceof Throwable)
      printStackTrace((Throwable) e);
    else
      print(e);
    return e;
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    if (e != null)
      print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public Class veryQuickJava_finish_specialMainClass(String mainClassName, String src) {
    return veryQuickJava_finish_specialMainClass(mainClassName, src, null);
  }

  static public Class veryQuickJava_finish_specialMainClass(String mainClassName, String src, List<String> libs) {
    src = findTranslators2(src, libs = cloneList(libs));
    File bytecode = javaCompile_overInternalBot(src, join(" ", libs));
    return hotwireCoreSpecialMainClass(mainClassName, concatLists(ll(bytecode), loadLibraries(libs)));
  }

  static public StefansOS_ConnectToServer snippetUpdateConnector(Object... __) {
    boolean verbose = boolPar("verbose", __);
    StefansOS_ConnectToServer connector = new StefansOS_ConnectToServer();
    connector.onLine = new VF1<String>() {

      public void get(String line) {
        try {
          Matches m = new Matches();
          if (startsWith(line, "snippetUpdates:", m)) {
            if (verbose)
              print(line);
            String msg = m.rest();
            vmBus_send("snippetUpdate", safeUnstruct(msg));
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new Matches m;\r\n    if (startsWith(line, \"snippetUpdates:\", m)) {\r\n      if (...";
      }
    };
    connector.startWithSubs("snippetUpdates");
    return connector;
  }

  static public JLabel jImage_scaledToHeight(String imageID, int height) {
    return jImage_scaledToHeight(imageID, height, null);
  }

  static public JLabel jImage_scaledToHeight(String imageID, int height, String toolTip) {
    return setToolTip(toolTip, jImage(resizeImageToHeight_bilinear(loadImage2(imageID), height)));
  }

  static public JLabel jImage_scaledToHeight(int height, String imageID) {
    return jImage_scaledToHeight(height, imageID, null);
  }

  static public JLabel jImage_scaledToHeight(int height, String imageID, String toolTip) {
    return jImage_scaledToHeight(imageID, height, toolTip);
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public AutoCloseable tempDBLock(Concepts concepts) {
    return tempLock(concepts.lock);
  }

  static public AutoCloseable tempDBLock() {
    return tempDBLock(db_mainConcepts());
  }

  static public <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
    return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
  }

  static public String nLabels(long n) {
    return n2(n, "label");
  }

  static public String nLabels(Collection l) {
    return nLabels(l(l));
  }

  static public String nLabels(Map map) {
    return nLabels(l(map));
  }

  static public JComboBox jcombobox(final String... items) {
    return swing(new F0<JComboBox>() {

      public JComboBox get() {
        try {
          return new JComboBox(items);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return new JComboBox(items);";
      }
    });
  }

  static public JComboBox jcombobox(Collection<String> items) {
    return jcombobox(toStringArray(items));
  }

  static public JComboBox jcombobox(Collection<String> items, String selectedItem) {
    return selectItem(selectedItem, jcombobox(items));
  }

  static public JComboBox jcombobox(String selectedItem, Collection<String> items) {
    return jcombobox(items, selectedItem);
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public List<JComponent> showForm_arrange1(List<List<JComponent>> l) {
    int minW = showForm_leftWidth(l);
    List<JComponent> out = new ArrayList();
    for (List<JComponent> row : l) out.add(westAndCenter(withRightMargin(showForm_gapBetweenColumns, jMinWidthAtLeast(minW, first(row))), second(row)));
    return out;
  }

  static public int selectedTableRow(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.getSelectedRow();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return t.getSelectedRow();";
      }
    });
  }

  static public class transpileOnServerWithErrorWindow_DaClass {

    public String snippetID;

    public JFastLogView_noWrap transpilationErrorBox;

    public Runnable onSuccess;

    public Object onError;

    public void go(boolean medium) {
      infoBox("Transpiling " + snippetID);
      final Pair<Boolean, String> p = transpileOnBestServer(snippetID, medium ? "medium" : "quick");
      swingLater(new Runnable() {

        public void run() {
          try {
            if (p.a) {
              infoBox("Transpiled OK!");
              hideWindow(transpilationErrorBox);
              transpilationErrorBox = null;
              callFInNewThread(onSuccess);
            } else {
              infoBox("Transpilation error. " + p.b);
              boolean first = transpilationErrorBox == null;
              transpilationErrorBox = maximizeFrame(scrollAllTheWayDown(showText_fast_noWrap(transpilationErrorBox, "Transpilation Error", p.b)));
              if (first) {
                setFrameIcon("#1101268", transpilationErrorBox);
                addButtonsToWindow(transpilationErrorBox, jbuttonWithDisable("Medium transpile", new Runnable() {

                  public void run() {
                    try {
                      go(true);
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "go(true)";
                  }
                }));
              }
              callFInNewThread(onError, p.b);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (p.a) {\r\n        infoBox(\"Transpiled OK!\");\r\n        hideWindow(transpilat...";
        }
      });
    }
  }

  static public void transpileOnServerWithErrorWindow(String snippetID, boolean medium, final Runnable onSuccess, Object... __) {
    nu(transpileOnServerWithErrorWindow_DaClass.class, paramsPlus(__, "snippetID", snippetID, "onSuccess", onSuccess)).go(medium);
  }

  static public <A, B> Map<A, B> immutableEmptyMap() {
    return Collections.emptyMap();
  }

  static public Rect preferredScreenBounds() {
    return screenBounds_safe(preferredScreen());
  }

  static public String fileSep() {
    return File.separator;
  }

  static public List<AbstractButton> buttonsInGroup(ButtonGroup g) {
    if (g == null)
      return ll();
    return asList(g.getElements());
  }

  static public List<Character> characters(final String s) {
    return stringAsCharacterList(s);
  }

  static public int withTopAndBottomMargin_defaultWidth = 6;

  static public JPanel withTopAndBottomMargin(Component c) {
    return withTopAndBottomMargin(withTopAndBottomMargin_defaultWidth, withTopAndBottomMargin_defaultWidth, c);
  }

  static public JPanel withTopAndBottomMargin(int topMargin, int bottomMargin, Component c) {
    return swing(() -> {
      JPanel p = new JPanel(new BorderLayout());
      int w = withTopAndBottomMargin_defaultWidth;
      p.setBorder(BorderFactory.createEmptyBorder(topMargin, 0, bottomMargin, 0));
      p.add(c);
      return p;
    });
  }

  static public SimpleDateFormat simpleDateFormat_UTC(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    return sdf;
  }

  static public void swingEvery(JComponent component, long delay, Object r) {
    installTimer(component, delay, r);
  }

  static public void swingEvery(JComponent component, long delay, long firstDelay, Object r) {
    installTimer(component, r, delay, firstDelay);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, Object r) {
    installTimer(frame, delay, r);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    installTimer(frame, delay, firstDelay, r);
  }

  static public void setComponentID(Component c, String id) {
    if (c != null)
      componentID_map.put(c, id);
  }

  static public String a(String noun) {
    if (eq(noun, ""))
      return "?";
    return ("aeiou".indexOf(noun.charAt(0)) >= 0 ? "an " : "a ") + noun;
  }

  static public String a(String contents, Object... params) {
    return hfulltag("a", contents, params);
  }

  static public Map synchronizedMap() {
    return synchroMap();
  }

  static public <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
    return synchroMap(map);
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public boolean oneIn(int n) {
    return random(n) == 0;
  }

  static public boolean oneIn(int n, Random random) {
    return random(random, n) == 0;
  }

  static public boolean oneIn(Random random, int n) {
    return oneIn(n, random);
  }

  static public BufferedImage resizeImageToHeight_bilinear(BufferedImage img, int newH) {
    return scaleImage_bilinear(doubleRatio(newH, img.getHeight()), img);
  }

  static public boolean haveMuricaPassword() {
    return nempty(muricaPassword());
  }

  static public double doubleRatio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public double doubleRatio(Seconds x, Seconds y) {
    return doubleRatio(x.get(), y.get());
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  static public int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  static public int l(Map m) {
    return m == null ? 0 : m.size();
  }

  static public int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public long l(File f) {
    return f == null ? 0 : f.length();
  }

  static public int l(IMultiSet ms) {
    return ms == null ? 0 : ms.size();
  }

  static public int l(IMultiMap mm) {
    return mm == null ? 0 : mm.size();
  }

  static public int l(IntRange r) {
    return r == null ? 0 : r.length();
  }

  static public long l(LongRange r) {
    return r == null ? 0 : r.length();
  }

  static public double l(DoubleRange r) {
    return r == null ? 0 : r.length();
  }

  static public int l(IntBuffer b) {
    return b == null ? 0 : b.size();
  }

  static public int l(LongBuffer b) {
    return b == null ? 0 : b.size();
  }

  static public int l(ShortBuffer b) {
    return b == null ? 0 : b.size();
  }

  static public int l(IntSize o) {
    return o == null ? 0 : o.size();
  }

  static public JPanel jRaisedCenteredSection(Component c) {
    return jRaisedCenteredSection("", c);
  }

  static public JPanel jRaisedCenteredSection(String title, Component c) {
    return jCenteredRaisedSection(title, c);
  }

  static public Object vm_generalMap_set(Object key, Object value) {
    return vm_generalMap_put(key, value);
  }

  static public JPanel jcenteredbuttons(Object... params) {
    return jcenteredline(paramsToButtons(params));
  }

  static public GlobalID asGlobalID(String id) {
    return id == null ? null : new GlobalID(id);
  }

  static public <A extends Concept> Pair<A, Boolean> uniq2(Class<A> c, Object... params) {
    return uniq2(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Pair<A, Boolean> uniq2(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
        return pair(x, true);
      }
      return pair(x, false);
    } finally {
      _close(__1);
    }
  }

  static public String copyTextToClipboard(Object _text) {
    String text = str(_text);
    StringSelection selection = new StringSelection(text);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    vmBus_send("newClipboardContents", text);
    return text;
  }

  static public <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public JComponent wrap(Object swingable) {
    return _recordNewSwingComponent(wrap_2(swingable));
  }

  static public JComponent wrap_2(Object swingable) {
    if (swingable == null)
      return null;
    JComponent c;
    if (swingable instanceof Component)
      c = componentToJComponent((Component) swingable);
    else if (swingable instanceof Swingable)
      c = componentToJComponent(((Swingable) swingable).visualize());
    else
      c = componentToJComponent((Component) callOpt(swingable, "swing"));
    if (c instanceof JTable || c instanceof JList || c instanceof JTextArea || c instanceof JEditorPane || c instanceof JTextPane || c instanceof JTree)
      return jscroll(c);
    return c == null ? jlabel(str(swingable)) : c;
  }

  static public <A> boolean syncRemoveAll(Collection<A> c, Collection<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.removeAll(b);
    }
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public BufferedImage whiteImage(int w, int h) {
    return newBufferedImage(w, h, Color.white);
  }

  static public BufferedImage whiteImage(int size) {
    return whiteImage(size, size);
  }

  static public BufferedImage whiteImage(WidthAndHeight size) {
    return whiteImage(size.getWidth(), size.getHeight());
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(BitSet bs) {
    return bs == null || bs.isEmpty();
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(IMultiMap mm) {
    return mm == null || mm.size() == 0;
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public boolean empty(DoubleRange r) {
    return r == null || r.isEmpty();
  }

  static public boolean empty(IntBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(LongBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(SynchronizedLongBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(DoubleBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(SynchronizedDoubleBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(SynchronizedFloatBufferPresentingAsDoubles b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(IDoubleBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(ILongBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(Rect r) {
    return !(r != null && r.w != 0 && r.h != 0);
  }

  static public boolean empty(Chain c) {
    return c == null;
  }

  static public boolean empty(AppendableChain c) {
    return c == null;
  }

  static public boolean empty(IntSize l) {
    return l == null || l.size() == 0;
  }

  static public void minWindowWidth(Window window, int w) {
    if (window != null) {
      swing(() -> {
        if (window.getWidth() < w)
          window.setSize(w, window.getHeight());
      });
    }
  }

  static public <A> A oneOf(List<A> l) {
    if (empty(l))
      return null;
    int n = l.size();
    return n == 1 ? first(l) : l.get(defaultRandomizer().nextInt(n));
  }

  static public char oneOf(String s) {
    return empty(s) ? '?' : s.charAt(random(l(s)));
  }

  static public <A> A oneOf(A... l) {
    return oneOf(asList(l));
  }

  static public void cancelAndInterruptThread(Thread t) {
    if (t == null)
      return;
    cancelThread(t);
    t.interrupt();
  }

  static public Rect boundsAsRect(Component c) {
    return boundsRect(c);
  }

  static public <A> IterableIterator<A> singletonIterator(A a) {
    return new IterableIterator<A>() {

      public boolean returned = false;

      public A next() {
        if (!returned) {
          returned = true;
          return a;
        } else
          throw fail();
      }

      public boolean hasNext() {
        return !returned;
      }
    };
  }

  static public void showPopupMenu(JPopupMenu menu, MouseEvent e) {
    if (menu != null && e != null)
      menu.show(e.getComponent(), e.getX(), e.getY());
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm) {
    return navigableMultiSetMapValuesIterator_concurrent(mm, mm.data);
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm, Object mutex) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data, mutex);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return list(type, db_mainConcepts());
  }

  static public <A extends Concept> List<A> list(Class<A> type, Concepts cc) {
    return cc.list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public List<Concept> list(Concepts concepts) {
    return asList(concepts.allConcepts());
  }

  static public boolean replaceTabTitleComponent(JTabbedPane tabs, String name, Component c) {
    if (tabs == null)
      return false;
    return swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          int idx = tabs.indexOfTab(name);
          if (idx < 0)
            return false;
          tabs.setTabComponentAt(idx, c);
          return true;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "int idx = tabs.indexOfTab(name);\r\n    if (idx < 0) false;\r\n    tabs.setTabCom...";
      }
    });
  }

  static public <A> IVarWithNotify<A> getterVarOnly(IVarWithNotify<A> var) {
    if (var == null)
      return null;
    var var2 = new VirtualVar(() -> var.get(), null);
    addWeakChangeListener(var, var2);
    return var2;
  }

  static public void desktopOpen(File f) {
    try {
      if (f != null) {
        print("desktopOpen: " + f2s(f));
        Desktop.getDesktop().open(f);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JSpinner jSpinner() {
    return swing(() -> {
      JSpinner s = new JSpinner();
      return jSpinnerCommitOnValidEdit(s);
    });
  }

  static public JSpinner jSpinner(int value) {
    return swing(() -> {
      JSpinner s = new JSpinner();
      s.setValue(value);
      return jSpinnerCommitOnValidEdit(s);
    });
  }

  static public JSpinner jSpinner(int min, int max) {
    return jSpinner(min, min, max);
  }

  static public JSpinner jSpinner(int value, int min, int max) {
    return swing(() -> {
      return jSpinnerCommitOnValidEdit(new JSpinner(new SpinnerNumberModel(value, min, max, 1)));
    });
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static public JPanel makeForm2(Object... parts) {
    return makeForm_customLayout(formLayouter1(), parts);
  }

  static public <A extends JComponent> A onFirstShow(A component, Runnable onShow) {
    return onFirstComponentShow(component, onShow);
  }

  static public <A extends JComponent> A onFirstShow(Runnable onShow, A component) {
    return onFirstShow(component, onShow);
  }

  static public JComponent makeForm3(Object... parts) {
    return new JForm(parts).visualize();
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuInstance(Class<A> c) {
    return nuEmptyObject(c);
  }

  static public Object[] dropEntryFromParams(Object[] params, int i) {
    int n = l(params);
    if (i < 0 || i >= n)
      return params;
    if (n == 2)
      return null;
    Object[] p = new Object[n - 2];
    System.arraycopy(params, 0, p, 0, i);
    System.arraycopy(params, i + 2, p, i, n - i - 2);
    return p;
  }

  static public Rectangle maxWindowBounds() {
    return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
  }

  static public boolean cic(Collection<String> l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(Collection<Symbol> l, Symbol s) {
    return contains(l, s);
  }

  static public boolean cic(String[] l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(String s, char c) {
    return containsIgnoreCase(s, c);
  }

  static public boolean cic(String a, String b) {
    return containsIgnoreCase(a, b);
  }

  static public JLabel jCenteredLiveValueLabel(final LiveValue lv) {
    return centerLabel(jLiveValueLabel(lv));
  }

  static public <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }
    }
    ;
    return new IFF2();
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public List flattenCollectionsAndArrays(Iterable a) {
    List l = new ArrayList();
    for (Object x : a) if (x instanceof Collection)
      l.addAll(flattenCollectionsAndArrays((Collection) x));
    else if (x instanceof Object[])
      l.addAll(flattenCollectionsAndArrays(asList((Object[]) x)));
    else
      l.add(x);
    return l;
  }

  static public List flattenCollectionsAndArrays(Object... whatever) {
    return flattenCollectionsAndArrays(ll(whatever));
  }

  static public JLabel jSimpleLabel() {
    return jSimpleLabel("");
  }

  static public JLabel jSimpleLabel(String text) {
    return swing(() -> new JLabel(text));
  }

  static public <A> void remove(List<A> l, int i) {
    if (l != null && i >= 0 && i < l(l))
      l.remove(i);
  }

  static public <A> void remove(Collection<A> l, A a) {
    if (l != null)
      l.remove(a);
  }

  static public <A, B> B remove(Map<A, B> map, Object a) {
    return map == null ? null : map.remove(a);
  }

  static public void remove(BitSet bs, int i) {
    bs.clear(i);
  }

  static public JPanel centerAndSouthOrEast(boolean horizontal, Component c, Component s) {
    return horizontal ? centerAndEast(c, s) : centerAndSouth(c, s);
  }

  static public IF1 toIF1(final Object f) {
    if (f == null)
      return null;
    if (f instanceof IF1)
      return (IF1) f;
    if (isString(f)) {
      throw fail("callF_legacy");
    }
    return new IF1() {

      public Object get(Object a) {
        return callF(f, a);
      }
    };
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      try (FileOutputStream fileOutputStream = newFileOutputStream(tempFileName)) {
        fileOutputStream.write(contents);
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public void imageSurface_pixelated(ImageSurface imageSurface) {
    if (imageSurface == null)
      return;
    imageSurface.setDoubleBuffered(true);
    imageSurface.noAlpha = true;
    imageSurface.interpolationMode = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    repaint(imageSurface);
  }

  static public void imageSurface_pixelated(ImageSurface imageSurface, boolean pixelated) {
    if (pixelated)
      imageSurface_pixelated(imageSurface);
    else
      imageSurface_unpixelated(imageSurface);
  }

  static public String renderRecordVars(String recordName, Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return formatFunctionCall(recordName, l);
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public JFrame showPackedFrame(String title, Component contents) {
    return packFrame(showFrame(title, contents));
  }

  static public JFrame showPackedFrame(Component contents) {
    return packFrame(showFrame(contents));
  }

  static public List syncMap(Object f, Map map) {
    return syncMap(map, f);
  }

  static public List syncMap(Map map, Object f) {
    return map(cloneLinkedHashMap(map), f);
  }

  static public <A, B> Map<A, B> syncMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> syncMap(Map map) {
    return synchronizedMap(map);
  }

  static public JPanel jpanel(LayoutManager layout, Object... components) {
    return jpanel(layout, asList(components));
  }

  static public JPanel jpanel(LayoutManager layout, List components) {
    return smartAdd(jpanel(layout), components);
  }

  static public JPanel jpanel(LayoutManager layout) {
    return swing(() -> new JPanel(layout));
  }

  static public JPanel jpanel() {
    return swing(() -> new JPanel());
  }

  static public boolean isComponentOrSwingable(Object o) {
    if (o instanceof Swingable)
      return true;
    return o instanceof Component;
  }

  static public Rectangle maximumWindowBounds() {
    return maxWindowBounds();
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public Collection<Concept> conceptsWhere(String c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public <B> TreeMap<String, B> toCIMap(Map<String, B> map) {
    return asCIMap(map);
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public double popLast(DoubleBuffer l) {
    return l.popLast();
  }

  static public int showForm_leftWidth_safetyMargin = 10;

  static public int showForm_leftWidth(List<List<JComponent>> l) {
    forEachLevel2(l, x -> vmBus_send("updateLayoutNow", x));
    int minW = 0;
    for (List<JComponent> row : l) minW = max(minW, getMinimumSize(first(row)).width);
    return minW + or((Integer) vmBus_query("formSafetyMargin"), showForm_leftWidth_safetyMargin);
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public BufferedImage renderableToImage(Renderable r) {
    if (r == null)
      return null;
    return renderableToImage(r.preferredSize(), r);
  }

  static public BufferedImage renderableToImage(int w, int h, Renderable r) {
    return renderableToImage(w, h, white(), r);
  }

  static public BufferedImage renderableToImage(int w, int h, Color backgroundColor, Renderable r) {
    return renderableToImage(pt(w, h), backgroundColor, r);
  }

  static public BufferedImage renderableToImage(Pt size, Renderable r) {
    return renderableToImage(size, white(), r);
  }

  static public BufferedImage renderableToImage(Pt size, Color backgroundColor, Renderable r) {
    var img = newImage(size.x, size.y, backgroundColor);
    r.renderOn(imageGraphics(img), size.x, size.y);
    return img;
  }

  static public String nRegions(long n) {
    return n2(n, "region");
  }

  static public String nRegions(Collection l) {
    return nRegions(l(l));
  }

  static public String nRegions(Map map) {
    return nRegions(l(map));
  }

  static public <A extends JComponent> A focus(final A a) {
    if (a != null)
      swingLater(new Runnable() {

        public void run() {
          try {
            a.requestFocus();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.requestFocus();";
        }
      });
    return a;
  }

  static public List<String> tok_identifiersInOrder(String s) {
    return filter(__94 -> isIdentifier(__94), javaTokC(s));
  }

  static public List<String> tok_identifiersInOrder(List<String> tok) {
    return filter(__95 -> isIdentifier(__95), codeTokens(tok));
  }

  static public File fileAppendToName(File f, String suffix) {
    return newFile(f.getPath() + suffix);
  }

  static public int cores() {
    return numberOfCores();
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Class<A> type, Iterable<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Class<A> type, Collection<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Collection<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    var c2 = asList(c);
    A[] a = arrayOfType(l(c2), type);
    if (a.length == 0)
      return a;
    c2.toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public String[] asStringArray(Collection<String> c) {
    return toStringArray(c);
  }

  static public String[] asStringArray(Object o) {
    return toStringArray(o);
  }

  static public <A extends Concept> A findConceptWhereCI(Class<A> c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    Lowest<IF0<Collection<A>>> bestIndex = new Lowest();
    if (concepts.ciFieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        ping();
        Object val = params[i + 1];
        IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> l = index.getAll(val);
          bestIndex.put(() -> l, l(l));
        }
        if (concepts.useBackRefsForSearches && val instanceof Concept) {
          bestIndex.put(() -> findBackRefs(((Concept) val), c), ((Concept) val)._backRefCount());
        }
      }
    if (bestIndex.has()) {
      Collection<A> l = bestIndex.get().get();
      if (l(params) == 2)
        return first(l);
      for (A x : l) {
        ping();
        if (checkConceptFieldsIC(x, params))
          return x;
      }
      return null;
    } else {
      for (A x : concepts.list(c)) {
        ping();
        if (checkConceptFieldsIC(x, params))
          return x;
      }
      return null;
    }
  }

  static public Concept findConceptWhereCI(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) {
      ping();
      if (checkConceptFieldsIC(x, params))
        return x;
    }
    return null;
  }

  static public void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImageWithMeta intArrayToBufferedImage(int[] pixels, int w) {
    return intArrayToBufferedImage(pixels, w, pixels.length / w);
  }

  static public BufferedImageWithMeta intArrayToBufferedImage(int[] pixels, int w, int h) {
    if (w == 0 || h == 0)
      return null;
    int[] bitMasks = new int[] { 0xFF0000, 0xFF00, 0xFF, 0xFF000000 };
    SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(DataBuffer.TYPE_INT, w, h, bitMasks);
    DataBufferInt db = new DataBufferInt(pixels, pixels.length);
    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point());
    return new BufferedImageWithMeta(ColorModel.getRGBdefault(), wr, false, null);
  }

  static public BufferedImageWithMeta intArrayToBufferedImage(int w, int... pixels) {
    return intArrayToBufferedImage(pixels, w);
  }

  static public String gtt(JTextComponent c) {
    return getTextTrim(c);
  }

  static public String gtt(JComboBox cb) {
    return getTextTrim(cb);
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public Component jMinHeight(Swingable c, int h) {
    return jMinHeight(wrap(c), h);
  }

  static public Component jMinHeight(int h, Swingable c) {
    return jMinHeight(wrap(c), h);
  }

  static public <A extends Component> A jMinHeight(A c, int h) {
    return jMinHeight(h, c);
  }

  static public <A extends Component> A jMinHeight(int h, A c) {
    Dimension size = c.getMinimumSize();
    c.setMinimumSize(new Dimension(size.width, max(h, size.height)));
    return jPreferHeight(h, c);
  }

  static public void printJavaVersion() {
    print("Java version: " + javaVersion());
  }

  static public boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  static public float clampZeroToOne(float x) {
    return x < 0 ? 0 : x > 1 ? 1 : x;
  }

  static public double clampZeroToOne(double x) {
    return x < 0 ? 0 : x > 1 ? 1 : x;
  }

  static public long toK(long l) {
    return (l + 1023) / 1024;
  }

  static public JPanel rightAlignedLine(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel rightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(components);
  }

  static public long toM(long l) {
    return (l + 1024 * 1024 - 1) / (1024 * 1024);
  }

  static public String toM(long l, int digits) {
    return formatDouble(toM_double(l), digits);
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public boolean even(BigInteger n) {
    return even(n.intValue());
  }

  static public int linesOfCode_javaTok(String text) {
    List<String> tok = javaTok(text);
    int lines = 0;
    boolean codeInCurrentLine = false;
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i)) {
        int lTok = l(t);
        for (int j = 0; j < lTok; j++) {
          char c = t.charAt(j);
          if (c == '\n')
            codeInCurrentLine = false;
          else if (!isSpaceEtc(c) && !codeInCurrentLine) {
            codeInCurrentLine = true;
            ++lines;
          }
        }
      } else {
        if (codeInCurrentLine && containsNewLine(t))
          codeInCurrentLine = false;
      }
    }
    return lines;
  }

  static public double toS(long ms) {
    return toSeconds(ms);
  }

  static public String toS(long ms, int digits) {
    return toSeconds(ms, digits);
  }

  static public void swingNowOrLater(Runnable r) {
    if (isAWTThread())
      r.run();
    else
      swingLater(r);
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(int w, BWIntegralImage img) {
    return scaledGrayBytesFromBWIntegralImage(img, w);
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(BWIntegralImage img, int w) {
    return scaledGrayBytesFromBWIntegralImage(img, w, heightForWidth(img, w));
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(BWIntegralImage img, int w, int h) {
    int w1 = img.getWidth(), h1 = img.getHeight();
    double stepX = doubleRatio(w1, w), stepY = doubleRatio(h1, h);
    byte[] pixels = new byte[w * h];
    int i = 0;
    double srcY = 0;
    if (stepX == 1 && stepY == 1) {
      for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
        int pixel = img.getPixelBrightness(x, y);
        pixels[i++] = clampToUByte(pixel);
      }
    } else {
      for (int y = 0; y < h; y++) {
        double srcX = 0, nextSrcY = srcY + stepY;
        for (int x = 0; x < w; x++) {
          double nextSrcX = srcX + stepX;
          int pixel = iround(img.getPixelAverage(srcX, srcY, nextSrcX, nextSrcY));
          pixels[i++] = clampToUByte(pixel);
          srcX = nextSrcX;
        }
        srcY = nextSrcY;
      }
    }
    return pixels;
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(int w, IBWIntegralImage img) {
    return scaledGrayBytesFromBWIntegralImage(img, w);
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(IBWIntegralImage img, int w) {
    return scaledGrayBytesFromBWIntegralImage(img, w, heightForWidth(img, w));
  }

  static public byte[] scaledGrayBytesFromBWIntegralImage(IBWIntegralImage img, int w, int h) {
    int w1 = img.getWidth(), h1 = img.getHeight();
    double stepX = doubleRatio(w1, w), stepY = doubleRatio(h1, h);
    byte[] pixels = new byte[w * h];
    int i = 0;
    double srcY = 0;
    if (stepX == 1 && stepY == 1) {
      for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
        int pixel = img.getPixelBrightness(x, y);
        pixels[i++] = clampToUByte(pixel);
      }
    } else {
      for (int y = 0; y < h; y++) {
        double srcX = 0, nextSrcY = srcY + stepY;
        for (int x = 0; x < w; x++) {
          double nextSrcX = srcX + stepX;
          int pixel = iround(img.getPixelAverage(srcX, srcY, nextSrcX, nextSrcY));
          pixels[i++] = clampToUByte(pixel);
          srcX = nextSrcX;
        }
        srcY = nextSrcY;
      }
    }
    return pixels;
  }

  static public <A extends JComponent> A jMaxWidth(int w, A c) {
    Dimension size = c.getMaximumSize();
    c.setMaximumSize(new Dimension(w, size.height));
    return jPreferWidth(w, c);
  }

  static public <A extends JComponent> A jMaxWidth(A c, int w) {
    return jMaxWidth(w, c);
  }

  static public boolean ping() {
    return ping(pingSource());
  }

  static public boolean ping(PingSource source) {
    ping_v3(source);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    return ping();
  }

  static volatile public boolean ping_pauseAll = false;

  static public void printNumberedLines(Map map) {
    printNumberedLines(mapToLines(map));
  }

  static public void printNumberedLines(String prefix, Map map) {
    printNumberedLines(prefix, mapToLines(map));
  }

  static public <A extends Iterable> A printNumberedLines(A l) {
    int i = 0;
    if (l != null)
      for (Object a : cloneList(l)) print((++i) + ". " + str(a));
    return l;
  }

  static public <A extends Iterable> A printNumberedLines(String prefix, A l) {
    int i = 0;
    if (l != null)
      for (Object a : cloneList(l)) print(prefix + (++i) + ". " + str(a));
    return l;
  }

  static public void printNumberedLines(Object[] l) {
    printNumberedLines("", l);
  }

  static public void printNumberedLines(String prefix, Object[] l) {
    printNumberedLines(prefix, wrapAsList(l));
  }

  static public void printNumberedLines(Object o) {
    printNumberedLines(lines(str(o)));
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public ImageSurface pixelatedImageSurface() {
    var is = imageSurface();
    imageSurface_pixelated(is);
    return is;
  }

  static public ImageSurface pixelatedImageSurface(MakesBufferedImage img) {
    return pixelatedImageSurface(toBufferedImage(img));
  }

  static public ImageSurface pixelatedImageSurface(BufferedImage img) {
    var is = pixelatedImageSurface();
    is.setImage(img);
    return is;
  }

  static public int getWidth(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getWidth");
  }

  static public void stepAllWithStats(Steppable s) {
    stepAllWithStats(s, null);
  }

  static public void stepAllWithStats(Steppable s, Long maxSteps) {
    if (s == null)
      return;
    long n = 0;
    long time = sysNow();
    if (maxSteps == null)
      while (s.step()) {
        ping();
        ++n;
      }
    else
      while (n < maxSteps && s.step()) {
        ping();
        ++n;
      }
    time = sysNow() - time;
    print(n2(n, "step") + " in " + n2(time) + " ms");
  }

  static public <A> void setComboBoxItems_notifyListeners(JComboBox<A> cb, Collection<A> items) {
    if (cb != null) {
      swing(() -> {
        if (eq(getComboBoxItems(cb), items))
          return;
        var sel = getSelectedItem_typed(cb);
        setComboBoxItems(cb, items);
        var item = getSelectedItem_typed(cb);
        if (!eq(sel, item)) {
          if (sel != null && contains(items, sel))
            setSelectedItem(cb, sel);
          else {
            setSelectedItem(cb, (A) null);
            setSelectedItem(cb, item);
          }
        }
      });
    }
  }

  static public String exceptionToStringShorter_dontDropOuterExceptions(Throwable e) {
    String msg = hideCredentials(unnull(e.getMessage()));
    String className = baseClassName(e);
    if (!eq(className, "RuntimeException") && (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0))
      return className + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void scrollRowToVisible(JTable t, int rowIndex) {
    int colIndex = 0;
    if (!(t.getParent() instanceof JViewport))
      return;
    JViewport viewport = (JViewport) t.getParent();
    Rectangle rect = t.getCellRect(rowIndex, colIndex, true);
    Rectangle viewRect = viewport.getViewRect();
    int x = viewRect.x;
    int y = viewRect.y;
    if (rect.x >= viewRect.x && rect.x <= (viewRect.x + viewRect.width - rect.width)) {
    } else if (rect.x < viewRect.x) {
      x = rect.x;
    } else if (rect.x > (viewRect.x + viewRect.width - rect.width)) {
      x = rect.x - viewRect.width + rect.width;
    }
    if (rect.y >= viewRect.y && rect.y <= (viewRect.y + viewRect.height - rect.height)) {
    } else if (rect.y < viewRect.y) {
      y = rect.y;
    } else if (rect.y > (viewRect.y + viewRect.height - rect.height)) {
      y = rect.y - viewRect.height + rect.height;
    }
    viewport.setViewPosition(new Point(x, y));
  }

  static public JWindow infoBoxForever(String message) {
    return infoBox(message, 0);
  }

  static public BufferedImage loadBufferedImageFile(File file) {
    try {
      if (!isFile(file))
        return null;
      if (hasExtension(file, ".qoi"))
        return loadQOI(file);
      return ImageIO.read(file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public float bwImageSimilarityResized(BWImage a, BWImage b, float similarityRequired) {
    int aw = a.w(), ah = a.h();
    int bw = b.w(), bh = b.h();
    int wp = max(aw, bw), hp = max(ah, bh);
    float ratio1 = ((float) aw) / ah, ratio2 = ((float) bw) / bh;
    float mismatch = ratio1 / ratio2;
    if (mismatch < 1f)
      mismatch = 1f / mismatch;
    float factor = wp * hp / mismatch;
    float maxError = (1f - similarityRequired) * factor;
    float diff = 0;
    for (int y = 0; y < hp; y++) for (int x = 0; x < wp; x++) {
      diff += Math.abs(a.getPixel(x * aw / wp, y * ah / hp) - b.getPixel(x * bw / wp, y * bh / hp));
      if (diff > maxError)
        return similarityRequired - 0.001f;
    }
    return 1f - diff / factor;
  }

  static public <A extends JComponent> A dm_transientCalculatedToolTip(IF0<Object> calc, A component) {
    return toolTipFromLiveValue(dm_transientCalculatedLiveValue(Object.class, calc), component);
  }

  static public void copyFileVerbose(File src, File dest) {
    copyFileToFileVerbose(src, dest);
  }

  static public Pair<Boolean, String> transpileOnBestServer(String snippetID, String mode) {
    try {
      return haveTranspilationPassword() ? print("shouldTranspileOnDedi", shouldTranspileOnDedi()) ? transpileOnDediServer(snippetID, mode) : transpileOnNewServer(snippetID, mode) : transpileOnServer(snippetID, mode);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pair<Boolean, String> transpileOnBestServer(String snippetID) {
    return transpileOnBestServer(snippetID, "quick");
  }

  static public List<String> stringsSortedByLength(Iterable<String> l) {
    return sortedByCalculatedField(l, new F1<String, Integer>() {

      public Integer get(String s) {
        try {
          return l(s);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "l(s)";
      }
    });
  }

  static public <A extends JLabel> A leftAlignLabel(final A a) {
    return setHorizontalAlignment(JLabel.LEFT, a);
  }

  static public Webcam findWebCamByName(List<Webcam> cams, String name) {
    if (empty(name))
      return null;
    for (Webcam cam : unnull(cams)) if (eqic(cam.getName(), name))
      return cam;
    return null;
  }

  static public String nFiles(long n) {
    return n2(n, "file");
  }

  static public String nFiles(Collection l) {
    return nFiles(l(l));
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public void doPostBinaryToFile(Map urlParameters, String url, File file) {
    doPostBinaryToFile(makePostData(urlParameters), url, file);
  }

  static public void doPostBinaryToFile(String urlParameters, String url, File file) {
    try {
      URL _url = new URL(url);
      ping();
      doPostBinaryToFile(urlParameters, _url.openConnection(), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void doPostBinaryToFile(String urlParameters, URLConnection conn, File file) throws IOException {
    setHeaders(conn);
    conn.setDoOutput(true);
    OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
    writer.write(urlParameters);
    writer.flush();
    try {
      loadBinaryPageToFile_noHeaders(conn, file);
    } finally {
      writer.close();
    }
  }

  static public String formatSeconds(long ms, int digits) {
    return formatDouble(toS(ms), digits);
  }

  static public String formatSeconds(Duration duration, int digits) {
    return formatSeconds(duration.toMillis(), digits);
  }

  static public GlobalID aGlobalIDObjUnlessLoading() {
    return dynamicObjectIsLoading() ? null : aGlobalIDObj();
  }

  static public IterableIterator<Integer> countIterator_inclusive_step(int a, int b, int step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i <= b;
      }

      public Integer next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public IterableIterator<Long> countIterator_inclusive_step(long a, long b, long step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Long>() {

      public long i = a;

      public boolean hasNext() {
        return i <= b;
      }

      public Long next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public IterableIterator<Double> countIterator_inclusive_step(double a, double b, double step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Double>() {

      public double i = a;

      public boolean hasNext() {
        return i <= b;
      }

      public Double next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_inclusive_step(double a, double b, double step, IF1<Double, A> f) {
    return mapI_if1(f, countIterator_inclusive_step(a, b, step));
  }

  static public <A> IterableIterator<A> countIterator_inclusive_step(int a, int b, int step, IF1<Integer, A> f) {
    return mapI_if1(f, countIterator_inclusive_step(a, b, step));
  }

  static public <A> VF1<A> ivf1ToVF1(IVF1<A> f) {
    return f == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          f.get(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "f.get(a)";
      }
    };
  }

  static public int lCharSequence(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public JButton jimageButton(String imageID, Object action) {
    JButton btn = jbutton("", action);
    btn.setIcon(imageIcon(imageID));
    return btn;
  }

  static public JButton jimageButton(String imageID) {
    return jimageButton(imageID, null);
  }

  static public JButton jimageButton(Image img) {
    return jimageButton(img, null, null);
  }

  static public JButton jimageButton(String imageID, String toolTip, Runnable action) {
    return jimageButton(imageIcon(imageID), toolTip, action);
  }

  static public JButton jimageButton(Image img, String toolTip, Runnable action) {
    var btn = jbutton("", action);
    setButtonImage(btn, img);
    return setToolTip(toolTip, btn);
  }

  static public JButton jimageButton(ImageIcon img, String toolTip, Runnable action) {
    var btn = jbutton("", action);
    setButtonImage(btn, img);
    return setToolTip(toolTip, btn);
  }

  static public Dimension maxDimension(Dimension a, Dimension b) {
    return a == null ? b : b == null ? a : new Dimension(max(a.width, b.width), max(a.height, b.height));
  }

  static public int formLayouter1_yPlus = 5;

  static public int formLayouter1_fixer2 = 0;

  static public F1<Container, Dimension> formLayouter1() {
    final int yplus = formLayouter1_yPlus, fixer2 = formLayouter1_fixer2;
    return new F1<Container, Dimension>() {

      public Dimension get(Container parent) {
        try {
          List<Component> l = getComponents(parent);
          BitSet bigOnes = new BitSet();
          for (int i = 0; i < l(l); i++) if (containsATextArea(l.get(i)))
            add(bigOnes, i);
          int nBigOnes = bigOnes.cardinality();
          int mandatoryHeight = totalPreferredHeight(listWithoutIndicesInBitSet(l, bigOnes));
          int gap = 4, outerSpacing = 5;
          Dimension size = parent.getSize();
          int gapsAndMargins = outerSpacing * 2 - (l(l) - 1) * gap;
          int totalSpace = size.height - gapsAndMargins - fixer2;
          int liberalSpace = totalSpace - mandatoryHeight;
          double perBigOne = doubleRatio(liberalSpace, nBigOnes);
          double y = outerSpacing;
          for (int i = 0; i < l(l); i++) {
            Component c = l.get(i);
            boolean big = contains(bigOnes, i);
            double h = big ? perBigOne : c.getPreferredSize().height;
            int actualY = iround(y);
            c.setBounds(10, actualY, size.width - outerSpacing * 2, iround(y + h) - actualY);
            y += h + gap;
          }
          Dimension pref = componentsBoundingSize(parent, outerSpacing);
          if (parent.getHeight() <= 0) {
            int tph = totalPreferredHeight(l);
            pref.height = tph + gapsAndMargins + yplus;
          }
          return pref;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "L<Component> l = getComponents(parent);\r\n    new BitSet bigOnes;\r\n    for i o...";
      }
    };
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public ArrayList<Short> toList(short[] a) {
    return asList(a);
  }

  static public ArrayList<Long> toList(long[] a) {
    return asList(a);
  }

  static public ArrayList<Double> toList(double[] a) {
    return asList(a);
  }

  static public ArrayList<Float> toList(float[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public RGB rgbFromGrayscale(int brightness) {
    float f = RGB.brightnessToFloat(brightness);
    return new RGB(f, f, f);
  }

  static public String joinStrings(String sep, Object... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Iterable strings) {
    StringBuilder buf = new StringBuilder();
    for (Object o : unnull(strings)) {
      String s = strOrNull(o);
      if (nempty(s)) {
        if (nempty(buf))
          buf.append(sep);
        buf.append(s);
      }
    }
    return str(buf);
  }

  static public Object[] massageArgsForVarArgsCall(Executable m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = l(args);
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    int nVarArgs = nArgs - n;
    Object varArgs = Array.newInstance(varArgType, nVarArgs);
    for (int i = 0; i < nVarArgs; i++) Array.set(varArgs, i, args[n + i]);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public void tableEnableTextDrag(final JTable table) {
    TransferHandler th = new TransferHandler() {

      @Override
      public int getSourceActions(JComponent c) {
        return COPY;
      }

      @Override
      public Transferable createTransferable(JComponent c) {
        Object o = selectedTableCell(table);
        return new StringSelection(str(o));
      }
    };
    tableEnableDrag(table, th);
  }

  static public <A> IVF1<A> runnableToIVF1(Runnable r) {
    return r == null ? null : a -> r.run();
  }

  static public boolean eqOneOf(Object o, Object... l) {
    if (l != null)
      for (Object x : l) if (eq(o, x))
        return true;
    return false;
  }

  static public boolean containsClosingBracket(List<String> l) {
    return any(__96 -> isClosingBracket(__96), l);
  }

  static public String roundBracket(String s) {
    return "(" + s + ")";
  }

  static public String roundBracket(Object s) {
    return roundBracket(str(s));
  }

  static public JToggleButton basicJToggleButton(String text) {
    return swing(() -> new JToggleButton(text));
  }

  static public <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
    List<A> l = tl.get();
    if (l == null)
      tl.set(l = new ArrayList());
    l.add(a);
  }

  static public List<Integer> virtualCountList(int n) {
    return new RandomAccessAbstractList<Integer>() {

      public int size() {
        return n;
      }

      public Integer get(int i) {
        return i;
      }
    };
  }

  static public List<Integer> virtualCountList(int from, int to) {
    int n = max(to - from, 0);
    return new RandomAccessAbstractList<Integer>() {

      public int size() {
        return n;
      }

      public Integer get(int i) {
        return from + i;
      }
    };
  }

  static public String sfuIndent(Object o) {
    return sfuIndent(Integer.MAX_VALUE, o);
  }

  static public String sfuIndent(int levels, Object o) {
    return indentedStructureForUser(levels, o);
  }

  static public JPanel jCenteredLine(Component... components) {
    return jcenteredline(components);
  }

  static public JPanel jCenteredLine(List<? extends Component> components) {
    return jcenteredline(components);
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public <A extends JComponent> A onFirstShowing(A component, Runnable onShow) {
    return onFirstComponentShow(component, onShow);
  }

  static public void addAndValidate(Container c, Component x) {
    if (c != null && x != null) {
      swing(() -> {
        if (c instanceof DynamicStack) {
          ((DynamicStack) c).addComponent(x);
          return;
        }
        c.add(x);
        c.revalidate();
      });
    }
  }

  static public <A, B> Pair<A, B> mapEntryToPair(Map.Entry<A, B> e) {
    return e == null ? null : pair(e.getKey(), e.getValue());
  }

  static public void cancelThread(Thread t) {
    if (t == null)
      return;
    ping();
    var ps = pingSource(t);
    if (ps == null)
      warn("No ping source for thread " + t + ", can't cancel");
    else
      ps.cancel();
  }

  static public Map<Object, Object> castMapToMapO(Map map) {
    return map;
  }

  static public List<String> endingWith_dropSuffix(Collection<String> l, String suffix) {
    List<String> out = new ArrayList();
    for (String s : unnullForIteration(l)) if (endsWith(s, suffix))
      out.add(dropLast(l(suffix), s));
    return out;
  }

  static public List<String> endingWith_dropSuffix(String suffix, Collection<String> l) {
    return endingWith_dropSuffix(l, suffix);
  }

  static public <A> IterableIterator<A> iteratorFromFunction(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = (A) callF(f);
        done = a == null;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction(F0<A> f) {
    return iteratorFromFunction_f0(f);
  }

  static public <A> IterableIterator<A> iteratorFromFunction(IF0<A> f) {
    return iteratorFromFunction_if0(f);
  }

  static public int secondIntFromLong(long l) {
    return (int) l;
  }

  static public List afterDelegatingToThread_operations = synchroList();

  static public void afterDelegatingToThread(Thread t) {
    for (Object op : cloneList(afterDelegatingToThread_operations)) pcallF(op, t);
  }

  static public void afterDelegatingToThread_do(Object f) {
    setAdd(afterDelegatingToThread_operations, f);
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public boolean scrollAllTheWayDown_bruteForce = true;

  static public <A extends JComponent> A scrollAllTheWayDown(A c) {
    if (c != null) {
      swing(() -> {
        int h = c.getHeight() - 1;
        if (scrollAllTheWayDown_bruteForce)
          h = max(h, 100000);
        c.scrollRectToVisible(new Rectangle(0, h, 1, 1));
      });
    }
    return c;
  }

  static public int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public JCheckBox dm_rcheckBox(String field) {
    return dm_fieldCheckBox(field);
  }

  static public JCheckBox dm_rcheckBox(String field, String text) {
    return dm_fieldCheckBox(text, field);
  }

  static public Pair<String, Integer> jmenu_autoMnemonic(String s) {
    int i = indexOf(s, '&');
    if (i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i + 1)))
      return pair(substring(s, 0, i) + substring(s, i + 1), (int) s.charAt(i + 1));
    return pair(s, 0);
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, lCharSequence(l));
  }

  static public void clickButton(final JButton b) {
    if (b != null) {
      swing(() -> {
        if (b.isEnabled())
          b.doClick();
      });
    }
  }

  static public Component horizontalStrut(int height) {
    return Box.createHorizontalStrut(height);
  }

  static public boolean setTextKeepCaret(String text, JTextComponent c) {
    if (c == null)
      return false;
    return swing(() -> {
      int caret = c.getCaretPosition();
      if (eq(c.getText(), text))
        return false;
      c.setText(text);
      setCaretPosition(c, caret);
      return true;
    });
  }

  static public boolean setTextKeepCaret(JTextComponent c, String text) {
    return setTextKeepCaret(text, c);
  }

  static public <A, B> AutoCloseable tempMapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null) {
      B old = map.put(key, value);
      return () -> mapPutOrRemove(map, key, old);
    }
    return null;
  }

  static public ZipFile openZipFile(File f) {
    try {
      return new ZipFile(f);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage cloneBufferedImageWithMetaSrc(Object src, BufferedImage img) {
    if (img == null)
      return null;
    img = cloneBufferedImageWithMeta(img);
    setMetaSrc(img, src);
    assertSame("cloneBufferedImageWithMetaSrc", getMetaSrc(img), src);
    return img;
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public List<Component> tabComponents(final JTabbedPane tabs) {
    final List<Component> l = new ArrayList();
    if (tabs != null) {
      swing(() -> {
        for (int i = 0; i < tabs.getTabCount(); i++) l.add(tabs.getTabComponentAt(i));
      });
    }
    return l;
  }

  static public void drawLine(BufferedImage image, int x1, int y1, int x2, int y2, Color color) {
    drawLine(imageGraphics(image), x1, y1, x2, y2, color);
  }

  static public void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, Color color) {
    g.setColor(color);
    g.drawLine(x1, y1, x2, y2);
  }

  static public void drawLine(BufferedImage image, Pt a, Pt b, Color color) {
    drawLine(imageGraphics(image), a, b, color);
  }

  static public void drawLine(Graphics2D g, Pt a, Pt b, Color color) {
    drawLine(g, a.x, a.y, b.x, b.y, color);
  }

  static public RuntimeException rethrowAndAppendToMessage(Throwable t, String msg) {
    String haveMsg = t.getMessage();
    if (empty(msg) || endsWith(haveMsg, " " + msg))
      throw rethrow(t);
    throw new RuntimeException(joinWithSpace(t.getMessage(), msg), t);
  }

  static public JLabel jimage(Image img) {
    return jImageLabel(img);
  }

  static public JLabel jimage(String imageID) {
    return jImageLabel(imageID);
  }

  static public List mapLL(Object f, Object... data) {
    return map(f, ll(data));
  }

  static public <A, B> List<B> mapLL(IF1<A, B> f, A... data) {
    return map(f, ll(data));
  }

  static public BufferedImage drawImage(BufferedImage canvas, Image img, Pt p) {
    return drawImageOnImage(img, canvas, p.x, p.y);
  }

  static public void drawImage(BufferedImage g, Image img) {
    drawImage(graphics(g), img);
  }

  static public void drawImage(Graphics2D g, Image img) {
    drawImage(g, img, 0, 0);
  }

  static public void drawImage(Graphics2D g, Image img, Pt p) {
    drawImage(g, img, p.x, p.y);
  }

  static public void drawImage(Graphics2D g, Image img, int x, int y) {
    {
      if (g != null)
        g.drawImage(img, x, y, null);
    }
  }

  static public File userDir_oneOf_createFirstIfNone(String... names) {
    return or(userDir_oneOf(names), userDir(first(names)));
  }

  static public Random getRandomizer(Random r) {
    return r != null ? r : defaultRandomGenerator();
  }

  static public void imageSurface_unpixelated(ImageSurface imageSurface) {
    if (imageSurface == null)
      return;
    imageSurface.interpolationMode = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    repaint(imageSurface);
  }

  static public Rect boundsRect(Component c) {
    return toRect(getBounds(c));
  }

  static public Set<String> allNonStaticFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & Modifier.STATIC) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public void setCaretPosition(final JTextComponent c, final int pos) {
    if (c != null) {
      swing(() -> {
        try {
          int _pos = max(0, min(l(c.getText()), pos));
          c.setCaretPosition(_pos);
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      });
    }
  }

  static public String appendBracketed(Object o) {
    String b = strOrNull(o);
    return empty(b) ? "" : "" + " (" + b + ")";
  }

  static public String appendBracketed(String a, String b) {
    return a + appendBracketed(b);
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public <A> boolean syncAddAll(Collection<A> c, Iterable<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (c) {
      return c.addAll(asCollection(b));
    }
  }

  static public String fileName(File f) {
    return f == null ? null : f.getName();
  }

  static public JComponent jErrorView(Throwable e) {
    return jSmallErrorView(e);
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public List<String> _stickyLibs_1013490 = ll("#1400553", "#1400552", "#1004016", "#1004015");

  static public List<Webcam> listWebCams() {
    fixContextClassLoader();
    return Webcam.getWebcams();
  }

  static public JLabel jImage(Image img) {
    return jimage(img);
  }

  static public JLabel jImage(String imageID) {
    return jimage(imageID);
  }

  static public generalizedCIComparator_C generalizedCIComparator_cache;

  static public generalizedCIComparator_C generalizedCIComparator() {
    if (generalizedCIComparator_cache == null)
      generalizedCIComparator_cache = generalizedCIComparator_load();
    return generalizedCIComparator_cache;
  }

  static public generalizedCIComparator_C generalizedCIComparator_load() {
    return new generalizedCIComparator_C();
  }

  final static public class generalizedCIComparator_C implements Comparator<Object> {

    public int compare(Object o1, Object o2) {
      if (o1 instanceof String)
        if (o2 instanceof String)
          return betterCIComparator().compare(((String) o1), ((String) o2));
        else
          return -1;
      else if (o2 instanceof String)
        return 1;
      else
        return cmp(o1, o2);
    }
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble((String) o);
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public void disposeFrame(final Component c) {
    disposeWindow(c);
  }

  static public boolean sameFile(File a, File b) {
    try {
      return a == null ? b == null : b != null && eq(a.getCanonicalPath(), b.getCanonicalPath());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >>> 2));
  }

  static public <A> List<A> wrapArrayAsList(A[] a) {
    return a == null ? null : Arrays.asList(a);
  }

  static public List<Component> getSwingChildren(Component c) {
    if (c instanceof Container)
      return asList(((Container) c).getComponents());
    return emptyList();
  }

  static public <Img extends WidthAndHeight> IImageRegion<Img> g22_darkestRegion(IImageRegions<Img> regions) {
    return regions == null ? null : lowest(regions.regions(), r -> r.brightness());
  }

  static public void printVars_shorten(Object... params) {
    print(renderVars_stringifier(o -> str_shorten(o), params));
  }

  static public void sortIntRangesInPlace(List<IntRange> l) {
    sortInPlaceByCalculatedField(l, r -> r.start);
  }

  static public <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  static public <A> AutoCloseable tempSetTL(BetterThreadLocal<A> tl, A a) {
    return tempSetThreadLocalIfNecessary(tl, a);
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(strOrNull(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public <A extends Iterable> A pnl(A l) {
    return pnl("", l);
  }

  static public <A extends Iterable> A pnl(String prefix, A l) {
    printNumberedLines(prefix, l);
    return l;
  }

  static public <A> A[] pnl(A[] l) {
    return pnl("", l);
  }

  static public <A> A[] pnl(String prefix, A[] l) {
    printNumberedLines(prefix, l);
    return l;
  }

  static public <A extends Map> A pnl(A map) {
    printNumberedLines(map);
    return map;
  }

  static public <A extends Map> A pnl(String prefix, A map) {
    printNumberedLines(prefix, map);
    return map;
  }

  static public String pnl(String s) {
    printNumberedLines(lines(s));
    return s;
  }

  static public <A> MultiSet<A> pnl(MultiSet<A> ms) {
    pnl(ms == null ? null : ms.asMap());
    return ms;
  }

  static public <A, B> MultiMap<A, B> pnl(MultiMap<A, B> mm) {
    pnl(mm == null ? null : mm.asMap());
    return mm;
  }

  static public int parseDigit(char c) {
    return c >= '0' && c <= '9' ? c - '0' : 0;
  }

  static public int parseDigit(String s, int i) {
    return parseDigit(s.charAt(i));
  }

  static public boolean dirOrZipContainsPath(File location, String subPath) {
    try {
      if (location.isDirectory()) {
        return new File(location, subPath).exists();
      } else if (location.isFile()) {
        return zipFileContains_falseOnError(location, subPath);
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public ThreadLocal<Boolean> addInternalFrame_dontSelect = new ThreadLocal();

  static public ThreadLocal<Integer> addInternalFrame_layer = new ThreadLocal();

  static public ThreadLocal<Boolean> addInternalFrame_toBack = new ThreadLocal();

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h) {
    return addInternalFrame(desktop, title, x, y, w, h, null);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h, final Component contents) {
    return addInternalFrame(desktop, title, rect(x, y, w, h), contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Component contents) {
    return addInternalFrame(desktop, title, null, contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Rect r, final Component contents) {
    final boolean dontSelect = isTrue(optParam(addInternalFrame_dontSelect));
    final boolean toBack = isTrue(optParam(addInternalFrame_toBack));
    final Integer layer = optParam(addInternalFrame_layer);
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame frame;
          if (contents instanceof JInternalFrame)
            frame = (JInternalFrame) contents;
          else {
            frame = jInternalFrame(title);
            setInternalFrameContents(frame, contents);
          }
          frame.setVisible(true);
          desktop.add(frame, layer);
          if (r != null)
            setBounds(frame, r);
          else
            internalFrameDefaultPosition(frame);
          if (dontSelect)
            if (toBack)
              frame.toBack();
            else
              frame.toFront();
          else
            frame.setSelected(true);
          return fixInternalFrame(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame frame;\r\n    if (contents instanceof JInternalFrame)\r\n      fra...";
      }
    });
  }

  static public JInternalFrame addInternalFrame(JDesktopPane desktop, String title) {
    return addInternalFrame(desktop, title, jpanel());
  }

  static public int numberOfChildren(final Container c) {
    return c == null ? 0 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return c.getComponentCount();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getComponentCount();";
      }
    });
  }

  static public void dm_watchFields(Collection<String> fields, Runnable onChange) {
    for (String field : unnullForIteration(fields)) dm_watchField(field, onChange);
  }

  static public JPanel jcenteredline(final Component... components) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          return jFullCenter(hstackWithSpacing(components));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return jFullCenter(hstackWithSpacing(components));";
      }
    });
  }

  static public JPanel jcenteredline(List<? extends Component> components) {
    return jcenteredline(asArray(Component.class, components));
  }

  static public <A, B> List<A> cloneKeys(Map<A, B> map) {
    return cloneList(keys(map));
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public float[] unnull(float[] l) {
    return l == null ? emptyFloatArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnull(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public int unnull(Integer i) {
    return i == null ? 0 : i;
  }

  static public long unnull(Long l) {
    return l == null ? 0L : l;
  }

  static public double unnull(Double l) {
    return l == null ? 0.0 : l;
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public <A> String joinWithComma(Iterable<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(Object... c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public JPanel vstack2(final Object... parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          GridBagConstraints gbc = new GridBagConstraints();
          gbc.weightx = 1;
          gbc.fill = GridBagConstraints.HORIZONTAL;
          gbc.gridwidth = GridBagConstraints.REMAINDER;
          smartAddWithLayout(panel, gbc, parts);
          gbc.weighty = 1;
          panel.add(jrigid(), gbc);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    new GridBagConstraints gbc...";
      }
    });
  }

  static public void runInQAndWait(Q q, Runnable r) {
    if (r == null)
      return;
    if (isInQ(q)) {
      callF(r);
      return;
    }
    final Flag done = new Flag();
    final Var<Throwable> error = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            callF(r);
          } catch (Throwable e) {
            error.set(e);
          } finally {
            done.raise();
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      callF(r);\r\n    } catch (Throwable e) {\r\n      error.set(e);\r\n   ...";
      }
    });
    done.waitUntilUp();
    if (error.has())
      throw rethrow(error.get());
  }

  static public List<JFrame> allFrames() {
    return listAllFrames();
  }

  static public String postPage(String url, Object... params) {
    return doPost(litmap(params), url);
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public BufferedImage newBufferedImage(int w, int h) {
    return new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
  }

  static public BufferedImage newBufferedImage(int w, int h, RGB rgb) {
    return newBufferedImage(w, h, rgb.getColor());
  }

  static public BufferedImage newBufferedImage(int w, int h, Color color) {
    BufferedImage img = newBufferedImage(w, h);
    Graphics2D g = img.createGraphics();
    g.setColor(or(color, Color.white));
    g.fillRect(0, 0, w, h);
    return img;
  }

  static public BufferedImage newBufferedImage(Pt p, Color color) {
    return newBufferedImage(p.x, p.y, color);
  }

  static public BufferedImage newBufferedImage(WidthAndHeight size, Color color) {
    return newBufferedImage(size.w(), size.h(), color);
  }

  static public BufferedImage newBufferedImage(int w, int h, int[] pixels) {
    return intArrayToBufferedImage(pixels, w, h);
  }

  static public <A extends JComponent> A tabComponentClickFixer(A c) {
    onMouseDown(c, e -> {
      JTabbedPane tabs = parentOfType(c, JTabbedPane.class);
      if (tabs == null)
        return;
      var tabComponents = tabComponents(tabs);
      for (int i = 0; i < l(tabComponents); i++) if (isGrandChildOf(c, tabComponents.get(i))) {
        {
          selectTab(tabs, i);
          return;
        }
      }
    });
    return c;
  }

  static public boolean lessThan(int a, int b) {
    return a < b;
  }

  static public boolean lessThan(double a, double b) {
    return a < b;
  }

  static public boolean lessThan(Object a, Object b) {
    return cmp(a, b) < 0;
  }

  static public String or2_rev(String b, String a) {
    return or2(a, b);
  }

  static public SingleThread awtCalcEvery(JFrame f, int delay, int firstDelay, final Object runnable) {
    return awtCalcRegularly(f, delay, firstDelay, runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, int delay, int firstDelay, final Object runnable) {
    return awtCalcRegularly(c, delay, firstDelay, runnable);
  }

  static public SingleThread awtCalcEvery(JFrame f, int delay, final Object runnable) {
    return awtCalcRegularly(f, delay, delay, runnable);
  }

  static public SingleThread awtCalcEvery(int delay, JComponent c, Runnable runnable) {
    return awtCalcRegularly(c, delay, delay, runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, int delay, Runnable runnable) {
    return awtCalcRegularly(c, delay, delay, runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, int delay, final Object runnable) {
    return awtCalcRegularly(c, delay, delay, runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, double delay, Runnable runnable) {
    return awtCalcEvery(c, delay, (Object) runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, double delay, Object runnable) {
    return awtCalcEvery(c, toMS_int(delay), runnable);
  }

  static public SingleThread awtCalcEvery(JComponent c, double firstDelay, double delay, final Object runnable) {
    return awtCalcEvery(c, toMS_int(delay), toMS_int(firstDelay), runnable);
  }

  static public Rect scaleRect(Rect r, double factorX, double factorY) {
    return rectFromPoints(iround(r.x * factorX), iround(r.y * factorY), iround(r.x2() * factorX), iround(r.y2() * factorY));
  }

  static public Rect scaleRect(Rect r, double factor) {
    return scaleRect(r, factor, factor);
  }

  static public Rect scaleRect(double factor, Rect r) {
    return scaleRect(r, factor);
  }

  static public DoubleRect scaleRect(DoubleRect r, double factorX, double factorY) {
    return doubleRect(r.x * factorX, r.y * factorY, r.w * factorX, r.h * factorY);
  }

  static public DoubleRect scaleRect(double factorX, double factorY, DoubleRect r) {
    return scaleRect(r, factorX, factorY);
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, List<A> l) {
    return subList(l, startIndex);
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex > endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public BufferedImage copyImage(Image img) {
    if (img == null)
      return null;
    if (img instanceof BufferedImage)
      return copyImage((BufferedImage) img);
    int w = img.getWidth(null), h = img.getHeight(null);
    BufferedImage bi = newBufferedImage(w, h);
    drawImage(bi, img);
    return bi;
  }

  static public BufferedImage copyImage(BufferedImage bi) {
    if (bi == null)
      return null;
    ColorModel cm = bi.getColorModel();
    boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
    WritableRaster raster = bi.copyData(bi.getRaster().createCompatibleWritableRaster());
    return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
  }

  static public <A extends Concept> List<A> sortConceptsByID(Collection<A> l) {
    return sortedByCalculatedField(l, c -> c.id);
  }

  static public int withRightMargin_defaultWidth = 6;

  static public JPanel withRightMargin(Component c) {
    return withRightMargin(withRightMargin_defaultWidth, c);
  }

  static public JPanel withRightMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, w));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(0,...";
      }
    });
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public BWImage scaleAndPosterize(BufferedImage img, SnPSettings settings) {
    return scaleAndPosterize(new BWIntegralImage(img), settings);
  }

  static public BWImage scaleAndPosterize(IBWIntegralImage ii, SnPSettings settings) {
    return posterizeBWImage_withMeta(settings.colors, scaledBWImageFromBWIntegralImage_withMeta_height(settings.pixelRowsForImage(ii), ii));
  }

  static public long intPairToLong(IntPair p) {
    return p == null ? 0 : (((long) p.a) << 32) | (((long) p.b) & 0xFFFFFFFF);
  }

  static public long intPairToLong(int a, int b) {
    return (((long) a) << 32) | (((long) b) & 0xFFFFFFFF);
  }

  static public <A> A evalWithTimeoutOrFail(int timeoutMS, F0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public <A> A evalWithTimeoutOrFail(double timeoutSeconds, F0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, f);
  }

  static public <A> A evalWithTimeoutOrFail(int timeoutMS, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public <A> A evalWithTimeoutOrFail(double timeoutSeconds, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, f);
  }

  static public void evalWithTimeoutOrFail(int timeoutMS, Runnable r) {
    evalWithTimeoutOrException(timeoutMS, runnableToF0(r));
  }

  static public void evalWithTimeoutOrFail(double timeoutSeconds, Runnable r) {
    evalWithTimeoutOrException(timeoutSeconds, runnableToF0(r));
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && b != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A extends Container> A addAll(A c, Collection<? extends Component> components) {
    return addComponents(c, components);
  }

  static public <A extends Container> A addAll(A c, Component... components) {
    return addComponents(c, components);
  }

  static public DynamicObject dynamicObject(String className, Object... x) {
    DynamicObject d = new DynamicObject(className);
    for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
      setDyn(d, (String) x[i], x[i + 1]);
    return d;
  }

  static public <A> A getVar(IF0<A> v) {
    return v == null ? null : v.get();
  }

  static public <A> A getVar(Optional<A> v) {
    return v == null ? null : v.orElse(null);
  }

  static public <A, B> LinkedHashMap<A, B> mapSortedByValue(Map<A, B> map) {
    return orderMapByValue(map);
  }

  static public boolean isAnonymousClassName(String s) {
    for (int i = 0; i < l(s); i++) if (s.charAt(i) == '$' && Character.isDigit(s.charAt(i + 1)))
      return true;
    return false;
  }

  static public <A, B> Map<A, B> putOrCreate(Map<A, B> map, A key, B value) {
    if (map == null)
      map = new HashMap();
    map.put(key, value);
    return map;
  }

  static public List<Integer> selectedTableRows(final JTable table) {
    return table == null ? null : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return asList(table.getSelectedRows());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return asList(table.getSelectedRows());";
      }
    });
  }

  static public boolean frameTooSmall(JFrame frame) {
    return frame.getWidth() < 100 || frame.getHeight() < 50;
  }

  static public boolean currentProgramHasLibrary(File f) {
    return contains(myLibraryFiles(), f);
  }

  static public void selectRow(final JTable table, final int i) {
    if (table != null) {
      swing(() -> {
        if (i >= 0 && i < table.getRowCount()) {
          table.setRowSelectionInterval(i, i);
          scrollRowToVisible(table, i);
        } else
          table.clearSelection();
      });
    }
  }

  static public void selectRow(final JList list, final int i) {
    if (list != null) {
      swing(() -> {
        if (i >= 0 && i < listRowCount(list))
          list.setSelectedIndex(i);
        else
          list.clearSelection();
      });
    }
  }

  static public Object dm_callStem(Object moduleOrID, String method, Object... args) {
    return call_withVarargs(dm_getStem(moduleOrID), method, args);
  }

  static public JScrollPane borderlessScrollPane(JScrollPane sp) {
    return setBorder(null, withoutViewportBorder(sp));
  }

  static public Map<Integer, Integer> rsyntaxTextArea_fixNumPad_map = litmap(KeyEvent.VK_UP, KeyEvent.VK_KP_UP, KeyEvent.VK_DOWN, KeyEvent.VK_KP_DOWN, KeyEvent.VK_LEFT, KeyEvent.VK_KP_LEFT, KeyEvent.VK_RIGHT, KeyEvent.VK_KP_RIGHT);

  static public boolean rsyntaxTextArea_fixNumPad_done = false;

  static public void rsyntaxTextArea_fixNumPad() {
    if (rsyntaxTextArea_fixNumPad_done)
      return;
    RSyntaxTextAreaDefaultInputMap inputMap = new RSyntaxTextAreaDefaultInputMap();
    for (KeyStroke key : inputMap.keys()) {
      Integer code = rsyntaxTextArea_fixNumPad_map.get(key.getKeyCode());
      if (code != null)
        inputMap.put(KeyStroke.getKeyStroke(code, key.getModifiers()), inputMap.get(key));
    }
    UIManager.put("RSyntaxTextAreaUI.inputMap", inputMap);
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public void printVars(Object... params) {
    printVars_str(params);
  }

  static public JSpinner dm_powersOfTwoSpinner(String field, int max) {
    SimpleLiveValue<Integer> lv = dm_fieldLiveValue(field);
    return bindLiveValueToSpinner(lv, jPowersOfTwoSpinner(max, lv.get()));
  }

  static public String formatDoubleFull(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '0');
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  static public <A extends Component> A _recordNewSwingComponent(A c) {
    if (c != null)
      callF((Object) vm_generalMap_get("newSwingComponentRegistry"), (Object) c);
    return c;
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  static public void clearConceptsOf(String progID) {
    getProgramFile(progID, "concepts.structure").delete();
    getProgramFile(progID, "concepts.structure.gz").delete();
    getProgramFile(progID, "idCounter.structure").delete();
  }

  static public String javaVersion() {
    return System.getProperty("java.version");
  }

  static public <A> JSpinner jListSpinner(List<A> entries) {
    return jListSpinner(entries, first(entries));
  }

  static public <A> JSpinner jListSpinner(List<A> entries, A defaultValue) {
    return swing(() -> {
      JSpinner s = new JSpinner();
      s.setModel(new SpinnerListModel(entries));
      if (contains(entries, defaultValue))
        setSpinnerValue(s, defaultValue);
      return s;
    });
  }

  static public ClassLoader getClassLoader(Object o) {
    return o == null ? null : _getClass(o).getClassLoader();
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public boolean bitMatrixRowEmpty(Matrix<Boolean> m, int y) {
    int w = m.getWidth();
    for (int x = 0; x < w; x++) if (m.get(x, y))
      return false;
    return true;
  }

  static public void catchError(DoneFlag doneFlag, Runnable r) {
    try {
      {
        if (r != null)
          r.run();
      }
    } catch (Throwable e) {
      doneFlag.setError(e);
    }
  }

  static public int hstackWithSpacing_spacing = 10;

  static public JPanel hstackWithSpacing(Object... parts) {
    parts = flattenArray2(parts);
    int spacing = hstackWithSpacing_spacing;
    int i = 0;
    if (first(parts) instanceof Integer) {
      spacing = toInt(first(parts));
      ++i;
    }
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.weighty = 1;
    gbc.fill = GridBagConstraints.VERTICAL;
    gbc.gridheight = GridBagConstraints.REMAINDER;
    for (; i < l(parts); i++) {
      if (i != 0)
        panel.add(javax.swing.Box.createRigidArea(new Dimension(spacing, 0)), gbc);
      panel.add(wrapForSmartAdd(parts[i]), gbc);
    }
    gbc.weightx = 1;
    panel.add(jrigid(), gbc);
    return panel;
  }

  static public AutoCloseable tempSetButtonImage(JButton btn, ImageIcon img) {
    if (btn == null)
      return null;
    return swing(() -> {
      Icon oldIcon = btn.getIcon();
      setButtonImage(btn, img);
      return new AutoCloseable() {

        public String toString() {
          return "setButtonImage(btn, oldIcon);";
        }

        public void close() throws Exception {
          setButtonImage(btn, oldIcon);
        }
      };
    });
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public String showFormSubmitButtonName() {
    return "Submit";
  }

  static public Q startQ() {
    return new Q();
  }

  static public Q startQ(String name) {
    return new Q(name);
  }

  static public double center(DoubleRange r) {
    return (r.start + r.end) / 2;
  }

  static public Pt center(Rect r) {
    return centerOfRect(r);
  }

  static public Pt center(int w, int h) {
    return pt(w / 2, h / 2);
  }

  static public <A, B extends Collection<A>> void forEachLevel2(Iterable<B> l, IVF1<A> f) {
    if (l != null)
      for (B b : l) forEach(b, f);
  }

  static public <A, B extends Collection<A>> void forEachLevel2(IVF1<A> f, Iterable<B> l) {
    forEachLevel2(f, l);
  }

  static public BufferedImage toBufferedImage(Object o) {
    return toBufferedImageOpt(o);
  }

  static public <A> SimplyLinkedList<A> toSimplyLinkedList(List<A> l) {
    SimplyLinkedList<A> sll = null;
    for (int i = l(l) - 1; i >= 0; i--) sll = SimplyLinkedList.cons(l.get(i), sll);
    return sll;
  }

  static public <A extends Concept> A uniq_returnIfNew(Class<A> c, Object... params) {
    return uniq_returnIfNew(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniq_returnIfNew(Concepts cc, Class<A> c, Object... params) {
    Pair<A, Boolean> p = uniq2(cc, c, params);
    return p.b ? p.a : null;
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int lastIndexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    for (int i = l(l) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> A getSelected(JList<A> l) {
    return getSelectedItem_typed(l);
  }

  static public <A> A getSelected(JComboBox<A> cb) {
    return getSelectedItem_typed(cb);
  }

  static public String structureOrText(Object o) {
    return o instanceof String ? (String) o : structure(o);
  }

  static public File myJar() {
    return first(myLibraryFiles());
  }

  static public boolean isOpeningBracket(String s) {
    return eqOneOf(s, "(", "{", "[");
  }

  static public <A extends IntSize> A assertNempty(A a) {
    return assertNempty("", a);
  }

  static public <A extends IntSize> A assertNempty(String msg, A a) {
    if (empty(a))
      throw fail(joinNemptiesWithColon(msg, str(a)));
    return a;
  }

  static public <A extends Collection> A assertNempty(A a) {
    return assertNempty("", a);
  }

  static public <A extends Collection> A assertNempty(String msg, A a) {
    if (empty(a))
      throw fail(joinNemptiesWithColon(msg, str(a)));
    return a;
  }

  static public <A extends String> A assertNempty(A a) {
    return assertNempty("", a);
  }

  static public <A extends String> A assertNempty(String msg, A a) {
    if (empty(a))
      throw fail(joinNemptiesWithColon(msg, str(a)));
    return a;
  }

  static public <A> A listGet(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l.size() ? l.get(idx) : null;
  }

  static public void addAndRevalidate(Container c, Component x) {
    addAndValidate(c, x);
  }

  static public String toStringOpt(Object o) {
    return o instanceof String ? ((String) o) : null;
  }

  static public CleanExit cleanExit(String msg) {
    throw new CleanExit(msg);
  }

  static public CleanExit cleanExit() {
    throw new CleanExit();
  }

  static public int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  static public int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnullForIteration(l)) n += cset(c, values);
    return n;
  }

  static public int csetAll(Concept c, Map<String, Object> values) {
    int n = 0;
    for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet(values)) {
      String field = __0.getKey();
      Object value = __0.getValue();
      n += cset(c, field, value);
    }
    return n;
  }

  static public java.util.Timer doAfter(long delay, Object r) {
    return doLater(delay, r);
  }

  static public java.util.Timer doAfter(long delay, Runnable r) {
    return doLater(delay, (Object) r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Object r) {
    return doLater(delaySeconds, r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Runnable r) {
    return doLater(delaySeconds, r);
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public JScrollPane borderless(JScrollPane sp) {
    return borderlessScrollPane(sp);
  }

  static public Dimension dimensionPlus(int w, int h, Dimension d) {
    return d == null ? null : new Dimension(d.width + w, d.height + h);
  }

  static public void caretToHome(JTextComponent c) {
    setCaret(c, 0);
  }

  static public <A> List<A> withoutNulls(Iterable<A> l) {
    if (l instanceof List)
      if (!containsNulls((List) l))
        return ((List) l);
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public JScrollPane enclosingScrollPane(Component c) {
    while (c.getParent() != null && !(c.getParent() instanceof JViewport) && c.getParent().getComponentCount() == 1) c = c.getParent();
    if (!(c.getParent() instanceof JViewport))
      return null;
    c = c.getParent().getParent();
    return c instanceof JScrollPane ? (JScrollPane) c : null;
  }

  static public JWindow infoBox_noHide(String message) {
    return infoBoxForever(message);
  }

  static public List<Integer> selectedTableRowsInModel(final JTable t) {
    return t == null ? emptyList() : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));";
      }
    });
  }

  static public String nLines(long n) {
    return n2(n, "line");
  }

  static public String nLines(Collection l) {
    return nLines(l(l));
  }

  static public String nLines(String s) {
    return nLines(countLines(s));
  }

  static public boolean jmenuItem_newThreads = false;

  static public JMenuItem jmenuItem(final String text) {
    return jMenuItem(text, null);
  }

  static public JMenuItem jmenuItem(final String text, final Object r) {
    return swing(new F0<JMenuItem>() {

      public JMenuItem get() {
        try {
          Pair<String, Integer> p = jmenu_autoMnemonic(dropPrefix("[disabled] ", text));
          JMenuItem mi = new JMenuItem(p.a);
          if (startsWith(text, "[disabled] "))
            disableMenuItem(mi);
          if (p.b != 0)
            mi.setMnemonic(p.b);
          mi.addActionListener(jmenuItem_newThreads ? actionListenerInNewThread(r) : actionListener(r));
          return mi;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Pair<S, Int> p = jmenu_autoMnemonic(dropPrefix(\"[disabled] \", text));\r\n    JM...";
      }
    });
  }

  static public double g22_regionFilledness(IImageRegion region) {
    return doubleRatio(region.numberOfPixels(), area(region.bounds()));
  }

  static public List<Integer> powersOfTwoUpTo(int n) {
    return powersOfTwoUpTo(1, n);
  }

  static public List<Integer> powersOfTwoUpTo(int firstPowerOfTwo, int n) {
    IntBuffer l = new IntBuffer();
    int i = firstPowerOfTwo;
    while (i <= n && i > 0) {
      l.add(i);
      i *= 2;
    }
    return l.asVirtualList();
  }

  static public int tableColumnCount(JTable table) {
    return tableNumColumns(table);
  }

  static public <A extends Component> A jMinWidth(final int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          c.setMinimumSize(new Dimension(w, size.height));
          return jPreferWidth(w, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    c.setMinimumSize(new Dimension(/*ma...";
      }
    });
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public void deleteConcepts(Collection conceptsOrIDs) {
    db_mainConcepts().deleteConcepts(asList(conceptsOrIDs));
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, Object... params) {
    return deleteConcepts(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, Object... params) {
    List<A> l = asList(findConceptsWhere(cc, c, params));
    deleteConcepts(l);
    return l;
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, IF1<A, Boolean> pred) {
    return deleteConcepts(db_mainConcepts(), c, pred);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, IF1<A, Boolean> pred) {
    var l = filter(list(cc, c), pred);
    deleteConcepts(l);
    return l;
  }

  static public List<Concept> deleteConcepts(Concepts cc) {
    return deleteConcepts(cc, Concept.class);
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public <A extends Component> A repaint(A c) {
    if (c != null)
      c.repaint();
    return c;
  }

  static public <A extends JComponent> A onFirstComponentShow(final A component, final Runnable onShow) {
    {
      swing(() -> {
        component.addAncestorListener(new AncestorListener() {

          public void ancestorAdded(AncestorEvent event) {
            component.removeAncestorListener(this);
            pcallF(onShow);
          }

          public void ancestorRemoved(AncestorEvent event) {
          }

          public void ancestorMoved(AncestorEvent event) {
          }
        });
      });
    }
    return component;
  }

  static public BufferedImage newImage(int w, int h) {
    return whiteImage(w, h);
  }

  static public BufferedImage newImage(int w, Color color) {
    return newImage(w, w, color);
  }

  static public BufferedImage newImage(int w, int h, Color color) {
    return bufferedImage(w, h, color);
  }

  static public BufferedImage newImage(int size) {
    return whiteImage(size);
  }

  static public BufferedImage newImage(Pt size) {
    return whiteImage(size.x, size.y);
  }

  static public BufferedImage newImage(WidthAndHeight size) {
    return whiteImage(size.w(), size.h());
  }

  static public BufferedImage newImage(Dimension size) {
    return whiteImage(size.width, size.height);
  }

  static public AutoCloseable tempDisableButton(final JButton b) {
    if (b == null)
      return null;
    boolean wasEnabled = swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          boolean wasEnabled = isEnabled(b);
          if (wasEnabled)
            disableButton(b);
          return wasEnabled;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool wasEnabled = isEnabled(b);\r\n    if (wasEnabled)\r\n      disableButton(b);...";
      }
    });
    if (!wasEnabled)
      return null;
    return new AutoCloseable() {

      public String toString() {
        return "enableButton(b);";
      }

      public void close() throws Exception {
        enableButton(b);
      }
    };
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public <A extends JComponent> A toolTipFromLiveValue(LiveValue lv, A c) {
    return bindToolTipToLiveValue(lv, c);
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public boolean usingStarter(Object mainObject) {
    return endsWith(className(getClassLoader(mainObject)), "StartClassLoader");
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String tok_moveImportsUp(String src) {
    return join(tok_moveImportsUp(javaTok(src)));
  }

  static public List<String> tok_moveImportsUp(List<String> tok) {
    StringBuilder buf = new StringBuilder();
    int i;
    Set<String> have = new HashSet();
    for (i = 1; i < l(tok); i += 2) if (eq(tok.get(i), "import")) {
      int j = indexOf(tok, i + 2, ";");
      if (j < 0)
        break;
      String s = joinSubList(tok, i, j + 1);
      have.add(s);
      i = j;
    } else
      break;
    List<IntRange> reToks = new ArrayList();
    for (; i < l(tok); i += 2) if (eq(tok.get(i), "import")) {
      int j = indexOf(tok, i + 2, ";");
      if (j < 0)
        continue;
      String s = joinSubList(tok, i, j + 1);
      if (!have.contains(s)) {
        buf.append(s).append("\n");
        have.add(s);
      }
      replaceTokens(tok, i, j + 1, "");
      reToks.add(intRange(i, j + 1));
      i -= 2;
    }
    if (nempty(buf)) {
      if (l(tok) == 1)
        addAll(tok, "", "");
      tok.set(1, str(buf) + "\n" + tok.get(1));
      reToks.add(intRange(1, 2));
    }
    return reTok_multi(tok, reToks);
  }

  static public <A> List<A> sortedByCalculatedField(Iterable<A> c, Object f) {
    return sortByCalculatedField(c, f);
  }

  static public <A> List<A> sortedByCalculatedField(Object f, Iterable<A> c) {
    return sortedByCalculatedField(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedField(IF1<A, B> f, Iterable<A> c) {
    return sortedByCalculatedField(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedField(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(a), f.get(b));
      }
    });
    return l;
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public List<String> codeTokens(List<String> tok) {
    return codeTokensOnly(tok);
  }

  static public List<File> listDirs(File dir) {
    if (dir == null)
      return emptyList();
    File[] files = dir.listFiles();
    List<File> l = new ArrayList();
    if (files != null)
      for (File f : files) if (f.isDirectory())
        l.add(f);
    return l;
  }

  static public List<File> listDirs(String dir) {
    return listDirs(newFile(dir));
  }

  static public <A> List<A> listPlus(Collection<A> l, A... more) {
    return concatLists(l, asList(more));
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public boolean sexyTable_drag = false;

  static public JTable sexyTable() {
    final JTable table = sexyTableWithoutDrag();
    if (sexyTable_drag)
      tableEnableTextDrag(table);
    return table;
  }

  static public boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
    return isConceptFieldIndexed(db_mainConcepts(), c, field);
  }

  static public boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
    return concepts.getFieldIndex(c, field) != null;
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public List<Integer> countIteratorToList_inclusive(int b) {
    return countIteratorToList_inclusive(0, b);
  }

  static public List<Integer> countIteratorToList_inclusive(int a, int b) {
    return asList(countIterator_inclusive(a, b));
  }

  static public <A> List<A> countIteratorToList_inclusive(int b, IF1<Integer, A> f) {
    return countIteratorToList_inclusive(0, b, f);
  }

  static public <A> List<A> countIteratorToList_inclusive(int a, int b, IF1<Integer, A> f) {
    return asList(countIterator_inclusive(a, b, f));
  }

  static public List<Integer> countIteratorToList_inclusive(int a, int b, int step) {
    return asList(countIterator_inclusive_step(a, b, step));
  }

  static public <A> List<A> countIteratorToList_inclusive(double a, double b, double step, IF1<Double, A> f) {
    return asList(countIterator_inclusive(a, b, step, f));
  }

  static public <A> List<Double> countIteratorToList_inclusive(double a, double b, double step) {
    return asList(countIterator_inclusive_step(a, b, step));
  }

  static public <A> List<A> countIteratorToList_inclusive(IF1<Double, A> f, double a, double b, double step) {
    return asList(countIterator_inclusive_step(a, b, step, f));
  }

  static public <A> List<A> countIteratorToList_inclusive(IF1<Integer, A> f, int a, int b) {
    return countIteratorToList_inclusive(f, a, b, 1);
  }

  static public <A> List<A> countIteratorToList_inclusive(IF1<Integer, A> f, int a, int b, int step) {
    return asList(countIterator_inclusive(a, b, step, f));
  }

  static public BufferedImage toBufferedImageOpt(Object o) {
    if (o instanceof BufferedImage)
      return ((BufferedImage) o);
    if (o instanceof Image)
      return copyImage((Image) o);
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    String c = getClassName(o);
    if (eqOneOf(c, "main$BWImage", "main$RGBImage"))
      return (BufferedImage) call(o, "getBufferedImage");
    return null;
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      {
        if (f != null)
          f.get(a);
      }
    } catch (Throwable __e) {
      pcallFail(__e);
    }
  }

  static public Object pcallF(Runnable r) {
    try {
      {
        if (r != null)
          r.run();
      }
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A> A pcallF(IF0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(IF1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      pcallFail(__e);
    }
    return null;
  }

  static public <A> List<A> listSetIntersection(Iterable<A> a, Collection<A> b) {
    List<A> l = new ArrayList();
    Set<A> bSet = asSet(b);
    for (A x : unnull(a)) if (bSet.contains(x))
      l.add(x);
    return l;
  }

  static public ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

  static public AutoCloseable holdInstance(Object o) {
    if (o == null)
      return null;
    listThreadLocalAdd(holdInstance_l, o);
    return new AutoCloseable() {

      public void close() {
        listThreadLocalPopLast(holdInstance_l);
      }
    };
  }

  static public void ownResource(AutoCloseable c) {
    _registerAutoCloseable(c);
  }

  static public float bwDistance(BWImage a, BWImage b, float maxDistance) {
    return 1f - bwImageSimilarityResized(a, b, 1f - maxDistance);
  }

  static public float bwDistance(BWImage a, BWImage b) {
    return bwDistance(a, b, 1f);
  }

  static public String tabsToSpaces(String s) {
    return tabsToSpaces(2, s);
  }

  static public String tabsToSpaces(int spacesPerTab, String s) {
    return replace(s, "\t", repSpace(spacesPerTab));
  }

  static public String makePostData(Map map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : castMapToMapO(map).entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String textOut_or(Collection l) {
    return textOut_or(l, "nothing");
  }

  static public String textOut_or(Collection l, String emptyText) {
    if (empty(l))
      return emptyText;
    List<String> separators = rep(", ", l(l) - 2);
    separators.add(" or ");
    return join_flex(separators, l);
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public <A extends Component> A packWindow(final A c) {
    {
      swing(() -> {
        Window w = getWindow(c);
        if (w != null)
          w.pack();
      });
    }
    return c;
  }

  static public boolean endsWithNewLine(String s) {
    return endsWith(s, "\n");
  }

  static public <A, B> IterableIterator<Pair<A, B>> multiMapPairIterator_transformValueList(MultiMap<A, B> mm, IF1<List<B>, List<B>> f) {
    return nestedIterator(iterator(keys(mm.data)), key -> (IterableIterator<Pair<A, B>>) mapI(iterator(f.get(mm.data.get(key))), val -> pair(key, val)));
  }

  static public int done_minPrint = 10;

  static public long done(long startTime, String desc) {
    long time = now() - startTime;
    if (time >= done_minPrint)
      print(desc + " [" + time + " ms]");
    return time;
  }

  static public long done(String desc, long startTime) {
    return done(startTime, desc);
  }

  static public long done(long startTime) {
    return done(startTime, "");
  }

  static public JMenuItem jMenuItem(final String text) {
    return jmenuItem(text);
  }

  static public JMenuItem jMenuItem(String text, Object r) {
    return jmenuItem(text, r);
  }

  static public File fileInSubDir(File f, String subDir) {
    if (f == null)
      return null;
    File dir = dirOfFile(f);
    return newFile(dir, subDir, f.getName());
  }

  static public File fileInSubDir(String subDir, File f) {
    return fileInSubDir(f, subDir);
  }

  static public File saveInImageDirectoryWithCounter(String subPath, BufferedImage img) {
    if (img == null)
      return null;
    assertNempty(subPath);
    File dir = imagesDir();
    if (!isImageFileName(subPath))
      subPath += ".png";
    File f = makeFileNameUnique_beforeExtension_startWith1_noDot(newFile(dir, subPath));
    saveImage(f, img);
    infoBox("Saved image " + appendBracketed(img.getWidth(null) + "*" + img.getHeight(null)) + ": " + fileInfo(f));
    return f;
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public void savePNGVerbose(BufferedImage img, File file) {
    try {
      savePNG(img, file);
      print("Saved PNG: " + f2s(file));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void savePNGVerbose(File file, BufferedImage img) {
    savePNGVerbose(img, file);
  }

  static public int indexOfTabNameWithoutTrailingCount(JTabbedPane tabs, String name) {
    if (tabs == null)
      return 1;
    return swing(() -> {
      var _name_1 = dropTrailingBracketedCount(name);
      int n = tabs.getTabCount();
      for (int i = 0; i < n; i++) if (eqic(_name_1, dropTrailingBracketedCount(tabs.getTitleAt(i))))
        return i;
      return -1;
    });
  }

  static public int tableRows(JTable table) {
    return (int) swingCall(table, "getRowCount");
  }

  static public <A> void setAddAll(Collection<A> a, Collection<A> b) {
    for (A x : b) setAdd(a, x);
  }

  static public int indexOfIC_underscore(String a, String b) {
    int la = l(a), lb = l(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    elsewhere: for (int i = 0; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c2 = b.charAt(j);
        if (c2 == '_' || eqic(c2, a.charAt(i + j))) {
        } else
          continue elsewhere;
      }
      return i;
    }
    return -1;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public void tablePopupMenuItem_top(final JTable table, final String name, final Object action) {
    tablePopupMenuFirst(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, row);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, row)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, row) });";
      }
    });
  }

  static public <A extends Image> A copyImageToClipboard(A img) {
    TransferableImage trans = new TransferableImage(img);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    vmBus_send("newClipboardContents", img);
    print("Copied image to clipboard (" + img.getWidth(null) + "*" + img.getHeight(null) + " px)");
    return img;
  }

  static public void setMeta(IMeta o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public void setMeta(Object o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public Pt ptMinus(Pt a, Pt b) {
    if (b == null)
      return a;
    return new Pt(a.x - b.x, a.y - b.y);
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static public List<String> regexpGetGroups(Matcher matcher) {
    int n = matcher.groupCount();
    List<String> l = new ArrayList();
    for (int i = 1; i <= n; i++) l.add(matcher.group(i));
    return l;
  }

  static public List<String> regexpGetGroups(String pat, String s) {
    Matcher m = regexpMatcher(pat, s);
    if (m.find())
      return regexpGetGroups(m);
    return null;
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, List parts) {
    for (Object o : parts) panel.add(wrapForSmartAdd(o), layout);
    return panel;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, Object... parts) {
    return smartAddWithLayout(panel, layout, asList(flattenArray2(parts)));
  }

  static public int menuItemCount(JMenu menu) {
    return menu == null ? 0 : swing(() -> menu.getItemCount());
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    Map m = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A key = __0.getKey();
      B val = __0.getValue();
      m.put(key, f.get(val));
    }
    return m;
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public <A, B, C> MultiMap<A, C> mapValues(IF1<B, C> func, MultiMap<A, B> mm) {
    return mapMultiMapValues(func, mm);
  }

  static public <A, B, C> MultiMap<A, C> mapValues(MultiMap<A, B> mm, IF1<B, C> func) {
    return mapValues(func, mm);
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public JProgressBar showProgressWindow(double maxValue) {
    return showProgressWindow(null, maxValue);
  }

  static public JProgressBar showProgressWindow(String text, double maxValue) {
    JProgressBar bar = jProgressBarWithText(iround(maxValue));
    swingCall(bar, "setString", text);
    centerFrame(packFrameVertically(500, showFrame(text, bar)));
    return bar;
  }

  static public TreeMap revTreeMap() {
    return new TreeMap(reverseComparator());
  }

  static public <A extends JLabel> A rightAlignLabel(final A a) {
    return setHorizontalAlignment(JLabel.RIGHT, a);
  }

  static public Object call_withVarargs(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(methodName, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(methodName);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + methodName + "(" + formatArgumentClasses(args) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(methodName);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + methodName + "(" + formatArgumentClasses(args) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> void replaceLastElement(List<A> l, A a) {
    if (nempty(l))
      l.set(l(l) - 1, a);
  }

  static public <A> A third(List<A> l) {
    return _get(l, 2);
  }

  static public <A> A third(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      if (!it.hasNext())
        return null;
      it.next();
    }
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A third(Producer<A> p) {
    if (p == null)
      return null;
    for (int _repeat_1 = 0; _repeat_1 < 2; _repeat_1++) {
      if (p.next() == null)
        return null;
    }
    return p.next();
  }

  static public <A> A third(A[] bla) {
    return bla == null || bla.length <= 2 ? null : bla[2];
  }

  static public <A, B, C> C third(T3<A, B, C> t) {
    return t == null ? null : t.c;
  }

  static public JScrollPane withoutViewportBorder(JScrollPane sp) {
    if (sp != null) {
      swing(() -> {
        sp.setViewportBorder(null);
      });
    }
    return sp;
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public Color getBackground(final Component c) {
    return c == null ? null : swing(new F0<Color>() {

      public Color get() {
        try {
          return c.getBackground();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getBackground();";
      }
    });
  }

  static public void addTab(JExtendedTabbedPane tabs, String title) {
    addTab(tabs, title, jpanel());
  }

  static public void addTab(JExtendedTabbedPane tabs, String title, Component c) {
    if (tabs != null) {
      swing(() -> {
        tabs.add(title, wrap(c));
      });
    }
  }

  static public void addTab(JExtendedTabbedPane tabs, String title, Swingable c) {
    if (tabs != null) {
      swing(() -> {
        tabs.add(title, wrap(c));
      });
    }
  }

  static public void addTab(JTabbedPane tabs, String title) {
    addTab(tabs, title, jpanel());
  }

  static public void addTab(JTabbedPane tabs, String title, Component c) {
    if (tabs != null) {
      swing(() -> {
        tabs.add(title, wrap(c));
      });
    }
  }

  static public void addTab(JTabbedPane tabs, String title, Swingable c) {
    if (tabs != null) {
      swing(() -> {
        tabs.add(title, wrap(c));
      });
    }
  }

  static public void addTab(JTabbedPane tabs, WithToolTip<String> title, Component c) {
    addTabWithToolTip(tabs, title.toolTip(), title == null ? null : title.get(), c);
  }

  static public void addTab(JTabbedPane tabs, WithToolTip<String> title, Swingable c) {
    addTabWithToolTip(tabs, title.toolTip(), title == null ? null : title.get(), c);
  }

  static public boolean hasJPEGExtension(File f) {
    return ewicOneOf(fileName(f), ".jpg", ".jpeg");
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
    return indexConceptFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
    ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
    return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public int lCommonPrefix(String a, String b) {
    int i = 0, n = Math.min(l(a), l(b));
    while (i < n && a.charAt(i) == b.charAt(i)) ++i;
    return i;
  }

  static public JComponent showErrorFrame(Throwable e) {
    if (e == null)
      return null;
    return showTextWordWrapped("Error", renderStackTrace((e)));
  }

  static public void maximizeOrRestoreFrame(JFrame f) {
    if (f == null)
      return;
    if (!isExtendedStateNormal(f)) {
      swing(() -> {
        f.setExtendedState(JFrame.NORMAL);
      });
    } else
      maximizeFrame(f);
  }

  static public File appendToFileName(File f, String suffix) {
    return fileAppendToName(f, suffix);
  }

  static public File appendToFileName(String suffix, File f) {
    return appendToFileName(f, suffix);
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public <A> A lowestByScoreFunction(Iterable<A> l, IF1<A, Number> f) {
    Lowest<A> lowest = new Lowest();
    for (A a : unnull(l)) {
      Number score = callF(f, a);
      if (score != null)
        lowest.put(a, toDouble(score));
    }
    return lowest.get();
  }

  static public void saveImage(File f, BufferedImage img) {
    if (hasJPEGExtension(f))
      saveJPG(f, img);
    else
      savePNG(f, img);
  }

  static public void saveImage(BufferedImage img, File f) {
    saveImage(f, img);
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public JInternalFrame getInternalFrame(final Object _o) {
    return _o == null ? null : swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JInternalFrame)
              return (JInternalFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public BWImage toBW(RGBImage img) {
    return img == null ? null : new BWImage(img);
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(BetterThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public String formatRecordVars(String recordName, Object... params) {
    return renderRecordVars(recordName, params);
  }

  static public F0 runnableToF0(Runnable r) {
    return r == null ? null : new F0<Object>() {

      public Object get() {
        try {
          r.run();
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "r.run(); null;";
      }
    };
  }

  static public <A> boolean syncRemove(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.remove(b);
    }
  }

  static public <A> A syncRemove(List<A> l, int idx) {
    if (l == null)
      return null;
    synchronized (collectionMutex(l)) {
      return l.remove(idx);
    }
  }

  static public <A, B> B syncRemove(Map<A, B> map, A key) {
    return map == null ? null : map.remove(key);
  }

  static public IterableIterator<Integer> countIterator_inclusive(final int a, final int b) {
    return countIterator_exclusive(a, b + 1);
  }

  static public <A> IterableIterator<A> countIterator_inclusive(int a, int b, IF1<Integer, A> f) {
    return countIterator_inclusive(a, b, 1, f);
  }

  static public <A> IterableIterator<A> countIterator_inclusive(int a, int b, int step, IF1<Integer, A> f) {
    return countIterator_inclusive_step(a, b, 1, f);
  }

  static public <A> IterableIterator<A> countIterator_inclusive(double a, double b, double step, IF1<Double, A> f) {
    return countIterator_inclusive_step(a, b, step, f);
  }

  static public JPanel vstack(Object... parts) {
    return vstack2(parts);
  }

  static public JPanel vstack(List parts) {
    return vstack(toObjectArray(parts));
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public Rect mouseArea(int w) {
    return mouseArea(w, w);
  }

  static public Rect mouseArea(int w, int h) {
    Point p = mouseLocation();
    return new Rect(p.x - w / 2, p.y - h / 2, w, h);
  }

  static public void disposePossiblyInternalFrame(Component c) {
    Container f = (Container) (getPossiblyInternalFrame(c));
    if (f instanceof JInternalFrame)
      disposeInternalFrame((JInternalFrame) f);
    else if (f instanceof Window)
      disposeWindow(f);
  }

  static public String exceptionType(Throwable e) {
    e = getInnerException(e);
    return shortClassName(e);
  }

  static public String rtrim_fromLines(Collection lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null) {
      boolean first = true;
      for (Object line : lines) {
        if (first)
          first = false;
        else
          buf.append('\n');
        buf.append(str(line));
      }
    }
    return buf.toString();
  }

  static public Map<JTable, VF1<JTable>> setTableModel_after = weakHashMap();

  static public Map<JTable, VF2<JTable, RowSorter>> setTableModel_fixSorter = weakHashMap();

  static public void setTableModel(final JTable table, final TableModel model) {
    {
      swing(() -> {
        Map<String, Integer> widths = tableColumnWidthsByName(table);
        int[] i = table.getSelectedRows();
        TableRowSorter sorter = model.getColumnCount() == tableColumnCount(table) ? (TableRowSorter) table.getRowSorter() : null;
        List<? extends RowSorter.SortKey> sortKeys = sorter == null ? null : sorter.getSortKeys();
        table.setModel(model);
        int n = model.getRowCount();
        ListSelectionModel sel = table.getSelectionModel();
        for (int j = 0; j < i.length; j++) if (i[j] < n)
          sel.addSelectionInterval(i[j], i[j]);
        tableSetColumnPreferredWidths(table, widths);
        if (sorter != null) {
          sorter.setModel(model);
          callF(setTableModel_fixSorter.get(table), table, sorter);
          if (sortKeys != null)
            sorter.setSortKeys(sortKeys);
        }
        table.setRowSorter(sorter);
        callF(setTableModel_after.get(table), table);
      });
    }
  }

  static public List<String> tabNames(JTabbedPane tabs) {
    return tabs == null ? null : swing(() -> countIteratorToList(tabs.getTabCount(), i -> tabs.getTitleAt(i)));
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] paramsPlus(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) {
      Object key = a2[i];
      if (key != null)
        map.put(key, a2[i + 1]);
    }
    return mapToParams(map);
  }

  static public Object[] paramsPlus(Map a1, Object... a2) {
    return paramsPlus(new Object[] { a1 }, a2);
  }

  static public ActionListener actionListener(final Object runnable) {
    return actionListener(runnable, null);
  }

  static public ActionListener actionListener(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    final Object info = _threadInfo();
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          _threadInheritInfo(info);
          AutoCloseable __1 = holdInstance(instanceToHold);
          try {
            pcallF(runnable);
          } finally {
            _close(__1);
          }
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public String str_shorten(Object o) {
    return shorten_str(o);
  }

  static public String str_shorten(Object o, int max) {
    return shorten_str(o, max);
  }

  static public String str_shorten(int max, Object o) {
    return shorten_str(max, o);
  }

  static public String formatUTCWithMS_24() {
    return formatUTCWithMS_24(now());
  }

  static public String formatUTCWithMS_24(long time) {
    var sdf = new SimpleDateFormat("HH:mm:ss.SSSS");
    sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    return sdf.format(time) + " UTC";
  }

  static public Rectangle rectangleUnion(Rectangle a, Rectangle b) {
    return a == null ? b : b == null ? a : a.union(b);
  }

  static public JCheckBox liveValueCheckBox(String text, IVarWithNotify<Boolean> lv) {
    return jLiveValueCheckBox(text, lv);
  }

  static public JCheckBox liveValueCheckBox(IVarWithNotify<Boolean> lv, String text) {
    return jLiveValueCheckBox(text, lv);
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void __setJavaX(Class j) {
    __javax = j;
    _onJavaXSet();
  }

  static public String conceptsDirName() {
    return conceptsDirName(db_mainConcepts());
  }

  static public String conceptsDirName(Concepts cc) {
    return fileName(cc.conceptsDir());
  }

  static public String fileInfo(File f) {
    return renderFileInfo(f);
  }

  static public String fileInfo(String f) {
    return renderFileInfo(newFile(f));
  }

  static public <A, B> Map<A, B> synchroIdentityHashMap() {
    return synchroMap(new IdentityHashMap());
  }

  static public String exceptionToStringShort(Throwable e) {
    try {
      lastException(e);
      e = getInnerException(e);
      String msg = hideCredentials(unnull(e.getMessage()));
      if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
        return baseClassName(e) + prependIfNempty(": ", msg);
      else
        return msg;
    } catch (Throwable _e) {
      printStackTrace(_e);
      return "Error in exceptionToStringShort";
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : getDeclaredConstructors_cached(c)) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public boolean isValidFileName(String s) {
    return nempty(s) && !eqOneOf(s, ".", "..") && all(characters(s), c -> isValidFileCharacter(c));
  }

  static public <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
    if (c == null)
      return null;
    {
      swing(() -> {
        String s = str_nullIfEmpty(toolTip);
        if (neq(s, c.getToolTipText()))
          c.setToolTipText(s);
      });
    }
    return c;
  }

  static public <A extends JComponent> A setToolTipText(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public void g22_highlightRegion(int[] pixels, ImageSurface is, Gazelle22_ImageToRegions itr, boolean showRegionsAsOutline) {
    g22_highlightRegion(pixels, is, itr, is.mousePosition, showRegionsAsOutline);
  }

  static public void g22_highlightRegion(int[] pixels, ImageSurface is, Gazelle22_ImageToRegions itr, Pt mouse, boolean showRegionsAsOutline) {
    if (mouse != null && itr != null && itr.regions != null) {
      int iHighlightedRegion = itr.regions.regionAt(mouse);
      g22_highlightRegion(pixels, itr, iHighlightedRegion, showRegionsAsOutline);
    }
  }

  static public void g22_highlightRegion(int[] pixels, Gazelle22_ImageToRegions itr, int iRegion, boolean showRegionsAsOutline) {
    g22_highlightRegion(pixels, itr, iRegion, 0xFF00C000, showRegionsAsOutline);
  }

  static public void g22_highlightRegion(int[] pixels, Gazelle22_ImageToRegions itr, int iRegion, int color, boolean showRegionsAsOutline) {
    if (iRegion == 0)
      return;
    if (showRegionsAsOutline) {
      RegionBorder_innerPoints x = new RegionBorder_innerPoints(itr.regions, iRegion);
      gazelle22_highlightRegionOutline(pixels, itr, x);
    } else
      itr.regions.markRegionInPixelArray(pixels, iRegion, color);
  }

  static public JPanel makeForm_customLayout(final F1<Container, Dimension> layouter, final Object... parts) {
    return makeForm_customArrangement(new F1<List<JComponent>, JPanel>() {

      public JPanel get(List<JComponent> components) {
        try {
          return customLayoutPanel(layouter, components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "customLayoutPanel(layouter, components)";
      }
    }, parts);
  }

  static public <A extends JComponent, B> A bindToolTipToTransformedLiveValue(IF1<B, Object> f, LiveValue<B> lv, A c) {
    bindLiveValueListenerToComponent(c, lv, new Runnable() {

      public void run() {
        try {
          setToolTipText(c, strOrNull(f.get(lv.get())));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setToolTipText(c, strOrNull(f.get(lv!)))";
      }
    });
    return c;
  }

  static public AutoCloseable tempAddToWindow(JWindow w, Component toAdd) {
    if (w == null || toAdd == null)
      return null;
    return swing(() -> {
      var oldContent = w.getContentPane();
      setContentPane(w, centerAndSouth(oldContent, toAdd));
      return () -> setContentPane(w, oldContent);
    });
  }

  static public AutoCloseable tempAddToWindow(JFrame w, Component toAdd) {
    if (w == null || toAdd == null)
      return null;
    return swing(() -> {
      var oldContent = w.getContentPane();
      setContentPane(w, centerAndSouth(oldContent, toAdd));
      return () -> setContentPane(w, oldContent);
    });
  }

  static public AutoCloseable tempEnter(Object o) {
    return o == null ? null : optCast(AutoCloseable.class, rcallOpt("enter", o));
  }

  static public AutoCloseable tempEnter(Enterable o) {
    return o == null ? null : o.enter();
  }

  static public Object[] arrayPlus(Object[] a1, Object... a2) {
    return concatArrays(a1, a2);
  }

  static public boolean sameSize(WidthAndHeight a, BufferedImage b) {
    return a != null && b != null && a.getWidth() == b.getWidth() && a.getHeight() == b.getHeight();
  }

  static public boolean sameSize(BufferedImage b, WidthAndHeight a) {
    return sameSize(a, b);
  }

  static public <A, B> IF1<A, B> f1ToIF1(F1<A, B> f) {
    return f == null ? null : a -> f.get(a);
  }

  static public Rect leftScreenBounds() {
    return first(allScreenBounds());
  }

  static public AutoCloseable tempInfoBox(String msg) {
    return tempDisposeWindow(infoBox(msg));
  }

  static public String joinNemptiesWithColon(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColon(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public void tableEnableDrag(final JTable table, TransferHandler th) {
    if (table.getDragEnabled()) {
      print("Table drag already enabled");
      return;
    }
    table.setDragEnabled(true);
    table.setTransferHandler(th);
    table.addMouseListener(new MouseAdapter() {

      @Override
      public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 1)
          table.getTransferHandler().exportAsDrag(table, e, TransferHandler.COPY);
      }
    });
  }

  static public IProgressShower tempProgressBar_addToWindowIfPossible(JWindow window, String text) {
    return tempProgressBar_addToWindowIfPossible(window, text, 1);
  }

  static public IProgressShower tempProgressBar_addToWindowIfPossible(JWindow window, String text, double total) {
    if (!isVisibleWindow(window))
      return tempProgressBar(text, total);
    JProgressBar bar = jProgressBarWithText(iround(total), text);
    var closeable = tempAddToWindow(window, withMargin(jCenteredRaisedSection(text, bar)));
    return new IProgressShower() {

      public void setValue(double value) {
        setProgressBarValue(bar, iround(value));
      }

      public void setTotal(double total) {
        setProgressBarTotal(bar, iround(total));
      }

      public void setText(String text) {
        setProgressBarText(bar, print(text));
      }

      public void close() {
        _close(closeable);
      }
    };
  }

  static public IProgressShower tempProgressBar_addToWindowIfPossible(JFrame window, String text) {
    return tempProgressBar_addToWindowIfPossible(window, text, 1);
  }

  static public IProgressShower tempProgressBar_addToWindowIfPossible(JFrame window, String text, double total) {
    if (!isVisibleWindow(window))
      return tempProgressBar(text, total);
    JProgressBar bar = jProgressBarWithText(iround(total), text);
    var closeable = tempAddToWindow(window, withMargin(jCenteredRaisedSection(text, bar)));
    return new IProgressShower() {

      public void setValue(double value) {
        setProgressBarValue(bar, iround(value));
      }

      public void setTotal(double total) {
        setProgressBarTotal(bar, iround(total));
      }

      public void setText(String text) {
        setProgressBarText(bar, print(text));
      }

      public void close() {
        _close(closeable);
      }
    };
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public List<String> ciSorted(Collection<String> c) {
    return sortedIgnoreCase(c);
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    setDynObjectValue(o, key, value);
    return o;
  }

  static public void setDyn(IMeta o, String key, Object value) {
    metaMapPut(o, key, value);
  }

  static public Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  static public <A, B> B secondOfPair(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public BWImage posterizeBWImage_withMeta(int brightnessLevels, BufferedImage img) {
    return posterizeBWImage_withMeta(brightnessLevels, toBWImage(img));
  }

  static public BWImage posterizeBWImage_withMeta(int brightnessLevels, BWImage img) {
    PosterizeBWImage x = new PosterizeBWImage(brightnessLevels, img);
    x.run();
    return setMetaSrcUnlessSame(img, x.result, x);
  }

  static public <A> boolean containsPred(IF1<A, Boolean> pred, Iterable<A> l) {
    return any(pred, l);
  }

  static public <A> boolean containsPred(Iterable<A> l, IF1<A, Boolean> pred) {
    return any(pred, l);
  }

  static public long saveGZStructureToFile(String file, Object o) {
    return saveGZStructureToFile(getProgramFile(file), o);
  }

  static public long saveGZStructureToFile(File file, Object o) {
    return saveGZStructureToFile(file, o, new structure_Data());
  }

  static public long saveGZStructureToFile(File file, Object o, structure_Data data) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      File tempFile = tempFileFor(file);
      if (tempFile.exists())
        try {
          String saveName = tempFile.getPath() + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      CountingOutputStream cos;
      try {
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        cos = new CountingOutputStream(gos);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(cos, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        structureToPrintWriter(o, printWriter, data);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      } catch (Throwable e) {
        fileOutputStream.close();
        tempFile.delete();
        throw rethrow(e);
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
      return cos.getFilePointer();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JTextField jLiveTextField(SimpleLiveValue<String> lv) {
    return jLiveValueTextField_bothWays(lv);
  }

  static public <A> List<A> replaceAll(List<A> l, final A a, final A b) {
    return map(l, new F1<A, A>() {

      public A get(A x) {
        try {
          return eq(x, a) ? b : x;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "eq(x, a) ? b : x";
      }
    });
  }

  static public String replaceAll(String s, String a, String b) {
    return s == null ? null : s.replaceAll(a, b);
  }

  static public int cmpAlphanumIC(String a, String b) {
    return cmpAlphaNum(a, b);
  }

  static public <A> A collectionGet(Collection<A> c, int idx) {
    if (c == null || idx < 0 || idx >= l(c))
      return null;
    if (c instanceof List)
      return listGet((List<A>) c, idx);
    Iterator<A> it = c.iterator();
    for (int i = 0; i < idx; i++) if (it.hasNext())
      it.next();
    else
      return null;
    return it.hasNext() ? it.next() : null;
  }

  static public void frameStandardSize(JFrame frame) {
    frame.setBounds(300, 100, 500, 400);
  }

  static public JToggleButton jToggleButton(String text, Runnable action) {
    var btn = basicJToggleButton(text);
    addActionListener(btn, action);
    return btn;
  }

  static public int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public int hashCode(long l) {
    return Long.hashCode(l);
  }

  static public int hashCode(double d) {
    return Double.hashCode(d);
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static public boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public AutoCloseable tempInfoBoxNoHide(String msg) {
    return tempInfoBox_noHide(msg);
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, Rectangle b) {
    return rectContains(a, toRect(b));
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public boolean rectContains(Rect a, Pt p) {
    return a != null && p != null && a.contains(p);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    return linesFromReader(r, null);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r, IResourceHolder resourceHolder) {
    final BufferedReader br = bufferedReader(r);
    return holdResource(resourceHolder, iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r)));
  }

  static public CloseableIterableIterator<String> linesFromReader(InputStream in) {
    return linesFromReader(inputStreamReader(in));
  }

  static public int length(Object[] array) {
    return array == null ? 0 : array.length;
  }

  static public int length(List list) {
    return list == null ? 0 : list.size();
  }

  static public int length(String s) {
    return s == null ? 0 : s.length();
  }

  static public <A extends Window> A onWindowDeiconified(A w, Runnable r) {
    if (w != null && r != null) {
      swing(() -> {
        w.addWindowListener(new WindowAdapter() {

          public void windowDeiconified(WindowEvent e) {
            try {
              r.run();
            } catch (Throwable __e) {
              pcallFail(__e);
            }
          }
        });
      });
    }
    return w;
  }

  static public JButton enableButton(JButton b) {
    return enableButton(b, true);
  }

  static public JButton enableButton(JButton b, boolean enable) {
    if (b != null) {
      swing(() -> {
        b.setEnabled(enable);
      });
    }
    return b;
  }

  static public int clampToInt(long l) {
    return (int) clamp(l, Integer.MIN_VALUE, Integer.MAX_VALUE);
  }

  static public <A, B> MultiSet<A> multiSetMapToMultiSet(MultiSetMap<A, B> mm) {
    MultiSet<A> ms = new MultiSet();
    for (A a : keys(mm)) ms.add(a, l(mm.get(a)));
    return ms;
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public <A extends IMeta> A setMetaSrc(A a, Object src) {
    setMetaAndVerify(a, "src", src);
    return a;
  }

  static public <A> A setMetaSrc(A a, Object src) {
    setMetaAndVerify(a, "src", src);
    return a;
  }

  static public int totalPreferredHeight(List<Component> l) {
    int h = 0;
    for (Component c : unnull(l)) h += c.getPreferredSize().height;
    return h;
  }

  static public int indexOfTabName(JTabbedPane tabs, String name) {
    return tabs == null ? -1 : swing(() -> tabs.indexOfTab(name));
  }

  static public Object[] assertEvenLength(Object[] a) {
    assertTrue(even(l(a)));
    return a;
  }

  static public <A extends Component> A packWindowVertically(A c) {
    final Window win = getWindow(c);
    if (win == null)
      return c;
    final int w = win.getWidth();
    packWindow(win);
    {
      swing(() -> {
        win.setSize(w, win.getHeight());
      });
    }
    return c;
  }

  static public Runnable _topLevelErrorHandling(Runnable r) {
    if (r == null)
      return null;
    Object info = _threadInfo();
    Object mod = dm_current_generic();
    Runnable r2 = r;
    if (info != null || mod == null)
      r2 = new Runnable() {

        public void run() {
          try {
            AutoCloseable __1 = (AutoCloseable) (rcall("enter", mod));
            try {
              _threadInheritInfo(info);
              r.run();
            } finally {
              _close(__1);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp (AutoCloseable) rcall enter(mod);\r\n      _threadInheritInfo(info);\r\n    ...";
        }
      };
    r2 = rPcall(r2);
    return r2;
  }

  static public void setSpinnerValue(JSpinner s, int value) {
    setSpinnerValue(s, (Integer) value);
  }

  static public void setSpinnerValue(JSpinner s, Object value) {
    try {
      if (s != null) {
        swing(() -> {
          s.setValue(value);
        });
      }
    } catch (Throwable __e) {
      pcallFail(__e);
    }
  }

  static public RasterBars reproduceRasterBars(IBWIntegralImage ii) {
    var thinImage = scaledBWImageFromBWIntegralImage_withMeta(ii, 1, ii.getHeight());
    var streaks = streaksOfRepeatingElements(listFromFunction(thinImage.getHeight(), y -> thinImage.getInt(0, y)));
    return new RasterBars(ii.getWidth(), ii.getHeight(), streaks);
  }

  static public void onUpdateAndNow(JComponent c, final Object r) {
    onUpdate(c, r);
    callF(r);
  }

  static public void onUpdateAndNow(JTextComponent c, IVF1<String> r) {
    swing(() -> {
      if (c == null)
        return;
      onUpdate(c, r);
      callF(r, c.getText());
    });
  }

  static public void onUpdateAndNow(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
    callF(r);
  }

  static public void sleepUntilSysTime(long sysTime) {
    sleepUntilSys(sysTime);
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel jRaisedSection(Component c) {
    return jRaisedSection("", c);
  }

  static public JPanel jRaisedSection(final String title, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          Border border = BorderFactory.createBevelBorder(BevelBorder.RAISED);
          border = BorderFactory.createTitledBorder(border, title);
          JPanel panel = new SingleComponentPanel(c);
          panel.setBorder(border);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Border border = BorderFactory.createBevelBorder(BevelBorder.RAISED);\r\n    bor...";
      }
    });
  }

  static public JPanel jRaisedSection(String title) {
    return jRaisedSection(title, new JPanel());
  }

  static public JRootPane getRootPane(Component c) {
    Component f = (Component) getPossiblyInternalFrame(c);
    return f instanceof RootPaneContainer ? (JRootPane) swingCall(f, "getRootPane") : null;
  }

  static public String stackTraceForThread(Thread t) {
    return t == null ? null : lines(t.getStackTrace());
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(asList(l));
  }

  static public void waitWhileTrue(BoolVar var) {
    {
      if (var != null)
        var.waitUntilFalse();
    }
  }

  static public <A> LiveValue<A> dm_transientCalculatedLiveValue(Class type, IF0<A> calc) {
    return dm_transientCalculatedLiveValue(dm_current_mandatory(), type, calc);
  }

  static public <A> LiveValue<A> dm_transientCalculatedLiveValue(DynModule mod, Class type, IF0<A> calc) {
    Lock __0 = mod.lock;
    lock(__0);
    try {
      SimpleLiveValue value = new SimpleLiveValue(type, calc.get());
      mod.onFieldChange(new VF1<String>() {

        public void get(String field) {
          try {
            value.set(calc.get());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "value.set(calc!)";
        }
      });
      return value;
    } finally {
      unlock(__0);
    }
  }

  static public LiveValue<Object> dm_transientCalculatedLiveValue(IF0<Object> calc) {
    return dm_transientCalculatedLiveValue(Object.class, calc);
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        vmBus_send("locking", lock, "thread", currentThread());
        lock.lockInterruptibly();
        vmBus_send("locked", lock, "thread", currentThread());
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public JLabel jboldLabel(String text) {
    return makeLabelBold(jlabel(text));
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public <A> A swingNu(final Class<A> c, final Object... args) {
    return swingConstruct(c, args);
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else {
        r = addThreadInfoToRunnable(r);
        executingSwingCode(r);
        EventQueue.invokeAndWait(r);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public String firstToLower(String s) {
    if (empty(s))
      return s;
    return Character.toLowerCase(s.charAt(0)) + s.substring(1);
  }

  static public void pcallFAll_minimalExceptionHandling(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        ping();
        pcallF_minimalExceptionHandling(f, args);
      }
  }

  static public void pcallFAll_minimalExceptionHandling(Iterator it, Object... args) {
    while (it.hasNext()) {
      ping();
      pcallF_minimalExceptionHandling(it.next(), args);
    }
  }

  static public IntRange intRangeWithLen(int start, int len) {
    return new IntRange(start, start + len);
  }

  static public File picturesDir() {
    return imagesDir();
  }

  static public File picturesDir(String sub) {
    return newFile(picturesDir(), sub);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public <A> A getSelectedItem_typed(JList<A> l) {
    return swing(() -> l.getSelectedValue());
  }

  static public <A> A getSelectedItem_typed(JComboBox<A> cb) {
    return swing(() -> (A) cb.getSelectedItem());
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public int methodApplicabilityScore_onTypes(Method m, Class[] argTypes) {
    return methodApplicabilityScore_onTypes((Executable) m, argTypes);
  }

  static public int methodApplicabilityScore_onTypes(Executable m, Class[] argTypes) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != argTypes.length)
      return Integer.MAX_VALUE;
    int score = 0;
    for (int i = 0; i < types.length; i++) {
      Class a = argTypes[i];
      Class c = types[i];
      if (c == a) {
      } else if (isSubclassOf(a, c))
        ++score;
      else
        return Integer.MAX_VALUE;
    }
    return score;
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public JLabel jcenteredLabel(String text) {
    return setHorizontalAlignment(JLabel.CENTER, jLabel(text));
  }

  static public JLabel jcenteredLabel() {
    return jcenteredLabel(" ");
  }

  static public JTable dataToTable(Object data) {
    return dataToTable(showTable(), data);
  }

  static public JTable dataToTable(Object data, String title) {
    return dataToTable(showTable(title), data);
  }

  static public JTable dataToTable(JTable table, Object data) {
    return dataToTable(table, data, false);
  }

  static public JTable dataToTable(JTable table, Object data, boolean now) {
    List<List> rows = new ArrayList();
    List<String> cols = new ContentsIndexedList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrTextForUser(key), structureOrTextForUser(value)));
      }
    } else if (data != null)
      print("Unknown data type: " + data);
    fillTableWithData(table, rows, cols);
    return table;
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem_dyn(String text, IF0<Boolean> checked, Object r) {
    JCheckBoxMenuItem mi = jCheckBoxMenuItem(text, false, r);
    if (checked != null)
      bindToComponent(mi, new Runnable() {

        public void run() {
          try {
            boolean b = isTrue(checked.get());
            setChecked(mi, b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "boolean b = isTrue(checked!);\r\n    ifdef jCheckBoxMenuItem_dyn_debug\r\n      p...";
        }
      }, new Runnable() {

        public void run() {
          try {
            ;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef jCheckBoxMenuItem_dyn_debug\r\n      print(\"jCheckBoxMenuItem_dyn: hiding...";
        }
      });
    return mi;
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem_dyn(String text, IF0<Boolean> checked, IVF1<Boolean> r) {
    return jCheckBoxMenuItem_dyn(text, checked, (Object) r);
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public <A extends Component> A packInternalFrameVertically(A c) {
    return packInternalFrameVertically(-1, c);
  }

  static public <A extends Component> A packInternalFrameVertically(int width, A c) {
    final JInternalFrame win = getInternalFrame(c);
    if (win == null)
      return c;
    final int w = width < 0 ? win.getWidth() : width;
    {
      swing(() -> {
        win.pack();
        win.setSize(w, win.getHeight());
        fixInternalFrame(win);
      });
    }
    return c;
  }

  static public <A> ThreadLocal<A> threadLocalWithDefault(A defaultValue) {
    return new ThreadLocal<A>() {

      public A initialValue() {
        return defaultValue;
      }
    };
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null) {
      var it = l.iterator();
      if (it.hasNext()) {
        var pingSource = pingSource();
        do {
          ping(pingSource);
          x.add(f.get(it.next()));
        } while (it.hasNext());
      }
    }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    List x = new ArrayList();
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) {
        ping();
        x.add(f.get(e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B> List<A> map(IF1<A, B> f, A data1, A... moreData) {
    List x = emptyList(l(moreData) + 1);
    x.add(f.get(data1));
    if (moreData != null)
      for (A o : moreData) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public int indexOfFirst(List l, Object pred) {
    return indexOfPred(l, pred);
  }

  static public <A, B> int indexOfFirst(List<A> l, IF1<A, B> pred) {
    return indexOfPred(l, pred);
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public void disposeWindowOnClick(final Window window) {
    AWTEventListener l = new AWTEventListener() {

      public void eventDispatched(AWTEvent evt) {
        if (!window.isVisible()) {
          Toolkit.getDefaultToolkit().removeAWTEventListener(this);
          return;
        }
        if (!(evt instanceof MouseEvent))
          return;
        Object source = evt.getSource();
        if (source == window && evt.getID() == MouseEvent.MOUSE_PRESSED) {
          Toolkit.getDefaultToolkit().removeAWTEventListener(this);
          window.dispose();
        }
      }
    };
    Toolkit.getDefaultToolkit().addAWTEventListener(l, AWTEvent.MOUSE_EVENT_MASK);
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public <A extends Comparable<A>> A max(Iterable<A> l) {
    A max = null;
    var it = iterator(l);
    if (it.hasNext()) {
      max = it.next();
      while (it.hasNext()) {
        A a = it.next();
        if (cmp(a, max) > 0)
          max = a;
      }
    }
    return max;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public <A extends Comparable<A>> A max(A a, A b) {
    return cmp(a, b) >= 0 ? a : b;
  }

  static public void fillJMenu(final JMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof List)
        fillJMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o)) {
        if (menuItemCount(m) != 0)
          m.addSeparator();
      } else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem(or2(unCurlyBracket(lv.get()), "..."), y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
              revalidate(m);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv!;\r\n        if (isCurlyBracketed(s)) {\r\n          setEnabled(mi,...";
          }
        });
        print("bound live value " + lv + " to menu item " + mi);
        m.add(mi);
        ++i;
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o == null && y instanceof Runnable)
        ++i;
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  static public <B> TreeMap<String, B> asCIMap(Map<String, B> map) {
    return asCaseInsensitiveMap(map);
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public <A> JComboBox<A> jTypedComboBox(Collection<A> items) {
    return swing(() -> new JComboBox<A>(toVector(items)));
  }

  static public <A> JComboBox<A> jTypedComboBox(Collection<A> items, A selectedItem) {
    return selectItem(selectedItem, jTypedComboBox(items));
  }

  static public boolean canCallWithVarargs(Object o, String method, Object... args) {
    if (o == null)
      return false;
    if (o instanceof Class) {
      Class c = (Class) o;
      _MethodCache cache = callOpt_getCache(c);
      if (cache.findStaticMethod(method, args) != null)
        return true;
      List<Method> methods = cache.cache.get(method);
      if (methods != null)
        methodSearch: for (Method m : methods) {
          {
            if (!(m.isVarArgs() && isStaticMethod(m)))
              continue;
          }
          if (massageArgsForVarArgsCall(m, args) != null)
            return true;
        }
    } else {
      Class c = o.getClass();
      _MethodCache cache = callOpt_getCache(c);
      if (cache.findMethod(method, args) != null)
        return true;
      List<Method> methods = cache.cache.get(method);
      if (methods != null)
        methodSearch: for (Method m : methods) {
          {
            if (!(m.isVarArgs()))
              continue;
          }
          if (massageArgsForVarArgsCall(m, args) != null)
            return true;
        }
    }
    return false;
  }

  static public double nsToMicroseconds(double ns) {
    return nanosToMicroseconds(ns);
  }

  static public <A extends AutoCloseable> A holdResource(IResourceHolder holder, A a) {
    {
      if (holder != null)
        holder.add(a);
    }
    return a;
  }

  static public int[] selectedTableRows_array(final JTable table) {
    return table == null ? null : swing(new F0<int[]>() {

      public int[] get() {
        try {
          return table.getSelectedRows();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return table.getSelectedRows();";
      }
    });
  }

  static public <A> List<A> listWithoutIndicesInBitSet(List<A> l, BitSet bs) {
    List<A> out = new ArrayList();
    for (int i = 0; i < l(l); i++) if (!bs.get(i))
      out.add(l.get(i));
    return out;
  }

  static public <A> A waitUntilVarSet(Var<A> v) {
    try {
      synchronized (v) {
        while (!v.has()) v.wait();
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A waitUntilVarSet(Var<A> v, int timeout) {
    try {
      synchronized (v) {
        long time = nanoTime();
        while (!v.has() && (nanoTime() - time) < timeout * 900000) v.wait(timeout);
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Throwable _storeException_value;

  static public void _storeException(Throwable e) {
    _storeException_value = e;
  }

  static public void deleteFileVerbose_assertSuccess(File file) {
    if (!deleteFileVerbose(file))
      throw fail("Couldn't delete " + file);
  }

  static public RGBImage loadImage(String snippetIDOrURL) {
    return new RGBImage(loadBufferedImage(snippetIDOrURL));
  }

  static public RGBImage loadImage(File f) {
    return new RGBImage(loadBufferedImage(f));
  }

  static public JPanel withSideMargin(Component c) {
    return withLeftAndRightMargin(c);
  }

  static public JPanel withSideMargin(int w, Component c) {
    return withLeftAndRightMargin(w, c);
  }

  static public JPanel withSideMargin(int w1, int w2, Component c) {
    return withLeftAndRightMargin(w1, w2, c);
  }

  static public <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
    List<A> l = tl.get();
    if (l == null)
      return null;
    A a = popLast(l);
    if (empty(l))
      tl.set(null);
    return a;
  }

  static public <A> JSpinner jPowersOfTwoSpinner(int max, int defaultValue) {
    return jPowersOfTwoSpinner(1, max, defaultValue);
  }

  static public <A> JSpinner jPowersOfTwoSpinner(int min, int max, int defaultValue) {
    var powers = powersOfTwoUpTo(max);
    if (min > 1)
      powers = filter(powers, x -> x >= min);
    return rightAlignSpinner(jListSpinner(powers, defaultValue));
  }

  static public <A> List<A> nullPlus(Collection<A> l) {
    return itemPlusList(null, l);
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public float floatRatio(float x, float y) {
    return y == 0 ? 0 : x / y;
  }

  static public <A> A listGetOrCreate(List<A> l, int i, Class<? extends A> c) {
    return listGetOrCreate(l, i, () -> nuInstance(c));
  }

  static public <A> A listGetOrCreate(List<A> l, int i, IF0<A> f) {
    if (l == null)
      return null;
    A a = get(l, i);
    if (a == null)
      listSet(l, i, a = f.get());
    return a;
  }

  static public <A> A listGetOrCreate(Class<? extends A> c, List<A> l, int i) {
    return listGetOrCreate(l, i, c);
  }

  static public int tableColumnViewIndex(final JTable t, final String colName) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());";
      }
    });
  }

  static public List<String> standardImports_fullyImportedPackages() {
    return endingWith_dropSuffix(standardImports(), ".*");
  }

  static public <A extends JComponent> A awtEveryAndNow(A component, long delay, Object r) {
    swingEvery(component, delay, 0, r);
    return component;
  }

  static public <A extends JComponent> A awtEveryAndNow(A component, long delay, Runnable r) {
    return awtEveryAndNow(component, delay, (Object) r);
  }

  static public <A extends JComponent> A awtEveryAndNow(A component, double delaySeconds, Object r) {
    return awtEveryAndNow(component, toMS(delaySeconds), r);
  }

  static public <A extends JComponent> A awtEveryAndNow(A component, double delaySeconds, Runnable r) {
    return awtEveryAndNow(component, toMS(delaySeconds), r);
  }

  static public void awtEveryAndNow(RootPaneContainer frame, long delay, Object r) {
    swingEvery(frame, delay, 0, r);
  }

  static public <A, B> Set<Map.Entry<A, B>> entries(Map<A, B> map) {
    return _entrySet(map);
  }

  static public void disposeInternalFrame(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(() -> {
        vmBus_send("disposingInternalFrame", f);
        f.dispose();
      });
    }
  }

  static public int indexOfLine(String text, String sub) {
    return indexOf(lines_iterator(text), sub);
  }

  static public String jextract(String pat, String s) {
    return jextract(pat, javaTok(s));
  }

  static public String jextract(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    jfind_preprocess(tokpat);
    int i = jfind(tok, tokpat);
    if (i < 0)
      return null;
    int j = i + l(tokpat) - 2;
    return joinSubList(tok, i, j);
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return new SynchronizedMap(map);
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public boolean tableSetColumnPreferredWidths_debug = false;

  static public void tableSetColumnPreferredWidths(final JTable table, final Map<String, Integer> widths) {
    if (table == null || widths == null)
      return;
    {
      swing(() -> {
        try {
          TableColumnModel tcm = table.getColumnModel();
          int n = tcm.getColumnCount();
          for (int i = 0; i < n; i++) {
            TableColumn tc = tcm.getColumn(i);
            Integer w = widths.get(str(tc.getHeaderValue()));
            if (w != null) {
              tc.setPreferredWidth(w);
              if (tableSetColumnPreferredWidths_debug)
                print("Setting preferred width of column " + i + " to " + w);
            }
          }
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      });
    }
  }

  static public void tableSetColumnPreferredWidths(JTable table, Object... widths) {
    tableSetColumnPreferredWidths(table, litorderedmap(widths));
  }

  static public Object deref(Object o) {
    if (o instanceof IRef)
      return ((IRef) o).get();
    return o;
  }

  static public boolean addLibraryToCurrentProgram(String libID) {
    return addLibraryToCurrentProgram(loadLibrary(libID));
  }

  static public boolean addLibraryToCurrentProgram(File f) {
    try {
      if (f == null || currentProgramHasLibrary(f))
        return false;
      ClassLoader cl = myClassLoader();
      return isTrue(call(cl, "addFile", f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel centerAndEastWithMargins(Component c, Component e) {
    return applyDefaultMargin(centerAndEast(c, withLeftMargin(e)));
  }

  static public <A> void setComboBoxItems(JComboBox<A> cb, Collection<A> items) {
    if (cb != null) {
      swing(() -> {
        cb.setModel(new DefaultComboBoxModel(new Vector(items)));
      });
    }
  }

  static public <A> A println(A a) {
    return print(a);
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll((Map) b);
    return a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
    if (a != null)
      litmap_impl(a, b);
    return a;
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public List<JMenuItem> getMenuItems(JMenu menu) {
    if (menu == null)
      return null;
    return nonNulls(countIterator(menu.getItemCount(), i -> menu.getItem(i)));
  }

  static public List<JMenuItem> getMenuItems(JPopupMenu menu) {
    if (menu == null)
      return null;
    return instancesOf(JMenuItem.class, asList(menu.getSubElements()));
  }

  static public void cMigrateField(Concept c, String oldField, String newField) {
    if (c == null)
      return;
    Object oldValue = cget(c, oldField);
    Object newValue = cget(c, newField);
    if (oldValue != null && newValue == null) {
      try {
        String name = shortDynName(c);
        print("Migrating " + name + "." + oldField + " -> " + name + "." + newField + " [id " + c.id + "]");
        cset(c, newField, oldValue);
        cset(c, oldField, null);
      } catch (Throwable __e) {
        pcallFail(__e);
      }
    }
  }

  static public void _onJavaXSet() {
  }

  static public String dropSuffix(String suffix, String s) {
    return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public Map syncHashMap() {
    return synchroHashMap();
  }

  static public Pt toPt(Point p) {
    return p == null ? null : new Pt(p.x, p.y);
  }

  static public Pt toPt(Dimension d) {
    return d == null ? null : new Pt(d.width, d.width);
  }

  static public <A> A evalWithTimeoutOrTypedException(int timeoutMS, IF0<A> f) {
    return evalWithTimeoutOrTypedException(toSeconds(timeoutMS), f);
  }

  static public <A> A evalWithTimeoutOrTypedException(double timeoutSeconds, IF0<A> f) {
    Either<A, Thread> e = evalWithTimeout(timeoutSeconds, f);
    if (e.isA())
      return (A) e.a();
    throw new TimeoutException_Inner(timeoutSeconds, f, e.b());
  }

  static public <A> MultiSetMap<Object, A> generalizedCIMultiSetMap() {
    MultiSetMap<Object, A> mm = new MultiSetMap();
    mm.data = generalizedCIMap();
    return mm;
  }

  static public int scoredSearch_score_single(String s, String query) {
    int i = indexOfIC_underscore(s, query);
    if (i < 0)
      return 0;
    if (i > 0)
      return 1;
    return l(s) == l(query) ? 3 : 2;
  }

  static public <A> Set<A> synchroHashSet() {
    return synchronizedSet(new HashSet<A>());
  }

  static public String stringify(IStringifier stringifier, Object o) {
    return stringifier == null ? str(o) : stringifier.toString(o);
  }

  static public TreeMap descTreeMap() {
    return revTreeMap();
  }

  static public int getMinimumHeight(final Component c) {
    return getMinimumSize(c).height;
  }

  static public <A, B> B syncGetOrCreate(Map<A, B> map, A key, Class<? extends B> c) {
    try {
      synchronized (map) {
        return getOrCreate(map, key, c);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> B syncGetOrCreate(Map<A, B> map, A key, Object f) {
    synchronized (map) {
      return getOrCreate(map, key, f);
    }
  }

  static public <A, B> B syncGetOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
    return syncGetOrCreate(map, key, c);
  }

  static public <A, B> B syncGetOrCreate(Map<A, B> map, A key, IF0<B> f) {
    synchronized (map) {
      return getOrCreate(map, key, f);
    }
  }

  static public JComponent withCenteredBoldTitle(String title, Component c) {
    return withTitle(jCenteredBoldLabel(title), c);
  }

  static public JScrollPane jHigherScrollPane(final JComponent c) {
    return swing(() -> new JScrollPane(c) {

      public Dimension getPreferredSize() {
        Component view = getViewport().getView();
        if (view == null)
          return super.getPreferredSize();
        int pref_width = view.getPreferredSize().width;
        setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        Dimension dim = new Dimension(pref_width, super.getPreferredSize().height + getHorizontalScrollBar().getSize().height);
        setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        return dim;
      }
    });
  }

  static public JFastLogView_noWrap showText_fast_noWrap(String title, Object text) {
    return showText_fast_noWrap(null, title, text);
  }

  static public JFastLogView_noWrap showText_fast_noWrap(JFastLogView_noWrap view, String title, Object text) {
    if (view != null) {
      view.setText(str(text));
      return view;
    }
    view = jFastLogView_noWrap(str(text));
    makeFrame(title, jscroll_copyBackground(view));
    return view;
  }

  static public JFastLogView_noWrap showText_fast_noWrap(Object text) {
    return showText_fast_noWrap(autoFrameTitle(), text);
  }

  static public JScrollPane jBorderlessHigherScrollPane(JComponent c) {
    return borderlessScrollPane(jHigherScrollPane(c));
  }

  static public boolean isComponentShowing(final Component c) {
    return c != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return c.isShowing();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.isShowing();";
      }
    });
  }

  static public <A extends JComponent> A focusOnFirstShowVerbose(A a) {
    return onFirstComponentShow(a, () -> {
      print("Focusing on first show: " + a);
      focus(a);
    });
  }

  static public <A, B> B syncMapGetOrCreate(Map<A, B> map, A key, Class<? extends B> c) {
    return syncGetOrCreate(map, key, c);
  }

  static public <A, B> B syncMapGetOrCreate(Map<A, B> map, A key, Object f) {
    return syncGetOrCreate(map, key, f);
  }

  static public <A, B> B syncMapGetOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
    return syncGetOrCreate(c, map, key);
  }

  static public <A, B> B syncMapGetOrCreate(Map<A, B> map, A key, IF0<B> f) {
    return syncGetOrCreate(map, key, f);
  }

  static public JComponent withCenteredTitle(String title, Component c) {
    return withTitle(jCenteredLabel(title), c);
  }

  static public <A> List<A> syncListGetMulti(final List<A> l, List<Integer> indices) {
    synchronized (collectionMutex(l)) {
      return listGetMulti(l, indices);
    }
  }

  static public <A> boolean removeAll(Collection<A> a, Collection<A> b) {
    return a != null && b != null && a.removeAll(b);
  }

  static public <A, B> void removeAll(Map<A, B> a, Collection<A> b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public <A, B extends A> boolean removeAll(Collection<A> c, B... b) {
    return c != null && b != null && c.removeAll(Arrays.asList(b));
  }

  static public <A, B> void removeAll(Map<A, B> a, A... b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public String yesNo2(Boolean b) {
    return eq(b, true) ? "Yes" : eq(b, false) ? "No" : "Unknown";
  }

  static public Dimension getMinimumSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getMinimumSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getMinimumSize();";
      }
    });
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public IterableIterator<Integer> countIterator_inclusive_backwards(int a, int b) {
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i >= b;
      }

      public Integer next() {
        return i--;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_inclusive_backwards(int a, int b, IF1<Integer, A> f) {
    return mapI_if1(f, countIterator_inclusive_backwards(a, b));
  }

  static public <A extends Concept> Collection<A> findConcepts(Class<A> c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public Collection<Concept> findConcepts(String c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public <A extends Concept> Collection<A> findConcepts(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public Collection<Concept> findConcepts(Concepts concepts, String c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public void dm_onFieldChange(String field, Runnable onChange) {
    dm_watchField(field, onChange);
  }

  static public void dm_onFieldChange(Collection<String> fields, Runnable onChange) {
    dm_watchFields(fields, onChange);
  }

  static public Pt longToPt(long l) {
    return new Pt(firstIntFromLong(l), secondIntFromLong(l));
  }

  static public JMenuItem disableMenuItem(final JMenuItem mi) {
    if (mi != null) {
      swing(() -> {
        mi.setEnabled(false);
      });
    }
    return mi;
  }

  static public Object swingCall(final Object o, final String method, final Object... args) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return call(o, method, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return call(o, method, args);";
      }
    });
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public String getText(final AbstractButton c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getText();";
      }
    });
  }

  static public String getText(final JTextComponent c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getText();";
      }
    });
  }

  static public String getText(final JLabel l) {
    return l == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return l.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return l.getText();";
      }
    });
  }

  static public String getText(final JComboBox cb) {
    if (cb == null)
      return null;
    if (isEditableComboBox(cb))
      return unnull((String) cb.getEditor().getItem());
    else
      return strOrNull(cb.getSelectedItem());
  }

  static public Pt mouseLocationPt() {
    return mousePointer();
  }

  static public <A, B extends Iterable<A>> IterableIterator<List<A>> outerProduct(List<B> lists) {
    return outerProduct_faster(lists);
  }

  static public <A, B> List<B> pairsB(Collection<Pair<A, B>> l) {
    return secondOfPairs(l);
  }

  static public List<String> toLinesFullTrim(String s) {
    List<String> l = new ArrayList();
    for (String line : toLines(s)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public List<String> toLinesFullTrim(File f) {
    List<String> l = new ArrayList();
    for (String line : linesFromFile(f)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW, int newH) {
    return resizeImage(img, newW, newH, Image.SCALE_SMOOTH);
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW, int newH, int scaleType) {
    if (newW == img.getWidth() && newH == img.getHeight())
      return img;
    Image tmp = img.getScaledInstance(newW, newH, scaleType);
    BufferedImage dimg = new BufferedImage(newW, newH, BufferedImage.TYPE_INT_ARGB);
    Graphics2D g2d = dimg.createGraphics();
    g2d.drawImage(tmp, 0, 0, null);
    g2d.dispose();
    return dimg;
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW) {
    int newH = iround(img.getHeight() * (double) newW / img.getWidth());
    return resizeImage(img, newW, newH);
  }

  static public BufferedImage resizeImage(int newW, BufferedImage img) {
    return resizeImage(img, newW);
  }

  static public MouseAdapter onMouseDown_anyButton(Component c, Runnable r) {
    return onMouseDown(c, runnableToIVF1(r));
  }

  static public MouseAdapter onMouseDown_anyButton(Component c, IVF1<MouseEvent> f) {
    return c == null || f == null ? null : swing(() -> {
      MouseAdapter ma = new MouseAdapter() {

        public void mousePressed(MouseEvent e) {
          f.get(e);
        }
      };
      c.addMouseListener(ma);
      return ma;
    });
  }

  static public <A> TreeMap<Object, A> generalizedCIMap() {
    return new TreeMap(generalizedCIComparator());
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public int dualLog(int i) {
    return 32 - Integer.numberOfLeadingZeros(max(0, i - 1));
  }

  static public ThreadLocal<Random> customRandomizerForThisThread_tl = new ThreadLocal();

  static public ThreadLocal<Random> customRandomizerForThisThread_tl() {
    return customRandomizerForThisThread_tl;
  }

  static public int incAtomicInt(AtomicInteger i) {
    return i.incrementAndGet();
  }

  static public int incAtomicInt(AtomicInteger i, int delta) {
    return i.addAndGet(delta);
  }

  static public Thread newThread(Object runnable) {
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public Color lightBlue_cache;

  static public Color lightBlue() {
    if (lightBlue_cache == null)
      lightBlue_cache = lightBlue_load();
    return lightBlue_cache;
  }

  static public Color lightBlue_load() {
    return colorFromHex("4169e1");
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public JTable onDoubleClickOrEnter(JTable table, Runnable runnable) {
    return onDoubleClickOrEnter(table, (Object) runnable);
  }

  static public JTable onDoubleClickOrEnter(final JTable table, Object runnable) {
    onDoubleClick(table, runnable);
    onEnter(table, runnable);
    return table;
  }

  static public JList onDoubleClickOrEnter(final JList list, final Object runnable) {
    onDoubleClick(list, runnable);
    onEnter(list, runnable);
    return list;
  }

  static public JTable onDoubleClickOrEnter(Object runnable, JTable table) {
    return onDoubleClickOrEnter(table, runnable);
  }

  static public <B> TreeMap<String, B> asCaseInsensitiveMap(Map<String, B> map) {
    if (isCIMap(map))
      return (TreeMap) map;
    TreeMap<String, B> m = ciMap();
    putAll(m, map);
    return m;
  }

  static public JList onDoubleClick(final JList list, final Object runnable) {
    {
      swing(() -> {
        list.addMouseListener(new MouseAdapter() {

          public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
              int idx = list.locationToIndex(evt.getPoint());
              Object item = list.getModel().getElementAt(idx);
              list.setSelectedIndex(idx);
              callF(runnable, item);
            }
          }
        });
      });
    }
    return list;
  }

  static public JTable onDoubleClick(final JTable table, final Object runnable) {
    {
      swing(() -> {
        table.addMouseListener(new MouseAdapter() {

          public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
              int idx = table.rowAtPoint(evt.getPoint());
              table.setRowSelectionInterval(idx, idx);
              callF(runnable, idx);
            }
          }
        });
      });
    }
    return table;
  }

  static public void onDoubleClick(final JComponent c, final Object runnable) {
    {
      swing(() -> {
        c.addMouseListener(new MouseAdapter() {

          public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() == 1 && evt.getClickCount() == 2)
              callF(runnable, evt.getPoint());
          }
        });
      });
    }
  }

  static public LookAndFeel currentLAF() {
    return UIManager.getLookAndFeel();
  }

  static public void addWeakChangeListener(IHasChangeListeners src, ChangeTriggerable target) {
    addWeakChangeListener(src, target, o -> o.change());
  }

  static public <A> void addWeakChangeListener(IHasChangeListeners src, A target, IVF1<A> action) {
    if (src == null || action == null || target == null)
      return;
    var ref = weakRef(target);
    src.onChange(new Runnable() {

      public void run() {
        try {
          var target = ref.get();
          if (target == null)
            src.removeChangeListener(this);
          else
            action.get(target);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var target = ref!;\r\n    if (target == null)\r\n      src.removeChangeListener(t...";
      }
    });
  }

  static public String lines_possiblyRTrim(String originalText, List<String> lines) {
    return endsWithNewLine(originalText) ? lines(lines) : lines_rtrim(lines);
  }

  static public String lines_possiblyRTrim(List<String> lines, String originalText) {
    return lines_possiblyRTrim(originalText, lines);
  }

  static public void hideTrayIcon(TrayIcon t) {
    removeTrayIcon(t);
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public <A extends Comparable<A>> A min(A a, A b) {
    return cmp(a, b) <= 0 ? a : b;
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, int destPos, int n) {
    arraycopy(src, srcPos, src, destPos, n);
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public int numberOfScreens() {
    return screenCount();
  }

  static public int showForm_defaultGap = 4;

  static public int showForm_gapBetweenColumns = 10;

  static public JPanel showFormTitled(final String title, final Object... _parts) {
    JDesktopPane desktop = mainDesktopPane();
    if (desktop != null)
      return showInternalFrameFormTitled(desktop, title, _parts);
    return swing(() -> {
      JPanel panel = showForm_makePanel(false, _parts);
      showForm_makeFrame(title, panel);
      return panel;
    });
  }

  static public JPanel showForm_makePanel(Boolean internalFrame, Object... _parts) {
    List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
    return vstackWithSpacing(out, showForm_defaultGap);
  }

  static public List<String> standardImports_cache;

  static public List<String> standardImports() {
    if (standardImports_cache == null)
      standardImports_cache = standardImports_load();
    return standardImports_cache;
  }

  static public List<String> standardImports_load() {
    return ll("java.util.*", "java.util.zip.*", "java.util.List", "java.util.regex.*", "java.util.concurrent.*", "java.util.concurrent.atomic.*", "java.util.concurrent.locks.*", "java.util.function.*", "javax.swing.*", "javax.swing.event.*", "javax.swing.text.*", "javax.swing.table.*", "java.io.*", "java.net.*", "java.lang.reflect.*", "java.lang.ref.*", "java.lang.management.*", "java.security.*", "java.security.spec.*", "java.awt.*", "java.awt.event.*", "java.awt.image.*", "java.awt.geom.*", "javax.imageio.*", "java.math.*", "java.time.Duration", "java.lang.invoke.VarHandle", "java.lang.invoke.MethodHandles");
  }

  static public String currentProcessCommand() {
    ProcessHandle processHandle = ProcessHandle.current();
    return getVar(processHandle.info().command());
  }

  static public class mapI_It extends IterableIterator {

    public Object f;

    public Iterator i;

    public mapI_It() {
    }

    public mapI_It(Object f, Iterator i) {
      this.i = i;
      this.f = f;
    }

    public boolean hasNext() {
      return i.hasNext();
    }

    public Object next() {
      return callF(f, i.next());
    }

    public String toString() {
      return formatFunctionCall("mapI", f, i);
    }
  }

  static public IterableIterator mapI(final Object f, final Iterator i) {
    return new mapI_It(f, i);
  }

  static public IterableIterator mapI(IterableIterator i, Object f) {
    return mapI((Iterator) i, f);
  }

  static public IterableIterator mapI(Object f, IterableIterator i) {
    return mapI((Iterator) i, f);
  }

  static public IterableIterator mapI(Iterator i, Object f) {
    return mapI(f, i);
  }

  static public <A, B> IterableIterator<B> mapI(Iterable<A> i, IF1<A, B> f) {
    return new MapI(f, iterator(i));
  }

  static public <A, B> IterableIterator<B> mapI(Iterator<A> i, IF1<A, B> f) {
    return new MapI(f, i);
  }

  static public <A, B> IterableIterator<B> mapI(IterableIterator<A> i, IF1<A, B> f) {
    return new MapI(f, i);
  }

  static public <A, B> IterableIterator<B> mapI(IF1<A, B> f, Iterable<A> i) {
    return new MapI(f, iterator(i));
  }

  static public IterableIterator mapI(Iterable i, Object f) {
    return mapI(f, i.iterator());
  }

  static public IterableIterator mapI(Object f, Iterable i) {
    return mapI(i, f);
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public <B, A extends B> A addAndReturn(List<B> c, int idx, A a) {
    if (c != null)
      c.add(idx, a);
    return a;
  }

  static public boolean dirExists(String path) {
    return path != null && new File(path).isDirectory();
  }

  static public boolean dirExists(File f) {
    return f != null && f.isDirectory();
  }

  static public String hostNameFromURL(String url) {
    try {
      return empty(url) ? null : new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String mainClassNameForClassLoader(ClassLoader cl) {
    return or((String) callOpt(cl, "mainClassName"), "main");
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public List collectField(Iterable c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  static public List collectField(String field, Iterable c) {
    return collectField(c, field);
  }

  static public JSpinner rightAlignSpinner(JSpinner spinner) {
    setHorizontalAlignment(JTextField.RIGHT, getTextFieldFromSpinner(spinner));
    return spinner;
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public int selectedTableRowInModel(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          int i = t.getSelectedRow();
          return i < 0 ? i : t.convertRowIndexToModel(i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "int i = t.getSelectedRow();\r\n    ret i < 0 ? i : t.convertRowIndexToModel(i);";
      }
    });
  }

  static public double scaleToFitInside(BufferedImage image, Component c) {
    return scaleToFitInside(image, c.getWidth(), c.getHeight());
  }

  static public double scaleToFitInside(BufferedImage image, int w) {
    return scaleToFitInside(image, w, w);
  }

  static public double scaleToFitInside(BufferedImage image, int w, int h) {
    int iw = image.getWidth(), ih = image.getHeight();
    return min(doubleRatio(h, ih), doubleRatio(w, iw));
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public JProgressBar jProgressBarWithText() {
    return swing(() -> {
      JProgressBar bar = new JProgressBar();
      bar.setStringPainted(true);
      return bar;
    });
  }

  static public JProgressBar jProgressBarWithText(int maxValue) {
    JProgressBar bar = jProgressBarWithText();
    {
      swing(() -> {
        bar.setMaximum(maxValue);
      });
    }
    return bar;
  }

  static public JProgressBar jProgressBarWithText(int maxValue, String text) {
    var bar = jProgressBarWithText(maxValue);
    {
      swing(() -> {
        bar.setString(text);
      });
    }
    return bar;
  }

  static public JProgressBar jProgressBarWithText(String text) {
    var bar = jProgressBarWithText();
    {
      swing(() -> {
        bar.setString(text);
      });
    }
    return bar;
  }

  static public File byteCodePathForClass(Class c) {
    if (c == null)
      return null;
    ClassLoader cl = getClassLoader(c);
    Collection<File> files = (Collection<File>) (getOpt(cl, "files"));
    if (files != null) {
      String name = c.getName().replace('.', '/') + ".class";
      for (File location : files) if (dirOrZipContainsPath(location, name))
        return location;
      throw fail(name + " not found in: " + files);
    }
    return null;
  }

  static public File byteCodePathForClass(Object o) {
    return byteCodePathForClass(_getClass(o));
  }

  static public <A extends JComponent> A fontSizePlus(final int delta, final A c) {
    if (c != null) {
      swing(() -> {
        Font font = c.getFont();
        c.setFont(font.deriveFont(font.getSize2D() + delta));
      });
    }
    return c;
  }

  static public JLabel jCenteredLabel(String text) {
    return jcenteredLabel(text);
  }

  static public JLabel jCenteredLabel() {
    return jcenteredLabel();
  }

  static public void renameFileVerbose_assertSuccess(File a, File b) {
    if (!renameFileVerbose(a, b))
      throw fail("Couldn't rename " + a + " to " + b);
  }

  static public IMeta initMetaOfJComponent(JComponent c) {
    if (c == null)
      return null;
    IMeta meta = (IMeta) (c.getClientProperty(IMeta.class));
    if (meta == null)
      c.putClientProperty(IMeta.class, meta = new Meta());
    return meta;
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public boolean isScreenCoordinateInWindow(Pt p, Component c) {
    Window w = getWindow(c);
    return w != null && w.isShowing() && toRect(boundsOnScreen(w)).contains(p);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    return linesFromFile(f, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f, IResourceHolder resourceHolder) {
    try {
      if (!fileExists(f))
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)), resourceHolder);
      return linesFromReader(utf8bufferedReader(f), resourceHolder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(path, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(String path, IResourceHolder resourceHolder) {
    return linesFromFile(newFile(path), resourceHolder);
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public List flattenToList(Object... l) {
    Flattener f = new Flattener();
    f.add(l);
    return f.toList();
  }

  static public <A> List<A> itemPlusList(A a, Collection<A> l) {
    return concatLists(ll(a), l);
  }

  static public <A extends Component> A revalidate(final A c) {
    if (c == null || !c.isShowing())
      return c;
    {
      swing(() -> {
        c.revalidate();
        c.repaint();
      });
    }
    return c;
  }

  static public void revalidate(JFrame f) {
    revalidate((Component) f);
  }

  static public void revalidate(JInternalFrame f) {
    revalidate((Component) f);
  }

  static public List<Character> stringAsCharacterList(final String s) {
    if (s == null)
      return null;
    return new RandomAccessAbstractList<Character>() {

      final public int l = l(s);

      public int size() {
        return l;
      }

      public Character get(int i) {
        return s.charAt(i);
      }
    };
  }

  static public <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public Concept unlisted(String name, Object... args) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    try {
      return cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public Timestamp tsNowPlusMS(long ms) {
    return tsNow().plus(msToSeconds(ms));
  }

  static public Timestamp tsNowPlusMS(double ms) {
    return tsNow().plus(msToSeconds(ms));
  }

  static public GlobalID aGlobalIDObj() {
    return asGlobalID(randomID(16));
  }

  static public GlobalID aGlobalIDObj(Random random) {
    return asGlobalID(randomID(random, 16));
  }

  static public <A> void replaceLast(List<A> l, A a) {
    replaceLastElement(l, a);
  }

  static public JButton jbuttonWithDisable(String name, Runnable action) {
    return jbutton(name, disableButtonWhileCalcing3(action));
  }

  static public int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public <A> List<A> immutableEmptyList() {
    return Collections.emptyList();
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public Set<Thread> evalWithTimeout_inTime = synchroSet();

  static public Set<Thread> evalWithTimeout_allThreads = newWeakHashSet();

  static public ThreadLocal<String> evalWithTimeout_threadName = new ThreadLocal();

  static public <A> Either<A, Thread> evalWithTimeout(double timeoutSeconds, IF0<A> r) {
    return (Either) evalWithTimeout(timeoutSeconds, (Object) r);
  }

  static public Either<Object, Thread> evalWithTimeout(int timeoutMS, Object r) {
    return evalWithTimeout(toSeconds(timeoutMS), r);
  }

  static public Either<Object, Thread> evalWithTimeout(double timeoutSeconds, Object r) {
    final Flag done = new Flag();
    final Flag doneWaiting = new Flag();
    final Var var = new Var();
    final Var<Throwable> error = new Var();
    var printer = print_byThread().get();
    Thread t = newThread(getAndClearThreadLocal(evalWithTimeout_threadName), new Runnable() {

      public void run() {
        try {
          try {
            AutoCloseable __1 = tempSetTL(print_byThread(), printer);
            try {
              try {
                var.set(callF(r));
              } finally {
                evalWithTimeout_allThreads.remove(currentThread());
              }
            } finally {
              _close(__1);
            }
          } catch (Throwable e) {
            error.set(e);
            if (doneWaiting.isUp())
              printStackTrace_inPossiblyCancelledThread(e);
          } finally {
            done.raise();
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      temp tempSetTL(print_byThread(), printer);\r\n      \r\n      try {\r...";
      }
    });
    beforeDelegatingToThread(t);
    try {
      startThread(t);
      evalWithTimeout_inTime.add(t);
      evalWithTimeout_allThreads.add(t);
      try {
        done.waitUntilUp(timeoutSeconds);
        doneWaiting.raise();
      } finally {
        evalWithTimeout_inTime.remove(t);
      }
      if (!done.isUp()) {
        print("Cancelling thread (timeout)");
        cancelAndInterruptThread(t);
        return either2(t);
      }
      if (error.get() != null)
        rethrow(error.get());
      return either1(var.get());
    } finally {
      afterDelegatingToThread(t);
    }
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public IConceptIndex simpleConceptIndex(final Runnable r) {
    return new IConceptIndex() {

      public void update(Concept c) {
        pcallF(r);
      }

      public void remove(Concept c) {
        pcallF(r);
      }
    };
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public void setComponent(SingleComponentPanel scp, Component c) {
    setSCPComponent(scp, c);
  }

  static public void setComponent(SingleComponentPanel scp, IF0<Component> c) {
    if (scp != null)
      setComponent(scp, callF(c));
  }

  static public MenuItem menuItem(String text, final Object r) {
    MenuItem mi = new MenuItem(text);
    mi.addActionListener(actionListener(r));
    return mi;
  }

  static public MenuItem menuItem(String text, Runnable r) {
    MenuItem mi = new MenuItem(text);
    mi.addActionListener(actionListener(r));
    return mi;
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public <A> SimpleLiveValue<A> varWithNotifyToLiveValue(Class<A> type, IVarWithNotify<A> var) {
    if (var == null)
      return null;
    var lv = new SimpleLiveValue<A>(type);
    var lvRef = weakRef(lv);
    var.onChange(new Runnable() {

      public void run() {
        try {
          var lv = lvRef.get();
          if (lv == null)
            var.removeChangeListener(this);
          else {
            var value = var.get();
            lv.set(value);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var lv = lvRef!;\r\n    print ifdef varWithNotifyToLiveValue_debug(\"varWithNoti...";
      }
    });
    lv.onChange(() -> var.set(lv.get()));
    lv.set(var.get());
    return lv;
  }

  static public <A> Comparator<A> reverseComparator(Comparator<A> c) {
    return (a, b) -> c.compare(b, a);
  }

  static public <A> Comparator<A> reverseComparator() {
    return (a, b) -> cmp(b, a);
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public <A, B> IterableIterator<Pair<A, B>> multiMapPairIterator(MultiMap<A, B> mm) {
    return nestedIterator(iterator(keys(mm.data)), key -> (IterableIterator<Pair<A, B>>) mapI(iterator(mm.data.get(key)), val -> pair(key, val)));
  }

  static public List<String> classNamesInJigsawModule(String moduleName) {
    return classNamesInJigsawModule(moduleName, javaHome());
  }

  static public List<String> classNamesInJigsawModule(String moduleName, File javaHome) {
    return classNamesInJarOrDir(jigsawModuleFile(moduleName, javaHome), "classes/");
  }

  static public short[] emptyShortArray = new short[0];

  static public short[] emptyShortArray() {
    return emptyShortArray;
  }

  static public JDesktopPane mainDesktopPane_value;

  static public JDesktopPane mainDesktopPane() {
    return mainDesktopPane_value;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public void tableDependButtons(JTable table, List<? extends Component> buttons) {
    for (Component c : buttons) if (c instanceof JButton) {
      JButton b = (JButton) c;
      onTableSelectionChangedAndNow(table, () -> b.setEnabled(table.getSelectedRow() >= 0));
    }
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static File DiskSnippetCache_getLibrary(String snippetID) {
    try {
      return DiskSnippetCache_getLibrary(psI(snippetID));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public ZipFile zipFile(File f) {
    return openZipFile(f);
  }

  static public <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JButton tableDependentButton(JTable tbl, String text) {
    return tableDependentButton(tbl, text, null);
  }

  static public JButton tableDependentButton(JTable tbl, String text, Runnable action) {
    return tableDependButton(tbl, jbutton(text, action));
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public JComponent unwrapScrollPane(JScrollPane sp) {
    return sp == null ? null : (JComponent) sp.getViewport().getView();
  }

  static public JComboBox jLiveValueComboBox(Collection<String> values, IVarWithNotify<String> lv) {
    final JComboBox cb = jComboBox(values);
    bindComboBoxToLiveValue(cb, lv);
    return cb;
  }

  static public JComboBox jLiveValueComboBox(IVarWithNotify<String> lv, Collection<String> values) {
    return jLiveValueComboBox(values, lv);
  }

  static public int packFrame_minw = 150, packFrame_minh = 50;

  static public <A extends Component> A packFrame(final A c) {
    {
      swing(() -> {
        Window w = getWindow(c);
        if (w != null) {
          w.pack();
          int maxW = getScreenWidth() - 50, maxH = getScreenHeight() - 50;
          w.setSize(min(maxW, max(w.getWidth(), packFrame_minw)), min(maxH, max(w.getHeight(), packFrame_minh)));
        }
      });
    }
    return c;
  }

  static public JFrame packFrame(ButtonGroup g) {
    return packFrame(getFrame(g));
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public <A> int smartLastIndexOf(List<A> l, A sub) {
    int i = lastIndexOf(l, sub);
    return i < 0 ? l(l) : i;
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, A[] l) {
    return concatMap((Object) f, l);
  }

  static public String printLog() {
    return getPrintLog();
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public <A> List<A> listGetMulti(final List<A> l, List<Integer> indices) {
    return map(indices, new F1<Integer, A>() {

      public A get(Integer i) {
        try {
          return _get(l, i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_get(l, i)";
      }
    });
  }

  static public int firstIntFromLong(long l) {
    return (int) (l >> 32);
  }

  static public IntRange intRangeWithLength(int start, int len) {
    return intRangeWithLen(start, len);
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public DoubleRect doubleRect(double w, double h) {
    return new DoubleRect(0, 0, w, h);
  }

  static public DoubleRect doubleRect(double x, double y, double w, double h) {
    return new DoubleRect(x, y, w, h);
  }

  static public String joinNemptiesWithComma(Object... strings) {
    return joinNempties(", ", strings);
  }

  static public String joinNemptiesWithComma(Iterable strings) {
    return joinNempties(", ", strings);
  }

  static public Map paramsToMap(Object... params) {
    int n = l(params);
    if (l(params) == 1 && params[0] instanceof Map)
      return (Map) params[0];
    LinkedHashMap map = new LinkedHashMap();
    for (int i = 0; i + 1 < n; i += 2) mapPut(map, params[i], params[i + 1]);
    return map;
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public double g22_squareness(Rect r) {
    return doubleRatio(min(r.w, r.h), max(r.w, r.h));
  }

  static public <A extends Component> A onBoundsChange(A c, final Object r) {
    if (c != null && r != null) {
      swing(() -> {
        c.addComponentListener(new ComponentAdapter() {

          public void componentResized(ComponentEvent e) {
            pcallF(r);
          }

          public void componentMoved(ComponentEvent e) {
            pcallF(r);
          }
        });
      });
    }
    return c;
  }

  static public <A extends Component> A onBoundsChange(Object r, A c) {
    return onBoundsChange(c, r);
  }

  static public void addDirectMenuItem(JMenuBar mb, String text, Object action) {
    if (mb != null) {
      swing(() -> {
        addDirectMenuItem(mb, directJMenuItem(text, action));
      });
    }
  }

  static public void addDirectMenuItem(Component c, String text, Object action) {
    addDirectMenuItem(addMenuBar(c), text, action);
  }

  static public void addDirectMenuItem(JMenuBar mb, JMenuItem menuItem) {
    if (mb != null) {
      swing(() -> {
        mb.add(menuItem);
        revalidate(mb);
      });
    }
  }

  static public <A, B> Map<A, B> antiFilterKeys(Map<A, B> map, Object f) {
    Map<A, B> m2 = similarEmptyMap(map);
    for (A a : keys(map)) {
      if (!isTrue(callF(f, a)))
        m2.put(a, map.get(a));
    }
    return m2;
  }

  static public <A, B> Map<A, B> antiFilterKeys(Object f, Map<A, B> map) {
    return antiFilterKeys(map, f);
  }

  static public <A, B> Map<A, B> antiFilterKeys(IF1<A, Boolean> f, Map<A, B> map) {
    Map<A, B> m2 = similarEmptyMap(map);
    for (A a : keys(map)) {
      if (!f.get(a))
        m2.put(a, map.get(a));
    }
    return m2;
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public int cmpAlphaNum(String a, String b) {
    return alphaNumComparator().compare(a, b);
  }

  static public <A> List<A> fromSimplyLinkedList(SimplyLinkedList<A> sll) {
    List<A> l = new ArrayList();
    while (sll != null) {
      l.add(sll.head);
      sll = sll.tail;
    }
    return l;
  }

  static public Rect toRect_round(DoubleRect r) {
    if (r == null)
      return null;
    int x = iround(r.x), y = iround(r.y);
    return new Rect(x, y, iround(r.x2()) - x, iround(r.y2()) - y);
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  static public String join_flex(List<String> glues, Iterable<String> strings) {
    if (strings == null)
      return "";
    StringBuilder buf = new StringBuilder();
    Iterator<String> i = strings.iterator();
    Iterator<String> iGlues = glues.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(iGlues.next()).append(i.next());
    }
    return buf.toString();
  }

  static public String repSpace(int n) {
    return spaces(n);
  }

  static public double toM_double(long l) {
    return l / (1024 * 1024.0);
  }

  static public String shortDynName(Object o) {
    return shortDynamicClassName(o);
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public <A, B> Map<A, B> mapWithSingleValue(Iterable<A> l, B b) {
    HashMap<A, B> map = new HashMap();
    if (l != null)
      for (A a : l) map.put(a, b);
    return map;
  }

  static public <A> JComboBox<A> setSelectedItem(A item, JComboBox<A> cb) {
    return selectItem(item, cb);
  }

  static public <A> JComboBox<A> setSelectedItem(JComboBox<A> cb, A item) {
    return selectItem(cb, item);
  }

  static public <A> JList<A> setSelectedItem(JList<A> list, A item) {
    return selectItem(list, item);
  }

  static public <A, B> Set<Map.Entry<A, B>> _entrySet(Map<A, B> map) {
    return map == null ? Collections.EMPTY_SET : map.entrySet();
  }

  static public Pair<Boolean, String> transpileOnServer(String snippetID) {
    return transpileOnServer(snippetID, "quick");
  }

  static public Pair<Boolean, String> transpileOnServer(long snippetID) {
    return transpileOnServer(fsI(snippetID));
  }

  static public Pair<Boolean, String> transpileOnServer(long snippetID, String mode) {
    return transpileOnServer(fsI(snippetID), mode);
  }

  static public Pair<Boolean, String> transpileOnServer(String snippetID, String mode) {
    try {
      print("Transpiling " + formatSnippetID(snippetID));
      String url = tb_mainServer() + "/tb/transpile.php";
      String modeStr = "&quick=1";
      if (eq(mode, "medium"))
        modeStr += "&medium=1";
      if (eq(mode, "fresh"))
        modeStr += "&fresh=1";
      String query = "id=" + parseSnippetID(snippetID) + modeStr + standardCredentials();
      String result = loadPage(url + "?" + query);
      print(result);
      Matcher m = regexp("URL=/(dexcompile\\.php.*?)'", result);
      if (!m.find())
        return pair(false, result);
      url = tb_mainServer() + "/" + m.group(1) + standardCredentials();
      result = loadPage(url);
      boolean ok = result.contains("SUCCESS");
      return pair(ok, result);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class ListFromFunction<A> extends RandomAccessAbstractList<A> implements IFieldsToList {

    public int n;

    public IF1<Integer, A> f;

    public ListFromFunction() {
    }

    public ListFromFunction(int n, IF1<Integer, A> f) {
      this.f = f;
      this.n = n;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + n + ", " + f + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { n, f };
    }

    public int size() {
      return n;
    }

    public A get(int i) {
      return f.get(i);
    }
  }

  static public <A> List<A> listFromFunction(int n, IF1<Integer, A> f) {
    return new ListFromFunction<A>(n, f);
  }

  static public <A> List<A> listFromFunction(IF1<Integer, A> f, int n) {
    return new ListFromFunction<A>(n, f);
  }

  static public void addTabWithToolTip(JTabbedPane tabs, String title, String toolTip, Component c) {
    if (tabs == null)
      return;
    {
      swing(() -> {
        addTab(tabs, title, c);
        if (nempty(toolTip))
          tabs.setToolTipTextAt(tabCount(tabs) - 1, toolTip);
      });
    }
  }

  static public void addTabWithToolTip(JTabbedPane tabs, String title, String toolTip, Swingable c) {
    addTabWithToolTip(tabs, title, toolTip, wrap(c));
  }

  static public int absDiff(int a, int b) {
    return abs(a - b);
  }

  static public long absDiff(long a, long b) {
    return abs(a - b);
  }

  static public float absDiff(float a, float b) {
    return abs(a - b);
  }

  static public double absDiff(double a, double b) {
    return abs(a - b);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A, B> Pair<A, B> first(Map<A, B> map) {
    return mapEntryToPair(first(entrySet(map)));
  }

  static public <A, B> Pair<A, B> first(MultiMap<A, B> mm) {
    if (mm == null)
      return null;
    var e = first(mm.data.entrySet());
    if (e == null)
      return null;
    return pair(e.getKey(), first(e.getValue()));
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public <A, B, C> A first(T3<A, B, C> t) {
    return t == null ? null : t.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public Double first(double[] l) {
    return empty(l) ? null : l[0];
  }

  static public int first(IntBuffer buf) {
    return buf.get(0);
  }

  static public byte first(ByteBuffer buf) {
    return buf.get(0);
  }

  static public <A> A first(A[] l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(pred, l);
  }

  static public <A> A first(AppendableChain<A> a) {
    return a == null ? null : a.element;
  }

  static public <A> A first(IMultiSet<A> a) {
    return a == null ? null : first(a.keySet());
  }

  static public String nlLogic_text(Exp e) {
    return e == null ? null : e.text();
  }

  static public String nlLogic_text(IfThen r) {
    return r == null ? null : r.text();
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static public void pnlQuoted(Collection<String> l) {
    pnl(quoteAll(l));
  }

  static public List<Component> allChildren(Component c) {
    return childrenOfType(c, Component.class);
  }

  static public <A> A shallowClone(A o) {
    return (A) shallowClone_impl(o);
  }

  static public <A> A shallowClone(A o, A emptyClone) {
    return copyFields(o, emptyClone);
  }

  static public Object shallowClone_impl(Object o) {
    if (o == null)
      return o;
    if (o instanceof List)
      return cloneList((List) o);
    if (o instanceof Map)
      return cloneMap((Map) o);
    if (o instanceof String || o instanceof Number || o instanceof Boolean)
      return o;
    if (o instanceof Object[]) {
      Object[] l = (Object[]) o;
      return l.clone();
    }
    Object clone;
    if (o instanceof IMakeEmptyClone)
      clone = ((IMakeEmptyClone) o).makeEmptyClone();
    else
      clone = nuEmptyObject(o.getClass());
    copyFields(o, clone);
    return clone;
  }

  static public Map<Thread, String> runnableThreadsWithRenderedStackTraces_withoutSystemThreads() {
    return mapValues(__97 -> stackTraceToString(__97), runnableThreadsWithStackTraces_withoutSystemThreads());
  }

  static public <A extends IMeta> A setMetaSrcUnlessSame(Object b, A a, Object src) {
    if (a != b)
      setMeta(a, "src", src);
    return a;
  }

  static public JComponent unwrap(JComponent c) {
    return c instanceof JScrollPane ? unwrapScrollPane((JScrollPane) c) : c;
  }

  static public void onConceptsChange(Runnable r) {
    onConceptsChange(db_mainConcepts(), r);
  }

  static public void onConceptsChange(Concepts cc, Runnable r) {
    cc.addConceptIndex(simpleConceptIndex(r));
    cc.onAllChanged.add(r);
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    return oneOfTheFiles(asList(files));
  }

  static public File oneOfTheFiles(Iterable<File> files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static public boolean greaterThan(Object a, Object b) {
    return cmp(a, b) > 0;
  }

  static public boolean greaterThan(int a, int b) {
    return a > b;
  }

  static public boolean greaterThan(double a, double b) {
    return a > b;
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public Map<String, Object> objectToMap(Object o) {
    try {
      if (o instanceof Map)
        return (Map) o;
      if (o == null)
        return null;
      TreeMap<String, Object> map = new TreeMap();
      Class c = o.getClass();
      while (c != Object.class) {
        Field[] fields = c.getDeclaredFields();
        for (final Field field : fields) {
          if ((field.getModifiers() & Modifier.STATIC) != 0)
            continue;
          field.setAccessible(true);
          final Object value = field.get(o);
          if (value != null)
            map.put(field.getName(), value);
        }
        c = c.getSuperclass();
      }
      if (o instanceof DynamicObject)
        putAll(map, ((DynamicObject) o).fieldValues);
      return map;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Map<String, Object>> objectToMap(Iterable l) {
    if (l == null)
      return null;
    List x = new ArrayList();
    for (Object o : l) x.add(objectToMap(o));
    return x;
  }

  static public Object rcall(String method, Object o, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public void onConceptChanges(Runnable r) {
    onConceptsChange(r);
  }

  static public void onConceptChanges(Concepts cc, Runnable r) {
    onConceptsChange(cc, r);
  }

  static public JLabel dm_transientCalculatedLabel(IF0<Object> calc) {
    return jLiveValueLabel(dm_transientCalculatedLiveValue(Object.class, calc));
  }

  static public String base64encode(byte[] a) {
    int aLen = a.length;
    int numFullGroups = aLen / 3;
    int numBytesInPartialGroup = aLen - 3 * numFullGroups;
    int resultLen = 4 * ((aLen + 2) / 3);
    StringBuffer result = new StringBuffer(resultLen);
    char[] intToAlpha = intToBase64;
    int inCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int byte0 = a[inCursor++] & 0xff;
      int byte1 = a[inCursor++] & 0xff;
      int byte2 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      result.append(intToAlpha[(byte0 << 4) & 0x3f | (byte1 >> 4)]);
      result.append(intToAlpha[(byte1 << 2) & 0x3f | (byte2 >> 6)]);
      result.append(intToAlpha[byte2 & 0x3f]);
    }
    if (numBytesInPartialGroup != 0) {
      int byte0 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      if (numBytesInPartialGroup == 1) {
        result.append(intToAlpha[(byte0 << 4) & 0x3f]);
        result.append("==");
      } else {
        int byte1 = a[inCursor++] & 0xff;
        result.append(intToAlpha[(byte0 << 4) & 0x3f | (byte1 >> 4)]);
        result.append(intToAlpha[(byte1 << 2) & 0x3f]);
        result.append('=');
      }
    }
    return result.toString();
  }

  static final public char[] intToBase64 = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/' };

  static public <A> AutoCloseable vmBus_onMessage(String msg, IVF1<A> onMessage) {
    return vmBus_onMessage(msg, ivf1ToVF1(onMessage));
  }

  static public <A> AutoCloseable vmBus_onMessage(final String msg, final VF1<A> onMessage) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, new VF2<String, Object>() {

        public void get(String _msg, Object arg) {
          try {
            callF(onMessage, arg);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(onMessage, arg)";
        }
      });
    }
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final IVF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public AutoCloseable vmBus_onMessage(String msg, Runnable onMessage) {
    return vmBus_onMessage(msg, runnableToVF1(onMessage));
  }

  static public double calcFitScale(BufferedImage image, Component c) {
    return calcFitScale(image, c.getWidth(), c.getHeight());
  }

  static public double calcFitScale(BufferedImage image, int w) {
    return calcFitScale(image, w, w);
  }

  static public double calcFitScale(BufferedImage image, int w, int h) {
    int iw = image.getWidth(), ih = image.getHeight();
    return max(doubleRatio(h, ih), doubleRatio(w, iw));
  }

  static public String strOrClassName(Object o) {
    if (o instanceof Class)
      return className((Class) o);
    return str(o);
  }

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args == null || args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : getDeclaredConstructors_cached(c)) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public File tempFileFor(File f) {
    return new File(f.getPath() + "_temp");
  }

  static public int listRowCount(JList list) {
    return list == null ? 0 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return list.getModel().getSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return list.getModel().getSize();";
      }
    });
  }

  static public JTextArea showWrappedText(final String title, final String text) {
    return (JTextArea) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JTextArea textArea = wrappedTextArea(text);
          caretToHome(textArea);
          textArea.setFont(typeWriterFont());
          makeFrame(title, new JScrollPane(textArea));
          return textArea;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextArea textArea = wrappedTextArea(text);\r\n    caretToHome(textArea);\r\n    ...";
      }
    });
  }

  static public JTextArea showWrappedText(Object text) {
    return showWrappedText(autoFrameTitle(), str(text));
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Graphics2D antiAliasOn(Graphics2D g) {
    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    return g;
  }

  static public BigInteger mul(BigInteger a, BigInteger b) {
    return a.multiply(b);
  }

  static public BigInteger mul(BigInteger a, long b) {
    return a.multiply(bigint(b));
  }

  static public int mul(int a, int b) {
    return a * b;
  }

  static public long mul(long a, long b) {
    return a * b;
  }

  static public double mul(double a, double b) {
    return a * b;
  }

  static public AbstractAction abstractAction(String name, final Object runnable) {
    return new AbstractAction(name) {

      public void actionPerformed(ActionEvent evt) {
        pcallF(runnable);
      }
    };
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public String mapEachLine(IF1<String, String> f, String text) {
    return lines_possiblyRTrim(text, mapLines(f, text));
  }

  static public String mapEachLine(String text, IF1<String, String> f) {
    return mapEachLine(f, text);
  }

  static public boolean zipFileContains_falseOnError(File inZip, String fileName) {
    try {
      return zipFileContains(inZip, fileName);
    } catch (Throwable e) {
      return false;
    }
  }

  static public void printVars_str(Object... params) {
    print(renderVars_str(params));
  }

  static public Object getMetaSrc(Object o) {
    return metaGet("src", o);
  }

  static public BufferedImage addBorderToImage(BufferedImage img, Color color, int border) {
    return img_addBorder(img, color, border);
  }

  static public BufferedImage addBorderToImage(Color color, BufferedImage img) {
    return addBorderToImage(1, color, img);
  }

  static public BufferedImage addBorderToImage(int border, Color color, BufferedImage img) {
    return img_addBorder(img, color, border);
  }

  static public BufferedImage addBorderToImage(Color color, int border, BufferedImage img) {
    return img_addBorder(img, color, border);
  }

  static public JPanel withTopRightAndBottomMargin(Component c) {
    return withTopRightAndBottomMargin(defaultMargin(), c);
  }

  static public JPanel withTopRightAndBottomMargin(int w, Component c) {
    return withMargins(w, 0, w, w, c);
  }

  static public File oneOfTheFilesInDir(File dir, String... names) {
    return oneOfTheFiles(map(names, name -> newFile(dir, name)));
  }

  static public <A extends JComponent> A bindListenerToComponent(A component, IHasChangeListeners source, Runnable listener) {
    if (source != null && listener != null)
      bindToComponent(component, new Runnable() {

        public void run() {
          try {
            source.onChangeAndNow(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "source.onChangeAndNow(listener);";
        }
      }, new Runnable() {

        public void run() {
          try {
            source.removeChangeListener(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "source.removeChangeListener(listener)";
        }
      });
    return component;
  }

  static public ImageIcon resizeImageIcon(ImageIcon icon, int newW) {
    var img = icon.getImage();
    int newH = iround(img.getHeight(null) * (double) newW / img.getWidth(null));
    return imageIcon(resizeImage_raw(img, newW, newH, Image.SCALE_DEFAULT));
  }

  static public int findIntArg(String name, String[] args, int defaultValue) {
    int i = indexOfIC(args, name);
    return i >= 0 && i + 1 < l(args) ? parseInt(args[i + 1]) : defaultValue;
  }

  static public Set<AutoCloseable> _registerAutoCloseable_set = synchroHashSet();

  static public void _registerAutoCloseable(AutoCloseable c) {
    addIfNotNull(_registerAutoCloseable_set, c);
  }

  static public void cleanMeUp__registerAutoCloseable() {
    closeAutoCloseables(getAndClearList(_registerAutoCloseable_set));
  }

  static public Map<String, Object> objectToMap_inOrder_withoutFields(Object o, Collection<String> withoutFields) {
    if (o == null)
      return null;
    if (o instanceof Map)
      return (Map) o;
    LinkedHashMap<String, Object> map = new LinkedHashMap();
    for (String field : listWithoutSet(fieldsInOrder(o), withoutFields)) map.put(field, get(o, field));
    return map;
  }

  static public <A> Value<A> value(A a) {
    return new Value<A>(a);
  }

  static public int inc(AtomicInteger i) {
    return incAtomicInt(i);
  }

  static public int inc(AtomicInteger i, int delta) {
    return incAtomicInt(i, delta);
  }

  static public long inc(AtomicLong l) {
    return incAtomicLong(l);
  }

  static public long inc(AtomicLong l, long b) {
    return l.addAndGet(b);
  }

  static public int inc(IntVar v) {
    synchronized (v) {
      int val = v.get() + 1;
      v.set(val);
      return val;
    }
  }

  static public int inc(int i) {
    return i + 1;
  }

  static public long inc(long l) {
    return l + 1;
  }

  static public <A> Set<A> syncSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> syncSet(Collection<A> l) {
    return addAllAndReturnCollection(synchroHashSet(), l);
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Map<String, Field> getOpt_getFieldMap(Object o) {
    Class c = _getClass(o);
    HashMap<String, Field> map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
    return map;
  }

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Map<String, Field> map = getOpt_getFieldMap(o);
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return syncMapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public boolean eqicOrEq(Object a, Object b) {
    return a instanceof String && b instanceof String ? eqic((String) a, (String) b) : eq(a, b);
  }

  static public JPanel withRightAlignedButtons(JComponent center, Object... params) {
    return centerAndSouth(center, withMargin(jRightAlignedButtons(params)));
  }

  static public JPanel withRightAlignedButtons(Swingable center, Object... params) {
    return withRightAlignedButtons(wrap(center), params);
  }

  static public JPanel borderLayoutPanel() {
    return jpanel(new BorderLayout());
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public String round(String s) {
    return roundBracket(s);
  }

  static public Complex round(Complex c) {
    return new Complex(round(c.re), round(c.im));
  }

  static public <A, B> Map<A, B> weakHashMap() {
    return newWeakHashMap();
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public Map<Thread, StackTraceElement[]> runnableThreadsWithStackTraces_withoutSystemThreads() {
    return antiFilterKeys(__98 -> isSystemThread(__98), runnableThreadsWithStackTraces());
  }

  static public void setTrayIconToolTip(TrayIcon trayIcon, String toolTip) {
    if (trayIcon != null)
      trayIcon.setToolTip(toolTip);
  }

  static public ScanlineBitMatrix toScanlineBitMatrix(Matrix<Boolean> m) {
    if (m == null)
      return null;
    if (m instanceof ScanlineBitMatrix)
      return ((ScanlineBitMatrix) m);
    return new ScanlineBitMatrix(m);
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public <A> JLabel simpleTransformedLiveValueLabel(IF1<A, Object> f, LiveValue<A> lv) {
    return bindJLabelToTransformedLiveValue(f, swing(() -> new JLabel()), lv);
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public JTextField jTextField() {
    return jTextField("");
  }

  static public JTextField jTextField(final String text) {
    return swing(new F0<JTextField>() {

      public JTextField get() {
        try {
          JTextField tf = new JTextField(unnull(text));
          standardTextFieldPopupMenu(tf);
          jenableUndoRedo(tf);
          tf.selectAll();
          return tf;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextField tf = new JTextField(unnull(text));\r\n    standardTextFieldPopupMenu...";
      }
    });
  }

  static public JTextField jTextField(Object o) {
    return jTextField(strOrEmpty(o));
  }

  static public <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      } else {
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public Map<Class, List<String>> fieldsInOrder_cache = weakHashMap();

  static public List<String> fieldsInOrder(Object o) {
    return fieldsInOrder(_getClass(o));
  }

  static public List<String> fieldsInOrder(Class c) {
    if (c == null)
      return null;
    synchronized (fieldsInOrder_cache) {
      List<String> fields = fieldsInOrder_cache.get(c);
      if (fields != null)
        return fields;
      String order = toStringOpt(getOpt(c, "_fieldOrder"));
      Set<String> set = asTreeSet(allNonStaticFields(c));
      if (order == null)
        return asList(set);
      fields = splitAtSpace(order);
      setAddAll(fields, set);
      fieldsInOrder_cache.put(c, fields);
      return fields;
    }
  }

  static public <A> Set<A> setWithNotify(final Runnable onChange) {
    return setWithNotify(new HashSet(), onChange);
  }

  static public <A> Set<A> setWithNotify(Set<A> set, final Runnable onChange) {
    return new NotifyingSet<A>(set) {

      public void change() {
        onChange.run();
      }
    };
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Iterable it, Object a) {
    if (it != null)
      for (Object o : it) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public boolean contains(Rect r, Pt p) {
    return rectContains(r, p);
  }

  static public JTabbedPane jLeftTabs(Object... x) {
    JTabbedPane tabs = jtabs(x);
    tabs.setTabPlacement(JTabbedPane.LEFT);
    return tabs;
  }

  static public JTabbedPane jLeftTabs(Collection c) {
    return jLeftTabs(toObjectArray(c));
  }

  static public Component addToWindow(final Component c, final Component toAdd) {
    if (toAdd != null) {
      swing(() -> {
        JFrame frame = getFrame(c);
        if (frame == null)
          return;
        setContentPane(frame, centerAndSouth(frame.getContentPane(), toAdd));
      });
    }
    return c;
  }

  static public void selectTableRows(final JTable table, int[] rows) {
    if (table != null) {
      swing(() -> {
        ListSelectionModel model = table.getSelectionModel();
        int n = tableRows(table);
        model.clearSelection();
        if (rows != null)
          for (int row : rows) if (row < n)
            model.addSelectionInterval(row, row);
      });
    }
  }

  static public Pair<Boolean, String> transpileOnNewServer(String snippetID) {
    return transpileOnNewServer(snippetID, "quick");
  }

  static public Pair<Boolean, String> transpileOnNewServer(long snippetID) {
    return transpileOnNewServer(fsI(snippetID));
  }

  static public Pair<Boolean, String> transpileOnNewServer(long snippetID, String mode) {
    return transpileOnNewServer(fsI(snippetID), mode);
  }

  static public Pair<Boolean, String> transpileOnNewServer(String snippetID, String mode) {
    try {
      print("Transpiling " + formatSnippetID(snippetID));
      String url = "https://botcompany.de/1018308/raw/" + psI(snippetID);
      url = appendParamsToURL(url, "medium", eq(mode, "medium") ? "1" : null, "fresh", eq(mode, "fresh") ? "1" : null);
      String result = postPage(url, transpilationCredentials());
      print(result);
      boolean ok = cic(htmlDecode(result), "Transpiled & uploaded");
      return pair(ok, result);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JTabbedPane jTopOrLeftTabs(boolean horizontal, Object... x) {
    return jLeftOrTopTabs(horizontal, x);
  }

  static public JTabbedPane jTopOrLeftTabs(boolean horizontal, Collection c) {
    return jLeftOrTopTabs(horizontal, c);
  }

  static public boolean isRunnable(Object o) {
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public void assertIsInstance(Class type, Object o) {
    if (!isInstance(type, o))
      throw fail(_getClass(o) + " is not a subclass of " + type);
  }

  static public void assertIsInstance(Object o, Class type) {
    assertIsInstance(type, o);
  }

  static public <A extends Concept> A uniqCI(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqCI(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhereCI(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public JPanel showInternalFrameFormTitled(final JDesktopPane desktop, final String title, final Object... _parts) {
    JPanel panel = showForm_makePanel(true, _parts);
    showForm_makeInternalFrame(desktop, title, panel);
    return panel;
  }

  static public Set emptySet() {
    return new HashSet();
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static public Collection<Concept> allConcepts() {
    return db_mainConcepts().allConcepts();
  }

  static public Collection<Concept> allConcepts(Concepts concepts) {
    return concepts.allConcepts();
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A extends Component> A centerFrame(A c) {
    Window w = getWindow(c);
    if (w != null) {
      swing(() -> {
        var r = preferredScreenBounds();
        w.setLocation(r.x + (r.w - w.getWidth()) / 2, r.y + (r.h - w.getHeight()) / 2);
      });
    }
    return c;
  }

  static public <A extends Component> A centerFrame(int w, int h, A c) {
    return centerFrame(setFrameSize(w, h, c));
  }

  static public Object[] reverseParams(Object[] params) {
    int n = l(params);
    if (params == null || odd(n))
      return params;
    Object[] a = new Object[n];
    for (int i = 0; i + 1 < n; i += 2) arraycopy(params, i, a, n - i - 2, 2);
    return a;
  }

  static public void indexConceptField(Class<? extends Concept> c, String field) {
    indexConceptField(db_mainConcepts(), c, field);
  }

  static public void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndex(concepts, c, field);
  }

  static public int getHeight(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getHeight");
  }

  static public String renderStackTrace(StackTraceElement[] st) {
    return stackTraceToString(st);
  }

  static public String renderStackTrace(Throwable e) {
    return stackTraceToString(e);
  }

  static public String renderStackTrace(String msg) {
    return renderStackTrace(new Throwable(msg));
  }

  static public int scoredSearch_score(Iterable<String> l, List<String> words) {
    int score = 0;
    if (l != null)
      for (String s : l) score += scoredSearch_score(s, words);
    return score;
  }

  static public int scoredSearch_score(String s, List<String> words) {
    int score = 0;
    if (nempty(s))
      for (String word : unnullForIteration(words)) score += scoredSearch_score_single(s, word);
    return score;
  }

  static public int scoredSearch_score(String s, String query) {
    return scoredSearch_score(s, scoredSearch_prepare(query));
  }

  static public JComboBox jComboBox(final String... items) {
    return jcombobox(items);
  }

  static public JComboBox jComboBox(Collection<String> items) {
    return jcombobox(items);
  }

  static public JComboBox jComboBox(Collection<String> items, String selectedItem) {
    return jcombobox(items, selectedItem);
  }

  static public JComboBox jComboBox(String selectedItem, Collection<String> items) {
    return jcombobox(items, selectedItem);
  }

  static public void close(AutoCloseable c) {
    _close(c);
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public boolean isFile(File f) {
    return f != null && f.isFile();
  }

  static public boolean isFile(String path) {
    return isFile(newFile(path));
  }

  static public int indexOfPred(List l, Object pred) {
    for (int i = 0; i < l(l); i++) if (checkCondition(pred, l.get(i)))
      return i;
    return -1;
  }

  static public <A, B> int indexOfPred(List<A> l, IF1<A, B> pred) {
    return indexOfPred(l, (Object) pred);
  }

  static public JPanel northAndCenterWithMargins(Swingable n, Swingable c) {
    return northAndCenterWithMargins(n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargins(Swingable n, Component c) {
    return northAndCenterWithMargins(toComponent(n), c);
  }

  static public JPanel northAndCenterWithMargins(Component n, Swingable c) {
    return northAndCenterWithMargins(n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargins(Component n, Component c) {
    return applyDefaultMargin(northAndCenter(withBottomMargin(n), c));
  }

  static public JPanel northAndCenterWithMargins(int margin, Swingable n, Swingable c) {
    return northAndCenterWithMargins(margin, n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargins(int margin, Swingable n, Component c) {
    return northAndCenterWithMargins(margin, toComponent(n), c);
  }

  static public JPanel northAndCenterWithMargins(int margin, Component n, Swingable c) {
    return northAndCenterWithMargins(margin, n, toComponent(c));
  }

  static public JPanel northAndCenterWithMargins(int margin, Component n, Component c) {
    return applyMargin(margin, northAndCenter(withBottomMargin(margin, n), c));
  }

  static public void assertSame(Object a, Object b) {
    assertSame("", a, b);
  }

  static public void assertSame(String msg, Object a, Object b) {
    if (a != b)
      throw fail(joinNemptiesWithColon(msg, a + " != " + b + " (" + identityHash(a) + "/" + identityHash(b) + ")"));
  }

  static public void assertSame(IF0<String> msg, Object a, Object b) {
    if (a != b)
      throw fail(joinNemptiesWithColon(msg.get(), a + " != " + b + " (" + identityHash(a) + "/" + identityHash(b) + ")"));
  }

  static public <A extends Component> A setBounds(final int x, final int y, final int w, final int h, final A a) {
    if (a != null) {
      swing(() -> {
        a.setBounds(x, y, w, h);
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(A a, Rect r) {
    if (a != null && r != null) {
      swing(() -> {
        a.setBounds(toRectangle(r));
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(A a, Rectangle r) {
    if (a != null && r != null) {
      swing(() -> {
        a.setBounds(r);
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(Rect r, A a) {
    return setBounds(a, r);
  }

  static public <A extends Component> A setBounds(A a, int x, int y, int w, int h) {
    return setBounds(x, y, w, h, a);
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public void swing(Runnable f) {
    swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  static public byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A extends Component> A jMinSize(int w, int h, A c) {
    return jMinWidth(w, jMinHeight(h, c));
  }

  static public <A extends Component> A jMinSize(A c, int w, int h) {
    return jMinSize(w, h, c);
  }

  static public <A extends Component> A jMinSize(A c, Dimension d) {
    return jMinSize(d.width, d.height, c);
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public IProgressShower tempProgressBar(String text) {
    return tempProgressBar(text, 1);
  }

  static public IProgressShower tempProgressBar(String text, double total) {
    JProgressBar bar = showProgressWindow(text, total);
    return new IProgressShower() {

      public void setValue(double value) {
        setProgressBarValue(bar, iround(value));
      }

      public void setTotal(double total) {
        setProgressBarTotal(bar, iround(total));
      }

      public void setText(String text) {
        setProgressBarText(bar, print(text));
      }

      public void close() {
        disposePIFrame(bar);
      }
    };
  }

  static public Pt centerOfRect(Rect r) {
    return r == null ? null : new Pt(r.x + r.w / 2, r.y + r.h / 2);
  }

  static public void register(Concept c) {
    registerConcept(c);
  }

  static public JLabel jCenteredBoldLabel(String text) {
    return jcenteredBoldLabel(text);
  }

  static public JLabel jCenteredBoldLabel() {
    return jcenteredBoldLabel();
  }

  static public File makeFileNameUnique_beforeExtension_startWith1_noDot(File f) {
    File orig = f;
    int n = 1;
    do {
      f = appendToFileBaseName(orig, str(n++));
    } while (f.exists());
    return f;
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return classLoaderForObject(realm).loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  static public boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  static public boolean instanceOf(Class c, Object o) {
    return instanceOf(o, c);
  }

  static public JComponent wrapForSmartAdd_jComponent(Object o) {
    return componentToJComponent(wrapForSmartAdd(o));
  }

  static public Pt mousePointer() {
    return new Pt(getMouseLocation());
  }

  static public <A, B> Either<A, B> either2(B b) {
    return new Either(2, b);
  }

  static public <A, B> Either<A, B> either1(A a) {
    return new Either(1, a);
  }

  static public Component addToWindowAndGrow(final Component c, final Component toAdd) {
    {
      swing(() -> {
        int h = getMinimumHeight(toAdd);
        addToWindow(c, toAdd);
        growWindowSouth(c, h);
      });
    }
    return c;
  }

  static public Object evalWithTimeoutOrException(final Object f, int timeoutMS) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public Object evalWithTimeoutOrException(int timeoutMS, final Object f) {
    return eitherAOpt(evalWithTimeout(timeoutMS, f));
  }

  static public Object evalWithTimeoutOrException(double timeoutSeconds, final Object f) {
    return eitherAOpt(evalWithTimeout(timeoutSeconds, f));
  }

  static public <A> A evalWithTimeoutOrException(int timeoutMS, F0<A> f) {
    Either<Object, Thread> e = evalWithTimeout(timeoutMS, f);
    if (e.isA())
      return (A) e.a();
    throw fail(trim("Timeout after " + timeoutMS + " ms. " + unnull(stackTraceForThread(e.b()))));
  }

  static public <A> A evalWithTimeoutOrException(double timeoutSeconds, F0<A> f) {
    return evalWithTimeoutOrException(toMS_int(timeoutSeconds), f);
  }

  static public <A> A evalWithTimeoutOrException(int timeoutMS, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, if0ToF0(f));
  }

  static public <A> A evalWithTimeoutOrException(double timeoutSeconds, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, if0ToF0(f));
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int fixInternalFrame_borderTopLeft = 0;

  static public int fixInternalFrame_borderBottomRight = 40;

  static public JInternalFrame fixInternalFrame(final JInternalFrame f) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Container c = f.getParent();
          if (c == null)
            return f;
          Rect r = toRect(f.getBounds());
          int a = fixInternalFrame_borderTopLeft, b = fixInternalFrame_borderBottomRight;
          Rect outer = new Rect(a, a, c.getWidth() - b, c.getHeight() - b);
          if (!rectContains(outer, r))
            f.setLocation(max(a, min(r.x, outer.x2())), max(a, min(r.y, outer.y2())));
          if (r.w > c.getWidth() || r.h > c.getHeight())
            f.setSize(c.getWidth() - a, c.getHeight() - a);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Container c = f.getParent();\r\n    if (c == null) ret f;\r\n    Rect r = toRect(...";
      }
    });
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public <A, B, C> MultiMap<B, C> mapKeys(IF1<A, C> f, MultiMap<A, B> mm) {
    return mapMultiMapKeys(f, mm);
  }

  static public <A, B, C> MultiSetMap<B, C> mapKeys(IF1<A, C> f, MultiSetMap<A, B> mm) {
    return mapMultiSetMapKeys(f, mm);
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public JButton tableDependButton(JTable tbl, JButton b) {
    tableDependButtons(tbl, ll(b));
    return b;
  }

  static public JButton tableDependButton(JTable tbl, String text, Object action) {
    return tableDependButton(tbl, jbutton(text, action));
  }

  static public <A> List<A> getComboBoxItems(JComboBox<A> cb) {
    return cb == null ? null : swing(() -> {
      ComboBoxModel<A> model = cb.getModel();
      int n = model.getSize();
      List<A> l = emptyList(n);
      for (int i = 0; i < n; i++) l.add(model.getElementAt(i));
      return l;
    });
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public <A> TreeSet<A> asTreeSet(Collection<A> set) {
    return set == null ? null : set instanceof TreeSet ? (TreeSet) set : new TreeSet(set);
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    File file = new File(fileName);
    mkdirsForFile(file);
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists())
        try {
          String saveName = tempFileName + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      try {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      } finally {
        _close(fileOutputStream);
      }
    }
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
    vmBus_send("wroteFile", file);
    return file;
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setContentPane(JFrame frame, Container c) {
    swing(() -> {
      frame.setContentPane(c);
      revalidate(frame);
    });
  }

  static public void setContentPane(JWindow w, Container c) {
    swing(() -> {
      w.setContentPane(c);
      revalidate(w);
    });
  }

  static public TreeSet mapToTreeSet(Object f, Iterable l) {
    TreeSet x = new TreeSet();
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> TreeSet<B> mapToTreeSet(IF1<A, B> f, Iterable<A> l) {
    TreeSet<B> x = new TreeSet();
    if (l != null)
      for (var o : l) x.add(f.get(o));
    return x;
  }

  static public <A, B> TreeSet<B> mapToTreeSet(Iterable<A> l, IF1<A, B> f) {
    return mapToTreeSet(f, l);
  }

  static public Map<Class, Set<String>> allFields_cache = weakHashMap();

  static public Set<String> allFields(Object o) {
    if (o == null)
      return emptySet();
    Class _c = _getClass(o);
    Set<String> fields = allFields_cache.get(_c);
    if (fields == null)
      allFields_cache.put(_c, fields = asTreeSet(keys(getOpt_getFieldMap(o))));
    return fields;
  }

  static public Window getWindow(Object o) {
    if (!(o instanceof Component))
      return null;
    return swing(() -> {
      Component c = (Component) o;
      while (c != null) {
        if (c instanceof Window)
          return ((Window) c);
        c = c.getParent();
      }
      return null;
    });
  }

  static public int ubyteToInt(byte b) {
    return b & 0x0FF;
  }

  static public int ubyteToInt(char c) {
    return c & 0x0FF;
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public void savePNG(BufferedImage img, File file) {
    try {
      File tempFile = new File(file.getPath() + "_temp");
      CriticalAction ca = beginCriticalAction("Save " + f2s(file));
      try {
        ImageIO.write(img, "png", mkdirsFor(tempFile));
        file.delete();
        tempFile.renameTo(file);
      } finally {
        ca.done();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void savePNG(String file, BufferedImage img) {
    savePNG(toFile(file), img);
  }

  static public void savePNG(File file, BufferedImage img) {
    savePNG(img, file);
  }

  static public void savePNG(File file, RGBImage img) {
    savePNG(file, img.getBufferedImage());
  }

  static public boolean replaceNiceButtons(DynamicStack stack, Object... params) {
    boolean first = stack.isEmpty();
    stack.setComponents(makeNiceButtons(params).components());
    return first;
  }

  static public JButton disableButton(final JButton b) {
    if (b != null) {
      swing(() -> {
        b.setEnabled(false);
      });
    }
    return b;
  }

  static public void disableButton() {
    disableButton(heldInstance(JButton.class));
  }

  static public void g22_renderPosterizedHighlightedImage(ImageSurface isPosterized, Gazelle22_ImageToRegions itr, boolean showRegionsAsOutline) {
    if (isPosterized == null)
      return;
    var mouse = mouseLocationPt();
    if (!isScreenCoordinateInWindow(mouse, isPosterized)) {
      var mouse2 = itr.coordinatesFromScreen(mouse);
      mouse = mouse2;
    } else
      mouse = isPosterized.mousePosition;
    var pixels = itr.posterized.getRGBPixels();
    g22_highlightRegion(pixels, isPosterized, itr, mouse, showRegionsAsOutline);
    if (itr.scoredRegions != null)
      for (Map.Entry<? extends IImageRegion, ? extends Double> __0 : _entrySet(itr.scoredRegions)) {
        IImageRegion region = __0.getKey();
        double score = __0.getValue();
        if (score >= .5) {
          int color = colorToIntOpaque(blendColors(lightBlue(), Color.blue, (score - .5) * 2));
          g22_highlightRegion(pixels, itr, region.indexInCreator(), color, false);
        }
      }
    isPosterized.setImage(bufferedImage(pixels, itr.posterized));
  }

  static public List<Map> zipFileToJSONFingerprint_md5(File zip) {
    var zipFile = zipFile(zip);
    try {
      return zipFileToJSONFingerprint_md5(zipFile);
    } finally {
      _close(zipFile);
    }
  }

  static public List<Map> zipFileToJSONFingerprint_md5(ZipFile zip) {
    return map(listZipEntries(zip), e -> {
      try {
        return litorderedmap("name", e.getName(), "md5", md5OfStream(zip.getInputStream(e)));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    });
  }

  static public <A> String pnlToString(String prefix, Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(prefix, l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(prefix, l)";
      }
    });
  }

  static public <A> String pnlToString(final Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A> String pnlToString(final A[] l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A, B> String pnlToString(final Map<A, B> map) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(map);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(map)";
      }
    });
  }

  static public <A, B> String pnlToString(MultiMap<A, B> map) {
    return pnlToString(multiMapToMap(map));
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public <A> String lines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines(l, f);
  }

  static public List<String> lines(File f) {
    return linesFromFile_list(f);
  }

  static public <A> AutoCloseable tempSetTL_noInit(BetterThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.isSet() ? tl.get() : null;
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public JTabbedPane jtabs(Object... x) {
    return fillJTabs(swingNu(JTabbedPane.class), x);
  }

  static public void onTabSelected(JTabbedPane tabs, Runnable r) {
    if (tabs != null) {
      swing(() -> {
        tabs.getModel().addChangeListener(changeListener(r));
      });
    }
  }

  static public void onTabSelected(JTabbedPane tabs, IVF1<Integer> r) {
    if (tabs != null && r != null)
      onTabSelected(tabs, () -> r.get(tabs.getSelectedIndex()));
  }

  static public BWImage scaledBWImageFromBWIntegralImage(int w, IBWIntegralImage img) {
    return scaledBWImageFromBWIntegralImage(img, w);
  }

  static public BWImage scaledBWImageFromBWIntegralImage(IBWIntegralImage img, int w) {
    return scaledBWImageFromBWIntegralImage(img, w, heightForWidth(img, w));
  }

  static public BWImage scaledBWImageFromBWIntegralImage(IBWIntegralImage img, int w, int h) {
    ScaledBWImageFromBWIntegralImage op = new ScaledBWImageFromBWIntegralImage(img, w, h);
    op.run();
    return op.result;
  }

  static public BWImage scaledBWImageFromBWIntegralImage(int w, int h, IBWImage img) {
    return scaledBWImageFromBWIntegralImage(w, h, toIBWIntegralImage(img));
  }

  static public void persistSelectedTabAsLiveValue(JTabbedPane tabs, SimpleLiveValue<String> lv) {
    String value = lv.get();
    if (value != null) {
      int idx = indexOfTabName(tabs, value);
      if (idx >= 0)
        selectTab(tabs, idx);
    }
    onChangeAndNow(tabs, () -> {
      String name = getTabTitle(tabs, selectedTabIndex(tabs));
      lv.set(name);
    });
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(BitSet bs) {
    return !empty(bs);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(IMultiMap mm) {
    return mm != null && mm.size() != 0;
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public boolean nempty(IntBuffer b) {
    return b != null && !b.isEmpty();
  }

  static public boolean nempty(LongBuffer b) {
    return b != null && !b.isEmpty();
  }

  static public boolean nempty(Rect r) {
    return r != null && r.w != 0 && r.h != 0;
  }

  static public boolean nempty(CloseablesHolder ch) {
    return ch != null && !empty(ch.closeables);
  }

  static public boolean nempty(MultiSet ms) {
    return ms != null && !ms.isEmpty();
  }

  static public boolean nempty(IntSize l) {
    return l != null && l.size() != 0;
  }

  static public boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean isEmpty(File f) {
    return f == null || f.length() == 0;
  }

  static public boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean isEmpty(DoubleRange r) {
    return r == null || r.isEmpty();
  }

  static public boolean isEmpty(AppendableChain c) {
    return c == null;
  }

  static public boolean isEmpty(IntSize l) {
    return l == null || l.size() == 0;
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public List<JFrame> allJFrames() {
    return allFrames();
  }

  static public JComponent withTitle(String title, Swingable c) {
    return withTitle(title, toComponent(c));
  }

  static public JComponent withTitle(String title, Component c) {
    return withTitle(withTitle_titlePanel(title), c);
  }

  static public JComponent withTitle_titlePanel(String title) {
    return jlabel(title);
  }

  static public JPanel withTitle(final JComponent titleComponent, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          titleComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Button.borderColor")));
          JPanel panel = new JPanel(new BorderLayout());
          panel.setBackground(Color.WHITE);
          panel.add(BorderLayout.NORTH, titleComponent);
          panel.add(BorderLayout.CENTER, wrap(c));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "titleComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManage...";
      }
    });
  }

  static public JComponent jSmallErrorView(Throwable e) {
    var btn = jimageButtonScaledToWidth(32, errorIconID(), "Show error details", () -> showErrorFrame(e));
    String text = exceptionToStringShort(e);
    var label = jlabel_noAutoToolTip(text);
    return jline(btn, label);
  }

  static public int colorToIntOpaque(Color c) {
    return c.getRGB() | 0xFF000000;
  }

  static public Object dm_getStemByID(Object id) {
    return dm_callOS("getModuleByID", str(id));
  }

  static public JToggleButton jImageToggleButton(Image image, String toolTip, Runnable action) {
    return jImageToggleButton(image, toolTip, action, false);
  }

  static public JToggleButton jImageToggleButton(Image image, String toolTip, Runnable action, boolean selected) {
    var btn = jToggleButton("", action);
    setSelected(btn, selected);
    toolTip(btn, toolTip);
    setButtonImage(btn, image);
    return btn;
  }

  static public JToggleButton jImageToggleButton(String image, String toolTip, Runnable action) {
    return jImageToggleButton(image, toolTip, action, false);
  }

  static public JToggleButton jImageToggleButton(String image, String toolTip, Runnable action, boolean selected) {
    var btn = jToggleButton("", action);
    setSelected(btn, selected);
    toolTip(btn, toolTip);
    setButtonImage(btn, image);
    return btn;
  }

  static public JPanel marginPanel() {
    return jtransparent(borderLayoutPanel());
  }

  static public String showImage_defaultIcon = "#1004230";

  static public ImageSurface showImage(String snippetIDOrURL, String title) {
    return showImage(loadImage(snippetIDOrURL), title);
  }

  static public ImageSurface showImage(String title, BufferedImage img) {
    return showImage(img, title);
  }

  static public ImageSurface showImage(final BufferedImage img, final String title) {
    return (ImageSurface) swing(new F0<Object>() {

      public Object get() {
        try {
          ImageSurface is = showImage(img);
          getFrame(is).setTitle(title);
          return is;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ImageSurface is = showImage(img);\r\n    getFrame(is).setTitle(title);\r\n    ret...";
      }
    });
  }

  static public ImageSurface showImage(final BufferedImage img) {
    return (ImageSurface) swing(new F0<Object>() {

      public Object get() {
        try {
          ImageSurface is = new ImageSurface(img);
          JFrame frame = showPackedFrame(new JScrollPane(is));
          moveToTopRightCorner(frame);
          frameIcon(frame, showImage_defaultIcon);
          return is;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ImageSurface is = new ImageSurface(img);\r\n    JFrame frame = showPackedFrame(...";
      }
    });
  }

  static public ImageSurface showImage(String imageID) {
    return showImage(loadImage2(imageID));
  }

  static public ImageSurface showImage(ImageSurface surface, BufferedImage img) {
    return showImage(img, surface);
  }

  static public ImageSurface showImage(ImageSurface surface, String title, BufferedImage img) {
    return showImage(surface, img, title);
  }

  static public ImageSurface showImage(ImageSurface surface, BufferedImage img, String title) {
    return setFrameTitle(showImage(img, surface), title);
  }

  static public ImageSurface showImage(BufferedImage img, ImageSurface surface) {
    if (surface == null)
      return showImage(img);
    else {
      surface.setImage(img);
      return surface;
    }
  }

  static public ImageSurface showImage(String title, MakesBufferedImage img) {
    return showImage(title, img.getBufferedImage());
  }

  static public ImageSurface showImage(ImageSurface is, MakesBufferedImage img) {
    return showImage(is, img.getBufferedImage());
  }

  static public ImageSurface showImage(RGBImage img) {
    return showImage(img.getBufferedImage());
  }

  static public ImageSurface showImage(RGBImage img, String title) {
    ImageSurface is = showImage(img.getBufferedImage());
    getFrame(is).setTitle(title);
    return is;
  }

  static public ImageSurface showImage(ImageSurface surface, RGBImage img) {
    return showImage(img, surface);
  }

  static public ImageSurface showImage(RGBImage img, ImageSurface surface) {
    if (surface == null)
      return showImage(img);
    else {
      surface.setImage(img);
      return surface;
    }
  }

  static public ImageSurface showImage(ImageSurface surface, String title, RGBImage img) {
    return showImage(surface, img, title);
  }

  static public ImageSurface showImage(ImageSurface surface, RGBImage img, String title) {
    return setFrameTitle(showImage(img, surface), title);
  }

  static public ImageSurface showImage(MakesBufferedImage img) {
    return showImage(img.getBufferedImage());
  }

  static public ImageSurface showImage() {
    return showImage(currentImage());
  }

  static public ImageSurface showImage(File f) {
    return showImage(f2s(f), loadImage2(f)).setFile(f);
  }

  static public Pt scalePt(Pt p, double scaleX) {
    return scalePt(p, scaleX, scaleX);
  }

  static public Pt scalePt(Pt p, double scaleX, double scaleY) {
    return new Pt(iround(p.x * scaleX), iround(p.y * scaleY));
  }

  static public Pt scalePt(double f, Pt p) {
    return scalePt(p, f);
  }

  static public Pt scalePt(int w, int h, double f) {
    return scalePt(new Pt(w, h), f);
  }

  static public <A> IterableIterator<A> iteratorFromFunction_if0(final IF0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }
    }
    ;
    return new IFF2();
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public Object selectedTableCell(JTable t, int col) {
    return getTableCell(t, selectedTableRow(t), col);
  }

  static public Object selectedTableCell(final JTable t) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, t.getSelectedColumn());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return selectedTableCell(t, t.getSelectedColumn());";
      }
    });
  }

  static public Object selectedTableCell(final JTable t, final String colName) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, tableColumnViewIndex(t, colName));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return selectedTableCell(t, tableColumnViewIndex(t, colName));";
      }
    });
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    if (r == null)
      return null;
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public BufferedReader bufferedReader(File f) {
    return utf8bufferedReader(f);
  }

  static public <A extends Concept> A cDeref(Concept.Ref<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public <A> List<A> listWithout(Collection<A> a, Object... b) {
    return minus(a, b);
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public int iceil(double d) {
    return (int) Math.ceil(d);
  }

  static public Point getMouseLocation() {
    return MouseInfo.getPointerInfo().getLocation();
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public void ping_v3_setPingSourceMaker(IF0<PingSource> pingMaker) {
    vm_generalMap_set("ping_v3_pingSourceMaker", pingMaker);
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public String nImages(long n) {
    return n2(n, "image");
  }

  static public String nImages(Collection l) {
    return nImages(l(l));
  }

  static public Color grayToColor(double f) {
    return toColor(brightnessToRGBA(iceil(f * 256)));
  }

  static public <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
    List<B> out = new ArrayList();
    if (l != null)
      for (A a : l) addIfNotNull(out, map.get(a));
    return out;
  }

  static public <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public String str_toMB_oneDigit(long l) {
    return formatDouble1(toM(l)) + " MB";
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public <A extends JComponent> A componentPopupMenuItems(A c, final Object... params) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItems(menu, params);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItems(menu, params)";
      }
    });
    return c;
  }

  static public void addMenuItem(JPopupMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(JPopupMenu menu, JMenuItem menuItem) {
    if (menu != null && menuItem != null)
      menu.add(menuItem);
  }

  static public void addMenuItem(JMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(Menu menu, String text, Object action) {
    menu.add(menuItem(text, action));
  }

  static public void addMenuItem(JMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenuBar menuBar, String text, Runnable action) {
    addMenuItem(menuBar, jmenuItem(text, action));
  }

  static public void addMenuItem(JMenuBar menuBar, JMenuItem menuItem) {
    addDirectMenuItem(menuBar, menuItem);
  }

  static public String longestPrefixInNavigableSet(String s, NavigableSet<String> set) {
    if (set == null || s == null)
      return null;
    while (licensed()) {
      String key = set.floor(s);
      if (key == null)
        break;
      int n = lCommonPrefix(key, s);
      if (n == l(key))
        return key;
      s = takeFirst(s, n);
    }
    return null;
  }

  static public void selectTab(JExtendedTabbedPane tabs, int idx) {
    if (tabs != null) {
      swing(() -> {
        tabs.setSelectedIndex(idx);
      });
    }
  }

  static public void selectTab(JTabbedPane tabs, int idx) {
    if (tabs != null) {
      swing(() -> {
        tabs.setSelectedIndex(idx);
      });
    }
  }

  static public <A, B> B firstValue(Map<A, B> map) {
    return first(values(map));
  }

  static public <A, B> B firstValue(MultiSetMap<A, B> map) {
    return map == null ? null : first(firstValue(map.data));
  }

  static public <A, B> B firstValue(MultiMap<A, B> map) {
    return map == null ? null : first(firstValue(map.data));
  }

  static public boolean zipFileContains(File inZip, String fileName) {
    try {
      ZipFile zip = new ZipFile(inZip);
      try {
        return zipFileContains(zip, fileName);
      } finally {
        zip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean zipFileContains(ZipFile zip, String fileName) {
    try {
      return zip.getEntry(fileName) != null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public <A> String mapToLines(IF1<A, String> f, A data1, A... moreData) {
    return lines(map(f, data1, moreData));
  }

  static public ReliableSingleThread dm_rst(Runnable r) {
    return dm_rst(dm_current_mandatory(), r);
  }

  static public ReliableSingleThread dm_rst(DynModule mod, Runnable r) {
    return dm_rst(mod, new ReliableSingleThread(r));
  }

  static public ReliableSingleThread dm_rst(DynModule mod, ReliableSingleThread rst) {
    rst.enter = dm_rEnter(mod);
    return rst;
  }

  static public boolean isImageFileName(String s) {
    return eqicOneOf(fileExtension(s), ".png", ".jpg", ".jpeg", ".gif", ".qoi");
  }

  static public boolean usingJTattoo() {
    return startsWith(className(currentLAF()), "com.jtattoo.");
  }

  static public Object[] arrayrep(Object a, int n) {
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = a;
    return array;
  }

  static public <A> A[] arrayrep(Class<A> type, A a, int n) {
    A[] array = newArray(type, n);
    for (int i = 0; i < n; i++) array[i] = a;
    return array;
  }

  static public File pathToJavaxJar() {
    return null;
  }

  static public File pathToJavaxJar_noResourceLoader() {
    try {
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String checkmarkIconID() {
    return "#1103071";
  }

  static public JFrame showFrame() {
    return makeFrame();
  }

  static public JFrame showFrame(Object content) {
    return makeFrame(content);
  }

  static public JFrame showFrame(String title) {
    return makeFrame(title);
  }

  static public JFrame showFrame(String title, Object content) {
    return makeFrame(title, content);
  }

  static public JFrame showFrame(final JFrame f) {
    if (f != null) {
      swing(() -> {
        if (frameTooSmall(f))
          frameStandardSize(f);
        if (!f.isVisible())
          f.setVisible(true);
        if (f.getState() == Frame.ICONIFIED)
          f.setState(Frame.NORMAL);
      });
    }
    return f;
  }

  static public JFrame showFrame(String title, Object content, JFrame frame) {
    if (frame == null)
      return showFrame(title, content);
    else {
      frame.setTitle(title);
      setFrameContents(frame, content);
      return frame;
    }
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return new SynchronizedSet(set);
  }

  static public Object callConstructor(String className, Object... args) {
    return nuObject(className, args);
  }

  static public <A> A callConstructor(Class<A> c, Object... args) {
    return nuObject(c, args);
  }

  static public List<String> identifiers(String s) {
    return tok_identifiersInOrder(s);
  }

  static public List<String> identifiers(List<String> tok) {
    return tok_identifiersInOrder(tok);
  }

  static public Rect rectUnion(Rect a, Rect b) {
    if (a == null)
      return b;
    if (b == null)
      return a;
    int x = min(a.x, b.x), y = min(a.y, b.y);
    int x2 = max(a.x + a.w, b.x + b.w), y2 = max(a.y + a.h, b.y + b.h);
    return new Rect(x, y, x2 - x, y2 - y);
  }

  static public JSpinner jSpinnerCommitOnValidEdit(JSpinner spinner) {
    var tf = getTextFieldFromSpinner(spinner);
    if (tf != null) {
      swing(() -> {
        DefaultFormatter formatter = (DefaultFormatter) (tf.getFormatter());
        if (formatter != null)
          formatter.setCommitsOnValidEdit(true);
      });
    }
    return spinner;
  }

  static public boolean isStringOrIntOrLong(Object o) {
    return o instanceof String || o instanceof Integer || o instanceof Long;
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public void createEmptyConceptsFileInDir(File dir) {
    File f = newFile(dir, conceptsFileName());
    if (!fileExists(f))
      saveGZStructureToFile(f, litmap());
  }

  static public JPanel jfullcenter(Component c) {
    return jFullCenter(c);
  }

  static public List<String> regexpFirstGroups(String pat, String s) {
    if (s == null)
      return null;
    Matcher m = regexp(pat, s);
    return m.find() ? regexpGetGroups(m) : null;
  }

  static public WidthAndHeight sixteenToNine_p(int height) {
    return new WidthAndHeightImpl(iround(height * 16.0 / 9), height);
  }

  static public AutoCloseable tempSetRandomSeed(int seed) {
    return tempSetCustomRandomizerForThisThread(new Random(seed));
  }

  static public JPanel northCenterAndSouthWithMargin(Component n, Component c, Component s) {
    return northCenterAndSouth(withBottomMargin(n), c, withTopMargin(s));
  }

  static public JPanel northCenterAndSouthWithMargin(int margin, Component n, Component c, Component s) {
    return northCenterAndSouth(withBottomMargin(margin, n), c, withTopMargin(margin, s));
  }

  static public <A> SimpleLiveValue<A> varWithNotifyToLiveValue_verbose(Class<A> type, IVarWithNotify<A> var) {
    if (var == null)
      return null;
    var lv = new SimpleLiveValue<A>(type);
    var lvRef = weakRef(lv);
    var.onChange(new Runnable() {

      public void run() {
        try {
          var lv = lvRef.get();
          if (lv == null)
            var.removeChangeListener(this);
          else {
            var value = var.get();
            print("varChange " + value);
            lv.set(value);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var lv = lvRef!;\r\n    if (lv == null)\r\n      var.removeChangeListener(this);\r...";
      }
    });
    lv.onChange(() -> {
      var value = lv.get();
      print("lvChange " + value);
      var.set(value);
    });
    var value = var.get();
    print("varToLvInit " + value);
    lv.set(value);
    return lv;
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public void addMenuItems(JMenu m, Object... x) {
    fillJMenu(m, x);
  }

  static public void addMenuItems(JPopupMenu m, Object... x) {
    fillJPopupMenu(m, x);
  }

  static public JLabel jLabel(String text) {
    return jlabel(text);
  }

  static public JLabel jLabel() {
    return jlabel();
  }

  static public AutoCloseable tempInfoBox_noHide(String msg) {
    return tempDisposeWindow(infoBox_noHide(msg));
  }

  static public void callF_thread(final Object f, final Object... args) {
    if (f != null) {
      startThread(new Runnable() {

        public void run() {
          try {
            callF(f, args);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(f, args);";
        }
      });
    }
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public SingleThread awtCalcRegularly(JComponent component, int delay, int firstDelay, Object runnable) {
    final SingleThread thread = new SingleThread();
    final Runnable r2 = addThreadInfoToRunnable(runnable);
    final Object info = _threadInfo();
    installTimer(component, delay, firstDelay, new Runnable() {

      public void run() {
        if (!licensed())
          return;
        _threadInheritInfo(info);
        thread.go(r2);
      }
    });
    return thread;
  }

  static public SingleThread awtCalcRegularly(JFrame frame, int delay, int firstDelay, final Object runnable) {
    return awtCalcRegularly(getRootPane(frame), delay, firstDelay, runnable);
  }

  static public JLabel centeredLiveValueLabel(LiveValue lv) {
    return jCenteredLiveValueLabel(lv);
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public boolean all(Object pred, Iterable l) {
    if (l != null)
      for (Object o : l) if (!isTrue(callF(pred, o)))
        return false;
    return true;
  }

  static public <A> boolean all(Iterable<A> l, IF1<A, Boolean> f) {
    if (l != null)
      for (A a : l) if (!f.get(a))
        return false;
    return true;
  }

  static public <A> boolean all(IF1<A, Boolean> f, Iterable<A> l) {
    return all(l, f);
  }

  static public boolean all(int[] l, IIntPred f) {
    if (l != null)
      for (int i : l) if (!f.get(i))
        return false;
    return true;
  }

  static public void setTabTitle(JExtendedTabbedPane tabs, int idx, String title) {
    if (tabs != null && idx >= 0) {
      swing(() -> {
        if (idx < tabs.getTabCount())
          tabs.setTitleAt(idx, title);
      });
    }
  }

  static public void setTabTitle(JTabbedPane tabs, int idx, String title) {
    if (tabs != null && idx >= 0) {
      swing(() -> {
        if (idx < tabs.getTabCount())
          tabs.setTitleAt(idx, title);
      });
    }
  }

  static public List<String> classNamesInLoadedJigsawModules() {
    return concatMap(loadedJigsawModuleNames(), moduleName -> classNamesInJigsawModule(moduleName));
  }

  static public void systemExit(int code) {
    System.exit(code);
  }

  static public <B, A extends JComboBox<B>> A bindComboBoxToVar(IVarWithNotify<B> var, A cb) {
    if (var != null) {
      bindListenerToComponent(cb, var, (Runnable) () -> selectItem(cb, var.get()));
      onChange(cb, (Runnable) () -> var.set(getSelected(cb)));
    }
    return cb;
  }

  static public <B, A extends JComboBox<B>> A bindComboBoxToVar(A cb, IVarWithNotify<B> var) {
    return bindComboBoxToVar(var, cb);
  }

  static public boolean isDeepContainedInDir_canonical(File f, File dir) {
    return nempty(nameRelativeToPhysicalSubdirectory(f, dir));
  }

  static public IBWImage iBWImageFromFunction(IF2_IntInt_Double f, int w, int h) {
    return new IBWImage() {

      public int getWidth() {
        return w;
      }

      public int getHeight() {
        return h;
      }

      public float getFloatPixel(int x, int y) {
        return (float) f.get(x, y);
      }
    };
  }

  static public ThreadLocal<Boolean> bindComboBoxToLiveValue_debug = new ThreadLocal();

  static public <A extends JComboBox> A bindComboBoxToLiveValue(final A cb, IVarWithNotify<String> lv) {
    boolean debug = isTrue(bindComboBoxToLiveValue_debug.get());
    bindLiveValueListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          selectItem(cb, lv.get());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "selectItem(cb, lv!)";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          String s = getText(cb);
          if (debug)
            print("ComboBox: " + s);
          lv.set(s);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "String s = getText(cb); // also works on editable combo boxes\r\n    if (debug)...";
      }
    });
    return cb;
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  static public <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  static public void onEnterInAllTextFields(JComponent c, Runnable action) {
    if (action == null)
      return;
    for (Component tf : allChildren(c)) onEnterIfTextField(tf, action);
  }

  static public void onEnterInAllTextFields(List c, Runnable action) {
    for (Object o : unnull(c)) if (o instanceof JComponent)
      onEnterInAllTextFields(((JComponent) o), action);
  }

  static public int vstackWithSpacing_default = 10;

  static public JPanel vstackWithSpacing(final List parts) {
    return vstackWithSpacing(parts, vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(final List parts, final int spacing) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          GridBagConstraints gbc = new GridBagConstraints();
          gbc.weightx = 1;
          gbc.fill = GridBagConstraints.HORIZONTAL;
          gbc.gridwidth = GridBagConstraints.REMAINDER;
          gbc.insets = new Insets(spacing / 2, 0, (spacing + 1) / 2, 0);
          smartAddWithLayout(panel, gbc, toObjectArray(nonNulls(parts)));
          gbc.weighty = 1;
          gbc.insets = new Insets(0, 0, 0, 0);
          panel.add(jrigid(), gbc);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    new GridBagConstraints gbc...";
      }
    });
  }

  static public JPanel vstackWithSpacing(Component... parts) {
    return vstackWithSpacing(asList(parts), vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(int spacing, Component... parts) {
    return vstackWithSpacing(asList(parts), spacing);
  }

  static public Pt addPts(Pt a, Pt b) {
    return a == null ? b : b == null ? a : new Pt(a.x + b.x, a.y + b.y);
  }

  static public int countTabs(JExtendedTabbedPane tabs) {
    return tabCount(tabs);
  }

  static public int countTabs(JTabbedPane tabs) {
    return tabCount(tabs);
  }

  static public void printStackTrace_inPossiblyCancelledThread(Throwable e) {
    AutoCloseable __1 = tempUncancelThread();
    try {
      System.out.println(getStackTrace_noRecord(e));
    } finally {
      _close(__1);
    }
  }

  static public List collect(Iterable c, String field) {
    return collectField(c, field);
  }

  static public List collect(String field, Iterable c) {
    return collectField(c, field);
  }

  static public <A extends Concept> A registerConcept(A c) {
    return registerConcept(db_mainConcepts(), c);
  }

  static public <A extends Concept> A registerConcept(Concepts cc, A c) {
    {
      if (cc != null)
        cc.register(c);
    }
    return c;
  }

  static public String nullIfEmpty(String s) {
    return isEmpty(s) ? null : s;
  }

  static public <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
    return isEmpty(map) ? null : map;
  }

  static public <A> List<A> nullIfEmpty(List<A> l) {
    return isEmpty(l) ? null : l;
  }

  static public <A> Vector<A> toVector(A[] array) {
    return new Vector(toList(array));
  }

  static public <A> Vector<A> toVector(Collection<A> l) {
    return l == null ? null : new Vector(l);
  }

  static public void disposePIFrame(Component c) {
    disposePossiblyInternalFrame(c);
  }

  static public void setLocation(Component c, int p_x, int p_y) {
    setLocation(c, pt(p_x, p_y));
  }

  static public void setLocation(Component c, Pt p) {
    if (c != null) {
      swing(() -> {
        c.setLocation(p.x, p.y);
      });
    }
  }

  static public String joinNempties(String sep, Object... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Iterable strings) {
    return joinStrings(sep, strings);
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public Class _run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public String indentStructureString(String s) {
    return indentStructureString(100, s);
  }

  static public String indentStructureString(int levels, String s) {
    if (s == null)
      return null;
    return new StructureStringIndenter().levels(levels).get(s);
  }

  static public void callFInNewThread(Object f, Object... args) {
    callF_thread(f, args);
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public String replacePlusWithSpace(String s) {
    return replace(s, '+', ' ');
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String tb_mainServer_default = "https://code.botcompany.de:9898";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public JButton jimageButtonScaledToWidth(int w, String imageID, Runnable action) {
    return jimageButtonScaledToWidth(w, imageID, "", action);
  }

  static public JButton jimageButtonScaledToWidth(int w, String imageID, String toolTip, Runnable action) {
    return jimageButton(scaleImageToWidth(w, imageID), toolTip, action);
  }

  static public <A> boolean any(Object pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (isTrue(callF(pred, a)))
        return true;
    return false;
  }

  static public <A> boolean any(IF1<A, Boolean> pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return true;
    return false;
  }

  static public <A> boolean any(Iterable<A> l, IF1<A, Boolean> pred) {
    return any(pred, l);
  }

  static public <A> boolean any(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return true;
    return false;
  }

  static public boolean any(Iterable<Boolean> l) {
    if (l != null)
      for (Boolean a : l) if (isTrue(a))
        return true;
    return false;
  }

  static public String microSymbol() {
    return "\u00B5";
  }

  static public List<JMenu> getMenus(JMenuBar mb) {
    if (mb == null)
      return null;
    return countIteratorAsList(mb.getMenuCount(), i -> mb.getMenu(i));
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public void addMouseListener(Container c, MouseListener l) {
    if (c != null && l != null) {
      swing(() -> {
        c.addMouseListener(l);
      });
    }
  }

  static public void addMouseListener(JComponent c, MouseListener l) {
    addMouseListener((Container) c, l);
  }

  static public int screenNrContaining(Pt p) {
    if (p == null)
      return -1;
    return indexOfFirst(allScreenBounds(), screen -> contains(screen, p));
  }

  static public Point mouseLocation() {
    return getMouseLocation();
  }

  static public long done2_always(long startTime, String desc) {
    long time = sysNow() - startTime;
    saveTiming_noPrint(time);
    print(desc + " [" + time + " ms]");
    return time;
  }

  static public long done2_always(String desc, long startTime) {
    return done2_always(startTime, desc);
  }

  static public long done2_always(long startTime) {
    return done2_always(startTime, "");
  }

  static public LinkedHashMap paramsToOrderedMap(Object... params) {
    return asLinkedHashMap(paramsToMap(params));
  }

  static public HashMap<String, List<Method>> callMC_cache = new HashMap();

  static public String callMC_key;

  static public Method callMC_value;

  static public Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  static public Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  static public JTextArea showTextWordWrapped(final String title, final String text) {
    return showWrappedText(title, text);
  }

  static public JTextArea showTextWordWrapped(Object text) {
    return showWrappedText(text);
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public File programFile(String name) {
    return prepareProgramFile(name);
  }

  static public File programFile(String progID, String name) {
    return prepareProgramFile(progID, name);
  }

  static public void setFrameContents(final Component c, final Object contents) {
    swing(() -> {
      JFrame frame = getFrame(c);
      if (frame == null)
        return;
      frame.getContentPane().removeAll();
      frame.getContentPane().setLayout(new BorderLayout());
      frame.getContentPane().add(wrap(contents));
      revalidate(frame);
    });
  }

  static public JPanel withSideMargins(Component c) {
    return withLeftAndRightMargin(c);
  }

  static public JPanel withSideMargins(int w, Component c) {
    return withLeftAndRightMargin(w, c);
  }

  static public JPanel withSideMargins(int w1, int w2, Component c) {
    return withLeftAndRightMargin(w1, w2, c);
  }

  static public void setInternalFrameContents(final Component c, final Object contents) {
    {
      swing(() -> {
        JInternalFrame frame = getInternalFrame(c);
        if (frame == null)
          return;
        frame.getContentPane().removeAll();
        frame.getContentPane().setLayout(new BorderLayout());
        if (contents != null)
          frame.getContentPane().add(wrap(contents));
        revalidate(frame);
      });
    }
  }

  static public List<String> quoteAll(String[] l) {
    return quoteAll(asList(l));
  }

  static public List<String> quoteAll(Collection<String> l) {
    List<String> x = new ArrayList();
    for (String s : l) x.add(quote(s));
    return x;
  }

  static public String renderVars_stringifier(IStringifier stringifier, Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(stringifier.toString(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + stringifier.toString(params[i + 1]));
    return trim(joinWithComma(l));
  }

  static public <A extends Component> A jMinWidthAtLeast(int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          Dimension d = new Dimension(max(w, size.width), size.height);
          c.setMinimumSize(d);
          return jPreferWidth(d.width, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    Dimension d = new Dimension(max(w, ...";
      }
    });
  }

  static public <A, B> List<B> valuesList(Map<A, B> map) {
    return cloneListSynchronizingOn(values(map), map);
  }

  static public <A, B> List<B> valuesList(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public int componentCount(Container c) {
    return numberOfChildren(c);
  }

  static public <A> List<A> nonNulls(Iterable<A> l) {
    return withoutNulls(l);
  }

  static public <A> List<A> nonNulls(A[] l) {
    return withoutNulls(l);
  }

  static public <A, B> Map<A, B> nonNulls(Map<A, B> map) {
    return withoutNulls(map);
  }

  static public <A, B> List<B> nonNulls(Iterable<A> l, IF1<A, B> f) {
    return mapNonNulls(l, f);
  }

  static public void setProgressBarTotal(JProgressBar bar, int total) {
    swingCall(bar, "setMaximum", total);
  }

  static public JScrollPane setScrollPaneBackground(Color c, JScrollPane sp) {
    if (sp != null && c != null) {
      swing(() -> {
        sp.getViewport().setBackground(c);
      });
    }
    return sp;
  }

  static public JPanel makeForm_customArrangement(F1<List<JComponent>, JPanel> arrange, final Object... _parts) {
    return makeForm_customArrangement(null, arrange, _parts);
  }

  static public JPanel makeForm_customArrangement(Boolean internalFrame, F1<List<JComponent>, JPanel> arrange, final Object... _parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          return callF(arrange, showForm_arrange1(showForm_makeComponents(internalFrame, _parts)));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return callF(arrange,\r\n      showForm_arrange1(showForm_makeComponents(intern...";
      }
    });
  }

  static public Object dm_getModule(Object moduleOrID) {
    if (moduleOrID == null || eq(moduleOrID, ""))
      return null;
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      return dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_callOS("getDynModuleByID", str(moduleOrID));
    return dm_resolveModule(moduleOrID);
  }

  static public boolean containsInstance(Iterable i, Class c) {
    if (i != null)
      for (Object o : i) if (isInstanceX(c, o))
        return true;
    return false;
  }

  static public void deleteConcept(long id) {
    db_mainConcepts().deleteConcept(id);
  }

  static public void deleteConcept(Concepts concepts, long id) {
    concepts.deleteConcept(id);
  }

  static public void deleteConcept(Concept c) {
    if (c != null)
      c.delete();
  }

  static public void deleteConcept(Concept.Ref ref) {
    if (ref != null)
      deleteConcept(ref.get());
  }

  static public void assertInstanceOf(Class type, Object o) {
    assertIsInstance(type, o);
  }

  static public void assertInstanceOf(Object o, Class type) {
    assertInstanceOf(type, o);
  }

  static public boolean deleteFileVerbose(File file) {
    if (file != null && file.delete()) {
      print("Deleted " + f2s(file));
      return true;
    }
    return false;
  }

  static public void setEnclosingViewPosition(Component c, int p_x, int p_y) {
    setEnclosingViewPosition(c, pt(p_x, p_y));
  }

  static public void setEnclosingViewPosition(Component c, Pt p) {
    setEnclosingViewPosition(c, toPoint(p));
  }

  static public void setEnclosingViewPosition(Component c, Point p) {
    if (p == null)
      return;
    JScrollPane sp = enclosingScrollPane(c);
    if (sp != null) {
      swing(() -> {
        sp.getViewport().setViewPosition(p);
      });
    }
  }

  static public boolean isCIMap(Map m) {
    return m instanceof TreeMap && ((TreeMap) m).comparator() == caseInsensitiveComparator();
  }

  static public boolean hasMethodNamed(Object obj, String method) {
    if (obj == null)
      return false;
    if (obj instanceof Class)
      return hasMethodNamed((Class) obj, method);
    return hasMethodNamed(obj.getClass(), method);
  }

  static public boolean hasMethodNamed(Class c, String method) {
    if (c == null)
      return false;
    return getMethodCache(c).cache.containsKey(method);
  }

  static public String yesNo_short(boolean b) {
    return b ? "yes" : "no";
  }

  static public boolean isGrandChildOf(Component a, Component b) {
    return swing(() -> {
      if (a == null || b == null)
        return false;
      if (a == b)
        return true;
      var _a_1 = a;
      while ((_a_1 = getParent(_a_1)) != null) if (_a_1 == b)
        return true;
      return false;
    });
  }

  static public Component addToWindowWithMargin(final Component c, final Component toAdd) {
    if (toAdd != null)
      addToWindowAndGrow(c, withMargin(toAdd));
    return c;
  }

  static public List<String> scoredSearch_prepare(String query) {
    return map(__99 -> replacePlusWithSpace(__99), splitAtSpace(query));
  }

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isSnippetID(snippetIDOrURLOrFile)) {
        String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
        IResourceLoader rl = vm_getResourceLoader();
        if (rl != null)
          return loadBufferedImage(rl.loadLibrary(snippetID));
        File dir = imageSnippetsCacheDir();
        if (loadBufferedImage_useImageCache) {
          dir.mkdirs();
          File file = new File(dir, snippetID + ".png");
          if (file.exists() && file.length() != 0)
            try {
              return ImageIO.read(file);
            } catch (Throwable e) {
              e.printStackTrace();
            }
        }
        String imageURL = snippetImageURL_http(snippetID);
        print("Loading image: " + imageURL);
        BufferedImage image = imageIO_readURL(imageURL);
        if (loadBufferedImage_useImageCache) {
          File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
          ImageIO.write(image, "png", tempFile);
          tempFile.renameTo(new File(dir, snippetID + ".png"));
        }
        return image;
      } else
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    return loadBufferedImageFile(file);
  }

  static public ThreadLocal<Boolean> imageGraphics_antiAlias = new ThreadLocal();

  static public Graphics2D imageGraphics(BufferedImage img) {
    return !isFalse(imageGraphics_antiAlias.get()) ? antiAliasGraphics(img) : createGraphics(img);
  }

  static public JSplitPane jvsplit(Swingable n, Swingable s) {
    return jvsplit(n, toComponent(s));
  }

  static public JSplitPane jvsplit(Swingable n, Component s) {
    return jvsplit(toComponent(n), s);
  }

  static public JSplitPane jvsplit(Component n, Swingable s) {
    return jvsplit(n, toComponent(s));
  }

  static public JSplitPane jvsplit(Component n, Component s) {
    return jvsplit(n, s, 0.5);
  }

  static public JSplitPane jvsplit(Swingable n, Swingable s, double splitPoint) {
    return jvsplit(n, toComponent(s), splitPoint);
  }

  static public JSplitPane jvsplit(Swingable n, Component s, double splitPoint) {
    return jvsplit(toComponent(n), s, splitPoint);
  }

  static public JSplitPane jvsplit(Component n, Swingable s, double splitPoint) {
    return jvsplit(n, toComponent(s), splitPoint);
  }

  static public JSplitPane jvsplit(Component n, Component s, double splitPoint) {
    return jvsplit(n, s, splitPoint, 0);
  }

  static public JSplitPane jvsplit(Swingable n, Swingable s, double splitPoint, int delay) {
    return jvsplit(n, toComponent(s), splitPoint, delay);
  }

  static public JSplitPane jvsplit(Swingable n, Component s, double splitPoint, int delay) {
    return jvsplit(toComponent(n), s, splitPoint, delay);
  }

  static public JSplitPane jvsplit(Component n, Swingable s, double splitPoint, int delay) {
    return jvsplit(n, toComponent(s), splitPoint, delay);
  }

  static public JSplitPane jvsplit(Component n, Component s, double splitPoint, int delay) {
    return setSplitPaneOnFirstShowing(swing(() -> new JSplitPane(JSplitPane.VERTICAL_SPLIT, wrap(n), wrap(s))), splitPoint, delay);
  }

  static public JSplitPane jvsplit(double splitPoint, Swingable n, Swingable s) {
    return jvsplit(splitPoint, n, toComponent(s));
  }

  static public JSplitPane jvsplit(double splitPoint, Swingable n, Component s) {
    return jvsplit(splitPoint, toComponent(n), s);
  }

  static public JSplitPane jvsplit(double splitPoint, Component n, Swingable s) {
    return jvsplit(splitPoint, n, toComponent(s));
  }

  static public JSplitPane jvsplit(double splitPoint, Component n, Component s) {
    return jvsplit(splitPoint, 0, n, s);
  }

  static public JSplitPane jvsplit(double splitPoint, int delay, Swingable n, Swingable s) {
    return jvsplit(splitPoint, delay, n, toComponent(s));
  }

  static public JSplitPane jvsplit(double splitPoint, int delay, Swingable n, Component s) {
    return jvsplit(splitPoint, delay, toComponent(n), s);
  }

  static public JSplitPane jvsplit(double splitPoint, int delay, Component n, Swingable s) {
    return jvsplit(splitPoint, delay, n, toComponent(s));
  }

  static public JSplitPane jvsplit(double splitPoint, int delay, Component n, Component s) {
    return jvsplit(n, s, splitPoint, delay);
  }

  static public LayoutManager layoutManagerFromFunction(final Object layouter) {
    if (layouter instanceof LayoutManager)
      return ((LayoutManager) layouter);
    return new AbstractLayoutManager() {

      public void layoutContainer(Container parent) {
        Object size = pcallF(layouter, parent);
        if (size instanceof Dimension)
          preferredSize = (Dimension) size;
        else if (size instanceof Pair) {
          preferredSize = (Dimension) ((Pair) size).a;
          minimumSize = (Dimension) ((Pair) size).b;
        }
      }
    };
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String yesNoShort(boolean b) {
    return yesNo_short(b);
  }

  static public <A, B> Pair<A, B> entryToPair(Map.Entry<A, B> e) {
    return mapEntryToPair(e);
  }

  static public <A> Map<String, A> syncCIMap() {
    return (Map) synchroMap(caseInsensitiveMap());
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      vmBus_send("locking", lock, "thread", currentThread());
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      vmBus_send("locked", lock, "thread", currentThread());
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public void centerWindowWithin(Window w, Rect r) {
    if (w != null) {
      swing(() -> {
        w.setLocation(r.x + (r.w - w.getWidth()) / 2, r.y + (r.h - w.getHeight()) / 2);
      });
    }
  }

  static public Runnable toRunnable(final Object o) {
    if (o == null)
      return null;
    if (o instanceof Runnable)
      return (Runnable) o;
    if (o instanceof String)
      throw fail("callF_legacy");
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public Color colorWithAlpha(Color c, double alpha) {
    return new Color(c.getRed() / 255f, c.getGreen() / 255f, c.getBlue() / 255f, (float) clampZeroToOne(alpha));
  }

  static public Color colorWithAlpha(double alpha, Color c) {
    return colorWithAlpha(c, alpha);
  }

  static public BWImage toBWImage(RGBImage img) {
    return toBW(img);
  }

  static public BWImage toBWImage(BufferedImage img) {
    return img == null ? null : new BWImage(img);
  }

  static public BWImage toBWImage(MakesBufferedImage img) {
    if (img == null)
      return null;
    if (img instanceof BWImage)
      return ((BWImage) img);
    return new BWImage(toBufferedImage(img));
  }

  static public void setCaret(final JTextComponent c, final int pos) {
    if (c != null) {
      swing(() -> {
        c.setCaretPosition(pos);
      });
    }
  }

  static public TitledBorder jRaisedSectionBorder(String title) {
    return swing(() -> {
      Border border = BorderFactory.createBevelBorder(BevelBorder.RAISED);
      return BorderFactory.createTitledBorder(border, title);
    });
  }

  static public String structForUser(Object o) {
    return structureForUser(o);
  }

  static public String structForUser(Object o, structure_Data data) {
    return structureForUser(o, data);
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public void setSectionTitle(JComponent c, String title) {
    swing(() -> {
      var _c_1 = c;
      while (_c_1 != null) {
        var b = _c_1.getBorder();
        if (b != null) {
          if (b instanceof javax.swing.border.TitledBorder) {
            ((javax.swing.border.TitledBorder) b).setTitle(title);
            revalidate(_c_1);
            return;
          }
        }
        if (_c_1.getParent() instanceof JComponent)
          _c_1 = (JComponent) _c_1.getParent();
        else
          break;
      }
    });
  }

  static public Color white() {
    return Color.white;
  }

  static public void makeTableUneditable(JTable table) {
    for (int c = 0; c < table.getColumnCount(); c++) {
      Class<?> col_class = table.getColumnClass(c);
      table.setDefaultEditor(col_class, null);
    }
  }

  static public ThreadLocal<Boolean> dataToTable_useStruct = threadLocalWithDefault(true);

  static public void dataToTable_dynSet(List l, int i, Object s) {
    while (i >= l.size()) l.add("");
    l.set(i, s);
  }

  static public List dataToTable_makeRow(Object x, List<String> cols) {
    if (instanceOf(x, "DynamicObject"))
      x = get_raw(x, "fieldValues");
    if (x instanceof Map) {
      Map m = (Map) x;
      List row = new ArrayList();
      for (Object _field : keysWithoutHidden(m)) {
        String field = (String) _field;
        Object value = m.get(field);
        int col = cols.indexOf(field);
        if (col < 0) {
          cols.add(field);
          col = cols.size() - 1;
        }
        dataToTable_dynSet(row, col, dataToTable_wrapValue(value));
      }
      return row;
    }
    if (x instanceof List)
      return allToString((List) x);
    return litlist(structureOrText(x));
  }

  static public Object dataToTable_wrapValue(Object o) {
    if (o instanceof BufferedImage)
      return o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof RGBImage)
      return o;
    if (o instanceof Boolean)
      return o;
    return dataToTable_useStruct.get() ? structureOrTextForUser(o) : strOrNull(o);
  }

  static public <A> A syncGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    synchronized (l) {
      return idx < l(l) ? l.get(idx) : null;
    }
  }

  static public <A, B> B syncGet(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.get(a);
    }
  }

  static public <B> List<B> mapLines(String text, F1<String, B> f) {
    return mapLines(f, text);
  }

  static public <B> List<B> mapLines(F1<String, B> f, String text) {
    return mapLines(f1ToIF1(f), text);
  }

  static public <B> List<B> mapLines(String text, IF1<String, B> f) {
    return mapLines(f, text);
  }

  static public <B> List<B> mapLines(IF1<String, B> f, String text) {
    return map(f, lines(text));
  }

  static public JTabbedPane jLeftOrTopTabs(boolean horizontal, Object... x) {
    return horizontal ? jLeftTabs(x) : jtabs(x);
  }

  static public JTabbedPane jLeftOrTopTabs(boolean horizontal, Collection c) {
    return horizontal ? jLeftTabs(c) : jtabs(c);
  }

  static public void failIfOddCount(Object... list) {
    if (odd(l(list)))
      throw fail("Odd list size: " + list);
  }

  static public DoubleRect doubleRectFromPoints(double x1, double y1, double x2, double y2) {
    return new DoubleRect(x1, y1, x2 - x1, y2 - y1);
  }

  static public <A extends Concept> List<A> cdelete(Class<A> c, Object... params) {
    return deleteConcepts(c, params);
  }

  static public void cdelete(Concept c) {
    deleteConcept(c);
  }

  static public <A extends Concept> void cdelete(Collection<A> c) {
    for (A a : cloneList(c)) cdelete(a);
  }

  static public void onFrameClose(Component c, final Runnable r) {
    JFrame f = getFrame(c);
    if (f != null)
      f.addWindowListener(new WindowAdapter() {

        public void windowClosing(WindowEvent e) {
          try {
            r.run();
          } catch (Throwable __e) {
            messageBox(__e);
          }
        }
      });
  }

  static public RootPaneContainer getPossiblyInternalFrame(Component c) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      return f;
    return optCast(RootPaneContainer.class, getWindow(c));
  }

  static public Class hotwireCoreSpecialMainClass(String mainClassName, List<File> files) {
    try {
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      Class<?> theClass = classLoader.loadClass(mainClassName);
      setOpt(theClass, "__javax", getJavaX());
      if (getOpt(theClass, "programID") == null)
        setOpt(theClass, "programID", "#3999999");
      if (!_inCore())
        hotwire_copyOver(theClass);
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void scrollTableDownNow(final JTable table) {
    if (table != null) {
      swing(() -> {
        table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
      });
    }
  }

  static public String appendBracketedCount(int n, String a) {
    return appendBracketed(a, n2(n));
  }

  static public String appendBracketedCount(String a, int n) {
    return appendBracketedCount(n, a);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public String spaces(int n) {
    return rep(' ', n);
  }

  static public boolean isExtendedStateNormal(JFrame f) {
    return f != null && swing(() -> f.getExtendedState() == JFrame.NORMAL);
  }

  static public List<String> sortedIgnoreCase(Collection<String> c) {
    List<String> l = cloneList(c);
    Collections.sort(l, caseInsensitiveComparator());
    return l;
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public String formatDoubleX(double d, int digits) {
    return formatDoubleFull(d, digits);
  }

  static public long ptToLong(Pt p) {
    return p == null ? -1 : intPairToLong(p.x, p.y);
  }

  static public long ptToLong(int x, int y) {
    return intPairToLong(x, y);
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public BufferedImage img_addBorder(BufferedImage img, Color color, int border) {
    int top = border, bottom = border, left = border, right = border;
    int w = img.getWidth(), h = img.getHeight();
    BufferedImage img2 = createBufferedImage(left + w + right, top + h + bottom, color);
    Graphics2D g = img2.createGraphics();
    g.drawImage(img, left, top, null);
    g.dispose();
    return img2;
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  static public void growWindowSouth(Component c, final int howMuch) {
    final Window w = getWindow(c);
    if (w != null) {
      swing(() -> {
        Rectangle r = w.getBounds();
        w.setBounds(r.x, r.y, r.width, r.height + howMuch);
      });
    }
  }

  static public <A extends JLabel, B> A bindJLabelToTransformedLiveValue(IF1<B, Object> f, A label, LiveValue<B> lv) {
    bindLiveValueListenerToComponent(label, lv, () -> {
      setText(label, strOrNull(f.get(lv.get())));
    });
    return label;
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, List<String> colNames) {
    fillTableWithStrings(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithStrings_makeModel(rows, colNames);
    swingNowOrLater(new Runnable() {

      public void run() {
        try {
          setTableModel(table, model);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setTableModel(table, model);";
      }
    });
  }

  static public DefaultTableModel fillTableWithStrings_makeModel(List<List<String>> rows, String... colNames) {
    Object[][] data = new Object[rows.size()][];
    int w = 0;
    for (int i = 0; i < rows.size(); i++) {
      List<String> l = rows.get(i);
      Object[] r = new Object[l.size()];
      for (int j = 0; j < l.size(); j++) r[j] = l.get(j);
      data[i] = r;
      w = Math.max(w, l.size());
    }
    Object[] columnNames = new Object[w];
    for (int i = 0; i < w; i++) columnNames[i] = i < l(colNames) ? colNames[i] : "?";
    return new DefaultTableModel(data, columnNames);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable) {
    return actionListenerInNewThread(runnable, null);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          startThread("Action Listener", new Runnable() {

            public void run() {
              try {
                AutoCloseable __1 = holdInstance(instanceToHold);
                try {
                  callF(runnable);
                } finally {
                  _close(__1);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1 = holdInstance(instanceToHold); try {\r\n      callF(runnable...";
            }
          });
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateWithIndex(Iterable<A> l) {
    return iterateListWithIndex(l);
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateWithIndex(A[] l) {
    return iterateWithIndex(asVirtualList(l));
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public <A, B extends A> void _addAll(Collection<A> c, Iterable<B> b) {
    addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, Collection<B> b) {
    return addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, B... b) {
    return addAll(c, b);
  }

  static public JTabbedPane scrollingTabs(JTabbedPane pane) {
    if (pane != null) {
      swing(() -> {
        pane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
      });
    }
    return pane;
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public JTabbedPane fillJTabs(final JTabbedPane tabs, final Object... _x) {
    if (tabs == null)
      return null;
    clearTabs(tabs);
    Object[] x = flattenArray2(_x);
    int idx = 0;
    if (get(x, 0) instanceof Integer) {
      idx = asInt(get(x, 0));
      x = dropFirst(x);
      if (empty(x)) {
        x = arrayrep(null, idx);
        idx = 0;
      }
    }
    int n = 0;
    for (int i = 0; i < l(x); i++) {
      ++n;
      Object o = x[i];
      if (isComponentOrSwingable(o))
        addTab(tabs, "Tab " + n, wrap(o));
      else {
        String toolTip = "";
        if (o instanceof WithToolTip) {
          toolTip = ((WithToolTip) o).toolTip();
          o = ((WithToolTip) o).get();
        }
        String name = str(or(o, "Tab " + n));
        Component c;
        if (isComponentOrSwingable(get(x, i + 1)))
          c = wrap(get(x, ++i));
        else
          c = new JPanel();
        addTabWithToolTip(tabs, name, toolTip, wrap(c));
      }
    }
    if (idx != 0)
      tabs.setSelectedIndex(min(tabs.getTabCount() - 1, idx));
    return tabs;
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public long sleepUntilSys(long sysTime) {
    long time = sysTime - sysNow();
    sleep(time);
    return time;
  }

  static public void addButtonsToWindow(Component c, Object... buttonParams) {
    addToWindowWithMargin(c, jcenteredbuttons(buttonParams));
  }

  static public boolean isStringStartingWith(Object o, String prefix) {
    return o instanceof String && ((String) o).startsWith(prefix);
  }

  static public IterableIterator<String> lines_iterator(final String s) {
    if (s == null)
      return emptyIterableIterator();
    return iteratorFromFunction(new F0<String>() {

      public int start = 0;

      public String get() {
        int i = toLines_nextLineBreak(s, start);
        if (i < 0) {
          String toReturn = s.length() > start ? s.substring(start) : null;
          start = s.length();
          return toReturn;
        }
        String toReturn = s.substring(start, i);
        if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
          i += 2;
        else
          ++i;
        start = i;
        return toReturn;
      }
    });
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public JPanel westAndCenterWithMargin(Component w, Component c) {
    return westAndCenter(withRightMargin(w), c);
  }

  static public JPanel westAndCenterWithMargin(int margin, Component w, Component c) {
    return westAndCenter(withRightMargin(margin, w), c);
  }

  static public JPanel hstack(Object... parts) {
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.weighty = 1;
    gbc.fill = GridBagConstraints.VERTICAL;
    gbc.gridheight = GridBagConstraints.REMAINDER;
    smartAddWithLayout(panel, gbc, parts);
    gbc.weightx = 1;
    panel.add(jrigid(), gbc);
    return panel;
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A, B extends Number> A lowest(Map<A, B> map) {
    A best = null;
    Number bestScore = null;
    for (A key : keys(map)) {
      Number score = map.get(key);
      if (best == null || cmp(score, bestScore) < 0) {
        best = key;
        bestScore = score;
      }
    }
    return best;
  }

  static public <A> A lowest(Iterable<A> l, IF1<A, Number> f) {
    return lowestByScoreFunction(l, f);
  }

  static public ThreadLocal<Boolean> doPost_silently = new ThreadLocal();

  static public ThreadLocal<Long> doPost_timeout = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> doPost_extraHeaders = new ThreadLocal();

  static public String doPost(String url, Map urlParameters) {
    return doPost(urlParameters, url);
  }

  static public String doPost(Map urlParameters, String url) {
    return doPost(makePostData(urlParameters), url);
  }

  static public String doPost(String urlParameters, String url) {
    try {
      URL _url = new URL(url);
      ping();
      return doPost(urlParameters, _url.openConnection(), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String doPost(String urlParameters, URLConnection conn, URL url) {
    try {
      boolean silently = isTrue(optParam(doPost_silently));
      Long timeout = optParam(doPost_timeout);
      Map<String, String> extraHeaders = optPar(doPost_extraHeaders);
      setHeaders(conn);
      for (String key : keys(extraHeaders)) {
        conn.setRequestProperty(key, extraHeaders.get(key));
      }
      int l = lUtf8(urlParameters);
      if (!silently)
        print("Sending POST request: " + hideCredentials(url) + " (" + l + " bytes)");
      if (timeout != null)
        setURLConnectionTimeouts(conn, timeout);
      ((HttpURLConnection) conn).setRequestMethod("POST");
      ((HttpURLConnection) conn).setDoOutput(true);
      ((HttpURLConnection) conn).setFixedLengthStreamingMode(l);
      OutputStreamWriter writer = new OutputStreamWriter(((HttpURLConnection) conn).getOutputStream(), "UTF-8");
      writer.write(urlParameters);
      writer.flush();
      String contents = loadPage_utf8(((HttpURLConnection) conn), url, false);
      writer.close();
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BWIntegralImage bwIntegralImage_withMeta(BufferedImage img) {
    return bwIntegralImage_withMeta(img, null);
  }

  static public BWIntegralImage bwIntegralImage_withMeta(BufferedImage img, Decolorizer decolorizer) {
    return setMetaSrc(bwIntegralImage(img, decolorizer), img);
  }

  static public BWIntegralImage bwIntegralImage_withMeta(BWImage img) {
    return setMetaSrc(bwIntegralImage(img), img);
  }

  static public List<Color> colorPaletteByBits(int bits) {
    return map(outerProduct(rep(3, countIteratorAsList(0, 1 << bits, i -> iround(i * 255.0 / (1 << bits - 1))))), rgb -> new Color(first(rgb), second(rgb), third(rgb)));
  }

  static public boolean showTable_searcher = true;

  static public JTable showTable(Object data) {
    return dataToTable_uneditable(data);
  }

  static public JTable showTable(String title, Object data) {
    return showTable(data, title);
  }

  static public JTable showTable(Object data, String title) {
    return dataToTable_uneditable(data, title);
  }

  static public JTable showTable(JTable table, Object data) {
    return showTable(table, data, autoFrameTitle());
  }

  static public JTable showTable(Object data, JTable table) {
    return showTable(table, data);
  }

  static public JTable showTable(JTable table, Object data, String title) {
    if (table == null)
      table = showTable(data, title);
    else {
      setFrameTitle(table, title);
      dataToTable_uneditable(table, data);
    }
    return table;
  }

  static public JTable showTable() {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>());
  }

  static public JTable showTable(String title) {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>(), title);
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols) {
    return showTable(rows, cols, autoFrameTitle());
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols, String title) {
    JTable tbl = sexyTable();
    fillTableWithStrings(tbl, rows, cols);
    showFrame(title, tbl);
    return tbl;
  }

  static public File userDir_oneOf(String... names) {
    return oneOfTheFilesInDir(userDir(), names);
  }

  static public boolean showTitledForm_blocking(String title, Object... _parts) {
    assertNotOnAWTThread();
    final Var<Boolean> var = new Var();
    onFrameClose(showFormTitled(title, arrayPlus(_parts, new Runnable() {

      public void run() {
        try {
          var.set(true);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var.set(true)";
      }
    })), new Runnable() {

      public void run() {
        try {
          if (!var.has())
            var.set(false);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (!var.has()) var.set(false)";
      }
    });
    waitUntilVarSet(var);
    return var.get();
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    return con.getInputStream();
  }

  static public String stackTraceToString(StackTraceElement[] st) {
    return lines(st);
  }

  static public String stackTraceToString(Throwable e) {
    return getStackTrace_noRecord(e);
  }

  static public Object getTableCell(JTable tbl, int row, int col) {
    if (row >= 0 && row < tbl.getModel().getRowCount())
      return tbl.getModel().getValueAt(row, col);
    return null;
  }

  static public BWIntegralImage bwIntegralImage(BufferedImage img) {
    return bwIntegralImage(img, null);
  }

  static public BWIntegralImage bwIntegralImage(BufferedImage img, Decolorizer decolorizer) {
    return img == null ? null : new BWIntegralImage(img, decolorizer);
  }

  static public BWIntegralImage bwIntegralImage(BWImage img) {
    return img == null ? null : new BWIntegralImage(img);
  }

  static public BWIntegralImage bwIntegralImage(IBWImage img) {
    return img == null ? null : new BWIntegralImage(img);
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public byte clampToUByte(long l) {
    return (byte) clamp(l, 0, 255);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public void clearTabs(final JTabbedPane tabs) {
    if (tabs != null) {
      swing(() -> {
        tabs.removeAll();
      });
    }
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public Font deriveFont(Font font, float size) {
    return font == null ? null : font.deriveFont(size);
  }

  static public <A> JComboBox<A> selectItem(A item, JComboBox<A> cb) {
    if (cb != null) {
      swing(() -> {
        cb.setSelectedItem(item);
      });
    }
    return cb;
  }

  static public <A> JComboBox<A> selectItem(JComboBox<A> cb, A item) {
    return selectItem(item, cb);
  }

  static public <A> JList<A> selectItem(JList<A> list, A item) {
    {
      swing(() -> {
        selectRow(list, jlist_indexOf(list, item));
      });
    }
    return list;
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public <A extends JComponent> A setMargin(final int w, final int h, final A a) {
    if (a != null) {
      swing(() -> {
        a.setBorder(BorderFactory.createEmptyBorder(h, w, h, w));
      });
    }
    return a;
  }

  static public <A extends JComponent> A setMargin(int w, A a) {
    return setMargin(w, w, a);
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public <B> Map<String, B> humanizeKeys(Map<String, B> map) {
    return mapKeys(__100 -> humanizeFormLabel(__100), map);
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String[] a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(String[] a, String b, int i) {
    int n = a == null ? 0 : a.length;
    for (; i < n; i++) if (eqic(a[i], b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public Class<?> getClass(String name) {
    return _getClass(name);
  }

  static public Class getClass(Object o) {
    return _getClass(o);
  }

  static public Class getClass(Object realm, String name) {
    return _getClass(realm, name);
  }

  static public void fillTableWithData(final JTable table, List<List> rows, List<String> colNames) {
    fillTableWithData(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithData(final JTable table, List<List> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithData_makeModel(rows, colNames);
    setTableModel(table, model);
  }

  static public DefaultTableModel fillTableWithData_makeModel(List<List> rows, String... colNames) {
    Pair<Object[][], Object[]> p = fillTableWithData_makeData(rows, colNames);
    return new DefaultTableModel(p.a, p.b) {

      public Class getColumnClass(int column) {
        return or(_getClass(getValueAt(0, column)), String.class);
      }

      public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
      }
    };
  }

  static public void waitUntil(int interval, IF0<Boolean> condition) {
    if (condition == null)
      return;
    while (!condition.get()) sleep(interval);
  }

  static public boolean waitUntil(int interval, double timeout, IF0<Boolean> condition) {
    if (condition == null)
      return false;
    long start = sysNow();
    while (sysNow() < start + toMS(timeout)) if (condition.get())
      return true;
    else
      sleep(interval);
    return false;
  }

  static public void printRunningThreads() {
    List<String> threads = valuesList(runnableThreadsWithRenderedStackTraces_withoutSystemThreads());
    for (int i = 0; i < l(threads); i++) print("\n[Thread " + (i + 1) + "/" + l(threads) + "] " + threads.get(i));
  }

  static public double scoredSearch_scoreWeighted2(Collection<Pair<String, Double>> l, List<String> words) {
    double score = 0;
    if (l != null)
      for (Pair<String, Double> __0 : l) {
        String s = pairA(__0);
        double weight = pairB(__0);
        score += scoredSearch_score(s, words) * weight;
      }
    return score;
  }

  static public Random defaultRandomizer() {
    return defaultRandomGenerator();
  }

  static public JLabel jcenteredlabel(String text) {
    return jcenteredLabel(text);
  }

  static public JLabel jcenteredlabel() {
    return jcenteredLabel();
  }

  static public boolean anyValueContainsIgnoreCase(Map map, String pat) {
    for (Object val : values(map)) if (val instanceof String && containsIgnoreCase((String) val, pat))
      return true;
    return false;
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, A[] l) {
    return firstThat(l, pred);
  }

  static public List<Map<String, Object>> rawTableData(JTable t) {
    int n = tableRows(t);
    List l = new ArrayList();
    for (int i = 0; i < n; i++) l.add(rawTableLineAsMap(t, i));
    return l;
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public File saveImageWithCounter(File dir, String baseName, BufferedImage img) {
    if (img == null || dir == null)
      return null;
    if (!isImageFileName(baseName))
      baseName += ".png";
    File f = makeFileNameUnique_beforeExtension_startWith1_noDot(newFile(dir, baseName));
    saveImage(f, img);
    infoBox("Saved image " + appendBracketed(img.getWidth(null) + "*" + img.getHeight(null)) + ": " + fileInfo(f));
    return f;
  }

  static public <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
    if (empty(params))
      return list;
    List<A> l = new ArrayList();
    for (A x : list) if (checkConceptFields(x, params))
      l.add(x);
    return l;
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public <A, B> void mapPut2(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        map.put(key, value);
      else
        map.remove(key);
  }

  static public int screenNrOfWindow(Window w) {
    if (w == null)
      return -1;
    Rect bounds = boundsAsRect(w);
    return indexOfMax(allScreenBounds(), screen -> area(intersectRects(bounds, screen)));
  }

  static public Object dm_resolveModule(Object moduleOrStem) {
    return dm_callOS("resolveModule", moduleOrStem);
  }

  static public boolean isMain() {
    return isMainProgram();
  }

  static public <A, B> boolean containsKey(Map<A, B> map, A key) {
    return map != null && map.containsKey(key);
  }

  static public String addFileSep(String path) {
    return addSuffix(path, fileSep());
  }

  static public boolean containsATextArea(Component c) {
    return childOfType(c, JTextArea.class) != null;
  }

  static public String jsonEncode(Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode(o, buf);
    return str(buf);
  }

  static public void jsonEncode(Object o, StringBuilder buf) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode(map.get(key), buf);
      }
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        jsonEncode(element, buf);
      }
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public Matcher regexpMatcher(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public Component verticalStrut(int height) {
    return Box.createVerticalStrut(height);
  }

  static public boolean containsTabNameWithoutTrailingCount(JTabbedPane tabs, String name) {
    return indexOfTabNameWithoutTrailingCount(tabs, name) >= 0;
  }

  static public String errorIconID() {
    return "#1101390";
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    return o;
  }

  static public boolean confirmOKCancel(final Component owner, final String msg) {
    return isTrue(swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return JOptionPane.showConfirmDialog(owner, msg, "JavaX", JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return JOptionPane.showConfirmDialog(owner,\r\n      msg, \"JavaX\", JOptionPane....";
      }
    }));
  }

  static public boolean confirmOKCancel(String msg) {
    return confirmOKCancel(null, msg);
  }

  static public <A extends JComponent> A focusOnShow(final A a) {
    onFirstComponentShow(a, new Runnable() {

      public void run() {
        try {
          focus(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "focus(a)";
      }
    });
    return a;
  }

  static public String structureOrTextForUser(Object o) {
    return o == null ? "" : o instanceof String ? (String) o : structureForUser(o);
  }

  static public JTable dataToTable_uneditable(Object data, final JTable table) {
    return dataToTable_uneditable(table, data);
  }

  static public JTable dataToTable_uneditable(final JTable table, final Object data) {
    if (table != null) {
      swing(() -> {
        dataToTable(table, data, true);
        makeTableUneditable(table);
      });
    }
    return table;
  }

  static public JTable dataToTable_uneditable(final Object data) {
    return dataToTable_uneditable(showTable(), data);
  }

  static public JTable dataToTable_uneditable(Object data, String title) {
    return dataToTable_uneditable(showTable(title), data);
  }

  static public BufferedImageWithMeta cloneBufferedImageWithMeta(BufferedImage img) {
    if (img == null)
      return null;
    if (img instanceof BufferedImageWithMeta)
      return ((BufferedImageWithMeta) img);
    Hashtable<String, Object> properties = new Hashtable();
    var names = img.getPropertyNames();
    if (names != null)
      for (var key : names) properties.put(key, img.getProperty(key));
    if (!properties.containsKey("meta"))
      properties.put("meta", new Meta());
    var cm = img.getColorModel();
    var img2 = new BufferedImageWithMeta(cm, img.getRaster(), cm.hasAlpha() && cm.isAlphaPremultiplied(), properties);
    assertNotNull(toIMeta(img2));
    return img2;
  }

  static public int asInt(Object o) {
    return toInt(o);
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public Rect rightScreenBounds() {
    return second(allScreenBounds());
  }

  static public BufferedImage scaleImageToWidth(BufferedImage img, int newW) {
    return resizeImage(img, newW);
  }

  static public BufferedImage scaleImageToWidth(int newW, BufferedImage img) {
    return scaleImageToWidth(img, newW);
  }

  static public BufferedImage scaleImageToWidth(int newW, String imageID) {
    return scaleImageToWidth(newW, loadImage2(imageID));
  }

  static public Object[] mapToArray(Map map) {
    return mapToObjectArray(map);
  }

  static public Object[] mapToArray(Object f, Collection l) {
    return mapToObjectArray(f, l);
  }

  static public Object[] mapToArray(Object f, Object[] l) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(l, f);
  }

  static public <A> Object[] mapToArray(A[] l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToArray(IF1<A, Object> f, A[] l) {
    return mapToObjectArray(f, l);
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public String htmlDecode(String input) {
    return htmldecode(input);
  }

  static public <A> A setAll(A o, Map<String, Object> fields) {
    if (fields == null)
      return o;
    for (String field : keys(fields)) set(o, field, fields.get(field));
    return o;
  }

  static public <A> A setAll(A o, Object... values) {
    failIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      set(o, field, value);
    }
    return o;
  }

  static public int lUtf8(String s) {
    return l(utf8(s));
  }

  static public JPanel centerSection(JPanel section) {
    if (section != null) {
      swing(() -> {
        Border border = section.getBorder();
        if (border instanceof TitledBorder)
          ((TitledBorder) border).setTitleJustification(TitledBorder.CENTER);
      });
    }
    return section;
  }

  static public <A, B extends Collection<A>> B addAllAndReturnCollection(B c, Collection<A> b) {
    if (c != null && b != null)
      c.addAll(b);
    return c;
  }

  static public <A, B extends Collection<A>> B addAllAndReturnCollection(B c, A... b) {
    addAll(c, b);
    return c;
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, Object r) {
    swingEvery(component, delay, r);
    return component;
  }

  static public <A extends JComponent> A awtEvery(long delay, A component, Runnable r) {
    return awtEvery(component, delay, delay, (Object) r);
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, Runnable r) {
    return awtEvery(component, delay, delay, r);
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, long firstDelay, Runnable r) {
    return awtEvery(component, delay, firstDelay, (Object) r);
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, long firstDelay, Object r) {
    swingEvery(component, delay, firstDelay, r);
    return component;
  }

  static public void awtEvery(RootPaneContainer frame, long delay, Object r) {
    swingEvery(frame, delay, r);
  }

  static public <A extends JComponent> A awtEvery(A component, double firstDelaySeconds, double delaySeconds, Object r) {
    return awtEvery(component, toMS(firstDelaySeconds), toMS(delaySeconds), r);
  }

  static public <A extends JComponent> A awtEvery(A component, double delaySeconds, Object r) {
    return awtEvery(component, toMS(delaySeconds), r);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public String firstIntAsString(String s) {
    return jextract("<int>", s);
  }

  static public Color blendColors(double bish, Color a, Color b) {
    return blendColors(a, b, bish);
  }

  static public Color blendColors(Color a, Color b, double bish) {
    bish = clampZeroToOne(bish);
    return new Color((float) blend(a.getRed() / 255.0, b.getRed() / 255.0, bish), (float) blend(a.getGreen() / 255.0, b.getGreen() / 255.0, bish), (float) blend(a.getBlue() / 255.0, b.getBlue() / 255.0, bish));
  }

  static public Component frameIcon(Component c, String imageID) {
    setFrameIconLater(c, imageID);
    return c;
  }

  static public Component frameIcon(String imageID, Component c) {
    setFrameIconLater(c, imageID);
    return c;
  }

  static public int random_incl(int min, int max) {
    return random_incl(min, max, defaultRandomizer());
  }

  static public int random_incl(int min, int max, Random random) {
    return random(min, max + 1, random);
  }

  static public int random_incl(int max) {
    return random(0, max + 1);
  }

  static public List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  static public class CriticalAction implements AutoCloseable {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    final public void close() {
      done();
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  static public CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  static public void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          pcallFail(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  static public JScrollPane jscrollHorizontal(final Component c) {
    return swing(new F0<JScrollPane>() {

      public JScrollPane get() {
        try {
          return new JScrollPane(c, ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return new JScrollPane(c,\r\n    ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER,\r...";
      }
    });
  }

  static public void imageSurfaceOnLeftMouseDown(ImageSurface is, IVF1<Pt> action) {
    if (is == null || action == null)
      return;
    {
      swing(() -> {
        MouseAdapter ma = new MouseAdapter() {

          public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1)
              pcallF(action, is.pointFromEvent(e));
          }
        };
        is.addMouseListener(ma);
      });
    }
  }

  static public Color toColor(RGB rgb) {
    return rgb == null ? null : rgb.getColor();
  }

  static public Color toColor(int rgb) {
    return new Color(rgb);
  }

  static public Color toColor(String hex) {
    return awtColor(hex);
  }

  static public Color toColor(int[] rgb) {
    return new Color(rgb[0], rgb[1], rgb[2]);
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Character> asList(char[] a) {
    if (a == null)
      return null;
    ArrayList<Character> l = emptyList(a.length);
    for (var i : a) l.add(i);
    return l;
  }

  static public ArrayList<Byte> asList(byte[] a) {
    if (a == null)
      return null;
    ArrayList<Byte> l = emptyList(a.length);
    for (var i : a) l.add(i);
    return l;
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Long> asList(long[] a) {
    if (a == null)
      return null;
    ArrayList<Long> l = emptyList(a.length);
    for (long i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public ArrayList<Short> asList(short[] a) {
    if (a == null)
      return null;
    ArrayList<Short> l = emptyList(a.length);
    for (short i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterator<A> it) {
    ArrayList l = new ArrayList();
    if (it != null)
      while (it.hasNext()) l.add(it.next());
    return l;
  }

  static public <A> ArrayList<A> asList(IterableIterator<A> s) {
    return asList((Iterator) s);
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A> ArrayList<A> asList(ReverseChain<A> c) {
    return c == null ? emptyList() : c.toList();
  }

  static public <A> List<A> asList(Pair<A, A> p) {
    return p == null ? null : ll(p.a, p.b);
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    dynamicObject_setRawFieldValue(o, field, value);
  }

  static public Runnable wrapAsActivity(Object r) {
    if (r == null)
      return null;
    Runnable r2 = toRunnable(r);
    Object mod = dm_current_generic();
    if (mod == null)
      return r2;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable c = (AutoCloseable) (rcall("enter", mod));
          AutoCloseable __1 = c;
          try {
            r2.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "AutoCloseable c =  (AutoCloseable) (rcall enter(mod));\r\n    temp c;\r\n    r2.r...";
      }
    };
  }

  static public String str_toKB(long l) {
    return n2(toK(l)) + " KB";
  }

  static public String str_toKB(File f) {
    return str_toKB(fileSize(f));
  }

  static public class ECJError {

    public String file, error;

    public int lineNr;

    public String codeLine;

    public IntRange colRange;

    public String toString() {
      return "Error on line " + lineNr + ": " + error;
    }
  }

  static public List<ECJError> parseECJOutputForErrors(String text) {
    List<ECJError> errors = new ArrayList();
    List<String> lines = lines(text);
    for (int i = 0; i < l(lines); i++) {
      if (startsWith(lines.get(i), "---")) {
        String line = get(lines, i + 1);
        List<String> groups = regexpFirstGroups("^\\d+\\. ERROR in (.*?) \\(at line (\\d+)\\)$", line);
        if (groups != null) {
          String codeLine = get(lines, i + 2);
          String markLine = get(lines, i + 3);
          String errorLine = get(lines, i + 4);
          List<String> markGroups = regexpFirstGroups("^( *)(\\^+)", markLine);
          ECJError e = new ECJError();
          e.file = groups.get(0);
          e.error = errorLine;
          e.lineNr = parseInt(groups.get(1));
          e.codeLine = codeLine;
          int col1 = l(first(markGroups));
          int cols = l(second(markGroups));
          e.colRange = intRangeWithLength(col1 + 1, cols);
          errors.add(e);
        }
      }
    }
    return errors;
  }

  static public SingleComponentPanel jOnDemand(IF0<JComponent> makeComponent) {
    SingleComponentPanel scp = singleComponentPanel();
    bindToComponent(scp, () -> {
      if (!scp.isEmpty())
        return;
      try {
        scp.setComponent(makeComponent == null ? null : makeComponent.get());
      } catch (Throwable e) {
        printStackTrace(e);
        scp.setComponent(jscroll(jFastLogView_noWrap(renderStackTrace(e))));
      }
    }, null);
    return scp;
  }

  static public String singleDigitBytesToString(ByteBuffer l) {
    if (l == null)
      return null;
    int n = l.size();
    char[] data = new char[n];
    for (int i = 0; i < n; i++) data[i] = (char) ('0' + ubyteToInt(l.get(i)) % 10);
    return str(data);
  }

  static public String dropPrefixFromLines(String prefix, String s) {
    return mapEachLine(s, line -> dropPrefix(prefix, line));
  }

  static public String indentedStructureForUser(Object o) {
    return indentedStructureForUser(Integer.MAX_VALUE, o);
  }

  static public String indentedStructureForUser(int levels, Object o) {
    return indentStructureString(levels, structForUser(o));
  }

  static public String indentedStructureForUser(Object o, structure_Data data) {
    return indentedStructureForUser(Integer.MAX_VALUE, o, data);
  }

  static public String indentedStructureForUser(int levels, Object o, structure_Data data) {
    return indentStructureString(levels, structForUser(o, data));
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public List<JFrame> listAllFrames() {
    List<JFrame> l = new ArrayList();
    for (Frame f : Frame.getFrames()) if (f instanceof JFrame)
      l.add((JFrame) f);
    return l;
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public JMenuBar addMenuBar(final Component c) {
    return swing(new F0<JMenuBar>() {

      public JMenuBar get() {
        try {
          RootPaneContainer f = getPossiblyInternalFrame(c);
          if (f == null)
            return null;
          JMenuBar bar = (JMenuBar) (call(f, "getJMenuBar"));
          if (bar == null) {
            setMenuBar(f, bar = new JMenuBar());
            revalidate((Component) f);
          }
          return bar;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "RootPaneContainer f = getPossiblyInternalFrame(c);\r\n    if (f == null) null;\r...";
      }
    });
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : getDeclaredConstructors_cached(c)) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public void addTabs(JTabbedPane tabs, Object... x) {
    if (tabs == null)
      return;
    x = flattenToArray(x);
    for (int i = 0; i < l(x); i++) {
      Object o = x[i];
      if (isComponentOrSwingable(o))
        addTab(tabs, "Tab " + (tabCount(tabs) + 1), wrap(o));
      else {
        String toolTip = "";
        if (o instanceof WithToolTip) {
          toolTip = ((WithToolTip) o).toolTip();
          o = ((WithToolTip) o).get();
        }
        String name = str(or(o, "Tab " + tabCount(tabs) + 1));
        Component c;
        if (isComponentOrSwingable(get(x, i + 1)))
          c = wrap(get(x, ++i));
        else
          c = new JPanel();
        addTabWithToolTip(tabs, name, toolTip, wrap(c));
      }
    }
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public String nameRelativeToPhysicalSubdirectory(File inner, File outer) {
    try {
      if (inner == null || outer == null)
        return null;
      String path1 = inner.getCanonicalPath();
      String path2a = outer.getCanonicalPath();
      if (eq(path1, path2a))
        return "";
      String path2 = addFileSep(path2a);
      Matches m = new Matches();
      if (startsWith(path1, path2, m))
        return m.rest();
      else
        return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A enableScaffolding(A o) {
    return enableScaffolding(o, true);
  }

  static public <A> A enableScaffolding(A o, boolean b) {
    if (o instanceof IMeta)
      ((IMeta) o).metaPut("scaffolding", trueOrNull(b));
    return o;
  }

  static public void ping_okInCleanUp() {
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public Object callOptWithEnter(Object o, String method, String[] arg) {
    return callOptWithEnter(o, method, new Object[] { arg });
  }

  static public Object callOptWithEnter(Object o, String method, Object... args) {
    if (o == null)
      return null;
    AutoCloseable __1 = tempEnter(o);
    try {
      return callOpt_withVarargs(o, method, args);
    } finally {
      _close(__1);
    }
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
    pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public <A, B extends Iterable<A>> IterableIterator<List<A>> outerProduct_faster(List<B> lists) {
    return mapI(__101 -> fromSimplyLinkedList(__101), outerProduct_faster(toSimplyLinkedList(lists)));
  }

  static public <A, B extends Iterable<A>> IterableIterator<SimplyLinkedList<A>> outerProduct_faster(SimplyLinkedList<B> lists) {
    if (lists == null)
      return singletonIterator(null);
    SimplyLinkedList<B> lists2 = lists.tail;
    return nestedIterator(lists.head, new F1<A, Iterator<SimplyLinkedList<A>>>() {

      public Iterator<SimplyLinkedList<A>> get(A a) {
        try {
          return mapI(outerProduct_faster(lists2), l -> SimplyLinkedList.cons(a, l));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "mapI(outerProduct_faster(lists2), l -> SimplyLinkedList.cons(a, l))";
      }
    });
  }

  static public File envJavaHome() {
    return newFile(System.getProperty("java.home"));
  }

  static public long incAtomicLong(AtomicLong l) {
    return l.incrementAndGet();
  }

  static public <A> A copyFields(Object x, A y, String... fields) {
    if (empty(fields)) {
      Map<String, Object> map = objectToMap(x);
      for (String field : map.keySet()) setOpt(y, field, map.get(field));
    } else
      for (String field : fields) {
        Object o = getOpt(x, field);
        if (o != null)
          setOpt(y, field, o);
      }
    return y;
  }

  static public <A> A copyFields(Object x, A y, Collection<String> fields) {
    return copyFields(x, y, asStringArray(fields));
  }

  static public void onChangeAndNow(JComponent c, Object r) {
    onUpdateAndNow(c, r);
  }

  static public void onChangeAndNow(List<? extends JComponent> l, Object r) {
    onUpdateAndNow(l, r);
  }

  static public void onChangeAndNow(JTextComponent c, IVF1<String> r) {
    onUpdateAndNow(c, r);
  }

  static public <A> JComboBox<A> onChangeAndNow(JComboBox<A> cb, IVF1<A> f) {
    onChange(cb, f);
    {
      if (f != null)
        f.get(getSelectedItem_typed(cb));
    }
    return cb;
  }

  static public <A extends JTabbedPane> A onChangeAndNow(A tabs, Runnable r) {
    if (r != null) {
      onChange(tabs, r);
      r.run();
    }
    return tabs;
  }

  static public JSlider onChangeAndNow(JSlider s, Runnable f) {
    if (s != null && f != null) {
      onChange(s, f);
      f.run();
    }
    return s;
  }

  static public Object dm_getStem(Object moduleOrID) {
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      moduleOrID = dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_getStemByID(moduleOrID);
    return or(getOpt(dm_getModule(moduleOrID), "_host"), moduleOrID);
  }

  static public <A> Collection<A> asCollection(Iterable<A> l) {
    return l == null ? null : l instanceof Collection ? ((Collection) l) : asList(l);
  }

  static public double msToSeconds(long ms) {
    return toSeconds(ms);
  }

  static public double msToSeconds(double ms) {
    return toSeconds(ms);
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public Graphics2D antiAliasGraphics(BufferedImage img) {
    return antiAliasOn(createGraphics(img));
  }

  static public void updateEnclosingTabTitleWithCount(JComponent c, int n) {
    Pair<JTabbedPane, Integer> p = enclosingTab(c);
    if (p == null)
      return;
    setTabTitle(p.a, p.b, appendBracketedCount(dropTrailingBracketedCount(getTabTitle(p.a, p.b)), n));
  }

  static public <A extends JComponent> A setToolTip(A c, Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A setToolTip(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public void setToolTip(TrayIcon trayIcon, String toolTip) {
    setTrayIconToolTip(trayIcon, toolTip);
  }

  static public DynamicObject dO(String className, Object... x) {
    return dynamicObject(className, x);
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String getTextTrim(JTextComponent c) {
    return trim(getText(c));
  }

  static public String getTextTrim(JComboBox cb) {
    return trim(getText(cb));
  }

  static public String getTextTrim(JComponent c) {
    if (c instanceof JLabel)
      return trim(((JLabel) c).getText());
    if (c instanceof JComboBox)
      return getTextTrim((JComboBox) c);
    return getTextTrim((JTextComponent) c);
  }

  static public byte[] gzipString(String s) {
    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      GZIPOutputStream gos = new GZIPOutputStream(baos);
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(s);
      printWriter.close();
      gos.close();
      return baos.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A extends JComponent> A setOpaqueBackground(final Color color, final A a) {
    if (a != null) {
      swing(() -> {
        a.setBackground(color);
        a.setOpaque(true);
        a.putClientProperty("substancelaf.colorizationFactor", 1.0);
      });
    }
    return a;
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }

  static public void setSelected(AbstractButton btn, boolean selected) {
    if (btn != null) {
      swing(() -> {
        btn.setSelected(selected);
      });
    }
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public <A, B> Map<A, List<B>> multiMapToMap(MultiMap<A, B> m) {
    return m == null ? null : m.data;
  }

  static public Graphics2D graphics(BufferedImage img) {
    return imageGraphics(img);
  }

  static public int getCaretPosition(final JTextComponent c) {
    return c == null ? 0 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return c.getCaretPosition();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return c.getCaretPosition();";
      }
    });
  }

  static public boolean jInternalFrame_iconifiable = true;

  static public JInternalFrame jInternalFrame() {
    return jInternalFrame("");
  }

  static public JInternalFrame jInternalFrame(final String title) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame_iconifiable);
          f.setVisible(true);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame...";
      }
    });
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public String getStackTrace(String msg) {
    return getStackTrace_noRecord(new Throwable(msg));
  }

  static public Class javax() {
    return getJavaX();
  }

  static public String copyToClipboard(String text) {
    return copyTextToClipboard(text);
  }

  static public <A extends Image> A copyToClipboard(A image) {
    copyImageToClipboard(image);
    return image;
  }

  static public File copyToClipboard(File f) {
    return copyFileToClipboard(f);
  }

  static public JComponent withLabel(String label, JComponent component) {
    return westAndCenter(jlabel(label + " "), component);
  }

  static public JComponent withLabel(JComponent label, JComponent component) {
    return westAndCenterWithMargin(label, component);
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public void setDialogContents(JDialog dialog, JComponent contents) {
    if (dialog == null)
      return;
    {
      swing(() -> {
        dialog.getContentPane().removeAll();
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add(wrap(contents));
        revalidate(dialog);
      });
    }
  }

  static public void removeTrayIcon(final TrayIcon t) {
    if (t != null) {
      swing(() -> {
        SystemTray.getSystemTray().remove(t);
      });
    }
  }

  static public <A extends Component> A packFrameVertically(A c) {
    return packWindowVertically(c);
  }

  static public <A extends Component> A packFrameVertically(int width, A c) {
    return packWindowVertically(setFrameWidth(width, c));
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static public RSyntaxTextAreaWithSearch rSyntaxTextAreaWithSearch() {
    return new RSyntaxTextAreaWithSearch();
  }

  static public RSyntaxTextAreaWithSearch rSyntaxTextAreaWithSearch(String text) {
    var ta = rSyntaxTextAreaWithSearch();
    ta.setText(text);
    return ta;
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public boolean eq(Symbol a, String b) {
    return eq(str(a), b);
  }

  static public AutoCloseable tempDisableButtons(Collection<JButton> buttons) {
    return combineAutoCloseables(map(__102 -> tempDisableButton(__102), buttons));
  }

  static public Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int countFilesInZip(File inZip) {
    try {
      ZipFile zipFile = new ZipFile(inZip);
      try {
        return countFilesInZip(zipFile);
      } finally {
        _close(zipFile);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int countFilesInZip(ZipFile zipFile) {
    try {
      int n = 0;
      Enumeration entries = zipFile.entries();
      while (entries.hasMoreElements()) {
        ZipEntry entry = (ZipEntry) (entries.nextElement());
        if (!entry.isDirectory())
          ++n;
      }
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage renderComponentToImage(final Component c) {
    if (c == null)
      return null;
    return swing(new F0<BufferedImage>() {

      public BufferedImage get() {
        try {
          int w = getWidth(c), h = getHeight(c);
          BufferedImage img = newBufferedImage(w, h);
          c.paint(createGraphics(img));
          return img;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "int w = getWidth(c), h = getHeight(c);\r\n    BufferedImage img = newBufferedIm...";
      }
    });
  }

  static public Pt origin() {
    return pt(0, 0);
  }

  static public JFastLogView_noWrap jFastLogView_noWrap() {
    return jFastLogView_noWrap("");
  }

  static public JFastLogView_noWrap jFastLogView_noWrap(String text) {
    return withTypeWriterFont(swingNu(JFastLogView_noWrap.class, text));
  }

  static public String nResults(int n) {
    return n2(n, "result");
  }

  static public String nResults(Collection l) {
    return nResults(l(l));
  }

  static public Point enclosingViewPosition(Component c) {
    JScrollPane sp = enclosingScrollPane(c);
    return sp == null ? null : swing(new F0<Point>() {

      public Point get() {
        try {
          return sp.getViewport().getViewPosition();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return sp.getViewport().getViewPosition();";
      }
    });
  }

  static public int random(int n) {
    return random(n, defaultRandomGenerator());
  }

  static public int random(int n, Random r) {
    return random(r, n);
  }

  static public long random(long n) {
    return random(n, defaultRandomGenerator());
  }

  static public long random(long n, Random r) {
    return random(r, n);
  }

  static public int random(Random r, int n) {
    return n <= 0 ? 0 : getRandomizer(r).nextInt(n);
  }

  static public long random(Random r, long n) {
    return n <= 0 ? 0 : getRandomizer(r).nextLong(n);
  }

  static public double random(double max) {
    return random() * max;
  }

  static public double random() {
    return defaultRandomGenerator().nextInt(100001) / 100000.0;
  }

  static public double random(double min, double max) {
    return min + random() * (max - min);
  }

  static public int random(int min, int max) {
    return min + random(max - min);
  }

  static public long random(long min, long max) {
    return min + random(max - min);
  }

  static public int random(int min, int max, Random r) {
    return random(r, min, max);
  }

  static public int random(Random r, int min, int max) {
    return min + random(r, max - min);
  }

  static public <A> A random(List<A> l) {
    return oneOf(l);
  }

  static public <A> A random(Collection<A> c) {
    if (c instanceof List)
      return random((List<A>) c);
    int i = random(l(c));
    return collectionGet(c, i);
  }

  static public int random(IntRange r) {
    return random(r.start, r.end);
  }

  static public double random(DoubleRange r) {
    return random(r.start, r.end);
  }

  static public Timestamp random(TimestampRange r) {
    return r == null ? null : new Timestamp(random(r.startTime().unixDate(), r.endTime().unixDate()));
  }

  static public <A, B> Pair<A, B> random(Map<A, B> map) {
    return entryToPair(random(entries(map)));
  }

  static public Map mapKeyAndFunction(Iterable l, Object f) {
    return mapKeyAndFunction(f, l);
  }

  static public Map mapKeyAndFunction(Object f, Iterable l) {
    HashMap map = new HashMap();
    if (l != null)
      for (Object o : l) map.put(o, callF(f, o));
    return map;
  }

  static public <A, B, C> Map<A, C> mapKeyAndFunction(Map<A, B> map, IF2<A, B, C> f) {
    HashMap map2 = new HashMap();
    if (map != null)
      for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
        A key = __0.getKey();
        B value = __0.getValue();
        map2.put(key, callF(f, key, value));
      }
    return map2;
  }

  static public <A, B> Map<A, B> mapKeyAndFunction(Iterable<A> l, IF1<A, B> f) {
    return mapKeyAndFunction(f, l);
  }

  static public JPanel centerAndSouthWithMargin(Swingable c, Swingable s) {
    return centerAndSouthWithMargin(c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargin(Swingable c, Component s) {
    return centerAndSouthWithMargin(toComponent(c), s);
  }

  static public JPanel centerAndSouthWithMargin(Component c, Swingable s) {
    return centerAndSouthWithMargin(c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargin(Component c, Component s) {
    return centerAndSouth(c, withTopMargin(s));
  }

  static public JPanel centerAndSouthWithMargin(int margin, Swingable c, Swingable s) {
    return centerAndSouthWithMargin(margin, c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargin(int margin, Swingable c, Component s) {
    return centerAndSouthWithMargin(margin, toComponent(c), s);
  }

  static public JPanel centerAndSouthWithMargin(int margin, Component c, Swingable s) {
    return centerAndSouthWithMargin(margin, c, toComponent(s));
  }

  static public JPanel centerAndSouthWithMargin(int margin, Component c, Component s) {
    return centerAndSouth(c, withTopMargin(margin, s));
  }

  static public <A> List<Pair<IntRange, A>> streaksOfRepeatingElements(List<A> l) {
    List<Pair<IntRange, A>> out = new ArrayList();
    int i = 0, n = l(l);
    while (i < n) {
      A a = l.get(i);
      int j = i + 1;
      while (j < n && eq(a, l.get(j))) ++j;
      out.add(pair(intRange(i, j), a));
      i = j;
    }
    return out;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Runnable runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(runnable, name));
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public String platformName() {
    if (isWindows())
      return "Windows";
    if (isMac())
      return "Mac OS";
    return "Linux";
  }

  static public List<File> allImageFiles(File dir) {
    return filter(__103 -> isImageFile(__103), findAllFiles_noDirs(dir));
  }

  static public JPanel jRightAlignedLine(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jRightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(components);
  }

  static public List<String> reTok_multi(List<String> tok, List<IntRange> places) {
    if (empty(places))
      return tok;
    if (l(places) == 1)
      return reTok(tok, first(places));
    List<String> orig = cloneList(tok);
    sortIntRangesInPlace(places);
    List<IntRange> places2 = new ArrayList();
    for (IntRange p : places) {
      p = intRange(p.start & ~1, p.end | 1);
      if (nempty(places2) && p.start <= last(places2).end)
        last(places2).end = p.end;
      else
        places2.add(p);
    }
    int iPlace = 0, n = l(orig);
    IntRange p = get(places2, iPlace);
    int next = p.start, i = next;
    tok.subList(next, tok.size()).clear();
    while (i < n) if (i < next)
      tok.add(orig.get(i++));
    else {
      int j = p.end;
      String s = joinSubList(orig, i, j);
      tok.addAll(javaTok(s));
      i = j;
      p = get(places2, ++iPlace);
      if (p == null)
        break;
      next = p.start;
    }
    while (i < n) tok.add(orig.get(i++));
    return tok;
  }

  static public JInternalFrame minInternalFrameWidth(final JInternalFrame frame, final int w) {
    {
      swing(() -> {
        if (frame != null && frame.getWidth() < w)
          frame.setSize(w, frame.getHeight());
      });
    }
    return frame;
  }

  static public JInternalFrame minInternalFrameWidth(int w, JInternalFrame frame) {
    return minInternalFrameWidth(frame, w);
  }

  static public <A> boolean comboBoxContainsItem(JComboBox<A> cb, A item) {
    return contains(getComboBoxItems(cb), item);
  }

  static public Container getContentPane(Object o) {
    JFrame f = getFrame(o);
    return f == null ? null : f.getContentPane();
  }

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public JSpinner bindLiveValueToSpinner(IVarWithNotify<Integer> lv, JSpinner spinner) {
    onChange(spinner, () -> lv.set(intFromSpinner(spinner)));
    lv.onChange(() -> setSpinnerValue(spinner, lv.get()));
    return spinner;
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public JScrollPane jscroll_center_borderless(Component c) {
    return jscroll_centered_borderless(c);
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public <A extends Component> A setFrameSize(A c, int w, int h) {
    JFrame f = getFrame(c);
    if (f != null)
      f.setSize(w, h);
    return c;
  }

  static public <A extends Component> A setFrameSize(int w, int h, A c) {
    return setFrameSize(c, w, h);
  }

  static public String ffmpegLibraryIDForPlatform() {
    if (isLinux())
      return "#1400557";
    else if (isWindows())
      return "#1400558";
    else
      return null;
  }

  static public AutoCloseable tempUncancelThread() {
    return tempPingPrivileged();
  }

  static public Map synchroHashMap() {
    return synchronizedMap(new HashMap());
  }

  static public JPanel withMargins(Component c) {
    return withMargin(c);
  }

  static public JPanel withMargins(int w, Component c) {
    return withMargin(w, c);
  }

  static public JPanel withMargins(int w, int h, Component c) {
    return withMargin(w, h, c);
  }

  static public JPanel withMargins(int top, int left, int bottom, int right, Component c) {
    return withMargin(top, left, bottom, right, c);
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public int selectedTabIndex(JExtendedTabbedPane tabs) {
    return tabs == null ? -1 : swing(() -> tabs.getSelectedIndex());
  }

  static public int selectedTabIndex(JTabbedPane tabs) {
    return tabs == null ? -1 : swing(() -> tabs.getSelectedIndex());
  }

  static public void removeAllComponents(final Container c) {
    if (c != null) {
      swing(() -> {
        c.removeAll();
        revalidate(c);
      });
    }
  }

  static public String appendQueryToURL(String url, Map params) {
    if (url == null)
      return null;
    String data = makePostData(params);
    if (empty(data))
      return url;
    int idx = smartIndexOf(url, '#');
    String url2 = takeFirst(url, idx);
    return url2 + (url2.contains("?") ? "&" : "?") + data + substring(url, idx);
  }

  static public String appendQueryToURL(String url, Object... data) {
    return appendQueryToURL(url, paramsToMap(data));
  }

  static public String selectedTabName(JTabbedPane tabs) {
    return tabs == null ? null : swing(() -> getTabTitle(tabs, tabs.getSelectedIndex()));
  }

  static public ThreadLocal<Long> saveTiming_last = new ThreadLocal();

  static public void saveTiming(long ms) {
    print(ms + " ms");
    saveTiming_noPrint(ms);
  }

  static public void saveTiming_noPrint(long ms) {
    saveTiming_last.set(ms);
  }

  static public ThreadLocal<Long> saveTiming_tl() {
    return saveTiming_last;
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public float clamp(float x, float a, float b) {
    return x < a ? a : x > b ? b : x;
  }

  static public double clamp(double x, double a, double b) {
    return x < a ? a : x > b ? b : x;
  }

  static public int clamp(int x, int a, int b) {
    return x < a ? a : x > b ? b : x;
  }

  static public long clamp(long x, long a, long b) {
    return x < a ? a : x > b ? b : x;
  }

  static public void dynamicObject_setRawFieldValue(DynamicObject o, Object key, Object value) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = syncMapPut2_createLinkedHashMap((LinkedHashMap) o.fieldValues, key, value);
    }
  }

  static public List<String> methodNames(Object o) {
    return allMethodNames(o);
  }

  static public List<Integer> countIteratorAsList(int b) {
    return countIteratorAsList(0, b);
  }

  static public List<Integer> countIteratorAsList(int a, int b) {
    return countIteratorToList(a, b);
  }

  static public <A> List<A> countIteratorAsList(int b, IF1<Integer, A> f) {
    return countIteratorAsList(0, b, f);
  }

  static public <A> List<A> countIteratorAsList(int a, int b, IF1<Integer, A> f) {
    return countIteratorToList(a, b, f);
  }

  static public List<Integer> countIteratorAsList(int a, int b, int step) {
    return countIteratorToList(a, b, step);
  }

  static public <A> List<A> countIteratorAsList(double a, double b, double step, IF1<Double, A> f) {
    return countIteratorToList(a, b, step, f);
  }

  static public <A> List<Double> countIteratorAsList(double a, double b, double step) {
    return countIteratorToList(a, b, step);
  }

  static public <A> List<A> countIteratorAsList(IF1<Double, A> f, double a, double b, double step) {
    return countIteratorToList(f, a, b, step);
  }

  static public <A> List<A> countIteratorAsList(IF1<Integer, A> f, int b) {
    return countIteratorAsList(f, 0, b);
  }

  static public <A> List<A> countIteratorAsList(IF1<Integer, A> f, int a, int b) {
    return countIteratorToList(f, a, b);
  }

  static public <A, B extends IF0<A>> List<A> getVars(Iterable<B> l) {
    return lambdaMap(__104 -> getVar(__104), l);
  }

  static public boolean is(String a, String b) {
    return false;
  }

  static public boolean isVisibleWindow(Window w) {
    return w != null && swing(() -> w.isVisible());
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public Object dm_getService(String serviceName) {
    return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateListWithIndex(Iterable<A> l) {
    return iterateListWithIndex(l, 0);
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateListWithIndex(Iterable<A> l, int startAt) {
    return iff(new Object() {

      public Iterator it = iterator(l);

      public int i = startAt;

      public Object get() {
        if (!it.hasNext())
          return endMarker();
        return pair(i++, it.next());
      }
    });
  }

  static public <A> List<A> sortInPlaceByCalculatedField(List<A> l, final F1<A, ?> f) {
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(a), f.get(b));
      }
    });
    return l;
  }

  static public <A> List<A> sortInPlaceByCalculatedField(List<A> l, final IF1<A, ?> f) {
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(a), f.get(b));
      }
    });
    return l;
  }

  static public Dimension componentsBoundingSize(Container container, int insetBottomRight) {
    Rectangle r = new Rectangle(0, 0, 0, 0);
    for (Component c : container.getComponents()) r = rectangleUnion(r, c.getBounds());
    return new Dimension(r.x + r.width + insetBottomRight, r.y + r.height + insetBottomRight);
  }

  static public JTextField standardTextFieldPopupMenu(final JTextField tf) {
    final WeakReference<JTextField> ref = weakRef(tf);
    componentPopupMenuItem(tf, "Copy text to clipboard", new Runnable() {

      public void run() {
        try {
          copyTextToClipboard(ref.get().getText());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "copyTextToClipboard(ref.get().getText())";
      }
    });
    componentPopupMenuItem(tf, "Paste", new Runnable() {

      public void run() {
        try {
          ref.get().paste();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ref.get().paste()";
      }
    });
    return tf;
  }

  static public File imagesDir() {
    return userDir_oneOf_createFirstIfNone("Pictures", "OneDrive/Pictures", "OneDrive/Bilder", "Bilder");
  }

  static public File imagesDir(String sub) {
    return newFile(imagesDir(), sub);
  }

  static public ClassLoader classLoader(Object o) {
    return classLoaderForObject(o);
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      return loadDataSnippetToFile_noResourceLoader(snippetID);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadDataSnippetToFile_noResourceLoader(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ScreenShotMeta shootScreenWithMeta(Rect bounds) {
    var timeRange = new TimestampRange().start(tsNow());
    ScreenShotMeta result = new ScreenShotMeta(timeRange, bounds, shootScreen2(bounds));
    timeRange.end(tsNow());
    result.image = cloneBufferedImageWithMetaSrc(result, result.image);
    return result;
  }

  static public <A> A parentOfType(Component _c, Class<A> theClass) {
    return swing(() -> {
      Component c = _c;
      while (c != null) {
        if (isInstance(theClass, c))
          return (A) c;
        c = c.getParent();
      }
      return null;
    });
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public File renameFile_assertTrue(File a, File b) {
    tr