import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;


// from https://github.com/vzhn/ffmpeg-java-samples/blob/master/src/main/java/WebcamCapture.java

/*lib 1400538
lib 1400539
lib 1400540
lib 1400541
lib 1400542
lib 1400543*/
import org.bytedeco.javacpp.avcodec;
import static org.bytedeco.javacpp.avcodec.av_packet_unref;
import static org.bytedeco.javacpp.avdevice.avdevice_register_all;
import static org.bytedeco.javacpp.avformat.*;
import static org.bytedeco.javacpp.avutil.*;

class main {

 // javacpp ffmpeg examples for linux x64








public static void main(final String[] args) throws Exception { new WebcamCapture().start(); }

static class WebcamCapture {
  public static final int WIDTH = 800;
  public static final int HEIGHT = 600;
  private Canvas canvas;

  private void start() throws IOException {
    JFrame frame = new JFrame();
    frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
    frame.setLayout(new BorderLayout());
    canvas = new Canvas();
    frame.add(canvas, BorderLayout.CENTER);
    frame.setVisible(true);
    frame.setSize(WIDTH, HEIGHT);
    startCapture();
  }

  private void startCapture() throws IOException {
    av_log_set_level(AV_LOG_VERBOSE);
    avdevice_register_all();
    AVInputFormat v4l2 = av_find_input_format("v4l2");
    if (v4l2 == null) {
      throw new RuntimeException("v4l2 not found");
    }
    AVFormatContext v4l2Device = avformat_alloc_context();
    if (v4l2Device == null) {
      throw new RuntimeException("failed to alloc AVFormatContext");
    }

    AVDictionary options = new AVDictionary();
    av_dict_set(options, "input_format", "mjpeg", 0);

    if(avformat_open_input(v4l2Device, "/dev/video0", v4l2, options) != 0) {
      throw new RuntimeException("Couldn't open input stream.\n");
    }
    av_dict_free(options);

    av_dump_format(v4l2Device, 0, "", 0);
    if (v4l2Device.nb_streams() == 0) {
      throw new RuntimeException("Stream not found!");
    }

    avcodec.AVPacket pkt = new avcodec.AVPacket();
    while (true) {
      av_read_frame(v4l2Device, pkt);
      byte[] data = new byte[pkt.size()];
      pkt.data().get(data);
      av_packet_unref(pkt);

      canvas.setImage(ImageIO.read(new ByteArrayInputStream(data)));
    }
  }
}

static class Canvas extends JPanel {
  private BufferedImage bufferedImage;

  @Override
  public void paint(Graphics g) {
    Graphics2D g2d = (Graphics2D) g;
    if (bufferedImage != null) {
      g2d.drawImage(bufferedImage, 0, 0, null);
    }
  }

  public void setImage(BufferedImage bufferedImage) {
    this.bufferedImage = bufferedImage;
    repaint();
  }
}
static <A extends Component> A repaint(A c) {
  if (c != null) c.repaint();
  return c;
}



}

class m1033821{}