//FILENAME: loadableUtils/utils.java
package loadableUtils;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import javax.swing.border.TitledBorder;
import java.text.*;
import javax.swing.border.*;
import javax.swing.Timer;
import java.util.TimeZone;
import java.util.jar.*;
import java.awt.image.DataBufferByte;
import java.awt.geom.*;
import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.nio.file.Path;
import javax.swing.undo.UndoManager;
import java.awt.datatransfer.StringSelection;
import java.nio.charset.Charset;
import java.awt.datatransfer.*;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.text.NumberFormat;
import java.awt.geom.Path2D;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.*;
import static x30_pkg.x30_util.VF1;
import x30_pkg.x30_util.DynamicObject;

public class utils {

  static public class MarkerY {
  }

  static public interface Derefable {

    public Concept get();
  }

  static public File nohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs);
  }

  static public File nohupJavax(String javaxargs, String vmArgs) {
    return directNohupJavax(javaxargs, vmArgs);
  }

  static public interface DynamicMethods {

    abstract public Object _dynCall(String methodName, Object[] args);
  }

  static public class BetterLabel extends JLabel {

    public boolean autoToolTip = true;

    public BetterLabel() {
      final WeakReference<BetterLabel> me = new WeakReference<>(this);
      componentPopupMenu(this, BetterLabel_menuItems(me));
    }

    public BetterLabel(String text) {
      this();
      this.setText(text);
    }

    public void setText(String text) {
      super.setText(text);
      if (autoToolTip)
        if (!swic(text, "<html>"))
          setToolTipText(nullIfEmpty(text));
    }
  }

  static public VF1<JPopupMenu> BetterLabel_menuItems(final WeakReference<BetterLabel> me) {
    return new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboard(me.get().getText());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboard(me.get().getText());";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, \"Copy text to clipboard\", r {\r\n      copyTextToClipboard(me...";
      }
    };
  }

  static public class SingleComponentPanel extends JPanel {

    public SingleComponentPanel() {
      super(new BorderLayout());
    }

    public SingleComponentPanel(Component component) {
      this();
      if (component != null)
        setComponent(component);
    }

    final public void set(Component component) {
      setComponent(component);
    }

    public void setComponent(Component component) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              removeAll();
              if (component != null)
                add(BorderLayout.CENTER, wrap(component));
              _revalidate(SingleComponentPanel.this);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "removeAll();\r\n      if (component != null)\r\n        add(BorderLayout.CENTER, ...";
          }
        });
      }
    }

    public void setComponentAndRevalidateParent(Component component) {
      setComponent(component);
      _revalidate(_getParent(this));
    }

    public void noComponent() {
      setComponent(null);
    }

    public Component getComponent() {
      return getComponentCount() == 0 ? null : getComponent(0);
    }
  }

  static public class Snippet {

    public String id, title, md5, type, text;

    public boolean isPublic = false;

    public Snippet() {
    }

    public Snippet(String id, String title) {
      this.title = title;
      this.id = id;
    }

    public Snippet(String id, String title, String md5) {
      this.md5 = md5;
      this.title = title;
      this.id = id;
    }

    public String toString() {
      return id + " - " + title;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }
  }

  static final public class BWImage implements MakesBufferedImage, IBWImage {

    public int width, height;

    public byte[] pixels;

    public float borderColor = 0.0f;

    public BWImage() {
    }

    public BWImage(int width, int height) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
    }

    public BWImage(int width, int height, float brightness) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
      fillArrayUnlessZero(pixels, _toByte(brightness));
    }

    public BWImage(int width, int height, float[] pixels) {
      this.pixels = new byte[pixels.length];
      this.height = height;
      this.width = width;
      for (int i = 0; i < pixels.length; i++) this.pixels[i] = _toByte(pixels[i]);
    }

    public BWImage(int width, int height, byte[] pixels) {
      this.height = height;
      this.width = width;
      this.pixels = pixels;
    }

    public BWImage(BWImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) pixels[y * width + x] = image.getByte(x, y);
    }

    public BWImage(RGBImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[height * width];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        pixels[y * width + x] = BWImage._toByte(rgb.getBrightness());
      }
    }

    public BWImage(BufferedImage image) {
      try {
        width = image.getWidth();
        height = image.getHeight();
        int[] pixels = new int[width * height];
        byte[] bytePixels = this.pixels = new byte[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        if (!pixelGrabber.grabPixels())
          throw fail("Could not grab pixels");
        int n = width * height;
        for (int i = 0; i < n; i++) {
          int packed = pixels[i];
          int r = ((packed >> 16) & 0xFF);
          int g = ((packed >> 8) & 0xFF);
          int b = (packed & 0xFF);
          bytePixels[i] = (byte) ((r + g + b + 1) / 3);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public byte pixelToByte(int packed) {
      float r = ((packed >> 16) & 0xFF) / 255f;
      float g = ((packed >> 8) & 0xFF) / 255f;
      float b = (packed & 0xFF) / 255f;
      return (byte) ((r + g + b) / 3.0f * 255f);
    }

    public byte getByte(int x, int y) {
      return inRange(x, y) ? getByte_noRangeCheck(x, y) : _toByte(borderColor);
    }

    public int getInt(int x, int y) {
      return ubyteToInt(getByte(x, y));
    }

    public double averageBrightness() {
      double sum = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) sum += getPixel(x, y);
      return (sum / (double) (height * width));
    }

    public float minimumBrightness() {
      float min = 1;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) min = Math.min(min, getPixel(x, y));
      return min;
    }

    public float maximumBrightness() {
      float max = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) max = Math.max(max, getPixel(x, y));
      return max;
    }

    public float getPixel(int x, int y) {
      return inRange(x, y) ? _toFloat(getByte(x, y)) : borderColor;
    }

    public float getFloatPixel(int x, int y) {
      return getPixel(x, y);
    }

    public float getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    static public byte _toByte(float pixel) {
      return (byte) (pixel * 255f);
    }

    static public float _toFloat(byte pixel) {
      return (((int) pixel) & 255) / 255f;
    }

    final public boolean inRange(int x, int y) {
      return x >= 0 && x < width && y >= 0 && y < height;
    }

    public int getWidth() {
      return width;
    }

    public int w() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int h() {
      return height;
    }

    public RGBImage toRGB() {
      int[] rgbs = new int[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = getByte(x, y) & 0xFF;
        rgbs[y * width + x] = 0xFF000000 | b * 0x010101;
      }
      return new RGBImage(width, height, rgbs);
    }

    public RGBImage toRGB_slow() {
      RGB[] rgbs = new RGB[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y * width + x] = new RGB(p, p, p);
      }
      return new RGBImage(width, height, rgbs);
    }

    public BWImage clip(int x, int y, int w, int h) {
      return clip(new Rectangle(x, y, w, h));
    }

    final public Rectangle fixClipRect(Rectangle r) {
      return r.intersection(new Rectangle(0, 0, width, height));
    }

    public BWImage clip(Rect r) {
      return clip(r.getRectangle());
    }

    public BWImage clip(Rectangle r) {
      r = fixClipRect(r);
      byte[] newPixels = new byte[r.height * r.width];
      for (int y = 0; y < r.height; y++) for (int x = 0; x < r.width; x++) newPixels[y * r.width + x] = getByte(r.x + x, r.y + y);
      return new BWImage(r.width, r.height, newPixels);
    }

    public void setPixel(int x, int y, float brightness) {
      setByte(x, y, _toByte(fixPixel(brightness)));
    }

    public void setInt(int x, int y, int i) {
      setByte(x, y, (byte) limitToUByte(i));
    }

    public void setByte(int x, int y, byte b) {
      if (x >= 0 && x < width && y >= 0 && y < height)
        pixels[y * width + x] = b;
    }

    public byte getByte_noRangeCheck(int x, int y) {
      return pixels[y * width + x];
    }

    public void setByte(int x, int y, int brightness) {
      setByte(x, y, (byte) brightness);
    }

    final public float fixPixel(float pixel) {
      return Math.max(0, Math.min(1, pixel));
    }

    public float getBorderColor() {
      return borderColor;
    }

    public void setBorderColor(float borderColor) {
      this.borderColor = borderColor;
    }

    public boolean anyPixelBrighterThan(double threshold) {
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) if (getPixel(x, y) > threshold)
        return true;
      return false;
    }

    public BufferedImage getBufferedImage() {
      BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = ((int) getByte(x, y) & 0xFF);
        bufferedImage.setRGB(x, y, b * 0x010101);
      }
      return bufferedImage;
    }

    public byte[] getBytes() {
      return pixels;
    }
  }

  static public class Cache<A> {

    public Object maker;

    public A value;

    public long loaded;

    static public boolean debug = false;

    public long changeCount;

    public Lock lock = lock();

    public Cache() {
    }

    public Cache(Object maker) {
      this.maker = maker;
    }

    public Cache(IF0<A> maker) {
      this.maker = maker;
    }

    public A get() {
      if (hasLock(lock))
        return value;
      Lock __14 = lock;
      lock(__14);
      try {
        if (loaded == 0) {
          value = make();
          changeCount++;
          loaded = sysNow();
        }
        return value;
      } finally {
        unlock(__14);
      }
    }

    public void clear() {
      Lock __15 = lock;
      lock(__15);
      try {
        if (debug && loaded != 0)
          print("Clearing cache");
        value = null;
        changeCount++;
        loaded = 0;
      } finally {
        unlock(__15);
      }
    }

    public void clear(double seconds) {
      Lock __16 = lock;
      lock(__16);
      try {
        if (seconds != 0 && loaded != 0 && sysNow() >= loaded + seconds * 1000)
          clear();
      } finally {
        unlock(__16);
      }
    }

    public void set(A a) {
      Lock __17 = lock;
      lock(__17);
      try {
        value = a;
        ++changeCount;
        loaded = sysNow();
      } finally {
        unlock(__17);
      }
    }

    public A make() {
      return (A) callF(maker);
    }
  }

  static abstract public class DynModule extends DynamicObject {

    public String name, toolTip;

    public PersistableThrowable _error;

    public Map<String, Collection<String>> mechLists;

    public Map<String, Boolean> _persistenceInfo;

    transient public Object _host;

    transient public Map<Object, IVF1> timers = newWeakHashMap();

    transient public Set<AutoCloseable> _resources = synchroHashSet();

    transient public Lock lock;

    transient public boolean persistOnChangedField = true;

    transient public int changeCount;

    transient public Object changeCountSync = new Object();

    transient public List onChange;

    transient public List onTransientChange;

    transient public boolean verboseTimers = false;

    transient public ReliableSingleThread rstUpdate;

    transient public Set<String> componentFieldsToKeep;

    transient public Map<String, Object> transientGeneralMap = synchroHashMap();

    transient public Q q;

    transient public List onFieldChange;

    transient public boolean _hasPreviousBounds = false;

    transient public StringBuffer _printLog = new StringBuffer();

    transient public boolean deleted = false;

    public DynModule() {
      if (useErrorHandling())
        dm_initErrorHandling();
      setMainDesktopPane((JDesktopPane) getCreatorOpt("desktop"));
    }

    public boolean useErrorHandling() {
      return true;
    }

    public boolean isVisible() {
      return isTrue(getOpt(_host, "visible"));
    }

    public String moduleName() {
      return name;
    }

    public void setModuleName(String name) {
      String oldName = this.name;
      if (!eq(name, oldName)) {
        setField("name", name);
        possiblyInternalFrameTitle(vis(), name);
        vmBus_send("moduleNameChange", this, oldName, name);
      }
    }

    public void setModuleToolTip(String toolTip) {
      this.toolTip = toolTip;
    }

    public JComponent vis() {
      return (JComponent) getOpt(_host, "vis");
    }

    public <A extends AutoCloseable> A ownResource(A a) {
      if (a != null)
        _resources.add(a);
      return a;
    }

    public <A> A ownTimer(A timer) {
      if (timer instanceof AutoCloseable)
        ownResource((AutoCloseable) timer);
      else
        ownTimer(timer, __29 -> cancelTimerOrInterruptThread(__29));
      return timer;
    }

    public void ownTimer(Object timer, IVF1 closerHelper) {
      timers.put(timer, closerHelper);
    }

    public void singleTimer(java.util.Timer timer) {
      stopAllTimers();
      ownTimer(timer);
    }

    public void stopAllTimers() {
      for (AutoCloseable resource : getAndClearList(_resources)) {
        if (verboseTimers)
          print("Releasing resource: " + resource);
        try {
          resource.close();
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
      for (Map.Entry<? extends Object, ? extends IVF1> __20 : _entrySet(getAndClearMap(timers))) {
        Object timer = __20.getKey();
        IVF1 closerHelper = __20.getValue();
        if (verboseTimers)
          print("Stopping timer: " + closerHelper + " / " + timer);
        pcallF(closerHelper, timer);
      }
    }

    public boolean isDeleted() {
      return deleted;
    }

    public boolean deleted() {
      return deleted;
    }

    public void cleanMeUp_dynModule() {
      deleted = true;
      stopAllTimers();
    }

    public void persistMe() {
      synchronized (changeCountSync) {
        ++changeCount;
      }
      pcallFAll(onChange);
      callOpt(_host, "_change");
      updateMe();
    }

    public void fireChangeWithoutPersisting() {
      pcallFAll(onChange);
    }

    public void fireTransientChange() {
      pcallFAll(onTransientChange);
    }

    public void _change() {
      persistMe();
    }

    public void change() {
      persistMe();
    }

    public void updateMe() {
      rstUpdate().trigger();
    }

    public void changeAndUpdate() {
      _change();
      updateMe();
    }

    public boolean setField_noPersist(String name, Object value) {
      return setField(name, value, true);
    }

    public boolean _setField(String name, Object value) {
      return setField(name, value);
    }

    public boolean setField(String name, Object value) {
      return setField(name, value, false);
    }

    public boolean setField(String name, Object value, boolean noPersist) {
      AutoCloseable __25 = enter();
      try {
        try {
          if (eq(get(this, name), value))
            return false;
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
        return setField_noCheck(name, value, noPersist);
      } finally {
        _close(__25);
      }
    }

    public boolean setField_noCheck(String name, Object value) {
      return setField_noCheck(name, value, false);
    }

    public boolean setField_noCheck(String name, Object value, boolean noPersist) {
      AutoCloseable __26 = enter();
      try {
        setOpt(this, name, value);
        pcallFAll(onFieldChange, name);
        if (!noPersist && persistOnChangedField && !isFalse(mapGet(_persistenceInfo, name)))
          _change();
        return true;
      } finally {
        _close(__26);
      }
    }

    public <A> A setFieldAndReturn(String name, A value) {
      setField(name, value);
      return value;
    }

    public boolean setFields(Object... params) {
      boolean change = false;
      for (int i = 0; i < l(params); i += 2) if (setField((String) params[i], params[i + 1]))
        change = true;
      return change;
    }

    public void start() {
      _hasPreviousBounds = dm_getBounds() != null;
      if (hasMethod_onTypes(this, "onTopInput", String.class))
        dm_onTopInput_q(new VF1<String>() {

          public void get(String s) {
            try {
              call(module(), "onTopInput", s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "call(module(), 'onTopInput, s)";
          }
        });
    }

    public void revisualize() {
      call(creator(), "revisualizeModule", _host);
    }

    public boolean useEnterShortcut() {
      return false;
    }

    public AutoCloseable enter() {
      AutoCloseable c = tempSetBetterThreadLocalIfNecessary_weakRef(dm_current_generic_tl(), this);
      if (c == null && useEnterShortcut())
        return null;
      Object realMC = getMainClass(this);
      if (printToModule())
        c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(_printToModuleInterceptor()));
      if (realMC != mc()) {
        if (printToModule())
          c = combineAutoCloseables(c, (AutoCloseable) callOpt(realMC, "tempInterceptPrintIfNotIntercepted", _printToModuleInterceptor()));
        else
          c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(new F1<String, Boolean>() {

            public Boolean get(String s) {
              try {
                {
                  call(realMC, "print", s);
                  return false;
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ret false with call(realMC, 'print, s);";
            }
          }));
        c = combineAutoCloseables(c, tempSetTL(realMC_tl(), realMC));
      }
      return c;
    }

    public F1<String, Boolean> _printToModuleInterceptor() {
      return new F1<String, Boolean>() {

        public Boolean get(String s) {
          try {
            if (print_preprocess != null)
              s = (String) callF(print_preprocess, s);
            s = fixNewLines(s);
            Appendable loc = _printLog;
            Appendable buf = print_log;
            int loc_max = print_log_max;
            if (buf != loc && buf != null) {
              print_append(buf, s, print_log_max);
              loc_max = local_log_max;
            }
            if (loc != null)
              print_append(loc, s, loc_max);
            if (printAlsoToSystemOut)
              System.out.print(s);
            return false;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (print_preprocess != null) s = (S) callF(print_preprocess, s);\r\n      s = ...";
        }
      };
    }

    public boolean printToModule() {
      return true;
    }

    public AutoCloseable enterAndLock() {
      return combineAutoCloseables(enter(), tempLock(lock));
    }

    public boolean setError(Throwable e) {
      setField("_error", persistableThrowable(e));
      return true;
    }

    public void clearError() {
      setField("_error", null);
    }

    public void onChange(Runnable r) {
      Lock __21 = lock;
      lock(__21);
      try {
        if (onChange == null)
          onChange = synchroList();
        addIfNotThere(onChange, r);
      } finally {
        unlock(__21);
      }
    }

    public void onFieldChange(VF1<String> r) {
      Lock __22 = lock;
      lock(__22);
      try {
        if (onFieldChange == null)
          onFieldChange = synchroList();
        addIfNotThere(onFieldChange, r);
      } finally {
        unlock(__22);
      }
    }

    public void onChangeAndNow(Runnable r) {
      onChange(r);
      callF(r);
    }

    public void onChangeAndNow(JComponent c, Object r) {
      onUpdateAndNow(c, r);
    }

    public <A extends JComponent> A onChange(A tc, Object r) {
      onUpdate(tc, r);
      return tc;
    }

    public void update() {
    }

    public void unvisualize() {
      zeroAllFieldsOfTypeExcept(this, Component.class, componentFieldsToKeep);
    }

    public Object menuItems() {
      return null;
    }

    public void enhanceFrame(Container f) {
      Object items = menuItems();
      if (items instanceof Object[])
        items = paramsToAbstractActions((Object[]) items);
      internalFramePopupMenuFromActions_threaded(f, (List) items);
      String switchableFields = (String) (callOpt(this, "switchableFields"));
      Set<String> set = asLinkedHashSet(splitAtSpace(switchableFields));
      Matches m = new Matches();
      for (String field : allFields(getClass())) if (startsWith(field, "_switchableField_", m))
        set.add(m.rest());
      for (String field : set) {
        Class type = fieldType(this, field);
        if (eq(boolean.class, type))
          dm_boolFieldMenuItem(f, field);
        else if (eq(int.class, type))
          dm_intFieldMenuItem(f, field);
        else if (eq(long.class, type))
          dm_longFieldMenuItem(f, field);
        else if (eq(double.class, type))
          dm_doubleFieldMenuItem(f, field);
        else if (eq(float.class, type))
          dm_floatFieldMenuItem(f, field);
        else if (eq(String.class, type))
          dm_stringFieldMenuItem(f, field);
        else if (eq(File.class, type))
          dm_fileFieldMenuItem(f, field);
      }
    }

    public ReliableSingleThread rstUpdate() {
      if (rstUpdate == null)
        rstUpdate = dm_rst(this, new Runnable() {

          public void run() {
            try {
              AutoCloseable __27 = enter();
              try {
                update();
              } finally {
                _close(__27);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "temp enter(); update();";
          }
        });
      return rstUpdate;
    }

    public Q q() {
      AutoCloseable __28 = enter();
      try {
        if (q == null) {
          Lock __23 = lock;
          lock(__23);
          try {
            if (q == null)
              q = dm_startQ();
          } finally {
            unlock(__23);
          }
        }
        return q;
      } finally {
        _close(__28);
      }
    }

    public <A> A withUpdate(A a) {
      rstUpdate().trigger();
      return a;
    }

    public DynModule module() {
      return this;
    }

    public DynModule me() {
      return this;
    }

    public JComponent visualize() {
      return dm_noVisualisation();
    }

    public String programTitle_cache;

    public String programTitle() {
      if (programTitle_cache == null)
        programTitle_cache = snippetTitle(programID(mainClass(this)));
      return programTitle_cache;
    }

    public void doPersist(String field) {
      _persistenceInfo = mapMinus(_persistenceInfo, field);
    }

    public void dontPersist(String field) {
      _persistenceInfo = mapPlus(_persistenceInfo, "field", false);
    }

    public Appendable _actualPrintLog() {
      return printToModule() ? _printLog : print_log;
    }

    public <A> boolean addAndChange(Collection<A> cl, A a) {
      if (cl == null || !cl.add(a))
        return false;
      change();
      return true;
    }

    public <A> void clearAndChange(Collection<A> cl) {
      if (cl == null)
        return;
      cl.clear();
      change();
    }
  }

  static public void _registerTimer(java.util.Timer timer) {
    _registerTimer_original(timer);
    var mod = dm_currentModule();
    {
      if (mod != null)
        mod.ownTimer(timer);
    }
  }

  abstract static public class DynPrintLog extends DynModule {

    transient public JFastLogView_noWrap printLogView;

    transient public Lock updatePrintLog_lock = lock();

    transient public StringBuffer actualPrintLog;

    transient public int printLogUpdateInterval = 500;

    transient public JComponent printLogPanel;

    public JComponent visualize() {
      return makePrintLogPanel();
    }

    public JComponent makePrintLogPanel() {
      JComponent section = printLogPanel = jSection("Log", jscroll_copyBackground(printLogView = jFastLogView_noWrap(getPrintLog())));
      componentPopupMenuItem(section, "Clear", new Runnable() {

        public void run() {
          try {
            AutoCloseable __36 = enter();
            try {
              dm_clearModulePrintLog();
            } finally {
              _close(__36);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();  dm_clearModulePrintLog();";
        }
      });
      return awtEvery(section, printLogUpdateInterval, new Runnable() {

        public void run() {
          try {
            updatePrintLog();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "updatePrintLog();";
        }
      });
    }

    public void updatePrintLog() {
      swing(new Runnable() {

        public void run() {
          try {
            Lock __33 = updatePrintLog_lock;
            lock(__33);
            try {
              JFastLogView_noWrap _view = printLogView;
              if (_view == null)
                return;
              if (_view.setText(getPrintLog())) {
                scrollAllTheWayDown(_view);
                awtLater(100, new Runnable() {

                  public void run() {
                    try {
                      scrollAllTheWayDown(_view);
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "scrollAllTheWayDown(_view)";
                  }
                });
              }
            } finally {
              unlock(__33);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// TODO: optimize\r\n    Lock __33 = updatePrintLog_lock; lock(__33); try {\r\n  ...";
        }
      });
    }

    public JFastLogView_noWrap myPrintLogComponent() {
      return printLogView;
    }

    public void enableWordWrap() {
    }

    public String getPrintLog() {
      if (actualPrintLog == null) {
        if (printToModule())
          actualPrintLog = _printLog;
        else
          actualPrintLog = liveLocalPrintLog_realMC(this);
      }
      return str(actualPrintLog);
    }
  }

  abstract static public class DynObjectTable<A> extends DynModule {

    public List<A> data = new ArrayList();

    transient public JTable table;

    transient public F1<A, Map> itemToMap;

    transient public VF1<A> defaultAction;

    transient public boolean debug, fieldsInOrder = true, withSearcher;

    transient public TableSearcher searcher;

    transient public List onListChanged;

    transient public Set<String> hideFields;

    transient public boolean useStruct = false;

    public void start() {
      try {
        super.start();
        itemToMap = new F1<A, Map>() {

          public Map get(A a) {
            try {
              if (a instanceof String)
                return litorderedmap("", (String) a);
              Map map = humanizeKeys(fieldsInOrder ? objectToMap_inOrder_withoutFields(a, hideFields) : objectToMap(a));
              if (!useStruct)
                map = mapValues(__76 -> strOrEmpty(__76), map);
              return map;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (a instanceof S) ret litorderedmap(\"\" := (S) a);\r\n      Map map = humanize...";
          }
        };
        onChange(new Runnable() {

          public void run() {
            try {
              updateTable();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "updateTable();";
          }
        });
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void onListChanged(Runnable r) {
      if (r == null)
        return;
      onListChanged = addDyn_sync(onListChanged, r);
    }

    public void onListChangedAndNow(Runnable r) {
      if (r == null)
        return;
      onListChanged(r);
      r.run();
    }

    public void addCountToName() {
      onListChangedAndNow(new Runnable() {

        public void run() {
          try {
            addCountToNameNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "addCountToNameNow();";
        }
      });
    }

    public void addCountToNameNow() {
      AutoCloseable __40 = enter();
      try {
        setModuleName(programTitle() + " (" + count() + ")");
      } finally {
        _close(__40);
      }
    }

    public JComponent visualize() {
      List<Map> l = map(itemToMap, data);
      table = dataToTable_uneditable(sexyTable(), l);
      onDoubleClickOrEnter(table, new VF1<Integer>() {

        public void get(Integer row) {
          try {
            AutoCloseable __41 = enter();
            try {
              A a = _get(data, row);
              if (a != null)
                onDoubleClick(a);
            } finally {
              _close(__41);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();\r\n      A a = _get(data, row);\r\n      if (a != null) onDoubleCli...";
        }
      });
      if (withSearcher)
        return (searcher = tableWithSearcher2(table)).panel;
      return table;
    }

    public void unvisualize() {
      super.unvisualize();
      searcher = null;
    }

    public void onDoubleClick(A line) {
      callF(defaultAction, line);
    }

    public void updateTable() {
      AutoCloseable __42 = enter();
      try {
        if (table != null) {
          swing(new Runnable() {

            public void run() {
              try {
                Point scrollPosition = enclosingViewPosition(table);
                if (debug)
                  print("Scroll position: " + scrollPosition);
                dataToTable_uneditable(table, map(itemToMap, data));
                setEnclosingViewPosition(table, scrollPosition);
                if (searcher != null)
                  searcher.rowIndices = null;
                if (debug)
                  print("dataToTable done, alerting " + n2(onListChanged, "listener"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "Point scrollPosition = enclosingViewPosition(table);\r\n      if (debug) print(...";
            }
          });
        }
        pcallFAll(onListChanged);
      } finally {
        _close(__42);
      }
    }

    public void dontPersist() {
      _persistenceInfo = mapPlus(_persistenceInfo, "data", false);
    }

    public void clear() {
      syncClear(data);
      fireDataChanged();
    }

    public void add(A a) {
      syncAdd(data, a);
      fireDataChanged();
    }

    public A addAndReturn(A a) {
      add(a);
      return a;
    }

    public void add(int idx, A a) {
      syncAdd(data, idx, a);
      fireDataChanged();
    }

    public void addAll(Collection<A> l) {
      if (empty(l))
        return;
      syncAddAll(data, l);
      fireDataChanged();
    }

    public void addAndScrollDown(A a) {
      add(a);
      scrollDown();
    }

    public void remove(A a) {
      syncRemove(data, a);
      fireDataChanged();
    }

    public void removeAll(List<A> a) {
      syncRemoveAll(data, a);
      fireDataChanged();
    }

    public void setList(Iterable<A> data) {
      setData(data);
    }

    public void removeSelected() {
      removeAll(allSelected());
    }

    public void setData(Collection<A> data) {
      setData((Iterable) data);
    }

    public void setData(Iterable<A> data) {
      setData(data, false);
    }

    public void setData(Iterable<A> data, boolean force) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              int[] selection = selectedTableRows_array(table);
              List<A> cloned = cloneList(data);
              if (setField("data", cloned) || force) {
                updateTable();
                dm_vmBus_send("listChanged", module(), cloned);
              }
              if (force)
                change();
              selectTableRows(table, selection);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "//int selection = selectedIndex();\r\n      int[] selection = selectedTableRows...";
          }
        });
      }
    }

    public int count() {
      return syncL(data);
    }

    public void setData_force(Collection<A> data) {
      setData(data, true);
    }

    public void fireDataChanged() {
      setData_force(data);
    }

    public int rowFromSearcher(int i) {
      return searcher == null || searcher.rowIndices == null ? i : or(get(searcher.rowIndices, i), -1);
    }

    public A selected() {
      return syncGet(data, rowFromSearcher(selectedTableRowInModel(table)));
    }

    public List<A> allSelected() {
      return syncListGetMulti(data, selectedIndices());
    }

    public int selectedIndex() {
      return selectedTableRow(table);
    }

    public List<Integer> selectedIndices() {
      return map(i -> rowFromSearcher(i), selectedTableRowsInModel(table));
    }

    public boolean selectItem(A a) {
      int i = indexOf(data, a);
      selectRow(table, i);
      return i >= 0;
    }

    public void doubleClickItem(A a) {
      if (selectItem(a))
        onDoubleClick(a);
    }

    public void popupMenuItem(String text, Object r) {
      tablePopupMenuItemsThreaded(table, text, _convertRunnable(r));
    }

    public void popupMenuItem_top(String text, Object r) {
      tablePopupMenuItemsThreaded_top(table, text, _convertRunnable(r));
    }

    public Object _convertRunnable(final Object r) {
      if (r == null || r instanceof Runnable)
        return r;
      return new VF1<Integer>() {

        public void get(Integer idx) {
          try {
            callF(r, syncGet(data, idx));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r, syncGet(data, idx))";
        }
      };
    }

    public JTable table() {
      return table;
    }

    public void hideFields(String... fields) {
      if (hideFields == null)
        hideFields = new HashSet();
      _addAll(hideFields, fields);
    }

    public A getRow(int row) {
      return get(data, row);
    }

    public void scrollDown() {
      scrollTableDownNow(table);
    }

    public List<A> getData() {
      return data;
    }

    public List<A> data() {
      return getData();
    }

    public List<A> list() {
      return getData();
    }

    public List<A> getList() {
      return getData();
    }

    public List<A> clonedList() {
      return cloneList(data);
    }

    public File quickBackup() {
      File f = programFile("backup-" + ymd_minus_hms_minus_millis() + ".gz");
      saveGZStructToFile(f, module());
      printFileInfo(f);
      return f;
    }
  }

  abstract static public class DynImageSurface extends DynModule {

    transient public ImageSurface imageSurface;

    transient public BufferedImage image;

    transient public String imageID;

    transient public boolean useUpdateHack, zoomToWindowOnSetImage;

    transient public Object onNewImage;

    static public boolean _switchableField_autoSaveToDisk = true;

    public boolean autoSaveToDisk = autoSaveToDiskDefault();

    static public boolean _switchableField_pixelate = true;

    public boolean pixelate = false;

    public JComponent visualize() {
      return _visualize();
    }

    final public JComponent _visualize() {
      imageSurface = imageSurface(image);
      imageSurface.onNewImage = new Runnable() {

        public void run() {
          try {
            newImageFromSurface();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "newImageFromSurface();";
        }
      };
      if (pixelate)
        imageSurface_pixelated(imageSurface);
      return jscroll_center(imageSurface);
    }

    public void enableDoubleBuffering() {
      if (imageSurface != null)
        imageSurface.setDoubleBuffered(true);
    }

    public JComponent visualizeWithDoubleBuffering() {
      JComponent c = _visualize();
      enableDoubleBuffering();
      return c;
    }

    public Object _getReloadData() {
      return image;
    }

    public void _setReloadData(BufferedImage image) {
      this.image = image;
    }

    public void start() {
      try {
        super.start();
        if (autoSaveToDisk)
          autoLoadNow();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void autoLoadNow() {
      AutoCloseable __47 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          if (fileExists(f)) {
            print("Auto-loading " + f);
            setImage(loadImage2(f), true);
          }
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      } finally {
        _close(__47);
      }
    }

    public void autoSaveNow() {
      AutoCloseable __48 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          savePNG(f, image);
          infoBox("Auto-saved " + renderFileInfo(f));
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      } finally {
        _close(__48);
      }
    }

    public boolean autoSaveToDiskDefault() {
      return false;
    }

    public void enhanceFrame(Container f) {
      super.enhanceFrame(f);
      internalFramePopupMenuItem(f, "Auto-save now", runnableThread(new Runnable() {

        public void run() {
          try {
            autoSaveNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "autoSaveNow();";
        }
      }));
    }

    public void setImage(MakesBufferedImage image) {
      imageID = null;
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void newImageFromSurface() {
      setImage(imageSurface.getImage());
    }

    public void setImage(BufferedImage image) {
      setImage(image, false);
    }

    public void setImage(BufferedImage image, boolean loadingFromAutoSave) {
      this.image = image;
      imageID = null;
      if (imageSurface != null) {
        AutoCloseable __49 = tempSetField(imageSurface, "onNewImage", null);
        try {
          imageSurface.setImage(image);
          if (zoomToWindowOnSetImage)
            imageSurface.zoomToWindow();
          if (autoSaveToDisk && !loadingFromAutoSave)
            autoSaveNow();
        } finally {
          _close(__49);
        }
      }
      vmBus_send("newImage", this);
      pcallF(onNewImage, image);
    }

    public void setImage(String imageID) {
      if (sameSnippetID(this.imageID, imageID))
        return;
      setImage(loadImage2(imageID));
      this.imageID = imageID;
    }

    public File autoSaveImageFile() {
      String id = dm_moduleID(me());
      return javaxDataDir("Image Autosaves/" + id + "-autosave.png");
    }

    public BufferedImage getImage() {
      if (useUpdateHack) {
        ImageSurface is = imageSurface;
        if (is != null && is.getImage() != image)
          setImage(is.getImage());
      }
      return image;
    }

    public boolean hasImage() {
      return image != null;
    }

    public void setZoom(double zoom) {
      if (imageSurface != null)
        imageSurface.setZoom(zoom);
    }

    public Rect getSelection() {
      return imageSurface == null ? null : toRect(imageSurface.getSelection());
    }

    public void setSelection(Rect r) {
      if (imageSurface != null)
        imageSurface.setSelection(toRectangle(r));
    }

    public int imageWidth() {
      return imageSurface.getImage().getWidth();
    }

    public int imageHeight() {
      return imageSurface.getImage().getHeight();
    }

    public void pixelate() {
      setField("pixelate", true);
      imageSurface_pixelated(imageSurface);
    }
  }

  abstract static public class DynCalculatedList extends DynModule {

    transient public JList list;

    transient public List<String> results;

    transient public boolean calculateWhenHidden = false;

    public JComponent visualize() {
      return list = jlist(calc());
    }

    public void unvisualize() {
      list = null;
    }

    public void update() {
      AutoCloseable __54 = enter();
      try {
        if (list != null || calculateWhenHidden)
          fillListWithStrings(list, results = calc());
      } finally {
        _close(__54);
      }
    }

    abstract public List<String> calc();

    public void scrollDown() {
      scrollAllTheWayDown(list);
    }

    public String selected() {
      return selectedItem(list);
    }
  }

  static public Object creator() {
    return callOpt(assertNotNull("No real MC", realMC_tl()).get(), "creator");
  }

  static public String programID;

  static public String getProgramID() {
    Object mc = realMC_tl().get();
    if (mc != null)
      return getProgramID(mc);
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public Concepts db_mainConcepts() {
    return (Concepts) call(assertNotNull("No real MC", realMC()), "db_mainConcepts");
  }

  static public List<String> myInnerClasses_list = litlist(null, "MarkerY", "Meta", "Derefable", "DefunctClassLoader", "ImageSurface", "BWImage", "talkToThisVM_IO", "PingSource", "IFieldIndex", "Str", "SimpleLiveValue", "SingleComponentPanel", "Best", "DynModule", "Rect", "Pt", "AbstractLayoutManager", "LeftAlignedLine", "IterableIterator", "betterCIComparator_C", "RemoteDB", "MakesBufferedImage", "SynchronizedArrayList", "IProbabilisticScheduler", "Concepts", "RC", "IBWIntegralImage", "Hasher", "CloseableIterableIterator", "PNGFile", "getOpt_Map", "IFieldsToList", "structure_Data", "IVar", "DynPrintLogAndEnabled", "Matches", "WithTimestamp", "HCRUD_Concepts", "TableWithTooltips", "LiteralJavaXExpr", "DynCalculatedList", "Dyn_FieldWatcher", "Timestamp", "DoubleRect", "Surface", "Q", "ConceptFieldIndexBase", "OrError", "LongRange", "JECompressionSearch", "RestartableCountdown", "MultiSet", "T3", "IResourceHolder", "EvalJavaPrep", "Htmlable", "DynObjectTable", "mapI_if1_It", "HCRUD_Data", "Average", "IntRange", "IConceptCounter", "UnsynchronizedCompactHashSet", "BetterLabel", "componentPopupMenu_Adapter", "BWIntegralImage", "JavaXClassLoaderWithParent2", "CompressionRegime_AnyType", "RGBImage", "SmartTimerTask", "JSection", "ValueConverterForField", "FullChange", "JECompressionRegime", "WithSideValue", "IntegerIterator", "ConceptDelete", "MultiSleeper", "WindowDragger", "ReliableSingleThread", "WindowResizeDragger", "IBWImage", "AutoComboBox", "ProgramScan", "ConceptFieldIndex", "GrabbableGrayPixels", "IHasBackRefs", "F0", "Snippet", "F1", "DynImageSurface", "F2", "RandomAccessAbstractList", "RGB", "F3", "unstructure_Receiver", "IF0", "BaseXRef", "DefaultValueConverterForField", "IF2", "IF1", "IVF3", "tablePopupMenu_Maker", "IVF1", "IVF2", "IWithSideValue", "Cache", "_MethodCache", "PingSourceCancelledException", "structure_ClassInfo", "TreeSetWithDuplicates", "ISetAndGet", "ToJava", "LiveValue", "QuickException", "DialogHandler", "Steppable", "proxy_InvocationHandler", "Pair", "Swingable", "JavaXClassLoader", "Probabilistic", "UniqueString", "IIVirtualClip", "GrabbableIntPixels", "TransferableImage", "Sleeping", "IConceptIndex", "ReverseChain", "ConceptCreate", "Seconds", "WithProbability", "MultiSetMap", "Var", "ITokCondition", "SubList", "SecretValue", "CountingOutputStream", "Matrix", "HTMLAceEditor", "AppendableChain", "PrecisePolygon", "ConceptChange", "CompactLinkedHashSet", "FixedRateTimer", "Fail", "GridCodec1", "ISetter", "SubMatrix", "ScannedBot", "XRef", "IntBuffer", "DoublePt", "NotifyingStringBuffer", "AbstractMatrix", "Chain", "ThreadPool", "IProbabilistic", "JS", "AbstractJavaXExpr", "Complex", "MultiMap", "ProbabilisticScheduler", "CriticalAction", "JavaCodec", "IResourceLoader", "WeakHasherMap", "Either", "Ratio", "FunctionCall", "IIntegralImage", "CompilerBot", "AbstractCompressor_AnyType", "JMenuScroller", "DialogIO", "SimpleCRUD", "SynchronizedArrayList_Base", "IAutoCloseableF0", "MRUCache", "ISleeper_v2", "AlphanumComparator", "PersistableThrowable", "talkToSubBot_IO", "Scored", "WidthAndHeight", "ISubList", "HasIndex", "Responder", "VF2", "TableSearcher", "IMultiSet", "JE_RepElement", "ConceptsChange", "ICachedJavaXExpr", "TokCondition", "HTML", "RightAlignedLine", "GlobalID", "HCRUD", "findCodeTokens_Matcher", "listPopupMenu_Maker", "JFastLogView_noWrap", "ImageSurfaceSelector", "JEInstantCompressor_AnyType", "Concept", "IRef", "RegisteredReference", "HAbstractRenderable", "TreeMultiMap", "NotifyingStringBufferRotator", "Flag", "ContentsIndexedList", "FileTransferable", "IContentsIndexedList2", "Producer", "tempRememberListener_c", "talkTo_IO", "OKOrError", "FileBasedLock", "Symbol", "IMeta", "ListToMatrix", "BetterThread", "IContentsIndexedList", "LetterLayout", "BetterThreadLocal", "Lowest", "CompressionSearch_AnyType", "HTMLPaginator", "DynPrintLog", "MinimalChain", "JavaXClassLoaderWithParent", "Transformable", "jLiveValueSection_class", "JE_CompressEachElementIndividually", "DoubleRange", "Android3", "DynamicMethods");

  static public List<String> myInnerClasses() {
    return myInnerClasses_list;
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(Object... objects) {
    throw new Fail(objects);
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first((Collection) strings));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(String glue, Object... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !regionMatches(s, j, "*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j < l && !regionMatches(s, j, "]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !regionMatches(s, j, "]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public boolean get(BitSet bs, int idx) {
    return bs != null && bs.get(idx);
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public void set(BitSet bs, int idx) {
    {
      if (bs != null)
        bs.set(idx);
    }
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject) {
        setDyn(((DynamicObject) o), field, value);
        return;
      }
      if (o instanceof IMeta)
        setDyn(((IMeta) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(A a, IVF1<A> f) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(IVF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF(Object f, Object... args) {
    return safeCallF(f, args);
  }

  static public Object safeCallF(Object f, Object... args) {
    if (f instanceof Runnable) {
      ((Runnable) f).run();
      return null;
    }
    if (f == null)
      return null;
    Class c = f.getClass();
    ArrayList<Method> methods;
    synchronized (callF_cache) {
      methods = callF_cache.get(c);
      if (methods == null)
        methods = callF_makeCache(c);
    }
    int n = l(methods);
    if (n == 0) {
      throw fail("No get method in " + getClassName(c));
    }
    if (n == 1)
      return invokeMethod(methods.get(0), f, args);
    for (int i = 0; i < n; i++) {
      Method m = methods.get(i);
      if (call_checkArgs(m, args, false))
        return invokeMethod(m, f, args);
    }
    throw fail("No matching get method in " + getClassName(c));
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public Object callOpt(Object o, String method, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public Map<String, UniqueString> uniqueString_map = weakHashMap();

  static public UniqueString uniqueString(String s) {
    if (s == null)
      return null;
    synchronized (uniqueString_map) {
      UniqueString us = uniqueString_map.get(s);
      if (us == null)
        uniqueString_map.put(s, us = new UniqueString(s, true));
      return us;
    }
  }

  static public UniqueString uniqueString(CharSequence s) {
    return s == null ? null : uniqueString(str(s));
  }

  static public FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  static public FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return vmBus_timerStarted(timer);
  }

  static public FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  static public FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JLabel jlabel(final String text) {
    return swingConstruct(BetterLabel.class, text);
  }

  static public JLabel jlabel() {
    return jlabel(" ");
  }

  static public JTextArea newTypeWriterTextArea() {
    return newTypeWriterTextArea("");
  }

  static public JTextArea newTypeWriterTextArea(String text) {
    return withTypeWriterFont(jTextArea(text));
  }

  static public String struct(Object o) {
    return structure(o);
  }

  static public String struct(Object o, structure_Data data) {
    return structure(o, data);
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public String loadPageSilentlyWithTimeout(double timeoutSeconds, String url) {
    return loadPageSilentlyWithTimeout(url, toMS_int(timeoutSeconds));
  }

  static public String loadPageSilentlyWithTimeout(int timeout, String url) {
    return loadPageSilentlyWithTimeout(url, timeout);
  }

  static public String loadPageSilentlyWithTimeout(String url, int timeout) {
    try {
      url = loadPage_preprocess(url);
      URL _url = new URL(url);
      return loadPage(setURLConnectionTimeouts(_url.openConnection(), timeout), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean loadPageWithUserAgent_verbose = false;

  static public String loadPageWithUserAgent(String url, String userAgent) {
    try {
      URL tURL = new URL(url);
      URLConnection conn = tURL.openConnection();
      conn.setRequestProperty("User-Agent", userAgent);
      loadPage_anonymous = true;
      if (loadPageWithUserAgent_verbose)
        print("Loading as " + userAgent + ": " + hideCredentials(url));
      return loadPage(conn, tURL);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public Object cget(Object c, String field) {
    c = derefRef(c);
    Object o = getOpt(c, field);
    return derefRef(o);
  }

  static public Object cget(String field, Object c) {
    return cget(c, field);
  }

  static public int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_csetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cset(Iterable<? extends Concept> l, Object... values) {
    int changes = 0;
    for (Concept c : unnullForIteration(l)) changes += cset(c, values);
    return changes;
  }

  static public <A extends Concept> int cset(Concept.Ref<A> c, Object... values) {
    return cset(getVar(c), values);
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static public boolean printAlsoToSystemOut = true;

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print(combinePrintParameters(s, o));
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    try {
      Object f = getThreadLocal(print_byThread_dontCreate());
      if (f == null)
        f = print_allThreads;
      if (f != null)
        if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
          return;
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
    }
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    if (printAlsoToSystemOut)
      System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public List<VF1<Map>> _threadInfo_makers = synchroList();

  static public Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  static public List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  static public void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  static public void _threadInfo_addMakerAndRetriever(VF1<Map> maker, VF1<Map> retriever) {
    _threadInfo_makers.add(maker);
    _threadInheritInfo_retrievers.add(retriever);
  }

  static public boolean match(String pat, String s) {
    return match3(pat, s);
  }

  static public boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  static public boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  static public Field getField(Object o, String field) {
    if (o == null)
      return null;
    return setOpt_findField(_getClass(o), field);
  }

  static public Object getField(Field field, Object o) {
    return fieldGet(field, o);
  }

  static public Class fieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getType();
  }

  static public String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (vm_generalMap()) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public Map vm_generalWeakSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  static public <A extends JComponent> A bindToComponent(final A component, final Runnable onShow, final Runnable onUnShow) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final Var<Boolean> flag = new Var<>(false);
            component.addAncestorListener(new AncestorListener() {

              public void ancestorAdded(AncestorEvent event) {
                if (flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(true);
                pcallF(onShow);
              }

              public void ancestorRemoved(AncestorEvent event) {
                if (!flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(false);
                pcallF(onUnShow);
              }

              public void ancestorMoved(AncestorEvent event) {
              }
            });
            if (component.isShowing()) {
              flag.set(true);
              pcallF(onShow);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Var<Boolean> flag = new(false);\r\n    component.addAncestorListener(new ...";
        }
      });
    }
    return component;
  }

  static public <A extends JComponent> A bindToComponent(A component, Runnable onShow) {
    return bindToComponent(component, onShow, null);
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    Long limit = optPar(loadPage_sizeLimit);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      boolean silent = isTrue(loadPage_silent.get());
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (limit == null || n < limit) {
        ping();
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if (!silent && (n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public String loadPage_utf8(URL url) {
    return loadPage_utf8(url.toString());
  }

  static public String loadPage_utf8(String url) {
    AutoCloseable __1 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(url);
    } finally {
      _close(__1);
    }
  }

  static public String loadPage_utf8(URLConnection con, URL url, boolean addHeaders) throws IOException {
    AutoCloseable __2 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(con, url, addHeaders);
    } finally {
      _close(__2);
    }
  }

  static public boolean preferCached = false;

  static public boolean loadSnippet_debug = false;

  static public ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();

  static public ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();

  static public int loadSnippet_timeout = 30000;

  static public String loadSnippet(Snippet s) {
    return loadSnippet(s.id);
  }

  static public String loadSnippet(String snippetID) {
    try {
      if (snippetID == null)
        return null;
      return loadSnippet(parseSnippetID(snippetID), preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(String snippetID, boolean preferCached) throws IOException {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  }

  static public IF1<Long, String> loadSnippet;

  static public String loadSnippet(long snippetID) {
    return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID);
  }

  final static public String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) {
    return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID);
  }

  static public String loadSnippet_base(long snippetID) {
    try {
      return loadSnippet(snippetID, preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(long snippetID, boolean preferCached) throws IOException {
    if (isLocalSnippetID(snippetID))
      return loadLocalSnippet(snippetID);
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadSnippet(fsI(snippetID));
    return loadSnippet_noResourceLoader(snippetID, preferCached);
  }

  static public String loadSnippet_noResourceLoader(long snippetID, boolean preferCached) throws IOException {
    String text;
    initSnippetCache();
    text = DiskSnippetCache_get(snippetID);
    if (preferCached && text != null)
      return text;
    try {
      if (loadSnippet_debug && text != null)
        System.err.println("md5: " + md5(text));
      String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
      if (nempty(text))
        url += "&md5=" + md5(text);
      if (!isTrue(loadSnippet_publicOnly.get()))
        url += standardCredentials();
      String text2 = loadSnippet_loadFromServer(url);
      boolean same = eq(text2, "==*#*==");
      if (loadSnippet_debug)
        print("loadSnippet: same=" + same);
      if (!same)
        text = text2;
    } catch (RuntimeException e) {
      e.printStackTrace();
      throw new IOException("Snippet #" + snippetID + " not found or not public");
    }
    try {
      initSnippetCache();
      DiskSnippetCache_put(snippetID, text);
    } catch (IOException e) {
      System.err.println("Minor warning: Couldn't save snippet to cache (" + DiskSnippetCache_getDir() + ")");
    }
    return text;
  }

  static public File DiskSnippetCache_dir;

  public static void initDiskSnippetCache(File dir) {
    DiskSnippetCache_dir = dir;
    dir.mkdirs();
  }

  public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
    return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
  }

  static public File DiskSnippetCache_getFile(long snippetID) {
    return new File(DiskSnippetCache_dir, "" + snippetID);
  }

  public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
    saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
  }

  public static File DiskSnippetCache_getDir() {
    return DiskSnippetCache_dir;
  }

  public static void initSnippetCache() {
    if (DiskSnippetCache_dir == null)
      initDiskSnippetCache(getGlobalCache());
  }

  static public String loadSnippet_loadFromServer(String url) {
    Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
    try {
      return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
    } finally {
      loadPage_forcedTimeout_byThread.set(oldTimeout);
    }
  }

  static public String loadSnippetQuietly(Snippet s) {
    return loadSnippetQuietly(s.id);
  }

  static public String loadSnippetQuietly(String snippetID) {
    loadSnippet_silent.set(true);
    try {
      return loadSnippet(snippetID);
    } finally {
      loadSnippet_silent.set(null);
    }
  }

  static public String sendToLocalBot(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        print(bot + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(bot + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBot(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        print(port + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(port + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public JTable sexyTableWithoutDrag() {
    final JTable table = tableWithToolTips();
    tablePopupMenu(table, sexyTableWithoutDrag_popupMenuMaker(table));
    table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_FOCUSED).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    ((InputMap) UIManager.get("Table.ancestorInputMap")).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    return table;
  }

  static public VF2<JPopupMenu, Integer> sexyTableWithoutDrag_popupMenuMaker(JTable t) {
    final WeakReference<JTable> ref = weakRef(t);
    return new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, Integer row) {
        try {
          final JTable table = ref.get();
          final String item = first(getTableLine(table, row));
          MouseEvent e = tablePopupMenu_mouseEvent.get();
          final int col = table.columnAtPoint(e.getPoint());
          final Object value = table.getModel().getValueAt(row, col);
          if (value instanceof ImageIcon) {
            addMenuItem(menu, "Copy image to clipboard", new Runnable() {

              public void run() {
                try {
                  copyImageToClipboard(((ImageIcon) value).getImage());
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyImageToClipboard(((ImageIcon) value).getImage());";
              }
            });
          } else {
            final String text = str(value);
            addMenuItem(menu, "Copy text to clipboard", new Runnable() {

              public void run() {
                try {
                  copyTextToClipboard(text);
                  print("Copied text to clipboard: " + quote(text));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyTextToClipboard(text);\r\n        print(\"Copied text to clipboard: \" + quot...";
              }
            });
          }
          addMenuItem(menu, "Set row height...", new Runnable() {

            public void run() {
              try {
                final JTextField tf = jTextField(table.getRowHeight());
                showTitledForm("Set row height", "Pixels", tf, new Runnable() {

                  public void run() {
                    try {
                      table.setRowHeight(parseInt(trim(tf.getText())));
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "table.setRowHeight(parseInt(trim(tf.getText())))";
                  }
                });
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "final JTextField tf = jTextField(table.getRowHeight());\r\n      showTitledForm...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTable table = ref!;\r\n    final S item = first(getTableLine(table, row)...";
      }
    };
  }

  static public class tablePopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JTable, tablePopupMenu_Maker> tablePopupMenu_map = newWeakHashMap();

  static public ThreadLocal<MouseEvent> tablePopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> tablePopupMenu_first = new ThreadLocal();

  static public void tablePopupMenu(final JTable table, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(tablePopupMenu_first));
    {
      swing(new Runnable() {

        public void run() {
          try {
            tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);
            if (maker == null) {
              tablePopupMenu_map.put(table, maker = new tablePopupMenu_Maker());
              final tablePopupMenu_Maker _maker = maker;
              table.addMouseListener(new MouseAdapter() {

                public void mousePressed(MouseEvent e) {
                  displayMenu(e);
                }

                public void mouseReleased(MouseEvent e) {
                  displayMenu(e);
                }

                public void displayMenu(MouseEvent e) {
                  if (!e.isPopupTrigger())
                    return;
                  JPopupMenu menu = new JPopupMenu();
                  int row = table.rowAtPoint(e.getPoint());
                  if (table.getSelectedRowCount() < 2)
                    table.setRowSelectionInterval(row, row);
                  int modelRow = convertTableRowToModel(table, row);
                  int emptyCount = menu.getComponentCount();
                  tablePopupMenu_mouseEvent.set(e);
                  for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, modelRow);
                  vmBus_send("showingPopupMenu", table, menu);
                  if (menu.getComponentCount() != emptyCount)
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
              });
            }
            if (first)
              maker.menuMakers.add(0, menuMaker);
            else
              maker.menuMakers.add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);\r\n    if (maker ==...";
        }
      });
    }
  }

  static public void tablePopupMenuFirst(JTable table, final Object menuMaker) {
    tablePopupMenu_first.set(true);
    tablePopupMenu(table, menuMaker);
  }

  static public void tablePopupMenuFirst(JTable table, IVF2<JPopupMenu, Integer> menuMaker) {
    tablePopupMenuFirst(table, (Object) menuMaker);
  }

  static public ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent;

  static public void componentPopupMenu_init() {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (componentPopupMenu_mouseEvent == null)
              componentPopupMenu_mouseEvent = (ThreadLocal<MouseEvent>) vm_generalMap_get("mouseEvent");
            if (componentPopupMenu_mouseEvent == null)
              vm_generalMap_put("componentPopupMenu_mouseEvent", componentPopupMenu_mouseEvent = new ThreadLocal());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (componentPopupMenu_mouseEvent == null)\r\n      componentPopupMenu_mouseEve...";
        }
      });
    }
  }

  static public void componentPopupMenu(final JComponent component, final Object menuMaker) {
    if (component == null || menuMaker == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) _get(adapter, "maker")).add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public Object componentPopupMenu_initForComponent(final JComponent component) {
    return component == null ? null : swing(new F0<Object>() {

      public Object get() {
        try {
          componentPopupMenu_init();
          Object adapter = findComponentPopupMenuListener_gen(component);
          if (adapter == null) {
            componentPopupMenu_Adapter a = new componentPopupMenu_Adapter();
            component.addMouseListener(a);
            adapter = a;
          }
          return adapter;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "componentPopupMenu_init();\r\n    O adapter = findComponentPopupMenuListener_ge...";
      }
    });
  }

  static public class componentPopupMenu_Adapter extends MouseAdapter {

    public List maker = new ArrayList();

    public boolean internalFrameLeftButtonMagic = false;

    public boolean allowScrolling = true;

    public Point pressedAt;

    public void mousePressed(MouseEvent e) {
      displayMenu(e);
      pressedAt = internalFrameLeftButtonMagic && e.getClickCount() == 1 && internalFrameActive(e.getComponent()) ? e.getLocationOnScreen() : null;
    }

    public void mouseReleased(MouseEvent e) {
      if (internalFrameLeftButtonMagic && eq(pressedAt, e.getLocationOnScreen()))
        displayMenu2(e);
      else
        displayMenu(e);
    }

    public void displayMenu(MouseEvent e) {
      if (e.getSource() instanceof JInternalFrame)
        return;
      if (e.isPopupTrigger())
        displayMenu2(e);
    }

    public void populate(JPopupMenu menu, MouseEvent e) {
      AutoCloseable __1 = tempSetTL(componentPopupMenu_mouseEvent, e);
      try {
        for (Object menuMaker : maker) pcallF(menuMaker, menu);
        vmBus_send("showingPopupMenu", e.getComponent(), menu);
      } finally {
        _close(__1);
      }
    }

    public void displayMenu2(MouseEvent e) {
      JPopupMenu menu = new JPopupMenu();
      int emptyCount = menu.getComponentCount();
      populate(menu, e);
      if (menu.getComponentCount() == emptyCount)
        return;
      if (allowScrolling) {
        menu = new JPopupMenu();
        JMenuScroller scroller = JMenuScroller.setScrollerFor(menu);
        scroller.fillMenu = new VF1<JPopupMenu>() {

          public void get(JPopupMenu m) {
            try {
              populate(m, e);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "populate(m, e)";
          }
        };
      }
      menu.show(e.getComponent(), e.getX(), e.getY());
    }
  }

  static public void componentPopupMenu_top(final JComponent component, final VF1<JPopupMenu> menuMaker) {
    if (component != null && menuMaker != null) {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) get(adapter, "maker")).add(0, menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public MouseEvent componentPopupMenu_getEvent() {
    return componentPopupMenu_mouseEvent.get();
  }

  static public Object dm_current_generic() {
    return getWeakRef(dm_current_generic_tl().get());
  }

  static public Object dm_current_mandatory_generic() {
    return assertNotNull("No module set", dm_current_generic());
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public void makePopupMenuConditional(JComponent c, F0<Boolean> condition) {
    if (c != null && condition != null) {
      swing(new Runnable() {

        public void run() {
          try {
            componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListeners(), componentPopupMenu_Adapter.class);
            c.removeMouseListener(adapter);
            c.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                if (!callF(condition))
                  adapter.mousePressed(e);
              }

              public void mouseReleased(MouseEvent e) {
                if (!callF(condition))
                  adapter.mouseReleased(e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListeners(), c...";
        }
      });
    }
  }

  static public boolean dynamicObjectIsLoading() {
    return isUnstructuring();
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public void rowSorter_setComparators(JTable table, final Object... params) {
    setTableModel_fixSorter.put(table, new VF2<JTable, RowSorter>() {

      public void get(JTable table, RowSorter sorter) {
        try {
          if (sorter instanceof TableRowSorter) {
            for (Pair<Integer, Comparator> p : (List<Pair<Integer, Comparator>>) (List) paramsToPairs(params)) ((TableRowSorter) sorter).setComparator(p.a, p.b);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "//print(\"Fixing table sorter\");\r\n    if (sorter cast TableRowSorter) {\r\n     ...";
      }
    });
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public int year() {
    return localYear();
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public <A> WithTimestamp<A> withTimestamp(A value) {
    return withTimestamp(now(), value);
  }

  static public <A> WithTimestamp<A> withTimestamp(long timestamp, A value) {
    return new WithTimestamp(timestamp, value);
  }

  static public ICachedJavaXExpr javaObjectToIJavaExpr(Object o) {
    if (isListOfElementType(Integer.class, o))
      return javaExpr(functionCall("lInts", naiveQuote(intsToHex_withLineBreaks((List<Integer>) o))), () -> o);
    if (o instanceof List)
      return javaExpr(functionCall("ll", map(__77 -> javaObjectToIJavaExpr(__77), (List) o)), () -> ((List) o));
    Object code = toJavaOpt(o);
    return javaExpr(code, () -> o);
  }

  static public <A, B> List<B> lambdaMapMethod(IF1<A, B> f, Iterable<A> l) {
    return lambdaMethodMap(f, l);
  }

  static public <A, B> List<B> lambdaMapMethod(IF1<A, B> f, A[] l) {
    return lambdaMethodMap(f, l);
  }

  static public double negativeInfinity() {
    return Double.NEGATIVE_INFINITY;
  }

  static public F1 mainFunctionToF1(final String fname) {
    return new F1<Object, Object>() {

      public Object get(Object a) {
        try {
          return callMC(fname, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callMC(fname, a)";
      }
    };
  }

  static public float score(Scored s) {
    return s == null ? 0 : s.score();
  }

  static public Set<String> isThreadRunnable_x_exclude = lithashset("Java.lang.Thread.start0", "java.lang.Object.wait", "java.net.Inet6AddressImpl.lookupAllHostAddr", "java.io.FileInputStream.readBytes", "jdk.internal.misc.Unsafe.park", "sun.misc.Unsafe.park", "java.net.SocketInputStream.socketRead0", "java.net.PlainSocketImpl.socketConnect", "java.net.PlainSocketImpl.socketAccept", "sun.awt.X11.XToolkit.waitForEvents", "java.net.DualStackPlainSocketImpl.accept0", "org.jnativehook.GlobalScreen$NativeHookThread.enable", "java.lang.Thread.sleep", "sun.nio.ch.EPollArrayWrapper.epollWait", "com.ibm.lang.management.internal.MemoryNotificationThread.processNotificationLoop", "com.ibm.tools.attach.target.IPC.waitSemaphore", "sun.nio.ch.Net.poll", "sun.nio.ch.Net.accept", "sun.nio.ch.Net.connect0", "sun.nio.ch.EPoll.wait", "sun.nio.ch.SocketDispatcher.read0", "sun.nio.fs.LinuxWatchService.poll", "java.lang.ref.Reference.waitForReferencePendingList", "com.sun.java.accessibility.internal.AccessBridge.runDLL", "java.lang.ProcessHandleImpl.waitForProcessExit0");

  static public boolean isThreadRunnable_x(Thread t, StackTraceElement[] trace) {
    {
      Boolean __1 = (Boolean) vmBus_query("isThreadRunnable_x", t, trace);
      if (__1 != null)
        return __1;
    }
    if (t.getState() != Thread.State.RUNNABLE)
      return false;
    StackTraceElement e = first(trace);
    if (e == null)
      return false;
    String s = e.getClassName() + "." + e.getMethodName();
    return !isThreadRunnable_x_exclude.contains(s);
  }

  static public RuntimeException asQuickException(Throwable t) {
    return t instanceof RuntimeException ? (RuntimeException) t : new QuickException(t);
  }

  static public void stepAll(Steppable s) {
    if (s != null)
      while (s.step()) {
        ping();
      }
  }

  static public void poorMansProfiling_stopAndPrintResults() {
    poorMansProfiling_renderFullResults_backwards.set(true);
    print(poorMansProfiling_stopAndRenderResults());
  }

  static public boolean isRunnableX(Object o) {
    if (o == null)
      return false;
    if (o instanceof String)
      return hasMethod(mc(), (String) o);
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public JTextArea wrappedTextArea(final JTextArea ta) {
    enableWordWrapForTextArea(ta);
    return ta;
  }

  static public JTextArea wrappedTextArea() {
    return wrappedTextArea(jtextarea());
  }

  static public JTextArea wrappedTextArea(String text) {
    JTextArea ta = wrappedTextArea();
    setText(ta, text);
    return ta;
  }

  static public boolean infoMessage_alwaysOnTop = true;

  static public double infoMessage_defaultTime = 5.0;

  static public JWindow infoMessage(String text) {
    return infoMessage(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage(final String text, final double seconds) {
    printHidingCredentials(text);
    return infoMessage_noprint(text, seconds);
  }

  static public JWindow infoMessage_noprint(String text) {
    return infoMessage_noprint(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage_noprint(final String _text, final double seconds) {
    final String text = hideCredentials(_text);
    if (empty(text))
      return null;
    logQuotedWithDate(infoBoxesLogFile(), text);
    if (isHeadless())
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JWindow window = makeWindow(infoMessage_makePanel(text));
          window.setSize(300, 150);
          moveToTopRightCorner(window);
          if (infoMessage_alwaysOnTop)
            window.setAlwaysOnTop(true);
          if (vmBus_noObjections("shouldShowInfoBox", window, text))
            window.setVisible(true);
          if (seconds != 0)
            disposeWindowAfter(iround(seconds * 1000), window);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JWindow window = makeWindow(infoMessage_makePanel(text));\r\n    window.setSize...";
      }
    });
  }

  static public JWindow infoMessage(Throwable e) {
    printStackTrace(e);
    return infoMessage(exceptionToStringShort(e));
  }

  static public int brightnessToRGBA(int brightness) {
    return 0xFF000000 | clamp(brightness, 0, 255) * 0x010101;
  }

  static public JPanel withBorder(javax.swing.border.Border border, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(border);
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(border);\r\n    p.add...";
      }
    });
  }

  static public Set<String> getPlural_specials = litciset("sheep", "fish");

  static public String getPlural(String s) {
    if (contains(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public boolean hasLetters(String s) {
    for (int i = 0; i < s.length(); i++) if (Character.isLetter(s.charAt(i)))
      return true;
    return false;
  }

  static public <A> List<A> sorted(Collection<A> c, Object comparator) {
    List<A> l = cloneList(c);
    sort(l, makeComparator(comparator));
    return l;
  }

  static public <A> List<A> sorted(Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l);
    return l;
  }

  static public <A> List<A> sorted(Comparator<A> comparator, Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l, comparator);
    return l;
  }

  static public Map<String, Font> loadFont_cached_cache = new HashMap();

  static synchronized public Font loadFont_cached(String snippetID) {
    try {
      snippetID = formatSnippetID(snippetID);
      Font f = loadFont_cached_cache.get(snippetID);
      if (f == null)
        loadFont_cached_cache.put(snippetID, f = loadFont(snippetID, 12f));
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static synchronized public Font loadFont_cached(String snippetID, float size) {
    try {
      return loadFont_cached(snippetID).deriveFont(size);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public Object rcallOpt(String method, Object o, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public void hideConsole() {
    final JFrame frame = consoleFrame();
    if (frame != null) {
      autoVMExit();
      swingLater(new Runnable() {

        public void run() {
          try {
            frame.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setVisible(false);";
        }
      });
    }
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  static public boolean machineIsOffline() {
    return isFalse(callF(vmGeneralMap_get("areWeOnline")));
  }

  static public Set<String> getClassDeclarationName_skippables_cache;

  static public Set<String> getClassDeclarationName_skippables() {
    if (getClassDeclarationName_skippables_cache == null)
      getClassDeclarationName_skippables_cache = getClassDeclarationName_skippables_load();
    return getClassDeclarationName_skippables_cache;
  }

  static public Set<String> getClassDeclarationName_skippables_load() {
    return litset("noeq", "mapMethodLike");
  }

  static public <A> List<A> childrenOfType(Component c, Class<A> theClass) {
    List<A> l = new ArrayList();
    scanForComponents(c, theClass, l);
    return l;
  }

  static public <A> List<A> childrenOfType(Class<A> theClass, Component c) {
    return childrenOfType(c, theClass);
  }

  static public void dm_reloadModuleInBackground(Object module) {
    dm_callOS("reloadModuleInBackground", dm_getStem(module));
  }

  static public void dm_reloadModuleInBackground() {
    dm_reloadModuleInBackground(dm_current_mandatory_generic());
  }

  static public ThreadLocal<Boolean> poorMansProfiling_renderFullResults_backwards = new ThreadLocal();

  static public String poorMansProfiling_renderFullResults(final MultiSet<String> traces) {
    int samples = poorMansProfiling_samples;
    boolean backwards = isTrue(getAndClearThreadLocal(poorMansProfiling_renderFullResults_backwards));
    final int n = traces.size();
    int percent = ratioToIntPercent(l(traces), samples);
    return (samples == 0 ? "Nothing sampled" : percent + "% core activity [" + n2(samples, "sample") + " taken]") + "\n\n" + joinMap(backwards ? traces.lowestFirst() : traces.highestFirst(), new F1<String, Object>() {

      public Object get(String trace) {
        try {
          return traces.get(trace) + "/" + n + "\n" + trace + "\n\n";
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "traces.get(trace) + \"/\" + n + \"\\n\" + trace + \"\\n\\n\"";
      }
    });
  }

  static public String unCurlyBracket(String s) {
    return tok_unCurlyBracket(s);
  }

  static public Pair<File, String> compileSnippetThroughServer(String progID) {
    String transpiledSrc = getServerTranspiled2(progID);
    String md5 = md5(transpiledSrc + "\n" + progID);
    File jar = CompilerBot.getJarFile(md5);
    if (jar == null || jar.length() <= 22) {
      byte[] jarData = null;
      boolean dontLoad = false;
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null) {
        dontLoad = true;
        File jar2 = rl.getSnippetJar(progID, transpiledSrc);
        if (jar2 != null)
          return pair(jar2, transpiledSrc);
      }
      if (!dontLoad) {
        try {
          jarData = loadBinaryPage("http://www.botcompany.de/jar/" + psI(progID) + "?md5=" + md5(transpiledSrc));
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
      if (!isJAR(jarData)) {
        if (jarData != null) {
          print(bytesToHex(takeFirstOfByteArray(8, jarData)));
          print("fallback to CompilerBot: " + fromUtf8(takeFirstOfByteArray(80, jarData)));
        }
        return CompilerBot.compileSnippet2(progID);
      }
      saveBinaryFile(jar, jarData);
    }
    return pair(jar, transpiledSrc);
  }

  static public String dropSpaceEtc(String s) {
    if (empty(s))
      return null;
    int n = l(s), i = 0;
    char c = s.charAt(i);
    boolean totality = !isSpaceEtc(c);
    for (++i; i < n; i++) {
      c = s.charAt(i);
      boolean b = !isSpaceEtc(c);
      if (b != totality) {
        StringBuilder buf = new StringBuilder();
        if (totality)
          buf.append(substring(s, 0, i));
        while (true) {
          ping();
          if (b)
            buf.append(c);
          if (++i >= n)
            break;
          c = s.charAt(i);
          b = !isSpaceEtc(c);
        }
        return buf.toString();
      }
    }
    return totality ? s : "";
  }

  static public ClassLoader getVirtualParent(ClassLoader cl) {
    return (ClassLoader) rcallOpt("getVirtualParent", cl);
  }

  static public boolean titlePopupMenu(final Component c, final Object menuMaker) {
    JComponent titleBar = getTitlePaneComponent(getPossiblyInternalFrame(c));
    if (titleBar == null) {
      print("Can't add title right click!");
      return false;
    } else {
      componentPopupMenu(titleBar, menuMaker);
      return true;
    }
  }

  static public <A, B> boolean isA(Either<A, B> e) {
    return eitherIsA(e);
  }

  static public long nanoTime() {
    return System.nanoTime();
  }

  static public int activateFrame_v3_delay = 100;

  static public boolean activateFrame_v3(Component c, Object... __) {
    return swing(() -> {
      Frame f = getAWTFrame(c);
      if (f == null)
        return false;
      if (!f.isVisible())
        f.setVisible(true);
      int state = f.getState();
      boolean iconified = state == Frame.ICONIFIED;
      boolean maximize = boolPar("maximize", __);
      if (iconified)
        f.setState(maximize ? Frame.MAXIMIZED_BOTH : Frame.NORMAL);
      else {
        f.setState(Frame.ICONIFIED);
        print("Restoring frame in " + activateFrame_v3_delay + " ms");
        doLater(activateFrame_v3_delay, new Runnable() {

          public void run() {
            try {
              f.setState(state);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "f.setState(state)";
          }
        });
      }
      f.toFront();
      return true;
    });
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public Set vm_generalWeakSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = newWeakHashSet());
      return set;
    }
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public boolean isCurlyBraced(String s) {
    List<String> tok = tok_combineCurlyBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "{", "}");
  }

  static public String b(Object contents, Object... params) {
    return tag("b", contents, params);
  }

  static public File findCmdOnPATH(String cmd) {
    String path = System.getenv("PATH");
    List<String> dirs = splitAt(path, File.pathSeparator);
    String c = isWindows() ? addSuffix(cmd, ".exe") : cmd;
    for (String dir : dirs) {
      File f = new File(dir, c);
      if (f.isFile())
        return f;
    }
    return null;
  }

  static public File tempDirPossiblyInRAMDisk() {
    File f = linux_fileInRamDisk(aGlobalID());
    if (f != null) {
      f.mkdirs();
      return f;
    }
    return makeTempDir();
  }

  static public int javaxIncludeSnippetType() {
    return 42;
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public Pt bottomRightCorner(Rect r) {
    return r == null ? null : pt(r.x2(), r.y2());
  }

  static public FixedRateTimer doEvery_daemon(long delay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, final Object r) {
    return doEvery_daemon(timerName, delay, delay, r);
  }

  static public FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, firstDelay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(true);
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
    return timer;
  }

  static public FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
    return doEvery_daemon(toMS(delaySeconds), r);
  }

  static public void pClose(AutoCloseable c) {
    close_pcall(c);
  }

  static public void closeRandomAccessFile(RandomAccessFile f) {
    if (f != null)
      try {
        f.close();
        callJavaX("dropIO", f);
      } catch (Throwable e) {
        printStackTrace(e);
      }
  }

  static public JPanel jCenteredSection(Component c) {
    return jCenteredSection("", c);
  }

  static public JPanel jCenteredSection(String title, Swingable c) {
    return jCenteredSection(title, wrap(c));
  }

  static public JPanel jCenteredSection(String title, Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = jSection(title, c);
          ((TitledBorder) p.getBorder()).setTitleJustification(TitledBorder.CENTER);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = jSection(title, c);\r\n    ((TitledBorder) p.getBorder()).setTitleJu...";
      }
    });
  }

  static public JPanel jCenteredSection(String title) {
    return jCenteredSection(title, jpanel());
  }

  static public Comparator makeComparator(final Object f) {
    if (f instanceof Comparator)
      return (Comparator) f;
    return new Comparator() {

      public int compare(Object a, Object b) {
        return (Integer) callF(f, a, b);
      }
    };
  }

  static public String manifestTextForMainClass(String mainClass) {
    return "Manifest-Version: 1.0\n" + "Main-Class: " + mainClass + "\n\n";
  }

  static public JLabel dm_fieldLabel(String fieldName) {
    return jLiveValueLabel(dm_fieldLiveValue(fieldName));
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    int n = s.length();
    StringBuilder out = null;
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (c == '<') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&lt;");
      } else if (c == '>') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&gt;");
      } else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else {
        if (out != null)
          out.append(c);
      }
    }
    return out == null ? s : out.toString();
  }

  static public Window dm_window(Object module) {
    return getWindow(dm_vis(module));
  }

  static public <A> IVF1<A> ivf1WithToString(String toString, IVF1<A> f) {
    return f == null ? null : new IVF1<A>() {

      public void get(A a) {
        f.get(a);
      }

      public String toString() {
        return toString;
      }
    };
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public double abs(Complex c) {
    return c.abs();
  }

  static public <A> void forEachWithPosition(Matrix<A> m, IVF3<Integer, Integer, A> f) {
    if (m == null || f == null)
      return;
    int w = m.getWidth(), h = m.getHeight();
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) f.get(x, y, m.get(x, y));
  }

  static public Map<Thread, StackTraceElement[]> runnableThreadsWithStackTraces() {
    Map<Thread, StackTraceElement[]> map = filterMap((__98, __99) -> isThreadRunnable_x(__98, __99), Thread.getAllStackTraces());
    map.remove(currentThread());
    return map;
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(int w, BWIntegralImage img) {
    return scaledBufferedImageFromBWIntegralImage(img, w);
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(BWIntegralImage img, int w) {
    return scaledBufferedImageFromBWIntegralImage(img, w, heightForWidth(img.w, img.h, w));
  }

  static public BufferedImage scaledBufferedImageFromBWIntegralImage(BWIntegralImage img, int w, int h) {
    int w1 = img.w, h1 = img.h;
    int[] pixels = new int[w * h];
    int i = 0;
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int pixel = iround(img.getPixelAverage(x1, y1, x2, y2));
      pixels[i++] = brightnessToRGBA(pixel);
    }
    return bufferedImage(w, h, pixels);
  }

  public static String winQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String winQuote(File f) {
    return winQuote(f.getAbsolutePath());
  }

  static public Map<String, String> stdFunctions_uncached() {
    return stdFunctions_uncached(new HashMap());
  }

  static public Map<String, String> stdFunctions_uncached(Map<String, String> map) {
    parseStdFunctionsList(loadSnippetSilently("#1006654"), map);
    parseStdFunctionsList(loadSnippetSilently("#761"), map);
    return map;
  }

  static public boolean isJavaxModuleSnippetType(int type) {
    return type == snippetType_javaxModule() || type == snippetType_javaxDesktopModule();
  }

  static public int findEndOfBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "("))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public File prepareProgramFile(String name) {
    return mkdirsForFile(getProgramFile(name));
  }

  static public File prepareProgramFile(String progID, String name) {
    return mkdirsForFile(getProgramFile(progID, name));
  }

  static public boolean rectEmpty(Rect r) {
    return r == null || r.w <= 0 || r.h <= 0;
  }

  static public Set<String> tok_returnTypesOfStaticFunction_uncleaned(List<String> tok, String functionName) {
    List<List<String>> funcs = findFullFunctionDefs(tok, true);
    TreeSet<String> out = new TreeSet();
    for (List<String> tokF : funcs) {
      int i = indexOfAny(tokF, 0, "(", "{");
      if (i < 0)
        continue;
      String fname = get(tokF, i - 2);
      if (!eq(fname, functionName))
        continue;
      out.add(joinSubList(tokF, 1, i - 3));
    }
    return out;
  }

  static public BufferedImage intMatrixToImage(Matrix<Integer> m) {
    return intMatrixToBufferedImage(m);
  }

  static public void interruptThreads(Collection<Thread> threads) {
    for (Thread t : unnull(threads)) interruptThread(t);
  }

  static public void interruptThreads(Class mainClass) {
    interruptThreads(registeredThreads(mainClass));
  }

  static public List<File> hotwire_collectJars(File jar) {
    List<String> libIDs = hotwire_libraryIDsFromJar_deleteJarOnFail(jar);
    List<File> files = ll(jar);
    for (String libID : libIDs) files.add(loadLibraryOrSrcLib(libID));
    return files;
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public <A, B> Either<A, B> eitherB(B b) {
    return new Either(2, b);
  }

  static public String evalJava_prep(String code) {
    return evalJava_prep(code, "calc");
  }

  static public String evalJava_prep(String code, String mainName) {
    return evalJava_prep(code, mainName, "");
  }

  static public ThreadLocal<String> evalJava_prep_args = new ThreadLocal();

  static public String evalJava_prep(String code, String mainName, String preCode) {
    EvalJavaPrep prep = new EvalJavaPrep();
    List<String> tok = evalJava_prePrep(code, prep);
    code = tok_addReturn(tok);
    String returnType = containsReturnWithArgument(code) ? "O" : "void";
    String main = lines(prep.global) + "static " + returnType + " " + mainName + "(" + unnull(evalJava_prep_args.get()) + ") throws Exception {\n" + preCode + code + "\n" + "}";
    return main;
  }

  static public <A, B> Either<A, B> eitherA(A a) {
    return new Either(1, a);
  }

  static public void markAsSrcLib(String snippetID) {
    saveTextFile(javaxCodeDir("srclibs/" + psI(snippetID)), "");
  }

  static public int lIntArray(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public ThreadLocal<Long> evalJava_myProgramID_main_time = new ThreadLocal();

  static public ThreadLocal<Object> evalJava_myProgramID_main_mainClass = new ThreadLocal();

  static public Object evalJava_myProgramID_main(String main, Object... args) {
    Object obj = veryQuickJava(main);
    setOpt(obj, "programID", programID());
    makeDependent(obj);
    if (evalJava_myProgramID_main_mainClass.get() != null)
      evalJava_myProgramID_main_mainClass.set(obj);
    return evalJava_myProgramID_main_2(obj, args);
  }

  static public Object evalJava_myProgramID_main_2(Object obj, Object... args) {
    long time = sysNow();
    try {
      return callCalc(obj, args);
    } finally {
      evalJava_myProgramID_main_time.set(sysNow() - time);
    }
  }

  static public void addMouseAndMotionListener(JComponent c, MouseAdapter ma) {
    if (c != null && ma != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(ma);
            c.addMouseMotionListener(ma);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(ma);\r\n    c.addMouseMotionListener(ma);";
        }
      });
    }
  }

  static public void containerAddFirst(final Container c, final Component... l) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            for (int i = 0; i < l(l); i++) c.add(l[i], i);
            revalidate(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (int i = 0; i < l(l); i++)\r\n      c.add(l[i], i);\r\n    revalidate(c);";
        }
      });
    }
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public String asciiHeading2(String title) {
    return asciiHeading(title) + "\n";
  }

  static public List<Component> getComponents(final Component c) {
    return !(c instanceof Container) ? emptyList() : asList(swing(new F0<Component[]>() {

      public Component[] get() {
        try {
          return ((Container) c).getComponents();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret ((Container) c).getComponents();";
      }
    }));
  }

  static public <A> List<Pair<A, A>> paramsToPairs(A... params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToPairs((Map) params[0]);
    List<Pair<A, A>> l = emptyList(l(params) / 2);
    for (int i = 0; i + 1 < l(params); i += 2) l.add(pair(params[i], params[i + 1]));
    return l;
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public int area(Rect r) {
    return rectArea(r);
  }

  static public double area(DoubleRect r) {
    return r == null ? 0 : r.w * r.h;
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public long add(AtomicLong l, long b) {
    return l.addAndGet(b);
  }

  static public SingleComponentPanel singleComponentPanel() {
    return singleComponentPanel(null);
  }

  static public SingleComponentPanel singleComponentPanel(final Component c) {
    return swing(new F0<SingleComponentPanel>() {

      public SingleComponentPanel get() {
        try {
          return new SingleComponentPanel(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new SingleComponentPanel(c);";
      }
    });
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public int withMargin_defaultWidth = 6;

  static public JPanel withMargin(Component c) {
    return withMargin(withMargin_defaultWidth, c);
  }

  static public JPanel withMargin(int w, Component c) {
    return withMargin(w, w, c);
  }

  static public JPanel withMargin(int w, int h, Component c) {
    return withMargin(w, h, w, h, c);
  }

  static public JPanel withMargin(final int top, final int left, final int bottom, final int right, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(to...";
      }
    });
  }

  static public File getCodeProgramDir() {
    return getCodeProgramDir(getProgramID());
  }

  static public File getCodeProgramDir(String snippetID) {
    return new File(javaxCodeDir(), formatSnippetID(snippetID));
  }

  static public File getCodeProgramDir(long snippetID) {
    return getCodeProgramDir(formatSnippetID(snippetID));
  }

  static public void addActionListener(JTextField tf, final Runnable action) {
    onEnter(tf, action);
  }

  static public void addActionListener(final JComboBox cb, final Runnable action) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public void addActionListener(final AbstractButton b, final Runnable action) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            b.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public Matrix<Integer> imageToMatrix(MakesBufferedImage img) {
    return imageToMatrix(toBufferedImage(img));
  }

  static public Matrix<Integer> imageToMatrix(BufferedImage img) {
    if (img == null)
      return null;
    int _w = img.getWidth(), _h = img.getHeight();
    class ImageToMatrix extends AbstractMatrix<Integer> {

      public ImageToMatrix() {
        super(_w, _h);
      }

      public Integer get(int x, int y) {
        assertPointInBounds(x, y, w, h);
        return img.getRGB(x, y);
      }

      public void set(int x, int y, Integer val) {
        assertPointInBounds(x, y, w, h);
        img.setRGB(x, y, val);
      }
    }
    ;
    return new ImageToMatrix();
  }

  static public int hashAboutObjects(Object... l) {
    int hash = 0, n = l(l);
    for (int i = 0; i < n; i++) hash = boostHashCombine(hash, hashCode(l[i]));
    return hash;
  }

  static public boolean hasMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args) != null;
  }

  static public void clearTokens(List<String> tok) {
    clearAllTokens(tok);
  }

  static public void clearTokens(List<String> tok, int i, int j) {
    clearAllTokens(tok, i, j);
  }

  static public void clearTokens(List<String> tok, IntRange r) {
    clearAllTokens(tok, r.start, r.end);
  }

  static public KeyListener enterKeyListener(final Object action) {
    return new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == KeyEvent.VK_ENTER)
          pcallF(action);
      }
    };
  }

  static public String poorMansProfiling_stopAndRenderResults() {
    return poorMansProfiling_renderFullResults(poorMansProfiling_stopAndGetResults());
  }

  static public int areaFromPoints(int x1, int y1, int x2, int y2) {
    return (x1 - x1) * (y2 - y1);
  }

  static public List<Integer> countIteratorToList(int b) {
    return countIteratorToList(0, b);
  }

  static public List<Integer> countIteratorToList(int a, int b) {
    return asList(countIterator(a, b));
  }

  static public <A> List<A> countIteratorToList(int b, IF1<Integer, A> f) {
    return countIteratorToList(0, b, f);
  }

  static public <A> List<A> countIteratorToList(int a, int b, IF1<Integer, A> f) {
    return asList(countIterator(a, b, f));
  }

  static public List<Integer> countIteratorToList(int a, int b, int step) {
    return asList(countIterator(a, b, step));
  }

  static public <A> List<A> countIteratorToList(double a, double b, double step, IF1<Double, A> f) {
    return asList(countIterator(a, b, step, f));
  }

  static public <A> List<Double> countIteratorToList(double a, double b, double step) {
    return asList(countIterator(a, b, step));
  }

  static public <A> List<A> countIteratorToList(IF1<Double, A> f, double a, double b, double step) {
    return asList(countIterator(f, a, b, step));
  }

  static public <A> List<A> countIteratorToList(IF1<Integer, A> f, int b) {
    return countIteratorToList(f, 0, b);
  }

  static public <A> List<A> countIteratorToList(IF1<Integer, A> f, int a, int b) {
    return asList(countIterator(f, a, b));
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public Object hotwire_onCompile;

  static public boolean hotwire_serially = false;

  static public Lock hotwire_overInternalBot_lock = lock();

  static public boolean hotwire_compileOnServer = false;

  static public Class<?> hotwire_overInternalBot(String progID) {
    return hotwire_overInternalBot(progID, "main");
  }

  static public Class<?> hotwire_overInternalBot(String progID, String mainClass) {
    return hotwire_overInternalBot(progID, __ -> mainClass);
  }

  static public Class<?> hotwire_overInternalBot(String progID, IF1<ClassLoader, String> calculateMainClass) {
    try {
      Pair<File, String> p;
      try {
        p = hotwire_compile(progID);
      } catch (Throwable e) {
        throw rethrow("Error hotwiring " + progID, e);
      }
      File jar = p.a;
      assertTrue(jar.getAbsolutePath(), jar.isFile());
      List<File> files = hotwire_collectJars(jar);
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      classLoader.progID = progID;
      String mainClass = calculateMainClass == null ? "main" : calculateMainClass.get(classLoader);
      return hotwire_finish(classLoader, progID, p.b, mainClass);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pair<File, String> hotwire_compile(String progID) {
    Pair<File, String> p = hotwire_compileOnServer && !isLocalSnippetID(progID) ? compileSnippetThroughServer(progID) : CompilerBot.compileSnippet2(progID);
    Lock __0 = hotwire_serially ? hotwire_overInternalBot_lock : null;
    lock(__0);
    try {
      callF(hotwire_onCompile, p);
      return p;
    } finally {
      unlock(__0);
    }
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public <A> boolean containsOneOf(Collection<A> l, A... x) {
    if (l instanceof Set) {
      if (x != null)
        for (A a : x) if (l.contains(a))
          return true;
    } else {
      for (A a : unnull(l)) if (eqOneOf(a, x))
        return true;
    }
    return false;
  }

  static public <A> boolean containsOneOf(Collection<A> l, Set<A> set) {
    if (set == null)
      return false;
    for (A a : unnull(l)) if (set.contains(a))
      return true;
    return false;
  }

  static public boolean containsOneOf(String s, String... x) {
    for (String o : x) if (contains(s, o))
      return true;
    return false;
  }

  static public AutoCloseable dm_registerAs_direct(String... msgs) {
    return dm_registerAs_directLink(msgs);
  }

  static public JFrame setFrameIconLater(Component c, final String imageID) {
    final JFrame frame = getFrame(c);
    if (frame != null)
      startThread("Loading Icon", new Runnable() {

        public void run() {
          try {
            final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
            swingLater(new Runnable() {

              public void run() {
                try {
                  frame.setIconImage(i);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "frame.setIconImage(i);";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Image i = imageIcon(or2(imageID, \"#1005557\")).getImage();\r\n      swingL...";
        }
      });
    return frame;
  }

  static public Rect intersectRects(Rect a, Rect b) {
    int x = max(a.x, b.x), y = max(a.y, b.y);
    int x2 = min(a.x + a.w, b.x + b.w), y2 = min(a.y + a.h, b.y + b.h);
    return new Rect(x, y, x2 - x, y2 - y);
  }

  static public Rect intersectRects(Rect a, int x1, int y1, int w, int h) {
    if (a == null || a.x >= x1 && a.y >= y1 && a.x2() < x1 + w && a.y2() < y1 + h)
      return a;
    return rectFromPoints(max(a.x, x1), max(a.y, y1), min(a.x2(), x1 + w), min(a.y2(), y1 + h));
  }

  static public String loadCachedTranspilation(String id) {
    try {
      return loadTextFilePossiblyGZipped(getCachedTranspilationFile(id));
    } catch (Throwable __e) {
      return null;
    }
  }

  static public File infoBoxesLogFile() {
    return new File(javaxDataDir(), "Logs/infoBoxes.txt");
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public double minusInfinity() {
    return negativeInfinity();
  }

  static public boolean deleteFile(File file) {
    return file != null && file.delete();
  }

  static public <A> Matrix<A> listOfListsToMatrix(List<List<A>> data) {
    if (data == null)
      return null;
    int _h = l(data);
    if (_h == 0)
      return null;
    int _w = l(data.get(0));
    class ListsToMatrix extends AbstractMatrix<A> {

      public ListsToMatrix() {
        super(_w, _h);
      }

      public A get(int x, int y) {
        return data.get(y).get(x);
      }

      public void set(int x, int y, A a) {
        data.get(y).set(x, a);
      }
    }
    ;
    return new ListsToMatrix();
  }

  static public String firstToken(String s) {
    return firstJavaToken(s);
  }

  static public String firstToken(List<String> tok) {
    return get(tok, 1);
  }

  static public JPanel centerAndSouthWithMargins(Component c, Component s) {
    return applyDefaultMargin(centerAndSouth(c, withTopMargin(s)));
  }

  static public JPanel centerAndSouthWithMargins(int margin, Component c, Component s) {
    return applyMargin(margin, centerAndSouth(c, withTopMargin(margin, s)));
  }

  static public void setSCPComponent(SingleComponentPanel scp, Component c) {
    if (scp != null)
      scp.setComponent(c);
  }

  static public void stopTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public Object dm_os() {
    {
      Object __1 = vm_generalMap_get("stefansOS");
      if (__1 != null)
        return __1;
    }
    return creator();
  }

  static public void hideWindow(final Component c) {
    final Window w = getWindow(c);
    if (w != null) {
      swing(new Runnable() {

        public void run() {
          try {
            w.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.setVisible(false);";
        }
      });
    }
  }

  static public <A> A cyclicGet(List<A> l, int i) {
    return empty(l) ? null : get(l, mod(i, l(l)));
  }

  static public String ymdMinusHMS() {
    return ymd_minus_hms();
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public int toIntPercent(double ratio) {
    return roundToInt(ratio * 100);
  }

  static public int toIntPercent(float ratio) {
    return toIntPercent((double) ratio);
  }

  static public boolean tok_classHasModifier(List<String> classDecl, String modifier) {
    if (classDecl == null)
      return false;
    int i = classDecl.indexOf("class");
    return subList(classDecl, 0, i).contains(modifier);
  }

  static public String prependSquareBracketed(Object o) {
    String s = strOrEmpty(o);
    return empty(s) ? "" : squareBracketed(s) + " ";
  }

  static public int withLeftMargin_defaultWidth = 6;

  static public JPanel withLeftMargin(Component c) {
    return withLeftMargin(withLeftMargin_defaultWidth, c);
  }

  static public JPanel withLeftMargin(final int margin, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, margin, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public BetterThreadLocal<PingSource> pingSource_tl_var = new BetterThreadLocal<PingSource>() {

    @Override
    public PingSource initialValue() {
      return ping_v3_pingSourceMaker().get();
    }
  };

  static public BetterThreadLocal<PingSource> pingSource_tl() {
    return pingSource_tl_var;
  }

  static public JPanel jSection(Component c) {
    return jSection("", c);
  }

  static public JPanel jSection(final String title, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
          border = BorderFactory.createTitledBorder(border, title);
          JSection panel = new JSection(c);
          panel.setBorder(border);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);\r\n    bo...";
      }
    });
  }

  static public JPanel jSection(String title) {
    return jSection(title, jpanel());
  }

  static public JPanel jSection(LiveValue<?> lv, Component c) {
    return jLiveValueSection(lv, c);
  }

  static public JButton jPopDownButton_noText(final Object... menuParams) {
    return toolTip("Additional commands", jPopDownButton("", menuParams));
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public <A> List<A> replaceElementsUsingMap(Iterable<A> l, final Map<A, A> map) {
    return map(l, new F1<A, A>() {

      public A get(A a) {
        try {
          return getOrKeep(map, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "getOrKeep(map, a)";
      }
    });
  }

  static public void swingLater(long delay, final Object r) {
    javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
    timer.setRepeats(false);
    timer.start();
  }

  static public void swingLater(Object r) {
    SwingUtilities.invokeLater(toRunnable(r));
  }

  static public String tok_unCurlyBracket(String s) {
    return isCurlyBraced(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public boolean makeNotifyingStringBufferRotate_verbose = false;

  static public class NotifyingStringBufferRotator implements Runnable {

    public NotifyingStringBuffer buf;

    public IF0<Integer> getMaxChars;

    public boolean processing = false;

    public NotifyingStringBufferRotator(NotifyingStringBuffer buf, IF0<Integer> getMaxChars) {
      this.getMaxChars = getMaxChars;
      this.buf = buf;
    }

    public void run() {
      try {
        if (processing)
          return;
        AutoCloseable __1 = tempSet(this, "processing", true);
        try {
          Integer max = callF(getMaxChars);
          if (max == null || buf.length() <= max)
            return;
          if (makeNotifyingStringBufferRotate_verbose)
            print("Rotating NotifyingStringBuffer (" + buf.length() + "/" + max + ")");
          try {
            int newLength = max / 2;
            int ofs = buf.length() - newLength;
            String newString = buf.substring(ofs);
            buf.setLength(0);
            buf.append("[...] ").append(newString);
          } catch (Exception e) {
            buf.setLength(0);
          }
          buf.trimToSize();
        } finally {
          _close(__1);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public void makeNotifyingStringBufferRotate(NotifyingStringBuffer buf, IF0<Integer> getMaxChars) {
    if (hasElementWithClassShortNamed("NotifyingStringBufferRotator", buf.onChange))
      return;
    buf.onChange(new NotifyingStringBufferRotator(buf, getMaxChars));
  }

  static public <A> List<A> matrixToList(Matrix<A> m) {
    if (m == null)
      return null;
    int w = m.getWidth(), h = m.getHeight(), n = w * h;
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return n;
      }

      public A get(int i) {
        return m.get(i % w, i / w);
      }

      public A set(int i, A val) {
        A old = m.get(i % w, i % h);
        m.set(i % w, i / w, val);
        return old;
      }
    };
  }

  static public Object[] mapObjectArray(IF1 f, Object[] l) {
    if (empty(l))
      return l;
    int n = l.length;
    Object[] a2 = new Object[n];
    for (int i = 0; i < n; i++) a2[i] = f.get(l[i]);
    return a2;
  }

  static public String defaultTimerName_name;

  static public String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  static public ThreadLocal<BufferedImage> currentImage_var = new ThreadLocal();

  static public BufferedImage currentImage() {
    return currentImage_var.get();
  }

  static public void currentImage(BufferedImage img) {
    currentImage_var.set(img);
  }

  static public int imageMergeSpacing = 5;

  static public int imageMergeSpacing() {
    return imageMergeSpacing;
  }

  static public void imageMergeSpacing(int pixels) {
    imageMergeSpacing = pixels;
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  static public boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  static public boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  static public MultiSet<String> poorMansProfiling_results = new MultiSet();

  static public int poorMansProfiling_samples;

  static public java.util.Timer poorMansProfiling_timer;

  static public Lock poorMansProfiling_lock = lock();

  static public Thread poorMansProfiling_threadToSample;

  static public void poorMansProfiling() {
    poorMansProfiling(poorMansProfiling_defaultInterval());
  }

  static public void poorMansProfiling(Thread thread) {
    poorMansProfiling(poorMansProfiling_defaultInterval(), thread);
  }

  static public void poorMansProfiling(int interval) {
    poorMansProfiling(interval, null);
  }

  static public void poorMansProfiling(int interval, Thread thread) {
    Lock __0 = poorMansProfiling_lock;
    lock(__0);
    try {
      poorMansProfiling_threadToSample = thread;
      poorMansProfiling_stop();
      poorMansProfiling_clear();
      poorMansProfiling_timer = doEvery_daemon(interval, new Runnable() {

        public void run() {
          try {
            Map<Thread, StackTraceElement[]> map = poorMansProfiling_threadToSample != null ? litmap(poorMansProfiling_threadToSample, poorMansProfiling_threadToSample.getStackTrace()) : runnableThreadsWithStackTraces();
            Lock __1 = poorMansProfiling_lock;
            lock(__1);
            try {
              poorMansProfiling_samples++;
              for (Thread t : keys(map)) {
                {
                  if (isSystemThread(t))
                    continue;
                }
                StringBuilder buf = new StringBuilder();
                for (StackTraceElement e : map.get(t)) buf.append(e).append("\n");
                poorMansProfiling_results.add(str(buf));
              }
            } finally {
              unlock(__1);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Map<Thread, StackTraceElement[]> map =\r\n      poorMansProfiling_threadToSampl...";
        }
      });
    } finally {
      unlock(__0);
    }
  }

  static public void poorMansProfiling_stop() {
    Lock __2 = poorMansProfiling_lock;
    lock(__2);
    try {
      if (poorMansProfiling_timer != null) {
        stopTimer(poorMansProfiling_timer);
        poorMansProfiling_timer = null;
      }
    } finally {
      unlock(__2);
    }
  }

  static public void poorMansProfiling_clear() {
    Lock __3 = poorMansProfiling_lock;
    lock(__3);
    try {
      poorMansProfiling_results.clear();
      poorMansProfiling_samples = 0;
    } finally {
      unlock(__3);
    }
  }

  static public MultiSet<String> poorMansProfiling_results() {
    return new MultiSet(poorMansProfiling_results);
  }

  static public MultiSet<String> poorMansProfiling_stopAndGetResults() {
    Lock __4 = poorMansProfiling_lock;
    lock(__4);
    try {
      poorMansProfiling_stop();
      return poorMansProfiling_results();
    } finally {
      unlock(__4);
    }
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public JLabel setImage(final BufferedImage img, final JLabel lbl) {
    if (lbl != null) {
      swing(new Runnable() {

        public void run() {
          try {
            lbl.setIcon(imageIcon(img));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lbl.setIcon(imageIcon(img));";
        }
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, BufferedImage img) {
    return setImage(img, lbl);
  }

  static public JLabel setImage(final String imageID, final JLabel lbl) {
    if (lbl != null) {
      swing(new Runnable() {

        public void run() {
          try {
            lbl.setIcon(imageIcon(imageID));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lbl.setIcon(imageIcon(imageID));";
        }
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, String imageID) {
    return setImage(imageID, lbl);
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static public void bindTimerToComponent(final Timer timer, JFrame f) {
    bindTimerToComponent(timer, f.getRootPane());
  }

  static public void bindTimerToComponent(final Timer timer, JComponent c) {
    if (c.isShowing())
      timer.start();
    c.addAncestorListener(new AncestorListener() {

      public void ancestorAdded(AncestorEvent event) {
        timer.start();
      }

      public void ancestorRemoved(AncestorEvent event) {
        timer.stop();
      }

      public void ancestorMoved(AncestorEvent event) {
      }
    });
  }

  static public IntegerIterator integerIterator(int[] l) {
    return l == null ? null : new IntegerIterator() {

      public int i = 0;

      public boolean hasNext() {
        return i < l.length;
      }

      public int next() {
        return l[i++];
      }
    };
  }

  static public boolean containsRegexp(String s, String pat) {
    return regexpFinds(pat, s);
  }

  static public int numLines(String s) {
    return countLines(s);
  }

  static public String simpleQuote(String s) {
    return s == null ? "null" : "\"" + s + "\"";
  }

  static public <A> int indexOfAny(List<A> l, int i, A... x) {
    while (i < l(l)) if (eqOneOf(l.get(i), x))
      return i;
    else
      ++i;
    return -1;
  }

  static public <A> int indexOfAny(List<A> l, Collection<A> x) {
    return indexOfAny(l, 0, x);
  }

  static public <A> int indexOfAny(List<A> l, int i, Collection<A> x) {
    if (nempty(x))
      while (i < l(l)) if (x.contains(l.get(i)))
        return i;
      else
        ++i;
    return -1;
  }

  static public int indexOfAny(String s, int i, String chars) {
    for (; i < l(s); i++) if (chars.indexOf(s.charAt(i)) >= 0)
      return i;
    return -1;
  }

  static public int indexOfAny(String s, String chars) {
    return indexOfAny(s, 0, chars);
  }

  static public BufferedImage gridLOLToImage(List<Integer> cellWidths, List<Integer> cellHeights, List<List<Integer>> lol) {
    List<Matrix<Integer>> lom = mapWithIndex(lol, (i, m) -> listToMatrix(cyclicGet(cellWidths, i), m));
    Matrix<Matrix<Integer>> mom = listToMatrix_cols(l(cellWidths), lom);
    List<Integer> cellX1s = partialSums_firstIs0(cellWidths);
    List<Integer> cellY1s = partialSums_firstIs0(cellHeights);
    int w = last(cellX1s), h = last(cellY1s);
    BufferedImage restored = newBufferedImage(w, h);
    forEachWithPosition(mom, (x, y, cell) -> drawIntMatrix(restored, cell, cyclicGet(cellX1s, x), cyclicGet(cellY1s, y)));
    return restored;
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public Producer<String> javaTokC_iterator(String s) {
    return new Producer<String>() {

      final public int l = strL(s);

      public int i = 0;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else if (c == '[' && d == '[') {
          do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
          j = Math.min(j + 2, l);
        } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
          do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
          j = Math.min(j + 3, l);
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public <A extends Component> A alwaysOnTop(A c) {
    return alwaysOnTop(c, true);
  }

  static public <A extends Component> A alwaysOnTop(A c, boolean on) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Window w = getWindow(c);
            if (w != null && w.isAlwaysOnTop() != on)
              w.setAlwaysOnTop(on);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Window w = getWindow(c);\r\n    if (w != null && w.isAlwaysOnTop() != on)\r\n    ...";
        }
      });
    }
    return c;
  }

  static public <A> A setFrameTitle(A c, final String title) {
    final Frame f = getAWTFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(title);";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A setFrameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public JFrame setFrameTitle(String title) {
    Object f = getOpt(mc(), "frame");
    if (f instanceof JFrame)
      return setFrameTitle((JFrame) f, title);
    return null;
  }

  static public boolean _inCore() {
    return false;
  }

  static public int getScreenWidth() {
    return getScreenSize().width;
  }

  static public Set<String> javaxVoidAliases_cache;

  static public Set<String> javaxVoidAliases() {
    if (javaxVoidAliases_cache == null)
      javaxVoidAliases_cache = javaxVoidAliases_load();
    return javaxVoidAliases_cache;
  }

  static public Set<String> javaxVoidAliases_load() {
    return litset("void", "svoid");
  }

  static public ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  static public Timestamp tsNow() {
    return new Timestamp();
  }

  static public Object makeDependent_postProcess;

  static public void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  static public Rectangle boundsOnScreen(Component c) {
    if (c == null)
      return null;
    if (c.getParent() instanceof JViewport && c.getParent().getParent() instanceof JScrollPane)
      c = c.getParent().getParent();
    try {
      return new Rectangle(c.getLocationOnScreen(), c.getSize());
    } catch (IllegalComponentStateException e) {
      return null;
    }
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, String in, ITokCondition condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, ITokCondition condition) {
    return jfind(tok, startIndex, in, (Object) condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public String formatFunctionCall(String fname, Object... args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Object... args) {
    return fname + "(" + joinWithComma(allToString(args)) + ")";
  }

  static public String formatFunctionCall(String fname, Iterable args) {
    return formatFunctionCall((Object) fname, args);
  }

  static public String formatFunctionCall(Object fname, Iterable args) {
    return formatFunctionCall(fname, toObjectArray(args));
  }

  static public void copyBufferedImage(BufferedImage src, int srcx, int srcy, BufferedImage dest, int destx, int desty, int w, int h) {
    copyImagePart(src, srcx, srcy, dest, destx, desty, w, h);
  }

  static public void copyBufferedImage(BufferedImage src, BufferedImage dest, int destx, int desty) {
    if (src != null)
      copyBufferedImage(src, 0, 0, dest, destx, desty, src.getWidth(), src.getHeight());
  }

  static public List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  static public Object dm_evalJava_veryQuickJava;

  static public Object dm_evalJava_withModule(String expression, Object... args) {
    Object m = dm_current_generic();
    String code = evalJava_prep(expression) + "\r\n    static new InheritableThreadLocal<WeakReference> dm_currentModule_value;\r\n    \r\n    sO dm_current_mandatory_generic_value;\r\n    \r\n    sO dm_current_mandatory_generic() { ret dm_current_mandatory_generic_value; }\r\n    sO dm_current_generic() { ret dm_current_mandatory_generic(); }\r\n  ";
    Object obj;
    if (dm_evalJava_veryQuickJava != null)
      obj = callF(dm_evalJava_veryQuickJava, code);
    else
      obj = veryQuickJava(code);
    setOpt(obj, "programID", programID());
    makeDependent(obj);
    setOpt(obj, "creator_class", newWeakReference(dm_os()));
    dm_pointSubmoduleToMe(obj, m);
    return evalJava_myProgramID_main_2(obj, args);
  }

  static public String localDateWithSeconds(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
    return format.format(time);
  }

  static public String localDateWithSeconds() {
    return localDateWithSeconds(now());
  }

  static public void dm_reload() {
    dm_reloadMe();
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, Iterable<B> l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(Object f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = (A) callF(f, a, b);
    return a;
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public ImageSurface doubleBufferedImageSurface() {
    ImageSurface is = imageSurface();
    setDoubleBuffered(is, true);
    return is;
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public String renderFunctionCall(String fname, Object... args) {
    return formatFunctionCall(fname, args);
  }

  static public <A extends JComponent> A addMargin(final int top, final int left, final int bottom, final int right, final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            Border margin = BorderFactory.createEmptyBorder(top, left, bottom, right);
            c.setBorder(jCompoundBorder(c.getBorder(), margin));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Border margin = BorderFactory.createEmptyBorder(top, left, bottom, right);\r\n ...";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A addMargin(int w, A c) {
    return addMargin(w, w, w, w, c);
  }

  static public <A> A dm_getOSOpt(String field) {
    return (A) getOpt(dm_os(), field);
  }

  static public double[] subDoubleArray(double[] b, int start) {
    return subDoubleArray(b, start, l(b));
  }

  static public double[] subDoubleArray(double[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new double[0];
    double[] x = new double[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean isJavaxCompilableSnippetTypeExceptInclude(int type) {
    return isJavaxApplicationSnippetType(type) || isJavaxModuleSnippetType(type) || type == snippetType_dynModule();
  }

  static public <A extends Component> A setFrameIcon(A c, String imageID) {
    setFrameIconLater(c, imageID);
    return c;
  }

  static public <A extends Component> A setFrameIcon(String imageID, A c) {
    return setFrameIcon(c, imageID);
  }

  static public JDesktopPane dm_desktopPane() {
    return dm_getOSOpt("desktop");
  }

  static public boolean isListOfElementType(Object o, Class type) {
    if (!(o instanceof List))
      return false;
    return allElementsAreOfType((List) o, type);
  }

  static public boolean isListOfElementType(Class type, Object o) {
    return isListOfElementType(o, type);
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public String getSnippetTitle(String id) {
    if (id == null)
      return null;
    if (!isSnippetID(id))
      return "?";
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getSnippetTitle(id);
    return getSnippetTitle_noResourceLoader(id);
  }

  static public String getSnippetTitle_noResourceLoader(String id) {
    try {
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public JPanel jFullCenter(final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          panel.add(c);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    panel.add(c);\r\n    ret panel;";
      }
    });
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(final DynModule module, final Class type, final F0<A> calc) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      final SimpleLiveValue value = new SimpleLiveValue(type, callF(calc));
      module.onChange(new Runnable() {

        public void run() {
          try {
            value.set(callF(calc));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "value.set(callF(calc))";
        }
      });
      return value;
    } finally {
      unlock(__0);
    }
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(Class type, F0<A> calc) {
    return dm_calculatedLiveValue(dm_current_mandatory(), type, calc);
  }

  static public <A> LiveValue<A> dm_calculatedLiveValue(Class<A> type, IF0<A> calc) {
    return dm_calculatedLiveValue(type, if0ToF0(calc));
  }

  static public LiveValue<Object> dm_calculatedLiveValue(IF0<?> calc) {
    return dm_calculatedLiveValue(Object.class, (F0) if0ToF0(calc));
  }

  static public MouseAdapter leftClickMouseAdapter_noPt(final Object r) {
    return new MouseAdapter() {

      public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1)
          pcallF(r);
      }
    };
  }

  static public List<String> getJavaModifiers_list = litlist("static", "abstract", "public", "private", "protected", "final", "native", "volatile", "synchronized", "transient", "default");

  static public List<String> getJavaModifiers() {
    return getJavaModifiers_list;
  }

  static public boolean dm_setFlag(String flagName) {
    return dm_setFlag(flagName, true);
  }

  static public boolean dm_setFlag(String flagName, boolean value) {
    Object mod = dm_current_generic();
    Object stem = dm_stem(mod);
    Integer flagCode = (Integer) (getOpt("flagName", stem));
    if (flagCode == null)
      return false;
    call(stem, value ? "setFlag" : "clearFlag", flagCode);
    return true;
  }

  static public <A, B> boolean isEitherB(Either<A, B> e) {
    return eitherIsB(e);
  }

  static public DynModule dm_currentModuleMandatory() {
    return dm_current_mandatory();
  }

  static public Object quickEval(String t) {
    if (isQuoted(t))
      return unquote(t);
    if (isInteger(t))
      return parseIntOrLong(t);
    if (isLongConstant(t))
      return parseLong(t);
    if (eq(t, "null"))
      return null;
    if (eq(t, "false"))
      return false;
    if (eq(t, "true"))
      return true;
    if (isIdentifier(t))
      return getMC(t);
    if (isSnippetID(t))
      return t;
    throw quickFail("Can't quick eval: " + t);
  }

  static public IAutoCloseableF0 tempMetaMutex(IMeta o) {
    return o == null ? null : o._tempMetaMutex();
  }

  static public JCheckBox dm_fieldCheckBox(String field) {
    return dm_fieldCheckBox(humanizeFormLabel(field), field);
  }

  static public JCheckBox dm_fieldCheckBox(String text, String field) {
    if (isIdentifier(text) && !isIdentifier(field)) {
      String temp = field;
      field = text;
      text = temp;
    }
    return jLiveValueCheckBox(text, dm_fieldLiveValue(field));
  }

  static public boolean hasLettersAllUpperCase(String s) {
    return hasLetters(s) && !containsLowerCase(s);
  }

  static public JTextArea jTextArea() {
    return jTextArea("");
  }

  static public JTextArea jTextArea(final String text) {
    return jTextAreaWithUndo(text);
  }

  static public List<String> classNamesInJarOrDir(File dir) {
    List<String> classes = new ArrayList();
    if (dir.isDirectory()) {
      for (File f : listFiles(dir)) {
        String s = f.getName();
        if (s.endsWith(".class"))
          classes.add(dropSuffix(".class", s));
      }
    } else if (dir.isFile()) {
      try {
        JarFile jarFile = new JarFile(dir);
        try {
          Enumeration<JarEntry> e = jarFile.entries();
          while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || je.getName().startsWith("META-INF/") || !je.getName().endsWith(".class"))
              continue;
            String className = dropSuffix(".class", je.getName());
            className = className.replace('/', '.');
            classes.add(className);
          }
        } finally {
          jarFile.close();
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
    return classes;
  }

  static public double toMinutes(long ms) {
    return ms / 60000.0;
  }

  static public void printShortenedFunctionCall(Object fname, Object... args) {
    printShortenedFunctionCall(100, fname, args);
  }

  static public void printShortenedFunctionCall(int len, Object fname, Object... args) {
    print(shorten(len, formatFunctionCall(fname, args)));
  }

  static public void dm_reloadMe() {
    dm_reloadModule(dm_currentModule());
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = f.get();
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF2();
  }

  static public JLabel dm_calculatedLabel(IF0<Object> calc) {
    return jLiveValueLabel(dm_calculatedLiveValue(Object.class, calc));
  }

  static public <A> void scanForComponents(final Component c, final Class<A> theClass, final List<A> l) {
    if (theClass.isInstance(c))
      l.add((A) c);
    if (c instanceof Container) {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component comp : ((Container) c).getComponents()) scanForComponents(comp, theClass, l);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component comp : ((Container) c).getComponents())\r\n      scanForComponen...";
        }
      });
    }
  }

  static public boolean scaffoldingEnabled(Object o) {
    return metaGet(o, "scaffolding") != null;
  }

  static public String defaultJavaXTranslatorID_value = "#759";

  static public String defaultJavaXTranslatorID() {
    return defaultJavaXTranslatorID_value;
  }

  static public List vmBus_queryAll(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    List out = new ArrayList();
    for (Object o : unnullForIteration(vm_busListeners_live())) addIfNotNull(out, pcallF(o, msg, arg));
    for (Object o : unnullForIteration(vm_busListenersByMessage_live().get(msg))) addIfNotNull(out, pcallF(o, msg, arg));
    return out;
  }

  static public List<String> hotwire_libraryIDsFromJar(File jar) {
    String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
    return regexpExtractAll("\\d+", dehlibs);
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + replace(unnull(s), "\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public boolean isAlwaysOnTop(JFrame f) {
    return f != null && swing(() -> f.isAlwaysOnTop());
  }

  static public boolean isAlwaysOnTop(Window w) {
    return w != null && swing(() -> w.isAlwaysOnTop());
  }

  static public <A> F0<A> f0_const(final A a) {
    return new F0<A>() {

      public A get() {
        try {
          return a;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret a;";
      }
    };
  }

  static public JWindow infoBox(String text) {
    return infoMessage(text);
  }

  static public JWindow infoBox(String text, double seconds) {
    return infoMessage(text, seconds);
  }

  static public JWindow infoBox(Throwable e) {
    return infoMessage(e);
  }

  static public double toSeconds(long ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(long ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toSeconds(double ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(double ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public Rect rect(int x, int y, int w, int h) {
    return new Rect(x, y, w, h);
  }

  static public Rect rect(Pt p, int w, int h) {
    return new Rect(p.x, p.y, w, h);
  }

  static public Rect rect(int w, int h) {
    return new Rect(0, 0, w, h);
  }

  static public <A> A navigableSet_find(NavigableSet<A> set, A a) {
    if (set == null || a == null)
      return null;
    A b = set.floor(a);
    return b != null && sortedSet_compare(set, a, b) == 0 ? b : null;
  }

  static public AutoCloseable tempCleaningUp() {
    AutoCloseable result = null;
    result = tempSetTL(ping_isCleanUpThread, true);
    return result;
  }

  static public boolean cleanUp_interruptThreads = false;

  static public void cleanUp(Object c) {
    if (c == null)
      return;
    if (c instanceof AutoCloseable) {
      close_pcall((AutoCloseable) c);
      return;
    }
    if (c instanceof java.util.Timer) {
      ((java.util.Timer) c).cancel();
      return;
    }
    if (c instanceof Collection) {
      cleanUp((Collection) c);
      return;
    }
    if (c instanceof Map) {
      for (Object o : keys((Map) c)) cleanUp(o);
      for (Object o : values((Map) c)) cleanUp(o);
      ((Map) c).clear();
      return;
    }
    try {
      preCleanUp(c);
      setOpt(c, "ping_pauseAll", false);
      innerCleanUp(c);
      List androids = (List) getOpt(c, "record_list");
      for (Object android : unnull(androids)) pcallOpt(android, "dispose");
      List<WeakReference> classes = (List<WeakReference>) (getOpt(c, "hotwire_classes"));
      if (classes != null)
        for (WeakReference cc : classes) {
          try {
            cleanUp(cc.get());
          } catch (Throwable __e) {
            printStackTrace(__e);
          }
        }
      if (cleanUp_interruptThreads) {
        List<Thread> threads = registeredThreads(c);
        if (nempty(threads)) {
          print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
          interruptThreads(threads);
        }
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    setOpt(c, "cleaningUp_flag", false);
    if (c instanceof Class && ((Class) c).getName().equals("main"))
      retireClassLoader(((Class) c).getClassLoader());
  }

  static public void cleanUp(Collection l) {
    if (l == null)
      return;
    for (Object c : l) cleanUp(c);
    l.clear();
  }

  static public Object dm_stem() {
    return dm_stem(dm_current_generic());
  }

  static public Object dm_stem(Object moduleOrID) {
    return dm_getStem(moduleOrID);
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        Class c = get2(name);
        return c;
      }

      public Class get2(String name) {
        if (eq(name, "<main>"))
          return mc();
        {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
        }
        if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
          for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
            String newName = pkg + afterDollar(name);
            {
              Class c = findClass_fullName(newName);
              if (c != null)
                return c;
            }
          }
        return null;
      }
    };
  }

  static public IterableIterator<Integer> countIterator_exclusive_step(final int a, final int b, final int step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Integer next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public IterableIterator<Double> countIterator_exclusive_step(double a, double b, double step) {
    assertTrue("step > 0", step > 0);
    return new IterableIterator<Double>() {

      public double i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Double next() {
        var j = i;
        i += step;
        return j;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_exclusive_step(double a, double b, double step, IF1<Double, A> f) {
    return mapI_if1(f, countIterator_exclusive_step(a, b, step));
  }

  static public <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  static public <A> void forEach(Iterable<A> l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public <A> void forEach(IVF1<A> f, Iterable<A> l) {
    forEach(l, f);
  }

  static public <A> void forEach(A[] l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public <A> void forEach(IVF1<A> f, A[] l) {
    forEach(l, f);
  }

  static public <A, B> void forEach(Map<A, B> map, IVF2<A, B> f) {
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A a = __0.getKey();
      B b = __0.getValue();
      f.get(a, b);
    }
  }

  static public boolean standardFunctionAlwaysReturnsVoid_uncached(String name) {
    return tok_staticFunctionAlwaysReturnsVoid(javaTok(textOfStandardFunction_uncached(name)), name);
  }

  static public int findEndOfBlock(List<String> tok, int i) {
    return tok_findEndOfBlock(tok, i);
  }

  static public void disposeWindow(final Window window) {
    if (window != null) {
      swing(new Runnable() {

        public void run() {
          try {
            window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING));
            myFrames_list.remove(window);
            window.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); //...";
        }
      });
    }
  }

  static public void disposeWindow(final Component c) {
    disposeWindow(getWindow(c));
  }

  static public void disposeWindow(Object o) {
    if (o != null)
      disposeWindow(((Component) o));
  }

  static public void disposeWindow() {
    disposeWindow(heldInstance(Component.class));
  }

  static public JTextField textFieldFromComboBox(JComboBox cb) {
    return (JTextField) cb.getEditor().getEditorComponent();
  }

  static public void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  static public void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  static public boolean isInRAMDisk(File f) {
    return startsWithOneOf(f2s(f), "/dev/shm/", "/run/shm/");
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public <A> float getScore(Scored<A> s) {
    return s == null ? 0 : s.score;
  }

  static public <A, B> String formatColonProperties_noNulls(Object... params) {
    return formatColonProperties(nonNullPairs(paramsToPairs(params)));
  }

  static public boolean containsNewLines(String s) {
    return containsNewLine(s);
  }

  static public int moveToTopRightCorner_inset = 20;

  static public <A extends Component> A moveToTopRightCorner(A a) {
    return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
  }

  static public <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Window w = getWindow(a);
            if (w != null)
              w.setLocation(getScreenSize().width - w.getWidth() - insetX, insetY);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Window w = getWindow(a);\r\n    if (w != null)\r\n      w.setLocation(getScreenSi...";
        }
      });
    }
    return a;
  }

  static public boolean objectArraysEqual(Object[] a, Object[] b) {
    return arraysEqual(a, b);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public JPanel centerAndEast(final Component c, final Component e) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.EAST, wrap(e));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public int preferredWidth(Component c) {
    return c == null ? 0 : getPreferredSize(c).width;
  }

  static public void metaMapPut(IMeta o, Object key, Object value) {
    {
      if (o != null)
        o.metaPut(key, value);
    }
  }

  static public String quoteBorderless(Object o) {
    if (o == null)
      return "null";
    return quoteBorderless(str(o));
  }

  static public String quoteBorderless(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5));
    quoteBorderless_impl(s, out);
    return out.toString();
  }

  static public void quoteBorderless_impl(String s, StringBuilder out) {
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else
        out.append(c);
    }
  }

  static public <A> boolean eqGetOneOf(List<A> l, int i, A... options) {
    return eqOneOf(get(l, i), options);
  }

  static public String makeFrame_defaultIcon;

  static public boolean makeFrame_hideConsole = false;

  static public ThreadLocal<VF1<JFrame>> makeFrame_post = new ThreadLocal();

  static public JFrame makeFrame() {
    return makeFrame((Component) null);
  }

  static public JFrame makeFrame(Object content) {
    return makeFrame(programTitle(), content);
  }

  static public JFrame makeFrame(String title) {
    return makeFrame(title, null);
  }

  static public JFrame makeFrame(String title, Object content) {
    return makeFrame(title, content, true);
  }

  static public JFrame makeFrame(final String title, final Object content, final boolean showIt) {
    final VF1<JFrame> post = optParam(makeFrame_post);
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          if (getFrame(content) != null)
            return getFrame(setFrameTitle((Component) content, title));
          final JFrame frame = new JFrame(title);
          if (makeFrame_defaultIcon != null)
            setFrameIconLater(frame, makeFrame_defaultIcon);
          _initFrame(frame);
          Component wrapped = wrap(content);
          if (wrapped != null)
            frame.getContentPane().add(wrapped);
          frame.setBounds(defaultNewFrameBounds());
          callF(post, frame);
          if (showIt)
            frame.setVisible(true);
          if (showIt && makeFrame_hideConsole) {
            hideConsole();
            makeFrame_hideConsole = false;
          }
          return frame;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ...";
      }
    });
  }

  static public <A> OKOrError<A> okOrError(IF0<A> f) {
    try {
      return OKOrError_ok(f.get());
    } catch (Throwable e) {
      printStackTrace(e);
      return OKOrError_error(e);
    }
  }

  static public <A> OKOrError<A> okOrError(Runnable r) {
    return okOrError(runnableToIF0(r));
  }

  static public <A extends JComponent> A setDoubleBuffered(A c, boolean b) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            {
              if (c != null)
                c.setDoubleBuffered(b);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c?.setDoubleBuffered(b);";
        }
      });
    }
    return c;
  }

  static public <A> List<A> asVirtualList(A[] a) {
    return wrapArrayAsList(a);
  }

  static public BufferedImage bufferedImage(int w, int h) {
    return newBufferedImage(w, h);
  }

  static public BufferedImage bufferedImage(int w, int h, RGB rgb) {
    return newBufferedImage(w, h, rgb);
  }

  static public BufferedImage bufferedImage(int w, Color color) {
    return bufferedImage(w, w, color);
  }

  static public BufferedImage bufferedImage(int w, int h, Color color) {
    return newBufferedImage(w, h, color);
  }

  static public BufferedImage bufferedImage(Pt p, Color color) {
    return newBufferedImage(p, color);
  }

  static public BufferedImage bufferedImage(int w, int h, int[] pixels) {
    return intArrayToBufferedImage(pixels, w, h);
  }

  static public String asciiHeading(String title) {
    return "\n" + title + "\n" + rep(l(title), '-');
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(A[] l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, A[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = f.get(l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, Collection<A> l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  static public int maximumSafeArraySize() {
    return Integer.MAX_VALUE - 8;
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public Q dm_q() {
    return dm_current_mandatory().q();
  }

  static public void dm_q(Runnable r) {
    dm_inQ(r);
  }

  static public void dm_q(DynModule module, Runnable r) {
    module.q().add(r);
  }

  static public <A> A dm_q(IF0<A> f) {
    return dm_evalInQ(if0ToF0(f));
  }

  static public AutoCloseable tempActivity(Object r) {
    return null;
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int withLeftAndRightMargin_defaultWidth = 6;

  static public JPanel withLeftAndRightMargin(Component c) {
    return withLeftAndRightMargin(withLeftAndRightMargin_defaultWidth, c);
  }

  static public JPanel withLeftAndRightMargin(int w, Component c) {
    return withLeftAndRightMargin(w, w, c);
  }

  static public JPanel withLeftAndRightMargin(final int w1, final int w2, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(0, w1, 0, w2));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(0,...";
      }
    });
  }

  static public void preCleanUp(Object c) {
    if (c instanceof Collection) {
      for (Object o : ((Collection) c)) preCleanUp(o);
      return;
    }
    callOpt(c, "licensed_off");
    setOpt(c, "ping_anyActions", true);
    setOpt(c, "cleaningUp_flag", true);
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public <A> A getAndClearTL(ThreadLocal<A> tl) {
    return getAndClearThreadLocal(tl);
  }

  static public String getClassDeclarationName(List<String> tok) {
    if (tok != null)
      for (int i = 1; i + 2 < tok.size(); i += 2) if (allClasses_keywords.contains(tok.get(i)) && isIdentifier(tok.get(i + 2))) {
        while (contains(getClassDeclarationName_skippables(), get(tok, i + 2))) i += 2;
        return tok.get(i + 2);
      }
    return null;
  }

  static public AutoCloseable dm_registerAs_directLink(String... msgs) {
    Object mod = dm_current_mandatory_generic();
    return combineAutoCloseables(map(msgs, msg -> dm_vmBus_answerToMessage(msg, fConst(mod))));
  }

  static public String addPrefixIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty(prefix, s);
  }

  static public FixedRateTimer dm_doEvery(long delay, Runnable r) {
    return dm_ownTimer(doEvery(delay, delay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(long delay, long firstDelay, Runnable r) {
    return dm_ownTimer(doEvery(delay, firstDelay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double initialSeconds, double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(initialSeconds, delaySeconds, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(delaySeconds, dm_rEnter(r)));
  }

  static public String platformQuoteOpt(String s) {
    return containsUnsafePlatformCmdLineChar(s) ? platformQuote(s) : s;
  }

  static public String platformQuoteOpt(File f) {
    return platformQuoteOpt(f2s(f));
  }

  static public List<List<Rect>> gridOfRects3(int w, int h, int cols, int rows) {
    return gridOfRects3(new Rect(0, 0, w, h), cols, rows);
  }

  static public List<List<Rect>> gridOfRects3(Rect r, int cols, int rows) {
    List<List<Rect>> l = new ArrayList();
    for (int row = 0; row < rows; row++) {
      List<Rect> line = new ArrayList();
      int y1 = r.y + iround(r.h * (double) row / rows);
      int y2 = r.y + iround(r.h * (double) (row + 1) / rows);
      for (int col = 0; col < cols; col++) {
        int x1 = r.x + iround(r.w * (double) col / cols);
        int x2 = r.x + iround(r.w * (double) (col + 1) / cols);
        line.add(new Rect(x1, y1, x2 - x1, y2 - y1));
      }
      l.add(line);
    }
    return l;
  }

  static public BufferedImage mergeBufferedImagesHorizontally(BufferedImage... images) {
    return mergeBufferedImagesHorizontally(toList(images));
  }

  static public BufferedImage mergeBufferedImagesHorizontally(List<BufferedImage> images, Object... __) {
    if (empty(images))
      return null;
    int spacing = optPar("spacing", __, imageMergeSpacing());
    RGB spaceColor = new RGB(0.9f);
    int w = intSum(mapMethod("getWidth", images)) + (l(images) - 1) * spacing, h = intMax(mapMethod("getHeight", images));
    BufferedImage out = newBufferedImage(w, h, spaceColor);
    int x = 0;
    for (int i = 0; i < l(images); i++) {
      BufferedImage img = images.get(i);
      int y = (h - img.getHeight()) / 2;
      copyBufferedImage(img, out, x, y);
      x += img.getWidth() + spacing;
    }
    return out;
  }

  static public <A> IterableIterator<A> enumerationToIterator(final Enumeration<A> e) {
    return e == null ? null : new IterableIterator() {

      public boolean hasNext() {
        return e.hasMoreElements();
      }

      public A next() {
        return e.nextElement();
      }
    };
  }

  static public boolean allPaused() {
    return ping_pauseAll;
  }

  static public List<Integer> partialSums_firstIs0(List<Integer> l) {
    int n = l(l);
    IntBuffer out = new IntBuffer(n);
    int sum = 0;
    for (int i = 0; i < n; i++) {
      out.add(sum);
      sum += l.get(i);
    }
    out.add(sum);
    return out.asVirtualList();
  }

  static public Object[] params_unpackList(Object[] params) {
    if (l(params) == 1 && params[0] instanceof List)
      return toObjectArray((List) params[0]);
    return params;
  }

  static public Object pcallOpt(Object o, String method, Object... args) {
    try {
      return callOpt(o, method, args);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> A childOfType(Component c, Class<A> theClass) {
    return first(childrenOfType(c, theClass));
  }

  static public <A> A childOfType(Class<A> theClass, Component c) {
    return childOfType(c, theClass);
  }

  static public boolean isMac() {
    return System.getProperty("os.name").toLowerCase().contains("mac");
  }

  static public JLabel dm_centeredCalculatedLabel(IF0<Object> calc) {
    return centerLabel(dm_calculatedLabel(calc));
  }

  static public String shortName(Object o) {
    return shortClassName(o);
  }

  static public void copyStreamAndCloseAll(InputStream in, OutputStream out) {
    try {
      try {
        copyStreamAndCloseInput(in, out);
      } finally {
        out.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean md5OfFile_verbose = false;

  static public String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  static public String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel hgrid(final Object... parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel();
          Object[] _parts = flattenArray2(parts);
          panel.setLayout(new GridLayout(1, _parts.length));
          smartAdd(panel, _parts);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JPanel panel;\r\n    O[] _parts = flattenArray2(parts);\r\n    panel.setLayou...";
      }
    });
  }

  static public List<String> ai_splitCamelCase(String s) {
    int j = 0;
    List<String> l = new ArrayList();
    if (isAllUpperCase(s)) {
      l.add(s);
      return l;
    }
    for (int i = 0; i < l(s); i++) if (i > j && isUpperCaseLetter(s.charAt(i))) {
      l.add(substring(s, j, i));
      j = i;
    }
    if (j < l(s))
      l.add(substring(s, j));
    return l;
  }

  static public boolean containsLowerCase(String s) {
    for (int i = 0; i < l(s); i++) if (isLowerCase(s.charAt(i)))
      return true;
    return false;
  }

  static public String findTranslators2(String src, List<String> libsOut) {
    return join(findTranslators2(javaTok(src), libsOut));
  }

  static public List<String> findTranslators2(List<String> tok, List<String> libsOut) {
    int i;
    while ((i = jfind(tok, "!<int>")) >= 0) {
      setAdd(libsOut, tok.get(i + 2));
      clearTokens(tok, i, i + 3);
    }
    return tok;
  }

  static public Class getFieldType(Object o, String field) {
    return fieldType(o, field);
  }

  static public BufferedImage screenshot() {
    return shootScreen2();
  }

  static public BufferedImage screenshot(Rectangle area) {
    try {
      return shootScreen2(area);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage screenshot(Rect area) {
    return shootScreen2(area);
  }

  static public BufferedImage screenshot(int x, int y, int w, int h) {
    return shootScreen2(x, y, w, h);
  }

  static public String decimalFormatEnglish(String format, double d) {
    return decimalFormatEnglish(format).format(d);
  }

  static public java.text.DecimalFormat decimalFormatEnglish(String format) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
  }

  static public DynModule dm_current() {
    return dm_currentModule();
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public boolean ping_v3() {
    return ping_v3(pingSource());
  }

  static public boolean ping_v3(PingSource source) {
    {
      if (source != null)
        source.get();
    }
    return true;
  }

  static public File standardLogFile() {
    return getProgramFile("log");
  }

  static public IterableIterator emptyIterableIterator_instance = new IterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> IterableIterator<A> emptyIterableIterator() {
    return emptyIterableIterator_instance;
  }

  static public Object toJavaOpt(Object o) {
    return new ToJava().getOpt(o);
  }

  static public List<String> findBlock(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    int i = findCodeTokens(tok, toStringArray(codeTokensOnly(tokpat)));
    if (i < 0)
      return null;
    int bracketIdx = i + tokpat.size() - 3;
    assertEquals("{", tok.get(bracketIdx));
    int endIdx = findEndOfBlock(tok, bracketIdx);
    return subList(tok, i - 1, endIdx + 1);
  }

  static public JWindow showLoadingAnimation() {
    return showLoadingAnimation("Hold on user...");
  }

  static public JWindow showLoadingAnimation(String text) {
    try {
      return showAnimationInTopRightCorner("#1003543", text);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> List<List<B>> mapLevelTwo(IF1<A, B> f, Iterable<List<A>> l) {
    return mapTwoLevelsDown(f, l);
  }

  static public int[] hexToInts_dropSpaces(String s) {
    return hexToInts(dropSpaceEtc(s));
  }

  static public Object[] flattenArray2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Object[])
        l.addAll(asList((Object[]) x));
      else if (x instanceof Collection)
        l.addAll((Collection) x);
      else
        l.add(x);
    return asObjectArray(l);
  }

  static public ThreadLocal<Boolean> evalJava_prep_voidMagic = new ThreadLocal();

  static public List<String> evalJava_prePrep(String code) {
    return evalJava_prePrep(code, new EvalJavaPrep());
  }

  static public List<String> evalJava_prePrep(String code, EvalJavaPrep prep) {
    List<String> tok = javaTok(trim(code));
    int idx;
    while ((idx = jfind(tok, "global {")) >= 0) {
      int j = findEndOfBracketPart(tok, idx + 2);
      prep.global.add(joinSubList(tok, idx + 3, j - 1));
      clearTokens_reTok(tok, idx, j + 1);
    }
    if (eqGet(tok, 1, "="))
      tok = subList(tok, 2);
    if (tok_isStaticLevelCode(tok))
      return tok;
    if (!isFalse(evalJava_prep_voidMagic.get()) && tok_shouldAddReturn(tok) && eqGet(tok, 3, "(") && isIdentifier(get(tok, 1)) && isKnownVoidFunction_uncached(get(tok, 1)))
      tokAppend_reTok(tok, l(tok) - 2, ";");
    String name = null;
    if (l(tok) == 3 && isIdentifier(name = firstToken(tok)))
      tokAppend_reTok(tok, 1, "()" + (isKnownVoidFunction_uncached(name) ? ";" : ""));
    return tok;
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String formatDouble(double d) {
    return str(d);
  }

  static public String formatDouble(DoubleRange r, int digits) {
    return r == null ? "null" : "[" + formatDouble(r.start, digits) + ";" + formatDouble(r.end, digits) + "]";
  }

  static public Container getParent(final Component c) {
    return c == null ? null : swing(new F0<Container>() {

      public Container get() {
        try {
          return c.getParent();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getParent();";
      }
    });
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public boolean dir2zip_recurse_verbose = false;

  static public int dir2zip_recurse(File inDir, File zip) {
    return dir2zip_recurse(inDir, zip, "");
  }

  static public int dir2zip_recurse(File inDir, File zip, String outPrefix) {
    try {
      mkdirsForFile(zip);
      FileOutputStream fout = newFileOutputStream(zip);
      ZipOutputStream outZip = new ZipOutputStream(fout);
      try {
        return dir2zip_recurse(inDir, outZip, outPrefix, 0);
      } finally {
        outZip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip) {
    return dir2zip_recurse(inDir, outZip, "", 0);
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) {
    try {
      if (++level >= 20)
        throw fail("woot? 20 levels in zip?");
      List<File> files = new ArrayList();
      for (File f : listFiles(inDir)) files.add(f);
      int n = 0;
      sortFilesByName(files);
      for (File f : files) {
        if (f.isDirectory()) {
          if (dir2zip_recurse_verbose)
            print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
          n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
        } else {
          if (dir2zip_recurse_verbose)
            print("Copying " + f.getName());
          outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
          InputStream fin = new FileInputStream(f);
          copyStream(fin, outZip);
          fin.close();
          ++n;
        }
      }
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

  static public Rectangle defaultNewFrameBounds() {
    return swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          defaultNewFrameBounds_r.translate(60, 20);
          if (!screenRectangle().contains(defaultNewFrameBounds_r))
            defaultNewFrameBounds_r.setLocation(30 + random(30), 20 + random(20));
          return new Rectangle(defaultNewFrameBounds_r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "defaultNewFrameBounds_r.translate(60, 20);\r\n    if (!screenRectangle().contai...";
      }
    });
  }

  static public byte[] hexToBytes_dropSpaces(String s) {
    return hexToBytes(dropSpaceEtc(s));
  }

  static public String pqO(String s) {
    return platformQuoteOpt(s);
  }

  static public String pqO(File f) {
    return platformQuoteOpt(f);
  }

  static public class jLiveValueSection_class extends SingleComponentPanel {

    public LiveValue<?> liveValue;

    public String getTitle() {
      return strOrEmpty(liveValue.get());
    }

    public jLiveValueSection_class(LiveValue<?> lv, Component c) {
      super(c);
      bindLiveValueListenerToComponent(this, liveValue = lv, new Runnable() {

        public void run() {
          try {
            swingLater(new Runnable() {

              public void run() {
                try {
                  setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), getTitle()));
                  revalidate();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "setBorder(BorderFactory.createTitledBorder(\r\n        BorderFactory.createBeve...";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "swingLater(r {\r\n      setBorder(BorderFactory.createTitledBorder(\r\n        Bo...";
        }
      });
    }
  }

  static public JPanel jLiveValueSection(LiveValue<?> lv, Component c) {
    return swingNu(jLiveValueSection_class.class, lv, c);
  }

  static public Producer<String> javaTokC_producer(String s) {
    return javaTokC_iterator(s);
  }

  static public <A> OKOrError<A> OKOrError_ok(A a) {
    return new OKOrError(a);
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public String toStringWithClassName(Object o) {
    return toStringWithClass(o);
  }

  static public File linux_fileInRamDisk(String name) {
    if (!isLinux())
      return null;
    File dir = newFile("/dev/shm");
    if (dir.isDirectory())
      return newFile(dir, name);
    return null;
  }

  static public ICachedJavaXExpr javaExpr(Object expr) {
    if (expr instanceof ICachedJavaXExpr)
      return ((ICachedJavaXExpr) expr);
    return new LiteralJavaXExpr(expr);
  }

  static public <A> ICachedJavaXExpr<A> javaExpr(Object expr, IF0<A> quickEval) {
    LiteralJavaXExpr<A> e = new LiteralJavaXExpr<>(expr);
    e.quickEval = quickEval;
    return e;
  }

  static public String shorten_str(Object o) {
    return shorten(str(o));
  }

  static public String shorten_str(Object o, int max) {
    return shorten(str(o), max);
  }

  static public String shorten_str(int max, Object o) {
    return shorten_str(o, max);
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource) {
    return hotwire_finish(classLoader, progID, javaSource, "main");
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource, String mainClass) {
    try {
      Class<?> theClass = classLoader.loadClass(mainClass);
      Class j = getJavaX();
      setOpt(theClass, "myJavaSource_code", javaSource);
      synchronized (j) {
        call(j, "setVars", theClass, progID);
        callOpt(j, "addInstance", progID, theClass);
      }
      hotwire_copyOver(theClass);
      vmBus_send("hotwireFinished", theClass, mc());
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pt topLeftCorner(Rect r) {
    return rectTopLeftCorner(r);
  }

  static public String platformQuote(String s) {
    return isWindows() ? winQuote(s) : bashQuote(s);
  }

  static public String platformQuote(File f) {
    return platformQuote(f2s(f));
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public HashSet<String> allClasses_keywords = lithashset("class", "interface", "enum", "sclass", "sinterface", "record", "srecord", "strecord", "asclass", "concept");

  static public List<List<String>> allClasses(List<String> tok) {
    List<List<String>> l = new ArrayList();
    int n = tok.size();
    HashSet<String> _allClasses_keywords = allClasses_keywords;
    for (int i = 1; i < n; i += 2) {
      String t = tok.get(i);
      if ("{".equals(t))
        i = findEndOfBlock(tok, i) - 1;
      else if (_allClasses_keywords.contains(t) && (tok_isJavaxMetaCommandLeftOf(tok, i) || !(eqGetOneOf(tok, i - 2, ".", "include") && !containsNewLine(tok.get(i - 1))))) {
        int j = i;
        while (j < n && !tok.get(j).equals("{")) j += 2;
        j = findEndOfBlock(tok, j) + 1;
        i = leftScanModifiers(tok, i);
        l.add(subList(tok, i - 1, Math.min(n, j)));
        i = j - 2;
      }
    }
    return l;
  }

  static public List<List<String>> allClasses(String text) {
    return allClasses(javaTok(text));
  }

  static public String getServerTranspiled(String snippetID) {
    return getServerTranspiled(snippetID, null);
  }

  static public boolean getServerTranspiled_printStackTrace = false;

  static public String getServerTranspiled(String snippetID, String expectedMD5) {
    try {
      if (getServerTranspiled_printStackTrace)
        printStackTrace();
      long id = parseSnippetID(snippetID);
      String text = loadPage_utf8(tb_mainServer() + "/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1" + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "") + standardCredentials());
      if (nempty(text) && neq(text, "SAME"))
        saveTranspiledCode(snippetID, text);
      return text;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> List<Pair<A, B>> nonNullPairs(Iterable<Pair<A, B>> l) {
    return filter(l, p -> p != null && p.a != null && p.b != null);
  }

  static public Boolean grabbableGrayPixels_succeeded;

  static public Throwable grabbableGrayPixels_error;

  static public boolean grabbableGrayPixels_enable = true;

  static public GrabbableGrayPixels grabbableGrayPixels(BufferedImage img) {
    if (img == null || !grabbableGrayPixels_enable)
      return null;
    try {
      var result = grabbableGrayPixels_impl(img);
      grabbableGrayPixels_succeeded = result != null;
      return result;
    } catch (Throwable e) {
      grabbableGrayPixels_error = e;
      grabbableGrayPixels_succeeded = false;
      throw rethrow(e);
    }
  }

  static public GrabbableGrayPixels grabbableGrayPixels_impl(BufferedImage img) {
    Raster raster = img.getRaster();
    SampleModel sampleModel = raster.getSampleModel();
    if (!(sampleModel instanceof PixelInterleavedSampleModel))
      return null;
    DataBufferByte dataBuffer = (DataBufferByte) (raster.getDataBuffer());
    assertEquals(1, dataBuffer.getNumBanks());
    assertEquals(DataBuffer.TYPE_BYTE, dataBuffer.getDataType());
    int w = img.getWidth(), h = img.getHeight();
    int scanlineStride = ((PixelInterleavedSampleModel) sampleModel).getScanlineStride();
    byte[] pixels = dataBuffer.getData();
    int offset = dataBuffer.getOffset();
    int translateX = raster.getSampleModelTranslateX();
    int translateY = raster.getSampleModelTranslateY();
    offset += -translateX - translateY * scanlineStride;
    return new GrabbableGrayPixels(pixels, w, h, offset, scanlineStride);
  }

  static public <A> List<WithSideValue<Integer, A>> indexAsSideValue(List<A> l) {
    List<WithSideValue<Integer, A>> out = emptyList(l);
    int n = l(l);
    for (int i = 0; i < n; i++) out.add(withSideValue(i, l.get(i)));
    return out;
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public Set<String> findFullFunctionDefs_keywords = new HashSet(splitAtSpace("static svoid ssvoid ssynchronized sbool sS sO sL"));

  static public List<List<String>> findFullFunctionDefs(List<String> tok, boolean topLevelOnly) {
    int n = l(tok);
    List<List<String>> functions = new ArrayList();
    for (int i = 1; i < n; i += 2) {
      String t = tok.get(i);
      if (topLevelOnly && eq(t, "{"))
        i = findEndOfBlock(tok, i) - 1;
      else if (findFullFunctionDefs_keywords.contains(t)) {
        int j = i + 2;
        while (j < n && !eqOneOf(tok.get(j), ";", "=", "(", "{")) j += 2;
        if ((eqGet(tok, j, "(") || eq(t, "svoid") && eqGet(tok, j, "{")) && isIdentifier(tok.get(j - 2)) && !contains(subList(tok, i, j), "new")) {
          int k = smartIndexOf(tok, "{", j);
          if (k < l(tok)) {
            k = findEndOfBlock(tok, k) + 1;
            functions.add(subList(tok, i - 1, k));
            i = k - 2;
          }
        }
      }
    }
    return functions;
  }

  static public List<List<String>> findFullFunctionDefs(String s, boolean topLevelOnly) {
    return findFullFunctionDefs(javaTok(s), topLevelOnly);
  }

  static public File makeFileNameUnique_withExtension(File f, String ext) {
    File orig = f;
    int n = 0;
    ext = addPrefixIfNempty(".", dropPrefix(".", ext));
    String name = dropSuffixIC(ext, orig.getName());
    f = new File(dirOfFile(orig), name + ext);
    while (f.exists()) f = new File(dirOfFile(orig), name + "." + (++n) + ext);
    return f;
  }

  static public boolean has(String a, String b, String c) {
    return false;
  }

  static public boolean has(T3<String, String, String> t) {
    return false;
  }

  static public OKOrError OKOrError_error(Throwable e) {
    return new OKOrError(false, e);
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last((List) l);
    if (l instanceof SortedSet)
      return (A) last((SortedSet) l);
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public <A> A last(ReverseChain<A> l) {
    return l == null ? null : l.element;
  }

  static public int last(IntBuffer buf) {
    return buf.get(buf.size() - 1);
  }

  static public <A> A last(CompactLinkedHashSet<A> set) {
    return set == null ? null : set.last();
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public String intsToHex(List<Integer> l) {
    if (l == null)
      return null;
    return bytesToHex(intListToByteArray(l));
  }

  static public int intSum(Collection c, String field) {
    int sum = 0;
    for (Object o : unnull(c)) sum += toInt(getOpt(o, field));
    return sum;
  }

  static public int intSum(Iterable<Integer> l) {
    int sum = 0;
    for (Integer i : unnull(l)) if (i != null)
      sum += i;
    return sum;
  }

  static public int intSum(int[] l) {
    int sum = 0;
    for (int i : unnull(l)) sum += i;
    return sum;
  }

  static public String formatDouble_noLeadingZero(double d, int digits) {
    String s = formatDouble(d, digits);
    if (startsWith(s, "-"))
      return startsWith(s, "-0.") ? "-." + dropFirst(3, s) : s;
    else
      return startsWith(s, "0.") ? dropFirst(s) : s;
  }

  static public byte[] takeFirstOfByteArray(byte[] b, int n) {
    return subByteArray(b, 0, n);
  }

  static public byte[] takeFirstOfByteArray(int n, byte[] b) {
    return takeFirstOfByteArray(b, n);
  }

  static public List<File> filesWithExtension(String ext, List<File> files) {
    return filesEndingWith(files, addPrefixIfNotEmpty2(".", ext));
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, A... keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, Iterable<A> keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public boolean dm_moduleIsPoppedOut() {
    return dm_moduleIsPoppedOut(dm_current_mandatory_generic());
  }

  static public boolean dm_moduleIsPoppedOut(Object mod) {
    return isTrue(dm_callOSOpt("stefansOS_moduleIsPoppedOut", dm_getStem(mod)));
  }

  static public File actualUserDir() {
    return new File(actualUserHome());
  }

  static public File actualUserDir(String path) {
    return new File(actualUserHome(), path);
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public double distance(double ax, double ay, double bx, double by) {
    return sqrt(sqr(bx - ax) + sqr(by - ay));
  }

  static public int distance(int a, int b) {
    return abs(a - b);
  }

  static public JPanel jrightAlignedLine(final Component... components) {
    return swing(new F0<RightAlignedLine>() {

      public RightAlignedLine get() {
        try {
          return new RightAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret RightAlignedLine(components);";
      }
    });
  }

  static public JPanel jrightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(asArray(Component.class, components));
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(DoubleRect r) {
    if (r == null)
      return null;
    int x = iround(r.x), y = iround(r.y);
    return new Rect(x, y, iround(r.x2()) - x, iround(r.y2()) - y);
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public <A> Set<A> synchroSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchroSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public String formatDouble_significant2(double d, int digits) {
    try {
      digits -= max(0, Math.floor(Math.log10(abs(d)) + 1));
      return formatDouble(d, digits);
    } catch (Throwable _e) {
      print("Had number: " + d + ", digits: " + digits);
      throw rethrow(_e);
    }
  }

  static public Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  static public void assertPointInBounds(int x, int y, int w, int h) {
    if (x < 0)
      throw fail("x < 0", x);
    if (y < 0)
      throw fail("y < 0", y);
    if (x >= w)
      throw fail("x >= w", x, w);
    if (y >= h)
      throw fail("y >= h", y, h);
  }

  static public boolean isJavaxCompilableSnippetType(int type) {
    return isJavaxCompilableSnippetTypeExceptInclude(type) || type == javaxIncludeSnippetType();
  }

  static public void installWindowDragger(JComponent c) {
    onMouseDown(c, event -> new WindowDragger(event));
  }

  static public <A extends JComponent> A onLeftClick(final A c, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(leftClickMouseAdapter(runnable));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(leftClickMouseAdapter(runnable));";
        }
      });
    }
    return c;
  }

  static public TrayIcon onLeftClick(final TrayIcon c, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(leftClickMouseAdapter_noPt(runnable));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(leftClickMouseAdapter_noPt(runnable));";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A onLeftClick(final Object runnable, A c) {
    return onLeftClick(c, runnable);
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  static public class SmartTimerTask extends TimerTask implements IFieldsToList {

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { r, timer, delay, threadInfo };
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __1 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__1);
        }
      }
    }
  }

  static public boolean isString(Object o) {
    return o instanceof String;
  }

  static public Timer installTimer(JComponent component, Object r, long delay) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, Object r) {
    return installTimer(frame.getRootPane(), r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, Object r) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, long firstDelay, Object r) {
    return installTimer(component, r, delay, firstDelay);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay) {
    return installTimer(component, r, delay, firstDelay, true);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay, final boolean repeats) {
    if (component == null)
      return null;
    return (Timer) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          final Var<Timer> timer = new Var();
          timer.set(new Timer(toInt(delay), new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent _evt) {
              try {
                AutoCloseable __1 = tempActivity(r);
                try {
                  try {
                    if (!allPaused())
                      if (isFalse(callF(r)))
                        cancelTimer(timer.get());
                  } catch (Throwable __e) {
                    printStackTrace(__e);
                  }
                } finally {
                  _close(__1);
                }
              } catch (Throwable __e) {
                messageBox(__e);
              }
            }
          }));
          timer.get().setInitialDelay(toInt(firstDelay));
          timer.get().setRepeats(repeats);
          bindTimerToComponent(timer.get(), component);
          return timer.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<Timer> timer;\r\n    timer.set(new Timer(toInt(delay), actionList...";
      }
    });
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    return installTimer(frame.getRootPane(), delay, firstDelay, r);
  }

  static public <A> boolean setAdd(Collection<A> c, A a) {
    if (c == null || c.contains(a))
      return false;
    c.add(a);
    return true;
  }

  static public <Data> JECompressionSearch<Data> jeCompressionSearch(Data data, long inputSize) {
    return new JECompressionSearch<Data>(data, inputSize);
  }

  static public <A, B> void syncMapPutOrRemove(Map<A, B> map, A key, B value) {
    syncMapPut2(map, key, value);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rectangle clip) {
    return clipBufferedImage(src, new Rect(clip));
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rect r) {
    if (src == null || r == null)
      return null;
    r = intersectRects(r, new Rect(0, 0, src.getWidth(), src.getHeight()));
    if (rectEmpty(r))
      return null;
    return src.getSubimage(r.x, r.y, r.w, r.h);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, int x, int y, int w, int h) {
    return clipBufferedImage(src, new Rect(x, y, w, h));
  }

  static public AutoCloseable temp_loadPage_silent() {
    return tempSetThreadLocal(loadPage_silent, true);
  }

  static public List<Integer> lInts(String hex) {
    return byteArrayToIntList_littleEndian(hexToBytes_dropSpaces(hex));
  }

  static public boolean veryQuickJava_silent = true;

  static public boolean veryQuickJava_useCompilerBot = true;

  static public ThreadLocal<String> veryQuickJava_transpiled = new ThreadLocal();

  static public Object veryQuickJava3_cacheFunction;

  static public ThreadLocal<IVF1<String>> veryQuickJava_onJavaSource = new ThreadLocal();

  static public Class veryQuickJava3(String mainJava) {
    return veryQuickJava3(mainJava, emptyList());
  }

  static public Class veryQuickJava3(String mainJava, List<String> libs) {
    Class c = (Class) (callF(veryQuickJava3_cacheFunction, mainJava, libs));
    if (c != null)
      return c;
    transpileRaw_silent = veryQuickJava_silent;
    String src = transpileRaw(mainJava);
    if (empty(src)) {
      printWithIndent("JAVAX> ", mainJava);
      throw fail("Transpiler returned empty result");
    }
    if (veryQuickJava_transpiled.get() != null)
      veryQuickJava_transpiled.set(src);
    callF(veryQuickJava_onJavaSource.get(), src);
    return veryQuickJava_finish(src, libs);
  }

  static public Border jCompoundBorder(Border inner, Border outer) {
    if (inner == null)
      return outer;
    if (outer == null)
      return inner;
    return BorderFactory.createCompoundBorder(inner, outer);
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public void dm_reloadModule(Object module) {
    dm_reloadModuleInBackground(module);
  }

  static public void dm_reloadModule() {
    dm_reloadModuleInBackground();
  }

  static public List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  static public List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  static public ThreadLocal<Boolean> htmlencode_forParams_useV2 = new ThreadLocal();

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    if (isTrue(htmlencode_forParams_useV2.get()))
      return htmlencode_forParams_v2(s);
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String formatDouble1(double d) {
    return formatDouble(d, 1);
  }

  static public <A> void methodForEach(IVF1<A> f, Iterable<A> l) {
    forEach(f, l);
  }

  static public <A> void methodForEach(IVF1<A> f, A[] l) {
    forEach(f, l);
  }

  static public File tempDir() {
    return makeTempDir();
  }

  static public JPanel centerAndNorth(final Component c, final Component n) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.NORTH, wrap(n));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public boolean setText_opt = true;

  static public <A extends JTextComponent> A setText(A c, Object text) {
    setText((JComponent) c, text);
    return c;
  }

  static public <A extends JComboBox> A setText(final A c, Object text) {
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.getEditor().setItem(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.getEditor().setItem(s);";
        }
      });
    }
    return c;
  }

  static public void setText(JLabel c, Object text) {
    setText((JComponent) c, text);
  }

  static public JButton setText(JButton c, Object text) {
    setText((JComponent) c, jlabel_textAsHTML_center_ifNeeded(strUnnull(text)));
    return c;
  }

  static public <A extends JComponent> A setText(final A c, Object text) {
    if (c == null)
      return null;
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (!setText_opt || neq(callOpt(c, "getText"), s))
              call(c, "setText", s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!setText_opt || neq(callOpt(c, \"getText\"), s))\r\n      call(c, \"setText\", s);";
        }
      });
    }
    return c;
  }

  static public String intToHex(int i) {
    return bytesToHex(intToBytes(i));
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public String jlabel_textAsHTML_center(String text) {
    return "<html><div style=\"text-align: center;\">" + replace(htmlencode2(text), "\n", "<br>") + "</div></html>";
  }

  static public int findBeginningOfBlock(List<String> cnc, int i) {
    int j = i - 2, level = 1;
    while (j > 0) {
      if (eq(cnc.get(j), "}"))
        ++level;
      else if (eq(cnc.get(j), "{"))
        --level;
      if (level == 0)
        return j;
      j -= 2;
    }
    return -1;
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public TreeSet<Symbol> litciset(Symbol... items) {
    TreeSet<Symbol> set = treeSet();
    for (Symbol a : items) set.add(a);
    return set;
  }

  static public JButton findButton(Component c, String name) {
    for (JButton b : childrenOfType(c, JButton.class)) if (eq(b.getText(), name))
      return b;
    for (JButton b : childrenOfType(getFrame(c), JButton.class)) if (eq(b.getText(), name))
      return b;
    return null;
  }

  static public JButton findButton(Component c) {
    return childOfType(c, JButton.class);
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public File getCanonicalFile(File f) {
    try {
      return f == null ? null : f.getCanonicalFile();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public Number parseIntOrLong(String s) {
    long l = parseLong(s);
    return longIsInt(l) ? (Number) (int) l : (Number) l;
  }

  static public MouseAdapter leftClickMouseAdapter(final Object r) {
    return new MouseAdapter() {

      public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1)
          callF(r, new Pt(e.getPoint()));
      }
    };
  }

  static public String toJava(Object o) {
    return str(new ToJava().get(o));
  }

  static public Rectangle getBounds(final Component c) {
    return c == null ? null : swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          return c.getBounds();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getBounds();";
      }
    });
  }

  static public JPanel northAndCenterWithMargin(int margin, Component n, Component c) {
    return northAndCenter(withBottomMargin(margin, n), c);
  }

  static public JPanel northAndCenterWithMargin(Component n, Component c) {
    return northAndCenter(withBottomMargin(n), c);
  }

  static public <A> A printIndent(A o) {
    print(indentx(str(o)));
    return o;
  }

  static public <A> A printIndent(String indent, A o) {
    print(indentx(indent, str(o)));
    return o;
  }

  static public void printIndent(int indent, Object o) {
    print(indentx(indent, str(o)));
  }

  static public <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  static public String loadTextFileResource(ClassLoader cl, String name) {
    return inputStreamToString(cl.getResourceAsStream(name));
  }

  static public int leftScanModifiers(List<String> tok, int i) {
    List<String> mod = getJavaModifiers();
    while (i > 1 && mod.contains(tok.get(i - 2))) i -= 2;
    return i;
  }

  static public String renderUserThreadsWithStackTraces() {
    return renderUserThreadsWithStackTraces(Thread.getAllStackTraces());
  }

  static public String renderUserThreadsWithStackTraces(Map<Thread, StackTraceElement[]> threadMap) {
    return renderUserThreadsWithStackTraces(threadMap, "user thread");
  }

  static public String renderUserThreadsWithStackTraces(Map<Thread, StackTraceElement[]> threadMap, String threadDescription) {
    StringBuilder buf = new StringBuilder();
    int n = 0;
    for (Thread t : threadMap.keySet()) {
      ThreadGroup g = t.getThreadGroup();
      if (g != null && g.getName().equals("system"))
        continue;
      ++n;
      printTo(buf, t);
      for (StackTraceElement e : threadMap.get(t)) {
        printTo(buf, "  " + e);
      }
      printTo(buf);
    }
    printTo(buf, n(n, threadDescription) + ".");
    return asciiHeading2(n(n, threadDescription) + " (+" + (l(threadMap) - n) + ")") + "\n" + buf;
  }

  static public String nBytes(long n) {
    return n2(n, "byte");
  }

  static public String nBytes(Collection l) {
    return nBytes(l(l));
  }

  static public String nBytes(byte[] l) {
    return nBytes(l(l));
  }

  static public String loadTextFilePossiblyGZipped(String fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
    File gz = new File(fileName + ".gz");
    return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
  }

  static public String loadTextFilePossiblyGZipped(File fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
    return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
  }

  static public Concepts newConceptsWithClassFinder(String progID) {
    Concepts cc = new Concepts(progID);
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public float getSwingFontScale() {
    return or((Float) vm_generalMap_get("swingFontScale_value"), 1f);
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static public int snippetType_javaxDesktopModule() {
    return 58;
  }

  static public boolean substanceLookAndFeelEnabled() {
    return startsWith(getLookAndFeel(), "org.pushingpixels.");
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public String selectedItem(JList l) {
    return getSelectedItem(l);
  }

  static public String selectedItem(JComboBox cb) {
    return getSelectedItem(cb);
  }

  static public List<String> codeTokensOnly(List<String> tok) {
    int n = l(tok);
    List<String> l = emptyList(n / 2);
    for (int i = 1; i < n; i += 2) l.add(tok.get(i));
    return l;
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public int[] matrixToIntArray(Matrix<Integer> m) {
    int w = m.getWidth(), h = m.getHeight(), n = w * h;
    int[] a = new int[n];
    int i = 0;
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) a[i++] = m.get(x, y);
    return a;
  }

  static public void printTo(StringBuilder buf, Object o) {
    buf.append(str(o)).append("\n");
  }

  static public void printTo(StringBuilder buf) {
    printTo(buf, "");
  }

  static public File appendToFileNameBeforeExtension(File f, String s) {
    String ext = fileExtension(f);
    String name = dropSuffixIC(ext, f.getName());
    name += s;
    return newFile(parentFile(f), name + ext);
  }

  static public F1 functionToF1(final Object f) {
    if (isString(f))
      return mainFunctionToF1((String) f);
    if (f instanceof F1)
      return (F1) f;
    return new F1<Object, Object>() {

      public Object get(Object a) {
        try {
          return callF(f, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret callF(f, a);";
      }
    };
  }

  static public boolean isSpaceEtc(char c) {
    return c == ' ' || c == '\t' || c == '\r' || c == '\n';
  }

  static public long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  static public JWindow loadingAnim() {
    return showLoadingAnimation();
  }

  static public JWindow loadingAnim(String text) {
    return showLoadingAnimation(text);
  }

  static public void saveGZTextFile(File file, String contents) {
    saveGZTextFile(file, contents, "UTF-8");
  }

  static public void saveGZTextFile(File file, String contents, String encoding) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = file.getPath() + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, encoding);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Frame getAWTFrame(final Object _o) {
    return swing(new F0<Frame>() {

      public Frame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof Frame)
              return (Frame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ...";
      }
    });
  }

  static public BufferedImage defaultScreenshot() {
    if (hasGlobalOption("canDefaultScreenshot"))
      return shootScreen2();
    return null;
  }

  static public <A> boolean setVar_trueIfChanged(IVar<A> v, A value) {
    if (v == null)
      return false;
    synchronized (v) {
      if (eq(v.get(), value))
        return false;
      v.set(value);
      return true;
    }
  }

  static public String nEntries(long n) {
    return n2(n, "entry", "entries");
  }

  static public String nEntries(Collection l) {
    return nEntries(l(l));
  }

  static public String nEntries(Map map) {
    return nEntries(l(map));
  }

  static public int[] hexToInts(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 8;
    int[] ints = new int[n];
    for (int i = 0; i < n; i++) {
      int value = 0;
      for (int j = 0; j < 4; j++) {
        int idx = i * 8 + j * 2;
        int a = parseHexChar(s.charAt(idx));
        int b = parseHexChar(s.charAt(idx + 1));
        if (a < 0 || b < 0)
          throw fail("Bad hex byte: " + quote(substring(s, idx, idx + 2)) + " at " + idx + "/" + l(s));
        value |= ((a << 4) | b) << (j * 8);
      }
      ints[i] = value;
    }
    return ints;
  }

  static public <A, B> void syncMapPut2(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      synchronized (collectionMutex(map)) {
        if (value != null)
          map.put(key, value);
        else
          map.remove(key);
      }
  }

  static public <A, B> List<Pair<A, B>> mapToPairs(Map<A, B> map) {
    List<Pair<A, B>> l = emptyList(l(map));
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) l.add(pair(e.getKey(), e.getValue()));
    return l;
  }

  static public boolean isJavaxApplicationSnippetType(int type) {
    return type == snippetType_javaxSource() || type == snippetType_JavaXDesktop();
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public JComboBox onSelectedItem(final JComboBox cb, final VF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public Boolean askTripleBool(String q) {
    print(q + " no idea");
    return null;
  }

  static public <A extends AutoCloseable> A dm_ownResource(A resource) {
    dm_currentModuleMandatory().ownResource(resource);
    return resource;
  }

  static public int ratioToIntPercent(double x, double y) {
    return roundToInt(x * 100 / y);
  }

  static public BufferedImage loadPNG(File file) {
    return loadBufferedImage(file);
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public class tempRememberListener_c implements IFieldsToList {

    static final public String _fieldOrder = "mainObject removeMethod listener";

    public Object mainObject;

    public String removeMethod;

    public Object listener;

    public tempRememberListener_c() {
    }

    public tempRememberListener_c(Object mainObject, String removeMethod, Object listener) {
      this.listener = listener;
      this.removeMethod = removeMethod;
      this.mainObject = mainObject;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + mainObject + ", " + removeMethod + ", " + listener + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof tempRememberListener_c))
        return false;
      tempRememberListener_c __1 = (tempRememberListener_c) o;
      return eq(mainObject, __1.mainObject) && eq(removeMethod, __1.removeMethod) && eq(listener, __1.listener);
    }

    public int hashCode() {
      int h = 1262836985;
      h = boostHashCombine(h, _hashCode(mainObject));
      h = boostHashCombine(h, _hashCode(removeMethod));
      h = boostHashCombine(h, _hashCode(listener));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { mainObject, removeMethod, listener };
    }
  }

  static public AutoCloseable tempRememberListener(Object mainObject, String removeMethod, Object listener) {
    return tempHoldInstance(new tempRememberListener_c(mainObject, removeMethod, listener));
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public boolean newButton_autoToolTip = true;

  static public JButton newButton(final String text, final Object action) {
    return swing(new F0<JButton>() {

      public JButton get() {
        try {
          String text2 = dropPrefix("[disabled] ", text);
          final JButton btn = new JButton(text2);
          if (l(text2) < l(text))
            btn.setEnabled(false);
          if (newButton_autoToolTip) {
            btn.setToolTipText(btn.getText());
          }
          if (action != null)
            btn.addActionListener(actionListener(action, btn));
          return btn;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S text2 = dropPrefix(\"[disabled] \", text);\r\n    final JButton btn = new JButt...";
      }
    });
  }

  static public String smartJoin(String[] args) {
    if (empty(args))
      return "";
    if (args.length == 1)
      return args[0];
    String[] a = new String[args.length];
    for (int i = 0; i < a.length; i++) a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
    return join(" ", a);
  }

  static public String smartJoin(List<String> args) {
    return smartJoin(toStringArray(args));
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public void onUpdate(JComponent c, final Object r) {
    if (c instanceof JTextComponent)
      ((JTextComponent) c).getDocument().addDocumentListener(new DocumentListener() {

        public void insertUpdate(DocumentEvent e) {
          call(r);
        }

        public void removeUpdate(DocumentEvent e) {
          call(r);
        }

        public void changedUpdate(DocumentEvent e) {
          call(r);
        }
      });
    else if (c instanceof ItemSelectable)
      ((ItemSelectable) c).addItemListener(new ItemListener() {

        public void itemStateChanged(ItemEvent e) {
          call(r);
        }
      });
    else
      print("Warning: onUpdate doesn't know " + getClassName(c));
  }

  static public void onUpdate(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public List flattenIterablesAndArrays(Iterable a) {
    List l = new ArrayList();
    for (Object x : a) if (x instanceof Iterable)
      l.addAll(flattenIterablesAndArrays((Iterable) x));
    else if (x instanceof Iterator)
      l.addAll(flattenIterablesAndArrays(asList((Iterator) x)));
    else if (x instanceof Object[])
      l.addAll(flattenIterablesAndArrays(asList((Object[]) x)));
    else
      l.add(x);
    return l;
  }

  static public int intMax(Collection c, String field) {
    int max = Integer.MIN_VALUE;
    for (Object o : c) max = Math.max(max, toInt(getOpt(o, field)));
    return max;
  }

  static public int intMax(Iterable<Integer> l) {
    int max = Integer.MIN_VALUE;
    for (int i : unnullForIteration(l)) max = Math.max(max, i);
    return max;
  }

  static public int intMax(int... l) {
    int max = Integer.MIN_VALUE;
    if (l != null)
      for (int i : l) max = Math.max(max, i);
    return max;
  }

  static public <B, A extends Collection<B>> A addAndReturnCollection(A c, B a) {
    if (c != null)
      c.add(a);
    return c;
  }

  static public boolean activateFrame(final Component c, Object... __) {
    return swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          Frame f = getAWTFrame(c);
          if (f == null)
            return false;
          if (!f.isVisible())
            f.setVisible(true);
          boolean windowsHack = optPar("windowsHack", __, true);
          boolean iconified = f.getState() == Frame.ICONIFIED;
          boolean maximize = boolPar("maximize", __);
          if (iconified)
            f.setState(maximize ? Frame.MAXIMIZED_BOTH : Frame.NORMAL);
          if (windowsHack && !iconified && isWindows()) {
            boolean fullscreen = f.getExtendedState() == Frame.MAXIMIZED_BOTH;
            f.setExtendedState(JFrame.ICONIFIED);
            f.setExtendedState(fullscreen ? JFrame.MAXIMIZED_BOTH : JFrame.NORMAL);
          }
          f.toFront();
          return true;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Frame f = getAWTFrame(c);\r\n    if (f == null) false;\r\n    if (!f.isVisible())...";
      }
    });
  }

  static public void awtLater(int delay, final Object r) {
    swingLater(delay, r);
  }

  static public void awtLater(Object r) {
    swingLater(r);
  }

  static public void awtLater(JComponent component, int delay, Object r) {
    installTimer(component, r, delay, delay, false);
  }

  static public void awtLater(JFrame frame, int delay, Object r) {
    awtLater(frame.getRootPane(), delay, r);
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public FunctionCall functionCall_list(Object fname, Iterable args) {
    return new FunctionCall(fname, toObjectArray(args));
  }

  static public ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  static public void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  static public boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public void profileToConsole(Runnable r) {
    poorMansProfileToConsole(r);
  }

  static public <A> A profileToConsole(IF0<A> r) {
    if (r == null)
      return null;
    Var<A> var = new Var();
    poorMansProfileToConsole(new Runnable() {

      public void run() {
        try {
          var.set(r.get());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "var.set(r!)";
      }
    });
    return var.get();
  }

  static public boolean neqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return false;
    return true;
  }

  static public List<File> myLibraryFiles() {
    return asList((Collection<File>) get(myClassLoader(), "files"));
  }

  static public Object dm_javaEval(String expression) {
    return dm_evalJava_withModule(expression);
  }

  static public Object dm_javaEval(ICachedJavaXExpr expression) {
    return dm_evalJava_withModule(str(expression));
  }

  static public String nChars(long n) {
    return n2(n, "char");
  }

  static public String nChars(String s) {
    return nChars(l(s));
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    if (i >= end)
      return -1;
    String firstToken = tokens[0];
    if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
      while (i < end && !firstToken.equals(tok.get(i))) i += 2;
    }
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else
        matcher = t -> t.equals(p);
      matchers[j] = matcher;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public <A extends JComponent> A withTypeWriterFont(A c) {
    return setFont(c, typeWriterFont());
  }

  static public String dropTranslators(String src) {
    return findTranslators2(src, null);
  }

  static public List<String> dropTranslators(List<String> tok) {
    return findTranslators2(tok, null);
  }

  static public void printWithMS(String s) {
    printWithMSTime(s);
  }

  static public void tokAppend(List<String> tok, int i, String s) {
    tok.set(i, tok.get(i) + s);
  }

  static public <A, B> List<B> lambdaMethodMap(IF1<A, B> f, Iterable<A> l) {
    return map(f, l);
  }

  static public <A, B> List<B> lambdaMethodMap(IF1<A, B> f, A[] l) {
    return map(f, l);
  }

  static public BufferedImage matrixToImage(Matrix<Integer> m) {
    return intMatrixToBufferedImage(m);
  }

  static public JSplitPane setSplitPaneOnFirstShowing(Component c, double value) {
    return setSplitPaneOnFirstShowing(c, value, 0);
  }

  static public JSplitPane setSplitPaneOnFirstShowing(Component c, double value, int delay) {
    final JSplitPane sp = first(childrenOfType(c, JSplitPane.class));
    if (sp != null)
      onFirstResize(sp, new Runnable() {

        public void run() {
          try {
            if (delay == 0)
              sp.setDividerLocation(value);
            else
              awtLater(delay, new Runnable() {

                public void run() {
                  try {
                    sp.setDividerLocation(value);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "sp.setDividerLocation(value);";
                }
              });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef setSplitPaneOnFirstShowing_debug\r\n        printVars setSplitPaneOnFirst...";
        }
      });
    return sp;
  }

  static public boolean vmBus_noObjections(String msg, Object... args) {
    return !vmBus_anyFalse(msg, args);
  }

  static public String format(String pat, Object... args) {
    return format3(pat, args);
  }

  static public Object vmGeneralMap_get(Object key) {
    return vm_generalMap_get(key);
  }

  static public int heightForWidth(int w, int h, int newWidth) {
    return iround(newWidth * doubleRatio(h, w));
  }

  static public int heightForWidth(BufferedImage img, int newWidth) {
    return heightForWidth(img.getWidth(), img.getHeight(), newWidth);
  }

  static public int heightForWidth(int newWidth, BufferedImage img) {
    return heightForWidth(img, newWidth);
  }

  static public String strUnnull(Object o) {
    return o == null ? "" : str(o);
  }

  static public boolean isSymLink(File f) {
    return f != null && Files.isSymbolicLink(toPath(f));
  }

  static public Object get2(Object o, String field1, String field2) {
    return get(get(o, field1), field2);
  }

  static public <A, B> A eitherAOpt(Either<A, B> e) {
    return e != null && e.isA() ? e.a() : null;
  }

  static public JTextField onEnter(final JTextField tf, final Object action) {
    if (action == null || tf == null)
      return tf;
    tf.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          tf.selectAll();
          callF(action);
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    });
    return tf;
  }

  static public JButton onEnter(JButton btn, final Object action) {
    if (action == null || btn == null)
      return btn;
    btn.addActionListener(actionListener(action));
    return btn;
  }

  static public JList onEnter(JList list, Object action) {
    list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
    return list;
  }

  static public JComboBox onEnter(final JComboBox cb, final Object action) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (cb.isEditable()) {
              JTextField text = (JTextField) cb.getEditor().getEditorComponent();
              onEnter(text, action);
            } else {
              cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
              cb.getActionMap().put("enter", abstractAction("", new Runnable() {

                public void run() {
                  try {
                    cb.hidePopup();
                    callF(action);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "cb.hidePopup(); callF(action);";
                }
              }));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (cb.isEditable()) {\r\n      JTextField text = (JTextField) cb.getEditor().g...";
        }
      });
    }
    return cb;
  }

  static public JTable onEnter(final JTable table, final Object action) {
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    table.getActionMap().put("Enter", new AbstractAction() {

      public void actionPerformed(ActionEvent e) {
        callF(action, table.getSelectedRow());
      }
    });
    return table;
  }

  static public JTextField onEnter(Object action, JTextField tf) {
    return onEnter(tf, action);
  }

  static public boolean vmBus_anyFalse(String msg, Object... args) {
    return contains(vmBus_queryAll(msg, args), false);
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public <A> Matrix<A> listToMatrix(int w, List<A> data) {
    int n = l(data);
    int h = n / w;
    if (w * h != n)
      throw fail("Bad size", "n", n, "w", w, "h", h);
    return new ListToMatrix(w, h, data);
  }

  static public JSplitPane hsplit(Component l, Component r) {
    return jhsplit(l, r);
  }

  static public JSplitPane hsplit(Component l, Component r, double splitPoint, int delay) {
    return jhsplit(l, r, splitPoint, delay);
  }

  static public JSplitPane hsplit(Component l, Component r, double splitPoint) {
    return jhsplit(l, r, splitPoint);
  }

  static public JSplitPane hsplit(double splitPoint, Component l, Component r) {
    return jhsplit(splitPoint, l, r);
  }

  static public String mcDollar() {
    return mcName() + "$";
  }

  static public ChangeListener changeListener(final Object r) {
    return new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(r);
      }
    };
  }

  static public Rectangle screenRectangle() {
    return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
  }

  static public Rectangle screenRectangle(GraphicsDevice device) {
    if (device == null)
      return null;
    DisplayMode mode = device.getDisplayMode();
    return new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
  }

  static public <A, B> List<B> mapWithIndex(List<A> l, IF2<Integer, A, B> f) {
    List<B> out = emptyList(l);
    for (int i = 0; i < l(l); i++) out.add(f.get(i, l.get(i)));
    return out;
  }

  static public boolean set_trueIfChanged(Object o, String field, Object value) {
    if (eq(get(o, field), value))
      return false;
    set(o, field, value);
    return true;
  }

  static public <A> boolean set_trueIfChanged(IVar<A> v, A value) {
    return setVar_trueIfChanged(v, value);
  }

  static public boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  static public void copyStreamAndCloseInput(InputStream in, OutputStream out) {
    try {
      try {
        copyStream(in, out);
      } finally {
        in.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel centerAndEastWithMargin(Component c, Component e) {
    return centerAndEastWithMarginInbetween(c, e);
  }

  static public void retireClassLoader(ClassLoader cl) {
    if (isJavaXClassLoader(cl))
      setOptAll(cl, "retired", true, "retiredMarker", new DefunctClassLoader());
  }

  static public JFrame getFrame(final Object _o) {
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JFrame)
              return (JFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A> A dm_evalInQ(F0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), f);
  }

  static public <A> A dm_evalInQ(IF0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), if0ToF0(f));
  }

  static public <A> A dm_evalInQ(DynModule module, F0<A> f) {
    return evalInQ(module.q(), f);
  }

  static public IterableIterator<Integer> countIterator_exclusive(int b) {
    return countIterator_exclusive(0, b);
  }

  static public IterableIterator<Integer> countIterator_exclusive(int a, int b) {
    return new IterableIterator<Integer>() {

      public int i = a;

      public boolean hasNext() {
        return i < b;
      }

      public Integer next() {
        return i++;
      }
    };
  }

  static public <A> IterableIterator<A> countIterator_exclusive(int b, IF1<Integer, A> f) {
    return countIterator_exclusive(0, b, f);
  }

  static public <A> IterableIterator<A> countIterator_exclusive(int a, int b, IF1<Integer, A> f) {
    return mapI_if1(f, countIterator_exclusive(a, b));
  }

  static public JPanel centerAndSouth(final Component c, final Component s) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          if (s != null)
            panel.add(BorderLayout.SOUTH, wrap(s));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public JScrollPane jscroll_center(Component c) {
    return jscroll_centered(c);
  }

  static public JSplitPane jhsplit(Component l, Component r) {
    return jhsplit(l, r, 0.5);
  }

  static public JSplitPane jhsplit(Component l, Component r, double splitPoint, int delay) {
    return jhsplit(l, r, splitPoint);
  }

  static public JSplitPane jhsplit(Component l, Component r, double splitPoint) {
    return setSplitPaneOnFirstShowing(swingNu(JSplitPane.class, JSplitPane.HORIZONTAL_SPLIT, wrap(l), wrap(r)), splitPoint);
  }

  static public JSplitPane jhsplit(double splitPoint, Component l, Component r) {
    return jhsplit(l, r, splitPoint);
  }

  static public SimpleLiveValue dm_fieldLiveValue(String fieldName) {
    return dm_fieldLiveValue(dm_current_mandatory(), fieldName);
  }

  static public SimpleLiveValue dm_fieldLiveValue(final DynModule module, final String fieldName) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      AutoCloseable __2 = module.enter();
      try {
        Class type = getFieldType(module, fieldName);
        final SimpleLiveValue value = new SimpleLiveValue(type, get(module, fieldName));
        dm_watchField(fieldName, new Runnable() {

          public void run() {
            try {
              Object o = get(module, fieldName);
              value.set(o);
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting \" + fi...";
          }
        });
        value.onChange(new Runnable() {

          public void run() {
            try {
              module.setField(fieldName, value.get());
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting 2 \" + ...";
          }
        });
        return value;
      } finally {
        _close(__2);
      }
    } finally {
      unlock(__0);
    }
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public double elapsedMinutes_timestamp(long time) {
    return toMinutes(now() - time);
  }

  static public void toggleAlwaysOnTop(Window frame) {
    if (frame == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setAlwaysOnTop(!frame.isAlwaysOnTop());";
        }
      });
    }
  }

  static public String percentRatioStrOneDigit(double x) {
    return percentRatioStrOneDigit(x, 1);
  }

  static public String percentRatioStrOneDigit(double x, double y) {
    return formatDouble1(doublePercentRatio(x, y)) + " %";
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public Class veryQuickJava_finish(String src, List<String> libs) {
    libs = cloneList(libs);
    src = findTranslators2(src, libs);
    String dehlibs = join(" ", libs);
    File bytecode = null;
    bytecode = javaCompile_overInternalBot(src, dehlibs);
    return hotwireCore(concatLists(ll(bytecode), loadLibraries(libs)));
  }

  static public List<File> findAllFiles_noDirs(List dirs) {
    return findAllFiles_noDirs(asObjectArray(dirs));
  }

  static public List<File> findAllFiles_noDirs(Object... dirs) {
    List<File> l = new ArrayList();
    for (Object dir : dirs) {
      ping();
      if (dir instanceof String && ((String) dir).endsWith("/.")) {
        for (File f : listFiles(dropSuffix("/.", ((String) dir)))) {
          ping();
          if (f.isFile())
            l.add(f);
        }
      } else
        findAllFiles_noDirs_impl(toFile(dir), l);
    }
    return l;
  }

  static public void findAllFiles_noDirs_impl(File dir, List<File> l) {
    for (File f : listFiles(dir)) {
      ping();
      if (f.isDirectory())
        findAllFiles_noDirs_impl(f, l);
      else
        l.add(f);
    }
  }

  static public Object[] toObjectArray(Collection c) {
    return toObjectArray((Iterable) c);
  }

  static public Object[] toObjectArray(Iterable c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public double nanoSecondsToSeconds(double nanos) {
    return nanos * 1e-9;
  }

  static public Dimension getScreenSize() {
    return Toolkit.getDefaultToolkit().getScreenSize();
  }

  static public ImageSurface imageSurface(BufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface(MakesBufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface() {
    return swingNu(ImageSurface.class);
  }

  static public Rect rectFromPoints(int x1, int y1, int x2, int y2) {
    return pointsRect(x1, y1, x2, y2);
  }

  static public Rect rectFromPoints(Pt a, Pt b) {
    return pointsRect(a.x, a.y, b.x, b.y);
  }

  static public Runnable runnableThread(final Runnable r) {
    return new Runnable() {

      public void run() {
        try {
          startThread(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startThread(r)";
      }
    };
  }

  static public String addPrefixIfNotEmpty(String prefix, String s) {
    return empty(s) ? "" : prefix + s;
  }

  static public <A extends JComponent> A toolTip(A c, final Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A toolTip(Object toolTip, A c) {
    return setToolTipText(toolTip, c);
  }

  static public String getLine(String s, int lineNr) {
    return safeGet(toLines(s), lineNr - 1);
  }

  static public Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  static public List<Rect> allScreenBounds() {
    return map(__78 -> screenBounds(__78), screenDevices());
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public void rangeCheck(int i, int n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public void rangeCheck(long i, long n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public String compilerBotDestDirSubName() {
    return "JavaX-Caches/Compilations";
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public Runnable rCallOnSelectedListItem(final JList list, final Object action) {
    return new Runnable() {

      public void run() {
        try {
          pcallF(action, getSelectedItem(list));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(action, getSelectedItem(list))";
      }
    };
  }

  static public int withBottomMargin_defaultWidth = 6;

  static public JPanel withBottomMargin(Component c) {
    return withBottomMargin(withBottomMargin_defaultWidth, c);
  }

  static public JPanel withBottomMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, w, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public Font typeWriterFont() {
    return typeWriterFont(iround(14 * getSwingFontScale()));
  }

  static public Font typeWriterFont(int size) {
    return new Font("Courier", Font.PLAIN, size);
  }

  static public List<WeakReference<Class>> hotwire_classes = synchroList();

  static public Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  static public File javaCompile_overInternalBot(String src) {
    return javaCompile_overInternalBot(src, "");
  }

  static synchronized public File javaCompile_overInternalBot(String src, String dehlibs) {
    return CompilerBot.compile(src, dehlibs);
  }

  static public <A> AutoCloseable tempLoadingAnim(String msg) {
    return tempDisposeWindow(loadingAnim(msg));
  }

  static public void removeMouseAdapter(Component c, MouseAdapter a) {
    if (c != null && a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.removeMouseListener(a);
            c.removeMouseMotionListener(a);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.removeMouseListener(a);\r\n    c.removeMouseMotionListener(a);";
        }
      });
    }
  }

  static public <A extends Window> A disposeWindowAfter(int delay, final A w) {
    if (w != null)
      swingLater(delay, new Runnable() {

        public void run() {
          try {
            w.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.dispose();";
        }
      });
    return w;
  }

  static public <A extends Window> A disposeWindowAfter(A w, double seconds) {
    return disposeWindowAfter(toMS_int(seconds), w);
  }

  static public <A extends Window> A disposeWindowAfter(double seconds, A w) {
    return disposeWindowAfter(w, seconds);
  }

  static public int indexOfNonDigit(String s) {
    int n = l(s);
    for (int i = 0; i < n; i++) if (!isDigit(s.charAt(i)))
      return i;
    return -1;
  }

  static public List<String> tok_combineCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "{")) {
        int j = findEndOfCurlyBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public String hms() {
    return hms(now());
  }

  static public String hms(long time) {
    return new SimpleDateFormat("HHmmss").format(time);
  }

  static public <A, B> List<List<B>> mapTwoLevelsDown(F1<A, B> f, Iterable<List<A>> l) {
    List<List<B>> out = new ArrayList();
    if (l != null)
      for (List<A> x : l) out.add(map(f, x));
    return out;
  }

  static public <A, B> List<List<B>> mapTwoLevelsDown(IF1<A, B> f, Iterable<List<A>> l) {
    List<List<B>> out = new ArrayList();
    if (l != null)
      for (List<A> x : l) out.add(map(f, x));
    return out;
  }

  static public void copyLocalLog(Object src, Object dest) {
    Object log = getOpt(src, "local_log");
    if (log != null)
      setOpt(dest, "local_log", local_log);
  }

  static public <A> int compareWithComparator(Comparator<A> comparator, A a, A b) {
    return comparator == null ? cmp(a, b) : comparator.compare(a, b);
  }

  static public int tok_findEndOfMethodDecl(List<String> tok, int i) {
    i = tok_findEndOfMethodHeader(tok, i);
    return findEndOfBlock(tok, i);
  }

  static public JScrollPane jscroll_centered(Component c) {
    return jscroll(jFullCenter(c));
  }

  static public Complex complex(double re, double im) {
    return new Complex(re, im);
  }

  static public Complex complex(double re) {
    return new Complex(re, 0.0);
  }

  static public Complex complex(double[] reIm) {
    if (empty(reIm))
      return null;
    if (l(reIm) != 2)
      throw fail("Need 2 doubles to make complex number");
    return complex(reIm[0], reIm[1]);
  }

  static public TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  static public Lock hotwireCached_lock = lock();

  static public Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  static public Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  static public Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __0 = hotwireCached_lock;
    lock(__0);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__0);
    }
  }

  public static boolean isWindows() {
    return System.getProperty("os.name").contains("Windows");
  }

  static public int rectArea(Rect r) {
    return r == null ? 0 : r.w * r.h;
  }

  static public String bashQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String bashQuote(File f) {
    return bashQuote(f.getAbsolutePath());
  }

  static public String tok_firstClassName(List<String> tok) {
    int i = jfind(tok, "class <id>");
    return i < 0 ? null : tok.get(i + 2);
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public void intToBytes_inArray_littleEndian(int i, byte[] array, int idx) {
    array[idx] = (byte) i;
    array[idx + 1] = (byte) (i >>> 8);
    array[idx + 2] = (byte) (i >>> 16);
    array[idx + 3] = (byte) (i >>> 24);
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public int roundToInt(double d) {
    return (int) Math.round(d);
  }

  static public <A> A evalInQ(Q q, final F0<A> f) {
    if (isInQ(q))
      return callF(f);
    final Var<Either<A, Throwable>> var = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            var.set(eitherA(callF(f)));
          } catch (Throwable e) {
            var.set(eitherB(e));
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      var.set(eitherA(callF(f)));\r\n    } catch (Throwable e) {\r\n      ...";
      }
    });
    return returnOrThrow_either(waitForVarToBeNotNull(var));
  }

  static public List<String> regexpExtractAll(String pat, String s) {
    if (s == null)
      return null;
    Matcher m = regexpMatcher(pat, s);
    List<String> out = new ArrayList();
    while (m.find()) out.add(m.group());
    return out;
  }

  static public <A> AutoCloseable vmBus_addListener_basic(String msg, Object listener) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, listener);
    }
  }

  static public <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
    if (l == null)
      return new ArrayList();
    synchronized (mutex) {
      return new ArrayList<A>(l);
    }
  }

  static public Map synchroLinkedHashMap() {
    return synchronizedMap(new LinkedHashMap());
  }

  static public JWindow showInTopRightCorner(Component c) {
    return swing(() -> {
      JWindow w = new JWindow();
      w.add(c);
      w.pack();
      moveToTopRightCorner(w);
      w.setVisible(true);
      return w;
    });
  }

  static public byte[] intListToByteArray_littleEndian(List<Integer> l) {
    if (l == null)
      return null;
    int n1 = l(l), n = n1 * 4;
    byte[] a = new byte[n];
    for (int i = 0; i < n1; i++) intToBytes_inArray_littleEndian(l.get(i), a, i * 4);
    return a;
  }

  static public <A> void listSet(List<A> l, int i, A a, A emptyElement) {
    if (i < 0)
      return;
    while (i >= l(l)) l.add(emptyElement);
    l.set(i, a);
  }

  static public <A> void listSet(List<A> l, int i, A a) {
    listSet(l, i, a, null);
  }

  static public JComponent getTitlePaneComponent(RootPaneContainer window) {
    if (window instanceof JInternalFrame)
      return getInternalFrameTitlePaneComponent((JInternalFrame) window);
    if (!substanceLookAndFeelEnabled() || window == null)
      return null;
    JRootPane rootPane = window.getRootPane();
    if (rootPane != null) {
      Object ui = rootPane.getUI();
      return (JComponent) call(ui, "getTitlePane");
    }
    return null;
  }

  static public void deleteDirectory(File dir) {
    deleteDirectory(dir, false, false);
  }

  static public void deleteDirectory(File dir, boolean verbose, boolean testRun) {
    deleteAllFilesInDirectory(dir, verbose, testRun);
    if (verbose)
      print((testRun ? "Would delete " : "Deleting ") + dir.getAbsolutePath());
    if (!testRun)
      dir.delete();
  }

  static public int poorMansProfiling_defaultInterval() {
    return 25;
  }

  static public void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  static public int screenWidth() {
    return getScreenWidth();
  }

  static public int screenWidth(int iDevice) {
    return screenBounds(iDevice).getWidth();
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public double[] takeFirstOfDoubleArray(double[] b, int n) {
    return subDoubleArray(b, 0, n);
  }

  static public double[] takeFirstOfDoubleArray(int n, double[] b) {
    return takeFirstOfDoubleArray(b, n);
  }

  static public void showConsole() {
    callOpt(get(javax(), "console"), "showConsole");
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean isLowerCase(char c) {
    return Character.isLowerCase(c);
  }

  static public JComponent getInternalFrameTitlePaneComponent(JInternalFrame f) {
    return (JComponent) childWithClassNameEndingWith(f, "InternalFrameTitlePane");
  }

  static public Rect toRect_floor(DoubleRect r) {
    if (r == null)
      return null;
    int x = ifloor(r.x), y = ifloor(r.y);
    return new Rect(x, y, ifloor(r.x2()) - x, ifloor(r.y2()) - y);
  }

  static public F1 toF1(final Object f) {
    return functionToF1(f);
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public Object endMarker() {
    return iteratorFromFunction_endMarker;
  }

  static public void onFirstResize(final Component c, final Object r) {
    if (c != null && r != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addComponentListener(new ComponentAdapter() {

              public void componentResized(ComponentEvent e) {
                c.removeComponentListener(this);
                pcallF(r);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addComponentListener(new ComponentAdapter {\r\n      public void componentRes...";
        }
      });
    }
  }

  static public void duplicateThisProgram() {
    nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
  }

  static public JComponent gazelle_wavySpacer() {
    return jMinWidth(30, swing(() -> new JComponent() {

      public void paintComponent(Graphics g) {
        int w = getWidth(), h = getHeight();
        var points = graphAsPolygon(x -> 1 - sineSigmoid(x), w, h);
        fillRect(((Graphics2D) g), 0, 0, w, h, gazelle_color2());
        fillPrecisePolygon(((Graphics2D) g), points, gazelle_color1());
      }
    }));
  }

  static public String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  static public Object iteratorFromFunction_endMarker = new Object();

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = callF(f);
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
    return iteratorFromFunction_withEndMarker_f0(f);
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public void callOnLoadMethods(Class c) {
    for (String name : methodsStartingWith(c, "_onLoad_")) pcallOpt(c, name);
    pcallOpt(c, "_onLoad");
  }

  static public F0<AutoCloseable> dm_rEnter() {
    return dm_rEnter(dm_current());
  }

  static public F0<AutoCloseable> dm_rEnter(DynModule mod) {
    return mod == null ? null : new F0<AutoCloseable>() {

      public AutoCloseable get() {
        try {
          return mod.enter();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mod.enter();";
      }
    };
  }

  static public Runnable dm_rEnter(Runnable r) {
    return dm_rEnter(dm_current(), r);
  }

  static public Runnable dm_rEnter(DynModule mod, Runnable r) {
    return mod == null || r == null ? r : new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = mod.enter();
          try {
            r.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp mod.enter(); r.run();";
      }
    };
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public boolean isOneOfSingleChars(String s, char... chars) {
    if (l(s) != 1)
      return false;
    char real = s.charAt(0);
    for (char c : unnullForIteration(chars)) if (real == c)
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, String... b) {
    if (b != null)
      for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
        return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b, Matches m) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix, m))
      return true;
    return false;
  }

  static public boolean getServerTranspiled2_allowLocalFallback = true, getServerTranspiled2_localFallbackVerbose = true;

  static public Map<String, String> getServerTranspiled2_tempCache;

  static public String getServerTranspiled2(String id) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getTranspiled(id);
    return getServerTranspiled2_noResourceLoader(id);
  }

  static public String getServerTranspiled2_noResourceLoader(String id) {
    id = fsIOpt(id);
    String transpiled = mapGet(getServerTranspiled2_tempCache, id);
    if (transpiled != null)
      return transpiled;
    transpiled = loadCachedTranspilation(id);
    String md5 = null;
    if (machineIsOffline() || isOfflineMode() || isLocalSnippet(id))
      return transpiled;
    if (transpiled != null)
      md5 = md5(transpiled);
    String transpiledSrc;
    try {
      transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
    } catch (Throwable e) {
      if (!getServerTranspiled2_allowLocalFallback)
        rethrow(e);
      printExceptionShort(e);
      if (getServerTranspiled2_localFallbackVerbose)
        print("Fallback to local code");
      return transpiled;
    }
    if (eq(transpiledSrc, "SAME")) {
      if (!isTrue(loadPage_silent.get()))
        print("SAME");
      return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiled);
    }
    return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiledSrc);
  }

  static public boolean loadLibraryOrSrcLib_srcLibsEnabled = true;

  static public ThreadLocal<Map<Long, File>> loadLibraryOrSrcLib_tempCache = new ThreadLocal();

  static public ThreadLocal<IF1<String, File>> loadLibraryOrSrcLib_compiler = new ThreadLocal();

  static public File loadLibraryOrSrcLib(String snippetID) {
    return loadLibraryOrSrcLib(snippetID, loadLibraryOrSrcLib_compiler.get());
  }

  static public File loadLibraryOrSrcLib(String snippetID, IF1<String, File> compiler) {
    try {
      vmBus_send("loadLibraryOrSrcLib", snippetID);
      long id = parseSnippetID(snippetID);
      if (loadLibraryOrSrcLib_tempCache.get() != null) {
        File f = loadLibraryOrSrcLib_tempCache.get().get(id);
        if (f != null) {
          print(snippetID + " from tempCache: " + f);
          return f;
        }
      }
      boolean srcLib = loadLibraryOrSrcLib_srcLibsEnabled && isMarkedAsSrcLib(snippetID);
      if (srcLib) {
        print(snippetID + " marked as src lib, compiling");
        File f;
        if (compiler != null)
          f = compiler.get(snippetID);
        else
          f = pairA(hotwire_compile(snippetID));
        print("Src lib: " + f);
        mapPut(loadLibraryOrSrcLib_tempCache.get(), id, f);
        return f;
      }
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) != 0) {
        print(snippetID + " from disk cache: " + f);
        return f;
      }
      try {
        print("Trying " + snippetID + " as binary library");
        return loadDataSnippetToFile(snippetID);
      } catch (Throwable e) {
        if (loadLibraryOrSrcLib_srcLibsEnabled) {
          print("Trying " + snippetID + " as src lib");
          if (nempty(loadSnippet(snippetID))) {
            print("Is src lib.");
            markAsSrcLib(snippetID);
            return pairA(hotwire_compile(snippetID));
          }
        }
        throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int fullAlphaMask() {
    return 0xFF000000;
  }

  static public List<String> findMainClass(List<String> tok) {
    for (List<String> c : reversedList(allClasses(tok))) {
      String name = getClassDeclarationName(c);
      if (eq(name, "main") || name.startsWith("x"))
        return c;
    }
    return findBlock("m {", tok);
  }

  static public String toString(Object o) {
    return strOrNull(o);
  }

  static public Object callCalc(Object o, Object... args) {
    return call(o, "calc", args);
  }

  static public void saveTranspiledCode(String progID, String code) {
    File dir = getCodeProgramDir(progID);
    new File(dir, "Transpilation").delete();
    saveGZTextFile(new File(dir, "Transpilation.gz"), code);
  }

  static public <A> Matrix<Matrix<A>> matrixToMNGrid(Matrix<A> m, int cols, int rows) {
    if (m == null)
      return null;
    cols = clamp(cols, 1, m.getWidth());
    rows = clamp(rows, 1, m.getHeight());
    List<List<Rect>> rects = gridOfRects3(m.getWidth(), m.getHeight(), cols, rows);
    List<List<Matrix<A>>> matrices = mapLevelTwo(r -> new SubMatrix(m, r), rects);
    return listOfListsToMatrix(matrices);
  }

  static public <A> List<A> colToList(Matrix<A> m, int x) {
    if (m == null)
      return null;
    rangeCheck(x, m.getWidth());
    int h = m.getHeight();
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return h;
      }

      public A get(int y) {
        return m.get(x, y);
      }

      public A set(int y, A val) {
        A old = m.get(x, y);
        m.set(x, y, val);
        return old;
      }
    };
  }

  static public class mapI_if1_It<A, B> extends IterableIterator<B> {

    public IF1<A, B> f;

    public Iterator<A> i;

    public mapI_if1_It() {
    }

    public mapI_if1_It(IF1<A, B> f, Iterator<A> i) {
      this.i = i;
      this.f = f;
    }

    public boolean hasNext() {
      return i.hasNext();
    }

    public B next() {
      return f.get(i.next());
    }

    public String toString() {
      return formatFunctionCall("mapI_if1", f, i);
    }
  }

  static public <A, B> IterableIterator<B> mapI_if1(IF1<A, B> f, Iterable<A> i) {
    return new mapI_if1_It(f, i.iterator());
  }

  static public <A, B> IterableIterator<B> mapI_if1(Iterable<A> i, IF1<A, B> f) {
    return mapI_if1(f, i);
  }

  static public boolean showAnimationInTopRightCorner_alwaysOnTop = true;

  static public boolean showAnimationInTopRightCorner_on = true;

  static public JWindow showAnimationInTopRightCorner(String imageID, String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(imageID), text);
  }

  static public JWindow showAnimationInTopRightCorner(final Image image, final String text) {
    if (image == null || isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(image), text);
  }

  static public JWindow showAnimationInTopRightCorner(final ImageIcon imageIcon, final String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JLabel label = new JLabel(imageIcon);
          if (nempty(text)) {
            label.setText(text);
            label.setVerticalTextPosition(SwingConstants.BOTTOM);
            label.setHorizontalTextPosition(SwingConstants.CENTER);
          }
          final JWindow window = showInTopRightCorner(label);
          onClick(label, new Runnable() {

            public void run() {
              try {
                window.dispose();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "window.dispose()";
            }
          });
          if (showAnimationInTopRightCorner_alwaysOnTop)
            window.setAlwaysOnTop(true);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JLabel label = new JLabel(imageIcon);\r\n    if (nempty(text)) {\r\n      label.s...";
      }
    });
  }

  static public JWindow showAnimationInTopRightCorner(final String imageID) {
    return showAnimationInTopRightCorner(imageID, "");
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, double seconds) {
    return showAnimationInTopRightCorner(imageID, "", seconds);
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, String text, double seconds) {
    if (isHeadless())
      return null;
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(imageID, text));
  }

  static public JWindow showAnimationInTopRightCorner(BufferedImage img, String text, double seconds) {
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(img, text));
  }

  static public String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  static public String div() {
    return div("");
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public Complex div(Complex a, double b) {
    return new Complex(a.re / b, a.im / b);
  }

  static public double div(double a, double b) {
    return a / b;
  }

  static public void addComponentsFirst(Container c, Component... l) {
    containerAddFirst(c, l);
  }

  static public String squareBracket(String s) {
    return "[" + s + "]";
  }

  static public File makeFileNameUnique_beforeExtension(File f) {
    File orig = f;
    int n = 0;
    while (f.exists()) f = appendToFileBaseName(orig, "." + ++n);
    return f;
  }

  static public void stepAllWithTimeout(double timeout, Steppable s) {
    if (s == null)
      return;
    long endTime = sysNow() + toMS(timeout);
    do {
      ping();
    } while (s.step() && sysNow() < endTime);
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public boolean tok_isJavaxMetaCommandLeftOf(List<String> tok, int i) {
    int j = i - 2 * 4 - 1;
    if (j >= 0 && jfind(subList(tok, j, i), "set flag <id> .") == 1)
      return true;
    return false;
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public void fixACCInClassLoader(Object o) {
  }

  static public String formatLocalDateWithSeconds(long time) {
    return localDateWithSeconds(time);
  }

  static public String formatLocalDateWithSeconds() {
    return localDateWithSeconds();
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public <A extends JComponent> A applyDefaultMargin(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMarg...";
        }
      });
    }
    return c;
  }

  static public void removeFromParent(final Component c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            Container cc = c.getParent();
            if (cc != null) {
              cc.remove(c);
              revalidate(cc);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Container cc = c.getParent();\r\n    if (cc != null) {\r\n      cc.remove(c);\r\n  ...";
        }
      });
    }
  }

  static public int month() {
    return localMonth();
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public boolean containsSpaces(String s) {
    return indexOf(s, ' ') >= 0;
  }

  static public boolean renameFile(File a, File b) {
    mkdirsForFile(b);
    return a.renameTo(b);
  }

  static public boolean renameFile(File a, String newName) {
    return renameFile(a, fileInSameDir(a, newName));
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public String flexLines(Object... l) {
    return lines(flattenIterablesAndArrays(ll(l)));
  }

  static public <A, B> boolean eitherIsA(Either<A, B> e) {
    return e != null && e.isA();
  }

  static public Object[] unrollParams(Object[] params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToParams((Map) params[0]);
    return params;
  }

  static public <A, B> boolean eitherIsB(Either<A, B> e) {
    return e != null && e.isB();
  }

  static public List mapQuickEval_javaExpr(Iterable<ICachedJavaXExpr> l) {
    return map(e -> e.quickEval(), l);
  }

  static public Object dm_callOS(String functionName, Object... args) {
    return call(dm_os(), functionName, args);
  }

  static public String tok_addReturn(List<String> tok) {
    if (tok_shouldAddReturn(tok)) {
      tokPrepend(tok, 1, "ret ");
      tokAppend(tok, l(tok) - 2, ";");
    }
    return join(tok);
  }

  static public String tok_addReturn(String s) {
    return tok_addReturn(javaTok(s));
  }

  static public String loadTextFileFromZip(File inZip, String fileName) {
    return loadTextFileFromZipFile(inZip, fileName);
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public Object dm_current_generic_mandatory() {
    return dm_current_mandatory_generic();
  }

  static public boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
  }

  static public boolean regionMatches(String a, int offsetA, String b) {
    return regionMatches(a, offsetA, b, 0, l(b));
  }

  static public String naiveQuote(String s) {
    return simpleQuote(s);
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public int snippetType_javaxModule() {
    return 54;
  }

  static public void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  static public void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  static public <A, B> WithSideValue<A, B> withSideValue(A sideValue, B value) {
    return new WithSideValue(sideValue, value);
  }

  static public RandomAccessFile newRandomAccessFile(File path, String mode) {
    try {
      boolean forWrite = mode.indexOf('w') >= 0;
      if (forWrite)
        mkdirsForFile(path);
      RandomAccessFile f = new RandomAccessFile(path, mode);
      callJavaX("registerIO", f, path, forWrite);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Boolean grabbableIntPixels_succeeded;

  static public boolean grabbableIntPixels_enable = true;

  static public GrabbableIntPixels grabbableIntPixels(BufferedImage img) {
    if (img == null || !grabbableIntPixels_enable)
      return null;
    try {
      var result = grabbableIntPixels_impl(img);
      grabbableIntPixels_succeeded = result != null;
      return result;
    } catch (Throwable _e) {
      grabbableIntPixels_succeeded = false;
      throw rethrow(_e);
    }
  }

  static public GrabbableIntPixels grabbableIntPixels_impl(BufferedImage img) {
    Raster raster = img.getRaster();
    SampleModel _sampleModel = raster.getSampleModel();
    if (!(_sampleModel instanceof SinglePixelPackedSampleModel))
      return null;
    SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel) _sampleModel;
    DataBufferInt dataBuffer = (DataBufferInt) (raster.getDataBuffer());
    assertEquals(1, dataBuffer.getNumBanks());
    assertEquals(DataBuffer.TYPE_INT, dataBuffer.getDataType());
    int w = img.getWidth(), h = img.getHeight();
    int scanlineStride = sampleModel.getScanlineStride();
    int[] pixels = dataBuffer.getData();
    int offset = dataBuffer.getOffset();
    int translateX = raster.getSampleModelTranslateX();
    int translateY = raster.getSampleModelTranslateY();
    offset += -translateX - translateY * scanlineStride;
    return new GrabbableIntPixels(pixels, w, h, offset, scanlineStride);
  }

  static public double doublePercentRatio(double x, double y) {
    return doubleRatio(x, y) * 100;
  }

  static public double doublePercentRatio(Seconds x, Seconds y) {
    return doublePercentRatio(x.get(), y.get());
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public List<File> loadLibraries(List<String> snippetIDs) {
    return map("loadLibrary", snippetIDs);
  }

  static public void logQuotedWithDate(String s) {
    logQuotedWithTime(s);
  }

  static public void logQuotedWithDate(String logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public void logQuotedWithDate(File logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public File printFileInfo(File f) {
    return printFileInfo("", f);
  }

  static public File printFileInfo(String s, File f) {
    print(s, renderFileInfo(f));
    return f;
  }

  static public JComponent dm_getVisualization(Object module) {
    return (JComponent) callOpt(dm_getStem(module), "vis");
  }

  static public JComponent dm_getVisualization() {
    return dm_getVisualization(dm_current_mandatory_generic());
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public int snippetType_javaxSource() {
    return 34;
  }

  static public <A> A dm_callOSOpt(String functionName, Object... args) {
    return (A) callOpt(dm_os(), functionName, args);
  }

  static public boolean interruptThread_verbose = false;

  static public void interruptThread(Thread t) {
    if (t == null)
      return;
    if (interruptThread_verbose)
      print("Interrupting thread " + t);
    vm_threadInterruptionReasonsMap().put(t, getStackTrace());
    t.interrupt();
    URLConnection c = (URLConnection) (vm_generalSubMap("URLConnection per thread").get(t));
    if (c != null) {
      try {
        print("Closing URLConnection of interrupted thread.");
        call(c, "disconnect");
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public <A extends JComponent> A bindLiveValueListenerToComponent(A component, final LiveValue lv, final Runnable listener) {
    if (lv != null)
      bindToComponent(component, new Runnable() {

        public void run() {
          try {
            lv.onChangeAndNow(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef bindLiveValueListenerToComponent_debug\r\n          print(\"bindLiveValueL...";
        }
      }, new Runnable() {

        public void run() {
          try {
            lv.removeOnChangeListener(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lv.removeOnChangeListener(listener)";
        }
      });
    return component;
  }

  static public void setOptAll(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) setOpt(o, field, fields.get(field));
  }

  static public void setOptAll(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      setOpt(o, field, value);
    }
  }

  static public int screenHeight() {
    return getScreenHeight();
  }

  static public int getPreferredWidth(Component c) {
    return preferredWidth(c);
  }

  static public boolean isOfflineMode() {
    return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
  }

  static public Rect screenBounds(GraphicsDevice screen) {
    return screen == null ? null : toRect(screen.getDefaultConfiguration().getBounds());
  }

  static public Rect screenBounds(int iScreen) {
    return screenBounds(get(screenDevices(), iScreen));
  }

  static public Map<JFrame, Boolean> myFrames_list = weakHashMap();

  static public List<JFrame> myFrames() {
    return swing(new F0<List<JFrame>>() {

      public List<JFrame> get() {
        try {
          return keysList(myFrames_list);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret keysList(myFrames_list);";
      }
    });
  }

  static public String callStringifier(Object stringifier, Object o) {
    return stringifier != null ? str(callF(stringifier, o)) : str(o);
  }

  static public void metaSet(IMeta o, Object key, Object value) {
    metaMapPut(o, key, value);
  }

  static public int calculateLengthOfFunctionCall(String fname, int... argLengths) {
    return l(fname) + 2 + intSum(argLengths);
  }

  static public String loadSnippetSilently(Snippet s) {
    return loadSnippetQuietly(s);
  }

  static public String loadSnippetSilently(String snippetID) {
    return loadSnippetQuietly(snippetID);
  }

  static public File touchFile(File file) {
    try {
      closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] paramsWithout(Object[] a1, Object... keys) {
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapMinus((Map) a1[0], keys) };
    Set set = lithashset(keys);
    List l = new ArrayList();
    int n = l(a1);
    for (int i = 0; i < n; i += 2) if (i == n - 1)
      l.add(a1[i]);
    else if (!set.contains(a1[i])) {
      l.add(a1[i]);
      l.add(a1[i + 1]);
    }
    return toObjectArray(l);
  }

  static public Rectangle toRectangle(Rect r) {
    return r == null ? null : r.getRectangle();
  }

  static public List<String> allMethodNames(Object o) {
    Class c = _getClass(o);
    TreeSet<String> names = new TreeSet();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) names.add(m.getName());
      c = c.getSuperclass();
    }
    return asList(names);
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  static public void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  static public void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  static public JFrame consoleFrame() {
    return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
  }

  static public JECompressionRegime jeCompressionRegime() {
    return new JECompressionRegime();
  }

  static public int widthForHeight(int w, int h, int newHeight) {
    return iround(newHeight * doubleRatio(w, h));
  }

  static public int widthForHeight(double w, double h, int newHeight) {
    return iround(newHeight * doubleRatio(w, h));
  }

  static public Class hotwireCore(List<File> files) {
    try {
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      Class<?> theClass = classLoader.loadClass("main");
      setOpt(theClass, "__javax", getJavaX());
      if (getOpt(theClass, "programID") == null)
        setOpt(theClass, "programID", "#3999999");
      if (!_inCore())
        hotwire_copyOver(theClass);
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A returnOrThrow_either(Either<A, Throwable> e) {
    if (isEitherB(e))
      throw rethrow(e.b());
    return eitherAOpt(e);
  }

  static public int tok_findEndOfBlock(List<String> tok, int i) {
    int j = i + 2, level = 1, n = l(tok);
    while (j < n) {
      String t = tok.get(j);
      if ("{".equals(t))
        ++level;
      else if ("}".equals(t))
        --level;
      if (level == 0)
        return j + 1;
      j += 2;
    }
    return n;
  }

  static public <A extends JLabel> A centerLabel(A l) {
    if (l != null)
      l.setHorizontalAlignment(SwingConstants.CENTER);
    return l;
  }

  static public String nohup_sanitize(String s) {
    return empty(s) ? s : takeFirst(50, s.replaceAll("[^.a-zA-Z0-9\\-_]", ""));
  }

  static public File javaxCodeDir_dir;

  static public File javaxCodeDir() {
    return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
  }

  static public File javaxCodeDir(String sub) {
    return newFile(javaxCodeDir(), sub);
  }

  static public BufferedImage imageFromHex(int w, int h, String pixelsAsHex) {
    return intArrayToBufferedImage(hexToInts_dropSpaces(pixelsAsHex), w, h);
  }

  static public JLabel jLiveValueLabel(final LiveValue lv) {
    return bindJLabelToLiveValue(jlabel(), lv);
  }

  static public AutoCloseable tempSet(Object o, final String field, Object value) {
    return tempSetField(o, field, value);
  }

  static public AutoCloseable combineAutoCloseables(final AutoCloseable a, final AutoCloseable b) {
    return a == null ? b : b == null ? a : new AutoCloseable() {

      public String toString() {
        return "pClose(a); pClose(b);";
      }

      public void close() throws Exception {
        pClose(a);
        pClose(b);
      }
    };
  }

  static public AutoCloseable combineAutoCloseables(AutoCloseable a, AutoCloseable b, AutoCloseable c, AutoCloseable... more) {
    return combineAutoCloseables(concatLists(ll(a, b, c), asList(more)));
  }

  static public AutoCloseable combineAutoCloseables(Iterable<AutoCloseable> l) {
    return foldl(new F2<AutoCloseable, AutoCloseable, AutoCloseable>() {

      public AutoCloseable get(AutoCloseable a, AutoCloseable b) {
        try {
          return combineAutoCloseables(a, b);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "combineAutoCloseables(a,b)";
      }
    }, null, l);
  }

  static public String systemHashCodeHex(Object o) {
    return intToHex(identityHashCode(o));
  }

  static public String shortClassName_dropNumberPrefix(Object o) {
    return dropNumberPrefix(shortClassName(o));
  }

  static public int findEndOfCurlyBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eq(cnc.get(j), "{"))
        ++level;
      else if (eq(cnc.get(j), "}"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public int identityHashCode(Object o) {
    return System.identityHashCode(o);
  }

  static public void minimizeWindow(JFrame f) {
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setState(JFrame.ICONIFIED);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setState(JFrame.ICONIFIED);";
        }
      });
    }
  }

  static public List<String> allClassNamesOnPath(Collection<File> files) {
    List<String> classes = new ArrayList();
    for (File dir : files) classes.addAll(classNamesInJarOrDir(dir));
    return classes;
  }

  static public double sqrt(double x) {
    return Math.sqrt(x);
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public int globalIDLength() {
    return 16;
  }

  static public boolean isSubstanceLAF() {
    return substanceLookAndFeelEnabled();
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static public File appendToFileBaseName(File f, String s) {
    return appendToFileNameBeforeExtension(f, s);
  }

  static public <A> Set<A> synchroLinkedHashSet() {
    return Collections.synchronizedSet(new CompactLinkedHashSet());
  }

  static public JButton jbutton(String text, Object action) {
    return newButton(text, action);
  }

  static public JButton jbutton(String text) {
    return newButton(text, null);
  }

  static public JButton jbutton(Action action) {
    return swingNu(JButton.class, action);
  }

  static public JTextArea jtextarea() {
    return jTextArea();
  }

  static public JTextArea jtextarea(String text) {
    return jTextArea(text);
  }

  static public <A> Matrix<A> listToMatrix_cols(int w, List<A> data) {
    return listToMatrix(w, data);
  }

  static public <A> List<A> addDyn(List<A> l, A a) {
    if (l == null)
      l = new ArrayList();
    l.add(a);
    return l;
  }

  static public <A extends JComponent> A setEnabled(A c, boolean enable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setEnabled(enable);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setEnabled(enable);";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setEnabled(boolean enable, A c) {
    return setEnabled(c, enable);
  }

  static public FunctionCall functionCall(Object fname, Object... args) {
    return new FunctionCall(fname, args);
  }

  static public boolean isInstanceOf(Object o, Class type) {
    return type.isInstance(o);
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public boolean isMarkedAsSrcLib(String snippetID) {
    if (snippetID == null)
      return false;
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return isJavaxCompilableSnippetType(rl.getSnippetType(snippetID));
    return fileExists(javaxCodeDir("srclibs/" + psI(snippetID)));
  }

  static public byte[] intListToByteArray(List<Integer> l) {
    return intListToByteArray_littleEndian(l);
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public JPanel northAndCenter(Component n, Component c) {
    return centerAndNorth(c, n);
  }

  static public <A> Matrix<Matrix<A>> matrixToMNGrid_rows(Matrix<A> m, int rows) {
    if (m == null)
      return null;
    int cols = widthForHeight(m.getWidth(), m.getHeight(), rows);
    return matrixToMNGrid(m, cols, rows);
  }

  static public JPanel jline(final Component... components) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          return new LeftAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new LeftAlignedLine(components);";
      }
    });
  }

  static public <A extends Component> JPanel jline(List<A> components) {
    return jline(asArray(Component.class, components));
  }

  static public ItemListener itemListener(final Object r) {
    return new ItemListener() {

      public void itemStateChanged(ItemEvent e) {
        pcallF(r);
      }
    };
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static public void dm_pointSubmoduleToMe(Object subModule) {
    dm_pointSubmoduleToMe(subModule, dm_current_mandatory_generic());
  }

  static public void dm_pointSubmoduleToMe(Object subModule, Object me) {
    setOpt(subModule, "dm_current_mandatory_generic_value", me);
  }

  static public void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  static public void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public int bwIntegralImage_sumRect(BWIntegralImage img, int x1, int y1, int x2, int y2) {
    int bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    int bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    int topLeft = img.getIIValue(x1 - 1, y1 - 1);
    int topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public int bwIntegralImage_sumRect(IBWIntegralImage img, int x1, int y1, int x2, int y2) {
    int bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    int bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    int topLeft = img.getIIValue(x1 - 1, y1 - 1);
    int topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public double bwIntegralImage_sumRect(IBWIntegralImage img, double x1, double y1, double x2, double y2) {
    double bottomLeft = img.getIIValue(x1 - 1, y2 - 1);
    double bottomRight = img.getIIValue(x2 - 1, y2 - 1);
    double topLeft = img.getIIValue(x1 - 1, y1 - 1);
    double topRight = img.getIIValue(x2 - 1, y1 - 1);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public int intFromBytes_littleEndian_partial(byte[] a, int i) {
    return (ubyteToInt(i + 3 >= a.length ? 0 : a[i + 3]) << 24 | (ubyteToInt(i + 2 >= a.length ? 0 : a[i + 2]) << 16 | (ubyteToInt(i + 1 >= a.length ? 0 : a[i + 1]) << 8 | ubyteToInt(a[i]))));
  }

  static public boolean containsSpace(String s) {
    return containsSpaces(s);
  }

  static public Class<?> hotwireSharingLibraries(String progID) {
    try {
      Pair<File, String> p = CompilerBot.compileSnippet2(progID);
      File jar = p.a;
      assertTrue(f2s(jar), jar.isFile());
      List<File> files = ll(jar);
      String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
      List<File> myLibraries = myLibraryFiles();
      Matcher matcher = Pattern.compile("\\d+").matcher(dehlibs);
      while (matcher.find()) {
        String libID = matcher.group();
        File lib = loadLibrary(libID);
        if (myLibraries.contains(lib)) {
        } else {
          files.add(lib);
        }
      }
      JavaXClassLoaderWithParent classLoader = new JavaXClassLoaderWithParent(progID, files, myClassLoader());
      return hotwire_finish(classLoader, progID, p.b);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htmlencode_forParams_v2(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String forward(String bot, String msg, Object... args) {
    return format("please forward to bot *: *", bot, format(msg, args));
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      Object __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public <A> A assertEquals(Object x, A y) {
    return assertEquals("", x, y);
  }

  static public <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  static public String joinMap(Object f, Iterable l) {
    return join(map(f, l));
  }

  static public String joinMap(Iterable l, Object f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(Iterable<A> l, IF1<A, String> f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(IF1<A, String> f, Iterable<A> l) {
    return join(map(f, l));
  }

  static public <A, B> String joinMap(String separator, Map<A, B> map, IF2<A, B, String> f) {
    return join(separator, map(map, f));
  }

  static public byte[] isJAR_magic = bytesFromHex("504B0304");

  static public boolean isJAR(byte[] data) {
    return byteArrayStartsWith(data, isJAR_magic);
  }

  static public boolean isJAR(File f) {
    return isJAR(loadBeginningOfBinaryFile(f, l(isJAR_magic)));
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public String programTitle() {
    return getProgramName();
  }

  static public <A> WithProbability<A> withProbability(double probability, A a) {
    return new WithProbability(probability, a);
  }

  static public <A> List<WithProbability<A>> withProbability(IF1<A, Double> makeProbability, Iterable<A> l) {
    return map(a -> withProbability(makeProbability.get(a), a), l);
  }

  static public Path toPath(File f) {
    return f == null ? null : f.toPath();
  }

  static public JTextArea jTextAreaWithUndo() {
    return jTextAreaWithUndo("");
  }

  static public JTextArea jTextAreaWithUndo(final String text) {
    return jenableUndoRedo(swingNu(JTextArea.class, text));
  }

  static public Dimension getPreferredSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getPreferredSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getPreferredSize();";
      }
    });
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public String unicode_downPointingTriangle() {
    return charToString(0x25BC);
  }

  static public Window dm_windowIfSingleModule(Object module) {
    Window w = dm_window(module);
    return w == null || w != getWindow(dm_desktopPane()) ? w : null;
  }

  static public int backtick_exitValue;

  static public boolean backtick_verbose, backtick_keepScript;

  static public ThreadLocal<File> backtick_scriptFile = new ThreadLocal();

  static public ThreadLocal<Boolean> backtick_uninterruptable = new ThreadLocal();

  static public boolean backtick_win_cmd = false;

  static public String backtick(String cmd) {
    try {
      ping();
      File outFile = File.createTempFile("_backtick", "");
      backtickToFile(cmd, outFile);
      String result = loadTextFile(outFile.getPath(), "");
      if (backtick_verbose) {
        print("[[\n" + result + "]]");
      }
      outFile.delete();
      return result;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public java.lang.Process backtickToFile(String cmd, File outFile) {
    try {
      try {
        java.lang.Process process = backtickToFile_noWait(cmd, outFile);
        process.waitFor();
        backtick_exitValue = process.exitValue();
        if (backtick_verbose)
          System.out.println("Process return code: " + backtick_exitValue);
        return process;
      } finally {
        if (!backtick_keepScript)
          deleteFile(backtick_scriptFile.get());
        backtick_scriptFile.set(null);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public java.lang.Process backtickToFile_noWait(String cmd, File outFile) {
    try {
      ping();
      File scriptFile;
      String ext = isWindows() ? ".bat" : "";
      if (backtick_keepScript)
        scriptFile = makeFileNameUnique_withExtension(javaxCachesDir("Cmd Scripts/backtick"), ".bat");
      else
        scriptFile = File.createTempFile("_backtick", ext);
      backtick_scriptFile.set(scriptFile);
      if (backtick_verbose)
        print("backtick: scriptFile " + f2s(scriptFile));
      boolean makeInterruptable = !isTrue(backtick_uninterruptable.get()) && !isWindows();
      cmd = trim(cmd);
      if (makeInterruptable && numLines(cmd) > 1)
        throw fail("No multi-line commands allowed when making interruptable");
      String command = cmd + " >" + bashQuote(outFile.getPath()) + " 2>&1";
      if (makeInterruptable)
        command = fixNewLines("\r\ninterruptable() {\r\n\r\n    # handle options\r\n    local setsid=\"\"\r\n    local debug=false\r\n    while true; do\r\n        case \"${1:-}\" in\r\n            --killall)      setsid=setsid; shift ;;\r\n            --debug)        debug=true; shift ;;\r\n            --*)            echo \"Invalid option: $1\" 1>&2; exit 1;;\r\n            *)              break;; # no more options\r\n        esac\r\n    done\r\n\r\n    # start the specified command\r\n    $setsid \"$@\" &\r\n    local child_pid=$!\r\n\r\n    # arrange to propagate a signal to the child process\r\n    trap '\r\n        exec 1>&2\r\n        set +e\r\n        trap \"\" SIGPIPE # ensure a possible sigpipe from the echo does not prevent the kill\r\n        echo \"${BASH_SOURCE[0]} caught SIGTERM while executing $* (pid $child_pid), sending SIGTERM to it\"\r\n        # (race) child may have exited in which case kill will report an error\r\n        # if setsid is used then prefix the pid with a \"-\" to indicate that the signal\r\n        # should be sent to the entire process group\r\n        kill ${setsid:+-}$child_pid\r\n        exit 143\r\n    ' SIGTERM\r\n    # ensure that the trap doesn't persist after we return\r\n    trap 'trap - SIGTERM' RETURN\r\n\r\n    $debug && echo \"interruptable wait (child $child_pid, self $$) for: $*\"\r\n\r\n    # An error status from the child process will trigger an exception (via set -e)\r\n    # here unless the caller is checking the return status\r\n    wait $child_pid # last command, so status of waited for command is returned\r\n}\r\n\r\ninterruptable ") + command;
      if (backtick_verbose) {
        print("backtick: command " + command);
        print("backtick: saving to " + scriptFile.getPath());
      }
      saveTextFile(scriptFile.getPath(), command);
      if (backtick_verbose)
        print("backtick: command length=" + l(command) + ", file length=" + scriptFile.length());
      String[] command2;
      if (isWindows())
        if (backtick_win_cmd)
          command2 = new String[] { "cmd", "/c", scriptFile.getPath() };
        else
          command2 = new String[] { scriptFile.getPath() };
      else
        command2 = new String[] { "/bin/bash", scriptFile.getPath() };
      if (backtick_verbose)
        print("backtick: command2 " + structure(command2));
      return Runtime.getRuntime().exec(command2);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String textOfStandardFunction_uncached(String sfName) {
    return loadSnippet(stdFunctions_uncached().get(sfName));
  }

  static public JCheckBox jLiveValueCheckBox(String text, final SimpleLiveValue<Boolean> lv) {
    final JCheckBox cb = jCheckBox(text);
    bindCheckBoxToLiveValue(cb, lv);
    return cb;
  }

  static public String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5_impl(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  static public byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(File file) {
    return md5OfFile(file);
  }

  static public Border getBorder(final JComponent c) {
    return c == null ? null : swing(new F0<Border>() {

      public Border get() {
        try {
          return c.getBorder();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getBorder();";
      }
    });
  }

  static public <A extends JComponent> A onClick(final A c, final Object runnable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent e) {
                callF(runnable, e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(MouseEv...";
        }
      });
    }
    return c;
  }

  static public void onClick(JButton btn, final Object runnable) {
    onEnter(btn, runnable);
  }

  static public List<GraphicsDevice> screenDevices() {
    return asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices());
  }

  static public boolean isAllUpperCase(String s) {
    return hasLettersAllUpperCase(s);
  }

  static public String getLookAndFeel() {
    return getClassName(UIManager.getLookAndFeel());
  }

  static public <A> List<A> rowToList(Matrix<A> m, int y) {
    if (m == null)
      return null;
    rangeCheck(y, m.getHeight());
    int w = m.getWidth();
    return new RandomAccessAbstractList<A>() {

      public int size() {
        return w;
      }

      public A get(int x) {
        return m.get(x, y);
      }

      public A set(int x, A val) {
        A old = m.get(x, y);
        m.set(x, y, val);
        return old;
      }
    };
  }

  static public boolean allElementsAreOfType(Collection c, Class type) {
    for (Object o : c) if (!isInstanceX(type, o))
      return false;
    return true;
  }

  static public boolean containsUnsafePlatformCmdLineChar(String s) {
    return containsRegexp(s, "[\\|&;<>()\\$`\\\\\"' \t\r\n\\*\\?\\[#~=%]");
  }

  static public String renderFileInfo(File f) {
    return f == null ? "-" : f2s(f) + " " + (f.isFile() ? "(file, " + n2(fileSize(f)) + " bytes)" : f.isDirectory() ? "(dir)" : "(not found)");
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
    final JCheckBoxMenuItem mi = swing(() -> new JCheckBoxMenuItem(text, checked));
    addActionListener(mi, new Runnable() {

      public void run() {
        try {
          callF(r, isChecked(mi));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, isChecked(mi))";
      }
    });
    return mi;
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, IVF1<Boolean> r) {
    return jCheckBoxMenuItem(text, checked, (Object) r);
  }

  static public <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
    mapPut(map, key, value);
    return value;
  }

  static public Lock appendToFile_lock = lock();

  static public boolean appendToFile_keepOpen = false;

  static public HashMap<String, Writer> appendToFile_writers = new HashMap();

  static public void appendToFile(String path, String s) {
    try {
      Lock __0 = appendToFile_lock;
      lock(__0);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  static public void cleanMeUp_appendToFile() {
    AutoCloseable __3 = tempCleaningUp();
    try {
      Lock __1 = appendToFile_lock;
      lock(__1);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__1);
      }
    } finally {
      _close(__3);
    }
  }

  static public String find(String pattern, String text) {
    Matcher matcher = Pattern.compile(pattern).matcher(text);
    if (matcher.find())
      return matcher.group(1);
    return null;
  }

  static public <A> A find(Collection<A> c, Object... data) {
    for (A x : c) if (checkFields(x, data))
      return x;
    return null;
  }

  static public <A extends JTextComponent> A jenableUndoRedo(final A textcomp) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final UndoManager undo = new UndoManager();
            vm_generalWeakSet("Undo Managers").add(undo);
            textcomp.getDocument().addUndoableEditListener(new UndoableEditListener() {

              public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
              }
            });
            textcomp.getActionMap().put("Undo", abstractAction("Undo", new Runnable() {

              public void run() {
                try {
                  if (undo.canUndo())
                    undo.undo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canUndo()) undo.undo()";
              }
            }));
            textcomp.getActionMap().put("Redo", abstractAction("Redo", new Runnable() {

              public void run() {
                try {
                  if (undo.canRedo())
                    undo.redo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canRedo()) undo.redo()";
              }
            }));
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final new UndoManager undo;\r\n    vm_generalWeakSet(\"Undo Managers\").add(undo)...";
        }
      });
    }
    return textcomp;
  }

  static public void setChecked(JCheckBox checkBox, boolean b) {
    if (checkBox != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (isChecked(checkBox) != b)
              checkBox.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (isChecked(checkBox) != b)\r\n      checkBox.setSelected(b);";
        }
      });
    }
  }

  static public void setChecked(JCheckBoxMenuItem mi, boolean b) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setSelected(b);";
        }
      });
    }
  }

  static public String joinPairWithColon(Pair p) {
    return p == null ? "" : str(p.a) + ": " + str(p.b);
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public <A extends JComponent> A setFont(final Font font, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setFont(font);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setFont(font);";
        }
      });
    }
    return a;
  }

  static public <A extends JComponent> A setFont(A a, Font font) {
    return setFont(font, a);
  }

  static public <A extends JComponent> A setFont(final String fontID, float fontSize, final A a) {
    return setFont(loadFont_cached(fontID, fontSize), a);
  }

  static public <A> List<A> syncList() {
    return synchroList();
  }

  static public <A> List<A> syncList(List<A> l) {
    return synchroList(l);
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterator<A> it) {
    if (it == null)
      return null;
    List l = new ArrayList();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    return i == null ? null : takeFirst(n, i.iterator());
  }

  static public <A> List<A> takeFirst(int n, IterableIterator<A> i) {
    return takeFirst(n, (Iterator<A>) i);
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public short[] takeFirst(int n, short[] a) {
    return takeFirstOfShortArray(n, a);
  }

  static public byte[] takeFirst(int n, byte[] a) {
    return takeFirstOfByteArray(n, a);
  }

  static public byte[] takeFirst(byte[] a, int n) {
    return takeFirstOfByteArray(n, a);
  }

  static public double[] takeFirst(int n, double[] a) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public double[] takeFirst(double[] a, int n) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public boolean isEditableComboBox(final JComboBox cb) {
    return cb != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return cb.isEditable();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret cb.isEditable();";
      }
    });
  }

  static public JPanel jrightalignedline(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jrightalignedline(List<Component> components) {
    return jrightAlignedLine(components);
  }

  static public <A, B> String formatColonProperties(Map<A, B> map) {
    return mapToLines(__79 -> joinPairWithColon(__79), mapToPairs(map));
  }

  static public <A, B> String formatColonProperties(List<Pair<A, B>> l) {
    return mapToLines(__80 -> joinPairWithColon(__80), l);
  }

  static public <A, B> String formatColonProperties(Object... params) {
    return formatColonProperties(paramsToPairs(params));
  }

  static volatile public int numberOfCores_value;

  static public int numberOfCores() {
    if (numberOfCores_value == 0)
      numberOfCores_value = Runtime.getRuntime().availableProcessors();
    return numberOfCores_value;
  }

  static public String cleanJavaCompilerOutput(String s) {
    return dropPrefixTrim("Annotation processing got disabled, since it requires a 1.6 compliant JVM", s);
  }

  static public <A extends Window> A showWindow(A w) {
    if (w != null) {
      swing(new Runnable() {

        public void run() {
          try {
            w.setVisible(true);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.setVisible(true);";
        }
      });
    }
    return w;
  }

  static public BigInteger plus(BigInteger a, BigInteger b) {
    return a.add(b);
  }

  static public BigInteger plus(BigInteger a, long b) {
    return a.add(bigint(b));
  }

  static public <A> A optPar_ignoreOddLength(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    for (int i = 0; i + 1 < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optPar_ignoreOddLength(Object[] opt, String name) {
    return optPar_ignoreOddLength(opt, name, null);
  }

  static public Object optPar_ignoreOddLength(String name, Object[] params) {
    return optPar_ignoreOddLength(params, name);
  }

  static public int tok_findEndOfMethodHeader(List<String> tok, int i) {
    i |= 1;
    int level = 0;
    while (i < l(tok)) {
      String t = tok.get(i);
      if (eq(t, "("))
        ++level;
      else if (eq(t, ")"))
        --level;
      else if (level == 0 && eqOneOf(t, "{", ";"))
        return i;
      i += 2;
    }
    return i;
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, IF2<A, B, Boolean> f) {
    if (map == null)
      return null;
    Map<A, B> m2 = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A a = __0.getKey();
      B b = __0.getValue();
      if (f.get(a, b))
        m2.put(a, b);
    }
    return m2;
  }

  static public <A, B> Map<A, B> filterMap(IF2<A, B, Boolean> f, Map<A, B> map) {
    return filterMap(map, f);
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, A... keys) {
    return getMultipleKeys(map, keys);
  }

  static public <A, B> Map<A, B> filterMap(Map<A, B> map, Iterable<A> keys) {
    return getMultipleKeys(map, keys);
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public void dm_watchField(String field, Runnable onChange) {
    new Dyn_FieldWatcher(dm_current_mandatory(), field, onChange);
  }

  static public void fillJPopupMenu(JPopupMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof IVF1)
        callF(o, m);
      else if (o instanceof List)
        fillJPopupMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o))
        m.addSeparator();
      else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem("", y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv!;\r\n        if (isCurlyBracketed(s)) {\r\n          setEnabled(mi,...";
          }
        });
        m.add(mi);
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public JavaXClassLoader hotwire_makeClassLoader(List<File> files) {
    Collection<String> toShare = hotwire_classesToShare();
    return nempty(toShare) ? new JavaXClassLoaderWithParent2(null, files, myClassLoader(), cloneList(toShare)) : new JavaXClassLoader(null, files);
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public int ifloor(double d) {
    return (int) Math.floor(d);
  }

  static public IntRange ifloor(DoubleRange r) {
    return r == null ? null : intRange(ifloor(r.start), ifloor(r.end));
  }

  static public boolean tok_isStaticLevelCode(List<String> tok) {
    return eqOneOf(firstCodeToken(tok), "static", "sclass", "sinterface", "sS", "sO");
  }

  static public boolean tok_isStaticLevelCode(String src) {
    return tok_isStaticLevelCode(javaTok(src));
  }

  static public boolean isUpperCaseLetter(char c) {
    return Character.isUpperCase(c);
  }

  static public String hmsWithColonsAndMS() {
    return hmsWithColonsAndMS(now());
  }

  static public String hmsWithColonsAndMS(long time) {
    return simpleDateFormat_local("HH:mm:ss:SSSS").format(time);
  }

  static public int blend(int x, int y, double yish) {
    double xish = 1 - yish;
    return (int) (x * xish + y * yish);
  }

  static public double blend(double x, double y, double yish) {
    double xish = 1 - yish;
    return x * xish + y * yish;
  }

  static public void scpSet(SingleComponentPanel scp, Component c) {
    setSCPComponent(scp, c);
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta) {
    return enableWordWrapForTextArea(ta, true);
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta, boolean enabled) {
    if (ta != null) {
      swing(new Runnable() {

        public void run() {
          try {
            ta.setLineWrap(enabled);
            ta.setWrapStyleWord(true);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ta.setLineWrap(enabled);\r\n    ta.setWrapStyleWord(true);\r\n    // Haven't foun...";
        }
      });
    }
    return ta;
  }

  static public boolean isSystemThread(Thread t) {
    ThreadGroup g = t.getThreadGroup();
    return g != null && g.getName().equals("system");
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public void tokAppend_reTok(List<String> tok, int i, String s) {
    tok.set(i, tok.get(i) + s);
    reTok(tok, i, i + 1);
  }

  static public JLabel dm_calculatedCenteredLabel(IF0<Object> calc) {
    return dm_centeredCalculatedLabel(calc);
  }

  static public <A> A printHidingCredentials(A o) {
    print(hideCredentials(str(o)));
    return o;
  }

  static public int sqr(int i) {
    return i * i;
  }

  static public long sqr(long l) {
    return l * l;
  }

  static public double sqr(double d) {
    return d * d;
  }

  static public float sqr(float f) {
    return f * f;
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public Component childWithClassNameEndingWith(Component c, String suffix) {
    if (endsWith(className(c), suffix))
      return c;
    Component x;
    for (Component comp : getComponents(c)) if ((x = childWithClassNameEndingWith(comp, suffix)) != null)
      return x;
    return null;
  }

  static public void stepMax(int max, Steppable s) {
    if (s == null)
      return;
    while (max-- > 0 && s.step()) {
      ping();
    }
  }

  static public void stepMax(Steppable s, int max) {
    stepMax(max, s);
  }

  static public String structureForUser(Object o) {
    return beautifyStructure(struct_noStringSharing(o));
  }

  static public String ok(Object o) {
    return format("ok *", o);
  }

  static public <A, B> Map<A, B> mapMinus(Map<A, B> map, Object... keys) {
    if (empty(keys))
      return map;
    Map<A, B> m2 = cloneMap(map);
    for (Object key : keys) m2.remove(key);
    return m2;
  }

  static public String firstCodeToken(String s) {
    return firstJavaToken(s);
  }

  static public String firstCodeToken(List<String> tok) {
    return get(tok, 1);
  }

  static public boolean nohup_debug = false;

  static public boolean nohup_noSlashB = false;

  static public ThreadLocal<Integer> nohup_exitValue = new ThreadLocal();

  public static File nohup(String cmd) {
    try {
      File outFile = File.createTempFile("nohup_" + nohup_sanitize(cmd) + "_", ".out");
      nohup(cmd, outFile, false);
      return outFile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void nohup(String cmd, File outFile, boolean append) {
    try {
      String command = nohup_makeNohupCommand(cmd, outFile, append);
      File scriptFile = File.createTempFile("_realnohup", isWindows() ? ".bat" : "");
      System.out.println("[Nohup] " + command);
      try {
        if (nohup_debug)
          print("[nohup] Script file: " + scriptFile.getPath());
        saveTextFile(scriptFile.getPath(), command);
        String[] command2;
        if (isWindows())
          if (nohup_noSlashB)
            command2 = new String[] { "cmd", "/c", "start", scriptFile.getPath() };
          else
            command2 = new String[] { "cmd", "/c", "start", "/b", scriptFile.getPath() };
        else
          command2 = new String[] { "/bin/bash", scriptFile.getPath() };
        printStruct("[nohup] ", command2);
        Process process = Runtime.getRuntime().exec(command2);
        try {
          process.waitFor();
        } catch (InterruptedException e) {
          throw new RuntimeException(e);
        }
        int value = process.exitValue();
        nohup_exitValue.set(value);
        if (value != 0)
          warn("nohup exit value != 0: " + value);
      } finally {
        if (!isWindows())
          scriptFile.delete();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String nohup_makeNohupCommand(String cmd, File outFile, boolean append) {
    mkdirsForFile(outFile);
    String command;
    if (isWindows())
      command = cmd + (append ? " >>" : " >") + winQuote(outFile.getPath()) + " 2>&1";
    else
      command = "nohup " + cmd + (append ? " >>" : " >") + bashQuote(outFile.getPath()) + " 2>&1 &";
    return command;
  }

  static public Rect pointsRect(int x1, int y1, int x2, int y2) {
    return new Rect(x1, y1, x2 - x1, y2 - y1);
  }

  static public JCheckBox jCheckBox() {
    return swingNu(JCheckBox.class);
  }

  static public JCheckBox jCheckBox(boolean checked) {
    return swingNu(JCheckBox.class, "", checked);
  }

  static public JCheckBox jCheckBox(String text, boolean checked) {
    return swingNu(JCheckBox.class, text, checked);
  }

  static public JCheckBox jCheckBox(String text) {
    return swingNu(JCheckBox.class, text);
  }

  static public JCheckBox jCheckBox(String text, boolean checked, final Object onChange) {
    JCheckBox cb = jCheckBox(checked, onChange);
    cb.setText(text);
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, final Object onChange) {
    final JCheckBox cb = jCheckBox(checked);
    cb.addChangeListener(new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(onChange, cb.isSelected());
      }
    });
    return cb;
  }

  static public void poorMansProfileToConsole(Runnable r) {
    poorMansProfiling();
    try {
      r.run();
    } finally {
      poorMansProfiling_stopAndPrintResults();
    }
  }

  static public int toMS_int(double seconds) {
    return toInt_checked((long) (seconds * 1000));
  }

  static public String jlabel_textAsHTML_center_ifNeeded(String text) {
    if (swic(text, "<html>") && ewic(text, "</html>"))
      return text;
    if (!containsNewLines(text))
      return text;
    return jlabel_textAsHTML_center(text);
  }

  static public List<String> hotwire_libraryIDsFromJar_deleteJarOnFail(File jar) {
    try {
      return hotwire_libraryIDsFromJar(jar);
    } catch (Throwable _e) {
      jar.delete();
      throw rethrow(_e);
    }
  }

  static public IF0 runnableToIF0(Runnable r) {
    return r == null ? null : () -> {
      r.run();
      return null;
    };
  }

  static public Pt rectTopLeftCorner(Rect r) {
    return r == null ? null : pt(r.x, r.y);
  }

  static public <A> Scored<A> scored(A a, float score) {
    return new Scored(a, score);
  }

  static public <A> Scored<A> scored(A a, double score) {
    return new Scored(a, (float) score);
  }

  static public <A> Scored<A> scored(A a, Scored scored) {
    return new Scored(a, getScore(scored));
  }

  static public <A> Scored<A> scored(double score, A a) {
    return scored(a, score);
  }

  static public File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }

  static public <A extends Window> A onWindowClosing(final A w, final Object r) {
    if (w != null) {
      swing(new Runnable() {

        public void run() {
          try {
            w.addWindowListener(new WindowAdapter() {

              public void windowClosing(WindowEvent e) {
                AutoCloseable __1 = tempRememberListener(w, "removeWindowListener", this);
                try {
                  pcallF(r);
                } finally {
                  _close(__1);
                }
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.addWindowListener(new WindowAdapter {\r\n      public void windowClosing(Wind...";
        }
      });
    }
    return w;
  }

  static public List<File> filesEndingWith(File dir, String suffix) {
    return listFilesWithSuffix(dir, suffix);
  }

  static public List<File> filesEndingWith(List<File> l, String suffix) {
    List<File> out = new ArrayList();
    for (File f : unnull(l)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      out.add(f);
    return out;
  }

  static public List<File> filesEndingWith(String suffix, File dir) {
    return filesEndingWith(dir, suffix);
  }

  static public String manifestPathInJar() {
    return "META-INF/MANIFEST.MF";
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public Object[] asArray(List l) {
    return toObjectArray(l);
  }

  static public <A> A[] asArray(Class<A> type, List l) {
    return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
  }

  static public Pt pt(int x, int y) {
    return new Pt(x, y);
  }

  static public Pt pt(int x) {
    return new Pt(x, x);
  }

  static public List mapMethod(Object[] l, final String methodName) {
    return map(l, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(Iterable c, final String methodName) {
    return map(c, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(String methodName, Iterable c) {
    return mapMethod(c, methodName);
  }

  static public List mapMethod(String methodName, Enumeration c) {
    return mapMethod(methodName, enumerationToIterator(c));
  }

  static public JTextArea showText(final String title, Object text) {
    return showText(null, title, text);
  }

  static public JTextArea showText(JTextArea ta, final String title, Object text) {
    final String _text = str(text);
    if (ta != null)
      return activateFrameAndReturnComponent(setFrameTitle(title, setText(ta, _text)));
    return swing(new F0<JTextArea>() {

      public JTextArea get() {
        try {
          JTextArea textArea = newTypeWriterTextArea(_text);
          makeFrame(title, new JScrollPane(textArea));
          return textArea;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextArea textArea = newTypeWriterTextArea(_text);\r\n    makeFrame(title, new ...";
      }
    });
  }

  static public JTextArea showText(Object text) {
    return showText(str(text));
  }

  static public JTextArea showText(String text) {
    return showText(autoFrameTitle(), text);
  }

  static public JTextArea showText() {
    return showText("");
  }

  static public Map convertObjectMetaToMap(IMeta o) {
    return convertObjectMetaToMap(o, () -> synchroLinkedHashMap());
  }

  static public Map convertObjectMetaToMap(IMeta o, IF0<Map> createEmptyMap) {
    if (o == null)
      return null;
    Object meta = o._getMeta();
    if (meta instanceof Map)
      return ((Map) meta);
    var mutex = tempMetaMutex(o);
    try {
      var actualMutex = mutex.get();
      synchronized (actualMutex) {
        meta = o._getMeta();
        if (meta instanceof Map)
          return ((Map) meta);
        Map map = createEmptyMap.get();
        if (meta != null)
          map.put("previousMeta", meta);
        o._setMeta(map);
        return map;
      }
    } finally {
      _close(mutex);
    }
  }

  static public String repSimple(int n, char c) {
    return repeat(c, n);
  }

  static public <A> List<A> repSimple(int n, A a) {
    return repeat(n, a);
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public JPanel infoMessage_makePanel(String text) {
    final JTextArea ta = wrappedTextArea(text);
    onClick(ta, new Runnable() {

      public void run() {
        try {
          disposeWindow(ta);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "disposeWindow(ta)";
      }
    });
    int size = 14;
    if (l(text) <= 50)
      size *= 2;
    else if (l(text) < 100)
      size = iround(size * 1.5);
    ta.setFont(typeWriterFont(size));
    JScrollPane sp = jscroll(ta);
    return withMargin(sp);
  }

  static public void setDefaultClassFinder(Object cf) {
    _defaultClassFinder_value = cf;
  }

  static public int countLines(String s) {
    return l(toLines(s));
  }

  static public boolean isCurlyBracketed(String s) {
    return isCurlyBraced(s);
  }

  static public String intsToHex_withLineBreaks(List<Integer> l) {
    return intsToHex_withLineBreaks(80, l);
  }

  static public String intsToHex_withLineBreaks(int charsPerLine, List<Integer> l) {
    return regularLineBreaks(charsPerLine, intsToHex(l));
  }

  static public ImageSurface doubleBufferedImageSurface_noAlpha() {
    ImageSurface is = doubleBufferedImageSurface();
    is.noAlpha = true;
    return is;
  }

  static public int snippetType_dynModule() {
    return 57;
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final IF0 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __1 = m.enter();
          try {
            return callF(f);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final F0 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __2 = m.enter();
          try {
            return callF(f);
          } finally {
            _close(__2);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, final F1 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          AutoCloseable __3 = m.enter();
          try {
            return callF(f, arg);
          } finally {
            _close(__3);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    ret callF(f, arg);";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, F2 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          if (arg instanceof Object[]) {
            if (((Object[]) arg).length != 2)
              return null;
            AutoCloseable __4 = m.enter();
            try {
              return callF(f, ((Object[]) arg)[0], ((Object[]) arg)[1]);
            } finally {
              _close(__4);
            }
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (arg cast O[]) {\r\n      if (arg.length != 2) null;\r\n      temp m.enter();\r...";
      }
    }));
  }

  static public AutoCloseable dm_vmBus_answerToMessage(String msg, F3 f) {
    final DynModule m = dm_current_mandatory();
    return dm_ownResource(vmBus_addListener_basic(msg, new F2<String, Object, Object>() {

      public Object get(String _msg, Object arg) {
        try {
          if (arg instanceof Object[]) {
            if (((Object[]) arg).length != 3)
              return null;
            AutoCloseable __5 = m.enter();
            try {
              return callF(f, ((Object[]) arg)[0], ((Object[]) arg)[1], ((Object[]) arg)[2]);
            } finally {
              _close(__5);
            }
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (arg cast O[]) {\r\n      if (arg.length != 3) null;\r\n      temp m.enter();\r...";
      }
    }));
  }

  static public <A> A getOrKeep(Map<A, ? extends A> map, A a) {
    if (map == null)
      return a;
    A v = map.get(a);
    return v != null ? v : a;
  }

  static public List<Byte> toByteList(Object o) {
    if (o == null)
      return null;
    if (o instanceof List)
      return ((List) o);
    if (o instanceof Iterable)
      return toList((Iterable) o);
    if (o instanceof byte[])
      return wrapPrimitiveArrayAsImmutableList((byte[]) o);
    throw fail();
  }

  static public String afterDollar(String s) {
    return substring(s, smartIndexOf(s, '$') + 1);
  }

  static public String filterChars(IF1<Character, Boolean> pred, String s) {
    if (empty(s))
      return null;
    int n = l(s), i = 0;
    char c = s.charAt(i);
    boolean totality = pred.get(c);
    for (++i; i < n; i++) {
      c = s.charAt(i);
      boolean b = pred.get(c);
      if (b != totality) {
        StringBuilder buf = new StringBuilder();
        if (totality)
          buf.append(substring(s, 0, i));
        while (true) {
          ping();
          if (b)
            buf.append(c);
          if (++i >= n)
            break;
          c = s.charAt(i);
          b = pred.get(c);
        }
        return buf.toString();
      }
    }
    return totality ? s : "";
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public Object costCenter() {
    return mc();
  }

  static public File getBytecodePathForClass(Object o) {
    return getBytecodePathForClass(_getClass(o));
  }

  static public File getBytecodePathForClass(Class c) {
    try {
      return c == null ? null : new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JPanel smartAdd(JPanel panel, List parts) {
    for (Object o : parts) addToContainer(panel, wrapForSmartAdd(o));
    return panel;
  }

  static public JPanel smartAdd(JPanel panel, Object... parts) {
    return smartAdd(panel, asList(parts));
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    if (src != null)
      dest.addAll(src);
  }

  static public Color gazelle_color2() {
    return awtColor("EEEEEE");
  }

  static public boolean transpileRaw_silent = true;

  static public boolean transpileRaw_useDiskCache = false;

  static public Class transpileRaw_trans;

  static public boolean transpileRaw_mine = true;

  static public boolean transpileRaw_verySilent = false;

  static public boolean transpileRaw_dontCopyFromCreator = false;

  static public Lock transpileRaw_lock = lock();

  static public ThreadLocal<Boolean> transpileRaw_asInclude = new ThreadLocal();

  static public String transpileRaw(String mainJava) {
    return transpileRaw(mainJava, false, transpileRaw_useDiskCache);
  }

  static public String transpileRaw(String mainJava, boolean fragment) {
    return transpileRaw(mainJava, fragment, transpileRaw_useDiskCache);
  }

  static public String transpileRaw(String mainJava, boolean fragment, boolean useDiskCache) {
    mainJava = dropTranslators(mainJava);
    if (!transpileRaw_dontCopyFromCreator)
      transpileRaw_copyFromCreator();
    Lock __0 = transpileRaw_lock;
    lock(__0);
    try {
      File cacheFile = null;
      if (useDiskCache) {
        cacheFile = new File(javaxCodeDir(), "Transpilations/" + uniqueFileNameUsingMD5_80_v2(mainJava) + ".java");
        {
          String __3 = loadTextFile(cacheFile);
          if (!empty(__3))
            return __3;
        }
      }
      AutoCloseable __4 = transpileRaw_verySilent ? null : tempLoadingAnim("Transpiling...");
      try {
        transpileRaw_translator();
        setOpt(transpileRaw_trans, "localStuffOnly", fragment);
        setOpt(transpileRaw_trans, "asInclude", isTrue(transpileRaw_asInclude.get()));
        set(transpileRaw_trans, "mainJava", mainJava);
        set(transpileRaw_trans, "print_byThread", print_byThread);
        if (!transpileRaw_verySilent)
          print("Running translator " + getOpt(transpileRaw_trans, "programID"));
        callMain(transpileRaw_trans);
        String main = (String) (get(transpileRaw_trans, "mainJava"));
        if (useDiskCache) {
          saveTextFile(new File(cacheFile.getPath() + "x"), mainJava);
          saveTextFile(cacheFile, main);
        }
        return main;
      } finally {
        _close(__4);
      }
    } finally {
      unlock(__0);
    }
  }

  static public Class transpileRaw_translator() {
    if (transpileRaw_trans == null) {
      transpileRaw_trans = hotwireSharingLibraries_silently(defaultJavaXTranslatorID());
      transpileRaw_mine = true;
      makeDependent(transpileRaw_trans);
    }
    setOpt(transpileRaw_trans, "print_silent", transpileRaw_silent);
    return transpileRaw_trans;
  }

  static public void transpileRaw_copyFromCreator() {
    Lock __1 = transpileRaw_lock;
    lock(__1);
    try {
      if (transpileRaw_trans != null)
        return;
      Object c = creator();
      if (c == null)
        return;
      Class trans = (Class) (getOpt(c, "transpileRaw_trans"));
      Lock lock = (Lock) (getOpt(c, "transpileRaw_lock"));
      if (trans != null && lock != null) {
        print("Using creator's transpiler: " + getProgramID(c) + " => " + programID());
        transpileRaw_lock = lock;
        transpileRaw_trans = trans;
        transpileRaw_mine = false;
      }
    } finally {
      unlock(__1);
    }
  }

  static public void cleanMeUp_transpileRaw() {
    if (transpileRaw_mine)
      cleanUp(transpileRaw_trans);
    transpileRaw_trans = null;
  }

  static public <A, B> B rCallF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A> void rCallF(A a, IVF1<A> f) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public void installWindowResizeDraggerOnBorder(JComponent c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            new WindowResizeDragger(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "new WindowResizeDragger(c);";
        }
      });
    }
  }

  static public String linesLL(Object... x) {
    return lines(ll(x));
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public <A> A safeGet(List<A> l, int i) {
    return i >= 0 && i < l(l) ? l.get(i) : null;
  }

  static public void clearTokens_reTok(List<String> tok, int i, int j) {
    clearTokens(tok, i, j);
    reTok(tok, i, j);
  }

  static public <A> int sortedSet_compare(SortedSet<A> set, A a, A b) {
    return compareWithComparator(set.comparator(), a, b);
  }

  static public void stepForNSeconds(double timeout, Steppable s) {
    stepAllWithTimeout(timeout, s);
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public boolean javaCompileToJar_useRAMDisk = false;

  static public ThreadLocal<List<File>> javaCompileToJar_localLibraries = new ThreadLocal();

  static public ThreadLocal<IVF1<File>> javaCompileToJar_addMoreFiles = new ThreadLocal();

  static public File javaCompileToJar_optionalRename(String src, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, "", destJar, progIDForRename);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, dehlibs, destJar, progIDForRename, null);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename, String progID) {
    String javaTarget = null;
    String dummyClass = "main";
    if (progIDForRename != null) {
      dummyClass = dummyMainClassName(progIDForRename);
      src += "\nclass " + dummyClass + "{}";
    }
    String md5 = md5(src);
    File jar = destJar;
    Class j = getJavaX();
    if (javaTarget != null)
      setOpt(j, "javaTarget", javaTarget);
    File srcDir = tempDir();
    String fileName = dummyClass + ".java";
    List<String> tok = javaTok(src);
    String packageName = tok_packageName(tok);
    if (packageName != null)
      fileName = packageName.replace(".", "/") + "/" + tok_firstClassName(tok) + ".java";
    File mainJava = new File(srcDir, fileName);
    saveTextFile(mainJava, src);
    File classesDir = javaCompileToJar_useRAMDisk ? tempDirPossiblyInRAMDisk() : tempDir();
    try {
      List<File> libraries = cloneList(getAndClearTL(javaCompileToJar_localLibraries));
      Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
      while (m.find()) {
        String libID = m.group();
        assertTrue(isSnippetID(libID));
        print("Adding library " + libID);
        libraries.add(loadLibraryOrSrcLib(libID));
      }
      libraries.add(pathToJavaxJar());
      String compilerOutput;
      try {
        compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
      } catch (Throwable e) {
        compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
        compilerOutput = indentx("> ", cleanJavaCompilerOutput(compilerOutput));
        if (!swic(e.getMessage(), "Java compiler returned errors."))
          compilerOutput = appendWithNewLine(compilerOutput, str(e));
        throw fail(compilerOutput, e);
      }
      compilerOutput = cleanJavaCompilerOutput("Annotation processing got disabled, since it requires a 1.6 compliant JVM");
      if (nempty(compilerOutput)) {
        print("Compiler said: " + compilerOutput);
      }
      if (!anyFileWithExtensionInDir(classesDir, ".class")) {
        printWithIndent("SRC> ", src);
        throw fail("No classes generated (was compiling " + nChars(src) + ")");
      }
      saveTextFile(new File(classesDir, "main.java"), src);
      if (nempty(dehlibs))
        saveTextFile(new File(classesDir, "libraries"), dehlibs);
      saveTextFile(new File(classesDir, "progID"), progID);
      callF(javaCompileToJar_addMoreFiles.get(), classesDir);
      dir2zip_recurse_verbose = false;
      int n = dir2zip_recurse(classesDir, jar);
      return jar;
    } finally {
      if (isInRAMDisk(classesDir))
        deleteDirectory(classesDir);
    }
  }

  static public File getCachedTranspilationFile(String id) {
    return newFile(getCodeProgramDir(id), "Transpilation");
  }

  static public void _initFrame(JFrame f) {
    myFrames_list.put(f, Boolean.TRUE);
    standardTitlePopupMenu(f);
  }

  static public <A> List<A> minus(Collection<A> a, Object... b) {
    Set set = asSet(b);
    List l = new ArrayList();
    for (Object s : unnull(a)) if (!set.contains(s))
      l.add(s);
    return l;
  }

  static public BigInteger minus(BigInteger a, BigInteger b) {
    return a.subtract(b);
  }

  static public Complex minus(Complex c) {
    return c == null ? null : complex(-c.re(), -c.im());
  }

  static public <A> A printWithIndent(A o) {
    return printIndent(o);
  }

  static public <A> A printWithIndent(String indent, A o) {
    return printIndent(indent, o);
  }

  static public void printWithIndent(int indent, Object o) {
    printIndent(indent, o);
  }

  static public <A> boolean hasElementWithClassShortNamed(String shortName, Iterable<A> l) {
    return firstWithClassShortNamed(shortName, l) != null;
  }

  static public <A> boolean hasElementWithClassShortNamed(String shortName, A[] l) {
    return firstWithClassShortNamed(shortName, l) != null;
  }

  static public <A> List<A> syncAddOrCreate(List<A> l, A a) {
    if (l == null)
      l = syncList();
    l.add(a);
    return l;
  }

  static public void tokPrepend(List<String> tok, String s) {
    tokPrepend(tok, 0, s);
  }

  static public void tokPrepend(List<String> tok, int i, String s) {
    tok.set(i, s + tok.get(i));
  }

  static public <A, B> List<A> keysList(Map<A, B> map) {
    return cloneListSynchronizingOn(keys(map), map);
  }

  static public <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

  static public boolean containsReturnWithArgument(List<String> tok) {
    for (int i = 1; i + 2 < l(tok); i += 2) {
      String t = tok.get(i);
      if (eqOneOf(t, "ret", "return") && neqOneOf(tok.get(i + 2), ";", "if", "unless", "with"))
        return true;
      if (eqOneOf(t, "embedded", "class") && isIdentifier(get(tok, i + 2)))
        i = tok_findEndOfMethodDecl(tok, i) - 1;
      if (eqOneOf(t, "r", ">") && eqGet(tok, i + 2, "{"))
        i = findEndOfBlock(tok, i + 2) - 1;
    }
    return false;
  }

  static public boolean containsReturnWithArgument(String code) {
    return containsReturnWithArgument(javaTok(code));
  }

  static public String fileNameEncode_safeChars = " ";

  static public String fileNameEncode(String s) {
    s = dropLeadingDots(s);
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (contains(fileNameEncode_safeChars, c))
        buf.append(c);
      else
        buf.append(urlencode(str(c)));
    }
    return str(buf);
  }

  static public AutoCloseable tempHoldInstance(Object o) {
    return holdInstance(o);
  }

  static public String getSnippetTitleOpt(String s) {
    try {
      return isSnippetID(s) ? getSnippetTitle(s) : s;
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return s;
  }

  static public <A> List<A> reversedList(Iterable<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public int getScreenHeight() {
    return getScreenSize().height;
  }

  static public List<Integer> byteArrayToIntList_littleEndian(byte[] a) {
    if (a == null)
      return null;
    int n = (a.length + 3) / 4;
    return new RandomAccessAbstractList<Integer>() {

      public int size() {
        return n;
      }

      public Integer get(int i) {
        return intFromBytes_littleEndian_partial(a, i * 4);
      }

      public Integer set(int i, Integer val) {
        Integer old = get(i);
        if ((int) old != (int) val)
          intToBytes_inArray_littleEndian_partial(val, a, i * 4);
        return old;
      }
    };
  }

  static public void dm_ownTimer(Object resource, Object closerHelper) {
    call(dm_current_generic(), "ownTimer", resource, closerHelper);
  }

  static public <A> A dm_ownTimer(A resource) {
    call(dm_current_generic(), "ownTimer", resource);
    return resource;
  }

  static public <A> void dm_ownTimer(IVF1<A> closerHelper, A resource) {
    dm_ownTimer(resource, closerHelper);
  }

  static public long ratio(long x, long y) {
    return y == 0 ? 0 : x / y;
  }

  static public double ratio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public IterableIterator<Integer> countIterator(int b) {
    return countIterator(0, b);
  }

  static public IterableIterator<Integer> countIterator(int a, int b) {
    return countIterator_exclusive(a, b);
  }

  static public <A> IterableIterator<A> countIterator(int b, IF1<Integer, A> f) {
    return countIterator(0, b, f);
  }

  static public <A> IterableIterator<A> countIterator(int a, int b, IF1<Integer, A> f) {
    return countIterator_exclusive(a, b, f);
  }

  static public IterableIterator<Integer> countIterator(int a, int b, int step) {
    return countIterator_exclusive_step(a, b, step);
  }

  static public <A> IterableIterator<A> countIterator(double a, double b, double step, IF1<Double, A> f) {
    return countIterator_exclusive_step(a, b, step, f);
  }

  static public <A> IterableIterator<Double> countIterator(double a, double b, double step) {
    return countIterator_exclusive_step(a, b, step);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Double, A> f, double a, double b, double step) {
    return countIterator(a, b, step, f);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Integer, A> f, int b) {
    return countIterator(f, 0, b);
  }

  static public <A> IterableIterator<A> countIterator(IF1<Integer, A> f, int a, int b) {
    return countIterator_exclusive(a, b, f);
  }

  static public PopupMenu makePopupMenu(Object... x) {
    if (x == null)
      return null;
    if (l(x) == 1 && x[0] instanceof PopupMenu)
      return (PopupMenu) x[0];
    PopupMenu m = new PopupMenu();
    for (int i = 0; i < l(x); i++) {
      Object o = x[i];
      if (eqOneOf(o, "***", "---", "===", ""))
        m.addSeparator();
      else if (o instanceof String && get(x, i + 1) instanceof Runnable)
        m.add(menuItem((String) o, get(x, ++i)));
      else if (o instanceof String || o instanceof Menu || o instanceof MenuItem)
        call(m, "add", o);
      else
        print("Unknown menu item: " + o);
    }
    return m;
  }

  static public List<String> methodsStartingWith(Object o, final String prefix) {
    return filter(allMethodNames(o), new F1<String, Object>() {

      public Object get(String s) {
        try {
          return startsWith(s, prefix);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startsWith(s, prefix)";
      }
    });
  }

  static public short[] subShortArray(short[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new short[0];
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  static public boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public boolean isNaN(double d) {
    return Double.isNaN(d);
  }

  static public boolean isNaN(float f) {
    return Float.isNaN(f);
  }

  static public void fillRect(BufferedImage image, int x, int y, int w, int h, Color color) {
    Graphics2D g = imageGraphics(image);
    fillRect(g, x, y, w, h, color);
    g.dispose();
  }

  static public void fillRect(Graphics g, int x, int y, int w, int h, Color color) {
    g.setColor(color);
    g.fillRect(x, y, w, h);
  }

  static public void fillRect(int x, int y, int w, int h, Color color) {
    fillRect(currentImage(), x, y, w, h, color);
  }

  static public void fillRect(Rect r, Color color) {
    fillRect(r.x, r.y, r.w, r.h, color);
  }

  static public void fillRect(BufferedImage image, Rect r, Color c) {
    if (r != null)
      fillRect(image, r.x, r.y, r.w, r.h, c);
  }

  static public void fillRect(Graphics g, Rect r, Color c) {
    if (r != null)
      fillRect(g, r.x, r.y, r.w, r.h, c);
  }

  static public int[] resizeIntArray(int[] a, int n) {
    if (n == lIntArray(a))
      return a;
    int[] b = new int[n];
    arraycopy(a, 0, b, 0, Math.min(lIntArray(a), n));
    return b;
  }

  static public JPanel westCenterAndEastWithMargin(Component w, Component c, Component e) {
    return westCenterAndEast(w, withLeftAndRightMargin(c), e);
  }

  static public <A> A lookupDynamicInterface(Class<A> intrface, Object o) {
    if (o instanceof DynamicObject) {
      A a = (A) (mapGet((Map) ((DynamicObject) o).fieldValues, intrface));
      if (a != null)
        return a;
    }
    if (isInstance(intrface, o))
      return (A) o;
    return null;
  }

  static public <A> A lookupDynamicInterface(Object o, Class<A> intrface) {
    return lookupDynamicInterface(intrface, o);
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String getSelectedItem(JList l) {
    return (String) l.getSelectedValue();
  }

  static public String getSelectedItem(JComboBox cb) {
    return strOrNull(cb.getSelectedItem());
  }

  static public double elapsedSeconds_timestamp(long time) {
    return toSeconds(now() - time);
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public int loadAllClassesInByteCodePath(File path) {
    int n = 0;
    for (String name : allClassNamesOnPath(ll(path))) try {
      Class.forName(name);
      ++n;
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
    return n;
  }

  static public <A extends Component> A activateFrameAndReturnComponent(A c) {
    activateFrame(c);
    return c;
  }

  static public short[] takeFirstOfShortArray(short[] b, int n) {
    return subShortArray(b, 0, n);
  }

  static public short[] takeFirstOfShortArray(int n, short[] b) {
    return takeFirstOfShortArray(b, n);
  }

  static public boolean tok_shouldAddReturn(List<String> tok) {
    String lastToken = get(tok, l(tok) - 2);
    if (eqOneOf(lastToken, ";", null))
      return false;
    if (eq(lastToken, "}")) {
      int i = findBeginningOfBlock(tok, l(tok) - 2);
      return eqGet(tok, i - 4, "-") && eqGet(tok, i - 3, "") && eqGet(tok, i - 2, ">");
    }
    return true;
  }

  static public boolean tok_shouldAddReturn(String s) {
    return tok_shouldAddReturn(javaTok(s));
  }

  static public JLabel dm_centeredFieldLabel(String fieldName) {
    return centerLabel(dm_fieldLabel(fieldName));
  }

  static public String ymd_minus_hms() {
    return ymd() + "-" + hms();
  }

  static public boolean isChecked(JCheckBox checkBox) {
    return checkBox != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return checkBox.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret checkBox.isSelected();";
      }
    });
  }

  static public boolean isChecked(JCheckBoxMenuItem mi) {
    return mi != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return mi.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mi.isSelected();";
      }
    });
  }

  static public boolean isChecked(JRadioButton rb) {
    return rb != null && (boolean) swing(() -> rb.isSelected());
  }

  static public JButton jPopDownButton(String text, final Object... menuParams) {
    return jbutton((empty(text) ? "" : text + " ") + unicode_downPointingTriangle(), new Runnable() {

      public void run() {
        try {
          JPopupMenu menu = new JPopupMenu();
          int emptyCount = menu.getComponentCount();
          String position = (String) (optPar_ignoreOddLength("position", menuParams));
          fillJPopupMenu(menu, paramsWithout(menuParams, "position"));
          if (menu.getComponentCount() != emptyCount) {
            JButton btn = heldInstance(JButton.class);
            int x = 0;
            if (eq(position, "center"))
              x = (btn.getWidth() - getPreferredWidth(menu)) / 2;
            else if (eq(position, "right"))
              x = btn.getWidth() - getPreferredWidth(menu);
            menu.show(btn, x, btn.getHeight());
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JPopupMenu menu;\r\n    int emptyCount = menu.getComponentCount();\r\n    Str...";
      }
    });
  }

  static public void innerCleanUp(Object c) {
    if (!isFalse(pcallOpt(c, "cleanMeUp")))
      for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
        callOpt(c, name);
      } catch (Throwable e) {
        print("Error cleaning up: " + programID(c));
        _handleException(e);
      }
  }

  static public void innerCleanUp() {
    innerCleanUp(mc());
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Map similarEmptyMap(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeMap(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Object getMC(String field) {
    return get(mc(), field);
  }

  static public File toFile(Object o) {
    if (o instanceof File)
      return (File) o;
    if (o instanceof String)
      return new File((String) o);
    throw fail("Not a file: " + o);
  }

  static public byte[] gunzipBytes(byte[] data) {
    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      copyStreamAndCloseAll(newGZIPInputStream(new ByteArrayInputStream(data)), baos);
      return baos.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a) {
    if (a == null)
      return null;
    return intArrayToList(a, 0, a.length);
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a, int from, int to) {
    if (a == null)
      return null;
    ArrayList<Integer> l = new ArrayList<>(to - from);
    for (int i = from; i < to; i++) l.add(a[i]);
    return l;
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public int snippetType_JavaXDesktop() {
    return 55;
  }

  static public void intToBytes_inArray_littleEndian_partial(int i, byte[] array, int idx) {
    if (idx < array.length)
      array[idx] = (byte) i;
    if (idx + 1 < array.length)
      array[idx + 1] = (byte) (i >>> 8);
    if (idx + 2 < array.length)
      array[idx + 2] = (byte) (i >>> 16);
    if (idx + 3 < array.length)
      array[idx + 3] = (byte) (i >>> 24);
  }

  static public File compilerBotDestDir() {
    return actualUserDir(compilerBotDestDirSubName());
  }

  static public File compilerBotDestDir(String sub) {
    return newFile(compilerBotDestDir(), sub);
  }

  static public Object metaMapGet(IMeta o, Object key) {
    return o == null ? null : o.metaGet(key);
  }

  static public Object metaMapGet(Object o, Object key) {
    if (o instanceof IMeta)
      return metaMapGet(((IMeta) o), key);
    return null;
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public void standardTitlePopupMenu(final JFrame frame) {
    if (!isSubstanceLAF())
      return;
    titlePopupMenu(frame, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          boolean alwaysOnTop = frame.isAlwaysOnTop();
          menu.add(jmenuItem("Restart Program", "restart"));
          menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
          menu.add(jmenuItem("Show Console", "showConsole"));
          menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() {

            public void run() {
              try {
                toggleAlwaysOnTop(frame);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "toggleAlwaysOnTop(frame)";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n    ifndef standardTitlePopupMenu_...";
      }
    });
  }

  static public <A> AutoCloseable tempAdd(final Collection<A> l, final A a) {
    if (l == null || l.contains(a))
      return null;
    l.add(a);
    return new AutoCloseable() {

      public String toString() {
        return "l.remove(a);";
      }

      public void close() throws Exception {
        l.remove(a);
      }
    };
  }

  static public String loadProgramTextFile(String name) {
    return loadTextFile(getProgramFile(name));
  }

  static public String loadProgramTextFile(String progID, String name) {
    return loadTextFile(getProgramFile(progID, name));
  }

  static public String loadProgramTextFile(String progID, String name, String defaultText) {
    return loadTextFile(getProgramFile(progID, name), defaultText);
  }

  static public String mcName() {
    return mc().getName();
  }

  static public void onMouseDown(Component c, Object r) {
    if (c != null && r != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1)
                  pcallF(r);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mousePressed(MouseEv...";
        }
      });
    }
  }

  static public MouseAdapter onMouseDown(Component c, IVF1<MouseEvent> f) {
    return c == null || f == null ? null : swing(() -> {
      MouseAdapter ma = new MouseAdapter() {

        public void mousePressed(MouseEvent e) {
          if (e.getButton() == MouseEvent.BUTTON1)
            f.get(e);
        }
      };
      c.addMouseListener(ma);
      return ma;
    });
  }

  static public <A> AutoCloseable tempDisposeWindow(final Window w) {
    return new AutoCloseable() {

      public void close() {
        disposeWindow(w);
      }
    };
  }

  static public Cache<Boolean> isLinux_cache = new Cache<>(() -> isLinux_load());

  static public boolean isLinux() {
    return isLinux_cache.get();
  }

  static public Boolean isLinux_load() {
    return !isWindows() && !isMac() && !isAndroid();
  }

  static public boolean checkFields(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public <A> IterableIterator<A> iff(Object f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public IterableIterator iff(F0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public <A> IterableIterator iff(IF0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public JWindow makeWindow(final Component c) {
    return swing(new F0<JWindow>() {

      public JWindow get() {
        try {
          JWindow w = new JWindow();
          w.add(wrap(c));
          return w;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JWindow w;\r\n    w.add(wrap(c));\r\n    ret w;";
      }
    });
  }

  static public int pixelCount(BufferedImage img) {
    return img == null ? 0 : img.getWidth() * img.getHeight();
  }

  static public <A> F0<A> if0ToF0(IF0<A> f) {
    return f == null ? null : new F0<A>() {

      public A get() {
        try {
          return f.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.get();";
      }
    };
  }

  static public <A, B> A pairA(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public void autoVMExit() {
    call(getJavaX(), "autoVMExit");
  }

  static public File appendToBaseName(File f, String s) {
    return appendToFileNameBeforeExtension(f, s);
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public <A> Chain<A> dropFirst(Chain<A> c) {
    return c == null ? null : c.next;
  }

  static volatile public PersistableThrowable _handleException_lastException;

  static public List _handleException_onException = synchroList(ll((IVF1<Throwable>) (__1 -> printStackTrace2(__1))));

  static public boolean _handleException_showThreadCancellations = false;

  static public void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException) {
      if (_handleException_showThreadCancellations)
        System.out.println(getStackTrace_noRecord(e2));
      return;
    }
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      try {
        printStackTrace2(e3);
      } catch (Throwable e4) {
        System.out.println(getStackTrace(e3));
        System.out.println(getStackTrace(e4));
      }
    }
  }

  static public <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  static public <A> A waitForVarToBeNotNull(Var<A> v) {
    try {
      synchronized (v) {
        while (!v.has()) v.wait();
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String nClasses(long n) {
    return n2(n, "class", "classes");
  }

  static public String nClasses(Collection l) {
    return nClasses(l(l));
  }

  static public String nClasses(Map map) {
    return nClasses(l(map));
  }

  static public String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  static public int mod(int n, int m) {
    return (n % m + m) % m;
  }

  static public long mod(long n, long m) {
    return (n % m + m) % m;
  }

  static public BigInteger mod(BigInteger n, int m) {
    return n.mod(bigint(m));
  }

  static public double mod(double n, double m) {
    return (n % m + m) % m;
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public <A> A lookupInterface(Class<A> intrface, Object o) {
    return lookupDynamicInterface(intrface, o);
  }

  static public <A> A lookupInterface(Object o, Class<A> intrface) {
    return lookupDynamicInterface(o, intrface);
  }

  static public String inputStreamToString(InputStream in) {
    return utf8streamToString(in);
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public String squareBracketed(String s) {
    return "[" + s + "]";
  }

  static public JFrame makeUndecoratedFrame(String title, Object content) {
    return swing(() -> {
      JFrame frame = new JFrame(title);
      frame.setUndecorated(true);
      Component wrapped = wrap(content);
      if (wrapped != null)
        frame.getContentPane().add(wrapped);
      frame.setBounds(defaultNewFrameBounds());
      return frame;
    });
  }

  static public JPanel centerAndEastWithMarginInbetween(Component c, final Component e) {
    return centerAndEast(c, withLeftMargin(e));
  }

  static public int seconds() {
    return seconds(Calendar.getInstance());
  }

  static public int seconds(Calendar c) {
    return c.get(Calendar.SECOND);
  }

  static public boolean regexpFinds(String pat, String s) {
    return regexp(pat, s).find();
  }

  static public boolean regexpFinds(Pattern pat, String s) {
    return regexp(pat, s).find();
  }

  static public boolean isLocalSnippet(String snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public boolean isLocalSnippet(long snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  static public boolean useDummyMainClasses() {
    return true;
  }

  static public boolean longIsInt(long l) {
    return l == (int) l;
  }

  static public byte[] subByteArray(byte[] b, int start) {
    return subByteArray(b, start, l(b));
  }

  static public byte[] subByteArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subByteArray(byte[] b, IntRange r) {
    return r == null ? null : subByteArray(b, r.start, r.end);
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        Object __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      Object __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public RuntimeException quickFail() {
    throw new QuickException("fail");
  }

  static public RuntimeException quickFail(Throwable e) {
    throw asQuickException(e);
  }

  static public RuntimeException quickFail(Object msg) {
    throw new QuickException(String.valueOf(msg));
  }

  static public RuntimeException quickFail(String msg) {
    throw new QuickException(unnull(msg));
  }

  static public RuntimeException quickFail(String msg, Throwable innerException) {
    throw new QuickException(msg, innerException);
  }

  static public boolean isJavaXClassLoader(ClassLoader cl) {
    return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public double nanosToSeconds(double nanos) {
    return nanoSecondsToSeconds(nanos);
  }

  static public boolean anyFileWithExtensionInDir(File dir, String ext) {
    return nempty(filesWithExtension(ext, findAllFiles_noDirs(dir)));
  }

  static public String readerToString(Reader r) {
    try {
      if (r == null)
        return null;
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void drawIntMatrix(BufferedImage g, Matrix<Integer> m, int x, int y) {
    drawIntMatrix(graphics(g), m, x, y);
  }

  static public void drawIntMatrix(Graphics2D g, Matrix<Integer> m, int x, int y) {
    if (g == null || m == null)
      return;
    drawImage(g, matrixToImage(m), x, y);
  }

  static public void dm_toggleAlwaysOnTop() {
    if (dm_moduleIsPoppedOut()) {
      boolean aot = !isTrue(dm_getFlag("ALWAYSONTOPWHENPOPPEDOUT"));
      dm_setFlag("ALWAYSONTOPWHENPOPPEDOUT", aot);
      alwaysOnTop(dm_windowIfSingleModule(dm_current_generic()), aot);
    }
  }

  static public String joinNemptiesWithDot(Object... strings) {
    return joinNempties(".", strings);
  }

  static public String joinNemptiesWithDot(Iterable strings) {
    return joinNempties(".", strings);
  }

  static public Map<String, String> humanizeFormLabel_replacements = litmap("id", "ID", "md5", "MD5");

  static public String humanizeFormLabel(String s) {
    if (containsSpace(s))
      return s;
    return firstToUpper(joinWithSpace(replaceElementsUsingMap(splitCamelCase(s), humanizeFormLabel_replacements)).replace("I D", "ID"));
  }

  static public java.util.Timer doLater_daemon(long delay, final Object r) {
    final java.util.Timer timer = new java.util.Timer(true);
    timer.schedule(timerTask(r, timer), delay);
    return timer;
  }

  static public java.util.Timer doLater_daemon(double delaySeconds, final Object r) {
    return doLater_daemon(toMS(delaySeconds), r);
  }

  static public Set<String> hotwire_classesToShare = synchroSet();

  static public Set<String> hotwire_classesToShare() {
    return hotwire_classesToShare;
  }

  static public GrabbableIntPixels grabbableIntPixels_fastOrSlow(BufferedImage image) {
    try {
      try {
        GrabbableIntPixels gp = grabbableIntPixels(image);
        if (gp != null)
          return gp;
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
      int w = image.getWidth(), h = image.getHeight();
      int[] data = new int[w * h];
      PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, w, h, data, 0, w);
      if (!pixelGrabber.grabPixels())
        throw fail("Could not grab pixels");
      return new GrabbableIntPixels(data, w, h, 0, w);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int countPred(Iterable c, Object pred) {
    return nfilter(c, pred);
  }

  static public int countPred(Object pred, Iterable c) {
    return nfilter(pred, c);
  }

  static public <A> int countPred(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(c, pred);
  }

  static public BWImage scaleDownUsingIntegralImageBW(int w, BWIntegralImage img) {
    return scaleDownUsingIntegralImageBW(img, w);
  }

  static public BWImage scaleDownUsingIntegralImageBW(BWIntegralImage img, int w) {
    return scaleDownUsingIntegralImageBW(img, w, iround(w * img.h / (double) img.w));
  }

  static public BWImage scaleDownUsingIntegralImageBW(BWIntegralImage img, int w, int h) {
    int w1 = img.w, h1 = img.h;
    BWImage out = new BWImage(w, h);
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int area = (x2 - x1) * (y2 - y1);
      int pixel = bwIntegralImage_sumRect(img, x1, y1, x2, y2) / area;
      out.setByte(x, y, (byte) pixel);
    }
    return out;
  }

  static public BWImage scaleDownUsingIntegralImageBW(IBWIntegralImage img, int w) {
    return scaleDownUsingIntegralImageBW(img, w, iround(w * img.getHeight() / (double) img.getWidth()));
  }

  static public BWImage scaleDownUsingIntegralImageBW(IBWIntegralImage img, int w, int h) {
    int w1 = img.getWidth(), h1 = img.getHeight();
    BWImage out = new BWImage(w, h);
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int x1 = x * w1 / w, x2 = max(x1 + 1, (x + 1) * w1 / w);
      int y1 = y * h1 / h, y2 = max(y1 + 1, (y + 1) * h1 / h);
      int area = (x2 - x1) * (y2 - y1);
      int pixel = bwIntegralImage_sumRect(img, x1, y1, x2, y2) / area;
      out.setByte(x, y, (byte) pixel);
    }
    return out;
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public RuntimeException augmentException(Throwable e, Object... info) {
    return new Fail(e, info);
  }

  static public String dummyMainClassName(String progID) {
    return "m" + psI(progID);
  }

  static public void printExceptionShort(Throwable e) {
    printExceptionShort("", e);
  }

  static public void printExceptionShort(String prefix, Throwable e) {
    print(prefix, exceptionToStringShort(e));
  }

  static public void printWithMSTime(String s) {
    print(hmsWithColonsAndMS() + ": " + s);
  }

  static public void close_pcall(AutoCloseable c) {
    if (c != null) {
      try {
        c.close();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public Component wrapForSmartAdd(Object o) {
    if (o == null)
      return jpanel();
    if (o instanceof String)
      return jlabel((String) o);
    return wrap(o);
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc) {
    return parseStdFunctionsList(snippetSrc, new LinkedHashMap());
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc, Map<String, String> map) {
    List<String> tok = javaTok(snippetSrc);
    int i = findCodeTokens(tok, "standardFunctions", "=", "litlist", "(");
    int opening = i + 6;
    int closing = indexOf(tok, ")", opening) - 1;
    for (i = opening + 2; i < closing; i += 4) {
      String[] f = unquote(tok.get(i)).split("/");
      map.put(f[1], f[0]);
    }
    return map;
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public String autoFrameTitle_value;

  static public String autoFrameTitle() {
    return autoFrameTitle_value != null ? autoFrameTitle_value : getProgramTitle();
  }

  static public void autoFrameTitle(Component c) {
    setFrameTitle(getFrame(c), autoFrameTitle());
  }

  static public JPanel westCenterAndEast(Component w, Component c, Component e) {
    JPanel panel = new JPanel(new BorderLayout());
    panel.add(BorderLayout.WEST, wrap(w));
    panel.add(BorderLayout.CENTER, wrap(c));
    panel.add(BorderLayout.EAST, wrap(e));
    return panel;
  }

  static public boolean hasLock(Lock lock) {
    return ((ReentrantLock) lock).isHeldByCurrentThread();
  }

  static public void scaffoldCalled(Object obj, Object function, Object... args) {
    printShortenedFunctionCall(100, (obj == null ? "" : obj + " :: ") + function, args);
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public boolean trayIcon_imageAutoSize = true;

  static public TrayIcon installTrayIcon(String imageID, String tooltip) {
    return installTrayIcon(imageID, tooltip, null);
  }

  static public TrayIcon installTrayIcon(String imageID, String tooltip, Object... menuItems) {
    try {
      if (!isSnippetID(imageID) && isSnippetID(tooltip)) {
        String s = tooltip;
        tooltip = imageID;
        imageID = s;
      }
      Image image = loadImage2(imageID);
      return installTrayIcon(image, tooltip, menuItems);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TrayIcon installTrayIcon(final Image image, final String tooltip, final Object... _menuItems) {
    try {
      return swing(new F0<TrayIcon>() {

        public TrayIcon get() {
          try {
            Runnable leftClick = null;
            Object[] menuItems = params_unpackList(_menuItems);
            if (l(menuItems) > 0 && menuItems[0] instanceof Runnable) {
              leftClick = (Runnable) menuItems[0];
              menuItems = dropFirst(menuItems);
            }
            PopupMenu menu = makePopupMenu(menuItems);
            TrayIcon trayIcon = new TrayIcon(image, tooltip, menu);
            trayIcon.setImageAutoSize(trayIcon_imageAutoSize);
            if (leftClick != null) {
              final Runnable _leftClick = leftClick;
              onLeftClick(trayIcon, _leftClick);
            }
            SystemTray.getSystemTray().add(trayIcon);
            return trayIcon;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Runnable leftClick = null;\r\n    O[] menuItems = params_unpackList(_menuItems)...";
        }
      });
    } catch (Throwable __e) {
      return null;
    }
  }

  static public boolean shootScreen_useScrot = false;

  static public BufferedImage shootScreen2() {
    return shootScreen2(screenRectangle());
  }

  static public BufferedImage shootScreen2(Rectangle area) {
    try {
      ping();
      if (shootScreen_useScrot && eq(area, screenRectangle())) {
        if (!isOnPATH("scrot"))
          shootScreen2_fallback();
        if (shootScreen_useScrot) {
          String filename = "screenshot-" + randomID(12) + ".png";
          File f = linux_fileInRamDisk(filename);
          if (f == null)
            f = prepareProgramFile(filename);
          try {
            String cmd = "scrot " + bashQuote(f);
            String out = backtick(cmd);
            if (f.exists())
              return loadPNG(f);
            shootScreen2_fallback();
          } catch (Throwable e) {
            print(e);
            shootScreen2_fallback();
          } finally {
            f.delete();
          }
        }
      }
      return new Robot().createScreenCapture(area);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage shootScreen2(Rect area) {
    return shootScreen2(area.getRectangle());
  }

  static public BufferedImage shootScreen2(int x, int y, int w, int h) {
    return shootScreen2(new Rectangle(x, y, w, h));
  }

  static public void shootScreen2_fallback() {
    if (shootScreen_useScrot) {
      if (isLinux())
        print("Scrot failed. Reverting to internal screenshots.");
      shootScreen_useScrot = false;
    }
  }

  static public String toStringWithClass(Object o) {
    return o == null ? null : className(o) + " - " + o;
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    params = unrollParams(params);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (eqOneOf(val, html_valueLessParam(), true))
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public String dropNumberPrefix(String s) {
    return dropFirst(s, indexOfNonDigit(s));
  }

  static public <A> F0<A> fConst(A a) {
    return f0_const(a);
  }

  static public AutoCloseable tempSetField(Object o, String field, Object value) {
    final Object oldValue = get(o, field);
    set(o, field, value);
    return () -> set(o, field, oldValue);
  }

  static public <A> AutoCloseable tempSetField(ISetAndGet<A> gs, A value) {
    if (gs == null)
      return null;
    A oldValue = gs.get();
    gs.set(value);
    return () -> gs.set(oldValue);
  }

  static public <A> AutoCloseable tempSetField(A value, ISetAndGet<A> gs) {
    return tempSetField(gs, value);
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A extends JCheckBox> A bindCheckBoxToLiveValue(final A cb, final SimpleLiveValue<Boolean> lv) {
    bindLiveValueListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          setChecked(cb, isTrue(lv.get()));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          lv.set(isChecked(cb));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    return cb;
  }

  static public String fsIOpt(String s) {
    return formatSnippetIDOpt(s);
  }

  static public int deleteAllFilesInDirectory_minPathLength = 10;

  static public void deleteAllFilesInDirectory(File dir) {
    deleteAllFilesInDirectory(dir, false, false);
  }

  static public void deleteAllFilesInDirectory(File dir, boolean verbose, boolean testRun) {
    dir = getCanonicalFile(dir);
    assertTrue(f2s(dir), l(f2s(dir)) >= deleteAllFilesInDirectory_minPathLength);
    File[] files = dir.listFiles();
    if (files == null)
      return;
    for (File f : files) {
      if (!isSymLink(f) && f.isDirectory())
        deleteDirectory(f, verbose, testRun);
      else {
        if (verbose)
          print((testRun ? "Would delete " : "Deleting ") + f.getAbsolutePath());
        if (!testRun)
          f.delete();
      }
    }
  }

  static public void copyImagePart(BufferedImage src, int srcx, int srcy, BufferedImage dest, int destx, int desty, int w, int h) {
    Graphics2D g = dest.createGraphics();
    BufferedImage sub = src.getSubimage(srcx, srcy, w, h);
    g.drawImage(sub, destx, desty, null);
    g.dispose();
  }

  static public String appendWithNewLine(String a, String b) {
    if (empty(b))
      return a;
    if (empty(a))
      return b;
    return addSuffix(a, "\n") + b;
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((nempty(msg) ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public boolean isOnPATH(String cmd) {
    return findCmdOnPATH(cmd) != null;
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public <A> Set<A> syncLinkedHashSet() {
    return synchroLinkedHashSet();
  }

  static public Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  static public <A> int nfilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(pred, c);
  }

  static public <A> int nfilter(IF1<A, Boolean> pred, Iterable<A> c) {
    int n = 0;
    if (c != null)
      for (A o : c) if (pred.get(o))
        ++n;
    return n;
  }

  static public int nfilter(Iterable c, Object pred) {
    int n = 0;
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        ++n;
    return n;
  }

  static public int nfilter(Object pred, Iterable c) {
    return nfilter(c, pred);
  }

  static public List<File> sortFilesByName(List<File> l) {
    sort(l, (a, b) -> stdcompare(a.getName(), b.getName()));
    return l;
  }

  static public double fracNonNeg(double d) {
    return frac_nonNeg(d);
  }

  static public String plusPrefixUnlessMinus(String s) {
    return startsWith(s, "-") ? s : "+" + s;
  }

  static public boolean tok_staticFunctionAlwaysReturnsVoid(List<String> tok, String name) {
    Set<String> types = tok_returnTypesOfStaticFunction_uncleaned(tok, name);
    if (empty(types))
      return false;
    for (String type : types) if (!containsOneOf(javaTokC(type), javaxVoidAliases()))
      return false;
    return true;
  }

  static public boolean isKnownVoidFunction_uncached(String name) {
    return standardFunctionAlwaysReturnsVoid_uncached(name);
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component c : unnullForIteration(b)) if (c != null)
              a.add(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component c : unnullForIteration(b))\r\n      if (c != null) \r\n        a.a...";
        }
      });
    }
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public <A extends JSpinner> A onChange(A spinner, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            spinner.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "spinner.addChangeListener(changeListener(r));";
        }
      });
    }
    return spinner;
  }

  static public <A extends AbstractButton> A onChange(A b, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            b.addItemListener(itemListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addItemListener(itemListener(r));";
        }
      });
    }
    return b;
  }

  static public void onChange(JTextComponent tc, Object r) {
    onUpdate(tc, r);
  }

  static public <A extends JSlider> A onChange(A slider, final Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            slider.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "slider.addChangeListener(changeListener(r));";
        }
      });
    }
    return slider;
  }

  static public JComboBox onChange(Object r, JComboBox cb) {
    return onChange(cb, r);
  }

  static public JComboBox onChange(JComboBox cb, final Object r) {
    if (isEditableComboBox(cb))
      onChange(textFieldFromComboBox(cb), r);
    else
      onSelectedItem(cb, new VF1<String>() {

        public void get(String s) {
          try {
            callF(r);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r)";
        }
      });
    return cb;
  }

  static public List<String> splitCamelCase(String s) {
    return ai_splitCamelCase(s);
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public String appendColonIfNempty(String s) {
    return empty(s) ? "" : s + ": ";
  }

  static public PingSource pingSource() {
    return pingSource_tl().get();
  }

  static public PingSource pingSource(Thread thread) {
    return pingSource_tl().get(thread);
  }

  static public Font loadFont(String snippetID) {
    try {
      return loadFont(snippetID, 12f);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(String snippetID, float fontSize) {
    return loadFont(loadLibrary(snippetID), fontSize);
  }

  static public Font loadFont(File f, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, f).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class<?> hotwireSharingLibraries_silently(String progID) {
    AutoCloseable __1 = temp_loadPage_silent();
    try {
      return hotwireSharingLibraries(progID);
    } finally {
      _close(__1);
    }
  }

  static public String loadTextFileFromZipFile(File inZip, String fileName) {
    try {
      if (!fileExists(inZip))
        return null;
      try {
        ZipFile zip = new ZipFile(inZip);
        try {
          return loadTextFileFromZipFile(zip, fileName);
        } finally {
          _close(zip);
        }
      } catch (Throwable e) {
        throw fail(f2s(inZip), e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadTextFileFromZipFile(ZipFile zip, String fileName) {
    try {
      ZipEntry entry = zip.getEntry(fileName);
      if (entry == null)
        return null;
      InputStream fin = zip.getInputStream(entry);
      try {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        copyStream(fin, baos);
        return fromUTF8(baos.toByteArray());
      } finally {
        _close(fin);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void dm_popInModule(Object module) {
    dm_callOS("stefansOS_popInModule", dm_getStem(module));
  }

  static public void dm_popInModule() {
    dm_popInModule(dm_current_generic_mandatory());
  }

  static public String dropLeadingDots(String s) {
    int i = 0;
    while (charAt(s, i) == '.') ++i;
    return dropFirst(s, i);
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public String loadGZTextFile(File file) {
    try {
      if (!file.isFile())
        return null;
      ping();
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      InputStream fis = new FileInputStream(file);
      try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        byte[] buffer = new byte[1024];
        int len;
        while ((len = gis.read(buffer)) != -1) baos.write(buffer, 0, len);
        baos.close();
        return fromUtf8(baos.toByteArray());
      } finally {
        _close(fis);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] header = bytesFromHex("504B0304");

  static public boolean isNonEmptySingleZip_byMagicHeader(byte[] data) {
    return byteArrayStartsWith(data, header);
  }

  static public boolean isNonEmptySingleZip_byMagicHeader(File f) {
    return isNonEmptySingleZip_byMagicHeader(loadBeginningOfBinaryFile(f, l(header)));
  }

  static public JComponent dm_vis(Object module) {
    return dm_getVisualization(module);
  }

  static public JComponent dm_vis() {
    return dm_getVisualization();
  }

  static public <A> void probabilisticForEach(IProbabilisticScheduler scheduler, double pStart, double pEnd, Collection<A> l, IVF1<A> f) {
    if (scheduler == null || f == null)
      return;
    probabilisticForEach(scheduler, pStart, pEnd, iterator(l), 0, l(l), 1.0, f);
  }

  static public <A> void probabilisticForEach(IProbabilisticScheduler scheduler, double pStart, double pEnd, Iterator<A> it, int i, int n, double myProb, IVF1<A> f) {
    assertTrue(pEnd <= pStart);
    if (scheduler == null || f == null || !it.hasNext())
      return;
    A a = it.next();
    double p = blend(pStart, pEnd, doubleRatio(i, n - 1));
    scheduler.at(new Runnable() {

      public void run() {
        try {
          f.get(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return formatFunctionCall(f, a);
      }
    });
    scheduler.atRelative(doubleRatio(p, myProb), () -> probabilisticForEach(scheduler, pStart, pEnd, it, i + 1, n, p, f));
  }

  static public String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  static public double frac_nonNeg(double d) {
    return mod(d, 1);
  }

  static public boolean isInQ(Q q) {
    return q != null && isCurrentThread(q.rst.thread);
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName) {
    return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
    return takeFirst(80 - 33, fileNameEncode(fullName)) + " - " + md5;
  }

  static public boolean isMenuSeparatorIndicator(Object o) {
    return eqOneOf(o, "***", "---", "===", "");
  }

  static public <A extends JComponent> A applyMargin(int top, int left, int bottom, int right, A c) {
    return addMargin(top, left, bottom, right, c);
  }

  static public <A extends JComponent> A applyMargin(int w, A c) {
    return addMargin(w, c);
  }

  static public BufferedImage intMatrixToBufferedImage(Matrix<Integer> m) {
    if (m == null)
      return null;
    int w = m.getWidth(), h = m.getHeight();
    int[] pixels = matrixToIntArray(m);
    return newBufferedImage(w, h, pixels);
  }

  static public int withTopMargin_defaultWidth = 6;

  static public JPanel withTopMargin(Component c) {
    return withTopMargin(withTopMargin_defaultWidth, c);
  }

  static public JPanel withTopMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public Boolean hasGlobalOption(String option) {
    String question = print(option + "?");
    return askTripleBool(question);
  }

  static public void dm_inQ(Runnable r) {
    dm_q().add(r);
  }

  static public void dm_inQ(DynModule mod, Runnable r) {
    dm_q(mod, r);
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public <A extends JLabel> A bindJLabelToLiveValue(final A label, final LiveValue lv) {
    bindLiveValueListenerToComponent(label, lv, new Runnable() {

      public void run() {
        try {
          setText(label, strOrNull(lv.get()));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setText(label, strOrNull(lv!))";
      }
    });
    return label;
  }

  static public RuntimeException error() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException error(String msg) {
    throw new RuntimeException(msg);
  }

  static public <A extends JComponent> A setBackground(final Color color, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBackground(color);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBackground(color);";
        }
      });
    }
    return a;
  }

  static public <A extends JComponent> A setBackground(A a, Color color) {
    return setBackground(color, a);
  }

  static public Boolean dm_getFlag(String flagName) {
    Object mod = dm_current_generic();
    Object stem = dm_stem(mod);
    Integer flagCode = (Integer) (getOpt(flagName, stem));
    return flagCode == null ? null : (Boolean) call(stem, "hasFlag", flagCode);
  }

  static public String renderVars(Object... params) {
    return renderVars_str(params);
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static public Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  static public boolean isCurrentThread(Thread t) {
    return t != null && t == currentThread();
  }

  static public String dropPrefixTrim(String prefix, String s) {
    return trim(dropPrefix(prefix, s));
  }

  static public double elapsedSeconds(long time) {
    return toSeconds(sysNow() - time);
  }

  static public double elapsedSeconds(Timestamp ts) {
    return ts == null ? Double.NaN : toSeconds(now() - ts.date);
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public Class<?> hotwire(String src) {
    return hotwire(src, __1 -> mainClassNameForClassLoader(__1));
  }

  static public Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public List wrapPrimitiveArrayAsImmutableList(Object array) {
    int n = Array.getLength(array);
    return new RandomAccessAbstractList() {

      public int size() {
        return n;
      }

      public Object get(int i) {
        return Array.get(array, i);
      }
    };
  }

  static public <A> List<List<A>> matrixOfMatricesToListOfLists(Matrix<Matrix<A>> mm) {
    return map(__81 -> matrixToList(__81), matrixToList(mm));
  }

  static public Object metaGet(IMeta o, Object key) {
    return metaMapGet(o, key);
  }

  static public Object metaGet(Object o, Object key) {
    return metaMapGet(o, key);
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public <A> A heldInstance(Class<A> c) {
    List<Object> l = holdInstance_l.get();
    for (int i = l(l) - 1; i >= 0; i--) {
      Object o = l.get(i);
      if (isInstanceOf(o, c))
        return (A) o;
    }
    throw fail("No instance of " + className(c) + " held");
  }

  static public Class veryQuickJava(CharSequence mainJava) {
    return veryQuickJava3(str(mainJava));
  }

  static public String firstJavaToken(String s) {
    if (s == null)
      return null;
    int l = s.length();
    int j = 0;
    char c, d;
    while (j < l) {
      c = s.charAt(j);
      d = j + 1 >= l ? '\0' : s.charAt(j + 1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
        j = Math.min(j + 2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    if (j >= l)
      return null;
    int i = j;
    c = s.charAt(i);
    d = i + 1 >= l ? '\0' : s.charAt(i + 1);
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j + 1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L')
        ++j;
    } else if (c == '[' && d == '[') {
      do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
      j = Math.min(j + 2, l);
    } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
      do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
      j = Math.min(j + 3, l);
    } else
      ++j;
    return quickSubstring(s, i, j);
  }

  static public String fromUTF8(byte[] bytes) {
    return fromUtf8(bytes);
  }

  static public <A> List<A> listCreateAndAdd(List<A> l, A a) {
    return addDyn(l, a);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(final Iterable<A> c, final F1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Collection<A> c, final IF1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Iterator<A> it1, IF1<A, C> makeInnerIterator) {
    return nestedIterator(it1, toF1(makeInnerIterator));
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(final Iterator<A> it1, final F1<A, C> makeInnerIterator) {
    if (it1 == null || !it1.hasNext())
      return emptyIterableIterator();
    return iff(new F0() {

      public A a;

      public Iterator<B> innerIterator;

      {
        nextOuter();
      }

      public void nextOuter() {
        a = it1.next();
        innerIterator = makeInnerIterator.get(a);
      }

      public Object get() {
        while (true) {
          ping();
          if (innerIterator != null && innerIterator.hasNext())
            return innerIterator.next();
          if (!it1.hasNext())
            return endMarker();
          nextOuter();
        }
      }
    });
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Iterator<A> it1) {
    return nestedIterator(it1, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Collection<A> l) {
    return nestedIterator(l, makeInnerIterator);
  }

  static public String tok_packageName(List<String> tok) {
    int i = jfind(tok, "package");
    if (i < 0)
      return "";
    i += 2;
    int j = jfind(tok, i, ";");
    if (j < 0)
      return "";
    return join(codeTokensOnly(subList(tok, i - 1, j)));
  }

  static public String tok_packageName(String src) {
    Producer<String> p = javaTokC_producer(src);
    String t = p.next();
    if (!eq(t, "package"))
      return "";
    StringBuilder buf = new StringBuilder();
    while (!eqOneOf(t = p.next(), null, ";")) buf.append(t);
    return str(buf);
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public double twoPi() {
    return Math.PI * 2;
  }

  static public boolean directNohupJava_loggingOn = true;

  static public File directNohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs, javaxDefaultVMArgs());
  }

  static public File directNohupJavax(final String _javaxargs, final String _vmArgs) {
    if (directNohupJava_loggingOn)
      appendToLocalMechLog("nohupJavax Log", sfu(dropSecondIfEmpty(str(parseFirstInt(_javaxargs)), _vmArgs)));
    String javaxargs = _javaxargs.trim();
    if (javaxargs.startsWith("#"))
      javaxargs = javaxargs.substring(1);
    String snippetID = javaTok(javaxargs).get(1);
    int idx = javaxargs.indexOf(' ');
    String args = idx < 0 ? "" : javaxargs.substring(idx + 1).trim();
    String vmArgs = trim(_vmArgs);
    if (empty(vmArgs) && usePreSpunVMs()) {
      String line;
      if (args.length() != 0)
        line = format3("please start program * with arguments *", snippetID, args);
      else
        line = format3("please start program *", snippetID);
      String answer = sendToLocalBotOpt("A pre-spun VM.", line);
      if (match3("ok", answer)) {
        print("OK, used pre-spun VM.");
        return null;
      }
      if (answer != null)
        print("> " + answer);
      print("Using standard nohup.");
    }
    return classicNohupJavax(javaxargs, vmArgs);
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
    if (c == null)
      return null;
    {
      swing(new Runnable() {

        public void run() {
          try {
            String s = nullIfEmpty(str(toolTip));
            if (neq(s, c.getToolTipText()))
              c.setToolTipText(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "String s = nullIfEmpty(str(toolTip));\r\n    if (neq(s, c.getToolTipText()))\r\n ...";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setToolTipText(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public String nullIfEmpty(String s) {
    return isEmpty(s) ? null : s;
  }

  static public <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
    return isEmpty(map) ? null : map;
  }

  static public <A> List<A> nullIfEmpty(List<A> l) {
    return isEmpty(l) ? null : l;
  }

  static public void addMenuItem(JPopupMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(JPopupMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(Menu menu, String text, Object action) {
    menu.add(menuItem(text, action));
  }

  static public void addMenuItem(JMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenuBar menuBar, String text, Runnable action) {
    addMenuItem(menuBar, jmenuItem(text, action));
  }

  static public void addMenuItem(JMenuBar menuBar, JMenuItem menuItem) {
    addDirectMenuItem(menuBar, menuItem);
  }

  static public String copyTextToClipboard(Object _text) {
    String text = str(_text);
    StringSelection selection = new StringSelection(text);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    vmBus_send("newClipboardContents", text);
    return text;
  }

  static public void setComponent(SingleComponentPanel scp, Component c) {
    setSCPComponent(scp, c);
  }

  static public void setComponent(SingleComponentPanel scp, IF0<Component> c) {
    if (scp != null)
      setComponent(scp, callF(c));
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> void removeAll(Collection<A> a, Collection<A> b) {
    if (a != null && b != null)
      a.removeAll(b);
  }

  static public <A, B> void removeAll(Map<A, B> a, Collection<A> b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public <A, B extends A> boolean removeAll(Collection<A> c, B... b) {
    return c != null && b != null && c.removeAll(Arrays.asList(b));
  }

  static public <A, B> void removeAll(Map<A, B> a, A... b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public JComponent wrap(Object swingable) {
    return _recordNewSwingComponent(wrap_2(swingable));
  }

  static public JComponent wrap_2(Object swingable) {
    if (swingable == null)
      return null;
    JComponent c;
    if (swingable instanceof Component)
      c = componentToJComponent((Component) swingable);
    else if (swingable instanceof Swingable)
      c = componentToJComponent(((Swingable) swingable).visualize());
    else
      c = componentToJComponent((Component) callOpt(swingable, "swing"));
    if (c instanceof JTable || c instanceof JList || c instanceof JTextArea || c instanceof JEditorPane || c instanceof JTextPane || c instanceof JTree)
      return jscroll(c);
    return c == null ? jlabel(str(swingable)) : c;
  }

  static public <A extends Component> A _revalidate(A c) {
    return revalidate(c);
  }

  static public void _revalidate(JFrame f) {
    revalidate(f);
  }

  static public void _revalidate(JInternalFrame f) {
    revalidate(f);
  }

  static public Container _getParent(Component c) {
    return getParent(c);
  }

  static public boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  static public int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  static public void fillArrayUnlessZero(byte[] a, byte value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public void fillArrayUnlessZero(int[] a, int value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public void fillArrayUnlessZero(float[] a, float value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public boolean inRange(int x, int n) {
    return x >= 0 && x < n;
  }

  static public boolean inRange(int x, int a, int b) {
    return x >= a && x < b;
  }

  static public int ubyteToInt(byte b) {
    return b & 0x0FF;
  }

  static public int ubyteToInt(char c) {
    return c & 0x0FF;
  }

  static public int getPixel(BufferedImage img, int x, int y) {
    return img.getRGB(x, y);
  }

  static public int getPixel(BufferedImage img, Pt p) {
    return img.getRGB(p.x, p.y);
  }

  static public int limitToUByte(int i) {
    return max(0, min(255, i));
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        vmBus_send("locking", lock, "thread", currentThread());
        lock.lockInterruptibly();
        vmBus_send("locked", lock, "thread", currentThread());
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public <A> Set<A> synchroHashSet() {
    return synchronizedSet(new HashSet<A>());
  }

  static public Map synchroHashMap() {
    return synchronizedMap(new HashMap());
  }

  static public Flag dm_initErrorHandling_flag = new Flag();

  static public void dm_initErrorHandling() {
    raiseFlagAndDo(dm_initErrorHandling_flag, new Runnable() {

      public void run() {
        try {
          _handleException_addHandler(__1 -> dm_initErrorHandling_handler(__1));
          assertNull(_onRegisterThread);
          _onRegisterThread = new VF1<Thread>() {

            public void get(Thread t) {
              try {
                Object m = dm_current_generic();
                if (m == null)
                  printStackTrace("New thread made outside of a module");
                else if (m instanceof DynModule)
                  ((DynModule) m).ownTimer(t);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "O m = dm_current_generic();\r\n      if (m == null) printStackTrace(\"New thread...";
            }
          };
          _threadInfo_makers.add(new VF1<Map>() {

            public void get(Map map) {
              try {
                mapPut(map, "currentModule", dm_currentModule());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "mapPut(map, \"currentModule\", dm_currentModule())";
            }
          });
          _threadInheritInfo_retrievers.add(new VF1<Map>() {

            public void get(Map map) {
              try {
                Object mod = map.get("currentModule");
                if (mod instanceof DynModule)
                  dm_current_generic_tl().set(new WeakReference((DynModule) mod));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "O mod = map.get(\"currentModule\");\r\n      if (mod cast DynModule)\r\n        dm_...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_handleException_addHandler(lambda1 dm_initErrorHandling_handler);\r\n    \r\n   ...";
      }
    });
  }

  static public void dm_initErrorHandling_handler(Throwable e) {
    DynModule m = dm_currentModule();
    if (m == null)
      print("Weird: Error outside of module");
    else
      m.setField("_error", persistableThrowable(e));
  }

  static public void setMainDesktopPane(JDesktopPane desktop) {
    mainDesktopPane_value = desktop;
  }

  static public <A> A getCreatorOpt(String field) {
    return (A) getOpt(creator(), field);
  }

  static public boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  static public boolean isTrue(Boolean b) {
    return b != null && b.booleanValue();
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public boolean eq(Symbol a, String b) {
    return eq(str(a), b);
  }

  static public <A extends Component> A possiblyInternalFrameTitle(A c, String title) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      internalFrameTitle(f, title);
    else
      frameTitle(getFrame(c), title);
    return c;
  }

  static public String possiblyInternalFrameTitle(Component c) {
    JInternalFrame f = getInternalFrame(c);
    return f != null ? internalFrameTitle(f) : frameTitle(getFrame(c));
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
    pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public void ownResource(AutoCloseable c) {
    _registerAutoCloseable(c);
  }

  static public void cancelTimerOrInterruptThread(Object timer) {
    if (timer instanceof Thread && !(timer instanceof AutoCloseable))
      interruptThread((Thread) timer);
    else
      cancelTimer(timer);
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    if (e != null)
      print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public <A, B> Set<Map.Entry<A, B>> _entrySet(Map<A, B> map) {
    return map == null ? Collections.EMPTY_SET : map.entrySet();
  }

  static public <A, B> Map<A, B> getAndClearMap(Map<A, B> map) {
    if (map == null)
      return emptyMap();
    synchronized (collectionMutex(map)) {
      Map<A, B> out = cloneMap(map);
      map.clear();
      return out;
    }
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      {
        if (f != null)
          f.get(a);
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public Object pcallF(Runnable r) {
    try {
      {
        if (r != null)
          r.run();
      }
      return null;
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> A pcallF(IF0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(IF1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  static public int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  static public int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  static public int l(Map m) {
    return m == null ? 0 : m.size();
  }

  static public int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public long l(File f) {
    return f == null ? 0 : f.length();
  }

  static public int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : o instanceof Object[] ? l((Object[]) o) : o instanceof boolean[] ? l((boolean[]) o) : o instanceof byte[] ? l((byte[]) o) : o instanceof char[] ? l((char[]) o) : o instanceof short[] ? l((short[]) o) : o instanceof int[] ? l((int[]) o) : o instanceof float[] ? l((float[]) o) : o instanceof double[] ? l((double[]) o) : o instanceof long[] ? l((long[]) o) : (Integer) call(o, "size");
  }

  static public int l(MultiSet ms) {
    return ms == null ? 0 : ms.size();
  }

  static public int l(IntRange r) {
    return r == null ? 0 : r.length();
  }

  static public long l(LongRange r) {
    return r == null ? 0 : r.length();
  }

  static public double l(DoubleRange r) {
    return r == null ? 0 : r.length();
  }

  static public int l(IntBuffer b) {
    return b == null ? 0 : b.size();
  }

  static public int l(AppendableChain a) {
    return a == null ? 0 : a.size;
  }

  static public Rect dm_getBounds(Object module) {
    return shallowCloneToClass(Rect.class, call(dm_getStem(module), "getFrameRect"));
  }

  static public Rect dm_getBounds() {
    return dm_getBounds(dm_current_generic());
  }

  static public boolean hasMethod_onTypes(Object o, String method, Class... argTypes) {
    return findMethod_precise_onTypes(o, method, argTypes) != null;
  }

  static public void dm_onTopInput_q(final VF1<String> r) {
    final DynModule m = dm_current_mandatory();
    dm_onTopInput(new VF1<String>() {

      public void get(final String s) {
        try {
          m.q().add(new Runnable() {

            public void run() {
              try {
                callF(r, s);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "callF(r, s);";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "switch to m.q();\r\n    callF(r, s);";
      }
    });
  }

  static public <A> AutoCloseable tempSetBetterThreadLocalIfNecessary_weakRef(x30_pkg.x30_util.BetterThreadLocal<WeakReference> tl, A a) {
    if (tl == null)
      return null;
    WeakReference prev = tl.get();
    if (eq(getWeakRef(prev), a))
      return null;
    tl.set(weakRef(a));
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl;

  static public x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl() {
    if (dm_current_generic_tl == null)
      dm_current_generic_tl = vm_generalMap_getOrCreate("currentModule", () -> new x30_pkg.x30_util.BetterThreadLocal());
    return dm_current_generic_tl;
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      ClassLoader cl = (o instanceof Class ? (Class) o : o.getClass()).getClassLoader();
      if (cl == null)
        return null;
      String name = mainClassNameForClassLoader(cl);
      return loadClassFromClassLoader_orNull(cl, name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public Class mc() {
    return utils.class;
  }

  static public <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  static public <A> AutoCloseable tempSetTL(BetterThreadLocal<A> tl, A a) {
    return tempSetThreadLocalIfNecessary(tl, a);
  }

  static public ThreadLocal realMC_tl_tl = new ThreadLocal();

  static public ThreadLocal realMC_tl() {
    return realMC_tl_tl;
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public <A> List<A> synchroList() {
    return synchroList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  static public <A> boolean addIfNotThere(Collection<A> c, A a) {
    return setAdd(c, a);
  }

  static public void onUpdateAndNow(JComponent c, final Object r) {
    onUpdate(c, r);
    callF(r);
  }

  static public void onUpdateAndNow(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
    callF(r);
  }

  static public void zeroAllFieldsOfTypeExcept(Object o, Class type, String... exceptions) {
    zeroAllFieldsOfTypeExcept(o, type, asSet(exceptions));
  }

  static public void zeroAllFieldsOfTypeExcept(Object o, Class type, Collection<String> exceptions) {
    Set<String> set = asSet(exceptions);
    for (String field : allFields(o)) if (!set.contains(field) && instanceOf(getOpt(o, field), type))
      set(o, field, null);
  }

  static public List<AbstractAction> paramsToAbstractActions(Object... params) {
    List<AbstractAction> l = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) {
      String text = (String) (params[i]);
      Runnable action = (Runnable) (params[i + 1]);
      if (nempty(text))
        l.add(abstractAction(text, action));
    }
    return l;
  }

  static public void internalFramePopupMenuFromActions_threaded(Container f, List<AbstractAction> actions) {
    if (!(f instanceof JInternalFrame))
      return;
    for (final AbstractAction a : unnull(actions)) if (a != null)
      internalFramePopupMenuItem(((JInternalFrame) f), str(a.getValue(Action.NAME)), runnableThread(new Runnable() {

        public void run() {
          try {
            callAction(a);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callAction(a)";
        }
      }));
  }

  static public <A> LinkedHashSet<A> asLinkedHashSet(A[] array) {
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> LinkedHashSet<A> asLinkedHashSet(Collection<A> l) {
    if (l instanceof LinkedHashSet)
      return (LinkedHashSet) l;
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A o : l) if (o != null)
      set.add(o);
    return set;
  }

  static public Map<Class, Set<String>> allFields_cache = weakHashMap();

  static public Set<String> allFields(Object o) {
    if (o == null)
      return emptySet();
    Class _c = _getClass(o);
    Set<String> fields = allFields_cache.get(_c);
    if (fields == null)
      allFields_cache.put(_c, fields = asTreeSet(keys(getOpt_getFieldMap(o))));
    return fields;
  }

  static public Class<?> getClass(String name) {
    return _getClass(name);
  }

  static public Class getClass(Object o) {
    return _getClass(o);
  }

  static public Class getClass(Object realm, String name) {
    return _getClass(realm, name);
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public void dm_boolFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    internalFrameTitlePopupMenu(((JInternalFrame) frame), new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          menu.add(jCheckBoxMenuItem(humanized, (boolean) _get(m, field), new VF1<Boolean>() {

            public void get(Boolean b) {
              try {
                m.setField(field, b);
                callF(optPar(__, "onSet"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.setField(field, b);\r\n      callF(optPar(_, 'onSet));";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "menu.add(jCheckBoxMenuItem(humanized, (bool) _get(m, field), voidfunc(bool b)...";
      }
    });
  }

  static public void dm_intFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          final JTextField tf = jtextfield(get(m, field));
          showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

            public void run() {
              try {
                m.setField(field, parseInt(gtt(tf)));
                callF(optPar(__, "onSet"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.setField(field, parseInt(gtt(tf)));\r\n        callF(optPar(__, \"onSet\"));";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTextField tf = jtextfield(get(m, field));\r\n    showFormTitled(or2(stri...";
      }
    });
  }

  static public void dm_longFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          final JTextField tf = jtextfield(get(m, field));
          showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

            public void run() {
              try {
                m.setField(field, parseLong(gtt(tf)));
                callF(optPar(__, "onSet"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.setField(field, parseLong(gtt(tf)));\r\n        callF(optPar(__, \"onSet\"));";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTextField tf = jtextfield(get(m, field));\r\n    showFormTitled(or2(stri...";
      }
    });
  }

  static public void dm_doubleFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_doubleFieldSetterDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_doubleFieldSetterDialog(field, __);";
      }
    });
  }

  static public void dm_floatFieldMenuItem(Container frame, String field, Object... __) {
    DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_floatFieldSetterDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_floatFieldSetterDialog(field, __);";
      }
    });
  }

  static public void dm_stringFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_stringFieldDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_stringFieldDialog(field, __);";
      }
    });
  }

  static public void dm_fileFieldMenuItem(Container frame, String field, Object... __) {
    DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_fileFieldDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_fileFieldDialog(field, __);";
      }
    });
  }

  static public ReliableSingleThread dm_rst(Runnable r) {
    return dm_rst(dm_current_mandatory(), r);
  }

  static public ReliableSingleThread dm_rst(DynModule mod, Runnable r) {
    return dm_rst(mod, new ReliableSingleThread(r));
  }

  static public ReliableSingleThread dm_rst(DynModule mod, ReliableSingleThread rst) {
    rst.enter = dm_rEnter(mod);
    return rst;
  }

  static public Q dm_startQ() {
    return dm_ownQ(startQ());
  }

  static public Q dm_startQ(String name) {
    return dm_ownQ(startQ(name));
  }

  static public JComponent dm_noVisualisation() {
    return setToolTip("Module has no visualization", jimage("#1101480"));
  }

  static public String snippetTitle(String id) {
    return getSnippetTitle(id);
  }

  static public String snippetTitle(long id) {
    return getSnippetTitle(id);
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public Class mainClass() {
    return getMainClass();
  }

  static public Class mainClass(Object o) {
    return getMainClass(o);
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

  static public void _registerTimer_original(java.util.Timer timer) {
    _registerTimer_list.add(timer);
  }

  static public void cleanMeUp__registerTimer() {
    cancelTimers(getAndClearList(_registerTimer_list));
  }

  static public DynModule dm_currentModule() {
    return optCast(DynModule.class, dm_current_generic());
  }

  static public JScrollPane jscroll_copyBackground(Component c) {
    return setScrollPaneBackground(getBackground(c), jscroll(c));
  }

  static public JFastLogView_noWrap jFastLogView_noWrap() {
    return jFastLogView_noWrap("");
  }

  static public JFastLogView_noWrap jFastLogView_noWrap(String text) {
    return withTypeWriterFont(swingNu(JFastLogView_noWrap.class, text));
  }

  static public String getPrintLog() {
    return str(print_log);
  }

  static public <A extends JComponent> A componentPopupMenuItem(A c, final String name, final Object action) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, name, action);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, action);";
      }
    });
    return c;
  }

  static public void componentPopupMenuItem(JComponent c, final JMenuItem menuItem) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, menuItem);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, menuItem);";
      }
    });
  }

  static public void dm_clearModulePrintLog() {
    clearStringBuffer_gen(dm_current_mandatory()._actualPrintLog());
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, Object r) {
    swingEvery(component, delay, r);
    return component;
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, long firstDelay, Object r) {
    swingEvery(component, delay, firstDelay, r);
    return component;
  }

  static public void awtEvery(RootPaneContainer frame, long delay, Object r) {
    swingEvery(frame, delay, r);
  }

  static public <A extends JComponent> A awtEvery(A component, double delaySeconds, Object r) {
    return awtEvery(component, toMS(delaySeconds), r);
  }

  static public boolean scrollAllTheWayDown_bruteForce = true;

  static public <A extends JComponent> A scrollAllTheWayDown(A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            int h = c.getHeight() - 1;
            if (scrollAllTheWayDown_bruteForce)
              h = max(h, 100000);
            c.scrollRectToVisible(new Rectangle(0, h, 1, 1));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "int h = c.getHeight()-1;\r\n    if (scrollAllTheWayDown_bruteForce) h = max(h, ...";
        }
      });
    }
    return c;
  }

  static public StringBuffer liveLocalPrintLog_realMC(Object o) {
    Object realMC = getMainClass(o);
    if (realMC != mc())
      return (StringBuffer) getOpt(realMC, "local_log");
    return liveLocalPrintLog();
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public <B> Map<String, B> humanizeKeys(Map<String, B> map) {
    return mapKeys(__82 -> humanizeFormLabel(__82), map);
  }

  static public Map<String, Object> objectToMap_inOrder_withoutFields(Object o, Collection<String> withoutFields) {
    if (o == null)
      return null;
    if (o instanceof Map)
      return (Map) o;
    LinkedHashMap<String, Object> map = new LinkedHashMap();
    for (String field : listWithoutSet(fieldsInOrder(o), withoutFields)) map.put(field, get(o, field));
    return map;
  }

  static public Map<String, Object> objectToMap(Object o) {
    try {
      if (o instanceof Map)
        return (Map) o;
      TreeMap<String, Object> map = new TreeMap();
      Class c = o.getClass();
      while (c != Object.class) {
        Field[] fields = c.getDeclaredFields();
        for (final Field field : fields) {
          if ((field.getModifiers() & Modifier.STATIC) != 0)
            continue;
          field.setAccessible(true);
          final Object value = field.get(o);
          if (value != null)
            map.put(field.getName(), value);
        }
        c = c.getSuperclass();
      }
      if (o instanceof DynamicObject)
        putAll(map, ((DynamicObject) o).fieldValues);
      return map;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Map<String, Object>> objectToMap(Iterable l) {
    if (l == null)
      return null;
    List x = new ArrayList();
    for (Object o : l) x.add(objectToMap(o));
    return x;
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    Map m = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A key = __0.getKey();
      B val = __0.getValue();
      m.put(key, f.get(val));
    }
    return m;
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public <A> List<A> addDyn_sync(List<A> l, A a) {
    if (l == null)
      l = synchroList();
    l.add(a);
    return l;
  }

  static public int count(Collection l, Object o) {
    int count = 0;
    for (Object x : l) if (eq(x, o))
      ++count;
    return count;
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    return map(map, (Object) f);
  }

  static public <A, B> List<A> map(IF1<A, B> f, A data1, A... moreData) {
    List x = emptyList(l(moreData) + 1);
    x.add(f.get(data1));
    if (moreData != null)
      for (A o : moreData) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public JTable dataToTable_uneditable(Object data, final JTable table) {
    return dataToTable_uneditable(table, data);
  }

  static public JTable dataToTable_uneditable(final JTable table, final Object data) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            dataToTable(table, data, true);
            makeTableUneditable(table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "dataToTable(table, data, true);\r\n    makeTableUneditable(table);";
        }
      });
    }
    return table;
  }

  static public JTable dataToTable_uneditable(final Object data) {
    return dataToTable_uneditable(showTable(), data);
  }

  static public JTable dataToTable_uneditable(Object data, String title) {
    return dataToTable_uneditable(showTable(title), data);
  }

  static public boolean sexyTable_drag = false;

  static public JTable sexyTable() {
    final JTable table = sexyTableWithoutDrag();
    if (sexyTable_drag)
      tableEnableTextDrag(table);
    return table;
  }

  static public JTable onDoubleClickOrEnter(final JTable table, final Object runnable) {
    onDoubleClick(table, runnable);
    onEnter(table, runnable);
    return table;
  }

  static public JList onDoubleClickOrEnter(final JList list, final Object runnable) {
    onDoubleClick(list, runnable);
    onEnter(list, runnable);
    return list;
  }

  static public JTable onDoubleClickOrEnter(Object runnable, JTable table) {
    return onDoubleClickOrEnter(table, runnable);
  }

  static public <A> A _get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public Object _get(Object o, String field) {
    return get(o, field);
  }

  static public Object _get(String field, Object o) {
    return get(o, field);
  }

  static public <A> A _get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public JList onDoubleClick(final JList list, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            list.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                  int idx = list.locationToIndex(evt.getPoint());
                  Object item = list.getModel().getElementAt(idx);
                  list.setSelectedIndex(idx);
                  callF(runnable, item);
                }
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "list.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(Mous...";
        }
      });
    }
    return list;
  }

  static public JTable onDoubleClick(final JTable table, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            table.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                  int idx = table.rowAtPoint(evt.getPoint());
                  table.setRowSelectionInterval(idx, idx);
                  callF(runnable, idx);
                }
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "table.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(Mou...";
        }
      });
    }
    return table;
  }

  static public void onDoubleClick(final JComponent c, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2)
                  callF(runnable, evt.getPoint());
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(MouseEv...";
        }
      });
    }
  }

  static public class TableSearcher {

    public JTable table;

    public JTextField tfInput;

    public JComponent searchPanel, panel;

    public F2<String, Map, Boolean> rowTester;

    public List<Integer> rowIndices;

    public String input() {
      return gtt(tfInput);
    }
  }

  static public TableSearcher tableWithSearcher2(final JTable t, Object... __) {
    final TableSearcher s = new TableSearcher();
    final boolean precise = true;
    s.table = t;
    s.tfInput = jtextfield();
    s.rowTester = new F2<String, Map, Boolean>() {

      public Boolean get(String pat, Map row) {
        try {
          return anyValueContainsIgnoreCase(row, pat);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "anyValueContainsIgnoreCase(row, pat)";
      }
    };
    onUpdate(s.tfInput, new Runnable() {

      public List lastFiltered, lastOriginal;

      public void run() {
        String pat = s.input();
        List<Map<String, Object>> data = rawTableData(t);
        if (eq(lastFiltered, data))
          data = lastOriginal;
        List data2 = new ArrayList();
        List<Integer> rowIndices = new ArrayList();
        for (int i = 0; i < l(data); i++) {
          Map<String, Object> map = data.get(i);
          if (isTrue(callF(s.rowTester, pat, map))) {
            data2.add(map);
            rowIndices.add(i);
          }
        }
        lastFiltered = data2;
        lastOriginal = data;
        dataToTable(t, data2);
        if (precise)
          lastFiltered = rawTableData(t);
        s.rowIndices = rowIndices;
      }
    });
    s.searchPanel = withLabel("Search:", s.tfInput);
    JComponent top = s.searchPanel;
    s.panel = boolOptPar(__, "withMargin") ? northAndCenterWithMargin(top, t) : northAndCenter(top, t);
    return s;
  }

  static public Point enclosingViewPosition(Component c) {
    JScrollPane sp = enclosingScrollPane(c);
    return sp == null ? null : swing(new F0<Point>() {

      public Point get() {
        try {
          return sp.getViewport().getViewPosition();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret sp.getViewport().getViewPosition();";
      }
    });
  }

  static public void setEnclosingViewPosition(Component c, Point p) {
    if (p == null)
      return;
    JScrollPane sp = enclosingScrollPane(c);
    if (sp != null) {
      swing(new Runnable() {

        public void run() {
          try {
            sp.getViewport().setViewPosition(p);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "sp.getViewport().setViewPosition(p);";
        }
      });
    }
  }

  static public String n2(long l) {
    return formatWithThousands(l);
  }

  static public String n2(AtomicLong l) {
    return n2(l.get());
  }

  static public String n2(Collection l) {
    return n2(l(l));
  }

  static public String n2(Map map) {
    return n2(l(map));
  }

  static public String n2(double l, String singular) {
    return empty(singular) ? str(l) : n2(l, singular, singular + "s");
  }

  static public String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  static public String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(long l, String singular) {
    return empty(singular) ? n2(l) : n_fancy2(l, singular, singular + "s");
  }

  static public String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  static public String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  static public String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  static public String n2(long[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  static public String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  static public <A> void syncClear(Collection<A> c) {
    if (c != null)
      synchronized (collectionMutex(c)) {
        c.clear();
      }
  }

  static public void syncClear(Map map) {
    if (map != null)
      synchronized (collectionMutex(map)) {
        map.clear();
      }
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(BitSet bs) {
    return bs == null || bs.isEmpty();
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(MultiMap mm) {
    return mm == null || mm.isEmpty();
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public boolean empty(DoubleRange r) {
    return r == null || r.isEmpty();
  }

  static public boolean empty(IntBuffer b) {
    return b == null || b.isEmpty();
  }

  static public boolean empty(Rect r) {
    return !(r != null && r.w != 0 && r.h != 0);
  }

  static public boolean empty(Chain c) {
    return c == null;
  }

  static public boolean empty(AppendableChain c) {
    return c == null;
  }

  static public <A> boolean syncAddAll(Collection<A> c, Iterable<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (c) {
      return c.addAll(asCollection(b));
    }
  }

  static public <A> boolean syncRemove(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.remove(b);
    }
  }

  static public <A> A syncRemove(List<A> l, int idx) {
    if (l == null)
      return null;
    synchronized (collectionMutex(l)) {
      return l.remove(idx);
    }
  }

  static public <A, B> B syncRemove(Map<A, B> map, A key) {
    return map == null ? null : map.remove(key);
  }

  static public <A> boolean syncRemoveAll(Collection<A> c, Collection<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.removeAll(b);
    }
  }

  static public int[] selectedTableRows_array(final JTable table) {
    return table == null ? null : swing(new F0<int[]>() {

      public int[] get() {
        try {
          return table.getSelectedRows();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret table.getSelectedRows();";
      }
    });
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public void dm_vmBus_send(String msg, Object... args) {
    vmBus_send(msg, args);
  }

  static public void dm_vmBus_send(String msg) {
    vmBus_send(msg);
  }

  static public void selectTableRows(final JTable table, int[] rows) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            ListSelectionModel model = table.getSelectionModel();
            int n = tableRows(table);
            model.clearSelection();
            if (rows != null)
              for (int row : rows) if (row < n)
                model.addSelectionInterval(row, row);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ListSelectionModel model = table.getSelectionModel();\r\n    int n = tableRows(...";
        }
      });
    }
  }

  static public int syncL(Collection l) {
    if (l == null)
      return 0;
    synchronized (collectionMutex(l)) {
      return l.size();
    }
  }

  static public int syncL(Map map) {
    if (map == null)
      return 0;
    synchronized (collectionMutex(map)) {
      return map.size();
    }
  }

  static public <A> List<A> syncL() {
    return syncList();
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public <A> A syncGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    synchronized (l) {
      return idx < l(l) ? l.get(idx) : null;
    }
  }

  static public <A, B> B syncGet(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.get(a);
    }
  }

  static public int selectedTableRowInModel(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          int i = t.getSelectedRow();
          return i < 0 ? i : t.convertRowIndexToModel(i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "int i = t.getSelectedRow();\r\n    ret i < 0 ? i : t.convertRowIndexToModel(i);";
      }
    });
  }

  static public <A> List<A> syncListGetMulti(final List<A> l, List<Integer> indices) {
    synchronized (collectionMutex(l)) {
      return listGetMulti(l, indices);
    }
  }

  static public int selectedTableRow(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.getSelectedRow();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.getSelectedRow();";
      }
    });
  }

  static public List<Integer> selectedTableRowsInModel(final JTable t) {
    return t == null ? emptyList() : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));";
      }
    });
  }

  static public <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  static public <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  static public int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  static public int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  static public void selectRow(final JTable table, final int i) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (i >= 0 && i < table.getRowCount()) {
              table.setRowSelectionInterval(i, i);
              scrollRowToVisible(table, i);
            } else
              table.clearSelection();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (i >= 0 && i < table.getRowCount()) {\r\n      table.setRowSelectionInterval...";
        }
      });
    }
  }

  static public void selectRow(final JList list, final int i) {
    if (list != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (i >= 0 && i < listRowCount(list))
              list.setSelectedIndex(i);
            else
              list.clearSelection();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (i >= 0 && i < listRowCount(list))\r\n      list.setSelectedIndex(i);\r\n    e...";
        }
      });
    }
  }

  static public <A> JComboBox<A> selectItem(A item, JComboBox<A> cb) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.setSelectedItem(item);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.setSelectedItem(item);";
        }
      });
    }
    return cb;
  }

  static public <A> JComboBox<A> selectItem(JComboBox<A> cb, A item) {
    return selectItem(item, cb);
  }

  static public <A> JList<A> selectItem(JList<A> list, A item) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            selectRow(list, jlist_indexOf(list, item));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "selectRow(list, jlist_indexOf(list, item));";
        }
      });
    }
    return list;
  }

  static public JTable tablePopupMenuItemsThreaded(final JTable table, Object... params) {
    for (int i = 0; i + 1 < l(params); i += 2) {
      final Object action = params[i + 1];
      final Object threadInfo = _threadInfo();
      tablePopupMenuItem(table, str(params[i]), new VF1<Integer>() {

        public void get(final Integer row) {
          try {
            _threadInheritInfo(threadInfo);
            {
              startThread(new Runnable() {

                public void run() {
                  try {
                    try {
                      callF(action, row);
                    } catch (Throwable __e) {
                      messageBox(__e);
                    }
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "try {\r\n        callF(action, row);\r\n      } catch (Throwable __e) { messageBo...";
                }
              });
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "_threadInheritInfo(threadInfo);\r\n      thread-messagebox {\r\n        callF(act...";
        }
      });
    }
    return table;
  }

  static public JTable tablePopupMenuItemsThreaded_top(final JTable table, Object... params) {
    params = reverseParams(params);
    for (int i = 0; i + 1 < l(params); i += 2) {
      final Object action = params[i + 1];
      final Object threadInfo = _threadInfo();
      tablePopupMenuItem_top(table, str(params[i]), new VF1<Integer>() {

        public void get(final Integer row) {
          try {
            _threadInheritInfo(threadInfo);
            {
              startThread(new Runnable() {

                public void run() {
                  try {
                    try {
                      callF(action, row);
                    } catch (Throwable __e) {
                      messageBox(__e);
                    }
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "try {\r\n        callF(action, row);\r\n      } catch (Throwable __e) { messageBo...";
                }
              });
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "_threadInheritInfo(threadInfo);\r\n      thread-messagebox {\r\n        callF(act...";
        }
      });
    }
    return table;
  }

  static public <A, B extends A> void _addAll(Collection<A> c, Iterable<B> b) {
    addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, Collection<B> b) {
    return addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, B... b) {
    return addAll(c, b);
  }

  static public void scrollTableDownNow(final JTable table) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "table.scrollRectToVisible(table.getCellRect(table.getRowCount()-1, 0, true));";
        }
      });
    }
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return db_mainConcepts().list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public List getList(Map map, Object key) {
    return map == null ? null : (List) map.get(key);
  }

  static public List getList(List l, int idx) {
    return (List) get(l, idx);
  }

  static public List getList(Object o, Object key) {
    if (o instanceof Map)
      return getList((Map) o, key);
    if (key instanceof String)
      return (List) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public List getList(String name, Object o) {
    return getList(o, name);
  }

  static public <A> ArrayList<A> clonedList(Iterable<A> l) {
    return cloneList(l);
  }

  static public <A> ArrayList<A> clonedList(Collection<A> l) {
    return cloneList(l);
  }

  static public File programFile(String name) {
    return prepareProgramFile(name);
  }

  static public File programFile(String progID, String name) {
    return prepareProgramFile(progID, name);
  }

  static public String ymd_minus_hms_minus_millis() {
    return ymd() + "-" + spliceString(replace(hmsWithColonsAndMS(), ":", ""), 6, 6, "-");
  }

  static public void saveGZStructToFile(String file, Object o) {
    saveGZStructureToFile(file, o);
  }

  static public void saveGZStructToFile(File file, Object o) {
    saveGZStructureToFile(file, o);
  }

  static public void imageSurface_pixelated(ImageSurface imageSurface) {
    imageSurface.setDoubleBuffered(true);
    imageSurface.noAlpha = true;
    imageSurface.interpolationMode = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public BufferedImage loadImage2(String snippetIDOrURL) {
    return loadBufferedImage(snippetIDOrURL);
  }

  static public BufferedImage loadImage2(File file) {
    return loadBufferedImage(file);
  }

  static public void savePNG(BufferedImage img, File file) {
    try {
      File tempFile = new File(file.getPath() + "_temp");
      CriticalAction ca = beginCriticalAction("Save " + f2s(file));
      try {
        ImageIO.write(img, "png", mkdirsFor(tempFile));
        file.delete();
        tempFile.renameTo(file);
      } finally {
        ca.done();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void savePNG(File file, BufferedImage img) {
    savePNG(img, file);
  }

  static public void savePNG(File file, RGBImage img) {
    savePNG(file, img.getBufferedImage());
  }

  static public void internalFramePopupMenuItem(Container f, final String name, final Object action) {
    internalFrameTitlePopupMenuItem(((JInternalFrame) f), name, action);
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public String dm_moduleID(Object module) {
    return strOrNull(getOpt(dm_getStem(module), "id"));
  }

  static public String dm_moduleID() {
    return dm_moduleID(dm_current_mandatory_generic());
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public JList jlist(final List<String> l) {
    return (JList) swing(new F0<Object>() {

      public Object get() {
        try {
          JList list = new JList();
          final WeakReference<JList> ref = weakRef(list);
          listPopupMenuItem(list, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboardIfNotNull(selectedItem(ref.get()));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboardIfNotNull(selectedItem(ref!))";
            }
          });
          fillListWithStrings(list, l);
          return list;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JList list;\r\n    final WeakReference<JList> ref = weakRef(list);\r\n    lis...";
      }
    });
  }

  static public JList jlist(String... l) {
    return jlist(asList(l));
  }

  static public void fillListWithStrings(JList list, Collection<String> contents) {
    if (list == null)
      return;
    final DefaultListModel model = new DefaultListModel();
    if (contents != null)
      for (String s : contents) model.addElement(empty(s) ? " " : s);
    {
      swing(new Runnable() {

        public void run() {
          try {
            list.setModel(model);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "list.setModel(model);";
        }
      });
    }
  }

  static public void fillListWithStrings(final JList list, String[] contents) {
    fillListWithStrings(list, asList(contents));
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(BitSet bs) {
    return !empty(bs);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(MultiMap mm) {
    return mm != null && !mm.isEmpty();
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public boolean nempty(IntBuffer b) {
    return b != null && !b.isEmpty();
  }

  static public boolean nempty(Rect r) {
    return r != null && r.w != 0 && r.h != 0;
  }

  static public boolean nempty(MultiSet ms) {
    return ms != null && !ms.isEmpty();
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public Object realMC() {
    return getThreadLocal(realMC_tl());
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Map<String, Field> getOpt_getFieldMap(Object o) {
    Class c = _getClass(o);
    HashMap<String, Field> map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
    return map;
  }

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Map<String, Field> map = getOpt_getFieldMap(o);
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return syncMapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public Map<JTable, VF1<JTable>> setTableModel_after = weakHashMap();

  static public Map<JTable, VF2<JTable, RowSorter>> setTableModel_fixSorter = weakHashMap();

  static public void setTableModel(final JTable table, final TableModel model) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Map<String, Integer> widths = tableColumnWidthsByName(table);
            int[] i = table.getSelectedRows();
            TableRowSorter sorter = model.getColumnCount() == tableColumnCount(table) ? (TableRowSorter) table.getRowSorter() : null;
            List<? extends RowSorter.SortKey> sortKeys = sorter == null ? null : sorter.getSortKeys();
            table.setModel(model);
            int n = model.getRowCount();
            ListSelectionModel sel = table.getSelectionModel();
            for (int j = 0; j < i.length; j++) if (i[j] < n)
              sel.addSelectionInterval(i[j], i[j]);
            tableSetColumnPreferredWidths(table, widths);
            if (sorter != null) {
              sorter.setModel(model);
              callF(setTableModel_fixSorter.get(table), table, sorter);
              if (sortKeys != null)
                sorter.setSortKeys(sortKeys);
            }
            table.setRowSorter(sorter);
            callF(setTableModel_after.get(table), table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Map<String, Integer> widths = tableColumnWidthsByName(table);\r\n    int[] i = ...";
        }
      });
    }
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping() {
    newPing();
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

  static public AutoCloseable holdInstance(Object o) {
    if (o == null)
      return null;
    listThreadLocalAdd(holdInstance_l, o);
    return new AutoCloseable() {

      public void close() {
        listThreadLocalPopLast(holdInstance_l);
      }
    };
  }

  static public Object _onAWTEnter_f;

  static public AutoCloseable _onAWTEnter() {
    return (AutoCloseable) callF(_onAWTEnter_f);
  }

  static public JDesktopPane mainDesktopPane_value;

  static public JDesktopPane mainDesktopPane() {
    return mainDesktopPane_value;
  }

  static public Class javax() {
    return getJavaX();
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A, B> Pair<A, B> first(Map<A, B> map) {
    return mapEntryToPair(first(entrySet(map)));
  }

  static public <A, B> Pair<A, B> first(MultiMap<A, B> mm) {
    if (mm == null)
      return null;
    var e = first(mm.data.entrySet());
    if (e == null)
      return null;
    return pair(e.getKey(), first(e.getValue()));
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public <A, B, C> A first(T3<A, B, C> t) {
    return t == null ? null : t.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public int first(IntBuffer buf) {
    return buf.get(0);
  }

  static public <A> A first(A[] l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(pred, l);
  }

  static public <A> A first(AppendableChain<A> a) {
    return a == null ? null : a.element;
  }

  static public List _registerWeakMap_preList;

  static public <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  static public void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static public Object getOptDynOnly(DynamicObject o, String field) {
    if (o == null || o.fieldValues == null)
      return null;
    return o.fieldValues.get(field);
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long) {
        f.set(o, ((Long) value).intValue());
        return;
      }
      if (type == boolean.class && value instanceof String) {
        f.set(o, isTrueOrYes(((String) value)));
        return;
      }
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    setDynObjectValue(o, key, value);
    return o;
  }

  static public void setDyn(IMeta o, String key, Object value) {
    metaMapPut(o, key, value);
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<A, B> weakHashMap() {
    return newWeakHashMap();
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    if (o instanceof Boolean)
      return boolToInt((Boolean) o);
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public Map<String, Integer> findBot_cache = synchroHashMap();

  static public int findBot_timeout = 5000;

  static public DialogIO findBot(String searchPattern) {
    String subBot = null;
    int i = searchPattern.indexOf('/');
    if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
      subBot = searchPattern.substring(i + 1);
      searchPattern = searchPattern.substring(0, i);
      if (!isInteger(searchPattern))
        searchPattern = "Multi-Port at " + searchPattern + ".";
    }
    if (isInteger(searchPattern))
      return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    if (eq(searchPattern, "remote"))
      return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    Integer port = findBot_cache.get(searchPattern);
    if (port != null)
      try {
        DialogIO io = talkTo("localhost", port);
        io.waitForLine();
        String line = io.readLineNoBlock();
        if (indexOfIgnoreCase(line, searchPattern) == 0) {
          call(io, "pushback", line);
          return talkToSubBot(subBot, io);
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    List<ProgramScan.Program> bots = quickBotScan();
    for (ProgramScan.Program p : bots) {
      if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) {
        findBot_cache.put(searchPattern, p.port);
        return talkToSubBot(subBot, talkTo("localhost", p.port));
      }
    }
    for (ProgramScan.Program p : bots) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            String name = subBots.get(vport);
            if (startsWithIgnoreCase(name, searchPattern))
              return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
          }
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
    }
    return null;
  }

  static public <A> A swingConstruct(final Class<A> c, final Object... args) {
    return swing(new F0<A>() {

      public A get() {
        try {
          return nuObject(c, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret nuObject(c, args);";
      }
    });
  }

  static public boolean structure_showTiming, structure_checkTokenCount;

  static public String structure(Object o) {
    return structure(o, new structure_Data());
  }

  static public String structure(Object o, structure_Data d) {
    StringWriter sw = new StringWriter();
    d.out = new PrintWriter(sw);
    structure_go(o, d);
    String s = str(sw);
    if (structure_checkTokenCount) {
      print("token count=" + d.n);
      assertEquals("token count", l(javaTokC(s)), d.n);
    }
    return s;
  }

  static public void structure_go(Object o, structure_Data d) {
    structure_1(o, d);
    while (nempty(d.stack)) popLast(d.stack).run();
  }

  static public void structureToPrintWriter(Object o, PrintWriter out) {
    structureToPrintWriter(o, out, new structure_Data());
  }

  static public void structureToPrintWriter(Object o, PrintWriter out, structure_Data d) {
    d.out = out;
    structure_go(o, d);
  }

  static public boolean structure_allowShortening = false;

  static public class structure_ClassInfo {

    public Class c;

    public List<Field> fields;

    public Method customSerializer;

    public IVF1<Object> serializeObject;

    public boolean special = false;

    public boolean nullInstances = false;
  }

  static public class structure_Data {

    public PrintWriter out;

    public int stringSizeLimit;

    public int shareStringsLongerThan = 20;

    public boolean noStringSharing = false;

    public boolean storeBaseClasses = false;

    public boolean honorFieldOrder = true;

    public String mcDollar = actualMCDollar();

    public IdentityHashMap<Object, Integer> seen = new IdentityHashMap();

    public HashMap<String, Integer> strings = new HashMap();

    public HashSet<String> concepts = new HashSet();

    public HashMap<Class, structure_ClassInfo> infoByClass = new HashMap();

    public HashMap<Class, Field> persistenceInfo = new HashMap();

    public int n;

    public List<Runnable> stack = new ArrayList();

    public structure_Data append(String token) {
      out.print(token);
      ++n;
      return this;
    }

    public structure_Data append(int i) {
      out.print(i);
      ++n;
      return this;
    }

    public structure_Data append(String token, int tokCount) {
      out.print(token);
      n += tokCount;
      return this;
    }

    public structure_Data app(String token) {
      out.print(token);
      return this;
    }

    public structure_Data app(int i) {
      out.print(i);
      return this;
    }

    public structure_ClassInfo infoForClass(Class c) {
      structure_ClassInfo info = infoByClass.get(c);
      if (info == null)
        info = newClass(c);
      return info;
    }

    public structure_ClassInfo newClass(Class c) {
      structure_ClassInfo info = new structure_ClassInfo();
      info.c = c;
      infoByClass.put(c, info);
      if (isSyntheticOrAnonymous(c)) {
        info.special = info.nullInstances = true;
        return info;
      }
      if ((info.customSerializer = findMethodNamed(c, "_serialize")) != null)
        info.special = true;
      if (storeBaseClasses) {
        Class sup = c.getSuperclass();
        if (sup != Object.class) {
          append("bc ");
          append(shortDynClassNameForStructure(c));
          out.print(" ");
          append(shortDynClassNameForStructure(sup));
          out.print(" ");
          infoForClass(sup);
        }
      }
      return info;
    }

    public void setFields(structure_ClassInfo info, List<Field> fields) {
      info.fields = fields;
    }

    public void writeObject(Object o, String shortName, Map<String, Object> fv) {
      String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
      append(shortName);
      n += countDots(shortName) * 2;
      int l = n;
      Iterator it = fv.entrySet().iterator();
      stack.add(new Runnable() {

        public void run() {
          try {
            if (!it.hasNext()) {
              if (n != l)
                append(")");
            } else {
              Map.Entry e = (Map.Entry) it.next();
              append(n == l ? "(" : ", ");
              append((String) e.getKey()).append("=");
              stack.add(this);
              structure_1(e.getValue(), structure_Data.this);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!it.hasNext()) {\r\n        if (n != l)\r\n          append(\")\");\r\n      } el...";
        }
      });
    }
  }

  static public void structure_1(final Object o, final structure_Data d) {
    try {
      if (o == null) {
        d.append("null");
        return;
      }
      Class c = o.getClass();
      boolean concept = false;
      concept = o instanceof Concept;
      structure_ClassInfo info = d.infoForClass(c);
      List<Field> lFields = info.fields;
      if (lFields == null) {
        if (o instanceof Number) {
          PrintWriter out = d.out;
          if (o instanceof Integer) {
            int i = ((Integer) o).intValue();
            out.print(i);
            d.n += i < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Long) {
            long l = ((Long) o).longValue();
            out.print(l);
            out.print("L");
            d.n += l < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Short) {
            short s = ((Short) o).shortValue();
            d.append("sh ");
            out.print(s);
            d.n += s < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Float) {
            d.append("fl ", 2);
            quoteToPrintWriter(str(o), out);
            return;
          }
          if (o instanceof Double) {
            d.append("d(", 3);
            quoteToPrintWriter(str(o), out);
            d.append(")");
            return;
          }
          if (o instanceof BigInteger) {
            out.print("bigint(");
            out.print(o);
            out.print(")");
            d.n += ((BigInteger) o).signum() < 0 ? 5 : 4;
            return;
          }
        }
        if (o instanceof Boolean) {
          d.append(((Boolean) o).booleanValue() ? "t" : "f");
          return;
        }
        if (o instanceof Character) {
          d.append(quoteCharacter((Character) o));
          return;
        }
        if (o instanceof File) {
          d.append("File ").append(quote(((File) o).getPath()));
          return;
        }
        Integer ref = d.seen.get(o);
        if (o instanceof String && ref == null)
          ref = d.strings.get((String) o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        if (!(o instanceof String))
          d.seen.put(o, d.n);
        else {
          String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
          if (!d.noStringSharing) {
            if (d.shareStringsLongerThan == Integer.MAX_VALUE)
              d.seen.put(o, d.n);
            if (l(s) >= d.shareStringsLongerThan)
              d.strings.put(s, d.n);
          }
          quoteToPrintWriter(s, d.out);
          d.n++;
          return;
        }
        if (o instanceof Set) {
          if (((Set) o) instanceof TreeSet) {
            d.append(isCISet_gen((Set) o) ? "ciset" : "treeset");
            structure_1(new ArrayList((Set) o), d);
            return;
          }
          d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
          structure_1(new ArrayList((Set) o), d);
          return;
        }
        String name = c.getName();
        if (o instanceof Collection && !isJavaXClassName(name)) {
          if (name.equals("java.util.Collections$SynchronizedList") || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedList(((List) o)), d);
              return;
            }
          } else if (name.equals("java.util.LinkedList"))
            d.append("ll");
          d.append("[");
          final int l = d.n;
          final Iterator it = cloneList((Collection) o).iterator();
          d.stack.add(new Runnable() {

            public void run() {
              try {
                if (!it.hasNext())
                  d.append("]");
                else {
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(it.next(), d);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta...";
            }
          });
          return;
        }
        if (o instanceof Map && !startsWith(name, d.mcDollar)) {
          if (o instanceof LinkedHashMap)
            d.append("lhm");
          else if (o instanceof HashMap)
            d.append("hm");
          else if (o instanceof TreeMap)
            d.append(isCIMap_gen((TreeMap) o) ? "cimap" : "tm");
          else if (name.equals("java.util.Collections$SynchronizedMap") || name.equals("java.util.Collections$SynchronizedSortedMap") || name.equals("java.util.Collections$SynchronizedNavigableMap")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedMap(((Map) o)), d);
              return;
            }
          }
          d.append("{");
          final int l = d.n;
          final Iterator it = cloneMap((Map) o).entrySet().iterator();
          d.stack.add(new Runnable() {

            public boolean v = false;

            public Map.Entry e;

            public void run() {
              if (v) {
                d.append("=");
                v = false;
                d.stack.add(this);
                structure_1(e.getValue(), d);
              } else {
                if (!it.hasNext())
                  d.append("}");
                else {
                  e = (Map.Entry) it.next();
                  v = true;
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(e.getKey(), d);
                }
              }
            }
          });
          return;
        }
        if (c.isArray()) {
          if (o instanceof byte[]) {
            d.append("ba ").append(quote(bytesToHex((byte[]) o)));
            return;
          }
          final int n = Array.getLength(o);
          if (o instanceof boolean[]) {
            String hex = boolArrayToHex((boolean[]) o);
            int i = l(hex);
            while (i > 0 && hex.charAt(i - 1) == '0' && hex.charAt(i - 2) == '0') i -= 2;
            d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i)));
            return;
          }
          String atype = "array";
          if (o instanceof int[]) {
            atype = "intarray";
          } else if (o instanceof double[]) {
            atype = "dblarray";
          } else {
            Pair<Class, Integer> p = arrayTypeAndDimensions(c);
            if (p.a == int.class)
              atype = "intarray";
            else if (p.a == byte.class)
              atype = "bytearray";
            else if (p.a == boolean.class)
              atype = "boolarray";
            else if (p.a == double.class)
              atype = "dblarray";
            else if (p.a == String.class) {
              atype = "array S";
              d.n++;
            } else
              atype = "array";
            if (p.b > 1) {
              atype += "/" + p.b;
              d.n += 2;
            }
          }
          d.append(atype).append("{");
          d.stack.add(new Runnable() {

            public int i;

            public void run() {
              if (i >= n)
                d.append("}");
              else {
                d.stack.add(this);
                if (i > 0)
                  d.append(", ");
                structure_1(Array.get(o, i++), d);
              }
            }
          });
          return;
        }
        if (o instanceof Class) {
          d.append("class(", 2).append(quote(((Class) o).getName())).append(")");
          return;
        }
        if (o instanceof Throwable) {
          d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")");
          return;
        }
        if (o instanceof BitSet) {
          BitSet bs = (BitSet) o;
          d.append("bitset{", 2);
          int l = d.n;
          for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i + 1)) {
            if (d.n != l)
              d.append(", ");
            d.append(i);
          }
          d.append("}");
          return;
        }
        if (name.startsWith("java.") || name.startsWith("javax.")) {
          d.append("j ").append(quote(str(o)));
          return;
        }
        if (info.special) {
          if (info.customSerializer != null) {
            Object o2 = invokeMethod(info.customSerializer, o);
            d.append("cu ");
            String shortName = dropPrefix(d.mcDollar, name);
            d.append(shortName);
            d.out.append(' ');
            structure_1(o2, d);
            return;
          } else if (info.nullInstances) {
            d.append("null");
            return;
          } else if (info.serializeObject != null) {
            info.serializeObject.get(o);
            return;
          } else
            throw fail("unknown special type");
        }
        String dynName = shortDynClassNameForStructure(o);
        if (concept && !d.concepts.contains(dynName)) {
          d.concepts.add(dynName);
          d.append("c ");
        }
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {

          public int compare(Field a, Field b) {
            return stdcompare(a.getName(), b.getName());
          }
        });
        Class cc = c;
        while (cc != Object.class) {
          for (Field field : getDeclaredFields_cached(cc)) {
            String fieldName = field.getName();
            if (fieldName.equals("_persistenceInfo"))
              d.persistenceInfo.put(c, field);
            if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
              continue;
            fields.add(field);
          }
          cc = cc.getSuperclass();
        }
        lFields = asList(d.honorFieldOrder ? fieldObjectsInFieldOrder(c, fields) : fields);
        int n = l(lFields);
        for (int i = 0; i < n; i++) {
          Field f = lFields.get(i);
          if (f.getName().startsWith("this$")) {
            lFields.remove(i);
            lFields.add(0, f);
            break;
          }
        }
        d.setFields(info, lFields);
      } else {
        Integer ref = d.seen.get(o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        d.seen.put(o, d.n);
      }
      Field persistenceInfoField = (Field) (d.persistenceInfo.get(c));
      Map<String, Object> persistenceInfo = persistenceInfoField == null ? null : (Map) persistenceInfoField.get(o);
      if (persistenceInfoField == null && o instanceof DynamicObject)
        persistenceInfo = (Map<String, Object>) getOptDynOnly(((DynamicObject) o), "_persistenceInfo");
      LinkedHashMap<String, Object> fv = new LinkedHashMap();
      for (Field f : lFields) {
        Object value;
        try {
          value = f.get(o);
        } catch (Exception e) {
          value = "?";
        }
        if (value != null && (persistenceInfo == null || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
          fv.put(f.getName(), value);
      }
      String name = c.getName();
      String shortName = dropPrefix("loadableUtils.utils$", dropPrefix(d.mcDollar, name));
      if (startsWithDigit(shortName))
        shortName = name;
      if (concept && eq(fv.get("className"), shortName))
        fv.remove("className");
      if (o instanceof DynamicObject) {
        putAll(fv, (Map) fv.get("fieldValues"));
        fv.remove("fieldValues");
        shortName = shortDynClassNameForStructure(o);
        fv.remove("className");
      }
      d.writeObject(o, shortName, fv);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  volatile static public boolean conceptsAndBot_running = false;

  static public boolean conceptsAndBot_thinOnStart = true;

  static public void conceptsAndBot() {
    conceptsAndBot(null);
  }

  static public void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    Concepts cc = db_mainConcepts();
    try {
      if (cc.useFileLock) {
        if (!cc.fileLock().tryToLock()) {
          ensureDBNotRunning(dbBotStandardName());
          cc.fileLock().forceLock();
        }
      } else
        ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable _e) {
      cc.dontSave = true;
      throw rethrow(_e);
    }
    cc.persist(autoSaveInterval);
    dbBot(false);
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  static public <A extends Concept> A derefRef(Concept.Ref<A> r) {
    return r == null ? null : r.get();
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public boolean _csetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (value instanceof RC)
        value = c._concepts.getConcept((RC) value);
      value = deref(value);
      if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan)
        value = intern((String) value);
      if (f == null) {
        assertIdentifier(field);
        Object oldVal = mapGet(c.fieldValues, field);
        if (value instanceof Concept) {
          if (oldVal instanceof Concept.Ref)
            return ((Concept.Ref) oldVal).set((Concept) value);
          else {
            dynamicObject_setRawFieldValue(c, field, c.new Ref((Concept) value));
            c.change();
            return true;
          }
        } else {
          if (oldVal instanceof Concept.Ref)
            ((Concept.Ref) oldVal).unindexAndDrop();
          if (eq(oldVal, value))
            return false;
          if (isConceptList(value) && nempty(((List) value))) {
            dynamicObject_setRawFieldValue(c, field, c.new RefL(((List) value)));
            c.change();
            return true;
          }
          if (value == null) {
            dynamicObject_dropRawField(c, field);
          } else {
            if (!isPersistable(value))
              throw fail("Can't persist: " + c + "." + field + " = " + value);
            dynamicObject_setRawFieldValue(c, field, value);
          }
          c.change();
          return true;
        }
      } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
        ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
        c.change();
        return true;
      } else if (isSubtypeOf(f.getType(), Concept.RefL.class)) {
        ((Concept.RefL) f.get(c)).replaceWithList(lmap(__83 -> derefRef(__83), (List) value));
        c.change();
        return true;
      } else {
        Object old = f.get(c);
        if (neq(value, old)) {
          boolean isTransient = isTransient(f);
          if (!isTransient && !isPersistable(value))
            throw fail("Can't persist: " + c + "." + field + " = " + value);
          f.set(c, value);
          if (!isTransient)
            c.change();
          return true;
        }
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String unnullForIteration(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnullForIteration(Collection<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public <A> List<A> unnullForIteration(List<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public int[] unnullForIteration(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnullForIteration(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnullForIteration(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public short[] unnullForIteration(short[] l) {
    return l == null ? emptyShortArray() : l;
  }

  static public <A, B> Map<A, B> unnullForIteration(Map<A, B> l) {
    return l == null ? immutableEmptyMap() : l;
  }

  static public <A> Iterable<A> unnullForIteration(Iterable<A> i) {
    return i == null ? immutableEmptyList() : i;
  }

  static public <A> A[] unnullForIteration(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnullForIteration(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnullForIteration(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnullForIteration(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnullForIteration(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public long unnullForIteration(Long l) {
    return l == null ? 0L : l;
  }

  static public <A> A getVar(IF0<A> v) {
    return v == null ? null : v.get();
  }

  static public <A> A getVar(Optional<A> v) {
    return v == null ? null : v.orElse(null);
  }

  static public String combinePrintParameters(String s, Object o) {
    return (endsWithLetterOrDigit(s) ? s + ": " : s) + o;
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public String getStackTrace(String msg) {
    return getStackTrace_noRecord(new Throwable(msg));
  }

  static public boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  static public boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  static public boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return classLoaderForObject(realm).loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Object fieldGet(Field f, Object o) {
    try {
      return f == null ? null : f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public boolean isNonNegativeInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public Map syncHashMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> newWeakMap() {
    return newWeakHashMap();
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public String tb_mainServer_default = "https://code.botcompany.de:9898";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A, B> Set<A> keys(MultiSetMap<A, B> mm) {
    return mm.keySet();
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    return con.getInputStream();
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public byte[] utf8(String s) {
    return toUtf8(s);
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public String loadLocalSnippet(String snippetID) {
    return loadLocalSnippet(psI(snippetID));
  }

  static public String loadLocalSnippet(long snippetID) {
    return loadTextFile(localSnippetFile(snippetID));
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      mkdirsForFile(file);
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      vmBus_send("wroteFile", file);
      return file;
    } finally {
      action.done();
    }
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public DialogIO talkTo(int port) {
    return talkTo("localhost", port);
  }

  static public int talkTo_defaultTimeout = 10000;

  static public int talkTo_timeoutForReads = 0;

  static public ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

  static public DialogIO talkTo(String ip, int port) {
    try {
      String full = ip + ":" + port;
      Map<String, DialogIO> map = talkTo_byThread.get();
      if (map != null && map.containsKey(full))
        return map.get(full);
      if (isLocalhost(ip) && port == vmPort())
        return talkToThisVM();
      return new talkTo_IO(ip, port);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class talkTo_IO extends DialogIO {

    public String ip;

    public int port;

    public Socket s;

    public Writer w;

    public BufferedReader in;

    public talkTo_IO(String ip, int port) {
      this.port = port;
      this.ip = ip;
      try {
        s = new Socket();
        try {
          if (talkTo_timeoutForReads != 0)
            s.setSoTimeout(talkTo_timeoutForReads);
          s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
        } catch (Throwable e) {
          throw fail("Tried talking to " + ip + ":" + port, e);
        }
        w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
        in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }

    public boolean isStillConnected() {
      return !(eos || s.isClosed());
    }

    public void sendLine(String line) {
      try {
        Lock __0 = lock;
        lock(__0);
        try {
          w.write(line + "\n");
          w.flush();
        } finally {
          unlock(__0);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLineImpl() {
      try {
        return in.readLine();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
      try {
        if (!noClose)
          s.close();
      } catch (IOException e) {
      }
    }

    public Socket getSocket() {
      return s;
    }
  }

  static public Map<String, Integer> newFindBot2_cache = synchroHashMap();

  static public boolean newFindBot2_verbose = false;

  static public DialogIO newFindBot2(String name) {
    Integer port = newFindBot2_cache.get(name);
    if (port != null) {
      if (newFindBot2_verbose)
        print("newFindBot2: testing " + name + " => " + port);
      DialogIO io = talkTo(port);
      String q = format("has bot *", name);
      String s = io.ask(q);
      if (match("yes", s)) {
        io = talkToSubBot(name, io);
        call(io, "pushback", "?");
        return io;
      }
      newFindBot2_cache.remove(name);
      if (newFindBot2_verbose)
        print("newFindBot2: dropping " + name + " => " + port);
    }
    DialogIO io = findBot(name);
    if (io != null) {
      newFindBot2_cache.put(name, io.getPort());
      if (newFindBot2_verbose)
        print("newFindBot2: remembering " + name + " => " + port);
    }
    return io;
  }

  static public TableWithTooltips tableWithToolTips() {
    return tableWithTooltips();
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public List<String> getTableLine(JTable tbl, int row) {
    if (row >= 0 && row < tbl.getModel().getRowCount()) {
      List<String> l = new ArrayList();
      for (int i = 0; i < tbl.getModel().getColumnCount(); i++) l.add(String.valueOf(tbl.getModel().getValueAt(row, i)));
      return l;
    }
    return null;
  }

  static public <A extends Image> A copyImageToClipboard(A img) {
    TransferableImage trans = new TransferableImage(img);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    vmBus_send("newClipboardContents", img);
    print("Copied image to clipboard (" + img.getWidth(null) + "*" + img.getHeight(null) + " px)");
    return img;
  }

  static public JTextField jTextField() {
    return jTextField("");
  }

  static public JTextField jTextField(final String text) {
    return swing(new F0<JTextField>() {

      public JTextField get() {
        try {
          JTextField tf = new JTextField(unnull(text));
          standardTextFieldPopupMenu(tf);
          jenableUndoRedo(tf);
          tf.selectAll();
          return tf;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextField tf = new JTextField(unnull(text));\r\n    standardTextFieldPopupMenu...";
      }
    });
  }

  static public JTextField jTextField(Object o) {
    return jTextField(strOrEmpty(o));
  }

  static public JComponent showTitledForm(String title, Object... _parts) {
    return showFormTitled(title, _parts);
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public int convertTableRowToModel(final JTable t, final int viewRow) {
    return t == null || viewRow < 0 ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.convertRowIndexToModel(viewRow);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.convertRowIndexToModel(viewRow);";
      }
    });
  }

  static public MouseListener findComponentPopupMenuListener_gen(final JComponent c) {
    return c == null ? null : swing(() -> firstWithClassShortNamed("componentPopupMenu_Adapter", c.getMouseListeners()));
  }

  static public boolean internalFrameActive(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    return f != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return f.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.isSelected();";
      }
    });
  }

  static public <A> A getWeakRef(Reference<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public <A> A firstInstanceOf(Iterable i, Class<A> c) {
    if (i == null)
      return null;
    c = primitiveToBoxedTypeOpt(c);
    for (Object o : i) if (isInstance(c, o))
      return (A) o;
    return null;
  }

  static public <A> A firstInstanceOf(Class<A> c, Iterable i) {
    return firstInstanceOf(i, c);
  }

  static public <A> A firstInstanceOf(Object[] a, Class<A> c) {
    if (a == null)
      return null;
    c = primitiveToBoxedTypeOpt(c);
    for (Object o : a) if (isInstance(c, o))
      return (A) o;
    return null;
  }

  static public boolean isUnstructuring() {
    return isTrue(getTL(dynamicObjectIsLoading_threadLocal()));
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static public HashMap<String, List<Method>> callMC_cache = new HashMap();

  static public String callMC_key;

  static public Method callMC_value;

  static public Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  static public Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Iterable it, Object a) {
    if (it != null)
      for (Object o : it) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public float clamp(float x, float a, float b) {
    return x < a ? a : x > b ? b : x;
  }

  static public double clamp(double x, double a, double b) {
    return x < a ? a : x > b ? b : x;
  }

  static public int clamp(int x, int a, int b) {
    return x < a ? a : x > b ? b : x;
  }

  static public long clamp(long x, long a, long b) {
    return x < a ? a : x > b ? b : x;
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public Object dm_getStem(Object moduleOrID) {
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      moduleOrID = dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_getStemByID(moduleOrID);
    return or(getOpt(dm_getModule(moduleOrID), "_host"), moduleOrID);
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, lCharSequence(l));
  }

  static public RootPaneContainer getPossiblyInternalFrame(Component c) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      return f;
    return optCast(RootPaneContainer.class, getWindow(c));
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public JPanel jpanel(LayoutManager layout) {
    return swingNu(JPanel.class, layout);
  }

  static public JPanel jpanel() {
    return swingNu(JPanel.class);
  }

  static public Window getWindow(Object o) {
    if (!(o instanceof Component))
      return null;
    return swing(() -> {
      Component c = (Component) o;
      while (c != null) {
        if (c instanceof Window)
          return ((Window) c);
        c = c.getParent();
      }
      return null;
    });
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public <A extends Comparable<A>> A max(A a, A b) {
    return cmp(a, b) >= 0 ? a : b;
  }

  static public boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnull(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public int unnull(Integer i) {
    return i == null ? 0 : i;
  }

  static public long unnull(Long l) {
    return l == null ? 0L : l;
  }

  static public double unnull(Double l) {
    return l == null ? 0.0 : l;
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public <A> String lines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines(l, f);
  }

  static public <A extends Component> A revalidate(final A c) {
    if (c == null || !c.isShowing())
      return c;
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.revalidate();
            c.repaint();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// magic combo to actually relayout and repaint\r\n    c.revalidate();\r\n    c.r...";
        }
      });
    }
    return c;
  }

  static public void revalidate(JFrame f) {
    revalidate((Component) f);
  }

  static public void revalidate(JInternalFrame f) {
    revalidate((Component) f);
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public <A> int smartLastIndexOf(List<A> l, A sub) {
    int i = lastIndexOf(l, sub);
    return i < 0 ? l(l) : i;
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Long> asList(long[] a) {
    if (a == null)
      return null;
    ArrayList<Long> l = emptyList(a.length);
    for (long i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public ArrayList<Short> asList(short[] a) {
    if (a == null)
      return null;
    ArrayList<Short> l = emptyList(a.length);
    for (short i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterator<A> it) {
    ArrayList l = new ArrayList();
    if (it != null)
      while (it.hasNext()) l.add(it.next());
    return l;
  }

  static public <A> ArrayList<A> asList(IterableIterator<A> s) {
    return asList((Iterator) s);
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A> ArrayList<A> asList(ReverseChain<A> c) {
    return c == null ? emptyList() : c.toList();
  }

  static public <A> List<A> asList(Pair<A, A> p) {
    return p == null ? null : ll(p.a, p.b);
  }

  static public JPanel marginPanel() {
    return jtransparent(borderLayoutPanel());
  }

  static public ActionListener actionListener(final Object runnable) {
    return actionListener(runnable, null);
  }

  static public ActionListener actionListener(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    final Object info = _threadInfo();
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          _threadInheritInfo(info);
          AutoCloseable __1 = holdInstance(instanceToHold);
          try {
            callF(runnable);
          } finally {
            _close(__1);
          }
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  static public int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  static public boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  static public boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Runnable runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(runnable, name));
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public int imageIcon_cacheSize = 10;

  static public boolean imageIcon_verbose = false;

  static public Map<String, ImageIcon> imageIcon_cache;

  static public Lock imageIcon_lock = lock();

  static public ThreadLocal<Boolean> imageIcon_fixGIF = new ThreadLocal();

  static public ImageIcon imageIcon(String imageID) {
    try {
      if (imageID == null)
        return null;
      Lock __0 = imageIcon_lock;
      lock(__0);
      try {
        if (imageIcon_cache == null)
          imageIcon_cache = new MRUCache(imageIcon_cacheSize);
        imageID = fsI(imageID);
        ImageIcon ii = imageIcon_cache.get(imageID);
        if (ii == null) {
          if (imageIcon_verbose)
            print("Loading image icon: " + imageID);
          File f = loadBinarySnippet(imageID);
          Boolean b = imageIcon_fixGIF.get();
          if (!isFalse(b))
            ii = new ImageIcon(loadBufferedImageFixingGIFs(f));
          else
            ii = new ImageIcon(f.toURI().toURL());
        } else
          imageIcon_cache.remove(imageID);
        imageIcon_cache.put(imageID, ii);
        return ii;
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(File f) {
    try {
      return new ImageIcon(f.toURI().toURL());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(Image img) {
    return new ImageIcon(img);
  }

  static public ImageIcon imageIcon(RGBImage img) {
    return imageIcon(img.getBufferedImage());
  }

  static public String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  static public String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, List<A> l) {
    return subList(l, startIndex);
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex > endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public IF0<PingSource> ping_v3_pingSourceMaker_cache;

  static public IF0<PingSource> ping_v3_pingSourceMaker() {
    if (ping_v3_pingSourceMaker_cache == null)
      ping_v3_pingSourceMaker_cache = ping_v3_pingSourceMaker_load();
    return ping_v3_pingSourceMaker_cache;
  }

  static public IF0<PingSource> ping_v3_pingSourceMaker_load() {
    return or((IF0) vm_generalMap_get("ping_v3_pingSourceMaker"), () -> null);
  }

  static public Runnable wrapAsActivity(Object r) {
    if (r == null)
      return null;
    Runnable r2 = toRunnable(r);
    Object mod = dm_current_generic();
    if (mod == null)
      return r2;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable c = (AutoCloseable) (rcall("enter", mod));
          AutoCloseable __1 = c;
          try {
            r2.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "AutoCloseable c =  (AutoCloseable) (rcall enter(mod));\r\n    temp c;\r\n    r2.r...";
      }
    };
  }

  static public Runnable toRunnable(final Object o) {
    if (o instanceof Runnable)
      return (Runnable) o;
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public BufferedImage newBufferedImage(int w, int h) {
    return new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
  }

  static public BufferedImage newBufferedImage(int w, int h, RGB rgb) {
    return newBufferedImage(w, h, rgb.getColor());
  }

  static public BufferedImage newBufferedImage(int w, int h, Color color) {
    BufferedImage img = newBufferedImage(w, h);
    Graphics2D g = img.createGraphics();
    g.setColor(or(color, Color.white));
    g.fillRect(0, 0, w, h);
    return img;
  }

  static public BufferedImage newBufferedImage(Pt p, Color color) {
    return newBufferedImage(p.x, p.y, color);
  }

  static public BufferedImage newBufferedImage(int w, int h, int[] pixels) {
    return intArrayToBufferedImage(pixels, w, h);
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(Object... c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static public DynModule dm_current_mandatory() {
    return assertNotNull("No module set!", dm_currentModule());
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  static public File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  static public String dropSuffix(String suffix, String s) {
    return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  static public boolean arraysEqual(Object[] a, Object[] b) {
    if (a.length != b.length)
      return false;
    for (int i = 0; i < a.length; i++) if (neq(a[i], b[i]))
      return false;
    return true;
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public <A> List<A> wrapArrayAsList(A[] a) {
    return a == null ? null : Arrays.asList(a);
  }

  static public BufferedImage intArrayToBufferedImage(int[] pixels, int w, int h) {
    int[] bitMasks = new int[] { 0xFF0000, 0xFF00, 0xFF, 0xFF000000 };
    SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(DataBuffer.TYPE_INT, w, h, bitMasks);
    DataBufferInt db = new DataBufferInt(pixels, pixels.length);
    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point());
    return new BufferedImage(ColorModel.getRGBdefault(), wr, false, null);
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public int getWidth(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getWidth");
  }

  static public int getHeight(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getHeight");
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Random random_random = new Random();

  static public int random(int n) {
    return random(random_random, n);
  }

  static public int random(int n, Random r) {
    return random(r, n);
  }

  static public int random(Random r, int n) {
    return n <= 0 ? 0 : r.nextInt(n);
  }

  static public double random(double max) {
    return random() * max;
  }

  static public double random() {
    return random_random.nextInt(100001) / 100000.0;
  }

  static public double random(double min, double max) {
    return min + random() * (max - min);
  }

  static public int random(int min, int max) {
    return min + random(max - min);
  }

  static public int random(int min, int max, Random r) {
    return random(r, min, max);
  }

  static public int random(Random r, int min, int max) {
    return min + random(r, max - min);
  }

  static public <A> A random(List<A> l) {
    return oneOf(l);
  }

  static public <A> A random(Collection<A> c) {
    if (c instanceof List)
      return random((List<A>) c);
    int i = random(l(c));
    return collectionGet(c, i);
  }

  static public int random(IntRange r) {
    return random(r.start, r.end);
  }

  static public <A, B> Pair<A, B> random(Map<A, B> map) {
    return entryToPair(random(entries(map)));
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public <A> A swingNu(final Class<A> c, final Object... args) {
    return swingConstruct(c, args);
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && b != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void __setJavaX(Class j) {
    __javax = j;
    _onJavaXSet();
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public void messageBox(final String msg) {
    if (headless())
      print(msg);
    else {
      swing(new Runnable() {

        public void run() {
          try {
            JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MES...";
        }
      });
    }
  }

  static public void messageBox(Throwable e) {
    printStackTrace(e);
    messageBox(hideCredentials(innerException2(e)));
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public byte[] intToBytes(int i) {
    return new byte[] { (byte) (i >>> 24), (byte) (i >>> 16), (byte) (i >>> 8), (byte) i };
  }

  static public String makePostData(Map map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : castMapToMapO(map).entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    return oneOfTheFiles(asList(files));
  }

  static public File oneOfTheFiles(Iterable<File> files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<AbstractButton> buttonsInGroup(ButtonGroup g) {
    if (g == null)
      return ll();
    return asList(g.getElements());
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isAbsolutePath(snippetIDOrURLOrFile))
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
      if (!isSnippetID(snippetIDOrURLOrFile))
        throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
      String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return loadBufferedImage(rl.loadLibrary(snippetID));
      File dir = imageSnippetsCacheDir();
      if (loadBufferedImage_useImageCache) {
        dir.mkdirs();
        File file = new File(dir, snippetID + ".png");
        if (file.exists() && file.length() != 0)
          try {
            return ImageIO.read(file);
          } catch (Throwable e) {
            e.printStackTrace();
          }
      }
      String imageURL = snippetImageURL_http(snippetID);
      print("Loading image: " + imageURL);
      BufferedImage image = imageIO_readURL(imageURL);
      if (loadBufferedImage_useImageCache) {
        File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
        ImageIO.write(image, "png", tempFile);
        tempFile.renameTo(new File(dir, snippetID + ".png"));
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    return loadBufferedImageFile(file);
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(Symbol a, Symbol b) {
    return eq(a, b);
  }

  static public boolean eqic(Symbol a, String b) {
    return eqic(asString(a), b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public double doubleRatio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public double doubleRatio(Seconds x, Seconds y) {
    return doubleRatio(x.get(), y.get());
  }

  static public AbstractAction abstractAction(String name, final Object runnable) {
    return new AbstractAction(name) {

      public void actionPerformed(ActionEvent evt) {
        pcallF(runnable);
      }
    };
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  static public List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  static public int toLines_nextLineBreak(String s, int start) {
    int n = s.length();
    for (int i = start; i < n; i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public JScrollPane jscroll(final Component c) {
    return swing(new F0<JScrollPane>() {

      public JScrollPane get() {
        try {
          return new JScrollPane(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JScrollPane(c);";
      }
    });
  }

  static public Map synchronizedMap() {
    return synchroMap();
  }

  static public <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
    return synchroMap(map);
  }

  static public <A extends Component> A jMinWidth(final int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          c.setMinimumSize(new Dimension(w, size.height));
          return jPreferWidth(w, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    c.setMinimumSize(new Dimension(/*ma...";
      }
    });
  }

  static public List<DoublePt> graphAsPolygon(IF1<Double, Double> formula, int w, int h) {
    List<DoublePt> points = new ArrayList();
    points.add(new DoublePt(0, 0));
    for (int x = 0; x < w; x++) {
      double y = formula.get(doubleRatio(x, w)) * h;
      points.add(new DoublePt(x, y));
    }
    points.add(new DoublePt(w - 1, 0));
    return points;
  }

  static public double sineSigmoid(double x) {
    return 0.5 * (1 + sin(pi() * (x - .5)));
  }

  static public void fillPrecisePolygon(BufferedImage g, List<DoublePt> points, Color color) {
    fillPrecisePolygon(graphics(g), points, color);
  }

  static public void fillPrecisePolygon(Graphics2D g, List<DoublePt> points, Color color) {
    g.setColor(color);
    g.fill(new PrecisePolygon(points));
  }

  static public void fillPrecisePolygon(BufferedImage g, List<DoublePt> points) {
    fillPrecisePolygon(graphics(g), points);
  }

  static public void fillPrecisePolygon(Graphics2D g, List<DoublePt> points) {
    g.fill(new PrecisePolygon(points));
  }

  static public Color gazelle_color1() {
    return awtColor("ADD8E6");
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public long fileSize(String path) {
    return getFileSize(path);
  }

  static public long fileSize(File f) {
    return getFileSize(f);
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      return loadDataSnippetToFile_noResourceLoader(snippetID);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadDataSnippetToFile_noResourceLoader(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  static public boolean byteArrayStartsWith(byte[] a, byte[] b) {
    if (a == null || b == null)
      return false;
    if (a.length < b.length)
      return false;
    for (int i = 0; i < b.length; i++) if (a[i] != b[i])
      return false;
    return true;
  }

  static public byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
    return loadBinaryFilePart(file, 0, maxBytes);
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public <A> String mapToLines(IF1<A, String> f, A data1, A... moreData) {
    return lines(map(f, data1, moreData));
  }

  static public boolean jmenuItem_newThreads = false;

  static public JMenuItem jmenuItem(final String text) {
    return jMenuItem(text, null);
  }

  static public JMenuItem jmenuItem(final String text, final Object r) {
    return swing(new F0<JMenuItem>() {

      public JMenuItem get() {
        try {
          Pair<String, Integer> p = jmenu_autoMnemonic(dropPrefix("[disabled] ", text));
          JMenuItem mi = new JMenuItem(p.a);
          if (startsWith(text, "[disabled] "))
            disableMenuItem(mi);
          if (p.b != 0)
            mi.setMnemonic(p.b);
          mi.addActionListener(jmenuItem_newThreads ? actionListenerInNewThread(r) : actionListener(r));
          return mi;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Pair<S, Int> p = jmenu_autoMnemonic(dropPrefix(\"[disabled] \", text));\r\n    JM...";
      }
    });
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public int toInt_checked(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public String regularLineBreaks(int charsPerLine, String s) {
    if (l(s) < charsPerLine)
      return s;
    StringBuilder buf = new StringBuilder();
    int n = l(s), j = 0;
    for (int i = 0; i < n; i++) {
      buf.append(s.charAt(i));
      if (++j >= charsPerLine) {
        buf.append('\n');
        j = 0;
      }
    }
    return str(buf);
  }

  static public java.awt.Color awtColor(String hex) {
    byte[] b = bytesFromHex(dropPrefix("#", hex));
    return new Color(ubyteToInt(b[0]), ubyteToInt(b[1]), ubyteToInt(b[2]));
  }

  static public File pathToJavaxJar() {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.pathToJavaXJar();
    return pathToJavaxJar_noResourceLoader();
  }

  static public File pathToJavaxJar_noResourceLoader() {
    try {
      int x = latestInstalledJavaX();
      File xfile = new File(userHome(), ".javax/x" + Math.max(x, 30) + ".jar");
      if (!xfile.isFile()) {
        print("Saving " + f2s(xfile));
        String url = x30JarServerURL();
        byte[] data = loadBinaryPage(url);
        if (data.length < 1000000)
          throw fail("Could not load " + url);
        saveBinaryFile(xfile.getPath(), data);
      }
      return xfile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A firstWithClassShortNamed(String shortName, Iterable<A> l) {
    if (l != null)
      for (A o : l) if (eq(shortClassName(o), shortName))
        return o;
    return null;
  }

  static public <A> A firstWithClassShortNamed(String shortName, A[] l) {
    if (l != null)
      for (A o : l) if (eq(shortClassName(o), shortName))
        return o;
    return null;
  }

  static public MenuItem menuItem(String text, final Object r) {
    MenuItem mi = new MenuItem(text);
    mi.addActionListener(actionListener(r));
    return mi;
  }

  static public ThreadLocal<Boolean> imageGraphics_antiAlias = new ThreadLocal();

  static public Graphics2D imageGraphics(BufferedImage img) {
    return !isFalse(imageGraphics_antiAlias.get()) ? antiAliasGraphics(img) : createGraphics(img);
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  static public BufferedImage drawImage(BufferedImage canvas, Image img, Pt p) {
    return drawImageOnImage(img, canvas, p.x, p.y);
  }

  static public void drawImage(BufferedImage g, Image img) {
    drawImage(graphics(g), img);
  }

  static public void drawImage(Graphics2D g, Image img) {
    drawImage(g, img, 0, 0);
  }

  static public void drawImage(Graphics2D g, Image img, Pt p) {
    drawImage(g, img, p.x, p.y);
  }

  static public void drawImage(Graphics2D g, Image img, int x, int y) {
    {
      if (g != null)
        g.drawImage(img, x, y, null);
    }
  }

  static public String joinNempties(String sep, Object... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Iterable strings) {
    return joinStrings(sep, strings);
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return in == null ? null : bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(strOrNull(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String mainClassNameForClassLoader(ClassLoader cl) {
    return or((String) callOpt(cl, "mainClassName"), "main");
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public String javaxDefaultVMArgs() {
    File fileNew, fileOld;
    String text = loadTextFile(fileNew = javaxDataDir("default-vm-args"));
    if (text == null) {
      text = loadTextFile(fileOld = programFile("#1005850", "default-vm-args"));
      if (text != null)
        moveFile(fileOld, fileNew);
    }
    return trim(unnull(text));
  }

  static public void appendToLocalMechLog(String listName, String text) {
    logMechListAppendLocally(listName, text);
  }

  static public List<String> dropSecondIfEmpty(String a, String b) {
    return empty(b) ? ll(a) : ll(a, b);
  }

  static public int parseFirstInt(String s) {
    return parseInt(jextract("<int>", s));
  }

  static public int parseFirstInt(Iterable<String> l) {
    return parseInt(firstIntegerString(l));
  }

  static public boolean usePreSpunVMs() {
    return eq("1", trim(loadProgramTextFile("#1005457", "enable-prespun-vms")));
  }

  static public void usePreSpunVMs(boolean flag) {
    saveProgramTextFile("#1005457", "enable-prespun-vms", flag ? "1" : null);
  }

  static public File classicNohupJavax(String javaxargs) {
    return classicNohupJavax(javaxargs, "");
  }

  static public File classicNohupJavax(String javaxargs, String vmArgs) {
    try {
      File jar = pathToJavaxJar();
      if (javaxargs.startsWith("#"))
        javaxargs = javaxargs.substring(1);
      String tempPrefix = takeFirst(30, nohup_sanitize(ymd_minus_hms() + "_" + javaxargs + "_"));
      File outFile;
      try {
        outFile = File.createTempFile(tempPrefix, "");
      } catch (Throwable e) {
        printStackTrace(e);
        print("Temp file creation failed for " + tempPrefix + ", trying again.");
        outFile = File.createTempFile("", "");
      }
      String cmd = joinWithSpace((platformParseArgs(_javaCommand() + " " + vmArgs))) + " -jar " + (isWindows() ? winQuote(jar) : bashQuote(jar)) + " " + javaxargs;
      nohup(cmd, outFile, false);
      return outFile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean isEmpty(DoubleRange r) {
    return r == null || r.isEmpty();
  }

  static public boolean isEmpty(AppendableChain c) {
    return c == null;
  }

  static public void addDirectMenuItem(JMenuBar mb, String text, Object action) {
    if (mb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            addDirectMenuItem(mb, directJMenuItem(text, action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "addDirectMenuItem(mb, directJMenuItem(text, action));";
        }
      });
    }
  }

  static public void addDirectMenuItem(Component c, String text, Object action) {
    addDirectMenuItem(addMenuBar(c), text, action);
  }

  static public void addDirectMenuItem(JMenuBar mb, JMenuItem menuItem) {
    if (mb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mb.add(menuItem);
            revalidate(mb);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mb.add(menuItem);\r\n    revalidate(mb);";
        }
      });
    }
  }

  static public <A extends Component> A _recordNewSwingComponent(A c) {
    if (c != null)
      callF((Object) vm_generalMap_get("newSwingComponentRegistry"), (Object) c);
    return c;
  }

  static public JComponent componentToJComponent(Component c) {
    if (c instanceof JComponent)
      return (JComponent) c;
    if (c instanceof JFrame)
      return ((JFrame) c).getRootPane();
    if (c == null)
      return null;
    throw fail("boohoo " + getClassName(c));
  }

  static public int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      vmBus_send("locking", lock, "thread", currentThread());
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      vmBus_send("locked", lock, "thread", currentThread());
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public void raiseFlagAndDo(Flag flag, Runnable r) {
    if (flag.raise())
      callF(r);
  }

  static public void _handleException_addHandler(Object handler) {
    addIfNotThere(_handleException_onException, handler);
  }

  static public void _handleException_addHandler(IVF1<Throwable> handler) {
    _handleException_addHandler((Object) handler);
  }

  static public <A> A assertNull(A a) {
    assertTrue(a == null);
    return a;
  }

  static public <A> A assertNull(String msg, A a) {
    assertTrue(msg, a == null);
    return a;
  }

  static public JInternalFrame getInternalFrame(final Object _o) {
    return _o == null ? null : swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JInternalFrame)
              return (JInternalFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A extends Component> A internalFrameTitle(A c, final String title) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(unnull(title));
            toolTip(getInternalFrameTitlePaneComponent(f), title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(unnull(title));\r\n    toolTip(getInternalFrameTitlePaneComponent(f)...";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A internalFrameTitle(String title, A c) {
    return internalFrameTitle(c, title);
  }

  static public String internalFrameTitle(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    return f == null ? null : swing(new F0<String>() {

      public String get() {
        try {
          return f.getTitle();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.getTitle();";
      }
    });
  }

  static public <A extends Component> A frameTitle(A c, String title) {
    return setFrameTitle(c, title);
  }

  static public <A extends Component> A frameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public String frameTitle(Component c) {
    return getFrameTitle(c);
  }

  static public void pcallFAll_minimalExceptionHandling(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        ping();
        pcallF_minimalExceptionHandling(f, args);
      }
  }

  static public void pcallFAll_minimalExceptionHandling(Iterator it, Object... args) {
    while (it.hasNext()) {
      ping();
      pcallF_minimalExceptionHandling(it.next(), args);
    }
  }

  static public Set<AutoCloseable> _registerAutoCloseable_set = synchroHashSet();

  static public void _registerAutoCloseable(AutoCloseable c) {
    addIfNotNull(_registerAutoCloseable_set, c);
  }

  static public void cleanMeUp__registerAutoCloseable() {
    closeAutoCloseables(getAndClearList(_registerAutoCloseable_set));
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A shallowCloneToClass(Class<A> c, Object o) {
    if (o == null)
      return null;
    A a = nuInstance(c);
    copyFields(o, a);
    return a;
  }

  static public Method findMethod_precise_onTypes(Object o, String method, Class... argTypes) {
    try {
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        Lowest<Method> best = new Lowest();
        if (methods != null)
          for (Method m : methods) {
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            int score = methodApplicabilityScore_onTypes(m, argTypes);
            if (score < Integer.MAX_VALUE) {
              best.put(m, score);
            }
          }
        return best.get();
      }
      if (o == null)
        return null;
      _MethodCache cache = callOpt_getCache(o.getClass());
      List<Method> methods = cache.cache.get(method);
      Lowest<Method> best = new Lowest();
      if (methods != null)
        for (Method m : methods) {
          int score = methodApplicabilityScore_onTypes(m, argTypes);
          if (score < Integer.MAX_VALUE)
            best.put(m, score);
        }
      return best.get();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void dm_onTopInput(final VF1<String> r) {
    final DynModule m = dm_current_mandatory();
    dm_ownResource(vmBus_onMessage("topInput", new VF1<String>() {

      public void get(final String s) {
        try {
          m.enter();
          callF(r, s);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.enter();\r\n    callF(r, s)";
      }
    }));
  }

  static public void dm_onTopInput(final Runnable r) {
    final DynModule m = dm_current_mandatory();
    dm_ownResource(vmBus_onMessage("topInput", new VF1<String>() {

      public void get(final String s) {
        try {
          m.enter();
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.enter();\r\n    callF(r)";
      }
    }));
  }

  static public <A> A vm_generalMap_getOrCreate(Object key, F0<A> create) {
    return vm_generalMap_getOrCreate(key, f0ToIF0(create));
  }

  static public <A> A vm_generalMap_getOrCreate(Object key, IF0<A> create) {
    Map generalMap = vm_generalMap();
    if (generalMap == null)
      return null;
    synchronized (generalMap) {
      A a = (A) (vm_generalMap_get(key));
      if (a == null)
        vm_generalMap_put(key, a = create == null ? null : create.get());
      return a;
    }
  }

  static public Class loadClassFromClassLoader_orNull(ClassLoader cl, String name) {
    try {
      return cl == null ? null : cl.loadClass(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(BetterThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  static public boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  static public boolean instanceOf(Class c, Object o) {
    return instanceOf(o, c);
  }

  static public void callAction(Action a) {
    if (a != null)
      a.actionPerformed(null);
  }

  static public Set emptySet() {
    return new HashSet();
  }

  static public <A> TreeSet<A> asTreeSet(Collection<A> set) {
    return set == null ? null : set instanceof TreeSet ? (TreeSet) set : new TreeSet(set);
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public void internalFrameTitlePopupMenu(final JInternalFrame f, final Object... params) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Object menuMaker;
            if (l(params) == 1 && !(params[0] instanceof JMenu))
              menuMaker = params[0];
            else
              menuMaker = new VF1<JPopupMenu>() {

                public void get(JPopupMenu menu) {
                  try {
                    addMenuItems(menu, params);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "addMenuItems(menu, params)";
                }
              };
            Component titleComponent = getInternalFrameTitlePaneComponent(f);
            if (!(titleComponent instanceof JComponent))
              print("Can't add internal frame title popup menu!");
            else {
              componentPopupMenu((JComponent) titleComponent, menuMaker);
              setOpt(componentPopupMenu_initForComponent((JComponent) titleComponent), "internalFrameLeftButtonMagic", isTrue(vm_generalMap_get("internalFramePopupOnLeftButton")));
            }
            componentPopupMenu(f, menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object menuMaker;\r\n    if (l(params) == 1 && !(params[0] instanceof JMenu))\r\n...";
        }
      });
    }
  }

  static public JTextField jtextfield() {
    return jTextField();
  }

  static public JTextField jtextfield(String text) {
    return jTextField(text);
  }

  static public JTextField jtextfield(Object o) {
    return jTextField(o);
  }

  static public int showForm_defaultGap = 4;

  static public int showForm_gapBetweenColumns = 10;

  static public JPanel showFormTitled(final String title, final Object... _parts) {
    JDesktopPane desktop = mainDesktopPane();
    if (desktop != null)
      return showInternalFrameFormTitled(desktop, title, _parts);
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          final Var<JFrame> frame = new Var();
          JPanel panel = showForm_makePanel(false, _parts);
          frame.set(showForm_makeFrame(title, panel));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<JFrame> frame;\r\n    JPanel panel = showForm_makePanel(false, _p...";
      }
    });
  }

  static public JPanel showForm_makePanel(Boolean internalFrame, Object... _parts) {
    List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
    return vstackWithSpacing(out, showForm_defaultGap);
  }

  static public String stringOptPar(Object[] params, String name) {
    return (String) optPar(params, name);
  }

  static public String gtt(JTextComponent c) {
    return getTextTrim(c);
  }

  static public String gtt(JComboBox cb) {
    return getTextTrim(cb);
  }

  static public void dm_doubleFieldSetterDialog(String field, Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    final JTextField tf = jtextfield(get(m, field));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, parseDouble(gtt(tf)));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, parseDouble(gtt(tf)));\r\n      callF(optPar(__, \"onSet\"));";
      }
    });
  }

  static public void dm_floatFieldSetterDialog(String field, Object... __) {
    DynModule m = dm_current_mandatory();
    String humanized = humanizeFormLabel(field);
    JTextField tf = jtextfield(get(m, field));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, parseFloat(gtt(tf)));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, parseFloat(gtt(tf)));\r\n      callF(optPar(__, \"onSet\"));";
      }
    });
  }

  static public void dm_stringFieldDialog(final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    final JTextField tf = jtextfield(get(m, field));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, gtt(tf));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, gtt(tf));\r\n      callF(optPar(__, \"onSet\"));";
      }
    });
  }

  static public void dm_fileFieldDialog(final String field, final Object... __) {
    DynModule m = dm_current_mandatory();
    String humanized = humanizeFormLabel(field);
    JTextField tf = jtextfield(strOrNull(get(m, field)));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, toFile_nullOnEmpty(gtt(tf)));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, toFile_nullOnEmpty(gtt(tf)));\r\n      callF(optPar(__, \"onSe...";
      }
    });
  }

  static public Q dm_ownQ(Q q) {
    q.rst.enter = dm_rEnter(dm_current_mandatory());
    dm_ownResource(q);
    return q;
  }

  static public Q startQ() {
    return new Q();
  }

  static public Q startQ(String name) {
    return new Q(name);
  }

  static public <A extends JComponent> A setToolTip(A c, Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A setToolTip(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public void setToolTip(TrayIcon trayIcon, String toolTip) {
    setTrayIconToolTip(trayIcon, toolTip);
  }

  static public JLabel jimage(Image img) {
    return jImageLabel(img);
  }

  static public JLabel jimage(String imageID) {
    return jImageLabel(imageID);
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public JScrollPane setScrollPaneBackground(Color c, JScrollPane sp) {
    if (sp != null && c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            sp.getViewport().setBackground(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "sp.getViewport().setBackground(c);";
        }
      });
    }
    return sp;
  }

  static public Color getBackground(final Component c) {
    return c == null ? null : swing(new F0<Color>() {

      public Color get() {
        try {
          return c.getBackground();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getBackground();";
      }
    });
  }

  static public void clearStringBuffer_gen(Object buf) {
    if (buf != null) {
      call(buf, "setLength", 0);
      call(buf, "trimToSize");
    }
  }

  static public void swingEvery(JComponent component, long delay, Object r) {
    installTimer(component, delay, r);
  }

  static public void swingEvery(JComponent component, long delay, long firstDelay, Object r) {
    installTimer(component, r, delay, firstDelay);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, Object r) {
    installTimer(frame, delay, r);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    installTimer(frame, delay, firstDelay, r);
  }

  static public StringBuffer liveLocalPrintLog() {
    return local_log;
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public <A> List<A> listWithoutSet(Collection<A> l, Collection<A> stuff) {
    return listMinusSet(l, stuff);
  }

  static public Map<Class, List<String>> fieldsInOrder_cache = weakHashMap();

  static public List<String> fieldsInOrder(Object o) {
    return fieldsInOrder(_getClass(o));
  }

  static public List<String> fieldsInOrder(Class c) {
    if (c == null)
      return null;
    synchronized (fieldsInOrder_cache) {
      List<String> fields = fieldsInOrder_cache.get(c);
      if (fields != null)
        return fields;
      String order = toStringOpt(getOpt(c, "_fieldOrder"));
      Set<String> set = asTreeSet(allNonStaticFields(c));
      if (order == null)
        return asList(set);
      fields = splitAtSpace(order);
      setAddAll(fields, set);
      fieldsInOrder_cache.put(c, fields);
      return fields;
    }
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll((Map) b);
    return a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
    if (a != null)
      litmap_impl(a, b);
    return a;
  }

  static public JTable dataToTable(Object data) {
    return dataToTable(showTable(), data);
  }

  static public JTable dataToTable(Object data, String title) {
    return dataToTable(showTable(title), data);
  }

  static public JTable dataToTable(JTable table, Object data) {
    return dataToTable(table, data, false);
  }

  static public JTable dataToTable(JTable table, Object data, boolean now) {
    List<List> rows = new ArrayList();
    List<String> cols = new ArrayList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrTextForUser(key), structureOrTextForUser(value)));
      }
    } else if (data != null)
      print("Unknown data type: " + data);
    fillTableWithData(table, rows, cols);
    return table;
  }

  static public void makeTableUneditable(JTable table) {
    for (int c = 0; c < table.getColumnCount(); c++) {
      Class<?> col_class = table.getColumnClass(c);
      table.setDefaultEditor(col_class, null);
    }
  }

  static public boolean showTable_searcher = true;

  static public JTable showTable(Object data) {
    return dataToTable_uneditable(data);
  }

  static public JTable showTable(String title, Object data) {
    return showTable(data, title);
  }

  static public JTable showTable(Object data, String title) {
    return dataToTable_uneditable(data, title);
  }

  static public JTable showTable(JTable table, Object data) {
    return showTable(table, data, autoFrameTitle());
  }

  static public JTable showTable(Object data, JTable table) {
    return showTable(table, data);
  }

  static public JTable showTable(JTable table, Object data, String title) {
    if (table == null)
      table = showTable(data, title);
    else {
      setFrameTitle(table, title);
      dataToTable_uneditable(table, data);
    }
    return table;
  }

  static public JTable showTable() {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>());
  }

  static public JTable showTable(String title) {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>(), title);
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols) {
    return showTable(rows, cols, autoFrameTitle());
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols, String title) {
    JTable tbl = sexyTable();
    fillTableWithStrings(tbl, rows, cols);
    showFrame(title, tbl);
    return tbl;
  }

  static public void tableEnableTextDrag(final JTable table) {
    TransferHandler th = new TransferHandler() {

      @Override
      public int getSourceActions(JComponent c) {
        return COPY;
      }

      @Override
      public Transferable createTransferable(JComponent c) {
        Object o = selectedTableCell(table);
        return new StringSelection(str(o));
      }
    };
    tableEnableDrag(table, th);
  }

  static public boolean anyValueContainsIgnoreCase(Map map, String pat) {
    for (Object val : values(map)) if (val instanceof String && containsIgnoreCase((String) val, pat))
      return true;
    return false;
  }

  static public List<Map<String, Object>> rawTableData(JTable t) {
    int n = tableRows(t);
    List l = new ArrayList();
    for (int i = 0; i < n; i++) l.add(rawTableLineAsMap(t, i));
    return l;
  }

  static public JComponent withLabel(String label, JComponent component) {
    return westAndCenter(jlabel(label + " "), component);
  }

  static public JComponent withLabel(JComponent label, JComponent component) {
    return westAndCenterWithMargin(label, component);
  }

  static public boolean boolOptPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolOptPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public JScrollPane enclosingScrollPane(Component c) {
    while (c.getParent() != null && !(c.getParent() instanceof JViewport) && c.getParent().getComponentCount() == 1) c = c.getParent();
    if (!(c.getParent() instanceof JViewport))
      return null;
    c = c.getParent().getParent();
    return c instanceof JScrollPane ? (JScrollPane) c : null;
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public double fraction(double d) {
    return d % 1;
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public <A> Collection<A> asCollection(Iterable<A> l) {
    return l == null ? null : l instanceof Collection ? ((Collection) l) : asList(l);
  }

  static public int tableRows(JTable table) {
    return (int) swingCall(table, "getRowCount");
  }

  static public <A> List<A> listGetMulti(final List<A> l, List<Integer> indices) {
    return map(indices, new F1<Integer, A>() {

      public A get(Integer i) {
        try {
          return _get(l, i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_get(l, i)";
      }
    });
  }

  static public List<Integer> selectedTableRows(final JTable table) {
    return table == null ? null : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return asList(table.getSelectedRows());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret asList(table.getSelectedRows());";
      }
    });
  }

  static public void scrollRowToVisible(JTable t, int rowIndex) {
    int colIndex = 0;
    if (!(t.getParent() instanceof JViewport))
      return;
    JViewport viewport = (JViewport) t.getParent();
    Rectangle rect = t.getCellRect(rowIndex, colIndex, true);
    Rectangle viewRect = viewport.getViewRect();
    int x = viewRect.x;
    int y = viewRect.y;
    if (rect.x >= viewRect.x && rect.x <= (viewRect.x + viewRect.width - rect.width)) {
    } else if (rect.x < viewRect.x) {
      x = rect.x;
    } else if (rect.x > (viewRect.x + viewRect.width - rect.width)) {
      x = rect.x - viewRect.width + rect.width;
    }
    if (rect.y >= viewRect.y && rect.y <= (viewRect.y + viewRect.height - rect.height)) {
    } else if (rect.y < viewRect.y) {
      y = rect.y;
    } else if (rect.y > (viewRect.y + viewRect.height - rect.height)) {
      y = rect.y - viewRect.height + rect.height;
    }
    viewport.setViewPosition(new Point(x, y));
  }

  static public int listRowCount(JList list) {
    return list == null ? 0 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return list.getModel().getSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret list.getModel().getSize();";
      }
    });
  }

  static public <A> int jlist_indexOf(JList<A> list, A item) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          ListModel<A> model = list.getModel();
          int n = model.getSize();
          for (int i = 0; i < n; i++) if (eq(model.getElementAt(i), item))
            return i;
          return -1;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ListModel<A> model = list.getModel();\r\n    int n = model.getSize();\r\n    for ...";
      }
    });
  }

  static public void tablePopupMenuItem(JTable table, String name, Object action) {
    tablePopupMenu(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, row);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, row)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, row) });";
      }
    });
  }

  static public void tablePopupMenuItem(JTable table, String name, IVF1<Integer> action) {
    tablePopupMenuItem(table, name, (Object) action);
  }

  static public Object[] reverseParams(Object[] params) {
    int n = l(params);
    if (params == null || odd(n))
      return params;
    Object[] a = new Object[n];
    for (int i = 0; i + 1 < n; i += 2) arraycopy(params, i, a, n - i - 2, 2);
    return a;
  }

  static public void tablePopupMenuItem_top(final JTable table, final String name, final Object action) {
    tablePopupMenuFirst(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, row);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, row)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, row) });";
      }
    });
  }

  static public String spliceString(String a, int from, int to, String b) {
    return substring(a, 0, from) + b + substring(a, Math.max(from, to));
  }

  static public String spliceString(String a, int from, int to, char b) {
    return spliceString(a, from, to, str(b));
  }

  static public long saveGZStructureToFile(String file, Object o) {
    return saveGZStructureToFile(getProgramFile(file), o);
  }

  static public long saveGZStructureToFile(File file, Object o) {
    return saveGZStructureToFile(file, o, new structure_Data());
  }

  static public long saveGZStructureToFile(File file, Object o, structure_Data data) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      File tempFile = tempFileFor(file);
      if (tempFile.exists())
        try {
          String saveName = tempFile.getPath() + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      CountingOutputStream cos;
      try {
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        cos = new CountingOutputStream(gos);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(cos, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        structureToPrintWriter(o, printWriter, data);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      } catch (Throwable e) {
        fileOutputStream.close();
        tempFile.delete();
        throw rethrow(e);
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
      return cos.getFilePointer();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  static public class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  static public CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  static public void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public void internalFrameTitlePopupMenuItem(JInternalFrame f, final String name, final Object action) {
    internalFrameTitlePopupMenu(f, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, name, action);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, action)";
      }
    });
  }

  static public void listPopupMenuItem(final JList list, final String name, final Object action) {
    listPopupMenu(list, new VF2<JPopupMenu, String>() {

      public void get(JPopupMenu menu, final String item) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, item);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, item)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, item) });";
      }
    });
  }

  static public String copyTextToClipboardIfNotNull(String text) {
    if (text != null)
      copyTextToClipboard(text);
    return text;
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public <A, B> B syncMapGet2(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (collectionMutex(map)) {
      return map.get(a);
    }
  }

  static public <A, B> B syncMapGet2(A a, Map<A, B> map) {
    return syncMapGet2(map, a);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public Map<String, Integer> tableColumnWidthsByName(JTable table) {
    TableColumnModel tcm = table.getColumnModel();
    if (tcm == null)
      return null;
    int n = tcm.getColumnCount();
    TreeMap<String, Integer> map = new TreeMap();
    for (int i = 0; i < n; i++) {
      TableColumn tc = tcm.getColumn(i);
      map.put(str(tc.getHeaderValue()), tc.getWidth());
    }
    return map;
  }

  static public int tableColumnCount(JTable table) {
    return tableNumColumns(table);
  }

  static public boolean tableSetColumnPreferredWidths_debug = false;

  static public void tableSetColumnPreferredWidths(final JTable table, final Map<String, Integer> widths) {
    if (table == null || widths == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            try {
              TableColumnModel tcm = table.getColumnModel();
              int n = tcm.getColumnCount();
              for (int i = 0; i < n; i++) {
                TableColumn tc = tcm.getColumn(i);
                Integer w = widths.get(str(tc.getHeaderValue()));
                if (w != null) {
                  tc.setPreferredWidth(w);
                  if (tableSetColumnPreferredWidths_debug)
                    print("Setting preferred width of column " + i + " to " + w);
                }
              }
            } catch (Throwable __e) {
              printStackTrace(__e);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "pcall {\r\n    TableColumnModel tcm = table.getColumnModel();\r\n    int n = tcm....";
        }
      });
    }
  }

  static public void tableSetColumnPreferredWidths(JTable table, Object... widths) {
    tableSetColumnPreferredWidths(table, litorderedmap(widths));
  }

  static public void newPing() {
    var tl = newPing_actionTL();
    Runnable action = tl == null ? null : tl.get();
    {
      if (action != null)
        action.run();
    }
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public File loadBinarySnippet(String snippetID) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadLibrary(snippetID);
    return loadBinarySnippet_noResourceLoader(snippetID);
  }

  static public File loadBinarySnippet_noResourceLoader(String snippetID) {
    try {
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile_noResourceLoader(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
    List<A> l = tl.get();
    if (l == null)
      tl.set(l = new ArrayList());
    l.add(a);
  }

  static public <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
    List<A> l = tl.get();
    if (l == null)
      return null;
    A a = popLast(l);
    if (empty(l))
      tl.set(null);
    return a;
  }

  static public <A, B> Pair<A, B> mapEntryToPair(Map.Entry<A, B> e) {
    return e == null ? null : pair(e.getKey(), e.getValue());
  }

  static public <A, B> Set<Map.Entry<A, B>> entrySet(Map<A, B> map) {
    return _entrySet(map);
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, A[] l) {
    return firstThat(l, pred);
  }

  static public <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  static public boolean isTrueOrYes(Object o) {
    return isTrueOpt(o) || o instanceof String && (eqicOneOf(((String) o), "1", "t", "true") || isYes(((String) o)));
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    dynamicObject_setRawFieldValue(o, field, value);
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public DialogIO talkToSubBot(final long vport, final DialogIO io) {
    return talkToSubBot(String.valueOf(vport), io);
  }

  static public DialogIO talkToSubBot(final String subBot, final DialogIO io) {
    if (subBot == null)
      return io;
    return new talkToSubBot_IO(subBot, io);
  }

  static public class talkToSubBot_IO extends DialogIO {

    public String subBot;

    public DialogIO io;

    public talkToSubBot_IO(String subBot, DialogIO io) {
      this.io = io;
      this.subBot = subBot;
    }

    public boolean isStillConnected() {
      return io.isStillConnected();
    }

    public String readLineImpl() {
      return io.readLineImpl();
    }

    public boolean isLocalConnection() {
      return io.isLocalConnection();
    }

    public Socket getSocket() {
      return io.getSocket();
    }

    public void close() {
      try {
        io.close();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void sendLine(String line) {
      io.sendLine(format3("please forward to bot *: *", subBot, line));
    }
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String[] a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(String[] a, String b, int i) {
    int n = a == null ? 0 : a.length;
    for (; i < n; i++) if (eqic(a[i], b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public List<ProgramScan.Program> quickBotScan() {
    return ProgramScan.quickBotScan();
  }

  static public List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
    return ProgramScan.quickBotScan(preferredPorts);
  }

  static public List<ProgramScan.Program> quickBotScan(String searchPattern) {
    List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
    for (ProgramScan.Program p : ProgramScan.quickBotScan()) if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
    return l;
  }

  static public String firstPartOfHelloString(String s) {
    int i = s.lastIndexOf('/');
    return i < 0 ? s : rtrim(s.substring(0, i));
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public Object unstructure(String text, IF1<String, Class> classFinder) {
    return unstructure(text, false, classFinder);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public String mcDollar = actualMCDollar();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public Map<String, String> baseClassMap = new HashMap();

      public HashMap<Class, Constructor> innerClassConstructors = new HashMap();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public X() {
        try {
          Class mc = (Class) (callF(_classFinder, "<main>"));
          if (mc != null)
            mcDollar = mc.getName() + "$";
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }

      public Class findAClass(String fullClassName) {
        try {
          return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
        } catch (Throwable __e) {
          return null;
        }
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        } else
          refID = -1;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (refID >= 0)
              refs.put(refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, unstructure_Receiver out) {
        String t = t();
        String cname = t;
        Class c = classesMap.get(cname);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              warn("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              warn("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            LinkedList l = new LinkedList();
            if (refID >= 0)
              refs.put(refID, l);
            {
              parseList(l, out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(synchroNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(synchroSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(synchroMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(synchroList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            ArrayList l = new ArrayList();
            if (refID >= 0)
              refs.put(refID, l);
            this.parseList(l, out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray") || t.equals("dblarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = mcDollar + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume();
          out.set(parseJava());
          return;
        }
        if (eq(t, "bc")) {
          consume();
          String c1 = tpp();
          String c2 = tpp();
          baseClassMap.put(c1, c2);
          {
            parse_inner(refID, i, out);
            return;
          }
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = mcDollar + t;
        }
        if (c == null && !allDynamic) {
          c = findAClass(fullClassName);
          classesMap.put(className, c);
        }
        if (c == null && !allDynamic) {
          Set<String> seen = new HashSet();
          String parent = className;
          while (true) {
            String baseName = baseClassMap.get(parent);
            if (baseName == null)
              break;
            if (!seen.add(baseName))
              throw fail("Cyclic superclass info: " + baseName);
            c = findAClass(mcDollar + baseName);
            if (c == null)
              print("Base class " + baseName + " of " + parent + " doesn't exist either");
            else if (isAbstract(c))
              print("Can't instantiate abstract base class: " + c);
            else {
              printVars_str("Reverting to base class", "className", className, "baseName", baseName, "c", c);
              classesMap.put(className, c);
              break;
            }
            parent = baseName;
          }
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && startsWith(t(), "this$");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          if (hasOuter)
            try {
              Constructor ctor = innerClassConstructors.get(c);
              if (ctor == null)
                innerClassConstructors.put(c, ctor = nuStubInnerObject_findConstructor(c, classFinder));
              o = ctor.newInstance(new Object[] { null });
            } catch (Exception e) {
              print("Error deserializing " + c + ": " + e);
              o = nuEmptyObject(c);
            }
          else
            o = nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findAClass(mcDollar + "Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID >= 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        HashMap<String, Object> fields = new HashMap();
        Object _o = o;
        DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        Object outer = fields.get("this$0");
        if (outer != null)
          fields.put("this$1", outer);
        else {
          outer = fields.get("this$1");
          if (outer != null)
            fields.put("this$0", outer);
        }
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(unstructure_Receiver out) {
        String _type = tpp();
        int dims;
        if (eq(t(), "S")) {
          _type = "S";
          consume();
        }
        if (eq(t(), "/")) {
          consume();
          dims = parseInt(tpp());
        } else
          dims = 1;
        consume("{");
        List list = new ArrayList();
        String type = _type;
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                if (dims > 1) {
                  Class atype;
                  if (type.equals("intarray"))
                    atype = int.class;
                  else if (type.equals("S"))
                    atype = String.class;
                  else
                    throw todo("multi-dimensional arrays of other types");
                  out.set(list.toArray((Object[]) newMultiDimensionalOuterArray(atype, dims, l(list))));
                } else
                  out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : type.equals("S") ? toStringArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          if (dims > 1) {\r\n    ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix(mcDollar, name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public String actualMCDollar() {
    return actualMC().getName() + "$";
  }

  static public boolean isSyntheticOrAnonymous(Class c) {
    return c != null && (c.isSynthetic() || isAnonymousClassName(c.getName()));
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public String shortDynClassNameForStructure(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return name.startsWith("dyn.") ? classNameToVM(name) : shortenClassName(name);
  }

  static public int countDots(String s) {
    int n = l(s), count = 0;
    for (int i = 0; i < n; i++) if (s.charAt(i) == '.')
      ++count;
    return count;
  }

  static public void quoteToPrintWriter(String s, PrintWriter out) {
    if (s == null) {
      out.print("null");
      return;
    }
    out.print('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"') {
        out.print('\\');
        out.print(c);
      } else if (c == '\r')
        out.print("\\r");
      else if (c == '\n')
        out.print("\\n");
      else if (c == '\0')
        out.print("\\0");
      else
        out.print(c);
    }
    out.print('"');
  }

  static public String quoteCharacter(char c) {
    if (c == '\'')
      return "'\\''";
    if (c == '\\')
      return "'\\\\'";
    if (c == '\r')
      return "'\\r'";
    if (c == '\n')
      return "'\\n'";
    if (c == '\t')
      return "'\\t'";
    return "'" + c + "'";
  }

  static public boolean isCISet_gen(Iterable<String> l) {
    return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
  }

  static public boolean isJavaXClassName(String s) {
    return startsWithOneOf(s, "main$", "loadableUtils.");
  }

  static public <A> List<A> unwrapSynchronizedList(List<A> l) {
    if (eqOneOf(className(l), "java.util.Collections$SynchronizedList", "java.util.Collections$SynchronizedRandomAccessList"))
      return (List) get_raw(l, "list");
    return l;
  }

  static public boolean isCIMap_gen(Map map) {
    return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
  }

  static public <A, B> Map<A, B> unwrapSynchronizedMap(Map<A, B> map) {
    if (eqOneOf(shortClassName(map), "SynchronizedMap", "SynchronizedSortedMap", "SynchronizedNavigableMap"))
      return (Map) get_raw(map, "m");
    return map;
  }

  static public String boolArrayToHex(boolean[] a) {
    return bytesToHex(boolArrayToBytes(a));
  }

  static public Pair<Class, Integer> arrayTypeAndDimensions(Object o) {
    return arrayTypeAndDimensions(_getClass(o));
  }

  static public Pair<Class, Integer> arrayTypeAndDimensions(Class c) {
    if (c == null || !c.isArray())
      return null;
    Class elem = c.getComponentType();
    if (elem.isArray())
      return mapPairB(arrayTypeAndDimensions(elem), dim -> dim + 1);
    return pair(elem, 1);
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

  static public Field[] getDeclaredFields_cached(Class c) {
    Field[] fields;
    synchronized (getDeclaredFields_cache) {
      fields = getDeclaredFields_cache.get(c);
      if (fields == null) {
        getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
        for (Field f : fields) makeAccessible(f);
      }
    }
    return fields;
  }

  static public Set<Field> fieldObjectsInFieldOrder(Class c, Set<Field> fields) {
    try {
      var byName = mapToKey(f -> f.getName(), fields);
      LinkedHashSet<Field> out = new LinkedHashSet();
      for (String name : unnullForIteration(getFieldOrder(c))) {
        Field f = byName.get(name);
        if (f != null) {
          byName.remove(name);
          out.add(f);
        }
      }
      addAll(out, fields);
      return out;
    } catch (Throwable __0) {
      printStackTrace(__0);
      return fields;
    }
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  static public void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  static public String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  static volatile public Android3 dbBot_instance;

  static public Android3 dbBot() {
    return dbBot(true);
  }

  static public Android3 dbBot(boolean ensureNotRunning) {
    return dbBot(dbBotStandardName(), ensureNotRunning);
  }

  static public Android3 dbBot(String name) {
    return dbBot(name, true);
  }

  static public Android3 dbBot(String name, boolean ensureNotRunning) {
    if (ensureNotRunning)
      ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  static public void thinAProgramsBackups(String progID, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)(\\d*)$");
    File dir = programDir(progID);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      java.util.regex.Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      int minute = matcherInt(matcher, 6);
      long time = timestampFromYMDHM(year, month, day, hour, minute);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  static public boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public Object deref(Object o) {
    if (o instanceof IRef)
      return ((IRef) o).get();
    return o;
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public void dynamicObject_setRawFieldValue(DynamicObject o, Object key, Object value) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = syncMapPut2_createLinkedHashMap((LinkedHashMap) o.fieldValues, key, value);
    }
  }

  static public boolean isConceptList(Object o) {
    if (!(o instanceof List))
      return false;
    List l = (List) o;
    for (Object x : l) if (!(x instanceof Concept))
      return false;
    return true;
  }

  static public void dynamicObject_dropRawField(DynamicObject o, Object key) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = (LinkedHashMap) syncMapRemove_deleteMapIfEmpty((Map) o.fieldValues, key);
    }
  }

  static public boolean isPersistable(Object o) {
    return !isInAnonymousClass(o);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
    return lambdaMap(f, l);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
    return lambdaMap(f, l);
  }

  static public boolean isTransient(Field f) {
    return (f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) != 0;
  }

  static public <A> List<A> immutableEmptyList() {
    return Collections.emptyList();
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public short[] emptyShortArray = new short[0];

  static public short[] emptyShortArray() {
    return emptyShortArray;
  }

  static public <A, B> Map<A, B> immutableEmptyMap() {
    return Collections.emptyMap();
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public Symbol emptySymbol_value;

  static public Symbol emptySymbol() {
    if (emptySymbol_value == null)
      emptySymbol_value = symbol("");
    return emptySymbol_value;
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  static public List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  static synchronized public List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public ClassLoader classLoaderForObject(Object o) {
    if (o instanceof ClassLoader)
      return ((ClassLoader) o);
    if (o == null)
      return null;
    return _getClass(o).getClassLoader();
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static volatile public Object isAllowed_function;

  static volatile public boolean isAllowed_all = true;

  static public boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public String round(String s) {
    return roundBracket(s);
  }

  static public Complex round(Complex c) {
    return new Complex(round(c.re), round(c.im));
  }

  static public String hmsWithColons() {
    return hmsWithColons(now());
  }

  static public String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  static public boolean isLocalhost(String ip) {
    return isLoopbackIP(ip) || eqic(ip, "localhost");
  }

  static public int vmPort() {
    return myVMPort();
  }

  static public DialogIO talkToThisVM() {
    return new talkToThisVM_IO();
  }

  static public class talkToThisVM_IO extends DialogIO {

    public List<String> answers = ll(thisVMGreeting());

    public boolean isLocalConnection() {
      return true;
    }

    public boolean isStillConnected() {
      return true;
    }

    public int getPort() {
      return vmPort();
    }

    public void sendLine(String line) {
      answers.add(or2(sendToThisVM_newThread(line), "?"));
    }

    public String readLineImpl() {
      try {
        return popFirst(answers);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
    }

    public Socket getSocket() {
      return null;
    }
  }

  static public TableWithTooltips tableWithTooltips() {
    return (TableWithTooltips) swing(new F0<Object>() {

      public Object get() {
        try {
          return new TableWithTooltips();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new TableWithTooltips;";
      }
    });
  }

  static public class TableWithTooltips extends JTable {

    public String getToolTipText(MouseEvent e) {
      String tip = null;
      Point p = e.getPoint();
      int rowIndex = rowAtPoint(p);
      int colIndex = columnAtPoint(p);
      try {
        return str(getValueAt(rowIndex, colIndex));
      } catch (Throwable _e) {
        return null;
      }
    }
  }

  static public JTextField standardTextFieldPopupMenu(final JTextField tf) {
    final WeakReference<JTextField> ref = weakRef(tf);
    componentPopupMenuItem(tf, "Copy text to clipboard", new Runnable() {

      public void run() {
        try {
          copyTextToClipboard(ref.get().getText());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "copyTextToClipboard(ref.get().getText())";
      }
    });
    componentPopupMenuItem(tf, "Paste", new Runnable() {

      public void run() {
        try {
          ref.get().paste();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ref.get().paste()";
      }
    });
    return tf;
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public Class primitiveToBoxedTypeOpt(Class type) {
    return or(primitiveToBoxedType(type), type);
  }

  static public Object getTL(Object o, String name) {
    return getThreadLocal(o, name);
  }

  static public <A> A getTL(ThreadLocal<A> tl) {
    return getThreadLocal(tl);
  }

  static public <A> A getTL(ThreadLocal<A> tl, A defaultValue) {
    return getThreadLocal(tl, defaultValue);
  }

  static public ThreadLocal<Boolean> DynamicObject_loading = or((ThreadLocal) get(getClass("x30_pkg.x30_util"), "DynamicObject_loading"), new ThreadLocal());

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble((String) o);
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public Object dm_getService(String serviceName) {
    return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
  }

  static public boolean isStringOrIntOrLong(Object o) {
    return o instanceof String || o instanceof Integer || o instanceof Long;
  }

  static public Object dm_getStemByID(Object id) {
    return dm_callOS("getModuleByID", str(id));
  }

  static public Object dm_getModule(Object moduleOrID) {
    if (moduleOrID == null || eq(moduleOrID, ""))
      return null;
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      return dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_callOS("getDynModuleByID", str(moduleOrID));
    return dm_resolveModule(moduleOrID);
  }

  static public <A> A println(A a) {
    return print(a);
  }

  static public int lCharSequence(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int lastIndexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    for (int i = l(l) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A extends JComponent> A jtransparent(final A a) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            a.setOpaque(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setOpaque(false);";
        }
      });
    }
    return a;
  }

  static public JPanel borderLayoutPanel() {
    return jpanel(new BorderLayout());
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public Thread newThread(Object runnable) {
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public boolean loadBufferedImageFixingGIFs_debug = false;

  static public ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

  static public Image loadBufferedImageFixingGIFs(File file) {
    try {
      if (!file.exists())
        return null;
      if (!isGIF(file))
        return ImageIO.read(file);
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": checking gif");
      ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
      reader.setInput(ImageIO.createImageInputStream(file));
      int numImages = reader.getNumImages(true);
      IIOMetadata imageMetaData = reader.getImageMetadata(0);
      String metaFormatName = imageMetaData.getNativeMetadataFormatName();
      boolean foundBug = false;
      for (int i = 0; i < numImages && !foundBug; i++) {
        IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
        int nNodes = root.getLength();
        for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
            String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
            if (Integer.parseInt(delay) == 0) {
              foundBug = true;
            }
            break;
          }
        }
      }
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
      Image image;
      if (!foundBug) {
        image = Toolkit.getDefaultToolkit().createImage(f2s(file));
      } else {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        {
          ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
          try {
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; i++) {
              BufferedImage frameIn = reader.read(i);
              IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
              int nNodes = root.getLength();
              for (int j = 0; j < nNodes; j++) {
                org.w3c.dom.Node node = root.item(j);
                if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
                  if (Integer.parseInt(delay) == 0) {
                    ((IIOMetadataNode) node).setAttribute("delayTime", "10");
                  }
                  break;
                }
              }
              IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
              metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
              IIOImage frameOut = new IIOImage(frameIn, null, metadata);
              writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
          } finally {
            _close(ios);
          }
        }
        byte[] data = baoStream.toByteArray();
        setVar(loadBufferedImageFixingGIFs_output.get(), data);
        if (loadBufferedImageFixingGIFs_debug)
          print("Data size: " + l(data));
        image = Toolkit.getDefaultToolkit().createImage(data);
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object rcall(String method, Object o, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public boolean even(BigInteger n) {
    return even(n.intValue());
  }

  static public <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public Object swingCall(final Object o, final String method, final Object... args) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return call(o, method, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret call(o, method, args);";
      }
    });
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public <A> A oneOf(List<A> l) {
    return empty(l) ? null : l.get(new Random().nextInt(l.size()));
  }

  static public char oneOf(String s) {
    return empty(s) ? '?' : s.charAt(random(l(s)));
  }

  static public String oneOf(String... l) {
    return oneOf(asList(l));
  }

  static public <A> A collectionGet(Collection<A> c, int idx) {
    if (c == null || idx < 0 || idx >= l(c))
      return null;
    if (c instanceof List)
      return listGet((List<A>) c, idx);
    Iterator<A> it = c.iterator();
    for (int i = 0; i < idx; i++) if (it.hasNext())
      it.next();
    else
      return null;
    return it.hasNext() ? it.next() : null;
  }

  static public <A, B> Pair<A, B> entryToPair(Map.Entry<A, B> e) {
    return mapEntryToPair(e);
  }

  static public <A, B> Set<Map.Entry<A, B>> entries(Map<A, B> map) {
    return _entrySet(map);
  }

  static public void _onJavaXSet() {
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public Map<Object, Object> castMapToMapO(Map map) {
    return map;
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public BufferedImage imageIO_readURL(String url) {
    try {
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isAbsolutePath(String s) {
    return s != null && new File(s).isAbsolute();
  }

  static public boolean isAbsolutePath(File f) {
    return f != null && f.isAbsolute();
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public BufferedImage loadBufferedImageFile(File file) {
    try {
      return isFile(file) ? ImageIO.read(file) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    return linesFromFile(f, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f, IResourceHolder resourceHolder) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)), resourceHolder);
      return linesFromReader(utf8bufferedReader(f), resourceHolder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(path, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(String path, IResourceHolder resourceHolder) {
    return linesFromFile(newFile(path), resourceHolder);
  }

  static public <A extends Component> A jPreferWidth(int w, A c) {
    Dimension size = c.getPreferredSize();
    c.setPreferredSize(new Dimension(w, size.height));
    return c;
  }

  static public double sin(double x) {
    return Math.sin(x);
  }

  static public double pi() {
    return Math.PI;
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public byte[] loadBinaryFilePart(File file, long start, long end) {
    try {
      RandomAccessFile raf = new RandomAccessFile(file, "r");
      int n = toInt(min(raf.length(), end - start));
      byte[] buffer = new byte[n];
      try {
        raf.seek(start);
        raf.readFully(buffer, 0, n);
        return buffer;
      } finally {
        raf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JMenuItem jMenuItem(final String text) {
    return jmenuItem(text);
  }

  static public JMenuItem jMenuItem(String text, Object r) {
    return jmenuItem(text, r);
  }

  static public Pair<String, Integer> jmenu_autoMnemonic(String s) {
    int i = indexOf(s, '&');
    if (i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i + 1)))
      return pair(substring(s, 0, i) + substring(s, i + 1), (int) s.charAt(i + 1));
    return pair(s, 0);
  }

  static public JMenuItem disableMenuItem(final JMenuItem mi) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setEnabled(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setEnabled(false);";
        }
      });
    }
    return mi;
  }

  static public ActionListener actionListenerInNewThread(final Object runnable) {
    return actionListenerInNewThread(runnable, null);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          startThread("Action Listener", new Runnable() {

            public void run() {
              try {
                AutoCloseable __1 = holdInstance(instanceToHold);
                try {
                  callF(runnable);
                } finally {
                  _close(__1);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1 = holdInstance(instanceToHold); try {\r\n      callF(runnable...";
            }
          });
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public int latestInstalledJavaX() {
    File[] files = new File(userHome(), ".javax").listFiles();
    int v = 0;
    if (files != null)
      for (File f : files) {
        Matcher m = regexpMatcher("x(\\d\\d\\d?)\\.jar", f.getName());
        if (m.matches())
          v = Math.max(v, Integer.parseInt(m.group(1)));
      }
    return v;
  }

  static public String x30JarServerURL() {
    return "http://botcompany.de:8081/x30.jar";
  }

  static public Graphics2D antiAliasGraphics(BufferedImage img) {
    return antiAliasOn(createGraphics(img));
  }

  static public Map<BufferedImage, Object> createGraphics_modulators = synchroIdentityHashMap();

  static public Graphics2D createGraphics(BufferedImage img) {
    Graphics2D g = img.createGraphics();
    Object mod = createGraphics_modulators.get(img);
    if (mod != null)
      callF(mod, g);
    return g;
  }

  static public void createGraphics_modulate(BufferedImage img, Object mod) {
    mapPut2(createGraphics_modulators, img, mod);
  }

  static public BufferedImage drawImageOnImage(Image img, BufferedImage canvas, int x, int y) {
    createGraphics(canvas).drawImage(img, x, y, null);
    return canvas;
  }

  static public String joinStrings(String sep, Object... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Iterable strings) {
    StringBuilder buf = new StringBuilder();
    for (Object o : unnull(strings)) {
      String s = strOrNull(o);
      if (nempty(s)) {
        if (nempty(buf))
          buf.append(sep);
        buf.append(s);
      }
    }
    return str(buf);
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    if (r == null)
      return null;
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public void moveFile(File a, File b) {
    if (!renameFile(a, b))
      throw fail("File move failed: " + a + " to " + b);
  }

  static public void logMechListAppendLocally(String listName, String text) {
    if (empty(text))
      return;
    logStructureWithDate(mechListAppendLogFile(listName), litorderedmap("list", listName, "text", text));
    appendToFile(createLocalMechListFile(listName), assureTrailingNewLine(text));
  }

  static public String jextract(String pat, String s) {
    return jextract(pat, javaTok(s));
  }

  static public String jextract(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    jfind_preprocess(tokpat);
    int i = jfind(tok, tokpat);
    if (i < 0)
      return null;
    int j = i + l(tokpat) - 2;
    return joinSubList(tok, i, j);
  }

  static public String firstIntegerString(Iterable<String> c) {
    Iterator<String> it = c.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (isInteger(s))
        return s;
    }
    return null;
  }

  static public File saveProgramTextFile(String name, String contents) {
    return saveTextFile(getProgramFile(name), contents);
  }

  static public File saveProgramTextFile(String progID, String name, String contents) {
    return saveTextFile(getProgramFile(progID, name), contents);
  }

  static public List<String> platformParseArgs(String s) {
    List<String> out = new ArrayList();
    List<String> tok = javaTok(trim(s));
    for (int i = 1; i < l(tok); i += 2) {
      if (isQuoted(tok.get(i))) {
        out.add(tok.get(i));
        continue;
      }
      int j = i;
      while (j + 2 < l(tok) && empty(tok.get(j + 1))) j += 2;
      out.add(joinSubList(tok, i, j + 1));
      i = j;
    }
    return out;
  }

  static public String _javaCommand() {
    String __1 = trim(loadTextFile(javaxDataDir("java-command.txt")));
    if (!empty(__1))
      return __1;
    String javaHome = System.getProperty("java.home");
    if (nempty(javaHome)) {
      File f = new File(javaHome);
      f = oneOfTheFiles(newFile(f, "bin", "java"), newFile(f, "bin", "java.exe"));
      if (f != null)
        return platformQuote(f);
    }
    if (isOnPATH("java"))
      return "java";
    throw fail("No java command found");
  }

  static public JMenuItem directJMenuItem(Action a) {
    return new JMenuItem(a) {

      public Dimension getMaximumSize() {
        return new Dimension(super.getPreferredSize().width, super.getMaximumSize().height);
      }
    };
  }

  static public JMenuItem directJMenuItem(String text, Object action) {
    return directJMenuItem(abstractAction(text, action));
  }

  static public JMenuBar addMenuBar(final Component c) {
    return swing(new F0<JMenuBar>() {

      public JMenuBar get() {
        try {
          RootPaneContainer f = getPossiblyInternalFrame(c);
          if (f == null)
            return null;
          JMenuBar bar = (JMenuBar) (call(f, "getJMenuBar"));
          if (bar == null) {
            setMenuBar(f, bar = new JMenuBar());
            revalidate((Component) f);
          }
          return bar;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "RootPaneContainer f = getPossiblyInternalFrame(c);\r\n    if (f == null) null;\r...";
      }
    });
  }

  static public String getFrameTitle(Component c) {
    JFrame f = getFrame(c);
    return f == null ? null : f.getTitle();
  }

  static public Object pcallF_minimalExceptionHandling(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
      _storeException(e);
    }
    return null;
  }

  static public void closeAutoCloseables(Collection<AutoCloseable> l) {
    if (l != null)
      for (AutoCloseable c : l) {
        try {
          c.close();
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public <A> A nuInstance(Class<A> c) {
    return nuEmptyObject(c);
  }

  static public <A> A copyFields(Object x, A y, String... fields) {
    if (empty(fields)) {
      Map<String, Object> map = objectToMap(x);
      for (String field : map.keySet()) setOpt(y, field, map.get(field));
    } else
      for (String field : fields) {
        Object o = getOpt(x, field);
        if (o != null)
          setOpt(y, field, o);
      }
    return y;
  }

  static public <A> A copyFields(Object x, A y, Collection<String> fields) {
    return copyFields(x, y, asStringArray(fields));
  }

  static public int methodApplicabilityScore_onTypes(Method m, Class[] argTypes) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != argTypes.length)
      return Integer.MAX_VALUE;
    int score = 0;
    for (int i = 0; i < types.length; i++) {
      Class a = argTypes[i];
      Class c = types[i];
      if (c == a) {
      } else if (isSubclassOf(a, c))
        ++score;
      else
        return Integer.MAX_VALUE;
    }
    return score;
  }

  static public <A> AutoCloseable vmBus_onMessage(String msg, IVF1<A> onMessage) {
    return vmBus_onMessage(msg, ivf1ToVF1(onMessage));
  }

  static public <A> AutoCloseable vmBus_onMessage(final String msg, final VF1<A> onMessage) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, new VF2<String, Object>() {

        public void get(String _msg, Object arg) {
          try {
            callF(onMessage, arg);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(onMessage, arg)";
        }
      });
    }
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final IVF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public AutoCloseable vmBus_onMessage(String msg, Runnable onMessage) {
    return vmBus_onMessage(msg, runnableToVF1(onMessage));
  }

  static public <A> IF0<A> f0ToIF0(F0<A> f) {
    return f == null ? null : () -> f.get();
  }

  static public void addMenuItems(JMenu m, Object... x) {
    fillJMenu(m, x);
  }

  static public void addMenuItems(JPopupMenu m, Object... x) {
    fillJPopupMenu(m, x);
  }

  static public JPanel showInternalFrameFormTitled(final JDesktopPane desktop, final String title, final Object... _parts) {
    JPanel panel = showForm_makePanel(true, _parts);
    showForm_makeInternalFrame(desktop, title, panel);
    return panel;
  }

  static public JFrame showForm_makeFrame(String title, JPanel panel) {
    return handleEscapeKey(minFrameWidth(showPackedFrame(title, withMargin(panel)), 400));
  }

  static public List<JComponent> showForm_arrange1(List<List<JComponent>> l) {
    int minW = showForm_leftWidth(l);
    List<JComponent> out = new ArrayList();
    for (List<JComponent> row : l) out.add(westAndCenter(withRightMargin(showForm_gapBetweenColumns, jMinWidthAtLeast(minW, first(row))), second(row)));
    return out;
  }

  static public List<List<JComponent>> showForm_makeComponents(final Boolean internalFrame, Object... _parts) {
    List<List<JComponent>> l = new ArrayList();
    List parts = asList(_parts);
    JButton submitButton = null;
    for (int i = 0; i < l(parts); i++) {
      final Object o = parts.get(i), next = get(parts, i + 1);
      if (o instanceof String && next instanceof Component)
        setComponentID((Component) next, (String) o);
      if (o instanceof Component || o instanceof String || next instanceof Component) {
        l.add(mapLL(__84 -> wrapForSmartAdd_jComponent(__84), o == null ? new JPanel() : o instanceof String ? humanizeFormLabel((String) o) : o, next));
        if (next instanceof JButton && submitButton == null)
          submitButton = (JButton) next;
        i++;
      } else if (isRunnable(o))
        l.add(mapLL(__85 -> wrapForSmartAdd_jComponent(__85), null, submitButton = jbutton(showFormSubmitButtonName(), new Runnable() {

          public void run() {
            try {
              Object result = call(o);
              print("Result of form runnable: " + result + ". Button:  " + heldInstance(JButton.class));
              if (neq(Boolean.FALSE, result)) {
                if (isTrue(internalFrame))
                  disposeInternalFrame(heldInstance(JButton.class));
                else if (isFalse(internalFrame))
                  disposeFrame(heldInstance(JButton.class));
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "Object result = call(o);\r\n        print(\"Result of form runnable: \" + result ...";
          }
        })));
      else
        print("showForm: Unknown element type: " + getClassName(o));
    }
    if (submitButton != null) {
      final JButton _submitButton = submitButton;
      onEnterInAllTextFields(concatLists(l), new Runnable() {

        public void run() {
          try {
            clickButton(_submitButton);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "clickButton(_submitButton)";
        }
      });
    }
    for (List<JComponent> row : l) {
      JComponent left = first(row);
      if (left instanceof JLabel)
        makeBold((JLabel) left).setVerticalAlignment(JLabel.TOP);
    }
    return l;
  }

  static public int vstackWithSpacing_default = 10;

  static public JPanel vstackWithSpacing(final List parts) {
    return vstackWithSpacing(parts, vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(final List parts, final int spacing) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          GridBagConstraints gbc = new GridBagConstraints();
          gbc.weightx = 1;
          gbc.fill = GridBagConstraints.HORIZONTAL;
          gbc.gridwidth = GridBagConstraints.REMAINDER;
          gbc.insets = new Insets(spacing / 2, 0, spacing / 2, 0);
          smartAddWithLayout(panel, gbc, toObjectArray(nonNulls(parts)));
          gbc.weighty = 1;
          gbc.insets = new Insets(0, 0, 0, 0);
          panel.add(jrigid(), gbc);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    new GridBagConstraints gbc...";
      }
    });
  }

  static public JPanel vstackWithSpacing(Component... parts) {
    return vstackWithSpacing(asList(parts), vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(int spacing, Component... parts) {
    return vstackWithSpacing(asList(parts), spacing);
  }

  static public String getTextTrim(JTextComponent c) {
    return trim(getText(c));
  }

  static public String getTextTrim(JComboBox cb) {
    return trim(getText(cb));
  }

  static public String getTextTrim(JComponent c) {
    if (c instanceof JLabel)
      return trim(((JLabel) c).getText());
    if (c instanceof JComboBox)
      return getTextTrim((JComboBox) c);
    return getTextTrim((JTextComponent) c);
  }

  static public double parseDouble(String s) {
    return empty(s) ? 0.0 : Double.parseDouble(s);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public File toFile_nullOnEmpty(String s) {
    return empty(s) ? null : new File(s);
  }

  static public void setTrayIconToolTip(TrayIcon trayIcon, String toolTip) {
    if (trayIcon != null)
      trayIcon.setToolTip(toolTip);
  }

  static public JLabel jImageLabel(Image img) {
    return swingNu(JLabel.class, imageIcon(img));
  }

  static public JLabel jImageLabel(javax.swing.Icon icon) {
    return swingNu(JLabel.class, icon);
  }

  static public JLabel jImageLabel(String imageID) {
    return jImageLabel(imageIcon(imageID));
  }

  static public JLabel jImageLabel(String text, String imageID) {
    final JLabel l = swingNu(JLabel.class, text, imageIcon(imageID), JLabel.CENTER);
    {
      swing(new Runnable() {

        public void run() {
          try {
            l.setVerticalTextPosition(SwingConstants.BOTTOM);
            l.setHorizontalTextPosition(SwingConstants.CENTER);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "l.setVerticalTextPosition(SwingConstants.BOTTOM);\r\n    l.setHorizontalTextPos...";
        }
      });
    }
    return l;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public String toStringOpt(Object o) {
    return o instanceof String ? ((String) o) : null;
  }

  static public Set<String> allNonStaticFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & Modifier.STATIC) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public <A> void setAddAll(Collection<A> a, Collection<A> b) {
    for (A x : b) setAdd(a, x);
  }

  static public ThreadLocal<Boolean> dataToTable_useStruct = threadLocalWithDefault(true);

  static public void dataToTable_dynSet(List l, int i, Object s) {
    while (i >= l.size()) l.add("");
    l.set(i, s);
  }

  static public List dataToTable_makeRow(Object x, List<String> cols) {
    if (instanceOf(x, "DynamicObject"))
      x = get_raw(x, "fieldValues");
    if (x instanceof Map) {
      Map m = (Map) x;
      List row = new ArrayList();
      for (Object _field : keysWithoutHidden(m)) {
        String field = (String) _field;
        Object value = m.get(field);
        int col = cols.indexOf(field);
        if (col < 0) {
          cols.add(field);
          col = cols.size() - 1;
        }
        dataToTable_dynSet(row, col, dataToTable_wrapValue(value));
      }
      return row;
    }
    if (x instanceof List)
      return allToString((List) x);
    return litlist(structureOrText(x));
  }

  static public Object dataToTable_wrapValue(Object o) {
    if (o instanceof BufferedImage)
      return o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof RGBImage)
      return o;
    if (o instanceof Boolean)
      return o;
    return dataToTable_useStruct.get() ? structureOrTextForUser(o) : strOrNull(o);
  }

  static public String structureOrTextForUser(Object o) {
    return o == null ? "" : o instanceof String ? (String) o : structureForUser(o);
  }

  static public void fillTableWithData(final JTable table, List<List> rows, List<String> colNames) {
    fillTableWithData(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithData(final JTable table, List<List> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithData_makeModel(rows, colNames);
    setTableModel(table, model);
  }

  static public DefaultTableModel fillTableWithData_makeModel(List<List> rows, String... colNames) {
    Pair<Object[][], Object[]> p = fillTableWithData_makeData(rows, colNames);
    return new DefaultTableModel(p.a, p.b) {

      public Class getColumnClass(int column) {
        return or(_getClass(getValueAt(0, column)), String.class);
      }

      public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
      }
    };
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, List<String> colNames) {
    fillTableWithStrings(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithStrings_makeModel(rows, colNames);
    swingNowOrLater(new Runnable() {

      public void run() {
        try {
          setTableModel(table, model);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setTableModel(table, model);";
      }
    });
  }

  static public DefaultTableModel fillTableWithStrings_makeModel(List<List<String>> rows, String... colNames) {
    Object[][] data = new Object[rows.size()][];
    int w = 0;
    for (int i = 0; i < rows.size(); i++) {
      List<String> l = rows.get(i);
      Object[] r = new Object[l.size()];
      for (int j = 0; j < l.size(); j++) r[j] = l.get(j);
      data[i] = r;
      w = Math.max(w, l.size());
    }
    Object[] columnNames = new Object[w];
    for (int i = 0; i < w; i++) columnNames[i] = i < l(colNames) ? colNames[i] : "?";
    return new DefaultTableModel(data, columnNames);
  }

  static public JFrame showFrame() {
    return makeFrame();
  }

  static public JFrame showFrame(Object content) {
    return makeFrame(content);
  }

  static public JFrame showFrame(String title) {
    return makeFrame(title);
  }

  static public JFrame showFrame(String title, Object content) {
    return makeFrame(title, content);
  }

  static public JFrame showFrame(final JFrame f) {
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (frameTooSmall(f))
              frameStandardSize(f);
            if (!f.isVisible())
              f.setVisible(true);
            if (f.getState() == Frame.ICONIFIED)
              f.setState(Frame.NORMAL);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frameTooSmall(f)) frameStandardSize(f);\r\n    if (!f.isVisible()) f.setVis...";
        }
      });
    }
    return f;
  }

  static public JFrame showFrame(String title, Object content, JFrame frame) {
    if (frame == null)
      return showFrame(title, content);
    else {
      frame.setTitle(title);
      setFrameContents(frame, content);
      return frame;
    }
  }

  static public Object selectedTableCell(JTable t, int col) {
    return getTableCell(t, selectedTableRow(t), col);
  }

  static public Object selectedTableCell(final JTable t) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, t.getSelectedColumn());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret selectedTableCell(t, t.getSelectedColumn());";
      }
    });
  }

  static public Object selectedTableCell(final JTable t, final String colName) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, tableColumnViewIndex(t, colName));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret selectedTableCell(t, tableColumnViewIndex(t, colName));";
      }
    });
  }

  static public void tableEnableDrag(final JTable table, TransferHandler th) {
    if (table.getDragEnabled()) {
      print("Table drag already enabled");
      return;
    }
    table.setDragEnabled(true);
    table.setTransferHandler(th);
    table.addMouseListener(new MouseAdapter() {

      @Override
      public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 1)
          table.getTransferHandler().exportAsDrag(table, e, TransferHandler.COPY);
      }
    });
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public Map<String, Object> rawTableLineAsMap(JTable tbl, int row) {
    if (row >= 0 && row < tbl.getModel().getRowCount()) {
      Map<String, Object> map = litorderedmap();
      for (int i = 0; i < tbl.getModel().getColumnCount(); i++) mapPut(map, tbl.getModel().getColumnName(i), tbl.getModel().getValueAt(row, i));
      return map;
    }
    return null;
  }

  static public JPanel westAndCenter(final Component w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.WEST, wrap(w));
          panel.add(BorderLayout.CENTER, wrap(c));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.WEST...";
      }
    });
  }

  static public JPanel westAndCenterWithMargin(Component w, Component c) {
    return westAndCenter(withRightMargin(w), c);
  }

  static public JPanel westAndCenterWithMargin(int margin, Component w, Component c) {
    return westAndCenter(withRightMargin(margin, w), c);
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public File tempFileFor(File f) {
    return new File(f.getPath() + "_temp");
  }

  static public List collect(Iterable c, String field) {
    return collectField(c, field);
  }

  static public List collect(String field, Iterable c) {
    return collectField(c, field);
  }

  static public void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class listPopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JList, listPopupMenu_Maker> listPopupMenu_map = new WeakHashMap();

  static public ThreadLocal<MouseEvent> listPopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> listPopupMenu_first = new ThreadLocal();

  static public void listPopupMenu(final JList list, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(listPopupMenu_first));
    swingNowOrLater(new Runnable() {

      public void run() {
        try {
          listPopupMenu_Maker maker = listPopupMenu_map.get(list);
          if (maker == null) {
            listPopupMenu_map.put(list, maker = new listPopupMenu_Maker());
            final listPopupMenu_Maker _maker = maker;
            list.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                displayMenu(e);
              }

              public void mouseReleased(MouseEvent e) {
                displayMenu(e);
              }

              public void displayMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                  JPopupMenu menu = new JPopupMenu();
                  int idx = list.locationToIndex(e.getPoint());
                  Object item = list.getModel().getElementAt(idx);
                  list.setSelectedIndex(idx);
                  int emptyCount = menu.getComponentCount();
                  listPopupMenu_mouseEvent.set(e);
                  for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, item);
                  if (menu.getComponentCount() == emptyCount)
                    return;
                  vmBus_send("showingPopupMenu", list, menu);
                  menu.show(e.getComponent(), e.getX(), e.getY());
                }
              }
            });
          }
          if (first)
            maker.menuMakers.add(0, menuMaker);
          else
            maker.menuMakers.add(menuMaker);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "listPopupMenu_Maker maker = listPopupMenu_map.get(list);\r\n    if (maker == nu...";
      }
    });
  }

  static public int tableNumColumns(final JTable table) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          return table.getColumnCount();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret table.getColumnCount();";
      }
    });
  }

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL;

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL() {
    if (newPing_actionTL == null)
      newPing_actionTL = vm_generalMap_getOrCreate("newPing_actionTL", () -> {
        Runnable value = (Runnable) (callF_gen(vm_generalMap_get("newPing_valueForNewThread")));
        var tl = new x30_pkg.x30_util.BetterThreadLocal<Runnable>();
        tl.set(value);
        return tl;
      });
    return newPing_actionTL;
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isTrueOpt(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    return false;
  }

  static public boolean isTrueOpt(String field, Object o) {
    return isTrueOpt(getOpt(field, o));
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public List<String> isYes_yesses = litlist("y", "yes", "yeah", "y", "yup", "yo", "corect", "sure", "ok", "afirmative");

  static public boolean isYes(String s) {
    return isYes_yesses.contains(collapseWord(toLowerCase(firstWord2(s))));
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public <A> List<A> synchroLinkedList() {
    return Collections.synchronizedList(new LinkedList<A>());
  }

  static public <A, B> NavigableMap<A, B> synchroNavigableMap(NavigableMap<A, B> map) {
    return (NavigableMap) call(Collections.class, "synchronizedNavigableMap", map);
  }

  static public <A, B> SortedMap<A, B> synchroSortedMap(SortedMap<A, B> map) {
    return Collections.synchronizedSortedMap(map);
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public void printVars_str(Object... params) {
    print(renderVars_str(params));
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c) {
    return nuStubInnerObject_findConstructor(c, null);
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      makeAccessible(m);
      return m;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null || o == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        Field f = fieldMap.get(field);
        if (f != null)
          smartSet(f, o, val);
        else {
          dynamicObject_setRawFieldValue(o, intern(field), val);
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public Object newMultiDimensionalOuterArray(Class elementType, int dimensions, int length) {
    int[] dims = new int[dimensions];
    dims[0] = length;
    return Array.newInstance(elementType, dims);
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(IntBuffer b) {
    int n = l(b);
    double[] a = new double[n];
    for (int i = 0; i < n; i++) a[i] = b.get(i);
    return a;
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    return classForName(name, null);
  }

  static public Class classForName(String name, Object classFinder) {
    if (classForName_cache == null || classFinder != null)
      return classForName_uncached(name, classFinder);
    Class c = classForName_cache.get(name);
    if (c == null)
      classForName_cache.put(name, c = classForName_uncached(name, null));
    return c;
  }

  static public Class classForName_uncached(String name, Object classFinder) {
    try {
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public Class actualMC() {
    return or((Class) realMC(), mc());
  }

  static public boolean isAnonymousClassName(String s) {
    for (int i = 0; i < l(s); i++) if (s.charAt(i) == '$' && Character.isDigit(s.charAt(i + 1)))
      return true;
    return false;
  }

  static public byte[] boolArrayToBytes(boolean[] a) {
    byte[] b = new byte[(l(a) + 7) / 8];
    for (int i = 0; i < l(a); i++) if (a[i])
      b[i / 8] |= 1 << (i & 7);
    return b;
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final Object f, Iterable<Pair<A, B>> l) {
    return map(l, new F1<Pair<A, B>, Pair<A, C>>() {

      public Pair<A, C> get(Pair<A, B> p) {
        try {
          return p == null ? null : pair(p.a, (C) callF(f, p.b));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "p == null ? null : pair(p.a, (C) callF(f, p.b))";
      }
    });
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final F1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final IF1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(Iterable<Pair<A, B>> l, IF1<B, C> f) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> Pair<A, C> mapPairB(IF1<B, C> f, Pair<A, B> p) {
    return pairMapB(f, p);
  }

  static public <A, B, C> Pair<A, C> mapPairB(Pair<A, B> p, IF1<B, C> f) {
    return pairMapB(f, p);
  }

  static public <A, B> Map<B, A> mapToKey(Iterable<A> l, IF1<A, B> f) {
    return mapToKeys(l, f);
  }

  static public <A, B> Map<B, A> mapToKey(IF1<A, B> f, Iterable<A> l) {
    return mapToKeys(f, l);
  }

  static public Map<Class, List<String>> getFieldOrder_cache = weakMap();

  static public List<String> getFieldOrder(Object o) {
    return getFieldOrder(_getClass(o));
  }

  static public List<String> getFieldOrder(Class c) {
    if (c == null)
      return null;
    return getOrCreate(getFieldOrder_cache, c, () -> splitAtSpace(toStringOpt(getOpt(c, "_fieldOrder"))));
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  static public String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  static public boolean isMainProgram() {
    return creator() == null;
  }

  static public void cleanKill() {
    cleanKillVM();
  }

  static public String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  static public List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  static public List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  static public List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  static public int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  static public long timestampFromYMDHM(int y, int m, int d, int h, int minutes) {
    return new GregorianCalendar(y, m - 1, d, h, minutes).getTimeInMillis();
  }

  static public <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  static public boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 1 / 12.0)
      return true;
    if (age <= 0.5 && age >= lastAge + 1 / 12.0)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age <= 28 && age >= lastAge + 7)
      return true;
    if (age >= lastAge + 365.0 / 12)
      return true;
    return false;
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public <A, B, C extends Map<A, B>> C syncMapRemove_deleteMapIfEmpty(C map, A key) {
    if (map != null && key != null)
      synchronized (collectionMutex(map)) {
        map.remove(key);
        if (map.isEmpty())
          return null;
      }
    return map;
  }

  static public boolean isInAnonymousClass(Object o) {
    if (o == null)
      return false;
    return isAnonymousClassName(className(o));
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public WeakHasherMap<Symbol, Boolean> symbol_map = new WeakHasherMap(new Hasher<Symbol>() {

    public int hashCode(Symbol symbol) {
      return symbol.text.hashCode();
    }

    public boolean equals(Symbol a, Symbol b) {
      if (a == null)
        return b == null;
      return b != null && eq(a.text, b.text);
    }
  });

  static public Symbol symbol(String s) {
    if (s == null)
      return null;
    synchronized (symbol_map) {
      Symbol symbol = new Symbol(s, true);
      Symbol existingSymbol = symbol_map.findKey(symbol);
      if (existingSymbol == null)
        symbol_map.put(existingSymbol = symbol, true);
      return existingSymbol;
    }
  }

  static public Symbol symbol(CharSequence s) {
    if (s == null)
      return null;
    if (s instanceof Symbol)
      return (Symbol) s;
    if (s instanceof String)
      return symbol((String) s);
    return symbol(str(s));
  }

  static public Symbol symbol(Object o) {
    return symbol((CharSequence) o);
  }

  static public List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String roundBracket(String s) {
    return "(" + s + ")";
  }

  static public String roundBracket(Object s) {
    return roundBracket(str(s));
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  static public boolean isLoopbackIP(String ip) {
    return eq(ip, "127.0.0.1");
  }

  static public int myVMPort() {
    List records = (List) (get(getJavaX(), "record_list"));
    Object android = last(records);
    return or0((Integer) get(android, "port"));
  }

  static public String thisVMGreeting() {
    List record_list = (List) (get(getJavaX(), "record_list"));
    Object android = first(record_list);
    return getString(android, "greeting");
  }

  static public String sendToThisVM_newThread(String s, Object... args) {
    final String _s = format(s, args);
    try {
      return (String) evalInNewThread(new F0<Object>() {

        public Object get() {
          try {
            return callStaticAnswerMethod(getJavaX(), _s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ret callStaticAnswerMethod(getJavaX(), _s);";
        }
      });
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      return str(e);
    }
  }

  static public <A> A popFirst(List<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(0);
    return a;
  }

  static public <A> A popFirst(Collection<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(a);
    return a;
  }

  static public <A, B> Pair<A, B> popFirst(Map<A, B> map) {
    if (map == null)
      return null;
    var it = map.entrySet().iterator();
    if (!it.hasNext())
      return null;
    var p = mapEntryToPair(it.next());
    it.remove();
    return p;
  }

  static public <A> List<A> popFirst(int n, List<A> l) {
    List<A> part = cloneSubList(l, 0, n);
    removeSubList(l, 0, n);
    return part;
  }

  static public <A> AppendableChain<A> popFirst(AppendableChain<A> a) {
    return a == null ? null : a.popFirst();
  }

  static public Class primitiveToBoxedType(Class type) {
    if (type == boolean.class)
      return Boolean.class;
    if (type == int.class)
      return Integer.class;
    if (type == long.class)
      return Long.class;
    if (type == float.class)
      return Float.class;
    if (type == short.class)
      return Short.class;
    if (type == char.class)
      return Character.class;
    if (type == byte.class)
      return Byte.class;
    if (type == double.class)
      return Double.class;
    return null;
  }

  static public Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public Object dm_resolveModule(Object moduleOrStem) {
    return dm_callOS("resolveModule", moduleOrStem);
  }

  static public Runnable _topLevelErrorHandling(Runnable r) {
    if (r == null)
      return null;
    Object info = _threadInfo();
    Object mod = dm_current_generic();
    if (info == null && mod == null)
      return r;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = (AutoCloseable) (rcall("enter", mod));
          try {
            _threadInheritInfo(info);
            r.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp (AutoCloseable) rcall enter(mod);\r\n    _threadInheritInfo(info);\r\n    r....";
      }
    };
  }

  static public byte[] isGIF_magic = bytesFromHex("47494638");

  static public boolean isGIF(byte[] data) {
    return byteArrayStartsWith(data, isGIF_magic);
  }

  static public boolean isGIF(File f) {
    return isGIF(loadBeginningOfBinaryFile(f, l(isGIF_magic)));
  }

  static public <A> void setVar(IVar<A> v, A value) {
    if (v != null)
      v.set(value);
  }

  static public <A> IVF1<A> setVar(IVar<A> v) {
    return a -> {
      if (v != null)
        v.set(a);
    };
  }

  static public Random defaultRandomGenerator() {
    return ThreadLocalRandom.current();
  }

  static public <A> A listGet(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public boolean isFile(File f) {
    return f != null && f.isFile();
  }

  static public boolean isFile(String path) {
    return isFile(newFile(path));
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    return linesFromReader(r, null);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r, IResourceHolder resourceHolder) {
    final BufferedReader br = bufferedReader(r);
    return holdResource(resourceHolder, iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r)));
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File renameFile_assertTrue(File a, File b) {
    try {
      if (a.equals(b))
        return b;
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a) {
    return newObjectArrayOfSameType(a, a.length);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public Graphics2D antiAliasOn(Graphics2D g) {
    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    return g;
  }

  static public <A, B> Map<A, B> synchroIdentityHashMap() {
    return synchroMap(new IdentityHashMap());
  }

  static public <A, B> void mapPut2(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        map.put(key, value);
      else
        map.remove(key);
  }

  static public <A> A logStructureWithDate(File logFile, A o) {
    logQuoted(logFile, now() + " " + structure(o));
    return o;
  }

  static public <A> A logStructureWithDate(String fileName, A o) {
    return logStructureWithDate(getProgramFile(fileName), o);
  }

  static public File mechListAppendLogFile(String listName) {
    return javaxDataDir("Mech List Appends/" + uniqueFileNameUsingMD5_80(listName));
  }

  static public File createLocalMechListFile(String listName) {
    File nameFile = localMechListNameFile(listName);
    if (!nameFile.exists())
      saveTextFile(nameFile, listName);
    return localMechListFile(listName);
  }

  static public String assureTrailingNewLine(String s) {
    return addSuffix(s, "\n");
  }

  static public void setMenuBar(final JMenuBar mb, final RootPaneContainer f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            call(f, "setJMenuBar", mb);
            revalidate((Component) f);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(f, \"setJMenuBar\", mb);\r\n    revalidate((Component) f);";
        }
      });
    }
  }

  static public void setMenuBar(RootPaneContainer f, JMenuBar mb) {
    setMenuBar(mb, f);
  }

  static public Throwable _storeException_value;

  static public void _storeException(Throwable e) {
    _storeException_value = e;
  }

  static public String[] asStringArray(Collection<String> c) {
    return toStringArray(c);
  }

  static public String[] asStringArray(Object o) {
    return toStringArray(o);
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public <A> VF1<A> ivf1ToVF1(IVF1<A> f) {
    return f == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          f.get(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "f.get(a)";
      }
    };
  }

  static public <A> A second(List<A> l) {
    return get(l, 1);
  }

  static public <A> A second(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    it.next();
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A second(A[] bla) {
    return bla == null || bla.length <= 1 ? null : bla[1];
  }

  static public <A, B> B second(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public <A, B, C> B second(T3<A, B, C> t) {
    return t == null ? null : t.b;
  }

  static public <A> A second(Producer<A> p) {
    if (p == null)
      return null;
    if (p.next() == null)
      return null;
    return p.next();
  }

  static public char second(String s) {
    return charAt(s, 1);
  }

  static public <A, B> B second(Either<A, B> e) {
    return e == null ? null : e.bOpt();
  }

  static public <A> A third(List<A> l) {
    return _get(l, 2);
  }

  static public <A> A third(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      if (!it.hasNext())
        return null;
      it.next();
    }
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A third(Producer<A> p) {
    if (p == null)
      return null;
    for (int _repeat_1 = 0; _repeat_1 < 2; _repeat_1++) {
      if (p.next() == null)
        return null;
    }
    return p.next();
  }

  static public <A> A third(A[] bla) {
    return bla == null || bla.length <= 2 ? null : bla[2];
  }

  static public <A, B, C> C third(T3<A, B, C> t) {
    return t == null ? null : t.c;
  }

  static public <A> VF1<A> runnableToVF1(final Runnable r) {
    return r == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          r.run();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "r.run()";
      }
    };
  }

  static public void fillJMenu(final JMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof List)
        fillJMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o)) {
        if (menuItemCount(m) != 0)
          m.addSeparator();
      } else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem(or2(unCurlyBracket(lv.get()), "..."), y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
              revalidate(m);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv!;\r\n        if (isCurlyBracketed(s)) {\r\n          setEnabled(mi,...";
          }
        });
        print("bound live value " + lv + " to menu item " + mi);
        m.add(mi);
        ++i;
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o == null && y instanceof Runnable)
        ++i;
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public JInternalFrame showForm_makeInternalFrame(JDesktopPane desktop, String title, JPanel panel) {
    JInternalFrame f = addInternalFrame(desktop, title, withMargin(panel));
    minInternalFrameWidth(f, 400);
    packInternalFrameVertically(f);
    centerInternalFrame(f);
    return f;
  }

  static public JFrame handleEscapeKey(final JFrame frame) {
    KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    frame.getRootPane().registerKeyboardAction(new ActionListener() {

      public void actionPerformed(ActionEvent actionEvent) {
        frame.dispose();
      }
    }, stroke, JComponent.WHEN_IN_FOCUSED_WINDOW);
    return frame;
  }

  static public JFrame minFrameWidth(JFrame frame, int w) {
    if (frame != null && frame.getWidth() < w)
      frame.setSize(w, frame.getHeight());
    return frame;
  }

  static public JFrame minFrameWidth(int w, JFrame frame) {
    return minFrameWidth(frame, w);
  }

  static public JFrame showPackedFrame(String title, Component contents) {
    return packFrame(showFrame(title, contents));
  }

  static public JFrame showPackedFrame(Component contents) {
    return packFrame(showFrame(contents));
  }

  static public int showForm_leftWidth_safetyMargin = 10;

  static public int showForm_leftWidth(List<List<JComponent>> l) {
    forEachLevel2(l, x -> vmBus_send("updateLayoutNow", x));
    int minW = 0;
    for (List<JComponent> row : l) minW = max(minW, getMinimumSize(first(row)).width);
    return minW + or((Integer) vmBus_query("formSafetyMargin"), showForm_leftWidth_safetyMargin);
  }

  static public int withRightMargin_defaultWidth = 6;

  static public JPanel withRightMargin(Component c) {
    return withRightMargin(withRightMargin_defaultWidth, c);
  }

  static public JPanel withRightMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = marginPanel();
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, w));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = marginPanel();\r\n    p.setBorder(BorderFactory.createEmptyBorder(0,...";
      }
    });
  }

  static public <A extends Component> A jMinWidthAtLeast(int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          Dimension d = new Dimension(max(w, size.width), size.height);
          c.setMinimumSize(d);
          return jPreferWidth(d.width, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    Dimension d = new Dimension(max(w, ...";
      }
    });
  }

  static public void setComponentID(Component c, String id) {
    if (c != null)
      componentID_map.put(c, id);
  }

  static public List mapLL(Object f, Object... data) {
    return map(f, ll(data));
  }

  static public <A, B> List<B> mapLL(IF1<A, B> f, A... data) {
    return map(f, ll(data));
  }

  static public JComponent wrapForSmartAdd_jComponent(Object o) {
    return componentToJComponent(wrapForSmartAdd(o));
  }

  static public boolean isRunnable(Object o) {
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public String showFormSubmitButtonName() {
    return "Submit";
  }

  static public void disposeInternalFrame(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            vmBus_send("disposingInternalFrame", f);
            f.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "vmBus_send disposingInternalFrame(f);\r\n    f.dispose();\r\n    // now illegal.....";
        }
      });
    }
  }

  static public void disposeFrame(final Component c) {
    disposeWindow(c);
  }

  static public void onEnterInAllTextFields(JComponent c, Object action) {
    if (action == null)
      return;
    for (Component tf : allChildren(c)) onEnterIfTextField(tf, action);
  }

  static public void onEnterInAllTextFields(List c, Object action) {
    for (Object o : unnull(c)) if (o instanceof JComponent)
      onEnterInAllTextFields((JComponent) o, action);
  }

  static public void clickButton(final JButton b) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (b.isEnabled())
              b.doClick();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (b.isEnabled())\r\n      b.doClick();";
        }
      });
    }
  }

  static public <A extends JComponent> A makeBold(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));";
        }
      });
    }
    return c;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, List parts) {
    for (Object o : parts) panel.add(wrapForSmartAdd(o), layout);
    return panel;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, Object... parts) {
    return smartAddWithLayout(panel, layout, asList(flattenArray2(parts)));
  }

  static public <A> List<A> nonNulls(Iterable<A> l) {
    return withoutNulls(l);
  }

  static public <A> List<A> nonNulls(A[] l) {
    return withoutNulls(l);
  }

  static public <A, B> Map<A, B> nonNulls(Map<A, B> map) {
    return withoutNulls(map);
  }

  static public Component jrigid() {
    return javax.swing.Box.createRigidArea(new Dimension(0, 0));
  }

  static public String getText(final AbstractButton c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JTextComponent c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JLabel l) {
    return l == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return l.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret l.getText();";
      }
    });
  }

  static public String getText(final JComboBox cb) {
    if (cb == null)
      return null;
    if (isEditableComboBox(cb))
      return unnull((String) cb.getEditor().getItem());
    else
      return str(cb.getSelectedItem());
  }

  static public <A> ThreadLocal<A> threadLocalWithDefault(A defaultValue) {
    return new ThreadLocal<A>() {

      public A initialValue() {
        return defaultValue;
      }
    };
  }

  static public <A, B> List<A> keysWithoutHidden(Map<A, B> map) {
    return filter(keys(map), new F1<Object, Boolean>() {

      public Boolean get(Object o) {
        try {
          return !eq(o, "[hidden]") && !isStringStartingWith(o, "[hidden] ");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "!eq(o, \"[hidden]\") && !isStringStartingWith(o, \"[hidden] \")";
      }
    });
  }

  static public String structureOrText(Object o) {
    return o instanceof String ? (String) o : structure(o);
  }

  static public Pair<Object[][], Object[]> fillTableWithData_makeData(List<List> rows, List<String> colNames) {
    return fillTableWithData_makeData(rows, asStringArray(colNames));
  }

  static public Pair<Object[][], Object[]> fillTableWithData_makeData(List<List> rows, String... colNames) {
    Object[][] data = new Object[rows.size()][];
    int w = 0;
    for (int i = 0; i < rows.size(); i++) {
      List l = rows.get(i);
      Object[] r = new Object[l.size()];
      for (int j = 0; j < l.size(); j++) {
        Object o = l.get(j);
        if (o instanceof BufferedImage)
          o = imageIcon((BufferedImage) o);
        if (o instanceof RGBImage)
          o = imageIcon((RGBImage) o);
        r[j] = o;
      }
      data[i] = r;
      w = Math.max(w, l.size());
    }
    Object[] columnNames = new Object[w];
    for (int i = 0; i < w; i++) columnNames[i] = i < l(colNames) ? colNames[i] : "?";
    return pair(data, columnNames);
  }

  static public void swingNowOrLater(Runnable r) {
    if (isAWTThread())
      r.run();
    else
      swingLater(r);
  }

  static public boolean frameTooSmall(JFrame frame) {
    return frame.getWidth() < 100 || frame.getHeight() < 50;
  }

  static public void frameStandardSize(JFrame frame) {
    frame.setBounds(300, 100, 500, 400);
  }

  static public void setFrameContents(final Component c, final Object contents) {
    swing(new Runnable() {

      public void run() {
        try {
          JFrame frame = getFrame(c);
          if (frame == null)
            return;
          frame.getContentPane().removeAll();
          frame.getContentPane().setLayout(new BorderLayout());
          frame.getContentPane().add(wrap(contents));
          revalidate(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JFrame frame = getFrame(c);\r\n  if (frame == null) return;\r\n  frame.getContent...";
      }
    });
  }

  static public Object getTableCell(JTable tbl, int row, int col) {
    if (row >= 0 && row < tbl.getModel().getRowCount())
      return tbl.getModel().getValueAt(row, col);
    return null;
  }

  static public int tableColumnViewIndex(final JTable t, final String colName) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());";
      }
    });
  }

  static public List collectField(Iterable c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  static public List collectField(String field, Iterable c) {
    return collectField(c, field);
  }

  static public Map<Component, String> componentID_map = weakHashMap();

  static public String componentID(Component c) {
    return c == null ? null : componentID_map.get(c);
  }

  static public <A> A callF_gen(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF_gen(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF_gen(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF_gen(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A, B, C> C callF_gen(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF_gen(VF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(A a, IVF1<A> f) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(IVF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public Object callF_gen(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF_gen(Object f, Object... args) {
    return callF(f, args);
  }

  static public File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public String collapseWord(String s) {
    if (s == null)
      return "";
    StringBuilder buf = new StringBuilder();
    for (int i = 0; i < l(s); i++) if (i == 0 || !charactersEqualIC(s.charAt(i), s.charAt(i - 1)))
      buf.append(s.charAt(i));
    return buf.toString();
  }

  static public List<String> toLowerCase(List<String> strings) {
    List<String> x = new ArrayList();
    for (String s : strings) x.add(s.toLowerCase());
    return x;
  }

  static public String[] toLowerCase(String[] strings) {
    String[] x = new String[l(strings)];
    for (int i = 0; i < l(strings); i++) x[i] = strings[i].toLowerCase();
    return x;
  }

  static public String toLowerCase(String s) {
    return s == null ? "" : s.toLowerCase();
  }

  static public String firstWord2(String s) {
    s = xltrim(s);
    if (empty(s))
      return "";
    if (isLetterOrDigit(first(s)))
      return takeCharsWhile(__86 -> isLetterOrDigit(__86), s);
    else
      return "" + first(s);
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public Object safeUnstructure(File f) {
    return safeUnstructureGZFile(f);
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      return classForName(name, classFinder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class getOuterClass(Object o) {
    return getOuterClass(o, null);
  }

  static public Class getOuterClass(Object o, Object classFinder) {
    return getOuterClass(_getClass(o), classFinder);
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    return (HashMap) getOpt_getFieldMap(o);
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().startsWith("this$"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public Pair pairMapB(Object f, Pair p) {
    return p == null ? null : pair(p.a, callF(f, p.b));
  }

  static public <A, B, C> Pair<A, C> pairMapB(IF1<B, C> f, Pair<A, B> p) {
    return p == null ? null : pair(p.a, f.get(p.b));
  }

  static public Pair pairMapB(Pair p, Object f) {
    return pairMap(f, p);
  }

  static public <A, B> Map<B, A> mapToKeys(Iterable<A> l, IF1<A, B> f) {
    if (l == null)
      return null;
    HashMap<B, A> map = new HashMap();
    for (A a : l) map.put(f.get(a), a);
    return map;
  }

  static public <A, B> Map<B, A> mapToKeys(IF1<A, B> f, A[] l) {
    return mapToKeys(f, asList(l));
  }

  static public <A, B> Map<B, A> mapToKeys(IF1<A, B> f, Iterable<A> l) {
    return mapToKeys(l, f);
  }

  static public <A, B> Map<A, B> weakMap() {
    return newWeakHashMap();
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, Class<? extends B> c) {
    try {
      B b = map.get(key);
      if (b == null)
        map.put(key, b = c.newInstance());
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, Object f) {
    try {
      B b = map.get(key);
      if (b == null)
        map.put(key, b = (B) callF(f));
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> B getOrCreate(IF0<B> f, Map<A, B> map, A key) {
    return getOrCreate(map, key, f);
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, IF0<B> f) {
    B b = map.get(key);
    if (b == null)
      map.put(key, b = f.get());
    return b;
  }

  static public <A, B> B getOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
    return getOrCreate(map, key, c);
  }

  static public boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  static public boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  static public boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  static public void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  static public String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  static public boolean exposeMethods2_debug = false;

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  static public int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  static public Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  static public Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  static public Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  static public List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  static public List<File> listFilesOnly(File... dirs) {
    return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public List<String> dropPunctuation_keep = ll("*", "<", ">");

  static public List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  static public String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public int or0(Integer i) {
    return i == null ? 0 : i;
  }

  static public long or0(Long l) {
    return l == null ? 0L : l;
  }

  static public double or0(Double d) {
    return d == null ? 0.0 : d;
  }

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public Object evalInNewThread(final Object f) {
    final Flag flag = new Flag();
    final Var var = new Var();
    final Var<Throwable> exception = new Var();
    {
      startThread(new Runnable() {

        public void run() {
          try {
            try {
              var.set(callF(f));
            } catch (Throwable e) {
              exception.set(e);
            }
            flag.raise();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception...";
        }
      });
    }
    flag.waitUntilUp();
    if (exception.has())
      throw rethrow(exception.get());
    return var.get();
  }

  static public String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  static public String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  static public String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  static public String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  static public String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  static public <A extends AutoCloseable> A holdResource(IResourceHolder holder, A a) {
    {
      if (holder != null)
        holder.add(a);
    }
    return a;
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public int roundDownTo(int n, int x) {
    return x / n * n;
  }

  static public long roundDownTo(long n, long x) {
    return x / n * n;
  }

  static public String uniqueFileNameUsingMD5_80(String fullName) {
    return md5(fullName) + " " + takeFirst(80 - 33, fileNameEncode(fullName));
  }

  static public File localMechListNameFile(String listName) {
    return newFile(localMechListsDir(), uniqueFileNameUsingMD5_80_v2(listName) + ".name");
  }

  static public File localMechListFile(String listName) {
    return newFile(localMechListsDir(), uniqueFileNameUsingMD5_80_v2(listName) + ".text");
  }

  static public boolean isSubclass(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public int menuItemCount(JMenu menu) {
    return menu == null ? 0 : swing(() -> menu.getItemCount());
  }

  static public ThreadLocal<Boolean> addInternalFrame_dontSelect = new ThreadLocal();

  static public ThreadLocal<Integer> addInternalFrame_layer = new ThreadLocal();

  static public ThreadLocal<Boolean> addInternalFrame_toBack = new ThreadLocal();

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h) {
    return addInternalFrame(desktop, title, x, y, w, h, null);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h, final Component contents) {
    return addInternalFrame(desktop, title, rect(x, y, w, h), contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Component contents) {
    return addInternalFrame(desktop, title, null, contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Rect r, final Component contents) {
    final boolean dontSelect = isTrue(optParam(addInternalFrame_dontSelect));
    final boolean toBack = isTrue(optParam(addInternalFrame_toBack));
    final Integer layer = optParam(addInternalFrame_layer);
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame frame;
          if (contents instanceof JInternalFrame)
            frame = (JInternalFrame) contents;
          else {
            frame = jInternalFrame(title);
            setInternalFrameContents(frame, contents);
          }
          frame.setVisible(true);
          desktop.add(frame, layer);
          if (r != null)
            setBounds(frame, r);
          else
            internalFrameDefaultPosition(frame);
          if (dontSelect)
            if (toBack)
              frame.toBack();
            else
              frame.toFront();
          else
            frame.setSelected(true);
          return fixInternalFrame(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame frame;\r\n    if (contents instanceof JInternalFrame)\r\n      fra...";
      }
    });
  }

  static public JInternalFrame addInternalFrame(JDesktopPane desktop, String title) {
    return addInternalFrame(desktop, title, jpanel());
  }

  static public JInternalFrame minInternalFrameWidth(final JInternalFrame frame, final int w) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (frame != null && frame.getWidth() < w)
              frame.setSize(w, frame.getHeight());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frame != null && frame.getWidth() < w)\r\n      frame.setSize(w, frame.getH...";
        }
      });
    }
    return frame;
  }

  static public JInternalFrame minInternalFrameWidth(int w, JInternalFrame frame) {
    return minInternalFrameWidth(frame, w);
  }

  static public <A extends Component> A packInternalFrameVertically(A c) {
    return packInternalFrameVertically(-1, c);
  }

  static public <A extends Component> A packInternalFrameVertically(int width, A c) {
    final JInternalFrame win = getInternalFrame(c);
    if (win == null)
      return c;
    final int w = width < 0 ? win.getWidth() : width;
    {
      swing(new Runnable() {

        public void run() {
          try {
            win.pack();
            win.setSize(w, win.getHeight());
            fixInternalFrame(win);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "win.pack();\r\n    win.setSize(w, win.getHeight());\r\n    fixInternalFrame(win);";
        }
      });
    }
    return c;
  }

  static public JInternalFrame centerInternalFrame(final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Container c = f.getParent();
            if (c != null) {
              f.setLocation((c.getWidth() - f.getWidth()) / 2, (c.getHeight() - f.getHeight()) / 2);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Container c = f.getParent();\r\n    if (c != null) {\r\n      //print(\"Container ...";
        }
      });
    }
    return f;
  }

  static public JInternalFrame centerInternalFrame(final int w, final int h, final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            f.setSize(w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setSize(w, h);";
        }
      });
    }
    return centerInternalFrame(f);
  }

  static public int packFrame_minw = 150, packFrame_minh = 50;

  static public <A extends Component> A packFrame(final A c) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Window w = getWindow(c);
            if (w != null) {
              w.pack();
              int maxW = getScreenWidth() - 50, maxH = getScreenHeight() - 50;
              w.setSize(min(maxW, max(w.getWidth(), packFrame_minw)), min(maxH, max(w.getHeight(), packFrame_minh)));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Window w = getWindow(c);\r\n    if (w != null) {\r\n      w.pack();\r\n      int ma...";
        }
      });
    }
    return c;
  }

  static public JFrame packFrame(ButtonGroup g) {
    return packFrame(getFrame(g));
  }

  static public <A, B extends Collection<A>> void forEachLevel2(Iterable<B> l, IVF1<A> f) {
    if (l != null)
      for (B b : l) forEach(b, f);
  }

  static public <A, B extends Collection<A>> void forEachLevel2(IVF1<A> f, Iterable<B> l) {
    forEachLevel2(f, l);
  }

  static public Dimension getMinimumSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getMinimumSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getMinimumSize();";
      }
    });
  }

  static public List<Component> allChildren(Component c) {
    return childrenOfType(c, Component.class);
  }

  static public void onEnterIfTextField(Component c, Object action) {
    if (action == null)
      return;
    if (c instanceof JTextField)
      onEnter((JTextField) c, action);
    else if (c instanceof JComboBox)
      onEnter((JComboBox) c, action);
  }

  static public <A> List<A> withoutNulls(Iterable<A> l) {
    if (l instanceof List)
      if (!containsNulls((List) l))
        return ((List) l);
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public boolean isStringStartingWith(Object o, String prefix) {
    return o instanceof String && ((String) o).startsWith(prefix);
  }

  static public boolean charactersEqualIC(char c1, char c2) {
    if (c1 == c2)
      return true;
    char u1 = Character.toUpperCase(c1);
    char u2 = Character.toUpperCase(c2);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public String xltrim(String s) {
    int i = 0, n = l(s);
    while (i < n && contains(" \t\r\n", s.charAt(i))) ++i;
    return substr(s, i);
  }

  static public String takeCharsWhile(String s, Object pred) {
    int i = 0;
    while (i < l(s) && isTrue(callF(pred, s.charAt(i)))) ++i;
    return substring(s, 0, i);
  }

  static public String takeCharsWhile(IF1<Character, Boolean> f, String s) {
    return takeCharsWhile(s, f);
  }

  static public Object safeUnstructureGZFile(File f) {
    try {
      if (!fileExists(f))
        return null;
      BufferedReader reader = utf8BufferedReader(gzInputStream(f));
      return unstructure_tok(javaTokC_noMLS_onReader(reader), true, null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Class<A> type, Iterable<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public Pair pairMap(Object f, Pair p) {
    return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
  }

  static public <A> Pair<A, A> pairMap(IF1<A, A> f, Pair<A, A> p) {
    return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
  }

  static public Pair pairMap(Pair p, Object f) {
    return pairMap(f, p);
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public String ok2(String s) {
    return "ok " + s;
  }

  static public boolean makeAndroid3_disable = false;

  static public class Android3 implements AutoCloseable {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public void close() {
      dispose();
    }

    synchronized public void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  static abstract public class Responder {

    abstract public String answer(String s, List<String> history);
  }

  static public Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  static public Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  static public Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  static public void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  static public DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  static public String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  static public String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  static public boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  static public Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  static public ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  static public Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  static public String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  static public Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  static public String defaultBotName() {
    return getProgramTitle() + ".";
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public Object rcurry(final Object f, final Object arg) {
    int n = numberOfFunctionArguments(f);
    if (n == 0)
      throw fail("function takes no arguments");
    if (n == 1)
      return new F0() {

        public Object get() {
          return callF(f, arg);
        }
      };
    if (n == 2)
      return new F1() {

        public Object get(Object a) {
          return callF(f, a, arg);
        }
      };
    throw todo("currying a function with " + n + "arguments");
  }

  static public List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  static public String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  static public <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public File localMechListsDir() {
    return javaxDataDir("Mech Lists");
  }

  static public boolean jInternalFrame_iconifiable = true;

  static public JInternalFrame jInternalFrame() {
    return jInternalFrame("");
  }

  static public JInternalFrame jInternalFrame(final String title) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame_iconifiable);
          f.setVisible(true);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame...";
      }
    });
  }

  static public void setInternalFrameContents(final Component c, final Object contents) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            JInternalFrame frame = getInternalFrame(c);
            if (frame == null)
              return;
            frame.getContentPane().removeAll();
            frame.getContentPane().setLayout(new BorderLayout());
            if (contents != null)
              frame.getContentPane().add(wrap(contents));
            revalidate(frame);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JInternalFrame frame = getInternalFrame(c);\r\n    if (frame == null) return;\r\n...";
        }
      });
    }
  }

  static public <A extends Component> A setBounds(final int x, final int y, final int w, final int h, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(x, y, w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(x, y, w, h);";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(A a, Rect r) {
    if (a != null && r != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(toRectangle(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(toRectangle(r));";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(Rect r, A a) {
    return setBounds(a, r);
  }

  static public <A extends Component> A setBounds(A a, int x, int y, int w, int h) {
    return setBounds(x, y, w, h, a);
  }

  static public void internalFrameDefaultPosition(JInternalFrame f) {
    f.setSize(500, 300);
    centerInternalFrame(f);
  }

  static public int fixInternalFrame_borderTopLeft = 0;

  static public int fixInternalFrame_borderBottomRight = 40;

  static public JInternalFrame fixInternalFrame(final JInternalFrame f) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Container c = f.getParent();
          if (c == null)
            return f;
          Rect r = toRect(f.getBounds());
          int a = fixInternalFrame_borderTopLeft, b = fixInternalFrame_borderBottomRight;
          Rect outer = new Rect(a, a, c.getWidth() - b, c.getHeight() - b);
          if (!rectContains(outer, r))
            f.setLocation(max(a, min(r.x, outer.x2())), max(a, min(r.y, outer.y2())));
          if (r.w > c.getWidth() || r.h > c.getHeight())
            f.setSize(c.getWidth() - a, c.getHeight() - a);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Container c = f.getParent();\r\n    if (c == null) ret f;\r\n    Rect r = toRect(...";
      }
    });
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public String substr(String s, int x) {
    return substring(s, x);
  }

  static public String substr(String s, int x, int y) {
    return substring(s, x, y);
  }

  static public BufferedReader utf8BufferedReader(InputStream in) {
    return utf8bufferedReader(in);
  }

  static public BufferedReader utf8BufferedReader(File f) {
    return utf8bufferedReader(f);
  }

  static public void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  static public List<Object> record_list = synchroList();

  static public void record(Object o) {
    record_list.add(o);
  }

  static public Object addToMultiPort_responder;

  static public long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  static public long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  static public AtomicInteger dialogServer_clients = new AtomicInteger();

  static public boolean dialogServer_printConnects = false;

  static public ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  static public Set<String> dialogServer_knownClients = synchroTreeSet();

  static public int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  static public int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  static public void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  static public ServerSocket startDialogServer_serverSocket;

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  static volatile public boolean readLine_noReadLine = false;

  static public String readLine_lastInput;

  static public String readLine_prefix = "[] ";

  static public String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  static public String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  static public boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  static public String processID_cached;

  static public String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  static public String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  static public Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  static public int numberOfFunctionArguments(Object f) {
    if (f instanceof F0)
      return 0;
    if (f instanceof F1)
      return 1;
    if (f instanceof F2)
      return 2;
    if (f instanceof VF1)
      return 1;
    if (f instanceof VF2)
      return 2;
    if (f instanceof String)
      return numberOfMethodArguments(mc(), (String) f);
    return numberOfMethodArguments(f, "get");
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  static public void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  static public <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  static public <A> Set<A> synchroTreeSet(TreeSet<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public boolean forbiddenPort(int port) {
    return port == 5037;
  }

  static public String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int numberOfMethodArguments(Object o, String method) {
    Class c;
    boolean mustBeStatic = false;
    if (o instanceof Class) {
      c = (Class) o;
      mustBeStatic = true;
    } else
      c = o.getClass();
    Class _c = c;
    int n = -1;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if (mustBeStatic && !methodIsStatic(m))
          continue;
        int nn = l(m.getParameterTypes());
        if (n == -1)
          n = nn;
        else if (n != nn)
          throw fail("Variable number of method arguments: " + _c + "." + method);
      }
      c = c.getSuperclass();
    }
    if (n == -1)
      throw fail("Method not found: " + _c + "." + method);
    return n;
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public void consoleClearInput() {
    consoleSetInput("");
  }

  static public void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  static public JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    if (tf != null) {
      swing(new Runnable() {

        public void run() {
          try {
            tf.setText(text);
            tf.selectAll();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tf.setText(text);\r\n    tf.selectAll();";
        }
      });
    }
    return tf;
  }

  static public JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  static public void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  static public void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  static public void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  static public JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  static public class Meta implements IMeta {

    volatile public Object meta;

    public void _setMeta(Object meta) {
      this.meta = meta;
    }

    public Object _getMeta() {
      return meta;
    }
  }

  static public class Var<A> implements IVar<A>, ISetter<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public void clear() {
      set(null);
    }

    public String toString() {
      return str(this.get());
    }
  }

  static public class DefunctClassLoader {
  }

  static public interface ITokCondition {

    public boolean get(List<String> tok, int i);
  }

  static public class SecretValue<A> extends Var<A> {

    public SecretValue() {
    }

    public SecretValue(A a) {
      super(a);
    }

    public String toString() {
      return "Secret value";
    }
  }

  static public class ImageSurface extends Surface {

    public BufferedImage image;

    public double zoomX = 1, zoomY = 1, zoomFactor = 1.5;

    public Rectangle selection;

    public List tools = new ArrayList();

    public Object overlay;

    public Runnable onSelectionChange;

    static public boolean verbose = false;

    public boolean noMinimumSize = true;

    public String titleForUpload;

    public Object onZoom;

    public boolean specialPurposed = false;

    public boolean zoomable = true;

    public boolean noAlpha = false;

    public Object interpolationMode = RenderingHints.VALUE_INTERPOLATION_BILINEAR;

    public Object onNewImage;

    public BufferedImage imageToDraw;

    public File file;

    public ImageSurface() {
      this(dummyImage());
    }

    static public BufferedImage dummyImage() {
      return new RGBImage(1, 1, new int[] { 0xFFFFFF }).getBufferedImage();
    }

    public ImageSurface(MakesBufferedImage image) {
      this(image != null ? image.getBufferedImage() : dummyImage());
    }

    public ImageSurface(BufferedImage image) {
      setImage(image);
      clearSurface = false;
      componentPopupMenu2(this, ImageSurface_popupMenuMaker());
      new ImageSurfaceSelector(this);
      jHandleFileDrop(this, new VF1<File>() {

        public void get(File f) {
          try {
            setImage(loadBufferedImage(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "setImage(loadBufferedImage(f))";
        }
      });
    }

    public ImageSurface(RGBImage image, double zoom) {
      this(image);
      setZoom(zoom);
    }

    public void fillPopupMenu(JPopupMenu menu, final Point point) {
      if (zoomable) {
        JMenuItem miZoomReset = new JMenuItem("Zoom 100%");
        miZoomReset.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            setZoom(1.0);
            centerPoint(point);
          }
        });
        menu.add(miZoomReset);
        JMenuItem miZoomIn = new JMenuItem("Zoom in");
        miZoomIn.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomIn(zoomFactor);
            centerPoint(point);
          }
        });
        menu.add(miZoomIn);
        JMenuItem miZoomOut = new JMenuItem("Zoom out");
        miZoomOut.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomOut(zoomFactor);
            centerPoint(point);
          }
        });
        menu.add(miZoomOut);
        JMenuItem miZoomToWindow = new JMenuItem("Zoom to window");
        miZoomToWindow.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomToDisplaySize();
          }
        });
        menu.add(miZoomToWindow);
        addMenuItem(menu, "Show full screen", new Runnable() {

          public void run() {
            try {
              showFullScreen();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "showFullScreen()";
          }
        });
        addMenuItem(menu, "Point: " + point.x + "," + point.y + " (image: " + w() + "*" + h() + ")", null);
        menu.addSeparator();
      }
      addMenuItem(menu, "Load image...", new Runnable() {

        public void run() {
          try {
            selectFile("Load image", new VF1<File>() {

              public void get(File f) {
                try {
                  setImage(loadImage2(f));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "setImage(loadImage2(f))";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "selectFile(\"Load image\",\r\n      new VF1<File>() { public void get(File f) cte...";
        }
      });
      addMenuItem(menu, "Save image...", new Runnable() {

        public void run() {
          try {
            saveImage();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "saveImage()";
        }
      });
      addMenuItem(menu, "Upload image...", new Runnable() {

        public void run() {
          try {
            uploadTheImage();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "uploadTheImage()";
        }
      });
      addMenuItem(menu, "Copy image to clipboard", new Runnable() {

        public void run() {
          try {
            copyImageToClipboard(getImage());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "copyImageToClipboard(getImage())";
        }
      });
      if (!specialPurposed) {
        addMenuItem(menu, "Paste image from clipboard", new Runnable() {

          public void run() {
            try {
              loadFromClipboard();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "loadFromClipboard()";
          }
        });
        addMenuItem(menu, "Load image snippet...", new Runnable() {

          public void run() {
            try {
              selectImageSnippet(new VF1<String>() {

                public void get(String imageID) {
                  try {
                    setImage(loadImage2(imageID));
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "setImage(loadImage2(imageID))";
                }
              });
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "selectImageSnippet(new VF1<String>() { public void get(String imageID) ctex {...";
          }
        });
      }
      if (selection != null)
        addMenuItem(menu, "Crop", new Runnable() {

          public void run() {
            try {
              crop();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "crop()";
          }
        });
      if (!specialPurposed)
        addMenuItem(menu, "No image", new Runnable() {

          public void run() {
            try {
              noImage();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "noImage()";
          }
        });
    }

    public void noImage() {
      setImage((BufferedImage) null);
    }

    public void crop() {
      if (selection == null)
        return;
      BufferedImage img = cloneClipBufferedImage(getImage(), selection);
      selection = null;
      setImage(img);
    }

    public void loadFromClipboard() {
      BufferedImage img = getImageFromClipboard();
      if (img != null)
        setImage(img);
    }

    public void saveImage() {
      RGBImage image = new RGBImage(getImage(), null);
      JFileChooser fileChooser = new JFileChooser(getProgramDir());
      if (fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
        try {
          image.save(file = fileChooser.getSelectedFile());
        } catch (IOException e) {
          popup(e);
        }
      }
    }

    public void drawImageItself(int w, int h, Graphics2D g) {
      int iw = getZoomedWidth(), ih = getZoomedHeight();
      if (interpolationMode == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || zoomX >= 1 || zoomY >= 1)
        g.drawImage(image, 0, 0, iw, ih, null);
      else
        g.drawImage(resizeImage(image, iw, ih), 0, 0, null);
    }

    public void render(int w, int h, Graphics2D g) {
      if (verbose)
        _print("render");
      g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationMode);
      g.setColor(Color.white);
      BufferedImage image = or(imageToDraw, this.image);
      if (!hasImage())
        g.fillRect(0, 0, w, h);
      else {
        boolean alpha = !noAlpha && hasTransparency(image);
        if (alpha)
          g.fillRect(0, 0, w, h);
        drawImageItself(w, h, g);
        int iw = getZoomedWidth(), ih = getZoomedHeight();
        if (!alpha) {
          g.fillRect(iw, 0, w - iw, h);
          g.fillRect(0, ih, iw, h - ih);
        }
      }
      if (overlay != null) {
        if (verbose)
          _print("render overlay");
        pcallF(overlay, g);
      }
      if (selection != null) {
        if (verbose)
          _print("render selection");
        drawSelectionRect(g, selection, Color.green, Color.white);
      }
    }

    public void drawSelectionRect(Graphics2D g, Rectangle selection, Color green, Color white) {
      drawSelectionRect(g, selection, green, white, zoomX, zoomY);
    }

    public void drawSelectionRect(Graphics2D g, Rectangle selection, Color green, Color white, double zoomX, double zoomY) {
      g.setColor(green);
      int top = (int) (selection.y * zoomY);
      int bottom = (int) ((selection.y + selection.height) * zoomY);
      int left = (int) (selection.x * zoomX);
      int right = (int) ((selection.x + selection.width) * zoomX);
      g.drawRect(left - 1, top - 1, right - left + 1, bottom - top + 1);
      g.setColor(white);
      g.drawRect(left - 2, top - 2, right - left + 3, bottom - top + 3);
    }

    public ImageSurface setZoom(double zoom) {
      setZoom(zoom, zoom);
      return this;
    }

    public void setZoom(double zoomX, double zoomY) {
      if (this.zoomX == zoomX && this.zoomY == zoomY)
        return;
      if (verbose)
        _print("Setting zoom");
      this.zoomX = zoomX;
      this.zoomY = zoomY;
      revalidate();
      repaint();
      centerPoint(new Point(getImage().getWidth() / 2, getImage().getHeight() / 2));
      pcallF(onZoom);
    }

    public Dimension getMinimumSize() {
      if (noMinimumSize)
        return new Dimension(1, 1);
      int w = getZoomedWidth();
      int h = getZoomedHeight();
      Dimension min = super.getMinimumSize();
      return new Dimension(Math.max(w, min.width), Math.max(h, min.height));
    }

    public int getZoomedHeight() {
      return (int) (h() * zoomY);
    }

    public int getZoomedWidth() {
      return (int) (w() * zoomX);
    }

    public void setImage(MakesBufferedImage image) {
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void setImage(final BufferedImage img) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              BufferedImage newImage = img != null ? img : dummyImage();
              BufferedImage oldImage = image;
              image = newImage;
              if (!imagesHaveSameSize(oldImage, newImage)) {
                if (verbose)
                  _print("New image size");
                revalidate();
              }
              repaint();
              pcallF(onNewImage);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "BufferedImage newImage = img != null ? img : dummyImage();\r\n      BufferedIma...";
          }
        });
      }
    }

    public void setImageAndZoomToDisplay(BufferedImage img) {
      setImage(img);
      zoomToDisplaySize();
    }

    public BufferedImage getImage() {
      return image;
    }

    public double getZoomX() {
      return zoomX;
    }

    public double getZoomY() {
      return zoomY;
    }

    public Dimension getPreferredSize() {
      return new Dimension(getZoomedWidth(), getZoomedHeight());
    }

    public JScrollPane makeScrollPane() {
      JScrollPane scrollPane = new JScrollPane(this);
      scrollPane.getViewport().setScrollMode(JViewport.BACKINGSTORE_SCROLL_MODE);
      return scrollPane;
    }

    public void zoomToWindow() {
      zoomToDisplaySize();
    }

    public void zoomToDisplaySize() {
      swing(new Runnable() {

        public void run() {
          try {
            if (!hasImage())
              return;
            Dimension display = getDisplaySize();
            double xRatio = (display.width - 5) / (double) w();
            double yRatio = (display.height - 5) / (double) h();
            setZoom(min(xRatio, yRatio));
            revalidate();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!hasImage()) return;\r\n    Dimension display = getDisplaySize();\r\n    doub...";
        }
      });
    }

    final public Dimension getDisplaySize() {
      Container c = getParent();
      while (c != null) {
        if (c instanceof JScrollPane)
          return c.getSize();
        c = c.getParent();
      }
      return getSize();
    }

    public void setSelection(Rect r) {
      setSelection(toRectangle(r));
    }

    public void setSelection(Rectangle r) {
      if (neq(selection, r)) {
        selection = r;
        pcallF(onSelectionChange);
        repaint();
      }
    }

    public Rectangle getSelection() {
      return selection;
    }

    public RGBImage getRGBImage() {
      return new RGBImage(getImage());
    }

    public void centerPoint(Point p) {
      JScrollPane sp = enclosingScrollPane(this);
      if (sp == null)
        return;
      p = new Point((int) (p.x * getZoomX()), (int) (p.y * getZoomY()));
      final JViewport viewport = sp.getViewport();
      Dimension viewSize = viewport.getExtentSize();
      int x = max(0, p.x - viewSize.width / 2);
      int y = max(0, p.y - viewSize.height / 2);
      p = new Point(x, y);
      final Point _p = p;
      awtLater(new Runnable() {

        public void run() {
          try {
            viewport.setViewPosition(_p);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "viewport.setViewPosition(_p);";
        }
      });
    }

    public Pt pointFromEvent(MouseEvent e) {
      return pointFromComponentCoordinates(new Pt(e.getX(), e.getY()));
    }

    public Pt pointFromComponentCoordinates(Pt p) {
      return new Pt((int) (p.x / zoomX), (int) (p.y / zoomY));
    }

    public Pt pointToComponentCoordinates(double x, double y) {
      return new Pt((int) (x * zoomX), (int) (y * zoomY));
    }

    public void uploadTheImage() {
      call(hotwire("#1016427"), "go", getImage(), titleForUpload);
    }

    public void showFullScreen() {
      showFullScreenImageSurface(getImage());
    }

    public void zoomIn(double f) {
      setZoom(getZoomX() * f, getZoomY() * f);
    }

    public void zoomOut(double f) {
      setZoom(getZoomX() / f, getZoomY() / f);
    }

    public ImageSurface setFile(File f) {
      file = f;
      return this;
    }

    public void setOverlay(IVF1<Graphics2D> overlay) {
      this.overlay = overlay;
    }

    public boolean hasImage() {
      return image != null;
    }

    public int w() {
      return image.getWidth();
    }

    public int h() {
      return image.getHeight();
    }
  }

  static public VF2<ImageSurface, JPopupMenu> ImageSurface_popupMenuMaker() {
    return new VF2<ImageSurface, JPopupMenu>() {

      public void get(ImageSurface is, JPopupMenu menu) {
        try {
          Point p = is.pointFromEvent(componentPopupMenu_mouseEvent.get()).getPoint();
          is.fillPopupMenu(menu, p);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Point p = is.pointFromEvent(componentPopupMenu_mouseEvent.get()).getPoint();\r...";
      }
    };
  }

  static public class PingSource {

    final public PingSource setAction(IF0<Boolean> action) {
      return action(action);
    }

    public PingSource action(IF0<Boolean> action) {
      this.action = action;
      return this;
    }

    final public IF0<Boolean> getAction() {
      return action();
    }

    public IF0<Boolean> action() {
      return action;
    }

    volatile public IF0<Boolean> action;

    public String text;

    public ThreadPool threadPool;

    public PingSource() {
    }

    public PingSource(ThreadPool threadPool) {
      this.threadPool = threadPool;
    }

    public PingSource(ThreadPool threadPool, String text) {
      this.text = text;
      this.threadPool = threadPool;
    }

    final public boolean get() {
      var a = action;
      return a != null && a.get();
    }

    final public void ping() {
      var a = action;
      if (a != null)
        a.get();
    }

    public void cancel() {
      action = new Cancelled();
    }

    public class Cancelled implements IF0<Boolean> {

      public Boolean get() {
        throw new PingSourceCancelledException(PingSource.this);
      }
    }

    public class Encapsulated implements Runnable, IFieldsToList {

      public Runnable r;

      public Encapsulated() {
      }

      public Encapsulated(Runnable r) {
        this.r = r;
      }

      public Object[] _fieldsToList() {
        return new Object[] { r };
      }

      public void run() {
        try {
          try {
            pingSource_tl().set(PingSource.this);
            ping();
            r.run();
          } finally {
            pingSource_tl().set(null);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return PingSource.this + ": " + r;
      }
    }

    public void dO(Runnable r) {
      if (r == null)
        return;
      threadPool.acquireThreadOrQueue(new Encapsulated(r));
    }

    public String toString() {
      String t = text;
      return nempty(t) ? t : super.toString();
    }

    public ISleeper_v2 sleeper() {
      return threadPool.sleeper();
    }
  }

  static public class CountingOutputStream extends FilterOutputStream {

    public long counter;

    public CountingOutputStream(OutputStream out) {
      super(out);
    }

    @Override
    public void write(int b) throws IOException {
      ++counter;
      out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
      counter += b.length;
      out.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
      if (len == 0)
        return;
      counter += len;
      out.write(b, off, len);
    }

    public long getFilePointer() {
      return counter;
    }
  }

  static public class SimpleLiveValue<A> extends LiveValue<A> {

    public Class<A> type;

    volatile public A value;

    transient public List onChange = synchroList();

    public SimpleLiveValue(Class<A> type) {
      this.type = type;
    }

    public SimpleLiveValue(Class<A> type, A value) {
      this.value = value;
      this.type = type;
    }

    public Class<A> getType() {
      return type;
    }

    public A get() {
      return value;
    }

    public void onChange(Runnable l) {
      onChange.add(l);
    }

    public void onChangeAndNow(Runnable l) {
      onChange(l);
      callF(l);
    }

    public void removeOnChangeListener(Runnable l) {
      onChange.remove(l);
    }

    public void fireChanged() {
      pcallFAll(onChange);
    }

    public void set(A a) {
      if (neq(value, a)) {
        value = a;
        fireChanged();
      }
    }
  }

  public interface Matrix<A> {

    public int getWidth();

    public int getHeight();

    public A get(int x, int y);

    public void set(int x, int y, A a);

    default public Pt size() {
      return pt(getWidth(), getHeight());
    }

    default public int nCells() {
      return getWidth() * getHeight();
    }

    default public List<A> getLine(int y) {
      return new RandomAccessAbstractList<A>() {

        public int size() {
          return getWidth();
        }

        public A get(int x) {
          return Matrix.this.get(x, y);
        }

        public A set(int x, A val) {
          A old = Matrix.this.get(x, y);
          Matrix.this.set(x, y, val);
          return old;
        }
      };
    }
  }

  static public class AppendableChain<A> extends MinimalChain<A> implements Iterable<A> {

    public MinimalChain<A> last;

    public int size;

    public AppendableChain() {
    }

    public AppendableChain(A element) {
      this.element = element;
      size = 1;
      last = this;
    }

    public AppendableChain(A element, AppendableChain<A> next) {
      this.next = next;
      this.element = element;
      if (next == null)
        return;
      MinimalChain<A> b = new MinimalChain();
      b.element = next.element;
      b.next = next.next;
      this.next = b;
      last = next.last;
      size = next.size + 1;
    }

    public String toString() {
      return str(toList());
    }

    public boolean add(A a) {
      MinimalChain newLast = new MinimalChain(a);
      last.next = newLast;
      last = newLast;
      ++size;
      return true;
    }

    public AppendableChain<A> popFirst() {
      if (next == null)
        return null;
      element = next.element;
      if (last == next)
        last = this;
      next = next.next;
      --size;
      return this;
    }

    public ArrayList<A> toList() {
      ArrayList<A> l = emptyList(size);
      MinimalChain<A> c = this;
      while (c != null) {
        l.add(c.element);
        c = c.next;
      }
      return l;
    }

    public class ACIt extends IterableIterator<A> {

      public MinimalChain<A> c = AppendableChain.this;

      public boolean hasNext() {
        return c != null;
      }

      public A next() {
        var a = c.element;
        c = c.next;
        return a;
      }
    }

    public IterableIterator<A> iterator() {
      return new ACIt();
    }
  }

  static public class PrecisePolygon extends Path2D.Double {

    public PrecisePolygon(List<DoublePt> points) {
      var p = first(points);
      moveTo(p.x, p.y);
      for (int i = 1; i < l(points); i++) {
        p = points.get(i);
        lineTo(p.x, p.y);
      }
      closePath();
    }
  }

  static public class CompactLinkedHashSet<A> extends AbstractSet<A> {

    public UnsynchronizedCompactHashSet<Entry<A>> entries = new UnsynchronizedCompactHashSet();

    public Entry<A> head, tail;

    static public class Entry<A> {

      public A value;

      public Entry<A> prev, next;

      public int hashCode() {
        return _hashCode(value);
      }

      public boolean equals(Object o) {
        return o == this || eq(value, o);
      }
    }

    public boolean add(A a) {
      if (entries.contains(a))
        return false;
      Entry<A> n = new Entry();
      n.value = a;
      n.prev = tail;
      if (tail != null)
        tail.next = n;
      tail = n;
      if (head == null)
        head = n;
      entries.add(n);
      return true;
    }

    public boolean remove(Object a) {
      return remove(entries.find(a));
    }

    public boolean remove(Entry<A> node) {
      if (node == null)
        return false;
      if (node.next != null)
        node.next.prev = node.prev;
      else
        tail = node.prev;
      if (node.prev != null)
        node.prev.next = node.next;
      else
        head = node.next;
      entries.remove(node);
      return true;
    }

    public int size() {
      return entries.size();
    }

    public IterableIterator<A> iterator() {
      return new IterableIterator<A>() {

        public Entry<A> entry = head, prev = null;

        public boolean hasNext() {
          return entry != null;
        }

        public A next() {
          A a = entry.value;
          prev = entry;
          entry = entry.next;
          return a;
        }

        public void remove() {
          if (prev == null)
            throw new IllegalStateException();
          CompactLinkedHashSet.this.remove(prev);
          prev = null;
        }
      };
    }

    public void clear() {
      entries.clear();
      head = tail = null;
    }

    public boolean contains(Object a) {
      return entries.contains(a);
    }

    public A find(Object o) {
      Entry<A> e = entries.find(o);
      return e == null ? null : e.value;
    }

    public A prevElement(A a) {
      Entry<A> e = entries.find(a);
      if (e == null || e.prev == null)
        return null;
      return e.prev.value;
    }

    public A nextElement(A a) {
      Entry<A> e = entries.find(a);
      if (e == null || e.next == null)
        return null;
      return e.next.value;
    }

    public A first() {
      return head == null ? null : head.value;
    }

    public A last() {
      return tail == null ? null : tail.value;
    }

    public boolean removeIfSame(Object o) {
      A value = find(o);
      if (value == o) {
        remove(value);
        return true;
      }
      return false;
    }
  }

  static public class Best<A> {

    public A best;

    public double score;

    public boolean verboseNewBest, replaceIfSameScore;

    transient public Object onChange;

    transient public Object stringifier;

    synchronized public boolean isNewBest(double score) {
      return best == null || !isNaN(score) && (replaceIfSameScore ? score >= this.score : score > this.score);
    }

    synchronized public double bestScore() {
      return best == null ? minusInfinity() : score;
    }

    public double score() {
      return bestScore();
    }

    public double getScore() {
      return bestScore();
    }

    synchronized public float floatScoreOr(float defaultValue) {
      return best == null ? defaultValue : (float) score;
    }

    public boolean put(Pair<? extends A, Double> p) {
      return p != null && put(p.a, p.b);
    }

    public boolean put(Best<? extends A> b) {
      return b != null && put(b.get(), b.score);
    }

    public boolean put(A a, double score) {
      ping();
      boolean change = false;
      if (a != null)
        synchronized (this) {
          if (isNewBest(score)) {
            best = a;
            this.score = score;
            change = true;
          }
        }
      if (change) {
        if (verboseNewBest)
          print("New best! " + this);
        pcallF(onChange);
      }
      return change;
    }

    synchronized public A get() {
      return best;
    }

    synchronized public boolean has() {
      return best != null;
    }

    synchronized public Pair<A, Double> pair() {
      return utils.pair(best, bestScore());
    }

    synchronized public Scored<A> scored() {
      return best == null ? null : new Scored<A>(best, bestScore());
    }

    synchronized public A getIfScoreAbove(double x) {
      return score() >= x ? best : null;
    }

    public String toString() {
      return "Score " + formatDouble_significant2(score, 4) + ": " + callStringifier(stringifier, best);
    }

    public boolean putAndPrintIfNewBest(A a, double score) {
      if (!put(a, score))
        return false;
      {
        print(this);
        return true;
      }
    }

    synchronized public void clear() {
      best = null;
      score = 0;
    }
  }

  static public class FixedRateTimer extends java.util.Timer implements AutoCloseable {

    public FixedRateTimer() {
      this(false);
    }

    public FixedRateTimer(boolean daemon) {
      this(defaultTimerName(), daemon);
    }

    public FixedRateTimer(String name) {
      this(name, false);
    }

    public FixedRateTimer(String name, boolean daemon) {
      super(name, daemon);
      _registerTimer(this);
    }

    public List<Entry> entries = synchroList();

    static public class Entry implements IFieldsToList {

      public TimerTask task;

      public long firstTime;

      public long period;

      public Entry() {
      }

      public Entry(TimerTask task, long firstTime, long period) {
        this.period = period;
        this.firstTime = firstTime;
        this.task = task;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + task + ", " + firstTime + ", " + period + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { task, firstTime, period };
      }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
      entries.add(new Entry(task, now() + delay, period));
      super.scheduleAtFixedRate(task, delay, period);
    }

    public void cancel() {
      entries.clear();
      super.cancel();
    }

    public int purge() {
      entries.clear();
      return super.purge();
    }

    public FixedRateTimer changeRate(int newPeriod) {
      Object r = ((SmartTimerTask) first(entries).task).r;
      cancel();
      return doEvery(newPeriod, r);
    }

    public void close() {
      try {
        cancel();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class Fail extends RuntimeException implements IFieldsToList {

    public Object[] objects;

    public Fail() {
    }

    public Fail(Object... objects) {
      this.objects = objects;
    }

    public Object[] _fieldsToList() {
      return new Object[] { objects };
    }

    public Fail(Throwable cause, Object... objects) {
      super(cause);
      this.objects = objects;
    }

    public String toString() {
      return joinNemptiesWithColon("Fail", commaCombine(getCause(), objects));
    }
  }

  final static public class Rect implements IFieldsToList {

    static final public String _fieldOrder = "x y w h";

    public int x;

    public int y;

    public int w;

    public int h;

    public Rect() {
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Rect))
        return false;
      Rect __1 = (Rect) o;
      return x == __1.x && y == __1.y && w == __1.w && h == __1.h;
    }

    public int hashCode() {
      int h = 2543108;
      h = boostHashCombine(h, _hashCode(x));
      h = boostHashCombine(h, _hashCode(y));
      h = boostHashCombine(h, _hashCode(w));
      h = boostHashCombine(h, _hashCode(h));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { x, y, w, h };
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(Pt p, int w, int h) {
      this.h = h;
      this.w = w;
      x = p.x;
      y = p.y;
    }

    public Rect(Rect r) {
      x = r.x;
      y = r.y;
      w = r.w;
      h = r.h;
    }

    public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    public int x1() {
      return x;
    }

    public int y1() {
      return y;
    }

    public int x2() {
      return x + w;
    }

    public int y2() {
      return y + h;
    }

    public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    public boolean empty() {
      return w <= 0 || h <= 0;
    }

    public int getWidth() {
      return w;
    }

    public int getHeight() {
      return h;
    }
  }

  static public class GridCodec1 implements JavaCodec<BufferedImage>, IFieldsToList {

    public BufferedImage stage0_image;

    public GridCodec1() {
    }

    public GridCodec1(BufferedImage stage0_image) {
      this.stage0_image = stage0_image;
    }

    public Object[] _fieldsToList() {
      return new Object[] { stage0_image };
    }

    final public GridCodec1 setRows(int rows) {
      return rows(rows);
    }

    public GridCodec1 rows(int rows) {
      this.rows = rows;
      return this;
    }

    final public int getRows() {
      return rows();
    }

    public int rows() {
      return rows;
    }

    public int rows = 20;

    static public GridCodec1 demo() {
      return new GridCodec1(defaultScreenshot());
    }

    public Matrix<Integer> stage1_matrix;

    public long dataBytes, dataChars;

    public Matrix<Matrix<Integer>> stage2_grid;

    public JE_CompressEachElementIndividually<List<Integer>> strat;

    public JECompressionSearch<List<List<Integer>>> search;

    public JECompressionSearch<List<List<Integer>>> forward() {
      assertNotNull(stage0_image);
      var m = stage1_matrix = imageToMatrix(stage0_image);
      dataBytes = m.nCells() * 4 + 2;
      dataChars = dataBytes * 2 + l("lInt(\"\")");
      print("Matrix ~ " + shorten_str(60, m));
      print("Trivial comp ~ " + (m.nCells() * 8));
      stage2_grid = matrixToMNGrid_rows(m, rows);
      List<List<Integer>> stage3_cells = matrixOfMatricesToListOfLists(stage2_grid);
      search = jeCompressionSearch(stage3_cells, dataChars);
      strat = new JE_CompressEachElementIndividually<List<Integer>>().elementCompressionStrategy(() -> new JE_RepElement()).onCompressionFail(ints -> javaObjectToIJavaExpr(ints));
      search.addStrategy(strat);
      return search;
    }

    public String stats() {
      return strat == null ? null : strat.stats();
    }

    public JECompressionSearch<List<List<Integer>>>.Submission winner() {
      return search == null ? null : search.bestSubmission();
    }

    public ICachedJavaXExpr<List<List<Integer>>> winnerCodeWithoutPostProcessing() {
      return rCallF(winner(), __1 -> __1 == null ? null : __1.decompressor());
    }

    public ICachedJavaXExpr<BufferedImage> winnerCode() {
      var innerWinner = winnerCodeWithoutPostProcessing();
      if (innerWinner == null)
        return null;
      return addPostProcessing(innerWinner);
    }

    public List<Integer> cellWidths() {
      return lambdaMapMethod(__100 -> __100.getWidth(), rowToList(stage2_grid, 0));
    }

    public List<Integer> cellHeights() {
      return lambdaMapMethod(__101 -> __101.getHeight(), colToList(stage2_grid, 0));
    }

    public ICachedJavaXExpr<BufferedImage> addPostProcessing(ICachedJavaXExpr<List<List<Integer>>> inner) {
      List<Integer> cellWidths = cellWidths();
      List<Integer> cellHeights = cellHeights();
      return new AbstractJavaXExpr<BufferedImage>() {

        public FunctionCall javaConstruct() {
          return functionCall("gridLOLToImage", toJava(cellWidths), toJava(cellHeights), inner);
        }

        public String toString() {
          return str(javaConstruct());
        }

        public BufferedImage quickEval() {
          return gridLOLToImage(cellWidths, cellHeights, inner.quickEval());
        }
      };
    }

    public BufferedImage renderCellsLinearly() {
      return mergeBufferedImagesHorizontally(map(__87 -> intMatrixToImage(__87), matrixToList(stage2_grid)));
    }

    public void drawOverlay(ImageSurface is, Graphics2D g) {
      try {
        double zoom = is.getZoomX();
        List<Integer> cellWidths = cellWidths();
        List<Integer> cellHeights = cellHeights();
        List<Integer> cellX1s = partialSums_firstIs0(cellWidths);
        List<Integer> cellY1s = partialSums_firstIs0(cellHeights);
        for (int y = 0; y < l(cellHeights); y++) for (int x = 0; x < l(cellWidths); x++) if (strat.isElementCompressed(y * l(cellWidths) + x)) {
          Rect r = rectFromPoints(cellX1s.get(x), cellY1s.get(y), cellX1s.get(x + 1), cellY1s.get(y + 1));
          r = scaleRect(r, zoom);
          fillRect(g, r, colorWithAlpha(Color.GREEN, .5));
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public class Pt implements Comparable<Pt> {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return o instanceof Pt && x == ((Pt) o).x && y == ((Pt) o).y;
    }

    public int hashCode() {
      return boostHashCombine(x, y);
    }

    public int compareTo(Pt p) {
      if (y != p.y)
        return cmp(y, p.y);
      return cmp(x, p.x);
    }

    public String toString() {
      return x + ", " + y;
    }
  }

  static public class LeftAlignedLine extends JPanel {

    public LeftAlignedLine(Component... components) {
      setLayout(LetterLayout.leftAlignedRow());
      for (Component component : components) add(component);
    }

    public void add(String text) {
      add(new JLabel(text));
    }
  }

  static abstract public class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  static public interface MakesBufferedImage extends WidthAndHeight {

    public BufferedImage getBufferedImage();

    public default void drawAt(Graphics2D g, int x, int y) {
      g.drawImage(getBufferedImage(), x, y, null);
    }
  }

  static public class SynchronizedArrayList<A> extends SynchronizedArrayList_Base<A> implements RandomAccess, Cloneable {

    static final public int DEFAULT_CAPACITY = 10;

    static final public Object[] EMPTY_ELEMENTDATA = {};

    static final public Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = {};

    transient public Object[] elementData;

    public int size;

    public SynchronizedArrayList(int initialCapacity) {
      if (initialCapacity > 0) {
        this.elementData = new Object[initialCapacity];
      } else if (initialCapacity == 0) {
        this.elementData = EMPTY_ELEMENTDATA;
      } else {
        throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
      }
    }

    public SynchronizedArrayList() {
      this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public SynchronizedArrayList(Collection<? extends A> c) {
      elementData = c.toArray();
      if ((size = elementData.length) != 0) {
        if (elementData.getClass() != Object[].class)
          elementData = Arrays.copyOf(elementData, size, Object[].class);
      } else {
        this.elementData = EMPTY_ELEMENTDATA;
      }
    }

    public synchronized void trimToSize() {
      modCount++;
      if (size < elementData.length) {
        elementData = (size == 0) ? EMPTY_ELEMENTDATA : Arrays.copyOf(elementData, size);
      }
    }

    public synchronized void ensureCapacity(int minCapacity) {
      int minExpand = (elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA) ? 0 : DEFAULT_CAPACITY;
      if (minCapacity > minExpand) {
        ensureExplicitCapacity(minCapacity);
      }
    }

    final public void ensureCapacityInternal(int minCapacity) {
      if (elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
        minCapacity = Math.max(DEFAULT_CAPACITY, minCapacity);
      }
      ensureExplicitCapacity(minCapacity);
    }

    final public void ensureExplicitCapacity(int minCapacity) {
      modCount++;
      if (minCapacity - elementData.length > 0)
        grow(minCapacity);
    }

    static final public int MAX_ARRAY_SIZE = Integer.MAX_VALUE - 8;

    final public void grow(int minCapacity) {
      int oldCapacity = elementData.length;
      int newCapacity = oldCapacity + (oldCapacity >> 1);
      if (newCapacity - minCapacity < 0)
        newCapacity = minCapacity;
      if (newCapacity - MAX_ARRAY_SIZE > 0)
        newCapacity = hugeCapacity(minCapacity);
      elementData = Arrays.copyOf(elementData, newCapacity);
    }

    static public int hugeCapacity(int minCapacity) {
      if (minCapacity < 0)
        throw new OutOfMemoryError();
      return (minCapacity > MAX_ARRAY_SIZE) ? Integer.MAX_VALUE : MAX_ARRAY_SIZE;
    }

    public synchronized int size() {
      return size;
    }

    public synchronized boolean isEmpty() {
      return size == 0;
    }

    public boolean contains(Object o) {
      return indexOf(o) >= 0;
    }

    public synchronized int indexOf(Object o) {
      if (o == null) {
        for (int i = 0; i < size; i++) if (elementData[i] == null)
          return i;
      } else {
        for (int i = 0; i < size; i++) if (o.equals(elementData[i]))
          return i;
      }
      return -1;
    }

    public synchronized int lastIndexOf(Object o) {
      if (o == null) {
        for (int i = size - 1; i >= 0; i--) if (elementData[i] == null)
          return i;
      } else {
        for (int i = size - 1; i >= 0; i--) if (o.equals(elementData[i]))
          return i;
      }
      return -1;
    }

    public synchronized Object clone() {
      return new SynchronizedArrayList(this);
    }

    public synchronized Object[] toArray() {
      return Arrays.copyOf(elementData, size);
    }

    @SuppressWarnings("unchecked")
    public synchronized <T> T[] toArray(T[] a) {
      if (a.length < size)
        return (T[]) Arrays.copyOf(elementData, size, a.getClass());
      System.arraycopy(elementData, 0, a, 0, size);
      if (a.length > size)
        a[size] = null;
      return a;
    }

    @SuppressWarnings("unchecked")
    public A elementData(int index) {
      return (A) elementData[index];
    }

    public synchronized A get(int index) {
      rangeCheck(index);
      return elementData(index);
    }

    public synchronized A set(int index, A element) {
      rangeCheck(index);
      A oldValue = elementData(index);
      elementData[index] = element;
      return oldValue;
    }

    public synchronized boolean add(A e) {
      ensureCapacityInternal(size + 1);
      elementData[size++] = e;
      return true;
    }

    public synchronized void add(int index, A element) {
      rangeCheckForAdd(index);
      ensureCapacityInternal(size + 1);
      System.arraycopy(elementData, index, elementData, index + 1, size - index);
      elementData[index] = element;
      size++;
    }

    public synchronized A remove(int index) {
      rangeCheck(index);
      modCount++;
      A oldValue = elementData(index);
      int numMoved = size - index - 1;
      if (numMoved > 0)
        System.arraycopy(elementData, index + 1, elementData, index, numMoved);
      elementData[--size] = null;
      return oldValue;
    }

    public synchronized boolean remove(Object o) {
      if (o == null) {
        for (int index = 0; index < size; index++) if (elementData[index] == null) {
          fastRemove(index);
          return true;
        }
      } else {
        for (int index = 0; index < size; index++) if (o.equals(elementData[index])) {
          fastRemove(index);
          return true;
        }
      }
      return false;
    }

    final public void fastRemove(int index) {
      modCount++;
      int numMoved = size - index - 1;
      if (numMoved > 0)
        System.arraycopy(elementData, index + 1, elementData, index, numMoved);
      elementData[--size] = null;
    }

    public synchronized void clear() {
      modCount++;
      for (int i = 0; i < size; i++) elementData[i] = null;
      size = 0;
    }

    public synchronized boolean addAll(Collection<? extends A> c) {
      Object[] a = c.toArray();
      int numNew = a.length;
      ensureCapacityInternal(size + numNew);
      System.arraycopy(a, 0, elementData, size, numNew);
      size += numNew;
      return numNew != 0;
    }

    public synchronized boolean addAll(int index, Collection<? extends A> c) {
      rangeCheckForAdd(index);
      Object[] a = c.toArray();
      int numNew = a.length;
      ensureCapacityInternal(size + numNew);
      int numMoved = size - index;
      if (numMoved > 0)
        System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
      System.arraycopy(a, 0, elementData, index, numNew);
      size += numNew;
      return numNew != 0;
    }

    public synchronized void removeRange(int fromIndex, int toIndex) {
      modCount++;
      int numMoved = size - toIndex;
      System.arraycopy(elementData, toIndex, elementData, fromIndex, numMoved);
      int newSize = size - (toIndex - fromIndex);
      for (int i = newSize; i < size; i++) {
        elementData[i] = null;
      }
      size = newSize;
    }

    final public void rangeCheck(int index) {
      if (index >= size)
        throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
    }

    final public void rangeCheckForAdd(int index) {
      if (index > size || index < 0)
        throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
    }

    final public String outOfBoundsMsg(int index) {
      return "Index: " + index + ", Size: " + size;
    }

    public synchronized boolean removeAll(Collection<?> c) {
      Objects.requireNonNull(c);
      return batchRemove(c, false);
    }

    public synchronized boolean retainAll(Collection<?> c) {
      Objects.requireNonNull(c);
      return batchRemove(c, true);
    }

    final public boolean batchRemove(Collection<?> c, boolean complement) {
      final Object[] elementData = this.elementData;
      int r = 0, w = 0;
      boolean modified = false;
      try {
        for (; r < size; r++) if (c.contains(elementData[r]) == complement)
          elementData[w++] = elementData[r];
      } finally {
        if (r != size) {
          System.arraycopy(elementData, r, elementData, w, size - r);
          w += size - r;
        }
        if (w != size) {
          for (int i = w; i < size; i++) elementData[i] = null;
          modCount += size - w;
          size = w;
          modified = true;
        }
      }
      return modified;
    }

    final public void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
      int expectedModCount = modCount;
      s.defaultWriteObject();
      s.writeInt(size);
      for (int i = 0; i < size; i++) {
        s.writeObject(elementData[i]);
      }
      if (modCount != expectedModCount) {
        throw new ConcurrentModificationException();
      }
    }

    final public void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
      elementData = EMPTY_ELEMENTDATA;
      s.defaultReadObject();
      s.readInt();
      if (size > 0) {
        ensureCapacityInternal(size);
        Object[] a = elementData;
        for (int i = 0; i < size; i++) {
          a[i] = s.readObject();
        }
      }
    }

    public synchronized ListIterator<A> listIterator(int index) {
      if (index < 0 || index > size)
        throw new IndexOutOfBoundsException("Index: " + index);
      return new ListItr(index);
    }

    public ListIterator<A> listIterator() {
      return new ListItr(0);
    }

    public Iterator<A> iterator() {
      return concurrentlyIterateList(this);
    }

  