//FILENAME: loadableUtils/utils.java
package loadableUtils;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import java.awt.datatransfer.StringSelection;
import java.text.*;
import java.text.SimpleDateFormat;
import javax.swing.undo.UndoManager;
import org.eclipse.collections.impl.map.mutable.primitive.*;
import org.eclipse.collections.impl.set.mutable.primitive.*;
import org.eclipse.collections.api.tuple.primitive.*;
import org.eclipse.collections.api.iterator.*;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.TimeZone;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.awt.geom.*;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.swing.border.*;
import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;
import javax.swing.Timer;
import java.awt.datatransfer.*;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.*;
import static x30_pkg.x30_util.VF1;
import x30_pkg.x30_util.DynamicObject;

public class utils {

  static public File nohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs);
  }

  static public File nohupJavax(String javaxargs, String vmArgs) {
    return directNohupJavax(javaxargs, vmArgs);
  }

  static public interface DynamicMethods {

    abstract public Object _dynCall(String methodName, Object[] args);
  }

  static public class BetterLabel extends JLabel {

    public boolean autoToolTip = true;

    public BetterLabel() {
      final WeakReference<BetterLabel> me = new WeakReference<>(this);
      componentPopupMenu(this, BetterLabel_menuItems(me));
    }

    public BetterLabel(String text) {
      this();
      this.setText(text);
    }

    public void setText(String text) {
      super.setText(text);
      if (autoToolTip)
        if (!swic(text, "<html>"))
          setToolTipText(nullIfEmpty(text));
    }
  }

  static public VF1<JPopupMenu> BetterLabel_menuItems(final WeakReference<BetterLabel> me) {
    return new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboard(me.get().getText());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboard(me.get().getText());";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, \"Copy text to clipboard\", r {\r\n      copyTextToClipboard(me...";
      }
    };
  }

  static public class SingleComponentPanel extends JPanel {

    public SingleComponentPanel() {
      super(new BorderLayout());
    }

    public SingleComponentPanel(Component component) {
      this();
      if (component != null)
        setComponent(component);
    }

    final public void set(Component component) {
      setComponent(component);
    }

    public void setComponent(Component component) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              removeAll();
              if (component != null)
                add(BorderLayout.CENTER, wrap(component));
              _revalidate(SingleComponentPanel.this);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "removeAll();\r\n      if (component != null)\r\n        add(BorderLayout.CENTER, ...";
          }
        });
      }
    }

    public void setComponentAndRevalidateParent(Component component) {
      setComponent(component);
      _revalidate(_getParent(this));
    }

    public void noComponent() {
      setComponent(null);
    }

    public Component getComponent() {
      return getComponentCount() == 0 ? null : getComponent(0);
    }
  }

  static public class Snippet {

    public String id, title, md5, type, text;

    public boolean isPublic = false;

    public Snippet() {
    }

    public Snippet(String id, String title) {
      this.title = title;
      this.id = id;
    }

    public Snippet(String id, String title, String md5) {
      this.md5 = md5;
      this.title = title;
      this.id = id;
    }

    public String toString() {
      return id + " - " + title;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }
  }

  static final public class BWImage implements MakesBufferedImage, IBWImage {

    public int width, height;

    public byte[] pixels;

    public float borderColor = 0.0f;

    public BWImage() {
    }

    public BWImage(int width, int height) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
    }

    public BWImage(int width, int height, float brightness) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
      fillArrayUnlessZero(pixels, _toByte(brightness));
    }

    public BWImage(int width, int height, float[] pixels) {
      this.pixels = new byte[pixels.length];
      this.height = height;
      this.width = width;
      for (int i = 0; i < pixels.length; i++) this.pixels[i] = _toByte(pixels[i]);
    }

    public BWImage(int width, int height, byte[] pixels) {
      this.height = height;
      this.width = width;
      this.pixels = pixels;
    }

    public BWImage(BWImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) pixels[y * width + x] = image.getByte(x, y);
    }

    public BWImage(RGBImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[height * width];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        pixels[y * width + x] = BWImage._toByte(rgb.getBrightness());
      }
    }

    public BWImage(BufferedImage image) {
      try {
        width = image.getWidth();
        height = image.getHeight();
        int[] pixels = new int[width * height];
        byte[] bytePixels = this.pixels = new byte[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        if (!pixelGrabber.grabPixels())
          throw fail("Could not grab pixels");
        int n = width * height;
        for (int i = 0; i < n; i++) {
          int packed = pixels[i];
          int r = ((packed >> 16) & 0xFF);
          int g = ((packed >> 8) & 0xFF);
          int b = (packed & 0xFF);
          bytePixels[i] = (byte) ((r + g + b + 1) / 3);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public byte pixelToByte(int packed) {
      float r = ((packed >> 16) & 0xFF) / 255f;
      float g = ((packed >> 8) & 0xFF) / 255f;
      float b = (packed & 0xFF) / 255f;
      return (byte) ((r + g + b) / 3.0f * 255f);
    }

    public byte getByte(int x, int y) {
      return inRange(x, y) ? getByte_noRangeCheck(x, y) : _toByte(borderColor);
    }

    public int getInt(int x, int y) {
      return ubyteToInt(getByte(x, y));
    }

    public double averageBrightness() {
      double sum = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) sum += getPixel(x, y);
      return (sum / (double) (height * width));
    }

    public float minimumBrightness() {
      float min = 1;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) min = Math.min(min, getPixel(x, y));
      return min;
    }

    public float maximumBrightness() {
      float max = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) max = Math.max(max, getPixel(x, y));
      return max;
    }

    public float getPixel(int x, int y) {
      return inRange(x, y) ? _toFloat(getByte(x, y)) : borderColor;
    }

    public float getFloatPixel(int x, int y) {
      return getPixel(x, y);
    }

    public float getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    static public byte _toByte(float pixel) {
      return (byte) (pixel * 255f);
    }

    static public float _toFloat(byte pixel) {
      return (((int) pixel) & 255) / 255f;
    }

    final public boolean inRange(int x, int y) {
      return x >= 0 && x < width && y >= 0 && y < height;
    }

    public int getWidth() {
      return width;
    }

    public int w() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int h() {
      return height;
    }

    public RGBImage toRGB() {
      int[] rgbs = new int[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = getByte(x, y) & 0xFF;
        rgbs[y * width + x] = 0xFF000000 | b * 0x010101;
      }
      return new RGBImage(width, height, rgbs);
    }

    public RGBImage toRGB_slow() {
      RGB[] rgbs = new RGB[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y * width + x] = new RGB(p, p, p);
      }
      return new RGBImage(width, height, rgbs);
    }

    public BWImage clip(int x, int y, int w, int h) {
      return clip(new Rectangle(x, y, w, h));
    }

    final public Rectangle fixClipRect(Rectangle r) {
      return r.intersection(new Rectangle(0, 0, width, height));
    }

    public BWImage clip(Rect r) {
      return clip(r.getRectangle());
    }

    public BWImage clip(Rectangle r) {
      r = fixClipRect(r);
      byte[] newPixels = new byte[r.height * r.width];
      for (int y = 0; y < r.height; y++) for (int x = 0; x < r.width; x++) newPixels[y * r.width + x] = getByte(r.x + x, r.y + y);
      return new BWImage(r.width, r.height, newPixels);
    }

    public void setPixel(int x, int y, float brightness) {
      setByte(x, y, _toByte(fixPixel(brightness)));
    }

    public void setInt(int x, int y, int i) {
      setByte(x, y, (byte) limitToUByte(i));
    }

    public void setByte(int x, int y, byte b) {
      if (x >= 0 && x < width && y >= 0 && y < height)
        pixels[y * width + x] = b;
    }

    public byte getByte_noRangeCheck(int x, int y) {
      return pixels[y * width + x];
    }

    public void setByte(int x, int y, int brightness) {
      setByte(x, y, (byte) brightness);
    }

    final public float fixPixel(float pixel) {
      return Math.max(0, Math.min(1, pixel));
    }

    public float getBorderColor() {
      return borderColor;
    }

    public void setBorderColor(float borderColor) {
      this.borderColor = borderColor;
    }

    public boolean anyPixelBrighterThan(double threshold) {
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) if (getPixel(x, y) > threshold)
        return true;
      return false;
    }

    public BufferedImage getBufferedImage() {
      BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = ((int) getByte(x, y) & 0xFF);
        bufferedImage.setRGB(x, y, b * 0x010101);
      }
      return bufferedImage;
    }

    public byte[] getBytes() {
      return pixels;
    }
  }

  static public class Cache<A> {

    public Object maker;

    public A value;

    public long loaded;

    static public boolean debug = false;

    public long changeCount;

    public Lock lock = lock();

    public Cache() {
    }

    public Cache(Object maker) {
      this.maker = maker;
    }

    public Cache(IF0<A> maker) {
      this.maker = maker;
    }

    public A get() {
      if (hasLock(lock))
        return value;
      Lock __16 = lock;
      lock(__16);
      try {
        if (loaded == 0) {
          value = make();
          changeCount++;
          loaded = sysNow();
        }
        return value;
      } finally {
        unlock(__16);
      }
    }

    public void clear() {
      Lock __17 = lock;
      lock(__17);
      try {
        if (debug && loaded != 0)
          print("Clearing cache");
        value = null;
        changeCount++;
        loaded = 0;
      } finally {
        unlock(__17);
      }
    }

    public void clear(double seconds) {
      Lock __18 = lock;
      lock(__18);
      try {
        if (seconds != 0 && loaded != 0 && sysNow() >= loaded + seconds * 1000)
          clear();
      } finally {
        unlock(__18);
      }
    }

    public void set(A a) {
      Lock __19 = lock;
      lock(__19);
      try {
        value = a;
        ++changeCount;
        loaded = sysNow();
      } finally {
        unlock(__19);
      }
    }

    public A make() {
      return (A) callF(maker);
    }
  }

  static abstract public class DynModule extends DynamicObject {

    public String name, toolTip;

    public PersistableThrowable _error;

    public Map<String, Collection<String>> mechLists;

    public Map<String, Boolean> _persistenceInfo;

    transient public Object _host;

    transient public Map<Object, Object> timers = newWeakHashMap();

    transient public Set<AutoCloseable> _resources = synchroHashSet();

    transient public Lock lock;

    transient public boolean persistOnChangedField = true;

    transient public int changeCount;

    transient public Object changeCountSync = new Object();

    transient public List onChange;

    transient public List onTransientChange;

    transient public boolean verboseTimers = false;

    transient public ReliableSingleThread rstUpdate;

    transient public Set<String> componentFieldsToKeep;

    transient public Map<String, Object> transientGeneralMap = synchroHashMap();

    transient public Q q;

    transient public List onFieldChange;

    transient public boolean _hasPreviousBounds = false;

    transient public StringBuffer _printLog = new StringBuffer();

    transient public boolean deleted = false;

    public DynModule() {
      if (useErrorHandling())
        dm_initErrorHandling();
      setMainDesktopPane((JDesktopPane) getCreatorOpt("desktop"));
    }

    public boolean useErrorHandling() {
      return true;
    }

    public boolean isVisible() {
      return isTrue(getOpt(_host, "visible"));
    }

    public String moduleName() {
      return name;
    }

    public void setModuleName(String name) {
      String oldName = this.name;
      if (!eq(name, oldName)) {
        setField("name", name);
        possiblyInternalFrameTitle(vis(), name);
        vmBus_send("moduleNameChange", this, oldName, name);
      }
    }

    public void setModuleToolTip(String toolTip) {
      this.toolTip = toolTip;
    }

    public JComponent vis() {
      return (JComponent) getOpt(_host, "vis");
    }

    public <A extends AutoCloseable> A ownResource(A a) {
      if (a != null)
        _resources.add(a);
      return a;
    }

    public <A> A ownTimer(A timer) {
      if (timer instanceof AutoCloseable)
        ownResource((AutoCloseable) timer);
      ownTimer(timer, "cancelTimerOrInterruptThread");
      return timer;
    }

    public void ownTimer(Object timer, Object closerHelper) {
      timers.put(timer, closerHelper);
    }

    public void singleTimer(java.util.Timer timer) {
      stopAllTimers();
      ownTimer(timer);
    }

    public void stopAllTimers() {
      for (AutoCloseable resource : getAndClearList(_resources)) {
        if (verboseTimers)
          print("Releasing resource: " + resource);
        try {
          resource.close();
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      for (Map.Entry<? extends Object, ? extends Object> __22 : _entrySet(getAndClearMap(timers))) {
        Object timer = __22.getKey();
        Object closerHelper = __22.getValue();
        if (verboseTimers)
          print("Stopping timer: " + closerHelper + " / " + timer);
        pcallFInRealOrMyMC(this, closerHelper, timer);
      }
    }

    public boolean isDeleted() {
      return deleted;
    }

    public boolean deleted() {
      return deleted;
    }

    public void cleanMeUp_dynModule() {
      deleted = true;
      stopAllTimers();
    }

    public void persistMe() {
      synchronized (changeCountSync) {
        ++changeCount;
      }
      pcallFAll(onChange);
      callOpt(_host, "_change");
      updateMe();
    }

    public void fireChangeWithoutPersisting() {
      pcallFAll(onChange);
    }

    public void fireTransientChange() {
      pcallFAll(onTransientChange);
    }

    public void _change() {
      persistMe();
    }

    public void change() {
      persistMe();
    }

    public void updateMe() {
      rstUpdate().trigger();
    }

    public void changeAndUpdate() {
      _change();
      updateMe();
    }

    public boolean setField_noPersist(String name, Object value) {
      return setField(name, value, true);
    }

    public boolean _setField(String name, Object value) {
      return setField(name, value);
    }

    public boolean setField(String name, Object value) {
      return setField(name, value, false);
    }

    public boolean setField(String name, Object value, boolean noPersist) {
      AutoCloseable __27 = enter();
      try {
        try {
          if (eq(get(this, name), value))
            return false;
        } catch (Throwable __e) {
          _handleException(__e);
        }
        return setField_noCheck(name, value, noPersist);
      } finally {
        _close(__27);
      }
    }

    public boolean setField_noCheck(String name, Object value) {
      return setField_noCheck(name, value, false);
    }

    public boolean setField_noCheck(String name, Object value, boolean noPersist) {
      AutoCloseable __28 = enter();
      try {
        set(this, name, value);
        pcallFAll(onFieldChange, name);
        if (!noPersist && persistOnChangedField && !isFalse(mapGet(_persistenceInfo, name)))
          _change();
        return true;
      } finally {
        _close(__28);
      }
    }

    public <A> A setFieldAndReturn(String name, A value) {
      setField(name, value);
      return value;
    }

    public boolean setFields(Object... params) {
      boolean change = false;
      for (int i = 0; i < l(params); i += 2) if (setField((String) params[i], params[i + 1]))
        change = true;
      return change;
    }

    public void start() {
      _hasPreviousBounds = dm_getBounds() != null;
      if (hasMethod_onTypes(this, "onTopInput", String.class))
        dm_onTopInput_q(new VF1<String>() {

          public void get(String s) {
            try {
              call(module(), "onTopInput", s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "call(module(), 'onTopInput, s)";
          }
        });
    }

    public void revisualize() {
      call(creator(), "revisualizeModule", _host);
    }

    public boolean useEnterShortcut() {
      return false;
    }

    public AutoCloseable enter() {
      AutoCloseable c = tempSetBetterThreadLocalIfNecessary_weakRef(dm_current_generic_tl(), this);
      if (c == null && useEnterShortcut())
        return null;
      Object realMC = getMainClass(this);
      if (printToModule())
        c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(_printToModuleInterceptor()));
      if (realMC != mc()) {
        if (printToModule())
          c = combineAutoCloseables(c, (AutoCloseable) callOpt(realMC, "tempInterceptPrintIfNotIntercepted", _printToModuleInterceptor()));
        else
          c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(new F1<String, Boolean>() {

            public Boolean get(String s) {
              try {
                {
                  call(realMC, "print", s);
                  return false;
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ret false with call(realMC, 'print, s);";
            }
          }));
        c = combineAutoCloseables(c, tempSetTL(realMC_tl(), realMC));
      }
      return c;
    }

    public F1<String, Boolean> _printToModuleInterceptor() {
      return new F1<String, Boolean>() {

        public Boolean get(String s) {
          try {
            if (print_preprocess != null)
              s = (String) callF(print_preprocess, s);
            s = fixNewLines(s);
            Appendable loc = _printLog;
            Appendable buf = print_log;
            int loc_max = print_log_max;
            if (buf != loc && buf != null) {
              print_append(buf, s, print_log_max);
              loc_max = local_log_max;
            }
            if (loc != null)
              print_append(loc, s, loc_max);
            System.out.print(s);
            return false;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (print_preprocess != null) s = (S) callF(print_preprocess, s);\r\n      s = ...";
        }
      };
    }

    public boolean printToModule() {
      return true;
    }

    public AutoCloseable enterAndLock() {
      return combineAutoCloseables(enter(), tempLock(lock));
    }

    public boolean setError(Throwable e) {
      setField("_error", persistableThrowable(e));
      return true;
    }

    public void clearError() {
      setField("_error", null);
    }

    public void onChange(Runnable r) {
      Lock __23 = lock;
      lock(__23);
      try {
        if (onChange == null)
          onChange = synchroList();
        addIfNotThere(onChange, r);
      } finally {
        unlock(__23);
      }
    }

    public void onFieldChange(VF1<String> r) {
      Lock __24 = lock;
      lock(__24);
      try {
        if (onFieldChange == null)
          onFieldChange = synchroList();
        addIfNotThere(onFieldChange, r);
      } finally {
        unlock(__24);
      }
    }

    public void onChangeAndNow(Runnable r) {
      onChange(r);
      callF(r);
    }

    public void onChangeAndNow(JComponent c, Object r) {
      onUpdateAndNow(c, r);
    }

    public <A extends JComponent> A onChange(A tc, Object r) {
      onUpdate(tc, r);
      return tc;
    }

    public void update() {
    }

    public void unvisualize() {
      zeroAllFieldsOfTypeExcept(this, Component.class, componentFieldsToKeep);
    }

    public Object menuItems() {
      return null;
    }

    public void enhanceFrame(Container f) {
      Object items = menuItems();
      if (items instanceof Object[])
        items = paramsToAbstractActions((Object[]) items);
      internalFramePopupMenuFromActions_threaded(f, (List) items);
      String switchableFields = (String) (callOpt(this, "switchableFields"));
      Set<String> set = asLinkedHashSet(splitAtSpace(switchableFields));
      Matches m = new Matches();
      for (String field : allFields(getClass())) if (startsWith(field, "_switchableField_", m))
        set.add(m.rest());
      for (String field : set) {
        Class type = fieldType(this, field);
        if (eq(boolean.class, type))
          dm_boolFieldMenuItem(f, field);
        else if (eq(int.class, type))
          dm_intFieldMenuItem(f, field);
        else if (eq(long.class, type))
          dm_longFieldMenuItem(f, field);
        else if (eq(double.class, type))
          dm_doubleFieldMenuItem(f, field);
        else if (eq(float.class, type))
          dm_floatFieldMenuItem(f, field);
        else if (eq(String.class, type))
          dm_stringFieldMenuItem(f, field);
        else if (eq(File.class, type))
          dm_fileFieldMenuItem(f, field);
      }
    }

    public ReliableSingleThread rstUpdate() {
      if (rstUpdate == null)
        rstUpdate = dm_rst(this, new Runnable() {

          public void run() {
            try {
              AutoCloseable __29 = enter();
              try {
                update();
              } finally {
                _close(__29);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "temp enter(); update();";
          }
        });
      return rstUpdate;
    }

    public Q q() {
      AutoCloseable __30 = enter();
      try {
        if (q == null) {
          Lock __25 = lock;
          lock(__25);
          try {
            if (q == null)
              q = dm_startQ();
          } finally {
            unlock(__25);
          }
        }
        return q;
      } finally {
        _close(__30);
      }
    }

    public <A> A withUpdate(A a) {
      rstUpdate().trigger();
      return a;
    }

    public DynModule module() {
      return this;
    }

    public DynModule me() {
      return this;
    }

    public JComponent visualize() {
      return dm_noVisualisation();
    }

    public String programTitle_cache;

    public String programTitle() {
      if (programTitle_cache == null)
        programTitle_cache = snippetTitle(programID(mainClass(this)));
      return programTitle_cache;
    }

    public void doPersist(String field) {
      _persistenceInfo = mapMinus(_persistenceInfo, field);
    }

    public void dontPersist(String field) {
      _persistenceInfo = mapPlus(_persistenceInfo, "field", false);
    }

    public Appendable _actualPrintLog() {
      return printToModule() ? _printLog : print_log;
    }

    public <A> boolean addAndChange(Collection<A> cl, A a) {
      if (cl == null || !cl.add(a))
        return false;
      change();
      return true;
    }

    public <A> void clearAndChange(Collection<A> cl) {
      if (cl == null)
        return;
      cl.clear();
      change();
    }
  }

  static public void _registerTimer(java.util.Timer timer) {
    _registerTimer_original(timer);
    dm_currentModule().ownTimer(timer);
  }

  abstract static public class DynPrintLog extends DynModule {

    transient public JFastLogView_noWrap printLogView;

    transient public Lock updatePrintLog_lock = lock();

    transient public StringBuffer actualPrintLog;

    transient public int printLogUpdateInterval = 500;

    transient public JComponent printLogPanel;

    public JComponent visualize() {
      return makePrintLogPanel();
    }

    public JComponent makePrintLogPanel() {
      JComponent section = printLogPanel = jSection("Log", jscroll_copyBackground(printLogView = jFastLogView_noWrap(getPrintLog())));
      componentPopupMenuItem(section, "Clear", new Runnable() {

        public void run() {
          try {
            AutoCloseable __37 = enter();
            try {
              dm_clearModulePrintLog();
            } finally {
              _close(__37);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();  dm_clearModulePrintLog();";
        }
      });
      return awtEvery(section, printLogUpdateInterval, new Runnable() {

        public void run() {
          try {
            updatePrintLog();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "updatePrintLog();";
        }
      });
    }

    public void updatePrintLog() {
      swing(new Runnable() {

        public void run() {
          try {
            Lock __34 = updatePrintLog_lock;
            lock(__34);
            try {
              JFastLogView_noWrap _view = printLogView;
              if (_view == null)
                return;
              if (_view.setText(getPrintLog())) {
                scrollAllTheWayDown(_view);
                awtLater(100, new Runnable() {

                  public void run() {
                    try {
                      scrollAllTheWayDown(_view);
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "scrollAllTheWayDown(_view)";
                  }
                });
              }
            } finally {
              unlock(__34);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// TODO: optimize\r\n    Lock __34 = updatePrintLog_lock; lock(__34); try {\r\n  ...";
        }
      });
    }

    public JFastLogView_noWrap myPrintLogComponent() {
      return printLogView;
    }

    public void enableWordWrap() {
    }

    public String getPrintLog() {
      if (actualPrintLog == null) {
        if (printToModule())
          actualPrintLog = _printLog;
        else
          actualPrintLog = liveLocalPrintLog_realMC(this);
      }
      return str(actualPrintLog);
    }
  }

  abstract static public class DynObjectTable<A> extends DynModule {

    public List<A> data = new ArrayList();

    transient public JTable table;

    transient public F1<A, Map> itemToMap;

    transient public VF1<A> defaultAction;

    transient public boolean debug, fieldsInOrder = true, withSearcher;

    transient public TableSearcher searcher;

    transient public List onListChanged;

    transient public Set<String> hideFields;

    transient public boolean useStruct = false;

    public void start() {
      try {
        super.start();
        itemToMap = new F1<A, Map>() {

          public Map get(A a) {
            try {
              if (a instanceof String)
                return litorderedmap("", (String) a);
              Map map = humanizeKeys(fieldsInOrder ? objectToMap_inOrder_withoutFields(a, hideFields) : objectToMap(a));
              if (!useStruct)
                map = mapValues(__73 -> strOrEmpty(__73), map);
              return map;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (a instanceof S) ret litorderedmap(\"\" := (S) a);\r\n      Map map = humanize...";
          }
        };
        onChange(new Runnable() {

          public void run() {
            try {
              updateTable();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "updateTable();";
          }
        });
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void onListChanged(Runnable r) {
      if (r == null)
        return;
      onListChanged = addDyn_sync(onListChanged, r);
    }

    public void onListChangedAndNow(Runnable r) {
      if (r == null)
        return;
      onListChanged(r);
      r.run();
    }

    public void addCountToName() {
      onListChangedAndNow(new Runnable() {

        public void run() {
          try {
            addCountToNameNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "addCountToNameNow();";
        }
      });
    }

    public void addCountToNameNow() {
      AutoCloseable __41 = enter();
      try {
        setModuleName(programTitle() + " (" + count() + ")");
      } finally {
        _close(__41);
      }
    }

    public JComponent visualize() {
      List<Map> l = map(itemToMap, data);
      table = dataToTable_uneditable(sexyTable(), l);
      onDoubleClickOrEnter(table, new VF1<Integer>() {

        public void get(Integer row) {
          try {
            AutoCloseable __42 = enter();
            try {
              A a = _get(data, row);
              if (a != null)
                onDoubleClick(a);
            } finally {
              _close(__42);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();\r\n      A a = _get(data, row);\r\n      if (a != null) onDoubleCli...";
        }
      });
      if (withSearcher)
        return (searcher = tableWithSearcher2(table)).panel;
      return table;
    }

    public void unvisualize() {
      super.unvisualize();
      searcher = null;
    }

    public void onDoubleClick(A line) {
      callF(defaultAction, line);
    }

    public void updateTable() {
      AutoCloseable __43 = enter();
      try {
        if (table != null) {
          swing(new Runnable() {

            public void run() {
              try {
                Point scrollPosition = enclosingViewPosition(table);
                if (debug)
                  print("Scroll position: " + scrollPosition);
                dataToTable_uneditable(table, map(itemToMap, data));
                setEnclosingViewPosition(table, scrollPosition);
                if (searcher != null)
                  searcher.rowIndices = null;
                if (debug)
                  print("dataToTable done, alerting " + n2(onListChanged, "listener"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "Point scrollPosition = enclosingViewPosition(table);\r\n      if (debug) print(...";
            }
          });
        }
        pcallFAll(onListChanged);
      } finally {
        _close(__43);
      }
    }

    public void dontPersist() {
      _persistenceInfo = mapPlus(_persistenceInfo, "data", false);
    }

    public void clear() {
      syncClear(data);
      fireDataChanged();
    }

    public void add(A a) {
      syncAdd(data, a);
      fireDataChanged();
    }

    public A addAndReturn(A a) {
      add(a);
      return a;
    }

    public void add(int idx, A a) {
      syncAdd(data, idx, a);
      fireDataChanged();
    }

    public void addAll(Collection<A> l) {
      if (empty(l))
        return;
      syncAddAll(data, l);
      fireDataChanged();
    }

    public void addAndScrollDown(A a) {
      add(a);
      scrollDown();
    }

    public void remove(A a) {
      syncRemove(data, a);
      fireDataChanged();
    }

    public void removeAll(List<A> a) {
      syncRemoveAll(data, a);
      fireDataChanged();
    }

    public void setList(Iterable<A> data) {
      setData(data);
    }

    public void removeSelected() {
      removeAll(allSelected());
    }

    public void setData(Collection<A> data) {
      setData((Iterable) data);
    }

    public void setData(Iterable<A> data) {
      setData(data, false);
    }

    public void setData(Iterable<A> data, boolean force) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              int[] selection = selectedTableRows_array(table);
              List<A> cloned = cloneList(data);
              if (setField("data", cloned) || force) {
                updateTable();
                dm_vmBus_send("listChanged", module(), cloned);
              }
              if (force)
                change();
              selectTableRows(table, selection);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "//int selection = selectedIndex();\r\n      int[] selection = selectedTableRows...";
          }
        });
      }
    }

    public int count() {
      return syncL(data);
    }

    public void setData_force(Collection<A> data) {
      setData(data, true);
    }

    public void fireDataChanged() {
      setData_force(data);
    }

    public int rowFromSearcher(int i) {
      return searcher == null || searcher.rowIndices == null ? i : or(get(searcher.rowIndices, i), -1);
    }

    public A selected() {
      return syncGet(data, rowFromSearcher(selectedTableRowInModel(table)));
    }

    public List<A> allSelected() {
      return syncListGetMulti(data, selectedIndices());
    }

    public int selectedIndex() {
      return selectedTableRow(table);
    }

    public List<Integer> selectedIndices() {
      return map(i -> rowFromSearcher(i), selectedTableRowsInModel(table));
    }

    public boolean selectItem(A a) {
      int i = indexOf(data, a);
      selectRow(table, i);
      return i >= 0;
    }

    public void doubleClickItem(A a) {
      if (selectItem(a))
        onDoubleClick(a);
    }

    public void popupMenuItem(String text, Object r) {
      tablePopupMenuItemsThreaded(table, text, _convertRunnable(r));
    }

    public void popupMenuItem_top(String text, Object r) {
      tablePopupMenuItemsThreaded_top(table, text, _convertRunnable(r));
    }

    public Object _convertRunnable(final Object r) {
      if (r == null || r instanceof Runnable)
        return r;
      return new VF1<Integer>() {

        public void get(Integer idx) {
          try {
            callF(r, syncGet(data, idx));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r, syncGet(data, idx))";
        }
      };
    }

    public JTable table() {
      return table;
    }

    public void hideFields(String... fields) {
      if (hideFields == null)
        hideFields = new HashSet();
      _addAll(hideFields, fields);
    }

    public A getRow(int row) {
      return get(data, row);
    }

    public void scrollDown() {
      scrollTableDownNow(table);
    }

    public List<A> getData() {
      return data;
    }

    public List<A> data() {
      return getData();
    }

    public List<A> list() {
      return getData();
    }

    public List<A> getList() {
      return getData();
    }

    public List<A> clonedList() {
      return cloneList(data);
    }

    public File quickBackup() {
      File f = programFile("backup-" + ymd_minus_hms_minus_millis() + ".gz");
      saveGZStructToFile(f, module());
      printFileInfo(f);
      return f;
    }
  }

  abstract static public class DynImageSurface extends DynModule {

    transient public ImageSurface imageSurface;

    transient public BufferedImage image;

    transient public String imageID;

    transient public boolean useUpdateHack, zoomToWindowOnSetImage;

    transient public Object onNewImage;

    static public boolean _switchableField_autoSaveToDisk = true;

    public boolean autoSaveToDisk = autoSaveToDiskDefault();

    public JComponent visualize() {
      return _visualize();
    }

    final public JComponent _visualize() {
      imageSurface = imageSurface(image);
      imageSurface.onNewImage = new Runnable() {

        public void run() {
          try {
            newImageFromSurface();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "newImageFromSurface();";
        }
      };
      return jscroll_center(imageSurface);
    }

    public void enableDoubleBuffering() {
      if (imageSurface != null)
        imageSurface.setDoubleBuffered(true);
    }

    public JComponent visualizeWithDoubleBuffering() {
      JComponent c = _visualize();
      enableDoubleBuffering();
      return c;
    }

    public Object _getReloadData() {
      return image;
    }

    public void _setReloadData(BufferedImage image) {
      this.image = image;
    }

    public void start() {
      try {
        super.start();
        if (autoSaveToDisk)
          autoLoadNow();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void autoLoadNow() {
      AutoCloseable __48 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          if (fileExists(f)) {
            print("Auto-loading " + f);
            setImage(loadImage2(f), true);
          }
        } catch (Throwable __e) {
          _handleException(__e);
        }
      } finally {
        _close(__48);
      }
    }

    public void autoSaveNow() {
      AutoCloseable __49 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          savePNG(f, image);
          infoBox("Auto-saved " + renderFileInfo(f));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      } finally {
        _close(__49);
      }
    }

    public boolean autoSaveToDiskDefault() {
      return false;
    }

    public void enhanceFrame(Container f) {
      super.enhanceFrame(f);
      internalFramePopupMenuItem(f, "Auto-save now", runnableThread(new Runnable() {

        public void run() {
          try {
            autoSaveNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "autoSaveNow();";
        }
      }));
    }

    public void setImage(MakesBufferedImage image) {
      imageID = null;
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void newImageFromSurface() {
      setImage(imageSurface.getImage());
    }

    public void setImage(BufferedImage image) {
      setImage(image, false);
    }

    public void setImage(BufferedImage image, boolean loadingFromAutoSave) {
      this.image = image;
      imageID = null;
      if (imageSurface != null) {
        AutoCloseable __50 = tempSetField(imageSurface, "onNewImage", null);
        try {
          imageSurface.setImage(image);
          if (zoomToWindowOnSetImage)
            imageSurface.zoomToWindow();
          if (autoSaveToDisk && !loadingFromAutoSave)
            autoSaveNow();
        } finally {
          _close(__50);
        }
      }
      vmBus_send("newImage", this);
      pcallF(onNewImage, image);
    }

    public void setImage(String imageID) {
      if (sameSnippetID(this.imageID, imageID))
        return;
      setImage(loadImage2(imageID));
      this.imageID = imageID;
    }

    public File autoSaveImageFile() {
      String id = dm_moduleID(me());
      return javaxDataDir("Image Autosaves/" + id + "-autosave.png");
    }

    public BufferedImage getImage() {
      if (useUpdateHack) {
        ImageSurface is = imageSurface;
        if (is != null && is.getImage() != image)
          setImage(is.getImage());
      }
      return image;
    }

    public boolean hasImage() {
      return image != null;
    }

    public void setZoom(double zoom) {
      if (imageSurface != null)
        imageSurface.setZoom(zoom);
    }

    public Rect getSelection() {
      return imageSurface == null ? null : toRect(imageSurface.getSelection());
    }

    public void setSelection(Rect r) {
      if (imageSurface != null)
        imageSurface.setSelection(toRectangle(r));
    }

    public int imageWidth() {
      return imageSurface.getImage().getWidth();
    }

    public int imageHeight() {
      return imageSurface.getImage().getHeight();
    }
  }

  abstract static public class DynCalculatedList extends DynModule {

    transient public JList list;

    transient public List<String> results;

    transient public boolean calculateWhenHidden = false;

    public JComponent visualize() {
      return list = jlist(calc());
    }

    public void unvisualize() {
      list = null;
    }

    public void update() {
      AutoCloseable __55 = enter();
      try {
        if (list != null || calculateWhenHidden)
          fillListWithStrings(list, results = calc());
      } finally {
        _close(__55);
      }
    }

    abstract public List<String> calc();

    public void scrollDown() {
      scrollAllTheWayDown(list);
    }

    public String selected() {
      return selectedItem(list);
    }
  }

  static public Object creator() {
    return callOpt(assertNotNull("No real MC", realMC_tl()).get(), "creator");
  }

  static public String programID;

  static public String getProgramID() {
    Object mc = realMC_tl().get();
    if (mc != null)
      return getProgramID(mc);
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public Concepts db_mainConcepts() {
    return (Concepts) call(assertNotNull("No real MC", realMC()), "db_mainConcepts");
  }

  static public void readLocally(String progID, String varNames) {
    readLocally2(mc(), progID, varNames);
  }

  static public void readLocally(String varNames) {
    readLocally2(mc(), programID(), varNames);
  }

  static public void readLocally2(Object obj, String varNames) {
    readLocally2(obj, programID(), varNames);
  }

  static public int readLocally_stringLength;

  static public ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

  static public ThreadLocal readLocally2_classFinder = new ThreadLocal();

  static public boolean readLocally_useTwoThreads = true;

  static public void readLocally2(Object obj, String progID, String varNames) {
    try {
      boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
      for (String variableName : javaTokC(varNames)) {
        File textFile = new File(programDir(progID), variableName + ".text");
        String value = loadTextFile(textFile);
        if (value != null)
          set(utils.class, variableName, value);
        else {
          File structureFile = new File(programDir(progID), variableName + ".structure");
          value = loadTextFile(structureFile);
          if (value == null) {
            File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
            if (!structureGZFile.isFile())
              return;
            CloseablesHolder ch = new CloseablesHolder();
            try {
              Producer<String> tokenizer = gzFileTokenReaderForUnstruct(structureGZFile, ch);
              if (readLocally_useTwoThreads) {
                tokenizer = moveProducerToNewThread(tokenizer, ch);
              }
              Object o = unstructure_tok(tokenizer, allDynamic, readLocally2_classFinder.get());
              readLocally_set(obj, variableName, o);
              return;
            } finally {
              _close(ch);
            }
          }
          readLocally_stringLength = l(value);
          if (nempty(value))
            readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void readLocally_set(Object c, String varName, Object value) {
    Object oldValue = get(c, varName);
    if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
      value = synchroList((List) value);
    }
    set(c, varName, value);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(final Iterable<A> c, final F1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Collection<A> c, final IF1<A, C> makeInnerIterator) {
    return nestedIterator(iterator(c), makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(Iterator<A> it1, IF1<A, C> makeInnerIterator) {
    return nestedIterator(it1, toF1(makeInnerIterator));
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(final Iterator<A> it1, final F1<A, C> makeInnerIterator) {
    if (it1 == null || !it1.hasNext())
      return emptyIterableIterator();
    return iff(new F0() {

      public A a;

      public Iterator<B> innerIterator;

      {
        nextOuter();
      }

      public void nextOuter() {
        a = it1.next();
        innerIterator = makeInnerIterator.get(a);
      }

      public Object get() {
        while (true) {
          ping();
          if (innerIterator != null && innerIterator.hasNext())
            return innerIterator.next();
          if (!it1.hasNext())
            return endMarker();
          nextOuter();
        }
      }
    });
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Iterator<A> it1) {
    return nestedIterator(it1, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedIterator(IF1<A, C> makeInnerIterator, Collection<A> l) {
    return nestedIterator(l, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(Iterable<A> c, F1<A, C> makeInnerIterator) {
    return nestedIterator(c, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(Collection<A> c, IF1<A, C> makeInnerIterator) {
    return nestedIterator(c, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(Iterator<A> it1, IF1<A, C> makeInnerIterator) {
    return nestedIterator(it1, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(Iterator<A> it1, F1<A, C> makeInnerIterator) {
    return nestedIterator(it1, makeInnerIterator);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(IF1<A, C> makeInnerIterator, Iterator<A> it1) {
    return nestedIterator(makeInnerIterator, it1);
  }

  static public <A, B, C extends Iterator<B>> IterableIterator<B> nestedI(IF1<A, C> makeInnerIterator, Collection<A> l) {
    return nestedIterator(makeInnerIterator, l);
  }

  static public Map<Class, Field[]> nonStaticNonTransientFieldObjects_cachedArray_cache = dangerousWeakMap();

  static public Field[] nonStaticNonTransientFieldObjects_cachedArray(Object o) {
    if (o == null)
      return null;
    Class c = _getClass(o);
    Field[] fields = nonStaticNonTransientFieldObjects_cachedArray_cache.get(c);
    if (fields == null) {
      List<Field> l = new ArrayList();
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
          l.add(makeAccessible(f));
        _c = _c.getSuperclass();
      } while (_c != null);
      fields = toArrayOfType(Field.class, l);
      nonStaticNonTransientFieldObjects_cachedArray_cache.put(c, fields);
    }
    return fields;
  }

  static public List<String> myInnerClasses_list = litlist(null, "Meta", "RandomAvatar", "DefunctClassLoader", "ImageSurface", "ConceptClassesDependentValue", "ConceptsRefChecker", "BWImage", "talkToThisVM_IO", "IFieldIndex", "Str", "BotRandomAction", "SimpleLiveValue", "ConceptFieldIndexDesc", "SingleComponentPanel", "DynModule", "OnNewDialog", "IWebRequest", "Rect", "Pt", "AbstractLayoutManager", "IterableIterator", "betterCIComparator_C", "RemoteDB", "MakesBufferedImage", "SynchronizedArrayList", "RiddleWithSolution", "Concepts", "RC", "Hasher", "IBWIntegralImage", "CloseableIterableIterator", "ExpiringMap2", "PostReferenceable", "PNGFile", "getOpt_Map", "IFieldsToList", "IInputHandler", "ForEach_vstack", "CustomBotStep", "structure_Data", "jsonDecode_Y", "IVar", "DynPrintLogAndEnabled", "ConceptWithGlobalID", "Matches", "WithTimestamp", "HCRUD_Concepts", "TableWithTooltips", "DynCalculatedList", "allSpreads_StackEntry", "ParameterizedTypeImpl", "Dyn_FieldWatcher", "Timestamp", "DoubleRect", "Surface", "Q", "ConceptFieldIndexBase", "FlexThreadLocal", "OrError", "LongRange", "EvtCallSubroutine", "SnippetTitles", "RandomAccessSubList", "BreadthFirstPathFinder_withLinkType", "VStack", "ReliableSingleThread_Multi", "MultiSet", "OptimizedMultiSet", "BotStep", "CompactHashSet", "T3", "MultiSetMapWithTopTen", "IResourceHolder", "CloseablesHolder", "DynObjectTable", "StringTree2", "HCRUD_Data", "SteppableAndIF0", "IntRange", "IConceptCounter", "UnsynchronizedCompactHashSet", "ActiveSequence", "BetterLabel", "componentPopupMenu_Adapter", "BWIntegralImage", "JavaXClassLoaderWithParent2", "InternationalPhoneValidator", "UndoState", "ScheduledAction", "RGBImage", "SmartTimerTask", "JSection", "ConceptFieldIndexCI_withTopTen", "ValueConverterForField", "Visitable", "FullChange", "HyperCompactTreeSet", "ConceptDelete", "BotSwitchLanguage", "ReliableSingleThread", "WithPollValue", "DeliveredDomain", "IBWImage", "AutoComboBox", "ProgramScan", "allSpreads_Data", "ConceptFieldIndex", "BotMessage", "BotClearStack", "IHasBackRefs", "F0", "BotIdleMode", "Snippet", "F1", "DynImageSurface", "F2", "RandomAccessAbstractList", "RGB", "F3", "unstructure_Receiver", "Not", "IHasGlobalID", "IF0", "BaseXRef", "StringBufferWithMaxSize", "DefaultValueConverterForField", "AbstractAvatar", "IF2", "ConceptFieldIndexCI", "IF1", "tablePopupMenu_Maker", "IVF1", "ShowComboBoxForm", "IVF2", "Domain", "Cache", "_MethodCache", "HDivWithVerticalExpandButton", "structure_ClassInfo", "Form", "BotOutgoingQuestion", "TimedCache", "ISetAndGet", "LiveValue", "BotSaveFeedback", "QuickException", "BotNewDialog", "Language", "DialogHandler", "JavaScript", "_PrintIndent", "Steppable", "proxy_InvocationHandler", "MMOPattern", "UserPost", "MetaTransformer", "ExecutedStep", "Pair", "HTMLFramer1", "JavaXClassLoader", "BotPause", "UniqueString", "Avatar", "GrabbableIntPixels", "IIVirtualClip", "TransferableImage", "UploadedFile", "SimpleCircularBuffer", "ConversationFeedback", "IConceptIndex", "ReverseChain", "ConceptCreate", "WebPushSubscription", "MultiSetMap", "BotSendTyping", "Var", "MRUAndAllTimeTop_optimized", "Scorer", "ITokCondition", "SubList", "SecretValue", "CountingOutputStream", "CancelToCancelPoint", "HTMLAceEditor", "ConceptChange", "CompactAbstractMap", "CompactLinkedHashSet", "FixedRateTimer", "Settings", "Fail", "ISetter", "CMissingObject", "OnUserMessage", "Out", "ScannedBot", "XRef", "HTMLPopDownButton", "IntegralImage", "MechMode", "CountryDialCode", "Chain", "MechListDependentCache", "JS", "Conversation", "ConceptID", "MultiMap", "HTMLTabs", "CriticalAction", "CreatedDeletedChanged", "IResourceLoader", "WeakHasherMap", "Lead", "Either", "Worker", "ScheduledActionOnConversation", "SortedArrayBasedMap", "BotSaveLead", "ScoredSearcher", "CompilerBot", "IIntegralImage", "Msg", "DialogIO", "SimpleCRUD", "SynchronizedArrayList_Base", "IAutoCloseableF0", "MRUCache", "TransitiveHull", "AlphanumComparator", "AbstractBotImage", "PersistableThrowable", "talkToSubBot_IO", "Scored", "HasIndex", "ISubList", "WidthAndHeight", "Responder", "VF2", "TableSearcher", "IMultiSet", "JavaXHyperlinker", "mapI_It", "ConceptsChange", "TokCondition", "HTML", "BotGoBack", "RightAlignedLine", "GlobalID", "HCRUD", "findCodeTokens_Matcher", "listPopupMenu_Maker", "EvtJumpTo", "JFastLogView_noWrap", "UploadedImage", "ImageSurfaceSelector", "UserKeyword", "Concept", "IRef", "HAbstractRenderable", "RegisteredReference", "Sequence", "ConceptsShadowLogger", "Flag", "generalizedCIComparator_C", "ContentsIndexedList", "FileTransferable", "VStackComputableWithStep", "IContentsIndexedList2", "BotEndConversation", "Producer", "DynNewBot2", "EvtMatchedUserKeyword", "And", "talkTo_IO", "DynGazelleRocks", "Evt", "User", "FileBasedLock", "Timed", "Symbol", "IMeta", "BetterThread", "IContentsIndexedList", "LetterLayout", "AuthedDialogID", "InputHandled", "ConceptShadow", "BetterThreadLocal", "Lowest", "Action_NextStep", "HTMLPaginator", "UploadedSound", "DynPrintLog", "JavaXClassLoaderWithParent", "Transformable", "CannedAnswer", "jLiveValueSection_class", "BotDoNothing", "RealmCopy", "CancelPoint", "FieldIndicator", "UserCreatedObject", "Android3", "replaceKeywordBlock_dyn_IReplacer", "DynamicMethods", "BotImage");

  static public List<String> myInnerClasses() {
    return myInnerClasses_list;
  }

  static public void cancelTimerOrInterruptThread(Object timer) {
    if (timer instanceof Thread && !(timer instanceof AutoCloseable))
      interruptThread((Thread) timer);
    else
      cancelTimer(timer);
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(Object... objects) {
    throw new Fail(objects);
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first((Collection) strings));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !regionMatches(s, j, "*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j < l && !regionMatches(s, j, "]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !regionMatches(s, j, "]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public boolean get(BitSet bs, int idx) {
    return bs != null && bs.get(idx);
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public void set(BitSet bs, int idx) {
    {
      if (bs != null)
        bs.set(idx);
    }
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject) {
        setDyn(((DynamicObject) o), field, value);
        return;
      }
      if (o instanceof IMeta)
        setDyn(((IMeta) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF(Object f, Object... args) {
    if (f instanceof String)
      return callMCWithVarArgs((String) f, args);
    return safeCallF(f, args);
  }

  static public Object safeCallF(Object f, Object... args) {
    if (f instanceof Runnable) {
      ((Runnable) f).run();
      return null;
    }
    if (f == null)
      return null;
    Class c = f.getClass();
    ArrayList<Method> methods;
    synchronized (callF_cache) {
      methods = callF_cache.get(c);
      if (methods == null)
        methods = callF_makeCache(c);
    }
    int n = l(methods);
    if (n == 0) {
      throw fail("No get method in " + getClassName(c));
    }
    if (n == 1)
      return invokeMethod(methods.get(0), f, args);
    for (int i = 0; i < n; i++) {
      Method m = methods.get(i);
      if (call_checkArgs(m, args, false))
        return invokeMethod(m, f, args);
    }
    throw fail("No matching get method in " + getClassName(c));
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public Object callOpt(Object o, String method, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public Map<String, UniqueString> uniqueString_map = weakHashMap();

  static public UniqueString uniqueString(String s) {
    if (s == null)
      return null;
    synchronized (uniqueString_map) {
      UniqueString us = uniqueString_map.get(s);
      if (us == null)
        uniqueString_map.put(s, us = new UniqueString(s, true));
      return us;
    }
  }

  static public UniqueString uniqueString(CharSequence s) {
    return s == null ? null : uniqueString(str(s));
  }

  static public FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  static public FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return vmBus_timerStarted(timer);
  }

  static public FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  static public FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JLabel jlabel(final String text) {
    return swingConstruct(BetterLabel.class, text);
  }

  static public JLabel jlabel() {
    return jlabel(" ");
  }

  static public JTextArea newTypeWriterTextArea() {
    return newTypeWriterTextArea("");
  }

  static public JTextArea newTypeWriterTextArea(String text) {
    return withTypeWriterFont(jTextArea(text));
  }

  static public String struct(Object o) {
    return structure(o);
  }

  static public String struct(Object o, structure_Data data) {
    return structure(o, data);
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public String loadPageSilentlyWithTimeout(double timeoutSeconds, String url) {
    return loadPageSilentlyWithTimeout(url, toMS_int(timeoutSeconds));
  }

  static public String loadPageSilentlyWithTimeout(int timeout, String url) {
    return loadPageSilentlyWithTimeout(url, timeout);
  }

  static public String loadPageSilentlyWithTimeout(String url, int timeout) {
    try {
      url = loadPage_preprocess(url);
      URL _url = new URL(url);
      return loadPage(setURLConnectionTimeouts(_url.openConnection(), timeout), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean loadPageWithUserAgent_verbose = false;

  static public String loadPageWithUserAgent(String url, String userAgent) {
    try {
      URL tURL = new URL(url);
      URLConnection conn = tURL.openConnection();
      conn.setRequestProperty("User-Agent", userAgent);
      loadPage_anonymous = true;
      if (loadPageWithUserAgent_verbose)
        print("Loading as " + userAgent + ": " + hideCredentials(url));
      return loadPage(conn, tURL);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public Object cget(Object c, String field) {
    c = derefRef(c);
    Object o = getOpt(c, field);
    return derefRef(o);
  }

  static public Object cget(String field, Object c) {
    return cget(c, field);
  }

  static public int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_csetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cset(Iterable<? extends Concept> l, Object... values) {
    int changes = 0;
    for (Concept c : unnullForIteration(l)) changes += cset(c, values);
    return changes;
  }

  static public <A extends Concept> int cset(Concept.Ref<A> c, Object... values) {
    return cset(getVar(c), values);
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print(combinePrintParameters(s, o));
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    try {
      Object f = getThreadLocal(print_byThread_dontCreate());
      if (f == null)
        f = print_allThreads;
      if (f != null)
        if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
          return;
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
    }
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public List<VF1<Map>> _threadInfo_makers = synchroList();

  static public Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  static public List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  static public void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  static public void _threadInfo_addMakerAndRetriever(VF1<Map> maker, VF1<Map> retriever) {
    _threadInfo_makers.add(maker);
    _threadInheritInfo_retrievers.add(retriever);
  }

  static public boolean match(String pat, String s) {
    return match3(pat, s);
  }

  static public boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  static public boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  static public Field getField(Object o, String field) {
    if (o == null)
      return null;
    return setOpt_findField(_getClass(o), field);
  }

  static public Object getField(Field field, Object o) {
    return fieldGet(field, o);
  }

  static public Class fieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getType();
  }

  static public String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public Map vm_generalWeakSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  static public <A extends JComponent> A bindToComponent(final A component, final Runnable onShow, final Runnable onUnShow) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final Var<Boolean> flag = new Var<>(false);
            component.addAncestorListener(new AncestorListener() {

              public void ancestorAdded(AncestorEvent event) {
                if (flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(true);
                pcallF(onShow);
              }

              public void ancestorRemoved(AncestorEvent event) {
                if (!flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(false);
                pcallF(onUnShow);
              }

              public void ancestorMoved(AncestorEvent event) {
              }
            });
            if (component.isShowing()) {
              flag.set(true);
              pcallF(onShow);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Var<Boolean> flag = new(false);\r\n    component.addAncestorListener(new ...";
        }
      });
    }
    return component;
  }

  static public <A extends JComponent> A bindToComponent(A component, Runnable onShow) {
    return bindToComponent(component, onShow, null);
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    Long limit = optPar(loadPage_sizeLimit);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      boolean silent = isTrue(loadPage_silent.get());
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (limit == null || n < limit) {
        ping();
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if (!silent && (n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public String loadPage_utf8(URL url) {
    return loadPage_utf8(url.toString());
  }

  static public String loadPage_utf8(String url) {
    AutoCloseable __1 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(url);
    } finally {
      _close(__1);
    }
  }

  static public String loadPage_utf8(URLConnection con, URL url, boolean addHeaders) throws IOException {
    AutoCloseable __2 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(con, url, addHeaders);
    } finally {
      _close(__2);
    }
  }

  static public boolean preferCached = false;

  static public boolean loadSnippet_debug = false;

  static public ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();

  static public ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();

  static public int loadSnippet_timeout = 30000;

  static public String loadSnippet(Snippet s) {
    return loadSnippet(s.id);
  }

  static public String loadSnippet(String snippetID) {
    try {
      if (snippetID == null)
        return null;
      return loadSnippet(parseSnippetID(snippetID), preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(String snippetID, boolean preferCached) throws IOException {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  }

  static public IF1<Long, String> loadSnippet;

  static public String loadSnippet(long snippetID) {
    return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID);
  }

  final static public String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) {
    return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID);
  }

  static public String loadSnippet_base(long snippetID) {
    try {
      return loadSnippet(snippetID, preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(long snippetID, boolean preferCached) throws IOException {
    if (isLocalSnippetID(snippetID))
      return loadLocalSnippet(snippetID);
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadSnippet(fsI(snippetID));
    return loadSnippet_noResourceLoader(snippetID, preferCached);
  }

  static public String loadSnippet_noResourceLoader(long snippetID, boolean preferCached) throws IOException {
    String text;
    initSnippetCache();
    text = DiskSnippetCache_get(snippetID);
    if (preferCached && text != null)
      return text;
    try {
      if (loadSnippet_debug && text != null)
        System.err.println("md5: " + md5(text));
      String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
      if (nempty(text))
        url += "&md5=" + md5(text);
      if (!isTrue(loadSnippet_publicOnly.get()))
        url += standardCredentials();
      String text2 = loadSnippet_loadFromServer(url);
      boolean same = eq(text2, "==*#*==");
      if (loadSnippet_debug)
        print("loadSnippet: same=" + same);
      if (!same)
        text = text2;
    } catch (RuntimeException e) {
      e.printStackTrace();
      throw new IOException("Snippet #" + snippetID + " not found or not public");
    }
    try {
      initSnippetCache();
      DiskSnippetCache_put(snippetID, text);
    } catch (IOException e) {
      System.err.println("Minor warning: Couldn't save snippet to cache (" + DiskSnippetCache_getDir() + ")");
    }
    return text;
  }

  static public File DiskSnippetCache_dir;

  public static void initDiskSnippetCache(File dir) {
    DiskSnippetCache_dir = dir;
    dir.mkdirs();
  }

  public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
    return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
  }

  static public File DiskSnippetCache_getFile(long snippetID) {
    return new File(DiskSnippetCache_dir, "" + snippetID);
  }

  public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
    saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
  }

  public static File DiskSnippetCache_getDir() {
    return DiskSnippetCache_dir;
  }

  public static void initSnippetCache() {
    if (DiskSnippetCache_dir == null)
      initDiskSnippetCache(getGlobalCache());
  }

  static public String loadSnippet_loadFromServer(String url) {
    Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
    try {
      return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
    } finally {
      loadPage_forcedTimeout_byThread.set(oldTimeout);
    }
  }

  static public String loadSnippetQuietly(Snippet s) {
    return loadSnippetQuietly(s.id);
  }

  static public String loadSnippetQuietly(String snippetID) {
    loadSnippet_silent.set(true);
    try {
      return loadSnippet(snippetID);
    } finally {
      loadSnippet_silent.set(null);
    }
  }

  static public String sendToLocalBot(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        print(bot + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(bot + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBot(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        print(port + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(port + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public JTable sexyTableWithoutDrag() {
    final JTable table = tableWithToolTips();
    tablePopupMenu(table, sexyTableWithoutDrag_popupMenuMaker(table));
    table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_FOCUSED).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    ((InputMap) UIManager.get("Table.ancestorInputMap")).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    return table;
  }

  static public VF2<JPopupMenu, Integer> sexyTableWithoutDrag_popupMenuMaker(JTable t) {
    final WeakReference<JTable> ref = weakRef(t);
    return new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, Integer row) {
        try {
          final JTable table = ref.get();
          final String item = first(getTableLine(table, row));
          MouseEvent e = tablePopupMenu_mouseEvent.get();
          final int col = table.columnAtPoint(e.getPoint());
          final Object value = table.getModel().getValueAt(row, col);
          if (value instanceof ImageIcon) {
            addMenuItem(menu, "Copy image to clipboard", new Runnable() {

              public void run() {
                try {
                  copyImageToClipboard(((ImageIcon) value).getImage());
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyImageToClipboard(((ImageIcon) value).getImage());";
              }
            });
          } else {
            final String text = str(value);
            addMenuItem(menu, "Copy text to clipboard", new Runnable() {

              public void run() {
                try {
                  copyTextToClipboard(text);
                  print("Copied text to clipboard: " + quote(text));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyTextToClipboard(text);\r\n        print(\"Copied text to clipboard: \" + quot...";
              }
            });
          }
          addMenuItem(menu, "Set row height...", new Runnable() {

            public void run() {
              try {
                final JTextField tf = jTextField(table.getRowHeight());
                showTitledForm("Set row height", "Pixels", tf, new Runnable() {

                  public void run() {
                    try {
                      table.setRowHeight(parseInt(trim(tf.getText())));
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "table.setRowHeight(parseInt(trim(tf.getText())))";
                  }
                });
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "final JTextField tf = jTextField(table.getRowHeight());\r\n      showTitledForm...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTable table = ref!;\r\n    final S item = first(getTableLine(table, row)...";
      }
    };
  }

  static public class tablePopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JTable, tablePopupMenu_Maker> tablePopupMenu_map = newWeakHashMap();

  static public ThreadLocal<MouseEvent> tablePopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> tablePopupMenu_first = new ThreadLocal();

  static public void tablePopupMenu(final JTable table, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(tablePopupMenu_first));
    {
      swing(new Runnable() {

        public void run() {
          try {
            tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);
            if (maker == null) {
              tablePopupMenu_map.put(table, maker = new tablePopupMenu_Maker());
              final tablePopupMenu_Maker _maker = maker;
              table.addMouseListener(new MouseAdapter() {

                public void mousePressed(MouseEvent e) {
                  displayMenu(e);
                }

                public void mouseReleased(MouseEvent e) {
                  displayMenu(e);
                }

                public void displayMenu(MouseEvent e) {
                  if (!e.isPopupTrigger())
                    return;
                  JPopupMenu menu = new JPopupMenu();
                  int row = table.rowAtPoint(e.getPoint());
                  if (table.getSelectedRowCount() < 2)
                    table.setRowSelectionInterval(row, row);
                  int modelRow = convertTableRowToModel(table, row);
                  int emptyCount = menu.getComponentCount();
                  tablePopupMenu_mouseEvent.set(e);
                  for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, modelRow);
                  vmBus_send("showingPopupMenu", table, menu);
                  if (menu.getComponentCount() != emptyCount)
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
              });
            }
            if (first)
              maker.menuMakers.add(0, menuMaker);
            else
              maker.menuMakers.add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);\r\n    if (maker ==...";
        }
      });
    }
  }

  static public void tablePopupMenuFirst(JTable table, final Object menuMaker) {
    tablePopupMenu_first.set(true);
    tablePopupMenu(table, menuMaker);
  }

  static public void tablePopupMenuFirst(JTable table, IVF2<JPopupMenu, Integer> menuMaker) {
    tablePopupMenuFirst(table, (Object) menuMaker);
  }

  static public ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent;

  static public void componentPopupMenu_init() {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (componentPopupMenu_mouseEvent == null)
              componentPopupMenu_mouseEvent = (ThreadLocal<MouseEvent>) vm_generalMap_get("mouseEvent");
            if (componentPopupMenu_mouseEvent == null)
              vm_generalMap_put("componentPopupMenu_mouseEvent", componentPopupMenu_mouseEvent = new ThreadLocal());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (componentPopupMenu_mouseEvent == null)\r\n      componentPopupMenu_mouseEve...";
        }
      });
    }
  }

  static public void componentPopupMenu(final JComponent component, final Object menuMaker) {
    if (component == null || menuMaker == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) _get(adapter, "maker")).add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public Object componentPopupMenu_initForComponent(final JComponent component) {
    return component == null ? null : swing(new F0<Object>() {

      public Object get() {
        try {
          componentPopupMenu_init();
          Object adapter = findComponentPopupMenuListener_gen(component);
          if (adapter == null) {
            componentPopupMenu_Adapter a = new componentPopupMenu_Adapter();
            component.addMouseListener(a);
            adapter = a;
          }
          return adapter;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "componentPopupMenu_init();\r\n    O adapter = findComponentPopupMenuListener_ge...";
      }
    });
  }

  static public class componentPopupMenu_Adapter extends MouseAdapter {

    public List maker = new ArrayList();

    public boolean internalFrameLeftButtonMagic = false;

    public Point pressedAt;

    public void mousePressed(MouseEvent e) {
      displayMenu(e);
      pressedAt = internalFrameLeftButtonMagic && e.getClickCount() == 1 && internalFrameActive(e.getComponent()) ? e.getLocationOnScreen() : null;
    }

    public void mouseReleased(MouseEvent e) {
      if (internalFrameLeftButtonMagic && eq(pressedAt, e.getLocationOnScreen()))
        displayMenu2(e);
      else
        displayMenu(e);
    }

    public void displayMenu(MouseEvent e) {
      if (e.getSource() instanceof JInternalFrame)
        return;
      if (e.isPopupTrigger())
        displayMenu2(e);
    }

    public void displayMenu2(MouseEvent e) {
      JPopupMenu menu = new JPopupMenu();
      int emptyCount = menu.getComponentCount();
      AutoCloseable __1 = tempSetTL(componentPopupMenu_mouseEvent, e);
      try {
        for (Object menuMaker : maker) pcallF(menuMaker, menu);
        vmBus_send("showingPopupMenu", e.getComponent(), menu);
        if (menu.getComponentCount() != emptyCount)
          menu.show(e.getComponent(), e.getX(), e.getY());
      } finally {
        _close(__1);
      }
    }
  }

  static public void componentPopupMenu_top(final JComponent component, final VF1<JPopupMenu> menuMaker) {
    if (component != null && menuMaker != null) {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) get(adapter, "maker")).add(0, menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public MouseEvent componentPopupMenu_getEvent() {
    return componentPopupMenu_mouseEvent.get();
  }

  static public Object dm_current_generic() {
    return getWeakRef(dm_current_generic_tl().get());
  }

  static public Object dm_current_mandatory_generic() {
    return assertNotNull("No module set", dm_current_generic());
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public void makePopupMenuConditional(final JComponent c, final F0<Boolean> condition) {
    if (c != null && condition != null) {
      swing(new Runnable() {

        public void run() {
          try {
            final componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListeners(), componentPopupMenu_Adapter.class);
            c.removeMouseListener(adapter);
            c.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                if (!callF(condition))
                  adapter.mousePressed(e);
              }

              public void mouseReleased(MouseEvent e) {
                if (!callF(condition))
                  adapter.mouseReleased(e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListener...";
        }
      });
    }
  }

  static public boolean dynamicObjectIsLoading() {
    return isTrue(getThreadLocal(DynamicObject_loading));
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public void rowSorter_setComparators(JTable table, final Object... params) {
    setTableModel_fixSorter.put(table, new VF2<JTable, RowSorter>() {

      public void get(JTable table, RowSorter sorter) {
        try {
          if (sorter instanceof TableRowSorter) {
            for (Pair<Integer, Comparator> p : (List<Pair<Integer, Comparator>>) (List) paramsToPairs(params)) ((TableRowSorter) sorter).setComparator(p.a, p.b);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "//print(\"Fixing table sorter\");\r\n    if (sorter cast TableRowSorter) {\r\n     ...";
      }
    });
  }

  static public void makeAndCall_setInitInThread(Object f) {
    makeAndCall_initChild.set(f);
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public List<String> callTokenizer(Object tokenizer, String s) {
    return (List<String>) callF(tokenizer, s);
  }

  static public String dropStuffBeforeVerticalBar(String s) {
    int i = indexOf(s, '|');
    return i < 0 ? s : substring(s, i + 1);
  }

  static public String multiLineQuote(String s) {
    for (int i = 0; ; i++) {
      String closer = "]" + rep('=', i) + "]";
      if (!contains(s, closer))
        return "[" + rep('=', i) + "[" + s + closer;
    }
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public UnsupportedOperationException unsupportedOperation() {
    throw new UnsupportedOperationException();
  }

  static public boolean isRunnableX(Object o) {
    if (o == null)
      return false;
    if (o instanceof String)
      return hasMethod(mc(), (String) o);
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public String javaxDefaultVMArgs() {
    File fileNew, fileOld;
    String text = loadTextFile(fileNew = javaxDataDir("default-vm-args"));
    if (text == null) {
      text = loadTextFile(fileOld = programFile("#1005850", "default-vm-args"));
      if (text != null)
        moveFile(fileOld, fileNew);
    }
    return trim(unnull(text));
  }

  static public String appendParamsToURL(String url, Map params) {
    return appendQueryToURL(url, params);
  }

  static public String appendParamsToURL(String url, Object... data) {
    return appendQueryToURL(url, data);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public Collection<Concept> findConceptsWhere(String c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFields(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConcepts(concepts.list(c), params);
  }

  static public Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
    return filterConcepts(concepts.list(c), params);
  }

  static public Object subBot_serveJavaScript(String html) {
    return subBot_serveWithContentType(html, "text/javascript");
  }

  static public String dm_require(String moduleLibID) {
    return dm_makeModule(moduleLibID);
  }

  static public JTextArea wrappedTextArea(final JTextArea ta) {
    enableWordWrapForTextArea(ta);
    return ta;
  }

  static public JTextArea wrappedTextArea() {
    return wrappedTextArea(jtextarea());
  }

  static public JTextArea wrappedTextArea(String text) {
    JTextArea ta = wrappedTextArea();
    setText(ta, text);
    return ta;
  }

  static public boolean infoMessage_alwaysOnTop = true;

  static public double infoMessage_defaultTime = 5.0;

  static public JWindow infoMessage(String text) {
    return infoMessage(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage(final String text, final double seconds) {
    printHidingCredentials(text);
    return infoMessage_noprint(text, seconds);
  }

  static public JWindow infoMessage_noprint(String text) {
    return infoMessage_noprint(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage_noprint(final String _text, final double seconds) {
    final String text = hideCredentials(_text);
    if (empty(text))
      return null;
    logQuotedWithDate(infoBoxesLogFile(), text);
    if (isHeadless())
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          final JWindow window = showWindow(infoMessage_makePanel(text));
          window.setSize(300, 150);
          moveToTopRightCorner(window);
          if (infoMessage_alwaysOnTop)
            window.setAlwaysOnTop(true);
          if (vmBus_noObjections("shouldShowInfoBox", window, text))
            window.setVisible(true);
          if (seconds != 0)
            disposeWindowAfter(iround(seconds * 1000), window);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JWindow window = showWindow(infoMessage_makePanel(text));\r\n    window.s...";
      }
    });
  }

  static public JWindow infoMessage(Throwable e) {
    printStackTrace(e);
    return infoMessage(exceptionToStringShort(e));
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public String spaceRoundBracketed(String s) {
    return spacePlusRoundBracketedIfNempty(s);
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public List<String> getPlural_specials = ll("sheep", "fish");

  static public String getPlural(String s) {
    if (containsIgnoreCase(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public <A> String pnlToStringWithEmptyLines(Iterable<A> l) {
    return pnlToString(map(l, o -> o + "\n"));
  }

  static public int toInt_checked(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public String spanTitle(String title, Object contents) {
    return empty(title) ? str(contents) : span(contents, "title", title);
  }

  static public Object[] litObjectArray(Object... l) {
    return l;
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public AutoCloseable tempDBLock(Concepts concepts) {
    return tempLock(concepts.lock);
  }

  static public AutoCloseable tempDBLock() {
    return tempDBLock(db_mainConcepts());
  }

  static public <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
    return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
  }

  static public String psI_str(String snippetID) {
    return str(psI(snippetID));
  }

  static public String loadJQuery2() {
    return "<script src=\"https://code.jquery.com/jquery-3.2.1.min.js\"></script>";
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public List<JComponent> showForm_arrange1(List<List<JComponent>> l) {
    int minW = showForm_leftWidth(l);
    List<JComponent> out = new ArrayList();
    for (List<JComponent> row : l) out.add(westAndCenter(withRightMargin(showForm_gapBetweenColumns, jMinWidthAtLeast(minW, first(row))), second(row)));
    return out;
  }

  static public void hideConsole() {
    final JFrame frame = consoleFrame();
    if (frame != null) {
      autoVMExit();
      swingLater(new Runnable() {

        public void run() {
          try {
            frame.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setVisible(false);";
        }
      });
    }
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  static public boolean machineIsOffline() {
    return isFalse(callF(vmGeneralMap_get("areWeOnline")));
  }

  static public <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  static public <A> Set<A> synchroTreeSet(TreeSet<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public <A> A replaceIfEqual(A a, A b, A c) {
    return eq(a, b) ? c : a;
  }

  static public String codePointToString(int codePoint) {
    return new String(Character.toChars(codePoint));
  }

  static public <A> List<A> childrenOfType(Component c, Class<A> theClass) {
    List<A> l = new ArrayList();
    scanForComponents(c, theClass, l);
    return l;
  }

  static public <A> List<A> childrenOfType(Class<A> theClass, Component c) {
    return childrenOfType(c, theClass);
  }

  static public Concept getConcept(long id) {
    return db_mainConcepts().getConcept(id);
  }

  static public Concept getConcept(Concepts concepts, long id) {
    return concepts.getConcept(id);
  }

  static public <A extends Concept> A getConcept(Class<A> cc, long id) {
    return getConcept(db_mainConcepts(), cc, id);
  }

  static public <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
    Concept c = concepts.getConcept(id);
    if (c == null)
      return null;
    if (!isInstance(cc, c))
      throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
    return (A) c;
  }

  static public List<AbstractButton> buttonsInGroup(ButtonGroup g) {
    if (g == null)
      return ll();
    return asList(g.getElements());
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public <A> A[] itemPlusArray(A a, A[] l) {
    return singlePlusArray(a, l);
  }

  static public String nPosts(long n) {
    return n2(n, "post");
  }

  static public String nPosts(Collection l) {
    return nPosts(l(l));
  }

  static public String nPosts(Map map) {
    return nPosts(l(map));
  }

  static public TokCondition toTokCondition(ITokCondition condition) {
    return condition == null ? null : condition instanceof TokCondition ? (TokCondition) condition : new TokCondition() {

      public boolean get(List<String> tok, int i) {
        return condition.get(tok, i);
      }
    };
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String or2_trim(String a, String b) {
    a = trim(a);
    if (nempty(a))
      return a;
    return trim(b);
  }

  static public String or2_trim(String a, String b, String c) {
    return or2_trim(or2_trim(a, b), c);
  }

  static public <A> A lastThat(List<A> l, Object pred) {
    for (int i = l(l) - 1; i >= 0; i--) {
      A a = l.get(i);
      if (checkCondition(pred, a))
        return a;
    }
    return null;
  }

  static public <A> A lastThat(Object pred, List<A> l) {
    return lastThat(l, pred);
  }

  static public <A> A lastThat(IF1<A, Boolean> pred, List<A> l) {
    return lastThat((Object) pred, l);
  }

  static public <A> A lastThat(List<A> l, IF1<A, Boolean> pred) {
    return lastThat(pred, l);
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public String targetBlank(String link, Object contents, Object... params) {
    return hrefBlank(link, contents, params);
  }

  static public boolean isCurlyBraced(String s) {
    List<String> tok = tok_combineCurlyBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "{", "}");
  }

  static public void setComponentID(Component c, String id) {
    if (c != null)
      componentID_map.put(c, id);
  }

  static public String b(Object contents, Object... params) {
    return tag("b", contents, params);
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public double doubleRatio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public void closeRandomAccessFile(RandomAccessFile f) {
    if (f != null)
      try {
        f.close();
        callJavaX("dropIO", f);
      } catch (Throwable e) {
        printStackTrace(e);
      }
  }

  static public String i(String s, Object... params) {
    return tag("i", s, params);
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public List<String> javaTokPlusBrackets2(String s) {
    return tok_combineRoundCurlySquareBrackets_keep(javaTok(s));
  }

  static public String p(Object contents, Object... params) {
    return hfulltag("p", contents, params) + "\n";
  }

  static public String p() {
    return p("");
  }

  static public <A> List<A> reverseInPlace(List<A> l) {
    return reverseList(l);
  }

  static public String nChanges(long n) {
    return n2(n, "change");
  }

  static public String nChanges(Collection l) {
    return nChanges(l(l));
  }

  static public GlobalID asGlobalID(String id) {
    return id == null ? null : new GlobalID(id);
  }

  static public <A> A reverseGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    int n = l(l);
    return idx < n ? l.get(n - 1 - idx) : null;
  }

  static public List<String> listZipFile(File inZip) {
    try {
      ZipFile zipFile = new ZipFile(inZip);
      try {
        return listZipFile(zipFile);
      } finally {
        zipFile.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> listZipFile(ZipFile zipFile) {
    try {
      List<String> list = new ArrayList();
      Enumeration entries = zipFile.entries();
      while (entries.hasMoreElements()) {
        ZipEntry entry = (ZipEntry) entries.nextElement();
        if (!entry.isDirectory())
          list.add(entry.getName());
      }
      return list;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> listZipFile(String name) {
    if (isSnippetID(name))
      return listZipFile(loadLibrary(name));
    return listZipFile(getProgramFile(name));
  }

  static public <A extends Concept> Pair<A, Boolean> uniq2(Class<A> c, Object... params) {
    return uniq2(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Pair<A, Boolean> uniq2(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
        return pair(x, true);
      }
      return pair(x, false);
    } finally {
      _close(__1);
    }
  }

  static public String copyTextToClipboard(Object _text) {
    String text = str(_text);
    StringSelection selection = new StringSelection(text);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    vmBus_send("newClipboardContents", text);
    return text;
  }

  static public List<String> tok_splitAtAsterisk(String s) {
    return tok_splitAtAsterisk(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtAsterisk(List<String> tok) {
    return splitAtTokens(tok, "*");
  }

  static public <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public JComponent wrap(Object swingable) {
    return _recordNewSwingComponent(wrap_2(swingable));
  }

  static public JComponent wrap_2(Object swingable) {
    if (swingable == null)
      return null;
    JComponent c;
    if (swingable instanceof Component)
      c = componentToJComponent((Component) swingable);
    else
      c = componentToJComponent((Component) callOpt(swingable, "swing"));
    if (c instanceof JTable || c instanceof JList || c instanceof JTextArea || c instanceof JEditorPane || c instanceof JTextPane || c instanceof JTree)
      return jscroll(c);
    return c == null ? jlabel(str(swingable)) : c;
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public String addParamToURL(String url, Map params) {
    return appendQueryToURL(url, params);
  }

  static public String addParamToURL(String url, Object... data) {
    return appendQueryToURL(url, data);
  }

  static public boolean isJavaxModuleSnippetType(int type) {
    return type == snippetType_javaxModule() || type == snippetType_javaxDesktopModule();
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public Boolean trueOrNull(Boolean b) {
    return eq(b, false) ? null : b;
  }

  static public boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  static public boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  static public boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public void interruptThreads(Collection<Thread> threads) {
    for (Thread t : unnull(threads)) interruptThread(t);
  }

  static public void interruptThreads(Class mainClass) {
    interruptThreads(registeredThreads(mainClass));
  }

  static public List<File> hotwire_collectJars(File jar) {
    List<String> libIDs = hotwire_libraryIDsFromJar_deleteJarOnFail(jar);
    List<File> files = ll(jar);
    for (String libID : libIDs) files.add(loadLibraryOrSrcLib(libID));
    return files;
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public void markAsSrcLib(String snippetID) {
    saveTextFile(javaxCodeDir("srclibs/" + psI(snippetID)), "");
  }

  static public void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  static public String jsDropTrailingComments(String s) {
    return javaTokDropTrailingN(s);
  }

  static public void containerAddFirst(final Container c, final Component... l) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            for (int i = 0; i < l(l); i++) c.add(l[i], i);
            revalidate(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (int i = 0; i < l(l); i++)\r\n      c.add(l[i], i);\r\n    revalidate(c);";
        }
      });
    }
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(MultiMap mm) {
    return mm == null || mm.isEmpty();
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public boolean empty(Rect r) {
    return !(r != null && r.w != 0 && r.h != 0);
  }

  static public boolean empty(Chain c) {
    return c == null;
  }

  static public void cancelAndInterruptThread(Thread t) {
    if (t == null)
      return;
    cancelThread(t);
    t.interrupt();
  }

  static public <A> A oneOf(List<A> l) {
    return empty(l) ? null : l.get(new Random().nextInt(l.size()));
  }

  static public char oneOf(String s) {
    return empty(s) ? '?' : s.charAt(random(l(s)));
  }

  static public String oneOf(String... l) {
    return oneOf(asList(l));
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public <A> List<Pair<A, A>> paramsToPairs(A... params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToPairs((Map) params[0]);
    List<Pair<A, A>> l = emptyList(l(params) / 2);
    for (int i = 0; i + 1 < l(params); i += 2) l.add(pair(params[i], params[i + 1]));
    return l;
  }

  static public int withMargin_defaultWidth = 6;

  static public JPanel withMargin(Component c) {
    return withMargin(withMargin_defaultWidth, c);
  }

  static public JPanel withMargin(int w, Component c) {
    return withMargin(w, w, c);
  }

  static public JPanel withMargin(int w, int h, Component c) {
    return withMargin(w, h, w, h, c);
  }

  static public JPanel withMargin(final int top, final int left, final int bottom, final int right, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public <A> List<A> syncCloneAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> l2 = cloneList(l);
      l.clear();
      return l2;
    }
  }

  static public boolean containsAngleBracketVars(String s) {
    List<String> tok = javaTokWithAngleBrackets(s);
    return nempty(indicesOfAngleBracketVars(tok));
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm) {
    return navigableMultiSetMapValuesIterator_concurrent(mm, mm.data);
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm, Object mutex) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data, mutex);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return db_mainConcepts().list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public boolean hasMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args) != null;
  }

  static public KeyListener enterKeyListener(final Object action) {
    return new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == KeyEvent.VK_ENTER)
          pcallF(action);
      }
    };
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static public java.lang.management.OperatingSystemMXBean osMXBean() {
    return ManagementFactory.getOperatingSystemMXBean();
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] dropEntryFromParams(Object[] params, int i) {
    int n = l(params);
    if (i < 0 || i >= n)
      return params;
    if (n == 2)
      return null;
    Object[] p = new Object[n - 2];
    System.arraycopy(params, 0, p, 0, i);
    System.arraycopy(params, i + 2, p, i, n - i - 2);
    return p;
  }

  static public boolean cic(Collection<String> l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(Collection<Symbol> l, Symbol s) {
    return contains(l, s);
  }

  static public boolean cic(String[] l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(String s, char c) {
    return containsIgnoreCase(s, c);
  }

  static public boolean cic(String a, String b) {
    return containsIgnoreCase(a, b);
  }

  static public Object hotwire_onCompile;

  static public boolean hotwire_serially = false;

  static public Lock hotwire_overInternalBot_lock = lock();

  static public boolean hotwire_compileOnServer = false;

  static public Class<?> hotwire_overInternalBot(String progID) {
    return hotwire_overInternalBot(progID, "main");
  }

  static public Class<?> hotwire_overInternalBot(String progID, String mainClass) {
    return hotwire_overInternalBot(progID, __ -> mainClass);
  }

  static public Class<?> hotwire_overInternalBot(String progID, IF1<ClassLoader, String> calculateMainClass) {
    try {
      Pair<File, String> p;
      try {
        p = hotwire_compile(progID);
      } catch (Throwable e) {
        throw rethrow("Error hotwiring " + progID, e);
      }
      File jar = p.a;
      assertTrue(jar.getAbsolutePath(), jar.isFile());
      List<File> files = hotwire_collectJars(jar);
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      classLoader.progID = progID;
      String mainClass = calculateMainClass == null ? "main" : calculateMainClass.get(classLoader);
      return hotwire_finish(classLoader, progID, p.b, mainClass);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Pair<File, String> hotwire_compile(String progID) {
    Pair<File, String> p = hotwire_compileOnServer && !isLocalSnippetID(progID) ? compileSnippetThroughServer(progID) : CompilerBot.compileSnippet2(progID);
    Lock __0 = hotwire_serially ? hotwire_overInternalBot_lock : null;
    lock(__0);
    try {
      callF(hotwire_onCompile, p);
      return p;
    } finally {
      unlock(__0);
    }
  }

  static public String stringUnless(boolean b, String s) {
    return b ? "" : s;
  }

  static public <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }
    }
    ;
    return new IFF2();
  }

  static public JFrame setFrameIconLater(Component c, final String imageID) {
    final JFrame frame = getFrame(c);
    if (frame != null)
      startThread("Loading Icon", new Runnable() {

        public void run() {
          try {
            final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
            swingLater(new Runnable() {

              public void run() {
                try {
                  frame.setIconImage(i);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "frame.setIconImage(i);";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Image i = imageIcon(or2(imageID, \"#1005557\")).getImage();\r\n      swingL...";
        }
      });
    return frame;
  }

  static public String getTranspiledStandardFunctionsIfCached(TreeSet<String> functionSet) {
    try {
      File f = transpiledStandardFunctions_file(functionSet);
      return loadTextFile(f);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public <A> void remove(List<A> l, int i) {
    if (l != null && i >= 0 && i < l(l))
      l.remove(i);
  }

  static public <A> void remove(Collection<A> l, A a) {
    if (l != null)
      l.remove(a);
  }

  static public <A, B> B remove(Map<A, B> map, Object a) {
    return map == null ? null : map.remove(a);
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public String ymd_minus_hm() {
    return ymd() + "-" + hhmm();
  }

  static public com.sun.management.OperatingSystemMXBean advancedOSMXBean() {
    return optCast(com.sun.management.OperatingSystemMXBean.class, osMXBean());
  }

  static public Collection<Concept.Ref> scanConceptForRefs(Concept c) {
    Set<Concept.Ref> refs = new HashSet();
    if (c != null)
      for (Object o : values(objectToMap(c))) {
        if (o instanceof Concept.Ref)
          refs.add((Concept.Ref) o);
        else if (o instanceof Concept.RefL)
          addAll(refs, ((Concept.RefL) o).l);
      }
    return refs;
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public JFrame showPackedFrame(String title, Component contents) {
    return packFrame(showFrame(title, contents));
  }

  static public JFrame showPackedFrame(Component contents) {
    return packFrame(showFrame(contents));
  }

  static public JPanel jpanel(LayoutManager layout) {
    return swingNu(JPanel.class, layout);
  }

  static public JPanel jpanel() {
    return swingNu(JPanel.class);
  }

  static public String hselect(String name, Map map, Object... params) {
    return hselect(map, paramsPlus_skipFirst(params, "name", name));
  }

  static public String hselect(Map map, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(map))
      for (Object key : keys(map)) {
        Object value = map.get(key);
        String k = str(key);
        buf.append(tag("option", htmlencode(str(or(value, ""))), "value", k, "selected", eq(selected, k) ? "selected" : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public String firstToken(String s) {
    return firstJavaToken(s);
  }

  static public String firstToken(List<String> tok) {
    return get(tok, 1);
  }

  static public <A> Set<A> joinSets(Collection<A>... l) {
    Set<A> set = similarEmptySet(first(l));
    for (Collection<A> o : l) if (o != null)
      set.addAll(o);
    return set;
  }

  static public String htitle_noEncode(String title) {
    return tag("title", title);
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public Collection<Concept> conceptsWhere(String c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public List dm_listStems() {
    return (List) dm_callOS("onModules");
  }

  static public Integer find3_levenWithSwapsDistance(String pat, String input) {
    List<String> tokPat = parse3_cachedPattern(pat);
    List<String> tok = parse3_cachedInput(input);
    int end = tok.size() - tokPat.size() + 1;
    Integer min = null;
    for (int idx = 0; idx < end; idx += 2) {
      int score = 0;
      for (int i = 1; i < tokPat.size(); i += 2) {
        String p = tokPat.get(i), t = tok.get(idx + i);
        score += levenWithSwapsIC(p, t);
      }
      min = min_withNull(min, score);
    }
    return min;
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public String dm_makeModule(String moduleLibID) {
    return (String) dm_callOS("makeModule", moduleLibID);
  }

  static public int showForm_leftWidth_safetyMargin = 10;

  static public int showForm_leftWidth(List<List<JComponent>> l) {
    forEachLevel2(l, x -> vmBus_send("updateLayoutNow", x));
    int minW = 0;
    for (List<JComponent> row : l) minW = max(minW, getMinimumSize(first(row)).width);
    return minW + or((Integer) vmBus_query("formSafetyMargin"), showForm_leftWidth_safetyMargin);
  }

  static public int toIntPercent(double ratio) {
    return roundToInt(ratio * 100);
  }

  static public int toIntPercent(float ratio) {
    return toIntPercent((double) ratio);
  }

  static public String containerTag(String tag) {
    return containerTag(tag, "");
  }

  static public String containerTag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    return openingTag + s + "</" + tag + ">";
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public <A extends Concept> A conceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(c, params);
  }

  static public <A extends Concept> A conceptWhere(Concepts cc, Class<A> c, Object... params) {
    return findConceptWhere(cc, c, params);
  }

  static public List collectSorted(Iterable c, String field) {
    return sorted(collect(c, field));
  }

  static public List collectSorted(String field, Iterable c) {
    return collectSorted(c, field);
  }

  static public StringBuilder stringBuilder(String s) {
    return new StringBuilder(unnull(s));
  }

  static public String regexpCaseInsensitivePrefix() {
    return "(?i)";
  }

  static public List<String> tok_identifiersInOrder(String s) {
    return filter(__74 -> isIdentifier(__74), javaTokC(s));
  }

  static public List<String> tok_identifiersInOrder(List<String> tok) {
    return filter(__75 -> isIdentifier(__75), codeTokens(tok));
  }

  static public boolean getSnippetTitles_verbose = false;

  static public Map<String, String> getSnippetTitles(Collection<String> ids) {
    try {
      if (empty(ids))
        return new HashMap();
      String url = tb_mainServer() + "/tb-int/get-titles.php";
      String ids2 = join(" ", parseSnippetIDs(ids));
      return trimValues(transformKeys(jsonDecodeMap(doPost(mapPlus(standardCredentialsMap(), "ids", ids2), url)), new F1<String, Object>() {

        public Object get(String id) {
          try {
            return fsI(id);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "fsI(id)";
        }
      }));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A grabValueAndCancel(VF1<VF1<A>> r) {
    Var<A> var = new Var();
    withCancelPoint(new VF1<CancelPoint>() {

      public void get(CancelPoint cp) {
        try {
          callF(r, new VF1<A>() {

            public void get(A a) {
              try {
                var.set(a);
                cancelTo(cp);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "var.set(a); cancelTo(cp)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, voidfunc(A a) { var.set(a); cancelTo(cp) });";
      }
    });
    return var.get();
  }

  static public JButton jPopDownButton_noText(final Object... menuParams) {
    return toolTip("Additional commands", jPopDownButton("", menuParams));
  }

  static public String hhead_title(String title) {
    return hhead(htitle(title));
  }

  static public void printShortException(Throwable e) {
    print(exceptionToStringShort(e));
  }

  static public void printShortException(String s, Throwable e) {
    print(s, exceptionToStringShort(e));
  }

  static public String hcrud_mergeTables(String table1, String table2, String connector) {
    List<String> tok1 = htmlTok(table1), tok2 = htmlTok(table2);
    List<String> tbl1 = first(findContainerTag(tok1, "table"));
    List<String> tbl2 = first(findContainerTag(tok2, "table"));
    if (tbl1 == null)
      return table2;
    if (tbl2 == null)
      return table1;
    List<List<String>> rows1 = findContainerTag(tbl1, "tr");
    List<List<String>> rows2 = findContainerTag(tbl2, "tr");
    print("rows1: " + l(rows1) + ", rows2: " + l(rows2));
    int nRows = max(l(rows1), l(rows2));
    List<String> rows = new ArrayList();
    for (int i = 0; i < nRows; i++) {
      List<String> row1 = dropFirstTwoAndLastTwo(get(rows1, i));
      List<String> row2 = dropFirstTwoAndLastTwo(get(rows2, i));
      row2 = dropFirst(row2, indexOfIC(row2, "</td>") + 1);
      rows.add(tr(join(concatLists(row1, ll(td(connector)), row2))));
    }
    replaceTokens(tbl1, 2, l(tbl1) - 2, lines(rows));
    return join(tok1);
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public List<String> javaTokNPunctuation_plusAsterisk(String s) {
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      int j = i;
      String t;
      while (j < l(tok) && l(t = tok.get(j)) == 1 && !Character.isLetterOrDigit(t.charAt(0)) && t.charAt(0) != '*') j += 2;
      if (j > i)
        replaceSubList(tok, i - 1, j, ll(joinSubList(tok, i - 1, j)));
    }
    return tok;
  }

  static public String[] asStringArray(Collection<String> c) {
    return toStringArray(c);
  }

  static public String[] asStringArray(Object o) {
    return toStringArray(o);
  }

  static public void swingLater(long delay, final Object r) {
    javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
    timer.setRepeats(false);
    timer.start();
  }

  static public void swingLater(Object r) {
    SwingUtilities.invokeLater(toRunnable(r));
  }

  static public String dropTrailingSlash(String s) {
    return dropSuffix("/", s);
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Class<A> type, Iterable<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      return classForName(name, classFinder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String tok_unCurlyBracket(String s) {
    return isCurlyBraced(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public void dbIndexing(Object... params) {
    db();
    indexConceptFields(params);
  }

  static public <A extends Concept> A findConceptWhereCI(Class<A> c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    Lowest<IF0<Collection<A>>> bestIndex = new Lowest();
    if (concepts.ciFieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        ping();
        Object val = params[i + 1];
        IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> l = index.getAll(val);
          bestIndex.put(() -> l, l(l));
        }
        if (concepts.useBackRefsForSearches && val instanceof Concept) {
          bestIndex.put(() -> findBackRefs(((Concept) val), c), ((Concept) val)._backRefCount());
        }
      }
    if (bestIndex.has()) {
      Collection<A> l = bestIndex.get().get();
      if (l(params) == 2)
        return first(l);
      for (A x : l) {
        ping();
        if (checkConceptFieldsIC(x, params))
          return x;
      }
      return null;
    } else {
      for (A x : concepts.list(c)) {
        ping();
        if (checkConceptFieldsIC(x, params))
          return x;
      }
      return null;
    }
  }

  static public Concept findConceptWhereCI(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) {
      ping();
      if (checkConceptFieldsIC(x, params))
        return x;
    }
    return null;
  }

  static public void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> text_multipleChoiceSplit(String input, String multipleChoiceSeparator) {
    return trimAll(splitAt(input, dropSpaces(multipleChoiceSeparator)));
  }

  static public String gtt(JTextComponent c) {
    return getTextTrim(c);
  }

  static public String gtt(JComboBox cb) {
    return getTextTrim(cb);
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public Object[] html_massageAutofocusParam(Object[] params) {
    Object autofocus = optPar("autofocus", params);
    return changeParam(params, "autofocus", eqOneOf(autofocus, html_valueLessParam(), true, 1, "1", "autofocus") ? html_valueLessParam() : null);
  }

  static public boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  static public String defaultTimerName_name;

  static public String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  static public long toK(long l) {
    return (l + 1023) / 1024;
  }

  static public long toM(long l) {
    return (l + 1024 * 1024 - 1) / (1024 * 1024);
  }

  static public String toM(long l, int digits) {
    return formatDouble(toM_double(l), digits);
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public boolean even(BigInteger n) {
    return even(n.intValue());
  }

  static public Object dm_callModule(Object moduleOrID, String method, Object... args) {
    Object mod = dm_getModule(moduleOrID);
    if (mod == null)
      return null;
    AutoCloseable __1 = dm_enter(mod);
    try {
      return call(mod, method, args);
    } finally {
      _close(__1);
    }
  }

  static public void logStructure(File logFile, Object o) {
    logQuoted(logFile, structure(o));
  }

  static public void logStructure(String fileName, Object o) {
    logStructure(getProgramFile(fileName), o);
  }

  static public void logStructure(String progID, String fileName, Object o) {
    logStructure(getProgramFile(progID, fileName), o);
  }

  static public void dm_assertFirstSibling() {
    if (!dm_isFirstSiblingModule(dm_current_mandatory_generic()))
      throw fail("Don't start this module (" + dm_moduleLibID() + ") multiple times. This instance will exit.");
  }

  static public boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  static public boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  static public boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public String hstyle_sourceCodeLikeInRepo() {
    return "padding-left: 1em; padding-top: 0.5em; padding-bottom: 0.5em; background-color: #EEEEEE; border-style: solid; border-color: #666666; border-width: 1px 0px 1px 0px;";
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping() {
    newPing();
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void printNumberedLines(Map map) {
    printNumberedLines(mapToLines(map));
  }

  static public void printNumberedLines(String prefix, Map map) {
    printNumberedLines(prefix, mapToLines(map));
  }

  static public <A extends Iterable> A printNumberedLines(A l) {
    int i = 0;
    if (l != null)
      for (Object a : l) print((++i) + ". " + str(a));
    return l;
  }

  static public <A extends Iterable> A printNumberedLines(String prefix, A l) {
    int i = 0;
    if (l != null)
      for (Object a : l) print(prefix + (++i) + ". " + str(a));
    return l;
  }

  static public void printNumberedLines(Object[] l) {
    printNumberedLines("", l);
  }

  static public void printNumberedLines(String prefix, Object[] l) {
    printNumberedLines(prefix, asList(l));
  }

  static public void printNumberedLines(Object o) {
    printNumberedLines(lines(str(o)));
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public <A> A setFrameTitle(A c, final String title) {
    final Frame f = getAWTFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(title);";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A setFrameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public JFrame setFrameTitle(String title) {
    Object f = getOpt(mc(), "frame");
    if (f instanceof JFrame)
      return setFrameTitle((JFrame) f, title);
    return null;
  }

  static public boolean _eq(Object a, Object b) {
    return eq(a, b);
  }

  static public String formatDateAndTime(long timestamp) {
    return formatDate(timestamp);
  }

  static public String formatDateAndTime() {
    return formatDate();
  }

  static public List mapNonCodeTokens(Object f, List l) {
    List out = emptyList(l);
    for (int i = 0; i < l(l); i++) {
      Object o = l.get(i);
      out.add(even(i) ? callF(f, o) : o);
    }
    return out;
  }

  static public List mapNonCodeTokens(List l, Object f) {
    return mapNonCodeTokens(f, l);
  }

  static public List<String> mapNonCodeTokens(List<String> tok, IF1<String, String> f) {
    return mapNonCodeTokens(tok, (Object) f);
  }

  static public List<String> mapNonCodeTokens(IF1<String, String> f, List<String> tok) {
    return mapNonCodeTokens(tok, f);
  }

  static public int getScreenWidth() {
    return getScreenSize().width;
  }

  static public String formatFunctionCall(String fname, Object... args) {
    return fname + "(" + joinWithComma(allToString(args)) + ")";
  }

  static public String formatFunctionCall(String fname, List args) {
    return formatFunctionCall(fname, toObjectArray(args));
  }

  static public boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 1 / 12.0)
      return true;
    if (age <= 0.5 && age >= lastAge + 1 / 12.0)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age <= 28 && age >= lastAge + 7)
      return true;
    if (age >= lastAge + 365.0 / 12)
      return true;
    return false;
  }

  static public String ahref_onClick(String js, Object contents, Object... params) {
    return ahref_js(js, contents, params);
  }

  static public String defaultVMArgs() {
    return javaxDefaultVMArgs();
  }

  static public String localDateWithSeconds(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
    return format.format(time);
  }

  static public String localDateWithSeconds() {
    return localDateWithSeconds(now());
  }

  static public int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  static public Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  static public Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  static public Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public <A extends Concept> int countConceptsCI(Concepts cc, Class<A> c, Object... params) {
    if (empty(params))
      return countConcepts(cc, c);
    return l(conceptsWhereCI(cc, c, params));
  }

  static public <A extends Concept> int countConceptsCI(Class<A> c, Object... params) {
    return countConceptsCI(db_mainConcepts(), c, params);
  }

  static public List<String> tok_combineAngleBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "<")) {
        int j = findEndOfAngleBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public String[] flattenStringArray2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof String[])
        l.addAll(asList((String[]) x));
      else if (x instanceof Collection)
        l.addAll((Collection) x);
      else
        l.add(x);
    return asStringArray(l);
  }

  static public String div_center(Object contents, Object... __) {
    return hcenter3(contents, __);
  }

  static public Object safeUnstructureAllowingClasses(String s, Class... allowedClasses) {
    final Set<String> allowedClassesSet = mapToSet(__76 -> className(__76), allowedClasses);
    Object classFinder = new F1<String, Object>() {

      public Object get(String name) {
        try {
          if (!allowedClassesSet.contains(name))
            throw fail("Class not allowed to unstructure: " + name);
          return classForName(name);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (!allowedClassesSet.contains(name)) fail(\"Class not allowed to unstructure...";
      }
    };
    return unstructure(s, false, classFinder);
  }

  static public Object getConsoleTextArea_gen() {
    return getOpt(get(getJavaX(), "console"), "textArea");
  }

  static public List<List<String>> ai_spreadCertainIndices_2(List<String> tokPat, List<String> tokS, List<Integer> indices) {
    int extra = (l(tokS) - l(tokPat)) / 2;
    if (extra < 0 || empty(indices))
      return emptyList();
    List<List<String>> results = new ArrayList();
    for (List<Integer> spread : allSpreads(extra, l(indices))) {
      List<String> tok = new ArrayList();
      int pos = 0, iSpread = 0, iIndices = 0;
      for (int i = 0; i < l(tokPat); i++) if (!eq(get(indices, iIndices), i))
        tok.add(tokS.get(pos++));
      else {
        ++iIndices;
        int take = spread.get(iSpread++) * 2;
        tok.add(joinSubList(tokS, pos, pos + take + 1));
        pos += take + 1;
      }
      results.add(tok);
    }
    return results;
  }

  static public boolean isJavaxCompilableSnippetTypeExceptInclude(int type) {
    return isJavaxApplicationSnippetType(type) || isJavaxModuleSnippetType(type) || type == snippetType_dynModule();
  }

  static public String htmlEncode(String s) {
    return htmlencode(s);
  }

  static public <A> Chain<A> chainPlus(Chain<A> chain, A a) {
    return new Chain<A>(a, chain);
  }

  static public <A> ReverseChain<A> chainPlus(ReverseChain<A> chain, A a) {
    return new ReverseChain<A>(chain, a);
  }

  static public String divUnlessEmpty(String s, Object... params) {
    return empty(s) ? "" : div(s, params);
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public <A, B> void putIfNotThere(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null && !map.containsKey(key))
      map.put(key, value);
  }

  static public String renderDBLoadTime() {
    return renderDBLoadTime(db_mainConcepts());
  }

  static public String renderDBLoadTime(Concepts cc) {
    if (cc == null)
      return null;
    return cc.loadTook < 0 ? "unknown" : n2(cc.loadTook) + " ms";
  }

  static public long raf_findBeginningOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      while (pos > 0) {
        long start = Math.max(pos - bufSize, 0);
        raf.seek(start);
        raf.readFully(buf, 0, (int) Math.min(pos - start, bufSize));
        int idx = lastIndexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return start + idx + 1;
        pos = start;
      }
      return 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<A, B> applyFunctionToMapValue(A key, Object f, Map<A, B> map) {
    if (map.containsKey(key))
      map.put(key, (B) callF(f, map.get(key)));
    return map;
  }

  static public String afterLastSlash(String s) {
    if (s == null)
      return null;
    int i = s.lastIndexOf('/');
    return i < 0 ? s : substring(s, i + 1);
  }

  static public GlobalID aGlobalIDObjUnlessLoading() {
    return dynamicObjectIsLoading() ? null : aGlobalIDObj();
  }

  static public <A extends Concept> Pair<A, Boolean> uniqCI2(Class<A> c, Object... params) {
    return uniqCI2(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Pair<A, Boolean> uniqCI2(Concepts cc, Class<A> c, Object... params) {
    params = expandParams(c, params);
    A x = findConceptWhereCI(cc, c, params);
    if (x == null) {
      x = unlisted(c);
      csetAll(x, params);
      cc.register(x);
      return pair(x, true);
    }
    return pair(x, false);
  }

  static public String getSnippetTitle(String id) {
    if (id == null)
      return null;
    if (!isSnippetID(id))
      return "?";
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getSnippetTitle(id);
    return getSnippetTitle_noResourceLoader(id);
  }

  static public String getSnippetTitle_noResourceLoader(String id) {
    try {
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public String js_setRedirect() {
    return "$('input[name=redirect]').val(window.location.toString());";
  }

  static public <A> VF1<A> ivf1ToVF1(IVF1<A> f) {
    return f == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          f.get(a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "f.get(a)";
      }
    };
  }

  static public <A> List<A> synchroLinkedList() {
    return Collections.synchronizedList(new LinkedList<A>());
  }

  static public Type type_LS() {
    return new ParameterizedTypeImpl(null, List.class, String.class);
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public int formLayouter1_yPlus = 5;

  static public int formLayouter1_fixer2 = 0;

  static public F1<Container, Dimension> formLayouter1() {
    final int yplus = formLayouter1_yPlus, fixer2 = formLayouter1_fixer2;
    return new F1<Container, Dimension>() {

      public Dimension get(Container parent) {
        try {
          List<Component> l = getComponents(parent);
          BitSet bigOnes = new BitSet();
          for (int i = 0; i < l(l); i++) if (containsATextArea(l.get(i)))
            add(bigOnes, i);
          int nBigOnes = bigOnes.cardinality();
          int mandatoryHeight = totalPreferredHeight(listWithoutIndicesInBitSet(l, bigOnes));
          int gap = 4, outerSpacing = 5;
          Dimension size = parent.getSize();
          int gapsAndMargins = outerSpacing * 2 - (l(l) - 1) * gap;
          int totalSpace = size.height - gapsAndMargins - fixer2;
          int liberalSpace = totalSpace - mandatoryHeight;
          double perBigOne = doubleRatio(liberalSpace, nBigOnes);
          double y = outerSpacing;
          for (int i = 0; i < l(l); i++) {
            Component c = l.get(i);
            boolean big = contains(bigOnes, i);
            double h = big ? perBigOne : c.getPreferredSize().height;
            int actualY = iround(y);
            c.setBounds(10, actualY, size.width - outerSpacing * 2, iround(y + h) - actualY);
            y += h + gap;
          }
          Dimension pref = componentsBoundingSize(parent, outerSpacing);
          if (parent.getHeight() <= 0) {
            int tph = totalPreferredHeight(l);
            pref.height = tph + gapsAndMargins + yplus;
          }
          return pref;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "L<Component> l = getComponents(parent);\r\n    new BitSet bigOnes;\r\n    for i o...";
      }
    };
  }

  static public Map<String, List<String>> javaTokWithAllBrackets_cached_cache = synchronizedMRUCache(defaultTokenizerCacheSize());

  static public List<String> javaTokWithAllBrackets_cached(String s) {
    List<String> tok = javaTokWithAllBrackets_cached_cache.get(s);
    if (tok == null)
      javaTokWithAllBrackets_cached_cache.put(s, tok = javaTokWithAllBrackets(s));
    return tok;
  }

  static public List<String> unquoteAll(List<String> l) {
    List<String> t = cloneList(l);
    for (int i = 0; i < l(t); i++) if (isQuoted(t.get(i)))
      t.set(i, unquote(t.get(i)));
    return t;
  }

  static public boolean tok_tokenBeforeLonelyReturnValue(List<String> tok, int i) {
    String t = get(tok, i);
    if (l(t) == 1 && "{};".contains(t) || eq(t, "else"))
      return true;
    if (!eq(t, ")"))
      return false;
    int level = 0;
    while (i > 0) {
      if (eq(tok.get(i), ")"))
        ++level;
      if (eq(tok.get(i), "("))
        --level;
      if (level == 0)
        return eq(get(tok, i - 2), "if");
      i -= 2;
    }
    return false;
  }

  static public String joinStrings(String sep, Object... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Iterable strings) {
    StringBuilder buf = new StringBuilder();
    for (Object o : unnull(strings)) {
      String s = strOrNull(o);
      if (nempty(s)) {
        if (nempty(buf))
          buf.append(sep);
        buf.append(s);
      }
    }
    return str(buf);
  }

  static public List<String> getJavaModifiers_list = litlist("static", "abstract", "public", "private", "protected", "final", "native", "volatile", "synchronized", "transient");

  static public List<String> getJavaModifiers() {
    return getJavaModifiers_list;
  }

  static public <A, B> boolean isEitherB(Either<A, B> e) {
    return eitherIsB(e);
  }

  static public void replaceACCInClassLoader(Object o, AccessControlContext newACC) {
    ClassLoader cl = getClassLoaderOrSame(o);
    if (cl instanceof URLClassLoader) {
      try {
        setOpt(cl, "acc", newACC);
        try {
          setOpt((Object) getOpt(cl, "ucp"), "acc", newACC);
        } catch (Throwable e) {
          printShortException("replaceACCInClassLoader: ", e);
          if (java10OrHigher())
            if (addDefaultVMOption("--add-opens java.base/jdk.internal.loader=ALL-UNNAMED"))
              print("Please restart the OS");
        }
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public File localMechListFile(String listName) {
    return newFile(localMechListsDir(), uniqueFileNameUsingMD5_80_v2(listName) + ".text");
  }

  static public String dropTags(String html) {
    return dropAllTags(html);
  }

  static public List<String> dropTags(List<String> tok) {
    return dropAllTags(tok);
  }

  static public void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  static public <A, B> Map<A, B> withoutKey(Map<A, B> map, A key) {
    return mapWithoutKey(map, key);
  }

  static public <A, B> Map<A, B> withoutKey(A key, Map<A, B> map) {
    return withoutKey(map, key);
  }

  static public DynModule dm_currentModuleMandatory() {
    return dm_current_mandatory();
  }

  static public boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  static public boolean containsClosingBracket(List<String> l) {
    return any(__77 -> isClosingBracket(__77), l);
  }

  static public <A> int syncLengthLevel2(Collection<? extends Collection> l) {
    int sum = 0;
    for (Collection c : cloneList(l)) sum += syncL(c);
    return sum;
  }

  static public String roundBracket(String s) {
    return "(" + s + ")";
  }

  static public String roundBracket(Object s) {
    return roundBracket(str(s));
  }

  static public <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
    List<A> l = tl.get();
    if (l == null)
      tl.set(l = new ArrayList());
    l.add(a);
  }

  static public String pageNav2(String baseLink, int count, int value, int step, String nVar, Object... __) {
    List<String> l = new ArrayList();
    baseLink = unnull(baseLink) + (contains(baseLink, "?") ? "&" : "?") + urlencode(nVar) + "=";
    if (value > 0)
      l.add(ahref(baseLink + max(0, value - step), stringPar("leftArrow", __, htmlencode(unicode_leftPointingTriangle()))));
    for (int i = 0; i < count; i += step) {
      int n = i / step + 1;
      if (pageNav2_showPage(value, i, step, count))
        if (value == i)
          l.add(b(n));
        else
          l.add(ahref(baseLink + i, n));
    }
    if (value + step < count)
      l.add(ahref(baseLink + (value + step), stringPar("rightArrow", __, htmlencode(unicode_rightPointingTriangle()))));
    return p("Pages: " + lines(l));
  }

  static public boolean pageNav2_showPage(int actual, int i, int step, int count) {
    int diff = abs(actual - i) / step;
    return i == 0 || i >= (count - 1) / step * step || diff <= 10 || diff <= 100 && ((i / step) % 10) == 9 || diff <= 1000 && ((i / step) % 100) == 99 || ((i / step) % 1000) == 999;
  }

  static public List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  static public JCheckBox dm_fieldCheckBox(String field) {
    return dm_fieldCheckBox(humanizeFormLabel(field), field);
  }

  static public JCheckBox dm_fieldCheckBox(String text, String field) {
    if (isIdentifier(text) && !isIdentifier(field)) {
      String temp = field;
      field = text;
      text = temp;
    }
    return jLiveValueCheckBox(text, dm_fieldLiveValue(field));
  }

  static public <A> Collection<A> concatCollections_conservative(Collection<A> a, Collection<A> b) {
    if (empty(a))
      return b;
    if (empty(b))
      return a;
    return concatLists(a, b);
  }

  static public String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  static public <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  static public String joinWithBR(Iterable l) {
    return join("<br>\n", l);
  }

  static public String joinWithBR(String... l) {
    return joinWithBR(asList(l));
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public void cancelThread(Thread t) {
    if (t == null)
      return;
    ping();
    synchronized (ping_actions) {
      ping_actions.put(t, "cancelled");
      ping_anyActions = true;
    }
  }

  static public void mreplace(Matcher m, StringBuffer buf, String s) {
    m.appendReplacement(buf, Matcher.quoteReplacement(s));
  }

  static public <A> IterableIterator<A> iteratorFromFunction(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = (A) callF(f);
        done = a == null;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction(F0<A> f) {
    return iteratorFromFunction_f0(f);
  }

  static public <A> IterableIterator<A> iteratorFromFunction(IF0<A> f) {
    return iteratorFromFunction_if0(f);
  }

  static public List afterDelegatingToThread_operations = synchroList();

  static public void afterDelegatingToThread(Thread t) {
    for (Object op : cloneList(afterDelegatingToThread_operations)) pcallF(op, t);
  }

  static public void afterDelegatingToThread_do(Object f) {
    setAdd(afterDelegatingToThread_operations, f);
  }

  static public List vmBus_queryAll(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    List out = new ArrayList();
    for (Object o : unnullForIteration(vm_busListeners_live())) addIfNotNull(out, pcallF(o, msg, arg));
    for (Object o : unnullForIteration(vm_busListenersByMessage_live().get(msg))) addIfNotNull(out, pcallF(o, msg, arg));
    return out;
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  static public String hAddToHead(String html, String tag) {
    List<String> tok = htmlTok(html);
    List<String> head = first(findContainerTag(tok, "head"));
    if (head == null)
      return tag + html;
    head.set(2, addLineBreak(tag) + head.get(2));
    return join(tok);
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public String tok_deRoundBracket(String s) {
    return tok_isRoundBracketed(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public Pair<String, Integer> jmenu_autoMnemonic(String s) {
    int i = indexOf(s, '&');
    if (i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i + 1)))
      return pair(substring(s, 0, i) + substring(s, i + 1), (int) s.charAt(i + 1));
    return pair(s, 0);
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, lCharSequence(l));
  }

  static public double toSeconds(long ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(long ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toSeconds(double ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(double ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public void clickButton(final JButton b) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (b.isEnabled())
              b.doClick();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (b.isEnabled())\r\n      b.doClick();";
        }
      });
    }
  }

  static public boolean anyIntRangeContains(Iterable<IntRange> ranges, int i) {
    return any(ranges, r -> intRangeContains(r, i));
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Map<String, Field> getOpt_getFieldMap(Object o) {
    Class c = _getClass(o);
    HashMap<String, Field> map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
    return map;
  }

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Map<String, Field> map = getOpt_getFieldMap(o);
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return syncMapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public List<Integer> rgbToIntList(RGB rgb) {
    return rgb == null ? null : ll(rgb.redInt(), rgb.greenInt(), rgb.blueInt());
  }

  static public boolean cleanUp_interruptThreads = false;

  static public void cleanUp(Object c) {
    if (c == null)
      return;
    if (c instanceof AutoCloseable) {
      close_pcall((AutoCloseable) c);
      return;
    }
    if (c instanceof java.util.Timer) {
      ((java.util.Timer) c).cancel();
      return;
    }
    if (c instanceof Collection) {
      cleanUp((Collection) c);
      return;
    }
    if (c instanceof Map) {
      for (Object o : keys((Map) c)) cleanUp(o);
      for (Object o : values((Map) c)) cleanUp(o);
      ((Map) c).clear();
      return;
    }
    try {
      preCleanUp(c);
      setOpt(c, "ping_pauseAll", false);
      innerCleanUp(c);
      List androids = (List) getOpt(c, "record_list");
      for (Object android : unnull(androids)) pcallOpt(android, "dispose");
      List<WeakReference> classes = (List<WeakReference>) (getOpt(c, "hotwire_classes"));
      if (classes != null)
        for (WeakReference cc : classes) {
          try {
            cleanUp(cc.get());
          } catch (Throwable __e) {
            _handleException(__e);
          }
        }
      if (cleanUp_interruptThreads) {
        List<Thread> threads = registeredThreads(c);
        if (nempty(threads)) {
          print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
          interruptThreads(threads);
        }
      }
    } catch (Throwable __e) {
      _handleException(__e);
    }
    setOpt(c, "cleaningUp_flag", false);
    if (c instanceof Class && ((Class) c).getName().equals("main"))
      retireClassLoader(((Class) c).getClassLoader());
  }

  static public void cleanUp(Collection l) {
    if (l == null)
      return;
    for (Object c : l) cleanUp(c);
    l.clear();
  }

  static public Map<String, String> flexMatchAngleBracketVarsIC_first(String pat, String input) {
    return grabValueAndCancel(new VF1<VF1<Map<String, String>>>() {

      public void get(VF1<Map<String, String>> onMatch) {
        try {
          flexMatchAngleBracketVarsIC_iterate(pat, input, onMatch);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "flexMatchAngleBracketVarsIC_iterate(pat, input, onMatch);";
      }
    });
  }

  static public Object subBot_serveFile(File file) {
    return call(getMainBot(), "serveFile", file);
  }

  static public Object subBot_serveFile(File file, String mimeType) {
    return call(getMainBot(), "serveFile", file, mimeType);
  }

  static public MMOPattern mmo2_parsePattern(String s) {
    s = trim(tok_deRoundBracket(trim(s)));
    List<String> tok = javaTokWithBrackets(s);
    List<String> l = tok_splitAtComma(tok);
    if (l(l) > 1)
      return new MMOPattern.Or(lambdaMap(__78 -> mmo2_parsePattern(__78), l));
    l = tok_splitAtPlus(tok);
    if (l(l) > 1)
      return new MMOPattern.And(lambdaMap(__79 -> mmo2_parsePattern(__79), l));
    if (startsWith(s, "!"))
      return new MMOPattern.Not(mmo2_parsePattern(dropFirst(s)));
    if (startsWith(s, "^"))
      return new MMOPattern.StartOfLine(mmo2_parsePattern(dropFirst(s)));
    if (endsWith(s, "$"))
      return new MMOPattern.EndOfLine(mmo2_parsePattern(dropLast(s)));
    l = tok_splitAtAsterisk(tok);
    if (l(l) == 2)
      return new MMOPattern.Weighted(parseDouble(second(l)), mmo2_parsePattern(first(l)));
    return new MMOPattern.Phrase(unquote(s), isQuoted(s));
  }

  static public <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  static public <A> void forEach(Iterable<A> l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public <A> void forEach(IVF1<A> f, Iterable<A> l) {
    forEach(l, f);
  }

  static public <A> void forEach(A[] l, IVF1<A> f) {
    if (f != null && l != null)
      for (A a : l) callF(f, a);
  }

  static public String javascriptQuote(String s) {
    return quote(s);
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long) {
        f.set(o, ((Long) value).intValue());
        return;
      }
      if (type == boolean.class && value instanceof String) {
        f.set(o, isTrueOrYes(((String) value)));
        return;
      }
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  static public Object postJSONPage(String url, Object... params) {
    return jsonDecode(postPage(url, params));
  }

  static public <A> List<A> syncListPlus(Collection<A> l, A... more) {
    if (l == null)
      return asList(more);
    synchronized (collectionMutex(l)) {
      return concatLists(l, asList(more));
    }
  }

  static public String str_toK(long l) {
    return n2(toK(l)) + " K";
  }

  static public List mapLL(Object f, Object... data) {
    return map(f, ll(data));
  }

  static public <A, B> List<B> mapLL(IF1<A, B> f, A... data) {
    return map(f, ll(data));
  }

  static public <A> void mapPutInRange(Map<Integer, A> map, int start, int end, A value) {
    if (map != null && value != null)
      for (int i = start; i < end; i++) map.put(i, value);
  }

  static public String unicode_rightPointingTriangle() {
    return charToString(0x25B8);
  }

  static public boolean tok_isRoundBracketed(String s) {
    List<String> tok = tok_combineRoundBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "(", ")");
  }

  static public <A extends Concept> A getConceptOpt(Class<A> cc, long id) {
    return getConceptOpt(db_mainConcepts(), cc, id);
  }

  static public <A extends Concept> A getConceptOpt(Concepts concepts, Class<A> cc, long id) {
    return concepts == null ? null : optCast(cc, concepts.getConcept(id));
  }

  static public String str_toM(long l) {
    return n2(toM(l)) + " MB";
  }

  static public String hhtml(Object contents) {
    return containerTag("html", contents);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public boolean isInRAMDisk(File f) {
    return startsWithOneOf(f2s(f), "/dev/shm/", "/run/shm/");
  }

  static public void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  static public void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  static public void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  static public boolean containsNewLines(String s) {
    return containsNewLine(s);
  }

  static public String appendBracketed(Object o) {
    String b = strOrNull(o);
    return empty(b) ? "" : "" + " (" + b + ")";
  }

  static public String appendBracketed(String a, String b) {
    return a + appendBracketed(b);
  }

  static public String js_evalOnWebSocketMessage() {
    return "\r\n    function(event) {\r\n      var data = JSON.parse(event.data);\r\n      if (data.eval) {\r\n        if (wsVerbose) console.log(\"Evaluating: \" + data.eval);\r\n        var geval = eval; // use global scope\r\n        geval(data.eval);\r\n        if (wsVerbose) console.log(\"Evaluated.\");\r\n      } else\r\n        if (wsVerbose) console.log(\"WebSocket incoming: \" + event.data);\r\n    }\r\n  ";
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public <A> boolean syncAddAll(Collection<A> c, Iterable<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (c) {
      return c.addAll(asCollection(b));
    }
  }

  static public String spacePlusRoundBracketedIfNempty(String s) {
    return nempty(s) ? " " + roundBracket(s) : "";
  }

  static public int preferredWidth(Component c) {
    return c == null ? 0 : getPreferredSize(c).width;
  }

  static public String jsonEncode_shallowLineBreaks(Object o) {
    return jsonEncode_breakAtLevel1(o);
  }

  static public void jsonEncode_shallowLineBreaks(Object o, StringBuilder buf, int level) {
    jsonEncode_breakAtLevel1(o, buf, level);
  }

  static public String hcss_responstableForForms() {
    return hcss("\r\n    .responstableForForms {\r\n      margin: 1em 0;\r\n      /*width: 100%;*/\r\n      overflow: hidden;\r\n      background: #FFF;\r\n      color: #024457;\r\n      border-radius: 10px;\r\n      border: 1px solid #167F92;\r\n    }\r\n    \r\n    .responstableForForms tr {\r\n      border: 1px solid #D9E4E6;\r\n    }\r\n    .responstableForForms tr:nth-child(odd) {\r\n      background-color: #EAF3F3;\r\n    }\r\n    .responstableForForms th {\r\n      display: none;\r\n      border: 1px solid #FFF;\r\n      background-color: #167F92;\r\n      color: #FFF;\r\n      padding: 1em;\r\n    }\r\n    .responstableForForms th:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n    }\r\n    .responstableForForms th:nth-child(2) {\r\n      display: table-cell;\r\n    }\r\n    .responstableForForms th:nth-child(2) span {\r\n      display: none;\r\n    }\r\n    .responstableForForms th:nth-child(2):after {\r\n      content: attr(data-th);\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms th:nth-child(2) span {\r\n        display: block;\r\n      }\r\n      .responstableForForms th:nth-child(2):after {\r\n        display: none;\r\n      }\r\n    }\r\n    .responstableForForms td {\r\n      display: block;\r\n      word-wrap: break-word;\r\n      /*max-width: 7em;*/\r\n    }\r\n    .responstableForForms td:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n      border-right: 1px solid #D9E4E6;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms td {\r\n        border: 1px solid #D9E4E6;\r\n      }\r\n    }\r\n    .responstableForForms th, .responstableForForms td {\r\n      text-align: left;\r\n      margin: .5em 1em;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms th, .responstableForForms td {\r\n        display: table-cell;\r\n        padding: 1em;\r\n      }\r\n    }\r\n  ");
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public String jsonEncode_breakAtLevels(Object o) {
    return jsonEncode_breakAtLevels(5, o);
  }

  static public String jsonEncode_breakAtLevels(int levels, Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode_breakAtLevels(levels, o, buf, 1);
    return str(buf);
  }

  static public void jsonEncode_breakAtLevels(int levels, Object o, StringBuilder buf, int level) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n" + spaces(level * 2));
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode_breakAtLevels(levels, map.get(key), buf, level + 1);
      }
      if (level <= levels)
        buf.append("\n" + spaces((level - 1) * 2));
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level <= levels)
          buf.append("\n" + spaces(level * 2));
        jsonEncode_breakAtLevels(levels, element, buf, level + 1);
      }
      if (level <= levels)
        buf.append("\n" + spaces((level - 1) * 2));
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public boolean eqOrSame(Object a, Object b) {
    return a == null ? b == null : a == b || b != null && a.equals(b);
  }

  static public String makeFrame_defaultIcon;

  static public boolean makeFrame_hideConsole = false;

  static public ThreadLocal<VF1<JFrame>> makeFrame_post = new ThreadLocal();

  static public JFrame makeFrame() {
    return makeFrame((Component) null);
  }

  static public JFrame makeFrame(Object content) {
    return makeFrame(programTitle(), content);
  }

  static public JFrame makeFrame(String title) {
    return makeFrame(title, null);
  }

  static public JFrame makeFrame(String title, Object content) {
    return makeFrame(title, content, true);
  }

  static public JFrame makeFrame(final String title, final Object content, final boolean showIt) {
    final VF1<JFrame> post = optParam(makeFrame_post);
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          if (getFrame(content) != null)
            return getFrame(setFrameTitle((Component) content, title));
          final JFrame frame = new JFrame(title);
          if (makeFrame_defaultIcon != null)
            setFrameIconLater(frame, makeFrame_defaultIcon);
          _initFrame(frame);
          Component wrapped = wrap(content);
          if (wrapped != null)
            frame.getContentPane().add(wrapped);
          frame.setBounds(defaultNewFrameBounds());
          callF(post, frame);
          if (showIt)
            frame.setVisible(true);
          if (showIt && makeFrame_hideConsole) {
            hideConsole();
            makeFrame_hideConsole = false;
          }
          return frame;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ...";
      }
    });
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public String nConversations(long n) {
    return n2(n, "conversation");
  }

  static public String nConversations(Collection l) {
    return nConversations(l(l));
  }

  static public String nConversations(Map map) {
    return nConversations(l(map));
  }

  static public CancelPoint newCancelPoint() {
    return new CancelPoint();
  }

  static public void flexMatchAngleBracketVarsIC_honorPunctuation_iterate(String pat, String input, VF1<Map<String, String>> onMatch) {
    List<String> vars = new ArrayList();
    String starsPat = angleBracketVarsToStars(pat, vars);
    flexMatchIC_iterate(starsPat, javaTokWithBrackets(starsPat), javaTokWithBrackets(input), new VF1<Matches>() {

      public void get(Matches m) {
        try {
          Map<String, String> map = matchesToMapUsingVarList_ciMap(m, vars);
          if (map != null)
            callF(onMatch, map);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "SS map = matchesToMapUsingVarList_ciMap(m, vars);\r\n    if (map != null) callF...";
      }
    });
  }

  static public <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  static public String javaDropAllComments(String s) {
    return join(javaDropAllComments(javaTok(s)));
  }

  static public List<String> javaDropAllComments(List<String> tok) {
    for (int i = 0; i < l(tok); i += 2) tok.set(i, tok_javaDropCommentsFromWhitespace(tok.get(i)));
    return tok;
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble((String) o);
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public void disposeFrame(final Component c) {
    disposeWindow(c);
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  static public String formatDoubleArrowMap_horizontallyAligned(Map map) {
    return formatDoubleArrowPairs_horizontallyAligned(mapToPairs(map));
  }

  static public void preCleanUp(Object c) {
    if (c instanceof Collection) {
      for (Object o : ((Collection) c)) preCleanUp(o);
      return;
    }
    callOpt(c, "licensed_off");
    setOpt(c, "ping_anyActions", true);
    setOpt(c, "cleaningUp_flag", true);
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public List<String> tok_combineRoundCurlySquareBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(", "[")) {
        int j = findEndOfBracketPart2(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public void thinAProgramsBackups(String progID, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)(\\d*)$");
    File dir = programDir(progID);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      java.util.regex.Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      int minute = matcherInt(matcher, 6);
      long time = timestampFromYMDHM(year, month, day, hour, minute);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  static public boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  static public int numberOfFunctionArguments(Object f) {
    if (f instanceof F0)
      return 0;
    if (f instanceof F1)
      return 1;
    if (f instanceof F2)
      return 2;
    if (f instanceof VF1)
      return 1;
    if (f instanceof VF2)
      return 2;
    if (f instanceof String)
      return numberOfMethodArguments(mc(), (String) f);
    return numberOfMethodArguments(f, "get");
  }

  static public String getClassDeclarationName(List<String> tok) {
    if (tok != null)
      for (int i = 1; i + 2 < tok.size(); i += 2) if (allClasses_keywords.contains(tok.get(i)) && isIdentifier(tok.get(i + 2))) {
        if (eqGet(tok, i + 2, "noeq"))
          i += 2;
        return tok.get(i + 2);
      }
    return null;
  }

  static public <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  static public <A> AutoCloseable tempSetTL(x30_pkg.x30_util.BetterThreadLocal<A> tl, A a) {
    return tempSetThreadLocalIfNecessary(tl, a);
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(strOrNull(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public String dottedSpan(String contents, String title) {
    return span(contents, "title", title, "style", "border-bottom: dotted 1px");
  }

  static public <A extends Iterable> A pnl(A l) {
    return pnl("", l);
  }

  static public <A extends Iterable> A pnl(String prefix, A l) {
    printNumberedLines(prefix, l);
    return l;
  }

  static public <A> A[] pnl(A[] l) {
    return pnl("", l);
  }

  static public <A> A[] pnl(String prefix, A[] l) {
    printNumberedLines(prefix, l);
    return l;
  }

  static public <A extends Map> A pnl(A map) {
    printNumberedLines(map);
    return map;
  }

  static public <A extends Map> A pnl(String prefix, A map) {
    printNumberedLines(prefix, map);
    return map;
  }

  static public String pnl(String s) {
    printNumberedLines(lines(s));
    return s;
  }

  static public <A> MultiSet<A> pnl(MultiSet<A> ms) {
    pnl(ms == null ? null : ms.asMap());
    return ms;
  }

  static public <A, B> MultiMap<A, B> pnl(MultiMap<A, B> mm) {
    pnl(mm == null ? null : mm.asMap());
    return mm;
  }

  static public String hPopDownButton(String... entries) {
    String id = "dropdown-" + aGlobalID(), outerID = "outer-" + id;
    String onclick = replaceDollarVars("\r\n    var x = document.getElementById($id);\r\n    x.style.display = window.getComputedStyle(x).display === \"none\" ? \"block\" : \"none\";\r\n    console.log(\"popup \" + id + \" display: \" + x.style.display);\r\n  ", "$id", jsQuote(id));
    return hstyle(replaceDollarVars("\r\n    #$id ul {\r\n      list-style-type: none;\r\n      margin: 0;\r\n      padding: 0;\r\n      width: 200px;\r\n      background-color: #f1f1f1;\r\n    }\r\n    \r\n    #$id {\r\n      position: absolute;\r\n      display:none;\r\n      background-color: #f9f9f9;\r\n      width:auto;\r\n      height:200px;\r\n      overflow: auto;\r\n     \r\n      min-width: 160px;\r\n      box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);\r\n      \r\n      z-index: 99;\r\n    }\r\n    \r\n    #$id li a {\r\n      text-decoration: none;\r\n      color: #000;\r\n    }\r\n\r\n    #$id li {    \r\n      display: block;\r\n      border-bottom: 1px solid #555;\r\n      padding: 8px 16px;\r\n      color: #000;\r\n    }\r\n  " + "\r\n    #$id li:hover, #$id li:hover > a {\r\n      background-color: #3399ff;\r\n      color: white;\r\n    }\r\n  ", "$id", id)) + hdiv(span(htmlEncode2(unicode_smallDownPointingTriangle()), "onclick", onclick) + hdiv(ul(entries), "id", id), "style", "position: relative; display: inline-block; cursor: context-menu", "id", outerID) + hscript(replaceDollarVars("\r\n      if (typeof $ !== 'undefined')\r\n        $('body').click(function(e) {\r\n          //console.log(\"target=\" + e.target + \", outerID=$outerID\");\r\n          if (!$(e.target).closest('#$outerID').length) {\r\n            //console.log(\"hiding $id\");\r\n            $(\"#$id\").hide();\r\n          }\r\n        });\r\n    ", "id", id, "outerID", outerID));
  }

  static public String hPopDownButton(Collection<String> entries) {
    return hPopDownButton(toStringArray(entries));
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public ThreadLocal<Boolean> addInternalFrame_dontSelect = new ThreadLocal();

  static public ThreadLocal<Integer> addInternalFrame_layer = new ThreadLocal();

  static public ThreadLocal<Boolean> addInternalFrame_toBack = new ThreadLocal();

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h) {
    return addInternalFrame(desktop, title, x, y, w, h, null);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h, final Component contents) {
    return addInternalFrame(desktop, title, rect(x, y, w, h), contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Component contents) {
    return addInternalFrame(desktop, title, null, contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Rect r, final Component contents) {
    final boolean dontSelect = isTrue(optParam(addInternalFrame_dontSelect));
    final boolean toBack = isTrue(optParam(addInternalFrame_toBack));
    final Integer layer = optParam(addInternalFrame_layer);
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame frame;
          if (contents instanceof JInternalFrame)
            frame = (JInternalFrame) contents;
          else {
            frame = jInternalFrame(title);
            setInternalFrameContents(frame, contents);
          }
          frame.setVisible(true);
          desktop.add(frame, layer);
          if (r != null)
            setBounds(frame, r);
          else
            internalFrameDefaultPosition(frame);
          if (dontSelect)
            if (toBack)
              frame.toBack();
            else
              frame.toFront();
          else
            frame.setSelected(true);
          return fixInternalFrame(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame frame;\r\n    if (contents instanceof JInternalFrame)\r\n      fra...";
      }
    });
  }

  static public JInternalFrame addInternalFrame(JDesktopPane desktop, String title) {
    return addInternalFrame(desktop, title, jpanel());
  }

  static public String hcenter3(Object contents, Object... __) {
    return tag("div", contents, params_stylePlus(__, "width: 100%; text-align: center"));
  }

  static public <A> A childOfType(Component c, Class<A> theClass) {
    return first(childrenOfType(c, theClass));
  }

  static public <A> A childOfType(Class<A> theClass, Component c) {
    return childOfType(c, theClass);
  }

  static public boolean isMac() {
    return System.getProperty("os.name").toLowerCase().contains("mac");
  }

  static public boolean shortClassNameIs(Object o, String name) {
    return eq(shortClassName(o), name);
  }

  static public boolean shortClassNameIs(String name, Object o) {
    return shortClassNameIs(o, name);
  }

  static public String shortName(Object o) {
    return shortClassName(o);
  }

  static public String camelCase(List<String> words) {
    StringBuilder buf = new StringBuilder();
    for (int i = 0; i < l(words); i++) {
      String word = words.get(i);
      word = toLower(word);
      buf.append(i == 0 ? word : firstToUpper(word));
    }
    return str(buf);
  }

  static public String camelCase(String words) {
    return camelCase(words(words));
  }

  static public int lastIndexOf_byteArray(byte[] a, byte b) {
    for (int i = l(a) - 1; i >= 0; i--) if (a[i] == b)
      return i;
    return -1;
  }

  static public Object subBot_noCacheHeaders(Object r) {
    call(r, "addHeader", "Cache-Control", "no-cache, must-revalidate, max-age=0");
    return r;
  }

  static public <A> List<A> instancesOf(Iterable i, Class<A> c) {
    return collectInstances(i, c);
  }

  static public <A> List<A> instancesOf(Class<A> c, Iterable i) {
    return collectInstances(c, i);
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public boolean containsLowerCase(String s) {
    for (int i = 0; i < l(s); i++) if (isLowerCase(s.charAt(i)))
      return true;
    return false;
  }

  static public String dropAfterSubstring(String s, String b) {
    return substring(s, 0, smartIndexOf(s, b));
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnull(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public int unnull(Integer i) {
    return i == null ? 0 : i;
  }

  static public long unnull(Long l) {
    return l == null ? 0L : l;
  }

  static public double unnull(Double l) {
    return l == null ? 0.0 : l;
  }

  static public String findTranslators2(String src, List<String> libsOut) {
    return join(findTranslators2(javaTok(src), libsOut));
  }

  static public List<String> findTranslators2(List<String> tok, List<String> libsOut) {
    int i;
    while ((i = jfind(tok, "!<int>")) >= 0) {
      setAdd(libsOut, tok.get(i + 2));
      clearTokens(tok, i, i + 3);
    }
    return tok;
  }

  static public Class getFieldType(Object o, String field) {
    return fieldType(o, field);
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public boolean conceptsWithFieldGreaterThan_sorted_verbose = false;

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan_sorted(Class<A> c, String field, Object value) {
    return conceptsWithFieldGreaterThan_sorted(db_mainConcepts(), c, field, value);
  }

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan_sorted(Concepts concepts, Class<A> c, String field, Object value) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc)
      return reverseInPlace(((ConceptFieldIndexDesc) index).objectsWithValueGreaterThan(value));
    if (conceptsWithFieldGreaterThan_sorted_verbose)
      print("conceptsWithFieldGreaterThan: table scan of " + c + " for field " + field);
    return sortByFieldInPlace(field, objectsWhereFieldGreaterThan(concepts.list(c), field, value));
  }

  static public String replaceDollarVars(String s, Object... params) {
    if (empty(params))
      return s;
    Map<String, Object> vars = mapKeys(__80 -> dropDollarPrefix(__80), (Map<String, Object>) litcimap(params));
    return replaceDollarVars_dyn(s, var -> strOrNull(vars.get(var)));
  }

  static public String replaceDollarVars(String s, IF1<String, String> f) {
    return replaceDollarVars_dyn(s, f);
  }

  static public List<String> splitAtVerticalBar(String s) {
    return s == null ? new ArrayList() : trimAll(asList(s.split("\\|")));
  }

  static public String decimalFormatEnglish(String format, double d) {
    return decimalFormatEnglish(format).format(d);
  }

  static public java.text.DecimalFormat decimalFormatEnglish(String format) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
  }

  static public <A> List<Integer> indicesOf(List<A> l, A a) {
    if (l == null)
      return null;
    if (l instanceof IContentsIndexedList)
      return intArrayToList(((IContentsIndexedList) l).indicesOf(a));
    if (l instanceof IContentsIndexedList2)
      return map(h -> ((HasIndex) h).idx, ((IContentsIndexedList2) l).indicesOf_treeSetOfHasIndex(a));
    List<Integer> x = new ArrayList();
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      x.add(i);
    return x;
  }

  static public <A> List<Integer> indicesOf(String s, String x) {
    int i = -1;
    List<Integer> out = new ArrayList();
    while ((i = indexOf(s, x, i + 1)) >= 0) out.add(i);
    return out;
  }

  static public String postPage(String url, Object... params) {
    return doPost(litmap(params), url);
  }

  static public List<String> findBlock(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    int i = findCodeTokens(tok, toStringArray(codeTokensOnly(tokpat)));
    if (i < 0)
      return null;
    int bracketIdx = i + tokpat.size() - 3;
    assertEquals("{", tok.get(bracketIdx));
    int endIdx = findEndOfBlock(tok, bracketIdx);
    return subList(tok, i - 1, endIdx + 1);
  }

  static public boolean startsAndEndsWith(String a, char c) {
    return startsWith(a, c) && endsWith(a, c) && l(a) >= 2;
  }

  static public boolean startsAndEndsWith(String a, String b) {
    return startsWith(a, b) && endsWith(a, b) && l(a) >= l(b) * 2;
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public String tdTop(Object contents, Object... params) {
    return tag("td", contents, arrayPlus(params, "valign", "top"));
  }

  static public String tryToReadErrorStreamFromURLConnection(URLConnection conn) {
    try {
      if (conn instanceof HttpURLConnection)
        return stream2string(((HttpURLConnection) conn).getErrorStream());
      return null;
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, List<A> l) {
    return subList(l, startIndex);
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex > endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return ourSubList_noRangeCheck(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String formatDouble(double d) {
    return str(d);
  }

  static public <A extends Concept> List<A> sortConceptsByID(Collection<A> l) {
    return sortedByCalculatedField(l, c -> c.id);
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public JFrame minFrameWidth(JFrame frame, int w) {
    if (frame != null && frame.getWidth() < w)
      frame.setSize(w, frame.getHeight());
    return frame;
  }

  static public JFrame minFrameWidth(int w, JFrame frame) {
    return minFrameWidth(frame, w);
  }

  static public int withRightMargin_defaultWidth = 6;

  static public JPanel withRightMargin(Component c) {
    return withRightMargin(withRightMargin_defaultWidth, c);
  }

  static public JPanel withRightMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, w));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public <A> A evalWithTimeoutOrFail(int timeoutMS, F0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public <A> A evalWithTimeoutOrFail(double timeoutSeconds, F0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, f);
  }

  static public <A> A evalWithTimeoutOrFail(int timeoutMS, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public <A> A evalWithTimeoutOrFail(double timeoutSeconds, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, f);
  }

  static public void evalWithTimeoutOrFail(int timeoutMS, Runnable r) {
    evalWithTimeoutOrException(timeoutMS, runnableToF0(r));
  }

  static public void evalWithTimeoutOrFail(double timeoutSeconds, Runnable r) {
    evalWithTimeoutOrException(timeoutSeconds, runnableToF0(r));
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && b != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public boolean cicWithSmartWordBoundary(String a, String b) {
    return containsRegexpIC(a, phraseToRegExp(b));
  }

  static public File linux_fileInRamDisk(String name) {
    if (!isLinux())
      return null;
    File dir = newFile("/dev/shm");
    if (dir.isDirectory())
      return newFile(dir, name);
    return null;
  }

  static public <A> A getVar(IF0<A> v) {
    return v == null ? null : v.get();
  }

  static public <A> void addFirst(List<A> c, A a) {
    if (c != null)
      c.add(0, a);
  }

  static public <A> A nextToLast(List<A> l) {
    return get(l, l(l) - 2);
  }

  static public boolean frameTooSmall(JFrame frame) {
    return frame.getWidth() < 100 || frame.getHeight() < 50;
  }

  static public String unquoteAllLines(String s) {
    return linesPreservingTrailingNewLine(s, unquoteAll(lines(s)));
  }

  static public String ahref(String link, Object contents, Object... params) {
    return link == null ? str(contents) : href(link, contents, params);
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public Object serveWithContentType(String text, String contentType) {
    return serveByteArray(toUtf8(text), contentType);
  }

  static public void zip2dir(File inZip, String outDir) {
    zip2dir(inZip, newFile(outDir));
  }

  static public void zip2dir(File inZip, File outDir) {
    zip2dir(inZip, outDir, "");
  }

  static public void zip2dir(File inZip, String outDir, String prefix) {
    zip2dir(inZip, newFile(outDir), prefix);
  }

  static public void zip2dir(File inZip, File outDir, String prefix) {
    try {
      if (prefix.length() != 0 && !prefix.endsWith("/"))
        prefix += "/";
      ZipFile zipFile = new ZipFile(inZip);
      try {
        Enumeration entries = zipFile.entries();
        while (entries.hasMoreElements()) {
          ZipEntry entry = (ZipEntry) entries.nextElement();
          if (entry.isDirectory())
            continue;
          if (!entry.getName().startsWith(prefix))
            continue;
          File outFile = new File(outDir, entry.getName());
          print("Unzipping " + entry.getName() + " to " + outFile.getAbsolutePath());
          stream2file(zipFile.getInputStream(entry), outFile);
        }
      } finally {
        _close(zipFile);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean exposeMethods2_debug = false;

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  static public Object serveJSON_breakAtLevels(int levels, Object... data) {
    return serveText(jsonEncode_breakAtLevels(levels, jsonPrepareData(data)));
  }

  static public String formatDoubleFull(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '0');
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
  }

  static public String spliceString(String a, int from, int to, String b) {
    return substring(a, 0, from) + b + substring(a, Math.max(from, to));
  }

  static public String spliceString(String a, int from, int to, char b) {
    return spliceString(a, from, to, str(b));
  }

  static public String pre(Object contents, Object... params) {
    return tag("pre", contents, params);
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
  }

  static public <A> String replaceVars(String s, Map<String, A> map) {
    return empty(map) ? s : join(replaceVars(javaTok(s), map));
  }

  static public <A> List<String> replaceVars(List<String> tok, Map<String, A> map) {
    if (empty(map))
      return tok;
    tok = cloneList(tok);
    for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet(map)) {
      String var = __0.getKey();
      Object val = __0.getValue();
      jreplace(tok, var, str(val));
    }
    return tok;
  }

  static public String replaceVars(String s, Object... params) {
    return replaceVars(s, paramsToMap(params));
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last((List) l);
    if (l instanceof SortedSet)
      return (A) last((SortedSet) l);
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public <A> A last(ReverseChain<A> l) {
    return l == null ? null : l.element;
  }

  static public <A> A last(CompactLinkedHashSet<A> set) {
    return set == null ? null : set.last();
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  static public <A extends Component> A _recordNewSwingComponent(A c) {
    if (c != null)
      callF((Object) vm_generalMap_get("newSwingComponentRegistry"), (Object) c);
    return c;
  }

  static public List<String> jsonTok(String s) {
    List<String> tok = new ArrayList();
    int l = l(s);
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isLetter(c))
        do ++j; while (j < l && Character.isLetter(s.charAt(j)));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public <A> List<A> objectsWhereIC(Collection<A> c, Object... data) {
    if (c == null)
      return null;
    List<A> l = new ArrayList();
    for (A x : c) if (checkFieldsIC(x, data))
      l.add(x);
    return l;
  }

  static public String addPlusToCount(long max, long n, String s) {
    if (n != max)
      return s;
    return insertString(s, smartIndexOfSpaceEtc(s), "+");
  }

  static public List<File> filesWithExtension(String ext, List<File> files) {
    return filesEndingWith(files, addPrefixIfNotEmpty2(".", ext));
  }

  static public List<String> splitAtTokens(String s, List<String> tokens) {
    return splitAtTokens(javaTok(s), tokens);
  }

  static public List<String> splitAtTokens(List<String> tok, List<String> tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public List<String> splitAtTokens(List<String> tok, String... tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public List<Integer> indicesOfAngleBracketVars(List<String> tok) {
    List<Integer> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) if (isAngleBracketVar(tok.get(i)))
      l.add(i);
    return l;
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, A... keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public <A, B> Map<A, B> getMultipleKeys(Map<A, B> map, Iterable<A> keys) {
    Map<A, B> map2 = similarEmptyMap(map);
    if (map != null && keys != null)
      for (A key : keys) map2.put(key, map.get(key));
    return map2;
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  static public List flattenList2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Collection)
        for (Object sub : (Collection) x) l.addAll(flattenList2(sub));
      else if (x != null)
        l.add(x);
    return l;
  }

  static public boolean isStringList(Object o) {
    if (!(o instanceof List))
      return false;
    List l = (List) o;
    for (Object x : l) if (!(x instanceof String))
      return false;
    return true;
  }

  static public Object[] paramsPlus_noOverwrite(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) mapPut_noOverwrite(map, a2[i], a2[i + 1]);
    return mapToParams(map);
  }

  static public String plural(String s) {
    return getPlural(s);
  }

  static public String h3_htmlEncode(Object contents, Object... params) {
    return h3(htmlEncode2(str(contents)), params);
  }

  static public String javaVersion() {
    return System.getProperty("java.version");
  }

  static public List<String> trimAll(Collection<String> l) {
    List<String> l2 = new ArrayList();
    if (l != null)
      for (String s : l) l2.add(trim(s));
    return l2;
  }

  static public String gazelle_server() {
    return "https://gazelle.rocks/";
  }

  static public ClassLoader getClassLoader(Object o) {
    return o == null ? null : _getClass(o).getClassLoader();
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public String formatDouble_significant2(double d, int digits) {
    try {
      digits -= max(0, Math.floor(Math.log10(abs(d)) + 1));
      return formatDouble(d, digits);
    } catch (Throwable _e) {
      print("Had number: " + d + ", digits: " + digits);
      throw rethrow(_e);
    }
  }

  static public String htmldecode_dropAllTags(String html) {
    return htmldecode(dropAllTags(html));
  }

  static public boolean isJavaxCompilableSnippetType(int type) {
    return isJavaxCompilableSnippetTypeExceptInclude(type) || type == javaxIncludeSnippetType();
  }

  static public Map<String, String> codeAnalysis_identifierSafetyMap() {
    return mechHashMap("JavaX Identifier Safety");
  }

  static public String rpad(String s, int l) {
    return rpad(s, l, ' ');
  }

  static public String rpad(String s, int l, char c) {
    return lengthOfString(s) >= l ? s : s + rep(c, l - lengthOfString(s));
  }

  static public String rpad(int l, String s) {
    return rpad(s, l);
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public String nTests(long n) {
    return n2(n, "test");
  }

  static public String nTests(Collection l) {
    return nTests(l(l));
  }

  static public boolean isString(Object o) {
    return o instanceof String;
  }

  static public String angleBracketed(String s) {
    return angleBracket(s);
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public String showFormSubmitButtonName() {
    return "Submit";
  }

  static public <A extends Concept> Collection<String> distinctCIFieldValuesOfConcepts(Class<A> c, String field) {
    return distinctCIFieldValuesOfConcepts(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> Collection<String> distinctCIFieldValuesOfConcepts(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, String> index = concepts.getCIFieldIndex(c, field);
    if (index != null)
      return index.allValues();
    Set<String> set = ciSet();
    for (A x : concepts.list(c)) set.add((String) getOpt(x, field));
    return set;
  }

  static public Object firstElementNotSubclassing(Iterable l, Class c) {
    return firstThat(l, o -> !isInstanceOf(o, c));
  }

  static public Q dm_ownQ(Q q) {
    q.rst.enter = dm_rEnter(dm_current_mandatory());
    dm_ownResource(q);
    return q;
  }

  static public AutoCloseable temp_loadPage_silent() {
    return tempSetThreadLocal(loadPage_silent, true);
  }

  static public List<String> listToTopTenCI(Collection<String> l) {
    return asCIMultiSet(l).highestFirst();
  }

  static public Q startQ() {
    return new Q();
  }

  static public Q startQ(String name) {
    return new Q(name);
  }

  static public int hours() {
    return hours(java.util.Calendar.getInstance());
  }

  static public int hours(java.util.Calendar c) {
    return c.get(java.util.Calendar.HOUR_OF_DAY);
  }

  static public int hours(long time) {
    return hours(calendarFromTime(time));
  }

  static public int hours(long time, TimeZone tz) {
    return hours(calendarFromTime(time, tz));
  }

  static public boolean veryQuickJava_silent = true;

  static public boolean veryQuickJava_useCompilerBot = true;

  static public ThreadLocal<String> veryQuickJava_transpiled = new ThreadLocal();

  static public Object veryQuickJava3_cacheFunction;

  static public ThreadLocal<IVF1<String>> veryQuickJava_onJavaSource = new ThreadLocal();

  static public Class veryQuickJava3(String mainJava) {
    return veryQuickJava3(mainJava, emptyList());
  }

  static public Class veryQuickJava3(String mainJava, List<String> libs) {
    Class c = (Class) (callF(veryQuickJava3_cacheFunction, mainJava, libs));
    if (c != null)
      return c;
    transpileRaw_silent = veryQuickJava_silent;
    String src = transpileRaw(mainJava);
    if (empty(src)) {
      printWithIndent("JAVAX> ", mainJava);
      throw fail("Transpiler returned empty result");
    }
    if (veryQuickJava_transpiled.get() != null)
      veryQuickJava_transpiled.set(src);
    callF(veryQuickJava_onJavaSource.get(), src);
    return veryQuickJava_finish(src, libs);
  }

  static public <A, B> Map<A, B> filterKeys(Map<A, B> map, Object f) {
    return filterMapByFunctionOnKey(map, f);
  }

  static public <A, B> Map<A, B> filterKeys(Object f, Map<A, B> map) {
    return filterMapByFunctionOnKey(f, map);
  }

  static public <A, B> Map<A, B> filterKeys(IF1<A, Boolean> f, Map<A, B> map) {
    return filterMapByFunctionOnKey((Object) f, map);
  }

  static public <A, B> Map<A, B> filterKeys(Map<A, B> map, IF1<A, Boolean> f) {
    return filterKeys(f, map);
  }

  static public MultiMap similarEmptyMultiMap(MultiMap m) {
    return similarEmptyMultiMap(m == null ? null : m.data);
  }

  static public MultiMap similarEmptyMultiMap(Map m) {
    MultiMap mm = new MultiMap();
    if (m != null)
      mm.data = similarEmptyMap(m);
    return mm;
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public <A, B extends Collection<A>> void forEachLevel2(Iterable<B> l, IVF1<A> f) {
    if (l != null)
      for (B b : l) forEach(b, f);
  }

  static public <A, B extends Collection<A>> void forEachLevel2(IVF1<A> f, Iterable<B> l) {
    forEachLevel2(f, l);
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public Set<String> allNonStaticNonTransientFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public String joinWithVBar(Iterable<String> l) {
    return join(" | ", l);
  }

  static public String joinWithVBar(String... l) {
    return joinWithVBar(asList(l));
  }

  static public String regexp_findSnippetIDs() {
    return "(?:#|\\blib\\s+|(?:^|\\n)\\s*!)([0-9]+)";
  }

  static public String htmlencode(Object o) {
    return htmlencode(str(o));
  }

  static public String htmlencode(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  static public List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  static public String hbutton(String text, Object... params) {
    return hfulltag("button", text, params);
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public String hbuttonLink(String url, String text, Object... params) {
    return hbuttonOnClick(text, "location.href=" + jsQuote(url) + ";", params);
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int lastIndexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    for (int i = l(l) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public String structureOrText(Object o) {
    return o instanceof String ? (String) o : structure(o);
  }

  static public boolean isOpeningBracket(String s) {
    return eqOneOf(s, "(", "{", "[");
  }

  static public File tempDir() {
    return makeTempDir();
  }

  static public List<String> filterNempty(Collection<String> c) {
    List<String> l = new ArrayList();
    for (String x : unnull(c)) if (nempty(x))
      l.add(x);
    return l;
  }

  static public void closeAllAndClear(Collection<? extends AutoCloseable> l) {
    if (l == null)
      return;
    for (AutoCloseable c : cloneList(l)) {
      try {
        close(c);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
    l.clear();
  }

  static public String rawLink(String pageName) {
    return "/" + parseSnippetID(getProgramID()) + "/raw" + addPrefix("/", pageName);
  }

  static public String rawLink() {
    return "/" + parseSnippetID(getProgramID()) + "/raw";
  }

  static public String rawLink(String pageName, String contents) {
    return ahref(rawLink(pageName), contents);
  }

  static public boolean setText_opt = true;

  static public <A extends JTextComponent> A setText(A c, Object text) {
    setText((JComponent) c, text);
    return c;
  }

  static public <A extends JComboBox> A setText(final A c, Object text) {
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.getEditor().setItem(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.getEditor().setItem(s);";
        }
      });
    }
    return c;
  }

  static public void setText(JLabel c, Object text) {
    setText((JComponent) c, text);
  }

  static public JButton setText(JButton c, Object text) {
    setText((JComponent) c, jlabel_textAsHTML_center_ifNeeded(strUnnull(text)));
    return c;
  }

  static public <A extends JComponent> A setText(final A c, Object text) {
    if (c == null)
      return null;
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (!setText_opt || neq(callOpt(c, "getText"), s))
              call(c, "setText", s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!setText_opt || neq(callOpt(c, \"getText\"), s))\r\n      call(c, \"setText\", s);";
        }
      });
    }
    return c;
  }

  static public <A> A listGet(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public String curlyBrace(String s) {
    return "{" + s + "}";
  }

  static public long parseFirstLong(String s) {
    return parseLong(jextract("<int>", s));
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public String jlabel_textAsHTML_center(String text) {
    return "<html><div style=\"text-align: center;\">" + replace(htmlencode2(text), "\n", "<br>") + "</div></html>";
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public TreeSet<Symbol> litciset(Symbol... items) {
    TreeSet<Symbol> set = treeSet();
    for (Symbol a : items) set.add(a);
    return set;
  }

  static public JButton findButton(Component c, String name) {
    for (JButton b : childrenOfType(c, JButton.class)) if (eq(b.getText(), name))
      return b;
    for (JButton b : childrenOfType(getFrame(c), JButton.class)) if (eq(b.getText(), name))
      return b;
    return null;
  }

  static public JButton findButton(Component c) {
    return childOfType(c, JButton.class);
  }

  static public <A, B> List<A> asForPairsWithB(B b, Iterable<Pair<A, B>> l) {
    List<A> out = new ArrayList();
    for (Pair<A, B> p : unnullForIteration(l)) if (eq(pairB(p), b))
      out.add(pairA(p));
    return out;
  }

  static public <A, B> List<A> asForPairsWithB(Iterable<Pair<A, B>> l, B b) {
    return asForPairsWithB(b, l);
  }

  static public int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  static public int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnullForIteration(l)) n += cset(c, values);
    return n;
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public String formatLocalDateWithMinutes(long time) {
    return localDateWithMinutes(time);
  }

  static public String formatLocalDateWithMinutes() {
    return localDateWithMinutes();
  }

  static public String firstWhereFirstLongIs(Collection<String> l, long i) {
    return firstThat(l, s -> parseFirstLong(s) == i);
  }

  static public java.util.Timer doAfter(long delay, Object r) {
    return doLater(delay, r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Object r) {
    return doLater(delaySeconds, r);
  }

  static public <A> A printIndent(A o) {
    print(indentx(str(o)));
    return o;
  }

  static public <A> A printIndent(String indent, A o) {
    print(indentx(indent, str(o)));
    return o;
  }

  static public void printIndent(int indent, Object o) {
    print(indentx(indent, str(o)));
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public String anchorFromURL(String url) {
    return substring(url, smartIndexOf(url, "#"));
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public int leftScanModifiers(List<String> tok, int i) {
    List<String> mod = getJavaModifiers();
    while (i > 1 && mod.contains(tok.get(i - 2))) i -= 2;
    return i;
  }

  static public String doPostSilently(Map urlParameters, String url) {
    return doPostSilently(makePostData(urlParameters), url);
  }

  static public String doPostSilently(String urlParameters, String url) {
    doPost_silently.set(true);
    return doPost(urlParameters, url);
  }

  static public String regexpQuote(String s) {
    return s.length() == 0 ? "" : Pattern.quote(s);
  }

  static public byte[] loadBinaryFilePart(File file, long start, long end) {
    try {
      RandomAccessFile raf = new RandomAccessFile(file, "r");
      int n = toInt(min(raf.length(), end - start));
      byte[] buffer = new byte[n];
      try {
        raf.seek(start);
        raf.readFully(buffer, 0, n);
        return buffer;
      } finally {
        raf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Concepts newConceptsWithClassFinder(String progID) {
    Concepts cc = new Concepts(progID);
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  static public boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  static public boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  static public double ratioToPercent(double x, double y) {
    return x * 100 / y;
  }

  static public void typeWriterConsole() {
    if (isHeadless())
      return;
    Font f = typeWriterFont();
    consoleFont(f);
    consoleInputFont(f);
  }

  static public int snippetType_javaxDesktopModule() {
    return 58;
  }

  static public <A> List<A> withoutNulls(Iterable<A> l) {
    if (l instanceof List)
      if (!containsNulls((List) l))
        return ((List) l);
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public Map<String, String> parseColonPropertyCIMap(String text) {
    return parseColonProperties(text, ciMap());
  }

  static public <A> SecretValue<A> secretValueOrNull(A a) {
    return a == null ? null : new SecretValue(a);
  }

  static public String firstIntegerString(Iterable<String> c) {
    Iterator<String> it = c.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (isInteger(s))
        return s;
    }
    return null;
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public String nLines(long n) {
    return n2(n, "line");
  }

  static public String nLines(Collection l) {
    return nLines(l(l));
  }

  static public String nLines(String s) {
    return nLines(countLines(s));
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean fileNotEmpty(File f) {
    return isFile(f) && fileSize(f) > 0;
  }

  static public List<String> codeTokensOnly(List<String> tok) {
    int n = l(tok);
    List<String> l = emptyList(n / 2);
    for (int i = 1; i < n; i += 2) l.add(tok.get(i));
    return l;
  }

  static public boolean jmenuItem_newThreads = false;

  static public JMenuItem jmenuItem(final String text) {
    return jMenuItem(text, null);
  }

  static public JMenuItem jmenuItem(final String text, final Object r) {
    return swing(new F0<JMenuItem>() {

      public JMenuItem get() {
        try {
          Pair<String, Integer> p = jmenu_autoMnemonic(dropPrefix("[disabled] ", text));
          JMenuItem mi = new JMenuItem(p.a);
          if (startsWith(text, "[disabled] "))
            disableMenuItem(mi);
          if (p.b != 0)
            mi.setMnemonic(p.b);
          mi.addActionListener(jmenuItem_newThreads ? actionListenerInNewThread(r) : actionListener(r));
          return mi;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Pair<S, Int> p = jmenu_autoMnemonic(dropPrefix(\"[disabled] \", text));\r\n    JM...";
      }
    });
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public List<String> javaTokPlusBrackets(String s) {
    return tok_combineRoundOrCurlyBrackets_keep(javaTok(s));
  }

  static public String mL_raw(String name) {
    return mechList_raw(name);
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public void deleteConcepts(Collection conceptsOrIDs) {
    db_mainConcepts().deleteConcepts(asList(conceptsOrIDs));
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, Object... params) {
    return deleteConcepts(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, Object... params) {
    List<A> l = asList(findConceptsWhere(cc, c, params));
    deleteConcepts(l);
    return l;
  }

  static public <A extends Concept> void deleteConcepts(Class<A> c, IF1<A, Boolean> pred) {
    deleteConcepts(db_mainConcepts(), c, pred);
  }

  static public <A extends Concept> void deleteConcepts(Concepts cc, Class<A> c, IF1<A, Boolean> pred) {
    deleteConcepts(filter(list(cc, c), pred));
  }

  static public List<Concept> deleteConcepts(Concepts cc) {
    return deleteConcepts(cc, Concept.class);
  }

  static public long conceptID(Concept c) {
    return c == null ? 0 : c.id;
  }

  static public long conceptID(Concept.Ref ref) {
    return conceptID(cDeref(ref));
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public Map<String, String> parseCSSParameter(String s) {
    Map<String, String> map = new LinkedHashMap();
    for (String x : trimAll(splitAt(s, ";"))) {
      List<String> y = trimAll(splitAtColon(x));
      if (l(y) == 2)
        map.put(first(y), second(y));
    }
    return map;
  }

  static public String indentedStructure(Object o) {
    return indentStructureString(struct(o));
  }

  static public String hcheckbox(String name, boolean checked, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "checkbox", "name", name, checked ? "checked" : null, "1"));
  }

  static public String hcheckbox(String name) {
    return hcheckbox(name, false);
  }

  static public String hcheckbox(String name, String text) {
    return hcheckboxWithText(name, text);
  }

  static public MultiMap treeMultiMapIndexByField(Collection c, String field) {
    MultiMap map = treeMultiMap();
    for (Object a : c) {
      Object val = getOpt(a, field);
      if (val != null)
        map.put(val, a);
    }
    return map;
  }

  static public MultiMap treeMultiMapIndexByField(String field, Collection c) {
    return treeMultiMapIndexByField(c, field);
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public <A> A callPostProcessor(Object f, A a) {
    return f == null ? a : (A) callF(f, a);
  }

  static public <A> A callPostProcessor(IF1<A, A> f, A a) {
    return f == null ? a : f.get(a);
  }

  static public boolean isValidEmailAddress_simple(String s) {
    return l(s) <= 254 && regexpMatches("^\\S+@\\S+(\\.[^\\.\\s]+)+$", s);
  }

  static public JavaScript hjs_copyToClipboard() {
    return new JavaScript("\r\n    const copyToClipboard = str => {\r\n      const el = document.createElement('textarea');\r\n      el.value = str;\r\n      el.setAttribute('readonly', '');\r\n      el.style.position = 'absolute';\r\n      el.style.left = '-9999px';\r\n      document.body.appendChild(el);\r\n      const selected =\r\n        document.getSelection().rangeCount > 0 ? document.getSelection().getRangeAt(0) : false;\r\n      el.select();\r\n      document.execCommand('copy');\r\n      document.body.removeChild(el);\r\n      if (selected) {\r\n        document.getSelection().removeAllRanges();\r\n        document.getSelection().addRange(selected);\r\n      }\r\n    };\r\n  ");
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public <A> List<A> sortedByCalculatedField(Iterable<A> c, Object f) {
    return sortByCalculatedField(c, f);
  }

  static public <A> List<A> sortedByCalculatedField(Object f, Iterable<A> c) {
    return sortedByCalculatedField(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedField(IF1<A, B> f, Iterable<A> c) {
    return sortedByCalculatedField(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedField(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(a), f.get(b));
      }
    });
    return l;
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public <A, B> List<Pair<A, B>> mapToPairs(Map<A, B> map) {
    List<Pair<A, B>> l = emptyList(l(map));
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) l.add(pair(e.getKey(), e.getValue()));
    return l;
  }

  static public boolean isAngleBracketed(String s) {
    return s.startsWith("<") && s.endsWith(">");
  }

  static public List<String> codeTokens(List<String> tok) {
    return codeTokensOnly(tok);
  }

  static public boolean isJavaxApplicationSnippetType(int type) {
    return type == snippetType_javaxSource() || type == snippetType_JavaXDesktop();
  }

  static public List<String> mechList_opt_tlft(String name) {
    return mechList_opt_tlft_cached(name);
  }

  static public <A> List<A> listPlus(Collection<A> l, A... more) {
    return concatLists(l, asList(more));
  }

  static public <A> List<A> sortByFieldInPlace(List<A> l, String field) {
    sort(l, fieldComparator(field));
    return l;
  }

  static public <A> List<A> sortByFieldInPlace(String field, List<A> l) {
    return sortByFieldInPlace(l, field);
  }

  static public <A extends AutoCloseable> A dm_ownResource(A resource) {
    dm_currentModuleMandatory().ownResource(resource);
    return resource;
  }

  static public List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  static public List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public String fromSingleQuoteIdentifier(String s) {
    return isSingleQuoteIdentifier(s) ? substring(s, 1) : s;
  }

  static public long collectMaxLong(Collection c, String field) {
    long x = Long.MIN_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = max(x, l);
    }
    return x;
  }

  static public boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
    return isConceptFieldIndexed(db_mainConcepts(), c, field);
  }

  static public boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
    return concepts.getFieldIndex(c, field) != null;
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  static public <A, B> List<Pair<A, B>> zipTwoListsToPairs_lengthOfFirst(List<A> l1, List<B> l2) {
    int n = l(l1);
    List<Pair<A, B>> out = emptyList(n);
    for (int i = 0; i < n; i++) addPair(out, l1.get(i), get(l2, i));
    return out;
  }

  static public <A> boolean containsAnythingNeq(Collection<A> l, A a) {
    for (A x : unnull(l)) if (neq(x, a))
      return true;
    return false;
  }

  static public String smartJoin(String[] args) {
    if (empty(args))
      return "";
    if (args.length == 1)
      return args[0];
    String[] a = new String[args.length];
    for (int i = 0; i < a.length; i++) a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
    return join(" ", a);
  }

  static public String smartJoin(List<String> args) {
    return smartJoin(toStringArray(args));
  }

  static final public boolean loadPageThroughProxy_enabled = false;

  static public String loadPageThroughProxy(String url) {
    return null;
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public void onUpdate(JComponent c, final Object r) {
    if (c instanceof JTextComponent)
      ((JTextComponent) c).getDocument().addDocumentListener(new DocumentListener() {

        public void insertUpdate(DocumentEvent e) {
          call(r);
        }

        public void removeUpdate(DocumentEvent e) {
          call(r);
        }

        public void changedUpdate(DocumentEvent e) {
          call(r);
        }
      });
    else if (c instanceof ItemSelectable)
      ((ItemSelectable) c).addItemListener(new ItemListener() {

        public void itemStateChanged(ItemEvent e) {
          call(r);
        }
      });
    else
      print("Warning: onUpdate doesn't know " + getClassName(c));
  }

  static public void onUpdate(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public String small(Object contents, Object... params) {
    return tag("small", contents, params);
  }

  static public String h2_title(String s) {
    return htitle_h2(s);
  }

  static public List<String> sortedIC(Collection<String> l) {
    return sortedIgnoreCase(l);
  }

  static public String addAnchorToURL(String url, String anchor) {
    int i = smartIndexOf(url, '#');
    url = takeFirst(url, i);
    if (nempty(anchor))
      url += "#" + anchor;
    return url;
  }

  static public <A> List<A> sortByFieldDesc(Collection<A> c, final String field) {
    return sortedByFieldDesc(c, field);
  }

  static public <A> List<A> sortByFieldDesc(String field, Collection<A> c) {
    return sortedByFieldDesc(field, c);
  }

  static public <A, B> List<Pair<A, B>> zipTwoListsToPairs_longer(List<A> l1, List<B> l2) {
    int n = max(l(l1), l(l2));
    List<Pair<A, B>> out = emptyList(n);
    for (int i = 0; i < n; i++) addPair(out, _get(l1, i), _get(l2, i));
    return out;
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      {
        if (f != null)
          f.get(a);
      }
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public <A> A pcallF(IF0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(IF1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

  static public AutoCloseable holdInstance(Object o) {
    if (o == null)
      return null;
    listThreadLocalAdd(holdInstance_l, o);
    return new AutoCloseable() {

      public void close() {
        listThreadLocalPopLast(holdInstance_l);
      }
    };
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public void ownResource(AutoCloseable c) {
    _registerAutoCloseable(c);
  }

  static public String makePostData(Map map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : castMapToMapO(map).entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public ThreadLocal<Object[]> dynamize_linkParams = new ThreadLocal();

  static public String dynamize_noEncode(String html) {
    List<String> tok = htmlTok(html);
    Pattern p = Pattern.compile(regexp_findSnippetIDs());
    for (int i = 0; i < l(tok); i += 2) {
      Matcher m = p.matcher(tok.get(i).replace("&#", "&~~~"));
      StringBuffer buf = new StringBuffer();
      while (m.find()) {
        String id = m.group(1);
        String link = m.group();
        try {
          link = ahref(snippetLink(id), link, concatArrays(new Object[] { "title", getSnippetTitle_cached(id) }, dynamize_linkParams.get()));
        } catch (Throwable __e) {
          _handleException(__e);
        }
        mreplace(m, buf, link);
      }
      m.appendTail(buf);
      String s = str(buf).replace("&~~~", "&#");
      tok.set(i, s);
    }
    dynamize_linkParams.set(null);
    return join(tok);
  }

  static public String nChars(long n) {
    return n2(n, "char");
  }

  static public String nChars(String s) {
    return nChars(l(s));
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    if (i >= end)
      return -1;
    String firstToken = tokens[0];
    if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
      while (i < end && !firstToken.equals(tok.get(i))) i += 2;
    }
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else
        matcher = t -> t.equals(p);
      matchers[j] = matcher;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public String hbuttonOnClick_returnFalse(String text, String onClick, Object... params) {
    return hfulltag("button", text, paramsPlus(params, "onclick", addSuffix(trim(onClick), ";") + " return false;"));
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public String regexpFirstGroupIC(String pat, String s) {
    Matcher m = regexpIC(pat, s);
    if (m.find())
      return m.group(1);
    else
      return null;
  }

  static public List<String> tlft_j(String text) {
    return toLinesFullTrim_java(text);
  }

  static public int minutes() {
    return minutes(Calendar.getInstance());
  }

  static public int minutes(Calendar c) {
    return c.get(Calendar.MINUTE);
  }

  static public Object[] paramsPlus_skipFirst(Object[] a1, Object... a2) {
    if (odd(l(a1)))
      return itemPlusArray(first(a1), paramsPlus(dropFirst(a1), a2));
    return paramsPlus(a1, a2);
  }

  static public boolean endsWithNewLine(String s) {
    return endsWith(s, "\n");
  }

  static public String wrapInDiv(String html, Object... __) {
    String tag = getTag(firstToken(htmlTok(html)));
    return eqicOneOf(tag, "div", "p") ? html : div(html, __);
  }

  static public <A> void syncRemoveLast(List<A> l) {
    if (l != null)
      synchronized (l) {
        removeLast(l);
      }
  }

  static public void syncRemoveLast(List l, int n) {
    if (l != null)
      synchronized (l) {
        removeLast(l, n);
      }
  }

  static public void syncRemoveLast(int n, List l) {
    syncRemoveLast(l, n);
  }

  static public String strUnnull(Object o) {
    return o == null ? "" : str(o);
  }

  static public <A, B> A eitherAOpt(Either<A, B> e) {
    return e != null && e.isA() ? e.a() : null;
  }

  static public ContentsIndexedList<String> ciContentsIndexedList() {
    return new ContentsIndexedList<String>(ciMap());
  }

  static public void stream2file(InputStream in, File out) {
    try {
      mkdirsForFile(out);
      FileOutputStream fos = new FileOutputStream(out);
      copyStream(in, fos);
      in.close();
      fos.close();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String hjs(String script) {
    return hjs(script, (Object[]) null);
  }

  static public String hjs(String script, Object... __) {
    return hjavascript(script, __);
  }

  static public String hjs(JS script) {
    return hjs(script, (Object[]) null);
  }

  static public String hjs(JS script, Object... __) {
    return hjavascript(script == null ? null : script.get(), __);
  }

  static public JTextField onEnter(final JTextField tf, final Object action) {
    if (action == null || tf == null)
      return tf;
    tf.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          tf.selectAll();
          callF(action);
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    });
    return tf;
  }

  static public JButton onEnter(JButton btn, final Object action) {
    if (action == null || btn == null)
      return btn;
    btn.addActionListener(actionListener(action));
    return btn;
  }

  static public JList onEnter(JList list, Object action) {
    list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
    return list;
  }

  static public JComboBox onEnter(final JComboBox cb, final Object action) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (cb.isEditable()) {
              JTextField text = (JTextField) cb.getEditor().getEditorComponent();
              onEnter(text, action);
            } else {
              cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
              cb.getActionMap().put("enter", abstractAction("", new Runnable() {

                public void run() {
                  try {
                    cb.hidePopup();
                    callF(action);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "cb.hidePopup(); callF(action);";
                }
              }));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (cb.isEditable()) {\r\n      JTextField text = (JTextField) cb.getEditor().g...";
        }
      });
    }
    return cb;
  }

  static public JTable onEnter(final JTable table, final Object action) {
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    table.getActionMap().put("Enter", new AbstractAction() {

      public void actionPerformed(ActionEvent e) {
        callF(action, table.getSelectedRow());
      }
    });
    return table;
  }

  static public JTextField onEnter(Object action, JTextField tf) {
    return onEnter(tf, action);
  }

  static public void htmlencode_forParams_useV2() {
    htmlencode_forParams_useV2.set(true);
  }

  static public boolean vmBus_anyFalse(String msg, Object... args) {
    return contains(vmBus_queryAll(msg, args), false);
  }

  static public String ukTimeZone_string() {
    return "Europe/London";
  }

  static public JMenuItem jMenuItem(final String text) {
    return jmenuItem(text);
  }

  static public JMenuItem jMenuItem(String text, Object r) {
    return jmenuItem(text, r);
  }

  static public ChangeListener changeListener(final Object r) {
    return new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(r);
      }
    };
  }

  static public Rectangle screenRectangle() {
    return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
  }

  static public Rectangle screenRectangle(GraphicsDevice device) {
    if (device == null)
      return null;
    DisplayMode mode = device.getDisplayMode();
    return new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public <A> List<A> sortedByCalculatedFieldDesc(Collection<A> c, final Object f) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public <A> List<A> sortedByCalculatedFieldDesc(Object f, Collection<A> c) {
    return sortByCalculatedFieldDesc(f, c);
  }

  static public <A, B> List<A> sortedByCalculatedFieldDesc(Iterable<A> c, IF1<A, B> f) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedFieldDesc(IF1<A, B> f, Iterable<A> c) {
    return sortByCalculatedFieldDesc(f, c);
  }

  static public String pUnlessEmpty(String s, Object... __) {
    return empty(s) ? "" : p(s, __);
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateWithIndex1(Collection<A> l) {
    return iterateListWithIndex(l, 1);
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateWithIndex1(A[] l) {
    return iterateListWithIndex(asVirtualList(l), 1);
  }

  static public int bufferedInputStream_bufferSize = 65536;

  static public BufferedInputStream bufferedInputStream(int bufSize, File f) {
    try {
      return bufferedInputStream(bufSize, newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedInputStream bufferedInputStream(File f) {
    try {
      return bufferedInputStream(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedInputStream bufferedInputStream(InputStream in) {
    return new BufferedInputStream(in, bufferedInputStream_bufferSize);
  }

  static public BufferedInputStream bufferedInputStream(int bufSize, InputStream in) {
    return new BufferedInputStream(in, bufSize);
  }

  static public int indexOfIC_underscore(String a, String b) {
    int la = l(a), lb = l(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    elsewhere: for (int i = 0; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c2 = b.charAt(j);
        if (c2 == '_' || eqic(c2, a.charAt(i + j))) {
        } else
          continue elsewhere;
      }
      return i;
    }
    return -1;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public MechMode mechMode_value = new MechMode();

  static public MechMode mechMode() {
    return mechMode_value;
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public JPanel centerAndSouth(final Component c, final Component s) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          if (s != null)
            panel.add(BorderLayout.SOUTH, wrap(s));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public <A extends Image> A copyImageToClipboard(A img) {
    TransferableImage trans = new TransferableImage(img);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    vmBus_send("newClipboardContents", img);
    print("Copied image to clipboard (" + img.getWidth(null) + "*" + img.getHeight(null) + " px)");
    return img;
  }

  static public String unicodeFromCodePoint(int codePoint) {
    return codePointToString(codePoint);
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public long parseLongOpt(String s) {
    return isInteger(s) ? parseLong(s) : 0;
  }

  static public void litmap_impl_noOverwrite(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) putIfNotThere(map, x[i], x[i + 1]);
  }

  static public void toggleAlwaysOnTop(JFrame frame) {
    frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
  }

  static public <A> List<A> objectsWhereFieldGreaterThan(Collection<A> c, String field, Object value) {
    List<A> l = new ArrayList();
    for (A x : unnull(c)) if (cmp(getOpt(x, field), value) > 0)
      l.add(x);
    return l;
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public Cache<MultiMap<String, CountryDialCode>> countryDialCodesMultiMap_cache = new Cache<>(() -> countryDialCodesMultiMap_load());

  static public MultiMap<String, CountryDialCode> countryDialCodesMultiMap() {
    return countryDialCodesMultiMap_cache.get();
  }

  static public MultiMap<String, CountryDialCode> countryDialCodesMultiMap_load() {
    return treeMultiMapIndexByField("dialCode", countryDialCodes());
  }

  static public Object[] toObjectArray(Collection c) {
    return toObjectArray((Iterable) c);
  }

  static public Object[] toObjectArray(Iterable c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public BufferedInputStream bufferedFileInputStream(File f) {
    return bufferedInputStream(f);
  }

  static public BufferedInputStream bufferedFileInputStream(File f, int bufSize) {
    try {
      return new BufferedInputStream(new FileInputStream(f), bufSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A highestByFunction(Iterable<A> l, Object f) {
    A best = null;
    Object bestValue = null;
    if (l != null)
      for (A a : l) {
        Object val = callF(f, a);
        if (best == null || cmp(val, bestValue) > 0) {
          best = a;
          bestValue = val;
        }
      }
    return best;
  }

  static public <A> A highestByFunction(Object f, Iterable<A> l) {
    return highestByFunction(l, f);
  }

  static public <A> A highestByFunction(IF1<A, ? extends Comparable> f, Iterable<A> l) {
    return highestByFunction(l, (Object) f);
  }

  static public <A> A highestByFunction(Iterable<A> l, IF1<A, ? extends Comparable> f) {
    return highestByFunction(f, l);
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static public Dimension getScreenSize() {
    return Toolkit.getDefaultToolkit().getScreenSize();
  }

  static public <A extends Concept> A highestConceptByField(Class<A> c, String field) {
    return highestConceptByField(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> A highestConceptByField(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc) {
      Map.Entry e = ((NavigableMap) ((ConceptFieldIndexDesc) index).valueToObject.data).firstEntry();
      return e == null ? null : (A) first((Collection) e.getValue());
    }
    return highestByField(field, concepts.list(c));
  }

  static public Object process(String processorID, Object in) {
    return process(processorID, in, "in");
  }

  static public Object process(String processorID, Object in, String outVar) {
    try {
      Class processor = hotwire(processorID);
      set(processor, "in", in);
      call(processor, "main", new Object[] { new String[0] });
      return get(processor, outVar);
    } catch (Exception e) {
      throw new RuntimeException("Error in #" + parseSnippetID(processorID), e);
    }
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, List parts) {
    for (Object o : parts) panel.add(wrapForSmartAdd(o), layout);
    return panel;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, Object... parts) {
    return smartAddWithLayout(panel, layout, asList(flattenArray2(parts)));
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    Map m = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A key = __0.getKey();
      B val = __0.getValue();
      m.put(key, f.get(val));
    }
    return m;
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public <A> boolean syncNempty(Collection<A> l) {
    return !syncEmpty(l);
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String hbody(Object contents, Object... params) {
    return tag("body", contents, params);
  }

  static public Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String stringIf(boolean b, String s) {
    return stringIfTrue(b, s);
  }

  static public String stringIf(String s, boolean b) {
    return stringIf(b, s);
  }

  static public <A> A third(List<A> l) {
    return _get(l, 2);
  }

  static public <A> A third(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      if (!it.hasNext())
        return null;
      it.next();
    }
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A third(Producer<A> p) {
    if (p == null)
      return null;
    for (int _repeat_1 = 0; _repeat_1 < 2; _repeat_1++) {
      if (p.next() == null)
        return null;
    }
    return p.next();
  }

  static public <A> A third(A[] bla) {
    return bla == null || bla.length <= 2 ? null : bla[2];
  }

  static public <A, B, C> C third(T3<A, B, C> t) {
    return t == null ? null : t.c;
  }

  static public Integer min_withNull(Integer a, Integer b) {
    return a == null ? b : b == null ? a : (Integer) min(a, b);
  }

  static public String hsansserif() {
    return hcss("body { font-family: Sans-Serif; }");
  }

  static public void withCancelPoint(VF1<CancelPoint> r) {
    CancelPoint cp = newCancelPoint();
    try {
      try {
        callF(r, cp);
      } catch (Throwable e) {
        e = innerException(e);
        if (!(e instanceof CancelToCancelPoint && ((CancelToCancelPoint) e).cp == cp))
          rethrow(e);
      }
    } finally {
      _close(cp);
    }
  }

  static public void withCancelPoint(IVF1<CancelPoint> r) {
    CancelPoint cp = newCancelPoint();
    try {
      try {
        r.get(cp);
      } catch (Throwable e) {
        e = innerException(e);
        if (!(e instanceof CancelToCancelPoint && ((CancelToCancelPoint) e).cp == cp))
          rethrow(e);
      }
    } finally {
      _close(cp);
    }
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public String div_vbar(String... items) {
    return div_vbar(asList(items));
  }

  static public String div_vbar(Collection<String> items, Object... params) {
    return divUnlessEmpty(joinNemptiesWithVBar(items), params);
  }

  static public <A> List<A> lookupPossiblyIgnoreCase(MultiMap<String, A> map, String key) {
    if (map == null)
      return null;
    List<A> value = map.get(key);
    return !value.isEmpty() ? value : lookupIgnoreCase(map, key);
  }

  static public <A> A lookupPossiblyIgnoreCase(Map<String, A> map, String key) {
    if (map == null)
      return null;
    A value = map.get(key);
    return value != null ? value : lookupIgnoreCase(map, key);
  }

  static public boolean isSingleQuoteIdentifier(String s) {
    if (l(s) < 2 || s.charAt(0) != '\'' || !Character.isJavaIdentifierStart(s.charAt(1)))
      return false;
    for (int i = 2; i < l(s); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public List<String> javaTokWithAngleBrackets(String s) {
    return tok_combineAngleBrackets_keep(javaTok(s));
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
    return indexConceptFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
    ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
    return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
  }

  static public boolean containsRegexpIC(String s, String pat) {
    return compileRegexpIC(pat).matcher(s).find();
  }

  static public File javaCompile_overInternalBot(String src) {
    return javaCompile_overInternalBot(src, "");
  }

  static synchronized public File javaCompile_overInternalBot(String src, String dehlibs) {
    return CompilerBot.compile(src, dehlibs);
  }

  static public <A> AutoCloseable tempLoadingAnim(String msg) {
    return tempDisposeWindow(loadingAnim(msg));
  }

  static public <A extends Concept> Collection<A> conceptsWhereCI(Class<A> c, Object... params) {
    return findConceptsWhereCI(c, params);
  }

  static public Collection<Concept> conceptsWhereCI(String c, Object... params) {
    return findConceptsWhereCI(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhereCI(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhereCI(concepts, c, params);
  }

  static public List<Concept> conceptsWhereCI(Concepts concepts, String c, Object... params) {
    return findConceptsWhereCI(concepts, c, params);
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public List<String> htmlTok(String s) {
    return htmlcoarsetok(s);
  }

  static public int lCommonPrefix(String a, String b) {
    int i = 0, n = Math.min(l(a), l(b));
    while (i < n && a.charAt(i) == b.charAt(i)) ++i;
    return i;
  }

  static public String joinNemptiesWithSemicolon(String... strings) {
    return joinNempties("; ", strings);
  }

  static public String joinNemptiesWithSemicolon(Collection<String> strings) {
    return joinNempties("; ", strings);
  }

  static public String newLinesToSpaces_trim(String s) {
    return s == null ? null : trim(s).replaceAll("\\s*\r?\n\\s*", " ");
  }

  static public String javaTokDropTrailingN(String s) {
    List<String> tok = javaTok(s);
    return empty(last(tok)) ? unnull(s) : join(dropLast(tok));
  }

  static public String hms() {
    return hms(now());
  }

  static public String hms(long time) {
    return new SimpleDateFormat("HHmmss").format(time);
  }

  static public int min3(int a, int b, int c) {
    return min(min(a, b), c);
  }

  static public double min3(double a, double b, double c) {
    return min(min(a, b), c);
  }

  static public <A> A[] singlePlusArray(A a, A[] l) {
    A[] out = newObjectArrayOfSameType(l, l(l) + 1);
    out[0] = a;
    arraycopy(l, 0, out, 1, l(l));
    return out;
  }

  static public boolean eqic_gen(Object a, Object b) {
    return a instanceof String && b instanceof String && eqic((String) a, (String) b);
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public List<Object> record_list = synchroList();

  static public void record(Object o) {
    record_list.add(o);
  }

  static public String replaceAngleBracketVars_curly(String s, Map<String, String> map) {
    return replaceAngleBracketVars(s, mapValues(__81 -> curly(__81), map));
  }

  static public List<String> replaceAngleBracketVars_curly(List<String> tok, Map<String, String> map) {
    return replaceAngleBracketVars(tok, mapValues(__82 -> curly(__82), map));
  }

  static public String replaceAngleBracketVars_curly(String s, Object... params) {
    return replaceAngleBracketVars_curly(s, paramsToMap(params));
  }

  static public File secretProgramFile(String progID, String fileName) {
    return new File(getSecretProgramDir(progID), fileName);
  }

  static public File secretProgramFile(String fileName) {
    return secretProgramFile(getProgramID(), fileName);
  }

  static public int numberOfWords2(String s) {
    return l(words2(s));
  }

  static public TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  static public Lock hotwireCached_lock = lock();

  static public Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  static public Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  static public Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __0 = hotwireCached_lock;
    lock(__0);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__0);
    }
  }

  public static boolean isWindows() {
    return System.getProperty("os.name").contains("Windows");
  }

  static public boolean phraseCache(String pattern, String s) {
    return mmo2_match(pattern, s);
  }

  static public boolean phraseCache(MMOPattern pattern, String s) {
    return mmo2_match(pattern, s);
  }

  static public IF1<String, Boolean> phraseCache(String pattern) {
    return phraseCache(mmo2_parsePattern(pattern));
  }

  static public IF1<String, Boolean> phraseCache(MMOPattern pattern) {
    return s -> phraseCache(pattern, s);
  }

  static public Map<String, String> mechMap(String listName) {
    return mechMapCI(listName);
  }

  static public String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public String tok_firstClassName(List<String> tok) {
    int i = jfind(tok, "class <id>");
    return i < 0 ? null : tok.get(i + 2);
  }

  static public String newLinesToSpaces(String s) {
    return s == null ? null : fixNewLines(s).replace("\n", " ");
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public JInternalFrame getInternalFrame(final Object _o) {
    return _o == null ? null : swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JInternalFrame)
              return (JInternalFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public int roundToInt(double d) {
    return (int) Math.round(d);
  }

  static public <A> A evalInQ(Q q, final F0<A> f) {
    if (isInQ(q))
      return callF(f);
    final Var<Either<A, Throwable>> var = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            var.set(eitherA(callF(f)));
          } catch (Throwable e) {
            var.set(eitherB(e));
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      var.set(eitherA(callF(f)));\r\n    } catch (Throwable e) {\r\n      ...";
      }
    });
    return returnOrThrow_either(waitForVarToBeNotNull(var));
  }

  static public F0 runnableToF0(Runnable r) {
    return r == null ? null : new F0<Object>() {

      public Object get() {
        try {
          r.run();
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "r.run(); null;";
      }
    };
  }

  static public List<String> regexpExtractAll(String pat, String s) {
    if (s == null)
      return null;
    Matcher m = regexpMatcher(pat, s);
    List<String> out = new ArrayList();
    while (m.find()) out.add(m.group());
    return out;
  }

  static public String htitle_h2(String s) {
    return htitle_noEncode(dropTags(s)) + h2(s);
  }

  static public String htitle_h1(String s) {
    return htitle_noEncode(dropTags(s)) + h1(s);
  }

  static public Map<String, String> stdFunctions_cached_map;

  static public Lock stdFunctions_cached_lock = lock();

  static public Map<String, String> stdFunctions_cached() {
    Lock __0 = stdFunctions_cached_lock;
    lock(__0);
    try {
      if (stdFunctions_cached_map == null)
        stdFunctions_cached_map = stdFunctions_uncached();
      return stdFunctions_cached_map;
    } finally {
      unlock(__0);
    }
  }

  static synchronized public void stdFunctions_clearCache() {
    stdFunctions_cached_map = null;
  }

  static public HashSet mapToHashSet(Object f, Iterable l) {
    HashSet x = new HashSet(l(l));
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> HashSet<B> mapToHashSet(IF1<A, B> f, Iterable<A> l) {
    return mapToHashSet((Object) f, l);
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public String domain() {
    return domainName();
  }

  static public List<String> tokSplitAtComma(String s) {
    List<String> tok = javaTok(s);
    List<String> l = new ArrayList();
    while (l(tok) > 1) {
      int i = smartIndexOf(tok, ",");
      l.add(trim(join(subList(tok, 0, i))));
      tok = subList(tok, i + 1);
    }
    return l;
  }

  static public JComponent getTitlePaneComponent(RootPaneContainer window) {
    if (window instanceof JInternalFrame)
      return getInternalFrameTitlePaneComponent((JInternalFrame) window);
    if (!substanceLookAndFeelEnabled() || window == null)
      return null;
    JRootPane rootPane = window.getRootPane();
    if (rootPane != null) {
      Object ui = rootPane.getUI();
      return (JComponent) call(ui, "getTitlePane");
    }
    return null;
  }

  static public String hdesktopNotifications() {
    return hscript("\r\n    function sendDesktopNotification(text, options) {\r\n      if (\"Notification\" in window && Notification.permission === \"granted\")\r\n        new Notification(text, options);\r\n    }\r\n    window.sendDesktopNotification = sendDesktopNotification;\r\n    \r\n    function initDesktopNotifications() {\r\n      if (!(\"Notification\" in window))\r\n        $(\"#notiStatus\").html(\"Desktop notifications not supported in this browser\");\r\n      else if (Notification.permission === \"granted\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications enabled\");\r\n      else if (Notification.permission === \"denied\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications denied\");\r\n      else {\r\n        $(\"#notiStatus\").html(\"Requesting permission for desktop notifications\");\r\n        Notification.requestPermission().then(function (permission) {\r\n          initDesktopNotifications();\r\n          sendDesktopNotification(\"Notifications will look like this!\");\r\n        });\r\n      }\r\n    }\r\n    \r\n    $(document).ready(initDesktopNotifications);\r\n  ");
  }

  static public String rtrim_fromLines(Collection lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null) {
      boolean first = true;
      for (Object line : lines) {
        if (first)
          first = false;
        else
          buf.append('\n');
        buf.append(str(line));
      }
    }
    return buf.toString();
  }

  static public void showConsole() {
    callOpt(get(javax(), "console"), "showConsole");
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean isLowerCase(char c) {
    return Character.isLowerCase(c);
  }

  static public Map<String, String> parseColonProperties(String text) {
    return parseColonProperties(text, new LinkedHashMap());
  }

  static public Map<String, String> parseColonProperties(String text, Map<String, String> map) {
    for (String s : tlft(text)) {
      int i = indexOf(s, ':');
      if (i > 0)
        map.put(trimSubstring(s, 0, i), trimSubstring(s, i + 1));
    }
    return map;
  }

  static public boolean regexpFindsIC(String pat, String s) {
    return regexpIC(pat, s).find();
  }

  static public String mapToLines_rtrim(Object f, Map map) {
    return lines_rtrim(map(map, f));
  }

  static public String mapToLines_rtrim(Object f, Iterable l) {
    return lines_rtrim(map(f, l));
  }

  static public <A> String mapToLines_rtrim(Iterable<A> l, IF1<A, String> f) {
    return mapToLines_rtrim(f, l);
  }

  static public Object subBot_serve404() {
    return call(getMainBot(), "serve404");
  }

  static public Object subBot_serve404(String msg) {
    return call(getMainBot(), "serve404", msg);
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] paramsPlus(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) {
      Object key = a2[i];
      if (key != null)
        map.put(key, a2[i + 1]);
    }
    return mapToParams(map);
  }

  static public Object[] paramsPlus(Map a1, Object... a2) {
    return paramsPlus(new Object[] { a1 }, a2);
  }

  static public List<String> splitAtColon(String s) {
    return empty(s) ? emptyList() : asList(s.split(":"));
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public ActionListener actionListener(final Object runnable) {
    return actionListener(runnable, null);
  }

  static public ActionListener actionListener(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    final Object info = _threadInfo();
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          _threadInheritInfo(info);
          AutoCloseable __1 = holdInstance(instanceToHold);
          try {
            callF(runnable);
          } finally {
            _close(__1);
          }
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public boolean isDollarVar(String s) {
    return startsWith(s, '$') && l(s) > 1;
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public boolean find3(String pat, String s) {
    return find3(pat, s, null);
  }

  static public boolean find3(String pat, String s, Matches matches) {
    return find3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean find3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    String[] m = find2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public String loadSnippet_cached(String id) {
    return loadSnippet_simpleCache(id);
  }

  static public String[] find2(List<String> pat, List<String> tok) {
    for (int idx = 0; idx < tok.size(); idx += 2) {
      String[] result = find2(pat, tok, idx);
      if (result != null)
        return result;
    }
    return null;
  }

  static public String[] find2(List<String> pat, List<String> tok, int idx) {
    if (idx + pat.size() > tok.size())
      return null;
    List<String> result = new ArrayList();
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(idx + i);
      if (eq(p, "*"))
        result.add(t);
      else if (!p.equalsIgnoreCase(t))
        return null;
    }
    return toStringArray(result);
  }

  static public String hreconnectingWebSockets() {
    return hjavascript_src_snippet(hreconnectingWebSockets_snippetID());
  }

  static public String pre_htmlencode(Object contents, Object... params) {
    return pre(htmlencode_noQuotes(str(contents)), params);
  }

  static public Rectangle rectangleUnion(Rectangle a, Rectangle b) {
    return a == null ? b : b == null ? a : a.union(b);
  }

  static public String addSlashPrefix(String s) {
    return addPrefix("/", s);
  }

  static public void duplicateThisProgram() {
    nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
  }

  static public String hscript(String script) {
    return hjavascript(script);
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String ipToCountry2020_safe(String ip) {
    try {
      return or2(ipToCountry2020(ip), "?");
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return "?";
  }

  static public String htmldecode(final String input) {
    if (input == null)
      return null;
    final int MIN_ESCAPE = 2;
    final int MAX_ESCAPE = 6;
    StringWriter writer = null;
    int len = input.length();
    int i = 1;
    int st = 0;
    while (true) {
      while (i < len && input.charAt(i - 1) != '&') i++;
      if (i >= len)
        break;
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';') j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
        i++;
        continue;
      }
      if (input.charAt(i) == '#') {
        int k = i + 1;
        int radix = 10;
        final char firstChar = input.charAt(k);
        if (firstChar == 'x' || firstChar == 'X') {
          k++;
          radix = 16;
        }
        try {
          int entityValue = Integer.parseInt(input.substring(k, j), radix);
          if (writer == null)
            writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));
          if (entityValue > 0xFFFF) {
            final char[] chrs = Character.toChars(entityValue);
            writer.write(chrs[0]);
            writer.write(chrs[1]);
          } else {
            writer.write(entityValue);
          }
        } catch (NumberFormatException ex) {
          i++;
          continue;
        }
      } else {
        CharSequence value = htmldecode_lookupMap().get(input.substring(i, j));
        if (value == null) {
          i++;
          continue;
        }
        if (writer == null)
          writer = new StringWriter(input.length());
        writer.append(input.substring(st, i - 1));
        writer.append(value);
      }
      st = j + 1;
      i = st;
    }
    if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
    }
    return input;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_cache;

  static public HashMap<String, CharSequence> htmldecode_lookupMap() {
    if (htmldecode_lookupMap_cache == null)
      htmldecode_lookupMap_cache = htmldecode_lookupMap_load();
    return htmldecode_lookupMap_cache;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_load() {
    var map = new HashMap<String, CharSequence>();
    for (CharSequence[] seq : htmldecode_escapes()) map.put(seq[1].toString(), seq[0]);
    return map;
  }

  static public String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  static public String td_valignTop(Object contents, Object... params) {
    return tdTop(contents, params);
  }

  static public String fileInfo(File f) {
    return renderFileInfo(f);
  }

  static public String fileInfo(String f) {
    return renderFileInfo(newFile(f));
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public boolean getServerTranspiled2_allowLocalFallback = true, getServerTranspiled2_localFallbackVerbose = true;

  static public Map<String, String> getServerTranspiled2_tempCache;

  static public String getServerTranspiled2(String id) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getTranspiled(id);
    return getServerTranspiled2_noResourceLoader(id);
  }

  static public String getServerTranspiled2_noResourceLoader(String id) {
    id = fsIOpt(id);
    String transpiled = mapGet(getServerTranspiled2_tempCache, id);
    if (transpiled != null)
      return transpiled;
    transpiled = loadCachedTranspilation(id);
    String md5 = null;
    if (machineIsOffline() || isOfflineMode() || isLocalSnippet(id))
      return transpiled;
    if (transpiled != null)
      md5 = md5(transpiled);
    String transpiledSrc;
    try {
      transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
    } catch (Throwable e) {
      if (!getServerTranspiled2_allowLocalFallback)
        rethrow(e);
      printExceptionShort(e);
      if (getServerTranspiled2_localFallbackVerbose)
        print("Fallback to local code");
      return transpiled;
    }
    if (eq(transpiledSrc, "SAME")) {
      if (!isTrue(loadPage_silent.get()))
        print("SAME");
      return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiled);
    }
    return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiledSrc);
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public List<String> findMainClass(List<String> tok) {
    for (List<String> c : reversedList(allClasses(tok))) {
      String name = getClassDeclarationName(c);
      if (eq(name, "main") || name.startsWith("x"))
        return c;
    }
    return findBlock("m {", tok);
  }

  static public boolean intRangeContains(IntRange r, int i) {
    return r != null && i >= r.start && i < r.end;
  }

  static public LinkedHashMap mapToOrderedMap(Object f, Iterable l) {
    LinkedHashMap map = new LinkedHashMap();
    for (Object o : unnullForIteration(l)) {
      Pair p = (Pair) (callF(f, o));
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
    LinkedHashMap<B, C> map = new LinkedHashMap();
    for (A o : unnullForIteration(l)) {
      Pair<B, C> p = callF(f, o);
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(Iterable<A> l, IF1<A, Pair<B, C>> f) {
    return mapToOrderedMap(f, l);
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    return (HashMap) getOpt_getFieldMap(o);
  }

  static public String hreplaceTitle(String html, String newTitle) {
    return hreplacetag(html, "title", htitle(newTitle));
  }

  static public String toString(Object o) {
    return strOrNull(o);
  }

  static public long collectMinLong(Collection c, String field) {
    long x = Long.MAX_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = min(x, l);
    }
    return x;
  }

  static public <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
    if (c == null)
      return null;
    {
      swing(new Runnable() {

        public void run() {
          try {
            String s = nullIfEmpty(str(toolTip));
            if (neq(s, c.getToolTipText()))
              c.setToolTipText(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "String s = nullIfEmpty(str(toolTip));\r\n    if (neq(s, c.getToolTipText()))\r\n ...";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setToolTipText(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public boolean makeAndroid3_disable = false;

  static public class Android3 implements AutoCloseable {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public void close() {
      dispose();
    }

    synchronized public void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  static abstract public class Responder {

    abstract public String answer(String s, List<String> history);
  }

  static public Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  static public Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  static public Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  static public void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  static public DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  static public String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  static public String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  static public boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  static public Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  static public ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  static public Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  static public String jsBool(boolean b) {
    return b ? "true" : "false";
  }

  static public boolean isOpeningTag(String token, String tag) {
    return isTag(token, tag) && !token.endsWith("/>");
  }

  static public boolean isOpeningTag(String token) {
    return token.startsWith("<") && token.endsWith(">") && !token.endsWith("/>") && isLetter(token.charAt(1));
  }

  static public boolean showAnimationInTopRightCorner_alwaysOnTop = true;

  static public boolean showAnimationInTopRightCorner_on = true;

  static public JWindow showAnimationInTopRightCorner(String imageID, String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(imageID), text);
  }

  static public JWindow showAnimationInTopRightCorner(final Image image, final String text) {
    if (image == null || isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return showAnimationInTopRightCorner(imageIcon(image), text);
  }

  static public JWindow showAnimationInTopRightCorner(final ImageIcon imageIcon, final String text) {
    if (isHeadless() || !showAnimationInTopRightCorner_on)
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          JLabel label = new JLabel(imageIcon);
          if (nempty(text)) {
            label.setText(text);
            label.setVerticalTextPosition(SwingConstants.BOTTOM);
            label.setHorizontalTextPosition(SwingConstants.CENTER);
          }
          final JWindow window = showInTopRightCorner(label);
          onClick(label, new Runnable() {

            public void run() {
              try {
                window.dispose();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "window.dispose()";
            }
          });
          if (showAnimationInTopRightCorner_alwaysOnTop)
            window.setAlwaysOnTop(true);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JLabel label = new JLabel(imageIcon);\r\n    if (nempty(text)) {\r\n      label.s...";
      }
    });
  }

  static public JWindow showAnimationInTopRightCorner(final String imageID) {
    return showAnimationInTopRightCorner(imageID, "");
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, double seconds) {
    return showAnimationInTopRightCorner(imageID, "", seconds);
  }

  static public JWindow showAnimationInTopRightCorner(String imageID, String text, double seconds) {
    if (isHeadless())
      return null;
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(imageID, text));
  }

  static public JWindow showAnimationInTopRightCorner(BufferedImage img, String text, double seconds) {
    return disposeWindowAfter(iround(seconds * 1000), showAnimationInTopRightCorner(img, text));
  }

  static public byte[] loadBinaryFromZip(File inZip, String fileName) {
    try {
      ZipFile zip = new ZipFile(inZip);
      try {
        ZipEntry entry = zip.getEntry(fileName);
        if (entry == null)
          return null;
        InputStream fin = zip.getInputStream(entry);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        copyStream(fin, baos);
        fin.close();
        return baos.toByteArray();
      } finally {
        zip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  static public String div() {
    return div("");
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public double div(double a, double b) {
    return a / b;
  }

  static public String squareBracket(String s) {
    return "[" + s + "]";
  }

  static public void addComponentsFirst(Container c, Component... l) {
    containerAddFirst(c, l);
  }

  static public String hdivWithID(String id, Object contents, Object... params) {
    return hdiv(contents, paramsPlus(params, "id", id));
  }

  static public void stepAllWithTimeout(double timeout, Steppable s) {
    if (s == null)
      return;
    long endTime = sysNow() + toMS(timeout);
    do {
      ping();
    } while (s.step() && sysNow() < endTime);
  }

  static public boolean tok_isJavaxMetaCommandLeftOf(List<String> tok, int i) {
    int j = i - 2 * 4 - 1;
    if (j >= 0 && jfind(subList(tok, j, i), "set flag <id> .") == 1)
      return true;
    return false;
  }

  static public <A> Chain<A> toChain(Iterable<A> l) {
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    Chain<A> c = new Chain<>(it.next());
    Chain<A> last = c;
    int size = 1;
    while (it.hasNext()) {
      ++size;
      Chain x = new Chain(it.next());
      last.next = x;
      last = x;
    }
    Chain<A> x = c;
    while (x != null) {
      x.size = size--;
      x = x.next;
    }
    return c;
  }

  static public Object[] arrayPlus(Object[] a1, Object... a2) {
    return concatArrays(a1, a2);
  }

  static public List<String> tok_splitAtPlus(String s) {
    return tok_splitAtPlus(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtPlus(List<String> tok) {
    return splitAtTokens(tok, "+");
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public <A extends Concept> List<A> filterConceptsIC(Collection<A> list, Object... params) {
    List<A> l = new ArrayList();
    if (list != null)
      for (A x : list) if (checkConceptFieldsIC(x, params))
        l.add(x);
    return l;
  }

  static public <A extends Concept> List<A> sortedByConceptIDDesc(Collection<A> c) {
    return sortedByCalculatedFieldDesc(__83 -> conceptID(__83), c);
  }

  static public String renderVars_struct(Object... params) {
    List<String> l = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) l.add(params[i] + "=" + struct(params[i + 1]) + ". ");
    return trim(join(l));
  }

  static public String formatLocalDateWithSeconds(long time) {
    return localDateWithSeconds(time);
  }

  static public String formatLocalDateWithSeconds() {
    return localDateWithSeconds();
  }

  static public String joinNemptiesWithColon(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColon(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public String snippetRawURL_maxCache(String snippetID) {
    return snippetRawURL_maxCache(snippetID, null);
  }

  static public String snippetRawURL_maxCache(String snippetID, String contentType) {
    return "https://botcompany.de/serve/" + psI(snippetID) + htmlQuery("ct", contentType, "maxCache", 1);
  }

  static public Map<String, String> parseDoubleLeftArrowMapCI(List<String> l) {
    return parseDoubleLeftArrowMap((Map) ciMap(), l);
  }

  static public String joinNemptiesWithSpace(String... strings) {
    return joinNempties(" ", strings);
  }

  static public String joinNemptiesWithSpace(Collection<String> strings) {
    return joinNempties(" ", strings);
  }

  static public boolean forbiddenPort(int port) {
    return port == 5037;
  }

  static public String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  static public <A extends Concept> Collection<A> conceptsWhereIC(Class<A> c, Object... params) {
    return findConceptsWhereCI(c, params);
  }

  static public List<Concept> conceptsWhereIC(String c, Object... params) {
    return findConceptsWhereCI(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhereIC(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhereCI(concepts, c, params);
  }

  static public List<Concept> conceptsWhereIC(Concepts concepts, String c, Object... params) {
    return findConceptsWhereCI(concepts, c, params);
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public int month() {
    return localMonth();
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public String domainName() {
    Object session = call(getMainBot(), "getSession");
    Map headers = (Map) (call(session, "getHeaders"));
    String host = (String) (headers.get("host"));
    if (host == null)
      return null;
    return dropFrom(host, ":");
  }

  static public boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  static public Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  static public <A, B> B secondOfPair(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public boolean renameFile(File a, File b) {
    mkdirsForFile(b);
    return a.renameTo(b);
  }

  static public boolean renameFile(File a, String newName) {
    return renameFile(a, fileInSameDir(a, newName));
  }

  static public Object[] unrollParams(Object[] params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToParams((Map) params[0]);
    return params;
  }

  static public String dropLoadableUtilsPackageFromStruct(String s) {
    String prefix = "loadableUtils.utils$";
    if (!contains(s, "loadableUtils.utils$"))
      return s;
    List<String> tok = javaTokForStructure(s);
    for (int i = 5; i < l(tok); i += 2) if (eqGet(tok, i - 4, "loadableUtils") && eqGet(tok, i - 2, "."))
      replaceTokens(tok, i - 4, i + 1, dropPrefix("utils$", tok.get(i)));
    return join(tok);
  }

  static public String optionalCurlyBrace(String s) {
    return isCurlyBraced(s) ? s : curlyBrace(s);
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
  }

  static public boolean regionMatches(String a, int offsetA, String b) {
    return regionMatches(a, offsetA, b, 0, l(b));
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public <A> List<A> replaceAll(List<A> l, final A a, final A b) {
    return map(l, new F1<A, A>() {

      public A get(A x) {
        try {
          return eq(x, a) ? b : x;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "eq(x, a) ? b : x";
      }
    });
  }

  static public String replaceAll(String s, String a, String b) {
    return s == null ? null : s.replaceAll(a, b);
  }

  static public String joinWithPlus(Collection<String> c) {
    return join("+", c);
  }

  static public String joinWithPlus(String... c) {
    return join("+", c);
  }

  static public <A> A collectionGet(Collection<A> c, int idx) {
    if (c == null || idx < 0 || idx >= l(c))
      return null;
    if (c instanceof List)
      return listGet((List<A>) c, idx);
    Iterator<A> it = c.iterator();
    for (int i = 0; i < idx; i++) if (it.hasNext())
      it.next();
    else
      return null;
    return it.hasNext() ? it.next() : null;
  }

  static public void frameStandardSize(JFrame frame) {
    frame.setBounds(300, 100, 500, 400);
  }

  static public int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public String hcomment(String text) {
    return hcommentSafe(text);
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public String htd(Object contents, Object... params) {
    return htag("td", contents, params);
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static public List<File> loadLibraries(List<String> snippetIDs) {
    return map("loadLibrary", snippetIDs);
  }

  static public <A> A postProcess(Object f, A a) {
    return callPostProcessor(f, a);
  }

  static public <A> A postProcess(IF1<A, A> f, A a) {
    return callPostProcessor(f, a);
  }

  static public boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public String htextfield(String name, Object... params) {
    return htextinput(name, params);
  }

  static public <A> List<A> syncInstancesOf(Iterable i, Class<A> c) {
    if (i == null)
      return new ArrayList();
    synchronized (i) {
      return collectInstances(i, c);
    }
  }

  static public <A> List<A> syncInstancesOf(Class<A> c, Iterable i) {
    return syncInstancesOf(i, c);
  }

  static public List map_ping(Iterable l, Object f) {
    return map_ping(f, l);
  }

  static public List map_ping(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map_ping(Iterable<A> l, F1<A, B> f) {
    return map_ping(f, l);
  }

  static public <A, B> List<B> map_ping(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map_ping(IF1<A, B> f, Iterable<A> l) {
    return map_ping(l, f);
  }

  static public <A, B> List<B> map_ping(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B> List<B> map_ping(IF1<A, B> f, A[] l) {
    return map_ping(l, f);
  }

  static public <A, B> List<B> map_ping(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public List map_ping(Object f, Object[] l) {
    return map_ping(f, asList(l));
  }

  static public List map_ping(Object[] l, Object f) {
    return map_ping(f, l);
  }

  static public List map_ping(Object f, Map map) {
    return map_ping(map, f);
  }

  static public List map_ping(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map_ping(Map<A, B> map, IF2<A, B, C> f) {
    return map_ping(map, (Object) f);
  }

  static public String hhidden(String name, Object value, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "hidden", "name", name, "value", value }, params));
  }

  static public String hhidden(Map<String, String> map, String... keys) {
    return hiddenFields(map, keys);
  }

  static public <A, B> Comparator<A> mapComparatorDesc(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(b), map.get(a));
      }
    };
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    return linesFromReader(r, null);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r, IResourceHolder resourceHolder) {
    final BufferedReader br = bufferedReader(r);
    return holdResource(resourceHolder, iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r)));
  }

  static public void setOptAll(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) setOpt(o, field, fields.get(field));
  }

  static public void setOptAll(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      setOpt(o, field, value);
    }
  }

  static public <A extends JComponent> A bindLiveValueListenerToComponent(A component, final LiveValue lv, final Runnable listener) {
    if (lv != null)
      bindToComponent(component, new Runnable() {

        public void run() {
          try {
            lv.onChangeAndNow(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef bindLiveValueListenerToComponent_debug\r\n          print(\"bindLiveValueL...";
        }
      }, new Runnable() {

        public void run() {
          try {
            lv.removeOnChangeListener(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lv.removeOnChangeListener(listener)";
        }
      });
    return component;
  }

  static public boolean isOfflineMode() {
    return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
  }

  static public int length(Object[] array) {
    return array == null ? 0 : array.length;
  }

  static public int length(List list) {
    return list == null ? 0 : list.size();
  }

  static public int length(String s) {
    return s == null ? 0 : s.length();
  }

  static public void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  static public void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  static public Map<JFrame, Boolean> myFrames_list = weakHashMap();

  static public List<JFrame> myFrames() {
    return swing(new F0<List<JFrame>>() {

      public List<JFrame> get() {
        try {
          return keysList(myFrames_list);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret keysList(myFrames_list);";
      }
    });
  }

  static public <A, B> MultiSet<A> multiSetMapToMultiSet(MultiSetMap<A, B> mm) {
    MultiSet<A> ms = new MultiSet();
    for (A a : keys(mm)) ms.add(a, l(mm.get(a)));
    return ms;
  }

  static public String ulIfNempty(Collection list, Object... params) {
    return empty(list) ? "" : ul(list, params);
  }

  static public Object callAndMake_orDirect(String functionName, List args) {
    return callAndMake_orDirect(functionName, toObjectArray(args));
  }

  static public Object callAndMake_orDirect(String functionName, Object... args) {
    if (functionName == null)
      return null;
    if (hasMethod(mc(), functionName, args))
      return callMC(functionName, args);
    else
      return makeAndCall_cached(functionName, args);
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public File touchFile(File file) {
    try {
      closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int totalPreferredHeight(List<Component> l) {
    int h = 0;
    for (Component c : unnull(l)) h += c.getPreferredSize().height;
    return h;
  }

  static public Rectangle toRectangle(Rect r) {
    return r == null ? null : r.getRectangle();
  }

  static public Object[] assertEvenLength(Object[] a) {
    assertTrue(even(l(a)));
    return a;
  }

  static public List<String> allMethodNames(Object o) {
    Class c = _getClass(o);
    TreeSet<String> names = new TreeSet();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) names.add(m.getName());
      c = c.getSuperclass();
    }
    return asList(names);
  }

  static public Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  static public void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  static public void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  static public Runnable _topLevelErrorHandling(Runnable r) {
    if (r == null)
      return null;
    Object info = _threadInfo();
    Object mod = dm_current_generic();
    if (info == null && mod == null)
      return r;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = (AutoCloseable) (rcall("enter", mod));
          try {
            _threadInheritInfo(info);
            r.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp (AutoCloseable) rcall enter(mod);\r\n    _threadInheritInfo(info);\r\n    r....";
      }
    };
  }

  static public AlphanumComparator alphaNumComparatorIC_instance;

  static public Comparator<String> alphaNumComparatorIC() {
    if (alphaNumComparatorIC_instance == null) {
      AlphanumComparator ac = new AlphanumComparator();
      ac.ignoreCase = true;
      alphaNumComparatorIC_instance = ac;
    }
    return alphaNumComparatorIC_instance;
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JFrame consoleFrame() {
    return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
  }

  static public String stackTraceForThread(Thread t) {
    return t == null ? null : lines(t.getStackTrace());
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  static public <A, B> IterableIterator<Pair<A, B>> mapPairs(Map<A, B> map) {
    final Iterator<Map.Entry<A, B>> it = map.entrySet().iterator();
    return iteratorFromFunction(new F0<Pair<A, B>>() {

      public Pair<A, B> get() {
        try {
          if (it.hasNext()) {
            Map.Entry<A, B> entry = it.next();
            return pair(entry.getKey(), entry.getValue());
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (it.hasNext()) {\r\n      Map.Entry<A, B> entry = it.next();\r\n      ret pair...";
      }
    });
  }

  static public <A, B, C> List<C> mapPairs(Iterable<Pair<A, B>> l, IF2<A, B, C> f) {
    return mapPairsToList(l, f);
  }

  static public int identityHashCode(Object o) {
    return System.identityHashCode(o);
  }

  static public <A> A assertBiggerThan(A a, A b) {
    assertTrue(cmp(b, a) > 0);
    return b;
  }

  static public String dropUriPrefix(String prefix, String uri) {
    prefix = dropTrailingSlash(prefix);
    if (empty(prefix))
      return uri;
    if (eq(uri, prefix) || startsWith(uri, prefix + "/"))
      return substring(uri, l(prefix));
    return uri;
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        vmBus_send("locking", lock, "thread", currentThread());
        lock.lockInterruptibly();
        vmBus_send("locked", lock, "thread", currentThread());
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public String hframeset_cols(String cols, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "cols", cols));
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public int globalIDLength() {
    return 16;
  }

  static public void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public <A> A swingNu(final Class<A> c, final Object... args) {
    return swingConstruct(c, args);
  }

  static public String firstToLower(String s) {
    if (empty(s))
      return s;
    return Character.toLowerCase(s.charAt(0)) + s.substring(1);
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public String htmlEncode2_gen(Object o) {
    return htmlEncode2(strOrEmpty(o));
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static public String simpleSpacesTrim_javaTok(String s) {
    return trim(simpleSpaces_javaTok(s));
  }

  static public <A> List<A> concatLists_syncIndividual(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) syncAddAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists_syncIndividual(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) syncAddAll(l, list);
    return l;
  }

  static public JButton jbutton(String text, Object action) {
    return newButton(text, action);
  }

  static public JButton jbutton(String text) {
    return newButton(text, null);
  }

  static public JButton jbutton(Action action) {
    return swingNu(JButton.class, action);
  }

  static public ThreadLocal makeAndCall_initChild = new ThreadLocal();

  static public Object makeAndCall_cached(String functionName, Object... args) {
    Class c = loadFunctions_cached(functionName);
    AutoCloseable closer = (AutoCloseable) (callF(makeAndCall_initChild.get(), c));
    AutoCloseable __1 = closer;
    try {
      return preciseCall(c, functionName, args);
    } finally {
      _close(__1);
    }
  }

  static public JTextArea jtextarea() {
    return jTextArea();
  }

  static public JTextArea jtextarea(String text) {
    return jTextArea(text);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  static public <A extends JComponent> A setEnabled(A c, boolean enable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setEnabled(enable);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setEnabled(enable);";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setEnabled(boolean enable, A c) {
    return setEnabled(c, enable);
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public String hpostform(Object contents, Object... params) {
    return tag("form", contents, concatArrays(new Object[] { "method", "POST" }, params));
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public Map<String, MechListDependentCache<List<String>>> mechList_opt_tlft_cached_cache = ciMap();

  static public Lock mechList_opt_tlft_cached_lock = lock();

  static public List<String> mechList_opt_tlft_cached(String name) {
    MechListDependentCache<List<String>> listCache;
    {
      Lock __0 = mechList_opt_tlft_cached_lock;
      lock(__0);
      try {
        listCache = mechList_opt_tlft_cached_cache.get(name);
        if (listCache == null)
          mechList_opt_tlft_cached_cache.put(name, listCache = new MechListDependentCache(name, new F1<String, List<String>>() {

            public List<String> get(String x) {
              try {
                return tlft(x);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "tlft(x)";
            }
          }));
      } finally {
        unlock(__0);
      }
    }
    return listCache.get();
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public Matcher regexpIC(Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public Matcher regexpIC(String pat, String s) {
    return compileRegexpIC(pat).matcher(unnull(s));
  }

  static public Pattern regexpIC(String pat) {
    return compileRegexpIC(pat);
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public Class loadFunction_cached(String function) {
    return loadFunctions_cached(function);
  }

  static public <A> A assertLessThan(A a, A b) {
    assertTrue(cmp(b, a) < 0);
    return b;
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public <A extends Component> A packInternalFrameVertically(A c) {
    return packInternalFrameVertically(-1, c);
  }

  static public <A extends Component> A packInternalFrameVertically(int width, A c) {
    final JInternalFrame win = getInternalFrame(c);
    if (win == null)
      return c;
    final int w = width < 0 ? win.getWidth() : width;
    {
      swing(new Runnable() {

        public void run() {
          try {
            win.pack();
            win.setSize(w, win.getHeight());
            fixInternalFrame(win);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "win.pack();\r\n    win.setSize(w, win.getHeight());\r\n    fixInternalFrame(win);";
        }
      });
    }
    return c;
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public <A> void syncRemoveAllExceptLast(List<A> l) {
    if (l == null)
      return;
    synchronized (collectionMutex(l)) {
      removeSubList(l, 0, l(l) - 1);
    }
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public ItemListener itemListener(final Object r) {
    return new ItemListener() {

      public void itemStateChanged(ItemEvent e) {
        pcallF(r);
      }
    };
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  static public void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public String escapeNewLines(String s) {
    return s == null ? null : fixNewLines(s).replace("\n", " | ");
  }

  static public int methodApplicabilityScore(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return Integer.MAX_VALUE;
    int score = 0;
    for (int i = 0; i < types.length; i++) {
      Object a = args[i];
      Class c = types[i];
      if (a == null)
        ++score;
      else if (c == a.getClass()) {
      } else if (isInstanceX(c, a))
        ++score;
      else
        return Integer.MAX_VALUE;
    }
    return score;
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    return map(map, (Object) f);
  }

  static public <A, B> List<A> map(IF1<A, B> f, A data1, A... moreData) {
    List x = emptyList(l(moreData) + 1);
    x.add(f.get(data1));
    if (moreData != null)
      for (A o : moreData) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public boolean isStringCollection(Object o) {
    if (!(o instanceof Collection))
      return false;
    Collection l = (Collection) o;
    for (Object x : l) if (!(x instanceof String))
      return false;
    return true;
  }

  static public boolean matchEnd(String pat, String s) {
    return matchEnd(pat, s, null);
  }

  static public boolean matchEnd(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    List<String> tokpat = parse3(pat), toks = parse3(s);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, takeLast(l(tokpat), toks));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = join(dropLast(l(tokpat), toks));
    }
    return true;
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public String htmlencode_forParams_v2(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String addParamsToURL(String url, Map params) {
    return appendQueryToURL(url, params);
  }

  static public String addParamsToURL(String url, Object... data) {
    return appendQueryToURL(url, data);
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  static public <A> void setVar(IVar<A> v, A value) {
    if (v != null)
      v.set(value);
  }

  static public <A> IVF1<A> setVar(IVar<A> v) {
    return a -> {
      if (v != null)
        v.set(a);
    };
  }

  static public <B> TreeMap<String, B> asCIMap(Map<String, B> map) {
    return asCaseInsensitiveMap(map);
  }

  static public String hscriptsrc(String src) {
    return hjavascript_src(src);
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public String unicode_downPointingTriangle() {
    return charToString(0x25BC);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final Object f, Iterable<Pair<A, B>> l) {
    return map(l, new F1<Pair<A, B>, Pair<A, C>>() {

      public Pair<A, C> get(Pair<A, B> p) {
        try {
          return p == null ? null : pair(p.a, (C) callF(f, p.b));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "p == null ? null : pair(p.a, (C) callF(f, p.b))";
      }
    });
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final F1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final IF1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(Iterable<Pair<A, B>> l, IF1<B, C> f) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> Pair<A, C> mapPairB(IF1<B, C> f, Pair<A, B> p) {
    return pairMapB(f, p);
  }

  static public <A, B, C> Pair<A, C> mapPairB(Pair<A, B> p, IF1<B, C> f) {
    return pairMapB(f, p);
  }

  static public String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5_impl(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  static public byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(File file) {
    return md5OfFile(file);
  }

  static public JCheckBox jLiveValueCheckBox(String text, final SimpleLiveValue<Boolean> lv) {
    final JCheckBox cb = jCheckBox(text);
    bindCheckBoxToLiveValue(cb, lv);
    return cb;
  }

  static public List<String> htmlcoarsetok(String s) {
    List<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      while (j < l) {
        if (s.charAt(j) != '<')
          ++j;
        else if (s.substring(j, Math.min(j + 4, l)).equals("<!--")) {
          j = j + 3;
          do ++j; while (j < l && !s.substring(j, Math.min(j + 3, l)).equals("-->"));
          j = Math.min(j + 3, l);
        } else {
          char d = charAt(s, j + 1);
          if (d == '/' || isLetter(d))
            break;
          else
            ++j;
        }
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '<') {
        ++j;
        while (j < l && s.charAt(j) != '>') ++j;
        if (j < l)
          ++j;
      }
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() & 1) == 0)
      tok.add("");
    return tok;
  }

  static public void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A extends JComponent> A onClick(final A c, final Object runnable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent e) {
                callF(runnable, e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(MouseEv...";
        }
      });
    }
    return c;
  }

  static public void onClick(JButton btn, final Object runnable) {
    onEnter(btn, runnable);
  }

  static public <A> List<A> listWithoutIndicesInBitSet(List<A> l, BitSet bs) {
    List<A> out = new ArrayList();
    for (int i = 0; i < l(l); i++) if (!bs.get(i))
      out.add(l.get(i));
    return out;
  }

  static public <A> int addAndReturnIndex(List<A> l, A a) {
    if (l == null)
      return -1;
    int idx = l.size();
    l.add(a);
    return idx;
  }

  static public String javaValueToHTML(Object value) {
    return javaValueToHTML(value, identityHashSet());
  }

  static public String javaValueToHTML(Object value, Set seen) {
    if (!seen.add(value))
      return "see above";
    if (value instanceof String)
      return htmlEncode_quote((String) value);
    else if (value instanceof List)
      return ol(map(((List) value), v -> javaValueToHTML(v, seen)));
    else
      return htmlEncode(shorten(str(value)));
  }

  static public boolean isAllUpperCase(String s) {
    return hasLettersAllUpperCase(s);
  }

  static public String regexReplace(String s, String pat, Object f) {
    Matcher m = Pattern.compile(pat).matcher(s);
    return regexReplace(m, f);
  }

  static public String regexReplace(String s, String pat, String replacement) {
    return regexpReplace_direct(s, pat, replacement);
  }

  static public String regexReplace(Matcher m, Object f) {
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, m.quoteReplacement(str(callF(f, m))));
    m.appendTail(buf);
    return str(buf);
  }

  static public String regexReplace(String s, String pat, IF1<Matcher, String> f) {
    return regexReplace(s, pat, (Object) f);
  }

  static public List<Integer> flexMatchIC_getVarIndices(List<String> tokPat, List<String> tokInput) {
    List<Integer> varIndices = new ArrayList();
    for (int i = 1; i < l(tokPat); i += 2) {
      String t = tokPat.get(i);
      if (eq(t, "*"))
        varIndices.add(i);
      else if (isIdentifier(t) && !cicAtOddPosition(tokInput, t)) {
        return null;
      }
    }
    return varIndices;
  }

  static public String renderFileInfo(File f) {
    return f == null ? "-" : f2s(f) + " " + (f.isFile() ? "(file, " + n2(fileSize(f)) + " bytes)" : f.isDirectory() ? "(dir)" : "(not found)");
  }

  static public boolean isAllDigits(String s) {
    int n = l(s);
    for (int i = 0; i < n; i++) if (!isDigit(s.charAt(i)))
      return false;
    return true;
  }

  static public <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
    mapPut(map, key, value);
    return value;
  }

  static public <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
    List<A> l = tl.get();
    if (l == null)
      return null;
    A a = popLast(l);
    if (empty(l))
      tl.set(null);
    return a;
  }

  static public boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  static public Cache<List<CountryDialCode>> countryDialCodes_cache = new Cache<>(() -> countryDialCodes_load());

  static public List<CountryDialCode> countryDialCodes() {
    return countryDialCodes_cache.get();
  }

  static public List<CountryDialCode> countryDialCodes_load() {
    return sortedByField("dialCode", filter(c -> nempty(c.dialCode), map((List<Map<String, String>>) loadJSONFile(loadLibrary("#1400429")), m -> new CountryDialCode(m.get("name"), m.get("code"), m.get("dial_code")))));
  }

  static public <A extends JTextComponent> A jenableUndoRedo(final A textcomp) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final UndoManager undo = new UndoManager();
            vm_generalWeakSet("Undo Managers").add(undo);
            textcomp.getDocument().addUndoableEditListener(new UndoableEditListener() {

              public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
              }
            });
            textcomp.getActionMap().put("Undo", abstractAction("Undo", new Runnable() {

              public void run() {
                try {
                  if (undo.canUndo())
                    undo.undo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canUndo()) undo.undo()";
              }
            }));
            textcomp.getActionMap().put("Redo", abstractAction("Redo", new Runnable() {

              public void run() {
                try {
                  if (undo.canRedo())
                    undo.redo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canRedo()) undo.redo()";
              }
            }));
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final new UndoManager undo;\r\n    vm_generalWeakSet(\"Undo Managers\").add(undo)...";
        }
      });
    }
    return textcomp;
  }

  static public void setChecked(JCheckBox checkBox, boolean b) {
    if (checkBox != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (isChecked(checkBox) != b)
              checkBox.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (isChecked(checkBox) != b)\r\n      checkBox.setSelected(b);";
        }
      });
    }
  }

  static public void setChecked(JCheckBoxMenuItem mi, boolean b) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setSelected(b);";
        }
      });
    }
  }

  static public String joinPairWithColon(Pair p) {
    return p == null ? "" : str(p.a) + ": " + str(p.b);
  }

  static public boolean isTrue_getOpt(String field, Object o) {
    return isTrue(getOpt(field, o));
  }

  static public <A> List<A> syncList() {
    return synchroList();
  }

  static public <A> List<A> syncList(List<A> l) {
    return synchroList(l);
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public <A, B> String formatColonProperties(Map<A, B> map) {
    return mapToLines(__84 -> joinPairWithColon(__84), mapToPairs(map));
  }

  static public <A, B> String formatColonProperties(List<Pair<A, B>> l) {
    return mapToLines(__85 -> joinPairWithColon(__85), l);
  }

  static public boolean isConceptList(Object o) {
    if (!(o instanceof List))
      return false;
    List l = (List) o;
    for (Object x : l) if (!(x instanceof Concept))
      return false;
    return true;
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public String htmlEncode_quote(Object o) {
    return htmlEncode2(quote(o));
  }

  static public JWindow showWindow(Component c) {
    JWindow w = new JWindow();
    w.add(wrap(c));
    return w;
  }

  static public <A> A optPar_ignoreOddLength(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    for (int i = 0; i + 1 < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optPar_ignoreOddLength(Object[] opt, String name) {
    return optPar_ignoreOddLength(opt, name, null);
  }

  static public Object optPar_ignoreOddLength(String name, Object[] params) {
    return optPar_ignoreOddLength(params, name);
  }

  static public Object subBot_serveByteArray(byte[] data, String mimeType) {
    return call(mainBot(), "serveByteArray", data, mimeType);
  }

  static public void disposeInternalFrame(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            vmBus_send("disposingInternalFrame", f);
            f.dispose();
            setOpt(f, "lastFocusOwner", null);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "vmBus_send disposingInternalFrame(f);\r\n    f.dispose();\r\n    setOpt(f, lastFo...";
        }
      });
    }
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldIC(Class<A> c, String field) {
    return indexConceptFieldCI(c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldIC(Concepts concepts, Class<A> c, String field) {
    return indexConceptFieldCI(concepts, c, field);
  }

  static public void dm_watchField(String field, Runnable onChange) {
    new Dyn_FieldWatcher(dm_current_mandatory(), field, onChange);
  }

  static public String jextract(String pat, String s) {
    return jextract(pat, javaTok(s));
  }

  static public String jextract(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    jfind_preprocess(tokpat);
    int i = jfind(tok, tokpat);
    if (i < 0)
      return null;
    int j = i + l(tokpat) - 2;
    return joinSubList(tok, i, j);
  }

  static public JavaXClassLoader hotwire_makeClassLoader(List<File> files) {
    Collection<String> toShare = hotwire_classesToShare();
    return nempty(toShare) ? new JavaXClassLoaderWithParent2(null, files, myClassLoader(), cloneList(toShare)) : new JavaXClassLoader(null, files);
  }

  static public void fillJPopupMenu(JPopupMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof IVF1)
        callF(o, m);
      else if (o instanceof List)
        fillJPopupMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o))
        m.addSeparator();
      else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem("", y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv.get();\r\n        if (isCurlyBracketed(s)) {\r\n          setEnable...";
          }
        });
        m.add(mi);
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public int levenWithSwapsIC(String s, String t) {
    if (s.equals(t))
      return 0;
    int ls = s.length(), lt = t.length();
    if (ls == 0)
      return lt;
    if (lt == 0)
      return ls;
    int[] vx = new int[lt + 1];
    int[] v0 = new int[lt + 1];
    int[] v1 = new int[lt + 1];
    for (int i = 0; i < v0.length; i++) v0[i] = i;
    for (int i = 0; i < ls; i++) {
      v1[0] = i + 1;
      for (int j = 0; j < lt; j++) {
        int cost = equalsIgnoreCase(s.charAt(i), t.charAt(j)) ? 0 : 1;
        int d = min3(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
        if (i > 0 && j > 0 && equalsIgnoreCase(s.charAt(i), t.charAt(j - 1)) && equalsIgnoreCase(s.charAt(i - 1), t.charAt(j)))
          d = min(d, vx[j - 1] + 1);
        v1[j + 1] = d;
      }
      int[] v = vx;
      vx = v0;
      v0 = v1;
      v1 = v;
    }
    return v0[lt];
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public boolean isUpperCaseLetter(char c) {
    return Character.isUpperCase(c);
  }

  static public Object deref(Object o) {
    if (o instanceof IRef)
      return ((IRef) o).get();
    return o;
  }

  static public Class primitiveToBoxedType(Class type) {
    if (type == boolean.class)
      return Boolean.class;
    if (type == int.class)
      return Integer.class;
    if (type == long.class)
      return Long.class;
    if (type == float.class)
      return Float.class;
    if (type == short.class)
      return Short.class;
    if (type == char.class)
      return Character.class;
    if (type == byte.class)
      return Byte.class;
    if (type == double.class)
      return Double.class;
    return null;
  }

  static public Map<String, String> matchesToMapUsingVarList_ciMap(Matches m, List<String> vars) {
    if (m == null)
      return null;
    Map<String, String> map = ciMap();
    int n = min(l(m.m), l(vars));
    for (int i = 0; i < n; i++) if (!strictPutIC(map, vars.get(i), m.get(i)))
      return null;
    return map;
  }

  static public <A> List<A> cloneAndClear(Collection<A> l) {
    return cloneAndClearList(l);
  }

  static volatile public Android3 dbBot_instance;

  static public Android3 dbBot() {
    return dbBot(true);
  }

  static public Android3 dbBot(boolean ensureNotRunning) {
    return dbBot(dbBotStandardName(), ensureNotRunning);
  }

  static public Android3 dbBot(String name) {
    return dbBot(name, true);
  }

  static public Android3 dbBot(String name, boolean ensureNotRunning) {
    if (ensureNotRunning)
      ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  static public <A, B> List<A> firstOfPairs(Collection<Pair<A, B>> l) {
    List<A> out = new ArrayList();
    for (Pair<A, B> p : unnull(l)) out.add(firstOfPair(p));
    return out;
  }

  static public boolean byteArrayStartsWith(byte[] a, byte[] b) {
    if (a == null || b == null)
      return false;
    if (a.length < b.length)
      return false;
    for (int i = 0; i < b.length; i++) if (a[i] != b[i])
      return false;
    return true;
  }

  static public <A> A printHidingCredentials(A o) {
    print(hideCredentials(str(o)));
    return o;
  }

  static public <A> A println(A a) {
    return print(a);
  }

  static public JFrame showForm_makeFrame(String title, JPanel panel) {
    return handleEscapeKey(minFrameWidth(showPackedFrame(title, withMargin(panel)), 400));
  }

  static public MetaTransformer metaTransformer_transformableAndList() {
    return new MetaTransformer(new MetaTransformer.StructureHandler() {

      public Object transform(Object o, IF1 recurse) {
        if (o instanceof Transformable)
          return ((Transformable) o).transformUsing(recurse);
        if (o instanceof List)
          return map_ping(recurse, ((List) o));
        return null;
      }

      public void visit(Object o, IVF1 recurse) {
        if (o instanceof Visitable)
          ((Visitable) o).visitUsing(recurse);
        else if (o instanceof List)
          for (Object x : ((List) o)) {
            ping();
            recurse.get(x);
          }
      }
    });
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll((Map) b);
    return a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
    if (a != null)
      litmap_impl(a, b);
    return a;
  }

  static public Component childWithClassNameEndingWith(Component c, String suffix) {
    if (endsWith(className(c), suffix))
      return c;
    Component x;
    for (Component comp : getComponents(c)) if ((x = childWithClassNameEndingWith(comp, suffix)) != null)
      return x;
    return null;
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public String sourceCodeToHTML_noEncode(String html) {
    return "<pre style=\"white-space: pre-wrap; white-space: -moz-pre-wrap; white-space: -pre-wrap; white-space: -o-pre-wrap; word-wrap: break-word;\">" + html + "</pre>";
  }

  static public String structureForUser(Object o) {
    return beautifyStructure(struct_noStringSharing(o));
  }

  static public <A, B> Map<A, B> mapMinus(Map<A, B> map, Object... keys) {
    if (empty(keys))
      return map;
    Map<A, B> m2 = cloneMap(map);
    for (Object key : keys) m2.remove(key);
    return m2;
  }

  static public JButton renameButton(JComponent c, String name) {
    JButton b = first(childrenOfType(c, JButton.class));
    if (b != null)
      b.setText(name);
    return b;
  }

  static public JButton renameButton(JComponent c, String oldName, String newName) {
    JButton b = findButton(c, oldName);
    if (b != null)
      b.setText(newName);
    return b;
  }

  static public String dropSuffix(String suffix, String s) {
    return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  static public String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  static public String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  static public String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public boolean startsWithLetterOrDigit(String s) {
    return nempty(s) && Character.isLetterOrDigit(s.charAt(0));
  }

  static public String getTag(String s) {
    if (!startsWith(s, "<"))
      return null;
    int i = 1;
    if (charAt(s, i) == '/')
      ++i;
    while (" \t>/\0".indexOf(charAt(s, i)) < 0) ++i;
    return substring(s, 1, i);
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> hotwire_libraryIDsFromJar_deleteJarOnFail(File jar) {
    try {
      return hotwire_libraryIDsFromJar(jar);
    } catch (Throwable _e) {
      jar.delete();
      throw rethrow(_e);
    }
  }

  static public Object subBot_serveWithContentType(String text, String contentType) {
    return callMainBot("serveByteArray", toUtf8(unnull(text)), contentType);
  }

  static public <A extends Concept> Collection<Pair<A, FieldIndicator>> cForwardAndBackRefsWithFieldIndicator(Concept c, Class<A> type) {
    return concatLists_conservative(mapPairsB(cForwardRefsWithFieldNames(c, type), f -> new FieldIndicator(f, true)), mapPairsB(findBackRefsWithFieldNames(c, type), f -> new FieldIndicator(f, false)));
  }

  static public <A extends Concept> Collection<Pair<A, FieldIndicator>> cForwardAndBackRefsWithFieldIndicator(Class<A> type, Concept c) {
    return cForwardAndBackRefsWithFieldIndicator(c, type);
  }

  static public int scoredSearch_score_single(String s, String query) {
    int i = indexOfIC_underscore(s, query);
    if (i < 0)
      return 0;
    if (i > 0)
      return 1;
    return l(s) == l(query) ? 3 : 2;
  }

  static public File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }

  static public void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  static public String renderDBSaveTime() {
    return renderDBSaveTime(db_mainConcepts());
  }

  static public String renderDBSaveTime(Concepts cc) {
    if (cc == null)
      return null;
    return cc.lastSaveTook < 0 ? "unknown" : n2(cc.lastSaveTook) + " ms";
  }

  static public <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }

  static public List<File> filesEndingWith(File dir, String suffix) {
    return listFilesWithSuffix(dir, suffix);
  }

  static public List<File> filesEndingWith(List<File> l, String suffix) {
    List<File> out = new ArrayList();
    for (File f : unnull(l)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      out.add(f);
    return out;
  }

  static public List<File> filesEndingWith(String suffix, File dir) {
    return filesEndingWith(dir, suffix);
  }

  static public Object serve404() {
    return subBot_serve404();
  }

  static public Object serve404(String msg) {
    return subBot_serve404(msg);
  }

  static public <A> List<A> objectsWhereCI(Collection<A> c, Object... data) {
    return objectsWhereIC(c, data);
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public Object[] asArray(List l) {
    return toObjectArray(l);
  }

  static public <A> A[] asArray(Class<A> type, List l) {
    return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
  }

  static public String getStringOpt(Map map, Object key) {
    return map == null ? null : optCast(String.class, map.get(key));
  }

  static public String getStringOpt(List l, int idx) {
    return optCast(String.class, get(l, idx));
  }

  static public String getStringOpt(Object o, Object key) {
    if (o instanceof Map)
      return getStringOpt((Map) o, key);
    if (key instanceof String)
      return optCast(String.class, getOpt(o, (String) key));
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getStringOpt(String key, Object o) {
    return getStringOpt(o, (Object) key);
  }

  static public List<String> splitAtDoubleArrow_tok;

  static public List<String> splitAtDoubleArrow_tok() {
    if (splitAtDoubleArrow_tok == null)
      splitAtDoubleArrow_tok = ll("=", "", ">");
    return splitAtDoubleArrow_tok;
  }

  static public boolean isCurlyBracketed(String s) {
    return isCurlyBraced(s);
  }

  static public String pIfNempty(String contents, Object... params) {
    return nempty(contents) ? p(contents, params) : "";
  }

  static public <A> void removeAll(Collection<A> a, Collection<A> b) {
    if (a != null && b != null)
      a.removeAll(b);
  }

  static public <A, B> void removeAll(Map<A, B> a, Collection<A> b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public <A, B extends A> boolean removeAll(Collection<A> c, B... b) {
    return c != null && b != null && c.removeAll(Arrays.asList(b));
  }

  static public <A, B> void removeAll(Map<A, B> a, A... b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public int snippetType_dynModule() {
    return 57;
  }

  static public Dimension getMinimumSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getMinimumSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getMinimumSize();";
      }
    });
  }

  static public Map<String, String> flexMatchAngleBracketVarsIC_honorPunctuation_first(String pat, String input) {
    return grabValueAndCancel(new VF1<VF1<Map<String, String>>>() {

      public void get(VF1<Map<String, String>> onMatch) {
        try {
          flexMatchAngleBracketVarsIC_honorPunctuation_iterate(pat, input, onMatch);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "flexMatchAngleBracketVarsIC_honorPunctuation_iterate(pat, input, onMatch);";
      }
    });
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public double elapsedSeconds_sysNow(long time) {
    return elapsedSeconds(time);
  }

  static public JMenuItem disableMenuItem(final JMenuItem mi) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setEnabled(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setEnabled(false);";
        }
      });
    }
    return mi;
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public Object costCenter() {
    return mc();
  }

  static public String getText(final AbstractButton c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JTextComponent c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JLabel l) {
    return l == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return l.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret l.getText();";
      }
    });
  }

  static public String getText(final JComboBox cb) {
    if (cb == null)
      return null;
    if (isEditableComboBox(cb))
      return unnull((String) cb.getEditor().getItem());
    else
      return str(cb.getSelectedItem());
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    if (src != null)
      dest.addAll(src);
  }

  static public Map<String, String> parseDoubleLeftArrowMapCI_tlft(String s) {
    return parseDoubleLeftArrowMapCI(tlft(s));
  }

  static public <A, B> List<B> pairsB(Collection<Pair<A, B>> l) {
    return secondOfPairs(l);
  }

  static public <A, B> List<A> pairsA(Collection<Pair<A, B>> l) {
    return firstOfPairs(l);
  }

  static public void ensureConceptClassesAreIndexed(Collection<Class> classes) {
    for (Class c : unnullForIteration(classes)) ensureConceptClassIsIndexed(c);
  }

  static public List<String> toLinesFullTrim(String s) {
    List<String> l = new ArrayList();
    for (String line : toLines(s)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public List<String> toLinesFullTrim(File f) {
    List<String> l = new ArrayList();
    for (String line : linesFromFile(f)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public <A> List<A> takeLast(List<A> l, int n) {
    return newSubList(l, l(l) - n);
  }

  static public <A> List<A> takeLast(int n, List<A> l) {
    return takeLast(l, n);
  }

  static public String takeLast(int n, String s) {
    return substring(s, l(s) - n);
  }

  static public String takeLast(String s, int n) {
    return substring(s, l(s) - n);
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public boolean checkFieldsIC(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (!eqicOrEq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public Map<String, Object> cgetAll_cloneLists(Concept c, Collection<String> fields) {
    return mapToValues(fields, f -> cloneIfList(cget(c, f)));
  }

  static public boolean swic_notSame(String a, String b) {
    return swic_notSame(a, b, null);
  }

  static public boolean swic_notSame(String a, String b, Matches m) {
    return l(a) > l(b) && swic(a, b, m);
  }

  static public boolean javaCompileToJar_useRAMDisk = false;

  static public ThreadLocal<List<File>> javaCompileToJar_localLibraries = new ThreadLocal();

  static public ThreadLocal<IVF1<File>> javaCompileToJar_addMoreFiles = new ThreadLocal();

  static public File javaCompileToJar_optionalRename(String src, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, "", destJar, progIDForRename);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename) {
    return javaCompileToJar_optionalRename(src, dehlibs, destJar, progIDForRename, null);
  }

  static synchronized public File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename, String progID) {
    String javaTarget = null;
    String dummyClass = "main";
    if (progIDForRename != null) {
      dummyClass = dummyMainClassName(progIDForRename);
      src += "\nclass " + dummyClass + "{}";
    }
    String md5 = md5(src);
    File jar = destJar;
    Class j = getJavaX();
    if (javaTarget != null)
      setOpt(j, "javaTarget", javaTarget);
    File srcDir = tempDir();
    String fileName = dummyClass + ".java";
    List<String> tok = javaTok(src);
    String packageName = tok_packageName(tok);
    if (packageName != null)
      fileName = packageName.replace(".", "/") + "/" + tok_firstClassName(tok) + ".java";
    File mainJava = new File(srcDir, fileName);
    saveTextFile(mainJava, src);
    File classesDir = javaCompileToJar_useRAMDisk ? tempDirPossiblyInRAMDisk() : tempDir();
    try {
      List<File> libraries = cloneList(getAndClearTL(javaCompileToJar_localLibraries));
      Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
      while (m.find()) {
        String libID = m.group();
        assertTrue(isSnippetID(libID));
        print("Adding library " + libID);
        libraries.add(loadLibraryOrSrcLib(libID));
      }
      libraries.add(pathToJavaxJar());
      String compilerOutput;
      try {
        compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
      } catch (Throwable e) {
        compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
        compilerOutput = indentx("> ", cleanJavaCompilerOutput(compilerOutput));
        if (!swic(e.getMessage(), "Java compiler returned errors."))
          compilerOutput = appendWithNewLine(compilerOutput, str(e));
        throw fail(compilerOutput, e);
      }
      compilerOutput = cleanJavaCompilerOutput("Annotation processing got disabled, since it requires a 1.6 compliant JVM");
      if (nempty(compilerOutput)) {
        print("Compiler said: " + compilerOutput);
      }
      if (!anyFileWithExtensionInDir(classesDir, ".class")) {
        printWithIndent("SRC> ", src);
        throw fail("No classes generated (was compiling " + nChars(src) + ")");
      }
      saveTextFile(new File(classesDir, "main.java"), src);
      if (nempty(dehlibs))
        saveTextFile(new File(classesDir, "libraries"), dehlibs);
      saveTextFile(new File(classesDir, "progID"), progID);
      callF(javaCompileToJar_addMoreFiles.get(), classesDir);
      dir2zip_recurse_verbose = false;
      int n = dir2zip_recurse(classesDir, jar);
      return jar;
    } finally {
      if (isInRAMDisk(classesDir))
        deleteDirectory(classesDir);
    }
  }

  static public String x30JarServerURL() {
    return "http://botcompany.de:8081/x30.jar";
  }

  static public File getCachedTranspilationFile(String id) {
    return newFile(getCodeProgramDir(id), "Transpilation");
  }

  static public Thread newThread(Object runnable) {
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public <A extends Concept> List<Pair<A, String>> cForwardRefsWithFieldNames(Concept c, Class<A> type) {
    return mapNonNulls(scanConceptForRefsWithFieldNames(c), p -> isInstanceOf(derefRef(p.a), type) ? pair((A) derefRef(p.a), p.b) : null);
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public String hstyle(Object contents) {
    return hcss(contents);
  }

  static public <B> TreeMap<String, B> asCaseInsensitiveMap(Map<String, B> map) {
    if (isCIMap(map))
      return (TreeMap) map;
    TreeMap<String, B> m = ciMap();
    putAll(m, map);
    return m;
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public Object unstructure(String text, IF1<String, Class> classFinder) {
    return unstructure(text, false, classFinder);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public String mcDollar = actualMCDollar();

      public IntObjectHashMap<Object> refs = new IntObjectHashMap();

      public IntObjectHashMap<Object> tokrefs = new IntObjectHashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public Map<String, String> baseClassMap = new HashMap();

      public HashMap<Class, Constructor> innerClassConstructors = new HashMap();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public X() {
        try {
          Class mc = (Class) (callF(_classFinder, "<main>"));
          if (mc != null)
            mcDollar = mc.getName() + "$";
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }

      public Class findAClass(String fullClassName) {
        try {
          return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
        } catch (Throwable __e) {
          return null;
        }
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        } else
          refID = -1;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (refID >= 0)
              refs.put(refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, unstructure_Receiver out) {
        String t = t();
        String cname = t;
        Class c = classesMap.get(cname);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              warn("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              warn("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            LinkedList l = new LinkedList();
            if (refID >= 0)
              refs.put(refID, l);
            {
              parseList(l, out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(synchroNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(synchroSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(synchroMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(synchroList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            ArrayList l = new ArrayList();
            if (refID >= 0)
              refs.put(refID, l);
            this.parseList(l, out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray") || t.equals("dblarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = mcDollar + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume();
          out.set(parseJava());
          return;
        }
        if (eq(t, "bc")) {
          consume();
          String c1 = tpp();
          String c2 = tpp();
          baseClassMap.put(c1, c2);
          {
            parse_inner(refID, i, out);
            return;
          }
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = mcDollar + t;
        }
        if (c == null && !allDynamic) {
          c = findAClass(fullClassName);
          classesMap.put(className, c);
        }
        if (c == null && !allDynamic) {
          Set<String> seen = new HashSet();
          String parent = className;
          while (true) {
            String baseName = baseClassMap.get(parent);
            if (baseName == null)
              break;
            if (!seen.add(baseName))
              throw fail("Cyclic superclass info: " + baseName);
            c = findAClass(mcDollar + baseName);
            if (c == null)
              print("Base class " + baseName + " of " + parent + " doesn't exist either");
            else if (isAbstract(c))
              print("Can't instantiate abstract base class: " + c);
            else {
              printVars_str("Reverting to base class", "className", className, "baseName", baseName, "c", c);
              classesMap.put(className, c);
              break;
            }
            parent = baseName;
          }
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && startsWith(t(), "this$");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          if (hasOuter)
            try {
              Constructor ctor = innerClassConstructors.get(c);
              if (ctor == null)
                innerClassConstructors.put(c, ctor = nuStubInnerObject_findConstructor(c, classFinder));
              o = ctor.newInstance(new Object[] { null });
            } catch (Exception e) {
              print("Error deserializing " + c + ": " + e);
              o = nuEmptyObject(c);
            }
          else
            o = nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findAClass(mcDollar + "Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID >= 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        HashMap<String, Object> fields = new HashMap();
        Object _o = o;
        DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        Object outer = fields.get("this$0");
        if (outer != null)
          fields.put("this$1", outer);
        else {
          outer = fields.get("this$1");
          if (outer != null)
            fields.put("this$0", outer);
        }
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(unstructure_Receiver out) {
        String _type = tpp();
        int dims;
        if (eq(t(), "S")) {
          _type = "S";
          consume();
        }
        if (eq(t(), "/")) {
          consume();
          dims = parseInt(tpp());
        } else
          dims = 1;
        consume("{");
        List list = new ArrayList();
        String type = _type;
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                if (dims > 1) {
                  Class atype;
                  if (type.equals("intarray"))
                    atype = int.class;
                  else if (type.equals("S"))
                    atype = String.class;
                  else
                    throw todo("multi-dimensional arrays of other types");
                  out.set(list.toArray((Object[]) newMultiDimensionalOuterArray(atype, dims, l(list))));
                } else
                  out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : type.equals("S") ? toStringArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          if (dims > 1) {\r\n    ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix(mcDollar, name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public String uncurly(String s) {
    return tok_unCurlyBracket(s);
  }

  static public String replaceSquareBracketVars(String s, Object... params) {
    if (empty(params))
      return s;
    Map<String, Object> vars = mapKeys(__86 -> deSquareBracket(__86), (Map<String, Object>) litcimap(params));
    return regexpReplaceIC(s, "\\[(.+?)\\]", matcher -> {
      String var = matcher.group(1);
      Object val = vars.get(var);
      return val == null ? matcher.group() : str(val);
    });
  }

  static public String lines_possiblyRTrim(String originalText, List<String> lines) {
    return endsWithNewLine(originalText) ? lines(lines) : lines_rtrim(lines);
  }

  static public String lines_possiblyRTrim(List<String> lines, String originalText) {
    return lines_possiblyRTrim(originalText, lines);
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public <A, B> List<A> keysList(Map<A, B> map) {
    return cloneListSynchronizingOn(keys(map), map);
  }

  static public <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

  static public Object[] dropParam(Object key, Object[] params) {
    return paramsWithout(params, key);
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public boolean isValidInternationalPhoneNumber(String s) {
    InternationalPhoneValidator v = new InternationalPhoneValidator(s);
    v.run();
    if (v.error != null)
      print(v.error);
    return v.valid;
  }

  static public List<IntRange> parseBusinessHours_pcall(String s) {
    try {
      return parseBusinessHours(s);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public int showForm_defaultGap = 4;

  static public int showForm_gapBetweenColumns = 10;

  static public JPanel showFormTitled(final String title, final Object... _parts) {
    JDesktopPane desktop = mainDesktopPane();
    if (desktop != null)
      return showInternalFrameFormTitled(desktop, title, _parts);
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          final Var<JFrame> frame = new Var();
          JPanel panel = showForm_makePanel(false, _parts);
          frame.set(showForm_makeFrame(title, panel));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<JFrame> frame;\r\n    JPanel panel = showForm_makePanel(false, _p...";
      }
    });
  }

  static public JPanel showForm_makePanel(Boolean internalFrame, Object... _parts) {
    List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
    return vstackWithSpacing(out, showForm_defaultGap);
  }

  static public String htmlTable2_noHtmlEncode(Object data, Object... __) {
    return htmlTable2(data, paramsPlus(__, "htmlEncode", false));
  }

  static public long parseSecondLong(String s) {
    List<String> tok = javaTokC(s);
    int i = 0;
    while (i < l(tok) && !isInteger(tok.get(i))) ++i;
    ++i;
    while (i < l(tok) && !isInteger(tok.get(i))) ++i;
    if (i < l(tok))
      return parseLong(tok.get(i));
    return 0;
  }

  static public String fileNameEncode_safeChars = " ";

  static public String fileNameEncode(String s) {
    s = dropLeadingDots(s);
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (contains(fileNameEncode_safeChars, c))
        buf.append(c);
      else
        buf.append(urlencode(str(c)));
    }
    return str(buf);
  }

  static public <A extends Concept> List<A> sortedByConceptID(Collection<A> c) {
    return sortedByCalculatedField(__87 -> conceptID(__87), c);
  }

  static public String nErrors(long n) {
    return n2(n, "error");
  }

  static public String nErrors(Collection l) {
    return nErrors(l(l));
  }

  static public String nErrors(Map map) {
    return nErrors(l(map));
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public <A> List<A> reversedList(Iterable<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public String getSnippetTitleOpt(String s) {
    return isSnippetID(s) ? getSnippetTitle(s) : s;
  }

  static public String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public List collectField(Iterable c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  static public List collectField(String field, Iterable c) {
    return collectField(c, field);
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public <A> A ifThenElse(boolean b, A trueValue, A falseValue) {
    return b ? trueValue : falseValue;
  }

  static public String stringPar(Object[] params, String name) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Object[] params) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Map params) {
    return (String) optPar(name, params);
  }

  static public String stringPar(String name, Object[] params, String defaultValue) {
    return optPar(name, params, defaultValue);
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public int getScreenHeight() {
    return getScreenSize().height;
  }

  static public boolean directoryIsEmpty(File f) {
    return !fileExists(f) || isDirectory(f) && empty(listFiles(f));
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public List<String> simplifySafetyTags(Collection<String> tags) {
    List<String> l = uniquifyList(tags);
    if (l.contains("safe") && containsAnythingNeq(l, "safe"))
      return listMinus(l, "safe");
    return l;
  }

  static public String simplifySafetyTags(String tags) {
    List<String> l = tokSplitAtComma(tags);
    Collection<String> l2 = simplifySafetyTags(l);
    return l(l2) != l(l) ? joinWithComma(l2) : tags;
  }

  static public <A, B extends Number> A keyWithBiggestValue(Map<A, B> map) {
    A best = null;
    Number bestScore = null;
    for (A key : keys(map)) {
      Number score = map.get(key);
      if (best == null || cmp(score, bestScore) > 0) {
        best = key;
        bestScore = score;
      }
    }
    return best;
  }

  static public String himgsnippet(String imageID, Object... params) {
    return hsnippetimg(imageID, params);
  }

  static public String jsBackLink() {
    return "javascript:history.go(-1)";
  }

  static public String jsQuote(String s) {
    return javascriptQuote(s);
  }

  static public Object jsonPrepareData(Object... data) {
    if (l(data) == 1)
      return data[0];
    return litorderedmap(data);
  }

  static public boolean isSpace(char c) {
    return " \t\r\n".indexOf(c) >= 0;
  }

  static public <A extends AutoCloseable, B> void closeAllKeysAndClear(Map<A, B> map) {
    closeAllAndClear(keys(map));
  }

  static public String htmlEncode2_nlToBr(String s) {
    return htmlEncode_nlToBr(s);
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public boolean isCodeSafe(String code) {
    return isSafeCodeFragment(code);
  }

  static public String getSelectedItem(JList l) {
    return (String) l.getSelectedValue();
  }

  static public String getSelectedItem(JComboBox cb) {
    return strOrNull(cb.getSelectedItem());
  }

  static public void saveTranspiledStandardFunctions(TreeSet<String> functionSet, String transpiledSrc) {
    try {
      saveTextFile(transpiledStandardFunctions_file(functionSet), transpiledSrc);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public <A> Comparator<A> descFieldComparator(final String field) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(getOpt(b, field), getOpt(a, field));
      }
    };
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    return linesFromFile(f, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f, IResourceHolder resourceHolder) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)), resourceHolder);
      return linesFromReader(utf8bufferedReader(f), resourceHolder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(path, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(String path, IResourceHolder resourceHolder) {
    return linesFromFile(newFile(path), resourceHolder);
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public String ymd_minus_hms() {
    return ymd() + "-" + hms();
  }

  static public byte[] base64decode(String s) {
    byte[] alphaToInt = base64decode_base64toint;
    int sLen = s.length();
    int numGroups = sLen / 4;
    if (4 * numGroups != sLen)
      throw new IllegalArgumentException("String length must be a multiple of four.");
    int missingBytesInLastGroup = 0;
    int numFullGroups = numGroups;
    if (sLen != 0) {
      if (s.charAt(sLen - 1) == '=') {
        missingBytesInLastGroup++;
        numFullGroups--;
      }
      if (s.charAt(sLen - 2) == '=')
        missingBytesInLastGroup++;
    }
    byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
    int inCursor = 0, outCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch3 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      result[outCursor++] = (byte) ((ch2 << 6) | ch3);
    }
    if (missingBytesInLastGroup != 0) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      if (missingBytesInLastGroup == 1) {
        int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
        result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      }
    }
    return result;
  }

  static public int base64decode_base64toint(char c, byte[] alphaToInt) {
    int result = alphaToInt[c];
    if (result < 0)
      throw new IllegalArgumentException("Illegal character " + c);
    return result;
  }

  static final public byte[] base64decode_base64toint = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 };

  static public <A> List<A> itemPlusList(A a, Collection<A> l) {
    return concatLists(ll(a), l);
  }

  static public <A extends Component> A revalidate(final A c) {
    if (c == null || !c.isShowing())
      return c;
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.revalidate();
            c.repaint();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// magic combo to actually relayout and repaint\r\n    c.revalidate();\r\n    c.r...";
        }
      });
    }
    return c;
  }

  static public void revalidate(JFrame f) {
    revalidate((Component) f);
  }

  static public void revalidate(JInternalFrame f) {
    revalidate((Component) f);
  }

  static public <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public Concept unlisted(String name, Object... args) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    try {
      return cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public List callF_all(Collection l, Object... args) {
    return map(l, f -> callF(f, args));
  }

  static public List<List<String>> findContainerTag(List<String> tok, String tag) {
    List<List<String>> l = new ArrayList();
    for (int i = 1; i < l(tok); i += 2) if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i + 2; j < tok.size(); j += 2) if (isOpeningTag(tok.get(j), tag))
        ++level;
      else if (isTag(tok.get(j), "/" + tag)) {
        --level;
        if (level == 0) {
          l.add(subList(tok, i - 1, j + 2));
          break;
        }
      }
      i = j;
    }
    return l;
  }

  static public List<List<String>> findContainerTag(String html, String tag) {
    return findContainerTag(htmlTok(html), tag);
  }

  static public GlobalID aGlobalIDObj() {
    return asGlobalID(randomID(16));
  }

  static public GlobalID aGlobalIDObj(Random random) {
    return asGlobalID(randomID(random, 16));
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a) {
    if (a == null)
      return null;
    return intArrayToList(a, 0, a.length);
  }

  static public <A> ArrayList<Integer> intArrayToList(int[] a, int from, int to) {
    if (a == null)
      return null;
    ArrayList<Integer> l = new ArrayList<>(to - from);
    for (int i = from; i < to; i++) l.add(a[i]);
    return l;
  }

  static public <A, B> B mapGet2(Map<A, B> map, A a) {
    return map == null ? null : map.get(a);
  }

  static public <A, B> B mapGet2(A a, Map<A, B> map) {
    return map == null ? null : map.get(a);
  }

  static public String hsnippetimg_scaleToWidth(int width, String imageID, int originalWidth, int originalHeight, Object... params) {
    return hsnippetimg(imageID, paramsPlus(params, "width", width, "height", calcHeight(originalWidth, originalHeight, width)));
  }

  static public String nlToBr(String s) {
    return s.replace("\n", "<br>\n");
  }

  static public <A> AutoCloseable tempAdd(final Collection<A> l, final A a) {
    if (l == null || l.contains(a))
      return null;
    l.add(a);
    return new AutoCloseable() {

      public String toString() {
        return "l.remove(a);";
      }

      public void close() throws Exception {
        l.remove(a);
      }
    };
  }

  static public <A extends Concept> int conceptCount(Concepts concepts, Class<A> c, Object... params) {
    return countConcepts(concepts, c, params);
  }

  static public <A extends Concept> int conceptCount(Class<A> c, Object... params) {
    return countConcepts(c, params);
  }

  static public int conceptCount() {
    return countConcepts();
  }

  static public int conceptCount(String className) {
    return countConcepts(className);
  }

  static public <A extends Concept> int conceptCount(Concepts concepts, String className) {
    return countConcepts(concepts, className);
  }

  static public int conceptCount(Concepts concepts) {
    return countConcepts(concepts);
  }

  static public String loadProgramTextFile(String name) {
    return loadTextFile(getProgramFile(name));
  }

  static public String loadProgramTextFile(String progID, String name) {
    return loadTextFile(getProgramFile(progID, name));
  }

  static public String loadProgramTextFile(String progID, String name, String defaultText) {
    return loadTextFile(getProgramFile(progID, name), defaultText);
  }

  static public boolean cicAtOddPosition(List<String> l, String s) {
    int n = l(l);
    for (int i = 1; i < n; i += 2) if (eqic(l.get(i), s))
      return true;
    return false;
  }

  static public int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public void dm_setModuleName(Object module, String name) {
    dm_callModule(module, "setModuleName", name);
  }

  static public void dm_setModuleName(String name) {
    dm_setModuleName(dm_current_mandatory_generic(), name);
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public String loadJQuery() {
    return "<script src=\"https://code.jquery.com/jquery-1.10.2.js\"></script>";
  }

  static public Set<Thread> evalWithTimeout_inTime = synchroSet();

  static public Set<Thread> evalWithTimeout_allThreads = newWeakHashSet();

  static public ThreadLocal<String> evalWithTimeout_threadName = new ThreadLocal();

  static public Either<Object, Thread> evalWithTimeout(int timeoutMS, final Object r) {
    final Flag done = new Flag();
    final Flag doneWaiting = new Flag();
    final Var var = new Var();
    final Var<Throwable> error = new Var();
    Thread t = newThread(getAndClearThreadLocal(evalWithTimeout_threadName), new Runnable() {

      public void run() {
        try {
          try {
            try {
              var.set(callF(r));
            } finally {
              evalWithTimeout_allThreads.remove(currentThread());
            }
          } catch (Throwable e) {
            error.set(e);
            if (doneWaiting.isUp())
              printStackTrace_inPossiblyCancelledThread(e);
          } finally {
            done.raise();
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      try {\r\n        var.set(callF(r));\r\n      } finally {\r\n        ev...";
      }
    });
    beforeDelegatingToThread(t);
    try {
      startThread(t);
      evalWithTimeout_inTime.add(t);
      evalWithTimeout_allThreads.add(t);
      try {
        done.waitUntilUp(timeoutMS);
        doneWaiting.raise();
      } finally {
        evalWithTimeout_inTime.remove(t);
      }
      if (!done.isUp()) {
        print("Cancelling thread (timeout)");
        cancelAndInterruptThread(t);
        return either2(t);
      }
      if (error.get() != null)
        rethrow(error.get());
      return either1(var.get());
    } finally {
      afterDelegatingToThread(t);
    }
  }

  static public Either<Object, Thread> evalWithTimeout(double timeoutSeconds, final Object r) {
    return evalWithTimeout(toMS_int(timeoutSeconds), r);
  }

  static public Cache<Boolean> isLinux_cache = new Cache<>(() -> isLinux_load());

  static public boolean isLinux() {
    return isLinux_cache.get();
  }

  static public Boolean isLinux_load() {
    return !isWindows() && !isMac() && !isAndroid();
  }

  static public Object addHeader(String header, String value, Object response) {
    call(response, "addHeader", header, value);
    return response;
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public Lock dbLock() {
    return db_mainConcepts().lock;
  }

  static public Lock dbLock(Concepts cc) {
    return cc == null ? null : cc.lock;
  }

  static public Lock dbLock(Concept c) {
    return dbLock(c == null ? null : c._concepts);
  }

  static public <A, B> A firstOfPair(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public IConceptIndex simpleConceptIndex(final Runnable r) {
    return new IConceptIndex() {

      public void update(Concept c) {
        pcallF(r);
      }

      public void remove(Concept c) {
        pcallF(r);
      }
    };
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public <A> IterableIterator<A> iff(Object f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public IterableIterator iff(F0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public <A> IterableIterator iff(IF0 f) {
    return iteratorFromFunction_withEndMarker(f);
  }

  static public String addLineBreak(String s) {
    return addSuffix(s, "\n");
  }

  static public String multiLineQuoteWithSpaces(String s) {
    return multiLineQuote(" " + s + " ");
  }

  static public MenuItem menuItem(String text, final Object r) {
    MenuItem mi = new MenuItem(text);
    mi.addActionListener(actionListener(r));
    return mi;
  }

  static public boolean addDefaultVMOption(String option) {
    String s = defaultVMArgs(), old = s;
    if (!s.contains(option))
      s = trim(s + " " + option);
    if (eq(old, s))
      return false;
    {
      setDefaultVMArgs(s);
      return true;
    }
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public String hfileupload(Object... params) {
    return hinputtag("", paramsPlus_noOverwrite(params, "type", "file", "name", "thefile"));
  }

  static public String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  static public Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String dialCodeStringForCountryCode(String countryCode) {
    CountryDialCode cdc = countryDialCodeByCountryCode(countryCode);
    return cdc == null ? null : cdc.dialCode;
  }

  static public <A> A nuStubInnerObject(Class<A> c) {
    return nuStubInnerObject(c, null);
  }

  static public <A> A nuStubInnerObject(Class<A> c, Object classFinder) {
    try {
      return (A) nuStubInnerObject_findConstructor(c, classFinder).newInstance(new Object[] { null });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  static public JDesktopPane mainDesktopPane_value;

  static public JDesktopPane mainDesktopPane() {
    return mainDesktopPane_value;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  static public <A, B extends Number> A keyWithHighestValue(Map<A, B> map) {
    return keyWithBiggestValue(map);
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  static public JPanel showFormTitled_customLayout(final F1<Container, Dimension> layouter, final String title, final Object... parts) {
    return showFormTitled_customArrangement(false, new F1<List<JComponent>, JPanel>() {

      public JPanel get(List<JComponent> components) {
        try {
          return customLayoutPanel(layouter, components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "customLayoutPanel(layouter, components)";
      }
    }, title, parts);
  }

  static public String squareBracketed(String s) {
    return "[" + s + "]";
  }

  static public List<String> javaTokWithAllPlusAngleBracketsC(String s) {
    return codeTokens(javaTokWithAllPlusAngleBrackets(s));
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Collection<A> c, final Object f) {
    return sortByCalculatedFieldDesc_inPlace(cloneList(c), f);
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Object f, Collection<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(b), f.get(a));
      }
    });
    return l;
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(IF1<A, B> f, Iterable<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public String hjssrc(String src) {
    return hjavascript_src(src);
  }

  static public <A> List<A> lookupPossiblyCI(MultiMap<String, A> map, String key) {
    return lookupPossiblyIgnoreCase(map, key);
  }

  static public <A> A lookupPossiblyCI(Map<String, A> map, String key) {
    return lookupPossiblyIgnoreCase(map, key);
  }

  static public String programName() {
    return getProgramName();
  }

  public static List<String> parseSnippetIDs(Collection<String> snippetIDs) {
    List<String> l = new ArrayList();
    for (String id : snippetIDs) l.add(str(parseSnippetID(id)));
    return l;
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public <A> A highestBy(Iterable<A> l, Object f) {
    return highestByFunction(l, f);
  }

  static public <A> A highestBy(Object f, Iterable<A> l) {
    return highestByFunction(f, l);
  }

  static public <A> A highestBy(Iterable<A> l, IF1<A, ? extends Comparable> f) {
    return highestByFunction(f, l);
  }

  static public <A> A highestBy(IF1<A, ? extends Comparable> f, A[] l) {
    return highestBy(f, asList(l));
  }

  static public <A> A highestBy(IF1<A, ? extends Comparable> f, Iterable<A> l) {
    return highestByFunction(f, l);
  }

  static public <A> void addToStringTree(StringTree2<A> tree, List<String> tokC, A leafValue) {
    if (leafValue == null)
      return;
    if (empty(tokC)) {
      tree.leafValue = leafValue;
      return;
    }
    String s = first(tokC);
    StringTree2 t = tree.getOrAdd(s);
    addToStringTree(t, dropFirst(tokC), leafValue);
  }

  static public String repLine(int n, String s) {
    return lines(rep(n, s));
  }

  static public boolean useDummyMainClasses() {
    return true;
  }

  static public String nSteps(long n) {
    return n2(n, "step");
  }

  static public String nSteps(Collection l) {
    return nSteps(l(l));
  }

  static public int packFrame_minw = 150, packFrame_minh = 50;

  static public <A extends Component> A packFrame(final A c) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Window w = getWindow(c);
            if (w != null) {
              w.pack();
              int maxW = getScreenWidth() - 50, maxH = getScreenHeight() - 50;
              w.setSize(min(maxW, max(w.getWidth(), packFrame_minw)), min(maxH, max(w.getHeight(), packFrame_minh)));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Window w = getWindow(c);\r\n    if (w != null) {\r\n      w.pack();\r\n      int ma...";
        }
      });
    }
    return c;
  }

  static public JFrame packFrame(ButtonGroup g) {
    return packFrame(getFrame(g));
  }

  static public String hInitWebSocket(Object... __) {
    String wsVar = optPar("wsVar", __, "ws");
    String onOpen = (String) (optPar("onOpen", __));
    String onMessage = (String) (optPar("onMessage", __));
    String readyMsg = optPar("readyMsg", __, "WebSocket ready!");
    return hreconnectingWebSockets() + hscript("\r\n      var wsReady = false;\r\n      var wsInitialMsgs = [];\r\n      var wsVerbose = false;\r\n      var " + wsVar + " = new ReconnectingWebSocket(((window.location.protocol === \"https:\") ? \"wss://\" : \"ws://\") + window.location.host + \"/\");\r\n      \r\n      " + wsVar + ".onopen = function(event) {\r\n        wsReady = true;\r\n        console.log(" + jsQuote(readyMsg) + ");\r\n        wsInitialMsgs.forEach(function(msg) {\r\n          if (wsVerbose) console.log(\"Sending initial msg: \" + msg);\r\n          ws.send(msg);\r\n        });\r\n        " + jsDropTrailingComments(onOpen) + " };\r\n        \r\n      " + wsVar + ".onmessage = function(event) {\r\n        " + unnull(onMessage) + "\r\n      };\r\n      \r\n      // add an initial message to send when websocket opens\r\n      // also send it now if ws is open already\r\n      function wsInitialMsg(msg) {\r\n        wsInitialMsgs.push(msg);\r\n        if (wsReady) {\r\n          if (wsVerbose) console.log(\"Sending initial msg: \" + msg);\r\n          ws.send(msg);\r\n        }\r\n      }\r\n    ");
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        Object __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      Object __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public boolean isJavaXClassLoader(ClassLoader cl) {
    return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public <A> int smartLastIndexOf(List<A> l, A sub) {
    int i = lastIndexOf(l, sub);
    return i < 0 ? l(l) : i;
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public ExpiringMap2<String, String> loadSnippet_simpleCache_map = new ExpiringMap2(10000);

  static public Lock loadSnippet_simpleCache_lock = lock();

  static public int loadSnippet_simpleCache_timeout = 60000;

  static public String loadSnippet_simpleCache(String id) {
    if (id == null)
      return null;
    Lock __0 = loadSnippet_simpleCache_lock;
    lock(__0);
    try {
      id = fsI(id);
      String src = loadSnippet_simpleCache_map.get(id);
      if (src != null)
        return src;
      Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_simpleCache_timeout);
      try {
        src = loadSnippet(id);
        if (src != null)
          loadSnippet_simpleCache_map.put(id, src);
        return src;
      } finally {
        loadPage_forcedTimeout_byThread.set(oldTimeout);
      }
    } finally {
      unlock(__0);
    }
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public boolean isAngleBracketVar(String s) {
    return isAngleBracketed(s);
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public boolean anyFileWithExtensionInDir(File dir, String ext) {
    return nempty(filesWithExtension(ext, findAllFiles_noDirs(dir)));
  }

  static public List<String> replaceSubList(List<String> l, List<String> x, List<String> y) {
    return replaceSublist(l, x, y);
  }

  static public <A> List<A> replaceSubList(List<A> l, int fromIndex, int toIndex, List<A> y) {
    return replaceSublist(l, fromIndex, toIndex, y);
  }

  static public String serveSnippetURL(String snippetID) {
    return "https://botcompany.de/serve/" + psI(snippetID);
  }

  static public Map<String, String> humanizeFormLabel_replacements = litmap("id", "ID", "md5", "MD5");

  static public String humanizeFormLabel(String s) {
    if (containsSpace(s))
      return s;
    return firstToUpper(joinWithSpace(replaceElementsUsingMap(splitCamelCase(s), humanizeFormLabel_replacements)).replace("I D", "ID"));
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public String starsToAngleBracketedNumbers(String s) {
    List<String> tok = javaTokWithAngleBrackets(s);
    int count = 0;
    for (int idx : indicesOf(tok, "*")) tok.set(idx, angleBracketed(str(++count)));
    return join(tok);
  }

  static public Map paramsToMap(Object... params) {
    int n = l(params);
    if (l(params) == 1 && params[0] instanceof Map)
      return (Map) params[0];
    LinkedHashMap map = new LinkedHashMap();
    for (int i = 0; i + 1 < n; i += 2) mapPut(map, params[i], params[i + 1]);
    return map;
  }

  static public int countPred(Iterable c, Object pred) {
    return nfilter(c, pred);
  }

  static public int countPred(Object pred, Iterable c) {
    return nfilter(pred, c);
  }

  static public <A> int countPred(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(c, pred);
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<IntRange> splitBusinessHoursAtMidnight(List<IntRange> l) {
    return concatLists(map(l, r -> r.end < r.start && r.start > 12 ? ll(intRange(r.start, 24 * 60), intRange(0, r.end)) : ll(r)));
  }

  static public <A> A highestByField(String field, Collection<A> l) {
    A best = null;
    Object bestValue = null;
    if (l != null)
      for (A a : l) {
        Object val = getOpt(a, field);
        if (val != null && (bestValue == null || cmp(val, bestValue) > 0)) {
          best = a;
          bestValue = val;
        }
      }
    return best;
  }

  static public <A> A highestByField(Collection<A> l, String field) {
    return highestByField(field, l);
  }

  static public Collection<String> getCodeFragmentSafety(String code) {
    Map<String, String> map = codeAnalysis_identifierSafetyMap();
    Set<String> identifiers = tok_allIdentifiers(code);
    Collection<String> tags = treeSet();
    for (String id : identifiers) {
      String tag;
      if (codeAnalysis_isSafeIdentifier(id))
        tag = "safe";
      else
        tag = or2(map.get(id), "?");
      tags.addAll(tokSplitAtComma(tag));
    }
    tags = simplifySafetyTags(tags);
    if (empty(tags))
      tags.add("safe");
    return tags;
  }

  static public Object serveJSON_shallowLineBreaks(Object data) {
    return serveText(jsonEncode_shallowLineBreaks(data));
  }

  static public void printExceptionShort(Throwable e) {
    printExceptionShort("", e);
  }

  static public void printExceptionShort(String prefix, Throwable e) {
    print(prefix, exceptionToStringShort(e));
  }

  static public String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  static public <A> Set<A> putSetElementsFirst(Collection<A> cl, Collection<A> elements) {
    Set<A> inputSet = asSet(cl);
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A a : unnullForIteration(elements)) if (contains(inputSet, a))
      set.add(a);
    addAll(set, cl);
    return set;
  }

  static public <A> Set<A> putSetElementsFirst(Collection<A> cl, A... elements) {
    return putSetElementsFirst(cl, asList(elements));
  }

  static public void close_pcall(AutoCloseable c) {
    if (c != null) {
      try {
        c.close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public <A> List<A> sortedByFieldDesc(Collection<A> c, String field) {
    List<A> l = new ArrayList(c);
    sort(l, descFieldComparator(field));
    return l;
  }

  static public <A> List<A> sortedByFieldDesc(String field, Collection<A> c) {
    return sortedByFieldDesc(c, field);
  }

  static public String renderConceptDate(Concept cc) {
    if (cc == null)
      return "";
    String c = formatLocalDateWithSeconds(cc.created);
    String m = formatLocalDateWithSeconds(cc._modified);
    String s = "Created " + c;
    if (neq(c, m))
      s += ", modified " + m;
    return s;
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public <A> A syncNextToLast(List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return nextToLast(l);
    }
  }

  static public Component wrapForSmartAdd(Object o) {
    if (o == null)
      return jpanel();
    if (o instanceof String)
      return jlabel((String) o);
    return wrap(o);
  }

  static public String hpassword(String name, Object... params) {
    return hpasswordfield(name, params);
  }

  static public String hpassword(String name) {
    return hpasswordfield(name);
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public <A, B> Map.Entry<A, B> firstEntry(Map<A, B> map) {
    return empty(map) ? null : first(map.entrySet());
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  static public boolean hasLock(Lock lock) {
    return ((ReentrantLock) lock).isHeldByCurrentThread();
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    params = unrollParams(params);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (eqOneOf(val, html_valueLessParam(), true))
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public Map jsonDecodeMap(String s) {
    Object o = jsonDecode(s);
    if (o instanceof List && empty((List) o))
      return new HashMap();
    if (o instanceof Map)
      return (Map) o;
    else
      throw fail("Not a JSON map: " + s);
  }

  static public double toM_double(long l) {
    return l / (1024 * 1024.0);
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public <A extends JCheckBox> A bindCheckBoxToLiveValue(final A cb, final SimpleLiveValue<Boolean> lv) {
    bindLiveValueListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          setChecked(cb, isTrue(lv.get()));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          lv.set(isChecked(cb));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    return cb;
  }

  static public String fsIOpt(String s) {
    return formatSnippetIDOpt(s);
  }

  static public RuntimeException wrapPatternSyntaxException(PatternSyntaxException e) {
    if (e == null)
      return null;
    String pat = e.getPattern();
    int i = e.getIndex();
    return new RuntimeException("Regular expression error between " + multiLineQuoteWithSpaces(substring(pat, 0, i)) + " and " + multiLineQuoteWithSpaces(substring(pat, i)) + " - " + e.getMessage());
  }

  static public int deleteAllFilesInDirectory_minPathLength = 10;

  static public void deleteAllFilesInDirectory(File dir) {
    deleteAllFilesInDirectory(dir, false, false);
  }

  static public void deleteAllFilesInDirectory(File dir, boolean verbose, boolean testRun) {
    dir = getCanonicalFile(dir);
    assertTrue(f2s(dir), l(f2s(dir)) >= deleteAllFilesInDirectory_minPathLength);
    File[] files = dir.listFiles();
    if (files == null)
      return;
    for (File f : files) {
      if (!isSymLink(f) && f.isDirectory())
        deleteDirectory(f, verbose, testRun);
      else {
        if (verbose)
          print((testRun ? "Would delete " : "Deleting ") + f.getAbsolutePath());
        if (!testRun)
          f.delete();
      }
    }
  }

  static public <A, B> Set<Map.Entry<A, B>> _entrySet(Map<A, B> map) {
    return map == null ? Collections.EMPTY_SET : map.entrySet();
  }

  static public String appendWithNewLine(String a, String b) {
    if (empty(b))
      return a;
    if (empty(a))
      return b;
    return addSuffix(a, "\n") + b;
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((nempty(msg) ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public void assertEqualsVerbose(Scorer scorer, Object x, Object y) {
    if (scorer == null) {
      assertEqualsVerbose(x, y);
      return;
    }
    if (!eq(x, y)) {
      print((y) + " != " + (x));
      scorer.add(false);
    } else {
      print("OK: " + (x));
      scorer.add(true);
    }
  }

  static public List<String> listZIP(File inZip) {
    return listZip(inZip);
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public <A, B, C> A first(T3<A, B, C> t) {
    return t == null ? null : t.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public <A> A first(A[] l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(pred, l);
  }

  static public String span(Object contents, Object... params) {
    return hfulltag("span", contents, params);
  }

  static public String span() {
    return span("");
  }

  static public String asciiSideBySide(List<String> texts) {
    if (l(texts) < 2)
      return unnull(first(texts));
    if (l(texts) > 2)
      return asciiSideBySide(ll(asciiSideBySide(dropLast(texts)), last(texts)));
    List<String> l1 = lines(first(texts)), l2 = lines(second(texts));
    int col1 = maxStringLength(l1), n = max(l(l1), l(l2));
    StringBuilder buf = new StringBuilder();
    for (int i = 0; i < n; i++) buf.append(rpad(unnull(get(l1, i)), col1)).append(unnull(get(l2, i))).append("\n");
    return str(buf);
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public int indexOfSpaceEtc(String s) {
    int n = l(s);
    for (int i = 0; i < n; i++) if (isSpace(s.charAt(i)))
      return i;
    return -1;
  }

  static public <A, B, C> List<C> mapPairsToList(Iterable<Pair<A, B>> l, F2<A, B, C> f) {
    List<C> x = emptyList(l);
    if (l != null)
      for (Pair<A, B> p : l) x.add(callF(f, p.a, p.b));
    return x;
  }

  static public <A, B, C> List<C> mapPairsToList(Iterable<Pair<A, B>> l, IF2<A, B, C> f) {
    List<C> x = emptyList(l);
    if (l != null)
      for (Pair<A, B> p : l) x.add(f.get(p.a, p.b));
    return x;
  }

  static public <A, B> List mapPairsToList(Object f, Iterable<Pair<A, B>> l) {
    List x = emptyList(l);
    if (l != null)
      for (Pair<A, B> p : l) x.add(callF(f, p.a, p.b));
    return x;
  }

  static public List<String> tok_subListWithoutBorderNTokens(List<String> tok, int i, int j) {
    List<String> tok2 = cloneSubList(tok, i & (~1), j | 1);
    tok2.set(0, "");
    tok2.set(l(tok2) - 1, "");
    return tok2;
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static public <A> A shallowClone(A o) {
    return (A) shallowClone_impl(o);
  }

  static public <A> A shallowClone(A o, A emptyClone) {
    return copyFields(o, emptyClone);
  }

  static public Object shallowClone_impl(Object o) {
    if (o == null)
      return o;
    if (o instanceof List)
      return cloneList((List) o);
    if (o instanceof Map)
      return cloneMap((Map) o);
    if (o instanceof String || o instanceof Number || o instanceof Boolean)
      return o;
    if (o instanceof Object[]) {
      Object[] l = (Object[]) o;
      return l.clone();
    }
    Class c = o.getClass();
    final Object clone = nuEmptyObject(c);
    copyFields(o, clone);
    return clone;
  }

  static public List<Component> allChildren(Component c) {
    return childrenOfType(c, Component.class);
  }

  static public <A> List<Pair<A, Integer>> multiSetToPairsByPopularity(MultiSet<A> ms) {
    List<Pair<A, Integer>> l = new ArrayList();
    if (ms != null)
      for (A a : ms.highestFirst()) l.add(pair(a, ms.get(a)));
    return l;
  }

  static public List<String> mechList_opt(String name) {
    return mechList_opt_tlft(name);
  }

  static public Set similarEmptySet(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeSet(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public Set similarEmptySet(Map m) {
    if (m instanceof TreeMap)
      return new TreeSet(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public <A, B> Map<A, B> filterMapByFunctionOnKey(Map<A, B> map, Object f) {
    Map<A, B> m2 = similarEmptyMap(map);
    for (A a : keys(map)) {
      if (isTrue(callF(f, a)))
        m2.put(a, map.get(a));
    }
    return m2;
  }

  static public <A, B> Map<A, B> filterMapByFunctionOnKey(Object f, Map<A, B> map) {
    return filterMapByFunctionOnKey(map, f);
  }

  static public String ahref_unstyled(String link, Object contents, Object... params) {
    if (link == null)
      return str(contents);
    return ahref(link, contents, paramsPlus(params, "style", unparseCSSParameter(mapPlus_noOverwrite(parseCSSParameter(stringPar("style", params)), "text-decoration", "none", "color", "inherit"))));
  }

  static public List<File> sortFilesByName(List<File> l) {
    sort(l, (a, b) -> stdcompare(a.getName(), b.getName()));
    return l;
  }

  static public <A, B> VF2<A, B> ivf2ToVF2(IVF2<A, B> f) {
    return f == null ? null : new VF2<A, B>() {

      public void get(A a, B b) {
        try {
          f.get(a, b);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "f.get(a, b)";
      }
    };
  }

  static public <A> A syncLast(List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return last(l);
    }
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public void onConceptsChange(Runnable r) {
    onConceptsChange(db_mainConcepts(), r);
  }

  static public void onConceptsChange(Concepts cc, Runnable r) {
    cc.addConceptIndex(simpleConceptIndex(r));
    cc.onAllChanged.add(r);
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    return oneOfTheFiles(asList(files));
  }

  static public File oneOfTheFiles(Iterable<File> files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public Map<String, Object> objectToMap(Object o) {
    try {
      if (o instanceof Map)
        return (Map) o;
      TreeMap<String, Object> map = new TreeMap();
      Class c = o.getClass();
      while (c != Object.class) {
        Field[] fields = c.getDeclaredFields();
        for (final Field field : fields) {
          if ((field.getModifiers() & Modifier.STATIC) != 0)
            continue;
          field.setAccessible(true);
          final Object value = field.get(o);
          if (value != null)
            map.put(field.getName(), value);
        }
        c = c.getSuperclass();
      }
      if (o instanceof DynamicObject)
        putAll(map, ((DynamicObject) o).fieldValues);
      return map;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Map<String, Object>> objectToMap(Iterable l) {
    if (l == null)
      return null;
    List x = new ArrayList();
    for (Object o : l) x.add(objectToMap(o));
    return x;
  }

  static public Object rcall(String method, Object o, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public <A extends JSpinner> A onChange(A spinner, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            spinner.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "spinner.addChangeListener(changeListener(r));";
        }
      });
    }
    return spinner;
  }

  static public <A extends AbstractButton> A onChange(A b, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            b.addItemListener(itemListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addItemListener(itemListener(r));";
        }
      });
    }
    return b;
  }

  static public void onChange(JTextComponent tc, Object r) {
    onUpdate(tc, r);
  }

  static public <A extends JSlider> A onChange(A slider, final Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            slider.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "slider.addChangeListener(changeListener(r));";
        }
      });
    }
    return slider;
  }

  static public JComboBox onChange(Object r, JComboBox cb) {
    return onChange(cb, r);
  }

  static public JComboBox onChange(JComboBox cb, final Object r) {
    if (isEditableComboBox(cb))
      onChange(textFieldFromComboBox(cb), r);
    else
      onSelectedItem(cb, new VF1<String>() {

        public void get(String s) {
          try {
            callF(r);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r)";
        }
      });
    return cb;
  }

  static public String nlToBr_withIndents(String s) {
    s = nlToBr(s);
    StringBuilder buf = new StringBuilder();
    int i = 0;
    while (i < l(s)) {
      while (charAt(s, i) == ' ') {
        ++i;
        buf.append("&nbsp;");
      }
      int j = smartIndexOf(s, i, '\n') + 1;
      buf.append(substring(s, i, j));
      i = j;
    }
    return str(buf);
  }

  static public String hsnippetimg(String imageID, Object... params) {
    return himg(snippetImageLink(imageID), params);
  }

  static public <A> AutoCloseable vmBus_onMessage(String msg, IVF1<A> onMessage) {
    return vmBus_onMessage(msg, ivf1ToVF1(onMessage));
  }

  static public <A> AutoCloseable vmBus_onMessage(final String msg, final VF1<A> onMessage) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, new VF2<String, Object>() {

        public void get(String _msg, Object arg) {
          try {
            callF(onMessage, arg);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(onMessage, arg)";
        }
      });
    }
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final IVF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public AutoCloseable vmBus_onMessage(String msg, Runnable onMessage) {
    return vmBus_onMessage(msg, runnableToVF1(onMessage));
  }

  static public String getUpToDateSnippetTranspilationMD5(String snippetID) {
    try {
      return loadPageSilently(tb_mainServer() + "/tb-int/get-transpilation-md5.php?id=" + psI(snippetID) + standardCredentials_noCookies());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String renderEqualsCommaProperties(Map<String, String> map) {
    return joinWithComma(map(map, (key, value) -> key + "=" + value));
  }

  static public String loadTextFileFromZipFile(File inZip, String fileName) {
    try {
      if (!fileExists(inZip))
        return null;
      try {
        ZipFile zip = new ZipFile(inZip);
        try {
          return loadTextFileFromZipFile(zip, fileName);
        } finally {
          _close(zip);
        }
      } catch (Throwable e) {
        throw fail(f2s(inZip), e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadTextFileFromZipFile(ZipFile zip, String fileName) {
    try {
      ZipEntry entry = zip.getEntry(fileName);
      if (entry == null)
        return null;
      InputStream fin = zip.getInputStream(entry);
      try {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        copyStream(fin, baos);
        return fromUTF8(baos.toByteArray());
      } finally {
        _close(fin);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadGZTextFile(File file) {
    try {
      if (!file.isFile())
        return null;
      ping();
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      InputStream fis = new FileInputStream(file);
      try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        byte[] buffer = new byte[1024];
        int len;
        while ((len = gis.read(buffer)) != -1) baos.write(buffer, 0, len);
        baos.close();
        return fromUtf8(baos.toByteArray());
      } finally {
        _close(fis);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public File remoteMechListMirrorsDir() {
    return javaxDataDir("Remote Mech Lists");
  }

  static public <A, B> MultiSetMap<A, B> treeMultiSetMap() {
    return new MultiSetMap(true);
  }

  static public <A, B> MultiSetMap<A, B> treeMultiSetMap(Comparator<A> comparator) {
    return new MultiSetMap(new TreeMap<A, Set<B>>(comparator));
  }

  static public String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String hjs_autoExpandingTextAreas() {
    return hjs_autoExpandingTextAreas(false);
  }

  static public String hjs_autoExpandingTextAreas(boolean verbose) {
    return hcss("\r\n      .auto-expand {\r\n        max-height: 30em; vertical-align: top;\r\n      }\r\n    ") + hjs(replaceDollarVars("\r\n    var autoExpandVerbose = $verbose;\r\n    \r\n    var autoExpandTextArea = function (ta) {\r\n      ta.style.height = \"1px\";\r\n      \r\n      // Get the computed styles for the element\r\n      var computed = window.getComputedStyle(ta);\r\n      \r\n      var h = ta.scrollHeight\r\n        + parseInt(computed.getPropertyValue('border-top-width'))\r\n        + parseInt(computed.getPropertyValue('border-bottom-width'));\r\n    \r\n      if (autoExpandVerbose)\r\n        console.log(\"Calculated auto-expand height \" + h + \" for \" + ta);\r\n      ta.style.height = h + 'px';\r\n    };\r\n  \r\n    document.addEventListener('input', function (event) {\r\n      if (!event.target.classList.contains(\"auto-expand\")) return;\r\n      autoExpandTextArea(event.target);\r\n    }, false);\r\n  \r\n    $(document).ready(function() {\r\n      $(\".auto-expand\").each(function() { autoExpandTextArea(this); });\r\n    });\r\n  ", "verbose", verbose));
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName) {
    return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
    return takeFirst(80 - 33, fileNameEncode(fullName)) + " - " + md5;
  }

  static public boolean isMenuSeparatorIndicator(Object o) {
    return eqOneOf(o, "***", "---", "===", "");
  }

  static public int withTopMargin_defaultWidth = 6;

  static public JPanel withTopMargin(Component c) {
    return withTopMargin(withTopMargin_defaultWidth, c);
  }

  static public JPanel withTopMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public AbstractAction abstractAction(String name, final Object runnable) {
    return new AbstractAction(name) {

      public void actionPerformed(ActionEvent evt) {
        pcallF(runnable);
      }
    };
  }

  static public String hmobilefix() {
    return "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">";
  }

  static public String hmobilefix(String html) {
    return hAddToHead(html, hmobilefix());
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public void dm_inQ(Runnable r) {
    dm_q().add(r);
  }

  static public void dm_inQ(DynModule mod, Runnable r) {
    dm_q(mod, r);
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public boolean conceptsSortedByFieldCI_verbose = false;

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Class<A> c, String field) {
    return conceptsSortedByFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexCI)
      return (Collection<A>) asList(((ConceptFieldIndexCI) index).objectIterator());
    if (conceptsSortedByFieldCI_verbose)
      print("conceptsSortedByFieldCI_verbose: Manual sort of " + c + " for " + field);
    return sortedByFieldIC(field, concepts.list(c));
  }

  static public String dropDollarPrefix(String s) {
    return dropPrefix("$", s);
  }

  static public int latestInstalledJavaX() {
    File[] files = new File(userHome(), ".javax").listFiles();
    int v = 0;
    if (files != null)
      for (File f : files) {
        Matcher m = regexpMatcher("x(\\d\\d\\d?)\\.jar", f.getName());
        if (m.matches())
          v = Math.max(v, Integer.parseInt(m.group(1)));
      }
    return v;
  }

  static public void printVars_str(Object... params) {
    print(renderVars_str(params));
  }

  static public Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  static public File remoteMechListMirrorNameFile(String listName) {
    return javaxDataDir("Remote Mech Lists/" + uniqueFileNameUsingMD5_80_v2(upper(listName)) + ".name");
  }

  static public boolean isCurrentThread(Thread t) {
    return t != null && t == currentThread();
  }

  static public Set<AutoCloseable> _registerAutoCloseable_set = synchroHashSet();

  static public void _registerAutoCloseable(AutoCloseable c) {
    addIfNotNull(_registerAutoCloseable_set, c);
  }

  static public void cleanMeUp__registerAutoCloseable() {
    closeAutoCloseables(getAndClearList(_registerAutoCloseable_set));
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public Class<?> hotwire(String src) {
    return hotwire(src, __1 -> mainClassNameForClassLoader(__1));
  }

  static public Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public String trimJoinSubList(List<String> l, int i, int j) {
    return trim(join(subList(l, i, j)));
  }

  static public String trimJoinSubList(List<String> l, int i) {
    return trim(join(subList(l, i)));
  }

  static public boolean hasSuperclassShortNamed(Object o, String name) {
    Class c = _getClass(o);
    while (c != null) if (shortClassNameIs(c, name))
      return true;
    else
      c = c.getSuperclass();
    return false;
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public <A> void syncReplaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    synchronized (collectionMutex(dest)) {
      dest.clear();
      if (src != null)
        dest.addAll(src);
    }
  }

  static public String deSquareBracket(String s) {
    if (startsWith(s, "[") && endsWith(s, "]"))
      return substring(s, 1, l(s) - 1);
    return s;
  }

  static public String hexColorToCSSRGB(String hex) {
    return empty(hex) ? null : "rgb(" + joinWithComma(rgbToIntList(new RGB(hex))) + ")";
  }

  static public Class veryQuickJava(CharSequence mainJava) {
    return veryQuickJava3(str(mainJava));
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public boolean eqicOrEq(Object a, Object b) {
    return a instanceof String && b instanceof String ? eqic((String) a, (String) b) : eq(a, b);
  }

  static public boolean eqicOrSwicPlusSpace(String a, String b) {
    return swic(a, b) && (l(a) == l(b) || a.charAt(l(b)) == ' ');
  }

  static public void revalidateFrame(Component c) {
    revalidate(getFrame(c));
  }

  static public <A> A lowestByField(Iterable<A> l, String field) {
    A lowest = null;
    Object lowestValue = null;
    for (A a : unnull(l)) {
      Object val = getOpt(a, field);
      if (lowest == null || cmp(val, lowestValue) < 0) {
        lowest = a;
        lowestValue = val;
      }
    }
    return lowest;
  }

  static public <A> A lowestByField(String field, Iterable<A> l) {
    return lowestByField(l, field);
  }

  static public boolean isTag(String token, String tag) {
    return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length() + 2) || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length() + 2);
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public String round(String s) {
    return roundBracket(s);
  }

  static public RandomAccessFile randomAccessFileForReading(File path) {
    try {
      return newRandomAccessFile(path, "r");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A syncPopLast(List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return popLast(l);
    }
  }

  static public <A> List<A> syncPopLast(int n, List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return popLast(n, l);
    }
  }

  static public <A, B> Map<A, B> weakHashMap() {
    return newWeakHashMap();
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public void consoleInputFont(final Font f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            JTextField input = consoleInputField();
            if (input != null) {
              input.setFont(f);
              revalidateFrame(input);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JTextField input = consoleInputField();\r\n    if (input != null) {\r\n      inpu...";
        }
      });
    }
  }

  static public String span_title(String title, Object contents) {
    return spanTitle(title, contents);
  }

  static public <A> Pair<List<A>, List<A>> filterAntiFilter(Iterable<A> c, Object pred) {
    List<A> yes = new ArrayList();
    List<A> no = new ArrayList();
    if (c != null)
      for (A o : c) (isTrue(callF(pred, o)) ? yes : no).add(o);
    return pair(yes, no);
  }

  static public <A> Pair<List<A>, List<A>> filterAntiFilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return filterAntiFilter(c, (Object) pred);
  }

  static public <A> Pair<List<A>, List<A>> filterAntiFilter(IF1<A, Boolean> pred, Iterable<A> c) {
    return filterAntiFilter(c, pred);
  }

  static public <A> Pair<List<A>, List<A>> filterAntiFilter(Object pred, Iterable<A> c) {
    return filterAntiFilter(c, pred);
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String dropParamFromURL(String url, String key) {
    Map<String, String> params = paramsFromURL(url);
    if (!containsKey(params, key))
      return url;
    params.remove(key);
    return addAnchorToURL(appendParamsToURL(urlWithoutQueryAndAnchor(url), params), anchorFromURL(url));
  }

  static public int defaultTokenizerCacheSize() {
    return 1000;
  }

  static public Map<String, String> decodeURIParams(String query) {
    return decodeHQuery(query);
  }

  static public int year() {
    return localYear();
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public String hNotificationPopups() {
    return hStylesheetSnippet_maxCache("#1029723") + hjssnippet_maxCache("#1029726") + hjs("\r\n      function successNotification(text) {\r\n        window.createNotification({ theme: 'success', showDuration: 3000 })({ message: text });\r\n      }\r\n      \r\n      function errorNotification(text) {\r\n        window.createNotification({ theme: 'error', showDuration: 3000 })({ message: text });\r\n      }\r\n    ");
  }

  static public Object subBot_serveInputStream(InputStream in, String mimeType) {
    return call(mainBot(), "serveInputStream", in, mimeType);
  }

  static public <A> A firstNotNull(Iterable<A> c) {
    Iterator<A> it = c.iterator();
    while (it.hasNext()) {
      A a = it.next();
      if (a != null)
        return a;
    }
    return null;
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public String reverseString(String s) {
    return empty(s) ? s : new StringBuilder(s).reverse().toString();
  }

  static public float score(Scored s) {
    return s == null ? 0 : s.score();
  }

  static public int howManySecondsAgo(long timestamp) {
    return iround(toSeconds(now() - timestamp));
  }

  static public Object subBot_httpd() {
    Object httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "MyHTTPD_current"));
    if (httpd == null)
      httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "WebSocketHTTPD_current"));
    return httpd;
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public String htmlEncode_nlToBr_withIndents(String s) {
    return nlToBr_withIndents(htmlEncode(s));
  }

  static public void clearToken(List<String> tok, int i) {
    tok.set(i, "");
  }

  static public String sortLinesAlphaNumIC(String s) {
    return lines_possiblyRTrim(s, sortedAlphanumIC(lines(s)));
  }

  static public ThreadLocal htmlTable2_cellEncoder = new ThreadLocal();

  static public String htmlTable2(Object data, Object... __) {
    boolean htmlEncode = optPar("htmlEncode", __, true);
    boolean useBr = boolPar("useBr", __);
    Map<String, Object[]> paramsByColName = (Map<String, Object[]>) (optPar("paramsByColName", __));
    Object[] tableParams = (Object[]) (optPar("tableParams", __));
    Object[] trParams = (Object[]) (optPar("trParams", __));
    Object[] tdParams = (Object[]) (optPar("tdParams", __));
    Map<String, String> replaceHeaders = (Map<String, String>) (optPar("replaceHeaders", __));
    boolean noHeader = boolPar("noHeader", __);
    List<List<String>> rows = new ArrayList();
    List<String> cols = new ContentsIndexedList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrText(key), structureOrText(value)));
      }
    } else
      print("Unknown data type: " + data);
    int w = 0;
    for (List<String> row : rows) w = max(w, l(row));
    StringBuilder buf = new StringBuilder();
    buf.append(hopeningtag("table", paramsPlus(tableParams, "border", html_valueLessParam())) + "\n");
    if (!noHeader) {
      buf.append("<tr>\n");
      for (String cell : padList(cols, w, "")) buf.append("  <th>" + htmlTable2_encodeCell(getOrKeep(replaceHeaders, cell), htmlEncode, useBr) + "</th>\n");
      buf.append("</tr>\n");
    }
    for (List<String> row : rows) {
      buf.append(hopeningtag("tr", trParams));
      int i = 0;
      for (String cell : padList(row, w, "")) {
        String col = get(cols, i++);
        Object[] params = paramsPlus(tdParams, mapGet(paramsByColName, col));
        buf.append("  " + tag("td", htmlTable2_encodeCell(cell, htmlEncode, useBr), params) + "\n");
      }
      buf.append("</tr>\n");
    }
    buf.append("</table>\n");
    return buf.toString();
  }

  static public String htmlTable2_encodeCell(String cell, boolean useHtmlEncode, boolean useBr) {
    if (htmlTable2_cellEncoder.get() != null)
      return (String) callF(htmlTable2_cellEncoder.get(), cell);
    if (useHtmlEncode)
      cell = htmlEncode2(cell);
    if (useBr)
      cell = nlToBr(cell);
    return cell;
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public JTextField jTextField() {
    return jTextField("");
  }

  static public JTextField jTextField(final String text) {
    return swing(new F0<JTextField>() {

      public JTextField get() {
        try {
          JTextField tf = new JTextField(unnull(text));
          standardTextFieldPopupMenu(tf);
          jenableUndoRedo(tf);
          tf.selectAll();
          return tf;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextField tf = new JTextField(unnull(text));\r\n    standardTextFieldPopupMenu...";
      }
    });
  }

  static public JTextField jTextField(Object o) {
    return jTextField(strOrEmpty(o));
  }

  static public <A> List<A> llNonNulls(A... a) {
    List<A> l = new ArrayList();
    for (A x : a) if (x != null)
      l.add(x);
    return l;
  }

  static public String newLinesToSpaces2(String s) {
    return newLinesToSpaces_trim(s);
  }

  static public <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      } else {
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public boolean hasLetters(String s) {
    for (int i = 0; i < s.length(); i++) if (Character.isLetter(s.charAt(i)))
      return true;
    return false;
  }

  static public TimeZone timeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public String hframeset_rows(String rows, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "rows", rows));
  }

  static public String fullRawLink(String pageName) {
    return (subBot_isHttps() ? "https" : "http") + "://" + domain() + rawLink(pageName);
  }

  static public JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    if (tf != null) {
      swing(new Runnable() {

        public void run() {
          try {
            tf.setText(text);
            tf.selectAll();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tf.setText(text);\r\n    tf.selectAll();";
        }
      });
    }
    return tf;
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public <A> List<A> sorted(Collection<A> c, Object comparator) {
    List<A> l = cloneList(c);
    sort(l, makeComparator(comparator));
    return l;
  }

  static public <A> List<A> sorted(Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l);
    return l;
  }

  static public <A> List<A> sorted(Comparator<A> comparator, Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l, comparator);
    return l;
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public List<String> splitAtDoubleArrow_bothDirections(String s) {
    return splitAtDoubleArrow_bothDirections(javaTok(s));
  }

  static public List<String> splitAtDoubleArrow_bothDirections(List<String> tok) {
    List<String> l = splitAtDoubleArrow(tok);
    if (l(l) != 2)
      l = reversedList(splitAtDoubleLeftArrow(tok));
    return l;
  }

  static public <A extends Concept> int countConceptsWhereCI(Concepts cc, Class<A> c, Object... params) {
    return countConceptsCI(cc, c, params);
  }

  static public <A extends Concept> int countConceptsWhereCI(Class<A> c, Object... params) {
    return countConceptsCI(c, params);
  }

  static public String renderHowLongAgoPlusModified(long timestamp, long timestamp2, Object... __) {
    String spacer = optPar("spacer", __, ", modified ");
    if (timestamp2 == 0)
      timestamp2 = timestamp;
    String s = renderHowLongAgo(timestamp);
    String s2 = renderHowLongAgo(timestamp2);
    return eq(s, s2) ? s : s + ", modified " + s2;
  }

  static public boolean isRunnable(Object o) {
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public <A extends Concept> A uniqCI(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqCI(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhereCI(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String jsonEncodeMap(Object... __) {
    return jsonEncode(paramsToMap(__));
  }

  static public Set emptySet() {
    return new HashSet();
  }

  static public JPanel showInternalFrameFormTitled(final JDesktopPane desktop, final String title, final Object... _parts) {
    JPanel panel = showForm_makePanel(true, _parts);
    showForm_makeInternalFrame(desktop, title, panel);
    return panel;
  }

  static public String div_floatRight(Object contents, Object... params) {
    return div(contents, params_stylePlus("float: right", params));
  }

  static public <A> A lookupOrKeep(Map<A, A> map, A key) {
    return map != null && map.containsKey(key) ? map.get(key) : key;
  }

  static public String unCurlyBracket(String s) {
    return tok_unCurlyBracket(s);
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Collection<Concept> allConcepts() {
    return db_mainConcepts().allConcepts();
  }

  static public Collection<Concept> allConcepts(Concepts concepts) {
    return concepts.allConcepts();
  }

  static public void indexConceptField(Class<? extends Concept> c, String field) {
    indexConceptField(db_mainConcepts(), c, field);
  }

  static public void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndex(concepts, c, field);
  }

  static public Pair<File, String> compileSnippetThroughServer(String progID) {
    String transpiledSrc = getServerTranspiled2(progID);
    String md5 = md5(transpiledSrc + "\n" + progID);
    File jar = CompilerBot.getJarFile(md5);
    if (jar == null || jar.length() <= 22) {
      byte[] jarData = null;
      boolean dontLoad = false;
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null) {
        dontLoad = true;
        File jar2 = rl.getSnippetJar(progID, transpiledSrc);
        if (jar2 != null)
          return pair(jar2, transpiledSrc);
      }
      if (!dontLoad) {
        try {
          jarData = loadBinaryPage("http://www.botcompany.de/jar/" + psI(progID) + "?md5=" + md5(transpiledSrc));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      if (!isJAR(jarData)) {
        if (jarData != null) {
          print(bytesToHex(takeFirstOfByteArray(8, jarData)));
          print("fallback to CompilerBot: " + fromUtf8(takeFirstOfByteArray(80, jarData)));
        }
        return CompilerBot.compileSnippet2(progID);
      }
      saveBinaryFile(jar, jarData);
    }
    return pair(jar, transpiledSrc);
  }

  static public int scoredSearch_score(Iterable<String> l, List<String> words) {
    int score = 0;
    if (l != null)
      for (String s : l) score += scoredSearch_score(s, words);
    return score;
  }

  static public int scoredSearch_score(String s, List<String> words) {
    int score = 0;
    if (nempty(s))
      for (String word : unnullForIteration(words)) score += scoredSearch_score_single(s, word);
    return score;
  }

  static public int scoredSearch_score(String s, String query) {
    return scoredSearch_score(s, scoredSearch_prepare(query));
  }

  static public <A, B> boolean isA(Either<A, B> e) {
    return eitherIsA(e);
  }

  static public boolean titlePopupMenu(final Component c, final Object menuMaker) {
    JComponent titleBar = getTitlePaneComponent(getPossiblyInternalFrame(c));
    if (titleBar == null) {
      print("Can't add title right click!");
      return false;
    } else {
      componentPopupMenu(titleBar, menuMaker);
      return true;
    }
  }

  static public String mp3mimeType() {
    return "audio/mpeg";
  }

  static public <A, B> boolean isB(Either<A, B> e) {
    return eitherIsB(e);
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public Object subBot_serveRedirect(String url) {
    return call(getMainBot(), "serveRedirect", url);
  }

  static public Set vm_generalWeakSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = newWeakHashSet());
      return set;
    }
  }

  static public List<String> uniquifyCI(Collection<String> l) {
    TreeSet<String> set = ciSet();
    List<String> out = new ArrayList();
    for (String a : unnull(l)) if (set.add(a))
      out.add(a);
    return out;
  }

  static public void close(AutoCloseable c) {
    _close(c);
  }

  static public String regexpReplaceIC(String s, String pat, Object f) {
    return regexReplaceIC(s, pat, f);
  }

  static public String regexpReplaceIC(String s, String pat, String replacement) {
    return regexReplaceIC(s, pat, replacement);
  }

  static public String regexpReplaceIC(String s, String pat, IF1<Matcher, String> f) {
    return regexReplaceIC(s, pat, f);
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public void assertStartsWith(List a, List b) {
    if (!startsWith(a, b))
      throw fail(a + " does not start with " + b);
  }

  static public void assertStartsWith(String a, String b) {
    if (!startsWith(a, b))
      throw fail(quote(a) + " does not start with " + quote(b));
  }

  static public File tempDirPossiblyInRAMDisk() {
    File f = linux_fileInRamDisk(aGlobalID());
    if (f != null) {
      f.mkdirs();
      return f;
    }
    return makeTempDir();
  }

  static public boolean isFile(File f) {
    return f != null && f.isFile();
  }

  static public boolean isFile(String path) {
    return isFile(newFile(path));
  }

  static public int javaxIncludeSnippetType() {
    return 42;
  }

  static public int indexOfPred(List l, Object pred) {
    for (int i = 0; i < l(l); i++) if (checkCondition(pred, l.get(i)))
      return i;
    return -1;
  }

  static public <A, B> int indexOfPred(List<A> l, IF1<A, B> pred) {
    return indexOfPred(l, (Object) pred);
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public Comparator makeComparator(final Object f) {
    if (f instanceof Comparator)
      return (Comparator) f;
    return new Comparator() {

      public int compare(Object a, Object b) {
        return (Integer) callF(f, a, b);
      }
    };
  }

  static public Map<String, String> standardClassesMap() {
    String sc = loadSnippet("#1003674");
    Map<String, String> map = new HashMap();
    for (String line : tlft_j(sc)) {
      int idx = line.indexOf('/');
      map.put(line.substring(0, idx), line.substring(idx + 1));
    }
    return map;
  }

  static public <A extends Component> A setBounds(final int x, final int y, final int w, final int h, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(x, y, w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(x, y, w, h);";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(A a, Rect r) {
    if (a != null && r != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(toRectangle(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(toRectangle(r));";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(Rect r, A a) {
    return setBounds(a, r);
  }

  static public <A extends Component> A setBounds(A a, int x, int y, int w, int h) {
    return setBounds(x, y, w, h, a);
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '<')
        out.append("&lt;");
      else if (c == '>')
        out.append("&gt;");
      else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public <A extends Concept> A conceptWhereIC(Class<A> c, Object... params) {
    return findConceptWhereCI(c, params);
  }

  static public Concept conceptWhereIC(String c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A conceptWhereIC(Concepts concepts, Class<A> c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public Concept conceptWhereIC(Concepts concepts, String c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public Object serveCSVWithFileName(String fileName, String text) {
    Object response = serveWithContentType(text, "text/csv");
    call(response, "addHeader", "Content-Disposition", "inline; filename=\"" + fileName + "\"");
    return response;
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> MultiSetMap<String, A> ciMultiSetMap() {
    MultiSetMap<String, A> mm = new MultiSetMap();
    mm.data = ciMap();
    return mm;
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  static public <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<String, String> stdFunctions_uncached() {
    return stdFunctions_uncached(new HashMap());
  }

  static public Map<String, String> stdFunctions_uncached(Map<String, String> map) {
    parseStdFunctionsList(loadSnippetSilently("#1006654"), map);
    parseStdFunctionsList(loadSnippetSilently("#761"), map);
    return map;
  }

  static public int findEndOfBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "("))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public File prepareProgramFile(String name) {
    return mkdirsForFile(getProgramFile(name));
  }

  static public File prepareProgramFile(String progID, String name) {
    return mkdirsForFile(getProgramFile(progID, name));
  }

  static public java.util.Calendar calendarFromTime(long time, TimeZone tz) {
    java.util.Calendar c = java.util.Calendar.getInstance(tz);
    c.setTimeInMillis(time);
    return c;
  }

  static public java.util.Calendar calendarFromTime(long time) {
    java.util.Calendar c = java.util.Calendar.getInstance();
    c.setTimeInMillis(time);
    return c;
  }

  static public String hjavascript_src(String src, Object... __) {
    return hfulltag("script", "", paramsPlus(__, "src", src));
  }

  static public <A, B> Either<A, B> eitherB(B b) {
    return new Either(2, b);
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return classLoaderForObject(realm).loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public <A, B> void replaceMap(Map<A, B> dest, Map<A, B> src) {
    if (dest == src)
      return;
    dest.clear();
    dest.putAll(src);
  }

  static public <A, B> Either<A, B> eitherA(A a) {
    return new Either(1, a);
  }

  static public <A> List<A> syncShallowCloneElements(List<A> l) {
    return syncLambdaMap(__88 -> shallowClone(__88), l);
  }

  static public String indentStructureString_firstLevels(int levelsToIndent, String s) {
    if (s == null)
      return null;
    List<String> tok = javaTokForStructure(s);
    StringBuilder buf = new StringBuilder();
    int level = 0;
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (isOpeningBracket(t)) {
        int j = i + 5;
        if (containsClosingBracket(subList(tok, i + 2, i + 5))) {
          buf.append(joinSubList(tok, i, j));
          i = j - 1;
        } else {
          buf.append(t);
          ++level;
          if (level <= levelsToIndent)
            buf.append("\n").append(spaces(level * 2));
        }
      } else if (isClosingBracket(t)) {
        if (level-- <= levelsToIndent)
          buf.append("\n").append(spaces(level * 2));
        buf.append(t);
      } else if (eq(t, ",")) {
        buf.append(t);
        if (level <= levelsToIndent)
          buf.append("\n").append(spaces(level * 2));
        i++;
      } else
        buf.append(t);
    }
    return str(buf);
  }

  static public boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  static public boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  static public boolean instanceOf(Class c, Object o) {
    return instanceOf(o, c);
  }

  static public String asciiSideBySideWithSeparator(String sep, List<String> texts) {
    if (empty(texts))
      return asciiSideBySide(texts);
    int rows = maxLineCount(texts);
    List<String> out = new ArrayList();
    for (int i = 0; i < l(texts); i++) {
      if (i != 0)
        out.add(repLine(rows, sep));
      out.add(texts.get(i));
    }
    return asciiSideBySide(out);
  }

  static public <A, B> Either<A, B> either2(B b) {
    return new Either(2, b);
  }

  static public <A, B> Either<A, B> either1(A a) {
    return new Either(1, a);
  }

  static public List<Component> getComponents(final Component c) {
    return !(c instanceof Container) ? emptyList() : asList(swing(new F0<Component[]>() {

      public Component[] get() {
        try {
          return ((Container) c).getComponents();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret ((Container) c).getComponents();";
      }
    }));
  }

  static public Map<String, String> paramsFromURL(String url) {
    return decodeHQuery(getQueryFromURL(url));
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public List<String> splitAtComma_trim(String s) {
    return nempties(trimAll(splitAtComma(s)));
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public Object evalWithTimeoutOrException(final Object f, int timeoutMS) {
    return evalWithTimeoutOrException(timeoutMS, f);
  }

  static public Object evalWithTimeoutOrException(int timeoutMS, final Object f) {
    return eitherAOpt(evalWithTimeout(timeoutMS, f));
  }

  static public Object evalWithTimeoutOrException(double timeoutSeconds, final Object f) {
    return eitherAOpt(evalWithTimeout(timeoutSeconds, f));
  }

  static public <A> A evalWithTimeoutOrException(int timeoutMS, F0<A> f) {
    Either<Object, Thread> e = evalWithTimeout(timeoutMS, f);
    if (e.isA())
      return (A) e.a();
    throw fail(trim("Timeout after " + timeoutMS + " ms. " + unnull(stackTraceForThread(e.b()))));
  }

  static public <A> A evalWithTimeoutOrException(double timeoutSeconds, F0<A> f) {
    return evalWithTimeoutOrException(toMS_int(timeoutSeconds), f);
  }

  static public <A> A evalWithTimeoutOrException(int timeoutMS, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutMS, if0ToF0(f));
  }

  static public <A> A evalWithTimeoutOrException(double timeoutSeconds, IF0<A> f) {
    return evalWithTimeoutOrException(timeoutSeconds, if0ToF0(f));
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public File getCodeProgramDir() {
    return getCodeProgramDir(getProgramID());
  }

  static public File getCodeProgramDir(String snippetID) {
    return new File(javaxCodeDir(), formatSnippetID(snippetID));
  }

  static public File getCodeProgramDir(long snippetID) {
    return getCodeProgramDir(formatSnippetID(snippetID));
  }

  static public <A> MultiMap<String, A> ciMultiMap() {
    return caseInsensitiveMultiMap();
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void addActionListener(JTextField tf, final Runnable action) {
    onEnter(tf, action);
  }

  static public void addActionListener(final JComboBox cb, final Runnable action) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public void addActionListener(final AbstractButton b, final Runnable action) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            b.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public JPanel showFormTitled_customArrangement(final boolean internalFrame, final F1<List<JComponent>, JPanel> arrange, final String title, final Object... _parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
          JPanel panel = callF(arrange, out);
          showForm_makeFrame(title, panel);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "L<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, ...";
      }
    });
  }

  static public int fixInternalFrame_borderTopLeft = 0;

  static public int fixInternalFrame_borderBottomRight = 40;

  static public JInternalFrame fixInternalFrame(final JInternalFrame f) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Container c = f.getParent();
          if (c == null)
            return f;
          Rect r = toRect(f.getBounds());
          int a = fixInternalFrame_borderTopLeft, b = fixInternalFrame_borderBottomRight;
          Rect outer = new Rect(a, a, c.getWidth() - b, c.getHeight() - b);
          if (!rectContains(outer, r))
            f.setLocation(max(a, min(r.x, outer.x2())), max(a, min(r.y, outer.y2())));
          if (r.w > c.getWidth() || r.h > c.getHeight())
            f.setSize(c.getWidth() - a, c.getHeight() - a);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Container c = f.getParent();\r\n    if (c == null) ret f;\r\n    Rect r = toRect(...";
      }
    });
  }

  static public String hcss(Object contents) {
    if (contents instanceof String && isRelativeOrAbsoluteURL((String) contents))
      return hstylesheetsrc((String) contents);
    else
      return htag("style", contents);
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public void clearTokens(List<String> tok) {
    clearAllTokens(tok);
  }

  static public void clearTokens(List<String> tok, int i, int j) {
    clearAllTokens(tok, i, j);
  }

  static public void clearTokens(List<String> tok, IntRange r) {
    clearAllTokens(tok, r.start, r.end);
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public boolean java10OrHigher() {
    return parseFirstInt(javaVersion()) >= 10;
  }

  static public List<String> splitAtJavaToken(String s, String splitToken) {
    return splitByJavaToken(s, splitToken);
  }

  static public Object subBot_serve500() {
    return call(getMainBot(), "serve500");
  }

  static public Object subBot_serve500(String msg) {
    return call(getMainBot(), "serve500", msg);
  }

  static public Object subBot_serve500(Throwable error) {
    return subBot_serve500(renderStackTrace(error));
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      mkdirsForFile(file);
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      vmBus_send("wroteFile", file);
      return file;
    } finally {
      action.done();
    }
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object subBot_maxCacheHeaders(Object response) {
    return callMainBot("maxCacheHeaders", response);
  }

  static public Object serveByteArray(byte[] data, String mimeType) {
    return subBot_serveByteArray(data, mimeType);
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public Map<Class, Set<String>> allFields_cache = weakHashMap();

  static public Set<String> allFields(Object o) {
    if (o == null)
      return emptySet();
    Class _c = _getClass(o);
    Set<String> fields = allFields_cache.get(_c);
    if (fields == null)
      allFields_cache.put(_c, fields = asTreeSet(keys(getOpt_getFieldMap(o))));
    return fields;
  }

  static public Window getWindow(Object o) {
    if (!(o instanceof Component))
      return null;
    return swing(() -> {
      Component c = (Component) o;
      while (c != null) {
        if (c instanceof Window)
          return ((Window) c);
        c = c.getParent();
      }
      return null;
    });
  }

  static public String hhiddenWithID(String id) {
    return hhiddenWithID(id, null);
  }

  static public String hhiddenWithID(String id, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", id, "value", value));
  }

  static public String htmlEncode2If(boolean b, String s) {
    return b ? htmlEncode2(s) : s;
  }

  static public Object loadJSONFile(File f) {
    return jsonDecode(loadTextFile(f));
  }

  static public int findEndOfAngleBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eq(cnc.get(j), "<"))
        ++level;
      else if (eq(cnc.get(j), ">"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public Object mainBot() {
    return getMainBot();
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public Map<String, String> decodeHQuery(String query) {
    Map<String, String> map = new HashMap();
    for (String s : splitAtAmpersand(query)) {
      int i = s.indexOf('=');
      if (i >= 0)
        map.put(urldecode(s.substring(0, i)), urldecode(s.substring(i + 1)));
    }
    return map;
  }

  static public <A extends Concept> A conceptWhereCI(Class<A> c, Object... params) {
    return findConceptWhereCI(c, params);
  }

  static public Concept conceptWhereCI(String c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A conceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public Concept conceptWhereCI(Concepts concepts, String c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public <A extends Concept> A lowestConceptByField(Class<A> c, String field) {
    return lowestConceptByField(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> A lowestConceptByField(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc) {
      Map.Entry e = ((NavigableMap) ((ConceptFieldIndexDesc) index).valueToObject.data).lastEntry();
      return e == null ? null : (A) first((Collection) e.getValue());
    }
    return lowestByField(field, concepts.list(c));
  }

  static public String loadCachedTranspilation(String id) {
    try {
      return loadTextFilePossiblyGZipped(getCachedTranspilationFile(id));
    } catch (Throwable __e) {
      return null;
    }
  }

  static public File infoBoxesLogFile() {
    return new File(javaxDataDir(), "Logs/infoBoxes.txt");
  }

  static public AtomicInteger dialogServer_clients = new AtomicInteger();

  static public boolean dialogServer_printConnects = false;

  static public ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  static public Set<String> dialogServer_knownClients = synchroTreeSet();

  static public int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  static public int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  static public void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  static public ServerSocket startDialogServer_serverSocket;

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public <A> String pnlToString(String prefix, Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(prefix, l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(prefix, l)";
      }
    });
  }

  static public <A> String pnlToString(final Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A> String pnlToString(final A[] l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A, B> String pnlToString(final Map<A, B> map) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(map);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(map)";
      }
    });
  }

  static public <A, B> String pnlToString(MultiMap<A, B> map) {
    return pnlToString(multiMapToMap(map));
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public <A> String lines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines(l, f);
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public boolean deleteFile(File file) {
    return file != null && file.delete();
  }

  static public String tok_expandIfQuoted(String s) {
    return applyTranspilationFunction(__89 -> tok_expandIfQuoted(__89), s);
  }

  static public void tok_expandIfQuoted(List<String> tok) {
    jreplace(tok, "if <quoted> || <quoted>", "if (matchOneOf(s, m, $2, $5))");
    jreplace_dyn(tok, "if <quoted>", new F2<List<String>, Integer, String>() {

      public String get(List<String> tok, Integer cIdx) {
        try {
          String s = unquote(tok.get(cIdx + 2));
          List<String> l = new ArrayList();
          for (String pat : splitAtJavaToken(s, "|")) {
            if (pat.contains("..."))
              l.add("matchX(" + quote(trim(pat)) + ", s, m)");
            else if (javaTok(pat).contains("*"))
              l.add("match(" + quote(trim(pat)) + ", s, m)");
            else
              l.add("match(" + quote(trim(pat)) + ", s)");
          }
          return "if (" + join(" || ", l) + ")";
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S s = unquote(tok.get(cIdx+2));\r\n    //print(\"multimatch: \" + quote(s));\r\n   ...";
      }
    }, new TokCondition() {

      public boolean get(final List<String> tok, final int i) {
        return javaTokC(unquote(tok.get(i + 3))).contains("|");
      }
    });
    tok_transpileIfQuoted_dollarVars(tok);
    jreplace(tok, "if <quoted>", "if (find3plusRestsX($2, s, m))", new TokCondition() {

      public boolean get(final List<String> tok, final int i) {
        return startsAndEndsWith(unquote(tok.get(i + 3)), "...");
      }
    });
    jreplace(tok, "if <quoted>", "if (matchStartX($2, s, m))", new TokCondition() {

      public boolean get(final List<String> tok, final int i) {
        return unquote(tok.get(i + 3)).endsWith("...");
      }
    });
    jreplace(tok, "if <quoted>", "if (match($2, s))", new TokCondition() {

      public boolean get(final List<String> tok, final int i) {
        return !javaTokC(unquote(tok.get(i + 3))).contains("*");
      }
    });
    jreplace(tok, "if <quoted>", "if (match($2, s, m))");
    jreplace(tok, "if match <quoted>", "if (match($3, s, m))");
  }

  static public JPanel centerAndSouthWithMargins(Component c, Component s) {
    return applyDefaultMargin(centerAndSouth(c, withTopMargin(s)));
  }

  static public JPanel centerAndSouthWithMargins(int margin, Component c, Component s) {
    return applyMargin(margin, centerAndSouth(c, withTopMargin(margin, s)));
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public boolean nempty(Rect r) {
    return r != null && r.w != 0 && r.h != 0;
  }

  static public boolean nempty(CloseablesHolder ch) {
    return ch != null && !empty(ch.closeables);
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  static public int lengthOfString(String s) {
    return s == null ? 0 : s.length();
  }

  static public long ipToInt(String ip) {
    Matches m = new Matches();
    assertTrue(jmatch("*.*.*.*", ip, m));
    return parseLong(m.unq(3)) | parseLong(m.unq(2)) << 8 | parseLong(m.unq(1)) << 16 | parseLong(m.unq(0)) << 24;
  }

  static public Object dm_os() {
    {
      Object __1 = vm_generalMap_get("stefansOS");
      if (__1 != null)
        return __1;
    }
    return creator();
  }

  static public Object serveText(Object s) {
    return call(getMainBot(), "serveByteArray", toUtf8(str(s)), "text/plain; charset=utf8");
  }

  static public boolean standardFunctionsCacheUpToDate(TreeSet<String> functionSet) {
    File f = transpiledStandardFunctions_file(functionSet);
    long date = recommendedTranspilationDateForStandardFunctions(functionSet);
    return date != 0 && f.lastModified() >= date;
  }

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public boolean tok_classHasModifier(List<String> classDecl, String modifier) {
    if (classDecl == null)
      return false;
    int i = classDecl.indexOf("class");
    return subList(classDecl, 0, i).contains(modifier);
  }

  static public String prependSquareBracketed(Object o) {
    String s = str(o);
    return empty(s) ? "" : squareBracketed(s) + " ";
  }

  static public Object dm_getStemByID(Object id) {
    return dm_callOS("getModuleByID", str(id));
  }

  static public int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public <A extends Concept> List<A> sortByConceptID(Collection<A> l) {
    return sortConceptsByID(l);
  }

  static public ExpiringMap2<String, String> mechList_raw_cache = new ExpiringMap2(10000).setMap(ciMap());

  static public Lock mechList_raw_lock = lock();

  static public int mechList_raw_timeout = 60000;

  static public String mechList_raw(String name) {
    try {
      Lock __0 = mechList_raw_lock;
      lock(__0);
      try {
        if (empty(name))
          return "";
        String src = mechList_raw_cache.get(name);
        if (src != null)
          return src;
        src = mechList_raw_fresh(name);
        if (src != null)
          mechList_raw_cache.put(name, src);
        return src;
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void _onLoad_mechList_raw() {
    ownResource(vmBus_onMessage("mechChange", listName -> mechList_raw_cache.remove((String) listName)));
  }

  static public Object serveFile(File file) {
    return subBot_serveFile(file);
  }

  static public Object serveFile(File file, String mimeType) {
    return subBot_serveFile(file, mimeType);
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    if (r == null)
      return null;
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public <A> List<A> replaceElementsUsingMap(Iterable<A> l, final Map<A, A> map) {
    return map(l, new F1<A, A>() {

      public A get(A a) {
        try {
          return getOrKeep(map, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "getOrKeep(map, a)";
      }
    });
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public int iceil(double d) {
    return (int) Math.ceil(d);
  }

  static public String smallestTransparentGIFDataURI() {
    return "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
  }

  static public <A> List<A> uniquify(Collection<A> l) {
    return uniquifyList(l);
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public List<Integer> jfindAll(List<String> tok, String pat) {
    return jfindAll(tok, pat, null);
  }

  static public List<Integer> jfindAll(List<String> tok, String pat, ITokCondition condition) {
    return jfindAll(tok, jfind_preprocess(javaTok(pat)), condition);
  }

  static public List<Integer> jfindAll(List<String> tok, List<String> tokPat) {
    return jfindAll(tok, tokPat, null);
  }

  static public List<Integer> jfindAll(List<String> tok, List<String> tokPat, ITokCondition condition) {
    TokCondition cond = toTokCondition(condition);
    String[] toks = toStringArray(codeTokensOnly(tokPat));
    int i = -1;
    List<Integer> l = new ArrayList();
    while ((i = findCodeTokens(tok, i + 1, false, toks, cond)) >= 0) l.add(i);
    return l;
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public String hjs_imgUploadBase64Encoder() {
    return hscript("\r\n    var imgConverted = false;\r\n    \r\n    function submitWithImageConversion(form) {\r\n      console.log(\"imgConverted: \" + imgConverted + \", form: \" + form);\r\n      if (imgConverted) return true;\r\n      imgConverted = true;\r\n      var file = $('#imgUploader')[0].files[0];\r\n      if (file == null) return true;\r\n      var reader = new FileReader();\r\n\r\n      // delay form submit until reader is done\r\n      reader.onloadend = function () {\r\n        var b64 = reader.result.replace(/^data:.+;base64,/, '');\r\n        $(\"#f_img_base64\").val(b64);\r\n        console.log(\"Got base64 data: \" + b64.length);\r\n        setTimeout(function() {\r\n          $(form).submit();\r\n        }, 1000);\r\n      };\r\n\r\n      reader.readAsDataURL(file);\r\n      return false;\r\n    }\r\n  ");
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public boolean dm_isFirstSiblingModule_debug = false;

  static public boolean dm_isFirstSiblingModule(Object mod) {
    String libID = dm_moduleLibID(mod);
    if (libID == null)
      return false;
    List<String> siblings = dm_modulesWithLibID(libID);
    if (dm_isFirstSiblingModule_debug)
      printVars("libID", libID, "siblings", siblings);
    if (empty(siblings))
      return true;
    return eq(dm_moduleID(mod), lowestByAlphaNum(siblings));
  }

  static public String windowsLineBreaks(String s) {
    return s == null ? null : s.replaceAll("(?<!\r)\n", "\r\n");
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
    List<B> out = new ArrayList();
    if (l != null)
      for (A a : l) addIfNotNull(out, map.get(a));
    return out;
  }

  static public <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public <A> Set<A> weakSet() {
    return synchroWeakHashSet();
  }

  static public String snippetImageLink(String snippetID) {
    return snippetImageURL(snippetID);
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public Map safeUnstructMapAllowingClasses(String s, Class... allowedClasses) {
    return (Map) safeUnstructureAllowingClasses(s, allowedClasses);
  }

  static public int minuteInDay() {
    return minuteInDay(java.util.Calendar.getInstance());
  }

  static public int minuteInDay(java.util.Calendar c) {
    return hours(c) * 60 + minutes(c);
  }

  static public int minuteInDay(long time) {
    return minuteInDay(calendarFromTime(time));
  }

  static public int minuteInDay(TimeZone tz) {
    return minuteInDay(now(), tz);
  }

  static public int minuteInDay(long time, TimeZone tz) {
    return minuteInDay(calendarFromTime(time, tz));
  }

  static public void addMenuItem(JPopupMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(JPopupMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(Menu menu, String text, Object action) {
    menu.add(menuItem(text, action));
  }

  static public void addMenuItem(JMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenuBar menuBar, String text, Runnable action) {
    addMenuItem(menuBar, jmenuItem(text, action));
  }

  static public void addMenuItem(JMenuBar menuBar, JMenuItem menuItem) {
    addDirectMenuItem(menuBar, menuItem);
  }

  static public String longestPrefixInNavigableSet(String s, NavigableSet<String> set) {
    if (set == null || s == null)
      return null;
    while (licensed()) {
      String key = set.floor(s);
      if (key == null)
        break;
      int n = lCommonPrefix(key, s);
      if (n == l(key))
        return key;
      s = takeFirst(s, n);
    }
    return null;
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public void touchConcept(Concept c) {
    if (c != null)
      c.change();
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public <A, B> B getAndRemove(Map<A, B> map, A a) {
    if (!containsKey(map, a))
      return null;
    B b = map.get(a);
    map.remove(a);
    return b;
  }

  static public <A, B> B getAndRemove(A a, Map<A, B> map) {
    return getAndRemove(map, a);
  }

  static public List<String> stringToStringListOpt(IF1<String, List<String>> f, Object o) {
    if (o instanceof String)
      return f.get((String) o);
    return (List) o;
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public <A> String mapToLines(IF1<A, String> f, A data1, A... moreData) {
    return lines(map(f, data1, moreData));
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public <A extends Concept> List<Pair<A, String>> findBackRefsWithFieldNames(Concept c, Class<A> type) {
    List<Pair<A, String>> l = new ArrayList();
    if (c != null && c.backRefs != null)
      for (Concept.Ref r : cloneList(c.backRefs)) if (instanceOf(r.concept(), type))
        l.add(pair((A) r.concept(), fieldNameForConceptLink(r.concept(), c)));
    return l;
  }

  static public boolean _inCore() {
    return false;
  }

  static public ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  static public ReliableSingleThread dm_rst(Runnable r) {
    return dm_rst(dm_current_mandatory(), r);
  }

  static public ReliableSingleThread dm_rst(DynModule mod, Runnable r) {
    return dm_rst(mod, new ReliableSingleThread(r));
  }

  static public ReliableSingleThread dm_rst(DynModule mod, ReliableSingleThread rst) {
    rst.enter = dm_rEnter(mod);
    return rst;
  }

  static public <A extends Concept> Collection<A> findConceptsWhereCI(Class<A> c, Object... params) {
    return findConceptsWhereCI(db_mainConcepts(), c, params);
  }

  static public List<Concept> findConceptsWhereCI(String c, Object... params) {
    return findConceptsWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhereCI(Concepts concepts, Class<A> c, Object... params) {
    Collection<A> l = findConceptsWhereCI_noParent(concepts, c, params);
    if (concepts.parent == null)
      return l;
    return concatCollections_conservative(l, findConceptsWhereCI(concepts.parent, c, params));
  }

  static public <A extends Concept> Collection<A> findConceptsWhereCI_noParent(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.ciFieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFieldsIC(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConceptsIC(concepts.list(c), params);
  }

  static public List<Concept> findConceptsWhereCI(Concepts concepts, String c, Object... params) {
    return filterConceptsIC(concepts.list(c), params);
  }

  static public Object makeDependent_postProcess;

  static public void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, String in, ITokCondition condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, ITokCondition condition) {
    return jfind(tok, startIndex, in, (Object) condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public void loadFunctions_clearCache() {
    callOptMC("loadFunctions_cached_clearCache");
  }

  static public String stringIfTrue(boolean b, String s) {
    return b ? s : "";
  }

  static public List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  static public File pathToJavaxJar() {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.pathToJavaXJar();
    return pathToJavaxJar_noResourceLoader();
  }

  static public File pathToJavaxJar_noResourceLoader() {
    try {
      int x = latestInstalledJavaX();
      File xfile = new File(userHome(), ".javax/x" + Math.max(x, 30) + ".jar");
      if (!xfile.isFile()) {
        print("Saving " + f2s(xfile));
        String url = x30JarServerURL();
        byte[] data = loadBinaryPage(url);
        if (data.length < 1000000)
          throw fail("Could not load " + url);
        saveBinaryFile(xfile.getPath(), data);
      }
      return xfile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public String renderHowLongAgo(Timestamp ts) {
    return renderHowLongAgo(timestampToLong(ts));
  }

  static public String renderHowLongAgo(long timestamp) {
    if (timestamp == 0)
      return "never";
    int seconds = howManySecondsAgo(timestamp);
    if (seconds <= 0)
      return "just now";
    if (seconds < 60)
      return n2(seconds, "second") + " ago";
    int minutes = iround(seconds / 60.0);
    if (minutes < 60)
      return n2(minutes, "minute") + " ago";
    int hours = iround(minutes / 60.0);
    if (hours < 24)
      return n2(hours, "hour") + " ago";
    int days = iround(hours / 24.0);
    return n2(days, "day") + " ago";
  }

  static public JFrame showFrame() {
    return makeFrame();
  }

  static public JFrame showFrame(Object content) {
    return makeFrame(content);
  }

  static public JFrame showFrame(String title) {
    return makeFrame(title);
  }

  static public JFrame showFrame(String title, Object content) {
    return makeFrame(title, content);
  }

  static public JFrame showFrame(final JFrame f) {
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (frameTooSmall(f))
              frameStandardSize(f);
            if (!f.isVisible())
              f.setVisible(true);
            if (f.getState() == Frame.ICONIFIED)
              f.setState(Frame.NORMAL);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frameTooSmall(f)) frameStandardSize(f);\r\n    if (!f.isVisible()) f.setVis...";
        }
      });
    }
    return f;
  }

  static public JFrame showFrame(String title, Object content, JFrame frame) {
    if (frame == null)
      return showFrame(title, content);
    else {
      frame.setTitle(title);
      setFrameContents(frame, content);
      return frame;
    }
  }

  static public String hrefresh(String target) {
    return hrefresh(0, target);
  }

  static public String hrefresh(double seconds) {
    return hrefresh(seconds, "");
  }

  static public String hrefresh(double seconds, String target) {
    return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(List<A> l, final Object f) {
    sort(l, new Comparator<A>() {

      public int compare(A b, A a) {
        return stdcompare((Object) callF(f, a), (Object) callF(f, b));
      }
    });
    return l;
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(Object f, List<A> c) {
    return sortByCalculatedFieldDesc_inPlace(c, f);
  }

  static public boolean fileContentsIs(File f, byte[] data) {
    try {
      if (isFile(f) != (data != null))
        return false;
      int l = l(data);
      if (fileSize(f) != l)
        return false;
      BufferedInputStream in = bufferedFileInputStream(f);
      try {
        for (int ofs = 0; ofs < l; ofs++) if (data[ofs] != (byte) in.read())
          return false;
        return true;
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  static public List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public <A extends Concept> int countConceptsWhereIC(Concepts cc, Class<A> c, Object... params) {
    return countConceptsCI(cc, c, params);
  }

  static public <A extends Concept> int countConceptsWhereIC(Class<A> c, Object... params) {
    return countConceptsCI(c, params);
  }

  static public String hsimpletableheader(String... cols) {
    return tag("tr", join(lambdaMap(__90 -> th(__90), cols)));
  }

  static public String beforeVerticalBar(String s) {
    return trimSubstring(s, 0, smartIndexOf(s, '|'));
  }

  static public String hStylesheetSnippet_maxCache(String snippetID) {
    return tag("link", "", "rel", "stylesheet", "type", "text/css", "href", snippetRawURL_maxCache(snippetID, "text/css"));
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static public boolean isStringOrIntOrLong(Object o) {
    return o instanceof String || o instanceof Integer || o instanceof Long;
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public String localDateWithMinutes(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm");
    return format.format(time);
  }

  static public String localDateWithMinutes() {
    return localDateWithMinutes(now());
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public String dropTrailingSlashIfNemptyAfterwards(String s) {
    return l(s) > 1 ? dropSuffix("/", s) : s;
  }

  static public Integer parseHourAndOptionalMinutesToMinutes(String s) {
    List<String> l = trimAll(splitAtColon(s));
    if (empty(l))
      return null;
    int minute = parseInt(first(l)) * 60;
    if (l(l) > 1)
      minute += parseInt(second(l));
    return minute;
  }

  static public int findEndOfBracketPart2(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "(", "["))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")", "]"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public NavigableMap<String, String> emojiShortNameMap_cache;

  static public NavigableMap<String, String> emojiShortNameMap() {
    if (emojiShortNameMap_cache == null)
      emojiShortNameMap_cache = emojiShortNameMap_load();
    return emojiShortNameMap_cache;
  }

  static public NavigableMap<String, String> emojiShortNameMap_load() {
    NavigableMap<String, String> map = ciMap();
    for (Map m : rawEmojisList()) {
      String shortName = (String) (m.get("shortname"));
      String emoji = (String) (m.get("emoji"));
      if (startsWith(shortName, ":"))
        map.put(shortName, emoji);
    }
    return map;
  }

  static public String stringOptPar(Object[] params, String name) {
    return (String) optPar(params, name);
  }

  static public void callF_thread(final Object f, final Object... args) {
    if (f != null) {
      startThread(new Runnable() {

        public void run() {
          try {
            callF(f, args);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(f, args);";
        }
      });
    }
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public int[] subArray(int[] b, int start, int end) {
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public short[] subArray(short[] b, int start, int end) {
    if (start <= 0 && end >= l(b))
      return b;
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public float[] subArray(float[] b, int start, int end) {
    float[] x = new float[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public Object[] subArray(Object[] b, int start) {
    return subArray(b, start, l(b));
  }

  static public Object[] subArray(Object[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new Object[0];
    Object[] x = new Object[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean all(Object pred, Iterable l) {
    if (l != null)
      for (Object o : l) if (!isTrue(callF(pred, o)))
        return false;
    return true;
  }

  static public <A> boolean all(Iterable<A> l, IF1<A, Boolean> f) {
    if (l != null)
      for (A a : l) if (!f.get(a))
        return false;
    return true;
  }

  static public <A> boolean all(IF1<A, Boolean> f, Iterable<A> l) {
    return all(l, f);
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public boolean codeAnalysis_isSafeIdentifier(String id) {
    return startsWith(id, "$");
  }

  static public Object[] paramsPlus_inFront(Object[] a1, Object... a2) {
    return paramsPlus(a2, a1);
  }

  static public void inputText(final String msg, final Object action) {
    inputText(msg, "", action);
  }

  static public void inputText(final String msg, final String defaultText, final Object action) {
    final Object threadInfo = _threadInfo();
    swingLater(new Runnable() {

      public void run() {
        try {
          final JTextField tf = jtextfield(defaultText);
          String title = joinStrings(" | ", msg, programName());
          JComponent form = showFormTitled(title, unnull(msg), tf, new Runnable() {

            public void run() {
              try {
                vmBus_send("inputtingText_OK", threadInfo, msg, tf);
                callF_thread(action, getTextTrim(tf));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "vmBus_send(\"inputtingText_OK\", threadInfo, msg, tf);\r\n        callF_thread(ac...";
            }
          });
          renameSubmitButton(form, "OK");
          vmBus_send("inputtingText", threadInfo, msg, tf);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTextField tf = jtextfield(defaultText);\r\n    String title = joinString...";
      }
    });
  }

  static public void inputText(String msg, String defaultText, IVF1<String> action) {
    inputText(msg, defaultText, (Object) action);
  }

  static public void inputText(String msg, IVF1<String> action) {
    inputText(msg, (Object) action);
  }

  static public boolean hasLettersAllUpperCase(String s) {
    return hasLetters(s) && !containsLowerCase(s);
  }

  static public long recommendedTranspilationDateForStandardFunctions(Collection<String> sfNames) {
    long date = 0;
    for (String name : sfNames) {
      long d = recommendedTranspilationDateForStandardFunction(name);
      if (d == 0)
        return 0;
      date = max(date, d);
    }
    return date;
  }

  static public Matcher regexpMatcherIC(String pat, String s) {
    return compileRegexpIC(pat).matcher(unnull(s));
  }

  static public boolean cset_trueIfChanged(Concept c, Object... values) {
    try {
      return cset(c, values) != 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JTextArea jTextArea() {
    return jTextArea("");
  }

  static public JTextArea jTextArea(final String text) {
    return jTextAreaWithUndo(text);
  }

  static public <A, B> Map<A, B> mapPlus_noOverwrite(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl_noOverwrite(m, data);
    return m;
  }

  static public Object serve500() {
    return subBot_serve500();
  }

  static public Object serve500(String msg) {
    return subBot_serve500(msg);
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  static public <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  static public void onEnterInAllTextFields(JComponent c, Object action) {
    if (action == null)
      return;
    for (Component tf : allChildren(c)) onEnterIfTextField(tf, action);
  }

  static public void onEnterInAllTextFields(List c, Object action) {
    for (Object o : unnull(c)) if (o instanceof JComponent)
      onEnterInAllTextFields((JComponent) o, action);
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = f.get();
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF2();
  }

  static public int vstackWithSpacing_default = 10;

  static public JPanel vstackWithSpacing(final List parts) {
    return vstackWithSpacing(parts, vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(final List parts, final int spacing) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          GridBagConstraints gbc = new GridBagConstraints();
          gbc.weightx = 1;
          gbc.fill = GridBagConstraints.HORIZONTAL;
          gbc.gridwidth = GridBagConstraints.REMAINDER;
          gbc.insets = new Insets(spacing / 2, 0, spacing / 2, 0);
          smartAddWithLayout(panel, gbc, toObjectArray(nonNulls(parts)));
          gbc.weighty = 1;
          gbc.insets = new Insets(0, 0, 0, 0);
          panel.add(jrigid(), gbc);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    new GridBagConstraints gbc...";
      }
    });
  }

  static public JPanel vstackWithSpacing(Component... parts) {
    return vstackWithSpacing(asList(parts), vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(int spacing, Component... parts) {
    return vstackWithSpacing(asList(parts), spacing);
  }

  static public List collect(Iterable c, String field) {
    return collectField(c, field);
  }

  static public List collect(String field, Iterable c) {
    return collectField(c, field);
  }

  static public <A> void scanForComponents(final Component c, final Class<A> theClass, final List<A> l) {
    if (theClass.isInstance(c))
      l.add((A) c);
    if (c instanceof Container) {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component comp : ((Container) c).getComponents()) scanForComponents(comp, theClass, l);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component comp : ((Container) c).getComponents())\r\n      scanForComponen...";
        }
      });
    }
  }

  static public <A extends Concept> A registerConcept(A c) {
    return registerConcept(db_mainConcepts(), c);
  }

  static public <A extends Concept> A registerConcept(Concepts cc, A c) {
    {
      if (cc != null)
        cc.register(c);
    }
    return c;
  }

  static public String defaultJavaXTranslatorID_value = "#759";

  static public String defaultJavaXTranslatorID() {
    return defaultJavaXTranslatorID_value;
  }

  static public String nullIfEmpty(String s) {
    return isEmpty(s) ? null : s;
  }

  static public <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
    return isEmpty(map) ? null : map;
  }

  static public <A> List<A> nullIfEmpty(List<A> l) {
    return isEmpty(l) ? null : l;
  }

  static public boolean isSafeStandardFunction(String name) {
    return isCodeSafe(formatFunctionCall(name));
  }

  static public List<String> hotwire_libraryIDsFromJar(File jar) {
    String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
    return regexpExtractAll("\\d+", dehlibs);
  }

  static public <A, B> Map<A, B> applyFunctionToValue(IF1<A, A> f, A key, Map<A, B> map) {
    return applyFunctionToMapValue(key, f, map);
  }

  static public <A, B> Map<A, B> applyFunctionToValue(IF1<A, A> f, Map<A, B> map, A... keys) {
    for (A key : unnullForIteration(keys)) applyFunctionToValue(f, key, map);
    return map;
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + s.replace("\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public List<String> tok_splitAtComma_unquote(String s) {
    List<String> tok = javaTok(s);
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(unquote(trimJoinSubList(tok, i, j)));
      i = j;
    }
    return out;
  }

  static public JWindow infoBox(String text) {
    return infoMessage(text);
  }

  static public JWindow infoBox(String text, double seconds) {
    return infoMessage(text, seconds);
  }

  static public JWindow infoBox(Throwable e) {
    return infoMessage(e);
  }

  static public SimpleDateFormat simpleDateFormat_timeZone(String format, String timeZone) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(timeZone(timeZone));
    return sdf;
  }

  static public String angleBracketVarsToStars(String s) {
    return angleBracketVarsToStars(s, null);
  }

  static public String angleBracketVarsToStars(String s, List<String> varNames_out) {
    List<String> tok = javaTokWithAngleBrackets(s);
    for (int idx : indicesOfAngleBracketVars(tok)) {
      {
        if (varNames_out != null)
          varNames_out.add(deAngleBracket(tok.get(idx)));
      }
      tok.set(idx, "*");
    }
    return join(tok);
  }

  static public Rect rect(int x, int y, int w, int h) {
    return new Rect(x, y, w, h);
  }

  static public Rect rect(Pt p, int w, int h) {
    return new Rect(p.x, p.y, w, h);
  }

  static public Rect rect(int w, int h) {
    return new Rect(0, 0, w, h);
  }

  static public Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  static public <A extends Concept> A derefRef(Concept.Ref<A> r) {
    return r == null ? null : r.get();
  }

  static public String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  static public AutoCloseable tempCleaningUp() {
    return tempSetTL(ping_isCleanUpThread, true);
  }

  static public String hjavascript_src_withType(String src, Object... __) {
    return hfulltag("script", "", paramsPlus_inFront(__, "src", src, "type", "text/javascript"));
  }

  static public String joinNempties(String sep, Object... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Iterable strings) {
    return joinStrings(sep, strings);
  }

  static public String html_emojisToUnicode(String s) {
    return join(mapNonCodeTokens(__91 -> emojisToUnicode(__91), htmlTok(s)));
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public <A, B> Set<A> keySet(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keySet(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  static public File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  static public Class _run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public String indentStructureString(String s) {
    return indentStructureString(100, s);
  }

  static public String indentStructureString(int levels, String s) {
    if (s == null)
      return null;
    List<String> tok = javaTokForStructure(s);
    StringBuilder buf = new StringBuilder();
    int indent = 0;
    levels = clampToInt(levels * 2L);
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (isOpeningBracket(t)) {
        int j = i + 5;
        if (containsClosingBracket(subList(tok, i + 2, i + 5))) {
          buf.append(joinSubList(tok, i, j));
          i = j - 1;
        } else {
          indent += 2;
          buf.append(t);
          if (indent <= levels)
            buf.append("\n").append(spaces(indent));
        }
      } else if (isClosingBracket(t)) {
        indent -= 2;
        if (indent < levels)
          buf.append("\n").append(spaces(indent));
        buf.append(t);
      } else if (indent <= levels && eq(t, ",")) {
        buf.append(t).append("\n").append(spaces(indent));
        i++;
      } else
        buf.append(t);
    }
    return str(buf);
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        Class c = get2(name);
        return c;
      }

      public Class get2(String name) {
        if (eq(name, "<main>"))
          return mc();
        {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
        }
        if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
          for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
            String newName = pkg + afterDollar(name);
            {
              Class c = findClass_fullName(newName);
              if (c != null)
                return c;
            }
          }
        return null;
      }
    };
  }

  static public HashSet mapToSet(Object f, Iterable l) {
    return mapToHashSet(f, l);
  }

  static public <A, B> HashSet<B> mapToSet(IF1<A, B> f, Iterable<A> l) {
    return mapToSet((Object) f, l);
  }

  static public <A, B> HashSet<B> mapToSet(IF1<A, B> f, A[] l) {
    return mapToSet(f, asList(l));
  }

  static public <A, B> HashSet<B> mapToSet(Iterable<A> l, IF1<A, B> f) {
    return mapToSet((Object) f, l);
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public String replacePlusWithSpace(String s) {
    return replace(s, '+', ' ');
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int findEndOfBlock(List<String> cnc, int i) {
    int j = i + 2, level = 1, n = cnc.size();
    while (j < n) {
      String t = cnc.get(j);
      if ("{".equals(t))
        ++level;
      else if ("}".equals(t))
        --level;
      if (level == 0)
        return j + 1;
      j += 2;
    }
    return n;
  }

  static public String tb_mainServer_default = "http://code.botcompany.de:8081";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public <A> boolean any(Object pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (isTrue(callF(pred, a)))
        return true;
    return false;
  }

  static public <A> boolean any(IF1<A, Boolean> pred, Iterable<A> l) {
    return any((Object) pred, l);
  }

  static public <A> boolean any(Iterable<A> l, IF1<A, Boolean> pred) {
    return any(pred, l);
  }

  static public <A> boolean any(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return true;
    return false;
  }

  static public boolean any(Iterable<Boolean> l) {
    if (l != null)
      for (Boolean a : l) if (isTrue(a))
        return true;
    return false;
  }

  static public void disposeWindow(final Window window) {
    if (window != null) {
      swing(new Runnable() {

        public void run() {
          try {
            window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING));
            myFrames_list.remove(window);
            window.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); //...";
        }
      });
    }
  }

  static public void disposeWindow(final Component c) {
    disposeWindow(getWindow(c));
  }

  static public void disposeWindow(Object o) {
    if (o != null)
      disposeWindow(((Component) o));
  }

  static public void disposeWindow() {
    disposeWindow(heldInstance(Component.class));
  }

  static public JTextField textFieldFromComboBox(JComboBox cb) {
    return (JTextField) cb.getEditor().getEditorComponent();
  }

  static public TreeMap litCIMap(Object... x) {
    TreeMap map = caseInsensitiveMap();
    litmap_impl(map, x);
    return map;
  }

  static public <A> A proxyFromInvocationHandler(Class<A> intrface, InvocationHandler handler) {
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, handler);
  }

  static public String joinNemptiesWithColonSpace(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColonSpace(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public List<String> dropHTMLTags(List<String> tok) {
    return dropAllTags(tok);
  }

  static public String dropHTMLTags(String html) {
    return dropAllTags(html);
  }

  static public Object callMainBot(String method, Object... args) {
    return call(mainBot(), method, args);
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public <A> void listAdd(Collection<A> c, A a) {
    if (c != null)
      c.add(a);
  }

  static public <A> List<A> reversed(Iterable<A> l) {
    return reversedList(l);
  }

  static public <A> List<A> reversed(A[] l) {
    return reversedList(asList(l));
  }

  static public String reversed(String s) {
    return reversedString(s);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public int moveToTopRightCorner_inset = 20;

  static public <A extends Component> A moveToTopRightCorner(A a) {
    return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
  }

  static public <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
    Window w = getWindow(a);
    if (w != null)
      w.setLocation(getScreenSize().width - w.getWidth() - insetX, insetY);
    return a;
  }

  static public String hjs_fileUploadBase64Encoder() {
    return hscript("\r\n    var fileConverted = false;\r\n    \r\n    function submitWithFileConversion(form) {\r\n      if (fileConverted) return true;\r\n      fileConverted = true;\r\n      var file = $('#fileUploader')[0].files[0];\r\n      if (file == null) return true;\r\n      var reader = new FileReader();\r\n\r\n      // delay form submit until reader is done\r\n      reader.onloadend = function () {\r\n        var b64 = reader.result.replace(/^data:.+;base64,/, '');\r\n        $(\"#f_file_base64\").val(b64);\r\n        console.log(\"Got base64 data: \" + b64.length);\r\n        setTimeout(function() {\r\n          $(form).submit();\r\n        }, 1000);\r\n      };\r\n\r\n      reader.readAsDataURL(file);\r\n      return false;\r\n    }\r\n  ");
  }

  static public <A> boolean eqGetOneOf(List<A> l, int i, A... options) {
    return eqOneOf(get(l, i), options);
  }

  static public long done2_always(long startTime, String desc) {
    long time = sysNow() - startTime;
    saveTiming_noPrint(time);
    print(desc + " [" + time + " ms]");
    return time;
  }

  static public long done2_always(String desc, long startTime) {
    return done2_always(startTime, desc);
  }

  static public long done2_always(long startTime) {
    return done2_always(startTime, "");
  }

  static public LinkedHashMap paramsToOrderedMap(Object... params) {
    return asLinkedHashMap(paramsToMap(params));
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(A[] l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, A[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = f.get(l[i]);
    return array;
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public String regexpReplace(String s, String pat, Object f) {
    return regexReplace(s, pat, f);
  }

  static public String regexpReplace(String s, String pat, IF1<Matcher, String> f) {
    return regexReplace(s, pat, f);
  }

  static public Q dm_q() {
    return dm_current_mandatory().q();
  }

  static public void dm_q(Runnable r) {
    dm_inQ(r);
  }

  static public void dm_q(DynModule module, Runnable r) {
    module.q().add(r);
  }

  static public <A> A dm_q(IF0<A> f) {
    return dm_evalInQ(if0ToF0(f));
  }

  static public File programFile(String name) {
    return prepareProgramFile(name);
  }

  static public File programFile(String progID, String name) {
    return prepareProgramFile(progID, name);
  }

  static public AutoCloseable tempActivity(Object r) {
    return null;
  }

  static public long raf_findEndOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      long length = raf.length();
      while (pos < length) {
        raf.seek(pos);
        raf.readFully(buf, 0, (int) Math.min(length - pos, bufSize));
        int idx = indexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return pos + idx + 1;
        pos += bufSize;
      }
      return length;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setFrameContents(final Component c, final Object contents) {
    swing(new Runnable() {

      public void run() {
        try {
          JFrame frame = getFrame(c);
          if (frame == null)
            return;
          frame.getContentPane().removeAll();
          frame.getContentPane().setLayout(new BorderLayout());
          frame.getContentPane().add(wrap(contents));
          revalidate(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JFrame frame = getFrame(c);\r\n  if (frame == null) return;\r\n  frame.getContent...";
      }
    });
  }

  static public Object cloneIfList(Object o) {
    return o instanceof List ? cloneList((List) o) : o;
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public String gazelle_postMentionRegexp() {
    return regexpCaseInsensitivePrefix() + "\\bpost\\s+(\\d+)";
  }

  static public <A> A lookupIgnoreCase(Map<String, A> map, String key) {
    for (String s : map.keySet()) if (eqic(s, key))
      return map.get(s);
    return null;
  }

  static public <A> List<A> lookupIgnoreCase(MultiMap<String, A> map, String key) {
    for (String s : map.keySet()) if (eqic(s, key))
      return map.get(s);
    return litlist();
  }

  static public void setInternalFrameContents(final Component c, final Object contents) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            JInternalFrame frame = getInternalFrame(c);
            if (frame == null)
              return;
            frame.getContentPane().removeAll();
            frame.getContentPane().setLayout(new BorderLayout());
            if (contents != null)
              frame.getContentPane().add(wrap(contents));
            revalidate(frame);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JInternalFrame frame = getInternalFrame(c);\r\n    if (frame == null) return;\r\n...";
        }
      });
    }
  }

  static public String hrefBlank(String link, Object contents, Object... params) {
    return empty(link) ? strOrEmpty(contents) : tag("a", contents, concatArrays(new Object[] { "href", link, "target", "_blank" }, params));
  }

  static public FixedRateTimer dm_doEvery(long delay, Runnable r) {
    return dm_ownTimer(doEvery(delay, delay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(long delay, long firstDelay, Runnable r) {
    return dm_ownTimer(doEvery(delay, firstDelay, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double initialSeconds, double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(initialSeconds, delaySeconds, dm_rEnter(r)));
  }

  static public FixedRateTimer dm_doEvery(double delaySeconds, Runnable r) {
    return dm_ownTimer(doEvery(delaySeconds, dm_rEnter(r)));
  }

  static public void tokPrepend_reTok(List<String> tok, int i, String s) {
    tokPrepend(tok, i, s);
    reTok(tok, i, i + 1);
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null || o == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        Field f = fieldMap.get(field);
        if (f != null)
          smartSet(f, o, val);
        else {
          dynamicObject_setRawFieldValue(o, intern(field), val);
        }
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  static public <A extends Concept> void onIndividualConceptChange_notOnAllChanged(Class<A> type, IVF1<A> r) {
    onIndividualConceptChange_notOnAllChanged(db_mainConcepts(), type, r);
  }

  static public <A extends Concept> void onIndividualConceptChange_notOnAllChanged(Concepts cc, Class<A> type, IVF1<A> r) {
    if (r != null) {
      if (cc != null)
        cc.addConceptIndex(new IConceptIndex() {

          public void update(Concept c) {
            if (instanceOf(c, type))
              r.get((A) c);
          }

          public void remove(Concept c) {
          }
        });
    }
  }

  static public <A extends Component> A jMinWidthAtLeast(int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          Dimension d = new Dimension(max(w, size.width), size.height);
          c.setMinimumSize(d);
          return jPreferWidth(d.width, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    Dimension d = new Dimension(max(w, ...";
      }
    });
  }

  static public <A extends Concept> boolean isConceptClassIndexed(Class<A> c) {
    return isConceptClassIndexed(db_mainConcepts(), c);
  }

  static public <A extends Concept> boolean isConceptClassIndexed(Concepts concepts, Class<A> c) {
    return concepts.conceptCounterForClass(c) != null;
  }

  static public Object pcallOpt(Object o, String method, Object... args) {
    try {
      return callOpt(o, method, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  static public <A> List<A> nonNulls(Iterable<A> l) {
    return withoutNulls(l);
  }

  static public <A> List<A> nonNulls(A[] l) {
    return withoutNulls(l);
  }

  static public <A, B> Map<A, B> nonNulls(Map<A, B> map) {
    return withoutNulls(map);
  }

  static public String hinputfield(String name, Object... params) {
    return htextinput(name, params);
  }

  static public MultiSet<String> asCIMultiSet(Iterable<String> l) {
    MultiSet<String> ms = new MultiSet();
    ms.map = ciMap();
    ms.addAll(l);
    return ms;
  }

  static public <A, B> Map<A, B> mapWithoutKey(Map<A, B> map, A key) {
    if (map == null || !map.containsKey(key))
      return map;
    Map m = cloneMap(map);
    m.remove(key);
    return m;
  }

  static public <A, B> Map<A, B> mapWithoutKey(A key, Map<A, B> map) {
    return mapWithoutKey(map, key);
  }

  static public RuntimeException cancelTo(CancelPoint cp) {
    if (cp.closed)
      throw fail("cancel point closed");
    throw new CancelToCancelPoint(cp);
  }

  static public boolean md5OfFile_verbose = false;

  static public String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  static public String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object dm_getModule(Object moduleOrID) {
    if (moduleOrID == null || eq(moduleOrID, ""))
      return null;
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      return dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_callOS("getDynModuleByID", str(moduleOrID));
    return dm_resolveModule(moduleOrID);
  }

  static public Map<String, String> parseDoubleArrowMapCI_tlft(String s) {
    return parseDoubleArrowMapCI(tlft(s));
  }

  static public List<String> ai_splitCamelCase(String s) {
    int j = 0;
    List<String> l = new ArrayList();
    if (isAllUpperCase(s)) {
      l.add(s);
      return l;
    }
    for (int i = 0; i < l(s); i++) if (i > j && isUpperCaseLetter(s.charAt(i))) {
      l.add(substring(s, j, i));
      j = i;
    }
    if (j < l(s))
      l.add(substring(s, j));
    return l;
  }

  static public void deleteConcept(long id) {
    db_mainConcepts().deleteConcept(id);
  }

  static public void deleteConcept(Concepts concepts, long id) {
    concepts.deleteConcept(id);
  }

  static public void deleteConcept(Concept c) {
    if (c != null)
      c.delete();
  }

  static public void deleteConcept(Concept.Ref ref) {
    if (ref != null)
      deleteConcept(ref.get());
  }

  static public <A> String replaceAngleBracketVars(String s, Map<String, A> map) {
    return empty(map) ? s : join(replaceAngleBracketVars(javaTokWithAngleBrackets(s), map));
  }

  static public <A> List<String> replaceAngleBracketVars(List<String> tok, Map<String, A> map) {
    return replaceAngleBracketVars(tok, map, null);
  }

  static public <A> List<String> replaceAngleBracketVars(List<String> tok, Map<String, A> map, BitSet replacedTokens_out) {
    if (empty(map))
      return tok;
    tok = cloneList(tok);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (isAngleBracketed(t)) {
        A t2 = map.get(t);
        if (t2 == null)
          t2 = map.get(deAngleBracket(t));
        if (t2 != null) {
          tok.set(i, str(t2));
          bitSetSet(replacedTokens_out, i);
        }
      }
    }
    return tok;
  }

  static public String replaceAngleBracketVars(String s, Object... params) {
    return replaceAngleBracketVars(s, paramsToMap(params));
  }

  static public boolean loadBufferedImageFixingGIFs_debug = false;

  static public ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

  static public Image loadBufferedImageFixingGIFs(File file) {
    try {
      if (!file.exists())
        return null;
      if (!isGIF(file))
        return ImageIO.read(file);
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": checking gif");
      ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
      reader.setInput(ImageIO.createImageInputStream(file));
      int numImages = reader.getNumImages(true);
      IIOMetadata imageMetaData = reader.getImageMetadata(0);
      String metaFormatName = imageMetaData.getNativeMetadataFormatName();
      boolean foundBug = false;
      for (int i = 0; i < numImages && !foundBug; i++) {
        IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
        int nNodes = root.getLength();
        for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
            String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
            if (Integer.parseInt(delay) == 0) {
              foundBug = true;
            }
            break;
          }
        }
      }
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
      Image image;
      if (!foundBug) {
        image = Toolkit.getDefaultToolkit().createImage(f2s(file));
      } else {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        {
          ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
          try {
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; i++) {
              BufferedImage frameIn = reader.read(i);
              IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
              int nNodes = root.getLength();
              for (int j = 0; j < nNodes; j++) {
                org.w3c.dom.Node node = root.item(j);
                if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
                  if (Integer.parseInt(delay) == 0) {
                    ((IIOMetadataNode) node).setAttribute("delayTime", "10");
                  }
                  break;
                }
              }
              IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
              metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
              IIOImage frameOut = new IIOImage(frameIn, null, metadata);
              writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
          } finally {
            _close(ios);
          }
        }
        byte[] data = baoStream.toByteArray();
        setVar(loadBufferedImageFixingGIFs_output.get(), data);
        if (loadBufferedImageFixingGIFs_debug)
          print("Data size: " + l(data));
        image = Toolkit.getDefaultToolkit().createImage(data);
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] litobjectarray(Object... l) {
    return litObjectArray(l);
  }

  static public Object[] muricaCredentialsPlus(Object... params) {
    return concatArrays(muricaCredentials(), params);
  }

  static public void saveBinaryFileVerbose(File f, byte[] data) {
    boolean exists = f.exists();
    saveBinaryFile(f, data);
    print((!exists ? "Created" : "Updated") + " file " + f2s(f) + " (" + f.length() + " bytes)");
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public String shortenEndTime(String endTime, String startTime) {
    int i = endTime.lastIndexOf(' ') + 1;
    if (i > 0 && eq(substring(startTime, 0, i), substring(endTime, 0, i)))
      return trim(substring(endTime, i));
    return endTime;
  }

  static public File standardLogFile() {
    return getProgramFile("log");
  }

  static public boolean isCIMap(Map m) {
    return m instanceof TreeMap && ((TreeMap) m).comparator() == caseInsensitiveComparator();
  }

  static public String ipToCountry2020_dataSnippetID = "#1400400";

  static public Lock ipToCountry2020_lock = lock();

  static public File ipToCountry2020_dataDir() {
    return javaxCachesDir("ipToCountry2020");
  }

  static public String ipToCountry2020(String ip) {
    return ipToCountry2020(ipToInt(ip));
  }

  static public String ipToCountry2020(long ipNum) {
    {
      Lock __0 = ipToCountry2020_lock;
      lock(__0);
      try {
        if (directoryEmpty(ipToCountry2020_dataDir()))
          unzipSnippet(ipToCountry2020_dataSnippetID, ipToCountry2020_dataDir());
      } finally {
        unlock(__0);
      }
    }
    String line = pairB(binarySearchForLineInTextFile(newFile(ipToCountry2020_dataDir(), "IP2LOCATION-LITE-DB1.CSV"), s -> {
      List<String> l = tok_splitAtComma_unquote(s);
      long a = parseLongOpt(first(l)), b = parseLongOpt(second(l));
      return ipNum > b ? 1 : ipNum < a ? -1 : 0;
    }));
    return get(tok_splitAtComma_unquote(line), 2);
  }

  static public JWindow showLoadingAnimation() {
    return showLoadingAnimation("Hold on user...");
  }

  static public JWindow showLoadingAnimation(String text) {
    try {
      return showAnimationInTopRightCorner("#1003543", text);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public SecretValue<String> aSecretGlobalID() {
    return secretValueOrNull(aGlobalID());
  }

  static public Object[] flattenArray2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Object[])
        l.addAll(asList((Object[]) x));
      else if (x instanceof Collection)
        l.addAll((Collection) x);
      else
        l.add(x);
    return asObjectArray(l);
  }

  static public JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public boolean dir2zip_recurse_verbose = false;

  static public int dir2zip_recurse(File inDir, File zip) {
    return dir2zip_recurse(inDir, zip, "");
  }

  static public int dir2zip_recurse(File inDir, File zip, String outPrefix) {
    try {
      mkdirsForFile(zip);
      FileOutputStream fout = newFileOutputStream(zip);
      ZipOutputStream outZip = new ZipOutputStream(fout);
      try {
        return dir2zip_recurse(inDir, outZip, outPrefix, 0);
      } finally {
        outZip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip) {
    return dir2zip_recurse(inDir, outZip, "", 0);
  }

  static public int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) {
    try {
      if (++level >= 20)
        throw fail("woot? 20 levels in zip?");
      List<File> files = new ArrayList();
      for (File f : listFiles(inDir)) files.add(f);
      int n = 0;
      sortFilesByName(files);
      for (File f : files) {
        if (f.isDirectory()) {
          print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
          n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
        } else {
          if (dir2zip_recurse_verbose)
            print("Copying " + f.getName());
          outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
          InputStream fin = new FileInputStream(f);
          copyStream(fin, outZip);
          fin.close();
          ++n;
        }
      }
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String curly(String s) {
    return optionalCurlyBrace(s);
  }

  static public String dropFirstLine(String text) {
    if (text == null)
      return null;
    int i = text.indexOf('\n');
    return i >= 0 ? text.substring(i + 1) : "";
  }

  static public Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

  static public Rectangle defaultNewFrameBounds() {
    return swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          defaultNewFrameBounds_r.translate(60, 20);
          if (!screenRectangle().contains(defaultNewFrameBounds_r))
            defaultNewFrameBounds_r.setLocation(30 + random(30), 20 + random(20));
          return new Rectangle(defaultNewFrameBounds_r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "defaultNewFrameBounds_r.translate(60, 20);\r\n    if (!screenRectangle().contai...";
      }
    });
  }

  static public String angleBracket(String s) {
    return "<" + s + ">";
  }

  static public List<String> scoredSearch_prepare(String query) {
    return map(__92 -> replacePlusWithSpace(__92), splitAtSpace(query));
  }

  static public String nMessages(long n) {
    return n2(n, "message");
  }

  static public String nMessages(Collection l) {
    return nMessages(l(l));
  }

  static public Concept cnew(String name, Object... values) {
    return cnew(db_mainConcepts(), name, values);
  }

  static public Concept cnew(Concepts concepts, String name, Object... values) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    Concept c;
    try {
      c = cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
    csetAll(c, values);
    concepts.register(c);
    return c;
  }

  static public <A extends Concept> A cnew(Class<A> cc, Object... values) {
    return cnew(db_mainConcepts(), cc, values);
  }

  static public <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
    concepts_unlisted.set(true);
    A c;
    try {
      c = nuObject(cc);
    } finally {
      concepts_unlisted.set(null);
    }
    csetAll(c, values);
    concepts.register(c);
    return c;
  }

  static public <A> Set<A> setMinus(Set<A> set, Object... stuff) {
    Set s2 = cloneSet(set);
    for (Object o : stuff) s2.remove(o);
    return s2;
  }

  static public boolean serverMechList_raw_fresh_verbose = false;

  static public String serverMechList_raw_fresh(String name) {
    return serverMechList_raw_fresh(name, false);
  }

  static public String serverMechList_raw_fresh(String name, boolean opt) {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      String text = null;
      try {
        text = loadTextFile(remoteMechListMirrorFile(name));
      } catch (Throwable __e) {
        _handleException(__e);
      }
      Object[] params = muricaCredentialsPlus("md5", md5OrNull(text), "l", l(text), "opt", opt ? 1 : 0, "withStatus", 1);
      String url = "http://butter.botcompany.de:8080/mech/raw/list-text/" + urlencode(name);
      String page = postPageSilently(url, params);
      Map map = jsonDecodeMap(page);
      boolean same = eq(map.get("Same"), true);
      boolean appended = eq(map.get("Appended"), true);
      saveTextFile(remoteMechListMirrorMetaFile(name), struct(getMultipleKeys(map, "Name", "Status")));
      if (!same) {
        if (appended)
          text += (String) map.get("Text");
        else
          text = (String) map.get("Text");
        saveTextFile(remoteMechListMirrorFile(name), text);
        File nameFile = remoteMechListMirrorNameFile(name);
        if (!fileExists(nameFile)) {
          String actualName = or((String) map.get("Name"), name);
          saveTextFile(nameFile, actualName);
        }
      }
      if (serverMechList_raw_fresh_verbose)
        print("Mech list " + name + ": " + (appended ? "appended" : same ? "same" : "downloaded") + ": " + n2(countLines(text), "line"));
      if (!same)
        vmBus_send("remoteMechListMirrorChanged", name);
      return text;
    } finally {
      unlock(__0);
    }
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public void unzipSnippet(String snippetID, File toDir) {
    print("Unzipping snippet " + snippetID + " to " + toDir);
    zip2dir(loadLibrary(snippetID), toDir);
  }

  static public String renderStructs(Object... params) {
    List<String> l = new ArrayList();
    if (odd(l(params)))
      l.add(addSuffix(str(first(params)), ":"));
    for (int i = l(params) & 1; i + 1 < l(params); i += 2) l.add(params[i] + "=" + sfu(params[i + 1]));
    return joinWithSpace(l);
  }

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isAbsolutePath(snippetIDOrURLOrFile))
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
      if (!isSnippetID(snippetIDOrURLOrFile))
        throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
      String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return loadBufferedImage(rl.loadLibrary(snippetID));
      File dir = imageSnippetsCacheDir();
      if (loadBufferedImage_useImageCache) {
        dir.mkdirs();
        File file = new File(dir, snippetID + ".png");
        if (file.exists() && file.length() != 0)
          try {
            return ImageIO.read(file);
          } catch (Throwable e) {
            e.printStackTrace();
          }
      }
      String imageURL = snippetImageURL_http(snippetID);
      print("Loading image: " + imageURL);
      BufferedImage image = imageIO_readURL(imageURL);
      if (loadBufferedImage_useImageCache) {
        File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
        ImageIO.write(image, "png", tempFile);
        tempFile.renameTo(new File(dir, snippetID + ".png"));
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    return loadBufferedImageFile(file);
  }

  static public String reversedString(String s) {
    return reverseString(s);
  }

  static public int parseFirstInt(String s) {
    return parseInt(jextract("<int>", s));
  }

  static public int parseFirstInt(Iterable<String> l) {
    return parseInt(firstIntegerString(l));
  }

  static public LayoutManager layoutManagerFromFunction(final Object layouter) {
    return new AbstractLayoutManager() {

      public void layoutContainer(Container parent) {
        Object size = pcallF(layouter, parent);
        if (size instanceof Dimension)
          preferredSize = (Dimension) size;
        else if (size instanceof Pair) {
          preferredSize = (Dimension) ((Pair) size).a;
          minimumSize = (Dimension) ((Pair) size).b;
        }
      }
    };
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getQueryFromURL(String url) {
    return dropAfterSubstring(substring(url, smartIndexOf(url, "?") + 1), "#");
  }

  static public AutoCloseable dm_enter(Object mod) {
    return (AutoCloseable) callOpt(dm_getModule(mod), "enter");
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource) {
    return hotwire_finish(classLoader, progID, javaSource, "main");
  }

  static public Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource, String mainClass) {
    try {
      Class<?> theClass = classLoader.loadClass(mainClass);
      Class j = getJavaX();
      setOpt(theClass, "myJavaSource_code", javaSource);
      synchronized (j) {
        call(j, "setVars", theClass, progID);
        callOpt(j, "addInstance", progID, theClass);
      }
      hotwire_copyOver(theClass);
      vmBus_send("hotwireFinished", theClass, mc());
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      vmBus_send("locking", lock, "thread", currentThread());
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      vmBus_send("locked", lock, "thread", currentThread());
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A extends Concept> A uniqCI_returnIfNew(Class<A> c, Object... params) {
    Pair<A, Boolean> p = uniqCI2(c, params);
    return p.b ? p.a : null;
  }

  static public <A extends Concept> A uniqCI_returnIfNew(Concepts cc, Class<A> c, Object... params) {
    Pair<A, Boolean> p = uniqCI2(cc, c, params);
    return p.b ? p.a : null;
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public Runnable toRunnable(final Object o) {
    if (o instanceof Runnable)
      return (Runnable) o;
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public String digitsOnly(String s) {
    return filterChars(__93 -> isDigit(__93), s);
  }

  static public <A extends JComponent> A renameSubmitButton(A form, String newName) {
    renameButton(form, showFormSubmitButtonName(), newName);
    return form;
  }

  static public <A extends JComponent> A renameSubmitButton(String newName, A form) {
    return renameSubmitButton(form, newName);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> Map<A, String> trimValues(Map<A, String> map) {
    Map map2 = similarEmptyMap(map);
    for (A key : keys(map)) map2.put(key, trim(map.get(key)));
    return map2;
  }

  static public String joinLines(List<String> lines) {
    return fromLines(lines);
  }

  static public String joinLines(String glue, String text) {
    return join(glue, toLines(text));
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public HashSet<String> allClasses_keywords = lithashset("class", "interface", "enum", "sclass", "sinterface", "record", "srecord", "strecord", "asclass", "concept");

  static public List<List<String>> allClasses(List<String> tok) {
    List<List<String>> l = new ArrayList();
    int n = tok.size();
    HashSet<String> _allClasses_keywords = allClasses_keywords;
    for (int i = 1; i < n; i += 2) {
      String t = tok.get(i);
      if ("{".equals(t))
        i = findEndOfBlock(tok, i) - 1;
      else if (_allClasses_keywords.contains(t) && (tok_isJavaxMetaCommandLeftOf(tok, i) || !(eqGetOneOf(tok, i - 2, ".", "include") && !containsNewLine(tok.get(i - 1))))) {
        int j = i;
        while (j < n && !tok.get(j).equals("{")) j += 2;
        j = findEndOfBlock(tok, j) + 1;
        i = leftScanModifiers(tok, i);
        l.add(subList(tok, i - 1, Math.min(n, j)));
        i = j - 2;
      }
    }
    return l;
  }

  static public List<List<String>> allClasses(String text) {
    return allClasses(javaTok(text));
  }

  static public List<String> javaTokWithAllBrackets(String s) {
    return javaTokPlusBrackets2(s);
  }

  static public String hhmm() {
    return hhmm(now());
  }

  static public String hhmm(long time) {
    return new SimpleDateFormat("HHmm").format(time);
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String getServerTranspiled(String snippetID) {
    return getServerTranspiled(snippetID, null);
  }

  static public boolean getServerTranspiled_printStackTrace = false;

  static public String getServerTranspiled(String snippetID, String expectedMD5) {
    try {
      if (getServerTranspiled_printStackTrace)
        printStackTrace();
      long id = parseSnippetID(snippetID);
      String text = loadPage_utf8(tb_mainServer() + "/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1" + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "") + standardCredentials());
      if (nempty(text) && neq(text, "SAME"))
        saveTranspiledCode(snippetID, text);
      return text;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setFieldToIVF1Proxy(Object o, String field, IVF1 target) {
    setFieldToSingleMethodProxy(o, field, target, "get");
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public ThreadLocal<Boolean> dataToTable_useStruct = threadLocalWithDefault(true);

  static public void dataToTable_dynSet(List l, int i, Object s) {
    while (i >= l.size()) l.add("");
    l.set(i, s);
  }

  static public List dataToTable_makeRow(Object x, List<String> cols) {
    if (instanceOf(x, "DynamicObject"))
      x = get_raw(x, "fieldValues");
    if (x instanceof Map) {
      Map m = (Map) x;
      List row = new ArrayList();
      for (Object _field : keysWithoutHidden(m)) {
        String field = (String) _field;
        Object value = m.get(field);
        int col = cols.indexOf(field);
        if (col < 0) {
          cols.add(field);
          col = cols.size() - 1;
        }
        dataToTable_dynSet(row, col, dataToTable_wrapValue(value));
      }
      return row;
    }
    if (x instanceof List)
      return allToString((List) x);
    return litlist(structureOrText(x));
  }

  static public Object dataToTable_wrapValue(Object o) {
    if (o instanceof BufferedImage)
      return o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof RGBImage)
      return o;
    if (o instanceof Boolean)
      return o;
    return dataToTable_useStruct.get() ? structureOrTextForUser(o) : strOrNull(o);
  }

  static public String renderColonProperties(Map map) {
    return formatColonProperties(map);
  }

  static public <A, B> String renderColonProperties(List<Pair<A, B>> l) {
    return formatColonProperties(l);
  }

  static public <A> A syncGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    synchronized (l) {
      return idx < l(l) ? l.get(idx) : null;
    }
  }

  static public <A, B> B syncGet(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.get(a);
    }
  }

  static public void failIfOddCount(Object... list) {
    if (odd(l(list)))
      throw fail("Odd list size: " + list);
  }

  static public void indexConceptFieldDesc(Class<? extends Concept> c, String field) {
    indexConceptFieldDesc(db_mainConcepts(), c, field);
  }

  static public void indexConceptFieldDesc(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndexDesc(concepts, c, field);
  }

  static public <A extends Concept> List<A> cdelete(Class<A> c, Object... params) {
    return deleteConcepts(c, params);
  }

  static public void cdelete(Concept c) {
    deleteConcept(c);
  }

  static public <A extends Concept> void cdelete(Collection<A> c) {
    for (A a : cloneList(c)) cdelete(a);
  }

  static public <A, B> List<B> mapWithIndexStartingAt1(Collection<A> l, IF2<Integer, A, B> f) {
    int n = l(l), i = 0;
    List<B> out = emptyList(n);
    for (A a : unnullForIteration(l)) out.add(f.get(++i, a));
    return out;
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  static public RootPaneContainer getPossiblyInternalFrame(Component c) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      return f;
    return optCast(RootPaneContainer.class, getWindow(c));
  }

  static public byte[] takeFirstOfByteArray(byte[] b, int n) {
    return subByteArray(b, 0, n);
  }

  static public byte[] takeFirstOfByteArray(int n, byte[] b) {
    return takeFirstOfByteArray(b, n);
  }

  static public boolean subBot_isHttps() {
    Object httpd = subBot_httpd();
    return eqOneOf(httpd, getOpt(mainBot(), "serveHttps_server"), getOpt(mainBot(), "serveHttpsWithWebsockets_server")) || contains((Collection) getOpt(mainBot(), "serveHttpsWithWebsockets_multiplePorts_servers"), httpd);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public String spaces(int n) {
    return rep(' ', n);
  }

  static public File actualUserDir() {
    return new File(actualUserHome());
  }

  static public File actualUserDir(String path) {
    return new File(actualUserHome(), path);
  }

  static public List<String> sortedIgnoreCase(Collection<String> c) {
    List<String> l = cloneList(c);
    Collections.sort(l, caseInsensitiveComparator());
    return l;
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public JPanel jrightAlignedLine(final Component... components) {
    return swing(new F0<RightAlignedLine>() {

      public RightAlignedLine get() {
        try {
          return new RightAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret RightAlignedLine(components);";
      }
    });
  }

  static public JPanel jrightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(asArray(Component.class, components));
  }

  static public boolean flexMatchIC_iterate_debug = false;

  static public boolean flexMatchIC_iterate_useTokenization = true;

  static public void flexMatchIC_iterate(String pat, String input, VF1<Matches> onMatch, Object... __) {
    if (flexMatchIC_iterate_debug)
      print("flexMatchIC_iterate " + pat + " / " + input);
    IF1<String, List<String>> tokenizer = optPar("tokenizer", __, __1 -> javaTokNPunctuation_plusAsterisk(__1));
    flexMatchIC_iterate(pat, callTokenizer(tokenizer, pat), callTokenizer(tokenizer, input), onMatch, __);
  }

  static public void flexMatchIC_iterate(String pat, List<String> tokPat, List<String> tokInput, VF1<Matches> onMatch, Object... __) {
    List<Integer> varIndices = flexMatchIC_getVarIndices(tokPat, tokInput);
    if (varIndices == null)
      return;
    if (flexMatchIC_iterate_debug)
      printStructs("varIndices", varIndices, "tokPat", tokPat, "tokInput", tokInput);
    IterableIterator<List<String>> spreadInputs = ai_spreadCertainIndices_2_iterator(tokPat, tokInput, varIndices);
    for (List<String> tok : spreadInputs) {
      if (flexMatchIC_iterate_debug)
        print("Testing spread " + sfu(codeTokens(tokPat)) + " with input: " + sfu(codeTokens(tok)));
      Matches m = new Matches();
      if (flexMatchIC_iterate_useTokenization ? match3(tokPat, tok, m) : match(pat, tok, m)) {
        if (flexMatchIC_iterate_debug)
          print("Got match: " + m);
        callF(onMatch, m);
      }
    }
  }

  static public String hjs_markRowMagic(Object... __) {
    String color = optPar("color", __, "#99f");
    return hjs(replaceDollarVars("\r\n    var rowMagic_hash = window.location.hash.substr(1);\r\n    if (rowMagic_hash)\r\n      $(\"a[name=\" + rowMagic_hash + \"]\").closest('tr').css({ 'background-color' : '$color'});\r\n  ", "color", color));
  }

  static public <A> Set<A> synchroSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchroSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(DoubleRect r) {
    if (r == null)
      return null;
    int x = iround(r.x), y = iround(r.y);
    return new Rect(x, y, iround(r.x2()) - x, iround(r.y2()) - y);
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public String snippetLink(String id) {
    return empty(id) ? id : snippetLink(parseSnippetID(id));
  }

  static public String snippetLink(long id) {
    return "https://code.botcompany.de/" + id;
  }

  static public Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  static public HashMap<Set<String>, Class> loadFunctions_cache = new HashMap();

  static public Lock loadFunctions_cached_lock = lock();

  static public boolean loadFunctions_preferDiskCache = false;

  static public Class loadFunctions_cached(String... functions) {
    return loadFunctions_cached(asList(functions));
  }

  static public Class loadFunctions_cached(Collection<String> functions) {
    TreeSet<String> functionSet = new TreeSet<String>(functions);
    Lock __0 = loadFunctions_cached_lock;
    lock(__0);
    try {
      Class c = loadFunctions_cache.get(functionSet);
      if (c != null)
        return c;
      String transpilation = null;
      if (l(functions) == 1 && isSlowMachine()) {
        String snippetID = stdFunctions_cached().get(first(functions));
        if (nempty(snippetID)) {
          if (!isMD5(getUpToDateSnippetTranspilationMD5(snippetID)))
            print("Slow machine mode: " + snippetID + " transpilation not up to date");
          else {
            transpilation = getServerTranspiledWithoutLibs(snippetID);
            print("Loaded server transpilation: " + snippetID);
          }
        }
      }
      if (transpilation == null) {
        String cached = getTranspiledStandardFunctionsIfCached(functionSet);
        if (cached != null && (loadFunctions_preferDiskCache || standardFunctionsCacheUpToDate(functionSet)))
          transpilation = cached;
      }
      if (transpilation != null) {
        print("Loading " + joinWithPlus(functionSet));
        c = veryQuickJava_finish(transpilation, emptyList());
      }
      if (c == null)
        c = loadFunctions(functionSet);
      loadFunctions_cache.put(functionSet, c);
      assertNotNull(loadFunctions_cache.get(functionSet));
      return c;
    } finally {
      unlock(__0);
    }
  }

  static public void loadFunctions_cached_clearCache() {
    Lock __1 = loadFunctions_cached_lock;
    lock(__1);
    try {
      loadFunctions_cache.clear();
    } finally {
      unlock(__1);
    }
  }

  static public void _onLoad_loadFunctions_cached() {
    ownResource(vmBus_onMessage("refreshedTranspiler", new Runnable() {

      public void run() {
        try {
          loadFunctions_clearCache();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "loadFunctions_clearCache();";
      }
    }));
  }

  static public String formatDoubleX(double d, int digits) {
    return formatDoubleFull(d, digits);
  }

  static public Boolean not(Boolean b) {
    return b == null ? null : !b;
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  static public class SmartTimerTask extends TimerTask implements IFieldsToList {

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { r, timer, delay, threadInfo };
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __1 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__1);
        }
      }
    }
  }

  static public String p_vbar(String... items) {
    return p_vbar(asList(items));
  }

  static public String p_vbar(Collection<String> items, Object... __) {
    return pUnlessEmpty(joinNemptiesWithVBar(items), __);
  }

  static public <A> boolean setAdd(Collection<A> c, A a) {
    if (c == null || c.contains(a))
      return false;
    c.add(a);
    return true;
  }

  static public void csetIfUnset(Concept c, String field, Object value) {
    if (cget(c, field) == null)
      cset(c, field, value);
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  static public String hsubmit(String text, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "submit", "value", text }, params));
  }

  static public String hsubmit() {
    return hsubmit("Submit");
  }

  static public <A> List<A> lastTwo(List<A> l) {
    return takeLast(2, l);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable) {
    return actionListenerInNewThread(runnable, null);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          startThread("Action Listener", new Runnable() {

            public void run() {
              try {
                AutoCloseable __1 = holdInstance(instanceToHold);
                try {
                  callF(runnable);
                } finally {
                  _close(__1);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1 = holdInstance(instanceToHold); try {\r\n      callF(runnable...";
            }
          });
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public ThreadLocal<Boolean> htmlencode_forParams_useV2 = new ThreadLocal();

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    if (isTrue(htmlencode_forParams_useV2.get()))
      return htmlencode_forParams_v2(s);
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public List<Map> rawEmojisList() {
    return (List) jsonDecodeMap(loadTextFile(loadLibrary("#1400427"))).get("emojis");
  }

  static public String p_alignRight(String s, Object... params) {
    return p(s, params_stylePlus(params, "text-align: right"));
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public int maxLineCount(Collection<String> l) {
    int n = 0;
    if (l != null)
      for (String s : l) n = max(n, countLines(s));
    return n;
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public String htitle(String title) {
    return hfulltag("title", htmlencode_noQuotes(title));
  }

  static public String intToHex(int i) {
    return bytesToHex(intToBytes(i));
  }

  static public int countWords(String s) {
    return numberOfWords2(s);
  }

  static public String formatDate() {
    return formatDate(now());
  }

  static public String formatDate(long timestamp) {
    return timestamp == 0 ? "-" : str(new Date(timestamp));
  }

  static public String formatDate(long timestamp, String format, TimeZone tz) {
    return simpleDateFormat(format, tz).format(timestamp);
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public File getCanonicalFile(File f) {
    try {
      return f == null ? null : f.getCanonicalFile();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public String htmlEncode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String htmlEncode2(Object o) {
    return htmlEncode2(strOrEmpty(o));
  }

  static public boolean isStringStartingWith(Object o, String prefix) {
    return o instanceof String && ((String) o).startsWith(prefix);
  }

  static public <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  static public <A, B> List<A> pairsAWhereB(Iterable<Pair<A, B>> c, IF1<B, Boolean> pred) {
    return pairsA(filter(c, p -> pred.get(p.b)));
  }

  static public String hcss_responstable() {
    return hcss("\r\n    .responstable {\r\n      margin: 1em 0;\r\n      width: 100%;\r\n      overflow: visible;\r\n      background: #FFF;\r\n      color: #024457;\r\n      border-radius: 10px;\r\n      border: 1px solid #167F92;\r\n    }\r\n    \r\n    .responstable tr {\r\n      border: 1px solid #D9E4E6;\r\n    }\r\n    .responstable tr:nth-child(odd) {\r\n      background-color: #EAF3F3;\r\n    }\r\n    .responstable th {\r\n      display: none;\r\n      border: 1px solid #FFF;\r\n      background-color: #167F92;\r\n      color: #FFF;\r\n      padding: 1em;\r\n    }\r\n    .responstable th:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n    }\r\n    .responstable th:nth-child(2) {\r\n      display: table-cell;\r\n    }\r\n    .responstable th:nth-child(2) span {\r\n      display: none;\r\n    }\r\n    .responstable th:nth-child(2):after {\r\n      content: attr(data-th);\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th:nth-child(2) span {\r\n        display: block;\r\n      }\r\n      .responstable th:nth-child(2):after {\r\n        display: none;\r\n      }\r\n    }\r\n    .responstable td {\r\n      display: block;\r\n      word-wrap: break-word;\r\n      max-width: 7em;\r\n    }\r\n    .responstable td:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n      border-right: 1px solid #D9E4E6;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable td {\r\n        border: 1px solid #D9E4E6;\r\n      }\r\n    }\r\n    .responstable th, .responstable td {\r\n      text-align: left;\r\n      margin: .5em 1em;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th, .responstable td {\r\n        display: table-cell;\r\n        padding: 1em;\r\n      }\r\n    }\r\n  ");
  }

  static public String snippetRawURL(String snippetID) {
    return snippetRawURL(snippetID, null);
  }

  static public String snippetRawURL(String snippetID, String contentType) {
    return "https://botcompany.de/serve/" + psI(snippetID) + htmlQuery("ct", contentType);
  }

  static public Map prependEmptyOptionForHSelect(Map map) {
    Map map2 = litorderedmap("", "");
    putAll(map2, map);
    return map2;
  }

  static public String loadTextFilePossiblyGZipped(String fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
    File gz = new File(fileName + ".gz");
    return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
  }

  static public String loadTextFilePossiblyGZipped(File fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
    return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
  }

  static public JPanel showFormTitled2(String title, Object... parts) {
    return showFormTitled_customLayout(formLayouter1(), title, parts);
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public String hdiv(Object contents, Object... params) {
    return div(contents, params);
  }

  static public float getSwingFontScale() {
    return or((Float) vm_generalMap_get("swingFontScale_value"), 1f);
  }

  static public boolean match3_startOrEndOfLine(String pat, String s, boolean startOfLine, boolean endOfLine) {
    if (startOfLine)
      return endOfLine ? match3(pat, s) : matchStart(pat, s);
    else
      return endOfLine ? matchEnd(pat, s) : find3(pat, s);
  }

  static public File transpiledStandardFunctions_file(TreeSet<String> functionSet) {
    String name = uniqueFileNameUsingMD5_80_v2(join("+", functionSet));
    File dir = javaxCachesDir("Transpiled Standard Functions");
    saveTextFileUnlessExists(newFile(dir, name + ".functions"), lines(functionSet));
    return newFile(dir, name + ".java");
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static public String dropLeadingSlash(String s) {
    return dropPrefix("/", s);
  }

  static public boolean substanceLookAndFeelEnabled() {
    return startsWith(getLookAndFeel(), "org.pushingpixels.");
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> List<A> dropFirstTwoAndLastTwo(List<A> l) {
    return dropFirstAndLast(2, l);
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public String selectedItem(JList l) {
    return getSelectedItem(l);
  }

  static public String selectedItem(JComboBox cb) {
    return getSelectedItem(cb);
  }

  static public ThreadLocal<Boolean> doPost_silently = new ThreadLocal();

  static public ThreadLocal<Long> doPost_timeout = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> doPost_extraHeaders = new ThreadLocal();

  static public String doPost(String url, Map urlParameters) {
    return doPost(urlParameters, url);
  }

  static public String doPost(Map urlParameters, String url) {
    return doPost(makePostData(urlParameters), url);
  }

  static public String doPost(String urlParameters, String url) {
    try {
      URL _url = new URL(url);
      ping();
      return doPost(urlParameters, _url.openConnection(), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String doPost(String urlParameters, URLConnection conn, URL url) {
    try {
      boolean silently = isTrue(optParam(doPost_silently));
      Long timeout = optParam(doPost_timeout);
      Map<String, String> extraHeaders = optPar(doPost_extraHeaders);
      setHeaders(conn);
      for (String key : keys(extraHeaders)) {
        conn.setRequestProperty(key, extraHeaders.get(key));
      }
      int l = lUtf8(urlParameters);
      if (!silently)
        print("Sending POST request: " + hideCredentials(url) + " (" + l + " bytes)");
      if (timeout != null)
        setURLConnectionTimeouts(conn, timeout);
      ((HttpURLConnection) conn).setRequestMethod("POST");
      conn.setDoOutput(true);
      conn.setRequestProperty("Content-Length", str(l));
      OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
      writer.write(urlParameters);
      writer.flush();
      String contents = loadPage_utf8(conn, url, false);
      writer.close();
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void saveFileVerbose(File f, byte[] data) {
    saveBinaryFileVerbose(f, data);
  }

  static public <A, B> List<A> keysSortedByValuesDesc(final Map<A, B> map) {
    List<A> l = new ArrayList(map.keySet());
    sort(l, mapComparatorDesc(map));
    return l;
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  static public void addIfNempty(Collection<String> l, String s) {
    if (nempty(s))
      l.add(s);
  }

  static public void addIfNempty(Collection l, Map m) {
    if (nempty(m))
      l.add(m);
  }

  static public void addIfNempty(Collection l, Collection c) {
    if (nempty(c))
      l.add(c);
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    UnknownHostException lastException = null;
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      try {
        if (con instanceof HttpURLConnection)
          if (((HttpURLConnection) con).getResponseCode() == 500)
            throw new IOException(joinNemptiesWithColonSpace("Server code 500", tryToReadErrorStreamFromURLConnection((HttpURLConnection) con)));
        return con.getInputStream();
      } catch (UnknownHostException e) {
        lastException = e;
        print("Retrying because of: " + e);
        continue;
      }
    }
    throw lastException;
  }

  static public List<Long> allToLong(Collection l) {
    return lmap(__94 -> toLong(__94), l);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public List<Integer> allPlus(final int x, List<Integer> l) {
    return map(l, new F1<Integer, Integer>() {

      public Integer get(Integer i) {
        try {
          return i + x;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "i+x";
      }
    });
  }

  static public Comparator reverseOrder() {
    return new Comparator() {

      public int compare(Object a, Object b) {
        return cmp(b, a);
      }
    };
  }

  static public JWindow loadingAnim() {
    return showLoadingAnimation();
  }

  static public JWindow loadingAnim(String text) {
    return showLoadingAnimation(text);
  }

  static public void saveGZTextFile(File file, String contents) {
    saveGZTextFile(file, contents, "UTF-8");
  }

  static public void saveGZTextFile(File file, String contents, String encoding) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = file.getPath() + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, encoding);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public String himgsrc(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", src));
  }

  static public List<String> toLinesFullTrim_java(String text) {
    return tlft(joinLines(map(__95 -> javaDropComments(__95), tlft(text))));
  }

  static public void tok_statementToBlock(List<String> tok, int i) {
    if (neqGet(tok, i, "{")) {
      int iEnd = tok_findEndOfStatement(tok, i) - 1;
      tokAppend_reTok(tok, iEnd, " }");
      tokPrepend_reTok(tok, i, "{ ");
    }
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public Frame getAWTFrame(final Object _o) {
    return swing(new F0<Frame>() {

      public Frame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof Frame)
              return (Frame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ...";
      }
    });
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public String h1_title(String s) {
    return htitle_h1(s);
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public <A> A singleObjectMethodProxy(Class<A> intrface, Object object, String methodName) {
    return proxyFromInvocationHandler(intrface, new InvocationHandler() {

      public Object invoke(Object proxy, Method method, Object[] args) {
        String mname = method.getName();
        if (mname.equals(methodName))
          return call(object, methodName, unnull(args));
        if (mname.equals("toString"))
          return "proxy for " + methodName;
        return null;
      }
    });
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public String toLower(String s) {
    return s == null ? null : s.toLowerCase();
  }

  static public char toLower(char c) {
    return Character.toLowerCase(c);
  }

  static public JComboBox onSelectedItem(final JComboBox cb, final VF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public List<String> uniquifyAndSortAlphaNum(Collection<String> l) {
    return sortedAlphaNum(uniquify(l));
  }

  static public void print_setPrefixForThread(final String prefix) {
    interceptPrintInThisThread(empty(prefix) ? null : new _PrintIndent(prefix));
  }

  static public String hhtml_head_title_body(String title, Object bodyContents, Object... bodyParams) {
    return hhtml(hhead(htitle(title)) + "\n" + hbody(bodyContents, bodyParams));
  }

  static public <A> MultiMap<String, A> caseInsensitiveMultiMap() {
    MultiMap<String, A> mm = new MultiMap();
    mm.data = caseInsensitiveMap();
    return mm;
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public String lowestByAlphaNum(Collection<String> c) {
    String best = null;
    for (String s : unnullForIteration(c)) if (best == null || alphaNumComparator().compare(s, best) < 0)
      best = s;
    return best;
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public long recommendedTranspilationDateForStandardFunction(String sfName) {
    return toLong(mechMap("Recommended SF Transpilation Date").get(sfName));
  }

  static public int compareIC(String s1, String s2) {
    return compareIgnoreCase_jdk(s1, s2);
  }

  static public List callFAll(Collection l, Object... args) {
    return callF_all(l, args);
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public boolean newButton_autoToolTip = true;

  static public JButton newButton(final String text, final Object action) {
    return swing(new F0<JButton>() {

      public JButton get() {
        try {
          String text2 = dropPrefix("[disabled] ", text);
          final JButton btn = new JButton(text2);
          if (l(text2) < l(text))
            btn.setEnabled(false);
          if (newButton_autoToolTip) {
            btn.setToolTipText(btn.getText());
          }
          if (action != null)
            btn.addActionListener(actionListener(action, btn));
          return btn;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S text2 = dropPrefix(\"[disabled] \", text);\r\n    final JButton btn = new JButt...";
      }
    });
  }

  static public List<String> listZip(File inZip) {
    return listZipFile(inZip);
  }

  static public List<String> listZip(String inZip) {
    return listZipFile(inZip);
  }

  static public boolean match3_withIntsAndIDs(String pat, String s) {
    return match3_withIntsAndIDs(pat, s, null);
  }

  static public boolean match3_withIntsAndIDs(String pat, String s, Matches m) {
    List<String> tokPat = javaTokWithAllPlusAngleBrackets(pat);
    String pat2 = joinMap(tokPat, t -> eqOneOf(t, "<int>", "<id>") ? "*" : t);
    Matches m2 = m == null ? new Matches() : m;
    if (!match3(pat2, s, m2))
      return false;
    List<String> vars = filter(codeTokens(tokPat), t -> eqOneOf(t, "<int>", "<id>", "*"));
    for (int i = 0; i < l(vars); i++) {
      if (eq(vars.get(i), "<int>") && !isInteger(m2.get(i)) || eq(vars.get(i), "<id>") && !isIdentifier(m2.get(i)))
        return false;
    }
    return true;
  }

  static public Class<?> getClass(String name) {
    return _getClass(name);
  }

  static public Class getClass(Object o) {
    return _getClass(o);
  }

  static public Class getClass(Object realm, String name) {
    return _getClass(realm, name);
  }

  static public <A> A objectWhere(Collection<A> c, Object... data) {
    return findWhere(c, data);
  }

  static public boolean isAbsolutePath(String s) {
    return s != null && new File(s).isAbsolute();
  }

  static public boolean isAbsolutePath(File f) {
    return f != null && f.isAbsolute();
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public <A> A findWhere(Collection<A> c, Object... data) {
    if (c != null)
      for (A x : c) if (checkFields(x, data))
        return x;
    return null;
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public String hbuttonOnClick(String text, String onClick, Object... params) {
    return hfulltag("button", text, paramsPlus(params, "onClick", onClick));
  }

  static public String stream2string(InputStream in) {
    return utf8streamToString(in);
  }

  static public String urlWithoutQueryAndAnchor(String url) {
    return takeFirst(url, min(smartIndexOf(url, "?"), smartIndexOf(url, "#")));
  }

  static public ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  static public void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  static public boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public String dm_moduleLibID() {
    return programID() + "/" + shortClassName(dm_current_mandatory_generic());
  }

  static public String dm_moduleLibID(Object mod) {
    if (mod == null)
      return null;
    mod = dm_getModule(mod);
    if (hasSuperclassShortNamed(mod, "DynModule"))
      return programID(mod) + "/" + shortClassName(mod);
    return null;
  }

  static public List<String> allToUpper(Collection<String> l) {
    List<String> x = new ArrayList(l(l));
    if (l != null)
      for (String s : l) x.add(upper(s));
    return x;
  }

  static public String hhiddenWithIDAndName(String idAndName) {
    return hhiddenWithIDAndName(idAndName, null);
  }

  static public String hhiddenWithIDAndName(String idAndName, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", idAndName, "name", idAndName, "value", value));
  }

  static public byte[] raf_readFilePart(RandomAccessFile raf, long start, int l) {
    try {
      byte[] buf = new byte[l];
      raf.seek(start);
      raf.readFully(buf);
      return buf;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<File> myLibraryFiles() {
    return asList((Collection<File>) get(myClassLoader(), "files"));
  }

  static public boolean neqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return false;
    return true;
  }

  static public <A> A firstThat(Iterable<A> l, Object pred) {
    if (l != null)
      for (A a : l) if (checkCondition(pred, a))
        return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return a;
    return null;
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, (Object) pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
    if (empty(params))
      return list;
    List<A> l = new ArrayList();
    for (A x : list) if (checkConceptFields(x, params))
      l.add(x);
    return l;
  }

  static public String dropTranslators(String src) {
    return findTranslators2(src, null);
  }

  static public List<String> dropTranslators(List<String> tok) {
    return findTranslators2(tok, null);
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public ClassLoader getClassLoaderOrSame(Object o) {
    return o instanceof ClassLoader ? (ClassLoader) o : getClassLoader(o);
  }

  static public Object dm_resolveModule(Object moduleOrStem) {
    return dm_callOS("resolveModule", moduleOrStem);
  }

  static public <A, B> boolean containsKey(Map<A, B> map, A key) {
    return map != null && map.containsKey(key);
  }

  static public List<String> dropHTMLComments(List<String> tok) {
    List<String> l = new ArrayList();
    for (int idx = 0; idx < l(tok); idx++) {
      String t = tok.get(idx);
      if (even(idx)) {
        int i;
        while ((i = t.indexOf("<!--")) >= 0) {
          int j = smartIndexOf(t, "-->", i + 4);
          t = substring(t, 0, i) + substring(t, j + 3);
        }
      }
      l.add(t);
    }
    return l;
  }

  static public Map<String, Pair<String, Map<String, String>>> mechHashMap_cache = synchroMap();

  static public Map<String, String> mechHashMap(String listName) {
    Pair<String, Map<String, String>> p = mechHashMap_cache.get(listName);
    String text = mechList_raw(listName);
    if (p != null && eq(p.a, text))
      return p.b;
    String parsing = first(mechList_opt(listName + " | Parsing"));
    p = pair(text, (Map<String, String>) (parsing != null ? asHashMap((Map<String, String>) callAndMake(parsing, text)) : parseDoubleArrowMap(new HashMap(), tlft(text))));
    mechHashMap_cache.put(listName, p);
    return p.b;
  }

  static public void tok_transpileIfQuoted_dollarVars(List<String> tok) {
    jreplace_dyn(tok, "if <quoted>", new F2<List<String>, Integer, String>() {

      public String get(List<String> tok, Integer cIdx) {
        try {
          String pat = unquote(tok.get(cIdx + 2));
          List<String> vars = new ArrayList();
          String pat2 = dollarVarsToStars(pat, vars);
          int iCurly = cIdx + 4;
          tok_statementToBlock(tok, iCurly);
          tokAppend_reTok(tok, iCurly, joinWithSpace(mapWithIndexStartingAt1(vars, (i, var) -> ("S " + var + " = $" + i + ";"))));
          return ("if (match(" + (quote(pat2)) + ", s, m))");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S pat = unquote(tok.get(cIdx+2));\r\n    new LS vars;\r\n    S pat2 = dollarVarsT...";
      }
    }, new TokCondition() {

      public boolean get(final List<String> tok, final int i) {
        return containsDollarVars(unquote(tok.get(i + 3)));
      }
    });
  }

  static public boolean containsATextArea(Component c) {
    return childOfType(c, JTextArea.class) != null;
  }

  static public boolean vmBus_noObjections(String msg, Object... args) {
    return !vmBus_anyFalse(msg, args);
  }

  static public Object vmGeneralMap_get(Object key) {
    return vm_generalMap_get(key);
  }

  static public boolean isSymLink(File f) {
    return f != null && Files.isSymbolicLink(toPath(f));
  }

  static public String jsonEncode(Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode(o, buf);
    return str(buf);
  }

  static public void jsonEncode(Object o, StringBuilder buf) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode(map.get(key), buf);
      }
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        jsonEncode(element, buf);
      }
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public boolean regexpMatches(String pat, String s) {
    return pat != null && s != null && regexp(pat, s).matches();
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public <A> A replaceIfEquals(A a, A b, A c) {
    return replaceIfEqual(a, b, c);
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  static public String mechList_opt_raw_fresh(String name) {
    Object readMode = mechMode().readMode;
    if (readMode instanceof File) {
      String md5Name = uniqueFileNameUsingMD5_80_v2(upper(name));
      return loadTextFileFromZipFile((File) readMode, md5Name);
    }
    boolean useLocal = false, useRemote = true;
    if (eq(readMode, "mergeLocalAndRemote"))
      useLocal = true;
    else if (eq(readMode, "local")) {
      useLocal = true;
      useRemote = false;
    }
    String s = "";
    if (useRemote) {
      if (eq(mechMode().readMode, "localCopies"))
        s = unnull(loadTextFile(remoteMechListMirrorFile(name)));
      else
        s = serverMechList_raw_fresh(name, true);
    }
    if (useLocal)
      s = appendNewLineIfNempty(s) + localMechList_opt_raw_fresh(name);
    return s;
  }

  static public boolean confirmOKCancel(final Component owner, final String msg) {
    return isTrue(swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return JOptionPane.showConfirmDialog(owner, msg, "JavaX", JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret JOptionPane.showConfirmDialog(owner,\r\n      msg, \"JavaX\", JOptionPane.OK_...";
      }
    }));
  }

  static public boolean confirmOKCancel(String msg) {
    return confirmOKCancel(null, msg);
  }

  static public String structureOrTextForUser(Object o) {
    return o == null ? "" : o instanceof String ? (String) o : structureForUser(o);
  }

  static public <A> List<A> sortedByField(Collection<A> c, final String field) {
    List<A> l = new ArrayList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(getOpt(a, field), getOpt(b, field));
      }
    });
    return l;
  }

  static public <A> List<A> sortedByField(String field, Collection<A> c) {
    return sortedByField(c, field);
  }

  static public Type getRawType(Type t) {
    if (t instanceof ParameterizedType)
      return ((ParameterizedType) t).getRawType();
    return t;
  }

  static public boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  static public void retireClassLoader(ClassLoader cl) {
    if (isJavaXClassLoader(cl))
      setOptAll(cl, "retired", true, "retiredMarker", new DefunctClassLoader());
  }

  static public byte[] isGIF_magic = bytesFromHex("47494638");

  static public boolean isGIF(byte[] data) {
    return byteArrayStartsWith(data, isGIF_magic);
  }

  static public boolean isGIF(File f) {
    return isGIF(loadBeginningOfBinaryFile(f, l(isGIF_magic)));
  }

  static public JFrame getFrame(final Object _o) {
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JFrame)
              return (JFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A> A dm_evalInQ(F0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), f);
  }

  static public <A> A dm_evalInQ(IF0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), if0ToF0(f));
  }

  static public <A> A dm_evalInQ(DynModule module, F0<A> f) {
    return evalInQ(module.q(), f);
  }

  static public List<String> words2(String s) {
    List<String> l = new ArrayList();
    int n = l(s);
    for (int i = 0; i < n; ) {
      int j = i;
      while (j < n && isLetterOrDigit(s.charAt(j))) ++j;
      if (j > i)
        l.add(substring(s, i, j));
      while (j < n && !isLetterOrDigit(s.charAt(j))) ++j;
      i = j;
    }
    return l;
  }

  static public String joinNemptiesWithVBar(String... strings) {
    return joinNempties(" | ", strings);
  }

  static public String joinNemptiesWithVBar(Collection<String> strings) {
    return joinNempties(" | ", strings);
  }

  static public SimpleLiveValue dm_fieldLiveValue(String fieldName) {
    return dm_fieldLiveValue(dm_current_mandatory(), fieldName);
  }

  static public SimpleLiveValue dm_fieldLiveValue(final DynModule module, final String fieldName) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      AutoCloseable __2 = module.enter();
      try {
        Class type = getFieldType(module, fieldName);
        final SimpleLiveValue value = new SimpleLiveValue(type, get(module, fieldName));
        dm_watchField(fieldName, new Runnable() {

          public void run() {
            try {
              Object o = get(module, fieldName);
              value.set(o);
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting \" + fi...";
          }
        });
        value.onChange(new Runnable() {

          public void run() {
            try {
              module.setField(fieldName, value.get());
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting 2 \" + ...";
          }
        });
        return value;
      } finally {
        _close(__2);
      }
    } finally {
      unlock(__0);
    }
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public Class veryQuickJava_finish(String src, List<String> libs) {
    libs = cloneList(libs);
    src = findTranslators2(src, libs);
    String dehlibs = join(" ", libs);
    File bytecode = null;
    bytecode = javaCompile_overInternalBot(src, dehlibs);
    return hotwireCore(concatLists(ll(bytecode), loadLibraries(libs)));
  }

  static public <A> void addInFront(List<A> c, A a) {
    addFirst(c, a);
  }

  static public List<String> splitAtComma(String s) {
    return empty(s) ? emptyList() : asList(s.split(","));
  }

  static public List<File> findAllFiles_noDirs(List dirs) {
    return findAllFiles_noDirs(asObjectArray(dirs));
  }

  static public List<File> findAllFiles_noDirs(Object... dirs) {
    List<File> l = new ArrayList();
    for (Object dir : dirs) {
      ping();
      if (dir instanceof String && ((String) dir).endsWith("/.")) {
        for (File f : listFiles(dropSuffix("/.", ((String) dir)))) {
          ping();
          if (f.isFile())
            l.add(f);
        }
      } else
        findAllFiles_noDirs_impl(toFile(dir), l);
    }
    return l;
  }

  static public void findAllFiles_noDirs_impl(File dir, List<File> l) {
    for (File f : listFiles(dir)) {
      ping();
      if (f.isDirectory())
        findAllFiles_noDirs_impl(f, l);
      else
        l.add(f);
    }
  }

  static public Object callAndMake(String functionName, Object... args) {
    return callAndMake_orDirect(functionName, args);
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public <A> List<A> uniquifyList(Collection<A> l) {
    if (l == null)
      return null;
    if (l(l) < 2)
      return asList(l);
    HashSet<A> set = new HashSet();
    List<A> out = new ArrayList();
    for (A a : l) if (set.add(a))
      out.add(a);
    return out;
  }

  static public String htextinput(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "text", "name", name, "value", value }, params));
  }

  static public String htextinput(String name) {
    return htextinput(name, "");
  }

  static public <A> A setAll(A o, Map<String, Object> fields) {
    if (fields == null)
      return o;
    for (String field : keys(fields)) set(o, field, fields.get(field));
    return o;
  }

  static public <A> A setAll(A o, Object... values) {
    failIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      set(o, field, value);
    }
    return o;
  }

  static public String processID_cached;

  static public String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  static public String[] conceptFields_drop = { "className", "fieldValues", "id", "created", "_modified", "refs", "backRefs", "_concepts" };

  static public Set<String> conceptFields(Concept c) {
    return setMinus(mergeSets(allNonStaticNonTransientFields(c), keys(c.fieldValues)), conceptFields_drop);
  }

  static public Set<String> conceptFields(Class<? extends Concept> c) {
    return setMinus(allNonStaticNonTransientFields(c), conceptFields_drop);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  static public Object[] litparams(Object... l) {
    int n = 0, n1 = l(l);
    for (int i = 0; i < n1; i += 2) if (l[i] != null && l[i + 1] != null)
      ++n;
    if (n == 0)
      return null;
    Object[] params = new Object[n * 2];
    int j = 0;
    for (int i = 0; i < n1; i += 2) {
      Object key = l[i], value = l[i + 1];
      if (key != null && value != null) {
        params[j++] = key;
        params[j++] = value;
      }
    }
    return params;
  }

  static public int lUtf8(String s) {
    return l(utf8(s));
  }

  static public Runnable runnableThread(final Runnable r) {
    return new Runnable() {

      public void run() {
        try {
          startThread(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startThread(r)";
      }
    };
  }

  static public <A extends JComponent> A toolTip(A c, final Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A toolTip(Object toolTip, A c) {
    return setToolTipText(toolTip, c);
  }

  static public IF1<String, Boolean> swic$(String prefix) {
    return s -> swic(s, prefix);
  }

  static public File localMechListsDir() {
    return javaxDataDir("Mech Lists");
  }

  static public Object subBot_serveHTML(Object html) {
    return subBot_serveWithContentType(str(html), "text/html");
  }

  static public String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public int indexOf_byteArray(byte[] a, byte b) {
    int n = l(a);
    for (int i = 0; i < n; i++) if (a[i] == b)
      return i;
    return -1;
  }

  static public Map<String, java.util.regex.Pattern> compileRegexpIC_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexpIC(String pat) {
    java.util.regex.Pattern p = compileRegexpIC_cache.get(pat);
    if (p == null) {
      try {
        compileRegexpIC_cache.put(pat, p = java.util.regex.Pattern.compile(pat, Pattern.CASE_INSENSITIVE));
      } catch (PatternSyntaxException e) {
        throw rethrow(wrapPatternSyntaxException(e));
      }
    }
    return p;
  }

  static public TreeMap litcimap(Object... x) {
    return litCIMap(x);
  }

  static public Runnable rCallOnSelectedListItem(final JList list, final Object action) {
    return new Runnable() {

      public void run() {
        try {
          pcallF(action, getSelectedItem(list));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(action, getSelectedItem(list))";
      }
    };
  }

  static public Font typeWriterFont() {
    return typeWriterFont(iround(14 * getSwingFontScale()));
  }

  static public Font typeWriterFont(int size) {
    return new Font("Courier", Font.PLAIN, size);
  }

  static public List<WeakReference<Class>> hotwire_classes = synchroList();

  static public Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  static public List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  static public class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  static public CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  static public void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  static public File programSecretFile(String progID, String fileName) {
    return secretProgramFile(progID, fileName);
  }

  static public File programSecretFile(String fileName) {
    return secretProgramFile(fileName);
  }

  static public String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  static public <A> List<A> reverseList(List<A> l) {
    Collections.reverse(l);
    return l;
  }

  static public <A extends Window> A disposeWindowAfter(int delay, final A w) {
    if (w != null)
      swingLater(delay, new Runnable() {

        public void run() {
          try {
            w.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.dispose();";
        }
      });
    return w;
  }

  static public <A extends Window> A disposeWindowAfter(A w, double seconds) {
    return disposeWindowAfter(toMS_int(seconds), w);
  }

  static public <A extends Window> A disposeWindowAfter(double seconds, A w) {
    return disposeWindowAfter(w, seconds);
  }

  static public List<String> tok_combineCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "{")) {
        int j = findEndOfCurlyBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Long> asList(long[] a) {
    if (a == null)
      return null;
    ArrayList<Long> l = emptyList(a.length);
    for (long i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterator<A> it) {
    ArrayList l = new ArrayList();
    if (it != null)
      while (it.hasNext()) l.add(it.next());
    return l;
  }

  static public <A> ArrayList<A> asList(IterableIterator<A> s) {
    return asList((Iterator) s);
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A> ArrayList<A> asList(ReverseChain<A> c) {
    return c == null ? emptyList() : c.toList();
  }

  static public <A> List<A> asList(Pair<A, A> p) {
    return p == null ? null : ll(p.a, p.b);
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    dynamicObject_setRawFieldValue(o, field, value);
  }

  static public Runnable wrapAsActivity(Object r) {
    if (r == null)
      return null;
    Runnable r2 = toRunnable(r);
    Object mod = dm_current_generic();
    if (mod == null)
      return r2;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable c = (AutoCloseable) (rcall("enter", mod));
          AutoCloseable __1 = c;
          try {
            r2.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "AutoCloseable c =  (AutoCloseable) (rcall enter(mod));\r\n    temp c;\r\n    r2.r...";
      }
    };
  }

  static public void saveTextFileUnlessExists(File f, String contents) {
    if (f != null && !f.exists())
      saveTextFile(f, contents);
  }

  static public File remoteMechListMirrorFile(String listName) {
    return newFile(remoteMechListMirrorsDir(), uniqueFileNameUsingMD5_80_v2(upper(listName)));
  }

  static public <A> List<A> concatLists_conservative(List<A> a, List<A> b) {
    if (empty(a))
      return b;
    if (empty(b))
      return a;
    return concatLists(a, b);
  }

  static public <A> List<A> concatLists_conservative(Collection<A> a, Collection<A> b) {
    if (empty(a) && b instanceof List)
      return ((List) b);
    if (empty(b) && a instanceof List)
      return ((List) a);
    return concatLists(a, b);
  }

  static public String neatMechListURL(String listName) {
    return "http://botcompany.de/mech/raw/list/" + urlencode(listName);
  }

  static public String unicode_leftPointingTriangle() {
    return unicodeFromCodePoint(0x25C2);
  }

  static public <A> String joinWithSemicolon(Iterable<A> l) {
    return join("; ", l);
  }

  static public String html_evaluateIfTags(String html, IF1<String, Boolean> pred) {
    List<String> tok = htmlTok(html);
    boolean anyChange = false;
    while (true) {
      ping();
      List<String> ifTag = first(findContainerTag(tok, "if"));
      if (ifTag == null)
        break;
      anyChange = true;
      int iElse = indexOfIC(ifTag, "<else>");
      boolean val = pred.get(htmlTagFullParamString(second(ifTag)));
      if (val) {
        if (iElse >= 0)
          clearTokens(ifTag, iElse, l(ifTag) - 2);
      } else {
        clearTokens(ifTag, 2, iElse < 0 ? l(ifTag) - 2 : iElse + 1);
      }
      clearToken(ifTag, 1);
      clearToken(ifTag, l(ifTag) - 2);
    }
    return anyChange ? join(tok) : html;
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public String getServerTranspiledWithoutLibs(String snippetID) {
    return dropFirstLine(getServerTranspiled2(snippetID));
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public boolean isProperlyQuoted(String s) {
    return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"") && (!s.endsWith("\\\"") || s.endsWith("\\\\\"")) && !containsNewLine(s);
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public JWindow showInTopRightCorner(Component c) {
    return swing(() -> {
      JWindow w = new JWindow();
      w.add(c);
      w.pack();
      moveToTopRightCorner(w);
      w.setVisible(true);
      return w;
    });
  }

  static public <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
    if (l == null)
      return new ArrayList();
    synchronized (mutex) {
      return new ArrayList<A>(l);
    }
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A> List<A> padList(List<A> l, int w) {
    return padList(l, w, null);
  }

  static public <A> List<A> padList(List<A> l, int w, A a) {
    if (l(l) >= w)
      return l;
    List<A> x = cloneList(l);
    while (l(x) < w) x.add(a);
    return x;
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public <A, B> void mapPut_noOverwrite(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null && !map.containsKey(key))
      map.put(key, value);
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public String postPageSilently(String url, Object... params) {
    return doPostSilently(litmap(params), url);
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public <A, B> HashMap<A, B> asHashMap(Map<A, B> map) {
    if (map != null && map.getClass() == HashMap.class)
      return (HashMap) map;
    HashMap<A, B> m = new HashMap(l(map));
    if (map != null)
      m.putAll(map);
    return m;
  }

  static public <A> void listSet(List<A> l, int i, A a, A emptyElement) {
    if (i < 0)
      return;
    while (i >= l(l)) l.add(emptyElement);
    l.set(i, a);
  }

  static public <A> void listSet(List<A> l, int i, A a) {
    listSet(l, i, a, null);
  }

  static public void deleteDirectory(File dir) {
    deleteDirectory(dir, false, false);
  }

  static public void deleteDirectory(File dir, boolean verbose, boolean testRun) {
    deleteAllFilesInDirectory(dir, verbose, testRun);
    if (verbose)
      print((testRun ? "Would delete " : "Deleting ") + dir.getAbsolutePath());
    if (!testRun)
      dir.delete();
  }

  static public boolean fileNempty(File f) {
    return fileNotEmpty(f);
  }

  static public void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public void removeLast(List l) {
    if (!l.isEmpty())
      l.remove(l(l) - 1);
  }

  static public void removeLast(List l, int n) {
    removeSubList(l, l(l) - n);
  }

  static public void removeLast(int n, List l) {
    removeLast(l, n);
  }

  static public List<Concept> allBackRefs(Concept c) {
    IdentityHashMap<Concept, Boolean> l = new IdentityHashMap();
    if (c != null && c.backRefs != null)
      for (Concept.Ref r : cloneList(c.backRefs)) l.put(r.concept(), true);
    return keysList(l);
  }

  static public JComponent getInternalFrameTitlePaneComponent(JInternalFrame f) {
    return (JComponent) childWithClassNameEndingWith(f, "InternalFrameTitlePane");
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
    pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public String unparseCSSParameter(Map<String, String> map) {
    return joinWithSemicolon(map(map, new F2<String, String, String>() {

      public String get(String key, String value) {
        try {
          return key + ": " + value;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "key + \": \" + value";
      }
    }));
  }

  static public <A> Set<A> mergeSets(Collection<A>... l) {
    return joinSets(l);
  }

  static public Object endMarker() {
    return iteratorFromFunction_endMarker;
  }

  static public <A> A copyFields(Object x, A y, String... fields) {
    if (empty(fields)) {
      Map<String, Object> map = objectToMap(x);
      for (String field : map.keySet()) setOpt(y, field, map.get(field));
    } else
      for (String field : fields) {
        Object o = getOpt(x, field);
        if (o != null)
          setOpt(y, field, o);
      }
    return y;
  }

  static public <A> A copyFields(Object x, A y, Collection<String> fields) {
    return copyFields(x, y, asStringArray(fields));
  }

  static public Object serveJSON(Object... data) {
    return serveJSON_shallowLineBreaks(jsonPrepareData(data));
  }

  static public Object dm_getStem(Object moduleOrID) {
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      moduleOrID = dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_getStemByID(moduleOrID);
    return or(getOpt(dm_getModule(moduleOrID), "_host"), moduleOrID);
  }

  static public Object iteratorFromFunction_endMarker = new Object();

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = callF(f);
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
    return iteratorFromFunction_withEndMarker_f0(f);
  }

  static public <A> Collection<A> asCollection(Iterable<A> l) {
    return l == null ? null : l instanceof Collection ? ((Collection) l) : asList(l);
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public String hselect_list(String name, Collection<String> entries, Object... params) {
    return hselect_list(entries, paramsPlus_skipFirst(params, "name", name));
  }

  static public String hselect_list(Collection<String> entries, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(entries))
      for (String k : entries) {
        String value = k;
        boolean isSelected = eq(selected, k);
        buf.append(hfulltag("option", htmlencode(str(or(value, ""))), "value", k, "selected", isSelected ? html_valueLessParam() : null)).append("\n");
      }
    return hfulltag("select", buf, params) + "\n";
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public List<String> words(String s) {
    return codeTokens(dropPunctuation(javaTok(s)));
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public F0<AutoCloseable> dm_rEnter() {
    return dm_rEnter(dm_current());
  }

  static public F0<AutoCloseable> dm_rEnter(DynModule mod) {
    return mod == null ? null : new F0<AutoCloseable>() {

      public AutoCloseable get() {
        try {
          return mod.enter();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mod.enter();";
      }
    };
  }

  static public Runnable dm_rEnter(Runnable r) {
    return dm_rEnter(dm_current(), r);
  }

  static public Runnable dm_rEnter(DynModule mod, Runnable r) {
    return mod == null || r == null ? r : new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = mod.enter();
          try {
            r.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp mod.enter(); r.run();";
      }
    };
  }

  static public Pair<LongRange, String> binarySearchForLineInTextFile(File file, IF1<String, Integer> nav) {
    long length = l(file);
    int bufSize = 1024;
    RandomAccessFile raf = randomAccessFileForReading(file);
    try {
      long min = 0, max = length;
      int direction = 0;
      Pair<LongRange, String> possibleResult = null;
      while (min < max) {
        ping();
        long middle = (min + max) / 2;
        long lineStart = raf_findBeginningOfLine(raf, middle, bufSize);
        long lineEnd = raf_findEndOfLine(raf, middle, bufSize);
        String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (lineEnd - 1 - lineStart)));
        direction = nav.get(line);
        possibleResult = pair(new LongRange(lineStart, lineEnd), line);
        if (direction == 0)
          return possibleResult;
        if (direction < 0)
          max = assertLessThan(max, lineStart);
        else
          min = assertBiggerThan(min, lineEnd);
      }
      if (direction >= 0)
        return possibleResult;
      long lineStart = raf_findBeginningOfLine(raf, min - 1, bufSize);
      String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (min - 1 - lineStart)));
      return pair(new LongRange(lineStart, min), line);
    } finally {
      _close(raf);
    }
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String getTextTrim(JTextComponent c) {
    return trim(getText(c));
  }

  static public String getTextTrim(JComboBox cb) {
    return trim(getText(cb));
  }

  static public String getTextTrim(JComponent c) {
    if (c instanceof JLabel)
      return trim(((JLabel) c).getText());
    if (c instanceof JComboBox)
      return getTextTrim((JComboBox) c);
    return getTextTrim((JTextComponent) c);
  }

  static public String javaDropComments(String s) {
    return javaDropAllComments(s);
  }

  static public String linesPreservingTrailingNewLine(String original, List<String> lines) {
    String s = lines(lines);
    return endsWith(original, "\n") ? s : dropSuffix("\n", s);
  }

  static public boolean loadLibraryOrSrcLib_srcLibsEnabled = true;

  static public ThreadLocal<Map<Long, File>> loadLibraryOrSrcLib_tempCache = new ThreadLocal();

  static public File loadLibraryOrSrcLib(String snippetID) {
    try {
      vmBus_send("loadLibraryOrSrcLib", snippetID);
      long id = parseSnippetID(snippetID);
      if (loadLibraryOrSrcLib_tempCache.get() != null) {
        File f = loadLibraryOrSrcLib_tempCache.get().get(id);
        if (f != null) {
          print(snippetID + " from tempCache: " + f);
          return f;
        }
      }
      boolean srcLib = loadLibraryOrSrcLib_srcLibsEnabled && isMarkedAsSrcLib(snippetID);
      if (srcLib) {
        print(snippetID + " marked as src lib, compiling");
        File f = pairA(hotwire_compile(snippetID));
        mapPut(loadLibraryOrSrcLib_tempCache.get(), id, f);
        return f;
      }
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) != 0) {
        print(snippetID + " from disk cache: " + f);
        return f;
      }
      try {
        print("Trying " + snippetID + " as binary library");
        return loadDataSnippetToFile(snippetID);
      } catch (Throwable e) {
        if (loadLibraryOrSrcLib_srcLibsEnabled) {
          print("Trying " + snippetID + " as src lib");
          if (nempty(loadSnippet(snippetID))) {
            print("Is src lib.");
            markAsSrcLib(snippetID);
            return pairA(hotwire_compile(snippetID));
          }
        }
        throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> List<A> sortedByFieldIC(Collection<A> c, final String field) {
    List<A> l = new ArrayList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return compareIC((String) getOpt(a, field), (String) getOpt(b, field));
      }
    });
    return l;
  }

  static public <A> List<A> sortedByFieldIC(String field, Collection<A> c) {
    return sortedByFieldIC(c, field);
  }

  static public String dropAfterSlash(String s) {
    if (s == null)
      return null;
    int i = s.indexOf('/');
    return i < 0 ? s : rtrim(substring(s, 0, i));
  }

  static public String timeInTimeZone(String timeZone) {
    return timeInTimeZone(timeZone, now());
  }

  static public String timeInTimeZone(String timeZone, long time) {
    return simpleDateFormat_timeZone("HH:mm", timeZone).format(time);
  }

  static public String timeInTimeZone(TimeZone timeZone, long time) {
    return simpleDateFormat("HH:mm", timeZone).format(time);
  }

  static public <A> List<A> listMinus(Collection<A> l, Object... stuff) {
    if (l == null)
      return null;
    List l2 = similarEmptyList(l);
    Set set = lithashset(stuff);
    for (Object o : l) if (!set.contains(o))
      l2.add(o);
    return l2;
  }

  static public String localMechList_opt_raw_fresh(String name) {
    return unnull(loadTextFile(localMechListFile(name)));
  }

  static public List<String> dropAllTags(List<String> tok) {
    List<String> list = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && t.startsWith("<")) {
        list.set(list.size() - 1, list.get(list.size() - 1) + tok.get(i + 1));
        ++i;
      } else
        list.add(t);
    }
    return list;
  }

  static public String dropAllTags(String html) {
    return join(dropAllTags(htmlcoarsetok(html)));
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }

  static public String phraseToRegExp(String b) {
    return (startsWithLetterOrDigit(b) ? "\\b" : "") + regexpQuote(b) + (endsWithLetterOrDigit(b) ? "\\b" : "");
  }

  static public String fieldNameForConceptLink(Concept from, Concept to) {
    for (Pair<Concept.Ref, String> p : scanConceptForRefsWithFieldNames(from)) if (derefRef(p.a) == to)
      return p.b;
    return null;
  }

  static public void saveTranspiledCode(String progID, String code) {
    File dir = getCodeProgramDir(progID);
    new File(dir, "Transpilation").delete();
    saveGZTextFile(new File(dir, "Transpilation.gz"), code);
  }

  static public Object[] onlyNonNullParams(Object... params) {
    List out = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) if (params[i] != null && params[i + 1] != null) {
      out.add(params[i]);
      out.add(params[i + 1]);
    }
    return toObjectArray(out);
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public Object jsonDecode(String text) {
    return new jsonDecode_Y(text).parse();
  }

  static public class jsonDecode_Y {

    public String text;

    public List<String> tok;

    public boolean useOrderedMaps = false;

    public int i = 1;

    public jsonDecode_Y(String text) {
      this.text = text;
      tok = jsonTok(text);
    }

    transient public IF1<String, RuntimeException> fail;

    public RuntimeException fail(String msg) {
      return fail != null ? fail.get(msg) : fail_base(msg);
    }

    final public RuntimeException fail_fallback(IF1<String, RuntimeException> _f, String msg) {
      return _f != null ? _f.get(msg) : fail_base(msg);
    }

    public RuntimeException fail_base(String msg) {
      return utils.fail(msg);
    }

    public Object parse() {
      if (l(tok) == 1)
        return null;
      return parseExpr();
    }

    public Object parseExpr() {
      String t = tok.get(i);
      if (t.startsWith("\"") || t.startsWith("'")) {
        String s = unquote(tok.get(i));
        i += 2;
        return s;
      }
      if (t.equals("{"))
        return parseMap();
      if (t.equals("["))
        return this.parseList();
      if (t.equals("null")) {
        i += 2;
        return null;
      }
      if (t.equals("false")) {
        i += 2;
        return false;
      }
      if (t.equals("true")) {
        i += 2;
        return true;
      }
      boolean minus = false;
      if (t.equals("-")) {
        minus = true;
        i += 2;
        t = get(tok, i);
      }
      if (isInteger(t)) {
        int j = i;
        i += 2;
        if (eqOneOf(get(tok, i), ".", "e", "E")) {
          while (isInteger(get(tok, i)) || eqOneOf(get(tok, i), ".", "e", "E", "-")) i += 2;
          double d = parseDouble(joinSubList(tok, j, i - 1));
          if (minus)
            d = -d;
          return d;
        } else {
          long l = parseLong(t);
          return boxedIntOrLong(minus ? -l : l);
        }
      }
      throw fail("Unknown token " + (i + 1) + ": " + t + ": " + text);
    }

    public Object parseList() {
      consume("[");
      List list = new ArrayList();
      while (!tok.get(i).equals("]")) {
        list.add(parseExpr());
        if (tok.get(i).equals(","))
          i += 2;
      }
      consume("]");
      return list;
    }

    public Object parseMap() {
      consume("{");
      Map map = useOrderedMaps ? new LinkedHashMap() : new TreeMap();
      while (!tok.get(i).equals("}")) {
        String key = unquote(tok.get(i));
        i += 2;
        consume(":");
        Object value = parseExpr();
        map.put(key, value);
        if (tok.get(i).equals(","))
          i += 2;
      }
      consume("}");
      return map;
    }

    public void consume(String s) {
      if (!tok.get(i).equals(s)) {
        String prevToken = i - 2 >= 0 ? tok.get(i - 2) : "";
        String nextTokens = join(tok.subList(i, Math.min(i + 4, tok.size())));
        throw fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");
      }
      i += 2;
    }
  }

  static public <A, B> Map<A, List<B>> multiMapToMap(MultiMap<A, B> m) {
    return m == null ? null : m.data;
  }

  static public boolean jInternalFrame_iconifiable = true;

  static public JInternalFrame jInternalFrame() {
    return jInternalFrame("");
  }

  static public JInternalFrame jInternalFrame(final String title) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame_iconifiable);
          f.setVisible(true);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame...";
      }
    });
  }

  static public <A, B> void addPair(Collection<Pair<A, B>> c, A a, B b) {
    if (c != null)
      c.add(pair(a, b));
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public Class javax() {
    return getJavaX();
  }

  static public Cache<MultiMap<String, CountryDialCode>> countryDialCodes_rawNumbersTreeMultiMap_cache = new Cache<>(() -> countryDialCodes_rawNumbersTreeMultiMap_load());

  static public MultiMap<String, CountryDialCode> countryDialCodes_rawNumbersTreeMultiMap() {
    return countryDialCodes_rawNumbersTreeMultiMap_cache.get();
  }

  static public MultiMap<String, CountryDialCode> countryDialCodes_rawNumbersTreeMultiMap_load() {
    return mapToMultiMap(mapKeys(__96 -> digitsOnly(__96), multiMapToMap(countryDialCodesMultiMap())));
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public String beforeColonOrAll(String s) {
    return takeFirst(smartIndexOf(s, ':'), s);
  }

  static public String copyToClipboard(String text) {
    return copyTextToClipboard(text);
  }

  static public <A extends Image> A copyToClipboard(A image) {
    copyImageToClipboard(image);
    return image;
  }

  static public File copyToClipboard(File f) {
    return copyFileToClipboard(f);
  }

  static public Scorer scorerWithSuccessesAndErrors() {
    Scorer scorer = new Scorer();
    scorer.successes = new ArrayList();
    scorer.errors = new ArrayList();
    return scorer;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public String hhiddenMulti(Object... params) {
    return mapPairsToLines(paramsToPairs(params), (k, v) -> hhidden(str(k), v));
  }

  static public void fixACCInClassLoader(Object o) {
    try {
      AccessControlContext acc = vm_globalACC();
      if (acc != null)
        replaceACCInClassLoader(o, acc);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public String toK_str(long l) {
    return str_toK(l);
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public boolean eq(Symbol a, String b) {
    return eq(str(a), b);
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public <A extends JComponent> A applyDefaultMargin(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMarg...";
        }
      });
    }
    return c;
  }

  static public boolean containsSpaces(String s) {
    return indexOf(s, ' ') >= 0;
  }

  static public boolean conceptsWithFieldGreaterThan_verbose = false;

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Class<A> c, String field, Object value) {
    return conceptsWithFieldGreaterThan(db_mainConcepts(), c, field, value);
  }

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Concepts concepts, Class<A> c, String field, Object value) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc)
      return ((ConceptFieldIndexDesc) index).objectsWithValueGreaterThan(value);
    if (conceptsWithFieldGreaterThan_verbose)
      print("conceptsWithFieldGreaterThan: table scan of " + c + " for field " + field);
    return objectsWhereFieldGreaterThan(concepts.list(c), field, value);
  }

  static public Map<String, String> parseDoubleLeftArrowMap(Map<String, String> map, List<String> l) {
    for (String s : l) {
      List<String> x = splitAtDoubleLeftArrow(s);
      if (l(x) == 2)
        map.put(second(x), first(x));
    }
    return map;
  }

  static public <A, B> boolean eitherIsA(Either<A, B> e) {
    return e != null && e.isA();
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public String hinlinepostform(Object contents, Object... __) {
    return hpostform(contents, params_stylePlus(__, "display: inline"));
  }

  static public <A, B> boolean eitherIsB(Either<A, B> e) {
    return e != null && e.isB();
  }

  static public String dropSlashPrefix(String s) {
    return dropLeadingSlash(s);
  }

  volatile static public boolean conceptsAndBot_running = false;

  static public boolean conceptsAndBot_thinOnStart = true;

  static public void conceptsAndBot() {
    conceptsAndBot(null);
  }

  static public void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    Concepts cc = db_mainConcepts();
    try {
      if (cc.useFileLock) {
        if (!cc.fileLock().tryToLock()) {
          ensureDBNotRunning(dbBotStandardName());
          cc.fileLock().forceLock();
        }
      } else
        ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable _e) {
      cc.dontSave = true;
      throw rethrow(_e);
    }
    cc.persist(autoSaveInterval);
    dbBot(false);
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public Object dm_callOS(String functionName, Object... args) {
    return call(dm_os(), functionName, args);
  }

  static public List<String> tok_splitAtComma(String s) {
    return tok_splitAtComma(javaTok(s));
  }

  static public List<String> tok_splitAtComma(List<String> tok) {
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(joinSubList(tok, i + 1, j - 1));
      i = j;
    }
    return out;
  }

  static public boolean isDirectory(File f) {
    return f != null && f.isDirectory();
  }

  static public boolean isDirectory(String path) {
    return path != null && isDirectory(newFile(path));
  }

  static public String hform(Object contents, Object... params) {
    return htag("form", contents, params);
  }

  static public String loadTextFileFromZip(File inZip, String fileName) {
    return loadTextFileFromZipFile(inZip, fileName);
  }

  static public <A> String pnlToStringWithEmptyLines_rtrim(Iterable<A> l) {
    return rtrim(pnlToStringWithEmptyLines(l));
  }

  static public String h1(String s, Object... params) {
    return hfulltag("h1", s, params);
  }

  static public String h2(String s, Object... params) {
    return tag("h2", s, params);
  }

  static public String h3(String s, Object... params) {
    return tag("h3", s, params) + "\n";
  }

  static public int snippetType_javaxModule() {
    return 54;
  }

  static public void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  static public void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  static public Random random_random = new Random();

  static public int random(int n) {
    return random(random_random, n);
  }

  static public int random(int n, Random r) {
    return random(r, n);
  }

  static public int random(Random r, int n) {
    return n <= 0 ? 0 : r.nextInt(n);
  }

  static public double random(double max) {
    return random() * max;
  }

  static public double random() {
    return random_random.nextInt(100001) / 100000.0;
  }

  static public double random(double min, double max) {
    return min + random() * (max - min);
  }

  static public int random(int min, int max) {
    return min + random(max - min);
  }

  static public int random(int min, int max, Random r) {
    return random(r, min, max);
  }

  static public int random(Random r, int min, int max) {
    return min + random(r, max - min);
  }

  static public <A> A random(List<A> l) {
    return oneOf(l);
  }

  static public <A> A random(Collection<A> c) {
    if (c instanceof List)
      return random((List<A>) c);
    int i = random(l(c));
    return collectionGet(c, i);
  }

  static public int random(IntRange r) {
    return random(r.start, r.end);
  }

  static public <A, B> Pair<A, B> random(Map<A, B> map) {
    return entryToPair(random(entries(map)));
  }

  static public String trimSubstring(String s, int x) {
    return trim(substring(s, x));
  }

  static public String trimSubstring(String s, int x, int y) {
    return trim(substring(s, x, y));
  }

  static public String trimSubstring(String s, IntRange r) {
    return trim(substring(s, r));
  }

  static public String trimSubstring(int x, String s) {
    return trimSubstring(s, x);
  }

  static public RandomAccessFile newRandomAccessFile(File path, String mode) {
    try {
      boolean forWrite = mode.indexOf('w') >= 0;
      if (forWrite)
        mkdirsForFile(path);
      RandomAccessFile f = new RandomAccessFile(path, mode);
      callJavaX("registerIO", f, path, forWrite);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public Map mapKeyAndFunction(Iterable l, Object f) {
    return mapKeyAndFunction(f, l);
  }

  static public Map mapKeyAndFunction(Object f, Iterable l) {
    HashMap map = new HashMap();
    if (l != null)
      for (Object o : l) map.put(o, callF(f, o));
    return map;
  }

  static public <A, B, C> Map<A, C> mapKeyAndFunction(Map<A, B> map, IF2<A, B, C> f) {
    HashMap map2 = new HashMap();
    if (map != null)
      for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
        A key = __0.getKey();
        B value = __0.getValue();
        map2.put(key, callF(f, key, value));
      }
    return map2;
  }

  static public <A, B> Map<A, B> mapKeyAndFunction(Iterable<A> l, IF1<A, B> f) {
    return mapKeyAndFunction(f, l);
  }

  static public String md5OrNull(String s) {
    return s == null ? null : md5(s);
  }

  static public <A, B> Map<A, B> syncWeakHashMap() {
    return newWeakHashMap();
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public String hmp3upload(Object... params) {
    return hfileupload(paramsPlus(params, "accept", mp3mimeType()));
  }

  static public String insertString(String a, int idx, String b) {
    return spliceString(a, idx, idx, b);
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public void logQuotedWithDate(String s) {
    logQuotedWithTime(s);
  }

  static public void logQuotedWithDate(String logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public void logQuotedWithDate(File logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public int snippetType_javaxSource() {
    return 34;
  }

  static public boolean interruptThread_verbose = false;

  static public void interruptThread(Thread t) {
    if (t == null)
      return;
    if (interruptThread_verbose)
      print("Interrupting thread " + t);
    vm_threadInterruptionReasonsMap().put(t, getStackTrace());
    t.interrupt();
    URLConnection c = (URLConnection) (vm_generalSubMap("URLConnection per thread").get(t));
    if (c != null) {
      try {
        print("Closing URLConnection of interrupted thread.");
        call(c, "disconnect");
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public String rcall_string(String method, Object o, Object... args) {
    return (String) rcall(method, o, args);
  }

  static public String simpleSpaces_javaTok(String s) {
    return join(simpleSpaces(javaTok(s)));
  }

  static public String dbProgramID() {
    return getDBProgramID();
  }

  static public int getPreferredWidth(Component c) {
    return preferredWidth(c);
  }

  static public JInternalFrame minInternalFrameWidth(final JInternalFrame frame, final int w) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (frame != null && frame.getWidth() < w)
              frame.setSize(w, frame.getHeight());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frame != null && frame.getWidth() < w)\r\n      frame.setSize(w, frame.getH...";
        }
      });
    }
    return frame;
  }

  static public JInternalFrame minInternalFrameWidth(int w, JInternalFrame frame) {
    return minInternalFrameWidth(frame, w);
  }

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public void sendMailThroughScript(String senderInfo, String from, String to, String subject, String text) {
    List<String> l = splitAt(senderInfo, "#");
    if (l(l) != 2)
      throw fail("Bad mail sender info");
    String url = first(l), pw = second(l);
    print("Sending mail through " + url);
    print("From: " + from);
    print("To: " + to);
    print("Subject: " + subject);
    print("Text:");
    printIndent("> ", text);
    assertStartsWith("OK", postPage(url, "pw", pw, "from", from, "to", to, "subject", subject, "text", text));
  }

  static public String loadSnippetSilently(Snippet s) {
    return loadSnippetQuietly(s);
  }

  static public String loadSnippetSilently(String snippetID) {
    return loadSnippetQuietly(snippetID);
  }

  static public List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Object[] paramsWithout(Object[] a1, Object... keys) {
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapMinus((Map) a1[0], keys) };
    Set set = lithashset(keys);
    List l = new ArrayList();
    int n = l(a1);
    for (int i = 0; i < n; i += 2) if (i == n - 1)
      l.add(a1[i]);
    else if (!set.contains(a1[i])) {
      l.add(a1[i]);
      l.add(a1[i + 1]);
    }
    return toObjectArray(l);
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public Map synchroHashMap() {
    return synchronizedMap(new HashMap());
  }

  static public String defaultBotName() {
    return getProgramTitle() + ".";
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public File conceptsFile(String progID) {
    return getProgramFile(progID, conceptsFileName());
  }

  static public File conceptsFile() {
    return conceptsFile(dbProgramID());
  }

  static public TreeSet<String> toCaseInsensitiveSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, x);
    return set;
  }

  static public Class hotwireCore(List<File> files) {
    try {
      JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
      Class<?> theClass = classLoader.loadClass("main");
      setOpt(theClass, "__javax", getJavaX());
      if (getOpt(theClass, "programID") == null)
        setOpt(theClass, "programID", "#3999999");
      if (!_inCore())
        hotwire_copyOver(theClass);
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A returnOrThrow_either(Either<A, Throwable> e) {
    if (isEitherB(e))
      throw rethrow(e.b());
    return eitherAOpt(e);
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public String loadTextFileOrCreateWithRandomID(File f) {
    String id = trim(loadTextFile(f));
    if (empty(id))
      saveTextFile(f, id = aGlobalID());
    return id;
  }

  static public String dropFrom(String s, String x) {
    if (s == null)
      return null;
    int i = s.indexOf(x);
    if (i < 0)
      return s;
    return substring(s, 0, i);
  }

  static public String hr() {
    return tag("hr");
  }

  static public Object dm_call(Object moduleOrID, String method, Object... args) {
    Object mod = dm_getModule(moduleOrID);
    if (mod == null)
      return null;
    AutoCloseable __1 = dm_enter(mod);
    try {
      return call_withVarargs(mod, method, args);
    } finally {
      _close(__1);
    }
  }

  static public File javaxCodeDir_dir;

  static public File javaxCodeDir() {
    return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
  }

  static public File javaxCodeDir(String sub) {
    return newFile(javaxCodeDir(), sub);
  }

  static public String systemHashCodeHex(Object o) {
    return intToHex(identityHashCode(o));
  }

  static public String hcrud_imagePreviewStyle() {
    return "max-width: 200px; max-height: 100px; width: auto; height: auto";
  }

  static public String appendQueryToURL(String url, Map params) {
    if (url == null)
      return null;
    String data = makePostData(params);
    if (empty(data))
      return url;
    int idx = smartIndexOf(url, '#');
    String url2 = takeFirst(url, idx);
    return url2 + (url2.contains("?") ? "&" : "?") + data + substring(url, idx);
  }

  static public String appendQueryToURL(String url, Object... data) {
    return appendQueryToURL(url, paramsToMap(data));
  }

  static public int findEndOfCurlyBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eq(cnc.get(j), "{"))
        ++level;
      else if (eq(cnc.get(j), "}"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public List<String> dm_moduleIDs() {
    return dm_listModuleIDs();
  }

  static public ThreadLocal<Long> saveTiming_last = new ThreadLocal();

  static public void saveTiming(long ms) {
    print(ms + " ms");
    saveTiming_noPrint(ms);
  }

  static public void saveTiming_noPrint(long ms) {
    saveTiming_last.set(ms);
  }

  static public ThreadLocal<Long> saveTiming_tl() {
    return saveTiming_last;
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public <A> Set<A> cloneSet(Collection<A> set) {
    if (set == null)
      return new HashSet();
    synchronized (collectionMutex(set)) {
      Set<A> s = similarEmptySet(set);
      s.addAll(set);
      return s;
    }
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public boolean eqic_unnull(String a, String b) {
    return eqic(unnull(a), unnull(b));
  }

  static public String hcss_linkColorInherit() {
    return hcss("a { color: inherit; }");
  }

  static public float clamp(float x, float a, float b) {
    return x < a ? a : x > b ? b : x;
  }

  static public double clamp(double x, double a, double b) {
    return x < a ? a : x > b ? b : x;
  }

  static public int clamp(int x, int a, int b) {
    return x < a ? a : x > b ? b : x;
  }

  static public long clamp(long x, long a, long b) {
    return x < a ? a : x > b ? b : x;
  }

  static public List<String> splitAtDoubleLeftArrow(String s) {
    return splitAtDoubleLeftArrow(javaTok(s));
  }

  static public List<String> splitAtDoubleLeftArrow(List<String> tok) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, ll("<", "", "="), i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + 3;
    }
    return l;
  }

  static public String binaryMimeType() {
    return "application/octet-stream";
  }

  static public String hTitleClean(String title) {
    return htmldecode(dropTagsAndHTMLComments(title));
  }

  static public boolean isSubstanceLAF() {
    return substanceLookAndFeelEnabled();
  }

  static public int calcHeight(int w, int h, int newWidth) {
    return iround(doubleRatio(h, w) * newWidth);
  }

  static public String html_showLineFeedsForPRE(String html) {
    return replace(html, "\n", unicode_newLineArrow() + "\n");
  }

  static public String lower(String s) {
    return s == null ? null : s.toLowerCase();
  }

  static public char lower(char c) {
    return Character.toLowerCase(c);
  }

  static public File getSecretProgramDir() {
    return getSecretProgramDir(actualProgramID());
  }

  static public File getSecretProgramDir(String snippetID) {
    if (empty(snippetID))
      return javaxSecretDir();
    return newFile(javaxSecretDir(), formatSnippetID(snippetID));
  }

  static public String loadTextFile_trim(String fileName) {
    return trim(loadTextFile(fileName));
  }

  static public String loadTextFile_trim(File f, String defaultContents) {
    return trim(loadTextFile(f, defaultContents));
  }

  static public String loadTextFile_trim(File fileName) {
    return trim(loadTextFile(fileName));
  }

  static public String loadTextFile_trim(String fileName, String defaultContents) {
    return trim(loadTextFile(fileName, defaultContents));
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public Object safeUnstructure(File f) {
    return safeUnstructureGZFile(f);
  }

  static public void moveFile(File a, File b) {
    if (!renameFile(a, b))
      throw fail("File move failed: " + a + " to " + b);
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public <A> StringTree2<A> stringTree2_javaTok(Map<String, A> entries) {
    StringTree2<A> tree = new StringTree2();
    for (String key : keys(entries)) addToStringTree(tree, javaTokC(key), entries.get(key));
    return tree;
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateListWithIndex(Collection<A> l) {
    return iterateListWithIndex(l, 0);
  }

  static public <A> IterableIterator<Pair<Integer, A>> iterateListWithIndex(Collection<A> l, int startAt) {
    return iff(new Object() {

      public Iterator it = iterator(l);

      public int i = startAt;

      public Object get() {
        if (!it.hasNext())
          return endMarker();
        return pair(i++, it.next());
      }
    });
  }

  static public Object dm_getService(String serviceName) {
    return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().startsWith("this$"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public String hpasswordfield(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "password", "name", name, "value", value }, params));
  }

  static public String hpasswordfield(String name) {
    return hpasswordfield(name, "");
  }

  static public boolean isInstanceOf(Object o, Class type) {
    return type.isInstance(o);
  }

  static public String orEmptyQuotes(String s) {
    return or2(s, "\"\"");
  }

  static public boolean isMarkedAsSrcLib(String snippetID) {
    if (snippetID == null)
      return false;
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return isJavaxCompilableSnippetType(rl.getSnippetType(snippetID));
    return fileExists(javaxCodeDir("srclibs/" + psI(snippetID)));
  }

  static public JTextField standardTextFieldPopupMenu(final JTextField tf) {
    final WeakReference<JTextField> ref = weakRef(tf);
    componentPopupMenuItem(tf, "Copy text to clipboard", new Runnable() {

      public void run() {
        try {
          copyTextToClipboard(ref.get().getText());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "copyTextToClipboard(ref.get().getText())";
      }
    });
    componentPopupMenuItem(tf, "Paste", new Runnable() {

      public void run() {
        try {
          ref.get().paste();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ref.get().paste()";
      }
    });
    return tf;
  }

  static public Dimension componentsBoundingSize(Container container, int insetBottomRight) {
    Rectangle r = new Rectangle(0, 0, 0, 0);
    for (Component c : container.getComponents()) r = rectangleUnion(r, c.getBounds());
    return new Dimension(r.x + r.width + insetBottomRight, r.y + r.height + insetBottomRight);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
    return lambdaMap(f, l);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
    return lambdaMap(f, l);
  }

  static public void cleanKill() {
    cleanKillVM();
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      return loadDataSnippetToFile_noResourceLoader(snippetID);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadDataSnippetToFile_noResourceLoader(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htmlTagFullParamString(String tag) {
    int i = indexOfSpaceEtc(tag);
    return trimSubstring(i, dropSuffix(">", tag));
  }

  static public List<String> splitAtMinus(String s) {
    return trimAll(asList(s.split("\\-")));
  }

  static public String ahref_undecorated(String link, Object contents, Object... params) {
    return ahref_unstyled(link, contents, params);
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public Map<String, String> parseDoubleArrowMapCI(List<String> l) {
    return parseDoubleArrowMap((Map) ciMap(), l);
  }

  static public Map<String, String> parseDoubleArrowMapCI(String s) {
    return parseDoubleArrowMapCI_tlft(s);
  }

  static public void setDefaultVMArgs(String args) {
    String oldArgs = javaxDefaultVMArgs();
    args = trim(args);
    if (neq(unnull(oldArgs), unnull(args))) {
      print();
      print("Changing default VM arguments from");
      print("  " + oldArgs);
      print("to");
      print("  " + args);
      print();
      saveTextFile(javaxDataDir("default-vm-args"), nullIfEmpty(args));
    }
  }

  static public String replaceDollarVars_dyn(String s, IF1<String, String> f) {
    if (f == null)
      return s;
    return regexpReplaceIC(s, "\\$(\\w+)", matcher -> {
      String var = matcher.group(1);
      String val = f.get(var);
      return val == null ? matcher.group() : str(val);
    });
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public File renameFile_assertTrue(File a, File b) {
    try {
      if (a.equals(b))
        return b;
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String gazelle_textURL(long postID) {
    return gazelle_server() + "text/" + postID;
  }

  static public boolean containsSpace(String s) {
    return containsSpaces(s);
  }

  static public <A> List<A> itemPlus(A a, Collection<A> l) {
    return itemPlusList(a, l);
  }

  static public <A, B> List<A> cloneKeys_noSync(Map<A, B> map) {
    return cloneList_noSync(keys(map));
  }

  static public String timeInTimeZoneWithOptionalDate_24(String timezone, long time) {
    return timeInTimeZoneWithOptionalDate_24(timeZone(timezone), time);
  }

  static public String timeInTimeZoneWithOptionalDate_24(TimeZone timezone, long time) {
    SimpleDateFormat format = simpleDateFormat("yyyy/MM/dd", timezone);
    String date = format.format(time);
    boolean needDate = neq(date, format.format(now()));
    return (needDate ? date + " " : "") + timeInTimeZone(timezone, time);
  }

  static public Class<?> hotwireSharingLibraries(String progID) {
    try {
      Pair<File, String> p = CompilerBot.compileSnippet2(progID);
      File jar = p.a;
      assertTrue(f2s(jar), jar.isFile());
      List<File> files = ll(jar);
      String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
      List<File> myLibraries = myLibraryFiles();
      Matcher matcher = Pattern.compile("\\d+").matcher(dehlibs);
      while (matcher.find()) {
        String libID = matcher.group();
        File lib = loadLibrary(libID);
        if (myLibraries.contains(lib)) {
        } else {
          files.add(lib);
        }
      }
      JavaXClassLoaderWithParent classLoader = new JavaXClassLoaderWithParent(progID, files, myClassLoader());
      return hotwire_finish(classLoader, progID, p.b);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String hcheckboxWithText(String name, String text, boolean checked, Object... params) {
    String id = randomID();
    return hcheckbox(name, checked, paramsPlus(params, "id", id)) + " " + hlabelFor(id, htmlEncode2(text));
  }

  static public String hcheckboxWithText(String name, String text) {
    return hcheckboxWithText(name, text, false);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      Object __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public <A> List<A> cloneAndClearList(Collection<A> l) {
    List<A> l2 = cloneList(l);
    l.clear();
    return l2;
  }

  static public <A> A assertEquals(Object x, A y) {
    return assertEquals("", x, y);
  }

  static public <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  static public void assertEquals(Scorer scorer, Object x, Object y) {
    assertEquals(scorer, "", x, y);
  }

  static public void assertEquals(Scorer scorer, String msg, Object x, Object y) {
    if (scorer == null) {
      assertEquals(msg, x, y);
      return;
    }
    scorer.add(eq(x, y), nullIfEmpty(msg));
  }

  static public String joinMap(Object f, Iterable l) {
    return join(map(f, l));
  }

  static public String joinMap(Iterable l, Object f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(Iterable<A> l, IF1<A, String> f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(IF1<A, String> f, Iterable<A> l) {
    return join(map(f, l));
  }

  static public <A, B> String joinMap(String separator, Map<A, B> map, IF2<A, B, String> f) {
    return join(separator, map(map, f));
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public byte[] isJAR_magic = bytesFromHex("504B0304");

  static public boolean isJAR(byte[] data) {
    return byteArrayStartsWith(data, isJAR_magic);
  }

  static public boolean isJAR(File f) {
    return isJAR(loadBeginningOfBinaryFile(f, l(isJAR_magic)));
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public long parseLongOpt_pcall(String s) {
    try {
      return isInteger(s) ? parseLong(s) : 0;
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
    return 0;
  }

  static public List<String> tlft(String s) {
    return toLinesFullTrim(s);
  }

  static public List<String> tlft(File f) {
    return toLinesFullTrim(f);
  }

  static public String programTitle() {
    return getProgramName();
  }

  static public List<String> tok_combineRoundOrCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public Path toPath(File f) {
    return f == null ? null : f.toPath();
  }

  static public <A> AutoCloseable dm_vmBus_onMessage(final String msg, final VF1<A> onMessage) {
    return dm_ownResource(vmBus_onMessage(msg, onMessage));
  }

  static public <A> AutoCloseable dm_vmBus_onMessage(final String msg, final IVF1<A> onMessage) {
    return dm_ownResource(vmBus_onMessage(msg, ivf1ToVF1(onMessage)));
  }

  static public <A, B> AutoCloseable dm_vmBus_onMessage(final String msg, final IVF2<A, B> onMessage) {
    return dm_ownResource(vmBus_onMessage(msg, ivf2ToVF2(onMessage)));
  }

  static public <A, B> AutoCloseable dm_vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
    return dm_ownResource(vmBus_onMessage(msg, onMessage));
  }

  static public AutoCloseable dm_vmBus_onMessage(String msg, Runnable onMessage) {
    return dm_ownResource(vmBus_onMessage(msg, onMessage));
  }

  static public Dimension getPreferredSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getPreferredSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getPreferredSize();";
      }
    });
  }

  static public JTextArea jTextAreaWithUndo() {
    return jTextAreaWithUndo("");
  }

  static public JTextArea jTextAreaWithUndo(final String text) {
    return jenableUndoRedo(swingNu(JTextArea.class, text));
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public Q dm_startQ() {
    return dm_ownQ(startQ());
  }

  static public Q dm_startQ(String name) {
    return dm_ownQ(startQ(name));
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  static public String dropSpaces(String s) {
    return unnull(s).replace(" ", "");
  }

  static public String ahref_js(String js, Object contents, Object... params) {
    return empty(js) ? str(contents) : ahref("#", contents, paramsPlus(params, "onclick", addSuffix(trim(js), ";") + " return false;"));
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static public Object[] concatArrays(Object[]... arrays) {
    int l = 0;
    for (Object[] a : arrays) l += l(a);
    Object[] x = new Object[l];
    int i = 0;
    for (Object[] a : arrays) if (a != null) {
      System.arraycopy(a, 0, x, i, l(a));
      i += l(a);
    }
    return x;
  }

  static public String n2(long l) {
    return formatWithThousands(l);
  }

  static public String n2(Collection l) {
    return n2(l(l));
  }

  static public String n2(Map map) {
    return n2(l(map));
  }

  static public String n2(double l, String singular) {
    return n2(l, singular, singular + "s");
  }

  static public String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  static public String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(long l, String singular) {
    return n_fancy2(l, singular, singular + "s");
  }

  static public String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  static public String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  static public String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  static public String n2(long[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  static public String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s) {
    return mmo2_match(pattern, s, false, false);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s, boolean startOfLine, boolean endOfLine) {
    if (pattern == null)
      return false;
    String s2 = trim(s);
    if (pattern instanceof MMOPattern.StartOfLine)
      return mmo2_match(((MMOPattern.StartOfLine) pattern).p, s2, true, endOfLine);
    if (pattern instanceof MMOPattern.EndOfLine)
      return mmo2_match(((MMOPattern.EndOfLine) pattern).p, s2, startOfLine, true);
    if (pattern instanceof MMOPattern.Phrase) {
      String p = ((MMOPattern.Phrase) pattern).phrase;
      if (((MMOPattern.Phrase) pattern).quoted)
        return cicWithSmartWordBoundary(s2, p);
      if (startsWith(p, "#"))
        return eqic(p, s2);
      return match3_startOrEndOfLine(p, s2, startOfLine, endOfLine);
    }
    if (pattern instanceof MMOPattern.And)
      return all(((MMOPattern.And) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Or)
      return any(((MMOPattern.Or) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Not)
      return !mmo2_match(((MMOPattern.Not) pattern).p, s2, startOfLine, endOfLine);
    throw fail("what. " + pattern);
  }

  static public boolean mmo2_match(String pattern, String s) {
    return mmo2_match(mmo2_parsePattern(pattern), s);
  }

  static public void closeAutoCloseables(Collection<AutoCloseable> l) {
    if (l != null)
      for (AutoCloseable c : l) {
        try {
          c.close();
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
  }

  static public String getLookAndFeel() {
    return getClassName(UIManager.getLookAndFeel());
  }

  static public String appendNewLineIfNempty(String s) {
    return empty(s) ? "" : s + "\n";
  }

  static public <A> boolean allUnique(Collection<A> l) {
    return l(uniquify(l)) == l(l);
  }

  static public String lines_rtrim(Collection lines) {
    return rtrim_fromLines(lines);
  }

  static public <A> A second(List<A> l) {
    return get(l, 1);
  }

  static public <A> A second(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    it.next();
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A second(A[] bla) {
    return bla == null || bla.length <= 1 ? null : bla[1];
  }

  static public <A, B> B second(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public <A, B, C> B second(T3<A, B, C> t) {
    return t == null ? null : t.b;
  }

  static public <A> A second(Producer<A> p) {
    if (p == null)
      return null;
    if (p.next() == null)
      return null;
    return p.next();
  }

  static public char second(String s) {
    return charAt(s, 1);
  }

  static public <A, B> B second(Either<A, B> e) {
    return e == null ? null : e.bOpt();
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
    final JCheckBoxMenuItem mi = swing(() -> new JCheckBoxMenuItem(text, checked));
    addActionListener(mi, new Runnable() {

      public void run() {
        try {
          callF(r, isChecked(mi));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, isChecked(mi))";
      }
    });
    return mi;
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, IVF1<Boolean> r) {
    return jCheckBoxMenuItem(text, checked, (Object) r);
  }

  static public Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  static synchronized public List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public Lock appendToFile_lock = lock();

  static public boolean appendToFile_keepOpen = false;

  static public HashMap<String, Writer> appendToFile_writers = new HashMap();

  static public void appendToFile(String path, String s) {
    try {
      Lock __0 = appendToFile_lock;
      lock(__0);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  static public void cleanMeUp_appendToFile() {
    AutoCloseable __3 = tempCleaningUp();
    try {
      Lock __1 = appendToFile_lock;
      lock(__1);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__1);
      }
    } finally {
      _close(__3);
    }
  }

  static public Class mc() {
    return utils.class;
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void replaceTokens(List<String> tok, IntRange r, String s) {
    replaceTokens(tok, r.start, r.end, s);
  }

  static public void replaceTokens(List<String> tok, int i, int j, String s) {
    clearAllTokens(tok, i + 1, j);
    tok.set(i, s);
  }

  static public void replaceTokens(List<String> tok, String s) {
    clearAllTokens(tok, 1, l(tok));
    tok.set(0, s);
  }

  static public Map<String, String> parseDoubleArrowMap(Map<String, String> map, List<String> l) {
    for (String s : l) {
      List<String> x = splitAtDoubleArrow_bothDirections(s);
      if (l(x) == 2)
        map.put(first(x), second(x));
    }
    return map;
  }

  static public Map<String, String> standardCredentialsMap() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return litmap("_user", user, "_pass", pass);
    return litmap();
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterator<A> it) {
    if (it == null)
      return null;
    List l = new ArrayList();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    return i == null ? null : takeFirst(n, i.iterator());
  }

  static public <A> List<A> takeFirst(int n, IterableIterator<A> i) {
    return takeFirst(n, (Iterator<A>) i);
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public byte[] intToBytes(int i) {
    return new byte[] { (byte) (i >>> 24), (byte) (i >>> 16), (byte) (i >>> 8), (byte) i };
  }

  static public String hparagraphs(Collection<String> l) {
    return lines(lambdaMap(__97 -> p(__97), l));
  }

  static public boolean isEditableComboBox(final JComboBox cb) {
    return cb != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return cb.isEditable();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret cb.isEditable();";
      }
    });
  }

  static public JPanel jrightalignedline(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jrightalignedline(List<Component> components) {
    return jrightAlignedLine(components);
  }

  static public String regexReplaceIC(String s, String pat, Object f) {
    return regexReplace(regexpMatcherIC(pat, s), f);
  }

  static public String regexReplaceIC(String s, String pat, String replacement) {
    return regexpReplaceIC_direct(s, pat, replacement);
  }

  static public String hreplacetag(String html, String tag, String newTag) {
    List<String> tok = htmlcoarsetok(html);
    List<List<String>> tags = findContainerTag(tok, tag);
    if (empty(tags))
      return html;
    List<String> theTag = first(tags);
    List<String> actualTag = subList(theTag, 1, l(theTag) - 1);
    return join(replaceSubList(cloneList(tok), actualTag, litlist(newTag)));
  }

  static public <A, B> Set<Map.Entry<A, B>> entrySet(Map<A, B> map) {
    return _entrySet(map);
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static public <A, B> List<B> syncLambdaMap(IF1<A, B> f, Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      return map(l, f);
    }
  }

  static public List<String> javaTokWithAllPlusAngleBrackets(String s) {
    return tok_combineAngleBrackets_keep(javaTokWithAllBrackets(s));
  }

  static public String cleanJavaCompilerOutput(String s) {
    return dropPrefixTrim("Annotation processing got disabled, since it requires a 1.6 compliant JVM", s);
  }

  static public String trimJoin(List<String> s) {
    return trim(join(s));
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public String jsonEncode_breakAtLevel1(Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode_breakAtLevel1(o, buf, 1);
    return str(buf);
  }

  static public void jsonEncode_breakAtLevel1(Object o, StringBuilder buf, int level) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n  ");
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode_breakAtLevel1(map.get(key), buf, level + 1);
      }
      if (level == 1)
        buf.append("\n");
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n  ");
        jsonEncode_breakAtLevel1(element, buf, level + 1);
      }
      if (level == 1)
        buf.append("\n");
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public boolean containsDollarVars(String s) {
    for (String t : javaTokC(s)) if (isDollarVar(t))
      return true;
    return false;
  }

  static public String hijackPrint(Runnable r) {
    return hijackPrint((Object) r);
  }

  static public String hijackPrint(Object r) {
    final StringBuilder buf = new StringBuilder();
    Object old = interceptPrintInThisThread(new F1<String, Boolean>() {

      public Boolean get(String s) {
        buf.append(s);
        return false;
      }
    });
    try {
      callF(r);
      return str(buf);
    } finally {
      interceptPrintInThisThread(old);
    }
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A, B> Set<A> keys(MultiSetMap<A, B> mm) {
    return mm.keySet();
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta) {
    return enableWordWrapForTextArea(ta, true);
  }

  static public JTextArea enableWordWrapForTextArea(JTextArea ta, boolean enabled) {
    if (ta != null) {
      swing(new Runnable() {

        public void run() {
          try {
            ta.setLineWrap(enabled);
            ta.setWrapStyleWord(true);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ta.setLineWrap(enabled);\r\n    ta.setWrapStyleWord(true);\r\n    // Haven't foun...";
        }
      });
    }
    return ta;
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public String dropPrefix_trim(String prefix, String s) {
    return dropPrefixTrim(prefix, s);
  }

  static public Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  static public List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public <A extends Concept> Pair<A, Boolean> uniqCI2_sync(Class<A> c, final Object... params) {
    return uniqCI2_sync(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Pair<A, Boolean> uniqCI2_sync(Concepts cc, Class<A> c, final Object... params) {
    return withDBLock(cc, new F0<Pair<A, Boolean>>() {

      public Pair<A, Boolean> get() {
        try {
          return uniqCI2(cc, c, params);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret uniqCI2(cc, c, params);";
      }
    });
  }

  static public String hresponstable() {
    return hcss_responstable();
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public void tokAppend_reTok(List<String> tok, int i, String s) {
    tok.set(i, tok.get(i) + s);
    reTok(tok, i, i + 1);
  }

  static public double parseDouble(String s) {
    return empty(s) ? 0.0 : Double.parseDouble(s);
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  static public File remoteMechListMirrorMetaFile(String listName) {
    return javaxDataDir("Remote Mech Lists/" + uniqueFileNameUsingMD5_80_v2(upper(listName)) + ".meta");
  }

  static public <A> A _print(String s, A a) {
    return print(s, a);
  }

  static public <A> A _print(A a) {
    return print(a);
  }

  static public void _print() {
    print();
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String ok2(String s) {
    return "ok " + s;
  }

  static public Map mapToValues(Iterable l, Object f) {
    return mapKeyAndFunction(l, f);
  }

  static public Map mapToValues(Object f, Iterable l) {
    return mapKeyAndFunction(f, l);
  }

  static public <A, B> Map<A, B> mapToValues(Iterable<A> l, IF1<A, B> f) {
    return mapKeyAndFunction(f, l);
  }

  static public <A, B> Map<A, B> mapToValues(IF1<A, B> f, Iterable<A> l) {
    return mapKeyAndFunction(f, l);
  }

  static public <A, B, C> Map<A, C> mapToValues(Map<A, B> map, IF2<A, B, C> f) {
    return mapKeyAndFunction(map, f);
  }

  static public String ol(String... list) {
    return ol(asList(list));
  }

  static public String ol(List<String> list, Object... params) {
    StringBuilder buf = new StringBuilder();
    int i = indexOf(params, null);
    if (i == -1)
      i = l(params);
    for (String s : withoutNulls(list)) buf.append(tag("li", s, subArray(params, i + 1))).append("\n");
    return containerTag("ol", buf, subArray(params, 0, i)) + "\n";
  }

  static public String htableRaw2(List<? extends List> data, List paramsTable, List paramsTR, List paramsTD) {
    StringBuilder buf = new StringBuilder();
    for (List row : data) {
      buf.append(hopeningTag("tr", toObjectArray(paramsTR)));
      for (Object cell : row) buf.append(htd(cell, toObjectArray(paramsTD))).append("\n");
      buf.append("</tr>\n");
    }
    return htag("table", buf, toObjectArray(paramsTable));
  }

  static public List<String> simpleSpaces(List<String> tok) {
    tok = cloneList(tok);
    for (int i = 0; i < l(tok); i += 2) tok.set(i, tok.get(i).equals("") ? "" : " ");
    return tok;
  }

  static public String simpleSpaces(String s) {
    return join(simpleSpaces(nlTok(s)));
  }

  static public String mechList_raw_fresh(String name) {
    return mechList_opt_raw_fresh(name);
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    if (o instanceof Boolean)
      return boolToInt((Boolean) o);
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public Map<String, Object> allConceptFieldsAsMap(Concept c) {
    Map<String, Object> map = new HashMap();
    for (String field : unnullForIteration(conceptFields(c))) map.put(field, cget(c, field));
    return map;
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  static public String imageSnippetURLOrEmptyGIF(String snippetID) {
    return empty(snippetID) ? smallestTransparentGIFDataURI() : snippetImageURL(snippetID);
  }

  static public List<String> dropPunctuation_keep = ll("*", "<", ">");

  static public List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  static public String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  static public JCheckBox jCheckBox() {
    return swingNu(JCheckBox.class);
  }

  static public JCheckBox jCheckBox(boolean checked) {
    return swingNu(JCheckBox.class, "", checked);
  }

  static public JCheckBox jCheckBox(String text, boolean checked) {
    return swingNu(JCheckBox.class, text, checked);
  }

  static public JCheckBox jCheckBox(String text) {
    return swingNu(JCheckBox.class, text);
  }

  static public JCheckBox jCheckBox(String text, boolean checked, final Object onChange) {
    JCheckBox cb = jCheckBox(checked, onChange);
    cb.setText(text);
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, final Object onChange) {
    final JCheckBox cb = jCheckBox(checked);
    cb.addChangeListener(new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(onChange, cb.isSelected());
      }
    });
    return cb;
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public List<String> dropTagsAndHTMLComments(List<String> tok) {
    return dropHTMLComments(dropTags(tok));
  }

  static public String dropTagsAndHTMLComments(String html) {
    return join(dropTagsAndHTMLComments(htmlTok(html)));
  }

  static public int toMS_int(double seconds) {
    return toInt_checked((long) (seconds * 1000));
  }

  static public int roundDownTo(int n, int x) {
    return x / n * n;
  }

  static public long roundDownTo(long n, long x) {
    return x / n * n;
  }

  static public String jlabel_textAsHTML_center_ifNeeded(String text) {
    if (swic(text, "<html>") && ewic(text, "</html>"))
      return text;
    if (!containsNewLines(text))
      return text;
    return jlabel_textAsHTML_center(text);
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public AccessControlContext vm_globalACC() {
    return (AccessControlContext) vm_generalMap_get("Global ACC");
  }

  static public boolean hasConceptIC(Class<? extends Concept> c, Object... params) {
    return hasConceptWhereIC(c, params);
  }

  static public boolean hasConceptIC(Concepts cc, Class<? extends Concept> c, Object... params) {
    return hasConceptWhereIC(cc, c, params);
  }

  static public Map<String, String> guessMimeTypeFromFileName_map = litmap(".css", "text/css", ".js", "text/javascript");

  static public String guessMimeTypeFromFileName(String name) {
    return guessMimeTypeFromFileName(name, binaryMimeType());
  }

  static public String guessMimeTypeFromFileName(String name, String defaultMimeType) {
    String __1 = guessMimeTypeFromFileName_map.get(fileExtension(name));
    if (!empty(__1))
      return __1;
    return or2(URLConnection.guessContentTypeFromName(name), defaultMimeType);
  }

  static public double systemLoad() {
    double load = osMXBean().getSystemLoadAverage();
    if (load < 0)
      return systemCPULoad();
    return load;
  }

  static public <A> A swingConstruct(final Class<A> c, final Object... args) {
    return swing(new F0<A>() {

      public A get() {
        try {
          return nuObject(c, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret nuObject(c, args);";
      }
    });
  }

  static volatile public Object isAllowed_function;

  static volatile public boolean isAllowed_all = true;

  static public boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  static public <A, B> Map<A, B> mapPlus_inFront(Map<A, B> m, Object... data) {
    LinkedHashMap m2 = new LinkedHashMap();
    litmap_impl(m2, data);
    putAll(m2, m);
    return m2;
  }

  static public JFrame handleEscapeKey(final JFrame frame) {
    KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    frame.getRootPane().registerKeyboardAction(new ActionListener() {

      public void actionPerformed(ActionEvent actionEvent) {
        frame.dispose();
      }
    }, stroke, JComponent.WHEN_IN_FOCUSED_WINDOW);
    return frame;
  }

  static public List<String> dm_modulesWithLibID(final String moduleLibID) {
    return filter(dm_moduleIDs(), new F1<String, Boolean>() {

      public Boolean get(String m) {
        try {
          return eq(dm_moduleLibID(m), moduleLibID);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "eq(dm_moduleLibID(m), moduleLibID)";
      }
    });
  }

  static public <A, B> MultiMap<A, B> treeMultiMap() {
    return new MultiMap(true);
  }

  static public <A, B> MultiMap<A, B> treeMultiMap(Comparator<A> comparator) {
    return new MultiMap(new TreeMap<A, List<B>>(comparator));
  }

  static public String getSnippetTitle_safe(String id) {
    if (isLocalSnippetID(id))
      return localSnippetTitle(id);
    String title = or(loadTextFile(snippetTitle_cacheFile(id)), "?");
    try {
      title = getSnippetTitle(id);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return title;
  }

  static public String upper(String s) {
    return s == null ? null : s.toUpperCase();
  }

  static public char upper(char c) {
    return Character.toUpperCase(c);
  }

  static public <A extends Component> A jPreferWidth(int w, A c) {
    Dimension size = c.getPreferredSize();
    c.setPreferredSize(new Dimension(w, size.height));
    return c;
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public JPanel infoMessage_makePanel(String text) {
    final JTextArea ta = wrappedTextArea(text);
    onClick(ta, new Runnable() {

      public void run() {
        try {
          disposeWindow(ta);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "disposeWindow(ta)";
      }
    });
    int size = 14;
    if (l(text) <= 50)
      size *= 2;
    else if (l(text) < 100)
      size = iround(size * 1.5);
    ta.setFont(typeWriterFont(size));
    JScrollPane sp = jscroll(ta);
    return withMargin(sp);
  }

  static public void setDefaultClassFinder(Object cf) {
    _defaultClassFinder_value = cf;
  }

  static public int countLines(String s) {
    return l(toLines(s));
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public boolean isSlowMachine() {
    return eq("1", trimLoadTextFile(javaxDataDir("is-slow-machine.txt")));
  }

  static public <A, B> void putMultipleKeys(Map<A, B> map, Collection<A> keys, B value) {
    if (map == null || keys == null)
      return;
    for (A key : keys) map.put(key, value);
  }

  static public <A> List<A> collectInstances(Iterable i, Class<A> c) {
    List l = new ArrayList();
    if (i == null)
      return l;
    c = primitiveToBoxedTypeOpt(c);
    for (Object o : i) if (isInstance(c, o))
      l.add(o);
    return l;
  }

  static public <A> List<A> collectInstances(Class<A> c, Iterable i) {
    return collectInstances(i, c);
  }

  static public boolean hasConceptWhereIC(Class<? extends Concept> c, Object... params) {
    return conceptWhereIC(c, params) != null;
  }

  static public boolean hasConceptWhereIC(Concepts cc, Class<? extends Concept> c, Object... params) {
    return conceptWhereIC(cc, c, params) != null;
  }

  static public <A> A getOrKeep(Map<A, ? extends A> map, A a) {
    if (map == null)
      return a;
    A v = map.get(a);
    return v != null ? v : a;
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public <A> A assertNotNull(Scorer scorer, String msg, A a) {
    if (scorer == null)
      return assertNotNull(msg, a);
    if (a == null) {
      print("BAD - " + msg + " is null: " + a);
      scorer.add(false);
    } else {
      print("OK, " + msg + " not null: " + a);
      scorer.add(true);
    }
    return a;
  }

  static public String hhtml_title_body(String title, Object bodyContents, Object... bodyParams) {
    return hhtml_head_title_body(title, bodyContents, bodyParams);
  }

  static public Object[] filterParams(Object[] params, Object... keys) {
    Set set = asSet(keys);
    List l = new ArrayList();
    for (int i = 0; i < l(params); i += 2) if (contains(set, params[i])) {
      l.add(params[i]);
      l.add(params[i + 1]);
    }
    return asObjectArray(l);
  }

  static public List<IntRange> parseBusinessHours(String s) {
    List<String> parts = nempties(tok_splitAtComma(s));
    return map(parts, part -> {
      List<String> l = splitAtMinus(part);
      IntRange r = intRange(parseHourAndOptionalMinutesToMinutes(first(l)), parseHourAndOptionalMinutesToMinutes(second(l)));
      if (r.end < r.start && r.start <= 12 * 60 && r.end < 12 * 60)
        r.end += 12 * 60;
      return r;
    });
  }

  static public String filterChars(IF1<Character, Boolean> pred, String s) {
    if (s == null)
      return null;
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    char c;
    for (int i = 0; i < n; i++) if (isTrue(callF(pred, c = s.charAt(i))))
      buf.append(c);
    return str(buf);
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public boolean directoryEmpty(File f) {
    return directoryIsEmpty(f);
  }

  static public boolean regexpContainsIC(String pat, String s) {
    return regexpFindsIC(pat, s);
  }

  static public boolean neqGet(List l, int i, Object o) {
    return neq(get(l, i), o);
  }

  static public List<String> tok_combineRoundBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public Map transformKeys(Map map, Object f) {
    HashMap m = new HashMap();
    for (Object key : keys(map)) m.put(callF(f, key), map.get(key));
    return m;
  }

  static public String emojisToUnicode(String s) {
    return regexReplace(s, ":(\\w+):", matcher -> lookupOrKeep(emojiShortNameMap(), matcher.group()));
  }

  static public List similarEmptyList(Collection m) {
    return new ArrayList();
  }

  static public String himageupload(Object... params) {
    return hfileupload(paramsPlus(params, "accept", "image/png,image/jpeg,image/gif"));
  }

  static public JTextField jtextfield() {
    return jTextField();
  }

  static public JTextField jtextfield(String text) {
    return jTextField(text);
  }

  static public JTextField jtextfield(Object o) {
    return jTextField(o);
  }

  static public boolean transpileRaw_silent = true;

  static public boolean transpileRaw_useDiskCache = false;

  static public String transpileRaw(String mainJava) {
    return (String) call(dm_transpiler(), "transpileRaw", mainJava, false, transpileRaw_useDiskCache);
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public double systemCPULoad() {
    return advancedOSMXBean().getSystemCpuLoad();
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public String ol_htmlEncode(String... list) {
    return ol_htmlEncode(asList(list));
  }

  static public String ol_htmlEncode(List list, Object... params) {
    return ol_htmlEncode((Collection) list, params);
  }

  static public String ol_htmlEncode(Collection list, Object... params) {
    return ol(lmap(__98 -> htmlEncode2(__98), list), params);
  }

  static public JPanel westAndCenter(final Component w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.WEST, wrap(w));
          panel.add(BorderLayout.CENTER, wrap(c));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.WEST...";
      }
    });
  }

  static public String hstylesheetsrc(String src) {
    return tag("link", "", "rel", "stylesheet", "href", src);
  }

  static public Object[] changeParam(Object[] params, String name, Object value) {
    if (eq(optPar(params, name), value))
      return params;
    Map map = paramsToOrderedMap(params);
    map.put(name, value);
    return mapToParams(map);
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public File loadBinarySnippet(String snippetID) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadLibrary(snippetID);
    return loadBinarySnippet_noResourceLoader(snippetID);
  }

  static public File loadBinarySnippet_noResourceLoader(String snippetID) {
    try {
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile_noResourceLoader(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> IterableIterator<B> concurrentlyIterateValues(NavigableMap<A, B> map) {
    return concurrentlyIterateValues(map, map);
  }

  static public <A, B> IterableIterator<B> concurrentlyIterateValues(final NavigableMap<A, B> map, Object mutex) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<A> it = keys(map).iterator();

      public A key;

      public B get() {
        synchronized (mutex) {
          try {
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          } catch (ConcurrentModificationException e) {
            print("Re-iterating");
            it = map.tailMap(key, false).keySet().iterator();
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          }
        }
      }
    });
  }

  static public void _initFrame(JFrame f) {
    myFrames_list.put(f, Boolean.TRUE);
    standardTitlePopupMenu(f);
  }

  static public Object addToMultiPort_responder;

  static public long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  static public long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  static public <A> A printWithIndent(A o) {
    return printIndent(o);
  }

  static public <A> A printWithIndent(String indent, A o) {
    return printIndent(indent, o);
  }

  static public void printWithIndent(int indent, Object o) {
    printIndent(indent, o);
  }

  static public List beforeDelegatingToThread_operations = synchroList();

  static public void beforeDelegatingToThread(Thread t) {
    for (Object op : cloneList(beforeDelegatingToThread_operations)) pcallF(op, t);
  }

  static public void beforeDelegatingToThread_do(Object f) {
    setAdd(beforeDelegatingToThread_operations, f);
  }

  static public String hfullcenter(Object contents, Object... __) {
    return tag("table", tr(td(contents, "align", "center")), paramsPlus(__, "width", "100%", "height", "100%"));
  }

  static public <A> List<A> syncAddOrCreate(List<A> l, A a) {
    if (l == null)
      l = syncList();
    l.add(a);
    return l;
  }

  static public String unicode_undoArrow() {
    return unicodeFromCodePoint(0x21B6);
  }

  static public <A> boolean strictPutIC(Map<A, String> map, A key, String value) {
    if (!(map != null && key != null && value != null))
      return true;
    String old = map.get(key);
    if (old == null) {
      map.put(key, value);
      return true;
    }
    return eqic(old, value);
  }

  static public boolean strictPutIC(Map<Symbol, Symbol> map, Symbol key, Symbol value) {
    if (!(map != null && key != null && value != null))
      return true;
    Symbol old = map.get(key);
    if (old == null) {
      map.put(key, value);
      return true;
    }
    return eqic(old, value);
  }

  static public void tokPrepend(List<String> tok, String s) {
    tokPrepend(tok, 0, s);
  }

  static public void tokPrepend(List<String> tok, int i, String s) {
    tok.set(i, s + tok.get(i));
  }

  static public String appendRoundBracketed(String b) {
    return empty(b) ? "" : "" + " (" + b + ")";
  }

  static public String appendRoundBracketed(String a, String b) {
    return empty(b) ? a : a + appendRoundBracketed(b);
  }

  static public List<String> dm_listModuleIDs() {
    return map(__99 -> dm_moduleID(__99), dm_listStems());
  }

  static public <A, B> B syncPut(Map<A, B> map, A key, B value) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.put(key, value);
    }
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      ClassLoader cl = (o instanceof Class ? (Class) o : o.getClass()).getClassLoader();
      if (cl == null)
        return null;
      String name = mainClassNameForClassLoader(cl);
      return loadClassFromClassLoader_orNull(cl, name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public TreeSet<String> asCISet(Iterable<String> c) {
    return toCaseInsensitiveSet(c);
  }

  static public TreeSet<String> asCISet(String... x) {
    return toCaseInsensitiveSet(x);
  }

  static public void internalFrameDefaultPosition(JInternalFrame f) {
    f.setSize(500, 300);
    centerInternalFrame(f);
  }

  static public int numberOfMethodArguments(Object o, String method) {
    Class c;
    boolean mustBeStatic = false;
    if (o instanceof Class) {
      c = (Class) o;
      mustBeStatic = true;
    } else
      c = o.getClass();
    Class _c = c;
    int n = -1;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if (mustBeStatic && !methodIsStatic(m))
          continue;
        int nn = l(m.getParameterTypes());
        if (n == -1)
          n = nn;
        else if (n != nn)
          throw fail("Variable number of method arguments: " + _c + "." + method);
      }
      c = c.getSuperclass();
    }
    if (n == -1)
      throw fail("Method not found: " + _c + "." + method);
    return n;
  }

  static public String himg(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", isSnippetID(src) ? snippetImageLink(src) : src));
  }

  static public String himg(BufferedImage img, Object... params) {
    return himg(dataURL(jpegMimeType(), toJPEG(img)), params);
  }

  static public String td(Object contents, Object... params) {
    return hfulltag("td", contents, params);
  }

  static public String td() {
    return td("");
  }

  static public List<String> splitAtDoubleArrow(String s) {
    return splitAtDoubleArrow(javaTok(s));
  }

  static public List<String> splitAtDoubleArrow(List<String> tok) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, splitAtDoubleArrow_tok(), i);
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + 3;
    }
    return l;
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public List<String> splitAtAmpersand(String s) {
    return s == null ? emptyList() : asList(s.split("&"));
  }

  static public List<String> splitByJavaToken(String s, String splitToken) {
    List<String> tok = javaTok(s);
    List<String> l = new ArrayList();
    int i = 1;
    while (i < l(tok)) {
      int j = smartIndexOf(tok, splitToken, i);
      l.add(join(subList(tok, i, j - 1)));
      i = j + 2;
    }
    return l;
  }

  static public String th(Object contents, Object... params) {
    return tag("th", contents, params);
  }

  static public <A, B> List<Pair<A, B>> syncMapToPairs(Map<A, B> map) {
    if (map == null)
      return new ArrayList();
    synchronized (collectionMutex(map)) {
      return mapToPairs(map);
    }
  }

  static public String hjssnippet_maxCache(String snippetID) {
    return hfulltag("script", "", "src", snippetRawURL_maxCache(snippetID, "text/javascript"));
  }

  static public boolean isSubclass(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public void dm_ownTimer(Object resource, Object closerHelper) {
    call(dm_current_generic(), "ownTimer", resource, closerHelper);
  }

  static public <A> A dm_ownTimer(A resource) {
    call(dm_current_generic(), "ownTimer", resource);
    return resource;
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public String tr(Object contents) {
    return tag("tr", contents);
  }

  static public void tt() {
    typeWriterConsole();
  }

  static public String tt(Object contents, Object... params) {
    return tag("tt", contents, params);
  }

  static public void flexMatchAngleBracketVarsIC_iterate(String pat, String input, VF1<Map<String, String>> onMatch) {
    List<String> vars = new ArrayList();
    String starsPat = angleBracketVarsToStars(pat, vars);
    flexMatchIC_iterate(starsPat, input, new VF1<Matches>() {

      public void get(Matches m) {
        try {
          Map<String, String> map = matchesToMapUsingVarList_ciMap(m, vars);
          if (map != null)
            callF(onMatch, map);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "SS map = matchesToMapUsingVarList_ciMap(m, vars);\r\n    if (map != null) callF...";
      }
    });
  }

  static public List<String> methodsStartingWith(Object o, final String prefix) {
    return filter(allMethodNames(o), new F1<String, Object>() {

      public Object get(String s) {
        try {
          return startsWith(s, prefix);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startsWith(s, prefix)";
      }
    });
  }

  static public String dm_moduleID(Object module) {
    return strOrNull(getOpt(dm_getStem(module), "id"));
  }

  static public String dm_moduleID() {
    return dm_moduleID(dm_current_mandatory_generic());
  }

  static public boolean checkConceptFieldsIC(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (!eqicOrEq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public File backupConceptsNow() {
    return backupConceptsNow(db_mainConcepts());
  }

  static public File backupConceptsNow(Concepts cc) {
    if (cc == null)
      return null;
    File f1 = cc.conceptsFile();
    File f2 = fileInSameDir(f1, "backups/concepts.structure" + (cc.useGZIP ? ".gz" : "") + ".backup" + ymd_minus_hms());
    return copyFile(f1, f2);
  }

  static public String hquery(Map params) {
    return htmlQuery(params);
  }

  static public String hquery(Object... data) {
    return htmlQuery(data);
  }

  static public String faviconMimeType() {
    return "image/x-icon";
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator(final MultiSetMap<A, B> mm) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  static public boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  static public boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A, B> void doublePut(Map<A, B> map, A key1, A key2, B value) {
    map.put(key1, value);
    map.put(key2, value);
  }

  static public String squareBracketIfNempty(String s) {
    return empty(s) ? "" : squareBracket(s);
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public JScrollPane jscroll(final Component c) {
    return swing(new F0<JScrollPane>() {

      public JScrollPane get() {
        try {
          return new JScrollPane(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JScrollPane(c);";
      }
    });
  }

  static public String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> void putUnlessZero(Map<A, Integer> map, A key, int value) {
    if (map != null && key != null && value != 0)
      map.put(key, value);
  }

  static public <A> void putUnlessZero(Map<A, Double> map, A key, double value) {
    if (map != null && key != null && value != 0)
      map.put(key, value);
  }

  static public Long conceptIDOrNull(Concept c) {
    return c == null ? null : c.id;
  }

  static public String ul(String... list) {
    return ul(asList(list));
  }

  static public String ul(Collection list, Object... params) {
    StringBuilder buf = new StringBuilder();
    int i = indexOf(params, null);
    if (i == -1)
      i = l(params);
    for (Object s : withoutNulls(list)) buf.append(tag("li", s, subArray(params, i + 1))).append("\n");
    return containerTag("ul", buf, subArray(params, 0, i)) + "\n";
  }

  static public String trimLoadTextFile(String fileName) {
    return loadTextFile_trim(fileName);
  }

  static public String trimLoadTextFile(File f, String defaultContents) {
    return loadTextFile_trim(f, defaultContents);
  }

  static public String trimLoadTextFile(File fileName) {
    return loadTextFile_trim(fileName);
  }

  static public String trimLoadTextFile(String fileName, String defaultContents) {
    return loadTextFile_trim(fileName, defaultContents);
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public String hlabelFor(String id, Object contents) {
    String s = strOrEmpty(contents);
    return empty(s) ? "" : htag("label", s, "for", id);
  }

  static public double elapsedSeconds_timestamp(long time) {
    return toSeconds(now() - time);
  }

  static public List<List<JComponent>> showForm_makeComponents(final Boolean internalFrame, Object... _parts) {
    List<List<JComponent>> l = new ArrayList();
    List parts = asList(_parts);
    JButton submitButton = null;
    for (int i = 0; i < l(parts); i++) {
      final Object o = parts.get(i), next = get(parts, i + 1);
      if (o instanceof String && next instanceof Component)
        setComponentID((Component) next, (String) o);
      if (o instanceof Component || o instanceof String || next instanceof Component) {
        l.add(mapLL(__100 -> wrapForSmartAdd_jComponent(__100), o == null ? new JPanel() : o instanceof String ? humanizeFormLabel((String) o) : o, next));
        if (next instanceof JButton && submitButton == null)
          submitButton = (JButton) next;
        i++;
      } else if (isRunnable(o))
        l.add(mapLL(__101 -> wrapForSmartAdd_jComponent(__101), null, submitButton = jbutton(showFormSubmitButtonName(), new Runnable() {

          public void run() {
            try {
              Object result = call(o);
              print("Result of form runnable: " + result + ". Button:  " + heldInstance(JButton.class));
              if (neq(Boolean.FALSE, result)) {
                if (isTrue(internalFrame))
                  disposeInternalFrame(heldInstance(JButton.class));
                else if (isFalse(internalFrame))
                  disposeFrame(heldInstance(JButton.class));
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "Object result = call(o);\r\n        print(\"Result of form runnable: \" + result ...";
          }
        })));
      else
        print("showForm: Unknown element type: " + getClassName(o));
    }
    if (submitButton != null) {
      final JButton _submitButton = submitButton;
      onEnterInAllTextFields(concatLists(l), new Runnable() {

        public void run() {
          try {
            clickButton(_submitButton);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "clickButton(_submitButton)";
        }
      });
    }
    for (List<JComponent> row : l) {
      JComponent left = first(row);
      if (left instanceof JLabel)
        makeBold((JLabel) left).setVerticalAlignment(JLabel.TOP);
    }
    return l;
  }

  static public JInternalFrame centerInternalFrame(final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Container c = f.getParent();
            if (c != null) {
              f.setLocation((c.getWidth() - f.getWidth()) / 2, (c.getHeight() - f.getHeight()) / 2);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Container c = f.getParent();\r\n    if (c != null) {\r\n      //print(\"Container ...";
        }
      });
    }
    return f;
  }

  static public JInternalFrame centerInternalFrame(final int w, final int h, final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            f.setSize(w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setSize(w, h);";
        }
      });
    }
    return centerInternalFrame(f);
  }

  static public boolean isSafeCodeFragment(String code) {
    return eq("safe", joinWithComma(getCodeFragmentSafety(code)));
  }

  static public <A> Comparator<A> fieldComparator(final String field) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(getOpt(a, field), getOpt(b, field));
      }
    };
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public boolean isChecked(JCheckBox checkBox) {
    return checkBox != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return checkBox.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret checkBox.isSelected();";
      }
    });
  }

  static public boolean isChecked(JCheckBoxMenuItem mi) {
    return mi != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return mi.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mi.isSelected();";
      }
    });
  }

  static public boolean isChecked(JRadioButton rb) {
    return rb != null && (boolean) swing(() -> rb.isSelected());
  }

  static public String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  static public String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  static public <A, B> String mapPairsToLines(Iterable<Pair<A, B>> l, IF2<A, B, String> f) {
    return lines(mapPairsToList(l, f));
  }

  static public BufferedImage imageIO_readURL(String url) {
    try {
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void innerCleanUp(Object c) {
    if (!isFalse(pcallOpt(c, "cleanMeUp")))
      for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
        callOpt(c, name);
      } catch (Throwable e) {
        print("Error cleaning up: " + programID(c));
        _handleException(e);
      }
  }

  static public void innerCleanUp() {
    innerCleanUp(mc());
  }

  static public JButton jPopDownButton(String text, final Object... menuParams) {
    return jbutton((empty(text) ? "" : text + " ") + unicode_downPointingTriangle(), new Runnable() {

      public void run() {
        try {
          JPopupMenu menu = new JPopupMenu();
          int emptyCount = menu.getComponentCount();
          String position = (String) (optPar_ignoreOddLength("position", menuParams));
          fillJPopupMenu(menu, paramsWithout(menuParams, "position"));
          if (menu.getComponentCount() != emptyCount) {
            JButton btn = heldInstance(JButton.class);
            int x = 0;
            if (eq(position, "center"))
              x = (btn.getWidth() - getPreferredWidth(menu)) / 2;
            else if (eq(position, "right"))
              x = btn.getWidth() - getPreferredWidth(menu);
            menu.show(btn, x, btn.getHeight());
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JPopupMenu menu;\r\n    int emptyCount = menu.getComponentCount();\r\n    Str...";
      }
    });
  }

  static public Integer mmo2_levenWithSwapsScore(MMOPattern pattern, String s) {
    return mmo2_levenWithSwapsScore(pattern, s, false, false);
  }

  static public Integer mmo2_levenWithSwapsScore(MMOPattern pattern, String s, boolean startOfLine, boolean endOfLine) {
    String s2 = trim(s);
    if (pattern == null)
      return null;
    if (startsWith(s2, "#"))
      return null;
    if (pattern instanceof MMOPattern.StartOfLine)
      return mmo2_levenWithSwapsScore(((MMOPattern.StartOfLine) pattern).p, s2, true, endOfLine);
    if (pattern instanceof MMOPattern.EndOfLine)
      return mmo2_levenWithSwapsScore(((MMOPattern.EndOfLine) pattern).p, s2, startOfLine, true);
    if (pattern instanceof MMOPattern.Phrase) {
      if (((MMOPattern.Phrase) pattern).quoted)
        return mmo2_match(((MMOPattern.Phrase) pattern), s2) ? (Integer) 0 : null;
      String p = ((MMOPattern.Phrase) pattern).phrase;
      if (startsWith(p, "#"))
        return null;
      if (endsWith(p, "!"))
        return find3(p, s) ? 0 : null;
      else
        return find3_levenWithSwapsDistance(p, s2);
    }
    if (pattern instanceof MMOPattern.And) {
      int score = 0;
      for (MMOPattern pat : ((MMOPattern.And) pattern).l) {
        Integer score2 = mmo2_levenWithSwapsScore(pat, s2, startOfLine, endOfLine);
        if (score2 == null)
          return null;
        score += score2;
      }
      return score;
    }
    if (pattern instanceof MMOPattern.Or) {
      Integer min = null;
      for (MMOPattern pat : ((MMOPattern.Or) pattern).l) min = min_withNull(min, mmo2_levenWithSwapsScore(pat, s2, startOfLine, endOfLine));
      return min;
    }
    if (pattern instanceof MMOPattern.Not)
      return mmo2_match(pattern, s2) ? 0 : null;
    throw fail("what. " + pattern);
  }

  static public Integer mmo2_levenWithSwapsScore(String pattern, String s) {
    return mmo2_levenWithSwapsScore(mmo2_parsePattern(pattern), s, false, false);
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Map similarEmptyMap(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeMap(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  static public File toFile(Object o) {
    if (o instanceof File)
      return (File) o;
    if (o instanceof String)
      return new File((String) o);
    throw fail("Not a file: " + o);
  }

  static public void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  static public <A> A _get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public Object _get(Object o, String field) {
    return get(o, field);
  }

  static public Object _get(String field, Object o) {
    return get(o, field);
  }

  static public <A> A _get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public String div_alignRight(Object contents, Object... params) {
    return div(contents, params_stylePlus(params, "text-align: right"));
  }

  static public Set<String> gazelle_allSyntacticPatternsFromInput(String input) {
    Chain<String> tokens = toChain(javaTokC(input));
    LinkedHashSet<String> out = new LinkedHashSet();
    gazelle_allSyntacticPatternsFromInput_collect(null, tokens, out);
    return out;
  }

  static public void gazelle_allSyntacticPatternsFromInput_collect(ReverseChain<String> prefix, Chain<String> tokens, Set<String> out) {
    ping();
    if (empty(tokens)) {
      out.add(joinWithSpace(asList(prefix)));
      return;
    }
    gazelle_allSyntacticPatternsFromInput_collect(chainPlus(prefix, first(tokens)), dropFirst(tokens), out);
    if (!eq(last(prefix), "*")) {
      ReverseChain<String> prefix2 = chainPlus(prefix, "*");
      Chain<String> tokens2 = tokens;
      while (!empty(tokens2)) {
        tokens2 = dropFirst(tokens2);
        gazelle_allSyntacticPatternsFromInput_collect(prefix2, tokens2, out);
      }
    }
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public String applyTranspilationFunction(IVF1<List<String>> f, String s) {
    if (f == null)
      return s;
    List<String> tok = javaTok(s);
    f.get(tok);
    return join(tok);
  }

  static public int snippetType_JavaXDesktop() {
    return 55;
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  static public <A> VF1<A> runnableToVF1(final Runnable r) {
    return r == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          r.run();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "r.run()";
      }
    };
  }

  static public List<String> gazelle_navLinks(String baseLink, String searchQuery, Object... __) {
    boolean withTeam = optPar("withTeam", __, true);
    boolean withStats = optPar("withStats", __, true);
    boolean flat = boolPar("flat", __);
    List more = ll(ahref(baseLink + "/deletedPosts", "Deleted Posts"));
    return llNonNulls(flattenStringArray2(ahref(baseLink + "/crud/UserPost?cmd=new", "New Post"), searchQuery != null ? hform(hinputfield("q", searchQuery, "style", "width: 75px") + " " + hsubmit("Search"), "style", "display: inline", "action", baseLink + "/search") : ahref(baseLink + "/search", "Search"), ahref(baseLink + "/rootPosts", "Root Posts"), ahref(baseLink + "/allPosts", "All Posts"), ahref(baseLink + "/latestPosts", "Latest Posts"), ahref(baseLink + "/latestModifiedPosts", "Latest Changes"), ahref(baseLink + "/mainPosts", "Main Posts"), !withTeam ? null : ahref(baseLink + "/team", "Team"), flat ? more : hPopDownButton(flattenStringArray2(!withStats ? null : ahref(baseLink + "/stats", "Stats"), more))));
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Class<A> c, String field) {
    return getConceptFieldCIIndex(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Concepts concepts, Class<A> c, String field) {
    return (ConceptFieldIndexCI) concepts.getCIFieldIndex(c, field);
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  static public void standardTitlePopupMenu(final JFrame frame) {
    if (!isSubstanceLAF())
      return;
    titlePopupMenu(frame, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          boolean alwaysOnTop = frame.isAlwaysOnTop();
          menu.add(jmenuItem("Restart Program", "restart"));
          menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
          menu.add(jmenuItem("Show Console", "showConsole"));
          menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() {

            public void run() {
              try {
                toggleAlwaysOnTop(frame);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "toggleAlwaysOnTop(frame)";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n    ifndef standardTitlePopupMenu_...";
      }
    });
  }

  static public SnippetTitles getSnippetTitle_cached_cache = new SnippetTitles();

  static public String getSnippetTitle_cached(String id) {
    return getSnippetTitle_cached_cache.get(id);
  }

  static public void getSnippetTitle_cached_put(String id, String title) {
    getSnippetTitle_cached_cache.put(id, title);
  }

  static public boolean getSnippetTitle_cached_has(String id) {
    return getSnippetTitle_cached_cache.has(id);
  }

  static public String getSnippetTitle_cached_probe(String id) {
    return getSnippetTitle_cached_cache.probe(id);
  }

  static public List<String> javaTokWithBrackets(String s) {
    return javaTokPlusBrackets(s);
  }

  static public <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
    return map == null ? new TreeSet() : map.navigableKeySet();
  }

  static public <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }

  static public <A, B> NavigableSet<A> navigableKeys(MultiMap<A, B> mm) {
    return ((NavigableMap) mm.data).navigableKeySet();
  }

  static public String ul_htmlEncode(String... list) {
    return ul_htmlEncode(asList(list));
  }

  static public String ul_htmlEncode(Collection list, Object... params) {
    return ul(map(__102 -> htmlEncode2(__102), allToString(list)), params);
  }

  static public String formatCSVFileForExcel2(List<List> rows) {
    String sep = "|";
    return windowsLineBreaks("sep=" + sep + "\n" + mapToLines_rtrim(rows, row -> join(sep, map(row, col -> replace(newLinesToSpaces(str(col)), sep, " ")))));
  }

  static public void indexSingletonConcept(Concepts cc, Class<? extends Concept> c) {
    indexConceptField(cc, c, "_dummy");
  }

  static public void indexSingletonConcept(Class<? extends Concept> c) {
    indexSingletonConcept(db_mainConcepts(), c);
  }

  static public <A> List<A> synchroList() {
    return synchroList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  static public Object serveInputStream(InputStream in, String mimeType) {
    return subBot_serveInputStream(in, mimeType);
  }

  static public JComponent componentToJComponent(Component c) {
    if (c instanceof JComponent)
      return (JComponent) c;
    if (c instanceof JFrame)
      return ((JFrame) c).getRootPane();
    if (c == null)
      return null;
    throw fail("boohoo " + getClassName(c));
  }

  static public <A> String formatDoubleArrowPairs_horizontallyAligned(List<Pair<A, A>> l) {
    return asciiSideBySideWithSeparator(" => ", ll(lines(pairsA(l)), lines(pairsB(l))));
  }

  static public Object subBot_serveFile_maxCache(File file) {
    return subBot_maxCacheHeaders(subBot_serveFile(file));
  }

  static public Object subBot_serveFile_maxCache(File file, String mimeType) {
    return subBot_maxCacheHeaders(subBot_serveFile(file, mimeType));
  }

  static public AlphanumComparator alphaNumComparator_instance;

  static public Comparator<String> alphaNumComparator() {
    if (alphaNumComparator_instance == null)
      alphaNumComparator_instance = new AlphanumComparator();
    return alphaNumComparator_instance;
  }

  static public int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  static public <A> AutoCloseable tempDisposeWindow(final Window w) {
    return new AutoCloseable() {

      public void close() {
        disposeWindow(w);
      }
    };
  }

  static public boolean checkFields(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static public boolean loadFunctions_debug = false;

  static public Object loadFunctions_veryQuickJava;

  static public Class loadFunctions(String... functions) {
    return loadFunctions(asList(functions));
  }

  static public Class loadFunctions(Collection<String> functions, Object... __) {
    print("Compiling " + joinWithPlus(functions));
    TreeSet<String> functionSet = new TreeSet<String>(functions);
    StringBuilder buf = stringBuilder(appendNewLineIfNempty(stringPar("header", __)));
    for (String s : functionSet) buf.append("please include function " + assertIdentifier(s) + ".\n");
    long time = sysNow();
    Class c;
    if (loadFunctions_veryQuickJava != null)
      c = (Class) callF(loadFunctions_veryQuickJava, str(buf));
    else {
      veryQuickJava_transpiled.set("");
      c = veryQuickJava(str(buf));
      saveTranspiledStandardFunctions(functionSet, getAndClearThreadLocal(veryQuickJava_transpiled));
    }
    if (loadFunctions_debug)
      done2_always(time, "loadFunctions: " + join(" ", functions));
    return c;
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public String quoteOr(String s, String whenEmpty) {
    return empty(s) ? whenEmpty : quote(s);
  }

  static public List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  static public List<File> listFilesOnly(File... dirs) {
    return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(Symbol a, Symbol b) {
    return eq(a, b);
  }

  static public boolean eqic(Symbol a, String b) {
    return eqic(asString(a), b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static volatile public boolean readLine_noReadLine = false;

  static public String readLine_lastInput;

  static public String readLine_prefix = "[] ";

  static public String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  static public String hpre_htmlencode(Object contents, Object... params) {
    return pre_htmlencode(contents, params);
  }

  static public String unicode_newLineArrow() {
    return charToString(0x21b5);
  }

  static public <A> F0<A> if0ToF0(IF0<A> f) {
    return f == null ? null : new F0<A>() {

      public A get() {
        try {
          return f.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.get();";
      }
    };
  }

  static public <A, B> A pairA(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public void autoVMExit() {
    call(getJavaX(), "autoVMExit");
  }

  static public String jreplace_dyn(String s, String in, Object out) {
    return jreplace_dyn(s, in, out, null);
  }

  static public String jreplace_dyn(String s, String in, Object out, Object condition) {
    List<String> tok = javaTok(s);
    jreplace_dyn(tok, in, out, condition);
    return join(tok);
  }

  static public boolean jreplace_dyn(List<String> tok, String in, Object out) {
    return jreplace_dyn(tok, in, out, false, true, null);
  }

  static public boolean jreplace_dyn(List<String> tok, String in, IF2<List<String>, Integer, String> out) {
    return jreplace_dyn(tok, in, (Object) out);
  }

  static public boolean jreplace_dyn(List<String> tok, String in, IF2<List<String>, Integer, String> out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace_dyn(tok, in, (Object) out, (Object) condition);
  }

  static public boolean jreplace_dyn(List<String> tok, String in, Object out, Object condition) {
    return jreplace_dyn(tok, in, out, false, true, condition);
  }

  static public boolean jreplace_dyn(List<String> tok, String in, Object out, boolean ignoreCase, boolean reTok, Object condition) {
    List<String> tokin = javaTok(in);
    jfind_preprocess(tokin);
    String[] toks = toStringArray(codeTokensOnly(tokin));
    boolean anyChange = false;
    for (int n = 0; n < 10000; n++) {
      int i = findCodeTokens(tok, 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      String expansion = (String) (callF(out, tok, i));
      int end = i + l(tokin) - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public void consoleClearInput() {
    consoleSetInput("");
  }

  static public int indexOfIC(List<String> a, String b) {
    return indexOfIgnoreCase(a, b);
  }

  static public int indexOfIC(List<String> a, String b, int i) {
    return indexOfIgnoreCase(a, b, i);
  }

  static public int indexOfIC(String a, String b) {
    return indexOfIgnoreCase(a, b);
  }

  static public int indexOfIC(String a, String b, int i) {
    return indexOfIgnoreCase(a, b, i);
  }

  static public int compareIgnoreCase_jdk(String s1, String s2) {
    if (s1 == null)
      return s2 == null ? 0 : -1;
    if (s2 == null)
      return 1;
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
      char c1 = s1.charAt(i);
      char c2 = s2.charAt(i);
      if (c1 != c2) {
        c1 = Character.toUpperCase(c1);
        c2 = Character.toUpperCase(c2);
        if (c1 != c2) {
          c1 = Character.toLowerCase(c1);
          c2 = Character.toLowerCase(c2);
          if (c1 != c2)
            return c1 - c2;
        }
      }
    }
    return n1 - n2;
  }

  static public int parseIntOpt(String s) {
    return parseIntOpt(s, 0);
  }

  static public int parseIntOpt(String s, int defValue) {
    return isInteger(s) ? parseInt(s) : defValue;
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public String dollarVarsToStars(String s) {
    return dollarVarsToStars(s, null);
  }

  static public String dollarVarsToStars(String s, List<String> varNames_out) {
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (isDollarVar(t)) {
        listAdd(varNames_out, t);
        tok.set(i, "*");
      } else if (eq(t, "*"))
        listAdd(varNames_out, "*");
    }
    return join(tok);
  }

  static volatile public PersistableThrowable _handleException_lastException;

  static public List _handleException_onException = synchroList(ll((IVF1<Throwable>) (__1 -> printStackTrace2(__1))));

  static public boolean _handleException_showThreadCancellations = false;

  static public void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException) {
      if (_handleException_showThreadCancellations)
        System.out.println(getStackTrace_noRecord(e2));
      return;
    }
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      try {
        printStackTrace2(e3);
      } catch (Throwable e4) {
        System.out.println(getStackTrace(e3));
        System.out.println(getStackTrace(e4));
      }
    }
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public <A> Chain<A> dropFirst(Chain<A> c) {
    return c == null ? null : c.next;
  }

  static public String longSnippetLink(String id) {
    return tb_mainServer() + "/tb/show-snippet.php?id=" + parseSnippetID(id);
  }

  static public <A, B> B pairB(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public String conceptsFileName() {
    return "concepts.structure.gz";
  }

  static public <A> A waitForVarToBeNotNull(Var<A> v) {
    try {
      synchronized (v) {
        while (!v.has()) v.wait();
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String htitledSectionWithDiv(String title, Object contents, Object... __) {
    String backgroundColor = "#fff";
    String labelStyle = "width: auto; float: top; position: relative; top: -.6em; left:15px; background-color: " + backgroundColor;
    String innerDivStyle = stringPar("innerDivStyle", __);
    String innerDivClass = stringPar("innerDivClass", __);
    String innerDivID = (String) (optPar("innerDivID", __));
    __ = paramsMinus(__, "innerDivStyle", "innerDivID", "innerDivClass");
    return div(htag("label", b("&nbsp;" + title + "&nbsp;"), "style", labelStyle) + div(contents, "style", joinNemptiesWithSemicolon(innerDivStyle, "padding-left: 15px"), "class", joinNemptiesWithSpace("sectionContents", innerDivClass), "id", innerDivID), params_stylePlus("border: 2px solid", __));
  }

  static public <A extends Container> A addAllComponents(final A c, final List<? extends Component> components) {
    if (nempty(components)) {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component x : components) c.add(x);
            revalidate(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component x : components)\r\n      c.add(x);\r\n    revalidate(c);";
        }
      });
    }
    return c;
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public String hscript_clickableRows() {
    return hscript("\r\n    jQuery(document).ready(function($) {\r\n      $(\".clickable-row\").click(function() {\r\n        window.location = $(this).data(\"href\");\r\n      });\r\n    });\r\n  ");
  }

  static public Set<String> tok_allIdentifiers(String s) {
    return new HashSet<String>(filter(__103 -> isIdentifier(__103), javaTokC(s)));
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public String urldecode(String x) {
    try {
      return URLDecoder.decode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public String hinput(String name, Object... params) {
    return htextinput(name, params);
  }

  static public List<String> sortedAlphaNum(Collection<String> c) {
    return sorted(c, new AlphanumComparator());
  }

  static public boolean isLocalSnippet(String snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public boolean isLocalSnippet(long snippetID) {
    return isLocalSnippetID(snippetID);
  }

  static public String nConcepts(long n) {
    return n2(n, "concept");
  }

  static public String nConcepts(Collection l) {
    return nConcepts(l(l));
  }

  static public String nConcepts(Map map) {
    return nConcepts(l(map));
  }

  static public String href(String link, Object contents, Object... params) {
    if (link == null)
      return str(contents);
    return hfulltag("a", contents, arrayPlus(params, "href", link));
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static public String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public Map<String, Pair<String, Map<String, String>>> mechMapCI_cache = synchroMap();

  static public Map<String, String> mechMapCI(String listName) {
    Pair<String, Map<String, String>> p = mechMapCI_cache.get(listName);
    String text = mechList_raw(listName);
    if (p != null && eq(p.a, text))
      return p.b;
    String parsing = first(mechList_opt(listName + " | Parsing"));
    Map<String, String> map;
    if (parsing == null)
      map = parseDoubleArrowMapCI(tlft(text));
    else
      map = asCIMap((Map<String, String>) callMC(parsing, text));
    p = pair(text, map);
    mechMapCI_cache.put(listName, p);
    return p.b;
  }

  static public MetaTransformer defaultMetaTransformer() {
    return metaTransformer_transformableAndList();
  }

  static public List<Pair<Concept.Ref, String>> scanConceptForRefsWithFieldNames(Concept c) {
    List<Pair<Concept.Ref, String>> refs = new ArrayList();
    if (c != null)
      for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet(objectToMap(c))) {
        String field = __0.getKey();
        Object o = __0.getValue();
        if (o instanceof Concept.Ref)
          refs.add(pair(((Concept.Ref) o), field));
        else if (o instanceof Concept.RefL)
          for (int i = 0; i < l(((Concept.RefL) o).l); i++) refs.add(pair((Concept.Ref) ((Concept.RefL) o).l.get(i), field + "[" + (i + 1) + "]"));
      }
    return refs;
  }

  static public String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  static public String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  static public String deAngleBracket(String s) {
    return isAngleBracketed(s) ? dropFirstAndLast(s) : s;
  }

  static public byte[] subByteArray(byte[] b, int start) {
    return subByteArray(b, start, l(b));
  }

  static public byte[] subByteArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public String readerToString(Reader r) {
    try {
      if (r == null)
        return null;
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
    return loadBinaryFilePart(file, 0, maxBytes);
  }

  static public Set<String> hotwire_classesToShare = synchroSet();

  static public Set<String> hotwire_classesToShare() {
    return hotwire_classesToShare;
  }

  static public <A, B, C> List<Pair<A, C>> mapPairsB(IF1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB(f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairsB(Iterable<Pair<A, B>> l, IF1<B, C> f) {
    return mapPairB(l, f);
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public byte[] utf8(String s) {
    return toUtf8(s);
  }

  static public String dummyMainClassName(String progID) {
    return "m" + psI(progID);
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public String hopeningtag(String tag, Map params) {
    return hopeningTag(tag, params);
  }

  static public String hopeningtag(String tag, Object... params) {
    return hopeningTag(tag, params);
  }

  static public List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public Component jrigid() {
    return javax.swing.Box.createRigidArea(new Dimension(0, 0));
  }

  static public IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  static public List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  static public int toLines_nextLineBreak(String s, int start) {
    int n = s.length();
    for (int i = start; i < n; i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  static public Class primitiveToBoxedTypeOpt(Class type) {
    return or(primitiveToBoxedType(type), type);
  }

  static public long sysTime() {
    return sysNow();
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc) {
    return parseStdFunctionsList(snippetSrc, new LinkedHashMap());
  }

  static public Map<String, String> parseStdFunctionsList(String snippetSrc, Map<String, String> map) {
    List<String> tok = javaTok(snippetSrc);
    int i = findCodeTokens(tok, "standardFunctions", "=", "litlist", "(");
    int opening = i + 6;
    int closing = indexOf(tok, ")", opening) - 1;
    for (i = opening + 2; i < closing; i += 4) {
      String[] f = unquote(tok.get(i)).split("/");
      map.put(f[1], f[0]);
    }
    return map;
  }

  static public List<String> tok_integersInOrder(String s) {
    return filter(__104 -> isInteger(__104), javaTokC(s));
  }

  static public String getClientIPFromHeaders(Map<String, String> headers) {
    if (headers == null)
      return null;
    String remoteAddr = (String) (headers.get("remote-addr"));
    String client = (String) (headers.get("x-forwarded-for"));
    if (nempty(client))
      remoteAddr += "," + client;
    return remoteAddr;
  }

  static public <A> A popFirst(List<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(0);
    return a;
  }

  static public <A> A popFirst(Collection<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(a);
    return a;
  }

  static public <A> List<A> popFirst(int n, List<A> l) {
    List<A> part = cloneSubList(l, 0, n);
    removeSubList(l, 0, n);
    return part;
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a) {
    return newObjectArrayOfSameType(a, a.length);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return in == null ? null : bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public int smartIndexOfSpaceEtc(String s) {
    int i = indexOfSpaceEtc(s);
    return i < 0 ? l(s) : i;
  }

  static public <A, B> List<B> secondOfPairs(Collection<Pair<A, B>> l) {
    return lambdaMap(__105 -> secondOfPair(__105), l);
  }

  static public String unicode_crossProduct() {
    return unicodeFromCodePoint(0x2A2F);
  }

  static public Object rcurry(final Object f, final Object arg) {
    int n = numberOfFunctionArguments(f);
    if (n == 0)
      throw fail("function takes no arguments");
    if (n == 1)
      return new F0() {

        public Object get() {
          return callF(f, arg);
        }
      };
    if (n == 2)
      return new F1() {

        public Object get(Object a) {
          return callF(f, a, arg);
        }
      };
    throw todo("currying a function with " + n + "arguments");
  }

  static public boolean preciseCall_debug = false;

  static public Object preciseCall(Object o, String method, Object... args) {
    try {
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        Lowest<Method> best = new Lowest();
        if (methods != null)
          for (Method m : methods) {
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            int score = methodApplicabilityScore(m, args);
            if (score < Integer.MAX_VALUE) {
              if (preciseCall_debug)
                print("Method score: " + m + " " + score);
              best.put(m, score);
            }
          }
        Method m = best.get();
        if (m != null)
          return invokeMethod(m, null, args);
        return call_withVarargs(((Class) o), method, args);
      } else
        throw todo();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<A, B> onlyKeys(Map<A, B> map, Collection<A> keys) {
    Set<A> keySet = asSet(keys);
    return filterKeys(map, a -> contains(keySet, a));
  }

  static public <A, B> Map<A, B> onlyKeys(Map<A, B> map, A... keys) {
    return onlyKeys(map, litset(keys));
  }

  static public CountryDialCode countryDialCodeByCountryCode(String countryCode) {
    return objectWhere(countryDialCodes(), "countryCode", upper(countryCode));
  }

  static public int maxStringLength(Collection<String> l) {
    int n = 0;
    if (l != null)
      for (String s : l) n = max(n, l(s));
    return n;
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public double fraction(double d) {
    return d % 1;
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A> A getWeakRef(Reference<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public void ensureConceptClassIsIndexed(Class<? extends Concept> c) {
    ensureConceptClassIsIndexed(db_mainConcepts(), c);
  }

  static public void ensureConceptClassIsIndexed(Concepts cc, Class<? extends Concept> c) {
    if (cc != null && c != null && !isConceptClassIndexed(cc, c))
      indexRandomConceptField(cc, c);
  }

  static public void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  static public void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  static public <A> boolean syncEmpty(Collection<A> l) {
    if (l == null)
      return true;
    synchronized (l) {
      return l.isEmpty();
    }
  }

  static public void messageBox(final String msg) {
    if (headless())
      print(msg);
    else {
      swing(new Runnable() {

        public void run() {
          try {
            JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MES...";
        }
      });
    }
  }

  static public void messageBox(Throwable e) {
    printStackTrace(e);
    messageBox(hideCredentials(innerException2(e)));
  }

  static public Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  static public String actualProgramID() {
    return programID();
  }

  static public <A> List<A> sortByCalculatedField(Iterable<A> c, final Object f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(callF(f, a), callF(f, b));
      }
    });
    return l;
  }

  static public <A extends Concept> List<A> findBackRefs(Collection<? extends Concept> concepts, Class<A> type) {
    IdentityHashMap<A, Boolean> l = new IdentityHashMap();
    for (Concept c : concepts) if (c.backRefs != null)
      for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
        l.put((A) r.concept(), true);
    return asList(keys(l));
  }

  static public <A extends Concept> List<A> findBackRefs(Concept c, Class<A> type) {
    IdentityHashMap<A, Boolean> l = new IdentityHashMap();
    if (c != null && c.backRefs != null)
      for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
        l.put((A) r.concept(), true);
    return asList(keys(l));
  }

  static public <A extends Concept> List<A> findBackRefs(Class<A> type, Concept c) {
    return findBackRefs(c, type);
  }

  static public Collection<Concept> findBackRefs(Concept c) {
    return findBackRefs(c, Concept.class);
  }

  static public <A, B> List<A> keysWithoutHidden(Map<A, B> map) {
    return filter(keys(map), new F1<Object, Boolean>() {

      public Boolean get(Object o) {
        try {
          return !eq(o, "[hidden]") && !isStringStartingWith(o, "[hidden] ");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "!eq(o, \"[hidden]\") && !isStringStartingWith(o, \"[hidden] \")";
      }
    });
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public List<String> nempties(Collection<String> c) {
    return filterNempty(c);
  }

  static public Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  static public List<String> sortedAlphanumIC(Collection<String> c) {
    List<String> l = cloneList(c);
    Collections.sort(l, alphaNumComparatorIC());
    return l;
  }

  static public AutoCloseable temp_printPrefix(String prefix) {
    Object oldValue = print_byThread();
    print_setPrefixForThread(prefix);
    return new AutoCloseable() {

      public String toString() {
        return "print_byThread().set(oldValue);";
      }

      public void close() throws Exception {
        print_byThread().set(oldValue);
      }
    };
  }

  static public <A extends JComponent> A componentPopupMenuItem(A c, final String name, final Object action) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, name, action);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, action);";
      }
    });
    return c;
  }

  static public void componentPopupMenuItem(JComponent c, final JMenuItem menuItem) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, menuItem);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, menuItem);";
      }
    });
  }

  static public JInternalFrame showForm_makeInternalFrame(JDesktopPane desktop, String title, JPanel panel) {
    JInternalFrame f = addInternalFrame(desktop, title, withMargin(panel));
    minInternalFrameWidth(f, 400);
    packInternalFrameVertically(f);
    centerInternalFrame(f);
    return f;
  }

  static public String htmlEncode_nlToBR(String s) {
    return htmlEncode_nlToBr(s);
  }

  static public <A> int nfilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(pred, c);
  }

  static public <A> int nfilter(IF1<A, Boolean> pred, Iterable<A> c) {
    int n = 0;
    if (c != null)
      for (A o : c) if (pred.get(o))
        ++n;
    return n;
  }

  static public int nfilter(Iterable c, Object pred) {
    int n = 0;
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        ++n;
    return n;
  }

  static public int nfilter(Object pred, Iterable c) {
    return nfilter(c, pred);
  }

  static public File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public class allSpreads_Data {

    public int n;

    public List<Integer> collecting;
  }

  static public class allSpreads_StackEntry {

    public int remaining, take;

    public int position;

    public Object step(List<allSpreads_StackEntry> stack, allSpreads_Data d) {
      if (position == 0) {
        if (l(d.collecting) >= d.n - 1) {
          List<Integer> result = listPlus(d.collecting, remaining);
          popLast(stack);
          return result;
        }
        position++;
      }
      if (position == 1) {
        if (take <= remaining) {
          d.collecting.add(take);
          allSpreads_StackEntry e = new allSpreads_StackEntry();
          e.remaining = remaining - take;
          stack.add(e);
          position++;
        } else
          popLast(stack);
      } else if (position == 2) {
        removeLast(d.collecting);
        take++;
        position = 1;
      }
      return null;
    }
  }

  static public IterableIterator<List<Integer>> allSpreads(final int toSpread, final int buckets) {
    final allSpreads_Data d = new allSpreads_Data();
    d.n = buckets;
    d.collecting = new ArrayList();
    final List<allSpreads_StackEntry> stack = new ArrayList();
    allSpreads_StackEntry e = new allSpreads_StackEntry();
    e.remaining = toSpread;
    stack.add(e);
    return iff(new F0<Object>() {

      public Object get() {
        try {
          while (nempty(stack)) {
            ping();
            {
              Object __1 = last(stack).step(stack, d);
              if (__1 != null)
                return __1;
            }
          }
          return endMarker();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "while (nempty(stack)) {\r\n      ping();\r\n      try object last(stack).step(sta...";
      }
    });
  }

  static public boolean mmo2_matchWithTypos(String pattern, String s) {
    return mmo2_matchWithTypos(pattern, s, 1);
  }

  static public boolean mmo2_matchWithTypos(String pattern, String s, int maxTypos) {
    return mmo2_matchWithTypos(mmo2_parsePattern(pattern), s, maxTypos);
  }

  static public boolean mmo2_matchWithTypos(MMOPattern pattern, String s) {
    return mmo2_matchWithTypos(pattern, s, 1);
  }

  static public boolean mmo2_matchWithTypos(MMOPattern pattern, String s, int maxTypos) {
    if (maxTypos == 0)
      return mmo2_match(pattern, s);
    Integer score = mmo2_levenWithSwapsScore(pattern, s);
    return score != null && score <= maxTypos;
  }

  static public int tok_findEndOfStatement(List<String> tok, int i) {
    if (eq(get(tok, i), "{"))
      return findEndOfBlock(tok, i);
    int j = i;
    boolean special = false;
    while (j < l(tok) && neq(tok.get(j), ";")) {
      String t = get(tok, j);
      if (eqOneOf(t, "for", "if"))
        special = true;
      if (eqOneOf(t, "{", "(")) {
        j = findEndOfBracketPart(tok, j) + 1;
        if (special && eq(t, "{"))
          return j - 1;
      } else
        j += 2;
    }
    return j + 1;
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component c : unnullForIteration(b)) if (c != null)
              a.add(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component c : unnullForIteration(b))\r\n      if (c != null) \r\n        a.a...";
        }
      });
    }
  }

  static public <A> Pair<A, Integer> stringTreeLeafValue2(StringTree2<A> tree, List<String> items) {
    int i = 0;
    while (tree != null && i < l(items)) {
      if (tree.leafValue != null)
        return pair(tree.leafValue, i);
      tree = tree.children.get(items.get(i));
      ++i;
    }
    return null;
  }

  static public <A> ArrayList<A> cloneList_noSync(Iterable<A> l) {
    return l instanceof Collection ? cloneList_noSync((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList_noSync(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    return new ArrayList<A>(l);
  }

  static public String tok_javaDropCommentsFromWhitespace(String s) {
    int l = l(s), j = 0;
    StringBuilder buf = new StringBuilder();
    while (j < l) {
      char c = s.charAt(j);
      char d = j + 1 >= l ? '\0' : s.charAt(j + 1);
      if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
        j = Math.min(j + 2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else {
        buf.append(c);
        ++j;
      }
    }
    return str(buf);
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public JPanel customLayoutPanel(final Object layouter) {
    return jpanel(layoutManagerFromFunction(layouter));
  }

  static public JPanel customLayoutPanel(final Object layouter, final List<? extends Component> components) {
    return addAllComponents(customLayoutPanel(layouter), components);
  }

  static public int syncL(Collection l) {
    if (l == null)
      return 0;
    synchronized (collectionMutex(l)) {
      return l.size();
    }
  }

  static public int syncL(Map map) {
    if (map == null)
      return 0;
    synchronized (collectionMutex(map)) {
      return map.size();
    }
  }

  static public <A> List<A> syncL() {
    return syncList();
  }

  static public Map safeUnstructureMap(String s) {
    return (Map) safeUnstructure(s);
  }

  static public <A> void syncClear(Collection<A> c) {
    if (c != null)
      synchronized (collectionMutex(c)) {
        c.clear();
      }
  }

  static public void syncClear(Map map) {
    if (map != null)
      synchronized (collectionMutex(map)) {
        map.clear();
      }
  }

  static public String htextarea(String text, Object... params) {
    params = html_massageAutofocusParam(params);
    return hopeningTag("textarea", params) + htmlencode2(text) + "</textarea>";
  }

  static public String hhead(Object contents) {
    return tag("head", contents);
  }

  static public int hashOfLong(long l) {
    return Long.hashCode(l);
  }

  static public List<String> splitCamelCase(String s) {
    return ai_splitCamelCase(s);
  }

  static public long toLong(Object o) {
    if (o instanceof Number)
      return ((Number) o).longValue();
    if (o instanceof String)
      return parseLong((String) o);
    return 0;
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public File copyFileToClipboard(File f) {
    if (f == null)
      return null;
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new FileTransferable(f), null);
    vmBus_send("newClipboardContents", f);
    return f;
  }

  static public String localTimeWithSeconds(long time) {
    return simpleDateFormat_local("HH:mm:ss").format(time);
  }

  static public String localTimeWithSeconds() {
    return localTimeWithSeconds(now());
  }

  static public void indexRandomConceptField(Class<? extends Concept> c) {
    indexRandomConceptField(db_mainConcepts(), c);
  }

  static public void indexRandomConceptField(Concepts cc, Class<? extends Concept> c) {
    String field = or(first(conceptFields(c)), "_dummy");
    print("Indexing " + c + "." + field);
    indexConceptField(cc, c, field);
    assertTrue("Concept class indexed", isConceptClassIndexed(cc, c));
    {
      long _startTime_0 = sysNow();
      try {
        print("Got " + nConcepts(countConcepts(cc, c)));
      } finally {
        _startTime_0 = sysNow() - _startTime_0;
        saveTiming(_startTime_0);
      }
    }
  }

  static public Class<?> hotwireSharingLibraries_silently(String progID) {
    AutoCloseable __1 = temp_loadPage_silent();
    try {
      return hotwireSharingLibraries(progID);
    } finally {
      _close(__1);
    }
  }

  static public String htmlEncode_nlToBr(String s) {
    return nlToBr(htmlEncode2(s));
  }

  static public List mapNonNulls(Iterable l, Object f) {
    return mapNonNulls(f, l);
  }

  static public List mapNonNulls(Object f, Iterable l) {
    List x = new ArrayList();
    if (l != null)
      for (Object o : l) addIfNotNull(x, callF(f, o));
    return x;
  }

  static public List mapNonNulls(Object f, Object[] l) {
    List x = new ArrayList();
    if (l != null)
      for (Object o : l) addIfNotNull(x, callF(f, o));
    return x;
  }

  static public <A, B> List<B> mapNonNulls(Iterable<A> l, F1<A, B> f) {
    return mapNonNulls(f, l);
  }

  static public <A, B> List<B> mapNonNulls(F1<A, B> f, Iterable<A> l) {
    List x = new ArrayList();
    if (l != null)
      for (Object o : l) addIfNotNull(x, callF(f, o));
    return x;
  }

  static public <A, B> List<B> mapNonNulls(A[] l, IF1<A, B> f) {
    return mapNonNulls(f, l);
  }

  static public <A, B> List<B> mapNonNulls(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) addIfNotNull(x, f.get(o));
    return x;
  }

  static public <A, B> List<B> mapNonNulls(IF1<A, B> f, Iterable<A> l) {
    return mapNonNulls(l, f);
  }

  static public String hjs_selectize() {
    return "\r\n    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js\" integrity=\"sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=\" crossorigin=\"anonymous\"></script>\r\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css\" integrity=\"sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=\" crossorigin=\"anonymous\" />\r\n  ";
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public long fileSize(String path) {
    return getFileSize(path);
  }

  static public long fileSize(File f) {
    return getFileSize(f);
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isInQ(Q q) {
    return q != null && isCurrentThread(q.rst.thread);
  }

  static public int countTokens(String s) {
    return l(javaTokC(s));
  }

  static public int countTokens(List<String> tok) {
    return l(tok) / 2;
  }

  static public String h3_htitle(String s) {
    return htitle(s) + h3(s);
  }

  static public boolean isMainProgram() {
    return creator() == null;
  }

  static public Random defaultRandomGenerator() {
    return ThreadLocalRandom.current();
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public void printConceptIndices() {
    printConceptIndices(db_mainConcepts());
  }

  static public void printConceptIndices(Concepts cc) {
    if (cc == null)
      return;
    Set<Class<? extends Concept>> classes = joinSets(keys(cc.fieldIndices), keys(cc.ciFieldIndices));
    print(n2(classes, "indexed class", "indexed classes") + ".");
    for (Class<? extends Concept> c : classes) {
      print("Indices on " + c + ":");
      for (Map.Entry<? extends String, ? extends IFieldIndex> __1 : _entrySet(cc.fieldIndices.get(c))) {
        String field = __1.getKey();
        IFieldIndex idx = __1.getValue();
        print("  " + field + ": " + idx);
      }
      for (Map.Entry<? extends String, ? extends IFieldIndex> __0 : _entrySet(cc.ciFieldIndices.get(c))) {
        String field = __0.getKey();
        IFieldIndex idx = __0.getValue();
        print("  " + field + " [case-insensitive]: " + idx);
      }
    }
  }

  static public <A, B, C extends Collection<B>> MultiMap<A, B> mapToMultiMap(Map<A, C> map) {
    if (map == null)
      return null;
    MultiMap<A, B> mm = similarEmptyMultiMap(map);
    for (Map.Entry<? extends A, ? extends Collection<B>> __0 : _entrySet(map)) {
      A key = __0.getKey();
      Collection<B> values = __0.getValue();
      mm.putAll(key, values);
    }
    return mm;
  }

  static public String unicode_smallDownPointingTriangle() {
    return charToString(0x25BE);
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public String renderVars(Object... params) {
    return renderVars_str(params);
  }

  static public String ahref_possiblyTargetBlank(String link, Object contents, boolean targetBlank, Object... params) {
    return ahref(link, contents, targetBlank ? paramsPlus(params, "target", "_blank") : params);
  }

  static public String ahref_possiblyTargetBlank(boolean targetBlank, String link, Object contents, Object... params) {
    return ahref_possiblyTargetBlank(link, contents, targetBlank, params);
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static public int imageIcon_cacheSize = 10;

  static public boolean imageIcon_verbose = false;

  static public Map<String, ImageIcon> imageIcon_cache;

  static public Lock imageIcon_lock = lock();

  static public ThreadLocal<Boolean> imageIcon_fixGIF = new ThreadLocal();

  static public ImageIcon imageIcon(String imageID) {
    try {
      if (imageID == null)
        return null;
      Lock __0 = imageIcon_lock;
      lock(__0);
      try {
        if (imageIcon_cache == null)
          imageIcon_cache = new MRUCache(imageIcon_cacheSize);
        imageID = fsI(imageID);
        ImageIcon ii = imageIcon_cache.get(imageID);
        if (ii == null) {
          if (imageIcon_verbose)
            print("Loading image icon: " + imageID);
          File f = loadBinarySnippet(imageID);
          Boolean b = imageIcon_fixGIF.get();
          if (!isFalse(b))
            ii = new ImageIcon(loadBufferedImageFixingGIFs(f));
          else
            ii = new ImageIcon(f.toURI().toURL());
        } else
          imageIcon_cache.remove(imageID);
        imageIcon_cache.put(imageID, ii);
        return ii;
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(File f) {
    try {
      return new ImageIcon(f.toURI().toURL());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(Image img) {
    return new ImageIcon(img);
  }

  static public ImageIcon imageIcon(RGBImage img) {
    return imageIcon(img.getBufferedImage());
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
    return concepts.countConcepts(c, params);
  }

  static public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    return db_mainConcepts().countConcepts(c, params);
  }

  static public int countConcepts() {
    return db_mainConcepts().countConcepts();
  }

  static public int countConcepts(String className) {
    return db_mainConcepts().countConcepts(className);
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, String className) {
    return concepts.countConcepts(className);
  }

  static public int countConcepts(Concepts concepts) {
    return concepts.countConcepts();
  }

  static public String hPopDownButtonWithText(String text, String... entries) {
    return (empty(text) ? "" : text + " ") + hPopDownButton(entries);
  }

  static public String hPopDownButtonWithText(String text, Collection<String> entries) {
    return hPopDownButtonWithText(text, asStringArray(entries));
  }

  static public String dropPrefixTrim(String prefix, String s) {
    return trim(dropPrefix(prefix, s));
  }

  static public double elapsedSeconds(long time) {
    return toSeconds(sysNow() - time);
  }

  static public String hmsWithColons() {
    return hmsWithColons(now());
  }

  static public String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  static public void consoleFont(Font font) {
    callOpt(getConsoleTextArea_gen(), "setFont", font);
  }

  static public void printStructs(Object... params) {
    print(renderStructs(params));
  }

  static public <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
    return lookupAllOpt(map, l);
  }

  static public <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public <A, B extends IF0<A>> List<A> getAll(Iterable<B> l) {
    return getVars(l);
  }

  static public Map<Component, String> componentID_map = weakHashMap();

  static public String componentID(Component c) {
    return c == null ? null : componentID_map.get(c);
  }

  static public Object[] params_stylePlus(Map params, String style) {
    return paramsPlus(params, "style", joinNemptiesWithSemicolon(stringPar("style", params), style));
  }

  static public Object[] params_stylePlus(Object[] params, String style) {
    return paramsPlus(params, "style", joinNemptiesWithSemicolon(stringPar("style", params), style));
  }

  static public Object[] params_stylePlus(String style, Object... params) {
    return params_stylePlus(params, style);
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long timestampFromYMDH(int y, int m, int d, int h) {
    return new GregorianCalendar(y, m - 1, d, h, 0).getTimeInMillis();
  }

  static public void onEnterIfTextField(Component c, Object action) {
    if (action == null)
      return;
    if (c instanceof JTextField)
      onEnter((JTextField) c, action);
    else if (c instanceof JComboBox)
      onEnter((JComboBox) c, action);
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public <A> A heldInstance(Class<A> c) {
    List<Object> l = holdInstance_l.get();
    for (int i = l(l) - 1; i >= 0; i--) {
      Object o = l.get(i);
      if (isInstanceOf(o, c))
        return (A) o;
    }
    throw fail("No instance of " + className(c) + " held");
  }

  static public String firstJavaToken(String s) {
    if (s == null)
      return null;
    int l = s.length();
    int j = 0;
    char c, d;
    while (j < l) {
      c = s.charAt(j);
      d = j + 1 >= l ? '\0' : s.charAt(j + 1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
        j = Math.min(j + 2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    if (j >= l)
      return null;
    int i = j;
    c = s.charAt(i);
    d = i + 1 >= l ? '\0' : s.charAt(i + 1);
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j + 1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L')
        ++j;
    } else if (c == '[' && d == '[') {
      do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
      j = Math.min(j + 2, l);
    } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
      do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
      j = Math.min(j + 3, l);
    } else
      ++j;
    return quickSubstring(s, i, j);
  }

  static public String fromUTF8(byte[] bytes) {
    return fromUtf8(bytes);
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    return classForName(name, null);
  }

  static public Class classForName(String name, Object classFinder) {
    if (classForName_cache == null || classFinder != null)
      return classForName_uncached(name, classFinder);
    Class c = classForName_cache.get(name);
    if (c == null)
      classForName_cache.put(name, c = classForName_uncached(name, null));
    return c;
  }

  static public Class classForName_uncached(String name, Object classFinder) {
    try {
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String hjavascript_src_snippet(String snippetID, Object... __) {
    return hfulltag("script", "", paramsPlus(__, "src", snippetRawURL(snippetID, "text/javascript")));
  }

  static public <A extends JComponent> A makeBold(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));";
        }
      });
    }
    return c;
  }

  static public String tok_packageName(List<String> tok) {
    int i = jfind(tok, "package");
    if (i < 0)
      return "";
    i += 2;
    int j = jfind(tok, i, ";");
    if (j < 0)
      return "";
    return join(codeTokensOnly(subList(tok, i - 1, j)));
  }

  static public String tok_packageName(String src) {
    Producer<String> p = javaTokC_producer(src);
    String t = p.next();
    if (!eq(t, "package"))
      return "";
    StringBuilder buf = new StringBuilder();
    while (!eqOneOf(t = p.next(), null, ";")) buf.append(t);
    return str(buf);
  }

  static public int countWordsWithoutAngleBracketedAndStars(String s) {
    int n = 0;
    for (String t : javaTokWithAllPlusAngleBracketsC(s)) if (!isAngleBracketed(t) && !eq(t, "*"))
      ++n;
    return n;
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public String hjavascript(String scriptOrURL, Object... __) {
    if (isRelativeOrAbsoluteURL(scriptOrURL) && !startsWithOneOf(scriptOrURL, "//", "/*"))
      return hjavascript_src(scriptOrURL, __);
    else
      return tag("script", scriptOrURL, paramsPlus(__, "type", "text/javascript"));
  }

  static public boolean isClosingBracket(String s) {
    return eqOneOf(s, ")", "}", "]");
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public Map<String, String> parseEqualsProperties(String text) {
    return parseEqualsProperties(text, new HashMap());
  }

  static public Map<String, String> parseEqualsProperties(String text, Map<String, String> map) {
    for (String s : tlft(text)) {
      int i = indexOf(s, '=');
      if (i > 0)
        map.put(trimSubstring(s, 0, i), trimSubstring(s, i + 1));
    }
    return map;
  }

  static public String nItems(long n) {
    return n2(n, "item");
  }

  static public String nItems(Collection l) {
    return nItems(l(l));
  }

  static public String nItems(Map map) {
    return nItems(l(map));
  }

  static public boolean zipContainsFile(File inZip, String fileName) {
    try {
      ZipFile zip = new ZipFile(inZip);
      try {
        return zip.getEntry(fileName) != null;
      } finally {
        _close(zip);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setFieldToSingleMethodProxy(Object o, String field, Object target, String methodName) {
    if (o == null || target == null)
      return;
    Class type = fieldType(o, field);
    if (type == null)
      throw fail("Field " + field + " not found in " + className(o));
    set(o, field, singleObjectMethodProxy(type, target, methodName));
  }

  static public Object[] prependParamIfOddCount(Object x, Object[] params) {
    if (odd(l(params)))
      return itemPlusObjectArray(x, params);
    return params;
  }

  static public <A> List<A> objectsWhereNotIC(Collection<A> c, Object... data) {
    if (c == null)
      return null;
    List<A> l = new ArrayList();
    for (A x : c) if (!checkFieldsIC(x, data))
      l.add(x);
    return l;
  }

  static public List<Field> nonStaticNonTransientFieldObjects(Object o) {
    if (o == null)
      return null;
    List<Field> fields = new ArrayList();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(makeAccessible(f));
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public String _className(Object o) {
    return className(o);
  }

  static public Set<String> isThreadRunnable_x_exclude = lithashset("Java.lang.Thread.start0", "java.lang.Object.wait", "java.net.Inet6AddressImpl.lookupAllHostAddr", "java.io.FileInputStream.readBytes", "jdk.internal.misc.Unsafe.park", "sun.misc.Unsafe.park", "java.net.SocketInputStream.socketRead0", "java.net.PlainSocketImpl.socketConnect", "java.net.PlainSocketImpl.socketAccept", "sun.awt.X11.XToolkit.waitForEvents", "java.net.DualStackPlainSocketImpl.accept0", "org.jnativehook.GlobalScreen$NativeHookThread.enable", "java.lang.Thread.sleep", "sun.nio.ch.EPollArrayWrapper.epollWait", "com.ibm.lang.management.internal.MemoryNotificationThread.processNotificationLoop", "com.ibm.tools.attach.target.IPC.waitSemaphore", "sun.nio.ch.Net.poll", "sun.nio.ch.Net.accept", "sun.nio.ch.Net.connect0", "sun.nio.ch.EPoll.wait", "sun.nio.ch.SocketDispatcher.read0", "sun.nio.fs.LinuxWatchService.poll", "java.lang.ref.Reference.waitForReferencePendingList", "com.sun.java.accessibility.internal.AccessBridge.runDLL", "java.lang.ProcessHandleImpl.waitForProcessExit0");

  static public boolean isThreadRunnable_x(Thread t, StackTraceElement[] trace) {
    {
      Boolean __1 = (Boolean) vmBus_query("isThreadRunnable_x", t, trace);
      if (__1 != null)
        return __1;
    }
    if (t.getState() != Thread.State.RUNNABLE)
      return false;
    StackTraceElement e = first(trace);
    if (e == null)
      return false;
    String s = e.getClassName() + "." + e.getMethodName();
    return !isThreadRunnable_x_exclude.contains(s);
  }

  static public <A extends Concept> A replaceConceptAndUpdateRefs(Concept a, A b) {
    assertTrue("object to replace with must be unlisted", isUnlisted(b));
    Concepts cc = a.concepts();
    assertTrue("object to replace must be listed", cc != null);
    List<Concept.Ref> refs = allBackRefObjects(a);
    b.id = a.id;
    deleteConcept(a);
    cc.register_phase2(b);
    cset(a, "meta_migratedTo", b);
    for (Concept.Ref ref : refs) ref.set(b);
    return b;
  }

  static public void stepAll(Steppable s) {
    if (s != null)
      while (s.step()) {
        ping();
      }
  }

  static public String yesNo2(Boolean b) {
    return eq(b, true) ? "Yes" : eq(b, false) ? "No" : "Unknown";
  }

  static public boolean isInAnonymousClass(Object o) {
    if (o == null)
      return false;
    return isAnonymousClassName(className(o));
  }

  static public boolean isInstanceOfAny(Object o, Collection<Class> b) {
    return any(b, x -> isInstanceOf(o, x));
  }

  static public boolean isInstanceOfAny(Object o, Class... b) {
    return any(b, x -> isInstanceOf(o, x));
  }

  static public String afterDollar(String s) {
    return substring(s, smartIndexOf(s, '$') + 1);
  }

  static public String shortDynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    return shortClassName(o);
  }

  static public Set<String> collectAngleBracketVars(String s) {
    return collectAngleBracketVars(javaTokWithAngleBrackets(s));
  }

  static public Set<String> collectAngleBracketVars(List<String> tok) {
    Set<String> set = ciSet();
    for (int i = 0; i < l(tok); i++) if (isAngleBracketVar(tok.get(i)))
      set.add(deAngleBracket(tok.get(i)));
    return set;
  }

  static public int identityHash(Object o) {
    return identityHashCode(o);
  }

  static public long regexpToLongIC(String regexp, String input) {
    return parseLong(regexpFirstGroupIC(regexp, input));
  }

  static public int countWhereCI(Collection c, Object... data) {
    int n = 0;
    if (c != null)
      for (Object x : c) if (checkFieldsIC(x, data))
        ++n;
    return n;
  }

  static public int toIntOpt(Object o) {
    return toIntOpt(o, 0);
  }

  static public int toIntOpt(Object o, int defaultValue) {
    if (o == null)
      return defaultValue;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseIntOpt((String) o);
    return defaultValue;
  }

  static public Object callWithEnter(Object o, String method, String[] arg) {
    return callWithEnter(o, method, new Object[] { arg });
  }

  static public Object callWithEnter(Object o, String method, Object... args) {
    if (o == null)
      return null;
    AutoCloseable __1 = tempEnter(o);
    try {
      return call_withVarargs(o, method, args);
    } finally {
      _close(__1);
    }
  }

  static public String regexpReplace_directWithRefs(String s, String pat, String replacement) {
    Matcher m = regexp(pat, s);
    return regexpReplace_direct(m, replacement);
  }

  static public String regexpReplace_directWithRefs(Matcher m, String replacement) {
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, replaceDollarVars2_dyn(replacement, v -> !isInteger(v) ? null : matcherGroup(m, parseInt(v))));
    m.appendTail(buf);
    return str(buf);
  }

  static public boolean dirOrZipContainsPath(File location, String subPath) {
    try {
      if (location.isDirectory()) {
        return new File(location, subPath).exists();
      } else if (location.isFile()) {
        return zipFileContains_falseOnError(location, subPath);
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> regexpExtractGroups(String pat, String s) {
    return regexpFirstGroups(pat, s);
  }

  static public long lastTiming() {
    return getLastTiming();
  }

  static public <A> List<A> removeAndReturnCollection(List<A> l, int i) {
    remove(l, i);
    return l;
  }

  static public <A, B extends Collection<A>> B removeAndReturnCollection(B l, A a) {
    remove(l, a);
    return l;
  }

  static public Map conceptShadow_rawMap(Concept c) {
    if (c == null)
      return null;
    Map map = objectToMap_nonTransient(c);
    map.remove("refs");
    map.remove("backRefs");
    map.remove("fieldValues");
    map.put(":class", getClassName(c));
    return map;
  }

  static public Object rcallOpt(String method, Object o, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public void dm_requireSnippetUpdatesModule() {
    if (!dm_subOSConnectorToChannel("snippetUpdates"))
      dm_requireModule("#1019239/SnippetUpdates");
  }

  static public String htmlEncode2_str(Object o) {
    return htmlEncode2_gen(o);
  }

  static public String vmClassNameToSubPath(String className) {
    return empty(className) ? null : replace(className, ".", "/") + ".class";
  }

  static public <A, B> Map<A, B> immutableEmptyMap() {
    return Collections.emptyMap();
  }

  static public void dm_reloadModuleInBackground(Object module) {
    dm_callOS("reloadModuleInBackground", dm_getStem(module));
  }

  static public void dm_reloadModuleInBackground() {
    dm_reloadModuleInBackground(dm_current_mandatory_generic());
  }

  static public ThreadLocal<Boolean> poorMansProfiling_renderFullResults_backwards = new ThreadLocal();

  static public String poorMansProfiling_renderFullResults(final MultiSet<String> traces) {
    int samples = poorMansProfiling_samples;
    boolean backwards = isTrue(getAndClearThreadLocal(poorMansProfiling_renderFullResults_backwards));
    final int n = traces.size();
    int percent = ratioToIntPercent(l(traces), samples);
    return (samples == 0 ? "Nothing sampled" : percent + "% core activity [" + n2(samples, "sample") + " taken]") + "\n\n" + joinMap(backwards ? traces.lowestFirst() : traces.highestFirst(), new F1<String, Object>() {

      public Object get(String trace) {
        try {
          return traces.get(trace) + "/" + n + "\n" + trace + "\n\n";
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "traces.get(trace) + \"/\" + n + \"\\n\" + trace + \"\\n\\n\"";
      }
    });
  }

  static public String unicode_thumbsUp() {
    return unicodeFromCodePoint(0x1F44D);
  }

  static public <A extends Concept> A ccopyFields_withConverter(Concept x, A y, String... fields) {
    if (x == null || y == null)
      return y;
    if (empty(fields)) {
      for (String field : conceptFields(x)) cSmartSetField_withConverter(y, field, cget(x, field));
    } else
      for (String field : fields) {
        Object o = cget(x, field);
        if (o != null)
          cSmartSetField_withConverter(y, field, o);
      }
    return y;
  }

  static public <A, B> Map<B, A> mapToKeys(Iterable<A> l, IF1<A, B> f) {
    if (l == null)
      return null;
    HashMap<B, A> map = new HashMap();
    for (A a : l) map.put(f.get(a), a);
    return map;
  }

  static public <A, B> Map<B, A> mapToKeys(IF1<A, B> f, Iterable<A> l) {
    return mapToKeys(l, f);
  }

  static public String format_quoteAll(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTok(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, quote(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public Map putKeysFirst(Map map, Object... keys) {
    Map m2 = litorderedmap();
    Map remaining = cloneMap(map);
    for (Object key : keys) {
      if (remaining.containsKey(key)) {
        m2.put(key, remaining.get(key));
        remaining.remove(key);
      }
    }
    m2.putAll(remaining);
    return m2;
  }

  static public Map putKeysFirst(List keys, Map map) {
    return putKeysFirst(map, toObjectArray(keys));
  }

  static public String lastTiming_formatted() {
    return renderElapsedTimePleasantly(lastTiming());
  }

  static public Object callOptWithEnter(Object o, String method, String[] arg) {
    return callOptWithEnter(o, method, new Object[] { arg });
  }

  static public Object callOptWithEnter(Object o, String method, Object... args) {
    if (o == null)
      return null;
    AutoCloseable __1 = tempEnter(o);
    try {
      return callOpt_withVarargs(o, method, args);
    } finally {
      _close(__1);
    }
  }

  static public Class findClassThroughDefaultClassFinder(String shortName) {
    return shortName == null ? null : (Class) callF(_defaultClassFinder(), "main$" + shortName);
  }

  static public void runInQAndWait(Q q, Runnable r) {
    if (r == null)
      return;
    if (isInQ(q)) {
      callF(r);
      return;
    }
    final Flag done = new Flag();
    final Var<Throwable> error = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            callF(r);
          } catch (Throwable e) {
            error.set(e);
          } finally {
            done.raise();
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      callF(r);\r\n    } catch (Throwable e) {\r\n      error.set(e);\r\n   ...";
      }
    });
    done.waitUntilUp();
    if (error.has())
      throw rethrow(error.get());
  }

  static public List<Concept.Ref> allBackRefObjects(Concept c) {
    return cloneList(c == null ? null : c.backRefs);
  }

  static public List<CreatedDeletedChanged<ConceptShadow>> diffConceptShadows(List<ConceptShadow> l1, List<ConceptShadow> l2) {
    List<CreatedDeletedChanged<ConceptShadow>> diffs = new ArrayList();
    int i1 = 0, i2 = 0;
    while (i1 < l(l1) && i2 < l(l2)) {
      ConceptShadow s1 = l1.get(i1), s2 = l2.get(i2);
      long id1 = s1.id(), id2 = s2.id();
      if (id1 < id2) {
        diffs.add(new CreatedDeletedChanged.Deleted(s1));
        ++i1;
      } else if (id1 > id2) {
        diffs.add(new CreatedDeletedChanged.Created(s2));
        ++i2;
      } else {
        if (!eq(s1, s2))
          diffs.add(new CreatedDeletedChanged.Changed(s1, s2));
        ++i1;
        ++i2;
      }
    }
    while (i1 < l(l1)) diffs.add(new CreatedDeletedChanged.Deleted(l1.get(i1++)));
    while (i2 < l(l2)) diffs.add(new CreatedDeletedChanged.Created(l2.get(i2++)));
    return diffs;
  }

  static public boolean addByteCodePathToClassLoader(ClassLoader cl, File bytecode) {
    try {
      print("Adding byte code path " + bytecode + " to " + cl);
      return isTrue(call(cl, "addFile", bytecode));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<ConceptShadow> allConceptShadows() {
    return allConceptShadows(db_mainConcepts());
  }

  static public List<ConceptShadow> allConceptShadows(Concepts cc) {
    if (cc == null)
      return null;
    List<Concept> l = asList(cc.allConcepts());
    assertTrue("Concepts are sorted by id", isSortedListByCalculatedField(__106 -> conceptID(__106), l));
    return lmap(__107 -> conceptShadow(__107), l);
  }

  static public boolean hasMethodNamed(Object obj, String method) {
    if (obj == null)
      return false;
    if (obj instanceof Class)
      return hasMethodNamed((Class) obj, method);
    return hasMethodNamed(obj.getClass(), method);
  }

  static public boolean hasMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method))
        return true;
      c = c.getSuperclass();
    }
    return false;
  }

  static public int minUnlessMinus1(int a, int b) {
    return a == -1 ? b : b == -1 ? a : min(a, b);
  }

  static public List<String> replaceKeywordBlock_dyn_any(List<String> tok, Collection<String> keywords, replaceKeywordBlock_dyn_IReplacer func) {
    for (String keyword : unnullForIteration(keywords)) replaceKeywordBlock_dyn(tok, keyword, func);
    return tok;
  }

  static public void pClose(AutoCloseable c) {
    close_pcall(c);
  }

  static public FixedRateTimer doEvery_daemon(long delay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, final Object r) {
    return doEvery_daemon(timerName, delay, delay, r);
  }

  static public FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
    return doEvery_daemon(defaultTimerName(), delay, firstDelay, r);
  }

  static public FixedRateTimer doEvery_daemon(String timerName, long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(true);
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
    return timer;
  }

  static public FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
    return doEvery_daemon(toMS(delaySeconds), r);
  }

  static public String hbuttonOnClick_noSubmit(String text, String onClick, Object... params) {
    return hfulltag("button", text, paramsPlus(params, "onclick", onClick, "type", "button"));
  }

  static public <A extends Concept> ConceptFieldIndexCI_withTopTen<A> indexConceptFieldCIWithTopTen(Class<A> c, String field) {
    return indexConceptFieldCIWithTopTen(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI_withTopTen<A> indexConceptFieldCIWithTopTen(Concepts cc, Class<A> c, String field) {
    var idx = getConceptFieldCIIndex(cc, c, field);
    if (idx instanceof ConceptFieldIndexCI_withTopTen)
      return ((ConceptFieldIndexCI_withTopTen) idx);
    if (idx != null)
      cc.removeCIFieldIndex(c, field);
    return new ConceptFieldIndexCI_withTopTen(cc, c, field);
  }

  static public boolean startsWithAny(String a, Collection<String> b) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, String... b) {
    if (b != null)
      for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
        return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b, Matches m) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix, m))
      return true;
    return false;
  }

  static public void assertSame(Object a, Object b) {
    assertSame("", a, b);
  }

  static public void assertSame(String msg, Object a, Object b) {
    if (a != b)
      throw fail(joinNemptiesWithColon(msg, a + " != " + b + " (" + identityHash(a) + "/" + identityHash(b) + ")"));
  }

  static public <A> IF0<A> if0_const(final A a) {
    return () -> a;
  }

  static public <A> List<A> sortedByComparator(Collection<A> l, Comparator<A> c) {
    List<A> l2 = cloneList(l);
    sort(l2, c);
    return l2;
  }

  static public <A> List<A> sortedByComparator(Comparator<A> c, Collection<A> l) {
    return sortedByComparator(l, c);
  }

  static public String toStringWithClassName(Object o) {
    return toStringWithClass(o);
  }

  static public File byteCodePathForClass(Class c) {
    if (c == null)
      return null;
    ClassLoader cl = getClassLoader(c);
    Collection<File> files = (Collection<File>) (getOpt(cl, "files"));
    if (files != null) {
      String name = c.getName().replace('.', '/') + ".class";
      for (File location : files) if (dirOrZipContainsPath(location, name))
        return location;
      throw fail(name + " not found in: " + files);
    }
    return null;
  }

  static public File byteCodePathForClass(Object o) {
    return byteCodePathForClass(_getClass(o));
  }

  static public Map<Thread, StackTraceElement[]> runnableThreadsWithStackTraces() {
    Map<Thread, StackTraceElement[]> map = filterMap((__137, __138) -> isThreadRunnable_x(__137, __138), Thread.getAllStackTraces());
    map.remove(currentThread());
    return map;
  }

  static public String renderMultiSet(MultiSet ms) {
    if (ms == null)
      return "-";
    List<String> l = new ArrayList();
    for (Object o : ms.highestFirst()) l.add(str(o) + " (" + ms.get(o) + ")");
    return joinWithComma(l);
  }

  static public <A> String renderMultiSet(Iterable<A> l) {
    return renderMultiSet(toMultiSet(l));
  }

  static public <A> A fourth(List<A> l) {
    return _get(l, 3);
  }

  static public <A> A fourth(A[] bla) {
    return bla == null || bla.length <= 3 ? null : bla[3];
  }

  static public String shorten_str(Object o) {
    return shorten(str(o));
  }

  static public String shorten_str(Object o, int max) {
    return shorte