//FILENAME: dynNewBotPkg/dynNewBotLoadable.java
package dynNewBotPkg;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import x30_pkg.x30_util;
import static x30_pkg.x30_util.VF1;
import static x30_pkg.x30_util.l;
import static x30_pkg.x30_util.fail;
import static x30_pkg.x30_util.indexOf;
import static x30_pkg.x30_util.getOpt;
import static x30_pkg.x30_util.setOpt;
import static x30_pkg.x30_util.callOpt;
import static x30_pkg.x30_util.newWeakHashMap;
import static x30_pkg.x30_util.newDangerousWeakHashMap;
import static x30_pkg.x30_util.get;
import static x30_pkg.x30_util.get_raw;
import static x30_pkg.x30_util.assertTrue;
import static x30_pkg.x30_util.isHeadless;
import static x30_pkg.x30_util.isAndroid;
import static x30_pkg.x30_util.isTrue;
import x30_pkg.x30_util.DynamicObject;
import loadableUtils.utils;
import static loadableUtils.utils._threadInfo;
import static loadableUtils.utils._threadInheritInfo;
import static loadableUtils.utils._threadInfo_addMakerAndRetriever;
import static loadableUtils.utils.dm_currentModule;
import static loadableUtils.utils.dm_current_mandatory;
import static loadableUtils.utils.match;
import static loadableUtils.utils.getOpt_raw;
import static loadableUtils.utils.setOpt_raw;
import static loadableUtils.utils.getField;
import static loadableUtils.utils.fieldType;
import static loadableUtils.utils.format3;
import static loadableUtils.utils.vm_generalIdentityHashSet;
import static loadableUtils.utils.vm_generalHashMap;
import static loadableUtils.utils.vm_generalWeakSubMap;
import static loadableUtils.utils.bindToComponent;
import static loadableUtils.utils.struct;
import static loadableUtils.utils.structure;
import static loadableUtils.utils.loadPage;
import static loadableUtils.utils.loadPage_utf8;
import static loadableUtils.utils.loadPageSilentlyWithTimeout;
import static loadableUtils.utils.loadPageSilently;
import static loadableUtils.utils.loadSnippet;
import static loadableUtils.utils.loadSnippetQuietly;
import static loadableUtils.utils.sendToLocalBot;
import static loadableUtils.utils.sendToLocalBotOpt;
import static loadableUtils.utils.sendToLocalBotQuietly;
import static loadableUtils.utils.componentPopupMenu;
import static loadableUtils.utils.componentPopupMenu_top;
import static loadableUtils.utils.componentPopupMenu_initForComponent;
import static loadableUtils.utils.componentPopupMenu_getEvent;
import static loadableUtils.utils.listPopupMenu;
import static loadableUtils.utils.tablePopupMenu;
import static loadableUtils.utils.tablePopupMenuFirst;
import static loadableUtils.utils.rowSorter_setComparators;
import static loadableUtils.utils.sexyTableWithoutDrag;
import static loadableUtils.utils.dm_current_generic;
import static loadableUtils.utils.dm_current_mandatory_generic;
import static loadableUtils.utils.cset;
import static loadableUtils.utils.DynamicObject_loading;
import static loadableUtils.utils.concepts_unlisted;
import static loadableUtils.utils.makePopupMenuConditional;
import static loadableUtils.utils.makeConceptsTable_idWidth;
import static loadableUtils.utils.showConceptsTable_afterUpdate;
import static loadableUtils.utils.dynamicObjectIsLoading;
import static loadableUtils.utils.rethrow;
import static loadableUtils.utils.hasBot;
import static loadableUtils.utils.concepts_internStringsLongerThan;
import static loadableUtils.utils.concepts_setUnlistedByDefault;
import static loadableUtils.utils.realMC_tl;
import loadableUtils.utils.F0;
import loadableUtils.utils.F1;
import loadableUtils.utils.IF0;
import loadableUtils.utils.IF1;
import loadableUtils.utils.Matches;
import loadableUtils.utils.BetterLabel;
import loadableUtils.utils.SingleComponentPanel;
import loadableUtils.utils.Snippet;
import loadableUtils.utils.Q;
import loadableUtils.utils.ImageSurface;
import loadableUtils.utils.structure_Data;
import loadableUtils.utils.structure_ClassInfo;
import loadableUtils.utils.RGBImage;
import loadableUtils.utils.RGB;
import loadableUtils.utils.BWImage;
import loadableUtils.utils.MakesBufferedImage;
import loadableUtils.utils.MultiSet;
import loadableUtils.utils.Concept;
import loadableUtils.utils.Concepts;
import loadableUtils.utils.RC;
import loadableUtils.utils.IConceptIndex;
import loadableUtils.utils.IFieldIndex;
import loadableUtils.utils.Derefable;
import loadableUtils.utils.ImageSurfaceSelector;
import loadableUtils.utils.SimpleCRUD;
import loadableUtils.utils.PersistableThrowable;
import loadableUtils.utils.DynModule;
import loadableUtils.utils.DynPrintLog;
import loadableUtils.utils.DynObjectTable;
import loadableUtils.utils.DynImageSurface;
import loadableUtils.utils.DynCalculatedList;
import loadableUtils.utils.GlobalID;
import loadableUtils.utils.Rect;
import loadableUtils.utils.Pt;
import loadableUtils.utils.SynchronizedArrayList;
import loadableUtils.utils.SecretValue;
import java.text.*;
import java.text.SimpleDateFormat;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.util.TimeZone;
import java.util.*;
import java.io.*;
import java.net.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.*;
import static loadableUtils.utils.getProgramID;
import static loadableUtils.utils.db_mainConcepts;

public class dynNewBotLoadable {

  static public String programID;

  static public void _onLoad_initUtils() {
    utils.__javax = javax();
  }

  static public void _onLoad_defaultClassFinder() {
    setDefaultClassFinder(new F1<String, Class>() {

      public Class get(String name) {
        Class c = findClass_fullName(name);
        if (c != null)
          return c;
        if (name.startsWith("main$"))
          return loadableUtils.utils.findClass_fullName("loadableUtils.utils" + name.substring(4));
        return null;
      }
    });
  }

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public Class javax() {
    return getJavaX();
  }

  static public void setDefaultClassFinder(Object cf) {
    _defaultClassFinder_value = cf;
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        Class c = findClass_fullName(name);
        if (c != null)
          return c;
        if (name.startsWith("loadableUtils.utils$"))
          return findClass_fullName("main" + name.substring(19));
        return null;
      }
    };
  }

  static public class Worker extends Concept {

    public String loginName, displayName;

    public boolean available = false;

    public long lastOnline;

    static public String _fieldOrder = "loginName displayName";

    public String renderAsHTML() {
      return htmlEncode2(loginName + " (display name: " + displayName + ")");
    }
  }

  abstract static public class DynNewBot2 extends DynPrintLogAndEnabled {

    public void setEleu(Object eleu) {
      mainBot = eleu;
    }

    public int maxRefsToShow = 5;

    transient public String templateID = "#1029809";

    static public String cssID = "#1029808";

    transient public String botName = "DynNewBot2";

    transient public String heading = "DynNewBot2";

    transient public String adminName = "DynNewBot2 Admin";

    transient public String botImageID = "#1102935";

    transient public String userImageID = "#1102803";

    transient public String chatHeaderImageID = "#1102802";

    transient public String timeZone = ukTimeZone_string();

    transient public String baseLink = "";

    transient public boolean newDesign = true;

    transient public boolean ariaLiveTrick = false;

    transient public boolean ariaLiveTrick2 = true;

    public class WorkerChat {

      public int workerLongPollTick = 200;

      public int workerLongPollMaxWait = 1000 * 30;

      public long lastWorkerRequested;

      public String mainAdminLink = "/";

      public Object html(String uri, Map<String, String> params, Conversation conv, AuthedDialogID auth) {
        String uri2 = appendSlash(uri);
        boolean requestAuthed = auth != null;
        if (startsWith(uri2, "/workers-admin/")) {
          if (!requestAuthed)
            return serveAuthForm(params.get("uri"));
          return serveWorkersAdmin(uri, params);
        }
        if (startsWith(uri2, "/worker/")) {
          if (!subBot_isHttps())
            return subBot_serveRedirect("https://" + domain() + fullSelfLink(params));
          if (!requestAuthed)
            return serveAuthForm(params.get("uri"));
          if (nempty(params.get("turnBotOn")))
            conv.turnBotOn();
          return serveWorkerPage(auth, conv, uri, params);
        }
        return null;
      }

      public String serveWorkersAdmin(String uri, Map<String, String> params) {
        String nav = p(ahref(mainAdminLink, "Main admin") + " | " + ahref(baseLink + "/workers-admin", "Workers admin"));
        if (eq(uri, "/workers-admin/change-image")) {
          long id = parseLong(params.get("id"));
          Worker worker = getConcept(Worker.class, id);
          File f = workerImageFile(id);
          String content;
          String b64 = params.get("base64");
          if (nempty(b64))
            saveFile(f, decodeBASE64(b64));
          if (worker == null)
            content = "Worker not found";
          else
            content = nav + hscript("\r\n            function submitIt() {\r\n              var file = $('#myUpload')[0].files[0];\r\n              var reader = new FileReader();\r\n  \r\n              reader.onloadend = function () {\r\n                var b64 = reader.result.replace(/^data:.+;base64,/, '');\r\n                $(\"#base64\").val(b64);\r\n                console.log(\"Got base64 data: \" + b64.length);\r\n                $(\"#submitForm\").submit();\r\n              };\r\n  \r\n              reader.readAsDataURL(file);\r\n              return false;\r\n            }\r\n          ") + h2("Worker image for: " + worker.renderAsHTML()) + p(!fileExists(f) ? "No image set" : himgsrc(rawLink("worker-image/" + id))) + hpostform(hhiddenWithIDAndName("base64") + "Choose image: " + hfileupload("accept", "image/png,image/jpeg,image/gif", "id", "myUpload") + "<br><br>" + "Note: Image should be square. Will be scaled to 40x40px in the chat" + hhidden("id", id), "action", rawLink("/workers-admin/change-image"), "id", "submitForm") + hbuttonOnClick_returnFalse("Upload", "submitIt()");
          return hhtml(hhead_title("Change worker image") + hsansserif() + hbody(loadJQuery() + content));
        }
        HCRUD_Concepts<Worker> data = new HCRUD_Concepts<Worker>(Worker.class);
        HCRUD crud = new HCRUD(rawLink("workers-admin"), data) {

          public String frame(String title, String contents) {
            return hhtml(hhead_title_htmldecode(title) + hbody(nav + h1(title) + contents));
          }
        };
        crud.unshownFields = litset("available", "lastOnline", "away");
        crud.postProcessTableRow = (item, rendered) -> {
          printStruct("item", item);
          long id = parseLong(item.get("id"));
          File f = workerImageFile(id);
          return mapPlus(rendered, "Image", f == null ? "???" : !fileExists(f) ? "-" : himgsrc(rawLink("worker-image/" + id)));
        };
        crud.renderCmds = item -> crud.renderCmds_base(item) + " | " + ahref(rawLink("workers-admin/change-image" + hquery("id", item.get("id"))), "Change image...");
        crud.tableClass = "responstable";
        return hsansserif() + hcss_responstable() + crud.renderPage(params);
      }

      public String serveWorkerPage(AuthedDialogID auth, Conversation conv, String uri, Map<String, String> params) {
        String cookie = conv.cookie;
        String uri2 = afterLastSlash(uri);
        if (eq(uri2, "availableWorkers"))
          return "Available workers: " + or2(joinWithComma(map(workersAvailable(), w -> w.renderAsHTML())), "-");
        if (nempty(params.get("workerLogOut")))
          cset(auth, "loggedIn", null);
        if (auth.loggedIn != null && nempty(params.get("workerAvailableBox")))
          if (cset_trueIfChanged(auth.loggedIn, "available", nempty(params.get("workerAvailable"))))
            noteConversationChange();
        if (nempty(params.get("acceptConversation"))) {
          if (conv.worker == null) {
            cset(conv, "worker", auth.loggedIn);
            conv.turnBotOff();
          }
        }
        String loginID = params.get("workerLogIn");
        if (nempty(loginID))
          cset(auth, "loggedIn", getConcept(Worker.class, parseLong(loginID)));
        Map map = prependEmptyOptionForHSelect(mapToOrderedMap(conceptsSortedByFieldCI(Worker.class, "loginName"), w -> pair(w.id, w.loginName)));
        if (auth.loggedIn == null)
          return hsansserif() + p("You are not logged in as a worker") + hpostform("Log in as: " + hselect("workerLogIn", map, conceptID(auth.loggedIn)) + " " + hsubmit("OK"), "action", rawLink("worker"));
        if (eq(uri2, "conversation")) {
          if (conv == null)
            return "Conversation not found";
          String onOffURL = rawLink("worker/botOnOff" + hquery("cookie", cookie) + "&on=");
          return hsansserif() + loadJQuery() + hhidden("cookie", conv.cookie) + hpostform(hhidden("cookie", cookie) + p(renderBotStatus(conv)) + p(conv.botOn ? hsubmit("Accept conversation", "name", "acceptConversation") : hsubmit("Turn bot back on", "name", "turnBotOn")), "action", rawLink("worker/innerFrameSet"), "target", "innerFrameSet") + hscriptsrc(rawLink(hquery("workerMode", 1, "cookie", conv.cookie)));
        }
        if (eq(uri2, "conversations")) {
          cset(auth.loggedIn, "lastOnline", now());
          boolean poll = eq("1", params.get("poll"));
          String content = "";
          if (poll) {
            long seenChange = parseLong(params.get("lastChange"));
            vmBus_send("chatBot_startingWorkerPoll", mc(), conv);
            long start = sysNow();
            List msgs;
            boolean first = true;
            while (licensed() && sysNow() < start + workerLongPollMaxWait && lastConversationChange == seenChange) sleep(workerLongPollTick);
            printVars_str("lastWorkerRequested", lastWorkerRequested, "seenChange", seenChange);
            if (lastWorkerRequested > seenChange)
              content = hscript("\r\n            window.parent.parent.frames[0].sendDesktopNotification(\"A worker is requested!\", { action: function() { window.focus(); } });\r\n            window.parent.parent.frames[0].playWorkerRequestedSound();\r\n          ");
          }
          long pingThreshold = now() - activeConversationTimeout();
          List<Conversation> convos = sortByCalculatedFieldDesc(c -> c.lastMsgTime(), conceptsWithFieldGreaterThan(Conversation.class, "lastPing", pingThreshold));
          content += hhiddenWithID("lastConversationChange", lastConversationChange) + tag("table", hsimpletableheader("IP", "Country", "Bot/worker status", "Last change", "Last messages") + mapToLines(convos, c -> {
            List<Msg> lastMsgs = lastTwo(c.msgs);
            String style = c == conv ? "background: #90EE90" : null;
            String convLink = rawLink("worker/innerFrameSet" + hquery("cookie", c.cookie));
            return tag("tr", td(ahref(convLink, c.ip, "target", "innerFrameSet")) + td(getCountry(c)) + td(renderBotStatus(c)) + td(renderHowLongAgo(c.lastMsgTime())) + td(ahref(convLink, hparagraphs(lambdaMap(__42 -> renderMsgForWorkerChat(__42), lastMsgs)), "target", "innerFrameSet", "style", "text-decoration: none")), "style", style);
          }), "class", "responstable");
          if (poll)
            return content;
          String incrementalURL = rawLink("worker/conversations?poll=1&lastChange=");
          return hhtml(hhead(hsansserif() + loadJQuery() + hscript_clickableRows()) + hbody(h3(botName) + hpostform("Logged in as " + htmlEncode2(auth.loggedIn.loginName) + " (display name: " + htmlEncode2(auth.loggedIn.displayName) + ")" + hhidden("workerAvailableBox", 1) + " &nbsp; " + hcheckboxWithText("workerAvailable", "I am available", auth.loggedIn.available, "onclick", "form.submit()") + " &nbsp; " + hsubmit("Log out", "name", "workerLogOut"), "target", "innerFrameSet", "action", rawLink("worker/innerFrameSet")) + p("Available workers: " + b(or2(joinWithComma(map(workersAvailable(), w -> w.displayName)), "none"))) + h3("Active conversations") + hcss_responstable() + hdivWithID("contentArea", content) + hscript("\r\n          function poll_start() {\r\n            var lastChange = $(\"#lastConversationChange\").val();\r\n            if (!lastChange)\r\n              setTimeout(poll_start, 1000);\r\n            else {\r\n              var url = \"#INCREMENTALURL#\" + lastChange;\r\n              console.log(\"Loading \" + url);\r\n              $.get(url, function(src) {\r\n                if (src.match(/^ERROR/)) console.log(src);\r\n                else {\r\n                  console.log(\"Loaded \" + src.length + \" chars\");\r\n                  $(\"#contentArea\").html(src);\r\n                }\r\n                setTimeout(poll_start, 1000);\r\n              }, 'text')\r\n                .fail(function() {\r\n                  console.log(\"Rescheduling after fail\");\r\n                  setTimeout(poll_start, 1000);\r\n                });\r\n            }\r\n          }\r\n          poll_start();\r\n        ".replace("#INCREMENTALURL#", incrementalURL))));
        }
        if (eq(uri2, "notificationArea"))
          return hhtml(hhead(hsansserif() + loadJQuery()) + hbody(hdesktopNotifications() + div(small(span(hbutton("CLICK HERE to enable notification sounds!"), "id", "enableSoundsBtn") + " | " + span("", "id", "notiStatus")), "style", "float: right") + hscript("\r\n          function enableSounds() {\r\n            document.removeEventListener('click', enableSounds);\r\n            $(\"#enableSoundsBtn\").html(\"Notification sounds enabled\");\r\n          }\r\n          document.addEventListener('click', enableSounds);\r\n          \r\n          if (window.workerRequestedSound == null) {\r\n            console.log(\"Loading worker requested sound\");\r\n            window.workerRequestedSound = new Audio(\"https://botcompany.de/files/1400404/worker-requested.mp3\");\r\n          }\r\n          \r\n          function playWorkerRequestedSound() {\r\n            console.log(\"Playing worker requested sound\");\r\n            window.workerRequestedSound.play();\r\n          }\r\n          window.playWorkerRequestedSound = playWorkerRequestedSound;\r\n\r\n        ")));
        if (eq(uri2, "innerFrameSet"))
          return hhtml(hhead_title("Worker Chat [" + auth.loggedIn.loginName + "]") + hframeset_cols("*,*", tag("frame", "", "name", "conversations", "src", rawLink("worker/conversations" + hquery("cookie", cookie))) + tag("frame", "", "name", "conversation", "src", conv == null ? null : rawLink("worker/conversation" + hquery("cookie", cookie)))));
        return hhtml(hhead_title("Worker Chat [" + auth.loggedIn.loginName + "]") + hframeset_rows("50,*", tag("frame", "", "name", "notificationArea", "src", rawLink("worker/notificationArea")) + tag("frame", "", "name", "innerFrameSet", "src", conv == null ? null : rawLink("worker/innerFrameSet" + hquery("cookie", cookie)))));
      }

      public String renderMsgForWorkerChat(Msg msg) {
        return (msg.fromWorker != null ? htmlEncode2(msg.fromWorker.displayName) : msg.fromUser ? "User" : "Bot") + ": " + b(htmlEncode2If(shouldHtmlEncodeMsg(msg), msg.text));
      }

      public Collection<Worker> workersAvailable() {
        long timestamp = now() - workerLongPollMaxWait - 10000;
        return filter(list(Worker.class), w -> w.available && w.lastOnline >= timestamp);
      }

      public boolean anyWorkersAvailable() {
        return nempty(workersAvailable());
      }

      public String renderBotStatus(Conversation conv) {
        return "Bot is " + b(conv.botOn ? "on" : "off") + "<br>" + "Assigned worker: " + b(conv.worker == null ? "none" : conv.worker.displayName);
      }
    }

    transient public WorkerChat workerChat = new WorkerChat();

    transient public ReliableSingleThread rstBotActions = dm_rst(this, new Runnable() {

      public void run() {
        try {
          botActions();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "botActions();";
      }
    });

    transient public String defaultHeaderColorLeft = "#2a27da";

    transient public String defaultHeaderColorRight = "#00ccff";

    public void start() {
      super.start();
      dm_setModuleName(botName);
      dm_assertFirstSibling();
      concepts_setUnlistedByDefault(true);
      standardTimeZone();
      standardTimeZone_name = timeZone;
      baseLink = "";
      print("DB program ID: " + dbProgramID());
      realPW();
      pWebChatBot();
      doEvery(60.0, new Runnable() {

        public void run() {
          try {
            cleanConversations();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cleanConversations();";
        }
      });
      rstBotActions.trigger();
    }

    static public class Req {

      public String uri;

      public Map<String, String> params;

      public AuthedDialogID auth;

      public Domain authDomainObj;

      public String authDomain;

      public HTMLFramer1 framer;

      public boolean masterAuthed = false;

      public Conversation conv;

      public boolean requestAuthed() {
        return auth != null;
      }
    }

    public Object html(IWebRequest request) {
      AutoCloseable __4 = enter();
      try {
        String uri = request.uri();
        Map<String, String> params = request.params();
        Req req = new Req();
        req.uri = uri;
        req.params = params;
        String cookie = params.get("cookie");
        if (empty(cookie))
          cookie = request.cookie();
        boolean workerMode = nempty(params.get("workerMode")) || startsWith(uri, "/worker");
        String domain = request.domain(), _domain = domain;
        saveDeliveredDomain(domain);
        Domain domainObj = findDomainObj(domain);
        Conversation conv = nempty(cookie) ? getConv(cookie) : null;
        req.conv = conv;
        AutoCloseable __5 = temp_printPrefix("Conv " + conv.cookie + ": ");
        try {
          String botConfig = params.get("_botConfig");
          Map<String, String> botConfigParams = decodeURIParams(botConfig);
          String simulatedDomain = botConfigParams.get("domain");
          Domain domainObj2 = nempty(simulatedDomain) ? findDomainObj(simulatedDomain) : domainObj;
          if (nempty(botConfigParams))
            cset(conv, "botConfig", botConfigParams);
          if (conv != null && !workerMode)
            if (cset_trueIfChanged(conv, "ip", request.clientIP(), "domain", domain, "domainObj", domainObj2))
              calcCountry(conv);
          print("URI: " + uri + ", cookie: " + cookie + ", msgs: " + l(conv.msgs));
          String pw = trim(params.get("pw"));
          if (nempty(pw) && nempty(cookie)) {
            Domain authDomain;
            if (eq(pw, realPW()))
              cset(uniq(AuthedDialogID.class, "cookie", cookie), "restrictedToDomain", null, "master", true);
            else if ((authDomain = conceptWhere(Domain.class, "password", pw)) != null)
              cset(uniq(AuthedDialogID.class, "cookie", cookie), "restrictedToDomain", authDomain, "master", false);
            else
              return errorMsg("Bad password, please try again");
            if (nempty(params.get("redirect")))
              return hrefresh(params.get("redirect"));
          }
          Matches m = new Matches();
          if (startsWith(uri, "/worker-image/", m)) {
            long id = parseLong(m.rest());
            return subBot_serveFile(workerImageFile(id), "image/jpeg");
          }
          if (startsWith(uri, "/uploaded-image/", m)) {
            long id = parseLong(m.rest());
            UploadedImage img = getConcept(UploadedImage.class, id);
            return img == null ? serve404() : subBot_serveFile(img.imageFile(), "image/jpeg");
          }
          AuthedDialogID auth = authObject(cookie);
          if (eq(params.get("logout"), "1")) {
            cdelete(auth);
            auth = null;
          }
          req.auth = auth;
          boolean requestAuthed = auth != null;
          boolean masterAuthed = req.masterAuthed = requestAuthed && auth.master;
          Domain authDomainObj = !requestAuthed ? null : auth.restrictedToDomain.get();
          req.authDomainObj = authDomainObj;
          String authDomain = !requestAuthed ? null : auth.domain();
          req.authDomain = authDomain;
          if (eq(uri, "/emoji-picker/index.js"))
            return subBot_maxCacheHeaders(serveInputStream(bufferedFileInputStream(loadLibrary("#1400436")), "text/javascript"));
          if (eq(uri, "/emoji-picker-test"))
            return loadSnippet("#1029870");
          if (eq(uri, "/stats")) {
            if (!requestAuthed)
              return serveAuthForm(rawLink(uri));
            return "Threads: " + ul_htmlEncode(getThreadNames(registeredThreads()));
          }
          if (eq(uri, "/logs")) {
            if (!masterAuthed)
              return serveAuthForm(rawLink(uri));
            return webChatBotLogsHTML2(rawLink(uri), params);
          }
          if (eq(uri, "/refchecker")) {
            if (!masterAuthed)
              return serveAuthForm(rawLink(uri));
            List errors = new ConceptsRefChecker(db_mainConcepts()).run();
            return serveText(jsonEncode_breakAtLevels(2, litorderedmap("errors", allToString(errors))));
          }
          if (eq(uri, "/auth-only")) {
            if (!requestAuthed)
              return serveAuthForm(params.get("uri"));
            return "";
          }
          if (eq(uri, "/leads-api"))
            return serveLeadsAPI(request);
          if (workerChat != null) {
            Object __3 = workerChat.html(uri, params, conv, auth);
            if (__3 != null)
              return __3;
          }
          {
            Lock __0 = dbLock();
            lock(__0);
            try {
              String message = trim(params.get("btn"));
              if (empty(message))
                message = trim(params.get("message"));
              if (match("new dialog", message)) {
                conv.newDialog();
                message = null;
              }
              if (eqic(message, "!toggle notifications")) {
                cset(conv, "notificationsOn", !conv.notificationsOn);
                message = null;
              }
              this.conv.set(conv);
              if (nempty(message) && !lastUserMessageWas(conv, message)) {
                print("Adding message: " + message);
                if (workerMode) {
                  Msg msg = new Msg(false, message);
                  msg.fromWorker = auth.loggedIn;
                  conv.add(msg);
                } else {
                  conv.add(new Msg(true, message));
                  addScheduledAction(new OnUserMessage(conv));
                }
              }
              String testMode = params.get("testMode");
              if (nempty(testMode)) {
                print("Setting testMode", testMode);
                cset(conv, "testMode", eq("1", testMode));
              }
            } finally {
              unlock(__0);
            }
          }
          if (eq(uri, "/msg"))
            return withHeader("OK");
          if (eq(uri, "/typing")) {
            if (workerMode) {
              conv.botTyping = now();
              print(conv.botTyping + " Bot typing in: " + conv.cookie);
            } else {
              conv.userTyping = now();
              print(conv.userTyping + " User typing in: " + conv.cookie);
            }
            return withHeader("OK");
          }
          if (eq(uri, "/incremental")) {
            vmBus_send("chatBot_userPolling", mc(), conv);
            cset(conv, "lastPing", now());
            if (empty(conv.msgs) && conv.newDialogTriggered < conv.archiveSize()) {
              cset(conv, "newDialogTriggered", conv.archiveSize());
              addScheduledAction(new OnNewDialog(conv));
            }
            int a = parseInt(params.get("a"));
            long start = sysNow(), start2 = now();
            List msgs;
            boolean first = true;
            while (licensed() && sysNow() < start + longPollMaxWait) {
              int as = conv.archiveSize();
              msgs = cloneSubList(conv.msgs, a - as);
              boolean newDialog = a < as;
              long typing = workerMode ? conv.userTyping : conv.botTyping;
              boolean otherPartyTyping = typing > start2;
              boolean anyEvent = nempty(msgs) || newDialog || otherPartyTyping;
              if (!anyEvent) {
                if (first) {
                  first = false;
                }
                sleep(longPollTick);
              } else {
                if (!first)
                  print("Long poll ended.");
                StringBuilder buf = new StringBuilder();
                if (newDialog) {
                  String l = or2_trim(domainObj2.headerColorLeft, defaultDomain().headerColorLeft, defaultHeaderColorLeft), r = or2_trim(domainObj2.headerColorRight, defaultDomain().headerColorRight, defaultHeaderColorRight);
                  buf.append(hcss(".chat_header { background: linear-gradient(135deg, " + hexColorToCSSRGB(l) + " 0%, " + hexColorToCSSRGB(r) + " 100%); }"));
                  buf.append(hscript("$('#chatBot_notiToggleText').text(" + jsQuote("Turn " + (conv.notificationsOn ? "off" : "on") + " notifications") + ");"));
                }
                if (otherPartyTyping) {
                  print("Noticed " + (workerMode ? "user" : "bot") + " typing in " + conv.cookie);
                  buf.append(hscript("showTyping();"));
                }
                renderMessages(conv, buf, msgs);
                if (ariaLiveTrick2 && !workerMode) {
                  Msg msg = lastBotMsg(msgs);
                  if (msg != null) {
                    String author = msg.fromWorker != null ? htmlEncode2(msg.fromWorker.displayName) : botName;
                    buf.append(hscript("$(\"#screenreadertrick\").html(" + jsQuote(author + " says: " + msg.text) + ");"));
                  }
                }
                if (a != 0 && anyInterestingMessages(msgs, workerMode))
                  buf.append(hscript(stringIf(conv.notificationsOn, "window.playChatNotification();\n") + "window.setTitleStatus(" + jsQuote((workerMode ? "User" : botName) + " says…") + ");"));
                return withHeader("<!-- " + conv.allCount() + " " + (newDialog ? "NEW DIALOG " : "") + "-->\n" + buf);
              }
            }
            return withHeader("");
          }
          if (eqOneOf(uri, "/script", "/demo")) {
            Lock __1 = dbLock();
            lock(__1);
            try {
              String html = loadSnippet_cached(templateID);
              String heading = or2(trim(domainObj2.botName), this.heading);
              String botImg = botImageForDomain(domainObj);
              String workerModeParam = workerMode ? "workerMode=1&" : "";
              String langlinks = "<!-- langlinks here -->";
              if (html.contains(langlinks))
                html = html.replace(langlinks, ahref(rawLink("eng"), "English") + " | " + ahref(rawLink("deu"), "German"));
              html = html.replace("#COUNTRY#", lower(conv.country));
              html = html.replace("#BOTIMG#", botImg);
              html = html.replace("#N#", "0");
              html = html.replace("#INCREMENTALURL#", baseLink + "/incremental?" + workerModeParam + "a=");
              html = html.replace("#MSGURL#", baseLink + "/msg?" + workerModeParam + "message=");
              html = html.replace("#TYPINGURL#", baseLink + "/typing?" + workerModeParam);
              html = html.replace("#CSS_ID#", psI_str(cssID));
              if (ariaLiveTrick || ariaLiveTrick2)
                html = html.replace("aria-live=\"polite\">", ">");
              html = html.replace("#OTHERSIDE#", workerMode ? "User" : "Representative");
              if (nempty(params.get("debug")))
                html = html.replace("var showActions = false;", "var showActions = true;");
              html = html.replace("#AUTOOPEN#", jsBool(workerMode || eq(params.get("_autoOpenBot"), "1") || botAutoOpen()));
              html = html.replace("#BOT_ON#", jsBool(botOn() || eq(uri, "/demo")));
              html = html.replace("$HEADING", heading);
              html = html.replace("#WORKERMODE", jsBool(workerMode));
              html = html.replace("<!-- MSGS HERE -->", "");
              html = hreplaceTitle(html, heading);
              if (eq(uri, "/demo"))
                return hhtml(hhead(htitle(heading) + loadJQuery2()) + hbody(hjavascript(html)));
              else
                return withHeader(subBot_serveJavaScript(html));
            } finally {
              unlock(__1);
            }
          }
          if (!requestAuthed)
            return serveAuthForm(params.get("uri"));
          if (eq(uri, "/thoughts"))
            return serveThoughts(req);
          if (masterAuthed && eq(uri, "/search"))
            return serveSearch(req);
          if (eq(uri, "/leads-csv")) {
            String text = leadsToCSV(conceptsWhere(Lead.class, mapToParams(filtersForClass(Lead.class, authDomainObj))));
            String name = "bot-leads" + (authDomainObj == null ? "" : "-" + replace(str(authDomainObj), "/", "-")) + "-" + ymd_minus_hm() + ".csv";
            return serveCSVWithFileName(name, text);
          }
          if (eq(uri, "/cleanConversations") && masterAuthed) {
            cleanConversations();
            return hrefresh(baseLink + "/crud/Conversation");
          }
          if (eq(uri, "/deleteDeliveredDomains") && masterAuthed) {
            deleteDeliveredDomains();
            return hrefresh(baseLink + "/crud/DeliveredDomain");
          }
          makeFramer(req);
          HTMLFramer1 framer = req.framer;
          List<Class> classes = crudClasses(req.masterAuthed);
          List<Class> cmdClasses = req.masterAuthed ? botCmdClasses() : null;
          for (Class c : (Set<Class>) asSet(flattenList2(classes, DeliveredDomain.class, cmdClasses))) if (eq(uri, dropUriPrefix(baseLink, crudLink(c)))) {
            String help = mapGet(crudHelp(), c);
            if (nempty(help))
              framer.contents.add(p(help));
            HCRUD crud = makeCRUD(c, req);
            crud.processSortParameter(params);
            framer.contents.add(crud.renderPage(params));
            framer.contents.add(hjs_markRowMagic());
          }
          if (eq(uri, "/emojis"))
            framer.contents.add(htmlTable2(map(emojiShortNameMap(), (code, emoji) -> litorderedmap("Shortcode", code, "Emoji", emoji))));
          framer.addNavItem(baseLink + "?logout=1", "Log out");
          return framer.render();
        } finally {
          _close(__5);
        }
      } finally {
        _close(__4);
      }
    }

    public void makeFramer(Req req) {
      HTMLFramer1 framer = new HTMLFramer1();
      req.framer = framer;
      framer.title = adminName + " " + squareBracket(req.masterAuthed ? "super user" : htmlEncode2(req.authDomain));
      framer.addInHead(hsansserif() + hmobilefix() + hresponstable() + hcss_responstableForForms());
      framer.addInHead(loadJQuery2());
      framer.addInHead(hjs_selectize());
      framer.addInHead(hjs_copyToClipboard());
      framer.addInHead(hNotificationPopups());
      framer.addInHead(hcss_linkColorInherit());
      framer.addNavItem(simulateDomainLink(req.authDomain), "Talk to bot", "targetBlank", true);
      List<Class> classes = crudClasses(req.masterAuthed);
      List<Class> cmdClasses = req.masterAuthed ? botCmdClasses() : null;
      for (Class c : classes) framer.addNavItem(makeClassNavItem(c, req.authDomainObj));
      if (nempty(cmdClasses))
        framer.contents.add(p("Bot actions: " + joinWithVBar(map(cmdClasses, c -> makeClassNavItem(c, req.authDomainObj)))));
    }

    public <A extends Concept> HCRUD makeCRUD(Class<A> c, Req req) {
      HTMLFramer1 framer = req.framer;
      HCRUD_Concepts data = crudData(c);
      data.referencesBlockDeletion = true;
      HCRUD crud = new HCRUD(req.uri, data);
      crud.haveJQuery = crud.haveSelectizeJS = true;
      crud.sortable = true;
      crud.paginate = true;
      crud.paginator.step = 25;
      crud.baseLink = crudLink(c);
      crud.cmdsLeft = true;
      crud.showCheckBoxes = true;
      crud.tableClass = "responstable";
      crud.formTableClass = "responstableForForms";
      crud.renderValue_inner = value -> {
        String html = crud.renderValue_inner_base(value);
        if (value instanceof Concept)
          return ahref(conceptLink(((Concept) value)), html);
        return html;
      };
      if (c == Conversation.class) {
        crud.nav = () -> joinNemptiesWithVBar(crud.nav_base(), ahref(baseLink + "/cleanConversations", "Clean list"));
        crud.unshownFields = litset("oldDialogs", "worker", "botOn", "lastPing", "cookie", "form", "testMode", "userMessageProcessed", "newDialogTriggered");
      }
      if (c == DeliveredDomain.class || c == Conversation.class || c == Lead.class || c == ConversationFeedback.class)
        crud.allowCreate = crud.allowEdit = false;
      if (c == Settings.class) {
        crud.singleton = true;
        framer.contents.add(p(ahref(baseLink + "/emojis", "Emojis")));
      }
      if (c == Lead.class)
        framer.contents.add(p(ahref(baseLink + "/leads-csv", "Export as CSV")));
      if (c == BotOutgoingQuestion.class)
        crud.unlistedFields = litset("multipleChoiceSeparator", "placeholder");
      data.addFilters(filtersForClass(c, req.authDomainObj));
      if (c == Domain.class) {
        crud.renderCmds = map -> {
          Domain dom = getConcept(Domain.class, toLong(crud.itemID(map)));
          return joinNemptiesWithVBar(crud.renderCmds_base(map), targetBlank(simulateDomainLink(dom.domainAndPath), "Talk to bot"));
        };
        framer.contents.add(p("See also the " + ahref(crudLink(DeliveredDomain.class), "list of domains the bot was delivered on")));
      }
      if (c == DeliveredDomain.class) {
        crud.nav = () -> joinNemptiesWithVBar(crud.nav_base(), ahref("/deleteDeliveredDomains", "Delete all"));
        crud.renderCmds = map -> {
          DeliveredDomain dom = getConcept(DeliveredDomain.class, toLong(crud.itemID(map)));
          return joinNemptiesWithVBar(crud.renderCmds_base(map), targetBlank(simulateDomainLink(dom.domain), "Talk to bot"));
        };
      }
      if (c == UploadedImage.class) {
        crud.massageFormMatrix = (map, matrix) -> {
          UploadedImage item = getConcept(UploadedImage.class, toLong(crud.itemID(map)));
          matrix.add(ll("Upload image", hjs_imgUploadBase64Encoder() + himageupload("id", "imgUploader") + hhiddenWithIDAndName("f_img_base64")));
        };
        crud.formParameters = () -> litparams("onsubmit", "return submitWithImageConversion(this)");
      }
      if (isSubclassOf(c, BotStep.class)) {
        crud.renderCmds = map -> {
          BotStep step = getConcept(BotStep.class, toLong(crud.itemID(map)));
          return joinNemptiesWithVBar(crud.renderCmds_base(map), targetBlank(simulateScriptLink(step), "Test in bot"));
        };
        framer.contents.add(p("See also the " + ahref(crudLink(DeliveredDomain.class), "list of domains the bot was delivered on")));
      }
      crud.postProcessTableRow = (item, rendered) -> {
        long id = parseLong(item.get("id"));
        Concept concept = getConcept(id);
        if (concept == null)
          return rendered;
        Collection<Concept> refs = allBackRefs(concept);
        if (empty(refs))
          return rendered;
        refs = sortedByConceptID(refs);
        int more = l(refs) - maxRefsToShow;
        return mapPlus(rendered, span_title("Where is this object used", "References"), joinMap(takeFirst(maxRefsToShow, refs), ref -> p(ahref(conceptLink(ref), htmlEncode_nlToBr_withIndents(str(ref))))) + (more > 0 ? "<br>+" + more + " more" : ""));
      };
      return crud;
    }

    public String conceptLink(Concept c) {
      return c == null ? null : crudLink(c.getClass()) + "#obj" + c.id;
    }

    public <A extends Concept> String makeClassNavItem(Class<A> c, Domain authDomainObj) {
      HCRUD_Concepts<A> data = crudData(c);
      Map filters = filtersForClass(c, authDomainObj);
      int count = countConcepts(c, mapToParams(filters));
      return (c == Settings.class ? "" : count + " ") + ahref(crudLink(c), data.itemNamePlural());
    }

    public List<Class> botCmdClasses() {
      return ll(BotMessage.class, UploadedImage.class, BotImage.class, BotOutgoingQuestion.class, BotPause.class, Sequence.class);
    }

    public List<Class> crudClasses(boolean masterAuthed) {
      if (masterAuthed) {
        List<Class> l = ll(Conversation.class, Lead.class, ConversationFeedback.class, Domain.class, UserKeyword.class, Settings.class);
        if (settings().multiLanguageMode)
          l.add(Language.class);
        return l;
      } else
        return ll(Conversation.class, Lead.class, ConversationFeedback.class);
    }

    public Map<String, Object> filtersForClass(Class c, Domain authDomainObj) {
      if (c == Conversation.class && authDomainObj != null)
        return litmap("domainObj", authDomainObj);
      if (eqOneOf(c, Lead.class, ConversationFeedback.class) && authDomainObj != null)
        return litmap("domain", authDomainObj);
      return null;
    }

    public String crudLink(Class c) {
      return baseLink + "/crud/" + shortName(c);
    }

    public <A extends Concept> HCRUD_Concepts<A> crudData(Class<A> c) {
      HCRUD_Concepts<A> cc = new HCRUD_Concepts<>(c);
      cc.trimAllSingleLineValues = true;
      cc.fieldHelp("comment", "Put any comment about this object here");
      cc.itemName = () -> replaceIfEquals(dropPrefix("Bot ", cc.itemName_base()), "Jump Button", "Button");
      cc.valueConverter = new DefaultValueConverterForField() {

        public OrError<Object> convertValue(Object object, Field field, Object value) {
          if (value instanceof String && eq(field.getGenericType(), type_LS()))
            return new OrError(tlft((String) value));
          return super.convertValue(object, field, value);
        }
      };
      if (c == Domain.class) {
        cc.fieldHelp("domainAndPath", "without http:// or https://", "botName", "Bot name for this domain (optional)", "headerColorLeft", "Hex color for left end of header gradient (optional)", "headerColorRight", "Hex color for right end of header gradient (optional)");
        cc.massageItemMapForList = (item, map) -> {
          map.put("domainAndPath", new HTML(b(htmlEncode2(((Domain) item).domainAndPath))));
          map.put("password", new SecretValue(map.get("password")));
        };
      }
      if (c == BotOutgoingQuestion.class) {
        cc.addRenderer("displayText", new HCRUD_Data.TextArea(80, 10));
        cc.addRenderer("buttons", new HCRUD_Data.TextArea(80, 10, o -> lines_rtrim((List) o)));
        cc.fieldHelp("displayText", displayTextHelp(), "key", "Internal key for question (any format, can be empty)", "defaultValue", "What the input field is prefilled with", "placeholder", "A text the empty input field shows as a hint", "buttons", "Buttons to offer as standard answers (one per line)", "allowFreeText", "Can user enter free text in addition to clicking a button?", "multipleChoice", "Can user select multiple buttons?", "optional", "Can user skip the question by entering nothing?", "multipleChoiceSeparator", "Internal field, just leave as it is", "answerCheck", "Select this to validate user's answer against a pattern", "buttonActions", "Optional actions (one for each button in the list above)");
        cc.addRenderer("answerCheck", new HCRUD_Data.ComboBox("", "email address", "phone number"));
        cc.massageItemMapForList = (item, map) -> {
          map.put("buttons", new HTML(ol_htmlEncode(((BotOutgoingQuestion) item).buttons)));
        };
      }
      if (c == UserKeyword.class) {
        for (String field : ll("examples", "counterexamples")) cc.addRenderer(field, new HCRUD_Data.TextArea(80, 5, o -> lines_rtrim((List) o)));
        cc.massageItemMapForList = (item, map) -> {
          map.put("examples", lines_rtrim(((UserKeyword) item).examples));
          map.put("counterexamples", lines_rtrim(((UserKeyword) item).counterexamples));
        };
      }
      if (c == Settings.class)
        cc.fieldHelp("botTypingDelay", "Delay in seconds before bot sends message", "preferredCountryCodes", "Country codes to display first in list (e.g. \"+1, +91\")");
      if (c == Conversation.class)
        cc.massageItemMapForList = (item, map) -> {
          replaceMap(map, litorderedmap("id", map.get("id"), "IP", map.get("ip"), "started", formatLocalDateWithMinutes(((Conversation) item).created), "country", map.get("country"), "msgs", lines_rtrim(((Conversation) item).msgs)));
        };
      if (c == BotMessage.class) {
        cc.addRenderer("text", new HCRUD_Data.TextArea(80, 10));
        cc.addRenderer("specialPurpose", new HCRUD_Data.ComboBox("", "bad email address", "bad phone number"));
        cc.fieldHelp("text", displayTextHelp(), "specialPurpose", "Special occasion when to display this message");
      }
      if (c == Form.class)
        cc.massageItemMapForList = (item, map) -> {
          map.put("steps", pnlToStringWithEmptyLines_rtrim(((Form) item).steps));
        };
      if (c == Sequence.class)
        cc.massageItemMapForList = (item, map) -> {
          map.put("steps", new HTML(ol(map(((Sequence) item).steps, step -> ahref(conceptLink(step), htmlEncode2_nlToBr(str(step)))))));
        };
      if (c == BotImage.class)
        cc.massageItemMapForList = (item, map) -> {
          String url = ((BotImage) item).imageURL;
          if (isURL(url))
            map.put("Image Preview", new HTML(himg(url, "style", "max-width: 200px; max-height: 100px; width: auto; height: auto")));
          map.put(cc.fieldNameToHTML("imageURL"), new HTML(htmlEncode2(url) + " " + himgsnippet("#1101381", "onclick", "copyToClipboard(" + jsQuote(url) + "); " + "window.createNotification({ theme: 'success', showDuration: 3000 })({ message: " + jsQuote("Image URL copied to clipboard") + "});")));
        };
      if (c == UploadedImage.class) {
        cc.massageItemMapForList = (item, map) -> {
          String url = ((UploadedImage) item).imageURL();
          File f = ((UploadedImage) item).imageFile();
          map.put("Image Size", toK_str(fileSize(f)));
          if (fileSize(f) > 0)
            map.put("Image Preview", new HTML(himg(((UploadedImage) item).imageURL(), "style", "max-width: 200px; max-height: 100px; width: auto; height: auto")));
        };
        IVF2 massageItemMapForUpdate_old = cc.massageItemMapForUpdate;
        cc.massageItemMapForUpdate = (item, map) -> {
          cc.massageItemMapForUpdate_fallback(massageItemMapForUpdate_old, item, map);
          String base64 = (String) map.get("img_base64");
          print("Got base64 data: " + l(base64));
          if (nempty(base64)) {
            File f = ((UploadedImage) item).imageFile();
            saveFileVerbose(f, base64decode(base64));
          }
          map.remove("img_base64");
        };
      }
      return cc;
    }

    public Map<Class, String> crudHelp() {
      return litmap(DeliveredDomain.class, "This list is filled by the bot with the domains it was delivered on. " + "Some may be bogus, we write down whatever the browser sends.");
    }

    public void saveDeliveredDomain(String domain) {
      if (empty(domain))
        return;
      uniqCI(DeliveredDomain.class, "domain", beforeColonOrAll(domain));
    }

    public void cleanConversations() {
      withDBLock(new Runnable() {

        public void run() {
          try {
            cdelete(filter(list(Conversation.class), c -> l(c.msgs) <= 1 && elapsedSeconds_timestamp(c.created) >= 60 & c.lastPing == 0));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cdelete(filter(list(Conversation), c -> l(c.msgs) <= 1\r\n        && elapsedSec...";
        }
      });
    }

    public void deleteDeliveredDomains() {
      cdelete(DeliveredDomain.class);
    }

    public Object serveThoughts(Req req) {
      HTMLFramer1 framer = new HTMLFramer1();
      framer.addInHead(hsansserif() + hmobilefix());
      framer.add(div_floatRight(hbutton("Reload", "onclick", "location.reload()")));
      framer.add(h2("Bot Thoughts"));
      if (req.conv == null)
        framer.add("No conversation");
      else {
        framer.add(p("Conversation cookie: " + req.conv.cookie));
        Conversation conv = req.conv;
        framer.add(h3("Stack"));
        framer.add(empty(conv.stack) ? p("empty") : ol(lmap(__43 -> htmlEncode2_gen(__43), reversed(conv.stack))));
      }
      return framer.render();
    }

    public Object serveSearch(Req req) {
      makeFramer(req);
      HTMLFramer1 framer = req.framer;
      framer.add("Search here");
      return framer.render();
    }

    transient public boolean debug = false;

    public Domain findDomainObj(String domain) {
      Domain domainObj = conceptWhereCI(Domain.class, "domainAndPath", domain);
      if (domainObj == null)
        domainObj = defaultDomain();
      return domainObj;
    }

    public Domain defaultDomain() {
      return uniqCI(Domain.class, "domainAndPath", "<default>");
    }

    transient public int longPollTick = 200;

    transient public int longPollMaxWait = 1000 * 30;

    transient public int activeConversationSafetyMargin = 15000;

    transient public Set<String> specialButtons = litciset("Cancel", "Back", "Abbrechen", "Zurück");

    public String dbStats() {
      Collection<Conversation> all = list(Conversation.class);
      int nRealConvos = countPred(all, c -> l(c.msgs) > 1);
      return nConversations(nRealConvos);
    }

    public String realPW() {
      print("realMC: " + realMC() + " (" + getProgramID(realMC()) + ")");
      print("Secret program dir: " + getSecretProgramDir());
      return loadSecretTextFileOrCreateWithRandomID("password.txt");
    }

    public String serveAuthForm(String redirect) {
      return hhtml(hhead(htitle("Authorization required") + hsansserif() + hmobilefix()) + hbody(hfullcenter(h3_htmlEncode(adminName) + hpostform(hhidden("redirect", redirect) + "Password: " + hpassword("pw") + " " + hsubmit("Log in"), "action", baseLink) + p(ahref(baseLink + "/demo", "Talk to bot")))));
    }

    public String leadsToCSV(Collection<Lead> leads) {
      List<String> fields = ciContentsIndexedList();
      List<List> rows = new ArrayList();
      for (Lead lead : unnull(leads)) {
        List row = new ArrayList();
        {
          final Map<String, Object> __6 = unnull(mapPlus_inFront((Map<String, Object>) (Map) lead.answers, "Date", formatLocalDateWithMinutes(lead.date.date), "Domain", lead.domain.get(), "Conversation ID", conceptID(lead.conversation.get())));
          for (String key : keys(__6)) {
            Object val = __6.get(key);
            int idx = fields.indexOf(key);
            if (idx < 0)
              idx = addAndReturnIndex(fields, key);
            listSet(row, idx, val, "");
          }
        }
        rows.add(row);
      }
      return formatCSVFileForExcel2(itemPlusList(fields, rows));
    }

    public String countryCodeOptions(Conversation conv) {
      Collection<String> countryCodes = putSetElementsFirst(keys(countryDialCodesMultiMap()), splitAtComma_trim(settings().preferredCountryCodes));
      String selected = dialCodeStringForCountryCode(conv.country);
      return mapToLines(c -> {
        List<CountryDialCode> cdc = countryDialCodesMultiMap().get(c);
        String text = nempty(cdc) ? c + " [" + joinWithComma(collectSorted("countryCode", cdc)) + "]" : c;
        return tag("option", text, "value", c, "selected", eq(c, selected) ? html_valueLessParam() : null);
      }, itemPlus("", countryCodes));
    }

    public List<BotStep> addTypingDelays(List<BotStep> steps) {
      if (settings().botTypingDelay <= 0)
        return steps;
      return concatMap(steps, step -> {
        double delay = step.preTypingDelay();
        if (delay <= 0)
          return ll(step);
        return ll(new BotSendTyping(), new BotPause(delay), step);
      });
    }

    public BotMessage messageForPurpose(String specialPurpose) {
      return conceptWhere(BotMessage.class, "specialPurpose", specialPurpose);
    }

    public Object serveLeadsAPI(Object req) {
      Map<String, String> headers = (Map<String, String>) (rcall("headers", req));
      Map<String, String> params = (Map<String, String>) (get("params", req));
      String tenantID = params.get("tenantID");
      if (empty(tenantID))
        return serveJSONError("Empty tenantID");
      String pw = params.get("pw");
      if (empty(pw))
        pw = dropPrefix_trim("Bearer ", headers.get("Authorization"));
      if (empty(pw))
        return serveJSONError("Empty password");
      Domain domain = conceptWhere(Domain.class, "tenantID", tenantID);
      if (domain == null)
        return serveJSONError("Tenant ID not found");
      if (neq(domain.password, pw))
        return serveJSONError("Bad passsword");
      Collection<Lead> leads = conceptsWhere(Lead.class, "domain", domain);
      return serveJSON(map(leads, lead -> {
        Map map = litorderedmap("tenantID", tenantID, "leadID", lead.id, "domain", str(lead.domain), "date", formatLocalDateWithSeconds(lead.created), "data", lead.answers);
        return map;
      }));
    }

    public Object serveJSONError(String error) {
      return serveJSON(litorderedmap("error", error));
    }

    public String botImageForDomain(Domain domainObj) {
      String botImg = imageSnippetURLOrEmptyGIF(chatHeaderImageID);
      if (domainObj != null && domainObj.botImage.has())
        botImg = domainObj.botImage.get().imageURL();
      else if (defaultDomain().botImage.has())
        botImg = defaultDomain().botImage.get().imageURL();
      return botImg;
    }

    public String simulateDomainLink(String domain) {
      return appendQueryToURL(baseLink + "/demo", "_botConfig", makePostData("domain", domain), "cookie", "test_" + aRandomID());
    }

    public String simulateScriptLink(BotStep script) {
      return appendQueryToURL(baseLink + "/demo", "_botConfig", makePostData("mainScript", script.id), "cookie", "test_" + aRandomID());
    }

    public boolean handleGeneralUserInput(Conversation conv, Msg msg, Boolean priority) {
      for (UserKeyword qa : conceptsWhere(UserKeyword.class, onlyNonNullParams("priority", priority))) {
        if (qa.enabled && mmo2_match(qa.parsedPattern(), msg.text)) {
          print("Matched pattern: " + qa.pattern + " / " + msg.text);
          conv.noteEvent(new EvtMatchedUserKeyword(qa, msg));
          conv.callSubroutine(qa.action.get());
          conv.scheduleNextStep();
          return true;
        }
      }
      return false;
    }

    public void didntUnderstandUserInput(Conversation conv, Msg msg) {
    }

    public Settings settings() {
      return conceptWhere(Settings.class);
    }

    public String displayTextHelp() {
      return "Text to show to user (can include HTML and " + targetBlank(baseLink + "/emojis", "emojis") + ")";
    }

    public void botActions() {
      withDBLock(new Runnable() {

        public void run() {
          try {
            while (licensed()) {
              ScheduledAction action = lowestConceptByField(ScheduledAction.class, "time");
              if (action == null)
                break;
              if (action.time > now()) {
                doAfter(100, rstBotActions);
                break;
              }
              cdelete(action);
              print("Executing action " + action);
              try {
                action.run();
              } catch (Throwable __e) {
                _handleException(__e);
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "while licensed {\r\n        ScheduledAction action = lowestConceptByField Sched...";
        }
      });
    }

    public void addScheduledAction(ScheduledAction action) {
      addScheduledAction(action, 0);
    }

    public void addScheduledAction(ScheduledAction action, long delay) {
      action.time = now() + delay;
      registerConcept(action);
      rstBotActions.trigger();
    }

    transient public ThreadLocal<Out> out = new ThreadLocal();

    transient public ThreadLocal<Conversation> conv = new ThreadLocal();

    transient public long lastConversationChange = now();

    public void pWebChatBot() {
      dbIndexing(Conversation.class, "cookie", Conversation.class, "worker", Conversation.class, "lastPing", Worker.class, "loginName", AuthedDialogID.class, "cookie");
      indexConceptFieldDesc(ScheduledAction.class, "time");
      indexConceptFieldCI(Domain.class, "domainAndPath");
      indexConceptFieldCI(DeliveredDomain.class, "domain");
      indexConceptFieldCI(CannedAnswer.class, "hashTag");
      indexConceptFieldCI(Language.class, "languageName");
      indexConceptField(Lead.class, "domain");
      indexConceptField(ConversationFeedback.class, "domain");
      db_mainConcepts().miscMap = litmap(DynNewBot2.class, this);
      indexSingletonConcept(Settings.class);
      uniq(Settings.class);
      uniq(BotSaveLead.class);
      uniq(BotSaveFeedback.class);
      uniq(BotClearStack.class);
    }

    public void addReplyToConvo(Conversation conv, IF0<String> think) {
      out.set(new Out());
      String reply = "";
      try {
        reply = think.get();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      Msg msg = new Msg(false, reply);
      msg.out = out.get();
      conv.add(msg);
    }

    public Msg msgFromThinkFunction(IF0<String> think) {
      out.set(new Out());
      String reply = "";
      try {
        reply = think.get();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      Msg msg = new Msg(false, reply);
      msg.out = out.get();
      return msg;
    }

    public Object withHeader(String html) {
      return withHeader(subBot_noCacheHeaders(subBot_serveHTML(html)));
    }

    public Object withHeader(Object response) {
      call(response, "addHeader", "Access-Control-Allow-Origin", "*");
      return response;
    }

    public String renderMessageText(String text, boolean htmlEncode) {
      text = trim(text);
      if (eqic(text, "!rate conversation"))
        text = "Rate this conversation";
      if (htmlEncode)
        text = htmlEncode2(text);
      text = nlToBr(text);
      return html_emojisToUnicode(text);
    }

    public void renderMessages(Conversation conv, StringBuilder buf, List<Msg> msgs) {
      if (empty(msgs))
        return;
      for (Msg m : msgs) {
        if (!m.fromUser && eq(m.text, "-"))
          continue;
        String html = renderMessageText(m.text, shouldHtmlEncodeMsg(m));
        appendMsg(conv, buf, m.fromUser ? defaultUserName() : botName, formatTime(m.time), html, !m.fromUser, m.fromWorker, m.out);
        if (m == last(msgs)) {
          buf.append(hscript("$(\"#chat_telephone, .iti\").hide(); $(\"#chat_message\").show();"));
          if (m.out != null && nempty(m.out.javaScript))
            buf.append(hscript(m.out.javaScript));
        }
      }
      appendButtons(buf, last(msgs).out, null);
    }

    public void appendMsg(Conversation conv, StringBuilder buf, String name, String time, String text, boolean bot, Worker fromWorker, Out out) {
      boolean useTrick = ariaLiveTrick;
      String tag = useTrick ? "div" : "span";
      if (bot) {
        String id = randomID();
        String author = fromWorker != null ? htmlEncode2(fromWorker.displayName) : botName;
        if (fromWorker != null)
          buf.append("<div class=\"chat_botname\"><p>" + author + "</p>");
        buf.append("<" + tag + " class=\"chat_msg_item chat_msg_item_admin\"" + (useTrick ? " id=\"" + id + "\" aria-live=\"polite\" tabindex=\"-1\"" : "") + ">");
        String imgURL;
        if (fromWorker != null && fileExists(workerImageFile(fromWorker.id)))
          imgURL = fullRawLink("worker-image/" + fromWorker.id);
        else
          imgURL = botImageForDomain(conv.domainObj.get());
        if (nempty(imgURL))
          buf.append("\r\n          <div class=\"chat_avatar\">\r\n            <img src=\"$IMG\"/>\r\n          </div>".replace("$IMG", imgURL));
        buf.append("<span class=\"sr-only\">" + (fromWorker != null ? "" : botName + " ") + "says</span>");
        buf.append(text);
        buf.append("</" + tag + ">");
        if (fromWorker != null)
          buf.append("</div>");
        if (useTrick)
          buf.append(hscript("$('#" + id + "').focus();"));
      } else
        buf.append(("\r\n        <span class=\"sr-only\">You say</span>\r\n        <" + tag + " class=\"chat_msg_item chat_msg_item_user\"" + (useTrick ? " aria-live=\"polite\"" : "") + ">$TEXT</" + tag + ">\r\n      ").replace("$TEXT", text));
    }

    public String replaceButtonText(String s) {
      if (eqicOneOf(s, "back", "zurück"))
        return unicode_undoArrow();
      if (eqicOneOf(s, "cancel", "Abbrechen"))
        return unicode_crossProduct();
      return s;
    }

    public String renderMultipleChoice(List<String> buttons, Collection<String> selections, String multipleChoiceSeparator) {
      print("selections", selections);
      Set<String> selectionSet = asCISet(selections);
      String rand = randomID();
      String className = "chat_multiplechoice_" + rand;
      String allCheckboxes = "$(\"." + className + "\")";
      return joinWithBR(map(buttons, name -> hcheckbox("", contains(selectionSet, name), "value", name, "class", className) + " " + name)) + "<br>" + hbuttonOnClick_returnFalse("OK", "submitMsg()", "class", "btn btn-ok") + hscript(allCheckboxes + ".change(function() {" + " var theList = $('." + className + ":checkbox:checked').map(function() { return this.value; }).get();" + "  console.log('theList: ' + theList);" + "  $('#chat_message').val(theList.join(" + jsQuote(multipleChoiceSeparator) + "));" + "});");
    }

    public String renderSingleChoice(List<String> buttons) {
      List<String> out = new ArrayList();
      for (int i = 0; i < l(buttons); i++) {
        String code = buttons.get(i);
        String text = replaceButtonText(code);
        out.add(hbuttonOnClick_returnFalse(text, "submitAMsg(" + jsQuote(text) + ")", "class", "chatbot-choice-button", "title", eq(code, text) ? null : code));
        if (!specialButtons.contains(code) && i + 1 < l(buttons) && specialButtons.contains(buttons.get(i + 1)))
          out.add("&nbsp;&nbsp;");
      }
      return lines(out);
    }

    public void appendButtons(StringBuilder buf, Out out, Set<String> buttonsToSkip) {
      String placeholder = out == null ? "" : unnull(out.placeholder);
      String defaultInput = out == null ? "" : unnull(out.defaultInput);
      buf.append(hscript("chatBot_setInput(" + jsQuote(defaultInput) + ", " + jsQuote(placeholder) + ");"));
      if (out == null)
        return;
      List<String> buttons = listMinusSet(out.buttons, buttonsToSkip);
      if (empty(buttons))
        return;
      printVars_str("buttons", buttons, "buttonsToSkip", buttonsToSkip);
      String buttonsHtml;
      if (out.multipleChoice)
        buttonsHtml = renderMultipleChoice(buttons, text_multipleChoiceSplit(out.defaultInput, out.multipleChoiceSeparator), out.multipleChoiceSeparator);
      else
        buttonsHtml = renderSingleChoice(buttons);
      buf.append(span(buttonsHtml, "class", "chat_msg_item chat_msg_item_admin chat_buttons" + stringIf(!out.multipleChoice, " single-choice")));
    }

    public void appendDate(StringBuilder buf, String date) {
      buf.append("\r\n    <div class=\"chat-box-single-line\">\r\n      <abbr class=\"timestamp\">DATE</abbr>\r\n    </div>".replace("DATE", date));
    }

    public boolean lastUserMessageWas(Conversation conv, String message) {
      Msg m = last(conv.msgs);
      return m != null && m.fromUser && eq(m.text, message);
    }

    public String formatTime(long time) {
      return timeInTimeZoneWithOptionalDate_24(timeZone, time);
    }

    public String formatDialog(String id, List<Msg> msgs) {
      List<String> lc = new ArrayList();
      for (Msg m : msgs) lc.add(htmlencode((m.fromUser ? "> " : "< ") + m.text));
      return id + ul(lc);
    }

    public Conversation getConv(final String cookie) {
      return withDBLock(new F0<Conversation>() {

        public Conversation get() {
          try {
            return uniq(Conversation.class, "cookie", cookie);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ret uniq(Conversation, +cookie);";
        }
      });
    }

    public String errorMsg(String msg) {
      return hhtml(hhead_title("Error") + hbody(hfullcenter(msg + "<br><br>" + ahref(jsBackLink(), "Back"))));
    }

    public String defaultUserName() {
      return "You";
    }

    public boolean botOn() {
      return true;
    }

    public boolean botAutoOpen() {
      return false;
    }

    public File workerImageFile(long id) {
      return id == 0 ? null : javaxDataDir("adaptive-bot/images/" + id + ".jpg");
    }

    public long activeConversationTimeout() {
      return longPollMaxWait + activeConversationSafetyMargin;
    }

    public AuthedDialogID authObject(String cookie) {
      AuthedDialogID auth = empty(cookie) ? null : conceptWhere(AuthedDialogID.class, "cookie", cookie);
      printVars_str("cookie", cookie, "auth", auth);
      return auth;
    }

    public boolean anyInterestingMessages(List<Msg> msgs, boolean workerMode) {
      return any(msgs, m -> m.fromUser == workerMode);
    }

    public boolean shouldHtmlEncodeMsg(Msg msg) {
      return msg.fromUser;
    }

    public void calcCountry(Conversation c) {
      cset(c, "country", "");
      getCountry(c);
    }

    public String getCountry(Conversation c) {
      if (empty(c.country) && nempty(c.ip))
        cset(c, "country", ipToCountry2020_safe(c.ip));
      return or2(c.country, "?");
    }

    public void noteConversationChange() {
      lastConversationChange = now();
    }

    public String template(String hashtag, Object... params) {
      return replaceSquareBracketVars(getCannedAnswer(hashtag), params);
    }

    public String getCannedAnswer(String hashTag) {
      return getCannedAnswer(hashTag, null);
    }

    public String getCannedAnswer(String hashTag, Conversation conv) {
      return hashTag;
    }

    public List<String> text_multipleChoiceSplit(String input, String multipleChoiceSeparator) {
      return trimAll(splitAt(input, dropSpaces(multipleChoiceSeparator)));
    }

    public Msg lastBotMsg(List<Msg> l) {
      return lastThat(l, msg -> !msg.fromUser);
    }

    public File uploadedImagesDir() {
      return programDir("uploadedImages");
    }
  }

  abstract static public class BotStep extends Concept {

    public String comment;

    public boolean run(Conversation conv) {
      return false;
    }

    public ScheduledAction nextStepAction(Conversation conv) {
      return new Action_NextStep(conv, conv.executedSteps);
    }

    public double preTypingDelay() {
      return 0;
    }
  }

  static public class Sequence extends BotStep {

    public RefL<BotStep> steps = new RefL();

    public String toString() {
      return "Sequence " + quoteOr(comment, "(unnamed)") + spaceRoundBracketed(nSteps(steps));
    }

    public boolean run(Conversation conv) {
      syncAdd(conv.stack, new ActiveSequence(this));
      conv.change();
      return true;
    }
  }

  static public class BotMessage extends BotStep {

    public String text;

    public String specialPurpose;

    static public String _fieldOrder = "text specialPurpose";

    public String toString() {
      return "Message" + spacePlusRoundBracketedIfNempty(comment) + ": " + newLinesToSpaces2(shorten(text, 40));
    }

    public boolean run(Conversation conv) {
      botMod().addReplyToConvo(conv, () -> text);
      return true;
    }

    public double preTypingDelay() {
      return botMod().settings().botTypingDelay;
    }
  }

  abstract static public class AbstractBotImage extends BotStep {

    public String altText;

    public boolean run(Conversation conv) {
      botMod().addReplyToConvo(conv, () -> himgsrc(imageURL(), "title", altText, "alt", altText, "class", "chat_contentImage"));
      return true;
    }

    abstract public String imageURL();

    public double preTypingDelay() {
      return botMod().settings().botTypingDelay;
    }
  }

  static public class BotImage extends AbstractBotImage {

    public String imageURL, altText;

    static public String _fieldOrder = "imageURL";

    public String imageURL() {
      return imageURL;
    }

    public String toString() {
      return "Image" + spacePlusRoundBracketedIfNempty(comment) + ": " + imageURL;
    }
  }

  static public class UploadedImage extends AbstractBotImage {

    public String imageURL() {
      return botMod().baseLink + "/uploaded-image/" + id;
    }

    public File imageFile() {
      return newFile(botMod().uploadedImagesDir(), id + ".png");
    }

    public String toString() {
      return "Image" + spacePlusRoundBracketedIfNempty(altText) + spacePlusRoundBracketedIfNempty(comment);
    }

    public void delete() {
      if (concepts() == db_mainConcepts())
        deleteFile(imageFile());
      super.delete();
    }
  }

  static public class BotSendTyping extends BotStep {

    public boolean run(Conversation conv) {
      conv.botTyping = now();
      return true;
    }
  }

  static public class BotPause extends BotStep {

    public double seconds;

    public BotPause() {
    }

    public BotPause(double seconds) {
      this.seconds = seconds;
    }

    public boolean run(Conversation conv) {
      botMod().addScheduledAction(nextStepAction(conv), toMS(seconds));
      return false;
    }

    public String toString() {
      return "Pause for " + (seconds == 1 ? "1 second" : formatDouble(seconds, 1) + " seconds");
    }
  }

  static public class BotOutgoingQuestion extends BotStep implements IInputHandler {

    public String displayText;

    public String key;

    public String defaultValue;

    public String placeholder;

    public List<String> buttons;

    public boolean allowFreeText = false;

    public boolean multipleChoice = false;

    public String multipleChoiceSeparator = ", ";

    public boolean optional = false;

    public String answerCheck;

    public RefL<BotStep> buttonActions = new RefL();

    static public String _fieldOrder = "displayText key defaultValue placeholder buttons allowFreeText multipleChoice optional answerCheck";

    public String toString() {
      return "Question: " + orEmptyQuotes(displayText);
    }

    public boolean run(Conversation conv) {
      Msg msg = new Msg(false, displayText);
      msg.out = makeMsgOut();
      conv.add(msg);
      cset(conv, "inputHandler", this);
      return false;
    }

    public Out makeMsgOut() {
      Out out = new Out();
      out.placeholder = or(placeholder, displayText);
      out.defaultInput = defaultValue;
      out.buttons = cloneList(buttons);
      out.multipleChoice = multipleChoice;
      out.multipleChoiceSeparator = multipleChoiceSeparator;
      if (eqic(answerCheck, "phone number"))
        out.javaScript = "$(\"#chat_telephone, .iti\").show(); $(\"#chat_message\").hide();";
      return out;
    }

    public boolean handleInput(String s, Conversation conv) {
      print("BotOutgoingQuestion handleInput " + s);
      s = trim(s);
      syncPut(conv.answers, or2(key, displayText), s);
      conv.change();
      if (eqic(answerCheck, "email address") && !isValidEmailAddress_simple(s)) {
        handleValidationFail(conv, "bad email address");
        return true;
      }
      if (eqic(answerCheck, "phone number") && !isValidInternationalPhoneNumber(s)) {
        handleValidationFail(conv, "bad phone number");
        return true;
      }
      conv.removeInputHandler(this);
      int idx = indexOfIC(buttons, s);
      print("Button index of " + quote(s) + " in " + sfu(buttons) + " => " + idx);
      BotStep target = get(buttonActions, idx);
      print("Button action: " + target);
      if (target != null)
        conv.jumpTo(target);
      print("Scheduling next step in " + conv);
      conv.scheduleNextStep();
      return true;
    }

    public double preTypingDelay() {
      return empty(displayText) ? 0 : botMod().settings().botTypingDelay;
    }

    public void handleValidationFail(Conversation conv, String purpose) {
      BotMessage msg = botMod().messageForPurpose(purpose);
      if (msg != null) {
        Msg m = new Msg();
        m.text = msg.text;
        m.out = makeMsgOut();
        conv.add(m);
      }
      cset(conv, "inputHandler", this);
      return;
    }
  }

  static public class BotSaveLead extends BotStep {

    public String toString() {
      return "Save Lead";
    }

    public boolean run(Conversation conv) {
      cnew(Lead.class, "conversation", conv, "domain", conv.domainObj, "date", new Timestamp(now()), "answers", cloneMap(conv.answers));
      return true;
    }
  }

  static public class BotSaveFeedback extends BotStep {

    public String toString() {
      return "Save Conversation Feedback";
    }

    public boolean run(Conversation conv) {
      cnew(ConversationFeedback.class, "conversation", conv, "domain", conv.domainObj, "date", new Timestamp(now()), "answers", filterKeys(conv.answers, swic$("Conversation Feedback:")));
      return true;
    }
  }

  static public class BotClearStack extends BotStep {

    public boolean run(Conversation conv) {
      syncRemoveAllExceptLast(conv.stack);
      conv.change();
      return true;
    }

    public String toString() {
      return "Clear Stack [forget all running procedures in conversation]";
    }
  }

  static public class UserKeyword extends Concept {

    static final public String _fieldOrder = "language pattern examples counterexamples action enabled priority parsedPattern";

    public Ref<Language> language = new Ref();

    public String pattern;

    public List<String> examples, counterexamples;

    public Ref<BotStep> action = new Ref();

    public boolean enabled = true;

    public boolean priority = false;

    transient public MMOPattern parsedPattern;

    public void change() {
      parsedPattern = null;
      super.change();
    }

    public MMOPattern parsedPattern() {
      if (parsedPattern == null)
        parsedPattern = mmo2_parsePattern(pattern);
      return parsedPattern;
    }

    public String toString() {
      return "User Keyword: " + pattern;
    }
  }

  static public class Language extends Concept {

    static final public String _fieldOrder = "languageName comment";

    public String languageName;

    public String comment;

    public String toString() {
      return languageName + spaceRoundBracketed(comment);
    }
  }

  static public class Evt extends Concept {
  }

  static public class EvtMatchedUserKeyword extends Evt {

    static final public String _fieldOrder = "userKeyword msg";

    public Ref<UserKeyword> userKeyword = new Ref();

    public Msg msg;

    public EvtMatchedUserKeyword() {
    }

    public EvtMatchedUserKeyword(UserKeyword userKeyword, Msg msg) {
      this.userKeyword.set(userKeyword);
      this.msg = msg;
    }
  }

  static public class EvtJumpTo extends Evt {

    public Ref<BotStep> target = new Ref();

    public EvtJumpTo() {
    }

    public EvtJumpTo(BotStep target) {
      this.target.set(target);
    }
  }

  static public class Avatar extends Concept {

    static final public String _fieldOrder = "name comment image";

    public String name, comment;

    public Ref<AbstractBotImage> image = new Ref();
  }

  static public class Out extends DynamicObject {

    public List<String> buttons;

    public boolean multipleChoice = false;

    public String multipleChoiceSeparator;

    public String placeholder;

    public String defaultInput;

    public String javaScript;
  }

  static public class Msg extends DynamicObject {

    public long time;

    public boolean fromUser = false;

    public Worker fromWorker;

    public String text;

    public Out out;

    public Msg() {
    }

    public Msg(boolean fromUser, String text) {
      this.text = text;
      this.fromUser = fromUser;
      time = now();
    }

    public Msg(String text, boolean fromUser) {
      this.fromUser = fromUser;
      this.text = text;
      time = now();
    }

    public String toString() {
      return (fromUser ? "User" : "Bot") + ": " + text;
    }
  }

  static public class AuthedDialogID extends Concept {

    static final public String _fieldOrder = "cookie master restrictedToDomain loggedIn";

    public String cookie;

    public boolean master = false;

    public Ref<Domain> restrictedToDomain = new Ref();

    public Worker loggedIn;

    public String domain() {
      return !restrictedToDomain.has() ? null : restrictedToDomain.get().domainAndPath;
    }
  }

  static public class ActiveSequence {

    public Sequence originalSequence;

    public List<BotStep> steps;

    public int stepIndex;

    public ActiveSequence() {
    }

    public ActiveSequence(BotStep step) {
      if (step instanceof Sequence) {
        steps = cloneList(((Sequence) step).steps);
        originalSequence = ((Sequence) step);
      } else
        steps = ll(step);
      steps = botMod().addTypingDelays(steps);
    }

    public boolean done() {
      return stepIndex > l(steps);
    }

    public BotStep currentStep() {
      return get(steps, stepIndex);
    }

    public void nextStep() {
      ++stepIndex;
    }

    public String toString() {
      return (stepIndex >= l(steps) ? "DONE " : "Step " + (stepIndex + 1) + "/" + l(steps) + " of ") + (originalSequence != null ? str(originalSequence) : squareBracket(joinWithComma(steps)));
    }
  }

  static public class Conversation extends Concept {

    static final public String _fieldOrder = "cookie ip country domain domainObj oldDialogs msgs lastPing botOn notificationsOn worker userTyping botTyping testMode nextActionTime userMessageProcessed newDialogTriggered dryRun stack executedSteps inputHandler language answers botConfig events";

    public String cookie, ip, country, domain;

    public Ref<Domain> domainObj = new Ref();

    public List<List<Msg>> oldDialogs = new ArrayList();

    public List<Msg> msgs = new ArrayList();

    public long lastPing;

    public boolean botOn = true;

    public boolean notificationsOn = true;

    public Worker worker;

    transient public long userTyping, botTyping;

    public boolean testMode = false;

    public long nextActionTime = Long.MAX_VALUE;

    public long userMessageProcessed;

    public int newDialogTriggered = -1;

    transient public boolean dryRun = false;

    public List<ActiveSequence> stack = new ArrayList();

    public int executedSteps;

    public IInputHandler inputHandler;

    public Ref<Language> language = new Ref();

    public Map<String, String> answers = litcimap();

    public Map<String, String> botConfig;

    public RefL<Concept> events = new RefL();

    public void add(Msg m) {
      m.text = trim(m.text);
      syncAdd(msgs, m);
      botMod().noteConversationChange();
      change();
      vmBus_send("chatBot_messageAdded", mc(), this, m);
    }

    public int allCount() {
      return archiveSize() + syncL(msgs);
    }

    public int archiveSize() {
      return syncLengthLevel2(oldDialogs) + syncL(oldDialogs);
    }

    public long lastMsgTime() {
      Msg m = last(msgs);
      return m == null ? 0 : m.time;
    }

    public String language() {
      return "en";
    }

    public void turnBotOff() {
      cset(this, "botOn", false);
      botMod().noteConversationChange();
    }

    public void turnBotOn() {
      cset(this, "botOn", true, "worker", null);
      String backMsg = botMod().getCannedAnswer("#botBack", this);
      if (empty(msgs) || lastMessageIsFromUser() || !eq(last(msgs).text, backMsg))
        add(new Msg(backMsg, false));
      botMod().noteConversationChange();
    }

    public boolean lastMessageIsFromUser() {
      return nempty(msgs) && last(msgs).fromUser;
    }

    public void newDialog() {
      syncAdd(oldDialogs, msgs);
      cset(this, "msgs", new ArrayList());
      syncClear(answers);
      syncClear(stack);
      change();
      print("newDialog " + archiveSize() + "/" + allCount());
      vmBus_send("chatBot_clearedSession", mc(), this);
    }

    public void jumpTo(BotStep step) {
      syncPopLast(stack);
      print("Jumping to " + step);
      noteEvent(new EvtJumpTo(step));
      if (step == null)
        return;
      syncAdd(stack, new ActiveSequence(step));
      change();
    }

    public void callSubroutine(BotStep step) {
      if (step == null)
        return;
      print("Calling subroutine " + step);
      syncAdd(stack, new ActiveSequence(step));
      change();
    }

    public void removeInputHandler(IInputHandler h) {
      if (inputHandler == h)
        cset(this, "inputHandler", null);
    }

    public void scheduleNextStep() {
      botMod().addScheduledAction(new Action_NextStep(this));
    }

    public void noteEvent(Concept event) {
      events.add(event);
    }
  }

  abstract static public class ScheduledAction extends Concept implements Runnable {

    public long time;
  }

  static public class Action_NextStep extends ScheduledAction {

    public Ref<Conversation> conv = new Ref();

    public int executedSteps = -1;

    public Action_NextStep() {
    }

    public Action_NextStep(Conversation conv) {
      this.conv.set(conv);
    }

    public Action_NextStep(Conversation conv, int executedSteps) {
      this.conv.set(conv);
      this.executedSteps = executedSteps;
    }

    public void run() {
      nextStep(conv.get(), executedSteps);
    }
  }

  static public class OnNewDialog extends ScheduledAction {

    public Ref<Conversation> conv = new Ref();

    public OnNewDialog() {
    }

    public OnNewDialog(Conversation conv) {
      this.conv.set(conv);
    }

    public void run() {
      Domain domain = conv.get().domainObj.get();
      if (domain == null) {
        botMod().addReplyToConvo(conv.get(), () -> "Error: No domain set");
        return;
      }
      BotStep seq = getConcept(BotStep.class, parseLong(mapGet(conv.get().botConfig, "mainScript")));
      if (seq == null)
        seq = domain.mainScript.get();
      if (seq == null) {
        botMod().addReplyToConvo(conv.get(), () -> "Error: No main script set for " + htmlEncode2(str(domain)));
        return;
      }
      if (executeStep(seq, conv.get()))
        nextStep(conv.get());
    }
  }

  static public void nextStep(Conversation conv) {
    nextStep(conv, -1);
  }

  static public void nextStep(Conversation conv, int expectedExecutedSteps) {
    if (expectedExecutedSteps >= 0 && conv.executedSteps != expectedExecutedSteps)
      return;
    while (licensed()) {
      if (empty(conv.stack))
        return;
      ActiveSequence seq = last(conv.stack);
      if (seq.done()) {
        syncPopLast(conv.stack);
        continue;
      }
      BotStep step = seq.currentStep();
      seq.nextStep();
      ++conv.executedSteps;
      conv.change();
      if (!executeStep(step, conv))
        break;
    }
  }

  static public boolean executeStep(BotStep step, Conversation conv) {
    if (step == null || conv == null)
      return false;
    print("Executing step " + step + " in " + conv);
    return step.run(conv);
  }

  static public class OnUserMessage extends ScheduledAction {

    public Ref<Conversation> conv = new Ref();

    public OnUserMessage() {
    }

    public OnUserMessage(Conversation conv) {
      this.conv.set(conv);
    }

    public void run() {
      Msg msg = syncLast(conv.get().msgs);
      if (msg == null || !msg.fromUser)
        return;
      print("OnUserMessage: " + msg);
      if (botMod().handleGeneralUserInput(conv.get(), msg, true))
        return;
      if (conv.get().inputHandler != null) {
        if (conv.get().inputHandler.handleInput(msg.text, conv.get()))
          return;
      }
      botMod().handleGeneralUserInput(conv.get(), msg, false);
    }
  }

  static public class Domain extends Concept {

    public String domainAndPath;

    public String tenantID;

    public Ref<AbstractBotImage> botImage = new Ref();

    public String botName;

    public String headerColorLeft, headerColorRight;

    public Ref<BotStep> mainScript = new Ref();

    public String password = aGlobalID();

    static public String _fieldOrder = "domainAndPath botImage mainScript";

    public String toString() {
      return domainAndPath;
    }
  }

  static public class Form extends Concept {

    public String name;

    public RefL<BotStep> steps = new RefL();

    public String toString() {
      return name;
    }
  }

  static public class DeliveredDomain extends Concept {

    public String domain;
  }

  static public class CannedAnswer extends Concept {

    public String hashTag, text;
  }

  static public String text(CannedAnswer a) {
    return a == null ? null : a.text;
  }

  static public class Lead extends Concept {

    static final public String _fieldOrder = "domain conversation date answers";

    public Ref<Domain> domain = new Ref();

    public Ref<Conversation> conversation = new Ref();

    public Timestamp date;

    public Map<String, String> answers;
  }

  static public class ConversationFeedback extends Concept {

    static final public String _fieldOrder = "domain conversation date answers";

    public Ref<Domain> domain = new Ref();

    public Ref<Conversation> conversation = new Ref();

    public Timestamp date;

    public Map<String, String> answers;
  }

  static public class Settings extends Concept {

    static final public String _fieldOrder = "botTypingDelay preferredCountryCodes multiLanguageMode";

    public double botTypingDelay;

    public String preferredCountryCodes;

    public boolean multiLanguageMode = false;
  }

  static public interface IInputHandler {

    public boolean handleInput(String s, Conversation conv);
  }

  static public DynNewBot2 botMod() {
    return (DynNewBot2) db_mainConcepts().miscMap.get(DynNewBot2.class);
  }

  static public class CountryDialCode implements IFieldsToList {

    public String country;

    public String countryCode;

    public String dialCode;

    public CountryDialCode() {
    }

    public CountryDialCode(String country, String countryCode, String dialCode) {
      this.dialCode = dialCode;
      this.countryCode = countryCode;
      this.country = country;
    }

    public String toString() {
      return shortClassName(this) + "(" + country + ", " + countryCode + ", " + dialCode + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof CountryDialCode))
        return false;
      CountryDialCode __1 = (CountryDialCode) o;
      return eq(country, __1.country) && eq(countryCode, __1.countryCode) && eq(dialCode, __1.dialCode);
    }

    public int hashCode() {
      int h = 240284435;
      h = boostHashCombine(h, _hashCode(country));
      h = boostHashCombine(h, _hashCode(countryCode));
      h = boostHashCombine(h, _hashCode(dialCode));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { country, countryCode, dialCode };
    }
  }

  static public class HTMLFramer1 {

    public String title;

    public List<NavItem> navItems = new ArrayList();

    public List<String> contents = new ArrayList();

    public List<String> headElements = new ArrayList();

    static public class NavItem implements IFieldsToList {

      static final public String _fieldOrder = "link html targetBlank";

      public String link;

      public String html;

      public NavItem() {
      }

      public NavItem(String link, String html) {
        this.html = html;
        this.link = link;
      }

      public String toString() {
        return shortClassName(this) + "(" + link + ", " + html + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof NavItem))
          return false;
        NavItem __1 = (NavItem) o;
        return eq(link, __1.link) && eq(html, __1.html);
      }

      public int hashCode() {
        int h = -900864330;
        h = boostHashCombine(h, _hashCode(link));
        h = boostHashCombine(h, _hashCode(html));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { link, html };
      }

      public boolean targetBlank = false;
    }

    transient public IF0<String> render;

    public String render() {
      return render != null ? render.get() : render_base();
    }

    final public String render_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : render_base();
    }

    public String render_base() {
      return hhtml(hhead(htitle(title) + lines(headElements)) + hbody(h1(htmlEncode2(title)) + renderNav() + lines(contents)));
    }

    transient public IF0<String> renderNav;

    public String renderNav() {
      return renderNav != null ? renderNav.get() : renderNav_base();
    }

    final public String renderNav_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : renderNav_base();
    }

    public String renderNav_base() {
      if (empty(navItems))
        return "";
      return p(joinWithVBar(map(navItems, ni -> ahref_possiblyTargetBlank(ni.link, ni.html, ni.targetBlank))));
    }

    public void addNavItem(String html) {
      navItems.add(new NavItem(null, html));
    }

    public void addNavItem(String link, String html, Object... __) {
      navItems.add(setAll(new NavItem(link, html), filterParams(__, "targetBlank")));
    }

    public void addInHead(Object html) {
      headElements.add(str(html));
    }

    public void add(Object html) {
      addIfNempty(contents, strOrEmpty(html));
    }
  }

  static public interface IWebRequest {

    public String uri();

    public Map<String, String> params();

    public Map<String, String> headers();

    default public String clientIP() {
      return unnull(getClientIPFromHeaders(headers()));
    }

    default public String domain() {
      return mapGet(headers(), "host");
    }

    public String cookie();
  }

  static public class HCRUD_Data {

    public Map<String, Renderer> renderers = new HashMap();

    public Map<String, String> fieldHelp = new HashMap();

    abstract static public class Renderer {

      transient public IF1<Object, Object> preprocessValue;

      public Object preprocessValue(Object value) {
        return preprocessValue != null ? preprocessValue.get(value) : preprocessValue_base(value);
      }

      final public Object preprocessValue_fallback(IF1<Object, Object> _f, Object value) {
        return _f != null ? _f.get(value) : preprocessValue_base(value);
      }

      public Object preprocessValue_base(Object value) {
        return value;
      }
    }

    static public class TextArea extends Renderer implements IFieldsToList {

      public int cols;

      public int rows;

      public TextArea() {
      }

      public TextArea(int cols, int rows) {
        this.rows = rows;
        this.cols = cols;
      }

      public String toString() {
        return shortClassName(this) + "(" + cols + ", " + rows + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextArea))
          return false;
        TextArea __1 = (TextArea) o;
        return cols == __1.cols && rows == __1.rows;
      }

      public int hashCode() {
        int h = -939552902;
        h = boostHashCombine(h, _hashCode(cols));
        h = boostHashCombine(h, _hashCode(rows));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols, rows };
      }

      public TextArea(int cols, int rows, IF1 preprocessValue) {
        this.cols = cols;
        this.rows = rows;
        this.preprocessValue = preprocessValue;
      }
    }

    static public class TextField extends Renderer implements IFieldsToList {

      public int cols;

      public TextField() {
      }

      public TextField(int cols) {
        this.cols = cols;
      }

      public String toString() {
        return shortClassName(this) + "(" + cols + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextField))
          return false;
        TextField __2 = (TextField) o;
        return cols == __2.cols;
      }

      public int hashCode() {
        int h = 942981037;
        h = boostHashCombine(h, _hashCode(cols));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols };
      }
    }

    static public class ComboBox extends Renderer implements IFieldsToList {

      public List<String> entries;

      public ComboBox() {
      }

      public ComboBox(List<String> entries) {
        this.entries = entries;
      }

      public String toString() {
        return shortClassName(this) + "(" + entries + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ComboBox))
          return false;
        ComboBox __3 = (ComboBox) o;
        return eq(entries, __3.entries);
      }

      public int hashCode() {
        int h = -547674755;
        h = boostHashCombine(h, _hashCode(entries));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { entries };
      }

      transient public IF1<Object, String> valueToEntry;

      public String valueToEntry(Object value) {
        return valueToEntry != null ? valueToEntry.get(value) : valueToEntry_base(value);
      }

      final public String valueToEntry_fallback(IF1<Object, String> _f, Object value) {
        return _f != null ? _f.get(value) : valueToEntry_base(value);
      }

      public String valueToEntry_base(Object value) {
        return strOrNull(value);
      }

      public ComboBox(String... entries) {
        this(asList(entries));
      }

      public ComboBox(List<String> entries, IF1<Object, String> valueToEntry) {
        this.entries = entries;
        this.valueToEntry = valueToEntry;
      }
    }

    static public class CheckBox extends Renderer implements IFieldsToList {

      public CheckBox() {
      }

      public String toString() {
        return shortClassName(this) + "(" + ")";
      }

      public boolean equals(Object o) {
        return o instanceof CheckBox;
      }

      public int hashCode() {
        int h = 1601505219;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }
    }

    static public class FlexibleLengthList extends Renderer implements IFieldsToList {

      public Renderer itemRenderer;

      public FlexibleLengthList() {
      }

      public FlexibleLengthList(Renderer itemRenderer) {
        this.itemRenderer = itemRenderer;
      }

      public String toString() {
        return shortClassName(this) + "(" + itemRenderer + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof FlexibleLengthList))
          return false;
        FlexibleLengthList __4 = (FlexibleLengthList) o;
        return eq(itemRenderer, __4.itemRenderer);
      }

      public int hashCode() {
        int h = -1874811153;
        h = boostHashCombine(h, _hashCode(itemRenderer));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { itemRenderer };
      }
    }

    public String itemName() {
      return "object";
    }

    public String itemNamePlural() {
      return plural(itemName());
    }

    public List<Map<String, Object>> list() {
      return null;
    }

    public List<Map<String, Object>> list(IntRange range) {
      return subListOrFull(list(), range);
    }

    public String idField() {
      return "id";
    }

    public Map<String, Object> emptyObject() {
      return null;
    }

    public Map<String, Object> getObject(Object id) {
      return null;
    }

    public Object createObject(Map<String, String> map) {
      throw unimplemented();
    }

    public String deleteObject(Object id) {
      throw unimplemented();
    }

    public boolean objectCanBeDeleted(Object id) {
      return true;
    }

    public String updateObject(Object id, Map<String, String> map) {
      throw unimplemented();
    }

    public Renderer getRenderer(String field) {
      return renderers.get(field);
    }

    public String fieldHelp(String field) {
      return fieldHelp.get(field);
    }

    public HCRUD_Data addRenderer(String field, Renderer renderer) {
      renderers.put(field, renderer);
      return this;
    }

    public HCRUD_Data fieldHelp(String field, String help, String... more) {
      fieldHelp.put(field, help);
      for (int i = 0; i + 1 < l(more); i += 2) fieldHelp.put(more[i], more[i + 1]);
      return this;
    }

    public String fieldNameToHTML(String name) {
      String help = fieldHelp.get(name);
      return spanTitle(help, htmlencode2(humanizeLabel(name)));
    }
  }

  static public class HCRUD_Concepts<A extends Concept> extends HCRUD_Data {

    public Concepts cc = db_mainConcepts();

    public Class<A> cClass;

    public List<IVF1<A>> onCreateOrUpdate = new ArrayList();

    public Map<String, Object> filters;

    public ValueConverterForField valueConverter;

    public boolean referencesBlockDeletion = false;

    public boolean trimAllSingleLineValues = false;

    public HCRUD_Concepts(Class<A> cClass) {
      this.cClass = cClass;
    }

    transient public IF0<String> itemName;

    public String itemName() {
      return itemName != null ? itemName.get() : itemName_base();
    }

    final public String itemName_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : itemName_base();
    }

    public String itemName_base() {
      return humanizeShortName(cClass);
    }

    public List<A> itemsForListing() {
      return defaultSort(asList(listConcepts()));
    }

    @Override
    public List<Map<String, Object>> list() {
      return lambdaMap(__44 -> itemToMapForList(__44), itemsForListing());
    }

    @Override
    public List<Map<String, Object>> list(IntRange range) {
      return lambdaMap(__45 -> itemToMapForList(__45), subListOrFull(itemsForListing(), range));
    }

    public Collection<A> listConcepts() {
      return conceptsWhere(cc, cClass, mapToParams(filters));
    }

    public List<A> defaultSort(List<A> l) {
      return l;
    }

    public Map<String, Object> emptyObject() {
      A c = unlisted(cClass);
      print("fieldOrder", getFieldOrder(c));
      return printStruct("emptyObject", itemToMap(c));
    }

    public Map<String, Object> itemToMap(A c) {
      if (c == null)
        return null;
      return putKeysFirst(getFieldOrder(c), conceptToMap_gen_withNullValues(c));
    }

    public Map<String, Object> itemToMapForList(A c) {
      if (c == null)
        return null;
      Map<String, Object> map = itemToMap(c);
      massageItemMapForList(c, map);
      return map;
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForList;

    public void massageItemMapForList(A c, Map<String, Object> map) {
      if (massageItemMapForList != null)
        massageItemMapForList.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    final public void massageItemMapForList_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    public void massageItemMapForList_base(A c, Map<String, Object> map) {
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForUpdate;

    public void massageItemMapForUpdate(A c, Map<String, Object> map) {
      if (massageItemMapForUpdate != null)
        massageItemMapForUpdate.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    final public void massageItemMapForUpdate_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    public void massageItemMapForUpdate_base(A c, Map<String, Object> map) {
      for (Field f : nonStaticNonTransientFieldObjectsOfType(Concept.RefL.class, cClass)) {
        TreeMap<Integer, Object> values = new TreeMap();
        Matches m = new Matches();
        {
          final Map<String, Object> __0 = cloneMap(map);
          for (String key : keys(__0)) {
            Object value = __0.get(key);
            if (startsWith(key, f.getName() + "_", m) && isInteger(m.rest())) {
              long conceptID = parseFirstLong((String) value);
              Concept concept = getConcept(cc, conceptID);
              printVars_str("RefL magic", "key", key, "conceptID", conceptID, "concept", concept);
              mapPut(values, parseInt(m.rest()), concept);
              map.remove(key);
            }
            map.put(f.getName(), valuesAsList(values));
          }
        }
      }
      for (Field f : nonStaticNonTransientFieldObjectsOfType(Concept.Ref.class, cClass)) {
        Object value = map.get(f.getName());
        if (value instanceof String) {
          long conceptID = parseFirstLong(((String) value));
          Concept concept = getConcept(cc, conceptID);
          map.put(f.getName(), concept);
        }
      }
      if (trimAllSingleLineValues)
        for (Map.Entry<String, Object> e : map.entrySet()) {
          String val = optCastString(e.getValue());
          if (val != null && isSingleLine(val) && isUntrimmed(val))
            e.setValue(trim(val));
        }
    }

    public Map<String, Object> getObject(Object id) {
      return itemToMap(conceptForID(id));
    }

    public Object createObject(Map<String, String> map) {
      A c = cnew(cc, cClass);
      setValues(c, map);
      cset(c, mapToParams(filters));
      pcallFAll(onCreateOrUpdate, c);
      return c.id;
    }

    public void setValues(A c, Map<String, String> map) {
      Map<String, Object> map2 = (Map) cloneMap(map);
      massageItemMapForUpdate(c, map2);
      if (valueConverter == null)
        cSmartSet(c, mapToParams(map2));
      else
        cSmartSet_withConverter(valueConverter, c, mapToParams(map2));
    }

    public A conceptForID(Object id) {
      return getConcept(cc, cClass, toLong(id));
    }

    public String updateObject(Object id, Map<String, String> map) {
      A c = conceptForID(id);
      if (c == null)
        return "Object " + id + " not found";
      {
        String __2 = checkFilters(c);
        if (!empty(__2))
          return __2;
      }
      setValues(c, map);
      pcallFAll(onCreateOrUpdate, c);
      return "Object " + id + " updated";
    }

    public String deleteObject(Object id) {
      A c = conceptForID(id);
      if (c == null)
        return "Object " + id + " not found";
      {
        String __3 = checkFilters(c);
        if (!empty(__3))
          return __3;
      }
      deleteConcept(c);
      return "Object " + id + " deleted";
    }

    public String checkFilters(A c) {
      return checkConceptFields(c, mapToParams(filters)) ? "" : "Object " + c.id + " not in view";
    }

    public HCRUD_Concepts<A> addFilters(Map<String, Object> map) {
      {
        final Map<String, Object> __4 = unnull(map);
        for (String field : keys(__4)) {
          Object value = __4.get(field);
          addFilter(field, value);
        }
      }
      return this;
    }

    public HCRUD_Concepts<A> addFilter(String field, Object value) {
      filters = orderedMapPutOrCreate(filters, field, value);
      return this;
    }

    public Renderer getRenderer(String field) {
      Class type = fieldType(cClass, field);
      if (eq(type, boolean.class))
        return new CheckBox();
      if (eq(type, Concept.Ref.class)) {
        Class<? extends Concept> c = getTypeArgumentAsClass(genericFieldType(cClass, field));
        return makeComboBox(comboBoxItemsForConceptClass(c));
      }
      if (eq(type, Concept.RefL.class)) {
        Class<? extends Concept> c = getTypeArgumentAsClass(genericFieldType(cClass, field));
        List<String> items = comboBoxItemsForConceptClass(c);
        return new FlexibleLengthList(makeComboBox(items));
      }
      return super.getRenderer(field);
    }

    public ComboBox makeComboBox(List<String> entries) {
      ComboBox cb = new ComboBox(entries);
      cb.valueToEntry = value -> {
        value = deref(value);
        print("ComboBox: value type=" + _getClass(value));
        if (value instanceof Concept) {
          long id = conceptID(((Concept) value));
          String entry = firstWhereFirstLongIs(entries, id);
          print("combobox selected: " + id + " / " + entry);
          return entry;
        }
        return null;
      };
      return cb;
    }

    public List<String> comboBoxItemsForConceptClass(Class<? extends Concept> c) {
      return itemPlus("", map(cc.list(c), val -> shorten(val.id + ": " + val)));
    }

    public boolean objectCanBeDeleted(Object id) {
      return !referencesBlockDeletion || !hasBackRefs(conceptForID(id));
    }
  }

  static public class HTML implements IFieldsToList {

    public String html;

    public HTML() {
    }

    public HTML(String html) {
      this.html = html;
    }

    public String toString() {
      return shortClassName(this) + "(" + html + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof HTML))
        return false;
      HTML __1 = (HTML) o;
      return eq(html, __1.html);
    }

    public int hashCode() {
      int h = 2228139;
      h = boostHashCombine(h, _hashCode(html));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { html };
    }

    public String get() {
      return html;
    }
  }

  static public class ConceptsRefChecker {

    public Concepts cc;

    public List<Err> errors = new ArrayList();

    static public class Err {
    }

    static public class ErrNoBackRef extends Err implements IFieldsToList {

      static final public String _fieldOrder = "ref dest";

      public Concept.Ref ref;

      public Concept dest;

      public ErrNoBackRef() {
      }

      public ErrNoBackRef(Concept.Ref ref, Concept dest) {
        this.dest = dest;
        this.ref = ref;
      }

      public String toString() {
        return shortClassName(this) + "(" + ref + ", " + dest + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ErrNoBackRef))
          return false;
        ErrNoBackRef __1 = (ErrNoBackRef) o;
        return eq(ref, __1.ref) && eq(dest, __1.dest);
      }

      public int hashCode() {
        int h = -1351603866;
        h = boostHashCombine(h, _hashCode(ref));
        h = boostHashCombine(h, _hashCode(dest));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { ref, dest };
      }
    }

    static public class ErrSuperfluousBackRef extends Err implements IFieldsToList {

      static final public String _fieldOrder = "ref dest";

      public Concept.Ref ref;

      public Concept dest;

      public ErrSuperfluousBackRef() {
      }

      public ErrSuperfluousBackRef(Concept.Ref ref, Concept dest) {
        this.dest = dest;
        this.ref = ref;
      }

      public String toString() {
        return shortClassName(this) + "(" + ref + ", " + dest + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ErrSuperfluousBackRef))
          return false;
        ErrSuperfluousBackRef __2 = (ErrSuperfluousBackRef) o;
        return eq(ref, __2.ref) && eq(dest, __2.dest);
      }

      public int hashCode() {
        int h = 1840777816;
        h = boostHashCombine(h, _hashCode(ref));
        h = boostHashCombine(h, _hashCode(dest));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { ref, dest };
      }
    }

    static public class ErrDanglingSource extends Err implements IFieldsToList {

      static final public String _fieldOrder = "ref dest";

      public Concept.Ref ref;

      public Concept dest;

      public ErrDanglingSource() {
      }

      public ErrDanglingSource(Concept.Ref ref, Concept dest) {
        this.dest = dest;
        this.ref = ref;
      }

      public String toString() {
        return shortClassName(this) + "(" + ref + ", " + dest + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ErrDanglingSource))
          return false;
        ErrDanglingSource __3 = (ErrDanglingSource) o;
        return eq(ref, __3.ref) && eq(dest, __3.dest);
      }

      public int hashCode() {
        int h = 666937292;
        h = boostHashCombine(h, _hashCode(ref));
        h = boostHashCombine(h, _hashCode(dest));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { ref, dest };
      }
    }

    static public class ErrDanglingDestination extends Err implements IFieldsToList {

      static final public String _fieldOrder = "ref dest";

      public Concept.Ref ref;

      public Concept dest;

      public ErrDanglingDestination() {
      }

      public ErrDanglingDestination(Concept.Ref ref, Concept dest) {
        this.dest = dest;
        this.ref = ref;
      }

      public String toString() {
        return shortClassName(this) + "(" + ref + ", " + dest + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ErrDanglingDestination))
          return false;
        ErrDanglingDestination __4 = (ErrDanglingDestination) o;
        return eq(ref, __4.ref) && eq(dest, __4.dest);
      }

      public int hashCode() {
        int h = -1158731011;
        h = boostHashCombine(h, _hashCode(ref));
        h = boostHashCombine(h, _hashCode(dest));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { ref, dest };
      }
    }

    public ConceptsRefChecker() {
    }

    public ConceptsRefChecker(Concepts cc) {
      this.cc = cc;
    }

    public List<Err> run() {
      errors.clear();
      if (cc == null)
        return errors;
      for (Concept c : cc.allConcepts()) try {
        Object badElement = firstElementNotSubclassing(c.backRefs, Concept.Ref.class);
        if (badElement != null) {
          print("Bad element in backRefs of " + c + ": " + badElement);
          continue;
        }
        for (Concept.Ref ref : cloneList(c.backRefs)) {
          if (ref.get() != c)
            errors.add(new ErrSuperfluousBackRef(ref, c));
          if (ref.concept()._concepts != cc)
            errors.add(new ErrDanglingSource(ref, c));
        }
        badElement = firstElementNotSubclassing(c.refs, Concept.Ref.class);
        if (badElement != null) {
          print("Bad element in backRefs of " + c + ": " + badElement);
          continue;
        }
        for (Concept.Ref ref : cloneList(c.refs)) if (ref.has()) {
          if (!contains(ref.get().backRefs, ref))
            errors.add(new ErrNoBackRef(ref, c));
          if (ref.get()._concepts != cc)
            errors.add(new ErrDanglingDestination(ref, c));
        }
      } catch (Throwable e) {
        _handleException(e);
        print("Error processing concept " + c);
      }
      return errors;
    }

    public List<Err> errors() {
      return errors;
    }
  }

  static public class Timestamp implements IFieldsToList {

    public long date;

    public Timestamp() {
    }

    public Timestamp(long date) {
      this.date = date;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Timestamp))
        return false;
      Timestamp __1 = (Timestamp) o;
      return date == __1.date;
    }

    public int hashCode() {
      int h = 2059094262;
      h = boostHashCombine(h, _hashCode(date));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { date };
    }

    public String toString() {
      return formatLocalDateWithSeconds(date);
    }
  }

  static public class HCRUD extends HAbstractRenderable {

    public HCRUD_Data data;

    public int defaultTextFieldCols = 80;

    public boolean mutationRights = true;

    public boolean allowCreateOrDelete = true;

    public boolean allowCreate = true;

    public boolean allowEdit = true;

    public boolean singleton = false;

    public boolean cmdsLeft = false;

    public String tableClass;

    public String formTableClass;

    public Set<String> unshownFields;

    public Set<String> uneditableFields;

    public Set<String> unlistedFields;

    public boolean showCheckBoxes = false;

    public boolean haveJQuery, haveSelectizeJS;

    public boolean needsJQuery = false;

    public boolean paginate = false;

    public boolean sortable = false;

    public Map<String, String> params;

    public HTMLPaginator paginator = new HTMLPaginator();

    public String sortByField;

    public String sortParameter = "sort";

    public boolean descending = false;

    public Object objectIDToHighlight;

    public HCRUD() {
    }

    public HCRUD(HCRUD_Data data) {
      this.data = data;
    }

    public HCRUD(String baseLink, HCRUD_Data data) {
      this.data = data;
      this.baseLink = baseLink;
    }

    public String newLink() {
      return appendQueryToURL(baseLink, "cmd", "new");
    }

    public String deleteLink(Object id) {
      return appendQueryToURL(baseLink, "delete_" + id, 1);
    }

    public String editLink(Object id) {
      return appendQueryToURL(baseLink, "edit", id);
    }

    public String duplicateLink(Object id) {
      return appendQueryToURL(baseLink, "duplicate", id);
    }

    public String render(boolean withCmds, Map<String, String> params) {
      this.params = params;
      if (!withCmds)
        return renderTable(false);
      {
        String __1 = handleCommands(params);
        if (!empty(__1))
          return __1;
      }
      return renderMsgs(params) + pUnlessEmpty(nav()) + renderTable(withCmds);
    }

    transient public IF0<String> nav;

    public String nav() {
      return nav != null ? nav.get() : nav_base();
    }

    final public String nav_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : nav_base();
    }

    public String nav_base() {
      List<String> l = new ArrayList();
      if (actuallyAllowCreate())
        l.add(ahref(newLink(), "New " + itemName()));
      return joinWithVBar(l);
    }

    public String handleCommands(Map<String, String> params) {
      List<String> msgs = new ArrayList();
      if (eqGet(params, "action", "create")) {
        if (!actuallyAllowCreate())
          throw fail("Creating objects not allowed");
        Object id = data.createObject(subMapStartingWith_dropPrefix(params, "f_"));
        msgs.add(itemName() + " created (ID: " + id + ")");
        objectIDToHighlight = id;
      }
      if (eqGet(params, "action", "update")) {
        if (!actuallyAllowEdit())
          throw fail("Editing objects not allowed");
        String id = params.get("id");
        msgs.add(data.updateObject(id, subMapStartingWith_dropPrefix(params, "f_")));
        objectIDToHighlight = id;
      }
      List<String> toDeleteList = keysDeprefixNemptyValue(params, "delete_");
      if (eq(params.get("bulkAction"), "deleteSelected"))
        toDeleteList.addAll(keysDeprefixNemptyValue(params, "obj_"));
      for (String toDelete : toDeleteList) {
        if (!actuallyAllowDelete())
          throw fail("Deleting objects not allowed");
        msgs.add(data.deleteObject(toDelete));
      }
      return nempty(msgs) ? refreshWithMsgs(msgs, "anchor", objectIDToHighlight != null ? "obj" + objectIDToHighlight : null) : "";
    }

    public String encodeField(String s) {
      return or(data.fieldNameToHTML(s), s);
    }

    transient public IF2<String, Object, String> renderValue;

    public String renderValue(String field, Object value) {
      return renderValue != null ? renderValue.get(field, value) : renderValue_base(field, value);
    }

    final public String renderValue_fallback(IF2<String, Object, String> _f, String field, Object value) {
      return _f != null ? _f.get(field, value) : renderValue_base(field, value);
    }

    public String renderValue_base(String field, Object value) {
      if (value instanceof HTML)
        return ((HTML) value).html;
      value = deref(value);
      if (value instanceof SecretValue)
        return hhiddenStuff(renderValue_inner(((SecretValue) value).get()));
      return renderValue_inner(value);
    }

    transient public IF1<Object, String> renderValue_inner;

    public String renderValue_inner(Object value) {
      return renderValue_inner != null ? renderValue_inner.get(value) : renderValue_inner_base(value);
    }

    final public String renderValue_inner_fallback(IF1<Object, String> _f, Object value) {
      return _f != null ? _f.get(value) : renderValue_inner_base(value);
    }

    public String renderValue_inner_base(Object value) {
      if (value instanceof Boolean)
        return yesNo_short(((Boolean) value));
      return htmlEncode_nlToBr_withIndents(strOrEmpty(value));
    }

    public String renderTable(boolean withCmds) {
      return renderTable(withCmds, data.list());
    }

    public String valueToSortable(Object value) {
      if (value instanceof HTML)
        return ((HTML) value).get();
      return strOrNull(value);
    }

    public String renderTable(boolean withCmds, List<Map<String, Object>> l) {
      if (empty(l))
        return p("No entries");
      if (nempty(sortByField))
        l = sortByTransformedMapKey_alphaNum(__46 -> valueToSortable(__46), l, sortByField);
      if (descending)
        l = reversed(l);
      Map<String, String> keyEncoding = new HashMap();
      List<Map<String, Object>> l2 = map(l, map -> {
        Object id = itemID(map);
        map = mapMinusKeys(map, joinSets(unshownFields, unlistedFields));
        Map<String, Object> map2 = postProcessTableRow(map, mapToMap((key, value) -> pair(mapPut_returnValue(keyEncoding, key, encodeField(key)), renderValue(key, value)), map));
        if (singleton)
          map2.remove(data.fieldNameToHTML(data.idField()));
        if (withCmds)
          map2 = addCmdsToTableRow(map, map2);
        map2.put(firstKey(map2), aname("obj" + id, firstValue(map2)));
        return map2;
      });
      List<String> out = new ArrayList();
      if (paginate) {
        paginator.processParams(params);
        paginator.baseLink = baseLink;
        paginator.max = l(l2);
        out.add(pUnlessEmpty(paginator.renderNav()));
        l2 = subListOrFull(l2, paginator.visibleRange());
      }
      Map<String, String> replaceHeaders = new HashMap();
      if (sortable && !singleton)
        for (String key : keys(keyEncoding)) {
          String html = keyEncoding.get(key);
          boolean sortedByField = eq(sortByField, key);
          boolean showDescendingLink = sortedByField && !descending;
          String htmlOld = html;
          if (sortedByField) {
            String title = showDescendingLink ? "Click here to sort descending" : "Click here to sort ascending";
            String titleSorted = "Sorted by this field (" + (descending ? "descending" : "ascending") + ")";
            title = titleSorted + ". " + title;
            html = span_title(title, unicode_downOrUpPointingTriangle(descending)) + " " + html;
          }
          String sortLink = appendQueryToURL(baseLink, sortParameter, showDescendingLink ? "-" + key : key);
          replaceHeaders.put(htmlOld, ahref(sortLink, html));
        }
      out.add(hpostform(htmlTable2_noHtmlEncode(l2, paramsPlus(tableParams(), "replaceHeaders", replaceHeaders)) + (!withCmds || !showCheckBoxes ? "" : "\n" + pUnlessEmpty(renderBulkCmds())), "action", baseLink));
      return lines_rtrim(out);
    }

    transient public IF0<String> renderBulkCmds;

    public String renderBulkCmds() {
      return renderBulkCmds != null ? renderBulkCmds.get() : renderBulkCmds_base();
    }

    final public String renderBulkCmds_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : renderBulkCmds_base();
    }

    public String renderBulkCmds_base() {
      return "Bulk action: " + hselect("bulkAction", litorderedmap("", "", "deleteSelected", "Delete selected")) + " " + hsubmit("OK", "onclick", "return confirm('Are you sure?')");
    }

    public Map<String, Object> addCmdsToTableRow(Map<String, Object> map, Map<String, Object> map2) {
      if (showCheckBoxes) {
        Object id = itemID(map);
        map2.put(checkBoxKey(), hcheckbox("obj_" + id, false, "title", "Select this object for a bulk action"));
        map2 = putKeysFirst(map2, checkBoxKey());
      }
      map2.put(cmdsKey(), renderCmds(map));
      if (cmdsLeft)
        map2 = putKeysFirst(map2, cmdsKey());
      return map2;
    }

    public Object[] tableParams() {
      return litparams("tdParams", litparams("valign", "top"), "tableParams", litparams("class", tableClass));
    }

    public String renderForm(Map<String, Object> map) {
      map = mapMinusKeys(map, joinSets(unshownFields, uneditableFields));
      List<List<String>> matrix = map(map, (field, value) -> {
        String help = data.fieldHelp(field);
        return ll(encodeField(field), renderInput(field, value) + (empty(help) ? "" : p(small(help), "style", "text-align: right")));
      });
      massageFormMatrix(map, matrix);
      return htableRaw_valignTop(matrix, empty(formTableClass) ? litparams("border", 1, "cellpadding", 4) : litparams("class", formTableClass));
    }

    public String renderInput(String field, Object value) {
      String name = "f_" + field;
      return renderInput(name, data.getRenderer(field), value);
    }

    public String renderInput(String name, HCRUD_Data.Renderer r, Object value) {
      if (r != null)
        value = r.preprocessValue(value);
      if (r instanceof HCRUD_Data.TextArea)
        return htextarea(strOrEmpty(value), "name", name, "cols", ((HCRUD_Data.TextArea) r).cols, "rows", ((HCRUD_Data.TextArea) r).rows);
      if (r instanceof HCRUD_Data.TextField)
        return htextfield(name, strOrEmpty(value), "size", ((HCRUD_Data.TextField) r).cols, "style", "font-family: monospace");
      if (r instanceof HCRUD_Data.ComboBox)
        return renderComboBox(name, ((HCRUD_Data.ComboBox) r).valueToEntry(value), ((HCRUD_Data.ComboBox) r).entries);
      if (r instanceof HCRUD_Data.CheckBox)
        return htrickcheckboxWithText(name, "", isTrue(value));
      if (r instanceof HCRUD_Data.FlexibleLengthList) {
        List list = (List) value;
        List<String> rows = new ArrayList();
        int leeway = 5, n = l(list) + leeway;
        for (int i = 0; i < n; i++) {
          Object item = _get(list, i);
          print("Item: " + item);
          rows.add(tr(td(i + 1 + ".", "align", "right") + td(renderInput(name + "_" + i, ((HCRUD_Data.FlexibleLengthList) r).itemRenderer, item))));
        }
        return htag("table", lines(rows));
      }
      return renderInput_default(name, value);
    }

    public String renderInput_default(String name, Object value) {
      return htextfield(name, strOrEmpty(value), "size", defaultTextFieldCols);
    }

    public String renderNewForm() {
      return renderNewForm(data.emptyObject());
    }

    public String renderNewForm(Map<String, Object> map1) {
      Map<String, Object> map = mapWithoutKey(map1, data.idField());
      return hpostform(hhidden("action", "create") + renderForm(map) + p(hsubmit("Create")), paramsPlus(formParameters(), "action", baseLink));
    }

    transient public IF0<Object[]> formParameters;

    public Object[] formParameters() {
      return formParameters != null ? formParameters.get() : formParameters_base();
    }

    final public Object[] formParameters_fallback(IF0<Object[]> _f) {
      return _f != null ? _f.get() : formParameters_base();
    }

    public Object[] formParameters_base() {
      return null;
    }

    public String renderEditForm(String id) {
      Map<String, Object> map = mapWithoutKey(data.getObject(id), data.idField());
      if (map == null)
        return htmlEncode2("Entry " + id + " not found");
      return hpostform(hhidden("action", "update") + hhidden("id", id) + p("Object ID: " + htmlEncode2(id)) + renderForm(map) + p(hsubmit("Save changes")), paramsPlus(formParameters(), "action", baseLink + "#obj" + id));
    }

    public String renderPage(Map<String, String> params) {
      if (eqGet(params, "cmd", "new"))
        return frame("New " + itemName(), renderNewForm());
      if (nempty(params.get("edit")))
        return frame("Edit " + itemName(), renderEditForm(params.get("edit")));
      if (nempty(params.get("duplicate")))
        return frame("New " + itemName(), renderNewForm(data.getObject(params.get("duplicate"))));
      return frame(ahref(baseLink, firstToUpper(singleton ? data.itemName() : data.itemNamePlural())), render(mutationRights, params));
    }

    public HCRUD makeFrame(MakeFrame makeFrame) {
      super.makeFrame(makeFrame);
      return this;
    }

    public String cmdsKey() {
      return "<!-- cmds -->";
    }

    public String checkBoxKey() {
      return "<!-- checkbox -->";
    }

    public String itemName() {
      return data.itemName();
    }

    transient public IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> postProcessTableRow;

    public Map<String, Object> postProcessTableRow(Map<String, Object> data, Map<String, Object> rendered) {
      return postProcessTableRow != null ? postProcessTableRow.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    final public Map<String, Object> postProcessTableRow_fallback(IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> _f, Map<String, Object> data, Map<String, Object> rendered) {
      return _f != null ? _f.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    public Map<String, Object> postProcessTableRow_base(Map<String, Object> data, Map<String, Object> rendered) {
      return rendered;
    }

    public Object itemID(Map<String, Object> item) {
      return mapGet(item, data.idField());
    }

    transient public IF1<Map<String, Object>, String> renderCmds;

    public String renderCmds(Map<String, Object> item) {
      return renderCmds != null ? renderCmds.get(item) : renderCmds_base(item);
    }

    final public String renderCmds_fallback(IF1<Map<String, Object>, String> _f, Map<String, Object> item) {
      return _f != null ? _f.get(item) : renderCmds_base(item);
    }

    public String renderCmds_base(Map<String, Object> item) {
      Object id = itemID(item);
      return joinNemptiesWithVBar(!actuallyAllowEdit() ? null : ahref(editLink(id), "EDIT"), !actuallyAllowDelete() ? null : !data.objectCanBeDeleted(id) ? span_title("Object can't be deleted, please delete references first", htmlEncode2(unicode_DEL())) : ahrefWithConfirm("Really delete item " + id + "?", deleteLink(id), htmlEncode2(unicode_DEL()), "title", "delete"), !actuallyAllowCreate() ? null : ahref(duplicateLink(id), "dup", "title", "duplicate"));
    }

    public boolean actuallyAllowCreate() {
      return !singleton && allowCreateOrDelete && allowCreate;
    }

    public boolean actuallyAllowEdit() {
      return allowCreateOrDelete && allowEdit;
    }

    public boolean actuallyAllowDelete() {
      return !singleton && allowCreateOrDelete;
    }

    transient public IVF2<Map<String, Object>, List<List<String>>> massageFormMatrix;

    public void massageFormMatrix(Map<String, Object> map, List<List<String>> matrix) {
      if (massageFormMatrix != null)
        massageFormMatrix.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    final public void massageFormMatrix_fallback(IVF2<Map<String, Object>, List<List<String>>> _f, Map<String, Object> map, List<List<String>> matrix) {
      if (_f != null)
        _f.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    public void massageFormMatrix_base(Map<String, Object> map, List<List<String>> matrix) {
    }

    transient public IF3<String, String, List<String>, String> renderComboBox;

    public String renderComboBox(String name, String value, List<String> entries) {
      return renderComboBox != null ? renderComboBox.get(name, value, entries) : renderComboBox_base(name, value, entries);
    }

    final public String renderComboBox_fallback(IF3<String, String, List<String>, String> _f, String name, String value, List<String> entries) {
      return _f != null ? _f.get(name, value, entries) : renderComboBox_base(name, value, entries);
    }

    public String renderComboBox_base(String name, String value, List<String> entries) {
      if (haveSelectizeJS) {
        String id = aGlobalID();
        return hselect_list(entries, value, "name", name, "id", id) + hjs("$('#" + id + "').selectize" + "\r\n          ({\r\n            searchField: 'text',\r\n            openOnFocus: true\r\n          });\r\n        ") + hcss(".selectize-input { min-width: 300px }");
      }
      if (haveJQuery) {
        String id = aGlobalID();
        return tag("datalist", mapToLines("hoption", entries), "id", id) + tag("input", "", "name", name, "list", id);
      }
      return hselect_list(entries, value, "name", name);
    }

    public void processSortParameter(Map<String, String> params) {
      String sort = mapGet(params, sortParameter);
      sortByField = null;
      descending = false;
      if (nempty(sort))
        if (startsWith(sort, "-")) {
          descending = true;
          sortByField = substring(sort, 1);
        } else
          sortByField = sort;
    }
  }

  static public class DefaultValueConverterForField implements ValueConverterForField {

    public OrError<Object> convertValue(Object object, Field field, Object value) {
      Class type = primitiveToBoxedTypeOpt(field.getType());
      if (isInstance(type, value))
        return new OrError(value);
      if (type == Integer.class && !(value instanceof Integer))
        return new OrError(toInt(trimIfString(value)));
      if (type == Double.class && !(value instanceof Double))
        return new OrError(toDouble(trimIfString(value)));
      if (type == Boolean.class && value instanceof String)
        return new OrError(eqicOneOf((String) value, "1", "true"));
      if (type == GlobalID.class && value instanceof String)
        return new OrError(new GlobalID((String) value));
      return new OrError(value);
    }
  }

  static public class OrError<A> extends Var<A> {

    public Object error;

    public OrError() {
    }

    public OrError(A value) {
      super(value);
    }

    public OrError(boolean dummy, Object error) {
      this.error = error;
      assertNotNull(error);
    }

    public boolean ok() {
      return error == null;
    }

    public Object error() {
      return error;
    }

    public String toString() {
      return ok() ? super.toString() : str(error);
    }
  }

  static public class ReliableSingleThread implements Runnable {

    public boolean _isTransient() {
      return true;
    }

    public Object runnable;

    public String name = "Single Thread";

    public boolean cancelBeforeTrigger = false;

    public F0<AutoCloseable> enter;

    public int cancelTimeOut = 10000;

    public boolean trigger = false;

    public Thread thread;

    public WeakReference<Thread> threadBeingCancelled;

    public ReliableSingleThread(Object runnable) {
      this.runnable = runnable;
    }

    public void trigger() {
      go();
    }

    synchronized public void go() {
      if (cancelBeforeTrigger)
        cancel();
      trigger = true;
      if (!running()) {
        AutoCloseable __1 = callF(enter);
        try {
          thread = startThread(name, new Runnable() {

            public void run() {
              try {
                AutoCloseable __2 = callF(enter);
                try {
                  _run();
                } finally {
                  _close(__2);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "temp callF(enter);\r\n        _run();";
            }
          });
        } finally {
          _close(__1);
        }
      }
    }

    public void run() {
      go();
    }

    public void get() {
      go();
    }

    synchronized public boolean running() {
      return thread != null;
    }

    public void triggerAndWait() {
      trigger();
      waitUntilDone();
    }

    public void waitUntilDone() {
      while (running()) sleep(1);
    }

    public void _run() {
      try {
        while (licensed()) {
          Thread oldThread;
          synchronized (this) {
            if (!trigger) {
              thread = null;
              break;
            }
            oldThread = getWeakRef(threadBeingCancelled);
            trigger = false;
          }
          if (oldThread != null && oldThread != currentThread())
            oldThread.join(cancelTimeOut);
          pcallF(runnable);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    synchronized public void cancel() {
      if (thread == null)
        return;
      threadBeingCancelled = new WeakReference(thread);
      cancelAndInterruptThread(thread);
      thread = null;
    }

    public void cancelAndTrigger() {
      cancel();
      trigger();
    }

    synchronized public boolean triggered() {
      return trigger;
    }

    public void cleanMeUp() {
      cancel();
    }

    public ReliableSingleThread cancelBeforeTrigger() {
      cancelBeforeTrigger = true;
      return this;
    }
  }

  static public class MMOPattern {

    static public class Phrase extends MMOPattern implements IFieldsToList {

      public String phrase;

      public boolean quoted = false;

      public Phrase() {
      }

      public Phrase(String phrase, boolean quoted) {
        this.quoted = quoted;
        this.phrase = phrase;
      }

      public String toString() {
        return shortClassName(this) + "(" + phrase + ", " + quoted + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Phrase))
          return false;
        Phrase __1 = (Phrase) o;
        return eq(phrase, __1.phrase) && eq(quoted, __1.quoted);
      }

      public int hashCode() {
        int h = -1905095975;
        h = boostHashCombine(h, _hashCode(phrase));
        h = boostHashCombine(h, _hashCode(quoted));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { phrase, quoted };
      }
    }

    static public class And extends MMOPattern implements IFieldsToList {

      public List<MMOPattern> l;

      public And() {
      }

      public And(List<MMOPattern> l) {
        this.l = l;
      }

      public String toString() {
        return shortClassName(this) + "(" + l + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof And))
          return false;
        And __2 = (And) o;
        return eq(l, __2.l);
      }

      public int hashCode() {
        int h = 65975;
        h = boostHashCombine(h, _hashCode(l));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { l };
      }
    }

    static public class Or extends MMOPattern implements IFieldsToList {

      public List<MMOPattern> l;

      public Or() {
      }

      public Or(List<MMOPattern> l) {
        this.l = l;
      }

      public String toString() {
        return shortClassName(this) + "(" + l + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Or))
          return false;
        Or __3 = (Or) o;
        return eq(l, __3.l);
      }

      public int hashCode() {
        int h = 2563;
        h = boostHashCombine(h, _hashCode(l));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { l };
      }
    }

    static public class Not extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public Not() {
      }

      public Not(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Not))
          return false;
        Not __4 = (Not) o;
        return eq(p, __4.p);
      }

      public int hashCode() {
        int h = 78515;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }

    static public class Weighted extends MMOPattern implements IFieldsToList {

      static final public String _fieldOrder = "weight p";

      public double weight;

      public MMOPattern p;

      public Weighted() {
      }

      public Weighted(double weight, MMOPattern p) {
        this.p = p;
        this.weight = weight;
      }

      public String toString() {
        return shortClassName(this) + "(" + weight + ", " + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Weighted))
          return false;
        Weighted __5 = (Weighted) o;
        return weight == __5.weight && eq(p, __5.p);
      }

      public int hashCode() {
        int h = -446368457;
        h = boostHashCombine(h, _hashCode(weight));
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { weight, p };
      }
    }

    static public class StartOfLine extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public StartOfLine() {
      }

      public StartOfLine(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof StartOfLine))
          return false;
        StartOfLine __6 = (StartOfLine) o;
        return eq(p, __6.p);
      }

      public int hashCode() {
        int h = -326863539;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }

    static public class EndOfLine extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public EndOfLine() {
      }

      public EndOfLine(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof EndOfLine))
          return false;
        EndOfLine __7 = (EndOfLine) o;
        return eq(p, __7.p);
      }

      public int hashCode() {
        int h = -810372346;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }
  }

  static public interface IVF2<A, B> {

    public void get(A a, B b);
  }

  abstract static public class DynPrintLogAndEnabled extends DynPrintLog {

    volatile public boolean enabled = true;

    transient public JPanel buttons;

    public JComponent visualize() {
      return dm_visualizeWithEnabled(super.visualize());
    }

    public JComponent visualizeWithoutEnabled() {
      return super.visualize();
    }

    public JComponent dm_visualizeWithEnabled(JComponent main) {
      return centerAndSouthWithMargins(main, buttons = makeControlArea());
    }

    public JPanel makeControlArea() {
      return jrightalignedline(makeEnabledCheckBox());
    }

    static public JCheckBox makeEnabledCheckBox() {
      return dm_fieldCheckBox("enabled");
    }

    public void setEnabled(boolean b) {
      setField("enabled", b);
    }
  }

  static public class Not<A> implements IFieldsToList, Transformable, Visitable {

    public A a;

    public Not() {
    }

    public Not(A a) {
      this.a = a;
    }

    public String toString() {
      return shortClassName(this) + "(" + a + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof Not))
        return false;
      Not __0 = (Not) o;
      return eq(a, __0.a);
    }

    public int hashCode() {
      int h = 78515;
      h = boostHashCombine(h, _hashCode(a));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { a };
    }

    public Object transformUsing(IF1 f) {
      return new Not((A) f.get(a));
    }

    public void visitUsing(IVF1 f) {
      f.get(a);
    }

    public Boolean get(Object o) {
      return not((Boolean) callF(a, o));
    }
  }

  static public interface IFieldsToList {

    public Object[] _fieldsToList();
  }

  static public interface IF2<A, B, C> {

    public C get(A a, B b);
  }

  static public class And<A> implements IFieldsToList, Transformable, Visitable {

    public A a;

    public A b;

    public And() {
    }

    public And(A a, A b) {
      this.b = b;
      this.a = a;
    }

    public String toString() {
      return shortClassName(this) + "(" + a + ", " + b + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof And))
        return false;
      And __0 = (And) o;
      return eq(a, __0.a) && eq(b, __0.b);
    }

    public int hashCode() {
      int h = 65975;
      h = boostHashCombine(h, _hashCode(a));
      h = boostHashCombine(h, _hashCode(b));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { a, b };
    }

    public Object transformUsing(IF1 f) {
      return new And((A) f.get(a), (A) f.get(b));
    }

    public void visitUsing(IVF1 f) {
      f.get(a);
      f.get(b);
    }
  }

  static public class Var<A> implements IVar<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public synchronized void clear() {
      v = null;
    }

    public String toString() {
      return str(get());
    }
  }

  static public interface ValueConverterForField {

    public OrError<Object> convertValue(Object object, Field field, Object value);
  }

  static public interface IF3<A, B, C, D> {

    public D get(A a, B b, C c);
  }

  static public class IntRange {

    public int start, end;

    public IntRange() {
    }

    public IntRange(int start, int end) {
      this.end = end;
      this.start = start;
    }

    public IntRange(IntRange r) {
      start = r.start;
      end = r.end;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    final public int length() {
      return end - start;
    }

    final public boolean empty() {
      return start >= end;
    }

    final public boolean isEmpty() {
      return start >= end;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  abstract static public class HAbstractRenderable {

    public String baseLink;

    public MakeFrame makeFrame = (title, contents) -> h1_title(title) + contents;

    static public interface MakeFrame {

      public String makeFrame(String title, String contents);
    }

    public HAbstractRenderable() {
    }

    public HAbstractRenderable(String baseLink) {
      this.baseLink = baseLink;
    }

    public HAbstractRenderable makeFrame(MakeFrame makeFrame) {
      this.makeFrame = makeFrame;
      return this;
    }

    public String baseLinkPlus(String uri) {
      return nempty(uri) ? appendSlash(baseLink) + uri : baseLink;
    }

    public String frame(String title, String contents) {
      return makeFrame.makeFrame(title, contents);
    }

    public String refreshWithMsgs(String... msgs) {
      return refreshWithMsgs(asList(msgs));
    }

    public String refreshWithMsgs(List<String> msgs, Object... __) {
      String anchor = (String) (optPar("anchor", __));
      return hrefresh(addAnchorToURL(appendQueryToURL(baseLink, "msg", htmlEncode_nlToBr(lines_rtrim(msgs))), anchor));
    }

    public String renderMsgs(Map<String, String> params) {
      return pUnlessEmpty(params.get("msg"));
    }
  }

  static public interface IVF1<A> {

    public void get(A a);
  }

  static public class HTMLPaginator {

    public String startParam = "start";

    public String baseLink;

    public int start, step = 50;

    public int max;

    public void processParams(Map<String, String> params) {
      start = parseInt(mapGet(params, startParam));
    }

    public String renderNav(Object... __) {
      return pageNav2(baseLink, max, start, step, startParam, __);
    }

    public IntRange visibleRange() {
      return intRange(start, min(max, start + step));
    }
  }

  static public interface Visitable {

    public void visitUsing(IVF1 f);
  }

  static public interface Transformable {

    public Object transformUsing(IF1 f);
  }

  static public interface IVar<A> extends IF0<A> {

    public void set(A a);

    public A get();

    default public boolean has() {
      return get() != null;
    }

    default public void clear() {
      set(null);
    }
  }

  static public String ukTimeZone_string() {
    return "Europe/London";
  }

  static public ReliableSingleThread dm_rst(Runnable r) {
    return dm_rst(dm_current_mandatory(), r);
  }

  static public ReliableSingleThread dm_rst(DynModule mod, Runnable r) {
    return dm_rst(mod, new ReliableSingleThread(r));
  }

  static public ReliableSingleThread dm_rst(DynModule mod, ReliableSingleThread rst) {
    rst.enter = dm_rEnter(mod);
    return rst;
  }

  static public void dm_setModuleName(Object module, String name) {
    dm_callModule(module, "setModuleName", name);
  }

  static public void dm_setModuleName(String name) {
    dm_setModuleName(dm_current_mandatory_generic(), name);
  }

  static public void dm_assertFirstSibling() {
    if (!dm_isFirstSiblingModule(dm_current_mandatory_generic()))
      throw fail("Don't start this module multiple times. This instance will exit.");
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    Object f = getThreadLocal(print_byThread_dontCreate());
    if (f == null)
      f = print_allThreads;
    if (f != null)
      if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
        return;
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public String dbProgramID() {
    return getDBProgramID();
  }

  static public FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  static public FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return vmBus_timerStarted(timer);
  }

  static public FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  static public FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(MultiMap mm) {
    return mm == null || mm.isEmpty();
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public AutoCloseable temp_printPrefix(String prefix) {
    Object oldValue = print_byThread();
    print_setPrefixForThread(prefix);
    return new AutoCloseable() {

      public String toString() {
        return "print_byThread().set(oldValue);";
      }

      public void close() throws Exception {
        print_byThread().set(oldValue);
      }
    };
  }

  static public Map<String, String> decodeURIParams(String query) {
    return decodeHQuery(query);
  }

  static public boolean cset_trueIfChanged(Concept c, Object... values) {
    try {
      return cset(c, values) != 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  static public <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  static public <A extends Concept> A conceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(c, params);
  }

  static public <A extends Concept> A conceptWhere(Concepts cc, Class<A> c, Object... params) {
    return findConceptWhere(cc, c, params);
  }

  static public String hrefresh(String target) {
    return hrefresh(0, target);
  }

  static public String hrefresh(double seconds) {
    return hrefresh(seconds, "");
  }

  static public String hrefresh(double seconds, String target) {
    return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public Object subBot_serveFile(File file) {
    return call(getMainBot(), "serveFile", file);
  }

  static public Object subBot_serveFile(File file, String mimeType) {
    return call(getMainBot(), "serveFile", file, mimeType);
  }

  static public Concept getConcept(long id) {
    return db_mainConcepts().getConcept(id);
  }

  static public Concept getConcept(Concepts concepts, long id) {
    return concepts.getConcept(id);
  }

  static public <A extends Concept> A getConcept(Class<A> cc, long id) {
    return getConcept(db_mainConcepts(), cc, id);
  }

  static public <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
    Concept c = concepts.getConcept(id);
    if (c == null)
      return null;
    if (!isInstance(cc, c))
      throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
    return (A) c;
  }

  static public NanoHTTPD.Response serve404() {
    return serve404("Not Found");
  }

  static public NanoHTTPD.Response serve404(String msg) {
    return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Status.NOT_FOUND, NanoHTTPD.MIME_PLAINTEXT, "Code 404 - " + msg);
  }

  static public <A extends Concept> List<A> cdelete(Class<A> c, Object... params) {
    return deleteConcepts(c, params);
  }

  static public void cdelete(Concept c) {
    deleteConcept(c);
  }

  static public <A extends Concept> void cdelete(Collection<A> c) {
    for (A a : cloneList(c)) cdelete(a);
  }

  static public Object subBot_maxCacheHeaders(Object response) {
    return callMainBot("maxCacheHeaders", response);
  }

  static public Object serveInputStream(InputStream in, String mimeType) {
    return subBot_serveInputStream(in, mimeType);
  }

  static public BufferedInputStream bufferedFileInputStream(File f) {
    return bufferedInputStream(f);
  }

  static public BufferedInputStream bufferedFileInputStream(File f, int bufSize) {
    try {
      return new BufferedInputStream(new FileInputStream(f), bufSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public String rawLink(String pageName) {
    return "/" + parseSnippetID(getProgramID()) + "/raw" + addPrefix("/", pageName);
  }

  static public String rawLink() {
    return "/" + parseSnippetID(getProgramID()) + "/raw";
  }

  static public String rawLink(String pageName, String contents) {
    return ahref(rawLink(pageName), contents);
  }

  static public String ul_htmlEncode(String... list) {
    return ul_htmlEncode(asList(list));
  }

  static public String ul_htmlEncode(Collection<String> list, Object... params) {
    return ul(map("htmlEncode2", list), params);
  }

  static public List<String> getThreadNames(Collection<Thread> threads) {
    return mapMethod(threads, "getName");
  }

  static public List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  static public List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  static public String webChatBotLogsHTML2(final String baseLink, final Map<String, String> params) {
    return withDBLock(new F0<String>() {

      public String get() {
        try {
          List<String> l = new ArrayList();
          for (Conversation conv : sortByCalculatedFieldDesc(list(Conversation.class), new F1<Conversation, Object>() {

            public Object get(Conversation c) {
              try {
                return empty(c.msgs) ? c.created : last(c.msgs).time;
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "empty(c.msgs) ? c.created : last(c.msgs).time";
            }
          })) {
            List<List<Msg>> dialogs = reversed(unnull(conv.oldDialogs));
            if (l(conv.msgs) > 1)
              l.add(webChatBotLogsHTML_formatDialog(str(conv.id), conv.msgs));
            int i = 2;
            for (List<Msg> msgs : dialogs) if (l(msgs) > 1)
              l.add(webChatBotLogsHTML_formatDialog(conv.id + "/" + (i++), msgs));
          }
          int perPage = 50, n = parseIntOpt(params.get("n"));
          return h3_htitle("Chat Logs") + pageNav2(baseLink, l(l), n, perPage, "n") + ul(subList(l, n, n + perPage), null, "style", "margin-top: 1em");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new L<S> l;\r\n    for (Conversation conv : sortByCalculatedFieldDesc(list Conv...";
      }
    });
  }

  static public Object serveText(Object s) {
    return call(getMainBot(), "serveByteArray", toUtf8(str(s)), "text/plain; charset=utf8");
  }

  static public String jsonEncode_breakAtLevels(int levels, Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode_breakAtLevels(levels, o, buf, 1);
    return str(buf);
  }

  static public void jsonEncode_breakAtLevels(int levels, Object o, StringBuilder buf, int level) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n" + spaces(level * 2));
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode_breakAtLevels(levels, map.get(key), buf, level + 1);
      }
      if (level <= levels)
        buf.append("\n" + spaces((level - 1) * 2));
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level <= levels)
          buf.append("\n" + spaces(level * 2));
        jsonEncode_breakAtLevels(levels, element, buf, level + 1);
      }
      if (level <= levels)
        buf.append("\n" + spaces((level - 1) * 2));
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public Lock dbLock() {
    return db_mainConcepts().lock;
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        lock.lockInterruptibly();
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll(vm_busListeners_live(), msg, arg);
    pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public Class mc() {
    return dynNewBotLoadable.class;
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String or2_trim(String a, String b) {
    a = trim(a);
    if (nempty(a))
      return a;
    return trim(b);
  }

  static public String or2_trim(String a, String b, String c) {
    return or2_trim(or2_trim(a, b), c);
  }

  static public String hcss(Object contents) {
    return htag("style", contents);
  }

  static public String hexColorToCSSRGB(String hex) {
    return empty(hex) ? null : "rgb(" + joinWithComma(rgbToIntList(new RGB(hex))) + ")";
  }

  static public String hscript(String script) {
    return hjavascript(script);
  }

  static public String jsQuote(String s) {
    return javascriptQuote(s);
  }

  static public String htmlEncode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String stringIf(boolean b, String s) {
    return stringIfTrue(b, s);
  }

  static public boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  static public String loadSnippet_cached(String id) {
    return loadSnippet_simpleCache(id);
  }

  static public String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  static public String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  static public String ahref(String link, Object contents, Object... params) {
    return link == null ? str(contents) : href(link, contents, params);
  }

  static public String lower(String s) {
    return s == null ? null : s.toLowerCase();
  }

  static public char lower(char c) {
    return Character.toLowerCase(c);
  }

  static public String psI_str(String snippetID) {
    return str(psI(snippetID));
  }

  static public String jsBool(boolean b) {
    return b ? "true" : "false";
  }

  static public String hreplaceTitle(String html, String newTitle) {
    return hreplacetag(html, "title", htitle(newTitle));
  }

  static public String hhtml(Object contents) {
    return containerTag("html", contents);
  }

  static public String hhead(Object contents) {
    return tag("head", contents);
  }

  static public String htitle(String title) {
    return hfulltag("title", htmlencode_noQuotes(title));
  }

  static public String loadJQuery2() {
    return "<script src=\"https://code.jquery.com/jquery-3.2.1.min.js\"></script>";
  }

  static public String hbody(Object contents, Object... params) {
    return tag("body", contents, params);
  }

  static public String hjavascript(String script) {
    return tag("script", script, "type", "text/javascript");
  }

  static public Object subBot_serveJavaScript(String html) {
    return subBot_serveWithContentType(html, "text/javascript");
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public Collection<Concept> conceptsWhere(String c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public String ymd_minus_hm() {
    return ymd() + "-" + hhmm();
  }

  static public Object serveCSVWithFileName(String fileName, String text) {
    Object response = serveWithContentType(text, "text/csv");
    call(response, "addHeader", "Content-Disposition", "inline; filename=\"" + fileName + "\"");
    return response;
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public List flattenList2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Collection)
        for (Object sub : (Collection) x) l.addAll(flattenList2(sub));
      else if (x != null)
        l.add(x);
    return l;
  }

  static public String dropUriPrefix(String prefix, String uri) {
    prefix = dropTrailingSlash(prefix);
    if (empty(prefix))
      return uri;
    if (eq(uri, prefix) || startsWith(uri, prefix + "/"))
      return substring(uri, l(prefix));
    return uri;
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  static public String p(Object contents, Object... params) {
    return tag("p", contents, params) + "\n";
  }

  static public String hjs_markRowMagic(Object... __) {
    String color = optPar("color", __, "#99f");
    return hjs(replaceDollarVars("\r\n    var rowMagic_hash = window.location.hash.substr(1);\r\n    if (rowMagic_hash)\r\n      $(\"a[name=\" + rowMagic_hash + \"]\").closest('tr').css({ 'background-color' : '$color'});\r\n  ", "color", color));
  }

  static public ThreadLocal htmlTable2_cellEncoder = new ThreadLocal();

  static public String htmlTable2(Object data, Object... __) {
    boolean htmlEncode = optPar("htmlEncode", __, true);
    boolean useBr = boolPar("useBr", __);
    Map<String, Object[]> paramsByColName = (Map<String, Object[]>) (optPar("paramsByColName", __));
    Object[] tableParams = (Object[]) (optPar("tableParams", __));
    Object[] trParams = (Object[]) (optPar("trParams", __));
    Object[] tdParams = (Object[]) (optPar("tdParams", __));
    Map<String, String> replaceHeaders = (Map<String, String>) (optPar("replaceHeaders", __));
    List<List<String>> rows = new ArrayList();
    List<String> cols = new ContentsIndexedList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrText(key), structureOrText(value)));
      }
    } else
      print("Unknown data type: " + data);
    int w = 0;
    for (List<String> row : rows) w = max(w, l(row));
    StringBuilder buf = new StringBuilder();
    buf.append(hopeningtag("table", paramsPlus(tableParams, "border", html_valueLessParam())) + "\n");
    buf.append("<tr>\n");
    for (String cell : padList(cols, w, "")) buf.append("  <th>" + htmlTable2_encodeCell(getOrKeep(replaceHeaders, cell), htmlEncode, useBr) + "</th>\n");
    buf.append("</tr>\n");
    for (List<String> row : rows) {
      buf.append(hopeningtag("tr", trParams));
      int i = 0;
      for (String cell : padList(row, w, "")) {
        String col = get(cols, i++);
        Object[] params = paramsPlus(tdParams, mapGet(paramsByColName, col));
        buf.append("  " + tag("td", htmlTable2_encodeCell(cell, htmlEncode, useBr), params) + "\n");
      }
      buf.append("</tr>\n");
    }
    buf.append("</table>\n");
    return buf.toString();
  }

  static public String htmlTable2_encodeCell(String cell, boolean useHtmlEncode, boolean useBr) {
    if (htmlTable2_cellEncoder.get() != null)
      return (String) callF(htmlTable2_cellEncoder.get(), cell);
    if (useHtmlEncode)
      cell = htmlEncode2(cell);
    if (useBr)
      cell = nlToBr(cell);
    return cell;
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    return map(map, (Object) f);
  }

  static public NavigableMap<String, String> emojiShortNameMap_cache;

  static public NavigableMap<String, String> emojiShortNameMap() {
    if (emojiShortNameMap_cache == null)
      emojiShortNameMap_cache = emojiShortNameMap_load();
    return emojiShortNameMap_cache;
  }

  static public NavigableMap<String, String> emojiShortNameMap_load() {
    NavigableMap<String, String> map = ciMap();
    for (Map m : rawEmojisList()) {
      String shortName = (String) (m.get("shortname"));
      String emoji = (String) (m.get("emoji"));
      if (startsWith(shortName, ":"))
        map.put(shortName, emoji);
    }
    return map;
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public String squareBracket(String s) {
    return "[" + s + "]";
  }

  static public String hsansserif() {
    return hcss("body { font-family: Sans-Serif; }");
  }

  static public String hmobilefix() {
    return "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">";
  }

  static public String hmobilefix(String html) {
    return hAddToHead(html, hmobilefix());
  }

  static public String hresponstable() {
    return hcss_responstable();
  }

  static public String hcss_responstableForForms() {
    return hcss("\r\n    .responstableForForms {\r\n      margin: 1em 0;\r\n      /*width: 100%;*/\r\n      overflow: hidden;\r\n      background: #FFF;\r\n      color: #024457;\r\n      border-radius: 10px;\r\n      border: 1px solid #167F92;\r\n    }\r\n    \r\n    .responstableForForms tr {\r\n      border: 1px solid #D9E4E6;\r\n    }\r\n    .responstableForForms tr:nth-child(odd) {\r\n      background-color: #EAF3F3;\r\n    }\r\n    .responstableForForms th {\r\n      display: none;\r\n      border: 1px solid #FFF;\r\n      background-color: #167F92;\r\n      color: #FFF;\r\n      padding: 1em;\r\n    }\r\n    .responstableForForms th:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n    }\r\n    .responstableForForms th:nth-child(2) {\r\n      display: table-cell;\r\n    }\r\n    .responstableForForms th:nth-child(2) span {\r\n      display: none;\r\n    }\r\n    .responstableForForms th:nth-child(2):after {\r\n      content: attr(data-th);\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms th:nth-child(2) span {\r\n        display: block;\r\n      }\r\n      .responstableForForms th:nth-child(2):after {\r\n        display: none;\r\n      }\r\n    }\r\n    .responstableForForms td {\r\n      display: block;\r\n      word-wrap: break-word;\r\n      /*max-width: 7em;*/\r\n    }\r\n    .responstableForForms td:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n      border-right: 1px solid #D9E4E6;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms td {\r\n        border: 1px solid #D9E4E6;\r\n      }\r\n    }\r\n    .responstableForForms th, .responstableForForms td {\r\n      text-align: left;\r\n      margin: .5em 1em;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstableForForms th, .responstableForForms td {\r\n        display: table-cell;\r\n        padding: 1em;\r\n      }\r\n    }\r\n  ");
  }

  static public String hjs_selectize() {
    return "\r\n    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js\" integrity=\"sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=\" crossorigin=\"anonymous\"></script>\r\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css\" integrity=\"sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=\" crossorigin=\"anonymous\" />\r\n  ";
  }

  static public JavaScript hjs_copyToClipboard() {
    return new JavaScript("\r\n    const copyToClipboard = str => {\r\n      const el = document.createElement('textarea');\r\n      el.value = str;\r\n      el.setAttribute('readonly', '');\r\n      el.style.position = 'absolute';\r\n      el.style.left = '-9999px';\r\n      document.body.appendChild(el);\r\n      const selected =\r\n        document.getSelection().rangeCount > 0 ? document.getSelection().getRangeAt(0) : false;\r\n      el.select();\r\n      document.execCommand('copy');\r\n      document.body.removeChild(el);\r\n      if (selected) {\r\n        document.getSelection().removeAllRanges();\r\n        document.getSelection().addRange(selected);\r\n      }\r\n    };\r\n  ");
  }

  static public String hNotificationPopups() {
    return hStylesheetSnippet_maxCache("#1029723") + hjssnippet_maxCache("#1029726");
  }

  static public String hcss_linkColorInherit() {
    return hcss("a { color: inherit; }");
  }

  static public String joinWithVBar(Iterable<String> l) {
    return join(" | ", l);
  }

  static public String joinWithVBar(String... l) {
    return joinWithVBar(asList(l));
  }

  static public String joinNemptiesWithVBar(String... strings) {
    return joinNempties(" | ", strings);
  }

  static public String joinNemptiesWithVBar(Collection<String> strings) {
    return joinNempties(" | ", strings);
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public long toLong(Object o) {
    if (o instanceof Number)
      return ((Number) o).longValue();
    if (o instanceof String)
      return parseLong((String) o);
    return 0;
  }

  static public String targetBlank(String link, Object contents, Object... params) {
    return hrefBlank(link, contents, params);
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static public String hjs_imgUploadBase64Encoder() {
    return hscript("\r\n    var imgConverted = false;\r\n    \r\n    function submitWithImageConversion(form) {\r\n      console.log(\"imgConverted: \" + imgConverted + \", form: \" + form);\r\n      if (imgConverted) return true;\r\n      imgConverted = true;\r\n      var file = $('#imgUploader')[0].files[0];\r\n      if (file == null) return true;\r\n      var reader = new FileReader();\r\n\r\n      // delay form submit until reader is done\r\n      reader.onloadend = function () {\r\n        var b64 = reader.result.replace(/^data:.+;base64,/, '');\r\n        $(\"#f_img_base64\").val(b64);\r\n        console.log(\"Got base64 data: \" + b64.length);\r\n        setTimeout(function() {\r\n          $(form).submit();\r\n        }, 1000);\r\n      };\r\n\r\n      reader.readAsDataURL(file);\r\n      return false;\r\n    }\r\n  ");
  }

  static public String himageupload(Object... params) {
    return hfileupload(paramsPlus(params, "accept", "image/png,image/jpeg,image/gif"));
  }

  static public String hhiddenWithIDAndName(String idAndName) {
    return hhiddenWithIDAndName(idAndName, null);
  }

  static public String hhiddenWithIDAndName(String idAndName, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", idAndName, "name", idAndName, "value", value));
  }

  static public Object[] litparams(Object... l) {
    int n = 0, n1 = l(l);
    for (int i = 0; i < n1; i += 2) if (l[i] != null && l[i + 1] != null)
      ++n;
    if (n == 0)
      return null;
    Object[] params = new Object[n * 2];
    int j = 0;
    for (int i = 0; i < n1; i += 2) {
      Object key = l[i], value = l[i + 1];
      if (key != null && value != null) {
        params[j++] = key;
        params[j++] = value;
      }
    }
    return params;
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public List<Concept> allBackRefs(Concept c) {
    IdentityHashMap<Concept, Boolean> l = new IdentityHashMap();
    if (c != null && c.backRefs != null)
      for (Concept.Ref r : c.backRefs) l.put(r.concept(), true);
    return keysList(l);
  }

  static public <A extends Concept> List<A> sortedByConceptID(Collection<A> c) {
    return sortedByCalculatedField("conceptID", c);
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public String span_title(String title, Object contents) {
    return spanTitle(title, contents);
  }

  static public String joinMap(Object f, Iterable l) {
    return join(map(f, l));
  }

  static public String joinMap(Iterable l, Object f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(Iterable<A> l, IF1<A, String> f) {
    return joinMap(f, l);
  }

  static public <A> String joinMap(IF1<A, String> f, Iterable<A> l) {
    return join(map(f, l));
  }

  static public <A, B> String joinMap(String separator, Map<A, B> map, IF2<A, B, String> f) {
    return join(separator, map(map, f));
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    List l = new ArrayList();
    Iterator<A> it = i.iterator();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public String htmlEncode_nlToBr_withIndents(String s) {
    return nlToBr_withIndents(htmlEncode(s));
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
    return concepts.countConcepts(c, params);
  }

  static public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    return db_mainConcepts().countConcepts(c, params);
  }

  static public int countConcepts() {
    return db_mainConcepts().countConcepts();
  }

  static public int countConcepts(String className) {
    return db_mainConcepts().countConcepts(className);
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, String className) {
    return concepts.countConcepts(className);
  }

  static public int countConcepts(Concepts concepts) {
    return concepts.countConcepts();
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public String shortName(Object o) {
    return shortClassName(o);
  }

  static public <A> A replaceIfEquals(A a, A b, A c) {
    return replaceIfEqual(a, b, c);
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public Type type_LS() {
    return new ParameterizedTypeImpl(null, List.class, String.class);
  }

  static public List<String> tlft(String s) {
    return toLinesFullTrim(s);
  }

  static public List<String> tlft(File f) {
    return toLinesFullTrim(f);
  }

  static public String b(Object contents, Object... params) {
    return tag("b", contents, params);
  }

  static public String lines_rtrim(Collection lines) {
    return rtrim_fromLines(lines);
  }

  static public String ol_htmlEncode(String... list) {
    return ol_htmlEncode(asList(list));
  }

  static public String ol_htmlEncode(List<String> list, Object... params) {
    return ol(lmap(__47 -> htmlEncode(__47), list), params);
  }

  static public <A, B> void replaceMap(Map<A, B> dest, Map<A, B> src) {
    if (dest == src)
      return;
    dest.clear();
    dest.putAll(src);
  }

  static public String formatLocalDateWithMinutes(long time) {
    return localDateWithMinutes(time);
  }

  static public String formatLocalDateWithMinutes() {
    return localDateWithMinutes();
  }

  static public <A> String pnlToStringWithEmptyLines_rtrim(Iterable<A> l) {
    return rtrim(pnlToStringWithEmptyLines(l));
  }

  static public String ol(String... list) {
    return ol(asList(list));
  }

  static public String ol(List<String> list, Object... params) {
    StringBuilder buf = new StringBuilder();
    int i = indexOf(params, null);
    if (i == -1)
      i = l(params);
    for (String s : withoutNulls(list)) buf.append(tag("li", s, subArray(params, i + 1))).append("\n");
    return containerTag("ol", buf, subArray(params, 0, i)) + "\n";
  }

  static public String htmlEncode2_nlToBr(String s) {
    return htmlEncode_nlToBr(s);
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public String himg(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", isSnippetID(src) ? snippetImageLink(src) : src));
  }

  static public String himgsnippet(String imageID, Object... params) {
    return hsnippetimg(imageID, params);
  }

  static public String toK_str(long l) {
    return str_toK(l);
  }

  static public long fileSize(String path) {
    return getFileSize(path);
  }

  static public long fileSize(File f) {
    return getFileSize(f);
  }

  static public void saveFileVerbose(File f, byte[] data) {
    saveBinaryFileVerbose(f, data);
  }

  static public byte[] base64decode(String s) {
    byte[] alphaToInt = base64decode_base64toint;
    int sLen = s.length();
    int numGroups = sLen / 4;
    if (4 * numGroups != sLen)
      throw new IllegalArgumentException("String length must be a multiple of four.");
    int missingBytesInLastGroup = 0;
    int numFullGroups = numGroups;
    if (sLen != 0) {
      if (s.charAt(sLen - 1) == '=') {
        missingBytesInLastGroup++;
        numFullGroups--;
      }
      if (s.charAt(sLen - 2) == '=')
        missingBytesInLastGroup++;
    }
    byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
    int inCursor = 0, outCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch3 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      result[outCursor++] = (byte) ((ch2 << 6) | ch3);
    }
    if (missingBytesInLastGroup != 0) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      if (missingBytesInLastGroup == 1) {
        int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
        result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      }
    }
    return result;
  }

  static public int base64decode_base64toint(char c, byte[] alphaToInt) {
    int result = alphaToInt[c];
    if (result < 0)
      throw new IllegalArgumentException("Illegal character " + c);
    return result;
  }

  static final public byte[] base64decode_base64toint = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 };

  static public <A extends Concept> A uniqCI(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqCI(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhereCI(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String beforeColonOrAll(String s) {
    return takeFirst(smartIndexOf(s, ':'), s);
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return db_mainConcepts().list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public double elapsedSeconds_timestamp(long time) {
    return toSeconds(now() - time);
  }

  static public String div_floatRight(Object contents, Object... params) {
    return div(contents, params_stylePlus("float: right", params));
  }

  static public String hbutton(String text, Object... params) {
    return hfulltag("button", text, params);
  }

  static public String h2(String s, Object... params) {
    return tag("h2", s, params);
  }

  static public String h3(String s, Object... params) {
    return tag("h3", s, params) + "\n";
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
    return lambdaMap(f, l);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
    return lambdaMap(f, l);
  }

  static public String htmlEncode2_gen(Object o) {
    return htmlEncode2(str(o));
  }

  static public <A> List<A> reversed(Collection<A> l) {
    return reversedList(l);
  }

  static public <A> List<A> reversed(A[] l) {
    return reversedList(asList(l));
  }

  static public String reversed(String s) {
    return reversedString(s);
  }

  static public <A extends Concept> A conceptWhereCI(Class<A> c, Object... params) {
    return findConceptWhereCI(c, params);
  }

  static public Concept conceptWhereCI(String c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A conceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public Concept conceptWhereCI(Concepts concepts, String c, Object... params) {
    return findConceptWhereCI(concepts, c, params);
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public int countPred(Iterable c, Object pred) {
    return nfilter(c, pred);
  }

  static public int countPred(Object pred, Iterable c) {
    return nfilter(pred, c);
  }

  static public <A> int countPred(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(c, pred);
  }

  static public String nConversations(long n) {
    return n2(n, "conversation");
  }

  static public String nConversations(Collection l) {
    return nConversations(l(l));
  }

  static public String nConversations(Map map) {
    return nConversations(l(map));
  }

  static public Object realMC() {
    return getThreadLocal(realMC_tl());
  }

  static public File getSecretProgramDir() {
    return getSecretProgramDir(actualProgramID());
  }

  static public File getSecretProgramDir(String snippetID) {
    if (empty(snippetID))
      return javaxSecretDir();
    return newFile(javaxSecretDir(), formatSnippetID(snippetID));
  }

  static public String loadSecretTextFileOrCreateWithRandomID(String name) {
    String id = trim(loadSecretTextFile(name));
    if (empty(id))
      saveSecretTextFile(name, id = aGlobalID());
    return id;
  }

  static public String loadSecretTextFileOrCreateWithRandomID(File f) {
    String id = trim(loadTextFile(f));
    if (empty(id))
      saveTextFile(f, id = aGlobalID());
    return id;
  }

  static public String hfullcenter(Object contents, Object... __) {
    return tag("table", tr(td(contents, "align", "center")), paramsPlus(__, "width", "100%", "height", "100%"));
  }

  static public String h3_htmlEncode(Object contents, Object... params) {
    return h3(htmlEncode2(str(contents)), params);
  }

  static public String hpostform(Object contents, Object... params) {
    return tag("form", contents, concatArrays(new Object[] { "method", "POST" }, params));
  }

  static public String hhidden(String name, Object value, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "hidden", "name", name, "value", value }, params));
  }

  static public String hpassword(String name, Object... params) {
    return hpasswordfield(name, params);
  }

  static public String hpassword(String name) {
    return hpasswordfield(name);
  }

  static public String hsubmit(String text, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "submit", "value", text }, params));
  }

  static public String hsubmit() {
    return hsubmit("Submit");
  }

  static public ContentsIndexedList<String> ciContentsIndexedList() {
    return new ContentsIndexedList<String>(ciMap());
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public <A, B> Map<A, B> mapPlus_inFront(Map<A, B> m, Object... data) {
    LinkedHashMap m2 = new LinkedHashMap();
    litmap_impl(m2, data);
    putAll(m2, m);
    return m2;
  }

  static public long conceptID(Concept c) {
    return c == null ? 0 : c.id;
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A, B> Set<A> keys(MultiSetMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A> int addAndReturnIndex(List<A> l, A a) {
    if (l == null)
      return -1;
    int idx = l.size();
    l.add(a);
    return idx;
  }

  static public <A> void listSet(List<A> l, int i, A a, A emptyElement) {
    if (i < 0)
      return;
    while (i >= l(l)) l.add(emptyElement);
    l.set(i, a);
  }

  static public <A> void listSet(List<A> l, int i, A a) {
    listSet(l, i, a, null);
  }

  static public String formatCSVFileForExcel2(List<List> rows) {
    String sep = "|";
    return windowsLineBreaks("sep=" + sep + "\n" + mapToLines_rtrim(rows, row -> join(sep, map(row, col -> replace(newLinesToSpaces(str(col)), sep, " ")))));
  }

  static public <A> List<A> itemPlusList(A a, Collection<A> l) {
    return concatLists(ll(a), l);
  }

  static public <A> Set<A> putSetElementsFirst(Collection<A> cl, Collection<A> elements) {
    Set<A> inputSet = asSet(cl);
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A a : unnull(elements)) if (contains(inputSet, a))
      set.add(a);
    addAll(set, cl);
    return set;
  }

  static public <A> Set<A> putSetElementsFirst(Collection<A> cl, A... elements) {
    return putSetElementsFirst(cl, asList(elements));
  }

  static public Cache<MultiMap<String, CountryDialCode>> countryDialCodesMultiMap_cache = new Cache<>(() -> countryDialCodesMultiMap_load());

  static public MultiMap<String, CountryDialCode> countryDialCodesMultiMap() {
    return countryDialCodesMultiMap_cache.get();
  }

  static public MultiMap<String, CountryDialCode> countryDialCodesMultiMap_load() {
    return treeMultiMapIndexByField("dialCode", countryDialCodes());
  }

  static public List<String> splitAtComma_trim(String s) {
    return nempties(trimAll(splitAtComma(s)));
  }

  static public String dialCodeStringForCountryCode(String countryCode) {
    CountryDialCode cdc = countryDialCodeByCountryCode(countryCode);
    return cdc == null ? null : cdc.dialCode;
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public List collectSorted(Iterable c, String field) {
    return sorted(collect(c, field));
  }

  static public List collectSorted(String field, Iterable c) {
    return collectSorted(c, field);
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public <A> List<A> itemPlus(A a, Collection<A> l) {
    return itemPlusList(a, l);
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public Object rcall(String method, Object o, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public String dropPrefix_trim(String prefix, String s) {
    return dropPrefixTrim(prefix, s);
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public Object serveJSON(Object data) {
    return serveJSON_shallowLineBreaks(data);
  }

  static public String formatLocalDateWithSeconds(long time) {
    return localDateWithSeconds(time);
  }

  static public String formatLocalDateWithSeconds() {
    return localDateWithSeconds();
  }

  static public String imageSnippetURLOrEmptyGIF(String snippetID) {
    return empty(snippetID) ? smallestTransparentGIFDataURI() : snippetImageURL(snippetID);
  }

  static public String appendQueryToURL(String url, Map params) {
    return url == null ? null : url + (url.contains("?") ? "&" : "?") + makePostData(params);
  }

  static public String appendQueryToURL(String url, Object... data) {
    return appendQueryToURL(url, litmap(data));
  }

  static public String makePostData(Map<Object, Object> map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : map.entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String aRandomID() {
    return aGlobalID();
  }

  static public String aRandomID(Random random) {
    return aGlobalID(random);
  }

  static public Object[] onlyNonNullParams(Object... params) {
    List out = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) if (params[i] != null && params[i + 1] != null) {
      out.add(params[i]);
      out.add(params[i + 1]);
    }
    return toObjectArray(out);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s) {
    return mmo2_match(pattern, s, false, false);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s, boolean startOfLine, boolean endOfLine) {
    if (pattern == null)
      return false;
    String s2 = trim(s);
    if (pattern instanceof MMOPattern.StartOfLine)
      return mmo2_match(((MMOPattern.StartOfLine) pattern).p, s2, true, endOfLine);
    if (pattern instanceof MMOPattern.EndOfLine)
      return mmo2_match(((MMOPattern.EndOfLine) pattern).p, s2, startOfLine, true);
    if (pattern instanceof MMOPattern.Phrase) {
      String p = ((MMOPattern.Phrase) pattern).phrase;
      if (((MMOPattern.Phrase) pattern).quoted)
        return cicWithSmartWordBoundary(s2, p);
      if (startsWith(p, "#"))
        return eqic(p, s2);
      return match3_startOrEndOfLine(p, s2, startOfLine, endOfLine);
    }
    if (pattern instanceof MMOPattern.And)
      return all(((MMOPattern.And) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Or)
      return any(((MMOPattern.Or) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Not)
      return !mmo2_match(((MMOPattern.Not) pattern).p, s2, startOfLine, endOfLine);
    throw fail("what. " + pattern);
  }

  static public boolean mmo2_match(String pattern, String s) {
    return mmo2_match(mmo2_parsePattern(pattern), s);
  }

  static public <A extends Concept> A lowestConceptByField(Class<A> c, String field) {
    return lowestConceptByField(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> A lowestConceptByField(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc) {
      Map.Entry e = ((NavigableMap) ((ConceptFieldIndexDesc) index).valueToObject.data).lastEntry();
      return e == null ? null : (A) first((Collection) e.getValue());
    }
    return lowestByField(field, concepts.list(c));
  }

  static public java.util.Timer doAfter(long delay, Object r) {
    return doLater(delay, r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Object r) {
    return doLater(delaySeconds, r);
  }

  static volatile public PersistableThrowable _handleException_lastException;

  static public List _handleException_onException = synchroList(ll("printStackTrace2"));

  static public void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
      return;
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      printStackTrace2(e3);
    }
  }

  static public void registerConcept(Concept c) {
    db_mainConcepts().register(c);
  }

  static public void registerConcept(Concepts cc, Concept c) {
    cc.register(c);
  }

  static public void dbIndexing(Object... params) {
    db();
    for (int i = 0; i < l(params); i += 2) indexConceptField((Class) params[i], (String) params[i + 1]);
  }

  static public void indexConceptFieldDesc(Class<? extends Concept> c, String field) {
    indexConceptFieldDesc(db_mainConcepts(), c, field);
  }

  static public void indexConceptFieldDesc(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndexDesc(concepts, c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
    return indexConceptFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
    ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
    return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
  }

  static public void indexConceptField(Class<? extends Concept> c, String field) {
    indexConceptField(db_mainConcepts(), c, field);
  }

  static public void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndex(concepts, c, field);
  }

  static public void indexSingletonConcept(Concepts cc, Class<? extends Concept> c) {
    indexConceptField(cc, c, "_dummy");
  }

  static public void indexSingletonConcept(Class<? extends Concept> c) {
    indexSingletonConcept(db_mainConcepts(), c);
  }

  static public Object subBot_noCacheHeaders(Object r) {
    call(r, "addHeader", "Cache-Control", "no-cache, must-revalidate, max-age=0");
    return r;
  }

  static public Object subBot_serveHTML(Object html) {
    return subBot_serveWithContentType(str(html), "text/html");
  }

  static public Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMC((String) f, args);
      return x30_util.callF(f, args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callMC(String method, Object... args) {
    return call(mc(), method, args);
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public String nlToBr(String s) {
    return s.replace("\n", "<br>\n");
  }

  static public String html_emojisToUnicode(String s) {
    return join(mapNonCodeTokens(__48 -> emojisToUnicode(__48), htmlTok(s)));
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last(((List) l));
    if (l instanceof SortedSet)
      return (A) last(((SortedSet) l));
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public String fullRawLink(String pageName) {
    return (subBot_isHttps() ? "https" : "http") + "://" + domain() + rawLink(pageName);
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public String unicode_undoArrow() {
    return unicodeFromCodePoint(0x21B6);
  }

  static public String unicode_crossProduct() {
    return unicodeFromCodePoint(0x2A2F);
  }

  static public TreeSet<String> asCISet(Iterable<String> c) {
    return toCaseInsensitiveSet(c);
  }

  static public TreeSet<String> asCISet(String... x) {
    return toCaseInsensitiveSet(x);
  }

  static public String joinWithBR(Iterable<String> l) {
    return join("<br>", l);
  }

  static public String joinWithBR(String... l) {
    return joinWithBR(asList(l));
  }

  static public String hcheckbox(String name, boolean checked, Object... params) {
    return tag("input", "", arrayPlus(params, "type", "checkbox", "name", name, checked ? "checked" : null, "1"));
  }

  static public String hcheckbox(String name) {
    return hcheckbox(name, false);
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public String hbuttonOnClick_returnFalse(String text, String onClick, Object... params) {
    return hfulltag("button", text, paramsPlus(params, "onclick", addSuffix(trim(onClick), ";") + " return false;"));
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public void printVars_str(Object... params) {
    String s = "";
    if (odd(l(params))) {
      s = str(first(params));
      if (endsWithLetterOrDigit(s))
        s += ": ";
      params = dropFirst(params);
    }
    print(s + renderVars_str(params));
  }

  static public List<String> text_multipleChoiceSplit(String input, String multipleChoiceSeparator) {
    return trimAll(splitAt(input, dropSpaces(multipleChoiceSeparator)));
  }

  static public String span(Object contents, Object... params) {
    return tag("span", contents, params);
  }

  static public String timeInTimeZoneWithOptionalDate_24(String timezone, long time) {
    return timeInTimeZoneWithOptionalDate_24(timeZone(timezone), time);
  }

  static public String timeInTimeZoneWithOptionalDate_24(TimeZone timezone, long time) {
    SimpleDateFormat format = simpleDateFormat("yyyy/MM/dd", timezone);
    String date = format.format(time);
    boolean needDate = neq(date, format.format(now()));
    return (needDate ? date + " " : "") + timeInTimeZone(timezone, time);
  }

  static public String htmlencode(Object o) {
    return htmlencode(str(o));
  }

  static public String htmlencode(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String ul(String... list) {
    return ul(asList(list));
  }

  static public String ul(List<String> list, Object... params) {
    StringBuilder buf = new StringBuilder();
    int i = indexOf(params, null);
    if (i == -1)
      i = l(params);
    for (String s : withoutNulls(list)) buf.append(tag("li", s, subArray(params, i + 1))).append("\n");
    return containerTag("ul", buf, subArray(params, 0, i)) + "\n";
  }

  static public String hhead_title(String title) {
    return hhead(htitle(title));
  }

  static public String jsBackLink() {
    return "javascript:history.go(-1)";
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public <A> boolean any(Object pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (isTrue(callF(pred, a)))
        return true;
    return false;
  }

  static public <A> boolean any(IF1<A, Boolean> pred, Iterable<A> l) {
    return any((Object) pred, l);
  }

  static public <A> boolean any(Iterable<A> l, IF1<A, Boolean> pred) {
    return any(pred, l);
  }

  static public String ipToCountry2020_safe(String ip) {
    try {
      return or2(ipToCountry2020(ip), "?");
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return "?";
  }

  static public String replaceSquareBracketVars(String s, Object... params) {
    if (empty(params))
      return s;
    Map<String, Object> vars = mapKeys(__49 -> deSquareBracket(__49), (Map<String, Object>) litcimap(params));
    return regexpReplaceIC(s, "\\[(.+?)\\]", matcher -> {
      String var = matcher.group(1);
      Object val = vars.get(var);
      return val == null ? matcher.group() : str(val);
    });
  }

  static public List<String> trimAll(Collection<String> l) {
    List<String> l2 = new ArrayList();
    if (l != null)
      for (String s : l) l2.add(trim(s));
    return l2;
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public String dropSpaces(String s) {
    return unnull(s).replace(" ", "");
  }

  static public <A> A lastThat(List<A> l, Object pred) {
    for (int i = l(l) - 1; i >= 0; i--) {
      A a = l.get(i);
      if (checkCondition(pred, a))
        return a;
    }
    return null;
  }

  static public <A> A lastThat(Object pred, List<A> l) {
    return lastThat(l, pred);
  }

  static public <A> A lastThat(IF1<A, Boolean> pred, List<A> l) {
    return lastThat((Object) pred, l);
  }

  static public <A> A lastThat(List<A> l, IF1<A, Boolean> pred) {
    return lastThat(pred, l);
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public String quoteOr(String s, String whenEmpty) {
    return empty(s) ? whenEmpty : quote(s);
  }

  static public String spaceRoundBracketed(String s) {
    return spacePlusRoundBracketedIfNempty(s);
  }

  static public String nSteps(long n) {
    return n2(n, "step");
  }

  static public String nSteps(Collection l) {
    return nSteps(l(l));
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public String spacePlusRoundBracketedIfNempty(String s) {
    return nempty(s) ? " " + roundBracket(s) : "";
  }

  static public String newLinesToSpaces2(String s) {
    return newLinesToSpaces_trim(s);
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public String himgsrc(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", src));
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  static public boolean deleteFile(File file) {
    return file != null && file.delete();
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String orEmptyQuotes(String s) {
    return or2(s, "\"\"");
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public <A, B> B syncPut(Map<A, B> map, A key, B value) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.put(key, value);
    }
  }

  static public boolean isValidEmailAddress_simple(String s) {
    return l(s) <= 254 && regexpMatches("^\\S+@\\S+(\\.[^\\.\\s]+)+$", s);
  }

  static public boolean isValidInternationalPhoneNumber(String s) {
    InternationalPhoneValidator v = new InternationalPhoneValidator(s);
    v.run();
    if (v.error != null)
      print(v.error);
    return v.valid;
  }

  static public int indexOfIC(List<String> a, String b) {
    return indexOfIgnoreCase(a, b);
  }

  static public int indexOfIC(List<String> a, String b, int i) {
    return indexOfIgnoreCase(a, b, i);
  }

  static public int indexOfIC(String a, String b) {
    return indexOfIgnoreCase(a, b);
  }

  static public int indexOfIC(String a, String b, int i) {
    return indexOfIgnoreCase(a, b, i);
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public Concept cnew(String name, Object... values) {
    return cnew(db_mainConcepts(), name, values);
  }

  static public Concept cnew(Concepts concepts, String name, Object... values) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    Concept c;
    try {
      c = cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  static public <A extends Concept> A cnew(Class<A> cc, Object... values) {
    return cnew(db_mainConcepts(), cc, values);
  }

  static public <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
    concepts_unlisted.set(true);
    A c;
    try {
      c = nuObject(cc);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public <A, B> Map<A, B> filterKeys(Map<A, B> map, Object f) {
    return filterMapByFunctionOnKey(map, f);
  }

  static public <A, B> Map<A, B> filterKeys(Object f, Map<A, B> map) {
    return filterMapByFunctionOnKey(f, map);
  }

  static public <A, B> Map<A, B> filterKeys(IF1<A, Boolean> f, Map<A, B> map) {
    return filterMapByFunctionOnKey((Object) f, map);
  }

  static public IF1<String, Boolean> swic$(String suffix) {
    return s -> swic(s, suffix);
  }

  static public <A> void syncRemoveAllExceptLast(List<A> l) {
    if (l == null)
      return;
    synchronized (collectionMutex(l)) {
      removeSubList(l, 0, l(l) - 1);
    }
  }

  static public MMOPattern mmo2_parsePattern(String s) {
    s = trim(tok_deRoundBracket(trim(s)));
    List<String> tok = javaTokWithBrackets(s);
    List<String> l = tok_splitAtComma(tok);
    if (l(l) > 1)
      return new MMOPattern.Or(lambdaMap(__50 -> mmo2_parsePattern(__50), l));
    l = tok_splitAtPlus(tok);
    if (l(l) > 1)
      return new MMOPattern.And(lambdaMap(__51 -> mmo2_parsePattern(__51), l));
    if (startsWith(s, "!"))
      return new MMOPattern.Not(mmo2_parsePattern(dropFirst(s)));
    if (startsWith(s, "^"))
      return new MMOPattern.StartOfLine(mmo2_parsePattern(dropFirst(s)));
    if (endsWith(s, "$"))
      return new MMOPattern.EndOfLine(mmo2_parsePattern(dropLast(s)));
    l = tok_splitAtAsterisk(tok);
    if (l(l) == 2)
      return new MMOPattern.Weighted(parseDouble(second(l)), mmo2_parsePattern(first(l)));
    return new MMOPattern.Phrase(unquote(s), isQuoted(s));
  }

  static public TreeMap litcimap(Object... x) {
    return litCIMap(x);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public int syncL(Collection l) {
    if (l == null)
      return 0;
    synchronized (l) {
      return l.size();
    }
  }

  static public <A> List<A> syncL() {
    return syncList();
  }

  static public <A> int syncLengthLevel2(Collection<? extends Collection> l) {
    int sum = 0;
    for (Collection c : cloneList(l)) sum += syncL(c);
    return sum;
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public <A> void syncClear(Collection<A> c) {
    if (c != null)
      synchronized (collectionMutex(c)) {
        c.clear();
      }
  }

  static public void syncClear(Map map) {
    if (map != null)
      synchronized (collectionMutex(map)) {
        map.clear();
      }
  }

  static public <A> A syncPopLast(List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return popLast(l);
    }
  }

  static public <A> List<A> syncPopLast(int n, List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return popLast(n, l);
    }
  }

  static public <A> A syncLast(List<A> l) {
    if (l == null)
      return null;
    synchronized (l) {
      return last(l);
    }
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public String h1(String s, Object... params) {
    return tag("h1", s, params);
  }

  static public String ahref_possiblyTargetBlank(String link, Object contents, boolean targetBlank, Object... params) {
    return ahref(link, contents, targetBlank ? paramsPlus(params, "target", "_blank") : params);
  }

  static public <A> A setAll(A o, Map<String, Object> fields) {
    if (fields == null)
      return o;
    for (String field : keys(fields)) set(o, field, fields.get(field));
    return o;
  }

  static public <A> A setAll(A o, Object... values) {
    failIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      set(o, field, value);
    }
    return o;
  }

  static public Object[] filterParams(Object[] params, Object... keys) {
    Set set = asSet(keys);
    List l = new ArrayList();
    for (int i = 0; i < l(params); i += 2) if (contains(set, params[i])) {
      l.add(params[i]);
      l.add(params[i + 1]);
    }
    return asObjectArray(l);
  }

  static public void addIfNempty(Collection<String> l, String s) {
    if (nempty(s))
      l.add(s);
  }

  static public void addIfNempty(Collection l, Map m) {
    if (nempty(m))
      l.add(m);
  }

  static public void addIfNempty(Collection l, Collection c) {
    if (nempty(c))
      l.add(c);
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public String getClientIPFromHeaders(Map<String, String> headers) {
    if (headers == null)
      return null;
    String remoteAddr = (String) (headers.get("remote-addr"));
    String client = (String) (headers.get("x-forwarded-for"));
    if (nempty(client))
      remoteAddr += "," + client;
    return remoteAddr;
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public String plural(String s) {
    return getPlural(s);
  }

  static public <A> List<A> subListOrFull(List<A> l, IntRange r) {
    return r == null ? l : subList(l, r.start, r.end);
  }

  static public RuntimeException unimplemented() {
    throw fail("TODO");
  }

  static public RuntimeException unimplemented(String msg) {
    throw fail("TODO: " + msg);
  }

  static public String spanTitle(String title, Object contents) {
    return empty(title) ? str(contents) : span(contents, "title", title);
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String humanizeLabel(String s) {
    return humanizeFormLabel(s);
  }

  static public String humanizeShortName(Object o) {
    return humanizeLabel(shortName(o));
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public List<String> getFieldOrder(Object o) {
    return getFieldOrder(_getClass(o));
  }

  static public List<String> getFieldOrder(Class c) {
    if (c == null)
      return null;
    return splitAtSpace(toStringOpt(getOpt(c, "_fieldOrder")));
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public Map putKeysFirst(Map map, Object... keys) {
    Map m2 = litorderedmap();
    Map remaining = cloneMap(map);
    for (Object key : keys) {
      if (remaining.containsKey(key)) {
        m2.put(key, remaining.get(key));
        remaining.remove(key);
      }
    }
    m2.putAll(remaining);
    return m2;
  }

  static public Map putKeysFirst(List keys, Map map) {
    return putKeysFirst(map, toObjectArray(keys));
  }

  static public Map conceptToMap_gen_withNullValues(Object c) {
    Map map = litorderedmap("id", str(getLong(c, "id")));
    for (String field : conceptFields_gen(c)) map.put(field, getOpt(c, field));
    return map;
  }

  static public List<Field> nonStaticNonTransientFieldObjectsOfType(Class type, Object o) {
    return filter(nonStaticNonTransientFieldObjects(o), f -> eq(f.getType(), type));
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public long parseFirstLong(String s) {
    return parseLong(jextract("<int>", s));
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public <A, B> List<B> valuesAsList(Map<A, B> map) {
    return valuesList(map);
  }

  static public String optCastString(Object o) {
    return optCastToString(o);
  }

  static public boolean isSingleLine(String s) {
    return !containsNewLine(s);
  }

  static public boolean isUntrimmed(String s) {
    return neq(s, trim(s));
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public int cSmartSet(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_cSmartSetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cSmartSet_withConverter(ValueConverterForField converter, Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (cSmartSetField_withConverter(c, (String) values[i], values[i + 1], converter))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void deleteConcept(long id) {
    db_mainConcepts().deleteConcept(id);
  }

  static public void deleteConcept(Concepts concepts, long id) {
    concepts.deleteConcept(id);
  }

  static public void deleteConcept(Concept c) {
    if (c != null)
      c.delete();
  }

  static public void deleteConcept(Concept.Ref ref) {
    if (ref != null)
      deleteConcept(ref.get());
  }

  static public boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public <A, B> Map<A, B> orderedMapPutOrCreate(Map<A, B> map, A key, B value) {
    if (key != null && value != null) {
      if (map == null)
        map = new LinkedHashMap();
      map.put(key, value);
    }
    return map;
  }

  static public Class getTypeArgumentAsClass(Type type) {
    if (type instanceof ParameterizedType)
      return typeToClass(first(((ParameterizedType) type).getActualTypeArguments()));
    return null;
  }

  static public Type genericFieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getGenericType();
  }

  static public Object deref(Object o) {
    if (o instanceof Derefable)
      o = ((Derefable) o).get();
    return o;
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public String firstWhereFirstLongIs(Collection<String> l, long i) {
    return firstThat(l, s -> parseFirstLong(s) == i);
  }

  static public boolean hasBackRefs(Concept c) {
    return c != null && syncNempty(c.backRefs);
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public Object firstElementNotSubclassing(Iterable l, Class c) {
    return firstThat(l, o -> !isInstanceOf(o, c));
  }

  static public String pUnlessEmpty(String s) {
    return empty(s) ? "" : p(s);
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public <T> Map<String, T> subMapStartingWith_dropPrefix(Map<String, T> map, String prefix) {
    if (map == null)
      return null;
    Map<String, T> map2 = new HashMap();
    for (String key : keys(map)) {
      T value = map.get(key);
      if (startsWith(key, prefix))
        map2.put(substring(key, l(prefix)), value);
    }
    return map2;
  }

  static public List<String> keysDeprefixNemptyValue(Map<String, String> map, String prefix) {
    List<String> l = new ArrayList();
    for (String s : keys(map)) if (startsWith(s, prefix) && nempty(map.get(s)))
      l.add(s.substring(l(prefix)));
    return l;
  }

  static public String hhiddenStuff(String secretHTML) {
    String id = aGlobalID();
    String js = "document.getElementById(" + jsQuote(id) + ").innerHTML = " + jsQuote(secretHTML) + "; return false;";
    return span(ahref("#", "show", "onclick", js), "id", id);
  }

  static public String yesNo_short(boolean b) {
    return b ? "yes" : "no";
  }

  static public <B, C, A extends Map<B, C>> List<A> sortByTransformedMapKey_alphaNum(IF1<C, String> transform, Iterable<A> c, B key) {
    List<A> l = cloneList(c);
    sort(l, (a, b) -> cmpAlphaNum(transform.get(mapGet(a, key)), transform.get(mapGet(b, key))));
    return l;
  }

  static public <A, B> Map<A, B> mapMinusKeys(Map<A, B> map, Collection<A> keys) {
    if (empty(keys) || empty(map))
      return map;
    keys = asSet(keys);
    Map<A, B> m2 = similarEmptyMap(map);
    for (A key : keys(map)) {
      B val = map.get(key);
      if (!keys.contains(key))
        m2.put(key, val);
    }
    return m2;
  }

  static public <A> Set<A> joinSets(Set<A>... l) {
    TreeSet set = new TreeSet();
    for (Set o : l) if (o != null)
      set.addAll(o);
    return set;
  }

  static public Map mapToMap(Object f, Iterable l) {
    Map map = new HashMap();
    for (Object o : unnull(l)) {
      Pair p = (Pair) (callF(f, o));
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> Map<B, C> mapToMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
    Map<B, C> map = new HashMap();
    for (A o : unnull(l)) {
      Pair<B, C> p = callF(f, o);
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> Map<B, C> mapToMap(Iterable<A> l, IF1<A, Pair<B, C>> f) {
    return mapToMap(f, l);
  }

  static public <A, B, C, D> Map<C, D> mapToMap(IF2<A, B, Pair<C, D>> f, Map<A, B> m) {
    return mapMapToMap(f, m);
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
    mapPut(map, key, value);
    return value;
  }

  static public <A, B> A firstKey(Map<A, B> map) {
    return first(keys(map));
  }

  static public <A, B> A firstKey(MultiSetMap<A, B> map) {
    return map == null ? null : firstKey(map.data);
  }

  static public String aname(String anchor, Object contents, Object... params) {
    return tag("a", contents, concatArrays(new Object[] { "name", anchor }, params));
  }

  static public <A, B> B firstValue(Map<A, B> map) {
    return first(values(map));
  }

  static public <A, B> B firstValue(MultiSetMap<A, B> map) {
    return map == null ? null : first(firstValue(map.data));
  }

  static public String unicode_downOrUpPointingTriangle(boolean down) {
    return down ? unicode_downPointingTriangle() : unicode_upPointingTriangle();
  }

  static public String htmlTable2_noHtmlEncode(Object data, Object... __) {
    return htmlTable2(data, paramsPlus(__, "htmlEncode", false));
  }

  static public Object[] paramsPlus(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) {
      Object key = a2[i];
      if (key != null)
        map.put(key, a2[i + 1]);
    }
    return mapToParams(map);
  }

  static public String hselect(String name, Map map, Object... params) {
    return hselect(map, paramsPlus_skipFirst(params, "name", name));
  }

  static public String hselect(Map map, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(map))
      for (Object key : keys(map)) {
        Object value = map.get(key);
        String k = str(key);
        buf.append(tag("option", htmlencode(str(or(value, ""))), "value", k, "selected", eq(selected, k) ? "selected" : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public String small(Object contents, Object... params) {
    return tag("small", contents, params);
  }

  static public String htableRaw_valignTop(List<? extends List> data, Object... params) {
    return htableRaw2(data, asList(params), ll(), ll("valign", "top"));
  }

  static public String htextarea(String text, Object... params) {
    params = html_massageAutofocusParam(params);
    return hopeningTag("textarea", params) + htmlencode2(text) + "</textarea>";
  }

  static public String htextfield(String name, Object... params) {
    return htextinput(name, params);
  }

  static public String htrickcheckboxWithText(String name, String text, boolean checked, Object... params) {
    String id = randomID();
    return hhidden(name, checked ? "1" : "0") + hcheckbox(null, checked, paramsPlus(params, "id", id, "onclick", "this.previousElementSibling.value=this.checked ? 1 : 0")) + " " + hlabelFor(id, htmlEncode2(text));
  }

  static public String htrickcheckboxWithText(String name, String text) {
    return htrickcheckboxWithText(name, text, false);
  }

  static public <A> A _get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public Object _get(Object o, String field) {
    return get(o, field);
  }

  static public Object _get(String field, Object o) {
    return get(o, field);
  }

  static public <A> A _get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public String tr(Object contents) {
    return tag("tr", contents);
  }

  static public String td(Object contents, Object... params) {
    return tag("td", contents, params);
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public <A, B> Map<A, B> mapWithoutKey(Map<A, B> map, A key) {
    if (map == null || !map.containsKey(key))
      return map;
    Map m = cloneMap(map);
    m.remove(key);
    return m;
  }

  static public String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  static public String makeFrame_defaultIcon;

  static public boolean makeFrame_hideConsole = false;

  static public ThreadLocal<VF1<JFrame>> makeFrame_post = new ThreadLocal();

  static public JFrame makeFrame() {
    return makeFrame((Component) null);
  }

  static public JFrame makeFrame(Object content) {
    return makeFrame(programTitle(), content);
  }

  static public JFrame makeFrame(String title) {
    return makeFrame(title, null);
  }

  static public JFrame makeFrame(String title, Object content) {
    return makeFrame(title, content, true);
  }

  static public JFrame makeFrame(final String title, final Object content, final boolean showIt) {
    final VF1<JFrame> post = optParam(makeFrame_post);
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          if (getFrame(content) != null)
            return getFrame(setFrameTitle((Component) content, title));
          final JFrame frame = new JFrame(title);
          if (makeFrame_defaultIcon != null)
            setFrameIconLater(frame, makeFrame_defaultIcon);
          _initFrame(frame);
          Component wrapped = wrap(content);
          if (wrapped != null)
            frame.getContentPane().add(wrapped);
          frame.setBounds(defaultNewFrameBounds());
          callF(post, frame);
          if (showIt)
            frame.setVisible(true);
          if (showIt && makeFrame_hideConsole) {
            hideConsole();
            makeFrame_hideConsole = false;
          }
          return frame;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ...";
      }
    });
  }

  static public String unicode_DEL() {
    return unicodeFromCodePoint(0x2421);
  }

  static public String ahrefWithConfirm(String msg, String url, Object contents, Object... params) {
    return ahref(url, contents, paramsPlus(params, "onClick", "return confirm(" + jsQuote(msg) + ");"));
  }

  static public String hselect_list(Collection<String> entries, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(entries))
      for (String k : entries) {
        String value = k;
        boolean isSelected = eq(selected, k);
        buf.append(hfulltag("option", htmlencode(str(or(value, ""))), "value", k, "selected", isSelected ? html_valueLessParam() : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public String hjs(String script) {
    return hjavascript(script);
  }

  static public String hoption(String text) {
    return tag("option", htmlEncode2(text));
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, l(l));
  }

  static public Class primitiveToBoxedTypeOpt(Class type) {
    return or(primitiveToBoxedType(type), type);
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt(((String) o));
    if (o instanceof Boolean)
      return boolToInt(((Boolean) o));
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public Object trimIfString(Object o) {
    return o instanceof String ? trim((String) o) : o;
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble(((String) o));
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public String ok(Object o) {
    return format("ok *", o);
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public Class _run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public <A> A getWeakRef(Reference<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      if (f != null)
        f.get(a);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public void cancelAndInterruptThread(Thread t) {
    if (t == null)
      return;
    cancelThread(t);
    t.interrupt();
  }

  static public Boolean not(Boolean b) {
    return b == null ? null : !b;
  }

  static public boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  static public int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  static public String h1_title(String s) {
    return htitle_h1(s);
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public String addAnchorToURL(String url, String anchor) {
    int i = smartIndexOf(url, '#');
    url = takeFirst(url, i);
    if (nempty(anchor))
      url += "#" + anchor;
    return url;
  }

  static public String htmlEncode_nlToBr(String s) {
    return nlToBr(htmlEncode2(s));
  }

  static public String pageNav2(String baseLink, int count, int value, int step, String nVar, Object... __) {
    List<String> l = new ArrayList();
    baseLink = unnull(baseLink) + (contains(baseLink, "?") ? "&" : "?") + urlencode(nVar) + "=";
    if (value > 0)
      l.add(ahref(baseLink + max(0, value - step), stringPar("leftArrow", __, htmlencode(unicode_leftPointingTriangle()))));
    for (int i = 0; i < count; i += step) {
      int n = i / step + 1;
      if (pageNav2_showPage(value, i, step, count))
        if (value == i)
          l.add(b(n));
        else
          l.add(ahref(baseLink + i, n));
    }
    if (value + step < count)
      l.add(ahref(baseLink + (value + step), stringPar("rightArrow", __, htmlencode(unicode_rightPointingTriangle()))));
    return p("Pages: " + lines(l));
  }

  static public boolean pageNav2_showPage(int actual, int i, int step, int count) {
    int diff = abs(actual - i) / step;
    return i == 0 || i >= (count - 1) / step * step || diff <= 10 || diff < 100 && ((i / step) % 10) == 9 || ((i / step) % 100) == 99;
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  static public void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  static public void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  static public F0<AutoCloseable> dm_rEnter(final DynModule mod) {
    return mod == null ? null : new F0<AutoCloseable>() {

      public AutoCloseable get() {
        try {
          return mod.enter();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mod.enter();";
      }
    };
  }

  static public Object dm_callModule(Object moduleOrID, String method, Object... args) {
    Object mod = dm_getModule(moduleOrID);
    if (mod == null)
      return null;
    AutoCloseable __1 = dm_enter(mod);
    try {
      return call(mod, method, args);
    } finally {
      _close(__1);
    }
  }

  static public boolean dm_isFirstSiblingModule(Object mod) {
    String libID = dm_moduleLibID(mod);
    if (libID == null)
      return false;
    List<String> siblings = dm_modulesWithLibID(libID);
    return eq(dm_moduleID(mod), lowestByAlphaNum(siblings));
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  static public class SmartTimerTask extends TimerTask implements IFieldsToList {

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return shortClassName(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { r, timer, delay, threadInfo };
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __1 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__1);
        }
      }
    }
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public void print_setPrefixForThread(final String prefix) {
    interceptPrintInThisThread(empty(prefix) ? null : new _PrintIndent(prefix));
  }

  static public Map<String, String> decodeHQuery(String query) {
    Map<String, String> map = new HashMap();
    for (String s : splitAtAmpersand(query)) {
      int i = s.indexOf('=');
      if (i >= 0)
        map.put(urldecode(s.substring(0, i)), urldecode(s.substring(i + 1)));
    }
    return map;
  }

  static public <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public int iceil(double d) {
    return (int) Math.ceil(d);
  }

  static public String dropSuffix(String suffix, String s) {
    return s.endsWith(suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public void deleteConcepts(List conceptsOrIDs) {
    db_mainConcepts().deleteConcepts(conceptsOrIDs);
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, Object... params) {
    return deleteConcepts(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, Object... params) {
    List<A> l = asList(findConceptsWhere(cc, c, params));
    deleteConcepts(l);
    return l;
  }

  static public Object callMainBot(String method, Object... args) {
    return call(mainBot(), method, args);
  }

  static public Object subBot_serveInputStream(InputStream in, String mimeType) {
    return call(mainBot(), "serveInputStream", in, mimeType);
  }

  static public int bufferedInputStream_bufferSize = 65536;

  static public BufferedInputStream bufferedInputStream(int bufSize, File f) {
    try {
      return bufferedInputStream(bufSize, newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedInputStream bufferedInputStream(File f) {
    try {
      return bufferedInputStream(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedInputStream bufferedInputStream(InputStream in) {
    return new BufferedInputStream(in, bufferedInputStream_bufferSize);
  }

  static public BufferedInputStream bufferedInputStream(int bufSize, InputStream in) {
    return new BufferedInputStream(in, bufSize);
  }

  static public File loadBinarySnippet(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public List mapMethod(Object[] l, final String methodName) {
    return map(l, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(Iterable c, final String methodName) {
    return map(c, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(String methodName, Iterable c) {
    return mapMethod(c, methodName);
  }

  static public List mapMethod(String methodName, Enumeration c) {
    return mapMethod(methodName, enumerationToIterator(c));
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Collection<A> c, final Object f) {
    return sortByCalculatedFieldDesc_inPlace(cloneList(c), f);
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Object f, Collection<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(b), f.get(a));
      }
    });
    return l;
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(IF1<A, B> f, Iterable<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public String webChatBotLogsHTML() {
    return withDBLock(new F0<String>() {

      public String get() {
        try {
          List<String> l = new ArrayList();
          for (Conversation conv : sortByCalculatedFieldDesc(list(Conversation.class), new F1<Conversation, Object>() {

            public Object get(Conversation c) {
              try {
                return empty(c.msgs) ? c.created : last(c.msgs).time;
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "empty(c.msgs) ? c.created : last(c.msgs).time";
            }
          })) {
            List<List<Msg>> dialogs = reversed(unnull(conv.oldDialogs));
            l.add(webChatBotLogsHTML_formatDialog(str(conv.id + "/" + (l(dialogs) + 1)), conv.msgs));
            int i = l(dialogs);
            for (List<Msg> msgs : dialogs) l.add(webChatBotLogsHTML_formatDialog(conv.id + "/" + (i--), msgs));
          }
          return h3_htitle("Chat Logs") + ul(l, null, "style", "margin-top: 1em");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new L<S> l;\r\n    for (Conversation conv : sortByCalculatedFieldDesc(list Conv...";
      }
    });
  }

  static public String webChatBotLogsHTML_formatDialog(String id, List<Msg> msgs) {
    long startTime = collectMinLong(msgs, "time");
    long endTime = collectMaxLong(msgs, "time");
    List<String> lc = new ArrayList();
    for (Msg m : msgs) if (m.fromUser)
      lc.add("U: " + i(htmlencode(m.text)));
    else
      lc.add("B: " + htmlencode(m.text));
    String time1 = formatDateAndTime(startTime);
    String time2 = formatDateAndTime(endTime);
    time2 = shortenEndTime(time2, time1);
    return id + " [" + htmlencode(time1) + " - " + htmlencode(time2) + "]" + ul(lc);
  }

  static public int parseIntOpt(String s) {
    return isInteger(s) ? parseInt(s) : 0;
  }

  static public String h3_htitle(String s) {
    return htitle(s) + h3(s);
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String spaces(int n) {
    return rep(' ', n);
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Integer> rgbToIntList(RGB rgb) {
    return rgb == null ? null : ll(rgb.redInt(), rgb.greenInt(), rgb.blueInt());
  }

  static public String javascriptQuote(String s) {
    return quote(s);
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '<')
        out.append("&lt;");
      else if (c == '>')
        out.append("&gt;");
      else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String stringIfTrue(boolean b, String s) {
    return b ? s : "";
  }

  static public ExpiringMap2<String, String> loadSnippet_simpleCache_map = new ExpiringMap2(10000);

  static public Lock loadSnippet_simpleCache_lock = lock();

  static public int loadSnippet_simpleCache_timeout = 60000;

  static public String loadSnippet_simpleCache(String id) {
    if (id == null)
      return null;
    Lock __0 = loadSnippet_simpleCache_lock;
    lock(__0);
    try {
      id = fsI(id);
      String src = loadSnippet_simpleCache_map.get(id);
      if (src != null)
        return src;
      Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_simpleCache_timeout);
      try {
        src = loadSnippet(id);
        if (src != null)
          loadSnippet_simpleCache_map.put(id, src);
        return src;
      } finally {
        loadPage_forcedTimeout_byThread.set(oldTimeout);
      }
    } finally {
      unlock(__0);
    }
  }

  static public String href(String link, Object contents, Object... params) {
    if (link == null)
      return str(contents);
    return tag("a", contents, arrayPlus(params, "href", link));
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  static public String hreplacetag(String html, String tag, String newTag) {
    List<String> tok = htmlcoarsetok(html);
    List<List<String>> tags = findContainerTag(tok, tag);
    if (empty(tags))
      return html;
    List<String> theTag = first(tags);
    List<String> actualTag = subList(theTag, 1, l(theTag) - 1);
    return join(replaceSubList(cloneList(tok), actualTag, litlist(newTag)));
  }

  static public String containerTag(String tag) {
    return containerTag(tag, "");
  }

  static public String containerTag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    return openingTag + s + "</" + tag + ">";
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public Object subBot_serveWithContentType(String text, String contentType) {
    return callMainBot("serveByteArray", toUtf8(text), contentType);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public Collection<Concept> findConceptsWhere(String c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFields(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConcepts(concepts.list(c), params);
  }

  static public Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
    return filterConcepts(concepts.list(c), params);
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public String hhmm() {
    return hhmm(now());
  }

  static public String hhmm(long time) {
    return new SimpleDateFormat("HHmm").format(time);
  }

  static public Object serveWithContentType(String text, String contentType) {
    return serveByteArray(toUtf8(text), contentType);
  }

  static public String dropTrailingSlash(String s) {
    return dropSuffix("/", s);
  }

  static public String replaceDollarVars(String s, Object... params) {
    if (empty(params))
      return s;
    Map<String, Object> vars = mapKeys(__52 -> dropDollarPrefix(__52), (Map<String, Object>) litcimap(params));
    return regexpReplaceIC(s, "\\$(\\w+)", matcher -> {
      String var = matcher.group(1);
      Object val = vars.get(var);
      return val == null ? matcher.group() : str(val);
    });
  }

  static public String htmlEncode(String s) {
    return htmlencode(s);
  }

  static public boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  static public boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public void dataToTable_dynSet(List l, int i, Object s) {
    while (i >= l.size()) l.add("");
    l.set(i, s);
  }

  static public List dataToTable_makeRow(Object x, List<String> cols) {
    if (instanceOf(x, "DynamicObject"))
      x = get_raw(x, "fieldValues");
    if (x instanceof Map) {
      Map m = (Map) x;
      List row = new ArrayList();
      for (Object _field : keysWithoutHidden(m)) {
        String field = (String) _field;
        Object value = m.get(field);
        int col = cols.indexOf(field);
        if (col < 0) {
          cols.add(field);
          col = cols.size() - 1;
        }
        dataToTable_dynSet(row, col, dataToTable_wrapValue(value));
      }
      return row;
    }
    if (x instanceof List)
      return allToString(((List) x));
    return litlist(structureOrText(x));
  }

  static public Object dataToTable_wrapValue(Object o) {
    if (o instanceof BufferedImage)
      return o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof RGBImage)
      return o;
    if (o instanceof Boolean)
      return o;
    return structureOrTextForUser(o);
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public String structureOrText(Object o) {
    return o instanceof String ? (String) o : structure(o);
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public String hopeningtag(String tag, Map params) {
    return hopeningTag(tag, params);
  }

  static public String hopeningtag(String tag, Object... params) {
    return hopeningTag(tag, params);
  }

  static public <A> List<A> padList(List<A> l, int w, A a) {
    if (l(l) >= w)
      return l;
    List<A> x = cloneList(l);
    while (l(x) < w) x.add(a);
    return x;
  }

  static public <A> A getOrKeep(Map<A, ? extends A> map, A a) {
    if (map == null)
      return a;
    A v = map.get(a);
    return v != null ? v : a;
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public List<Map> rawEmojisList() {
    return (List) jsonDecodeMap(loadTextFile(loadLibrary("#1400427"))).get("emojis");
  }

  static public String hAddToHead(String html, String tag) {
    List<String> tok = htmlTok(html);
    List<String> head = first(findContainerTag(tok, "head"));
    if (head == null)
      return tag + html;
    head.set(2, addLineBreak(tag) + head.get(2));
    return join(tok);
  }

  static public String hcss_responstable() {
    return hcss("\r\n    .responstable {\r\n      margin: 1em 0;\r\n      width: 100%;\r\n      overflow: hidden;\r\n      background: #FFF;\r\n      color: #024457;\r\n      border-radius: 10px;\r\n      border: 1px solid #167F92;\r\n    }\r\n    \r\n    .responstable tr {\r\n      border: 1px solid #D9E4E6;\r\n    }\r\n    .responstable tr:nth-child(odd) {\r\n      background-color: #EAF3F3;\r\n    }\r\n    .responstable th {\r\n      display: none;\r\n      border: 1px solid #FFF;\r\n      background-color: #167F92;\r\n      color: #FFF;\r\n      padding: 1em;\r\n    }\r\n    .responstable th:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n    }\r\n    .responstable th:nth-child(2) {\r\n      display: table-cell;\r\n    }\r\n    .responstable th:nth-child(2) span {\r\n      display: none;\r\n    }\r\n    .responstable th:nth-child(2):after {\r\n      content: attr(data-th);\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th:nth-child(2) span {\r\n        display: block;\r\n      }\r\n      .responstable th:nth-child(2):after {\r\n        display: none;\r\n      }\r\n    }\r\n    .responstable td {\r\n      display: block;\r\n      word-wrap: break-word;\r\n      max-width: 7em;\r\n    }\r\n    .responstable td:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n      border-right: 1px solid #D9E4E6;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable td {\r\n        border: 1px solid #D9E4E6;\r\n      }\r\n    }\r\n    .responstable th, .responstable td {\r\n      text-align: left;\r\n      margin: .5em 1em;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th, .responstable td {\r\n        display: table-cell;\r\n        padding: 1em;\r\n      }\r\n    }\r\n  ");
  }

  static public String hStylesheetSnippet_maxCache(String snippetID) {
    return tag("link", "", "rel", "stylesheet", "type", "text/css", "href", snippetRawURL_maxCache(snippetID, "text/css"));
  }

  static public String hjssnippet_maxCache(String snippetID) {
    return hfulltag("script", "", "src", snippetRawURL_maxCache(snippetID, "text/javascript"));
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first(((Collection) strings)));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public String joinNempties(String sep, String... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Collection<String> strings) {
    return joinStrings(sep, strings);
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public String hrefBlank(String link, Object contents, Object... params) {
    return tag("a", contents, concatArrays(new Object[] { "href", link, "target", "_blank" }, params));
  }

  static public String hfileupload(Object... params) {
    return hinput("", paramsPlus_noOverwrite(params, "type", "file", "name", "thefile"));
  }

  static public boolean isSubclass(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public <A, B> List<A> keysList(Map<A, B> map) {
    return cloneListSynchronizingOn(keys(map), map);
  }

  static public <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

  static public <A> List<A> sortedByCalculatedField(Iterable<A> c, Object f) {
    return sortByCalculatedField(c, f);
  }

  static public <A> List<A> sortedByCalculatedField(Object f, Iterable<A> c) {
    return sortedByCalculatedField(c, f);
  }

  static public <A, B> List<A> sortedByCalculatedField(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(a), f.get(b));
      }
    });
    return l;
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public String nlToBr_withIndents(String s) {
    s = nlToBr(s);
    StringBuilder buf = new StringBuilder();
    int i = 0;
    while (i < l(s)) {
      while (charAt(s, i) == ' ') {
        ++i;
        buf.append("&nbsp;");
      }
      int j = smartIndexOf(s, i, '\n') + 1;
      buf.append(substring(s, i, j));
      i = j;
    }
    return str(buf);
  }

  static public <A> A replaceIfEqual(A a, A b, A c) {
    return eq(a, b) ? c : a;
  }

  static public List<String> toLinesFullTrim(String s) {
    List<String> l = new ArrayList();
    for (String line : toLines(s)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public List<String> toLinesFullTrim(File f) {
    List<String> l = new ArrayList();
    for (String line : linesFromFile(f)) if (nempty(line = trim(line)))
      l.add(line);
    return l;
  }

  static public String rtrim_fromLines(Collection lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null) {
      boolean first = true;
      for (Object line : lines) {
        if (first)
          first = false;
        else
          buf.append('\n');
        buf.append(str(line));
      }
    }
    return buf.toString();
  }

  static public String localDateWithMinutes(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm");
    return format.format(time);
  }

  static public String localDateWithMinutes() {
    return localDateWithMinutes(now());
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public <A> String pnlToStringWithEmptyLines(Iterable<A> l) {
    return pnlToString(map(l, o -> o + "\n"));
  }

  static public <A> List<A> withoutNulls(List<A> l) {
    if (!containsNulls(l))
      return l;
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public int[] subArray(int[] b, int start, int end) {
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public short[] subArray(short[] b, int start, int end) {
    if (start <= 0 && end >= l(b))
      return b;
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public float[] subArray(float[] b, int start, int end) {
    float[] x = new float[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public Object[] subArray(Object[] b, int start) {
    return subArray(b, start, l(b));
  }

  static public Object[] subArray(Object[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new Object[0];
    Object[] x = new Object[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public Object[] arrayPlus(Object[] a1, Object... a2) {
    return concatArrays(a1, a2);
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public String snippetImageLink(String snippetID) {
    return snippetImageURL(snippetID);
  }

  static public String hsnippetimg(String imageID, Object... params) {
    return himg(snippetImageLink(imageID), params);
  }

  static public String str_toK(long l) {
    return toK(l) + " K";
  }

  static public void saveBinaryFileVerbose(File f, byte[] data) {
    boolean exists = f.exists();
    saveBinaryFile(f, data);
    print((!exists ? "Created" : "Updated") + " file " + f2s(f) + " (" + f.length() + " bytes)");
  }

  static public AutoCloseable tempDBLock(Concepts concepts) {
    return tempLock(concepts.lock);
  }

  static public AutoCloseable tempDBLock() {
    return tempDBLock(db_mainConcepts());
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public <A extends Concept> A findConceptWhereCI(Class<A> c, Object... params) {
    return findConceptWhereCI(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.ciFieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFieldsIC(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFieldsIC(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhereCI(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFieldsIC(x, params))
      return x;
    return null;
  }

  static public int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  static public int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnull(l)) n += cset(c, values);
    return n;
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public double toSeconds(long ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(long ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toSeconds(double ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(double ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public Object[] params_stylePlus(Object[] params, String style) {
    return paramsPlus(params, "style", joinNemptiesWithSemicolon(stringPar("style", params), style));
  }

  static public Object[] params_stylePlus(String style, Object[] params) {
    return params_stylePlus(params, style);
  }

  static public <A> List<A> reversedList(Collection<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public String reversedString(String s) {
    return reverseString(s);
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public <A> int nfilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(pred, c);
  }

  static public <A> int nfilter(IF1<A, Boolean> pred, Iterable<A> c) {
    int n = 0;
    if (c != null)
      for (A o : c) if (pred.get(o))
        ++n;
    return n;
  }

  static public int nfilter(Iterable c, Object pred) {
    int n = 0;
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        ++n;
    return n;
  }

  static public int nfilter(Object pred, Iterable c) {
    return nfilter(c, pred);
  }

  static public String n2(long l) {
    return formatWithThousands(l);
  }

  static public String n2(Collection l) {
    return n2(l(l));
  }

  static public String n2(Map map) {
    return n2(l(map));
  }

  static public String n2(double l, String singular) {
    return n2(l, singular, singular + "s");
  }

  static public String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  static public String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(long l, String singular) {
    return n_fancy2(l, singular, singular + "s");
  }

  static public String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  static public String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  static public String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  static public String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  static public String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  static public String actualProgramID() {
    return programID();
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public String loadSecretTextFile(String name) {
    return loadTextFile(new File(getSecretProgramDir(), name));
  }

  static public String loadSecretTextFile(String progID, String name) {
    return loadTextFile(new File(getSecretProgramDir(progID), name));
  }

  static public void saveSecretTextFile(String name, String s) {
    saveTextFile(new File(getSecretProgramDir(), name), s);
  }

  static public void saveSecretTextFile(String progID, String name, String s) {
    saveTextFile(new File(getSecretProgramDir(progID), name), s);
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      mkdirsForFile(file);
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      vmBus_send("wroteFile", file);
      return file;
    } finally {
      action.done();
    }
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] concatArrays(Object[]... arrays) {
    int l = 0;
    for (Object[] a : arrays) l += l(a);
    Object[] x = new Object[l];
    int i = 0;
    for (Object[] a : arrays) if (a != null) {
      System.arraycopy(a, 0, x, i, l(a));
      i += l(a);
    }
    return x;
  }

  static public String hpasswordfield(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "password", "name", name, "value", value }, params));
  }

  static public String hpasswordfield(String name) {
    return hpasswordfield(name, "");
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public String windowsLineBreaks(String s) {
    return s == null ? null : s.replaceAll("(?<!\r)\n", "\r\n");
  }

  static public String mapToLines_rtrim(Object f, Map map) {
    return lines_rtrim(map(map, f));
  }

  static public String mapToLines_rtrim(Object f, Iterable l) {
    return lines_rtrim(map(f, l));
  }

  static public <A> String mapToLines_rtrim(Iterable<A> l, IF1<A, String> f) {
    return mapToLines_rtrim(f, l);
  }

  static public String newLinesToSpaces(String s) {
    return s == null ? null : fixNewLines(s).replace("\n", " ");
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll(b);
    return a;
  }

  static public MultiMap treeMultiMapIndexByField(Collection c, String field) {
    MultiMap map = treeMultiMap();
    for (Object a : c) {
      Object val = getOpt(a, field);
      if (val != null)
        map.put(val, a);
    }
    return map;
  }

  static public MultiMap treeMultiMapIndexByField(String field, Collection c) {
    return treeMultiMapIndexByField(c, field);
  }

  static public Cache<List<CountryDialCode>> countryDialCodes_cache = new Cache<>(() -> countryDialCodes_load());

  static public List<CountryDialCode> countryDialCodes() {
    return countryDialCodes_cache.get();
  }

  static public List<CountryDialCode> countryDialCodes_load() {
    return sortedByField("dialCode", filter(c -> nempty(c.dialCode), map((List<Map<String, String>>) loadJSONFile(loadLibrary("#1400429")), m -> new CountryDialCode(m.get("name"), m.get("code"), m.get("dial_code")))));
  }

  static public List<String> nempties(Collection<String> c) {
    return filterNempty(c);
  }

  static public List<String> splitAtComma(String s) {
    return empty(s) ? emptyList() : asList(s.split(","));
  }

  static public CountryDialCode countryDialCodeByCountryCode(String countryCode) {
    return objectWhere(countryDialCodes(), "countryCode", upper(countryCode));
  }

  static public <A> List<A> sorted(Collection<A> c, final Object comparator) {
    List<A> l = cloneList(c);
    sort(l, makeComparator(comparator));
    return l;
  }

  static public <A> List<A> sorted(Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l);
    return l;
  }

  static public List collect(Iterable c, String field) {
    return collectField(c, field);
  }

  static public List collect(String field, Iterable c) {
    return collectField(c, field);
  }

  static public Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String dropPrefixTrim(String prefix, String s) {
    return trim(dropPrefix(prefix, s));
  }

  static public Object serveJSON_shallowLineBreaks(Object data) {
    return serveText(jsonEncode_shallowLineBreaks(data));
  }

  static public String localDateWithSeconds(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
    return format.format(time);
  }

  static public String localDateWithSeconds() {
    return localDateWithSeconds(now());
  }

  static public String smallestTransparentGIFDataURI() {
    return "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public Object[] toObjectArray(Collection c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public boolean cicWithSmartWordBoundary(String a, String b) {
    return containsRegexpIC(a, phraseToRegExp(b));
  }

  static public boolean match3_startOrEndOfLine(String pat, String s, boolean startOfLine, boolean endOfLine) {
    if (startOfLine)
      return endOfLine ? match3(pat, s) : matchStart(pat, s);
    else
      return endOfLine ? matchEnd(pat, s) : find3(pat, s);
  }

  static public boolean all(Object pred, Iterable l) {
    if (l != null)
      for (Object o : l) if (!isTrue(callF(pred, o)))
        return false;
    return true;
  }

  static public <A> boolean all(Iterable<A> l, IF1<A, Boolean> f) {
    if (l != null)
      for (A a : l) if (!f.get(a))
        return false;
    return true;
  }

  static public <A> boolean all(IF1<A, Boolean> f, Iterable<A> l) {
    return all(l, f);
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public <A> A lowestByField(Iterable<A> l, String field) {
    A lowest = null;
    Object lowestValue = null;
    for (A a : unnull(l)) {
      Object val = getOpt(a, field);
      if (lowest == null || cmp(val, lowestValue) < 0) {
        lowest = a;
        lowestValue = val;
      }
    }
    return lowest;
  }

  static public <A> A lowestByField(String field, Iterable<A> l) {
    return lowestByField(l, field);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
    return isConceptFieldIndexed(db_mainConcepts(), c, field);
  }

  static public boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
    return concepts.getFieldIndex(c, field) != null;
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Class<A> c, String field) {
    return getConceptFieldCIIndex(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Concepts concepts, Class<A> c, String field) {
    return (ConceptFieldIndexCI) concepts.getCIFieldIndex(c, field);
  }

  static public List mapNonCodeTokens(Object f, List l) {
    List out = emptyList(l);
    for (int i = 0; i < l(l); i++) {
      Object o = l.get(i);
      out.add(even(i) ? callF(f, o) : o);
    }
    return out;
  }

  static public List mapNonCodeTokens(List l, Object f) {
    return mapNonCodeTokens(f, l);
  }

  static public List<String> mapNonCodeTokens(List<String> tok, IF1<String, String> f) {
    return mapNonCodeTokens(tok, (Object) f);
  }

  static public List<String> mapNonCodeTokens(IF1<String, String> f, List<String> tok) {
    return mapNonCodeTokens(tok, f);
  }

  static public String emojisToUnicode(String s) {
    return regexReplace(s, ":(\\w+):", matcher -> lookupOrKeep(emojiShortNameMap(), matcher.group()));
  }

  static public List<String> htmlTok(String s) {
    return htmlcoarsetok(s);
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public boolean subBot_isHttps() {
    Object httpd = subBot_httpd();
    return eqOneOf(httpd, getOpt(mainBot(), "serveHttps_server"), getOpt(mainBot(), "serveHttpsWithWebsockets_server")) || contains((Collection) getOpt(mainBot(), "serveHttpsWithWebsockets_multiplePorts_servers"), httpd);
  }

  static public String domain() {
    return domainName();
  }

  static public String unicodeFromCodePoint(int codePoint) {
    return codePointToString(codePoint);
  }

  static public TreeSet<String> toCaseInsensitiveSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, x);
    return set;
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  static public List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  static public int toLines_nextLineBreak(String s, int start) {
    int n = s.length();
    for (int i = start; i < n; i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1] + ". ");
    return trim(join(l));
  }

  static public TimeZone timeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public String timeInTimeZone(String timeZone) {
    return timeInTimeZone(timeZone, now());
  }

  static public String timeInTimeZone(String timeZone, long time) {
    return simpleDateFormat_timeZone("HH:mm", timeZone).format(time);
  }

  static public String timeInTimeZone(TimeZone timeZone, long time) {
    return simpleDateFormat("HH:mm", timeZone).format(time);
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public String ipToCountry2020_dataSnippetID = "#1400400";

  static public Lock ipToCountry2020_lock = lock();

  static public File ipToCountry2020_dataDir() {
    return javaxCachesDir("ipToCountry2020");
  }

  static public String ipToCountry2020(String ip) {
    return ipToCountry2020(ipToInt(ip));
  }

  static public String ipToCountry2020(long ipNum) {
    {
      Lock __0 = ipToCountry2020_lock;
      lock(__0);
      try {
        if (directoryEmpty(ipToCountry2020_dataDir()))
          unzipSnippet(ipToCountry2020_dataSnippetID, ipToCountry2020_dataDir());
      } finally {
        unlock(__0);
      }
    }
    String line = pairB(binarySearchForLineInTextFile(newFile(ipToCountry2020_dataDir(), "IP2LOCATION-LITE-DB1.CSV"), s -> {
      List<String> l = tok_splitAtComma_unquote(s);
      long a = parseLongOpt(first(l)), b = parseLongOpt(second(l));
      return ipNum > b ? 1 : ipNum < a ? -1 : 0;
    }));
    return get(tok_splitAtComma_unquote(line), 2);
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public String deSquareBracket(String s) {
    if (startsWith(s, "[") && endsWith(s, "]"))
      return substring(s, 1, l(s) - 1);
    return s;
  }

  static public String regexpReplaceIC(String s, String pat, Object f) {
    return regexReplaceIC(s, pat, f);
  }

  static public String regexpReplaceIC(String s, String pat, IF1<Matcher, String> f) {
    return regexReplaceIC(s, pat, f);
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  static public String roundBracket(String s) {
    return "(" + s + ")";
  }

  static public String newLinesToSpaces_trim(String s) {
    return s == null ? null : trim(s).replaceAll("\\s*\r?\n\\s*", " ");
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public String decimalFormatEnglish(String format, double d) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
  }

  static public boolean regexpMatches(String pat, String s) {
    return pat != null && s != null && regexp(pat, s).matches();
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public String structureForUser(Object o) {
    return beautifyStructure(struct_noStringSharing(o));
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public <A, B> Map<A, B> filterMapByFunctionOnKey(Map<A, B> map, Object f) {
    Map<A, B> m2 = similarEmptyMap(map);
    for (A a : keys(map)) {
      if (isTrue(callF(f, a)))
        m2.put(a, map.get(a));
    }
    return m2;
  }

  static public <A, B> Map<A, B> filterMapByFunctionOnKey(Object f, Map<A, B> map) {
    return filterMapByFunctionOnKey(map, f);
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public String tok_deRoundBracket(String s) {
    return tok_isRoundBracketed(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public List<String> javaTokWithBrackets(String s) {
    return javaTokPlusBrackets(s);
  }

  static public List<String> tok_splitAtComma(String s) {
    return tok_splitAtComma(javaTok(s));
  }

  static public List<String> tok_splitAtComma(List<String> tok) {
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(joinSubList(tok, i + 1, j - 1));
      i = j;
    }
    return out;
  }

  static public List<String> tok_splitAtPlus(String s) {
    return tok_splitAtPlus(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtPlus(List<String> tok) {
    return splitAtTokens(tok, "+");
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public List<String> tok_splitAtAsterisk(String s) {
    return tok_splitAtAsterisk(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtAsterisk(List<String> tok) {
    return splitAtTokens(tok, "*");
  }

  static public double parseDouble(String s) {
    return Double.parseDouble(s);
  }

  static public <A> A second(List<A> l) {
    return get(l, 1);
  }

  static public <A> A second(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    it.next();
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A second(A[] bla) {
    return bla == null || bla.length <= 1 ? null : bla[1];
  }

  static public <A, B> B second(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public <A> A second(Producer<A> p) {
    if (p == null)
      return null;
    if (p.next() == null)
      return null;
    return p.next();
  }

  static public char second(String s) {
    return charAt(s, 1);
  }

  static public <A, B> B second(Either<A, B> e) {
    return e == null ? null : e.bOpt();
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public TreeMap litCIMap(Object... x) {
    TreeMap map = caseInsensitiveMap();
    litmap_impl(map, x);
    return map;
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public <A> List<A> syncList() {
    return synchroList();
  }

  static public <A> List<A> syncList(List<A> l) {
    return synchroList(l);
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component c : unnull(b)) if (c != null)
              a.add(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component c : unnull(b))\r\n      if (c != null) \r\n        a.add(c);";
        }
      });
    }
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public int globalIDLength() {
    return 16;
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public void failIfOddCount(Object... list) {
    if (odd(l(list)))
      throw fail("Odd list size: " + list);
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public List<String> getPlural_specials = ll("sheep", "fish");

  static public String getPlural(String s) {
    if (containsIgnoreCase(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public Map<String, String> humanizeFormLabel_replacements = litmap("id", "ID", "md5", "MD5");

  static public String humanizeFormLabel(String s) {
    if (containsSpace(s))
      return s;
    return firstToUpper(joinWithSpace(replaceElementsUsingMap(splitCamelCase(s), humanizeFormLabel_replacements)).replace("I D", "ID"));
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public String toStringOpt(Object o) {
    return o instanceof String ? ((String) o) : null;
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public long getLong(Object o, String field) {
    return toLong(getOpt(o, field));
  }

  static public long getLong(String field, Object o) {
    return getLong(o, field);
  }

  static public String[] conceptFields_gen_drop = { "className", "fieldValues", "id", "created", "_modified", "refs", "backRefs", "_concepts" };

  static public Set<String> conceptFields_gen(Object c) {
    return setMinus(mergeSets(allNonStaticNonTransientFields(c), keys((Map) getOpt_raw(c, "fieldValues"))), conceptFields_gen_drop);
  }

  static public Set<String> conceptFields_gen(Class c) {
    return setMinus(allNonStaticNonTransientFields(c), conceptFields_gen_drop);
  }

  static public List<Field> nonStaticNonTransientFieldObjects(Object o) {
    if (o == null)
      return null;
    List<Field> fields = new ArrayList();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(makeAccessible(f));
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public String jextract(String pat, String s) {
    return jextract(pat, javaTok(s));
  }

  static public String jextract(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    jfind_preprocess(tokpat);
    int i = jfind(tok, tokpat);
    if (i < 0)
      return null;
    int j = i + l(tokpat) - 2;
    return joinSubList(tok, i, j);
  }

  static public <A, B> List<B> valuesList(Map<A, B> map) {
    return cloneListSynchronizingOn(values(map), map);
  }

  static public <A, B> List<B> valuesList(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public String optCastToString(Object o) {
    return o instanceof String ? (String) o : null;
  }

  static public boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public boolean _cSmartSetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (f != null && value != null) {
        Class type = primitiveToBoxedTypeOpt(f.getType());
        if (type == Integer.class && !(value instanceof Integer)) {
          if (!setField_trueIfChanged(f, c, toInt(trimIfString(value))))
            return false;
          if (!isTransient(f))
            c.change();
          return true;
        }
        if (type == Boolean.class && value instanceof String)
          return _csetField(c, field, eqicOneOf((String) value, "1", "true"));
        if (type == GlobalID.class && value instanceof String)
          return _csetField(c, field, new GlobalID((String) value));
      }
      return _csetField(c, field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean cSmartSetField_withConverter(Concept c, String field, Object value, ValueConverterForField converter) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (f != null) {
        if (converter != null && value != null) {
          OrError<Object> result = converter.convertValue(c, f, value);
          if (result == null)
            throw fail("Unknown conversion " + className(value) + " => " + f);
          if (!result.ok())
            throw fail("Unknown conversion " + className(value) + " => " + f + ": " + result.error());
          value = result.get();
        }
        if (value instanceof List && f.getType() == Concept.RefL.class) {
          ((Concept.RefL) f.get(c)).replaceWithList((List) value);
          return true;
        }
        if (value instanceof Concept && f.getType() == Concept.Ref.class)
          return ((Concept.Ref) f.get(c)).set((Concept) value);
      }
      return _csetField(c, field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A cget(Object c, String field) {
    Object o = getOpt(c, field);
    if (o instanceof Concept.Ref)
      return (A) ((Concept.Ref) o).get();
    return (A) o;
  }

  static public <A> A cget(String field, Object c) {
    return cget(c, field);
  }

  static public Class typeToClass(Type type) {
    if (type == null)
      return null;
    if (type instanceof Class)
      return ((Class) type);
    if (type instanceof ParameterizedType)
      return optCast(Class.class, ((ParameterizedType) type).getRawType());
    return null;
  }

  static public Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public <A> A firstThat(Iterable<A> l, Object pred) {
    if (l != null)
      for (A a : l) if (checkCondition(pred, a))
        return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return a;
    return null;
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, (Object) pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> boolean syncNempty(Collection<A> l) {
    return !syncEmpty(l);
  }

  static public Class<?> hotwire(String src) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public boolean isInstanceOf(Object o, Class type) {
    return type.isInstance(o);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public int cmpAlphaNum(String a, String b) {
    return alphaNumComparator().compare(a, b);
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public <A, B, C, D> Map<C, D> mapMapToMap(IF2<A, B, Pair<C, D>> f, Map<A, B> m) {
    if (m == null)
      return null;
    Map<C, D> map = similarEmptyMap(m);
    for (Map.Entry<A, B> e : m.entrySet()) {
      Pair<C, D> p = f.get(e.getKey(), e.getValue());
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C, D> Map<C, D> mapMapToMap(Map<A, B> m, IF2<A, B, Pair<C, D>> f) {
    return mapMapToMap(f, m);
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public String unicode_downPointingTriangle() {
    return charToString(0x25BC);
  }

  static public String unicode_upPointingTriangle() {
    return charToString(0x25B2);
  }

  static public Object[] assertEvenLength(Object[] a) {
    assertTrue(even(l(a)));
    return a;
  }

  static public LinkedHashMap paramsToOrderedMap(Object... params) {
    return asLinkedHashMap(paramsToMap(params));
  }

  static public Object[] paramsPlus_skipFirst(Object[] a1, Object... a2) {
    if (odd(l(a1)))
      return itemPlusArray(first(a1), paramsPlus(dropFirst(a1), a2));
    return paramsPlus(a1, a2);
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public String htableRaw2(List<? extends List> data, List paramsTable, List paramsTR, List paramsTD) {
    StringBuilder buf = new StringBuilder();
    for (List row : data) {
      buf.append(hopeningTag("tr", toObjectArray(paramsTR)));
      for (Object cell : row) buf.append(htd(cell, toObjectArray(paramsTD))).append("\n");
      buf.append("</tr>\n");
    }
    return htag("table", buf, toObjectArray(paramsTable));
  }

  static public Object[] html_massageAutofocusParam(Object[] params) {
    Object autofocus = optPar("autofocus", params);
    return changeParam(params, "autofocus", eqOneOf(autofocus, true, 1, "1", "autofocus") ? html_valueLessParam() : null);
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (val == html_valueLessParam())
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public String htextinput(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "text", "name", name, "value", value }, params));
  }

  static public String htextinput(String name) {
    return htextinput(name, "");
  }

  static public String hlabelFor(String id, Object contents) {
    return htag("label", contents, "for", id);
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public String programTitle() {
    return getProgramName();
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  static public JFrame getFrame(final Object _o) {
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JFrame)
              return (JFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A> A setFrameTitle(A c, final String title) {
    final Frame f = getAWTFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(title);";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A setFrameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public JFrame setFrameTitle(String title) {
    Object f = getOpt(mc(), "frame");
    if (f instanceof JFrame)
      return setFrameTitle((JFrame) f, title);
    return null;
  }

  static public JFrame setFrameIconLater(Component c, final String imageID) {
    final JFrame frame = getFrame(c);
    if (frame != null)
      startThread("Loading Icon", new Runnable() {

        public void run() {
          try {
            final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
            swingLater(new Runnable() {

              public void run() {
                try {
                  frame.setIconImage(i);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "frame.setIconImage(i);";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Image i = imageIcon(or2(imageID, \"#1005557\")).getImage();\r\n      swingL...";
        }
      });
    return frame;
  }

  static public void _initFrame(JFrame f) {
    myFrames_list.put(f, Boolean.TRUE);
    standardTitlePopupMenu(f);
  }

  static public JComponent wrap(Object swingable) {
    return _recordNewSwingComponent(wrap_2(swingable));
  }

  static public JComponent wrap_2(Object swingable) {
    if (swingable == null)
      return null;
    JComponent c;
    if (swingable instanceof Component)
      c = componentToJComponent(((Component) swingable));
    else
      c = componentToJComponent((Component) callOpt(swingable, "swing"));
    if (c instanceof JTable || c instanceof JList || c instanceof JTextArea || c instanceof JEditorPane || c instanceof JTextPane || c instanceof JTree)
      return jscroll(c);
    return c == null ? jlabel(str(swingable)) : c;
  }

  static public Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

  static public Rectangle defaultNewFrameBounds() {
    return swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          defaultNewFrameBounds_r.translate(60, 20);
          if (!screenRectangle().contains(defaultNewFrameBounds_r))
            defaultNewFrameBounds_r.setLocation(30 + random(30), 20 + random(20));
          return new Rectangle(defaultNewFrameBounds_r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "defaultNewFrameBounds_r.translate(60, 20);\r\n    if (!screenRectangle().contai...";
      }
    });
  }

  static public void hideConsole() {
    final JFrame frame = consoleFrame();
    if (frame != null) {
      autoVMExit();
      swingLater(new Runnable() {

        public void run() {
          try {
            frame.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setVisible(false);";
        }
      });
    }
  }

  static public Class primitiveToBoxedType(Class type) {
    if (type == boolean.class)
      return Boolean.class;
    if (type == int.class)
      return Integer.class;
    if (type == long.class)
      return Long.class;
    if (type == float.class)
      return Float.class;
    if (type == short.class)
      return Short.class;
    if (type == char.class)
      return Character.class;
    if (type == byte.class)
      return Byte.class;
    if (type == double.class)
      return Double.class;
    return null;
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public String format(String pat, Object... args) {
    return format3(pat, args);
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public Runnable wrapAsActivity(Object r) {
    return toRunnable(r);
  }

  static public Thread newThread(Object runnable) {
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public Runnable toRunnable(final Object o) {
    if (o instanceof Runnable)
      return (Runnable) o;
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  static public void cancelThread(Thread t) {
    if (t == null)
      return;
    ping();
    synchronized (ping_actions) {
      ping_actions.put(t, "cancelled");
      ping_anyActions = true;
    }
  }

  static public Set<String> allFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public String htitle_h1(String s) {
    return htitle_noEncode(dropTags(s)) + h1(s);
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public String stringPar(Object[] params, String name) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Object[] params) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Map params) {
    return (String) optPar(name, params);
  }

  static public String stringPar(String name, Object[] params, String defaultValue) {
    return optPar(name, params, defaultValue);
  }

  static public String unicode_leftPointingTriangle() {
    return unicodeFromCodePoint(0x25C2);
  }

  static public String unicode_rightPointingTriangle() {
    return charToString(0x25B8);
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long)
        value = ((Long) value).intValue();
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  static public Map<JFrame, Boolean> myFrames_list = weakHashMap();

  static public List<JFrame> myFrames() {
    return swing(new F0<List<JFrame>>() {

      public List<JFrame> get() {
        try {
          return keysList(myFrames_list);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret keysList(myFrames_list);";
      }
    });
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  static public Object dm_getModule(Object moduleOrID) {
    if (moduleOrID == null || eq(moduleOrID, ""))
      return null;
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      return dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_callOS("getDynModuleByID", str(moduleOrID));
    return dm_resolveModule(moduleOrID);
  }

  static public AutoCloseable dm_enter(Object mod) {
    return (AutoCloseable) callOpt(dm_getModule(mod), "enter");
  }

  static public String dm_moduleLibID() {
    return programID() + "/" + shortClassName(dm_current_mandatory_generic());
  }

  static public String dm_moduleLibID(Object mod) {
    if (mod == null)
      return null;
    mod = dm_getModule(mod);
    if (hasSuperclassShortNamed(mod, "DynModule"))
      return programID(mod) + "/" + shortClassName(mod);
    return null;
  }

  static public List<String> dm_modulesWithLibID(final String moduleLibID) {
    return filter(dm_moduleIDs(), new F1<String, Boolean>() {

      public Boolean get(String m) {
        try {
          return eq(dm_moduleLibID(m), moduleLibID);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "eq(dm_moduleLibID(m), moduleLibID)";
      }
    });
  }

  static public String dm_moduleID(Object module) {
    return strOrNull(getOpt(dm_getStem(module), "id"));
  }

  static public String dm_moduleID() {
    return dm_moduleID(dm_current_mandatory_generic());
  }

  static public String lowestByAlphaNum(Collection<String> c) {
    String best = null;
    for (String s : unnull(c)) if (best == null || alphaNumComparator().compare(s, best) < 0)
      best = s;
    return best;
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public AutoCloseable tempActivity(Object r) {
    return null;
  }

  static public long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  static public Object costCenter() {
    return mc();
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public List<String> splitAtAmpersand(String s) {
    return s == null ? emptyList() : asList(s.split("&"));
  }

  static public String urldecode(String x) {
    try {
      return URLDecoder.decode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public Object mainBot() {
    return getMainBot();
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public <A> IterableIterator<A> enumerationToIterator(final Enumeration<A> e) {
    return e == null ? null : new IterableIterator() {

      public boolean hasNext() {
        return e.hasMoreElements();
      }

      public A next() {
        return e.nextElement();
      }
    };
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(List<A> l, final Object f) {
    sort(l, new Comparator<A>() {

      public int compare(A b, A a) {
        return stdcompare((Object) callF(f, a), (Object) callF(f, b));
      }
    });
    return l;
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(Object f, List<A> c) {
    return sortByCalculatedFieldDesc_inPlace(c, f);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public long collectMinLong(Collection c, String field) {
    long x = Long.MAX_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = min(x, l);
    }
    return x;
  }

  static public long collectMaxLong(Collection c, String field) {
    long x = Long.MIN_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = max(x, l);
    }
    return x;
  }

  static public String i(String s, Object... params) {
    return tag("i", s, params);
  }

  static public String formatDateAndTime(long timestamp) {
    return formatDate(timestamp);
  }

  static public String formatDateAndTime() {
    return formatDate();
  }

  static public String shortenEndTime(String endTime, String startTime) {
    int i = endTime.lastIndexOf(' ') + 1;
    if (i > 0 && eq(substring(startTime, 0, i), substring(endTime, 0, i)))
      return trim(substring(endTime, i));
    return endTime;
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public List<String> htmlcoarsetok(String s) {
    List<String> tok = new ArrayList<String>();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      while (j < l) {
        if (s.charAt(j) != '<')
          ++j;
        else if (s.substring(j, Math.min(j + 4, l)).equals("<!--")) {
          j = j + 4;
          do ++j; while (j < l && !s.substring(j, Math.min(j + 3, l)).equals("-->"));
          j = Math.min(j + 3, l);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '<') {
        ++j;
        while (j < l && s.charAt(j) != '>') ++j;
        if (j < l)
          ++j;
      }
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public List<List<String>> findContainerTag(List<String> tok, String tag) {
    List<List<String>> l = new ArrayList();
    for (int i = 1; i < l(tok); i += 2) if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i + 2; j < tok.size(); j += 2) if (isOpeningTag(tok.get(j), tag))
        ++level;
      else if (isTag(tok.get(j), "/" + tag)) {
        --level;
        if (level == 0) {
          l.add(tok.subList(i - 1, j + 2));
          break;
        }
      }
      i = j;
    }
    return l;
  }

  static public List<List<String>> findContainerTag(String html, String tag) {
    return findContainerTag(htmlTok(html), tag);
  }

  static public List<String> replaceSubList(List<String> l, List<String> x, List<String> y) {
    return replaceSublist(l, x, y);
  }

  static public <A> List<A> replaceSubList(List<A> l, int fromIndex, int toIndex, List<A> y) {
    return replaceSublist(l, fromIndex, toIndex, y);
  }

  static public Object[] dropEntryFromParams(Object[] params, int i) {
    int n = l(params);
    if (i < 0 || i >= n)
      return params;
    if (n == 2)
      return null;
    Object[] p = new Object[n - 2];
    System.arraycopy(params, 0, p, 0, i);
    System.arraycopy(params, i + 2, p, i, n - i - 2);
    return p;
  }

  static public <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
    if (empty(params))
      return list;
    List<A> l = new ArrayList();
    for (A x : list) if (checkConceptFields(x, params))
      l.add(x);
    return l;
  }

  static public int year() {
    return localYear();
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public int month() {
    return localMonth();
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public Object serveByteArray(byte[] data, String mimeType) {
    return subBot_serveByteArray(data, mimeType);
  }

  static public String dropDollarPrefix(String s) {
    return dropPrefix("$", s);
  }

  static public boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  static public boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  static public boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  static public boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  static public boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  static public boolean instanceOf(Class c, Object o) {
    return instanceOf(o, c);
  }

  static public <A, B> List<A> keysWithoutHidden(Map<A, B> map) {
    return filter(keys(map), new F1<Object, Boolean>() {

      public Boolean get(Object o) {
        try {
          return !eq(o, "[hidden]") && !isStringStartingWith(o, "[hidden] ");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "!eq(o, \"[hidden]\") && !isStringStartingWith(o, \"[hidden] \")";
      }
    });
  }

  static public String structureOrTextForUser(Object o) {
    return o == null ? "" : o instanceof String ? (String) o : structureForUser(o);
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public Map jsonDecodeMap(String s) {
    Object o = jsonDecode(s);
    if (o instanceof List && empty((List) o))
      return new HashMap();
    if (o instanceof Map)
      return (Map) o;
    else
      throw fail("Not a JSON map: " + s);
  }

  static public String addLineBreak(String s) {
    return addSuffix(s, "\n");
  }

  static public String snippetRawURL_maxCache(String snippetID) {
    return snippetRawURL_maxCache(snippetID, null);
  }

  static public String snippetRawURL_maxCache(String snippetID, String contentType) {
    return "https://botcompany.de/serve/" + psI(snippetID) + htmlQuery("ct", contentType, "maxCache", 1);
  }

  static public String joinStrings(String sep, String... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Collection<String> strings) {
    StringBuilder buf = new StringBuilder();
    for (String s : unnull(strings)) if (nempty(s)) {
      if (nempty(buf))
        buf.append(sep);
      buf.append(s);
    }
    return str(buf);
  }

  static public String hinput(Object contents, Object... params) {
    return htag("input", contents, params);
  }

  static public Object[] paramsPlus_noOverwrite(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) mapPut_noOverwrite(map, a2[i], a2[i + 1]);
    return mapToParams(map);
  }

  static public <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
    if (l == null)
      return new ArrayList();
    synchronized (mutex) {
      return new ArrayList<A>(l);
    }
  }

  static public <A> List<A> sortByCalculatedField(Iterable<A> c, final Object f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(callF(f, a), callF(f, b));
      }
    });
    return l;
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
      return linesFromReader(utf8bufferedReader(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(newFile(path));
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public <A> String pnlToString(String prefix, Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(prefix, l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(prefix, l)";
      }
    });
  }

  static public <A> String pnlToString(final Iterable<A> l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A> String pnlToString(final A[] l) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(l);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(l)";
      }
    });
  }

  static public <A, B> String pnlToString(final Map<A, B> map) {
    return hijackPrint(new Runnable() {

      public void run() {
        try {
          pnl(map);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pnl(map)";
      }
    });
  }

  static public <A, B> String pnlToString(MultiMap<A, B> map) {
    return pnlToString(multiMapToMap(map));
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public long toK(long l) {
    return (l + 1023) / 1024;
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public boolean checkConceptFieldsIC(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (!eqicOrEq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public String joinNemptiesWithSemicolon(String... strings) {
    return joinNempties("; ", strings);
  }

  static public String joinNemptiesWithSemicolon(Collection<String> strings) {
    return joinNempties("; ", strings);
  }

  static public String reverseString(String s) {
    return new StringBuilder(s).reverse().toString();
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public double fraction(double d) {
    return d % 1;
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  static public List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  static public class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  static public CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  static public void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public <A, B> MultiMap<A, B> treeMultiMap() {
    return new MultiMap(true);
  }

  static public <A, B> MultiMap<A, B> treeMultiMap(Comparator<A> comparator) {
    return new MultiMap(new TreeMap<A, List<B>>(comparator));
  }

  static public <A> List<A> sortedByField(Collection<A> c, final String field) {
    List<A> l = new ArrayList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(getOpt(a, field), getOpt(b, field));
      }
    });
    return l;
  }

  static public <A> List<A> sortedByField(String field, Collection<A> c) {
    return sortedByField(c, field);
  }

  static public Object loadJSONFile(File f) {
    return jsonDecode(loadTextFile(f));
  }

  static public List<String> filterNempty(Collection<String> c) {
    List<String> l = new ArrayList();
    for (String x : unnull(c)) if (nempty(x))
      l.add(x);
    return l;
  }

  static public <A> A objectWhere(Collection<A> c, Object... data) {
    return findWhere(c, data);
  }

  static public String upper(String s) {
    return s == null ? null : s.toUpperCase();
  }

  static public char upper(char c) {
    return Character.toUpperCase(c);
  }

  static public Comparator makeComparator(final Object f) {
    if (f instanceof Comparator)
      return (Comparator) f;
    return new Comparator() {

      public int compare(Object a, Object b) {
        return (Integer) callF(f, a, b);
      }
    };
  }

  static public List collectField(Iterable c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  static public List collectField(String field, Iterable c) {
    return collectField(c, field);
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    synchronized (callOpt_cache) {
      _MethodCache cache = callOpt_cache.get(c);
      if (cache == null)
        callOpt_cache.put(c, cache = new _MethodCache(c));
      return cache;
    }
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  static public String jsonEncode_shallowLineBreaks(Object o) {
    return jsonEncode_breakAtLevel1(o);
  }

  static public void jsonEncode_shallowLineBreaks(Object o, StringBuilder buf, int level) {
    jsonEncode_breakAtLevel1(o, buf, level);
  }

  static public String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  static public String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  static public boolean containsRegexpIC(String s, String pat) {
    return compileRegexpIC(pat).matcher(s).find();
  }

  static public String phraseToRegExp(String b) {
    return (startsWithLetterOrDigit(b) ? "\\b" : "") + regexpQuote(b) + (endsWithLetterOrDigit(b) ? "\\b" : "");
  }

  static public boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  static public boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  static public boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  static public boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  static public boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  static public boolean matchEnd(String pat, String s) {
    return matchEnd(pat, s, null);
  }

  static public boolean matchEnd(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    List<String> tokpat = parse3(pat), toks = parse3(s);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, takeLast(l(tokpat), toks));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = join(dropLast(l(tokpat), toks));
    }
    return true;
  }

  static public boolean find3(String pat, String s) {
    return find3(pat, s, null);
  }

  static public boolean find3(String pat, String s, Matches matches) {
    return find3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean find3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    String[] m = find2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  volatile static public boolean conceptsAndBot_running = false;

  static public boolean conceptsAndBot_thinOnStart = true;

  static public void conceptsAndBot() {
    conceptsAndBot(null);
  }

  static public void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    try {
      ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable _e) {
      db_mainConcepts().dontSave = true;
      throw rethrow(_e);
    }
    db_mainConcepts().persist(autoSaveInterval);
    dbBot();
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public String regexReplace(String s, String pat, Object f) {
    Matcher m = Pattern.compile(pat).matcher(s);
    return regexReplace(m, f);
  }

  static public String regexReplace(Matcher m, Object f) {
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, m.quoteReplacement(str(callF(f, m))));
    m.appendTail(buf);
    return str(buf);
  }

  static public String regexReplace(String s, String pat, IF1<Matcher, String> f) {
    return regexReplace(s, pat, (Object) f);
  }

  static public <A> A lookupOrKeep(Map<A, A> map, A key) {
    return map != null && map.containsKey(key) ? map.get(key) : key;
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public Random defaultRandomGenerator() {
    return ThreadLocalRandom.current();
  }

  static public Object subBot_httpd() {
    Object httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "MyHTTPD_current"));
    if (httpd == null)
      httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "WebSocketHTTPD_current"));
    return httpd;
  }

  static public String domainName() {
    Object session = call(getMainBot(), "getSession");
    Map headers = (Map) (call(session, "getHeaders"));
    String host = (String) (headers.get("host"));
    if (host == null)
      return null;
    return dropFrom(host, ":");
  }

  static public String codePointToString(int codePoint) {
    return new String(Character.toChars(codePoint));
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public SimpleDateFormat simpleDateFormat_timeZone(String format, String timeZone) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(timeZone(timeZone));
    return sdf;
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public long ipToInt(String ip) {
    Matches m = new Matches();
    assertTrue(jmatch("*.*.*.*", ip, m));
    return parseLong(m.unq(3)) | parseLong(m.unq(2)) << 8 | parseLong(m.unq(1)) << 16 | parseLong(m.unq(0)) << 24;
  }

  static public boolean directoryEmpty(File f) {
    return directoryIsEmpty(f);
  }

  static public void unzipSnippet(String snippetID, File toDir) {
    print("Unzipping snippet " + snippetID + " to " + toDir);
    zip2dir(loadLibrary(snippetID), toDir);
  }

  static public <A, B> B pairB(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public Pair<LongRange, String> binarySearchForLineInTextFile(File file, IF1<String, Integer> nav) {
    long length = l(file);
    int bufSize = 1024;
    RandomAccessFile raf = randomAccessFileForReading(file);
    try {
      long min = 0, max = length;
      int direction = 0;
      Pair<LongRange, String> possibleResult = null;
      while (min < max) {
        ping();
        long middle = (min + max) / 2;
        long lineStart = raf_findBeginningOfLine(raf, middle, bufSize);
        long lineEnd = raf_findEndOfLine(raf, middle, bufSize);
        String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (lineEnd - 1 - lineStart)));
        direction = nav.get(line);
        possibleResult = pair(new LongRange(lineStart, lineEnd), line);
        if (direction == 0)
          return possibleResult;
        if (direction < 0)
          max = assertLessThan(max, lineStart);
        else
          min = assertBiggerThan(min, lineEnd);
      }
      if (direction >= 0)
        return possibleResult;
      long lineStart = raf_findBeginningOfLine(raf, min - 1, bufSize);
      String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (min - 1 - lineStart)));
      return pair(new LongRange(lineStart, min), line);
    } finally {
      _close(raf);
    }
  }

  static public List<String> tok_splitAtComma_unquote(String s) {
    List<String> tok = javaTok(s);
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(unquote(trimJoinSubList(tok, i, j)));
      i = j;
    }
    return out;
  }

  static public long parseLongOpt(String s) {
    return isInteger(s) ? parseLong(s) : 0;
  }

  static public String regexReplaceIC(String s, String pat, Object f) {
    return regexReplace(regexpMatcherIC(pat, s), f);
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    try {
      if (classForName_cache == null)
        return Class.forName(name);
      Class c = classForName_cache.get(name);
      if (c == null)
        classForName_cache.put(name, c = Class.forName(name));
      return c;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public boolean tok_isRoundBracketed(String s) {
    List<String> tok = tok_combineRoundBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "(", ")");
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public List<String> javaTokPlusBrackets(String s) {
    return tok_combineRoundOrCurlyBrackets_keep(javaTok(s));
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public Map<String, List<String>> javaTokWithAllBrackets_cached_cache = synchronizedMRUCache(defaultTokenizerCacheSize());

  static public List<String> javaTokWithAllBrackets_cached(String s) {
    List<String> tok = javaTokWithAllBrackets_cached_cache.get(s);
    if (tok == null)
      javaTokWithAllBrackets_cached_cache.put(s, tok = javaTokWithAllBrackets(s));
    return tok;
  }

  static public List<String> splitAtTokens(String s, List<String> tokens) {
    return splitAtTokens(javaTok(s), tokens);
  }

  static public List<String> splitAtTokens(List<String> tok, List<String> tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public List<String> splitAtTokens(List<String> tok, String... tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public boolean containsSpace(String s) {
    return containsSpaces(s);
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public <A> List<A> replaceElementsUsingMap(Iterable<A> l, final Map<A, A> map) {
    return map(l, new F1<A, A>() {

      public A get(A a) {
        try {
          return getOrKeep(map, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "getOrKeep(map, a)";
      }
    });
  }

  static public List<String> splitCamelCase(String s) {
    return ai_splitCamelCase(s);
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public <A> Set<A> setMinus(Set<A> set, Object... stuff) {
    Set s2 = cloneSet(set);
    for (Object o : stuff) s2.remove(o);
    return s2;
  }

  static public <A> Set<A> mergeSets(Set<A>... l) {
    return joinSets(l);
  }

  static public Set<String> allNonStaticNonTransientFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject)
        setDyn(((DynamicObject) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public boolean setField_trueIfChanged(Field f, Object o, Object value) {
    try {
      if (eq(f.get(o), value))
        return false;
      f.set(o, value);
      return true;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isTransient(Field f) {
    return (f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) != 0;
  }

  static public boolean _csetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (value instanceof RC)
        value = c._concepts.getConcept((RC) value);
      value = deref(value);
      if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan)
        value = intern((String) value);
      if (f == null) {
        c.fieldValues = syncMapPut2_createLinkedHashMap(c.fieldValues, assertIdentifier(field), value instanceof Concept ? c.new Ref((Concept) value) : value);
        c.change();
      } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
        ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
        c.change();
        return true;
      } else if (isSubtypeOf(f.getType(), Concept.RefL.class)) {
        ((Concept.RefL) f.get(c)).replaceWithList(lmap(__53 -> derefRef(__53), (List) value));
        c.change();
        return true;
      } else {
        Object old = f.get(c);
        if (neq(value, old)) {
          f.set(c, value);
          if (!isTransient(f))
            c.change();
          return true;
        }
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public <A> boolean syncEmpty(Collection<A> l) {
    if (l == null)
      return true;
    synchronized (l) {
      return l.isEmpty();
    }
  }

  static public boolean _inCore() {
    return false;
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public AlphanumComparator alphaNumComparator_instance;

  static public Comparator<String> alphaNumComparator() {
    if (alphaNumComparator_instance == null)
      alphaNumComparator_instance = new AlphanumComparator();
    return alphaNumComparator_instance;
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public Map paramsToMap(Object... params) {
    int n = l(params);
    if (l(params) == 1 && params[0] instanceof Map)
      return (Map) params[0];
    LinkedHashMap map = new LinkedHashMap();
    for (int i = 0; i + 1 < n; i += 2) mapPut(map, params[i], params[i + 1]);
    return map;
  }

  static public <A> A[] itemPlusArray(A a, A[] l) {
    return singlePlusArray(a, l);
  }

  static public String htd(Object contents, Object... params) {
    return htag("td", contents, params);
  }

  static public Object[] changeParam(Object[] params, String name, Object value) {
    if (eq(optPar(params, name), value))
      return params;
    Map map = paramsToOrderedMap(params);
    map.put(name, value);
    return mapToParams(map);
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public List<AbstractButton> buttonsInGroup(ButtonGroup g) {
    if (g == null)
      return ll();
    return asList(g.getElements());
  }

  static public Frame getAWTFrame(final Object _o) {
    return swing(new F0<Frame>() {

      public Frame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof Frame)
              return (Frame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ...";
      }
    });
  }

  static public int imageIcon_cacheSize = 10;

  static public boolean imageIcon_verbose = false;

  static public Map<String, ImageIcon> imageIcon_cache;

  static public Lock imageIcon_lock = lock();

  static public ThreadLocal<Boolean> imageIcon_fixGIF = new ThreadLocal();

  static public ImageIcon imageIcon(String imageID) {
    try {
      if (imageID == null)
        return null;
      Lock __0 = imageIcon_lock;
      lock(__0);
      try {
        if (imageIcon_cache == null)
          imageIcon_cache = new MRUCache(imageIcon_cacheSize);
        imageID = fsI(imageID);
        ImageIcon ii = imageIcon_cache.get(imageID);
        if (ii == null) {
          if (imageIcon_verbose)
            print("Loading image icon: " + imageID);
          File f = loadBinarySnippet(imageID);
          Boolean b = imageIcon_fixGIF.get();
          if (!isFalse(b))
            ii = new ImageIcon(loadBufferedImageFixingGIFs(f));
          else
            ii = new ImageIcon(f.toURI().toURL());
        } else
          imageIcon_cache.remove(imageID);
        imageIcon_cache.put(imageID, ii);
        return ii;
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(File f) {
    try {
      return new ImageIcon(f.toURI().toURL());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(Image img) {
    return new ImageIcon(img);
  }

  static public ImageIcon imageIcon(RGBImage img) {
    return imageIcon(img.getBufferedImage());
  }

  static public void swingLater(long delay, final Object r) {
    javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
    timer.setRepeats(false);
    timer.start();
  }

  static public void swingLater(Object r) {
    SwingUtilities.invokeLater(toRunnable(r));
  }

  static public void standardTitlePopupMenu(final JFrame frame) {
    if (!isSubstanceLAF())
      return;
    titlePopupMenu(frame, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          boolean alwaysOnTop = frame.isAlwaysOnTop();
          menu.add(jmenuItem("Restart Program", "restart"));
          menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
          menu.add(jmenuItem("Show Console", "showConsole"));
          menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() {

            public void run() {
              try {
                toggleAlwaysOnTop(frame);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "toggleAlwaysOnTop(frame)";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n    ifndef standardTitlePopupMenu_...";
      }
    });
  }

  static public <A extends Component> A _recordNewSwingComponent(A c) {
    if (c != null)
      callF((Object) vm_generalMap_get("newSwingComponentRegistry"), (Object) c);
    return c;
  }

  static public JComponent componentToJComponent(Component c) {
    if (c instanceof JComponent)
      return (JComponent) c;
    if (c instanceof JFrame)
      return ((JFrame) c).getRootPane();
    if (c == null)
      return null;
    throw fail("boohoo " + getClassName(c));
  }

  static public JScrollPane jscroll(final Component c) {
    return swing(new F0<JScrollPane>() {

      public JScrollPane get() {
        try {
          return new JScrollPane(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JScrollPane(c);";
      }
    });
  }

  static public JLabel jlabel(final String text) {
    return swingConstruct(BetterLabel.class, text);
  }

  static public JLabel jlabel() {
    return jlabel(" ");
  }

  static public Rectangle screenRectangle() {
    return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
  }

  static public Rectangle screenRectangle(GraphicsDevice device) {
    if (device == null)
      return null;
    DisplayMode mode = device.getDisplayMode();
    return new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
  }

  static public Random random_random = new Random();

  static public int random(int n) {
    return random(random_random, n);
  }

  static public int random(int n, Random r) {
    return random(r, n);
  }

  static public int random(Random r, int n) {
    return n <= 0 ? 0 : r.nextInt(n);
  }

  static public double random(double max) {
    return random() * max;
  }

  static public double random() {
    return random_random.nextInt(100001) / 100000.0;
  }

  static public double random(double min, double max) {
    return min + random() * (max - min);
  }

  static public int random(int min, int max) {
    return min + random(max - min);
  }

  static public int random(int min, int max, Random r) {
    return random(r, min, max);
  }

  static public int random(Random r, int min, int max) {
    return min + random(r, max - min);
  }

  static public <A> A random(List<A> l) {
    return oneOf(l);
  }

  static public <A> A random(Collection<A> c) {
    if (c instanceof List)
      return random((List<A>) c);
    int i = random(l(c));
    return collectionGet(c, i);
  }

  static public int random(IntRange r) {
    return random(r.start, r.end);
  }

  static public JFrame consoleFrame() {
    return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
  }

  static public void autoVMExit() {
    call(getJavaX(), "autoVMExit");
  }

  static public Runnable _topLevelErrorHandling(final Runnable runnable) {
    final Object info = _threadInfo();
    return new Runnable() {

      public void run() {
        try {
          try {
            _threadInheritInfo(info);
            runnable.run();
          } catch (Throwable __e) {
            _handleException(__e);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcall {\r\n      _threadInheritInfo(info);\r\n      runnable.run();\r\n    }";
      }
    };
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public String htitle_noEncode(String title) {
    return tag("title", title);
  }

  static public String dropTags(String html) {
    return dropAllTags(html);
  }

  static public List<String> dropTags(List<String> tok) {
    return dropAllTags(tok);
  }

  static public String stringOptPar(Object[] params, String name) {
    return (String) optPar(params, name);
  }

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isAbsolutePath(snippetIDOrURLOrFile))
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
      if (!isSnippetID(snippetIDOrURLOrFile))
        throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
      String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return loadBufferedImage(rl.loadLibrary(snippetID));
      File dir = imageSnippetsCacheDir();
      if (loadBufferedImage_useImageCache) {
        dir.mkdirs();
        File file = new File(dir, snippetID + ".png");
        if (file.exists() && file.length() != 0)
          try {
            return ImageIO.read(file);
          } catch (Throwable e) {
            e.printStackTrace();
          }
      }
      String imageURL = snippetImageURL_http(snippetID);
      print("Loading image: " + imageURL);
      BufferedImage image = imageIO_readURL(imageURL);
      if (loadBufferedImage_useImageCache) {
        File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
        ImageIO.write(image, "png", tempFile);
        tempFile.renameTo(new File(dir, snippetID + ".png"));
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    try {
      return file.isFile() ? ImageIO.read(file) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return mapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public void duplicateThisProgram() {
    nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
  }

  static public void showConsole() {
    callOpt(get(javax(), "console"), "showConsole");
  }

  static public <A, B> Map<A, B> weakHashMap() {
    return newWeakHashMap();
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  static public Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  static public boolean isString(Object o) {
    return o instanceof String;
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public Object dm_getService(String serviceName) {
    return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
  }

  static public boolean isStringOrIntOrLong(Object o) {
    return o instanceof String || o instanceof Integer || o instanceof Long;
  }

  static public Object dm_callOS(String functionName, Object... args) {
    return call(dm_os(), functionName, args);
  }

  static public Object dm_resolveModule(Object moduleOrStem) {
    return dm_callOS("resolveModule", moduleOrStem);
  }

  static public boolean hasSuperclassShortNamed(Object o, String name) {
    Class c = _getClass(o);
    while (c != null) if (shortClassNameIs(c, name))
      return true;
    else
      c = c.getSuperclass();
    return false;
  }

  static public List<String> dm_moduleIDs() {
    return dm_listModuleIDs();
  }

  static public Object dm_getStem(Object moduleOrID) {
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      moduleOrID = dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_getStemByID(moduleOrID);
    return or(getOpt(dm_getModule(moduleOrID), "_host"), moduleOrID);
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  static public File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public String tb_mainServer_default = "http://code.botcompany.de:8081";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String formatDate() {
    return formatDate(now());
  }

  static public String formatDate(long timestamp) {
    return timestamp == 0 ? "-" : str(new Date(timestamp));
  }

  static public String formatDate(long timestamp, String format, TimeZone tz) {
    return simpleDateFormat(format, tz).format(timestamp);
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public boolean isOpeningTag(String token, String tag) {
    return isTag(token, tag) && !token.endsWith("/>");
  }

  static public boolean isOpeningTag(String token) {
    return token.startsWith("<") && token.endsWith(">") && !token.endsWith("/>") && isLetter(token.charAt(1));
  }

  static public boolean isTag(String token, String tag) {
    return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length() + 2) || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length() + 2);
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public Object subBot_serveByteArray(byte[] data, String mimeType) {
    return call(mainBot(), "serveByteArray", data, mimeType);
  }

  static public boolean isStringStartingWith(Object o, String prefix) {
    return o instanceof String && ((String) o).startsWith(prefix);
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public boolean jsonDecode_useOrderedMaps = true;

  static public Object jsonDecode(final String text) {
    final List<String> tok = jsonTok(text);
    if (l(tok) == 1)
      return null;
    class Y {

      public int i = 1;

      public Object parse() {
        String t = tok.get(i);
        if (t.startsWith("\"") || t.startsWith("'")) {
          String s = unquote(tok.get(i));
          i += 2;
          return s;
        }
        if (t.equals("{"))
          return parseMap();
        if (t.equals("["))
          return this.parseList();
        if (t.equals("null")) {
          i += 2;
          return null;
        }
        if (t.equals("false")) {
          i += 2;
          return false;
        }
        if (t.equals("true")) {
          i += 2;
          return true;
        }
        boolean minus = false;
        if (t.equals("-")) {
          minus = true;
          i += 2;
          t = get(tok, i);
        }
        if (isInteger(t)) {
          int j = i;
          i += 2;
          if (eqOneOf(get(tok, i), ".", "e", "E")) {
            while (isInteger(get(tok, i)) || eqOneOf(get(tok, i), ".", "e", "E", "-")) i += 2;
            double d = parseDouble(joinSubList(tok, j, i - 1));
            if (minus)
              d = -d;
            return d;
          } else {
            long l = parseLong(t);
            if (minus)
              l = -l;
            return l != (int) l ? (Object) new Long(l) : new Integer((int) l);
          }
        }
        throw new RuntimeException("Unknown token " + (i + 1) + ": " + t + ": " + text);
      }

      public Object parseList() {
        consume("[");
        List list = new ArrayList();
        while (!tok.get(i).equals("]")) {
          list.add(parse());
          if (tok.get(i).equals(","))
            i += 2;
        }
        consume("]");
        return list;
      }

      public Object parseMap() {
        consume("{");
        Map map = jsonDecode_useOrderedMaps ? new LinkedHashMap() : new TreeMap();
        while (!tok.get(i).equals("}")) {
          String key = unquote(tok.get(i));
          i += 2;
          consume(":");
          Object value = parse();
          map.put(key, value);
          if (tok.get(i).equals(","))
            i += 2;
        }
        consume("}");
        return map;
      }

      public void consume(String s) {
        if (!tok.get(i).equals(s)) {
          String prevToken = i - 2 >= 0 ? tok.get(i - 2) : "";
          String nextTokens = join(tok.subList(i, Math.min(i + 4, tok.size())));
          throw fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");
        }
        i += 2;
      }
    }
    return new Y().parse();
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public <A, B> void mapPut_noOverwrite(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null && !map.containsKey(key))
      map.put(key, value);
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    final BufferedReader br = bufferedReader(r);
    return iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r));
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public String hijackPrint(Object r) {
    final StringBuilder buf = new StringBuilder();
    Object old = interceptPrintInThisThread(new F1<String, Boolean>() {

      public Boolean get(String s) {
        buf.append(s);
        return false;
      }
    });
    try {
      callF(r);
      return str(buf);
    } finally {
      interceptPrintInThisThread(old);
    }
  }

  static public <A extends Iterable> A pnl(String prefix, A l) {
    printNumberedLines(prefix, l);
    return l;
  }

  static public <A extends Iterable> A pnl(A l) {
    printNumberedLines(l);
    return l;
  }

  static public <A extends Map> A pnl(A map) {
    printNumberedLines(map);
    return map;
  }

  static public <A extends Map> A pnl(String prefix, A map) {
    printNumberedLines(prefix, map);
    return map;
  }

  static public <A> A[] pnl(A[] a) {
    printNumberedLines(a);
    return a;
  }

  static public String pnl(String s) {
    printNumberedLines(lines(s));
    return s;
  }

  static public <A> MultiSet<A> pnl(MultiSet<A> ms) {
    pnl(ms == null ? null : ms.asMap());
    return ms;
  }

  static public <A, B> Map<A, List<B>> multiMapToMap(MultiMap<A, B> m) {
    return m == null ? null : m.data;
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public boolean eqicOrEq(Object a, Object b) {
    return a instanceof String && b instanceof String ? eqic((String) a, (String) b) : eq(a, b);
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A findWhere(Collection<A> c, Object... data) {
    if (c != null)
      for (A x : c) if (checkFields(x, data))
        return x;
    return null;
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public String jsonEncode_breakAtLevel1(Object o) {
    StringBuilder buf = new StringBuilder();
    jsonEncode_breakAtLevel1(o, buf, 1);
    return str(buf);
  }

  static public void jsonEncode_breakAtLevel1(Object o, StringBuilder buf, int level) {
    if (o == null)
      buf.append("null");
    else if (o instanceof String)
      buf.append(quote((String) o));
    else if (o instanceof Number || o instanceof Boolean)
      buf.append(o);
    else if (o instanceof Map) {
      Map map = (Map) o;
      buf.append("{");
      boolean first = true;
      for (Object key : keys(map)) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n  ");
        buf.append(quote((String) key));
        buf.append(":");
        jsonEncode_breakAtLevel1(map.get(key), buf, level + 1);
      }
      if (level == 1)
        buf.append("\n");
      buf.append("}");
    } else if (o instanceof Collection) {
      Collection l = (Collection) o;
      buf.append("[");
      boolean first = true;
      for (Object element : l) {
        if (first)
          first = false;
        else
          buf.append(",");
        if (level == 1)
          buf.append("\n  ");
        jsonEncode_breakAtLevel1(element, buf, level + 1);
      }
      if (level == 1)
        buf.append("\n");
      buf.append("]");
    } else
      throw fail("Unknown object for JSON encoding: " + className(o));
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public Map<String, java.util.regex.Pattern> compileRegexpIC_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexpIC(String pat) {
    java.util.regex.Pattern p = compileRegexpIC_cache.get(pat);
    if (p == null) {
      try {
        compileRegexpIC_cache.put(pat, p = java.util.regex.Pattern.compile(pat, Pattern.CASE_INSENSITIVE));
      } catch (PatternSyntaxException e) {
        throw rethrow(wrapPatternSyntaxException(e));
      }
    }
    return p;
  }

  static public boolean startsWithLetterOrDigit(String s) {
    return nempty(s) && Character.isLetterOrDigit(s.charAt(0));
  }

  static public String regexpQuote(String s) {
    return s.length() == 0 ? "" : Pattern.quote(s);
  }

  static public Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  static public List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  static synchronized public List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  static public <A> List<A> takeLast(List<A> l, int n) {
    return newSubList(l, l(l) - n);
  }

  static public <A> List<A> takeLast(int n, List<A> l) {
    return takeLast(l, n);
  }

  static public String takeLast(int n, String s) {
    return substring(s, l(s) - n);
  }

  static public String takeLast(String s, int n) {
    return substring(s, l(s) - n);
  }

  static public String[] find2(List<String> pat, List<String> tok) {
    for (int idx = 0; idx < tok.size(); idx += 2) {
      String[] result = find2(pat, tok, idx);
      if (result != null)
        return result;
    }
    return null;
  }

  static public String[] find2(List<String> pat, List<String> tok, int idx) {
    if (idx + pat.size() > tok.size())
      return null;
    List<String> result = new ArrayList();
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(idx + i);
      if (eq(p, "*"))
        result.add(t);
      else if (!p.equalsIgnoreCase(t))
        return null;
    }
    return toStringArray(result);
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  static public void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  static public String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  static volatile public Android3 dbBot_instance;

  static public Android3 dbBot() {
    return dbBot(dbBotStandardName());
  }

  static public Android3 dbBot(String name) {
    ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  static public void thinAProgramsBackups(String progID, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
    File dir = programDir(progID);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      java.util.regex.Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      long time = timestampFromYMDH(year, month, day, hour);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  static public boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  static public String dropFrom(String s, String x) {
    if (s == null)
      return null;
    int i = s.indexOf(x);
    if (i < 0)
      return s;
    return substring(s, 0, i);
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public boolean directoryIsEmpty(File f) {
    return !fileExists(f) || isDirectory(f) && empty(listFiles(f));
  }

  static public void zip2dir(File inZip, File outDir) {
    zip2dir(inZip, outDir, "");
  }

  static public void zip2dir(File inZip, File outDir, String prefix) {
    try {
      if (prefix.length() != 0 && !prefix.endsWith("/"))
        prefix += "/";
      ZipFile zipFile = new ZipFile(inZip);
      try {
        Enumeration entries = zipFile.entries();
        while (entries.hasMoreElements()) {
          ZipEntry entry = (ZipEntry) entries.nextElement();
          if (entry.isDirectory())
            continue;
          if (!entry.getName().startsWith(prefix))
            continue;
          File outFile = new File(outDir, entry.getName());
          System.out.println("Unzipping " + entry.getName() + " to " + outFile.getAbsolutePath());
          stream2file(zipFile.getInputStream(entry), outFile);
        }
      } finally {
        _close(zipFile);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public RandomAccessFile randomAccessFileForReading(File path) {
    try {
      return newRandomAccessFile(path, "r");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long raf_findBeginningOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      while (pos > 0) {
        long start = Math.max(pos - bufSize, 0);
        raf.seek(start);
        raf.readFully(buf, 0, (int) Math.min(pos - start, bufSize));
        int idx = lastIndexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return start + idx + 1;
        pos = start;
      }
      return 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long raf_findEndOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      long length = raf.length();
      while (pos < length) {
        raf.seek(pos);
        raf.readFully(buf, 0, (int) Math.min(length - pos, bufSize));
        int idx = indexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return pos + idx + 1;
        pos += bufSize;
      }
      return length;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] raf_readFilePart(RandomAccessFile raf, long start, int l) {
    try {
      byte[] buf = new byte[l];
      raf.seek(start);
      raf.readFully(buf);
      return buf;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A assertLessThan(A a, A b) {
    assertTrue(cmp(b, a) < 0);
    return b;
  }

  static public <A> A assertBiggerThan(A a, A b) {
    assertTrue(cmp(b, a) > 0);
    return b;
  }

  static public String trimJoinSubList(List<String> l, int i, int j) {
    return trim(join(subList(l, i, j)));
  }

  static public String trimJoinSubList(List<String> l, int i) {
    return trim(join(subList(l, i)));
  }

  static public Matcher regexpMatcherIC(String pat, String s) {
    return compileRegexpIC(pat).matcher(unnull(s));
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public List<String> tok_combineRoundBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public List<String> tok_combineRoundOrCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public int defaultTokenizerCacheSize() {
    return 1000;
  }

  static public List<String> javaTokWithAllBrackets(String s) {
    return javaTokPlusBrackets2(s);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public String trimJoin(List<String> s) {
    return trim(join(s));
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public boolean containsSpaces(String s) {
    return indexOf(s, ' ') >= 0;
  }

  static public List<String> ai_splitCamelCase(String s) {
    int j = 0;
    List<String> l = new ArrayList();
    if (isAllUpperCase(s)) {
      l.add(s);
      return l;
    }
    for (int i = 0; i < l(s); i++) if (i > j && isUpperCaseLetter(s.charAt(i))) {
      l.add(substring(s, j, i));
      j = i;
    }
    if (j < l(s))
      l.add(substring(s, j));
    return l;
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public <A> Set<A> cloneSet(Set<A> set) {
    if (set == null)
      return new HashSet();
    synchronized (collectionMutex(set)) {
      Set<A> s = similarEmptySet(set);
      s.addAll(set);
      return s;
    }
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    String firstToken = tokens[0];
    if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
      while (i < end && !firstToken.equals(tok.get(i))) i += 2;
    }
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else
        matcher = t -> t.equals(p);
      matchers[j] = matcher;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    if (o == null)
      return o;
    setDynObjectValue(o, key, value);
    return o;
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  static public Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public <A> A[] singlePlusArray(A a, A[] l) {
    A[] out = newObjectArrayOfSameType(l, l(l) + 1);
    out[0] = a;
    arraycopy(l, 0, out, 1, l(l));
    return out;
  }

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public String getSnippetTitleOpt(String s) {
    return isSnippetID(s) ? getSnippetTitle(s) : s;
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public boolean loadBufferedImageFixingGIFs_debug = false;

  static public ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

  static public Image loadBufferedImageFixingGIFs(File file) {
    try {
      if (!file.exists())
        return null;
      if (!isGIF(file))
        return ImageIO.read(file);
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": checking gif");
      ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
      reader.setInput(ImageIO.createImageInputStream(file));
      int numImages = reader.getNumImages(true);
      IIOMetadata imageMetaData = reader.getImageMetadata(0);
      String metaFormatName = imageMetaData.getNativeMetadataFormatName();
      boolean foundBug = false;
      for (int i = 0; i < numImages && !foundBug; i++) {
        IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
        int nNodes = root.getLength();
        for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
            String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
            if (Integer.parseInt(delay) == 0) {
              foundBug = true;
            }
            break;
          }
        }
      }
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
      Image image;
      if (!foundBug) {
        image = Toolkit.getDefaultToolkit().createImage(f2s(file));
      } else {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        {
          ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
          try {
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; i++) {
              BufferedImage frameIn = reader.read(i);
              IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
              int nNodes = root.getLength();
              for (int j = 0; j < nNodes; j++) {
                org.w3c.dom.Node node = root.item(j);
                if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
                  if (Integer.parseInt(delay) == 0) {
                    ((IIOMetadataNode) node).setAttribute("delayTime", "10");
                  }
                  break;
                }
              }
              IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
              metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
              IIOImage frameOut = new IIOImage(frameIn, null, metadata);
              writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
          } finally {
            _close(ios);
          }
        }
        byte[] data = baoStream.toByteArray();
        setVar(loadBufferedImageFixingGIFs_output.get(), data);
        if (loadBufferedImageFixingGIFs_debug)
          print("Data size: " + l(data));
        image = Toolkit.getDefaultToolkit().createImage(data);
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ActionListener actionListener(final Object runnable) {
    return actionListener(runnable, null);
  }

  static public ActionListener actionListener(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    final Object info = _threadInfo();
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          _threadInheritInfo(info);
          AutoCloseable __1 = holdInstance(instanceToHold);
          try {
            callF(runnable);
          } finally {
            _close(__1);
          }
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public boolean isSubstanceLAF() {
    return substanceLookAndFeelEnabled();
  }

  static public boolean titlePopupMenu(final Component c, final Object menuMaker) {
    JComponent titleBar = getTitlePaneComponent(getPossiblyInternalFrame(c));
    if (titleBar == null) {
      print("Can't add title right click!");
      return false;
    } else {
      componentPopupMenu(titleBar, menuMaker);
      return true;
    }
  }

  static public boolean jmenuItem_newThreads = false;

  static public JMenuItem jmenuItem(final String text) {
    return jMenuItem(text, null);
  }

  static public JMenuItem jmenuItem(final String text, final Object r) {
    return swing(new F0<JMenuItem>() {

      public JMenuItem get() {
        try {
          Pair<String, Integer> p = jmenu_autoMnemonic(dropPrefix("[disabled] ", text));
          JMenuItem mi = new JMenuItem(p.a);
          if (startsWith(text, "[disabled] "))
            disableMenuItem(mi);
          if (p.b != 0)
            mi.setMnemonic(p.b);
          mi.addActionListener(jmenuItem_newThreads ? actionListenerInNewThread(r) : actionListener(r));
          return mi;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Pair<S, Int> p = jmenu_autoMnemonic(dropPrefix(\"[disabled] \", text));\r\n    JM...";
      }
    });
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
    final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text, checked);
    addActionListener(mi, new Runnable() {

      public void run() {
        try {
          callF(r, isChecked(mi));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, isChecked(mi))";
      }
    });
    return mi;
  }

  static public void toggleAlwaysOnTop(JFrame frame) {
    frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
  }

  static public <A> A swingConstruct(final Class<A> c, final Object... args) {
    return swing(new F0<A>() {

      public A get() {
        try {
          return nuObject(c, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret nuObject(c, args);";
      }
    });
  }

  static public <A> A oneOf(List<A> l) {
    return empty(l) ? null : l.get(new Random().nextInt(l.size()));
  }

  static public char oneOf(String s) {
    return empty(s) ? '?' : s.charAt(random(l(s)));
  }

  static public String oneOf(String... l) {
    return oneOf(asList(l));
  }

  static public <A> A collectionGet(Collection<A> c, int idx) {
    if (c == null || idx < 0 || idx >= l(c))
      return null;
    if (c instanceof List)
      return listGet((List<A>) c, idx);
    Iterator<A> it = c.iterator();
    for (int i = 0; i < idx; i++) if (it.hasNext())
      it.next();
    else
      return null;
    return it.hasNext() ? it.next() : null;
  }

  static public List<String> dropAllTags(List<String> tok) {
    List<String> list = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && t.startsWith("<")) {
        list.set(list.size() - 1, list.get(list.size() - 1) + tok.get(i + 1));
        ++i;
      } else
        list.add(t);
    }
    return list;
  }

  static public String dropAllTags(String html) {
    return join(dropAllTags(htmlcoarsetok(html)));
  }

  static public BufferedImage imageIO_readURL(String url) {
    try {
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isAbsolutePath(String s) {
    return s != null && new File(s).isAbsolute();
  }

  static public boolean isAbsolutePath(File f) {
    return f != null && f.isAbsolute();
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  static public <A, B> B mapGet2(Map<A, B> map, A a) {
    return map == null ? null : map.get(a);
  }

  static public <A, B> B mapGet2(A a, Map<A, B> map) {
    return map == null ? null : map.get(a);
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public void nohupJavax(final String javaxargs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs);";
        }
      });
    }
  }

  static public void nohupJavax(final String javaxargs, final String vmArgs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs, vmArgs);";
        }
      });
    }
  }

  static public String smartJoin(String[] args) {
    if (empty(args))
      return "";
    if (args.length == 1)
      return args[0];
    String[] a = new String[args.length];
    for (int i = 0; i < a.length; i++) a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
    return join(" ", a);
  }

  static public String smartJoin(List<String> args) {
    return smartJoin(toStringArray(args));
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      Object __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public Object dm_os() {
    {
      Object __1 = vm_generalMap_get("stefansOS");
      if (__1 != null)
        return __1;
    }
    return creator();
  }

  static public boolean shortClassNameIs(Object o, String name) {
    return eq(shortClassName(o), name);
  }

  static public boolean shortClassNameIs(String name, Object o) {
    return shortClassNameIs(o, name);
  }

  static public List<String> dm_listModuleIDs() {
    return map("dm_moduleID", dm_listStems());
  }

  static public Object dm_getStemByID(Object id) {
    return dm_callOS("getModuleByID", str(id));
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPageThroughProxy_enabled) {
          print("Trying proxy because of: " + e);
          try {
            return loadPageThroughProxy(str(url));
          } catch (Throwable e2) {
            print("  " + exceptionToStringShort(e2));
          }
        } else if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    Long limit = optPar(loadPage_sizeLimit);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      boolean silent = isTrue(loadPage_silent.get());
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (limit == null || n < limit) {
        ping();
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if (!silent && (n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public <A> A println(A a) {
    return print(a);
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void renameFile_assertTrue(File a, File b) {
    try {
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public List<String> jsonTok(String s) {
    List<String> tok = new ArrayList();
    int l = l(s);
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isLetter(c))
        do ++j; while (j < l && Character.isLetter(s.charAt(j)));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public void printNumberedLines(Map map) {
    printNumberedLines(mapToLines(map));
  }

  static public void printNumberedLines(String prefix, Map map) {
    printNumberedLines(prefix, mapToLines(map));
  }

  static public <A extends Iterable> A printNumberedLines(A l) {
    int i = 0;
    if (l != null)
      for (Object a : l) print((++i) + ". " + str(a));
    return l;
  }

  static public <A extends Iterable> A printNumberedLines(String prefix, A l) {
    int i = 0;
    if (l != null)
      for (Object a : l) print(prefix + (++i) + ". " + str(a));
    return l;
  }

  static public void printNumberedLines(Object[] l) {
    printNumberedLines(asList(l));
  }

  static public void printNumberedLines(Object o) {
    printNumberedLines(lines(str(o)));
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public boolean checkFields(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  static public RuntimeException wrapPatternSyntaxException(PatternSyntaxException e) {
    if (e == null)
      return null;
    String pat = e.getPattern();
    int i = e.getIndex();
    return new RuntimeException("Regular expression error between " + multiLineQuoteWithSpaces(substring(pat, 0, i)) + " and " + multiLineQuoteWithSpaces(substring(pat, i)) + " - " + e.getMessage());
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public List<String> dropPunctuation_keep = ll("*", "<", ">");

  static public List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  static public String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  static public String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  static public boolean isMainProgram() {
    return creator() == null;
  }

  static public void cleanKill() {
    cleanKillVM();
  }

  static public String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  static public List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  static public List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  static public List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  static public List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  static public int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  static public long timestampFromYMDH(int y, int m, int d, int h) {
    return new GregorianCalendar(y, m - 1, d, h, 0).getTimeInMillis();
  }

  static public <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  static public boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 0.5)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age <= 28 && age >= lastAge + 7)
      return true;
    if (age >= lastAge + 365.0 / 12)
      return true;
    return false;
  }

  static public boolean isDirectory(File f) {
    return f != null && f.isDirectory();
  }

  static public boolean isDirectory(String path) {
    return path != null && isDirectory(newFile(path));
  }

  static public File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  static public File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  static public void stream2file(InputStream in, File out) {
    try {
      mkdirsForFile(out);
      FileOutputStream fos = new FileOutputStream(out);
      copyStream(in, fos);
      in.close();
      fos.close();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public RandomAccessFile newRandomAccessFile(File path, String mode) {
    try {
      boolean forWrite = mode.indexOf('w') >= 0;
      if (forWrite)
        mkdirsForFile(path);
      RandomAccessFile f = new RandomAccessFile(path, mode);
      callJavaX("registerIO", f, path, forWrite);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int lastIndexOf_byteArray(byte[] a, byte b) {
    for (int i = l(a) - 1; i >= 0; i--) if (a[i] == b)
      return i;
    return -1;
  }

  static public int indexOf_byteArray(byte[] a, byte b) {
    int n = l(a);
    for (int i = 0; i < n; i++) if (a[i] == b)
      return i;
    return -1;
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public int findEndOfBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "("))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public List<String> javaTokPlusBrackets2(String s) {
    return tok_combineRoundCurlySquareBrackets_keep(javaTok(s));
  }

  static public boolean isAllUpperCase(String s) {
    return hasLettersAllUpperCase(s);
  }

  static public boolean isUpperCaseLetter(char c) {
    return Character.isUpperCase(c);
  }

  static public Set similarEmptySet(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeSet(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public Set similarEmptySet(Map m) {
    if (m instanceof TreeMap)
      return new TreeSet(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    o.fieldValues = syncMapPut2_createLinkedHashMap(o.fieldValues, field, value);
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public String getSnippetTitle(String id) {
    try {
      if (id == null)
        return null;
      if (!isSnippetID(id))
        return "?";
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.getSnippetTitle(id);
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public byte[] isGIF_magic = bytesFromHex("47494638");

  static public boolean isGIF(byte[] data) {
    return byteArrayStartsWith(data, isGIF_magic);
  }

  static public boolean isGIF(File f) {
    return isGIF(loadBeginningOfBinaryFile(f, l(isGIF_magic)));
  }

  static public <A> void setVar(IVar<A> v, A value) {
    if (v != null)
      v.set(value);
  }

  static public ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

  static public AutoCloseable holdInstance(Object o) {
    if (o == null)
      return null;
    listThreadLocalAdd(holdInstance_l, o);
    return new AutoCloseable() {

      public void close() {
        listThreadLocalPopLast(holdInstance_l);
      }
    };
  }

  static public void messageBox(final String msg) {
    if (headless())
      print(msg);
    else {
      swing(new Runnable() {

        public void run() {
          try {
            JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MES...";
        }
      });
    }
  }

  static public void messageBox(Throwable e) {
    printStackTrace(e);
    messageBox(hideCredentials(innerException2(e)));
  }

  static public boolean substanceLookAndFeelEnabled() {
    return startsWith(getLookAndFeel(), "org.pushingpixels.");
  }

  static public JComponent getTitlePaneComponent(RootPaneContainer window) {
    if (window instanceof JInternalFrame)
      return getInternalFrameTitlePaneComponent((JInternalFrame) window);
    if (!substanceLookAndFeelEnabled() || window == null)
      return null;
    JRootPane rootPane = window.getRootPane();
    if (rootPane != null) {
      Object ui = rootPane.getUI();
      return (JComponent) call(ui, "getTitlePane");
    }
    return null;
  }

  static public RootPaneContainer getPossiblyInternalFrame(Component c) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      return f;
    return optCast(RootPaneContainer.class, getWindow(c));
  }

  static public JMenuItem jMenuItem(final String text) {
    return jmenuItem(text);
  }

  static public JMenuItem jMenuItem(String text, Object r) {
    return jmenuItem(text, r);
  }

  static public Pair<String, Integer> jmenu_autoMnemonic(String s) {
    int i = indexOf(s, '&');
    if (i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i + 1)))
      return pair(substring(s, 0, i) + substring(s, i + 1), (int) s.charAt(i + 1));
    return pair(s, 0);
  }

  static public JMenuItem disableMenuItem(final JMenuItem mi) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setEnabled(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setEnabled(false);";
        }
      });
    }
    return mi;
  }

  static public ActionListener actionListenerInNewThread(final Object runnable) {
    return actionListenerInNewThread(runnable, null);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          startThread("Action Listener", new Runnable() {

            public void run() {
              try {
                AutoCloseable __1 = holdInstance(instanceToHold);
                try {
                  callF(runnable);
                } finally {
                  _close(__1);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1 = holdInstance(instanceToHold); try {\r\n      callF(runnable...";
            }
          });
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public void addActionListener(JTextField tf, final Runnable action) {
    onEnter(tf, action);
  }

  static public void addActionListener(final JComboBox cb, final Runnable action) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public void addActionListener(final AbstractButton b, final Runnable action) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            b.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public boolean isChecked(final JCheckBox checkBox) {
    return checkBox != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return checkBox.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret checkBox.isSelected();";
      }
    });
  }

  static public boolean isChecked(final JCheckBoxMenuItem mi) {
    return mi != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return mi.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mi.isSelected();";
      }
    });
  }

  static public <A> A listGet(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        Object __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      Object __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public WeakReference<Object> creator_class;

  static public Object creator() {
    return creator_class == null ? null : creator_class.get();
  }

  static public List dm_listStems() {
    return (List) dm_callOS("onModules");
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static final public boolean loadPageThroughProxy_enabled = false;

  static public String loadPageThroughProxy(String url) {
    return null;
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    UnknownHostException lastException = null;
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      try {
        if (con instanceof HttpURLConnection)
          if (((HttpURLConnection) con).getResponseCode() == 500)
            throw new IOException(joinNemptiesWithColonSpace("Server code 500", tryToReadErrorStreamFromURLConnection(((HttpURLConnection) con))));
        return con.getInputStream();
      } catch (UnknownHostException e) {
        lastException = e;
        print("Retrying because of: " + e);
        continue;
      }
    }
    throw lastException;
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public byte[] utf8(String s) {
    return toUtf8(s);
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public int roundDownTo(int n, int x) {
    return x / n * n;
  }

  static public long roundDownTo(long n, long x) {
    return x / n * n;
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public String multiLineQuoteWithSpaces(String s) {
    return multiLineQuote(" " + s + " ");
  }

  static public List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  static public void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  static public String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  static public boolean exposeMethods2_debug = false;

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  static public int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  static public Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  static public Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  static public Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  static public List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  static public List<File> listFilesOnly(File... dirs) {
    return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    dest.addAll(src);
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public List<String> tok_combineRoundCurlySquareBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(", "[")) {
        int j = findEndOfBracketPart2(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public boolean hasLettersAllUpperCase(String s) {
    return hasLetters(s) && !containsLowerCase(s);
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  static public boolean byteArrayStartsWith(byte[] a, byte[] b) {
    if (a == null || b == null)
      return false;
    if (a.length < b.length)
      return false;
    for (int i = 0; i < b.length; i++) if (a[i] != b[i])
      return false;
    return true;
  }

  static public byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
    return loadBinaryFilePart(file, 0, maxBytes);
  }

  static public <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
    List<A> l = tl.get();
    if (l == null)
      tl.set(l = new ArrayList());
    l.add(a);
  }

  static public <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
    List<A> l = tl.get();
    if (l == null)
      return null;
    A a = popLast(l);
    if (empty(l))
      tl.set(null);
    return a;
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public String getLookAndFeel() {
    return getClassName(UIManager.getLookAndFeel());
  }

  static public JComponent getInternalFrameTitlePaneComponent(JInternalFrame f) {
    return (JComponent) childWithClassNameEndingWith(f, "InternalFrameTitlePane");
  }

  static public JInternalFrame getInternalFrame(final Object _o) {
    return _o == null ? null : swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JInternalFrame)
              return (JInternalFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public Window getWindow(Object o) {
    if (!(o instanceof Component))
      return null;
    Component c = (Component) o;
    while (c != null) {
      if (c instanceof Window)
        return (Window) c;
      c = c.getParent();
    }
    return null;
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public JTextField onEnter(final JTextField tf, final Object action) {
    if (action == null || tf == null)
      return tf;
    tf.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          tf.selectAll();
          callF(action);
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    });
    return tf;
  }

  static public JButton onEnter(JButton btn, final Object action) {
    if (action == null || btn == null)
      return btn;
    btn.addActionListener(actionListener(action));
    return btn;
  }

  static public JList onEnter(JList list, Object action) {
    list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
    return list;
  }

  static public JComboBox onEnter(final JComboBox cb, final Object action) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (cb.isEditable()) {
              JTextField text = (JTextField) cb.getEditor().getEditorComponent();
              onEnter(text, action);
            } else {
              cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
              cb.getActionMap().put("enter", abstractAction("", new Runnable() {

                public void run() {
                  try {
                    cb.hidePopup();
                    callF(action);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "cb.hidePopup(); callF(action);";
                }
              }));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (cb.isEditable()) {\r\n      JTextField text = (JTextField) cb.getEditor().g...";
        }
      });
    }
    return cb;
  }

  static public JTable onEnter(final JTable table, final Object action) {
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    table.getActionMap().put("Enter", new AbstractAction() {

      public void actionPerformed(ActionEvent e) {
        callF(action, table.getSelectedRow());
      }
    });
    return table;
  }

  static public JTextField onEnter(Object action, JTextField tf) {
    return onEnter(tf, action);
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  static public Lock hotwireCached_lock = lock();

  static public Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  static public Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  static public Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __0 = hotwireCached_lock;
    lock(__0);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__0);
    }
  }

  static volatile public Object isAllowed_function;

  static volatile public boolean isAllowed_all = true;

  static public boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public String hmsWithColons() {
    return hmsWithColons(now());
  }

  static public String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public String joinNemptiesWithColonSpace(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColonSpace(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public String tryToReadErrorStreamFromURLConnection(URLConnection conn) {
    try {
      if (conn instanceof HttpURLConnection)
        return stream2string(((HttpURLConnection) conn).getErrorStream());
      return null;
    } catch (Throwable __e) {
      return null;
    }
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  static public String multiLineQuote(String s) {
    for (int i = 0; ; i++) {
      String closer = "]" + rep('=', i) + "]";
      if (!contains(s, closer))
        return "[" + rep('=', i) + "[" + s + closer;
    }
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, final boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public Class findAClass(String fullClassName) {
        return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID = 0;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        }
        final int _refID = refID;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (_refID != 0)
              refs.put(_refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
        String t = t();
        Class c = classesMap.get(t);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              throw fail("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              throw fail("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            {
              parseList(new LinkedList(), out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(Collections.synchronizedNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(Collections.synchronizedSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(Collections.synchronizedMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(Collections.synchronizedList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            this.parseList(new ArrayList(), out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray") || t.equals("dblarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = "main$" + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume("j");
          out.set(parseJava());
          return;
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = "main$" + t;
        }
        if (c == null) {
          if (allDynamic)
            c = null;
          else
            c = findAClass(fullClassName);
          if (c != null)
            classesMap.put(className, c);
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && eq(t(), "this$1");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          o = hasOuter ? nuStubInnerObject(c, classFinder) : nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findAClass("main$Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID != 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        final LinkedHashMap<String, Object> fields = new LinkedHashMap();
        final Object _o = o;
        final DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(final unstructure_Receiver out) {
        final String type = tpp();
        consume("{");
        final List list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(\r\n           ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix("main$", name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public String ok2(String s) {
    return "ok " + s;
  }

  static public boolean makeAndroid3_disable = false;

  static public class Android3 implements AutoCloseable {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public void close() {
      dispose();
    }

    synchronized public void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  static abstract public class Responder {

    abstract public String answer(String s, List<String> history);
  }

  static public Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  static public Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  static public Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  static public void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  static public DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  static public String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  static public String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  static public boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  static public Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  static public ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  static public Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  static public String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  static public Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  static public String defaultBotName() {
    return getProgramTitle() + ".";
  }

  static public Object rcurry(final Object f, final Object arg) {
    int n = numberOfFunctionArguments(f);
    if (n == 0)
      throw fail("function takes no arguments");
    if (n == 1)
      return new F0() {

        public Object get() {
          return callF(f, arg);
        }
      };
    if (n == 2)
      return new F1() {

        public Object get(Object a) {
          return callF(f, a, arg);
        }
      };
    throw todo("currying a function with " + n + "arguments");
  }

  static public int findEndOfBracketPart2(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "(", "["))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")", "]"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public boolean hasLetters(String s) {
    for (int i = 0; i < s.length(); i++) if (Character.isLetter(s.charAt(i)))
      return true;
    return false;
  }

  static public boolean containsLowerCase(String s) {
    for (int i = 0; i < l(s); i++) if (isLowerCase(s.charAt(i)))
      return true;
    return false;
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public byte[] loadBinaryFilePart(File file, long start, long end) {
    try {
      RandomAccessFile raf = new RandomAccessFile(file, "r");
      int n = toInt(min(raf.length(), end - start));
      byte[] buffer = new byte[n];
      try {
        raf.seek(start);
        raf.readFully(buffer, 0, n);
        return buffer;
      } finally {
        raf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Component childWithClassNameEndingWith(Component c, String suffix) {
    if (endsWith(className(c), suffix))
      return c;
    Component x;
    for (Component comp : getComponents(c)) if ((x = childWithClassNameEndingWith(comp, suffix)) != null)
      return x;
    return null;
  }

  static public KeyListener enterKeyListener(final Object action) {
    return new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == KeyEvent.VK_ENTER)
          pcallF(action);
      }
    };
  }

  static public Runnable rCallOnSelectedListItem(final JList list, final Object action) {
    return new Runnable() {

      public void run() {
        try {
          pcallF(action, getSelectedItem(list));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(action, getSelectedItem(list))";
      }
    };
  }

  static public AbstractAction abstractAction(String name, final Object runnable) {
    return new AbstractAction(name) {

      public void actionPerformed(ActionEvent evt) {
        pcallF(runnable);
      }
    };
  }

  static public Object makeDependent_postProcess;

  static public void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public String stream2string(InputStream in) {
    return utf8streamToString(in);
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public <A> List<A> synchroLinkedList() {
    return Collections.synchronizedList(new LinkedList<A>());
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public <A> A nuStubInnerObject(Class<A> c) {
    return nuStubInnerObject(c, null);
  }

  static public <A> A nuStubInnerObject(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      makeAccessible(m);
      return (A) m.newInstance(new Object[] { null });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        boolean has = fieldMap.containsKey(field);
        if (has)
          setOpt(o, field, val);
        else {
          o.fieldValues = syncMapPut2_createLinkedHashMap(o.fieldValues, intern(field), val);
        }
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  static public String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  static public String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  static public String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  static public String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public List<Object> record_list = synchroList();

  static public void record(Object o) {
    record_list.add(o);
  }

  static public Object addToMultiPort_responder;

  static public long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  static public long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  static public AtomicInteger dialogServer_clients = new AtomicInteger();

  static public boolean dialogServer_printConnects = false;

  static public ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  static public Set<String> dialogServer_knownClients = synchroTreeSet();

  static public int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  static public int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  static public void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  static public ServerSocket startDialogServer_serverSocket;

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  static volatile public boolean readLine_noReadLine = false;

  static public String readLine_lastInput;

  static public String readLine_prefix = "[] ";

  static public String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  static public String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  static public boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String processID_cached;

  static public String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  static public String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  static public int numberOfFunctionArguments(Object f) {
    if (f instanceof F0)
      return 0;
    if (f instanceof F1)
      return 1;
    if (f instanceof VF1)
      return 1;
    if (f instanceof String)
      return numberOfMethodArguments(mc(), (String) f);
    return numberOfMethodArguments(f, "get");
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public boolean isLowerCase(char c) {
    return Character.isLowerCase(c);
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public List<Component> getComponents(final Component c) {
    return !(c instanceof Container) ? emptyList() : asList(swing(new F0<Component[]>() {

      public Component[] get() {
        try {
          return ((Container) c).getComponents();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret ((Container) c).getComponents();";
      }
    }));
  }

  static public String getSelectedItem(JList l) {
    return (String) l.getSelectedValue();
  }

  static public String getSelectedItem(JComboBox cb) {
    return strOrNull(cb.getSelectedItem());
  }

  static public List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  static public String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    Class c = o.getClass();
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map;
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().equals("this$1"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  static public String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  static public <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  static public <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  static public <A> Set<A> synchroTreeSet(TreeSet<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public boolean forbiddenPort(int port) {
    return port == 5037;
  }

  static public String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + s.replace("\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public int numberOfMethodArguments(Object o, String method) {
    Class c;
    boolean mustBeStatic = false;
    if (o instanceof Class) {
      c = (Class) o;
      mustBeStatic = true;
    } else
      c = o.getClass();
    Class _c = c;
    int n = -1;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if (mustBeStatic && !methodIsStatic(m))
          continue;
        int nn = l(m.getParameterTypes());
        if (n == -1)
          n = nn;
        else if (n != nn)
          throw fail("Variable number of method arguments: " + _c + "." + method);
      }
      c = c.getSuperclass();
    }
    if (n == -1)
      throw fail("Method not found: " + _c + "." + method);
    return n;
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public List<WeakReference<Class>> hotwire_classes = synchroList();

  static public Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  static public <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  static public String readerToString(Reader r) {
    try {
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public void consoleClearInput() {
    consoleSetInput("");
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    if (tf != null) {
      swing(new Runnable() {

        public void run() {
          try {
            tf.setText(text);
            tf.selectAll();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tf.setText(text);\r\n    tf.selectAll();";
        }
      });
    }
    return tf;
  }

  static public JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  static public void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  static public void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static public void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  static public JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  final static public class _MethodCache {

    final public Class c;

    final public HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      while (_c != null) {
        for (Method m : _c.getDeclaredMethods()) if (!isAbstract(m) && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if (m.isDefault() && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public boolean NanoHTTPD_debug = false;

  static abstract public class NanoHTTPD implements AutoCloseable {

    public boolean decodePercentInURI = false;

    public boolean noQueryStringParameter = true;

    static public ThreadLocal<IHTTPSession> currentSession = new ThreadLocal<IHTTPSession>();

    static public List<IHTTPSession> badClients = synchroList();

    public interface AsyncRunner {

      public void closeAll();

      public void closed(ClientHandler clientHandler);

      public void exec(ClientHandler code);
    }

    public class ClientHandler implements Runnable {

      final public InputStream inputStream;

      final public Socket acceptSocket;

      public ClientHandler(InputStream inputStream, Socket acceptSocket) {
        this.inputStream = inputStream;
        this.acceptSocket = acceptSocket;
      }

      public void close() {
        safeClose(this.inputStream);
        safeClose(this.acceptSocket);
      }

      @Override
      public void run() {
        OutputStream outputStream = null;
        try {
          outputStream = this.acceptSocket.getOutputStream();
          TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
          HTTPSession session = new HTTPSession(tempFileManager, this.inputStream, outputStream, this.acceptSocket.getInetAddress());
          while (!this.acceptSocket.isClosed() && !session.badClient) {
            session.execute();
          }
        } catch (Exception e) {
          if (!(e instanceof SocketException && "NanoHttpd Shutdown".equals(e.getMessage())) && !(e instanceof SocketTimeoutException)) {
            NanoHTTPD.LOG.log(Level.FINE, "Communication with the client broken", e);
          }
        } finally {
          safeClose(outputStream);
          safeClose(this.inputStream);
          safeClose(this.acceptSocket);
          NanoHTTPD.this.asyncRunner.closed(this);
        }
      }
    }

    public static class Cookie {

      public static String getHTTPTime(int days) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.add(Calendar.DAY_OF_MONTH, days);
        return dateFormat.format(calendar.getTime());
      }

      final public String n, v, e;

      public String domain, path;

      public Cookie(String name, String value) {
        this(name, value, 30);
      }

      public Cookie(String name, String value, int numDays) {
        this.n = name;
        this.v = value;
        this.e = getHTTPTime(numDays);
      }

      public Cookie(String name, String value, String expires) {
        this.n = name;
        this.v = value;
        this.e = expires;
      }

      public String getHTTPHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(n).append("=").append(v).append("; expires=").append(e);
        if (nempty(domain))
          buf.append("; Domain=").append(domain);
        if (nempty(path))
          buf.append("; Path=").append(path);
        return buf.toString();
      }
    }

    public class CookieHandler implements Iterable<String> {

      final public HashMap<String, String> cookies = new HashMap<String, String>();

      final public ArrayList<Cookie> queue = new ArrayList<Cookie>();

      public CookieHandler(Map<String, String> httpHeaders) {
        String raw = httpHeaders.get("cookie");
        if (raw != null) {
          String[] tokens = raw.split(";");
          for (String token : tokens) {
            String[] data = token.trim().split("=");
            if (data.length == 2) {
              this.cookies.put(data[0], data[1]);
            }
          }
        }
      }

      public void delete(String name) {
        set(name, "-delete-", -30);
      }

      @Override
      public Iterator<String> iterator() {
        return this.cookies.keySet().iterator();
      }

      public String read(String name) {
        return this.cookies.get(name);
      }

      public void set(Cookie cookie) {
        this.queue.add(cookie);
      }

      public Cookie set(String name, String value, int expires) {
        return addAndReturn(this.queue, new Cookie(name, value, Cookie.getHTTPTime(expires)));
      }

      public void unloadQueue(Response response) {
        for (Cookie cookie : this.queue) {
          response.addHeader("Set-Cookie", cookie.getHTTPHeader());
        }
      }
    }

    public static class DefaultAsyncRunner implements AsyncRunner {

      public long requestCount;

      final public List<ClientHandler> running = Collections.synchronizedList(new ArrayList<NanoHTTPD.ClientHandler>());

      public List<ClientHandler> getRunning() {
        return running;
      }

      @Override
      public void closeAll() {
        for (ClientHandler clientHandler : new ArrayList<ClientHandler>(this.running)) {
          clientHandler.close();
        }
      }

      @Override
      public void closed(ClientHandler clientHandler) {
        this.running.remove(clientHandler);
      }

      @Override
      public void exec(ClientHandler clientHandler) {
        ++this.requestCount;
        Thread t = new Thread(clientHandler);
        String clientIP = "?";
        try {
          clientIP = clientHandler.acceptSocket.getInetAddress().getHostAddress().toString();
        } catch (Throwable __e) {
          _handleException(__e);
        }
        t.setName("NanoHttpd serving request #" + this.requestCount + " to " + clientIP);
        this.running.add(clientHandler);
        t.start();
      }
    }

    public static class DefaultTempFile implements TempFile {

      final public File file;

      final public OutputStream fstream;

      public DefaultTempFile(String tempdir) throws IOException {
        this.file = File.createTempFile("NanoHTTPD-", "", new File(tempdir));
        this.fstream = new FileOutputStream(this.file);
        System.err.println("Temp file created: " + file);
      }

      @Override
      public void delete() throws Exception {
        safeClose(this.fstream);
        System.err.println("Temp file deleted: " + file);
        if (!this.file.delete()) {
          throw new Exception("could not delete temporary file");
        }
      }

      @Override
      public String getName() {
        return this.file.getAbsolutePath();
      }

      @Override
      public OutputStream open() throws Exception {
        return this.fstream;
      }
    }

    public static class DefaultTempFileManager implements TempFileManager {

      final public String tmpdir;

      final public List<TempFile> tempFiles;

      public DefaultTempFileManager() {
        this.tmpdir = tempDir().getPath();
        this.tempFiles = new ArrayList<TempFile>();
      }

      @Override
      public void clear() {
        for (TempFile file : this.tempFiles) {
          try {
            file.delete();
          } catch (Exception ignored) {
            NanoHTTPD.LOG.log(Level.WARNING, "could not delete file ", ignored);
          }
        }
        this.tempFiles.clear();
      }

      @Override
      public TempFile createTempFile() throws Exception {
        DefaultTempFile tempFile = new DefaultTempFile(this.tmpdir);
        this.tempFiles.add(tempFile);
        return tempFile;
      }
    }

    public class DefaultTempFileManagerFactory implements TempFileManagerFactory {

      @Override
      public TempFileManager create() {
        return new DefaultTempFileManager();
      }
    }

    static final public String CONTENT_DISPOSITION_REGEX = "([ |\t]*Content-Disposition[ |\t]*:)(.*)";

    static final public Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile(CONTENT_DISPOSITION_REGEX, Pattern.CASE_INSENSITIVE);

    static final public String CONTENT_TYPE_REGEX = "([ |\t]*content-type[ |\t]*:)(.*)";

    static final public Pattern CONTENT_TYPE_PATTERN = Pattern.compile(CONTENT_TYPE_REGEX, Pattern.CASE_INSENSITIVE);

    static final public String CONTENT_DISPOSITION_ATTRIBUTE_REGEX = "[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]";

    static final public Pattern CONTENT_DISPOSITION_ATTRIBUTE_PATTERN = Pattern.compile(CONTENT_DISPOSITION_ATTRIBUTE_REGEX);

    public class HTTPSession implements IHTTPSession {

      public boolean badClient = false;

      public long opened = sysNow();

      public static final int BUFSIZE = 8192;

      final public TempFileManager tempFileManager;

      final public OutputStream outputStream;

      final public PushbackInputStream inputStream;

      public int splitbyte;

      public int rlen;

      public String uri;

      public Method method;

      public Map<String, String> parms;

      public Map<String, String> headers;

      public Map<String, String> files = new HashMap();

      public CookieHandler cookies;

      public String queryParameterString;

      public String remoteIp;

      public String protocolVersion;

      public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
        this.tempFileManager = tempFileManager;
        this.inputStream = new PushbackInputStream(inputStream, HTTPSession.BUFSIZE);
        this.outputStream = outputStream;
      }

      public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
        this.tempFileManager = tempFileManager;
        this.inputStream = new PushbackInputStream(inputStream, HTTPSession.BUFSIZE);
        this.outputStream = outputStream;
        this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
        this.headers = new LinkedHashMap<String, String>();
      }

      public void badClient(boolean b) {
        badClient = b;
      }

      final public void decodeHeader(BufferedReader in, Map<String, String> pre, Map<String, String> parms, Map<String, String> headers, Map<String, String> files) throws ResponseException {
        try {
          String inLine = in.readLine();
          if (inLine == null) {
            return;
          }
          StringTokenizer st = new StringTokenizer(inLine);
          if (!st.hasMoreTokens()) {
            throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
          }
          pre.put("method", st.nextToken());
          if (!st.hasMoreTokens()) {
            throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
          }
          String uri = st.nextToken();
          int qmi = uri.indexOf('?');
          if (qmi >= 0) {
            String query = uri.substring(qmi + 1);
            files.put("query", query);
            decodeParms(query, parms);
            uri = uri.substring(0, qmi);
          }
          if (decodePercentInURI)
            uri = decodePercent(uri);
          if (st.hasMoreTokens()) {
            protocolVersion = st.nextToken();
          } else {
            protocolVersion = "HTTP/1.1";
            NanoHTTPD.LOG.log(Level.FINE, "no protocol version specified, strange. Assuming HTTP/1.1.");
          }
          String line = in.readLine();
          while (line != null && line.trim().length() > 0) {
            int p = line.indexOf(':');
            if (p >= 0) {
              headers.put(line.substring(0, p).trim().toLowerCase(Locale.US), line.substring(p + 1).trim());
            }
            line = in.readLine();
          }
          pre.put("uri", uri);
        } catch (IOException ioe) {
          throw new ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
        }
      }

      final public void decodeMultipartFormData(String boundary, ByteBuffer fbuf, Map<String, String> parms, Map<String, String> files) throws ResponseException {
        try {
          int[] boundary_idxs = getBoundaryPositions(fbuf, boundary.getBytes());
          if (boundary_idxs.length < 2) {
            throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but contains less than two boundary strings.");
          }
          final int MAX_HEADER_SIZE = 1024;
          byte[] part_header_buff = new byte[MAX_HEADER_SIZE];
          for (int bi = 0; bi < boundary_idxs.length - 1; bi++) {
            fbuf.position(boundary_idxs[bi]);
            int len = (fbuf.remaining() < MAX_HEADER_SIZE) ? fbuf.remaining() : MAX_HEADER_SIZE;
            fbuf.get(part_header_buff, 0, len);
            ByteArrayInputStream bais = new ByteArrayInputStream(part_header_buff, 0, len);
            BufferedReader in = new BufferedReader(new InputStreamReader(bais, Charset.forName("US-ASCII")));
            String mpline = in.readLine();
            if (!mpline.contains(boundary)) {
              throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but chunk does not start with boundary.");
            }
            String part_name = null, file_name = null, content_type = null;
            mpline = in.readLine();
            while (mpline != null && mpline.trim().length() > 0) {
              Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(mpline);
              if (matcher.matches()) {
                String attributeString = matcher.group(2);
                matcher = CONTENT_DISPOSITION_ATTRIBUTE_PATTERN.matcher(attributeString);
                while (matcher.find()) {
                  String key = matcher.group(1);
                  if (key.equalsIgnoreCase("name")) {
                    part_name = matcher.group(2);
                  } else if (key.equalsIgnoreCase("filename")) {
                    file_name = matcher.group(2);
                  }
                }
              }
              matcher = CONTENT_TYPE_PATTERN.matcher(mpline);
              if (matcher.matches()) {
                content_type = matcher.group(2).trim();
              }
              mpline = in.readLine();
            }
            int part_header_len = len - (int) in.skip(MAX_HEADER_SIZE);
            if (part_header_len >= len - 4) {
              throw new ResponseException(Status.INTERNAL_ERROR, "Multipart header size exceeds MAX_HEADER_SIZE.");
            }
            int part_data_start = boundary_idxs[bi] + part_header_len;
            int part_data_end = boundary_idxs[bi + 1] - 4;
            fbuf.position(part_data_start);
            if (content_type == null) {
              byte[] data_bytes = new byte[part_data_end - part_data_start];
              fbuf.get(data_bytes);
              parms.put(part_name, new String(data_bytes));
            } else {
              String path = saveTmpFile(fbuf, part_data_start, part_data_end - part_data_start);
              if (!files.containsKey(part_name)) {
                files.put(part_name, path);
              } else {
                int count = 2;
                while (files.containsKey(part_name + count)) {
                  count++;
                }
                files.put(part_name + count, path);
              }
              parms.put(part_name, file_name);
            }
          }
        } catch (ResponseException re) {
          throw re;
        } catch (Exception e) {
          throw new ResponseException(Status.INTERNAL_ERROR, e.toString());
        }
      }

      final public void decodeParms(String parms, Map<String, String> p) {
        if (parms == null) {
          this.queryParameterString = "";
          return;
        }
        this.queryParameterString = parms;
        StringTokenizer st = new StringTokenizer(parms, "&");
        while (st.hasMoreTokens()) {
          String e = st.nextToken();
          int sep = e.indexOf('=');
          if (sep >= 0) {
            p.put(decodePercent(e.substring(0, sep)).trim(), decodePercent(e.substring(sep + 1)));
          } else {
            p.put(decodePercent(e).trim(), "");
          }
        }
      }

      @Override
      public void execute() throws IOException {
        Response r = null;
        try {
          byte[] buf = new byte[HTTPSession.BUFSIZE];
          this.splitbyte = 0;
          this.rlen = 0;
          int read = -1;
          try {
            read = this.inputStream.read(buf, 0, HTTPSession.BUFSIZE);
          } catch (Exception e) {
            safeClose(this.inputStream);
            safeClose(this.outputStream);
            throw new SocketException("NanoHttpd Shutdown");
          }
          if (read == -1) {
            safeClose(this.inputStream);
            safeClose(this.outputStream);
            throw new SocketException("NanoHttpd Shutdown");
          }
          while (read > 0) {
            this.rlen += read;
            if (rlen >= buf.length)
              throw fail("Header too big (" + rlen + " bytes)");
            this.splitbyte = findHeaderEnd(buf, this.rlen);
            if (this.splitbyte > 0) {
              break;
            }
            read = this.inputStream.read(buf, this.rlen, HTTPSession.BUFSIZE - this.rlen);
          }
          if (this.splitbyte < this.rlen) {
            this.inputStream.unread(buf, this.splitbyte, this.rlen - this.splitbyte);
          }
          this.parms = new HashMap<String, String>();
          if (null == this.headers) {
            this.headers = new HashMap<String, String>();
          } else {
            this.headers.clear();
          }
          if (null != this.remoteIp) {
            this.headers.put("remote-addr", this.remoteIp);
            this.headers.put("http-client-ip", this.remoteIp);
          }
          BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.rlen)));
          Map<String, String> pre = new LinkedHashMap<String, String>();
          decodeHeader(hin, pre, this.parms, this.headers, this.files);
          this.method = Method.lookup(pre.get("method"));
          if (this.method == null) {
            throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error.");
          }
          this.uri = pre.get("uri");
          this.cookies = new CookieHandler(this.headers);
          String connection = this.headers.get("connection");
          boolean keepAlive = protocolVersion.equals("HTTP/1.1") && (connection == null || !connection.matches("(?i).*close.*"));
          r = serve(this);
          if (badClient)
            return;
          if (r == null) {
            throw new ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
          } else {
            String acceptEncoding = this.headers.get("accept-encoding");
            this.cookies.unloadQueue(r);
            r.setRequestMethod(this.method);
            r.setGzipEncoding(useGzipWhenAccepted(r) && acceptEncoding != null && acceptEncoding.contains("gzip"));
            r.setKeepAlive(keepAlive);
            r.send(this.outputStream);
          }
          if (!keepAlive || "close".equalsIgnoreCase(r.getHeader("connection"))) {
            throw new SocketException("NanoHttpd Shutdown");
          }
        } catch (SocketException e) {
          throw e;
        } catch (SocketTimeoutException ste) {
          throw ste;
        } catch (IOException ioe) {
          Response resp = newFixedLengthResponse(Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
          resp.send(this.outputStream);
          safeClose(this.outputStream);
        } catch (ResponseException re) {
          Response resp = newFixedLengthResponse(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
          resp.send(this.outputStream);
          safeClose(this.outputStream);
        } finally {
          if (badClient)
            badClients.add(this);
          else
            safeClose(r);
          this.tempFileManager.clear();
        }
      }

      final public int findHeaderEnd(final byte[] buf, int rlen) {
        int splitbyte = 0;
        while (splitbyte + 3 < rlen) {
          if (buf[splitbyte] == '\r' && buf[splitbyte + 1] == '\n' && buf[splitbyte + 2] == '\r' && buf[splitbyte + 3] == '\n') {
            return splitbyte + 4;
          }
          splitbyte++;
        }
        return 0;
      }

      final public int[] getBoundaryPositions(ByteBuffer b, byte[] boundary) {
        int[] res = new int[0];
        if (b.remaining() < boundary.length) {
          return res;
        }
        int search_window_pos = 0;
        byte[] search_window = new byte[4 * 1024 + boundary.length];
        int first_fill = (b.remaining() < search_window.length) ? b.remaining() : search_window.length;
        b.get(search_window, 0, first_fill);
        int new_bytes = first_fill - boundary.length;
        do {
          for (int j = 0; j < new_bytes; j++) {
            for (int i = 0; i < boundary.length; i++) {
              if (search_window[j + i] != boundary[i])
                break;
              if (i == boundary.length - 1) {
                int[] new_res = new int[res.length + 1];
                System.arraycopy(res, 0, new_res, 0, res.length);
                new_res[res.length] = search_window_pos + j;
                res = new_res;
              }
            }
          }
          search_window_pos += new_bytes;
          System.arraycopy(search_window, search_window.length - boundary.length, search_window, 0, boundary.length);
          new_bytes = search_window.length - boundary.length;
          new_bytes = (b.remaining() < new_bytes) ? b.remaining() : new_bytes;
          b.get(search_window, boundary.length, new_bytes);
        } while (new_bytes > 0);
        return res;
      }

      @Override
      public CookieHandler getCookies() {
        return this.cookies;
      }

      @Override
      public final Map<String, String> getHeaders() {
        return this.headers;
      }

      @Override
      public final Map<String, String> getFiles() {
        return this.files;
      }

      @Override
      public final InputStream getInputStream() {
        return this.inputStream;
      }

      @Override
      public final Method getMethod() {
        return this.method;
      }

      @Override
      public final Map<String, String> getParms() {
        return this.parms;
      }

      @Override
      public String getQueryParameterString() {
        return this.queryParameterString;
      }

      final public RandomAccessFile getTmpBucket() {
        try {
          TempFile tempFile = this.tempFileManager.createTempFile();
          return new RandomAccessFile(tempFile.getName(), "rw");
        } catch (Exception e) {
          throw new Error(e);
        }
      }

      @Override
      public final String getUri() {
        return this.uri;
      }

      @Override
      public void parseBody() throws IOException, ResponseException {
        final int REQUEST_BUFFER_LEN = 512;
        final int MEMORY_STORE_LIMIT = 1024;
        RandomAccessFile randomAccessFile = null;
        try {
          long size;
          if (this.headers.containsKey("content-length")) {
            size = Integer.parseInt(this.headers.get("content-length"));
          } else if (this.splitbyte < this.rlen) {
            size = this.rlen - this.splitbyte;
          } else {
            size = 0;
          }
          ByteArrayOutputStream baos = null;
          DataOutput request_data_output = null;
          if (size < MEMORY_STORE_LIMIT) {
            baos = new ByteArrayOutputStream();
            request_data_output = new DataOutputStream(baos);
          } else {
            randomAccessFile = getTmpBucket();
            request_data_output = randomAccessFile;
          }
          byte[] buf = new byte[REQUEST_BUFFER_LEN];
          while (this.rlen >= 0 && size > 0) {
            this.rlen = this.inputStream.read(buf, 0, (int) Math.min(size, REQUEST_BUFFER_LEN));
            size -= this.rlen;
            if (this.rlen > 0) {
              request_data_output.write(buf, 0, this.rlen);
            }
          }
          ByteBuffer fbuf = null;
          if (baos != null) {
            fbuf = ByteBuffer.wrap(baos.toByteArray(), 0, baos.size());
          } else {
            fbuf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0, randomAccessFile.length());
            randomAccessFile.seek(0);
          }
          if (Method.POST.equals(this.method)) {
            String contentType = "";
            String contentTypeHeader = this.headers.get("content-type");
            StringTokenizer st = null;
            if (contentTypeHeader != null) {
              st = new StringTokenizer(contentTypeHeader, ",; ");
              if (st.hasMoreTokens()) {
                contentType = st.nextToken();
              }
            }
            if ("multipart/form-data".equalsIgnoreCase(contentType)) {
              if (!st.hasMoreTokens()) {
                throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
              }
              String boundaryStartString = "boundary=";
              int boundaryContentStart = contentTypeHeader.indexOf(boundaryStartString) + boundaryStartString.length();
              String boundary = contentTypeHeader.substring(boundaryContentStart, contentTypeHeader.length());
              if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
                boundary = boundary.substring(1, boundary.length() - 1);
              }
              decodeMultipartFormData(boundary, fbuf, this.parms, files);
            } else {
              byte[] postBytes = new byte[fbuf.remaining()];
              if (NanoHTTPD_debug)
                print("NanoHTTPD: Handling POST data (" + l(postBytes) + " bytes)");
              fbuf.get(postBytes);
              String postLine = new String(postBytes).trim();
              if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                decodeParms(postLine, this.parms);
              } else if (postLine.length() != 0) {
                files.put("postData", postLine);
              }
            }
          } else if (Method.PUT.equals(this.method)) {
            files.put("content", saveTmpFile(fbuf, 0, fbuf.limit()));
          }
        } finally {
          safeClose(randomAccessFile);
        }
      }

      final public String saveTmpFile(ByteBuffer b, int offset, int len) {
        String path = "";
        if (len > 0) {
          FileOutputStream fileOutputStream = null;
          try {
            TempFile tempFile = this.tempFileManager.createTempFile();
            ByteBuffer src = b.duplicate();
            fileOutputStream = new FileOutputStream(tempFile.getName());
            FileChannel dest = fileOutputStream.getChannel();
            src.position(offset).limit(offset + len);
            dest.write(src.slice());
            path = tempFile.getName();
          } catch (Exception e) {
            throw new Error(e);
          } finally {
            safeClose(fileOutputStream);
          }
        }
        return path;
      }
    }

    public interface IHTTPSession {

      public void badClient(boolean b);

      public void execute() throws IOException;

      public CookieHandler getCookies();

      public Map<String, String> getHeaders();

      public Map<String, String> getFiles();

      public InputStream getInputStream();

      public Method getMethod();

      public Map<String, String> getParms();

      public String getQueryParameterString();

      public String getUri();

      public void parseBody() throws IOException, ResponseException;
    }

    public enum Method {

      GET,
      PUT,
      POST,
      DELETE,
      HEAD,
      OPTIONS,
      TRACE,
      CONNECT,
      PATCH;

      static public Method lookup(String method) {
        for (Method m : Method.values()) {
          if (m.toString().equalsIgnoreCase(method)) {
            return m;
          }
        }
        return null;
      }
    }

    public static class Response implements Closeable {

      static public class ChunkedOutputStream extends FilterOutputStream {

        public ChunkedOutputStream(OutputStream out) {
          super(out);
        }

        @Override
        public void write(int b) throws IOException {
          byte[] data = { (byte) b };
          write(data, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
          write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
          if (len == 0)
            return;
          out.write(String.format("%x\r\n", len).getBytes());
          out.write(b, off, len);
          out.write("\r\n".getBytes());
        }

        public void finish() throws IOException {
          out.write("0\r\n\r\n".getBytes());
        }
      }

      public IStatus status;

      public String mimeType;

      public InputStream data;

      public long contentLength;

      final public Map<String, String> header = lithashmap("X-Powered-By", "JavaX");

      public Method requestMethod;

      public boolean chunkedTransfer = false;

      public boolean encodeAsGzip = false;

      public boolean keepAlive = false;

      public Response(IStatus status, String mimeType, InputStream data, long totalBytes) {
        this.status = status;
        this.mimeType = mimeType;
        if (data == null) {
          this.data = new ByteArrayInputStream(new byte[0]);
          this.contentLength = 0L;
        } else {
          this.data = data;
          this.contentLength = totalBytes;
        }
        this.chunkedTransfer = this.contentLength < 0;
        keepAlive = true;
      }

      @Override
      public void close() throws IOException {
        if (this.data != null) {
          this.data.close();
        }
      }

      public void addHeader(String name, String value) {
        this.header.put(name, value);
      }

      public InputStream getData() {
        return this.data;
      }

      public String getHeader(String name) {
        for (String headerName : header.keySet()) {
          if (headerName.equalsIgnoreCase(name)) {
            return header.get(headerName);
          }
        }
        return null;
      }

      public String getMimeType() {
        return this.mimeType;
      }

      public Method getRequestMethod() {
        return this.requestMethod;
      }

      public IStatus getStatus() {
        return this.status;
      }

      public void setGzipEncoding(boolean encodeAsGzip) {
        this.encodeAsGzip = encodeAsGzip;
      }

      public void setKeepAlive(boolean useKeepAlive) {
        this.keepAlive = useKeepAlive;
      }

      final public boolean headerAlreadySent(Map<String, String> header, String name) {
        boolean alreadySent = false;
        for (String headerName : header.keySet()) {
          alreadySent |= headerName.equalsIgnoreCase(name);
        }
        return alreadySent;
      }

      public void send(OutputStream outputStream) {
        String mime = this.mimeType;
        SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
          if (this.status == null) {
            throw new Error("sendResponse(): Status can't be null.");
          }
          PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), false);
          pw.print("HTTP/1.1 " + this.status.getDescription() + " \r\n");
          if (mime != null) {
            pw.print("Content-Type: " + mime + "\r\n");
          }
          if (this.header == null || this.header.get("Date") == null) {
            pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
          }
          if (this.header != null) {
            for (String key : this.header.keySet()) {
              String value = this.header.get(key);
              pw.print(key + ": " + value + "\r\n");
            }
          }
          if (!headerAlreadySent(header, "connection")) {
            pw.print("Connection: " + (this.keepAlive ? "keep-alive" : "close") + "\r\n");
          }
          if (headerAlreadySent(this.header, "content-length")) {
            encodeAsGzip = false;
          }
          if (encodeAsGzip) {
            pw.print("Content-Encoding: gzip\r\n");
            setChunkedTransfer(true);
          }
          long pending = this.data != null ? this.contentLength : 0;
          if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
            pw.print("Transfer-Encoding: chunked\r\n");
          } else if (!encodeAsGzip) {
            pending = sendContentLengthHeaderIfNotAlreadyPresent(pw, this.header, pending);
          }
          pw.print("\r\n");
          pw.flush();
          sendBodyWithCorrectTransferAndEncoding(outputStream, pending);
          outputStream.flush();
          safeClose(this.data);
        } catch (IOException ioe) {
          NanoHTTPD.LOG.log(Level.SEVERE, "Could not send response to the client", ioe);
        }
      }

      final public void sendBodyWithCorrectTransferAndEncoding(OutputStream outputStream, long pending) throws IOException {
        if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
          ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream);
          sendBodyWithCorrectEncoding(chunkedOutputStream, -1);
          chunkedOutputStream.finish();
        } else {
          sendBodyWithCorrectEncoding(outputStream, pending);
        }
      }

      final public void sendBodyWithCorrectEncoding(OutputStream outputStream, long pending) throws IOException {
        if (encodeAsGzip) {
          GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
          sendBody(gzipOutputStream, -1);
          gzipOutputStream.finish();
        } else {
          sendBody(outputStream, pending);
        }
      }

      final public void sendBody(OutputStream outputStream, long pending) throws IOException {
        long BUFFER_SIZE = 16 * 1024;
        byte[] buff = new byte[(int) BUFFER_SIZE];
        boolean sendEverything = pending == -1;
        while (pending > 0 || sendEverything) {
          long bytesToRead = sendEverything ? BUFFER_SIZE : Math.min(pending, BUFFER_SIZE);
          int read = this.data.read(buff, 0, (int) bytesToRead);
          if (read <= 0) {
            break;
          }
          outputStream.write(buff, 0, read);
          if (!sendEverything) {
            pending -= read;
          }
        }
      }

      public long sendContentLengthHeaderIfNotAlreadyPresent(PrintWriter pw, Map<String, String> header, long size) {
        for (String headerName : header.keySet()) {
          if (headerName.equalsIgnoreCase("content-length")) {
            try {
              return Long.parseLong(header.get(headerName));
            } catch (NumberFormatException ex) {
              return size;
            }
          }
        }
        pw.print("Content-Length: " + size + "\r\n");
        return size;
      }

      public void setChunkedTransfer(boolean chunkedTransfer) {
        this.chunkedTransfer = chunkedTransfer;
      }

      public void setData(InputStream data) {
        this.data = data;
      }

      public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
      }

      public void setRequestMethod(Method requestMethod) {
        this.requestMethod = requestMethod;
      }

      public void setStatus(IStatus status) {
        this.status = status;
      }
    }

    public static final class ResponseException extends Exception {

      static final public long serialVersionUID = 6569838532917408380L;

      final public Status status;

      public ResponseException(Status status, String message) {
        super(message);
        this.status = status;
      }

      public ResponseException(Status status, String message, Exception e) {
        super(message, e);
        this.status = status;
      }

      public Status getStatus() {
        return this.status;
      }
    }

    public class ServerRunnable implements Runnable {

      final public int timeout;

      public IOException bindException;

      public boolean hasBinded = false;

      public ServerRunnable(int timeout) {
        this.timeout = timeout;
      }

      @Override
      public void run() {
        try {
          myServerSocket.bind(hostname != null ? new InetSocketAddress(hostname, myPort) : new InetSocketAddress(myPort));
          hasBinded = true;
        } catch (IOException e) {
          print("Was trying to bind to port: " + myPort + (hostname == null ? "" : " on " + hostname));
          this.bindException = e;
          return;
        }
        do {
          try {
            final Socket finalAccept = NanoHTTPD.this.myServerSocket.accept();
            if (NanoHTTPD_debug)
              print("NanoHTTPD: New socket.");
            if (this.timeout > 0) {
              finalAccept.setSoTimeout(this.timeout);
            }
            final InputStream inputStream = wrapStuff("SocketInputStream", finalAccept.getInputStream(), finalAccept, NanoHTTPD.this.myServerSocket);
            NanoHTTPD.this.asyncRunner.exec(createClientHandler(finalAccept, inputStream));
          } catch (IOException e) {
            NanoHTTPD.LOG.log(Level.FINE, "Communication with the client broken", e);
          }
        } while (!NanoHTTPD.this.myServerSocket.isClosed());
      }
    }

    public interface TempFile {

      public void delete() throws Exception;

      public String getName();

      public OutputStream open() throws Exception;
    }

    public interface TempFileManager {

      public void clear();

      public TempFile createTempFile() throws Exception;
    }

    public interface TempFileManagerFactory {

      public TempFileManager create();
    }

    public static int SOCKET_READ_TIMEOUT = 24 * 3600 * 1000;

    public static final String MIME_PLAINTEXT = "text/plain; charset=utf-8";

    public static final String MIME_HTML = "text/html; charset=utf-8";

    static final public String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";

    static final public Logger LOG = Logger.getLogger(NanoHTTPD.class.getName());

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManager[] keyManagers) throws IOException {
      SSLServerSocketFactory res = null;
      try {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(loadedKeyStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
        res = ctx.getServerSocketFactory();
      } catch (Exception e) {
        throw new IOException(e.getMessage());
      }
      return res;
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManagerFactory loadedKeyFactory) throws IOException {
      SSLServerSocketFactory res = null;
      try {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(loadedKeyStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(loadedKeyFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        res = ctx.getServerSocketFactory();
      } catch (Exception e) {
        throw new IOException(e.getMessage());
      }
      return res;
    }

    public static SSLServerSocketFactory makeSSLSocketFactory(String keyAndTrustStoreClasspathPath, char[] passphrase) throws IOException {
      SSLServerSocketFactory res = null;
      try {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream keystoreStream = NanoHTTPD.class.getResourceAsStream(keyAndTrustStoreClasspathPath);
        keystore.load(keystoreStream, passphrase);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keystore, passphrase);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        res = ctx.getServerSocketFactory();
      } catch (Exception e) {
        throw new IOException(e.getMessage());
      }
      return res;
    }

    static final public void safeClose(Object closeable) {
      try {
        if (closeable != null) {
          if (closeable instanceof Closeable) {
            ((Closeable) closeable).close();
          } else if (closeable instanceof Socket) {
            ((Socket) closeable).close();
          } else if (closeable instanceof ServerSocket) {
            ((ServerSocket) closeable).close();
          } else {
            throw new IllegalArgumentException("Unknown object to close");
          }
        }
      } catch (IOException e) {
        NanoHTTPD.LOG.log(Level.SEVERE, "Could not close", e);
      }
    }

    final public String hostname;

    final public int myPort;

    public ServerSocket myServerSocket;

    public SSLServerSocketFactory sslServerSocketFactory;

    public Thread myThread;

    public AsyncRunner asyncRunner;

    public TempFileManagerFactory tempFileManagerFactory;

    public NanoHTTPD(int port) {
      this(null, port);
    }

    public NanoHTTPD(String hostname, int port) {
      this.hostname = hostname;
      this.myPort = port;
      setTempFileManagerFactory(new DefaultTempFileManagerFactory());
      setAsyncRunner(new DefaultAsyncRunner());
    }

    public synchronized void closeAllConnections() {
      stop();
    }

    public ClientHandler createClientHandler(final Socket finalAccept, final InputStream inputStream) {
      return new ClientHandler(inputStream, finalAccept);
    }

    public ServerRunnable createServerRunnable(final int timeout) {
      return new ServerRunnable(timeout);
    }

    public Map<String, List<String>> decodeParameters(Map<String, String> parms) {
      return this.decodeParameters(parms.get(NanoHTTPD.QUERY_STRING_PARAMETER));
    }

    public Map<String, List<String>> decodeParameters(String queryString) {
      Map<String, List<String>> parms = new HashMap<String, List<String>>();
      if (queryString != null) {
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
          String e = st.nextToken();
          int sep = e.indexOf('=');
          String propertyName = sep >= 0 ? decodePercent(e.substring(0, sep)).trim() : decodePercent(e).trim();
          if (!parms.containsKey(propertyName)) {
            parms.put(propertyName, new ArrayList<String>());
          }
          String propertyValue = sep >= 0 ? decodePercent(e.substring(sep + 1)) : null;
          {
            parms.get(propertyName).add(propertyValue);
          }
        }
      }
      return parms;
    }

    public String decodePercent(String str) {
      String decoded = null;
      try {
        decoded = URLDecoder.decode(str, "UTF8");
      } catch (UnsupportedEncodingException ignored) {
        NanoHTTPD.LOG.log(Level.WARNING, "Encoding not supported, ignored", ignored);
      }
      return decoded;
    }

    public boolean useGzipWhenAccepted(Response r) {
      return r.getMimeType() != null && r.getMimeType().toLowerCase().contains("text/");
    }

    public final int getListeningPort() {
      return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean isAlive() {
      return wasStarted() && !this.myServerSocket.isClosed() && this.myThread.isAlive();
    }

    public void join() throws InterruptedException {
      myThread.join();
    }

    public void makeSecure(SSLServerSocketFactory sslServerSocketFactory) {
      this.sslServerSocketFactory = sslServerSocketFactory;
    }

    public static Response newChunkedResponse(IStatus status, String mimeType, InputStream data) {
      return new Response(status, mimeType, data, -1);
    }

    public static Response newFixedLengthResponse(IStatus status, String mimeType, InputStream data, long totalBytes) {
      return new Response(status, mimeType, data, totalBytes);
    }

    public static Response newFixedLengthResponse(IStatus status, String mimeType, String txt) {
      if (txt == null) {
        return newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(new byte[0]), 0);
      } else {
        byte[] bytes;
        try {
          bytes = txt.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
          NanoHTTPD.LOG.log(Level.SEVERE, "encoding problem, responding nothing", e);
          bytes = new byte[0];
        }
        return newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(bytes), bytes.length);
      }
    }

    public static Response newFixedLengthResponse(String msg) {
      return newFixedLengthResponse(Status.OK, NanoHTTPD.MIME_HTML, msg);
    }

    public Response serve(IHTTPSession session) {
      currentSession.set(session);
      Method method = session.getMethod();
      if (Method.PUT.equals(method) || Method.POST.equals(method)) {
        try {
          session.parseBody();
        } catch (IOException ioe) {
          return newFixedLengthResponse(Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
        } catch (ResponseException re) {
          return newFixedLengthResponse(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
        }
      }
      Map<String, String> parms = session.getParms();
      if (!noQueryStringParameter)
        parms.put(NanoHTTPD.QUERY_STRING_PARAMETER, session.getQueryParameterString());
      return serve(session.getUri(), method, session.getHeaders(), parms, session.getFiles());
    }

    @Deprecated
    public Response serve(String uri, Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
      return newFixedLengthResponse(Status.NOT_FOUND, NanoHTTPD.MIME_PLAINTEXT, "Not Found");
    }

    public void setAsyncRunner(AsyncRunner asyncRunner) {
      this.asyncRunner = asyncRunner;
    }

    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
      this.tempFileManagerFactory = tempFileManagerFactory;
    }

    public void start() throws IOException {
      start(NanoHTTPD.SOCKET_READ_TIMEOUT);
    }

    public void start(final int timeout) throws IOException {
      boolean ssl = this.sslServerSocketFactory != null;
      if (ssl) {
        SSLServerSocket ss = (SSLServerSocket) this.sslServerSocketFactory.createServerSocket();
        ss.setNeedClientAuth(false);
        this.myServerSocket = ss;
      } else {
        this.myServerSocket = new ServerSocket();
      }
      this.myServerSocket.setReuseAddress(true);
      ServerRunnable serverRunnable = createServerRunnable(timeout);
      this.myThread = new Thread(serverRunnable);
      this.myThread.setName("NanoHttpd Main Listener");
      this.myThread.start();
      while (!serverRunnable.hasBinded && serverRunnable.bindException == null) {
        try {
          Thread.sleep(10L);
        } catch (Throwable e) {
        }
      }
      if (serverRunnable.bindException != null) {
        throw serverRunnable.bindException;
      }
      System.out.println("HTTP" + (ssl ? "S" : "") + " server started (listening on port " + getListeningPort() + "!)");
      printMyIPs();
    }

    public void stop() {
      try {
        safeClose(this.myServerSocket);
        this.asyncRunner.closeAll();
        if (this.myThread != null) {
          this.myThread.join();
        }
      } catch (Exception e) {
        NanoHTTPD.LOG.log(Level.SEVERE, "Could not stop all connections", e);
      }
    }

    public final boolean wasStarted() {
      return this.myServerSocket != null && this.myThread != null;
    }

    static public void printMyIPs() {
      String ip;
      try {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
          NetworkInterface iface = interfaces.nextElement();
          if (iface.isLoopback() || !iface.isUp())
            continue;
          Enumeration<InetAddress> addresses = iface.getInetAddresses();
          while (addresses.hasMoreElements()) {
            InetAddress addr = addresses.nextElement();
            ip = addr.getHostAddress();
            if (ip.startsWith("127."))
              continue;
            boolean local = addr.isSiteLocalAddress() || ip.startsWith("fe");
            System.out.println(iface.getDisplayName() + " " + ip + " " + (local ? "(private address)" : "(public address)"));
          }
        }
      } catch (Throwable e) {
        e.printStackTrace();
      }
    }

    static public interface IStatus {

      public String getDescription();

      public int getRequestStatus();
    }

    static enum Status implements IStatus {

      SWITCH_PROTOCOL(101, "Switching Protocols"),
      OK(200, "OK"),
      CREATED(201, "Created"),
      ACCEPTED(202, "Accepted"),
      NO_CONTENT(204, "No Content"),
      PARTIAL_CONTENT(206, "Partial Content"),
      REDIRECT(301, "Moved Permanently"),
      NOT_MODIFIED(304, "Not Modified"),
      BAD_REQUEST(400, "Bad Request"),
      UNAUTHORIZED(401, "Unauthorized"),
      FORBIDDEN(403, "Forbidden"),
      NOT_FOUND(404, "Not Found"),
      METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
      REQUEST_TIMEOUT(408, "Request Timeout"),
      RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
      INTERNAL_ERROR(500, "Internal Server Error"),
      UNSUPPORTED_HTTP_VERSION(505, "HTTP Version Not Supported");

      final public int requestStatus;

      final public String description;

      Status(int requestStatus, String description) {
        this.requestStatus = requestStatus;
        this.description = description;
      }

      @Override
      public String getDescription() {
        return "" + this.requestStatus + " " + this.description;
      }

      @Override
      public int getRequestStatus() {
        return this.requestStatus;
      }
    }

    public int getPort() {
      return myPort;
    }

    public void close() {
      stop();
    }
  }

  static abstract public class TokCondition {

    abstract public boolean get(List<String> tok, int i);
  }

  static final public class ParameterizedTypeImpl implements ParameterizedType {

    final public Type ownerType;

    final public Type rawType;

    final public Type[] typeArguments;

    public ParameterizedTypeImpl(Type ownerType, Type rawType, Type... typeArguments) {
      this.typeArguments = typeArguments;
      this.rawType = rawType;
      this.ownerType = ownerType;
    }

    public Type[] getActualTypeArguments() {
      return typeArguments;
    }

    public Type getRawType() {
      return rawType;
    }

    public Type getOwnerType() {
      return ownerType;
    }

    @Override
    public boolean equals(Object other) {
      if (other instanceof ParameterizedType)
        return eq(ownerType, ((ParameterizedType) other).getOwnerType()) && eq(rawType, ((ParameterizedType) other).getRawType()) && eq(asList(typeArguments), asList(((ParameterizedType) other).getActualTypeArguments()));
      return false;
    }

    @Override
    public int hashCode() {
      return Arrays.hashCode(typeArguments) ^ rawType.hashCode() ^ _hashCode(ownerType);
    }

    @Override
    public String toString() {
      int length = typeArguments.length;
      if (length == 0)
        return typeToString(rawType);
      StringBuilder stringBuilder = new StringBuilder();
      stringBuilder.append(typeToString(rawType)).append("<").append(typeToString(typeArguments[0]));
      for (int i = 1; i < length; i++) {
        stringBuilder.append(", ").append(typeToString(typeArguments[i]));
      }
      return stringBuilder.append(">").toString();
    }

    static public String typeToString(Type type) {
      return type instanceof Class ? ((Class<?>) type).getName() : type.toString();
    }
  }

  static public class MultiMap<A, B> {

    public Map<A, List<B>> data = new HashMap<A, List<B>>();

    public MultiMap() {
    }

    public MultiMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiMap(MultiMap<A, B> map) {
      putAll(map);
    }

    public MultiMap(Map<A, List<B>> data) {
      this.data = data;
    }

    public void put(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        list.add(value);
      }
    }

    public void add(A key, B value) {
      put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      putAll(key, values);
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        if (nempty(values))
          getActual(key).addAll(values);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public List<B> get(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        return list == null ? Collections.<B>emptyList() : list;
      }
    }

    public List<B> getOpt(A key) {
      synchronized (data) {
        return data.get(key);
      }
    }

    public List<B> getActual(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        return list;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null && list.isEmpty())
          data.remove(key);
      }
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public Set<A> keys() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        data.remove(key);
      }
    }

    public void remove(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null) {
          list.remove(value);
          if (list.isEmpty())
            data.remove(key);
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        List<B> list = get(key);
        return list.isEmpty() ? null : list.get(0);
      }
    }

    public void addAll(MultiMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    public int size() {
      synchronized (data) {
        int n = 0;
        for (List l : data.values()) n += l(l);
        return n;
      }
    }

    public List<A> reverseGet(B b) {
      synchronized (data) {
        List<A> l = new ArrayList();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, List<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public List<B> _makeEmptyList() {
      return new ArrayList();
    }

    public Collection<List<B>> allLists() {
      synchronized (data) {
        return new ArrayList(data.values());
      }
    }

    public Collection<List<B>> values() {
      return allLists();
    }

    public List<B> allValues() {
      return concatLists(data.values());
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }
  }

  final static public class LongRange {

    public long start, end;

    public LongRange() {
    }

    public LongRange(long start, long end) {
      this.end = end;
      this.start = start;
    }

    public boolean equals(Object o) {
      if (o instanceof LongRange)
        return start == ((LongRange) o).start && end == ((LongRange) o).end;
      return false;
    }

    public int hashCode() {
      return boostHashCombine(hashOfLong(start), hashOfLong(end));
    }

    public long length() {
      return end - start;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  final static public class ConceptFieldIndexDesc<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter {

    public Class<A> cc;

    public String field;

    public HashMap<A, Val> objectToValue = new HashMap();

    public MultiSetMap<Val, A> valueToObject;

    public ConceptFieldIndexDesc() {
      valueToObject = treeMultiSetMap(reverseOrder());
    }

    public ConceptFieldIndexDesc(Class<A> cc, String field) {
      this(db_mainConcepts(), cc, field);
    }

    public ConceptFieldIndexDesc(Concepts concepts, Class<A> cc, String field) {
      this();
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    synchronized public void updateImpl(Concept c) {
      Val newValue = (Val) (cget(c, field));
      Val oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      Val value = (Val) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    synchronized public A get(Val value) {
      return valueToObject.getFirst(value);
    }

    public synchronized Collection<A> getAll(Val value) {
      return valueToObject.get(value);
    }

    public synchronized List<Val> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public IterableIterator<A> objectIterator() {
      return navigableMultiSetMapValuesIterator_concurrent(valueToObject, this);
    }

    public synchronized MultiSet<Val> allValues_multiSet() {
      return multiSetMapToMultiSet(valueToObject);
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }

    public Object mutex() {
      return this;
    }

    synchronized public List<A> objectsWithValueGreaterThan(Object value) {
      SortedMap<Object, Set<A>> subMap = ((SortedMap<Object, Set<A>>) valueToObject.data).headMap(value);
      return concatLists(values(subMap));
    }
  }

  static public class JavaScript extends Var<String> {

    public JavaScript() {
    }

    public JavaScript(String src) {
      super(src);
    }

    public String javaScriptSource() {
      return get();
    }

    public String toString() {
      return hjs(get());
    }
  }

  static public class _PrintIndent extends F1<String, Boolean> {

    public String prefix;

    public boolean beginningOfLine = true;

    public _PrintIndent() {
    }

    public _PrintIndent(String prefix) {
      this.prefix = prefix;
    }

    public Boolean get(String s) {
      if (empty(s))
        return false;
      boolean nl = s.endsWith("\n");
      if (nl)
        s = dropLast(s);
      s = s.replace("\n", "\n" + prefix);
      print_raw(beginningOfLine ? prefix + s : s);
      if (nl)
        print_raw("\n");
      beginningOfLine = nl;
      return false;
    }
  }

  static public interface IResourceLoader {

    public String loadSnippet(String snippetID);

    public String getTranspiled(String snippetID);

    public int getSnippetType(String snippetID);

    public String getSnippetTitle(String snippetID);

    public File loadLibrary(String snippetID);

    public File pathToJavaXJar();

    public File getSnippetJar(String snippetID, String transpiledSrc);
  }

  static public class proxy_InvocationHandler implements InvocationHandler {

    public Object target;

    public proxy_InvocationHandler() {
    }

    public proxy_InvocationHandler(Object target) {
      this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
      return call(target, method.getName(), unnull(args));
    }
  }

  static public class FixedRateTimer extends java.util.Timer {

    public FixedRateTimer() {
      this(false);
    }

    public FixedRateTimer(boolean daemon) {
      this(defaultTimerName(), daemon);
    }

    public FixedRateTimer(String name) {
      this(name, false);
    }

    public FixedRateTimer(String name, boolean daemon) {
      super(name, daemon);
      _registerTimer(this);
    }

    public List<Entry> entries = synchroList();

    static public class Entry implements IFieldsToList {

      public TimerTask task;

      public long firstTime;

      public long period;

      public Entry() {
      }

      public Entry(TimerTask task, long firstTime, long period) {
        this.period = period;
        this.firstTime = firstTime;
        this.task = task;
      }

      public String toString() {
        return shortClassName(this) + "(" + task + ", " + firstTime + ", " + period + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { task, firstTime, period };
      }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
      entries.add(new Entry(task, now() + delay, period));
      super.scheduleAtFixedRate(task, delay, period);
    }

    public void cancel() {
      entries.clear();
      super.cancel();
    }

    public int purge() {
      entries.clear();
      return super.purge();
    }

    public FixedRateTimer changeRate(int newPeriod) {
      Object r = ((SmartTimerTask) first(entries).task).r;
      cancel();
      return doEvery(newPeriod, r);
    }
  }

  static public class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  static abstract public class DialogIO implements AutoCloseable {

    public String line;

    public boolean eos, loud, noClose;

    public Lock lock = lock();

    abstract public String readLineImpl();

    abstract public boolean isStillConnected();

    abstract public void sendLine(String line);

    abstract public boolean isLocalConnection();

    abstract public Socket getSocket();

    public int getPort() {
      Socket s = getSocket();
      return s == null ? 0 : s.getPort();
    }

    public boolean helloRead = false;

    public int shortenOutputTo = 500;

    public String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }

    public boolean waitForLine() {
      try {
        ping();
        if (line != null)
          return true;
        line = readLineImpl();
        if (line == null)
          eos = true;
        return line != null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }

    public String ask(String s, Object... args) {
      if (loud)
        return askLoudly(s, args);
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      sendLine(s);
      return readLine();
    }

    public String askLoudly(String s, Object... args) {
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }

    public void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }

  static abstract public class DialogHandler {

    abstract public void run(DialogIO io);
  }

  static public class ConceptFieldIndex<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter {

    public Class<A> cc;

    public String field;

    public HashMap<A, Val> objectToValue = new HashMap();

    public MultiSetMap<Val, A> valueToObject = new MultiSetMap();

    public ConceptFieldIndex() {
    }

    public ConceptFieldIndex(Class<A> cc, String field) {
      this(db_mainConcepts(), cc, field);
    }

    public ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) {
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    synchronized public void updateImpl(Concept c) {
      Val newValue = (Val) (cget(c, field));
      Val oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      Val value = (Val) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    synchronized public A get(Val value) {
      return valueToObject.getFirst(value);
    }

    public synchronized Collection<A> getAll(Val value) {
      return valueToObject.get(value);
    }

    public synchronized List<Val> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public synchronized MultiSet<Val> allValues_multiSet() {
      return multiSetMapToMultiSet(valueToObject);
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }
  }

  static abstract public class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  final static public class ContentsIndexedList<A> extends RandomAccessAbstractList<A> implements IContentsIndexedList<A>, IContentsIndexedList2<A> {

    public Map<A, TreeSet<Elem<A>>> index = new HashMap();

    final public ArrayList<Elem<A>> list = new ArrayList();

    final static public class Elem<A> extends HasIndex {

      public A s;

      public String toString() {
        return "Elem " + quote(s) + "@" + idx;
      }
    }

    public ContentsIndexedList() {
    }

    public ContentsIndexedList(Map<A, TreeSet<Elem<A>>> index) {
      this.index = index;
    }

    public ContentsIndexedList(Collection<A> l) {
      addAll(l);
    }

    public A get(int i) {
      return list.get(i).s;
    }

    public int size() {
      return list.size();
    }

    public A set(int i, A s) {
      Elem<A> t = list.get(i);
      A old = t.s;
      if (eq(old, s))
        return old;
      removeFromIdx(t);
      t.s = s;
      addToIdx(t);
      return old;
    }

    public boolean add(A s) {
      ++modCount;
      Elem<A> t = new Elem();
      t.s = s;
      t.idx = size();
      list.add(t);
      addToIdx(t);
      return true;
    }

    public void add(int i, A s) {
      ++modCount;
      Elem<A> t = new Elem();
      t.s = s;
      t.idx = i;
      list.add(i, t);
      reorder(i + 1);
      addToIdx(t);
    }

    public boolean addAll(int i, Collection<? extends A> l) {
      int n = l.size();
      if (n == 0)
        return false;
      ++modCount;
      List<Elem<A>> l2 = emptyList(n);
      int j = i;
      for (A s : l) {
        Elem<A> t = new Elem();
        t.s = s;
        t.idx = j++;
        l2.add(t);
      }
      list.addAll(i, l2);
      reorder(i + n);
      for (Elem<A> t : l2) addToIdx(t);
      return true;
    }

    public A remove(int i) {
      ++modCount;
      Elem<A> t = list.get(i);
      removeFromIdx(t);
      list.remove(i);
      reorder(i);
      return t.s;
    }

    public void reorder(int fromIdx) {
      int n = size();
      for (int i = fromIdx; i < n; i++) list.get(i).idx = i;
    }

    public void removeFromIdx(Elem<A> t) {
      TreeSet<Elem<A>> idx = index.get(t.s);
      idx.remove(t);
      if (idx.isEmpty())
        index.remove(t.s);
    }

    public void addToIdx(Elem<A> t) {
      TreeSet<Elem<A>> idx = index.get(t.s);
      if (idx == null)
        index.put(t.s, idx = new TreeSet());
      idx.add(t);
    }

    @Override
    public int indexOf(Object s) {
      TreeSet<Elem<A>> l = index.get(s);
      return l == null ? -1 : first(l).idx;
    }

    @Override
    public int lastIndexOf(Object s) {
      TreeSet<Elem<A>> l = index.get(s);
      return l == null ? -1 : last(l).idx;
    }

    @Override
    public boolean contains(Object s) {
      return index.containsKey(s);
    }

    public void clear() {
      ++modCount;
      index.clear();
      list.clear();
    }

    public void removeRange(int fromIndex, int toIndex) {
      if (fromIndex == toIndex)
        return;
      ++modCount;
      for (int i = fromIndex; i < toIndex; i++) removeFromIdx(list.get(i));
      list.subList(fromIndex, toIndex).clear();
      reorder(fromIndex);
    }

    public int[] indicesOf(Object o) {
      TreeSet<Elem<A>> idx = index.get(o);
      if (idx == null)
        return emptyIntArray();
      int[] a = new int[idx.size()];
      int i = 0;
      for (Elem<A> t : idx) a[i++] = t.idx;
      return a;
    }

    public TreeSet<HasIndex> indicesOf_treeSetOfHasIndex(Object o) {
      return (TreeSet) index.get(o);
    }
  }

  static public class MRUCache<A, B> extends LinkedHashMap<A, B> {

    public int maxSize = 10;

    public MRUCache() {
    }

    public MRUCache(int maxSize) {
      this.maxSize = maxSize;
    }

    public boolean removeEldestEntry(Map.Entry eldest) {
      return size() > maxSize;
    }

    public Object _serialize() {
      return ll(maxSize, cloneLinkedHashMap(this));
    }

    static public MRUCache _deserialize(List l) {
      MRUCache m = new MRUCache();
      m.maxSize = (int) first(l);
      m.putAll((LinkedHashMap) second(l));
      return m;
    }
  }

  static abstract public class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {

    public void close() throws Exception {
    }
  }

  static public class ExpiringMap2<A, B> extends AbstractMap<A, B> {

    public Map<A, Pair<Long, B>> byKey = new HashMap();

    public PriorityBlockingQueue<Pair<Long, A>> queue = new PriorityBlockingQueue();

    public long standardExpiryTime;

    public boolean renewOnOverwrite = true, renewOnGet;

    public Object onChange;

    public ExpiringMap2() {
    }

    public ExpiringMap2(long standardExpiryTime) {
      this.standardExpiryTime = standardExpiryTime;
    }

    public ExpiringMap2(long standardExpiryTime, Object onChange) {
      this.onChange = onChange;
      this.standardExpiryTime = standardExpiryTime;
    }

    synchronized public boolean clean() {
      boolean changes = false;
      Pair<Long, A> p;
      while ((p = queue.peek()) != null && sysTime() >= p.a) {
        p = queue.poll();
        Pair<Long, B> v = byKey.get(p.b);
        if (v != null) {
          byKey.remove(p.b);
          changes = true;
          change();
        }
      }
      return changes;
    }

    public void change() {
      callF(onChange);
    }

    synchronized public B put(A a, B b) {
      clean();
      long timeout = sysTime() + standardExpiryTime;
      Pair<Long, B> p = byKey.get(a);
      if (p != null && renewOnOverwrite)
        queue.remove(new Pair(p.a, a));
      byKey.put(a, pair(timeout, b));
      change();
      if (p == null || renewOnOverwrite)
        queue.add(new Pair(timeout, a));
      return pairB(p);
    }

    synchronized public B remove(Object a) {
      clean();
      Pair<Long, B> p = byKey.get(a);
      if (p == null)
        return null;
      queue.remove(new Pair(p.a, a));
      byKey.remove(a);
      change();
      return p.b;
    }

    synchronized public B get(Object a) {
      clean();
      Pair<Long, B> p = byKey.get(a);
      if (renewOnGet && p != null) {
        queue.remove(new Pair(p.a, a));
        long timeout = sysTime() + standardExpiryTime;
        byKey.put((A) a, pair(timeout, p.b));
        queue.add(new Pair(timeout, a));
      }
      return pairB(p);
    }

    synchronized public Set<Map.Entry<A, B>> entrySet() {
      clean();
      return synchronizedSet(mapValues("pairB", byKey).entrySet());
    }

    synchronized public Set<A> keySet() {
      clean();
      return synchronizedSet(byKey.keySet());
    }

    synchronized public int size() {
      clean();
      return byKey.size();
    }

    public void setStandardExpiryTime(long ms) {
      standardExpiryTime = ms;
    }

    synchronized public ExpiringMap2<A, B> setMap(Map innerMap) {
      byKey = innerMap;
      return this;
    }
  }

  static public class ConceptFieldIndexCI<A extends Concept> implements IConceptIndex, IFieldIndex<A, String>, IConceptCounter {

    public Class<A> cc;

    public String field;

    public HashMap<A, String> objectToValue = new HashMap();

    public MultiSetMap<String, A> valueToObject = ciMultiSetMap();

    public ConceptFieldIndexCI() {
    }

    public ConceptFieldIndexCI(Class<A> cc, String field) {
      this(db_mainConcepts(), cc, field);
    }

    public ConceptFieldIndexCI(Concepts concepts, Class<A> cc, String field) {
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addCIFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    synchronized public void updateImpl(Concept c) {
      String newValue = (String) (cget(c, field));
      String oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      String value = (String) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    synchronized public A get(String value) {
      return valueToObject.getFirst(value);
    }

    public synchronized List<A> getAll(String value) {
      return cloneList(valueToObject.get(value));
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }

    public synchronized List<String> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public synchronized MultiSet<String> allValues_multiSet() {
      return multiSetMapToMultiSet(valueToObject);
    }

    public IterableIterator<A> objectIterator() {
      return navigableMultiSetMapValuesIterator(valueToObject);
    }
  }

  static public interface Producer<A> {

    public A next();
  }

  static public class InternationalPhoneValidator {

    public String rawInput;

    public String filtered;

    public List<CountryDialCode> dialCodes;

    public String countryPart, localPart;

    public boolean valid = false;

    public String error;

    public InternationalPhoneValidator() {
    }

    public InternationalPhoneValidator(String rawInput) {
      this.rawInput = rawInput;
    }

    public void run() {
      filtered = dropPrefix("+", dropSpecialChars(rawInput));
      if (!isAllDigits(filtered)) {
        error = "Bad characters";
        return;
      }
      splitLocal();
    }

    public String dropSpecialChars(String s) {
      return replaceAll(s, "[\\s\\(\\)\\-]", "");
    }

    public void splitLocal() {
      String countryPart = longestPrefixInNavigableSet(filtered, navigableKeys(countryDialCodes_rawNumbersTreeMultiMap()));
      if (countryPart == null) {
        error = "Invalid country code";
        return;
      }
      dialCodes = countryDialCodes_rawNumbersTreeMultiMap().get(countryPart);
      localPart = dropPrefix(countryPart, filtered);
      if (l(filtered) < 7) {
        error = "Phone number too short";
        return;
      } else if (l(filtered) > 15) {
        error = "Phone number too long";
        return;
      }
      valid = true;
    }
  }

  static public class AlphanumComparator implements Comparator<String> {

    public boolean ignoreCase = false;

    final public boolean isDigit(char ch) {
      return ((ch >= 48) && (ch <= 57));
    }

    final public String getChunk(String s, int slength, int marker) {
      StringBuilder chunk = new StringBuilder();
      char c = s.charAt(marker);
      chunk.append(c);
      marker++;
      if (isDigit(c))
        while (marker < slength) {
          c = s.charAt(marker);
          if (!isDigit(c))
            break;
          chunk.append(c);
          marker++;
        }
      else
        while (marker < slength) {
          c = s.charAt(marker);
          if (isDigit(c))
            break;
          chunk.append(c);
          marker++;
        }
      return chunk.toString();
    }

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int thisMarker = 0;
      int thatMarker = 0;
      int s1Length = s1.length();
      int s2Length = s2.length();
      while (thisMarker < s1Length && thatMarker < s2Length) {
        String thisChunk = getChunk(s1, s1Length, thisMarker);
        thisMarker += thisChunk.length();
        String thatChunk = getChunk(s2, s2Length, thatMarker);
        thatMarker += thatChunk.length();
        int result = 0;
        if (isDigit(thisChunk.charAt(0)) && isDigit(thatChunk.charAt(0))) {
          int thisChunkLength = thisChunk.length();
          result = thisChunkLength - thatChunk.length();
          if (result == 0) {
            for (int i = 0; i < thisChunkLength; i++) {
              result = thisChunk.charAt(i) - thatChunk.charAt(i);
              if (result != 0) {
                return result;
              }
            }
          }
        } else {
          result = thisChunk.compareTo(thatChunk);
        }
        if (result != 0)
          return result;
      }
      return s1Length - s2Length;
    }
  }

  static public class Cache<A> {

    public Object maker;

    public A value;

    public long loaded;

    static public boolean debug = false;

    public long changeCount;

    public Lock lock = lock();

    public Cache() {
    }

    public Cache(Object maker) {
      this.maker = maker;
    }

    public Cache(IF0<A> maker) {
      this.maker = maker;
    }

    public A get() {
      if (hasLock(lock))
        return value;
      Lock __0 = lock;
      lock(__0);
      try {
        if (loaded == 0) {
          value = make();
          changeCount++;
          loaded = sysNow();
        }
        return value;
      } finally {
        unlock(__0);
      }
    }

    public void clear() {
      Lock __1 = lock;
      lock(__1);
      try {
        if (debug && loaded != 0)
          print("Clearing cache");
        value = null;
        changeCount++;
        loaded = 0;
      } finally {
        unlock(__1);
      }
    }

    public void clear(double seconds) {
      Lock __2 = lock;
      lock(__2);
      try {
        if (seconds != 0 && loaded != 0 && sysNow() >= loaded + seconds * 1000)
          clear();
      } finally {
        unlock(__2);
      }
    }

    public void set(A a) {
      Lock __3 = lock;
      lock(__3);
      try {
        value = a;
        ++changeCount;
        loaded = sysNow();
      } finally {
        unlock(__3);
      }
    }

    public A make() {
      return (A) callF(maker);
    }
  }

  static public interface IContentsIndexedList2<A> extends List<A> {

    public TreeSet<HasIndex> indicesOf_treeSetOfHasIndex(Object o);
  }

  static public class MultiSetMap<A, B> {

    public Map<A, Set<B>> data = new HashMap<A, Set<B>>();

    public int size;

    public MultiSetMap() {
    }

    public MultiSetMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiSetMap(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public MultiSetMap(Map<A, Set<B>> data) {
      this.data = data;
    }

    public boolean put(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        if (!set.add(value))
          return false;
        {
          ++size;
          return true;
        }
      }
    }

    public boolean add(A key, B value) {
      return put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      synchronized (data) {
        putAll(key, values);
      }
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) put(key, value);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public Set<B> get(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        return set == null ? Collections.<B>emptySet() : set;
      }
    }

    public Set<B> getOpt(A key) {
      synchronized (data) {
        return data.get(key);
      }
    }

    public Set<B> getActual(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        return set;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        Set<B> list = data.get(key);
        if (list != null && list.isEmpty())
          data.remove(key);
      }
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public Set<A> keys() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        size -= l(data.get(key));
        data.remove(key);
      }
    }

    public void remove(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set != null) {
          if (set.remove(value)) {
            --size;
            if (set.isEmpty())
              data.remove(key);
          }
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
        size = 0;
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        return first(get(key));
      }
    }

    public void addAll(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiSetMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    public int size() {
      synchronized (data) {
        return size;
      }
    }

    public int getSize(A key) {
      return l(data.get(key));
    }

    public int count(A key) {
      return getSize(key);
    }

    public Set<A> reverseGet(B b) {
      synchronized (data) {
        Set<A> l = new HashSet();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, Set<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public Set<B> _makeEmptySet() {
      return new HashSet();
    }

    public Collection<Set<B>> allLists() {
      synchronized (data) {
        return new HashSet(data.values());
      }
    }

    public List<B> allValues() {
      return concatLists(values(data));
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }

    public Pair<A, B> firstEntry() {
      if (empty(data))
        return null;
      Map.Entry<A, Set<B>> entry = data.entrySet().iterator().next();
      return pair(entry.getKey(), first(entry.getValue()));
    }
  }

  static public interface IConceptCounter {

    public Class<? extends Concept> conceptClass();

    public int countConcepts();

    public Collection<Concept> allConcepts();
  }

  static public interface IContentsIndexedList<A> extends List<A> {

    public int[] indicesOf(Object o);
  }

  abstract static public class RandomAccessAbstractList<A> extends AbstractList<A> implements RandomAccess {
  }

  static public class HasIndex implements Comparable<HasIndex> {

    public int idx;

    public HasIndex() {
    }

    public HasIndex(int idx) {
      this.idx = idx;
    }

    public int compareTo(HasIndex h) {
      return idx - h.idx;
    }
  }

  static public Object subBot_serveRedirect(String url) {
    return call(getMainBot(), "serveRedirect", url);
  }

  static public String fullSelfLink(Map<String, String> params) {
    return getActualURI() + htmlQuery(params);
  }

  static public String fullSelfLink() {
    return getActualURI();
  }

  static public byte[] saveFile(String fileName, byte[] contents) {
    return saveBinaryFile(fileName, contents);
  }

  static public byte[] saveFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName, contents);
  }

  static public byte[] decodeBASE64(String s) {
    return base64decode(s);
  }

  static public String loadJQuery() {
    return "<script src=\"https://code.jquery.com/jquery-1.10.2.js\"></script>";
  }

  static public String hhead_title_htmldecode(String title) {
    return hhead_title_decode(title);
  }

  static public String hquery(Map params) {
    return htmlQuery(params);
  }

  static public String hquery(Object... data) {
    return htmlQuery(data);
  }

  static public String afterLastSlash(String s) {
    if (s == null)
      return null;
    int i = s.lastIndexOf('/');
    return i < 0 ? s : substring(s, i + 1);
  }

  static public Map prependEmptyOptionForHSelect(Map map) {
    Map map2 = litorderedmap("", "");
    putAll(map2, map);
    return map2;
  }

  static public LinkedHashMap mapToOrderedMap(Object f, Iterable l) {
    LinkedHashMap map = new LinkedHashMap();
    for (Object o : unnull(l)) {
      Pair p = (Pair) (callF(f, o));
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
    LinkedHashMap<B, C> map = new LinkedHashMap();
    for (A o : unnull(l)) {
      Pair<B, C> p = callF(f, o);
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(Iterable<A> l, IF1<A, Pair<B, C>> f) {
    return mapToOrderedMap(f, l);
  }

  static public boolean conceptsSortedByFieldCI_verbose = false;

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Class<A> c, String field) {
    return conceptsSortedByFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexCI)
      return (Collection<A>) asList(((ConceptFieldIndexCI) index).objectIterator());
    if (conceptsSortedByFieldCI_verbose)
      print("conceptsSortedByFieldCI_verbose: Manual sort of " + c + " for " + field);
    return sortedByFieldIC(field, concepts.list(c));
  }

  static public String hscriptsrc(String src) {
    return hjavascript_src(src);
  }

  static public boolean conceptsWithFieldGreaterThan_verbose = false;

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Class<A> c, String field, Object value) {
    return conceptsWithFieldGreaterThan(db_mainConcepts(), c, field, value);
  }

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Concepts concepts, Class<A> c, String field, Object value) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc)
      return ((ConceptFieldIndexDesc) index).objectsWithValueGreaterThan(value);
    if (conceptsWithFieldGreaterThan_verbose)
      print("conceptsWithFieldGreaterThan: table scan of " + c + " for field " + field);
    return objectsWhereFieldGreaterThan(concepts.list(c), field, value);
  }

  static public String hhiddenWithID(String id) {
    return hhiddenWithID(id, null);
  }

  static public String hhiddenWithID(String id, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", id, "value", value));
  }

  static public String hsimpletableheader(String... cols) {
    return tag("tr", join(lambdaMap(__63 -> th(__63), cols)));
  }

  static public <A> List<A> lastTwo(List<A> l) {
    return takeLast(2, l);
  }

  static public String renderHowLongAgo(long timestamp) {
    if (timestamp == 0)
      return "never";
    int seconds = howManySecondsAgo(timestamp);
    if (seconds <= 0)
      return "just now";
    if (seconds < 60)
      return n2(seconds, "second") + " ago";
    int minutes = iround(seconds / 60.0);
    if (minutes < 60)
      return n2(minutes, "minute") + " ago";
    int hours = iround(minutes / 60.0);
    if (hours < 24)
      return n2(hours, "hour") + " ago";
    int days = iround(hours / 24.0);
    return n2(days, "day") + " ago";
  }

  static public String hparagraphs(Collection<String> l) {
    return lines(lambdaMap(__64 -> p(__64), l));
  }

  static public String hscript_clickableRows() {
    return hscript("\r\n    jQuery(document).ready(function($) {\r\n      $(\".clickable-row\").click(function() {\r\n        window.location = $(this).data(\"href\");\r\n      });\r\n    });\r\n  ");
  }

  static public String hcheckboxWithText(String name, String text, boolean checked, Object... params) {
    String id = randomID();
    return hcheckbox(name, checked, paramsPlus(params, "id", id)) + " " + hlabelFor(id, htmlEncode2(text));
  }

  static public String hcheckboxWithText(String name, String text) {
    return hcheckboxWithText(name, text, false);
  }

  static public String hdivWithID(String id, Object contents, Object... params) {
    return hdiv(contents, paramsPlus(params, "id", id));
  }

  static public String hdesktopNotifications() {
    return hscript("\r\n    function sendDesktopNotification(text, options) {\r\n      if (\"Notification\" in window && Notification.permission === \"granted\")\r\n        new Notification(text, options);\r\n    }\r\n    window.sendDesktopNotification = sendDesktopNotification;\r\n    \r\n    function initDesktopNotifications() {\r\n      if (!(\"Notification\" in window))\r\n        $(\"#notiStatus\").html(\"Desktop notifications not supported in this browser\");\r\n      else if (Notification.permission === \"granted\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications enabled\");\r\n      else if (Notification.permission === \"denied\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications denied\");\r\n      else {\r\n        $(\"#notiStatus\").html(\"Requesting permission for desktop notifications\");\r\n        Notification.requestPermission().then(function (permission) {\r\n          initDesktopNotifications();\r\n          sendDesktopNotification(\"Notifications will look like this!\");\r\n        });\r\n      }\r\n    }\r\n    \r\n    $(document).ready(initDesktopNotifications);\r\n  ");
  }

  static public String hframeset_cols(String cols, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "cols", cols));
  }

  static public String hframeset_rows(String rows, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "rows", rows));
  }

  static public String htmlEncode2If(boolean b, String s) {
    return b ? htmlEncode2(s) : s;
  }

  static public JPanel centerAndSouthWithMargins(Component c, Component s) {
    return applyDefaultMargin(centerAndSouth(c, withTopMargin(s)));
  }

  static public JPanel jrightalignedline(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jrightalignedline(List<Component> components) {
    return jrightAlignedLine(components);
  }

  static public JCheckBox dm_fieldCheckBox(String field) {
    return dm_fieldCheckBox(humanizeFormLabel(field), field);
  }

  static public JCheckBox dm_fieldCheckBox(String text, String field) {
    if (isIdentifier(text) && !isIdentifier(field)) {
      String temp = field;
      field = text;
      text = temp;
    }
    return jLiveValueCheckBox(text, dm_fieldLiveValue(field));
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  static public void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  static public File tempDir() {
    return makeTempDir();
  }

  static public File createTempFile() {
    return createTempFile("tmp", null);
  }

  static public File createTempFile(String prefix, String suffix) {
    try {
      prefix = nohup_sanitize(prefix);
      suffix = nohup_sanitize(suffix);
      if (shouldKeepTempFiles())
        return mkdirsForFile(javaxCachesDir("Temp/" + prefix + "-" + randomID() + "-" + suffix));
      File f = File.createTempFile(takeFirst(10, pad(prefix, 3, '-')), suffix);
      f.deleteOnExit();
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap lithashmap(Object... x) {
    return litmap(x);
  }

  static public <A> A wrapStuff(String name, A object, Object... args) {
    return or((A) callOpt(mc(), "_wrap", object, asList(args)), object);
  }

  static public void printMyIPs() {
    String ip;
    try {
      Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
      while (interfaces.hasMoreElements()) {
        NetworkInterface iface = interfaces.nextElement();
        if (iface.isLoopback() || !iface.isUp())
          continue;
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        while (addresses.hasMoreElements()) {
          InetAddress addr = addresses.nextElement();
          ip = addr.getHostAddress();
          if (ip.startsWith("127."))
            continue;
          boolean local = addr.isSiteLocalAddress() || ip.startsWith("fe");
          System.out.println(iface.getDisplayName() + " " + ip + " " + (local ? "(private address)" : "(public address)"));
        }
      }
    } catch (Throwable e) {
      e.printStackTrace();
    }
  }

  static public Type getRawType(Type t) {
    if (t instanceof ParameterizedType)
      return ((ParameterizedType) t).getRawType();
    return t;
  }

  static public <A> void remove(List<A> l, int i) {
    if (l != null && i >= 0 && i < l(l))
      l.remove(i);
  }

  static public <A> void remove(Collection<A> l, A a) {
    if (l != null)
      l.remove(a);
  }

  static public <A, B> Set<A> keySet(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keySet(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A> A reverseGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    int n = l(l);
    return idx < n ? l.get(n - 1 - idx) : null;
  }

  static public int hashOfLong(long l) {
    return Long.hashCode(l);
  }

  static public int length(Object[] array) {
    return array == null ? 0 : array.length;
  }

  static public int length(List list) {
    return list == null ? 0 : list.size();
  }

  static public int length(String s) {
    return s == null ? 0 : s.length();
  }

  static public <A, B> MultiSetMap<A, B> treeMultiSetMap() {
    return new MultiSetMap(true);
  }

  static public <A, B> MultiSetMap<A, B> treeMultiSetMap(Comparator<A> comparator) {
    return new MultiSetMap(new TreeMap<A, Set<B>>(comparator));
  }

  static public Comparator reverseOrder() {
    return new Comparator() {

      public int compare(Object a, Object b) {
        return cmp(b, a);
      }
    };
  }

  static public <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
    return lookupAllOpt(map, l);
  }

  static public <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public <A, B> List<A> cloneKeys_noSync(Map<A, B> map) {
    return cloneList_noSync(keys(map));
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm) {
    return navigableMultiSetMapValuesIterator_concurrent(mm, mm.data);
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm, Object mutex) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data, mutex);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  static public <A, B> MultiSet<A> multiSetMapToMultiSet(MultiSetMap<A, B> mm) {
    MultiSet<A> ms = new MultiSet();
    for (A a : keys(mm)) ms.add(a, l(mm.get(a)));
    return ms;
  }

  static public Collection<Concept> allConcepts() {
    return db_mainConcepts().allConcepts();
  }

  static public Collection<Concept> allConcepts(Concepts concepts) {
    return concepts.allConcepts();
  }

  static public String defaultTimerName_name;

  static public String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  static public Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

  static public void _registerTimer(java.util.Timer timer) {
    _registerTimer_list.add(timer);
  }

  static public void cleanMeUp__registerTimer() {
    cancelTimers(getAndClearList(_registerTimer_list));
  }

  static public int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public UnsupportedOperationException unsupportedOperation() {
    throw new UnsupportedOperationException();
  }

  static public <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
    return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
  }

  static public long sysTime() {
    return sysNow();
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    return mapValues((Object) f, map);
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public <A> MultiSetMap<String, A> ciMultiSetMap() {
    MultiSetMap<String, A> mm = new MultiSetMap();
    mm.data = ciMap();
    return mm;
  }

  static public <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator(final MultiSetMap<A, B> mm) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  static public boolean isAllDigits(String s) {
    int n = l(s);
    for (int i = 0; i < n; i++) if (!isDigit(s.charAt(i)))
      return false;
    return true;
  }

  static public <A> List<A> replaceAll(List<A> l, final A a, final A b) {
    return map(l, new F1<A, A>() {

      public A get(A x) {
        try {
          return eq(x, a) ? b : x;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "eq(x, a) ? b : x";
      }
    });
  }

  static public String replaceAll(String s, String a, String b) {
    return s == null ? null : s.replaceAll(a, b);
  }

  static public String longestPrefixInNavigableSet(String s, NavigableSet<String> set) {
    if (set == null || s == null)
      return null;
    while (licensed()) {
      String key = set.floor(s);
      if (key == null)
        break;
      int n = lCommonPrefix(key, s);
      if (n == l(key))
        return key;
      s = takeFirst(s, n);
    }
    return null;
  }

  static public <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
    return map == null ? new TreeSet() : map.navigableKeySet();
  }

  static public <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }

  static public <A, B> NavigableSet<A> navigableKeys(MultiMap<A, B> mm) {
    return ((NavigableMap) mm.data).navigableKeySet();
  }

  static public Cache<MultiMap<String, CountryDialCode>> countryDialCodes_rawNumbersTreeMultiMap_cache = new Cache<>(() -> countryDialCodes_rawNumbersTreeMultiMap_load());

  static public MultiMap<String, CountryDialCode> countryDialCodes_rawNumbersTreeMultiMap() {
    return countryDialCodes_rawNumbersTreeMultiMap_cache.get();
  }

  static public MultiMap<String, CountryDialCode> countryDialCodes_rawNumbersTreeMultiMap_load() {
    return mapToMultiMap(mapKeys(__65 -> digitsOnly(__65), multiMapToMap(countryDialCodesMultiMap())));
  }

  static public boolean hasLock(Lock lock) {
    return ((ReentrantLock) lock).isHeldByCurrentThread();
  }

  static public Set emptySet() {
    return new HashSet();
  }

  static public String getActualURI() {
    return (String) call(getMainBot(), "getActualURI");
  }

  static public String hhead_title_decode(String title) {
    return hhead_title(htmldecode_dropAllTags(title));
  }

  static public <A> List<A> sortedByFieldIC(Collection<A> c, final String field) {
    List<A> l = new ArrayList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return compareIC((String) getOpt(a, field), (String) getOpt(b, field));
      }
    });
    return l;
  }

  static public <A> List<A> sortedByFieldIC(String field, Collection<A> c) {
    return sortedByFieldIC(c, field);
  }

  static public String hjavascript_src(String src) {
    return tag("script", "", "src", src);
  }

  static public <A> List<A> objectsWhereFieldGreaterThan(Collection<A> c, String field, Object value) {
    List<A> l = new ArrayList();
    for (A x : unnull(c)) if (cmp(getOpt(x, field), value) > 0)
      l.add(x);
    return l;
  }

  static public String th(Object contents, Object... params) {
    return tag("th", contents, params);
  }

  static public int howManySecondsAgo(long timestamp) {
    return iround(toSeconds(now() - timestamp));
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public String hdiv(Object contents, Object... params) {
    return div(contents, params);
  }

  static public <A extends JComponent> A applyDefaultMargin(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth, withMargin_defaultWidth));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setBorder(BorderFactory.createEmptyBorder(withMargin_defaultWidth, withMarg...";
        }
      });
    }
    return c;
  }

  static public JPanel centerAndSouth(final Component c, final Component s) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          if (s != null)
            panel.add(BorderLayout.SOUTH, wrap(s));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public int withTopMargin_defaultWidth = 6;

  static public JPanel withTopMargin(Component c) {
    return withTopMargin(withTopMargin_defaultWidth, c);
  }

  static public JPanel withTopMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public JPanel jrightAlignedLine(final Component... components) {
    return swing(new F0<RightAlignedLine>() {

      public RightAlignedLine get() {
        try {
          return new RightAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret RightAlignedLine(components);";
      }
    });
  }

  static public JPanel jrightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(asArray(Component.class, components));
  }

  static public JCheckBox jLiveValueCheckBox(String text, final SimpleLiveValue<Boolean> lv) {
    final JCheckBox cb = jCheckBox(text);
    bindCheckBoxToLiveValue(cb, lv);
    return cb;
  }

  static public SimpleLiveValue dm_fieldLiveValue(String fieldName) {
    return dm_fieldLiveValue(dm_current_mandatory(), fieldName);
  }

  static public SimpleLiveValue dm_fieldLiveValue(final DynModule module, final String fieldName) {
    Lock __0 = module.lock;
    lock(__0);
    try {
      AutoCloseable __2 = module.enter();
      try {
        Class type = getFieldType(module, fieldName);
        final SimpleLiveValue value = new SimpleLiveValue(type, get(module, fieldName));
        dm_watchField(fieldName, new Runnable() {

          public void run() {
            try {
              Object o = get(module, fieldName);
              value.set(o);
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting \" + fi...";
          }
        });
        value.onChange(new Runnable() {

          public void run() {
            try {
              module.setField(fieldName, value.get());
              ;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "ifdef dm_fieldLiveValue_debug\r\n      print(\"dm_fieldLiveValue: setting 2 \" + ...";
          }
        });
        return value;
      } finally {
        _close(__2);
      }
    } finally {
      unlock(__0);
    }
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache(((Class) o));
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }

  static public String nohup_sanitize(String s) {
    return empty(s) ? s : takeFirst(50, s.replaceAll("[^.a-zA-Z0-9\\-_]", ""));
  }

  static public IF0<Boolean> shouldKeepTempFiles;

  static public boolean shouldKeepTempFiles() {
    return shouldKeepTempFiles != null ? shouldKeepTempFiles.get() : shouldKeepTempFiles_base();
  }

  final static public boolean shouldKeepTempFiles_fallback(IF0<Boolean> _f) {
    return _f != null ? _f.get() : shouldKeepTempFiles_base();
  }

  static public boolean shouldKeepTempFiles_base() {
    return false;
  }

  static public String pad(Object s, int l) {
    return pad(s, l, ' ');
  }

  static public String pad(Object s, int l, char c) {
    String _s = str(s);
    if (lengthOfString(_s) >= l)
      return _s;
    return rep(c, l - lengthOfString(_s)) + _s;
  }

  static public <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
    List<B> out = new ArrayList();
    if (l != null)
      for (A a : l) addIfNotNull(out, map.get(a));
    return out;
  }

  static public <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public <A> ArrayList<A> cloneList_noSync(Iterable<A> l) {
    return l instanceof Collection ? cloneList_noSync((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList_noSync(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    return new ArrayList<A>(l);
  }

  static public <A> IterableIterator<A> iteratorFromFunction(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = (A) callF(f);
        done = a == null;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction(final F0<A> f) {
    return iteratorFromFunction_f0(f);
  }

  static public <A, B> IterableIterator<B> concurrentlyIterateValues(NavigableMap<A, B> map) {
    return concurrentlyIterateValues(map, map);
  }

  static public <A, B> IterableIterator<B> concurrentlyIterateValues(final NavigableMap<A, B> map, Object mutex) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<A> it = keys(map).iterator();

      public A key;

      public B get() {
        synchronized (mutex) {
          try {
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          } catch (ConcurrentModificationException e) {
            print("Re-iterating");
            it = map.tailMap(key, false).keySet().iterator();
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          }
        }
      }
    });
  }

  static public <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  static public void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  static public <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  static public <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }

  static public int lCommonPrefix(String a, String b) {
    int i = 0, n = min(l(a), l(b));
    while (i < n && a.charAt(i) == b.charAt(i)) ++i;
    return i;
  }

  static public <A, B, C extends Collection<B>> MultiMap<A, B> mapToMultiMap(Map<A, C> map) {
    if (map == null)
      return null;
    MultiMap<A, B> mm = similarEmptyMultiMap(map);
    for (A key : keys(map)) {
      Collection<B> values = map.get(key);
      mm.putAll(key, values);
    }
    return mm;
  }

  static public String digitsOnly(String s) {
    return filterChars(__66 -> isDigit(__66), s);
  }

  static public int withMargin_defaultWidth = 6;

  static public JPanel withMargin(Component c) {
    return withMargin(withMargin_defaultWidth, c);
  }

  static public JPanel withMargin(int w, Component c) {
    return withMargin(w, w, c);
  }

  static public JPanel withMargin(int w, int h, Component c) {
    return withMargin(w, h, w, h, c);
  }

  static public JPanel withMargin(final int top, final int left, final int bottom, final int right, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public String htmldecode_dropAllTags(String html) {
    return htmldecode(dropAllTags(html));
  }

  static public int compareIC(String s1, String s2) {
    return compareIgnoreCase_jdk(s1, s2);
  }

  static public Object[] asArray(List l) {
    return toObjectArray(l);
  }

  static public <A> A[] asArray(Class<A> type, List l) {
    return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
  }

  static public JCheckBox jCheckBox() {
    return swingNu(JCheckBox.class);
  }

  static public JCheckBox jCheckBox(boolean checked) {
    return swingNu(JCheckBox.class, "", checked);
  }

  static public JCheckBox jCheckBox(String text, boolean checked) {
    return swingNu(JCheckBox.class, text, checked);
  }

  static public JCheckBox jCheckBox(String text) {
    return swingNu(JCheckBox.class, text);
  }

  static public JCheckBox jCheckBox(String text, boolean checked, final Object onChange) {
    JCheckBox cb = jCheckBox(checked, onChange);
    cb.setText(text);
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, final Object onChange) {
    final JCheckBox cb = jCheckBox(checked);
    cb.addChangeListener(new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(onChange, cb.isSelected());
      }
    });
    return cb;
  }

  static public <A extends JCheckBox> A bindCheckBoxToLiveValue(final A cb, final SimpleLiveValue<Boolean> lv) {
    bindLiveValueListenerToComponent(cb, lv, new Runnable() {

      public void run() {
        try {
          setChecked(cb, isTrue(lv.get()));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    onChange(cb, new Runnable() {

      public void run() {
        try {
          lv.set(isChecked(cb));
          ;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ifdef bindCheckBoxToLiveValue_debug\r\n      print(\"bindCheckBoxToLiveValue: se...";
      }
    });
    return cb;
  }

  static public Class getFieldType(Object o, String field) {
    return fieldType(o, field);
  }

  static public void dm_watchField(String field, Runnable onChange) {
    new Dyn_FieldWatcher(dm_current_mandatory(), field, onChange);
  }

  static public int lengthOfString(String s) {
    return s == null ? 0 : s.length();
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }
    }
    ;
    return new IFF2();
  }

  static public <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  static public void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  static public void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public MultiMap similarEmptyMultiMap(MultiMap m) {
    return similarEmptyMultiMap(m == null ? null : m.data);
  }

  static public MultiMap similarEmptyMultiMap(Map m) {
    MultiMap mm = new MultiMap();
    if (m != null)
      mm.data = similarEmptyMap(m);
    return mm;
  }

  static public String filterChars(IF1<Character, Boolean> pred, String s) {
    if (s == null)
      return null;
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    char c;
    for (int i = 0; i < n; i++) if (isTrue(callF(pred, c = s.charAt(i))))
      buf.append(c);
    return str(buf);
  }

  static public String htmldecode(final String input) {
    if (input == null)
      return null;
    final int MIN_ESCAPE = 2;
    final int MAX_ESCAPE = 6;
    StringWriter writer = null;
    int len = input.length();
    int i = 1;
    int st = 0;
    while (true) {
      while (i < len && input.charAt(i - 1) != '&') i++;
      if (i >= len)
        break;
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';') j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
        i++;
        continue;
      }
      if (input.charAt(i) == '#') {
        int k = i + 1;
        int radix = 10;
        final char firstChar = input.charAt(k);
        if (firstChar == 'x' || firstChar == 'X') {
          k++;
          radix = 16;
        }
        try {
          int entityValue = Integer.parseInt(input.substring(k, j), radix);
          if (writer == null)
            writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));
          if (entityValue > 0xFFFF) {
            final char[] chrs = Character.toChars(entityValue);
            writer.write(chrs[0]);
            writer.write(chrs[1]);
          } else {
            writer.write(entityValue);
          }
        } catch (NumberFormatException ex) {
          i++;
          continue;
        }
      } else {
        CharSequence value = htmldecode_lookupMap.get(input.substring(i, j));
        if (value == null) {
          i++;
          continue;
        }
        if (writer == null)
          writer = new StringWriter(input.length());
        writer.append(input.substring(st, i - 1));
        writer.append(value);
      }
      st = j + 1;
      i = st;
    }
    if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
    }
    return input;
  }

  static final public String[][] htmldecode_ESCAPES = { { "\"", "quot" }, { "&", "amp" }, { "<", "lt" }, { ">", "gt" }, { "\u00A0", "nbsp" }, { "\u00A1", "iexcl" }, { "\u00A2", "cent" }, { "\u00A3", "pound" }, { "\u00A4", "curren" }, { "\u00A5", "yen" }, { "\u00A6", "brvbar" }, { "\u00A7", "sect" }, { "\u00A8", "uml" }, { "\u00A9", "copy" }, { "\u00AA", "ordf" }, { "\u00AB", "laquo" }, { "\u00AC", "not" }, { "\u00AD", "shy" }, { "\u00AE", "reg" }, { "\u00AF", "macr" }, { "\u00B0", "deg" }, { "\u00B1", "plusmn" }, { "\u00B2", "sup2" }, { "\u00B3", "sup3" }, { "\u00B4", "acute" }, { "\u00B5", "micro" }, { "\u00B6", "para" }, { "\u00B7", "middot" }, { "\u00B8", "cedil" }, { "\u00B9", "sup1" }, { "\u00BA", "ordm" }, { "\u00BB", "raquo" }, { "\u00BC", "frac14" }, { "\u00BD", "frac12" }, { "\u00BE", "frac34" }, { "\u00BF", "iquest" }, { "\u00C0", "Agrave" }, { "\u00C1", "Aacute" }, { "\u00C2", "Acirc" }, { "\u00C3", "Atilde" }, { "\u00C4", "Auml" }, { "\u00C5", "Aring" }, { "\u00C6", "AElig" }, { "\u00C7", "Ccedil" }, { "\u00C8", "Egrave" }, { "\u00C9", "Eacute" }, { "\u00CA", "Ecirc" }, { "\u00CB", "Euml" }, { "\u00CC", "Igrave" }, { "\u00CD", "Iacute" }, { "\u00CE", "Icirc" }, { "\u00CF", "Iuml" }, { "\u00D0", "ETH" }, { "\u00D1", "Ntilde" }, { "\u00D2", "Ograve" }, { "\u00D3", "Oacute" }, { "\u00D4", "Ocirc" }, { "\u00D5", "Otilde" }, { "\u00D6", "Ouml" }, { "\u00D7", "times" }, { "\u00D8", "Oslash" }, { "\u00D9", "Ugrave" }, { "\u00DA", "Uacute" }, { "\u00DB", "Ucirc" }, { "\u00DC", "Uuml" }, { "\u00DD", "Yacute" }, { "\u00DE", "THORN" }, { "\u00DF", "szlig" }, { "\u00E0", "agrave" }, { "\u00E1", "aacute" }, { "\u00E2", "acirc" }, { "\u00E3", "atilde" }, { "\u00E4", "auml" }, { "\u00E5", "aring" }, { "\u00E6", "aelig" }, { "\u00E7", "ccedil" }, { "\u00E8", "egrave" }, { "\u00E9", "eacute" }, { "\u00EA", "ecirc" }, { "\u00EB", "euml" }, { "\u00EC", "igrave" }, { "\u00ED", "iacute" }, { "\u00EE", "icirc" }, { "\u00EF", "iuml" }, { "\u00F0", "eth" }, { "\u00F1", "ntilde" }, { "\u00F2", "ograve" }, { "\u00F3", "oacute" }, { "\u00F4", "ocirc" }, { "\u00F5", "otilde" }, { "\u00F6", "ouml" }, { "\u00F7", "divide" }, { "\u00F8", "oslash" }, { "\u00F9", "ugrave" }, { "\u00FA", "uacute" }, { "\u00FB", "ucirc" }, { "\u00FC", "uuml" }, { "\u00FD", "yacute" }, { "\u00FE", "thorn" }, { "\u00FF", "yuml" }, { "\u2013", "ndash" }, { "\u2018", "lsquo" }, { "\u2019", "rsquo" }, { "\u201D", "rdquo" }, { "\u201C", "ldquo" }, { "\u2014", "mdash" }, { "'", "apos" } };

  static final public HashMap<String, CharSequence> htmldecode_lookupMap;

  static {
    htmldecode_lookupMap = new HashMap<String, CharSequence>();
    for (final CharSequence[] seq : htmldecode_ESCAPES) htmldecode_lookupMap.put(seq[1].toString(), seq[0]);
  }

  static public int compareIgnoreCase_jdk(String s1, String s2) {
    if (s1 == null)
      return s2 == null ? 0 : -1;
    if (s2 == null)
      return 1;
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
      char c1 = s1.charAt(i);
      char c2 = s2.charAt(i);
      if (c1 != c2) {
        c1 = Character.toUpperCase(c1);
        c2 = Character.toUpperCase(c2);
        if (c1 != c2) {
          c1 = Character.toLowerCase(c1);
          c2 = Character.toLowerCase(c2);
          if (c1 != c2)
            return c1 - c2;
        }
      }
    }
    return n1 - n2;
  }

  static public <A> A swingNu(final Class<A> c, final Object... args) {
    return swingConstruct(c, args);
  }

  static public <A extends JComponent> A bindLiveValueListenerToComponent(A component, final LiveValue lv, final Runnable listener) {
    if (lv != null)
      bindToComponent(component, new Runnable() {

        public void run() {
          try {
            lv.onChangeAndNow(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef bindLiveValueListenerToComponent_debug\r\n          print(\"bindLiveValueL...";
        }
      }, new Runnable() {

        public void run() {
          try {
            lv.removeOnChangeListener(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lv.removeOnChangeListener(listener)";
        }
      });
    return component;
  }

  static public void setChecked(JCheckBox checkBox, boolean b) {
    if (checkBox != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (isChecked(checkBox) != b)
              checkBox.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (isChecked(checkBox) != b)\r\n      checkBox.setSelected(b);";
        }
      });
    }
  }

  static public void setChecked(JCheckBoxMenuItem mi, boolean b) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setSelected(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setSelected(b);";
        }
      });
    }
  }

  static public <A extends JSpinner> A onChange(A spinner, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            spinner.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "spinner.addChangeListener(changeListener(r));";
        }
      });
    }
    return spinner;
  }

  static public <A extends AbstractButton> A onChange(A b, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            b.addItemListener(itemListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addItemListener(itemListener(r));";
        }
      });
    }
    return b;
  }

  static public void onChange(JTextComponent tc, Object r) {
    onUpdate(tc, r);
  }

  static public <A extends JSlider> A onChange(A slider, final Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            slider.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "slider.addChangeListener(changeListener(r));";
        }
      });
    }
    return slider;
  }

  static public JComboBox onChange(Object r, JComboBox cb) {
    return onChange(cb, r);
  }

  static public JComboBox onChange(JComboBox cb, final Object r) {
    if (isEditableComboBox(cb))
      onChange(textFieldFromComboBox(cb), r);
    else
      onSelectedItem(cb, new VF1<String>() {

        public void get(String s) {
          try {
            callF(r);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r)";
        }
      });
    return cb;
  }

  static public ChangeListener changeListener(final Object r) {
    return new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(r);
      }
    };
  }

  static public ItemListener itemListener(final Object r) {
    return new ItemListener() {

      public void itemStateChanged(ItemEvent e) {
        pcallF(r);
      }
    };
  }

  static public void onUpdate(JComponent c, final Object r) {
    if (c instanceof JTextComponent)
      ((JTextComponent) c).getDocument().addDocumentListener(new DocumentListener() {

        public void insertUpdate(DocumentEvent e) {
          call(r);
        }

        public void removeUpdate(DocumentEvent e) {
          call(r);
        }

        public void changedUpdate(DocumentEvent e) {
          call(r);
        }
      });
    else if (c instanceof ItemSelectable)
      ((ItemSelectable) c).addItemListener(new ItemListener() {

        public void itemStateChanged(ItemEvent e) {
          call(r);
        }
      });
    else
      print("Warning: onUpdate doesn't know " + getClassName(c));
  }

  static public void onUpdate(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
  }

  static public boolean isEditableComboBox(final JComboBox cb) {
    return cb != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return cb.isEditable();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret cb.isEditable();";
      }
    });
  }

  static public JTextField textFieldFromComboBox(JComboBox cb) {
    return (JTextField) cb.getEditor().getEditorComponent();
  }

  static public JComboBox onSelectedItem(final JComboBox cb, final VF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public String selectedItem(JList l) {
    return getSelectedItem(l);
  }

  static public String selectedItem(JComboBox cb) {
    return getSelectedItem(cb);
  }

  static public class SimpleLiveValue<A> extends LiveValue<A> {

    public Class<A> type;

    volatile public A value;

    transient public List onChange = synchroList();

    public SimpleLiveValue(Class<A> type) {
      this.type = type;
    }

    public SimpleLiveValue(Class<A> type, A value) {
      this.value = value;
      this.type = type;
    }

    public Class<A> getType() {
      return type;
    }

    public A get() {
      return value;
    }

    public void onChange(Runnable l) {
      onChange.add(l);
    }

    public void onChangeAndNow(Runnable l) {
      onChange(l);
      callF(l);
    }

    public void removeOnChangeListener(Runnable l) {
      onChange.remove(l);
    }

    public void fireChanged() {
      pcallFAll(onChange);
    }

    public void set(A a) {
      if (neq(value, a)) {
        value = a;
        fireChanged();
      }
    }
  }

  static abstract public class LiveValue<A> {

    abstract public Class<A> getType();

    abstract public A get();

    abstract public void onChange(Runnable l);

    abstract public void removeOnChangeListener(Runnable l);

    public void onChangeAndNow(Runnable l) {
      onChange(l);
      callF(l);
    }
  }

  static public class Dyn_FieldWatcher {

    public DynModule module;

    public String field;

    public Object value;

    public Runnable action;

    transient public IF1<Object, Object> cloneValue;

    public Object cloneValue(Object o) {
      return cloneValue != null ? cloneValue.get(o) : cloneValue_base(o);
    }

    final public Object cloneValue_fallback(IF1<Object, Object> _f, Object o) {
      return _f != null ? _f.get(o) : cloneValue_base(o);
    }

    public Object cloneValue_base(Object o) {
      return o;
    }

    public Dyn_FieldWatcher(DynModule module, String field, Runnable action) {
      this(module, field, action, null);
    }

    public Dyn_FieldWatcher(DynModule module, String field, Runnable action, IF1 cloneValue) {
      this.cloneValue = cloneValue;
      this.action = action;
      this.field = field;
      this.module = module;
      value = cloneValue(get(module, field));
      module.onChange(new Runnable() {

        public void run() {
          try {
            check();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "check();";
        }
      });
      module.onFieldChange(new VF1<String>() {

        public void get(String f) {
          try {
            if (eq(f, field))
              check();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (eq(f, field))\r\n        check();";
        }
      });
    }

    public void check() {
      Object newValue = cloneValue(get(module, field));
      if (eq(value, newValue))
        return;
      value = newValue;
      dm_q(module, action);
    }
  }

  static public class RightAlignedLine extends JPanel {

    public RightAlignedLine(Component... components) {
      setLayout(LetterLayout.rightAlignedRow());
      for (Component component : components) add(component);
    }

    public void add(String text) {
      add(new JLabel(text));
    }
  }

  static public class LetterLayout implements LayoutManager {

    public String[] lines;

    public Map<String, Component> map = new TreeMap<String, Component>();

    public RC[] rows;

    public RC[] cols;

    public Cell[][] cells;

    public int spacingX = 10, spacingY = 10;

    public int insetTop, insetBottom, insetLeft, insetRight;

    public int template;

    public boolean formWideLeftSide, formWideRightSide;

    static final public int STALACTITE = 1, LEFT_ALIGNED_ROW = 2, CENTERED_ROW = 3, FORM = 4, RIGHT_ALIGNED_ROW = 5;

    public boolean debug = false;

    public void setLeftBorder(int border) {
      insetLeft = border;
    }

    public void setRightBorder(int border) {
      insetRight = border;
    }

    public static JComponent withBorder(JComponent component, int border) {
      JPanel panel = new JPanel(new LetterLayout("C").setBorder(border));
      panel.add("C", component);
      return panel;
    }

    public static JPanel panel(String... lines) {
      return new JPanel(new LetterLayout(lines));
    }

    public static JPanel stalactitePanel() {
      return new JPanel(stalactite());
    }

    static public class DummyComponent extends JComponent {
    }

    static public class Cell {

      public boolean aux = false;

      public int minWidth, minHeight;

      public Component component;

      public int colspan, rowspan;

      public double weightX, weightY;
    }

    static public class RC {

      public int min;

      public double weightSum;

      public int start;

      public int minEnd;
    }

    public LetterLayout(int template) {
      this.template = template;
    }

    public LetterLayout(String... lines) {
      this.lines = lines;
    }

    public void removeLayoutComponent(Component component) {
      map.values().remove(component);
    }

    public void layoutContainer(Container container) {
      prepareLayout(container);
      if (debug)
        System.out.println("Container size: " + container.getSize());
      Insets insets = getInsets(container);
      for (int r = 0; r < rows.length; r++) {
        for (int i = 0; i < cols.length; ) {
          Cell cell = cells[i][r];
          if (cell.aux)
            ++i;
          else {
            if (cell.component != null) {
              int x1 = cols[i].start;
              int y1 = rows[r].start;
              int x2 = i + cell.colspan < cols.length ? cols[i + cell.colspan].start - spacingX : container.getWidth() - insets.right;
              int y2 = r + cell.rowspan < rows.length ? rows[r + cell.rowspan].start - spacingY : container.getHeight() - insets.bottom;
              if (debug)
                System.out.println("Layouting (" + i + ", " + r + ", " + cell.component.getClass().getName() + "): " + x1 + " " + y1 + " " + x2 + " " + y2);
              cell.component.setBounds(x1, y1, x2 - x1, y2 - y1);
            }
            i += cells[i][r].colspan;
          }
        }
      }
    }

    final public void prepareLayout(Container container) {
      applyTemplate(container);
      int numRows = lines.length, numCols = lines[0].length();
      for (int i = 1; i < numRows; i++) if (lines[i].length() != numCols)
        throw new IllegalArgumentException("Lines have varying length");
      cells = new Cell[numCols][numRows];
      rows = new RC[numRows];
      cols = new RC[numCols];
      for (int r = 0; r < numRows; r++) rows[r] = new RC();
      for (int i = 0; i < numCols; i++) cols[i] = new RC();
      for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r] = new Cell();
      for (int r = 0; r < numRows; r++) {
        String line = lines[r];
        for (int i = 0; i < numCols; ) {
          Cell cell = cells[i][r];
          if (cell.aux) {
            ++i;
            continue;
          }
          char ch = line.charAt(i);
          int iNext = i;
          do ++iNext; while (iNext < numCols && ch == line.charAt(iNext));
          int rNext = r;
          do ++rNext; while (rNext < numRows && ch == lines[rNext].charAt(i));
          cell.weightX = numCols == 1 || iNext > i + 1 ? 1.0 : 0.0;
          cell.weightY = numRows == 1 || rNext > r + 1 ? 1.0 : 0.0;
          Component c = map.get(String.valueOf(ch));
          cell.component = c;
          if (c != null) {
            cell.minWidth = c.getMinimumSize().width + spacingX;
            cell.minHeight = getMinimumHeight(c) + spacingY;
          }
          cell.colspan = iNext - i;
          cell.rowspan = rNext - r;
          if (cell.colspan == 1)
            cols[i].min = Math.max(cols[i].min, cell.minWidth);
          if (cell.rowspan == 1)
            rows[r].min = Math.max(rows[r].min, cell.minHeight);
          for (int r2 = r; r2 < rNext; r2++) for (int i2 = i; i2 < iNext; i2++) if (r2 != r || i2 != i)
            cells[i2][r2].aux = true;
          i = iNext;
        }
      }
      while (true) {
        for (int i = 0; i < numCols; i++) {
          int minStart = i == 0 ? 0 : cols[i - 1].minEnd;
          double weightStart = i == 0 ? 0.0 : cols[i - 1].weightSum;
          for (int r = 0; r < numRows; r++) {
            Cell cell = cells[i][r];
            if (!cell.aux) {
              RC rc = cols[i + cell.colspan - 1];
              rc.minEnd = Math.max(rc.minEnd, minStart + cell.minWidth);
              rc.weightSum = Math.max(rc.weightSum, weightStart + cell.weightX);
            }
          }
        }
        for (int r = 0; r < numRows; r++) {
          int minStart = r == 0 ? 0 : rows[r - 1].minEnd;
          double weightStart = r == 0 ? 0.0 : rows[r - 1].weightSum;
          for (int i = 0; i < numCols; i++) {
            Cell cell = cells[i][r];
            if (!cell.aux) {
              RC rc = rows[r + cell.rowspan - 1];
              rc.minEnd = Math.max(rc.minEnd, minStart + cell.minHeight);
              rc.weightSum = Math.max(rc.weightSum, weightStart + cell.weightY);
            }
          }
        }
        if (allWeightsZero(cols)) {
          for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r].weightX = 1.0;
          continue;
        }
        if (allWeightsZero(rows)) {
          for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r].weightY = 1.0;
          continue;
        }
        break;
      }
      Insets insets = getInsets(container);
      determineStarts(cols, insets.left, container.getWidth() - insets.left - insets.right + spacingX, spacingX);
      determineStarts(rows, insets.top, container.getHeight() - insets.top - insets.bottom + spacingY, spacingY);
    }

    final public boolean allWeightsZero(RC[] rcs) {
      for (int i = 0; i < rcs.length; i++) if (rcs[i].weightSum != 0.0)
        return false;
      return true;
    }

    static public int getMinimumHeight(Component c) {
      return c.getMinimumSize().height;
    }

    final public void applyTemplate(Container container) {
      if (template == STALACTITE) {
        Component[] components = container.getComponents();
        lines = new String[components.length + 2];
        map.clear();
        for (int i = 0; i < components.length; i++) {
          String s = String.valueOf(makeIndexChar(i));
          map.put(s, components[i]);
          lines[i] = s;
        }
        lines[components.length] = lines[components.length + 1] = " ";
      } else if (template == FORM) {
        Component[] components = container.getComponents();
        int numRows = components.length / 2;
        lines = new String[numRows + 2];
        map.clear();
        for (int row = 0; row < numRows; row++) {
          String lower = String.valueOf(makeIndexChar(row));
          String upper = String.valueOf(makeAlternateIndexChar(row));
          Component rightComponent = components[row * 2 + 1];
          if (rightComponent instanceof DummyComponent)
            upper = lower;
          lines[row] = (formWideLeftSide ? lower + lower : lower) + (formWideRightSide ? upper + upper : upper);
          map.put(lower, components[row * 2]);
          if (!(rightComponent instanceof DummyComponent))
            map.put(upper, rightComponent);
        }
        lines[numRows] = lines[numRows + 1] = (formWideLeftSide ? "  " : " ") + (formWideRightSide ? "  " : " ");
      } else if (template == LEFT_ALIGNED_ROW) {
        lines = new String[] { makeSingleRow(container) + RIGHT_CHAR + RIGHT_CHAR };
      } else if (template == CENTERED_ROW) {
        lines = new String[] { "" + LEFT_CHAR + LEFT_CHAR + makeSingleRow(container) + RIGHT_CHAR + RIGHT_CHAR };
      } else if (template == RIGHT_ALIGNED_ROW) {
        lines = new String[] { "" + LEFT_CHAR + LEFT_CHAR + makeSingleRow(container) };
      }
    }

    final public String makeSingleRow(Container container) {
      Component[] components = container.getComponents();
      StringBuffer buf = new StringBuffer();
      map.clear();
      for (int i = 0; i < components.length; i++) {
        String s = String.valueOf(makeAlternateIndexChar(i));
        map.put(s, components[i]);
        buf.append(s);
      }
      return buf.toString();
    }

    static public void determineStarts(RC[] rcs, int start, int totalSize, int spacing) {
      int minTotal = rcs[rcs.length - 1].minEnd;
      double weightSum = rcs[rcs.length - 1].weightSum;
      int spare = (int) ((totalSize - minTotal) / (weightSum == 0.0 ? 1.0 : weightSum));
      int x = start, minSum = 0;
      double prevWeightSum = 0.0;
      for (int i = 0; i < rcs.length; i++) {
        int width = rcs[i].minEnd - minSum + (int) ((rcs[i].weightSum - prevWeightSum) * spare) - spacing;
        rcs[i].start = x;
        x += width + spacing;
        prevWeightSum = rcs[i].weightSum;
        minSum = rcs[i].minEnd;
      }
    }

    public void addLayoutComponent(String s, Component component) {
      map.put(s, component);
    }

    public Dimension minimumLayoutSize(Container container) {
      prepareLayout(container);
      Insets insets = getInsets(container);
      Dimension result = new Dimension(insets.left + cols[cols.length - 1].minEnd + insets.right - spacingX, insets.top + rows[rows.length - 1].minEnd + insets.bottom - spacingY);
      return result;
    }

    final public Insets getInsets(Container container) {
      Insets insets = container.getInsets();
      return new Insets(insets.top + insetTop, insets.left + insetLeft, insets.bottom + insetBottom, insets.right + insetRight);
    }

    public Dimension preferredLayoutSize(Container container) {
      return minimumLayoutSize(container);
    }

    public LetterLayout setSpacing(int x, int y) {
      spacingX = x;
      spacingY = y;
      return this;
    }

    public LetterLayout setSpacing(int spacing) {
      return setSpacing(spacing, spacing);
    }

    public LetterLayout setBorder(int top, int left, int bottom, int right) {
      insetTop = top;
      insetLeft = left;
      insetBottom = bottom;
      insetRight = right;
      return this;
    }

    public LetterLayout setBorder(int inset) {
      return setBorder(inset, inset, inset, inset);
    }

    public LetterLayout setTopBorder(int inset) {
      insetTop = inset;
      return this;
    }

    public static LetterLayout stalactite() {
      return new LetterLayout(STALACTITE);
    }

    public static LetterLayout leftAlignedRow() {
      return new LetterLayout(LEFT_ALIGNED_ROW);
    }

    public static LetterLayout leftAlignedRow(int spacing) {
      return leftAlignedRow().setSpacing(spacing);
    }

    public static LetterLayout centeredRow() {
      return new LetterLayout(CENTERED_ROW);
    }

    public static LetterLayout rightAlignedRow() {
      return new LetterLayout(RIGHT_ALIGNED_ROW);
    }

    public static JPanel rightAlignedRowPanel(JComponent... components) {
      return makePanel(new LetterLayout(RIGHT_ALIGNED_ROW), components);
    }

    static public JPanel makePanel(LetterLayout letterLayout, JComponent[] components) {
      JPanel panel = new JPanel(letterLayout);
      for (JComponent component : components) {
        panel.add(component);
      }
      return panel;
    }

    public static LetterLayout form() {
      LetterLayout letterLayout = new LetterLayout(FORM);
      letterLayout.formWideLeftSide = true;
      letterLayout.formWideRightSide = true;
      return letterLayout;
    }

    public static LetterLayout formWideRightSide() {
      LetterLayout letterLayout = new LetterLayout(FORM);
      letterLayout.formWideRightSide = true;
      return letterLayout;
    }

    public static Component getDummyComponent() {
      return new DummyComponent();
    }

    public static JPanel newPanel(String... lines) {
      return new JPanel(new LetterLayout(lines));
    }

    public boolean isDebug() {
      return debug;
    }

    public void setDebug(boolean debug) {
      this.debug = debug;
    }

    public static char makeIndexChar(int idx) {
      return (char) ('a' + idx * 2);
    }

    public static char makeAlternateIndexChar(int idx) {
      return (char) ('b' + idx * 2);
    }

    public static char LEFT_CHAR = ',', RIGHT_CHAR = '.';

    public static void main(String[] args) {
      System.out.println((int) makeIndexChar(0));
      System.out.println((int) makeAlternateIndexChar(0));
      System.out.println((int) makeIndexChar(32000));
      System.out.println((int) makeAlternateIndexChar(32000));
      System.out.println((int) LEFT_CHAR);
      System.out.println((int) RIGHT_CHAR);
    }
  }

  static public Q dm_q() {
    return dm_current_mandatory().q();
  }

  static public void dm_q(Runnable r) {
    dm_inQ(r);
  }

  static public void dm_q(DynModule module, Runnable r) {
    module.q().add(r);
  }

  static public <A> A dm_q(IF0<A> f) {
    return dm_evalInQ(if0ToF0(f));
  }

  static public void dm_inQ(Runnable r) {
    dm_q().add(r);
  }

  static public <A> A dm_evalInQ(F0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), f);
  }

  static public <A> A dm_evalInQ(IF0<A> f) {
    return dm_evalInQ(dm_current_mandatory(), if0ToF0(f));
  }

  static public <A> A dm_evalInQ(DynModule module, F0<A> f) {
    return evalInQ(module.q(), f);
  }

  static public <A> F0<A> if0ToF0(IF0<A> f) {
    return f == null ? null : new F0<A>() {

      public A get() {
        try {
          return f.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.get();";
      }
    };
  }

  static public <A> A evalInQ(Q q, final F0<A> f) {
    if (isInQ(q))
      return callF(f);
    final Var<Either<A, Throwable>> var = new Var();
    q.add(new Runnable() {

      public void run() {
        try {
          try {
            var.set(eitherA(callF(f)));
          } catch (Throwable e) {
            var.set(eitherB(e));
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "try {\r\n      var.set(eitherA(callF(f)));\r\n    } catch (Throwable e) {\r\n      ...";
      }
    });
    return returnOrThrow_either(waitForVarToBeNotNull(var));
  }

  static public boolean isInQ(Q q) {
    return q != null && isCurrentThread(q.rst.thread);
  }

  static public <A, B> Either<A, B> eitherA(A a) {
    return new Either(1, a);
  }

  static public <A, B> Either<A, B> eitherB(B b) {
    return new Either(2, b);
  }

  static public <A> A returnOrThrow_either(Either<A, Throwable> e) {
    if (isEitherB(e))
      throw rethrow(e.b());
    return eitherAOpt(e);
  }

  static public <A> A waitForVarToBeNotNull(Var<A> v) {
    try {
      synchronized (v) {
        while (!v.has()) v.wait();
        return v.get();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isCurrentThread(Thread t) {
    return t != null && t == currentThread();
  }

  static public <A, B> boolean isEitherB(Either<A, B> e) {
    return eitherIsB(e);
  }

  static public <A, B> A eitherAOpt(Either<A, B> e) {
    return e != null && e.isA() ? e.a() : null;
  }

  static public <A, B> boolean eitherIsB(Either<A, B> e) {
    return e != null && e.isB();
  }

  static public class Either<A, B> {

    public byte which;

    public Object value;

    public Either() {
    }

    public Either(int which, Object value) {
      this.which = (byte) which;
      this.value = value;
    }

    public boolean isA() {
      return which == 1;
    }

    public boolean isB() {
      return which == 2;
    }

    public A a() {
      if (which != 1)
        _failMe();
      return (A) value;
    }

    public B b() {
      if (which != 2)
        _failMe();
      return (B) value;
    }

    public A aOpt() {
      return which != 1 ? null : (A) value;
    }

    public B bOpt() {
      return which != 2 ? null : (B) value;
    }

    public void _failMe() {
      throw fail("Either object is of wrong type: " + shortClassName(value));
    }

    public String toString() {
      return "Either" + (isA() ? "A" : "B") + "(" + value + ")";
    }
  }

  static public <A, B> boolean isA(Either<A, B> e) {
    return eitherIsA(e);
  }

  static public <A, B> boolean eitherIsA(Either<A, B> e) {
    return e != null && e.isA();
  }
}

