import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;
import java.time.Duration;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarScopes;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.Events;
import java.text.*;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.text.NumberFormat;
import java.awt.geom.*;
import java.nio.charset.Charset;
import com.google.api.client.googleapis.auth.oauth2.*;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import static x30_pkg.x30_util.DynamicObject;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.Const;
import org.apache.bcel.generic.*;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.jar.*;

public class main {

  static public String dbBotID = "#1028421";

  static public boolean newDesign = true;

  static public boolean ariaLiveTrick = false;

  static public boolean ariaLiveTrick2 = true;

  static public String templateID = "#1028653";

  static public String cssID = "#1028652";

  static public String thoughtBotID = null;

  static public String botName = "BookBetter";

  static public String heading = "Schedule";

  static public String botImageID = "#1102935";

  static public String userImageID = "#1102803";

  static public String chatHeaderImageID = "#1102802";

  static public String timeZone = californiaTimeZone_string();

  static public String timeZoneForGoogleAPI = "America/Los_Angeles";

  static public String baseLink;

  static public boolean botOnRight = true;

  static public class Worker extends Concept {

    public String loginName, displayName;

    public boolean available = false;

    public long lastOnline;

    static public String _fieldOrder = "loginName displayName";

    public String renderAsHTML() {
      return htmlEncode2(loginName + " (display name: " + displayName + ")");
    }
  }

  static public class WorkerChat {

    public int workerLongPollTick = 200;

    public int workerLongPollMaxWait = 1000 * 30;

    public long lastWorkerRequested;

    public Object html(String uri, Map<String, String> params, Conversation conv, AuthedDialogID auth) {
      String uri2 = appendSlash(uri);
      boolean requestAuthed = auth != null;
      if (startsWith(uri2, "/workers-admin/")) {
        if (!requestAuthed)
          return serveAuthForm(params.get("uri"));
        return serveWorkersAdmin(uri, params);
      }
      if (startsWith(uri2, "/worker/")) {
        if (!subBot_isHttps())
          return subBot_serveRedirect("https://" + domain() + fullSelfLink(params));
        if (!requestAuthed)
          return serveAuthForm(params.get("uri"));
        if (nempty(params.get("turnBotOn")))
          conv.turnBotOn();
        return serveWorkerPage(auth, conv, uri, params);
      }
      return null;
    }

    public String serveWorkersAdmin(String uri, Map<String, String> params) {
      String nav = p(ahref(rawBotLink(dbBotID), "Main admin") + " | " + ahref(baseLink + "/workers-admin", "Workers admin"));
      if (eq(uri, "/workers-admin/change-image")) {
        long id = parseLong(params.get("id"));
        Worker worker = getConcept(Worker.class, id);
        File f = workerImageFile(id);
        String content;
        String b64 = params.get("base64");
        if (nempty(b64))
          saveFile(f, decodeBASE64(b64));
        if (worker == null)
          content = "Worker not found";
        else
          content = nav + hscript("\r\n            function submitIt() {\r\n              var file = $('#myUpload')[0].files[0];\r\n              var reader = new FileReader();\r\n  \r\n              reader.onloadend = function () {\r\n                var b64 = reader.result.replace(/^data:.+;base64,/, '');\r\n                $(\"#base64\").val(b64);\r\n                console.log(\"Got base64 data: \" + b64.length);\r\n                $(\"#submitForm\").submit();\r\n              };\r\n  \r\n              reader.readAsDataURL(file);\r\n              return false;\r\n            }\r\n          ") + h2("Worker image for: " + worker.renderAsHTML()) + p(!fileExists(f) ? "No image set" : himgsrc(rawLink("worker-image/" + id))) + hpostform(hhiddenWithIDAndName("base64") + "Choose image: " + hfileupload("accept", "image/png,image/jpeg,image/gif", "id", "myUpload") + "<br><br>" + "Note: Image should be square. Will be scaled to 40x40px in the chat" + hhidden("id", id), "action", rawLink("/workers-admin/change-image"), "id", "submitForm") + hbuttonOnClick_returnFalse("Upload", "submitIt()");
        return hhtml(hhead_title("Change worker image") + hsansserif() + hbody(loadJQuery() + content));
      }
      HCRUD_Concepts<Worker> data = new HCRUD_Concepts<Worker>(Worker.class);
      HCRUD crud = new HCRUD(rawLink("workers-admin"), data) {

        public String frame(String title, String contents) {
          return hhtml(hhead_title_htmldecode(title) + hbody(nav + h1(title) + contents));
        }
      };
      crud.unshownFields = litset("available", "lastOnline", "away");
      crud.postProcessTableRow = (item, rendered) -> {
        printStruct("item", item);
        long id = parseLong(item.get("id"));
        File f = workerImageFile(id);
        return mapPlus(rendered, "Image", f == null ? "???" : !fileExists(f) ? "-" : himgsrc(rawLink("worker-image/" + id)));
      };
      crud.renderCmds = item -> crud.renderCmds_base(item) + " | " + ahref(rawLink("workers-admin/change-image" + hquery("id", item.get("id"))), "Change image...");
      crud.tableClass = "responstable";
      return hsansserif() + hcss_responstable() + crud.renderPage(params);
    }

    public String serveWorkerPage(AuthedDialogID auth, Conversation conv, String uri, Map<String, String> params) {
      String cookie = conv.cookie;
      String uri2 = afterLastSlash(uri);
      if (eq(uri2, "availableWorkers"))
        return "Available workers: " + or2(joinWithComma(map(workersAvailable(), w -> w.renderAsHTML())), "-");
      if (nempty(params.get("workerLogOut")))
        cset(auth, "loggedIn", null);
      if (auth.loggedIn != null && nempty(params.get("workerAvailableBox")))
        if (cset_trueIfChanged(auth.loggedIn, "available", nempty(params.get("workerAvailable"))))
          noteConversationChange();
      if (nempty(params.get("acceptConversation"))) {
        if (conv.worker == null) {
          cset(conv, "worker", auth.loggedIn);
          conv.turnBotOff();
        }
      }
      String loginID = params.get("workerLogIn");
      if (nempty(loginID))
        cset(auth, "loggedIn", getConcept(Worker.class, parseLong(loginID)));
      Map map = prependEmptyOptionForHSelect(mapToOrderedMap(conceptsSortedByFieldCI(Worker.class, "loginName"), w -> pair(w.id, w.loginName)));
      if (auth.loggedIn == null)
        return hsansserif() + p("You are not logged in as a worker") + hpostform("Log in as: " + hselect("workerLogIn", map, conceptID(auth.loggedIn)) + " " + hsubmit("OK"), "action", rawLink("worker"));
      if (eq(uri2, "conversation")) {
        if (conv == null)
          return "Conversation not found";
        String onOffURL = rawLink("worker/botOnOff" + hquery("cookie", cookie) + "&on=");
        return hsansserif() + loadJQuery() + hhidden("cookie", conv.cookie) + hpostform(hhidden("cookie", cookie) + p(renderBotStatus(conv)) + p(conv.botOn ? hsubmit("Accept conversation", "name", "acceptConversation") : hsubmit("Turn bot back on", "name", "turnBotOn")), "action", rawLink("worker/innerFrameSet"), "target", "innerFrameSet") + hscriptsrc(rawLink(hquery("workerMode", 1, "cookie", conv.cookie)));
      }
      if (eq(uri2, "conversations")) {
        cset(auth.loggedIn, "lastOnline", now());
        boolean poll = eq("1", params.get("poll"));
        String content = "";
        if (poll) {
          long seenChange = parseLong(params.get("lastChange"));
          vmBus_send("chatBot_startingWorkerPoll", mc(), conv);
          long start = sysNow();
          List msgs;
          boolean first = true;
          while (licensed() && sysNow() < start + workerLongPollMaxWait && lastConversationChange == seenChange) sleep(workerLongPollTick);
          printVars_str("lastWorkerRequested", lastWorkerRequested, "seenChange", seenChange);
          if (lastWorkerRequested > seenChange)
            content = hscript("\r\n            window.parent.parent.frames[0].sendDesktopNotification(\"A worker is requested!\", { action: function() { window.focus(); } });\r\n            window.parent.parent.frames[0].playWorkerRequestedSound();\r\n          ");
        }
        long pingThreshold = now() - activeConversationTimeout();
        List<Conversation> convos = sortByCalculatedFieldDesc(c -> c.lastMsgTime(), conceptsWithFieldGreaterThan(Conversation.class, "lastPing", pingThreshold));
        content += hhiddenWithID("lastConversationChange", lastConversationChange) + tag("table", hsimpletableheader("IP", "Country", "Bot/worker status", "Last change", "Last messages") + mapToLines(convos, c -> {
          List<Msg> lastMsgs = lastTwo(c.msgs);
          String style = c == conv ? "background: #90EE90" : null;
          String convLink = rawLink("worker/innerFrameSet" + hquery("cookie", c.cookie));
          return tag("tr", td(ahref(convLink, c.ip, "target", "innerFrameSet")) + td(getCountry(c)) + td(renderBotStatus(c)) + td(renderHowLongAgo(c.lastMsgTime())) + td(ahref(convLink, hparagraphs(lambdaMap(__47 -> renderMsgForWorkerChat(__47), lastMsgs)), "target", "innerFrameSet", "style", "text-decoration: none")), "style", style);
        }), "class", "responstable");
        if (poll)
          return content;
        String incrementalURL = rawLink("worker/conversations?poll=1&lastChange=");
        return hhtml(hhead(hsansserif() + loadJQuery() + hscript_clickableRows()) + hbody(h3(botName) + hpostform("Logged in as " + htmlEncode2(auth.loggedIn.loginName) + " (display name: " + htmlEncode2(auth.loggedIn.displayName) + ")" + hhidden("workerAvailableBox", 1) + " &nbsp; " + hcheckboxWithText("workerAvailable", "I am available", auth.loggedIn.available, "onclick", "form.submit()") + " &nbsp; " + hsubmit("Log out", "name", "workerLogOut"), "target", "innerFrameSet", "action", rawLink("worker/innerFrameSet")) + p("Available workers: " + b(or2(joinWithComma(map(workersAvailable(), w -> w.displayName)), "none"))) + h3("Active conversations") + hcss_responstable() + hdivWithID("contentArea", content) + hscript("\r\n          function poll_start() {\r\n            var lastChange = $(\"#lastConversationChange\").val();\r\n            if (!lastChange)\r\n              setTimeout(poll_start, 1000);\r\n            else {\r\n              var url = \"#INCREMENTALURL#\" + lastChange;\r\n              console.log(\"Loading \" + url);\r\n              $.get(url, function(src) {\r\n                if (src.match(/^ERROR/)) console.log(src);\r\n                else {\r\n                  console.log(\"Loaded \" + src.length + \" chars\");\r\n                  $(\"#contentArea\").html(src);\r\n                }\r\n                setTimeout(poll_start, 1000);\r\n              }, 'text')\r\n                .fail(function() {\r\n                  console.log(\"Rescheduling after fail\");\r\n                  setTimeout(poll_start, 1000);\r\n                });\r\n            }\r\n          }\r\n          poll_start();\r\n        ".replace("#INCREMENTALURL#", incrementalURL))));
      }
      if (eq(uri2, "notificationArea"))
        return hhtml(hhead(hsansserif() + loadJQuery()) + hbody(hdesktopNotifications() + div(small(span(hbutton("CLICK HERE to enable notification sounds!"), "id", "enableSoundsBtn") + " | " + span("", "id", "notiStatus")), "style", "float: right") + hscript("\r\n          function enableSounds() {\r\n            document.removeEventListener('click', enableSounds);\r\n            $(\"#enableSoundsBtn\").html(\"Notification sounds enabled\");\r\n          }\r\n          document.addEventListener('click', enableSounds);\r\n          \r\n          if (window.workerRequestedSound == null) {\r\n            console.log(\"Loading worker requested sound\");\r\n            window.workerRequestedSound = new Audio(\"https://botcompany.de/files/1400404/worker-requested.mp3\");\r\n          }\r\n          \r\n          function playWorkerRequestedSound() {\r\n            console.log(\"Playing worker requested sound\");\r\n            window.workerRequestedSound.play();\r\n          }\r\n          window.playWorkerRequestedSound = playWorkerRequestedSound;\r\n\r\n        ")));
      if (eq(uri2, "innerFrameSet"))
        return hhtml(hhead_title("Worker Chat [" + auth.loggedIn.loginName + "]") + hframeset_cols("*,*", tag("frame", "", "name", "conversations", "src", rawLink("worker/conversations" + hquery("cookie", cookie))) + tag("frame", "", "name", "conversation", "src", conv == null ? null : rawLink("worker/conversation" + hquery("cookie", cookie)))));
      return hhtml(hhead_title("Worker Chat [" + auth.loggedIn.loginName + "]") + hframeset_rows("50,*", tag("frame", "", "name", "notificationArea", "src", rawLink("worker/notificationArea")) + tag("frame", "", "name", "innerFrameSet", "src", conv == null ? null : rawLink("worker/innerFrameSet" + hquery("cookie", cookie)))));
    }

    public String renderMsgForWorkerChat(Msg msg) {
      return (msg.fromWorker != null ? htmlEncode2(msg.fromWorker.displayName) : msg.fromUser ? "User" : "Bot") + ": " + b(htmlEncode2If(shouldHtmlEncodeMsg(msg), msg.text));
    }

    public Collection<Worker> workersAvailable() {
      long timestamp = now() - workerLongPollMaxWait - 10000;
      return filter(list(Worker.class), w -> w.available && w.lastOnline >= timestamp);
    }

    public boolean anyWorkersAvailable() {
      return nempty(workersAvailable());
    }

    public String renderBotStatus(Conversation conv) {
      return "Bot is " + b(conv.botOn ? "on" : "off") + "<br>" + "Assigned worker: " + b(conv.worker == null ? "none" : conv.worker.displayName);
    }
  }

  static public WorkerChat workerChat = new WorkerChat();

  static public List<LongRange> testModeEventRanges() {
    return ll(longRange(parseYMDHMS("2020/07/03 9:00:00", localTimeZone()), parseYMDHMS("2020/07/03 10:30:00", localTimeZone())), longRange(parseYMDHMS("2020/07/06 9:00:00", localTimeZone()), parseYMDHMS("2020/07/06 20:00:00", localTimeZone())));
  }

  static public long testModeDate() {
    return parseYMDHMS("2020/07/02 17:00:00", localTimeZone());
  }

  static public Map<Integer, List<IntRange>> testModeBusinessHours() {
    List<IntRange> r = parseBusinessHours("9-5");
    return litmap(2, r, 3, r, 4, r, 5, r, 6, r);
  }

  static public class BookingConfig extends Concept {

    static final public String _fieldOrder = "bookingOpen googleCalendarAccessToken googleCalendarRefreshToken twilioAccountSID twilioAuthToken twilioPhoneNr ownerPhoneNr eventKeyword businessHoursSunday businessHoursMonday businessHoursTuesday businessHoursWednesday businessHoursThursday businessHoursFriday businessHoursSaturday businessName appointmentName appointmentDuration appointmentGranularity appointmentMaxLead dateSuggestionsInGreeting dateSuggestionsOnFail smsTemplate";

    public boolean bookingOpen = true;

    public String googleCalendarAccessToken, googleCalendarRefreshToken;

    public String twilioAccountSID, twilioAuthToken, twilioPhoneNr;

    public String ownerPhoneNr;

    public String eventKeyword = "[SALES]";

    public String businessHoursSunday, businessHoursMonday, businessHoursTuesday, businessHoursWednesday, businessHoursThursday, businessHoursFriday, businessHoursSaturday;

    public String businessName;

    public String appointmentName;

    public int appointmentDuration;

    public int appointmentGranularity;

    public int appointmentMaxLead;

    public int dateSuggestionsInGreeting, dateSuggestionsOnFail = 2;

    public String smsTemplate;

    public Map<Integer, String> businessHourStrings() {
      return pairsToTreeMap(ll(pair(1, businessHoursSunday), pair(2, businessHoursMonday), pair(3, businessHoursTuesday), pair(4, businessHoursWednesday), pair(5, businessHoursThursday), pair(6, businessHoursFriday), pair(7, businessHoursSaturday)));
    }
  }

  static public Booking booking;

  static public class Booking {

    public GoogleAccess googleAccess = new GoogleAccess();

    public Calendar googleCalendarService;

    public BookingConfig conf;

    public boolean anyTimeSlots = true;

    public Booking() {
      indexSingletonConcept(BookingConfig.class);
      conf = uniq(BookingConfig.class);
      initGoogleCalendar();
      initTwilio();
      print("Booking inited");
    }

    public Object html(String uri, Map<String, String> params, AuthedDialogID auth) {
      print("Booking: " + uri);
      String uri2 = appendSlash(uri);
      boolean requestAuthed = auth != null;
      if (startsWith(uri2, "/booking-admin/")) {
        if (!requestAuthed)
          return serveAuthForm(params.get("uri"));
        return serveBookingAdmin(uri, params);
      }
      return null;
    }

    public String serveBookingAdmin(String uri, Map<String, String> params) {
      String nav = p(ahref(rawBotLink(dbBotID), botName + " Main admin") + " | " + ahref(baseLink + "/booking-admin", "Booking admin"));
      HCRUD_Concepts<BookingConfig> data = new HCRUD_Concepts<BookingConfig>(BookingConfig.class);
      data.fieldHelp = litmap("bookingOpen", "Whether booking is open at all", "eventKeyword", "keyword to recognize events in Google Calendar, e.g. [SALES]", "businessHoursMonday", "Regular hours available for appointments on Monday, e.g.: 9-12, 15-18", "businessName", "What's your business called?", "appointmentName", "Description of a typical appointment", "appointmentDuration", "Duration of an appointment in minutes", "appointmentGranularity", "Appointment grid size in minutes (e.g. 10)", "appointmentMaxLead", "How many days in advance can an appointment be made", "smsTemplate", "Template for appointment confirmation, e.g.: Hello [name], your [appointment] is scheduled for [time] on [date] at [business]", "dateSuggestionsInGreeting", "How many date suggestions are shown in bot greeting (0 for no suggestions)");
      data.onCreateOrUpdate.add(c -> initGoogleCalendar());
      HCRUD crud = new HCRUD(rawLink("booking-admin"), data) {

        public String frame(String title, String contents) {
          return hhtml(hhead_title_htmldecode(title) + hbody(hsansserif() + hcss_responstable() + nav + h1(title) + p(join(". ", calendarStatus(), twilioStatus())) + h3("Business hours") + p(businessHourStatus()) + contents));
        }
      };
      crud.singleton = true;
      crud.cmdsLeft = true;
      crud.tableClass = "responstable";
      return crud.renderPage(params);
    }

    public Object twilio() {
      return vmBus_query("twilioHolder");
    }

    public boolean twilioInited() {
      return isTrue(call(twilio(), "twilioInited"));
    }

    public void initTwilio() {
      if (twilioInited())
        return;
      if (empty(conf.twilioAccountSID) || empty(conf.twilioAuthToken) || empty(conf.twilioPhoneNr))
        return;
      try {
        print("initTwilio");
        Object twilio = twilio();
        if (twilio == null) {
          print("No twilio holder in VM");
          return;
        }
        call(twilio, "twilioInit", conf.twilioAccountSID, conf.twilioAuthToken);
        print("initTwilio done");
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }

    public void initGoogleCalendar() {
      googleCalendarService = null;
      BookingConfig c = conf;
      if (empty(c.googleCalendarAccessToken) || empty(c.googleCalendarRefreshToken))
        return;
      try {
        googleAccess.credentialFromTokens(c.googleCalendarAccessToken, c.googleCalendarRefreshToken);
        googleCalendarService = googleCalendarService(googleAccess, botName);
        print("googleCalendarService", googleCalendarService);
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }

    public String calendarStatus() {
      return googleCalendarService == null ? "Calendar NOT initialized (auth problem?)" : "Calendar access OK";
    }

    public String twilioStatus() {
      return twilioInited() ? "Twilio initialized" : "Twilio NOT initialized";
    }

    public String businessHourStatus() {
      Map<Integer, String> map = conf.businessHourStrings();
      List<String> l = new ArrayList();
      double totalHours = 0;
      for (Map.Entry<? extends Integer, ? extends String> __2 : _entrySet(map)) {
        int day = __2.getKey();
        String s = __2.getValue();
        List<IntRange> ranges = parseBusinessHours_pcall(s);
        if (ranges == null)
          l.add(englishWeekday(day) + ": Error in business hour definition, please fix");
        else {
          double hours = totalIntRangesLength(ranges) / 60.0;
          l.add(englishWeekday(day) + ": " + formatDouble(hours, 1) + (hours == 1 ? " hour" : " hours"));
          totalHours += hours;
        }
      }
      l.add("Total business hours per week: " + formatDouble(totalHours, 1));
      return joinWithBR(l);
    }

    public LongRange maxLead(long now) {
      return longRange(now, dateStructureToTimestampRange(new DateStructures.TodayPlus(conf.appointmentMaxLead)).start);
    }

    public String answer(String s, Conversation conv) {
      DateInterpretationConfig config = new DateInterpretationConfig();
      config.now = nowInConv(conv);
      LongRange range = parseEnglishDateRange(s, config);
      if (range == null)
        return null;
      LongRange extendedRange = new LongRange(beginningOfDay(range.start, localTimeZone()), endOfDay(range.end - 1, localTimeZone()));
      long now = nowInConv(conv);
      print("now=" + now + ", testMode: " + conv.testMode);
      range = intersectLongRanges(range, maxLead(now));
      if (range == null)
        return template("#badTimeRange");
      print("range: " + range);
      List<LongRange> eventRanges = getEventRanges(extendedRange, conv.testMode);
      TreeSet<Long> allPossibleDates = possibleDatesInTimeRange_unfiltered(extendedRange, conv.testMode);
      removeEventsFromPossibleDates(allPossibleDates, eventRanges);
      TreeSet<Long> possibleDates = possibleDatesInTimeRange_unfiltered(range, conv.testMode);
      removeEventsFromPossibleDates(possibleDates, eventRanges);
      print("Possible dates: " + l(possibleDates));
      String formattedRange = formatDateRange(extendedRange, " and ");
      if (empty(possibleDates)) {
        if (empty(allPossibleDates)) {
          if (conf.dateSuggestionsOnFail != 0) {
            LongRange range2 = maxLead(nowInConv(conv));
            TreeSet<Long> possibleDates2 = possibleDates(range2, conv.testMode);
            print("Possible dates: " + l(possibleDates2));
            if (nempty(possibleDates2)) {
              proposeForm(new ProposeAppointmentsForm(possibleDates2, conf.dateSuggestionsOnFail));
              return template("#noTimeSlots", "range", formattedRange);
            }
            return template("#bookedOut");
          }
          return template("#noTimeSlots", "range", formattedRange);
        }
        long proposedDate = first(allPossibleDates);
        ProposeAppointmentForm form = new ProposeAppointmentForm(allPossibleDates, proposedDate);
        form.setTemplate("#suggestOtherTime");
        proposeForm(form);
        return "";
      }
      long proposedDate = first(possibleDates);
      ProposeAppointmentForm form = new ProposeAppointmentForm(allPossibleDates, proposedDate);
      form.setTemplate("#yesWeCanDoThatHowAboutDate");
      if (range.length() <= hoursToMS(1))
        form.setTemplate("#confirmDate");
      proposeForm(form);
      return "";
    }

    public List<LongRange> getEventRanges(LongRange range, boolean testMode) {
      long duration = minutesToMS(conf.appointmentDuration);
      int maxEvents = 10000;
      List<LongRange> eventRanges;
      if (testMode)
        eventRanges = testModeEventRanges();
      else {
        long _startTime_3 = sysNow();
        List<Event> events = googleCalendar_eventsInDateRange(booking.googleCalendarService, localTimeZone(), range, maxEvents);
        events = filterEventsByKeyword(events);
        eventRanges = map(events, evt -> longRange(evt.getStart().getDateTime().getValue() - duration + 1, evt.getEnd().getDateTime().getValue()));
        done2_always("Get events from calendar", _startTime_3);
      }
      return eventRanges;
    }

    public TreeSet<Long> possibleDatesInTimeRange_unfiltered(LongRange range, boolean testMode) {
      long granularity = granularity();
      List<LongRange> ranges = sliceTimeRangeIntoBusinessHours(range, testMode);
      print("Sliced ranges: " + lambdaMap(__48 -> formatDateRange(__48), ranges));
      ranges = map(r -> cutLongRangeToGranularity(r, granularity), ranges);
      ranges = filter(ranges, r -> r.length() >= 0);
      print("Final ranges: " + lambdaMap(__49 -> formatDateRange(__49), ranges) + ", granularity: " + granularity);
      TreeSet<Long> possibleDates = new TreeSet();
      for (LongRange r : ranges) for (long x = r.start; x <= r.end; x += granularity) possibleDates.add(x);
      print("Possible dates: " + l(possibleDates));
      return possibleDates;
    }

    public void removeEventsFromPossibleDates(TreeSet<Long> possibleDates, Collection<LongRange> eventRanges) {
      for (LongRange evt : eventRanges) {
        SortedSet<Long> subSet = possibleDates.subSet(evt.start, evt.end);
        if (nempty(subSet)) {
          subSet.clear();
        }
      }
    }

    public TreeSet<Long> possibleDates(LongRange range, boolean testMode) {
      List<LongRange> eventRanges = getEventRanges(range, testMode);
      TreeSet<Long> possibleDates = possibleDatesInTimeRange_unfiltered(range, testMode);
      removeEventsFromPossibleDates(possibleDates, eventRanges);
      return possibleDates;
    }

    public List<Event> filterEventsByKeyword(List<Event> l) {
      return filter(l, e -> cic(e.getSummary(), conf.eventKeyword));
    }

    public List<LongRange> sliceTimeRangeIntoBusinessHours(LongRange range, boolean testMode) {
      long firstDay = beginningOfDay(range.start, timeZone());
      long lastDay = beginningOfDay(range.end, timeZone());
      lastDay = min(firstDay + daysToMS(365), lastDay);
      List<LongRange> out = new ArrayList();
      Map<Integer, List<IntRange>> businessHours = businessHours(testMode);
      long duration = minutesToMS(conf.appointmentDuration);
      for (long day = firstDay; day <= lastDay; day += daysToMS(1)) {
        int weekday = dayOfWeek_nr(day, timeZone());
        List<IntRange> hours = businessHours.get(weekday);
        for (IntRange r : unnullForIteration(hours)) {
          LongRange r2 = longRange(day + r.start * 60 * 1000, day + r.end * 60 * 1000 - duration);
          r2 = intersectLongRanges(range, r2);
          if (r2 != null)
            out.add(r2);
        }
      }
      return out;
    }

    public String dateAndTimeFormat() {
      return dateFormat() + " " + timeFormat();
    }

    public String dateFormat() {
      return "EEE M/dd/y";
    }

    public String timeFormat() {
      return "hh:mm aa";
    }

    public TimeZone timeZone() {
      return localTimeZone();
    }

    public String formatDate(long date) {
      return main.formatDate(date, dateAndTimeFormat(), timeZone());
    }

    public String formatDateRange(LongRange r) {
      return formatDateRange(r, " to ");
    }

    public String formatDateRange(LongRange r, String connector) {
      return r == null ? null : formatDate(r.start) + connector + formatDate(r.end);
    }

    public long granularity() {
      return minutesToMS(max(conf.appointmentGranularity, 5));
    }

    public String acceptAppointment(Conversation conv, long date) {
      proposeForm(conv, new TakeUserInfoForm(date));
      return "";
    }

    public Object serveTwilioWebhook(String uri, Map<String, String> params) {
      String twilioSig = subBot_getHeader("X-Twilio-Signature");
      printAndProgramLog("twilioSig=" + twilioSig);
      print("params", params);
      String url = subBot_completeRequestURL();
      printAndProgramLog("url", url);
      programLog("webhook: " + params);
      initTwilio();
      boolean validated = isTrue(call(twilio(), "twilioValidateRequest", conf.twilioAuthToken, url, params, twilioSig));
      printAndProgramLog("validated", validated);
      if (!validated)
        return "not validated";
      String accountSID = params.get("AccountSid");
      String body = params.get("Body");
      String from = params.get("From");
      String msgTo = conf.ownerPhoneNr;
      String msgText = from + " said: " + body;
      try {
        Object message = call(twilio(), "twilioSend", conf.twilioPhoneNr, msgTo, msgText);
        printAndProgramLog("Message sent: " + message);
      } catch (Throwable e) {
        printStackTrace(e);
        programLog(stackTraceToString(e));
      }
      return hfulltag("Response", "");
    }

    public Map<Integer, List<IntRange>> businessHours(boolean testMode) {
      return testMode ? testModeBusinessHours() : mapValues(__50 -> parseBusinessHours_pcall(__50), conf.businessHourStrings());
    }

    public boolean anyBusinessHours() {
      return !allEmpty(values(businessHours(false)));
    }

    public void checkIfAnyTimeSlots() {
      int n = l(possibleDates(maxLead(now()), false));
      print("Found " + n2(n, "possible date") + " in near future");
      anyTimeSlots = n != 0;
    }

    public boolean anyBookingPossible() {
      return conf.bookingOpen && anyBusinessHours() && anyTimeSlots;
    }

    public List<Long> pickDates(int n, Collection<Long> possibleDates) {
      LinkedHashSet<Long> l = new LinkedHashSet();
      if (nempty(possibleDates)) {
        long first = first(possibleDates);
        l.add(first);
        if (n >= 2) {
          boolean firstIsPM = hours(first, localTimeZone()) > 12;
          addIfNotNull(l, firstThat(dropFirst(possibleDates), d -> (hours(d, localTimeZone()) > 12) != firstIsPM));
        }
        for (long date : possibleDates) {
          if (l(l) >= n)
            break;
          l.add(date);
        }
      }
      return asList(l);
    }
  }

  static public class ProposeAppointmentForm extends FormInFlight {

    public TreeSet<Long> possibleDates;

    public long date;

    public String template = "#howAboutDate";

    public ProposeAppointmentForm() {
    }

    public ProposeAppointmentForm(TreeSet<Long> possibleDates, long date) {
      this.date = date;
      this.possibleDates = possibleDates;
      makeSteps();
    }

    public void setTemplate(String template) {
      this.template = template;
      makeSteps();
    }

    public void resetTemplate() {
      template = new ProposeAppointmentForm().template;
    }

    public void makeSteps() {
      steps = ll(nu(FormStep.class, "key", "start", "displayText", template(template, "date", booking.formatDate(date)), "buttons", ll_nonNulls(template("#illTakeIt"), possibleDates.lower(date) == null ? null : "Earlier please", possibleDates.higher(date) == null ? null : "Later please")));
      change();
    }

    public String handleInput(String s) {
      Matches m = new Matches();
      if (find3plusRestsX("...earlier...", s, m)) {
        Long date2 = possibleDates.lower(date);
        if (date2 == null)
          return template("#noEarlierDate");
        date = date2;
        resetTemplate();
        makeSteps();
        return "";
      }
      if (find3plusRestsX("...later...", s, m)) {
        Long date2 = possibleDates.higher(date);
        if (date2 == null)
          return template("#noLaterDate");
        date = date2;
        resetTemplate();
        makeSteps();
        return "";
      }
      if (find3(template("#illTakeIt"), s))
        return booking.acceptAppointment(cancelMe(), date);
      return null;
    }

    public boolean allowGeneralOverride() {
      return true;
    }
  }

  static public class ProposeAppointmentsForm extends FormInFlight {

    public int maxDatesToShow = 2;

    public List<Long> possibleDates;

    public List<String> dateTexts;

    public ProposeAppointmentsForm() {
    }

    public ProposeAppointmentsForm(Collection<Long> possibleDates, int maxDatesToShow) {
      this.possibleDates = booking.pickDates(maxDatesToShow, possibleDates);
      this.maxDatesToShow = maxDatesToShow;
      dateTexts = map(d -> booking.formatDate(d), this.possibleDates);
      makeSteps();
    }

    public void makeSteps() {
      steps = ll(nu(FormStep.class, "key", "select", "buttons", dateTexts));
      change();
    }

    public String handleInput(String s) {
      Matches m = new Matches();
      for (int i = 0; i < l(dateTexts); i++) if (cic(s, dateTexts.get(i))) {
        long date = possibleDates.get(i);
        return booking.acceptAppointment(cancelMe(), date);
      }
      return null;
    }

    public boolean allowGeneralOverride() {
      return true;
    }
  }

  static public class TakeUserInfoForm extends FormInFlight {

    public long date;

    public TakeUserInfoForm() {
    }

    public TakeUserInfoForm(long date) {
      this.date = date;
      steps.add(nu(FormStep.class, "key", "name", "displayText", template("#bookingYouForPlusName", "date", booking.formatDate(date)), "placeholder", template("#yourName")));
      steps.add(nu(USPhoneNrStep.class, "key", "phone", "displayText", template("#pleaseEnterAPhoneNr"), "placeholder", template("#yourPhoneNr")));
    }

    public String complete() {
      try {
        BookingConfig conf = booking.conf;
        if (!conversation.testMode) {
          String name = shorten(getValue("name"), 50);
          String title = conf.eventKeyword + " " + conf.appointmentName + " with " + name;
          Event event = new Event().setSummary(title).setLocation(conf.businessName).setDescription("Booked through chat bot on " + ymdWithSlashes(nowInConv(conversation), localTimeZone()) + ". Phone contact: " + getValue("phone"));
          DateTime startDateTime = new DateTime(new java.util.Date(date), localTimeZone());
          EventDateTime start = new EventDateTime().setDateTime(startDateTime).setTimeZone(timeZoneForGoogleAPI);
          event.setStart(start);
          long endDate = date + minutesToMS(conf.appointmentDuration);
          DateTime endDateTime = new DateTime(new java.util.Date(endDate), localTimeZone());
          EventDateTime end = new EventDateTime().setDateTime(endDateTime).setTimeZone(timeZoneForGoogleAPI);
          event.setEnd(end);
          event = booking.googleCalendarService.events().insert("primary", event).execute();
          print("Event created: " + event.getHtmlLink());
          if (!isDummyPhoneNr(getValue("phone")))
            startThread("Twilio", new Runnable() {

              public void run() {
                try {
                  booking.initTwilio();
                  if (!booking.twilioInited()) {
                    print("Twilio not available");
                    return;
                  }
                  print("Sending Twilio msg");
                  String text = conf.smsTemplate;
                  text = replaceIC(text, "[date]", ymd(date, localTimeZone()));
                  text = replaceIC(text, "[time]", timeInZone_24(date, localTimeZone()));
                  text = replaceIC(text, "[business]", conf.businessName);
                  text = replaceIC(text, "[appointment]", conf.appointmentName);
                  text = replaceIC(text, "[name]", name);
                  String cleanedPhoneNr = trim(getValue("phone"));
                  if (!startsWithOneOf(cleanedPhoneNr, "+1", "1-", "1 ", "1("))
                    cleanedPhoneNr = "1" + cleanedPhoneNr;
                  cleanedPhoneNr = "+" + digitsOnly(cleanedPhoneNr);
                  print("Cleaned phone number: " + cleanedPhoneNr);
                  print("SMS text: " + text);
                  Object message = call(booking.twilio(), "twilioSend", conf.twilioPhoneNr, cleanedPhoneNr, text);
                  print("Twilio msg sent: " + message);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "booking.initTwilio();\r\n        if (!booking.twilioInited()) { print(\"Twilio n...";
              }
            });
        }
        return template("#youAreBooked", "name", getValue("name"), "date", booking.formatDate(date));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class USPhoneNrStep extends FormStep {

    public String verifyData(String s) {
      s = digitsOnly(s);
      if (contains(usAreaCodes(), takeFirst(s, 3)) || startsWith(s, "1") && contains(usAreaCodes(), substring(s, 1, 4))) {
      } else
        return template("#invalidAreaCode");
      if (countDigitsInString(s) < 7)
        return template("#tooFewDigits");
      return null;
    }
  }

  static public long nowInConv(Conversation conv) {
    return conv.testMode ? testModeDate() : now();
  }

  static public class TestScript extends Concept {

    static final public String _fieldOrder = "scriptName comments active lastRun testedOK botLinePattern1 userLine1 botLinePattern2 userLine2 botLinePattern3 userLine3 botLinePattern4 userLine4 botLinePattern5 userLine5 botLinePattern6 userLine6 botLinePattern7 userLine7 botLinePattern8 userLine8";

    public String scriptName, comments;

    public boolean active = false;

    public long lastRun;

    public boolean testedOK = false;

    public String botLinePattern1, userLine1;

    public String botLinePattern2, userLine2;

    public String botLinePattern3, userLine3;

    public String botLinePattern4, userLine4;

    public String botLinePattern5, userLine5;

    public String botLinePattern6, userLine6;

    public String botLinePattern7, userLine7;

    public String botLinePattern8, userLine8;

    public int highestIndex() {
      return 8;
    }

    public String botLinePattern(int i) {
      return trim(getString(this, "botLinePattern" + i));
    }

    public String userLine(int i) {
      return trim(getString(this, "userLine" + i));
    }
  }

  static public class TestScripting {

    static public Object html(String uri, Map<String, String> params, AuthedDialogID auth) {
      String uri2 = appendSlash(uri);
      boolean requestAuthed = auth != null;
      if (startsWith(uri2, "/testscripts/")) {
        if (!requestAuthed)
          return serveAuthForm(params.get("uri"));
        return serveTestScriptingAdmin(uri, params);
      }
      return null;
    }

    static public Object serveTestScriptingAdmin(String uri, Map<String, String> params) {
      String nav = p(ahref(rawBotLink(dbBotID), "Main admin") + " | " + ahref(baseLink + "/testscripts", "Test scripts admin"));
      if (ewic(uri, "/run-test")) {
        long id = parseLong(params.get("id"));
        TestScript script = getConcept(TestScript.class, id);
        if (script == null)
          return "Script " + id + " not found";
        String output = hijackPrint_tee_pcall(() -> runTestScript(script));
        String title = "Test results for script: " + script.scriptName;
        return hhtml(hhead_title(title) + hbody(hsansserif() + nav + h1(title) + hsourcecode(output)));
      }
      HCRUD_Concepts<TestScript> data = new HCRUD_Concepts<>(TestScript.class);
      HCRUD crud = new HCRUD(rawLink("testscripts"), data) {

        public String frame(String title, String contents) {
          return hhtml(hhead_title_htmldecode(title) + hbody(hsansserif() + hcss_responstable() + nav + h1(title) + contents));
        }

        public String renderValue(String field, Object value) {
          if (eq(field, "lastRun"))
            return renderHowLongAgo(toLong(value));
          return super.renderValue(field, value);
        }
      };
      crud.renderCmds = item -> crud.renderCmds_base(item) + " | " + ahref(rawLink("testscripts/run-test" + hquery("id", item.get("id"))), "run test");
      crud.cmdsLeft = true;
      crud.tableClass = "responstable";
      crud.uneditableFields = litset("lastRun", "testedOK");
      return subBot_serveHTMLNoCache(crud.renderPage(params));
    }

    static public void runTestScript(TestScript script) {
      try {
        WebBotTester tester = new WebBotTester(programID());
        try {
          tester.params.put("testMode", "1");
          tester.start();
          int i = 0;
          for (int idx = 1; idx <= script.highestIndex(); idx++) {
            String pat = script.botLinePattern(idx);
            if (nempty(pat)) {
              print("Bot line pattern: " + pat);
              tester.waitForMessages(i + 1);
              WebChatBotMsg msg = get(tester.msgs, i);
              try {
                assertTrueVerbose(i + ": " + pat + "/" + msg.msgText, mmo2_match(pat, msg.msgText));
                assertTrue("fromBot", !msg.fromUser);
              } catch (Throwable _e) {
                print("msgs", tester.msgs);
                throw rethrow(_e);
              }
              ++i;
            }
            String userLine = script.userLine(idx);
            if (nempty(userLine)) {
              print("Sending line: " + userLine);
              tester.sendMsg(userLine);
              ++i;
            }
          }
          print("Script OK: " + script.scriptName);
          cset(script, "testedOK", true);
        } finally {
          _close(tester);
        }
      } catch (Throwable e) {
        printStackTrace(e);
        cset(script, "testedOK", false);
      }
      cset(script, "lastRun", now());
    }
  }

  public static void main(final String[] args) throws Exception {
    standardTimeZone_name = timeZone;
    thoughtBot = mc();
    baseLink = "https://botcompany.de/" + psI(programID()) + "/raw";
    pWebChatBot();
    booking = new Booking();
  }

  static public void processParams(Map<String, String> map) {
  }

  static public ThreadLocal<Out> out = new ThreadLocal();

  static public ThreadLocal<Conversation> conv = new ThreadLocal();

  static transient public long lastConversationChange = now();

  static public boolean testFunctions = false;

  static public class FormStep {

    public String key;

    public String displayText, desc;

    public String defaultValue;

    public String placeholder;

    public List<String> buttons;

    public boolean allowFreeText = false;

    public String value;

    public void update(Runnable onChange) {
    }

    public String verifyData(String s) {
      return null;
    }
  }

  static public class FormInFlight {

    public Conversation conversation;

    public String hashTag;

    public List<FormStep> steps = new ArrayList();

    public int stepIndex;

    public String handleInput(String s) {
      return null;
    }

    public FormStep currentStep() {
      return get(steps, stepIndex);
    }

    public void update(Runnable onChange) {
      if (currentStep() != null)
        currentStep().update(onChange);
    }

    public String complete() {
      return "Form complete";
    }

    public String cancel() {
      return "Request cancelled";
    }

    public FormStep byKey(String key) {
      return objectWhere(steps, "key", key);
    }

    public String getValue(String key) {
      FormStep step = byKey(key);
      return step == null ? null : step.value;
    }

    public Map<String, String> allValues() {
      Map<String, String> map = litorderedmap();
      for (FormStep step : steps) map.put(step.key, step.value);
      return map;
    }

    public boolean allowGeneralOverride() {
      return false;
    }

    public Conversation cancelMe() {
      Conversation conv = conversation;
      conversation.cancelForm();
      return conv;
    }

    public void change() {
      if (conversation != null)
        conversation.change();
    }
  }

  static public boolean debug = false;

  static public String answer(String s) {
    out.set(new Out());
    if (creator() == null)
      if (match("debug", s))
        debug = true;
    String a = rawAnswer(s);
    List<String> tokHashtags = regexpICMatchesAsCNC(regexpNegativeLookbehind("\\w") + "#\\w+\\b", a);
    for (int i = 1; i < l(tokHashtags); i += 2) {
      print("Found hashtag " + tokHashtags.get(i));
    }
    a = join(tokHashtags);
    return deliverAnswerAndFormStep(a);
  }

  static public String rawAnswer(String s) {
    FormInFlight form = conv.get().form;
    String a = null;
    Object bot = getDBBot();
    out.get().proposeMode = true;
    String generalAnswer;
    {
      AutoCloseable __16 = tempSetTL((ThreadLocal) getOpt(bot, "opt_noDefault"), true);
      try {
        generalAnswer = (String) call(bot, "answer", s, conv.get().language());
      } finally {
        _close(__16);
      }
    }
    if (generalAnswer == null) {
      try {
        generalAnswer = booking.answer(s, conv.get());
        print("Booking answer to " + s + ": " + generalAnswer + " with form: " + out.get().proposedForm);
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
    out.get().proposeMode = false;
    if (form != null && generalAnswer != null && form.allowGeneralOverride())
      conv.get().cancelForm();
    else if (form != null) {
      if ((a = form.handleInput(s)) != null)
        return a;
      if (eqicOneOf(s, "cancel", "Abbrechen", unicode_crossProduct())) {
        String answer = form.cancel();
        conv.get().cancelForm();
        return answer;
      } else if (eqicOneOf(s, "back", "zurück", unicode_undoArrow()) && form.stepIndex > 0) {
        --form.stepIndex;
        conv.get().change();
        return "";
      } else if (form.currentStep() != null) {
        FormStep step = form.currentStep();
        if (!step.allowFreeText && nempty(step.buttons) && !cic(step.buttons, s))
          return de() ? "Bitte wählen Sie eine Option!" : "Please choose an option.";
        print("Verifying data " + quote(s) + " in step " + step);
        String error = step.verifyData(s);
        if (error != null)
          return error;
        step.value = s;
        ++form.stepIndex;
        conv.get().change();
        if (form.currentStep() == null) {
          String answer = form.complete();
          if (conv.get().form == form)
            conv.get().cancelForm();
          return answer;
        }
        return "";
      }
    }
    a = generalAnswer;
    if (a == null)
      a = (String) call(bot, "answer", "#default", conv.get().language());
    if (out.get().proposedForm != null)
      conv.get().setForm(out.get().proposedForm);
    return a;
  }

  static public String deliverAnswerAndFormStep(String answer) {
    FormInFlight form = conv.get().form;
    if (form == null || form.currentStep() == null)
      return answer;
    FormStep step = form.currentStep();
    printVars_str("answer", answer, "displayText", step.displayText);
    answer = joinNemptiesWithSpace(answer, step.displayText);
    out.get().placeholder = or(step.placeholder, step.displayText);
    print("Step " + form.stepIndex + ": " + sfu(step));
    out.get().defaultInput = or2(step.value, step.defaultValue);
    out.get().buttons = cloneList(step.buttons);
    if (form.stepIndex > 0)
      out.get().buttons.add(de() ? "Zurück" : "Back");
    out.get().buttons.add(de() ? "Abbrechen" : "Cancel");
    return answer;
  }

  static public String initialMessage() {
    if (out.get() != null)
      out.get().placeholder = template("#typeADay");
    if (booking.conf.dateSuggestionsInGreeting == 0)
      return getCannedAnswer("#greetingWithoutSuggestions", conv.get());
    if (booking.anyBookingPossible()) {
      try {
        print("Booking possible");
        LongRange range = booking.maxLead(nowInConv(conv.get()));
        TreeSet<Long> possibleDates = booking.possibleDates(range, conv.get().testMode);
        print("Possible dates: " + l(possibleDates));
        if (nempty(possibleDates)) {
          proposeForm(new ProposeAppointmentsForm(possibleDates, booking.conf.dateSuggestionsInGreeting));
          return getCannedAnswer("#greeting", conv.get());
        }
        return template("#greetingBookedOut");
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
    return getCannedAnswer("#bookingClosed", conv.get());
  }

  static public Object getDBBot() {
    return getBot(dbBotID);
  }

  static public boolean de() {
    return eqic(conv.get().language(), "de");
  }

  static public Object thoughtBot;

  static public int longPollTick = 200;

  static public int longPollMaxWait = 1000 * 30;

  static public int activeConversationSafetyMargin = 15000;

  static public Set<String> specialButtons = litciset("Cancel", "Back", "Abbrechen", "Zurück");

  static public class Out extends DynamicObject {

    public List<String> buttons;

    public boolean multipleChoice = false;

    public String multipleChoiceSeparator;

    public String placeholder;

    public String defaultInput;

    public Integer progressBarValue;

    public boolean glow = false;

    transient public boolean proposeMode = false;

    transient public FormInFlight proposedForm;
  }

  static public class Msg extends DynamicObject {

    public long time;

    public boolean fromUser = false;

    public Worker fromWorker;

    public String text;

    public Out out;

    public Msg() {
    }

    public Msg(boolean fromUser, String text) {
      this.text = text;
      this.fromUser = fromUser;
      time = now();
    }

    public Msg(String text, boolean fromUser) {
      this.fromUser = fromUser;
      this.text = text;
      time = now();
    }
  }

  static public class AuthedDialogID extends Concept {

    public String dialogID;

    public Worker loggedIn;
  }

  static public class Conversation extends Concept {

    static final public String _fieldOrder = "cookie ip country oldDialogs msgs lastPing botOn worker userTyping botTyping testMode dryRun proposedForm form language lastProposedDate";

    public String cookie, ip, country;

    public List<List<Msg>> oldDialogs = new ArrayList();

    public List<Msg> msgs = new ArrayList();

    public long lastPing;

    public boolean botOn = true;

    public Worker worker;

    transient public long userTyping, botTyping;

    public boolean testMode = false;

    transient public boolean dryRun = false;

    transient public FormInFlight proposedForm;

    public FormInFlight form;

    public String language;

    public Long lastProposedDate;

    public void add(Msg m) {
      m.text = trim(m.text);
      if (!m.fromUser && empty(m.text))
        return;
      syncAdd(msgs, m);
      noteConversationChange();
      change();
      vmBus_send("chatBot_messageAdded", mc(), this, m);
    }

    public int allCount() {
      return lengthLevel2(oldDialogs) + l(msgs);
    }

    public int archiveSize() {
      return lengthLevel2(oldDialogs);
    }

    public long lastMsgTime() {
      Msg m = last(msgs);
      return m == null ? 0 : m.time;
    }

    public void cancelForm() {
      if (form != null) {
        print("Cancelling form " + form);
        form.conversation = null;
        cset(this, "form", null);
      }
    }

    public <A extends FormInFlight> A setForm(A form) {
      form.conversation = this;
      cset(this, "form", form);
      return form;
    }

    public String language() {
      return or2(language, "en");
    }

    public void updateForm() {
      if (form != null)
        form.update(new Runnable() {

          public void run() {
            try {
              change();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "change();";
          }
        });
    }

    public void turnBotOff() {
      cset(this, "botOn", false);
      noteConversationChange();
      updateForm();
    }

    public void turnBotOn() {
      cset(this, "botOn", true, "worker", null);
      String backMsg = getCannedAnswer("#botBack", this);
      if (empty(msgs) || lastMessageIsFromUser() || !eq(last(msgs).text, backMsg))
        add(new Msg(backMsg, false));
      noteConversationChange();
    }

    public boolean lastMessageIsFromUser() {
      return nempty(msgs) && last(msgs).fromUser;
    }

    public void newDialog() {
      cancelForm();
      lastProposedDate = null;
      oldDialogs.add(msgs);
      cset(this, "msgs", new ArrayList());
      change();
      vmBus_send("chatBot_clearedSession", mc(), this);
    }
  }

  static public class ProposedMsg extends Concept {

    static final public String _fieldOrder = "authoringObject text conversation said";

    public Object authoringObject;

    public String text;

    public Conversation conversation;

    public Msg said;
  }

  static public void pWebChatBot() {
    dbIndexing(Conversation.class, "cookie", Conversation.class, "worker", Conversation.class, "lastPing", Worker.class, "loginName", AuthedDialogID.class, "dialogID");
    Class envType = fieldType(thoughtBot, "env");
    if (envType != null)
      setOpt(thoughtBot, "env", proxy(envType, (Object) mc()));
  }

  static public Object html(String uri, Map<String, String> params) {
    AutoCloseable __17 = tempRegisterThread();
    try {
      if (eqic(uri, "/twilioWebhook"))
        return booking.serveTwilioWebhook(uri, params);
      String cookie = params.get("cookie");
      if (empty(cookie)) {
        registerVisitor();
        cookie = cookieSent();
      }
      boolean workerMode = nempty(params.get("workerMode")) || startsWith(uri, "/worker");
      Conversation conv = nempty(cookie) ? getConv(cookie) : null;
      if (conv != null && !workerMode)
        cset(conv, "ip", subBot_clientIP());
      print("URI: " + uri + ", cookie: " + cookie + ", msgs: " + l(conv.msgs));
      String dialogID = getDialogID();
      String pw = trim(params.get("pw"));
      if (nempty(pw)) {
        String realPW = loadSecretTextFileOrCreateWithRandomID("password.txt");
        if (neq(pw, realPW))
          return errorMsg("Bad password, please try again");
        uniq(AuthedDialogID.class, "dialogID", dialogID);
        if (nempty(params.get("redirect")))
          return hrefresh(params.get("redirect"));
      }
      Matches m = new Matches();
      if (startsWith(uri, "/worker-image/", m)) {
        long id = parseLong(m.rest());
        return subBot_serveFile(workerImageFile(id), "image/jpeg");
      }
      AuthedDialogID auth = authObject();
      boolean requestAuthed = auth != null;
      if (eq(uri, "/stats")) {
        if (!requestAuthed)
          return serveAuthForm(rawLink(uri));
        return "Threads: " + ul_htmlEncode(getThreadNames(registeredThreads()));
      }
      if (eq(uri, "/logs")) {
        if (!requestAuthed)
          return serveAuthForm(rawLink(uri));
        return webChatBotLogsHTML2(rawLink(uri), params);
      }
      if (eq(uri, "/auth-only")) {
        if (eq(params.get("logout"), "1"))
          cdelete(AuthedDialogID.class, "dialogID", getDialogID());
        if (!requestAuthed)
          return serveAuthForm(params.get("uri"));
        return "";
      }
      if (workerChat != null) {
        var __13 = workerChat.html(uri, params, conv, auth);
        if (__13 != null)
          return __13;
      }
      if (booking != null) {
        var __14 = booking.html(uri, params, auth);
        if (__14 != null)
          return __14;
      }
      {
        var __15 = TestScripting.html(uri, params, auth);
        if (__15 != null)
          return __15;
      }
      {
        Lock __10 = dbLock();
        lock(__10);
        try {
          String message = trim(params.get("btn"));
          if (empty(message))
            message = trim(params.get("message"));
          if (match("new dialog", message)) {
            conv.newDialog();
            message = null;
          }
          main.conv.set(conv);
          if (!workerMode && empty(conv.msgs))
            addReplyToConvo(conv, () -> deliverAnswerAndFormStep(initialMessage()));
          if (nempty(message) && !lastUserMessageWas(conv, message)) {
            print("Adding message: " + message);
            if (workerMode) {
              Msg msg = new Msg(false, message);
              msg.fromWorker = auth.loggedIn;
              conv.add(msg);
            } else
              conv.add(new Msg(true, message));
          }
          String testMode = params.get("testMode");
          if (nempty(testMode)) {
            print("Setting testMode", testMode);
            cset(conv, "testMode", eq("1", testMode));
          }
          if (!workerMode && conv.botOn && nempty(conv.msgs) && last(conv.msgs).fromUser)
            addReplyToConvo(conv, () -> makeReply(last(conv.msgs).text));
        } finally {
          unlock(__10);
        }
      }
      if (eq(uri, "/msg"))
        return withHeader("OK");
      if (eq(uri, "/typing")) {
        if (workerMode) {
          conv.botTyping = sysNow();
          print(conv.botTyping + " Bot typing in: " + conv.cookie);
        } else {
          conv.userTyping = sysNow();
          print(conv.userTyping + " User typing in: " + conv.cookie);
        }
        return withHeader("OK");
      }
      if (eq(uri, "/incremental")) {
        vmBus_send("chatBot_userPolling", mc(), conv);
        cset(conv, "lastPing", now());
        int a = parseInt(params.get("a"));
        long start = sysNow();
        List msgs;
        boolean first = true;
        while (licensed() && sysNow() < start + longPollMaxWait) {
          int as = conv.archiveSize();
          msgs = cloneSubList(conv.msgs, a - as);
          boolean newDialog = a <= as;
          long typing = workerMode ? conv.userTyping : conv.botTyping;
          boolean otherPartyTyping = typing > start;
          if (empty(msgs) && !otherPartyTyping) {
            if (first) {
              print("Long poll starting on " + cookie + ", " + a + "/" + a);
              first = false;
            }
            sleep(longPollTick);
          } else {
            if (first)
              print("Long poll ended.");
            StringBuilder buf = new StringBuilder();
            if (otherPartyTyping) {
              print("Noticed " + (workerMode ? "user" : "bot") + " typing in " + conv.cookie);
              buf.append(hscript("showTyping();"));
            }
            renderMessages(buf, msgs);
            if (ariaLiveTrick2 && !workerMode) {
              Msg msg = lastBotMsg(msgs);
              if (msg != null) {
                String author = msg.fromWorker != null ? htmlEncode2(msg.fromWorker.displayName) : botName;
                buf.append(hscript("$(\"#screenreadertrick\").html(" + jsQuote(author + " says: " + msg.text) + ");"));
              }
            }
            if (a != 0 && anyInterestingMessages(msgs, workerMode))
              buf.append(hscript("window.playChatNotification();\n" + "window.setTitleStatus(" + jsQuote((workerMode ? "User" : botName) + " says…") + ");"));
            return withHeader("<!-- " + conv.allCount() + " " + (newDialog ? "NEW DIALOG " : "") + "-->\n" + buf);
          }
        }
        return withHeader("");
      }
      {
        Lock __11 = dbLock();
        lock(__11);
        try {
          processParams(params);
          String html = loadSnippet(templateID);
          String workerModeParam = workerMode ? "workerMode=1&" : "";
          String langlinks = "<!-- langlinks here -->";
          if (html.contains(langlinks))
            html = html.replace(langlinks, ahref(rawLink("eng"), "English") + " | " + ahref(rawLink("deu"), "German"));
          html = html.replace("#BOTIMG#", imageSnippetURLOrEmptyGIF(chatHeaderImageID));
          html = html.replace("#N#", "0");
          html = html.replace("#INCREMENTALURL#", baseLink + "/incremental?" + workerModeParam + "a=");
          html = html.replace("#MSGURL#", baseLink + "/msg?" + workerModeParam + "message=");
          html = html.replace("#TYPINGURL#", baseLink + "/typing?" + workerModeParam);
          html = html.replace("#CSS_ID#", psI_str(cssID));
          if (ariaLiveTrick || ariaLiveTrick2)
            html = html.replace("aria-live=\"polite\">", ">");
          html = html.replace("#OTHERSIDE#", workerMode ? "User" : "Representative");
          if (nempty(params.get("debug")))
            html = html.replace("var showActions = false;", "var showActions = true;");
          html = html.replace("#AUTOOPEN#", jsBool(workerMode || botAutoOpen()));
          html = html.replace("#BOT_ON#", jsBool(botOn()));
          html = html.replace("$HEADING", heading);
          html = html.replace("#WORKERMODE", jsBool(workerMode));
          html = html.replace("<!-- MSGS HERE -->", "");
          html = hreplaceTitle(html, heading);
          if (eqGet(params, "_botDemo", "1"))
            return hhtml(hhead(htitle(heading) + loadJQuery()) + hbody(hjavascript(html)));
          else
            return withHeader(subBot_serveJavaScript(html));
        } finally {
          unlock(__11);
        }
      }
    } finally {
      _close(__17);
    }
  }

  static public void addReplyToConvo(Conversation conv, IF0<String> think) {
    out.set(new Out());
    String reply = "";
    try {
      reply = think.get();
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    Msg msg = new Msg(false, reply);
    msg.out = out.get();
    conv.add(msg);
  }

  static public Object withHeader(String html) {
    return withHeader(subBot_noCacheHeaders(subBot_serveHTML(html)));
  }

  static public Object withHeader(Object response) {
    call(response, "addHeader", "Access-Control-Allow-Origin", "*");
    return response;
  }

  static public String renderMessageText(String text, boolean htmlEncode) {
    text = trim(text);
    if (htmlEncode)
      text = htmlEncode2(text);
    text = nlToBr(text);
    return replace(text, ":wave:", html_wavingHand());
  }

  static public void renderMessages(StringBuilder buf, List<Msg> msgs) {
    if (empty(msgs))
      return;
    Set<String> buttonsToSkip = new HashSet();
    List<String> buttonsHtml = new ArrayList();
    for (Msg m : msgs) {
      if (!m.fromUser && eq(m.text, "-"))
        continue;
      String html = renderMessageText(m.text, shouldHtmlEncodeMsg(m));
      if (m == last(msgs) && m.out != null) {
        for (String btn : unnullForIteration(m.out.buttons)) if (specialButtons.contains(btn)) {
          buttonsToSkip.add(btn);
          buttonsHtml.add(renderButtons(ll(btn)));
        }
      }
      if (nempty(buttonsHtml) && l(m.out.buttons) == l(buttonsToSkip))
        html += " " + hspan("&nbsp;&nbsp;", "class", "chat-button-span") + lines(buttonsHtml);
      else
        buttonsToSkip.clear();
      appendMsg(buf, m.fromUser ? defaultUserName() : botName, formatTime(m.time), html, !m.fromUser, m.fromWorker);
    }
    appendButtons(buf, last(msgs).out, buttonsToSkip);
  }

  static public void appendMsg(StringBuilder buf, String name, String time, String text, boolean bot, Worker fromWorker) {
    boolean useTrick = ariaLiveTrick;
    String tag = useTrick ? "div" : "span";
    if (bot) {
      String id = randomID();
      String author = fromWorker != null ? htmlEncode2(fromWorker.displayName) : botName;
      if (fromWorker != null)
        buf.append("<div class=\"chat_botname\"><p>" + author + "</p>");
      buf.append("<" + tag + " class=\"chat_msg_item chat_msg_item_admin\"" + (useTrick ? " id=\"" + id + "\" aria-live=\"polite\" tabindex=\"-1\"" : "") + ">");
      String imgURL = snippetImgLink(botImageID);
      if (fromWorker != null && fileExists(workerImageFile(fromWorker.id)))
        imgURL = fullRawLink("worker-image/" + fromWorker.id);
      if (nempty(imgURL))
        buf.append("\r\n        <div class=\"chat_avatar\">\r\n          <img src=\"$IMG\"/>\r\n        </div>".replace("$IMG", imgURL));
      buf.append("<span class=\"sr-only\">" + (fromWorker != null ? "" : botName + " ") + "says</span>");
      buf.append(text);
      buf.append("</" + tag + ">");
      if (fromWorker != null)
        buf.append("</div>");
      if (useTrick)
        buf.append(hscript("$('#" + id + "').focus();"));
    } else
      buf.append(("\r\n      <span class=\"sr-only\">You say</span>\r\n      <" + tag + " class=\"chat_msg_item chat_msg_item_user\"" + (useTrick ? " aria-live=\"polite\"" : "") + ">$TEXT</" + tag + ">\r\n    ").replace("$TEXT", text));
  }

  static public String replaceButtonText(String s) {
    if (eqicOneOf(s, "back", "zurück"))
      return unicode_undoArrow();
    if (eqicOneOf(s, "cancel", "Abbrechen"))
      return unicode_crossProduct();
    return s;
  }

  static public String renderMultipleChoice(List<String> buttons, Collection<String> selections, String multipleChoiceSeparator) {
    print("selections", selections);
    Set<String> selectionSet = asCISet(selections);
    String rand = randomID();
    String className = "chat_multiplechoice_" + rand;
    String allCheckboxes = "$(\"." + className + "\")";
    return joinWithBR(map(buttons, name -> hcheckbox("", contains(selectionSet, name), "value", name, "class", className) + " " + name)) + "<br>" + hbuttonOnClick_returnFalse("OK", "submitMsg()", "style", "float: right") + hscript(allCheckboxes + ".change(function() {" + " var theList = $('." + className + ":checkbox:checked').map(function() { return this.value; }).get();" + "  console.log('theList: ' + theList);" + "  $('#chat_message').val(theList.join(" + jsQuote(multipleChoiceSeparator) + "));" + "});");
  }

  static public String renderButtons(List<String> buttons) {
    List<String> out = new ArrayList();
    for (int i = 0; i < l(buttons); i++) {
      String code = buttons.get(i);
      String text = replaceButtonText(code);
      out.add(hbuttonOnClick_returnFalse(text, "submitAMsg(" + jsQuote(text) + ")", "class", "chatbot-choice-button", "title", eq(code, text) ? null : code));
      if (!specialButtons.contains(code) && i + 1 < l(buttons) && specialButtons.contains(buttons.get(i + 1)))
        out.add("&nbsp;&nbsp;");
    }
    return lines(out);
  }

  static public void appendButtons(StringBuilder buf, Out out, Set<String> buttonsToSkip) {
    String placeholder = out == null ? "" : unnull(out.placeholder);
    String defaultInput = out == null ? "" : unnull(out.defaultInput);
    buf.append(hscript("chatBot_setInput(" + jsQuote(defaultInput) + ", " + jsQuote(placeholder) + ");"));
    if (out == null)
      return;
    List<String> buttons = listMinusSet(out.buttons, buttonsToSkip);
    if (empty(buttons))
      return;
    printVars_str("buttons", buttons, "buttonsToSkip", buttonsToSkip);
    String buttonsHtml;
    if (out.multipleChoice)
      buttonsHtml = renderMultipleChoice(buttons, mcSplit(out.defaultInput, out.multipleChoiceSeparator), out.multipleChoiceSeparator);
    else
      buttonsHtml = renderButtons(buttons);
    buf.append("<span class=\"chat_msg_item chat_msg_item_admin chat_buttons\">");
    buf.append(buttonsHtml);
    buf.append("</span>");
  }

  static public void appendDate(StringBuilder buf, String date) {
    buf.append("\r\n  <div class=\"chat-box-single-line\">\r\n    <abbr class=\"timestamp\">DATE</abbr>\r\n  </div>".replace("DATE", date));
  }

  static public boolean lastUserMessageWas(Conversation conv, String message) {
    Msg m = last(conv.msgs);
    return m != null && m.fromUser && eq(m.text, message);
  }

  static public String makeReply(String message) {
    try {
      return answer(message);
    } catch (Throwable e) {
      printStackTrace(e);
      return "Internal error";
    }
  }

  static public String formatTime(long time) {
    return timeInTimeZoneWithOptionalDate_24(timeZone, time);
  }

  static public String formatDialog(String id, List<Msg> msgs) {
    List<String> lc = new ArrayList();
    for (Msg m : msgs) lc.add(htmlencode((m.fromUser ? "> " : "< ") + m.text));
    return id + ul(lc);
  }

  static public Conversation getConv(final String cookie) {
    return withDBLock(new F0<Conversation>() {

      public Conversation get() {
        try {
          return uniq(Conversation.class, "cookie", cookie);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return uniq(Conversation, +cookie);";
      }
    });
  }

  static public String serveAuthForm(String redirect) {
    return hhtml(hhead(htitle("Authorization required")) + hbody(hfullcenter(h3_htmlEncode(heading + " Admin") + hpostform(hhidden("redirect", redirect) + "Password: " + hpassword("pw") + "<br><br>" + hsubmit()))));
  }

  static public String errorMsg(String msg) {
    return hhtml(hhead_title("Error") + hbody(hfullcenter(msg + "<br><br>" + ahref(jsBackLink(), "Back"))));
  }

  static public String defaultUserName() {
    return de() ? "Sie" : "You";
  }

  static public boolean botOn() {
    return isTrue(call(getDBBot(), "botOn"));
  }

  static public boolean botAutoOpen() {
    return isTrue(call(getDBBot(), "botAutoOpen"));
  }

  static public File workerImageFile(long id) {
    return id == 0 ? null : javaxDataDir("adaptive-bot/images/" + id + ".jpg");
  }

  static public long activeConversationTimeout() {
    return longPollMaxWait + activeConversationSafetyMargin;
  }

  static public AuthedDialogID authObject() {
    return conceptWhere(AuthedDialogID.class, "dialogID", getDialogID());
  }

  static public boolean anyInterestingMessages(List<Msg> msgs, boolean workerMode) {
    return any(msgs, m -> m.fromUser == workerMode);
  }

  static public boolean shouldHtmlEncodeMsg(Msg msg) {
    return msg.fromUser;
  }

  static public String getCountry(Conversation c) {
    if (empty(c.country) && nempty(c.ip))
      cset(c, "country", ipToCountry2020_safe(c.ip));
    return or2(c.country, "?");
  }

  static public void noteConversationChange() {
    lastConversationChange = now();
  }

  static public void addTimeout(double seconds, Runnable action) {
    doAfter(seconds, action);
    print("Timeout added: " + seconds + " => " + action);
  }

  static public String template(String hashtag, Object... params) {
    return replaceSquareBracketVars(getCannedAnswer(hashtag), params);
  }

  static public String getCannedAnswer(String hashtag) {
    return getCannedAnswer(hashtag, null);
  }

  static public String getCannedAnswer(String hashtag, Conversation conv) {
    if (!startsWith(hashtag, "#"))
      return hashtag;
    String lang = conv == null ? "en" : conv.language();
    AutoCloseable __18 = tempSetTL((ThreadLocal) getOpt(getDBBot(), "opt_noDefault"), true);
    try {
      return or2((String) call(getDBBot(), "answer", hashtag, lang), hashtag);
    } finally {
      _close(__18);
    }
  }

  static public List<String> mcSplit(String input, String multipleChoiceSeparator) {
    return trimAll(splitAt(input, dropSpaces(multipleChoiceSeparator)));
  }

  static public Msg lastBotMsg(List<Msg> l) {
    return lastThat(l, msg -> !msg.fromUser);
  }

  static public String dbStats() {
    Collection<Conversation> all = list(Conversation.class);
    int nTestConvos = countPred(all, c -> startsWith(c.cookie, "test_"));
    return n2(l(all) - nTestConvos, "real conversation") + ", " + n2(nTestConvos, "test conversation");
  }

  static public void proposeForm(FormInFlight form) {
    proposeForm(conv.get(), form);
  }

  static public void proposeForm(Conversation conversation, FormInFlight form) {
    if (out.get() != null && out.get().proposeMode)
      out.get().proposedForm = form;
    else if (conversation != null)
      conversation.setForm(form);
  }

  static public String californiaTimeZone_string() {
    return "America/Los_Angeles";
  }

  static public String htmlEncode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String htmlEncode2(Object o) {
    return htmlEncode2(strOrEmpty(o));
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public boolean subBot_isHttps() {
    Object httpd = subBot_httpd();
    return eqOneOf(httpd, getOpt(mainBot(), "serveHttps_server"), getOpt(mainBot(), "serveHttpsWithWebsockets_server")) || contains((Collection) getOpt(mainBot(), "serveHttpsWithWebsockets_multiplePorts_servers"), httpd);
  }

  static public Object subBot_serveRedirect(String url) {
    return call(getMainBot(), "serveRedirect", url);
  }

  static public String domain() {
    return domainName();
  }

  static public String domain(String url) {
    return hostNameFromURL(url);
  }

  static public String fullSelfLink(Map<String, String> params) {
    return getActualURI() + htmlQuery(params);
  }

  static public String fullSelfLink() {
    return getActualURI();
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(BitSet bs) {
    return !empty(bs);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(IMultiMap mm) {
    return mm != null && mm.size() != 0;
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public boolean nempty(Rect r) {
    return r != null && r.w != 0 && r.h != 0;
  }

  static public boolean nempty(MultiSet ms) {
    return ms != null && !ms.isEmpty();
  }

  static public String p(Object contents, Object... params) {
    return hfulltag("p", contents, params) + "\n";
  }

  static public String p() {
    return p("");
  }

  static public String ahref(String link, Object contents, Object... params) {
    return link == null ? str(contents) : href(link, contents, params);
  }

  static public String rawBotLink() {
    return rawBotLink(programID());
  }

  static public String rawBotLink(String botID) {
    return "https://" + myDomain() + "/" + parseSnippetID(botID) + "/raw";
  }

  static public String rawBotLink(String botID, String uri) {
    return "https://" + myDomain() + "/" + parseSnippetID(botID) + "/raw" + addPrefix("/", uri);
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public boolean eq(Symbol a, String b) {
    return eq(str(a), b);
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public Concept getConcept(long id) {
    return db_mainConcepts().getConcept(id);
  }

  static public Concept getConcept(Concepts concepts, long id) {
    return concepts.getConcept(id);
  }

  static public <A extends Concept> A getConcept(Class<A> cc, long id) {
    return getConcept(db_mainConcepts(), cc, id);
  }

  static public <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
    Concept c = concepts.getConcept(id);
    if (c == null)
      return null;
    if (!isInstance(cc, c))
      throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
    return (A) c;
  }

  static public byte[] saveFile(String fileName, byte[] contents) {
    return saveBinaryFile(fileName, contents);
  }

  static public byte[] saveFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName, contents);
  }

  static public byte[] decodeBASE64(String s) {
    return base64decode(s);
  }

  static public String hscript(String script) {
    return hjavascript(script);
  }

  static public String h2(String s, Object... params) {
    return tag("h2", s, params);
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public String himgsrc(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", src));
  }

  static public String rawLink(String pageName) {
    return "/" + parseSnippetID(getProgramID()) + "/raw" + addPrefix("/", pageName);
  }

  static public String rawLink() {
    return "/" + parseSnippetID(getProgramID()) + "/raw";
  }

  static public String rawLink(String pageName, String contents) {
    return ahref(rawLink(pageName), contents);
  }

  static public String hpostform(Object contents, Object... params) {
    return tag("form", contents, concatArrays(new Object[] { "method", "POST" }, params));
  }

  static public String hhiddenWithIDAndName(String idAndName) {
    return hhiddenWithIDAndName(idAndName, null);
  }

  static public String hhiddenWithIDAndName(String idAndName, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", idAndName, "name", idAndName, "value", value));
  }

  static public String hfileupload(Object... params) {
    return hinputtag("", paramsPlus_noOverwrite(params, "type", "file", "name", "thefile"));
  }

  static public String hhidden(String name, Object value, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "hidden", "name", name, "value", value }, params));
  }

  static public String hhidden(Map<String, String> map, String... keys) {
    return hiddenFields(map, keys);
  }

  static public String hbuttonOnClick_returnFalse(String text, String onClick, Object... params) {
    return hfulltag("button", text, paramsPlus(params, "onclick", addSuffix(trim(onClick), ";") + " return false;"));
  }

  static public String hhtml(Object contents) {
    return containerTag("html", contents);
  }

  static public String hhead_title(String title) {
    return hhead(htitle(title));
  }

  static public String hsansserif() {
    return hcss("body { font-family: Sans-Serif; }");
  }

  static public String hbody(Object contents, Object... params) {
    return tag("body", contents, params);
  }

  static public String loadJQuery() {
    return "<script src=\"https://code.jquery.com/jquery-1.10.2.js\"></script>";
  }

  static public String hhead_title_htmldecode(String title) {
    return hhead_title_decode(title);
  }

  static public String h1(String s, Object... params) {
    return hfulltag("h1", s, params);
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public String hquery(Map params) {
    return htmlQuery(params);
  }

  static public String hquery(Object... data) {
    return htmlQuery(data);
  }

  static public String hcss_responstable() {
    return hcss("\r\n    .responstable {\r\n      margin: 1em 0;\r\n      width: 100%;\r\n      overflow: visible;\r\n      background: #FFF;\r\n      color: #024457;\r\n      border-radius: 10px;\r\n      border: 1px solid #167F92;\r\n    }\r\n    \r\n    .responstable tr {\r\n      border: 1px solid #D9E4E6;\r\n    }\r\n    .responstable tr:nth-child(odd) {\r\n      background-color: #EAF3F3;\r\n    }\r\n    .responstable th {\r\n      display: none;\r\n      border: 1px solid #FFF;\r\n      background-color: #167F92;\r\n      color: #FFF;\r\n      padding: 1em;\r\n    }\r\n    .responstable th:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n    }\r\n    .responstable th:nth-child(2) {\r\n      display: table-cell;\r\n    }\r\n    .responstable th:nth-child(2) span {\r\n      display: none;\r\n    }\r\n    .responstable th:nth-child(2):after {\r\n      content: attr(data-th);\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th:nth-child(2) span {\r\n        display: block;\r\n      }\r\n      .responstable th:nth-child(2):after {\r\n        display: none;\r\n      }\r\n    }\r\n    .responstable td {\r\n      display: block;\r\n      word-wrap: break-word;\r\n      max-width: 7em;\r\n    }\r\n    .responstable td:first-child {\r\n      display: table-cell;\r\n      text-align: center;\r\n      border-right: 1px solid #D9E4E6;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable td {\r\n        border: 1px solid #D9E4E6;\r\n      }\r\n    }\r\n    .responstable th, .responstable td {\r\n      text-align: left;\r\n      margin: .5em 1em;\r\n    }\r\n    @media (min-width: 480px) {\r\n      .responstable th, .responstable td {\r\n        display: table-cell;\r\n        padding: 1em;\r\n      }\r\n    }\r\n  ");
  }

  static public String afterLastSlash(String s) {
    if (s == null)
      return null;
    int i = s.lastIndexOf('/');
    return i < 0 ? s : substring(s, i + 1);
  }

  static public String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  static public String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(Object... c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(callF(f, o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    List x = new ArrayList();
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) {
        ping();
        x.add(f.get(e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B> List<A> map(IF1<A, B> f, A data1, A... moreData) {
    List x = emptyList(l(moreData) + 1);
    x.add(f.get(data1));
    if (moreData != null)
      for (A o : moreData) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_csetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cset(Iterable<? extends Concept> l, Object... values) {
    int changes = 0;
    for (Concept c : unnullForIteration(l)) changes += cset(c, values);
    return changes;
  }

  static public <A extends Concept> int cset(Concept.Ref<A> c, Object... values) {
    return cset(getVar(c), values);
  }

  static public boolean cset_trueIfChanged(Concept c, Object... values) {
    try {
      return cset(c, values) != 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map prependEmptyOptionForHSelect(Map map) {
    Map map2 = litorderedmap("", "");
    putAll(map2, map);
    return map2;
  }

  static public LinkedHashMap mapToOrderedMap(Object f, Iterable l) {
    LinkedHashMap map = new LinkedHashMap();
    for (Object o : unnullForIteration(l)) {
      Pair p = (Pair) (callF(f, o));
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
    LinkedHashMap<B, C> map = new LinkedHashMap();
    for (A o : unnullForIteration(l)) {
      Pair<B, C> p = callF(f, o);
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> LinkedHashMap<B, C> mapToOrderedMap(Iterable<A> l, IF1<A, Pair<B, C>> f) {
    return mapToOrderedMap(f, l);
  }

  static public boolean conceptsSortedByFieldCI_verbose = false;

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Class<A> c, String field) {
    return conceptsSortedByFieldCI(db_mainConcepts(), c, field);
  }

  static public <A extends Concept> Collection<A> conceptsSortedByFieldCI(Concepts concepts, Class<A> c, String field) {
    IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexCI)
      return (Collection<A>) asList(((ConceptFieldIndexCI) index).objectIterator());
    if (conceptsSortedByFieldCI_verbose)
      print("conceptsSortedByFieldCI_verbose: Manual sort of " + c + " for " + field);
    return sortedByFieldIC(field, concepts.list(c));
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public String hselect(String name, Map map, Object... params) {
    return hselect(map, paramsPlus_skipFirst(params, "name", name));
  }

  static public String hselect(Map map, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(map))
      for (Object key : keys(map)) {
        Object value = map.get(key);
        String k = str(key);
        buf.append(tag("option", htmlencode(str(or(value, ""))), "value", k, "selected", eq(selected, k) ? "selected" : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public long conceptID(Concept c) {
    return c == null ? 0 : c.id;
  }

  static public long conceptID(Concept.Ref ref) {
    return conceptID(cDeref(ref));
  }

  static public String hsubmit(String text, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "submit", "value", text }, params));
  }

  static public String hsubmit() {
    return hsubmit("Submit");
  }

  static public String hscriptsrc(String src) {
    return hjavascript_src(src);
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
    pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public Class mc() {
    return main.class;
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void printVars_str(Object... params) {
    print(renderVars_str(params));
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Collection<A> c, final Object f) {
    return sortByCalculatedFieldDesc_inPlace(cloneList(c), f);
  }

  static public <A> List<A> sortByCalculatedFieldDesc(Object f, Collection<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(Iterable<A> c, IF1<A, B> f) {
    List<A> l = cloneList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return stdcompare(f.get(b), f.get(a));
      }
    });
    return l;
  }

  static public <A, B> List<A> sortByCalculatedFieldDesc(IF1<A, B> f, Iterable<A> c) {
    return sortByCalculatedFieldDesc(c, f);
  }

  static public boolean conceptsWithFieldGreaterThan_verbose = false;

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Class<A> c, String field, Object value) {
    return conceptsWithFieldGreaterThan(db_mainConcepts(), c, field, value);
  }

  static public <A extends Concept> Collection<A> conceptsWithFieldGreaterThan(Concepts concepts, Class<A> c, String field, Object value) {
    IFieldIndex<A, Object> index = concepts.getFieldIndex(c, field);
    if (index instanceof ConceptFieldIndexDesc)
      return ((ConceptFieldIndexDesc) index).objectsWithValueGreaterThan(value);
    if (conceptsWithFieldGreaterThan_verbose)
      print("conceptsWithFieldGreaterThan: table scan of " + c + " for field " + field);
    return objectsWhereFieldGreaterThan(concepts.list(c), field, value);
  }

  static public String hhiddenWithID(String id) {
    return hhiddenWithID(id, null);
  }

  static public String hhiddenWithID(String id, Object value, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "hidden", "id", id, "value", value));
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String hsimpletableheader(String... cols) {
    return tag("tr", join(lambdaMap(__51 -> th(__51), cols)));
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public <A> String mapToLines(IF1<A, String> f, A data1, A... moreData) {
    return lines(map(f, data1, moreData));
  }

  static public <A> List<A> lastTwo(List<A> l) {
    return takeLast(2, l);
  }

  static public String tr(Object contents) {
    return tag("tr", contents);
  }

  static public String td(Object contents, Object... params) {
    return hfulltag("td", contents, params);
  }

  static public String td() {
    return td("");
  }

  static public String renderHowLongAgo(Timestamp ts) {
    return renderHowLongAgo(timestampToLong(ts));
  }

  static public String renderHowLongAgo(long timestamp) {
    if (timestamp == 0)
      return "never";
    int seconds = howManySecondsAgo(timestamp);
    if (seconds <= 0)
      return "just now";
    if (seconds < 60)
      return n2(seconds, "second") + " ago";
    int minutes = iround(seconds / 60.0);
    if (minutes < 60)
      return n2(minutes, "minute") + " ago";
    int hours = iround(minutes / 60.0);
    if (hours < 24)
      return n2(hours, "hour") + " ago";
    int days = iround(hours / 24.0);
    return n2(days, "day") + " ago";
  }

  static public String hparagraphs(Collection<String> l) {
    return lines(lambdaMap(__52 -> p(__52), l));
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public String hhead(Object contents) {
    return tag("head", contents);
  }

  static public String hscript_clickableRows() {
    return hscript("\r\n    jQuery(document).ready(function($) {\r\n      $(\".clickable-row\").click(function() {\r\n        window.location = $(this).data(\"href\");\r\n      });\r\n    });\r\n  ");
  }

  static public String h3(String s, Object... params) {
    return tag("h3", s, params) + "\n";
  }

  static public String hcheckboxWithText(String name, String text, boolean checked, Object... params) {
    String id = randomID();
    return hcheckbox(name, checked, paramsPlus(params, "id", id)) + " " + hlabelFor(id, htmlEncode2(text));
  }

  static public String hcheckboxWithText(String name, String text) {
    return hcheckboxWithText(name, text, false);
  }

  static public String b(Object contents, Object... params) {
    return tag("b", contents, params);
  }

  static public String hdivWithID(String id, Object contents, Object... params) {
    return hdiv(contents, paramsPlus(params, "id", id));
  }

  static public String hdesktopNotifications() {
    return hscript("\r\n    function sendDesktopNotification(text, options) {\r\n      if (\"Notification\" in window && Notification.permission === \"granted\")\r\n        new Notification(text, options);\r\n    }\r\n    window.sendDesktopNotification = sendDesktopNotification;\r\n    \r\n    function initDesktopNotifications() {\r\n      if (!(\"Notification\" in window))\r\n        $(\"#notiStatus\").html(\"Desktop notifications not supported in this browser\");\r\n      else if (Notification.permission === \"granted\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications enabled\");\r\n      else if (Notification.permission === \"denied\")\r\n        $(\"#notiStatus\").html(\"Desktop notifications denied\");\r\n      else {\r\n        $(\"#notiStatus\").html(\"Requesting permission for desktop notifications\");\r\n        Notification.requestPermission().then(function (permission) {\r\n          initDesktopNotifications();\r\n          sendDesktopNotification(\"Notifications will look like this!\");\r\n        });\r\n      }\r\n    }\r\n    \r\n    $(document).ready(initDesktopNotifications);\r\n  ");
  }

  static public String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  static public String div() {
    return div("");
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public Complex div(Complex a, double b) {
    return new Complex(a.re / b, a.im / b);
  }

  static public double div(double a, double b) {
    return a / b;
  }

  static public double div(double a, int b) {
    return a / b;
  }

  static public int div(int a, int b) {
    return a / b;
  }

  static public String small(Object contents, Object... params) {
    return tag("small", contents, params);
  }

  static public String span(Object contents, Object... params) {
    return hfulltag("span", contents, params);
  }

  static public String span() {
    return span("");
  }

  static public String hbutton(String text, Object... params) {
    return hfulltag("button", text, params);
  }

  static public String hframeset_cols(String cols, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "cols", cols));
  }

  static public String hframeset_rows(String rows, Object contents, Object... params) {
    return tag("frameset", contents, paramsPlus(params, "rows", rows));
  }

  static public String htmlEncode2If(boolean b, String s) {
    return b ? htmlEncode2(s) : s;
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return list(type, db_mainConcepts());
  }

  static public <A extends Concept> List<A> list(Class<A> type, Concepts cc) {
    return cc.list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public List<Concept> list(Concepts concepts) {
    return asList(concepts.allConcepts());
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static public LongRange longRange(long start, long end) {
    return new LongRange(start, end);
  }

  static public long parseYMDHMS(String s) {
    return parseYMDHMS_slashesSpaceColons(s);
  }

  static public long parseYMDHMS(String s, TimeZone tz) {
    return parseYMDHMS_slashesSpaceColons(s, tz);
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public List<IntRange> parseBusinessHours(String s) {
    List<String> parts = nempties(tok_splitAtComma(s));
    return map(parts, part -> {
      List<String> l = splitAtMinus(part);
      IntRange r = intRange(parseHourAndOptionalMinutesToMinutes(first(l)), parseHourAndOptionalMinutesToMinutes(second(l)));
      if (r.end < r.start && r.start <= 12 * 60 && r.end < 12 * 60)
        r.end += 12 * 60;
      return r;
    });
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public <A, B> TreeMap<A, B> pairsToTreeMap(Collection<? extends Pair<A, B>> l) {
    TreeMap<A, B> map = new TreeMap();
    if (l != null)
      for (Pair<A, B> p : l) map.put(p.a, p.b);
    return map;
  }

  static public void indexSingletonConcept(Concepts cc, Class<? extends Concept> c) {
    indexConceptField(cc, c, "_dummy");
  }

  static public void indexSingletonConcept(Class<? extends Concept> c) {
    indexSingletonConcept(db_mainConcepts(), c);
  }

  static public <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  static public <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static public boolean printAlsoToSystemOut = true;

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print(combinePrintParameters(s, o));
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    try {
      Object f = getThreadLocal(print_byThread_dontCreate());
      if (f == null)
        f = print_allThreads;
      if (f != null)
        if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
          return;
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
    }
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    if (printAlsoToSystemOut)
      System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first((Collection) strings));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(String glue, Object... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      var __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  static public boolean isTrue(Boolean b) {
    return b != null && b.booleanValue();
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(BitSet bs) {
    return bs == null || bs.isEmpty();
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(IMultiMap mm) {
    return mm == null || mm.size() == 0;
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public boolean empty(Rect r) {
    return !(r != null && r.w != 0 && r.h != 0);
  }

  static public boolean empty(Chain c) {
    return c == null;
  }

  static public boolean empty(AppendableChain c) {
    return c == null;
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    if (e != null)
      print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public Calendar googleCalendarService(GoogleAccess ga, String applicationName) {
    return new Calendar.Builder(ga.transport(), ga.jsonFactory(), ga.credential).setApplicationName(applicationName).build();
  }

  static public <A, B> Set<Map.Entry<A, B>> _entrySet(Map<A, B> map) {
    return map == null ? Collections.EMPTY_SET : map.entrySet();
  }

  static public List<IntRange> parseBusinessHours_pcall(String s) {
    try {
      return parseBusinessHours(s);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public String englishWeekday(int i) {
    return get(englishWeekdays(), i - 1);
  }

  static public long totalIntRangesLength(Iterable<IntRange> l) {
    long total = 0;
    for (IntRange r : unnullForIteration(l)) total += r.length();
    return total;
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public String formatDouble(double d) {
    return str(d);
  }

  static public String joinWithBR(Iterable l) {
    return join("<br>\n", l);
  }

  static public String joinWithBR(String... l) {
    return joinWithBR(asList(l));
  }

  static public LongRange dateStructureToTimestampRange(DateStructures.SomeDate d) {
    return dateStructureToTimestampRange(d, new DateInterpretationConfig());
  }

  static public LongRange dateStructureToTimestampRange(DateStructures.SomeDate d, DateInterpretationConfig config) {
    return new DateStructureToTimestampRange(config).getRange(d);
  }

  static public class DateStructureToTimestampRange {

    public TimeZone tz;

    public long now;

    public boolean assumeFuture = false;

    public DateStructureToTimestampRange(DateInterpretationConfig config) {
      tz = config.timeZone;
      now = config.now;
      assumeFuture = config.assumeFuture;
    }

    public DateStructures.Year currentYear() {
      return new DateStructures.Year(year(now, tz));
    }

    public DateStructures.Month currentMonth() {
      return new DateStructures.Month(month(now, tz), currentYear());
    }

    public DateStructures.SomeDate concretizeDate(DateStructures.SomeDate d) {
      if (d instanceof DateStructures.CurrentMonthPlus)
        d = new DateStructures.Month(month(now, tz) + ((DateStructures.CurrentMonthPlus) d).nMonths, currentYear());
      if (d instanceof DateStructures.TodayPlus)
        d = new DateStructures.Day(dayOfMonth(now, tz) + ((DateStructures.TodayPlus) d).nDays, currentMonth());
      if (d instanceof DateStructures.CurrentYearPlus)
        d = new DateStructures.Year(year(now, tz) + ((DateStructures.CurrentYearPlus) d).nYears);
      if (d instanceof DateStructures.CurrentWeekPlus)
        d = new DateStructures.Week(weekInYear(now, tz) + ((DateStructures.CurrentWeekPlus) d).nWeeks, currentYear());
      return d;
    }

    public LongRange getRange(DateStructures.SomeDate d) {
      d = concretizeDate(d);
      if (d instanceof DateStructures.Year)
        return longRange(yearToTimestamp(((DateStructures.Year) d).year, tz), yearToTimestamp(((DateStructures.Year) d).year + 1, tz));
      if (d instanceof DateStructures.Month) {
        if (((DateStructures.Month) d).year == null)
          ((DateStructures.Month) d).year = (DateStructures.Year) concretizeDate(new DateStructures.CurrentYearPlus(((DateStructures.Month) d).month < currentMonth().month ? 1 : 0));
        int year = ((DateStructures.Month) d).year.year;
        return longRange(yearAndMonthToTimestamp(year, ((DateStructures.Month) d).month, tz), yearAndMonthToTimestamp(year, ((DateStructures.Month) d).month + 1, tz));
      }
      if (d instanceof DateStructures.Week) {
        int year = ((DateStructures.Week) d).year.year;
        return longRange(yearAndWeekToTimestamp(year, ((DateStructures.Week) d).week, tz), yearAndWeekToTimestamp(year, ((DateStructures.Week) d).week + 1, tz));
      }
      if (d instanceof DateStructures.Weekday) {
        if (((DateStructures.Weekday) d).week == null)
          ((DateStructures.Weekday) d).week = (DateStructures.Week) concretizeDate(new DateStructures.CurrentWeekPlus(((DateStructures.Weekday) d).weekday < dayOfWeek_nr(now, tz) ? 1 : 0));
        long start = getRange(((DateStructures.Weekday) d).week).start + (((DateStructures.Weekday) d).weekday - 1) * 24 * 60 * 60 * 1000;
        return new LongRange(start, start + 24 * 60 * 60 * 1000);
      }
      if (d instanceof DateStructures.Day) {
        int month = ((DateStructures.Day) d).month.month;
        int year = ((DateStructures.Day) d).month.year.year;
        return longRange(ymdToTimestamp(year, month, ((DateStructures.Day) d).day, tz), ymdToTimestamp(year, month, ((DateStructures.Day) d).day + 1, tz));
      }
      if (d instanceof DateStructures.Hour) {
        if (((DateStructures.Hour) d).isPM == null)
          throw fail("AM/PM unknown: " + ((DateStructures.Hour) d));
        long dayStart = getRange(assertNotNull("day of hour", ((DateStructures.Hour) d).day)).start;
        int actualHour = ((DateStructures.Hour) d).hour + (((DateStructures.Hour) d).isPM ? 12 : 0);
        return longRange(dayStart + hoursToMS(actualHour), dayStart + hoursToMS(actualHour + 1));
      }
      if (d instanceof DateStructures.Between) {
        return longRange(getRange(((DateStructures.Between) d).from).start, getRange(((DateStructures.Between) d).to).start);
      }
      throw fail("dateStructureToTimestampRange: unknown type " + d);
    }
  }

  static public LongRange parseEnglishDateRange(String s, DateInterpretationConfig config) {
    EnglishDateParser parser = new EnglishDateParser();
    List<DateStructures.SomeDate> dates = getVars(parser.topDogs(s));
    print("dates", dates);
    if (empty(dates))
      return null;
    LongRange first = dateStructureToTimestampRange(first(dates), config);
    if (l(dates) == 2 && !DateStructures.containsDateDates(second(dates)) && DateStructures.containsTimes(second(dates))) {
      DateStructures.Day day = new DateStructures.Day(dayOfMonth(first.start), new DateStructures.Month(month(first.start), new DateStructures.Year(year(first.start))));
      DateStructures.SomeDate combined = (DateStructures.SomeDate) (defaultMetaTransformer().transform(o -> {
        if (o instanceof DateStructures.Hour)
          return cloneSetAll(((DateStructures.Hour) o), "day", day);
        return null;
      }, second(dates)));
      print("combined", combined);
      return dateStructureToTimestampRange(combined, config);
    }
    return joinLongRanges(map(d -> dateStructureToTimestampRange(d, config), dates));
  }

  static public long beginningOfDay(long timestamp, TimeZone tz) {
    return parseYYYYMMDD(ymd(timestamp, tz), tz);
  }

  static public long endOfDay(long timestamp, TimeZone tz) {
    return beginningOfDay(timestamp, tz) + daysToMS(1);
  }

  static public LongRange intersectLongRanges(LongRange a, LongRange b) {
    long start = max(a.start, b.start);
    long end = min(a.end, b.end);
    return start <= end ? new LongRange(start, end) : null;
  }

  static public int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  static public int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  static public int l(Map m) {
    return m == null ? 0 : m.size();
  }

  static public int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public long l(File f) {
    return f == null ? 0 : f.length();
  }

  static public int l(MultiSet ms) {
    return ms == null ? 0 : ms.size();
  }

  static public int l(IMultiMap mm) {
    return mm == null ? 0 : mm.size();
  }

  static public int l(IntRange r) {
    return r == null ? 0 : r.length();
  }

  static public long l(LongRange r) {
    return r == null ? 0 : r.length();
  }

  static public int l(AppendableChain a) {
    return a == null ? 0 : a.size;
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A, B> Pair<A, B> first(Map<A, B> map) {
    return mapEntryToPair(first(entrySet(map)));
  }

  static public <A, B> Pair<A, B> first(MultiMap<A, B> mm) {
    if (mm == null)
      return null;
    var e = first(mm.data.entrySet());
    if (e == null)
      return null;
    return pair(e.getKey(), first(e.getValue()));
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public <A, B, C> A first(T3<A, B, C> t) {
    return t == null ? null : t.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public <A> A first(A[] l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, pred);
  }

  static public <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(pred, l);
  }

  static public <A> A first(AppendableChain<A> a) {
    return a == null ? null : a.element;
  }

  static public long hoursToMS(double hours) {
    return round(hours * 60 * 60 * 1000);
  }

  static public long minutesToMS(double minutes) {
    return round(minutes * 60 * 1000);
  }

  static public List<Event> googleCalendar_eventsInDateRange(Calendar calendarService, TimeZone tz, long startDate, long endDate, int maxEvents) {
    return googleCalendar_eventsInDateRange(calendarService, tz, longRange(startDate, endDate), maxEvents);
  }

  static public List<Event> googleCalendar_eventsInDateRange(Calendar calendarService, TimeZone tz, LongRange dateRange, int maxEvents) {
    try {
      Events events = calendarService.events().list("primary").setMaxResults(maxEvents).setTimeMin(new DateTime(new java.util.Date(dateRange.start), tz)).setTimeMax(new DateTime(new java.util.Date(dateRange.end), tz)).setOrderBy("startTime").setSingleEvents(true).execute();
      return events.getItems();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long done2_always(long startTime, String desc) {
    long time = sysNow() - startTime;
    saveTiming_noPrint(time);
    print(desc + " [" + time + " ms]");
    return time;
  }

  static public long done2_always(String desc, long startTime) {
    return done2_always(startTime, desc);
  }

  static public long done2_always(long startTime) {
    return done2_always(startTime, "");
  }

  static public LongRange cutLongRangeToGranularity(LongRange r, long granularity) {
    if (r == null || granularity < 1)
      return r;
    return new LongRange(roundUpTo(granularity, r.start), roundDownTo(granularity, r.end));
  }

  static public boolean cic(Collection<String> l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(Collection<Symbol> l, Symbol s) {
    return contains(l, s);
  }

  static public boolean cic(String[] l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(String s, char c) {
    return containsIgnoreCase(s, c);
  }

  static public boolean cic(String a, String b) {
    return containsIgnoreCase(a, b);
  }

  static public TimeZone timeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public long daysToMS(double days) {
    return round(days * 24 * 60 * 60 * 1000);
  }

  static public int dayOfWeek_nr() {
    return dayOfWeek_nr(java.util.Calendar.getInstance());
  }

  static public int dayOfWeek_nr(java.util.Calendar calendar) {
    return calendar.get(java.util.Calendar.DAY_OF_WEEK);
  }

  static public int dayOfWeek_nr(long time) {
    return dayOfWeek_nr(calendarFromTime(time));
  }

  static public int dayOfWeek_nr(long time, TimeZone tz) {
    return dayOfWeek_nr(calendarFromTime(time, tz));
  }

  static public String unnullForIteration(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnullForIteration(Collection<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public <A> List<A> unnullForIteration(List<A> l) {
    return l == null ? immutableEmptyList() : l;
  }

  static public int[] unnullForIteration(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnullForIteration(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnullForIteration(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public short[] unnullForIteration(short[] l) {
    return l == null ? emptyShortArray() : l;
  }

  static public <A, B> Map<A, B> unnullForIteration(Map<A, B> l) {
    return l == null ? immutableEmptyMap() : l;
  }

  static public <A> Iterable<A> unnullForIteration(Iterable<A> i) {
    return i == null ? immutableEmptyList() : i;
  }

  static public <A> A[] unnullForIteration(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnullForIteration(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnullForIteration(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnullForIteration(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnullForIteration(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public long unnullForIteration(Long l) {
    return l == null ? 0L : l;
  }

  static public String formatDate() {
    return formatDate(now());
  }

  static public String formatDate(long timestamp) {
    return timestamp == 0 ? "-" : str(new Date(timestamp));
  }

  static public String formatDate(long timestamp, String format, TimeZone tz) {
    return simpleDateFormat(format, tz).format(timestamp);
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public <A extends Comparable<A>> A max(Iterable<A> l) {
    A max = null;
    var it = iterator(l);
    if (it.hasNext()) {
      max = it.next();
      while (it.hasNext()) {
        A a = it.next();
        if (cmp(a, max) > 0)
          max = a;
      }
    }
    return max;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public <A extends Comparable<A>> A max(A a, A b) {
    return cmp(a, b) >= 0 ? a : b;
  }

  static public String subBot_getHeader(String key) {
    return subBot_getHeaders().get(lower(key));
  }

  static public <A> A printAndProgramLog(String s, A o) {
    printAndProgramLog((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
    return o;
  }

  static public <A> A printAndProgramLog(A a) {
    String s = str(a);
    print("[" + localDateWithMilliseconds() + "] " + s);
    logQuotedWithDate(programLog(), s);
    return a;
  }

  static public String subBot_completeRequestURL() {
    int port = subBot_currentPort();
    boolean https = subBot_isHttps();
    boolean standardPort = port == (https ? 443 : 80);
    return "http" + (https ? "s" : "") + "://" + domain() + (standardPort ? "" : ":" + port) + getActualURI();
  }

  static public File programLog() {
    return programLogFile();
  }

  static public String programLog(String s) {
    logQuotedWithDate(programLog(), s);
    return s;
  }

  static public String stackTraceToString(StackTraceElement[] st) {
    return lines(st);
  }

  static public String stackTraceToString(Throwable e) {
    return getStackTrace_noRecord(e);
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    Map m = similarEmptyMap(map);
    for (Map.Entry<? extends A, ? extends B> __0 : _entrySet(map)) {
      A key = __0.getKey();
      B val = __0.getValue();
      m.put(key, f.get(val));
    }
    return m;
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public <A, B, C> MultiMap<A, C> mapValues(IF1<B, C> func, MultiMap<A, B> mm) {
    return mapMultiMapValues(func, mm);
  }

  static public <A, B, C> MultiMap<A, C> mapValues(MultiMap<A, B> mm, IF1<B, C> func) {
    return mapValues(func, mm);
  }

  static public <A, B extends Collection<A>> boolean allEmpty(Iterable<B> l) {
    return all(__53 -> empty(__53), l);
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  static public String n2(long l) {
    return formatWithThousands(l);
  }

  static public String n2(AtomicLong l) {
    return n2(l.get());
  }

  static public String n2(Collection l) {
    return n2(l(l));
  }

  static public String n2(Map map) {
    return n2(l(map));
  }

  static public String n2(double l, String singular) {
    return empty(singular) ? str(l) : n2(l, singular, singular + "s");
  }

  static public String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  static public String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(long l, String singular) {
    return empty(singular) ? n2(l) : n_fancy2(l, singular, singular + "s");
  }

  static public String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  static public String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  static public String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  static public String n2(long[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  static public String n2(MultiSet ms, String singular) {
    return n2(ms, singular, singular + "s");
  }

  static public String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  static public String n2(IMultiMap mm, String singular) {
    return n2(mm, singular, singular + "s");
  }

  static public String n2(IMultiMap mm, String singular, String plural) {
    return n_fancy2(l(mm), singular, plural);
  }

  static public int hours() {
    return hours(java.util.Calendar.getInstance());
  }

  static public int hours(java.util.Calendar c) {
    return c.get(java.util.Calendar.HOUR_OF_DAY);
  }

  static public int hours(long time) {
    return hours(calendarFromTime(time));
  }

  static public int hours(long time, TimeZone tz) {
    return hours(calendarFromTime(time, tz));
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    for (A a : unnullForIteration(l)) if (pred.get(a))
      return a;
    return null;
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, A[] l) {
    return firstThat(l, pred);
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public <A> Chain<A> dropFirst(Chain<A> c) {
    return c == null ? null : c.next;
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Long> asList(long[] a) {
    if (a == null)
      return null;
    ArrayList<Long> l = emptyList(a.length);
    for (long i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public ArrayList<Short> asList(short[] a) {
    if (a == null)
      return null;
    ArrayList<Short> l = emptyList(a.length);
    for (short i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterator<A> it) {
    ArrayList l = new ArrayList();
    if (it != null)
      while (it.hasNext()) l.add(it.next());
    return l;
  }

  static public <A> ArrayList<A> asList(IterableIterator<A> s) {
    return asList((Iterator) s);
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A> ArrayList<A> asList(ReverseChain<A> c) {
    return c == null ? emptyList() : c.toList();
  }

  static public <A> List<A> asList(Pair<A, A> p) {
    return p == null ? null : ll(p.a, p.b);
  }

  static public <A> A nu(Class<A> c, Object... values) {
    A a = nuObject(c);
    setAll(a, values);
    return a;
  }

  static public <A> List<A> ll_nonNulls(A... a) {
    return llNonNulls(a);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public boolean find3plusRestsX(String pat, String s) {
    return find3plusRestsX(pat, s, null);
  }

  static public boolean find3plusRestsX(String pat, String s, Matches matches) {
    pat = dropPrefix("...", dropSuffix("...", pat));
    List<String> tokpat = parse3(pat), toks = parse3(s);
    Pair<String[], Integer> p = find2plusIndex(tokpat, toks);
    if (p == null)
      return false;
    if (matches != null)
      matches.m = concatStringArrays(new String[] { joinSubList(toks, 0, p.b - 1) }, p.a, new String[] { joinSubList(toks, p.b + l(tokpat) - 1) });
    return true;
  }

  static public boolean find3(String pat, String s) {
    return find3(pat, s, null);
  }

  static public boolean find3(String pat, String s, Matches matches) {
    return find3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean find3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    String[] m = find2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public String ymdWithSlashes() {
    return ymdWithSlashes(now());
  }

  static public String ymdWithSlashes(long time) {
    return simpleDateFormat_local("YYYY/MM/dd").format(time);
  }

  static public String ymdWithSlashes(long time, TimeZone tz) {
    return simpleDateFormat("YYYY/MM/dd", tz).format(time);
  }

  static public boolean isDummyPhoneNr(String s) {
    return startsWith(digitsOnly(s), "123456");
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Runnable runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(runnable, name));
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public List<String> replaceIC(List<String> l, String a, String b) {
    List<String> l2 = new ArrayList();
    for (int i = 0; i < l(l); i++) {
      String s = l.get(i);
      l2.add(eqic(s, a) ? b : s);
    }
    return l2;
  }

  static public String replaceIC(String s, String a, String b) {
    return s.replaceAll("(?i)" + patternQuote(a), quoteReplacement(b));
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public String timeInZone_24(long time, String timeZone) {
    return timeInZone_24(time, getTimeZone(timeZone));
  }

  static public String timeInZone_24(long time, TimeZone timeZone) {
    return simpleDateFormat("HH:mm", timeZone).format(time);
  }

  static public String timeInZone_24(String timeZone) {
    return timeInZone_24(now(), timeZone);
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public String digitsOnly(String s) {
    return filterChars(__54 -> isDigit(__54), s);
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Iterable it, Object a) {
    if (it != null)
      for (Object o : it) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public boolean contains(Rect r, Pt p) {
    return rectContains(r, p);
  }

  static public Set<String> usAreaCodes_cache;

  static public Set<String> usAreaCodes() {
    if (usAreaCodes_cache == null)
      usAreaCodes_cache = usAreaCodes_load();
    return usAreaCodes_cache;
  }

  static public Set<String> usAreaCodes_load() {
    return asTreeSet(values(usAreaCodesMap()));
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterator<A> it) {
    if (it == null)
      return null;
    List l = new ArrayList();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    return i == null ? null : takeFirst(n, i.iterator());
  }

  static public <A> List<A> takeFirst(int n, IterableIterator<A> i) {
    return takeFirst(n, (Iterator<A>) i);
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public short[] takeFirst(int n, short[] a) {
    return takeFirstOfShortArray(n, a);
  }

  static public byte[] takeFirst(int n, byte[] a) {
    return takeFirstOfByteArray(n, a);
  }

  static public byte[] takeFirst(byte[] a, int n) {
    return takeFirstOfByteArray(n, a);
  }

  static public double[] takeFirst(int n, double[] a) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public double[] takeFirst(double[] a, int n) {
    return takeFirstOfDoubleArray(n, a);
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, lCharSequence(l));
  }

  static public int countDigitsInString(String s) {
    int n = 0;
    for (int i = 0; i < l(s); i++) if (isDigit(s.charAt(i)))
      ++n;
    return n;
  }

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public String hijackPrint_tee_pcall(Runnable r) {
    return hijackPrint_tee(new Runnable() {

      public void run() {
        try {
          try {
            callF(r);
          } catch (Throwable __e) {
            printStackTrace(__e);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcall { callF(r); }";
      }
    });
  }

  static public String hsourcecode(Object o) {
    return sourceCodeToHTML(o);
  }

  static public long toLong(Object o) {
    if (o instanceof Number)
      return ((Number) o).longValue();
    if (o instanceof String)
      return parseLong((String) o);
    return 0;
  }

  static public Object subBot_serveHTMLNoCache(String html) {
    return subBot_noCacheHeaders(subBot_serveHTML(html));
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public boolean get(BitSet bs, int idx) {
    return bs != null && bs.get(idx);
  }

  static public void assertTrueVerbose(Object o) {
    assertEqualsVerbose(true, o);
  }

  static public void assertTrueVerbose(String msg, Object o) {
    assertEqualsVerbose(msg, true, o);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s) {
    return mmo2_match(pattern, s, false, false);
  }

  static public boolean mmo2_match(MMOPattern pattern, String s, boolean startOfLine, boolean endOfLine) {
    if (pattern == null)
      return false;
    String s2 = trim(s);
    if (pattern instanceof MMOPattern.StartOfLine)
      return mmo2_match(((MMOPattern.StartOfLine) pattern).p, s2, true, endOfLine);
    if (pattern instanceof MMOPattern.EndOfLine)
      return mmo2_match(((MMOPattern.EndOfLine) pattern).p, s2, startOfLine, true);
    if (pattern instanceof MMOPattern.Phrase) {
      String p = ((MMOPattern.Phrase) pattern).phrase;
      if (((MMOPattern.Phrase) pattern).quoted)
        return cicWithSmartWordBoundary(s2, p);
      if (startsWith(p, "#"))
        return eqic(p, s2);
      return match3_startOrEndOfLine(p, s2, startOfLine, endOfLine);
    }
    if (pattern instanceof MMOPattern.And)
      return all(((MMOPattern.And) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Or)
      return any(((MMOPattern.Or) pattern).l, pat -> mmo2_match(pat, s2, startOfLine, endOfLine));
    if (pattern instanceof MMOPattern.Not)
      return !mmo2_match(((MMOPattern.Not) pattern).p, s2, startOfLine, endOfLine);
    throw fail("what. " + pattern);
  }

  static public boolean mmo2_match(String pattern, String s) {
    return mmo2_match(mmo2_parsePattern(pattern), s);
  }

  static public void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  static public boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  static public boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  static public <A> A objectWhere(Collection<A> c, Object... data) {
    return findWhere(c, data);
  }

  static public <A, B, C extends Collection<B>> List<B> allValues(Map<A, C> map) {
    List<B> out = new ArrayList();
    for (var l : values(map)) addAll(out, l);
    return out;
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public WeakReference<Object> creator_class;

  static public Object creator() {
    return creator_class == null ? null : creator_class.get();
  }

  static public boolean match(String pat, String s) {
    return match3(pat, s);
  }

  static public boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  static public boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  static public List<String> regexpICMatchesAsCNC(String pat, String s) {
    return intRangesToCNC(s, regexpFindRangesIC(pat, s));
  }

  static public String regexpNegativeLookbehind(String re) {
    return "(?<!" + re + ")";
  }

  static public <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  static public <A> AutoCloseable tempSetTL(BetterThreadLocal<A> tl, A a) {
    return tempSetThreadLocalIfNecessary(tl, a);
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public String unicode_crossProduct() {
    return unicodeFromCodePoint(0x2A2F);
  }

  static public String unicode_undoArrow() {
    return unicodeFromCodePoint(0x21B6);
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public String joinNemptiesWithSpace(String... strings) {
    return joinNempties(" ", strings);
  }

  static public String joinNemptiesWithSpace(Collection<String> strings) {
    return joinNempties(" ", strings);
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public Object getBot(String botID) {
    return callOpt(getMainBot(), "getBot", botID);
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(Symbol a, Symbol b) {
    return eq(a, b);
  }

  static public boolean eqic(Symbol a, String b) {
    return eqic(asString(a), b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public TreeSet<Symbol> litciset(Symbol... items) {
    TreeSet<Symbol> set = treeSet();
    for (Symbol a : items) set.add(a);
    return set;
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public <A> int lengthLevel2(Collection<? extends Collection> l) {
    int sum = 0;
    for (Collection c : l) sum += l(c);
    return sum;
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public byte last(byte[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last((List) l);
    if (l instanceof SortedSet)
      return (A) last((SortedSet) l);
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public <A> A last(ReverseChain<A> l) {
    return l == null ? null : l.element;
  }

  static public <A> A last(CompactLinkedHashSet<A> set) {
    return set == null ? null : set.last();
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public long add(AtomicLong l, long b) {
    return l.addAndGet(b);
  }

  static public void dbIndexing(Object... params) {
    db();
    indexConceptFields(params);
  }

  static public Class fieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getType();
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject) {
        setDyn(((DynamicObject) o), field, value);
        return;
      }
      if (o instanceof IMeta)
        setDyn(((IMeta) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public AutoCloseable tempRegisterThread() {
    _registerThread();
    return new AutoCloseable() {

      public String toString() {
        return "_unregisterThread();";
      }

      public void close() throws Exception {
        _unregisterThread();
      }
    };
  }

  static public String registerVisitor() {
    Object visitorsBot = getBot("#1002157");
    String visitorStats = visitorsBot == null ? null : str(callHtmlMethod(visitorsBot, "/"));
    return visitorStats;
  }

  static public String cookieSent() {
    Object visitorsBot = getBot("#1002157");
    return (String) callOpt(visitorsBot, "cookieSent");
  }

  static public String subBot_clientIP() {
    return getClientIP_subBot();
  }

  static public String getDialogID() {
    return (String) callOpt(getMainBot(), "getDialogID");
  }

  static public String loadSecretTextFileOrCreateWithRandomID(String name) {
    String id = trim(loadSecretTextFile(name));
    if (empty(id))
      saveSecretTextFile(name, id = aGlobalID());
    return id;
  }

  static public String loadSecretTextFileOrCreateWithRandomID(File f) {
    String id = trim(loadTextFile(f));
    if (empty(id))
      saveTextFile(f, id = aGlobalID());
    return id;
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public String hrefresh(String target) {
    return hrefresh(0, target);
  }

  static public String hrefresh(double seconds) {
    return hrefresh(seconds, "");
  }

  static public String hrefresh(double seconds, String target) {
    return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
  }

  static public Object subBot_serveFile(File file) {
    return call(getMainBot(), "serveFile", file);
  }

  static public Object subBot_serveFile(File file, String mimeType) {
    return call(getMainBot(), "serveFile", file, mimeType);
  }

  static public String ul_htmlEncode(String... list) {
    return ul_htmlEncode(asList(list));
  }

  static public String ul_htmlEncode(Collection list, Object... params) {
    return ul(map(__55 -> htmlEncode2(__55), allToString(list)), params);
  }

  static public List<String> getThreadNames(Collection<Thread> threads) {
    return mapMethod(threads, "getName");
  }

  static public List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  static public List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  static public String webChatBotLogsHTML2(final String baseLink, final Map<String, String> params) {
    return withDBLock(new F0<String>() {

      public String get() {
        try {
          List<String> l = new ArrayList();
          for (Conversation conv : sortByCalculatedFieldDesc(list(Conversation.class), new F1<Conversation, Object>() {

            public Object get(Conversation c) {
              try {
                return empty(c.msgs) ? c.created : last(c.msgs).time;
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "empty(c.msgs) ? c.created : last(c.msgs).time";
            }
          })) {
            List<List<Msg>> dialogs = reversed(unnull(conv.oldDialogs));
            if (l(conv.msgs) > 1)
              l.add(webChatBotLogsHTML_formatDialog(str(conv.id), conv.msgs));
            int i = 2;
            for (List<Msg> msgs : dialogs) if (l(msgs) > 1)
              l.add(webChatBotLogsHTML_formatDialog(conv.id + "/" + (i++), msgs));
          }
          int perPage = 50, n = parseIntOpt(params.get("n"));
          return h3_htitle("Chat Logs") + pageNav2(baseLink, l(l), n, perPage, "n") + ul(subList(l, n, n + perPage), null, "style", "margin-top: 1em");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new L<S> l;\r\n    for (Conversation conv : sortByCalculatedFieldDesc(list Conv...";
      }
    });
  }

  static public <A extends Concept> List<A> cdelete(Class<A> c, Object... params) {
    return deleteConcepts(c, params);
  }

  static public void cdelete(Concept c) {
    deleteConcept(c);
  }

  static public <A extends Concept> void cdelete(Collection<A> c) {
    for (A a : cloneList(c)) cdelete(a);
  }

  static public Lock dbLock() {
    return db_mainConcepts().lock;
  }

  static public Lock dbLock(Concepts cc) {
    return cc == null ? null : cc.lock;
  }

  static public Lock dbLock(Concept c) {
    return dbLock(c == null ? null : c._concepts);
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        vmBus_send("locking", lock, "thread", currentThread());
        lock.lockInterruptibly();
        vmBus_send("locked", lock, "thread", currentThread());
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
    vmBus_send("unlocked", lock, "thread", currentThread());
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public String jsQuote(String s) {
    return javascriptQuote(s);
  }

  static public boolean preferCached = false;

  static public boolean loadSnippet_debug = false;

  static public ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();

  static public ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();

  static public int loadSnippet_timeout = 30000;

  static public String loadSnippet(String snippetID) {
    try {
      if (snippetID == null)
        return null;
      return loadSnippet(parseSnippetID(snippetID), preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(String snippetID, boolean preferCached) throws IOException {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  }

  static public IF1<Long, String> loadSnippet;

  static public String loadSnippet(long snippetID) {
    return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID);
  }

  final static public String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) {
    return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID);
  }

  static public String loadSnippet_base(long snippetID) {
    try {
      return loadSnippet(snippetID, preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(long snippetID, boolean preferCached) throws IOException {
    if (isLocalSnippetID(snippetID))
      return loadLocalSnippet(snippetID);
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadSnippet(fsI(snippetID));
    return loadSnippet_noResourceLoader(snippetID, preferCached);
  }

  static public String loadSnippet_noResourceLoader(long snippetID, boolean preferCached) throws IOException {
    String text;
    initSnippetCache();
    text = DiskSnippetCache_get(snippetID);
    if (preferCached && text != null)
      return text;
    try {
      if (loadSnippet_debug && text != null)
        System.err.println("md5: " + md5(text));
      String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
      if (nempty(text))
        url += "&md5=" + md5(text);
      if (!isTrue(loadSnippet_publicOnly.get()))
        url += standardCredentials();
      String text2 = loadSnippet_loadFromServer(url);
      boolean same = eq(text2, "==*#*==");
      if (loadSnippet_debug)
        print("loadSnippet: same=" + same);
      if (!same)
        text = text2;
    } catch (RuntimeException e) {
      e.printStackTrace();
      throw new IOException("Snippet #" + snippetID + " not found or not public");
    }
    try {
      initSnippetCache();
      DiskSnippetCache_put(snippetID, text);
    } catch (IOException e) {
      System.err.println("Minor warning: Couldn't save snippet to cache (" + DiskSnippetCache_getDir() + ")");
    }
    return text;
  }

  static public File DiskSnippetCache_dir;

  public static void initDiskSnippetCache(File dir) {
    DiskSnippetCache_dir = dir;
    dir.mkdirs();
  }

  public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
    return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
  }

  static public File DiskSnippetCache_getFile(long snippetID) {
    return new File(DiskSnippetCache_dir, "" + snippetID);
  }

  public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
    saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
  }

  public static File DiskSnippetCache_getDir() {
    return DiskSnippetCache_dir;
  }

  public static void initSnippetCache() {
    if (DiskSnippetCache_dir == null)
      initDiskSnippetCache(getGlobalCache());
  }

  static public String loadSnippet_loadFromServer(String url) {
    Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
    try {
      return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
    } finally {
      loadPage_forcedTimeout_byThread.set(oldTimeout);
    }
  }

  static public String imageSnippetURLOrEmptyGIF(String snippetID) {
    return empty(snippetID) ? smallestTransparentGIFDataURI() : snippetImageURL(snippetID);
  }

  static public String psI_str(String snippetID) {
    return str(psI(snippetID));
  }

  static public String jsBool(boolean b) {
    return b ? "true" : "false";
  }

  static public String hreplaceTitle(String html, String newTitle) {
    return hreplacetag(html, "title", htitle(newTitle));
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public String htitle(String title) {
    return hfulltag("title", htmlencode_noQuotes(title));
  }

  static public String hjavascript(String scriptOrURL, Object... __) {
    if (isRelativeOrAbsoluteURL(scriptOrURL) && !startsWithOneOf(scriptOrURL, "//", "/*"))
      return hjavascript_src(scriptOrURL, __);
    else
      return tag("script", scriptOrURL, paramsPlus(__, "type", "text/javascript"));
  }

  static public Object subBot_serveJavaScript(String html) {
    return subBot_serveWithContentType(html, "text/javascript");
  }

  static public Object subBot_noCacheHeaders(Object r) {
    call(r, "addHeader", "Cache-Control", "no-cache, must-revalidate, max-age=0");
    return r;
  }

  static public Object subBot_serveHTML(Object html) {
    return subBot_serveWithContentType(str(html), "text/html");
  }

  static public String nlToBr(String s) {
    return s.replace("\n", "<br>\n");
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public String html_wavingHand() {
    return himg(dataSnippetURL("#1400314"), "style", "width: 1.4em; height: 1.4em; margin-top: -0.15em", "align", "top");
  }

  static public String hspan(Object contents, Object... params) {
    return tag("span", contents, params);
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public <A> String lines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines(l, f);
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public String snippetImgLink(String snippetID) {
    return snippetImageURL(snippetID);
  }

  static public String fullRawLink(String pageName) {
    return (subBot_isHttps() ? "https" : "http") + "://" + domain() + rawLink(pageName);
  }

  static public TreeSet<String> asCISet(Iterable<String> c) {
    return toCaseInsensitiveSet(c);
  }

  static public TreeSet<String> asCISet(String... x) {
    return toCaseInsensitiveSet(x);
  }

  static public String hcheckbox(String name, boolean checked, Object... params) {
    return tag("input", "", paramsPlus(params, "type", "checkbox", "name", name, checked ? "checked" : null, "1"));
  }

  static public String hcheckbox(String name) {
    return hcheckbox(name, false);
  }

  static public String hcheckbox(String name, String text) {
    return hcheckboxWithText(name, text);
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public Symbol unnull(Symbol s) {
    return s == null ? emptySymbol() : s;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public int unnull(Integer i) {
    return i == null ? 0 : i;
  }

  static public long unnull(Long l) {
    return l == null ? 0L : l;
  }

  static public double unnull(Double l) {
    return l == null ? 0.0 : l;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public String timeInTimeZoneWithOptionalDate_24(String timezone, long time) {
    return timeInTimeZoneWithOptionalDate_24(timeZone(timezone), time);
  }

  static public String timeInTimeZoneWithOptionalDate_24(TimeZone timezone, long time) {
    SimpleDateFormat format = simpleDateFormat("yyyy/MM/dd", timezone);
    String date = format.format(time);
    boolean needDate = neq(date, format.format(now()));
    return (needDate ? date + " " : "") + timeInTimeZone(timezone, time);
  }

  static public String htmlencode(Object o) {
    return htmlencode(str(o));
  }

  static public String htmlencode(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String ul(String... list) {
    return ul(asList(list));
  }

  static public String ul(Collection list, Object... params) {
    StringBuilder buf = new StringBuilder();
    int i = indexOf(params, null);
    if (i == -1)
      i = l(params);
    for (Object s : withoutNulls(list)) buf.append(tag("li", s, subArray(params, i + 1))).append("\n");
    return containerTag("ul", buf, subArray(params, 0, i)) + "\n";
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public String hfullcenter(Object contents, Object... __) {
    return tag("table", tr(td(contents, "align", "center")), paramsPlus(__, "width", "100%", "height", "100%"));
  }

  static public String h3_htmlEncode(Object contents, Object... params) {
    return h3(htmlEncode2(str(contents)), params);
  }

  static public String hpassword(String name, Object... params) {
    return hpasswordfield(name, params);
  }

  static public String hpassword(String name) {
    return hpasswordfield(name);
  }

  static public String jsBackLink() {
    return "javascript:history.go(-1)";
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public <A extends Concept> A conceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(c, params);
  }

  static public <A extends Concept> A conceptWhere(Concepts cc, Class<A> c, Object... params) {
    return findConceptWhere(cc, c, params);
  }

  static public <A> boolean any(Object pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (isTrue(callF(pred, a)))
        return true;
    return false;
  }

  static public <A> boolean any(IF1<A, Boolean> pred, Iterable<A> l) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return true;
    return false;
  }

  static public <A> boolean any(Iterable<A> l, IF1<A, Boolean> pred) {
    return any(pred, l);
  }

  static public <A> boolean any(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return true;
    return false;
  }

  static public boolean any(Iterable<Boolean> l) {
    if (l != null)
      for (Boolean a : l) if (isTrue(a))
        return true;
    return false;
  }

  static public String ipToCountry2020_safe(String ip) {
    try {
      return or2(ipToCountry2020(ip), "?");
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return "?";
  }

  static public java.util.Timer doAfter(long delay, Object r) {
    return doLater(delay, r);
  }

  static public java.util.Timer doAfter(long delay, Runnable r) {
    return doLater(delay, (Object) r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Object r) {
    return doLater(delaySeconds, r);
  }

  static public java.util.Timer doAfter(double delaySeconds, Runnable r) {
    return doLater(delaySeconds, r);
  }

  static public String replaceSquareBracketVars(String s, Object... params) {
    if (empty(params))
      return s;
    Map<String, Object> vars = mapKeys(__56 -> deSquareBracket(__56), (Map<String, Object>) litcimap(params));
    return regexpReplaceIC(s, "\\[(.+?)\\]", matcher -> {
      String var = matcher.group(1);
      Object val = vars.get(var);
      return val == null ? matcher.group() : str(val);
    });
  }

  static public List<String> trimAll(String... l) {
    return trimAll(asList(l));
  }

  static public List<String> trimAll(Collection<String> l) {
    List<String> l2 = new ArrayList();
    if (l != null)
      for (String s : l) l2.add(trim(s));
    return l2;
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public String dropSpaces(String s) {
    return unnull(s).replace(" ", "");
  }

  static public <A> A lastThat(List<A> l, Object pred) {
    for (int i = l(l) - 1; i >= 0; i--) {
      A a = l.get(i);
      if (checkCondition(pred, a))
        return a;
    }
    return null;
  }

  static public <A> A lastThat(Object pred, List<A> l) {
    return lastThat(l, pred);
  }

  static public <A> A lastThat(IF1<A, Boolean> pred, List<A> l) {
    return lastThat((Object) pred, l);
  }

  static public <A> A lastThat(List<A> l, IF1<A, Boolean> pred) {
    return lastThat(pred, l);
  }

  static public int countPred(Iterable c, Object pred) {
    return nfilter(c, pred);
  }

  static public int countPred(Object pred, Iterable c) {
    return nfilter(pred, c);
  }

  static public <A> int countPred(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(c, pred);
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Map<String, Field> getOpt_getFieldMap(Object o) {
    Class c = _getClass(o);
    HashMap<String, Field> map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
    return map;
  }

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Map<String, Field> map = getOpt_getFieldMap(o);
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return syncMapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    int n = s.length();
    StringBuilder out = null;
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (c == '<') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&lt;");
      } else if (c == '>') {
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&gt;");
      } else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        if (out == null)
          out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else {
        if (out != null)
          out.append(c);
      }
    }
    return out == null ? s : out.toString();
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public Object subBot_httpd() {
    Object httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "MyHTTPD_current"));
    if (httpd == null)
      httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "WebSocketHTTPD_current"));
    return httpd;
  }

  static public boolean eqOneOf(Object o, Object... l) {
    if (l != null)
      for (Object x : l) if (eq(o, x))
        return true;
    return false;
  }

  static public Object mainBot() {
    return getMainBot();
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public String domainName() {
    Object session = call(getMainBot(), "getSession");
    Map headers = (Map) (call(session, "getHeaders"));
    String host = (String) (headers.get("host"));
    if (host == null)
      return null;
    return dropFrom(host, ":");
  }

  static public String hostNameFromURL(String url) {
    try {
      return empty(url) ? null : new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getActualURI() {
    return (String) call(getMainBot(), "getActualURI");
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public String str(char[] c, int offset, int count) {
    return new String(c, offset, count);
  }

  static public String href(String link, Object contents, Object... params) {
    if (link == null)
      return str(contents);
    return hfulltag("a", contents, arrayPlus(params, "href", link));
  }

  static public String myDomain() {
    return or2(trim(loadTextFile(javaxDataDir("my-domain.txt"))), "botcompany.de");
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public String dropSuffix(String suffix, String s) {
    return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static volatile public Concepts mainConcepts;

  static public Concepts db_mainConcepts() {
    if (mainConcepts == null)
      mainConcepts = newConceptsWithClassFinder(getDBProgramID());
    return mainConcepts;
  }

  static public void cleanMeUp_concepts() {
    if (db_mainConcepts() != null)
      db_mainConcepts().cleanMeUp();
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(Object... objects) {
    throw new Fail(objects);
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public byte[] base64decode(String s) {
    byte[] alphaToInt = base64decode_base64toint;
    int sLen = s.length();
    int numGroups = sLen / 4;
    if (4 * numGroups != sLen)
      throw new IllegalArgumentException("String length must be a multiple of four.");
    int missingBytesInLastGroup = 0;
    int numFullGroups = numGroups;
    if (sLen != 0) {
      if (s.charAt(sLen - 1) == '=') {
        missingBytesInLastGroup++;
        numFullGroups--;
      }
      if (s.charAt(sLen - 2) == '=')
        missingBytesInLastGroup++;
    }
    byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
    int inCursor = 0, outCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch3 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      result[outCursor++] = (byte) ((ch2 << 6) | ch3);
    }
    if (missingBytesInLastGroup != 0) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      if (missingBytesInLastGroup == 1) {
        int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
        result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      }
    }
    return result;
  }

  static public int base64decode_base64toint(char c, byte[] alphaToInt) {
    int result = alphaToInt[c];
    if (result < 0)
      throw new IllegalArgumentException("Illegal character " + c);
    return result;
  }

  static final public byte[] base64decode_base64toint = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 };

  static public Object[] arrayPlus(Object[] a1, Object... a2) {
    return concatArrays(a1, a2);
  }

  static public String programID;

  static public String getProgramID() {
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public Object[] concatArrays(Object[]... arrays) {
    int l = 0;
    for (Object[] a : arrays) l += l(a);
    Object[] x = new Object[l];
    int i = 0;
    for (Object[] a : arrays) if (a != null) {
      System.arraycopy(a, 0, x, i, l(a));
      i += l(a);
    }
    return x;
  }

  static public Object[] paramsPlus(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) {
      Object key = a2[i];
      if (key != null)
        map.put(key, a2[i + 1]);
    }
    return mapToParams(map);
  }

  static public Object[] paramsPlus(Map a1, Object... a2) {
    return paramsPlus(new Object[] { a1 }, a2);
  }

  static public String hinputtag(Object contents, Object... params) {
    return htag("input", contents, params);
  }

  static public Object[] paramsPlus_noOverwrite(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) mapPut_noOverwrite(map, a2[i], a2[i + 1]);
    return mapToParams(map);
  }

  static public String hiddenFields(Map<String, String> map, Collection<String> keys) {
    StringBuilder buf = new StringBuilder();
    for (String key : keys) {
      String value = map.get(key);
      if (!empty(value))
        buf.append(htag("input", "", "type", "hidden", "name", key, "value", value) + "\n");
    }
    return str(buf);
  }

  static public String hiddenFields(Map<String, String> map, String... keys) {
    return hiddenFields(map, asList(keys));
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public String containerTag(String tag) {
    return containerTag(tag, "");
  }

  static public String containerTag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    return openingTag + s + "</" + tag + ">";
  }

  static public String hcss(Object contents) {
    if (contents instanceof String && isRelativeOrAbsoluteURL((String) contents))
      return hstylesheetsrc((String) contents);
    else
      return htag("style", contents);
  }

  static public String hhead_title_decode(String title) {
    return hhead_title(htmldecode_dropAllTags(title));
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping(PingSource pingSource) {
    return ping();
  }

  static public boolean ping() {
    newPing();
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(A a, IVF1<A> f) {
    if (f != null)
      f.get(a);
  }

  static public <A> void callF(IVF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF(Object f, Object... args) {
    return safeCallF(f, args);
  }

  static public Object safeCallF(Object f, Object... args) {
    if (f instanceof Runnable) {
      ((Runnable) f).run();
      return null;
    }
    if (f == null)
      return null;
    Class c = f.getClass();
    ArrayList<Method> methods;
    synchronized (callF_cache) {
      methods = callF_cache.get(c);
      if (methods == null)
        methods = callF_makeCache(c);
    }
    int n = l(methods);
    if (n == 0) {
      if (f instanceof String)
        throw fail("Legacy call: " + f);
      throw fail("No get method in " + getClassName(c));
    }
    if (n == 1)
      return invokeMethod(methods.get(0), f, args);
    for (int i = 0; i < n; i++) {
      Method m = methods.get(i);
      if (call_checkArgs(m, args, false))
        return invokeMethod(m, f, args);
    }
    throw fail("No matching get method in " + getClassName(c));
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public boolean _csetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (value instanceof RC)
        value = c._concepts.getConcept((RC) value);
      value = deref(value);
      if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan)
        value = intern((String) value);
      if (f == null) {
        assertIdentifier(field);
        Object oldVal = mapGet(c.fieldValues, field);
        if (value instanceof Concept) {
          if (oldVal instanceof Concept.Ref)
            return ((Concept.Ref) oldVal).set((Concept) value);
          else {
            dynamicObject_setRawFieldValue(c, field, c.new Ref((Concept) value));
            c.change();
            return true;
          }
        } else {
          if (oldVal instanceof Concept.Ref)
            ((Concept.Ref) oldVal).unindexAndDrop();
          if (eq(oldVal, value))
            return false;
          if (isConceptList(value) && nempty(((List) value))) {
            dynamicObject_setRawFieldValue(c, field, c.new RefL(((List) value)));
            c.change();
            return true;
          }
          if (value == null) {
            dynamicObject_dropRawField(c, field);
          } else {
            if (!isPersistable(value))
              throw fail("Can't persist: " + c + "." + field + " = " + value);
            dynamicObject_setRawFieldValue(c, field, value);
          }
          c.change();
          return true;
        }
      } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
        ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
        c.change();
        return true;
      } else if (isSubtypeOf(f.getType(), Concept.RefL.class)) {
        ((Concept.RefL) f.get(c)).replaceWithList(lmap(__57 -> derefRef(__57), (List) value));
        c.change();
        return true;
      } else {
        Object old = f.get(c);
        if (neq(value, old)) {
          boolean isTransient = isTransient(f);
          if (!isTransient && !isPersistable(value))
            throw fail("Can't persist: " + c + "." + field + " = " + value);
          f.set(c, value);
          if (!isTransient)
            c.change();
          return true;
        }
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A getVar(IF0<A> v) {
    return v == null ? null : v.get();
  }

  static public <A> A getVar(Optional<A> v) {
    return v == null ? null : v.orElse(null);
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll((Map) b);
    return a;
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
    if (a != null)
      litmap_impl(a, b);
    return a;
  }

  static public <A> List<A> sortedByFieldIC(Collection<A> c, final String field) {
    List<A> l = new ArrayList(c);
    sort(l, new Comparator<A>() {

      public int compare(A a, A b) {
        return compareIC((String) getOpt(a, field), (String) getOpt(b, field));
      }
    });
    return l;
  }

  static public <A> List<A> sortedByFieldIC(String field, Collection<A> c) {
    return sortedByFieldIC(c, field);
  }

  static public Object[] paramsPlus_skipFirst(Object[] a1, Object... a2) {
    if (odd(l(a1)))
      return itemPlusArray(first(a1), paramsPlus(dropFirst(a1), a2));
    return paramsPlus(a1, a2);
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  static public <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  static public int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  static public int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  static public <A> int indexOf(Iterable<A> l, A a) {
    if (l == null)
      return -1;
    int i = 0;
    for (A x : l) {
      if (eq(x, a))
        return i;
      i++;
    }
    return -1;
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public boolean even(BigInteger n) {
    return even(n.intValue());
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public <A, B> Set<A> keys(IMultiMap<A, B> mm) {
    return mm.keySet();
  }

  static public <A extends Concept> A cDeref(Concept.Ref<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public String hjavascript_src(String src, Object... __) {
    return hfulltag("script", "", paramsPlus(__, "src", src));
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public void pcallFAll_minimalExceptionHandling(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        ping();
        pcallF_minimalExceptionHandling(f, args);
      }
  }

  static public void pcallFAll_minimalExceptionHandling(Iterator it, Object... args) {
    while (it.hasNext()) {
      ping();
      pcallF_minimalExceptionHandling(it.next(), args);
    }
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    int i = 0;
    if (odd(l(params))) {
      l.add(strOrNull(first(params)));
      ++i;
    }
    for (; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(List<A> l, final Object f) {
    sort(l, new Comparator<A>() {

      public int compare(A b, A a) {
        return stdcompare((Object) callF(f, a), (Object) callF(f, b));
      }
    });
    return l;
  }

  static public <A> List<A> sortByCalculatedFieldDesc_inPlace(Object f, List<A> c) {
    return sortByCalculatedFieldDesc_inPlace(c, f);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public <A> List<A> objectsWhereFieldGreaterThan(Collection<A> c, String field, Object value) {
    List<A> l = new ArrayList();
    for (A x : unnull(c)) if (cmp(getOpt(x, field), value) > 0)
      l.add(x);
    return l;
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public String th(Object contents, Object... params) {
    return tag("th", contents, params);
  }

  static public <A> List<A> takeLast(List<A> l, int n) {
    return newSubList(l, l(l) - n);
  }

  static public <A> List<A> takeLast(int n, List<A> l) {
    return takeLast(l, n);
  }

  static public String takeLast(int n, String s) {
    return substring(s, l(s) - n);
  }

  static public String takeLast(String s, int n) {
    return substring(s, l(s) - n);
  }

  static public long timestampToLong(Timestamp ts) {
    return ts == null ? 0 : ts.date;
  }

  static public int howManySecondsAgo(long timestamp) {
    return iround(toSeconds(now() - timestamp));
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public String hlabelFor(String id, Object contents) {
    String s = strOrEmpty(contents);
    return empty(s) ? "" : htag("label", s, "for", id);
  }

  static public String hdiv(Object contents, Object... params) {
    return div(contents, params);
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public long parseYMDHMS_slashesSpaceColons(String s) {
    try {
      return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(s).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long parseYMDHMS_slashesSpaceColons(String s, TimeZone tz) {
    try {
      return simpleDateFormat("yyyy/MM/dd HH:mm:ss", tz).parse(s).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static public List<String> nempties(Collection<String> c) {
    return filterNempty(c);
  }

  static public List<String> tok_splitAtComma(String s) {
    return tok_splitAtComma(javaTok(s));
  }

  static public List<String> tok_splitAtComma(List<String> tok) {
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(joinSubList(tok, i + 1, j - 1));
      i = j;
    }
    return out;
  }

  static public List<String> splitAtMinus(String s) {
    return trimAll(asList(s.split("\\-")));
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public Integer parseHourAndOptionalMinutesToMinutes(String s) {
    List<String> l = trimAll(splitAtColon(s));
    if (empty(l))
      return null;
    int minute = parseInt(first(l)) * 60;
    if (l(l) > 1)
      minute += parseInt(second(l));
    return minute;
  }

  static public <A> A second(List<A> l) {
    return get(l, 1);
  }

  static public <A> A second(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    it.next();
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A second(A[] bla) {
    return bla == null || bla.length <= 1 ? null : bla[1];
  }

  static public <A, B> B second(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public <A, B, C> B second(T3<A, B, C> t) {
    return t == null ? null : t.b;
  }

  static public <A> A second(Producer<A> p) {
    if (p == null)
      return null;
    if (p.next() == null)
      return null;
    return p.next();
  }

  static public char second(String s) {
    return charAt(s, 1);
  }

  static public void indexConceptField(Class<? extends Concept> c, String field) {
    indexConceptField(db_mainConcepts(), c, field);
  }

  static public void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndex(concepts, c, field);
  }

  static public <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      } else {
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String combinePrintParameters(String s, Object o) {
    return (endsWithLetterOrDigit(s) ? s + ": " : s) + o;
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public String getStackTrace(String msg) {
    return getStackTrace_noRecord(new Throwable(msg));
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        var __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      var __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public Object call_withVarargs(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(methodName, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(methodName);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + methodName + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(methodName);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + methodName + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public List<String> englishWeekdays_list = ll("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");

  static public List<String> englishWeekdays() {
    return englishWeekdays_list;
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public String decimalFormatEnglish(String format, double d) {
    return decimalFormatEnglish(format).format(d);
  }

  static public java.text.DecimalFormat decimalFormatEnglish(String format) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
  }

  static public int year() {
    return localYear();
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public int month() {
    return localMonth();
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public int weekInYear(long time, TimeZone tz) {
    return parseInt(simpleDateFormat("w", tz).format(time));
  }

  static public long yearToTimestamp(int year, TimeZone tz) {
    try {
      return simpleDateFormat("y", tz).parse(str(year)).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long yearAndMonthToTimestamp(int year, int month, TimeZone tz) {
    try {
      return simpleDateFormat("y/M", tz).parse(year + "/" + month).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long yearAndWeekToTimestamp(int year, int week, TimeZone tz) {
    try {
      return simpleDateFormat("y/w", tz).parse(year + "/" + week).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long ymdToTimestamp(int year, int month, int day) {
    return ymdToTimestamp(year, month, day, defaultTimeZone());
  }

  static public long ymdToTimestamp(int year, int month, int day, TimeZone tz) {
    try {
      return simpleDateFormat("y/M/d", tz).parse(year + "/" + month + "/" + day).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public <A, B extends IF0<A>> List<A> getVars(Iterable<B> l) {
    return lambdaMap(__58 -> getVar(__58), l);
  }

  static public MetaTransformer defaultMetaTransformer() {
    return metaTransformer_transformableAndList();
  }

  static public <A> A cloneSetAll(A a, Object... params) {
    return setAll(clone(a), params);
  }

  static public LongRange joinLongRanges(Iterable<LongRange> l) {
    LongRange r = null;
    for (LongRange x : unnullForIteration(l)) r = r == null ? x : new LongRange(min(r.start, x.start), max(r.end, x.end));
    return r;
  }

  static public long parseYYYYMMDD(String s, TimeZone tz) {
    try {
      return simpleDateFormat("yyyyMMdd", tz).parse(s).getTime();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Pair<A, B> mapEntryToPair(Map.Entry<A, B> e) {
    return e == null ? null : pair(e.getKey(), e.getValue());
  }

  static public <A, B> Set<Map.Entry<A, B>> entrySet(Map<A, B> map) {
    return _entrySet(map);
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public String round(String s) {
    return roundBracket(s);
  }

  static public Complex round(Complex c) {
    return new Complex(round(c.re), round(c.im));
  }

  static public ThreadLocal<Long> saveTiming_last = new ThreadLocal();

  static public void saveTiming(long ms) {
    print(ms + " ms");
    saveTiming_noPrint(ms);
  }

  static public void saveTiming_noPrint(long ms) {
    saveTiming_last.set(ms);
  }

  static public ThreadLocal<Long> saveTiming_tl() {
    return saveTiming_last;
  }

  static public int roundUpTo(int n, int x) {
    return (x + n - 1) / n * n;
  }

  static public long roundUpTo(long n, long x) {
    return (x + n - 1) / n * n;
  }

  static public int roundDownTo(int n, int x) {
    return x / n * n;
  }

  static public long roundDownTo(long n, long x) {
    return x / n * n;
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public java.util.Calendar calendarFromTime(long time, TimeZone tz) {
    java.util.Calendar c = java.util.Calendar.getInstance(tz);
    c.setTimeInMillis(time);
    return c;
  }

  static public java.util.Calendar calendarFromTime(long time) {
    java.util.Calendar c = java.util.Calendar.getInstance();
    c.setTimeInMillis(time);
    return c;
  }

  static public <A> List<A> immutableEmptyList() {
    return Collections.emptyList();
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public short[] emptyShortArray = new short[0];

  static public short[] emptyShortArray() {
    return emptyShortArray;
  }

  static public <A, B> Map<A, B> immutableEmptyMap() {
    return Collections.emptyMap();
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public Symbol emptySymbol_value;

  static public Symbol emptySymbol() {
    if (emptySymbol_value == null)
      emptySymbol_value = symbol("");
    return emptySymbol_value;
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public Map<String, String> subBot_getHeaders() {
    Object session = call(getMainBot(), "getSession");
    return (Map<String, String>) call(session, "getHeaders");
  }

  static public String lower(String s) {
    return s == null ? null : s.toLowerCase();
  }

  static public char lower(char c) {
    return Character.toLowerCase(c);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public String localDateWithMilliseconds(Date time) {
    return localDateWithMilliseconds(time.getTime());
  }

  static public String localDateWithMilliseconds(long time) {
    SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss''SSSS");
    return format.format(time);
  }

  static public String localDateWithMilliseconds() {
    return localDateWithMilliseconds(now());
  }

  static public void logQuotedWithDate(String s) {
    logQuotedWithTime(s);
  }

  static public void logQuotedWithDate(String logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public void logQuotedWithDate(File logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public int subBot_currentPort() {
    return toInt(getOpt(subBot_httpd(), "myPort"));
  }

  static public File programLogFile() {
    return programFile(defaultProgramLogFileName());
  }

  static public File programLogFile(String programID) {
    return programFile(programID, defaultProgramLogFileName());
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    params = unrollParams(params);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (eqOneOf(val, html_valueLessParam(), true))
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public Map similarEmptyMap(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeMap(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public MultiMap mapMultiMapValues(Object func, MultiMap mm) {
    MultiMap m = similarEmptyMultiMap(mm);
    for (Object key : keys(mm)) for (Object value : mm.get(key)) m.put(key, callF(func, value));
    return m;
  }

  static public MultiMap mapMultiMapValues(MultiMap mm, Object func) {
    return mapMultiMapValues(func, mm);
  }

  static public <A, B, C> MultiMap<A, C> mapMultiMapValues(IF1<B, C> func, MultiMap<A, B> mm) {
    return mapMultiMapValues((Object) func, mm);
  }

  static public boolean all(Object pred, Iterable l) {
    if (l != null)
      for (Object o : l) if (!isTrue(callF(pred, o)))
        return false;
    return true;
  }

  static public <A> boolean all(Iterable<A> l, IF1<A, Boolean> f) {
    if (l != null)
      for (A a : l) if (!f.get(a))
        return false;
    return true;
  }

  static public <A> boolean all(IF1<A, Boolean> f, Iterable<A> l) {
    return all(l, f);
  }

  static public boolean all(int[] l, IIntPred f) {
    if (l != null)
      for (int i : l) if (!f.get(i))
        return false;
    return true;
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public double fraction(double d) {
    return d % 1;
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args == null || args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : getDeclaredConstructors_cached(c)) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public <A> A setAll(A o, Map<String, Object> fields) {
    if (fields == null)
      return o;
    for (String field : keys(fields)) set(o, field, fields.get(field));
    return o;
  }

  static public <A> A setAll(A o, Object... values) {
    failIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      set(o, field, value);
    }
    return o;
  }

  static public <A> List<A> llNonNulls(A... a) {
    List<A> l = new ArrayList();
    for (A x : a) if (x != null)
      l.add(x);
    return l;
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public Object callOpt(Object o, String method, Object... args) {
    return callOpt_withVarargs(o, method, args);
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  static public Pair<String[], Integer> find2plusIndex(List<String> pat, List<String> tok) {
    for (int idx = 0; idx < tok.size(); idx += 2) {
      String[] result = find2(pat, tok, idx);
      if (result != null)
        return pair(result, idx + 1);
    }
    return null;
  }

  static public String[] concatStringArrays(String[]... arrays) {
    int l = 0;
    for (String[] a : arrays) l += l(a);
    String[] x = new String[l];
    int i = 0;
    for (String[] a : arrays) if (a != null) {
      System.arraycopy(a, 0, x, i, l(a));
      i += l(a);
    }
    return x;
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  static public List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  static synchronized public List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public String[] find2(List<String> pat, List<String> tok) {
    for (int idx = 0; idx < tok.size(); idx += 2) {
      String[] result = find2(pat, tok, idx);
      if (result != null)
        return result;
    }
    return null;
  }

  static public String[] find2(List<String> pat, List<String> tok, int idx) {
    if (idx + pat.size() > tok.size())
      return null;
    List<String> result = new ArrayList();
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(idx + i);
      if (eq(p, "*"))
        result.add(t);
      else if (!p.equalsIgnoreCase(t))
        return null;
    }
    return toStringArray(result);
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public Runnable wrapAsActivity(Object r) {
    if (r == null)
      return null;
    Runnable r2 = toRunnable(r);
    Object mod = dm_current_generic();
    if (mod == null)
      return r2;
    return new Runnable() {

      public void run() {
        try {
          AutoCloseable c = (AutoCloseable) (rcall("enter", mod));
          AutoCloseable __1 = c;
          try {
            r2.run();
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "AutoCloseable c =  (AutoCloseable) (rcall enter(mod));\r\n    temp c;\r\n    r2.r...";
      }
    };
  }

  static public Thread newThread(Object runnable) {
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public Runnable toRunnable(final Object o) {
    if (o == null)
      return null;
    if (o instanceof Runnable)
      return (Runnable) o;
    if (o instanceof String)
      throw fail("callF_legacy");
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public String patternQuote(String s) {
    return s.length() == 0 ? "" : Pattern.quote(s);
  }

  static public String quoteReplacement(String s) {
    return Matcher.quoteReplacement(s);
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public String filterChars(IF1<Character, Boolean> pred, String s) {
    if (empty(s))
      return null;
    int n = l(s), i = 0;
    char c = s.charAt(i);
    boolean totality = pred.get(c);
    for (++i; i < n; i++) {
      c = s.charAt(i);
      boolean b = pred.get(c);
      if (b != totality) {
        StringBuilder buf = new StringBuilder();
        if (totality)
          buf.append(substring(s, 0, i));
        while (true) {
          ping();
          if (b)
            buf.append(c);
          if (++i >= n)
            break;
          c = s.charAt(i);
          b = pred.get(c);
        }
        return buf.toString();
      }
    }
    return totality ? s : "";
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public void _handleError(Error e) {
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, Rectangle b) {
    return rectContains(a, toRect(b));
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public boolean rectContains(Rect a, Pt p) {
    return a != null && p != null && a.contains(p);
  }

  static public <A> TreeSet<A> asTreeSet(Collection<A> set) {
    return set == null ? null : set instanceof TreeSet ? (TreeSet) set : new TreeSet(set);
  }

  static public MultiMap<String, String> usAreaCodesMap_cache;

  static public MultiMap<String, String> usAreaCodesMap() {
    if (usAreaCodesMap_cache == null)
      usAreaCodesMap_cache = usAreaCodesMap_load();
    return usAreaCodesMap_cache;
  }

  static public MultiMap<String, String> usAreaCodesMap_load() {
    File f = javaxCachesDir("us-area-codes.json");
    if (!fileExists(f))
      saveTextFile(f, loadSnippet("#1028616"));
    return mapMultiMapValues(__59 -> str(__59), mapToMultiMap(jsonDecodeMap(loadTextFile(f))));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public short[] takeFirstOfShortArray(short[] b, int n) {
    return subShortArray(b, 0, n);
  }

  static public short[] takeFirstOfShortArray(int n, short[] b) {
    return takeFirstOfShortArray(b, n);
  }

  static public byte[] takeFirstOfByteArray(byte[] b, int n) {
    return subByteArray(b, 0, n);
  }

  static public byte[] takeFirstOfByteArray(int n, byte[] b) {
    return takeFirstOfByteArray(b, n);
  }

  static public double[] takeFirstOfDoubleArray(double[] b, int n) {
    return subDoubleArray(b, 0, n);
  }

  static public double[] takeFirstOfDoubleArray(int n, double[] b) {
    return takeFirstOfDoubleArray(b, n);
  }

  static public int lCharSequence(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    if (m != null)
      m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public String hijackPrint_tee(Runnable r) {
    final StringBuilder buf = new StringBuilder();
    Object old = interceptPrintInThisThread(new F1<String, Boolean>() {

      public Boolean get(String s) {
        buf.append(s);
        return true;
      }
    });
    try {
      callF(r);
      return str(buf);
    } finally {
      interceptPrintInThisThread(old);
    }
  }

  static public String sourceCodeToHTML(String src) {
    return sourceCodeToHTML_noEncode(htmlencode2(src));
  }

  static public String sourceCodeToHTML(Object o) {
    return sourceCodeToHTML(str(o));
  }

  static public Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static public Object getOptDynOnly(DynamicObject o, String field) {
    if (o == null || o.fieldValues == null)
      return null;
    return o.fieldValues.get(field);
  }

  static public RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((nempty(msg) ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public boolean cicWithSmartWordBoundary(String a, String b) {
    return containsRegexpIC(a, phraseToRegExp(b));
  }

  static public boolean match3_startOrEndOfLine(String pat, String s, boolean startOfLine, boolean endOfLine) {
    if (startOfLine)
      return endOfLine ? match3(pat, s) : matchStart(pat, s);
    else
      return endOfLine ? matchEnd(pat, s) : find3(pat, s);
  }

  static public MMOPattern mmo2_parsePattern(String s) {
    s = trim(tok_deRoundBracket(trim(s)));
    List<String> tok = javaTokWithBrackets(s);
    List<String> l = tok_splitAtComma(tok);
    if (l(l) > 1)
      return new MMOPattern.Or(lambdaMap(__60 -> mmo2_parsePattern(__60), l));
    l = tok_splitAtPlus(tok);
    if (l(l) > 1)
      return new MMOPattern.And(lambdaMap(__61 -> mmo2_parsePattern(__61), l));
    if (startsWith(s, "!"))
      return new MMOPattern.Not(mmo2_parsePattern(dropFirst(s)));
    if (startsWith(s, "^"))
      return new MMOPattern.StartOfLine(mmo2_parsePattern(dropFirst(s)));
    if (endsWith(s, "$"))
      return new MMOPattern.EndOfLine(mmo2_parsePattern(dropLast(s)));
    l = tok_splitAtAsterisk(tok);
    if (l(l) == 2)
      return new MMOPattern.Weighted(parseDouble(second(l)), mmo2_parsePattern(first(l)));
    return new MMOPattern.Phrase(unquote(s), isQuoted(s));
  }

  static public <A> A findWhere(Collection<A> c, Object... data) {
    if (c != null)
      for (A x : c) if (checkFields(x, data))
        return x;
    return null;
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && b != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public <A extends Container> A addAll(A c, Collection<? extends Component> components) {
    return addComponents(c, components);
  }

  static public <A extends Container> A addAll(A c, Component... components) {
    return addComponents(c, components);
  }

  static public boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  static public boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  static public boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public List<String> intRangesToCNC(String s, List<IntRange> l) {
    List<String> tok = new ArrayList();
    int idx = 0;
    for (int i = 0; i < l(l); i++) {
      IntRange r = l.get(i);
      tok.add(substring(s, idx, r.start));
      tok.add(substring(s, r));
      idx = r.end;
    }
    tok.add(substring(s, idx));
    return tok;
  }

  static public List<IntRange> regexpFindRangesIC(String pat, String s) {
    Matcher m = regexpMatcherIC(pat, s);
    List<IntRange> l = new ArrayList();
    while (m.find()) l.add(new IntRange(m.start(), m.end()));
    return l;
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public <A> AutoCloseable tempSetThreadLocalIfNecessary(BetterThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    A prev = tl.get();
    if (eq(prev, a))
      return null;
    tl.set(a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public String unicodeFromCodePoint(int codePoint) {
    return codePointToString(codePoint);
  }

  static public String joinNempties(String sep, Object... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Iterable strings) {
    return joinStrings(sep, strings);
  }

  static public String structureForUser(Object o) {
    return structureForUser(o, new structure_Data());
  }

  static public String structureForUser(Object o, structure_Data d) {
    d.noStringSharing = true;
    d.warnIfUnpersistable(false);
    return beautifyStructure(structure(o, d));
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    return o;
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(() -> {
        for (Component c : unnullForIteration(b)) if (c != null)
          a.add(c);
      });
    }
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public void indexConceptFields(Object... params) {
    int i = 0;
    Concepts concepts;
    if (first(params) instanceof Concepts) {
      concepts = (Concepts) first(params);
      ++i;
    } else
      concepts = db_mainConcepts();
    for (; i < l(params); i += 2) indexConceptField(concepts, (Class) params[i], (String) params[i + 1]);
  }

  static public Field getField(Object o, String field) {
    if (o == null)
      return null;
    return setOpt_findField(_getClass(o), field);
  }

  static public Object getField(Field field, Object o) {
    return fieldGet(field, o);
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long) {
        f.set(o, ((Long) value).intValue());
        return;
      }
      if (type == boolean.class && value instanceof String) {
        f.set(o, isTrueOrYes(((String) value)));
        return;
      }
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    setDynObjectValue(o, key, value);
    return o;
  }

  static public void setDyn(IMeta o, String key, Object value) {
    metaMapPut(o, key, value);
  }

  static public Thread _unregisterThread(Thread t) {
    _registerThread_threads.remove(t);
    return t;
  }

  static public void _unregisterThread() {
    _unregisterThread(currentThread());
  }

  static public String callHtmlMethod(Object o, String uri) {
    return callHtmlMethod(o, uri, null);
  }

  static public String callHtmlMethod(Object o, String uri, Map<String, String> params) {
    String s = (String) callOpt(o, "html", uri, params);
    if (s == null)
      s = (String) callOpt(o, "html", uri);
    if (s == null)
      s = (String) callOpt(o, "html");
    return s;
  }

  static public String getClientIP_subBot() {
    Object session = call(getMainBot(), "getSession");
    Map headers = (Map) (call(session, "getHeaders"));
    return getClientIPFromHeaders(headers);
  }

  static public String loadSecretTextFile(String name) {
    return loadTextFile(new File(getSecretProgramDir(), name));
  }

  static public String loadSecretTextFile(String progID, String name) {
    return loadTextFile(new File(getSecretProgramDir(progID), name));
  }

  static public void saveSecretTextFile(String name, String s) {
    saveTextFile(new File(getSecretProgramDir(), name), s);
  }

  static public void saveSecretTextFile(String progID, String name, String s) {
    saveTextFile(new File(getSecretProgramDir(progID), name), s);
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    File file = new File(fileName);
    mkdirsForFile(file);
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists())
        try {
          String saveName = tempFileName + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      try {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      } finally {
        _close(fileOutputStream);
      }
    }
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
    vmBus_send("wroteFile", file);
    return file;
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int iceil(double d) {
    return (int) Math.ceil(d);
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List mapMethod(Object[] l, final String methodName) {
    return map(l, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(Iterable c, final String methodName) {
    return map(c, new F1<Object, Object>() {

      public Object get(Object o) {
        try {
          return callOpt(o, methodName);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callOpt(o, methodName)";
      }
    });
  }

  static public List mapMethod(String methodName, Iterable c) {
    return mapMethod(c, methodName);
  }

  static public List mapMethod(String methodName, Enumeration c) {
    return mapMethod(methodName, enumerationToIterator(c));
  }

  static public <A> List<A> reversed(Iterable<A> l) {
    return reversedList(l);
  }

  static public <A> List<A> reversed(A[] l) {
    return reversedList(asList(l));
  }

  static public String reversed(String s) {
    return reversedString(s);
  }

  static public String webChatBotLogsHTML() {
    return withDBLock(new F0<String>() {

      public String get() {
        try {
          List<String> l = new ArrayList();
          for (Conversation conv : sortByCalculatedFieldDesc(list(Conversation.class), new F1<Conversation, Object>() {

            public Object get(Conversation c) {
              try {
                return empty(c.msgs) ? c.created : last(c.msgs).time;
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "empty(c.msgs) ? c.created : last(c.msgs).time";
            }
          })) {
            List<List<Msg>> dialogs = reversed(unnull(conv.oldDialogs));
            l.add(webChatBotLogsHTML_formatDialog(str(conv.id + "/" + (l(dialogs) + 1)), conv.msgs));
            int i = l(dialogs);
            for (List<Msg> msgs : dialogs) l.add(webChatBotLogsHTML_formatDialog(conv.id + "/" + (i--), msgs));
          }
          return h3_htitle("Chat Logs") + ul(l, null, "style", "margin-top: 1em");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new L<S> l;\r\n    for (Conversation conv : sortByCalculatedFieldDesc(list Conv...";
      }
    });
  }

  static public String webChatBotLogsHTML_formatDialog(String id, List<Msg> msgs) {
    long startTime = collectMinLong(msgs, "time");
    long endTime = collectMaxLong(msgs, "time");
    List<String> lc = new ArrayList();
    for (Msg m : msgs) if (m.fromUser)
      lc.add("U: " + i(htmlencode(m.text)));
    else
      lc.add("B: " + htmlencode(m.text));
    String time1 = formatDateAndTime(startTime);
    String time2 = formatDateAndTime(endTime);
    time2 = shortenEndTime(time2, time1);
    return id + " [" + htmlencode(time1) + " - " + htmlencode(time2) + "]" + ul(lc);
  }

  static public int parseIntOpt(String s) {
    return parseIntOpt(s, 0);
  }

  static public int parseIntOpt(String s, int defValue) {
    return isInteger(s) ? parseInt(s) : defValue;
  }

  static public String h3_htitle(String s) {
    return htitle(s) + h3(s);
  }

  static public String pageNav2(String baseLink, int count, int value, int step, String nVar, Object... __) {
    List<String> l = new ArrayList();
    baseLink = unnull(baseLink) + (contains(baseLink, "?") ? "&" : "?") + urlencode(nVar) + "=";
    if (value > 0)
      l.add(ahref(baseLink + max(0, value - step), stringPar("leftArrow", __, htmlencode(unicode_leftPointingTriangle()))));
    for (int i = 0; i < count; i += step) {
      int n = i / step + 1;
      if (pageNav2_showPage(value, i, step, count))
        if (value == i)
          l.add(b(n));
        else
          l.add(ahref(baseLink + i, n));
    }
    if (value + step < count)
      l.add(ahref(baseLink + (value + step), stringPar("rightArrow", __, htmlencode(unicode_rightPointingTriangle()))));
    return p("Pages: " + lines(l));
  }

  static public boolean pageNav2_showPage(int actual, int i, int step, int count) {
    int diff = abs(actual - i) / step;
    return i == 0 || i >= (count - 1) / step * step || diff <= 10 || diff <= 100 && ((i / step) % 10) == 9 || diff <= 1000 && ((i / step) % 100) == 99 || ((i / step) % 1000) == 999;
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, List<A> l) {
    return subList(l, startIndex);
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex > endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public void deleteConcepts(Collection conceptsOrIDs) {
    db_mainConcepts().deleteConcepts(asList(conceptsOrIDs));
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, Object... params) {
    return deleteConcepts(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, Object... params) {
    List<A> l = asList(findConceptsWhere(cc, c, params));
    deleteConcepts(l);
    return l;
  }

  static public <A extends Concept> List<A> deleteConcepts(Class<A> c, IF1<A, Boolean> pred) {
    return deleteConcepts(db_mainConcepts(), c, pred);
  }

  static public <A extends Concept> List<A> deleteConcepts(Concepts cc, Class<A> c, IF1<A, Boolean> pred) {
    var l = filter(list(cc, c), pred);
    deleteConcepts(l);
    return l;
  }

  static public List<Concept> deleteConcepts(Concepts cc) {
    return deleteConcepts(cc, Concept.class);
  }

  static public void deleteConcept(long id) {
    db_mainConcepts().deleteConcept(id);
  }

  static public void deleteConcept(Concepts concepts, long id) {
    concepts.deleteConcept(id);
  }

  static public void deleteConcept(Concept c) {
    if (c != null)
      c.delete();
  }

  static public void deleteConcept(Concept.Ref ref) {
    if (ref != null)
      deleteConcept(ref.get());
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      vmBus_send("locking", lock, "thread", currentThread());
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      vmBus_send("locked", lock, "thread", currentThread());
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public String javascriptQuote(String s) {
    return quote(s);
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public String loadLocalSnippet(String snippetID) {
    return loadLocalSnippet(psI(snippetID));
  }

  static public String loadLocalSnippet(long snippetID) {
    return loadTextFile(localSnippetFile(snippetID));
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5_impl(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  static public byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(File file) {
    return md5OfFile(file);
  }

  static public String tb_mainServer_default = "https://code.botcompany.de:9898";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    Long limit = optPar(loadPage_sizeLimit);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      boolean silent = isTrue(loadPage_silent.get());
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (limit == null || n < limit) {
        ping();
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if (!silent && (n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public String smallestTransparentGIFDataURI() {
    return "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public String hreplacetag(String html, String tag, String newTag) {
    List<String> tok = htmlcoarsetok(html);
    List<List<String>> tags = findContainerTag(tok, tag);
    if (empty(tags))
      return html;
    List<String> theTag = first(tags);
    List<String> actualTag = subList(theTag, 1, l(theTag) - 1);
    return join(replaceSubList(cloneList(tok), actualTag, litlist(newTag)));
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  static public boolean isRelativeOrAbsoluteURL(String s) {
    return isAbsoluteURL(s) || isRelativeURL(s);
  }

  static public Object subBot_serveWithContentType(String text, String contentType) {
    return callMainBot("serveByteArray", toUtf8(unnull(text)), contentType);
  }

  static public String himg(String src, Object... params) {
    return tag("img", "", arrayPlus(params, "src", isSnippetID(src) ? snippetImageLink(src) : src));
  }

  static public String himg(BufferedImage img, Object... params) {
    return himg(dataURL(jpegMimeType(), toJPEG(img)), params);
  }

  static public String dataSnippetURL(String snippetID) {
    return dataSnippetLink(snippetID);
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  static public List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  static public int toLines_nextLineBreak(String s, int start) {
    int n = s.length();
    for (int i = start; i < n; i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public TreeSet<String> toCaseInsensitiveSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet();
    addAll(set, x);
    return set;
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public String timeInTimeZone(String timeZone) {
    return timeInTimeZone(timeZone, now());
  }

  static public String timeInTimeZone(String timeZone, long time) {
    return simpleDateFormat_timeZone("HH:mm", timeZone).format(time);
  }

  static public String timeInTimeZone(TimeZone timeZone, long time) {
    return simpleDateFormat("HH:mm", timeZone).format(time);
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public <A> List<A> withoutNulls(Iterable<A> l) {
    if (l instanceof List)
      if (!containsNulls((List) l))
        return ((List) l);
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public int[] subArray(int[] b, int start, int end) {
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public short[] subArray(short[] b, int start, int end) {
    if (start <= 0 && end >= l(b))
      return b;
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public float[] subArray(float[] b, int start, int end) {
    float[] x = new float[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public Object[] subArray(Object[] b, int start) {
    return subArray(b, start, l(b));
  }

  static public Object[] subArray(Object[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start >= end)
      return new Object[0];
    Object[] x = new Object[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public String hpasswordfield(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "password", "name", name, "value", value }, params));
  }

  static public String hpasswordfield(String name) {
    return hpasswordfield(name, "");
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  static public <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public String ipToCountry2020_dataSnippetID = "#1400400";

  static public Map<Long, String> ipToCountry2020_cache = mruCache(100);

  static public Lock ipToCountry2020_lock = lock();

  static public File ipToCountry2020_dataDir() {
    return javaxCachesDir("ipToCountry2020");
  }

  static public String ipToCountry2020(String ip) {
    return ipToCountry2020(ipToInt(ip));
  }

  static public String ipToCountry2020(long ipNum) {
    return mapGetOrCreate(ipToCountry2020_cache, ipNum, () -> ipToCountry2020_uncached(ipNum));
  }

  static public String ipToCountry2020_uncached(long ipNum) {
    {
      Lock __0 = ipToCountry2020_lock;
      lock(__0);
      try {
        if (directoryEmpty(ipToCountry2020_dataDir()))
          unzipSnippet(ipToCountry2020_dataSnippetID, ipToCountry2020_dataDir());
      } finally {
        unlock(__0);
      }
    }
    String line = pairB(binarySearchForLineInTextFile(newFile(ipToCountry2020_dataDir(), "IP2LOCATION-LITE-DB1.CSV"), s -> {
      List<String> l = tok_splitAtComma_unquote(s);
      long a = parseLongOpt(first(l)), b = parseLongOpt(second(l));
      return ipNum > b ? 1 : ipNum < a ? -1 : 0;
    }));
    return get(tok_splitAtComma_unquote(line), 2);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public <A, B, C> MultiMap<B, C> mapKeys(IF1<A, C> f, MultiMap<A, B> mm) {
    return mapMultiMapKeys(f, mm);
  }

  static public <A, B, C> MultiSetMap<B, C> mapKeys(IF1<A, C> f, MultiSetMap<A, B> mm) {
    return mapMultiSetMapKeys(f, mm);
  }

  static public String deSquareBracket(String s) {
    if (startsWith(s, "[") && endsWith(s, "]"))
      return substring(s, 1, l(s) - 1);
    return s;
  }

  static public TreeMap litcimap(Object... x) {
    return litCIMap(x);
  }

  static public String regexpReplaceIC(String s, String pat, Object f) {
    return regexReplaceIC(s, pat, f);
  }

  static public String regexpReplaceIC(String s, String pat, String replacement) {
    return regexReplaceIC(s, pat, replacement);
  }

  static public String regexpReplaceIC(String s, String pat, IF1<Matcher, String> f) {
    return regexReplaceIC(s, pat, f);
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public <A> int nfilter(Iterable<A> c, IF1<A, Boolean> pred) {
    return nfilter(pred, c);
  }

  static public <A> int nfilter(IF1<A, Boolean> pred, Iterable<A> c) {
    int n = 0;
    if (c != null)
      for (A o : c) if (pred.get(o))
        ++n;
    return n;
  }

  static public int nfilter(Iterable c, Object pred) {
    int n = 0;
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        ++n;
    return n;
  }

  static public int nfilter(Object pred, Iterable c) {
    return nfilter(c, pred);
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return new SynchronizedMap(map);
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return classLoaderForObject(realm).loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public <A, B> B syncMapGet2(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (collectionMutex(map)) {
      return map.get(a);
    }
  }

  static public <A, B> B syncMapGet2(A a, Map<A, B> map) {
    return syncMapGet2(map, a);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public Map vm_generalWeakSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public String dropFrom(String s, String x) {
    if (s == null)
      return null;
    int i = s.indexOf(x);
    if (i < 0)
      return s;
    return substring(s, 0, i);
  }

  static public String makePostData(Map map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : castMapToMapO(map).entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String a(String noun) {
    if (eq(noun, ""))
      return "?";
    return ("aeiou".indexOf(noun.charAt(0)) >= 0 ? "an " : "a ") + noun;
  }

  static public String a(String contents, Object... params) {
    return hfulltag("a", contents, params);
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public Concepts newConceptsWithClassFinder(String progID) {
    Concepts cc = new Concepts(progID);
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public Concepts newConceptsWithClassFinder(File conceptsFile) {
    Concepts cc = new Concepts(assertNotNull(conceptsFile));
    cc.classFinder = _defaultClassFinder();
    return cc;
  }

  static public Concepts newConceptsWithClassFinder(File conceptsFile, IF1<String, Class> classFinder) {
    Concepts cc = new Concepts(assertNotNull(conceptsFile));
    cc.classFinder = classFinder;
    return cc;
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      ClassLoader cl = (o instanceof Class ? (Class) o : o.getClass()).getClassLoader();
      if (cl == null)
        return null;
      String name = mainClassNameForClassLoader(cl);
      return loadClassFromClassLoader_orNull(cl, name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] assertEvenLength(Object[] a) {
    assertTrue(even(l(a)));
    return a;
  }

  static public LinkedHashMap paramsToOrderedMap(Object... params) {
    return asLinkedHashMap(paramsToMap(params));
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public <A, B> void mapPut_noOverwrite(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null && !map.containsKey(key))
      map.put(key, value);
  }

  static public String hstylesheetsrc(String src) {
    return tag("link", "", "rel", "stylesheet", "href", src);
  }

  static public String htmldecode_dropAllTags(String html) {
    return htmldecode(dropAllTags(html));
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public void newPing() {
    var tl = newPing_actionTL();
    Runnable action = tl == null ? null : tl.get();
    {
      if (action != null)
        action.run();
    }
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != l(args)) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public Object deref(Object o) {
    if (o instanceof IRef)
      return ((IRef) o).get();
    return o;
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public void dynamicObject_setRawFieldValue(DynamicObject o, Object key, Object value) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = syncMapPut2_createLinkedHashMap((LinkedHashMap) o.fieldValues, key, value);
    }
  }

  static public boolean isConceptList(Object o) {
    if (!(o instanceof List))
      return false;
    List l = (List) o;
    for (Object x : l) if (!(x instanceof Concept))
      return false;
    return true;
  }

  static public void dynamicObject_dropRawField(DynamicObject o, Object key) {
    if (o == null)
      return;
    synchronized (o) {
      o.fieldValues = (LinkedHashMap) syncMapRemove_deleteMapIfEmpty((Map) o.fieldValues, key);
    }
  }

  static public boolean isPersistable(Object o) {
    return !isInAnonymousClass(o);
  }

  static public Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  static public <A extends Concept> A derefRef(Concept.Ref<A> r) {
    return r == null ? null : r.get();
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
    return lambdaMap(f, l);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
    return lambdaMap(f, l);
  }

  static public boolean isTransient(Field f) {
    return (f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) != 0;
  }

  static public int compareIC(String s1, String s2) {
    return compareIgnoreCase_jdk(s1, s2);
  }

  static public <A> A[] itemPlusArray(A a, A[] l) {
    return singlePlusArray(a, l);
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    if (o instanceof Boolean)
      return boolToInt((Boolean) o);
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public Object pcallF_minimalExceptionHandling(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable e) {
      System.out.println(getStackTrace(e));
      _storeException(e);
    }
    return null;
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (vm_generalMap()) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (vm_generalMap()) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public double toSeconds(long ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(long ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toSeconds(double ms) {
    return ms / 1000.0;
  }

  static public String toSeconds(double ms, int digits) {
    return formatDouble(toSeconds(ms), digits);
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble((String) o);
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public List<String> filterNempty(Collection<String> c) {
    List<String> l = new ArrayList();
    for (String x : unnull(c)) if (nempty(x))
      l.add(x);
    return l;
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !regionMatches(s, j, "*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j < l && !regionMatches(s, j, "]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !regionMatches(s, j, "]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public List<String> splitAtColon(String s) {
    return empty(s) ? emptyList() : asList(s.split(":"));
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
    return isConceptFieldIndexed(db_mainConcepts(), c, field);
  }

  static public boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
    return concepts.getFieldIndex(c, field) != null;
  }

  static public AutoCloseable tempDBLock(Concepts concepts) {
    return tempLock(concepts.lock);
  }

  static public AutoCloseable tempDBLock() {
    return tempDBLock(db_mainConcepts());
  }

  static public <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public Concept unlisted(String name, Object... args) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    try {
      return cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  static public int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnullForIteration(l)) n += cset(c, values);
    return n;
  }

  static public int csetAll(Concept c, Map<String, Object> values) {
    int n = 0;
    for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet(values)) {
      String field = __0.getKey();
      Object value = __0.getValue();
      n += cset(c, field, value);
    }
    return n;
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      {
        if (f != null)
          f.get(a);
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public Object pcallF(Runnable r) {
    try {
      {
        if (r != null)
          r.run();
      }
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A> A pcallF(IF0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public <A, B> B pcallF(IF1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] massageArgsForVarArgsCall(Executable m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = l(args);
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    int nVarArgs = nArgs - n;
    Object varArgs = Array.newInstance(varArgType, nVarArgs);
    for (int i = 0; i < nVarArgs; i++) Array.set(varArgs, i, args[n + i]);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(asList(l));
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public TimeZone defaultTimeZone() {
    return TimeZone.getDefault();
  }

  static public MetaTransformer metaTransformer_transformableAndList() {
    return new MetaTransformer(new MetaTransformer.StructureHandler() {

      public Object transform(Object o, IF1 recurse) {
        if (o instanceof Transformable)
          return ((Transformable) o).transformUsing(recurse);
        if (o instanceof List)
          return map_ping(recurse, ((List) o));
        return null;
      }

      public void visit(Object o, IVF1 recurse) {
        if (o instanceof Visitable)
          ((Visitable) o).visitUsing(recurse);
        else if (o instanceof List)
          for (Object x : ((List) o)) {
            ping();
            recurse.get(x);
          }
      }
    });
  }

  static public <A> A clone(A o) {
    ArrayDeque<Runnable> q = new ArrayDeque();
    Object x = clone_impl(o, new IdentityHashMap(), q);
    while (!q.isEmpty()) q.poll().run();
    return (A) x;
  }

  static public Object clone_impl(Object o, final IdentityHashMap seen, final ArrayDeque<Runnable> q) {
    try {
      if (o == null)
        return null;
      Object y = seen.get(o);
      if (y != null)
        return y;
      if (o instanceof List) {
        final List l = new ArrayList();
        seen.put(o, l);
        for (final Object x : (List) o) q.add(new Runnable() {

          public void run() {
            try {
              l.add(clone_impl(x, seen, q));
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "l.add(clone_impl(x, seen, q))";
          }
        });
        return l;
      }
      if (o instanceof Map) {
        final Map m = similarEmptyMap((Map) o);
        seen.put(o, m);
        for (Object entry : ((Map) o).entrySet()) {
          final Map.Entry e = (Map.Entry) entry;
          q.add(new Runnable() {

            public void run() {
              try {
                m.put(clone_impl(e.getKey(), seen, q), clone_impl(e.getValue(), seen, q));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.put(clone_impl(e.getKey(), seen, q), clone_impl(e.getValue(), seen, q))";
            }
          });
        }
        return m;
      }
      if (o instanceof String || o instanceof Number || o instanceof Boolean)
        return o;
      if (o instanceof Object[]) {
        final Object[] l = (Object[]) o;
        final Object[] l2 = l.clone();
        seen.put(o, l2);
        for (int i = 0; i < l.length; i++) {
          final int _i = i;
          q.add(new Runnable() {

            public void run() {
              try {
                l2[_i] = clone_impl(l[_i], seen, q);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "l2[_i] = clone_impl(l[_i], seen, q)";
            }
          });
        }
        return l2;
      }
      final Object clone = nuObjectWithoutArguments(o.getClass());
      seen.put(o, clone);
      Class c = o.getClass();
      while (c != Object.class) {
        Field[] fields = c.getDeclaredFields();
        for (final Field field : fields) {
          if ((field.getModifiers() & Modifier.STATIC) != 0)
            continue;
          field.setAccessible(true);
          final Object value = field.get(o);
          q.add(new Runnable() {

            public void run() {
              try {
                field.set(clone, clone_impl(value, seen, q));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "field.set(clone, clone_impl(value, seen, q))";
            }
          });
        }
        c = c.getSuperclass();
      }
      return clone;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String roundBracket(String s) {
    return "(" + s + ")";
  }

  static public String roundBracket(Object s) {
    return roundBracket(str(s));
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String[] a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(String[] a, String b, int i) {
    int n = a == null ? 0 : a.length;
    for (; i < n; i++) if (eqic(a[i], b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public WeakHasherMap<Symbol, Boolean> symbol_map = new WeakHasherMap(new Hasher<Symbol>() {

    public int hashCode(Symbol symbol) {
      return symbol.text.hashCode();
    }

    public boolean equals(Symbol a, Symbol b) {
      if (a == null)
        return b == null;
      return b != null && eq(a.text, b.text);
    }
  });

  static public Symbol symbol(String s) {
    if (s == null)
      return null;
    synchronized (symbol_map) {
      Symbol symbol = new Symbol(s, true);
      Symbol existingSymbol = symbol_map.findKey(symbol);
      if (existingSymbol == null)
        symbol_map.put(existingSymbol = symbol, true);
      return existingSymbol;
    }
  }

  static public Symbol symbol(CharSequence s) {
    if (s == null)
      return null;
    if (s instanceof Symbol)
      return (Symbol) s;
    if (s instanceof String)
      return symbol((String) s);
    return symbol(str(s));
  }

  static public Symbol symbol(Object o) {
    return symbol((CharSequence) o);
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  static public void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  static public File programFile(String name) {
    return prepareProgramFile(name);
  }

  static public File programFile(String progID, String name) {
    return prepareProgramFile(progID, name);
  }

  static public String defaultProgramLogFileName() {
    return "log.txt";
  }

  static public Object[] unrollParams(Object[] params) {
    if (l(params) == 1 && params[0] instanceof Map)
      return mapToParams((Map) params[0]);
    return params;
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public MultiMap similarEmptyMultiMap(MultiMap m) {
    if (m instanceof TreeMultiMap)
      return new TreeMultiMap((TreeMultiMap) m);
    return similarEmptyMultiMap(m == null ? null : m.data);
  }

  static public MultiMap similarEmptyMultiMap(Map m) {
    MultiMap mm = new MultiMap();
    if (m != null)
      mm.data = similarEmptyMap(m);
    return mm;
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    return classForName(name, null);
  }

  static public Class classForName(String name, Object classFinder) {
    if (classForName_cache == null || classFinder != null)
      return classForName_uncached(name, classFinder);
    Class c = classForName_cache.get(name);
    if (c == null)
      classForName_cache.put(name, c = classForName_uncached(name, null));
    return c;
  }

  static public Class classForName_uncached(String name, Object classFinder) {
    try {
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : getDeclaredConstructors_cached(c)) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public Map<Class, Constructor[]> getDeclaredConstructors_cached_cache = newDangerousWeakHashMap();

  static public Constructor[] getDeclaredConstructors_cached(Class c) {
    Constructor[] ctors;
    synchronized (getDeclaredConstructors_cached_cache) {
      ctors = getDeclaredConstructors_cached_cache.get(c);
      if (ctors == null) {
        getDeclaredConstructors_cached_cache.put(c, ctors = c.getDeclaredConstructors());
        for (var ctor : ctors) makeAccessible(ctor);
      }
    }
    return ctors;
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public void set(BitSet bs, int idx) {
    {
      if (bs != null)
        bs.set(idx);
    }
  }

  static public void failIfOddCount(Object... list) {
    if (odd(l(list)))
      throw fail("Odd list size: " + list);
  }

  static public Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<String> dropPunctuation_keep = ll("*", "<", ">");

  static public List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  static public String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public Object dm_current_generic() {
    return getWeakRef(dm_current_generic_tl().get());
  }

  static public Object rcall(String method, Object o, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Runnable _topLevelErrorHandling(Runnable r) {
    if (r == null)
      return null;
    Object info = _threadInfo();
    Object mod = dm_current_generic();
    Runnable r2 = r;
    if (info != null || mod == null)
      r2 = new Runnable() {

        public void run() {
          try {
            AutoCloseable __1 = (AutoCloseable) (rcall("enter", mod));
            try {
              _threadInheritInfo(info);
              r.run();
            } finally {
              _close(__1);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp (AutoCloseable) rcall enter(mod);\r\n      _threadInheritInfo(info);\r\n    ...";
        }
      };
    r2 = rPcall(r2);
    return r2;
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public <A, B, C extends Collection<B>> MultiMap<A, B> mapToMultiMap(Map<A, C> map) {
    if (map == null)
      return null;
    MultiMap<A, B> mm = similarEmptyMultiMap(map);
    for (Map.Entry<? extends A, ? extends Collection<B>> __0 : _entrySet(map)) {
      A key = __0.getKey();
      Collection<B> values = __0.getValue();
      mm.putAll(key, values);
    }
    return mm;
  }

  static public Map jsonDecodeMap(String s) {
    Object o = jsonDecode(s);
    if (o instanceof List && empty((List) o))
      return new HashMap();
    if (o instanceof Map)
      return (Map) o;
    else
      throw fail("Not a JSON map: " + s);
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public short[] subShortArray(short[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new short[0];
    short[] x = new short[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subByteArray(byte[] b, int start) {
    return subByteArray(b, start, l(b));
  }

  static public byte[] subByteArray(byte[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new byte[0];
    byte[] x = new byte[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public byte[] subByteArray(byte[] b, IntRange r) {
    return r == null ? null : subByteArray(b, r.start, r.end);
  }

  static public double[] subDoubleArray(double[] b, int start) {
    return subDoubleArray(b, start, l(b));
  }

  static public double[] subDoubleArray(double[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new double[0];
    double[] x = new double[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public String sourceCodeToHTML_noEncode(String html) {
    return "<pre style=\"white-space: pre-wrap; white-space: -moz-pre-wrap; white-space: -pre-wrap; white-space: -o-pre-wrap; word-wrap: break-word;\">" + html + "</pre>";
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String appendColonIfNempty(String s) {
    return empty(s) ? "" : s + ": ";
  }

  static public boolean containsRegexpIC(String s, String pat) {
    return compileRegexpIC(pat).matcher(s).find();
  }

  static public String phraseToRegExp(String b) {
    return (startsWithLetterOrDigit(b) ? "\\b" : "") + regexpQuote(b) + (endsWithLetterOrDigit(b) ? "\\b" : "");
  }

  static public boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  static public boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  static public boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  static public boolean matchEnd(String pat, String s) {
    return matchEnd(pat, s, null);
  }

  static public boolean matchEnd(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    List<String> tokpat = parse3(pat), toks = parse3(s);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, takeLast(l(tokpat), toks));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = join(dropLast(l(tokpat), toks));
    }
    return true;
  }

  static public String tok_deRoundBracket(String s) {
    return tok_isRoundBracketed(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public List<String> javaTokWithBrackets(String s) {
    return javaTokPlusBrackets(s);
  }

  static public List<String> tok_splitAtPlus(String s) {
    return tok_splitAtPlus(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtPlus(List<String> tok) {
    return splitAtTokens(tok, "+");
  }

  static public List<String> tok_splitAtAsterisk(String s) {
    return tok_splitAtAsterisk(javaTokWithAllBrackets_cached(s));
  }

  static public List<String> tok_splitAtAsterisk(List<String> tok) {
    return splitAtTokens(tok, "*");
  }

  static public double parseDouble(String s) {
    return empty(s) ? 0.0 : Double.parseDouble(s);
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public boolean checkFields(Object x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(getOpt(x, (String) data[i]), data[i + 1]))
      return false;
    return true;
  }

  static public <A extends Container> A addComponents(A c, Collection<? extends Component> components) {
    if (nempty(components)) {
      swing(() -> {
        for (Component comp : components) if (comp != null)
          c.add(comp);
        revalidate(c);
      });
    }
    return c;
  }

  static public <A extends Container> A addComponents(A c, Component... components) {
    return addComponents(c, asList(components));
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public Matcher regexpMatcherIC(String pat, String s) {
    return compileRegexpIC(pat).matcher(unnull(s));
  }

  static public String codePointToString(int codePoint) {
    return new String(Character.toChars(codePoint));
  }

  static public String joinStrings(String sep, Object... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Iterable strings) {
    StringBuilder buf = new StringBuilder();
    for (Object o : unnull(strings)) {
      String s = strOrNull(o);
      if (nempty(s)) {
        if (nempty(buf))
          buf.append(sep);
        buf.append(s);
      }
    }
    return str(buf);
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public boolean structure_showTiming, structure_checkTokenCount;

  static public String structure(Object o) {
    return structure(o, new structure_Data());
  }

  static public String structure(Object o, structure_Data d) {
    StringWriter sw = new StringWriter();
    d.out = new PrintWriter(sw);
    structure_go(o, d);
    String s = str(sw);
    if (structure_checkTokenCount) {
      print("token count=" + d.n);
      assertEquals("token count", l(javaTokC(s)), d.n);
    }
    return s;
  }

  static public void structure_go(Object o, structure_Data d) {
    structure_1(o, d);
    while (nempty(d.stack)) popLast(d.stack).run();
  }

  static public void structureToPrintWriter(Object o, PrintWriter out) {
    structureToPrintWriter(o, out, new structure_Data());
  }

  static public void structureToPrintWriter(Object o, PrintWriter out, structure_Data d) {
    d.out = out;
    structure_go(o, d);
  }

  static public boolean structure_allowShortening = false;

  static public class structure_ClassInfo {

    public Class c;

    public String shortName;

    public List<Field> fields;

    public Method customSerializer;

    public IVF1<Object> serializeObject;

    public boolean special = false;

    public boolean nullInstances = false;

    public boolean javafy = false;

    public Object emptyInstance;

    public void nullInstances(boolean b) {
      this.nullInstances = b;
      if (b)
        special = true;
    }

    public void javafy(boolean b) {
      this.javafy = b;
      if (b)
        special = true;
    }
  }

  static public class structure_Data {

    public PrintWriter out;

    public int stringSizeLimit;

    public int shareStringsLongerThan = 20;

    public boolean noStringSharing = false;

    public boolean storeBaseClasses = false;

    public boolean honorFieldOrder = true;

    public String mcDollar = actualMCDollar();

    final public structure_Data setWarnIfUnpersistable(boolean warnIfUnpersistable) {
      return warnIfUnpersistable(warnIfUnpersistable);
    }

    public structure_Data warnIfUnpersistable(boolean warnIfUnpersistable) {
      this.warnIfUnpersistable = warnIfUnpersistable;
      return this;
    }

    final public boolean getWarnIfUnpersistable() {
      return warnIfUnpersistable();
    }

    public boolean warnIfUnpersistable() {
      return warnIfUnpersistable;
    }

    public boolean warnIfUnpersistable = true;

    final public structure_Data setStackTraceIfUnpersistable(boolean stackTraceIfUnpersistable) {
      return stackTraceIfUnpersistable(stackTraceIfUnpersistable);
    }

    public structure_Data stackTraceIfUnpersistable(boolean stackTraceIfUnpersistable) {
      this.stackTraceIfUnpersistable = stackTraceIfUnpersistable;
      return this;
    }

    final public boolean getStackTraceIfUnpersistable() {
      return stackTraceIfUnpersistable();
    }

    public boolean stackTraceIfUnpersistable() {
      return stackTraceIfUnpersistable;
    }

    public boolean stackTraceIfUnpersistable = true;

    final public structure_Data setSkipDefaultValues(boolean skipDefaultValues) {
      return skipDefaultValues(skipDefaultValues);
    }

    public structure_Data skipDefaultValues(boolean skipDefaultValues) {
      this.skipDefaultValues = skipDefaultValues;
      return this;
    }

    final public boolean getSkipDefaultValues() {
      return skipDefaultValues();
    }

    public boolean skipDefaultValues() {
      return skipDefaultValues;
    }

    public boolean skipDefaultValues = false;

    transient public IF1<Field, Boolean> shouldIncludeField;

    public boolean shouldIncludeField(Field f) {
      return shouldIncludeField != null ? shouldIncludeField.get(f) : shouldIncludeField_base(f);
    }

    final public boolean shouldIncludeField_fallback(IF1<Field, Boolean> _f, Field f) {
      return _f != null ? _f.get(f) : shouldIncludeField_base(f);
    }

    public boolean shouldIncludeField_base(Field f) {
      return true;
    }

    public IdentityHashMap<Object, Integer> seen = new IdentityHashMap();

    public HashMap<String, Integer> strings = new HashMap();

    public HashSet<String> concepts = new HashSet();

    public HashMap<Class, structure_ClassInfo> infoByClass = new HashMap();

    public HashMap<Class, IF1<Object, Map>> persistenceInfo = new HashMap();

    public int n;

    public List<Runnable> stack = new ArrayList();

    public structure_Data append(String token) {
      out.print(token);
      ++n;
      return this;
    }

    public structure_Data append(int i) {
      out.print(i);
      ++n;
      return this;
    }

    public structure_Data append(String token, int tokCount) {
      out.print(token);
      n += tokCount;
      return this;
    }

    public structure_Data app(String token) {
      out.print(token);
      return this;
    }

    public structure_Data app(int i) {
      out.print(i);
      return this;
    }

    public structure_ClassInfo infoForClass(Class c) {
      structure_ClassInfo info = infoByClass.get(c);
      if (info == null)
        info = newClass(c);
      return info;
    }

    public structure_ClassInfo newClass(Class c) {
      structure_ClassInfo info = new structure_ClassInfo();
      info.c = c;
      infoByClass.put(c, info);
      String name = c.getName();
      String shortName = dropPrefix("main$", dropPrefix("loadableUtils.utils$", dropPrefix(mcDollar, name)));
      if (startsWithDigit(shortName))
        shortName = name;
      info.shortName = shortName;
      try {
        if (isSyntheticOrAnonymous(c)) {
          info.nullInstances(true);
          return info;
        }
        if (c.isEnum()) {
          info.special = true;
          return info;
        }
        if (c.isArray()) {
          return info;
        }
        if ((info.customSerializer = findMethodNamed(c, "_serialize")) != null)
          info.special = true;
        if (storeBaseClasses) {
          Class sup = c.getSuperclass();
          if (sup != Object.class) {
            append("bc ");
            append(shortDynClassNameForStructure(c));
            out.print(" ");
            append(shortDynClassNameForStructure(sup));
            out.print(" ");
            infoForClass(sup);
          }
        }
        if (eqOneOf(name, "java.awt.Color", "java.lang.ThreadLocal"))
          info.javafy(true);
        else if (name.startsWith("sun") || !isPersistableClass(c)) {
          info.javafy(true);
          if (warnIfUnpersistable) {
            String msg = "Class not persistable: " + c + " (anonymous or no default constructor), referenced from " + last(stack);
            if (stackTraceIfUnpersistable)
              printStackTrace(new Throwable(msg));
            else
              print(msg);
          }
        } else if (skipDefaultValues) {
          var ctor = getDefaultConstructor(c);
          if (ctor != null)
            info.emptyInstance = invokeConstructor(ctor);
        }
      } catch (Throwable e) {
        printStackTrace(e);
        info.nullInstances(true);
      }
      return info;
    }

    public void setFields(structure_ClassInfo info, List<Field> fields) {
      info.fields = fields;
    }

    public void writeObject(Object o, String shortName, Map<String, Object> fv) {
      String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
      append(shortName);
      n += countDots(shortName) * 2;
      int l = n;
      Iterator it = fv.entrySet().iterator();
      class WritingObject implements Runnable {

        public String lastFieldWritten;

        public void run() {
          try {
            if (!it.hasNext()) {
              if (n != l)
                append(")");
            } else {
              Map.Entry e = (Map.Entry) (it.next());
              append(n == l ? "(" : ", ");
              append(lastFieldWritten = (String) e.getKey()).append("=");
              stack.add(this);
              structure_1(e.getValue(), structure_Data.this);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return shortName + "." + lastFieldWritten;
        }
      }
      stack.add(new WritingObject());
    }
  }

  static public void structure_1(final Object o, final structure_Data d) {
    try {
      if (o == null) {
        d.append("null");
        return;
      }
      Class c = o.getClass();
      boolean concept = false;
      concept = o instanceof Concept;
      structure_ClassInfo info = d.infoForClass(c);
      List<Field> lFields = info.fields;
      if (lFields == null) {
        if (o instanceof Number) {
          PrintWriter out = d.out;
          if (o instanceof Integer) {
            int i = ((Integer) o).intValue();
            out.print(i);
            d.n += i < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Long) {
            long l = ((Long) o).longValue();
            out.print(l);
            out.print("L");
            d.n += l < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Short) {
            short s = ((Short) o).shortValue();
            d.append("sh ");
            out.print(s);
            d.n += s < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Float) {
            d.append("fl ", 2);
            quoteToPrintWriter(str(o), out);
            return;
          }
          if (o instanceof Double) {
            d.append("d(", 3);
            quoteToPrintWriter(str(o), out);
            d.append(")");
            return;
          }
          if (o instanceof BigInteger) {
            out.print("bigint(");
            out.print(o);
            out.print(")");
            d.n += ((BigInteger) o).signum() < 0 ? 5 : 4;
            return;
          }
        }
        if (o instanceof Boolean) {
          d.append(((Boolean) o).booleanValue() ? "t" : "f");
          return;
        }
        if (o instanceof Character) {
          d.append(quoteCharacter((Character) o));
          return;
        }
        if (o instanceof File) {
          d.append("File ").append(quote(((File) o).getPath()));
          return;
        }
        Integer ref = d.seen.get(o);
        if (o instanceof String && ref == null)
          ref = d.strings.get((String) o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        if (!(o instanceof String))
          d.seen.put(o, d.n);
        else {
          String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
          if (!d.noStringSharing) {
            if (d.shareStringsLongerThan == Integer.MAX_VALUE)
              d.seen.put(o, d.n);
            if (l(s) >= d.shareStringsLongerThan)
              d.strings.put(s, d.n);
          }
          quoteToPrintWriter(s, d.out);
          d.n++;
          return;
        }
        if (o instanceof Set) {
          if (((Set) o) instanceof TreeSet) {
            d.append(isCISet_gen((Set) o) ? "ciset" : "treeset");
            structure_1(new ArrayList((Set) o), d);
            return;
          }
          d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
          structure_1(new ArrayList((Set) o), d);
          return;
        }
        String name = c.getName();
        if (o instanceof Collection && !isJavaXClassName(name)) {
          if (name.equals("java.util.Collections$SynchronizedList") || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedList(((List) o)), d);
              return;
            }
          } else if (name.equals("java.util.LinkedList"))
            d.append("ll");
          d.append("[");
          final int l = d.n;
          final Iterator it = cloneList((Collection) o).iterator();
          d.stack.add(new Runnable() {

            public void run() {
              try {
                if (!it.hasNext())
                  d.append("]");
                else {
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(it.next(), d);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta...";
            }
          });
          return;
        }
        if (o instanceof SynchronizedMap) {
          d.append("sync ");
          {
            structure_1(((SynchronizedMap) o).m, d);
            return;
          }
        }
        if (o instanceof Map && !startsWith(name, d.mcDollar)) {
          if (o instanceof LinkedHashMap)
            d.append("lhm");
          else if (o instanceof HashMap)
            d.append("hm");
          else if (o instanceof TreeMap)
            d.append(isCIMap_gen((TreeMap) o) ? "cimap" : "tm");
          else if (name.equals("java.util.Collections$SynchronizedMap") || name.equals("java.util.Collections$SynchronizedSortedMap") || name.equals("java.util.Collections$SynchronizedNavigableMap")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedMap(((Map) o)), d);
              return;
            }
          }
          d.append("{");
          final int l = d.n;
          final Iterator it = cloneMap((Map) o).entrySet().iterator();
          d.stack.add(new Runnable() {

            public boolean v = false;

            public Map.Entry e;

            public void run() {
              if (v) {
                d.append("=");
                v = false;
                d.stack.add(this);
                structure_1(e.getValue(), d);
              } else {
                if (!it.hasNext())
                  d.append("}");
                else {
                  e = (Map.Entry) it.next();
                  v = true;
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(e.getKey(), d);
                }
              }
            }
          });
          return;
        }
        if (c.isArray()) {
          if (o instanceof byte[]) {
            d.append("ba ").append(quote(bytesToHex((byte[]) o)));
            return;
          }
          final int n = Array.getLength(o);
          if (o instanceof boolean[]) {
            String hex = boolArrayToHex((boolean[]) o);
            int i = l(hex);
            while (i > 0 && hex.charAt(i - 1) == '0' && hex.charAt(i - 2) == '0') i -= 2;
            d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i)));
            return;
          }
          String atype = "array";
          if (o instanceof int[]) {
            atype = "intarray";
          } else if (o instanceof double[]) {
            atype = "dblarray";
          } else {
            Pair<Class, Integer> p = arrayTypeAndDimensions(c);
            if (p.a == int.class)
              atype = "intarray";
            else if (p.a == byte.class)
              atype = "bytearray";
            else if (p.a == boolean.class)
              atype = "boolarray";
            else if (p.a == double.class)
              atype = "dblarray";
            else if (p.a == String.class) {
              atype = "array S";
              d.n++;
            } else
              atype = "array";
            if (p.b > 1) {
              atype += "/" + p.b;
              d.n += 2;
            }
          }
          d.append(atype).append("{");
          d.stack.add(new Runnable() {

            public int i;

            public void run() {
              if (i >= n)
                d.append("}");
              else {
                d.stack.add(this);
                if (i > 0)
                  d.append(", ");
                structure_1(Array.get(o, i++), d);
              }
            }
          });
          return;
        }
        if (o instanceof Class) {
          d.append("class(", 2).append(quote(((Class) o).getName())).append(")");
          return;
        }
        if (o instanceof Throwable) {
          d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")");
          return;
        }
        if (o instanceof BitSet) {
          BitSet bs = (BitSet) o;
          d.append("bitset{", 2);
          int l = d.n;
          for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i + 1)) {
            if (d.n != l)
              d.append(", ");
            d.append(i);
          }
          d.append("}");
          return;
        }
        if (info.javafy) {
          d.append("j ").append(quote(str(o)));
          return;
        }
        if (info.special) {
          if (c.isEnum()) {
            d.append("enum ");
            d.append(info.shortName);
            d.out.append(' ');
            d.append(((Enum) o).ordinal());
            return;
          }
          if (info.customSerializer != null) {
            Object o2 = invokeMethod(info.customSerializer, o);
            if (o2 == o) {
            } else {
              d.append("cu ");
              String shortName = dropPrefix(d.mcDollar, name);
              d.append(shortName);
              d.out.append(' ');
              structure_1(o2, d);
              return;
            }
          } else if (info.nullInstances) {
            d.append("null");
            return;
          } else if (info.serializeObject != null) {
            info.serializeObject.get(o);
            return;
          } else
            throw fail("unknown special type");
        }
        String dynName = shortDynClassNameForStructure(o);
        if (concept && !d.concepts.contains(dynName)) {
          d.concepts.add(dynName);
          d.append("c ");
        }
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {

          public int compare(Field a, Field b) {
            return stdcompare(a.getName(), b.getName());
          }
        });
        Class cc = c;
        while (cc != Object.class) {
          for (Field field : getDeclaredFields_cached(cc)) {
            if (!d.shouldIncludeField(field))
              continue;
            String fieldName = field.getName();
            if (fieldName.equals("_persistenceInfo"))
              d.persistenceInfo.put(c, obj -> (Map) fieldGet(field, obj));
            if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
              continue;
            fields.add(field);
          }
          cc = cc.getSuperclass();
        }
        Method persistenceInfoMethod = findInstanceMethod(c, "_persistenceInfo");
        if (persistenceInfoMethod != null)
          d.persistenceInfo.put(c, obj -> (Map) invokeMethod(persistenceInfoMethod, obj));
        lFields = asList(d.honorFieldOrder ? fieldObjectsInFieldOrder(c, fields) : fields);
        int n = l(lFields);
        for (int i = 0; i < n; i++) {
          Field f = lFields.get(i);
          if (f.getName().startsWith("this$")) {
            lFields.remove(i);
            lFields.add(0, f);
            break;
          }
        }
        d.setFields(info, lFields);
      } else {
        Integer ref = d.seen.get(o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        d.seen.put(o, d.n);
      }
      IF1<Object, Map> piGetter = d.persistenceInfo.get(c);
      Map persistenceInfo = piGetter == null ? null : piGetter.get(o);
      if (piGetter == null && o instanceof DynamicObject)
        persistenceInfo = (Map) getOptDynOnly(((DynamicObject) o), "_persistenceInfo");
      LinkedHashMap<String, Object> fv = new LinkedHashMap();
      Object defaultInstance = info.emptyInstance;
      for (Field f : lFields) {
        Object value, defaultValue = null;
        try {
          value = f.get(o);
          defaultValue = defaultInstance == null ? null : f.get(defaultInstance);
        } catch (Exception e) {
          value = "?";
        }
        if (!eq(defaultValue, value) && (persistenceInfo == null || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
          fv.put(f.getName(), value);
      }
      String shortName = info.shortName;
      if (concept && eq(fv.get("className"), shortName))
        fv.remove("className");
      if (o instanceof DynamicObject) {
        putAll(fv, (Map) fv.get("fieldValues"));
        fv.remove("fieldValues");
        if (((DynamicObject) o).className != null) {
          shortName = shortDynClassNameForStructure((DynamicObject) o);
          fv.remove("className");
        }
      }
      d.writeObject(o, shortName, fv);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public void swing(Runnable f) {
    swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  volatile static public boolean conceptsAndBot_running = false;

  static public boolean conceptsAndBot_thinOnStart = true;

  static public void conceptsAndBot() {
    conceptsAndBot(null);
  }

  static public void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    Concepts cc = db_mainConcepts();
    cc.programID = getDBProgramID();
    try {
      if (cc.useFileLock) {
        if (!cc.fileLock().tryToLock()) {
          ensureDBNotRunning(dbBotStandardName());
          cc.fileLock().forceLock();
        }
      } else
        ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable e) {
      printStackTrace(e);
      cc.dontSave = true;
      throw rethrow(e);
    }
    cc.persist(autoSaveInterval);
    dbBot(false);
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public Object fieldGet(Field f, Object o) {
    try {
      return f == null ? null : f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isTrueOrYes(Object o) {
    return isTrueOpt(o) || o instanceof String && (eqicOneOf(((String) o), "1", "t", "true") || isYes(((String) o)));
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    dynamicObject_setRawFieldValue(o, field, value);
  }

  static public void metaMapPut(IMeta o, Object key, Object value) {
    {
      if (o != null)
        o.metaPut(key, value);
    }
  }

  static public void metaMapPut(Object o, Object key, Object value) {
    var meta = initIMeta(o);
    {
      if (meta != null)
        meta.metaPut(key, value);
    }
  }

  static public String getClientIPFromHeaders(Map<String, String> headers) {
    if (headers == null)
      return null;
    String remoteAddr = (String) (headers.get("remote-addr"));
    String client = (String) (headers.get("x-forwarded-for"));
    if (nempty(client))
      remoteAddr += "," + client;
    return remoteAddr;
  }

  static public File getSecretProgramDir() {
    return getSecretProgramDir(actualProgramID());
  }

  static public File getSecretProgramDir(String snippetID) {
    if (empty(snippetID))
      return javaxSecretDir();
    return newFile(javaxSecretDir(), formatSnippetID(snippetID));
  }

  static public int globalIDLength() {
    return 16;
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> IterableIterator<A> enumerationToIterator(final Enumeration<A> e) {
    return e == null ? null : new IterableIterator() {

      public boolean hasNext() {
        return e.hasMoreElements();
      }

      public A next() {
        return e.nextElement();
      }
    };
  }

  static public <A> List<A> reversedList(Iterable<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public String reversedString(String s) {
    return reverseString(s);
  }

  static public long collectMinLong(Collection c, String field) {
    long x = Long.MAX_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = min(x, l);
    }
    return x;
  }

  static public long collectMaxLong(Collection c, String field) {
    long x = Long.MIN_VALUE;
    for (Object o : unnull(c)) {
      Long l = (Long) (getOpt(o, field));
      if (l != null)
        x = max(x, (long) l);
    }
    return x;
  }

  static public String i(String s, Object... params) {
    return tag("i", s, params);
  }

  static public String formatDateAndTime(long timestamp) {
    return formatDate(timestamp);
  }

  static public String formatDateAndTime() {
    return formatDate();
  }

  static public String shortenEndTime(String endTime, String startTime) {
    int i = endTime.lastIndexOf(' ') + 1;
    if (i > 0 && eq(substring(startTime, 0, i), substring(endTime, 0, i)))
      return trim(substring(endTime, i));
    return endTime;
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public String stringPar(Object[] params, String name) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Object[] params) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Map params) {
    return (String) optPar(name, params);
  }

  static public String stringPar(String name, Object[] params, String defaultValue) {
    return optPar(name, params, defaultValue);
  }

  static public Object leftArrow(String script) {
    GazelleV_LeftArrowScriptParser parser = new GazelleV_LeftArrowScriptParser();
    parser.allowTheWorld();
    return parser.parse(script).get();
  }

  static public String unicode_leftPointingTriangle() {
    return unicodeFromCodePoint(0x25C2);
  }

  static public String unicode_rightPointingTriangle() {
    return charToString(0x25B8);
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public double abs(Complex c) {
    return c.abs();
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public Collection<Concept> findConceptsWhere(String c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    ping();
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFields(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConcepts(concepts.list(c), params);
  }

  static public Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
    return filterConcepts(concepts.list(c), params);
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean md5OfFile_verbose = false;

  static public String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  static public String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (vm_generalMap()) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    return con.getInputStream();
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public byte[] utf8(String s) {
    return toUtf8(s);
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public Matcher regexpMatcher(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static public String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  static public String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  static public List<String> htmlcoarsetok(String s) {
    List<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      while (j < l) {
        if (s.charAt(j) != '<')
          ++j;
        else if (s.substring(j, Math.min(j + 4, l)).equals("<!--")) {
          j = j + 3;
          do ++j; while (j < l && !s.substring(j, Math.min(j + 3, l)).equals("-->"));
          j = Math.min(j + 3, l);
        } else {
          char d = charAt(s, j + 1);
          if (d == '/' || isLetter(d))
            break;
          else
            ++j;
        }
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '<') {
        ++j;
        while (j < l && s.charAt(j) != '>') ++j;
        if (j < l)
          ++j;
      }
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() & 1) == 0)
      tok.add("");
    return tok;
  }

  static public List<List<String>> findContainerTag(List<String> tok, String tag) {
    List<List<String>> l = new ArrayList();
    for (int i = 1; i < l(tok); i += 2) if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i + 2; j < tok.size(); j += 2) if (isOpeningTag(tok.get(j), tag))
        ++level;
      else if (isTag(tok.get(j), "/" + tag)) {
        --level;
        if (level == 0) {
          l.add(subList(tok, i - 1, j + 2));
          break;
        }
      }
      i = j;
    }
    return l;
  }

  static public List<List<String>> findContainerTag(String html, String tag) {
    return findContainerTag(htmlTok(html), tag);
  }

  static public List<String> replaceSubList(List<String> l, List<String> x, List<String> y) {
    return replaceSublist(l, x, y);
  }

  static public <A> List<A> replaceSubList(List<A> l, int fromIndex, int toIndex, List<A> y) {
    return replaceSublist(l, fromIndex, toIndex, y);
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public boolean isAbsoluteURL(String s) {
    return isURL(s);
  }

  static public boolean isRelativeURL(String s) {
    return startsWithOneOf(s, "/", "./", "../");
  }

  static public Object callMainBot(String method, Object... args) {
    return call(mainBot(), method, args);
  }

  static public String snippetImageLink(String snippetID) {
    return snippetImageURL(snippetID);
  }

  static public String dataURL(String mimeType, byte[] data) {
    return "data:" + mimeType + ";base64," + base64(data);
  }

  static public String jpegMimeType() {
    return "image/jpeg";
  }

  static public byte[] toJPEG(BufferedImage img) {
    try {
      ByteArrayOutputStream stream = new ByteArrayOutputStream();
      ImageIO.write(dropAlphaChannelFromBufferedImage(img), "jpeg", stream);
      return stream.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] toJPEG(File f) {
    return toJPEG(loadImage2(f));
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    return linesFromFile(f, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f, IResourceHolder resourceHolder) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)), resourceHolder);
      return linesFromReader(utf8bufferedReader(f), resourceHolder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(path, null);
  }

  static public CloseableIterableIterator<String> linesFromFile(String path, IResourceHolder resourceHolder) {
    return linesFromFile(newFile(path), resourceHolder);
  }

  static public Random defaultRandomGenerator() {
    {
      Random r = customRandomizerForThisThread();
      if (r != null)
        return r;
    }
    return ThreadLocalRandom.current();
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public SimpleDateFormat simpleDateFormat_timeZone(String format, String timeZone) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(timeZone(timeZone));
    return sdf;
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public Object[] html_massageAutofocusParam(Object[] params) {
    Object autofocus = optPar("autofocus", params);
    return changeParam(params, "autofocus", eqOneOf(autofocus, html_valueLessParam(), true, 1, "1", "autofocus") ? html_valueLessParam() : null);
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public <A, B> Map<A, B> mruCache(int maxSize) {
    return synchronizedMRUCache(maxSize);
  }

  static public long ipToInt(String ip) {
    Matches m = new Matches();
    assertTrue(jmatch("*.*.*.*", ip, m));
    return parseLong(m.unq(3)) | parseLong(m.unq(2)) << 8 | parseLong(m.unq(1)) << 16 | parseLong(m.unq(0)) << 24;
  }

  static public <A, B> B mapGetOrCreate(Map<A, B> map, A key, Class<? extends B> c) {
    return getOrCreate(map, key, c);
  }

  static public <A, B> B mapGetOrCreate(Map<A, B> map, A key, Object f) {
    return getOrCreate(map, key, f);
  }

  static public <A, B> B mapGetOrCreate(Map<A, B> map, A key, IF0<B> f) {
    return getOrCreate(map, key, (Object) f);
  }

  static public <A, B> B mapGetOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
    return getOrCreate(c, map, key);
  }

  static public boolean directoryEmpty(File f) {
    return directoryIsEmpty(f);
  }

  static public void unzipSnippet(String snippetID, File toDir) {
    print("Unzipping snippet " + snippetID + " to " + toDir);
    zip2dir(loadLibrary(snippetID), toDir);
  }

  static public <A, B> B pairB(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public Pair<LongRange, String> binarySearchForLineInTextFile(File file, IF1<String, Integer> nav) {
    long length = l(file);
    int bufSize = 1024;
    RandomAccessFile raf = randomAccessFileForReading(file);
    try {
      long min = 0, max = length;
      int direction = 0;
      Pair<LongRange, String> possibleResult = null;
      while (min < max) {
        ping();
        long middle = (min + max) / 2;
        long lineStart = raf_findBeginningOfLine(raf, middle, bufSize);
        long lineEnd = raf_findEndOfLine(raf, middle, bufSize);
        String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (lineEnd - 1 - lineStart)));
        direction = nav.get(line);
        possibleResult = pair(new LongRange(lineStart, lineEnd), line);
        if (direction == 0)
          return possibleResult;
        if (direction < 0)
          max = assertLessThan(max, lineStart);
        else
          min = assertBiggerThan(min, lineEnd);
      }
      if (direction >= 0)
        return possibleResult;
      long lineStart = raf_findBeginningOfLine(raf, min - 1, bufSize);
      String line = fromUtf8(raf_readFilePart(raf, lineStart, (int) (min - 1 - lineStart)));
      return pair(new LongRange(lineStart, min), line);
    } finally {
      _close(raf);
    }
  }

  static public List<String> tok_splitAtComma_unquote(String s) {
    List<String> tok = javaTok(s);
    List<String> out = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      int j = smartIndexOf(tok, ",", i);
      out.add(unquote(trimJoinSubList(tok, i, j)));
      i = j;
    }
    return out;
  }

  static public long parseLongOpt(String s) {
    return isInteger(s) ? parseLong(s) : 0;
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static public <A, B, C> MultiMap<B, C> mapMultiMapKeys(IF1<A, C> f, MultiMap<A, B> mm) {
    MultiMap m = similarEmptyMultiMap(mm);
    for (var key : keys(mm)) m.put(f.get(key), mm.get(key));
    return m;
  }

  static public <A, B, C> MultiMap<B, C> mapMultiMapKeys(MultiMap<A, B> mm, IF1<A, C> f) {
    return mapMultiMapKeys(f, mm);
  }

  static public <A, B, C> MultiSetMap<B, C> mapMultiSetMapKeys(IF1<A, C> f, MultiSetMap<A, B> mm) {
    MultiSetMap m = similarEmptyMultiSetMap(mm);
    for (var key : keys(mm)) m.put(f.get(key), mm.get(key));
    return m;
  }

  static public <A, B, C> MultiSetMap<B, C> mapMultiSetMapKeys(MultiSetMap<A, B> mm, IF1<A, C> f) {
    return mapMultiSetMapKeys(f, mm);
  }

  static public TreeMap litCIMap(Object... x) {
    TreeMap map = caseInsensitiveMap();
    litmap_impl(map, x);
    return map;
  }

  static public String regexReplaceIC(String s, String pat, Object f) {
    return regexReplace(regexpMatcherIC(pat, s), f);
  }

  static public String regexReplaceIC(String s, String pat, String replacement) {
    return regexpReplaceIC_direct(s, pat, replacement);
  }

  static public HashMap<String, List<Method>> callMC_cache = new HashMap();

  static public String callMC_key;

  static public Method callMC_value;

  static public Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  static public Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  static public Class javax() {
    return getJavaX();
  }

  static public <A> List<A> synchroList() {
    return synchroList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return new SynchronizedList(l);
  }

  static public Map synchroHashMap() {
    return synchronizedMap(new HashMap());
  }

  static public ClassLoader classLoaderForObject(Object o) {
    if (o instanceof ClassLoader)
      return ((ClassLoader) o);
    if (o == null)
      return null;
    return _getClass(o).getClassLoader();
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public List _registerWeakMap_preList;

  static public <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  static public void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public <A, B> Map<A, B> newWeakMap() {
    return newWeakHashMap();
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public Map<Object, Object> castMapToMapO(Map map) {
    return map;
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public String mainClassNameForClassLoader(ClassLoader cl) {
    return or((String) callOpt(cl, "mainClassName"), "main");
  }

  static public Class loadClassFromClassLoader_orNull(ClassLoader cl, String name) {
    try {
      return cl == null ? null : cl.loadClass(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Map paramsToMap(Object... params) {
    int n = l(params);
    if (l(params) == 1 && params[0] instanceof Map)
      return (Map) params[0];
    LinkedHashMap map = new LinkedHashMap();
    for (int i = 0; i + 1 < n; i += 2) mapPut(map, params[i], params[i + 1]);
    return map;
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(A[] l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, A[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = f.get(l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(IF1<A, Object> f, Collection<A> l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public String htmldecode(final String input) {
    if (input == null)
      return null;
    final int MIN_ESCAPE = 2;
    final int MAX_ESCAPE = 6;
    StringWriter writer = null;
    int len = input.length();
    int i = 1;
    int st = 0;
    while (true) {
      while (i < len && input.charAt(i - 1) != '&') i++;
      if (i >= len)
        break;
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';') j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
        i++;
        continue;
      }
      if (input.charAt(i) == '#') {
        int k = i + 1;
        int radix = 10;
        final char firstChar = input.charAt(k);
        if (firstChar == 'x' || firstChar == 'X') {
          k++;
          radix = 16;
        }
        try {
          int entityValue = Integer.parseInt(input.substring(k, j), radix);
          if (writer == null)
            writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));
          if (entityValue > 0xFFFF) {
            final char[] chrs = Character.toChars(entityValue);
            writer.write(chrs[0]);
            writer.write(chrs[1]);
          } else {
            writer.write(entityValue);
          }
        } catch (NumberFormatException ex) {
          i++;
          continue;
        }
      } else {
        CharSequence value = htmldecode_lookupMap().get(input.substring(i, j));
        if (value == null) {
          i++;
          continue;
        }
        if (writer == null)
          writer = new StringWriter(input.length());
        writer.append(input.substring(st, i - 1));
        writer.append(value);
      }
      st = j + 1;
      i = st;
    }
    if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
    }
    return input;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_cache;

  static public HashMap<String, CharSequence> htmldecode_lookupMap() {
    if (htmldecode_lookupMap_cache == null)
      htmldecode_lookupMap_cache = htmldecode_lookupMap_load();
    return htmldecode_lookupMap_cache;
  }

  static public HashMap<String, CharSequence> htmldecode_lookupMap_load() {
    var map = new HashMap<String, CharSequence>();
    for (CharSequence[] seq : htmldecode_escapes()) map.put(seq[1].toString(), seq[0]);
    return map;
  }

  static public List<String> dropAllTags(List<String> tok) {
    List<String> list = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && t.startsWith("<")) {
        list.set(list.size() - 1, list.get(list.size() - 1) + tok.get(i + 1));
        ++i;
      } else
        list.add(t);
    }
    return list;
  }

  static public String dropAllTags(String html) {
    if (!contains(html, '<'))
      return html;
    return join(dropAllTags(htmlcoarsetok(html)));
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL;

  static public x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL() {
    if (newPing_actionTL == null)
      newPing_actionTL = vm_generalMap_getOrCreate("newPing_actionTL", () -> {
        Runnable value = (Runnable) (callF_gen(vm_generalMap_get("newPing_valueForNewThread")));
        var tl = new x30_pkg.x30_util.BetterThreadLocal<Runnable>();
        tl.set(value);
        return tl;
      });
    return newPing_actionTL;
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public <A, B, C extends Map<A, B>> C syncMapRemove_deleteMapIfEmpty(C map, A key) {
    if (map != null && key != null)
      synchronized (collectionMutex(map)) {
        map.remove(key);
        if (map.isEmpty())
          return null;
      }
    return map;
  }

  static public boolean isInAnonymousClass(Object o) {
    if (o == null)
      return false;
    return isAnonymousClassName(className(o));
  }

  static public int compareIgnoreCase_jdk(String s1, String s2) {
    if (s1 == null)
      return s2 == null ? 0 : -1;
    if (s2 == null)
      return 1;
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
      char c1 = s1.charAt(i);
      char c2 = s2.charAt(i);
      if (c1 != c2) {
        c1 = Character.toUpperCase(c1);
        c2 = Character.toUpperCase(c2);
        if (c1 != c2) {
          c1 = Character.toLowerCase(c1);
          c2 = Character.toLowerCase(c2);
          if (c1 != c2)
            return c1 - c2;
        }
      }
    }
    return n1 - n2;
  }

  static public <A> A[] singlePlusArray(A a, A[] l) {
    A[] out = newObjectArrayOfSameType(l, l(l) + 1);
    out[0] = a;
    arraycopy(l, 0, out, 1, l(l));
    return out;
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public Throwable _storeException_value;

  static public void _storeException(Throwable e) {
    _storeException_value = e;
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public Map syncHashMap() {
    return synchroHashMap();
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
  }

  static public boolean regionMatches(String a, int offsetA, String b) {
    return regionMatches(a, offsetA, b, 0, l(b));
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return null;
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, int destPos, int n) {
    arraycopy(src, srcPos, src, destPos, n);
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public List map_ping(Iterable l, Object f) {
    return map_ping(f, l);
  }

  static public List map_ping(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map_ping(Iterable<A> l, F1<A, B> f) {
    return map_ping(f, l);
  }

  static public <A, B> List<B> map_ping(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map_ping(IF1<A, B> f, Iterable<A> l) {
    return map_ping(l, f);
  }

  static public <A, B> List<B> map_ping(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public <A, B> List<B> map_ping(IF1<A, B> f, A[] l) {
    return map_ping(l, f);
  }

  static public <A, B> List<B> map_ping(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) {
        ping();
        x.add(f.get(o));
      }
    return x;
  }

  static public List map_ping(Object f, Object[] l) {
    return map_ping(f, asList(l));
  }

  static public List map_ping(Object[] l, Object f) {
    return map_ping(f, l);
  }

  static public List map_ping(Object f, Map map) {
    return map_ping(map, f);
  }

  static public List map_ping(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        ping();
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map_ping(Map<A, B> map, IF2<A, B, C> f) {
    return map_ping(map, (Object) f);
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  static public File standardLogFile() {
    return getProgramFile("log");
  }

  static public void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  static public void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  static public File prepareProgramFile(String name) {
    return mkdirsForFile(getProgramFile(name));
  }

  static public File prepareProgramFile(String progID, String name) {
    return mkdirsForFile(getProgramFile(progID, name));
  }

  static public ThreadLocal<Boolean> htmlencode_forParams_useV2 = new ThreadLocal();

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    if (isTrue(htmlencode_forParams_useV2.get()))
      return htmlencode_forParams_v2(s);
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  static public <A> A getWeakRef(Reference<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl;

  static public x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl() {
    if (dm_current_generic_tl == null)
      dm_current_generic_tl = vm_generalMap_getOrCreate("currentModule", () -> new x30_pkg.x30_util.BetterThreadLocal());
    return dm_current_generic_tl;
  }

  static public List<VF1<Map>> _threadInfo_makers = synchroList();

  static public Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  static public List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  static public void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  static public Runnable rPcall(Runnable r) {
    return r == null ? null : () -> {
      try {
        r.run();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    };
  }

  static public Object jsonDecode(String text) {
    return new jsonDecode_Y(text).parse();
  }

  static public class jsonDecode_Y {

    public String text;

    public List<String> tok;

    public boolean useOrderedMaps = false;

    public int i = 1;

    public jsonDecode_Y(String text) {
      this.text = text;
      tok = jsonTok(text);
    }

    transient public IF1<String, RuntimeException> fail;

    public RuntimeException fail(String msg) {
      return fail != null ? fail.get(msg) : fail_base(msg);
    }

    final public RuntimeException fail_fallback(IF1<String, RuntimeException> _f, String msg) {
      return _f != null ? _f.get(msg) : fail_base(msg);
    }

    public RuntimeException fail_base(String msg) {
      return main.fail(msg);
    }

    public Object parse() {
      if (l(tok) == 1)
        return null;
      return parseExpr();
    }

    public Object parseExpr() {
      String t = tok.get(i);
      if (t.startsWith("\"") || t.startsWith("'")) {
        String s = unquote(tok.get(i));
        i += 2;
        return s;
      }
      if (t.equals("{"))
        return parseMap();
      if (t.equals("["))
        return this.parseList();
      if (t.equals("null")) {
        i += 2;
        return null;
      }
      if (t.equals("false")) {
        i += 2;
        return false;
      }
      if (t.equals("true")) {
        i += 2;
        return true;
      }
      boolean minus = false;
      if (t.equals("-")) {
        minus = true;
        i += 2;
        t = get(tok, i);
      }
      if (isInteger(t)) {
        int j = i;
        i += 2;
        if (eqOneOf(get(tok, i), ".", "e", "E")) {
          while (isInteger(get(tok, i)) || eqOneOf(get(tok, i), ".", "e", "E", "-")) i += 2;
          double d = parseDouble(joinSubList(tok, j, i - 1));
          if (minus)
            d = -d;
          return d;
        } else {
          long l = parseLong(t);
          return boxedIntOrLong(minus ? -l : l);
        }
      }
      throw fail("Unknown token " + (i + 1) + ": " + t + ": " + text);
    }

    public Object parseList() {
      consume("[");
      List list = new ArrayList();
      while (!tok.get(i).equals("]")) {
        list.add(parseExpr());
        if (tok.get(i).equals(","))
          i += 2;
      }
      consume("]");
      return list;
    }

    public Object parseMap() {
      consume("{");
      Map map = useOrderedMaps ? new LinkedHashMap() : new TreeMap();
      while (!tok.get(i).equals("}")) {
        String key = unquote(tok.get(i));
        i += 2;
        consume(":");
        Object value = parseExpr();
        map.put(key, value);
        if (tok.get(i).equals(","))
          i += 2;
      }
      consume("}");
      return map;
    }

    public void consume(String s) {
      if (!tok.get(i).equals(s)) {
        String prevToken = i - 2 >= 0 ? tok.get(i - 2) : "";
        String nextTokens = join(tok.subList(i, Math.min(i + 4, tok.size())));
        throw fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");
      }
      i += 2;
    }
  }

  static public Map<String, java.util.regex.Pattern> compileRegexpIC_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexpIC(String pat) {
    java.util.regex.Pattern p = compileRegexpIC_cache.get(pat);
    if (p == null) {
      try {
        compileRegexpIC_cache.put(pat, p = java.util.regex.Pattern.compile(pat, Pattern.CASE_INSENSITIVE));
      } catch (PatternSyntaxException e) {
        throw rethrow(wrapPatternSyntaxException(e));
      }
    }
    return p;
  }

  static public boolean startsWithLetterOrDigit(String s) {
    return nempty(s) && Character.isLetterOrDigit(s.charAt(0));
  }

  static public String regexpQuote(String s) {
    return s.length() == 0 ? "" : Pattern.quote(s);
  }

  static public boolean tok_isRoundBracketed(String s) {
    List<String> tok = tok_combineRoundBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "(", ")");
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public List<String> javaTokPlusBrackets(String s) {
    return tok_combineRoundOrCurlyBrackets_keep(javaTok(s));
  }

  static public Map<String, List<String>> javaTokWithAllBrackets_cached_cache = synchronizedMRUCache(defaultTokenizerCacheSize());

  static public List<String> javaTokWithAllBrackets_cached(String s) {
    List<String> tok = javaTokWithAllBrackets_cached_cache.get(s);
    if (tok == null)
      javaTokWithAllBrackets_cached_cache.put(s, tok = javaTokWithAllBrackets(s));
    return tok;
  }

  static public List<String> splitAtTokens(String s, List<String> tokens) {
    return splitAtTokens(javaTok(s), tokens);
  }

  static public List<String> splitAtTokens(List<String> tok, List<String> tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public List<String> splitAtTokens(List<String> tok, String... tokens) {
    List<String> l = new ArrayList();
    int i = 0;
    while (i < l(tok)) {
      int j = indexOfSubList(tok, tokens, i);
      if (i >= l(tok))
        break;
      if (j < 0)
        j = l(tok);
      l.add(trimJoin(tok.subList(i, j)));
      i = j + l(tokens);
    }
    return l;
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  static public <A extends Component> A revalidate(final A c) {
    if (c == null || !c.isShowing())
      return c;
    {
      swing(() -> {
        c.revalidate();
        c.repaint();
      });
    }
    return c;
  }

  static public void revalidate(JFrame f) {
    revalidate((Component) f);
  }

  static public void revalidate(JInternalFrame f) {
    revalidate((Component) f);
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public <A> A assertEquals(Object x, A y) {
    return assertEquals("", x, y);
  }

  static public <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public String actualMCDollar() {
    return actualMC().getName() + "$";
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public boolean isSyntheticOrAnonymous(Class c) {
    return c != null && (c.isSynthetic() || isAnonymousClassName(c.getName()));
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public String shortDynClassNameForStructure(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return name.startsWith("dyn.") ? classNameToVM(name) : shortenClassName(name);
  }

  static public boolean isPersistableClass(Class c) {
    String name = c.getName();
    if (isSubtypeOf(c, TransientObject.class))
      return false;
    if (isAnonymousClassName(name))
      return false;
    if (isBoxedType(c))
      return true;
    if (isArrayType(c))
      return true;
    if (c == Class.class || c == String.class || c == File.class || c == Color.class)
      return true;
    if (name.startsWith("java.util.Collections$Synchronized"))
      return true;
    if (hasThisDollarFields(c))
      return hasSingleArgumentConstructor(c);
    else
      return getDefaultConstructor(c) != null;
  }

  static public Constructor getDefaultConstructor(Class c) {
    if (c != null)
      for (Constructor m : getDeclaredConstructors_cached(c)) if (empty(m.getParameterTypes()))
        return m;
    return null;
  }

  static public Object invokeConstructor(Constructor m, Object... args) {
    try {
      makeAccessible(m);
      return m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int countDots(String s) {
    int n = l(s), count = 0;
    for (int i = 0; i < n; i++) if (s.charAt(i) == '.')
      ++count;
    return count;
  }

  static public void quoteToPrintWriter(String s, PrintWriter out) {
    if (s == null) {
      out.print("null");
      return;
    }
    out.print('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"') {
        out.print('\\');
        out.print(c);
      } else if (c == '\r')
        out.print("\\r");
      else if (c == '\n')
        out.print("\\n");
      else if (c == '\0')
        out.print("\\0");
      else
        out.print(c);
    }
    out.print('"');
  }

  static public String quoteCharacter(char c) {
    if (c == '\'')
      return "'\\''";
    if (c == '\\')
      return "'\\\\'";
    if (c == '\r')
      return "'\\r'";
    if (c == '\n')
      return "'\\n'";
    if (c == '\t')
      return "'\\t'";
    return "'" + c + "'";
  }

  static public boolean isCISet_gen(Iterable<String> l) {
    return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
  }

  static public boolean isJavaXClassName(String s) {
    return startsWithOneOf(s, "main$", "loadableUtils.");
  }

  static public <A> List<A> unwrapSynchronizedList(List<A> l) {
    if (l instanceof SynchronizedList)
      return ((SynchronizedList) l).list;
    if (eqOneOf(className(l), "java.util.Collections$SynchronizedList", "java.util.Collections$SynchronizedRandomAccessList"))
      return (List) get_raw(l, "list");
    return l;
  }

  static public boolean isCIMap_gen(Map map) {
    return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
  }

  static public <A, B> Map<A, B> unwrapSynchronizedMap(Map<A, B> map) {
    if (eqOneOf(shortClassName(map), "SynchronizedMap", "SynchronizedSortedMap", "SynchronizedNavigableMap"))
      return (Map) get_raw(map, "m");
    return map;
  }

  static public String boolArrayToHex(boolean[] a) {
    return bytesToHex(boolArrayToBytes(a));
  }

  static public Pair<Class, Integer> arrayTypeAndDimensions(Object o) {
    return arrayTypeAndDimensions(_getClass(o));
  }

  static public Pair<Class, Integer> arrayTypeAndDimensions(Class c) {
    if (c == null || !c.isArray())
      return null;
    Class elem = c.getComponentType();
    if (elem.isArray())
      return mapPairB(arrayTypeAndDimensions(elem), dim -> dim + 1);
    return pair(elem, 1);
  }

  static public Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

  static public Field[] getDeclaredFields_cached(Class c) {
    Field[] fields;
    synchronized (getDeclaredFields_cache) {
      fields = getDeclaredFields_cache.get(c);
      if (fields == null) {
        getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
        for (Field f : fields) makeAccessible(f);
      }
    }
    return fields;
  }

  static public Method findInstanceMethod(Class c, String method, Object... args) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method) && findMethod_checkArgs(m, args, false))
        return m;
      c = c.getSuperclass();
    }
    return null;
  }

  static public Set<Field> fieldObjectsInFieldOrder(Class c, Set<Field> fields) {
    try {
      var byName = mapToKey(f -> f.getName(), fields);
      LinkedHashSet<Field> out = new LinkedHashSet();
      for (String name : unnullForIteration(getFieldOrder(c))) {
        Field f = byName.get(name);
        if (f != null) {
          byName.remove(name);
          out.add(f);
        }
      }
      addAll(out, fields);
      return out;
    } catch (Throwable __0) {
      printStackTrace(__0);
      return fields;
    }
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  static public void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  static public String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  static volatile public Android3 dbBot_instance;

  static public Android3 dbBot() {
    return dbBot(true);
  }

  static public Android3 dbBot(boolean ensureNotRunning) {
    return dbBot(dbBotStandardName(), ensureNotRunning);
  }

  static public Android3 dbBot(String name) {
    return dbBot(name, true);
  }

  static public Android3 dbBot(String name, boolean ensureNotRunning) {
    if (ensureNotRunning)
      ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  static public void thinAProgramsBackups(String progID, boolean doIt) {
    File dir = programDir(progID);
    thinAProgramsBackups(dir, doIt);
  }

  static public void thinAProgramsBackups(File dir, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)(\\d*)$");
    print("Processing backups in " + dir);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      java.util.regex.Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      int minute = matcherInt(matcher, 6);
      long time = timestampFromYMDHM(year, month, day, hour, minute);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  static public boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  static public boolean isTrueOpt(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    return false;
  }

  static public boolean isTrueOpt(String field, Object o) {
    return isTrueOpt(getOpt(field, o));
  }

  static public List<String> isYes_yesses = litlist("y", "yes", "yeah", "y", "yup", "yo", "corect", "sure", "ok", "afirmative");

  static public boolean isYes(String s) {
    return isYes_yesses.contains(collapseWord(toLowerCase(firstWord2(s))));
  }

  static public IMeta initIMeta(Object o) {
    if (o == null)
      return null;
    if (o instanceof IMeta)
      return ((IMeta) o);
    if (o instanceof JComponent)
      return initMetaOfJComponent((JComponent) o);
    if (o instanceof BufferedImage)
      return optCast(IMeta.class, ((BufferedImage) o).getProperty("meta"));
    return null;
  }

  static public String actualProgramID() {
    return programID();
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String reverseString(String s) {
    return empty(s) ? s : new StringBuilder(s).reverse().toString();
  }

  static public String stringOptPar(Object[] params, String name) {
    return (String) optPar(params, name);
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public Object[] dropEntryFromParams(Object[] params, int i) {
    int n = l(params);
    if (i < 0 || i >= n)
      return params;
    if (n == 2)
      return null;
    Object[] p = new Object[n - 2];
    System.arraycopy(params, 0, p, 0, i);
    System.arraycopy(params, i + 2, p, i, n - i - 2);
    return p;
  }

  static public <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
    if (empty(params))
      return list;
    List<A> l = new ArrayList();
    for (A x : list) if (checkConceptFields(x, params))
      l.add(x);
    return l;
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    return oneOfTheFiles(asList(files));
  }

  static public File oneOfTheFiles(Iterable<File> files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static volatile public Object isAllowed_function;

  static volatile public boolean isAllowed_all = true;

  static public boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static public String hmsWithColons() {
    return hmsWithColons(now());
  }

  static public String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public boolean isOpeningTag(String token, String tag) {
    return isTag(token, tag) && !token.endsWith("/>");
  }

  static public boolean isOpeningTag(String token) {
    return token.startsWith("<") && token.endsWith(">") && !token.endsWith("/>") && isLetter(token.charAt(1));
  }

  static public boolean isTag(String token, String tag) {
    return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length() + 2) || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length() + 2);
  }

  static public List<String> htmlTok(String s) {
    return htmlcoarsetok(s);
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public String base64(byte[] a) {
    return base64encode(a);
  }

  static public BufferedImage dropAlphaChannelFromBufferedImage(BufferedImage img) {
    if (img == null || img.getType() == BufferedImage.TYPE_INT_RGB)
      return img;
    int w = img.getWidth(), h = img.getHeight();
    BufferedImage newImage = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
    int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
    newImage.setRGB(0, 0, w, h, rgb, 0, w);
    return newImage;
  }

  static public BufferedImage loadImage2(String snippetIDOrURL) {
    return loadBufferedImage(snippetIDOrURL);
  }

  static public BufferedImage loadImage2(File file) {
    return loadBufferedImage(file);
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    return linesFromReader(r, null);
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r, IResourceHolder resourceHolder) {
    final BufferedReader br = bufferedReader(r);
    return holdResource(resourceHolder, iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "return readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r)));
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return in == null ? null : bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Random customRandomizerForThisThread() {
    return customRandomizerForThisThread_tl().get();
  }

  static public Object[] changeParam(Object[] params, String name, Object value) {
    if (eq(optPar(params, name), value))
      return params;
    Map map = paramsToOrderedMap(params);
    map.put(name, value);
    return mapToParams(map);
  }

  static public Object cget(Object c, String field) {
    c = derefRef(c);
    Object o = getOpt(c, field);
    return derefRef(o);
  }

  static public Object cget(String field, Object c) {
    return cget(c, field);
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, Class<? extends B> c) {
    try {
      B b = map.get(key);
      if (b == null)
        map.put(key, b = c.newInstance());
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, Object f) {
    try {
      B b = map.get(key);
      if (b == null)
        map.put(key, b = (B) callF(f));
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> B getOrCreate(IF0<B> f, Map<A, B> map, A key) {
    return getOrCreate(map, key, f);
  }

  static public <A, B> B getOrCreate(Map<A, B> map, A key, IF0<B> f) {
    B b = map.get(key);
    if (b == null)
      map.put(key, b = f.get());
    return b;
  }

  static public <A, B> B getOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
    return getOrCreate(map, key, c);
  }

  static public boolean directoryIsEmpty(File f) {
    return !fileExists(f) || isDirectory(f) && empty(listFiles(f));
  }

  static public void zip2dir(File inZip, String outDir) {
    zip2dir(inZip, newFile(outDir));
  }

  static public void zip2dir(File inZip, File outDir) {
    zip2dir(inZip, outDir, "");
  }

  static public void zip2dir(File inZip, String outDir, String prefix) {
    zip2dir(inZip, newFile(outDir), prefix);
  }

  static public void zip2dir(File inZip, File outDir, String prefix) {
    try {
      if (prefix.length() != 0 && !prefix.endsWith("/"))
        prefix += "/";
      ZipFile zipFile = new ZipFile(inZip);
      try {
        Enumeration entries = zipFile.entries();
        while (entries.hasMoreElements()) {
          ZipEntry entry = (ZipEntry) entries.nextElement();
          if (entry.isDirectory())
            continue;
          if (!entry.getName().startsWith(prefix))
            continue;
          File outFile = new File(outDir, entry.getName());
          print("Unzipping " + entry.getName() + " to " + outFile.getAbsolutePath());
          stream2file(zipFile.getInputStream(entry), outFile);
        }
      } finally {
        _close(zipFile);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public RandomAccessFile randomAccessFileForReading(File path) {
    try {
      return newRandomAccessFile(path, "r");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long raf_findBeginningOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      while (pos > 0) {
        long start = Math.max(pos - bufSize, 0);
        raf.seek(start);
        raf.readFully(buf, 0, (int) Math.min(pos - start, bufSize));
        int idx = lastIndexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return start + idx + 1;
        pos = start;
      }
      return 0;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long raf_findEndOfLine(RandomAccessFile raf, long pos, int bufSize) {
    try {
      byte[] buf = new byte[bufSize];
      long length = raf.length();
      while (pos < length) {
        raf.seek(pos);
        raf.readFully(buf, 0, (int) Math.min(length - pos, bufSize));
        int idx = indexOf_byteArray(buf, (byte) '\n');
        if (idx >= 0)
          return pos + idx + 1;
        pos += bufSize;
      }
      return length;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] raf_readFilePart(RandomAccessFile raf, long start, int l) {
    try {
      byte[] buf = new byte[l];
      raf.seek(start);
      raf.readFully(buf);
      return buf;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A assertLessThan(A a, A b) {
    assertTrue(cmp(b, a) < 0);
    return b;
  }

  static public <A> A assertBiggerThan(A a, A b) {
    assertTrue(cmp(b, a) > 0);
    return b;
  }

  static public String trimJoinSubList(List<String> l, int i, int j) {
    return trim(join(subList(l, i, j)));
  }

  static public String trimJoinSubList(List<String> l, int i) {
    return trim(join(subList(l, i)));
  }

  static public Object costCenter() {
    return mc();
  }

  static public MultiSetMap similarEmptyMultiSetMap(MultiSetMap m) {
    return similarEmptyMultiSetMap(m == null ? null : m.data);
  }

  static public MultiSetMap similarEmptyMultiSetMap(Map m) {
    MultiSetMap mm = new MultiSetMap();
    if (m != null)
      mm.data = similarEmptyMap(m);
    return mm;
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public String regexReplace(String s, String pat, Object f) {
    Matcher m = Pattern.compile(pat).matcher(s);
    return regexReplace(m, f);
  }

  static public String regexReplace(String s, String pat, String replacement) {
    return regexpReplace_direct(s, pat, replacement);
  }

  static public String regexReplace(Matcher m, Object f) {
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, m.quoteReplacement(str(callF(f, m))));
    m.appendTail(buf);
    return str(buf);
  }

  static public String regexReplace(String s, String pat, IF1<Matcher, String> f) {
    return regexReplace(s, pat, (Object) f);
  }

  static public String regexpReplaceIC_direct(String s, String pat, String replacement) {
    Matcher m = regexpIC(pat, s);
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, replacement);
    m.appendTail(buf);
    return str(buf);
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void __setJavaX(Class j) {
    __javax = j;
    _onJavaXSet();
  }

  static public Map synchronizedMap() {
    return synchroMap();
  }

  static public <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
    return synchroMap(map);
  }

  static public <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        name = replacePrefix("main$main$", "main$", name);
        Class c = get2(name);
        return c;
      }

      public Class get2(String name) {
        if (eq(name, "<main>"))
          return mc();
        {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
        }
        if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
          for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
            String newName = pkg + afterDollar(name);
            {
              Class c = findClass_fullName(newName);
              if (c != null)
                return c;
            }
          }
        return null;
      }
    };
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public Object[] toObjectArray(Collection c) {
    return toObjectArray((Iterable) c);
  }

  static public Object[] toObjectArray(Iterable c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public String[][] htmldecode_escapes() {
    return htmldecode_ESCAPES;
  }

  static final public String[][] htmldecode_ESCAPES = { { "\"", "quot" }, { "&", "amp" }, { "<", "lt" }, { ">", "gt" }, { "\u00A0", "nbsp" }, { "\u00A1", "iexcl" }, { "\u00A2", "cent" }, { "\u00A3", "pound" }, { "\u00A4", "curren" }, { "\u00A5", "yen" }, { "\u00A6", "brvbar" }, { "\u00A7", "sect" }, { "\u00A8", "uml" }, { "\u00A9", "copy" }, { "\u00AA", "ordf" }, { "\u00AB", "laquo" }, { "\u00AC", "not" }, { "\u00AD", "shy" }, { "\u00AE", "reg" }, { "\u00AF", "macr" }, { "\u00B0", "deg" }, { "\u00B1", "plusmn" }, { "\u00B2", "sup2" }, { "\u00B3", "sup3" }, { "\u00B4", "acute" }, { "\u00B5", "micro" }, { "\u00B6", "para" }, { "\u00B7", "middot" }, { "\u00B8", "cedil" }, { "\u00B9", "sup1" }, { "\u00BA", "ordm" }, { "\u00BB", "raquo" }, { "\u00BC", "frac14" }, { "\u00BD", "frac12" }, { "\u00BE", "frac34" }, { "\u00BF", "iquest" }, { "\u00C0", "Agrave" }, { "\u00C1", "Aacute" }, { "\u00C2", "Acirc" }, { "\u00C3", "Atilde" }, { "\u00C4", "Auml" }, { "\u00C5", "Aring" }, { "\u00C6", "AElig" }, { "\u00C7", "Ccedil" }, { "\u00C8", "Egrave" }, { "\u00C9", "Eacute" }, { "\u00CA", "Ecirc" }, { "\u00CB", "Euml" }, { "\u00CC", "Igrave" }, { "\u00CD", "Iacute" }, { "\u00CE", "Icirc" }, { "\u00CF", "Iuml" }, { "\u00D0", "ETH" }, { "\u00D1", "Ntilde" }, { "\u00D2", "Ograve" }, { "\u00D3", "Oacute" }, { "\u00D4", "Ocirc" }, { "\u00D5", "Otilde" }, { "\u00D6", "Ouml" }, { "\u00D7", "times" }, { "\u00D8", "Oslash" }, { "\u00D9", "Ugrave" }, { "\u00DA", "Uacute" }, { "\u00DB", "Ucirc" }, { "\u00DC", "Uuml" }, { "\u00DD", "Yacute" }, { "\u00DE", "THORN" }, { "\u00DF", "szlig" }, { "\u00E0", "agrave" }, { "\u00E1", "aacute" }, { "\u00E2", "acirc" }, { "\u00E3", "atilde" }, { "\u00E4", "auml" }, { "\u00E5", "aring" }, { "\u00E6", "aelig" }, { "\u00E7", "ccedil" }, { "\u00E8", "egrave" }, { "\u00E9", "eacute" }, { "\u00EA", "ecirc" }, { "\u00EB", "euml" }, { "\u00EC", "igrave" }, { "\u00ED", "iacute" }, { "\u00EE", "icirc" }, { "\u00EF", "iuml" }, { "\u00F0", "eth" }, { "\u00F1", "ntilde" }, { "\u00F2", "ograve" }, { "\u00F3", "oacute" }, { "\u00F4", "ocirc" }, { "\u00F5", "otilde" }, { "\u00F6", "ouml" }, { "\u00F7", "divide" }, { "\u00F8", "oslash" }, { "\u00F9", "ugrave" }, { "\u00FA", "uacute" }, { "\u00FB", "ucirc" }, { "\u00FC", "uuml" }, { "\u00FD", "yacute" }, { "\u00FE", "thorn" }, { "\u00FF", "yuml" }, { "\u2013", "ndash" }, { "\u2018", "lsquo" }, { "\u2019", "rsquo" }, { "\u201D", "rdquo" }, { "\u201C", "ldquo" }, { "\u2014", "mdash" }, { "'", "apos" } };

  static public <A> A vm_generalMap_getOrCreate(Object key, F0<A> create) {
    return vm_generalMap_getOrCreate(key, f0ToIF0(create));
  }

  static public <A> A vm_generalMap_getOrCreate(Object key, IF0<A> create) {
    Map generalMap = vm_generalMap();
    if (generalMap == null)
      return null;
    synchronized (generalMap) {
      A a = (A) (vm_generalMap_get(key));
      if (a == null)
        vm_generalMap_put(key, a = create == null ? null : create.get());
      return a;
    }
  }

  static public <A> A callF_gen(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF_gen(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF_gen(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B> B callF_gen(A a, IF1<A, B> f) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF_gen(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF_gen(VF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(A a, IVF1<A> f) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public <A> void callF_gen(IVF1<A> f, A a) {
    {
      if (f != null)
        f.get(a);
    }
  }

  static public Object callF_gen(Runnable r) {
    {
      if (r != null)
        r.run();
    }
    return null;
  }

  static public Object callF_gen(Object f, Object... args) {
    return callF(f, args);
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public Set<String> getPlural_specials = litciset("sheep", "fish");

  static public String getPlural(String s) {
    if (contains(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public boolean isAnonymousClassName(String s) {
    for (int i = 0; i < l(s); i++) if (s.charAt(i) == '$' && Character.isDigit(s.charAt(i + 1)))
      return true;
    return false;
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a) {
    return newObjectArrayOfSameType(a, a.length);
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return new SynchronizedSet(set);
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public Lock appendToFile_lock = lock();

  static public boolean appendToFile_keepOpen = false;

  static public HashMap<String, Writer> appendToFile_writers = new HashMap();

  static public void appendToFile(String path, String s) {
    try {
      Lock __0 = appendToFile_lock;
      lock(__0);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  static public void cleanMeUp_appendToFile() {
    AutoCloseable __3 = tempCleaningUp();
    try {
      Lock __1 = appendToFile_lock;
      lock(__1);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__1);
      }
    } finally {
      _close(__3);
    }
  }

  static public String htmlencode_forParams_v2(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public List<String> jsonTok(String s) {
    List<String> tok = new ArrayList();
    int l = l(s);
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isLetter(c))
        do ++j; while (j < l && Character.isLetter(s.charAt(j)));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public Number boxedIntOrLong(long l) {
    return l != (int) l ? boxed(l) : boxed((int) l);
  }

  static public <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  static public RuntimeException wrapPatternSyntaxException(PatternSyntaxException e) {
    if (e == null)
      return null;
    String pat = e.getPattern();
    int i = e.getIndex();
    return new RuntimeException("Regular expression error between " + multiLineQuoteWithSpaces(substring(pat, 0, i)) + " and " + multiLineQuoteWithSpaces(substring(pat, i)) + " - " + e.getMessage());
  }

  static public List<String> tok_combineRoundBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public List<String> tok_combineRoundOrCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(")) {
        int j = findEndOfBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public int defaultTokenizerCacheSize() {
    return 1000;
  }

  static public List<String> javaTokWithAllBrackets(String s) {
    return javaTokPlusBrackets2(s);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public String trimJoin(List<String> s) {
    return trim(join(s));
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    if (i >= end)
      return -1;
    String firstToken = tokens[0];
    if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
      while (i < end && !firstToken.equals(tok.get(i))) i += 2;
    }
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else
        matcher = t -> t.equals(p);
      matchers[j] = matcher;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  static public void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  static public boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  static public String nullIfEmpty(String s) {
    return isEmpty(s) ? null : s;
  }

  static public <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
    return isEmpty(map) ? null : map;
  }

  static public <A> List<A> nullIfEmpty(List<A> l) {
    return isEmpty(l) ? null : l;
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public Class actualMC() {
    return or((Class) realMC(), mc());
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public boolean isBoxedType(Class type) {
    return type == Boolean.class || type == Integer.class || type == Long.class || type == Float.class || type == Short.class || type == Character.class || type == Byte.class || type == Double.class;
  }

  static public boolean isArrayType(Class type) {
    return type != null && type.isArray();
  }

  static public boolean hasThisDollarFields(Object o) {
    Matches m = new Matches();
    for (var f : allFieldObjects_dontMakeAccessible(o)) if (startsWith(f.getName(), "this$", m) && isInteger(m.rest()))
      return true;
    return false;
  }

  static public boolean hasSingleArgumentConstructor(Class c) {
    if (c != null)
      for (Constructor m : getDeclaredConstructors_cached(c)) if (l(m.getParameterTypes()) == 1)
        return true;
    return false;
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static public byte[] boolArrayToBytes(boolean[] a) {
    byte[] b = new byte[(l(a) + 7) / 8];
    for (int i = 0; i < l(a); i++) if (a[i])
      b[i / 8] |= 1 << (i & 7);
    return b;
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final Object f, Iterable<Pair<A, B>> l) {
    return map(l, new F1<Pair<A, B>, Pair<A, C>>() {

      public Pair<A, C> get(Pair<A, B> p) {
        try {
          return p == null ? null : pair(p.a, (C) callF(f, p.b));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "p == null ? null : pair(p.a, (C) callF(f, p.b))";
      }
    });
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final F1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(final IF1<B, C> f, Iterable<Pair<A, B>> l) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> List<Pair<A, C>> mapPairB(Iterable<Pair<A, B>> l, IF1<B, C> f) {
    return mapPairB((Object) f, l);
  }

  static public <A, B, C> Pair<A, C> mapPairB(IF1<B, C> f, Pair<A, B> p) {
    return pairMapB(f, p);
  }

  static public <A, B, C> Pair<A, C> mapPairB(Pair<A, B> p, IF1<B, C> f) {
    return pairMapB(f, p);
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public <A, B> Map<B, A> mapToKey(Iterable<A> l, IF1<A, B> f) {
    return mapToKeys(l, f);
  }

  static public <A, B> Map<B, A> mapToKey(IF1<A, B> f, Iterable<A> l) {
    return mapToKeys(f, l);
  }

  static public Map<Class, List<String>> getFieldOrder_cache = weakMap();

  static public List<String> getFieldOrder(Object o) {
    return getFieldOrder(_getClass(o));
  }

  static public List<String> getFieldOrder(Class c) {
    if (c == null)
      return null;
    return getOrCreate(getFieldOrder_cache, c, () -> splitAtSpace(toStringOpt(getOpt(c, "_fieldOrder"))));
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  static public String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  static public boolean isMainProgram() {
    return creator() == null;
  }

  static public void cleanKill() {
    cleanKillVM();
  }

  static public String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  static public List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  static public List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static public List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  static public List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  static public int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  static public long timestampFromYMDHM(int y, int m, int d, int h, int minutes) {
    return new GregorianCalendar(y, m - 1, d, h, minutes).getTimeInMillis();
  }

  static public <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  static public boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 1 / 12.0)
      return true;
    if (age <= 0.5 && age >= lastAge + 1 / 12.0)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age <= 28 && age >= lastAge + 7)
      return true;
    if (age >= lastAge + 365.0 / 12)
      return true;
    return false;
  }

  static public String collapseWord(String s) {
    if (s == null)
      return "";
    StringBuilder buf = new StringBuilder();
    for (int i = 0; i < l(s); i++) if (i == 0 || !charactersEqualIC(s.charAt(i), s.charAt(i - 1)))
      buf.append(s.charAt(i));
    return buf.toString();
  }

  static public List<String> toLowerCase(List<String> strings) {
    List<String> x = new ArrayList();
    for (String s : strings) x.add(s.toLowerCase());
    return x;
  }

  static public String[] toLowerCase(String[] strings) {
    String[] x = new String[l(strings)];
    for (int i = 0; i < l(strings); i++) x[i] = strings[i].toLowerCase();
    return x;
  }

  static public String toLowerCase(String s) {
    return s == null ? "" : s.toLowerCase();
  }

  static public String firstWord2(String s) {
    s = xltrim(s);
    if (empty(s))
      return "";
    if (isLetterOrDigit(first(s)))
      return takeCharsWhile(__62 -> isLetterOrDigit(__62), s);
    else
      return "" + first(s);
  }

  static public IMeta initMetaOfJComponent(JComponent c) {
    if (c == null)
      return null;
    IMeta meta = (IMeta) (c.getClientProperty(IMeta.class));
    if (meta == null)
      c.putClientProperty(IMeta.class, meta = new Meta());
    return meta;
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public String base64encode(byte[] a) {
    int aLen = a.length;
    int numFullGroups = aLen / 3;
    int numBytesInPartialGroup = aLen - 3 * numFullGroups;
    int resultLen = 4 * ((aLen + 2) / 3);
    StringBuffer result = new StringBuffer(resultLen);
    char[] intToAlpha = intToBase64;
    int inCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int byte0 = a[inCursor++] & 0xff;
      int byte1 = a[inCursor++] & 0xff;
      int byte2 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      result.append(intToAlpha[(byte0 << 4) & 0x3f | (byte1 >> 4)]);
      result.append(intToAlpha[(byte1 << 2) & 0x3f | (byte2 >> 6)]);
      result.append(intToAlpha[byte2 & 0x3f]);
    }
    if (numBytesInPartialGroup != 0) {
      int byte0 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      if (numBytesInPartialGroup == 1) {
        result.append(intToAlpha[(byte0 << 4) & 0x3f]);
        result.append("==");
      } else {
        int byte1 = a[inCursor++] & 0xff;
        result.append(intToAlpha[(byte0 << 4) & 0x3f | (byte1 >> 4)]);
        result.append(intToAlpha[(byte1 << 2) & 0x3f]);
        result.append('=');
      }
    }
    return result.toString();
  }

  static final public char[] intToBase64 = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/' };

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isSnippetID(snippetIDOrURLOrFile)) {
        String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
        IResourceLoader rl = vm_getResourceLoader();
        if (rl != null)
          return loadBufferedImage(rl.loadLibrary(snippetID));
        File dir = imageSnippetsCacheDir();
        if (loadBufferedImage_useImageCache) {
          dir.mkdirs();
          File file = new File(dir, snippetID + ".png");
          if (file.exists() && file.length() != 0)
            try {
              return ImageIO.read(file);
            } catch (Throwable e) {
              e.printStackTrace();
            }
        }
        String imageURL = snippetImageURL_http(snippetID);
        print("Loading image: " + imageURL);
        BufferedImage image = imageIO_readURL(imageURL);
        if (loadBufferedImage_useImageCache) {
          File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
          ImageIO.write(image, "png", tempFile);
          tempFile.renameTo(new File(dir, snippetID + ".png"));
        }
        return image;
      } else
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    return loadBufferedImageFile(file);
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    if (r == null)
      return null;
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public <A extends AutoCloseable> A holdResource(IResourceHolder holder, A a) {
    {
      if (holder != null)
        holder.add(a);
    }
    return a;
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public ThreadLocal<Random> customRandomizerForThisThread_tl = new ThreadLocal();

  static public ThreadLocal<Random> customRandomizerForThisThread_tl() {
    return customRandomizerForThisThread_tl;
  }

  static public boolean isDirectory(File f) {
    return f != null && f.isDirectory();
  }

  static public boolean isDirectory(String path) {
    return path != null && isDirectory(newFile(path));
  }

  static public File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  static public File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  static public void stream2file(InputStream in, File out) {
    try {
      mkdirsForFile(out);
      FileOutputStream fos = new FileOutputStream(out);
      copyStream(in, fos);
      in.close();
      fos.close();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadBinarySnippet(String snippetID) {
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadLibrary(snippetID);
    return loadBinarySnippet_noResourceLoader(snippetID);
  }

  static public File loadBinarySnippet_noResourceLoader(String snippetID) {
    try {
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile_noResourceLoader(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public RandomAccessFile newRandomAccessFile(File path, String mode) {
    try {
      boolean forWrite = mode.indexOf('w') >= 0;
      if (forWrite)
        mkdirsForFile(path);
      RandomAccessFile f = new RandomAccessFile(path, mode);
      callJavaX("registerIO", f, path, forWrite);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int lastIndexOf_byteArray(byte[] a, byte b) {
    for (int i = l(a) - 1; i >= 0; i--) if (a[i] == b)
      return i;
    return -1;
  }

  static public int indexOf_byteArray(byte[] a, byte b) {
    int n = l(a);
    for (int i = 0; i < n; i++) if (a[i] == b)
      return i;
    return -1;
  }

  static public String regexpReplace_direct(String s, String pat, String replacement) {
    Matcher m = regexp(pat, s);
    return regexpReplace_direct(m, replacement);
  }

  static public String regexpReplace_direct(Matcher m, String replacement) {
    StringBuffer buf = new StringBuffer();
    while (m.find()) m.appendReplacement(buf, replacement);
    m.appendTail(buf);
    return str(buf);
  }

  static public Matcher regexpIC(Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public Matcher regexpIC(String pat, String s) {
    return compileRegexpIC(pat).matcher(unnull(s));
  }

  static public Pattern regexpIC(String pat) {
    return compileRegexpIC(pat);
  }

  static public void _onJavaXSet() {
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public Object get2(Object o, String field1, String field2) {
    return get(get(o, field1), field2);
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public boolean startsWithAny(String a, Collection<String> b) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
      return true;
    return false;
  }

  static public boolean startsWithAny(String a, String... b) {
    if (b != null)
      for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix))
        return true;
    return false;
  }

  static public boolean startsWithAny(String a, Collection<String> b, Matches m) {
    for (String prefix : unnullForIteration(b)) if (startsWith(a, prefix, m))
      return true;
    return false;
  }

  static public String mcDollar() {
    return mcName() + "$";
  }

  static public String afterDollar(String s) {
    return substring(s, smartIndexOf(s, '$') + 1);
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public <A> IF0<A> f0ToIF0(F0<A> f) {
    return f == null ? null : () -> f.get();
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public <A> Set<A> synchroHashSet() {
    return synchronizedSet(new HashSet<A>());
  }

  static public String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  static public AutoCloseable tempCleaningUp() {
    AutoCloseable result = null;
    result = tempSetTL(ping_isCleanUpThread, true);
    return result;
  }

  static public void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public Integer boxed(int i) {
    return i;
  }

  static public Long boxed(long l) {
    return l;
  }

  static public String multiLineQuoteWithSpaces(String s) {
    return multiLineQuote(" " + s + " ");
  }

  static public int findEndOfBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "("))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public List<String> javaTokPlusBrackets2(String s) {
    return tok_combineRoundCurlySquareBrackets_keep(javaTok(s));
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, (ITokCondition) null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, String in, IIntPred condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, IIntPred condition) {
    return jfind(tok, startIndex, in, tokCondition(condition));
  }

  static public int jfind(List<String> tok, String in, ITokCondition condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIndex, String in, ITokCondition condition) {
    return jfind(tok, startIndex, in, (Object) condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    if (src != null)
      dest.addAll(src);
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean isEmpty(AppendableChain c) {
    return c == null;
  }

  static public Object realMC() {
    return getThreadLocal(realMC_tl());
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int lastIndexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    for (int i = l(l) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public List<Field> allFieldObjects_dontMakeAccessible(Object o) {
    List<Field> fields = new ArrayList();
    Class _c = _getClass(o);
    do {
      addAll(fields, _c.getDeclaredFields());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public Pair pairMapB(Object f, Pair p) {
    return p == null ? null : pair(p.a, callF(f, p.b));
  }

  static public <A, B, C> Pair<A, C> pairMapB(IF1<B, C> f, Pair<A, B> p) {
    return p == null ? null : pair(p.a, f.get(p.b));
  }

  static public Pair pairMapB(Pair p, Object f) {
    return pairMap(f, p);
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache((Class) o);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<B, A> mapToKeys(Iterable<A> l, IF1<A, B> f) {
    if (l == null)
      return null;
    HashMap<B, A> map = new HashMap();
    for (A a : l) map.put(f.get(a), a);
    return map;
  }

  static public <A, B> Map<B, A> mapToKeys(IF1<A, B> f, A[] l) {
    return mapToKeys(f, asList(l));
  }

  static public <A, B> Map<B, A> mapToKeys(IF1<A, B> f, Iterable<A> l) {
    return mapToKeys(l, f);
  }

  static public <A, B> Map<A, B> weakMap() {
    return newWeakHashMap();
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public String toStringOpt(Object o) {
    return o instanceof String ? ((String) o) : null;
  }

  static public Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public Map<String, Integer> findBot_cache = synchroHashMap();

  static public int findBot_timeout = 5000;

  static public DialogIO findBot(String searchPattern) {
    String subBot = null;
    int i = searchPattern.indexOf('/');
    if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
      subBot = searchPattern.substring(i + 1);
      searchPattern = searchPattern.substring(0, i);
      if (!isInteger(searchPattern))
        searchPattern = "Multi-Port at " + searchPattern + ".";
    }
    if (isInteger(searchPattern))
      return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    if (eq(searchPattern, "remote"))
      return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    Integer port = findBot_cache.get(searchPattern);
    if (port != null)
      try {
        DialogIO io = talkTo("localhost", port);
        io.waitForLine();
        String line = io.readLineNoBlock();
        if (indexOfIgnoreCase(line, searchPattern) == 0) {
          call(io, "pushback", line);
          return talkToSubBot(subBot, io);
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    List<ProgramScan.Program> bots = quickBotScan();
    for (ProgramScan.Program p : bots) {
      if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) {
        findBot_cache.put(searchPattern, p.port);
        return talkToSubBot(subBot, talkTo("localhost", p.port));
      }
    }
    for (ProgramScan.Program p : bots) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            String name = subBots.get(vport);
            if (startsWithIgnoreCase(name, searchPattern))
              return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
          }
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
    }
    return null;
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  static public String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  static public boolean exposeMethods2_debug = false;

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  static public int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  static public Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  static public Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  static public Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  static public List<File> listFilesOnly(File... dirs) {
    return concatMap(dir -> listFilesWithSuffix("", dir), dirs);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public boolean charactersEqualIC(char c1, char c2) {
    if (c1 == c2)
      return true;
    char u1 = Character.toUpperCase(c1);
    char u2 = Character.toUpperCase(c2);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public String xltrim(String s) {
    int i = 0, n = l(s);
    while (i < n && contains(" \t\r\n", s.charAt(i))) ++i;
    return substr(s, i);
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public String takeCharsWhile(String s, Object pred) {
    int i = 0;
    while (i < l(s) && isTrue(callF(pred, s.charAt(i)))) ++i;
    return substring(s, 0, i);
  }

  static public String takeCharsWhile(IF1<Character, Boolean> f, String s) {
    return takeCharsWhile(s, f);
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public BufferedImage imageIO_readURL(String url) {
    try {
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public BufferedImage loadBufferedImageFile(File file) {
    try {
      return isFile(file) ? ImageIO.read(file) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static File DiskSnippetCache_getLibrary(String snippetID) {
    try {
      return DiskSnippetCache_getLibrary(psI(snippetID));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public long fileSize(String path) {
    return getFileSize(path);
  }

  static public long fileSize(File f) {
    return getFileSize(f);
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      return loadDataSnippetToFile_noResourceLoader(snippetID);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File loadDataSnippetToFile_noResourceLoader(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  static public String mcName() {
    return mc().getName();
  }

  static public Class<?> hotwire(String src) {
    return hotwire(src, __1 -> mainClassNameForClassLoader(__1));
  }

  static public Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public String multiLineQuote(String s) {
    for (int i = 0; ; i++) {
      String closer = "]" + rep('=', i) + "]";
      if (!contains(s, closer))
        return "[" + rep('=', i) + "[" + s + closer;
    }
  }

  static public List<String> tok_combineRoundCurlySquareBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eqOneOf(t, "{", "(", "[")) {
        int j = findEndOfBracketPart2(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public ITokCondition tokCondition(IIntPred condition) {
    return condition == null ? null : (tok, nIdx) -> condition.get(nIdx);
  }

  static public ThreadLocal realMC_tl_tl = new ThreadLocal();

  static public ThreadLocal realMC_tl() {
    return realMC_tl_tl;
  }

  static public Pair pairMap(Object f, Pair p) {
    return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
  }

  static public <A> Pair<A, A> pairMap(IF1<A, A> f, Pair<A, A> p) {
    return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
  }

  static public Pair pairMap(Pair p, Object f) {
    return pairMap(f, p);
  }

  static public DialogIO talkToSubBot(final long vport, final DialogIO io) {
    return talkToSubBot(String.valueOf(vport), io);
  }

  static public DialogIO talkToSubBot(final String subBot, final DialogIO io) {
    if (subBot == null)
      return io;
    return new talkToSubBot_IO(subBot, io);
  }

  static public class talkToSubBot_IO extends DialogIO {

    public String subBot;

    public DialogIO io;

    public talkToSubBot_IO(String subBot, DialogIO io) {
      this.io = io;
      this.subBot = subBot;
    }

    public boolean isStillConnected() {
      return io.isStillConnected();
    }

    public String readLineImpl() {
      return io.readLineImpl();
    }

    public boolean isLocalConnection() {
      return io.isLocalConnection();
    }

    public Socket getSocket() {
      return io.getSocket();
    }

    public void close() {
      try {
        io.close();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void sendLine(String line) {
      io.sendLine(format3("please forward to bot *: *", subBot, line));
    }
  }

  static public DialogIO talkTo(int port) {
    return talkTo("localhost", port);
  }

  static public int talkTo_defaultTimeout = 10000;

  static public int talkTo_timeoutForReads = 0;

  static public ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

  static public DialogIO talkTo(String ip, int port) {
    try {
      String full = ip + ":" + port;
      Map<String, DialogIO> map = talkTo_byThread.get();
      if (map != null && map.containsKey(full))
        return map.get(full);
      if (isLocalhost(ip) && port == vmPort())
        return talkToThisVM();
      return new talkTo_IO(ip, port);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class talkTo_IO extends DialogIO {

    public String ip;

    public int port;

    public Socket s;

    public Writer w;

    public BufferedReader in;

    public talkTo_IO(String ip, int port) {
      this.port = port;
      this.ip = ip;
      try {
        s = new Socket();
        try {
          if (talkTo_timeoutForReads != 0)
            s.setSoTimeout(talkTo_timeoutForReads);
          s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
        } catch (Throwable e) {
          throw fail("Tried talking to " + ip + ":" + port, e);
        }
        w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
        in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }

    public boolean isStillConnected() {
      return !(eos || s.isClosed());
    }

    public void sendLine(String line) {
      try {
        Lock __0 = lock;
        lock(__0);
        try {
          w.write(line + "\n");
          w.flush();
        } finally {
          unlock(__0);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLineImpl() {
      try {
        return in.readLine();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
      try {
        if (!noClose)
          s.close();
      } catch (IOException e) {
      }
    }

    public Socket getSocket() {
      return s;
    }
  }

  static public List<ProgramScan.Program> quickBotScan() {
    return ProgramScan.quickBotScan();
  }

  static public List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
    return ProgramScan.quickBotScan(preferredPorts);
  }

  static public List<ProgramScan.Program> quickBotScan(String searchPattern) {
    List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
    for (ProgramScan.Program p : ProgramScan.quickBotScan()) if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
    return l;
  }

  static public String firstPartOfHelloString(String s) {
    int i = s.lastIndexOf('/');
    return i < 0 ? s : rtrim(s.substring(0, i));
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public Object unstructure(String text, IF1<String, Class> classFinder) {
    return unstructure(text, false, classFinder);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  public interface unstructure_Handler {

    public void parse(int refID, int tokIndex, unstructure_Receiver out);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public String mcDollar = actualMCDollar();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public List<Runnable> stack = new ArrayList();

      public Map<String, String> baseClassMap = new HashMap();

      public HashMap<Class, Constructor> innerClassConstructors = new HashMap();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      final public HashMap<String, Object> handlers = new HashMap();

      public X() {
        try {
          Class mc = (Class) (callF(_classFinder, "<main>"));
          if (mc != null)
            mcDollar = mc.getName() + "$";
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
        makeHandlers();
      }

      public void makeHandlers() {
        unstructure_Handler h;
        handlers.put("bigint", (unstructure_Handler) (refID, tokIndex, out) -> out.set(parseBigInt()));
        handlers.put("d", (unstructure_Handler) (refID, tokIndex, out) -> out.set(parseDouble()));
        handlers.put("fl", (unstructure_Handler) (refID, tokIndex, out) -> out.set(parseFloat()));
        handlers.put("sh", (unstructure_Handler) (refID, tokIndex, out) -> {
          consume();
          String t = tpp();
          if (t.equals("-")) {
            t = tpp();
            out.set((short) (-parseInt(t)));
            return;
          }
          out.set((short) parseInt(t));
        });
        handlers.put("enum", (unstructure_Handler) (refID, tokIndex, out) -> {
          consume();
          String t = tpp();
          assertTrue(isJavaIdentifier(t));
          String fullClassName = mcDollar + t;
          Class _c = findAClass(fullClassName);
          if (_c == null)
            throw fail("Enum class not found: " + fullClassName);
          int ordinal = parseInt(tpp());
          out.set(_c.getEnumConstants()[ordinal]);
        });
        handlers.put("false", h = (unstructure_Handler) (refID, tokIndex, out) -> {
          consume();
          out.set(false);
        });
        handlers.put("f", h);
        handlers.put("true", h = (unstructure_Handler) (refID, tokIndex, out) -> {
          consume();
          out.set(true);
        });
        handlers.put("t", h);
        handlers.put("{", (unstructure_Handler) (refID, tokIndex, out) -> parseMap(out));
        handlers.put("[", (unstructure_Handler) (refID, tokIndex, out) -> {
          ArrayList l = new ArrayList();
          if (refID >= 0)
            refs.put(refID, l);
          this.parseList(l, out);
        });
        handlers.put("bitset", (unstructure_Handler) (refID, tokIndex, out) -> parseBitSet(out));
        handlers.put("array", h = (unstructure_Handler) (refID, tokIndex, out) -> parseArray(out));
        handlers.put("intarray", h);
        handlers.put("dblarray", h);
      }

      public Class findAClass(String fullClassName) {
        try {
          return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
        } catch (Throwable __e) {
          return null;
        }
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        } else
          refID = -1;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (refID >= 0)
              refs.put(refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, unstructure_Receiver out) {
        String t = t();
        Object handler = handlers.get(t);
        if (handler instanceof unstructure_Handler) {
          ((unstructure_Handler) handler).parse(refID, tokIndex, out);
          return;
        }
        Class c = (Class) handler;
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              warn("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              warn("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            LinkedList l = new LinkedList();
            if (refID >= 0)
              refs.put(refID, l);
            {
              parseList(l, out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(synchroNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(synchroSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(synchroMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(synchroList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = mcDollar + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume();
          out.set(parseJava());
          return;
        }
        if (eq(t, "bc")) {
          consume();
          String c1 = tpp();
          String c2 = tpp();
          baseClassMap.put(c1, c2);
          {
            parse_inner(refID, i, out);
            return;
          }
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = mcDollar + t;
        }
        if (c == null && !allDynamic) {
          c = findAClass(fullClassName);
          handlers.put(className, c);
        }
        if (c == null && !allDynamic) {
          Set<String> seen = new HashSet();
          String parent = className;
          while (true) {
            String baseName = baseClassMap.get(parent);
            if (baseName == null)
              break;
            if (!seen.add(baseName))
              throw fail("Cyclic superclass info: " + baseName);
            c = findAClass(mcDollar + baseName);
            if (c == null)
              print("Base class " + baseName + " of " + parent + " doesn't exist either");
            else if (isAbstract(c))
              print("Can't instantiate abstract base class: " + c);
            else {
              printVars_str("Reverting to base class", "className", className, "baseName", baseName, "c", c);
              handlers.put(className, c);
              break;
            }
            parent = baseName;
          }
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && startsWith(t(), "this$");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        try {
          if (c != null) {
            if (hasOuter)
              try {
                Constructor ctor = innerClassConstructors.get(c);
                if (ctor == null)
                  innerClassConstructors.put(c, ctor = nuStubInnerObject_findConstructor(c, classFinder));
                o = ctor.newInstance(new Object[] { null });
              } catch (Exception e) {
                print("Error deserializing " + c + ": " + e);
                o = nuEmptyObject(c);
              }
            else
              o = nuEmptyObject(c);
            if (o instanceof DynamicObject)
              dO = (DynamicObject) o;
          } else {
            if (concepts.contains(t) && (c = findAClass(mcDollar + "Concept")) != null)
              o = dO = (DynamicObject) nuEmptyObject(c);
            else
              dO = new DynamicObject();
            dO.className = className;
          }
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
        if (o == null && dO == null)
          dO = new DynamicObject();
        if (refID >= 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        HashMap<String, Object> fields = new HashMap();
        Object _o = o;
        DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        Object outer = fields.get("this$0");
        if (outer != null)
          fields.put("this$1", outer);
        else {
          outer = fields.get("this$1");
          if (outer != null)
            fields.put("this$0", outer);
        }
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(unstructure_Receiver out) {
        String _type = tpp();
        int dims;
        if (eq(t(), "S")) {
          _type = "S";
          consume();
        }
        if (eq(t(), "/")) {
          consume();
          dims = parseInt(tpp());
        } else
          dims = 1;
        consume("{");
        List list = new ArrayList();
        String type = _type;
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                if (dims > 1) {
                  Class atype;
                  if (type.equals("intarray"))
                    atype = int.class;
                  else if (type.equals("S"))
                    atype = String.class;
                  else
                    throw todo("multi-dimensional arrays of other types");
                  out.set(list.toArray((Object[]) newMultiDimensionalOuterArray(atype, dims, l(list))));
                } else
                  out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : type.equals("S") ? toStringArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          if (dims > 1) {\r\n    ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix(mcDollar, name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String format(String pat, Object... args) {
    return format3(pat, args);
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public String ok2(String s) {
    return "ok " + s;
  }

  static public boolean makeAndroid3_disable = false;

  static public class Android3 implements AutoCloseable {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public void close() {
      dispose();
    }

    synchronized public void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          printStackTrace(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  static abstract public class Responder {

    abstract public String answer(String s, List<String> history);
  }

  static public Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  static public Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  static public Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  static public void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  static public DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  static public String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  static public String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  static public boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  static public Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  static public ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  static public Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  static public String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  static public Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  static public String defaultBotName() {
    return getProgramTitle() + ".";
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, A[] l) {
    return concatMap((Object) f, l);
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public List<File> listFilesWithSuffix(String suffix, File dir) {
    return listFilesWithSuffix(dir, suffix);
  }

  static public String substr(String s, int x) {
    return substring(s, x);
  }

  static public String substr(String s, int x, int y) {
    return substring(s, x, y);
  }

  static public boolean isFile(File f) {
    return f != null && f.isFile();
  }

  static public boolean isFile(String path) {
    return isFile(newFile(path));
  }

  static public File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean _inCore() {
    return false;
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public int findEndOfBracketPart2(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eqOneOf(cnc.get(j), "{", "(", "["))
        ++level;
      else if (eqOneOf(cnc.get(j), "}", ")", "]"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  static public boolean isLocalhost(String ip) {
    return isLoopbackIP(ip) || eqic(ip, "localhost");
  }

  static public int vmPort() {
    return myVMPort();
  }

  static public DialogIO talkToThisVM() {
    return new talkToThisVM_IO();
  }

  static public class talkToThisVM_IO extends DialogIO {

    public List<String> answers = ll(thisVMGreeting());

    public boolean isLocalConnection() {
      return true;
    }

    public boolean isStillConnected() {
      return true;
    }

    public int getPort() {
      return vmPort();
    }

    public void sendLine(String line) {
      answers.add(or2(sendToThisVM_newThread(line), "?"));
    }

    public String readLineImpl() {
      try {
        return popFirst(answers);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
    }

    public Socket getSocket() {
      return null;
    }
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public <A> List<A> synchroLinkedList() {
    return synchroList(new LinkedList<A>());
  }

  static public <A, B> NavigableMap<A, B> synchroNavigableMap(NavigableMap<A, B> map) {
    return new SynchronizedNavigableMap(map);
  }

  static public <A, B> SortedMap<A, B> synchroSortedMap(SortedMap<A, B> map) {
    return new SynchronizedSortedMap(map);
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c) {
    return nuStubInnerObject_findConstructor(c, null);
  }

  static public <A> Constructor nuStubInnerObject_findConstructor(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      makeAccessible(m);
      return m;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : getDeclaredConstructors_cached(c)) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null || o == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        Field f = fieldMap.get(field);
        if (f != null)
          smartSet(f, o, val);
        else {
          dynamicObject_setRawFieldValue(o, intern(field), val);
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public Object newMultiDimensionalOuterArray(Class elementType, int dimensions, int length) {
    int[] dims = new int[dimensions];
    dims[0] = length;
    return Array.newInstance(elementType, dims);
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public ThreadLocal<Boolean> DynamicObject_loading = or((ThreadLocal) get(getClass("x30_pkg.x30_util"), "DynamicObject_loading"), new ThreadLocal());

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public Map<String, Integer> newFindBot2_cache = synchroHashMap();

  static public boolean newFindBot2_verbose = false;

  static public DialogIO newFindBot2(String name) {
    Integer port = newFindBot2_cache.get(name);
    if (port != null) {
      if (newFindBot2_verbose)
        print("newFindBot2: testing " + name + " => " + port);
      DialogIO io = talkTo(port);
      String q = format("has bot *", name);
      String s = io.ask(q);
      if (match("yes", s)) {
        io = talkToSubBot(name, io);
        call(io, "pushback", "?");
        return io;
      }
      newFindBot2_cache.remove(name);
      if (newFindBot2_verbose)
        print("newFindBot2: dropping " + name + " => " + port);
    }
    DialogIO io = findBot(name);
    if (io != null) {
      newFindBot2_cache.put(name, io.getPort());
      if (newFindBot2_verbose)
        print("newFindBot2: remembering " + name + " => " + port);
    }
    return io;
  }

  static public void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  static public String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  static public String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  static public String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  static public String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public List<Object> record_list = synchroList();

  static public void record(Object o) {
    record_list.add(o);
  }

  static public Object addToMultiPort_responder;

  static public long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  static public long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  static public AtomicInteger dialogServer_clients = new AtomicInteger();

  static public boolean dialogServer_printConnects = false;

  static public ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  static public Set<String> dialogServer_knownClients = synchroTreeSet();

  static public int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  static public int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  static public void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  static public ServerSocket startDialogServer_serverSocket;

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  static volatile public boolean readLine_noReadLine = false;

  static public String readLine_lastInput;

  static public String readLine_prefix = "[] ";

  static public String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  static public String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  static public boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  static public String indentx(Object s) {
    return indentx(strOrEmpty(s));
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String processID_cached;

  static public String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  static public String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  static public <A> A println(A a) {
    return print(a);
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File renameFile_assertTrue(File a, File b) {
    try {
      if (a.equals(b))
        return b;
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
      return b;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public boolean isNonNegativeInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public boolean isLoopbackIP(String ip) {
    return eq(ip, "127.0.0.1");
  }

  static public int myVMPort() {
    List records = (List) (get(getJavaX(), "record_list"));
    Object android = last(records);
    return or0((Integer) get(android, "port"));
  }

  static public String thisVMGreeting() {
    List record_list = (List) (get(getJavaX(), "record_list"));
    Object android = first(record_list);
    return getString(android, "greeting");
  }

  static public String sendToThisVM_newThread(String s, Object... args) {
    final String _s = format(s, args);
    try {
      return (String) evalInNewThread(new F0<Object>() {

        public Object get() {
          try {
            return callStaticAnswerMethod(getJavaX(), _s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "return callStaticAnswerMethod(getJavaX(), _s);";
        }
      });
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      return str(e);
    }
  }

  static public <A> A popFirst(List<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(0);
    return a;
  }

  static public <A> A popFirst(Collection<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(a);
    return a;
  }

  static public <A, B> Pair<A, B> popFirst(Map<A, B> map) {
    if (map == null)
      return null;
    var it = map.entrySet().iterator();
    if (!it.hasNext())
      return null;
    var p = mapEntryToPair(it.next());
    it.remove();
    return p;
  }

  static public <A> List<A> popFirst(int n, List<A> l) {
    List<A> part = cloneSubList(l, 0, n);
    removeSubList(l, 0, n);
    return part;
  }

  static public <A> AppendableChain<A> popFirst(AppendableChain<A> a) {
    return a == null ? null : a.popFirst();
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i >= j)
      return "";
    return s.substring(i, j);
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public Object safeUnstructure(File f) {
    return safeUnstructureGZFile(f);
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      return classForName(name, classFinder);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class getOuterClass(Object o) {
    return getOuterClass(o, null);
  }

  static public Class getOuterClass(Object o, Object classFinder) {
    return getOuterClass(_getClass(o), classFinder);
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    return (HashMap) getOpt_getFieldMap(o);
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().startsWith("this$"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public Class<?> getClass(String name) {
    return _getClass(name);
  }

  static public Class getClass(Object o) {
    return _getClass(o);
  }

  static public Class getClass(Object realm, String name) {
    return _getClass(realm, name);
  }

  static public List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  static public String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  static public <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  static public void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  static public <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  static public <A> Set<A> synchroTreeSet(TreeSet<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public boolean forbiddenPort(int port) {
    return port == 5037;
  }

  static public String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + replace(unnull(s), "\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public int or0(Integer i) {
    return i == null ? 0 : i;
  }

  static public long or0(Long l) {
    return l == null ? 0L : l;
  }

  static public double or0(Double d) {
    return d == null ? 0.0 : d;
  }

  static public Object evalInNewThread(final Object f) {
    final Flag flag = new Flag();
    final Var var = new Var();
    final Var<Throwable> exception = new Var();
    {
      startThread(new Runnable() {

        public void run() {
          try {
            try {
              var.set(callF(f));
            } catch (Throwable e) {
              exception.set(e);
            }
            flag.raise();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception...";
        }
      });
    }
    flag.waitUntilUp();
    if (exception.has())
      throw rethrow(exception.get());
    return var.get();
  }

  static public Object safeUnstructureGZFile(File f) {
    try {
      if (!fileExists(f))
        return null;
      BufferedReader reader = utf8BufferedReader(gzInputStream(f));
      return unstructure_tok(javaTokC_noMLS_onReader(reader), true, null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Class<A> type, Iterable<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Class<A> type, Collection<A> c) {
    return toArray(c, type);
  }

  static public <A> A[] toArray(Collection<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    var c2 = asList(c);
    A[] a = arrayOfType(l(c2), type);
    if (a.length == 0)
      return a;
    c2.toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public void nohupJavax(final String javaxargs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs);";
        }
      });
    }
  }

  static public void nohupJavax(final String javaxargs, final String vmArgs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs, vmArgs);";
        }
      });
    }
  }

  static public void consoleClearInput() {
    consoleSetInput("");
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public String getSnippetTitleOpt(String s) {
    try {
      return isSnippetID(s) ? getSnippetTitle(s) : s;
    } catch (Throwable __e) {
      printStackTrace(__e);
    }
    return s;
  }

  static public BufferedReader utf8BufferedReader(InputStream in) {
    return utf8bufferedReader(in);
  }

  static public BufferedReader utf8BufferedReader(File f) {
    return utf8bufferedReader(f);
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  static public void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  static public String getSnippetTitle(String id) {
    if (id == null)
      return null;
    if (!isSnippetID(id))
      return "?";
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.getSnippetTitle(id);
    return getSnippetTitle_noResourceLoader(id);
  }

  static public String getSnippetTitle_noResourceLoader(String id) {
    try {
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  static public Lock hotwireCached_lock = lock();

  static public Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  static public Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  static public Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __0 = hotwireCached_lock;
    lock(__0);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__0);
    }
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    if (tf != null) {
      swing(() -> {
        tf.setText(text);
        tf.selectAll();
      });
    }
    return tf;
  }

  static public JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  static public void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  static public void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public Object makeDependent_postProcess;

  static public void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  static public void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  static public JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public <A> int smartLastIndexOf(List<A> l, A sub) {
    int i = lastIndexOf(l, sub);
    return i < 0 ? l(l) : i;
  }

  static public List<WeakReference<Class>> hotwire_classes = synchroList();

  static public Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  static public <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static abstract public class VF1<A> implements IVF1<A> {

    public abstract void get(A a);
  }

  static public class Meta implements IMeta {

    volatile public Object meta;

    public void _setMeta(Object meta) {
      this.meta = meta;
    }

    public Object _getMeta() {
      return meta;
    }

    final public boolean scaffolding() {
      return scaffoldingEnabled();
    }

    public boolean scaffoldingEnabled() {
      return main.scaffoldingEnabled(this);
    }

    public boolean scaffoldingEnabled(Object o) {
      return main.scaffoldingEnabled(o);
    }
  }

  static public class MultiSetMap<A, B> implements IMultiMap<A, B> {

    public Map<A, Set<B>> data = new HashMap<A, Set<B>>();

    public int size;

    public MultiSetMap() {
    }

    public MultiSetMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiSetMap(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public MultiSetMap(Map<A, Set<B>> data) {
      this.data = data;
    }

    public boolean put(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        if (!set.add(value))
          return false;
        {
          ++size;
          return true;
        }
      }
    }

    public boolean add(A key, B value) {
      return put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      synchronized (data) {
        putAll(key, values);
      }
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    final public boolean contains(A key, B value) {
      return containsPair(key, value);
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) put(key, value);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public Set<B> get(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        return set == null ? Collections.<B>emptySet() : set;
      }
    }

    public List<B> getAndClear(A key) {
      synchronized (data) {
        List<B> l = cloneList(data.get(key));
        remove(key);
        return l;
      }
    }

    public Set<B> getOpt(A key) {
      synchronized (data) {
        return data.get(key);
      }
    }

    public Set<B> getActual(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        return set;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        Set<B> list = data.get(key);
        if (list != null && list.isEmpty())
          data.remove(key);
      }
    }

    final public Set<A> keys() {
      return keySet();
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        size -= l(data.get(key));
        data.remove(key);
      }
    }

    public void remove(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set != null) {
          if (set.remove(value)) {
            --size;
            if (set.isEmpty())
              data.remove(key);
          }
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
        size = 0;
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        return first(get(key));
      }
    }

    public void addAll(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiSetMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    final public int keyCount() {
      return keysSize();
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    public int size() {
      synchronized (data) {
        return size;
      }
    }

    public int getSize(A key) {
      return l(data.get(key));
    }

    public int count(A key) {
      return getSize(key);
    }

    public Set<A> reverseGet(B b) {
      synchronized (data) {
        Set<A> l = new HashSet();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public A keyForValue(B b) {
      synchronized (data) {
        for (A key : data.keySet()) if (data.get(key).contains(b))
          return key;
        return null;
      }
    }

    public Map<A, Set<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public Set<B> _makeEmptySet() {
      return new HashSet();
    }

    public Collection<Set<B>> allLists() {
      synchronized (data) {
        return new HashSet(data.values());
      }
    }

    public List<B> allValues() {
      return concatLists(values(data));
    }

    public List<Pair<A, B>> allEntries() {
      synchronized (data) {
        List<Pair<A, B>> l = emptyList(size);
        for (Map.Entry<? extends A, ? extends Set<B>> __0 : _entrySet(data)) {
          A a = __0.getKey();
          Set<B> set = __0.getValue();
          for (B b : set) l.add(pair(a, b));
        }
        return l;
      }
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }

    public Pair<A, B> firstEntry() {
      synchronized (data) {
        if (empty(data))
          return null;
        Map.Entry<A, Set<B>> entry = data.entrySet().iterator().next();
        return pair(entry.getKey(), first(entry.getValue()));
      }
    }

    public A firstKey() {
      synchronized (data) {
        return main.firstKey(data);
      }
    }

    public A lastKey() {
      synchronized (data) {
        return (A) ((NavigableMap) data).lastKey();
      }
    }

    public A higherKey(Object a) {
      synchronized (data) {
        return (A) ((NavigableMap) data).higherKey(a);
      }
    }
  }

  static public class Var<A> implements IVar<A>, ISetter<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public void clear() {
      set(null);
    }

    public String toString() {
      return str(this.get());
    }
  }

  static public interface Visitable {

    public void visitUsing(IVF1 f);
  }

  static public interface ITokCondition {

    public boolean get(List<String> tok, int i);
  }

  static abstract public class TokCondition implements ITokCondition {

    public abstract boolean get(List<String> tok, int i);
  }

  static public class PingSource {

    final public PingSource setAction(IF0<Boolean> action) {
      return action(action);
    }

    public PingSource action(IF0<Boolean> action) {
      this.action = action;
      return this;
    }

    final public IF0<Boolean> getAction() {
      return action();
    }

    public IF0<Boolean> action() {
      return action;
    }

    volatile public IF0<Boolean> action;

    public String text;

    public ThreadPool threadPool;

    public PingSource() {
    }

    public PingSource(ThreadPool threadPool) {
      this.threadPool = threadPool;
    }

    public PingSource(ThreadPool threadPool, String text) {
      this.text = text;
      this.threadPool = threadPool;
    }

    public PingSource(IF0<Boolean> action) {
      this.action = action;
    }

    final public boolean get() {
      var a = action;
      return a != null && a.get();
    }

    final public void ping() {
      var a = action;
      if (a != null)
        a.get();
    }

    public void cancel() {
      action = new Cancelled();
    }

    public class Cancelled implements IF0<Boolean> {

      public Boolean get() {
        throw new PingSourceCancelledException(PingSource.this);
      }
    }

    public class Encapsulated implements Runnable, IFieldsToList {

      public Runnable r;

      public Encapsulated() {
      }

      public Encapsulated(Runnable r) {
        this.r = r;
      }

      public Object[] _fieldsToList() {
        return new Object[] { r };
      }

      public void run() {
        try {
          try {
            pingSource_tl().set(PingSource.this);
            ping();
            r.run();
          } finally {
            pingSource_tl().set(null);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return PingSource.this + ": " + r;
      }
    }

    public void dO(Runnable r) {
      if (r == null)
        return;
      threadPool.acquireThreadOrQueue(new Encapsulated(r));
    }

    public String toString() {
      String t = text;
      return nempty(t) ? t : super.toString();
    }

    public ISleeper_v2 sleeper() {
      return threadPool.sleeper();
    }
  }

  static public int concepts_internStringsLongerThan = 10;

  static public ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

  static public boolean concepts_unlistedByDefault = true;

  public interface IConceptIndex {

    public void update(Concept c);

    public void remove(Concept c);
  }

  public interface IFieldIndex<A extends Concept, Val> {

    public Collection<A> getAll(Val val);

    public List<Val> allValues();

    public MultiSet<Val> allValues_multiSet();

    public IterableIterator<A> objectIterator();
  }

  static public class ConceptsChange {
  }

  static public class ConceptCreate extends ConceptsChange implements IFieldsToList {

    public Concept c;

    public ConceptCreate() {
    }

    public ConceptCreate(Concept c) {
      this.c = c;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + c + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof ConceptCreate))
        return false;
      ConceptCreate __3 = (ConceptCreate) o;
      return eq(c, __3.c);
    }

    public int hashCode() {
      int h = -1751266972;
      h = boostHashCombine(h, _hashCode(c));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { c };
    }
  }

  static public class ConceptChange extends ConceptsChange implements IFieldsToList {

    public Concept c;

    public ConceptChange() {
    }

    public ConceptChange(Concept c) {
      this.c = c;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + c + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof ConceptChange))
        return false;
      ConceptChange __4 = (ConceptChange) o;
      return eq(c, __4.c);
    }

    public int hashCode() {
      int h = -1760609256;
      h = boostHashCombine(h, _hashCode(c));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { c };
    }
  }

  static public class ConceptDelete extends ConceptsChange implements IFieldsToList {

    static final public String _fieldOrder = "id c";

    public long id;

    public Concept c;

    public ConceptDelete() {
    }

    public ConceptDelete(long id, Concept c) {
      this.c = c;
      this.id = id;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + id + ", " + c + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof ConceptDelete))
        return false;
      ConceptDelete __5 = (ConceptDelete) o;
      return id == __5.id && eq(c, __5.c);
    }

    public int hashCode() {
      int h = -1734431213;
      h = boostHashCombine(h, _hashCode(id));
      h = boostHashCombine(h, _hashCode(c));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { id, c };
    }
  }

  static public class FullChange extends ConceptsChange implements IFieldsToList {

    public FullChange() {
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this);
    }

    public boolean equals(Object o) {
      return o instanceof FullChange;
    }

    public int hashCode() {
      int h = 733452095;
      return h;
    }

    public Object[] _fieldsToList() {
      return null;
    }
  }

  static public class Concepts implements AutoCloseable {

    public SortedMap<Long, Concept> concepts = synchroTreeMap();

    final public long getIdCounter() {
      return idCounter();
    }

    public long idCounter() {
      return idCounter;
    }

    public long idCounter;

    transient public HashMap<Class, Object> perClassData;

    transient public Map miscMap;

    transient public String programID;

    transient public File conceptsFile;

    transient public Concepts parent;

    transient volatile public long changes, changesWritten, lastChange;

    transient volatile public java.util.Timer autoSaver;

    transient volatile public boolean dontSave = false;

    transient volatile public boolean savingConcepts, noXFullGrab;

    transient public boolean vmBusSend = true;

    transient public boolean initialSave = false;

    transient public int autoSaveInterval = -1000;

    transient public boolean useGZIP = true, quietSave;

    transient public ReentrantLock lock = new ReentrantLock(true);

    transient public ReentrantLock saverLock = new ReentrantLock(true);

    transient public long lastSaveTook = -1, lastSaveWas, loadTook, uncompressedSize;

    transient public float maxAutoSavePercentage = 10;

    transient public List<IConceptIndex> conceptIndices;

    transient public Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;

    transient public Map<Class<? extends Concept>, Map<String, IFieldIndex>> ciFieldIndices;

    transient public List<Runnable> preSave;

    transient public Object classFinder = _defaultClassFinder();

    transient public List onAllChanged = synchroList();

    transient public Set<IVF1> onChange = new HashSet();

    transient public Object saveWrapper;

    final public Concepts setModifyOnCreate(boolean modifyOnCreate) {
      return modifyOnCreate(modifyOnCreate);
    }

    public Concepts modifyOnCreate(boolean modifyOnCreate) {
      this.modifyOnCreate = modifyOnCreate;
      return this;
    }

    final public boolean getModifyOnCreate() {
      return modifyOnCreate();
    }

    public boolean modifyOnCreate() {
      return modifyOnCreate;
    }

    transient public boolean modifyOnCreate = false;

    transient public boolean modifyOnBackRef = false;

    transient public boolean useFileLock = true;

    transient public FileBasedLock fileLock;

    transient public boolean storeBaseClassesInStructure = false;

    transient public boolean useBackRefsForSearches = false;

    transient public boolean defunct = false;

    transient public int newBackupEveryXMinutes = 60;

    public Concepts() {
    }

    public Concepts(String programID) {
      this.programID = programID;
    }

    public Concepts(File conceptsFile) {
      this.conceptsFile = conceptsFile;
    }

    synchronized public long internalID() {
      do {
        ++idCounter;
      } while (hasConcept(idCounter));
      return idCounter;
    }

    synchronized public HashMap<Class, Object> perClassData() {
      if (perClassData == null)
        perClassData = new HashMap();
      return perClassData;
    }

    public void initProgramID() {
      if (programID == null)
        programID = getDBProgramID();
    }

    public Concepts load(String structure) {
      return load(structure, false);
    }

    public Concepts load(String structure, boolean allDynamic) {
      clearConcepts();
      Map<Long, Concept> map = unstructureMap(structure, allDynamic, classFinder);
      concepts.putAll(map);
      assignConceptsToUs();
      calcIdCounter();
      return this;
    }

    public Concepts load() {
      initProgramID();
      Object dbGrabber = miscMapGet("dbGrabber");
      if (dbGrabber != null && !isFalse(callF(dbGrabber)))
        return this;
      try {
        if (tryToGrab())
          return this;
      } catch (Throwable e) {
        if (!exceptionMessageContains(e, "no xfullgrab"))
          printShortException(e);
        print("xfullgrab failed - loading DB of " + programID + " from disk");
      }
      return loadFromDisk();
    }

    public Concepts loadFromDisk() {
      if (nempty(concepts))
        clearConcepts();
      long time = now();
      Map<Long, Concept> _concepts = (Map<Long, Concept>) (unstructureGZFile(conceptsFile(), toIF1(classFinder)));
      putAll(concepts, _concepts);
      assignConceptsToUs();
      loadTook = now() - time;
      done("Loaded " + n2(l(concepts), "concept"), time);
      calcIdCounter();
      return this;
    }

    public Concepts loadConcepts() {
      return load();
    }

    public boolean tryToGrab() {
      if (sameSnippetID(programID, getDBProgramID()))
        return false;
      RemoteDB db = connectToDBOpt(programID);
      try {
        if (db != null) {
          loadGrab(db.fullgrab());
          return true;
        }
        return false;
      } finally {
        _close(db);
      }
    }

    public Concepts loadGrab(String grab) {
      clearConcepts();
      DynamicObject_loading.set(true);
      try {
        Map<Long, Concept> map = (Map) unstructure(grab, false, classFinder);
        concepts.putAll(map);
        assignConceptsToUs();
        for (long l : map.keySet()) idCounter = max(idCounter, l);
      } finally {
        DynamicObject_loading.set(null);
      }
      return this;
    }

    public void assignConceptsToUs() {
      for (Pair<Long, Object> p : mapToPairs((Map<Long, Object>) (Map) concepts)) if (!(p.b instanceof Concept)) {
        print("DROPPING non-existant concept " + p.a + ": " + dynShortName(p.b));
        concepts.remove(p.a);
      }
      for (Concept c : values(concepts)) c._concepts = this;
      for (Concept c : values(concepts)) c._doneLoading2();
    }

    public String progID() {
      return programID == null ? getDBProgramID() : programID;
    }

    public Concept getConcept(String id) {
      return empty(id) ? null : getConcept(parseLong(id));
    }

    public Concept getConcept(long id) {
      return (Concept) concepts.get((long) id);
    }

    public Concept getConcept(RC ref) {
      return ref == null ? null : getConcept(ref.longID());
    }

    public boolean hasConcept(long id) {
      return concepts.containsKey((long) id);
    }

    public void deleteConcept(long id) {
      Concept c = getConcept(id);
      if (c == null)
        print("Concept " + id + " not found");
      else
        c.delete();
    }

    public void calcIdCounter() {
      Long lastID = lastKey(concepts);
      idCounter = lastID == null ? 1 : lastID + 1;
    }

    public File conceptsDir() {
      return dirOfFile(conceptsFile());
    }

    public Concepts conceptsFile(File conceptsFile) {
      this.conceptsFile = conceptsFile;
      return this;
    }

    public File conceptsFile() {
      if (conceptsFile != null)
        return conceptsFile;
      return getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
    }

    public File lockFile() {
      return newFile(conceptsDir(), "concepts.lock");
    }

    public FileBasedLock fileLock() {
      if (fileLock == null)
        fileLock = new FileBasedLock(lockFile());
      return fileLock;
    }

    public void saveConceptsIfDirty() {
      saveConcepts();
    }

    public void save() {
      saveConcepts();
    }

    public void saveConcepts() {
      vmBus_send("saveConceptsCalled", Concepts.this);
      if (dontSave)
        return;
      initProgramID();
      saverLock.lock();
      savingConcepts = true;
      long start = now(), time;
      try {
        String s = null;
        long _changes = changes;
        if (_changes == changesWritten)
          return;
        File f = conceptsFile();
        lock.lock();
        long fullTime = now();
        try {
          if (useGZIP) {
            vmBus_send("callingSaveWrapper", Concepts.this, saveWrapper);
            callRunnableWithWrapper(saveWrapper, new Runnable() {

              public void run() {
                try {
                  vmBus_send("callingPreSave", Concepts.this, preSave);
                  callFAll(preSave);
                  vmBus_send("writingFile", Concepts.this, f);
                  uncompressedSize = saveGZStructureToFile(f, cloneMap(concepts), makeStructureData());
                  vmBus_send("gzFileSaved", Concepts.this, f, uncompressedSize);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "vmBus_send callingPreSave(Concepts.this, preSave);\r\n            callFAll(preS...";
              }
            });
            newFile(conceptsDir(), "concepts.structure").delete();
          } else
            s = fullStructure();
        } finally {
          lock.unlock();
        }
        changesWritten = _changes;
        if (!useGZIP) {
          time = now() - start;
          if (!quietSave)
            print("Saving " + toM(l(s)) + "M chars (" + time + " ms)");
          start = now();
          saveTextFile(f, javaTokWordWrap(s));
          newFile(conceptsDir(), "concepts.structure.gz").delete();
        }
        File conceptsFile = conceptsFile();
        File backupFile = newFile(conceptsDir(), "backups/" + fileName(conceptsFile) + ".backup" + ymd() + "-" + formatInt(hours(), 2) + (newBackupEveryXMinutes >= 60 ? "" : formatInt(roundDownTo_rev(minutes(), newBackupEveryXMinutes), 2)));
        copyFile(f, backupFile);
        time = now() - start;
        if (!quietSave)
          print("Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
        lastSaveWas = fullTime;
        lastSaveTook = now() - fullTime;
      } finally {
        savingConcepts = false;
        saverLock.unlock();
      }
    }

    public void _autoSaveConcepts() {
      if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
        long pivotTime = Math.round(lastSaveWas + lastSaveTook * 100.0 / maxAutoSavePercentage);
        if (now() < pivotTime) {
          return;
        }
      }
      try {
        saveConcepts();
      } catch (Throwable e) {
        print("Concept save failed, will try again");
        printStackTrace(e);
      }
    }

    public String fullStructure() {
      return structure(cloneMap(concepts), makeStructureData());
    }

    transient public IF0<structure_Data> makeStructureData;

    public structure_Data makeStructureData() {
      return makeStructureData != null ? makeStructureData.get() : makeStructureData_base();
    }

    final public structure_Data makeStructureData_fallback(IF0<structure_Data> _f) {
      return _f != null ? _f.get() : makeStructureData_base();
    }

    public structure_Data makeStructureData_base() {
      return finishStructureData(new structure_Data());
    }

    public structure_Data finishStructureData(structure_Data data) {
      if (storeBaseClassesInStructure)
        data.storeBaseClasses = true;
      return data;
    }

    public void clearConcepts() {
      for (Concept c : allConcepts()) c.delete();
    }

    public void fireLegacyChangeEvent() {
      synchronized (this) {
        ++changes;
        lastChange = sysNow();
      }
      if (vmBusSend)
        vmBus_send("conceptsChanged", this);
      pcallFAll(onAllChanged);
    }

    synchronized public void autoSaveConcepts() {
      if (autoSaver == null) {
        if (isTransient())
          throw fail("Can't persist transient database");
        autoSaver = doEvery_daemon("Concepts Saver for " + conceptsDir(), abs(autoSaveInterval), new Runnable() {

          public void run() {
            try {
              _autoSaveConcepts();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "_autoSaveConcepts()";
          }
        });
      }
    }

    public void close() {
      cleanMeUp();
    }

    public void cleanMeUp() {
      try {
        defunct = true;
        boolean shouldSave = autoSaver != null;
        if (autoSaver != null) {
          autoSaver.cancel();
          autoSaver = null;
        }
        while (savingConcepts) sleepInCleanUp(10);
        if (shouldSave)
          saveConceptsIfDirty();
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
      {
        cleanUp(fileLock);
        fileLock = null;
      }
    }

    public Map<Long, String> getIDsAndNames() {
      Map<Long, String> map = new HashMap();
      Map<Long, Concept> cloned = cloneMap(concepts);
      for (long id : keys(cloned)) map.put(id, cloned.get(id).className);
      return map;
    }

    public void deleteConcepts(List l) {
      ping();
      if (l != null)
        for (Object o : cloneList(l)) if (o instanceof Long) {
          Concept c = concepts.get(o);
          if (c != null)
            c.delete();
        } else if (o instanceof Concept)
          ((Concept) o).delete();
        else
          warn("Can't delete " + getClassName(o));
    }

    public <A extends Concept> A conceptOfType(Class<A> type) {
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (A) first(counter.allConcepts());
      return firstOfType(allConcepts(), type);
    }

    public <A extends Concept> List<A> conceptsOfType(Class<A> type) {
      List<A> l = conceptsOfType_noParent(type);
      if (parent == null)
        return l;
      return concatLists_conservative(l, parent.conceptsOfType(type));
    }

    public <A extends Concept> List<A> conceptsOfType_noParent(Class<A> type) {
      ping();
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (List<A>) cloneList(counter.allConcepts());
      return filterByType(allConcepts(), type);
    }

    public <A extends Concept> List<A> listConcepts(Class<A> type) {
      return conceptsOfType(type);
    }

    public <A extends Concept> List<A> list(Class<A> type) {
      return conceptsOfType(type);
    }

    public <A extends Concept> List<A> list_noParent(Class<A> type) {
      return conceptsOfType_noParent(type);
    }

    public List<Concept> list(String type) {
      return conceptsOfType(type);
    }

    public List<Concept> conceptsOfType(String type) {
      return filterByDynamicType(allConcepts(), "main$" + type);
    }

    public boolean hasConceptOfType(Class<? extends Concept> type) {
      return hasType(allConcepts(), type);
    }

    public void persistConcepts() {
      loadConcepts();
      autoSaveConcepts();
    }

    public void conceptPersistence() {
      persistConcepts();
    }

    public Concepts persist() {
      persistConcepts();
      return this;
    }

    public void persist(Integer interval) {
      if (interval != null)
        autoSaveInterval = interval;
      persist();
    }

    public <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
      A a = conceptOfType(c);
      if (a == null) {
        r.run();
        a = conceptOfType(c);
        if (a == null)
          throw fail("Concept not made by " + r + ": " + shortClassName(c));
      }
      return a;
    }

    public void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
      for (Concept a : conceptsOfType(c1)) {
        Concept b = findBackRef(a, c2);
        if (b == null) {
          callF(func, a);
          b = findBackRef(a, c2);
          if (b == null)
            throw fail("Concept not made by " + func + ": " + shortClassName(c2));
        }
      }
    }

    public void forEvery(Class<? extends Concept> type, Object func) {
      for (Concept c : conceptsOfType(type)) callF(func, c);
    }

    public int deleteAll(Class<? extends Concept> type) {
      List<Concept> l = (List) conceptsOfType(type);
      for (Concept c : l) c.delete();
      return l(l);
    }

    public Collection<Concept> allConcepts() {
      synchronized (concepts) {
        return new ArrayList(values(concepts));
      }
    }

    public IConceptCounter conceptCounterForClass(Class<? extends Concept> c) {
      for (IFieldIndex idx : values(mapGet(fieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      for (IFieldIndex idx : values(mapGet(ciFieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      return null;
    }

    public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
      int n = countConcepts_noParent(c, params);
      if (parent == null)
        return n;
      return n + parent.countConcepts(c, params);
    }

    public <A extends Concept> int countConcepts_noParent(Class<A> c, Object... params) {
      ping();
      if (empty(params)) {
        IConceptCounter counter = conceptCounterForClass(c);
        if (counter != null)
          return counter.countConcepts();
        return l(list_noParent(c));
      }
      int n = 0;
      for (A x : list_noParent(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts(String c, Object... params) {
      ping();
      if (empty(params))
        return l(list(c));
      int n = 0;
      for (Concept x : list(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts() {
      return l(concepts);
    }

    synchronized public List<IConceptIndex> clonedConceptIndices() {
      return cloneList(conceptIndices);
    }

    synchronized public void addConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        conceptIndices = new ArrayList();
      conceptIndices.add(index);
    }

    synchronized public void removeConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        return;
      conceptIndices.remove(index);
      if (empty(conceptIndices))
        conceptIndices = null;
    }

    synchronized public void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (fieldIndices == null)
        fieldIndices = new HashMap();
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      if (map == null)
        fieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    synchronized public void removeFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      Map<String, IFieldIndex> map = mapGet(fieldIndices, c);
      mapRemove(map, field);
    }

    synchronized public IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
      if (fieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    synchronized public IFieldIndex getAnyIndexForClass(Class<? extends Concept> c) {
      return firstValue(fieldIndices == null ? null : fieldIndices.get(c));
    }

    synchronized public void addCIFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (ciFieldIndices == null)
        ciFieldIndices = new HashMap();
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      if (map == null)
        ciFieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    synchronized public void removeCIFieldIndex(Class<? extends Concept> c, String field) {
      Map<String, IFieldIndex> map = mapGet(ciFieldIndices, c);
      mapRemove(map, field);
    }

    synchronized public IFieldIndex getCIFieldIndex(Class<? extends Concept> c, String field) {
      if (ciFieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    public RC xnew(String name, Object... values) {
      return new RC(cnew(name, values));
    }

    public void xset(long id, String field, Object value) {
      xset(new RC(id), field, value);
    }

    public void xset(RC c, String field, Object value) {
      if (value instanceof RC)
        value = getConcept((RC) value);
      cset(getConcept(c), field, value);
    }

    public Object xget(long id, String field) {
      return xget(new RC(id), field);
    }

    public Object xget(RC c, String field) {
      return xgetPost(cget(getConcept(c), field));
    }

    public Object xgetPost(Object o) {
      o = deref(o);
      if (o instanceof Concept)
        return new RC((Concept) o);
      return o;
    }

    public void xdelete(long id) {
      xdelete(new RC(id));
    }

    public void xdelete(RC c) {
      getConcept(c).delete();
    }

    public void xdelete(List<RC> l) {
      for (RC c : l) xdelete(c);
    }

    public List<RC> xlist() {
      return map("toPassRef", allConcepts());
    }

    public List<RC> xlist(String className) {
      return map("toPassRef", conceptsOfType(className));
    }

    public boolean isTransient() {
      return eq(programID, "-");
    }

    public String xfullgrab() {
      if (noXFullGrab)
        throw fail("no xfullgrab (DB too large)");
      Lock __1 = lock();
      lock(__1);
      try {
        if (changes == changesWritten && !isTransient())
          return loadConceptsStructure(programID);
        return fullStructure();
      } finally {
        unlock(__1);
      }
    }

    public void xshutdown() {
      cleanKillVM();
    }

    public long xchangeCount() {
      return changes;
    }

    public int xcount() {
      return countConcepts();
    }

    public void register(Concept c) {
      ping();
      if (c._concepts == this)
        return;
      if (c._concepts != null)
        throw fail("Can't re-register");
      c.id = internalID();
      c.created = now();
      if (modifyOnCreate)
        c._setModified(c.created);
      register_phase2(c);
      vmBus_send("conceptCreated", c);
      fireChange(new ConceptCreate(c));
    }

    public void register_phase2(Concept c) {
      c._concepts = this;
      concepts.put((long) c.id, c);
      for (Concept.Ref r : c._refs()) r.index();
      c.change();
      c._onRegistered();
    }

    public void registerKeepingID(Concept c) {
      if (c._concepts == this)
        return;
      if (c._concepts != null)
        throw fail("Can't re-register");
      c._concepts = this;
      concepts.put((long) c.id, c);
      c.change();
    }

    public void conceptChanged(Concept c) {
      fireChange(new ConceptChange(c));
      if (conceptIndices != null)
        for (IConceptIndex index : clonedConceptIndices()) index.update(c);
    }

    public boolean hasUnsavedData() {
      return changes != changesWritten || savingConcepts;
    }

    synchronized public Object miscMapGet(Object key) {
      return mapGet(miscMap, key);
    }

    synchronized public Object miscMapPut(Object key, Object value) {
      if (miscMap == null)
        miscMap = new HashMap();
      return miscMap.put(key, value);
    }

    synchronized public void miscMapRemove(Object key) {
      mapRemove(miscMap, key);
    }

    synchronized public <A> A miscMapGetOrCreate(Object key, IF0<A> create) {
      if (containsKey(miscMap, key))
        return (A) miscMap.get(key);
      A value = create.get();
      miscMapPut(key, value);
      return value;
    }

    public void setParent(Concepts parent) {
      this.parent = parent;
    }

    public void fireChange(ConceptsChange change) {
      if (change == null)
        return;
      pcallFAll(onChange, change);
      fireLegacyChangeEvent();
    }

    final public void onChange(IVF1<ConceptsChange> l) {
      addChangeListener(l);
    }

    public void addChangeListener(IVF1<ConceptsChange> l) {
      syncAdd(onChange, l);
    }

    public void removeChangeListener(IVF1<ConceptsChange> l) {
      syncRemove(onChange, l);
    }

    public void addPreSave(Runnable r) {
      preSave = syncAddOrCreate(preSave, r);
    }

    public String toString() {
      return nConcepts(concepts) + " (" + conceptsDir() + ", hash: " + identityHashCode(this) + ")";
    }
  }

  public interface IConcept {

    public long _conceptID();

    public Concepts concepts();
  }

  static public class Concept extends DynamicObject implements IConcept, ChangeTriggerable {

    transient public Concepts _concepts;

    public long id;

    public long created, _modified;

    public List<Ref> backRefs;

    public Concept(String className) {
      super(className);
      _created();
    }

    public Concept() {
      if (!_loading()) {
        _created();
      }
    }

    public Concept(boolean unlisted) {
      if (!unlisted)
        _created();
    }

    public boolean includeZeroIDInToString() {
      return false;
    }

    public String toString() {
      String s = shortDynamicClassName(this);
      long id = this.id;
      if (id != 0 || includeZeroIDInToString())
        s += " " + id;
      return s;
    }

    static public boolean loading() {
      return _loading();
    }

    static public boolean _loading() {
      return dynamicObjectIsLoading();
    }

    public void _created() {
      if (!concepts_unlistedByDefault && !eq(concepts_unlisted.get(), true))
        db_mainConcepts().register(this);
    }

    public class TypedRef<A extends Concept, B> extends Ref<A> {

      public TypedRef() {
      }

      public Class<B> bType;

      public TypedRef(Class<B> bType) {
        this.bType = bType;
      }

      public TypedRef(Class<B> bType, B value) {
        this.bType = bType;
        set((A) value);
      }

      public TypedRef(B value) {
        set((A) value);
      }

      public boolean set(A a) {
        return super.set(checkValue(a));
      }

      public void check() {
        checkValue(get());
      }

      public <C> C checkValue(C a) {
        if (bType != null && a != null)
          assertIsInstance(a, bType);
        return a;
      }

      public B b() {
        return (B) value;
      }
    }

    public class Ref<A extends Concept> implements IRef<A> {

      public A value;

      public Ref() {
        if (!dynamicObjectIsLoading())
          registerRef();
      }

      public void registerRef() {
        vmBus_send("registeringConceptRef", this);
      }

      public Ref(A value) {
        this.value = value;
        registerRef();
        index();
      }

      public Concept concept() {
        return Concept.this;
      }

      public A get() {
        return value;
      }

      public boolean has() {
        return value != null;
      }

      public boolean set(A a) {
        if (a == value)
          return false;
        unindex();
        value = a;
        index();
        change();
        return true;
      }

      public void setIfEmpty(A a) {
        if (!has())
          set(a);
      }

      public void set(Ref<A> ref) {
        set(ref.get());
      }

      public void clear() {
        set((A) null);
      }

      public boolean validRef() {
        return value != null && _concepts != null && _concepts == value._concepts;
      }

      public void index() {
        if (validRef()) {
          value._addBackRef(this);
          change();
        }
      }

      public Ref<A> unindex() {
        if (validRef()) {
          value._removeBackRef(this);
          change();
        }
        return this;
      }

      public void unindexAndDrop() {
        unindex();
        _removeRef(this);
      }

      public void change() {
        Concept.this.change();
      }

      public String toString() {
        return str(value);
      }
    }

    public class RefL<A extends Concept> extends AbstractList<A> {

      public List<Ref<A>> l = new ArrayList();

      public RefL() {
      }

      public RefL(List<A> l) {
        replaceWithList(l);
      }

      public void clear() {
        while (!isEmpty()) removeLast(this);
      }

      public void replaceWithList(List<A> l) {
        clear();
        for (A a : unnullForIteration(l)) add(a);
      }

      public A set(int i, A o) {
        Ref<A> ref = syncGet(l, i);
        A prev = ref.get();
        ref.set(o);
        return prev;
      }

      public void add(int i, A o) {
        syncAdd(l, i, new Ref(o));
      }

      public A get(int i) {
        return syncGet(l, i).get();
      }

      public A remove(int i) {
        return syncRemove(l, i).get();
      }

      public int size() {
        return syncL(l);
      }

      public boolean contains(Object o) {
        if (o instanceof Concept)
          for (Ref<A> r : l) if (eq(r.get(), o))
            return true;
        return super.contains(o);
      }
    }

    public void delete() {
      for (Ref r : unnullForIteration(_refs())) r.unindex();
      for (Ref r : cloneList(backRefs)) r.set((Concept) null);
      backRefs = null;
      var _concepts = this._concepts;
      if (_concepts != null) {
        _concepts.concepts.remove(id);
        _concepts.fireChange(new ConceptDelete(id, this));
        if (_concepts.conceptIndices != null)
          for (IConceptIndex index : _concepts.conceptIndices) index.remove(this);
        this._concepts = null;
      }
      id = 0;
    }

    public BaseXRef export() {
      return new BaseXRef(_concepts.progID(), id);
    }

    final public void _change() {
      change();
    }

    public void change() {
      _setModified(now());
      _change_withoutUpdatingModifiedField();
    }

    public void _setModified(long modified) {
      _modified = modified;
    }

    final public void _change_withoutUpdatingModifiedField() {
      _onChange();
      if (_concepts != null)
        _concepts.conceptChanged(this);
    }

    public void _onChange() {
    }

    public String _programID() {
      return _concepts == null ? getDBProgramID() : _concepts.progID();
    }

    public void _addBackRef(Concept.Ref ref) {
      backRefs = addDyn_quickSync(backRefs, ref);
      _backRefsModified();
    }

    public void _backRefsModified() {
      if (_concepts != null && _concepts.modifyOnBackRef)
        change();
    }

    public void _removeBackRef(Concept.Ref ref) {
      backRefs = removeDyn_quickSync(backRefs, ref);
      _backRefsModified();
    }

    public void _removeRef(Concept.Ref ref) {
    }

    public int _backRefCount() {
      return syncL(backRefs);
    }

    final public void setField(String field, Object value) {
      _setField(field, value);
    }

    public void _setField(String field, Object value) {
      cset(this, field, value);
    }

    public boolean setField_trueIfChanged(String field, Object value) {
      return cset(this, field, value) != 0;
    }

    public <A> A setFieldAndReturn(String field, A value) {
      setField(field, value);
      return value;
    }

    final public void setFields(Object... values) {
      _setFields(values);
    }

    public void _setFields(Object... values) {
      cset(this, values);
    }

    public Concepts concepts() {
      return _concepts;
    }

    public boolean isDeleted() {
      return id == 0;
    }

    public void _doneLoading() {
    }

    public void _doneLoading2() {
      Map<String, FieldMigration> map = _fieldMigrations();
      if (map != null)
        for (Map.Entry<? extends String, ? extends FieldMigration> __0 : _entrySet(map)) {
          String oldField = __0.getKey();
          FieldMigration m = __0.getValue();
          crenameField_noOverwrite(this, oldField, m.newField);
        }
    }

    static public class FieldMigration implements IFieldsToList {

      public String newField;

      public FieldMigration() {
      }

      public FieldMigration(String newField) {
        this.newField = newField;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + newField + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof FieldMigration))
          return false;
        FieldMigration __6 = (FieldMigration) o;
        return eq(newField, __6.newField);
      }

      public int hashCode() {
        int h = 558692372;
        h = boostHashCombine(h, _hashCode(newField));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { newField };
      }
    }

    public Map<String, FieldMigration> _fieldMigrations() {
      return null;
    }

    public Collection<Ref> _refs() {
      return scanConceptForRefs(this);
    }

    public Concepts _concepts() {
      return _concepts;
    }

    public boolean _conceptsDefunct() {
      return _concepts != null && _concepts.defunct;
    }

    public boolean _conceptsDefunctOrUnregistered() {
      return _concepts == null || _concepts.defunct;
    }

    public void _onRegistered() {
    }

    public <A> boolean addAndChange(Collection<A> cl, A a) {
      if (cl == null || !cl.add(a))
        return false;
      change();
      return true;
    }

    public <A> void clearAndChange(Collection<A> cl) {
      if (cl == null)
        return;
      cl.clear();
      change();
    }

    public File conceptsDir() {
      var concepts = concepts();
      return concepts == null ? null : concepts.conceptsDir();
    }

    public File fileInConceptsDir(String name) {
      var dir = conceptsDir();
      return dir == null ? null : newFile(dir, name);
    }

    public long _conceptID() {
      return id;
    }
  }

  static public class RC {

    transient public Object owner;

    public String id;

    public RC() {
    }

    public RC(long id) {
      this.id = str(id);
    }

    public RC(Object owner, long id) {
      this.id = str(id);
      this.owner = owner;
    }

    public RC(Concept c) {
      this(c.id);
    }

    public long longID() {
      return parseLong(id);
    }

    public String toString() {
      return id;
    }

    transient public RemoteDB db;

    public String getString(String field) {
      return db.xS(this, field);
    }

    public Object get(String field) {
      return db.xget(this, field);
    }

    public void set(String field, Object value) {
      db.xset(this, field, value);
    }
  }

  static public class BaseXRef {

    public String programID;

    public long id;

    public BaseXRef() {
    }

    public BaseXRef(String programID, long id) {
      this.id = id;
      this.programID = programID;
    }

    public boolean equals(Object o) {
      if (!(o instanceof BaseXRef))
        return false;
      BaseXRef r = (BaseXRef) o;
      return eq(programID, r.programID) && eq(id, r.id);
    }

    public int hashCode() {
      return programID.hashCode() + (int) id;
    }
  }

  static public class XRef extends Concept {

    public BaseXRef ref;

    public XRef() {
    }

    public XRef(BaseXRef ref) {
      this.ref = ref;
      _doneLoading2();
    }

    public void _doneLoading2() {
      getIndex().put(ref, this);
    }

    public HashMap<BaseXRef, XRef> getIndex() {
      return getXRefIndex(_concepts);
    }
  }

  static synchronized public HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
    HashMap cache = (HashMap) concepts.perClassData().get(XRef.class);
    if (cache == null)
      concepts.perClassData.put(XRef.class, cache = new HashMap());
    return cache;
  }

  static public XRef lookupOrCreateXRef(BaseXRef ref) {
    XRef xref = getXRefIndex(db_mainConcepts()).get(ref);
    if (xref == null)
      xref = new XRef(ref);
    return xref;
  }

  static public void loadAndAutoSaveConcepts() {
    db_mainConcepts().persist();
  }

  static public void loadAndAutoSaveConcepts(int interval) {
    db_mainConcepts().persist(interval);
  }

  static public RC toPassRef(Concept c) {
    return new RC(c);
  }

  static public void concepts_setUnlistedByDefault(boolean b) {
    concepts_unlistedByDefault = b;
  }

  static public class HCRUD extends HAbstractRenderable {

    public HCRUD_Data data;

    public boolean mutationRights = true;

    public boolean allowCreateOrDelete = true;

    public boolean allowCreate = true;

    public boolean allowEdit = true;

    public boolean singleton = false;

    public boolean cmdsLeft = false;

    public boolean showEntryCountInTitle = false;

    public boolean allowFieldRenaming = false;

    public int defaultTextFieldCols = 80;

    public int valueDisplayLength = 1000;

    public String tableClass;

    public String formTableClass;

    public String checkBoxClass = "crud_chkbox";

    public String customTitle;

    public boolean showTextFieldsAsAutoExpandingTextAreas = false;

    public Set<String> unshownFields;

    public Set<String> uneditableFields;

    public Set<String> unlistedFields;

    public boolean showCheckBoxes = false;

    public boolean cleanItemIDs = false;

    public boolean haveJQuery, haveSelectizeJS, haveSelectizeClickable;

    public boolean needsJQuery = false;

    public boolean paginate = false;

    public boolean sortable = false;

    public boolean buttonsOnTop, buttonsOnBottom = true;

    public boolean duplicateInNewTab = false;

    public String formID = "crudForm";

    public boolean showQuickSaveButton = false;

    public boolean enableMultiSelect = true;

    public boolean cellColumnToolTips = false;

    public boolean showSearchField = false;

    public String searchQuery;

    public Map<String, String> params;

    public HTMLPaginator paginator = new HTMLPaginator();

    public String sortByField = "id";

    public String sortParameter = "sort";

    public boolean descending = false;

    public int flexibleLengthListLeeway = 5;

    public Object objectIDToHighlight;

    public boolean showOnlySelected = false;

    public String fieldPrefix = "f_";

    public int entryCount;

    public HCRUD() {
    }

    public HCRUD(HCRUD_Data data) {
      this.data = data;
    }

    public HCRUD(String baseLink, HCRUD_Data data) {
      this.data = data;
      this.baseLink = baseLink;
    }

    public String newLink() {
      return appendQueryToURL(baseLink, "cmd", "new");
    }

    public String deleteLink(Object id) {
      return appendQueryToURL(baseLink, "delete_" + id, 1);
    }

    public String editLink(Object id) {
      return appendQueryToURL(baseLink, "edit", id);
    }

    public String duplicateLink(Object id) {
      return appendQueryToURL(baseLink, "duplicate", id);
    }

    public void setParams(Map<String, String> params) {
      this.params = params;
      if (objectIDToHighlight == null)
        objectIDToHighlight = params.get("selectObj");
      if (eq("1", params.get("showOnlySelected")))
        showOnlySelected = true;
    }

    public String render(boolean withCmds, Map<String, String> params) {
      setParams(params);
      if (!withCmds)
        return renderTable(false);
      {
        String __3 = handleCommands(params);
        if (!empty(__3))
          return __3;
      }
      return renderMsgs(params) + divUnlessEmpty(nav()) + renderTable(withCmds);
    }

    transient public IF0<String> nav;

    public String nav() {
      return nav != null ? nav.get() : nav_base();
    }

    final public String nav_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : nav_base();
    }

    public String nav_base() {
      List<String> l = new ArrayList();
      if (actuallyAllowCreate())
        l.add(ahref(newLink(), "New " + itemName()));
      if (showSearchField)
        l.add(hInlineSearchForm("search", searchQuery, ""));
      return joinWithVBar(l);
    }

    public String handleCommands(Map<String, String> params) {
      List<String> msgs = new ArrayList();
      if (eqGet(params, "action", "create")) {
        if (!actuallyAllowCreate())
          throw fail("Creating objects not allowed");
        processRenames(params);
        Object id = data.createObject(preprocessUpdateParams(params), fieldPrefix);
        msgs.add(itemName() + " created (ID: " + id + ")");
        objectIDToHighlight = id;
      }
      if (eqGet(params, "action", "update")) {
        if (!actuallyAllowEdit())
          throw fail("Editing objects not allowed");
        String id = params.get("id");
        processRenames(params);
        msgs.add(data.updateObject(id, preprocessUpdateParams(params), fieldPrefix));
        objectIDToHighlight = id;
      }
      List<String> toDeleteList = keysDeprefixNemptyValue(params, "delete_");
      if (eq(params.get("bulkAction"), "deleteSelected"))
        toDeleteList.addAll(keysDeprefixNemptyValue(params, "obj_"));
      for (String toDelete : toDeleteList) {
        if (!actuallyAllowDelete())
          throw fail("Deleting objects not allowed");
        msgs.add(data.deleteObject(toDelete));
      }
      return empty(msgs) ? "" : refreshAfterCommand(params, msgs);
    }

    transient public IF2<Map<String, String>, List<String>, String> refreshAfterCommand;

    public String refreshAfterCommand(Map<String, String> params, List<String> msgs) {
      return refreshAfterCommand != null ? refreshAfterCommand.get(params, msgs) : refreshAfterCommand_base(params, msgs);
    }

    final public String refreshAfterCommand_fallback(IF2<Map<String, String>, List<String>, String> _f, Map<String, String> params, List<String> msgs) {
      return _f != null ? _f.get(params, msgs) : refreshAfterCommand_base(params, msgs);
    }

    public String refreshAfterCommand_base(Map<String, String> params, List<String> msgs) {
      String redirectAfterSave = mapGet(params, "redirectAfterSave");
      if (nempty(redirectAfterSave))
        return hrefresh(redirectAfterSave);
      return refreshWithMsgs(msgs, "anchor", objectIDToHighlight == null ? null : "obj" + objectIDToHighlight, "params", objectIDToHighlight == null ? null : litmap("selectObj", objectIDToHighlight));
    }

    public String encodeField(String s) {
      return or(data.fieldNameToHTML(s), s);
    }

    transient public IF2<String, Object, String> renderValue;

    public String renderValue(String field, Object value) {
      return renderValue != null ? renderValue.get(field, value) : renderValue_base(field, value);
    }

    final public String renderValue_fallback(IF2<String, Object, String> _f, String field, Object value) {
      return _f != null ? _f.get(field, value) : renderValue_base(field, value);
    }

    public String renderValue_base(String field, Object value) {
      if (value instanceof HTML)
        return ((HTML) value).html;
      value = deref(value);
      if (value instanceof SecretValue)
        return hhiddenStuff(renderValue_inner(((SecretValue) value).get()));
      return renderValue_inner(value);
    }

    transient public IF1<Object, String> renderValue_inner;

    public String renderValue_inner(Object value) {
      return renderValue_inner != null ? renderValue_inner.get(value) : renderValue_inner_base(value);
    }

    final public String renderValue_inner_fallback(IF1<Object, String> _f, Object value) {
      return _f != null ? _f.get(value) : renderValue_inner_base(value);
    }

    public String renderValue_inner_base(Object value) {
      if (value instanceof Boolean)
        return yesNo_short((Boolean) value);
      return htmlEncode_nlToBr_withIndents(shorten(valueDisplayLength, strOrEmpty(value)));
    }

    public String renderTable(boolean withCmds) {
      return renderTable(withCmds, data.list());
    }

    public String valueToSortable(Object value) {
      if (value instanceof HTML)
        return ((HTML) value).get();
      return strOrNull(value);
    }

    public String renderTable(boolean withCmds, List<Map<String, Object>> l) {
      entryCount = l(l);
      if (empty(l))
        return p("No entries");
      if (!eq(data.defaultSortField(), pair(sortByField, descending))) {
        if (nempty(sortByField)) {
          print("Sorting " + nEntries(l) + " by " + sortByField);
          l = sortByTransformedMapKey_alphaNum(__89 -> valueToSortable(__89), l, sortByField);
        }
        if (descending)
          l = reversed(l);
      }
      Map<String, String> keyEncoding = new HashMap();
      List<Map<String, Object>> l2 = lazyMap(l, _map -> {
        Object id = itemID(_map);
        return data.new Item(id) {

          public Map<String, Object> calcFullMap() {
            Map<String, Object> map = _map;
            map = mapMinusKeys(map, joinSets(unshownFields, unlistedFields));
            Map<String, Object> map2 = postProcessTableRow(map, mapToMap((key, value) -> pair(mapPut_returnValue(keyEncoding, key, encodeField(key)), renderValue(key, value)), map));
            if (singleton)
              map2.remove(encodeField(data.idField()));
            if (withCmds)
              map2 = addCmdsToTableRow(map, map2);
            map2.put(firstKey(map2), aname("obj" + id, firstValue(map2)));
            return map2;
          }
        };
      });
      List<String> out = new ArrayList();
      if (paginate) {
        paginator.processParams(params);
        paginator.baseLink = addParamsToURL(baseLink, filterKeys(__90 -> keepParamInPagination(__90), params));
        paginator.max = l(l2);
        out.add(divUnlessEmpty(paginator.renderNav()));
        List<Map<String, Object>> l3 = subListOrFull(l2, paginator.visibleRange());
        if (objectIDToHighlight != null && (showOnlySelected || !any(__63 -> isHighlighted(__63), l3))) {
          l3 = llNonNulls(firstThat(__64 -> isHighlighted(__64), l2));
        }
        l2 = l3;
      }
      Map<String, String> replaceHeaders = new HashMap();
      if (sortable && !singleton)
        for (Map.Entry<? extends String, ? extends String> __1 : _entrySet(keyEncoding)) {
          String key = __1.getKey();
          String html = __1.getValue();
          boolean sortedByField = eq(sortByField, key);
          boolean showDescendingLink = sortedByField && !descending;
          String htmlOld = html;
          if (sortedByField) {
            String title = showDescendingLink ? "Click here to sort descending" : "Click here to sort ascending";
            String titleSorted = "Sorted by this field (" + (descending ? "descending" : "ascending") + ")";
            title = titleSorted + ". " + title;
            html = span_title(title, unicode_downOrUpPointingTriangle(descending)) + " " + html;
          }
          String sortLink = appendQueryToURL(baseLink, sortParameter, showDescendingLink ? "-" + key : key);
          replaceHeaders.put(htmlOld, ahref(sortLink, html));
        }
      Map<String, Object[]> paramsByColName = null;
      if (cellColumnToolTips) {
        paramsByColName = new HashMap();
        for (Map<String, Object> map : l2) for (String key : keys(map)) if (!paramsByColName.containsKey(key))
          paramsByColName.put(key, litobjectarray("title", nullIfEmpty(htmldecode_dropTagsAndComments(key))));
      }
      out.add(hpostform(htmlTable2_noHtmlEncode(l2, paramsPlus(tableParams(), "replaceHeaders", replaceHeaders, "paramsByColName", paramsByColName)) + (!withCmds || !showCheckBoxes ? "" : "\n" + divUnlessEmpty(renderBulkCmds())), "action", baseLink));
      if (showCheckBoxes && haveJQuery && enableMultiSelect)
        out.add(hCheckBoxMultiSelect_v2());
      return lines_rtrim(out);
    }

    public Object mapToID(Map<String, Object> item) {
      return item == null ? null : dropAllTags(strOrNull(item.get(encodeField(idField()))));
    }

    public boolean isHighlighted(Map<String, Object> item) {
      Object id = mapToID(item);
      return eq(id, objectIDToHighlight);
    }

    transient public IF0<String> renderBulkCmds;

    public String renderBulkCmds() {
      return renderBulkCmds != null ? renderBulkCmds.get() : renderBulkCmds_base();
    }

    final public String renderBulkCmds_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : renderBulkCmds_base();
    }

    public String renderBulkCmds_base() {
      return "Bulk action: " + hselect("bulkAction", litorderedmap("", "", "deleteSelected", "Delete selected")) + " " + hsubmit("OK", "onclick", "return confirm('Are you sure?')");
    }

    public Map<String, Object> addCmdsToTableRow(Map<String, Object> map, Map<String, Object> map2) {
      if (showCheckBoxes) {
        Object id = itemID(map);
        map2.put(checkBoxKey(), hcheckbox("obj_" + id, false, "title", "Select this object for a bulk action", "class", checkBoxClass));
        map2 = putKeysFirst(map2, checkBoxKey());
      }
      map2.put(cmdsKey(), renderCmds(map));
      if (cmdsLeft)
        map2 = putKeysFirst(map2, cmdsKey());
      return map2;
    }

    public Object[] tableParams() {
      return litparams("tdParams", litparams("valign", "top"), "tableParams", litparams("class", tableClass));
    }

    public String renderForm(Map<String, Object> map) {
      AutoCloseable __5 = tempSetTL(htmlencode_forParams_useV2, true);
      try {
        map = mapMinusKeys(map, joinSets(unshownFields, uneditableFields, data.filteredFields()));
        Map<String, Object> mapWithoutID = mapWithoutKey(map, data.idField());
        List<List<String>> matrix = map(mapWithoutID, (field, value) -> {
          String help = data.fieldHelp(field);
          return ll(allowFieldRenaming ? hinputfield("rename_" + field, field, "class", "field-rename", "style", "border: none; text-align: right", "title", "Edit this to rename field " + quote(field) + " or clear to delete field") : encodeField(field), addHelpText(help, renderInput(field, value)));
        });
        massageFormMatrix(map, matrix);
        return htableRaw_valignTop(matrix, empty(formTableClass) ? litparams("border", 1, "cellpadding", 4) : litparams("class", formTableClass));
      } finally {
        _close(__5);
      }
    }

    public String renderInput(String field, Object value) {
      String name = fieldPrefix + field;
      return renderInput(name, data.getRenderer(field, value), value);
    }

    public String renderInput(String name, HCRUD_Data.Renderer r, Object value) {
      if (r != null)
        value = r.preprocessValue(value);
      String meta = r == null ? "" : renderMetaInfo(r.metaInfo, name);
      if (r instanceof HCRUD_Data.AceEditor) {
        HTMLAceEditor ace = new HTMLAceEditor(strOrEmpty(value));
        ace.name = name;
        ace.divParams.put("style", "width: " + ((HCRUD_Data.AceEditor) r).cols + "ch; height: " + ((HCRUD_Data.AceEditor) r).rows + "em");
        customizeACEEditor(ace);
        return meta + ace.headStuff() + ace.html();
      }
      if (r instanceof HCRUD_Data.TextArea)
        return meta + htextarea(strOrEmpty(value), "name", name, "cols", ((HCRUD_Data.TextArea) r).cols, "rows", ((HCRUD_Data.TextArea) r).rows);
      if (r instanceof HCRUD_Data.TextField)
        return meta + renderTextField(name, strOrEmpty(value), ((HCRUD_Data.TextField) r).cols);
      if (r instanceof HCRUD_Data.ComboBox)
        return meta + renderComboBox(name, ((HCRUD_Data.ComboBox) r).valueToEntry(value), ((HCRUD_Data.ComboBox) r).entries, ((HCRUD_Data.ComboBox) r).editable);
      if (r instanceof HCRUD_Data.DynamicComboBox)
        return meta + renderDynamicComboBox(name, ((HCRUD_Data.DynamicComboBox) r).valueToEntry(value), ((HCRUD_Data.DynamicComboBox) r).info, ((HCRUD_Data.DynamicComboBox) r).editable, ((HCRUD_Data.DynamicComboBox) r).url);
      if (r instanceof HCRUD_Data.CheckBox)
        return meta + htrickcheckboxWithText(name, "", isTrue(value));
      if (r instanceof HCRUD_Data.FlexibleLengthList) {
        List list = (List) value;
        List<String> rows = new ArrayList();
        int n = l(list) + flexibleLengthListLeeway;
        for (int i = 0; i < n; i++) {
          Object item = _get(list, i);
          rows.add(tr(td(i + 1 + ".", "align", "right") + td(renderInput(name + "_" + i, ((HCRUD_Data.FlexibleLengthList) r).itemRenderer, item))));
        }
        return meta + htag("table", lines(rows));
      }
      if (r instanceof HCRUD_Data.NotEditable)
        return "Not editable";
      return renderInput_default(name, value);
    }

    transient public IVF1<HTMLAceEditor> customizeACEEditor;

    public void customizeACEEditor(HTMLAceEditor ace) {
      if (customizeACEEditor != null)
        customizeACEEditor.get(ace);
      else
        customizeACEEditor_base(ace);
    }

    final public void customizeACEEditor_fallback(IVF1<HTMLAceEditor> _f, HTMLAceEditor ace) {
      if (_f != null)
        _f.get(ace);
      else
        customizeACEEditor_base(ace);
    }

    public void customizeACEEditor_base(HTMLAceEditor ace) {
    }

    public String renderMetaInfo(String metaInfo, String name) {
      if (empty(metaInfo))
        return "";
      return hhidden("metaInfo_" + dropPrefix(fieldPrefix, name), metaInfo);
    }

    public String renderInput_default(String name, Object value) {
      return renderTextField(name, strOrEmpty(value), defaultTextFieldCols);
    }

    public String renderTextField(String name, String value, int cols) {
      if (showTextFieldsAsAutoExpandingTextAreas) {
        return htextarea(value, "name", name, "class", "auto-expand", "style", "width: " + cols + "ch", "autofocus", eq(mapGet(params, "autofocus"), name) ? html_valueLessParam() : null, "onkeydown", jquery_submitFormOnCtrlEnter());
      }
      return htextfield(name, value, "size", cols, "style", "font-family: monospace");
    }

    public String renderNewForm() {
      return renderNewForm(data.emptyObject());
    }

    public String renderNewFormWithParams(Map<String, String> params) {
      Map<String, String> filteredMap = subMapStartingWith_dropPrefix(params, fieldPrefix);
      Map<String, Object> map = joinMaps(data.emptyObject(), (Map) filteredMap);
      data.rawFormValues = params;
      for (Map.Entry<? extends String, ? extends String> __0 : _entrySet(filteredMap)) {
        String key = __0.getKey();
        String value = __0.getValue();
        List<String> l = splitAt(key, "_");
        if (l(l) == 2) {
          String field = first(l);
          int idx = parseInt(second(l));
          List<String> list = (List<String>) (map.get(field));
          if (!(list instanceof ArrayList))
            map.put(field, list = new ArrayList());
          listPut(list, idx, value);
        }
      }
      return renderNewForm(map);
    }

    public String renderNewForm(Map<String, Object> map) {
      String buttons = p(hsubmit("Create"));
      return hpostform(hhidden("action", "create") + formExtraHiddens() + stringIf(buttonsOnTop, buttons) + renderForm(map) + stringIf(buttonsOnBottom, buttons), paramsPlus(formParameters(), "action", baseLink));
    }

    transient public IF0<Object[]> formParameters;

    public Object[] formParameters() {
      return formParameters != null ? formParameters.get() : formParameters_base();
    }

    final public Object[] formParameters_fallback(IF0<Object[]> _f) {
      return _f != null ? _f.get() : formParameters_base();
    }

    public Object[] formParameters_base() {
      return litparams("id", formID);
    }

    public String idField() {
      return data.idField();
    }

    public String renderEditForm(String id) {
      if (!actuallyAllowEdit())
        return "Can't edit objects in this table";
      if (!data.objectCanBeEdited(id))
        return htmlEncode2("Object " + id + " can't be edited");
      Map<String, Object> map = data.getObjectForEdit(id);
      if (map == null)
        return htmlEncode2("Entry " + id + " not found");
      String onlyFields = mapGet(params, "onlyFields");
      if (nempty(onlyFields))
        map = onlyKeys(map, itemPlus(idField(), tok_identifiersOnly(onlyFields)));
      String buttons = p_vbar(hsubmit("Save changes"), !showQuickSaveButton ? "" : hbuttonOnClick_noSubmit("Save & keep editing", "\r\n          $.ajax({\r\n            type: 'POST',\r\n            url: $('#crudForm').attr('action'),\r\n            data: $('#crudForm').serialize(), \r\n            success: function(response) { successNotification(\"Saved\"); },\r\n          }).error(function() { errorNotification(\"Couldn't save\"); });\r\n        "), deleteObjectHTML(id));
      return hpostform(hhidden("action", "update") + formExtraHiddens() + hhidden("id", id) + p("Object ID: " + htmlEncode2(id)) + stringIf(buttonsOnTop, buttons) + renderForm(map) + stringIf(buttonsOnBottom, buttons), paramsPlus(formParameters(), "action", baseLink + "#obj" + id));
    }

    public String renderPage(Map<String, String> params) {
      setParams(params);
      {
        String __4 = handleComboSearch(params);
        if (!empty(__4))
          return __4;
      }
      if (eqGet(params, "cmd", "new")) {
        if (!actuallyAllowCreate())
          return "Can't create objects in ths table";
        return frame(customTitleOr("New " + itemName()), renderNewFormWithParams(params));
      }
      if (nempty(params.get("edit")))
        return frame("Edit " + itemName(), renderEditForm(params.get("edit")));
      if (nempty(params.get("duplicate")))
        return frame("New " + itemName(), renderNewForm(data.getObjectForDuplication(params.get("duplicate"))));
      String rendered = render(mutationRights, params);
      String title = null;
      if (singleton)
        title = ahref(baseLink, firstToUpper(data.itemName()));
      else {
        if (objectIDToHighlight != null)
          title = data.titleForObjectID(objectIDToHighlight);
        if (empty(title))
          title = (showEntryCountInTitle ? n2(entryCount) + " " : "") + ahref(baseLink, firstToUpper(data.itemNamePlural()));
      }
      return frame(customTitleOr(title), rendered);
    }

    public HCRUD makeFrame(MakeFrame makeFrame) {
      super.makeFrame(makeFrame);
      return this;
    }

    public String cmdsKey() {
      return "<!-- cmds -->";
    }

    public String checkBoxKey() {
      return "<!-- checkbox -->";
    }

    public String itemName() {
      return data.itemName();
    }

    transient public IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> postProcessTableRow;

    public Map<String, Object> postProcessTableRow(Map<String, Object> data, Map<String, Object> rendered) {
      return postProcessTableRow != null ? postProcessTableRow.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    final public Map<String, Object> postProcessTableRow_fallback(IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> _f, Map<String, Object> data, Map<String, Object> rendered) {
      return _f != null ? _f.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    public Map<String, Object> postProcessTableRow_base(Map<String, Object> data, Map<String, Object> rendered) {
      return rendered;
    }

    public Object itemID(Map<String, Object> item) {
      Object id = mapGet(item, data.idField());
      if (cleanItemIDs)
        id = htmlDecode_dropTags(strOrNull(getVarOpt(id)));
      return id;
    }

    public long itemIDAsLong(Map<String, Object> item) {
      return parseLong(itemID(item));
    }

    transient public IF1<Map<String, Object>, List<String>> additionalCmds;

    public List<String> additionalCmds(Map<String, Object> item) {
      return additionalCmds != null ? additionalCmds.get(item) : additionalCmds_base(item);
    }

    final public List<String> additionalCmds_fallback(IF1<Map<String, Object>, List<String>> _f, Map<String, Object> item) {
      return _f != null ? _f.get(item) : additionalCmds_base(item);
    }

    public List<String> additionalCmds_base(Map<String, Object> item) {
      return null;
    }

    transient public IF1<Map<String, Object>, String> renderCmds;

    public String renderCmds(Map<String, Object> item) {
      return renderCmds != null ? renderCmds.get(item) : renderCmds_base(item);
    }

    final public String renderCmds_fallback(IF1<Map<String, Object>, String> _f, Map<String, Object> item) {
      return _f != null ? _f.get(item) : renderCmds_base(item);
    }

    public String renderCmds_base(Map<String, Object> item) {
      Object id = itemID(item);
      List<String> additionalCmds = additionalCmds(item);
      return joinNemptiesWithVBar(!actuallyAllowEdit() || !data.objectCanBeEdited(id) ? null : ahref(editLink(id), "EDIT"), deleteObjectHTML(id), !actuallyAllowCreate() ? null : targetBlankIf(duplicateInNewTab, duplicateLink(id), "dup", "title", "duplicate"), empty(additionalCmds) ? null : hPopDownButton(additionalCmds));
    }

    public boolean actuallyAllowCreate() {
      return !singleton && allowCreateOrDelete && allowCreate;
    }

    public boolean actuallyAllowEdit() {
      return allowCreateOrDelete && allowEdit;
    }

    public boolean actuallyAllowDelete() {
      return !singleton && allowCreateOrDelete;
    }

    transient public IVF2<Map<String, Object>, List<List<String>>> massageFormMatrix;

    public void massageFormMatrix(Map<String, Object> map, List<List<String>> matrix) {
      if (massageFormMatrix != null)
        massageFormMatrix.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    final public void massageFormMatrix_fallback(IVF2<Map<String, Object>, List<List<String>>> _f, Map<String, Object> map, List<List<String>> matrix) {
      if (_f != null)
        _f.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    public void massageFormMatrix_base(Map<String, Object> map, List<List<String>> matrix) {
    }

    public String renderComboBox(String name, String value, List<String> entries, boolean editable) {
      if (haveSelectizeJS) {
        String id = aGlobalID();
        return hselect_list(entries, value, "name", name, "id", id) + hjs("$('#" + id + "').selectize" + "\r\n          ({\r\n            searchField: 'text',\r\n            openOnFocus: true,\r\n            dropdownParent: 'body',\r\n            create: " + jsBool(editable) + "\r\n            /*allowEmptyOption: true*/\r\n            " + unnull(moreSelectizeOptions2(name)) + "\r\n          });\r\n        ") + selectizeLayoutFix();
      }
      if (haveJQuery) {
        String id = aGlobalID();
        return tag("datalist", mapToLines(__65 -> hoption(__65), entries), "id", id) + tag("input", "", "name", name, "list", id);
      }
      if (editable)
        return hinputfield(name, value);
      return hselect_list(entries, value, "name", name);
    }

    public String renderDynamicComboBox(String name, String value, String info, boolean editable) {
      return renderDynamicComboBox(name, value, info, editable, null);
    }

    public String renderDynamicComboBox(String name, String value, String info, boolean editable, String url) {
      assertTrue("haveSelectizeJS", haveSelectizeJS);
      String id = aGlobalID();
      String ajaxURL = or2(url, baseLink);
      return hselect_list(llNempties(value), value, "name", name, "id", id) + hjs("$('#" + id + "').selectize" + "\r\n        ({\r\n          searchField: 'text',\r\n          valueField: 'text',\r\n          labelField: 'text',\r\n          openOnFocus: true,\r\n          dropdownParent: 'body',\r\n          create: " + jsBool(editable) + ",\r\n          load: function(query, callback) {\r\n            if (!query.length) return callback();\r\n            var data = {\r\n              comboSearchInfo: " + jsQuote(info) + ",\r\n              comboSearchQuery: query\r\n            };\r\n            console.log(\"Loading \" + " + jsQuote(baseLink) + " + \" with \" + JSON.stringify(data));\r\n            $.ajax({\r\n              url: " + jsQuote(ajaxURL) + ",\r\n              type: 'GET',\r\n              dataType: 'json',\r\n              data: data,\r\n              error: function() {\r\n                console.log(\"Got error\");\r\n                callback();\r\n              },\r\n              success: function(res) {\r\n                //console.log(\"Got data: \" + res);\r\n                var converted = res.map(x => { return {text: x}; });\r\n                //console.log(\"Converted: \" + converted);\r\n                callback(converted);\r\n              }\r\n            });\r\n          }\r\n          /*allowEmptyOption: true*/\r\n          " + moreSelectizeOptions2(name) + "\r\n        });\r\n      ") + selectizeLayoutFix();
    }

    public void processSortParameter(Map<String, String> params) {
      String sort = mapGet(params, sortParameter);
      if (nempty(sort))
        if (startsWith(sort, "-")) {
          descending = true;
          sortByField = substring(sort, 1);
        } else {
          descending = false;
          sortByField = sort;
        }
    }

    public String deleteObjectHTML(Object id) {
      return !actuallyAllowDelete() ? null : !data.objectCanBeDeleted(id) ? span_title("Object can't be deleted, either there are references to it or you are not authorized", htmlEncode2(unicode_DEL())) : ahrefWithConfirm("Really delete item " + id + "?", deleteLink(id), htmlEncode2(unicode_DEL()), "title", "delete");
    }

    public String addHelpText(String helpText, String html) {
      return empty(helpText) ? html : html + p(small(helpText), "style", "text-align: right");
    }

    public String moreSelectizeOptions2(String name) {
      return unnull(moreSelectizeOptions(name)) + (!haveSelectizeClickable ? "" : "\r\n        , plugins: ['clickable']\r\n        , render: {\r\n            option: function(item) {\r\n              var id = item.text.match(/\\d+/)[0];\r\n              return '<div><span>'+item.text+'</span>'\r\n                  + '<div style=\"float: right\">'\r\n                  + '<a title=\"Go to object\" class=\"clickable\" href=\"/' + id + '\" target=\"_blank\">&#8599;</a>'\r\n                  + '</div></div>';\r\n            }\r\n          }\r\n        ");
    }

    transient public IF1<String, String> moreSelectizeOptions;

    public String moreSelectizeOptions(String name) {
      return moreSelectizeOptions != null ? moreSelectizeOptions.get(name) : moreSelectizeOptions_base(name);
    }

    final public String moreSelectizeOptions_fallback(IF1<String, String> _f, String name) {
      return _f != null ? _f.get(name) : moreSelectizeOptions_base(name);
    }

    public String moreSelectizeOptions_base(String name) {
      return "";
    }

    public String handleComboSearch(Map<String, String> params) {
      String query = params.get("comboSearchQuery");
      if (nempty(query)) {
        String info = params.get("comboSearchInfo");
        return jsonEncode_shallowLineBreaks(data.comboBoxSearch(info, query));
      }
      return null;
    }

    transient public IF1<Map<String, String>, Map<String, String>> preprocessUpdateParams;

    public Map<String, String> preprocessUpdateParams(Map<String, String> params) {
      return preprocessUpdateParams != null ? preprocessUpdateParams.get(params) : preprocessUpdateParams_base(params);
    }

    final public Map<String, String> preprocessUpdateParams_fallback(IF1<Map<String, String>, Map<String, String>> _f, Map<String, String> params) {
      return _f != null ? _f.get(params) : preprocessUpdateParams_base(params);
    }

    public Map<String, String> preprocessUpdateParams_base(Map<String, String> params) {
      return params;
    }

    public void disableAllMutationRights() {
      mutationRights = allowCreateOrDelete = allowCreate = allowEdit = false;
    }

    transient public IF1<String, Boolean> keepParamInPagination;

    public boolean keepParamInPagination(String name) {
      return keepParamInPagination != null ? keepParamInPagination.get(name) : keepParamInPagination_base(name);
    }

    final public boolean keepParamInPagination_fallback(IF1<String, Boolean> _f, String name) {
      return _f != null ? _f.get(name) : keepParamInPagination_base(name);
    }

    public boolean keepParamInPagination_base(String name) {
      return eq(name, "search");
    }

    public String customTitleOr(String title) {
      return or2(customTitle, or2(mapGet(params, "title"), title));
    }

    transient public IF0<String> selectizeLayoutFix;

    public String selectizeLayoutFix() {
      return selectizeLayoutFix != null ? selectizeLayoutFix.get() : selectizeLayoutFix_base();
    }

    final public String selectizeLayoutFix_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : selectizeLayoutFix_base();
    }

    public String selectizeLayoutFix_base() {
      return hcss(".selectize-input, .selectize-control { min-width: 300px }");
    }

    public String formExtraHiddens() {
      String redirectAfterSave = mapGet(params, "redirectAfterSave");
      return empty(redirectAfterSave) ? "" : hhidden("redirectAfterSave", redirectAfterSave);
    }

    public void processRenames(Map<String, String> params) {
      if (!allowFieldRenaming)
        return;
      for (String key1 : keysList(params)) {
        String field = dropPrefixOrNull("rename_", key1);
        if (field == null)
          continue;
        String newName = trim(params.get(key1));
        if (newName == null || eq(field, newName))
          continue;
        print("Renaming " + field + " to " + or2(newName, "<deleted>"));
        params.remove("rename_" + field);
        String re = "^([^_]+_)" + regexpQuote(field) + "(_[^_]+)?$";
        for (String key : keysList(params)) {
          List<String> groups = regexpGroups(re, key);
          if (groups != null) {
            String newKey = empty(newName) ? null : first(groups) + newName + unnull(second(groups));
            mapPut(params, newKey, params.get(key));
            params.put(key, "");
            print("Renaming key: " + key + " => " + newKey);
          }
        }
      }
    }
  }

  static public class AppendableChain<A> extends MinimalChain<A> implements Iterable<A> {

    public MinimalChain<A> last;

    public int size;

    public AppendableChain() {
    }

    public AppendableChain(A element) {
      this.element = element;
      size = 1;
      last = this;
    }

    public AppendableChain(A element, AppendableChain<A> next) {
      this.next = next;
      this.element = element;
      if (next == null)
        return;
      MinimalChain<A> b = new MinimalChain();
      b.element = next.element;
      b.next = next.next;
      this.next = b;
      last = next.last;
      size = next.size + 1;
    }

    public String toString() {
      return str(toList());
    }

    public boolean add(A a) {
      MinimalChain newLast = new MinimalChain(a);
      last.next = newLast;
      last = newLast;
      ++size;
      return true;
    }

    public AppendableChain<A> popFirst() {
      if (next == null)
        return null;
      element = next.element;
      if (last == next)
        last = this;
      next = next.next;
      --size;
      return this;
    }

    public ArrayList<A> toList() {
      ArrayList<A> l = emptyList(size);
      MinimalChain<A> c = this;
      while (c != null) {
        l.add(c.element);
        c = c.next;
      }
      return l;
    }

    public class ACIt extends IterableIterator<A> {

      public MinimalChain<A> c = AppendableChain.this;

      public boolean hasNext() {
        return c != null;
      }

      public A next() {
        var a = c.element;
        c = c.next;
        return a;
      }
    }

    public IterableIterator<A> iterator() {
      return new ACIt();
    }
  }

  final static public class ConceptFieldIndexDesc<A extends Concept, Val> extends ConceptFieldIndexBase<A, Val> {

    public ConceptFieldIndexDesc(Class<A> cc, String field) {
      super(cc, field);
    }

    public ConceptFieldIndexDesc(Concepts concepts, Class<A> cc, String field) {
      super(concepts, cc, field);
    }

    public void init() {
      valueToObject = treeMultiSetMap(reverseOrder());
    }

    public void register() {
      concepts.addFieldIndex(cc, field, this);
    }

    public void close() {
      concepts.removeFieldIndex(cc, field, this);
      super.close();
    }

    synchronized public List<A> objectsWithValueGreaterThan(Object value) {
      SortedMap<Object, Set<A>> subMap = ((SortedMap<Object, Set<A>>) valueToObject.data).headMap(value);
      return concatLists(values(subMap));
    }
  }

  static public class Fail extends RuntimeException implements IFieldsToList {

    public Object[] objects;

    public Fail() {
    }

    public Fail(Object... objects) {
      this.objects = objects;
    }

    public Object[] _fieldsToList() {
      return new Object[] { objects };
    }

    public Fail(Throwable cause, Object... objects) {
      super(cause);
      this.objects = objects;
    }

    public String toString() {
      return joinNemptiesWithColon("Fail", commaCombine(getCause(), objects));
    }
  }

  static public class Rect implements WidthAndHeight, IFieldsToList {

    static final public String _fieldOrder = "x y w h";

    public int x;

    public int y;

    public int w;

    public int h;

    public Rect() {
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Rect))
        return false;
      Rect __1 = (Rect) o;
      return x == __1.x && y == __1.y && w == __1.w && h == __1.h;
    }

    public int hashCode() {
      int h = 2543108;
      h = boostHashCombine(h, _hashCode(x));
      h = boostHashCombine(h, _hashCode(y));
      h = boostHashCombine(h, _hashCode(w));
      h = boostHashCombine(h, _hashCode(h));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { x, y, w, h };
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(Pt p, int w, int h) {
      this.h = h;
      this.w = w;
      x = p.x;
      y = p.y;
    }

    public Rect(Rect r) {
      x = r.x;
      y = r.y;
      w = r.w;
      h = r.h;
    }

    final public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    final public int x1() {
      return x;
    }

    final public int y1() {
      return y;
    }

    final public int x2() {
      return x + w;
    }

    final public int y2() {
      return y + h;
    }

    final public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    final public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    final public boolean contains(Rectangle r) {
      return rectContains(this, r);
    }

    final public boolean empty() {
      return w <= 0 || h <= 0;
    }

    final public int getWidth() {
      return w;
    }

    final public int getHeight() {
      return h;
    }

    final public int area() {
      return w * h;
    }
  }

  static public class ProgramScan {

    static public int threads = isWindows() ? 500 : 10;

    static public int timeout = 5000;

    static public String ip = "127.0.0.1";

    static public int quickScanFrom = 10000, quickScanTo = 10999;

    static public int maxNumberOfVMs_android = 4;

    static public int maxNumberOfVMs_nonAndroid = 50;

    static public int maxNumberOfVMs;

    static public boolean verbose = false;

    static public class Program {

      public int port;

      public String helloString;

      public Program(int port, String helloString) {
        this.helloString = helloString;
        this.port = port;
      }
    }

    static public List<Program> scan() {
      try {
        return scan(1, 65535);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public List<Program> scan(int fromPort, int toPort) {
      return scan(fromPort, toPort, new int[0]);
    }

    static public List<Program> scan(int fromPort, int toPort, int[] preferredPorts) {
      try {
        Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
        int scanSize = toPort - fromPort + 1;
        String name = toPort < 10000 ? "bot" : "program";
        int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
        final ExecutorService es = Executors.newFixedThreadPool(threads);
        if (verbose)
          print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
        startTiming();
        List<Future<Program>> futures = new ArrayList();
        List<Integer> ports = new ArrayList();
        for (int port : preferredPorts) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        for (int port = fromPort; port <= toPort; port++) if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        es.shutdown();
        List<Program> programs = new ArrayList();
        long time = now();
        int i = 0;
        for (final Future<Program> f : futures) {
          if (verbose)
            print("Waiting for port " + get(ports, i++) + " at time " + (now() - time));
          Program p = f.get();
          if (p != null)
            programs.add(p);
        }
        if (verbose)
          print("Found " + programs.size() + " " + name + "(s) on " + ip);
        return programs;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
      return es.submit(new Callable<Program>() {

        @Override
        public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
      });
    }

    static public List<Program> quickScan() {
      return scan(quickScanFrom, quickScanTo);
    }

    static public List<Program> quickBotScan() {
      return quickBotScan(new int[0]);
    }

    static public List<Program> quickBotScan(int[] preferredPorts) {
      if (maxNumberOfVMs == 0)
        maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
      return scan(4999, 5000 + maxNumberOfVMs - 1, preferredPorts);
    }
  }

  static public class Pt implements Comparable<Pt>, IDoublePt {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return o instanceof Pt && x == ((Pt) o).x && y == ((Pt) o).y;
    }

    public int hashCode() {
      return boostHashCombine(x, y);
    }

    public int compareTo(Pt p) {
      if (y != p.y)
        return cmp(y, p.y);
      return cmp(x, p.x);
    }

    public String toString() {
      return x + ", " + y;
    }

    public double length() {
      return sqrt(x * x + y * y);
    }

    public Pt minus(Pt p) {
      return ptMinus(this, p);
    }

    public double x_double() {
      return x;
    }

    public double y_double() {
      return y;
    }
  }

  static public class ConceptFieldIndex<A extends Concept, Val> extends ConceptFieldIndexBase<A, Val> {

    public ConceptFieldIndex(Class<A> cc, String field) {
      super(cc, field);
    }

    public ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) {
      super(concepts, cc, field);
    }

    public void init() {
      valueToObject = new MultiSetMap();
    }

    public void register() {
      concepts.addFieldIndex(cc, field, this);
    }
  }

  static public interface IRef<A> extends IF0<A> {

    public default void replaceValue(A oldValue, A newValue) {
    }
  }

  static abstract public class F0<A> {

    abstract public A get();
  }

  static abstract public class F1<A, B> {

    abstract public B get(A a);
  }

  static abstract public class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  static public class TreeMultiMap<A, B> extends MultiMap<A, B> {

    public TreeMultiMap() {
      super(true);
    }

    public TreeMultiMap(MultiMap<A, B> map) {
      this();
      putAll(map);
    }
  }

  static public class Flag implements Runnable {

    public boolean up = false;

    public synchronized boolean raise() {
      if (!up) {
        up = true;
        notifyAll();
        return true;
      } else
        return false;
    }

    public synchronized void waitUntilUp() {
      try {
        while (!up) {
          wait();
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public boolean waitUntilUp(double timeout) {
      if (timeout == infinity()) {
        waitUntilUp();
        return isUp();
      } else
        return waitUntilUp(toMS(timeout));
    }

    public synchronized boolean waitUntilUp(long timeout) {
      try {
        if (!up) {
          wait(timeout);
        }
        return isUp();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public synchronized boolean isUp() {
      return up;
    }

    public boolean get() {
      return isUp();
    }

    public String toString() {
      return isUp() ? "up" : "down";
    }

    public void waitForThisOr(Flag otherFlag) {
      try {
        while (!isUp() && !otherFlag.isUp()) Thread.sleep(50);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void run() {
      raise();
    }
  }

  static public class GoogleAccess {

    public GoogleCredential credential;

    public HttpTransport transport_cache;

    public HttpTransport transport() {
      if (transport_cache == null)
        transport_cache = transport_load();
      return transport_cache;
    }

    public HttpTransport transport_load() {
      try {
        return GoogleNetHttpTransport.newTrustedTransport();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public JsonFactory jsonFactory_cache;

    public JsonFactory jsonFactory() {
      if (jsonFactory_cache == null)
        jsonFactory_cache = jsonFactory_load();
      return jsonFactory_cache;
    }

    public JsonFactory jsonFactory_load() {
      try {
        return JacksonFactory.getDefaultInstance();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public GoogleClientSecrets clientSecrets_cache;

    public GoogleClientSecrets clientSecrets() {
      if (clientSecrets_cache == null)
        clientSecrets_cache = clientSecrets_load();
      return clientSecrets_cache;
    }

    public GoogleClientSecrets clientSecrets_load() {
      try {
        InputStream in = newFileInputStream(javaxSecretDir("google-botcompany-credentials.json"));
        try {
          return GoogleClientSecrets.load(jsonFactory(), new InputStreamReader(in));
        } finally {
          _close(in);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public GoogleCredential credentialFromTokens(String accessToken, String refreshToken) {
      return credential = new GoogleCredential.Builder().setTransport(transport()).setJsonFactory(jsonFactory()).setClientSecrets(clientSecrets()).build().setAccessToken(accessToken).setRefreshToken(refreshToken);
    }

    public GoogleCredential credentialFromJavaXSecret() {
      try {
        return GoogleCredential.fromStream(fileInputStream(assertFileExists(javaxSecretDir("google-access.json"))));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class SynchronizedNavigableMap<K, V> extends SynchronizedSortedMap<K, V> implements NavigableMap<K, V> {

    public SynchronizedNavigableMap() {
    }

    public NavigableMap<K, V> innerMap() {
      return (NavigableMap) m;
    }

    public SynchronizedNavigableMap(NavigableMap<K, V> m) {
      super(m);
    }

    public SynchronizedNavigableMap(NavigableMap<K, V> m, Object mutex) {
      super(m, mutex);
    }

    public Entry<K, V> lowerEntry(K key) {
      synchronized (mutex) {
        return innerMap().lowerEntry(key);
      }
    }

    public K lowerKey(K key) {
      synchronized (mutex) {
        return innerMap().lowerKey(key);
      }
    }

    public Entry<K, V> floorEntry(K key) {
      synchronized (mutex) {
        return innerMap().floorEntry(key);
      }
    }

    public K floorKey(K key) {
      synchronized (mutex) {
        return innerMap().floorKey(key);
      }
    }

    public Entry<K, V> ceilingEntry(K key) {
      synchronized (mutex) {
        return innerMap().ceilingEntry(key);
      }
    }

    public K ceilingKey(K key) {
      synchronized (mutex) {
        return innerMap().ceilingKey(key);
      }
    }

    public Entry<K, V> higherEntry(K key) {
      synchronized (mutex) {
        return innerMap().higherEntry(key);
      }
    }

    public K higherKey(K key) {
      synchronized (mutex) {
        return innerMap().higherKey(key);
      }
    }

    public Entry<K, V> firstEntry() {
      synchronized (mutex) {
        return innerMap().firstEntry();
      }
    }

    public Entry<K, V> lastEntry() {
      synchronized (mutex) {
        return innerMap().lastEntry();
      }
    }

    public Entry<K, V> pollFirstEntry() {
      synchronized (mutex) {
        return innerMap().pollFirstEntry();
      }
    }

    public Entry<K, V> pollLastEntry() {
      synchronized (mutex) {
        return innerMap().pollLastEntry();
      }
    }

    public NavigableMap<K, V> descendingMap() {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().descendingMap(), mutex);
      }
    }

    public NavigableSet<K> keySet() {
      return navigableKeySet();
    }

    public NavigableSet<K> navigableKeySet() {
      synchronized (mutex) {
        return new SynchronizedNavigableSet<>(innerMap().navigableKeySet(), mutex);
      }
    }

    public NavigableSet<K> descendingKeySet() {
      synchronized (mutex) {
        return new SynchronizedNavigableSet<>(innerMap().descendingKeySet(), mutex);
      }
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().subMap(fromKey, true, toKey, false), mutex);
      }
    }

    public SortedMap<K, V> headMap(K toKey) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().headMap(toKey, false), mutex);
      }
    }

    public SortedMap<K, V> tailMap(K fromKey) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().tailMap(fromKey, true), mutex);
      }
    }

    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().subMap(fromKey, fromInclusive, toKey, toInclusive), mutex);
      }
    }

    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().headMap(toKey, inclusive), mutex);
      }
    }

    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
      synchronized (mutex) {
        return new SynchronizedNavigableMap<>(innerMap().tailMap(fromKey, inclusive), mutex);
      }
    }
  }

  public static interface IF0<A> {

    public A get();
  }

  static public interface Hasher<A> {

    public int hashCode(A a);

    public boolean equals(A a, A b);
  }

  static abstract public class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {

    public void close() throws Exception {
    }
  }

  static public class ConceptFieldIndexCI<A extends Concept> extends ConceptFieldIndexBase<A, Object> {

    public ConceptFieldIndexCI(Class<A> cc, String field) {
      super(cc, field);
    }

    public ConceptFieldIndexCI(Concepts concepts, Class<A> cc, String field) {
      super(concepts, cc, field);
    }

    public void init() {
      valueToObject = generalizedCIMultiSetMap();
    }

    public void register() {
      concepts.addCIFieldIndex(cc, field, this);
    }
  }

  static public interface IF2<A, B, C> {

    public C get(A a, B b);
  }

  static public interface Producer<A> {

    public A next();
  }

  static public interface IF1<A, B> {

    public B get(A a);
  }

  static public interface IVF1<A> {

    public void get(A a);
  }

  static public interface IIntPred {

    public boolean get(int a);
  }

  static public class SynchronizedList<E> extends SynchronizedCollection<E> implements List<E> {

    public SynchronizedList() {
    }

    public List<E> list;

    public SynchronizedList(List<E> list) {
      super(list);
      this.list = list;
    }

    public SynchronizedList(List<E> list, Object mutex) {
      super(list, mutex);
      this.list = list;
    }

    public boolean equals(Object o) {
      if (this == o)
        return true;
      synchronized (mutex) {
        return list.equals(o);
      }
    }

    public int hashCode() {
      synchronized (mutex) {
        return list.hashCode();
      }
    }

    public E get(int index) {
      synchronized (mutex) {
        return list.get(index);
      }
    }

    public E set(int index, E element) {
      synchronized (mutex) {
        return list.set(index, element);
      }
    }

    public void add(int index, E element) {
      synchronized (mutex) {
        list.add(index, element);
      }
    }

    public E remove(int index) {
      synchronized (mutex) {
        return list.remove(index);
      }
    }

    public int indexOf(Object o) {
      synchronized (mutex) {
        return list.indexOf(o);
      }
    }

    public int lastIndexOf(Object o) {
      synchronized (mutex) {
        return list.lastIndexOf(o);
      }
    }

    public boolean addAll(int index, Collection<? extends E> c) {
      synchronized (mutex) {
        return list.addAll(index, c);
      }
    }

    public ListIterator<E> listIterator() {
      return list.listIterator();
    }

    public ListIterator<E> listIterator(int index) {
      return list.listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
      synchronized (mutex) {
        return new SynchronizedList<>(list.subList(fromIndex, toIndex), mutex);
      }
    }

    @Override
    public void replaceAll(java.util.function.UnaryOperator<E> operator) {
      synchronized (mutex) {
        list.replaceAll(operator);
      }
    }

    @Override
    public void sort(Comparator<? super E> c) {
      synchronized (mutex) {
        list.sort(c);
      }
    }

    @java.io.Serial
    final public Object readResolve() {
      return (list instanceof RandomAccess ? new SynchronizedRandomAccessList<>(list) : this);
    }
  }

  static public class WebChatBotMsg {

    public String fullHTML;

    public boolean fromUser = false;

    public String msgHTML, msgText;

    public String toString() {
      return (fromUser ? "U" : "B") + ": " + msgText;
    }
  }

  final static public class _MethodCache {

    final public Class c;

    final public HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      java.lang.Module myModule = getClass().getModule();
      boolean anyHiddenClasses = false;
      while (_c != null) {
        boolean exported = classIsExportedTo(_c, myModule);
        if (!exported)
          anyHiddenClasses = true;
        else
          for (Method m : _c.getDeclaredMethods()) if ((anyHiddenClasses || !isAbstract(m)) && !reflection_isForbiddenMethod(m))
            multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if ((anyHiddenClasses || m.isDefault()) && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class Matches {

    public String[] m;

    public Matches() {
    }

    public Matches(String... m) {
      this.m = m;
    }

    public String get(int i) {
      return i < m.length ? m[i] : null;
    }

    public String unq(int i) {
      return unquote(get(i));
    }

    public String tlc(int i) {
      return unq(i).toLowerCase();
    }

    public boolean bool(int i) {
      return "true".equals(unq(i));
    }

    public String rest() {
      return m[m.length - 1];
    }

    public int psi(int i) {
      return Integer.parseInt(unq(i));
    }

    public String toString() {
      return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")";
    }

    public int hashCode() {
      return _hashCode(toList(m));
    }

    public boolean equals(Object o) {
      return o instanceof Matches && arraysEqual(m, ((Matches) o).m);
    }
  }

  static public class Symbol implements CharSequence {

    public String text;

    public Symbol() {
    }

    public Symbol(String text, boolean dummy) {
      this.text = text;
    }

    public int hashCode() {
      return _hashCode(text);
    }

    public String toString() {
      return text;
    }

    public boolean equals(Object o) {
      return this == o;
    }

    public int length() {
      return text.length();
    }

    public char charAt(int index) {
      return text.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
      return text.substring(start, end);
    }
  }

  static public interface IMeta {

    public void _setMeta(Object meta);

    public Object _getMeta();

    default public IAutoCloseableF0 _tempMetaMutex() {
      return new IAutoCloseableF0() {

        public Object get() {
          return IMeta.this;
        }

        public void close() {
        }
      };
    }

    default public Object getMeta(Object obj, Object key) {
      return metaGet(obj, key);
    }

    default public Object metaGet(Object obj, Object key) {
      return metaMapGet(obj, key);
    }

    default public Object metaGet(String key, Object obj) {
      return metaMapGet(obj, key);
    }

    default public Object getMeta(Object key) {
      return metaGet(key);
    }

    default public Object metaGet(Object key) {
      if (key == null)
        return null;
      Object meta = _getMeta();
      if (meta instanceof Map)
        return ((Map) meta).get(key);
      return null;
    }

    default public void metaSet(IMeta obj, Object key, Object value) {
      metaPut(obj, key, value);
    }

    default public void metaPut(IMeta obj, Object key, Object value) {
      metaMapPut(obj, key, value);
    }

    default public void metaSet(Object key, Object value) {
      metaPut(key, value);
    }

    default public void metaPut(Object key, Object value) {
      if (key == null)
        return;
      Map map = convertObjectMetaToMap(this);
      syncMapPutOrRemove(map, key, value);
    }
  }

  static public class HCRUD_Concepts<A extends Concept> extends HCRUD_Data {

    public Concepts cc = db_mainConcepts();

    public Class<A> cClass;

    public List<IVF1<A>> onCreateOrUpdate = new ArrayList();

    public List<IVF1<A>> onCreate = new ArrayList();

    public IVF2<A, Map<String, Object>> afterUpdate;

    public Map<String, Object> filters;

    public Map<String, String> ciFilters;

    public IF1<Collection<A>, Collection<A>> customFilter;

    public ValueConverterForField valueConverter;

    public boolean referencesBlockDeletion = false;

    public boolean trimAllSingleLineValues = false;

    public Set<String> fieldsToHideInCreationForm;

    public boolean lockDB = false;

    public boolean verbose = false;

    public boolean dropEmptyListValues = true;

    public boolean lsMagic = false;

    public boolean convertConceptValuesToRefs = false;

    public A currentConcept;

    public boolean useDynamicComboBoxes = false;

    public IF1<String, Boolean> useDynamicComboBoxesForField;

    public int dynamicComboBoxesThreshold = 1000;

    public HCRUD_Concepts(Class<A> cClass) {
      this.cClass = cClass;
    }

    public HCRUD_Concepts(Concepts cc, Class<A> cClass) {
      this.cClass = cClass;
      this.cc = cc;
    }

    transient public IF0<String> itemName;

    public String itemName() {
      return itemName != null ? itemName.get() : itemName_base();
    }

    final public String itemName_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : itemName_base();
    }

    public String itemName_base() {
      return humanizeShortName(cClass);
    }

    transient public IF0<String> itemNamePlural;

    public String itemNamePlural() {
      return itemNamePlural != null ? itemNamePlural.get() : itemNamePlural_base();
    }

    final public String itemNamePlural_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : itemNamePlural_base();
    }

    public String itemNamePlural_base() {
      return super.itemNamePlural();
    }

    public List<A> itemsForListing() {
      return defaultSort(asList(listConcepts()));
    }

    @Override
    public List<Map<String, Object>> list() {
      return lazyMap(itemsForListing(), a -> new Item(str(a.id)) {

        public Map<String, Object> calcFullMap() {
          return itemToMapForList(a);
        }
      });
    }

    @Override
    public List<Map<String, Object>> list(IntRange range) {
      return lambdaMap(__66 -> itemToMapForList(__66), subListOrFull(itemsForListing(), range));
    }

    public Collection<A> listConcepts() {
      Collection<A> l = listConcepts_firstStep();
      return postProcess(customFilter, l);
    }

    transient public IF0<Collection<A>> listConcepts_firstStep;

    public Collection<A> listConcepts_firstStep() {
      return listConcepts_firstStep != null ? listConcepts_firstStep.get() : listConcepts_firstStep_base();
    }

    final public Collection<A> listConcepts_firstStep_fallback(IF0<Collection<A>> _f) {
      return _f != null ? _f.get() : listConcepts_firstStep_base();
    }

    public Collection<A> listConcepts_firstStep_base() {
      if (empty(ciFilters))
        return conceptsWhere(cc, cClass, mapToParams(filters));
      else if (empty(filters))
        return conceptsWhereCI(cc, cClass, mapToParams(ciFilters));
      else {
        Collection<A> l = conceptsWhere(cc, cClass, mapToParams(filters));
        return filterConceptsIC(l, mapToParams(ciFilters));
      }
    }

    transient public IF0<Pair<String, Boolean>> defaultSortField;

    public Pair<String, Boolean> defaultSortField() {
      return defaultSortField != null ? defaultSortField.get() : defaultSortField_base();
    }

    final public Pair<String, Boolean> defaultSortField_fallback(IF0<Pair<String, Boolean>> _f) {
      return _f != null ? _f.get() : defaultSortField_base();
    }

    public Pair<String, Boolean> defaultSortField_base() {
      return pair("id", true);
    }

    transient public IF1<List<A>, List<A>> defaultSort;

    public List<A> defaultSort(List<A> l) {
      return defaultSort != null ? defaultSort.get(l) : defaultSort_base(l);
    }

    final public List<A> defaultSort_fallback(IF1<List<A>, List<A>> _f, List<A> l) {
      return _f != null ? _f.get(l) : defaultSort_base(l);
    }

    public List<A> defaultSort_base(List<A> l) {
      return sortedByConceptIDDesc(l);
    }

    transient public IF0<A> emptyConcept;

    public A emptyConcept() {
      return emptyConcept != null ? emptyConcept.get() : emptyConcept_base();
    }

    final public A emptyConcept_fallback(IF0<A> _f) {
      return _f != null ? _f.get() : emptyConcept_base();
    }

    public A emptyConcept_base() {
      return unlisted(cClass);
    }

    transient public IF0<Map<String, Object>> emptyObject;

    public Map<String, Object> emptyObject() {
      return emptyObject != null ? emptyObject.get() : emptyObject_base();
    }

    final public Map<String, Object> emptyObject_fallback(IF0<Map<String, Object>> _f) {
      return _f != null ? _f.get() : emptyObject_base();
    }

    public Map<String, Object> emptyObject_base() {
      A c = emptyConcept();
      Map<String, Object> map = itemToMap(c);
      return mapMinusKeys(fieldsToHideInCreationForm, map);
    }

    public Map<String, Object> itemToMap(A c) {
      if (c == null)
        return null;
      return putKeysFirst(getFieldOrder(c), conceptToMap_gen_withNullValues(c));
    }

    public Map<String, Object> itemToMapForList(A c) {
      if (c == null)
        return null;
      Map<String, Object> map = itemToMap(c);
      massageItemMapForList(c, map);
      return map;
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForList;

    public void massageItemMapForList(A c, Map<String, Object> map) {
      if (massageItemMapForList != null)
        massageItemMapForList.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    final public void massageItemMapForList_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    public void massageItemMapForList_base(A c, Map<String, Object> map) {
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForUpdate;

    public void massageItemMapForUpdate(A c, Map<String, Object> map) {
      if (massageItemMapForUpdate != null)
        massageItemMapForUpdate.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    final public void massageItemMapForUpdate_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    public void massageItemMapForUpdate_base(A c, Map<String, Object> map) {
      Collection<Field> refLFields = nonStaticNonTransientFieldObjectsOfType(Concept.RefL.class, c);
      printVars_str("refLFields", refLFields, "c", c);
      for (Field f : refLFields) {
        TreeMap<Integer, Object> values = new TreeMap();
        Matches m = new Matches();
        for (Map.Entry<? extends String, ? extends Object> __2 : _entrySet(cloneMap(map))) {
          String key = __2.getKey();
          Object value = __2.getValue();
          if (startsWith(key, f.getName() + "_", m) && isInteger(m.rest())) {
            Concept concept = getConceptFromString((String) value);
            if (concept != null || !dropEmptyListValues)
              values.put(parseInt(m.rest()), concept);
            map.remove(key);
          }
        }
        if (!dropEmptyListValues)
          while (nempty(values) && lastValue(values) == null) {
            if (verbose)
              print("Dropping value " + lastEntry(values));
            removeLastKey(values);
          }
        map.put(f.getName(), valuesAsList(values));
      }
      for (String name : cloneKeys(map)) {
        String metaInfo = metaInfoFromForm(name);
        print("metaInfo for " + name + ": " + metaInfo);
        if (eqic(metaInfo, "concept"))
          replaceStringValueWithConcept(map, name);
        else if (eqic(metaInfo, "bool"))
          replaceStringValueWithBool(map, name);
      }
      for (Field f : nonStaticNonTransientFieldObjectsOfType(Concept.Ref.class, c)) replaceStringValueWithConcept(map, f.getName());
      if (trimAllSingleLineValues)
        for (Map.Entry<String, Object> e : map.entrySet()) {
          String val = optCastString(e.getValue());
          if (val != null && isSingleLine(val) && isUntrimmed(val))
            e.setValue(trim(val));
        }
      if (lsMagic)
        for (Field f : nonStaticNonTransientFieldObjectsOfType(List.class, c)) {
          if (eqOneOf(f.getName(), "refs", "backRefs"))
            continue;
          TreeMap<Integer, String> values = new TreeMap();
          Matches m = new Matches();
          for (Map.Entry<? extends String, ? extends Object> __1 : _entrySet(cloneMap(map))) {
            String key = __1.getKey();
            Object value = __1.getValue();
            if (startsWith(key, f.getName() + "_", m) && isInteger(m.rest())) {
              if (!dropEmptyListValues || nempty((String) value)) {
                if (verbose)
                  print("Adding value " + m.rest() + " / " + value);
                mapPut(values, parseInt(m.rest()), (String) value);
              }
              map.remove(key);
            }
          }
          if (!dropEmptyListValues)
            while (nempty(values) && empty(lastValue(values))) {
              if (verbose)
                print("Dropping value " + lastEntry(values));
              removeLastKey(values);
            }
          map.put(f.getName(), valuesAsList(values));
        }
      for (Field f : nonStaticNonTransientFieldObjectsOfType(SecretValue.class, c)) map.remove(f.getName());
    }

    public void replaceStringValueWithConcept(Map<String, Object> map, String key) {
      Object value = map.get(key);
      if (value instanceof String) {
        Concept concept = getConceptFromString((String) value);
        map.put(key, concept);
      }
    }

    public void replaceStringValueWithBool(Map<String, Object> map, String key) {
      Object value = map.get(key);
      if (value instanceof String) {
        map.put(key, englishStringToBool((String) value));
      }
    }

    transient public IF1<Object, Map<String, Object>> getObject;

    public Map<String, Object> getObject(Object id) {
      return getObject != null ? getObject.get(id) : getObject_base(id);
    }

    final public Map<String, Object> getObject_fallback(IF1<Object, Map<String, Object>> _f, Object id) {
      return _f != null ? _f.get(id) : getObject_base(id);
    }

    public Map<String, Object> getObject_base(Object id) {
      return itemToMap(conceptForID(id));
    }

    public Map<String, Object> getObjectForEdit(Object id) {
      currentConcept = conceptForID(id);
      return getObject(id);
    }

    public Object createObject(Map<String, String> fullMap, String fieldPrefix) {
      rawFormValues = fullMap;
      try {
        Map<String, String> map = extractFieldValues(fullMap, fieldPrefix);
        A c = cnew(cc, cClass);
        setValues(c, mapMinusKeys(map, filteredFields()), true);
        cset(c, mapToParams(filters));
        cset(c, mapToParams(ciFilters));
        pcallFAll(onCreate, c);
        pcallFAll(onCreateOrUpdate, c);
        callOpt(c, "_onCreated");
        return c.id;
      } finally {
        rawFormValues = null;
      }
    }

    public void setValues(A c, Map<String, String> map, boolean creating) {
      Lock __3 = lockDB && !creating ? dbLock(cc) : null;
      lock(__3);
      try {
        Map<String, Object> map2 = (Map) cloneMap(map);
        massageItemMapForUpdate(c, map2);
        if (verbose) {
          print("setValues " + map);
          print("backRefs: " + c.backRefs);
        }
        Map<String, Object> oldValues = !creating && afterUpdate != null ? cgetAll_cloneLists(c, keys(map2)) : null;
        if (convertConceptValuesToRefs)
          convertAllConceptValuesToRefs(c, map2);
        if (valueConverter == null)
          cSmartSet(c, mapToParams(map2));
        else
          cSmartSet_withConverter_pcall(verbose, valueConverter, c, mapToParams(map2));
        if (oldValues != null)
          callF(afterUpdate, c, oldValues);
        if (verbose)
          print("backRefs: " + c.backRefs);
      } finally {
        unlock(__3);
      }
    }

    public void convertAllConceptValuesToRefs(A c, Map<String, Object> map) {
      for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet(cloneMap(map))) {
        String key = __0.getKey();
        Object value = __0.getValue();
        if (value instanceof Concept)
          if (!hasField(c, key)) {
            print("Converting value to ref: " + key);
            map.put(key, c.new Ref((Concept) value));
          }
      }
    }

    public A conceptForID(Object id) {
      return _getConcept(cc, cClass, toLong(id));
    }

    public String updateObject(Object id, Map<String, String> fullMap, String fieldPrefix) {
      rawFormValues = fullMap;
      try {
        Map<String, String> map = extractFieldValues(fullMap, fieldPrefix);
        A c = conceptForID(id);
        if (c == null)
          return "Object " + id + " not found";
        {
          String __5 = checkFilters(c);
          if (!empty(__5))
            return __5;
        }
        setValues(c, map, false);
        pcallFAll(onCreateOrUpdate, c);
        return "Object " + id + " updated";
      } finally {
        rawFormValues = null;
      }
    }

    public String deleteObject(Object id) {
      A c = conceptForID(id);
      if (c == null)
        return "Object " + id + " not found";
      {
        String __6 = checkFilters(c);
        if (!empty(__6))
          return __6;
      }
      actuallyDeleteConcept(c);
      return "Object " + id + " deleted";
    }

    transient public IVF1<A> actuallyDeleteConcept;

    public void actuallyDeleteConcept(A c) {
      if (actuallyDeleteConcept != null)
        actuallyDeleteConcept.get(c);
      else
        actuallyDeleteConcept_base(c);
    }

    final public void actuallyDeleteConcept_fallback(IVF1<A> _f, A c) {
      if (_f != null)
        _f.get(c);
      else
        actuallyDeleteConcept_base(c);
    }

    public void actuallyDeleteConcept_base(A c) {
      deleteConcept(c);
    }

    public String checkFilters(A c) {
      if (!checkConceptFields(c, mapToParams(filters)) || !checkConceptFieldsIC(c, mapToParams(ciFilters)))
        return "Object " + c.id + " not in view";
      return "";
    }

    public HCRUD_Concepts<A> addFilters(Map<String, Object> map) {
      for (Map.Entry<? extends String, ? extends Object> __7 : _entrySet(unnullForIteration(map))) {
        String field = __7.getKey();
        Object value = __7.getValue();
        addFilter(field, value);
      }
      return this;
    }

    public HCRUD_Concepts<A> addFilter(String field, Object value) {
      filters = orderedMapPutOrCreate(filters, field, value);
      return this;
    }

    transient public IF1<Object, Boolean> isEditableValue;

    public boolean isEditableValue(Object value) {
      return isEditableValue != null ? isEditableValue.get(value) : isEditableValue_base(value);
    }

    final public boolean isEditableValue_fallback(IF1<Object, Boolean> _f, Object value) {
      return _f != null ? _f.get(value) : isEditableValue_base(value);
    }

    public boolean isEditableValue_base(Object value) {
      if (value instanceof List)
        return true;
      if (value instanceof Collection)
        return false;
      return true;
    }

    public Renderer getRenderer(String field) {
      if (!isEditableValue(currentValue))
        return new NotEditable();
      Class type = fieldType(or(currentConcept, cClass), field);
      String metaInfo = metaInfoFromForm(field);
      if (eq(type, boolean.class))
        return new CheckBox();
      if (eq(type, Boolean.class))
        return new ComboBox(ll("", "yes", "no"), b -> trueFalseNull((Boolean) b, "yes", "no", ""));
      if (isSubtypeOf(type, Concept.Ref.class)) {
        Class<? extends Concept> c = fieldTypeArg(field);
        AbstractComboBox cb = makeConceptsComboBox(field, c);
        cb.metaInfo = "concept";
        return cb;
      }
      Object val = deref(currentValue);
      if (val instanceof Concept) {
        Class<? extends Concept> c = ((Concept) val).getClass();
        AbstractComboBox cb = makeConceptsComboBox(field, c);
        cb.metaInfo = "concept";
        return cb;
      }
      if (eqic(metaInfo, "concept")) {
        printVars_str("metaInfo value", "field", field, "val", val);
        AbstractComboBox cb = makeConceptsComboBox(field, Concept.class);
        cb.metaInfo = "concept";
        return cb;
      }
      if (eq(type, Concept.RefL.class)) {
        Class<? extends Concept> c = fieldTypeArg(field);
        return new FlexibleLengthList(makeConceptsComboBox(field, c));
      }
      if (eq(type, List.class)) {
        return new FlexibleLengthList(new TextField(80));
      }
      if (val instanceof Boolean)
        return new CheckBox();
      return super.getRenderer(field);
    }

    public DynamicComboBox makeDynamicComboBox(String field, Class<? extends Concept> c) {
      DynamicComboBox cb = new DynamicComboBox(field);
      cb.valueToEntry = value -> {
        value = deref(value);
        long id = 0;
        if (value instanceof Concept)
          id = conceptID((Concept) value);
        else if (value instanceof String && isInteger((String) value))
          id = parseLong(value);
        if (id != 0)
          return comboBoxItem(_getConcept(cc, id));
        return null;
      };
      return cb;
    }

    public AbstractComboBox makeConceptsComboBox(String field, Class<? extends Concept> c) {
      if (c == null)
        throw fail(("Null type for field " + field + ". currentConcept: ") + currentConcept);
      if (useDynamicComboBoxes || useDynamicComboBoxesForField != null && useDynamicComboBoxesForField.get(field))
        return makeDynamicComboBox(field, c);
      Collection concepts = listConceptClass(c);
      if (l(concepts) >= dynamicComboBoxesThreshold)
        return makeDynamicComboBox(field, c);
      List<String> entries = comboBoxItems(concepts);
      ComboBox cb = new ComboBox(entries);
      cb.valueToEntry = value -> {
        value = deref(value);
        long id = 0;
        if (value instanceof Concept)
          id = conceptID((Concept) value);
        else if (value instanceof String && isInteger((String) value))
          id = parseLong(value);
        if (id != 0) {
          String entry = firstWhereFirstLongIs(entries, id);
          return entry;
        }
        return null;
      };
      return cb;
    }

    public <A extends Concept> Collection<A> listConceptClass(Class<A> c) {
      return cc.list(c);
    }

    public List<String> comboBoxItemsForConceptClass(Class<? extends Concept> c) {
      return comboBoxItems(listConceptClass(c));
    }

    public List<String> comboBoxItems(Collection<? extends Concept> l) {
      return comboBoxItems_static(l);
    }

    static public List<String> comboBoxItems_static(Collection<? extends Concept> l) {
      return itemPlus("", lmap(__67 -> comboBoxItem_static(__67), l));
    }

    public String comboBoxItem(Concept val) {
      return comboBoxItem_static(val);
    }

    static public String comboBoxItem_static(Concept val) {
      return val == null ? null : shorten(val.id + ": " + val);
    }

    transient public IF1<Object, Boolean> objectCanBeDeleted;

    public boolean objectCanBeDeleted(Object id) {
      return objectCanBeDeleted != null ? objectCanBeDeleted.get(id) : objectCanBeDeleted_base(id);
    }

    final public boolean objectCanBeDeleted_fallback(IF1<Object, Boolean> _f, Object id) {
      return _f != null ? _f.get(id) : objectCanBeDeleted_base(id);
    }

    public boolean objectCanBeDeleted_base(Object id) {
      return !referencesBlockDeletion || !hasBackRefs(conceptForID(id));
    }

    public Set<String> filteredFields() {
      return joinSets(keys(filters), keys(ciFilters));
    }

    public Class<? extends Concept> fieldTypeArg(String field) {
      return getTypeArgumentAsClass(genericFieldType(or(currentConcept, cClass), field));
    }

    transient public IF2<String, String, Class<? extends Concept>> conceptClassForComboBoxSearch;

    public Class<? extends Concept> conceptClassForComboBoxSearch(String info, String query) {
      return conceptClassForComboBoxSearch != null ? conceptClassForComboBoxSearch.get(info, query) : conceptClassForComboBoxSearch_base(info, query);
    }

    final public Class<? extends Concept> conceptClassForComboBoxSearch_fallback(IF2<String, String, Class<? extends Concept>> _f, String info, String query) {
      return _f != null ? _f.get(info, query) : conceptClassForComboBoxSearch_base(info, query);
    }

    public Class<? extends Concept> conceptClassForComboBoxSearch_base(String info, String query) {
      if (!isIdentifier(info))
        return cClass;
      String field = info;
      Class<? extends Concept> c = fieldTypeArg(field);
      if (c == null)
        c = cClass;
      return c;
    }

    transient public IF2<String, String, List<String>> comboBoxSearchBaseItems;

    public List<String> comboBoxSearchBaseItems(String info, String query) {
      return comboBoxSearchBaseItems != null ? comboBoxSearchBaseItems.get(info, query) : comboBoxSearchBaseItems_base(info, query);
    }

    final public List<String> comboBoxSearchBaseItems_fallback(IF2<String, String, List<String>> _f, String info, String query) {
      return _f != null ? _f.get(info, query) : comboBoxSearchBaseItems_base(info, query);
    }

    public List<String> comboBoxSearchBaseItems_base(String info, String query) {
      var c = conceptClassForComboBoxSearch(info, query);
      if (c == null)
        return emptyList();
      return comboBoxItemsForConceptClass(c);
    }

    public List<String> comboBoxSearch(String info, String query) {
      List<String> items = comboBoxSearchBaseItems(info, query);
      return takeFirst(10, scoredSearch(query, items));
    }

    public A conceptForMap(Map<String, Object> map) {
      if (map == null)
        return null;
      long id = toLong(map.get(idField()));
      return id == 0 ? null : (A) _getConcept(cc, id);
    }

    public A getConcept(Map<String, Object> map) {
      return conceptForMap(map);
    }

    public Map<String, String> extractFieldValues(Map<String, String> fullMap, String fieldPrefix) {
      return subMapStartingWith_dropPrefix(fullMap, fieldPrefix);
    }

    public Concept getConceptFromString(String s) {
      long conceptID = parseFirstLong(s);
      return _getConcept(cc, conceptID);
    }

    public String metaInfoFromForm(String field) {
      return mapGet(rawFormValues, "metaInfo_" + field);
    }

    public void addCIFilter(String field, String value) {
      ciFilters = putOrCreate(ciFilters, field, value);
    }

    transient public IF1<Object, String> titleForObjectID;

    public String titleForObjectID(Object id) {
      return titleForObjectID != null ? titleForObjectID.get(id) : titleForObjectID_base(id);
    }

    final public String titleForObjectID_fallback(IF1<Object, String> _f, Object id) {
      return _f != null ? _f.get(id) : titleForObjectID_base(id);
    }

    public String titleForObjectID_base(Object id) {
      return htmlEncode2(strOrNull(conceptForID(id)));
    }
  }

  static public class BetterThread extends Thread {

    public Runnable target;

    public BetterThread(Runnable target) {
      this.target = target;
      _created();
    }

    public BetterThread(Runnable target, String name) {
      super(name);
      this.target = target;
      _created();
    }

    public void _created() {
      vmBus_send("threadCreated", this);
    }

    public void run() {
      try {
        try {
          vmBus_send("threadStarted", this);
          if (target != null)
            target.run();
        } finally {
          vmBus_send("threadEnded", this);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Runnable getTarget() {
      return target;
    }
  }

  static public class Timestamp implements Comparable<Timestamp>, IFieldsToList {

    public long date;

    public Timestamp(long date) {
      this.date = date;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Timestamp))
        return false;
      Timestamp __1 = (Timestamp) o;
      return date == __1.date;
    }

    public int hashCode() {
      int h = 2059094262;
      h = boostHashCombine(h, _hashCode(date));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { date };
    }

    public Timestamp() {
      date = now();
    }

    public long unixDate() {
      return date;
    }

    public String toString() {
      return formatLocalDateWithSeconds(date);
    }

    public int compareTo(Timestamp t) {
      return t == null ? 1 : cmp(date, t.date);
    }

    public Timestamp plus(Seconds seconds) {
      return plus(seconds == null ? null : seconds.getDouble());
    }

    final public Timestamp plusSeconds(double seconds) {
      return plus(seconds);
    }

    public Timestamp plus(double seconds) {
      return new Timestamp(date + toMS(seconds));
    }

    public long minus(Timestamp ts) {
      return unixDate() - ts.unixDate();
    }

    public long sysTime() {
      return clockTimeToSystemTime(date);
    }

    public Duration minusAsDuration(Timestamp ts) {
      return Duration.ofMillis(minus(ts));
    }
  }

  static public class GazelleV_LeftArrowScriptParser extends SimpleLeftToRightParser {

    public ClassNameResolver classNameResolver;

    public List functionContainers = new ArrayList();

    final public GazelleV_LeftArrowScriptParser setLasClassLoader(ILASClassLoader lasClassLoader) {
      return lasClassLoader(lasClassLoader);
    }

    public GazelleV_LeftArrowScriptParser lasClassLoader(ILASClassLoader lasClassLoader) {
      this.lasClassLoader = lasClassLoader;
      return this;
    }

    final public ILASClassLoader getLasClassLoader() {
      return lasClassLoader();
    }

    public ILASClassLoader lasClassLoader() {
      return lasClassLoader;
    }

    public ILASClassLoader lasClassLoader;

    final public GazelleV_LeftArrowScriptParser setClassDefPrefix(String classDefPrefix) {
      return classDefPrefix(classDefPrefix);
    }

    public GazelleV_LeftArrowScriptParser classDefPrefix(String classDefPrefix) {
      this.classDefPrefix = classDefPrefix;
      return this;
    }

    final public String getClassDefPrefix() {
      return classDefPrefix();
    }

    public String classDefPrefix() {
      return classDefPrefix;
    }

    public String classDefPrefix;

    final public GazelleV_LeftArrowScriptParser setOptimize(boolean optimize) {
      return optimize(optimize);
    }

    public GazelleV_LeftArrowScriptParser optimize(boolean optimize) {
      this.optimize = optimize;
      return this;
    }

    final public boolean getOptimize() {
      return optimize();
    }

    public boolean optimize() {
      return optimize;
    }

    public boolean optimize = true;

    final public GazelleV_LeftArrowScriptParser setUseFixedVarContexts(boolean useFixedVarContexts) {
      return useFixedVarContexts(useFixedVarContexts);
    }

    public GazelleV_LeftArrowScriptParser useFixedVarContexts(boolean useFixedVarContexts) {
      this.useFixedVarContexts = useFixedVarContexts;
      return this;
    }

    final public boolean getUseFixedVarContexts() {
      return useFixedVarContexts();
    }

    public boolean useFixedVarContexts() {
      return useFixedVarContexts;
    }

    public boolean useFixedVarContexts = false;

    public LASScope scope;

    public LinkedHashMap<String, LASValueDescriptor> knownVars = new LinkedHashMap();

    public List<GazelleV_LeftArrowScript.FixedVarBase> varAccessesToFix = new ArrayList();

    public Set<String> closerTokens = litset(";", "}", ")");

    public BuildingScript currentReturnableScript;

    public BuildingScript currentLoop;

    public boolean inParens = false;

    public int idCounter;

    public Map<String, LASClassDef> classDefs = new HashMap();

    transient public Set<IVF1<Map<String, LASValueDescriptor>>> onKnownVarsSnapshot;

    public GazelleV_LeftArrowScriptParser onKnownVarsSnapshot(IVF1<Map<String, LASValueDescriptor>> f) {
      onKnownVarsSnapshot = createOrAddToSyncLinkedHashSet(onKnownVarsSnapshot, f);
      return this;
    }

    public GazelleV_LeftArrowScriptParser removeKnownVarsSnapshotListener(IVF1<Map<String, LASValueDescriptor>> f) {
      main.remove(onKnownVarsSnapshot, f);
      return this;
    }

    public void knownVarsSnapshot(Map<String, LASValueDescriptor> knownVars) {
      if (onKnownVarsSnapshot != null)
        for (var listener : onKnownVarsSnapshot) pcallF_typed(listener, knownVars);
    }

    static public class MethodOnObject implements IFieldsToList {

      static final public String _fieldOrder = "object method";

      public Object object;

      public String method;

      public MethodOnObject() {
      }

      public MethodOnObject(Object object, String method) {
        this.method = method;
        this.object = object;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + object + ", " + method + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof MethodOnObject))
          return false;
        MethodOnObject __15 = (MethodOnObject) o;
        return eq(object, __15.object) && eq(method, __15.method);
      }

      public int hashCode() {
        int h = 791808543;
        h = boostHashCombine(h, _hashCode(object));
        h = boostHashCombine(h, _hashCode(method));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { object, method };
      }
    }

    static public class EvaluableWrapper implements IFieldsToList {

      public GazelleV_LeftArrowScript.Evaluable expr;

      public EvaluableWrapper() {
      }

      public EvaluableWrapper(GazelleV_LeftArrowScript.Evaluable expr) {
        this.expr = expr;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + expr + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof EvaluableWrapper))
          return false;
        EvaluableWrapper __16 = (EvaluableWrapper) o;
        return eq(expr, __16.expr);
      }

      public int hashCode() {
        int h = 700525824;
        h = boostHashCombine(h, _hashCode(expr));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { expr };
      }
    }

    public class BuildingScript {

      public int id = ++idCounter;

      final public BuildingScript setReturnable(boolean returnable) {
        return returnable(returnable);
      }

      public BuildingScript returnable(boolean returnable) {
        this.returnable = returnable;
        return this;
      }

      final public boolean getReturnable() {
        return returnable();
      }

      public boolean returnable() {
        return returnable;
      }

      public boolean returnable = false;

      final public BuildingScript setIsLoopBody(boolean isLoopBody) {
        return isLoopBody(isLoopBody);
      }

      public BuildingScript isLoopBody(boolean isLoopBody) {
        this.isLoopBody = isLoopBody;
        return this;
      }

      final public boolean getIsLoopBody() {
        return isLoopBody();
      }

      public boolean isLoopBody() {
        return isLoopBody;
      }

      public boolean isLoopBody = false;

      public BuildingScript returnableParent, loopParent;

      final public BuildingScript setScope(LASScope scope) {
        return scope(scope);
      }

      public BuildingScript scope(LASScope scope) {
        this.scope = scope;
        return this;
      }

      final public LASScope getScope() {
        return scope();
      }

      public LASScope scope() {
        return scope;
      }

      public LASScope scope;

      public GazelleV_LeftArrowScript.Script script = new GazelleV_LeftArrowScript.Script();

      public List<GazelleV_LeftArrowScript.Evaluable> steps = new ArrayList();

      public Map<String, GazelleV_LeftArrowScript.FunctionDef> functionDefs = new HashMap();

      public BuildingScript(boolean returnable) {
        this();
        this.returnable = returnable;
      }

      public BuildingScript(boolean returnable, boolean isLoopBody) {
        this();
        this.isLoopBody = isLoopBody;
        this.returnable = returnable;
      }

      public BuildingScript() {
        scope = currentScope();
      }

      public void add(GazelleV_LeftArrowScript.Evaluable step) {
        if (step != null)
          steps.add(step);
      }

      public GazelleV_LeftArrowScript.Evaluable get() {
        script.scope = scope;
        var lastStep = last(steps);
        if (lastStep instanceof GazelleV_LeftArrowScript.ReturnFromScript)
          if (((GazelleV_LeftArrowScript.ReturnFromScript) lastStep).script == script)
            replaceLast(steps, ((GazelleV_LeftArrowScript.ReturnFromScript) lastStep).value);
        if (!returnable && l(steps) == 1 && empty(functionDefs))
          return first(steps);
        if (nempty(functionDefs))
          script.functionDefs = functionDefs;
        script.steps = toTypedArray(GazelleV_LeftArrowScript.Evaluable.class, steps);
        return script;
      }

      public String toStringLong() {
        return pnlToLines(steps);
      }

      public String toString() {
        return formatRecordVars("BuildingScript", "id", id, "returnable", returnable, "returnableParent", returnableParent, "script", script);
      }
    }

    public GazelleV_LeftArrowScript.Script parse(String text) {
      setText(text);
      init();
      return parse();
    }

    public GazelleV_LeftArrowScript.Script parse() {
      GazelleV_LeftArrowScript.Script script = parseReturnableScript();
      for (var varAccess : varAccessesToFix) varAccess.resolve();
      if (optimize)
        script = script.optimizeScript();
      return script;
    }

    public GazelleV_LeftArrowScript.Script parseReturnableScript() {
      return (GazelleV_LeftArrowScript.Script) parseScript(new BuildingScript().returnable(true));
    }

    public GazelleV_LeftArrowScript.Evaluable parseScript(BuildingScript script) {
      return linkToSrc(() -> {
        script.returnableParent = currentReturnableScript;
        script.loopParent = currentLoop;
        if (script.returnable)
          currentReturnableScript = script;
        if (script.isLoopBody)
          currentLoop = script;
        return parseBuildingScript(script);
      });
    }

    public GazelleV_LeftArrowScript.Evaluable parseBuildingScript(BuildingScript script) {
      try {
        parseScript_2(script);
        var builtScript = script.get();
        currentReturnableScript = script.returnableParent;
        currentLoop = script.loopParent;
        return builtScript;
      } catch (Throwable e) {
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("Parsed so far:\n" + script);
        throw rethrowAndAppendToMessage(e, squareBracketed(str(lineAndColumn(-1))));
      }
    }

    public void parseScript_2(BuildingScript script) {
      AutoCloseable __6 = tempRestoreMap(knownVars);
      try {
        AssureAdvance assure = new AssureAdvance();
        while (assure.get()) {
          knownVarsSnapshot(knownVars);
          if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
            print("parseScript_2: Next token is " + quote(token()));
          if (is(";")) {
            next();
            continue;
          }
          if (isOneOf("}", ")"))
            break;
          GazelleV_LeftArrowScript.Evaluable instruction = linkToSrc(() -> parseInstruction(script));
          if (instruction != null)
            script.add(instruction);
        }
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("parseScript_2 done");
        knownVarsSnapshot(knownVars);
      } finally {
        _close(__6);
      }
    }

    public GazelleV_LeftArrowScript.Evaluable parseInstruction(BuildingScript script) {
      if (is("def")) {
        parseFunctionDefinition(currentReturnableScript.functionDefs);
        return null;
      }
      if (is("param")) {
        consume();
        String var = assertIdentifier(tpp());
        LASValueDescriptor valueDescriptor = new LASValueDescriptor();
        if (is(":")) {
          var type = parseColonType();
          valueDescriptor = LASValueDescriptor.nonExactCanBeNull(type);
        }
        knownVars.put(var, valueDescriptor);
        return null;
      }
      if (is("throw")) {
        consume();
        return new GazelleV_LeftArrowScript.Throw(parseExpr());
      }
      if (is("try")) {
        consume();
        GazelleV_LeftArrowScript.Evaluable body = parseCurlyBlock(new BuildingScript());
        consume("catch");
        String var = consumeIdentifier();
        AutoCloseable __7 = tempAddKnownVars(var);
        try {
          GazelleV_LeftArrowScript.Evaluable catchBlock = parseCurlyBlock(new BuildingScript());
          return new GazelleV_LeftArrowScript.TryCatch(body, var, catchBlock);
        } finally {
          _close(__7);
        }
      }
      if (isOneOf("return", "ret")) {
        consume();
        GazelleV_LeftArrowScript.Evaluable expr;
        if (atCmdEnd())
          expr = _const(null);
        else
          expr = parseAssignmentOrExpr();
        return new GazelleV_LeftArrowScript.ReturnFromScript(currentReturnableScript.script, expr);
      }
      if (is("continue")) {
        consume();
        assertCmdEnd();
        if (currentLoop == null)
          throw fail("continue outside of loop");
        return new GazelleV_LeftArrowScript.Continue(currentLoop.script);
      }
      if (is("temp")) {
        consume();
        GazelleV_LeftArrowScript.Evaluable tempExpr = parseExpr();
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("tempExpr", tempExpr);
        GazelleV_LeftArrowScript.Evaluable body = parseScript(new BuildingScript());
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("body", body);
        return new GazelleV_LeftArrowScript.TempBlock(tempExpr, body);
      }
      if (is("class"))
        return new GazelleV_LeftArrowScript.ClassDef(new ResolvableLASClass(lasClassLoader, parseClassDef()));
      return parseAssignmentOrExpr();
    }

    public GazelleV_LeftArrowScript.Evaluable parseAssignmentOrExpr() {
      {
        var __3 = parseAssignmentOpt();
        if (__3 != null)
          return __3;
      }
      return parseExpr();
    }

    public GazelleV_LeftArrowScript.Evaluable parseAssignmentOpt() {
      String t = token();
      if (isIdentifier(t) && eq(token(1), "<") && eq(token(2), "-")) {
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("Found assignment");
        next(3);
        GazelleV_LeftArrowScript.Evaluable rhs = parseExpr();
        assertNotNull("Expression expected", rhs);
        boolean newVar = !knownVars.containsKey(t);
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          printVars("newVar", newVar, "t", t, "knownVars", knownVars);
        knownVars.put(t, new LASValueDescriptor());
        return newVar ? new GazelleV_LeftArrowScript.VarDeclaration(t, null, rhs) : new GazelleV_LeftArrowScript.Assignment(t, rhs);
      }
      return null;
    }

    public GazelleV_LeftArrowScript.Evaluable parseOptionalInnerExpression() {
      if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
        printVars("parseOptionalInnerExpression", "token", token());
      if (atCmdEnd() || isOneOf("{", ","))
        return null;
      return parseInnerExpr();
    }

    public GazelleV_LeftArrowScript.Evaluable _const(Object o) {
      return new GazelleV_LeftArrowScript.Const(o);
    }

    public GazelleV_LeftArrowScript.Evaluable parseInnerExpr() {
      return parseExpr(true);
    }

    public GazelleV_LeftArrowScript.Evaluable parseExpr() {
      if (metaGet("scaffolding") != null)
        scaffoldCalled(this, "parseExpr");
      return parseExpr(false);
    }

    public GazelleV_LeftArrowScript.Evaluable parseExpr(boolean inner) {
      GazelleV_LeftArrowScript.Evaluable e = linkToSrc(() -> inner ? parseExpr_impl(true) : parseExprPlusOptionalComma());
      if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
        print("parseExpr done:\n" + GazelleV_LeftArrowScript.indentedScriptStruct(e));
      return e;
    }

    public GazelleV_LeftArrowScript.Evaluable parseExprPlusOptionalComma() {
      GazelleV_LeftArrowScript.Evaluable expr = parseExpr_impl(false);
      while (consumeOpt(",")) {
        expr = parseCall_noCmdEndCheck(expr);
      }
      return expr;
    }

    public GazelleV_LeftArrowScript.Evaluable parseExpr_impl(boolean inner) {
      if (atEnd())
        return null;
      String t = token();
      if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
        printVars("parseExpr", "token", t);
      if (is(";"))
        return null;
      if (is("{"))
        return parseCurlyBlock(new BuildingScript());
      if (is("-") && empty(nextSpace()) && startsWithDigit(token(1)) || startsWithDigit(t)) {
        var e = parseNumberLiteral();
        return inner ? e : parseCall(e);
      }
      if (isQuoted(t)) {
        consume();
        var e = _const(unquote(t));
        return inner ? e : parseCall(e);
      }
      if (startsWith(t, '\'')) {
        consume();
        var e = _const(first(unquote(t)));
        return inner ? e : parseCall(e);
      }
      if (isIdentifier(t)) {
        if (is("while"))
          return parseWhileLoop();
        if (is("for"))
          return parseForEach();
        if (is("if"))
          return parseIfStatement();
        if (is("repeat"))
          return parseRepeatStatement();
        if (is("outer")) {
          consume();
          var a = parseAssignmentOpt();
          if (!(a instanceof GazelleV_LeftArrowScript.Assignment))
            throw fail("Assignment expected");
          return new GazelleV_LeftArrowScript.AssignmentToOuterVar(((GazelleV_LeftArrowScript.Assignment) a).var, ((GazelleV_LeftArrowScript.Assignment) a).expression);
        }
        consume();
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("Consumed identifier " + t + ", next token: " + token() + ", inner: " + inner);
        return parseExprStartingWithIdentifier(t, inner);
      }
      if (eq(t, "(")) {
        boolean inParensOld = inParens;
        inParens = true;
        consume();
        var e = parseExpr();
        consume(")");
        inParens = inParensOld;
        return inner ? e : parseCall(e);
      }
      if (isOneOf("&", "|") && empty(nextSpace()) && is(1, token())) {
        return parseBinaryOperator();
      }
      throw fail("Identifier, literal, operator or opening parentheses expected (got: " + quote(t));
    }

    public GazelleV_LeftArrowScript.Evaluable parseNumberLiteral() {
      String t = consumeMultiTokenLiteral();
      if (swic(t, "0x"))
        return _const(parseHexInt(dropFirst(t, 2)));
      if (swic(t, "0b"))
        return _const(intFromBinary(dropFirst(t, 2)));
      if (isInteger(t))
        return _const(parseInt(t));
      if (endsWith(t, "f"))
        return _const(parseFloat(t));
      if (endsWith(t, "L"))
        return _const(parseLong(t));
      return _const(parseDouble(t));
    }

    public GazelleV_LeftArrowScript.Evaluable parseBinaryOperator() {
      boolean and = is("&");
      next(2);
      GazelleV_LeftArrowScript.Evaluable a = parseInnerExpr();
      GazelleV_LeftArrowScript.Evaluable b = parseInnerExpr();
      return and ? new GazelleV_LeftArrowScript.BoolAnd(a, b) : new GazelleV_LeftArrowScript.BoolOr(a, b);
    }

    public boolean qualifiedNameContinues() {
      return empty(prevSpace()) && eq(token(), ".") && empty(nextSpace()) && isIdentifier(token(1));
    }

    public GazelleV_LeftArrowScript.Evaluable parseExprStartingWithIdentifier(String t, boolean inner) {
      if (eq(t, "true"))
        return _const(true);
      if (eq(t, "false"))
        return _const(false);
      if (eq(t, "null"))
        return _const(null);
      if (eq(t, "new")) {
        String className = assertIdentifier(tpp());
        parseTypeArguments(null);
        LASClassDef cd = classDefs.get(className);
        if (cd != null)
          return new GazelleV_LeftArrowScript.NewObject_LASClass(new ResolvableLASClass(lasClassLoader, cd));
        var type = knownVars.get(className);
        if (type != null)
          return new GazelleV_LeftArrowScript.NewObject_UnknownClass(new GazelleV_LeftArrowScript.GetVar(className), parseArguments());
        Object o = findExternalObject(className);
        if (o instanceof Class) {
          Class c = (Class) o;
          if (c == List.class)
            c = ArrayList.class;
          else if (c == Map.class)
            c = HashMap.class;
          else if (c == Set.class)
            c = HashSet.class;
          return new GazelleV_LeftArrowScript.NewObject(c, parseArguments());
        }
        throw new ClassNotFound(className);
      }
      if (scope != null && scope.useFixedVars) {
        var type = scope.declaredVars.get(t);
        if (type != null) {
          var e = new GazelleV_LeftArrowScript.GetFixedVar(scope, t);
          e.scope(scope);
          e.returnType(type);
          varAccessesToFix.add(e);
          return inner ? e : parseCall(e);
        }
      }
      var type = knownVars.get(t);
      if (type != null) {
        var e = new GazelleV_LeftArrowScript.GetVar(t).returnType(type);
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("Found var acccess: " + e + ", " + (!inner ? "Checking for call" : "Returning expression"));
        return inner ? e : parseCall(e);
      }
      if (!inner) {
        var fdef = lookupFunction(t);
        if (fdef != null)
          return new GazelleV_LeftArrowScript.CallFunction(fdef, parseArguments());
      }
      if (eq(t, "_context"))
        return new GazelleV_LeftArrowScript.GetVarContext();
      Object o = findExternalObject(t);
      if (o == null) {
        throw new UnknownObject(t);
      } else if (o instanceof EvaluableWrapper) {
        return inner ? ((EvaluableWrapper) o).expr : parseCall(((EvaluableWrapper) o).expr);
      } else if (inner)
        return _const(o);
      else if (o instanceof Class) {
        return parseExprStartingWithClass((Class) o);
      } else if (o instanceof MethodOnObject) {
        if (inner)
          throw fail("Can't call methods in arguments");
        return new GazelleV_LeftArrowScript.CallMethod(_const(((MethodOnObject) o).object), ((MethodOnObject) o).method, parseArguments());
      } else
        return parseCall(_const(o));
    }

    public GazelleV_LeftArrowScript.Evaluable parseExprStartingWithClass(Class c) {
      if (atCmdEnd())
        return _const(c);
      if (is("("))
        return new GazelleV_LeftArrowScript.NewObject(c, parseArguments());
      {
        var __4 = parseLambdaOpt(c);
        if (__4 != null)
          return __4;
      }
      if (isIdentifier()) {
        String name = tpp();
        if (hasStaticMethodNamed(c, name))
          return new GazelleV_LeftArrowScript.CallMethod(_const(c), name, parseArguments());
        if (isInterface(c))
          return parseLambdaMethodRef(c, name);
        var field = getField(c, name);
        if (field != null) {
          assertCmdEnd();
          if (!isStaticField(field))
            throw fail(field + " is not a static field");
          return new GazelleV_LeftArrowScript.GetStaticField(field);
        }
        throw fail(name + " not found in " + c + " (looked for method or field)");
      } else
        throw fail("Method name expected: " + token());
    }

    public GazelleV_LeftArrowScript.Evaluable parseLambdaOpt(Class c) {
      int nArgs = 0;
      while (isIdentifier(token(nArgs))) nArgs++;
      if (!(is(nArgs, "-") && is(nArgs + 1, ">")))
        return null;
      String[] argNames = consumeArray(nArgs);
      AutoCloseable __8 = tempAddKnownVars(argNames);
      try {
        skip(2);
        GazelleV_LeftArrowScript.Evaluable body;
        if (is("{"))
          body = parseReturnableScript();
        else
          body = parseExpr();
        var lambda = new GazelleV_LeftArrowScript.LambdaDef(c, argNames, body);
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("parseLambdaOpt done:\n" + GazelleV_LeftArrowScript.indentedScriptStruct(lambda));
        return lambda;
      } finally {
        _close(__8);
      }
    }

    public GazelleV_LeftArrowScript.Evaluable parseLambdaMethodRef(Class c, String name) {
      var fdef = lookupFunction(name);
      if (fdef != null) {
        GazelleV_LeftArrowScript.Evaluable[] curriedArguments = parseArguments();
        return new GazelleV_LeftArrowScript.CurriedScriptFunctionLambda(c, fdef, curriedArguments);
      }
      Object function = findExternalObject(name);
      if (function == null)
        throw new UnknownObject(name);
      if (function instanceof MethodOnObject) {
        Object target = ((MethodOnObject) function).object;
        String targetMethod = ((MethodOnObject) function).method;
        GazelleV_LeftArrowScript.Evaluable[] curriedArguments = parseArguments();
        return new GazelleV_LeftArrowScript.CurriedMethodLambda(c, target, targetMethod, curriedArguments);
      } else if (function instanceof Class) {
        Class c2 = (Class) function;
        assertCmdEnd();
        var ctors = constructorsWithNumberOfArguments(c2, 1);
        if (empty(ctors))
          throw fail("No single argument constructor found in " + c2);
        return new GazelleV_LeftArrowScript.CurriedConstructorLambda(c, toArray(Constructor.class, ctors), null);
      } else
        throw fail(function + " is not an instantiable class or callable method");
    }

    public GazelleV_LeftArrowScript.FunctionDef lookupFunction(String name) {
      var script = currentReturnableScript;
      while (script != null) {
        var f = script.functionDefs.get(name);
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          printVars("lookupFunction", "script", script, "name", name, "f", f);
        if (f != null)
          return f;
        script = script.returnableParent;
      }
      return null;
    }

    public GazelleV_LeftArrowScript.Evaluable[] parseArguments() {
      return toArrayOrNull(GazelleV_LeftArrowScript.Evaluable.class, parseArgumentsAsList());
    }

    public List<GazelleV_LeftArrowScript.Evaluable> parseArgumentsAsList() {
      List<GazelleV_LeftArrowScript.Evaluable> l = new ArrayList();
      try {
        while (true) {
          GazelleV_LeftArrowScript.Evaluable a = parseOptionalInnerExpression();
          if (a == null)
            break;
          l.add(a);
        }
        return l;
      } catch (Throwable _e) {
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("Arguments parsed so far: " + l);
        throw rethrow(_e);
      }
    }

    public String consumeMultiTokenLiteral() {
      return consumeUntilSpaceOr(() -> atCmdEnd() || is(","));
    }

    public boolean atCmdEnd() {
      return !inParens && atEndOrLineBreak() || closerTokens.contains(token());
    }

    public void assertCmdEnd() {
      if (!atCmdEnd())
        throw fail("Expected end of command, token is: " + quote(token()));
    }

    public GazelleV_LeftArrowScript.Evaluable parseCall(GazelleV_LeftArrowScript.Evaluable target) {
      if (atCmdEnd())
        return target;
      return parseCall_noCmdEndCheck(target);
    }

    public GazelleV_LeftArrowScript.Evaluable parseCall_noCmdEndCheck(GazelleV_LeftArrowScript.Evaluable target) {
      if (!isIdentifier())
        return target;
      var start = ptr();
      String name = tpp();
      if (eq(token(), "<") && eq(token(1), "-")) {
        next(2);
        GazelleV_LeftArrowScript.Evaluable rhs = parseExpr();
        return new GazelleV_LeftArrowScript.SetField(target, name, rhs);
      }
      var args = parseArguments();
      if (nempty(args))
        return new GazelleV_LeftArrowScript.CallMethod(target, name, args);
      else
        return linkToSrc(start, new GazelleV_LeftArrowScript.CallMethodOrGetField(target, name));
    }

    public <A> A linkToSrc(ListAndIndex<String> start, A a) {
      if (a instanceof IHasTokenRangeWithSrc)
        ((IHasTokenRangeWithSrc) a).setTokenRangeWithSrc(new TokenRangeWithSrc(start, ptr().plus(-1)));
      return a;
    }

    public <A> A linkToSrc(IF0<A> a) {
      var start = ptr();
      return linkToSrc(start, a.get());
    }

    transient public IF1<String, Object> findExternalObject;

    public Object findExternalObject(String name) {
      return findExternalObject != null ? findExternalObject.get(name) : findExternalObject_base(name);
    }

    final public Object findExternalObject_fallback(IF1<String, Object> _f, String name) {
      return _f != null ? _f.get(name) : findExternalObject_base(name);
    }

    public Object findExternalObject_base(String name) {
      {
        var __5 = parsePrimitiveType(name);
        if (__5 != null)
          return __5;
      }
      if (qualifiedNameContinues()) {
        int idx = idx() - 2;
        do next(2); while (qualifiedNameContinues());
        String fqn = joinSubList(tok, idx, idx() - 1);
        return classForName(fqn);
      }
      String fullName = globalClassNames().get(name);
      if (fullName != null)
        return classForName(fullName);
      for (var container : unnullForIteration(functionContainers)) {
        if (hasMethodNamed(container, name))
          return new MethodOnObject(container, name);
        var field = getField(container, name);
        if (field != null && isStaticField(field))
          return new EvaluableWrapper(new GazelleV_LeftArrowScript.GetStaticField(field));
      }
      return null;
    }

    public GazelleV_LeftArrowScriptParser allowTheWorld() {
      return allowTheWorld(mc());
    }

    public GazelleV_LeftArrowScriptParser allowTheWorld(Object... functionContainers) {
      for (Object o : unnullForIteration(reversed(functionContainers))) if (!contains(this.functionContainers, o)) {
        this.functionContainers.add(0, o);
        globalClassNames_cache = null;
      }
      return this;
    }

    public void printFunctionDefs(GazelleV_LeftArrowScript.Script script) {
      if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
        print(values(script.functionDefs));
    }

    public AutoCloseable tempAddKnownVars(String... vars) {
      return tempAddKnownVars(asList(vars));
    }

    public AutoCloseable tempAddKnownVars(Iterable<String> vars) {
      var newVars = mapWithSingleValue(vars, new LASValueDescriptor());
      if (scope != null)
        for (var __1 : _entrySet(newVars)) {
          var name = __1.getKey();
          var type = __1.getValue();
          scope.addDeclaredVar(name, type);
        }
      return tempMapPutAll(knownVars, newVars);
    }

    public GazelleV_LeftArrowScript.FunctionDef parseFunctionDefinition(Map<String, GazelleV_LeftArrowScript.FunctionDef> functionDefsToAddTo) {
      consume("def");
      String functionName = assertIdentifier(tpp());
      if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
        print("parseFunctionDefinition " + functionName);
      List<String> args = new ArrayList();
      while (isIdentifier()) args.add(tpp());
      var scope = newScope();
      scope.useFixedVars(useFixedVarContexts);
      AutoCloseable __9 = tempScope(scope);
      try {
        AutoCloseable __10 = tempAddKnownVars(args);
        try {
          if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
            print("Parsing function body");
          var functionBody = parseReturnableCurlyBlock();
          if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
            print("Defined function " + functionName + ", adding to " + functionDefsToAddTo);
          var fd = new GazelleV_LeftArrowScript.FunctionDef(functionName, args, functionBody);
          fd.scope(scope);
          {
            if (functionDefsToAddTo != null)
              functionDefsToAddTo.put(functionName, fd);
          }
          return fd;
        } finally {
          _close(__10);
        }
      } finally {
        _close(__9);
      }
    }

    public LASScope newScope() {
      return new LASScope(scope);
    }

    public LASScope currentScope() {
      return scope;
    }

    public AutoCloseable tempScope(LASScope scope) {
      var oldScope = currentScope();
      this.scope = scope;
      return () -> {
        scope.resolve();
        this.scope = oldScope;
      };
    }

    public GazelleV_LeftArrowScript.Script parseReturnableCurlyBlock() {
      return (GazelleV_LeftArrowScript.Script) parseCurlyBlock(new BuildingScript().returnable(true));
    }

    public GazelleV_LeftArrowScript.Evaluable parseCurlyBlock(BuildingScript script) {
      consume("{");
      boolean inParensOld = inParens;
      inParens = false;
      var body = parseScript(script);
      consume("}");
      inParens = inParensOld;
      return body;
    }

    public GazelleV_LeftArrowScript.Evaluable parseWhileLoop() {
      consume("while");
      var condition = parseExpr();
      var body = parseCurlyBlock(new BuildingScript().isLoopBody(true));
      return new GazelleV_LeftArrowScript.While(condition, body);
    }

    public GazelleV_LeftArrowScript.Evaluable parseForEach() {
      return new ParseForEach().get();
    }

    public class ParseForEach {

      public GazelleV_LeftArrowScript.Evaluable collection, body;

      public IF0<GazelleV_LeftArrowScript.Evaluable> finish;

      public Set<String> vars = new HashSet();

      public String addVar(String var) {
        return addAndReturn(vars, var);
      }

      public String consumeVar() {
        return addVar(consumeIdentifier());
      }

      public void parseBody() {
        AutoCloseable __11 = tempAddKnownVars(vars);
        try {
          body = parseCurlyBlock(new BuildingScript().isLoopBody(true));
        } finally {
          _close(__11);
        }
      }

      public GazelleV_LeftArrowScript.Evaluable get() {
        consume("for");
        if (is(1, "to")) {
          String var = consumeVar();
          consume("to");
          GazelleV_LeftArrowScript.Evaluable endValue = parseExpr();
          parseBody();
          return new GazelleV_LeftArrowScript.ForIntTo(endValue, var, body);
        }
        int iIn = relativeIndexOf("in");
        if (iIn < 0)
          throw fail("for without in");
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("iIn", iIn);
        if (iIn == 1) {
          String var = consumeVar();
          finish = () -> new GazelleV_LeftArrowScript.ForEach(collection, var, body);
        } else if (iIn == 2) {
          if (consumeOpt("iterator")) {
            String var = consumeVar();
            finish = () -> new GazelleV_LeftArrowScript.ForIterator(collection, var, body);
          } else if (consumeOpt("nested")) {
            String var = consumeVar();
            finish = () -> new GazelleV_LeftArrowScript.ForNested(collection, var, body);
          } else
            throw fail("Unknown pattern for 'for' loop");
        } else if (iIn == 3) {
          if (isOneOf("pair", "Pair")) {
            consume();
            String varA = consumeVar();
            String varB = consumeVar();
            if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
              printVars("varA", varA, "varB", varB);
            finish = () -> new GazelleV_LeftArrowScript.ForPairs(collection, body, varA, varB);
          } else {
            String varA = consumeVar();
            consume(",");
            String varB = consumeVar();
            finish = () -> new GazelleV_LeftArrowScript.ForKeyValue(collection, body, varA, varB);
          }
        } else if (iIn == 4) {
          consume("index");
          String varIndex = consumeVar();
          consume(",");
          String varElement = consumeVar();
          finish = () -> new GazelleV_LeftArrowScript.ForIndex(collection, body, varIndex, varElement);
        } else
          throw fail("Unknown pattern for 'for' loop");
        consume("in");
        collection = parseExpr();
        if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
          print("collection", collection);
        parseBody();
        return finish.get();
      }
    }

    public GazelleV_LeftArrowScript.Evaluable parseIfStatement() {
      consume("if");
      GazelleV_LeftArrowScript.Evaluable condition, body, elseBranch = null;
      {
        AutoCloseable __12 = tempAdd(closerTokens, "then");
        try {
          condition = parseExpr();
        } finally {
          _close(__12);
        }
      }
      if (consumeOpt("then")) {
        AutoCloseable __13 = tempAdd(closerTokens, "else");
        try {
          body = parseExpr();
          if (consumeOpt("else"))
            elseBranch = parseExpr();
        } finally {
          _close(__13);
        }
      } else {
        body = parseCurlyBlock(new BuildingScript());
        if (consumeOpt("else")) {
          if (is("if"))
            elseBranch = parseIfStatement();
          else
            elseBranch = parseCurlyBlock(new BuildingScript());
        }
      }
      return new GazelleV_LeftArrowScript.IfThen(condition, body, elseBranch);
    }

    public GazelleV_LeftArrowScript.Evaluable parseRepeatStatement() {
      consume("repeat");
      var n = parseExpr();
      var body = parseCurlyBlock(new BuildingScript());
      return new GazelleV_LeftArrowScript.RepeatN(n, body);
    }

    public void addVar(String var) {
      addVar(var, new LASValueDescriptor());
    }

    public void addVar(String var, LASValueDescriptor type) {
      knownVars.put(var, type);
    }

    public void addVar(String var, Class type, boolean canBeNull) {
      addVar(var, new LASValueDescriptor.NonExact(type, canBeNull));
    }

    public Map<String, String> globalClassNames_cache;

    public Map<String, String> globalClassNames() {
      if (globalClassNames_cache == null)
        globalClassNames_cache = globalClassNames_load();
      return globalClassNames_cache;
    }

    public Map<String, String> globalClassNames_load() {
      var packages = mapToTreeSet(importedPackages(), pkg -> pkg + ".");
      Map<String, String> out = new HashMap();
      for (var fc : functionContainers) if (fc instanceof Class) {
        if (isAnonymousClass((Class) fc))
          continue;
        out.put(shortClassName((Class) fc), className((Class) fc));
      }
      var classContainers = classContainerPrefixes();
      TreeSet<String> classContainerSet = asTreeSet(classContainers);
      out.put("List", "java.util.List");
      for (var className : classNameResolver().allFullyQualifiedClassNames()) {
        if (isAnonymousClassName(className))
          continue;
        if (!contains(className, '$')) {
          String pkg = longestPrefixInTreeSet(className, packages);
          if (pkg != null) {
            String shortName = dropPrefix(pkg, className);
            if (!shortName.contains(".") && !out.containsKey(shortName))
              out.put(shortName, className);
          }
        }
        String container = longestPrefixInTreeSet(className, classContainerSet);
        if (container != null) {
          String shortName = dropPrefix(container, className);
          String existing = out.get(shortName);
          if (existing != null) {
            int priority = indexOf(classContainers, container);
            String oldContainer = longestPrefixInTreeSet(existing, classContainerSet);
            int oldPriority = indexOf(classContainers, oldContainer);
            if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
              printVars("className", className, "shortName", shortName, "container", container, "priority", priority, "existing", existing, "oldPriority", oldPriority);
            if (priority > oldPriority)
              continue;
          }
          out.put(shortName, className);
        }
      }
      for (var __0 : _entrySet(javaxClassShortcuts())) {
        var key = __0.getKey();
        var val = __0.getValue();
        String fullName = out.get(val);
        if (fullName != null)
          out.put(key, fullName);
      }
      return out;
    }

    transient public IF0<Collection<String>> importedPackages;

    public Collection<String> importedPackages() {
      return importedPackages != null ? importedPackages.get() : importedPackages_base();
    }

    final public Collection<String> importedPackages_fallback(IF0<Collection<String>> _f) {
      return _f != null ? _f.get() : importedPackages_base();
    }

    public Collection<String> importedPackages_base() {
      return itemPlus("java.lang", standardImports_fullyImportedPackages());
    }

    public void addClassAlias(String alias, String longName) {
      String fullName = globalClassNames().get(longName);
      if (fullName != null)
        globalClassNames().put(alias, fullName);
    }

    public List<String> classContainerPrefixes() {
      return map(functionContainers, fc -> className(fc) + "$");
    }

    static public class UnknownObject extends RuntimeException implements IFieldsToList {

      public String name;

      public UnknownObject() {
      }

      public UnknownObject(String name) {
        this.name = name;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + name + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { name };
      }

      public String getMessage() {
        return "Unknown object: " + name;
      }
    }

    static public class ClassNotFound extends UnknownObject {

      public ClassNotFound(String className) {
        super(className);
      }

      public String getMessage() {
        return "Class not found: " + name;
      }
    }

    public LASClassDef parseClassDef() {
      consume("class");
      LASClassDef classDef = new LASClassDef();
      classDef.verbose(scaffoldingEnabled());
      if (nempty(classDefPrefix))
        classDef.classDefPrefix(classDefPrefix);
      String name = consumeIdentifier();
      classDef.userGivenName(name);
      consume("{");
      while (!is("}")) {
        if (is(";")) {
          next();
          continue;
        }
        if (is("def")) {
          AutoCloseable __14 = tempAddKnownVars("this");
          try {
            GazelleV_LeftArrowScript.FunctionDef fd = parseFunctionDefinition(null);
            if (GazelleV_LeftArrowScriptParser.this.scaffoldingEnabled())
              printVars("knownVarsAfterFunctionDef", knownVars);
            classDef.methods.add(fd);
            continue;
          } finally {
            _close(__14);
          }
        }
        LASClassDef.FieldDef fd = new LASClassDef.FieldDef();
        fd.name(consumeIdentifier());
        var type = parseColonType();
        fd.type(type);
        classDef.fields.add(fd);
      }
      consume("}");
      classDefs.put(name, classDef);
      return classDef;
    }

    public Type parseColonType() {
      consume(":");
      String typeName = consumeIdentifier();
      Object type = findExternalObject(typeName);
      if (!(type instanceof Class))
        throw fail("Class not found: " + typeName);
      return parseTypeArguments((Type) type);
    }

    public Type parseTypeArguments(Type type) {
      if (is("<") && isIdentifier(token(1))) {
        next();
        Object arg = findExternalObject(consume());
        consume(">");
        if (!(arg instanceof Class))
          throw fail("Class not found: " + arg);
        if (type != null)
          type = new ParameterizedTypeImpl(null, type, (Class) arg);
      }
      return type;
    }

    transient public IF1<String, Class> classForName;

    public Class classForName(String name) {
      return classForName != null ? classForName.get(name) : classForName_base(name);
    }

    final public Class classForName_fallback(IF1<String, Class> _f, String name) {
      return _f != null ? _f.get(name) : classForName_base(name);
    }

    public Class classForName_base(String name) {
      try {
        return Class.forName(name);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void copyFunctionContainersFrom(GazelleV_LeftArrowScriptParser parser) {
      functionContainers = cloneList(parser.functionContainers);
      globalClassNames_cache = parser.globalClassNames();
    }

    public ClassNameResolver classNameResolver() {
      if (classNameResolver == null)
        classNameResolver = new ClassNameResolver().byteCodePath(assertNotNull(getBytecodePathForClass(this))).init();
      return classNameResolver;
    }

    public GazelleV_LeftArrowScriptParser classNameResolver(ClassNameResolver classNameResolver) {
      this.classNameResolver = classNameResolver;
      return this;
    }
  }

  static public class MultiMap<A, B> implements IMultiMap<A, B> {

    public Map<A, List<B>> data = new HashMap<A, List<B>>();

    public int fullSize;

    public MultiMap() {
    }

    public MultiMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiMap(MultiMap<A, B> map) {
      putAll(map);
    }

    public MultiMap(Map<A, List<B>> data) {
      this.data = data;
    }

    public void put(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        list.add(value);
        ++fullSize;
      }
    }

    public void add(A key, B value) {
      put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      putAll(key, values);
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(Collection<A> keys, B value) {
      synchronized (data) {
        for (A key : unnullForIteration(keys)) put(key, value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        if (nempty(values))
          getActual(key).addAll(values);
      }
    }

    public void putAll(Iterable<Pair<A, B>> pairs) {
      synchronized (data) {
        for (Pair<A, B> p : unnullForIteration(pairs)) put(p.a, p.b);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public List<B> get(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        return list == null ? Collections.<B>emptyList() : list;
      }
    }

    public List<B> getOpt(A key) {
      synchronized (data) {
        return data.get(key);
      }
    }

    public List<B> getAndClear(A key) {
      synchronized (data) {
        List<B> l = cloneList(data.get(key));
        remove(key);
        return l;
      }
    }

    public List<B> getActual(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        return list;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null && list.isEmpty()) {
          fullSize -= l(list);
          data.remove(key);
        }
      }
    }

    final public Set<A> keys() {
      return keySet();
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        fullSize -= l(this.getOpt(key));
        data.remove(key);
      }
    }

    final public void remove(Pair<A, B> p) {
      removePair(p);
    }

    public void removePair(Pair<A, B> p) {
      if (p != null)
        remove(p.a, p.b);
    }

    public void remove(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null) {
          if (list.remove(value))
            fullSize--;
          if (list.isEmpty())
            data.remove(key);
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        List<B> list = get(key);
        return list.isEmpty() ? null : list.get(0);
      }
    }

    public void addAll(MultiMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    final public int keyCount() {
      return keysSize();
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    final public int fullSize() {
      return size();
    }

    public int size() {
      synchronized (data) {
        return fullSize;
      }
    }

    public List<A> reverseGet(B b) {
      synchronized (data) {
        List<A> l = new ArrayList();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, List<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public List<B> _makeEmptyList() {
      return new ArrayList();
    }

    public Collection<List<B>> allLists() {
      synchronized (data) {
        return new ArrayList(data.values());
      }
    }

    public Collection<List<B>> values() {
      return allLists();
    }

    public List<B> allValues() {
      return concatLists(data.values());
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }
  }

  static public class SynchronizedSet<E> extends SynchronizedCollection<E> implements Set<E> {

    public SynchronizedSet() {
    }

    public SynchronizedSet(Set<E> s) {
      super(s);
    }

    public SynchronizedSet(Set<E> s, Object mutex) {
      super(s, mutex);
    }

    public boolean equals(Object o) {
      if (this == o)
        return true;
      synchronized (mutex) {
        return c.equals(o);
      }
    }

    public int hashCode() {
      synchronized (mutex) {
        return c.hashCode();
      }
    }
  }

  final static public class LongRange {

    public long start, end;

    public LongRange() {
    }

    public LongRange(long start, long end) {
      this.end = end;
      this.start = start;
    }

    public boolean equals(Object o) {
      if (o instanceof LongRange)
        return start == ((LongRange) o).start && end == ((LongRange) o).end;
      return false;
    }

    public int hashCode() {
      return boostHashCombine(hashOfLong(start), hashOfLong(end));
    }

    public long length() {
      return end - start;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  static public class SynchronizedMap<K, V> implements Map<K, V>, Serializable {

    public SynchronizedMap() {
    }

    public Map<K, V> m;

    public Object mutex;

    public SynchronizedMap(Map<K, V> m) {
      this.m = Objects.requireNonNull(m);
      mutex = this;
    }

    public SynchronizedMap(Map<K, V> m, Object mutex) {
      this.m = m;
      this.mutex = mutex;
    }

    public Map<K, V> innerMap() {
      return m;
    }

    public int size() {
      synchronized (mutex) {
        return m.size();
      }
    }

    public boolean isEmpty() {
      synchronized (mutex) {
        return m.isEmpty();
      }
    }

    public boolean containsKey(Object key) {
      synchronized (mutex) {
        return m.containsKey(key);
      }
    }

    public boolean containsValue(Object value) {
      synchronized (mutex) {
        return m.containsValue(value);
      }
    }

    public V get(Object key) {
      synchronized (mutex) {
        return m.get(key);
      }
    }

    public V put(K key, V value) {
      synchronized (mutex) {
        return m.put(key, value);
      }
    }

    public V remove(Object key) {
      synchronized (mutex) {
        return m.remove(key);
      }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
      synchronized (mutex) {
        m.putAll(map);
      }
    }

    public void clear() {
      synchronized (mutex) {
        m.clear();
      }
    }

    transient public Set<K> keySet;

    transient public Set<Map.Entry<K, V>> entrySet;

    transient public Collection<V> values;

    public Set<K> keySet() {
      synchronized (mutex) {
        if (keySet == null)
          keySet = new SynchronizedSet<>(m.keySet(), mutex);
        return keySet;
      }
    }

    public Set<Map.Entry<K, V>> entrySet() {
      synchronized (mutex) {
        if (entrySet == null)
          entrySet = new SynchronizedSet<>(m.entrySet(), mutex);
        return entrySet;
      }
    }

    public Collection<V> values() {
      synchronized (mutex) {
        if (values == null)
          values = new SynchronizedCollection<>(m.values(), mutex);
        return values;
      }
    }

    public boolean equals(Object o) {
      if (this == o)
        return true;
      synchronized (mutex) {
        return m.equals(o);
      }
    }

    public int hashCode() {
      synchronized (mutex) {
        return m.hashCode();
      }
    }

    public String toString() {
      synchronized (mutex) {
        return m.toString();
      }
    }

    @Override
    public V getOrDefault(Object k, V defaultValue) {
      synchronized (mutex) {
        return m.getOrDefault(k, defaultValue);
      }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
      synchronized (mutex) {
        m.forEach(action);
      }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
      synchronized (mutex) {
        m.replaceAll(function);
      }
    }

    @Override
    public V putIfAbsent(K key, V value) {
      synchronized (mutex) {
        return m.putIfAbsent(key, value);
      }
    }

    @Override
    public boolean remove(Object key, Object value) {
      synchronized (mutex) {
        return m.remove(key, value);
      }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
      synchronized (mutex) {
        return m.replace(key, oldValue, newValue);
      }
    }

    @Override
    public V replace(K key, V value) {
      synchronized (mutex) {
        return m.replace(key, value);
      }
    }

    @Override
    public V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> mappingFunction) {
      synchronized (mutex) {
        return m.computeIfAbsent(key, mappingFunction);
      }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
      synchronized (mutex) {
        return m.computeIfPresent(key, remappingFunction);
      }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
      synchronized (mutex) {
        return m.compute(key, remappingFunction);
      }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
      synchronized (mutex) {
        return m.merge(key, value, remappingFunction);
      }
    }

    @java.io.Serial
    final public void writeObject(ObjectOutputStream s) throws IOException {
      synchronized (mutex) {
        s.defaultWriteObject();
      }
    }
  }

  static public interface IResourceLoader {

    public String loadSnippet(String snippetID);

    public String getTranspiled(String snippetID);

    public int getSnippetType(String snippetID);

    public String getSnippetTitle(String snippetID);

    public File loadLibrary(String snippetID);

    default public File pathToJavaXJar() {
      return pathToJavaxJar_noResourceLoader();
    }

    default public File getSnippetJar(String snippetID, String transpiledSrc) {
      return null;
    }
  }

  static final public class WeakHasherMap<K, V> extends AbstractMap<K, V> implements Map<K, V> {

    public Hasher hasher = null;

    final public boolean keyEquals(Object k1, Object k2) {
      return (hasher == null ? k1.equals(k2) : hasher.equals(k1, k2));
    }

    final public int keyHashCode(Object k1) {
      return (hasher == null ? k1.hashCode() : hasher.hashCode(k1));
    }

    final public WeakKey WeakKeyCreate(K k) {
      if (k == null)
        return null;
      else
        return new WeakKey(k);
    }

    final public WeakKey WeakKeyCreate(K k, ReferenceQueue<? super K> q) {
      if (k == null)
        return null;
      else
        return new WeakKey(k, q);
    }

    final public class WeakKey extends WeakReference<K> {

      public int hash;

      public WeakKey(K k) {
        super(k);
        hash = keyHashCode(k);
      }

      final public WeakKey create(K k) {
        if (k == null)
          return null;
        else
          return new WeakKey(k);
      }

      public WeakKey(K k, ReferenceQueue<? super K> q) {
        super(k, q);
        hash = keyHashCode(k);
      }

      final public WeakKey create(K k, ReferenceQueue<? super K> q) {
        if (k == null)
          return null;
        else
          return new WeakKey(k, q);
      }

      @Override
      public boolean equals(Object o) {
        if (o == null)
          return false;
        if (this == o)
          return true;
        if (!(o.getClass().equals(WeakKey.class)))
          return false;
        Object t = this.get();
        @SuppressWarnings("unchecked")
        Object u = ((WeakKey) o).get();
        if ((t == null) || (u == null))
          return false;
        if (t == u)
          return true;
        return keyEquals(t, u);
      }

      @Override
      public int hashCode() {
        return hash;
      }
    }

    public HashMap<WeakKey, V> hash;

    public ReferenceQueue<? super K> queue = new ReferenceQueue<K>();

    @SuppressWarnings("unchecked")
    final public void processQueue() {
      WeakKey wk;
      while ((wk = (WeakKey) queue.poll()) != null) {
        hash.remove(wk);
      }
    }

    public WeakHasherMap(int initialCapacity, float loadFactor) {
      hash = new HashMap<WeakKey, V>(initialCapacity, loadFactor);
    }

    public WeakHasherMap(int initialCapacity) {
      hash = new HashMap<WeakKey, V>(initialCapacity);
    }

    public WeakHasherMap() {
      hash = new HashMap<WeakKey, V>();
    }

    public WeakHasherMap(Hasher h) {
      hash = new HashMap<WeakKey, V>();
      hasher = h;
    }

    @Override
    public int size() {
      return entrySet().size();
    }

    @Override
    public boolean isEmpty() {
      return entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.containsKey(WeakKeyCreate(kkey));
    }

    @Override
    public V get(Object key) {
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.get(WeakKeyCreate(kkey));
    }

    @Override
    public V put(K key, V value) {
      processQueue();
      return hash.put(WeakKeyCreate(key, queue), value);
    }

    @Override
    public V remove(Object key) {
      processQueue();
      @SuppressWarnings("unchecked")
      K kkey = (K) key;
      return hash.remove(WeakKeyCreate(kkey));
    }

    @Override
    public void clear() {
      processQueue();
      hash.clear();
    }

    @SuppressWarnings("TypeParameterShadowing")
    final public class Entry<K, V> implements Map.Entry<K, V> {

      public Map.Entry<WeakKey, V> ent;

      public K key;

      public Entry(Map.Entry<WeakKey, V> ent, K key) {
        this.ent = ent;
        this.key = key;
      }

      @Override
      public K getKey() {
        return key;
      }

      @Override
      public V getValue() {
        return ent.getValue();
      }

      @Override
      public V setValue(V value) {
        return ent.setValue(value);
      }

      final public boolean keyvalEquals(K o1, K o2) {
        return (o1 == null) ? (o2 == null) : keyEquals(o1, o2);
      }

      final public boolean valEquals(V o1, V o2) {
        return (o1 == null) ? (o2 == null) : o1.equals(o2);
      }

      @SuppressWarnings("NonOverridingEquals")
      public boolean equals(Map.Entry<K, V> e) {
        return (keyvalEquals(key, e.getKey()) && valEquals(getValue(), e.getValue()));
      }

      @Override
      public int hashCode() {
        V v;
        return (((key == null) ? 0 : keyHashCode(key)) ^ (((v = getValue()) == null) ? 0 : v.hashCode()));
      }
    }

    final public class EntrySet extends AbstractSet<Map.Entry<K, V>> {

      public Set<Map.Entry<WeakKey, V>> hashEntrySet = hash.entrySet();

      @Override
      public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>() {

          public Iterator<Map.Entry<WeakKey, V>> hashIterator = hashEntrySet.iterator();

          public Map.Entry<K, V> next = null;

          @Override
          public boolean hasNext() {
            while (hashIterator.hasNext()) {
              Map.Entry<WeakKey, V> ent = hashIterator.next();
              WeakKey wk = ent.getKey();
              K k = null;
              if ((wk != null) && ((k = wk.get()) == null)) {
                continue;
              }
              next = new Entry<K, V>(ent, k);
              return true;
            }
            return false;
          }

          @Override
          public Map.Entry<K, V> next() {
            if ((next == null) && !hasNext())
              throw new NoSuchElementException();
            Map.Entry<K, V> e = next;
            next = null;
            return e;
          }

          @Override
          public void remove() {
            hashIterator.remove();
          }
        };
      }

      @Override
      public boolean isEmpty() {
        return !(iterator().hasNext());
      }

      @Override
      public int size() {
        int j = 0;
        for (Iterator<Map.Entry<K, V>> i = iterator(); i.hasNext(); i.next()) j++;
        return j;
      }

      @Override
      public boolean remove(Object o) {
        processQueue();
        if (!(o instanceof Map.Entry<?, ?>))
          return false;
        @SuppressWarnings("unchecked")
        Map.Entry<K, V> e = (Map.Entry<K, V>) o;
        Object ev = e.getValue();
        WeakKey wk = WeakKeyCreate(e.getKey());
        Object hv = hash.get(wk);
        if ((hv == null) ? ((ev == null) && hash.containsKey(wk)) : hv.equals(ev)) {
          hash.remove(wk);
          return true;
        }
        return false;
      }

      @Override
      public int hashCode() {
        int h = 0;
        for (Iterator<Map.Entry<WeakKey, V>> i = hashEntrySet.iterator(); i.hasNext(); ) {
          Map.Entry<WeakKey, V> ent = i.next();
          WeakKey wk = ent.getKey();
          Object v;
          if (wk == null)
            continue;
          h += (wk.hashCode() ^ (((v = ent.getValue()) == null) ? 0 : v.hashCode()));
        }
        return h;
      }
    }

    public Set<Map.Entry<K, V>> entrySet = null;

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
      if (entrySet == null)
        entrySet = new EntrySet();
      return entrySet;
    }

    public K findKey(Object key) {
      processQueue();
      K kkey = (K) key;
      WeakKey wkey = WeakKeyCreate(kkey);
      WeakKey found = hashMap_findKey(hash, wkey);
      return found == null ? null : found.get();
    }
  }

  public interface TransientObject {
  }

  static public class MMOPattern {

    static public class Phrase extends MMOPattern implements IFieldsToList {

      public String phrase;

      public boolean quoted = false;

      public Phrase() {
      }

      public Phrase(String phrase, boolean quoted) {
        this.quoted = quoted;
        this.phrase = phrase;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + phrase + ", " + quoted + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Phrase))
          return false;
        Phrase __1 = (Phrase) o;
        return eq(phrase, __1.phrase) && eq(quoted, __1.quoted);
      }

      public int hashCode() {
        int h = -1905095975;
        h = boostHashCombine(h, _hashCode(phrase));
        h = boostHashCombine(h, _hashCode(quoted));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { phrase, quoted };
      }
    }

    static public class And extends MMOPattern implements IFieldsToList {

      public List<MMOPattern> l;

      public And() {
      }

      public And(List<MMOPattern> l) {
        this.l = l;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + l + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof And))
          return false;
        And __2 = (And) o;
        return eq(l, __2.l);
      }

      public int hashCode() {
        int h = 65975;
        h = boostHashCombine(h, _hashCode(l));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { l };
      }
    }

    static public class Or extends MMOPattern implements IFieldsToList {

      public List<MMOPattern> l;

      public Or() {
      }

      public Or(List<MMOPattern> l) {
        this.l = l;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + l + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Or))
          return false;
        Or __3 = (Or) o;
        return eq(l, __3.l);
      }

      public int hashCode() {
        int h = 2563;
        h = boostHashCombine(h, _hashCode(l));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { l };
      }
    }

    static public class Not extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public Not() {
      }

      public Not(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Not))
          return false;
        Not __4 = (Not) o;
        return eq(p, __4.p);
      }

      public int hashCode() {
        int h = 78515;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }

    static public class Weighted extends MMOPattern implements IFieldsToList {

      static final public String _fieldOrder = "weight p";

      public double weight;

      public MMOPattern p;

      public Weighted() {
      }

      public Weighted(double weight, MMOPattern p) {
        this.p = p;
        this.weight = weight;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + weight + ", " + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Weighted))
          return false;
        Weighted __5 = (Weighted) o;
        return weight == __5.weight && eq(p, __5.p);
      }

      public int hashCode() {
        int h = -446368457;
        h = boostHashCombine(h, _hashCode(weight));
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { weight, p };
      }
    }

    static public class StartOfLine extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public StartOfLine() {
      }

      public StartOfLine(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof StartOfLine))
          return false;
        StartOfLine __6 = (StartOfLine) o;
        return eq(p, __6.p);
      }

      public int hashCode() {
        int h = -326863539;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }

    static public class EndOfLine extends MMOPattern implements IFieldsToList {

      public MMOPattern p;

      public EndOfLine() {
      }

      public EndOfLine(MMOPattern p) {
        this.p = p;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + p + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof EndOfLine))
          return false;
        EndOfLine __7 = (EndOfLine) o;
        return eq(p, __7.p);
      }

      public int hashCode() {
        int h = -810372346;
        h = boostHashCombine(h, _hashCode(p));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { p };
      }
    }
  }

  static public class proxy_InvocationHandler implements InvocationHandler {

    public Object target;

    public proxy_InvocationHandler() {
    }

    public proxy_InvocationHandler(Object target) {
      this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
      return call(target, method.getName(), unnull(args));
    }
  }

  static public class MetaTransformer {

    static public interface StructureHandler {

      default public Object transform(Object o, IF1 recurse) {
        return null;
      }

      public void visit(Object o, IVF1 recurse);
    }

    public List<StructureHandler> structureHandlers;

    public Set seen;

    public MetaTransformer() {
    }

    public MetaTransformer(StructureHandler... handlers) {
      structureHandlers = asList(handlers);
    }

    final public void add(StructureHandler sh) {
      addStructureHandler(sh);
    }

    public void addStructureHandler(StructureHandler sh) {
      structureHandlers.add(sh);
    }

    public Object transform(IF1 f, Object o) {
      ping();
      Object x = f.get(o);
      if (x != null)
        return x;
      IF1 recurse = liftFunction(f);
      for (StructureHandler h : unnullForIteration(structureHandlers)) {
        ping();
        {
          var __2 = h.transform(o, recurse);
          if (__2 != null)
            return __2;
        }
      }
      return o;
    }

    public void visit(IVF1 f, Object o) {
      ping();
      if (o == null)
        return;
      if (seen != null && !seen.add(o))
        return;
      f.get(o);
      for (StructureHandler h : unnullForIteration(structureHandlers)) {
        ping();
        IVF1 recurse = x -> {
          markPointer(o, x);
          visit(f, x);
        };
        h.visit(o, recurse);
      }
    }

    public void visit_vstack(IVF1 f, Object o) {
      vstackCompute(new visit_vstackComputable(f, o));
    }

    public class visit_vstackComputable extends VStackComputableWithStep implements IFieldsToList {

      public IVF1 f;

      public Object o;

      public visit_vstackComputable() {
      }

      public visit_vstackComputable(IVF1 f, Object o) {
        this.o = o;
        this.f = f;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + f + ", " + o + ")";
      }

      public boolean equals(Object _o) {
        if (!(_o instanceof visit_vstackComputable))
          return false;
        visit_vstackComputable __0 = (visit_vstackComputable) _o;
        return eq(f, __0.f) && eq(o, __0.o);
      }

      public int hashCode() {
        int h = 1091269166;
        h = boostHashCombine(h, _hashCode(f));
        h = boostHashCombine(h, _hashCode(o));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { f, o };
      }

      public void step(VStack stack) {
        if (step == 0) {
          ping();
          if (o == null) {
            stack._return();
            return;
          }
          step++;
        }
        if (step == 1) {
          if (seen != null && !seen.add(o)) {
            stack._return();
            return;
          }
          ++step;
        }
        if (step == 2) {
          f.get(o);
          ++step;
        }
        stack.replace(new ForEach_vstack<>(structureHandlers, h -> {
          IVF1 recurse = x -> {
            markPointer(o, x);
            stack.call(new visit_vstackComputable(f, x));
          };
          h.visit(o, recurse);
        }));
      }
    }

    public IF1 liftFunction(IF1 f) {
      return o -> transform(f, o);
    }

    public boolean any(IF1<Object, Boolean> pred, Object o) {
      Flag flag = new Flag();
      withCancelPoint(cp -> visit(x -> {
        if (pred.get(x)) {
          flag.raise();
          cancelTo(cp);
        }
      }, o));
      return flag.isUp();
    }

    public void addVisitor(IVF1 visitor) {
      if (visitor == null)
        return;
      addStructureHandler(new StructureHandler() {

        public void visit(Object o, IVF1 recurse) {
          visitor.get(o);
        }
      });
    }

    public void avoidCycles() {
      seen = identityHashSet();
    }

    transient public IVF2<Object, Object> markPointer;

    public void markPointer(Object a, Object b) {
      if (markPointer != null)
        markPointer.get(a, b);
      else
        markPointer_base(a, b);
    }

    final public void markPointer_fallback(IVF2<Object, Object> _f, Object a, Object b) {
      if (_f != null)
        _f.get(a, b);
      else
        markPointer_base(a, b);
    }

    public void markPointer_base(Object a, Object b) {
    }
  }

  static public class Pair<A, B> implements Comparable<Pair<A, B>> {

    final public Pair<A, B> setA(A a) {
      return a(a);
    }

    public Pair<A, B> a(A a) {
      this.a = a;
      return this;
    }

    final public A getA() {
      return a();
    }

    public A a() {
      return a;
    }

    public A a;

    final public Pair<A, B> setB(B b) {
      return b(b);
    }

    public Pair<A, B> b(B b) {
      this.b = b;
      return this;
    }

    final public B getB() {
      return b();
    }

    public B b() {
      return b;
    }

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  static public interface IResourceHolder {

    public <A extends AutoCloseable> A add(A a);

    public Collection<AutoCloseable> takeAll();
  }

  static abstract public class DialogIO implements AutoCloseable {

    public String line;

    public boolean eos, loud, noClose;

    public Lock lock = lock();

    abstract public String readLineImpl();

    abstract public boolean isStillConnected();

    abstract public void sendLine(String line);

    abstract public boolean isLocalConnection();

    abstract public Socket getSocket();

    public int getPort() {
      Socket s = getSocket();
      return s == null ? 0 : s.getPort();
    }

    public boolean helloRead = false;

    public int shortenOutputTo = 500;

    public String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }

    public boolean waitForLine() {
      try {
        ping();
        if (line != null)
          return true;
        line = readLineImpl();
        if (line == null)
          eos = true;
        return line != null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }

    public String ask(String s, Object... args) {
      if (loud)
        return askLoudly(s, args);
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      sendLine(s);
      return readLine();
    }

    public String askLoudly(String s, Object... args) {
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }

    public void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }

  static abstract public class DialogHandler {

    abstract public void run(DialogIO io);
  }

  static public class DateInterpretationConfig implements IFieldsToList {

    static final public String _fieldOrder = "timeZone now assumeFuture";

    public TimeZone timeZone;

    public long now;

    public boolean assumeFuture = false;

    public DateInterpretationConfig(TimeZone timeZone, long now, boolean assumeFuture) {
      this.assumeFuture = assumeFuture;
      this.now = now;
      this.timeZone = timeZone;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + timeZone + ", " + now + ", " + assumeFuture + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof DateInterpretationConfig))
        return false;
      DateInterpretationConfig __1 = (DateInterpretationConfig) o;
      return eq(timeZone, __1.timeZone) && now == __1.now && eq(assumeFuture, __1.assumeFuture);
    }

    public int hashCode() {
      int h = 1673400408;
      h = boostHashCombine(h, _hashCode(timeZone));
      h = boostHashCombine(h, _hashCode(now));
      h = boostHashCombine(h, _hashCode(assumeFuture));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { timeZone, now, assumeFuture };
    }

    public DateInterpretationConfig() {
      timeZone = localTimeZone();
      now = now();
      assumeFuture = true;
    }
  }

  static public class IntRange {

    public int start, end;

    public IntRange() {
    }

    public IntRange(int start, int end) {
      this.end = end;
      this.start = start;
    }

    public IntRange(IntRange r) {
      start = r.start;
      end = r.end;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    final public int length() {
      return end - start;
    }

    final public boolean empty() {
      return start >= end;
    }

    final public boolean isEmpty() {
      return start >= end;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  static public interface Transformable {

    public Object transformUsing(IF1 f);
  }

  static public class DateStructures {

    abstract static public class SomeDate {
    }

    abstract static public class SomeDateDate extends SomeDate {
    }

    abstract static public class SomeTime extends SomeDate {
    }

    abstract static public class SomeWeek extends SomeDateDate {
    }

    abstract static public class DateProp extends SomeDate {
    }

    static public class Year extends SomeDateDate implements IFieldsToList, Transformable, Visitable {

      public int year;

      public Year() {
      }

      public Year(int year) {
        this.year = year;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + year + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Year))
          return false;
        Year __0 = (Year) o;
        return year == __0.year;
      }

      public int hashCode() {
        int h = 2751581;
        h = boostHashCombine(h, _hashCode(year));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { year };
      }

      public Object transformUsing(IF1 f) {
        return new Year((int) f.get(year));
      }

      public void visitUsing(IVF1 f) {
        f.get(year);
      }
    }

    static public class CurrentYearPlus extends SomeDateDate implements IFieldsToList, Transformable, Visitable {

      public int nYears;

      public CurrentYearPlus() {
      }

      public CurrentYearPlus(int nYears) {
        this.nYears = nYears;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nYears + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof CurrentYearPlus))
          return false;
        CurrentYearPlus __1 = (CurrentYearPlus) o;
        return nYears == __1.nYears;
      }

      public int hashCode() {
        int h = -283479056;
        h = boostHashCombine(h, _hashCode(nYears));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nYears };
      }

      public Object transformUsing(IF1 f) {
        return new CurrentYearPlus((int) f.get(nYears));
      }

      public void visitUsing(IVF1 f) {
        f.get(nYears);
      }
    }

    static public class Month extends SomeDateDate implements IFieldsToList, Transformable, Visitable {

      public int month;

      public Year year;

      public Month() {
      }

      public Month(int month, Year year) {
        this.year = year;
        this.month = month;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + month + ", " + year + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Month))
          return false;
        Month __2 = (Month) o;
        return month == __2.month && eq(year, __2.year);
      }

      public int hashCode() {
        int h = 74527328;
        h = boostHashCombine(h, _hashCode(month));
        h = boostHashCombine(h, _hashCode(year));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { month, year };
      }

      public Object transformUsing(IF1 f) {
        return new Month((int) f.get(month), (Year) f.get(year));
      }

      public void visitUsing(IVF1 f) {
        f.get(month);
        f.get(year);
      }

      public Month(int month) {
        this(month, null);
      }
    }

    static public class CurrentMonthPlus extends SomeDateDate implements IFieldsToList, Transformable, Visitable {

      public int nMonths;

      public CurrentMonthPlus() {
      }

      public CurrentMonthPlus(int nMonths) {
        this.nMonths = nMonths;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nMonths + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof CurrentMonthPlus))
          return false;
        CurrentMonthPlus __3 = (CurrentMonthPlus) o;
        return nMonths == __3.nMonths;
      }

      public int hashCode() {
        int h = -1003838751;
        h = boostHashCombine(h, _hashCode(nMonths));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nMonths };
      }

      public Object transformUsing(IF1 f) {
        return new CurrentMonthPlus((int) f.get(nMonths));
      }

      public void visitUsing(IVF1 f) {
        f.get(nMonths);
      }
    }

    static public class Week extends SomeWeek implements IFieldsToList, Transformable, Visitable {

      public int week;

      public Year year;

      public Week() {
      }

      public Week(int week, Year year) {
        this.year = year;
        this.week = week;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + week + ", " + year + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Week))
          return false;
        Week __4 = (Week) o;
        return week == __4.week && eq(year, __4.year);
      }

      public int hashCode() {
        int h = 2692116;
        h = boostHashCombine(h, _hashCode(week));
        h = boostHashCombine(h, _hashCode(year));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { week, year };
      }

      public Object transformUsing(IF1 f) {
        return new Week((int) f.get(week), (Year) f.get(year));
      }

      public void visitUsing(IVF1 f) {
        f.get(week);
        f.get(year);
      }
    }

    static public class CurrentWeekPlus extends SomeWeek implements IFieldsToList, Transformable, Visitable {

      public int nWeeks;

      public CurrentWeekPlus() {
      }

      public CurrentWeekPlus(int nWeeks) {
        this.nWeeks = nWeeks;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nWeeks + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof CurrentWeekPlus))
          return false;
        CurrentWeekPlus __5 = (CurrentWeekPlus) o;
        return nWeeks == __5.nWeeks;
      }

      public int hashCode() {
        int h = 633919527;
        h = boostHashCombine(h, _hashCode(nWeeks));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nWeeks };
      }

      public Object transformUsing(IF1 f) {
        return new CurrentWeekPlus((int) f.get(nWeeks));
      }

      public void visitUsing(IVF1 f) {
        f.get(nWeeks);
      }
    }

    static public class Day extends SomeDate implements IFieldsToList, Transformable, Visitable {

      public int day;

      public Month month;

      public Day() {
      }

      public Day(int day, Month month) {
        this.month = month;
        this.day = day;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + day + ", " + month + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Day))
          return false;
        Day __6 = (Day) o;
        return day == __6.day && eq(month, __6.month);
      }

      public int hashCode() {
        int h = 68476;
        h = boostHashCombine(h, _hashCode(day));
        h = boostHashCombine(h, _hashCode(month));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { day, month };
      }

      public Object transformUsing(IF1 f) {
        return new Day((int) f.get(day), (Month) f.get(month));
      }

      public void visitUsing(IVF1 f) {
        f.get(day);
        f.get(month);
      }
    }

    static public class TodayPlus extends SomeDate implements IFieldsToList, Transformable, Visitable {

      public int nDays;

      public TodayPlus() {
      }

      public TodayPlus(int nDays) {
        this.nDays = nDays;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nDays + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TodayPlus))
          return false;
        TodayPlus __7 = (TodayPlus) o;
        return nDays == __7.nDays;
      }

      public int hashCode() {
        int h = 123418715;
        h = boostHashCombine(h, _hashCode(nDays));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nDays };
      }

      public Object transformUsing(IF1 f) {
        return new TodayPlus((int) f.get(nDays));
      }

      public void visitUsing(IVF1 f) {
        f.get(nDays);
      }
    }

    static public class Weekday extends SomeDateDate implements IFieldsToList, Transformable, Visitable {

      public int weekday;

      public SomeWeek week;

      public Weekday() {
      }

      public Weekday(int weekday, SomeWeek week) {
        this.week = week;
        this.weekday = weekday;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + weekday + ", " + week + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Weekday))
          return false;
        Weekday __8 = (Weekday) o;
        return weekday == __8.weekday && eq(week, __8.week);
      }

      public int hashCode() {
        int h = -1403451640;
        h = boostHashCombine(h, _hashCode(weekday));
        h = boostHashCombine(h, _hashCode(week));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { weekday, week };
      }

      public Object transformUsing(IF1 f) {
        return new Weekday((int) f.get(weekday), (SomeWeek) f.get(week));
      }

      public void visitUsing(IVF1 f) {
        f.get(weekday);
        f.get(week);
      }

      public Weekday(int weekday) {
        this.weekday = weekday;
      }
    }

    static public class Hour extends SomeTime implements IFieldsToList, Transformable, Visitable {

      public int hour;

      public Boolean isPM;

      public Day day;

      public Hour() {
      }

      public Hour(int hour, Boolean isPM, Day day) {
        this.day = day;
        this.isPM = isPM;
        this.hour = hour;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + hour + ", " + isPM + ", " + day + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Hour))
          return false;
        Hour __9 = (Hour) o;
        return hour == __9.hour && eq(isPM, __9.isPM) && eq(day, __9.day);
      }

      public int hashCode() {
        int h = 2255364;
        h = boostHashCombine(h, _hashCode(hour));
        h = boostHashCombine(h, _hashCode(isPM));
        h = boostHashCombine(h, _hashCode(day));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { hour, isPM, day };
      }

      public Object transformUsing(IF1 f) {
        return new Hour((int) f.get(hour), (Boolean) f.get(isPM), (Day) f.get(day));
      }

      public void visitUsing(IVF1 f) {
        f.get(hour);
        f.get(isPM);
        f.get(day);
      }

      public Hour(int hour, Boolean isPM) {
        this(hour, isPM, null);
      }
    }

    static public class CurrentHourPlus extends SomeTime implements IFieldsToList, Transformable, Visitable {

      public int nHours;

      public CurrentHourPlus() {
      }

      public CurrentHourPlus(int nHours) {
        this.nHours = nHours;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nHours + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof CurrentHourPlus))
          return false;
        CurrentHourPlus __10 = (CurrentHourPlus) o;
        return nHours == __10.nHours;
      }

      public int hashCode() {
        int h = 1011201559;
        h = boostHashCombine(h, _hashCode(nHours));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nHours };
      }

      public Object transformUsing(IF1 f) {
        return new CurrentHourPlus((int) f.get(nHours));
      }

      public void visitUsing(IVF1 f) {
        f.get(nHours);
      }
    }

    static public class Minute extends SomeTime implements IFieldsToList, Transformable, Visitable {

      public int minute;

      public Hour hour;

      public Minute() {
      }

      public Minute(int minute, Hour hour) {
        this.hour = hour;
        this.minute = minute;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + minute + ", " + hour + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Minute))
          return false;
        Minute __11 = (Minute) o;
        return minute == __11.minute && eq(hour, __11.hour);
      }

      public int hashCode() {
        int h = -1990159820;
        h = boostHashCombine(h, _hashCode(minute));
        h = boostHashCombine(h, _hashCode(hour));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { minute, hour };
      }

      public Object transformUsing(IF1 f) {
        return new Minute((int) f.get(minute), (Hour) f.get(hour));
      }

      public void visitUsing(IVF1 f) {
        f.get(minute);
        f.get(hour);
      }
    }

    static public class CurrentMinutePlus extends SomeTime implements IFieldsToList, Transformable, Visitable {

      public int nMinutes;

      public CurrentMinutePlus() {
      }

      public CurrentMinutePlus(int nMinutes) {
        this.nMinutes = nMinutes;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + nMinutes + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof CurrentMinutePlus))
          return false;
        CurrentMinutePlus __12 = (CurrentMinutePlus) o;
        return nMinutes == __12.nMinutes;
      }

      public int hashCode() {
        int h = -1844800505;
        h = boostHashCombine(h, _hashCode(nMinutes));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { nMinutes };
      }

      public Object transformUsing(IF1 f) {
        return new CurrentMinutePlus((int) f.get(nMinutes));
      }

      public void visitUsing(IVF1 f) {
        f.get(nMinutes);
      }
    }

    static public class Second extends SomeTime implements IFieldsToList, Transformable, Visitable {

      public int second;

      public Minute minute;

      public Second() {
      }

      public Second(int second, Minute minute) {
        this.minute = minute;
        this.second = second;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + second + ", " + minute + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Second))
          return false;
        Second __13 = (Second) o;
        return second == __13.second && eq(minute, __13.minute);
      }

      public int hashCode() {
        int h = -1822412652;
        h = boostHashCombine(h, _hashCode(second));
        h = boostHashCombine(h, _hashCode(minute));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { second, minute };
      }

      public Object transformUsing(IF1 f) {
        return new Second((int) f.get(second), (Minute) f.get(minute));
      }

      public void visitUsing(IVF1 f) {
        f.get(second);
        f.get(minute);
      }
    }

    static public class BeginningOfTime extends SomeDate implements IFieldsToList, Transformable, Visitable {

      public BeginningOfTime() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this);
      }

      public boolean equals(Object o) {
        return o instanceof BeginningOfTime;
      }

      public int hashCode() {
        int h = -1618841503;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }

      public Object transformUsing(IF1 f) {
        return this;
      }

      public void visitUsing(IVF1 f) {
      }
    }

    static public class EndOfTime extends SomeDate implements IFieldsToList, Transformable, Visitable {

      public EndOfTime() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this);
      }

      public boolean equals(Object o) {
        return o instanceof EndOfTime;
      }

      public int hashCode() {
        int h = -810134049;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }

      public Object transformUsing(IF1 f) {
        return this;
      }

      public void visitUsing(IVF1 f) {
      }
    }

    static public class Between extends DateProp implements IFieldsToList, Transformable, Visitable {

      public SomeDate from;

      public SomeDate to;

      public Between() {
      }

      public Between(SomeDate from, SomeDate to) {
        this.to = to;
        this.from = from;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + from + ", " + to + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Between))
          return false;
        Between __14 = (Between) o;
        return eq(from, __14.from) && eq(to, __14.to);
      }

      public int hashCode() {
        int h = 1448018920;
        h = boostHashCombine(h, _hashCode(from));
        h = boostHashCombine(h, _hashCode(to));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { from, to };
      }

      public Object transformUsing(IF1 f) {
        return new Between((SomeDate) f.get(from), (SomeDate) f.get(to));
      }

      public void visitUsing(IVF1 f) {
        f.get(from);
        f.get(to);
      }
    }

    static public class Or extends DateProp implements IFieldsToList, Transformable, Visitable {

      public DateProp a;

      public DateProp b;

      public Or() {
      }

      public Or(DateProp a, DateProp b) {
        this.b = b;
        this.a = a;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + a + ", " + b + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Or))
          return false;
        Or __15 = (Or) o;
        return eq(a, __15.a) && eq(b, __15.b);
      }

      public int hashCode() {
        int h = 2563;
        h = boostHashCombine(h, _hashCode(a));
        h = boostHashCombine(h, _hashCode(b));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { a, b };
      }

      public Object transformUsing(IF1 f) {
        return new Or((DateProp) f.get(a), (DateProp) f.get(b));
      }

      public void visitUsing(IVF1 f) {
        f.get(a);
        f.get(b);
      }
    }

    static public class And extends DateProp implements IFieldsToList, Transformable, Visitable {

      public DateProp a;

      public DateProp b;

      public And() {
      }

      public And(DateProp a, DateProp b) {
        this.b = b;
        this.a = a;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + a + ", " + b + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof And))
          return false;
        And __16 = (And) o;
        return eq(a, __16.a) && eq(b, __16.b);
      }

      public int hashCode() {
        int h = 65975;
        h = boostHashCombine(h, _hashCode(a));
        h = boostHashCombine(h, _hashCode(b));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { a, b };
      }

      public Object transformUsing(IF1 f) {
        return new And((DateProp) f.get(a), (DateProp) f.get(b));
      }

      public void visitUsing(IVF1 f) {
        f.get(a);
        f.get(b);
      }
    }

    static public class Not extends DateProp implements IFieldsToList, Transformable, Visitable {

      public DateProp a;

      public Not() {
      }

      public Not(DateProp a) {
        this.a = a;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + a + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Not))
          return false;
        Not __17 = (Not) o;
        return eq(a, __17.a);
      }

      public int hashCode() {
        int h = 78515;
        h = boostHashCombine(h, _hashCode(a));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { a };
      }

      public Object transformUsing(IF1 f) {
        return new Not((DateProp) f.get(a));
      }

      public void visitUsing(IVF1 f) {
        f.get(a);
      }
    }

    static public boolean containsTimes(SomeDate d) {
      return defaultMetaTransformer().any(o -> o instanceof SomeTime, d);
    }

    static public boolean containsDateDates(SomeDate d) {
      return defaultMetaTransformer().any(o -> o instanceof SomeDateDate, d);
    }
  }

  static public class MRUCache<A, B> extends LinkedHashMap<A, B> {

    public int maxSize = 10;

    public MRUCache() {
    }

    public MRUCache(int maxSize) {
      this.maxSize = maxSize;
    }

    public boolean removeEldestEntry(Map.Entry eldest) {
      return size() > maxSize;
    }

    public Object _serialize() {
      return ll(maxSize, cloneLinkedHashMap(this));
    }

    static public MRUCache _deserialize(List l) {
      MRUCache m = new MRUCache();
      m.maxSize = (int) first(l);
      m.putAll((LinkedHashMap) second(l));
      return m;
    }
  }

  static public class PersistableThrowable extends DynamicObject {

    public String className;

    public String msg;

    public String stacktrace;

    public PersistableThrowable() {
    }

    public PersistableThrowable(Throwable e) {
      if (e == null)
        className = "Crazy Null Error";
      else {
        className = getClassName(e).replace('/', '.');
        msg = e.getMessage();
        stacktrace = getStackTrace_noRecord(e);
      }
    }

    public String toString() {
      return nempty(msg) ? className + ": " + msg : className;
    }

    public RuntimeException asRuntimeException() {
      return new Fail(this);
    }
  }

  static public class SynchronizedSortedMap<K, V> extends SynchronizedMap<K, V> implements SortedMap<K, V> {

    public SynchronizedSortedMap() {
    }

    public SortedMap<K, V> innerMap() {
      return (SortedMap) m;
    }

    public SynchronizedSortedMap(SortedMap<K, V> m) {
      super(m);
    }

    public SynchronizedSortedMap(SortedMap<K, V> m, Object mutex) {
      super(m, mutex);
    }

    public Comparator<? super K> comparator() {
      synchronized (mutex) {
        return innerMap().comparator();
      }
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
      synchronized (mutex) {
        return new SynchronizedSortedMap<>(innerMap().subMap(fromKey, toKey), mutex);
      }
    }

    public SortedMap<K, V> headMap(K toKey) {
      synchronized (mutex) {
        return new SynchronizedSortedMap<>(innerMap().headMap(toKey), mutex);
      }
    }

    public SortedMap<K, V> tailMap(K fromKey) {
      synchronized (mutex) {
        return new SynchronizedSortedMap<>(innerMap().tailMap(fromKey), mutex);
      }
    }

    public K firstKey() {
      synchronized (mutex) {
        return innerMap().firstKey();
      }
    }

    public K lastKey() {
      synchronized (mutex) {
        return innerMap().lastKey();
      }
    }
  }

  static public class EnglishDateParser extends DateStructures {

    public boolean assumeFuture = true;

    public List<String> tok;

    public int maxTokens = 3;

    public List<ParsedWithTokens<SomeDate>> topDogs(String s) {
      return pwt_topDogs(pwt_filterByType(SomeDate.class, allParses(s)));
    }

    public SomeDate parse(String s) {
      return getVar(first(topDogs(s)));
    }

    public IterableIterator<ParsedWithTokens> allParses(String s) {
      List<ParsedWithTokens<String>> initials = pwt_initial(tok = javaTok(s), maxTokens);
      List<ParsedWithTokens> out = new ArrayList();
      List<ParsedWithTokens<Integer>> numbers = pwt_transform(number(), initials);
      List<ParsedWithTokens<Integer>> ordinals = new ArrayList();
      for (ParsedWithTokens<Integer> number : numbers) for (ParsedWithTokens<String> ord : parseToTheRight(fixedToken("st", "nd", "rd", "th"), number)) ordinals.add(pwt_combine(number, ord));
      for (ParsedWithTokens<Integer> number : numbers) for (ParsedWithTokens<String> in : parseToTheLeft(fixedToken("in"), number)) for (ParsedWithTokens<String> days : parseToTheRight(fixedToken("day", "days"), number)) out.add(pwt_combine(new TodayPlus(number.get()), in, days));
      for (ParsedWithTokens<Integer> number : numbers) for (ParsedWithTokens<String> daysFromNow : parseToTheRight(fixedToken("day from now", "days from now"), number)) out.add(pwt_combine(new TodayPlus(number.get()), number, daysFromNow));
      List<ParsedWithTokens<Integer>> years = pwt_filter(__91 -> isYear(__91), numbers);
      out.addAll(years);
      List<ParsedWithTokens<Integer>> months = pwt_filter(__92 -> isMonthNr(__92), numbers);
      List<ParsedWithTokens<Integer>> dayOfMonths = pwt_filter(__93 -> isDayOfMonth(__93), numbers);
      List<ParsedWithTokens<Weekday>> weekdays = pwt_transform(weekday(), initials);
      out.addAll(weekdays);
      List<ParsedWithTokens<Month>> monthNames = pwt_transform(monthName(), initials);
      out.addAll(monthNames);
      out.addAll(pwt_combine(monthNames, years, (month, year) -> new Month(month.month, new Year(year))));
      out.addAll(pwt_combine(monthNames, ordinals, (month, ord) -> new Day(ord, month)));
      out.addAll(pwt_transform(t -> eqic(t, "yesterday") ? new TodayPlus(-1) : eqic(t, "today") ? new TodayPlus(0) : new TodayPlus(1), pwt_transform(fixedToken("yesterday", "today", "tomorrow"), initials)));
      for (ParsedWithTokens<String> week : pwt_transform(fixedToken("week"), initials)) for (ParsedWithTokens<String> which : parseToTheLeft(fixedToken("last", "this", "next"), week)) out.add(pwt_combine(new CurrentWeekPlus(eqic(which.get(), "last") ? -1 : eqic(which.get(), "this") ? 0 : 1), which, week));
      for (ParsedWithTokens<Weekday> weekday : weekdays) for (ParsedWithTokens<String> next : parseToTheLeft(fixedToken("next"), weekday)) out.add(pwt_combine(new Weekday(weekday.get().weekday, new CurrentWeekPlus(1)), next, weekday));
      for (ParsedWithTokens<Integer> year : years) for (ParsedWithTokens<String> slash : parseToTheRight(fixedToken("/"), year)) for (ParsedWithTokens<Integer> month : pwt_toTheRightOf(months, slash)) for (ParsedWithTokens<String> slash2 : parseToTheRight(fixedToken("/"), month)) for (ParsedWithTokens<Integer> day : pwt_toTheRightOf(dayOfMonths, slash2)) out.add(pwt_combine(new Day(day.get(), new Month(month.get(), new Year(year.get()))), year, day));
      List<ParsedWithTokens<Hour>> hours = pwt_transform(__94 -> numberToHour(__94), numbers);
      List<ParsedWithTokens<Integer>> minutes = pwt_filter(__95 -> isMinute(__95), numbers);
      List<ParsedWithTokens<Integer>> seconds = minutes;
      List<ParsedWithTokens<String>> colons = pwt_filter(t -> eq(t, ":"), initials);
      List<ParsedWithTokens<Minute>> hoursAndMinutes = pwt_combine(hours, colons, minutes, (h, __, m) -> new Minute(m, h));
      out.addAll(hoursAndMinutes);
      List<ParsedWithTokens<Second>> hoursAndMinutesAndSeconds = pwt_combine(hoursAndMinutes, colons, seconds, (hm, __, second) -> new Second(second, hm));
      out.addAll(hoursAndMinutesAndSeconds);
      List<ParsedWithTokens<String>> amPMs = pwt_transform(fixedToken("am", "pm"), initials);
      List<ParsedWithTokens<Hour>> amPMTimes = pwt_combine(numbers, amPMs, (hour, amPM) -> !between(hour, 1, 12) ? null : new Hour(hour, eqic(amPM, "pm")));
      out.addAll(amPMTimes);
      for (ParsedWithTokens<Hour> time : amPMTimes) for (ParsedWithTokens<String> and : parseToTheLeft(fixedToken("and"), time)) for (ParsedWithTokens<Hour> hour : pwt_toTheLeftOf(hours, and)) out.add(pwt_combine(new Between(new Hour(hour.get().hour, time.get().isPM), time.get()), time, hour));
      return itIt(out);
    }

    public IF1<String, Integer> number() {
      return s -> isInteger(s) ? parseInt(s) : null;
    }

    public boolean isYear(int n) {
      return between(n, 1900, 2100);
    }

    public boolean isMonthNr(int n) {
      return between(n, 1, 12);
    }

    public boolean isDayOfMonth(int n) {
      return between(n, 1, 31);
    }

    public boolean isHour(int n) {
      return between(n, 0, 23);
    }

    public boolean isMinute(int n) {
      return between(n, 0, 59);
    }

    public boolean isSecond(int n) {
      return between(n, 0, 59);
    }

    public Hour numberToHour(int n) {
      return !isHour(n) ? null : n > 12 ? new Hour(n - 12, true) : new Hour(n, null);
    }

    public IF1<String, String> fixedToken(String... tokens) {
      return fixedToken(litciset(tokens));
    }

    public IF1<String, String> fixedToken(Set<String> set) {
      return t -> contains(set, t) ? t : null;
    }

    public IF1<String, Weekday> weekday() {
      return s -> {
        int n = parseEnglishWeekday(s);
        return n == 0 ? null : new Weekday(n);
      };
    }

    public IF1<String, Month> monthName() {
      return s -> {
        int n = parseEnglishMonthName(s);
        return n == 0 ? null : new Month(n);
      };
    }

    public <A, B> List<ParsedWithTokens<B>> parseToTheLeft(IF1<A, B> f, ParsedWithTokens p) {
      return pwt_transform(f, pwt_precedingTokens(1, maxTokens, p.start()));
    }

    public <A, B> List<ParsedWithTokens<B>> parseToTheRight(IF1<A, B> f, ParsedWithTokens p) {
      return pwt_transform(f, pwt_followingTokens(1, maxTokens, p.remaining()));
    }
  }

  static public class WebBotTester implements AutoCloseable {

    public String botURL;

    public String cookie = "test_" + aGlobalID();

    public int n;

    public Thread grabThread;

    volatile public boolean closed = false;

    public List<String> allHtml = syncList();

    public List<WebChatBotMsg> msgs = new ArrayList();

    public double readTimeout = 120.0, sendTimeout = 20.0;

    public double waitForMessagesTimeout = 20.0;

    public Map<String, String> params = new LinkedHashMap();

    public WebBotTester(String botID) {
      botURL = "https://botcompany.de/" + psI(botID) + "/raw";
    }

    public void close() {
      closed = true;
      cancelAndInterruptThread(grabThread);
    }

    public WebBotTester start() {
      if (grabThread == null)
        grabThread = startThread(new Runnable() {

          public void run() {
            try {
              _grabLoop();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "_grabLoop();";
          }
        });
      return this;
    }

    public void _grabLoop() {
      while (!closed) {
        String html = loadPageWithTimeout(botURL + "/incremental" + hquery(mapPlus(params, "cookie", cookie, "a", n)), readTimeout);
        allHtml.add(html);
        printWithIndent("> ", html);
        msgs.addAll(webBotTester_extractMsgs(html));
        String comment = first(getHTMLComments(html));
        int n = parseFirstIntOrMinus1(comment);
        if (n >= 0)
          this.n = n;
        sleepSeconds(1);
      }
    }

    public void sendMsg(String message) {
      print(doPostWithTimeout(mapPlus(params, "cookie", cookie, "message", message), botURL + "/msg", toMS_int(sendTimeout)));
    }

    public void waitForMessages(int n) {
      waitUntil(50, waitForMessagesTimeout, () -> l(msgs) >= n);
    }
  }

  static public class LASValueDescriptor {

    public LASValueDescriptor() {
    }

    public boolean knownValue() {
      return false;
    }

    public Object value() {
      return null;
    }

    public Class javaClass() {
      return null;
    }

    public boolean javaClassIsExact() {
      return false;
    }

    public boolean canBeNull() {
      return true;
    }

    public boolean canFail() {
      return false;
    }

    public boolean willFail() {
      return false;
    }

    static public class Exact extends LASValueDescriptor implements IFieldsToList {

      public Class c;

      public boolean canBeNull = false;

      public Exact() {
      }

      public Exact(Class c, boolean canBeNull) {
        this.canBeNull = canBeNull;
        this.c = c;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + c + ", " + canBeNull + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof Exact))
          return false;
        Exact __1 = (Exact) o;
        return eq(c, __1.c) && eq(canBeNull, __1.canBeNull);
      }

      public int hashCode() {
        int h = 67394271;
        h = boostHashCombine(h, _hashCode(c));
        h = boostHashCombine(h, _hashCode(canBeNull));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { c, canBeNull };
      }

      public Class javaClass() {
        return c;
      }

      public boolean javaClassIsExact() {
        return true;
      }

      public boolean canBeNull() {
        return canBeNull;
      }
    }

    static public class NonExact extends LASValueDescriptor implements IFieldsToList {

      public Class c;

      public boolean canBeNull = false;

      public NonExact() {
      }

      public NonExact(Class c, boolean canBeNull) {
        this.canBeNull = canBeNull;
        this.c = c;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + c + ", " + canBeNull + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof NonExact))
          return false;
        NonExact __2 = (NonExact) o;
        return eq(c, __2.c) && eq(canBeNull, __2.canBeNull);
      }

      public int hashCode() {
        int h = 1445514322;
        h = boostHashCombine(h, _hashCode(c));
        h = boostHashCombine(h, _hashCode(canBeNull));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { c, canBeNull };
      }

      public Class javaClass() {
        return c;
      }

      public boolean javaClassIsExact() {
        return false;
      }

      public boolean canBeNull() {
        return canBeNull;
      }
    }

    static public LASValueDescriptor nonExactCanBeNull(Type c) {
      return new NonExact(typeToClass(c), true);
    }

    static public class KnownValue extends LASValueDescriptor implements IFieldsToList {

      public Object value;

      public KnownValue() {
      }

      public KnownValue(Object value) {
        this.value = value;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + value + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof KnownValue))
          return false;
        KnownValue __3 = (KnownValue) o;
        return eq(value, __3.value);
      }

      public int hashCode() {
        int h = -1456305138;
        h = boostHashCombine(h, _hashCode(value));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { value };
      }

      public boolean knownValue() {
        return true;
      }

      public Object value() {
        return value;
      }

      public Class javaClass() {
        return value == null ? null : value.getClass();
      }

      public boolean javaClassIsExact() {
        return value != null;
      }

      public boolean canBeNull() {
        return value == null;
      }
    }

    static public class WillFail extends LASValueDescriptor {

      public boolean canFail() {
        return true;
      }

      public boolean willFail() {
        return true;
      }
    }

    static public LASValueDescriptor fromClass(Class c) {
      return new NonExact(c, true);
    }
  }

  static public class PingSourceCancelledException extends RuntimeException implements IFieldsToList {

    public PingSource pingSource;

    public PingSourceCancelledException() {
    }

    public PingSourceCancelledException(PingSource pingSource) {
      this.pingSource = pingSource;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + pingSource + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { pingSource };
    }
  }

  static public class TokenRangeWithSrc extends TokenRange {

    public List<String> tok;

    public TokenRangeWithSrc() {
    }

    public TokenRangeWithSrc(List<String> tok, int start) {
      this.start = start;
      end = start;
    }

    public TokenRangeWithSrc(List<String> tok, int start, int end) {
      this.end = end;
      this.start = start;
    }

    public TokenRangeWithSrc(ListAndIndex<String> startPtr, ListAndIndex<String> endPtr) {
      assertNotNull("startPtr", startPtr);
      assertNotNull("endPtr", endPtr);
      assertSame(tok = startPtr.list(), endPtr.list());
      start = startPtr.idx();
      end = endPtr.idx();
    }

    public ListAndIndex<String> startPtr() {
      return new ListAndIndex(tok, start);
    }

    public ListAndIndex<String> endPtr() {
      return new ListAndIndex(tok, end);
    }

    public LineAndColumn startLineAndCol() {
      return tokenToLineAndColumn(startPtr());
    }

    public LineAndColumn endLineAndCol() {
      return tokenToLineAndColumn(endPtr());
    }

    public String text() {
      return joinSubList(tok, start, end);
    }

    public String toString() {
      var start = startLineAndCol();
      if (eq(start, end))
        return str(start);
      return start + " to " + endLineAndCol();
    }

    public String fullSourceText() {
      return join(tok);
    }
  }

  static public class FileBasedLock implements AutoCloseable {

    public File lockFile;

    public double timeout = 60.0;

    public boolean verbose = false;

    public boolean haveLock = false;

    public java.util.Timer touchTimer;

    final public FileBasedLock setContentsForLockFile(String contentsForLockFile) {
      return contentsForLockFile(contentsForLockFile);
    }

    public FileBasedLock contentsForLockFile(String contentsForLockFile) {
      this.contentsForLockFile = contentsForLockFile;
      return this;
    }

    final public String getContentsForLockFile() {
      return contentsForLockFile();
    }

    public String contentsForLockFile() {
      return contentsForLockFile;
    }

    public String contentsForLockFile;

    public FileBasedLock() {
    }

    public FileBasedLock(File lockFile) {
      this.lockFile = lockFile;
    }

    public FileBasedLock(File lockFile, double timeout) {
      this.timeout = timeout;
      this.lockFile = lockFile;
    }

    synchronized public boolean tryToLock() {
      if (haveLock)
        return true;
      if (fileExists(lockFile)) {
        double age = fileAgeInSeconds(lockFile);
        double remaining = timeout - age;
        print("Lock file age: " + lockFile + ": " + iround(age) + " s" + (remaining <= 0 ? " - old, deleting" : " - please start again in " + nSeconds(iceil(remaining))));
        if (remaining <= 0) {
          print("Deleting old lock file (program crashed?): " + lockFile + " (age: " + iround(age) + " seconds)");
          deleteFile(lockFile);
        }
      }
      try {
        mkdirsForFile(lockFile);
        java.nio.file.Files.createFile(toPath(lockFile));
        if (nempty(contentsForLockFile))
          writeContents();
        acquired();
        return true;
      } catch (Throwable e) {
        printExceptionShort("Can't lock", e);
        return false;
      }
    }

    public void writeContents() {
      saveTextFileWithoutTemp(lockFile, unnull(contentsForLockFile));
    }

    final public void acquired() {
      haveLock = true;
      startTouchTimer();
    }

    public void forceLock() {
      try {
        print("Force-locking " + lockFile);
        writeContents();
        acquired();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String lockError() {
      return "Couldn't aquire lock file: " + lockFile;
    }

    public void lockOrFail() {
      if (!tryToLock())
        throw fail(lockError());
    }

    synchronized public void startTouchTimer() {
      if (touchTimer != null)
        return;
      double interval = timeout / 2;
      touchTimer = doEvery(interval, new Runnable() {

        public void run() {
          try {
            doTouch();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "doTouch();";
        }
      });
      if (verbose)
        print("Touch timer started for " + lockFile + " (" + interval + "s)");
    }

    synchronized public void doTouch() {
      try {
        if (haveLock) {
          if (verbose)
            print("Touching lock file: " + lockFile);
          touchExistingFile(lockFile);
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }

    public synchronized void close() {
      try {
        {
          cleanUp(touchTimer);
          touchTimer = null;
        }
        if (haveLock) {
          haveLock = false;
          if (verbose)
            print("Deleting lock file: " + lockFile);
          deleteFile(lockFile);
        }
      } catch (Throwable __e) {
        printStackTrace(__e);
      }
    }

    synchronized public void _simulateCrash() {
      {
        cleanUp(touchTimer);
        touchTimer = null;
      }
    }

    public void deleteOnExit() {
      if (haveLock)
        lockFile.deleteOnExit();
    }

    public String actualContents() {
      return loadTextFile(lockFile);
    }

    public boolean hasExpectedContents() {
      return eq(unnull(contentsForLockFile), actualContents());
    }
  }

  static public class LASScope {

    final public LASScope setUseFixedVars(boolean useFixedVars) {
      return useFixedVars(useFixedVars);
    }

    public LASScope useFixedVars(boolean useFixedVars) {
      this.useFixedVars = useFixedVars;
      return this;
    }

    final public boolean getUseFixedVars() {
      return useFixedVars();
    }

    public boolean useFixedVars() {
      return useFixedVars;
    }

    public boolean useFixedVars = false;

    final public Map<String, LASValueDescriptor> getDeclaredVars() {
      return declaredVars();
    }

    public Map<String, LASValueDescriptor> declaredVars() {
      return declaredVars;
    }

    public Map<String, LASValueDescriptor> declaredVars = new HashMap();

    final public LASScope setParentScope(LASScope parentScope) {
      return parentScope(parentScope);
    }

    public LASScope parentScope(LASScope parentScope) {
      this.parentScope = parentScope;
      return this;
    }

    final public LASScope getParentScope() {
      return parentScope();
    }

    public LASScope parentScope() {
      return parentScope;
    }

    public LASScope parentScope;

    final public LASScope setParentIsDetached(boolean parentIsDetached) {
      return parentIsDetached(parentIsDetached);
    }

    public LASScope parentIsDetached(boolean parentIsDetached) {
      this.parentIsDetached = parentIsDetached;
      return this;
    }

    final public boolean getParentIsDetached() {
      return parentIsDetached();
    }

    public boolean parentIsDetached() {
      return parentIsDetached;
    }

    public boolean parentIsDetached = false;

    public String[] names;

    public LASScope() {
    }

    public LASScope(LASScope parentScope) {
      this.parentScope = parentScope;
    }

    public boolean resolved() {
      return names != null;
    }

    public void addDeclaredVar(String name, LASValueDescriptor type) {
      if (resolved())
        throw fail("Can't add variables to resolved scope");
      declaredVars.put(name, type);
    }

    public int resolveVar(String name) {
      resolve();
      int idx = indexOfInSortedArray(names, name);
      if (idx < 0)
        throw fail("Variable not found in scope: " + name);
      return idx;
    }

    public void resolve() {
      if (names != null)
        return;
      names = empty(declaredVars) ? null : toStringArray(sortedKeys(declaredVars));
    }
  }

  static public interface ValueConverterForField {

    public OrError<Object> convertValue(Object object, Field field, Object value);
  }

  static public class ClassNameResolver {

    final public ClassNameResolver setByteCodePath(File byteCodePath) {
      return byteCodePath(byteCodePath);
    }

    public ClassNameResolver byteCodePath(File byteCodePath) {
      this.byteCodePath = byteCodePath;
      return this;
    }

    final public File getByteCodePath() {
      return byteCodePath();
    }

    public File byteCodePath() {
      return byteCodePath;
    }

    public File byteCodePath = byteCodePathForClass(getClass());

    public List<String> importedPackages = itemPlusList("java.lang", endingWith_dropSuffix(standardImports(), ".*"));

    public Set<String> allFullyQualifiedClassNames_cache;

    public Set<String> allFullyQualifiedClassNames() {
      if (allFullyQualifiedClassNames_cache == null)
        allFullyQualifiedClassNames_cache = allFullyQualifiedClassNames_load();
      return allFullyQualifiedClassNames_cache;
    }

    public Set<String> allFullyQualifiedClassNames_load() {
      Set<String> set = new HashSet();
      assertNotNull(byteCodePath);
      set.addAll(classNamesInJarOrDir(byteCodePath));
      printVars("ClassNameResolver", "byteCodePath", byteCodePath, "classesFound", l(set));
      set.addAll(classNamesInLoadedJigsawModules());
      return set;
    }

    public ClassNameResolver init() {
      allFullyQualifiedClassNames();
      return this;
    }

    public String findClass(String name) {
      for (String pkg : importedPackages) {
        String fullName = pkg + "." + name;
        if (allFullyQualifiedClassNames().contains(fullName))
          return fullName;
      }
      return null;
    }

    public void printMe() {
      printVars("ClassNameResolver", "byteCodePath", byteCodePath);
      print("importedPackages", importedPackages);
    }
  }

  static public class ThreadPool implements AutoCloseable {

    public int max = numberOfCores();

    public List<PooledThread> all = new ArrayList();

    public Set<PooledThread> used = new HashSet();

    public Set<PooledThread> free = new HashSet();

    public boolean verbose, retired;

    public class InternalPingSource extends PingSource {
    }

    public InternalPingSource internalPingSource = new InternalPingSource();

    public MultiSleeper sleeper = new MultiSleeper();

    public ThreadPool() {
    }

    public ThreadPool(int max) {
      this.max = max;
    }

    synchronized public int maxSize() {
      return max;
    }

    synchronized public int total() {
      return l(used) + l(free);
    }

    transient public Set<Runnable> onCustomerMustWaitAlert;

    public ThreadPool onCustomerMustWaitAlert(Runnable r) {
      onCustomerMustWaitAlert = createOrAddToSyncLinkedHashSet(onCustomerMustWaitAlert, r);
      return this;
    }

    public ThreadPool removeCustomerMustWaitAlertListener(Runnable r) {
      main.remove(onCustomerMustWaitAlert, r);
      return this;
    }

    public void customerMustWaitAlert() {
      if (onCustomerMustWaitAlert != null)
        for (var listener : onCustomerMustWaitAlert) pcallF_typed(listener);
    }

    public void fireCustomerMustWaitAlert() {
      vmBus_send("customerMustWaitAlert", this, currentThread());
      customerMustWaitAlert();
    }

    public PooledThread acquireThreadOrQueue(Runnable action) {
      if (action == null)
        return null;
      PooledThread t;
      synchronized (this) {
        if (_hasFreeAfterCreating()) {
          t = _firstFreeThread();
          markUsed(t);
        } else
          t = _anyThread();
      }
      t.addWork(action);
      return t;
    }

    public boolean _hasFreeAfterCreating() {
      checkNotRetired();
      if (nempty(free))
        return true;
      if (total() < max) {
        PooledThread t = newThread();
        all.add(t);
        free.add(t);
        return true;
      }
      return false;
    }

    public PooledThread acquireThreadOrWait(Runnable action) {
      try {
        if (action == null)
          return null;
        PooledThread t;
        while (true) {
          synchronized (this) {
            if (_hasFreeAfterCreating()) {
              t = _firstFreeThread();
              break;
            } else
              _waitWaitWait();
          }
        }
        t.addWork(action);
        return t;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public PooledThread _firstFreeThread() {
      return first(free);
    }

    public PooledThread _anyThread() {
      return random(used);
    }

    public class PooledThread extends Thread {

      public PooledThread(String name) {
        super(name);
      }

      public AppendableChain<Runnable> q;

      synchronized public Runnable _grabWorkOrSleep() {
        try {
          Runnable r = first(q);
          if (r == null) {
            markFree(this);
            if (verbose)
              print("Thread sleeps");
            synchronized (this) {
              wait();
            }
            if (verbose)
              print("Thread woke up");
            return null;
          }
          q = popFirst(q);
          return r;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void run() {
        try {
          pingSource_tl().set(internalPingSource);
          while (!retired()) {
            ping();
            Runnable r = _grabWorkOrSleep();
            if (verbose)
              print(this + " work: " + r);
            if (r != null)
              try {
                if (verbose)
                  print(this + " running: " + r);
                r.run();
                pingSource_tl().set(internalPingSource);
                if (verbose)
                  print(this + " done");
              } catch (Throwable e) {
                pingSource_tl().set(internalPingSource);
                if (verbose)
                  print(this + " error");
                printStackTrace(e);
              } finally {
                pingSource_tl().set(internalPingSource);
                if (verbose)
                  print("ThreadPool finally");
              }
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      synchronized public boolean isEmpty() {
        return empty(q);
      }

      public void addWork(Runnable r) {
        if (verbose)
          print("Added work to " + this + ": " + r);
        synchronized (this) {
          q = chainPlus(q, r);
          notifyAll();
        }
      }
    }

    public PooledThread newThread() {
      PooledThread t = new PooledThread("Thread Pool Inhabitant " + n2(total() + 1));
      t.start();
      return t;
    }

    synchronized public void markFree(PooledThread t) {
      used.remove(t);
      free.add(t);
      notifyAll();
    }

    synchronized public void markUsed(PooledThread t) {
      free.remove(t);
      used.add(t);
    }

    synchronized public String toString() {
      return retired() ? "Retired ThreadPool" : "ThreadPool " + roundBracket(commaCombine(n2(used) + " used out of " + n2(total()), max <= total() ? null : "could grow to " + n2(max)));
    }

    synchronized public boolean retired() {
      return retired;
    }

    synchronized public void retire() {
      if (verbose)
        print("ThreadPool Retiring");
      retired = true;
      for (var thread : free) syncNotifyAll(thread);
    }

    public void checkNotRetired() {
      if (retired())
        throw fail("retired");
    }

    synchronized public void close() {
      try {
        retire();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void _waitWaitWait() {
      try {
        do {
          fireCustomerMustWaitAlert();
          wait();
          checkNotRetired();
        } while (empty(free));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void dO(String text, Runnable r) {
      if (r == null)
        return;
      new PingSource(this, text).dO(r);
    }

    public ISleeper_v2 sleeper() {
      return sleeper;
    }
  }

  static public class HTML implements IF0<String>, IFieldsToList {

    public String html;

    public HTML() {
    }

    public HTML(String html) {
      this.html = html;
    }

    public boolean equals(Object o) {
      if (!(o instanceof HTML))
        return false;
      HTML __1 = (HTML) o;
      return eq(html, __1.html);
    }

    public int hashCode() {
      int h = 2228139;
      h = boostHashCombine(h, _hashCode(html));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { html };
    }

    public String get() {
      return html;
    }

    public String toString() {
      return html;
    }
  }

  static public class SecretValue<A> extends Var<A> {

    public SecretValue() {
    }

    public SecretValue(A a) {
      super(a);
    }

    public String toString() {
      return "Secret value";
    }
  }

  static final public class ParameterizedTypeImpl implements ParameterizedType {

    public ParameterizedTypeImpl() {
    }

    public Type ownerType;

    public Type rawType;

    public Type[] typeArguments;

    public ParameterizedTypeImpl(Type ownerType, Type rawType, Type... typeArguments) {
      this.typeArguments = typeArguments;
      this.rawType = rawType;
      this.ownerType = ownerType;
    }

    public Type[] getActualTypeArguments() {
      return typeArguments;
    }

    public Type getRawType() {
      return rawType;
    }

    public Type getOwnerType() {
      return ownerType;
    }

    @Override
    public boolean equals(Object other) {
      if (other instanceof ParameterizedType)
        return eq(ownerType, ((ParameterizedType) other).getOwnerType()) && eq(rawType, ((ParameterizedType) other).getRawType()) && eq(asList(typeArguments), asList(((ParameterizedType) other).getActualTypeArguments()));
      return false;
    }

    @Override
    public int hashCode() {
      return Arrays.hashCode(typeArguments) ^ rawType.hashCode() ^ _hashCode(ownerType);
    }

    @Override
    public String toString() {
      int length = typeArguments.length;
      if (length == 0)
        return typeToString(rawType);
      StringBuilder stringBuilder = new StringBuilder();
      stringBuilder.append(typeToString(rawType)).append("<").append(typeToString(typeArguments[0]));
      for (int i = 1; i < length; i++) {
        stringBuilder.append(", ").append(typeToString(typeArguments[i]));
      }
      return stringBuilder.append(">").toString();
    }

    static public String typeToString(Type type) {
      return type instanceof Class ? ((Class<?>) type).getName() : type.toString();
    }
  }

  public interface ILASClassLoader {

    public Class<?> defineLASClass(String name, IF0<byte[]> generateClass);

    public Object rememberClassBytes(boolean rememberClassBytes);
  }

  static public class ParsedWithTokens<A> extends Var<A> {

    public List<String> tok;

    public int iStart;

    public int iRemaining;

    public ParsedWithTokens() {
    }

    public ParsedWithTokens(A a) {
      super(a);
    }

    public ParsedWithTokens(A a, List<String> tok, int iStart, int iRemaining) {
      super(a);
      this.iRemaining = iRemaining;
      this.iStart = iStart;
      this.tok = tok;
    }

    public String parsedText() {
      return joinSubList(tok, iStart | 1, iRemaining & ~1);
    }

    public ListAndIndex<String> remaining() {
      return new ListAndIndex(tok, iRemaining);
    }

    public ListAndIndex<String> start() {
      return new ListAndIndex(tok, iStart);
    }

    public int length() {
      return iRemaining - iStart;
    }

    public <B> ParsedWithTokens<B> withValue(B b) {
      return new ParsedWithTokens<B>(b, tok, iStart, iRemaining);
    }

    public String toString() {
      return "Parsed " + quote(parsedText()) + " as " + super.toString();
    }

    public void replaceTokens(String s) {
      main.replaceTokens(tok, iStart, iRemaining, s);
    }
  }

  static public class LASClassDef {

    final public LASClassDef setUserGivenName(String userGivenName) {
      return userGivenName(userGivenName);
    }

    public LASClassDef userGivenName(String userGivenName) {
      this.userGivenName = userGivenName;
      return this;
    }

    final public String getUserGivenName() {
      return userGivenName();
    }

    public String userGivenName() {
      return userGivenName;
    }

    public String userGivenName;

    final public LASClassDef setClassDefPrefix(String classDefPrefix) {
      return classDefPrefix(classDefPrefix);
    }

    public LASClassDef classDefPrefix(String classDefPrefix) {
      this.classDefPrefix = classDefPrefix;
      return this;
    }

    final public String getClassDefPrefix() {
      return classDefPrefix();
    }

    public String classDefPrefix() {
      return classDefPrefix;
    }

    public String classDefPrefix = "userCode.";

    final public LASClassDef setFullCompilation(boolean fullCompilation) {
      return fullCompilation(fullCompilation);
    }

    public LASClassDef fullCompilation(boolean fullCompilation) {
      this.fullCompilation = fullCompilation;
      return this;
    }

    final public boolean getFullCompilation() {
      return fullCompilation();
    }

    public boolean fullCompilation() {
      return fullCompilation;
    }

    public boolean fullCompilation = false;

    final public LASClassDef setVerbose(boolean verbose) {
      return verbose(verbose);
    }

    public LASClassDef verbose(boolean verbose) {
      this.verbose = verbose;
      return this;
    }

    final public boolean getVerbose() {
      return verbose();
    }

    public boolean verbose() {
      return verbose;
    }

    public boolean verbose = true;

    public List<FieldDef> fields = new ArrayList();

    public List<GazelleV_LeftArrowScript.FunctionDef> methods = new ArrayList();

    public List<GazelleV_LeftArrowScript.FunctionDef> methodBodies = new ArrayList();

    static public class FieldDef {

      final public FieldDef setName(String name) {
        return name(name);
      }

      public FieldDef name(String name) {
        this.name = name;
        return this;
      }

      final public String getName() {
        return name();
      }

      public String name() {
        return name;
      }

      public String name;

      final public FieldDef setType(Type type) {
        return type(type);
      }

      public FieldDef type(Type type) {
        this.type = type;
        return this;
      }

      final public Type getType() {
        return type();
      }

      public Type type() {
        return type;
      }

      public Type type;
    }

    public String structForHash() {
      return GazelleV_LeftArrowScript.scriptStruct(litorderedmap("userGivenName", userGivenName, "fields", fields, "methods", methods, "fullCompilation", fullCompilation));
    }

    public String classHash_cache;

    public String classHash() {
      if (classHash_cache == null)
        classHash_cache = classHash_load();
      return classHash_cache;
    }

    public String classHash_load() {
      String struct = structForHash();
      if (verbose)
        print("structForHash", struct);
      return md5(struct);
    }

    public String finalClassName() {
      return classDefPrefix() + finalClassNameWithoutPrefix();
    }

    public String finalClassNameWithoutPrefix() {
      return or2(userGivenName, "C") + "_" + classHash();
    }

    public byte[] toBytes_cache;

    public byte[] toBytes() {
      if (toBytes_cache == null)
        toBytes_cache = toBytes_load();
      return toBytes_cache;
    }

    public byte[] toBytes_load() {
      ClassMaker classMaker = new ClassMaker(finalClassName());
      var cp = classMaker.getConstantPool();
      for (var field : fields) {
        var type = field.type;
        var fg = new FieldGen(Const.ACC_PUBLIC, typeToBCELType(type), field.name, cp);
        if (type instanceof ParameterizedType)
          fg.addAttribute(new org.apache.bcel.classfile.Signature(cp.addUtf8("Signature"), 2, cp.addUtf8(typeToVMSignature((ParameterizedType) type)), cp.getConstantPool()));
        classMaker.addField(fg);
      }
      for (var method : methods) if (fullCompilation)
        fullyCompileMethod(classMaker, method);
      else
        semiCompileMethod(classMaker, method);
      classMaker.addDefaultConstructor();
      return classMaker.toBytes();
    }

    public void semiCompileMethod(ClassMaker classMaker, GazelleV_LeftArrowScript.FunctionDef method) {
      int iMethod = l(methodBodies);
      methodBodies.add(method);
      String bodyFieldName = "_body" + iMethod;
      classMaker.addField(new FieldGen(Const.ACC_PUBLIC | Const.ACC_STATIC, classToBCELType(GazelleV_LeftArrowScript.Evaluable.class), bodyFieldName, classMaker.getConstantPool()));
      int nArgs = l(method.args);
      MethodMaker mm = new MethodMaker(classMaker, Object.class, method.name, repArray(Class.class, Object.class, nArgs));
      int iThis = 0, iFirstArg = 1, iCtx = iFirstArg + nArgs;
      mm.newObject(FlexibleVarContext.class);
      mm.astore(iCtx);
      mm.aload(iCtx);
      mm.stringConstant("this");
      mm.aload(iThis);
      mm.invokeVirtual(VarContext.class, void.class, "put", String.class, Object.class);
      for (int iArg = 0; iArg < nArgs; iArg++) {
        mm.aload(iCtx);
        mm.stringConstant(method.args[iArg]);
        mm.aload(iFirstArg + iArg);
        mm.invokeVirtual(VarContext.class, void.class, "put", String.class, Object.class);
      }
      mm.getStaticField(classMaker.className(), bodyFieldName, GazelleV_LeftArrowScript.Evaluable.class);
      mm.aload(iCtx);
      mm.invokeInterface(GazelleV_LeftArrowScript.Evaluable.class, Object.class, "get", VarContext.class);
      mm.areturn();
      mm.done();
    }

    public void fullyCompileMethod(ClassMaker classMaker, GazelleV_LeftArrowScript.FunctionDef method) {
      MethodMaker mm = new MethodMaker(classMaker, Object.class, method.name, repArray(Class.class, Object.class, l(method.args)));
      var tbc = new LASToByteCode(mm) {

        public JVMStackCellType compileGetVar(GazelleV_LeftArrowScript.GetVar code) {
          if (eq(code.var, "this")) {
            mm.aload(0);
            return JVMStackCellType.objValue;
          }
          int iArg = indexOf(method.args, code.var);
          if (iArg >= 0) {
            mm.aload(iArg + 1);
            return JVMStackCellType.objValue;
          }
          return super.compileGetVar(code);
        }
      };
      tbc.postConversion = stackTop -> mm.convertToObject(stackTop);
      tbc.compileScript(method.body);
      mm.areturn();
      mm.done();
    }

    public void init(Class c) {
      for (int iMethod = 0; iMethod < l(methodBodies); iMethod++) {
        String bodyFieldName = "_body" + iMethod;
        set(c, bodyFieldName, methodBodies.get(iMethod).body);
      }
    }
  }

  abstract static public class ConceptFieldIndexBase<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter, AutoCloseable {

    public Concepts concepts;

    public Class<A> cc;

    public String field;

    public Map<A, Val> objectToValue = syncHashMap();

    public MultiSetMap<Val, A> valueToObject;

    public ConceptFieldIndexBase() {
      init();
    }

    public ConceptFieldIndexBase(Class<A> cc, String field) {
      this(db_mainConcepts(), cc, field);
    }

    public ConceptFieldIndexBase(Concepts concepts, Class<A> cc, String field) {
      this();
      this.field = field;
      this.cc = cc;
      this.concepts = concepts;
      concepts.addConceptIndex(this);
      updateAll();
      register();
      updateAll();
    }

    public void updateAll() {
      for (A c : setToIndex()) updateImpl(c);
    }

    public Collection<A> setToIndex() {
      return list(concepts, cc);
    }

    abstract public void init();

    abstract public void register();

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl((A) c);
    }

    synchronized public void updateImpl(A c) {
      Val newValue = (Val) (cget(c, field));
      Val oldValue = objectToValue.get(c);
      if (newValue == oldValue && (oldValue != null || objectToValue.containsKey(c)))
        return;
      valueToObject.remove(oldValue, c);
      valueToObject.put(newValue, c);
      put(objectToValue, c, newValue);
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      if (!objectToValue.containsKey(c))
        return;
      Val value = objectToValue.get(c);
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    synchronized public A get(Val value) {
      return valueToObject.getFirst(value);
    }

    public synchronized Collection<A> getAll(Val value) {
      return valueToObject.get(value);
    }

    public synchronized List<Val> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public IterableIterator<A> objectIterator() {
      return navigableMultiSetMapValuesIterator_concurrent(valueToObject, this);
    }

    public synchronized MultiSet<Val> allValues_multiSet() {
      return multiSetMapToMultiSet(valueToObject);
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }

    public Object mutex() {
      return this;
    }

    public void close() {
      try {
        concepts.removeConceptIndex(this);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class SynchronizedCollection<E> implements Collection<E>, Serializable {

    public SynchronizedCollection() {
    }

    @java.io.Serial
    static final public long serialVersionUID = 3053995032091335093L;

    @SuppressWarnings("serial")
    public Collection<E> c;

    @SuppressWarnings("serial")
    public Object mutex;

    public SynchronizedCollection(Collection<E> c) {
      this.c = Objects.requireNonNull(c);
      mutex = this;
    }

    public SynchronizedCollection(Collection<E> c, Object mutex) {
      this.c = Objects.requireNonNull(c);
      this.mutex = Objects.requireNonNull(mutex);
    }

    public int size() {
      synchronized (mutex) {
        return c.size();
      }
    }

    public boolean isEmpty() {
      synchronized (mutex) {
        return c.isEmpty();
      }
    }

    public boolean contains(Object o) {
      synchronized (mutex) {
        return c.contains(o);
      }
    }

    public Object[] toArray() {
      synchronized (mutex) {
        return c.toArray();
      }
    }

    public <T> T[] toArray(T[] a) {
      synchronized (mutex) {
        return c.toArray(a);
      }
    }

    public <T> T[] toArray(java.util.function.IntFunction<T[]> f) {
      synchronized (mutex) {
        return c.toArray(f);
      }
    }

    public Iterator<E> iterator() {
      return c.iterator();
    }

    public boolean add(E e) {
      synchronized (mutex) {
        return c.add(e);
      }
    }

    public boolean remove(Object o) {
      synchronized (mutex) {
        return c.remove(o);
      }
    }

    public boolean containsAll(Collection<?> coll) {
      synchronized (mutex) {
        return c.containsAll(coll);
      }
    }

    public boolean addAll(Collection<? extends E> coll) {
      synchronized (mutex) {
        return c.addAll(coll);
      }
    }

    public boolean removeAll(Collection<?> coll) {
      synchronized (mutex) {
        return c.removeAll(coll);
      }
    }

    public boolean retainAll(Collection<?> coll) {
      synchronized (mutex) {
        return c.retainAll(coll);
      }
    }

    public void clear() {
      synchronized (mutex) {
        c.clear();
      }
    }

    public String toString() {
      synchronized (mutex) {
        return c.toString();
      }
    }

    @Override
    public void forEach(java.util.function.Consumer<? super E> consumer) {
      synchronized (mutex) {
        c.forEach(consumer);
      }
    }

    @Override
    public boolean removeIf(java.util.function.Predicate<? super E> filter) {
      synchronized (mutex) {
        return c.removeIf(filter);
      }
    }

    @Override
    public Spliterator<E> spliterator() {
      return c.spliterator();
    }

    @Override
    public java.util.stream.Stream<E> stream() {
      return c.stream();
    }

    @Override
    public java.util.stream.Stream<E> parallelStream() {
      return c.parallelStream();
    }

    @java.io.Serial
    final public void writeObject(ObjectOutputStream s) throws IOException {
      synchronized (mutex) {
        s.defaultWriteObject();
      }
    }
  }

  static public class SynchronizedRandomAccessList<E> extends SynchronizedList<E> implements RandomAccess {

    public SynchronizedRandomAccessList() {
    }

    public SynchronizedRandomAccessList(List<E> list) {
      super(list);
    }

    public SynchronizedRandomAccessList(List<E> list, Object mutex) {
      super(list, mutex);
    }

    public List<E> subList(int fromIndex, int toIndex) {
      synchronized (mutex) {
        return new SynchronizedRandomAccessList<>(list.subList(fromIndex, toIndex), mutex);
      }
    }

    @java.io.Serial
    static final public long serialVersionUID = 1530674583602358482L;

    @java.io.Serial
    final public Object writeReplace() {
      return new SynchronizedList<>(list);
    }
  }

  static public class HTMLAceEditor implements Htmlable {

    public String text;

    public String name = "text";

    public String id;

    public Map divParams = litmap("style", "width: 80ch; height: 20em");

    public String onKeyDown;

    public HTMLAceEditor() {
    }

    public HTMLAceEditor(String text) {
      this.text = text;
    }

    public String headStuff() {
      return hscriptsrc("https://botcompany.de/ace-builds/src-noconflict/ace.js") + hscriptsrc("https://botcompany.de/ace-builds/src-noconflict/ext-language_tools.js");
    }

    public String html() {
      id = "ace_" + name;
      return div(htmlEncode2(text), params_stylePlus("display: none", paramsPlus(mapToParams(divParams), "id", id))) + hhiddenWithIDAndName(name) + hscript(replaceDollarVars(" (function() {\r\n        ace.require(\"ace/ext/language_tools\");\r\n        var editor = ace.edit($id);\r\n        editor.setTheme(\"ace/theme/ambience\");\r\n        editor.getSession().setTabSize(2);\r\n        editor.getSession().setUseSoftTabs(true);\r\n        editor.getSession().setUseWrapMode(true);\r\n        document.getElementById($id).style.fontSize='15px';\r\n        editor.setOptions({\r\n          enableBasicAutocompletion: true\r\n        });\r\n      \r\n        var div = $(\"#\" + $id);\r\n        var hiddenVal = document.getElementById($name);\r\n        function updateHidden() {\r\n          div.trigger('input'); // for auto-expand\r\n          //hiddenVal.value = editor.getValue();\r\n          var newVal = editor.getValue();\r\n          if (hiddenVal.value != newVal)\r\n            $(hiddenVal).val(newVal).trigger('change');\r\n        }\r\n        updateHidden();\r\n      \r\n        editor.session.on('change', updateHidden);\r\n        $onKeyDown\r\n  \r\n        div.show();\r\n        //editor.focus();\r\n      })() ", "id", jsQuote(id), "name", jsQuote(name), "onKeyDown", empty(onKeyDown) ? "" : "editor.textInput.getElement().onkeydown = " + onKeyDown + ";"));
    }

    public String complete() {
      return linesLL(headStuff(), html());
    }
  }

  static public class VStack implements Steppable, IVStack {

    public List<Computable> stack = new ArrayList();

    public Object latestResult;

    transient public Object newResult;

    static public class NullSentinel {
    }

    static public NullSentinel nullSentinel = new NullSentinel();

    public VStack() {
    }

    public VStack(Computable computation) {
      push(computation);
    }

    public VStack(Iterable<Computable> l) {
      pushAll(l);
    }

    public interface Computable<A> {

      public void step(VStack stack, Object subComputationResult);
    }

    final public Object deSentinel(Object o) {
      return o instanceof NullSentinel ? null : o;
    }

    final public Object sentinel(Object o) {
      return o == null ? nullSentinel : o;
    }

    public void push(Computable computation) {
      stack.add(assertNotNull(computation));
    }

    public boolean step() {
      if (empty(stack))
        return false;
      newResult = null;
      last(stack).step(this, result());
      latestResult = newResult;
      newResult = null;
      return true;
    }

    public void _return(Object value) {
      newResult = sentinel(value);
      pop();
    }

    final public void replace(Computable computation) {
      tailCall(computation);
    }

    public void tailCall(Computable computation) {
      pop();
      stack.add(computation);
    }

    public <A> A compute(Computable<A> computation) {
      if (computation == null)
        return null;
      push(computation);
      stepAll(this);
      return (A) latestResult;
    }

    final public Object subResult() {
      return result();
    }

    public Object result() {
      return deSentinel(latestResult);
    }

    public boolean hasSubResult() {
      return latestResult != null;
    }

    public void pushAll(Iterable<Computable> l) {
      for (Computable c : unnullForIteration(l)) push(c);
    }

    public void add(Runnable r) {
      if (r == null)
        return;
      push((stack, subComputationResult) -> r.run());
    }

    public Computable caller() {
      return nextToLast(stack);
    }

    public void pop() {
      removeLast(stack);
    }

    public boolean isEmpty() {
      return empty(stack);
    }
  }

  static public class SimpleLeftToRightParser extends Meta {

    public String text;

    public List<String> tok;

    final public ListAndIndex<String> getPtr() {
      return ptr();
    }

    public ListAndIndex<String> ptr() {
      return ptr;
    }

    public ListAndIndex<String> ptr;

    public ListAndIndex<String> mainLoopPtr;

    public String currentToken;

    public boolean caseInsensitive = false;

    public List warnings = new ArrayList();

    public SimpleLeftToRightParser() {
    }

    public SimpleLeftToRightParser(String text) {
      this.text = text;
    }

    public SimpleLeftToRightParser(List<String> tok) {
      this.tok = tok;
    }

    transient public IF1<String, List<String>> tokenize;

    public List<String> tokenize(String text) {
      return tokenize != null ? tokenize.get(text) : tokenize_base(text);
    }

    final public List<String> tokenize_fallback(IF1<String, List<String>> _f, String text) {
      return _f != null ? _f.get(text) : tokenize_base(text);
    }

    public List<String> tokenize_base(String text) {
      return javaTok(text);
    }

    final public String token() {
      return t();
    }

    public String t() {
      return currentToken;
    }

    public String token(int i) {
      return get(tok, ptr.idx() + i * 2);
    }

    final public String consume() {
      return next();
    }

    final public String tpp() {
      return next();
    }

    public String next() {
      var t = t();
      next(1);
      return t;
    }

    final public String prevSpace() {
      return lastSpace();
    }

    public String lastSpace() {
      return get(tok, ptr.idx() - 1);
    }

    public String nextSpace() {
      return get(tok, ptr.idx() + 1);
    }

    public String space(int i) {
      return get(tok, ptr.idx() + i * 2 + 1);
    }

    public void unconsume() {
      next(-1);
    }

    final public boolean eqTok(String a, String b) {
      return tokEq(a, b);
    }

    public boolean tokEq(String a, String b) {
      return eqOrEqic(caseInsensitive, a, b);
    }

    public boolean tokEqOneOf(String a, String... l) {
      return any(l, b -> tokEq(a, b));
    }

    public boolean is(int i, String t) {
      return tokEq(token(i), t);
    }

    public boolean is(String t) {
      return tokEq(currentToken, t);
    }

    public boolean was(String t) {
      return tokEq(token(-1), t);
    }

    public boolean isOneOf(String... tokens) {
      return tokEqOneOf(currentToken, tokens);
    }

    public String[] consumeArray(int n) {
      String[] array = new String[n];
      for (int i = 0; i < n; i++) array[i] = consume();
      return array;
    }

    public boolean isInteger() {
      return isInteger(t());
    }

    public boolean isInteger(String s) {
      return main.isInteger(s);
    }

    public boolean isIdentifier() {
      return isIdentifier(t());
    }

    public boolean isIdentifier(String s) {
      return main.isIdentifier(s);
    }

    public String consumeIdentifier() {
      return assertIdentifier(consume());
    }

    public boolean consumeOpt(String token) {
      if (!is(token))
        return false;
      consume();
      return true;
    }

    public void consume(String token) {
      if (!is(token))
        throw fail("Expected " + quote(token) + ", got " + describeToken(token()));
      consume();
    }

    public String describeToken(String token) {
      return token == null ? "EOF" : quote(token);
    }

    public String consumeOneOf(String... tokens) {
      if (!isOneOf(tokens))
        throw fail("Expected one of " + asList(tokens));
      return consume();
    }

    public void ptr(ListAndIndex<String> ptr) {
      this.ptr = ptr;
      fetch();
    }

    final public int tokIdx() {
      return idx();
    }

    public int idx() {
      return ptr.idx();
    }

    public int lTok() {
      return l(tok);
    }

    public int nRemainingTokens() {
      return (lTok() - idx()) / 2;
    }

    final public boolean endOfText() {
      return atEnd();
    }

    public boolean atEnd() {
      return ptr.atEnd();
    }

    public void fetch() {
      currentToken = ptr.get();
    }

    public boolean lineBreak() {
      return containsLineBreak(get(tok, ptr.idx() - 1));
    }

    public boolean atEndOrLineBreak() {
      return atEnd() || lineBreak();
    }

    public void init() {
      if (tok == null)
        tok = tokenize(text);
      if (ptr == null)
        ptr(new ListAndIndex(tok, 1));
    }

    public boolean mainLoop() {
      init();
      if (atEnd())
        return false;
      if (eq(mainLoopPtr, ptr))
        throw fail("main loop didn't advance (current token: " + quote(token()) + ")");
      mainLoopPtr = ptr;
      return true;
    }

    public class AssureAdvance {

      public ListAndIndex<String> cur;

      {
        init();
      }

      public boolean get() {
        if (atEnd())
          return false;
        if (eq(cur, ptr))
          throw fail("Parse loop didn't advance (current token: " + quote(token()) + ")");
        cur = ptr;
        return true;
      }
    }

    public void unknownToken() {
      warn("Unknown token: " + t());
    }

    public void warn(String msg) {
      warnings.add(print(msg));
    }

    final public void skip(int n) {
      next(n);
    }

    public void next(int n) {
      ptr(min(lTok(), ptr.idx() + n * 2));
    }

    public void ptr(int i) {
      ptr(new ListAndIndex(tok, min(i | 1, l(tok))));
    }

    public LineAndColumn lineAndColumn() {
      return tokenToLineAndColumn(ptr);
    }

    public LineAndColumn lineAndColumn(int idx) {
      return tokenToLineAndColumn(ptr.plus(idx * 2));
    }

    public String consumeUntilSpaceOr(IF0<Boolean> pred) {
      int i = idx();
      do next(); while (!atEnd() && empty(lastSpace()) && !pred.get());
      return joinSubList(tok, i, idx() - 1);
    }

    public void setText(String text) {
      this.text = text;
      tok = null;
      ptr = null;
    }

    public int relativeIndexOf(String token) {
      int n = nRemainingTokens();
      for (int i = 0; i < n; i++) if (eqTok(token(i), token))
        return i;
      return -1;
    }
  }

  public interface IMultiMap<A, B> {

    public Set<A> keySet();

    public Collection<B> get(A a);

    public int size();

    public int keyCount();
  }

  static public class MultiSet<A> implements IMultiSet<A> {

    public Map<A, Integer> map = new HashMap();

    public int size;

    public MultiSet(boolean useTreeMap) {
      if (useTreeMap)
        map = new TreeMap();
    }

    public MultiSet(TreeMap map) {
      this.map = map;
    }

    public MultiSet() {
    }

    public MultiSet(Iterable<A> c) {
      addAll(c);
    }

    public MultiSet(MultiSet<A> ms) {
      synchronized (ms) {
        for (A a : ms.keySet()) add(a, ms.get(a));
      }
    }

    public synchronized int add(A key) {
      return add(key, 1);
    }

    synchronized public void addAll(Iterable<A> c) {
      if (c != null)
        for (A a : c) add(a);
    }

    synchronized public void addAll(MultiSet<A> ms) {
      for (A a : ms.keySet()) add(a, ms.get(a));
    }

    synchronized public int add(A key, int count) {
      if (count <= 0)
        return 0;
      size += count;
      Integer i = map.get(key);
      map.put(key, i != null ? (count += i) : count);
      return count;
    }

    synchronized public void put(A key, int count) {
      int oldCount = get(key);
      if (count == oldCount)
        return;
      size += count - oldCount;
      if (count != 0)
        map.put(key, count);
      else
        map.remove(key);
    }

    public synchronized int get(A key) {
      Integer i = map.get(key);
      return i != null ? i : 0;
    }

    synchronized public boolean contains(A key) {
      return map.containsKey(key);
    }

    synchronized public void remove(A key) {
      Integer i = map.get(key);
      if (i != null) {
        --size;
        if (i > 1)
          map.put(key, i - 1);
        else
          map.remove(key);
      }
    }

    synchronized public List<A> topTen() {
      return getTopTen();
    }

    synchronized public List<A> getTopTen() {
      return getTopTen(10);
    }

    synchronized public List<A> getTopTen(int maxSize) {
      List<A> list = getSortedListDescending();
      return list.size() > maxSize ? list.subList(0, maxSize) : list;
    }

    synchronized public List<A> highestFirst() {
      return getSortedListDescending();
    }

    synchronized public List<A> lowestFirst() {
      return reversedList(getSortedListDescending());
    }

    synchronized public List<A> getSortedListDescending() {
      List<A> list = new ArrayList<A>(map.keySet());
      Collections.sort(list, new Comparator<A>() {

        public int compare(A a, A b) {
          return map.get(b).compareTo(map.get(a));
        }
      });
      return list;
    }

    synchronized public int getNumberOfUniqueElements() {
      return map.size();
    }

    synchronized public int uniqueSize() {
      return map.size();
    }

    synchronized public Set<A> asSet() {
      return map.keySet();
    }

    synchronized public NavigableSet<A> navigableSet() {
      return navigableKeys((NavigableMap) map);
    }

    synchronized public Set<A> keySet() {
      return map.keySet();
    }

    synchronized public A getMostPopularEntry() {
      int max = 0;
      A a = null;
      for (Map.Entry<A, Integer> entry : map.entrySet()) {
        if (entry.getValue() > max) {
          max = entry.getValue();
          a = entry.getKey();
        }
      }
      return a;
    }

    synchronized public void removeAll(A key) {
      size -= get(key);
      map.remove(key);
    }

    synchronized public int size() {
      return size;
    }

    synchronized public MultiSet<A> mergeWith(MultiSet<A> set) {
      MultiSet<A> result = new MultiSet<A>();
      for (A a : set.asSet()) {
        result.add(a, set.get(a));
      }
      return result;
    }

    synchronized public boolean isEmpty() {
      return map.isEmpty();
    }

    synchronized public String toString() {
      return str(map);
    }

    synchronized public void clear() {
      map.clear();
      size = 0;
    }

    final public Map<A, Integer> toMap() {
      return asMap();
    }

    synchronized public Map<A, Integer> asMap() {
      return cloneMap(map);
    }
  }

  static public class HTMLPaginator {

    public String startParam = "start";

    public String baseLink;

    public int start, step = 50;

    public int max;

    public void processParams(Map<String, String> params) {
      start = parseInt(mapGet(params, startParam));
    }

    public String renderNav(Object... __) {
      return pageNav2(baseLink, max, start, step, startParam, __);
    }

    public IntRange visibleRange() {
      return intRange(start, min(max, start + step));
    }
  }

  static public class HCRUD_Data {

    public Map<String, Renderer> renderers = new HashMap();

    public Map<String, String> fieldHelp = new HashMap();

    public Object currentValue;

    public boolean humanizeFieldNames = true;

    public Map<String, String> rawFormValues;

    abstract static public class Renderer {

      public String metaInfo;

      transient public IF1<Object, Object> preprocessValue;

      public Object preprocessValue(Object value) {
        return preprocessValue != null ? preprocessValue.get(value) : preprocessValue_base(value);
      }

      final public Object preprocessValue_fallback(IF1<Object, Object> _f, Object value) {
        return _f != null ? _f.get(value) : preprocessValue_base(value);
      }

      public Object preprocessValue_base(Object value) {
        return value;
      }
    }

    static public class NotEditable extends Renderer {
    }

    static public class TextArea extends Renderer implements IFieldsToList {

      public int cols;

      public int rows;

      public TextArea() {
      }

      public TextArea(int cols, int rows) {
        this.rows = rows;
        this.cols = cols;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + cols + ", " + rows + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextArea))
          return false;
        TextArea __1 = (TextArea) o;
        return cols == __1.cols && rows == __1.rows;
      }

      public int hashCode() {
        int h = -939552902;
        h = boostHashCombine(h, _hashCode(cols));
        h = boostHashCombine(h, _hashCode(rows));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols, rows };
      }

      public TextArea(int cols, int rows, IF1 preprocessValue) {
        this.cols = cols;
        this.rows = rows;
        this.preprocessValue = preprocessValue;
      }
    }

    static public class AceEditor extends TextArea {

      public AceEditor() {
      }

      public AceEditor(int cols, int rows) {
        this.rows = rows;
        this.cols = cols;
      }
    }

    static public class TextField extends Renderer implements IFieldsToList {

      public int cols;

      public TextField() {
      }

      public TextField(int cols) {
        this.cols = cols;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + cols + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextField))
          return false;
        TextField __2 = (TextField) o;
        return cols == __2.cols;
      }

      public int hashCode() {
        int h = 942981037;
        h = boostHashCombine(h, _hashCode(cols));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols };
      }
    }

    static public class AbstractComboBox extends Renderer implements IFieldsToList {

      public AbstractComboBox() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this);
      }

      public boolean equals(Object o) {
        return o instanceof AbstractComboBox;
      }

      public int hashCode() {
        int h = -1802496065;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }

      public boolean editable = false;

      transient public IF1<Object, String> valueToEntry;

      public String valueToEntry(Object value) {
        return valueToEntry != null ? valueToEntry.get(value) : valueToEntry_base(value);
      }

      final public String valueToEntry_fallback(IF1<Object, String> _f, Object value) {
        return _f != null ? _f.get(value) : valueToEntry_base(value);
      }

      public String valueToEntry_base(Object value) {
        return strOrNull(value);
      }
    }

    static public class ComboBox extends AbstractComboBox implements IFieldsToList {

      public List<String> entries;

      public ComboBox() {
      }

      public ComboBox(List<String> entries) {
        this.entries = entries;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + entries + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ComboBox))
          return false;
        ComboBox __3 = (ComboBox) o;
        return eq(entries, __3.entries);
      }

      public int hashCode() {
        int h = -547674755;
        h = boostHashCombine(h, _hashCode(entries));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { entries };
      }

      public ComboBox(String... entries) {
        this(asList(entries));
      }

      public ComboBox(boolean editable, String... entries) {
        this(entries);
        this.editable = editable;
      }

      public ComboBox(boolean editable, List<String> entries) {
        this(entries);
        this.editable = editable;
      }

      public ComboBox(List<String> entries, IF1<Object, String> valueToEntry) {
        this.entries = entries;
        this.valueToEntry = valueToEntry;
      }
    }

    static public class DynamicComboBox extends AbstractComboBox implements IFieldsToList {

      public String info;

      public DynamicComboBox() {
      }

      public DynamicComboBox(String info) {
        this.info = info;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + info + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof DynamicComboBox))
          return false;
        DynamicComboBox __4 = (DynamicComboBox) o;
        return eq(info, __4.info);
      }

      public int hashCode() {
        int h = -737505636;
        h = boostHashCombine(h, _hashCode(info));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { info };
      }

      public String url;
    }

    static public class CheckBox extends Renderer implements IFieldsToList {

      public CheckBox() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this);
      }

      public boolean equals(Object o) {
        return o instanceof CheckBox;
      }

      public int hashCode() {
        int h = 1601505219;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }

      {
        metaInfo = "Bool";
      }
    }

    static public class FlexibleLengthList extends Renderer implements IFieldsToList {

      public Renderer itemRenderer;

      public FlexibleLengthList() {
      }

      public FlexibleLengthList(Renderer itemRenderer) {
        this.itemRenderer = itemRenderer;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + itemRenderer + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof FlexibleLengthList))
          return false;
        FlexibleLengthList __5 = (FlexibleLengthList) o;
        return eq(itemRenderer, __5.itemRenderer);
      }

      public int hashCode() {
        int h = -1874811153;
        h = boostHashCombine(h, _hashCode(itemRenderer));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { itemRenderer };
      }
    }

    public String itemName() {
      return "object";
    }

    public String itemNamePlural() {
      return plural(itemName());
    }

    public List<Map<String, Object>> list() {
      return null;
    }

    public List<Map<String, Object>> list(IntRange range) {
      return subListOrFull(list(), range);
    }

    public String idField() {
      return "id";
    }

    public Map<String, Object> emptyObject() {
      return null;
    }

    public Map<String, Object> getObject(Object id) {
      return null;
    }

    public Map<String, Object> getObjectForEdit(Object id) {
      return getObject(id);
    }

    transient public IF1<Object, Map<String, Object>> getObjectForDuplication;

    public Map<String, Object> getObjectForDuplication(Object id) {
      return getObjectForDuplication != null ? getObjectForDuplication.get(id) : getObjectForDuplication_base(id);
    }

    final public Map<String, Object> getObjectForDuplication_fallback(IF1<Object, Map<String, Object>> _f, Object id) {
      return _f != null ? _f.get(id) : getObjectForDuplication_base(id);
    }

    public Map<String, Object> getObjectForDuplication_base(Object id) {
      return getObject(id);
    }

    public Object createObject(Map<String, String> fullMap, String fieldPrefix) {
      throw unimplemented();
    }

    public String deleteObject(Object id) {
      throw unimplemented();
    }

    public boolean objectCanBeDeleted(Object id) {
      return true;
    }

    transient public IF1<Object, Boolean> objectCanBeEdited;

    public boolean objectCanBeEdited(Object id) {
      return objectCanBeEdited != null ? objectCanBeEdited.get(id) : objectCanBeEdited_base(id);
    }

    final public boolean objectCanBeEdited_fallback(IF1<Object, Boolean> _f, Object id) {
      return _f != null ? _f.get(id) : objectCanBeEdited_base(id);
    }

    public boolean objectCanBeEdited_base(Object id) {
      return true;
    }

    public String updateObject(Object id, Map<String, String> fullMap, String fieldPrefix) {
      throw unimplemented();
    }

    public Renderer getRenderer(String field) {
      return renderers.get(field);
    }

    final public Renderer getRenderer(String field, Object value) {
      this.currentValue = value;
      try {
        return getRenderer(field);
      } finally {
        this.currentValue = null;
      }
    }

    public String fieldHelp(String field) {
      return fieldHelp.get(field);
    }

    public HCRUD_Data addRenderer(String field, Renderer renderer) {
      renderers.put(field, renderer);
      return this;
    }

    public HCRUD_Data fieldHelp(String field, String help, String... more) {
      fieldHelp.put(field, help);
      for (int i = 0; i + 1 < l(more); i += 2) fieldHelp.put(more[i], more[i + 1]);
      return this;
    }

    public String fieldNameToHTML(String name) {
      String help = fieldHelp.get(name);
      return spanTitle(help, htmlencode2(humanizeFieldNames ? humanizeLabel(name) : name));
    }

    public Set<String> filteredFields() {
      return null;
    }

    public List<String> comboBoxSearch(String info, String query) {
      return null;
    }

    public String titleForObjectID(Object id) {
      return null;
    }

    public Pair<String, Boolean> defaultSortField() {
      return null;
    }

    abstract public class Item extends AbstractMap<String, Object> {

      public Object id;

      public Map<String, Object> fullMap;

      public Item(Object id) {
        this.id = id;
      }

      abstract public Map<String, Object> calcFullMap();

      public Map<String, Object> fullMap() {
        if (fullMap == null)
          fullMap = calcFullMap();
        return fullMap;
      }

      public int size() {
        return l(fullMap());
      }

      public Set<Map.Entry<String, Object>> entrySet() {
        return fullMap().entrySet();
      }

      public boolean containsKey(Object o) {
        return fullMap().containsKey(o);
      }

      public Object get(Object o) {
        if (fullMap == null && eq(o, idField()))
          return id;
        return fullMap().get(o);
      }

      public Object put(String key, Object value) {
        return fullMap().put(key, value);
      }
    }
  }

  static public class ResolvableLASClass {

    public ResolvableLASClass() {
    }

    transient public ILASClassLoader lasClassLoader;

    public LASClassDef classDef;

    public Class resolvedClass;

    public ResolvableLASClass(ILASClassLoader lasClassLoader, LASClassDef classDef) {
      this.classDef = classDef;
      this.lasClassLoader = lasClassLoader;
    }

    public Class get() {
      if (resolvedClass == null) {
        if (lasClassLoader == null)
          throw fail("Need LASClassLoader to define " + classDef.userGivenName);
        resolvedClass = lasClassLoader.defineLASClass(classDef.finalClassName(), () -> classDef.toBytes());
        classDef.init(resolvedClass);
      }
      return resolvedClass;
    }

    public String toString() {
      if (resolvedClass != null)
        return className(resolvedClass);
      {
        var __1 = classDef.userGivenName;
        if (__1 != null)
          return __1;
      }
      if (classDef.classHash_cache != null)
        return classDef.finalClassNameWithoutPrefix();
      return or2(classDef.userGivenName, "script-defined class") + " [unresolved]";
    }
  }

  static public class MinimalChain<A> implements Iterable<A> {

    public A element;

    public MinimalChain<A> next;

    public MinimalChain() {
    }

    public MinimalChain(A element) {
      this.element = element;
    }

    public MinimalChain(A element, MinimalChain<A> next) {
      this.next = next;
      this.element = element;
    }

    public String toString() {
      return str(toList());
    }

    public ArrayList<A> toList() {
      ArrayList<A> l = new ArrayList();
      MinimalChain<A> c = this;
      while (c != null) {
        l.add(c.element);
        c = c.next;
      }
      return l;
    }

    public void setElement(A a) {
      element = a;
    }

    public void setNext(MinimalChain<A> next) {
      this.next = next;
    }

    public Iterator<A> iterator() {
      return toList().iterator();
    }

    public A get() {
      return element;
    }
  }

  static public interface ISetter<A> {

    public void set(A a);
  }

  static public interface IConceptCounter {

    public Class<? extends Concept> conceptClass();

    public int countConcepts();

    public Collection<Concept> allConcepts();
  }

  static public interface IAutoCloseableF0<A> extends IF0<A>, AutoCloseable {
  }

  abstract static public class HAbstractRenderable {

    public String baseLink = "";

    public MakeFrame makeFrame = (title, contents) -> h1_title(title) + contents;

    static public interface MakeFrame {

      public String makeFrame(String title, String contents);
    }

    public HAbstractRenderable() {
    }

    public HAbstractRenderable(String baseLink) {
      this.baseLink = baseLink;
    }

    public HAbstractRenderable makeFrame(MakeFrame makeFrame) {
      this.makeFrame = makeFrame;
      return this;
    }

    public String baseLinkPlus(String uri) {
      return nempty(uri) ? appendSlash(baseLink) + uri : baseLink;
    }

    public String frame(String title, String contents) {
      return makeFrame.makeFrame(title, contents);
    }

    public String refreshWithMsgs(String... msgs) {
      return refreshWithMsgs(asList(msgs));
    }

    public String refreshWithMsgs(List<String> msgs, Object... __) {
      String anchor = (String) (optPar("anchor", __));
      Map<String, String> params = (Map<String, String>) (optPar("params", __));
      return hrefresh(addAnchorToURL(appendQueryToURL(baseLink, mapPlus(params, "msg", htmlEncode_nlToBr(lines_rtrim(msgs)))), anchor));
    }

    public String renderMsgs(Map<String, String> params) {
      return pUnlessEmpty(params.get("msg"));
    }
  }

  static public class RemoteDB implements AutoCloseable {

    public DialogIO db;

    public String name;

    public RemoteDB(String s) {
      this(s, false);
    }

    public RemoteDB(String s, boolean autoStart) {
      name = s;
      if (isSnippetID(s))
        name = dbBotName(s);
      db = findBot(name);
      if (db == null)
        if (autoStart) {
          nohupJavax(fsI(s));
          waitForBotStartUp(name);
          assertNotNull("Weird problem", db = findBot(s));
        } else
          throw fail("DB " + s + " not running");
    }

    public boolean functional() {
      return db != null;
    }

    public List<RC> list() {
      return adopt((List<RC>) rpc(db, "xlist"));
    }

    public List<RC> list(String className) {
      return adopt((List<RC>) rpc(db, "xlist", className));
    }

    public List<RC> xlist() {
      return list();
    }

    public List<RC> xlist(String className) {
      return list(className);
    }

    public List<RC> adopt(List<RC> l) {
      if (l != null)
        for (RC rc : l) adopt(rc);
      return l;
    }

    public RC adopt(RC rc) {
      if (rc != null)
        rc.db = this;
      return rc;
    }

    public Object adopt(Object o) {
      if (o instanceof RC)
        return adopt((RC) o);
      return o;
    }

    public String xclass(RC o) {
      return (String) rpc(db, "xclass", o);
    }

    public Object xget(RC o, String field) {
      return adopt(rpc(db, "xget", o, field));
    }

    public String xS(RC o, String field) {
      return (String) xget(o, field);
    }

    public RC xgetref(RC o, String field) {
      return adopt((RC) xget(o, field));
    }

    public void xset(RC o, String field, Object value) {
      rpc(db, "xset", o, field, value);
    }

    public RC uniq(String className) {
      RC ref = first(list(className));
      if (ref == null)
        ref = xnew(className);
      return ref;
    }

    public RC xuniq(String className) {
      return uniq(className);
    }

    public RC xnew(String className, Object... values) {
      return adopt((RC) rpc(db, "xnew", className, values));
    }

    public void xdelete(RC o) {
      rpc(db, "xdelete", o);
    }

    public void xdelete(List<RC> l) {
      rpc(db, "xdelete", l);
    }

    public void close() {
      _close(db);
    }

    public String fullgrab() {
      return (String) rpc(db, "xfullgrab");
    }

    public String xfullgrab() {
      return fullgrab();
    }

    public void xshutdown() {
      rpc(db, "xshutdown");
    }

    public long xchangeCount() {
      return (long) rpc(db, "xchangeCount");
    }

    public int xcount() {
      return (int) rpc(db, "xcount");
    }

    public void reconnect() {
      close();
      db = findBot(name);
    }

    public RC rc(long id) {
      return new RC(this, id);
    }
  }

  public interface ChangeTriggerable {

    public void change();
  }

  static public class Not<A> implements IFieldsToList, Transformable, Visitable {

    public A a;

    public Not() {
    }

    public Not(A a) {
      this.a = a;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + a + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof Not))
        return false;
      Not __0 = (Not) o;
      return eq(a, __0.a);
    }

    public int hashCode() {
      int h = 78515;
      h = boostHashCombine(h, _hashCode(a));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { a };
    }

    public Object transformUsing(IF1 f) {
      return new Not((A) f.get(a));
    }

    public void visitUsing(IVF1 f) {
      f.get(a);
    }

    public Boolean get(Object o) {
      return not((Boolean) callF(a, o));
    }
  }

  abstract static public class VStackComputableWithStep<A> implements VStack.Computable<A> {

    public int step;

    public void step(VStack stack, Object subComputationResult) {
      step(stack);
    }

    public void step(VStack stack) {
    }
  }

  static public interface IFieldsToList {

    public Object[] _fieldsToList();
  }

  static public interface ISleeper_v2 {

    public Sleeping doLater(Timestamp targetTime, Runnable r);

    public default Sleeping doAfter(double seconds, Runnable r) {
      return doLater(tsNow().plusSeconds(seconds), r);
    }
  }

  static public class ForEach_vstack<A> extends VStackComputableWithStep implements IFieldsToList {

    public Iterable<A> l;

    public IVF1<A> body;

    public ForEach_vstack() {
    }

    public ForEach_vstack(Iterable<A> l, IVF1<A> body) {
      this.body = body;
      this.l = l;
    }

    public String toString() {
      return shortClassName_dropNumberPrefix(this) + "(" + l + ", " + body + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { l, body };
    }

    public Iterator<A> it;

    public void step(VStack stack) {
      if (step == 0) {
        if (l == null) {
          stack._return();
          return;
        }
        it = iterator(l);
        ++step;
      }
      if (!it.hasNext()) {
        stack._return();
        return;
      }
      body.get(it.next());
    }
  }

  public interface IHasTokenRangeWithSrc {

    public void setTokenRangeWithSrc(TokenRangeWithSrc src);

    public TokenRangeWithSrc tokenRangeWithSrc();

    default public String srcText() {
      var src = tokenRangeWithSrc();
      return src == null ? null : src.text();
    }
  }

  static public class Seconds implements Comparable<Seconds>, IFieldsToList {

    public double seconds;

    public Seconds() {
    }

    public Seconds(double seconds) {
      this.seconds = seconds;
    }

    public boolean equals(Object o) {
      if (!(o instanceof Seconds))
        return false;
      Seconds __1 = (Seconds) o;
      return seconds == __1.seconds;
    }

    public int hashCode() {
      int h = -660217249;
      h = boostHashCombine(h, _hashCode(seconds));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { seconds };
    }

    final public double get() {
      return seconds();
    }

    final public double getDouble() {
      return seconds();
    }

    public double seconds() {
      return seconds;
    }

    public String toString() {
      return formatDouble(seconds, 3) + " s";
    }

    public int compareTo(Seconds s) {
      return cmp(seconds, s.seconds);
    }

    public Seconds div(double x) {
      return new Seconds(get() / x);
    }

    public Seconds minus(Seconds x) {
      return new Seconds(get() - x.get());
    }
  }

  static public class GazelleV_LeftArrowScript {

    abstract static public class Base extends HasTokenRangeWithSrc {

      public RuntimeException rethrowWithSrc(Throwable e) {
        return rethrowWithSrc("", e);
      }

      public RuntimeException rethrowWithSrc(String msg, Throwable e) {
        if (src != null)
          throw rethrowAndAppendToMessage(e, squareBracketed(joinNemptiesWithComma(msg, src)));
        else
          throw rethrow(e);
      }
    }

    public interface Evaluable extends IF0, IHasTokenRangeWithSrc {

      public default Object get() {
        return get(new FlexibleVarContext());
      }

      public Object get(VarContext ctx);

      public default LASValueDescriptor returnType() {
        return null;
      }

      public default Evaluable optimize() {
        return this;
      }

      public default Evaluable optimizeForReturnValueNotNeeded() {
        return this;
      }
    }

    abstract static public class EvaluableBase extends Base implements Evaluable {

      final public EvaluableBase setReturnType(LASValueDescriptor returnType) {
        return returnType(returnType);
      }

      public EvaluableBase returnType(LASValueDescriptor returnType) {
        this.returnType = returnType;
        return this;
      }

      final public LASValueDescriptor getReturnType() {
        return returnType();
      }

      public LASValueDescriptor returnType() {
        return returnType;
      }

      public LASValueDescriptor returnType;

      public boolean returnValueNeeded = true;

      public Evaluable optimizeForReturnValueNotNeeded() {
        returnValueNeeded = false;
        return optimize();
      }
    }

    static public AtomicLong scriptIDCounter = new AtomicLong();

    static public long scriptID() {
      return incAtomicLong(scriptIDCounter);
    }

    static public class Script extends EvaluableBase {

      transient public long id = scriptID();

      public Map<String, FunctionDef> functionDefs;

      public Evaluable[] steps;

      final public Script setScope(LASScope scope) {
        return scope(scope);
      }

      public Script scope(LASScope scope) {
        this.scope = scope;
        return this;
      }

      final public LASScope getScope() {
        return scope();
      }

      public LASScope scope() {
        return scope;
      }

      public LASScope scope;

      public Object get(VarContext ctx) {
        Object result = null;
        var pingSource = pingSource();
        for (var step : steps) {
          ping(pingSource);
          result = step.get(ctx);
          var exiting = ctx.exitFromScript;
          if (exiting != null) {
            if (exiting == this) {
              ctx.exitFromScript = null;
              result = ctx.returnValue;
              ctx.returnValue(null);
              return result;
            }
            return null;
          }
        }
        return result;
      }

      public String toStringLong() {
        return pnlToLines(steps);
      }

      public String toString() {
        return "Script " + n2(id);
      }

      public FunctionDef getFunction(String name) {
        return mapGet(functionDefs, name);
      }

      final public Script optimize() {
        return optimizeScript();
      }

      public Script optimizeScript() {
        int n = returnValueNeeded ? steps.length - 1 : steps.length;
        for (int i = 0; i < n; i++) steps[i] = steps[i].optimizeForReturnValueNotNeeded();
        for (var f : values(functionDefs)) f.optimize();
        return this;
      }
    }

    static public class FunctionDef extends Base implements IFieldsToList {

      public String name;

      public String[] args;

      public Script body;

      public FunctionDef() {
      }

      public FunctionDef(String name, String[] args, Script body) {
        this.body = body;
        this.args = args;
        this.name = name;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + name + ", " + args + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { name, args, body };
      }

      final public FunctionDef setScope(LASScope scope) {
        return scope(scope);
      }

      public FunctionDef scope(LASScope scope) {
        this.scope = scope;
        return this;
      }

      final public LASScope getScope() {
        return scope();
      }

      public LASScope scope() {
        return scope;
      }

      public LASScope scope;

      public FunctionDef(String name, List<String> args, Script body) {
        this.args = toStringArray(args);
        this.body = body;
        this.name = name;
      }

      public Object call(VarContext ctx, Object... args) {
        VarContext ctx2 = scope != null && scope.useFixedVars ? new FixedVarContext(ctx, scope.names) : new FlexibleVarContext(ctx);
        int n = min(l(args), l(this.args));
        for (int i = 0; i < n; i++) ctx2.put(this.args[i], args[i]);
        return body.get(ctx2);
      }

      public void optimize() {
        body = body.optimize();
      }
    }

    static public class Assignment extends EvaluableBase implements IFieldsToList {

      public String var;

      public Evaluable expression;

      public Assignment() {
      }

      public Assignment(String var, Evaluable expression) {
        this.expression = expression;
        this.var = var;
      }

      public Object[] _fieldsToList() {
        return new Object[] { var, expression };
      }

      public Object get(VarContext ctx) {
        Object o = expression.get(ctx);
        ctx.set(var, o);
        return o;
      }

      public String toString() {
        return var + " <- " + expression;
      }
    }

    abstract static public class FixedVarBase extends EvaluableBase {

      final public FixedVarBase setScope(LASScope scope) {
        return scope(scope);
      }

      public FixedVarBase scope(LASScope scope) {
        this.scope = scope;
        return this;
      }

      final public LASScope getScope() {
        return scope();
      }

      public LASScope scope() {
        return scope;
      }

      public LASScope scope;

      public String var;

      public int varIdx;

      public String varToStr() {
        return var + " [" + varIdx + "]";
      }

      public void assertResolved() {
        if (varIdx < 0)
          throw fail("Unresolved variable access: " + var);
      }

      public void resolve() {
        varIdx = scope.resolveVar(var);
      }
    }

    static public class FixedVarAssignment extends FixedVarBase {

      public FixedVarAssignment() {
      }

      public Evaluable expression;

      public FixedVarAssignment(LASScope scope, String var, Evaluable expression) {
        this.expression = expression;
        this.var = var;
        this.scope = scope;
      }

      public Object get(VarContext ctx) {
        Object o = expression.get(ctx);
        ((FixedVarContext) ctx).set(varIdx, o);
        return o;
      }

      public String toString() {
        return varToStr() + " <- " + expression;
      }
    }

    static public class VarDeclaration extends EvaluableBase implements IFieldsToList {

      public String var;

      public Class type;

      public Evaluable expression;

      public VarDeclaration() {
      }

      public VarDeclaration(String var, Class type, Evaluable expression) {
        this.expression = expression;
        this.type = type;
        this.var = var;
      }

      public Object[] _fieldsToList() {
        return new Object[] { var, type, expression };
      }

      public Object get(VarContext ctx) {
        Object o = expression == null ? null : expression.get(ctx);
        ctx.set(var, o);
        return o;
      }

      public String toString() {
        return "var " + var + " <- " + expression;
      }
    }

    static public class AssignmentToOuterVar extends EvaluableBase implements IFieldsToList {

      public String var;

      public Evaluable expression;

      public AssignmentToOuterVar() {
      }

      public AssignmentToOuterVar(String var, Evaluable expression) {
        this.expression = expression;
        this.var = var;
      }

      public Object[] _fieldsToList() {
        return new Object[] { var, expression };
      }

      public Object get(VarContext ctx) {
        var parent = ctx.parent();
        assertNotNull("No outer variable context", parent);
        Object o = expression.get(ctx);
        parent.set(var, o);
        return o;
      }

      public String toString() {
        return "outer " + var + " <- " + expression;
      }
    }

    static public class NewObject extends EvaluableBase {

      public NewObject() {
      }

      public Class c;

      public Evaluable[] args;

      public NewObject(Class c) {
        this.c = c;
      }

      public NewObject(Class c, Evaluable[] args) {
        this.args = args;
        this.c = c;
      }

      public Object get(VarContext ctx) {
        try {
          return preciseNuObject(c, mapToArrayOrNull(args, arg -> arg.get(ctx)));
        } catch (Throwable e) {
          throw rethrowWithSrc(e);
        }
      }

      public String toString() {
        return "new " + formatFunctionCall(className(c), args);
      }
    }

    static public class NewObject_LASClass extends NewObject {

      public NewObject_LASClass() {
      }

      public ResolvableLASClass lasClass;

      public NewObject_LASClass(ResolvableLASClass lasClass) {
        this.lasClass = lasClass;
      }

      public NewObject_LASClass(ResolvableLASClass lasClass, Evaluable[] args) {
        this.args = args;
        this.lasClass = lasClass;
      }

      public void resolve() {
        if (c == null)
          c = lasClass.get();
      }

      public Object get(VarContext ctx) {
        resolve();
        return super.get(ctx);
      }

      public String toString() {
        return "new " + formatFunctionCall(str(lasClass), args);
      }
    }

    static public class NewObject_UnknownClass extends NewObject implements IFieldsToList {

      public Evaluable classExpr;

      public Evaluable[] args;

      public NewObject_UnknownClass() {
      }

      public NewObject_UnknownClass(Evaluable classExpr, Evaluable[] args) {
        this.args = args;
        this.classExpr = classExpr;
      }

      public Object[] _fieldsToList() {
        return new Object[] { classExpr, args };
      }

      public Object get(VarContext ctx) {
        try {
          Class c = (Class) (classExpr.get(ctx));
          return preciseNuObject(c, mapToArrayOrNull(args, arg -> arg.get(ctx)));
        } catch (Throwable e) {
          throw rethrowWithSrc(e);
        }
      }

      public String toString() {
        return "new " + formatFunctionCall(classExpr, args);
      }
    }

    static public class CallFunction extends EvaluableBase implements IFieldsToList {

      public FunctionDef f;

      public Evaluable[] args;

      public CallFunction() {
      }

      public CallFunction(FunctionDef f, Evaluable[] args) {
        this.args = args;
        this.f = f;
      }

      public Object[] _fieldsToList() {
        return new Object[] { f, args };
      }

      public Object get(VarContext ctx) {
        var evaledArgs = mapToArrayOrNull(args, a -> a.get(ctx));
        if (ctx.exiting())
          return null;
        return f.call(ctx, evaledArgs);
      }

      public String toString() {
        return formatFunctionCall(f.name, args);
      }
    }

    static public class GetVar extends EvaluableBase implements IFieldsToList {

      public String var;

      public GetVar() {
      }

      public GetVar(String var) {
        this.var = var;
      }

      public Object[] _fieldsToList() {
        return new Object[] { var };
      }

      public Object get(VarContext ctx) {
        return ctx.get(var);
      }

      public String toString() {
        return var;
      }
    }

    static public class GetFixedVar extends FixedVarBase {

      public GetFixedVar() {
      }

      public GetFixedVar(LASScope scope, String var) {
        this.var = var;
        this.scope = scope;
      }

      public Object get(VarContext ctx) {
        assertResolved();
        try {
          return ((FixedVarContext) ctx).get(varIdx);
        } catch (ArrayIndexOutOfBoundsException e) {
          assertResolved();
          throw e;
        }
      }

      public String toString() {
        return var + " [" + varIdx + "]";
      }
    }

    static public class Const extends EvaluableBase implements IFieldsToList {

      public Object value;

      public Const() {
      }

      public Const(Object value) {
        this.value = value;
      }

      public Object[] _fieldsToList() {
        return new Object[] { value };
      }

      public Object get(VarContext ctx) {
        return value;
      }

      public String toString() {
        return strOrClassName(value);
      }

      public LASValueDescriptor returnType() {
        return new LASValueDescriptor.KnownValue(value);
      }

      public Object _serialize() {
        boolean ok = isUnproblematicValue(value);
        return ok ? this : toStringWithClass(value);
      }
    }

    static public class GetStaticField extends EvaluableBase implements IFieldsToList {

      public Field field;

      public GetStaticField() {
      }

      public GetStaticField(Field field) {
        this.field = field;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + field + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { field };
      }

      public Object get(VarContext ctx) {
        try {
          return field.get(null);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String _serialize() {
        return str(field);
      }
    }

    static public class CallMethodOrGetField extends EvaluableBase implements IFieldsToList {

      public Evaluable target;

      public String name;

      public CallMethodOrGetField() {
      }

      public CallMethodOrGetField(Evaluable target, String name) {
        this.name = name;
        this.target = target;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + target + ", " + name + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { target, name };
      }

      final public CallMethodOrGetField setAllowNullReference(boolean allowNullReference) {
        return allowNullReference(allowNullReference);
      }

      public CallMethodOrGetField allowNullReference(boolean allowNullReference) {
        this.allowNullReference = allowNullReference;
        return this;
      }

      final public boolean getAllowNullReference() {
        return allowNullReference();
      }

      public boolean allowNullReference() {
        return allowNullReference;
      }

      public boolean allowNullReference = false;

      public Object handleNullReference() {
        if (allowNullReference)
          return null;
        else
          throw new NullPointerException();
      }

      public Object get(VarContext ctx) {
        try {
          Object object = target.get(ctx);
          if (object == null)
            return handleNullReference();
          return preciseGetOrCallMethod(object, name);
        } catch (Throwable e) {
          throw rethrowWithSrc("Was getting " + name, e);
        }
      }
    }

    static public class GetVarContext extends EvaluableBase {

      public Object get(VarContext ctx) {
        return ctx;
      }
    }

    static public class ThrowMethodNotFoundException extends EvaluableBase implements IFieldsToList {

      public CallMethod instruction;

      public ThrowMethodNotFoundException() {
      }

      public ThrowMethodNotFoundException(CallMethod instruction) {
        this.instruction = instruction;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + instruction + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { instruction };
      }

      public Object get(VarContext ctx) {
        throw fail("Method not found: " + instruction);
      }
    }

    static public class ThrowNullPointerException extends EvaluableBase implements IFieldsToList {

      public CallMethod instruction;

      public ThrowNullPointerException() {
      }

      public ThrowNullPointerException(CallMethod instruction) {
        this.instruction = instruction;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + instruction + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { instruction };
      }

      public Object get(VarContext ctx) {
        throw fail("Null pointer exception: " + instruction);
      }
    }

    static public class CallMethod extends EvaluableBase implements IFieldsToList {

      public Evaluable target;

      public String methodName;

      public Evaluable[] args;

      public CallMethod() {
      }

      public CallMethod(Evaluable target, String methodName, Evaluable[] args) {
        this.args = args;
        this.methodName = methodName;
        this.target = target;
      }

      public Object[] _fieldsToList() {
        return new Object[] { target, methodName, args };
      }

      public Object get(VarContext ctx) {
        return newPreciseCall(target.get(ctx), methodName, mapToArrayOrNull(args, arg -> arg.get(ctx)));
      }

      public String toString() {
        return target + "." + formatFunctionCall(methodName, args);
      }

      public Evaluable optimize() {
        var targetType = target.returnType();
        if (targetType != null && targetType.knownValue()) {
          Object o = targetType.value();
          if (o == null)
            return new ThrowNullPointerException(this);
          Class[] argTypes = new Class[l(args)];
          for (int i = 0; i < l(args); i++) {
            var type = args[i].returnType();
            if (type == null || !type.javaClassIsExact())
              return this;
            argTypes[i] = type.javaClass();
          }
          List<Method> methods = findMethodsNamed_cached(o, methodName);
          if (any(methods, m -> m.isVarArgs()))
            return this;
          var __4 = findMethod_withPrimitiveWidening_onTypes(o, methodName, argTypes);
          var method = __4.a;
          var widening = __4.b;
          if (method == null)
            return new ThrowMethodNotFoundException(this);
          return new DirectMethodCallOnKnownTarget(widening, o instanceof Class ? null : o, method, args);
        }
        return this;
      }
    }

    static public class LambdaDef extends EvaluableBase implements IFieldsToList {

      public Class intrface;

      public String[] args;

      public Evaluable body;

      public LambdaDef() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + intrface + ", " + args + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { intrface, args, body };
      }

      public Method implementedMethod;

      public LambdaDef(Class intrface, String[] args, Evaluable body) {
        this.body = body;
        this.args = args;
        this.intrface = intrface;
        implementedMethod = findSingleInterfaceMethodOrFail(intrface);
        if (implementedMethod.getParameterCount() != l(args))
          throw fail("Bad parameter count for lambda: " + implementedMethod + " vs: " + joinWithComma(args));
      }

      public Object get(VarContext ctx) {
        return proxyFromInvocationHandler(intrface, (proxy, method, actualArgs) -> {
          ping();
          if (method.getDeclaringClass() == intrface) {
            var ctx2 = new FlexibleVarContext(ctx);
            var argNames = args;
            for (int i = 0; i < l(args); i++) ctx2.put(argNames[i], actualArgs[i]);
            return body.get(ctx2);
          } else
            return handleObjectMethodsInProxyInvocationHandler(this, implementedMethod, method, proxy, actualArgs);
        });
      }
    }

    abstract static public class CurriedLambdaBase extends EvaluableBase implements IFieldsToList {

      public Class intrface;

      public Evaluable[] curriedArgs;

      public CurriedLambdaBase() {
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + intrface + ", " + curriedArgs + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { intrface, curriedArgs };
      }

      public Method implementedMethod;

      public CurriedLambdaBase(Class intrface, Evaluable[] curriedArgs) {
        this.curriedArgs = curriedArgs;
        this.intrface = intrface;
        implementedMethod = findSingleInterfaceMethodOrFail(intrface);
      }

      public Object get(VarContext ctx) {
        Object[] curriedArguments = mapToArrayOrNull(curriedArgs, arg -> arg.get(ctx));
        return proxyFromInvocationHandler(intrface, (proxy, method, actualArgs) -> {
          if (method.getDeclaringClass() == intrface)
            return forwardCall(ctx, concatMethodArgs(curriedArguments, actualArgs));
          else
            return handleObjectMethodsInProxyInvocationHandler(this, implementedMethod, method, proxy, actualArgs);
        });
      }

      abstract public Object forwardCall(VarContext ctx, Object[] args);
    }

    static public class CurriedMethodLambda extends CurriedLambdaBase {

      public Object target;

      public String targetMethod;

      public CurriedMethodLambda(Class intrface, Object target, String targetMethod, Evaluable[] curriedArgs) {
        super(intrface, curriedArgs);
        this.targetMethod = targetMethod;
        this.target = target;
      }

      public Object forwardCall(VarContext ctx, Object[] args) {
        return call(target, targetMethod, args);
      }
    }

    static public class CurriedScriptFunctionLambda extends CurriedLambdaBase {

      public FunctionDef f;

      public CurriedScriptFunctionLambda(Class intrface, FunctionDef f, Evaluable[] curriedArgs) {
        super(intrface, curriedArgs);
        this.f = f;
      }

      public Object forwardCall(VarContext ctx, Object[] args) {
        return f.call(ctx, args);
      }
    }

    static public class CurriedConstructorLambda extends CurriedLambdaBase {

      public Constructor[] ctors;

      public CurriedConstructorLambda(Class intrface, Constructor[] ctors, Evaluable[] curriedArgs) {
        super(intrface, curriedArgs);
        this.ctors = ctors;
      }

      public Object forwardCall(VarContext ctx, Object[] args) {
        return preciseNuObject(ctors, args);
      }
    }

    static public class DirectMethodCallOnKnownTarget extends EvaluableBase implements IFieldsToList {

      public boolean widening = false;

      public Object target;

      public Method method;

      public Evaluable[] args;

      public DirectMethodCallOnKnownTarget() {
      }

      public DirectMethodCallOnKnownTarget(boolean widening, Object target, Method method, Evaluable[] args) {
        this.args = args;
        this.method = method;
        this.target = target;
        this.widening = widening;
      }

      public Object[] _fieldsToList() {
        return new Object[] { widening, target, method, args };
      }

      public Object get(VarContext ctx) {
        var evaluatedArgs = mapToArrayOrNull(args, arg -> arg.get(ctx));
        return widening ? invokeMethodWithWidening(method, target, evaluatedArgs) : invokeMethod(method, target, evaluatedArgs);
      }

      public String toString() {
        return (target == null ? "" : target + ".") + formatFunctionCall(str(method), args);
      }

      public LASValueDescriptor returnType() {
        return LASValueDescriptor.fromClass(method.getReturnType());
      }
    }

    static public class While extends EvaluableBase implements IFieldsToList {

      public Evaluable condition;

      public Evaluable body;

      public While() {
      }

      public While(Evaluable condition, Evaluable body) {
        this.body = body;
        this.condition = condition;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + condition + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { condition, body };
      }

      public Object get(VarContext ctx) {
        while (!ctx.exiting() && (Boolean) condition.get(ctx)) {
          body.get(ctx);
        }
        return null;
      }
    }

    abstract static public class ForEachBase extends EvaluableBase implements IFieldsToList {

      public Evaluable collection;

      public Evaluable body;

      public ForEachBase() {
      }

      public ForEachBase(Evaluable collection, Evaluable body) {
        this.body = body;
        this.collection = collection;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + collection + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { collection, body };
      }

      public Object get(VarContext ctx) {
        var coll = collection.get(ctx);
        Iterator iterator;
        List out;
        try {
          if (coll instanceof Object[]) {
            out = emptyList(((Object[]) coll).length);
            for (var element : ((Object[]) coll)) {
              if (ctx.exiting())
                return null;
              processElement(ctx, out, element);
            }
          } else if (coll instanceof Iterable) {
            out = emptyList((Iterable) coll);
            for (var element : ((Iterable) coll)) {
              if (ctx.exiting())
                return null;
              processElement(ctx, out, element);
            }
          } else if (coll == null)
            out = new ArrayList();
          else
            throw fail("Not iterable: " + className(coll));
        } finally {
          loopDone(ctx);
        }
        return out;
      }

      abstract public void processElement(VarContext ctx, List out, Object o);

      abstract public void loopDone(VarContext ctx);
    }

    static public class ForEach extends ForEachBase {

      public ForEach() {
      }

      public String var;

      public ForEach(Evaluable collection, String var, Evaluable body) {
        this.body = body;
        this.var = var;
        this.collection = collection;
      }

      public void processElement(VarContext ctx, List out, Object o) {
        ctx.set(var, o);
        out.add(body.get(ctx));
      }

      public void loopDone(VarContext ctx) {
        ctx.unset(var);
      }
    }

    static public class ForIterator extends EvaluableBase implements IFieldsToList {

      static final public String _fieldOrder = "iterable var body";

      public Evaluable iterable;

      public String var;

      public Evaluable body;

      public ForIterator() {
      }

      public ForIterator(Evaluable iterable, String var, Evaluable body) {
        this.body = body;
        this.var = var;
        this.iterable = iterable;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + iterable + ", " + var + ", " + body + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ForIterator))
          return false;
        ForIterator __5 = (ForIterator) o;
        return eq(iterable, __5.iterable) && eq(var, __5.var) && eq(body, __5.body);
      }

      public int hashCode() {
        int h = -214906825;
        h = boostHashCombine(h, _hashCode(iterable));
        h = boostHashCombine(h, _hashCode(var));
        h = boostHashCombine(h, _hashCode(body));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { iterable, var, body };
      }

      public Object get(VarContext ctx) {
        VarContext subContext = new FlexibleVarContext(ctx);
        var iterable = this.iterable.get(ctx);
        Iterator iterator = iterator_gen(iterable);
        return mapI(iterator, value -> {
          subContext.set(var, value);
          return body.get(subContext);
        });
      }
    }

    static public class ForNested extends EvaluableBase implements IFieldsToList {

      static final public String _fieldOrder = "iterable var body";

      public Evaluable iterable;

      public String var;

      public Evaluable body;

      public ForNested() {
      }

      public ForNested(Evaluable iterable, String var, Evaluable body) {
        this.body = body;
        this.var = var;
        this.iterable = iterable;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + iterable + ", " + var + ", " + body + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ForNested))
          return false;
        ForNested __6 = (ForNested) o;
        return eq(iterable, __6.iterable) && eq(var, __6.var) && eq(body, __6.body);
      }

      public int hashCode() {
        int h = -1363247360;
        h = boostHashCombine(h, _hashCode(iterable));
        h = boostHashCombine(h, _hashCode(var));
        h = boostHashCombine(h, _hashCode(body));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { iterable, var, body };
      }

      public Object get(VarContext ctx) {
        VarContext subContext = new FlexibleVarContext(ctx);
        var iterable = this.iterable.get(ctx);
        Iterator iterator = iterator_gen(iterable);
        return nestedIterator(iterator, value -> {
          subContext.set(var, value);
          return iterator_gen(body.get(subContext));
        });
      }
    }

    static public class ForPairs extends ForEachBase {

      public ForPairs() {
      }

      public String varA, varB;

      public ForPairs(Evaluable collection, Evaluable body, String varA, String varB) {
        this.varB = varB;
        this.varA = varA;
        this.body = body;
        this.collection = collection;
      }

      public void processElement(VarContext ctx, List out, Object o) {
        Pair p = (Pair) o;
        ctx.set(varA, p.a);
        ctx.set(varB, p.b);
        out.add(body.get(ctx));
      }

      public void loopDone(VarContext ctx) {
        ctx.unset(varA);
        ctx.unset(varB);
      }
    }

    static public class ForKeyValue extends EvaluableBase implements IFieldsToList {

      public Evaluable map;

      public Evaluable body;

      public String varA;

      public String varB;

      public ForKeyValue() {
      }

      public ForKeyValue(Evaluable map, Evaluable body, String varA, String varB) {
        this.varB = varB;
        this.varA = varA;
        this.body = body;
        this.map = map;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + map + ", " + body + ", " + varA + ", " + varB + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { map, body, varA, varB };
      }

      public Object get(VarContext ctx) {
        Map<?, ?> theMap = (Map) map.get(ctx);
        List out;
        try {
          if (theMap != null) {
            out = emptyList(theMap.size());
            for (var entry : theMap.entrySet()) {
              if (ctx.exiting())
                return null;
              ctx.set(varA, entry.getKey());
              ctx.set(varB, entry.getValue());
              out.add(body.get(ctx));
            }
          } else
            out = new ArrayList();
        } finally {
          ctx.unset(varA);
          ctx.unset(varB);
        }
        return out;
      }
    }

    static public class ForIntTo extends EvaluableBase implements IFieldsToList {

      public Evaluable endValue;

      public String var;

      public Evaluable body;

      public ForIntTo() {
      }

      public ForIntTo(Evaluable endValue, String var, Evaluable body) {
        this.body = body;
        this.var = var;
        this.endValue = endValue;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + endValue + ", " + var + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { endValue, var, body };
      }

      public Evaluable optimize() {
        if (!returnValueNeeded)
          body = body.optimizeForReturnValueNotNeeded();
        return this;
      }

      public Object get(VarContext ctx) {
        int n = (Integer) endValue.get(ctx), i = 0;
        List out = returnValueNeeded ? new ArrayList() : null;
        try {
          ctx.put(var, i);
          while (i < n) {
            if (ctx.exiting())
              return null;
            Object o = body.get(ctx);
            {
              if (out != null)
                out.add(o);
            }
            ctx.set(var, i = (Integer) ctx.get(var) + 1);
          }
        } finally {
          ctx.unset(var);
        }
        return out;
      }
    }

    static public class ForIndex extends EvaluableBase {

      public ForIndex() {
      }

      public Evaluable collection, body;

      public String varIndex, varElement;

      public ForIndex(Evaluable collection, Evaluable body, String varIndex, String varElement) {
        this.varElement = varElement;
        this.varIndex = varIndex;
        this.body = body;
        this.collection = collection;
      }

      public Object get(VarContext ctx) {
        return new ForIndex_instance(collection, body, varIndex, varElement).get(ctx);
      }
    }

    static public class ForIndex_instance extends ForEachBase {

      public String varIndex, varElement;

      public int index;

      public ForIndex_instance(Evaluable collection, Evaluable body, String varIndex, String varElement) {
        this.varElement = varElement;
        this.varIndex = varIndex;
        this.body = body;
        this.collection = collection;
      }

      public void processElement(VarContext ctx, List out, Object o) {
        ctx.set(varIndex, index++);
        ctx.set(varElement, o);
        out.add(body.get(ctx));
      }

      public void loopDone(VarContext ctx) {
        ctx.unset(varIndex);
        ctx.unset(varElement);
      }
    }

    static public class IfThen extends EvaluableBase implements IFieldsToList {

      public Evaluable condition;

      public Evaluable body;

      public Evaluable elseBranch;

      public IfThen() {
      }

      public IfThen(Evaluable condition, Evaluable body, Evaluable elseBranch) {
        this.elseBranch = elseBranch;
        this.body = body;
        this.condition = condition;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + condition + ", " + body + ", " + elseBranch + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { condition, body, elseBranch };
      }

      public IfThen(Evaluable condition, Evaluable body) {
        this.condition = condition;
        this.body = body;
      }

      public Object get(VarContext ctx) {
        if ((Boolean) condition.get(ctx))
          return body.get(ctx);
        else if (elseBranch != null)
          return elseBranch.get(ctx);
        else
          return null;
      }
    }

    static public class ReturnFromScript extends EvaluableBase implements IFieldsToList {

      public Script script;

      public Evaluable value;

      public ReturnFromScript() {
      }

      public ReturnFromScript(Script script, Evaluable value) {
        this.value = value;
        this.script = script;
      }

      public Object[] _fieldsToList() {
        return new Object[] { script, value };
      }

      public Object get(VarContext ctx) {
        Object result = value.get(ctx);
        ctx.exitFromScript(script);
        ctx.returnValue(result);
        return null;
      }

      public String toString() {
        return formatFunctionCall("ReturnFromScript", script, value);
      }
    }

    static public class Continue extends EvaluableBase implements IFieldsToList {

      public Script loopBody;

      public Continue() {
      }

      public Continue(Script loopBody) {
        this.loopBody = loopBody;
      }

      public Object[] _fieldsToList() {
        return new Object[] { loopBody };
      }

      public Object get(VarContext ctx) {
        ctx.exitFromScript(loopBody);
        ctx.returnValue(null);
        return null;
      }

      public String toString() {
        return formatFunctionCall("Continue", loopBody);
      }
    }

    static public class RepeatN extends EvaluableBase implements IFieldsToList {

      public Evaluable n;

      public Evaluable body;

      public RepeatN() {
      }

      public RepeatN(Evaluable n, Evaluable body) {
        this.body = body;
        this.n = n;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + n + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { n, body };
      }

      public Object get(VarContext ctx) {
        long count = ((Number) n.get(ctx)).longValue();
        for (int _repeat_0 = 0; _repeat_0 < count; _repeat_0++) {
          if (ctx.exiting())
            return null;
          body.get(ctx);
        }
        return null;
      }
    }

    static public class BoolAnd extends EvaluableBase implements IFieldsToList {

      public Evaluable a;

      public Evaluable b;

      public BoolAnd() {
      }

      public BoolAnd(Evaluable a, Evaluable b) {
        this.b = b;
        this.a = a;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + a + ", " + b + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof BoolAnd))
          return false;
        BoolAnd __7 = (BoolAnd) o;
        return eq(a, __7.a) && eq(b, __7.b);
      }

      public int hashCode() {
        int h = 1729330797;
        h = boostHashCombine(h, _hashCode(a));
        h = boostHashCombine(h, _hashCode(b));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { a, b };
      }

      public Object get(VarContext ctx) {
        if (!((Boolean) a.get(ctx)))
          return false;
        return b.get(ctx);
      }
    }

    static public class BoolOr extends EvaluableBase implements IFieldsToList {

      public Evaluable a;

      public Evaluable b;

      public BoolOr() {
      }

      public BoolOr(Evaluable a, Evaluable b) {
        this.b = b;
        this.a = a;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + a + ", " + b + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof BoolOr))
          return false;
        BoolOr __8 = (BoolOr) o;
        return eq(a, __8.a) && eq(b, __8.b);
      }

      public int hashCode() {
        int h = 1995447949;
        h = boostHashCombine(h, _hashCode(a));
        h = boostHashCombine(h, _hashCode(b));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { a, b };
      }

      public Object get(VarContext ctx) {
        if (((Boolean) a.get(ctx)))
          return true;
        return b.get(ctx);
      }
    }

    static public class TempBlock extends EvaluableBase implements IFieldsToList {

      public Evaluable tempExpr;

      public Evaluable body;

      public TempBlock() {
      }

      public TempBlock(Evaluable tempExpr, Evaluable body) {
        this.body = body;
        this.tempExpr = tempExpr;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + tempExpr + ", " + body + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { tempExpr, body };
      }

      public Object get(VarContext ctx) {
        AutoCloseable __2 = (AutoCloseable) (tempExpr.get(ctx));
        try {
          return body.get(ctx);
        } finally {
          _close(__2);
        }
      }
    }

    static public class ClassDef extends EvaluableBase implements IFieldsToList {

      public ResolvableLASClass lasClass;

      public ClassDef() {
      }

      public ClassDef(ResolvableLASClass lasClass) {
        this.lasClass = lasClass;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + lasClass + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ClassDef))
          return false;
        ClassDef __9 = (ClassDef) o;
        return eq(lasClass, __9.lasClass);
      }

      public int hashCode() {
        int h = 757052301;
        h = boostHashCombine(h, _hashCode(lasClass));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { lasClass };
      }

      public Object get(VarContext ctx) {
        return lasClass.get();
      }
    }

    static public class SetField extends EvaluableBase implements IFieldsToList {

      public Evaluable target;

      public String name;

      public Evaluable expr;

      public SetField() {
      }

      public SetField(Evaluable target, String name, Evaluable expr) {
        this.expr = expr;
        this.name = name;
        this.target = target;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + target + ", " + name + ", " + expr + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { target, name, expr };
      }

      final public SetField setAllowNullReference(boolean allowNullReference) {
        return allowNullReference(allowNullReference);
      }

      public SetField allowNullReference(boolean allowNullReference) {
        this.allowNullReference = allowNullReference;
        return this;
      }

      final public boolean getAllowNullReference() {
        return allowNullReference();
      }

      public boolean allowNullReference() {
        return allowNullReference;
      }

      public boolean allowNullReference = false;

      public Object handleNullReference() {
        if (allowNullReference)
          return null;
        else
          throw new NullPointerException();
      }

      public Object get(VarContext ctx) {
        try {
          Object value = expr.get(ctx);
          Object object = target.get(ctx);
          if (object == null)
            handleNullReference();
          else
            set(object, name, value);
          return value;
        } catch (Throwable e) {
          throw rethrowWithSrc(e);
        }
      }
    }

    static public class Throw extends EvaluableBase implements IFieldsToList {

      public Evaluable expr;

      public Throw() {
      }

      public Throw(Evaluable expr) {
        this.expr = expr;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + expr + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { expr };
      }

      public Object get(VarContext ctx) {
        throw asRuntimeException((Throwable) expr.get(ctx));
      }
    }

    static public class TryCatch extends EvaluableBase implements IFieldsToList {

      public Evaluable body;

      public String var;

      public Evaluable catchBlock;

      public TryCatch() {
      }

      public TryCatch(Evaluable body, String var, Evaluable catchBlock) {
        this.catchBlock = catchBlock;
        this.var = var;
        this.body = body;
      }

      public String toString() {
        return shortClassName_dropNumberPrefix(this) + "(" + body + ", " + var + ", " + catchBlock + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { body, var, catchBlock };
      }

      public Object get(VarContext ctx) {
        try {
          return body.get(ctx);
        } catch (Throwable e) {
          AutoCloseable __3 = ctx.tempPut(var, e);
          try {
            return catchBlock.get(ctx);
          } finally {
            _close(__3);
          }
        }
      }
    }

    static public structure_Data structureDataForLAS() {
      structure_Data d = new structure_Data();
      d.skipDefaultValues(true);
      d.shouldIncludeField = field -> {
        String c = shortClassName(field.getDeclaringClass());
        String f = field.getName();
        boolean shouldInclude = !(eq(c, "HasTokenRangeWithSrc") && eq(f, "src"));
        return shouldInclude;
      };
      return d;
    }

    static public boolean isUnproblematicValue(Object o) {
      return o == null || o instanceof Number || o instanceof String || o instanceof Boolean || o instanceof Class;
    }

    static public String scriptStruct(Object o) {
      String s = struct(o, structureDataForLAS());
      List<String> tok = structTok(s);
      String prefix = shortName(GazelleV_LeftArrowScript.class) + "$";
      for (int i = 1; i < l(tok); i += 2) tok.set(i, replacePrefix(prefix, "$", tok.get(i)));
      return join(tok);
    }

    static public String indentedScriptStruct(Object o) {
      return indentStructureString(scriptStruct(o));
    }
  }

  static public interface IVF2<A, B> {

    public void get(A a, B b);
  }

  public interface IDoublePt {

    public double x_double();

    public double y_double();
  }

  static public interface IVar<A> extends IF0<A> {

    public void set(A a);

    public A get();

    default public Class<A> getType() {
      return null;
    }

    default public boolean has() {
      return get() != null;
    }

    default public void clear() {
      set(null);
    }
  }

  static public interface WidthAndHeight {

    default public int w() {
      return getWidth();
    }

    public int getWidth();

    default public int h() {
      return getHeight();
    }

    public int getHeight();

    public default Rect bounds() {
      return rect(0, 0, getWidth(), getHeight());
    }

    default public int area() {
      return toInt(areaAsLong());
    }

    default public long areaAsLong() {
      return longMul(w(), h());
    }
  }

  static public class SynchronizedNavigableSet<E> extends SynchronizedSortedSet<E> implements NavigableSet<E> {

    public SynchronizedNavigableSet() {
    }

    @java.io.Serial
    static final public long serialVersionUID = -5505529816273629798L;

    @SuppressWarnings("serial")
    public NavigableSet<E> ns;

    public SynchronizedNavigableSet(NavigableSet<E> s) {
      super(s);
      ns = s;
    }

    public SynchronizedNavigableSet(NavigableSet<E> s, Object mutex) {
      super(s, mutex);
      ns = s;
    }

    public E lower(E e) {
      synchronized (mutex) {
        return ns.lower(e);
      }
    }

    public E floor(E e) {
      synchronized (mutex) {
        return ns.floor(e);
      }
    }

    public E ceiling(E e) {
      synchronized (mutex) {
        return ns