import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;


import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.*;
import java.util.TimeZone;
import org.eclipse.collections.impl.map.mutable.primitive.*;
import org.eclipse.collections.impl.set.mutable.primitive.*;
import org.eclipse.collections.api.tuple.primitive.*;
import org.eclipse.collections.api.iterator.*;

class main {

public static void main(final String[] args) throws Exception {
  noRegularGC();
  try {
    go(asList(args));
  } catch (Throwable e) {
    //print(exceptionToStringShort(e));
    printStackTrace(e);
  }
}

static void go(List<String> args) {
  boolean verbose = false;
  //print(+args); // javax still swallowing -v!?
  String cmd = popFirst(args);
  boolean byteMode = contains(cmd, "b");
  cmd = replace(cmd, "b", "");
  boolean toUpper = contains(cmd, "u");
  cmd = replace(cmd, "u", "");
  boolean balancing = contains(cmd, "B");
  cmd = replace(cmd, "B", "");
  
  if (eqOneOf(first(args), "-v", "-verbose", "-V")) {
    args = dropFirst(args);
    verbose = true;
  }
  
  String archiveName = first(args);
  if (eqic(cmd, "x")) {
    print("Extracting");
    if (empty(archiveName)) throw fail("Need archive name as second argument");
    
    File f = newFile(archiveName);
    if (!fileExists(f)) throw fail("File not found: " + f.getAbsolutePath());
    
    // TODO: byteMode
    LineCompReader lcr = new LineCompReader(f);
    
    List<String> filesToExtract = dropFirst(args);
    if (empty(filesToExtract)) {
      for (String version : lcr.versions())
        extractVersion(lcr, version);
    } else {
      for (String name : filesToExtract)
        if (!lcr.versions().contains(name))
          print("Warning: File " + name + " not found in archive");
        else
          extractVersion(lcr, name);
    }
  } else if (eqic(cmd, "c")) {
    //print("Creating");
    if (empty(archiveName)) throw fail("Need archive name as second argument");
    List<String> filesToAdd = dropFirst(args);
    if (empty(filesToAdd)) throw fail("Please specify files to add to archive");
    
    LinkedHashMap<String, String> data = new LinkedHashMap();
    for (String file : filesToAdd) {
      File f = newFile(file);
      if (!isFile(f))
        print("Warning: File " + f.getAbsolutePath() + " not found, skipping");
      else {
        print("Adding file " + file);
        data.put(file, bytesToString_raw(loadBinaryFile(f)));
      }
    }
    print("Compressing a total of " + nBytes(totalStringLength(values(data))) + "...");
    long _startTime_0 = sysNow(); 
      LineCompCompressor compressor = new LineCompCompressor();
      compressor.byteMode = byteMode;
      compressor.toUpper = toUpper;
      if (byteMode) print("byte mode");
      if (toUpper) print("toUpper mode");
      compressor.verboseCompressionSteps = print("verbose", verbose);
      compressor.balancing = balancing;
      if (balancing) print("balancing mode");
      compressor.verify = false;
      compressor.verboseStats = true;
      compressor.loadTexts(data);
      data = null;
      compressor.run();
      File archiveFile = newFile(archiveName);
      lcSaveToFile(compressor, archiveFile);
     done2_always("Compression done", _startTime_0); 
    
    listArchive(archiveFile, false);
  } else if (eqic(cmd, "t")) {
    //print("Listing");
    if (empty(archiveName)) throw fail("Need archive name as second argument");
    File f = newFile(archiveName);
    if (!fileExists(f)) throw fail("File not found: " + f.getAbsolutePath());
    
    listArchive(f, true);
  } else {
    print(autoUnindent_mls("\r\n      This is LINECOMP v0.3, a supercompressor for a bunch of similar text files with fast extraction of any file.\r\n      (c) Stefan Reich 2020, info@BotCompany.de. Source: https://code.BotCompany.de/1028231\r\n      \r\n      Commands:\r\n      \r\n        c archive.lc textFile1 textFile2 ... - create LINECOMP archive archive.lc from files\r\n        cb archive.lc file1 file2 ... - create BYTECOMP archive [compress byte-by-byte]\r\n        x archive.lc - extract archive.lc to current directory\r\n        x archive.lc textFile1 - extract textFile1 from archive.lc to current directory\r\n        t archive.lc - show contents of archive.lc\r\n    "));
  }
}

static void extractVersion(LineCompReader lcr, String version) {
  File outFile = newFile(version);
  saveBinaryFileVerbose(outFile, stringToBytes_raw(lcr.getText(version)));
}

static void listArchive(File f, boolean listFiles) { try {
  LineCompReader lcr = new LineCompReader(f);
  if (listFiles)
    for (String version : lcr.versions())
      print("  Found file: " + version
        //+ " (" + nLines(lcr.lineCountForVersion(version)) + ")");
        + " (" + nBytes(lcr.byteCountForVersion(version)) + ")");
  printWithPrecedingNL("Archive " + f.getCanonicalPath() + " stats:");
    print("  " + str_toK_noSpace(lcr.totalByteCount()) + " of text compressed into " + str_toK_noSpace(l(f)) + " (" + nFiles(l(lcr.versions())) + ")");
} catch (Exception __e) { throw rethrow(__e); } }
static void noRegularGC() {
  if (!_inCore()) { call(javax(), "noRegularGC"); return; }
  Lock __0 = generalLock(); lock(__0); try {
  cancelTimer(regularGC_timer);
  regularGC_timer = null;
} finally { unlock(__0); } }
// unclear semantics as to whether return null on null

static <A> ArrayList<A> asList(A[] a) {
  return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  if (a == null) return null;
  ArrayList<Integer> l = emptyList(a.length);
  for (int i : a) l.add(i);
  return l;
}

static ArrayList<Float> asList(float[] a) {
  if (a == null) return null;
  ArrayList<Float> l = emptyList(a.length);
  for (float i : a) l.add(i);
  return l;
}

static ArrayList<Double> asList(double[] a) {
  if (a == null) return null;
  ArrayList<Double> l = emptyList(a.length);
  for (double i : a) l.add(i);
  return l;
}

static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}



static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}


static <A extends Throwable> A printStackTrace(A e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

static void printStackTrace(String msg, Throwable e) {
  printStackTrace(new Throwable(msg, e));
}
static <A> A popFirst(List<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(0);
  return a;
}

static <A> A popFirst(Collection<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(a);
  return a;
}

static <A> List<A> popFirst(int n, List<A> l) {
  List<A> part = cloneSubList(l, 0, n);
  removeSubList(l, 0, n);
  return part;
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}

static boolean contains(BitSet bs, int i) {
  return bs != null && bs.get(i);
}


static <A> List<A> replace(List<A> l, A a, A b) {
  for (int i = 0; i < l(l); i++)
    if (eq(l.get(i), a))
      l.set(i, b);
  return l;
}

static <A> List<A> replace(A a, A b, List<A> l) {
  return replace(l, a, b);
}

static String replace(String s, String a, String b) {
  return s == null ? null : a == null || b == null ? s : s.replace(a, b);
}

static String replace(String s, char a, char b) {
  return s == null ? null : s.replace(a, b);
}
static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}

static Object first(Object list) {
  return first((Iterable) list);
}


static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}


static <A> A first(IterableIterator<A> i) {
  return first((Iterator<A>) i);
}


static <A> A first(Iterator<A> i) {
  return i == null || !i.hasNext() ? null : i.next();
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }
static Character first(CharSequence s) { return empty(s) ? null : s.charAt(0); }


static <A, B> A first(Pair<A, B> p) {
  return p == null ? null : p.a;
}




static Byte first(byte[] l) { 
  return empty(l) ? null : l[0];
}


static int first(IntBuffer buf) {
  return buf.get(0);
}

static String[] dropFirst(int n, String[] a) {
  return drop(n, a);
}

static String[] dropFirst(String[] a) {
  return drop(1, a);
}

static Object[] dropFirst(Object[] a) {
  return drop(1, a);
}

static <A> List<A> dropFirst(List<A> l) {
  return dropFirst(1, l);
}

static <A> List<A> dropFirst(int n, Iterable<A> i) { return dropFirst(n, toList(i)); }
static <A> List<A> dropFirst(Iterable<A> i) { return dropFirst(toList(i)); }

static <A> List<A> dropFirst(int n, List<A> l) {
  return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
}

static <A> List<A> dropFirst(List<A> l, int n) {
  return dropFirst(n, l);
}

static String dropFirst(int n, String s) { return substring(s, n); }
static String dropFirst(String s, int n) { return substring(s, n); }
static String dropFirst(String s) { return substring(s, 1); }
static boolean eqic(String a, String b) {
  
  
    if ((a == null) != (b == null)) return false;
    if (a == null) return true;
    return a.equalsIgnoreCase(b);
  
}



static boolean eqic(char a, char b) {
  if (a == b) return true;
  
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2) return true;
  
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}
static volatile StringBuffer local_log = new StringBuffer(); // not redirected




static volatile Appendable print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;

static boolean print_silent = false; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<Object> print_byThread; // special handling by thread - prefers F1<S, Bool>
static volatile Object print_allThreads;
static volatile Object print_preprocess;

static void print() {
  print("");
}

static <A> A print(String s, A o) {
  print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
  return o;
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping_okInCleanUp();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  

  print_raw(s);
}

static void print_raw(String s) {
  
  Appendable loc = local_log;
  Appendable buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  
  
    System.out.print(s);
  
}

static void print_autoRotate() {
  
}
static boolean empty(Collection c) { return c == null || c.isEmpty(); }
static boolean empty(Iterable c) { return c == null || !c.iterator().hasNext(); }
static boolean empty(CharSequence s) { return s == null || s.length() == 0; }
static boolean empty(Map map) { return map == null || map.isEmpty(); }
static boolean empty(Object[] o) { return o == null || o.length == 0; }
static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  if (o instanceof byte[]) return empty((byte[]) o);
  if (o == null) return true;
  throw fail("unknown type for 'empty': " + getType(o));
}

static boolean empty(Iterator i) { return i == null || !i.hasNext(); }

static boolean empty(double[] a) { return a == null || a.length == 0; }
static boolean empty(float[] a) { return a == null || a.length == 0; }
static boolean empty(int[] a) { return a == null || a.length == 0; }
static boolean empty(long[] a) { return a == null || a.length == 0; }
static boolean empty(byte[] a) { return a == null || a.length == 0; }
static boolean empty(short[] a) { return a == null || a.length == 0; }





static boolean empty(File f) { return getFileSize(f) == 0; }




static boolean empty(IntBuffer b) { return b == null || b.isEmpty(); }



static boolean empty(LongBuffer b) { return b == null || b.isEmpty(); }

static RuntimeException fail() { throw new RuntimeException("fail"); }
static RuntimeException fail(Throwable e) { throw asRuntimeException(e); }
static RuntimeException fail(Object msg) { throw new RuntimeException(String.valueOf(msg)); }
static RuntimeException fail(String msg) { throw new RuntimeException(msg == null ? "" : msg); }
static RuntimeException fail(String msg, Throwable innerException) { throw new RuntimeException(msg, innerException); }

static File newFile(File base, String... names) {
  for (String name : names) base = new File(base, name);
  return base;
}

static File newFile(String name) {
  return name == null ? null : new File(name);
}

static File newFile(String base, String... names) {
  return newFile(newFile(base), names);
}
static boolean fileExists(String path) {
  return path != null && new File(path).exists();
}

static boolean fileExists(File f) {
  return f != null && f.exists();
}
static boolean isFile(File f) {
  return f != null && f.isFile();
}

static boolean isFile(String path) {
  return isFile(newFile(path));
}
static String bytesToString_raw(byte[] data) { try {
  return data == null ? null : new String(data, "ISO-8859-1");
} catch (Exception __e) { throw rethrow(__e); } }
public static byte[] loadBinaryFile(String fileName) {
 try {
  if (!new File(fileName).exists())
    return null;

  FileInputStream in = new FileInputStream(fileName);

  byte buf[] = new byte[1024];
  ByteArrayOutputStream out = new ByteArrayOutputStream();
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    out.write(buf, 0, l);
  }
  in.close();
  return out.toByteArray();
 } catch (IOException e) { throw new RuntimeException(e); }
}

public static byte[] loadBinaryFile(File file) {
  return loadBinaryFile(file.getPath());
}

static String nBytes(long n) { return n2(n, "byte"); }
static String nBytes(Collection l) { return nBytes(l(l)); }
static String nBytes(byte[] l) { return nBytes(l(l)); }
static long totalStringLength(Iterable<String> l) {
  return totalLengthOfStrings(l);
}
static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}

// convenience shortcut for values_gen
static Collection values(Object map) {
  return values((Map) map);
}




static long sysNow() {
  ping();
  return System.nanoTime()/1000000;
}
static void lcSaveToFile(LineCompCompressor comp, File f) { 
  saveGZTextFile(f, comp.asText(), "ISO-8859-1");
}
static long done2_always(long startTime, String desc) {
  long time = sysNow()-startTime;
  
  // BREAKING CHANGE: Now stores result for lastTiming()
  saveTiming_noPrint(time);
  
  print(desc + " [" + time + " ms]");
  return time;
}

static long done2_always(String desc, long startTime) {
  return done2_always(startTime, desc);
}

static long done2_always(long startTime) {
  return done2_always(startTime, "");
}
static String autoUnindent_mls(String s) {
  return autoUnindent(rtrim(dropLeadingNewLine(s)));
}
static void saveBinaryFileVerbose(File f, byte[] data) {
  boolean exists = f.exists();
  saveBinaryFile(f, data);
  print((!exists ? "Created" : "Updated") + " file " + f2s(f) + " (" + f.length() + " bytes)");
}
static byte[] stringToBytes_raw(String s) { try {
  return s == null ? null : s.getBytes("ISO-8859-1");
} catch (Exception __e) { throw rethrow(__e); } }
static void printWithPrecedingNL(Object o) {
  nlPrint(o);
}
static String str_toK_noSpace(long l) {
  return toK(l) + "K";
}
static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(short[] a) { return a == null ? 0 : a.length; }
static int l(long[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(double[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }

static int l(Iterator i) { return iteratorCount_int_close(i); } // consumes the iterator && closes it if possible

static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); }
static long l(File f) { return f == null ? 0 : f.length(); }



static int l(Object o) {
  return o == null ? 0
    : o instanceof String ? l((String) o)
    : o instanceof Map ? l((Map) o)
    : o instanceof Collection ? l((Collection) o)
    : o instanceof Object[] ? l((Object[]) o)
    : o instanceof boolean[] ? l((boolean[]) o)
    : o instanceof byte[] ? l((byte[]) o)
    : o instanceof char[] ? l((char[]) o)
    : o instanceof short[] ? l((short[]) o)
    : o instanceof int[] ? l((int[]) o)
    : o instanceof float[] ? l((float[]) o)
    : o instanceof double[] ? l((double[]) o)
    : o instanceof long[] ? l((long[]) o)
    : (Integer) call(o, "size");
}











  static int l(IntBuffer b) { return b == null ? 0 : b.size(); }



  static int l(LongBuffer b) { return b == null ? 0 : b.size(); }


static String nFiles(long n) { return n2(n, "file"); }
static String nFiles(Collection l) { return nFiles(l(l)); }
static RuntimeException rethrow(Throwable t) {
  
  throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}

static RuntimeException rethrow(String msg, Throwable t) {
  throw new RuntimeException(msg, t);
}


static int regularGC_interval = 60000; // every minute
static int regularGC_firstDelay = 20000; // clean up 20 seconds after loading VM
static volatile java.util.Timer regularGC_timer;
static Object regularGC_condition; // F0<Bool> - set this to make GC depend on a condition

static int regularGC_countdown = -1;

static void regularGC() {
  if (!_inCore()) { callJavaX("regularGC"); return; }
  Lock __0 = generalLock(); lock(__0); try {
  if (regularGC_timer == null)
    regularGC_timer = doEvery_daemon(regularGC_interval, regularGC_firstDelay, "regularGC_doIt");
} finally { unlock(__0); } }

static void regularGC_doIt() {
  if (regularGC_countdown == 0) return;
  else if (regularGC_countdown > 0) --regularGC_countdown;
  if (!isFalse(pcallF(regularGC_condition)))
    timedGCPlusDeadlockSolving();
  else
    callOpt(javax(), "cleanWeakMaps"); // This is important, always do it
}

static AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
  return print_byThread().get() == null ? tempInterceptPrint(f) : null;
}
static boolean _inCore() {
  return false;
}
static Object call(Object o) {
  return callF(o);
}

// varargs assignment fixer for a single string array argument
static Object call(Object o, String method, String[] arg) {
  return call(o, method, new Object[] {arg});
}

static Object call(Object o, String method, Object... args) {
  //ret call_cached(o, method, args);
  return call_withVarargs(o, method, args);
}
static Class javax() {
  return getJavaX();
}
static Lock generalLock_instance = lock();

static Lock generalLock() {
  return generalLock_instance;
}
static void lock(Lock lock) { try {
  ping();
  if (lock == null) return;
  try {
    lock.lockInterruptibly();
  } catch (InterruptedException e) {
    print("Locking interrupted! I probably deadlocked, oops.");
    printStackTrace(e);
    rethrow(e);
  }
  ping();
} catch (Exception __e) { throw rethrow(__e); } }

static void lock(Lock lock, String msg) {
  print("Locking: " + msg);
  lock(lock);
}

static void lock(Lock lock, String msg, long timeout) {
  print("Locking: " + msg);
  lockOrFail(lock, timeout);
}

static ReentrantLock lock() {
  return fairLock();
}

static void cancelTimer(javax.swing.Timer timer) {
  if (timer != null) timer.stop();
}


static void cancelTimer(java.util.Timer timer) {
  if (timer != null) timer.cancel();
}

static void cancelTimer(Object o) {
  if (o instanceof java.util.Timer) cancelTimer((java.util.Timer) o);
  
  else if (o instanceof javax.swing.Timer) cancelTimer((javax.swing.Timer) o);
  
  else if (o instanceof AutoCloseable) { try { ((AutoCloseable) o).close(); } catch (Throwable __e) { _handleException(__e); }}
}
static void unlock(Lock lock, String msg) {
  if (lock == null) return;
  print("Unlocking: " + msg);
  lock.unlock();
}

static void unlock(Lock lock) {
  if (lock == null) return;
  lock.unlock();
}
static ArrayList emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}

static ArrayList emptyList(int capacity) {
  return new ArrayList(max(0, capacity));
}

// Try to match capacity
static ArrayList emptyList(Iterable l) {
  return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
}

static ArrayList emptyList(Object[] l) {
  return emptyList(l(l));
}

// get correct type at once
static <A> ArrayList<A> emptyList(Class<A> c) {
  return new ArrayList();
}
static String getStackTrace(Throwable throwable) {
  lastException(throwable);
  return getStackTrace_noRecord(throwable);
}

static String getStackTrace_noRecord(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return hideCredentials(writer.toString());
}

static String getStackTrace() {
  return getStackTrace_noRecord(new Throwable());
}
static <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
  return newSubList(l, startIndex, endIndex);
}

static <A> List<A> cloneSubList(List<A> l, int startIndex) {
  return newSubList(l, startIndex);
}
static void removeSubList(List l, int from, int to) {
  if (l != null) subList(l, from, to).clear();
}

static void removeSubList(List l, int from) {
  if (l != null) subList(l, from).clear();
}
static boolean eq(Object a, Object b) {
  return a == b || a != null && b != null && a.equals(b);
}


static String[] drop(int n, String[] a) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}

static Object[] drop(int n, Object[] a) {
  n = Math.min(n, a.length);
  Object[] b = new Object[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}
static <A> ArrayList<A> toList(A[] a) { return asList(a); }
static ArrayList<Integer> toList(int[] a) { return asList(a); }
static <A> ArrayList<A> toList(Set<A> s) { return asList(s); }
static <A> ArrayList<A> toList(Iterable<A> s) { return asList(s); }
static String substring(String s, int x) {
  return substring(s, x, strL(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  int n = s.length();
  if (y < x) y = x;
  if (y > n) y = n;
  if (x >= y) return "";
  return s.substring(x, y);
}



// convenience method for quickly dropping a prefix
static String substring(String s, CharSequence l) {
  return substring(s, l(l));
}
static String asString(Object o) {
  return o == null ? null : o.toString();
}
static boolean endsWithLetterOrDigit(String s) {
  return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length()-1));
}
static void ping_okInCleanUp() {

}
static void print_append(Appendable buf, String s, int max) { try {
  synchronized(buf) {
    buf.append(s);
    if (buf instanceof StringBuffer)
      rotateStringBuffer(((StringBuffer) buf), max);
    else if (buf instanceof StringBuilder)
      rotateStringBuilder(((StringBuilder) buf), max);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static String getType(Object o) {
  return getClassName(o);
}
static long getFileSize(String path) {
  return path == null ? 0 : new File(path).length();
}

static long getFileSize(File f) {
  return f == null ? 0 : f.length();
}
static RuntimeException asRuntimeException(Throwable t) {
  
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static String n2(long l) { return formatWithThousands(l); }
static String n2(Collection l) { return n2(l(l)); }
static String n2(Map map) { return n2(l(map)); }

static String n2(double l, String singular) {
  return n2(l, singular, singular + "s");
}

static String n2(double l, String singular, String plural) {
  if (fraction(l) == 0)
    return n2((long) l, singular, plural);
  else
    return l + " " + plural;
}

static String n2(long l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(long l, String singular) {
  return n_fancy2(l, singular, singular + "s");
}

static String n2(Collection l, String singular) {
  return n2(l(l), singular);
}

static String n2(Collection l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(Map m, String singular, String plural) {
  return n_fancy2(m, singular, plural);
}

static String n2(Map m, String singular) {
  return n2(l(m), singular);
}

static String n2(Object[] a, String singular) { return n2(l(a), singular); }
static String n2(Object[] a, String singular, String plural) { return n_fancy2(a, singular, plural); }


static long totalLengthOfStrings(Iterable<String> l) {
  long total = 0;
  for (String s : unnull(l)) total += l(s);
  return total;
}
static <A> List<A> concatLists(Iterable<A>... lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Iterable<A> list : lists)
    addAll(l, list);
  return l;
}

static <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Iterable<A> list : lists)
    addAll(l, list);
  return l;
}


// you can change this function to allow interrupting long calculations from the outside. just throw a RuntimeException.
static boolean ping() { return true; }
static boolean ping_impl(boolean okInCleanUp) { return true; }



static void saveGZTextFile(File file, String contents) { saveGZTextFile(file, contents, "UTF-8"); }
static void saveGZTextFile(File file, String contents, String encoding) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  String tempFileName = file.getPath() + "_temp";
  File tempFile = new File(tempFileName);
  if (contents != null) {
    if (tempFile.exists()) try {
      String saveName = tempFileName + ".saved." + now();
      copyFile(tempFile, new File(saveName));
    } catch (Throwable e) { printStackTrace(e); }
    FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
    GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, encoding);
    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
    printWriter.print(contents);
    printWriter.close();
    gos.close();
    fileOutputStream.close();
  }
  
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (contents != null)
    if (!tempFile.renameTo(file))
      throw new IOException("Can't rename " + tempFile + " to " + file);
} catch (Exception __e) { throw rethrow(__e); } }
static ThreadLocal<Long> saveTiming_last = new ThreadLocal();

static void saveTiming(long ms) {
  print(ms + " ms");
  saveTiming_noPrint(ms);
}

static void saveTiming_noPrint(long ms) {
  saveTiming_last.set(ms);
}
static String autoUnindent(String s) {
  int n = getIndent(s);
  if (n == 0) return s;
  List<String> l = toLines(s);
  for (int i = 0; i < l(l); i++)
    l.set(i, substring(l.get(i), n));
  return fromLines(l);
}
public static String rtrim(String s) {
  if (s == null) return null;
  int i = s.length();
  while (i > 0 && " \t\r\n".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}
static String dropLeadingNewLine(String s) {
  if (startsWith(s, "\r\n")) return substring(s, 2);
  if (startsWith(s, "\n")) return substring(s, 1);
  return s;
}
/** writes safely (to temp file, then rename) */
public static byte[] saveBinaryFile(String fileName, byte[] contents) { try {
  File file = new File(fileName);
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  String tempFileName = fileName + "_temp";
  FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
  fileOutputStream.write(contents);
  fileOutputStream.close();
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + fileName);

  if (!new File(tempFileName).renameTo(file))
    throw new IOException("Can't rename " + tempFileName + " to " + fileName);
    
  
  return contents;
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] saveBinaryFile(File fileName, byte[] contents) {
  return saveBinaryFile(fileName.getPath(), contents);
}
static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}

static String f2s(String s) { return f2s(newFile(s)); }


 static String f2s(java.nio.file.Path p) {
  return p == null ? null : f2s(p.toFile());
}

static <A> A nlPrint(A o) {
  return nlPrint("", o);
}

static <A> A nlPrint(String prefix, A o) {
  return print("\n" + unnull(prefix), o);
}
static long toK(long l) {
  return (l+1023)/1024;
}
static <A> int iteratorCount_int_close(Iterator<A> i) { try {
  int n = 0;
  if (i != null) while (i.hasNext()) { i.next(); ++n; }
  if (i instanceof AutoCloseable) ((AutoCloseable) i).close();
  return n;
} catch (Exception __e) { throw rethrow(__e); } }


static Object callJavaX(String method, Object... args) {
  return callOpt(getJavaX(), method, args);
}
// firstDelay = delay
static FixedRateTimer doEvery_daemon(long delay, final Object r) {
  return doEvery_daemon(delay, delay, r);
}

static FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(true);
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
  return timer;
}

static FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
  return doEvery_daemon(toMS(delaySeconds), r);
}
static boolean isFalse(Object o) {
  return eq(false, o);
}
static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}


static <A> A pcallF(F0<A> f) { try {
  return f == null ? null : f.get();
} catch (Throwable __e) { return null; } }



static <A, B> B pcallF(F1<A, B> f, A a) { try {
  return f == null ? null : f.get(a);
} catch (Throwable __e) { return null; } }



static <A> void pcallF(VF1<A> f, A a) {
  try {
    if (f != null) f.get(a);
  } catch (Throwable __e) { _handleException(__e); }
}

static void timedGCPlusDeadlockSolving() {
  timedGC();
  printDeadlocksAndSolve();
}
static Object callOpt(Object o) {
  return callF(o);
}

static <A> A callOpt(Object o, String method, Object... args) {
  return (A) callOpt_withVarargs(o, method, args);
}
static ThreadLocal<Object> print_byThread() {
  synchronized(print_byThread_lock) {
    if (print_byThread == null)
      print_byThread = new ThreadLocal();
  }
  return print_byThread;
}
// f can return false to suppress regular printing
// call print_raw within f to actually print something
static AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
  return tempSetThreadLocal(print_byThread(), f);
}
static Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();


  static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }



  static <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }





  static <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A> void callF(VF1<A> f, A a) {
    if (f != null) f.get(a);
  }


static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMCWithVarArgs((String) f, args); // possible SLOWDOWN over callMC
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) {
    
    throw fail("No get method in " + getClassName(c));
  }
  if (n == 1) return invokeMethod(methods.get(0), f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return invokeMethod(m, f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static Object call_withVarargs(Object o, String method, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findStaticMethod(method, args);
    if (me != null)
      return invokeMethod(me, null, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      { if (!(isStaticMethod(m))) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, null, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(method, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
  }
} catch (Exception __e) { throw rethrow(__e); } }
static Class __javax;

static Class getJavaX() { try {
  
  return __javax;
} catch (Exception __e) { throw rethrow(__e); } }
static void lockOrFail(Lock lock, long timeout) { try {
  ping();
  if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
    String s = "Couldn't acquire lock after " + timeout + " ms.";
    if (lock instanceof ReentrantLock) {
      ReentrantLock l =  (ReentrantLock) lock;
      s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
    }
    throw fail(s);
  }
  ping();
} catch (Exception __e) { throw rethrow(__e); } }
static ReentrantLock fairLock() {
  return new ReentrantLock(true);
}
static volatile PersistableThrowable _handleException_lastException;
static List _handleException_onException = synchroList(ll("printStackTrace2"));

static void _handleException(Throwable e) {
  _handleException_lastException = persistableThrowable(e);
  
  Throwable e2 = innerException(e);
  if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
    return;
    
  for (Object f : cloneList(_handleException_onException)) try {
    callF(f, e);
  } catch (Throwable e3) {
    printStackTrace2(e3); // not using pcall here - it could lead to endless loops
  }
}

static int max(int a, int b) { return Math.max(a, b); }
static int max(int a, int b, int c) { return max(max(a, b), c); }
static long max(int a, long b) { return Math.max((long) a, b); }
static long max(long a, long b) { return Math.max(a, b); }
static double max(int a, double b) { return Math.max((double) a, b); }
static float max(float a, float b) { return Math.max(a, b); }
static double max(double a, double b) { return Math.max(a, b); }

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}

static int max(int[] c) {
  int x = Integer.MIN_VALUE;
  for (int d : c) if (d > x) x = d;
  return x;
}
// PersistableThrowable doesn't hold GC-disturbing class references in backtrace
static volatile PersistableThrowable lastException_lastException;

static PersistableThrowable lastException() {
  return lastException_lastException;
}

static void lastException(Throwable e) {
  lastException_lastException = persistableThrowable(e);
}
static String hideCredentials(URL url) { return url == null ? null : hideCredentials(str(url)); }

static String hideCredentials(String url) {
  try {
    if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url))) return url;
  } catch (Throwable e) {
    print("HideCredentials", e);
  }
  return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
}

static String hideCredentials(Object o) {
  return hideCredentials(str(o));
}
static <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
  return cloneList(subList(l, startIndex, endIndex));
}

static <A> List<A> newSubList(List<A> l, int startIndex) {
  return cloneList(subList(l, startIndex));
}
static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
  return subList(l, startIndex, endIndex);
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = Math.max(0, startIndex);
  endIndex = Math.min(n, endIndex);
  if (startIndex >= endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  return l.subList(startIndex, endIndex);
}


static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
static int strL(String s) {
  return s == null ? 0 : s.length();
}
static void rotateStringBuffer(StringBuffer buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static void rotateStringBuilder(StringBuilder buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static String getClassName(Object o) {
  return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
}
static String formatWithThousands(long l) {
  return formatWithThousandsSeparator(l);
}
static double fraction(double d) {
  return d % 1;
}
static String n_fancy2(long l, String singular, String plural) {
  return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
}

static String n_fancy2(Collection l, String singular, String plural) {
  return n_fancy2(l(l), singular, plural);
}

static String n_fancy2(Map m, String singular, String plural) {
  return n_fancy2(l(m), singular, plural);
}

static String n_fancy2(Object[] a, String singular, String plural) {
  return n_fancy2(l(a), singular, plural);
}


static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> Collection<A> unnull(Collection<A> l) {
  return l == null ? emptyList() : l;
}

static <A> List<A> unnull(List<A> l) { return l == null ? emptyList() : l; }
static int[] unnull(int[] l) { return l == null ? emptyIntArray() : l; }
static char[] unnull(char[] l) { return l == null ? emptyCharArray() : l; }

static <A, B> Map<A, B> unnull(Map<A, B> l) {
  return l == null ? emptyMap() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static <A> A[] unnull(A[] a) {
  return a == null ? (A[]) emptyObjectArray() : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}



//ifclass Symbol



static <A, B> Pair<A, B> unnull(Pair<A, B> p) {
  return p != null ? p : new Pair(null, null);
}

static <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
  if (c != null && b != null) for (A a : b) c.add(a);
}

static <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
  return c != null && b != null && c.addAll(b);
}

static <A, B extends A> boolean addAll(Collection<A> c, B... b) {
  return c != null && c.addAll(Arrays.asList(b));
}



static <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll(b);
  return a;
}
static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}

static File copyFile(File src, File dest) { try {
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
  return dest;
} catch (Exception __e) { throw rethrow(__e); } }
static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
  return newFileOutputStream(path.getPath(), append);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  mkdirsForFile(path);
  FileOutputStream f = new FileOutputStream(path, append);
  
  return f;
}
static int getIndent(String s) {
  int n = Integer.MAX_VALUE;
  for (String l : toLines(s))
    n = min(n, getIndentOfLine(l));
  return n;
}

static IterableIterator<String> toLines(File f) {
  return linesFromFile(f);
}

static List<String> toLines(String s) {
  List<String> lines = new ArrayList<String>();
  if (s == null) return lines;
  int start = 0;
  while (true) {
    int i = toLines_nextLineBreak(s, start);
    if (i < 0) {
      if (s.length() > start) lines.add(s.substring(start));
      break;
    }

    lines.add(s.substring(start, i));
    if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
      i += 2;
    else
      ++i;

    start = i;
  }
  return lines;
}

static int toLines_nextLineBreak(String s, int start) {
  int n = s.length();
  for (int i = start; i < n; i++) {
    char c = s.charAt(i);
    if (c == '\r' || c == '\n')
      return i;
  }
  return -1;
}
// usually L<S>
static String fromLines(Iterable lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null)
    for (Object line : lines)
      buf.append(str(line)).append('\n');
  return buf.toString();
}

static String fromLines(String... lines) {
  return fromLines(asList(lines));
}
static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(unnull(b));
}

static boolean startsWith(String a, char c) {
  return nemptyString(a) && a.charAt(0) == c;
}


  static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b)) return false;
    m.m = new String[] {substring(a, strL(b))};
    return true;
  }


static boolean startsWith(List a, List b) {
  if (a == null || listL(b) > listL(a)) return false;
  for (int i = 0; i < listL(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}




static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}

// r may return false to cancel timer
static TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
  return new SmartTimerTask(r, timer, delay, _threadInfo());
}

static class SmartTimerTask extends TimerTask implements IFieldsToList{
  Object r;
  java.util.Timer timer;
  long delay;
  Object threadInfo;
  SmartTimerTask() {}
  SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
  this.threadInfo = threadInfo;
  this.delay = delay;
  this.timer = timer;
  this.r = r;}
  public String toString() { return shortClassName(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")"; }public Object[] _fieldsToList() { return new Object[] {r, timer, delay, threadInfo}; }

  long lastRun;
  
  public void run() {
    if (!licensed())
      timer.cancel();
    else {
      _threadInheritInfo(threadInfo);
       AutoCloseable __1 = tempActivity(r); try {
      lastRun = fixTimestamp(lastRun);
      long now = now();
      if (now >= lastRun + delay*0.9) {
        lastRun = now;
        if (eq(false, pcallF(r)))
          timer.cancel();
      }
    } finally { _close(__1); }}
  }
}
static long toMS(double seconds) {
  return (long) (seconds*1000);
}
static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { _handleException(__e); }
  return null;
}
static int timedGC_minPrint = 5000; // print notice to console when GC takes longer than these many ms

static void timedGC() {
  long time = sysNow(), start = now();
  gc_notTooOften();
  done2_systemErr_minPrint = timedGC_minPrint;
  done2_systemErr(time, "GC " + hmsWithColons(start));
}
static List<ThreadInfo> printDeadlocksAndSolve() {
  List<ThreadInfo> l = printDeadlocks();
  interruptDeadlockedThreads(l);
  return l;
}
static Object callOpt_withVarargs(Object o, String method, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findMethod(method, args);
    if (me == null) {
      // TODO: varargs
      return null;
    }
    if ((me.getModifiers() & Modifier.STATIC) == 0)
      return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(method, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
  if (tl == null) return null;
  final A prev = setThreadLocal(tl, a);
  return new AutoCloseable() { public String toString() { return "tl.set(prev);"; } public void close() throws Exception { tl.set(prev); }};
}
static <A, B> Map<A, B> newDangerousWeakHashMap() {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
}

// initFunction: voidfunc(Map) - is called initially, and after clearing the map
static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
}
static Object callMCWithVarArgs(String method, Object... args) {
  return call_withVarargs(mc(), method, args);
}
static Object invokeMethod(Method m, Object o, Object... args) { try {
  try {
    return m.invoke(o, args);
  } catch (InvocationTargetException e) {
    throw rethrow(getExceptionCause(e));
  } catch (IllegalArgumentException e) {
    throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      print("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++) {
    Object arg = args[i];
    if (!(arg == null ? !types[i].isPrimitive()
      : isInstanceX(types[i], arg))) {
      if (debug)
        print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
      return false;
    }
  }
  return true;
}
static Field makeAccessible(Field f) {
  try {
    f.setAccessible(true);
  } catch (Throwable e) {
    // Note: The error reporting only works with Java VM option --illegal-access=deny
    
  }
  return f;
}

static Method makeAccessible(Method m) {
  try {
    m.setAccessible(true);
  } catch (Throwable e) {
    
  }
  return m;
}

static Constructor makeAccessible(Constructor c) {
  try {
    c.setAccessible(true);
  } catch (Throwable e) {
    
  }
  return c;
}
static final Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

static Object callOpt_cached(Object o, String methodName, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    // TODO: (super-rare) case where method exists static and non-static
    // with different args
    
    Method me = cache.findMethod(methodName, args);
    if (me == null || (me.getModifiers() & Modifier.STATIC) == 0) return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(methodName, args);
    if (me == null) return null;
    return invokeMethod(me, o, args);
  }
} catch (Exception __e) { throw rethrow(__e); } }

static _MethodCache callOpt_getCache(Class c) {
  synchronized(callOpt_cache) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }
}
static boolean isStaticMethod(Method m) {
  return methodIsStatic(m);
}
static Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  int n = types.length-1, nArgs = args.length;
  if (nArgs < n) return null;
  for (int i = 0; i < n; i++)
    if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
  Class varArgType = types[n].getComponentType();
  for (int i = n; i < nArgs; i++)
    if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
  Object[] newArgs = new Object[n+1];
  arraycopy(args, 0, newArgs, 0, n);
  Object[] varArgs = arrayOfType(varArgType, nArgs-n);
  arraycopy(args, n, varArgs, 0, nArgs-n);
  newArgs[n] = varArgs;
  return newArgs;
}
static <A> String joinWithComma(Collection<A> c) {
  return join(", ", c);
}

static String joinWithComma(String... c) {
  return join(", ", c);
}


static String joinWithComma(Pair p) {
  return p == null ? "" : joinWithComma(str(p.a), str(p.b));
}

static List<String> classNames(Collection l) {
  return getClassNames(l);
}

static List<String> classNames(Object[] l) {
  return getClassNames(Arrays.asList(l));
}
static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static <A> List<A> ll(A... a) {
  ArrayList l = new ArrayList(a.length);
  if (a != null) for (A x : a) l.add(x);
  return l;
}
static PersistableThrowable persistableThrowable(Throwable e) {
  return e == null ? null : new PersistableThrowable(e);
}
static Throwable innerException(Throwable e) {
  return getInnerException(e);
}
static <A> ArrayList<A> cloneList(Iterable<A> l) {
  return l instanceof Collection ? cloneList((Collection) l) : asList(l);
}

static <A> ArrayList<A> cloneList(Collection<A> l) {
  if (l == null) return new ArrayList();
  synchronized(collectionMutex(l)) {
    return new ArrayList<A>(l);
  }
}
static boolean startsWithOneOf(String s, String... l) {
  for (String x : l) if (startsWith(s, x)) return true; return false;
}

static boolean startsWithOneOf(String s, Matches m, String... l) {
  for (String x : l) if (startsWith(s, x, m)) return true; return false;
}
static boolean isAGIBlueDomain(String domain) {
  return domainIsUnder(domain, theAGIBlueDomain());
}
static String hostNameFromURL(String url) { try {
  return new URL(url).getHost();
} catch (Exception __e) { throw rethrow(__e); } }


static String formatWithThousandsSeparator(long l) {
  return NumberFormat.getInstance(new Locale("en_US")).format(l);
}
static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }
static int[] emptyIntArray_a = new int[0];
static int[] emptyIntArray() { return emptyIntArray_a; }
static char[] emptyCharArray = new char[0];
static char[] emptyCharArray() { return emptyCharArray; }
static Map emptyMap() {
  return new HashMap();
}
static Object[] emptyObjectArray_a = new Object[0];
static Object[] emptyObjectArray() { return emptyObjectArray_a; }
static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }
public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) { // is null if file is in current dir
    dir.mkdirs();
    if (!dir.isDirectory())
      if (dir.isFile()) throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
      else throw fail("Unknown IO exception during mkdirs of " + f2s(file));
  }
  return file;
}

public static String mkdirsForFile(String path) {
  mkdirsForFile(new File(path));
  return path;
}
static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}

static int min(int[] c) {
  int x = Integer.MAX_VALUE;
  for (int d : c) if (d < x) x = d;
  return x;
}
static int getIndentOfLine(String s) {
  int i = 0, n = l(s);
  while (i < n && s.charAt(i) == ' ')
    ++i;
  return i;
}

static CloseableIterableIterator<String> linesFromFile(File f) { try {
  if (!f.exists()) return emptyCloseableIterableIterator();
  
  if (ewic(f.getName(), ".gz"))
    return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
  
  return linesFromReader(utf8bufferedReader(f));
} catch (Exception __e) { throw rethrow(__e); } }

static CloseableIterableIterator<String> linesFromFile(String path) {
  return linesFromFile(newFile(path));
}
static boolean nemptyString(String s) {
  return s != null && s.length() > 0;
}
static int listL(Collection l) {
  return l == null ? 0 : l.size();
}
static boolean neq(Object a, Object b) {
  return !eq(a, b);
}


static String getStackTrace2(Throwable e) {
  return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ",
    hideCredentials(str(innerException2(e)))) + "\n");
}
static List<VF1<Map>> _threadInfo_makers = synchroList();

static Object _threadInfo() {
  if (empty(_threadInfo_makers)) return null;
  HashMap map = new HashMap();
  pcallFAll(_threadInfo_makers, map);
  return map;
}
static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}
static volatile boolean licensed_yes = true;

static boolean licensed() {
  if (!licensed_yes) return false;
  ping_okInCleanUp();
  return true;
}

static void licensed_off() {
  licensed_yes = false;
}
static List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

static void _threadInheritInfo(Object info) {
  if (info == null) return;
  pcallFAll(_threadInheritInfo_retrievers, (Map) info);
}
static AutoCloseable tempActivity(Object r) {
  return null;
}
static long fixTimestamp(long timestamp) {
  return timestamp > now() ? 0 : timestamp;
}
static void _close(AutoCloseable c) {
  if (c != null) try {
    c.close();
  } catch (Throwable e) {
    // Some classes stupidly throw an exception on double-closing
    if (c instanceof javax.imageio.stream.ImageOutputStream)
      return;
    else throw rethrow(e);
  }
}
static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static volatile long gc_notTooOften_last;
static volatile long gc_notTooOften_interval = 1000;

static void gc_notTooOften() {
  gc_notTooOften_last = fixTimestamp(gc_notTooOften_last);
  if (now() >= gc_notTooOften_last + gc_notTooOften_interval) {
    gc();
    gc_notTooOften_last = now();
  }
}
static int done2_systemErr_minPrint = 10;

static long done2_systemErr(long startTime, String desc) {
  long time = sysNow()-startTime;
  if (time >= done2_systemErr_minPrint)
    System.err.println(desc + " [" + time + " ms]");
  return time;
}

static long done2_systemErr(String desc, long startTime) {
  return done2_systemErr(startTime, desc);
}

static long done2_systemErr(long startTime) {
  return done2_systemErr(startTime, "");
}


static String hmsWithColons() {
  return hmsWithColons(now());
}

static String hmsWithColons(long time) {
  return new SimpleDateFormat("HH:mm:ss").format(time);
}

static volatile List<ThreadInfo> printDeadlocks_lastDeadlock;

static List<ThreadInfo> printDeadlocks() {
  ThreadMXBean bean = ManagementFactory.getThreadMXBean();
  long ids[] = bean.findDeadlockedThreads();
  if (empty(ids)) return emptyList();
  
  printAsciiHeading("DEADLOCKED THREADS!");
  ThreadInfo threadInfo[] = bean.getThreadInfo(ids);
  String info = print(deadlockedThreadsToString(asList(threadInfo)));
  appendToFile(javaxDataDir("deadlocks.txt"), "\n\n" + localDateWithSeconds() + "\n\n" + info);
  return printDeadlocks_lastDeadlock = asList(threadInfo);
}
static void interruptDeadlockedThreads(List<ThreadInfo> lockingThreads) {
  if (empty(lockingThreads)) return;
  List<Thread> threads = threadInfosToThreads(lockingThreads);
  if (empty(threads)) return;
  Thread t = random(threads);
  print("Interrupting deadlocked thread " + quote(t.getName()) + " (out of " + l(lockingThreads) + ")");
  t.interrupt();
}
static <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
  if (tl == null) return null;
  A old = tl.get();
  tl.set(value);
  return old;
}
static List<Pair> _registerDangerousWeakMap_preList;

static <A> A _registerDangerousWeakMap(A map) {
  return _registerDangerousWeakMap(map, null);
}

static <A> A _registerDangerousWeakMap(A map, Object init) {
  
  return map;
}

static void _onLoad_registerDangerousWeakMap() {
  
}
static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static Class mc() {
  return main.class;
}
static Throwable getExceptionCause(Throwable e) {
  Throwable c = e.getCause();
  return c != null ? c : e;
}
static String joinWithSpace(Iterable c) {
  return join(" ", c);
}

static String joinWithSpace(String... c) {
  return join(" ", c);
}

static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static boolean methodIsStatic(Method m) {
  return (m.getModifiers() & Modifier.STATIC) != 0;
}
static boolean argumentCompatibleWithType(Object arg, Class type) {
  return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
}
static void arraycopy(Object[] a, Object[] b) {
  if (a != null && b != null)
    arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
}

static void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
  if (n != 0)
    System.arraycopy(src, srcPos, dest, destPos, n);
}
static <A> A[] arrayOfType(Class<A> type, int n) {
  return makeArray(type, n);
}

static <A> A[] arrayOfType(int n, Class<A> type) {
  return arrayOfType(type, n);
}
public static <A> String join(String glue, Iterable<A> strings) {
  if (strings == null) return "";
  if (strings instanceof Collection) {
    if (((Collection) strings).size() == 1) return str(first(((Collection) strings)));
  }
  StringBuilder buf = new StringBuilder();
  Iterator<A> i = strings.iterator();
  if (i.hasNext()) {
    buf.append(i.next());
    while (i.hasNext())
      buf.append(glue).append(i.next());
  }
  return buf.toString();
}

public static String join(String glue, String... strings) {
  return join(glue, Arrays.asList(strings));
}

static <A> String join(Iterable<A> strings) {
  return join("", strings);
}

static <A> String join(Iterable<A> strings, String glue) {
  return join(glue, strings);
}

public static String join(String[] strings) {
  return join("", strings);
}


static String join(String glue, Pair p) {
  return p == null ? "" : str(p.a) + glue + str(p.b);
}

static List<String> getClassNames(Collection l) {
  List<String> out = new ArrayList();
  if (l != null) for (Object o : l)
    out.add(o == null ? null : getClassName(o));
  return out;
}
static Throwable getInnerException(Throwable e) {
  if (e == null) return null;
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}

static Throwable getInnerException(Runnable r) {
  return getInnerException(getException(r));
}
static Object collectionMutex(List l) {
  return l;
}

static Object collectionMutex(Object o) {
  if (o instanceof List) return o;
  
  String c = className(o);
  if (eq(c, "java.util.TreeMap$KeySet"))
    c = className(o = getOpt(o, "m"));
  else if (eq(c, "java.util.HashMap$KeySet"))
    c = className(o = get_raw(o, "this$0"));

  
  
  if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
    c = className(o = get_raw(o, "m"));
    
  
    
  return o;
}
static boolean domainIsUnder(String domain, String mainDomain) {
  return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
}
static String theAGIBlueDomain() {
  return "agi.blue";
}
static CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {
  public Object next() { throw fail(); }
  public boolean hasNext() { return false; }
};

static <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
  return emptyCloseableIterableIterator_instance; 
}
static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}


static boolean ewic(String a, String b, Matches m) {
  return endsWithIgnoreCase(a, b, m);
}

static CloseableIterableIterator<String> linesFromReader(Reader r) {
  final BufferedReader br = bufferedReader(r);
  return iteratorFromFunction_f0_autoCloseable(new F0<String>() { public String get() { try {  return readLineFromReaderWithClose(br);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret readLineFromReaderWithClose(br);"; }}, _wrapIOCloseable(r));
}
static BufferedReader utf8bufferedReader(InputStream in) { try {
  return bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader utf8bufferedReader(File f) { try {
  return utf8bufferedReader(newFileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }
static GZIPInputStream newGZIPInputStream(File f) {
  return gzInputStream(f);
}

static GZIPInputStream newGZIPInputStream(InputStream in) {
  return gzInputStream(in);
}


static Throwable unwrapTrivialExceptionWraps(Throwable e) {
  if (e == null) return e;
  while (e.getClass() == RuntimeException.class
    && e.getCause() != null && eq(e.getMessage(), str(e.getCause())))
    e = e.getCause();
  return e;
}
static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}
static Throwable innerException2(Throwable e) {
  if (e == null) return null;
  while (empty(e.getMessage()) && e.getCause() != null)
    e = e.getCause();
  return e;
}
static void pcallFAll(Collection l, Object... args) {
  if (l != null) for (Object f : cloneList(l)) pcallF(f, args);
}

static void pcallFAll(Iterator it, Object... args) {
  while (it.hasNext()) pcallF(it.next(), args);
}
static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}
static volatile long gc_memoryUsedAfterGC;
static volatile long gc_lastStart;
static volatile long gc_duration;
static Lock gc_lock = lock();

static void gc() {
  callOpt(javax(), "cleanWeakMaps");
  {
    Lock __0 = gc_lock; lock(__0); try {
    gc_lastStart = sysNow();
    System.gc();
    gc_duration = sysNow()-gc_lastStart;
    gc_memoryUsedAfterGC = usedMemory();
  } finally { unlock(__0); } }
  vmBus_send("gcDone");
}
static void printAsciiHeading(String text) {
  print(asciiHeading2(text));
}
static String deadlockedThreadsToString(List<ThreadInfo> threadInfo) {
  List<String> out = new ArrayList();
  int i = 0;
  Map<ThreadInfo, Thread> map = threadInfosToThreads_map(threadInfo);
  for (ThreadInfo threadInfo1 : threadInfo) {
    out.add("Thread " + (++i) + "/" + l(threadInfo) + ": ID=" + threadInfo1.getThreadId()
      + ", name=" + quote(threadInfo1.getThreadName()));
    out.add("  Trying to lock: " + threadInfo1.getLockName()
      + " which is owned by thread " + threadInfo1.getLockOwnerId()
      + " (" + quote(threadInfo1.getLockOwnerName()) + ")");
    // ThreadInfo.getStackTrace() doesn't work, so we look up the thread.
    Thread t = map.get(threadInfo1);
    if (t != null) {
      StackTraceElement[] st = t.getStackTrace();
      out.add("Stack trace (" + l(st) + "): ");
      out.add(indentx(stackTraceToString(st)));
    }
  }
  return lines(out);
}
static Lock appendToFile_lock = lock();
static boolean appendToFile_keepOpen = false;
static HashMap<String, Writer> appendToFile_writers = new HashMap();

static void appendToFile(String path, String s) { try {
  Lock __0 = appendToFile_lock; lock(__0); try { // Let's just generally synchronize this to be safe.
  mkdirsForFile(new File(path));
  path = getCanonicalPath(path);
  Writer writer = appendToFile_writers.get(path);
  if (writer == null) {
    //print("[Logging to " + path + "]");
    writer = new BufferedWriter(new OutputStreamWriter(
      newFileOutputStream(path, true), "UTF-8"));
    if (appendToFile_keepOpen)
      appendToFile_writers.put(path, writer);
  }
  writer.write(s);
  if (!appendToFile_keepOpen)
    writer.close();
} finally { unlock(__0); } } catch (Exception __e) { throw rethrow(__e); } }
  
static void appendToFile(File path, String s) {
  if (path != null)
    appendToFile(path.getPath(), s);
}

static void cleanMeUp_appendToFile() {
   AutoCloseable __3 = tempCleaningUp(); try {
  Lock __1 = appendToFile_lock; lock(__1); try {
  closeAllWriters(values(appendToFile_writers));
  appendToFile_writers.clear();
} finally { unlock(__1); } } finally { _close(__3); }}
static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}

static File javaxDataDir(String... subs) {
  return newFile(javaxDataDir(), subs);
}


static String localDateWithSeconds(long time) {
  SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
  return format.format(time);
}

static String localDateWithSeconds() {
  return localDateWithSeconds(now());
}
static List<Thread> threadInfosToThreads(List<ThreadInfo> l) {
  HashMap<Long, Thread> map = new HashMap();
  for (Thread t : keys(Thread.getAllStackTraces()))
    map.put(t.getId(), t);
  List<Thread> out = new ArrayList();
  for (ThreadInfo t : l)
    addIfNotNull(out, map.get(t.getThreadId()));
  return out;
}
static Random random_random = new Random();

static int random(int n) {
  return random(random_random, n);
}

static int random(int n, Random r) { return random(r, n); }

static int random(Random r, int n) {
  return n <= 0 ? 0 : r.nextInt(n);
}

static double random(double max) {
  return random()*max;
}

static double random() {
  return random_random.nextInt(100001)/100000.0;
}

static double random(double min, double max) {
  return min+random()*(max-min);
}

// min <= value < max
static int random(int min, int max) {
  return min+random(max-min);
}

static int random(int min, int max, Random r) {
  return random(r, min, max);
}

static int random(Random r, int min, int max) {
  return min+random(r, max-min);
}

static <A> A random(List<A> l) {
  return oneOf(l);
}

static <A> A random(Collection<A> c) {
  if (c instanceof List) return random((List<A>) c);
  int i = random(l(c));
  return collectionGet(c, i);
}


static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else if (c == '\0')
      out.append("\\0");
    else
      out.append(c);
  }
  out.append('"');
}
static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static <A> A[] makeArray(Class<A> type, int n) {
  return (A[]) Array.newInstance(type, n);
}
static Throwable getException(Runnable r) {
  try {
    callF(r);
    return null;
  } catch (Throwable e) {
    return e;
  }
}
static String className(Object o) {
  return getClassName(o);
}
static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt(String field, Object o) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) { try {
  Field f = getOpt_findField(o.getClass(), field);
  if (f == null) return null;
  makeAccessible(f);
  return f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }

// access of static fields is not yet optimized
static Object getOpt(Class c, String field) { try {
  if (c == null) return null;
  Field f = getOpt_findStaticField(c, field);
  if (f == null) return null;
  makeAccessible(f);
  return f.get(null);
} catch (Exception __e) { throw rethrow(__e); } }

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

// get purpose 1: access a list/array/map (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

// seems to conflict with other signatures
/*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o == null) return null;
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      makeAccessible(f);
      return f.get(o);
    }
      
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(String field, Object o) {
  return get_raw(o, field);
}

static Object get_raw(Object o, String field) { try {
  if (o == null) return null;
  Field f = get_findField(o.getClass(), field);
  makeAccessible(f);
  return f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    makeAccessible(f);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static Object get(String field, Object o) {
  return get(o, field);
}
static boolean endsWithIgnoreCase(String a, String b) {
  int la = l(a), lb = l(b);
  return la >= lb && regionMatchesIC(a, la-lb, b, 0, lb);
}


static boolean endsWithIgnoreCase(String a, String b, Matches m) {
  if (!endsWithIgnoreCase(a, b)) return false;
  m.m = new String[] { substring(a, 0, l(a)-l(b)) };
  return true;
}

static BufferedReader bufferedReader(Reader r) { return bufferedReader(r, 8192); }
static BufferedReader bufferedReader(Reader r, int bufSize) {
  return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
}
static <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
  class IFF2 extends CloseableIterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
    
    public void close() throws Exception {
      if (closeable != null) closeable.close();
    }
  };
  return new IFF2();
}
static String readLineFromReaderWithClose(BufferedReader r) { try {
  String s = r.readLine();
  if (s == null) r.close();
  return s;
} catch (Exception __e) { throw rethrow(__e); } }
static AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
  return c == null ? null : new AutoCloseable() { public String toString() { return "c.close();\r\n    _registerIO(c, null, false);"; } public void close() throws Exception { c.close();
    _registerIO(c, null, false);
  }};
}

static <A> A _registerIOWrap(A wrapper, Object wrapped) {
  return wrapper;
}
static FileInputStream newFileInputStream(File path) throws IOException {
  return newFileInputStream(path.getPath());
}

static FileInputStream newFileInputStream(String path) throws IOException {
  FileInputStream f = new FileInputStream(path);
  _registerIO(f, path, true);
  return f;
}
static int gzInputStream_defaultBufferSize = 65536;

static GZIPInputStream gzInputStream(File f) { try {
  return gzInputStream(new FileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(File f, int bufferSize) { try {
  return gzInputStream(new FileInputStream(f), bufferSize);
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(InputStream in) {
  return gzInputStream(in, gzInputStream_defaultBufferSize);
}

static GZIPInputStream gzInputStream(InputStream in, int bufferSize) { try {
  return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
} catch (Exception __e) { throw rethrow(__e); } }


static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}

static int lastIndexOf(String a, char b) {
  return a == null ? -1 : a.lastIndexOf(b);
}

// starts searching from i-1
static <A> int lastIndexOf(List<A> l, int i, A a) {
  if (l == null) return -1;
  for (i = min(l(l), i)-1; i >= 0; i--)
    if (eq(l.get(i), a))
      return i;
  return -1;
}
static long usedMemory() {
  return Runtime.getRuntime().totalMemory()-Runtime.getRuntime().freeMemory();
}
static void vmBus_send(String msg, Object... args) {
  Object arg = vmBus_wrapArgs(args);
  pcallFAll(vm_busListeners_live(), msg, arg);
  pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
}

static void vmBus_send(String msg) {
  vmBus_send(msg, (Object) null);
}
static String asciiHeading2(String title) {
  return asciiHeading(title) + "\n";
}
static Map<ThreadInfo, Thread> threadInfosToThreads_map(List<ThreadInfo> l) {
  HashMap<Long, Thread> map = new HashMap();
  for (Thread t : keys(Thread.getAllStackTraces()))
    map.put(t.getId(), t);
  HashMap<ThreadInfo, Thread> out = new HashMap();
  for (ThreadInfo t : l)
    mapPut(out, t, map.get(t.getThreadId()));
  return out;
}
static String indentx(String s) {
  return indentx(indent_default, s);
}

static String indentx(int n, String s) {
  return dropSuffix(repeat(' ', n), indent(n, s));
}

static String indentx(String indent, String s) {
  return dropSuffix(indent, indent(indent, s));
}
static String stackTraceToString(StackTraceElement[] st) {
  return lines(st);
}

static String stackTraceToString(Throwable e) {
  return getStackTrace_noRecord(e);
}
static String lines(Iterable lines) { return fromLines(lines); }
static String lines(Object[] lines) { return fromLines(asList(lines)); }
static List<String> lines(String s) { return toLines(s); }
static String getCanonicalPath(File f) { try {
  return f == null ? null : f.getCanonicalPath();
} catch (Exception __e) { throw rethrow(__e); } }

static String getCanonicalPath(String path) {
  return getCanonicalPath(newFile(path));
}
static AutoCloseable tempCleaningUp() {
  
  
  return null;
  
}
static void closeAllWriters(Collection<? extends Writer> l) {
  for (Writer w : unnull(l)) { try {
    w.close();
  } catch (Throwable __e) { _handleException(__e); }}
}
static String _userHome;
static String userHome() {
  if (_userHome == null)
    return actualUserHome();
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}


static SimpleDateFormat simpleDateFormat_local(String format) {
  SimpleDateFormat sdf = new SimpleDateFormat(format);
  sdf.setTimeZone(localTimeZone());
  return sdf;
}
static <A, B> Set<A> keys(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

// convenience shortcut for keys_gen
static Set keys(Object map) {
  return keys((Map) map);
}






  static <A, B> Set<A> keys(MultiSetMap<A, B> mm) {
    return mm.keySet();
  }



static <A> boolean addIfNotNull(Collection<A> l, A a) {
  return a != null && l != null & l.add(a);
}


static <A> A oneOf(List<A> l) {
  return empty(l) ? null : l.get(new Random().nextInt(l.size()));
}

static char oneOf(String s) {
  return empty(s) ? '?' : s.charAt(random(l(s)));
}

static String oneOf(String... l) {
  return oneOf(asList(l));
}
static <A> A collectionGet(Collection<A> c, int idx) {
  if (c == null || idx < 0 || idx >= l(c)) return null;
  if (c instanceof List) return listGet((List<A>) c, idx);
  Iterator<A> it = c.iterator();
  for (int i = 0; i < idx; i++) if (it.hasNext()) it.next(); else return null;
  return it.hasNext() ? it.next() : null;
}
//static final Map<Class, HashMap<S, Field>> getOpt_cache = newDangerousWeakHashMap(f getOpt_special_init);

static class getOpt_Map extends WeakHashMap {
  getOpt_Map() {
    if (getOpt_special == null) getOpt_special = new HashMap();
    clear();
  }
  
  public void clear() {
    super.clear();
    //print("getOpt clear");
    put(Class.class, getOpt_special);
    put(String.class, getOpt_special);
  }
}

static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));
//static final Map<Class, HashMap<S, Field>> getOpt_cache = _registerWeakMap(synchroMap(new getOpt_Map));
static HashMap getOpt_special; // just a marker

/*static void getOpt_special_init(Map map) {
  map.put(Class.class, getOpt_special);
  map.put(S.class, getOpt_special);
}*/

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    if (!reflection_classesNotToScan().contains(c.getName())) {
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) {
          makeAccessible(f);
          String name = f.getName();
          if (!map.containsKey(name))
            map.put(name, f);
        }
        _c = _c.getSuperclass();
      } while (_c != null);
    }
  }
  if (getOpt_cache != null) getOpt_cache.put(c, map);
  return map;
}
static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
  
  
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  
}
static void _registerIO(Object object, String path, boolean opened) {
}


static Object vmBus_wrapArgs(Object... args) {
  return empty(args) ? null
    : l(args) == 1 ? args[0]
    : args;
}
static Set vm_busListeners_live_cache;
static Set vm_busListeners_live() { if (vm_busListeners_live_cache == null) vm_busListeners_live_cache = vm_busListeners_live_load(); return vm_busListeners_live_cache; }

static Set vm_busListeners_live_load() {
  return vm_generalIdentityHashSet("busListeners");
}
static Map<String, Set> vm_busListenersByMessage_live_cache;
static Map<String, Set> vm_busListenersByMessage_live() { if (vm_busListenersByMessage_live_cache == null) vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load(); return vm_busListenersByMessage_live_cache; }

static Map<String, Set> vm_busListenersByMessage_live_load() {
  return vm_generalHashMap("busListenersByMessage");
}
static String asciiHeading(String title) {
  return "\n" + title + "\n" + rep(l(title), '-');
}
static <A, B> void mapPut(Map<A, B> map, A key, B value) {
  if (map != null && key != null && value != null) map.put(key, value);
}


static <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
  if (map != null && p != null) map.put(p.a, p.b);
}

static String dropSuffix(String suffix, String s) {
  return s.endsWith(suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  n = Math.max(n, 0);
  List<A> l = new ArrayList(n);
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}
static int indent_default = 2;

static String indent(int indent) {
  return repeat(' ', indent);
}

static String indent(int indent, String s) {
  return indent(repeat(' ', indent), s);
}

static String indent(String indent, String s) {
  return indent + s.replace("\n", "\n" + indent);
}

static String indent(String s) {
  return indent(indent_default, s);
}

static List<String> indent(String indent, List<String> lines) {
  List<String> l = new ArrayList();
  if (lines != null) for (String s : lines)
    l.add(indent + s);
  return l;
}
static String actualUserHome_value;
static String actualUserHome() {
  if (actualUserHome_value == null) {
    if (isAndroid())
      actualUserHome_value = "/storage/emulated/0/";
    else
      actualUserHome_value = System.getProperty("user.home");
  }
  return actualUserHome_value;
}

static File actualUserHome(String sub) {
  return newFile(new File(actualUserHome()), sub);
}
static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}
static TimeZone localTimeZone() {
  return getTimeZone(standardTimeZone());
  // TimeZone.getDefault()?
}
static <A> A listGet(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}
static void clear(Collection c) {
  if (c != null) c.clear();
}

static void clear(Map map) {
  if (map != null) map.clear();
}
static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}

static <A> void put(List<A> l, int i, A a) {
  if (l != null && i >= 0 && i < l(l)) l.set(i, a);
}
static <A, B> B mapGet2(Map<A, B> map, A a) {
  return map == null ? null : map.get(a);
}

static <A, B> B mapGet2(A a, Map<A, B> map) {
  return map == null ? null : map.get(a);
}
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}
static Set<String> reflection_classesNotToScan_value = litset(
  "jdk.internal.loader.URLClassPath"
);

static Set<String> reflection_classesNotToScan() {
  return reflection_classesNotToScan_value;
}


static Set vm_generalIdentityHashSet(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Set set =  (Set) (vm_generalMap_get(name));
    if (set == null)
      vm_generalMap_put(name, set = syncIdentityHashSet());
    return set;
  }
}

static Map vm_generalHashMap(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Map m =  (Map) (vm_generalMap_get(name));
    if (m == null)
      vm_generalMap_put(name, m = syncHashMap());
    return m;
  }
}

static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}

static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}



static TimeZone getTimeZone(String name) {
  return TimeZone.getTimeZone(name);
}
static String standardTimeZone_name = "Europe/Berlin";

static String standardTimeZone() {
  return standardTimeZone_name;
}
static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}


static Object vm_generalMap_get(Object key) {
  return vm_generalMap().get(key);
}
static Object vm_generalMap_put(Object key, Object value) {
  return mapPutOrRemove(vm_generalMap(), key, value);
}
static <A> Set<A> syncIdentityHashSet() {
  return (Set) synchronizedSet(identityHashSet());
}
static Map syncHashMap() {
  return synchroHashMap();
}
static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}


static Map vm_generalMap_map;

static Map vm_generalMap() {
  if (vm_generalMap_map == null)
    vm_generalMap_map = (Map) get(javax(), "generalMap");
  return vm_generalMap_map;
}
static <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
  if (map != null && key != null)
    if (value != null) return map.put(key, value);
    else return map.remove(key);
  return null;
}
static <A> Set<A> synchronizedSet() {
  return synchroHashSet();
}

static <A> Set<A> synchronizedSet(Set<A> set) {
  return Collections.synchronizedSet(set);
}
static <A> Set<A> identityHashSet() {
  return Collections.newSetFromMap(new IdentityHashMap());
}


static <A> Set<A> synchroHashSet() {
  return Collections.synchronizedSet(new HashSet<A>());
}



// immutable, has strong refs
final static class _MethodCache {
  final Class c;
  final HashMap<String, List<Method>> cache = new HashMap();
  
  _MethodCache(Class c) {
  this.c = c; _init(); }
  
  void _init() {
    Class _c = c;
    while (_c != null) {
      for (Method m : _c.getDeclaredMethods())
        if (!isAbstract(m) && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
      _c = _c.getSuperclass();
    }
    
    // add default methods - this might lead to a duplication
    // because the overridden method is also added, but it's not
    // a problem except for minimal performance loss.
    for (Class intf : allInterfacesImplementedBy(c))
      for (Method m : intf.getDeclaredMethods())
        if (m.isDefault() && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));

    
  }
  
  // Returns only matching methods
  Method findMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
    
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Method findStaticMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (isStaticMethod(me) && call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
}static abstract class VF1<A> implements IVF1<A> {
  public abstract void get(A a);
}static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
  
  public String toString() { return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")"; }
  
  public int hashCode() { return _hashCode(toList(m)); }
  public boolean equals(Object o) { return o instanceof Matches && arraysEqual(m, ((Matches) o).m); }
}
static class LineCompReader {
  List<String> literals = new ArrayList();
  IVF1<Long> onPair; // if not null, don't save pairs, but stream them to onPair instead
  int[] literalOffsets; // where they start in file
  LongBuffer pairs = new LongBuffer();
  LinkedHashMap<String, List<Integer>> versions = new LinkedHashMap();
  boolean byteMode = false;
  
  LineCompReader() {}
  
  // takes text or gzipped input file
  LineCompReader(File f) { load(f); }
  
  LineCompReader(InputStream in) { load(rawByteReader(in, 128*1024)); }
  LineCompReader(BufferedReader reader) { load(reader); }
  
  void load(File f) {
     BufferedReader reader = rawByteReader_possiblyGZipped(f); try {
    load(reader);
  } finally { _close(reader); }}
  
  void load(BufferedReader reader) { try {
    String s = readLineIgnoreCR(reader);
    int ofs = l(s)+1;
    Matches m = new Matches();
    if (startsWith(s, "BYTECOMP ", m)) byteMode = true;
    else if (!startsWith(s, "LINECOMP ", m))
      throw fail("Not a LINECOMP file");
    int nLiterals = parseInt(m.rest());
    IntBuffer offsets = new IntBuffer();
    for (int i = 0; i < nLiterals; i++) {
      String line = readLineIgnoreCR(reader);
      assertNotNull(line);
      literals.add(byteMode ? str(charFromHex(line)) : line);
      offsets.add(ofs);
      ofs += l(line)+1;
    }
    offsets.add(ofs);
    literalOffsets = offsets.toArray();
    int n = 0;
    while (licensed()) {
      s = readLineIgnoreCR(reader);
      if (s == null || contains(s, "=")) break;
      try {
        int iSpace = s.indexOf(' ');
        long pair = twoIntsToLong(parseInt(takeFirst(s, iSpace)), parseInt(substring(s, iSpace+1)));
        if (onPair != null) onPair.get(pair);
        else pairs.add(pair);
        if (((++n) % oneMillion()) == 0) print(nPairs(n) + " read");
      } catch (Throwable _e) {
        print("On line " + (nLiterals + l(pairs)));
      
throw rethrow(_e); }
    }
    pairs.trimToSize();
    while (contains(s, "=")) {
      int i = indexOf(s, '=');
      versions.put(takeFirst(s, i), compactIntList(parseInts(splitAtSpace(substring(s, i+1)))));
      s = readLineIgnoreCR(reader);
    }
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Set<String> versions() { return keys(versions); }
  
  String getText(String version) { return textForVersion(version); }
  String textForVersion(String version) {
    List<Integer> encoded = versions.get(version);
    if (encoded == null) return null;
    List<String> buf = new ArrayList();
    for (int idx : encoded)
      decode(idx, buf);
    return myFromLines(buf);
  }
  
  // name of first (or only) file
  String firstFile() { return first(versions()); }
  
  // text for first (or only) file
  String text() { return getText(firstFile()); }
  
  List<Integer> encoding() { return versions.get(firstFile()); }
  
  String myFromLines(List<String> l) {
    return byteMode
      ? join(l)
      : fromLines_rtrim(l);
  }
  
  void decode(int idx, List<String> buf) {
    if (idx < l(literals))
      buf.add(literals.get(idx));
    else {
      long p = pairs.get(idx-l(literals));
      decode(firstIntFromLong(p), buf);
      decode(secondIntFromLong(p), buf);
    }
  }
  
  // That was it! The rest of this file is just for calculating some stats.
  
  Map<Integer, Integer> lineCountsForPairs = new HashMap();
  Map<Integer, Long> byteCountsForPairs = new HashMap();

  int lineCountForPointer(int idx) {
    return idx < l(literals) ? 1 : lineCountForPair(idx);
  }
  
  long byteCountForPointer(int idx) {
    return idx < l(literals) ? l(literals.get(idx))+1 : byteCountForPair(idx);
  }
  
  int lineCountForPair(int idx) {
    Integer c = lineCountsForPairs.get(idx);
    if (c == null) {
      long p = pairs.get(idx-l(literals));
      c = lineCountForPointer(firstIntFromLong(p)) + lineCountForPointer(secondIntFromLong(p));
      lineCountsForPairs.put(idx, c);
    }
    return c;
  }
  
  long byteCountForPair(int idx) {
    Long c = byteCountsForPairs.get(idx);
    if (c == null) {
      long p = pairs.get(idx-l(literals));
      c = byteCountForPointer(firstIntFromLong(p)) + byteCountForPointer(secondIntFromLong(p));
      byteCountsForPairs.put(idx, c);
    }
    return c;
  }
  
  int lineCountForVersion(String version) {
    List<Integer> encoded = versions.get(version);
    if (encoded == null) return 0;
    int n = 0;
    for (int i : encoded) n += lineCountForPointer(i);
    return n;
  }
  
  long byteCountForVersion(String version) {
    List<Integer> encoded = versions.get(version);
    if (encoded == null) return 0;
    long n = 0;
    for (int i : encoded) n += byteCountForPointer(i);
    return max(0, n-1);
  }
  
  long totalByteCount() {
    return longSum(lambdaMap(__32 -> byteCountForVersion(__32),versions()));
  }
  
  // now we can also save again
  
  void save(PrintWriter out) {
    out.println((byteMode ? "BYTECOMP " : "LINECOMP ") + l(literals));
    for (String s : literals)
      out.println(byteMode ? charToHex(first(s)) : s);
    for (long p : pairs)
      out.println(firstIntFromLong(p) + " " + secondIntFromLong(p));
    for (String id : keys( versions))
      { List<Integer> l = versions.get(id);  out.println(id + "=" + joinWithSpace(l)); }
  }  
}static abstract class F0<A> {
  abstract A get();
}static abstract class F1<A, B> {
  abstract B get(A a);
}// you still need to implement hasNext() and next()
static abstract class IterableIterator<A> implements Iterator<A>, Iterable<A> {
  public Iterator<A> iterator() {
    return this;
  }
  
  public void remove() {
    unsupportedOperation();
  }
}static abstract class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {
  public void close() throws Exception {}
}static interface IFieldsToList {
  Object[] _fieldsToList();
}static class PersistableThrowable {
  String className;
  String msg;
  String stacktrace;
  
  PersistableThrowable() {}
  PersistableThrowable(Throwable e) {
    if (e == null)
      className = "Crazy Null Error";
    else {
      className = getClassName(e).replace('/', '.');
      msg = e.getMessage();
      stacktrace = getStackTrace_noRecord(e);
    }
  }
  
  public String toString() {
    return nempty(msg) ? className + ": " + msg : className;
  }
}// This is using the implementation that seems to work fastest
// in reality, although it probably is O(n log n) due to the use
// of TreeMaps.
//
// The theoretically best implementation is O(n) (replacing the
// TreeMap with a linked list).











final static class LineCompCompressor {
  int safety = 0;
  
  

  abstract static class Chunk {
    abstract String text(List<Chunk> chunks);
    IntPair getPair() { return null; }
  }
  
  static class CPair extends Chunk implements IFieldsToList{
  int i1;
  int i2;
  CPair() {}
  CPair(int i1, int i2) {
  this.i2 = i2;
  this.i1 = i1;}
  public String toString() { return shortClassName(this) + "(" + i1 + ", " + i2 + ")"; }

public boolean equals(Object o) {
if (!(o instanceof CPair)) return false;
    CPair __1 =  (CPair) o;
    return i1 == __1.i1 && i2 == __1.i2;
}

  public int hashCode() {
    int h = 64355773;
    h = boostHashCombine(h, _hashCode(i1));
    h = boostHashCombine(h, _hashCode(i2));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {i1, i2}; }

    CPair(IntPair p) { i1 = p.a; i2 = p.b; }
    
    String text(List<Chunk> chunks) {
      return linesLL_rtrim(chunks.get(i1).text(chunks), chunks.get(i2).text(chunks));
    }
    
    IntPair getPair() {
      return new IntPair(i1, i2);
    }
  }
  
  static class CPrim extends Chunk implements IFieldsToList{
  String s;
  CPrim() {}
  CPrim(String s) {
  this.s = s;}
  public String toString() { return shortClassName(this) + "(" + s + ")"; }

public boolean equals(Object o) {
if (!(o instanceof CPrim)) return false;
    CPrim __2 =  (CPrim) o;
    return eq(s, __2.s);
}

  public int hashCode() {
    int h = 64372105;
    h = boostHashCombine(h, _hashCode(s));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {s}; }

    String text(List<Chunk> chunks) { return s; }
  }

  boolean verbose = false, verboseCompressionSteps = false;
  boolean verboseStats = false;
  boolean sortLines = true;
  boolean verify = true;
  boolean byteMode = false; // compress bytes instead of lines
  boolean caseInsensitive = false; // for line mode
  boolean toUpper = false; // for byte mode: convert all characters to upper case
  boolean recordPairLengths = false; // for "balanced" compression
  boolean balancing = false; // try to lower tree heights by compressing "shorter" pairs first
  boolean fullCompression = false; // keep compressing until every file is a single symbol

  LineComp_PairIndex pairIndex = new LineComp_PairIndex();
  Map<String, List<String>> textIDToLines;
  List<String> allUniqueLines;
  List<Chunk> chunks = new ArrayList();
  int primChunks;
  Map<String, Integer> lineIndex;
  Map<String, List<Integer>> simpleEncodings; // temporary
  Map<String, List<Integer>> finalEncodings;
  LongIntHashMap existingPairsIndex = new LongIntHashMap(); // formerly Map<IntPair, Int>
  int round, printStatsEvery = /*10000*/0, printStatsInFirstRounds = 10;
  int printStatsEveryNSeconds = /*10*/60; // 60 for slower computers
  
  // initializing fullIndex = new Map will make things slow and use a lot of memory
  // and I thought there might be a case where it improves the compression
  // - but maybe there isn't?
  Map<String, Integer> fullIndex; 
  SimpleIntList pairLengths;

  LineCompCompressor() {}
  LineCompCompressor(Map<String, String> texts) { loadTexts(texts); }
  
  // key = version ID, values = text
  void loadTexts(Map<String, String> texts) {
    textIDToLines = mapValuesToLinkedHashMap(__33 -> myToLines(__33),texts);
  }
  
  List<String> myToLines(String s) {
    List<String> l = byteMode
      ? lambdaMap(__34 -> charToHex(__34),characters(toUpper ? upper(s) : s))
      : toLines_nOnly_reversible(s);
    return l;
  }
      
  String myFromLines(List<String> l) {
    return byteMode
      ? join(mapI("hexToChar",l)) // TODO: optimize even more
      : fromLines_rtrim(l);
  }
  
  public void run() {
    if (balancing) {
      recordPairLengths = true;
      pairIndex.pairComparatorForBalancing = (p1, p2) -> {
        int l1 = pairLength(p1), l2 = pairLength(p2);
        if (l1 != l2) return l1-l2;
        // return arbitrary order, but not 0
        if (p1.a != p2.a) return p1.a-p2.a;
        return p1.b-p2.b;
      };
    }
      
    if (recordPairLengths) pairLengths = new SimpleIntList();
    List<String> allLines = concatLists(values(textIDToLines));
    if (verboseCompressionSteps) print("Uniquifying " + nLines(allLines));
    allUniqueLines = uniquify(allLines);
    if (verboseCompressionSteps) print("Have " + n2(allUniqueLines, "unique line"));
    allLines = null; // allow me to forget
    if (sortLines) sortInPlace(allUniqueLines);
    if (verboseCompressionSteps) print("Sorted " + nLines(allUniqueLines));
    for (String line : allUniqueLines)
      chunks.add(new CPrim(line));
    primChunks = l(chunks);
    List<String> _lines = collect("s",chunks);
    lineIndex = caseInsensitive ? ciListIndex(_lines) : listIndex(_lines);
    _lines = null;
    
    // simple encoding (only direct line references)
    simpleEncodings = mapValues(textIDToLines,
      (IF1<List<String>, List<Integer>>) (lines -> wrapIntArrayAsImmutableList(mapToIntArray(lines, line -> lineIndex.get(line)))));
    //printAndCheckEncodings(simpleEncodings);
    if (verboseCompressionSteps) print("Have simple encodings");
    
    finalEncodings = compressPairs();
    if (verbose || verify) printAndCheckEncodings(finalEncodings);
  }
  
  void saveAsTextFile(File f) {
    String out = exportEncoding(finalEncodings);
    saveTextFile(f, out);
    
    if (verify) checkDecompression(f, textIDToLines);
  }
  
  void checkDecompression(File file, Map<String, List<String>> textIDToLines) {
     BufferedReader reader = bufferedUtf8Reader(file); try {
    LineCompReader lcr = new LineCompReader(reader);
    assertEquals(keysList(textIDToLines), asList(lcr.versions()));
    for (String version : keys(textIDToLines))
      assertEquals(lcr.textForVersion(version), lines_rtrim(textIDToLines.get(version)));
    if (verbose) print("Decompression OK for " + nVersions(textIDToLines));
  } finally { _close(reader); }}
  
  String asText() { return exportEncoding(finalEncodings); }
  
  String exportEncoding(Map<String, List<Integer>> encodings) {
    List<String> buf = new ArrayList();
    buf.add((byteMode ? "BYTECOMP " : "LINECOMP ") + primChunks); // magic signature
    for (Chunk c : chunks) {
      if (c instanceof CPair)
        buf.add(((CPair) c).i1 + " " + ((CPair) c).i2);
      else
        buf.add(((CPrim) c).s);
    }
    for (String id : keys( encodings))
      { List<Integer> l = encodings.get(id);  buf.add(id + "=" + joinWithSpace(l)); }
    return lines_rtrim(buf);
  }
  
  Map<String, List<Integer>> compressPairs() {
    pairIndex.verbose = verboseCompressionSteps || verbose;
    pairIndex.init();
    for (String version : keys( simpleEncodings))
      { List<Integer> l = simpleEncodings.get(version);  pairIndex.newChain(version, l); }
    pairIndex.haveChains();
    simpleEncodings = null; // forget

    return compressChains(keys(pairIndex.chains));
  }
  
  Map<String, List<Integer>> compressChains(Collection<String> files) {
    NotTooOften nto = new NotTooOften(printStatsEveryNSeconds*1000);
    IntPair toCompress;
    // Compress only most popular pair in one step
    while  ((toCompress = fullCompression
      ? pairIndex.mostPopularPair()
      : pairIndex.mostPopularDuplicate()) != null) { ping(); 
      if (verbose) {
        print("Chains: " + mapValuesToList(pairIndex.chains, c -> c.toList()));
        //print("Highest bucket (" + pairIndex.highestBucketNr() + "): " + pairIndex.mostPopularDuplicates());
        print("Buckets: " + pairIndex.byCount);
      }

      if (safety > 0 && --safety <= 0) throw fail("safety");
      ++round;
      if (verboseStats)
        if (printStatsEvery > 0 && (round % printStatsEvery) == 0
          || round <= printStatsInFirstRounds
          || nto.get())
          printStats();
      int count = pairIndex.getCount(toCompress);
      Integer idx = makeCPair(toCompress);
      int dups = pairIndex.numberOfDuplicates();
      if (verboseCompressionSteps) print("Compressing pair " + toCompress + " (count=" + count + ") -> " + idx + ", " + (dups-1) + " remaining");
      pairIndex.replacePair(toCompress.a, toCompress.b, idx);
    }
    if (verboseStats) printStats();
    
    // reconvert to normal list
    return mapToValues(f -> pairIndex.chains.get(f).toList(), files);
  }
  
  // TODO: check if pair is already there
  Integer makeCPair(IntPair p) {
    long l = intPairToLong(p);
    String text = null;
    if (fullIndex != null) {
      text = itemToString(p.a) + itemToString(p.b);
      Integer idx = fullIndex.get(text);
      if (idx != null) return idx;
    }
    int idx = existingPairsIndex.getIfAbsent(l, -1);
    if (idx < 0) {
      idx = addAndReturnIndex(chunks, new CPair(p));
      if (recordPairLengths) listPut(pairLengths, idx, itemLength(p.a) + itemLength(p.b), 1);
      existingPairsIndex.put(l, idx);
      if (fullIndex != null)
        fullIndex.put(text, idx);
    }
    return idx;
  }
  
  void printAndCheckEncodings(Map<String, List<Integer>> encodings) {
    for (String id : keys( encodings)) { List<Integer> encoded = encodings.get(id); 
      if (verbose) print(id + ": " + joinWithSpace(encoded));
      String x = myFromLines(textIDToLines.get(id)), y = decode(encoded);
      if (caseInsensitive)
        assertEqualsIC(x, y);
      else
        assertEquals_quote(x, y);
    }
  }
  
  String decode(List<Integer> encoded) {
    List<String> l = lambdaMap(__35 -> chunkText(__35),encoded);
    if (byteMode) l = lines(lines(l));
    return myFromLines(l);
  }
  
  // for non-byte mode
  String chunkText(int idx) {
    return chunks.get(idx).text(chunks);
  }
  
  void printStats() {
    print("Round: " + round);
    pairIndex.printStats();
  }
  
  // byteMode only
  String itemToString(int idx) {
    StringBuilder buf = new StringBuilder();
    itemToString_step(buf, idx);
    return str(buf);
  }
  
  void itemToString_step(StringBuilder buf, int idx) {
    Chunk c = chunks.get(idx);
    if (c instanceof CPair) {
      itemToString_step(buf, ((CPair) c).i1);
      itemToString_step(buf, ((CPair) c).i2);
    } else {
      String s = ((CPrim) c).s;
      buf.append(byteMode ? charFromHex(s) : s + "\n");
    }
  }
  
  int nLiterals() { return primChunks; }
  int nItems() { return l(chunks); }
  
  IntPair getPair(int idx) {
    return chunks.get(idx).getPair();
  }
  
  int itemLength(int idx) {
    return idx >= l(pairLengths) ? 1 : pairLengths.get(idx);
  }
  
  int pairLength(IntPair p) {
    return p == null ? 0 : itemLength(p.a) + itemLength(p.b);
  }
}static class FixedRateTimer extends java.util.Timer {
  FixedRateTimer() { this(false); }
  FixedRateTimer(boolean daemon) { this(defaultTimerName(), daemon); }
  FixedRateTimer(String name) { this(name, false); }
  FixedRateTimer(String name, boolean daemon) {
    super(name, daemon);
    _registerTimer(this);
  }
  
  List<Entry> entries = synchroList();
  
  static class Entry implements IFieldsToList{
  TimerTask task;
  long firstTime;
  long period;
  Entry() {}
  Entry(TimerTask task, long firstTime, long period) {
  this.period = period;
  this.firstTime = firstTime;
  this.task = task;}
  public String toString() { return shortClassName(this) + "(" + task + ", " + firstTime + ", " + period + ")"; }public Object[] _fieldsToList() { return new Object[] {task, firstTime, period}; }
}
  
  // Note: not all methods overridden; only use these ones
  
  public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
    entries.add(new Entry(task, now()+delay, period));
    super.scheduleAtFixedRate(task, delay, period);
  }
  
  public void cancel() {
    entries.clear();
    super.cancel();
  }
  
  public int purge() {
    entries.clear();
    return super.purge();
  }
  
  FixedRateTimer changeRate(int newPeriod) {
    Object r = ((SmartTimerTask) first(entries).task).r;
    cancel();
    return doEvery(newPeriod, r);
  }
}static class Pair<A, B> implements Comparable<Pair<A, B>> {
  A a;
  B b;

  Pair() {}
  Pair(A a, B b) {
  this.b = b;
  this.a = a;}
  
  public int hashCode() {
    return hashCodeFor(a) + 2*hashCodeFor(b);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof Pair)) return false;
    Pair t = (Pair) o;
    return eq(a, t.a) && eq(b, t.b);
  }
  
  public String toString() {
    return "<" + a + ", " + b + ">";
  }
  
  public int compareTo(Pair<A, B> p) {
    if (p == null) return 1;
    int i = ((Comparable<A>) a).compareTo(p.a);
    if (i != 0) return i;
    return ((Comparable<B>) b).compareTo(p.b);
  }
}

static class LongBuffer implements Iterable<Long> {
  long[] data;
  int size;
  
  LongBuffer() {}
  LongBuffer(int size) { if (size != 0) data = new long[size]; }
  LongBuffer(Iterable<Long> l) { this(l(l)); addAll(l); }
  
  void add(long i) {
    if (size >= lLongArray(data))
      data = resizeLongArray(data, Math.max(1, lLongArray(data)*2));
    data[size++] = i;
  }
  
  void addAll(Iterable<Long> l) {
    if (l != null) for (long i : l) add(i);
  }
  
  long[] toArray() {
    return size == 0 ? null : resizeLongArray(data, size);
  }
  
  List<Long> toList() {
    return longArrayToList(data, 0, size);
  }
  
  List<Long> asVirtualList() {
    return listFromFunction(__36 -> get(__36),size);
  }
  
  void reset() { size = 0; }
  void clear() { reset(); }
  
  int size() { return size; }
  boolean isEmpty() { return size == 0; }
  
  long get(int idx) {
    if (idx >= size) throw fail("Index out of range: " + idx + "/" + size);
    return data[idx];
  }
  
  void set(int idx, long value) {
    if (idx >= size) throw fail("Index out of range: " + idx + "/" + size);
    data[idx] = value;
  }
  
  long popLast() {
    if (size == 0) throw fail("empty buffer");
    return data[--size];
  }
  
  long last() { return data[size-1]; }
  long nextToLast() { return data[size-2]; }
  
  public String toString() { return squareBracket(joinWithSpace(toList())); }
  
  public Iterator<Long> iterator() {
    return new IterableIterator<Long>() {
      int i = 0;
      
      public boolean hasNext() { return i < size; }
      public Long next() {
        if (!hasNext()) throw fail("Index out of bounds: " + i);
        return data[i++];
      }
    };
  }
  
  void trimToSize() {
    data = resizeLongArray(data, size);
  }
}static interface IF1<A, B> {
  B get(A a);
}static class IntBuffer implements Iterable<Integer> {
  int[] data;
  int size;
  
  IntBuffer() {}
  IntBuffer(int size) { if (size != 0) data = new int[size]; }
  IntBuffer(Iterable<Integer> l) { this(l(l)); addAll(l); }
  
  void add(int i) {
    if (size >= lIntArray(data))
      data = resizeIntArray(data, Math.max(1, lIntArray(data)*2));
    data[size++] = i;
  }
  
  void addAll(Iterable<Integer> l) {
    if (l != null) for (int i : l) add(i);
  }
  
  int[] toArray() {
    return size == 0 ? null : resizeIntArray(data, size);
  }
  
  List<Integer> toList() {
    return intArrayToList(data, 0, size);
  }

  List<Integer> asVirtualList() {
    return new RandomAccessAbstractList<Integer>() {
      public int size() { return size; }
      public Integer get(int i) { return IntBuffer.this.get(i); }
      public Integer set(int i, Integer val) {
        Integer a = get(i);
        data[i] = val;
        return a;
      }
    };
  }
  
  void reset() { size = 0; }
  void clear() { reset(); }
  
  int size() { return size; }
  boolean isEmpty() { return size == 0; }
  
  int get(int idx) {
    if (idx >= size) throw fail("Index out of range: " + idx + "/" + size);
    return data[idx];
  }
  
  void set(int idx, int value) {
    if (idx >= size) throw fail("Index out of range: " + idx + "/" + size);
    data[idx] = value;
  }
  
  int popLast() {
    if (size == 0) throw fail("empty buffer");
    return data[--size];
  }
  
  int last() { return data[size-1]; }
  int nextToLast() { return data[size-2]; }
  
  public String toString() { return squareBracket(joinWithSpace(toList())); }
  
  public Iterator<Integer> iterator() {
    return new IterableIterator<Integer>() {
      int i = 0;
      
      public boolean hasNext() { return i < size; }
      public Integer next() {
        //if (!hasNext()) fail("Index out of bounds: " + i);
        return data[i++];
      }
    };
  }
  
  public IntegerIterator integerIterator() {
    return new IntegerIterator() {
      int i = 0;
      
      public boolean hasNext() { return i < size; }
      public int next() {
        //if (!hasNext()) fail("Index out of bounds: " + i);
        return data[i++];
      }
      public String toString() { return "Iterator@" + i + " over " + IntBuffer.this; }
    };
  }
  
  void trimToSize() {
    data = resizeIntArray(data, size);
  }
}


final static class LineComp_PairIndex {
  boolean verbose = false;
  boolean inOrder = true;
  //MultiSetMap<IntPair, Node> nodes;
  LongObjectHashMap<LinkedHashSet<Node>> nodes = new LongObjectHashMap();
  MultiSetMap<Integer, IntPair> byCount // values are pairs
    = null; // init later
    //= multiSetMap_innerHashSet_outerRevTreeMap(); // makes a difference in selecting a pair if there are multiple with the same count
    // = multiSetMap_innerCompactHashSet_outerRevTreeMap(); // same but more compact
    //= multiSetMap_innerTreeSet_outerRevTreeMap(); // initial version that kind of pointlessly sorts the same-count nodes lexicographically
  LinkedHashMap<String, Ch> chains = new LinkedHashMap();
  Ch firstChain;
  int totalPairCount;
  int initialNodesSetCapacity = 1;
  List<IVF1<Node>> onAddingPair, onRemovingPair;
  LongIntHashMap existingPairsIndex;
  
  // This queue checks all newly made pairs to see if they already
  // have a symbol.
  LinkedList<Node> compressionQueue = new LinkedList();
  
  Comparator<IntPair> pairComparatorForBalancing;

  void init() {
    /*nodes = inOrder
      ? multiSetMap_innerLinkedHashSet_outerHashMap()
      : multiSetMap_innerHashSet_outerHashMap();*/
  }
  
  // indicate end of chain-making phase.
  // we still more chains accept after this though, I think (for late input)
  void haveChains() {
    if (byCount == null) {
      //time "Making byCount" {
        if (pairComparatorForBalancing != null)
          byCount = multiSetMap_innerCustomTreeSet_outerRevTreeMap(pairComparatorForBalancing);
        else
          byCount = multiSetMap_innerCompactHashSet_outerRevTreeMap();
        for (Set<Node> set : nodes.values()) {
          IntPair p = first(set).pair();
          int n = set.size();
          if (verbose) print("Adding node " + p + " (" + n + ")");
          byCount.put(n, p);
        }
      //}
    }
  }
  
  // a "chain" of nodes (one input file)
  static class Ch {
    Node tail;
    
    Ch(LineComp_PairIndex pi, List<Integer> l) {
      int count = 0;
      for (int i : unnull(l)) {
        add(pi, i);
        if (((++count) % oneMillion()) == 0)
          print("Added " + n2(count) + " entries to chain");
      }
    }
    
    List<Integer> toList() {
      List<Integer> l = new ArrayList();
      Node node = tail;
      while (node != null) {
        l.add(node.value);
        node = node.prev;
      }
      return reverseInPlace(l);
    }
    
    void add(LineComp_PairIndex pi, int i) {
      Node n = new Node();
      
        n.ch = this;
      
      n.value = i;
      n.prev = tail;
      if (tail != null) tail.next = n;
      tail = n;
      pi.addToIndex(n.prev);
      pi.processQueue();
    }
  }
  
  static class Node {
    
      Ch ch;
    
    int value;
    Node prev, next;
    
    int a() { return value; }
    int b() { return next == null ? -1 : next.value; }
    IntPair pair() { return next == null ? null : new IntPair(a(), b()); }
    
    public String toString() {
      return stringIf(prev != null, "<") + value +
        (next == null ? "" : next.value
         + stringIf(next.next != null, ">")); 
    }
  }
  
  IntPair nodeToPair(Node n) {
    return n == null ? null : n.pair();
  }
  
  // add node to pair index
  void addToIndex(Node n) {
    IntPair p = nodeToPair(n);
    if (p == null) return;
    callFAll(onAddingPair, n);
    int count = nodes_getSize(p);
    nodes_add(p, n);
    if (byCount != null) { // not in init phase
      if (count != 0) byCount.remove(count, p);
      byCount.put(count+1, p);
    }
    if (existingPairsIndex != null)
      compressionQueue.add(n);
  }
  
  // remove node from pair index
  void removeFromIndex(Node n) {
    IntPair p = nodeToPair(n);
    if (p == null) return;
    callFAll(onRemovingPair, n);
    int count = nodes_getSize(p);
    if (count == 0) throw fail("Can't remove pair " + p);
    nodes_remove(p, n);
    byCount.remove(count, p);
    if (--count > 0) byCount.put(count, p);
  }
  
  // return all pairs in "most popular" bucket
  Collection<IntPair> mostPopularDuplicates() {
    Integer key = firstKey(byCount);
    return toInt(key) < 2 ? null : byCount.get(key);
  }
  
  IntPair mostPopularDuplicate() {
    return toInt(firstKey(byCount)) < 2 ? null : firstValue(byCount);
  }
  
  IntPair mostPopularPair() {
    return firstValue(byCount);
  }
  
  int highestBucketNr() {
    return or0(firstKey(byCount));
  }
  
  // counts buckets actually (lower value than totalPairCount)
  int numberOfDuplicates() {
    return byCount.size()-l(byCount.get(1));
  }
  
  int getCount(IntPair p) {
    return nodes_getSize(p);
  }
  
  void replacePair(int pa, int pb, int replaceWith) {
    IntPair p = new IntPair(pa, pb);
    Set<Node> set = nodes.get(intPairToLong(p));
    if (set != null)
      for (Node n : cloneList(set)) {
        { if (n.a() != pa || n.b() != pb) continue; } // nodes might have been deleted or changed
        replacePair(n, replaceWith);
      }
  }
  
  void replacePair(Node node, int replaceWith) {
    removeFromIndex(node.prev);
    removeFromIndex(node);
    removeFromIndex(node.next);
    node.value = replaceWith;
    deleteNode(node.next);
    addToIndex(node.prev);
    addToIndex(node);
    processQueue();
  }
  
  void processQueue() {
    if (existingPairsIndex != null) {
      Node n;
      while ((n = popFirst(compressionQueue)) != null)
        checkIfPairExists(n);
    }
  }
  
  void checkIfPairExists(Node node) {
    if (existingPairsIndex == null) return;
    if (node.value < 0) return;
    IntPair pair = nodeToPair(node);
    if (pair == null) return;
    //print("Checking pair " + pair);
    int i = existingPairsIndex.getIfAbsent(intPairToLong(pair), -1);
    if (i >= 0) {
      //print("  Replacing with: " + i);
      replacePair(node, i);
    }
  }
  
  void deleteNode(Node node) {
    if (node.next != null) node.next.prev = node.prev; else getChain(node).tail = node.prev;
    if (node.prev != null) node.prev.next = node.next;
    node.value = -1; // mark invalid
  }
  
  Ch newChain(String version, List<Integer> encoding) {
    Ch ch = new Ch(this, encoding);
    chains.put(version, ch);
    
    if (firstChain == null) firstChain = ch;
    return ch;
  }
  
  int nodes_getSize(IntPair p) {
    return l(nodes.get(intPairToLong(p)));
  }
  
  void nodes_add(IntPair p, Node n) {
    ++totalPairCount;
    long l = intPairToLong(p);
    LinkedHashSet<Node> set = nodes.get(l);
    if (set == null)
      nodes.put(l, set = new LinkedHashSet(initialNodesSetCapacity));
    set.add(n);
  }
  
  void nodes_remove(IntPair p, Node n) {
    --totalPairCount;
    long l = intPairToLong(p);
    LinkedHashSet<Node> set = nodes.get(l);
    if (set == null || !set.remove(n)) throw fail("Consistency error");
    if (set.isEmpty())
      nodes.remove(l);
  }
  
  // also shrinks sets...
  void printStats() {
    print("Different pairs: " + l(nodes));
    print("Different counts: " + byCount.keysSize() + " (highest count: " + firstKey(byCount) + ")");
    long count = 0, waste = 0, newWaste = 0;
    long count1 = 0, waste1 = 0;
    
    for (HashSet set : nodes.values()) {
      count1 += set.size();
      int capacity = hashSetCapacity(set);
      waste1 += capacity-set.size();
      //if (capacity > set.size()*3) set.shrink(); // TODO
    }
     
    if (pairComparatorForBalancing == null) for (CompactHashSet set : (Collection<CompactHashSet>) (Collection) values(byCount.data)) {
      count += set.size();
      waste += set.capacity()-set.size();
      set.shrinkToFactor(0.5);
      newWaste += set.capacity()-set.size();
    }
    
    print("Nodes set count: " + count1 + ". Waste: " + waste1);
    print("Set count: " + count + ". Waste: " + waste + (waste == newWaste ? "" : " => " + newWaste));
    print("Duplicates: " + n2(totalPairCount-byCount.count(1)));
  }
  
  Ch getChain(Node node) {
    
    
      return node.ch;
    
  }
  
  /*public LineComp_PairIndex clone() {
    
  }*/
}static class NotTooOften {
  long minDelay;
  long lastTime;
  
  NotTooOften() {}
  NotTooOften(long minDelay) {
  this.minDelay = minDelay;}
  
  boolean canDoAgain_willDoIfTrue() {
    if (lastTime == 0 || now() >= lastTime+minDelay)
      { lastTime = now(); return true; }
    return false;
  }
  
  boolean yo() { return canDoAgain_willDoIfTrue(); }
  boolean get() { return canDoAgain_willDoIfTrue(); }
}static interface IVF1<A> {
  void get(A a);
}static class SimpleIntList extends RandomAccessAbstractList<Integer> {
  int[] data = EMPTY_ELEMENTDATA;
  int size;
  
  private static final int[] EMPTY_ELEMENTDATA = {};

  public void add(int i) {
    ensureCapacityInternal(size+1);
    data[size++] = i;
  }
  
  public boolean add(Integer i) {
    add((int) i);
    return true;
  }
  
  public Integer set(int i, Integer value) {
    if (i >= size) throw fail("Index out of range: " + i);
    int old = data[i];
    data[i] = value;
    return old;
  }
  
  public int size() { return size; }
  
  public Integer get(int i) {
    if (i >= 0 && i < size) return data[i];
    throw new IndexOutOfBoundsException(i + "/" + size);
  }
  
  void ensureCapacityInternal(int minCapacity) {
    if (data.length < minCapacity) grow(minCapacity);
  }
  
  private void grow(int minCapacity) {
    int oldCapacity = data.length;
    int newCapacity = oldCapacity + (oldCapacity >> 1);
    if (newCapacity - minCapacity < 0)
      newCapacity = minCapacity;
    data = Arrays.copyOf(data, newCapacity);
  }
  
  // always returns a fresh copy
  int[] toIntArray() {
    int[] a = new int[size];
    System.arraycopy(data, 0, a, 0, size);
    return a;
  }
}static final class IntPair implements Comparable<IntPair> , IFieldsToList{
  int a;
  int b;
  IntPair() {}
  IntPair(int a, int b) {
  this.b = b;
  this.a = a;}
  public String toString() { return shortClassName(this) + "(" + a + ", " + b + ")"; }public Object[] _fieldsToList() { return new Object[] {a, b}; }

  public boolean equals(Object o) {
    if (!(o instanceof IntPair)) return false;
    IntPair x =  (IntPair) o;
    return a == x.a && b == x.b;
  }

  public int hashCode() {
    int h = -672893111;
    h = boostHashCombine(h, _hashCode(a));
    h = boostHashCombine(h, _hashCode(b));
    return h;
  }
  
  public int compareTo(IntPair p) {
    if (p == null) return 1;
    int pa = p.a;
    if (a < pa) return -1;
    if (a > pa) return 1;
    return Integer.compare(b, p.b);
  }
}

// uses hash sets as inner sets unless subclassed
// uses a hash map as the outer map by default
static class MultiSetMap<A, B> {
  Map<A, Set<B>> data = new HashMap<A, Set<B>>();
  int size;
  
  MultiSetMap() {}
  MultiSetMap(boolean useTreeMap) { if (useTreeMap) data = new TreeMap(); }
  MultiSetMap(MultiSetMap<A, B> map) { putAll(map); }
  MultiSetMap(Map<A, Set<B>> data) {
  this.data = data;}

  boolean put(A key, B value) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set == null)
      data.put(key, set = _makeEmptySet());
    if (!set.add(value)) return false;
    { ++size; return true; }
  }}

  boolean add(A key, B value) { return put(key, value); }

  void addAll(A key, Collection<B> values) { synchronized(data) {
    putAll(key, values);
  }}
  
  void addAllIfNotThere(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      setPut(key, value);
  }}
  
  void setPut(A key, B value) { synchronized(data) {
    if (!containsPair(key, value))
      put(key, value);
  }}
  
  boolean containsPair(A key, B value) { synchronized(data) {
    return get(key).contains(value);
  }}
  
  void putAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      put(key, value);
  }}

  void removeAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      remove(key, value);
  }}
  
  Set<B> get(A key) { synchronized(data) {
    Set<B> set = data.get(key);
    return set == null ? Collections.<B> emptySet() : set;
  }}

  // return null if empty
  Set<B> getOpt(A key) { synchronized(data) {
    return data.get(key);
  }}

  // returns actual mutable live set
  // creates the set if not there
  Set<B> getActual(A key) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set == null)
      data.put(key, set = _makeEmptySet());
    return set;
  }}
 
  // TODO: this looks unnecessary
  void clean(A key) { synchronized(data) {
    Set<B> list = data.get(key);
    if (list != null && list.isEmpty())
      data.remove(key);
  }}

  Set<A> keySet() { synchronized(data) {
    return data.keySet();
  }}

  Set<A> keys() { synchronized(data) {
    return data.keySet();
  }}

  void remove(A key) { synchronized(data) {
    size -= l(data.get(key));
    data.remove(key);
  }}

  void remove(A key, B value) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set != null) {
      if (set.remove(value)) {
        --size;
        if (set.isEmpty())
          data.remove(key);
      }
    }
  }}

  void clear() { synchronized(data) {
    data.clear();
    size = 0;
  }}

  boolean containsKey(A key) { synchronized(data) {
    return data.containsKey(key);
  }}

  B getFirst(A key) { synchronized(data) {
    return first(get(key));
  }}
  
  void addAll(MultiSetMap<A, B> map) { putAll(map); }
  
  void putAll(MultiSetMap<A, B> map) { synchronized(data) {
    for (A key : map.keySet())
      putAll(key, map.get(key));
  }}
  
  void putAll(Map<A, B> map) { synchronized(data) {
    if (map != null) for (Map.Entry<A, B> e : map.entrySet())
      put(e.getKey(), e.getValue());
  }}
  
  int keysSize() { synchronized(data) { return l(data); }}
  
  // full size
  int size() { synchronized(data) {
    return size;
  }}
  
  // count values for key
  int getSize(A key) { return l(data.get(key)); }
  int count(A key) { return getSize(key); }
  
  // expensive operation
  Set<A> reverseGet(B b) { synchronized(data) {
    Set<A> l = new HashSet();
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        l.add(key);
    return l;
  }}
  
  Map<A, Set<B>> asMap() { synchronized(data) {
    return cloneMap(data);
  }}
  
  boolean isEmpty() { synchronized(data) { return data.isEmpty(); }}
  
  // override in subclasses
  Set<B> _makeEmptySet() {
    return new HashSet();
  }
  
  Collection<Set<B>> allLists() {
    synchronized(data) {
      return new HashSet(data.values());
    }
  }
  
  List<B> allValues() {
    return concatLists(values(data));
  }
  
  Object mutex() { return data; }
  
  public String toString() { return "mm" + str(data); }
  
  Pair<A, B> firstEntry() {
    if (empty(data)) return null;
    Map.Entry<A, Set<B>> entry = data.entrySet().iterator().next();
    return pair(entry.getKey(), first(entry.getValue()));
  }
}abstract static class IntegerIterator {
  abstract boolean hasNext();
  abstract int next();
}abstract static class RandomAccessAbstractList<A> extends AbstractList<A> implements RandomAccess {
}/*
 * #!
 * Ontopia Engine
 * #-
 * Copyright (C) 2001 - 2013 The Ontopia Project
 * #-
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * !#
 */

// modified by Stefan Reich

// Implements the Set interface more compactly than
// java.util.HashSet by using a closed hashtable. 

static class CompactHashSet<A> extends java.util.AbstractSet<A> {
  protected final static int INITIAL_SIZE = 3;
  public final static double LOAD_FACTOR = 0.75;

  protected final static Object nullObject = new Object();
  protected final static Object deletedObject = new Object();
  protected int elements;
  protected int freecells;
  protected A[] objects;
  
  
  CompactHashSet() {
    this(INITIAL_SIZE);
  }

  CompactHashSet(int size) {
    // NOTE: If array size is 0, we get a
    // "java.lang.ArithmeticException: / by zero" in add(Object).
    objects = (A[]) new Object[(size==0 ? 1 : size)];
    elements = 0;
    freecells = objects.length;
    
  }

  CompactHashSet(Collection<A> c) {
    this(c.size());
    addAll(c);
  }

  @Override
  public Iterator<A> iterator() {
    return new CompactHashIterator<A>();
  }

  @Override
  public int size() {
    return elements;
  }

  @Override
  public boolean isEmpty() {
    return elements == 0;
  }

  @Override
  public boolean contains(Object o) {
    return find(o) != null;
  }
  
  synchronized A find(Object o) {
    if (o == null) o = nullObject;
    
    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;

    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }

    return objects[index];
  }
  
  boolean removeIfSame(Object o) {
    A value = find(o);
    if (value == o) {
      remove(value);
      return true;
    }
    return false;
  }

  @Override
  synchronized public boolean add(Object o) {
    if (o == null) o = nullObject;

    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;
    int deletedix = -1;
    
    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {

      // if there's a deleted object here we can put this object here,
      // provided it's not in here somewhere else already
      if (objects[index] == deletedObject)
        deletedix = index;
      
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }
    
    if (objects[index] == null) { // wasn't present already
      if (deletedix != -1) // reusing a deleted cell
        index = deletedix;
      else
        freecells--;

      
      elements++;

      // here we face a problem regarding generics:
      // add(A o) is not possible because of the null Object. We cant do 'new A()' or '(A) new Object()'
      // so adding an empty object is a problem here
      // If (! o instanceof A) : This will cause a class cast exception
      // If (o instanceof A) : This will work fine

      objects[index] = (A) o;
      
      // do we need to rehash?
      if (1 - (freecells / (double) objects.length) > LOAD_FACTOR)
        rehash();
      return true;
    } else // was there already 
      return false;
  }
  
  @Override
  synchronized public boolean remove(Object o) {
    if (o == null) o = nullObject;
    
    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;
    
    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }

    // we found the right position, now do the removal
    if (objects[index] != null) {
      // we found the object

      // same problem here as with add
      objects[index] = (A) deletedObject;
      
      elements--;
      return true;
    } else
      // we did not find the object
      return false;
  }
  
  @Override
  synchronized public void clear() {
    elements = 0;
    for (int ix = 0; ix < objects.length; ix++)
      objects[ix] = null;
    freecells = objects.length;
    
  }

  @Override
  synchronized public Object[] toArray() {
    Object[] result = new Object[elements];
    Object[] objects = this.objects;
    int pos = 0;
    for (int i = 0; i < objects.length; i++)
      if (objects[i] != null && objects[i] != deletedObject) {
        if (objects[i] == nullObject)
          result[pos++] = null;
        else
          result[pos++] = objects[i];
      }
    // unchecked because it should only contain A
    return result;
  }

  // not sure if this needs to have generics
  @Override
  synchronized public <T> T[] toArray(T[] a) {
    int size = elements;
    if (a.length < size)
      a = (T[])java.lang.reflect.Array.newInstance(
                                 a.getClass().getComponentType(), size);
    A[] objects = this.objects;
    int pos = 0;
    for (int i = 0; i < objects.length; i++)
      if (objects[i] != null && objects[i] != deletedObject) {
        if (objects[i] == nullObject)
          a[pos++] = null;
        else
          a[pos++] = (T) objects[i];
      }
    return a;
  }
  
  protected void rehash() {
    int garbagecells = objects.length - (elements + freecells);
    if (garbagecells / (double) objects.length > 0.05)
      // rehash with same size
      rehash(objects.length);
    else
      // rehash with increased capacity
      rehash(objects.length*2 + 1);
  }
  
  protected void rehash(int newCapacity) {
    int oldCapacity = objects.length;
    @SuppressWarnings("unchecked")
    A[] newObjects = (A[]) new Object[newCapacity];

    for (int ix = 0; ix < oldCapacity; ix++) {
      Object o = objects[ix];
      if (o == null || o == deletedObject)
        continue;
      
      int hash = o.hashCode();
      int index = (hash & 0x7FFFFFFF) % newCapacity;
      int offset = 1;

      // search for the object
      while(newObjects[index] != null) { // no need to test for duplicates
        index = ((index + offset) & 0x7FFFFFFF) % newCapacity;
        offset = offset*2 + 1;

        if (offset == -1)
          offset = 2;
      }

      newObjects[index] = (A) o;
    }

    objects = newObjects;
    freecells = objects.length - elements;
  }
  
  private class CompactHashIterator<T> implements Iterator<T> {
    private int index;
    private int lastReturned = -1;

    

    @SuppressWarnings("empty-statement")
    public CompactHashIterator() {
      synchronized(CompactHashSet.this) {
        for (index = 0; index < objects.length &&
                        (objects[index] == null ||
                        objects[index] == deletedObject); index++)
          ;
        
      }
    }

    @Override
    public boolean hasNext() {
      synchronized(CompactHashSet.this) {
        return index < objects.length;
      }
    }

    @SuppressWarnings("empty-statement")
    @Override
    public T next() {
      synchronized(CompactHashSet.this) {
        /*if (modCount != expectedModCount)
          throw new ConcurrentModificationException();*/
        int length = objects.length;
        if (index >= length) {
          lastReturned = -2;
          throw new NoSuchElementException();
        }
  
        lastReturned = index;
        for (index += 1; index < length &&
                         (objects[index] == null ||
                          objects[index] == deletedObject); index++)
          ;
        if (objects[lastReturned] == nullObject)
          return null;
        else
          return (T) objects[lastReturned];
      }
    }

    @Override
    public void remove() {
      synchronized(CompactHashSet.this) {
        
        if (lastReturned == -1 || lastReturned == -2)
          throw new IllegalStateException();
        // delete object
        if (objects[lastReturned] != null && objects[lastReturned] != deletedObject) {
          objects[lastReturned] = (A) deletedObject;
          elements--;
          
        }
      }
    }
  }
  
  synchronized int capacity() { return objects.length; }
  
  // returns true if there was a shrink
  synchronized boolean shrinkToFactor(double factor) {
    if (factor > LOAD_FACTOR)
      throw fail("Shrink factor must be equal to or smaller than load factor: " + factor + " / " + LOAD_FACTOR);
    int newCapacity = max(INITIAL_SIZE, iround(size()/factor));
    if (newCapacity >= capacity()) return false;
    rehash(newCapacity);
    return true;
  }
}

static char hexToChar(String s) {
  return charFromHex(s);
}
static boolean isAbstract(Class c) {
  return (c.getModifiers() & Modifier.ABSTRACT) != 0;
}

static boolean isAbstract(Method m) {
  return (m.getModifiers() & Modifier.ABSTRACT) != 0;
}
static boolean reflection_isForbiddenMethod(Method m) {
  return m.getDeclaringClass() == Object.class
    && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
}
static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}


static Set<Class> allInterfacesImplementedBy(Class c) {
  if (c == null) return null;
  HashSet<Class> set = new HashSet();
  allInterfacesImplementedBy_find(c, set);
  return set;
}

static void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
  if (c.isInterface() && !set.add(c)) return;
  do {
    for (Class intf : c.getInterfaces())
      allInterfacesImplementedBy_find(intf, set);
  } while ((c = c.getSuperclass()) != null);
}
static Method findMethod(Object o, String method, Object... args) {
  return findMethod_cached(o, method, args);
}

static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}
static Method findStaticMethod(Class c, String method, Object... args) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (!m.getName().equals(method))
        continue;

      if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static boolean findStaticMethod_checkArgs(Method m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length)
    return false;
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
  return true;
}

static String unquote(String s) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();
    }
  }
    
  return s; // not quoted - return original
}
static List<String> quoteAll(Collection<String> l) {
  List<String> x = new ArrayList();
  for (String s : l)
    x.add(quote(s));
  return x;
}
static int _hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}
static boolean arraysEqual(Object[] a, Object[] b) {
  if (a.length != b.length) return false;
  for (int i = 0; i < a.length; i++)
    if (neq(a[i], b[i])) return false;
  return true;
}
static BufferedReader rawByteReader(InputStream in) { return rawByteReader(in, 8192); }
static BufferedReader rawByteReader(InputStream in, int bufSize) { try {
  return bufferedReader(_registerIOWrap(new InputStreamReader(in, "ISO-8859-1"), in), bufSize);
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader rawByteReader(File f) { try {
  return rawByteReader(newFileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader rawByteReader(File f, int bufSize) { try {
  return rawByteReader(newFileInputStream(f), bufSize);
} catch (Exception __e) { throw rethrow(__e); } }
static BufferedReader rawByteReader_possiblyGZipped(File f) {
  return isGZipFile(f) ? rawByteReader(gzipInputStream(f)) : rawByteReader(f);
}
static String readLineIgnoreCR(Reader reader) { try {
  int ch;
  StringBuilder buf = new StringBuilder();
  while ((ch = reader.read()) >= 0) {
    if (ch == '\n') break;
    buf.append((char) ch);
  }
  return str(buf);
} catch (Exception __e) { throw rethrow(__e); } }
static int parseInt(String s) {
  return emptyString(s) ? 0 : Integer.parseInt(s);
}

static int parseInt(char c) {
  return Integer.parseInt(str(c));
}
static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
static char charFromHex(String s) {
  return (char) hexToInt(s);
}
static long twoIntsToLong(int a, int b) {
  return (((long) a) << 32) | (((long) b) & 0xFFFFFFFF);
}
static <A> List<A> takeFirst(List<A> l, int n) {
  return l(l) <= n ? l : newSubListOrSame(l, 0, n);
}

static <A> List<A> takeFirst(int n, List<A> l) {
  return takeFirst(l, n);
}

static String takeFirst(int n, String s) { return substring(s, 0, n); }
static String takeFirst(String s, int n) { return substring(s, 0, n); }

static CharSequence takeFirst(int n, CharSequence s) { return subCharSequence(s, 0, n); }

static <A> List<A> takeFirst(int n, Iterable<A> i) {
  if (i == null) return null;
  List l = new ArrayList();
  Iterator<A> it = i.iterator();
  for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++)  { if (it.hasNext()) l.add(it.next()); else break; }
  return l;
}

static int oneMillion() {
  return 1000000;
}
static String nPairs(long n) { return n2(n, "pair"); }
static String nPairs(Collection l) { return nPairs(l(l)); }
static String nPairs(Map map) { return nPairs(l(map)); }
static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  int n = l(l);
  for (int i = startIndex; i < n; i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, int startIndex, A a) {
  return indexOf(l, a, startIndex);
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b) {
  return a == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, int i, char b) {
  return indexOf(a, b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  int n = l(x);
  for (int i = 0; i < n; i++)
    if (eq(x[i], a))
      return i;
  return -1;
}
static List<Integer> compactIntList(List<Integer> l) {
  return l == null ? null : new IntBuffer(l).asVirtualList();
}
static List<Integer> parseInts(Iterable<String> l) {
  return lambdaMap(__37 -> parseInt(__37),l);
}
static List<String> splitAtSpace(String s) {
  return empty(s) ? emptyList() : asList(s.split("\\s+"));
}

static String getText(final AbstractButton c) {
  return c == null ? "" : (String) swingAndWait(new F0<Object>() { public Object get() { try {  return c.getText();  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret c.getText();"; }});
}

static String getText(final JTextComponent c) {
  return c == null ? "" : (String) swingAndWait(new F0<Object>() { public Object get() { try {  return c.getText();  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret c.getText();"; }});
}

static String getText(final JLabel l) {
  return l == null ? "" : (String) swingAndWait(new F0<Object>() { public Object get() { try {  return l.getText();  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret l.getText();"; }});
}

// returns the contents of text field for editable combo box
static String getText(final JComboBox cb) {
  if (cb == null) return null;
  if (isEditableComboBox(cb))
    return unnull((String) cb.getEditor().getItem());
  else
    return str(cb.getSelectedItem());
}



static String fromLines_rtrim(Collection lines) {
  return rtrim_fromLines(lines);
}
static int firstIntFromLong(long l) {
  return (int) (l >> 32);
}
static int secondIntFromLong(long l) {
  return (int) l;
}
static long longSum(Iterable<Long> l) {
  long sum = 0;
  for (Long i : unnull(l))
    if (i != null) sum += i;
  return sum;
}
static <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
  return map(l, f);
}

static <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
  return map(l, f);
}
static String charToHex(char c) {
  return bytesToHex(charToBytes(c));
}
static <A> Iterator<A> iterator(Iterable<A> c) {
  return c == null ? emptyIterator() : c.iterator();
}
static UnsupportedOperationException unsupportedOperation() {
  throw new UnsupportedOperationException();
}
static boolean nempty(Collection c) {
  return !empty(c);
}

static boolean nempty(CharSequence s) {
  return !empty(s);
}

static boolean nempty(Object[] o) { return !empty(o); }
static boolean nempty(byte[] o) { return !empty(o); }
static boolean nempty(int[] o) { return !empty(o); }

static boolean nempty(Map m) {
  return !empty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}

static boolean nempty(Object o) { return !empty(o); }




static boolean nempty(IntBuffer b) { return b != null && !b.isEmpty(); }



static boolean nempty(LongBuffer b) { return b != null && !b.isEmpty(); }

static int boostHashCombine(int a, int b) {
  return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
}
static String linesLL_rtrim(Object... x) {
  return lines_rtrim(ll(x));
}
static LinkedHashMap mapValuesToLinkedHashMap(Object func, Map map) {
  LinkedHashMap m = new LinkedHashMap();
  for (Object key : keys(map))
    m.put(key, callF(func, map.get(key)));
  return m;
}

static <A, B, C> LinkedHashMap<A, C> mapValuesToLinkedHashMap(Map<A, B> map, IF1<B, C> f) {
  return mapValuesToLinkedHashMap(f, map);
}

static <A, B, C> LinkedHashMap<A, C> mapValuesToLinkedHashMap(IF1<B, C> f, Map<A, B> map) {
  return mapValuesToLinkedHashMap((Object) f, map);
}

static LinkedHashMap mapValuesToLinkedHashMap(Map map, Object func) {
  return mapValuesToLinkedHashMap(func, map);
}
static List<Character> characters(final String s) {
  return stringAsCharacterList(s);
}
static String upper(String s) {
  return s == null ? null : s.toUpperCase();
}

static char upper(char c) {
  return Character.toUpperCase(c);
}
static List<String> toLines_nOnly_reversible(String s) {
  List<String> lines = new ArrayList();
  if (s == null) return lines;
  int start = 0, n = s.length();
  if (n != 0) while (true) {
    int i = smartIndexOf(s, '\n', start);
    lines.add(s.substring(start, i));
    if (i == n) break;
    start = i+1;
  }
  return lines;
}
static class mapI_It extends IterableIterator {
  Object f;
  Iterator i;
  
  mapI_It() {}
  mapI_It(Object f, Iterator i) {
  this.i = i;
  this.f = f;}
  
  public boolean hasNext() {
    return i.hasNext();
  }
  
  public Object next() {
    return callF(f, i.next());
  }
  
  public String toString() {
    return formatFunctionCall("mapI", f, i);
  }
}


// apply a function to an iterator
static IterableIterator mapI(final Object f, final Iterator i) {
  return new mapI_It(f, i);
}


static IterableIterator mapI(IterableIterator i, Object f) {
  return mapI((Iterator) i, f);
}

static IterableIterator mapI(Object f, IterableIterator i) {
  return mapI((Iterator) i, f);
}


static IterableIterator mapI(Iterator i, Object f) {
  return mapI(f, i);
}

static <A, B> IterableIterator<B> mapI(Iterable<A> i, IF1<A, B> f) {
  return mapI(i, (Object) f);
}

static <A, B> IterableIterator<B> mapI(Iterator<A> i, IF1<A, B> f) {
  return mapI(f, i);
}

static <A, B> IterableIterator<B> mapI(IterableIterator<A> i, IF1<A, B> f) {
  return mapI((Iterator<A>) i, f);
}

static <A, B> IterableIterator<B> mapI(IF1<A, B> f, Iterable<A> i) {
  return mapI(i, (Object) f);
}

static IterableIterator mapI(Iterable i, Object f) {
  return mapI(f, i.iterator());
}

static IterableIterator mapI(Object f, Iterable i) {
  return mapI(i, f);
}

static String nLines(long n) { return n2(n, "line"); }
static String nLines(Collection l) { return nLines(l(l)); }
static String nLines(String s) { return nLines(countLines(s)); }
static <A> List<A> uniquify(Collection<A> l) {
  return uniquifyList(l);
}
static <A> List<A> sortInPlace(List<A> l, final Object comparator) {
  return sortedInPlace(l, comparator);
}

static <A> List<A> sortInPlace(List<A> l) {
  return sortedInPlace(l);
}
static List collect(Iterable c, String field) {
  return collectField(c, field);
}

static List collect(String field, Iterable c) {
  return collectField(c, field);
}

/*ifclass Concept
static L collect(Class c, S field) {
  ret collect(list(c), field);
}
endif
TODO: make translator ignore stuff in ifclass until resolved
*/
static Map<String, Integer> ciListIndex(List<String> l) {
  return listIndexCI(l);
}
static <A> Map<A, Integer> listIndex(List<A> l) {
  Map<A, Integer> map = new HashMap();
  for (int i = 0; i < l(l); i++)
    map.put(l.get(i), i);
  return map;
}
static Map mapValues(Object func, Map map) {
  Map m = similarEmptyMap(map);
  for (Object key : keys(map))
    m.put(key, callF(func, map.get(key)));
  return m;
}

static <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
  return mapValues(f, map);
}

static <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
  return mapValues((Object) f, map);
}

static Map mapValues(Map map, Object func) {
  return mapValues(func, map);
}
static List<Integer> wrapIntArrayAsImmutableList(int[] l) {
  return new RandomAccessAbstractList<Integer>() {
    public int size() { return l.length; }
    public Integer get(int i) { return l[i]; }
  };
}
static int[] mapToIntArray(Object f, Collection l) {
  return toIntArray(map(f, l));
}

static int[] mapToIntArray(Object f, Object[] l) {
  return toIntArray(map(f, l));
}

static <A> int[] mapToIntArray(Collection<A> l, IF1<A, Integer> f) {
  return mapToIntArray((Object) f, l);
}
/** writes safely (to temp file, then rename) */
static File saveTextFile(String fileName, String contents) throws IOException {
  CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  try {
    File file = new File(fileName);
    mkdirsForFile(file);
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists()) try {
        String saveName = tempFileName + ".saved." + now();
        copyFile(tempFile, new File(saveName));
      } catch (Throwable e) { printStackTrace(e); }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(contents);
      printWriter.close();
    }
    
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
  
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
        
    
    return file;
  } finally {
    action.done();
  }
}

static File saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
  return fileName;
} catch (Exception __e) { throw rethrow(__e); } }
static BufferedReader bufferedUtf8Reader(InputStream in) {
  return utf8BufferedReader(in);
}



static BufferedReader bufferedUtf8Reader(File f) {
  return utf8BufferedReader(f);
}
static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (assertVerbose()) return assertEqualsVerbose(msg, x, y);
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}
static <A, B> List<A> keysList(Map<A, B> map) {
  return cloneListSynchronizingOn(keys(map), map);
}


static String lines_rtrim(Collection lines) {
  return rtrim_fromLines(lines);
}
static String nVersions(long n) { return n2(n, "version"); }
static String nVersions(Collection l) { return nVersions(l(l)); }
static String nVersions(Map map) { return nVersions(l(map)); }
static List mapValuesToList(Object func, Map map) {
  List out = emptyList(l(map));
  for (Object key : keys(map))
    out.add(callF(func, map.get(key)));
  return out;
}

static <A, B, C> List<C> mapValuesToList(IF1<B, C> f, Map<A, B> map) {
  return mapValuesToList((Object) f, map);
}

static <A, B, C> List<C> mapValuesToList(Map<A, B> map, IF1<B, C> f) {
  return mapValuesToList(f, map);
}

static List mapValuesToList(Map map, Object func) {
  return mapValuesToList(func, map);
}
static Map mapToValues(Iterable l, Object f) {
  return mapKeyAndFunction(l, f);
}



static Map mapToValues(Object f, Iterable l) {
  return mapKeyAndFunction(f, l);
}

static <A, B> Map<A, B> mapToValues(Iterable<A> l, IF1<A, B> f) {
  return mapKeyAndFunction(f, l);
}

static <A, B> Map<A, B> mapToValues(IF1<A, B> f, Iterable<A> l) {
  return mapKeyAndFunction(f, l);
}

static <A, B, C> Map<A, C> mapToValues(Map<A, B> map, IF2<A, B, C> f) {
  return mapKeyAndFunction(map, f);
}
static long intPairToLong(IntPair p) {
  return p == null ? 0 : (((long) p.a) << 32) | (((long) p.b) & 0xFFFFFFFF);
}
static <A> int addAndReturnIndex(List<A> l, A a) {
  if (l == null) return -1;
  int idx = l.size();
  l.add(a);
  return idx;
}
static <A> void listPut(List<A> l, int i, A a, A emptyElement) {
  listSet(l, i, a, emptyElement);
}

static <A> void listPut(List<A> l, int i, A a) {
  listSet(l, i, a);
}

static void assertEqualsIC(String x, String y) {
  assertEqic(x, y);
}

static void assertEqualsIC(String msg, String x, String y) {
  assertEqic(msg, x, y);
}
static String assertEquals_quote(String x, String y) {
  return assertEquals_quote(null, x, y);
}

static String assertEquals_quote(String msg, String x, String y) {
  if (neq(x, y))
    throw fail((msg != null ? msg + ": " : "") + quote(y) + " != " + quote(x));
  return y;
}
static String defaultTimerName_name;

static String defaultTimerName() {
  if (defaultTimerName_name == null)
    defaultTimerName_name = "A timer by " + programID();
  return defaultTimerName_name;
}
static Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

static void _registerTimer(java.util.Timer timer) {
  _registerTimer_list.add(timer);
}

static void cleanMeUp__registerTimer() {
  cancelTimers(getAndClearList(_registerTimer_list));
}
// firstDelay = delay
static FixedRateTimer doEvery(long delay, final Object r) {
  return doEvery(delay, delay, r);
}

static FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
  return vmBus_timerStarted(timer);
}

// reversed argument order for fun
static FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
}

static FixedRateTimer doEvery(double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), r);
}

static int hashCodeFor(Object a) {
  return a == null ? 0 : a.hashCode();
}
static int lLongArray(long[] a) {
  return a == null ? 0 : a.length;
}
static long[] resizeLongArray(long[] a, int n) {
  if (n == lLongArray(a)) return a;
  long[] b = new long[n];
  arraycopy(a, 0, b, 0, Math.min(lLongArray(a), n));
  return b;
}
static void add(BitSet bs, int i) {
  bs.set(i);
}

static <A> boolean add(Collection<A> c, A a) {
  return c != null && c.add(a);
}


static void add(Container c, Component x) {
  addToContainer(c, x);
}

static <A> ArrayList<Long> longArrayToList(long[] a) {
  if (a == null) return null;
  return longArrayToList(a, 0, a.length);
}

// no range checking on from/to in the interest of S P E E E E E EEED
static <A> ArrayList<Long> longArrayToList(long[] a, int from, int to) {
  if (a == null) return null;
  ArrayList < Long > l = new ArrayList<>(to-from);
  for (int i = from; i < to; i++) l.add(a[i]);
  return l;
}
static <A> List<A> listFromFunction(int n, IF1<Integer, A> f) {
  return new RandomAccessAbstractList<A>() {
    public int size() { return n; }
    public A get(int i) { return f.get(i); }
  };
}

static <A> List<A> listFromFunction(IF1<Integer, A> f, int n) {
  return listFromFunction(n, f);
}
static <A> A popLast(List<A> l) {
  return liftLast(l);
}

static <A> List<A> popLast(int n, List<A> l) {
  return liftLast(n, l);
}
static <A> A last(List<A> l) {
  return empty(l) ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static double last(double[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static <A> A last(A[] a) {
  return l(a) != 0 ? a[l(a)-1] : null;
}

static <A> A last(Iterator<A> it) {
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}

static <A> A last(Collection<A> l) {
  if (l == null) return null;
  if (l instanceof List) return (A) last(((List) l));
  if (l instanceof SortedSet) return (A) last(((SortedSet) l));
  Iterator<A> it = iterator(l);
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}

static <A> A last(SortedSet<A> l) {
  return l == null ? null : l.last();
}


static <A> A nextToLast(List<A> l) {
  return get(l, l(l)-2);
}
static String squareBracket(String s) {
  return "[" + s + "]";
}
static int lIntArray(int[] a) {
  return a == null ? 0 : a.length;
}
static int[] resizeIntArray(int[] a, int n) {
  if (n == lIntArray(a)) return a;
  int[] b = new int[n];
  arraycopy(a, 0, b, 0, Math.min(lIntArray(a), n));
  return b;
}
static <A> ArrayList<Integer> intArrayToList(int[] a) {
  if (a == null) return null;
  return intArrayToList(a, 0, a.length);
}

// no range checking on from/to in the interest of S P E E E E E EEED
static <A> ArrayList<Integer> intArrayToList(int[] a, int from, int to) {
  if (a == null) return null;
  ArrayList < Integer > l = new ArrayList<>(to-from);
  for (int i = from; i < to; i++) l.add(a[i]);
  return l;
}
static <A> A set(A o, String field, Object value) {
  if (o == null) return null;
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    makeAccessible(f);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
  return o;
}

static void set(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = set_findStaticField(c, field);
    makeAccessible(f);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
static IntegerIterator integerIterator(int[] l) {
  return l == null ? null : new IntegerIterator() {
    int i = 0;
    public boolean hasNext() { return i < l.length; }
    public int next() { return l[i++]; }
  };
}
static <A, B> MultiSetMap<A, B> multiSetMap_innerCustomTreeSet_outerRevTreeMap(Comparator<B> innerComparator) {
  MultiSetMap<A, B> m = multiSetMap_innerTreeSet(innerComparator);
  m.data = revTreeMap();
  return m;
}
static <A, B> MultiSetMap<A, B> multiSetMap_innerCompactHashSet_outerRevTreeMap() {
  return new MultiSetMap<A, B>(descTreeMap()) {
    Set<B> _makeEmptySet() { return new CompactHashSet(); }
  };
}
static <A> List<A> reverseInPlace(List<A> l) {
  return reverseList(l);
}
static <A, B> Pair<A, B> pair(A a, B b) {
  return new Pair(a, b);
}

static <A> Pair<A, A> pair(A a) {
  return new Pair(a, a);
}
static String a(String noun) {
  if (eq(noun, "")) return "?";
  return ("aeiou".indexOf(noun.charAt(0)) >= 0 ? "an " : "a ") + noun;
}

static String a(String contents, Object... params) {
  return htag("a", contents, params);
}

static String b(Object contents, Object... params) {
  return tag("b", contents, params);
}
static String stringIf(boolean b, String s) {
  return stringIfTrue(b, s);
}
static List callFAll(Collection l, Object... args) {
  return callF_all(l, args);
}
static <A, B> A firstKey(Map<A, B> map) {
  return first(keys(map));
}


static <A, B> A firstKey(MultiSetMap<A, B> map) {
  return map == null ? null : firstKey(map.data);
}

static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt(((String) o));
  if (o instanceof Boolean)
    return boolToInt(((Boolean) o));
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}
static <A, B> B firstValue(Map<A, B> map) {
  return first(values(map));
}


static <A, B> B firstValue(MultiSetMap<A, B> map) {
  return map == null ? null : first(firstValue(map.data));
}

static int or0(Integer i) { return i == null ? 0 : i; }
static long or0(Long l) { return l == null ? 0L : l; }
static double or0(Double d) { return d == null ? 0.0 : d; }
static int hashSetCapacity(HashSet set) {
  return (int) call(get(set, "map"), "capacity");
}
static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null && b != null) a.putAll(b);
  return a;
}
static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}

static <A> void remove(Collection<A> l, A a) {
  if (l != null) l.remove(a);
}
static Set emptySet() {
  return new HashSet();
}
static <A, B> Set<A> keySet(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

static Set keySet(Object map) {
  return keys((Map) map);
}






static <A> A reverseGet(List<A> l, int idx) {
  if (l == null || idx < 0) return null;
  int n = l(l);
  return idx < n ? l.get(n-1-idx) : null;
}
static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
  if (map == null) return new HashMap();
  // assume mutex is equal to map
  synchronized(map) {
    return map instanceof TreeMap ? new TreeMap((TreeMap) map) // copies comparator
      : map instanceof LinkedHashMap ? new LinkedHashMap(map)
      : new HashMap(map);
  }
}

static <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : cloneList(l))
    x.add(f.get(o));
  return x;
}
static String find(String pattern, String text) {
  Matcher matcher = Pattern.compile(pattern).matcher(text);
  if (matcher.find())
    return matcher.group(1);
  return null;
}

static <A> A find(Collection<A> c, Object... data) {
  for (A x : c)
    if (checkFields(x, data))
      return x;
  return null;
}
static int iround(double d) {
  return (int) Math.round(d);
}

static int iround(Number n) {
  return iround(toDouble(n));
}


static Method findMethod_cached(Object o, String method, Object... args) { try {
  if (o == null) return null;
  if (o instanceof Class) {
    _MethodCache cache = callOpt_getCache(((Class) o));
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
        return m;
    return null;
  } else {
    _MethodCache cache = callOpt_getCache(o.getClass());
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (findMethod_checkArgs(m, args, false))
        return m;
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }

static boolean endsWith(String a, String b) {
  return a != null && a.endsWith(b);
}

static boolean endsWith(String a, char c) {
  return nempty(a) && lastChar(a) == c;
}


  static boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b)) return false;
    m.m = new String[] {dropLast(l(b), a)};
    return true;
  }


static byte[] isGZipFile_magic = bytesFromHex("1f8b08");

static boolean isGZipFile(File f) {
  return byteArraysEqual(isGZipFile_magic, loadBeginningOfBinaryFile(f, l(isGZipFile_magic)));
}
static GZIPInputStream gzipInputStream(File f) {
  return newGZIPInputStream(f);
}



static GZIPInputStream gzipInputStream(InputStream in) {
  return newGZIPInputStream(in);
}
static boolean emptyString(String s) {
  return s == null || s.length() == 0;
}
static void assertTrue(Object o) {
  if (!(eq(o, true) /*|| isTrue(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static int hexToInt(String s) {
  return Integer.parseInt(s, 16);
}
static <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
  return newSubListOrSame(l, startIndex, l(l));
}

static <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = max(0, startIndex);
  endIndex = min(n, endIndex);
  if (startIndex >= endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  return cloneList(l.subList(startIndex, endIndex));
}


static CharSequence subCharSequence(CharSequence s, int x) {
  return subCharSequence(s, x, s == null ? 0 : s.length());
}

static CharSequence subCharSequence(CharSequence s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x >= s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.subSequence(x, y);
}
static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() {  public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}
static boolean isEditableComboBox(final JComboBox cb) {
  return cb != null && swing(new F0<Boolean>() { public Boolean get() { try {  return cb.isEditable();  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret cb.isEditable();"; }});
}
static String rtrim_fromLines(Collection lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null) {
    boolean first = true;
    for (Object line : lines) {
      if (first) first = false; else buf.append('\n');
      buf.append(str(line));
    }
  }
  return buf.toString();
}
static List map(Iterable l, Object f) { return map(f, l); }

static List map(Object f, Iterable l) {
  List x = emptyList(l);
  if (l != null) for (Object o : l)
    x.add(callF(f, o));
  return x;
}


  static <A, B> List<B> map(Iterable<A> l, F1<A, B> f) { return map(f, l); }

  static <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null) for (A o : l)
      x.add(callF(f, o));
    return x;
  }


static <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) { return map(l, f); }
static <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : l)
    x.add(f.get(o));
  return x;
}
  
static <A, B> List<B> map(IF1<A, B> f, A[] l) { return map(l, f); }
static <A, B> List<B> map(A[] l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : l)
    x.add(f.get(o));
  return x;
}
  
static List map(Object f, Object[] l) { return map(f, asList(l)); }
static List map(Object[] l, Object f) { return map(f, l); }

static List map(Object f, Map map) {
  return map(map, f);
}

// map: func(key, value) -> list element
static List map(Map map, Object f) {
  List x = new ArrayList();
  if (map != null) for (Object _e : map.entrySet()) {
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}

static <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
  return map(map, (Object) f);
}
  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }

static byte[] charToBytes(char c) {
  return new byte[] {
    (byte) (c >>> 8),
    (byte) c
  };
}
static Iterator emptyIterator() {
  return Collections.emptyIterator();
}
static List<Character> stringAsCharacterList(final String s) {
  if (s == null) return null;
  return new RandomAccessAbstractList<Character>() {
    final int l = l(s);
    public int size() { return l; }
    public Character get(int i) { return s.charAt(i); }
  };
}
// returns l(s) if not found
static int smartIndexOf(String s, String sub, int i) {
  if (s == null) return 0;
  i = s.indexOf(sub, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, int i, char c) {
  return smartIndexOf(s, c, i);
}

static int smartIndexOf(String s, char c, int i) {
  if (s == null) return 0;
  i = s.indexOf(c, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, String sub) {
  return smartIndexOf(s, sub, 0);
}

static int smartIndexOf(String s, char c) {
  return smartIndexOf(s, c, 0);
}

static <A> int smartIndexOf(List<A> l, A sub) {
  return smartIndexOf(l, sub, 0);
}

static <A> int smartIndexOf(List<A> l, int start, A sub) {
  return smartIndexOf(l, sub, start);
}

static <A> int smartIndexOf(List<A> l, A sub, int start) {
  int i = indexOf(l, sub, start);
  return i < 0 ? l(l) : i;
}
static String formatFunctionCall(String fname, Object... args) {
  return fname + "(" + joinWithComma(allToString(args)) + ")";
}
static int countLines(String s) {
  return l(toLines(s)); // yeah could be optimized :-)
}
static <A> List<A> uniquifyList(Collection<A> l) {
  if (l == null) return null;
  if (l(l) < 2) return asList(l);
  HashSet<A> set = new HashSet();
  List<A> out = new ArrayList();
  for (A a : l)
    if (set.add(a))
      out.add(a);
  return out;
}
static <A> List<A> sortedInPlace(List<A> l, final Object comparator) {
  sort(l, makeComparator(comparator));
  return l;
}

static <A> List<A> sortedInPlace(List<A> l) {
  sort(l);
  return l;
}
static List collectField(Iterable c, String field) {
  List l = new ArrayList();
  if (c != null) for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}

static List collectField(String field, Iterable c) {
  return collectField(c, field);
}
static Map<String, Integer> listIndexCI(List<String> l) {
  Map<String, Integer> map = ciMap();
  for (int i = 0; i < l(l); i++)
    map.put(l.get(i), i);
  return map;
}
static Map similarEmptyMap(Map m) {
  if (m instanceof TreeMap) return new TreeMap(((TreeMap) m).comparator());
  if (m instanceof LinkedHashMap) return new LinkedHashMap();
  
  // default to a hash map
  return new HashMap();
}
static int[] toIntArray(Collection<Integer> l) {
  int[] a = new int[l(l)];
  int i = 0;
  if (a.length != 0) for (int x : l)
    a[i++] = x;
  return a;
}
static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

static class CriticalAction {
  String description;
  
  CriticalAction() {}
  CriticalAction(String description) {
  this.description = description;}
  
  void done() {
    beginCriticalAction_inFlight.remove(this);
  }
}

static CriticalAction beginCriticalAction(String description) {
  ping();
  CriticalAction c = new CriticalAction(description);
  beginCriticalAction_inFlight.add(c);
  return c;
}

static void cleanMeUp_beginCriticalAction() {
  int n = 0;
  while (nempty(beginCriticalAction_inFlight)) {
    int m = l(beginCriticalAction_inFlight);
    if (m != n) {
      n = m;
      try {
        print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
      } catch (Throwable __e) { _handleException(__e); }
    }
    sleepInCleanUp(10);
  }
}
static BufferedReader utf8BufferedReader(InputStream in) {
  return utf8bufferedReader(in);
}

static BufferedReader utf8BufferedReader(File f) {
  return utf8bufferedReader(f);
}
static ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

static void assertVerbose(boolean b) {
  assertVerbose_value.set(b);
}

static boolean assertVerbose() { return isTrue(assertVerbose_value.get()); }
static <A> A assertEqualsVerbose(Object x, A y) {
  assertEqualsVerbose((String) null, x, y);
  return y;
}

// x = expected, y = actual
static <A> A assertEqualsVerbose(String msg, Object x, A y) {
  if (!eq(x, y)) {
    

    throw fail((msg != null ? msg + ": " : "") + "expected: "+ x + ", got: " + y);
  } else
    print("OK" + (empty(msg) ? "" : " " + msg) + ": " + /*sfu*/(x));
  return y;
}


static <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
  if (l == null) return new ArrayList();
  synchronized(mutex) {
    return new ArrayList<A>(l);
  }
}
static Map mapKeyAndFunction(Iterable l, Object f) {
  return mapKeyAndFunction(f, l);
}

static Map mapKeyAndFunction(Object f, Iterable l) {
  HashMap map = new HashMap();
  if (l != null) for (Object o : l)
    map.put(o, callF(f, o));
  return map;
}

static <A, B, C> Map<A, C> mapKeyAndFunction(Map<A, B> map, IF2<A, B, C> f) {
  HashMap map2 = new HashMap();
  if (map != null) for (Object key : keys( map))
    { Object value = map.get(key);  map2.put(key, callF(f, key, value)); }
  return map2;
}


static <A, B> Map<A, B> mapKeyAndFunction(Iterable<A> l, IF1<A, B> f) {
  return mapKeyAndFunction(f, l);
}
static <A> void listSet(List<A> l, int i, A a, A emptyElement) {
  if (i < 0) return;
  while (i >= l(l)) l.add(emptyElement);
  l.set(i, a);
}

static <A> void listSet(List<A> l, int i, A a) {
  listSet(l, i, a, null);
}

static void assertEqic(String x, String y) {
  assertEqic(null, x, y);
}

static void assertEqic(String msg, String x, String y) {
  if (!eqic(x, y))
    throw fail((msg != null ? msg + ": " : "") + quote(x) + " != " + quote(y) + " [ic]");
}
static String programID() {
  return getProgramID();
}

static String programID(Object o) {
  return getProgramID(o);
}
static <A> Set<A> newWeakHashSet() {
  return synchroWeakHashSet();
}
static void cancelTimers(Collection timers) {
  for (Object timer : timers) cancelTimer(timer);
}
static <A> List<A> getAndClearList(Collection<A> l) {
  if (l == null) return emptyList();
  synchronized(collectionMutex(l)) {
    List<A> out = cloneList(l);
    l.clear();
    return out;
  }
}
static int shorten_default = 100;

static String shorten(CharSequence s) { return shorten(s, shorten_default); }

static String shorten(CharSequence s, int max) {
  return shorten(s, max, "...");
}

static String shorten(CharSequence s, int max, String shortener) {
  if (s == null) return "";
  if (max < 0) return str(s);
  return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max-l(shortener))) + shortener;
}

static String shorten(int max, CharSequence s) { return shorten(s, max); }
static <A> A vmBus_timerStarted(A timer) {
  vmBus_send("timerStarted",timer, costCenter());
  return timer;
}
static void addToContainer(final Container a, final Component b) {
  if (a != null && b != null) { swing(new Runnable() {  public void run() { try {  a.add(b); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "a.add(b);"; }}); }
}
static <A> A liftLast(List<A> l) {
  if (empty(l)) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}

static <A> List<A> liftLast(int n, List<A> l) {
  int i = l(l)-n;
  List<A> part = cloneSubList(l, i);
  removeSubList(l, i);
  return part;
}
static void smartSet(Field f, Object o, Object value) throws Exception {
  try {
    f.set(o, value);
  } catch (Exception e) {
    Class type = f.getType();
    
    // take care of common case (long to int)
    if (type == int.class && value instanceof Long)
      value = ((Long) value).intValue();
    
    if (type == LinkedHashMap.class && value instanceof Map)
      { f.set(o, asLinkedHashMap((Map) value)); return; }
    
    
    throw e;
  }
}
static <A, B> MultiSetMap<A, B> multiSetMap_innerTreeSet() { return multiSetMap_innerTreeSet(null); }
static <A, B> MultiSetMap<A, B> multiSetMap_innerTreeSet(Comparator<B> innerComparator) {
  return new MultiSetMap<A, B>() {
    Set<B> _makeEmptySet() { return new TreeSet(innerComparator); }
  };
}
static TreeMap revTreeMap() {
  return new TreeMap(reverseComparator());
}
static TreeMap descTreeMap() {
  return revTreeMap();
}
static <A> List<A> reverseList(List<A> l) {
  Collections.reverse(l);
  return l;
}
static String htag(String tag) {
  return htag(tag, "");
}

static String htag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  if (empty(s) && neqic(tag, "script"))
    return dropLast(openingTag) + "/>";
  return openingTag + s + "</" + tag + ">";
}
static String tag(String tag) {
  return htag(tag);
}

static String tag(String tag, Object contents, Object... params) {
  return htag(tag, str(contents), params);
}

static String tag(String tag, StringBuilder contents, Object... params) {
  return htag(tag, contents, params);
}

static String tag(String tag, StringBuffer contents, Object... params) {
  return htag(tag, contents, params);
}
static String stringIfTrue(boolean b, String s) {
  return b ? s : "";
}
static List callF_all(Collection l, Object... args) {
  return map(l, f -> callF(f, args));
}
static int boolToInt(boolean b) {
  return b ? 1 : 0;
}
static boolean checkFields(Object x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(getOpt(x, (String) data[i]), data[i+1]))
      return false;
  return true;
}
static double toDouble(Object o) {
  if (o instanceof Number)
    return ((Number) o).doubleValue();
  if (o instanceof BigInteger)
    return ((BigInteger) o).doubleValue();
  if (o instanceof String)
    return parseDouble(((String) o));
  if (o == null) return 0.0;
  throw fail(o);
}


static char lastChar(String s) {
  return empty(s) ? '\0' : s.charAt(l(s)-1);
}
static <A> A[] dropLast(A[] a) { return dropLast(a, 1); }
static <A> A[] dropLast(A[] a, int n) {
  if (a == null) return null;
  n = Math.min(n, a.length);
  A[] b = arrayOfSameType(a, a.length-n);
  System.arraycopy(a, 0, b, 0, b.length);
  return b;
}

static <A> List<A> dropLast(List<A> l) {
  return subList(l, 0, l(l)-1);
}

static <A> List<A> dropLast(int n, List<A> l) {
  return subList(l, 0, l(l)-n);
}

static <A> List<A> dropLast(Iterable<A> l) {
  return dropLast(asList(l));
}

static String dropLast(String s) {
  return substring(s, 0, l(s)-1);
}

static String dropLast(String s, int n) {
  return substring(s, 0, l(s)-n);
}

static String dropLast(int n, String s) {
  return dropLast(s, n);
}

static byte[] bytesFromHex(String s) {
  return hexToBytes(s);
}
static boolean byteArraysEqual(byte[] a, byte[] b) {
  return Arrays.equals(a, b);
}
static byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
  return loadBinaryFilePart(file, 0, maxBytes);
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
static Runnable addThreadInfoToRunnable(final Object r) {
  final Object info = _threadInfo();
  return info == null ? asRunnable(r) : new Runnable() {  public void run() { try {  _inheritThreadInfo(info); callF(r); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_inheritThreadInfo(info); callF(r);"; }};
}
static Object swing(Object f) {
  return swingAndWait(f);
}

static <A> A swing(F0<A> f) {
  return (A) swingAndWait(f);
}

static <A> A swing(IF0<A> f) {
  return (A) swingAndWait(f);
}
static List<String> allToString(Iterable c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}

static List<String> allToString(Object[] c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}
static <T> void sort(T[] a, Comparator<? super T> c) {
  if (a != null) Arrays.sort(a, c);
}

static <T> void sort(T[] a) {
  if (a != null) Arrays.sort(a);
}

static void sort(int[] a) { if (a != null) Arrays.sort(a); }

static <T> void sort(List<T> a, Comparator<? super T> c) {
  if (a != null) Collections.sort(a, c);
}

static void sort(List a) {
  if (a != null) Collections.sort(a);
}
static Comparator makeComparator(final Object f) {
  if (f instanceof Comparator) return (Comparator) f;
  return new Comparator() {
    public int compare(Object a, Object b) {
      return (Integer) callF(f, a, b);
    }
  };
}

static <A> TreeMap<String, A> ciMap() {
  return caseInsensitiveMap();
}
static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  if (o instanceof ThreadLocal) // TODO: remove this
    return isTrue(((ThreadLocal) o).get());
  throw fail(getClassName(o));
}

static String programID;
static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}



static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}
static <A> Set<A> synchroWeakHashSet() {
  return Collections.newSetFromMap((Map) newWeakHashMap());
}
static Object costCenter() { return mc(); }
static <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
  if (map instanceof LinkedHashMap) return (LinkedHashMap) map;
  LinkedHashMap<A, B> m = new LinkedHashMap();
  if (map != null) synchronized(collectionMutex(map)) {
    m.putAll(map);
  }
  return m;
}
static <A> Comparator<A> reverseComparator(Comparator<A> c) {
  return (a, b) -> c.compare(b, a);
}

static <A> Comparator<A> reverseComparator() {
  return (a, b) -> cmp(b, a);
}

static String hopeningTag(String tag, Map params) {
  return hopeningTag(tag, mapToParams(params));
}

static String hopeningTag(String tag, Object... params) {
  StringBuilder buf = new StringBuilder();
  buf.append("<" + tag);
  for (int i = 0; i < l(params); i += 2) {
    String name = (String) get(params, i);
    Object val = get(params, i+1);
    if (nempty(name) && val != null) {
      if (val == html_valueLessParam())
        buf.append(" " + name);
      else {
        String s = str(val);
        if (!empty(s))
          buf.append(" " + name + "=" + htmlQuote(s));
      }
    }
  }
  buf.append(">");
  return str(buf);
}
static boolean neqic(String a, String b) {
  return !eqic(a, b);
}

static boolean neqic(char a, char b) {
  return !eqic(a, b);
}
static double parseDouble(String s) {
  return Double.parseDouble(s);
}


static <A> A[] arrayOfSameType(A[] a, int n) {
  return newObjectArrayOfSameType(a, n);
}
static byte[] hexToBytes(String s) {
  if (odd(l(s))) throw fail("Hex string has odd length: " + quote(shorten(10, s)));
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    int a = parseHexChar(s.charAt(i*2));
    int b = parseHexChar(s.charAt(i*2+1));
    if (a < 0 || b < 0)
      throw fail("Bad hex byte: " + quote(substring(s, i*2, i*2+2)) + " at " + i*2 + "/" + l(s));
    bytes[i] = (byte) ((a << 4) | b);
  }
  return bytes;
}
static byte[] loadBinaryFilePart(File file, long start, long end) { try {
  RandomAccessFile raf = new RandomAccessFile(file, "r");
  int n = toInt(min(raf.length(), end-start));
  byte[] buffer = new byte[n];
  try {
    raf.seek(start);
    raf.readFully(buffer, 0, n);
    return buffer;
  } finally {
    raf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (isAndroid()) return isHeadless_cache = true;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static Runnable asRunnable(Object o) {
  return toRunnable(o);
}


static void _inheritThreadInfo(Object info) {
  _threadInheritInfo(info);
}
static <A> TreeMap<String, A> caseInsensitiveMap() {
  return new TreeMap(caseInsensitiveComparator());
}
static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}
static Class getMainClass() {
  return mc();
}

static Class getMainClass(Object o) { try {
  if (o == null) return null;
  if (o instanceof Class && eq(((Class) o).getName(), "x30")) return (Class) o;
  return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
} catch (Exception __e) { throw rethrow(__e); } }
static <A, B> Map<A, B> newWeakHashMap() {
  return _registerWeakMap(synchroMap(new WeakHashMap()));
}
static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(int a, int b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(long a, long b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}
static Object[] mapToParams(Map map) {
  return mapToObjectArray(map);
}
static Object html_valueLessParam_cache;
static Object html_valueLessParam() { if (html_valueLessParam_cache == null) html_valueLessParam_cache = html_valueLessParam_load(); return html_valueLessParam_cache; }

static Object html_valueLessParam_load() {
  return new Object();
}
static String htmlQuote(String s) {
  return "\"" + htmlencode_forParams(s) + "\"";
}


static <A> A[] newObjectArrayOfSameType(A[] a, int n) {
  return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
}
static boolean odd(int i) {
  return (i & 1) != 0;
}

static boolean odd(long i) {
  return (i & 1) != 0;
}

static boolean odd(BigInteger i) { return odd(toInt(i)); }
static int parseHexChar(char c) {
  if (c >= '0' && c <= '9') return charDiff(c, '0');
  if (c >= 'a' && c <= 'f') return charDiff(c, 'a')+10;
  if (c >= 'A' && c <= 'F') return charDiff(c, 'A')+10;
  return -1;
}
static Runnable toRunnable(final Object o) {
  if (o instanceof Runnable) return (Runnable) o;
  return new Runnable() {  public void run() { try {  callF(o) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(o)"; }};
}
static Comparator<String> caseInsensitiveComparator() {
  
  
  return betterCIComparator();
  
}
  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }
static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}
static List _registerWeakMap_preList;

static <A> A _registerWeakMap(A map) {
  if (javax() == null) {
    // We're in class init
    if (_registerWeakMap_preList == null) _registerWeakMap_preList = synchroList();
    _registerWeakMap_preList.add(map);
    return map;
  }
  
  try {
    call(javax(), "_registerWeakMap", map);
  } catch (Throwable e) {
    printException(e);
    print("Upgrade JavaX!!");
  }
  return map;
}

static void _onLoad_registerWeakMap() {
  assertNotNull(javax());
  if (_registerWeakMap_preList == null) return;
  for (Object o : _registerWeakMap_preList)
    _registerWeakMap(o);
  _registerWeakMap_preList = null;
}
static Object[] mapToObjectArray(Map map) {
  List l = new ArrayList();
  for (Object o : keys(map)) {
    l.add(o);
    l.add(map.get(o));
  }
  return toObjectArray(l);
}

static Object[] mapToObjectArray(Object f, Collection l) {
  int n = l(l);
  Object[] array = new Object[n];
  if (n != 0) {
    Iterator it = iterator(l);
    for (int i = 0; i < n; i++)
      array[i] = callF(f, it.next());
  }
  return array;
}

static Object[] mapToObjectArray(Object f, Object[] l) {
  int n = l(l);
  Object[] array = new Object[n];
  for (int i = 0; i < n; i++)
    array[i] = callF(f, l[i]);
  return array;
}

static <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
  return mapToObjectArray(f, l);
}
static String htmlencode_forParams(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      /*if (c >= 0x100)
        out.append("&#x").append(charToHex(c)).append(';');
      else*/ if (c > 127 || c == '"' || c == '<' || c == '>') {
          out.append("&#");
          out.append((int) c);
          out.append(';');
      } else
          out.append(c);
  }
  return out.toString();
}


static int charDiff(char a, char b) {
  return (int) a-(int) b;
}

static int charDiff(String a, char b) {
  return charDiff(stringToChar(a), b);
}
static betterCIComparator_C betterCIComparator_instance;

static betterCIComparator_C betterCIComparator() {
  if (betterCIComparator_instance == null)
    betterCIComparator_instance = new betterCIComparator_C();
  return betterCIComparator_instance;
}

static class betterCIComparator_C implements Comparator<String> {
  public int compare(String s1, String s2) {
    if (s1 == null) return s2 == null ? 0 : -1;
    if (s2 == null) return 1;
  
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
            c1 = Character.toUpperCase(c1);
            c2 = Character.toUpperCase(c2);
            if (c1 != c2) {
                c1 = Character.toLowerCase(c1);
                c2 = Character.toLowerCase(c2);
                if (c1 != c2) {
                    // No overflow because of numeric promotion
                    return c1 - c2;
                }
            }
        }
    }
    return n1 - n2;
  }
}
public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}
static <A extends Throwable> A printException(A e) {
  printStackTrace(e);
  return e;
}
static Object[] toObjectArray(Collection c) {
  List l = asList(c);
  return l.toArray(new Object[l.size()]);
}



static char stringToChar(String s) {
  if (l(s) != 1) throw fail("bad stringToChar: " + s);
  return firstChar(s);
}
static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}


static char firstChar(String s) {
  return s.charAt(0);
}
static long parseLong(String s) {
  if (empty(s)) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}


static interface IF0<A> {
  A get();
}static interface IF2<A, B, C> {
  C get(A a, B b);
}static class Var<A> implements IVar<A> {
  Var() {}
  Var(A v) {
  this.v = v;}

  
  A v; // you can access this directly if you use one thread
  
  public synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  public synchronized A get() { return v; }
  public synchronized boolean has() { return v != null; }
  public synchronized void clear() { v = null; }
  
  public String toString() { return str(get()); }
}

static interface IVar<A> extends IF0<A> {
  void set(A a);
  A get();
  
  default boolean has() { return get() != null; }
  default void clear() { set(null); }
  
}
}



class m1028231{}