//FILENAME: iiPkg/ii.java
package iiPkg;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;

public class ii {

  public static class IntegralImage implements MakesBufferedImage {

    public int w, h;

    public int[] data;

    public IntegralImage() {
    }

    public IntegralImage(RGBImage img) {
      w = img.w();
      h = img.h();
      if (longMul(w, h) > 8000000)
        throw fail("Image too big: " + w + "*" + h);
      data = new int[w * h * 3];
      int i = 0;
      for (int y = 0; y < h; y++) {
        int sumR = 0, sumG = 0, sumB = 0;
        for (int x = 0; x < w; x++) {
          int rgb = img.getInt(x, y);
          sumR += (rgb >> 16) & 0xFF;
          sumG += (rgb >> 8) & 0xFF;
          sumB += rgb & 0xFF;
          data[i] = y > 0 ? sumR + data[i - w * 3] : sumR;
          data[i + 1] = y > 0 ? sumG + data[i - w * 3 + 1] : sumG;
          data[i + 2] = y > 0 ? sumB + data[i - w * 3 + 2] : sumB;
          i += 3;
        }
      }
    }

    public IntegralImage(BufferedImage img) {
      w = img.getWidth();
      h = img.getHeight();
      if (longMul(w, h) > 8000000)
        throw fail("Image too big: " + w + "*" + h);
      int[] pixels = pixelsOfBufferedImage(img);
      data = new int[w * h * 3];
      int i = 0, j = 0;
      for (int y = 0; y < h; y++) {
        int sumR = 0, sumG = 0, sumB = 0;
        for (int x = 0; x < w; x++) {
          int rgb = pixels[j++];
          sumR += (rgb >> 16) & 0xFF;
          sumG += (rgb >> 8) & 0xFF;
          sumB += rgb & 0xFF;
          data[i] = y > 0 ? sumR + data[i - w * 3] : sumR;
          data[i + 1] = y > 0 ? sumG + data[i - w * 3 + 1] : sumG;
          data[i + 2] = y > 0 ? sumB + data[i - w * 3 + 2] : sumB;
          i += 3;
        }
      }
    }

    public int get(int x, int y, int channel) {
      return x < 0 || y < 0 || x >= w || y >= h ? 0 : data[(y * w + x) * 3 + channel];
    }

    public int get(int x, int y) {
      if (x < 0 || y < 0 || x >= w || y >= h)
        return 0;
      int i = (y * w + x) * 3;
      return data[i] + data[i + 1] + data[i + 2];
    }

    public double averageBrightness() {
      return doubleRatio(get(w - 1, h - 1), w * h * 3 * 255.0);
    }

    public String toString() {
      return "IntegralImage " + w + "*" + h + ", brightness: " + averageBrightness();
    }

    public BufferedImage getBufferedImage() {
      return integralImageToBufferedImage(this);
    }

    public int getWidth() {
      return w;
    }

    public int getHeight() {
      return h;
    }
  }

  public static class RGBImage implements MakesBufferedImage {

    public transient BufferedImage bufferedImage;

    public File file;

    public int width, height;

    public int[] pixels;

    public RGBImage() {
    }

    public RGBImage(BufferedImage image) {
      this(image, null);
    }

    public RGBImage(BufferedImage image, File file) {
      this.file = file;
      bufferedImage = image;
      width = image.getWidth();
      height = image.getHeight();
      pixels = new int[width * height];
      PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
      try {
        if (!pixelGrabber.grabPixels())
          throw new RuntimeException("Could not grab pixels");
        cleanPixels();
      } catch (InterruptedException e) {
        throw new RuntimeException(e);
      }
    }

    public RGBImage(String file) throws IOException {
      this(new File(file));
    }

    public RGBImage(Dimension size, Color color) {
      this(size.width, size.height, color);
    }

    public RGBImage(Dimension size, RGB color) {
      this(size.width, size.height, color);
    }

    public final void cleanPixels() {
      for (int i = 0; i < pixels.length; i++) pixels[i] &= 0xFFFFFF;
    }

    public RGBImage(int width, int height, int[] pixels) {
      this.width = width;
      this.height = height;
      this.pixels = pixels;
    }

    public RGBImage(int w, int h, RGB[] pixels) {
      this.width = w;
      this.height = h;
      this.pixels = asInts(pixels);
    }

    public static int[] asInts(RGB[] pixels) {
      int[] ints = new int[pixels.length];
      for (int i = 0; i < pixels.length; i++) ints[i] = pixels[i] == null ? 0 : pixels[i].getColor().getRGB();
      return ints;
    }

    public RGBImage(int w, int h) {
      this(w, h, Color.black);
    }

    public RGBImage(int w, int h, RGB rgb) {
      this.width = w;
      this.height = h;
      this.pixels = new int[w * h];
      int col = rgb.asInt();
      if (col != 0)
        for (int i = 0; i < pixels.length; i++) pixels[i] = col;
    }

    public RGBImage(RGBImage image) {
      this(image.width, image.height, copyPixels(image.pixels));
    }

    public RGBImage(int width, int height, Color color) {
      this(width, height, new RGB(color));
    }

    public RGBImage(File file) throws IOException {
      this(javax.imageio.ImageIO.read(file));
    }

    public static int[] copyPixels(int[] pixels) {
      int[] copy = new int[pixels.length];
      System.arraycopy(pixels, 0, copy, 0, pixels.length);
      return copy;
    }

    public int getIntPixel(int x, int y) {
      if (inRange(x, y))
        return pixels[y * width + x];
      else
        return 0xFFFFFF;
    }

    public static RGB asRGB(int packed) {
      int r = (packed >> 16) & 0xFF;
      int g = (packed >> 8) & 0xFF;
      int b = packed & 0xFF;
      return new RGB(r / 255f, g / 255f, b / 255f);
    }

    public RGB getRGB(int x, int y) {
      if (inRange(x, y))
        return asRGB(pixels[y * width + x]);
      else
        return new RGB(0xFFFFFF);
    }

    public RGB getPixel(int x, int y) {
      return getRGB(x, y);
    }

    public RGB getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    public int getWidth() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int w() {
      return width;
    }

    public int h() {
      return height;
    }

    public BufferedImage getBufferedImage() {
      if (bufferedImage == null) {
        bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) bufferedImage.setRGB(x, y, pixels[y * width + x]);
      }
      return bufferedImage;
    }

    public RGBImage clip(Rect r) {
      return r == null ? null : clip(r.getRectangle());
    }

    public RGBImage clip(Rectangle r) {
      r = fixClipRect(r);
      if (r.x == 0 && r.y == 0 && r.width == width && r.height == height)
        return this;
      int[] newPixels;
      try {
        newPixels = new int[r.width * r.height];
      } catch (RuntimeException e) {
        System.out.println(r);
        throw e;
      }
      for (int y = 0; y < r.height; y++) {
        System.arraycopy(pixels, (y + r.y) * width + r.x, newPixels, y * r.width, r.width);
      }
      return new RGBImage(r.width, r.height, newPixels);
    }

    public final Rectangle fixClipRect(Rectangle r) {
      r = r.intersection(new Rectangle(0, 0, width, height));
      if (r.isEmpty())
        r = new Rectangle(r.x, r.y, 0, 0);
      return r;
    }

    public File getFile() {
      return file;
    }

    public static RGBImage load(String fileName) {
      return load(new File(fileName));
    }

    public static RGBImage load(File file) {
      try {
        BufferedImage bufferedImage = javax.imageio.ImageIO.read(file);
        return new RGBImage(bufferedImage);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    public int getInt(int x, int y) {
      return pixels[y * width + x];
    }

    public void save(File file) throws IOException {
      String name = file.getName().toLowerCase();
      String type;
      if (name.endsWith(".png"))
        type = "png";
      else if (name.endsWith(".jpg") || name.endsWith(".jpeg"))
        type = "jpeg";
      else
        throw new IOException("Unknown image extension: " + name);
      javax.imageio.ImageIO.write(getBufferedImage(), type, file);
    }

    public static RGBImage dummyImage() {
      return new RGBImage(1, 1, new int[] { 0xFFFFFF });
    }

    public int[] getPixels() {
      return pixels;
    }

    public void setPixel(int x, int y, int r, int g, int b) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = (limitToUByte(r) << 16) | (limitToUByte(g) << 8) | limitToUByte(b);
    }

    public void setPixel(int x, int y, RGB rgb) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = rgb.asInt();
    }

    public void setPixel(int x, int y, Color color) {
      setPixel(x, y, new RGB(color));
    }

    public void setInt(int x, int y, int rgb) {
      setPixel(x, y, rgb);
    }

    public void setPixel(int x, int y, int rgb) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = rgb;
    }

    public void setPixel(Pt p, RGB rgb) {
      setPixel(p.x, p.y, rgb);
    }

    public void setPixel(Pt p, Color color) {
      setPixel(p.x, p.y, color);
    }

    public RGBImage copy() {
      return new RGBImage(this);
    }

    public boolean inRange(int x, int y) {
      return x >= 0 && y >= 0 && x < width && y < height;
    }

    public Dimension getSize() {
      return new Dimension(width, height);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o)
        return true;
      if (o == null || getClass() != o.getClass())
        return false;
      RGBImage rgbImage = (RGBImage) o;
      if (height != rgbImage.height)
        return false;
      if (width != rgbImage.width)
        return false;
      if (!Arrays.equals(pixels, rgbImage.pixels))
        return false;
      return true;
    }

    @Override
    public int hashCode() {
      int result = width;
      result = 31 * result + height;
      result = 31 * result + Arrays.hashCode(pixels);
      return result;
    }

    public String getHex(int x, int y) {
      return getPixel(x, y).getHexString();
    }

    public RGBImage clip(int x, int y, int width, int height) {
      return clip(new Rectangle(x, y, width, height));
    }

    public RGBImage clipLine(int y) {
      return clip(0, y, width, 1);
    }

    public int numPixels() {
      return width * height;
    }
  }

  public static interface MakesBufferedImage {

    public BufferedImage getBufferedImage();

    public int getWidth();

    public int getHeight();
  }

  public static class Rect {

    public int x, y, w, h;

    public Rect() {
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public Rect(Pt p, int w, int h) {
      this.h = h;
      this.w = w;
      x = p.x;
      y = p.y;
    }

    public Rect(Rect r) {
      x = r.x;
      y = r.y;
      w = r.w;
      h = r.h;
    }

    public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    public int x2() {
      return x + w;
    }

    public int y2() {
      return y + h;
    }

    public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    public boolean empty() {
      return w <= 0 || h <= 0;
    }
  }

  public static class Pt {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + ", " + y;
    }
  }

  public static class RGB {

    public float r, g, b;

    public RGB() {
    }

    public RGB(float r, float g, float b) {
      this.r = r;
      this.g = g;
      this.b = b;
    }

    public RGB(double r, double g, double b) {
      this.r = (float) r;
      this.g = (float) g;
      this.b = (float) b;
    }

    public RGB(int rgb) {
      this(new Color(rgb));
    }

    public RGB(double brightness) {
      this.r = this.g = this.b = max(0f, min(1f, (float) brightness));
    }

    public RGB(Color color) {
      this.r = color.getRed() / 255f;
      this.g = color.getGreen() / 255f;
      this.b = color.getBlue() / 255f;
    }

    public RGB(String hex) {
      int i = l(hex) - 6;
      r = Integer.parseInt(hex.substring(i, i + 2), 16) / 255f;
      g = Integer.parseInt(hex.substring(i + 2, i + 4), 16) / 255f;
      b = Integer.parseInt(hex.substring(i + 4, i + 6), 16) / 255f;
    }

    public float getComponent(int i) {
      return i == 0 ? r : i == 1 ? g : b;
    }

    public Color getColor() {
      return new Color(r, g, b);
    }

    public static RGB newSafe(float r, float g, float b) {
      return new RGB(Math.max(0, Math.min(1, r)), Math.max(0, Math.min(1, g)), Math.max(0, Math.min(1, b)));
    }

    public int asInt() {
      return getColor().getRGB() & 0xFFFFFF;
    }

    public int getInt() {
      return getColor().getRGB() & 0xFFFFFF;
    }

    public float getBrightness() {
      return (r + g + b) / 3.0f;
    }

    public String getHexString() {
      return Integer.toHexString(asInt() | 0xFF000000).substring(2).toUpperCase();
    }

    @Override
    public boolean equals(Object o) {
      if (this == o)
        return true;
      if (!(o instanceof RGB))
        return false;
      RGB rgb = (RGB) o;
      if (Float.compare(rgb.b, b) != 0)
        return false;
      if (Float.compare(rgb.g, g) != 0)
        return false;
      if (Float.compare(rgb.r, r) != 0)
        return false;
      return true;
    }

    @Override
    public int hashCode() {
      int result = (r != +0.0f ? Float.floatToIntBits(r) : 0);
      result = 31 * result + (g != +0.0f ? Float.floatToIntBits(g) : 0);
      result = 31 * result + (b != +0.0f ? Float.floatToIntBits(b) : 0);
      return result;
    }

    public boolean isBlack() {
      return r == 0f && g == 0f && b == 0f;
    }

    public boolean isWhite() {
      return r == 1f && g == 1f && b == 1f;
    }

    public String toString() {
      return getHexString();
    }

    public int redInt() {
      return iround(r * 255);
    }

    public int greenInt() {
      return iround(g * 255);
    }

    public int blueInt() {
      return iround(b * 255);
    }
  }

  public static long longMul(long a, long b) {
    return a * b;
  }

  public static RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  public static RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  public static RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  public static RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  public static RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  public static int[] pixelsOfBufferedImage(BufferedImage image) {
    try {
      int width = image.getWidth();
      int height = image.getHeight();
      int[] pixels = new int[width * height];
      PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
      if (!pixelGrabber.grabPixels())
        throw fail("Could not grab pixels");
      return pixels;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static double averageBrightness(BufferedImage img) {
    return new BWImage(img).averageBrightness();
  }

  public static double doubleRatio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  public static <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  public static <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  public static boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  public static Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  public static Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  public static Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  public static Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  public static Object get(String field, Object o) {
    return get(o, field);
  }

  public static BufferedImage integralImageToBufferedImage(IntegralImage img) {
    if (img == null)
      return null;
    int w = img.w, h = img.h;
    BufferedImage out = newBufferedImage(w, h);
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) {
      int r = integralImage_sumRect(img, x, y, x + 1, y + 1, 0);
      int g = integralImage_sumRect(img, x, y, x + 1, y + 1, 1);
      int b = integralImage_sumRect(img, x, y, x + 1, y + 1, 2);
      out.setRGB(x, y, (r << 16) | (g << 8) | b);
    }
    return out;
  }

  public static boolean inRange(int x, int n) {
    return x >= 0 && x < n;
  }

  public static boolean inRange(int x, int a, int b) {
    return x >= a && x < b;
  }

  public static int limitToUByte(int i) {
    return max(0, min(255, i));
  }

  public static Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  public static int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  public static boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  public static boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  public static boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  public static boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  public static boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  public static int max(int a, int b) {
    return Math.max(a, b);
  }

  public static int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  public static long max(int a, long b) {
    return Math.max((long) a, b);
  }

  public static long max(long a, long b) {
    return Math.max(a, b);
  }

  public static double max(int a, double b) {
    return Math.max((double) a, b);
  }

  public static float max(float a, float b) {
    return Math.max(a, b);
  }

  public static double max(double a, double b) {
    return Math.max(a, b);
  }

  public static int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  public static double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  public static short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  public static int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  public static int min(int a, int b) {
    return Math.min(a, b);
  }

  public static long min(long a, long b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  public static double min(double a, double b) {
    return Math.min(a, b);
  }

  public static double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  public static float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  public static byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  public static short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  public static int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  public static int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  public static int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  public static int l(Map m) {
    return m == null ? 0 : m.size();
  }

  public static int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  public static long l(File f) {
    return f == null ? 0 : f.length();
  }

  public static int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : o instanceof Object[] ? l((Object[]) o) : o instanceof boolean[] ? l((boolean[]) o) : o instanceof byte[] ? l((byte[]) o) : o instanceof char[] ? l((char[]) o) : o instanceof short[] ? l((short[]) o) : o instanceof int[] ? l((int[]) o) : o instanceof float[] ? l((float[]) o) : o instanceof double[] ? l((double[]) o) : o instanceof long[] ? l((long[]) o) : (Integer) call(o, "size");
  }

  public static int asInt(Object o) {
    return toInt(o);
  }

  public static int iround(double d) {
    return (int) Math.round(d);
  }

  public static int iround(Number n) {
    return iround(toDouble(n));
  }

  public static RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  public static Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  public static Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  public static Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  public static BufferedImage newBufferedImage(int w, int h) {
    return new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
  }

  public static BufferedImage newBufferedImage(int w, int h, RGB rgb) {
    return newBufferedImage(w, h, toColor(rgb));
  }

  public static BufferedImage newBufferedImage(int w, int h, Color color) {
    BufferedImage img = newBufferedImage(w, h);
    Graphics2D g = img.createGraphics();
    g.setColor(color);
    g.fillRect(0, 0, w, h);
    return img;
  }

  public static BufferedImage newBufferedImage(Pt p, Color color) {
    return newBufferedImage(p.x, p.y, color);
  }

  public static int integralImage_sumRect(IntegralImage img, int x1, int y1, int x2, int y2, int channel) {
    int bottomLeft = img.get(x1 - 1, y2 - 1, channel);
    int bottomRight = img.get(x2 - 1, y2 - 1, channel);
    int topLeft = img.get(x1 - 1, y1 - 1, channel);
    int topRight = img.get(x2 - 1, y1 - 1, channel);
    return bottomRight + topLeft - topRight - bottomLeft;
  }

  public static String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  public static Set<String> allFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  public static boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  public static Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  public static String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  public static String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  public static boolean eq(Object a, Object b) {
    return a == b || (a == null ? b == null : b != null && a.equals(b));
  }

  public static <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object call(Object o) {
    return callF(o);
  }

  public static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  public static Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  public static int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    throw fail("woot not int: " + getClassName(o));
  }

  public static int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  public static double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  public static void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  public static void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll(vm_busListeners_live(), msg, arg);
    pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  public static void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  public static Color toColor(RGB rgb) {
    return rgb == null ? null : rgb.getColor();
  }

  public static Color toColor(int rgb) {
    return new Color(rgb);
  }

  public static Color toColor(String hex) {
    return awtColor(hex);
  }

  public static Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  public static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  public static HashMap getOpt_special;

  public static Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  public static String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  public static int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  public static int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  public static String str(char[] c) {
    return new String(c);
  }

  public static Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  public static <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  public static Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMC((String) f, args);
      if (f instanceof Runnable) {
        ((Runnable) f).run();
        return null;
      }
      if (f == null)
        return null;
      Class c = f.getClass();
      ArrayList<Method> methods;
      synchronized (callF_cache) {
        methods = callF_cache.get(c);
        if (methods == null)
          methods = callF_makeCache(c);
      }
      int n = l(methods);
      if (n == 0) {
        throw fail("No get method in " + getClassName(c));
      }
      if (n == 1)
        return invokeMethod(methods.get(0), f, args);
      for (int i = 0; i < n; i++) {
        Method m = methods.get(i);
        if (call_checkArgs(m, args, false))
          return invokeMethod(m, f, args);
      }
      throw fail("No matching get method in " + getClassName(c));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  public static Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found in " + c);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static int parseInt(String s) {
    return empty(s) ? 0 : Integer.parseInt(s);
  }

  public static int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  public static Class javax() {
    return getJavaX();
  }

  public static Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  public static void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  public static void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  public static Set vm_busListeners_live_cache;

  public static Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  public static Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  public static Map<String, Set> vm_busListenersByMessage_live_cache;

  public static Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  public static Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  public static java.awt.Color awtColor(String hex) {
    byte[] b = bytesFromHex(dropPrefix("#", hex));
    return new Color(ubyteToInt(b[0]), ubyteToInt(b[1]), ubyteToInt(b[2]));
  }

  public static void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  public static <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  public static <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  public static List<Pair> _registerDangerousWeakMap_preList;

  public static <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  public static <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  public static void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  public static Map synchroMap() {
    return synchroHashMap();
  }

  public static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  public static <A, B> B mapGet2(Map<A, B> map, A a) {
    return map == null ? null : map.get(a);
  }

  public static <A, B> B mapGet2(A a, Map<A, B> map) {
    return map == null ? null : map.get(a);
  }

  public static boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  public static Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  public static Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  public static <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  public static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  public static HashMap<String, List<Method>> callMC_cache = new HashMap();

  public static String callMC_key;

  public static Method callMC_value;

  public static Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  public static Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with matching arguments found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  public static Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  public static final Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  public static Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static _MethodCache callOpt_getCache(Class c) {
    synchronized (callOpt_cache) {
      _MethodCache cache = callOpt_cache.get(c);
      if (cache == null)
        callOpt_cache.put(c, cache = new _MethodCache(c));
      return cache;
    }
  }

  public static boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  public static Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  public static <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  public static String joinWithComma(String... c) {
    return join(", ", c);
  }

  public static String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  public static List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  public static List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  public static boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  public static boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  public static boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  public static boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  public static boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  public static boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  public static boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  public static Class __javax;

  public static Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  public static <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  public static Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  public static <A> void pcallF(VF1<A> f, A a) {
    try {
      if (f != null)
        f.get(a);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  public static Set vm_generalIdentityHashSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  public static Map vm_generalHashMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  public static byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  public static String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  public static int ubyteToInt(byte b) {
    return b & 0x0FF;
  }

  public static <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  public static <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  public static <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  public static <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  public static <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  public static <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  public static Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  public static <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  public static Class mc() {
    return ii.class;
  }

  public static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  public static Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  public static String joinWithSpace(Collection<String> c) {
    return join(" ", c);
  }

  public static String joinWithSpace(String... c) {
    return join(" ", c);
  }

  public static volatile StringBuffer local_log = new StringBuffer();

  public static volatile Appendable print_log = local_log;

  public static volatile int print_log_max = 1024 * 1024;

  public static volatile int local_log_max = 100 * 1024;

  public static boolean print_silent = false;

  public static Object print_byThread_lock = new Object();

  public static volatile ThreadLocal<Object> print_byThread;

  public static volatile Object print_allThreads;

  public static volatile Object print_preprocess;

  public static void print() {
    print("");
  }

  public static <A> A print(String s, A o) {
    print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
    return o;
  }

  public static <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = String.valueOf(o) + "\n";
    print_noNewLine(s);
    return o;
  }

  public static void print_noNewLine(String s) {
    Object f = getThreadLocal(print_byThread_dontCreate());
    if (f == null)
      f = print_allThreads;
    if (f != null)
      if (isFalse(callF(f, s)))
        return;
    print_raw(s);
  }

  public static void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
  }

  public static void print_autoRotate() {
  }

  public static boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  public static boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  public static boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  public static void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, min(a.length, b.length));
  }

  public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  public static <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  public static <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first(((Collection) strings)));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  public static <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  public static String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  public static List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  public static String getType(Object o) {
    return getClassName(o);
  }

  public static long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  public static long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  public static <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  public static ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  public static ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  public static <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  public static <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  public static Object collectionMutex(List l) {
    return l;
  }

  public static Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  public static Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  public static volatile PersistableThrowable _handleException_lastException;

  public static List _handleException_onException = synchroList(ll("printStackTrace2"));

  public static void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
      return;
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      printStackTrace2(e3);
    }
  }

  public static Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  public static Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  public static <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  public static Map syncHashMap() {
    return synchroHashMap();
  }

  public static byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  public static void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  public static boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  public static boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  public static <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  public static boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  public static void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  public static Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  public static <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  public static <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  public static ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  public static boolean isFalse(Object o) {
    return eq(false, o);
  }

  public static String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  public static void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  public static Object first(Object list) {
    return first((Iterable) list);
  }

  public static <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  public static <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  public static <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  public static <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  public static Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  public static <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  public static Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  public static void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  public static void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  public static ArrayList emptyList() {
    return new ArrayList();
  }

  public static ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  public static ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  public static ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  public static <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  public static String className(Object o) {
    return getClassName(o);
  }

  public static boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  public static Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  public static <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  public static PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  public static Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  public static Map vm_generalMap_map;

  public static Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  public static <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  public static <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  public static <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  public static <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  public static boolean odd(int i) {
    return (i & 1) != 0;
  }

  public static boolean odd(long i) {
    return (i & 1) != 0;
  }

  public static boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  public static String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  public static String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  public static void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  public static int shorten_default = 100;

  public static String shorten(String s) {
    return shorten(s, shorten_default);
  }

  public static String shorten(String s, int max) {
    return shorten(s, max, "...");
  }

  public static String shorten(String s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return s;
    return s.length() <= max ? s : substring(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  public static String shorten(int max, String s) {
    return shorten(s, max);
  }

  public static int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  public static String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  public static String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.substring(x, y);
  }

  public static volatile boolean ping_pauseAll = false;

  public static int ping_sleep = 100;

  public static volatile boolean ping_anyActions = false;

  public static Map<Thread, Object> ping_actions = newWeakHashMap();

  public static ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  public static boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  public static boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  public static <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  public static <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  public static <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  public static int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  public static int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  public static int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  public static int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  public static int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  public static int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  public static <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  public static void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  public static Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  public static Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  public static <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }

  public static int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  public static int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  public static int strL(String s) {
    return s == null ? 0 : s.length();
  }

  public static <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  public static boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  public static boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  public static boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  public static void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  public static Thread currentThread() {
    return Thread.currentThread();
  }

  public static String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  public static String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  public static String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  public static String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  public static String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  public static String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  public static Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  public static String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  public static Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  public static Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  public static char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  public static List _registerWeakMap_preList;

  public static <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  public static void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  public static int isAndroid_flag;

  public static boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  public static Boolean isHeadless_cache;

  public static boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static volatile boolean licensed_yes = true;

  public static boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  public static void licensed_off() {
    licensed_yes = false;
  }

  public static boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  public static boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  public static String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static volatile PersistableThrowable lastException_lastException;

  public static PersistableThrowable lastException() {
    return lastException_lastException;
  }

  public static void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  public static boolean startsWith(String a, String b) {
    return a != null && a.startsWith(b);
  }

  public static boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  public static boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  public static char firstChar(String s) {
    return s.charAt(0);
  }

  public static <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  public static boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  public static String theAGIBlueDomain() {
    return "agi.blue";
  }

  public static boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  public static int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  public static <A extends Throwable> A printStackTrace(A e) {
    print(getStackTrace(e));
    return e;
  }

  public static void printStackTrace() {
    printStackTrace(new Throwable());
  }

  public static void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  public static void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  public static boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  public static boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  public static boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  public static String asString(Object o) {
    return o == null ? null : o.toString();
  }

  public static boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  public static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  public static final class _MethodCache {

    public final Class c;

    public final HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      while (_c != null) {
        for (Method m : _c.getDeclaredMethods()) if (!reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if (m.isDefault() && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  public abstract static class VF1<A> implements IVF1<A> {

    public abstract void get(A a);
  }

  public static class PersistableThrowable {

    public String className;

    public String msg;

    public String stacktrace;

    public PersistableThrowable() {
    }

    public PersistableThrowable(Throwable e) {
      if (e == null)
        className = "Crazy Null Error";
      else {
        className = getClassName(e).replace('/', '.');
        msg = e.getMessage();
        stacktrace = getStackTrace_noRecord(e);
      }
    }

    public String toString() {
      return nempty(msg) ? className + ": " + msg : className;
    }
  }

  public static final class BWImage implements MakesBufferedImage, IBWImage {

    public int width, height;

    public byte[] pixels;

    public float borderColor = 0.0f;

    public BWImage() {
    }

    public BWImage(int width, int height) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
    }

    public BWImage(int width, int height, float brightness) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
      fillArrayUnlessZero(pixels, _toByte(brightness));
    }

    public BWImage(int width, int height, float[] pixels) {
      this.pixels = new byte[pixels.length];
      this.height = height;
      this.width = width;
      for (int i = 0; i < pixels.length; i++) this.pixels[i] = _toByte(pixels[i]);
    }

    public BWImage(int width, int height, byte[] pixels) {
      this.height = height;
      this.width = width;
      this.pixels = pixels;
    }

    public BWImage(BWImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) pixels[y * width + x] = image.getByte(x, y);
    }

    public BWImage(RGBImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[height * width];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        pixels[y * width + x] = BWImage._toByte(rgb.getBrightness());
      }
    }

    public BWImage(BufferedImage image) {
      try {
        width = image.getWidth();
        height = image.getHeight();
        int[] pixels = new int[width * height];
        byte[] bytePixels = this.pixels = new byte[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        if (!pixelGrabber.grabPixels())
          throw fail("Could not grab pixels");
        int n = width * height;
        for (int i = 0; i < n; i++) {
          int packed = pixels[i];
          int r = ((packed >> 16) & 0xFF);
          int g = ((packed >> 8) & 0xFF);
          int b = (packed & 0xFF);
          bytePixels[i] = (byte) ((r + g + b + 1) / 3);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public static byte pixelToByte(int packed) {
      float r = ((packed >> 16) & 0xFF) / 255f;
      float g = ((packed >> 8) & 0xFF) / 255f;
      float b = (packed & 0xFF) / 255f;
      return (byte) ((r + g + b) / 3.0f * 255f);
    }

    public byte getByte(int x, int y) {
      return inRange(x, y) ? getByte_noRangeCheck(x, y) : _toByte(borderColor);
    }

    public int getInt(int x, int y) {
      return ubyteToInt(getByte(x, y));
    }

    public double averageBrightness() {
      double sum = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) sum += getPixel(x, y);
      return (sum / (double) (height * width));
    }

    public float minimumBrightness() {
      float min = 1;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) min = Math.min(min, getPixel(x, y));
      return min;
    }

    public float maximumBrightness() {
      float max = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) max = Math.max(max, getPixel(x, y));
      return max;
    }

    public float getPixel(int x, int y) {
      return inRange(x, y) ? _toFloat(getByte(x, y)) : borderColor;
    }

    public float getFloatPixel(int x, int y) {
      return getPixel(x, y);
    }

    public float getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    public static byte _toByte(float pixel) {
      return (byte) (pixel * 255f);
    }

    public static float _toFloat(byte pixel) {
      return (((int) pixel) & 255) / 255f;
    }

    public final boolean inRange(int x, int y) {
      return x >= 0 && x < width && y >= 0 && y < height;
    }

    public int getWidth() {
      return width;
    }

    public int w() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int h() {
      return height;
    }

    public RGBImage toRGB() {
      int[] rgbs = new int[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = getByte(x, y) & 0xFF;
        rgbs[y * width + x] = 0xFF000000 | b * 0x010101;
      }
      return new RGBImage(width, height, rgbs);
    }

    public RGBImage toRGB_slow() {
      RGB[] rgbs = new RGB[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y * width + x] = new RGB(p, p, p);
      }
      return new RGBImage(width, height, rgbs);
    }

    public BWImage clip(int x, int y, int w, int h) {
      return clip(new Rectangle(x, y, w, h));
    }

    public final Rectangle fixClipRect(Rectangle r) {
      return r.intersection(new Rectangle(0, 0, width, height));
    }

    public BWImage clip(Rect r) {
      return clip(r.getRectangle());
    }

    public BWImage clip(Rectangle r) {
      r = fixClipRect(r);
      byte[] newPixels = new byte[r.height * r.width];
      for (int y = 0; y < r.height; y++) for (int x = 0; x < r.width; x++) newPixels[y * r.width + x] = getByte(r.x + x, r.y + y);
      return new BWImage(r.width, r.height, newPixels);
    }

    public void setPixel(int x, int y, float brightness) {
      setByte(x, y, _toByte(fixPixel(brightness)));
    }

    public void setInt(int x, int y, int i) {
      setByte(x, y, (byte) limitToUByte(i));
    }

    public void setByte(int x, int y, byte b) {
      if (x >= 0 && x < width && y >= 0 && y < height)
        pixels[y * width + x] = b;
    }

    public byte getByte_noRangeCheck(int x, int y) {
      return pixels[y * width + x];
    }

    public void setByte(int x, int y, int brightness) {
      setByte(x, y, (byte) brightness);
    }

    public final float fixPixel(float pixel) {
      return Math.max(0, Math.min(1, pixel));
    }

    public float getBorderColor() {
      return borderColor;
    }

    public void setBorderColor(float borderColor) {
      this.borderColor = borderColor;
    }

    public boolean anyPixelBrighterThan(double threshold) {
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) if (getPixel(x, y) > threshold)
        return true;
      return false;
    }

    public BufferedImage getBufferedImage() {
      BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = ((int) getByte(x, y) & 0xFF);
        bufferedImage.setRGB(x, y, b * 0x010101);
      }
      return bufferedImage;
    }

    public byte[] getBytes() {
      return pixels;
    }
  }

  public static class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  public static interface IBWImage {

    public int getWidth();

    public int getHeight();

    public float getFloatPixel(int x, int y);
  }

  public static interface IVF1<A> {

    public void get(A a);
  }

  public static boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  public static Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  public static void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  public static Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  public static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  public static boolean nempty(Collection c) {
    return !empty(c);
  }

  public static boolean nempty(CharSequence s) {
    return !empty(s);
  }

  public static boolean nempty(Object[] o) {
    return !empty(o);
  }

  public static boolean nempty(byte[] o) {
    return !empty(o);
  }

  public static boolean nempty(int[] o) {
    return !empty(o);
  }

  public static boolean nempty(Map m) {
    return !empty(m);
  }

  public static boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  public static boolean nempty(Object o) {
    return !empty(o);
  }

  public static void fillArrayUnlessZero(byte[] a, byte value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  public static void fillArrayUnlessZero(int[] a, int value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  public static void fillArrayUnlessZero(float[] a, float value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  public static int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache(((Class) o));
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }
}
