//FILENAME: agiBlue/dblib.java
package agiBlue;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import java.text.*;
import java.text.NumberFormat;
import java.util.TimeZone;
import javax.net.ssl.*;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;

public class dblib {

  public static class Slice extends Concept {

    public static String _fieldOrder = "globalID caseID name indexed sliceDumped owner";

    public GlobalID globalID = aGlobalIDObject();

    public String caseID;

    public String name;

    public boolean indexed = true;

    public long sliceDumped;

    public Ref<User> owner = new Ref();

    public String defaultCaseID() {
      return uniqueFileNameUsingMD5_80_v2(name + " " + globalID);
    }

    public GlobalID globalID() {
      return globalID;
    }
  }

  public static class Page extends Concept {

    public long gID_1;

    public short gID_2;

    {
      setGlobalID(aGlobalIDObj());
    }

    public void setGlobalID(GlobalID id) {
      if (id == null) {
        gID_1 = gID_2 = 0;
        return;
      }
      gID_1 = globalIDPart1(id);
      gID_2 = globalIDPart2(id);
    }

    public void setGlobalID(String id) {
      setGlobalID(toGlobalIDObj(id));
    }

    public GlobalID globalID() {
      return globalIDFromParts(gID_1, gID_2);
    }

    public String q;

    public void _onLoad() {
      String id = cget(this, "globalID");
      if (id != null) {
        setGlobalID(id);
        cset(this, "globalID", null);
      }
    }

    public void quickPost(String key, String value) {
      agiBlue().new GetEntriesAndPost(_concepts).go(this, litmap("key", key, "value", value));
    }

    public AGIBlue agiBlue() {
      return (AGIBlue) mapGet(_concepts.miscMap, "agiBlue");
    }
  }

  public abstract static class AbstractEntry extends Concept {

    public static String _fieldOrder = "page count key ip signer";

    public Ref<Page> page = new Ref();

    public int count;

    public String key;

    public String ip;

    public Ref<Signer> signer = new Ref();

    public String q() {
      Page p = page.get();
      return p == null ? null : page.get().q;
    }
  }

  public static class Entry extends AbstractEntry {

    public String globalID = aGlobalID();

    public String value;
  }

  public static class MultiLineEntry extends AbstractEntry {

    public GlobalID globalID = aGlobalIDObject();

    public String value;
  }

  public static class BlobEntry extends AbstractEntry {

    public GlobalID globalID = aGlobalIDObject();

    public long length;

    public String md5;
  }

  public static class Signer extends Concept {

    public static String _fieldOrder = "globalID publicKey trusted approvedBy";

    public String globalID = aGlobalID();

    public String publicKey;

    public boolean trusted = false;

    public String approvedBy;
  }

  public static class User extends Concept {

    public GlobalID globalID = aGlobalIDObject();

    public long lastSeen;
  }

  public static class CookieUser extends User {

    public String cookie;

    public String toString() {
      return "[cookieUser]";
    }
  }

  public static class GoogleUser extends User {

    public static String _fieldOrder = "googleLogInDate googleEmail googleFirstName googleLastName googleEmailVerified";

    public long googleLogInDate;

    public String googleEmail, googleFirstName, googleLastName;

    public boolean googleEmailVerified = false;

    public String toString() {
      return googleFirstName + " " + googleLastName;
    }
  }

  public static class MinimalUser extends User {

    public static String _fieldOrder = "userName encryptedPassword";

    public String userName, encryptedPassword;

    public String toString() {
      return "[minimalUser] " + userName;
    }
  }

  public static class Session extends Concept {

    public String cookie;

    public String selectedSlice;

    public Page slicePage;

    public Ref<User> user = new Ref();
  }

  public static class SliceInfo extends Concept {

    public GlobalID globalID;

    public List<String> mandatoryBotVMBusIDs;
  }

  public static class CentralIndexEntry {

    public Set<Slice> slices = synchroLinkedHashSet();
  }

  public abstract static class AGIBlue {

    public boolean asyncSearch = false;

    public boolean allowMultipleCasesInValues = true;

    public boolean showSliceSelector = true;

    public boolean showGoogleLogIn = true;

    public boolean makeAllKeysPages = true;

    public boolean makeAllValuesPages = true;

    public boolean legacy = true;

    public boolean dumpSlicesOnAnyChange = true;

    public int maxSliceNameLength = 1024;

    public int displayLength = 140;

    public int sideDisplayLength = 50;

    public int searchResultsToShow = 50;

    public String sideSearchType = "literal";

    public int maxBackgroundSlices = 1000;

    public abstract void dumpSliceToFile(LoadedSlice slice);

    public abstract Page pageFromQ(Concepts cc, String q);

    public abstract void makeCentralIndex();

    public abstract void dbLog(Object... params);

    public class LoadedSlice {

      public String caseID;

      public Concepts cc;

      public Slice sliceConcept;

      public long lastAccess = sysNow();

      public ReliableSingleThread rstDumpSlice = new ReliableSingleThread(new Runnable() {

        public void run() {
          try {
            dumpSliceToFile(LoadedSlice.this);
            rst_index.trigger();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "dumpSliceToFile(LoadedSlice.this);\r\n      rst_index.trigger(); // rebuild ind...";
        }
      });

      public boolean haltSliceDumping = false;

      public ConceptFieldIndexDesc idx_latestEntries, idx_latestCreatedPages, idx_latestChangedPages;

      public LoadedSlice(String caseID, Concepts cc) {
        this.cc = cc;
        this.caseID = caseID;
        csetAll(list(cc, Page.class), "slice", null, "url", null);
        releaseEmptyFieldValuesOfAllConcepts(cc);
        indexThings();
        onConceptsChange(cc, rOnceAtATimeOnly(new Runnable() {

          public void run() {
            try {
              cset(sliceConcept, "_modified", now());
              if (!haltSliceDumping && dumpSlicesOnAnyChange && nempty(caseID)) {
                rstDumpSlice.trigger();
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "cset(sliceConcept, _modified := now())\r\n  ;\r\n        if (!haltSliceDumping &&...";
          }
        }));
        if (makeAllKeysPages && legacy)
          for (Entry e : list(cc, Entry.class)) pageFromQ(e.key);
        if (makeAllValuesPages && legacy)
          for (Entry e : list(cc, Entry.class)) pageFromQ(e.value);
      }

      public void initialSetup(GlobalID globalID) {
        SliceInfo info = uniq(cc, SliceInfo.class);
        cset(info, "globalID", globalID);
      }

      public Page pageFromQ(String q) {
        return AGIBlue.this.pageFromQ(cc, q);
      }

      public void indexThings() {
        indexConceptFieldsCI(cc, Page.class, "q", Entry.class, "key", Entry.class, "value");
        indexConceptFields(cc, Signer.class, "publicKey");
        indexConceptFields(cc, Session.class, "cookie");
        indexSingletonConcept(cc, SliceInfo.class);
        idx_latestCreatedPages = new ConceptFieldIndexDesc(cc, Page.class, "created");
        idx_latestChangedPages = new ConceptFieldIndexDesc(cc, Page.class, "_modified");
        idx_latestEntries = new ConceptFieldIndexDesc(cc, Entry.class, "created");
      }

      public boolean isMainSlice() {
        return empty(caseID);
      }

      public GlobalID globalID() {
        return sliceConcept.globalID;
      }

      public String name() {
        return sliceConcept.name;
      }
    }

    public ConceptsLoadedOnDemand fan;

    public ConceptsLoadedOnDemand backgroundFan;

    public Map<String, LoadedSlice> loadedSlices = syncMap();

    public Map<String, LoadedSlice> backgroundSlices = syncMap();

    public Map<String, CentralIndexEntry> centralIndex = ciMap();

    public Map<String, CentralIndexEntry> newCentralIndex = ciMap();

    public long centralIndexMade;

    public long centralIndexMadeIn;

    public ReliableSingleThread rst_index = new ReliableSingleThread(new Runnable() {

      public void run() {
        try {
          makeCentralIndex();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "makeCentralIndex();";
      }
    });

    public ConceptFieldIndexDesc idx_slicesByModification, idx_usersBySeen;

    public ConceptFieldIndexCI idx_slicesByName, idx_usersByName;

    public class GetEntriesAndPost {

      public Concepts cc;

      public List<Entry> entries;

      public Entry entry;

      public boolean newEntry = false;

      public Signer signer;

      public GetEntriesAndPost(Concepts cc) {
        this.cc = cc;
      }

      public GetEntriesAndPost go(Page page, Map<String, String> params) {
        String key = trim(params.get("key")), value = trim(params.get("value"));
        print("GetEntriesAndPost: " + quote(page.q) + ", " + quote(key) + " := " + quote(value));
        {
          withDBLock(new Runnable() {

            public void run() {
              try {
                entries = findBackRefs(page, Entry.class);
                if (nempty(key) && nempty(value)) {
                  String ip = subBot_clientIP();
                  entry = firstThat(e -> eqic(e.key, key) && eq_icIf(!allowMultipleCasesInValues, e.value, value) && eq(e.ip, ip), entries);
                  if (entry == null) {
                    print("SAVING");
                    Entry e = cnew(cc, Entry.class, "page", page, "key", key, "value", value, "ip", ip, "count", l(entries) + 1, "signer", signer);
                    if (makeAllKeysPages)
                      pageFromQ(cc, key);
                    if (makeAllValuesPages)
                      pageFromQ(cc, value);
                    page.change();
                    entry = e;
                    newEntry = true;
                    entries.add(entry);
                    dbLog("New entry", "page", page.q, "globalID", e.globalID, "count", e.count, "key", key, "value", value);
                  }
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "entries = findBackRefs(page, Entry);\r\n        if (nempty(key) && nempty(value...";
            }
          });
        }
        sortByFieldInPlace("created", entries);
        numberEntriesInConceptField("count", entries);
        return this;
      }
    }
  }

  public static GlobalID aGlobalIDObject() {
    return aGlobalIDObj();
  }

  public static String uniqueFileNameUsingMD5_80_v2(String fullName) {
    return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
  }

  public static String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
    return takeFirst(80 - 33, fileNameEncode(fullName)) + " - " + md5;
  }

  public static GlobalID aGlobalIDObj() {
    return asGlobalID(randomID(16));
  }

  public static long globalIDPart1(GlobalID id) {
    return id == null ? 0 : id.a;
  }

  public static short globalIDPart2(GlobalID id) {
    return id == null ? 0 : (short) id.b;
  }

  public static GlobalID toGlobalIDObj(String s) {
    return s == null ? null : new GlobalID(s);
  }

  public static GlobalID toGlobalIDObj(GlobalID globalID) {
    return globalID;
  }

  public static GlobalID globalIDFromParts(long a, short b) {
    GlobalID id = new GlobalID();
    id.a = a;
    id.b = b;
    return id;
  }

  public static <A> A cget(Object c, String field) {
    Object o = getOpt(c, field);
    if (o instanceof Concept.Ref)
      return (A) ((Concept.Ref) o).get();
    return (A) o;
  }

  public static <A> A cget(String field, Object c) {
    return cget(c, field);
  }

  public static int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      int changes = 0;
      values = expandParams(c.getClass(), values);
      warnIfOddCount(values);
      for (int i = 0; i + 1 < l(values); i += 2) {
        String field = (String) values[i];
        Object value = values[i + 1];
        Field f = setOpt_findField(c.getClass(), field);
        if (value instanceof RC)
          value = c._concepts.getConcept((RC) value);
        value = deref(value);
        if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan)
          value = intern((String) value);
        if (f == null) {
          c.fieldValues = syncMapPut2_createLinkedHashMap(c.fieldValues, assertIdentifier(field), value instanceof Concept ? c.new Ref((Concept) value) : value);
          c.change();
        } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
          ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
          c.change();
          ++changes;
        } else {
          Object old = f.get(c);
          if (neq(value, old)) {
            f.set(c, value);
            if ((f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) == 0)
              c.change();
            ++changes;
          }
        }
      }
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  public static void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  public static <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  public static <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  public static String aGlobalID() {
    return randomID(globalIDLength());
  }

  public static <A> Set<A> synchroLinkedHashSet() {
    return Collections.synchronizedSet(new LinkedHashSet<A>());
  }

  public static long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  public static RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  public static int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  public static int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnull(l)) n += cset(c, values);
    return n;
  }

  public static <A extends Concept> List<A> list(Class<A> type) {
    return db_mainConcepts().list(type);
  }

  public static <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  public static List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  public static List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  public static void releaseEmptyFieldValuesOfAllConcepts(Concepts cc) {
    for (Concept c : cc.allConcepts()) dynamicObject_releaseEmptyFieldValues(c);
  }

  public static void onConceptsChange(Runnable r) {
    onConceptsChange(db_mainConcepts(), r);
  }

  public static void onConceptsChange(Concepts cc, Runnable r) {
    cc.addConceptIndex(simpleConceptIndex(r));
    cc.onAllChanged.add(r);
  }

  public static Runnable rOnceAtATimeOnly(Runnable r) {
    if (r == null)
      return null;
    AtomicBoolean running = new AtomicBoolean();
    return new Runnable() {

      public void run() {
        try {
          if (!running.compareAndSet(false, true))
            return;
          try {
            r.run();
          } finally {
            running.set(false);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (!running.compareAndSet(false, true)) return;\r\n    try {\r\n      r.run();\r\n...";
      }
    };
  }

  public static long now_virtualTime;

  public static long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  public static boolean nempty(Collection c) {
    return !empty(c);
  }

  public static boolean nempty(CharSequence s) {
    return !empty(s);
  }

  public static boolean nempty(Object[] o) {
    return !empty(o);
  }

  public static boolean nempty(byte[] o) {
    return !empty(o);
  }

  public static boolean nempty(int[] o) {
    return !empty(o);
  }

  public static boolean nempty(Map m) {
    return !empty(m);
  }

  public static boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  public static boolean nempty(Object o) {
    return !empty(o);
  }

  public static <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  public static <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  public static void indexConceptFieldsCI(Concepts concepts, Object... params) {
    for (int i = 0; i < l(params); i += 2) indexConceptFieldCI(concepts, (Class) params[i], (String) params[i + 1]);
  }

  public static void indexConceptFields(Object... params) {
    int i = 0;
    Concepts concepts;
    if (first(params) instanceof Concepts) {
      concepts = (Concepts) first(params);
      ++i;
    } else
      concepts = db_mainConcepts();
    for (; i < l(params); i += 2) indexConceptField(concepts, (Class) params[i], (String) params[i + 1]);
  }

  public static void indexSingletonConcept(Concepts cc, Class<? extends Concept> c) {
    indexConceptField(cc, c, "_dummy");
  }

  public static boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  public static boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  public static boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  public static boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  public static boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  public static boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  public static boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  public static List syncMap(Object f, Map map) {
    return syncMap(map, f);
  }

  public static List syncMap(Map map, Object f) {
    return map(cloneLinkedHashMap(map), f);
  }

  public static <A, B> Map<A, B> syncMap() {
    return synchroHashMap();
  }

  public static <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  public static String trim(String s) {
    return s == null ? null : s.trim();
  }

  public static String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  public static String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  public static volatile StringBuffer local_log = new StringBuffer();

  public static volatile Appendable print_log = local_log;

  public static volatile int print_log_max = 1024 * 1024;

  public static volatile int local_log_max = 100 * 1024;

  public static boolean print_silent = false;

  public static Object print_byThread_lock = new Object();

  public static volatile ThreadLocal<Object> print_byThread;

  public static volatile Object print_allThreads;

  public static volatile Object print_preprocess;

  public static void print() {
    print("");
  }

  public static <A> A print(String s, A o) {
    print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
    return o;
  }

  public static <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = String.valueOf(o) + "\n";
    print_noNewLine(s);
    return o;
  }

  public static void print_noNewLine(String s) {
    Object f = getThreadLocal(print_byThread_dontCreate());
    if (f == null)
      f = print_allThreads;
    if (f != null)
      if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
        return;
    print_raw(s);
  }

  public static void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
  }

  public static void print_autoRotate() {
  }

  public static String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  public static String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  public static void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  public static Object withDBLock(Object r) {
    Lock __359 = db_mainConcepts().lock;
    lock(__359);
    try {
      return callF(r);
    } finally {
      unlock(__359);
    }
  }

  public static <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  public static Object withDBLock(Concepts concepts, Object r) {
    Lock __360 = concepts.lock;
    lock(__360);
    try {
      return callF(r);
    } finally {
      unlock(__360);
    }
  }

  public static <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  public static <A extends Concept> List<A> findBackRefs(Collection<? extends Concept> concepts, Class<A> type) {
    IdentityHashMap<A, Boolean> l = new IdentityHashMap();
    for (Concept c : concepts) if (c.backRefs != null)
      for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
        l.put((A) r.concept(), true);
    return asList(keys(l));
  }

  public static <A extends Concept> List<A> findBackRefs(Concept c, Class<A> type) {
    IdentityHashMap<A, Boolean> l = new IdentityHashMap();
    if (c != null && c.backRefs != null)
      for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
        l.put((A) r.concept(), true);
    return asList(keys(l));
  }

  public static <A extends Concept> List<A> findBackRefs(Class<A> type, Concept c) {
    return findBackRefs(c, type);
  }

  public static String subBot_clientIP() {
    return getClientIP_subBot();
  }

  public static <A> A firstThat(Iterable<A> l, Object pred) {
    if (l != null)
      for (A a : l) if (checkCondition(pred, a))
        return a;
    return null;
  }

  public static <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, (Object) pred);
  }

  public static <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  public static boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  public static boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  public static boolean eq_icIf(boolean ignoreCase, String a, String b) {
    return ignoreCase ? eqic(a, b) : eq(a, b);
  }

  public static boolean eq(Object a, Object b) {
    return a == null ? b == null : a == b || b != null && a.equals(b);
  }

  public static Concept cnew(String name, Object... values) {
    Class<? extends Concept> cc = findClass(name);
    Concept c = cc != null ? nuObject(cc) : new Concept(name);
    csetAll(c, values);
    return c;
  }

  public static Concept cnew(Concepts concepts, String name, Object... values) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    Concept c;
    try {
      c = cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  public static <A extends Concept> A cnew(Class<A> cc, Object... values) {
    A c = nuObject(cc);
    csetAll(c, values);
    return c;
  }

  public static <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
    concepts_unlisted.set(true);
    A c;
    try {
      c = nuObject(cc);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  public static int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  public static int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  public static int l(Map m) {
    return m == null ? 0 : m.size();
  }

  public static int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  public static long l(File f) {
    return f == null ? 0 : f.length();
  }

  public static int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : o instanceof Object[] ? l((Object[]) o) : o instanceof boolean[] ? l((boolean[]) o) : o instanceof byte[] ? l((byte[]) o) : o instanceof char[] ? l((char[]) o) : o instanceof short[] ? l((short[]) o) : o instanceof int[] ? l((int[]) o) : o instanceof float[] ? l((float[]) o) : o instanceof double[] ? l((double[]) o) : o instanceof long[] ? l((long[]) o) : (Integer) call(o, "size");
  }

  public static int l(MultiSet ms) {
    return ms == null ? 0 : ms.size();
  }

  public static <A> List<A> sortByFieldInPlace(List<A> l, String field) {
    sort(l, fieldComparator(field));
    return l;
  }

  public static <A> List<A> sortByFieldInPlace(String field, List<A> l) {
    return sortByFieldInPlace(l, field);
  }

  public static void numberEntriesInConceptField(String field, List<? extends Concept> entries) {
    for (int i = 0; i < l(entries); i++) if (getInt(entries.get(i), field) == 0)
      cset(entries.get(i), field, i + 1);
  }

  public static int count(Collection l, Object o) {
    int count = 0;
    for (Object x : l) if (eq(x, o))
      ++count;
    return count;
  }

  public static String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5_impl(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  public static byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String md5(File file) {
    return md5OfFile(file);
  }

  public static <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  public static <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  public static String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  public static String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  public static <A> List<A> takeFirst(int n, Iterable<A> i) {
    List l = new ArrayList();
    Iterator<A> it = i.iterator();
    for (int _repeat_1103 = 0; _repeat_1103 < n; _repeat_1103++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  public static String fileNameEncode_safeChars = " ()[]#,!";

  public static String fileNameEncode(String s) {
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (contains(fileNameEncode_safeChars, c))
        buf.append(c);
      else
        buf.append(urlencode(str(c)));
    }
    return str(buf);
  }

  public static GlobalID asGlobalID(String id) {
    return id == null ? null : new GlobalID(id);
  }

  public static int randomID_defaultLength = 12;

  public static String randomID(int length) {
    return makeRandomID(length);
  }

  public static String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  public static String randomID() {
    return randomID(randomID_defaultLength);
  }

  public static String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  public static Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  public static void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  public static Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  public static void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null)
        smartSet(f, o, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        f.setAccessible(true);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Object deref(Object o) {
    if (o instanceof Derefable)
      o = ((Derefable) o).get();
    return o;
  }

  public static String intern(String s) {
    return fastIntern(s);
  }

  public static <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  public static String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  public static String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  public static boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  public static Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  public static boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  public static int globalIDLength() {
    return 16;
  }

  public static volatile boolean ping_pauseAll = false;

  public static int ping_sleep = 100;

  public static volatile boolean ping_anyActions = false;

  public static Map<Thread, Object> ping_actions = newWeakHashMap();

  public static ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  public static boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  public static boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  public static String unnull(String s) {
    return s == null ? "" : s;
  }

  public static <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  public static <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  public static <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  public static <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  public static <A> A[] unnull(A[] a) {
    return a == null ? (A[]) new Object[0] : a;
  }

  public static BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  public static <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  public static volatile Concepts mainConcepts;

  public static Concepts db_mainConcepts() {
    if (mainConcepts == null) {
      mainConcepts = new Concepts(getDBProgramID());
      mainConcepts.classFinder = _defaultClassFinder();
    }
    return mainConcepts;
  }

  public static void dynamicObject_releaseEmptyFieldValues(DynamicObject o) {
    if (o != null && o.fieldValues != null && empty(o.fieldValues))
      o.fieldValues = null;
  }

  public static IConceptIndex simpleConceptIndex(final Runnable r) {
    return new IConceptIndex() {

      public void update(Concept c) {
        pcallF(r);
      }

      public void remove(Concept c) {
        pcallF(r);
      }
    };
  }

  public static <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  public static <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    params = expandParams(c, params);
    A x = findConceptWhere(cc, c, params);
    if (x == null) {
      x = unlisted(c);
      csetAll(x, params);
      cc.register(x);
    }
    return x;
  }

  public static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
    return indexConceptFieldCI(db_mainConcepts(), c, field);
  }

  public static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
    ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
    return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
  }

  public static Object first(Object list) {
    return first((Iterable) list);
  }

  public static <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  public static <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  public static <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  public static <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  public static <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  public static Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  public static <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  public static void indexConceptField(Class<? extends Concept> c, String field) {
    indexConceptField(db_mainConcepts(), c, field);
  }

  public static void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
    if (!isConceptFieldIndexed(concepts, c, field))
      new ConceptFieldIndex(concepts, c, field);
  }

  public static RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  public static RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  public static RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  public static RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  public static RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  public static String getType(Object o) {
    return getClassName(o);
  }

  public static long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  public static long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  public static List map(Iterable l, Object f) {
    return map(f, l);
  }

  public static List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  public static <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  public static <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(callF(f, o));
    return x;
  }

  public static <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  public static <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  public static <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  public static <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  public static List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  public static List map(Object[] l, Object f) {
    return map(f, l);
  }

  public static List map(Object f, Map map) {
    return map(map, f);
  }

  public static List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  public static <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
    return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
  }

  public static Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  public static <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  public static boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  public static void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  public static Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  public static <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  public static <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  public static ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  public static boolean isFalse(Object o) {
    return eq(false, o);
  }

  public static Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  public static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  public static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  public static <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  public static <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  public static Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMC((String) f, args);
      if (f instanceof Runnable) {
        ((Runnable) f).run();
        return null;
      }
      if (f == null)
        return null;
      Class c = f.getClass();
      ArrayList<Method> methods;
      synchronized (callF_cache) {
        methods = callF_cache.get(c);
        if (methods == null)
          methods = callF_makeCache(c);
      }
      int n = l(methods);
      if (n == 0) {
        throw fail("No get method in " + getClassName(c));
      }
      if (n == 1)
        return invokeMethod(methods.get(0), f, args);
      for (int i = 0; i < n; i++) {
        Method m = methods.get(i);
        if (call_checkArgs(m, args, false))
          return invokeMethod(m, f, args);
      }
      throw fail("No matching get method in " + getClassName(c));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  public static String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  public static void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  public static String str(char[] c) {
    return new String(c);
  }

  public static void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        lock.lockInterruptibly();
      } catch (InterruptedException e) {
        print("Locking interrupted! I probably deadlocked, oops.");
        printStackTrace(e);
        rethrow(e);
      }
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  public static void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  public static ReentrantLock lock() {
    return fairLock();
  }

  public static void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    print("Unlocking: " + msg);
    lock.unlock();
  }

  public static void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
  }

  public static boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  public static boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  public static <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  public static ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  public static ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  public static <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  public static <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  public static <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  public static <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  public static Set keys(Object map) {
    return keys((Map) map);
  }

  public static <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  public static <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  public static <A, B> Set<A> keys(MultiSetMap<A, B> mm) {
    return mm.keySet();
  }

  public static String getClientIP_subBot() {
    Object session = call(getMainBot(), "getSession");
    Map headers = (Map) (call(session, "getHeaders"));
    return getClientIPFromHeaders(headers);
  }

  public static boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  public static <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  public static String asString(Object o) {
    return o == null ? null : o.toString();
  }

  public static HashMap<String, Class> findClass_cache = new HashMap();

  public static Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  public static Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      m.setAccessible(true);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  public static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object call(Object o) {
    return callF(o);
  }

  public static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  public static Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  public static <T> void sort(T[] a, Comparator<? super T> c) {
    Arrays.sort(a, c);
  }

  public static <T> void sort(T[] a) {
    Arrays.sort(a);
  }

  public static <T> void sort(List<T> a, Comparator<? super T> c) {
    Collections.sort(a, c);
  }

  public static void sort(List a) {
    Collections.sort(a);
  }

  public static <A> Comparator<A> fieldComparator(final String field) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(getOpt(a, field), getOpt(b, field));
      }
    };
  }

  public static int getInt(List c, int i) {
    return toInt(get(c, i));
  }

  public static int getInt(Map map, Object key) {
    return toInt(mapGet(map, key));
  }

  public static int getInt(Object o, String field) {
    return toInt(getOpt(o, (String) field));
  }

  public static int getInt(String field, Object o) {
    return getInt(o, field);
  }

  public static class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  public static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  public static HashMap getOpt_special;

  public static Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return mapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            f.setAccessible(true);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  public static byte[] toUtf8(String s) {
    try {
      return s.getBytes("UTF-8");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean md5OfFile_verbose = false;

  public static String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  public static String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  public static <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  public static String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  public static String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.substring(x, y);
  }

  public static boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  public static boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  public static boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  public static boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  public static boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  public static String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  public static String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  public static String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  public static String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  public static Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  public static boolean odd(int i) {
    return (i & 1) != 0;
  }

  public static boolean odd(long i) {
    return (i & 1) != 0;
  }

  public static boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  public static <A extends Throwable> A printStackTrace(A e) {
    print(getStackTrace(e));
    return e;
  }

  public static void printStackTrace() {
    printStackTrace(new Throwable());
  }

  public static void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  public static void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  public static void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          f.setAccessible(true);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        f.setAccessible(true);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long)
        value = ((Long) value).intValue();
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  public static Method fastIntern_method;

  public static String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object collectionMutex(Object o) {
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  public static String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  public static String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  public static <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  public static boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  public static boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  public static boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  public static void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  public static Thread currentThread() {
    return Thread.currentThread();
  }

  public static Class javax() {
    return getJavaX();
  }

  public static ArrayList emptyList() {
    return new ArrayList();
  }

  public static ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  public static ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  public static ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  public static <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  public static Map emptyMap() {
    return new HashMap();
  }

  public static String getDBProgramID_id;

  public static String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  public static Object _defaultClassFinder_value = defaultDefaultClassFinder();

  public static Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  public static Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  public static <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  public static <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  public static <A> void pcallF(VF1<A> f, A a) {
    try {
      if (f != null)
        f.get(a);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  public static <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  public static <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  public static Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  public static <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  public static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Class<A> c, String field) {
    return getConceptFieldCIIndex(db_mainConcepts(), c, field);
  }

  public static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Concepts concepts, Class<A> c, String field) {
    return (ConceptFieldIndexCI) concepts.getCIFieldIndex(c, field);
  }

  public static boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
    return isConceptFieldIndexed(db_mainConcepts(), c, field);
  }

  public static boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
    return concepts.getFieldIndex(c, field) != null;
  }

  public static RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  public static Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  public static <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  public static <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  public static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  public static HashMap<String, List<Method>> callMC_cache = new HashMap();

  public static String callMC_key;

  public static Method callMC_value;

  public static Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  public static Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with matching arguments found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  public static Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  public static <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  public static <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  public static <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  public static int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  public static int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  public static int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  public static int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  public static int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  public static int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  public static <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  public static void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  public static Object mainBot;

  public static Object getMainBot() {
    return mainBot;
  }

  public static String getClientIPFromHeaders(Map<String, String> headers) {
    if (headers == null)
      return null;
    String remoteAddr = (String) (headers.get("remote-addr"));
    String client = (String) (headers.get("x-forwarded-for"));
    if (nempty(client))
      remoteAddr += "," + client;
    return remoteAddr;
  }

  public static boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  public static Map<String, Class> classForName_cache = synchroHashMap();

  public static Class classForName(String name) {
    try {
      if (classForName_cache == null)
        return Class.forName(name);
      Class c = classForName_cache.get(name);
      if (c == null)
        classForName_cache.put(name, c = Class.forName(name));
      return c;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  public static Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      m.setAccessible(true);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  public static List<Class> getClasses(Object[] array) {
    List<Class> l = new ArrayList();
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  public static boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  public static Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found in " + c);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  public static int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  public static int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  public static int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt((String) o);
    throw fail("woot not int: " + getClassName(o));
  }

  public static int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  public static <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  public static <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  public static boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  public static Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        f.setAccessible(true);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  public static Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  public static Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  public static Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  public static Object get(String field, Object o) {
    return get(o, field);
  }

  public static void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  public static <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  public static <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  public static List<Pair> _registerDangerousWeakMap_preList;

  public static <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  public static <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  public static void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  public static Map synchroMap() {
    return synchroHashMap();
  }

  public static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  public static <A, B> B mapGet2(Map<A, B> map, A a) {
    return map == null ? null : map.get(a);
  }

  public static <A, B> B mapGet2(A a, Map<A, B> map) {
    return map == null ? null : map.get(a);
  }

  public static Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  public static Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  public static File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  public static File newFile(String name) {
    return name == null ? null : new File(name);
  }

  public static void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  public static int max(int a, int b) {
    return Math.max(a, b);
  }

  public static int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  public static long max(int a, long b) {
    return Math.max((long) a, b);
  }

  public static long max(long a, long b) {
    return Math.max(a, b);
  }

  public static double max(int a, double b) {
    return Math.max((double) a, b);
  }

  public static float max(float a, float b) {
    return Math.max(a, b);
  }

  public static double max(double a, double b) {
    return Math.max(a, b);
  }

  public static int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  public static double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  public static short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  public static int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  public static int min(int a, int b) {
    return Math.min(a, b);
  }

  public static long min(long a, long b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  public static double min(double a, double b) {
    return Math.min(a, b);
  }

  public static double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  public static float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  public static byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  public static short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  public static int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  public static <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  public static <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  public static <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  public static int strL(String s) {
    return s == null ? 0 : s.length();
  }

  public static Random defaultRandomGenerator() {
    return ThreadLocalRandom.current();
  }

  public static Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  public static String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  public static String n(Collection l, String name) {
    return n(l(l), name);
  }

  public static String n(Map m, String name) {
    return n(l(m), name);
  }

  public static String n(Object[] a, String name) {
    return n(l(a), name);
  }

  public static String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  public static String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  public static String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  public static String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  public static <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  public static Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  public static Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        m.setAccessible(true);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  public static String className(Object o) {
    return getClassName(o);
  }

  public static boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  public static boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  public static List _registerWeakMap_preList;

  public static <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  public static void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  public static int isAndroid_flag;

  public static boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  public static Boolean isHeadless_cache;

  public static boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  public static boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  public static boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  public static volatile boolean licensed_yes = true;

  public static boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  public static void licensed_off() {
    licensed_yes = false;
  }

  public static Class __javax;

  public static Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  public static Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        try {
          Class c = findClass_fullName(name);
          if (c != null)
            return c;
          if (startsWith(name, "loadableUtils.utils$"))
            return findClass_fullName("main" + substring(name, 19));
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Class c = findClass_fullName(name);\r\n    if (c != null) ret c;\r\n    if (start...";
      }
    };
  }

  public static Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  public static volatile PersistableThrowable _handleException_lastException;

  public static List _handleException_onException = synchroList(ll("printStackTrace2"));

  public static void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
      return;
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      printStackTrace2(e3);
    }
  }

  public static boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  public static betterCIComparator_C betterCIComparator_instance;

  public static betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  public static class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  public static List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  public static List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  public static Class mc() {
    return dblib.class;
  }

  public static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  public static <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
    if (mm != null && key != null && value != null)
      mm.put(key, value);
  }

  public static Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  public static String joinWithSpace(Collection<String> c) {
    return join(" ", c);
  }

  public static String joinWithSpace(String... c) {
    return join(" ", c);
  }

  public static Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static final Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  public static Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static _MethodCache callOpt_getCache(Class c) {
    synchronized (callOpt_cache) {
      _MethodCache cache = callOpt_cache.get(c);
      if (cache == null)
        callOpt_cache.put(c, cache = new _MethodCache(c));
      return cache;
    }
  }

  public static boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  public static Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  public static <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  public static String joinWithComma(String... c) {
    return join(", ", c);
  }

  public static String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  public static int parseInt(String s) {
    return empty(s) ? 0 : Integer.parseInt(s);
  }

  public static int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  public static Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  public static void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  public static void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  public static <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  public static <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  public static <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  public static <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  public static <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  public static <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  public static <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  public static Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  public static Set<String> singular_specials2 = litset("time", "machine", "line");

  public static String singular(String s) {
    if (s == null)
      return null;
    {
      String _a_56 = singular_specials.get(s);
      if (!empty(_a_56))
        return _a_56;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  public static List<String> getPlural_specials = ll("sheep", "fish");

  public static String getPlural(String s) {
    if (containsIgnoreCase(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewic(s, "ss"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  public static volatile PersistableThrowable lastException_lastException;

  public static PersistableThrowable lastException() {
    return lastException_lastException;
  }

  public static void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  public static String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  public static String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  public static String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  public static Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  public static void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  public static volatile boolean sleep_noSleep = false;

  public static void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  public static volatile String caseID_caseID;

  public static String caseID() {
    return caseID_caseID;
  }

  public static void caseID(String id) {
    caseID_caseID = id;
  }

  public static String programID() {
    return getProgramID();
  }

  public static String programID(Object o) {
    return getProgramID(o);
  }

  public static String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  public static HashMap<String, Class> findClass_fullName_cache = new HashMap();

  public static Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  public static boolean startsWith(String a, String b) {
    return a != null && a.startsWith(b);
  }

  public static boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  public static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  public static boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  public static Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  public static PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  public static Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  public static List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first(((Collection) strings)));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  public static <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  public static String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  public static Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  public static boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  public static boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  public static void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, min(a.length, b.length));
  }

  public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  public static <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  public static <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  public static String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  public static <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  public static String dropSuffix(String suffix, String s) {
    return s.endsWith(suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  public static String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  public static boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  public static boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  public static boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  public static String[] dropLast(String[] a, int n) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  public static <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  public static <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  public static <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  public static String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  public static String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  public static String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  public static boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  public static boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  public static boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  public static boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  public static boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  public static boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  public static String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  public static boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  public static boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  public static String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Class<?> hotwire(String src) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  public static <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  public static void callMain() {
    callMain(mc());
  }

  public static Object sleepQuietly_monitor = new Object();

  public static void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String programID;

  public static String getProgramID() {
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  public static String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  public static String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  public static String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  public static boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  public static int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  public static Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  public static Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  public static <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  public static Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  public static String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  public static Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  public static char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  public static <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  public static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  public static int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  public static int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  public static int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  public static boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  public static boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  public static boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  public static String theAGIBlueDomain() {
    return "agi.blue";
  }

  public static void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  public static boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  public static boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  public static boolean _inCore() {
    return false;
  }

  public static List hotwire_copyOver_after = synchroList();

  public static void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  public static Object callOpt(Object o) {
    return callF(o);
  }

  public static <A> A callOpt(Object o, String method, Object... args) {
    return (A) callOpt_withVarargs(o, method, args);
  }

  public static String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  public static String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  public static String formatSnippetID(long id) {
    return "#" + id;
  }

  public static Class getMainClass() {
    return mc();
  }

  public static Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  public static Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  public static int indexOfIgnoreCase_manual(String a, String b) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (int i = 0; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  public static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  public static void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  public static void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  public static void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  public static Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  public static String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  public static long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  public static long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  public static final class _MethodCache {

    public final Class c;

    public final HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      while (_c != null) {
        for (Method m : _c.getDeclaredMethods()) if (!reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if (m.isDefault() && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  public abstract static class VF1<A> implements IVF1<A> {

    public abstract void get(A a);
  }

  public static class ConceptFieldIndex<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter {

    public Class<A> cc;

    public String field;

    public HashMap<A, Val> objectToValue = new HashMap();

    public MultiMap<Val, A> valueToObject = new MultiMap();

    public ConceptFieldIndex() {
    }

    public ConceptFieldIndex(Class<A> cc, String field) {
      this(mainConcepts, cc, field);
    }

    public ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) {
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    public synchronized void updateImpl(Concept c) {
      Val newValue = (Val) (cget(c, field));
      Val oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      Val value = (Val) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    public synchronized A get(Val value) {
      return valueToObject.getFirst(value);
    }

    public synchronized List<A> getAll(Val value) {
      return valueToObject.get(value);
    }

    public synchronized List<Val> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public synchronized MultiSet<Val> allValues_multiSet() {
      return multiMapToMultiSet(valueToObject);
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }
  }

  public abstract static class F0<A> {

    public abstract A get();
  }

  public abstract static class F1<A, B> {

    public abstract B get(A a);
  }

  public static class GlobalID {

    public long a;

    public int b;

    public GlobalID() {
    }

    public GlobalID(String id) {
      assertGlobalID(id);
      BigInteger value = bigint(0);
      for (int i = 0; i < l(id); i++) value = plus(mul(value, 26), charDiff(id.charAt(i), 'a'));
      a = value.longValue();
      value = value.shiftRight(64);
      b = value.shortValue();
    }

    public String toString() {
      BigInteger value = bigint(b);
      value = value.shiftLeft(32);
      value = plus(value, (a >> 32) & 0xFFFFFFFFL);
      value = value.shiftLeft(32);
      value = plus(value, a & 0xFFFFFFFFL);
      return bigintToGlobalID(value);
    }

    public boolean equals(Object o) {
      if (!(o instanceof GlobalID))
        return false;
      return ((GlobalID) o).a == a && ((GlobalID) o).b == b;
    }

    public int hashCode() {
      return (int) a;
    }
  }

  public static int concepts_internStringsLongerThan = 10;

  public static ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

  public static interface Derefable {

    public Concept get();
  }

  public static interface IConceptIndex {

    public void update(Concept c);

    public void remove(Concept c);
  }

  public static interface IFieldIndex<A extends Concept, Val> {

    public List<A> getAll(Val val);

    public List<Val> allValues();

    public MultiSet<Val> allValues_multiSet();
  }

  public static class Concepts {

    public Map<Long, Concept> concepts = synchroTreeMap();

    public HashMap<Class, Object> perClassData = new HashMap();

    public Map miscMap;

    public String programID;

    public long idCounter;

    public volatile long changes, changesWritten, lastChange;

    public volatile java.util.Timer autoSaver;

    public volatile boolean savingConcepts, dontSave, noXFullGrab;

    public boolean vmBusSend = true;

    public boolean initialSave = true;

    public int autoSaveInterval = -1000;

    public boolean useGZIP = true, quietSave;

    public ReentrantLock lock = new ReentrantLock(true);

    public ReentrantLock saverLock = new ReentrantLock(true);

    public long lastSaveTook, lastSaveWas;

    public float maxAutoSavePercentage = 10;

    public List<IConceptIndex> conceptIndices;

    public Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;

    public Map<Class<? extends Concept>, Map<String, IFieldIndex>> ciFieldIndices;

    public List saveActions = synchroList();

    public Object classFinder = _defaultClassFinder();

    public List onAllChanged = synchroList();

    public transient Object saveWrapper;

    public Concepts() {
    }

    public Concepts(String programID) {
      this.programID = programID;
    }

    public synchronized long internalID() {
      do {
        ++idCounter;
      } while (hasConcept(idCounter));
      return idCounter;
    }

    public void initProgramID() {
      if (programID == null)
        programID = getDBProgramID();
    }

    public Concepts load() {
      return load(false);
    }

    public Concepts safeLoad() {
      return load(true);
    }

    public Concepts load(boolean allDynamic) {
      initProgramID();
      try {
        if (tryToGrab(allDynamic))
          return this;
      } catch (Throwable e) {
        if (!exceptionMessageContains(e, "no xfullgrab"))
          printShortException(e);
        print("xfullgrab failed - loading DB of " + programID + " from disk");
      }
      return loadFromDisk(allDynamic);
    }

    public Concepts loadFromDisk() {
      return loadFromDisk(false);
    }

    public Concepts loadFromDisk(boolean allDynamic) {
      if (nempty(concepts))
        clearConcepts();
      restoreLatestBackupIfConceptsFileEmpty(programID, "doIt", true);
      long time = now();
      Map<Long, Concept> _concepts = concepts;
      readLocally2_allDynamic.set(allDynamic);
      AutoCloseable __8 = tempSetTL(readLocally2_classFinder, classFinder);
      try {
        readLocally2(this, programID, "concepts");
        Map<Long, Concept> __concepts = concepts;
        concepts = _concepts;
        concepts.putAll(__concepts);
        int l = readLocally_stringLength;
        int tokrefs = unstructure_tokrefs;
        assignConceptsToUs();
        done("Loaded " + n(l(concepts), "concepts"), time);
        if (fileSize(getProgramFile(programID, "idCounter.structure")) != 0)
          readLocally2(this, programID, "idCounter");
        else
          calcIdCounter();
        if (initialSave)
          allChanged();
        return this;
      } finally {
        _close(__8);
      }
    }

    public Concepts loadConcepts() {
      return load();
    }

    public boolean tryToGrab(boolean allDynamic) {
      if (sameSnippetID(programID, getDBProgramID()))
        return false;
      RemoteDB db = connectToDBOpt(programID);
      try {
        if (db != null) {
          loadGrab(db.fullgrab(), allDynamic);
          return true;
        }
        return false;
      } finally {
        _close(db);
      }
    }

    public Concepts load(String grab) {
      return loadGrab(grab, false);
    }

    public Concepts safeLoad(String grab) {
      return loadGrab(grab, true);
    }

    public Concepts loadGrab(String grab, boolean allDynamic) {
      clearConcepts();
      DynamicObject_loading.set(true);
      try {
        Map<Long, Concept> map = (Map) unstructure(grab, allDynamic, classFinder);
        concepts.putAll(map);
        assignConceptsToUs();
        for (long l : map.keySet()) idCounter = max(idCounter, l);
      } finally {
        DynamicObject_loading.set(null);
      }
      allChanged();
      return this;
    }

    public void assignConceptsToUs() {
      for (Concept c : values(concepts)) c._concepts = this;
      for (Concept c : values(concepts)) callOpt_noArgs(c, "_doneLoading2");
    }

    public String progID() {
      return programID == null ? getDBProgramID() : programID;
    }

    public Concept getConcept(String id) {
      return empty(id) ? null : getConcept(parseLong(id));
    }

    public Concept getConcept(long id) {
      return (Concept) concepts.get((long) id);
    }

    public Concept getConcept(RC ref) {
      return ref == null ? null : getConcept(ref.longID());
    }

    public boolean hasConcept(long id) {
      return concepts.containsKey((long) id);
    }

    public void deleteConcept(long id) {
      Concept c = getConcept(id);
      if (c == null)
        print("Concept " + id + " not found");
      else
        c.delete();
    }

    public void calcIdCounter() {
      long id_ = 0;
      for (long id : keys(concepts)) id_ = max(id_, id);
      idCounter = id_ + 1;
      saveLocally2(this, programID, "idCounter");
    }

    public void saveConceptsIfDirty() {
      saveConcepts();
    }

    public void save() {
      saveConcepts();
    }

    public void saveConcepts() {
      if (dontSave)
        return;
      initProgramID();
      saverLock.lock();
      savingConcepts = true;
      long start = now(), time;
      try {
        String s = null;
        long _changes = changes;
        if (_changes == changesWritten)
          return;
        final File f = getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
        lock.lock();
        long fullTime = now();
        try {
          saveLocally2(this, programID, "idCounter");
          if (useGZIP) {
            callRunnableWithWrapper(saveWrapper, new Runnable() {

              public void run() {
                try {
                  saveGZStructureToFile(f, cloneMap(concepts));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "saveGZStructureToFile(f, cloneMap(concepts));";
              }
            });
            getProgramFile(programID, "concepts.structure").delete();
          } else
            s = structure(cloneMap(concepts));
        } finally {
          lock.unlock();
        }
        while (nempty(saveActions)) pcallF(popFirst(saveActions));
        changesWritten = _changes;
        if (!useGZIP) {
          time = now() - start;
          if (!quietSave)
            print("Saving " + toM(l(s)) + "M chars (" + time + " ms)");
          start = now();
          saveTextFile(f, javaTokWordWrap(s));
          getProgramFile(programID, "concepts.structure.gz").delete();
        }
        copyFile(f, getProgramFile(programID, "backups/concepts.structure" + (useGZIP ? ".gz" : "") + ".backup" + ymd() + "-" + formatInt(hours(), 2)));
        time = now() - start;
        if (!quietSave)
          print(programID + ": Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
        lastSaveWas = fullTime;
        lastSaveTook = now() - fullTime;
      } finally {
        savingConcepts = false;
        saverLock.unlock();
      }
    }

    public void _autoSaveConcepts() {
      if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
        long pivotTime = Math.round(lastSaveWas + lastSaveTook * 100.0 / maxAutoSavePercentage);
        if (now() < pivotTime) {
          return;
        }
      }
      try {
        saveConcepts();
      } catch (Throwable e) {
        print("Concept save failed, will try again: " + e);
      }
    }

    public void clearConcepts() {
      concepts.clear();
      allChanged();
    }

    public void allChanged() {
      synchronized (this) {
        ++changes;
        lastChange = sysNow();
      }
      if (vmBusSend)
        vmBus_send("conceptsChanged", this);
      pcallFAll(onAllChanged);
    }

    public synchronized void autoSaveConcepts() {
      if (autoSaver == null) {
        if (isTransient())
          throw fail("Can't persist transient database");
        autoSaver = doEvery_daemon(abs(autoSaveInterval), new Runnable() {

          public void run() {
            try {
              _autoSaveConcepts();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "_autoSaveConcepts()";
          }
        });
      }
    }

    public void cleanMeUp() {
      boolean shouldSave = autoSaver != null;
      if (autoSaver != null) {
        autoSaver.cancel();
        autoSaver = null;
      }
      while (savingConcepts) sleepInCleanUp(10);
      if (shouldSave)
        saveConceptsIfDirty();
    }

    public Map<Long, String> getIDsAndNames() {
      Map<Long, String> map = new HashMap();
      Map<Long, Concept> cloned = cloneMap(concepts);
      for (long id : keys(cloned)) map.put(id, cloned.get(id).className);
      return map;
    }

    public void deleteConcepts(List l) {
      if (l != null)
        for (Object o : cloneList(l)) if (o instanceof Long) {
          Concept c = concepts.get(o);
          if (c != null)
            c.delete();
        } else if (o instanceof Concept)
          ((Concept) o).delete();
        else
          warn("Can't delete " + getClassName(o));
    }

    public <A extends Concept> A conceptOfType(Class<A> type) {
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (A) first(counter.allConcepts());
      return firstOfType(allConcepts(), type);
    }

    public <A extends Concept> List<A> conceptsOfType(Class<A> type) {
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (List<A>) cloneList(counter.allConcepts());
      return filterByType(allConcepts(), type);
    }

    public <A extends Concept> List<A> listConcepts(Class<A> type) {
      return conceptsOfType(type);
    }

    public <A extends Concept> List<A> list(Class<A> type) {
      return conceptsOfType(type);
    }

    public List<Concept> list(String type) {
      return conceptsOfType(type);
    }

    public List<Concept> conceptsOfType(String type) {
      return filterByDynamicType(allConcepts(), "main$" + type);
    }

    public boolean hasConceptOfType(Class<? extends Concept> type) {
      return hasType(allConcepts(), type);
    }

    public void persistConcepts() {
      loadConcepts();
      autoSaveConcepts();
    }

    public void conceptPersistence() {
      persistConcepts();
    }

    public Concepts persist() {
      persistConcepts();
      return this;
    }

    public void persist(Integer interval) {
      if (interval != null)
        autoSaveInterval = interval;
      persist();
    }

    public <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
      A a = conceptOfType(c);
      if (a == null) {
        r.run();
        a = conceptOfType(c);
        if (a == null)
          throw fail("Concept not made by " + r + ": " + shortClassName(c));
      }
      return a;
    }

    public void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
      for (Concept a : conceptsOfType(c1)) {
        Concept b = findBackRef(a, c2);
        if (b == null) {
          callF(func, a);
          b = findBackRef(a, c2);
          if (b == null)
            throw fail("Concept not made by " + func + ": " + shortClassName(c2));
        }
      }
    }

    public void forEvery(Class<? extends Concept> type, Object func) {
      for (Concept c : conceptsOfType(type)) callF(func, c);
    }

    public int deleteAll(Class<? extends Concept> type) {
      List<Concept> l = (List) conceptsOfType(type);
      for (Concept c : l) c.delete();
      return l(l);
    }

    public Collection<Concept> allConcepts() {
      synchronized (concepts) {
        return new ArrayList(values(concepts));
      }
    }

    public IConceptCounter conceptCounterForClass(Class<? extends Concept> c) {
      for (IFieldIndex idx : values(mapGet(fieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      for (IFieldIndex idx : values(mapGet(ciFieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      return null;
    }

    public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
      if (empty(params)) {
        IConceptCounter counter = conceptCounterForClass(c);
        if (counter != null)
          return counter.countConcepts();
        return l(list(c));
      }
      int n = 0;
      for (A x : list(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts(String c, Object... params) {
      if (empty(params))
        return l(list(c));
      int n = 0;
      for (Concept x : list(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts() {
      return l(concepts);
    }

    public synchronized void addConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        conceptIndices = new ArrayList();
      conceptIndices.add(index);
    }

    public synchronized void removeConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        return;
      conceptIndices.remove(index);
      if (empty(conceptIndices))
        conceptIndices = null;
    }

    public synchronized void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (fieldIndices == null)
        fieldIndices = new HashMap();
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      if (map == null)
        fieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    public synchronized IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
      if (fieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    public synchronized void addCIFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (ciFieldIndices == null)
        ciFieldIndices = new HashMap();
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      if (map == null)
        ciFieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    public synchronized IFieldIndex getCIFieldIndex(Class<? extends Concept> c, String field) {
      if (ciFieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    public RC xnew(String name, Object... values) {
      return new RC(cnew(name, values));
    }

    public void xset(long id, String field, Object value) {
      xset(new RC(id), field, value);
    }

    public void xset(RC c, String field, Object value) {
      if (value instanceof RC)
        value = getConcept((RC) value);
      cset(getConcept(c), field, value);
    }

    public Object xget(long id, String field) {
      return xget(new RC(id), field);
    }

    public Object xget(RC c, String field) {
      return xgetPost(cget(getConcept(c), field));
    }

    public Object xgetPost(Object o) {
      o = deref(o);
      if (o instanceof Concept)
        return new RC((Concept) o);
      return o;
    }

    public void xdelete(long id) {
      xdelete(new RC(id));
    }

    public void xdelete(RC c) {
      getConcept(c).delete();
    }

    public void xdelete(List<RC> l) {
      for (RC c : l) xdelete(c);
    }

    public List<RC> xlist() {
      return map("toPassRef", allConcepts());
    }

    public List<RC> xlist(String className) {
      return map("toPassRef", conceptsOfType(className));
    }

    public boolean isTransient() {
      return eq(programID, "-");
    }

    public String xfullgrab() {
      if (noXFullGrab)
        throw fail("no xfullgrab (DB too large)");
      Lock __7 = lock();
      lock(__7);
      try {
        if (changes == changesWritten && !isTransient())
          return loadConceptsStructure(programID);
        return structure(cloneMap(concepts));
      } finally {
        unlock(__7);
      }
    }

    public void xshutdown() {
      cleanKillVM();
    }

    public long xchangeCount() {
      return changes;
    }

    public int xcount() {
      return countConcepts();
    }

    public void register(Concept c) {
      if (c._concepts == this)
        return;
      if (c._concepts != null)
        throw fail("Can't re-register");
      c._concepts = this;
      c.id = internalID();
      c.created = now();
      concepts.put((long) c.id, c);
      c.change();
    }

    public void conceptChanged(Concept c) {
      allChanged();
      if (conceptIndices != null)
        for (IConceptIndex index : conceptIndices) index.update(c);
    }

    public boolean hasUnsavedData() {
      return changes != changesWritten || savingConcepts;
    }
  }

  public static class Concept extends DynamicObject {

    public transient Concepts _concepts;

    public long id;

    public long created, _modified;

    public List<Ref> refs;

    public List<Ref> backRefs;

    public Concept(String className) {
      super(className);
      _created();
    }

    public Concept() {
      if (!_loading()) {
        _created();
      }
    }

    public Concept(boolean unlisted) {
      if (!unlisted)
        _created();
    }

    public static boolean loading() {
      return _loading();
    }

    public static boolean _loading() {
      return dynamicObjectIsLoading();
    }

    public void _created() {
      if (!isTrue(concepts_unlisted.get()))
        db_mainConcepts().register(this);
    }

    public class Ref<A extends Concept> {

      public A value;

      public Ref() {
        if (!dynamicObjectIsLoading())
          refs = addDyn(refs, this);
      }

      public Ref(A value) {
        this.value = value;
        refs = addDyn(refs, this);
        index();
      }

      public Concept concept() {
        return Concept.this;
      }

      public A get() {
        return value;
      }

      public boolean has() {
        return value != null;
      }

      public void set(A a) {
        if (a == value)
          return;
        unindex();
        value = a;
        index();
      }

      public void set(Ref<A> ref) {
        set(ref.get());
      }

      public void clear() {
        set((A) null);
      }

      public void index() {
        if (value != null)
          value._addBackRef(this);
        change();
      }

      public void unindex() {
        if (value != null)
          value._removeBackRef(this);
      }

      public void change() {
        Concept.this.change();
      }
    }

    public class RefL<A extends Concept> extends AbstractList<A> {

      public List<Ref<A>> l = new ArrayList();

      public A set(int i, A o) {
        A prev = l.get(i).get();
        l.get(i).set(o);
        return prev;
      }

      public void add(int i, A o) {
        l.add(i, new Ref(o));
      }

      public A get(int i) {
        return l.get(i).get();
      }

      public A remove(int i) {
        return l.remove(i).get();
      }

      public int size() {
        return l.size();
      }

      public boolean contains(Object o) {
        if (o instanceof Concept)
          for (Ref<A> r : l) if (eq(r.get(), o))
            return true;
        return super.contains(o);
      }
    }

    public void delete() {
      for (Ref r : unnull(refs)) r.unindex();
      refs = null;
      for (Ref r : cloneList(backRefs)) r.set((Concept) null);
      backRefs = null;
      if (_concepts != null) {
        _concepts.concepts.remove((long) id);
        _concepts.allChanged();
        if (_concepts.conceptIndices != null)
          for (IConceptIndex index : _concepts.conceptIndices) index.remove(this);
        _concepts = null;
      }
      id = 0;
    }

    public BaseXRef export() {
      return new BaseXRef(_concepts.progID(), id);
    }

    public void change() {
      _modified = now();
      _change_withoutUpdatingModifiedField();
    }

    public void _change_withoutUpdatingModifiedField() {
      if (_concepts != null)
        _concepts.conceptChanged(this);
    }

    public void _change() {
      change();
    }

    public String _programID() {
      return _concepts == null ? getDBProgramID() : _concepts.progID();
    }

    public void _addBackRef(Concept.Ref ref) {
      backRefs = addDyn(backRefs, ref);
    }

    public void _removeBackRef(Concept.Ref ref) {
      backRefs = removeDyn(backRefs, ref);
    }

    public void _setField(String field, Object value) {
      cset(this, field, value);
    }

    public void _setFields(Object... values) {
      cset(this, values);
    }
  }

  public static class RC {

    public transient Object owner;

    public String id;

    public RC() {
    }

    public RC(long id) {
      this.id = str(id);
    }

    public RC(Object owner, long id) {
      this.id = str(id);
      this.owner = owner;
    }

    public RC(Concept c) {
      this(c.id);
    }

    public long longID() {
      return parseLong(id);
    }

    public String toString() {
      return id;
    }

    public transient RemoteDB db;

    public String getString(String field) {
      return db.xS(this, field);
    }

    public Object get(String field) {
      return db.xget(this, field);
    }

    public void set(String field, Object value) {
      db.xset(this, field, value);
    }
  }

  public static class BaseXRef {

    public String programID;

    public long id;

    public BaseXRef() {
    }

    public BaseXRef(String programID, long id) {
      this.id = id;
      this.programID = programID;
    }

    public boolean equals(Object o) {
      if (!(o instanceof BaseXRef))
        return false;
      BaseXRef r = (BaseXRef) o;
      return eq(programID, r.programID) && eq(id, r.id);
    }

    public int hashCode() {
      return programID.hashCode() + (int) id;
    }
  }

  public static class XRef extends Concept {

    public BaseXRef ref;

    public XRef() {
    }

    public XRef(BaseXRef ref) {
      this.ref = ref;
      _doneLoading2();
    }

    public void _doneLoading2() {
      getIndex().put(ref, this);
    }

    public HashMap<BaseXRef, XRef> getIndex() {
      return getXRefIndex(_concepts);
    }
  }

  public static synchronized HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
    HashMap cache = (HashMap) concepts.perClassData.get(XRef.class);
    if (cache == null)
      concepts.perClassData.put(XRef.class, cache = new HashMap());
    return cache;
  }

  public static XRef lookupOrCreateXRef(BaseXRef ref) {
    XRef xref = getXRefIndex(db_mainConcepts()).get(ref);
    if (xref == null)
      xref = new XRef(ref);
    return xref;
  }

  public static void cleanMeUp_concepts() {
    if (db_mainConcepts() != null)
      db_mainConcepts().cleanMeUp();
  }

  public static void loadAndAutoSaveConcepts() {
    db_mainConcepts().persist();
  }

  public static void loadAndAutoSaveConcepts(int interval) {
    db_mainConcepts().persist(interval);
  }

  public static RC toPassRef(Concept c) {
    return new RC(c);
  }

  public static class ConceptFieldIndexCI<A extends Concept> implements IConceptIndex, IFieldIndex<A, String>, IConceptCounter {

    public Class<A> cc;

    public String field;

    public HashMap<A, String> objectToValue = new HashMap();

    public MultiSetMap<String, A> valueToObject = ciMultiSetMap();

    public ConceptFieldIndexCI() {
    }

    public ConceptFieldIndexCI(Class<A> cc, String field) {
      this(db_mainConcepts(), cc, field);
    }

    public ConceptFieldIndexCI(Concepts concepts, Class<A> cc, String field) {
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addCIFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    public synchronized void updateImpl(Concept c) {
      String newValue = (String) (cget(c, field));
      String oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      String value = (String) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    public synchronized A get(String value) {
      return valueToObject.getFirst(value);
    }

    public synchronized List<A> getAll(String value) {
      return cloneList(valueToObject.get(value));
    }

    public Class<? extends Concept> conceptClass() {
      return cc;
    }

    public int countConcepts() {
      return l(objectToValue);
    }

    public Collection<Concept> allConcepts() {
      return (Collection) keys(objectToValue);
    }

    public synchronized List<String> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public synchronized MultiSet<String> allValues_multiSet() {
      return multiSetMapToMultiSet(valueToObject);
    }

    public IterableIterator<A> objectIterator() {
      return navigableMultiSetMapValuesIterator(valueToObject);
    }
  }

  public static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

  public static class DynamicObject {

    public String className;

    public LinkedHashMap<String, Object> fieldValues;

    public DynamicObject() {
    }

    public DynamicObject(String className) {
      this.className = className;
    }

    public Map<String, Object> _map() {
      return fieldValues;
    }
  }

  public static interface IF1<A, B> {

    public B get(A a);
  }

  public static class ConceptFieldIndexDesc<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val> {

    public Class<A> cc;

    public String field;

    public HashMap<A, Val> objectToValue = new HashMap();

    public MultiMap<Val, A> valueToObject;

    public ConceptFieldIndexDesc() {
      valueToObject = treeMultiMap(reverseOrder());
    }

    public ConceptFieldIndexDesc(Class<A> cc, String field) {
      this(mainConcepts, cc, field);
    }

    public ConceptFieldIndexDesc(Concepts concepts, Class<A> cc, String field) {
      this();
      this.field = field;
      this.cc = cc;
      concepts.addConceptIndex(this);
      for (A c : list(concepts, cc)) updateImpl(c);
      concepts.addFieldIndex(cc, field, this);
    }

    public void update(Concept c) {
      if (!isInstance(cc, c))
        return;
      updateImpl(c);
    }

    public synchronized void updateImpl(Concept c) {
      Val newValue = (Val) (cget(c, field));
      Val oldValue = objectToValue.get(c);
      if (newValue == null || newValue != oldValue) {
        valueToObject.remove(oldValue, (A) c);
        valueToObject.put(newValue, (A) c);
        objectToValue.put((A) c, newValue);
      }
    }

    public synchronized void remove(Concept c) {
      if (!isInstance(cc, c))
        return;
      Val value = (Val) (cget(c, field));
      objectToValue.remove(c);
      valueToObject.remove(value, (A) c);
    }

    public synchronized A get(Val value) {
      return valueToObject.getFirst(value);
    }

    public synchronized List<A> getAll(Val value) {
      return valueToObject.get(value);
    }

    public synchronized List<Val> allValues() {
      return cloneKeys_noSync(valueToObject.data);
    }

    public IterableIterator<A> objectIterator() {
      return navigableMultiMapValuesIterator(valueToObject);
    }

    public synchronized MultiSet<Val> allValues_multiSet() {
      return multiMapToMultiSet(valueToObject);
    }
  }

  public static class ReliableSingleThread implements Runnable {

    public Object runnable;

    public boolean trigger = false;

    public Thread thread;

    public String name = "Single Thread";

    public F0<AutoCloseable> enter;

    public ReliableSingleThread(Object runnable) {
      this.runnable = runnable;
    }

    public void trigger() {
      go();
    }

    public synchronized void go() {
      trigger = true;
      if (!running()) {
        AutoCloseable __1078 = callF(enter);
        try {
          thread = startThread(name, new Runnable() {

            public void run() {
              try {
                AutoCloseable __1079 = callF(enter);
                try {
                  _run();
                } finally {
                  _close(__1079);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1079 = callF(enter); try {\r\n        _run();\r\n      } finally ...";
            }
          });
        } finally {
          _close(__1078);
        }
      }
    }

    public void run() {
      go();
    }

    public void get() {
      go();
    }

    public synchronized boolean running() {
      return thread != null;
    }

    public void triggerAndWait() {
      trigger();
      while (running()) sleep(1);
    }

    public void _run() {
      while (licensed()) {
        synchronized (this) {
          if (!trigger) {
            thread = null;
            break;
          }
          trigger = false;
        }
        pcallF(runnable);
      }
    }

    public synchronized void cancel() {
      cancelAndInterruptThread(thread);
      thread = null;
    }
  }

  public static class PersistableThrowable {

    public String className;

    public String msg;

    public String stacktrace;

    public PersistableThrowable() {
    }

    public PersistableThrowable(Throwable e) {
      if (e == null)
        className = "Crazy Null Error";
      else {
        className = getClassName(e).replace('/', '.');
        msg = e.getMessage();
        stacktrace = getStackTrace_noRecord(e);
      }
    }

    public String toString() {
      return nempty(msg) ? className + ": " + msg : className;
    }
  }

  public static class ConceptsLoadedOnDemand {

    public Map<String, Concepts> loaded = new HashMap();

    public List onCaseLoaded;

    public List onUnloadingCase;

    public Lock lock = lock();

    public Concepts get(String caseID, Object extraInfo) {
      return conceptsForCase(caseID, extraInfo);
    }

    public Concepts getIfLoaded(String caseID) {
      Lock __1102 = lock;
      lock(__1102);
      try {
        return loaded.get(unnull(caseID));
      } finally {
        unlock(__1102);
      }
    }

    public Concepts conceptsForCase(String caseID, Object extraInfo) {
      Lock __1103 = lock;
      lock(__1103);
      try {
        caseID = unnull(caseID);
        if (loaded.containsKey(caseID))
          return assertNotNull("Concepts load error", loaded.get(caseID));
        String id = dbID(caseID);
        print("Loading concepts for case " + id);
        Concepts cc = new Concepts(id);
        cc.persist();
        loaded.put(caseID, cc);
        pcallFAll(onCaseLoaded, caseID, extraInfo, cc);
        return cc;
      } finally {
        unlock(__1103);
      }
    }

    public String dbID(String caseID) {
      return combineWithSlash(getDBProgramID(), caseID);
    }

    public void cleanMeUp() {
      cleanUpAndClear(loaded);
    }

    public void onCaseLoaded(VF3<String, Object, Concepts> f) {
      onCaseLoaded = listCreateAndAdd(onCaseLoaded, f);
    }

    public void onUnloadingCase(VF2<String, Concepts> f) {
      onUnloadingCase = listCreateAndAdd(onUnloadingCase, f);
    }

    public void unloadCase(String caseID) {
      Lock __1104 = lock;
      lock(__1104);
      try {
        caseID = unnull(caseID);
        Concepts cc = loaded.get(caseID);
        if (cc != null) {
          pcallFAll(onUnloadingCase, caseID, cc);
          cleanUp(cc);
          loaded.remove(caseID);
        }
      } finally {
        unlock(__1104);
      }
    }
  }

  public static class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  public static class MultiMap<A, B> {

    public Map<A, List<B>> data = new HashMap<A, List<B>>();

    public MultiMap() {
    }

    public MultiMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiMap(MultiMap<A, B> map) {
      putAll(map);
    }

    public MultiMap(Map<A, List<B>> data) {
      this.data = data;
    }

    public void put(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        list.add(value);
      }
    }

    public void add(A key, B value) {
      put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      synchronized (data) {
        putAll(key, values);
      }
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) put(key, value);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public List<B> get(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        return list == null ? Collections.<B>emptyList() : list;
      }
    }

    public List<B> getActual(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list == null)
          data.put(key, list = _makeEmptyList());
        return list;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null && list.isEmpty())
          data.remove(key);
      }
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public Set<A> keys() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        data.remove(key);
      }
    }

    public void remove(A key, B value) {
      synchronized (data) {
        List<B> list = data.get(key);
        if (list != null) {
          list.remove(value);
          if (list.isEmpty())
            data.remove(key);
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        List<B> list = get(key);
        return list.isEmpty() ? null : list.get(0);
      }
    }

    public void addAll(MultiMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    public int size() {
      synchronized (data) {
        int n = 0;
        for (List l : data.values()) n += l(l);
        return n;
      }
    }

    public List<A> reverseGet(B b) {
      synchronized (data) {
        List<A> l = new ArrayList();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, List<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public List<B> _makeEmptyList() {
      return new ArrayList();
    }

    public Collection<List<B>> allLists() {
      synchronized (data) {
        return new ArrayList(data.values());
      }
    }

    public List<B> allValues() {
      return concatLists(values(data));
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }
  }

  public abstract static class VF3<A, B, C> {

    public abstract void get(A a, B b, C c);
  }

  public abstract static class VF2<A, B> {

    public abstract void get(A a, B b);
  }

  public static class MultiSetMap<A, B> {

    public Map<A, Set<B>> data = new HashMap<A, Set<B>>();

    public MultiSetMap() {
    }

    public MultiSetMap(boolean useTreeMap) {
      if (useTreeMap)
        data = new TreeMap();
    }

    public MultiSetMap(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public MultiSetMap(Map<A, Set<B>> data) {
      this.data = data;
    }

    public void put(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        set.add(value);
      }
    }

    public void add(A key, B value) {
      put(key, value);
    }

    public void addAll(A key, Collection<B> values) {
      synchronized (data) {
        putAll(key, values);
      }
    }

    public void addAllIfNotThere(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) setPut(key, value);
      }
    }

    public void setPut(A key, B value) {
      synchronized (data) {
        if (!containsPair(key, value))
          put(key, value);
      }
    }

    public boolean containsPair(A key, B value) {
      synchronized (data) {
        return get(key).contains(value);
      }
    }

    public void putAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) put(key, value);
      }
    }

    public void removeAll(A key, Collection<B> values) {
      synchronized (data) {
        for (B value : values) remove(key, value);
      }
    }

    public Set<B> get(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        return set == null ? Collections.<B>emptySet() : set;
      }
    }

    public Set<B> getActual(A key) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set == null)
          data.put(key, set = _makeEmptySet());
        return set;
      }
    }

    public void clean(A key) {
      synchronized (data) {
        Set<B> list = data.get(key);
        if (list != null && list.isEmpty())
          data.remove(key);
      }
    }

    public Set<A> keySet() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public Set<A> keys() {
      synchronized (data) {
        return data.keySet();
      }
    }

    public void remove(A key) {
      synchronized (data) {
        data.remove(key);
      }
    }

    public void remove(A key, B value) {
      synchronized (data) {
        Set<B> set = data.get(key);
        if (set != null) {
          set.remove(value);
          if (set.isEmpty())
            data.remove(key);
        }
      }
    }

    public void clear() {
      synchronized (data) {
        data.clear();
      }
    }

    public boolean containsKey(A key) {
      synchronized (data) {
        return data.containsKey(key);
      }
    }

    public B getFirst(A key) {
      synchronized (data) {
        return first(get(key));
      }
    }

    public void addAll(MultiSetMap<A, B> map) {
      putAll(map);
    }

    public void putAll(MultiSetMap<A, B> map) {
      synchronized (data) {
        for (A key : map.keySet()) putAll(key, map.get(key));
      }
    }

    public void putAll(Map<A, B> map) {
      synchronized (data) {
        if (map != null)
          for (Map.Entry<A, B> e : map.entrySet()) put(e.getKey(), e.getValue());
      }
    }

    public int keysSize() {
      synchronized (data) {
        return l(data);
      }
    }

    public int size() {
      synchronized (data) {
        int n = 0;
        for (Set l : data.values()) n += l(l);
        return n;
      }
    }

    public Set<A> reverseGet(B b) {
      synchronized (data) {
        Set<A> l = new HashSet();
        for (A key : data.keySet()) if (data.get(key).contains(b))
          l.add(key);
        return l;
      }
    }

    public Map<A, Set<B>> asMap() {
      synchronized (data) {
        return cloneMap(data);
      }
    }

    public boolean isEmpty() {
      synchronized (data) {
        return data.isEmpty();
      }
    }

    public Set<B> _makeEmptySet() {
      return new HashSet();
    }

    public Collection<Set<B>> allLists() {
      synchronized (data) {
        return new HashSet(data.values());
      }
    }

    public List<B> allValues() {
      return concatLists(values(data));
    }

    public Object mutex() {
      return data;
    }

    public String toString() {
      return "mm" + str(data);
    }
  }

  public static interface IConceptCounter {

    public Class<? extends Concept> conceptClass();

    public int countConcepts();

    public Collection<Concept> allConcepts();
  }

  public static interface IVF1<A> {

    public void get(A a);
  }

  public abstract static class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  public static class MultiSet<A> {

    public Map<A, Integer> map = new HashMap();

    public MultiSet(boolean useTreeMap) {
      if (useTreeMap)
        map = new TreeMap();
    }

    public MultiSet() {
    }

    public MultiSet(Iterable<A> c) {
      addAll(c);
    }

    public MultiSet(MultiSet<A> ms) {
      synchronized (ms) {
        for (A a : ms.keySet()) add(a, ms.get(a));
      }
    }

    public synchronized void add(A key) {
      add(key, 1);
    }

    public synchronized void addAll(Iterable<A> c) {
      if (c != null)
        for (A a : c) add(a);
    }

    public synchronized void addAll(MultiSet<A> ms) {
      for (A a : ms.keySet()) add(a, ms.get(a));
    }

    public synchronized void add(A key, int count) {
      if (count <= 0)
        return;
      if (map.containsKey(key))
        map.put(key, map.get(key) + count);
      else
        map.put(key, count);
    }

    public synchronized int get(A key) {
      Integer i = map.get(key);
      return i != null ? i : 0;
    }

    public synchronized boolean contains(A key) {
      return map.containsKey(key);
    }

    public synchronized void remove(A key) {
      Integer i = map.get(key);
      if (i != null && i > 1)
        map.put(key, i - 1);
      else
        map.remove(key);
    }

    public synchronized List<A> topTen() {
      return getTopTen();
    }

    public synchronized List<A> getTopTen() {
      return getTopTen(10);
    }

    public synchronized List<A> getTopTen(int maxSize) {
      List<A> list = getSortedListDescending();
      return list.size() > maxSize ? list.subList(0, maxSize) : list;
    }

    public synchronized List<A> highestFirst() {
      return getSortedListDescending();
    }

    public synchronized List<A> lowestFirst() {
      return reversedList(getSortedListDescending());
    }

    public synchronized List<A> getSortedListDescending() {
      List<A> list = new ArrayList<A>(map.keySet());
      Collections.sort(list, new Comparator<A>() {

        public int compare(A a, A b) {
          return map.get(b).compareTo(map.get(a));
        }
      });
      return list;
    }

    public synchronized int getNumberOfUniqueElements() {
      return map.size();
    }

    public synchronized int uniqueSize() {
      return map.size();
    }

    public synchronized Set<A> asSet() {
      return map.keySet();
    }

    public synchronized NavigableSet<A> navigableSet() {
      return navigableKeys((NavigableMap) map);
    }

    public synchronized Set<A> keySet() {
      return map.keySet();
    }

    public synchronized A getMostPopularEntry() {
      int max = 0;
      A a = null;
      for (Map.Entry<A, Integer> entry : map.entrySet()) {
        if (entry.getValue() > max) {
          max = entry.getValue();
          a = entry.getKey();
        }
      }
      return a;
    }

    public synchronized void removeAll(A key) {
      map.remove(key);
    }

    public synchronized int size() {
      int size = 0;
      for (int i : map.values()) size += i;
      return size;
    }

    public synchronized MultiSet<A> mergeWith(MultiSet<A> set) {
      MultiSet<A> result = new MultiSet<A>();
      for (A a : set.asSet()) {
        result.add(a, set.get(a));
      }
      return result;
    }

    public synchronized boolean isEmpty() {
      return map.isEmpty();
    }

    public synchronized String toString() {
      return str(map);
    }

    public synchronized void clear() {
      map.clear();
    }

    public synchronized Map<A, Integer> asMap() {
      return cloneMap(map);
    }
  }

  public static class RemoteDB implements AutoCloseable {

    public DialogIO db;

    public String name;

    public RemoteDB(String s) {
      this(s, false);
    }

    public RemoteDB(String s, boolean autoStart) {
      name = s;
      if (isSnippetID(s))
        name = dbBotName(s);
      db = findBot(name);
      if (db == null)
        if (autoStart) {
          nohupJavax(fsI(s));
          waitForBotStartUp(name);
          assertNotNull("Weird problem", db = findBot(s));
        } else
          throw fail("DB " + s + " not running");
    }

    public boolean functional() {
      return db != null;
    }

    public List<RC> list() {
      return adopt((List<RC>) rpc(db, "xlist"));
    }

    public List<RC> list(String className) {
      return adopt((List<RC>) rpc(db, "xlist", className));
    }

    public List<RC> xlist() {
      return list();
    }

    public List<RC> xlist(String className) {
      return list(className);
    }

    public List<RC> adopt(List<RC> l) {
      if (l != null)
        for (RC rc : l) adopt(rc);
      return l;
    }

    public RC adopt(RC rc) {
      if (rc != null)
        rc.db = this;
      return rc;
    }

    public Object adopt(Object o) {
      if (o instanceof RC)
        return adopt((RC) o);
      return o;
    }

    public String xclass(RC o) {
      return (String) rpc(db, "xclass", o);
    }

    public Object xget(RC o, String field) {
      return adopt(rpc(db, "xget", o, field));
    }

    public String xS(RC o, String field) {
      return (String) xget(o, field);
    }

    public RC xgetref(RC o, String field) {
      return adopt((RC) xget(o, field));
    }

    public void xset(RC o, String field, Object value) {
      rpc(db, "xset", o, field, value);
    }

    public RC uniq(String className) {
      RC ref = first(list(className));
      if (ref == null)
        ref = xnew(className);
      return ref;
    }

    public RC xuniq(String className) {
      return uniq(className);
    }

    public RC xnew(String className, Object... values) {
      return adopt((RC) rpc(db, "xnew", className, values));
    }

    public void xdelete(RC o) {
      rpc(db, "xdelete", o);
    }

    public void xdelete(List<RC> l) {
      rpc(db, "xdelete", l);
    }

    public void close() {
      _close(db);
    }

    public String fullgrab() {
      return (String) rpc(db, "xfullgrab");
    }

    public String xfullgrab() {
      return fullgrab();
    }

    public void xshutdown() {
      rpc(db, "xshutdown");
    }

    public long xchangeCount() {
      return (long) rpc(db, "xchangeCount");
    }

    public int xcount() {
      return (int) rpc(db, "xcount");
    }

    public void reconnect() {
      close();
      db = findBot(name);
    }

    public RC rc(long id) {
      return new RC(this, id);
    }
  }

  public abstract static class DialogIO implements AutoCloseable {

    public String line;

    public boolean eos, loud, noClose;

    public Lock lock = lock();

    public abstract String readLineImpl();

    public abstract boolean isStillConnected();

    public abstract void sendLine(String line);

    public abstract boolean isLocalConnection();

    public abstract Socket getSocket();

    public int getPort() {
      Socket s = getSocket();
      return s == null ? 0 : s.getPort();
    }

    public boolean helloRead = false;

    public int shortenOutputTo = 500;

    public String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }

    public boolean waitForLine() {
      try {
        ping();
        if (line != null)
          return true;
        line = readLineImpl();
        if (line == null)
          eos = true;
        return line != null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }

    public String ask(String s, Object... args) {
      if (loud)
        return askLoudly(s, args);
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      sendLine(s);
      return readLine();
    }

    public String askLoudly(String s, Object... args) {
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }

    public void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }

  public abstract static class DialogHandler {

    public abstract void run(DialogIO io);
  }

  public static Lock dbLock() {
    return db_mainConcepts().lock;
  }

  public static boolean bareDBMode_on = false;

  public static void bareDBMode() {
    bareDBMode(null);
  }

  public static void bareDBMode(Integer autoSaveInterval) {
    bareDBMode_on = true;
    conceptsAndBot(autoSaveInterval);
  }

  public static boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  public static Field makeAccessible(Field f) {
    f.setAccessible(true);
    return f;
  }

  public static Method makeAccessible(Method m) {
    m.setAccessible(true);
    return m;
  }

  public static Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  public static void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  public static Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  public static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  public static boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  public static <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
    return lookupAllOpt(map, l);
  }

  public static <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  public static <A, B> List<A> cloneKeys_noSync(Map<A, B> map) {
    return cloneList_noSync(keys(map));
  }

  public static <A, B> MultiSet<A> multiMapToMultiSet(MultiMap<A, B> mm) {
    return multiMapAsMultiSet(mm);
  }

  public static Collection<Concept> allConcepts() {
    return db_mainConcepts().allConcepts();
  }

  public static Collection<Concept> allConcepts(Concepts concepts) {
    return concepts.allConcepts();
  }

  public static String assertGlobalID(String s) {
    return assertPossibleGlobalID(s);
  }

  public static BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  public static BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  public static BigInteger plus(BigInteger a, BigInteger b) {
    return a.add(b);
  }

  public static BigInteger plus(BigInteger a, long b) {
    return a.add(bigint(b));
  }

  public static BigInteger mul(BigInteger a, BigInteger b) {
    return a.multiply(b);
  }

  public static BigInteger mul(BigInteger a, long b) {
    return a.multiply(bigint(b));
  }

  public static int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  public static int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  public static String bigintToGlobalID(BigInteger value) {
    char[] buf = new char[16];
    for (int i = 16 - 1; i >= 0; i--) {
      buf[i] = charPlus('a', mod(value, 26).intValue());
      value = div(value, 26);
    }
    return str(buf);
  }

  public static NavigableMap synchroTreeMap() {
    return Collections.synchronizedNavigableMap(new TreeMap());
  }

  public static boolean hasConcept(Class<? extends Concept> c, Object... params) {
    return findConceptWhere(c, params) != null;
  }

  public static Object load(String varName) {
    readLocally(varName);
    return get(mc(), varName);
  }

  public static Object load(String progID, String varName) {
    readLocally(progID, varName);
    return get(mc(), varName);
  }

  public static boolean exceptionMessageContains(Throwable e, String s) {
    return cic(getInnerMessage(e), s);
  }

  public static void printShortException(Throwable e) {
    print(exceptionToStringShort(e));
  }

  public static void printShortException(String s, Throwable e) {
    print(s, exceptionToStringShort(e));
  }

  public static void clearConcepts() {
    db_mainConcepts().clearConcepts();
  }

  public static void clearConcepts(Concepts concepts) {
    concepts.clearConcepts();
  }

  public static void restoreLatestBackupIfConceptsFileEmpty(String dbID, Object... __) {
    boolean doIt = boolPar("doIt", __);
    File file = conceptsFile(dbID);
    if (fileExists(file) && fileSize(file) == 0) {
      print(file + " corrupted, trying to restore");
      File backup = lastThat("fileNotEmpty", sortByFileName(conceptBackupFiles(dbID)));
      if (backup == null) {
        print("No usable backup found :(");
        return;
      }
      String msg = "RESTORING: " + backup;
      File log = javaxDataDir("db-restores.log");
      if (doIt)
        logQuotedWithTime(log, msg);
      print(stringIf(!doIt, "[would be] ") + msg);
      if (doIt) {
        clearConceptsOf(dbID);
        copyFile(backup, file);
        print(msg = "DB RESTORED!");
        if (doIt)
          logQuotedWithTime(log, msg);
      }
    }
  }

  public static <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  public static void readLocally(String progID, String varNames) {
    readLocally2(mc(), progID, varNames);
  }

  public static void readLocally(String varNames) {
    readLocally2(mc(), programID(), varNames);
  }

  public static void readLocally2(Object obj, String varNames) {
    readLocally2(obj, programID(), varNames);
  }

  public static int readLocally_stringLength;

  public static ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

  public static ThreadLocal readLocally2_classFinder = new ThreadLocal();

  public static void readLocally2(Object obj, String progID, String varNames) {
    try {
      boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
      for (String variableName : javaTokC(varNames)) {
        File textFile = new File(programDir(progID), variableName + ".text");
        String value = loadTextFile(textFile);
        if (value != null)
          set(dblib.class, variableName, value);
        else {
          File structureFile = new File(programDir(progID), variableName + ".structure");
          value = loadTextFile(structureFile);
          if (value == null) {
            File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
            if (!structureGZFile.isFile())
              return;
            InputStream fis = new FileInputStream(structureGZFile);
            try {
              GZIPInputStream gis = newGZIPInputStream(fis);
              InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
              BufferedReader bufferedReader = new BufferedReader(reader);
              Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, readLocally2_classFinder.get());
              readLocally_set(obj, variableName, o);
              return;
            } finally {
              _close(fis);
            }
          }
          readLocally_stringLength = l(value);
          if (nempty(value))
            readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void readLocally_set(Object c, String varName, Object value) {
    Object oldValue = get(c, varName);
    if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
      value = synchroList((List) value);
    }
    set(c, varName, value);
  }

  public static int done_minPrint = 10;

  public static long done(long startTime, String desc) {
    long time = now() - startTime;
    if (time >= done_minPrint)
      print(desc + " [" + time + " ms]");
    return time;
  }

  public static long done(String desc, long startTime) {
    return done(startTime, desc);
  }

  public static long done(long startTime) {
    return done(startTime, "");
  }

  public static long fileSize(String path) {
    return getFileSize(path);
  }

  public static long fileSize(File f) {
    return getFileSize(f);
  }

  public static File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  public static File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  public static boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  public static RemoteDB connectToDBOpt(String dbNameOrID) {
    try {
      return new RemoteDB(dbNameOrID);
    } catch (Throwable __e) {
      return null;
    }
  }

  public static Object unstructure(String text) {
    return unstructure(text, false);
  }

  public static Object unstructure(String text, final boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  public static int structure_internStringsLongerThan = 50;

  public static int unstructure_unquoteBufSize = 100;

  public static int unstructure_tokrefs;

  public abstract static class unstructure_Receiver {

    public abstract void set(Object o);
  }

  public static Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  public static Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  public static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      public final Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID = 0;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        }
        final int _refID = refID;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (_refID != 0)
              refs.put(_refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
        String t = t();
        Class c = classesMap.get(t);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              throw fail("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              throw fail("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            {
              parseList(new LinkedList(), out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            if (t().equals("tm")) {
              consume();
              {
                parseMap(synchronizedTreeMap(), out);
                return;
              }
            }
            if (t().equals("[")) {
              parseList(synchroList(), out);
              return;
            }
            {
              parseMap(synchronizedMap(), out);
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            this.parseList(new ArrayList(), out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume("c");
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
        }
        if (eq(t, "j")) {
          consume("j");
          out.set(parseJava());
          return;
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + t);
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = "main$" + t;
        }
        if (c == null) {
          if (allDynamic)
            c = null;
          else
            c = classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
          if (c != null)
            classesMap.put(className, c);
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && eq(t(), "this$1");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          o = hasOuter ? nuStubInnerObject(c, classFinder) : nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findClass("Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID != 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        final LinkedHashMap<String, Object> fields = new LinkedHashMap();
        final Object _o = o;
        final DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  if (!eq(tpp(), "="))
                    throw fail("= expected, got " + t() + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                      if (eq(t(), ","))
                        consume();
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, ...";
            }
          });
        } else {
          objRead(o, dO, fields);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
        if (o != null)
          if (dO != null) {
            setOptAllDyn(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
        else
          for (String field : keys(fields)) dO.fieldValues.put(intern(field), fields.get(field));
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume("]");
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n     ...";
          }
        });
      }

      public void parseArray(final unstructure_Receiver out) {
        final String type = tpp();
        consume("{");
        final List list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass_fullName(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix("main$", name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_x(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    Boolean b = DynamicObject_loading.get();
    DynamicObject_loading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_x(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      DynamicObject_loading.set(b);
    }
  }

  public static boolean unstructure_debug = false;

  public static <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  public static <A, B> Collection<B> values(MultiMap<A, B> mm) {
    return mm == null ? emptyList() : concatLists(values(mm.data));
  }

  public static Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  public static Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  public static Concept getConcept(long id) {
    return db_mainConcepts().getConcept(id);
  }

  public static <A extends Concept> A getConcept(Class<A> cc, long id) {
    return getConcept(db_mainConcepts(), cc, id);
  }

  public static <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
    Concept c = concepts.getConcept(id);
    if (c == null)
      return null;
    if (!isInstance(cc, c))
      throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
    return (A) c;
  }

  public static void saveLocally(String variableName) {
    saveLocally(programID(), variableName);
  }

  public static void saveLocally(String progID, String variableName) {
    saveLocally2(mc(), progID, variableName);
  }

  public static void saveLocally2(Object obj, String variableName) {
    saveLocally2(obj, programID(), variableName);
  }

  public static void saveLocally2(Object obj, String progID, String variableName) {
    Lock __206 = saveLock();
    lock(__206);
    try {
      File textFile = new File(programDir(progID), variableName + ".text");
      File structureFile = new File(programDir(progID), variableName + ".structure");
      Object x = get(obj, variableName);
      if (x == null) {
        textFile.delete();
        structureFile.delete();
      } else if (x instanceof String) {
        saveTextFile(textFile, (String) x);
        structureFile.delete();
      } else {
        saveTextFile(structureFile, javaTokWordWrap(structure(x)));
        textFile.delete();
      }
    } finally {
      unlock(__206);
    }
  }

  public static void callRunnableWithWrapper(Object wrapper, Runnable r) {
    if (wrapper == null)
      callF(r);
    else
      callF(wrapper, r);
  }

  public static void saveGZStructureToFile(String file, Object o) {
    saveGZStructureToFile(getProgramFile(file), o);
  }

  public static void saveGZStructureToFile(File file, Object o) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      File tempFile = tempFileFor(file);
      if (tempFile.exists())
        try {
          String saveName = tempFile.getPath() + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      try {
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        structureToPrintWriter(o, printWriter);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      } catch (Throwable e) {
        fileOutputStream.close();
        tempFile.delete();
        throw rethrow(e);
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  public static boolean structure_showTiming, structure_checkTokenCount;

  public static String structure(Object o) {
    return structure(o, new structure_Data());
  }

  public static String structure(Object o, structure_Data d) {
    StringWriter sw = new StringWriter();
    d.out = new PrintWriter(sw);
    structure_go(o, d);
    String s = str(sw);
    if (structure_checkTokenCount) {
      print("token count=" + d.n);
      assertEquals("token count", l(javaTokC(s)), d.n);
    }
    return s;
  }

  public static void structure_go(Object o, structure_Data d) {
    structure_1(o, d);
    while (nempty(d.stack)) popLast(d.stack).run();
  }

  public static void structureToPrintWriter(Object o, PrintWriter out) {
    structure_Data d = new structure_Data();
    d.out = out;
    structure_go(o, d);
  }

  public static boolean structure_allowShortening = false;

  public static class structure_Data {

    public PrintWriter out;

    public int stringSizeLimit;

    public int shareStringsLongerThan = 20;

    public boolean noStringSharing = false;

    public IdentityHashMap<Object, Integer> seen = new IdentityHashMap();

    public HashMap<String, Integer> strings = new HashMap();

    public HashSet<String> concepts = new HashSet();

    public HashMap<Class, List<Field>> fieldsByClass = new HashMap();

    public HashMap<Class, Field> persistenceInfo = new HashMap();

    public int n;

    public List<Runnable> stack = new ArrayList();

    public structure_Data append(String token) {
      out.print(token);
      ++n;
      return this;
    }

    public structure_Data append(int i) {
      out.print(i);
      ++n;
      return this;
    }

    public structure_Data append(String token, int tokCount) {
      out.print(token);
      n += tokCount;
      return this;
    }

    public structure_Data app(String token) {
      out.print(token);
      return this;
    }

    public structure_Data app(int i) {
      out.print(i);
      return this;
    }
  }

  public static void structure_1(final Object o, final structure_Data d) {
    try {
      if (o == null) {
        d.append("null");
        return;
      }
      Class c = o.getClass();
      boolean concept = false;
      concept = o instanceof Concept;
      List<Field> lFields = d.fieldsByClass.get(c);
      if (lFields == null) {
        if (o instanceof Number) {
          PrintWriter out = d.out;
          if (o instanceof Integer) {
            int i = ((Integer) o).intValue();
            out.print(i);
            d.n += i < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Long) {
            long l = ((Long) o).longValue();
            out.print(l);
            out.print("L");
            d.n += l < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Short) {
            short s = ((Short) o).shortValue();
            d.append("sh ");
            out.print(s);
            d.n += s < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Float) {
            d.append("fl ", 2);
            quoteToPrintWriter(str(o), out);
            return;
          }
          if (o instanceof Double) {
            d.append("d(", 3);
            quoteToPrintWriter(str(o), out);
            d.append(")");
            return;
          }
          if (o instanceof BigInteger) {
            out.print("bigint(");
            out.print(o);
            out.print(")");
            d.n += ((BigInteger) o).signum() < 0 ? 5 : 4;
            return;
          }
        }
        if (o instanceof Boolean) {
          d.append(((Boolean) o).booleanValue() ? "t" : "f");
          return;
        }
        if (o instanceof Character) {
          d.append(quoteCharacter((Character) o));
          return;
        }
        if (o instanceof File) {
          d.append("File ").append(quote(((File) o).getPath()));
          return;
        }
        Integer ref = d.seen.get(o);
        if (o instanceof String && ref == null)
          ref = d.strings.get((String) o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        if (!(o instanceof String))
          d.seen.put(o, d.n);
        else {
          String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
          if (!d.noStringSharing) {
            if (d.shareStringsLongerThan == Integer.MAX_VALUE)
              d.seen.put(o, d.n);
            if (l(s) >= d.shareStringsLongerThan)
              d.strings.put(s, d.n);
          }
          quoteToPrintWriter(s, d.out);
          d.n++;
          return;
        }
        if (o instanceof Set) {
          if (((Set) o) instanceof TreeSet) {
            d.append(isCISet_gen(((Set) o)) ? "ciset" : "treeset");
            structure_1(new ArrayList(((Set) o)), d);
            return;
          }
          d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
          structure_1(new ArrayList(((Set) o)), d);
          return;
        }
        String name = c.getName();
        if (o instanceof Collection && !startsWith(name, "main$")) {
          if (name.equals("java.util.Collections$SynchronizedList") || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
            if (unwrapSynchronizedList(((List) o)) instanceof LinkedList)
              d.append("syncLL");
            else
              d.append("sync");
          } else if (name.equals("java.util.LinkedList"))
            d.append("ll");
          d.append("[");
          final int l = d.n;
          final Iterator it = ((Collection) o).iterator();
          d.stack.add(new Runnable() {

            public void run() {
              try {
                if (!it.hasNext())
                  d.append("]");
                else {
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(it.next(), d);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta...";
            }
          });
          return;
        }
        if (o instanceof Map && !startsWith(name, "main$")) {
          if (o instanceof LinkedHashMap)
            d.append("lhm");
          else if (o instanceof HashMap)
            d.append("hm");
          else if (o instanceof TreeMap)
            d.append(isCIMap_gen(((TreeMap) o)) ? "cimap" : "tm");
          else if (name.equals("java.util.Collections$SynchronizedMap"))
            d.append("sync");
          else if (name.equals("java.util.Collections$SynchronizedSortedMap")) {
            d.append("sync tm", 2);
          }
          d.append("{");
          final int l = d.n;
          final Iterator it = ((Map) o).entrySet().iterator();
          d.stack.add(new Runnable() {

            public boolean v = false;

            public Map.Entry e;

            public void run() {
              if (v) {
                d.append("=");
                v = false;
                d.stack.add(this);
                structure_1(e.getValue(), d);
              } else {
                if (!it.hasNext())
                  d.append("}");
                else {
                  e = (Map.Entry) it.next();
                  v = true;
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(e.getKey(), d);
                }
              }
            }
          });
          return;
        }
        if (c.isArray()) {
          if (o instanceof byte[]) {
            d.append("ba ").append(quote(bytesToHex((byte[]) o)));
            return;
          }
          final int n = Array.getLength(o);
          if (o instanceof boolean[]) {
            String hex = boolArrayToHex((boolean[]) o);
            int i = l(hex);
            while (i > 0 && hex.charAt(i - 1) == '0' && hex.charAt(i - 2) == '0') i -= 2;
            d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i)));
            return;
          }
          String atype = "array", sep = ", ";
          if (o instanceof int[]) {
            atype = "intarray";
            sep = " ";
          }
          d.append(atype).append("{");
          d.stack.add(new Runnable() {

            public int i;

            public void run() {
              if (i >= n)
                d.append("}");
              else {
                d.stack.add(this);
                if (i > 0)
                  d.append(", ");
                structure_1(Array.get(o, i++), d);
              }
            }
          });
          return;
        }
        if (o instanceof Class) {
          d.append("class(", 2).append(quote(((Class) o).getName())).append(")");
          return;
        }
        if (o instanceof Throwable) {
          d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")");
          return;
        }
        if (o instanceof BitSet) {
          BitSet bs = (BitSet) o;
          d.append("bitset{", 2);
          int l = d.n;
          for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i + 1)) {
            if (d.n != l)
              d.append(", ");
            d.append(i);
          }
          d.append("}");
          return;
        }
        if (name.startsWith("java.") || name.startsWith("javax.")) {
          d.append("j ").append(quote(str(o)));
          return;
        }
        String dynName = shortDynamicClassName(o);
        if (concept && !d.concepts.contains(dynName)) {
          d.concepts.add(dynName);
          d.append("c ");
        }
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {

          public int compare(Field a, Field b) {
            return stdcompare(a.getName(), b.getName());
          }
        });
        Class cc = c;
        while (cc != Object.class) {
          for (Field field : getDeclaredFields_cached(cc)) {
            String fieldName = field.getName();
            if (fieldName.equals("_persistenceInfo"))
              d.persistenceInfo.put(c, field);
            if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
              continue;
            fields.add(field);
          }
          cc = cc.getSuperclass();
        }
        lFields = asList(fields);
        for (int i = 0; i < l(lFields); i++) {
          Field f = lFields.get(i);
          if (f.getName().equals("this$1")) {
            lFields.remove(i);
            lFields.add(0, f);
            break;
          }
        }
        d.fieldsByClass.put(c, lFields);
      } else {
        Integer ref = d.seen.get(o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        d.seen.put(o, d.n);
      }
      Field persistenceInfoField = (Field) (d.persistenceInfo.get(c));
      Map<String, Object> persistenceInfo = persistenceInfoField == null ? null : (Map) persistenceInfoField.get(o);
      LinkedHashMap<String, Object> fv = new LinkedHashMap();
      for (Field f : lFields) {
        Object value;
        try {
          value = f.get(o);
        } catch (Exception e) {
          value = "?";
        }
        if (value != null && (persistenceInfo == null || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
          fv.put(f.getName(), value);
      }
      String name = c.getName();
      String shortName = dropPrefix("main$", name);
      if (startsWithDigit(shortName))
        shortName = name;
      if (concept && eq(fv.get("className"), shortName))
        fv.remove("className");
      if (o instanceof DynamicObject) {
        putAll(fv, (Map) fv.get("fieldValues"));
        fv.remove("fieldValues");
        shortName = shortDynamicClassName(o);
        fv.remove("className");
      }
      String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
      d.append(shortName);
      final int l = d.n;
      final Iterator it = fv.entrySet().iterator();
      d.stack.add(new Runnable() {

        public void run() {
          try {
            if (!it.hasNext()) {
              if (d.n != l)
                d.append(")");
            } else {
              Map.Entry e = (Map.Entry) it.next();
              d.append(d.n == l ? "(" : ", ");
              d.append((String) e.getKey()).append("=");
              d.stack.add(this);
              structure_1(e.getValue(), d);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else...";
        }
      });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> A popFirst(List<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(0);
    return a;
  }

  public static <A> A popFirst(Collection<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(a);
    return a;
  }

  public static long toM(long l) {
    return (l + 1024 * 1024 - 1) / (1024 * 1024);
  }

  public static String toM(long l, int digits) {
    return formatDouble(toM_double(l), digits);
  }

  public static File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      mkdirsForFile(file);
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      vmBus_send("wroteFile", file);
      return file;
    } finally {
      action.done();
    }
  }

  public static File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String javaTokWordWrap(String s) {
    return javaTokWordWrap(120, s);
  }

  public static String javaTokWordWrap(int cols, String s) {
    int col = 0;
    List<String> tok = javaTok(s);
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && col >= cols && !containsNewLine(t))
        tok.set(i, t = rtrimSpaces(t) + "\n");
      int idx = t.lastIndexOf('\n');
      if (idx >= 0)
        col = l(t) - (idx + 1);
      else
        col += l(t);
    }
    return join(tok);
  }

  public static void copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String ymd() {
    return ymd(now());
  }

  public static String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  public static String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  public static String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  public static int hours() {
    return hours(java.util.Calendar.getInstance());
  }

  public static int hours(java.util.Calendar c) {
    return c.get(java.util.Calendar.HOUR_OF_DAY);
  }

  public static long toK(long l) {
    return (l + 1023) / 1024;
  }

  public static void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll(vm_busListeners_live(), msg, arg);
    pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  public static void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  public static FixedRateTimer doEvery_daemon(long delay, final Object r) {
    return doEvery_daemon(delay, delay, r);
  }

  public static FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(true);
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
    return timer;
  }

  public static FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
    return doEvery_daemon(toMS(delaySeconds), r);
  }

  public static float abs(float f) {
    return Math.abs(f);
  }

  public static int abs(int i) {
    return Math.abs(i);
  }

  public static double abs(double d) {
    return Math.abs(d);
  }

  public static void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean warn_on = true;

  public static ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  public static void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  public static void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  public static <A> A firstOfType(Collection c, Class<A> type) {
    for (Object x : c) if (isInstanceX(type, x))
      return (A) x;
    return null;
  }

  public static List<Concept> conceptsOfType(String type) {
    return db_mainConcepts().conceptsOfType(type);
  }

  public static <A> List<A> filterByType(Iterable c, Class<A> type) {
    List<A> l = new ArrayList();
    if (c != null)
      for (Object x : c) if (isInstanceX(type, x))
        l.add((A) x);
    return l;
  }

  public static <A> List<A> filterByType(Object[] c, Class<A> type) {
    return filterByType(asList(c), type);
  }

  public static <A> List<A> filterByType(Class<A> type, Iterable c) {
    return filterByType(c, type);
  }

  public static <A> List<A> filterByDynamicType(Collection<A> c, String type) {
    List<A> l = new ArrayList();
    for (A x : c) if (eq(dynamicClassName(x), type))
      l.add(x);
    return l;
  }

  public static boolean hasType(Collection c, Class type) {
    for (Object x : c) if (isInstanceX(type, x))
      return true;
    return false;
  }

  public static String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  public static <A extends Concept> A findBackRef(Concept c, Class<A> type) {
    for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
      return (A) r.concept();
    return null;
  }

  public static <A extends Concept> A findBackRef(Class<A> type, Concept c) {
    return findBackRef(c, type);
  }

  public static String loadConceptsStructure(String progID) {
    return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
  }

  public static String loadConceptsStructure() {
    return loadConceptsStructure(dbProgramID());
  }

  public static void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  public static <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
    return concepts.countConcepts(c, params);
  }

  public static <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    return db_mainConcepts().countConcepts(c, params);
  }

  public static int countConcepts() {
    return db_mainConcepts().countConcepts();
  }

  public static int countConcepts(String className) {
    return db_mainConcepts().countConcepts(className);
  }

  public static <A extends Concept> int countConcepts(Concepts concepts, String className) {
    return concepts.countConcepts(className);
  }

  public static int countConcepts(Concepts concepts) {
    return concepts.countConcepts();
  }

  public static boolean dynamicObjectIsLoading() {
    return isTrue(getThreadLocal(DynamicObject_loading));
  }

  public static <A> List<A> addDyn(List<A> l, A a) {
    if (l == null)
      l = new ArrayList();
    l.add(a);
    return l;
  }

  public static Str concept(String name) {
    for (Str s : list(Str.class)) if (eqic(s.name, name) || containsIgnoreCase(s.otherNames, name))
      return s;
    return new Str(name);
  }

  public static <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        f.setAccessible(true);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  public static void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      f.setAccessible(true);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  public static Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  public static void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  public static <A> List<A> removeDyn(List<A> l, A a) {
    if (l == null)
      return null;
    l.remove(a);
    return empty(l) ? null : l;
  }

  public static <A> MultiSetMap<String, A> ciMultiSetMap() {
    MultiSetMap<String, A> mm = new MultiSetMap();
    mm.data = ciMap();
    return mm;
  }

  public static <A, B> MultiSet<A> multiSetMapToMultiSet(MultiSetMap<A, B> mm) {
    MultiSet<A> ms = new MultiSet();
    for (A a : keys(mm)) ms.add(a, l(mm.get(a)));
    return ms;
  }

  public static <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator(final MultiSetMap<A, B> mm) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = iterator(asList(it.next()));
        }
        return it2.next();
      }
    });
  }

  public static <A, B> MultiMap<A, B> treeMultiMap() {
    return new MultiMap(true);
  }

  public static <A, B> MultiMap<A, B> treeMultiMap(Comparator<A> comparator) {
    return new MultiMap(new TreeMap<A, List<B>>(comparator));
  }

  public static Comparator reverseOrder() {
    return new Comparator() {

      public int compare(Object a, Object b) {
        return cmp(b, a);
      }
    };
  }

  public static <A, B> IterableIterator<B> navigableMultiMapValuesIterator(final MultiMap<A, B> mm) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<List<B>> it = concurrentlyIterateValues((NavigableMap) mm.data);

      public Iterator<B> it2;

      public B get() {
        while (it2 == null || !it2.hasNext()) {
          if (!it.hasNext())
            return null;
          it2 = concurrentlyIterateList(it.next());
        }
        return it2.next();
      }
    });
  }

  public static Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  public static Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  public static Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  public static Class _run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  public static void cancelAndInterruptThread(Thread t) {
    if (t == null)
      return;
    cancelThread(t);
    t.interrupt();
  }

  public static String combineWithSlash(String a, String b) {
    return joinNempties("/", a, b);
  }

  public static void cleanUpAndClear(Collection c) {
    if (c == null)
      return;
    cleanUp(c);
    c.clear();
  }

  public static void cleanUpAndClear(Map map) {
    if (map == null)
      return;
    cleanUp(map);
    map.clear();
  }

  public static <A> List<A> listCreateAndAdd(List<A> l, A a) {
    return addDyn(l, a);
  }

  public static boolean cleanUp_interruptThreads = false;

  public static void cleanUp(Object c) {
    if (c == null)
      return;
    if (c instanceof Collection) {
      cleanUp((Collection) c);
      return;
    }
    if (c instanceof Map) {
      for (Object o : keys((Map) c)) cleanUp(o);
      for (Object o : values((Map) c)) cleanUp(o);
      ((Map) c).clear();
      return;
    }
    try {
      preCleanUp(c);
      setOpt(c, "ping_pauseAll", false);
      innerCleanUp(c);
      List androids = (List) getOpt(c, "record_list");
      for (Object android : unnull(androids)) pcallOpt(android, "dispose");
      List<WeakReference> classes = (List<WeakReference>) (getOpt(c, "hotwire_classes"));
      if (classes != null)
        for (WeakReference cc : classes) {
          try {
            cleanUp(cc.get());
          } catch (Throwable __e) {
            _handleException(__e);
          }
        }
      if (cleanUp_interruptThreads) {
        List<Thread> threads = registeredThreads(c);
        if (nempty(threads)) {
          print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
          interruptThreads(threads);
        }
      }
    } catch (Throwable __e) {
      _handleException(__e);
    }
    setOpt(c, "cleaningUp_flag", false);
    if (c instanceof Class && ((Class) c).getName().equals("main"))
      retireClassLoader(((Class) c).getClassLoader());
  }

  public static void cleanUp(Collection l) {
    if (l == null)
      return;
    for (Object c : l) cleanUp(c);
    l.clear();
  }

  public static int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  public static <A> void remove(List<A> l, int i) {
    if (l != null && i >= 0 && i < l(l))
      l.remove(i);
  }

  public static <A> void remove(Collection<A> l, A a) {
    if (l != null)
      l.remove(a);
  }

  public static <A, B> Set<A> keySet(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  public static Set keySet(Object map) {
    return keys((Map) map);
  }

  public static <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }

  public static <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }

  public static <A> A reverseGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    int n = l(l);
    return idx < n ? l.get(n - 1 - idx) : null;
  }

  public static <A> List<A> concatLists(Collection<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Collection<A> list : lists) if (list != null)
        l.addAll(list);
    return l;
  }

  public static <A> List<A> concatLists(Collection<? extends Collection<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Collection<A> list : lists) if (list != null)
        l.addAll(list);
    return l;
  }

  public static Set emptySet() {
    return new HashSet();
  }

  public static <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  public static UnsupportedOperationException unsupportedOperation() {
    throw new UnsupportedOperationException();
  }

  public static <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  public static <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  public static <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && c.addAll(Arrays.asList(b));
  }

  public static <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll(b);
    return a;
  }

  public static void add(BitSet bs, int i) {
    bs.set(i);
  }

  public static <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  public static void add(Container c, Component x) {
    addToContainer(c, x);
  }

  public static <A> List<A> reversedList(Collection<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  public static Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  public static Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  public static <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  public static <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
    return map == null ? new TreeSet() : map.navigableKeySet();
  }

  public static <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }

  public static <A, B> NavigableSet<A> navigableKeys(MultiMap<A, B> mm) {
    return ((NavigableMap) mm.data).navigableKeySet();
  }

  public static String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  public static Map<String, Integer> findBot_cache = synchroHashMap();

  public static int findBot_timeout = 5000;

  public static DialogIO findBot(String searchPattern) {
    String subBot = null;
    int i = searchPattern.indexOf('/');
    if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
      subBot = searchPattern.substring(i + 1);
      searchPattern = searchPattern.substring(0, i);
      if (!isInteger(searchPattern))
        searchPattern = "Multi-Port at " + searchPattern + ".";
    }
    if (isInteger(searchPattern))
      return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    if (eq(searchPattern, "remote"))
      return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    Integer port = findBot_cache.get(searchPattern);
    if (port != null)
      try {
        DialogIO io = talkTo("localhost", port);
        io.waitForLine();
        String line = io.readLineNoBlock();
        if (indexOfIgnoreCase(line, searchPattern) == 0) {
          call(io, "pushback", line);
          return talkToSubBot(subBot, io);
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    List<ProgramScan.Program> bots = quickBotScan();
    for (ProgramScan.Program p : bots) {
      if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) {
        findBot_cache.put(searchPattern, p.port);
        return talkToSubBot(subBot, talkTo("localhost", p.port));
      }
    }
    for (ProgramScan.Program p : bots) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            String name = subBots.get(vport);
            if (startsWithIgnoreCase(name, searchPattern))
              return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
          }
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
    }
    return null;
  }

  public static void nohupJavax(final String javaxargs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs);";
        }
      });
    }
  }

  public static void nohupJavax(final String javaxargs, final String vmArgs) {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs, vmArgs);";
        }
      });
    }
  }

  public static String fsI(String id) {
    return formatSnippetID(id);
  }

  public static String fsI(long id) {
    return formatSnippetID(id);
  }

  public static long waitForBotStartUp_timeoutSeconds = 60;

  public static String waitForBotStartUp(String botName) {
    for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
      sleepSeconds(i == 0 ? 0 : 1);
      String addr = getBotAddress(botName);
      if (addr != null)
        return addr;
    }
    throw fail("Bot not found: " + quote(botName));
  }

  public static Object rpc(String botName, String method, Object... args) {
    return unstructure_matchOK2OrFail(sendToLocalBot(botName, rpc_makeCall(method, args)));
  }

  public static Object rpc(DialogIO bot, String method, Object... args) {
    return unstructure_matchOK2OrFail(bot.ask(rpc_makeCall(method, args)));
  }

  public static String rpc_makeCall(String method, Object... args) {
    if (empty(args))
      return "call " + method;
    return format("call *", concatLists((List) ll(method), asList(args)));
  }

  public static void close(AutoCloseable c) {
    _close(c);
  }

  public static volatile boolean readLine_noReadLine = false;

  public static String readLine_lastInput;

  public static String readLine_prefix = "[] ";

  public static String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  public static String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  public static String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  public static int shorten_default = 100;

  public static String shorten(String s) {
    return shorten(s, shorten_default);
  }

  public static String shorten(String s, int max) {
    return shorten(s, max, "...");
  }

  public static String shorten(String s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return s;
    return s.length() <= max ? s : substring(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  public static String shorten(int max, String s) {
    return shorten(s, max);
  }

  public static volatile boolean conceptsAndBot_running = false;

  public static boolean conceptsAndBot_thinOnStart = true;

  public static void conceptsAndBot() {
    conceptsAndBot(null);
  }

  public static void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    try {
      ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable _e) {
      db_mainConcepts().dontSave = true;
      throw rethrow(_e);
    }
    db_mainConcepts().persist(autoSaveInterval);
    dbBot();
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  public static Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache(((Class) o));
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
    List<B> out = new ArrayList();
    if (l != null)
      for (A a : l) addIfNotNull(out, map.get(a));
    return out;
  }

  public static <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  public static <A> ArrayList<A> cloneList_noSync(Iterable<A> l) {
    return l instanceof Collection ? cloneList_noSync((Collection) l) : asList(l);
  }

  public static <A> ArrayList<A> cloneList_noSync(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    return new ArrayList<A>(l);
  }

  public static <A, B> MultiSet<A> multiMapAsMultiSet(MultiMap<A, B> mm) {
    MultiSet<A> ms = new MultiSet();
    for (A a : keys(mm)) ms.add(a, l(mm.get(a)));
    return ms;
  }

  public static String assertPossibleGlobalID(String s) {
    if (!possibleGlobalID(s))
      throw fail("Not an acceptable global ID: " + s);
    return s;
  }

  public static char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  public static char charPlus(char a, int b) {
    return (char) (((int) a) + b);
  }

  public static int mod(int n, int m) {
    return (n % m + m) % m;
  }

  public static long mod(long n, long m) {
    return (n % m + m) % m;
  }

  public static BigInteger mod(BigInteger n, int m) {
    return n.mod(bigint(m));
  }

  public static double mod(double n, double m) {
    return (n % m + m) % m;
  }

  public static String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  public static BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  public static BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  public static boolean cic(Collection<String> l, String s) {
    return containsIgnoreCase(l, s);
  }

  public static boolean cic(String[] l, String s) {
    return containsIgnoreCase(l, s);
  }

  public static boolean cic(String s, char c) {
    return containsIgnoreCase(s, c);
  }

  public static boolean cic(String a, String b) {
    return containsIgnoreCase(a, b);
  }

  public static String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  public static String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  public static boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  public static boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  public static boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  public static boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  public static boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  public static File conceptsFile(String progID) {
    return getProgramFile(progID, conceptsFileName());
  }

  public static File conceptsFile() {
    return conceptsFile(dbProgramID());
  }

  public static boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  public static boolean fileExists(File f) {
    return f != null && f.exists();
  }

  public static <A> A lastThat(List<A> l, Object pred) {
    for (int i = l(l) - 1; i >= 0; i--) {
      A a = l.get(i);
      if (checkCondition(pred, a))
        return a;
    }
    return null;
  }

  public static <A> A lastThat(Object pred, List<A> l) {
    return lastThat(l, pred);
  }

  public static boolean fileNotEmpty(File f) {
    return isFile(f) && fileSize(f) > 0;
  }

  public static List<File> sortByFileName(List<File> l) {
    return sortFilesByName(l);
  }

  public static List<File> conceptBackupFiles(String progID) {
    Pattern pat = Pattern.compile("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
    File dir = programDir(progID);
    List<File> l = new ArrayList();
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      l.add(f);
    }
    return l;
  }

  public static File javaxDataDir_dir;

  public static File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  public static File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  public static void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  public static void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  public static void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  public static String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  public static String stringIf(boolean b, String s) {
    return stringIfTrue(b, s);
  }

  public static void clearConceptsOf(String progID) {
    getProgramFile(progID, "concepts.structure").delete();
    getProgramFile(progID, "idCounter.structure").delete();
  }

  public static <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  public static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  public static List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  public static File programDir_mine;

  public static File programDir() {
    return programDir(getProgramID());
  }

  public static File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  public static File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  public static String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(File f, String defaultContents) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  public static String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  public static GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  public static GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  public static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  public static File getProgramDir() {
    return programDir();
  }

  public static File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  public static Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  public static Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      public final int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  public static String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  public static boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  public static String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  public static String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  public static char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  public static double parseDouble(String s) {
    return Double.parseDouble(s);
  }

  public static float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  public static boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  public static List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  public static <A> List<A> synchroLinkedList() {
    return Collections.synchronizedList(new LinkedList<A>());
  }

  public static SortedMap synchronizedTreeMap() {
    return synchroTreeMap();
  }

  public static Map synchronizedMap() {
    return synchroMap();
  }

  public static <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
    return synchroMap(map);
  }

  public static byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  public static boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  public static <A> A nuStubInnerObject(Class<A> c) {
    return nuStubInnerObject(c, null);
  }

  public static <A> A nuStubInnerObject(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      m.setAccessible(true);
      return (A) m.newInstance(new Object[] { null });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  public static <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          ctr.setAccessible(true);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  public static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
    if (fields == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      String field = e.getKey();
      Object val = e.getValue();
      boolean has = fieldMap.containsKey(field);
      if (has)
        setOpt(o, field, val);
      else {
        o.fieldValues = syncMapPut2_createLinkedHashMap(o.fieldValues, intern(field), val);
      }
    }
  }

  public static void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  public static void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  public static void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  public static int[] toIntArray(List<Integer> l) {
    int[] a = new int[l(l)];
    for (int i = 0; i < a.length; i++) a[i] = l.get(i);
    return a;
  }

  public static String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  public static TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  public static boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  public static boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  public static boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  public static boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  public static <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  public static Lock saveLock_lock = fairLock();

  public static Lock saveLock() {
    return saveLock_lock;
  }

  public static File tempFileFor(File f) {
    return new File(f.getPath() + "_temp");
  }

  public static FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  public static FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  public static FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  public static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  public static <A> A assertEquals(Object x, A y) {
    return assertEquals(null, x, y);
  }

  public static <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  public static void quoteToPrintWriter(String s, PrintWriter out) {
    if (s == null) {
      out.print("null");
      return;
    }
    out.print('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"') {
        out.print('\\');
        out.print(c);
      } else if (c == '\r')
        out.print("\\r");
      else if (c == '\n')
        out.print("\\n");
      else if (c == '\0')
        out.print("\\0");
      else
        out.print(c);
    }
    out.print('"');
  }

  public static String quoteCharacter(char c) {
    if (c == '\'')
      return "'\\''";
    if (c == '\\')
      return "'\\\\'";
    if (c == '\r')
      return "'\\r'";
    if (c == '\n')
      return "'\\n'";
    if (c == '\t')
      return "'\\t'";
    return "'" + c + "'";
  }

  public static boolean isCISet_gen(Iterable<String> l) {
    return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
  }

  public static <A> List<A> unwrapSynchronizedList(List<A> l) {
    if (eqOneOf(className(l), "java.util.Collections$SynchronizedList", "java.util.Collections$SynchronizedRandomAccessList"))
      return (List) get_raw(l, "list");
    return l;
  }

  public static boolean isCIMap_gen(Map map) {
    return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
  }

  public static String boolArrayToHex(boolean[] a) {
    return bytesToHex(boolArrayToBytes(a));
  }

  public static Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  public static String shortDynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    return shortClassName(o);
  }

  public static int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  public static int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  public static int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  public static int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  public static Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

  public static Field[] getDeclaredFields_cached(Class c) {
    Field[] fields;
    synchronized (getDeclaredFields_cache) {
      fields = getDeclaredFields_cache.get(c);
      if (fields == null) {
        getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
        for (Field f : fields) f.setAccessible(true);
      }
    }
    return fields;
  }

  public static boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  public static String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
  }

  public static double toM_double(long l) {
    return l / (1024 * 1024.0);
  }

  public static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  public static class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  public static CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  public static void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  public static int javaTok_n, javaTok_elements;

  public static boolean javaTok_opt = false;

  public static List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  public static List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  public static boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  public static String rtrimSpaces(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  public static void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static int year() {
    return localYear();
  }

  public static int year(long now) {
    return localYear(now);
  }

  public static int month() {
    return localMonth();
  }

  public static int month(long now) {
    return localMonth(now);
  }

  public static int dayOfMonth() {
    return localDayOfMonth();
  }

  public static int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  public static String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  public static String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  public static Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  public static Set vm_busListeners_live_cache;

  public static Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  public static Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  public static Map<String, Set> vm_busListenersByMessage_live_cache;

  public static Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  public static Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  public static TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  public static class SmartTimerTask extends TimerTask {

    public static String _fieldOrder = "r timer delay threadInfo lastRun";

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return "SmartTimerTask(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __521 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__521);
        }
      }
    }
  }

  public static long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  public static <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  public static String dynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return "main$" + ((DynamicObject) o).className;
    return className(o);
  }

  public static String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  public static String loadTextFilePossiblyGZipped(String fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  public static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
    File gz = new File(fileName + ".gz");
    return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
  }

  public static String loadTextFilePossiblyGZipped(File fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  public static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
    return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
  }

  public static String dbProgramID() {
    return getDBProgramID();
  }

  public static void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  public static Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  public static <A> IterableIterator<A> iteratorFromFunction(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = (A) callF(f);
        done = a == null;
      }
    }
    ;
    return new IFF();
  }

  public static <A> IterableIterator<A> iteratorFromFunction(final F0<A> f) {
    return iteratorFromFunction_f0(f);
  }

  public static <A, B> IterableIterator<B> concurrentlyIterateValues(final NavigableMap<A, B> map) {
    return iteratorFromFunction(new F0<B>() {

      public Iterator<A> it = keys(map).iterator();

      public A key;

      public B get() {
        synchronized (map) {
          try {
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          } catch (ConcurrentModificationException e) {
            print("Re-iterating");
            it = map.tailMap(key, false).keySet().iterator();
            if (!it.hasNext())
              return null;
            return map.get(key = it.next());
          }
        }
      }
    });
  }

  public static <A> IterableIterator<A> concurrentlyIterateList(final List<A> l) {
    return iteratorFromFunction_withEndMarker_f0(new F0<A>() {

      public int i;

      public A get() {
        int _i = i++;
        synchronized (l) {
          if (_i < l(l)) {
            A a = l.get(_i);
            if (a == iteratorFromFunction_endMarker)
              throw fail("no");
            return a;
          }
          return (A) iteratorFromFunction_endMarker;
        }
      }
    });
  }

  public static String defaultThreadName_name;

  public static String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  public static Runnable wrapAsActivity(Object r) {
    return toRunnable(r);
  }

  public static Thread newThread(Object runnable) {
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  public static Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  public static Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  public static Runnable toRunnable(final Object o) {
    if (o instanceof Runnable)
      return (Runnable) o;
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  public static Map<Thread, Boolean> _registerThread_threads;

  public static Object _onRegisterThread;

  public static Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  public static void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  public static void cancelThread(Thread t) {
    if (t == null)
      return;
    ping();
    synchronized (ping_actions) {
      ping_actions.put(t, "cancelled");
      ping_anyActions = true;
    }
  }

  public static String joinNempties(String sep, String... strings) {
    return joinStrings(sep, strings);
  }

  public static String joinNempties(String sep, Collection<String> strings) {
    return joinStrings(sep, strings);
  }

  public static void preCleanUp(Object c) {
    if (c instanceof Collection) {
      for (Object o : ((Collection) c)) cleanUp(o);
      return;
    }
    callOpt(c, "licensed_off");
    setOpt(c, "ping_anyActions", true);
    setOpt(c, "cleaningUp_flag", true);
  }

  public static void innerCleanUp(Object c) {
    if (!isFalse(pcallOpt(c, "cleanMeUp")))
      for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
        callOpt(c, name);
      } catch (Throwable e) {
        print("Error cleaning up: " + programID(c));
        _handleException(e);
      }
  }

  public static void innerCleanUp() {
    innerCleanUp(mc());
  }

  public static Object pcallOpt(Object o, String method, Object... args) {
    try {
      return callOpt(o, method, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  public static List<Thread> registeredThreads(Object o) {
    Map<Thread, Boolean> map = (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
    if (map == null)
      return ll();
    map.size();
    synchronized (map) {
      return asList(keys(map));
    }
  }

  public static List<Thread> registeredThreads() {
    _registerThread_threads.size();
    return asList(keys(_registerThread_threads));
  }

  public static String n2(long l) {
    return formatWithThousands(l);
  }

  public static String n2(Collection l) {
    return n2(l(l));
  }

  public static String n2(double l, String singular) {
    return n2(l, singular, singular + "s");
  }

  public static String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  public static String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  public static String n2(long l, String singular) {
    return n_fancy2(l, singular, singular + "s");
  }

  public static String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  public static String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  public static String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  public static String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  public static String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  public static String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  public static String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  public static List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  public static List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  public static void interruptThreads(Collection<Thread> threads) {
    for (Thread t : unnull(threads)) t.interrupt();
  }

  public static void interruptThreads(Class mainClass) {
    interruptThreads(registeredThreads(mainClass));
  }

  public static void retireClassLoader(ClassLoader cl) {
    if (isJavaXClassLoader(cl))
      setOptAll(cl, "retired", true, "retiredMarker", new DefunctClassLoader());
  }

  public static void addToContainer(final Container a, final Component b) {
    if (a != null && b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.add(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.add(b);";
        }
      });
    }
  }

  public static String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  public static DialogIO talkToSubBot(final long vport, final DialogIO io) {
    return talkToSubBot(String.valueOf(vport), io);
  }

  public static DialogIO talkToSubBot(final String subBot, final DialogIO io) {
    if (subBot == null)
      return io;
    return new talkToSubBot_IO(subBot, io);
  }

  public static class talkToSubBot_IO extends DialogIO {

    public String subBot;

    public DialogIO io;

    public talkToSubBot_IO(String subBot, DialogIO io) {
      this.io = io;
      this.subBot = subBot;
    }

    public boolean isStillConnected() {
      return io.isStillConnected();
    }

    public String readLineImpl() {
      return io.readLineImpl();
    }

    public boolean isLocalConnection() {
      return io.isLocalConnection();
    }

    public Socket getSocket() {
      return io.getSocket();
    }

    public void close() {
      try {
        io.close();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void sendLine(String line) {
      io.sendLine(format3("please forward to bot *: *", subBot, line));
    }
  }

  public static DialogIO talkTo(int port) {
    return talkTo("localhost", port);
  }

  public static int talkTo_defaultTimeout = 10000;

  public static int talkTo_timeoutForReads = 0;

  public static ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

  public static DialogIO talkTo(String ip, int port) {
    try {
      String full = ip + ":" + port;
      Map<String, DialogIO> map = talkTo_byThread.get();
      if (map != null && map.containsKey(full))
        return map.get(full);
      if (isLocalhost(ip) && port == vmPort())
        return talkToThisVM();
      return new talkTo_IO(ip, port);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static class talkTo_IO extends DialogIO {

    public String ip;

    public int port;

    public Socket s;

    public Writer w;

    public BufferedReader in;

    public talkTo_IO(String ip, int port) {
      this.port = port;
      this.ip = ip;
      try {
        s = new Socket();
        try {
          if (talkTo_timeoutForReads != 0)
            s.setSoTimeout(talkTo_timeoutForReads);
          s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
        } catch (Throwable e) {
          throw fail("Tried talking to " + ip + ":" + port, e);
        }
        w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
        in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }

    public boolean isStillConnected() {
      return !(eos || s.isClosed());
    }

    public void sendLine(String line) {
      try {
        Lock __557 = lock;
        lock(__557);
        try {
          w.write(line + "\n");
          w.flush();
        } finally {
          unlock(__557);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLineImpl() {
      try {
        return in.readLine();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
      try {
        if (!noClose)
          s.close();
      } catch (IOException e) {
      }
    }

    public Socket getSocket() {
      return s;
    }
  }

  public static List<ProgramScan.Program> quickBotScan() {
    return ProgramScan.quickBotScan();
  }

  public static List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
    return ProgramScan.quickBotScan(preferredPorts);
  }

  public static List<ProgramScan.Program> quickBotScan(String searchPattern) {
    List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
    for (ProgramScan.Program p : ProgramScan.quickBotScan()) if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
    return l;
  }

  public static String firstPartOfHelloString(String s) {
    int i = s.lastIndexOf('/');
    return i < 0 ? s : rtrim(s.substring(0, i));
  }

  public static boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  public static String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  public static String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  public static Class hotwireOnce(String programID) {
    return hotwireCached(programID, false);
  }

  public static void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  public static String getBotAddress(String bot) {
    List<ScannedBot> l = fullBotScan(bot);
    return empty(l) ? null : first(l).address;
  }

  public static Object unstructure_matchOK2OrFail(String s) {
    if (swic(s, "ok "))
      return unstructure_startingAtIndex(s, 3);
    else
      throw fail(s);
  }

  public static String sendToLocalBot(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        print(bot + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(bot + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  public static String sendToLocalBot(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        print(port + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(port + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  public static String format(String pat, Object... args) {
    return format3(pat, args);
  }

  public static String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  public static boolean isNonNegativeInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  public static void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  public static void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  public static String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  public static volatile Android3 dbBot_instance;

  public static Android3 dbBot() {
    return dbBot(dbBotStandardName());
  }

  public static Android3 dbBot(String name) {
    ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  public static void thinAProgramsBackups(String progID, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    Pattern pat = Pattern.compile("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
    File dir = programDir(progID);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      long time = timestampFromYMDH(year, month, day, hour);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  public static boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  public static <A> void addIfNotNull(Collection<A> l, A a) {
    if (a != null && l != null)
      l.add(a);
  }

  public static <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  public static boolean possibleGlobalID(String s) {
    return l(s) == globalIDLength() && allLowerCaseCharacters(s);
  }

  public static char firstChar(String s) {
    return s.charAt(0);
  }

  public static String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  public static String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  public static String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  public static String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  public static String prependIfNempty(String prefix, String s) {
    return empty(s) ? s : prefix + s;
  }

  public static boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  public static boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  public static boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  public static boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  public static <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  public static <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  public static Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  public static <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  public static Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  public static String conceptsFileName() {
    return "concepts.structure.gz";
  }

  public static boolean isFile(File f) {
    return f != null && f.isFile();
  }

  public static boolean isFile(String path) {
    return isFile(newFile(path));
  }

  public static List<File> sortFilesByName(List<File> l) {
    sort(l, new Comparator<File>() {

      public int compare(File a, File b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    return l;
  }

  public static List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  public static List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  public static String _userHome;

  public static String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  public static File userHome(String path) {
    return new File(userDir(), path);
  }

  public static File standardLogFile() {
    return getProgramFile("log");
  }

  public static void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  public static void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  public static String stringIfTrue(boolean b, String s) {
    return b ? s : "";
  }

  public static <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  public static String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  public static ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  public static void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  public static int gzInputStream_defaultBufferSize = 65536;

  public static GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  public static GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  public static Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  public static int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  public static Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  public static Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap<String, Field> instanceFieldsMap(Object o) {
    Class c = o.getClass();
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map;
  }

  public static TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  public static TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  public static String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  public static String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  public static <A> A liftLast(List<A> l) {
    if (l.isEmpty())
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  public static void _registerIO(Object object, String path, boolean opened) {
  }

  public static ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  public static void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  public static boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  public static <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  public static <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((msg != null ? msg + ": " : "") + (y) + " != " + (x));
    } else
      print("OK: " + (x));
    return y;
  }

  public static byte[] boolArrayToBytes(boolean[] a) {
    byte[] b = new byte[(l(a) + 7) / 8];
    for (int i = 0; i < l(a); i++) if (a[i])
      b[i / 8] |= 1 << (i & 7);
    return b;
  }

  public static boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  public static String rep(int n, char c) {
    return repeat(c, n);
  }

  public static String rep(char c, int n) {
    return repeat(c, n);
  }

  public static <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  public static <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  public static List collect(Collection c, String field) {
    return collectField(c, field);
  }

  public static List collect(String field, Collection c) {
    return collectField(c, field);
  }

  public static String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  public static String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  public static String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  public static List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  public static boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  public static int localYear() {
    return localYear(now());
  }

  public static int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  public static int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  public static int localMonth() {
    return localMonth(now());
  }

  public static int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  public static int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  public static Set vm_generalIdentityHashSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  public static Map vm_generalHashMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  public static List<VF1<Map>> _threadInfo_makers = synchroList();

  public static Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  public static List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  public static void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  public static AutoCloseable tempActivity(Object r) {
    return null;
  }

  public static long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  public static int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  public static int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  public static String loadGZTextFile(File file) {
    try {
      if (!file.isFile())
        return null;
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      InputStream fis = new FileInputStream(file);
      GZIPInputStream gis = newGZIPInputStream(fis);
      try {
        byte[] buffer = new byte[1024];
        int len;
        while ((len = gis.read(buffer)) != -1) {
          baos.write(buffer, 0, len);
        }
      } finally {
        fis.close();
      }
      baos.close();
      return fromUtf8(baos.toByteArray());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }
    }
    ;
    return new IFF2();
  }

  public static <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        a = f.get();
        have = true;
        if (a == iteratorFromFunction_endMarker)
          done = true;
      }
    }
    ;
    return new IFF2();
  }

  public static Runnable _topLevelErrorHandling(final Runnable runnable) {
    final Object info = _threadInfo();
    return new Runnable() {

      public void run() {
        try {
          try {
            _threadInheritInfo(info);
            runnable.run();
          } catch (Throwable __e) {
            _handleException(__e);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcall {\r\n      _threadInheritInfo(info);\r\n      runnable.run();\r\n    }";
      }
    };
  }

  public static Map vm_generalWeakSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  public static <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  public static String joinStrings(String sep, String... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  public static String joinStrings(String sep, Collection<String> strings) {
    StringBuilder buf = new StringBuilder();
    for (String s : unnull(strings)) if (nempty(s)) {
      if (nempty(buf))
        buf.append(sep);
      buf.append(s);
    }
    return str(buf);
  }

  public static <A> List<A> sorted(Collection<A> c, final Object comparator) {
    List<A> l = cloneList(c);
    sort(l, makeComparator(comparator));
    return l;
  }

  public static <A> List<A> sorted(Collection<A> c) {
    List<A> l = cloneList(c);
    sort(l);
    return l;
  }

  public static List<String> methodsStartingWith(Object o, final String prefix) {
    return filter(allMethodNames(o), new F1<String, Object>() {

      public Object get(String s) {
        try {
          return startsWith(s, prefix);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startsWith(s, prefix)";
      }
    });
  }

  public static String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  public static double fraction(double d) {
    return d % 1;
  }

  public static String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  public static String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  public static String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  public static String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  public static String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  public static boolean isJavaXClassLoader(ClassLoader cl) {
    return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
  }

  public static void setOptAll(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) setOpt(o, field, fields.get(field));
  }

  public static void setOptAll(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      setOpt(o, field, value);
    }
  }

  public static Object swing(Object f) {
    return swingAndWait(f);
  }

  public static <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  public static boolean isLocalhost(String ip) {
    return isLoopbackIP(ip) || eqic(ip, "localhost");
  }

  public static int vmPort() {
    return myVMPort();
  }

  public static DialogIO talkToThisVM() {
    return new talkToThisVM_IO();
  }

  public static class talkToThisVM_IO extends DialogIO {

    public List<String> answers = ll(thisVMGreeting());

    public boolean isLocalConnection() {
      return true;
    }

    public boolean isStillConnected() {
      return true;
    }

    public int getPort() {
      return vmPort();
    }

    public void sendLine(String line) {
      answers.add(or2(sendToThisVM_newThread(line), "?"));
    }

    public String readLineImpl() {
      try {
        return popFirst(answers);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
    }

    public Socket getSocket() {
      return null;
    }
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  public static Map<String, Integer> newFindBot2_cache = synchroHashMap();

  public static boolean newFindBot2_verbose = false;

  public static DialogIO newFindBot2(String name) {
    Integer port = newFindBot2_cache.get(name);
    if (port != null) {
      if (newFindBot2_verbose)
        print("newFindBot2: testing " + name + " => " + port);
      DialogIO io = talkTo(port);
      String q = format("has bot *", name);
      String s = io.ask(q);
      if (match("yes", s)) {
        io = talkToSubBot(name, io);
        call(io, "pushback", "?");
        return io;
      }
      newFindBot2_cache.remove(name);
      if (newFindBot2_verbose)
        print("newFindBot2: dropping " + name + " => " + port);
    }
    DialogIO io = findBot(name);
    if (io != null) {
      newFindBot2_cache.put(name, io.getPort());
      if (newFindBot2_verbose)
        print("newFindBot2: remembering " + name + " => " + port);
    }
    return io;
  }

  public static TreeMap<String, Class> hotwireCached_cache = new TreeMap();

  public static Lock hotwireCached_lock = lock();

  public static Class hotwireCached(String programID) {
    return hotwireCached(programID, true);
  }

  public static Class hotwireCached(String programID, boolean runMain) {
    return hotwireCached(programID, runMain, false);
  }

  public static Class hotwireCached(String programID, boolean runMain, boolean dependent) {
    Lock __739 = hotwireCached_lock;
    lock(__739);
    try {
      programID = formatSnippetID(programID);
      Class c = hotwireCached_cache.get(programID);
      if (c == null) {
        c = hotwire(programID);
        if (dependent)
          makeDependent(c);
        if (runMain)
          callMain(c);
        hotwireCached_cache.put(programID, c);
      }
      return c;
    } finally {
      unlock(__739);
    }
  }

  public static long round(double d) {
    return Math.round(d);
  }

  public static class ScannedBot {

    public String helloString;

    public String address;

    public ScannedBot(String helloString, String address) {
      this.address = address;
      this.helloString = helloString;
    }

    public ScannedBot() {
    }
  }

  public static List<ScannedBot> fullBotScan() {
    return fullBotScan("");
  }

  public static List<ScannedBot> fullBotScan(String searchPattern) {
    List<ScannedBot> bots = new ArrayList();
    for (ProgramScan.Program p : quickBotScan()) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = swic(botName, "Multi-Port") || isVM;
      if (swic(botName, searchPattern))
        bots.add(new ScannedBot(botName, "" + p.port));
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            botName = subBots.get(vport);
            if (swic(botName, searchPattern))
              bots.add(new ScannedBot(botName, p.port + "/" + vport));
          }
        } catch (Exception e) {
          e.printStackTrace();
        }
    }
    return bots;
  }

  public static boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  public static boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  public static Object unstructure_startingAtIndex(String s, int i) {
    return unstructure_tok(javaTokC_noMLS_iterator(s, i), false, null);
  }

  public static void consoleClearInput() {
    consoleSetInput("");
  }

  public static Object iteratorFromFunction_endMarker = new Object();

  public static <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = (A) callF(f);
        if (a == iteratorFromFunction_endMarker)
          done = true;
      }
    }
    ;
    return new IFF();
  }

  public static <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
    return iteratorFromFunction_withEndMarker_f0(f);
  }

  public static boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  public static String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  public static boolean isMainProgram() {
    return creator() == null;
  }

  public static void cleanKill() {
    cleanKillVM();
  }

  public static String actualUserHome_value;

  public static String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  public static File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  public static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  public static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  public static List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  public static List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  public static int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  public static long timestampFromYMDH(int y, int m, int d, int h) {
    return new GregorianCalendar(y, m - 1, d, h, 0).getTimeInMillis();
  }

  public static <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  public static boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 0.5)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age >= lastAge + 7)
      return true;
    return false;
  }

  public static boolean allLowerCaseCharacters(String s) {
    for (int i = 0; i < l(s); i++) if (Character.getType(s.charAt(i)) != Character.LOWERCASE_LETTER)
      return false;
    return true;
  }

  public static String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  public static String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (val == html_valueLessParam())
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  public static <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  public static <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  public static Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  public static Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  public static Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  public static <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  public static <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  public static boolean even(int i) {
    return (i & 1) == 0;
  }

  public static boolean even(long i) {
    return (i & 1) == 0;
  }

  public static List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  public static List<File> listFilesOnly(File... dirs) {
    return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
  }

  public static File userDir() {
    return new File(userHome());
  }

  public static File userDir(String path) {
    return new File(userHome(), path);
  }

  public static Lock appendToFile_lock = lock();

  public static boolean appendToFile_keepOpen = false;

  public static HashMap<String, Writer> appendToFile_writers = new HashMap();

  public static void appendToFile(String path, String s) {
    try {
      Lock __793 = appendToFile_lock;
      lock(__793);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__793);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  public static void cleanMeUp_appendToFile() {
    AutoCloseable __795 = tempCleaningUp();
    try {
      Lock __794 = appendToFile_lock;
      lock(__794);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__794);
      }
    } finally {
      _close(__795);
    }
  }

  public static <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  public static TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  public static TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  public static boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  public static boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  public static String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  public static <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  public static <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  public static List collectField(Collection c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  public static List collectField(String field, Collection c) {
    return collectField(c, field);
  }

  public static SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  public static Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  public static Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  public static <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  public static Map syncHashMap() {
    return synchroHashMap();
  }

  public static String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, "UTF-8");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A, B> Map<A, B> newWeakMap() {
    return newWeakHashMap();
  }

  public static <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  public static Comparator makeComparator(final Object f) {
    if (f instanceof Comparator)
      return (Comparator) f;
    return new Comparator() {

      public int compare(Object a, Object b) {
        return (Integer) callF(f, a, b);
      }
    };
  }

  public static <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  public static List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  public static <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  public static <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  public static <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  public static <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  public static List<String> allMethodNames(Object o) {
    Class c = _getClass(o);
    TreeSet<String> names = new TreeSet();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) names.add(m.getName());
      c = c.getSuperclass();
    }
    return asList(names);
  }

  public static String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  public static void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  public static boolean isLoopbackIP(String ip) {
    return eq(ip, "127.0.0.1");
  }

  public static int myVMPort() {
    List records = (List) (get(getJavaX(), "record_list"));
    Object android = last(records);
    return or0((Integer) get(android, "port"));
  }

  public static String thisVMGreeting() {
    List record_list = (List) (get(getJavaX(), "record_list"));
    Object android = first(record_list);
    return getString(android, "greeting");
  }

  public static String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  public static String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  public static String sendToThisVM_newThread(String s, Object... args) {
    final String _s = format(s, args);
    try {
      return (String) evalInNewThread(new F0<Object>() {

        public Object get() {
          try {
            return callStaticAnswerMethod(getJavaX(), _s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ret callStaticAnswerMethod(getJavaX(), _s);";
        }
      });
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      return str(e);
    }
  }

  public static boolean match(String pat, String s) {
    return match3(pat, s);
  }

  public static boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  public static boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  public static Object makeDependent_postProcess;

  public static void makeDependent(Object c) {
    if (c == null)
      return;
    assertTrue("Not a class", c instanceof Class);
    dependentClasses();
    hotwire_classes.add(new WeakReference(c));
    Object local_log = getOpt(mc(), "local_log");
    if (local_log != null)
      setOpt(c, "local_log", local_log);
    Object print_byThread = getOpt(mc(), "print_byThread");
    if (print_byThread != null)
      setOpt(c, "print_byThread", print_byThread);
    callF(makeDependent_postProcess, c);
  }

  public static void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  public static List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  public static boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  public static boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  public static boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  public static String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  public static WeakReference<Object> creator_class;

  public static Object creator() {
    return creator_class == null ? null : creator_class.get();
  }

  public static boolean exposeMethods2_debug = false;

  public static String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  public static String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  public static int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  public static Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  public static Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  public static Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  public static <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  public static Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  public static Object html_valueLessParam_cache;

  public static Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  public static Object html_valueLessParam_load() {
    return new Object();
  }

  public static String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  public static List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  public static List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  public static List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  public static List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  public static Object rcurry(final Object f, final Object arg) {
    int n = numberOfFunctionArguments(f);
    if (n == 0)
      throw fail("function takes no arguments");
    if (n == 1)
      return new F0() {

        public Object get() {
          return callF(f, arg);
        }
      };
    if (n == 2)
      return new F1() {

        public Object get(Object a) {
          return callF(f, a, arg);
        }
      };
    throw todo("currying a function with " + n + "arguments");
  }

  public static String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  public static AutoCloseable tempCleaningUp() {
    return tempSetTL(ping_isCleanUpThread, true);
  }

  public static void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  public static TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  public static TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  public static TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  public static Map vm_generalMap_map;

  public static Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  public static <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  public static <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  public static <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  public static <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  public static Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  public static <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  public static char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  public static int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  public static <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  public static <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  public static int or0(Integer i) {
    return i == null ? 0 : i;
  }

  public static long or0(Long l) {
    return l == null ? 0L : l;
  }

  public static double or0(Double d) {
    return d == null ? 0.0 : d;
  }

  public static String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  public static String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  public static String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  public static String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  public static Object evalInNewThread(final Object f) {
    final Flag flag = new Flag();
    final Var var = new Var();
    final Var<Throwable> exception = new Var();
    {
      startThread(new Runnable() {

        public void run() {
          try {
            try {
              var.set(callF(f));
            } catch (Throwable e) {
              exception.set(e);
            }
            flag.raise();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception...";
        }
      });
    }
    flag.waitUntilUp();
    if (exception.has())
      throw rethrow(exception.get());
    return var.get();
  }

  public static String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  public static String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  public static String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  public static String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  public static String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  public static boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  public static boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  public static boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  public static boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  public static List<Class> dependentClasses() {
    return cleanUpAndGetWeakReferencesList(hotwire_classes);
  }

  public static boolean headless() {
    return isHeadless();
  }

  public static JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            tf.setText(text);
            tf.selectAll();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tf.setText(text);\r\n    tf.selectAll();";
        }
      });
    }
    return tf;
  }

  public static JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  public static void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  public static void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  public static List<WeakReference<Class>> hotwire_classes = synchroList();

  public static Class<?> hotwireDependent(String src) {
    Class c = hotwire(src);
    makeDependent(c);
    return c;
  }

  public static File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  public static File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  public static Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  public static List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  public static Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  public static synchronized List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  public static String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  public static String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  public static Object[] asObjectArray(List l) {
    return toObjectArray(l);
  }

  public static String ok2(String s) {
    return "ok " + s;
  }

  public static boolean makeAndroid3_disable = false;

  public static class Android3 {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public synchronized void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  public abstract static class Responder {

    public abstract String answer(String s, List<String> history);
  }

  public static Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  public static Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  public static Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  public static void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  public static DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  public static String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  public static String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  public static boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  public static Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  public static ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  public static Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  public static String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  public static Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  public static String defaultBotName() {
    return getProgramTitle() + ".";
  }

  public static Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  public static String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  public static int numberOfFunctionArguments(Object f) {
    if (f instanceof F0)
      return 0;
    if (f instanceof F1)
      return 1;
    if (f instanceof VF1)
      return 1;
    if (f instanceof VF2)
      return 2;
    if (f instanceof VF3)
      return 3;
    if (f instanceof String)
      return numberOfMethodArguments(mc(), (String) f);
    return numberOfMethodArguments(f, "get");
  }

  public static RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  public static RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  public static boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  public static TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  public static String standardTimeZone_name = "Europe/Berlin";

  public static String standardTimeZone() {
    return standardTimeZone_name;
  }

  public static <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }

  public static Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  public static void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  public static <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  public static String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  public static <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  public static <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
    if (l == null)
      return null;
    synchronized (l) {
      List<A> out = new ArrayList();
      for (int i = 0; i < l(l); i++) {
        A a = l.get(i).get();
        if (a == null)
          l.remove(i--);
        else
          out.add(a);
      }
      return out;
    }
  }

  public static void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  public static JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  public static <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  public static List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  public static Object[] toObjectArray(Collection c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  public static void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  public static List<Object> record_list = synchroList();

  public static void record(Object o) {
    record_list.add(o);
  }

  public static Object addToMultiPort_responder;

  public static long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  public static long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  public static AtomicInteger dialogServer_clients = new AtomicInteger();

  public static boolean dialogServer_printConnects = false;

  public static ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  public static Set<String> dialogServer_knownClients = synchroTreeSet();

  public static int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  public static int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  public static void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  public static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  public static ServerSocket startDialogServer_serverSocket;

  public static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  public static boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  public static String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  public static String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  public static Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  public static <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  public static <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  public static <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  public static <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  public static <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  public static String dropFirst(int n, String s) {
    return substring(s, n);
  }

  public static String dropFirst(String s, int n) {
    return substring(s, n);
  }

  public static String dropFirst(String s) {
    return substring(s, 1);
  }

  public static String indentx(String s) {
    return indentx(indent_default, s);
  }

  public static String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  public static String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  public static String processID_cached;

  public static String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  public static String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  public static String getProgramTitle() {
    return getProgramName();
  }

  public static Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  public static int numberOfMethodArguments(Object o, String method) {
    Class c;
    boolean mustBeStatic = false;
    if (o instanceof Class) {
      c = (Class) o;
      mustBeStatic = true;
    } else
      c = o.getClass();
    Class _c = c;
    int n = -1;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if (mustBeStatic && !methodIsStatic(m))
          continue;
        int nn = l(m.getParameterTypes());
        if (n == -1)
          n = nn;
        else if (n != nn)
          throw fail("Variable number of method arguments: " + _c + "." + method);
      }
      c = c.getSuperclass();
    }
    if (n == -1)
      throw fail("Method not found: " + _c + "." + method);
    return n;
  }

  public static List<String> dropPunctuation_keep = ll("*", "<", ">");

  public static List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  public static String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  public static List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  public static void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  public static <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  public static boolean forbiddenPort(int port) {
    return port == 5037;
  }

  public static String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  public static Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  public static <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  public static ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  public static <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  public static <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  public static int indent_default = 2;

  public static String indent(int indent) {
    return repeat(' ', indent);
  }

  public static String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  public static String indent(String indent, String s) {
    return indent + s.replace("\n", "\n" + indent);
  }

  public static String indent(String s) {
    return indent(indent_default, s);
  }

  public static List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  public static String getProgramName_cache;

  public static String getProgramName() {
    Lock __1012 = downloadLock();
    lock(__1012);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__1012);
    }
  }

  public static void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  public static List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  public static Lock downloadLock_lock = fairLock();

  public static Lock downloadLock() {
    return downloadLock_lock;
  }

  public static String getSnippetTitleOpt(String s) {
    return isSnippetID(s) ? getSnippetTitle(s) : s;
  }

  public static String getSnippetTitle(String id) {
    try {
      if (id == null)
        return null;
      if (!isSnippetID(id))
        return "?";
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.getSnippetTitle(id);
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  public static IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  public static boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  public static boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  public static String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  public static boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  public static String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  public static String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  public static boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  public static String tb_mainServer_default = "http://code.botcompany.de:8081";

  public static Object tb_mainServer_override;

  public static String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  public static File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  public static boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  public static String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  public static int loadPage_defaultTimeout = 60000;

  public static ThreadLocal<String> loadPage_charset = new ThreadLocal();

  public static boolean loadPage_allowGzip = true, loadPage_debug;

  public static boolean loadPage_anonymous = false;

  public static int loadPage_verboseness = 100000;

  public static int loadPage_retries = 1;

  public static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  public static volatile int loadPage_forcedTimeout;

  public static ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  public static ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  public static ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (url.getProtocol().equals("https"))
        disableCertificateValidation();
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPageThroughProxy_enabled) {
          print("Trying proxy because of: " + e);
          try {
            return loadPageThroughProxy(str(url));
          } catch (Throwable e2) {
            print("  " + exceptionToStringShort(e2));
          }
        } else if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  public static String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  public static String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  public static String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (true) {
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if ((n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  public static String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  public static URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  public static boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  public static File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  public static <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new InvocationHandler() {

      public Object invoke(Object proxy, Method method, Object[] args) {
        return call(target, method.getName(), unnull(args));
      }
    });
  }

  public static <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  public static long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  public static File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  public static File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  public static String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  public static File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  public static String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  public static String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  public static String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  public static Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  public static String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  public static volatile boolean disableCertificateValidation_attempted = false;

  public static void disableCertificateValidation() {
    try {
      if (disableCertificateValidation_attempted)
        return;
      disableCertificateValidation_attempted = true;
      try {
        TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {

          public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
          }

          public void checkClientTrusted(X509Certificate[] certs, String authType) {
          }

          public void checkServerTrusted(X509Certificate[] certs, String authType) {
          }
        } };
        HostnameVerifier hv = new HostnameVerifier() {

          public boolean verify(String hostname, SSLSession session) {
            return true;
          }
        };
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  public static final boolean loadPageThroughProxy_enabled = false;

  public static String loadPageThroughProxy(String url) {
    return null;
  }

  public static <A> A printWithTime(A a) {
    print(hmsWithColons() + ": " + a);
    return a;
  }

  public static void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  public static Map vm_generalSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  public static InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    UnknownHostException lastException = null;
    for (int _repeat_1078 = 0; _repeat_1078 < 2; _repeat_1078++) {
      try {
        if (con instanceof HttpURLConnection)
          if (((HttpURLConnection) con).getResponseCode() == 500)
            throw new IOException(joinNemptiesWithColonSpace("Server code 500", tryToReadErrorStreamFromURLConnection(((HttpURLConnection) con))));
        return con.getInputStream();
      } catch (UnknownHostException e) {
        lastException = e;
        print("Retrying because of: " + e);
        continue;
      }
    }
    throw lastException;
  }

  public static String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  public static String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  public static byte[] utf8(String s) {
    return toUtf8(s);
  }

  public static Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  public static URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  public static URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  public static boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  public static File javaxCachesDir_dir;

  public static File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  public static File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  public static File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  public static File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  public static String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  public static File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  public static int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  public static String makePostData(Map<Object, Object> map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : map.entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  public static String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  public static volatile boolean muricaPassword_pretendNotAuthed = false;

  public static String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  public static String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  public static String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  public static volatile Object isAllowed_function;

  public static volatile boolean isAllowed_all = true;

  public static boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  public static String hmsWithColons() {
    return hmsWithColons(now());
  }

  public static String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  public static String getComputerID_quick() {
    return computerID();
  }

  public static String joinNemptiesWithColonSpace(String... strings) {
    return joinNempties(": ", strings);
  }

  public static String joinNemptiesWithColonSpace(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  public static String tryToReadErrorStreamFromURLConnection(URLConnection conn) {
    try {
      if (conn instanceof HttpURLConnection)
        return stream2string(((HttpURLConnection) conn).getErrorStream());
      return null;
    } catch (Throwable __e) {
      return null;
    }
  }

  public static Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  public static java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  public static File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  public static String lines(Iterable lines) {
    return fromLines(lines);
  }

  public static String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  public static List<String> lines(String s) {
    return toLines(s);
  }

  public static String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  public static String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  public static File parentFile(File f) {
    return dirOfFile(f);
  }

  public static File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  public static File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  public static File oneOfTheFiles(File... files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  public static File javaxSecretDir_dir;

  public static File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  public static File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  public static String _computerID;

  public static Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __1148 = computerID_lock;
      lock(__1148);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__1148);
      }
    }
    return _computerID;
  }

  public static String stream2string(InputStream in) {
    return utf8streamToString(in);
  }

  public static <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  public static File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  public static File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  public static String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  public static String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  public static String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  public static String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  public static IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  public static List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  public static int toLines_nextLineBreak(String s, int start) {
    for (int i = start; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  public static File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  public static File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  public static String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  public static String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  public static String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  public static String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  public static String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  public static CloseableIterableIterator<String> linesFromFile(File f) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
      return linesFromReader(utf8bufferedReader(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(newFile(path));
  }

  public static String readerToString(Reader r) {
    try {
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  public static CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  public static <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  public static CloseableIterableIterator<String> linesFromReader(Reader r) {
    final BufferedReader br = bufferedReader(r);
    return iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r));
  }

  public static BufferedReader bufferedReader(Reader r) {
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r), r);
  }

  public static FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  public static FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  public static String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  public static <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  public static String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  public static class Str extends Concept {

    public String name;

    public List<String> otherNames = new ArrayList();

    public Str() {
    }

    public Str(String name) {
      this.name = name;
    }

    public String toString() {
      return name;
    }
  }

  public static class MRUCache<A, B> extends LinkedHashMap<A, B> {

    public int maxSize = 10;

    public MRUCache() {
    }

    public MRUCache(int maxSize) {
      this.maxSize = maxSize;
    }

    public boolean removeEldestEntry(Map.Entry eldest) {
      return size() > maxSize;
    }
  }

  public abstract static class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {

    public void close() throws Exception {
    }
  }

  public static interface Producer<A> {

    public A next();
  }

  public static class ProgramScan {

    public static int threads = isWindows() ? 500 : 10;

    public static int timeout = 5000;

    public static String ip = "127.0.0.1";

    public static int quickScanFrom = 10000, quickScanTo = 10999;

    public static int maxNumberOfVMs_android = 4;

    public static int maxNumberOfVMs_nonAndroid = 50;

    public static int maxNumberOfVMs;

    public static boolean verbose = false;

    public static class Program {

      public int port;

      public String helloString;

      public Program(int port, String helloString) {
        this.helloString = helloString;
        this.port = port;
      }
    }

    public static List<Program> scan() {
      try {
        return scan(1, 65535);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public static List<Program> scan(int fromPort, int toPort) {
      return scan(fromPort, toPort, new int[0]);
    }

    public static List<Program> scan(int fromPort, int toPort, int[] preferredPorts) {
      try {
        Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
        int scanSize = toPort - fromPort + 1;
        String name = toPort < 10000 ? "bot" : "program";
        int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
        final ExecutorService es = Executors.newFixedThreadPool(threads);
        if (verbose)
          print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
        startTiming();
        List<Future<Program>> futures = new ArrayList();
        List<Integer> ports = new ArrayList();
        for (int port : preferredPorts) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        for (int port = fromPort; port <= toPort; port++) if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        es.shutdown();
        List<Program> programs = new ArrayList();
        long time = now();
        int i = 0;
        for (final Future<Program> f : futures) {
          if (verbose)
            print("Waiting for port " + get(ports, i++) + " at time " + (now() - time));
          Program p = f.get();
          if (p != null)
            programs.add(p);
        }
        if (verbose)
          print("Found " + programs.size() + " " + name + "(s) on " + ip);
        return programs;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public static Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
      return es.submit(new Callable<Program>() {

        @Override
        public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
      });
    }

    public static List<Program> quickScan() {
      return scan(quickScanFrom, quickScanTo);
    }

    public static List<Program> quickBotScan() {
      return quickBotScan(new int[0]);
    }

    public static List<Program> quickBotScan(int[] preferredPorts) {
      if (maxNumberOfVMs == 0)
        maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
      return scan(4999, 5000 + maxNumberOfVMs - 1, preferredPorts);
    }
  }

  public static class Matches {

    public String[] m;

    public Matches() {
    }

    public Matches(String... m) {
      this.m = m;
    }

    public String get(int i) {
      return i < m.length ? m[i] : null;
    }

    public String unq(int i) {
      return unquote(get(i));
    }

    public String fsi(int i) {
      return formatSnippetID(unq(i));
    }

    public String fsi() {
      return fsi(0);
    }

    public String tlc(int i) {
      return unq(i).toLowerCase();
    }

    public boolean bool(int i) {
      return "true".equals(unq(i));
    }

    public String rest() {
      return m[m.length - 1];
    }

    public int psi(int i) {
      return Integer.parseInt(unq(i));
    }

    public String toString() {
      return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")";
    }

    public int hashCode() {
      return _hashCode(toList(m));
    }

    public boolean equals(Object o) {
      return o instanceof Matches && arraysEqual(m, ((Matches) o).m);
    }
  }

  public static class Var<A> implements IVar<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public synchronized void clear() {
      v = null;
    }

    public String toString() {
      return str(get());
    }
  }

  public static interface IResourceLoader {

    public String loadSnippet(String snippetID);

    public String getTranspiled(String snippetID);

    public int getSnippetType(String snippetID);

    public String getSnippetTitle(String snippetID);

    public File loadLibrary(String snippetID);

    public File pathToJavaXJar();

    public File getSnippetJar(String snippetID, String transpiledSrc);
  }

  public static class DefunctClassLoader {
  }

  public static class FixedRateTimer extends java.util.Timer {

    public FixedRateTimer() {
      this(false);
    }

    public FixedRateTimer(boolean daemon) {
      this(defaultTimerName(), daemon);
    }

    public FixedRateTimer(String name) {
      this(name, false);
    }

    public FixedRateTimer(String name, boolean daemon) {
      super(name, daemon);
      _registerTimer(this);
    }

    public List<Entry> entries = synchroList();

    public static class Entry {

      public static String _fieldOrder = "task firstTime period";

      public TimerTask task;

      public long firstTime;

      public long period;

      public Entry() {
      }

      public Entry(TimerTask task, long firstTime, long period) {
        this.period = period;
        this.firstTime = firstTime;
        this.task = task;
      }

      public String toString() {
        return "Entry(" + task + ", " + firstTime + ", " + period + ")";
      }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
      entries.add(new Entry(task, now() + delay, period));
      super.scheduleAtFixedRate(task, delay, period);
    }

    public void cancel() {
      entries.clear();
      super.cancel();
    }

    public int purge() {
      entries.clear();
      return super.purge();
    }

    public FixedRateTimer changeRate(int newPeriod) {
      Object r = ((SmartTimerTask) first(entries).task).r;
      cancel();
      return doEvery(newPeriod, r);
    }
  }

  public static class Flag implements Runnable {

    public boolean up = false;

    public synchronized boolean raise() {
      if (!up) {
        up = true;
        notifyAll();
        return true;
      } else
        return false;
    }

    public synchronized void waitUntilUp() {
      while (!up) {
        try {
          wait();
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
      }
    }

    public synchronized void waitUntilUp(long timeout) {
      if (!up) {
        try {
          wait(timeout);
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
      }
    }

    public synchronized boolean isUp() {
      return up;
    }

    public boolean get() {
      return isUp();
    }

    public String toString() {
      return isUp() ? "up" : "down";
    }

    public void waitForThisOr(Flag otherFlag) {
      try {
        while (!isUp() && !otherFlag.isUp()) Thread.sleep(50);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void run() {
      raise();
    }
  }

  public static interface IVar<A> {

    public void set(A a);

    public A get();

    public boolean has();

    public void clear();
  }

  public static boolean isWindows() {
    return System.getProperty("os.name").contains("Windows");
  }

  public static String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  public static long stopTiming_defaultMin = 10;

  public static long startTiming_startTime;

  public static void startTiming() {
    startTiming_startTime = now();
  }

  public static void stopTiming() {
    stopTiming(null);
  }

  public static void stopTiming(String text) {
    stopTiming(text, stopTiming_defaultMin);
  }

  public static void stopTiming(String text, long minToPrint) {
    long time = now() - startTiming_startTime;
    if (time >= minToPrint) {
      text = or2(text, "Time: ");
      print(text + time + " ms");
    }
  }

  public static String fsi(String id) {
    return formatSnippetID(id);
  }

  public static List<String> quoteAll(Collection<String> l) {
    List<String> x = new ArrayList();
    for (String s : l) x.add(quote(s));
    return x;
  }

  public static int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static boolean arraysEqual(Object[] a, Object[] b) {
    if (a.length != b.length)
      return false;
    for (int i = 0; i < a.length; i++) if (neq(a[i], b[i]))
      return false;
    return true;
  }

  public static File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  public static String defaultTimerName_name;

  public static String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  public static Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

  public static void _registerTimer(java.util.Timer timer) {
    _registerTimer_list.add(timer);
  }

  public static void cleanMeUp__registerTimer() {
    cancelTimers(getAndClearList(_registerTimer_list));
  }

  public static FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  public static FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return timer;
  }

  public static FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  public static FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  public static File loadBinarySnippet(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  public static void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  public static <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  public static File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  public static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL("http://data.tinybrain.de/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  public static File loadDataSnippetToFile(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL("http://data.tinybrain.de/blobs/" + psI(snippetID)));
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  public static void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  public static void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  public static void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  public static boolean loadBufferedImage_useImageCache = true;

  public static BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isAbsolutePath(snippetIDOrURLOrFile))
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
      if (!isSnippetID(snippetIDOrURLOrFile))
        throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
      String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return loadBufferedImage(rl.loadLibrary(snippetID));
      File dir = imageSnippetsCacheDir();
      if (loadBufferedImage_useImageCache) {
        dir.mkdirs();
        File file = new File(dir, snippetID + ".png");
        if (file.exists() && file.length() != 0)
          try {
            return ImageIO.read(file);
          } catch (Throwable e) {
            e.printStackTrace();
          }
      }
      String imageURL = snippetImageURL_http(snippetID);
      print("Loading image: " + imageURL);
      BufferedImage image = imageIO_readURL(imageURL);
      if (loadBufferedImage_useImageCache) {
        File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
        ImageIO.write(image, "png", tempFile);
        tempFile.renameTo(new File(dir, snippetID + ".png"));
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static BufferedImage loadBufferedImage(File file) {
    try {
      return file.isFile() ? ImageIO.read(file) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  public static File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  public static String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  public static String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  public static ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  public static ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  public static byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  public static File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  public static String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1400000 && id < 1500000)
      return "http://butter.botcompany.de:8080/files/" + id + "?_pass=" + muricaPassword();
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "http://butter.botcompany.de:8080/1008823/raw/" + id + "?_pass=" + pw;
    } else
      return "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id + "&contentType=application/binary";
  }

  public static <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  public static void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static BufferedImage imageIO_readURL(String url) {
    try {
      if (startsWith(url, "https:"))
        disableCertificateValidation();
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isAbsolutePath(String s) {
    return s != null && new File(s).isAbsolute();
  }

  public static boolean isAbsolutePath(File f) {
    return f != null && f.isAbsolute();
  }

  public static File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  public static String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  public static String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  public static String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  public static String snippetImageURL(String snippetID, String contentType) {
    if (isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (id == 1000010 || id == 1000012)
      url = "http://tinybrain.de:8080/tb/show-blobimage.php?id=" + id;
    else if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://www.botcompany.de:8443/img/" + id;
    return url;
  }

  public static <A> A println(A a) {
    return print(a);
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  public static void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(total, 100000))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void renameFile_assertTrue(File a, File b) {
    try {
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  public static String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  public static int roundDownTo(int x, int n) {
    return x / n * n;
  }

  public static long roundDownTo(long x, long n) {
    return x / n * n;
  }

  public static boolean possibleMD5(String s) {
    return isMD5(s);
  }

  public static boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  public static boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }
}
