import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;


// See #1023660 for the older 99 lines version

// Customizations:

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken.Payload;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.nio.file.Files;
import javax.net.ssl.*;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.io.*;
import java.net.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.text.*;
import java.util.TimeZone;

class main {

static boolean asyncSearch = false;
static boolean allowMultipleCasesInValues = true;
static boolean showSliceSelector = true;
static boolean showGoogleLogIn = true;
static boolean makeAllKeysPages = true;
static boolean makeAllValuesPages = true; 
static boolean legacy = true; // We still have slices without applied fixes

static int maxSliceNameLength = 1024;
static int displayLength = 140;
static int sideDisplayLength = 50; // when in side bar
static int searchResultsToShow = 50;
static String sideSearchType = "literal";
static int maxBackgroundSlices = 1000;

// end of customizations

// in main DB
static class Slice extends Concept {
  static String _fieldOrder = "globalID caseID name sliceDumped indexed owner";
  GlobalID globalID = aGlobalIDObject();
  String caseID;
  String name;
  long sliceDumped; // wall time, set before dump starts
  boolean indexed = true;
  
  Ref<User> owner = new Ref();

  String defaultCaseID() {
    return uniqueFileNameUsingMD5_80_v2(name + " " + globalID);
  }
}

// in any DB
static class Page extends Concept {
  static String _fieldOrder = "globalID url q";
  String globalID = aGlobalID();
  String url, q;
  
  // for in-VM helper bots
  void quickPost(String key, String value) {
    new GetEntriesAndPost(_concepts).go(this, litmap("key", key, "value", value));
  }
}

abstract static class AbstractEntry extends Concept {
  static String _fieldOrder = "page count key ip signer";
  Ref<Page> page = new Ref();
  int count;
  String key;
  String ip;
  Ref<Signer> signer = new Ref();
  
  String q() { Page p = page.get(); return p == null ? null : page.get().q; }
}

static class Entry extends AbstractEntry {
  String globalID = aGlobalID(); // TODO: migrate to object
  String value;
}

static class MultiLineEntry extends AbstractEntry {
  GlobalID globalID = aGlobalIDObject();
  String value;
}

static class BlobEntry extends AbstractEntry {
  GlobalID globalID = aGlobalIDObject();
  long length;
  String md5;
}

// in main DB?
static class Signer extends Concept {
  static String _fieldOrder = "globalID publicKey trusted approvedBy";
  String globalID = aGlobalID();
  String publicKey;
  boolean trusted = false;
  String approvedBy;
}

static class User extends Concept {
  GlobalID globalID = aGlobalIDObject();
}

static class GoogleUser extends User {
  static String _fieldOrder = "googleLogInDate googleEmail googleFirstName googleLastName googleEmailVerified";
  long googleLogInDate;
  String googleEmail, googleFirstName, googleLastName;
  boolean googleEmailVerified = false;
}

// in main DB
static class Session extends Concept {
  static String _fieldOrder = "cookie selectedSlice slicePage googleLogInDate googleEmail googleFirstName googleLastName googleEmailVerified";
  String cookie;
  String selectedSlice; // global ID
  Page slicePage; // phasing out
  
  long googleLogInDate;
  String googleEmail, googleFirstName, googleLastName;
  boolean googleEmailVerified = false;
}

// singleton concept in every DB
static class SliceInfo extends Concept {
  GlobalID globalID;
  List<String> mandatoryBotVMBusIDs;
}

static class CentralIndexEntry {
  Set<Slice> slices = synchroLinkedHashSet();
}

// global constants

static Map<String, String> searchTypeToText = litmap(
  "leven" , "Leven",
  "literal" , "Literal",
  "scored" , "Scored");
  
// global vars

static volatile boolean started, broken;
static int sourceCodeLines;
static ConceptsLoadedOnDemand fan;
static ConceptsLoadedOnDemand backgroundFan;
static Map<String, LoadedSlice> loadedSlices = syncMap();
static Map<String, LoadedSlice> backgroundSlices = syncMap();
static Map<String, CentralIndexEntry> centralIndex = ciMap();
static Map<String, CentralIndexEntry> newCentralIndex = ciMap();
static long centralIndexMade; // wall time
static ReliableSingleThread rst_index = new ReliableSingleThread(new Runnable() {  public void run() { try {  makeCentralIndex(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "makeCentralIndex();"; }});

// end of global vars

static class LoadedSlice { // non-persistent class
  String caseID;
  Concepts cc;
  Slice sliceConcept;
  long lastAccess = sysNow();
  
  ConceptFieldIndexDesc idx_latestEntries, idx_latestCreatedPages, idx_latestChangedPages;
  
  LoadedSlice(String caseID, Concepts cc) {
  this.cc = cc;
  this.caseID = caseID;
    indexThings();
    
    // forward changes to Slice concept
    onConceptsChange(cc, new Runnable() {  public void run() { try { 
      cset(sliceConcept, "_modified" , now())
    ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "cset(sliceConcept, _modified := now())"; }});
    
    if (makeAllKeysPages && legacy)
      for (Entry e : list(cc, Entry.class))
        pageFromQ(e.key);
        
    if (makeAllValuesPages && legacy)
      for (Entry e : list(cc, Entry.class))
        pageFromQ(e.value);
  }
  
  void initialSetup(GlobalID globalID) {
    SliceInfo info = uniq(cc, SliceInfo.class);
    cset(info, "globalID", globalID);
  }
  
  // create if not there
  Page pageFromQ(String q) {
    return main.pageFromQ(cc, q);
  }

  void indexThings() {
    indexConceptFieldsCI(cc, Page.class, "url", Page.class, "q", Entry.class, "key", Entry.class, "value");
    indexConceptFields(cc, Signer.class, "publicKey");
    indexConceptFields(cc, Session.class, "cookie");
    indexSingletonConcept(cc, SliceInfo.class);
    idx_latestCreatedPages = new ConceptFieldIndexDesc(cc, Page.class, "created");
    idx_latestChangedPages = new ConceptFieldIndexDesc(cc, Page.class, "_modified");
    idx_latestEntries = new ConceptFieldIndexDesc(cc, Entry.class, "created");
  }
  
  boolean isMainSlice() { return empty(caseID); }
  GlobalID globalID() { return sliceConcept.globalID; }
}

public static void main(final String[] args) throws Exception {
  try {
    if (bootstrapDataFrom("#1023558")) deleteMyBackups();
    thinMyBackups();
    fan = slicesLoadedOnDemand(loadedSlices);
    mainConcepts = fan.get("", null);
    indexConceptFields(Slice.class, "globalID", Slice.class, "caseID");
    cset(uniq_returnIfNew(Slice.class,"caseID" , ""), "name" , "main slice");
    loadedSlices.get("").initialSetup(toGlobalIDObj(mainSliceGlobalID()));
    
    backgroundFan = slicesLoadedOnDemand(backgroundSlices);
    backgroundFan.lock = fan.lock;
  
    // legacy conversions!
    //deleteConcepts(Slice, globalID := GlobalID('wftlawbagrwprywn));
  
    // Approve this machine's key
    PKIKeyPair machineKey = agiBot_trustedKeyForMachine();
    if (machineKey != null) {
      print("Approving this machine's key: " + machineKey.publicKey);
      cset(uniq_sync(Signer.class, "publicKey" , machineKey.publicKey), "trusted" , true, "approvedBy" , "local");
    }
    
    sourceCodeLines = countLines(mySource());
    
    rst_index.trigger();
  } catch (Throwable e) { _handleException(e);
    broken = true;
  } finally {
    started = true;
  }
}

// Serve page

static Object html(String uri, final Map<String, String> params) { try {

  sleepWhile(() -> !started);
  if (broken) return serve500("Internal error");
  return new Request().serve(uri, params);
} catch (Exception __e) { throw rethrow(__e); } }

static class WorksOnSlice {
  Concepts cc;
  LoadedSlice slice;
  
  WorksOnSlice() {}
  WorksOnSlice(LoadedSlice slice) {
  this.slice = slice; cc = slice.cc; }
  
  void setSlice(LoadedSlice slice) {
    this.slice = slice;
    cc = slice.cc;
  }
  
  Page findPageFromParams(Map map) {
    String q = getString("q",map);
    return empty(q) ? null : findPageFromQ(q);
  }

  Page findOrMakePageFromParams(Map map) {
    return pageFromQ(getString("q",map));
  }
  
  Page findPageFromQ(String q) {
    return conceptWhereCI(cc, Page.class, "q", q);
  }
  
  Page pageFromQ(String q) {
    return slice.pageFromQ(q);
  }
  
  Set<Page> pagesForKeyAndValue(String key, String value) {
    List<Entry> entries = conceptsWhereIC(cc, Entry.class, "value", value, "key", key);
    return asSet(ccollect("page",entries));
  }
  
  Collection<String> keysForPageAndValue(String q, String value) {
    Page page = findPageFromQ(q);
    if (page == null) return null;
    return collect("key",conceptsWhereIC(cc, Entry.class, "page", page, "value", value));
  }

  // DB functions

  boolean hasPage(String q) { return hasConceptWhereIC(Page.class, "q", q); }
  String getValue(Page page, String key) {
    return page == null || empty(key) ? null : getString("value",highestByField("count",objectsWhereIC(findBackRefs(page, Entry.class), "key", key)));
  }
  String getValue(String page, String key) {
    return getValue(findPageFromQ(page), key);
  }
  String pageDisplayName(Page page) {
    /*S name = getValue(page, "read as");
    bool unnaturalName = nempty(name) && !eq(makeAGIDomain(name), page.url);
    ret unnaturalName ? name + " " + squareBracketed(page.url) : or2(name, unpackAGIDomainOpt(page.url));*/
    return page.q;
  }
  
  String renderThing(String s, boolean forceURLDisplay) {
    return forceURLDisplay || isURL(s) || isAGIDomain(s)
      ? ahref(fixAGILink(absoluteURL(s)), htmlencode2(shorten(displayLength, s)))
      : ahref(agiBlue_linkForPhrase(s,
          "slice" , slice.isMainSlice() ? null : slice.sliceConcept.globalID),
        htmlencode2(shorten(displayLength, s)));
  }

} // end of WorksOnSlice

static class Request extends WorksOnSlice {
  String cookie;
  Session session;
  String uri;
  Map<String, String> params;
  long started = sysNow();
  
  // when serving a concept page, info that may be grabbed
  // by thought bots
  List<Entry> usesAsKey;
  
  // should also work for standalone
  boolean isHomeDomain() {
    String domain = domain();
    return eqic(domain, "www.agi.blue") || !ewic(domain, ".agi.blue");
  }
  
  Object serve(String uri, Map<String, String> params) {
    this.uri = dropMultipleSlashes(uri);
    this.params = params;
    Matches m = new Matches();
    
    print(uri + " ? " + unnull(subBot_query()));
    
    // get cookie & session
    
    cookie = cookieFromUser();
    if (cookie != null)
      session = uniq_sync(Session.class, "cookie", cookie);
    else
      session = unlistedWithValues(Session.class);
      
    // check if user wants to change slices
      
    String selectSlice = params.get("slice");
    if (isGlobalID(selectSlice))
      cset(session, "selectedSlice" , selectSlice);
    if (session.selectedSlice == null)
      cset(session, "selectedSlice" , str(mainSliceGlobalID()));

    // get case ID
    
    String caseID = "";
    Slice sliceConcept = sliceConceptForGlobalID(session.selectedSlice);
    print("Selected slice: " + session.selectedSlice + ", obj? " + (sliceConcept != null));
    if (sliceConcept != null) caseID = sliceConcept.caseID;
    print("caseID: " + caseID);
    
    // load slice
    
    slice = assertNotNull(loadSlice(caseID, session.selectedSlice));
    cc = slice.cc;
    slice.sliceConcept = sliceConcept;
      
    // Check for special URIs

    if (swic(uri, "/bot/")) return serveBot();
    
    // eleu appends a slash to the URI if it's a single identifier, so we drop it again
    String uri2 = dropTrailingSlash(uri);
    
    if (eqic(uri2, "/google-verify")) {
      print("Google-verify started.");
      Payload payload = printStruct(googleVerifyUserToken2(googleSignInID(), params.get("token")));
      if (payload == null) return print("google-verify", "No");
      cset(session,
        "googleLogInDate" , now(),
        "googleEmail" , payload.getEmail(),
        "googleEmailVerified" , payload.getEmailVerified(),
        "googleFirstName" , strOrNull(payload.get("given_name")),
        "googleLastName" , strOrNull(payload.get("family_name")));
        
      return print("google-verify", payload.getEmail() + " " + (payload.getEmailVerified() ? "(verified)" : "(not verified)"));
    }
    
    if (eqic(uri2, "/search")) return serveScoredSearch();
    if (eqic(uri2, "/literalSearch")) return serveLiteralSearch();
    if (eqic(uri2, "/levenSearch")) return serveLevenSearch();
    
    if (eqic(uri2, "/query")) return serveQueryPage();
    if (eqic(uri2, "/createSlice")) return serveCreateSlicePage();
    
    String q = params.get("q");
    String domain = or2(params.get("domain"), domain());
    
    String raw = firstKeyWithValue("", params); // agi.blue?something
    if (nempty(raw) && empty(q)) q = raw;
    /*if (nempty(q)) {
      domain = makeAGIDomain(q);
      if (l(domain) > maximumDomainPartLength()) // escape with "domain="
        ret hrefresh(agiBlueURL() + hquery(+domain, key := "read as", value := q));
      ret hrefresh("http://" + domain + (eq(q, domain) ? "" : "/" +  hquery(key := "read as", value := q)));
      //uri = "/"; replaceMapWithParams(params, key := "read as", value := q);
    }*/
    String url = domain + dropTrailingSlash(uri);
    
    // domain to query
    //if (empty(q)) q = url;
    if (empty(q)) q = agiBlue_urlToQuery(url);
    
    Page page; boolean newPage = false; Pair<Page,Boolean> __6= uniqCI2_sync(cc, Page.class, "q", q); page = __6.a; newPage = __6.b;
    if (newPage) dbLog("New page", "q", q);
    //printStructs(+params, +raw, +q);
  
    Set<String> get = asCISet(nempties(subBot_paramsAsMultiMap().get("get")));
    
    String top = nempty(get) ? "" : hcomment("cookie: " + takeFirst(4, session.cookie))
      + hSilentComputatorWithFlag("agi.blue: " + q)
      + p(ahref(sliceHomeURL(),
        //hsnippetimg(#1101682, width := 565/5, height := 800/5, title := "Robot by Peerro @ DeviantArt")
        //hsnippetimg(#1101778, width := 96, height := 96, title := "agi.blue - a database for everything")
        hsnippetimg("#1101822", "width" , 314, "height" , 125, "title" , "agi.blue - Wikipedia for robots")
      ))
      + p(small(
          b(agiBlueNameHTML())
        + (agiBlue_isOriginal() ? "" : " " + targetBlank("http://agi.blue", "[original]"))
        + " | " + targetBlank(progLink(), "source code") + " of this web site (" + nLines(sourceCodeLines) + ") | " + targetBlank("https://gitter.im/agi-blue/community", "sponsor https?") + " | by " + targetBlank("https://BotCompany.de", "BC") + " | " + targetBlank("http://fiverr.tinybrain.de/", "Fiverr") + " | " + targetBlank("https://discordapp.com/invite/SEAjPqk", "Discord") + " | " + targetBlank("https://www.youtube.com/watch?v=b6jtRdV3Ev8", "Video")
        + " | " + targetBlank("http://code.botcompany.de/1024233", "Notes")
        + " | " + ahref(agiBlueURL() + "/query", "Query")
      ));
    
    if (empty(params.get("q")) && empty(raw) && isHomeDomain()) {
      //L<Page> pages = sortedByFieldDesc _modified(list(cc, Page)); // TODO: use index
      List<Page> pages = cloneList(slice.idx_latestChangedPages.objectIterator());
      int start = parseInt(params.get("start")), step = 100;
      String nav = pageNav2("/", l(pages), start, step, "start");
      String content = hform(b("GIVE ME INPUT: &nbsp; ") + htextinput("q", "autofocus" , true) + " " + hsubmit("Ask"))
        + h1(sliceAsHTML() + " has " + nPages(countConcepts(cc, Page.class)) + " and " + nConnections(countConcepts(cc, Entry.class)))
        + p(nav)
        + p_nemptyLines(map(pageToHTMLLink(), subList(pages, start, start+step)));

      return hhtml_agiBlue(hhead_title("Slice " + sliceConcept().name + " | agi.blue") // SERVE SLICE HOME PAGE
        + hbody(hfullcenterAndTopLeft(top + content
          + footer(),
          sliceSelector()
        )));
    }
        
    String key = trim(params.get("key")), value = trim(params.get("value"));
    List<Entry> entries = new GetEntriesAndPost(cc).go(page, params).entries;
    
    //S get = params.get('get);
    if (nempty(get))
      return serveJSON(collect("value",llNotNulls(firstThat(entries, e -> get.contains(e.key)))));
    
    String key2 = key, value2 = value; if (nempty(key) && nempty(value)) key2 = value2 = ""; // input reset
  
    boolean withHidden = eq(params.get("withHidden"), "1");
    Set<Integer> hide = new HashSet();
    if (!withHidden) for (Entry e : entries) if (eqic(e.key, "hide") && isSquareBracketedInt(e.value)) addAll(hide, e.count, parseInt(unSquareBracket(e.value)));
    MultiMap<Integer,String> mmMeta = new MultiMap();
    for (Entry e : entries) if (isSquareBracketedInt(e.key)) mmMeta.put(parseInt(unSquareBracket(e.key)), e.value);
    MultiMap<String, String> mm = new MultiMap();
    for (Entry e : entries) mm.put(e.key, e.value);
    
    //S name = or2(/* ouch */ last(mm.get("read as")), /* end ouch */ unpackAGIDomain(page.url), page.url);
    String name = page.q;
    
    // Find references
    
    List<Entry> refs = concatLists(conceptsWhereIC(cc, Entry.class, "value" , name),
      conceptsWhereIC(cc, Entry.class, "key" , name));
    Set<Page> refPages = asSet(ccollect("page",refs));
    refPages.remove(page); // don't list current page as reference
    
    // Search in page names (depending on default search type)
    
    List<Page> searchResults;
    if (eq(sideSearchType, "leven"))
      searchResults = levenSearch(page.q, "max" , 50);
    else if (eq(sideSearchType, "literal"))
      searchResults = literalSearch(page.q, "max" , 50);
    else
      searchResults = (List<Page>) dm_call("agiBlueSearch", "search", page.q, "maxResult" , searchResultsToShow+1, "agiBlueBotID" , programID(), "cc", cc);
    searchResults.remove(page);
    
    // Find uses as key
    usesAsKey = conceptsWhereIC(cc, Entry.class, "key" , page.q);
    
    String pageName_html = htmlEncode2(shorten(displayLength, name));

    String mainContents =
        top + h1(ahref_unstyled(agiBlue_pageURLWithSlice(page), pageName_html) + (newPage ? " [huh????]" : ""))
      + p_nemptyLines(map(entries, new F1<Entry, String>() { String get(Entry e) { try { 
        return !withHidden && (hide.contains(e.count) || eqic(e.key, "read as") && eqic(e.value, name)) ? ""
        : "[" + e.count + "] " +
          renderThing(e.key, false) + ": " +
          b(renderThing(e.value, cic(mmMeta.get(e.count), "is a URL")));
         } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "!withHidden && (hide.contains(e.count) || eqic(e.key, \"read as\") && eqic(e.va..."; }}))
      + hpostform(h3("Add an entry")
        + "Key: " + hinputfield("key" , key2) + " Value: " + hinputfield("value" , value2) + "<br><br>" + hsubmit("Add")
        )
        
      + p(ahref(agiBlueURL() + "/literalSearch" + hquery("q" , page.q), "[literal search]", "title" , "Search pages with a name containing this page's name literally")
       + " " +
       ahref(agiBlueURL() + "/levenSearch" + hquery("q" , page.q), "[leven search 1]", "title" , "Search pages with a Levenshtein similarity of 1 containing this page's name literally")
       + " " +
       ahref(agiBlueURL() + "/search" + hquery("q" , page.q), "[scored search]", "title" , "Search pages with ScoredSearch"))
       
       + (empty(usesAsKey) ? "" : h3(quote(pageName_html) + " as key")
       + p_nemptyLines_showFirst(50, map(usesAsKey, e ->
         pageToHTMLLink().get(e.page.get()) + unicode_spacedRightPointingTriangle() +
           pageName_html + unicode_spacedRightPointingTriangle() +
         pageToHTMLLink().get(pageFromQ(e.value))
       )));
       
      // end of mainContents
        
    String sideContents =
      hform(b("GIVE ME INPUT:") + " "
        + htextinput("q") + " "
        + hsubmit("Ask", "onclick" , "document.getElementById('newInputForm').target = '';") + " "
        + hsubmit("+Tab", "title" , "Ask and show result in a new tab", "onclick" , "document.getElementById('newInputForm').target = '_blank';"),
        "id" , "newInputForm")
      
      + h3("References (" + l(refPages) + ")")
      
      + p_nemptyLines_showFirst(10, map(pageToHTMLLink("displayLength" , sideDisplayLength), refPages))
      
      + h3(searchTypeToText.get(sideSearchType) + " search results (" + (l(searchResults) >= searchResultsToShow ? searchResultsToShow + "+" : str(l(searchResults))) + ")")
      
      + p_nemptyLines_showFirst(searchResultsToShow, map(pageToHTMLLink("displayLength" , sideDisplayLength), searchResults))
      
      + hdiv("", "id" , "extraStuff");
      
    // TODO: sync search delivery with WebSocket creation
    if (asyncSearch)
      doLater(6.0, new Runnable() {  public void run() { try {  dm_call("agiBlueSearch", "searchAndPost", page.q, "agiBlueBotID" , programID(), "cc", cc) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "dm_call(\"agiBlueSearch\", \"searchAndPost\", page.q, agiBlueBotID := programID()..."; }});
      
    // notify local interested parties
    vmBus_send("agiBlue_servingConceptPage", this, page);
    
    String iframe = params.get("render_iframe");
      
    // serve a concept page
    return hhtml_agiBlue(hhead_title(pageDisplayName(page)) + hbody(
      tag("table",
        tr(
          td(sliceSelector(), "valign" , "top")
        + td(sideContents, "align" , "right", "valign" , "top", "rowspan" , 2))
      + tr(td(mainContents +
        (empty(iframe) ? "" : iframe(iframe, "width" , 600, "height" , 400)) +
      footer(), "align" , "center", "valign" , "top")),
      "width" , "100%", "height" , "100%")));
  }
  
  Object servePagesToBot(Iterable<Page> pages) {
    return serveListToBot(map(pageToMap(wrapMapAsParams(params)), pages));
  }

  Object serveListToBot(Collection l) {
    if (nempty(params.get("max")))
      l = takeFirst(parseInt(params.get("max")), l);
    return serveJSON(l);
  }

  // uri starts with "/bot/"
  Object serveBot() {
    String q = params.get("q");
    
    if (eqic(uri, "/bot/hello")) return serveJSON("hello");
    if (eqic(uri, "/bot/hasPage")) return serveJSON(hasPage(q));
    if (eqic(uri, "/bot/randomPageContaining")) {
      assertNempty(q);
      return servePageToBot(random(filter(list(cc, Page.class), p -> cic(p.q, q))), params);
    }
    if (eqic(uri, "/bot/allPages"))
      return servePagesToBot(list(cc, Page.class));
    if (eqic(uri, "/bot/allPagesStartingWith")) {
      assertNempty(q);
      return servePagesToBot(filter(list(cc, Page.class), p -> swic(p.q, q)));
    }
    if (eqic(uri, "/bot/allPagesEndingWith")) {
      assertNempty(q);
      return servePagesToBot(filter(list(cc, Page.class), p -> ewic(p.q, q)));
    }
    if (eqic(uri, "/bot/allPagesContaining")) {
      assertNempty(q);
      return servePagesToBot(filter(list(cc, Page.class), p -> cic(p.q, q)));
    }
    if (eqic(uri, "/bot/allPagesContainingRegexp")) {
      assertNempty(q);
      Pattern pat = regexpIC(q);
      return servePagesToBot(filter(list(cc, Page.class), p -> regexpFindIC(pat, p.q)));
    }
    
    if (eqicOneOf(uri, "/bot/postSigned", /*"/bot/makePhysicalSlice",*/ "/bot/approveTrustRequest")) {
      String text = rtrim(params.get("text"));
      String key = getSignerKey(text);
      if (empty(key)) return subBot_serve500("Please include your public key");
      if (!isSignedWithKey(text, key)) return subBot_serve500("Signature didn't verify");
      text = dropLastTwoLines(text); // drop signer + sig line
      
      Signer signer = uniq_sync(Signer.class,"publicKey" , key);
      
      /*if (eqic(uri, "/bot/makePhysicalSlice")) {
        if (!signer.trusted) ret subBot_serve500("Untrusted signer");
        Page page = findPageFromParams(jsonDecodeMap(text));
        if (page == null) ret subBot_serve500("Page not found");
        ret serveJSON(uniq2_sync(PhysicalSlice, slicePage := page).b ? "Slice made" : "Slice exists");
      }*/
    
      if (eqic(uri, "/bot/postSigned")) {
        List out = new ArrayList();
        for (String line : tlft(text)) {
          Map<String, String> map = jsonDecodeMap(line);
          GetEntriesAndPost x = new GetEntriesAndPost(db_mainConcepts());
          x.signer = signer;
          Page page = findOrMakePageFromParams(map);
          if (page == null) { out.add("Invalid page reference"); continue; }
          x.go(page, map);
          out.add(x.newEntry ? "Saved" : x.entry != null ? "Entry exists" : "Need key and value");
        }
        return serveJSON(out);
      }
      
      if (eqic(uri, "/bot/approveTrustRequest")) {
        if (!signer.trusted) return subBot_serve500("Untrusted signer");
        Signer toApprove = conceptWhere(Signer.class,"publicKey" , trim(text));
        if (toApprove == null) return subBot_serve500("Signer to approve not found");
        cset(toApprove, "trusted" , true, "approvedBy" , signer.globalID);
        return serveJSON("Approved: " + trim(text));
      }
      
      return subBot_serve500("CONFUSION");
    }
    
    if (eqic(uri, "/bot/post")) {
      GetEntriesAndPost x = new GetEntriesAndPost(db_mainConcepts());
      x.go(pageFromQ(q), params);
      return serveJSON(x.newEntry ? "Saved" : x.entry != null ? "Entry exists" : "Need key and value");
    }
    
    if (eqic(uri, "/bot/entriesOnPage"))
      return serveJSON(map(entriesOnPage(findPageFromParams(params)), entryToMap(false)));
      
    if (eqic(uri, "/bot/entriesForKey"))
      return serveJSON(map(conceptsWhereIC(cc, Entry.class, "key" , params.get("key")), entryToMap(true)));
      
    if (eqic(uri, "/bot/lookup")) {
      String key = params.get("key");
      if (empty(key)) return serveJSON("Need key");
      String value = getValue(findPageFromParams(params), key);
      return serveJSON(empty(value) ? "" : litmap("value", value));
    }
  
    if (eqic(uri, "/bot/latestEntries"))
      return serveJSON(map(takeFirst(10, slice.idx_latestEntries.objectIterator()), entryToMap(true)));
    if (eqic(uri, "/bot/latestPages"))
      return serveJSON(map(takeFirst(10, slice.idx_latestCreatedPages.objectIterator()), pageToMap()));
    if (eqic(uri, "/bot/latestChangedPages"))
      return serveJSON(map(takeFirst(10, slice.idx_latestChangedPages.objectIterator()), pageToMap()));
      
    if (eqic(uri, "/bot/googleUsersCount"))
      return serveJSON(l(setMinus(collectAsCISet("googleEmail",list(Session.class)), "", null)));
      
    if (eqic(uri, "/bot/totalPageCount"))
      return serveJSON(countConcepts(Page.class));
    /*if (eqic(uri, "/bot/pageWithoutPhysicalSliceCount"))
      ret serveJSON(countConceptsWhere(Page, slice := null));
    if (eqic(uri, "/bot/physicalSliceCount"))
      ret serveJSON(countConcepts(PhysicalSlice));*/
    if (eqic(uri, "/bot/trustedSignersCount"))
      return serveJSON(countConcepts(Signer.class, "trusted" , true));
      
    if (eqic(uri, "/bot/valueSearch")) {
      String value = params.get("value");
      List<Entry> entries = conceptsWhereIC(cc, Entry.class, "value", value);
      return serveJSON(map(takeFirst(100, entries), entryToMap(true)));
    }
      
    if (eqic(uri, "/bot/keyAndValueSearch")) {
      String key = params.get("key"), value = params.get("value");
      Collection<Page> pages = pagesForKeyAndValue(key, value);
      return servePagesToBot(pages);
    }
    
    if (eqic(uri, "/bot/keyValuePairsByPopularity")) {
      List<Pair<String, String>> pairs = map(list(Entry.class), e -> pair(e.key, e.value));
      List<Pair<String, Integer>> pairs2 = multiSetTopPairs(ciMultiSet(map("pairToUglyStringForCIComparison",pairs)));
      return serveJSON(map(pairs2, p -> {
        String key; String value ; Pair<String,String> __7= pairFromUglyString(p.a); key = __7.a; value = __7.b;
        return litorderedmap("n" , p.b, "key", key, "value", value);
      }));
    }
    
    if (eqic(uri, "/bot/allKeys"))
      return serveListToBot(distinctCIFieldValuesOfConcepts(cc, Entry.class, "key"));
      
    if (eqic(uri, "/bot/allKeysByPopularity"))
      return serveListToBot(mapMultiSetByPopularity(distinctCIFieldValuesOfConcepts_multiSet(cc, Entry.class, "key"), (key, n) -> litorderedmap("n", n, "key", key)));
      
    if (eqic(uri, "/bot/dbSize"))
      return serveJSON(l(conceptsFile()));
      
    if (eqic(uri, "/bot/query"))
      return serveBotQuery();

    if (eqic(uri, "/bot/createSlice")) {
      Slice slice = createSlice(assertNempty(params.get("name")));
      return serveJSON(litorderedmap("id" , str(slice.globalID), "name" , slice.name));
    }
    
    if (eqic(uri, "/bot/dumpAllSlices") && authed()) {
      List<Map> out = new ArrayList();
      for (Slice slice : list(Slice.class)) try {
        out.add(litorderedmap("slice" , slice.caseID, "ms" , returnTimeFor(() -> dumpSliceToFile(loadBackgroundSlice(slice)))));
      } catch (Throwable e) { _handleException(e);
        out.add(litorderedmap(slice.caseID, "error" , exceptionToStringShort(e)));
      }
      return serveJSON(out);
    }
    
    if (eqic(uri, "/bot/dumpSlice")) {
      File f = dumpSliceToFile(slice);
      return "OK, saved as: " + f2s(f);
    }
    
    if (eqic(uri, "/bot/memStats")) {
      Map fg = cloneMap(loadedSlices);
      Map bg = cloneMap(backgroundSlices);
      return serveJSON(litcimap(
        "error" , checkDoubleLoads(),
        "centralIndexEntries" , l(centralIndex),
        "centralIndexMade" , renderHowLongAgo(centralIndexMade),
        "numLoadedForegroundSlices" , l(fg),
        "numLoadedBackgroundSlices" , l(bg),
        "loadedForegroundSlicesEstimatedSize" , longSum(map("estimatedSliceDataSize",keys(fg))),
        "loadedBackgroundSlicesEstimatedSize" , longSum(map("estimatedSliceDataSize",keys(bg))),
        "loadedForegroundSlices" , sortedIC(keysList(fg)),
        "loadedBackgroundSlices" , sortedIC(keysList(bg))));
    }
    
    if (eqic(uri, "/bot/centralIndexGet")) {
      CentralIndexEntry e = centralIndex.get(q);
      return serveJSON(e == null ? ll() : map(e.slices, sliceToMap()));
    }
    
    // return primary triple from each slice
    if (eqic(uri, "/bot/centralIndexGrab")) {
      CentralIndexEntry ie = centralIndex.get(q);
      List<Map> out = new ArrayList();
      if (ie != null) for (Slice slice : ie.slices) {
        LoadedSlice ls = loadBackgroundSlice(slice);
        WorksOnSlice wos = new WorksOnSlice(ls);
        Page page = wos.findPageFromQ(q);
        Iterable<Entry> entries = entriesOnPage(page);
        print("Page for " + q + " in slice " + ls.caseID + ": " + yesNo(page != null) + " - " + l(entries));
        Entry e = first(entries);
        if (e != null)
          out.add(litorderedmap("a" , page.q, "b" , e.key, "c" , e.value, "slice" , slice.caseID));
      }
      return serveJSON(out);
    }
    
    if (eqic(uri, "/bot/updateCentralIndex") && authed()) {
      rst_index.trigger();
      return "OK";
    }
    
    // end of bot methods
  
    return subBot_serve404();
  }
  
  Object serveBotQuery() {
    String query = params.get("query");
    return new Query(slice).process(query);
  }
  
  Object serveLiteralSearch() {
    String q = params.get("q");
    List<Page> searchResults = literalSearch(q);
    return serveSearchResults("literal search" , q, searchResultsToShow, searchResults);
  }
  
  List<Page> literalSearch(String q, Object... __) {
    int searchResultsToShow = optPar("max",__, 100);
    
    // quick search in random order
    //L<Page> searchResults = takeFirst(searchResultsToShow+1, filterIterator(iterator(list(cc, Page)), p -> cic(p.q, q));
    
    // full search, order by length
    return takeFirst(searchResultsToShow+1, pagesSortedByLength(filter(list(cc, Page.class), p -> cic(p.q, q))));
  }
  
  Object serveScoredSearch() {
    String q = params.get("q");
    List<Page> searchResults = (List<Page>) dm_call("agiBlueSearch", "search", q, "cc", cc);
    return serveSearchResults("scored search" , q, searchResultsToShow, searchResults);
  }
  
  Object serveLevenSearch() {
    String q = params.get("q");
    List<Page> searchResults = levenSearch(q);
    return serveSearchResults("leven search with distance 1" , q, searchResultsToShow, searchResults);
  }
  
  List<Page> levenSearch(String q, Object... __) {
    int searchResultsToShow = optPar("max",__, 100);
    int maxEditDistance = 1;
    
    Map<Page,Integer> map = new HashMap();
    for (Page p : list(cc, Page.class)) {
      int distance = leven_limitedIC(q, p.q, maxEditDistance+1);
      if (distance <= maxEditDistance) map.put(p, distance);
    }
    return takeFirst(searchResultsToShow+1, keysSortedByValue(map));
  }
  
  Object serveSearchResults(String searchType, String q, int searchResultsToShow, Collection<Page> searchResults) {
    String title = "agi.blue " + searchType + " for " + htmlEncode2(quote(q)) + " (" + (l(searchResults) >= searchResultsToShow ? searchResultsToShow + "+ results" : nResults(l(searchResults))) + ")";
    
    return hhtml_agiBlue(hhead_title(htmldecode_dropAllTags(title))
      + hbody(hfullcenter(//top +
        h3(title)
      + p_nemptyLines_showFirst(searchResultsToShow, map(pageToHTMLLink(), searchResults)))));
  }
  
  Object serveQueryPage() {
    String query = params.get("query");
    if (query == null) query = loadSnippet("#1024258");
    String title = agiBlueNameHTML() + " | Execute a query script (" + targetBlank("http://code.botcompany.de/1024274", "ALQL") + ")";
    return hhtml_agiBlue(hhead_title(htmldecode_dropAllTags(title))
      + hbody(hfullcenter(
        h3(title)
      + form(
        htextarea(query, "name" , "query", "cols" , 80, "rows" , 10, "autofocus" , true)
        + "<br><br>"
        + hsubmit("Execute"), "action" , "/bot/query")
      )));    
  }
  
  String sliceHomeURL() {
    return slice == null ? agiBlueURL() : sliceHomeURL(slice.sliceConcept.globalID);
  }

  String sliceHomeURL(GlobalID slice) {
    return agiBlueURL() + hquery("slice", slice);
  }
  
  Object serveCreateSlicePage() {
    String sliceName = trim(params.get("sliceName"));
    if (eq(params.get("doIt"), "1") && nempty(sliceName)) {
      // TODO: check for existing name
      Slice slice = createSlice(sliceName);
      return hrefresh(sliceHomeURL(slice.globalID));
    }
    
    String title = agiBlueNameHTML() + " | Create slice";
    return hhtml_agiBlue(hhead_title(htmldecode_dropAllTags(title))
      + hbody(hfullcenter(
        h3(title)
      + form(
          hhidden("doIt" , 1)
        + "Slice name: " + htextinput("sliceName", sliceName, "autofocus" , true)
        + "<br><br>"
        + hsubmit("Create slice"))
      )));    
  }
  
  F1<Page, String> pageToHTMLLink(Object... __) {
    int displayLength = optPar("displayLength",__,  main.displayLength);
    return new F1<Page, String>() { String get(Page p) { try { 
      String name = pageDisplayName(p);
      return ahref(agiBlue_pageURLWithSlice(p),
        htmlEncode2(shorten(displayLength, name)),
        "title" , name);
     } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "S name = pageDisplayName(p);\r\n      ret ahref(agiBlue_pageURLWithSlice(p),\r\n ..."; }};
  }
  
  // and google log-in
  String sliceSelector() {
    return htag("table",tr(
      (!showGoogleLogIn ? "" : td(
        googleSignIn_signInButton(agiBlueURL() + "/google-verify", "console.log(data);", ""), "style" , "padding-right: 10px;")
        + td(nobr(ahref("javascript:signOut()", "Sign out")), "style" , "padding-right: 10px; padding-bottom: 0.15em"))
    
    + (!showSliceSelector ? "" : hform(td(
        "Select reality slice: "
      + hselect(availableSlices(), session.selectedSlice, "name" , "slice", "onchange" , "this.form.submit()")
      /*+ " " + hsubmit("Go")*/
      + " &nbsp; " + ahref(agiBlueURL() + "/createSlice", "Create slice...")
    )))));
  }
  
  String sliceAsHTML() {
    if (slice.isMainSlice()) return htmlEncode2(agiBlueName() + "'s main slice");
    if (slice.sliceConcept == null) return "Slice ???";
    return htmlEncode2("Slice " + quote(slice.sliceConcept.name));
  }
  
  Slice sliceConcept() { return slice.sliceConcept; }
  
  String footer() {
    return p(small(elapsedMS_sysNow(started) + " ms"));
  }
  
  String verifiedEmail() {
    return session == null || !session.googleEmailVerified ? null
      : session.googleEmail;
  }
  
  boolean authed() {
    boolean ver = eqic(verifiedEmail(), "stefan.reich.maker.of.eye@googlemail.com");
    print("Auth check " + verifiedEmail() + " -> " + ver);
    return ver;
  }
  
  String googleSignInID() {
    return eqic(domain(), "botcompany.de") ? botCompanyGoogleSignInID() : agiBlueGoogleSignInID();
  }

  String hhtml_agiBlue(String contents) {
    return hhtml(hAddToHead_fast(contents, 
      hIncludeGoogleFont("Source Sans Pro")
      //+ [[<meta name="google-site-verification" content="oRvyeTqgSuv-FE_c-2UKM1Vp0oDqx8h9WruHYWqA-NQ" />]]
      + loadJQuery()
      + hmobilefix()
      + googleSignIn_header("", googleSignInID())
      + hstylesheet("body { font-family: Source Sans Pro }")));
  }

} // end of Request

static void dbLog(Object... params) {
  logStructure(programFile("db.log"), ll(params));
}

static IF1<Page, Map> pageToMap(Object... __) {
  boolean withEntries = boolPar("withEntries",__);
  
  boolean nameOnly = eqOneOf(optPar("nameOnly",__), "1", true);
  if (nameOnly) return (IF1<Page, Map>) p -> litmap("q" , p.q);
  
  return (IF1<Page, Map>) p -> {
    List<Entry> entries = findBackRefs(p, Entry.class);
    return litorderedmap(
      "q" , p.q,
      "nEntries" , l(entries),
      "created" , p.created,
      "modified" , p._modified,
      "entries" , !withEntries ? null : map(entries, entryToMap(false)));
  };
}

static IF1<Entry, Map> entryToMap(boolean withPage) {
  return (IF1<Entry, Map>) e -> litorderedmap(
    "created" , e.created,
    "i" , e.count,
    "key" , e.key,
    "value" , e.value,
    "q" , withPage ? e.page.get().q : null,
    "signer" , getString("globalID",e.signer.get()));
}

static IF1<Slice, Map> sliceToMap() {
  return (IF1<Slice, Map>) s -> litorderedmap(
    "created" , s.created,
    "globalID" , str(s.globalID),
    "name" , s.name,
    "caseID" , s.caseID);
}

static Object servePageToBot(Page page, Map<String, String> params) {
  if (page == null) return serveJSON(null);
  params = asCIMap(params);
  Map map = pageToMap("withEntries" , valueIs1("withEntries",params)).get(page);
  return serveJSON(map);
}

static class GetEntriesAndPost {
  Concepts cc;
  List<Entry> entries;
  Entry entry;
  boolean newEntry = false;
  Signer signer;
  
  GetEntriesAndPost(Concepts cc) {
  this.cc = cc;}
  
  GetEntriesAndPost go(Page page, Map<String, String> params) {
    String key = trim(params.get("key")), value = trim(params.get("value"));
    print("GetEntriesAndPost: " + quote(page.q) + ", " + quote(key) + " := " + quote(value));
    { withDBLock(new Runnable() {  public void run() { try { 
      entries = findBackRefs(page, Entry.class);
      if (nempty(key) && nempty(value)) {
        String ip = subBot_clientIP();
        entry = firstThat(e -> eqic(e.key, key) && eq_icIf(!allowMultipleCasesInValues, e.value, value) && eq(e.ip, ip), entries);
        if (entry == null) {
          print("SAVING");
          Entry e = cnew(cc, Entry.class, "page", page, "key", key, "value", value, "ip", ip, "count" , l(entries) + 1, "signer", signer);
          if (makeAllKeysPages) pageFromQ(cc, key);
          if (makeAllValuesPages) pageFromQ(cc, value);
          page.change(); // bump modification date
          entry = e;
          newEntry = true;
          entries.add(entry);
          dbLog("New entry", "page" , page.q, "globalID" , e.globalID, "count" , e.count, "key", key, "value", value);
        }
      }
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "entries = findBackRefs(page, Entry);\r\n      if (nempty(key) && nempty(value))..."; }}); }

    sortByFieldInPlace("created",entries);
    numberEntriesInConceptField("count",entries);
    return this;
  }
}

static Map<String, String> availableSlices() {
  return mapToOrderedMap(s -> pair(str(s.globalID), s.name + " [ID: " + s.globalID + "]"), list(Slice.class));
}

static List<Entry> entriesOnPage(Page p) {
  return p == null ? null : sortedByField("count",findBackRefs(p, Entry.class));
}

static List<Page> pagesSortedByLength(List<Page> l) {
  return sortedByCalculatedField(l, p -> l(p.q));
}

static boolean agiBlue_isOriginal() {
  return amProgram("#1023558");
}

static String agiBlueURL() {
  return agiBlue_isOriginal() ? "https://agi.blue" :  "/" + psI(programID()) + "/raw";
}

static String agiBlueName() {
  return agiBlue_isOriginal() ? "agi.blue" : "agi.blue clone " + programID();
}

static void cleanMeUp() {
  cleanUp(fan);
}

static LoadedSlice loadSlice(Slice slice) {
  return loadSlice(slice.caseID, str(slice.globalID));
}

static LoadedSlice loadSlice(String caseID, String globalID) {
  caseID = unnull(caseID);
  Lock __0 = fan.lock; lock(__0); try {
  
  // move slice from background to foreground
  
  Concepts cc = backgroundFan.getIfLoaded(caseID);
  if (cc != null) {
    LoadedSlice slice = assertNotNull(backgroundSlices.get(caseID));
    backgroundFan.loaded.remove(caseID);
    fan.loaded.put(caseID, cc);
    backgroundSlices.remove(caseID);
    loadedSlices.put(caseID, slice);
    return slice;
  }
  
  fan.get(caseID, globalID);
  return loadedSlices.get(caseID);
} finally { unlock(__0); } }

// load background slice
static LoadedSlice loadBackgroundSlice(Slice slice) {
  return loadBackgroundSlice(slice.caseID, str(slice.globalID));
}

static LoadedSlice loadBackgroundSlice(String caseID, String globalID) {
  caseID = unnull(caseID);
  Lock __1 = fan.lock; lock(__1); try {
  
  // check if in foreground
  
  if (fan.getIfLoaded(caseID) != null)
    return loadedSlices.get(caseID);

  backgroundFan.get(caseID, globalID);
  LoadedSlice slice = assertNotNull(backgroundSlices.get(caseID));
  slice.lastAccess = sysNow();
  while (l(backgroundSlices) > maxBackgroundSlices)
    unloadLeastRecentlyAccessedBackgroundSlice();
  return slice;
} finally { unlock(__1); } }

// TODO: sync unloading slice with accessors
static void unloadLeastRecentlyAccessedBackgroundSlice() {
  Lock __2 = fan.lock; lock(__2); try {
  String caseID = lowestByField("lastAccess",keys(backgroundSlices));
  if (caseID != null)
    backgroundFan.unloadCase(caseID);
} finally { unlock(__2); } }

static Slice sliceConceptForGlobalID(String globalID) {
  return sliceConceptForGlobalID(toGlobalIDObj(globalID));
}

static Slice sliceConceptForGlobalID(GlobalID globalID) {
  return conceptWhere(Slice.class,"globalID", globalID);
}

static Slice sliceConceptForCaseID(String caseID) {
  return conceptWhere(Slice.class,"caseID", caseID);
}

static String agiBlueNameHTML() {
  return ahref(agiBlueURL(), htmlEncode2(agiBlueName()));
}

static Slice createSlice(String name) {
  name = shorten(name, maxSliceNameLength);
  Slice slice = cnew(Slice.class,"name", name);
  cset(slice, "caseID" , slice.defaultCaseID());
  loadSlice(slice).initialSetup(slice.globalID);
  return slice;
}

static Slice sliceForName(String name) {
  return conceptWhereCI(Slice.class,"name", name);
}

static class Query extends WorksOnSlice {
  Map<String, String> vars = ciMap();
    
  Query(LoadedSlice slice) { super(slice); }
  
  Object process(String query) {
    { Object __4= processLines(agiBlue_parseQueryScript(query)); if (__4 != null) return __4; }
    return serveJSON("No return statement");
  }
    
  Object processLines(List<ALQLLine> lines) {
    for (ALQLLine line : lines) {
      if (line instanceof ALQLSlice) {
        Slice slice = sliceForName(((ALQLSlice) line).slice);
        if (slice == null) return serveJSON("Slice not found: " + ((ALQLSlice) line).slice);
        LoadedSlice oldSlice = Query.this.slice;
        try {
          setSlice(loadSlice(slice));
          { Object __5= processLines(((ALQLSlice) line).contents); if (__5 != null) return __5; }
        } finally {
          setSlice(oldSlice);
        }
      } else if (line instanceof ALQLReturn)
        return serveJSON(ll(getOrKeep(vars, ((ALQLReturn) line).var)));
      else if (line instanceof ALQLTriple) {
        T3<String, String, String> t = ((ALQLTriple) line).triple;
        t = tripleMap(t, s -> getOrKeep(vars, s));
        Collection<Page> pages;
        String var;
        if (isDollarVar(t.c)) {
          var = t.c;
          if (isDollarVar(t.a)) {
            if (isDollarVar(t.b)) throw todo(t);
            Entry e = random(conceptsWhereCI(cc, Entry.class, "key" , t.b));
            if (e == null) return serveJSON("No results for " + var);
            pages = pagesForKeyAndValue(t.b, t.c);
            vars.put(t.a, e.page.get().q);
            vars.put(t.c, e.value);
            continue;
          } else if (isDollarVar(t.b)) {
            Page page = findPageFromQ(t.a);
            Entry e = random(findBackRefs(page, Entry.class));
            if (e == null) return serveJSON("No results for " + var);
            vars.put(t.b, e.key);
            vars.put(t.c, e.value);
            continue;
          } else {
            String val = getValue(t.a, t.b);
            if (val == null) return serveJSON("No results for " + var);
            pages = ll(pageFromQ(val));
          }
        } else if (isDollarVar(t.b)) {
          var = t.b;
          if (isDollarVar(t.c)) throw todo(t);
          if (isDollarVar(t.a)) {
            List<Entry> entries = conceptsWhereCI(cc, Entry.class, "value" , t.c);
            if (empty(entries)) return serveJSON("No results for " + var);
            Entry e = random(entries);
            vars.put(t.a, e.page.get().q);
            vars.put(t.b, e.key);
            continue;
          } else {
            Collection<String> keys = keysForPageAndValue(t.a, t.c);
            if (empty(keys)) return serveJSON("No results for " + var);
            pages = map(new F1<String, Page>() { Page get(String x) { try {  return pageFromQ(x);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "pageFromQ(x)"; }}, keys);
          }
        } else {
          var = t.a;
          if (!isDollarVar(t.a)) throw todo(t);
          if (isDollarVar(t.b)) throw todo(t);
          if (isDollarVar(t.c)) throw todo(t);
          pages = pagesForKeyAndValue(t.b, t.c);
        }
        if (empty(pages)) return serveJSON("No results for " + var);
        vars.put(var, random(pages).q);
      } else if (line instanceof ALQLPage) {
        if (eq(((ALQLPage) line).matchMethod, "eqic"))
          findPageFromQ(((ALQLPage) line).page);
        else if (eq(((ALQLPage) line).matchMethod, "flexMatchDollarVarsIC_first")) {
          List<Map<String, String>> l = new ArrayList();
          for (Page p : list(cc, Page.class))
            addIfNotNull(l, flexMatchDollarVarsIC_first(((ALQLPage) line).page, p.q));
          if (empty(l)) return serveJSON("No results for " + curly(((ALQLPage) line).page));
          vars.putAll(random(l));
        } else
          throw fail("Unknown match method: " + ((ALQLPage) line).matchMethod);
      } else
        throw fail("Can't interpret: " + line);
    }
    
    return null;
  }
}

static Page pageFromQ(Concepts cc, String q) {
  return empty(q) ? null : uniqCI_sync(cc, Page.class, "q", q);
}

/*sS globalIDFromCaseID(S caseID) {
  ret assertGlobalID(takeLast(globalIDLength(), caseID));
}*/

static String agiBlue_pageURLWithSlice(Page p) {
  return p == null ? null : agiBlueURL() + hquery("slice" , _get(sliceForPage(p), "globalID"), "q" , p.q);
}

static Slice sliceForPage(Page p) {
  if (p == null) return null;
  SliceInfo info = conceptWhere(p._concepts, SliceInfo.class);
  return info == null ? null : sliceConceptForGlobalID(info.globalID);
}

static GlobalID mainSliceGlobalID() {
  return conceptWhere(Slice.class,"caseID" , "").globalID;
}

static File sliceDumpFile(Slice slice) {
  return programFile("slice-dumps/" + or2(slice.caseID, "main") + ".slice");
}

static File dumpSliceToFile(LoadedSlice slice) {
  return withDBLock(slice.cc, new F0<File>() { File get() { try { 
    cset(slice.sliceConcept, "sliceDumped" , now());
    File file = sliceDumpFile(slice.sliceConcept);
    List<String> lines = new ArrayList();
    for (Page p : list(slice.cc, Page.class))
      lines.add(quote(p.q));
    for (Entry e : list(slice.cc, Entry.class))
      lines.add(sfu(tripleToList(entryToTriple(e))));
    saveLinesAsTextFile(file, lines);
    return file;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "cset(slice.sliceConcept, sliceDumped := now());\r\n    File file = sliceDumpFil..."; }});
}

static T3<String, String, String> entryToTriple(Entry e) {
  return e == null ? null : t3(e.page.get().q, e.key, e.value);
}

static ConceptsLoadedOnDemand slicesLoadedOnDemand(Map<String, LoadedSlice> loadedSlices) {
  ConceptsLoadedOnDemand fan = new ConceptsLoadedOnDemand();
  fan.onCaseLoaded(new VF3<String, Object, Concepts>() { public void get(String caseID, Object globalID, Concepts concepts) { try { 
    LoadedSlice ls = new LoadedSlice(caseID, concepts);
    if (nempty(globalID))
      ls.initialSetup(toGlobalIDObj((String) globalID));
    loadedSlices.put(caseID, ls);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "LoadedSlice ls = new(caseID, concepts);\r\n    if (nempty(globalID))\r\n      ls...."; }});
  fan.onUnloadingCase(new VF2<String, Concepts>() { public void get(String caseID, Concepts concepts) { try { 
    loadedSlices.remove(caseID);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "loadedSlices.remove(caseID);"; }});
  return fan;
}

// check if slices are loaded both in foreground and background (BAD)
static String checkDoubleLoads() {
  List<String> l = sharedKeys(loadedSlices, backgroundSlices);
  return empty(l) ? null : "ERROR: Slice loaded in background and foreground: " + first(l);
}

// just use size of concepts.structure.gz
static long estimatedSliceDataSize(Slice slice) {
  return estimatedSliceDataSize(slice.caseID);
}

static long estimatedSliceDataSize(String caseID) {
  return l(conceptsFile(fan.dbID(caseID)));
}

static CentralIndexEntry centralIndexGet(String s) { return getOrCreate(CentralIndexEntry.class,centralIndex, s); }

static CentralIndexEntry newCentralIndexGet(String s) { return getOrCreate(CentralIndexEntry.class,newCentralIndex, s); }

// executed by rst_index
static void makeCentralIndex() {
  newCentralIndex.clear();
  try {
    for (Slice slice : conceptsWhere(Slice.class, "indexed" , true))
      addToNewCentralIndex(slice);
  } catch (Throwable __e) { _handleException(__e); }
  centralIndex.putAll(newCentralIndex);
  removeAllKeysNotIn(centralIndex, newCentralIndex);
  newCentralIndex.clear();
  centralIndexMade = now();
}

static void addToNewCentralIndex(Slice slice) {
  for (String s : sliceDump_pageNamesIncludingKeys(sliceDumpFile(slice)))
    newCentralIndexGet(s).slices.add(slice);
}
static String pairToUglyStringForCIComparison(Pair<String, String> p) {
  return p == null ? null : l(p.a) + "|" + p.a + "|" + p.b;
}
static GlobalID aGlobalIDObject() {
  return aGlobalIDObj();
}
static String uniqueFileNameUsingMD5_80_v2(String fullName) {
  return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
}

static String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
  return takeFirst(80-33, fileNameEncode(fullName)) + " - " + md5;
}
static String aGlobalID() {
  return randomID(globalIDLength());
}
static HashMap litmap(Object... x) {
  HashMap map = new HashMap();
  litmap_impl(map, x);
  return map;
}

static void litmap_impl(Map map, Object... x) {
  if (x != null) for (int i = 0; i < x.length-1; i += 2)
    if (x[i+1] != null)
      map.put(x[i], x[i+1]);
}
static <A> Set<A> synchroLinkedHashSet() {
  return Collections.synchronizedSet(new LinkedHashSet<A>());
}

static List syncMap(Object f, Map map) {
  return syncMap(map, f);
}

// map: func(key, value) -> list element
static List syncMap(Map map, Object f) {
  return map(cloneLinkedHashMap(map), f); // TODO: use a temporary list instead
}

static <A, B> Map<A, B> syncMap() {
  return synchroHashMap();
}
static <A> TreeMap<String, A> ciMap() {
  return caseInsensitiveMap();
}
static RuntimeException rethrow(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}

static RuntimeException rethrow(String msg, Throwable t) {
  throw new RuntimeException(msg, t);
}
static long sysNow() {
  ping();
  return System.nanoTime()/1000000;
}
static void onConceptsChange(Runnable r) {
  onConceptsChange(db_mainConcepts(), r);
}

static void onConceptsChange(Concepts cc, Runnable r) {
  cc.addConceptIndex(simpleConceptIndex(r));
  cc.onAllChanged.add(r);
}
// returns number of changes
static int cset(Concept c, Object... values) { try {
  if (c == null) return 0;
  int changes = 0;
  values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    Field f = setOpt_findField(c.getClass(), field);
    //print("cset: " + c.id + " " + field + " " + struct(value) + " " + f);
    if (value instanceof RC) value = c._concepts.getConcept((RC) value);
    value = deref(value);
    
    if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan) value = intern((String) value);
    
    if (f == null) {
      // TODO: keep ref if it exists
      mapPut2(c.fieldValues, assertIdentifier(field), value instanceof Concept ? c.new Ref((Concept) value) : value);
      c.change();
    } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
      ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
      c.change(); ++changes;
    } else {
      Object old = f.get(c);
      if (neq(value, old)) {
        f.set(c, value);
        if ((f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) == 0) c.change(); 
        ++changes;
      }
    }
  }
  return changes;
} catch (Exception __e) { throw rethrow(__e); } }
static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}

static <A extends Concept> List<A> list(Class<A> type) {
  return db_mainConcepts().list(type);
}

static <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
  return concepts.list(type);
}

static List<Concept> list(String type) {
  return db_mainConcepts().list(type);
}

static List<Concept> list(Concepts concepts, String type) {
  return concepts.list(type);
}

static <A extends Concept> A uniq(Class<A> c, Object... params) {
  return uniqueConcept(c, params);
}

static <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
  return uniqueConcept(cc, c, params);
}
static void indexConceptFieldsCI(Concepts concepts, Object... params) {
  for (int i = 0; i < l(params); i += 2)
    indexConceptFieldCI(concepts, (Class) params[i], (String) params[i+1]);
}
// first parameter can be Concepts
static void indexConceptFields(Object... params) {
  int i = 0;
  Concepts concepts;
  if (first(params) instanceof Concepts) {
    concepts = (Concepts) first(params);
    ++i;
  } else concepts = db_mainConcepts();
  for (; i < l(params); i += 2)
    indexConceptField(concepts, (Class) params[i], (String) params[i+1]);
}
static void indexSingletonConcept(Concepts cc, Class<? extends Concept> c) {
  indexConceptField(cc, c, "_dummy");
}
static boolean empty(Collection c) { return c == null || c.isEmpty(); }
static boolean empty(CharSequence s) { return s == null || s.length() == 0; }
static boolean empty(Map map) { return map == null || map.isEmpty(); }
static boolean empty(Object[] o) { return o == null || o.length == 0; }
static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  if (o instanceof byte[]) return empty((byte[]) o);
  if (o == null) return true;
  throw fail("unknown type for 'empty': " + getType(o));
}

static boolean empty(float[] a) { return a == null || a.length == 0; }
static boolean empty(int[] a) { return a == null || a.length == 0; }
static boolean empty(long[] a) { return a == null || a.length == 0; }
static boolean empty(byte[] a) { return a == null || a.length == 0; }


static boolean empty(MultiSet ms) { return ms == null || ms.isEmpty(); }


static boolean empty(File f) { return getFileSize(f) == 0; }
// true if it bootstrapped
static boolean bootstrapDataFrom(String progID) {
  File otherDir = javaxDataDir(progID);
  File myDir = programDir();
  if (sameFile(otherDir, myDir)) return false;
  if (!directoryIsEmpty(myDir)) return false;
  print("Importing data from: " + progID + " to " + programID());
  copyAllFilesInDirectory_rec_noOverwrite(otherDir, myDir);
  return true;
}
static void deleteMyBackups() {
  deleteFiles(conceptBackupFiles(dbProgramID()));
}
static void thinMyBackups() {
  thinAProgramsBackups(dbProgramID(), true);
}
static <A extends Concept> A uniq_returnIfNew(Class<A> c, Object... params) {
  Pair<A, Boolean> p = uniq2(c, params);
  return p.b ? p.a : null;
}
static GlobalID toGlobalIDObj(String s) {
  return s == null ? null : new GlobalID(s);
}

static GlobalID toGlobalIDObj(GlobalID globalID) {
  return globalID;
}
static PKIKeyPair agiBot_trustedKeyForMachine() {
  return pkiKeyPairFromTwoLineFile(agiBot_trustedKeyForMachine_file());
}


static volatile StringBuffer local_log = new StringBuffer(); // not redirected


static volatile Appendable print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;

static boolean print_silent = false; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<Object> print_byThread; // special handling by thread - prefers F1<S, Bool>
static volatile Object print_allThreads;
static volatile Object print_preprocess;

static void print() {
  print("");
}

static <A> A print(String s, A o) {
  print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
  return o;
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping_okInCleanUp();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  
  Object f = getThreadLocal(print_byThread_dontCreate());
  if (f == null) f = print_allThreads;
  if (f != null)
    // We do need the general callF machinery here as print_byThread is sometimes shared between modules
    if (isFalse(
      
        f instanceof F1 ? ((F1) f).get(s) :
      
      callF(f, s))) return;
  

  print_raw(s);
}

static void print_raw(String s) {
  
  if (print_preprocess != null) s = (String) callF(print_preprocess, s);
  s = fixNewLines(s);
  
  Appendable loc = local_log;
  Appendable buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  System.out.print(s);
}

static void print_autoRotate() {
  
}
static <A extends Concept> A uniq_sync(final Class<A> c, final Object... params) {
  return uniq_sync(db_mainConcepts(), c, params);
}

static <A extends Concept> A uniq_sync(Concepts concepts, Class<A> c, final Object... params) {
  return withDBLock(concepts, new F0<A>() { A get() { try {  return uniq(concepts, c, params);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret uniq(concepts, c, params);"; }});
}
static int countLines(String s) {
  return l(toLines(s)); // yeah could be optimized :-)
}
static String mySource() {
  return loadSnippet(programID());
}
static volatile PersistableThrowable _handleException_lastException;
static List _handleException_onException = synchroList(ll("printStackTrace2"));

static void _handleException(Throwable e) {
  _handleException_lastException = persistableThrowable(e);
  
  Throwable e2 = innerException(e);
  if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
    return;
    
  for (Object f : cloneList(_handleException_onException)) try {
    callF(f, e);
  } catch (Throwable e3) {
    printStackTrace2(e3); // not using pcall here - it could lead to endless loops
  }
}

static void sleepWhile(IF0<Boolean> pred, Object... __) {
  int interval = optPar("interval",__,  50); // ms
  double max = optPar("max",__,  10.0); // seconds
  long time = sysNow();
  while (sysNow() <= time+toMS(max) && pred.get())
    sleep(interval);
}
static NanoHTTPD.Response serve500() {
  return serve500("Internal Server Error");
}

static NanoHTTPD.Response serve500(String msg) {
  return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "Code 500 - " + msg);
}
static String getString(Map map, Object key) {
  return map == null ? null : (String) map.get(key);
}

static String getString(List l, int idx) {
  return (String) get(l, idx);
}

static String getString(Object o, Object key) {
  if (o instanceof Map) return getString((Map) o, key);
  if (key instanceof String)
    return (String) getOpt(o, (String) key);
  throw fail("Not a string key: " + getClassName(key));
}

static String getString(String key, Object o) {
  return getString(o, (Object) key);
}
static <A extends Concept> A conceptWhereCI(Class<A> c, Object... params) {
  return findConceptWhereCI(c, params);
}

static Concept conceptWhereCI(String c, Object... params) {
  return findConceptWhereCI(db_mainConcepts(), c, params);
}

static <A extends Concept> A conceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
  return findConceptWhereCI(concepts, c, params);
}

static Concept conceptWhereCI(Concepts concepts, String c, Object... params) {
  return findConceptWhereCI(concepts, c, params);
}
static <A extends Concept> List<A> conceptsWhereIC(Class<A> c, Object... params) {
  return conceptsWhereIC(db_mainConcepts(), c, params);
}

static List<Concept> conceptsWhereIC(String c, Object... params) {
  return conceptsWhereIC(db_mainConcepts(), c, params);
}

static <A extends Concept> List<A> conceptsWhereIC(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  return filterConceptsIC(concepts.list(c), params);
}

static List<Concept> conceptsWhereIC(Concepts concepts, String c, Object... params) {
  return filterConceptsIC(concepts.list(c), params);
}
static Set asSet(Object[] array) {
  HashSet set = new HashSet();
  for (Object o : array)
    if (o != null)
      set.add(o);
  return set;
}

static Set<String> asSet(String[] array) {
  TreeSet<String> set = new TreeSet();
  for (String o : array)
    if (o != null)
      set.add(o);
  return set;
}

static <A> Set<A> asSet(Iterable<A> l) {
  if (l instanceof Set) return (Set) l;
  HashSet<A> set = new HashSet();
  for (A o : unnull(l))
    if (o != null)
      set.add(o);
  return set;
}
static List ccollect(Collection<? extends Concept> c, String field) {
  List l = new ArrayList();
  if (c != null) for (Concept a : c)
    l.add(cget(a, field));
  return l;
}

static List ccollect(String field, Collection<? extends Concept> c) {
  return ccollect(c, field);
}
static List collect(Collection c, String field) {
  return collectField(c, field);
}

static List collect(String field, Collection c) {
  return collectField(c, field);
}

/*ifclass Concept
static L collect(Class c, S field) {
  ret collect(list(c), field);
}
endif
TODO: make translator ignore stuff in ifclass until resolved
*/
static boolean hasConceptWhereIC(Class<? extends Concept> c, Object... params) {
  return conceptWhereIC(c, params) != null;
}
static <A> A highestByField(String field, Collection<A> l) {
  A best = null;
  Object bestValue = null;
  if (l != null) for(A a : l) {
    Object val = getOpt(a, field);
    if (val != null && (bestValue == null || cmp(val, bestValue) > 0)) {
      best = a;
      bestValue = val;
    }
  }
  return best;
}

static <A> A highestByField(Collection<A> l, String field) {
  return highestByField(field, l);
}
static int count(Collection l, Object o) {
  int count = 0;
  for (Object x : l)
    if (eq(x, o))
      ++count;
  return count;
}
static <A> List<A> objectsWhereIC(Collection<A> c, Object... data) {
  if (c == null) return null;
  List<A> l = new ArrayList();
  for (A x : c)
    if (checkFieldsIC(x, data))
      l.add(x);
  return l;
}
static <A extends Concept> List<A> findBackRefs(Collection<? extends Concept> concepts, Class<A> type) {
  IdentityHashMap<A,Boolean> l = new IdentityHashMap();
  for (Concept c : concepts)
    if (c.backRefs != null) for (Concept.Ref r : c.backRefs)
      if (instanceOf(r.concept(), type))
        l.put((A) r.concept(), true);
  return asList(keys(l));
}

// TODO: sort by ID?
static <A extends Concept> List<A> findBackRefs(Concept c, Class<A> type) {
  IdentityHashMap<A,Boolean> l = new IdentityHashMap();
  if (c != null && c.backRefs != null) for (Concept.Ref r : c.backRefs)
    if (instanceOf(r.concept(), type))
      l.put((A) r.concept(), true);
  return asList(keys(l));
}
  
static <A extends Concept> List<A> findBackRefs(Class<A> type, Concept c) {
  return findBackRefs(c, type);
}

static boolean isURL(String s) {
  return startsWithOneOf(s, "http://", "https://", "file:");
}
static boolean isAGIDomain(String s) {
  return regexpMatchesIC("[a-z0-9-]+\\.agi\\.blue", s);
}
static String ahref(String link, Object contents, Object... params) {
  return link == null ? str(contents) : href(link, contents, params);
}
static String fixAGILink(String s) {
  if (!isAbsoluteURL(s)) return s;
  String host = hostNameFromURL(s);
  if (!isAGIBlueDomain(host)) return s;
  String sub = dropSuffixIC(theAGIBlueDomain(), host);
  if (l(sub) <= maximumDomainPartLength()) return s;
  return "http://" + theAGIBlueDomain() + hquery(mapPlus(paramsFromURL(s), "domain" , host));
}
static String absoluteURL(String url) {
  return isAbsoluteURL(url) ? url : "http://" + url;
}
static String htmlencode2(String s) {
  return htmlencode_noQuotes(s);
}
static int shorten_default = 100;

static String shorten(String s) { return shorten(s, shorten_default); }

static String shorten(String s, int max) {
  return shorten(s, max, "...");
}

static String shorten(String s, int max, String shortener) {
  if (s == null) return "";
  if (max < 0) return s;
  return s.length() <= max ? s : substring(s, 0, min(s.length(), max-l(shortener))) + shortener;
}

static String shorten(int max, String s) { return shorten(s, max); }
static String agiBlue_linkForPhrase(String phrase, Object... additionalParams) {
  return agiBlueURL() + hquery(arrayPlus /* allow multiple "get" parameters */(additionalParams, "q" , phrase));
}
static String domain() {
  return domainName();
}
static boolean eqic(String a, String b) {
  
  
    if ((a == null) != (b == null)) return false;
    if (a == null) return true;
    return a.equalsIgnoreCase(b);
  
}



static boolean eqic(char a, char b) {
  if (a == b) return true;
  
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2) return true;
  
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}
static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}


static boolean ewic(String a, String b, Matches m) {
  return endsWithIgnoreCase(a, b, m);
}

static String dropMultipleSlashes(String s) {
  return regexpReplace_direct(s, "//+", "/");
}
static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> Collection<A> unnull(Collection<A> l) {
  return l == null ? emptyList() : l;
}

static <A> List<A> unnull(List<A> l) {
  return l == null ? emptyList() : l;
}

static <A, B> Map<A, B> unnull(Map<A, B> l) {
  return l == null ? emptyMap() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static <A> A[] unnull(A[] a) {
  return a == null ? (A[]) new Object[0] : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}



//ifclass Symbol



static <A, B> Pair<A, B> unnull(Pair<A, B> p) {
  return p != null ? p : new Pair(null, null);
}

static String subBot_query() {
  return (String) mapGet(subBot_getHttpFiles(), "query");
}
static String cookieFromUser() {
  return (String) callOpt(getBot("#1002157"), "cookieFromUser");
}
// make concept instance that is not connected to DB & set fields
static <A extends Concept> A unlistedWithValues(Class<A> c, Object... params) {
  A a = unlisted(c);
  cset(a, params);
  return a;
}
static boolean isGlobalID(String s) {
  return possibleGlobalID(s);
}
static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
static boolean swic(String a, String b) {
  return startsWithIgnoreCase(a, b);
}


  static boolean swic(String a, String b, Matches m) {
    if (!swic(a, b)) return false;
    m.m = new String[] {substring(a, l(b))};
    return true;
  }

static String dropTrailingSlash(String s) {
  return dropSuffix("/", s);
}
static <A> A printStruct(String prefix, A a) {
  printStructure(prefix, a);
  return a;
}

static <A> A printStruct(A a) {
  printStructure(a);
  return a;
}

 // google http client
 // google api client
 // google oauth client
 // jackson
 // google jackson2
 // google http client appengine







static Payload googleVerifyUserToken2(String clientID, String token) { try {
  NetHttpTransport transport = new NetHttpTransport();
  
  GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder(transport, new JacksonFactory())
    .setAudience(Collections.singletonList(clientID))
    .build();
  
  GoogleIdToken idToken = verifier.verify(token);
  if (idToken != null)
    return idToken.getPayload();
  return null;
} catch (Exception __e) { throw rethrow(__e); } }
static String strOrNull(Object o) {
  return o == null ? null : str(o);
}
static String or2(String a, String b) {
  return nempty(a) ? a : b;
}

static String or2(String a, String b, String c) {
  return or2(or2(a, b), c);
}
static <A, B> A firstKeyWithValue(Map<A, B> map, B value) {
  if (map != null) for (Map.Entry<A, B> e : map.entrySet())
    if (eq(e.getValue(), value))
      return e.getKey();
  return null;
}

static <A, B> A firstKeyWithValue(B value, Map<A, B> map) {
  return firstKeyWithValue(map, value);
}
static boolean nempty(Collection c) {
  return !empty(c);
}

static boolean nempty(CharSequence s) {
  return !empty(s);
}

static boolean nempty(Object[] o) { return !empty(o); }
static boolean nempty(byte[] o) { return !empty(o); }
static boolean nempty(int[] o) { return !empty(o); }

static boolean nempty(Map m) {
  return !empty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}

static boolean nempty(Object o) { return !empty(o); }
static String agiBlue_urlToQuery(String url) {
  String s = unpackAGIDomainOpt(url);
  if (s != null && neqic(s, "www")) return s.replace("-", " ");
  return url;
}
static <A extends Concept> Pair<A, Boolean> uniqCI2_sync(Class<A> c, final Object... params) {
  return uniqCI2_sync(db_mainConcepts(), c, params);
}

static <A extends Concept> Pair<A, Boolean> uniqCI2_sync(Concepts cc, Class<A> c, final Object... params) {
  return withDBLock(cc, new F0<Pair<A, Boolean>>() { Pair<A, Boolean> get() { try {  return uniqCI2(cc, c, params);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret uniqCI2(cc, c, params);"; }});
}
static TreeSet<String> asCISet(Iterable<String> c) {
  return toCaseInsensitiveSet(c);
}

static TreeSet<String> asCISet(String... x) {
  return toCaseInsensitiveSet(x);
}
static List<String> nempties(Collection<String> c) {
  return filterNempty(c);
}
static MultiMap<String, String> subBot_paramsAsMultiMap() {
  return decodeHQueryToMultiMap(mapGet(subBot_getHttpFiles(), "query"));
}
static String hcomment(String text) {
  return "<!-- " + text + " -->";
}
static <A> List<A> takeFirst(List<A> l, int n) {
  return l(l) <= n ? l : newSubListOrSame(l, 0, n);
}

static <A> List<A> takeFirst(int n, List<A> l) {
  return takeFirst(l, n);
}

static String takeFirst(int n, String s) { return substring(s, 0, n); }
static String takeFirst(String s, int n) { return substring(s, 0, n); }

static <A> List<A> takeFirst(int n, Iterable<A> i) {
  List l = new ArrayList();
  Iterator<A> it = i.iterator();
  for (int _repeat_135 = 0; _repeat_135 < n; _repeat_135++)  { if (it.hasNext()) l.add(it.next()); else break; }
  return l;
}

static String hSilentComputatorWithFlag(String flag) {
  return hSilentComputator(hSilentComputator_defaultURI(), flag);
}
static String p(Object contents, Object... params) {
  return tag("p", contents, params) + "\n";
}
static String hsnippetimg(String imageID, Object... params) {
  return himg(snippetImageLink(imageID), params);
}
static String small(Object contents, Object... params) {
  return tag("small", contents, params);
}
static String b(Object contents, Object... params) {
  return tag("b", contents, params);
}
static String targetBlank(String link, Object contents, Object... params) {
  return hrefBlank(link, contents, params);
}
static String progLink(String id) {
  return "http://tinybrain.de/" + parseSnippetID(id);
}

static String progLink() {
  return progLink(programID());
}
static String nLines(int n) { return n2(n, "line"); }
static String nLines(Collection l) { return nLines(l(l)); }
static <A> ArrayList<A> cloneList(Iterable<A> l) {
  return l instanceof Collection ? cloneList((Collection) l) : asList(l);
}

static <A> ArrayList<A> cloneList(Collection<A> l) {
  if (l == null) return new ArrayList();
  synchronized(collectionMutex(l)) {
    return new ArrayList<A>(l);
  }
}
static int parseInt(String s) {
  return empty(s) ? 0 : Integer.parseInt(s);
}

static int parseInt(char c) {
  return Integer.parseInt(str(c));
}
// step = e.g. 100
// value = 0 to count
static String pageNav2(String baseLink, int count, int value, int step, String nVar, Object... __) {
  List<String> l = new ArrayList();
  baseLink += contains(baseLink, "?") ? "&" : "?"
    + urlencode(nVar) + "=";
  if (value > 0) l.add(ahref(baseLink + max(0, value-step),
    stringPar("leftArrow",__, htmlencode(unicode_leftPointingTriangle()))));
  for (int i = 0; i < count; i += step) {
    int n = i/step+1;
    if (pageNav2_showPage(value, i, step, count))
      if (value == i)
        l.add(b(n));
      else
        l.add(ahref(baseLink + i, n));
  }
  if (value+step < count) l.add(ahref(baseLink + (value+step),
    stringPar("rightArrow",__, htmlencode(unicode_rightPointingTriangle()))));
  return p("Pages: " + lines(l));
}

static boolean pageNav2_showPage(int actual, int i, int step, int count) {
  int diff = abs(actual-i)/step;
  return i == 0 || i >= (count-1)/step*step || diff <= 10 || ((i/step) % 10) == 9;
}
static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(short[] a) { return a == null ? 0 : a.length; }
static int l(long[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(double[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }
static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); }
static long l(File f) { return f == null ? 0 : f.length(); }

static int l(Object o) {
  return o == null ? 0
    : o instanceof String ? l((String) o)
    : o instanceof Map ? l((Map) o)
    : o instanceof Collection ? l((Collection) o)
    : o instanceof Object[] ? l((Object[]) o)
    : o instanceof boolean[] ? l((boolean[]) o)
    : o instanceof byte[] ? l((byte[]) o)
    : o instanceof char[] ? l((char[]) o)
    : o instanceof short[] ? l((short[]) o)
    : o instanceof int[] ? l((int[]) o)
    : o instanceof float[] ? l((float[]) o)
    : o instanceof double[] ? l((double[]) o)
    : o instanceof long[] ? l((long[]) o)
    : (Integer) call(o, "size");
}


  static int l(MultiSet ms) { return ms == null ? 0 : ms.size(); }



static String hform(Object contents, Object... params) {
  return htag("form", contents, params);
}
// first element of params can be the value
static String htextinput(String name, Object... params) {
  Object value = "";
  if (odd(l(params))) {
    value = params[0];
    params = dropFirst(params);
  }
  params = html_massageAutofocusParam(params);
  return tag("input", "", 
    concatArrays(new Object[] {"type", "text", "name", name, "value", value}, params));
}

static String htextinput(String name) {
  return htextinput(name, "");
}
static String hsubmit(String text, Object... params) {
  return tag("input", "", concatArrays(new Object[] {"type", "submit", "value", text}, params));
}

static String hsubmit() {
  return hsubmit("Submit");
}
static String h1(String s, Object... params) {
  return tag("h1", s, params);
}
static String nPages(int n) { return n2(n, "page"); }
static String nPages(Collection l) { return nPages(l(l)); }
static <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
  return concepts.countConcepts(c, params);
}

static <A extends Concept> int countConcepts(Class<A> c, Object... params) {
  return db_mainConcepts().countConcepts(c, params);
}

static int countConcepts() {
  return db_mainConcepts().countConcepts();
}

static int countConcepts(String className) {
  return db_mainConcepts().countConcepts(className);
}

static <A extends Concept> int countConcepts(Concepts concepts, String className) {
  return concepts.countConcepts(className);
}

static int countConcepts(Concepts concepts) {
  return concepts.countConcepts();
}
static String nConnections(int n) { return n2(n, "connection"); }
static String nConnections(Collection l) { return nConnections(l(l)); }
static String p_nemptyLines(Iterable l) {
  return p(nlToBr(nemptyLines(l)));
}
static List map(Iterable l, Object f) { return map(f, l); }

static List map(Object f, Iterable l) {
  List x = emptyList(l);
  if (l != null) for (Object o : l)
    x.add(callF(f, o));
  return x;
}


  static <A, B> List<B> map(Iterable<A> l, F1<A, B> f) { return map(f, l); }

  static <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null) for (A o : l)
      x.add(callF(f, o));
    return x;
  }


static <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) { return map(l, f); }
static <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : l)
    x.add(f.get(o));
  return x;
}
  
static <A, B> List<B> map(IF1<A, B> f, A[] l) { return map(l, f); }
static <A, B> List<B> map(A[] l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : l)
    x.add(f.get(o));
  return x;
}
  
static List map(Object f, Object[] l) { return map(f, asList(l)); }
static List map(Object[] l, Object f) { return map(f, l); }

static List map(Object f, Map map) {
  return map(map, f);
}

// map: func(key, value) -> list element
static List map(Map map, Object f) {
  List x = new ArrayList();
  if (map != null) for (Object _e : map.entrySet()) {
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}
static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = Math.max(0, startIndex);
  endIndex = Math.min(n, endIndex);
  if (startIndex >= endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  return l.subList(startIndex, endIndex);
}


static String hhead_title(String title) {
  return hhead(htitle(title));
}
static String hbody(Object contents, Object... params) {
  return tag("body", contents, params);
}
static String hfullcenterAndTopLeft(Object contents, Object topLeft) {
  return tag("table",
    tr(td(topLeft, "align" , "left", "height" , "1")) +
    tr(td(contents, "align" , "center")),
    "width" , "100%", "height" , "100%");
}
static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }
static Object serveJSON(Object data) {
  return serveJSON_shallowLineBreaks(data);
}
static <A> List<A> llNotNulls(A... a) {
  ArrayList l = new ArrayList(a.length);
  if (a != null) for (A x : a) if (x != null) l.add(x);
  return l;
}
static <A> A firstThat(Iterable<A> l, Object pred) {
  if (l != null) for (A a : l)
    if (checkCondition(pred, a))
      return a;
  return null;
}

static <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
  return firstThat(l, (Object) pred);
}

static <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
  return firstThat(l, pred);
}
static boolean eq(Object a, Object b) {
  return a == null ? b == null : a == b || b != null && a.equals(b);
}


static boolean isSquareBracketedInt(String s) {
  return isSquareBracketed(s) && isInteger(deSquareBracket(s));
}
static <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
  if (c != null && b != null) for (A a : b) c.add(a);
}

static <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
  return c != null && b != null && c.addAll(b);
}

static <A, B extends A> boolean addAll(Collection<A> c, B... b) {
  return c != null && c.addAll(Arrays.asList(b));
}



static <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll(b);
  return a;
}
static String unSquareBracket(String s) {
  return deSquareBracket(s);
}
static <A> List<A> concatLists(Collection<A>... lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Collection<A> list : lists)
    if (list != null)
      l.addAll(list);
  return l;
}

static <A> List<A> concatLists(Collection<? extends Collection<A>> lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Collection<A> list : lists)
    if (list != null)
      l.addAll(list);
  return l;
}

static Object dm_call(Object moduleOrID, String method, Object... args) {
  Object mod = dm_getModule(moduleOrID);
  if (mod == null) return null;
   AutoCloseable __196 = dm_enter(mod); try {
  return call_withVarargs(mod, method, args);
} finally { _close(__196); }}
static String programID() {
  return getProgramID();
}

static String programID(Object o) {
  return getProgramID(o);
}
static String htmlEncode2(String s) {
  return htmlencode_noQuotes(s);
}
static String ahref_unstyled(String link, Object contents, Object... params) {
  return link == null ? str(contents) : ahref(link, contents,
    paramsPlus(params, "style" , "text-decoration: none; color: inherit"));
}
static boolean cic(Collection<String> l, String s) {
  return containsIgnoreCase(l, s);
}



static boolean cic(String[] l, String s) {
  return containsIgnoreCase(l, s);
}

static boolean cic(String s, char c) {
  return containsIgnoreCase(s, c);
}

static boolean cic(String a, String b) {
  return containsIgnoreCase(a, b);
}

static String hpostform(Object contents, Object... params) {
  return tag("form", contents, concatArrays(new Object[] {"method", "POST"}, params));
}
static String h3(String s, Object... params) {
  return tag("h3", s, params) + "\n";
}
static String hinputfield(String name, Object... params) {
  return htextinput(name, params);
}
static String hquery(Map params) {
  return htmlQuery(params);
}

static String hquery(Object... data) {
  return htmlQuery(data);
}
static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else if (c == '\0')
      out.append("\\0");
    else
      out.append(c);
  }
  out.append('"');
}
static String p_nemptyLines_showFirst(int maxLines, Collection l) {
  if (l(l) <= maxLines) return p_nemptyLines(l);
  return p_nemptyLines(listPlus(takeFirst(maxLines, l), "..."));
}
static String unicode_spacedRightPointingTriangle() {
  return spaced(unicode_rightPointingTriangle());
}
static String hdiv(Object contents, Object... params) {
  return div(contents, params);
}
static java.util.Timer doLater(long delay, final Object r) {
  ping();
  final java.util.Timer timer = new java.util.Timer();
  timer.schedule(timerTask(r, timer), delay);
  return timer;
}

static java.util.Timer doLater(double delaySeconds, final Object r) {
  return doLater(toMS(delaySeconds), r);
}
static void vmBus_send(String msg, Object... args) {
  Object arg = vmBus_wrapArgs(args);
  pcallFAll(vm_busListeners_live(), msg, arg);
  pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
}

static void vmBus_send(String msg) {
  vmBus_send(msg, (Object) null);
}
static String tag(String tag) {
  return htag(tag);
}

static String tag(String tag, Object contents, Object... params) {
  return htag(tag, str(contents), params);
}

static String tag(String tag, StringBuilder contents, Object... params) {
  return htag(tag, contents, params);
}

static String tag(String tag, StringBuffer contents, Object... params) {
  return htag(tag, contents, params);
}
static String tr(Object contents) {
  return tag("tr", contents);
}
static String td(Object contents, Object... params) {
  return tag("td", contents, params);
}
static String iframe(String url, Object... params) {
  return hfulltag("iframe", "", arrayPlus(params, "src" , url));
}

static Object[] wrapMapAsParams(Map map) {
  return empty(map) ? null : new Object[] { map };
}
static <A> A assertNempty(A a) {
  return assertNempty("empty", a);
}

static <A> A assertNempty(String msg, A a) {
  if (empty(a)) throw fail(msg + ": " + a);
  return a;
}
static Random random_random = new Random();

static int random(int n) {
  return n <= 0 ? 0 : random_random.nextInt(n);
}

static double random(double max) {
  return random()*max;
}

static double random() {
  return random_random.nextInt(100001)/100000.0;
}

static double random(double min, double max) {
  return min+random()*(max-min);
}

// min <= value < max
static int random(int min, int max) {
  return min+random(max-min);
}

static <A> A random(List<A> l) {
  return oneOf(l);
}

static <A> A random(Collection<A> c) {
  if (c instanceof List) return random((List<A>) c);
  int i = random(l(c));
  return collectionGet(c, i);
}
static <A> List<A> filter(Iterable<A> c, Object pred) {
  if (pred instanceof F1) return filter(c, (F1<A, Boolean>) pred);

  
  List x = new ArrayList();
  if (c != null) for (Object o : c)
    if (isTrue(callF(pred, o)))
      x.add(o);
  return x;
}

static List filter(Object pred, Iterable c) {
  return filter(c, pred);
}

static <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o).booleanValue())
      x.add(o);
  return x;
}

static <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
  return filter(c, pred);
}

//ifclass IF1
static <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o).booleanValue())
      x.add(o);
  return x;
}

static <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
  return filter(c, pred);
}
//endif
static Matcher regexpIC(Pattern pat, String s) {
  return pat.matcher(unnull(s));
}

static Matcher regexpIC(String pat, String s) {
  return compileRegexpIC(pat).matcher(unnull(s));
}

static Pattern regexpIC(String pat) {
  return compileRegexpIC(pat);
}
static boolean regexpFindIC(Pattern pat, String s) {
  return regexpICFind(pat, s);
}

static boolean regexpFindIC(String pat, String s) {
  return regexpICFind(pat, s);
}
static boolean eqicOneOf(String s, String... l) {
  for (String x : l) if (eqic(s, x)) return true; return false;
}
public static String rtrim(String s) {
  if (s == null) return null;
  int i = s.length();
  while (i > 0 && " \t\r\n".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}
static String getSignerKey(String signed) {
  String s = fullTrimLastLine(signed);
  Matches m = new Matches();
  if (swic_trim(s, "signer:", m)) return m.rest();
  return null;
}

static Object subBot_serve500() {
  return call(getMainBot(), "serve500");
}

static Object subBot_serve500(String msg) {
  return call(getMainBot(), "serve500", msg);
}
static boolean isSignedWithKey_verbose = false;

static boolean isSignedWithKey(String signed, String key) {
  try {
    List<String> lines = toLines(signed);
    if (swic(last(lines), "signer:")) popLast(lines);
    String sigLine = last(lines);
    String text = fromLines(dropLast(lines));
    String sig = dropPrefixMandatory("sig: ", sigLine);
    return PKI.verifySignature(PKI.publicKeyFromString(key), PKI.signatureFromString(sig), toUtf8(text));
  } catch (RuntimeException e) {
    if (isSignedWithKey_verbose)
      printStackTrace(e);
    return false;
  }
}

// if text trails with \n, drops the lines before that
static String dropLastTwoLines(String s) {
  return dropLastLine(dropLastLine(s));
}
static List<String> tlft(String s) { return toLinesFullTrim(s); }
static List<String> tlft(File f) { return toLinesFullTrim(f); }

static Map jsonDecodeMap(String s) {
  Object o = jsonDecode(s);
  if (o instanceof List && empty((List) o))
    return new HashMap();
  if (o instanceof Map)
    return (Map) o;
  else
    throw fail("Not a JSON map: " + s);
}
static volatile Concepts mainConcepts; // Where we create new concepts

static Concepts db_mainConcepts() {
  if (mainConcepts == null) {
    mainConcepts = new Concepts(getDBProgramID());
    mainConcepts.classFinder = _defaultClassFinder();
  }
  return mainConcepts;
}
static <A extends Concept> A conceptWhere(Class<A> c, Object... params) {
  return findConceptWhere(c, params);
}

static <A extends Concept> A conceptWhere(Concepts cc, Class<A> c, Object... params) {
  return findConceptWhere(cc, c, params);
}
static <A> Set<A> setMinus(Set<A> set, Object... stuff) {
  Set s2 = cloneSet(set);
  for (Object o : stuff)
    s2.remove(o);
  return s2;
}
static TreeSet<String> collectAsCISet(Iterable c, String field) {
  return collectInCISet(c, field);
}



static TreeSet<String> collectAsCISet(String field, Iterable c) {
  return collectInCISet(field, c);
}
static <A, B> Pair<A, B> pair(A a, B b) {
  return new Pair(a, b);
}

static <A> Pair<A, A> pair(A a) {
  return new Pair(a, a);
}
static <A> List<Pair<A, Integer>> multiSetTopPairs(MultiSet<A> ms) {
  List < Pair < A , Integer > > l = new ArrayList();
  for (A a : ms.highestFirst())
    l.add(pair(a, ms.get(a)));
  return l;
}
static MultiSet<String> ciMultiSet() {
  MultiSet ms = new MultiSet();
  ms.map = ciMap();
  return ms;
}

static MultiSet<String> ciMultiSet(Iterable<String> l) {
  return asCIMultiSet(l);
}
static Pair<String, String> pairFromUglyString(String s) {
  if (empty(s)) return null;
  int i = indexOf(s, '|');
  int lA = parseInt(takeFirst(s, i));
  return pair(substring(s, i+1, i+1+lA), substring(s, i+1+lA+1));
}
static LinkedHashMap litorderedmap(Object... x) {
  LinkedHashMap map = new LinkedHashMap();
  litmap_impl(map, x);
  return map;
}
static <A extends Concept> Collection<String> distinctCIFieldValuesOfConcepts(Class<A> c, String field) {
  return distinctCIFieldValuesOfConcepts(db_mainConcepts(), c, field);
}

static <A extends Concept> Collection<String> distinctCIFieldValuesOfConcepts(Concepts concepts, Class<A> c, String field) {
  // indexed
  IFieldIndex<A, String> index = concepts.getCIFieldIndex(c, field);
  if (index != null)
    return index.allValues();

  // table scan
  Set<String> set = ciSet();
  for (A x : concepts.list(c)) set.add((String) getOpt(x, field));
  return set;
}
static <A, B> List<B> mapMultiSetByPopularity(MultiSet<A> ms, F2<A, Integer, B> f) {
  List<B> l = new ArrayList();
  if (ms != null) for (A key : ms.highestFirst())
    l.add(callF(f, key, ms.get(key)));
  return l;
}

static <A, B> List<B> mapMultiSetByPopularity(MultiSet<A> ms, IF2<A, Integer, B> f) {
  List<B> l = new ArrayList();
  if (ms != null) for (A key : ms.highestFirst())
    l.add(callF(f, key, ms.get(key)));
  return l;
}
static <A extends Concept> MultiSet<String> distinctCIFieldValuesOfConcepts_multiSet(Class<A> c, String field) {
  return distinctCIFieldValuesOfConcepts_multiSet(db_mainConcepts(), c, field);
}

static <A extends Concept> MultiSet<String> distinctCIFieldValuesOfConcepts_multiSet(Concepts concepts, Class<A> c, String field) {
  // indexed
  IFieldIndex<A, String> index = concepts.getCIFieldIndex(c, field);
  if (index != null)
    return index.allValues_multiSet();

  // table scan
  MultiSet<String> set = ciMultiSet();
  for (A x : concepts.list(c)) set.add((String) getOpt(x, field));
  return set;
}
static File conceptsFile(String progID) {
  return getProgramFile(progID, conceptsFileName());
}

static File conceptsFile() {
  return conceptsFile(dbProgramID());
}
static long returnTimeFor(int n, Object f) {
  long time = sysNow();
  for (int i = 0; i < n; i++)
    callF(f);
  return ratio(sysNow()-time, n);
}

static long returnTimeFor(Runnable f) {
  return returnTimeFor(1, f);
}
static String exceptionToStringShort(Throwable e) {
  lastException(e);
  e = getInnerException(e);
  String msg = hideCredentials(unnull(e.getMessage()));
  if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
    return baseClassName(e) + prependIfNempty(": ", msg);
  else
    return msg;
}
static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}


 static String f2s(java.nio.file.Path p) {
  return p == null ? null : f2s(p.toFile());
}

static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
  if (map == null) return new HashMap();
  // assume mutex is equal to collection
  synchronized(map) {
    return map instanceof TreeMap ? new TreeMap((TreeMap) map) // copies comparator
      : map instanceof LinkedHashMap ? new LinkedHashMap(map)
      : new HashMap(map);
  }
}
static TreeMap litcimap(Object... x) {
  return litCIMap(x);
}
static String renderHowLongAgo(long timestamp) {
  if (timestamp == 0) return "never";
  int seconds = howManySecondsAgo(timestamp);
  if (seconds <= 0) return "just now";
  if (seconds < 60) return n2(seconds, "second") + " ago";
  int minutes = iround(seconds/60.0);
  if (minutes < 60) return n2(minutes, "minute") + " ago";
  int hours = iround(minutes/60.0);
  if (hours < 24) return n2(hours, "hour") + " ago";
  int days = iround(hours/24.0);
  return n2(days, "day") + " ago";
}
static long longSum(Iterable<Long> l) {
  long sum = 0;
  for (Long i : unnull(l))
    if (i != null) sum += i;
  return sum;
}
static <A, B> Set<A> keys(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

static Set keys(Object map) {
  return keys((Map) map);
}


  static <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }



  static <A, B> Set<A> keys(MultiMap<A, B> mm) {
    return mm.keySet();
  }



static List<String> sortedIC(Collection<String> l) {
  return sortedIgnoreCase(l);
}

static <A, B> List<A> keysList(Map<A, B> map) {
  return cloneListSynchronizingOn(keys(map), map);
}


  static <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

static <A> List<A> ll(A... a) {
  ArrayList l = new ArrayList(a.length);
  if (a != null) for (A x : a) l.add(x);
  return l;
}
static String yesNo(boolean b) {
  return yesno(b);
}

static String yesNo(Boolean b) {
  return yesno(b);
}
static Object first(Object list) {
  return first((Iterable) list);
}

static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}


static <A> A first(IterableIterator<A> i) {
  return first((Iterator<A>) i);
}


static <A> A first(Iterator<A> i) {
  return i == null || !i.hasNext() ? null : i.next();
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }


static <A, B> A first(Pair<A, B> p) {
  return p == null ? null : p.a;
}



static <A, B, C> A first(T3<A, B, C> t) {
  return t == null ? null : t.a;
}

static Object subBot_serve404() {
  return call(getMainBot(), "serve404");
}

static Object subBot_serve404(String msg) {
  return call(getMainBot(), "serve404", msg);
}
static <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
  A a = tl.get();
  if (a != null) {
    tl.set(null);
    return a;
  }
  return defaultValue;
}

static <A> A optPar(ThreadLocal<A> tl) {
  return optPar(tl, null);
}

static Object optPar(Object[] params, String name) {
  return optParam(params, name);
}

static Object optPar(String name, Object[] params) {
  return optParam(params, name);
}

static Object optPar(String name, Map params) {
  return optParam(name, params);
}

static <A> A optPar(Object[] params, String name, A defaultValue) {
  return optParam(params, name, defaultValue);
}

static <A> A optPar(String name, Object[] params, A defaultValue) {
  return optParam(params, name, defaultValue);
}
static int max(int a, int b) { return Math.max(a, b); }
static int max(int a, int b, int c) { return max(max(a, b), c); }
static long max(int a, long b) { return Math.max((long) a, b); }
static long max(long a, long b) { return Math.max(a, b); }
static double max(int a, double b) { return Math.max((double) a, b); }
static float max(float a, float b) { return Math.max(a, b); }
static double max(double a, double b) { return Math.max(a, b); }

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}

static int max(int[] c) {
  int x = Integer.MIN_VALUE;
  for (int d : c) if (d > x) x = d;
  return x;
}
static int leven_limitedIC(String left, String right, int threshold) {
  if (--threshold < 0) return 0;

  int n = left.length(); // length of left
  int m = right.length(); // length of right

  // if one string is empty, the edit distance is necessarily the length
  // of the other
  if (n == 0)
    return m <= threshold ? m : threshold+1;
  if (m == 0)
    return n <= threshold ? n : threshold+1;
    
  // if length difference is > threshold, just bail out
  if (abs(m-n) > threshold) return threshold+1;

  if (n > m) {
      // swap the two strings to consume less memory
      final String tmp = left;
      left = right;
      right = tmp;
      n = m;
      m = right.length();
  }

  int[] p = new int[n + 1]; // 'previous' cost array, horizontally
  int[] d = new int[n + 1]; // cost array, horizontally
  int[] tempD; // placeholder to assist in swapping p and d

  // fill in starting table values
  final int boundary = Math.min(n, threshold) + 1;
  for (int i = 0; i < boundary; i++) {
      p[i] = i;
  }
  // these fills ensure that the value above the rightmost entry of our
  // stripe will be ignored in following loop iterations
  Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
  Arrays.fill(d, Integer.MAX_VALUE);

  // iterates through t - USE LONG to fix JVM SAFE POINTS.
  for (long _j = 1; _j <= m; _j++) {
      int j = (int) _j;
      final char rightJ = right.charAt(j - 1); // jth character of right
      d[0] = j;

      // compute stripe indices, constrain to array size
      final int min = Math.max(1, j - threshold);
      final int max = j > Integer.MAX_VALUE - threshold ? n : Math.min(
              n, j + threshold);

      // the stripe may lead off of the table if s and t are of different
      // sizes
      if (min > max) {
          return threshold+1;
      }

      // ignore entry left of leftmost
      if (min > 1) {
          d[min - 1] = Integer.MAX_VALUE;
      }

      // iterates through [min, max] in s
      for (int i = min; i <= max; i++) {
          if (equalsIgnoreCase(left.charAt(i - 1), rightJ)) {
              // diagonally left and up
              d[i] = p[i - 1];
          } else {
              // 1 + minimum of cell to the left, to the top, diagonally
              // left and up
              d[i] = 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
          }
      }

      // copy current distance counts to 'previous row' distance counts
      tempD = p;
      p = d;
      d = tempD;
  }

  // if p[n] is greater than the threshold, there's no guarantee on it
  // being the correct
  // distance
  if (p[n] <= threshold) {
      return p[n];
  }
  return threshold+1;
}
static <A, B> List<A> keysSortedByValue(Map<A, B> map) {
  return keysSortedByValues(map);
}
static String nResults(int n) { return n2(n, "result"); }
static String nResults(Collection l) { return nResults(l(l)); }
static String htmldecode_dropAllTags(String html) {
  return htmldecode(dropAllTags(html));
}
static String hfullcenter(Object contents) {
  return tag("table", tr(td(contents, "align" , "center")), "width" , "100%", "height" , "100%");
}
static boolean preferCached = false;
static boolean loadSnippet_debug = false;
static ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();
static int loadSnippet_timeout = 30000;



static String loadSnippet(String snippetID) { try {
  if (snippetID == null) return null;
  return loadSnippet(parseSnippetID(snippetID), preferCached);
} catch (Exception __e) { throw rethrow(__e); } }

static String loadSnippet(String snippetID, boolean preferCached) throws IOException {
  return loadSnippet(parseSnippetID(snippetID), preferCached);
}

public static String loadSnippet(long snippetID) { try {
  return loadSnippet(snippetID, preferCached);
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadSnippet(long snippetID, boolean preferCached) throws IOException {
  String text;
  
  if (isLocalSnippetID(snippetID))
    return loadLocalSnippet(snippetID);
    
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadSnippet(fsI(snippetID));
  
  
  // boss bot disabled for now for shorter transpilations
  
  /*text = getSnippetFromBossBot(snippetID);
  if (text != null) return text;*/
  
  initSnippetCache();
  text = DiskSnippetCache_get(snippetID);
  
  if (preferCached && text != null)
    return text;
  
  try {
    if (loadSnippet_debug && text != null) System.err.println("md5: " + md5(text));
    String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
    if (nempty(text)) url += "&md5=" + md5(text);
    url += standardCredentials();
    
    String text2 = loadSnippet_loadFromServer(url);
    
    boolean same = eq(text2, "==*#*==");
    if (loadSnippet_debug) print("loadSnippet: same=" + same);
    if (!same) text = text2;
  } catch (RuntimeException e) {
    e.printStackTrace();
    throw new IOException("Snippet #" + snippetID + " not found or not public");
  }

  try {
    initSnippetCache();
    DiskSnippetCache_put(snippetID, text);
  } catch (IOException e) {
    System.err.println("Minor warning: Couldn't save snippet to cache ("  + DiskSnippetCache_getDir() + ")");
  }

  return text;
}

static File DiskSnippetCache_dir;

public static void initDiskSnippetCache(File dir) {
  DiskSnippetCache_dir = dir;
  dir.mkdirs();
}

public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
  return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
}

private static File DiskSnippetCache_getFile(long snippetID) {
  return new File(DiskSnippetCache_dir, "" + snippetID);
}

public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
  saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
}

public static File DiskSnippetCache_getDir() {
  return DiskSnippetCache_dir;
}

public static void initSnippetCache() {
  if (DiskSnippetCache_dir == null)
    initDiskSnippetCache(getGlobalCache());
}

static String loadSnippet_loadFromServer(String url) {
  Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
  try {
    return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
  } finally {
    loadPage_forcedTimeout_byThread.set(oldTimeout);
  }
}

static String form(Object contents, Object... params) {
  return hform(contents, params);
}
static String htextarea(String text, Object... params) {
  params = html_massageAutofocusParam(params);
  return hopeningTag("textarea", params) + htmlencode2(text) + "</textarea>";
}
static String hrefresh(String target) {
  return hrefresh(0, target);
}

static String hrefresh(double seconds) {
  return hrefresh(seconds, "");
}

static String hrefresh(double seconds, String target) {
  return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
}
static String hhidden(String name, Object value, Object... params) {
  return tag("input", "", concatArrays(new Object[] {"type", "hidden", "name", name, "value", value}, params));
}
static String htag(String tag) {
  return htag(tag, "");
}

static String htag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  if (empty(s) && neqic(tag, "script"))
    return dropLast(openingTag) + "/>";
  return openingTag + s + "</" + tag + ">";
}
static String googleSignIn_signInButton(String verifyURL, String onSuccess, String onSignOut) {
  return "<div class=\"g-signin2\" data-onsuccess=\"onSignIn\"></div>\r\n    <script>\r\n    function onSignIn(googleUser) {\r\n      console.log(\"Signing in\");\r\n      var profile = googleUser.getBasicProfile();\r\n      var email = profile.getEmail();\r\n      if (email != \"\") {\r\n        var token = googleUser.getAuthResponse().id_token;\r\n        console.log(\"Email: \" + email + \"\\nToken: \" + token);\r\n        var myKeyVals = { token: token };\r\n        $.ajax({\r\n          type: \"POST\",\r\n          url: \"$VERIFYURL\",\r\n          data: myKeyVals,\r\n          dataType: \"text\",\r\n          success: function(data) {\r\n            $ONSUCCESS\r\n          }\r\n        });\r\n      }\r\n    }\r\n\r\n    function signOut() {\r\n      var auth2 = gapi.auth2.getAuthInstance();\r\n      auth2.signOut().then(function () { $ONSIGNOUT});\r\n    }\r\n    </script>\r\n  ".replace("$VERIFYURL", verifyURL)
    .replace("$ONSUCCESS", onSuccess)
    .replace("$ONSIGNOUT", onSignOut);
}
static String nobr(Object contents) {
  return tag("nobr",contents);
}
static String hselect(Map map, Object... params) {
  StringBuilder buf = new StringBuilder();
  String selected = null;
  if (odd(l(params))) {
    selected = str(first(params));
    params = dropFirst(params);
  }
  int i = indexOf(params, "allowEmpty");
  if (even(i)) {
    buf.append("<option></option>\n");
    params[i] = params[i+1] = null;
  }
  if (nempty(map)) for (Object key : keys(map)) {
    Object value = map.get(key);
    String k = str(key);
    buf.append(tag("option", htmlencode(str(or(value, ""))),
      "value" , k,
      "selected" , eq(selected, k) ? "selected" : null)).append("\n");
  }
  return tag("select", buf, params) + "\n";
}
static long elapsedMS_sysNow(long time) {
  return elapsedMS(time);
}
static String botCompanyGoogleSignInID() {
  return "709303807085-rvu63dqa5hjcii6h0j70lhn7me27cegc.apps.googleusercontent.com";
}
static String agiBlueGoogleSignInID() {
  return "709303807085-l19k12l095cl4c0llu4p6fl1r0phnnki.apps.googleusercontent.com";
}
static String hhtml(Object contents) {
  return containerTag("html", contents);
}
static String hAddToHead_fast(String html, String tag) {
  int idx = indexOfIC(html, "</head>");
  if (idx < 0) return tag + html;
  return takeFirst(html, idx) + tag + substring(html, idx);
}
// TODO: is display=swap always correct?
static String hIncludeGoogleFont(String fontFamily) {
  return htag("link","", "href" , "https://fonts.googleapis.com/css?family=" + urlencode(fontFamily) + "&display=swap", "rel" , "stylesheet");
}
static String loadJQuery() {
  return "<script src=\"https://code.jquery.com/jquery-1.10.2.js\"></script>";
}
static String hmobilefix() {
  return "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">";
}

static String hmobilefix(String html) {
  return hAddToHead(html, hmobilefix());
}

static String googleSignIn_header() {
  return googleSignIn_header("");
}

static String googleSignIn_header(String onLoad) {
  return googleSignIn_header(onLoad, botCompanyGoogleSignInID());
}

static String googleSignIn_header(String onLoad, String clientID) {
  return "<script src=\"https://apis.google.com/js/platform.js$PARAM\" async defer></script>\r\n    <meta name=\"google-signin-client_id\" content=\"$CLIENTID\">"
    .replace("$PARAM", nempty(onLoad) ? "?onload=" + urlencode(onLoad) : "")
    .replace("$CLIENTID", clientID);
}
static String hstylesheet(Object contents) {
  return hcss(contents);
}
static void logStructure(File logFile, Object o) {
  logQuoted(logFile, structure(o));
}

// quick version - log to file in program directory
static void logStructure(String fileName, Object o) {
  logStructure(getProgramFile(fileName), o);
}

static void logStructure(String progID, String fileName, Object o) {
  logStructure(getProgramFile(progID, fileName), o);
}
static File programFile(String name) {
  return prepareProgramFile(name);
}

static File programFile(String progID, String name) {
  return prepareProgramFile(progID, name);
}
static boolean boolPar(ThreadLocal<Boolean> tl) {
  return boolOptParam(tl);
}



// defaults to false
static boolean boolPar(Object[] __, String name) {
  return boolOptParam(__, name);
}

static boolean boolPar(String name, Object[] __) {
  return boolOptParam(__, name);
}

static boolean boolPar(String name, Map __) {
  return boolOptParam(name, __);
}

static boolean boolPar(String name, Object[] params, boolean defaultValue) {
  return optParam(params, name, defaultValue);
}

static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}
static <B> TreeMap<String, B> asCIMap(Map<String, B> map) {
  return asCaseInsensitiveMap(map);
}
static boolean valueIs1(String key, Map<String, String> map) {
  return eq("1", mapGet(map, key));
}
static Object withDBLock(Object r) {
  Lock __367 = db_mainConcepts().lock; lock(__367); try {
  return callF(r);
} finally { unlock(__367); } }

static <A> A withDBLock(F0<A> r) {
  return (A) withDBLock((Object) r);
}

static Object withDBLock(Concepts concepts, Object r) {
  Lock __368 = concepts.lock; lock(__368); try {
  return callF(r);
} finally { unlock(__368); } }

static <A> A withDBLock(Concepts concepts, F0<A> r) {
  return (A) withDBLock(concepts, (Object) r);
}
static String subBot_clientIP() {
  return getClientIP_subBot();
}
static boolean eq_icIf(boolean ignoreCase, String a, String b) {
  return ignoreCase ? eqic(a, b) : eq(a, b);
}
static Concept cnew(String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  Concept c = cc != null ? nuObject(cc) : new Concept(name);
  csetAll(c, values);
  return c;
}

static Concept cnew(Concepts concepts, String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  concepts_unlisted.set(true);
  Concept c;
  try {
    c = cc != null ? nuObject(cc) : new Concept(name);
  } finally {
    concepts_unlisted.set(null);
  }
  concepts.register(c);
  csetAll(c, values);
  return c;
}

static <A extends Concept> A cnew(Class<A> cc, Object... values) {
  A c = nuObject(cc);
  csetAll(c, values);
  return c;
}

static <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
  concepts_unlisted.set(true);
  A c;
  try {
    c = nuObject(cc);
  } finally {
    concepts_unlisted.set(null);
  }
  concepts.register(c);
  csetAll(c, values);
  return c;
}

static <A> List<A> sortByFieldInPlace(List<A> l, String field) {
  sort(l, fieldComparator(field));
  return l;
}

static <A> List<A> sortByFieldInPlace(String field, List<A> l) {
  return sortByFieldInPlace(l, field);
}
static void numberEntriesInConceptField(String field, List<? extends Concept> entries) {
  for (int i = 0; i < l(entries); i++)
    if (getInt(entries.get(i), field) == 0)
      cset(entries.get(i), field, i+1);
}
static Map mapToOrderedMap(Object f, Iterable l) {
  LinkedHashMap map = new LinkedHashMap();
  for (Object o : unnull(l)) {
    Pair p =  (Pair) (callF(f, o));
    map.put(p.a, p.b);
  }
  return map;
}

static <A, B, C> Map<B, C> mapToOrderedMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
  LinkedHashMap<B,C> map = new LinkedHashMap();
  for (A o : unnull(l)) {
    Pair<B, C> p = callF(f, o);
    map.put(p.a, p.b);
  }
  return map;
}
static <A> List<A> sortedByField(Collection<A> c, final String field) {
  List<A> l = new ArrayList(c);
  sort(l, new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(getOpt(a, field), getOpt(b, field));
    }
  });
  return l;
}

static <A> List<A> sortedByField(String field, Collection<A> c) {
  return sortedByField(c, field);
}
// f: A -> Comparable
static <A> List<A> sortedByCalculatedField(Iterable<A> c, Object f) {
  return sortByCalculatedField(c, f);
}

static <A> List<A> sortedByCalculatedField(Object f, Iterable<A> c) {
  return sortedByCalculatedField(c, f);
}

static <A, B> List<A> sortedByCalculatedField(Iterable<A> c, IF1<A, B> f) {
  return sortedByCalculatedField(c, (Object) f);
}
static boolean amProgram(String snippetID) {
  return sameSnippetID(programID(), snippetID);
}
static long psI(String snippetID) {
  return parseSnippetID(snippetID);
}
static boolean cleanUp_interruptThreads = false; // experimental

static void cleanUp(Object c) {
  if (c == null) return;
  if (c instanceof Collection) { cleanUp((Collection) c); return; }
  if (c instanceof Map) {
    for (Object o : keys((Map) c)) cleanUp(o);
    for (Object o : values((Map) c)) cleanUp(o);
    ((Map) c).clear();
    return;
  }
  //if (!(c instanceof Class)) ret;
  
  try {
    // revoke license
    
    preCleanUp(c);
    
    // unpause
    
    setOpt(c, "ping_pauseAll", false);
    
    // call custom cleanMeUp() and cleanMeUp_*() functions
    
    innerCleanUp(c);
        
    // Java spec says finalize should only be called by GC,
    // but we care to differ.
    // Edit: Not anymore (illegal access warnings)
    /*if (isTrue(vmMap_get('callFinalize)))
      pcallOpt(c, "finalize");*/

    // remove all virtual bots (hope this works)
    
    List androids = (List) getOpt(c, "record_list");
    for (Object android : unnull(androids))
      pcallOpt(android, "dispose"); // heck we'll dispose anything

    // sub-cleanup
    
    List<WeakReference> classes =  (List<WeakReference>) (getOpt(c, "hotwire_classes"));
    if (classes != null)
      for (WeakReference cc : classes) { try {
        cleanUp(cc.get());
      } catch (Throwable __e) { _handleException(__e); }}
      
    // interrupt all threads (experimental, they might be doing cleanup?)
    
    if (cleanUp_interruptThreads) {
      List<Thread> threads = registeredThreads(c);
      if (nempty(threads)) {
        print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
        interruptThreads(threads);
      }
    }
  } catch (Throwable __e) { _handleException(__e); }
  
  setOpt(c, "cleaningUp_flag" , false);
  if (c instanceof Class && ((Class) c).getName().equals("main"))
    retireClassLoader(((Class) c).getClassLoader());
 }

static void cleanUp(Collection l) {
  if (l == null) return;
  for (Object c : l)
    cleanUp(c);
  l.clear();
}
static void lock(Lock lock) { try {
  ping();
  if (lock == null) return;
  try {
    lock.lockInterruptibly();
  } catch (InterruptedException e) {
    print("Locking interrupted! I probably deadlocked, oops.");
    printStackTrace(e);
    rethrow(e);
  }
  ping();
} catch (Exception __e) { throw rethrow(__e); } }

static void lock(Lock lock, String msg) {
  print("Locking: " + msg);
  lock(lock);
}

static void lock(Lock lock, String msg, long timeout) {
  print("Locking: " + msg);
  lockOrFail(lock, timeout);
}

static ReentrantLock lock() {
  return fairLock();
}
static void unlock(Lock lock, String msg) {
  if (lock == null) return;
  print("Unlocking: " + msg);
  lock.unlock();
}

static void unlock(Lock lock) {
  if (lock == null) return;
  lock.unlock();
}
static <A> A lowestByField(Iterable<A> l, String field) {
  Lowest<A> lowest = new Lowest();
  for (A a : unnull(l))
    lowest.put(a, toDouble(getOpt(a, "field")));
  return lowest.get();
}

static <A> A lowestByField(String field, Iterable<A> l) {
  return lowestByField(l, field);
}
static List<ALQLLine> agiBlue_parseQueryScript(String script) {
  return map("agiBlue_parseQueryLine",tlftj_honoringBrackets(script));
}
static <A> A getOrKeep(Map<A, ? extends A> map, A a) {
  if (map == null) return a;
  A v = map.get(a);
  return v != null ? v : a;
}
static T3 tripleMap(Object f, T3 t) {
  return t == null ? null : triple(callF(f, t.a), callF(f, t.b), callF(f, t.c));
}

static <A> T3<A, A, A> tripleMap(T3<A, A, A> t, IF1<A, A> f) {
  return tripleMap(f, t);
}

static <A> T3<A, A, A> tripleMap(IF1<A, A> f, T3<A, A, A> t) {
  return t == null ? null : triple(callF(f, t.a), callF(f, t.b), callF(f, t.c));
}

static T3 tripleMap(T3 t, Object f) {
  return tripleMap(f, t);
}

static boolean isDollarVar(String s) {
  return startsWith(s, '$') && isJavaIdentifierAfter(s, 1);
}


  static RuntimeException todo() {
    throw new RuntimeException("TODO");
  }
  
  static RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }
static <A extends Concept> List<A> conceptsWhereCI(Class<A> c, Object... params) {
  return findConceptsWhereCI(c, params);
}



static List<Concept> conceptsWhereCI(String c, Object... params) {
  return findConceptsWhereCI(c, params);
}



static <A extends Concept> List<A> conceptsWhereCI(Concepts concepts, Class<A> c, Object... params) {
  return findConceptsWhereCI(concepts, c, params);
}



static List<Concept> conceptsWhereCI(Concepts concepts, String c, Object... params) {
  return findConceptsWhereCI(concepts, c, params);
}
// get purpose 1: access a list/array/map (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

// seems to conflict with other signatures
/*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o == null) return null;
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      return f.get(o);
    }
      
    
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(Object o, String field) {
  try {
    Field f = get_findField(o.getClass(), field);
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static Object get(String field, Object o) {
  return get(o, field);
}
static <A> void addIfNotNull(Collection<A> l, A a) {
  if (a != null && l != null) l.add(a);
}


static <A> void addIfNotNull(MultiSet<A> ms, A a) {
  if (a != null && ms != null) ms.add(a);
}

static Map<String, String> flexMatchDollarVarsIC_first(String pat, String input) {
  return grabValueAndCancel(new VF1<VF1<Map<String, String>>>() { public void get(VF1<Map<String, String>> onMatch) { try { 
    flexMatchDollarVarsIC_iterate(pat, input, onMatch);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "flexMatchDollarVarsIC_iterate(pat, input, onMatch);"; }});
}
static String curly(String s) {
  return optionalCurlyBrace(s);
}
static RuntimeException fail() { throw new RuntimeException("fail"); }
static RuntimeException fail(Throwable e) { throw asRuntimeException(e); }
static RuntimeException fail(Object msg) { throw new RuntimeException(String.valueOf(msg)); }
static RuntimeException fail(String msg) { throw new RuntimeException(msg == null ? "" : msg); }
static RuntimeException fail(String msg, Throwable innerException) { throw new RuntimeException(msg, innerException); }

static <A extends Concept> A uniqCI_sync(final Class<A> c, final Object... params) {
  return uniqCI_sync(db_mainConcepts(), c, params);
}

static <A extends Concept> A uniqCI_sync(Concepts concepts, Class<A> c, final Object... params) {
  return withDBLock(concepts, new F0<A>() { A get() { try {  return uniqCI(concepts, c, params);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret uniqCI(concepts, c, params);"; }});
}
static <A> A _get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

static Object _get(Object o, String field) {
  return get(o, field);
}

static Object _get(String field, Object o) {
  return get(o, field);
}
static <A> A _get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}
static String sfu(Object o) { return structureForUser(o); }
static <A> List<A> tripleToList(T3<A, A, A> t) {
  return t == null ? null : ll(t.a, t.b, t.c);
}
/** writes safely (to temp file, then rename) */
static File saveLinesAsTextFile(String fileName, Iterable<String> lines) { try {
  return saveTextFile(fileName, lines(lines));
} catch (Exception __e) { throw rethrow(__e); } }

static File saveLinesAsTextFile(File fileName, Iterable<String> lines) {
  return saveLinesAsTextFile(fileName.getPath(), lines);
}
static <A, B, C> T3<A, B, C> t3(A a, B b, C c) {
  return new T3(a, b, c);
}
static <A> List<A> sharedKeys(Map<A, ?> a, Map<A, ?> b) {
  List<A> l = new ArrayList();
  if (nempty(a) && nempty(b))
    for (A key : cloneKeys(a))
      if (b.containsKey(key))
        l.add(key);
  return l;
}
static <A, B> B getOrCreate(Map<A, B> map, A key, Class<? extends B> c) { try {
  B b = map.get(key);
  if (b == null)
    map.put(key, b = c.newInstance());
  return b;
} catch (Exception __e) { throw rethrow(__e); } }

// f : func -> B
static <A, B> B getOrCreate(Map<A, B> map, A key, Object f) { try {
  B b = map.get(key);
  if (b == null)
    map.put(key, b = (B) callF(f));
  return b;
} catch (Exception __e) { throw rethrow(__e); } }


static <A, B> B getOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
  return getOrCreate(map, key, c);
}
static <A extends Concept> List<A> conceptsWhere(Class<A> c, Object... params) {
  return findConceptsWhere(c, params);
}

static List<Concept> conceptsWhere(String c, Object... params) {
  return findConceptsWhere(c, params);
}
static <A, B> void removeAllKeysNotIn(Map<A, B> a, Map<A, ?> b) {
  if (a != null) removeAllBut(a, keys(b));
}
static Set<String> sliceDump_pageNamesIncludingKeys(File f) {
  Set<String> names = ciSet();
   CloseableIterableIterator<String> it = linesFromFile(f); try {
  while (it.hasNext()) { try {
    String s = trim(it.next());
    if (empty(s)) continue;
    if (startsWith(s, '"'))
      { names.add(unquote(s)); continue; }
    List l = optCast(List.class, safeUnstructure(s));
    if (l(l) != 3) { print("Can't parse: " + s); continue; }
    names.add((String) second(l));
  } catch (Throwable __e) { _handleException(__e); }}
  return names;
} finally { _close(it); }}


static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}

static GlobalID aGlobalIDObj() {
  return asGlobalID(randomID(16));
}
static String md5(String text) { try {
  if (text == null) return "-";
  return bytesToHex(md5_impl(toUtf8(text))); // maybe different than the way PHP does it...
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(byte[] data) {
  if (data == null) return "-";
  return bytesToHex(md5_impl(data));
}

static byte[] md5_impl(byte[] data) { try {
  return MessageDigest.getInstance("MD5").digest(data);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(File file) {
  return md5OfFile(file);
}
static String fileNameEncode_safeChars = " ()[]#,!";

static String fileNameEncode(String s) {
  StringBuilder buf = new StringBuilder();
  int n = l(s);
  for (int i = 0; i < n; i++) {
    char c = s.charAt(i);
    if (contains(fileNameEncode_safeChars, c))
      buf.append(c);
    else
      buf.append(urlencode(str(c)));
  }
  return str(buf);
}
static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}
static int globalIDLength() {
  return 16;
}
static <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
  return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
}
static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static <A> TreeMap<String, A> caseInsensitiveMap() {
  return new TreeMap(caseInsensitiveComparator());
}
static void _handleError(Error e) {
  call(javax(), "_handleError", e);
}
//sbool ping_actions_shareable = true;
static volatile boolean ping_pauseAll = false;
static int ping_sleep = 100; // poll pauseAll flag every 100

static volatile boolean ping_anyActions = false;
static Map<Thread, Object> ping_actions = newWeakHashMap();
static ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();


// always returns true
static boolean ping() {
  if (ping_pauseAll  || ping_anyActions ) ping_impl(true /* XXX */);
  //ifndef LeanMode ping_impl(); endifndef
  return true;
}

// returns true when it slept
static boolean ping_impl(boolean okInCleanUp) { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  
  if (ping_anyActions) { // don't allow sharing ping_actions
    if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
      failIfUnlicensed();
    Object action = null;
    synchronized(ping_actions) {
      if (!ping_actions.isEmpty()) {
        action = ping_actions.get(currentThread());
        if (action instanceof Runnable)
          ping_actions.remove(currentThread());
        if (ping_actions.isEmpty()) ping_anyActions = false;
      }
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }
  
  
  return false;
} catch (Exception __e) { throw rethrow(__e); } }
static IConceptIndex simpleConceptIndex(final Runnable r) {
  return new IConceptIndex() {
    public void update(Concept c) { pcallF(r); }
    public void remove(Concept c) { pcallF(r); }
  };
}
static <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
  if (l(params) == 1)
    params = new Object[] { singleFieldName(c), params[0] };
  else
    warnIfOddCount(params);
  return params;
}

static void warnIfOddCount(Object... list) {
  if (odd(l(list)))
    printStackTrace("Odd list size: " + list);
}
static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  if (getOpt_cache == null)
    map = getOpt_makeCache(c); // in class init
  else synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    
    // It's probably a subclass of Map. Use raw method
    setOpt_raw(o, field, value);
    return;
  }
  
  Field f = map.get(field);
  if (f != null)
    smartSet(f, o, value); // possible improvement: skip setAccessible
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        f.setAccessible(true);
        return f;
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static Object deref(Object o) {
  if (o instanceof Derefable) o = ((Derefable) o).get();
  return o;
}

static String intern(String s) {
  return fastIntern(s);
}
static <A, B> void mapPut2(Map<A, B> map, A key, B value) {
  if (map != null && key != null)
    if (value != null) map.put(key, value);
    else map.remove(key);
}
static String assertIdentifier(String s) {
  return assertIsIdentifier(s);
}

static String assertIdentifier(String msg, String s) {
  return assertIsIdentifier(msg, s);
}
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}
static Object derefRef(Object o) {
  if (o instanceof Concept.Ref) o = ((Concept.Ref) o).get();
  return o;
}

static boolean neq(Object a, Object b) {
  return !eq(a, b);
}
static <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
  return uniqueConcept(db_mainConcepts(), c, params);
}

static <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhere(cc, c, params);
  if (x == null) {
    x = unlisted(c);
    csetAll(x, params);
    cc.register(x);
  }
  return x;
}
static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
  return indexConceptFieldCI(db_mainConcepts(), c, field);
}

static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
  ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
  return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
}
static void indexConceptField(Class<? extends Concept> c, String field) {
  indexConceptField(db_mainConcepts(), c, field);
}

static void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
  if (!isConceptFieldIndexed(concepts, c, field))
    new ConceptFieldIndex(concepts, c, field);
}
static String getType(Object o) {
  return getClassName(o);
}
static long getFileSize(String path) {
  return path == null ? 0 : new File(path).length();
}

static long getFileSize(File f) {
  return f == null ? 0 : f.length();
}
static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}

static File javaxDataDir(String... subs) {
  return newFile(javaxDataDir(), subs);
}
static File programDir_mine; // set this to relocate program's data

static File programDir() {
  return programDir(getProgramID());
}

static File programDir(String snippetID) {
  boolean me = sameSnippetID(snippetID, programID());
  if (programDir_mine != null && me)
    return programDir_mine;
  File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
  if (me) {
    String c = caseID();
    if (nempty(c)) dir = newFile(dir, c);
  }
  return dir;
}

static File programDir(String snippetID, String subPath) {
  return new File(programDir(snippetID), subPath);
}
static boolean sameFile(File a, File b) { try {
  return a == null ? b == null : b != null && eq(a.getCanonicalPath(), b.getCanonicalPath());
} catch (Exception __e) { throw rethrow(__e); } }
static boolean directoryIsEmpty(File f) {
  return !fileExists(f) || isDirectory(f) && empty(listFiles(f));
}
static void copyAllFilesInDirectory_rec_noOverwrite(File src, File dest) { try {
  print("Listing " + f2s(src));
  for (File f : listFiles(src)) {
    print("Copying " + f2s(f));
    File destFile = newFile(dest, f.getName());
    if (fileExists(destFile))
      throw fail("Won't overwrite " + f2s(destFile) + " with contents of " + f2s(f));
    if (isSymLink(f))
      Files.createLink(fileToPath(destFile), fileToPath(f).toRealPath());
    else if (isFile(f))
      copyFile(f, destFile);
    else if (isDirectory(f)) {
      mkdirs(destFile);
      copyAllFilesInDirectory_rec_noOverwrite(f, newFile(dest, f.getName()));
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean deleteFiles(File... files) {
  return deleteFiles(asList(files));
}

static boolean deleteFiles(List<File> files) {
  boolean b = false;
  for (File f : unnull(files))
    if (deleteFile(f)) b = true;
  return b;
}
static List<File> conceptBackupFiles(String progID) {
  Pattern pat = Pattern.compile("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
  File dir = programDir(progID);
  List<File> l = new ArrayList();
  for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
    String s = f.getName();
    Matcher matcher = pat.matcher(s);
    { if (!(matcher.find())) continue; }
    String originalName = matcher.group(1);
    { if (!(eq(originalName, "concepts.structure.gz"))) continue; }
    l.add(f);
  }
  return l;
}
static String dbProgramID() {
  return getDBProgramID();
}
static void thinAProgramsBackups(String progID, boolean doIt) {
  List<File> files = new ArrayList();
  Map<File,Double> ageMap = new HashMap();
  
  Pattern pat = Pattern.compile("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
  //print("Processing backups of program " + progID);
  File dir = programDir(progID);
  for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
    String s = f.getName();
    Matcher matcher = pat.matcher(s);
    { if (!(matcher.find())) continue; }
    String originalName = matcher.group(1);
    { if (!(eq(originalName, "concepts.structure.gz"))) continue; }
    //print("Found backup: " + sfu(matcherGroups(matcher)));
    int year = matcherInt(matcher, 2);
    int month = matcherInt(matcher, 3);
    int day = matcherInt(matcher, 4);
    int hour = matcherInt(matcher, 5);
    long time = timestampFromYMDH(year, month, day, hour);
    double age = ((now()-time)/1000.0/60/60/24);
    //print("Age: " + age + " days");
    ageMap.put(f, age);
    files.add(f);
  }
  
  int numDeleted = 0;
  sortByMap_inPlace(files, ageMap);
  double lastAge = -1;
  for (File f : files) {
    double age = ageMap.get(f);
    if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
      //print("Deleting: " + f);
      ++numDeleted;
      if (doIt) {
        print("Deleting: " + f);
        f.delete();
      }
    } else {
      //print("Keeping: " + f);
      lastAge = age;
    }
  }
  if (numDeleted != 0)
    print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
}

// age = age in days
static boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
  return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
}
static <A extends Concept> Pair<A, Boolean> uniq2(Class<A> c, Object... params) {
  return uniq2(db_mainConcepts(), c, params);
}

static <A extends Concept> Pair<A, Boolean> uniq2(Concepts cc, Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhere(c, params);
  if (x == null) {
    x = unlisted(c);
    csetAll(x, params);
    cc.register(x);
    return pair(x, true);
  }
  return pair(x, false);
}
static PKIKeyPair pkiKeyPairFromTwoLineFile(File f) {
  List<String> l = tlft(loadTextFile(f));
  if (l(l) == 2) return new PKIKeyPair(second(l), first(l));
  return null;
}
static File agiBot_trustedKeyForMachine_file() {
  return javaxSecretDir("agi.blue-trusted-key-pair.txt");
}
static boolean endsWithLetterOrDigit(String s) {
  return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length()-1));
}
static void ping_okInCleanUp() {
  if (ping_pauseAll  || ping_anyActions )
    ping_impl(true);
}
// this syntax should be removed...
static Object getThreadLocal(Object o, String name) {
  ThreadLocal t =  (ThreadLocal) (getOpt(o, name));
  return t != null ? t.get() : null;
}

static <A> A getThreadLocal(ThreadLocal<A> tl) {
  return tl == null ? null : tl.get();
}

static <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
  return or(getThreadLocal(tl), defaultValue);
}
static ThreadLocal<Object> print_byThread_dontCreate() {
  return print_byThread;
}
static boolean isFalse(Object o) {
  return eq(false, o);
}
static Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();


  static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }



  static <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }



  static <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A> void callF(VF1<A> f, A a) {
    if (f != null) f.get(a);
  }


static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMC((String) f, args);
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) {
    
    throw fail("No get method in " + getClassName(c));
  }
  if (n == 1) return invokeMethod(methods.get(0), f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return invokeMethod(m, f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static String fixNewLines(String s) {
  int i = indexOf(s, '\r');
  if (i < 0) return s;
  int l = s.length();
  StringBuilder out = new StringBuilder(l);
  out.append(s, 0, i);
  for (; i < l; i++) {
    char c = s.charAt(i);
    if (c != '\r')
      out.append(c);
    else {
      out.append('\n');
      if (i+1 < l && s.charAt(i+1) == '\n') ++i;
    }
  }
  return out.toString();
}
static void print_append(Appendable buf, String s, int max) { try {
  synchronized(buf) {
    buf.append(s);
    if (buf instanceof StringBuffer)
      rotateStringBuffer(((StringBuffer) buf), max);
    else if (buf instanceof StringBuilder)
      rotateStringBuilder(((StringBuilder) buf), max);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static IterableIterator<String> toLines(File f) {
  return linesFromFile(f);
}

static List<String> toLines(String s) {
  List<String> lines = new ArrayList<String>();
  if (s == null) return lines;
  int start = 0;
  while (true) {
    int i = toLines_nextLineBreak(s, start);
    if (i < 0) {
      if (s.length() > start) lines.add(s.substring(start));
      break;
    }

    lines.add(s.substring(start, i));
    if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
      i += 2;
    else
      ++i;

    start = i;
  }
  return lines;
}

static int toLines_nextLineBreak(String s, int start) {
  for (int i = start; i < s.length(); i++) {
    char c = s.charAt(i);
    if (c == '\r' || c == '\n')
      return i;
  }
  return -1;
}
static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static PersistableThrowable persistableThrowable(Throwable e) {
  return e == null ? null : new PersistableThrowable(e);
}
static Throwable innerException(Throwable e) {
  return getInnerException(e);
}
static long toMS(double seconds) {
  return (long) (seconds*1000);
}
static volatile boolean sleep_noSleep = false;

static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  if (sleep_noSleep) throw fail("nosleep");
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }
static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt(String field, Object o) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) { try {
  Field f = getOpt_findField(o.getClass(), field);
  if (f == null) return null;
  f.setAccessible(true);
  return f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }

// access of static fields is not yet optimized
static Object getOpt(Class c, String field) { try {
  if (c == null) return null;
  Field f = getOpt_findStaticField(c, field);
  if (f == null) return null;
  f.setAccessible(true);
  return f.get(null);
} catch (Exception __e) { throw rethrow(__e); } }

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static String getClassName(Object o) {
  return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
}
static <A extends Concept> A findConceptWhereCI(Class<A> c, Object... params) {
  return findConceptWhereCI(db_mainConcepts(), c, params);
}

static <A extends Concept> A findConceptWhereCI(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  
  // indexed
  if (concepts.ciFieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
      if (index != null) {
        for (A x : index.getAll(params[i+1]))
          if (checkConceptFieldsIC(x, params)) return x;
        return null;
      }
    }
    
  // table scan
  for (A x : concepts.list(c)) if (checkConceptFieldsIC(x, params)) return x;
  return null;
}

static Concept findConceptWhereCI(Concepts concepts, String c, Object... params) {
  for (Concept x : concepts.list(c)) if (checkConceptFieldsIC(x, params)) return x;
  return null;
}

static <A extends Concept> List<A> filterConceptsIC(List<A> list, Object... params) {
  List<A> l = new ArrayList();
  for (A x : list)
    if (checkConceptFieldsIC(x, params))
      l.add(x);
  return l;
}
// magic cast
static <A> A cget(Object c, String field) {
  Object o = getOpt(c, field);
  if (o instanceof Concept.Ref) return (A) ((Concept.Ref) o).get();
  return (A) o;
}

static <A> A cget(String field, Object c) {
  return cget(c, field);
}
static List collectField(Collection c, String field) {
  List l = new ArrayList();
  if (c != null) for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}

static List collectField(String field, Collection c) {
  return collectField(c, field);
}
static <A extends Concept> A conceptWhereIC(Class<A> c, Object... params) {
  return findConceptWhereCI(c, params);
}

static Concept conceptWhereIC(String c, Object... params) {
  return findConceptWhereCI(db_mainConcepts(), c, params);
}

static <A extends Concept> A conceptWhereIC(Concepts concepts, Class<A> c, Object... params) {
  return findConceptWhereCI(concepts, c, params);
}

static Concept conceptWhereIC(Concepts concepts, String c, Object... params) {
  return findConceptWhereCI(concepts, c, params);
}
static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}
static boolean checkFieldsIC(Object x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (!eqicOrEq(getOpt(x, (String) data[i]), data[i+1]))
      return false;
  return true;
}
static boolean instanceOf(Object o, String className) {
  if (o == null) return false;
  String c = o.getClass().getName();
  return eq(c, className) || eq(c, "main$" + className);
}

static boolean instanceOf(Object o, Class c) {
  if (c == null) return false;
  return c.isInstance(o);
}
static <A> ArrayList<A> asList(A[] a) {
  return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  if (a == null) return null;
  ArrayList<Integer> l = emptyList(a.length);
  for (int i : a) l.add(i);
  return l;
}

static ArrayList<Float> asList(float[] a) {
  if (a == null) return null;
  ArrayList<Float> l = emptyList(a.length);
  for (float i : a) l.add(i);
  return l;
}
static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}


static <A> ArrayList<A> asList(Producer<A> p) {
  ArrayList l = new ArrayList();
  A a;
  if (p != null) while ((a = p.next()) != null)
    l.add(a);
  return l;
}


static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}
static boolean startsWithOneOf(String s, String... l) {
  for (String x : l) if (startsWith(s, x)) return true; return false;
}
static boolean regexpMatchesIC(String pat, String s) {
  return regexpICMatches(pat, s);
}



static boolean regexpMatchesIC(Pattern pat, String s) {
  return regexpICMatches(pat, s);
}
static String href(String link, Object contents, Object... params) {
  if (link == null) return str(contents);
  return tag("a", contents, arrayPlus(params, "href", link));
}
static boolean isAbsoluteURL(String s) {
  return contains(s, "://");
}
static String hostNameFromURL(String url) { try {
  return new URL(url).getHost();
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isAGIBlueDomain(String domain) {
  return domainIsUnder(domain, theAGIBlueDomain());
}
static String dropSuffixIC(String suffix, String s) {
  return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static String theAGIBlueDomain() {
  return "agi.blue";
}
static int maximumDomainPartLength() {
  return 63;
}
static <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
  m = cloneMap(m);
  litmap_impl(m, data);
  return m;
}
static Map<String, String> paramsFromURL(String url) {
  return decodeHQuery(getQueryFromURL(url));
}
static String htmlencode_noQuotes(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
    char c = s.charAt(i);
    if (c == '<') out.append("&lt;");
    else if (c == '>') out.append("&gt;");
    else if (c > 127 || c == '&') {
      out.append("&#");
      out.append((int) c);
      out.append(';');
    } else
      out.append(c);
  }
  return out.toString();
}
static String substring(String s, int x) {
  return substring(s, x, strL(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x >= s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.substring(x, y);
}


static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}

static int min(int[] c) {
  int x = Integer.MAX_VALUE;
  for (int d : c) if (d < x) x = d;
  return x;
}
// one array plus more elements
static Object[] arrayPlus(Object[] a1, Object... a2) {
  return concatArrays(a1, a2);
}
static String domainName() {
  Object session = call(getMainBot(), "getSession");
  Map headers =  (Map) (call(session, "getHeaders"));
  String host =  (String) (headers.get("host"));
  if (host == null) return null;
  return dropFrom(host, ":");
}
static String asString(Object o) {
  return o == null ? null : o.toString();
}
static boolean endsWithIgnoreCase(String a, String b) {
  int la = l(a), lb = l(b);
  return la >= lb && regionMatchesIC(a, la-lb, b, 0, lb);
}


static boolean endsWithIgnoreCase(String a, String b, Matches m) {
  if (!endsWithIgnoreCase(a, b)) return false;
  m.m = new String[] { substring(a, 0, l(a)-l(b)) };
  return true;
}

static String regexpReplace_direct(String s, String pat, String replacement) {
  Matcher m = regexp(pat, s);
  StringBuffer buf = new StringBuffer();
  while (m.find())
    m.appendReplacement(buf, replacement);
  m.appendTail(buf);
  return str(buf);
}
static ArrayList emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}

static ArrayList emptyList(int capacity) {
  return new ArrayList(max(0, capacity));
}

// Try to match capacity
static ArrayList emptyList(Iterable l) {
  return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
}

static ArrayList emptyList(Object[] l) {
  return emptyList(l(l));
}

// get correct type at once
static <A> ArrayList<A> emptyList(Class<A> c) {
  return new ArrayList();
}
static Map emptyMap() {
  return new HashMap();
}
static <A, B> B mapGet(Map<A, B> map, A a) {
  return map == null || a == null ? null : map.get(a);
}

static <A, B> B mapGet(A a, Map<A, B> map) {
  return map == null || a == null ? null : map.get(a);
}
static Map<String, String> subBot_getHttpFiles() {
  Object session = call(getMainBot(), "getSession");
  return (Map<String, String>) call(session, "getFiles");
}
static Object callOpt(Object o) {
  return callF(o);
}

static <A> A callOpt(Object o, String method, Object... args) {
  return (A) callOpt_withVarargs(o, method, args);
}
static Object getBot(String botID) {
  return callOpt(getMainBot(), "getBot", botID);
}

// make concept instance that is not connected to DB
static <A extends Concept> A unlisted(Class<A> c, Object... args) {
  concepts_unlisted.set(true);
  try {
    return nuObject(c, args);
  } finally {
    concepts_unlisted.set(null);
  }
}
static boolean possibleGlobalID(String s) {
  return l(s) == globalIDLength() && allLowerCaseCharacters(s);
}
static void assertTrue(Object o) {
  if (!(eq(o, true) /*|| isTrue(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static boolean startsWithIgnoreCase(String a, String b) {
  return regionMatchesIC(a, 0, b, 0, b.length());
}
static String dropSuffix(String suffix, String s) {
  return s.endsWith(suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static void printStructure(String prefix, Object o) {
  if (endsWithLetter(prefix)) prefix += ": ";
  print(prefix + structureForUser(o));
}

static void printStructure(Object o) {
  print(structureForUser(o));
}

static String unpackAGIDomainOpt(String s) {
  return or(unpackAGIDomain(s), s);
}
static boolean neqic(String a, String b) {
  return !eqic(a, b);
}

static boolean neqic(char a, char b) {
  return !eqic(a, b);
}
static <A extends Concept> Pair<A, Boolean> uniqCI2(Class<A> c, Object... params) {
  return uniqCI2(db_mainConcepts(), c, params);
}

static <A extends Concept> Pair<A, Boolean> uniqCI2(Concepts cc, Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhereCI(cc, c, params);
  if (x == null) {
    x = unlisted(c);
    csetAll(x, params);
    cc.register(x);
    return pair(x, true);
  }
  return pair(x, false);
}
static TreeSet<String> toCaseInsensitiveSet(Iterable<String> c) {
  if (isCISet(c)) return (TreeSet) c;
  TreeSet<String> set = caseInsensitiveSet();
  addAll(set, c);
  return set;
}

static TreeSet<String> toCaseInsensitiveSet(String... x) {
  TreeSet<String> set = caseInsensitiveSet();
  addAll(set, x);
  return set;
}
static List<String> filterNempty(Collection<String> c) {
  List<String> l = new ArrayList();
  for (String x : unnull(c))
    if (nempty(x))
      l.add(x);
  return l;
}
static MultiMap<String, String> decodeHQueryToMultiMap(String query) {
  MultiMap<String, String> map = new MultiMap();
  for (String s : splitAtAmpersand(query)) {
    int i = s.indexOf('=');
    if (i >= 0)
      map.put(urldecode(s.substring(0, i)), urldecode(s.substring(i+1)));
  }
  return map;
}
static <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
  return newSubListOrSame(l, startIndex, l(l));
}

static <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = max(0, startIndex);
  endIndex = min(n, endIndex);
  if (startIndex >= endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  return cloneList(l.subList(startIndex, endIndex));
}


static String hSilentComputator() {
  return hSilentComputator(hSilentComputator_defaultURI());
}

static String hSilentComputator(String wsUri) {
  return hSilentComputator(wsUri, "");
}

static String hSilentComputator(String wsUri, String flag) {
  if (nempty(flag)) wsUri = addSlash(wsUri) + flag;
  
  return div("Calculating", "id" , "calcing")
  + hcss("#calcing {\r\nposition: fixed;\r\nwidth: 100%;\r\nheight: 100vh;\r\nz-index: 9999;\r\nvisibility: hidden;\r\n}")
    + hMakeComputerID()
    + hreconnectingWebSockets()
    + hjavascript("\r\n      function sendPing() {\r\n        ${PINGCMD}\r\n      }\r\n      \r\n      var working = false;\r\n      var benchResultl;\r\n      var ws = new ReconnectingWebSocket(\"${URI}\");\r\n      ws.onopen = function(event) {\r\n        console.log(\"WebSocket opened.\");\r\n      };\r\n      ws.onmessage = function(event) {\r\n        var d = event.data;\r\n        while (d.length > 0 && d.charCodeAt(d.length-1) == 0)\r\n          d = d.substring(0, d.length-1);\r\n        console.log(\"Evaluating: \" + d);\r\n        var geval = eval; // use global scope\r\n        geval(d);\r\n        console.log(\"Evaluated.\");\r\n      };\r\n      \r\n      //working = true; // XXX\r\n      //console.log(\"Eval test: \" + eval('working'));\r\n  ".replace("${URI}", wsUri)
    .replace("${PINGCMD}", nodes_pingCmd()));
}
static String hSilentComputator_defaultURI() {
  int port = subBot_currentPort();
  return (subBot_isHttps() ? "wss://" : "ws://") + domain() 
    + (port == 80 ? "" : ":" + port) + "/";
}

static String himg(String src, Object... params) {
  return tag("img", "", arrayPlus(params, "src", src));
}
static String snippetImageLink(String snippetID) {
  return snippetImageURL(snippetID);
}
static String hrefBlank(String link, Object contents, Object... params) {
  return tag("a", contents, concatArrays(new Object[] { "href" , link, "target" , "_blank" }, params));
}
public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}
static String n2(long l) { return formatWithThousands(l); }
static String n2(Collection l) { return n2(l(l)); }

static String n2(double l, String singular) {
  return n2(l, singular, singular + "s");
}

static String n2(double l, String singular, String plural) {
  if (fraction(l) == 0)
    return n2((long) l, singular, plural);
  else
    return l + " " + plural;
}

static String n2(long l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(long l, String singular) {
  return n_fancy2(l, singular, singular + "s");
}

static String n2(Collection l, String singular) {
  return n2(l(l), singular);
}

static String n2(Collection l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(Map m, String singular, String plural) {
  return n_fancy2(m, singular, plural);
}

static String n2(Map m, String singular) {
  return n2(l(m), singular);
}

static String n2(Object[] a, String singular) { return n2(l(a), singular); }
static String n2(Object[] a, String singular, String plural) { return n_fancy2(a, singular, plural); }


  static String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

static Object collectionMutex(Object o) {
  String c = className(o);
  if (eq(c, "java.util.TreeMap$KeySet"))
    c = className(o = getOpt(o, "m"));
  else if (eq(c, "java.util.HashMap$KeySet"))
    c = className(o = get_raw(o, "this$0"));

  
  
  if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
    c = className(o = get_raw(o, "m"));
    
  
    
  return o;
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}

static boolean contains(BitSet bs, int i) {
  return bs != null && bs.get(i);
}
static String urlencode(String x) {
  try {
    return URLEncoder.encode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}
static String stringPar(Object[] params, String name) {
  return stringOptPar(params, name);
}

static String stringPar(String name, Object[] params) {
  return stringOptPar(params, name);
}

static String stringPar(String name, Map params) {
  return (String) optPar(name, params);
}

static String stringPar(String name, Object[] params, String defaultValue) {
  return optPar(name, params, defaultValue);
}
static String htmlencode(Object o) {
  return htmlencode(str(o));
}

static String htmlencode(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      /*if (c >= 0x100)
        out.append("&#x").append(charToHex(c)).append(';');
      else*/ if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&')
          out.append("&#").append((int) c).append(';');
      else
          out.append(c);
  }
  return out.toString();
}
static String unicode_leftPointingTriangle() {
  return unicodeFromCodePoint(0x25C2);
}
static String unicode_rightPointingTriangle() {
  return charToString(0x25B8);
}
static String lines(Iterable lines) { return fromLines(lines); }
static String lines(Object[] lines) { return fromLines(asList(lines)); }
static List<String> lines(String s) { return toLines(s); }
static float abs(float f) { return Math.abs(f); }
static int abs(int i) { return Math.abs(i); }
static double abs(double d) { return Math.abs(d); }
static Object call(Object o) {
  return callF(o);
}

// varargs assignment fixer for a single string array argument
static Object call(Object o, String method, String[] arg) {
  return call(o, method, new Object[] {arg});
}

static Object call(Object o, String method, Object... args) {
  //ret call_cached(o, method, args);
  return call_withVarargs(o, method, args);
}
static boolean odd(int i) {
  return (i & 1) != 0;
}

static boolean odd(long i) {
  return (i & 1) != 0;
}

static boolean odd(BigInteger i) { return odd(toInt(i)); }
static String[] dropFirst(int n, String[] a) {
  return drop(n, a);
}

static String[] dropFirst(String[] a) {
  return drop(1, a);
}

static Object[] dropFirst(Object[] a) {
  return drop(1, a);
}

static <A> List<A> dropFirst(List<A> l) {
  return dropFirst(1, l);
}

static <A> List<A> dropFirst(int n, Iterable<A> i) { return dropFirst(n, toList(i)); }
static <A> List<A> dropFirst(Iterable<A> i) { return dropFirst(toList(i)); }

static <A> List<A> dropFirst(int n, List<A> l) {
  return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
}

static <A> List<A> dropFirst(List<A> l, int n) {
  return dropFirst(n, l);
}

static String dropFirst(int n, String s) { return substring(s, n); }
static String dropFirst(String s, int n) { return substring(s, n); }
static String dropFirst(String s) { return substring(s, 1); }
static Object[] html_massageAutofocusParam(Object[] params) {
  Object autofocus = optPar("autofocus",params);
  return changeParam(params, "autofocus" , eqOneOf(autofocus, true, 1, "1", "autofocus") ? html_valueLessParam() : null);
}
static Object[] concatArrays(Object[]... arrays) {
  int l = 0;
  for (Object[] a : arrays) l += l(a);
  Object[] x = new Object[l];
  int i = 0;
  for (Object[] a : arrays) if (a != null) {
    System.arraycopy(a, 0, x, i, l(a));
    i += l(a);
  }
  return x;
}

static String nlToBr(String s) {
  return s.replace("\n", "<br>\n");
}
static String nemptyLines(Iterable l) {
  return lines(nempties(allToString(l)));
}
static String hhead(Object contents) {
  return tag("head", contents);
}
static String htitle(String title) {
  return tag("title", htmlencode_noQuotes(title));
}
static Object serveJSON_shallowLineBreaks(Object data) {
  return serveText(jsonEncode_shallowLineBreaks(data));
}
static boolean checkCondition(Object condition, Object... args) {
  return isTrue(callF(condition, args));
}

static <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
  return isTrue(callF(condition, arg));
}
static boolean isSquareBracketed(String s) {
  return s != null && s.startsWith("[") && s.endsWith("]");
}
static boolean isInteger(String s) {
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  if (s.charAt(0) == '-')
    if (++i >= n) return false;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static String deSquareBracket(String s) {
  if (startsWith(s, "[") && endsWith(s, "]"))
    return substring(s, 1, l(s)-1);
  return s;
}
static Object dm_getModule(Object moduleOrID) {
  if (moduleOrID == null || eq(moduleOrID, "")) return null;
  if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
    return dm_getService(((String) moduleOrID));
  if (isStringOrIntOrLong(moduleOrID))
    return dm_callOS("getDynModuleByID", str(moduleOrID));
  return dm_resolveModule(moduleOrID);
}
static AutoCloseable dm_enter(Object mod) {
  return (AutoCloseable) callOpt(dm_getModule(mod), "enter");
}
static Object call_withVarargs(Object o, String method, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findStaticMethod(method, args);
    if (me != null)
      return invokeMethod(me, null, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      { if (!(isStaticMethod(m))) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, null, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(method, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found in " + c);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static void _close(AutoCloseable c) {
  if (c != null) try {
    c.close();
  } catch (Throwable e) {
    // Some classes stupidly throw an exception on double-closing
    if (c instanceof javax.imageio.stream.ImageOutputStream)
      return;
    else throw rethrow(e);
  }
}
static String programID;

static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}


// TODO: ask JavaX instead
static String getProgramID(Class c) {
  String id = (String) getOpt(c, "programID");
  if (nempty(id))
    return formatSnippetID(id);
  return "?";
}


static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}
static Object[] paramsPlus(Object[] a1, Object... a2) {
  if (a2 == null) return a1;
  if (a1 == null) return a2;
  if (l(a1) == 1 && a1[0] instanceof Map)
    return new Object[] { mapPlus((Map) a1[0], a2) };
  assertEvenLength(a1);
  assertEvenLength(a2);
  Map map = paramsToOrderedMap(a1);
  int n = l(a2);
  for (int i = 0; i < n; i += 2) {
    Object key = a2[i];
    if (key != null) map.put(key, a2[i+1]);
  }
  return mapToParams(map);
}
static boolean containsIgnoreCase(Collection<String> l, String s) {
  if (l != null) for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String[] l, String s) {
  if (l != null) for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String s, char c) {
  return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
}

static boolean containsIgnoreCase(String a, String b) {
  return indexOfIgnoreCase(a, b) >= 0;
}
static String htmlQuery(Map params) {
  return empty(params) ? "" : "?" + makePostData(params);
}

static String htmlQuery(Object... data) {
  return empty(data) ? "" : "?" + makePostData(data);
}
static <A> List<A> listPlus(Collection<A> l, A... more) {
  return concatLists(l, asList(more));
}
static String spaced(String s) {
  return " " + unnull(s) + " ";
}
static String div(Object contents, Object... params) {
  return hfulltag("div", contents, params);
}

static BigInteger div(BigInteger a, BigInteger b) {
  return a.divide(b);
}

static BigInteger div(BigInteger a, int b) {
  return a.divide(bigint(b));
}
static TimerTask timerTask(final Object r, final java.util.Timer timer) {
  return new TimerTask() {
    public void run() {
      
      if (!licensed())
        timer.cancel();
      else
        pcallF(r);
    }
  };
}
static Object vmBus_wrapArgs(Object... args) {
  return empty(args) ? null
    : l(args) == 1 ? args[0]
    : args;
}
static void pcallFAll(Collection l, Object... args) {
  if (l != null) for (Object f : cloneList(l)) pcallF(f, args);
}

static void pcallFAll(Iterator it, Object... args) {
  while (it.hasNext()) pcallF(it.next(), args);
}
static Set vm_busListeners_live_cache;
static Set vm_busListeners_live() { if (vm_busListeners_live_cache == null) vm_busListeners_live_cache = vm_busListeners_live_load(); return vm_busListeners_live_cache; }

static Set vm_busListeners_live_load() {
  return vm_generalIdentityHashSet("busListeners");
}
static Map<String, Set> vm_busListenersByMessage_live_cache;
static Map<String, Set> vm_busListenersByMessage_live() { if (vm_busListenersByMessage_live_cache == null) vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load(); return vm_busListenersByMessage_live_cache; }

static Map<String, Set> vm_busListenersByMessage_live_load() {
  return vm_generalHashMap("busListenersByMessage");
}
static String hfulltag(String tag) {
  return hfulltag(tag, "");
}

static String hfulltag(String tag, Object contents, Object... params) {
  return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
}
static <A> A oneOf(List<A> l) {
  return l.isEmpty() ? null : l.get(new Random().nextInt(l.size()));
}

static char oneOf(String s) {
  return empty(s) ? '?' : s.charAt(random(l(s)));
}

static String oneOf(String... l) {
  return oneOf(asList(l));
}
static <A> A collectionGet(Collection<A> c, int idx) {
  if (c == null || idx < 0 || idx >= l(c)) return null;
  if (c instanceof List) return listGet((List<A>) c, idx);
  Iterator<A> it = c.iterator();
  for (int i = 0; i < idx; i++) if (it.hasNext()) it.next(); else return null;
  return it.hasNext() ? it.next() : null;
}
static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  if (o instanceof ThreadLocal)
    return isTrue(((ThreadLocal) o).get());
  throw fail(getClassName(o));
}
static Map<String, java.util.regex.Pattern> compileRegexpIC_cache = syncMRUCache(10);

static java.util.regex.Pattern compileRegexpIC(String pat) {
  java.util.regex.Pattern p = compileRegexpIC_cache.get(pat);
  if (p == null) {
    
    try {
      compileRegexpIC_cache.put(pat, p = java.util.regex.Pattern.compile(pat, Pattern.CASE_INSENSITIVE));
    } catch (PatternSyntaxException e) {
      throw rethrow(wrapPatternSyntaxException(e));
    }
  }
  return p;
}
static boolean regexpICFind(Pattern pat, String s) {
  return regexpIC(pat, s).find();
}

static boolean regexpICFind(String pat, String s) {
  return regexpIC(pat, s).find();
}
static String fullTrimLastLine(String s) {
  return trimLastLine(rtrim(s));
}
static boolean swic_trim(String a, String b, Matches m) {
  if (!swic(a, b)) return false;
  m.m = new String[] {trim(substring(a, l(b)))};
  return true;
}
static Object mainBot;

static Object getMainBot() {
  return mainBot;
}
static <A> A last(List<A> l) {
  return empty(l) ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static <A> A last(A[] a) {
  return l(a) != 0 ? a[l(a)-1] : null;
}

static <A> A last(Iterator<A> it) {
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}
static <A> A popLast(List<A> l) {
  return liftLast(l);
}
// usually L<S>
static String fromLines(Iterable lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null)
    for (Object line : lines)
      buf.append(str(line)).append('\n');
  return buf.toString();
}

static String fromLines(String... lines) {
  return fromLines(asList(lines));
}
static String[] dropLast(String[] a, int n) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, 0, b, 0, b.length);
  return b;
}

static <A> List<A> dropLast(List<A> l) {
  return subList(l, 0, l(l)-1);
}

static <A> List<A> dropLast(int n, List<A> l) {
  return subList(l, 0, l(l)-n);
}

static <A> List<A> dropLast(Iterable<A> l) {
  return dropLast(asList(l));
}

static String dropLast(String s) {
  return substring(s, 0, l(s)-1);
}

static String dropLast(String s, int n) {
  return substring(s, 0, l(s)-n);
}

static String dropLast(int n, String s) {
  return dropLast(s, n);
}

static String dropPrefixMandatory(String prefix, String s) {
  if (s.startsWith(prefix))
    return s.substring(prefix.length());
  else
    throw fail("Prefix " + prefix + " not found in: " + s);
}

static byte[] toUtf8(String s) { try {
  return s.getBytes("UTF-8");
} catch (Exception __e) { throw rethrow(__e); } }
static <A extends Throwable> A printStackTrace(A e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

static void printStackTrace(String msg, Throwable e) {
  printStackTrace(new Throwable(msg, e));
}
// if text trails with \n, drops the line before that
static String dropLastLine(String s) {
  s = dropSuffix("\r", dropSuffix("\n", s));
  int i = s.lastIndexOf('\n');
  return i < 0 ? "" : dropSuffix("\r", substring(s, 0, i));
}
static List<String> toLinesFullTrim(String s) {
  
  List<String> l = new ArrayList();
  for (String line : toLines(s)) if (nempty(line = trim(line))) l.add(line);
  return l;
}

static List<String> toLinesFullTrim(File f) {
  List<String> l = new ArrayList();
  for (String line : linesFromFile(f)) if (nempty(line = trim(line))) l.add(line);
  return l;
}

static boolean jsonDecode_useOrderedMaps = true;

static Object jsonDecode(final String text) {
  final List<String> tok = jsonTok(text);
  if (l(tok) == 1) return null;
  
  class Y {
    int i = 1;

    Object parse() {
      String t = tok.get(i);
      if (t.startsWith("\"")) {
        String s = unquote(tok.get(i));
        i += 2;
        return s;
      }
      if (t.equals("{"))
        return parseMap();
      if (t.equals("["))
        return this.parseList(); // avoid loading standard function "parseList"
      if (t.equals("null")) {
        i += 2; return null;
      }
      if (t.equals("false")) {
        i += 2; return false;
      }
      if (t.equals("true")) {
        i += 2; return true;
      }
      boolean minus = false;
      if (t.equals("-")) {
        minus = true;
        i += 2;
        t = get(tok, i);
      }
      if (isInteger(t)) {
        i += 2;
        if (eq(get(tok, i), ".")) {
          String x = t + "." + get(tok, i+2);
          i += 4;
          double d = parseDouble(x);
          if (minus) d = -d;
          return d;
        } else {
          long l = parseLong(t);
          if (minus) l = -l;
          return l != (int) l ? new Long(l) : new Integer((int) l);
        }
      }
      
      throw new RuntimeException("Unknown token " + (i+1) + ": " + t + ": " + text);
    }
    
    Object parseList() {
      consume("[");
      List list = new ArrayList();
      while (!tok.get(i).equals("]")) {
        list.add(parse());
        if (tok.get(i).equals(",")) i += 2;
      }
      consume("]");
      return list;
    }
    
    Object parseMap() {
      consume("{");
      Map map = jsonDecode_useOrderedMaps ? new LinkedHashMap() : new TreeMap();
      while (!tok.get(i).equals("}")) {
        String key = unquote(tok.get(i));
        i += 2;
        consume(":");
        Object value = parse();
        map.put(key, value);
        if (tok.get(i).equals(",")) i += 2;
      }
      consume("}");
      return map;
    }
    
    void consume(String s) {
      if (!tok.get(i).equals(s)) {
        String prevToken = i-2 >= 0 ? tok.get(i-2) : "";
        String nextTokens = join(tok.subList(i, Math.min(i+4, tok.size())));
        throw fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");
      }
      i += 2;
    }
  }
  
  return new Y().parse();
}
static String getDBProgramID_id;

static String getDBProgramID() {
  return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
}
static Object _defaultClassFinder_value = defaultDefaultClassFinder();

static Object _defaultClassFinder() {
  return _defaultClassFinder_value;
}
// TODO: if field is a Ref<>, you can thoretically use findBackRefs

static <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
  return findConceptWhere(db_mainConcepts(), c, params);
}

static <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  
  // indexed
  if (concepts.fieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
      if (index != null) {
        for (A x : index.getAll(params[i+1]))
          if (checkConceptFields(x, params)) return x;
        return null;
      }
    }
    
  // table scan
  for (A x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}

static Concept findConceptWhere(Concepts concepts, String c, Object... params) {
  for (Concept x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}

// TODO: does not detect set type (hash/tree) when it's synchronized
static <A> Set<A> cloneSet(Set<A> set) {
  if (set == null) return new HashSet();
  synchronized(collectionMutex(set)) {
    Set<A> s = similarEmptySet(set);
    s.addAll(set);
    return s;
  }
}
static TreeSet<String> collectInCISet(Iterable c, String field) {
  TreeSet<String> set = ciSet();
  for (Object a : c) {
    Object val = getOpt(a, field);
    if (val instanceof String)
      set.add(((String) val));
  }
  return set;
}

static TreeSet<String> collectInCISet(String field, Iterable c) {
  return collectInCISet(c, field);
}
static <A> MultiSet<A> asCIMultiSet(Iterable<A> l) {
  MultiSet ms = new MultiSet();
  ms.map = ciMap();
  ms.addAll(l);
  return ms;
}
static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  int n = l(l);
  for (int i = startIndex; i < n; i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, int startIndex, A a) {
  return indexOf(l, a, startIndex);
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b) {
  return a == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, int i, char b) {
  return indexOf(a, b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  int n = l(x);
  for (int i = 0; i < n; i++)
    if (eq(x[i], a))
      return i;
  return -1;
}
static TreeSet<String> ciSet() {
  return caseInsensitiveSet();
}
static File getProgramFile(String progID, String fileName) {
  if (new File(fileName).isAbsolute())
    return new File(fileName);
  return new File(getProgramDir(progID), fileName);
}

static File getProgramFile(String fileName) {
  return getProgramFile(getProgramID(), fileName);
}

static String conceptsFileName() {
  return "concepts.structure.gz";
}
static long ratio(long x, long y) {
  return y == 0 ? 0 : x/y;
}
// PersistableThrowable doesn't hold GC-disturbing class references in backtrace
static volatile PersistableThrowable lastException_lastException;

static PersistableThrowable lastException() {
  return lastException_lastException;
}

static void lastException(Throwable e) {
  lastException_lastException = persistableThrowable(e);
}
static Throwable getInnerException(Throwable e) {
  if (e == null) return null;
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}

static Throwable getInnerException(Runnable r) {
  return getInnerException(getException(r));
}
static String hideCredentials(URL url) { return url == null ? null : hideCredentials(str(url)); }

static String hideCredentials(String url) {
  try {
    if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url))) return url;
  } catch (Throwable e) {
    print("HideCredentials", e);
  }
  return url.replaceAll("([&?])(_pass|key)=[^&\\s\"]*", "$1$2=<hidden>");
}

static String hideCredentials(Object o) {
  return hideCredentials(str(o));
}
static String baseClassName(String className) {
  return substring(className, className.lastIndexOf('.')+1);
}

static String baseClassName(Object o) {
  return baseClassName(getClassName(o));
}
static String prependIfNempty(String prefix, String s) {
  return empty(s) ? s : prefix + s;
}
static TreeMap litCIMap(Object... x) {
  TreeMap map = caseInsensitiveMap();
  litmap_impl(map, x);
  return map;
}
static int howManySecondsAgo(long timestamp) {
  return iround(toSeconds(now()-timestamp));
}
static int iround(double d) {
  return (int) Math.round(d);
}

static int iround(Number n) {
  return iround(toDouble(n));
}
static List<String> sortedIgnoreCase(Collection<String> c) {
  List<String> l = cloneList(c);
  Collections.sort(l, caseInsensitiveComparator());
  return l;
}

static <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
  if (l == null) return new ArrayList();
  synchronized(mutex) {
    return new ArrayList<A>(l);
  }
}
static String yesno(boolean b) {
  return yesno((Boolean) b);
}

static String yesno(Boolean b) {
  return eq(b, true) ? "Yes. " : eq(b, false) ? "No. " : "Unknown. ";
}
static <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
  return optPar(tl, defaultValue);
}

static <A> A optParam(ThreadLocal<A> tl) {
  return optPar(tl);
}

static Object optParam(String name, Map params) {
  return mapGet(params, name);
}

// now also takes a map as single array entry
static <A> A optParam(Object[] opt, String name, A defaultValue) {
  int n = l(opt);
  if (n == 1 && opt[0] instanceof Map) {
    Map map =  (Map) (opt[0]);
    return map.containsKey(name) ? (A) map.get(name) : defaultValue;
  }
  if (!even(l(opt))) throw fail("Odd parameter length");
  for (int i = 0; i < l(opt); i += 2)
    if (eq(opt[i], name))
      return (A) opt[i+1];
  return defaultValue;
}

static Object optParam(Object[] opt, String name) {
  return optParam(opt, name, null);
}
static boolean equalsIgnoreCase(String a, String b) {
  return eqic(a, b);
}

static boolean equalsIgnoreCase(char a, char b) {
  return eqic(a, b);
}
static <A, B> List<A> keysSortedByValues(final Map<A, B> map) {
  List<A> l = new ArrayList(map.keySet());
  sort(l, mapComparator(map));
  return l;
}
static String htmldecode(final String input) {
  if (input == null) return null;
  
  final int MIN_ESCAPE = 2;
  final int MAX_ESCAPE = 6;

  StringWriter writer = null;
  int len = input.length();
  int i = 1;
  int st = 0;
  while (true) {
      // look for '&'
      while (i < len && input.charAt(i-1) != '&')
          i++;
      if (i >= len)
          break;

      // found '&', look for ';'
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';')
          j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
          i++;
          continue;
      }

      // found escape 
      if (input.charAt(i) == '#') {
          // numeric escape
          int k = i + 1;
          int radix = 10;

          final char firstChar = input.charAt(k);
          if (firstChar == 'x' || firstChar == 'X') {
              k++;
              radix = 16;
          }

          try {
              int entityValue = Integer.parseInt(input.substring(k, j), radix);

              if (writer == null) 
                  writer = new StringWriter(input.length());
              writer.append(input.substring(st, i - 1));

              if (entityValue > 0xFFFF) {
                  final char[] chrs = Character.toChars(entityValue);
                  writer.write(chrs[0]);
                  writer.write(chrs[1]);
              } else {
                  writer.write(entityValue);
              }

          } catch (NumberFormatException ex) { 
              i++;
              continue;
          }
      }
      else {
          // named escape
          CharSequence value = htmldecode_lookupMap.get(input.substring(i, j));
          if (value == null) {
              i++;
              continue;
          }

          if (writer == null) 
              writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));

          writer.append(value);
      }

      // skip escape
      st = j + 1;
      i = st;
  }

  if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
  }
  return input;
}

private static final String[][] htmldecode_ESCAPES = {
    {"\"",     "quot"}, // " - double-quote
    {"&",      "amp"}, // & - ampersand
    {"<",      "lt"}, // < - less-than
    {">",      "gt"}, // > - greater-than

    // Mapping to escape ISO-8859-1 characters to their named HTML 3.x equivalents.
    {"\u00A0", "nbsp"}, // non-breaking space
    {"\u00A1", "iexcl"}, // inverted exclamation mark
    {"\u00A2", "cent"}, // cent sign
    {"\u00A3", "pound"}, // pound sign
    {"\u00A4", "curren"}, // currency sign
    {"\u00A5", "yen"}, // yen sign = yuan sign
    {"\u00A6", "brvbar"}, // broken bar = broken vertical bar
    {"\u00A7", "sect"}, // section sign
    {"\u00A8", "uml"}, // diaeresis = spacing diaeresis
    {"\u00A9", "copy"}, // copyright sign
    {"\u00AA", "ordf"}, // feminine ordinal indicator
    {"\u00AB", "laquo"}, // left-pointing double angle quotation mark = left pointing guillemet
    {"\u00AC", "not"}, // not sign
    {"\u00AD", "shy"}, // soft hyphen = discretionary hyphen
    {"\u00AE", "reg"}, // registered trademark sign
    {"\u00AF", "macr"}, // macron = spacing macron = overline = APL overbar
    {"\u00B0", "deg"}, // degree sign
    {"\u00B1", "plusmn"}, // plus-minus sign = plus-or-minus sign
    {"\u00B2", "sup2"}, // superscript two = superscript digit two = squared
    {"\u00B3", "sup3"}, // superscript three = superscript digit three = cubed
    {"\u00B4", "acute"}, // acute accent = spacing acute
    {"\u00B5", "micro"}, // micro sign
    {"\u00B6", "para"}, // pilcrow sign = paragraph sign
    {"\u00B7", "middot"}, // middle dot = Georgian comma = Greek middle dot
    {"\u00B8", "cedil"}, // cedilla = spacing cedilla
    {"\u00B9", "sup1"}, // superscript one = superscript digit one
    {"\u00BA", "ordm"}, // masculine ordinal indicator
    {"\u00BB", "raquo"}, // right-pointing double angle quotation mark = right pointing guillemet
    {"\u00BC", "frac14"}, // vulgar fraction one quarter = fraction one quarter
    {"\u00BD", "frac12"}, // vulgar fraction one half = fraction one half
    {"\u00BE", "frac34"}, // vulgar fraction three quarters = fraction three quarters
    {"\u00BF", "iquest"}, // inverted question mark = turned question mark
    {"\u00C0", "Agrave"}, // ? - uppercase A, grave accent
    {"\u00C1", "Aacute"}, // ? - uppercase A, acute accent
    {"\u00C2", "Acirc"}, // ? - uppercase A, circumflex accent
    {"\u00C3", "Atilde"}, // ? - uppercase A, tilde
    {"\u00C4", "Auml"}, // ? - uppercase A, umlaut
    {"\u00C5", "Aring"}, // ? - uppercase A, ring
    {"\u00C6", "AElig"}, // ? - uppercase AE
    {"\u00C7", "Ccedil"}, // ? - uppercase C, cedilla
    {"\u00C8", "Egrave"}, // ? - uppercase E, grave accent
    {"\u00C9", "Eacute"}, // ? - uppercase E, acute accent
    {"\u00CA", "Ecirc"}, // ? - uppercase E, circumflex accent
    {"\u00CB", "Euml"}, // ? - uppercase E, umlaut
    {"\u00CC", "Igrave"}, // ? - uppercase I, grave accent
    {"\u00CD", "Iacute"}, // ? - uppercase I, acute accent
    {"\u00CE", "Icirc"}, // ? - uppercase I, circumflex accent
    {"\u00CF", "Iuml"}, // ? - uppercase I, umlaut
    {"\u00D0", "ETH"}, // ? - uppercase Eth, Icelandic
    {"\u00D1", "Ntilde"}, // ? - uppercase N, tilde
    {"\u00D2", "Ograve"}, // ? - uppercase O, grave accent
    {"\u00D3", "Oacute"}, // ? - uppercase O, acute accent
    {"\u00D4", "Ocirc"}, // ? - uppercase O, circumflex accent
    {"\u00D5", "Otilde"}, // ? - uppercase O, tilde
    {"\u00D6", "Ouml"}, // ? - uppercase O, umlaut
    {"\u00D7", "times"}, // multiplication sign
    {"\u00D8", "Oslash"}, // ? - uppercase O, slash
    {"\u00D9", "Ugrave"}, // ? - uppercase U, grave accent
    {"\u00DA", "Uacute"}, // ? - uppercase U, acute accent
    {"\u00DB", "Ucirc"}, // ? - uppercase U, circumflex accent
    {"\u00DC", "Uuml"}, // ? - uppercase U, umlaut
    {"\u00DD", "Yacute"}, // ? - uppercase Y, acute accent
    {"\u00DE", "THORN"}, // ? - uppercase THORN, Icelandic
    {"\u00DF", "szlig"}, // ? - lowercase sharps, German
    {"\u00E0", "agrave"}, // ? - lowercase a, grave accent
    {"\u00E1", "aacute"}, // ? - lowercase a, acute accent
    {"\u00E2", "acirc"}, // ? - lowercase a, circumflex accent
    {"\u00E3", "atilde"}, // ? - lowercase a, tilde
    {"\u00E4", "auml"}, // ? - lowercase a, umlaut
    {"\u00E5", "aring"}, // ? - lowercase a, ring
    {"\u00E6", "aelig"}, // ? - lowercase ae
    {"\u00E7", "ccedil"}, // ? - lowercase c, cedilla
    {"\u00E8", "egrave"}, // ? - lowercase e, grave accent
    {"\u00E9", "eacute"}, // ? - lowercase e, acute accent
    {"\u00EA", "ecirc"}, // ? - lowercase e, circumflex accent
    {"\u00EB", "euml"}, // ? - lowercase e, umlaut
    {"\u00EC", "igrave"}, // ? - lowercase i, grave accent
    {"\u00ED", "iacute"}, // ? - lowercase i, acute accent
    {"\u00EE", "icirc"}, // ? - lowercase i, circumflex accent
    {"\u00EF", "iuml"}, // ? - lowercase i, umlaut
    {"\u00F0", "eth"}, // ? - lowercase eth, Icelandic
    {"\u00F1", "ntilde"}, // ? - lowercase n, tilde
    {"\u00F2", "ograve"}, // ? - lowercase o, grave accent
    {"\u00F3", "oacute"}, // ? - lowercase o, acute accent
    {"\u00F4", "ocirc"}, // ? - lowercase o, circumflex accent
    {"\u00F5", "otilde"}, // ? - lowercase o, tilde
    {"\u00F6", "ouml"}, // ? - lowercase o, umlaut
    {"\u00F7", "divide"}, // division sign
    {"\u00F8", "oslash"}, // ? - lowercase o, slash
    {"\u00F9", "ugrave"}, // ? - lowercase u, grave accent
    {"\u00FA", "uacute"}, // ? - lowercase u, acute accent
    {"\u00FB", "ucirc"}, // ? - lowercase u, circumflex accent
    {"\u00FC", "uuml"}, // ? - lowercase u, umlaut
    {"\u00FD", "yacute"}, // ? - lowercase y, acute accent
    {"\u00FE", "thorn"}, // ? - lowercase thorn, Icelandic
    {"\u00FF", "yuml"}, // ? - lowercase y, umlaut
    {"\u2013", "ndash"},
    {"\u2018", "lsquo"},
    {"\u2019", "rsquo"},
    {"\u201D", "rdquo"},
    {"\u201C", "ldquo"},
    {"\u2014", "mdash"},
    
    {"'", "apos"}, // the controversial (but who cares!) &apos;
      // stackoverflow.com/questions/2083754/why-shouldnt-apos-be-used-to-escape-single-quotes
  };

private static final HashMap<String, CharSequence> htmldecode_lookupMap;
static {
    htmldecode_lookupMap = new HashMap<String, CharSequence>();
    for (final CharSequence[] seq : htmldecode_ESCAPES) 
        htmldecode_lookupMap.put(seq[1].toString(), seq[0]);
}
// tok should be the output of htmlcoarsetok
static List<String> dropAllTags(List<String> tok) {
  List<String> list = new ArrayList();
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && t.startsWith("<")) {
      list.set(list.size()-1, list.get(list.size()-1) + tok.get(i+1));
      ++i;
    } else
      list.add(t);
  }
  return list;
}

// alternatively, call this convenient function
static String dropAllTags(String html) {
  return join(dropAllTags(htmlcoarsetok(html)));
}
static boolean isLocalSnippetID(String snippetID) {
  return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
}

static boolean isLocalSnippetID(long snippetID) {
  return snippetID >= 1000 && snippetID <= 9999;
}
static String loadLocalSnippet(String snippetID) {
  return loadLocalSnippet(psI(snippetID));
}

static String loadLocalSnippet(long snippetID) {
  return loadTextFile(localSnippetFile(snippetID));
}
static IResourceLoader vm_getResourceLoader() {
  return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
}
static String fsI(String id) {
  return formatSnippetID(id);
}

static String fsI(long id) {
  return formatSnippetID(id);
}
static String tb_mainServer_default = "http://code.botcompany.de:8081";
static Object tb_mainServer_override; // func -> S

static String tb_mainServer() {
  if (tb_mainServer_override != null) return (String) callF(tb_mainServer_override);
  return trim(loadTextFile(tb_mainServer_file(),
    tb_mainServer_default));
}

static File tb_mainServer_file() {
  return getProgramFile("#1001638", "mainserver.txt");
}

static boolean tb_mainServer_isDefault() {
  return eq(tb_mainServer(), tb_mainServer_default);
}
static String standardCredentials() {
  String user = standardCredentialsUser();
  String pass = standardCredentialsPass();
  if (nempty(user) && nempty(pass))
    return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
  return "";
}
static String loadTextFile(String fileName) {
  return loadTextFile(fileName, null);
}

static String loadTextFile(File f, String defaultContents) { try {
  
  checkFileNotTooBigToRead(f);
  
  if (f == null || !f.exists()) return defaultContents;

  FileInputStream fileInputStream = new FileInputStream(f);
  InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
  return loadTextFile(inputStreamReader);
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadTextFile(File fileName) {
  return loadTextFile(fileName, null);
}

static String loadTextFile(String fileName, String defaultContents) {
  return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
}

static String loadTextFile(Reader reader) throws IOException {
  StringBuilder builder = new StringBuilder();
  try {
    char[] buffer = new char[1024];
    int n;
    while (-1 != (n = reader.read(buffer)))
      builder.append(buffer, 0, n);
  } finally {
    reader.close();
  }
  return str(builder);
}
/** writes safely (to temp file, then rename) */
static File saveTextFile(String fileName, String contents) throws IOException {
  CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  try {
    File file = new File(fileName);
    mkdirsForFile(file);
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists()) try {
        String saveName = tempFileName + ".saved." + now();
        copyFile(tempFile, new File(saveName));
      } catch (Throwable e) { printStackTrace(e); }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(contents);
      printWriter.close();
    }
    
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
  
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
        
    vmBus_send("wroteFile", file);
    return file;
  } finally {
    action.done();
  }
}

static File saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
  return fileName;
} catch (Exception __e) { throw rethrow(__e); } }
static File getGlobalCache() {
  File file = new File(javaxCachesDir(), "Binary Snippets");
  file.mkdirs();
  return file;
}

static <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
  if (tl == null) return null;
  A old = tl.get();
  tl.set(value);
  return old;
}
static int loadPage_defaultTimeout = 60000;
static ThreadLocal<String> loadPage_charset = new ThreadLocal();
static boolean loadPage_allowGzip = true, loadPage_debug;
static boolean loadPage_anonymous = false; // don't send computer ID
static int loadPage_verboseness = 100000;
static int loadPage_retries = 1; //60; // seconds
static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();
static volatile int loadPage_forcedTimeout; // ms
static ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal(); // ms
static ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

public static String loadPageSilently(String url) { try {
  return loadPageSilently(new URL(loadPage_preprocess(url)));
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadPageSilently(URL url) { try {
  if (url.getProtocol().equals("https"))
    disableCertificateValidation();
    
  if (!networkAllowanceTest(str(url))) throw fail("Not allowed: " + url);
    
  IOException e = null;
  for (int tries = 0; tries < loadPage_retries; tries++)
    try {
      URLConnection con = loadPage_openConnection(url);
      return loadPage(con, url);
    } catch (IOException _e) {
      e = _e;
      if (loadPageThroughProxy_enabled) {
        print("Trying proxy because of: " + e);
        try {
          return loadPageThroughProxy(str(url));
        } catch (Throwable e2) {
          print("  " + exceptionToStringShort(e2));
        }
      } else if (loadPage_debug)
        print(exceptionToStringShort(e));
      if (tries < loadPage_retries-1) sleepSeconds(1);
    }
  throw e;
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage_preprocess(String url) {  
  if (url.startsWith("tb/")) // don't think we use this anymore
    url = tb_mainServer() + "/" + url;
  if (url.indexOf("://") < 0)
    url = "http://" + url;
  return url;
}

static String loadPage(String url) { try {
  url = loadPage_preprocess(url);
  if (!isTrue(loadPage_silent.get()))
    printWithTime("Loading: " + hideCredentials(url));
  return loadPageSilently(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage(URL url) {
  return loadPage(url.toExternalForm());
}

static String loadPage(URLConnection con, URL url) throws IOException {
  return loadPage(con, url, true);
}

static String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
  if (addHeaders) try {
    if (!loadPage_anonymous)
      setHeaders(con);
    if (loadPage_allowGzip)
      con.setRequestProperty("Accept-Encoding", "gzip");
    con.setRequestProperty("X-No-Cookies", "1");
    for (String key : keys(extraHeaders))
      con.setRequestProperty(key, extraHeaders.get(key));
  } catch (Throwable e) {} // fails if within doPost
  
  
  vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
  
  loadPage_responseHeaders.set(con.getHeaderFields());
  InputStream in = null;
  try {
    in = urlConnection_getInputStream(con);
  //vm_generalSubMap("InputStream per thread").put(currentThread(), in);
  if (loadPage_debug)
    print("Put stream in map: " + currentThread());
    String contentType = con.getContentType();
    if (contentType == null) {
      //printStruct("Headers: ", con.getHeaderFields());
      throw new IOException("Page could not be read: " + hideCredentials(url));
    }
    //print("Content-Type: " + contentType);
    String charset = loadPage_charset == null ? null : loadPage_charset.get();
    if (charset == null) charset = loadPage_guessCharset(contentType);
    
    if ("gzip".equals(con.getContentEncoding())) {
      if (loadPage_debug)
        print("loadPage: Using gzip.");
      in = newGZIPInputStream(in);
    }
    Reader r;
    try {
      r = new InputStreamReader(in, unquote(charset));
    } catch (UnsupportedEncodingException e) {
      print(toHex(utf8(charset)));
      throw e;
    }
    
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  } finally {
    if (loadPage_debug)
      print("loadPage done");
    //vm_generalSubMap("InputStream per thread").remove(currentThread());
    
    vm_generalSubMap("URLConnection per thread").remove(currentThread());
    
    if (in != null) in.close();
  }
}

static String loadPage_guessCharset(String contentType) {
  Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
  String match = m.matches() ? m.group(1) : null;
  if (loadPage_debug)
    print("loadPage: contentType=" + contentType + ", match: " + match);
  /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
  //return or(match, "ISO-8859-1");
  return or(match, "UTF-8");
}

static URLConnection loadPage_openConnection(URL url) {
  URLConnection con = openConnection(url);
  int timeout = toInt(loadPage_forcedTimeout_byThread.get());
  if (timeout == 0) timeout = loadPage_forcedTimeout;
  if (timeout != 0)
    setURLConnectionTimeouts(con, loadPage_forcedTimeout);
  else
    setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
  return con;
}
static String hopeningTag(String tag, Map params) {
  return hopeningTag(tag, mapToParams(params));
}

static String hopeningTag(String tag, Object... params) {
  StringBuilder buf = new StringBuilder();
  buf.append("<" + tag);
  for (int i = 0; i < l(params); i += 2) {
    String name = (String) get(params, i);
    Object val = get(params, i+1);
    if (nempty(name) && val != null) {
      if (val == html_valueLessParam())
        buf.append(" " + name);
      else {
        String s = str(val);
        if (!empty(s))
          buf.append(" " + name + "=" + htmlQuote(s));
      }
    }
  }
  buf.append(">");
  return str(buf);
}
static int iceil(double d) {
  return (int) Math.ceil(d);
}
static boolean even(int i) {
  return (i & 1) == 0;
}

static boolean even(long i) {
  return (i & 1) == 0;
}
static <A> A or(A a, A b) {
  return a != null ? a : b;
}
static long elapsedMS(long time) {
  ping();
  return sysNow()-time;
}
static String containerTag(String tag) { return containerTag(tag, ""); }

static String containerTag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  return openingTag + s + "</" + tag + ">";
}
static int indexOfIC(List<String> a, String b) {
  return indexOfIgnoreCase(a, b);
}

static int indexOfIC(List<String> a, String b, int i) {
  return indexOfIgnoreCase(a, b, i);
}

static int indexOfIC(String a, String b) {
  return indexOfIgnoreCase(a, b);
}
static String hAddToHead(String html, String tag) {
  List<String> tok = htmlTok(html);
  List<String> head = first(findContainerTag(tok, "head"));
  if (head == null) return tag + html;
  head.set(2, addLineBreak(tag) + head.get(2));
  return join(tok);
}
static String hcss(Object contents) {
  return htag("style", contents);
}
static void logQuoted(String logFile, String line) {
  logQuoted(getProgramFile(logFile), line);
}

static void logQuoted(File logFile, String line) {
  appendToFile(logFile, quote(line) + "\n");
}
static boolean structure_showTiming, structure_checkTokenCount;

static String structure(Object o) {
  return structure(o, new structure_Data());
}

static String structure(Object o, structure_Data d) {
  StringWriter sw = new StringWriter();
  d.out = new PrintWriter(sw);
  structure_go(o, d);
  String s = str(sw);
  if (structure_checkTokenCount) {
    print("token count=" + d.n);
    assertEquals("token count", l(javaTokC(s)), d.n);
  }
  return s;
}

static void structure_go(Object o, structure_Data d) {
  structure_1(o, d);
  while (nempty(d.stack))
    popLast(d.stack).run();
}

static void structureToPrintWriter(Object o, PrintWriter out) {
  structure_Data d = new structure_Data();
  d.out = out;
  structure_go(o, d);
}

// leave to false, unless unstructure() breaks
static boolean structure_allowShortening = false;

static class structure_Data {
  PrintWriter out;
  int stringSizeLimit;
  int shareStringsLongerThan = 20;
  boolean noStringSharing = false;

  IdentityHashMap<Object,Integer> seen = new IdentityHashMap();
  //new BitSet refd;
  HashMap<String,Integer> strings = new HashMap();
  HashSet<String> concepts = new HashSet();
  HashMap<Class, List<Field>> fieldsByClass = new HashMap();
  HashMap<Class,Field> persistenceInfo = new HashMap();
  int n; // token count
  List<Runnable> stack = new ArrayList();
  
  // append single token
  structure_Data append(String token) { out.print(token); ++n; return this; }
  structure_Data append(int i) { out.print(i); ++n; return this; }
  
  // append multiple tokens
  structure_Data append(String token, int tokCount) { out.print(token); n += tokCount; return this; }
  
  // extend last token
  structure_Data app(String token) { out.print(token); return this; }
  structure_Data app(int i) { out.print(i); return this; }
}

static void structure_1(final Object o, final structure_Data d) { try {
  if (o == null) { d.append("null"); return; }
  
  Class c = o.getClass();
  boolean concept = false;
  
    concept = o instanceof Concept;
  
  List<Field> lFields = d.fieldsByClass.get(c);
  
  if (lFields == null) {
    // these are never back-referenced (for readability)
    
    if (o instanceof Number) {
      PrintWriter out = d.out;
if (o instanceof Integer) { int i = ((Integer) o).intValue(); out.print(i); d.n += i < 0 ? 2 : 1; return; }
      if (o instanceof Long) { long l = ((Long) o).longValue(); out.print(l); out.print("L"); d.n += l < 0 ? 2 : 1; return; }
      if (o instanceof Short) { short s = ((Short) o).shortValue(); d.append("sh ", 2); out.print(s); d.n += s < 0 ? 2 : 1; return; }
      if (o instanceof Float) { d.append("fl ", 2); quoteToPrintWriter(str(o), out); return; }
      if (o instanceof Double) { d.append("d(", 3); quoteToPrintWriter(str(o), out); d.append(")"); return; }
      if (o instanceof BigInteger) { out.print("bigint("); out.print(o); out.print(")"); d.n += ((BigInteger) o).signum() < 0 ? 5 : 4; return; }
    }
  
    if (o instanceof Boolean) {
      d.append(((Boolean) o).booleanValue() ? "t" : "f"); return;
    }
      
    if (o instanceof Character) {
      d.append(quoteCharacter((Character) o)); return;
    }
      
    if (o instanceof File) {
      d.append("File ").append(quote(((File) o).getPath())); return;
    }
      
    // referencable objects follow
    
    Integer ref = d.seen.get(o);
    if (o instanceof String && ref == null) ref = d.strings.get((String) o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }

    if (!(o instanceof String))
      d.seen.put(o, d.n); // record token number
    else {
      String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
      if (!d.noStringSharing) {
        if (d.shareStringsLongerThan == Integer.MAX_VALUE)
          d.seen.put(o, d.n);
        if (l(s) >= d.shareStringsLongerThan)
          d.strings.put(s, d.n);
      }
      quoteToPrintWriter(s, d.out); d.n++; return;
    }
      
    if (o instanceof Set) {
      /*O set2 = unwrapSynchronizedSet(o);
      if (set2 != o) {
        d.append("sync");
        o = set2;
      } TODO */
      
      if (((Set) o) instanceof TreeSet) {
        d.append(isCISet_gen(((Set) o)) ? "ciset" : "treeset");
        structure_1(new ArrayList(((Set) o)), d);
        return;
      }
      
      // assume it's a HashSet or LinkedHashSet
      d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
      structure_1(new ArrayList(((Set) o)), d);
      return;
    }
    
    String name = c.getName();
    
    if (o instanceof Collection
      && !startsWith(name, "main$")
      /* && neq(name, "main$Concept$RefL") */) {
      
      // it's a list
    
      if (name.equals("java.util.Collections$SynchronizedList")
        || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
        if (unwrapSynchronizedList(((List) o)) instanceof LinkedList)
          d.append("syncLL");
        else
          d.append("sync");
      }
      else if (name.equals("java.util.LinkedList")) d.append("ll");
      d.append("[");
      final int l = d.n;
      final Iterator it = ((Collection) o).iterator();
      d.stack.add(new Runnable() {  public void run() { try { 
        if (!it.hasNext())
          d.append("]");
        else {
          d.stack.add(this);
          if (d.n != l) d.append(", ");
          structure_1(it.next(), d);
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta..."; }});
      return;
    }
    
    if (o instanceof Map && !startsWith(name, "main$")) {
      if (o instanceof LinkedHashMap) d.append("lhm");
      else if (o instanceof HashMap) d.append("hm");
      else if (o instanceof TreeMap)
        d.append(isCIMap_gen(((TreeMap) o)) ? "cimap" : "tm");
      else if (name.equals("java.util.Collections$SynchronizedMap")) d.append("sync");
      else if (name.equals("java.util.Collections$SynchronizedSortedMap")) { d.append("sync tm", 2); }
      
      d.append("{");
      final int l = d.n;
      final Iterator it = ((Map) o).entrySet().iterator();
      
      d.stack.add(new Runnable() {
        boolean v = false;
        Map.Entry e;
        
        public void run() {
          if (v) {
            d.append("=");
            v = false;
            d.stack.add(this);
            structure_1(e.getValue(), d);
          } else {
            if (!it.hasNext())
              d.append("}");
            else {
              e = (Map.Entry) it.next();
              v = true;
              d.stack.add(this);
              if (d.n != l) d.append(", ");
              structure_1(e.getKey(), d);
            }
          }
        }
      });
      return;
    }
    
    if (c.isArray()) {
      if (o instanceof byte[]) {
        d.append("ba ").append(quote(bytesToHex((byte[]) o))); return;
      }
  
      final int n = Array.getLength(o);
  
      if (o instanceof boolean[]) {
        String hex = boolArrayToHex((boolean[]) o);
        int i = l(hex);
        while (i > 0 && hex.charAt(i-1) == '0' && hex.charAt(i-2) == '0') i -= 2;
        d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i))); return;
      }
      
      String atype = "array", sep = ", ";
  
      if (o instanceof int[]) {
        //ret "intarray " + quote(intArrayToHex((int[]) o));
        atype = "intarray";
        sep = " ";
      }
      
      d.append(atype).append("{");
      d.stack.add(new Runnable() {
        int i;
        public void run() {
          if (i >= n)
            d.append("}");
          else {
            d.stack.add(this);
            if (i > 0) d.append(", ");
            structure_1(Array.get(o, i++), d);
          }
        }
      });
      return;
    }
  
    if (o instanceof Class) {
      d.append("class(", 2).append(quote(((Class) o).getName())).append(")"); return;
    }
      
    if (o instanceof Throwable) {
      d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")"); return;
    }
      
    if (o instanceof BitSet) {
      BitSet bs = (BitSet) o;
      d.append("bitset{", 2);
      int l = d.n;
      for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i+1)) {
        if (d.n != l) d.append(", ");
        d.append(i);
      }
      d.append("}"); return;
    }
      
    // Need more cases? This should cover all library classes...
    if (name.startsWith("java.") || name.startsWith("javax.")) {
      d.append("j ").append(quote(str(o))); return; // Hm. this is not unstructure-able
    }
    
    
      
    /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
    
    String dynName = shortDynamicClassName(o);
    if (concept && !d.concepts.contains(dynName)) {
      d.concepts.add(dynName);
      d.append("c ");
    }
    
    // serialize an object with fields.
    // first, collect all fields and values in fv.
    
    TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {
      public int compare(Field a, Field b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    
    Class cc = c;
    while (cc != Object.class) {
      for (Field field : getDeclaredFields_cached(cc)) {
        String fieldName = field.getName();
        if (fieldName.equals("_persistenceInfo"))
          d.persistenceInfo.put(c, field);
        if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
          continue;

        fields.add(field);
        
        // put special cases here...?
      }
        
      cc = cc.getSuperclass();
    }
    
    // TODO: S fieldOrder = getOpt(c, "_fieldOrder");
    lFields = asList(fields);
    
    // Render this$1 first because unstructure needs it for constructor call.
    
    for (int i = 0; i < l(lFields); i++) {
      Field f = lFields.get(i);
      if (f.getName().equals("this$1")) {
        lFields.remove(i);
        lFields.add(0, f);
        break;
      }
    }
  
    
    d.fieldsByClass.put(c, lFields);
  } // << if (lFields == null)
  else { // ref handling for lFields != null
    Integer ref = d.seen.get(o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }
    d.seen.put(o, d.n); // record token number
  }

  Field persistenceInfoField =  (Field) (d.persistenceInfo.get(c));
  Map<String, Object> persistenceInfo = persistenceInfoField == null ? null : (Map) persistenceInfoField.get(o);
  
  LinkedHashMap<String,Object> fv = new LinkedHashMap();
  for (Field f : lFields) {
    Object value;
    try {
      value = f.get(o);
    } catch (Exception e) {
      value = "?";
    }
      
    if (value != null && (persistenceInfo == null
      || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
      fv.put(f.getName(), value);
    
  }
  
  String name = c.getName();
  String shortName = dropPrefix("main$", name);
  if (startsWithDigit(shortName)) shortName = name; // for anonymous classes
    
  // Now we have fields & values. Process fieldValues if it's a DynamicObject.
  
  // omit field "className" if equal to class's name
  if (concept && eq(fv.get("className"), shortName))
    fv.remove("className");
          
  if (o instanceof DynamicObject) {
    fv.putAll((Map) fv.get("fieldValues"));
    fv.remove("fieldValues");
    shortName = shortDynamicClassName(o);
    fv.remove("className");
  }
  
  String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
  
  d.append(shortName);
  
  
  final int l = d.n;
  final Iterator it = fv.entrySet().iterator();
  
  d.stack.add(new Runnable() {  public void run() { try { 
    if (!it.hasNext()) {
      if (d.n != l)
        d.append(")");
    } else {
      Map.Entry e = (Map.Entry) it.next();
      d.append(d.n == l ? "(" : ", ");
      d.append((String) e.getKey()).append("=");
      d.stack.add(this);
      structure_1(e.getValue(), d);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else..."; }});
} catch (Exception __e) { throw rethrow(__e); } }

static File prepareProgramFile(String name) {
  return mkdirsForFile(getProgramFile(name));
}

static File prepareProgramFile(String progID, String name) {
  return mkdirsForFile(getProgramFile(progID, name));
}
static boolean boolOptParam(ThreadLocal<Boolean> tl) {
  return isTrue(optPar(tl));
}

// defaults to false
static boolean boolOptParam(Object[] __, String name) {
  return isTrue(optParam(__, name));
}

static boolean boolOptParam(String name, Object[] __) {
  return boolOptParam(__, name);
}

static boolean boolOptParam(String name, Map __) {
  return isTrue(optPar(name, __));
}
static <B> TreeMap<String, B> asCaseInsensitiveMap(Map<String, B> map) {
  if (isCIMap(map)) return (TreeMap) map;
  TreeMap<String, B> m = ciMap();
  m.putAll(map);
  return m;
}
static String getClientIP_subBot() {
  Object session = call(getMainBot(), "getSession");
  Map headers =  (Map) (call(session, "getHeaders"));
  return getClientIPFromHeaders(headers);
}
static HashMap<String,Class> findClass_cache = new HashMap();

// currently finds only inner classes of class "main"
// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass(String name) {
  synchronized(findClass_cache) {
    if (findClass_cache.containsKey(name))
      return findClass_cache.get(name);
      
    if (!isJavaIdentifier(name)) return null;
    
    Class c;
    try {
      c = Class.forName("main$" + name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_cache.put(name, c);
    return c;
  }
}
static Object nuObject(String className, Object... args) { try {
  return nuObject(classForName(className), args);
} catch (Exception __e) { throw rethrow(__e); } }

// too ambiguous - maybe need to fix some callers
/*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/

static <A> A nuObject(Class<A> c, Object... args) { try {
  if (args.length == 0) return nuObjectWithoutArguments(c); // cached!
  
  Constructor m = nuObject_findConstructor(c, args);
  m.setAccessible(true);
  return (A) m.newInstance(args);
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObject_findConstructor(Class c, Object... args) {
  for (Constructor m : c.getDeclaredConstructors()) {
    if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
      continue;
    return m;
  }
  throw fail("Constructor " + c.getName() + getClasses(args) + " not found"
    + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
}

 static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }
static int csetAll(Concept c, Object... values) {
  return cset(c, values);
}
static <T> void sort(T[] a, Comparator<? super T> c) {
  Arrays.sort(a, c);
}

static <T> void sort(T[] a) {
  Arrays.sort(a);
}

static <T> void sort(List<T> a, Comparator<? super T> c) {
  Collections.sort(a, c);
}

static void sort(List a) {
  Collections.sort(a);
}
static <A> Comparator<A> fieldComparator(final String field) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(getOpt(a, field), getOpt(b, field));
    }
  };
}
static int getInt(List c, int i) {
  return toInt(get(c, i));
}

static int getInt(Map map, Object key) {
  return toInt(mapGet(map, key));
}

static int getInt(Object o, String field) {
  return toInt(getOpt(o, (String) field));
}

static int getInt(String field, Object o) {
  return getInt(o, field);
}
// f: A -> Comparable
static <A> List<A> sortByCalculatedField(Iterable<A> c, final Object f) {
  List<A> l = cloneList(c);
  sort(l, new Comparator<A>() {
    public int compare(A a, A b) {
      return stdcompare(callF(f, a), callF(f, b));
    }
  });
  return l;
}
static boolean sameSnippetID(String a, String b) {
  if (!isSnippetID(a) || !isSnippetID(b)) return false;
  return parseSnippetID(a) == parseSnippetID(b);
}
static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}


static <A, B> Collection<B> values(MultiMap<A, B> mm) {
  return mm == null ? emptyList() : concatLists(values(mm.data));
}



static void preCleanUp(Object c) {
  if (c instanceof Collection) { for (Object o : ((Collection) c)) cleanUp(o); return; }
  callOpt(c, "licensed_off");
  setOpt(c, "ping_anyActions" , true); // so ping notices
  setOpt(c, "cleaningUp_flag" , true);
}
static void innerCleanUp(Object c) {
  // call custom cleanMeUp() and cleanMeUp_*() functions
  
  if (!isFalse(pcallOpt(c, "cleanMeUp")))
    for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
      callOpt(c, name);
    } catch (Throwable e) {
      print("Error cleaning up: " + programID(c));
      _handleException(e);
    }
}

static void innerCleanUp() {
  innerCleanUp(mc());
}
static Object pcallOpt(Object o, String method, Object... args) {
  try { return callOpt(o, method, args); } catch (Throwable __e) { _handleException(__e); }
  return null;
}
static List<Thread> registeredThreads(Object o) {
  Map<Thread, Boolean> map =  (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
  if (map == null) return ll();
  map.size(); // force clean-up
  synchronized(map) { return asList(keys(map)); }
}

static List<Thread> registeredThreads() {
  _registerThread_threads.size(); // force clean-up
  return asList(keys(_registerThread_threads));
}
static <A> String joinWithComma(Collection<A> c) {
  return join(", ", c);
}

static String joinWithComma(String... c) {
  return join(", ", c);
}


static String joinWithComma(Pair p) {
  return p == null ? "" : joinWithComma(str(p.a), str(p.b));
}

static List<String> allToString(Iterable c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}

static List<String> allToString(Object[] c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}
static void interruptThreads(Collection<Thread> threads) {
  for (Thread t : unnull(threads))
    t.interrupt();
}

static void interruptThreads(Class mainClass) {
  interruptThreads(registeredThreads(mainClass));
}
static void retireClassLoader(ClassLoader cl) {
  if (isJavaXClassLoader(cl))
    setOptAll(cl, "retired" , true, "retiredMarker" , new DefunctClassLoader());
}

static void lockOrFail(Lock lock, long timeout) { try {
  ping();
  if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
    String s = "Couldn't acquire lock after " + timeout + " ms.";
    if (lock instanceof ReentrantLock) {
      ReentrantLock l =  (ReentrantLock) lock;
      s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
    }
    throw fail(s);
  }
  ping();
} catch (Exception __e) { throw rethrow(__e); } }
static ReentrantLock fairLock() {
  return new ReentrantLock(true);
}
static double toDouble(Object o) {
  if (o instanceof Number)
    return ((Number) o).doubleValue();
  if (o instanceof BigInteger)
    return ((BigInteger) o).doubleValue();
  if (o == null) return 0.0;
  throw fail(o);
}
static ALQLLine agiBlue_parseQueryLine(String s) {
  List<String> tok = javaTokWithBrackets(s);
  
  // TODO: improve jmatch and use here
  if (lCodeTokens(tok) == 2 && eqGet(tok, 1, "return") && isIdentifier(get(tok, 3)))
    return new ALQLReturn(tok.get(3));
    
  T3<String, String, String> t = agiBlue_parseTriple(tok);
  if (t != null)
    return new ALQLTriple(t);
    
  if (lCodeTokens(tok) == 2 && eqGet(tok, 1, "lock")) {
    t = agiBlue_parseTriple(uncurly(tok.get(3)));
    if (t == null) throw fail("Bad lock statement: " + s);
    return new ALQLLockStatement(t);
  }
    
  if (lCodeTokens(tok) == 2 && eqGet(tok, 1, "page")) {
    String page = uncurly(tok.get(3));
    String method = containsDollarVars(page) ? "flexMatchDollarVarsIC_first" : "eqic";
    return new ALQLPage(page, method);
  }
    
  if (lCodeTokens(tok) == 3 && eqGet(tok, 1, "slice")) {
    String slice = unquote(tok.get(3));
    String contents = uncurly(tok.get(5));
    return new ALQLSlice(slice, agiBlue_parseQueryScript(print("contents", contents)));
  }
  
  throw fail("Can't parse ALQL line: " + s);
}
static List<String> tlftj_honoringBrackets(String s) {
  List<String> tok = javaTokWithBrackets(javaDropComments(s));
  List<String> out = new ArrayList();
  int j = 1;
  for (int i = 2; i+1 < l(tok); i += 2)
    if (containsNewLine(tok.get(i))) {
      addIfNempty(out, joinSubList(tok, j, i));
      j = i+1;
    }
  if (j < l(tok)-1)
    addIfNempty(out, joinSubList(tok, j, l(tok)-1));
  return out;
}
static <A, B, C> T3<A, B, C> triple(A a, B b, C c) {
  return new T3(a, b, c);
}
static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(b);
}

static boolean startsWith(String a, char c) {
  return nemptyString(a) && a.charAt(0) == c;
}


  static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b)) return false;
    m.m = new String[] {substring(a, strL(b))};
    return true;
  }


static boolean startsWith(List a, List b) {
  if (a == null || listL(b) > listL(a)) return false;
  for (int i = 0; i < listL(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}


static boolean isJavaIdentifierAfter(String s, int i) {
  int n = l(s);
  if (i >= n || !Character.isJavaIdentifierStart(s.charAt(i)))
    return false;
  for (i++; i < n; i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}
static <A extends Concept> List<A> findConceptsWhereCI(Class<A> c, Object... params) {
  return findConceptsWhereCI(db_mainConcepts(), c, params);
}

static List<Concept> findConceptsWhereCI(String c, Object... params) {
  return findConceptsWhereCI(db_mainConcepts(), c, params);
}

static <A extends Concept> List<A> findConceptsWhereCI(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  
  // indexed
  if (concepts.ciFieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getCIFieldIndex(c, (String) params[i]);
      if (index != null) {
        List<A> rawList = index.getAll(params[i+1]);
        params = dropEntryFromParams(params, i);
        if (params == null) return rawList;
        List<A> l = new ArrayList();
        for (A x : rawList)
          if (checkConceptFieldsIC(x, params)) l.add(x);
        return l;
      }
    }
    
  // table scan
  return filterConceptsIC(concepts.list(c), params);
}

static List<Concept> findConceptsWhereCI(Concepts concepts, String c, Object... params) {
  return filterConceptsIC(concepts.list(c), params);
}
static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static RuntimeException asRuntimeException(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static <A> A grabValueAndCancel(VF1<VF1<A>> r) {
  Var<A> var = new Var();
  withCancelPoint(new VF1<CancelPoint>() { public void get(CancelPoint cp) { try { 
    callF(r, new VF1<A>() { public void get(A a) { try {  var.set(a); cancelTo(cp) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "var.set(a); cancelTo(cp)"; }});
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callF(r, voidfunc(A a) { var.set(a); cancelTo(cp) });"; }});
  return var.get();
}
static void flexMatchDollarVarsIC_iterate(String pat, String input, VF1<Map<String, String>> onMatch) {
  List<String> vars = new ArrayList();
  String starsPat = dollarVarsToStars(pat, vars);
  flexMatchIC_iterate(starsPat, input, new VF1<Matches>() { public void get(Matches m) { try { 
    Map<String, String> map = matchesToMapUsingVarList_ciMap(m, vars);
    if (map != null) callF(onMatch, map);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "SS map = matchesToMapUsingVarList_ciMap(m, vars);\r\n    if (map != null) callF..."; }});
}
static String optionalCurlyBrace(String s) {
  return isCurlyBraced(s) ? s : curlyBrace(s);
}
static <A extends Concept> A uniqCI(Class<A> c, Object... params) {
  return uniqueConcept(db_mainConcepts(), c, params);
}

static <A extends Concept> A uniqCI(Concepts cc, Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhereCI(cc, c, params);
  if (x == null) {
    x = unlisted(c);
    csetAll(x, params);
    cc.register(x);
  }
  return x;
}
static String structureForUser(Object o) {
  return beautifyStructure(struct_noStringSharing(o));
}
static <A, B> List<A> cloneKeys(Map<A, B> map) {
  return cloneList(keys(map));
}
static <A extends Concept> List<A> findConceptsWhere(Class<A> c, Object... params) {
  return findConceptsWhere(db_mainConcepts(), c, params);
}

static List<Concept> findConceptsWhere(String c, Object... params) {
  return findConceptsWhere(db_mainConcepts(), c, params);
}

static <A extends Concept> List<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  
  // indexed
  if (concepts.fieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
      if (index != null) {
        List<A> rawList = index.getAll(params[i+1]);
        params = dropEntryFromParams(params, i);
        if (params == null) return rawList;
        List<A> l = new ArrayList();
        for (A x : rawList)
          if (checkConceptFields(x, params)) l.add(x);
        return l;
      }
    }
    
  // table scan
  return filterConcepts(concepts.list(c), params);
}

static List<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
  return filterConcepts(concepts.list(c), params);
}
static <A> void removeAllBut(Set<A> a, Collection<A> b) {
  if (a != null) for (Iterator<A> it = a.iterator(); it.hasNext(); )
    if (!contains(b, it.next()))
      it.remove();
}

static <A, B> void removeAllBut(Map<A, B> a, Collection<A> b) {
  if (a != null) removeAllBut(a.keySet(), b);
}
static CloseableIterableIterator<String> linesFromFile(File f) { try {
  if (!f.exists()) return emptyCloseableIterableIterator();
  if (ewic(f.getName(), ".gz"))
    return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
  return linesFromReader(utf8bufferedReader(f));
} catch (Exception __e) { throw rethrow(__e); } }
static String unquote(String s) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();
    }
  }
    
  return s; // not quoted - return original
}
static <A> A optCast(Class<A> c, Object o) {
  return isInstance(c, o) ? (A) o : null;
}
static Object safeUnstructure(String s) {
  return unstructure(s, true);
}
static <A> A second(List<A> l) {
  return get(l, 1);
}

static <A> A second(Iterable<A> l) {
  if (l == null) return null;
  Iterator<A> it = iterator(l);
  if (!it.hasNext()) return null;
  it.next();
  return it.hasNext() ? it.next() : null;
}

static <A> A second(A[] bla) {
  return bla == null || bla.length <= 1 ? null : bla[1];
}


static <A, B> B second(Pair<A, B> p) {
  return p == null ? null : p.b;
}



static <A, B, C> B second(T3<A, B, C> t) {
  return t == null ? null : t.b;
}



static <A> A second(Producer<A> p) {
  if (p == null) return null;
  if (p.next() == null) return null;
  return p.next();
}



//static final Map<Class, HashMap<S, Field>> getOpt_cache = newDangerousWeakHashMap(f getOpt_special_init);

static class getOpt_Map extends WeakHashMap {
  getOpt_Map() {
    if (getOpt_special == null) getOpt_special = new HashMap();
    clear();
  }
  
  public void clear() {
    super.clear();
    //print("getOpt clear");
    put(Class.class, getOpt_special);
    put(String.class, getOpt_special);
  }
}

static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));
//static final Map<Class, HashMap<S, Field>> getOpt_cache = _registerWeakMap(synchroMap(new getOpt_Map));
static HashMap getOpt_special; // just a marker

/*static void getOpt_special_init(Map map) {
  map.put(Class.class, getOpt_special);
  map.put(S.class, getOpt_special);
}*/

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
    if (o instanceof DynamicObject)
      return ((DynamicObject) o).fieldValues.get(field);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    if (!reflection_classesNotToScan().contains(c.getName())) {
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) {
          f.setAccessible(true);
          String name = f.getName();
          if (!map.containsKey(name))
            map.put(name, f);
        }
        _c = _c.getSuperclass();
      } while (_c != null);
    }
  }
  if (getOpt_cache != null) getOpt_cache.put(c, map);
  return map;
}
static Map<Thread, Boolean> _registerThread_threads;
static Object _onRegisterThread; // voidfunc(Thread)

static Thread _registerThread(Thread t) {
  if (_registerThread_threads == null)
    _registerThread_threads = newWeakHashMap();
  _registerThread_threads.put(t, true);
  vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
  callF(_onRegisterThread, t);
  return t;
}

static void _registerThread() { _registerThread(Thread.currentThread()); }
static String getStackTrace2(Throwable e) {
  return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ",
    hideCredentials(str(innerException2(e)))) + "\n");
}
static GlobalID asGlobalID(String id) {
  return id == null ? null : new GlobalID(id);
}
  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }

static boolean md5OfFile_verbose = false;

static String md5OfFile(String path) {
  return md5OfFile(newFile(path));
}

static String md5OfFile(File f) { try {
  if (!f.exists()) return "-";
  
  if (md5OfFile_verbose)
    print("Getting MD5 of " + f);
  
  MessageDigest md5 = MessageDigest.getInstance("MD5");
   FileInputStream in = new FileInputStream(f); try {

  byte buf[] = new byte[65536];
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    md5.update(buf, 0, l);
  }
  
  return bytesToHex(md5.digest());
} finally { _close(in); }} catch (Exception __e) { throw rethrow(__e); } }
static String makeRandomID(int length) {
  return makeRandomID(length, defaultRandomGenerator());
}

static String makeRandomID(int length, Random random) {
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}
static Comparator<String> caseInsensitiveComparator() {
  
  
  return betterCIComparator();
  
}
static Class javax() {
  return getJavaX();
}
static <A, B> Map<A, B> newWeakHashMap() {
  return _registerWeakMap(synchroMap(new WeakHashMap()));
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
static void failIfUnlicensed() {
  assertTrue("license off", licensed());
}
static Thread currentThread() {
  return Thread.currentThread();
}
static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}


static <A> A pcallF(F0<A> f) { try {
  return f == null ? null : f.get();
} catch (Throwable __e) { return null; } }



static <A, B> B pcallF(F1<A, B> f, A a) { try {
  return f == null ? null : f.get(a);
} catch (Throwable __e) { return null; } }



static <A> void pcallF(VF1<A> f, A a) {
  try {
    if (f != null) f.get(a);
  } catch (Throwable __e) { _handleException(__e); }
}

static String singleFieldName(Class c) {
  Set<String> l = listFields(c);
  if (l(l) != 1)
    throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
  return first(l);
}
static void setOpt_raw(Object o, String field, Object value) { try {
  if (o == null) return;
  if (o instanceof Class) setOpt_raw((Class) o, field, value);
  else {
    Field f = setOpt_raw_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      smartSet(f, o, value);
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt_raw(Class c, String field, Object value) { try {
  if (c == null) return;
  Field f = setOpt_raw_findStaticField(c, field);
  if (f != null) {
    f.setAccessible(true);
    smartSet(f, null, value);
  }
} catch (Exception __e) { throw rethrow(__e); } }
  
static Field setOpt_raw_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field setOpt_raw_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static void smartSet(Field f, Object o, Object value) throws Exception {
  try {
    f.set(o, value);
  } catch (Exception e) {
    Class type = f.getType();
    
    // take care of common case (long to int)
    if (type == int.class && value instanceof Long)
      value = ((Long) value).intValue();
    
    if (type == LinkedHashMap.class && value instanceof Map)
      { f.set(o, asLinkedHashMap((Map) value)); return; }
    
    
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {}
    
    throw e;
  }
}
static Method fastIntern_method;

static String fastIntern(String s) { try {
  if (s == null) return null;
  if (fastIntern_method == null) {
    fastIntern_method = findMethodNamed(javax(), "internPerProgram");
    if (fastIntern_method == null) upgradeJavaXAndRestart();
  }
    
  return (String) fastIntern_method.invoke(null, s);
} catch (Exception __e) { throw rethrow(__e); } }
static String assertIsIdentifier(String s) {
  if (!isIdentifier(s))
    throw fail("Not an identifier: " + quote(s));
  return s;
}

static String assertIsIdentifier(String msg, String s) {
  if (!isIdentifier(s))
    throw fail(msg + " - Not an identifier: " + quote(s));
  return s;
}
static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Class<A> c, String field) {
  return getConceptFieldCIIndex(db_mainConcepts(), c, field);
}

static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Concepts concepts, Class<A> c, String field) {
  return (ConceptFieldIndexCI) concepts.getCIFieldIndex(c, field);
}
static boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
  return isConceptFieldIndexed(db_mainConcepts(), c, field);
}

static boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
  return concepts.getFieldIndex(c, field) != null;
}
static String _userHome;
static String userHome() {
  if (_userHome == null)
    return actualUserHome();
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}
static File newFile(File base, String... names) {
  for (String name : names) base = new File(base, name);
  return base;
}

static File newFile(String name) {
  return name == null ? null : new File(name);
}
static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}
static volatile String caseID_caseID;

static String caseID() { return caseID_caseID; }

static void caseID(String id) {
  caseID_caseID = id;
}
static boolean fileExists(String path) {
  return path != null && new File(path).exists();
}

static boolean fileExists(File f) {
  return f != null && f.exists();
}
static boolean isDirectory(File f) {
  return f != null && f.isDirectory();
}

static boolean isDirectory(String path) {
  return path != null && isDirectory(newFile(path));
}
static File[] listFiles(File dir) {
  File[] files = dir.listFiles();
  return files == null ? new File[0] : files;
}

static File[] listFiles(String dir) {
  return listFiles(new File(dir));
}

static boolean isSymLink(File f) {
  
  
  
  return f != null && Files.isSymbolicLink(toPath(f));
  
}


static Path fileToPath(File f) {
  return toPath(f);
}
static boolean isFile(File f) {
  return f != null && f.isFile();
}

static boolean isFile(String path) {
  return isFile(newFile(path));
}
public static void copyFile(File src, File dest) { try {
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static File mkdirs(File dir) {
  if (dir != null)
    dir.mkdirs();
  return dir;
}

static boolean deleteFile(File file) {
  return file != null && file.delete();
}
static List<File> listFilesNotDirs(String dir) {
  return listFilesOnly(dir);
}

static List<File> listFilesNotDirs(File... dirs) {
  return listFilesOnly(dirs);
}
static int matcherInt(Matcher m, int i) {
  return parseInt(m.group(i));
}
// month = 1 to 12
static long timestampFromYMDH(int y, int m, int d, int h) {
  return new GregorianCalendar(y, m-1, d, h, 0).getTimeInMillis();
}
static <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
  sort(l, mapComparator(map));
  return l;
}
static String n(long l, String name) {
  return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
}

static String n(Collection l, String name) {
  return n(l(l), name);
}

static String n(Map m, String name) {
  return n(l(m), name);
}

static String n(Object[] a, String name) {
  return n(l(a), name);
}


  static String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

// age = age in days, lastAge = age of last (more recent) file kept (also in days)
static boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
  if (age <= 0.5) return true; // keep all backups of last 12 hours
  if (age <= 7 && age >= lastAge+1) return true; // keep every daily backup from this week
  if (age >= lastAge+7) return true; // after that, keep weekly backups
  return false;
}
static File javaxSecretDir_dir; // can be set to work on different base dir

static File javaxSecretDir() {
  return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
}

static File javaxSecretDir(String sub) {
  return newFile(javaxSecretDir(), sub);
}
static <A, B> Map<A, B> newDangerousWeakHashMap() {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
}

// initFunction: voidfunc(Map) - is called initially, and after clearing the map
static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
}
static HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  if (callMC_cache == null) callMC_cache = new HashMap(); // initializer time workaround
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) try {
    return invokeMethod(me, null, args);
  } catch (IllegalArgumentException e) {
    throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
  }

  List<Method> m;
  synchronized(callMC_cache) {
    m = callMC_cache.get(method);
  }
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    try {
      return invokeMethod(me, null, args);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
    }
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return invokeMethod(me, null, args);
  }
  throw fail("No method called " + method + " with matching arguments found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static void callMC_makeCache() {
  synchronized(callMC_cache) {
    callMC_cache.clear();
    Class _c = (Class) mc(), c = _c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods())
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
      c = c.getSuperclass();
    }
  }
}
static Object invokeMethod(Method m, Object o, Object... args) { try {
  try {
    return m.invoke(o, args);
  } catch (InvocationTargetException e) {
    throw rethrow(getExceptionCause(e));
  } catch (IllegalArgumentException e) {
    throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      print("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++) {
    Object arg = args[i];
    if (!(arg == null ? !types[i].isPrimitive()
      : isInstanceX(types[i], arg))) {
      if (debug)
        print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
      return false;
    }
  }
  return true;
}
static void rotateStringBuffer(StringBuffer buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static void rotateStringBuilder(StringBuilder buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static Object sleepQuietly_monitor = new Object();

static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(sleepQuietly_monitor) { sleepQuietly_monitor.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean checkConceptFieldsIC(Concept x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (!eqicOrEq(cget(x, (String) data[i]), deref(data[i+1])))
      return false;
  return true;
}
static boolean eqicOrEq(Object a, Object b) {
  return a instanceof String && b instanceof String ? eqic((String) a, (String) b) : eq(a, b);
}
static boolean regexpICMatches(String pat, String s) {
  return regexpIC(pat, s).matches();
}

static boolean regexpICMatches(Pattern pat, String s) {
  return pat.matcher(s).matches();
}
static boolean domainIsUnder(String domain, String mainDomain) {
  return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
}
static Map<String, String> decodeHQuery(String query) {
  Map<String,String> map = new HashMap();
  for (String s : splitAtAmpersand(query)) {
    int i = s.indexOf('=');
    if (i >= 0)
      map.put(urldecode(s.substring(0, i)), urldecode(s.substring(i+1)));
  }
  return map;
}
static String getQueryFromURL(String url) {
  return substring(url, smartIndexOf(url, "?")+1);
}
static int strL(String s) {
  return s == null ? 0 : s.length();
}
static String dropFrom(String s, String x) {
  if (s == null) return null;
  int i = s.indexOf(x);
  if (i < 0) return s;
  return substring(s, 0, i);
}
static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
  
  
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  
}
static Matcher regexp(String pat, String s) {
  return regexp(compileRegexp(pat), unnull(s));
}

static Matcher regexp(Pattern pat, String s) {
  return pat.matcher(unnull(s));
}

static Pattern regexp(String pat) {
  return compileRegexp(pat);
}
static Object callOpt_withVarargs(Object o, String method, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findMethod(method, args);
    if (me == null) {
      // TODO: varargs
      return null;
    }
    if ((me.getModifiers() & Modifier.STATIC) == 0)
      return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(method, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean allLowerCaseCharacters(String s) {
  for (int i = 0; i < l(s); i++)
    if (Character.getType(s.charAt(i)) != Character.LOWERCASE_LETTER) return false;
  return true;
}
static boolean endsWithLetter(String s) {
  return nempty(s) && isLetter(last(s));
}
static String unpackAGIDomain(String s) {
  return isAGIDomain(s) ? dropSuffixIC(".agi.blue", s) : null;
}
static boolean isCISet(Iterable<String> l) {
  return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
}
static TreeSet<String> caseInsensitiveSet() {
  return caseInsensitiveSet_treeSet();
}

static TreeSet<String> caseInsensitiveSet(Collection<String> c) {
  return caseInsensitiveSet_treeSet(c);
}
static List<String> splitAtAmpersand(String s) {
  return s == null ? emptyList() : asList(s.split("&"));
}
static String urldecode(String x) {
  try {
    return URLDecoder.decode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}
static String addSlash(String s) {
  return empty(s) || s.endsWith("/") ? s : s + "/";
}
static String hMakeComputerID() {
  return hjavascript("\r\n  function makeComputerID() {\r\n    var text = \"\";\r\n    var possible = \"abcdefghijklmnopqrstuvwxyz\";\r\n\r\n    for (var i = 0; i < 12; i++)\r\n      text += possible.charAt(Math.floor(Math.random() * possible.length));\r\n    return text;\r\n  }\r\n  \r\n  var computerID = localStorage.getItem('computer-id');\r\n  if (computerID == null || computerID.length != 12) {\r\n    computerID = makeComputerID();\r\n    localStorage.setItem('computer-id', computerID);\r\n  }\r\n  ");
}
static String hreconnectingWebSockets() {
  return hjavascript_src_snippet("#1013374" /*#1013375*/);
}
static String hjavascript(String script) {
  return tag("script", script, "type", "text/javascript");
}
static String nodes_pingCmd() {
  return "\r\n    ws.send((working ? 'working' : 'idle') + '; cores=' + navigator.hardwareConcurrency + \"; id=\" + window.computerID\r\n      + (window.benchResult != null ? \"; bench=\" + window.benchResult : \"\") \r\n      + \"; b=\" + navigator.userAgent);\r\n  ";
}
static int subBot_currentPort() {
  return toInt(getOpt(subBot_httpd(), "myPort"));
}
static boolean subBot_isHttps() {
  Object httpd = subBot_httpd();
  return eqOneOf(httpd,
    getOpt(mainBot(), "serveHttps_server"),
    getOpt(mainBot(), "serveHttpsWithWebsockets_server"))
    || contains((Collection) getOpt(mainBot(), "serveHttpsWithWebsockets_multiplePorts_servers"), httpd);
}
static String snippetImageURL(String snippetID) {
  return snippetImageURL(snippetID, "png");
}

static String snippetImageURL(String snippetID, String contentType) {
  if (isURL(snippetID)) return snippetID;
  long id = parseSnippetID(snippetID);
  String url;
  if (id == 1000010 || id == 1000012)
    url = "http://tinybrain.de:8080/tb/show-blobimage.php?id=" + id;
  else if (isImageServerSnippet(id))
    url = imageServerLink(id);
  else
    //url = "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id + "&contentType=image/" + contentType;
    url = "https://www.botcompany.de:8443/img/" + id;
  return url;
}
static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}
static String formatWithThousands(long l) {
  return formatWithThousandsSeparator(l);
}
static double fraction(double d) {
  return d % 1;
}
static String n_fancy2(long l, String singular, String plural) {
  return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
}

static String n_fancy2(Collection l, String singular, String plural) {
  return n_fancy2(l(l), singular, plural);
}

static String n_fancy2(Map m, String singular, String plural) {
  return n_fancy2(l(m), singular, plural);
}

static String n_fancy2(Object[] a, String singular, String plural) {
  return n_fancy2(l(a), singular, plural);
}


  static String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

static String className(Object o) {
  return getClassName(o);
}
static String stringOptPar(Object[] params, String name) {
  return (String) optPar(params, name);
}
static String unicodeFromCodePoint(int codePoint) {
  return codePointToString(codePoint);
}
static String charToString(char c) {
  return String.valueOf(c);
}

static String charToString(int c) {
  return String.valueOf((char) c);
}
static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt((String) o);
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}
static String[] drop(int n, String[] a) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}

static Object[] drop(int n, Object[] a) {
  n = Math.min(n, a.length);
  Object[] b = new Object[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}
static <A> ArrayList<A> toList(A[] a) { return asList(a); }
static ArrayList<Integer> toList(int[] a) { return asList(a); }
static <A> ArrayList<A> toList(Set<A> s) { return asList(s); }
static <A> ArrayList<A> toList(Iterable<A> s) { return asList(s); }
static Object[] changeParam(Object[] params, String name, Object value) {
  if (eq(optPar(params, name), value)) return params;
  Map map = paramsToOrderedMap(params);
  map.put(name, value);
  return mapToParams(map);
}
static Object html_valueLessParam_cache;
static Object html_valueLessParam() { if (html_valueLessParam_cache == null) html_valueLessParam_cache = html_valueLessParam_load(); return html_valueLessParam_cache; }

static Object html_valueLessParam_load() {
  return new Object();
}
static Object serveText(Object s) {
  
  return call(getMainBot(), "serveByteArray", toUtf8(str(s)), "text/plain; charset=utf8");
}
static String jsonEncode_shallowLineBreaks(Object o) {
  return jsonEncode_breakAtLevel1(o);
}



static void jsonEncode_shallowLineBreaks(Object o, StringBuilder buf, int level) {
  jsonEncode_breakAtLevel1(o, buf, level);
}
static boolean endsWith(String a, String b) {
  return a != null && a.endsWith(b);
}

static boolean endsWith(String a, char c) {
  return nempty(a) && lastChar(a) == c;
}


  static boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b)) return false;
    m.m = new String[] {dropLast(l(b), a)};
    return true;
  }


static boolean isString(Object o) {
  return o instanceof String;
}
static boolean isIdentifier(String s) {
  return isJavaIdentifier(s);
}
static Object dm_getService(String serviceName) {
  return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
}
static boolean isStringOrIntOrLong(Object o) {
  return o instanceof String || o instanceof Integer || o instanceof Long;
}
static Object dm_callOS(String functionName, Object... args) {
  return call(dm_os(), functionName, args);
}
static Object dm_resolveModule(Object moduleOrStem) {
  return dm_callOS("resolveModule", moduleOrStem);
}
static final Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

static Object callOpt_cached(Object o, String methodName, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    // TODO: (super-rare) case where method exists static and non-static
    // with different args
    
    Method me = cache.findMethod(methodName, args);
    if (me == null || (me.getModifiers() & Modifier.STATIC) == 0) return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(methodName, args);
    if (me == null) return null;
    return invokeMethod(me, o, args);
  }
} catch (Exception __e) { throw rethrow(__e); } }

static _MethodCache callOpt_getCache(Class c) {
  synchronized(callOpt_cache) {
    _MethodCache cache = callOpt_cache.get(c);
    if (cache == null)
      callOpt_cache.put(c, cache = new _MethodCache(c));
    return cache;
  }
}
static boolean isStaticMethod(Method m) {
  return methodIsStatic(m);
}
static Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  int n = types.length-1, nArgs = args.length;
  if (nArgs < n) return null;
  for (int i = 0; i < n; i++)
    if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
  Class varArgType = types[n].getComponentType();
  for (int i = n; i < nArgs; i++)
    if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
  Object[] newArgs = new Object[n+1];
  arraycopy(args, 0, newArgs, 0, n);
  Object[] varArgs = arrayOfType(varArgType, nArgs-n);
  arraycopy(args, n, varArgs, 0, nArgs-n);
  newArgs[n] = varArgs;
  return newArgs;
}
static List<String> classNames(Collection l) {
  return getClassNames(l);
}

static List<String> classNames(Object[] l) {
  return getClassNames(Arrays.asList(l));
}
static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}
static Class getMainClass() {
  return mc();
}

static Class getMainClass(Object o) { try {
  if (o == null) return null;
  if (o instanceof Class && eq(((Class) o).getName(), "x30")) return (Class) o;
  return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
} catch (Exception __e) { throw rethrow(__e); } }
static Object[] assertEvenLength(Object[] a) {
  assertTrue(even(l(a)));
  return a;
}
static LinkedHashMap paramsToOrderedMap(Object... params) {
  return asLinkedHashMap(paramsToMap(params));
}
static Object[] mapToParams(Map map) {
  return mapToObjectArray(map);
}
// works on lists and strings and null

static int indexOfIgnoreCase(List<String> a, String b) {
  return indexOfIgnoreCase(a, b, 0);
}

static int indexOfIgnoreCase(List<String> a, String b, int i) {
  int n = a == null ? 0 : a.size();
  for (; i < n; i++)
    if (eqic(a.get(i), b)) return i;
  return -1;
}

static int indexOfIgnoreCase(String a, String b) {
  return indexOfIgnoreCase_manual(a, b);
  /*Matcher m = Pattern.compile(b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher(a);
  if (m.find()) return m.start(); else ret -1;*/
}
static String makePostData(Map<Object, Object> map) {
  StringBuilder buf = new StringBuilder();
  for (Map.Entry<Object, Object> e : map.entrySet()) {
    String key =  (String) (e.getKey());
    Object val = e.getValue();
    if (val != null) {
      String value = str(val);
      if (nempty(buf)) buf.append("&");
      buf.append(urlencode(key)).append("=").append(urlencode(/*escapeMultichars*/(value)));
    }
  }
  return str(buf);
}

static String makePostData(Object... params) {
  StringBuilder buf = new StringBuilder();
  int n = l(params);
  for (int i = 0; i+1 < n; i += 2) {
    String key =  (String) (params[i]);
    Object val = params[i+1];
    if (val != null) {
      String value = str(val);
      if (nempty(buf)) buf.append("&");
      buf.append(urlencode(key)).append("=").append(urlencode(/*escapeMultichars*/(value)));
    }
  }
  return str(buf);

}

static BigInteger bigint(String s) {
  return new BigInteger(s);
}

static BigInteger bigint(long l) {
  return BigInteger.valueOf(l);
}
static volatile boolean licensed_yes = true;

static boolean licensed() {
  if (!licensed_yes) return false;
  ping_okInCleanUp();
  return true;
}

static void licensed_off() {
  licensed_yes = false;
}
static Set vm_generalIdentityHashSet(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Set set =  (Set) (vm_generalMap_get(name));
    if (set == null)
      vm_generalMap_put(name, set = syncIdentityHashSet());
    return set;
  }
}

static Map vm_generalHashMap(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Map m =  (Map) (vm_generalMap_get(name));
    if (m == null)
      vm_generalMap_put(name, m = syncHashMap());
    return m;
  }
}

static <A> A listGet(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}
static <A, B> Map<A, B> syncMRUCache(int size) {
  return synchroMap(new MRUCache(size));
}
static RuntimeException wrapPatternSyntaxException(PatternSyntaxException e) {
  if (e == null) return null;
  String pat = e.getPattern();
  int i = e.getIndex();
  return new RuntimeException("Regular expression error between " + multiLineQuoteWithSpaces(substring(pat, 0, i)) + " and " + multiLineQuoteWithSpaces(substring(pat, i)) + " - " + e.getMessage());
}
static String trimLastLine(String s) {
  return trim(lastLine(s));
}
static <A> A liftLast(List<A> l) {
  if (l.isEmpty()) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}
static String getStackTrace(Throwable throwable) {
  lastException(throwable);
  return getStackTrace_noRecord(throwable);
}

static String getStackTrace_noRecord(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return hideCredentials(writer.toString());
}

static String getStackTrace() {
  return getStackTrace_noRecord(new Throwable());
}
static List<String> jsonTok(String s) {
  List<String> tok = new ArrayList();
  int l = l(s);
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i); // cc is not needed in rest of loop body

    // scan for non-whitespace (json strings, "null" identifier, numbers. everything else automatically becomes a one character token.)
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isLetter(c))
      do ++j; while (j < l && Character.isLetter(s.charAt(j)));
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}

static double parseDouble(String s) {
  return Double.parseDouble(s);
}
static long parseLong(String s) {
  if (s == null) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}
public static <A> String join(String glue, Iterable<A> strings) {
  if (strings == null) return "";
  if (strings instanceof Collection) {
    if (((Collection) strings).size() == 1) return str(first(((Collection) strings)));
  }
  StringBuilder buf = new StringBuilder();
  Iterator<A> i = strings.iterator();
  if (i.hasNext()) {
    buf.append(i.next());
    while (i.hasNext())
      buf.append(glue).append(i.next());
  }
  return buf.toString();
}

public static String join(String glue, String... strings) {
  return join(glue, Arrays.asList(strings));
}

static <A> String join(Iterable<A> strings) {
  return join("", strings);
}

static <A> String join(Iterable<A> strings, String glue) {
  return join(glue, strings);
}

public static String join(String[] strings) {
  return join("", strings);
}


static String join(String glue, Pair p) {
  return p == null ? "" : str(p.a) + glue + str(p.b);
}

static String programIDWithCase() {
  return nempty(caseID())
    ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID())
    : programID();
}
static Object defaultDefaultClassFinder() {
  return new F1<String, Class>() { Class get(String name) { try { 
    Class c = findClass_fullName(name);
    if (c != null) return c;
    if (startsWith(name, "loadableUtils.utils$"))
      return findClass_fullName("main" + substring(name, 19));
    return null;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Class c = findClass_fullName(name);\r\n    if (c != null) ret c;\r\n    if (start..."; }};
}
static boolean checkConceptFields(Concept x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(cget(x, (String) data[i]), deref(data[i+1])))
      return false;
  return true;
}
static Set similarEmptySet(Collection m) {
  if (m instanceof TreeSet) return new TreeSet(((TreeSet) m).comparator());
  if (m instanceof LinkedHashSet) return new LinkedHashSet();
  
  return new HashSet();
}
static File getProgramDir() {
  return programDir();
}

static File getProgramDir(String snippetID) {
  return programDir(snippetID);
}
static Throwable getException(Runnable r) {
  try {
    callF(r);
    return null;
  } catch (Throwable e) {
    return e;
  }
}
static double toSeconds(long ms) {
  return ms/1000.0;
}

static String toSeconds(long ms, int digits) {
  return formatDouble(toSeconds(ms), digits);
}
static <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(map.get(a), map.get(b));
    }
  };
}
// TODO: process CDATA, scripts

static List<String> htmlcoarsetok(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c;
    
    // scan for non-tags
    while (j < l) {
      if (s.charAt(j) != '<')
        // regular character
        ++j;
      else if (s.substring(j, Math.min(j+4, l)).equals("<!--")) {
        // HTML comment
        j = j+4;
        do ++j; while (j < l && !s.substring(j, Math.min(j+3, l)).equals("-->"));
        j = Math.min(j+3, l);
      } else
        // it's a tag
        break;
    }
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);

    // scan for tags
    if (c == '<') {
      ++j;
      
      while (j < l && s.charAt(j) != '>') ++j; // TODO: strings?
      if (j < l) ++j;
    }

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}
  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }
static File localSnippetFile(long snippetID) {
  return localSnippetsDir(snippetID + ".text");
}

static File localSnippetFile(String snippetID) {
  return localSnippetFile(parseSnippetID(snippetID));
}
static <A> A proxy(Class<A> intrface, final Object target) {
  if (target == null) return null;
  if (isInstance(intrface, target)) return (A) target;
  return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(),
   new Class[] { intrface },
   new InvocationHandler() {
     public Object invoke(Object proxy, Method method, Object[] args) {
       return call(target, method.getName(), unnull(args));
     }
   });
}

static <A> A proxy(Object target, Class<A> intrface) {
  return proxy(intrface, target);
}
static Object vm_generalMap_get(Object key) {
  return vm_generalMap().get(key);
}
static String standardCredentialsUser() {
  return trim(loadTextFile(
    oneOfTheFiles(
      javaxSecretDir("tinybrain-username"),
      userDir(".tinybrain/username"))));
}
static String standardCredentialsPass() {
  return trim(loadTextFile(
    oneOfTheFiles(
      javaxSecretDir("tinybrain-userpass"),
      userDir(".tinybrain/userpass"))));
}
static ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

static void checkFileNotTooBigToRead(File f) {
  callF(checkFileNotTooBigToRead_tl.get(), f);
}
static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

static class CriticalAction {
  String description;
  
  CriticalAction() {}
  CriticalAction(String description) {
  this.description = description;}
  
  void done() {
    beginCriticalAction_inFlight.remove(this);
  }
}

static CriticalAction beginCriticalAction(String description) {
  ping();
  CriticalAction c = new CriticalAction(description);
  beginCriticalAction_inFlight.add(c);
  return c;
}

static void cleanMeUp_beginCriticalAction() {
  int n = 0;
  while (nempty(beginCriticalAction_inFlight)) {
    int m = l(beginCriticalAction_inFlight);
    if (m != n) {
      n = m;
      try {
        print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
      } catch (Throwable __e) { _handleException(__e); }
    }
    sleepInCleanUp(10);
  }
}
public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) { // is null if file is in current dir
    dir.mkdirs();
    if (!dir.isDirectory())
      if (dir.isFile()) throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
      else throw fail("Unknown IO exception during mkdirs of " + f2s(file));
  }
  return file;
}

public static String mkdirsForFile(String path) {
  mkdirsForFile(new File(path));
  return path;
}
static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
  return newFileOutputStream(path.getPath(), append);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  mkdirsForFile(path);
  FileOutputStream f = new FileOutputStream(path, append);
  
  _registerIO(f, path, true);
  
  return f;
}
static File javaxCachesDir_dir; // can be set to work on different base dir

static File javaxCachesDir() {
  return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
}

static File javaxCachesDir(String sub) {
  return newFile(javaxCachesDir(), sub);
}




static volatile boolean disableCertificateValidation_attempted = false;

static void disableCertificateValidation() { try {
  if (disableCertificateValidation_attempted) return;
  disableCertificateValidation_attempted = true;
  
  try {
    // Create a trust manager that does not validate certificate chains
    TrustManager[] trustAllCerts = new TrustManager[] { 
      new X509TrustManager() {
        public X509Certificate[] getAcceptedIssuers() { 
          return new X509Certificate[0]; 
        }
        public void checkClientTrusted(X509Certificate[] certs, String authType) {}
        public void checkServerTrusted(X509Certificate[] certs, String authType) {}
    }};
  
    // Ignore differences between given hostname and certificate hostname
    HostnameVerifier hv = new HostnameVerifier() {
      public boolean verify(String hostname, SSLSession session) { return true; }
    };
  
    // Install the all-trusting trust manager
    SSLContext sc = SSLContext.getInstance("SSL");
    sc.init(null, trustAllCerts, new SecureRandom());
    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    HttpsURLConnection.setDefaultHostnameVerifier(hv);
  } catch (Throwable __e) { _handleException(__e); }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean networkAllowanceTest(String url) {
  
  
  return isAllowed("networkAllowanceTest", url);
  
}
static final boolean loadPageThroughProxy_enabled = false;

static String loadPageThroughProxy(String url) {
  return null;
}
static void sleepSeconds(double s) {
  if (s > 0) sleep(round(s*1000));
}
static <A> A printWithTime(A a) {
  print(hmsWithColons() + ": " + a);
  return a;
}
static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
  A a = tl.get();
  tl.set(null);
  return a;
}
static void setHeaders(URLConnection con) throws IOException {
  
  String computerID = getComputerID_quick();
  if (computerID != null) try {
    con.setRequestProperty("X-ComputerID", computerID);
    con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
  } catch (Throwable e) {
    //printShortException(e);
  }
  
}
static Map vm_generalSubMap(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Map map =  (Map) (vm_generalMap_get(name));
    if (map == null)
      vm_generalMap_put(name, map = synchroMap());
    return map;
  }
}

static InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
  UnknownHostException lastException = null;
  for (int _repeat_1053 = 0; _repeat_1053 < 2; _repeat_1053++)  {
    try {
      if (con instanceof HttpURLConnection)
        if (((HttpURLConnection) con).getResponseCode() == 500)
          throw new IOException(joinNemptiesWithColonSpace("Server code 500", tryToReadErrorStreamFromURLConnection(((HttpURLConnection) con))));
      return con.getInputStream();
    } catch (UnknownHostException e) {
      lastException = e;
      print("Retrying because of: " + e);
      continue;
    }
  }
  throw lastException;
}
static GZIPInputStream newGZIPInputStream(File f) {
  return gzInputStream(f);
}

static GZIPInputStream newGZIPInputStream(InputStream in) {
  return gzInputStream(in);
}
static String toHex(byte[] bytes) {
  return bytesToHex(bytes);
}

static String toHex(byte[] bytes, int ofs, int len) {
  return bytesToHex(bytes, ofs, len);
}

static byte[] utf8(String s) {
  return toUtf8(s);
}
static Matcher regexpMatcher(String pat, String s) {
  return compileRegexp(pat).matcher(unnull(s));
}
static URLConnection openConnection(String url) { try {
  return openConnection(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static URLConnection openConnection(URL url) { try {
  ping();
  
  callOpt(javax(), "recordOpenURLConnection", str(url));
  
  return url.openConnection();
} catch (Exception __e) { throw rethrow(__e); } }
static URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
  con.setConnectTimeout(toInt(timeout));
  con.setReadTimeout(toInt(timeout));
  if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
    print("Warning: Timeouts not set by JDK.");
  return con;
}
static URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
  if (con.getConnectTimeout() == 0) {
    con.setConnectTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout)
      print("Warning: URL connect timeout not set by JDK.");
  }
  if (con.getReadTimeout() == 0) {
    con.setReadTimeout(toInt(timeout));
    if (con.getReadTimeout() != timeout)
      print("Warning: URL read timeout not set by JDK.");
  }
  return con;
}
static String htmlQuote(String s) {
  return "\"" + htmlencode_forParams(s) + "\"";
}
static List<String> htmlTok(String s) {
  return htmlcoarsetok(s);
}
// tok must come from htmlTok
// returns all container tags found (including content) as CNC
// should be OK for both HTML and XML
static List<List<String>> findContainerTag(List<String> tok, String tag) {
  List<List<String>> l = new ArrayList();
  for (int i = 1; i < l(tok); i += 2)
    if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i+2; j < tok.size(); j += 2)
        if (isOpeningTag(tok.get(j), tag))
          ++level;
        else if (isTag(tok.get(j), "/" + tag)) {
          --level;
          if (level == 0) {
            l.add(tok.subList(i-1, j+2)); // actual CNC
            break;
          }
        }
      i = j;
    }
  return l;
}

static List<List<String>> findContainerTag(String html, String tag) {
  return findContainerTag(htmlTok(html), tag);
}

static String addLineBreak(String s) {
  return addSuffix(s, "\n");
}
static Lock appendToFile_lock = lock();
static boolean appendToFile_keepOpen = false;
static HashMap<String,Writer> appendToFile_writers = new HashMap();

static void appendToFile(String path, String s) { try {
  Lock __1114 = appendToFile_lock; lock(__1114); try { // Let's just generally synchronize this to be safe.
  mkdirsForFile(new File(path));
  path = getCanonicalPath(path);
  Writer writer = appendToFile_writers.get(path);
  if (writer == null) {
    //print("[Logging to " + path + "]");
    writer = new BufferedWriter(new OutputStreamWriter(
      newFileOutputStream(path, true), "UTF-8"));
    if (appendToFile_keepOpen)
      appendToFile_writers.put(path, writer);
  }
  writer.write(s);
  if (!appendToFile_keepOpen)
    writer.close();
} finally { unlock(__1114); } } catch (Exception __e) { throw rethrow(__e); } }
  
static void appendToFile(File path, String s) {
  if (path != null)
    appendToFile(path.getPath(), s);
}

static void cleanMeUp_appendToFile() {
   AutoCloseable __1117 = tempCleaningUp(); try {
  Lock __1115 = appendToFile_lock; lock(__1115); try {
  closeAllWriters(values(appendToFile_writers));
  appendToFile_writers.clear();
} finally { unlock(__1115); } } finally { _close(__1117); }}
static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (assertVerbose()) return assertEqualsVerbose(msg, x, y);
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}
static List<String> javaTokC(String s) {
  if (s == null) return null;
  int l = s.length();
  ArrayList<String> tok = new ArrayList();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    i = j;
  }
  
  return tok;
}
static void quoteToPrintWriter(String s, PrintWriter out) {
  if (s == null) { out.print("null"); return; }
  out.print('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"') {
      out.print('\\'); out.print(c);
    } else if (c == '\r')
      out.print("\\r");
    else if (c == '\n')
      out.print("\\n");
    else if (c == '\0')
      out.print("\\0");
    else
      out.print(c);
  }
  out.print('"');
}
static String quoteCharacter(char c) {
  if (c == '\'') return "'\\''";
  if (c == '\\') return "'\\\\'";
  if (c == '\r') return "'\\r'";
  if (c == '\n') return "'\\n'";
  if (c == '\t') return "'\\t'";
  return "'" + c + "'";
}

static boolean isCISet_gen(Iterable<String> l) {
  return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
}
static <A> List<A> unwrapSynchronizedList(List<A> l) {
  if (eqOneOf(className(l),
    "java.util.Collections$SynchronizedList",
    "java.util.Collections$SynchronizedRandomAccessList"))
    return (List) get_raw(l, "list");
  return l;
}
static boolean isCIMap_gen(Map map) {
  return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
}
static String boolArrayToHex(boolean[] a) {
  return bytesToHex(boolArrayToBytes(a));
}
static Iterator emptyIterator() {
  return Collections.emptyIterator();
}
static String shortDynamicClassName(Object o) {
 if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  return shortClassName(o);
}
static int stdcompare(Number a, Number b) {
  return cmp(a, b);
}

static int stdcompare(String a, String b) {
  return cmp(a, b);
}

static int stdcompare(long a, long b) {
  return a < b ? -1 : a > b ? 1 : 0;
}

static int stdcompare(Object a, Object b) {
  return cmp(a, b);
}

static Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

static Field[] getDeclaredFields_cached(Class c) {
  Field[] fields;
  synchronized(getDeclaredFields_cache) {
    fields = getDeclaredFields_cache.get(c);
    if (fields == null) {
      getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
      for (Field f : fields)
        f.setAccessible(true);
    }
  }
  return fields;
}
static String dropPrefix(String prefix, String s) {
  return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
}
static boolean startsWithDigit(String s) {
  return nempty(s) && isDigit(s.charAt(0));
}
static boolean isCIMap(Map m) {
  return m instanceof TreeMap && ((TreeMap) m).comparator() == caseInsensitiveComparator();
}
static String getClientIPFromHeaders(Map<String, String> headers) {
  //print("All headers: " + sfu(headers));
  if (headers == null) return null;
  String remoteAddr =  (String) (headers.get("remote-addr"));
  String client =  (String) (headers.get("x-forwarded-for"));
  if (nempty(client)) remoteAddr += "," + client;
  return remoteAddr;
}
static boolean isJavaIdentifier(String s) {
  if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
    return false;
  for (int i = 1; i < s.length(); i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}
static Map<String, Class> classForName_cache = synchroHashMap();

static Class classForName(String name) { try {
  if (classForName_cache == null) return Class.forName(name); // in class init
  Class c = classForName_cache.get(name);
  if (c == null)
    classForName_cache.put(name, c = Class.forName(name));
  return c;
} catch (Exception __e) { throw rethrow(__e); } }
static Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

static Object nuObjectWithoutArguments(String className) { try {
  return nuObjectWithoutArguments(classForName(className));
} catch (Exception __e) { throw rethrow(__e); } }

static <A> A nuObjectWithoutArguments(Class<A> c) { try {
  if (nuObjectWithoutArguments_cache == null)
    // in class init
    return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
    
  Constructor m = nuObjectWithoutArguments_cache.get(c);
  if (m == null)
    nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
  return (A) m.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObjectWithoutArguments_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (empty(m.getParameterTypes())) {
      m.setAccessible(true);
      return m;
    }
  throw fail("No default constructor found in " + c.getName());
}

static List<Class> getClasses(Object[] array) {
  List<Class> l = new ArrayList();
  for (Object o : array) l.add(_getClass(o));
  return l;
}
static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static <A> List<A> sorted(Collection<A> c, final Object comparator) {
  List<A> l = cloneList(c);
  sort(l, makeComparator(comparator));
  return l;
}

static <A> List<A> sorted(Collection<A> c) {
  List<A> l = cloneList(c);
  sort(l);
  return l;
}
static List<String> methodsStartingWith(Object o, final String prefix) {
  return filter(allMethodNames(o), new F1<String, Object>() { Object get(String s) { try {  return startsWith(s, prefix);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "startsWith(s, prefix)"; }});
}
static Class mc() {
  return main.class;
}
static boolean isJavaXClassLoader(ClassLoader cl) {
  return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
}
static void setOptAll(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    setOpt/*_flex*/(o, field, fields.get(field));
}

static void setOptAll(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    setOpt(o, field, value);
  }
}
static List<String> javaTokWithBrackets(String s) {
  return javaTokPlusBrackets(s);
}
static int lCodeTokens(List<String> tok) {
  return l(tok)/2;
}
static boolean eqGet(List l, int i, Object o) {
  return eq(get(l, i), o);
}

static <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
  return eq(mapGet(map, key), o);
}
static T3<String, String, String> agiBlue_parseTriple(String s) {
  return agiBlue_parseTriple(javaTokWithBrackets(s));
}

static T3<String, String, String> agiBlue_parseTriple(List<String> tok) {
  List<String> split = tok_splitAtSlashes(tok);
  if (l(split) != 3 || !allNempty(split)) return null;
  return listToTriple(uncurlyAll(split));
}
static String uncurly(String s) {
  return tok_unCurlyBracket(s);
}
static boolean containsDollarVars(String s) {
  List<String> tok = javaTok(s);
  for (int i = 1; i < l(tok); i += 2)
    if (isDollarVar(tok.get(i))) return true;
  return false;
}
static String javaDropComments(String s) {
  return javaDropAllComments(s);
}
static boolean containsNewLine(String s) {
  return contains(s, '\n'); // screw \r, nobody needs it
}
static void addIfNempty(Collection<String> l, String s) {
  if (nempty(s)) l.add(s);
}

static void addIfNempty(Collection l, Map m) {
  if (nempty(m)) l.add(m);
}

static void addIfNempty(Collection l, Collection c) {
  if (nempty(c)) l.add(c);
}
static String joinSubList(List<String> l, int i, int j) {
  return join(subList(l, i, j));
}

static String joinSubList(List<String> l, int i) {
  return join(subList(l, i));
}


static boolean nemptyString(String s) {
  return s != null && s.length() > 0;
}
static int listL(Collection l) {
  return l == null ? 0 : l.size();
}
static Object[] dropEntryFromParams(Object[] params, int i) {
  int n = l(params);
  if (i < 0 || i >= n) return params;
  if (n == 2) return null;
  Object[] p = new Object[n-2];
  System.arraycopy(params, 0, p, 0, i);
  System.arraycopy(params, i+2, p, i, n-i-2);
  return p;
}
static void withCancelPoint(VF1<CancelPoint> r) {
   CancelPoint cp = newCancelPoint(); try {
  try {
    callF(r, cp);
  } catch (Throwable e) {
    e = innerException(e);
    if (!(e instanceof CancelToCancelPoint && ((CancelToCancelPoint) e).cp == cp))
      rethrow(e);
  }
} finally { _close(cp); }}
static RuntimeException cancelTo(CancelPoint cp) {
  if (cp.closed) throw fail("cancel point closed");
  throw new CancelToCancelPoint(cp);
}
static String dollarVarsToStars(String s) {
  return dollarVarsToStars(s, null);
}

static String dollarVarsToStars(String s, List<String> varNames_out) {
  List<String> tok = javaTok(s);
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (isDollarVar(t)) {
      listAdd(varNames_out, t);
      tok.set(i, "*");
    } else if (eq(t, "*"))
      listAdd(varNames_out, "*");
  }
  return join(tok);
}


static boolean flexMatchIC_iterate_debug = false;

static void flexMatchIC_iterate(String pat, String input, VF1<Matches> onMatch) {
  if (flexMatchIC_iterate_debug)
    print("flexMatchIC_iterate " + pat + " / " + input);
  List<String> tokPat = javaTokNPunctuation_plusAsterisk(pat), tokInput = javaTokNPunctuation_plusAsterisk(input);
  // fail if crucial words not found (could be optimized more)
  List<Integer> varIndices = new ArrayList();
  for (int i = 1; i < l(tokPat); i += 2) {
    String t = tokPat.get(i);
    if (eq(t, "*"))
      varIndices.add(i);
    else if (isIdentifier(t) && !cicAtOddPosition(tokInput, t)) {
      if (flexMatchIC_iterate_debug)
        print("Crucial word fail (" + t + "): " + pat + " / " + input);
      return;
    }
  }
  if (flexMatchIC_iterate_debug)
    printStructs("varIndices", varIndices, "tokPat", tokPat, "tokInput", tokInput);
  List<List<String>> spreadInputs = ai_spreadCertainIndices_2(tokPat, tokInput, varIndices);
  for (List<String> tok : spreadInputs) {
    if (flexMatchIC_iterate_debug)
      print("Testing spread input: " + sfu(tok));
    Matches m = new Matches();
    if (match(pat, tok, m))
      callF(onMatch, m);
  }
}
static Map<String, String> matchesToMapUsingVarList_ciMap(Matches m, List<String> vars) {
  if (m == null) return null;
  Map<String, String> map = ciMap();
  int n = min(l(m.m), l(vars));
  for (int i = 0; i < n; i++)
    if (!strictPutIC(map, vars.get(i), m.get(i))) return null;
  return map;
}
static boolean isCurlyBraced(String s) {
  List<String> tok = tok_combineCurlyBrackets_keep(javaTok(s));
  return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "{", "}");
}
static String curlyBrace(String s) {
  return "{" + s + "}";
}
static String beautifyStructure(String s) {
  List<String> tok = javaTok(s);
  structure_addTokenMarkers(tok);
  jreplace(tok, "lhm", "");
  return join(tok);
}
static String struct_noStringSharing(Object o) {
  structure_Data d = new structure_Data();
  d.noStringSharing = true;
  return structure(o, d);
}
static <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
  List<A> l = new ArrayList();
  for (A x : list)
    if (checkConceptFields(x, params))
      l.add(x);
  return l;
}
static CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {
  public Object next() { throw fail(); }
  public boolean hasNext() { return false; }
};

static <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
  return emptyCloseableIterableIterator_instance; 
}
static CloseableIterableIterator<String> linesFromReader(Reader r) {
  final BufferedReader br = bufferedReader(r);
  return iteratorFromFunction_f0_autoCloseable(new F0<String>() { String get() { try {  return readLineFromReaderWithClose(br);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret readLineFromReaderWithClose(br);"; }}, _wrapIOCloseable(r));
}
static BufferedReader utf8bufferedReader(InputStream in) { try {
  return bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader utf8bufferedReader(File f) { try {
  return utf8bufferedReader(newFileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isInstance(Class type, Object arg) {
  return type.isInstance(arg);
}
static Object unstructure(String text) {
  return unstructure(text, false);
}

static Object unstructure(String text, final boolean allDynamic) {
  return unstructure(text, allDynamic, null);
}

static int structure_internStringsLongerThan = 50;
static int unstructure_unquoteBufSize = 100;

static int unstructure_tokrefs; // stats

abstract static class unstructure_Receiver {
  abstract void set(Object o);
}

// classFinder: func(name) -> class (optional)
static Object unstructure(String text, boolean allDynamic,
  Object classFinder) {
  if (text == null) return null;
  return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
}

static Object unstructure_reader(BufferedReader reader) {
  return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
}

static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
  final boolean debug = unstructure_debug;
  
  final class X {
    int i = -1;
    final Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();
    HashMap<Integer,Object> refs = new HashMap();
    HashMap<Integer,Object> tokrefs = new HashMap();
    HashSet<String> concepts = new HashSet();
    HashMap<String,Class> classesMap = new HashMap();
    List<Runnable> stack = new ArrayList();
    String curT;
    char[] unquoteBuf = new char[unstructure_unquoteBufSize];
    
    String unquote(String s) {
      return unquoteUsingCharArray(s, unquoteBuf); 
    }

    // look at current token
    String t() {
      return curT;
    }
    
    // get current token, move to next
    String tpp() {
      String t = curT;
      consume();
      return t;
    }
    
    void parse(final unstructure_Receiver out) {
      String t = t();
      
      int refID = 0;
      if (structure_isMarker(t, 0, l(t))) {
        refID = parseInt(t.substring(1));
        consume();
      }
      final int _refID = refID;
      
      // if (debug) print("parse: " + quote(t));
      
      final int tokIndex = i;  
      parse_inner(refID, tokIndex, new unstructure_Receiver() {
        void set(Object o) {
          if (_refID != 0)
            refs.put(_refID, o);
          if (o != null)
            tokrefs.put(tokIndex, o);
          out.set(o);
        }
      });
    }
    
    void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
      String t = t();
      
      // if (debug) print("parse_inner: " + quote(t));
      
      Class c = classesMap.get(t);
      if (c == null) {
        if (t.startsWith("\"")) {
          String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
          out.set(s); return;
        }
        
        if (t.startsWith("'")) {
          out.set(unquoteCharacter(tpp())); return;
        }
        if (t.equals("bigint")) {
          out.set(parseBigInt()); return;
        }
        if (t.equals("d")) {
          out.set(parseDouble()); return;
        }
        if (t.equals("fl")) {
          out.set(parseFloat()); return;
        }
        if (t.equals("sh")) {
          consume();
          t = tpp();
          if (t.equals("-")) {
            t = tpp();
            out.set((short) (-parseInt(t))); return;
          }
          out.set((short) parseInt(t)); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          
          out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l)); return;
        }
        if (t.equals("false") || t.equals("f")) {
          consume(); out.set(false); return;
        }
        if (t.equals("true") || t.equals("t")) {
          consume(); out.set(true); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          
          out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l)); return;
        }
        
        if (t.equals("File")) {
          consume();
          File f = new File(unquote(tpp()));
          out.set(f); return;
        }
        
        if (t.startsWith("r") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = refs.get(ref);
          if (o == null)
            print("Warning: unsatisfied back reference " + ref);
          out.set(o); return;
        }
      
        if (t.startsWith("t") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = tokrefs.get(ref);
          if (o == null)
            print("Warning: unsatisfied token reference " + ref);
          out.set(o); return;
        }
        
        if (t.equals("hashset")) { parseHashSet(out); return; }
        if (t.equals("lhs")) { parseLinkedHashSet(out); return; }
        if (t.equals("treeset")) { parseTreeSet(out); return; }
        if (t.equals("ciset")) { parseCISet(out); return; }
        
        if (eqOneOf(t, "hashmap", "hm")) {
          consume();
          parseMap(new HashMap(), out);
          return;
        }
        if (t.equals("lhm")) {
          consume();
          parseMap(new LinkedHashMap(), out);
          return;
        }
        if (t.equals("tm")) {
          consume();
          parseMap(new TreeMap(), out);
          return;
        }
        if (t.equals("cimap")) {
          consume();
          parseMap(ciMap(), out);
          return;
        }
        
        if (t.equals("ll")) {
          consume();
          { parseList(new LinkedList(), out); return; }
        }

        if (t.equals("syncLL")) {
          consume();
          { parseList(synchroLinkedList(), out); return; }
        }

        if (t.equals("sync")) {
          consume();
          if (t().equals("tm")) {
            consume();
            { parseMap(synchronizedTreeMap(), out); return; }
          }
          if (t().equals("["))
            { parseList(synchroList(), out); return; }
          { parseMap(synchronizedMap(), out); return; }
        }
        if (t.equals("{")) {
          parseMap(out); return;
        }
        if (t.equals("[")) {
          this.parseList(new ArrayList(), out); return;
        }
        if (t.equals("bitset")) {
          parseBitSet(out); return;
        }
        if (t.equals("array") || t.equals("intarray")) {
          parseArray(out); return;
        }
        if (t.equals("ba")) {
          consume();
          String hex = unquote(tpp());
          out.set(hexToBytes(hex)); return;
        }
        if (t.equals("boolarray")) {
          consume();
          int n = parseInt(tpp());
          String hex = unquote(tpp());
          out.set(boolArrayFromBytes(hexToBytes(hex), n)); return;
        }
        if (t.equals("class")) {
          out.set(parseClass()); return;
        }
        if (t.equals("l")) {
          parseLisp(out); return;
        }
        if (t.equals("null")) {
          consume(); out.set(null); return;
        }
        
        if (eq(t, "c")) {
          consume("c");
          t = t();
          assertTrue(isJavaIdentifier(t));
          concepts.add(t);
        }
      }
      
      if (eq(t, "j")) {
        consume("j");
        out.set(parseJava()); return;
      }

      if (c == null && !isJavaIdentifier(t))
        throw new RuntimeException("Unknown token " + (i+1) + ": " + t);
        
      // any other class name (or package name)
      consume();
      String className, fullClassName;
      
      // Is it a package name?
      if (eq(t(), ".")) {
        consume();
        className = fullClassName = t + "." + assertIdentifier(tpp());
      } else {
        className = t;
        fullClassName = "main$" + t;
      }
      
      if (c == null) {
        // First, find class
        if (allDynamic) c = null;
        else c = classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
        if (c != null)
          classesMap.put(className, c);
      }
          
      // Check if it has an outer reference
      boolean hasBracket = eq(t(), "(");
      if (hasBracket) consume();
      boolean hasOuter = hasBracket && eq(t(), "this$1");
      
      DynamicObject dO = null;
      Object o = null;
      final String thingName = t;
      if (c != null) {
        o = hasOuter ? nuStubInnerObject(c, classFinder) : nuEmptyObject(c);
        if (o instanceof DynamicObject) dO = (DynamicObject) o;
      } else {
        if (concepts.contains(t) && (c = findClass("Concept")) != null)
          o = dO = (DynamicObject) nuEmptyObject(c);
        else
          dO = new DynamicObject();
        dO.className = className;
        
      }
      
      // Save in references list early because contents of object
      // might link back to main object
      
      if (refID != 0)
        refs.put(refID, o != null ? o : dO);
      tokrefs.put(tokIndex, o != null ? o : dO);
      
      // NOW parse the fields!
      
      final LinkedHashMap<String,Object> fields = new LinkedHashMap(); // preserve order
      final Object _o = o;
      final DynamicObject _dO = dO;
      if (hasBracket) {
        stack.add(new Runnable() {  public void run() { try { 
          if (eq(t(), ")")) {
            consume(")");
            objRead(_o, _dO, fields);
            out.set(_o != null ? _o : _dO);
          } else {
            final String key = unquote(tpp());
            if (!eq(tpp(), "="))
              throw fail("= expected, got " + t() + " after " + quote(key) + " in object " + thingName /*+ " " + sfu(fields)*/);
            stack.add(this);
            parse(new unstructure_Receiver() {
              void set(Object value) {
                fields.put(key, value);
                if (eq(t(), ",")) consume();
              }
            });
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, ..."; }});
      } else {
        objRead(o, dO, fields);
        out.set(o != null ? o : dO);
      }
    }
    
    void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
      
      if (o != null)
        if (dO != null) {
          
          setOptAllDyn(dO, fields);
        } else {
          setOptAll_pcall(o, fields);
          
        }
      else for (String field : keys(fields))
        dO.fieldValues.put(intern(field), fields.get(field));

      if (o != null)
        pcallOpt_noArgs(o, "_doneLoading");
    }
    
    void parseSet(final Set set, final unstructure_Receiver out) {
      this.parseList(new ArrayList(), new unstructure_Receiver() {
        void set(Object o) {
          set.addAll((List) o);
          out.set(set);
        }
      });
    }
    
    void parseLisp(final unstructure_Receiver out) {
      
      
      throw fail("class Lisp not included");
    }
    
    void parseBitSet(final unstructure_Receiver out) {
      consume("bitset");
      consume("{");
      final BitSet bs = new BitSet();
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(bs);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              bs.set((Integer) o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ..."; }});
    }
    
    void parseList(final List list, final unstructure_Receiver out) {
      consume("[");
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "]")) {
          consume("]");
          out.set(list);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              //if (debug) print("List element type: " + getClassName(o));
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n     ..."; }});
    }
    
    void parseArray(final unstructure_Receiver out) {
      final String type = tpp();
      consume("{");
      final List list = new ArrayList();
      
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"..."; }});
    }
    
    Object parseClass() {
      consume("class");
      consume("(");
      String name = unquote(tpp());
      consume(")");
      Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass_fullName(name);
      if (c != null) return c;
      DynamicObject dO = new DynamicObject();
      dO.className = "java.lang.Class";
      name = dropPrefix("main$", name);
      dO.fieldValues.put("name", name);
      return dO;
    }
    
    Object parseBigInt() {
      consume("bigint");
      consume("(");
      String val = tpp();
      if (eq(val, "-"))
        val = "-" + tpp();
      consume(")");
      return new BigInteger(val);
    }
    
    Object parseDouble() {
      consume("d");
      consume("(");
      String val = unquote(tpp());
      consume(")");
      return Double.parseDouble(val);
    }
    
    Object parseFloat() {
      consume("fl");
      String val;
      if (eq(t(), "(")) {
        consume("(");
        val = unquote(tpp());
        consume(")");
      } else {
        val = unquote(tpp());
      }
      return Float.parseFloat(val);
    }
    
    void parseHashSet(unstructure_Receiver out) {
      consume("hashset");
      parseSet(new HashSet(), out);
    }
    
    void parseLinkedHashSet(unstructure_Receiver out) {
      consume("lhs");
      parseSet(new LinkedHashSet(), out);
    }
    
    void parseTreeSet(unstructure_Receiver out) {
      consume("treeset");
      parseSet(new TreeSet(), out);
    }
    
    void parseCISet(unstructure_Receiver out) {
      consume("ciset");
      parseSet(ciSet(), out);
    }
    
    void parseMap(unstructure_Receiver out) {
      parseMap(new TreeMap(), out);
    }
    
    Object parseJava() {
      String j = unquote(tpp());
      Matches m = new Matches();
      if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
        return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
      else {
        warn("Unknown Java object: " + j);
        return null;
      }
    }
    
    void parseMap(final Map map, final unstructure_Receiver out) {
      consume("{");
      stack.add(new Runnable() {
        boolean v = false;
        Object key;
        
        public void run() { 
          if (v) {
            v = false;
            stack.add(this);
            if (!eq(tpp(), "="))
              throw fail("= expected, got " + t() + " in map of size " + l(map));

            parse(new unstructure_Receiver() {
              void set(Object value) {
                map.put(key, value);
                
                if (eq(t(), ",")) consume();
              }
            });
          } else {
            if (eq(t(), "}")) {
              consume("}");
              out.set(map);
            } else {
              v = true;
              stack.add(this);
              parse(new unstructure_Receiver() {
                void set(Object o) {
                  key = o;
                }
              });
            }
          } // if v else
        } // run()
      });
    }
    
    /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
    
    void consume() { curT = tok.next(); ++i; }
    
    void consume(String s) {
      if (!eq(t(), s)) {
        /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
        throw fail(quote(s) + " expected, got " + quote(t()));
      }
      consume();
    }
    
    void parse_x(unstructure_Receiver out) {
      consume(); // get first token
      parse(out);
      while (nempty(stack))
        popLast(stack).run();
    }
  }
  
  Boolean b = DynamicObject_loading.get();
  DynamicObject_loading.set(true);
  try {
    final Var v = new Var();
    X x = new X();
    x.parse_x(new unstructure_Receiver() {
      void set(Object o) { v.set(o); }
    });
    unstructure_tokrefs = x.tokrefs.size();
    return v.get();
  } finally {
    DynamicObject_loading.set(b);
  }
}

static boolean unstructure_debug = false;
static <A> Iterator<A> iterator(Iterable<A> c) {
  return c == null ? emptyIterator() : c.iterator();
}


static void clear(Collection c) {
  if (c != null) c.clear();
}
static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}

static <A> void put(List<A> l, int i, A a) {
  if (l != null && i >= 0 && i < l(l)) l.set(i, a);
}
static List<Pair> _registerDangerousWeakMap_preList;

static <A> A _registerDangerousWeakMap(A map) {
  return _registerDangerousWeakMap(map, null);
}

static <A> A _registerDangerousWeakMap(A map, Object init) {
  
  callF(init, map);
  
  if (init instanceof String) {
    final String f =  (String) init;
    init = new VF1<Map>() { public void get(Map map) { try {  callMC(f, map) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callMC(f, map)"; }};
  }
    
  if (javax() == null) {
    // We're in class init
    if (_registerDangerousWeakMap_preList == null) _registerDangerousWeakMap_preList = synchroList();
    _registerDangerousWeakMap_preList.add(pair(map, init));
    return map;
  }
  
  call(javax(), "_registerDangerousWeakMap", map, init);
  
  return map;
}

static void _onLoad_registerDangerousWeakMap() {
  
  assertNotNull(javax());
  if (_registerDangerousWeakMap_preList == null) return;
  for (Pair p : _registerDangerousWeakMap_preList)
    _registerDangerousWeakMap(p.a, p.b);
  _registerDangerousWeakMap_preList = null;
  
}
static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static Set<String> reflection_classesNotToScan_value = litset(
  "jdk.internal.loader.URLClassPath"
);

static Set<String> reflection_classesNotToScan() {
  return reflection_classesNotToScan_value;
}
static Map vm_generalWeakSubMap(Object name) {
  synchronized(get(javax(), "generalMap")) {
    Map map =  (Map) (vm_generalMap_get(name));
    if (map == null)
      vm_generalMap_put(name, map = newWeakMap());
    return map;
  }
}

static <A> WeakReference<A> weakRef(A a) {
  return newWeakReference(a);
}
static Throwable unwrapTrivialExceptionWraps(Throwable e) {
  if (e == null) return e;
  while (e.getClass() == RuntimeException.class
    && e.getCause() != null && eq(e.getMessage(), str(e.getCause())))
    e = e.getCause();
  return e;
}
static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}
static Throwable innerException2(Throwable e) {
  if (e == null) return null;
  while (empty(e.getMessage()) && e.getCause() != null)
    e = e.getCause();
  return e;
}
static Random defaultRandomGenerator() {
  return ThreadLocalRandom.current();
}
static betterCIComparator_C betterCIComparator_instance;

static betterCIComparator_C betterCIComparator() {
  if (betterCIComparator_instance == null)
    betterCIComparator_instance = new betterCIComparator_C();
  return betterCIComparator_instance;
}

static class betterCIComparator_C implements Comparator<String> {
  public int compare(String s1, String s2) {
    if (s1 == null) return s2 == null ? 0 : -1;
    if (s2 == null) return 1;
  
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
            c1 = Character.toUpperCase(c1);
            c2 = Character.toUpperCase(c2);
            if (c1 != c2) {
                c1 = Character.toLowerCase(c1);
                c2 = Character.toLowerCase(c2);
                if (c1 != c2) {
                    // No overflow because of numeric promotion
                    return c1 - c2;
                }
            }
        }
    }
    return n1 - n2;
  }
}
static Class __javax;

static Class getJavaX() { try {
  
  return __javax;
} catch (Exception __e) { throw rethrow(__e); } }
static List _registerWeakMap_preList;

static <A> A _registerWeakMap(A map) {
  if (javax() == null) {
    // We're in class init
    if (_registerWeakMap_preList == null) _registerWeakMap_preList = synchroList();
    _registerWeakMap_preList.add(map);
    return map;
  }
  
  try {
    call(javax(), "_registerWeakMap", map);
  } catch (Throwable e) {
    printException(e);
    print("Upgrade JavaX!!");
  }
  return map;
}

static void _onLoad_registerWeakMap() {
  assertNotNull(javax());
  if (_registerWeakMap_preList == null) return;
  for (Object o : _registerWeakMap_preList)
    _registerWeakMap(o);
  _registerWeakMap_preList = null;
}
static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}

static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (isAndroid()) return isHeadless_cache = true;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { _handleException(__e); }
  return null;
}
// This is for main classes that are all static.
// (We don't go to base classes.)
static Set<String> listFields(Object c) {
  TreeSet<String> fields = new TreeSet();
  for (Field f : _getClass(c).getDeclaredFields())
    fields.add(f.getName());
  return fields;
}
static <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
  if (map instanceof LinkedHashMap) return (LinkedHashMap) map;
  LinkedHashMap<A,B> m = new LinkedHashMap();
  if (map != null) synchronized(collectionMutex(map)) {
    m.putAll(map);
  }
  return m;
}
// This is a bit rough... finds static and non-static methods.

static Method findMethodNamed(Object obj, String method) {
  if (obj == null) return null;
  if (obj instanceof Class)
    return findMethodNamed((Class) obj, method);
  return findMethodNamed(obj.getClass(), method);
}

static Method findMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method)) {
        m.setAccessible(true);
        return m;
      }
    c = c.getSuperclass();
  }
  return null;
}
static void upgradeJavaXAndRestart() {
  
    run("#1001639");
    restart();
    sleep();
  
  
}
static String actualUserHome_value;
static String actualUserHome() {
  if (actualUserHome_value == null) {
    if (isAndroid())
      actualUserHome_value = "/storage/emulated/0/";
    else
      actualUserHome_value = System.getProperty("user.home");
  }
  return actualUserHome_value;
}

static File actualUserHome(String sub) {
  return newFile(new File(actualUserHome()), sub);
}
static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}


static Path toPath(File f) {
  return f == null ? null : f.toPath();
}
static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static List<File> listFilesOnly(String dir) {
  return listFilesOnly(new File(dir));
}

static List<File> listFilesOnly(File... dirs) {
  return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
}

static Map<String, String> singular_specials = litmap(
  "children", "child", "images", "image", "chess", "chess");
  
static Set<String> singular_specials2 = litset("time", "machine", "line");

static String singular(String s) {
  if (s == null) return null;
  { String _a_1210 = singular_specials.get(s); if (!empty(_a_1210)) return _a_1210; }
  //try answer hippoSingulars().get(lower(s));
  if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
    return dropSuffix("s", s);
  if (s.endsWith("ness")) return s;
  if (s.endsWith("ges")) return dropSuffix("s", s);
  if (endsWith(s, "bases")) return dropLast(s);
  s = dropSuffix("es", s);
  s = dropSuffix("s", s);
  return s;
}
static List<String> getPlural_specials = ll("sheep", "fish");

static String getPlural(String s) {
  if (containsIgnoreCase(getPlural_specials, s)) return s;
  if (ewic(s, "y")) return dropSuffixIgnoreCase("y", s) + "ies";
  if (ewic(s, "ss")) return s + "es";
  if (ewic(s, "s")) return s;
  return s + "s";
}
static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}


static <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
  if (mm != null && key != null && value != null) mm.put(key, value);
}

static Throwable getExceptionCause(Throwable e) {
  Throwable c = e.getCause();
  return c != null ? c : e;
}
static String joinWithSpace(Collection<String> c) {
  return join(" ", c);
}

static String joinWithSpace(String... c) {
  return join(" ", c);
}

static void assertFalse(Object o) {
  if (!(eq(o, false) /*|| isFalse(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}

// returns l(s) if not found
static int smartIndexOf(String s, String sub, int i) {
  if (s == null) return 0;
  i = s.indexOf(sub, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, int i, char c) {
  return smartIndexOf(s, c, i);
}

static int smartIndexOf(String s, char c, int i) {
  if (s == null) return 0;
  i = s.indexOf(c, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, String sub) {
  return smartIndexOf(s, sub, 0);
}

static int smartIndexOf(String s, char c) {
  return smartIndexOf(s, c, 0);
}

static <A> int smartIndexOf(List<A> l, A sub) {
  return smartIndexOf(l, sub, 0);
}

static <A> int smartIndexOf(List<A> l, int start, A sub) {
  return smartIndexOf(l, sub, start);
}

static <A> int smartIndexOf(List<A> l, A sub, int start) {
  int i = indexOf(l, sub, start);
  return i < 0 ? l(l) : i;
}
static Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

static java.util.regex.Pattern compileRegexp(String pat) {
  java.util.regex.Pattern p = compileRegexp_cache.get(pat);
  if (p == null) {
    
    compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
  }
  return p;
}
static boolean isLetter(char c) {
  return Character.isLetter(c);
}
static TreeSet<String> caseInsensitiveSet_treeSet() {
  return new TreeSet(caseInsensitiveComparator());
}

static TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
  return toCaseInsensitiveSet_treeSet(c);
}
static String hjavascript_src_snippet(String snippetID) {
  return tag("script", "", "src" , snippetRawURL(snippetID));
}
static Object subBot_httpd() {
  Object httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "MyHTTPD_current"));
  if (httpd == null)
    httpd = getThreadLocal((ThreadLocal) getOpt(mainBot(), "WebSocketHTTPD_current"));
  return httpd;
}
static Object mainBot() {
  return getMainBot();
}
static boolean isImageServerSnippet(long id) {
  return id >= 1100000 && id < 1200000;
}
static String imageServerLink(String md5OrID) {
  if (possibleMD5(md5OrID))
    return "https://botcompany.de/images/md5/" + md5OrID;
  return imageServerLink(parseSnippetID(md5OrID));
}

static String imageServerLink(long id) {
  return "https://botcompany.de/images/" + id;
}


static String formatWithThousandsSeparator(long l) {
  return NumberFormat.getInstance(new Locale("en_US")).format(l);
}
static String codePointToString(int codePoint) {
  return new String(Character.toChars(codePoint));
}
static String jsonEncode_breakAtLevel1(Object o) {
  StringBuilder buf = new StringBuilder();
  jsonEncode_breakAtLevel1(o, buf, 1);
  return str(buf);
}

static void jsonEncode_breakAtLevel1(Object o, StringBuilder buf, int level) {
  if (o == null)
    buf.append("null");
  else if (o instanceof String)
    buf.append(quote((String) o));
  else if (o instanceof Number || o instanceof Boolean)
    buf.append(o);
  else if (o instanceof Map) {
    Map map =  (Map) o;
    buf.append("{");
    boolean first = true;
    for (Object key : keys(map)) {
      if (first) first = false; else buf.append(",");
      if (level == 1) buf.append("\n  ");
      buf.append(quote((String) key));
      buf.append(":");
      jsonEncode_breakAtLevel1(map.get(key), buf, level+1);
    }
    if (level == 1) buf.append("\n");
    buf.append("}");
  } else if (o instanceof Collection) {
    Collection l =  (Collection) o;
    buf.append("[");
    boolean first = true;
    for (Object element : l) {
      if (first) first = false; else buf.append(",");
      if (level == 1) buf.append("\n  ");
      jsonEncode_breakAtLevel1(element, buf, level+1);
    }
    if (level == 1) buf.append("\n");
    buf.append("]");
  } else
    throw fail("Unknown object for JSON encoding: " + className(o));
}
static char lastChar(String s) {
  return empty(s) ? '\0' : s.charAt(l(s)-1);
}
static Object vmBus_query(String msg, Object... args) {
  Object arg = vmBus_wrapArgs(args);
  { Object __1239= pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg); if (__1239 != null) return __1239; }
  return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
}

static Object vmBus_query(String msg) {
  return vmBus_query(msg, (Object) null);
}
static Object dm_os() {
  { Object __1244= vm_generalMap_get("stefansOS"); if (__1244 != null) return __1244; }
  return creator();
}
static boolean methodIsStatic(Method m) {
  return (m.getModifiers() & Modifier.STATIC) != 0;
}
static boolean argumentCompatibleWithType(Object arg, Class type) {
  return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
}
static void arraycopy(Object[] a, Object[] b) {
  if (a != null && b != null)
    arraycopy(a, 0, b, 0, min(a.length, b.length));
}

static void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
  if (n != 0)
    System.arraycopy(src, srcPos, dest, destPos, n);
}
static <A> A[] arrayOfType(Class<A> type, int n) {
  return makeArray(type, n);
}

static <A> A[] arrayOfType(int n, Class<A> type) {
  return arrayOfType(type, n);
}
static List<String> getClassNames(Collection l) {
  List<String> out = new ArrayList();
  if (l != null) for (Object o : l)
    out.add(o == null ? null : getClassName(o));
  return out;
}
static Map paramsToMap(Object... params) {
  int n = l(params);
  if (l(params) == 1 && params[0] instanceof Map) return (Map) params[0];
  LinkedHashMap map = new LinkedHashMap();
  for (int i = 0; i+1 < n; i += 2)
    mapPut(map, params[i], params[i+1]);
  return map;
}
static Object[] mapToObjectArray(Map map) {
  List l = new ArrayList();
  for (Object o : keys(map)) {
    l.add(o);
    l.add(map.get(o));
  }
  return toObjectArray(l);
}
static int indexOfIgnoreCase_manual(String a, String b) {
  int la = strL(a), lb = strL(b);
  if (la < lb) return -1;
  int n = la-lb;
  
  loop: for (int i = 0; i <= n; i++) {
    for (int j = 0; j < lb; j++) {
      char c1 = a.charAt(i+j), c2 = b.charAt(j);
      if (!eqic(c1, c2))
        continue loop;
    }
    return i;
  }
  return -1;
}
static Object vm_generalMap_put(Object key, Object value) {
  return mapPutOrRemove(vm_generalMap(), key, value);
}
static <A> Set<A> syncIdentityHashSet() {
  return (Set) synchronizedSet(identityHashSet());
}
static Map syncHashMap() {
  return synchroHashMap();
}
static String multiLineQuoteWithSpaces(String s) {
  return multiLineQuote(" " + s + " ");
}
// TODO: optimize
static String lastLine(String s) {
  s = dropSuffix("\n", s);
  s = dropSuffix("\r", s);
  int i = s.lastIndexOf('\n');
  return substring(s, i+1);
}
static String quoteUnlessIdentifierOrInteger(String s) {
  return quoteIfNotIdentifierOrInteger(s);
}
static HashMap<String,Class> findClass_fullName_cache = new HashMap();

// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass_fullName(String name) {
  synchronized(findClass_fullName_cache) {
    if (findClass_fullName_cache.containsKey(name))
      return findClass_fullName_cache.get(name);
      
    Class c;
    try {
      c = Class.forName(name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_fullName_cache.put(name, c);
    return c;
  }
}
static String formatDouble(double d, int digits) {
  String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
  return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
}

static File localSnippetsDir() {
  return javaxDataDir("Personal Programs");
}

static File localSnippetsDir(String sub) {
  return newFile(localSnippetsDir(), sub);
}
static Map vm_generalMap_map;

static Map vm_generalMap() {
  if (vm_generalMap_map == null)
    vm_generalMap_map = (Map) get(javax(), "generalMap");
  return vm_generalMap_map;
}
static File oneOfTheFiles(String... paths) {
  if (paths != null) for (String path : paths)
    if (fileExists(path))
      return newFile(path);
  return null;
}

static File oneOfTheFiles(File... files) {
  if (files != null) for (File f : files)
    if (fileExists(f))
      return f;
  return null;
}
static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }
static void _registerIO(Object object, String path, boolean opened) {
}
static volatile Object isAllowed_function; // func(S, O[]) -> bool
static volatile boolean isAllowed_all = true;

static boolean isAllowed(String askingMethod, Object... args) {
  // check on VM level
  Object f = vm_generalMap_get("isAllowed_function");
  if (f != null && !isTrue(callF(f, askingMethod, args))) return false;
  
  // check locally
  return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
}
static long round(double d) {
  return Math.round(d);
}


static String hmsWithColons() {
  return hmsWithColons(now());
}

static String hmsWithColons(long time) {
  return new SimpleDateFormat("HH:mm:ss").format(time);
}

static String getComputerID_quick() {
  return computerID();
}
static String joinNemptiesWithColonSpace(String... strings) {
  return joinNempties(": ", strings);
}

static String joinNemptiesWithColonSpace(Collection<String> strings) {
  return joinNempties(": ", strings);
}
static String tryToReadErrorStreamFromURLConnection(URLConnection conn) { try {
  if (conn instanceof HttpURLConnection)
    return stream2string(((HttpURLConnection) conn).getErrorStream()); // TODO: ensure some max length
  return null;
} catch (Throwable __e) { return null; } }
static int gzInputStream_defaultBufferSize = 65536;

static GZIPInputStream gzInputStream(File f) { try {
  return gzInputStream(new FileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(File f, int bufferSize) { try {
  return gzInputStream(new FileInputStream(f), bufferSize);
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(InputStream in) {
  return gzInputStream(in, gzInputStream_defaultBufferSize);
}

static GZIPInputStream gzInputStream(InputStream in, int bufferSize) { try {
  return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
} catch (Exception __e) { throw rethrow(__e); } }
static String htmlencode_forParams(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      /*if (c >= 0x100)
        out.append("&#x").append(charToHex(c)).append(';');
      else*/ if (c > 127 || c == '"' || c == '<' || c == '>') {
          out.append("&#");
          out.append((int) c);
          out.append(';');
      } else
          out.append(c);
  }
  return out.toString();
}
static boolean isOpeningTag(String token, String tag) {
  return isTag(token, tag) && !token.endsWith("/>");
}

static boolean isOpeningTag(String token) {
  return token.startsWith("<")
    && token.endsWith(">")
    && !token.endsWith("/>")
    && isLetter(token.charAt(1));
}    

static boolean isTag(String token, String tag) {
  return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length()+2)
    || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length()+2);
}
static String addSuffix(String s, String suffix) {
  return s == null || s.endsWith(suffix) ? s : s + suffix;
}
static String getCanonicalPath(File f) { try {
  return f == null ? null : f.getCanonicalPath();
} catch (Exception __e) { throw rethrow(__e); } }

static String getCanonicalPath(String path) {
  return getCanonicalPath(newFile(path));
}
static AutoCloseable tempCleaningUp() {
  return tempSetTL(ping_isCleanUpThread, true);
}
static void closeAllWriters(Collection<? extends Writer> l) {
  for (Writer w : unnull(l)) { try {
    w.close();
  } catch (Throwable __e) { _handleException(__e); }}
}
static ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

static void assertVerbose(boolean b) {
  assertVerbose_value.set(b);
}

static boolean assertVerbose() { return isTrue(assertVerbose_value.get()); }
static <A> A assertEqualsVerbose(Object x, A y) {
  assertEqualsVerbose((String) null, x, y);
  return y;
}

static <A> A assertEqualsVerbose(String msg, Object x, A y) {
  if (!eq(x, y)) {
    

    throw fail((msg != null ? msg + ": " : "") + /*sfu*/(y) + " != " + /*sfu*/(x));
  } else
    print("OK: " + /*sfu*/(x));
  return y;
}


static String javaTok_substringC(String s, int i, int j) {
  return s.substring(i, j);
}
static byte[] boolArrayToBytes(boolean[] a) {
  byte[] b = new byte[(l(a)+7)/8];
  for (int i = 0; i < l(a); i++)
    if (a[i])
      b[i/8] |= 1 << (i & 7);
  return b;
}
static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}
static boolean isDigit(char c) {
  return Character.isDigit(c);
}
static Class<?> _getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null; // could optimize this
  }
}

static Class _getClass(Object o) {
  return o == null ? null
    : o instanceof Class ? (Class) o : o.getClass();
}

static Class _getClass(Object realm, String name) {
  try {
    return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null; // could optimize this
  }
}
static Comparator makeComparator(final Object f) {
  if (f instanceof Comparator) return (Comparator) f;
  return new Comparator() {
    public int compare(Object a, Object b) {
      return (Integer) callF(f, a, b);
    }
  };
}

static List<String> allMethodNames(Object o) {
  Class c = _getClass(o);
  TreeSet<String> names = new TreeSet();
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      names.add(m.getName());
    c = c.getSuperclass();
  }
  return asList(names);
}
static List<String> javaTokPlusBrackets(String s) {
  return tok_combineRoundOrCurlyBrackets_keep(javaTok(s));
}
static List<String> tok_splitAtSlashes(String s) {
  return tok_splitAtSlash(s);
}



static List<String> tok_splitAtSlashes(List<String> tok) {
  return tok_splitAtSlash(tok);
}
static boolean allNempty(String... l) {
  for (String s : unnull(l))
    if (empty(s)) return false;
  return true;
}

static boolean allNempty(Iterable<String> l) {
  for (String s : unnull(l))
    if (empty(s)) return false;
  return true;
}
static <A> T3<A, A, A> listToTriple(List<A> l) {
  return l(l) != 3 ? null : triple(get(l, 0), get(l, 1), get(l, 2));
}
static List<String> uncurlyAll(Collection<String> l) {
  return map("uncurly",l);
}
static String tok_unCurlyBracket(String s) {
  return isCurlyBraced(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
}
// TODO: extended multi-line strings

static int javaTok_n, javaTok_elements;
static boolean javaTok_opt = false;

static List<String> javaTok(String s) {
  ++javaTok_n;
  ArrayList<String> tok = new ArrayList();
  int l = s == null ? 0 : s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    // Special JavaX syntax: 'identifier
    if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
      j += 2;
      while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
        ++j;
    } else if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        int c2 = s.charAt(j);
        if (c2 == opener || c2 == '\n' && opener == '\'') { // allow multi-line strings, but not for '
          ++j;
          break;
        } else if (c2 == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static List<String> javaTok(List<String> tok) {
  return javaTokWithExisting(join(tok), tok);
}
static String javaDropAllComments(String s) {
  return join(javaDropAllComments(javaTok(s)));
}

static List<String> javaDropAllComments(List<String> tok) {
  for (int i = 0; i < l(tok); i += 2)
    tok.set(i, tok_javaDropCommentsFromWhitespace(tok.get(i)));
  return tok;
}
static CancelPoint newCancelPoint() {
  return new CancelPoint();
}
static <A> void listAdd(Collection<A> c, A a) {
  if (c != null) c.add(a);
}
static List<String> javaTokNPunctuation_plusAsterisk(String s) {
  List<String> tok = javaTok(s);
  for (int i = 1; i < l(tok); i += 2) {
    int j = i;
    String t;
    while (j < l(tok) && l(t = tok.get(j)) == 1
      && !Character.isLetterOrDigit(t.charAt(0))
      && t.charAt(0) != '*')
        j += 2;
    if (j > i)
      // j points to next C token after mergeable stuff
      replaceSubList(tok, i-1, j, ll(joinSubList(tok, i-1, j)));
  }
  return tok;
}
static boolean cicAtOddPosition(List<String> l, String s) {
  int n = l(l);
  for (int i = 1; i < n; i += 2)
    if (eqic(l.get(i), s))
      return true;
  return false;
}
static void printStructs(Object... params) {
  print(renderStructs(params));
}
static List<List<String>> ai_spreadCertainIndices_2(List<String> tokPat, List<String> tokS, List<Integer> indices) {
  int extra = (l(tokS)-l(tokPat))/2;
  if (extra < 0 || empty(indices)) return emptyList();

  List<List<String>> results = new ArrayList();
  for (List<Integer> spread : allSpreads(extra, l(indices))) {
    List<String> tok = new ArrayList();
    int pos = 0, iSpread = 0, iIndices = 0;
    for (int i = 0; i < l(tokPat); i++)
      if (!eq(get(indices, iIndices), i))
        tok.add(tokS.get(pos++));
      else {
        ++iIndices;
        int take = spread.get(iSpread++)*2;
        tok.add(joinSubList(tokS, pos, pos+take+1));
        pos += take+1;
      }
    results.add(tok);
  }
  return results;
}
static boolean match(String pat, String s) {
  return match3(pat, s);
}

static boolean match(String pat, String s, Matches matches) {
  return match3(pat, s, matches);
}

static boolean match(String pat, List<String> toks, Matches matches) {
  return match3(pat, toks, matches);
}
static <A> boolean strictPutIC(Map<A, String> map, A key, String value) {
  if (!(map != null && key != null && value != null)) return true;
  String old = map.get(key);
  if (old == null) { map.put(key, value); return true; }
  return eqic(old, value);
}


static List<String> tok_combineCurlyBrackets_keep(List<String> tok) {
  List<String> l = new ArrayList();
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && eq(t, "{")) {
      int j = findEndOfCurlyBracketPart(tok, i);
      l.add(joinSubList(tok, i, j));
      i = j-1;
    } else
      l.add(t);
  }
  return l;
}
static boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
  return startsWith(s, prefix) && endsWith(s, suffix);
}
static String structure_addTokenMarkers(String s) {
  return join(structure_addTokenMarkers(javaTok(s)));
}
  
static List<String> structure_addTokenMarkers(List<String> tok) {
  // find references
  
  TreeSet<Integer> refs = new TreeSet();
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (t.startsWith("t") && isInteger(t.substring(1)))
      refs.add(parseInt(t.substring(1)));
  }
  
  if (empty(refs)) return tok;
  
  // add markers
  for (int i : refs) {
    int idx = i*2+1;
    String t = "";
    if (endsWithLetterOrDigit(tok.get(idx-1))) t = " ";
    tok.set(idx, t + "m" + i + " " + tok.get(idx));
  }
  
  return tok;
}


static String jreplace(String s, String in, String out) {
  return jreplace(s, in, out, null);
}

static String jreplace(String s, String in, String out, Object condition) {
  List<String> tok = javaTok(s);
  return jreplace(tok, in, out, condition) ? join(tok) : s;
}

// leaves tok properly tokenized
// returns true iff anything was replaced
static boolean jreplace(List<String> tok, String in, String out) {
  return jreplace(tok, in, out, false, true, null);
}

static boolean jreplace(List<String> tok, String in, String out, Object condition) {
  return jreplace(tok, in, out, false, true, condition);
}

static boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
  String[] toks = javaTokForJFind_array(in);
  int lTokin = toks.length*2+1;

  boolean anyChange = false;
  int i = -1;
  for (int n = 0; n < 10000; n++) { // TODO: don't need this check anymore
    i = findCodeTokens(tok, i+1, ignoreCase, toks, condition);
    if (i < 0)
      return anyChange;
    List<String> subList = tok.subList(i-1, i+lTokin-1); // N to N
    String expansion = jreplaceExpandRefs(out, subList);
    int end = i+lTokin-2;
    clearAllTokens(tok, i, end); // C to C
    tok.set(i, expansion);
    if (reTok) // would this ever be false??
      reTok(tok, i, end);
    i = end;
    anyChange = true;
  }
  throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
}

static boolean jreplace_debug = false;
static BufferedReader bufferedReader(Reader r) {
  return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r), r);
}
static <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
  class IFF2 extends CloseableIterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
    
    public void close() throws Exception {
      if (closeable != null) closeable.close();
    }
  };
  return new IFF2();
}
static String readLineFromReaderWithClose(BufferedReader r) { try {
  String s = r.readLine();
  if (s == null) r.close();
  return s;
} catch (Exception __e) { throw rethrow(__e); } }
static AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
  return c == null ? null : new AutoCloseable() { public String toString() { return "c.close();\r\n    _registerIO(c, null, false);"; } public void close() throws Exception { 
    c.close();
    _registerIO(c, null, false);
  }};
}

static <A> A _registerIOWrap(A wrapper, Object wrapped) {
  return wrapper;
}
static FileInputStream newFileInputStream(File path) throws IOException {
  return newFileInputStream(path.getPath());
}

static FileInputStream newFileInputStream(String path) throws IOException {
  FileInputStream f = new FileInputStream(path);
  _registerIO(f, path, true);
  return f;
}
static Producer<String> javaTokC_noMLS_iterator(final String s) {
  return javaTokC_noMLS_iterator(s, 0);
}

static Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
  return new Producer<String>() {
    final int l = s.length();
    int i = startIndex;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}

static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
  final class X implements Producer<String> {
    StringBuilder buf = new StringBuilder(); // stores from "i"
    char c, d, e = 'x'; // just not '\0'
    
    X() {
      // fill c, d and e
      nc();
      nc();
      nc();
    }
    
    // get next character(s) into c, d and e
    void nc() { try {
      c = d;
      d = e;
      if (e == '\0') return;
      int i = r.read();
      e = i < 0 ? '\0'
        : i == '\0' ? '_' // shouldn't happen anymore
        : (char) i;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void ncSave() {
      if (c != '\0') {
        buf.append(c);
        nc();
      }
    }
    
    public String next() {
      // scan for whitespace
      while (c != '\0') {
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          nc();
        else if (c == '/' && d == '*') {
          do nc(); while (c != '\0' && !(c == '*' && d == '/'));
          nc(); nc();
        } else if (c == '/' && d == '/') {
          do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
        } else
          break;
      }
      
      if (c == '\0') return null;

      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ncSave();
        while (c != '\0') {
          if (c == opener || c == '\n') { // end at \n to not propagate unclosed string literal errors
            ncSave();
            break;
          } else if (c == '\\') {
            ncSave();
            ncSave();
          } else
            ncSave();
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\''); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ncSave(); while (Character.isDigit(c));
        if (c == 'L') ncSave(); // Long constants like 1L
      } else
        ncSave();
        
      String t = buf.toString();
      buf.setLength(0);
      return t;
    }
  }
  
  return new X();
}

static String unquoteUsingCharArray(String s, char[] buf) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      if (l > buf.length) return unquote(s); // fallback
      int n = 0;
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              char[] x = Character.toChars(code);
              int lx = x.length;
              for (int j = 0; j < lx; j++)
                buf[n++] = x[j];
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        buf[n++] = ch;
      }
      return new String(buf, 0, n);
    }
  }
    
  return s; // not quoted - return original
}
static boolean structure_isMarker(String s, int i, int j) {
  if (i >= j) return false;
  if (s.charAt(i) != 'm') return false;
  ++i;
  while (i < j) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static String internIfLongerThan(String s, int l) {
  return s == null ? null : l(s) >= l ? intern(s) : s;
}
static char unquoteCharacter(String s) {
  assertTrue(s.startsWith("'") && s.length() > 1);
  return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length()-1 : s.length()) + "\"").charAt(0);
}
static float parseFloat(String s) {
  return Float.parseFloat(s);
}
static boolean isLongConstant(String s) {
  if (!s.endsWith("L")) return false;
  s = s.substring(0, l(s)-1);
  return isInteger(s);
}
static List parseList(String s) {
  return (List) safeUnstructure(s);
}
static <A> List<A> synchroLinkedList() {
  return Collections.synchronizedList(new LinkedList<A>());
}

static SortedMap synchronizedTreeMap() {
  return synchroTreeMap();
}
static Map synchronizedMap() {
  return synchroMap();
}

static <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
  return synchroMap(map);
}
static byte[] hexToBytes(String s) {
  if (odd(l(s))) throw fail("Hex string has odd length: " + quote(shorten(10, s)));
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    int a = parseHexChar(s.charAt(i*2));
    int b = parseHexChar(s.charAt(i*2+1));
    if (a < 0 || b < 0)
      throw fail("Bad hex byte: " + quote(substring(s, i*2, i*2+2)) + " at " + i*2 + "/" + l(s));
    bytes[i] = (byte) ((a << 4) | b);
  }
  return bytes;
}
static boolean[] boolArrayFromBytes(byte[] a, int n) {
  boolean[] b = new boolean[n];
  int m = min(n, l(a)*8);
  for (int i = 0; i < m; i++)
    b[i] = (a[i/8] & 1 << (i & 7)) != 0;
  return b;
}
static <A> A nuStubInnerObject(Class<A> c) {
  return nuStubInnerObject(c, null);
}

static <A> A nuStubInnerObject(Class<A> c, Object classFinder) { try {
  Class outerType = getOuterClass(c, classFinder);
  Constructor m = c.getDeclaredConstructor(outerType);
  m.setAccessible(true);
  return (A) m.newInstance(new Object[] {null});
} catch (Exception __e) { throw rethrow(__e); } }
static Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

static <A> A nuEmptyObject(Class<A> c) { try {
  Constructor ctr;
  
  synchronized(nuEmptyObject_cache) {
    ctr = nuEmptyObject_cache.get(c);
    if (ctr == null) {
      nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
      ctr.setAccessible(true);
    }
  }

  try {
    return (A) ctr.newInstance();
  } catch (InstantiationException e) {
    if (empty(e.getMessage()))
      if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
        throw fail("Can't instantiate abstract class " + className(c), e);
      else
        throw fail("Can't instantiate " + className(c), e);  
    else throw rethrow(e);
  }
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuEmptyObject_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (m.getParameterTypes().length == 0)
      return m;
  throw fail("No default constructor declared in " + c.getName());
}

static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
  if (fields == null) return;
  HashMap<String, Field> fieldMap = instanceFieldsMap(o);
  for (Map.Entry<String, Object> e : fields.entrySet()) {
    String field = e.getKey();
    Object val = e.getValue();
    boolean has = fieldMap.containsKey(field);
    if (has)
      setOpt(o, field, val);
    else {
      o.fieldValues.put(intern(field), val);
      
    }
  }
}
static void setOptAll_pcall(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    try { setOpt(o, field, fields.get(field)); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
}

static void setOptAll_pcall(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    try { setOpt(o, field, value); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  }
}
static void pcallOpt_noArgs(Object o, String method) {
  try { callOpt_noArgs(o, method); } catch (Throwable __e) { _handleException(__e); }
}
static int[] toIntArray(List<Integer> l) {
  int[] a = new int[l(l)];
  for (int i = 0; i < a.length; i++)
    a[i] = l.get(i);
  return a;
}
static boolean jmatch(String pat, String s) {
  return jmatch(pat, s, null);
}

static boolean jmatch(String pat, String s, Matches matches) {
  if (s == null) return false;
  return jmatch(pat, javaTok(s), matches);
}

static boolean jmatch(String pat, List<String> toks) {
  return jmatch(pat, toks, null);
}

static boolean jmatch(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = javaTok(pat);
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}
static boolean warn_on = true;
static ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

static void warn(String s) {
  if (warn_on)
    print("Warning: " + s);
}

static void warn(String s, List<String> warnings) {
  warn(s);
  if (warnings != null)
    warnings.add(s);
  addToCollection(warn_warnings.get(), s);
}


static List<File> listFilesWithSuffix(File dir, String suffix) {
  List<File> l = new ArrayList();
  for (File f : listFiles(dir))
    if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
  return l;
}
static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}
static <A, B> Map<A, B> newWeakMap() {
  return newWeakHashMap();
}
static <A> WeakReference<A> newWeakReference(A a) {
  return a == null ? null : new WeakReference(a);
}
static <A extends Throwable> A printException(A e) {
  printStackTrace(e);
  return e;
}
static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static Class run(String progID, String... args) {
  Class main = hotwire(progID);
  callMain(main, args);
  return main;
}
static void restart() {
  Object j = getJavaX();
  call(j, "cleanRestart", get(j, "fullArgs"));
}
// f must return a list
static List concatMap(Object f, Iterable l) {
  return concatLists(map(f, l));
}

static List concatMap(Iterable l, Object f) {
  return concatMap(f, l);
}

static List concatMap(Object f, Object[] l) {
  return concatLists(map(f, l));
}

static List concatMap(Object[] l, Object f) {
  return concatMap(f, l);
}
static Object rcurry(final Object f, final Object arg) {
  int n = numberOfFunctionArguments(f);
  if (n == 0) throw fail("function takes no arguments");
  if (n == 1) return new F0() {
    Object get() {
      return callF(f, arg);
    }
  };
  if (n == 2)
    return new F1() {
      Object get(Object a) {
        return callF(f, a, arg);
      }
    };
  throw todo("currying a function with " + n + "arguments");
}
static String afterLastSpace(String s) {
  return s == null ? null : substring(s, s.lastIndexOf(' ')+1);
}
static String dropSuffixIgnoreCase(String suffix, String s) {
  return ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
  if (isCISet(c)) return (TreeSet) c;
  TreeSet<String> set = caseInsensitiveSet_treeSet();
  addAll(set, c);
  return set;
}

static TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
  TreeSet<String> set = caseInsensitiveSet_treeSet();
  addAll(set, x);
  return set;
}
static String snippetRawURL(String snippetID) {
  return snippetRawURL(snippetID, null);
}
  
static String snippetRawURL(String snippetID, String contentType) {
  return "https://www.botcompany.de:8443/serve/" + psI(snippetID) +
    htmlQuery("ct" , contentType);
}
static boolean possibleMD5(String s) { return isMD5(s); }
static Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
  if (l != null) for (Object f : cloneList(l))
    { Object __1420= pcallF(f, args); if (__1420 != null) return __1420; }
  return null;
}

static Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
  while (it.hasNext())
    { Object __1421= pcallF(it.next(), args); if (__1421 != null) return __1421; }
  return null;
}
static WeakReference<Object> creator_class;

static Object creator() {
  return creator_class == null ? null : creator_class.get();
}
static <A> A[] makeArray(Class<A> type, int n) {
  return (A[]) Array.newInstance(type, n);
}
static <A, B> void mapPut(Map<A, B> map, A key, B value) {
  if (map != null && key != null && value != null) map.put(key, value);
}
static Object[] toObjectArray(Collection c) {
  List l = asList(c);
  return l.toArray(new Object[l.size()]);
}

static <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
  if (map != null && key != null)
    if (value != null) return map.put(key, value);
    else return map.remove(key);
  return null;
}
static <A> Set<A> synchronizedSet() {
  return synchroHashSet();
}

static <A> Set<A> synchronizedSet(Set<A> set) {
  return Collections.synchronizedSet(set);
}
static <A> Set<A> identityHashSet() {
  return Collections.newSetFromMap(new IdentityHashMap());
}
static String multiLineQuote(String s) {
  for (int i = 0; ; i++) {
    String closer = "]" + rep('=', i) + "]";
    if (!contains(s, closer))
      return "[" + rep('=', i) + "[" + s + closer;
  }
}
static String quoteIfNotIdentifierOrInteger(String s) {
  if (s == null) return null;
  return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
}
static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}

static String _computerID;
static Lock computerID_lock = lock();

public static String computerID() {
  if (_computerID == null) {
    Lock __1435 = computerID_lock; lock(__1435); try {
    if (_computerID != null) return _computerID;
    File file = computerIDFile();
    _computerID = loadTextFile(file.getPath());
    if (_computerID == null) {
      // legacy load
      _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
      if (_computerID == null)
        _computerID = makeRandomID(12, new SecureRandom());
      saveTextFile(file, _computerID);
    }
  } finally { unlock(__1435); } }
  return _computerID;
}
static String joinNempties(String sep, String... strings) {
  return joinStrings(sep, strings);
}

static String joinNempties(String sep, Collection<String> strings) {
  return joinStrings(sep, strings);
}
static String stream2string(InputStream in) {
  return utf8streamToString(in);
}
static <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
  return tempSetThreadLocal(tl, a);
}
static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}
static Class<?> getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class getClass(Object o) {
  return o instanceof Class ? (Class) o : o.getClass();
}

static Class getClass(Object realm, String name) { try {
  try {
    return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static String classNameToVM(String name) {
  return name.replace(".", "$");
}
static List<String> tok_combineRoundOrCurlyBrackets_keep(List<String> tok) {
  List<String> l = new ArrayList();
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && eqOneOf(t, "{", "(")) {
      int j = findEndOfBracketPart(tok, i);
      l.add(joinSubList(tok, i, j));
      i = j-1;
    } else
      l.add(t);
  }
  return l;
}
static List<String> tok_splitAtSlash(String s) {
  return tok_splitAtSlash(javaTok(s));
}

static List<String> tok_splitAtSlash(List<String> tok) {
  List<String> l = new ArrayList();
  int i = 0;
  while (i < l(tok)) {
    if (i >= l(tok)) break;
    int j = indexOf(tok, "/", i);
    if (j < 0) j = l(tok);
    l.add(trimJoin(tok.subList(i, j)));
    i = j+1;
  }
  return l;
}
static <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
  return dropFirstAndLast(3, l);
}
static String javaTok_substringN(String s, int i, int j) {
  if (i == j) return "";
  if (j == i+1 && s.charAt(i) == ' ') return " ";
  return s.substring(i, j);
}
static List<String> javaTokWithExisting(String s, List<String> existing) {
  ++javaTok_n;
  int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
  ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    // Special JavaX syntax: 'identifier
    if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
      j += 2;
      while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
        ++j;
    } else if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
  return t.length() == j-i
    && s.regionMatches(i, t, 0, j-i); // << could be left out, but that's brave
}
static String tok_javaDropCommentsFromWhitespace(String s) {
  int l = l(s), j = 0;
  StringBuilder buf = new StringBuilder();
  while (j < l) {
    char c = s.charAt(j);
    char d = j+1 >= l ? '\0' : s.charAt(j+1);
    if (c == '/' && d == '*') {
      do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
      j = Math.min(j+2, l);
    } else if (c == '/' && d == '/') {
      do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
    } else {
      buf.append(c); ++j;
    }
  }
  return str(buf);
}
static List<String> replaceSubList(List<String> l, List<String> x, List<String> y) {
  return replaceSublist(l, x, y);
}

static <A> List<A> replaceSubList(List<A> l, int fromIndex, int toIndex, List<A> y) {
  return replaceSublist(l, fromIndex, toIndex, y);
}
static String renderStructs(Object... params) {
  List<String> l = new ArrayList();
  if (odd(l(params))) l.add(addSuffix(str(first(params)), ":"));
  for (int i = l(params) & 1; i+1 < l(params); i += 2)
    l.add(params[i] + "=" + sfu(params[i+1]));
  return joinWithSpace(l);
}


static class allSpreads_Data {
  int n;
  List<Integer> collecting;
}

static class allSpreads_StackEntry {
  int remaining, take;
  int position; // position in code
  
  Object step(List<allSpreads_StackEntry> stack, allSpreads_Data d) {
    //printStruct(stack);
    if (position == 0) {
      if (l(d.collecting) >= d.n-1) {
        List<Integer> result = listPlus(d.collecting, remaining);
        popLast(stack);
        return result;
      }
      position++;
    }
    if (position == 1) {
      if (take <= remaining) {
        d.collecting.add(take);
        allSpreads_StackEntry e = new allSpreads_StackEntry();
        e.remaining = remaining-take;
        stack.add(e);
        position++;
      } else
        popLast(stack);
    } else if (position == 2) {
      removeLast(d.collecting);
      take++;
      position = 1;
    }
    return null;
  }
}

static IterableIterator<List<Integer>> allSpreads(final int toSpread, final int buckets) {
  final allSpreads_Data d = new allSpreads_Data();
  d.n = buckets;
  d.collecting = new ArrayList();
  
  final List<allSpreads_StackEntry> stack = new ArrayList();
  allSpreads_StackEntry e = new allSpreads_StackEntry();
  e.remaining = toSpread;
  stack.add(e);
  
  return iff(new F0<Object>() { Object get() { try { 
    while (nempty(stack)) {
      ping();
      { Object __1471= last(stack).step(stack, d); if (__1471 != null) return __1471; }
    }
    return endMarker();
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "while (nempty(stack)) {\r\n      ping();\r\n      try object last(stack).step(sta..."; }});
}


static boolean match3(String pat, String s) {
  return match3(pat, s, null);
}

static boolean match3(String pat, String s, Matches matches) {
  if (pat == null || s == null) return false;
  return match3(pat, parse3_cachedInput(s), matches);
}
  
static boolean match3(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = parse3_cachedPattern(pat);
  return match3(tokpat, toks, matches);
}

static boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) matches.m = m; return true;
}
// i must point at the (possibly imaginary) opening bracket
// index returned is index of closing bracket + 1
static int findEndOfCurlyBracketPart(List<String> cnc, int i) {
  int j = i+2, level = 1;
  while (j < cnc.size()) {
    if (eq(cnc.get(j), "{")) ++level;
    else if (eq(cnc.get(j), "}")) --level;
    if (level == 0)
      return j+1;
    ++j;
  }
  return cnc.size();
}



static Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

static String[] javaTokForJFind_array(String s) {
  String[] tok = javaTokForJFind_array_cache.get(s);
  if (tok == null)
    javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
  return tok;
}


static int findCodeTokens(List<String> tok, String... tokens) {
  return findCodeTokens(tok, 1, false, tokens);
}

static int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, 1, ignoreCase, tokens);
}

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
}

static HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");
static boolean findCodeTokens_debug = false;
static int findCodeTokens_indexed, findCodeTokens_unindexed;
static int findCodeTokens_bails, findCodeTokens_nonbails;

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
  if (findCodeTokens_debug) {
    if (eq(getClassName(tok), "main$IndexedList2"))
      findCodeTokens_indexed++;
    else
      findCodeTokens_unindexed++;
  }
  
  int end = tok.size()-tokens.length*2+2, nTokens = tokens.length;
  int i = startIdx | 1;
  
  // bail out early if first token not found (works great with IndexedList)
  String firstToken = tokens[0];
  if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
    
    
    // quickly scan for first token
    while (i < end && !firstToken.equals(tok.get(i)))
      i += 2;
  }
  
  outer: for (; i < end; i += 2) {
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j], t = tok.get(i+j*2);
      boolean match = false;
      if (eq(p, "*")) match = true;
      else if (eq(p, "<quoted>")) match = isQuoted(t);
      else if (eq(p, "<id>")) match = isIdentifier(t);
      else if (eq(p, "<int>")) match = isInteger(t);
      else if (eq(p, "\\*")) match = eq("*", t);
      else match = ignoreCase ? eqic(p, t) : eq(p, t);
      
      if (!match)
        continue outer;
    }
    
    if (condition == null || checkTokCondition(condition, tok, i-1)) // pass N index
      return i;
  }
  return -1;
}
// "$1" is first code token, "$2" second code token etc.
static String jreplaceExpandRefs(String s, List<String> tokref) {
  List<String> tok = javaTok(s);
  for (int i = 1; i < l(tok); i += 2) {
    if (tok.get(i).startsWith("$") && isInteger(tok.get(i).substring(1))) {
      String x = tokref.get(-1+parseInt(tok.get(i).substring(1))*2);
      tok.set(i, x);
    }
  }
  return join(tok);
}

  static void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++)
      tok.set(i, "");
  }
  
  static void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++)
      tok.set(i, "");
  }
static List<String> reTok(List<String> tok) {
  replaceCollection(tok, javaTok(tok));
  return tok;
}

static List<String> reTok(List<String> tok, int i) {
  return reTok(tok, i, i+1);
}

static List<String> reTok(List<String> tok, int i, int j) {
  // extend i to an "N" token
  // and j to "C" (so j-1 is an "N" token)
  i = i & ~1;
  j = j | 1;
  
  List<String> t = javaTok(join(subList(tok, i, j)));
  replaceListPart(tok, i, j, t);
  
  // fallback to safety
  // reTok(tok);
  
  return tok;
}


static String quickSubstring(String s, int i, int j) {
  if (i == j) return "";
  return s.substring(i, j);
}
static NavigableMap synchroTreeMap() {
  return Collections.synchronizedNavigableMap(new TreeMap());
}

static int parseHexChar(char c) {
  if (c >= '0' && c <= '9') return charDiff(c, '0');
  if (c >= 'a' && c <= 'f') return charDiff(c, 'a')+10;
  if (c >= 'A' && c <= 'F') return charDiff(c, 'A')+10;
  return -1;
}
static Class getOuterClass(Class c) {
  return getOuterClass(c, null);
}

static Class getOuterClass(Class c, Object classFinder) { try {
  String s = c.getName();
  int i = s.lastIndexOf('$');
  String name = substring(s, 0, i);
  if (classFinder != null) return (Class) callF(classFinder, name);
  return Class.forName(name);
} catch (Exception __e) { throw rethrow(__e); } }
static HashMap<String, Field> instanceFieldsMap(Object o) {
  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map;
}

static Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

static Object callOpt_noArgs(Object o, String method) { try {
  if (o == null) return null;
  if (o instanceof Class)
    return callOpt(o, method); // not optimized
  
  Class c = o.getClass();
  HashMap<String, Method> map;
  synchronized(callOpt_noArgs_cache) {
    map = callOpt_noArgs_cache.get(c);
    if (map == null)
      map = callOpt_noArgs_makeCache(c);
  }

  Method m = map.get(method);
  return m != null ? m.invoke(o) : null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
  HashMap<String,Method> map = new HashMap();
  Class _c = c;
  do {
    for (Method m : c.getDeclaredMethods())
      if (m.getParameterTypes().length == 0 
        && !reflection_isForbiddenMethod(m)) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  callOpt_noArgs_cache.put(c, map);
  return map;
}
// match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)

static String[] match2(List<String> pat, List<String> tok) {
  // standard case (no ...)
  int i = pat.indexOf("...");
  if (i < 0) return match2_match(pat, tok);
  
  pat = new ArrayList<String>(pat); // We're modifying it, so copy first
  pat.set(i, "*");
  while (pat.size() < tok.size()) {
    pat.add(i, "*");
    pat.add(i+1, ""); // doesn't matter
  }
  
  return match2_match(pat, tok);
}

static String[] match2_match(List<String> pat, List<String> tok) {
  List<String> result = new ArrayList<String>();
  if (pat.size() != tok.size()) {
    
    return null;
  }
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(i);
    
    if (eq(p, "*"))
      result.add(t);
    else if (!equalsIgnoreCase(unquote(p), unquote(t))) // bold change - match quoted and unquoted now
      return null;
  }
  return result.toArray(new String[result.size()]);
}

static <A> boolean addToCollection(Collection<A> c, A a) {
  return c != null && c.add(a);
}


static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}
static Class<?> hotwire(String src) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    
    
    Class c =  (Class) (call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
    
  }
}
static <A> A callMain(A c, String... args) {
  callOpt(c, "main", new Object[] {args});
  return c;
}

static void callMain() {
  callMain(mc());
}
static int numberOfFunctionArguments(Object f) {
   if (f instanceof F0) return 0; 
   if (f instanceof F1) return 1; 
   if (f instanceof F2) return 2; 
   if (f instanceof VF1) return 1; 
   if (f instanceof VF2) return 2; 
   if (f instanceof VF3) return 3; 
  if (f instanceof String) return numberOfMethodArguments(mc(), (String) f);
  return numberOfMethodArguments(f, "get");
}
static boolean isMD5(String s) {
  return l(s) == 32 && isLowerHexString(s);
}
static <A> Set<A> synchroHashSet() {
  return Collections.synchronizedSet(new HashSet<A>());
}

static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  n = Math.max(n, 0);
  List<A> l = new ArrayList(n);
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}
static File computerIDFile() {
  return javaxDataDir("Basic Info/computer-id.txt");
}
static String joinStrings(String sep, String... strings) {
  return joinStrings(sep, Arrays.asList(strings));
}

static String joinStrings(String sep, Collection<String> strings) {
  StringBuilder buf = new StringBuilder();
  for (String s : unnull(strings)) if (nempty(s)) {
    if (nempty(buf)) buf.append(sep);
    buf.append(s);
  }
  return str(buf);
}
static String utf8streamToString(InputStream in) {
  return readerToString(utf8bufferedReader(in));
}
static <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
  if (tl == null) return null;
  final A prev = setThreadLocal(tl, a);
  return new AutoCloseable() { public String toString() { return "tl.set(prev);"; } public void close() throws Exception {  tl.set(prev); }};
}
static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}

static int lastIndexOf(String a, char b) {
  return a == null ? -1 : a.lastIndexOf(b);
}
// i must point at the (possibly imaginary) opening bracket (any of the 2 types, not type parameters)
// index returned is index of closing bracket + 1
static int findEndOfBracketPart(List<String> cnc, int i) {
  int j = i+2, level = 1;
  while (j < cnc.size()) {
    if (eqOneOf(cnc.get(j), "{", "(")) ++level;
    else if (eqOneOf(cnc.get(j), "}", ")")) --level;
    if (level == 0)
      return j+1;
    ++j;
  }
  return cnc.size();
}
static String trimJoin(List<String> s) {
  return trim(join(s));
}
static <A> List<A> dropFirstAndLast(int n, List<A> l) {
  return new ArrayList(subList(l, n, l(l)-n));
}

static <A> List<A> dropFirstAndLast(List<A> l) {
  return dropFirstAndLast(1, l);
}

static String dropFirstAndLast(String s) {
  return substring(s, 1, l(s)-1);
}
static <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
  if (x == null) return l;
  
  int i = 0;
  while (true) {
    i = indexOfSubList(l, x, i);
    if (i < 0) break;
    
    removeSubList(l, i, i+l(x));
    l.addAll(i, y);
    i += l(y);
  }
  return l;
}

static <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
  // TODO: optimize more
  removeSubList(l, fromIndex, toIndex);
  l.addAll(fromIndex, y);
  return l;
}


static void removeLast(List l) {
  if (!l.isEmpty())
    l.remove(l(l)-1);
}

static void removeLast(List l, int n) {
  removeSubList(l, l(l)-n, l(l));
}
// f: func -> A | endMarker
static <A> IterableIterator<A> iff(Object f) {
  return iteratorFromFunction_withEndMarker(f);
}

static <A> IterableIterator<A> iff(F0 f) {
  return iteratorFromFunction_withEndMarker(f);
}
static Object endMarker() {
  return iteratorFromFunction_endMarker;
}


static Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

static List<String> parse3_cachedInput(String s) {
  List<String> tok = parse3_cachedInput_cache.get(s);
  if (tok == null) parse3_cachedInput_cache.put(s, tok = parse3(s));
  return tok;
}




static Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

static synchronized List<String> parse3_cachedPattern(String s) {
  List<String> tok = parse3_cachedPattern_cache.get(s);
  if (tok == null) parse3_cachedPattern_cache.put(s, tok = parse3(s));
  return tok;
}


static <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
  return synchroMap(new MRUCache(maxSize));
}
static String[] codeTokensAsStringArray(List<String> tok) {
  int n = max(0, (l(tok)-1)/2);
  String[] out = new String[n];
  for (int i = 0; i < n; i++)
    out[i] = tok.get(i*2+1);
  return out;
}
static int jfind(String s, String in) {
  return jfind(javaTok(s), in);
}

static int jfind(List<String> tok, String in) {
  return jfind(tok, 1, in);
}

static int jfind(List<String> tok, int startIdx, String in) {
  return jfind(tok, startIdx, in, null);
}

static int jfind(List<String> tok, String in, Object condition) {
  return jfind(tok, 1, in, condition);
}

static int jfind(List<String> tok, int startIdx, String in, Object condition) {
  //LS tokin = jfind_preprocess(javaTok(in));
  return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
}

// assumes you preprocessed tokin
static int jfind(List<String> tok, List<String> tokin) {
  return jfind(tok, 1, tokin);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin) {
  return jfind(tok, startIdx, tokin, null);
}

static int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
  return findCodeTokens(tok, startIdx, false, tokinC, condition);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
  return findCodeTokens(tok, startIdx, false, codeTokensAsStringArray(tokin), condition);
}

static List<String> jfind_preprocess(List<String> tok) {
  for (String type : litlist("quoted", "id", "int"))
    replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
  replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
  return tok;
}
// supports the usual quotings (", variable length double brackets) except ' quoting
static boolean isQuoted(String s) {
  
  
  if (isNormalQuoted(s)) return true; // use the exact version
  
  return isMultilineQuoted(s);
}
static boolean checkTokCondition(Object condition, List<String> tok, int i) {
  if (condition instanceof TokCondition)
    return ((TokCondition) condition).get(tok, i);
  return checkCondition(condition, tok, i);
}
static <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
  dest.clear();
  dest.addAll(src);
}
static void replaceListPart(List l, int i, int j, List l2) {
  int j2 = i+l(l2);
  if (j2 == j)
    { copyListPart(l2, 0, l, i, l(l2)); return; }
  l.subList(i, j).clear();
  l.addAll(i, l2);
}
static int charDiff(char a, char b) {
  return (int) a-(int) b;
}

static int charDiff(String a, char b) {
  return charDiff(stringToChar(a), b);
}
static boolean reflection_isForbiddenMethod(Method m) {
  return m.getDeclaringClass() == Object.class
    && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
}


// requires ugly casting when used (O -> A)
static Object iteratorFromFunction_endMarker = new Object();

// f: func -> A | endMarker
static <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
  class IFF extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = (A) callF(f);
      if (a == iteratorFromFunction_endMarker)
        done = true;
    }
  };
  return new IFF();
}

// optimized version for F0 argument
static <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
  return iteratorFromFunction_withEndMarker_f0(f);
}
static boolean _inCore() {
  return false;
}
static List hotwire_copyOver_after = synchroList();

static void hotwire_copyOver(Class c) {
  // TODO: make a mechanism for making such "inheritable" fields
  for (String field : ll("print_log", "print_silent", "androidContext", "_userHome"))
    setOptIfNotNull(c, field, getOpt(mc(), field));
    
  
  
  setOptIfNotNull(c, "mainBot" , getMainBot());
  setOpt(c, "creator_class" , new WeakReference(mc()));
  pcallFAll(hotwire_copyOver_after, c);
}
static int numberOfMethodArguments(Object o, String method) {
  Class c;
  boolean mustBeStatic = false;
  if (o instanceof Class) {
    c = (Class) o;
    mustBeStatic = true;
  } else
    c = o.getClass();
      
  Class _c = c;
  int n = -1;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (!m.getName().equals(method)) continue;
      if (mustBeStatic && !methodIsStatic(m)) continue;
      int nn = l(m.getParameterTypes());
      if (n == -1) n = nn;
      else if (n != nn) throw fail("Variable number of method arguments: " + _c + "." + method);
    }
    c = c.getSuperclass();
  }
  if (n == -1) throw fail("Method not found: " + _c + "." + method);
  return n;
}
static boolean isLowerHexString(String s) {
  for (int i = 0; i < l(s); i++) {
    char c = s.charAt(i);
    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      // ok
    } else
      return false;
  }
  return true;
}
static String readerToString(Reader r) { try {
  try {
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      //if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  } finally {
    r.close();
  }  
} catch (Exception __e) { throw rethrow(__e); } }
static <A> int indexOfSubList(List<A> x, List<A> y) {
  return indexOfSubList(x, y, 0);
}

static <A> int indexOfSubList(List<A> x, List<A> y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y.get(j)))
        continue outer;
    return i;
  }
  return -1;
}

static <A> int indexOfSubList(List<A> x, A[] y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y[j]))
        continue outer;
    return i;
  }
  return -1;
}
static void removeSubList(List l, int from, int to) {
  if (l != null) subList(l, from, to).clear();
}

static void removeSubList(List l, int from) {
  if (l != null) subList(l, from).clear();
}
static List<String> parse3(String s) {
  return dropPunctuation(javaTokPlusPeriod(s));
}
static <A> ArrayList<A> litlist(A... a) {
  ArrayList l = new ArrayList(a.length);
  for (A x : a) l.add(x);
  return l;
}
static boolean isNormalQuoted(String s) {
  int l = l(s);
  if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"')) return false;
  int j = 1;
  while (j < l)
    if (s.charAt(j) == '"')
      return j == l-1;
    else if (s.charAt(j) == '\\' && j+1 < l)
      j += 2;
    else
      ++j;
  return false;
}
static boolean isMultilineQuoted(String s) {
  if (!startsWith(s, "[")) return false;
  int i = 1;
  while (i < s.length() && s.charAt(i) == '=') ++i;
  return i < s.length() && s.charAt(i) == '[';
}
static <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
  if (a == null || b == null) return;
  for (int i = 0; i < n; i++)
    b.set(i2+i, a.get(i1+i));
}
static char stringToChar(String s) {
  if (l(s) != 1) throw fail("bad stringToChar: " + s);
  return firstChar(s);
}


static <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
  class IFF2 extends IterableIterator<A> {
    A a;
    boolean have, done;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      have = false;
      return _a;
    }
    
    void getNext() {
      if (done || have) return;
      a = f.get();
      have = true;
      if (a == iteratorFromFunction_endMarker)
        done = true;
    }
  };
  return new IFF2();
}
static void setOptIfNotNull(Object o, String field, Object value) {
  if (value != null) setOpt(o, field, value);
}
static List<String> dropPunctuation_keep = ll("*", "<", ">");

static List<String> dropPunctuation(List<String> tok) {
  tok = new ArrayList<String>(tok);
  for (int i = 1; i < tok.size(); i += 2) {
    String t = tok.get(i);
    if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
      tok.set(i-1, tok.get(i-1) + tok.get(i+1));
      tok.remove(i);
      tok.remove(i);
      i -= 2;
    }
  }
  return tok;
}

static String dropPunctuation(String s) {
  return join(dropPunctuation(nlTok(s)));
}
// This is made for NL parsing.
// It's javaTok extended with "..." token, "$n" and "#n" and
// special quotes (which are converted to normal ones).

static List<String> javaTokPlusPeriod(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    cc = s.substring(i, Math.min(i+2, l));

    // scan for non-whitespace
    if (c == (char) 0x201C || c == (char) 0x201D) c = '"'; // normalize quotes
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        char _c = s.charAt(j);
        if (_c == (char) 0x201C || _c == (char) 0x201D) _c = '"'; // normalize quotes
        if (_c == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
      if (j-1 >= i+1) {
        tok.add(opener + s.substring(i+1, j-1) + opener);
        i = j;
        continue;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for things like "this one's"
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else if (cc.equals("[[")) {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (cc.equals("[=") && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else if (s.substring(j, Math.min(j+3, l)).equals("..."))
      j += 3;
    else if (c == '$' || c == '#')
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}

static char firstChar(String s) {
  return s.charAt(0);
}


static List<String> nlTok(String s) {
  return javaTokPlusPeriod(s);
}


// immutable, has strong refs
final static class _MethodCache {
  final Class c;
  final HashMap<String, List<Method>> cache = new HashMap();
  
  _MethodCache(Class c) {
  this.c = c; _init(); }
  
  void _init() {
    Class _c = c;
    while (_c != null) {
      for (Method m : _c.getDeclaredMethods())
        if (!reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
      _c = _c.getSuperclass();
    }
    
    // add default methods - this might lead to a duplication
    // because the overridden method is also added, but it's not
    // a problem except for minimal performance loss.
    for (Class intf : allInterfacesImplementedBy(c))
      for (Method m : intf.getDeclaredMethods())
        if (m.isDefault() && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));

    
  }
  
  // Returns only matching methods
  Method findMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
    
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Method findStaticMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (isStaticMethod(me) && call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
}static abstract class VF1<A> implements IVF1<A> {
  public abstract void get(A a);
}static abstract class VF3<A, B, C> {
  abstract void get(A a, B b, C c);
}static abstract class VF2<A, B> {
  abstract void get(A a, B b);
}static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  String fsi(int i) { return formatSnippetID(unq(i)); }
  String fsi() { return fsi(0); }
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
  
  public String toString() { return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")"; }
  
  public int hashCode() { return _hashCode(toList(m)); }
  public boolean equals(Object o) { return o instanceof Matches && arraysEqual(m, ((Matches) o).m); }
}
static class Var<A> implements IVar<A> {
  Var() {}
  Var(A v) {
  this.v = v;}

  
  A v; // you can access this directly if you use one thread
  
  public synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  public synchronized A get() { return v; }
  public synchronized boolean has() { return v != null; }
  public synchronized void clear() { v = null; }
  
  public String toString() { return str(get()); }
}static class DefunctClassLoader {}// not changed yet: allow cookie to be read right after being set


















static boolean NanoHTTPD_debug = false;

static abstract class NanoHTTPD implements AutoCloseable {

    boolean decodePercentInURI = false; // I set this to false, makes more sense to me
    boolean noQueryStringParameter = true;

    static ThreadLocal<IHTTPSession> currentSession = new ThreadLocal<IHTTPSession>();
    
    static List<IHTTPSession> badClients = synchroList();

    /**
     * Pluggable strategy for asynchronously executing requests.
     */
    public interface AsyncRunner {

        void closeAll();

        void closed(ClientHandler clientHandler);

        void exec(ClientHandler code);
    }

    /**
     * The runnable that will be used for every new client connection.
     */
    public class ClientHandler implements Runnable {

        private final InputStream inputStream;

        final Socket acceptSocket;

        private ClientHandler(InputStream inputStream, Socket acceptSocket) {
            this.inputStream = inputStream;
            this.acceptSocket = acceptSocket;
        }

        public void close() {
            safeClose(this.inputStream);
            safeClose(this.acceptSocket);
        }

        @Override
        public void run() {
            OutputStream outputStream = null;
            try {
                //outputStream = wrapStuff("SocketOutputStream", this.acceptSocket.getOutputStream(), this.acceptSocket);
                outputStream = this.acceptSocket.getOutputStream();
                TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
                HTTPSession session = new HTTPSession(tempFileManager, this.inputStream, outputStream, this.acceptSocket.getInetAddress());
                while (!this.acceptSocket.isClosed() && !session.badClient) {
                    session.execute();
                }
            } catch (Exception e) {
                // When the socket is closed by the client,
                // we throw our own SocketException
                // to break the "keep alive" loop above. If
                // the exception was anything other
                // than the expected SocketException OR a
                // SocketTimeoutException, print the
                // stacktrace
                if (!(e instanceof SocketException && "NanoHttpd Shutdown".equals(e.getMessage())) && !(e instanceof SocketTimeoutException)) {
                    NanoHTTPD.LOG.log(Level.FINE, "Communication with the client broken", e);
                }
            } finally {
                safeClose(outputStream);
                safeClose(this.inputStream);
                safeClose(this.acceptSocket);
                NanoHTTPD.this.asyncRunner.closed(this);
            }
        }
    }

    public static class Cookie {

        public static String getHTTPTime(int days) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.add(Calendar.DAY_OF_MONTH, days);
            return dateFormat.format(calendar.getTime());
        }

        final String n, v, e;
        String domain;

        public Cookie(String name, String value) {
            this(name, value, 30);
        }

        public Cookie(String name, String value, int numDays) {
            this.n = name;
            this.v = value;
            this.e = getHTTPTime(numDays);
        }

        public Cookie(String name, String value, String expires) {
            this.n = name;
            this.v = value;
            this.e = expires;
        }

        public String getHTTPHeader() {
          StringBuilder buf = new StringBuilder();
            buf.append(n).append("=").append(v).append("; expires=").append(e);
          if (nempty(domain)) buf.append("; Domain=").append(domain);
          return buf.toString();
        }
    }

    /**
     * Provides rudimentary support for cookies. Doesn't support 'path',
     * 'secure' nor 'httpOnly'. Feel free to improve it and/or add unsupported
     * features.
     * 
     * @author LordFokas
     */
    public class CookieHandler implements Iterable<String> {

        private final HashMap<String, String> cookies = new HashMap<String, String>();

        private final ArrayList<Cookie> queue = new ArrayList<Cookie>();

        public CookieHandler(Map<String, String> httpHeaders) {
            String raw = httpHeaders.get("cookie");
            if (raw != null) {
                String[] tokens = raw.split(";");
                for (String token : tokens) {
                    String[] data = token.trim().split("=");
                    if (data.length == 2) {
                        this.cookies.put(data[0], data[1]);
                    }
                }
            }
        }

        /**
         * Set a cookie with an expiration date from a month ago, effectively
         * deleting it on the client side.
         * 
         * @param name
         *            The cookie name.
         */
        public void delete(String name) {
            set(name, "-delete-", -30);
        }

        @Override
        public Iterator<String> iterator() {
            return this.cookies.keySet().iterator();
        }

        /**
         * Read a cookie from the HTTP Headers.
         * 
         * @param name
         *            The cookie's name.
         * @return The cookie's value if it exists, null otherwise.
         */
        public String read(String name) {
            return this.cookies.get(name);
        }

        public void set(Cookie cookie) {
            this.queue.add(cookie);
            //cookies.put(cookie.n, cookie.v); // CHANGED
        }

        /**
         * Sets a cookie.
         * 
         * @param name
         *            The cookie's name.
         * @param value
         *            The cookie's value.
         * @param expires
         *            How many days until the cookie expires.
         */
        public Cookie set(String name, String value, int expires) {
            return addAndReturn(this.queue, new Cookie(name, value, Cookie.getHTTPTime(expires)));
        }

        /**
         * Internally used by the webserver to add all queued cookies into the
         * Response's HTTP Headers.
         * 
         * @param response
         *            The Response object to which headers the queued cookies
         *            will be added.
         */
        public void unloadQueue(Response response) {
            for (Cookie cookie : this.queue) {
                response.addHeader("Set-Cookie", cookie.getHTTPHeader());
            }
        }
    }

    /**
     * Default threading strategy for NanoHTTPD.
     * <p/>
     * <p>
     * By default, the server spawns a new Thread for every incoming request.
     * These are set to <i>daemon</i> status, and named according to the request
     * number. The name is useful when profiling the application.
     * </p>
     */
    public static class DefaultAsyncRunner implements AsyncRunner {

        private long requestCount;

        private final List<ClientHandler> running = Collections.synchronizedList(new ArrayList<NanoHTTPD.ClientHandler>());

        /**
         * @return a list with currently running clients.
         */
        public List<ClientHandler> getRunning() {
            return running;
        }

        @Override
        public void closeAll() {
            // copy of the list for concurrency
            for (ClientHandler clientHandler : new ArrayList<ClientHandler>(this.running)) {
                clientHandler.close();
            }
        }

        @Override
        public void closed(ClientHandler clientHandler) {
            this.running.remove(clientHandler);
        }

        @Override
        public void exec(ClientHandler clientHandler) {
            ++this.requestCount;
            Thread t = new Thread(clientHandler);
            //t.setDaemon(true);
            String clientIP = "?";
            try { clientIP = clientHandler.acceptSocket.getInetAddress().getHostAddress().toString(); } catch (Throwable __e) { _handleException(__e); }
            t.setName("NanoHttpd serving request #" + this.requestCount + " to " + clientIP);
            this.running.add(clientHandler);
            t.start();
        }
    }

    /**
     * Default strategy for creating and cleaning up temporary files.
     * <p/>
     * <p>
     * By default, files are created by <code>File.createTempFile()</code> in
     * the directory specified.
     * </p>
     */
    public static class DefaultTempFile implements TempFile {

        private final File file;

        private final OutputStream fstream;

        public DefaultTempFile(String tempdir) throws IOException {
            this.file = File.createTempFile("NanoHTTPD-", "", new File(tempdir));
            this.fstream = new FileOutputStream(this.file);
            System.err.println("Temp file created: " + file);
        }

        @Override
        public void delete() throws Exception {
            safeClose(this.fstream);
            System.err.println("Temp file deleted: " + file);
            if (!this.file.delete()) {
                throw new Exception("could not delete temporary file");
            }
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public OutputStream open() throws Exception {
            return this.fstream;
        }
    }

    /**
     * Default strategy for creating and cleaning up temporary files.
     * <p/>
     * <p>
     * This class stores its files in the standard location (that is, wherever
     * <code>java.io.tmpdir</code> points to). Files are added to an internal
     * list, and deleted when no longer needed (that is, when
     * <code>clear()</code> is invoked at the end of processing a request).
     * </p>
     */
    public static class DefaultTempFileManager implements TempFileManager {

        private final String tmpdir;

        private final List<TempFile> tempFiles;

        public DefaultTempFileManager() {
            this.tmpdir = tempDir().getPath(); // use JavaX, dude
              // System.getProperty("java.io.tmpdir");
            this.tempFiles = new ArrayList<TempFile>();
        }

        @Override
        public void clear() {
            for (TempFile file : this.tempFiles) {
                try {
                    file.delete();
                } catch (Exception ignored) {
                    NanoHTTPD.LOG.log(Level.WARNING, "could not delete file ", ignored);
                }
            }
            this.tempFiles.clear();
        }

        @Override
        public TempFile createTempFile() throws Exception {
            DefaultTempFile tempFile = new DefaultTempFile(this.tmpdir);
            this.tempFiles.add(tempFile);
            return tempFile;
        }
    }

    /**
     * Default strategy for creating and cleaning up temporary files.
     */
    private class DefaultTempFileManagerFactory implements TempFileManagerFactory {

        @Override
        public TempFileManager create() {
            return new DefaultTempFileManager();
        }
    }

    private static final String CONTENT_DISPOSITION_REGEX = "([ |\t]*Content-Disposition[ |\t]*:)(.*)";

    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile(CONTENT_DISPOSITION_REGEX, Pattern.CASE_INSENSITIVE);

    private static final String CONTENT_TYPE_REGEX = "([ |\t]*content-type[ |\t]*:)(.*)";

    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile(CONTENT_TYPE_REGEX, Pattern.CASE_INSENSITIVE);

    private static final String CONTENT_DISPOSITION_ATTRIBUTE_REGEX = "[ |\t]*([a-zA-Z]*)[ |\t]*=[ |\t]*['|\"]([^\"^']*)['|\"]";

    private static final Pattern CONTENT_DISPOSITION_ATTRIBUTE_PATTERN = Pattern.compile(CONTENT_DISPOSITION_ATTRIBUTE_REGEX);

    class HTTPSession implements IHTTPSession {
    
        boolean badClient = false;
        
        long opened = sysNow();

        public static final int BUFSIZE = 8192;

        private final TempFileManager tempFileManager;

        private final OutputStream outputStream;

        private final PushbackInputStream inputStream;

        private int splitbyte;

        private int rlen;

        private String uri;

        private Method method;

        private Map<String, String> parms;

        private Map<String, String> headers;

        Map<String, String> files = new HashMap();
        
        private CookieHandler cookies;

        private String queryParameterString;

        private String remoteIp;

        private String protocolVersion;

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new PushbackInputStream(inputStream, HTTPSession.BUFSIZE);
            this.outputStream = outputStream;
        }

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
            this.tempFileManager = tempFileManager;
            this.inputStream = new PushbackInputStream(inputStream, HTTPSession.BUFSIZE);
            this.outputStream = outputStream;
            this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
            this.headers = new LinkedHashMap<String, String>();
        }
        
        public void badClient(boolean b) { badClient = b; }

        /**
         * Decodes the sent headers and loads the data into Key/value pairs
         */
        private void decodeHeader(BufferedReader in, Map<String, String> pre, Map<String, String> parms, Map<String, String> headers, Map<String, String> files) throws ResponseException {
            try {
                // Read the request line
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }

                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }

                pre.put("method", st.nextToken());

                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }

                String uri = st.nextToken();

                // Decode parameters from the URI
                int qmi = uri.indexOf('?');
                if (qmi >= 0) {
                    String query = uri.substring(qmi + 1);
                    files.put("query", query);
                    decodeParms(query, parms);
                    uri = uri.substring(0, qmi);
                }
                
                if (decodePercentInURI)
                  uri = decodePercent(uri);

                // If there's another token, its protocol version,
                // followed by HTTP headers.
                // NOTE: this now forces header names lower case since they are
                // case insensitive and vary by client.
                if (st.hasMoreTokens()) {
                    protocolVersion = st.nextToken();
                } else {
                    protocolVersion = "HTTP/1.1";
                    NanoHTTPD.LOG.log(Level.FINE, "no protocol version specified, strange. Assuming HTTP/1.1.");
                }
                String line = in.readLine();
                while (line != null && line.trim().length() > 0) {
                    int p = line.indexOf(':');
                    if (p >= 0) {
                        headers.put(line.substring(0, p).trim().toLowerCase(Locale.US), line.substring(p + 1).trim());
                    }
                    line = in.readLine();
                }

                pre.put("uri", uri);
            } catch (IOException ioe) {
                throw new ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
            }
        }

        /**
         * Decodes the Multipart Body data and put it into Key/Value pairs.
         */
        private void decodeMultipartFormData(String boundary, ByteBuffer fbuf, Map<String, String> parms, Map<String, String> files) throws ResponseException {
            try {
                int[] boundary_idxs = getBoundaryPositions(fbuf, boundary.getBytes());
                if (boundary_idxs.length < 2) {
                    throw new ResponseException(
                    Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but contains less than two boundary strings.");
                }

                final int MAX_HEADER_SIZE = 1024;
                byte[] part_header_buff = new byte[MAX_HEADER_SIZE];
                for (int bi = 0; bi < boundary_idxs.length - 1; bi++) {
                    fbuf.position(boundary_idxs[bi]);
                    int len = (fbuf.remaining() < MAX_HEADER_SIZE) ? fbuf.remaining() : MAX_HEADER_SIZE;
                    fbuf.get(part_header_buff, 0, len);
                    ByteArrayInputStream bais = new ByteArrayInputStream(part_header_buff, 0, len);
                    BufferedReader in = new BufferedReader(new InputStreamReader(bais, Charset.forName("US-ASCII")));

                    // First line is boundary string
                    String mpline = in.readLine();
                    if (!mpline.contains(boundary)) {
                        throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but chunk does not start with boundary.");
                    }

                    String part_name = null, file_name = null, content_type = null;
                    // Parse the reset of the header lines
                    mpline = in.readLine();
                    while (mpline != null && mpline.trim().length() > 0) {
                        Matcher matcher = CONTENT_DISPOSITION_PATTERN.matcher(mpline);
                        if (matcher.matches()) {
                            String attributeString = matcher.group(2);
                            matcher = CONTENT_DISPOSITION_ATTRIBUTE_PATTERN.matcher(attributeString);
                            while (matcher.find()) {
                                String key = matcher.group(1);
                                if (key.equalsIgnoreCase("name")) {
                                    part_name = matcher.group(2);
                                } else if (key.equalsIgnoreCase("filename")) {
                                    file_name = matcher.group(2);
                                }
                            }
                        }
                        matcher = CONTENT_TYPE_PATTERN.matcher(mpline);
                        if (matcher.matches()) {
                            content_type = matcher.group(2).trim();
                        }
                        mpline = in.readLine();
                    }

                    // Read the part data
                    int part_header_len = len - (int) in.skip(MAX_HEADER_SIZE);
                    if (part_header_len >= len - 4) {
                        throw new ResponseException(Status.INTERNAL_ERROR, "Multipart header size exceeds MAX_HEADER_SIZE.");
                    }
                    int part_data_start = boundary_idxs[bi] + part_header_len;
                    int part_data_end = boundary_idxs[bi + 1] - 4;

                    fbuf.position(part_data_start);
                    if (content_type == null) {
                        // Read the part into a string
                        byte[] data_bytes = new byte[part_data_end - part_data_start];
                        fbuf.get(data_bytes);
                        parms.put(part_name, new String(data_bytes));
                    } else {
                        // Read it into a file
                        String path = saveTmpFile(fbuf, part_data_start, part_data_end - part_data_start);
                        if (!files.containsKey(part_name)) {
                            files.put(part_name, path);
                        } else {
                            int count = 2;
                            while (files.containsKey(part_name + count)) {
                                count++;
                            }
                            files.put(part_name + count, path);
                        }
                        parms.put(part_name, file_name);
                    }
                }
            } catch (ResponseException re) {
                throw re;
            } catch (Exception e) {
                throw new ResponseException(Status.INTERNAL_ERROR, e.toString());
            }
        }

        /**
         * Decodes parameters in percent-encoded URI-format ( e.g.
         * "name=Jack%20Daniels&pass=Single%20Malt" ) and adds them to given
         * Map. NOTE: this doesn't support multiple identical keys due to the
         * simplicity of Map.
         */
        private void decodeParms(String parms, Map<String, String> p) {
            if (parms == null) {
                this.queryParameterString = "";
                return;
            }

            this.queryParameterString = parms;
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf('=');
                if (sep >= 0) {
                    p.put(decodePercent(e.substring(0, sep)).trim(), decodePercent(e.substring(sep + 1)));
                } else {
                    p.put(decodePercent(e).trim(), "");
                }
            }
        }

        @Override
        public void execute() throws IOException {
            Response r = null;
            try {
                // Read the first 8192 bytes.
                // The full header should fit in here.
                // Apache's default header limit is 8KB.
                // Do NOT assume that a single read will get the entire header
                // at once!
                byte[] buf = new byte[HTTPSession.BUFSIZE];
                this.splitbyte = 0;
                this.rlen = 0;

                int read = -1;
                try {
                    read = this.inputStream.read(buf, 0, HTTPSession.BUFSIZE);
                } catch (Exception e) {
                    safeClose(this.inputStream);
                    safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                if (read == -1) {
                    // socket was been closed
                    safeClose(this.inputStream);
                    safeClose(this.outputStream);
                    throw new SocketException("NanoHttpd Shutdown");
                }
                while (read > 0) {
                    this.rlen += read;
                    if (rlen >= buf.length) throw fail("Header too big (" + rlen + " bytes)");
                    this.splitbyte = findHeaderEnd(buf, this.rlen);
                    if (this.splitbyte > 0) {
                        break;
                    }
                    read = this.inputStream.read(buf, this.rlen, HTTPSession.BUFSIZE - this.rlen);
                }

                if (this.splitbyte < this.rlen) {
                    this.inputStream.unread(buf, this.splitbyte, this.rlen - this.splitbyte);
                }

                this.parms = new HashMap<String, String>();
                if (null == this.headers) {
                    this.headers = new HashMap<String, String>();
                } else {
                    this.headers.clear();
                }

                if (null != this.remoteIp) {
                    this.headers.put("remote-addr", this.remoteIp);
                    this.headers.put("http-client-ip", this.remoteIp);
                }

                // Create a BufferedReader for parsing the header.
                BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.rlen)));

                // Decode the header into parms and header java properties
                Map<String, String> pre = new LinkedHashMap<String, String>();
                decodeHeader(hin, pre, this.parms, this.headers, this.files);

                this.method = Method.lookup(pre.get("method"));
                if (this.method == null) {
                    throw new ResponseException(Status.BAD_REQUEST, "BAD REQUEST: Syntax error.");
                }

                this.uri = pre.get("uri");

                this.cookies = new CookieHandler(this.headers);

                String connection = this.headers.get("connection");
                boolean keepAlive = protocolVersion.equals("HTTP/1.1") && (connection == null || !connection.matches("(?i).*close.*"));

                // Ok, now do the serve()
                r = serve(this);
                
                if (badClient) return;
                
                if (r == null) {
                    throw new ResponseException(Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                } else {
                    String acceptEncoding = this.headers.get("accept-encoding");
                    this.cookies.unloadQueue(r);
                    r.setRequestMethod(this.method);
                    r.setGzipEncoding(useGzipWhenAccepted(r) && acceptEncoding != null && acceptEncoding.contains("gzip"));
                    r.setKeepAlive(keepAlive);
                    r.send(this.outputStream);
                }
                if (!keepAlive || "close".equalsIgnoreCase(r.getHeader("connection"))) {
                    throw new SocketException("NanoHttpd Shutdown");
                }
            } catch (SocketException e) {
                // throw it out to close socket object (finalAccept)
                throw e;
            } catch (SocketTimeoutException ste) {
                // treat socket timeouts the same way we treat socket exceptions
                // i.e. close the stream & finalAccept object by throwing the
                // exception up the call stack.
                throw ste;
            } catch (IOException ioe) {
                Response resp = newFixedLengthResponse(Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                resp.send(this.outputStream);
                safeClose(this.outputStream);
            } catch (ResponseException re) {
                Response resp = newFixedLengthResponse(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
                resp.send(this.outputStream);
                safeClose(this.outputStream);
            } finally {
              if (badClient)
                badClients.add(this);
              else
                safeClose(r);
              this.tempFileManager.clear();
            }
        }

        /**
         * Find byte index separating header from body. It must be the last byte
         * of the first two sequential new lines.
         */
        private int findHeaderEnd(final byte[] buf, int rlen) {
            int splitbyte = 0;
            while (splitbyte + 3 < rlen) {
                if (buf[splitbyte] == '\r' && buf[splitbyte + 1] == '\n' && buf[splitbyte + 2] == '\r' && buf[splitbyte + 3] == '\n') {
                    return splitbyte + 4;
                }
                splitbyte++;
            }
            return 0;
        }

        /**
         * Find the byte positions where multipart boundaries start. This reads
         * a large block at a time and uses a temporary buffer to optimize
         * (memory mapped) file access.
         */
        private int[] getBoundaryPositions(ByteBuffer b, byte[] boundary) {
            int[] res = new int[0];
            if (b.remaining() < boundary.length) {
                return res;
            }

            int search_window_pos = 0;
            byte[] search_window = new byte[4 * 1024 + boundary.length];

            int first_fill = (b.remaining() < search_window.length) ? b.remaining() : search_window.length;
            b.get(search_window, 0, first_fill);
            int new_bytes = first_fill - boundary.length;

            do {
                // Search the search_window
                for (int j = 0; j < new_bytes; j++) {
                    for (int i = 0; i < boundary.length; i++) {
                        if (search_window[j + i] != boundary[i])
                            break;
                        if (i == boundary.length - 1) {
                            // Match found, add it to results
                            int[] new_res = new int[res.length + 1];
                            System.arraycopy(res, 0, new_res, 0, res.length);
                            new_res[res.length] = search_window_pos + j;
                            res = new_res;
                        }
                    }
                }
                search_window_pos += new_bytes;

                // Copy the end of the buffer to the start
                System.arraycopy(search_window, search_window.length - boundary.length, search_window, 0, boundary.length);

                // Refill search_window
                new_bytes = search_window.length - boundary.length;
                new_bytes = (b.remaining() < new_bytes) ? b.remaining() : new_bytes;
                b.get(search_window, boundary.length, new_bytes);
            } while (new_bytes > 0);
            return res;
        }

        @Override
        public CookieHandler getCookies() {
            return this.cookies;
        }

        @Override
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final Map<String, String> getFiles() {
            return this.files;
        }

        @Override
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public final Method getMethod() {
            return this.method;
        }

        @Override
        public final Map<String, String> getParms() {
            return this.parms;
        }

        @Override
        public String getQueryParameterString() {
            return this.queryParameterString;
        }

        private RandomAccessFile getTmpBucket() {
            try {
                TempFile tempFile = this.tempFileManager.createTempFile();
                return new RandomAccessFile(tempFile.getName(), "rw");
            } catch (Exception e) {
                throw new Error(e); // we won't recover, so throw an error
            }
        }

        @Override
        public final String getUri() {
            return this.uri;
        }

        @Override
        public void parseBody() throws IOException, ResponseException {
            final int REQUEST_BUFFER_LEN = 512;
            final int MEMORY_STORE_LIMIT = 1024;
            RandomAccessFile randomAccessFile = null;
            try {
                long size;
                if (this.headers.containsKey("content-length")) {
                    size = Integer.parseInt(this.headers.get("content-length"));
                } else if (this.splitbyte < this.rlen) {
                    size = this.rlen - this.splitbyte;
                } else {
                    size = 0;
                }

                ByteArrayOutputStream baos = null;
                DataOutput request_data_output = null;

                // Store the request in memory or a file, depending on size
                if (size < MEMORY_STORE_LIMIT) {
                    baos = new ByteArrayOutputStream();
                    request_data_output = new DataOutputStream(baos);
                } else {
                    randomAccessFile = getTmpBucket();
                    request_data_output = randomAccessFile;
                }

                // Read all the body and write it to request_data_output
                byte[] buf = new byte[REQUEST_BUFFER_LEN];
                while (this.rlen >= 0 && size > 0) {
                    this.rlen = this.inputStream.read(buf, 0, (int) Math.min(size, REQUEST_BUFFER_LEN));
                    size -= this.rlen;
                    if (this.rlen > 0) {
                        request_data_output.write(buf, 0, this.rlen);
                    }
                }

                ByteBuffer fbuf = null;
                if (baos != null) {
                    fbuf = ByteBuffer.wrap(baos.toByteArray(), 0, baos.size());
                } else {
                    fbuf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0, randomAccessFile.length());
                    randomAccessFile.seek(0);
                }

                // If the method is POST, there may be parameters
                // in data section, too, read it:
                if (Method.POST.equals(this.method)) {
                    String contentType = "";
                    String contentTypeHeader = this.headers.get("content-type");

                    StringTokenizer st = null;
                    if (contentTypeHeader != null) {
                        st = new StringTokenizer(contentTypeHeader, ",; ");
                        if (st.hasMoreTokens()) {
                            contentType = st.nextToken();
                        }
                    }

                    if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                        // Handle multipart/form-data
                        if (!st.hasMoreTokens()) {
                            throw new ResponseException(Status.BAD_REQUEST,
                                    "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                        }

                        String boundaryStartString = "boundary=";
                        int boundaryContentStart = contentTypeHeader.indexOf(boundaryStartString) + boundaryStartString.length();
                        String boundary = contentTypeHeader.substring(boundaryContentStart, contentTypeHeader.length());
                        if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
                            boundary = boundary.substring(1, boundary.length() - 1);
                        }

                        decodeMultipartFormData(boundary, fbuf, this.parms, files);
                    } else {
                        byte[] postBytes = new byte[fbuf.remaining()];
                        if (NanoHTTPD_debug)
                          print("NanoHTTPD: Handling POST data (" + l(postBytes) + " bytes)");
                        fbuf.get(postBytes);
                        String postLine = new String(postBytes).trim();
                        // Handle application/x-www-form-urlencoded
                        if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                            decodeParms(postLine, this.parms);
                        } else if (postLine.length() != 0) {
                            // Special case for raw POST data => create a
                            // special files entry "postData" with raw content
                            // data
                            files.put("postData", postLine);
                        }
                    }
                } else if (Method.PUT.equals(this.method)) {
                    files.put("content", saveTmpFile(fbuf, 0, fbuf.limit()));
                }
            } finally {
                safeClose(randomAccessFile);
            }
        }

        /**
         * Retrieves the content of a sent file and saves it to a temporary
         * file. The full path to the saved file is returned.
         */
        private String saveTmpFile(ByteBuffer b, int offset, int len) {
            String path = "";
            if (len > 0) {
                FileOutputStream fileOutputStream = null;
                try {
                    TempFile tempFile = this.tempFileManager.createTempFile();
                    ByteBuffer src = b.duplicate();
                    fileOutputStream = new FileOutputStream(tempFile.getName());
                    FileChannel dest = fileOutputStream.getChannel();
                    src.position(offset).limit(offset + len);
                    dest.write(src.slice());
                    path = tempFile.getName();
                } catch (Exception e) { // Catch exception if any
                    throw new Error(e); // we won't recover, so throw an error
                } finally {
                    safeClose(fileOutputStream);
                }
            }
            return path;
        }
    }

    /**
     * Handles one session, i.e. parses the HTTP request and returns the
     * response.
     */
    public interface IHTTPSession {
    
        void badClient(boolean b);

        void execute() throws IOException;

        CookieHandler getCookies();

        Map<String, String> getHeaders();
        
        Map<String, String> getFiles();

        InputStream getInputStream();

        Method getMethod();

        Map<String, String> getParms();

        String getQueryParameterString();

        /**
         * @return the path part of the URL.
         */
        String getUri();

        /**
         * Adds the files in the request body to the files map.
         * 
         * @param files
         *            map to modify
         */
        void parseBody() throws IOException, ResponseException;
    }

    /**
     * HTTP Request methods, with the ability to decode a <code>String</code>
     * back to its enum value.
     */
    public enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        CONNECT,
        PATCH;

        static Method lookup(String method) {
            for (Method m : Method.values()) {
                if (m.toString().equalsIgnoreCase(method)) {
                    return m;
                }
            }
            return null;
        }
    }

    /**
     * HTTP response. Return one of these from serve().
     */
    public static class Response implements Closeable {


        /**
         * Output stream that will automatically send every write to the wrapped
         * OutputStream according to chunked transfer:
         * http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.6.1
         */
        private static class ChunkedOutputStream extends FilterOutputStream {

            public ChunkedOutputStream(OutputStream out) {
                super(out);
            }

            @Override
            public void write(int b) throws IOException {
                byte[] data = {
                    (byte) b
                };
                write(data, 0, 1);
            }

            @Override
            public void write(byte[] b) throws IOException {
                write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (len == 0)
                    return;
                out.write(String.format("%x\r\n", len).getBytes());
                out.write(b, off, len);
                out.write("\r\n".getBytes());
            }

            public void finish() throws IOException {
                out.write("0\r\n\r\n".getBytes());
            }

        }

        /**
         * HTTP status code after processing, e.g. "200 OK", Status.OK
         */
        private IStatus status;

        /**
         * MIME type of content, e.g. "text/html"
         */
        private String mimeType;

        /**
         * Data of the response, may be null.
         */
        private InputStream data;

        private long contentLength;

        /**
         * Headers for the HTTP response. Use addHeader() to add lines.
         */
        //private final Map<String, String> header = new HashMap<String, String>();
        final Map<String, String> header = lithashmap("X-Powered-By", "JavaX");

        /**
         * The request method that spawned this response.
         */
        private Method requestMethod;

        /**
         * Use chunkedTransfer
         */
        private boolean chunkedTransfer = false;

        private boolean encodeAsGzip = false;

        private boolean keepAlive = false;

        /**
         * Creates a fixed length response if totalBytes>=0, otherwise chunked.
         */
        protected Response(IStatus status, String mimeType, InputStream data, long totalBytes) {
            this.status = status;
            this.mimeType = mimeType;
            if (data == null) {
                this.data = new ByteArrayInputStream(new byte[0]);
                this.contentLength = 0L;
            } else {
                this.data = data;
                this.contentLength = totalBytes;
            }
            this.chunkedTransfer = this.contentLength < 0;
            keepAlive = true;
        }

        @Override
        public void close() throws IOException {
            if (this.data != null) {
                this.data.close();
            }
        }

        /**
         * Adds given line to the header.
         */
        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        public InputStream getData() {
            return this.data;
        }

        public String getHeader(String name) {
            for (String headerName : header.keySet()) {
                if (headerName.equalsIgnoreCase(name)) {
                    return header.get(headerName);
                }
            }
            return null;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Method getRequestMethod() {
            return this.requestMethod;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setGzipEncoding(boolean encodeAsGzip) {
            this.encodeAsGzip = encodeAsGzip;
        }

        public void setKeepAlive(boolean useKeepAlive) {
            this.keepAlive = useKeepAlive;
        }

        private boolean headerAlreadySent(Map<String, String> header, String name) {
            boolean alreadySent = false;
            for (String headerName : header.keySet()) {
                alreadySent |= headerName.equalsIgnoreCase(name);
            }
            return alreadySent;
        }

        /**
         * Sends given response to the socket.
         */
        protected void send(OutputStream outputStream) {
            String mime = this.mimeType;
            SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));

            try {
                if (this.status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), false);
                pw.print("HTTP/1.1 " + this.status.getDescription() + " \r\n");

                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }

                if (this.header == null || this.header.get("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }

                if (this.header != null) {
                    for (String key : this.header.keySet()) {
                        String value = this.header.get(key);
                        pw.print(key + ": " + value + "\r\n");
                    }
                }

                if (!headerAlreadySent(header, "connection")) {
                    pw.print("Connection: " + (this.keepAlive ? "keep-alive" : "close") + "\r\n");
                }

                if (headerAlreadySent(this.header, "content-length")) {
                    encodeAsGzip = false;
                }

                if (encodeAsGzip) {
                    pw.print("Content-Encoding: gzip\r\n");
                    setChunkedTransfer(true);
                }

                long pending = this.data != null ? this.contentLength : 0;
                if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                    pw.print("Transfer-Encoding: chunked\r\n");
                } else if (!encodeAsGzip) {
                    pending = sendContentLengthHeaderIfNotAlreadyPresent(pw, this.header, pending);
                }
                pw.print("\r\n");
                pw.flush();
                sendBodyWithCorrectTransferAndEncoding(outputStream, pending);
                outputStream.flush();
                safeClose(this.data);
            } catch (IOException ioe) {
                NanoHTTPD.LOG.log(Level.SEVERE, "Could not send response to the client", ioe);
            }
        }

        private void sendBodyWithCorrectTransferAndEncoding(OutputStream outputStream, long pending) throws IOException {
            if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream);
                sendBodyWithCorrectEncoding(chunkedOutputStream, -1);
                chunkedOutputStream.finish();
            } else {
                sendBodyWithCorrectEncoding(outputStream, pending);
            }
        }

        private void sendBodyWithCorrectEncoding(OutputStream outputStream, long pending) throws IOException {
            if (encodeAsGzip) {
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
                sendBody(gzipOutputStream, -1);
                gzipOutputStream.finish();
            } else {
                sendBody(outputStream, pending);
            }
        }

        /**
         * Sends the body to the specified OutputStream. The pending parameter
         * limits the maximum amounts of bytes sent unless it is -1, in which
         * case everything is sent.
         * 
         * @param outputStream
         *            the OutputStream to send data to
         * @param pending
         *            -1 to send everything, otherwise sets a max limit to the
         *            number of bytes sent
         * @throws IOException
         *             if something goes wrong while sending the data.
         */
        private void sendBody(OutputStream outputStream, long pending) throws IOException {
            long BUFFER_SIZE = 16 * 1024;
            byte[] buff = new byte[(int) BUFFER_SIZE];
            boolean sendEverything = pending == -1;
            while (pending > 0 || sendEverything) {
                long bytesToRead = sendEverything ? BUFFER_SIZE : Math.min(pending, BUFFER_SIZE);
                int read = this.data.read(buff, 0, (int) bytesToRead);
                if (read <= 0) {
                    break;
                }
                outputStream.write(buff, 0, read);
                if (!sendEverything) {
                    pending -= read;
                }
            }
        }

        protected long sendContentLengthHeaderIfNotAlreadyPresent(PrintWriter pw, Map<String, String> header, long size) {
            for (String headerName : header.keySet()) {
                if (headerName.equalsIgnoreCase("content-length")) {
                    try {
                        return Long.parseLong(header.get(headerName));
                    } catch (NumberFormatException ex) {
                        return size;
                    }
                }
            }

            pw.print("Content-Length: " + size + "\r\n");
            return size;
        }

        public void setChunkedTransfer(boolean chunkedTransfer) {
            this.chunkedTransfer = chunkedTransfer;
        }

        public void setData(InputStream data) {
            this.data = data;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setRequestMethod(Method requestMethod) {
            this.requestMethod = requestMethod;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }

    public static final class ResponseException extends Exception {

        private static final long serialVersionUID = 6569838532917408380L;

        private final Status status;

        public ResponseException(Status status, String message) {
            super(message);
            this.status = status;
        }

        public ResponseException(Status status, String message, Exception e) {
            super(message, e);
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }
    }

    /**
     * The runnable that will be used for the main listening thread.
     */
    public class ServerRunnable implements Runnable {

        private final int timeout;

        private IOException bindException;

        private boolean hasBinded = false;

        private ServerRunnable(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                myServerSocket.bind(hostname != null ? new InetSocketAddress(hostname, myPort) : new InetSocketAddress(myPort));
                hasBinded = true;
            } catch (IOException e) {
                print("Was trying to bind to port: " + myPort + (hostname == null ? "" : " on " + hostname));
                this.bindException = e;
                return;
            }
            do {
                try {
                    final Socket finalAccept = NanoHTTPD.this.myServerSocket.accept();
                    if (NanoHTTPD_debug) print("NanoHTTPD: New socket.");
                    if (this.timeout > 0) {
                        finalAccept.setSoTimeout(this.timeout);
                    }
                    final InputStream inputStream = wrapStuff("SocketInputStream", finalAccept.getInputStream(), finalAccept, NanoHTTPD.this.myServerSocket);
                    NanoHTTPD.this.asyncRunner.exec(createClientHandler(finalAccept, inputStream));
                } catch (IOException e) {
                    NanoHTTPD.LOG.log(Level.FINE, "Communication with the client broken", e);
                }
            } while (!NanoHTTPD.this.myServerSocket.isClosed());
        }
    }

    /**
     * A temp file.
     * <p/>
     * <p>
     * Temp files are responsible for managing the actual temporary storage and
     * cleaning themselves up when no longer needed.
     * </p>
     */
    public interface TempFile {

        void delete() throws Exception;

        String getName();

        OutputStream open() throws Exception;
    }

    /**
     * Temp file manager.
     * <p/>
     * <p>
     * Temp file managers are created 1-to-1 with incoming requests, to create
     * and cleanup temporary files created as a result of handling the request.
     * </p>
     */
    public interface TempFileManager {

        void clear();

        TempFile createTempFile() throws Exception;
    }

    /**
     * Factory to create temp file managers.
     */
    public interface TempFileManagerFactory {

        TempFileManager create();
    }

    /**
     * Maximum time to wait on Socket.getInputStream().read() (in milliseconds)
     * This is required as the Keep-Alive HTTP connections would otherwise block
     * the socket reading thread forever (or as long the browser is open).
     */
    public static int SOCKET_READ_TIMEOUT =
      // 5000;
      24*3600*1000; // for WebSockets!

    /**
     * Common MIME type for dynamic content: plain text
     */
    public static final String MIME_PLAINTEXT = "text/plain; charset=utf-8";

    /**
     * Common MIME type for dynamic content: html
     */
    public static final String MIME_HTML = "text/html; charset=utf-8";

    /**
     * Pseudo-Parameter to use to store the actual query string in the
     * parameters map for later re-processing.
     */
    private static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";

    /**
     * logger to log to.
     */
    private static final Logger LOG = Logger.getLogger(NanoHTTPD.class.getName());

    /**
     * Creates an SSLSocketFactory for HTTPS. Pass a loaded KeyStore and an
     * array of loaded KeyManagers. These objects must properly
     * loaded/initialized by the caller.
     */
    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManager[] keyManagers) throws IOException {
        SSLServerSocketFactory res = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(loadedKeyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
            res = ctx.getServerSocketFactory();
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return res;
    }

    /**
     * Creates an SSLSocketFactory for HTTPS. Pass a loaded KeyStore and a
     * loaded KeyManagerFactory. These objects must properly loaded/initialized
     * by the caller.
     */
    public static SSLServerSocketFactory makeSSLSocketFactory(KeyStore loadedKeyStore, KeyManagerFactory loadedKeyFactory) throws IOException {
        SSLServerSocketFactory res = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(loadedKeyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(loadedKeyFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            res = ctx.getServerSocketFactory();
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return res;
    }

    /**
     * Creates an SSLSocketFactory for HTTPS. Pass a KeyStore resource with your
     * certificate and passphrase
     */
    public static SSLServerSocketFactory makeSSLSocketFactory(String keyAndTrustStoreClasspathPath, char[] passphrase) throws IOException {
        SSLServerSocketFactory res = null;
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream keystoreStream = NanoHTTPD.class.getResourceAsStream(keyAndTrustStoreClasspathPath);
            keystore.load(keystoreStream, passphrase);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, passphrase);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            res = ctx.getServerSocketFactory();
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return res;
    }

    private static final void safeClose(Object closeable) {
        try {
            if (closeable != null) {
                if (closeable instanceof Closeable) {
                    ((Closeable) closeable).close();
                } else if (closeable instanceof Socket) {
                    ((Socket) closeable).close();
                } else if (closeable instanceof ServerSocket) {
                    ((ServerSocket) closeable).close();
                } else {
                    throw new IllegalArgumentException("Unknown object to close");
                }
            }
        } catch (IOException e) {
            NanoHTTPD.LOG.log(Level.SEVERE, "Could not close", e);
        }
    }

    private final String hostname;

    private final int myPort;

    private ServerSocket myServerSocket;

    private SSLServerSocketFactory sslServerSocketFactory;

    private Thread myThread;

    /**
     * Pluggable strategy for asynchronously executing requests.
     */
    protected AsyncRunner asyncRunner;

    /**
     * Pluggable strategy for creating and cleaning up temporary files.
     */
    private TempFileManagerFactory tempFileManagerFactory;

    /**
     * Constructs an HTTP server on given port.
     */
    public NanoHTTPD(int port) {
        this(null, port);
    }

    // -------------------------------------------------------------------------------
    // //
    //
    // Threading Strategy.
    //
    // -------------------------------------------------------------------------------
    // //

    /**
     * Constructs an HTTP server on given hostname and port.
     */
    public NanoHTTPD(String hostname, int port) {
        this.hostname = hostname;
        this.myPort = port;
        setTempFileManagerFactory(new DefaultTempFileManagerFactory());
        setAsyncRunner(new DefaultAsyncRunner());
    }

    /**
     * Forcibly closes all connections that are open.
     */
    public synchronized void closeAllConnections() {
        stop();
    }

    /**
     * create a instance of the client handler, subclasses can return a subclass
     * of the ClientHandler.
     * 
     * @param finalAccept
     *            the socket the cleint is connected to
     * @param inputStream
     *            the input stream
     * @return the client handler
     */
    protected ClientHandler createClientHandler(final Socket finalAccept, final InputStream inputStream) {
        return new ClientHandler(inputStream, finalAccept);
    }

    /**
     * Instantiate the server runnable, can be overwritten by subclasses to
     * provide a subclass of the ServerRunnable.
     * 
     * @param timeout
     *            the socet timeout to use.
     * @return the server runnable.
     */
    protected ServerRunnable createServerRunnable(final int timeout) {
        return new ServerRunnable(timeout);
    }

    /**
     * Decode parameters from a URL, handing the case where a single parameter
     * name might have been supplied several times, by return lists of values.
     * In general these lists will contain a single element.
     * 
     * @param parms
     *            original <b>NanoHTTPD</b> parameters values, as passed to the
     *            <code>serve()</code> method.
     * @return a map of <code>String</code> (parameter name) to
     *         <code>List&lt;String&gt;</code> (a list of the values supplied).
     */
    protected Map<String, List<String>> decodeParameters(Map<String, String> parms) {
        return this.decodeParameters(parms.get(NanoHTTPD.QUERY_STRING_PARAMETER));
    }

    // -------------------------------------------------------------------------------
    // //

    /**
     * Decode parameters from a URL, handing the case where a single parameter
     * name might have been supplied several times, by return lists of values.
     * In general these lists will contain a single element.
     * 
     * @param queryString
     *            a query string pulled from the URL.
     * @return a map of <code>String</code> (parameter name) to
     *         <code>List&lt;String&gt;</code> (a list of the values supplied).
     */
    protected Map<String, List<String>> decodeParameters(String queryString) {
        Map<String, List<String>> parms = new HashMap<String, List<String>>();
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf('=');
                String propertyName = sep >= 0 ? decodePercent(e.substring(0, sep)).trim() : decodePercent(e).trim();
                if (!parms.containsKey(propertyName)) {
                    parms.put(propertyName, new ArrayList<String>());
                }
                String propertyValue = sep >= 0 ? decodePercent(e.substring(sep + 1)) : null;
                // XXX Stefan - allow raw parameters - took the if out:
                /* if (propertyValue != null) */ {
                    parms.get(propertyName).add(propertyValue);
                }
            }
        }
        return parms;
    }

    /**
     * Decode percent encoded <code>String</code> values.
     * 
     * @param str
     *            the percent encoded <code>String</code>
     * @return expanded form of the input, for example "foo%20bar" becomes
     *         "foo bar"
     */
    protected String decodePercent(String str) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(str, "UTF8");
        } catch (UnsupportedEncodingException ignored) {
            NanoHTTPD.LOG.log(Level.WARNING, "Encoding not supported, ignored", ignored);
        }
        return decoded;
    }

    /**
     * @return true if the gzip compression should be used if the client
     *         accespts it. Default this option is on for text content and off
     *         for everything else.
     */
    protected boolean useGzipWhenAccepted(Response r) {
        return r.getMimeType() != null && r.getMimeType().toLowerCase().contains("text/");
    }

    public final int getListeningPort() {
        return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean isAlive() {
        return wasStarted() && !this.myServerSocket.isClosed() && this.myThread.isAlive();
    }

    public void join() throws InterruptedException {
      myThread.join();
    }

    /**
     * Call before start() to serve over HTTPS instead of HTTP
     */
    public void makeSecure(SSLServerSocketFactory sslServerSocketFactory) {
        this.sslServerSocketFactory = sslServerSocketFactory;
    }

    /**
     * Create a response with unknown length (using HTTP 1.1 chunking).
     */
    public Response newChunkedResponse(IStatus status, String mimeType, InputStream data) {
        return new Response(status, mimeType, data, -1);
    }

    /**
     * Create a response with known length.
     */
    public static Response newFixedLengthResponse(IStatus status, String mimeType, InputStream data, long totalBytes) {
        return new Response(status, mimeType, data, totalBytes);
    }

    /**
     * Create a text response with known length.
     */
    public static Response newFixedLengthResponse(IStatus status, String mimeType, String txt) {
        if (txt == null) {
            return newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(new byte[0]), 0);
        } else {
            byte[] bytes;
            try {
                bytes = txt.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                NanoHTTPD.LOG.log(Level.SEVERE, "encoding problem, responding nothing", e);
                bytes = new byte[0];
            }
            return newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(bytes), bytes.length);
        }
    }

    /**
     * Create a text response with known length.
     */
    public static Response newFixedLengthResponse(String msg) {
        return newFixedLengthResponse(Status.OK, NanoHTTPD.MIME_HTML, msg);
    }

    /**
     * Override this to customize the server.
     * <p/>
     * <p/>
     * (By default, this returns a 404 "Not Found" plain text error response.)
     * 
     * @param session
     *            The HTTP session
     * @return HTTP response, see class Response for details
     */
    public Response serve(IHTTPSession session) {
        currentSession.set(session);
        Method method = session.getMethod();
        if (Method.PUT.equals(method) || Method.POST.equals(method)) {
            try {
                session.parseBody();
            } catch (IOException ioe) {
                return newFixedLengthResponse(Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            } catch (ResponseException re) {
                return newFixedLengthResponse(re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
            }
        }

        Map<String, String> parms = session.getParms();
        if (!noQueryStringParameter)
          parms.put(NanoHTTPD.QUERY_STRING_PARAMETER, session.getQueryParameterString());
        return serve(session.getUri(), method, session.getHeaders(), parms, session.getFiles());
    }

    /**
     * Override this to customize the server.
     * <p/>
     * <p/>
     * (By default, this returns a 404 "Not Found" plain text error response.)
     * 
     * @param uri
     *            Percent-decoded URI without parameters, for example
     *            "/index.cgi"
     * @param method
     *            "GET", "POST" etc.
     * @param parms
     *            Parsed, percent decoded parameters from URI and, in case of
     *            POST, data.
     * @param headers
     *            Header entries, percent decoded
     * @return HTTP response, see class Response for details
     */
    @Deprecated
    public Response serve(String uri, Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        return newFixedLengthResponse(Status.NOT_FOUND, NanoHTTPD.MIME_PLAINTEXT, "Not Found");
    }

    /**
     * Pluggable strategy for asynchronously executing requests.
     * 
     * @param asyncRunner
     *            new strategy for handling threads.
     */
    public void setAsyncRunner(AsyncRunner asyncRunner) {
        this.asyncRunner = asyncRunner;
    }

    /**
     * Pluggable strategy for creating and cleaning up temporary files.
     * 
     * @param tempFileManagerFactory
     *            new strategy for handling temp files.
     */
    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
        this.tempFileManagerFactory = tempFileManagerFactory;
    }

    /**
     * Start the server.
     * 
     * @throws IOException
     *             if the socket is in use.
     */
    public void start() throws IOException {
        start(NanoHTTPD.SOCKET_READ_TIMEOUT);
    }

    /**
     * Start the server.
     * 
     * @param timeout
     *            timeout to use for socket connections.
     * @throws IOException
     *             if the socket is in use.
     */
    public void start(final int timeout) throws IOException {
        boolean ssl = this.sslServerSocketFactory != null;
        if (ssl) {
            SSLServerSocket ss = (SSLServerSocket) this.sslServerSocketFactory.createServerSocket();
            ss.setNeedClientAuth(false);
            this.myServerSocket = ss;
        } else {
            this.myServerSocket = new ServerSocket();
        }
        this.myServerSocket.setReuseAddress(true);

        ServerRunnable serverRunnable = createServerRunnable(timeout);
        this.myThread = new Thread(serverRunnable);
        //this.myThread.setDaemon(true);
        this.myThread.setName("NanoHttpd Main Listener");
        this.myThread.start();
        while (!serverRunnable.hasBinded && serverRunnable.bindException == null) {
            try {
                Thread.sleep(10L);
            } catch (Throwable e) {
                // on android this may not be allowed, that's why we
                // catch throwable the wait should be very short because we are
                // just waiting for the bind of the socket
            }
        }
        if (serverRunnable.bindException != null) {
            throw serverRunnable.bindException;
        }
        
      System.out.println("HTTP" + (ssl ? "S" : "") + " server started (listening on port " + getListeningPort() + "!)");
      printMyIPs();
    }

    /**
     * Stop the server.
     */
    public void stop() {
        try {
            safeClose(this.myServerSocket);
            this.asyncRunner.closeAll();
            if (this.myThread != null) {
                this.myThread.join();
            }
        } catch (Exception e) {
            NanoHTTPD.LOG.log(Level.SEVERE, "Could not stop all connections", e);
        }
    }

    public final boolean wasStarted() {
        return this.myServerSocket != null && this.myThread != null;
    }

  
static void printMyIPs() {
String ip;
  try {
      Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
      while (interfaces.hasMoreElements()) {
          NetworkInterface iface = interfaces.nextElement();
          // filters out 127.0.0.1 and inactive interfaces
          if (iface.isLoopback() || !iface.isUp())
              continue;

          Enumeration<InetAddress> addresses = iface.getInetAddresses();
          while(addresses.hasMoreElements()) {
              InetAddress addr = addresses.nextElement();
              ip = addr.getHostAddress();
if (ip.startsWith("127.")) continue;
boolean local = addr.isSiteLocalAddress() || ip.startsWith("fe");
              System.out.println(iface.getDisplayName() + " " + ip + " " + (local ? "(private address)" : "(public address)"));
          }
      }
  } catch (Throwable e) {
      e.printStackTrace();
  }
}
static interface IStatus {
    String getDescription();
    int getRequestStatus();
  }
  
  /**
   * Some HTTP response status codes
   */
  static enum Status implements IStatus {
      SWITCH_PROTOCOL(101, "Switching Protocols"),
      OK(200, "OK"),
      CREATED(201, "Created"),
      ACCEPTED(202, "Accepted"),
      NO_CONTENT(204, "No Content"),
      PARTIAL_CONTENT(206, "Partial Content"),
      REDIRECT(301, "Moved Permanently"),
      NOT_MODIFIED(304, "Not Modified"),
      BAD_REQUEST(400, "Bad Request"),
      UNAUTHORIZED(401, "Unauthorized"),
      FORBIDDEN(403, "Forbidden"),
      NOT_FOUND(404, "Not Found"),
      METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
      REQUEST_TIMEOUT(408, "Request Timeout"),
      RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
      INTERNAL_ERROR(500, "Internal Server Error"),
      UNSUPPORTED_HTTP_VERSION(505, "HTTP Version Not Supported");
  
      private final int requestStatus;
  
      private final String description;
  
      Status(int requestStatus, String description) {
          this.requestStatus = requestStatus;
          this.description = description;
      }
  
      @Override
      public String getDescription() {
          return "" + this.requestStatus + " " + this.description;
      }
  
      @Override
      public int getRequestStatus() {
          return this.requestStatus;
      }
  }
  
  int getPort() { return myPort; }
  
  public void close() { stop(); }
}
static abstract class TokCondition {
  abstract boolean get(List<String> tok, int i); // i = N Index
}abstract static class ALQLLine {
  public String toString() { return stdToString(this); }
}

static class ALQLReturn extends ALQLLine {
  String var;
  
  ALQLReturn() {}
  ALQLReturn(String var) {
  this.var = var;}
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
}

static class ALQLTriple extends ALQLLine {
  T3<String, String, String> triple;
  
  ALQLTriple() {}
  ALQLTriple(T3<String, String, String> triple) {
  this.triple = triple;}
  ALQLTriple(String a, String b, String c) { triple = t3(a, b, c); }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
}

static class ALQLLockStatement extends ALQLLine {
  T3<String, String, String> triple;
  
  ALQLLockStatement() {}
  ALQLLockStatement(T3<String, String, String> triple) {
  this.triple = triple;}
  ALQLLockStatement(String a, String b, String c) { triple = t3(a, b, c); }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }  
}

static class ALQLPage extends ALQLLine {
  String page, matchMethod;
  
  ALQLPage() {}
  ALQLPage(String page, String matchMethod) {
  this.matchMethod = matchMethod;
  this.page = page;}
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
}

static class ALQLSlice extends ALQLLine {
  String slice;
  List<ALQLLine> contents;

  ALQLSlice() {}
  ALQLSlice(String slice, List<ALQLLine> contents) {
  this.contents = contents;
  this.slice = slice;}
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
} static class GlobalID {
  // We need 76 bits for 26^16 IDs
  long a; // all bits used
  int b;  // 76-64=12 bits used; could be short. change to short when unstructure() is smarter
  
  GlobalID() {}
  GlobalID(String id) {
    assertGlobalID(id);
    BigInteger value = bigint(0);
    for (int i = 0; i < l(id); i++)
      value = plus(mul(value, 26), charDiff(id.charAt(i), 'a'));
      
    
    a = value.longValue();
    value = value.shiftRight(64);
    b = value.shortValue();
  }
  
  public String toString() {
    BigInteger value = bigint(b);
    value = value.shiftLeft(32);
    value = plus(value, (a >> 32) & 0xFFFFFFFFL);
    value = value.shiftLeft(32);
    value = plus(value, a & 0xFFFFFFFFL);
    
    
    
    return bigintToGlobalID(value);
  }
  
  public boolean equals(Object o) {
    if (!(o instanceof GlobalID)) return false;
    return ((GlobalID) o).a == a && ((GlobalID) o).b == b;
  }
  
  public int hashCode() {
    return (int) a;
  }
}// A concept should be an object, not just a string.

// Functions that should always be there for child processes:
static int concepts_internStringsLongerThan = 10;

static ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

static interface Derefable {
  Concept get();
}

static interface IConceptIndex {
  void update(Concept c); // also for adding
  void remove(Concept c);
}

static interface IFieldIndex<A extends Concept, Val> {
  List<A> getAll(Val val);
  List<Val> allValues(); // returns a cloned list
  MultiSet<Val> allValues_multiSet();
}

static class Concepts {
  Map<Long, Concept> concepts = synchroTreeMap();
  HashMap<Class,Object> perClassData = new HashMap();
  
  // set to "-" for non-persistent (possibly not implemented)
  // also, can include a case ID ("#123/1")
  // TODO: have an actual directory instead
  String programID;
  
  long idCounter;
  volatile long changes, changesWritten, lastChange;
  volatile java.util.Timer autoSaver;
  volatile boolean savingConcepts, dontSave, noXFullGrab;
  boolean vmBusSend = true;
  boolean initialSave = true; // set to false to avoid initial useless saving
  int autoSaveInterval = -1000; // 1 second + wait logic
  boolean useGZIP = true, quietSave;
  ReentrantLock lock = new ReentrantLock(true);
  ReentrantLock saverLock = new ReentrantLock(true);
  long lastSaveTook, lastSaveWas;
  float maxAutoSavePercentage = 10;
  List<IConceptIndex> conceptIndices;
  Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;
  Map<Class<? extends Concept>, Map<String, IFieldIndex>> ciFieldIndices;
  List saveActions = synchroList();
  Object classFinder = _defaultClassFinder();
  List onAllChanged = synchroList(); // list of runnables
  transient Object saveWrapper; // VF1<Runnable>, to profile saving
  
  Concepts() {}
  Concepts(String programID) {
  this.programID = programID;}
  
  synchronized long internalID() {
    do {
      ++idCounter;
    } while (hasConcept(idCounter));
    return idCounter;
  }
  
  void initProgramID() {
    if (programID == null)
      programID = getDBProgramID();
  }
  
  // Now tries to load from bot first, then go to disk.
  Concepts load() {
    return load(false);
  }
  
  Concepts safeLoad() {
    return load(true);
  }
  
  Concepts load(boolean allDynamic) {
    initProgramID();
    try {
      if (tryToGrab(allDynamic)) return this;
    } catch (Throwable e) {
      if (!exceptionMessageContains(e, "no xfullgrab"))
        printShortException(e);
      print("xfullgrab failed - loading DB of " + programID + " from disk");
    }
    return loadFromDisk(allDynamic);
  }
  
  Concepts loadFromDisk() { return loadFromDisk(false); }
  
  Concepts loadFromDisk(boolean allDynamic) {
    if (nempty(concepts)) clearConcepts();
    //DynamicObject_loading.set(true); // now done in unstructure()
    //try {
      // minimal crash recovery
      restoreLatestBackupIfConceptsFileEmpty(programID, "doIt" , true);

      long time = now();
      Map<Long, Concept> _concepts = concepts; // empty map
      readLocally2_allDynamic.set(allDynamic);
       AutoCloseable __1556 = tempSetTL(readLocally2_classFinder, classFinder); try {
      readLocally2(this, programID, "concepts");
      Map<Long, Concept> __concepts = concepts;
      concepts = _concepts;
      concepts.putAll(__concepts);
      int l = readLocally_stringLength;
      int tokrefs = unstructure_tokrefs;
      assignConceptsToUs();
      done("Loaded " + n(l(concepts), "concepts"), time);
      if (fileSize(getProgramFile(programID, "idCounter.structure")) != 0)
        readLocally2(this, programID, "idCounter");
      else
        calcIdCounter();
    /*} finally {
      DynamicObject_loading.set(null);
    }*/
    if (initialSave) allChanged();
    return this;
  } finally { _close(__1556); }}
  
  Concepts loadConcepts() { return load(); }
  
  boolean tryToGrab(boolean allDynamic) {
    if (sameSnippetID(programID, getDBProgramID())) return false;
     RemoteDB db = connectToDBOpt(programID); try {
    if (db != null) {
      loadGrab(db.fullgrab(), allDynamic);
      return true;
    }
    return false;
  } finally { _close(db); }}
  
  Concepts load(String grab) {
    return loadGrab(grab, false);
  }
  
  Concepts safeLoad(String grab) {
    return loadGrab(grab, true);
  }
  
  Concepts loadGrab(String grab, boolean allDynamic) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      Map<Long, Concept> map = (Map) unstructure(grab, allDynamic, classFinder);
      concepts.putAll(map);
      assignConceptsToUs();
      for (long l : map.keySet())
        idCounter = max(idCounter, l);
    } finally {
      DynamicObject_loading.set(null);
    }
    allChanged();
    return this;
  }
  
  void assignConceptsToUs() {
    for (Concept c : values(concepts)) c._concepts = this;
    for (Concept c : values(concepts))
      callOpt_noArgs(c, "_doneLoading2"); // doneLoading2 is called on all concepts after all concepts are loaded
  }

  String progID() {
    return programID == null ? getDBProgramID() : programID;
  }
  
  Concept getConcept(String id) {
    return empty(id) ? null : getConcept(parseLong(id));
  }
  
  Concept getConcept(long id) {
    return (Concept) concepts.get((long) id);
  }
  
  Concept getConcept(RC ref) {
    return ref == null ? null : getConcept(ref.longID());
  }
  
  boolean hasConcept(long id) {
    return concepts.containsKey((long) id);
  }
  
  void deleteConcept(long id) {
    Concept c = getConcept(id);
    if (c == null)
      print("Concept " + id + " not found");
    else
      c.delete();
  }
  
  void calcIdCounter() {
    long id_ = 0;
    for (long id : keys(concepts))
      id_ = max(id_, id);
    idCounter = id_+1;
    saveLocally2(this, programID, "idCounter");
  }
  
  void saveConceptsIfDirty() { saveConcepts(); }
  void save() { saveConcepts(); }

  void saveConcepts() {
    if (dontSave) return;
    initProgramID();
    saverLock.lock();
    savingConcepts = true;
    long start = now(), time;
    try {
      String s = null;
      //synchronized(main.class) {
      long _changes = changes;
      if (_changes == changesWritten) return;
      
      final File f = getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
      
      lock.lock();
      long fullTime = now();
      try {
        saveLocally2(this, programID, "idCounter");
        
        if (useGZIP) {
          callRunnableWithWrapper(saveWrapper, new Runnable() {  public void run() { try { 
            saveGZStructureToFile(f, cloneMap(concepts));
          
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "saveGZStructureToFile(f, cloneMap(concepts));"; }});
          getProgramFile(programID, "concepts.structure").delete();
        } else
          s = structure(cloneMap(concepts));
      } finally {
        lock.unlock();
      }
      
      while (nempty(saveActions))
        pcallF(popFirst(saveActions));

      changesWritten = _changes; // only update when structure didn't fail
      
      if (!useGZIP) {
        time = now()-start;
        if (!quietSave)
          print("Saving " + toM(l(s)) + "M chars (" /*+ changesWritten + ", "*/ + time + " ms)");
        start = now();
        saveTextFile(f, javaTokWordWrap(s));
        getProgramFile(programID, "concepts.structure.gz").delete();
      }
      
      copyFile(f, getProgramFile(programID, "backups/concepts.structure" + (useGZIP ? ".gz" : "") + ".backup" + ymd() + "-" + formatInt(hours(), 2)));
      time = now()-start;
      if (!quietSave)
        print(programID + ": Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
      lastSaveWas = fullTime;
      lastSaveTook = now()-fullTime;
    } finally {
      savingConcepts = false;
      saverLock.unlock();
    }
  }
  
  void _autoSaveConcepts() {
    if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
      long pivotTime = Math.round(lastSaveWas+lastSaveTook*100.0/maxAutoSavePercentage);
      if (now() < pivotTime) {
        //print("Skipping auto-save (last save took " + lastSaveTook + ")");
        return;
      }
    }
    try {
      saveConcepts();
    } catch (Throwable e) {
      print("Concept save failed, will try again: " + e);
    }
  }
  
  void clearConcepts() {
    concepts.clear();
    allChanged();
  }
  
  void allChanged() {
    synchronized(this) { ++changes; lastChange = sysNow(); }
    if (vmBusSend) vmBus_send("conceptsChanged", this);
    pcallFAll(onAllChanged);
  }
  
  // auto-save every second if dirty
  synchronized void autoSaveConcepts() {
    if (autoSaver == null) {
      if (isTransient()) throw fail("Can't persist transient database");
      autoSaver = doEvery_daemon(abs(autoSaveInterval), new Runnable() {  public void run() { try {  _autoSaveConcepts() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_autoSaveConcepts()"; }});
      // print("Installed auto-saver (" + autoSaveInterval + " ms, " + progID() + ")");
    }
  }
  
  void cleanMeUp() {
    boolean shouldSave = autoSaver != null;
    if (autoSaver != null) {
      autoSaver.cancel();
      autoSaver = null;
    }
    while (savingConcepts) sleepInCleanUp(10);
    if (shouldSave)
      saveConceptsIfDirty();
  }
  
  Map<Long, String> getIDsAndNames() {
    Map<Long,String> map = new HashMap();
    Map<Long, Concept> cloned = cloneMap(concepts);
    for (long id : keys(cloned)) 
      map.put(id, cloned.get(id).className);
    return map;
  }
  
  void deleteConcepts(List l) {
    if (l != null) for (Object o : cloneList(l))
      if (o instanceof Long) {
        Concept c = concepts.get(o);
        if (c != null) c.delete();
      } else if (o instanceof Concept)
        ((Concept) o).delete();
      else
        warn("Can't delete " + getClassName(o));
  }
  
  <A extends Concept> A conceptOfType(Class<A> type) {
    IConceptCounter counter = conceptCounterForClass(type);
    if (counter != null) return (A) first(counter.allConcepts());
    return firstOfType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> conceptsOfType(Class<A> type) {
    IConceptCounter counter = conceptCounterForClass(type);
    if (counter != null) return (List<A>) cloneList(counter.allConcepts());
    return filterByType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> listConcepts(Class<A> type) {
    return conceptsOfType(type);
  }
  
  <A extends Concept> List<A> list(Class<A> type) {
    return conceptsOfType(type);
  }
  
  List<Concept> list(String type) {
    return conceptsOfType(type);
  }
  
  List<Concept> conceptsOfType(String type) {
    return filterByDynamicType(allConcepts(), "main$" + type);
  }
  
  boolean hasConceptOfType(Class<? extends Concept> type) {
    return hasType(allConcepts(), type);
  }
  
  void persistConcepts() {
    loadConcepts();
    autoSaveConcepts();
  }
  
  // We love synonyms
  void conceptPersistence() { persistConcepts(); }
  
  Concepts persist() { persistConcepts(); return this; }
  void persist(Integer interval) {
    if (interval != null) autoSaveInterval = interval;
    persist();
  }
    
  // Runs r if there is no concept of that type
  <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
    A a = conceptOfType(c);
    if (a == null) {
      r.run();
      a = conceptOfType(c);
      if (a == null)
        throw fail("Concept not made by " + r + ": " + shortClassName(c));
    }
    return a;
  }
  
  // Ensures that every concept of type c1 is ref'd by a concept of
  // type c2.
  // Type of func: voidfunc(concept)
  void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
    for (Concept a : conceptsOfType(c1)) {
      Concept b = findBackRef(a, c2);
      if (b == null) {
        callF(func, a);
        b = findBackRef(a, c2);
        if (b == null)
          throw fail("Concept not made by " + func + ": " + shortClassName(c2));
      }
    }
  }
  
  // Type of func: voidfunc(concept)
  void forEvery(Class<? extends Concept> type, Object func) {
    for (Concept c : conceptsOfType(type))
      callF(func, c);
  }
  
  int deleteAll(Class<? extends Concept> type) {
    List<Concept> l = (List) conceptsOfType(type);
    for (Concept c : l) c.delete();
    return l(l);
  }
  
  Collection<Concept> allConcepts() {
    synchronized(concepts) {
      return new ArrayList(values(concepts));
    }
  }
  
  IConceptCounter conceptCounterForClass(Class<? extends Concept> c) {
    for (IFieldIndex idx : values(mapGet(fieldIndices, c)))
      if (idx instanceof IConceptCounter) return ((IConceptCounter) idx);
    for (IFieldIndex idx : values(mapGet(ciFieldIndices, c)))
      if (idx instanceof IConceptCounter) return ((IConceptCounter) idx);
    return null;
  }
  
  <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    if (empty(params)) {
      IConceptCounter counter = conceptCounterForClass(c);
      if (counter != null) return counter.countConcepts();
      return l(list(c));
    }
    int n = 0;
    for (A x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts(String c, Object... params) {
    if (empty(params)) return l(list(c));
    int n = 0;
    for (Concept x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts() {
    return l(concepts);
  }
  
  synchronized void addConceptIndex(IConceptIndex index) {
    if (conceptIndices == null)
      conceptIndices = new ArrayList();
    conceptIndices.add(index);
  }
  
  synchronized void removeConceptIndex(IConceptIndex index) {
    if (conceptIndices == null) return;
    conceptIndices.remove(index);
    if (empty(conceptIndices)) conceptIndices = null;
  }
  
  synchronized void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    if (fieldIndices == null)
      fieldIndices = new HashMap();
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    if (map == null)
      fieldIndices.put(c, map = new HashMap());
    map.put(field, index);
  }
  
  synchronized IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
    if (fieldIndices == null) return null;
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    return map == null ? null : map.get(field);
  }
  
  synchronized void addCIFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    if (ciFieldIndices == null)
      ciFieldIndices = new HashMap();
    Map<String, IFieldIndex> map = ciFieldIndices.get(c);
    if (map == null)
      ciFieldIndices.put(c, map = new HashMap());
    map.put(field, index);
  }
  
  synchronized IFieldIndex getCIFieldIndex(Class<? extends Concept> c, String field) {
    if (ciFieldIndices == null) return null;
    Map<String, IFieldIndex> map = ciFieldIndices.get(c);
    return map == null ? null : map.get(field);
  }
  
  // inter-process methods
  
  RC xnew(String name, Object... values) {
    return new RC(cnew(name, values));
  }
  
  void xset(long id, String field, Object value) {
    xset(new RC(id), field, value);
  }
  
  void xset(RC c, String field, Object value) {
    if (value instanceof RC)
      value = getConcept((RC) value);
    cset(getConcept(c), field, value);
  }
  
  Object xget(long id, String field) {
    return xget(new RC(id), field);
  }
  
  Object xget(RC c, String field) {
    return xgetPost(cget(getConcept(c), field));
  }
  
  Object xgetPost(Object o) {
    o = deref(o);
    if (o instanceof Concept)
      return new RC((Concept) o);
    return o;
  }
  
  void xdelete(long id) {
    xdelete(new RC(id));
  }
  
  void xdelete(RC c) {
    getConcept(c).delete();
  }
  
  void xdelete(List<RC> l) {
    for (RC c : l)
      xdelete(c);
  }
  
  List<RC> xlist() {
    return map("toPassRef", allConcepts());
  }
  
  List<RC> xlist(String className) {
    return map("toPassRef", conceptsOfType(className));
  }
  
  boolean isTransient() { return eq(programID, "-"); }
  
  String xfullgrab() {
    if (noXFullGrab) throw fail("no xfullgrab (DB too large)");
    Lock __1555 = lock(); lock(__1555); try {
    if (changes == changesWritten && !isTransient())
      return loadConceptsStructure(programID);
    return structure(cloneMap(concepts));
  } finally { unlock(__1555); } }
  
  /* dev.
  Either<File, byte[]> xfullgrabGZipped() {
    lock lock();
    if (changes == changesWritten && !isTransient())
      ret loadConceptsStructure(programID);
    ret structure(cloneMap(concepts));
  }*/
  
  void xshutdown() {
    // Killing whole VM if someone wants this DB to shut down
    cleanKillVM();
  }
  
  long xchangeCount() { return changes; }
  int xcount() { return countConcepts(); }
  
  void register(Concept c) {
    if (c._concepts == this) return;
    if (c._concepts != null) throw fail("Can't re-register");
    c._concepts = this;
    c.id = internalID();
    c.created = now();
    concepts.put((long) c.id, c);
    c.change();
  }
  
  void conceptChanged(Concept c) {
    allChanged();
    if (conceptIndices != null)
      for (IConceptIndex index : conceptIndices)
        index.update(c);
  }
} // class Concepts

static class Concept extends DynamicObject {
  transient Concepts _concepts; // Where we belong
  long id;
  long created, _modified;
  List<Ref> refs;
  List<Ref> backRefs;
  
  // used only internally (cnew)
  Concept(String className) {
    super(className);
    _created();
  }
  
  Concept() {
    if (!_loading()) {
      //className = shortClassName(this); // XXX - necessary?
      //print("New concept of type " + className);
      _created();
    }
  }
  
  Concept(boolean unlisted) {
    if (!unlisted) _created();
  }
  
  static boolean loading() { return _loading(); }
  static boolean _loading() { return dynamicObjectIsLoading(); }

  void _created() {
    if (!isTrue(concepts_unlisted.get()))
      db_mainConcepts().register(this);
  }
  
  /*void put(S field, O value) {
    fieldValues.put(field, value);
    change();
  }
  
  O get(S field) {
    ret fieldValues.get(field);
  }*/
  
  class Ref<A extends Concept> {
    A value;
    
    Ref() {
      if (!dynamicObjectIsLoading()) refs = addDyn(refs, this);
    }
    
    Ref(A value) {
  this.value = value;
      refs = addDyn(refs, this);
      index();
    }
    
    // get owning concept (source)
    Concept concept() {
      return Concept.this;
    }
    
    // get target
    A get() { return value; }
    boolean has() { return value != null; }
    
    void set(A a) {
      if (a == value) return;
      unindex();
      value = a;
      index();
    }
    
    void set(Ref<A> ref) { set(ref.get()); }
    void clear() { set((A) null); }
    
    // TODO: sync all the indexing and unindexing!?
    void index() { 
      if (value != null)
        value._addBackRef(this);
      change();
    }
    
    void unindex() {
      if (value != null)
        value._removeBackRef(this);
    }
    
    void change() {
      Concept.this.change();
    }
  }
  
  class RefL<A extends Concept> extends AbstractList<A> {
    List<Ref<A>> l = new ArrayList();
    
    public A set(int i, A o) {
      A prev = l.get(i).get();
      l.get(i).set(o);
      return prev;
    }
    
    public void add(int i, A o) {
      l.add(i, new Ref(o));
    }
    
    public A get(int i) {
      return l.get(i).get();
    }
    
    public A remove(int i) {
      return l.remove(i).get();
    }
    
    public int size() {
      return l.size();
    }
    
    public boolean contains(Object o) {
      if (o instanceof Concept)
        for (Ref<A> r : l) if (eq(r.get(), o)) return true;
      return super.contains(o);
    }
  }
  
  void delete() {
    //name = "[defunct " + name + "]";
    //defunct = true;
    //energy = 0;
    
    // clean refs
    
    for (Ref r : unnull(refs))
      r.unindex();
    refs = null;
    
    // set back refs to null
    
    for (Ref r : cloneList(backRefs))
      r.set((Concept) null);
    backRefs = null;
    
    if (_concepts != null) {
      _concepts.concepts.remove((long) id);
      _concepts.allChanged();
      if (_concepts.conceptIndices != null)
        for (IConceptIndex index : _concepts.conceptIndices)
          index.remove(this);
      _concepts = null;
    }
    id = 0;
  }
  
  BaseXRef export() {
    return new BaseXRef(_concepts.progID(), id);
  }
  
  // notice system of a change in this object
  void change() {
    _modified = now();
    _change_withoutUpdatingModifiedField();
  }
  
  void _change_withoutUpdatingModifiedField() {
    if (_concepts != null) _concepts.conceptChanged(this);
  }
  
  void _change() { change(); }
  
  String _programID() {
    return _concepts == null ? getDBProgramID() : _concepts.progID();
  }
  
  // overridable
  
  void _addBackRef(Concept.Ref ref) {
    backRefs = addDyn(backRefs, ref);
  }
  
  void _removeBackRef(Concept.Ref ref) {
    backRefs = removeDyn(backRefs, ref);
  }
  
  // convenience methods
  
  void _setField(String field, Object value) {
    cset(this, field, value);
  }
  
  void _setFields(Object... values) {
    cset(this, values);
  }
} // class Concept

// remote reference (for inter-process communication or
// external databases). Formerly "PassRef".
// prepared for string ids if we do them later
static class RC {
  transient Object owner;
  String id;
  
  RC() {} // make serialisation happy
  RC(long id) { this.id = str(id); }
  RC(Object owner, long id) { this.id = str(id); this.owner = owner; }
  RC(Concept c) { this(c.id); }
  long longID() { return parseLong(id); }
  
  public String toString() {
    return id;
  }

  transient RemoteDB db;
  
  String getString(String field) { return db.xS(this, field); }
  Object get(String field) { return db.xget(this, field); }
  void set(String field, Object value) { db.xset(this, field, value); }

}

// Reference to a concept in another program
static class BaseXRef {
  String programID;
  long id;
    
  BaseXRef() {}
  BaseXRef(String programID, long id) {
  this.id = id;
  this.programID = programID;}
  
  public boolean equals(Object o) {
    if (!(o instanceof BaseXRef)) return false;
    BaseXRef r =  (BaseXRef) o;
    return eq(programID, r.programID) && eq(id, r.id);
  }
  
  public int hashCode() {
    return programID.hashCode() + (int) id;
  }
}

// BaseXRef as a concept
static class XRef extends Concept {
  BaseXRef ref;
  
  XRef() {}
  XRef(BaseXRef ref) {
  this.ref = ref; _doneLoading2(); }
  
  // after we have been added to concepts
  void _doneLoading2() {
    getIndex().put(ref, this);
  }
    
  HashMap<BaseXRef, XRef> getIndex() {
    return getXRefIndex(_concepts);
  }
}

static synchronized HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
  HashMap cache = (HashMap) concepts.perClassData.get(XRef.class);
  if (cache == null)
    concepts.perClassData.put(XRef.class, cache = new HashMap());
  return cache;
}

// uses mainConcepts
static XRef lookupOrCreateXRef(BaseXRef ref) {
  XRef xref = getXRefIndex(db_mainConcepts()).get(ref);
  if (xref == null)
    xref = new XRef(ref);
  return xref;
}

// define standard concept functions to use main concepts

static void cleanMeUp_concepts() {
  if (db_mainConcepts() != null) db_mainConcepts().cleanMeUp();
  // mainConcepts = null; // TODO
}

static void loadAndAutoSaveConcepts() {
  db_mainConcepts().persist();
}

static void loadAndAutoSaveConcepts(int interval) {
  db_mainConcepts().persist(interval);
}

static RC toPassRef(Concept c) {
  return new RC(c);
}

// so we can instantiate the program to run as a bare DB bot
static class MultiMap<A,B> {
  Map<A, List<B>> data = new HashMap<A, List<B>>();
  
  MultiMap() {}
  MultiMap(boolean useTreeMap) { if (useTreeMap) data = new TreeMap(); }
  MultiMap(MultiMap<A, B> map) { putAll(map); }
  MultiMap(Map<A, List<B>> data) {
  this.data = data;}

  void put(A key, B value) { synchronized(data) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = _makeEmptyList());
    list.add(value);
  }}

  void add(A key, B value) { put(key, value); }

  void addAll(A key, Collection<B> values) { synchronized(data) {
    putAll(key, values);
  }}
  
  void addAllIfNotThere(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      setPut(key, value);
  }}
  
  void setPut(A key, B value) { synchronized(data) {
    if (!containsPair(key, value))
      put(key, value);
  }}
  
  boolean containsPair(A key, B value) { synchronized(data) {
    return get(key).contains(value);
  }}
  
  void putAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      put(key, value);
  }}

  void removeAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      remove(key, value);
  }}
  
  List<B> get(A key) { synchronized(data) {
    List<B> list = data.get(key);
    return list == null ? Collections.<B> emptyList() : list;
  }}

  // returns actual mutable live list
  // creates the list if not there
  List<B> getActual(A key) { synchronized(data) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = _makeEmptyList());
    return list;
  }}
 
  void clean(A key) { synchronized(data) {
    List<B> list = data.get(key);
    if (list != null && list.isEmpty())
      data.remove(key);
  }}

  Set<A> keySet() { synchronized(data) {
    return data.keySet();
  }}

  Set<A> keys() { synchronized(data) {
    return data.keySet();
  }}

  void remove(A key) { synchronized(data) {
    data.remove(key);
  }}

  void remove(A key, B value) { synchronized(data) {
    List<B> list = data.get(key);
    if (list != null) {
      list.remove(value);
      if (list.isEmpty())
        data.remove(key);
    }
  }}

  void clear() { synchronized(data) {
    data.clear();
  }}

  boolean containsKey(A key) { synchronized(data) {
    return data.containsKey(key);
  }}

  B getFirst(A key) { synchronized(data) {
    List<B> list = get(key);
    return list.isEmpty() ? null : list.get(0);
  }}
  
  void addAll(MultiMap<A, B> map) { putAll(map); }
  
  void putAll(MultiMap<A, B> map) { synchronized(data) {
    for (A key : map.keySet())
      putAll(key, map.get(key));
  }}
  
  void putAll(Map<A, B> map) { synchronized(data) {
    if (map != null) for (Map.Entry<A, B> e : map.entrySet())
      put(e.getKey(), e.getValue());
  }}
  
  int keysSize() { synchronized(data) { return l(data); }}
  
  // full size - note: expensive operation
  int size() { synchronized(data) {
    int n = 0;
    for (List l : data.values())
      n += l(l);
    return n;
  }}
  
  // expensive operation
  List<A> reverseGet(B b) { synchronized(data) {
    List<A> l = new ArrayList();
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        l.add(key);
    return l;
  }}
  
  Map<A, List<B>> asMap() { synchronized(data) {
    return cloneMap(data);
  }}
  
  boolean isEmpty() { synchronized(data) { return data.isEmpty(); }}
  
  // override in subclasses
  List<B> _makeEmptyList() {
    return new ArrayList();
  }
  
  Collection<List<B>> allLists() {
    synchronized(data) {
      return new ArrayList(data.values());
    }
  }
  
  List<B> allValues() {
    return concatLists(values(data));
  }
  
  Object mutex() { return data; }
  
  public String toString() { return "mm" + str(data); }
}static class CancelToCancelPoint extends QuickException {
  CancelPoint cp;
  
  CancelToCancelPoint(CancelPoint cp) {
  this.cp = cp;}
}static class ConceptFieldIndexDesc<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val> {
  Class<A> cc;
  String field;
  HashMap<A,Val> objectToValue = new HashMap();
  MultiMap<Val, A> valueToObject;
  
  ConceptFieldIndexDesc() { valueToObject = treeMultiMap(reverseOrder()); }
  ConceptFieldIndexDesc(Class<A> cc, String field) { this(mainConcepts, cc, field); }
  ConceptFieldIndexDesc(Concepts concepts, Class<A> cc, String field) {
    this();
  this.field = field;
  this.cc = cc;
    concepts.addConceptIndex(this);
    for (A c : list(concepts, cc))
      updateImpl(c);
    concepts.addFieldIndex(cc, field, this);
  }
  
  public void update(Concept c) {
    if (!isInstance(cc, c)) return;
    updateImpl(c);
  }
  
  synchronized void updateImpl(Concept c) {
    Val newValue =  (Val) (cget(c, field));
    Val oldValue = objectToValue.get(c);
    if (newValue == null || newValue != oldValue) {
      valueToObject.remove(oldValue, (A) c);
      valueToObject.put(newValue, (A) c);
      objectToValue.put((A) c, newValue);
    }
  }
  
  public synchronized void remove(Concept c) {
    if (!isInstance(cc, c)) return;
    Val value =  (Val) (cget(c, field));
    objectToValue.remove(c);
    valueToObject.remove(value, (A) c);
  }
  
  synchronized A get(Val value) {
    return valueToObject.getFirst(value);
  }
  
  public synchronized List<A> getAll(Val value) {
    return valueToObject.get(value);
  }
  
  public synchronized List<Val> allValues() { return cloneKeys_noSync(valueToObject.data); }
  
  IterableIterator<A> objectIterator() {
    return navigableMultiMapValuesIterator(valueToObject);
  }
  
  public synchronized MultiSet<Val> allValues_multiSet() {
    return multiMapToMultiSet(valueToObject);
  }
}static class Lowest<A> {
  A best;
  double score;
  transient Object onChange;
  
  synchronized boolean isNewBest(double score) {
    return best == null || score < this.score;
  }
  
  synchronized double bestScore() {
    return best == null ? Double.NaN : score;
  }
  
  double score() { return bestScore(); }
  
  synchronized float floatScore() {
    return best == null ? Float.NaN : (float) score;
  }
  
  synchronized float floatScoreOr(float defaultValue) {
    return best == null ? defaultValue : (float) score;
  }
  
  boolean put(A a, double score) {
    boolean change = false;
    synchronized(this) {
      if (a != null && isNewBest(score)) {
        best = a;
        this.score = score;
        change = true;
      }
    }
    if (change)
      pcallF(onChange);
    return change;
  }
  
  synchronized A get() { return best; }
  synchronized boolean has() { return best != null; }
}static interface IResourceLoader {
  String loadSnippet(String snippetID);
  String getTranspiled(String snippetID); // with libs
  int getSnippetType(String snippetID);
  String getSnippetTitle(String snippetID);
  File loadLibrary(String snippetID);
  File pathToJavaXJar();
  File getSnippetJar(String snippetID, String transpiledSrc);
}static class ReliableSingleThread implements Runnable {
  Object runnable;
  boolean trigger = false;
  Thread thread;
  String name = "Single Thread";
  F0<AutoCloseable> enter; // optional ownership marker, e.g. for DynModules
  
  ReliableSingleThread(Object runnable) {
  this.runnable = runnable;}
  
  void trigger() { go(); }
  synchronized void go() {
    trigger = true;
    if (!running()) {
       AutoCloseable __1570 = callF(enter); try {
      thread = startThread(name, new Runnable() {  public void run() { try { 
         AutoCloseable __1571 = callF(enter); try {
        _run();
      } finally { _close(__1571); }
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "AutoCloseable __1571 = callF(enter); try {\r\n        _run();\r\n      } finally ..."; }});
    } finally { _close(__1570); }}
  }
  public void run() { go(); }
  void get() { go(); } // so you can use the ! syntax
  
  synchronized boolean running() { return thread != null; }
  
  // use only if this is the last time you trigger this
  void triggerAndWait() {
    trigger();
    while (running()) sleep(1);
  }
  
  void _run() {
    while (licensed()) {
      synchronized(this) {
        if (!trigger) {
          thread = null;
          break;
        }
        trigger = false;
      }
      pcallF(runnable);
    }
  }
  
  synchronized void cancel() {
    cancelAndInterruptThread(thread);
    thread = null;
  }
}static class PKIKeyPair {
  String privateKey;
  String publicKey;
  PKIKeyPair() {}
  PKIKeyPair(String privateKey, String publicKey) {
  this.publicKey = publicKey;
  this.privateKey = privateKey;}public boolean equals(Object o) {
    if (!(o instanceof PKIKeyPair)) return false;
    PKIKeyPair x =  (PKIKeyPair) o;
    return eq(privateKey, x.privateKey) && eq(publicKey, x.publicKey);
  }
  
  public int hashCode() {
    int h = -1731104693;
    h = h*2+_hashCode(privateKey);
    h = h*2+_hashCode(publicKey);
    return h;
  }
  
  public String toString() { return "PKIKeyPair([secret], " + quote(publicKey) + ")"; }
}// uses HashMap by default
static class MultiSet<A> {
  Map<A, Integer> map = new HashMap();
  
  MultiSet(boolean useTreeMap) {
    if (useTreeMap) map = new TreeMap();
  }
  MultiSet() {}
  MultiSet(Iterable<A> c) { addAll(c); }
  MultiSet(MultiSet<A> ms) { synchronized(ms) {
    for (A a : ms.keySet()) add(a, ms.get(a));
  }}
  
  synchronized void add(A key) { add(key, 1); }
  
  synchronized void addAll(Iterable<A> c) {
    if (c != null) for (A a : c) add(a);
  }

  synchronized void addAll(MultiSet<A> ms) {
    for (A a : ms.keySet()) add(a, ms.get(a));
  }
  
  synchronized void add(A key, int count) {
    if (count <= 0) return;
    if (map.containsKey(key))
      map.put(key, map.get(key)+count);
    else
      map.put(key, count);
  }

  synchronized int get(A key) {
    Integer i = map.get(key);
    return i != null ? i : 0;
    //ret key != null && map.containsKey(key) ? map.get(key) : 0;
  }
  
  synchronized boolean contains(A key) {
    return map.containsKey(key);
  }

  synchronized void remove(A key) {
    Integer i = map.get(key);
    if (i != null && i > 1)
      map.put(key, i - 1);
    else
      map.remove(key);
  }

  synchronized List<A> topTen() { return getTopTen(); }
  
  synchronized List<A> getTopTen() { return getTopTen(10); }
  synchronized List<A> getTopTen(int maxSize) {
    List<A> list = getSortedListDescending();
    return list.size() > maxSize ? list.subList(0, maxSize) : list;
  }
  
  synchronized List<A> highestFirst() {
    return getSortedListDescending();
  }

  synchronized List<A> lowestFirst() {
    return reversedList(getSortedListDescending());
  }

  synchronized List<A> getSortedListDescending() {
    List<A> list = new ArrayList<A>(map.keySet());
    Collections.sort(list, new Comparator<A>() {
      public int compare(A a, A b) {
        return map.get(b).compareTo(map.get(a));
      }
    });
    return list;
  }

  synchronized int getNumberOfUniqueElements() {
    return map.size();
  }
  
  synchronized int uniqueSize() {
    return map.size();
  }

  synchronized Set<A> asSet() {
    return map.keySet();
  }

  synchronized NavigableSet<A> navigableSet() {
    return navigableKeys((NavigableMap) map);
  }

  synchronized Set<A> keySet() {
    return map.keySet();
  }
  
  synchronized A getMostPopularEntry() {
    int max = 0;
    A a = null;
    for (Map.Entry<A,Integer> entry : map.entrySet()) {
      if (entry.getValue() > max) {
        max = entry.getValue();
        a = entry.getKey();
      }
    }
    return a;
  }

  synchronized void removeAll(A key) {
    map.remove(key);
  }

  synchronized int size() {
    int size = 0;
    for (int i : map.values())
      size += i;
    return size;
  }

  synchronized MultiSet<A> mergeWith(MultiSet<A> set) {
    MultiSet<A> result = new MultiSet<A>();
    for (A a : set.asSet()) {
      result.add(a, set.get(a));
    }
    return result;
  }
  
  synchronized boolean isEmpty() {
    return map.isEmpty();
  }
  
  synchronized public String toString() { // hmm. sync this?
    return str(map);
  }
  
  synchronized void clear() {
    map.clear();
  }
  
  synchronized Map<A, Integer> asMap() {
    return cloneMap(map);
  }
}static class T3<A, B, C> {
  A a;
  B b;
  C c;
  
  T3() {}
  T3(A a, B b, C c) {
  this.c = c;
  this.b = b;
  this.a = a;}
  T3(T3<A, B, C> t) { a = t.a; b = t.b; c = t.c; }
  
  public int hashCode() {
    return _hashCode(a) + 2*_hashCode(b) - 4*_hashCode(c);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof T3)) return false;
    T3 t = (T3) o;
    return eq(a, t.a) && eq(b, t.b) && eq(c, t.c);
  }
  
  public String toString() {
    return "(" + quoteBorderless(a) + ", " + quoteBorderless(b) + ", " + quoteBorderless(c) + ")";
  }
}static class Pair<A, B> implements Comparable<Pair<A, B>> {
  A a;
  B b;

  Pair() {}
  Pair(A a, B b) {
  this.b = b;
  this.a = a;}
  
  public int hashCode() {
    return hashCodeFor(a) + 2*hashCodeFor(b);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof Pair)) return false;
    Pair t = (Pair) o;
    return eq(a, t.a) && eq(b, t.b);
  }
  
  public String toString() {
    return "<" + a + ", " + b + ">";
  }
  
  public int compareTo(Pair<A, B> p) {
    if (p == null) return 1;
    int i = ((Comparable<A>) a).compareTo(p.a);
    if (i != 0) return i;
    return ((Comparable<B>) b).compareTo(p.b);
  }
}static class ConceptFieldIndex<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter {
  Class<A> cc;
  String field;
  HashMap<A,Val> objectToValue = new HashMap();
  MultiMap<Val,A> valueToObject = new MultiMap();
  
  ConceptFieldIndex() {}
  ConceptFieldIndex(Class<A> cc, String field) { this(mainConcepts, cc, field); }
  ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) {
  this.field = field;
  this.cc = cc;
    concepts.addConceptIndex(this);
    for (A c : list(concepts, cc))
      updateImpl(c);
    concepts.addFieldIndex(cc, field, this);
  }
  
  public void update(Concept c) {
    if (!isInstance(cc, c)) return;
    updateImpl(c);
  }
  
  synchronized void updateImpl(Concept c) {
    Val newValue =  (Val) (cget(c, field));
    Val oldValue = objectToValue.get(c);
    if (newValue == null || newValue != oldValue) {
      valueToObject.remove(oldValue, (A) c);
      valueToObject.put(newValue, (A) c);
      objectToValue.put((A) c, newValue);
    }
  }
  
  public synchronized void remove(Concept c) {
    if (!isInstance(cc, c)) return;
    Val value =  (Val) (cget(c, field));
    objectToValue.remove(c);
    valueToObject.remove(value, (A) c);
  }
  
  synchronized A get(Val value) {
    return valueToObject.getFirst(value);
  }
  
  public synchronized List<A> getAll(Val value) {
    
    
      return valueToObject.get(value);
    
  }
  
  public synchronized List<Val> allValues() { return cloneKeys_noSync(valueToObject.data); }
  
  public synchronized MultiSet<Val> allValues_multiSet() {
    return multiMapToMultiSet(valueToObject);
  }
  
  public Class<? extends Concept> conceptClass() { return cc; }
  public int countConcepts() { return l(objectToValue); }
  public Collection<Concept> allConcepts() { return (Collection) keys(objectToValue); }
}static abstract class F0<A> {
  abstract A get();
}static abstract class F1<A, B> {
  abstract B get(A a);
}// you still need to implement hasNext() and next()
static abstract class IterableIterator<A> implements Iterator<A>, Iterable<A> {
  public Iterator<A> iterator() {
    return this;
  }
  
  public void remove() {
    unsupportedOperation();
  }
}static abstract class F2<A, B, C> {
  abstract C get(A a, B b);
}// TODO: Android N seems to deprecate SHA1PRNG
// https://android-developers.googleblog.com/2016/06/security-crypto-provider-deprecated-in.html

static class PKI {
  static String getProvider() {
    return isAndroid() ? /*"AndroidOpenSSL"*/ "BC" : "SUN";
  }
  
  public static boolean verifySignature(byte[] publicKey, byte[] signature, String file)
    throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, IOException, SignatureException, InvalidKeySpecException {
    Signature sig = initPublicSignature(publicKey);

    FileInputStream datafis = new FileInputStream(file);
    BufferedInputStream bufin = new BufferedInputStream(datafis);

    byte[] buffer = new byte[1024];
    while (bufin.available() != 0) {
      int len = bufin.read(buffer);
      sig.update(buffer, 0, len);
    }

    bufin.close();

    return sig.verify(signature);
  }

  public static boolean verifySignature(byte[] publicKey, byte[] signature, byte[] data) { try {
    Signature sig = initPublicSignature(publicKey);
    sig.update(data);
    return sig.verify(signature);
  } catch (Exception __e) { throw rethrow(__e); } }

  private static Signature initPublicSignature(byte[] publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException {
    Signature sig = Signature.getInstance("SHA1withDSA", getProvider());
    PublicKey pub = KeyFactory.getInstance("DSA", getProvider()).generatePublic(new X509EncodedKeySpec(publicKey));
    sig.initVerify(pub);
    return sig;
  }

  public static byte[] sign(String file, byte[] privateKey) { try {
    Signature dsa = initSignature(privateKey);

    FileInputStream fis = new FileInputStream(file);
    BufferedInputStream bufin = new BufferedInputStream(fis);
    byte[] buffer = new byte[1024];
    int len;
    while ((len = bufin.read(buffer)) >= 0)
      dsa.update(buffer, 0, len);
    bufin.close();

    return dsa.sign();
  } catch (Exception __e) { throw rethrow(__e); } }

  public static byte[] sign(byte[] data, byte[] privateKey) { try {
    Signature dsa = initSignature(privateKey);
    dsa.update(data);
    return dsa.sign();
  } catch (Exception __e) { throw rethrow(__e); } }

  private static Signature initSignature(byte[] privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException {
    Signature dsa = Signature.getInstance("SHA1withDSA", getProvider());
    //X509EncodedKeySpec keySpec = new X509EncodedKeySpec(privateKey);
    EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
    PrivateKey priv = KeyFactory.getInstance("DSA", getProvider()).generatePrivate(keySpec);
    dsa.initSign(priv);
    return dsa;
  }

  public static KeyPair makeKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
    KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA", getProvider());
    // OLD SecureRandom random = SecureRandom.getInstance("SHA1PRNG", getProvider());
    // should work on Android?
    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");

    keyGen.initialize(1024, random);
    return keyGen.generateKeyPair();
  }

  // Standard key pair is for the MACHINE (not the user)
  public static boolean makeStandardKeyPairIfNecessary() { try {
    File publicKeyPath = getStandardPublicKeyPath();
    File privateKeyPath = getStandardPrivateKeyPath();
    if (!publicKeyPath.exists()) {
      print("PKI: Making standard key pair");
      KeyPair keyPair = makeKeyPair();
      byte[] privateKey = keyPair.getPrivate().getEncoded();
      print("PKI: Private key hex (debug) - " + bytesToHex(privateKey));
      saveTextFile(privateKeyPath, privateKeyToString(privateKey));
      String publicKey = publicKeyToString(keyPair.getPublic());
      saveTextFile(publicKeyPath, publicKey);
      print("PKI: Standard key pair made!");
      print();
      printInfo();
      return true;
    }
    return false;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  static void printInfo() {
    print("PKI: Machine's public key: " + publicKeyToString(getStandardPublicKey()));
    print("PKI: Machine's private key in: " + getStandardPrivateKeyPath());
    print("PKI: Machine's public key also in: " + getStandardPublicKeyPath());
    print("PKI: User's public key: " + publicKeyToString(userPublicKey()));
    print("PKI: User's private key in: " + userPrivateKeyPath());
    print("PKI: User's public key also in: " + userPublicKeyPath());
  }

  public static File getStandardPrivateKeyPath() {
    return new File(getSecretProgramDir("#1001547"), "Computer-Private-Key");
  }

  public static File userPublicKeyPath() {
    return new File(getProgramDir("#1001547"), "User-Public-Key");
  }

  public static File userPrivateKeyPath() {
    return new File(getSecretProgramDir("#1001547"), "User-Private-Key");
  }

  public static File getStandardPublicKeyPath() {
    return new File(getProgramDir("#1001547"), "Computer-Public-Key");
  }

  public static byte[] getStandardPrivateKey() {
    makeStandardKeyPairIfNecessary();
    return privateKeyFromString(loadTextFile(getStandardPrivateKeyPath()));
  }

  public static byte[] getStandardPublicKey() {
    makeStandardKeyPairIfNecessary();
    return publicKeyFromString(loadTextFile(getStandardPublicKeyPath()));
  }

  public static byte[] userPrivateKey() {
    makeUserKeyPairIfNecessary();
    return privateKeyFromString(loadTextFile(userPrivateKeyPath()));
  }

  public static byte[] userPublicKey() {
    makeUserKeyPairIfNecessary();
    return publicKeyFromString(loadTextFile(userPublicKeyPath()));
  }

  private static String publicKeyToString(PublicKey publicKey) {
    return publicKeyToString(publicKey.getEncoded());
  }

  public static String privateKeyToString(PrivateKey privateKey) {
    return privateKeyToString(privateKey.getEncoded());
  }

  public static byte[] publicKeyFromString(String key) {
    return base64decode(dropPrefixMandatory("publickey:", trim(key)));
  }

  public static byte[] privateKeyFromString(String key) {
    return base64decode(dropPrefixMandatory("privatekey:", trim(key)));
  }

  public static byte[] signatureFromString(String key) {
    return base64decode(key);
  }

  public static byte[] dataFromString(String text) {
    return toUtf8(text);
  }

  public static String signatureToString(byte[] signature) {
    return base64encode(signature);
  }

  public static String publicKeyToString(byte[] key) {
    return "publickey:" + base64encode(key);
  }

  public static String privateKeyToString(byte[] key) {
    return "privatekey:" + base64encode(key);
  }
  
  static boolean makeUserKeyPairIfNecessary() { try {
    File publicKeyPath = userPublicKeyPath();
    File privateKeyPath = userPrivateKeyPath();
    if (!publicKeyPath.exists()) {
      print("PKI: Making user key pair");
      KeyPair keyPair = makeKeyPair();
      byte[] privateKey = keyPair.getPrivate().getEncoded();
      print("PKI: Private key hex (debug) - " + bytesToHex(privateKey));
      saveTextFile(privateKeyPath, privateKeyToString(privateKey));
      String publicKey = publicKeyToString(keyPair.getPublic());
      saveTextFile(publicKeyPath, publicKey);
      print("PKI: User key pair made!");
      print();
      printInfo();
      return true;
    }
    return false;
  } catch (Exception __e) { throw rethrow(__e); } }
}
static class CancelPoint implements AutoCloseable {
  volatile boolean closed = false;
  
  public void close() { closed = true; }
}// elements are put to front when added (not when accessed)
static class MRUCache<A, B> extends LinkedHashMap<A, B> {
  int maxSize = 10;

  MRUCache() {}
  MRUCache(int maxSize) {
  this.maxSize = maxSize;}
  
  protected boolean removeEldestEntry(Map.Entry eldest) {
    return size() > maxSize;
  }
}static interface IF0<A> {
  A get();
}static abstract class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {
  public void close() throws Exception {}
}static interface IF2<A, B, C> {
  C get(A a, B b);
}static class ConceptFieldIndexCI<A extends Concept> implements IConceptIndex, IFieldIndex<A, String>, IConceptCounter {
  Class<A> cc;
  String field;
  HashMap<A,String> objectToValue = new HashMap();
  MultiMap<String, A> valueToObject = ciMultiMap();
  
  ConceptFieldIndexCI() {}
  ConceptFieldIndexCI(Class<A> cc, String field) { this(db_mainConcepts(), cc, field); }
  ConceptFieldIndexCI(Concepts concepts, Class<A> cc, String field) {
  this.field = field;
  this.cc = cc;
    concepts.addConceptIndex(this);
    for (A c : list(concepts, cc))
      updateImpl(c);
    concepts.addCIFieldIndex(cc, field, this);
  }
  
  public void update(Concept c) {
    if (!isInstance(cc, c)) return;
    updateImpl(c);
  }
  
  synchronized void updateImpl(Concept c) {
    String newValue =  (String) (cget(c, field));
    String oldValue = objectToValue.get(c);
    if (newValue == null || newValue != oldValue) {
      valueToObject.remove(oldValue, (A) c);
      valueToObject.put(newValue, (A) c);
      objectToValue.put((A) c, newValue);
    }
  }
  
  public synchronized void remove(Concept c) {
    if (!isInstance(cc, c)) return;
    String value =  (String) (cget(c, field));
    objectToValue.remove(c);
    valueToObject.remove(value, (A) c);
  }
  
  synchronized A get(String value) {
    return valueToObject.getFirst(value);
  }
  
  public synchronized List<A> getAll(String value) {
    return valueToObject.get(value);
  }
  
  public Class<? extends Concept> conceptClass() { return cc; }
  public int countConcepts() { return l(objectToValue); }
  public Collection<Concept> allConcepts() { return (Collection) keys(objectToValue); }
  
  public synchronized List<String> allValues() { return cloneKeys_noSync(valueToObject.data); }
  
  public synchronized MultiSet<String> allValues_multiSet() {
    return multiMapToMultiSet(valueToObject);
  }
}static interface Producer<A> {
  public A next();
}static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

static class DynamicObject {
  String className; // just the name, without the "main$"
  LinkedHashMap<String,Object> fieldValues = new LinkedHashMap();
  
  DynamicObject() {}
  // className = just the name, without the "main$"
  DynamicObject(String className) {
  this.className = className;}
  
  Map<String, Object> _map() { return fieldValues; }
}static interface IF1<A, B> {
  B get(A a);
}static class PersistableThrowable {
  String className;
  String msg;
  String stacktrace;
  
  PersistableThrowable() {}
  PersistableThrowable(Throwable e) {
    if (e == null)
      className = "Crazy Null Error";
    else {
      className = getClassName(e).replace('/', '.');
      msg = e.getMessage();
      stacktrace = getStackTrace_noRecord(e);
    }
  }
  
  public String toString() {
    return nempty(msg) ? className + ": " + msg : className;
  }
}// TODO: run dbBot()

static class ConceptsLoadedOnDemand {
  Map<String,Concepts> loaded = new HashMap(); // key = just the case ID. value can be null in case of error
  List onCaseLoaded; // L<voidfunc(S caseID, O extraInfo, Concepts concepts)>
  List onUnloadingCase; // L<voidfunc(S caseID, Concepts concepts)>
  Lock lock = lock();
  
  Concepts get(String caseID, Object extraInfo) { return conceptsForCase(caseID, extraInfo); }
  
  Concepts getIfLoaded(String caseID) {
    Lock __1601 = lock; lock(__1601); try {
    return loaded.get(unnull(caseID));
  } finally { unlock(__1601); } }
  
  // caseID may be empty, then you get the program's main DB
  Concepts conceptsForCase(String caseID, Object extraInfo) {
    Lock __1602 = lock; lock(__1602); try {
    //assertNempty(+caseID);
    caseID = unnull(caseID);
    
    if (loaded.containsKey(caseID))
      return assertNotNull("Concepts load error", loaded.get(caseID));

    String id = dbID(caseID);
    print("Loading concepts for case " + id);
    Concepts cc = new Concepts(id);
    cc.persist();
    loaded.put(caseID, cc);
    pcallFAll(onCaseLoaded, caseID, extraInfo, cc);
    return cc;
  } finally { unlock(__1602); } }
  
  String dbID(String caseID) {
    return combineWithSlash(getDBProgramID(), caseID);
  }
  
  void cleanMeUp() {
    cleanUpAndClear(loaded);
  }
  
  void onCaseLoaded(VF3<String, Object, Concepts> f) {
    onCaseLoaded = listCreateAndAdd(onCaseLoaded, f);
  }
  
  void onUnloadingCase(VF2<String, Concepts> f) {
    onUnloadingCase = listCreateAndAdd(onUnloadingCase, f);
  }
  
  void unloadCase(String caseID) {
    Lock __1603 = lock; lock(__1603); try {
    caseID = unnull(caseID);
    Concepts cc = loaded.get(caseID);
    if (cc != null) {
      pcallFAll(onUnloadingCase, caseID, cc);
      cleanUp(cc);
      loaded.remove(caseID);
    }
  } finally { unlock(__1603); } }
}

static class QuickException extends RuntimeException {
  public Throwable fillInStackTrace() { return this; }
  
  QuickException() {}
  QuickException(Throwable e) { super(e); }
  QuickException(String msg) { super(msg); }
  QuickException(String msg, Throwable e) { super(msg, e); }
}static interface IConceptCounter {
  Class<? extends Concept> conceptClass();
  int countConcepts();
  Collection<Concept> allConcepts();
}static interface IVF1<A> {
  void get(A a);
}static interface IVar<A> {
  void set(A a);
  A get();
  boolean has();
  void clear();
}static class RemoteDB implements AutoCloseable {
  DialogIO db;
  String name;
  
  // s = bot name or snippet ID
  RemoteDB(String s) {
    this(s, false);
  }
  
  RemoteDB(String s, boolean autoStart) {
    name = s;
    if (isSnippetID(s)) name = dbBotName(s);
    db = findBot(name);
    if (db == null)
      if (autoStart) {
        nohupJavax(fsI(s));
        waitForBotStartUp(name);
        assertNotNull("Weird problem", db = findBot(s));
      } else
        throw fail("DB " + s + " not running");
  }

  boolean functional() { return db != null; } // now always true
  
  List<RC> list() { return adopt((List<RC>) rpc(db, "xlist")); }
  List<RC> list(String className) { return adopt((List<RC>) rpc(db, "xlist", className)); }
  List<RC> xlist() { return list(); }
  List<RC> xlist(String className) { return list(className); }
  
  // adopt is an internal method
  List<RC> adopt(List<RC> l) {
    if (l != null) for (RC rc : l) adopt(rc);
    return l;
  }
  
  RC adopt(RC rc) { if (rc != null) rc.db = this; return rc; }
  
  Object adopt(Object o) {
    if (o instanceof RC) return adopt((RC) o);
    return o;
  }
  
  String xclass(RC o) {
    return (String) rpc(db, "xclass", o);
  }
  
  Object xget(RC o, String field) {
    return adopt(rpc(db, "xget", o, field));
  }
  
  String xS(RC o, String field) {
    return (String) xget(o, field);
  }
  
  RC xgetref(RC o, String field) {
    return adopt((RC) xget(o, field));
  }
  
  void xset(RC o, String field, Object value) {
    rpc(db, "xset", o, field, value);
  }
  
  RC uniq(String className) {
    RC ref = first(list(className));
    if (ref == null)
      ref = xnew(className);
    return ref;
  }
  RC xuniq(String className) { return uniq(className); }
  
  RC xnew(String className, Object... values) {
    return adopt((RC) rpc(db, "xnew", className, values));
  }
  
  void xdelete(RC o) {
    rpc(db, "xdelete", o);
  }
  
  void xdelete(List<RC> l) {
    rpc(db, "xdelete", l);
  }

  public void close() {
    _close(db);
  }
  
  String fullgrab() { return (String) rpc(db, "xfullgrab"); }
  String xfullgrab() { return fullgrab(); }
  
  void xshutdown() { rpc(db, "xshutdown"); }
  
  long xchangeCount() { return (long) rpc(db, "xchangeCount"); }
  int xcount() { return (int) rpc(db, "xcount"); }

  void reconnect() {
    close();
    db = findBot(name);
  }
  
  RC rc(long id) { return new RC(this, id); }
}

static abstract class DialogIO implements AutoCloseable {
  String line;
  boolean eos, loud, noClose;
  Lock lock = lock();
  
  abstract String readLineImpl();
  abstract boolean isStillConnected();
  abstract void sendLine(String line);
  abstract boolean isLocalConnection();
  abstract Socket getSocket();

  int getPort() { Socket s = getSocket(); return s == null ? 0 : s.getPort(); }
  
  boolean helloRead = false;
  int shortenOutputTo = 500;
  
  String readLineNoBlock() {
    String l = line;
    line = null;
    return l;
  }
  
  boolean waitForLine() { try {
    ping();
    if (line != null) return true;
    //print("Readline");
    line = readLineImpl();
    //print("Readline done: " + line);
    if (line == null) eos = true;
    return line != null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLine() {
    waitForLine();
    helloRead = true;
    return readLineNoBlock();
  }
  
  String ask(String s, Object... args) {
    if (loud) return askLoudly(s, args);
    if (!helloRead) readLine();
    if (args.length != 0) s = format3(s, args);
    sendLine(s);
    return readLine();
  }
  
  String askLoudly(String s, Object... args) {
    if (!helloRead) readLine();
    if (args.length != 0) s = format3(s, args);
    print("> " + shorten(s, shortenOutputTo));
    sendLine(s);
    String answer = readLine();
    print("< " + shorten(answer, shortenOutputTo));
    return answer;
  }
  
  void pushback(String l) {
    if (line != null)
      throw fail();
    line = l;
    helloRead = false;
  }
}

static abstract class DialogHandler {
  abstract void run(DialogIO io);
}

static Lock dbLock() {
  return db_mainConcepts().lock;
}
static boolean bareDBMode_on = false;

static void bareDBMode() {
  bareDBMode(null); // default autoSaveInterval
}

static void bareDBMode(Integer autoSaveInterval) {
  bareDBMode_on = true;
  conceptsAndBot(autoSaveInterval);
}
static Field makeAccessible(Field f) {
  f.setAccessible(true);
  return f;
}

static Method makeAccessible(Method m) {
  m.setAccessible(true);
  return m;
}
static Set<Class> allInterfacesImplementedBy(Class c) {
  if (c == null) return null;
  HashSet<Class> set = new HashSet();
  allInterfacesImplementedBy_find(c, set);
  return set;
}

static void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
  if (c.isInterface() && !set.add(c)) return;
  do {
    for (Class intf : c.getInterfaces())
      allInterfacesImplementedBy_find(intf, set);
  } while ((c = c.getSuperclass()) != null);
}
static Method findMethod(Object o, String method, Object... args) {
  return findMethod_cached(o, method, args);
}

static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}
static Method findStaticMethod(Class c, String method, Object... args) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (!m.getName().equals(method))
        continue;

      if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static boolean findStaticMethod_checkArgs(Method m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length)
    return false;
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
  return true;
}

static String fsi(String id) {
  return formatSnippetID(id);
}
static List<String> quoteAll(Collection<String> l) {
  List<String> x = new ArrayList();
  for (String s : l)
    x.add(quote(s));
  return x;
}
static int _hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}
static boolean arraysEqual(Object[] a, Object[] b) {
  if (a.length != b.length) return false;
  for (int i = 0; i < a.length; i++)
    if (neq(a[i], b[i])) return false;
  return true;
}
static <A> A set(A o, String field, Object value) {
  if (o == null) return null;
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    f.setAccessible(true);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
  return o;
}

static void set(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = set_findStaticField(c, field);
    f.setAccessible(true);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
static <B, A extends B> A addAndReturn(Collection<B> c, A a) {
  if (c != null) c.add(a);
  return a;
}
  static File tempDir() {
    return makeTempDir();
  }
static File createTempFile() {
  return createTempFile("tmp", null);
}

static File createTempFile(String prefix, String suffix) { try {
  // File.createTempFile needs at least 3 prefix characters, so we
  // fíll them up for you
  File f = File.createTempFile(takeFirst(10, pad(nohup_sanitize(prefix), 3, '-')), nohup_sanitize(suffix));
  f.deleteOnExit();
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static HashMap lithashmap(Object... x) {
  return litmap(x);
}
// name currently not used, we only call a method called "_wrap" in
// the main class with the to-wrapped object as first argument and
// a list of other parameters as second argument.
static <A> A wrapStuff(String name, A object, Object... args) {
  //ret or(object, (A) callOpt(mc(), "wrap" + name,
  //  toObjectArray(concatLists(litlist((O) object), toList(args)))));
  return or((A) callOpt(mc(), "_wrap", object, asList(args)), object);
}
static void printMyIPs() {
String ip;
  try {
      Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
      while (interfaces.hasMoreElements()) {
          NetworkInterface iface = interfaces.nextElement();
          // filters out 127.0.0.1 and inactive interfaces
          if (iface.isLoopback() || !iface.isUp())
              continue;

          Enumeration<InetAddress> addresses = iface.getInetAddresses();
          while(addresses.hasMoreElements()) {
              InetAddress addr = addresses.nextElement();
              ip = addr.getHostAddress();
if (ip.startsWith("127.")) continue;
boolean local = addr.isSiteLocalAddress() || ip.startsWith("fe");
              System.out.println(iface.getDisplayName() + " " + ip + " " + (local ? "(private address)" : "(public address)"));
          }
      }
  } catch (Throwable e) {
      e.printStackTrace();
  }
}
static String stdToString(Object o) {
  return standard_toString(o);
}
static boolean stdEq2(Object a, Object b) {
  if (a == null) return b == null;
  if (b == null) return false;
  if (a.getClass() != b.getClass()) return false;
  for (String field : allFields(a))
    if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
  return true;
}
static int stdHash2(Object a) {
  if (a == null) return 0;
  return stdHash(a, toStringArray(allFields(a)));
}
static String assertGlobalID(String s) {
  return assertPossibleGlobalID(s);
}
static BigInteger plus(BigInteger a, BigInteger b) {
  return a.add(b);
}

static BigInteger plus(BigInteger a, long b) {
  return a.add(bigint(b));
}
static BigInteger mul(BigInteger a, BigInteger b) {
  return a.multiply(b);
}

static BigInteger mul(BigInteger a, long b) {
  return a.multiply(bigint(b));
}
static String bigintToGlobalID(BigInteger value) {
  char[] buf = new char[16];
  for (int i = 16-1; i >= 0; i--) {
    buf[i] = charPlus('a', mod(value, 26).intValue());
    value = div(value, 26);
  }
  return str(buf);
}
static <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
  return lookupAllOpt(map, l);
}

static <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
  return lookupAllOpt(map, l);
}
static boolean hasConcept(Class<? extends Concept> c, Object... params) {
  return findConceptWhere(c, params) != null;
}
static Object load(String varName) {
  readLocally(varName);
  return get(mc(), varName);
}

static Object load(String progID, String varName) {
  readLocally(progID, varName);
  return get(mc(), varName);
}
static boolean exceptionMessageContains(Throwable e, String s) {
  return cic(getInnerMessage(e), s);
}
static void printShortException(Throwable e) {
  print(exceptionToStringShort(e));
}

static void printShortException(String s, Throwable e) {
  print(s, exceptionToStringShort(e));
}
static void clearConcepts() {
  db_mainConcepts().clearConcepts();
}

static void clearConcepts(Concepts concepts) {
  concepts.clearConcepts();
}
static void restoreLatestBackupIfConceptsFileEmpty(String dbID, Object... __) {
  boolean doIt = boolPar("doIt",__);
  File file = conceptsFile(dbID);
  if (fileExists(file) && fileSize(file) == 0) {
    print(file + " corrupted, trying to restore");
    File backup = lastThat("fileNotEmpty",sortByFileName(conceptBackupFiles(dbID)));
    if (backup == null) { print("No usable backup found :("); return; }
    String msg = "RESTORING: " + backup;
    File log = javaxDataDir("db-restores.log");
    if (doIt) logQuotedWithTime(log, msg);
    print(stringIf(!doIt, "[would be] ") + msg);
    if (doIt) {
      clearConceptsOf(dbID);
      copyFile(backup, file);
      print(msg = "DB RESTORED!");
      if (doIt) logQuotedWithTime(log, msg);
    }
  }
}
static void readLocally(String progID, String varNames) {
  readLocally2(mc(), progID, varNames);
}

static void readLocally(String varNames) {
  readLocally2(mc(), programID(), varNames);
}

static void readLocally2(Object obj, String varNames) {
  readLocally2(obj, programID(), varNames);
}

static int readLocally_stringLength;

static ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();
static ThreadLocal readLocally2_classFinder = new ThreadLocal();

// read a string variable from standard storage
// does not overwrite variable contents if there is no file
static void readLocally2(Object obj, String progID, String varNames) { try {
  boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
  for (String variableName : javaTokC(varNames)) {
    File textFile = new File(programDir(progID), variableName + ".text");
    
    String value = loadTextFile(textFile);
    if (value != null)
      set(main.class, variableName, value);
    else {
      File structureFile = new File(programDir(progID), variableName + ".structure");
      value = loadTextFile(structureFile);
      
      if (value == null) {
        File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
        if (!structureGZFile.isFile()) return;
        //value = loadGZTextFile(structureGZFile);
         InputStream fis = new FileInputStream(structureGZFile); try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(reader);
        //O o = unstructure_reader(bufferedReader);
        Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, readLocally2_classFinder.get());
        readLocally_set(obj, variableName, o);
        return;
      } finally { _close(fis); }}
      
      readLocally_stringLength = l(value);
      if (nempty(value))
        readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void readLocally_set(Object c, String varName, Object value) {
  Object oldValue = get(c, varName);
  if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
    // Assume it's a synchroList.
    value = synchroList((List) value);
  }
  set(c, varName, value);
}

static int done_minPrint = 10;

static long done(long startTime, String desc) {
  long time = now()-startTime;
  if (time >= done_minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done(String desc, long startTime) {
  return done(startTime, desc);
}

static long done(long startTime) {
  return done(startTime, "");
}
static long fileSize(String path) { return getFileSize(path); }
static long fileSize(File f) { return getFileSize(f); }

static RemoteDB connectToDBOpt(String dbNameOrID) { try {
  return new RemoteDB(dbNameOrID);
} catch (Throwable __e) { return null; } }
static Concept getConcept(long id) {
  return db_mainConcepts().getConcept(id);
}

static <A extends Concept> A getConcept(Class<A> cc, long id) {
  return getConcept(db_mainConcepts(), cc, id);
}

static <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
  Concept c = concepts.getConcept(id);
  if (c == null) return null;
  if (!isInstance(cc, c))
    throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
  return (A) c;
}
static void saveLocally(String variableName) {
  saveLocally(programID(), variableName);
}

static void saveLocally(String progID, String variableName) {
  saveLocally2(mc(), progID, variableName);
}

static void saveLocally2(Object obj, String variableName) {
  saveLocally2(obj, programID(), variableName);
}

static void saveLocally2(Object obj, String progID, String variableName) {
  Lock __1701 = saveLock(); lock(__1701); try {
  File textFile = new File(programDir(progID), variableName + ".text");
  File structureFile = new File(programDir(progID), variableName + ".structure");
  Object x = get(obj, variableName);
  
  if (x == null) {
    textFile.delete();
    structureFile.delete();
  } else if (x instanceof String) {
    saveTextFile(textFile, (String) x);
    structureFile.delete();
  } else {
    saveTextFile(structureFile, javaTokWordWrap(structure(x)));
    textFile.delete();
  }
} finally { unlock(__1701); } }
// wrapper: VF1<Runnable> or null
static void callRunnableWithWrapper(Object wrapper, Runnable r) {
  if (wrapper == null) callF(r);
  else callF(wrapper, r);
}

static void saveGZStructureToFile(String file, Object o) {
  saveGZStructureToFile(getProgramFile(file), o);
}
  
static void saveGZStructureToFile(File file, Object o) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  File tempFile = tempFileFor(file);
  if (tempFile.exists()) try {
    String saveName = tempFile.getPath() + ".saved." + now();
    copyFile(tempFile, new File(saveName));
  } catch (Throwable e) { printStackTrace(e); }
  
  FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
  try {
    GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
    structureToPrintWriter(o, printWriter);
    printWriter.close();
    gos.close();
    fileOutputStream.close();
  } catch (Throwable e) {
    fileOutputStream.close();
    tempFile.delete();
    throw rethrow(e);
  }
  
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (!tempFile.renameTo(file))
    throw new IOException("Can't rename " + tempFile + " to " + file);
} catch (Exception __e) { throw rethrow(__e); } }
static <A> A popFirst(List<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(0);
  return a;
}

static <A> A popFirst(Collection<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(a);
  return a;
}
static long toM(long l) {
  return (l+1024*1024-1)/(1024*1024);
}

static String toM(long l, int digits) {
  return formatDouble(toM_double(l), digits);
}
static String javaTokWordWrap(String s) {
  return javaTokWordWrap(120, s);
}

// TODO: complete trimming
static String javaTokWordWrap(int cols, String s) {
  int col = 0;
  List<String> tok = javaTok(s);
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && col >= cols && !containsNewLine(t))
      tok.set(i, t = rtrimSpaces(t) + "\n");
    int idx = t.lastIndexOf('\n');
    if (idx >= 0) col = l(t)-(idx+1);
    else col += l(t);
  }
  return join(tok);
}
static String ymd() {
  return ymd(now());
}

static String ymd(long now) {
  return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
}
static String formatInt(int i, int digits) {
  return padLeft(str(i), '0', digits);
}

static String formatInt(long l, int digits) {
  return padLeft(str(l), '0', digits);
}
static int hours() {
  return hours(java.util.Calendar.getInstance());
}

static int hours(java.util.Calendar c) {
  return c.get(java.util.Calendar.HOUR_OF_DAY);
}
static long toK(long l) {
  return (l+1023)/1024;
}
// firstDelay = delay
static FixedRateTimer doEvery_daemon(long delay, final Object r) {
  return doEvery_daemon(delay, delay, r);
}

static FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(true);
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
  return timer;
}

static FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
  return doEvery_daemon(toMS(delaySeconds), r);
}
static <A> A firstOfType(Collection c, Class<A> type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return (A) x;
  return null;
}
static Collection<Concept> allConcepts() {
  return db_mainConcepts().allConcepts();
}

static Collection<Concept> allConcepts(Concepts concepts) {
  return concepts.allConcepts();
}

static List<Concept> conceptsOfType(String type) {
  return db_mainConcepts().conceptsOfType(type);
}
static <A> List<A> filterByType(Iterable c, Class<A> type) {
  List<A> l = new ArrayList();
  if (c != null) for (Object x : c)
    if (isInstanceX(type, x))
      l.add((A) x);
  return l;
}

static <A> List<A> filterByType(Object[] c, Class<A> type) {
  return filterByType(asList(c), type);
}

static <A> List<A> filterByType(Class<A> type, Iterable c) {
  return filterByType(c, type);
}
static <A> List<A> filterByDynamicType(Collection<A> c, String type) {
  List<A> l = new ArrayList();
  for (A x : c)
    if (eq(dynamicClassName(x), type))
      l.add(x);
  return l;
}
static boolean hasType(Collection c, Class type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return true;
  return false;
}
static <A extends Concept> A findBackRef(Concept c, Class<A> type) {
  for (Concept.Ref r : c.backRefs)
    if (instanceOf(r.concept(), type))
      return (A) r.concept();
  return null;
}

static <A extends Concept> A findBackRef(Class<A> type, Concept c) {
  return findBackRef(c, type);
}
static String loadConceptsStructure(String progID) {
  return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
}

static String loadConceptsStructure() {
  return loadConceptsStructure(dbProgramID());
}
static void cleanKillVM() { try {
  ping();
  assertNotOnAWTThread();
  cleanKillVM_noSleep();
  Object o = new Object();
  synchronized(o) { o.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }

static void cleanKillVM_noSleep() {
  call(getJavaX(), "cleanKill");
}
static boolean dynamicObjectIsLoading() { 
  return isTrue(getThreadLocal(DynamicObject_loading));
}
static <A> List<A> addDyn(List<A> l, A a) {
  if (l == null) l = new ArrayList();
  l.add(a);
  return l;
}
static Str concept(String name) {
  for (Str s : list(Str.class))
    if (eqic(s.name, name) || containsIgnoreCase(s.otherNames, name))
      return s;
  return new Str(name);
}
static void change() {
  //mainConcepts.allChanged();
  // safe version for now cause function is sometimes included unnecessarily (e.g. by EGDiff)
  callOpt(getOptMC("mainConcepts"), "allChanged");
}
static <A> List<A> removeDyn(List<A> l, A a) {
  if (l == null) return null;
  l.remove(a);
  return empty(l) ? null : l;
}
static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll(b);
  return a;
}
static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}

static <A> void remove(Collection<A> l, A a) {
  if (l != null) l.remove(a);
}
static <A, B> Set<A> keySet(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

static Set keySet(Object map) {
  return keys((Map) map);
}


  static <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }



  static <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }



static <A> A reverseGet(List<A> l, int idx) {
  if (l == null || idx < 0) return null;
  int n = l(l);
  return idx < n ? l.get(n-1-idx) : null;
}
static <A, B> MultiMap<A, B> treeMultiMap() {
  return new MultiMap(true);
}

static <A, B> MultiMap<A, B> treeMultiMap(Comparator<A> comparator) {
  return new MultiMap(new TreeMap<A, List<B>>(comparator));
}
static Comparator reverseOrder() {
  return new Comparator() {
    public int compare(Object a, Object b) {
      return cmp(b, a);
    }
  };
}
static <A, B> List<A> cloneKeys_noSync(Map<A, B> map) {
  return cloneList_noSync(keys(map));
}
static <A, B> IterableIterator<B> navigableMultiMapValuesIterator(final MultiMap<A, B> mm) {
  return iteratorFromFunction(new F0<B>() {
    Iterator<List<B>> it = concurrentlyIterateValues((NavigableMap) mm.data);
    Iterator<B> it2;
    
    public B get() {
      while (it2 == null || !it2.hasNext()) {
        if (!it.hasNext()) return null;
        it2 = concurrentlyIterateList(it.next());
      }
      return it2.next();
    }
  });
}
static <A, B> MultiSet<A> multiMapToMultiSet(MultiMap<A, B> mm) {
  return multiMapAsMultiSet(mm);
}
static File loadLibrary(String snippetID) {
  return loadBinarySnippet(snippetID);
}
static Thread startThread(Object runnable) {
  return startThread(defaultThreadName(), runnable);
}

static Thread startThread(String name, Object runnable) {
  runnable = wrapAsActivity(runnable);
  return startThread(newThread(toRunnable(runnable), name));
}

static Thread startThread(Thread t) {
  
  _registerThread(t);
  
  t.start();
  return t;
}
static Class _run(String progID, String... args) {
  Class main = hotwire(progID);
  callMain(main, args);
  return main;
}
static void cancelAndInterruptThread(Thread t) {
  if (t == null) return;
  cancelThread(t);
  t.interrupt();
}
static void add(BitSet bs, int i) {
  bs.set(i);
}

static <A> boolean add(Collection<A> c, A a) {
  return c != null && c.add(a);
}


static void add(Container c, Component x) {
  addToContainer(c, x);
}

static <A> List<A> reversedList(Collection<A> l) {
  List<A> x = cloneList(l);
  Collections.reverse(x);
  return x;
}
static <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
  return map == null ? new TreeSet() : map.navigableKeySet();
}


  static <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }



  static <A, B> NavigableSet<A> navigableKeys(MultiMap<A, B> mm) {
    return ((NavigableMap) mm.data).navigableKeySet();
  }

static String quoteBorderless(Object o) {
  if (o == null) return "null";
  return quoteBorderless(str(o));
}

static String quoteBorderless(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5));
  quoteBorderless_impl(s, out);
  return out.toString();
}
  
static void quoteBorderless_impl(String s, StringBuilder out) {
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
}
static int hashCodeFor(Object a) {
  return a == null ? 0 : a.hashCode();
}
static UnsupportedOperationException unsupportedOperation() {
  throw new UnsupportedOperationException();
}
static File getSecretProgramDir() {
  return getSecretProgramDir(getProgramID());
}

static File getSecretProgramDir(String snippetID) {
  if (empty(snippetID)) return javaxSecretDir();
  return newFile(javaxSecretDir(), formatSnippetID(snippetID));
}
  static byte[] base64decode(String s) {
    byte[] alphaToInt = base64decode_base64toint;
    int sLen = s.length();
    int numGroups = sLen/4;
    if (4*numGroups != sLen)
      throw new IllegalArgumentException(
        "String length must be a multiple of four.");
    int missingBytesInLastGroup = 0;
    int numFullGroups = numGroups;
    if (sLen != 0) {
      if (s.charAt(sLen-1) == '=') {
        missingBytesInLastGroup++;
        numFullGroups--;
      }
      if (s.charAt(sLen-2) == '=')
        missingBytesInLastGroup++;
    }
    byte[] result = new byte[3*numGroups - missingBytesInLastGroup];

    // Translate all full groups from base64 to byte array elements
    int inCursor = 0, outCursor = 0;
    for (int i=0; i<numFullGroups; i++) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch3 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      result[outCursor++] = (byte) ((ch2 << 6) | ch3);
    }

    // Translate partial group, if present
    if (missingBytesInLastGroup != 0) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));

      if (missingBytesInLastGroup == 1) {
        int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
        result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      }
    }
    // assert inCursor == s.length()-missingBytesInLastGroup;
    // assert outCursor == result.length;
    return result;
  }

  static int base64decode_base64toint(char c, byte[] alphaToInt) {
    int result = alphaToInt[c];
    if (result < 0)
      throw new IllegalArgumentException("Illegal character " + c);
    return result;
  }

  static final byte base64decode_base64toint[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54,
    55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
    24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34,
    35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51
  };


  static String base64encode(byte[] a) {
    int aLen = a.length;
    int numFullGroups = aLen/3;
    int numBytesInPartialGroup = aLen - 3*numFullGroups;
    int resultLen = 4*((aLen + 2)/3);
    StringBuffer result = new StringBuffer(resultLen);
    char[] intToAlpha = intToBase64;

    // Translate all full groups from byte array elements to Base64
    int inCursor = 0;
    for (int i=0; i<numFullGroups; i++) {
      int byte0 = a[inCursor++] & 0xff;
      int byte1 = a[inCursor++] & 0xff;
      int byte2 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      result.append(intToAlpha[(byte0 << 4)&0x3f | (byte1 >> 4)]);
      result.append(intToAlpha[(byte1 << 2)&0x3f | (byte2 >> 6)]);
      result.append(intToAlpha[byte2 & 0x3f]);
    }

    // Translate partial group if present
    if (numBytesInPartialGroup != 0) {
      int byte0 = a[inCursor++] & 0xff;
      result.append(intToAlpha[byte0 >> 2]);
      if (numBytesInPartialGroup == 1) {
        result.append(intToAlpha[(byte0 << 4) & 0x3f]);
        result.append("==");
      } else {
        // assert numBytesInPartialGroup == 2;
        int byte1 = a[inCursor++] & 0xff;
        result.append(intToAlpha[(byte0 << 4)&0x3f | (byte1 >> 4)]);
        result.append(intToAlpha[(byte1 << 2)&0x3f]);
        result.append('=');
      }
    }
    // assert inCursor == a.length;
    // assert result.length() == resultLen;
    return result.toString();
  }

  /**
   * This array is a lookup table that translates 6-bit positive integer
   * index values into their "Base64 Alphabet" equivalents as specified
   * in Table 1 of RFC 2045.
   */
  static final char intToBase64[] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
    'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'
  };
static <A> MultiMap<String, A> ciMultiMap() {
  return caseInsensitiveMultiMap();
}
static String combineWithSlash(String a, String b) {
  return joinNempties("/", a, b);
}
static void cleanUpAndClear(Collection c) {
  if (c == null) return;
  cleanUp(c);
  c.clear();
}

static void cleanUpAndClear(Map map) {
  if (map == null) return;
  cleanUp(map);
  map.clear();
}
static <A> List<A> listCreateAndAdd(List<A> l, A a) {
  return addDyn(l, a);
}
static String dbBotName(String progIDWithCase) {
  return fsI_flex(progIDWithCase) + " Concepts";
}
static Map<String, Integer> findBot_cache = synchroHashMap();
static int findBot_timeout = 5000;

static DialogIO findBot(String searchPattern) {
  // first split off sub-bot suffix
  String subBot = null;
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i+1);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    
  if (eq(searchPattern, "remote"))
    return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    io.waitForLine(/*findBot_timeout*/); // TODO: implement
    String line = io.readLineNoBlock();
    if (indexOfIgnoreCase(line, searchPattern) == 0) {
      call(io, "pushback", line); // put hello string back in
      return talkToSubBot(subBot, io);
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      findBot_cache.put(searchPattern, p.port);
      return talkToSubBot(subBot, talkTo("localhost", p.port));
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
      }
    } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  }
        
  return null;
}
static void nohupJavax(final String javaxargs) {
  { startThread(new Runnable() {  public void run() { try {   call(hotwireOnce("#1008562"), "nohupJavax", javaxargs); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs);"; }}); }
}

static void nohupJavax(final String javaxargs, final String vmArgs) {
  { startThread(new Runnable() {  public void run() { try {   call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs, vmArgs);"; }}); }
}
static long waitForBotStartUp_timeoutSeconds = 60;

// returns address or fails
static String waitForBotStartUp(String botName) {
  for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
    sleepSeconds(i == 0 ? 0 : 1);
    String addr = getBotAddress(botName);
    if (addr != null)
      return addr;
  }
  throw fail("Bot not found: " + quote(botName));
}
static Object rpc(String botName, String method, Object... args) {
  return unstructure_matchOK2OrFail(
    sendToLocalBot(botName, rpc_makeCall(method, args)));
}

static Object rpc(DialogIO bot, String method, Object... args) {
  return unstructure_matchOK2OrFail(
    bot.ask(rpc_makeCall(method, args)));
}

static String rpc_makeCall(String method, Object... args) {
  if (empty(args))
    return "call " + method;
  return format("call *", concatLists((List) ll(method), asList(args)));
}
static void close(AutoCloseable c) {
  _close(c);
}
static volatile boolean readLine_noReadLine = false;

static String readLine_lastInput;
static String readLine_prefix = "[] ";

static String readLine() {
  if (readLine_noReadLine) return null;
  String s = readLineHidden();
  if (s != null) {
    readLine_lastInput = s;
    print(readLine_prefix + s);
  }
  return s;
}
  static String format3(String pat, Object... args) {
    if (args.length == 0) return pat;
    
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2)
      if (tok.get(i).equals("*"))
        tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }
  
  static String format3_formatArg(Object arg) {
    if (arg == null) return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long) return String.valueOf(arg);
    return quote(structure(arg));
  }
  



volatile static boolean conceptsAndBot_running = false;
static boolean conceptsAndBot_thinOnStart = true;

static void conceptsAndBot() {
  conceptsAndBot(null);
}

static void conceptsAndBot(Integer autoSaveInterval) {
  if (conceptsAndBot_running) return;
  conceptsAndBot_running = true;
  
  try {
    ensureDBNotRunning(dbBotStandardName());
  } catch (Throwable _e) {
    db_mainConcepts().dontSave = true; // SAFETY
  
throw rethrow(_e); }
  
  db_mainConcepts().persist(autoSaveInterval);
  dbBot();
  
  if (conceptsAndBot_thinOnStart) { try {
    thinAProgramsBackups(getDBProgramID(), true);
  } catch (Throwable __e) { _handleException(__e); }}
}
static Method findMethod_cached(Object o, String method, Object... args) { try {
  if (o == null) return null;
  if (o instanceof Class) {
    _MethodCache cache = callOpt_getCache(((Class) o));
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
        return m;
    return null;
  } else {
    _MethodCache cache = callOpt_getCache(o.getClass());
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (findMethod_checkArgs(m, args, false))
        return m;
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }

  static File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }
static String pad(Object s, int l) {
  return pad(s, l, ' ');
}

static String pad(Object s, int l, char c) {
  String _s = str(s);
  if (lengthOfString(_s) >= l) return _s;
  return rep(c, l-lengthOfString(_s)) + _s;
}
static String nohup_sanitize(String s) {
  return empty(s) ? s : takeFirst(50, s.replaceAll("[^a-zA-Z0-9\\-_]", ""));
}

static String standard_toString(Object o) {
  if (o == null) return "null";
  String name = shortClassName(o);
  Set<String> fields = fieldNames(o);
  if (empty(fields)) return name;
  return name + "(" + joinWithComma(mapNonNulls(fields, field -> {
    Object value = get(o, field);
    if (value == null) return null;
    return field + "=" + str(value);
  })) + ")";
}
static Set<String> allFields(Object o) {
  TreeSet<String> fields = new TreeSet();
  Class _c = _getClass(o);
  do {
    for (Field f : _c.getDeclaredFields())
      fields.add(f.getName());
    _c = _c.getSuperclass();
  } while (_c != null);
  return fields;
}
static int stdHash(Object a, String... fields) {
  if (a == null) return 0;
  int hash = getClassName(a).hashCode();
  for (String field : fields)
    hash = hash*2+hashCode(getOpt(a, field));
  return hash;
}
static String[] toStringArray(Collection<String> c) {
  String[] a = new String[l(c)];
  Iterator<String> it = c.iterator();
  for (int i = 0; i < l(a); i++)
    a[i] = it.next();
  return a;
}

static String[] toStringArray(Object o) {
  if (o instanceof String[])
    return (String[]) o;
  else if (o instanceof Collection)
    return toStringArray((Collection<String>) o);
  else
    throw fail("Not a collection or array: " + getClassName(o));
}

static String assertPossibleGlobalID(String s) {
  if (!possibleGlobalID(s))
    throw fail("Not an acceptable global ID: " + s);
  return s;
}
static char charPlus(char a, int b) {
  return (char) (((int) a) + b);
}
// better modulo that gives positive numbers always
static int mod(int n, int m) {
  return (n % m + m) % m;
}

static long mod(long n, long m) {
  return (n % m + m) % m;
}

static BigInteger mod(BigInteger n, int m) {
  return n.mod(bigint(m));
}

static double mod(double n, double m) {
  return (n % m + m) % m;
}

static <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
  List<B> out = new ArrayList();
  if (l != null) for (A a : l)
    addIfNotNull(out, map.get(a));
  return out; 
}

static <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
  return lookupAllOpt(map, l);
}
static String getInnerMessage(Throwable e) {
  if (e == null) return null;
  return getInnerException(e).getMessage();
}
static <A> A lastThat(List<A> l, Object pred) {
  for (int i = l(l)-1; i >= 0; i--) {
    A a = l.get(i);
    if (checkCondition(pred, a))
      return a;
  }
  return null;
}

static <A> A lastThat(Object pred, List<A> l) {
  return lastThat(l, pred);
}
static boolean fileNotEmpty(File f) {
  return isFile(f) && fileSize(f) > 0;
}
static List<File> sortByFileName(List<File> l) {
  return sortFilesByName(l);
}
static void logQuotedWithTime(String s) {
  logQuotedWithTime(standardLogFile(), s);
}

static void logQuotedWithTime(File logFile, String s) {
  logQuoted(logFile, logQuotedWithTime_format(s));
}

static void logQuotedWithTime(String logFile, String s) {
  logQuoted(logFile, logQuotedWithTime_format(s));
}

static String logQuotedWithTime_format(String s) {
  return /*formatGMTWithDate_24*/(now()) + " " + s;
}
static String stringIf(boolean b, String s) {
  return stringIfTrue(b, s);
}
static void clearConceptsOf(String progID) {
  getProgramFile(progID, "concepts.structure").delete();
  getProgramFile(progID, "idCounter.structure").delete();
}
static Lock saveLock_lock = fairLock();

static Lock saveLock() {
  return saveLock_lock;
}
static File tempFileFor(File f) {
  return new File(f.getPath() + "_temp");
}
static double toM_double(long l) {
  return l/(1024*1024.0);
}
public static String rtrimSpaces(String s) {
  if (s == null) return null;
  int i = s.length();
  while (i > 0 && " \t".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}
static int year() {
  return localYear();
}

static int year(long now) {
  return localYear(now);
}
static int month() {
  return localMonth();
}

static int month(long now) {
  return localMonth(now);
}
static int dayOfMonth() {
  return localDayOfMonth();
}

static int dayOfMonth(long now) {
  return localDayOfMonth(now);
}
static String padLeft(String s, char c, int n) {
  return rep(c, n-l(s)) + s;
}

// default to space
static String padLeft(String s, int n) {
  return padLeft(s, ' ', n);
}
// r may return false to cancel timer
static TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
  return new SmartTimerTask(r, timer, delay, _threadInfo());
}

static  class SmartTimerTask extends TimerTask {
  static String _fieldOrder = "r timer delay threadInfo lastRun";
  Object r;
  java.util.Timer timer;
  long delay;
  Object threadInfo;
  SmartTimerTask() {}
  SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
  this.threadInfo = threadInfo;
  this.delay = delay;
  this.timer = timer;
  this.r = r;}
  public String toString() { return "SmartTimerTask(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")"; }
  long lastRun;
  
  public void run() {
    if (!licensed())
      timer.cancel();
    else {
      _threadInheritInfo(threadInfo);
       AutoCloseable __1839 = tempActivity(r); try {
      lastRun = fixTimestamp(lastRun);
      long now = now();
      if (now >= lastRun + delay*0.9) {
        lastRun = now;
        if (eq(false, pcallF(r)))
          timer.cancel();
      }
    } finally { _close(__1839); }}
  }
}
static String dynamicClassName(Object o) {
  if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return "main$" + ((DynamicObject) o).className;
  return className(o);
}
static String loadTextFilePossiblyGZipped(String fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}
  
static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
  File gz = new File(fileName + ".gz");
  return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
}

static String loadTextFilePossiblyGZipped(File fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}

static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
  return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
}

static void assertNotOnAWTThread() {
  assertFalse("Can't do this in AWT thread", isAWTThread());
}
  
static Object getOptMC(String field) {
  return getOpt(mc(), field);
}
static <A> ArrayList<A> cloneList_noSync(Iterable<A> l) {
  return l instanceof Collection ? cloneList_noSync((Collection) l) : asList(l);
}

static <A> ArrayList<A> cloneList_noSync(Collection<A> l) {
  if (l == null) return new ArrayList();
  return new ArrayList<A>(l);
}
// f: func -> A (stream ends when f returns null)
static <A> IterableIterator<A> iteratorFromFunction(final Object f) {
  class IFF extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = (A) callF(f);
      done = a == null;
    }
  };
  return new IFF();
}

// optimized version for F0 argument
static <A> IterableIterator<A> iteratorFromFunction(final F0<A> f) {
  return iteratorFromFunction_f0(f);
}
// iterate safely (& quickly) in the face of concurrent modifications
static <A, B> IterableIterator<B> concurrentlyIterateValues(final NavigableMap<A, B> map) {
  return iteratorFromFunction(new F0<B>() {
    Iterator<A> it = keys(map).iterator();
    A key;
    
    B get() {
      synchronized(map) {
        try {
          if (!it.hasNext()) return null;
          return map.get(key = it.next());
        } catch (ConcurrentModificationException e) {
          print("Re-iterating");
          it = map.tailMap(key, false).keySet().iterator();
          if (!it.hasNext()) return null;
          return map.get(key = it.next()); // Can't throw another exception
        }
      }
    }
  });
}
// iterate safely (& quickly) in the face of concurrent modifications
static <A> IterableIterator<A> concurrentlyIterateList(final List<A> l) {
  return iteratorFromFunction_withEndMarker_f0(new F0<A>() {
    int i;

    A get() {
      int _i = i++;
      synchronized(l) {
        if (_i < l(l)) {
          A a = l.get(_i);
          if (a == iteratorFromFunction_endMarker) throw fail("no"); // ugly comparison fail-fast redemption
          return a;
        }
        return (A) iteratorFromFunction_endMarker; // ugly cast
      }
    }
  });
}
static <A, B> MultiSet<A> multiMapAsMultiSet(MultiMap<A, B> mm) {
  MultiSet<A> ms = new MultiSet();
  for (A a : keys(mm))
    ms.add(a, l(mm.get(a)));
  return ms;
}
static File loadBinarySnippet(String snippetID) { try {
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadLibrary(snippetID);
  
  
  long id = parseSnippetID(snippetID);
  if (isImageServerSnippet(id)) return loadImageAsFile(snippetID);
  File f = DiskSnippetCache_getLibrary(id);
  if (fileSize(f) == 0)
    f = loadDataSnippetToFile(snippetID);
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static String defaultThreadName_name;

static String defaultThreadName() {
  if (defaultThreadName_name == null)
    defaultThreadName_name = "A thread by " + programID();
  return defaultThreadName_name;
}
static Runnable wrapAsActivity(Object r) {
  return toRunnable(r);
}
// runnable = Runnable or String (method name)
static Thread newThread(Object runnable) {
  return new Thread(_topLevelErrorHandling(toRunnable(runnable)));
}

static Thread newThread(Object runnable, String name) {
  if (name == null) name = defaultThreadName();
  return new Thread(_topLevelErrorHandling(toRunnable(runnable)), name);
}

static Thread newThread(String name, Object runnable) {
  return newThread(runnable, name);
}
static Runnable toRunnable(final Object o) {
  if (o instanceof Runnable) return (Runnable) o;
  return new Runnable() {  public void run() { try {  callF(o) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(o)"; }};
}
static void cancelThread(Thread t) {
  if (t == null) return;
  ping();
  
  /*O mc = getWeakRef((WeakReference) vm_generalWeakSubMap("thread2mc").get(t));
  ifdef cancelThread_verbose
  print("cancelThread: mc=" + mc);
  endifdef
  if (mc != null) {
    Map ping_actions = cast get(mc, 'ping_actions);
    synchronized(ping_actions) {
      ping_actions.put(t, "cancelled");
      set(mc, ping_anyActions := true);
    }
  } else*/ synchronized(ping_actions) {
    ping_actions.put(t, "cancelled");
    ping_anyActions = true;
  }
  
}
static void addToContainer(final Container a, final Component b) {
  if (a != null && b != null) { swing(new Runnable() {  public void run() { try {  a.add(b); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "a.add(b);"; }}); }
}
static <A> MultiMap<String, A> caseInsensitiveMultiMap() {
  MultiMap<String,A> mm = new MultiMap();
  mm.data = caseInsensitiveMap();
  return mm;
}
static String fsI_flex(String s) {
  return startsWithDigit(s) ? "#" + s : s;
}
static DialogIO talkToSubBot(final long vport, final DialogIO io) {
  return talkToSubBot(String.valueOf(vport), io);
}

static DialogIO talkToSubBot(final String subBot, final DialogIO io) {
  if (subBot == null) return io;
  return new talkToSubBot_IO(subBot, io);
}

static class talkToSubBot_IO extends DialogIO {
  String subBot;
  DialogIO io;
  
  talkToSubBot_IO(String subBot, DialogIO io) {
  this.io = io;
  this.subBot = subBot;}
  
  // delegate all but sendLine
  boolean isStillConnected() { return io.isStillConnected(); }
  String readLineImpl() { return io.readLineImpl(); }
  boolean isLocalConnection() { return io.isLocalConnection(); }
  Socket getSocket() { return io.getSocket(); }
  public void close() { try { io.close(); } catch (Exception __e) { throw rethrow(__e); } }

  void sendLine(String line) {
    io.sendLine(format3("please forward to bot *: *", subBot, line));
  }
}
static DialogIO talkTo(int port) {
  return talkTo("localhost", port);
}

static int talkTo_defaultTimeout = 10000; // This is the CONNECT timeout
static int talkTo_timeoutForReads = 0; // Timeout waiting for answers (0 = no timeout)

static ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

static DialogIO talkTo(String ip, int port) { try {
  String full = ip + ":" + port;
  Map<String, DialogIO> map = talkTo_byThread.get();
  if (map != null && map.containsKey(full)) return map.get(full);
  
  if (isLocalhost(ip) && port == vmPort()) return talkToThisVM();

  return new talkTo_IO(ip, port);
} catch (Exception __e) { throw rethrow(__e); } }

static class talkTo_IO extends DialogIO { 
  String ip;
  int port;
  Socket s;
  Writer w;
  BufferedReader in;
  
  talkTo_IO(String ip, int port) {
  this.port = port;
  this.ip = ip; try {
    s = new Socket();
    try {
      if (talkTo_timeoutForReads != 0)
        s.setSoTimeout(talkTo_timeoutForReads);
      s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
    } catch (Throwable e) {
      throw fail("Tried talking to " + ip + ":" + port, e);
    }
  
    w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
    in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    Lock __1878 = lock; lock(__1878); try {
    w.write(line + "\n");
    w.flush();
  } finally { unlock(__1878); } } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {
    try {
      if (!noClose) s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
}
static List<ProgramScan.Program> quickBotScan() {
  return ProgramScan.quickBotScan();
}

static List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
  return ProgramScan.quickBotScan(preferredPorts);
}

static List<ProgramScan.Program> quickBotScan(String searchPattern) {
  List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
  for (ProgramScan.Program p : ProgramScan.quickBotScan())
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
  return l;
}

static String firstPartOfHelloString(String s) {
  int i = s.lastIndexOf('/');
  return i < 0 ? s : rtrim(s.substring(0, i));
}
static String sendToLocalBotQuietly(String bot, String text, Object... args) {
  text = format3(text, args);
  
   DialogIO channel = newFindBot2(bot); try {
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}

static String sendToLocalBotQuietly(int port, String text, Object... args) {
  text = format3(text, args);
   DialogIO channel = talkTo(port); try {
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}
static Class hotwireOnce(String programID) {
  return hotwireCached(programID, false);
}
static String getBotAddress(String bot) {
  List<ScannedBot> l = fullBotScan(bot);
  return empty(l) ? null : first(l).address;
}
static Object unstructure_matchOK2OrFail(String s) {
  if (swic(s, "ok "))
    return unstructure_startingAtIndex(s, 3);
  else
    throw fail(s);
}
static String sendToLocalBot(String bot, String text, Object... args) {
  text = format3(text, args);
  
   DialogIO channel = findBot(bot); try {
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    print(bot + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(bot + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}

static String sendToLocalBot(int port, String text, Object... args) {
  text = format3(text, args);
   DialogIO channel = talkTo(port); try {
  try {
    channel.readLine();
    print(port + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(port + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}
  static String format(String pat, Object... args) {
    return format3(pat, args);
  }

static String readLineHidden() { try {
  if (get(javax(), "readLine_reader") == null)
    set(javax(), "readLine_reader" , new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
  try {
    return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
  } finally {
    consoleClearInput();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isNonNegativeInteger(String s) {
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}


static void ensureDBNotRunning(String name) {
  if (hasBot(name)) {
    try {
      String framesBot = dropSuffix(".", name) + " Frames";
      print("Trying to activate frames of running DB: " + framesBot);
      if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
        cleanKill();
    } catch (Throwable __e) { _handleException(__e); }
    throw fail("Already running: " + name);
  }
}

static void ensureDBNotRunning() {
  ensureDBNotRunning(dbBotStandardName());
}
static String dbBotStandardName() {
  String home = userHome();
  String name = dbBotName(getDBProgramID());
  if (neq(home, actualUserHome()))
    name += " " + quote(home);
  return name + ".";
}
static volatile Android3 dbBot_instance;

static Android3 dbBot() {
  return dbBot(dbBotStandardName());
}

static Android3 dbBot(String name) {
  ensureDBNotRunning(name);
  return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
}
static int lengthOfString(String s) {
  return s == null ? 0 : s.length();
}
static Set<String> fieldNames(Object o) {
  return allFields(o);
}
static List mapNonNulls(Iterable l, Object f) { return mapNonNulls(f, l); }

static List mapNonNulls(Object f, Iterable l) {
  List x = new ArrayList();
  if (l != null) for (Object o : l)
    addIfNotNull(x, callF(f, o));
  return x;
}

static List mapNonNulls(Object f, Object[] l) {
  List x = new ArrayList();
  if (l != null) for (Object o : l)
    addIfNotNull(x, callF(f, o));
  return x;
}


  static <A, B> List<B> mapNonNulls(Iterable<A> l, F1<A, B> f) { return mapNonNulls(f, l); }

  static <A, B> List<B> mapNonNulls(F1<A, B> f, Iterable<A> l) {
    List x = new ArrayList();
    if (l != null) for (Object o : l)
      addIfNotNull(x, callF(f, o));
    return x;
  }


static <A, B> List<B> mapNonNulls(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : l)
    addIfNotNull(x, f.get(o));
  return x;
}
static int hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}
static List<File> sortFilesByName(List<File> l) {
  sort(l, new Comparator<File>() {
    public int compare(File a, File b) {
      return stdcompare(a.getName(), b.getName());
    }
  });
  return l;
}
static File standardLogFile() {
  return getProgramFile("log");
}
static String stringIfTrue(boolean b, String s) {
  return b ? s : "";
}
static int localYear() {
  return localYear(now());
}

static int localYear(long time) {
  return parseInt(simpleDateFormat_local("yyyy").format(time));
}
static int localMonth(long time) {
  return parseInt(simpleDateFormat_local("MM").format(time));
}

static int localMonth() {
  return localMonth(now());
}
static int localDayOfMonth(long time) {
  return parseInt(simpleDateFormat_local("dd").format(time));
}

static int localDayOfMonth() {
  return localDayOfMonth(now());
}
static List<VF1<Map>> _threadInfo_makers = synchroList();

static Object _threadInfo() {
  if (empty(_threadInfo_makers)) return null;
  HashMap map = new HashMap();
  pcallFAll(_threadInfo_makers, map);
  return map;
}
static List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

static void _threadInheritInfo(Object info) {
  if (info == null) return;
  pcallFAll(_threadInheritInfo_retrievers, (Map) info);
}
static AutoCloseable tempActivity(Object r) {
  return null;
}
static long fixTimestamp(long timestamp) {
  return timestamp > now() ? 0 : timestamp;
}
static String loadGZTextFile(File file) { try {
  if (!file.isFile()) return null;
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
  InputStream fis = new FileInputStream(file);
  GZIPInputStream gis = newGZIPInputStream(fis);
  try {
    byte[] buffer = new byte[1024];
    int len;
    while((len = gis.read(buffer)) != -1){
        baos.write(buffer, 0, len);
    }
  } finally {
    fis.close();
  }
  baos.close();
  return fromUtf8(baos.toByteArray()); // TODO: use a Reader
} catch (Exception __e) { throw rethrow(__e); } }
static <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
  class IFF2 extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
  };
  return new IFF2();
}

static File loadImageAsFile(String snippetIDOrURL) { try {
  if (isURL(snippetIDOrURL))
    throw fail("not implemented");

  if (!isSnippetID(snippetIDOrURL)) throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
  String snippetID = "" + parseSnippetID(snippetIDOrURL);
  
  File file = imageSnippetCacheFile(snippetID);
  if (fileSize(file) > 0) return file;

  String imageURL = snippetImageURL_noHttps(snippetID);
  System.err.println("Loading image: " + imageURL);
  byte[] data = loadBinaryPage(imageURL);

  saveBinaryFile(file, data);
  return file;
} catch (Exception __e) { throw rethrow(__e); } }

// If you change this, also change DiskSnippetCache_fileToLibID
static File DiskSnippetCache_file(long snippetID) {
  return new File(getGlobalCache(), "data_" + snippetID + ".jar");
}
  
  // Data files are immutable, use centralized cache
public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
  File file = DiskSnippetCache_file(snippetID);
  return file.exists() ? file : null;
}

public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
  saveBinaryFile(DiskSnippetCache_file(snippetID), data);
}

static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
  byte[] data;
  try {
    URL url = new URL(dataSnippetLink(snippetID));
    print("Loading library: " + hideCredentials(url));
    try {
      data = loadBinaryPage(url.openConnection());
    } catch (RuntimeException e) {
      data = null;
    }
    
    if (data == null || data.length == 0) {
      url = new URL("http://data.tinybrain.de/blobs/"
        + parseSnippetID(snippetID));
      print("Loading library: " + hideCredentials(url));
      data = loadBinaryPage(url.openConnection());
    }
    print("Bytes loaded: " + data.length);
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return data;
}
static File loadDataSnippetToFile(String snippetID) { try {
  snippetID = fsI(snippetID);
  
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadLibrary(snippetID);
  
  
  File f = DiskSnippetCache_file(parseSnippetID(snippetID));
  List<URL> urlsTried = new ArrayList();
  List<Throwable> errors = new ArrayList();
  try {
    URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
    print("Loading library: " + hideCredentials(url));
    try {
      loadBinaryPageToFile(openConnection(url), f);
      if (fileSize(f) == 0) throw fail();
    } catch (Throwable e) {
      errors.add(e);
      url = addAndReturn(urlsTried, new URL("http://data.tinybrain.de/blobs/"
        + psI(snippetID)));
      print("Trying other server: " + hideCredentials(url));
      loadBinaryPageToFile(openConnection(url), f);
      print("Got bytes: " + fileSize(f));
    }
    // TODO: check if we hit the "LOADING" message
    if (fileSize(f) == 0) throw fail();
    System.err.println("Bytes loaded: " + fileSize(f));
  } catch (Throwable e) {
    //printStackTrace(e);
    errors.add(e);
    throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
  }
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static Runnable _topLevelErrorHandling(final Runnable runnable) {
  final Object info = _threadInfo();
  return new Runnable() {  public void run() { try { 
    try {
      _threadInheritInfo(info);
      runnable.run();
    } catch (Throwable __e) { _handleException(__e); }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "pcall {\r\n      _threadInheritInfo(info);\r\n      runnable.run();\r\n    }"; }};
}
static Object swing(Object f) {
  return swingAndWait(f);
}

static <A> A swing(F0<A> f) {
  return (A) swingAndWait(f);
}
static boolean isLocalhost(String ip) {
  return isLoopbackIP(ip) || eqic(ip, "localhost");
}
static int vmPort() {
  return myVMPort();
}
static DialogIO talkToThisVM() {
  return new talkToThisVM_IO();
}

static class talkToThisVM_IO extends DialogIO { 
  List<String> answers = ll(thisVMGreeting());
  
  boolean isLocalConnection() { return true; }
  boolean isStillConnected() { return true; }
  int getPort() { return vmPort(); }
  
  void sendLine(String line) {
    answers.add(or2(sendToThisVM_newThread(line), "?"));
  }
  
  String readLineImpl() { try {
    return popFirst(answers);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {}
  Socket getSocket() { return null; }
}
static Map<String, Integer> newFindBot2_cache = synchroHashMap();
static boolean newFindBot2_verbose = false;

static DialogIO newFindBot2(String name) {
  Integer port = newFindBot2_cache.get(name);
  if (port != null) {
    if (newFindBot2_verbose)
      print("newFindBot2: testing " + name + " => " + port);
    DialogIO io = talkTo(port);
    String q = format("has bot *", name);
    String s = io.ask(q);
    if (match("yes", s)) {
      io = talkToSubBot(name, io);
      call(io, "pushback", "?"); // put some hello string in (yes, this should be improved.)
      return io;
    }
    // bot not there anymore - remove cache entry
    newFindBot2_cache.remove(name);
    if (newFindBot2_verbose)
      print("newFindBot2: dropping " + name + " => " + port);
  }
  
  DialogIO io = findBot(name);
  if (io != null) {
    newFindBot2_cache.put(name, io.getPort());
    if (newFindBot2_verbose)
      print("newFindBot2: remembering " + name + " => " + port);
  }
  return io;
}
static TreeMap<String,Class> hotwireCached_cache = new TreeMap();
static Lock hotwireCached_lock = lock();

static Class hotwireCached(String programID) {
  return hotwireCached(programID, true);
}

static Class hotwireCached(String programID, boolean runMain) {
  return hotwireCached(programID, runMain, false);
}

static Class hotwireCached(String programID, boolean runMain, boolean dependent) {
  Lock __1953 = hotwireCached_lock; lock(__1953); try {
  
  programID = formatSnippetID(programID);
  Class c = hotwireCached_cache.get(programID);
  if (c == null) {
    c = hotwire(programID);
    if (dependent)
      makeDependent(c);
    if (runMain)
      callMain(c);
    hotwireCached_cache.put(programID, c);
  }
  return c;
} finally { unlock(__1953); } }
static class ScannedBot {
  String helloString;
  String address;
  
  ScannedBot(String helloString, String address) {
  this.address = address;
  this.helloString = helloString;}
  ScannedBot() {}
}

static List<ScannedBot> fullBotScan() {
  return fullBotScan("");
}

static List<ScannedBot> fullBotScan(String searchPattern) {
  List<ScannedBot> bots = new ArrayList();
  for (ProgramScan.Program p : quickBotScan()) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = swic(botName, "Multi-Port") || isVM;
    
    if (swic(botName, searchPattern)) bots.add(new ScannedBot(botName, "" + p.port));

    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        botName = subBots.get(vport);
        if (swic(botName, searchPattern)) 
          bots.add(new ScannedBot(botName, p.port + "/" + vport));
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
  return bots;
}
static Object unstructure_startingAtIndex(String s, int i) {
  return unstructure_tok(javaTokC_noMLS_iterator(s, i), false, null);
}
static void consoleClearInput() {
  consoleSetInput("");
}


static boolean loadBufferedImage_useImageCache = true;

static BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) { try {
  ping();
  if (snippetIDOrURLOrFile == null) return null;
  if (isURL(snippetIDOrURLOrFile))
    return imageIO_readURL(snippetIDOrURLOrFile);

  if (isAbsolutePath(snippetIDOrURLOrFile)) 
    return loadBufferedImage(new File(snippetIDOrURLOrFile));
  
  if (!isSnippetID(snippetIDOrURLOrFile))
    throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
  String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
  
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return loadBufferedImage(rl.loadLibrary(snippetID));
  
  
  File dir = imageSnippetsCacheDir();
  if (loadBufferedImage_useImageCache) {
    dir.mkdirs();
    File file = new File(dir, snippetID + ".png");
    if (file.exists() && file.length() != 0)
      try {
        return ImageIO.read(file);
      } catch (Throwable e) {
        e.printStackTrace();
        // fall back to loading from sourceforge
      }
  }

  String imageURL = snippetImageURL_http(snippetID);
  print("Loading image: " + imageURL);
  BufferedImage image = imageIO_readURL(imageURL);

  if (loadBufferedImage_useImageCache) {
    File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
    ImageIO.write(image, "png", tempFile);
    tempFile.renameTo(new File(dir, snippetID + ".png"));
    //Log.info("Cached image.");
  }

  //Log.info("Loaded image.");
  return image;
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedImage loadBufferedImage(File file) { try {
  return file.isFile() ? ImageIO.read(file) : null;
} catch (Exception __e) { throw rethrow(__e); } }
static boolean hasBot(String searchPattern) { try {
  DialogIO io = findBot(searchPattern);
  if (io != null) {
    io.close();
    return true;
  } else
    return false;
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isOK(String s) {
  s = trim(s);
  return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
}
static String sendOpt(String bot, String text, Object... args) {
  return sendToLocalBotOpt(bot, text, args);
}
static boolean isMainProgram() {
  return creator() == null;
}
static void cleanKill() {
  cleanKillVM();
}
static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
  return methodsBot2(name, receiver, exposedMethods, null);
}

static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
  Android3 android = new Android3();
  android.greeting = name;
  android.console = false;
  android.responder = new Responder() {
    String answer(String s, List<String> history) {
      return exposeMethods2(receiver, s, exposedMethods, lock);
    }
  };
  return makeBot(android);
}
static List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

static List<String> db_standardExposedMethods() {
  return db_standardExposedMethods_list;
}


static SimpleDateFormat simpleDateFormat_local(String format) {
  SimpleDateFormat sdf = new SimpleDateFormat(format);
  sdf.setTimeZone(localTimeZone());
  return sdf;
}
static String fromUtf8(byte[] bytes) { try {
  return bytes == null ? null : new String(bytes, "UTF-8");
} catch (Exception __e) { throw rethrow(__e); } }
static File imageSnippetCacheFile(String snippetID) {
  File dir = imageSnippetsCacheDir();
  
  if (!loadBufferedImage_useImageCache) return null;
  
  return new File(dir, parseSnippetID(snippetID) + ".png");
}
static String snippetImageURL_noHttps(String snippetID) {
  return snippetImageURL_noHttps(snippetID, "png");
}

static String snippetImageURL_noHttps(String snippetID, String contentType) {
  return snippetImageURL(snippetID, contentType)
    .replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/")
    .replace("https://botcompany.de/", "http://botcompany.de/");
}
static ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

static byte[] loadBinaryPage(String url) { try {
  print("Loading " + url);
  return loadBinaryPage(loadPage_openConnection(new URL(url)));
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage(URLConnection con) { try {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
  setHeaders(con);
  for (String key : keys(extraHeaders))
    con.setRequestProperty(key, extraHeaders.get(key));
  return loadBinaryPage_noHeaders(con);
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage_noHeaders(URLConnection con) { try {
  ByteArrayOutputStream buf = new ByteArrayOutputStream();
  InputStream inputStream = con.getInputStream();
  loadBinaryPage_responseHeaders.set(con.getHeaderFields());
  long len = 0;
  try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
int n = 0;
  while (true) {
    int ch = inputStream.read();
    if (ch < 0)
      break;
    buf.write(ch);
    if (++n % 100000 == 0)
      println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
  }
  inputStream.close();
  return buf.toByteArray();
} catch (Exception __e) { throw rethrow(__e); } }

/** writes safely (to temp file, then rename) */
public static byte[] saveBinaryFile(String fileName, byte[] contents) { try {
  File file = new File(fileName);
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  String tempFileName = fileName + "_temp";
  FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
  fileOutputStream.write(contents);
  fileOutputStream.close();
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + fileName);

  if (!new File(tempFileName).renameTo(file))
    throw new IOException("Can't rename " + tempFileName + " to " + fileName);
    
  vmBus_send("wroteFile", file);
  return contents;
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] saveBinaryFile(File fileName, byte[] contents) {
  return saveBinaryFile(fileName.getPath(), contents);
}
static String dataSnippetLink(String snippetID) {
  long id = parseSnippetID(snippetID);
  if (id >= 1100000 && id < 1200000)
    return imageServerURL() + id;
  if (id >= 1400000 && id < 1500000)
    return "http://butter.botcompany.de:8080/files/" + id + "?_pass=" + muricaPassword();
  if (id >= 1200000 && id < 1300000) { // Woody files, actually
    String pw = muricaPassword();
    if (empty(pw)) throw fail("Please set 'murica password by running #1008829");
    return "http://butter.botcompany.de:8080/1008823/raw/" + id + "?_pass=" + pw; // XXX, although it typically gets hidden when printing
  } else
    return "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + id + "&contentType=application/binary";
}
static void loadBinaryPageToFile(String url, File file) { try {
  print("Loading " + url);
  loadBinaryPageToFile(openConnection(new URL(url)), file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile(URLConnection con, File file) { try {
  setHeaders(con);
  loadBinaryPageToFile_noHeaders(con, file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) { try {
  File ftemp = new File(f2s(file) + "_temp");
  FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
  try {
    InputStream inputStream = con.getInputStream();
    long len = 0;
    try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
    String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
    copyStreamWithPrints(inputStream, buf, pat);
    inputStream.close();
    buf.close();
    file.delete();
    renameFile_assertTrue(ftemp, file);
  } finally {
    if (buf != null) buf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() {  public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}
static boolean isLoopbackIP(String ip) {
  return eq(ip, "127.0.0.1");
}
static int myVMPort() {
  List records =  (List) (get(getJavaX(), "record_list"));
  Object android = last(records);
  return or0((Integer) get(android, "port"));
}
static String thisVMGreeting() {
  List record_list =  (List) (get(getJavaX(), "record_list"));
  Object android = first(record_list); // Should be of class Android3
  return getString(android, "greeting");
}
static String sendToThisVM_newThread(String s, Object... args) {
  final String _s = format(s, args);
  try {
    return (String) evalInNewThread(new F0<Object>() { Object get() { try { 
      return callStaticAnswerMethod(getJavaX(), _s);
     } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ret callStaticAnswerMethod(getJavaX(), _s);"; }});
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    return str(e);
  }
}
static Object makeDependent_postProcess;

static void makeDependent(Object c) {
  if (c == null) return;
  assertTrue("Not a class", c instanceof Class);
  dependentClasses(); // cleans up the list
  hotwire_classes.add(new WeakReference(c));
  
  Object local_log = getOpt(mc(), "local_log");
  if (local_log != null)
    setOpt(c, "local_log", local_log);
    
  /*if (isTrue(getOpt(c, 'ping_actions_shareable)))
    setOpt(c, +ping_actions);*/
    
  Object print_byThread = getOpt(mc(), "print_byThread");
  if (print_byThread != null)
    setOpt(c, "print_byThread", print_byThread);
    
  callF(makeDependent_postProcess, c);
}

static void consoleSetInput(final String text) {
  
    if (headless()) return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  
}


static BufferedImage imageIO_readURL(String url) { try {
  if (startsWith(url, "https:")) // Java is still buggy there :(
    disableCertificateValidation();
  return ImageIO.read(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static boolean isAbsolutePath(String s) {
  return s != null && new File(s).isAbsolute();
}

static boolean isAbsolutePath(File f) {
  return f != null && f.isAbsolute();
}
static File imageSnippetsCacheDir() {
  return javaxCachesDir("Image-Snippets");
}
static String snippetImageURL_http(String snippetID) {
  return snippetImageURL_http(snippetID, "png");
}

static String snippetImageURL_http(String snippetID, String contentType) {
  return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
}
static boolean matchStart(String pat, String s) {
  return matchStart(pat, s, null);
}

// matches are as you expect, plus an extra item for the rest string
static boolean matchStart(String pat, String s, Matches matches) {
  if (s == null) return false;
  return matchStart(pat, parse3_cachedInput(s), matches);
}
  
static boolean matchStart(String pat, List<String> toks, Matches matches) {
  if (toks == null) return false;
  List<String> tokpat = parse3_cachedPattern(pat);
  if (toks.size() < tokpat.size()) return false;
  String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) {
    matches.m = new String[m.length+1];
    arraycopy(m, matches.m);
    matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size()); // for Matches.rest()
  }
  return true;
}
static String sendToLocalBotOpt(String bot, String text, Object... args) {
  if (bot == null) return null;
  text = format(text, args);
   DialogIO channel = findBot(bot); try {
  if (channel == null) {
    print(quote(bot) + " not found, skipping send: " + quote(text));
    return null;
  }
  try {
    channel.readLine();
    print(shorten(bot + "> " + text, 200));
    channel.sendLine(text);
    String s = channel.readLine();
    print(shorten(bot + "< " + s, 200));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}
static boolean exposeMethods2_debug = false;

static String exposeMethods2(Object receiver, String s, List<String> methodNames) {
  return exposeMethods2(receiver, s, methodNames, null);
}

static String exposeMethods2(Object receiver, String s, List<String> methodNames,
  Lock lock) {
  Matches m = new Matches();
  if (exposeMethods2_debug) print("Received: " + s);
  if (match("call *", s, m)) {
    List l;
    if (isIdentifier(m.unq(0)))
      l = ll(m.unq(0));
    else
      l = (List) unstructure(m.unq(0)); // we used to have safeUnstructure here
    String method = getString(l, 0);
    if (!contains(methodNames, method))
      throw fail("Method not allowed: " + method);
    if (lock != null) lock.lock();
    try {
      if (exposeMethods2_debug) print("Calling: " + method);
      Object o = call(receiver, method, asObjectArray(subList(l, 1)));
      if (exposeMethods2_debug) print("Got: " + getClassName(o));
      return ok2(structure(o));
    } finally {
      if (lock != null) lock.unlock();
    }
  }
  if (match("list methods", s))
    return ok2(structure(methodNames));
  return null;
}
static int makeBot(String greeting) {
  return makeAndroid3(greeting).port;
}

static Android3 makeBot(Android3 a) {
  makeAndroid3(a);
  return a;
}

static Android3 makeBot(String greeting, Object responder) {
  Android3 a = new Android3(greeting);
  a.responder = makeResponder(responder);
  makeBot(a);
  return a;
}

static Android3 makeBot() {
  return makeAndroid3(defaultBotName());
}
static TimeZone localTimeZone() {
  return getTimeZone(standardTimeZone());
  // TimeZone.getDefault()?
}
static <A> A println(A a) {
  return print(a);
}
static String imageServerURL() {
  return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
}
static volatile boolean muricaPassword_pretendNotAuthed = false;

static String muricaPassword() {
  if (muricaPassword_pretendNotAuthed) return null;
  return trim(loadTextFile(muricaPasswordFile()));
}
public static File mkdirsFor(File file) {
  return mkdirsForFile(file);
}

static void copyStreamWithPrints(InputStream in, OutputStream out, String pat) { try {
  byte[] buf = new byte[65536];
  int total = 0;
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
    if ((total+n)/100000 > total/100000)
      print(pat.replace("{*}", str(roundDownTo(total, 100000))));
    total += n;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static void renameFile_assertTrue(File a, File b) { try {
  if (!a.exists()) throw fail("Source file not found: " + f2s(a));
  if (b.exists()) throw fail("Target file exists: " + f2s(b));
  mkdirsForFile(b);
  
  
  if (!a.renameTo(b))
    throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
  
} catch (Exception __e) { throw rethrow(__e); } }
static Runnable addThreadInfoToRunnable(final Object r) {
  final Object info = _threadInfo();
  return info == null ? asRunnable(r) : new Runnable() {  public void run() { try {  _inheritThreadInfo(info); callF(r); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_inheritThreadInfo(info); callF(r);"; }};
}
static int or0(Integer i) { return i == null ? 0 : i; }
static long or0(Long l) { return l == null ? 0L : l; }
static double or0(Double d) { return d == null ? 0.0 : d; }
static Object evalInNewThread(final Object f) {
  final Flag flag = new Flag();
  final Var var = new Var();
  final Var<Throwable> exception = new Var();
  { startThread(new Runnable() {  public void run() { try {  
    try {
      var.set(callF(f));
    } catch (Throwable e) {
      exception.set(e);
    }
    flag.raise();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception..."; }}); }
  flag.waitUntilUp();
  if (exception.has()) throw rethrow(exception.get());
  return var.get();
}
static String callStaticAnswerMethod(List bots, String s) {
  for (Object c : bots) try {
    String answer = callStaticAnswerMethod(c, s);
    if (!empty(answer)) return answer;
  } catch (Throwable e) {
    print("Error calling " + getProgramID(c));
    e.printStackTrace();
  }
  return null;
}

static String callStaticAnswerMethod(Object c, String s) {
  String answer = (String) callOpt(c, "answer", s, litlist(s));
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}

static String callStaticAnswerMethod(String s) {
  return callStaticAnswerMethod(mc(), s);
}

static String callStaticAnswerMethod(String s, List<String> history) {
  return callStaticAnswerMethod(mc(), s, history);
}

static String callStaticAnswerMethod(Object c, String s, List<String> history) {
  String answer = (String) callOpt(c, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}
static List<Class> dependentClasses() {
  return cleanUpAndGetWeakReferencesList(hotwire_classes);
}
static boolean headless() {
  return isHeadless();
}
static JTextField setTextAndSelectAll(final JTextField tf, final String text) {
  { swing(new Runnable() {  public void run() { try { 
    tf.setText(text);
    tf.selectAll();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "tf.setText(text);\r\n    tf.selectAll();"; }}); }
  return tf;
}
static JTextField consoleInputField() {
  Object console = get(getJavaX(), "console");
  return (JTextField) getOpt(console, "tfInput");
}
static void focusConsole(String s) {
  setConsoleInput(s);
  focusConsole();
}

static void focusConsole() {
  JComponent tf = consoleInputFieldOrComboBox();
  if (tf != null) {
    //print("Focusing console");
    tf.requestFocus();
  }
}


static List<WeakReference<Class>> hotwire_classes = synchroList();

static Class<?> hotwireDependent(String src) {
  Class c = hotwire(src);
  makeDependent(c);
  return c;
}

static Object[] asObjectArray(List l) {
  return toObjectArray(l);
}
static String ok2(String s) {
  return "ok " + s;
}
// An "Android" is a program that accepts text questions (on console or TCP) and outputs one response text per question

//please include function myJavaSource. // for getting my known commands

static boolean makeAndroid3_disable = false; // disable all android making

static class Android3 {
  String greeting;
  boolean publicOverride = false; // optionally set this in client
  int startPort = 5000; // optionally set this in client
  Responder responder;
  boolean console = true;
  boolean quiet = false; // no messages on console
  boolean daemon = false;
  boolean incomingSilent = false;
  int incomingPrintLimit = 200;
  boolean useMultiPort = true;
  boolean recordHistory = false;
  boolean verbose = false;
  int answerPrintLimit = 500;
  boolean newLineAboveAnswer, newLineBelowAnswer;
  
  // set by system
  int port;
  long vport;
  DialogHandler handler;
  ServerSocket server;
  
  Android3(String greeting) {
  this.greeting = greeting;}
  Android3() {}
  
  synchronized void dispose() {
    if (server != null) {
      try {
        server.close();
      } catch (IOException e) {
        print("[internal] " + e);
      }
      server = null;
    }
    if (vport != 0) { try {
      print("Disposing " + this);
      removeFromMultiPort(vport);
      vport = 0;
    } catch (Throwable __e) { _handleException(__e); }}
  }
  
  public String toString() { return "Bot: " + greeting + " [vport " + vport + "]"; }
}

static abstract class Responder {
  abstract String answer(String s, List<String> history);
}

static Android3 makeAndroid3(final String greeting) {
  return makeAndroid3(new Android3(greeting));
}

static Android3 makeAndroid3(final String greeting, Responder responder) {
  Android3 android = new Android3(greeting);
  android.responder = responder;
  return makeAndroid3(android);
}

static Android3 makeAndroid3(final Android3 a) {
  if (makeAndroid3_disable) return a;
  
  if (a.responder == null)
    a.responder = new Responder() {
      String answer(String s, List<String> history) {
        return callStaticAnswerMethod(s, history);
      }
    };
    
  if (!a.quiet)
    print("[bot] " + a.greeting);
  
  if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
    a.console = false;
  
  record(a);
  
  if (a.useMultiPort)
    a.vport = addToMultiPort(a.greeting,
      makeAndroid3_verboseResponder(a));
      
  if (a.console)
    makeAndroid3_handleConsole(a);

  if (a.useMultiPort) return a;

  a.handler = makeAndroid3_makeDialogHandler(a);
  if (a.quiet) startDialogServer_quiet.set(true);
  try {
    a.port = a.daemon
      ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler)
      : startDialogServerOnPortAbove(a.startPort, a.handler);
  } finally {
    startDialogServer_quiet.set(null);
  }
  a.server = startDialogServer_serverSocket;

  return a;
}

static void makeAndroid3_handleConsole(final Android3 a) {
  // Console handling stuff
  if (!a.quiet)
    print("You may also type on this console.");
  { startThread(new Runnable() {  public void run() { try {  
    List<String> history = new ArrayList();
    while (licensed()) {
      String line;
      try {
        line = readLine();
      } catch (Throwable e) {
        print(getInnerMessage(e));
        break;
      }
      if (line == null) break;
      /*if (eq(line, "bye")) {
        print("> bye stranger");
        history = new ArrayList<S>();
      } else*/ {
        history.add(line);
        history.add(makeAndroid3_getAnswer(line, history, a)); // prints answer on console too
      }
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri..."; }}); }
}

static DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
  return new DialogHandler() {
public void run(final DialogIO io) {
    if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
      io.sendLine("Sorry, not allowed");
      return;
    }
    
    String dialogID = randomID(8);
    
    io.sendLine(a.greeting + " / Your ID: " + dialogID);
    
    List<String> history = new ArrayList();
    
    while (io.isStillConnected()) {
      if (io.waitForLine()) {
        final String line = io.readLineNoBlock();
        String s = dialogID + " at " + now() + ": " + quote(line);
        if (!a.incomingSilent)
          print(shorten(s, a.incomingPrintLimit));
        if (eq(line, "bye")) {
          io.sendLine("bye stranger");
          return;
        }
        Matches m = new Matches();
        if (a.recordHistory)
          history.add(line);
        String answer;
        if (match3("this is a continuation of talk *", s, m)
          || match3("hello bot! this is a continuation of talk *", s, m)) {
          dialogID = unquote(m.m[0]);
          answer = "ok";
        } else try {
          makeAndroid3_io.set(io);
          answer = makeAndroid3_getAnswer(line, history, a);
        } finally {
          makeAndroid3_io.set(null);
        }
        if (a.recordHistory)
          history.add(answer);
        io.sendLine(answer);
        //appendToLog(logFile, s);
      }
    }
  }};
}

static String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
  String answer, originalAnswer;
  try {
    originalAnswer = a.responder.answer(line, history);
    answer = makeAndroid3_fallback(line, history, originalAnswer);
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    originalAnswer = answer = e.toString();
  }
  if (!a.incomingSilent) {
    if (originalAnswer == null) originalAnswer = "?";
    if (a.newLineAboveAnswer) print();
    print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
    if (a.newLineBelowAnswer) print();
  }
  return answer;
}

static String makeAndroid3_fallback(String s, List<String> history, String answer) {
  // Now we only do the safe thing instead of VM inspection - give out our process ID
  if (answer == null && match3("what is your pid", s))
    return getPID();
    
  if (answer == null && match3("what is your program id", s)) // should be fairly safe, right?
    return getProgramID();
    
  if (match3("get injection id", s))
    return getInjectionID();
    
  if (answer == null) answer = "?";
  if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
    answer = quote(answer);
  return answer;
}

static boolean makeAndroid3_consoleInUse() {
  if (isTrue(vm_generalMap_get("consoleInUse"))) return true;
  for (Object o : record_list)
    if (o instanceof Android3 && ((Android3) o).console)
      return true;
  return false;
}

static Responder makeAndroid3_verboseResponder(final Android3 a) {
  return new Responder() {
    String answer(String s, List<String> history) {
      if (a.verbose)
        print("> " + shorten(s, a.incomingPrintLimit));
      String answer = a.responder.answer(s, history);
      if (a.verbose)
        print("< " + shorten(answer, a.incomingPrintLimit));
      return answer;
    }
  };
}

static ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

static Android3 makeAndroid3() {
  return makeAndroid3(getProgramTitle() + ".");
}
static String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
  String answer = (String) callOpt(bot, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(bot, "answer", s);
  return answer;
}

static Responder makeResponder(final Object bot) {
  if (bot instanceof Responder) return (Responder) bot;
  
  if (bot instanceof String) {
    String f =  (String) bot;
    return new Responder() {
      String answer(String s, List<String> history) {
        String answer = (String) callOptMC((String) bot, s, history);
        if (answer == null)
          answer = (String) callOptMC((String) bot, s);
        return answer;
      }
    };
  }
  
  return new Responder() {
    String answer(String s, List<String> history) {
      return makeResponder_callAnswerMethod(bot, s, history);
    }
  };
}
static String defaultBotName() {
  return getProgramTitle() + ".";
}


static TimeZone getTimeZone(String name) {
  return TimeZone.getTimeZone(name);
}
static String standardTimeZone_name = "Europe/Berlin";

static String standardTimeZone() {
  return standardTimeZone_name;
}
static File muricaPasswordFile() {
  return new File(javaxSecretDir(), "murica/muricaPasswordFile");
}
static int roundDownTo(int x, int n) {
  return x/n*n;
}

static long roundDownTo(long x, long n) {
  return x/n*n;
}
static Runnable asRunnable(Object o) {
  return toRunnable(o);
}


static void _inheritThreadInfo(Object info) {
  _threadInheritInfo(info);
}
static String emptyToNull(String s) {
  return eq(s, "") ? null : s;
}

static <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
  return empty(map) ? null : map;
}
static <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
  if (l == null) return null;
  synchronized(l) {
    List<A> out = new ArrayList();
    for (int i = 0; i < l(l); i++) {
      A a = l.get(i).get();
      if (a == null)
        l.remove(i--);
      else
        out.add(a);
    }
    return out;
  }
}
static void setConsoleInput(String text) {
  consoleSetInput(text);
}
static JComponent consoleInputFieldOrComboBox() {
  Object console = get(getJavaX(), "console");
  JComboBox cb =  (JComboBox) (getOpt(console, "cbInput"));
  if (cb != null) return cb;
  return (JTextField) getOpt(console, "tfInput");
}


static void removeFromMultiPort(long vport) {
  if (vport == 0) return;
  for (Object port : getMultiPorts())
    call(port, "removePort", vport);
}
static List<Object> record_list = synchroList();

static void record(Object o) {
  record_list.add(o);
}
static Object addToMultiPort_responder;

static long addToMultiPort(final String botName) {
  return addToMultiPort(botName, new Object() {
    public String answer(String s, List<String> history) {
      String answer =  (String) (callOpt(getMainClass(), "answer", s, history));
      if (answer != null) return answer;
      answer = (String) callOpt(getMainClass(), "answer", s);
      if (answer != null) return answer;
      if (match3("get injection id", s))
        return getInjectionID();
      return null;
    }
  });
}

static long addToMultiPort(final String botName, final Object responder) {
  //print(botName);
  addToMultiPort_responder = responder;
  startMultiPort();
  List ports = getMultiPorts();
  if (ports == null) return 0;
  if (ports.isEmpty())
    throw fail("No multiports!");
  if (ports.size() > 1)
    print("Multiple multi-ports. Using last one.");
  Object port = last(ports);
  Object responder2 = new Object() {
    public String answer(String s, List<String> history) {
      if (match3("get injection id", s))
        return getInjectionID();
      if (match3("your name", s))
        return botName;
      return (String) call(responder, "answer", s, history);
    }
  };
  record(responder2);
  return (Long) call(port, "addResponder", botName, responder2);
}

static AtomicInteger dialogServer_clients = new AtomicInteger();
static boolean dialogServer_printConnects = false;
static ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

static Set<String> dialogServer_knownClients = synchroTreeSet();

static int startDialogServerOnPortAbove(int port, DialogHandler handler) {
  while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler))
    ++port;
  return port;
}

static int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
  while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true))
    ++port;
  return port;
}

static void startDialogServer(int port, DialogHandler handler) {
  if (!startDialogServerIfPortAvailable(port, handler))
    throw fail("Can't start dialog server on port " + port);
}

static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
  return startDialogServerIfPortAvailable(port, handler, false);
}

static ServerSocket startDialogServer_serverSocket;
  
static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
  ServerSocket serverSocket = null;
  try {
    serverSocket = new ServerSocket(port);
  } catch (IOException e) {
    // probably the port number is used - let's assume there already is a chat server.
    return false;
  }
  final ServerSocket _serverSocket = serverSocket;
  startDialogServer_serverSocket = serverSocket;

  Thread thread = new Thread("Socket accept port " + port) { public void run() {
   try {
    while (true) {
      try {
        final Socket s = _serverSocket.accept();
        
        String client = s.getInetAddress().toString();
        if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
          print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
          dialogServer_knownClients.add(client);
        }
        
        String threadName = "Handling client " + s.getInetAddress();

        Thread t2 = new Thread(threadName) {
         public void run() {
          try {
            final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
            final BufferedReader in = new BufferedReader(
              new InputStreamReader(s.getInputStream(), "UTF-8"));
              
            DialogIO io = new DialogIO() {
            
              // This should be the same as #1001076 (talkTo)
            
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    w.write(line + "\n");
    w.flush();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {
    try {
      s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
  };
            
            try {
              handler.run(io);
            } finally {
              if (!io.noClose)
                s.close();
            }
          } catch (IOException e) {
            print("[internal] " + e);
          } finally {
            //print("client disconnect - " + dialogServer_clients.decrementAndGet() + " remaining");
          }
         }
        }; // Thread t2
        t2.setDaemon(true); // ?
        t2.start();
      } catch (SocketTimeoutException e) {
      }
    }   
   } catch (IOException e) {
     print("[internal] " + e);
   }
  }};
  if (daemon) thread.setDaemon(true);
  thread.start();
 
  if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
    print("Dialog server on port " + port + " started."); 
  return true;
}
static boolean publicCommOn() {
  return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
}
static String indentx(String s) {
  return indentx(indent_default, s);
}

static String indentx(int n, String s) {
  return dropSuffix(repeat(' ', n), indent(n, s));
}

static String indentx(String indent, String s) {
  return dropSuffix(indent, indent(indent, s));
}
static String processID_cached;

// try to get our current process ID
static String getPID() {
  if (processID_cached == null) {
    String name = ManagementFactory.getRuntimeMXBean().getName();
    processID_cached = name.replaceAll("@.*", "");
  }
  return processID_cached;
}
static String getInjectionID() {
  return (String) call(getJavaX(), "getInjectionID", getMainClass());
}
static String getProgramTitle() {
  return getProgramName();
}
static Object callOptMC(String method, Object... args) {
  return callOpt(mc(), method, args);
}


static List<Object> getMultiPorts() {
  return (List) callOpt(getJavaX(), "getMultiPorts");
}
// start multi-port if none exists in current VM.
static void startMultiPort() {
  List mp = getMultiPorts();
  if (mp != null && mp.isEmpty()) {
    nohupJavax("#1001639");
    throw fail("Upgrading JavaX, please restart this program afterwards.");
    //callMain(hotwire("#1001672"));
  }
}
static <A> Set<A> synchroTreeSet() {
  return Collections.synchronizedSet(new TreeSet<A>());
}

static boolean forbiddenPort(int port) {
  return port == 5037; // adb
}

static int indent_default = 2;

static String indent(int indent) {
  return repeat(' ', indent);
}

static String indent(int indent, String s) {
  return indent(repeat(' ', indent), s);
}

static String indent(String indent, String s) {
  return indent + s.replace("\n", "\n" + indent);
}

static String indent(String s) {
  return indent(indent_default, s);
}

static List<String> indent(String indent, List<String> lines) {
  List<String> l = new ArrayList();
  if (lines != null) for (String s : lines)
    l.add(indent + s);
  return l;
}
static String getProgramName_cache;

static String getProgramName() {
  Lock __2108 = downloadLock(); lock(__2108); try {
  if (getProgramName_cache == null)
    getProgramName_cache = getSnippetTitleOpt(programID());
  return getProgramName_cache;
} finally { unlock(__2108); } }

static void _onLoad_getProgramName() {
  { startThread(new Runnable() {  public void run() { try {   getProgramName(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "getProgramName();"; }}); }
}


static Lock downloadLock_lock = fairLock();

static Lock downloadLock() {
  return downloadLock_lock;
}
static String getSnippetTitleOpt(String s) {
  return isSnippetID(s) ? getSnippetTitle(s) : s;
}


static String getSnippetTitle(String id) { try {
  if (id == null) return null;
  if (!isSnippetID(id)) return "?";
  
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.getSnippetTitle(id);
  

  if (isLocalSnippetID(id)) return localSnippetTitle(id);
  long parsedID = parseSnippetID(id);
  String url;
  if (isImageServerSnippet(parsedID))
    url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
  else if (isGeneralFileServerSnippet(parsedID))
    url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
  else
    url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
  String title = trim(loadPageSilently(url));
  if (title != null)
    try { saveTextFileIfChanged(snippetTitle_cacheFile(id), title); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  return or(title, "?");
} catch (Exception __e) { throw rethrow(__e); } }

static String getSnippetTitle(long id) {
  return getSnippetTitle(fsI(id));
}



static String localSnippetTitle(String snippetID) {
  if (!isLocalSnippetID(snippetID)) return null;
  File f = localSnippetFile(snippetID);
  if (!f.exists()) return null;
  return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
}
static String muricaCredentialsQuery() {
  return htmlQuery(muricaCredentials());
}
static boolean isGeneralFileServerSnippet(long id) {
  return id >= 1400000 && id < 1500000;
}
static String standardCredentials_noCookies() {
  return standardCredentials() + "&noCookies=1";
}
static boolean saveTextFileIfChanged(File f, String contents) {
  return saveTextFileIfDifferent(f, contents);
}
static File snippetTitle_cacheFile(String snippetID) {
  return javaxCachesDir("Snippet Titles/" + psI(snippetID));
}


static String getFileInfoField(File f, String field) {
  return getOneLineFileInfoField(f, field);
}
static File dropExtension(File f) {
  return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
}

static String dropExtension(String s) {
  return takeFirst(s, smartLastIndexOf(s, '.'));
}
static Object[] muricaCredentials() {
  String pass = muricaPassword();
  return nempty(pass) ? new Object[] {"_pass", pass } : new Object[0];
}
static boolean saveTextFileIfDifferent(File f, String contents) {
  if (eq(loadTextFile(f), contents)) return false;
  { saveTextFile(f, contents); return true; }
}


static String getOneLineFileInfoField(File f, String field) {
  File infoFile = associatedInfosFile(f);
  List<String> lines = lines(loadTextFile(infoFile));
  return firstStartingWithIC_drop(lines, field + ": ");
}
static File fileInSameDir(File f, String newName) {
  return newFile(parentFile(f), newName);
}
static int smartLastIndexOf(String s, char c) {
  if (s == null) return 0;
  int i = s.lastIndexOf(c);
  return i >= 0 ? i : l(s);
}


static File associatedInfosFile(File f) {
  return replaceExtension(f, ".infos");
}
static String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
  for (String s : unnull(l))
    if (swic(s, prefix))
      return substring(s, l(prefix));
  return null;
}

static String firstStartingWithIC_drop(String prefix, Collection<String> l) {
  return firstStartingWithIC_drop(l, prefix);
}
static File parentFile(File f) {
  return dirOfFile(f);
}


static File replaceExtension(File f, String extOld, String extNew) {
  return newFile(replaceExtension(f2s(f), extOld, extNew));
}

static File replaceExtension(File f, String extNew) {
  return replaceExtension(f, fileExtension(f), extNew);
}

static String replaceExtension(String s, String extOld, String extNew) {
  s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
  return s + addPrefixOptIfNempty(".", extNew);
}

static String replaceExtension(String name, String extNew) {
  return replaceExtension(name, fileExtension(name), extNew);
}
static File dirOfFile(File f) {
  return f == null ? null : f.getParentFile();
}


static String fileExtension(File f) {
  if (f == null) return null;
  return fileExtension(f.getName());
}

static String fileExtension(String s) {
  return substring(s, smartLastIndexOf(s, '.'));
}
static String addPrefixOptIfNempty(String prefix, String s) {
  return addPrefixIfNotEmpty2(prefix, s);
}


static String addPrefixIfNotEmpty2(String prefix, String s) {
  return empty(s) ? "" : addPrefix(prefix, s);
}


static String addPrefix(String prefix, String s) {
  return s.startsWith(prefix) ? s : prefix + s;
}


static class Str extends Concept {
  String name;
  List<String> otherNames = new ArrayList();
  
  Str() {}
  Str(String name) {
  this.name = name;}
  
  public String toString() { return name; }
}static class ProgramScan {
  static int threads = isWindows() ? 500 : 10;
  static int timeout = 5000; // hmm...
  static String ip = "127.0.0.1";
  
  // This range is not used anymore anyway
  static int quickScanFrom = 10000, quickScanTo = 10999;

  static int maxNumberOfVMs_android = 4; // Android will always only have one if we don't screw up
  static int maxNumberOfVMs_nonAndroid = 50; // 100;
  static int maxNumberOfVMs;
  
  static boolean verbose = false;
  
  static class Program {
    int port;
    String helloString;
    
    Program(int port, String helloString) {
  this.helloString = helloString;
  this.port = port;}
  }
  
  static List<Program> scan() { try {
    return scan(1, 65535);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  static List<Program> scan(int fromPort, int toPort) {
    return scan(fromPort, toPort, new int[0]);
  }
  
  static List<Program> scan(int fromPort, int toPort, int[] preferredPorts) { try {
    Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
    int scanSize = toPort-fromPort+1;
    String name = toPort < 10000 ? "bot" : "program";
    int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
    final ExecutorService es = Executors.newFixedThreadPool(threads);
    if (verbose) print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
    startTiming();
    List<Future<Program>> futures = new ArrayList();
    List<Integer> ports = new ArrayList();
    for (int port : preferredPorts) {
      futures.add(checkPort(es, ip, port, timeout));
      ports.add(port);
    }
    for (int port = fromPort; port <= toPort; port++)
      if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
        futures.add(checkPort(es, ip, port, timeout));
        ports.add(port);
      }
    es.shutdown();
    List<Program> programs = new ArrayList();
    long time = now();
    int i = 0;
    for (final Future<Program> f : futures) {
      if (verbose) print("Waiting for port " + get(ports, i++) + " at time " + (now()-time));
      Program p = f.get();
      if (p != null)
        programs.add(p);
    }
    //stopTiming("Port Scan " + scanSize + ", " + n(threads, "threads") + ": ", 250);
    if (verbose) print("Found " + programs.size() + " " + name + "(s) on " + ip);
    return programs;
  } catch (Exception __e) { throw rethrow(__e); } }

  static Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
    return es.submit(new Callable<Program>() {
        @Override public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              //if (verbose) print("Connected to " + ip + ":" + port);
              BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
     });
  }
  
  static List<Program> quickScan() {
    return scan(quickScanFrom, quickScanTo);
  }
  
  static List<Program> quickBotScan() {
    return quickBotScan(new int[0]);
  }
  
  static List<Program> quickBotScan(int[] preferredPorts) {
    if (maxNumberOfVMs == 0)
      maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
    return scan(4999, 5000+maxNumberOfVMs-1, preferredPorts);
  }
}static class FixedRateTimer extends java.util.Timer {
  FixedRateTimer() { this(false); }
  FixedRateTimer(boolean daemon) { this(defaultTimerName(), daemon); }
  FixedRateTimer(String name) { this(name, false); }
  FixedRateTimer(String name, boolean daemon) {
    super(name, daemon);
    _registerTimer(this);
  }
  
  List<Entry> entries = synchroList();
  
  static  class Entry {
  static String _fieldOrder = "task firstTime period";
  TimerTask task;
  long firstTime;
  long period;
  Entry() {}
  Entry(TimerTask task, long firstTime, long period) {
  this.period = period;
  this.firstTime = firstTime;
  this.task = task;}
  public String toString() { return "Entry(" + task + ", " + firstTime + ", " + period + ")"; }}
  
  // Note: not all methods overridden; only use these ones
  
  public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
    entries.add(new Entry(task, now()+delay, period));
    super.scheduleAtFixedRate(task, delay, period);
  }
  
  public void cancel() {
    entries.clear();
    super.cancel();
  }
  
  public int purge() {
    entries.clear();
    return super.purge();
  }
  
  FixedRateTimer changeRate(int newPeriod) {
    Object r = ((SmartTimerTask) first(entries).task).r;
    cancel();
    return doEvery(newPeriod, r);
  }
}/** this class is fully thread-safe */
static class Flag implements Runnable {
  private boolean up = false;

  /** returns true if flag was down before */
  public synchronized boolean raise() {
    if (!up) {
      up = true;
      notifyAll();
      return true;
    } else
      return false;
  }

  public synchronized void waitUntilUp() {
    while (!up) {
      try {
        wait();
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized void waitUntilUp(long timeout) {
    if (!up) {
      try {
        wait(timeout);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized boolean isUp() {
    return up;
  }
  
  boolean get() { return isUp(); }

  public String toString() {
    return isUp() ? "up" : "down";
  }

  // currently does a semi-active wait with latency = 50 ms
  public void waitForThisOr(Flag otherFlag) { try {
    while (!isUp() && !otherFlag.isUp())
      Thread.sleep(50);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void run() { raise(); }
}

public static boolean isWindows() {
  return System.getProperty("os.name").contains("Windows");
}
static String firstToUpper(String s) {
  if (empty(s)) return s;
  return Character.toUpperCase(s.charAt(0)) + s.substring(1);
}
static long stopTiming_defaultMin = 10;

static long startTiming_startTime;
static void startTiming() {
  startTiming_startTime = now();
}

static void stopTiming() {
  stopTiming(null);
}

static void stopTiming(String text) {
  stopTiming(text, stopTiming_defaultMin);
}

static void stopTiming(String text, long minToPrint) {
  long time = now()-startTiming_startTime;
  if (time >= minToPrint) {
    text = or2(text, "Time: ");
    print(text + time + " ms");
  }
}
static String defaultTimerName_name;

static String defaultTimerName() {
  if (defaultTimerName_name == null)
    defaultTimerName_name = "A timer by " + programID();
  return defaultTimerName_name;
}
static Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

static void _registerTimer(java.util.Timer timer) {
  _registerTimer_list.add(timer);
}

static void cleanMeUp__registerTimer() {
  cancelTimers(getAndClearList(_registerTimer_list));
}
// firstDelay = delay
static FixedRateTimer doEvery(long delay, final Object r) {
  return doEvery(delay, delay, r);
}

static FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
  return timer;
}

// reversed argument order for fun
static FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
}

static FixedRateTimer doEvery(double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), r);
}



static <A> Set<A> newWeakHashSet() {
  return synchroWeakHashSet();
}
static void cancelTimers(Collection timers) {
  for (Object timer : timers) cancelTimer(timer);
}
static <A> List<A> getAndClearList(Collection<A> l) {
  if (l == null) return emptyList();
  synchronized(collectionMutex(l)) {
    List<A> out = cloneList(l);
    l.clear();
    return out;
  }
}


static <A> Set<A> synchroWeakHashSet() {
  return Collections.newSetFromMap((Map) newWeakHashMap());
}
static void cancelTimer(javax.swing.Timer timer) {
  if (timer != null) timer.stop();
}

static void cancelTimer(java.util.Timer timer) {
  if (timer != null) timer.cancel();
}

static void cancelTimer(Object o) {
  if (o instanceof java.util.Timer) cancelTimer((java.util.Timer) o);
  else if (o instanceof javax.swing.Timer) cancelTimer((javax.swing.Timer) o);
  else if (o instanceof AutoCloseable) { try { ((AutoCloseable) o).close(); } catch (Throwable __e) { _handleException(__e); }}
}

}









class m1024374{}