//FILENAME: loadableUtils/utils.java
package loadableUtils;
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import java.awt.datatransfer.StringSelection;
import javax.swing.border.*;
import java.awt.geom.*;
import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;
import javax.swing.Timer;
import java.awt.datatransfer.*;
import java.text.SimpleDateFormat;
import javax.swing.undo.UndoManager;
import java.text.NumberFormat;
import java.text.*;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.nio.charset.Charset;
import java.util.TimeZone;
import net.coobird.thumbnailator.Thumbnailator;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.*;
import static x30_pkg.x30_util.VF1;
import x30_pkg.x30_util.DynamicObject;

public class utils {

  static public ThreadLocal<Boolean> DynamicObject_loading = x30_pkg.x30_util.DynamicObject_loading;

  static public File nohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs);
  }

  static public File nohupJavax(String javaxargs, String vmArgs) {
    return directNohupJavax(javaxargs, vmArgs);
  }

  static public interface DynamicMethods {

    abstract public Object _dynCall(String methodName, Object[] args);
  }

  static public class BetterLabel extends JLabel {

    public boolean autoToolTip = true;

    public BetterLabel() {
      final WeakReference<BetterLabel> me = new WeakReference<>(this);
      componentPopupMenu(this, BetterLabel_menuItems(me));
    }

    public BetterLabel(String text) {
      this();
      this.setText(text);
    }

    public void setText(String text) {
      super.setText(text);
      if (autoToolTip)
        if (!swic(text, "<html>"))
          setToolTipText(nullIfEmpty(text));
    }
  }

  static public VF1<JPopupMenu> BetterLabel_menuItems(final WeakReference<BetterLabel> me) {
    return new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboard(me.get().getText());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboard(me.get().getText());";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, \"Copy text to clipboard\", r {\r\n      copyTextToClipboard(me...";
      }
    };
  }

  static public class SingleComponentPanel extends JPanel {

    public SingleComponentPanel() {
      super(new BorderLayout());
    }

    public SingleComponentPanel(Component component) {
      this();
      if (component != null)
        setComponent(component);
    }

    public void setComponent(final Component component) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              removeAll();
              if (component != null)
                add(BorderLayout.CENTER, wrap(component));
              _revalidate(SingleComponentPanel.this);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "removeAll();\r\n      if (component != null)\r\n        add(BorderLayout.CENTER, ...";
          }
        });
      }
    }

    public void setComponentAndRevalidateParent(Component component) {
      setComponent(component);
      _revalidate(_getParent(this));
    }

    public void noComponent() {
      setComponent(null);
    }

    public Component getComponent() {
      return getComponentCount() == 0 ? null : getComponent(0);
    }
  }

  static public class Snippet {

    public String id, title, md5, type, text;

    public boolean isPublic = false;

    public Snippet() {
    }

    public Snippet(String id, String title) {
      this.title = title;
      this.id = id;
    }

    public Snippet(String id, String title, String md5) {
      this.md5 = md5;
      this.title = title;
      this.id = id;
    }

    public String toString() {
      return id + " - " + title;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }
  }

  static final public class BWImage implements MakesBufferedImage, IBWImage {

    public int width, height;

    public byte[] pixels;

    public float borderColor = 0.0f;

    public BWImage() {
    }

    public BWImage(int width, int height) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
    }

    public BWImage(int width, int height, float brightness) {
      this.height = height;
      this.width = width;
      pixels = new byte[width * height];
      fillArrayUnlessZero(pixels, _toByte(brightness));
    }

    public BWImage(int width, int height, float[] pixels) {
      this.pixels = new byte[pixels.length];
      this.height = height;
      this.width = width;
      for (int i = 0; i < pixels.length; i++) this.pixels[i] = _toByte(pixels[i]);
    }

    public BWImage(int width, int height, byte[] pixels) {
      this.height = height;
      this.width = width;
      this.pixels = pixels;
    }

    public BWImage(BWImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) pixels[y * width + x] = image.getByte(x, y);
    }

    public BWImage(RGBImage image) {
      width = image.getWidth();
      height = image.getHeight();
      byte[] pixels = this.pixels = new byte[height * width];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        pixels[y * width + x] = BWImage._toByte(rgb.getBrightness());
      }
    }

    public BWImage(BufferedImage image) {
      try {
        width = image.getWidth();
        height = image.getHeight();
        int[] pixels = new int[width * height];
        byte[] bytePixels = this.pixels = new byte[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        if (!pixelGrabber.grabPixels())
          throw fail("Could not grab pixels");
        int n = width * height;
        for (int i = 0; i < n; i++) {
          int packed = pixels[i];
          int r = ((packed >> 16) & 0xFF);
          int g = ((packed >> 8) & 0xFF);
          int b = (packed & 0xFF);
          bytePixels[i] = (byte) ((r + g + b + 1) / 3);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public byte pixelToByte(int packed) {
      float r = ((packed >> 16) & 0xFF) / 255f;
      float g = ((packed >> 8) & 0xFF) / 255f;
      float b = (packed & 0xFF) / 255f;
      return (byte) ((r + g + b) / 3.0f * 255f);
    }

    public byte getByte(int x, int y) {
      return inRange(x, y) ? getByte_noRangeCheck(x, y) : _toByte(borderColor);
    }

    public int getInt(int x, int y) {
      return ubyteToInt(getByte(x, y));
    }

    public double averageBrightness() {
      double sum = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) sum += getPixel(x, y);
      return (sum / (double) (height * width));
    }

    public float minimumBrightness() {
      float min = 1;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) min = Math.min(min, getPixel(x, y));
      return min;
    }

    public float maximumBrightness() {
      float max = 0;
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) max = Math.max(max, getPixel(x, y));
      return max;
    }

    public float getPixel(int x, int y) {
      return inRange(x, y) ? _toFloat(getByte(x, y)) : borderColor;
    }

    public float getFloatPixel(int x, int y) {
      return getPixel(x, y);
    }

    public float getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    static public byte _toByte(float pixel) {
      return (byte) (pixel * 255f);
    }

    static public float _toFloat(byte pixel) {
      return (((int) pixel) & 255) / 255f;
    }

    final public boolean inRange(int x, int y) {
      return x >= 0 && x < width && y >= 0 && y < height;
    }

    public int getWidth() {
      return width;
    }

    public int w() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int h() {
      return height;
    }

    public RGBImage toRGB() {
      int[] rgbs = new int[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = getByte(x, y) & 0xFF;
        rgbs[y * width + x] = 0xFF000000 | b * 0x010101;
      }
      return new RGBImage(width, height, rgbs);
    }

    public RGBImage toRGB_slow() {
      RGB[] rgbs = new RGB[width * height];
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y * width + x] = new RGB(p, p, p);
      }
      return new RGBImage(width, height, rgbs);
    }

    public BWImage clip(int x, int y, int w, int h) {
      return clip(new Rectangle(x, y, w, h));
    }

    final public Rectangle fixClipRect(Rectangle r) {
      return r.intersection(new Rectangle(0, 0, width, height));
    }

    public BWImage clip(Rect r) {
      return clip(r.getRectangle());
    }

    public BWImage clip(Rectangle r) {
      r = fixClipRect(r);
      byte[] newPixels = new byte[r.height * r.width];
      for (int y = 0; y < r.height; y++) for (int x = 0; x < r.width; x++) newPixels[y * r.width + x] = getByte(r.x + x, r.y + y);
      return new BWImage(r.width, r.height, newPixels);
    }

    public void setPixel(int x, int y, float brightness) {
      setByte(x, y, _toByte(fixPixel(brightness)));
    }

    public void setInt(int x, int y, int i) {
      setByte(x, y, (byte) limitToUByte(i));
    }

    public void setByte(int x, int y, byte b) {
      if (x >= 0 && x < width && y >= 0 && y < height)
        pixels[y * width + x] = b;
    }

    public byte getByte_noRangeCheck(int x, int y) {
      return pixels[y * width + x];
    }

    public void setByte(int x, int y, int brightness) {
      setByte(x, y, (byte) brightness);
    }

    final public float fixPixel(float pixel) {
      return Math.max(0, Math.min(1, pixel));
    }

    public float getBorderColor() {
      return borderColor;
    }

    public void setBorderColor(float borderColor) {
      this.borderColor = borderColor;
    }

    public boolean anyPixelBrighterThan(double threshold) {
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) if (getPixel(x, y) > threshold)
        return true;
      return false;
    }

    public BufferedImage getBufferedImage() {
      BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) {
        int b = ((int) getByte(x, y) & 0xFF);
        bufferedImage.setRGB(x, y, b * 0x010101);
      }
      return bufferedImage;
    }

    public byte[] getBytes() {
      return pixels;
    }
  }

  static public class Cache<A> {

    public Object maker;

    public A value;

    public long loaded;

    static public boolean debug = false;

    public long changeCount;

    public Lock lock = lock();

    public Cache() {
    }

    public Cache(Object maker) {
      this.maker = maker;
    }

    public Cache(IF0<A> maker) {
      this.maker = maker;
    }

    public A get() {
      if (hasLock(lock))
        return value;
      Lock __14 = lock;
      lock(__14);
      try {
        if (loaded == 0) {
          value = make();
          changeCount++;
          loaded = sysNow();
        }
        return value;
      } finally {
        unlock(__14);
      }
    }

    public void clear() {
      Lock __15 = lock;
      lock(__15);
      try {
        if (debug && loaded != 0)
          print("Clearing cache");
        value = null;
        changeCount++;
        loaded = 0;
      } finally {
        unlock(__15);
      }
    }

    public void clear(double seconds) {
      Lock __16 = lock;
      lock(__16);
      try {
        if (seconds != 0 && loaded != 0 && sysNow() >= loaded + seconds * 1000)
          clear();
      } finally {
        unlock(__16);
      }
    }

    public void set(A a) {
      Lock __17 = lock;
      lock(__17);
      try {
        value = a;
        ++changeCount;
        loaded = sysNow();
      } finally {
        unlock(__17);
      }
    }

    public A make() {
      return (A) callF(maker);
    }
  }

  static abstract public class DynModule {

    public String name, toolTip;

    public PersistableThrowable _error;

    public Map<String, Collection<String>> mechLists;

    public Map<String, Boolean> _persistenceInfo;

    transient public Object _host;

    transient public Map timers = newWeakHashMap();

    transient public Set<AutoCloseable> _resources = synchroHashSet();

    transient public Lock lock;

    transient public boolean persistOnChangedField = true;

    transient public int changeCount;

    transient public Object changeCountSync = new Object();

    transient public List onChange;

    transient public List onTransientChange;

    transient public boolean verboseTimers = false;

    transient public ReliableSingleThread rstUpdate;

    transient public Set<String> componentFieldsToKeep;

    transient public Map<String, Object> transientGeneralMap = synchroHashMap();

    transient public Q q;

    transient public List onFieldChange;

    transient public boolean _hasPreviousBounds = false;

    transient public StringBuffer _printLog = new StringBuffer();

    transient public boolean deleted = false;

    public DynModule() {
      dm_initErrorHandling();
      setMainDesktopPane((JDesktopPane) getCreatorOpt("desktop"));
    }

    public boolean isVisible() {
      return isTrue(getOpt(_host, "visible"));
    }

    public String moduleName() {
      return name;
    }

    public void setModuleName(String name) {
      String oldName = this.name;
      if (!eq(name, oldName)) {
        setField("name", name);
        possiblyInternalFrameTitle(vis(), name);
        vmBus_send("moduleNameChange", this, oldName, name);
      }
    }

    public void setModuleToolTip(String toolTip) {
      this.toolTip = toolTip;
    }

    public JComponent vis() {
      return (JComponent) getOpt(_host, "vis");
    }

    public <A extends AutoCloseable> A ownResource(A a) {
      if (a != null)
        _resources.add(a);
      return a;
    }

    public <A> A ownTimer(A timer) {
      if (timer instanceof AutoCloseable)
        ownResource((AutoCloseable) timer);
      ownTimer(timer, "cancelTimerOrInterruptThread");
      return timer;
    }

    public void ownTimer(Object timer, Object closerHelper) {
      timers.put(timer, closerHelper);
    }

    public void singleTimer(java.util.Timer timer) {
      stopAllTimers();
      ownTimer(timer);
    }

    public void stopAllTimers() {
      for (AutoCloseable resource : getAndClearList(_resources)) {
        if (verboseTimers)
          print("Releasing resource: " + resource);
        try {
          resource.close();
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      {
        final Map<Object, Object> __20 = getAndClearMap(timers);
        for (Object timer : keys(__20)) {
          Object closerHelper = __20.get(timer);
          if (verboseTimers)
            print("Stopping timer: " + closerHelper + " / " + timer);
          pcallFInRealOrMyMC(this, closerHelper, timer);
        }
      }
    }

    public boolean isDeleted() {
      return deleted;
    }

    public void cleanMeUp_dynModule() {
      deleted = true;
      stopAllTimers();
    }

    public void persistMe() {
      synchronized (changeCountSync) {
        ++changeCount;
      }
      pcallFAll(onChange);
      callOpt(_host, "_change");
      updateMe();
    }

    public void fireChangeWithoutPersisting() {
      pcallFAll(onChange);
    }

    public void fireTransientChange() {
      pcallFAll(onTransientChange);
    }

    public void _change() {
      persistMe();
    }

    public void change() {
      persistMe();
    }

    public void updateMe() {
      rstUpdate().trigger();
    }

    public void changeAndUpdate() {
      _change();
      updateMe();
    }

    public boolean setField(String name, Object value) {
      AutoCloseable __25 = enter();
      try {
        {
          try {
            if (eq(get(this, name), value))
              return false;
          } catch (Throwable __e) {
            _handleException(__e);
          }
          set(this, name, value);
        }
        pcallFAll(onFieldChange, name);
        if (persistOnChangedField && !isFalse(mapGet(_persistenceInfo, name)))
          _change();
        return true;
      } finally {
        _close(__25);
      }
    }

    public <A> A setFieldAndReturn(String name, A value) {
      setField(name, value);
      return value;
    }

    public boolean setFields(Object... params) {
      boolean change = false;
      for (int i = 0; i < l(params); i += 2) if (setField((String) params[i], params[i + 1]))
        change = true;
      return change;
    }

    public void start() {
      _hasPreviousBounds = dm_getBounds() != null;
      if (hasMethod_onTypes(this, "onTopInput", String.class))
        dm_onTopInput_q(new VF1<String>() {

          public void get(String s) {
            try {
              call(module(), "onTopInput", s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "call(module(), 'onTopInput, s)";
          }
        });
    }

    public void revisualize() {
      call(creator(), "revisualizeModule", _host);
    }

    public AutoCloseable enter() {
      AutoCloseable c = tempSetThreadLocal(dm_currentModule_value, new WeakReference(this));
      final Object realMC = getMainClass(this);
      if (printToModule())
        c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(_printToModuleInterceptor()));
      if (realMC != mc()) {
        if (printToModule())
          c = combineAutoCloseables(c, (AutoCloseable) callOpt(realMC, "tempInterceptPrintIfNotIntercepted", _printToModuleInterceptor()));
        else
          c = combineAutoCloseables(c, tempInterceptPrintIfNotIntercepted(new F1<String, Boolean>() {

            public Boolean get(String s) {
              try {
                {
                  call(realMC, "print", s);
                  return false;
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ret false with call(realMC, 'print, s);";
            }
          }));
        c = combineAutoCloseables(c, tempSetTL(realMC_tl(), realMC));
      }
      return c;
    }

    public F1<String, Boolean> _printToModuleInterceptor() {
      return new F1<String, Boolean>() {

        public Boolean get(String s) {
          try {
            if (print_preprocess != null)
              s = (String) callF(print_preprocess, s);
            s = fixNewLines(s);
            Appendable loc = _printLog;
            Appendable buf = print_log;
            int loc_max = print_log_max;
            if (buf != loc && buf != null) {
              print_append(buf, s, print_log_max);
              loc_max = local_log_max;
            }
            if (loc != null)
              print_append(loc, s, loc_max);
            System.out.print(s);
            return false;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (print_preprocess != null) s = (S) callF(print_preprocess, s);\r\n      s = ...";
        }
      };
    }

    public boolean printToModule() {
      return true;
    }

    public AutoCloseable enterAndLock() {
      return combineAutoCloseables(enter(), tempLock(lock));
    }

    public boolean setError(Throwable e) {
      setField("_error", persistableThrowable(e));
      return true;
    }

    public void clearError() {
      setField("_error", null);
    }

    public void onChange(Runnable r) {
      Lock __21 = lock;
      lock(__21);
      try {
        if (onChange == null)
          onChange = synchroList();
        addIfNotThere(onChange, r);
      } finally {
        unlock(__21);
      }
    }

    public void onFieldChange(VF1<String> r) {
      Lock __22 = lock;
      lock(__22);
      try {
        if (onFieldChange == null)
          onFieldChange = synchroList();
        addIfNotThere(onFieldChange, r);
      } finally {
        unlock(__22);
      }
    }

    public void onChangeAndNow(Runnable r) {
      onChange(r);
      callF(r);
    }

    public void onChangeAndNow(JComponent c, Object r) {
      onUpdateAndNow(c, r);
    }

    public <A extends JComponent> A onChange(A tc, Object r) {
      onUpdate(tc, r);
      return tc;
    }

    public void update() {
    }

    public void unvisualize() {
      zeroAllFieldsOfTypeExcept(this, Component.class, componentFieldsToKeep);
    }

    public Object menuItems() {
      return null;
    }

    public void enhanceFrame(Container f) {
      Object items = menuItems();
      if (items instanceof Object[])
        items = paramsToAbstractActions((Object[]) items);
      internalFramePopupMenuFromActions_threaded(f, (List) items);
      String switchableFields = (String) (callOpt(this, "switchableFields"));
      Set<String> set = asLinkedHashSet(splitAtSpace(switchableFields));
      Matches m = new Matches();
      for (String field : allFields(this)) if (startsWith(field, "_switchableField_", m))
        set.add(m.rest());
      for (String field : set) {
        Class type = fieldType(this, field);
        if (eq(boolean.class, type))
          dm_boolFieldMenuItem(f, field);
        else if (eq(int.class, type))
          dm_intFieldMenuItem(f, field);
        else if (eq(double.class, type))
          dm_doubleFieldMenuItem(f, field);
        else if (eq(String.class, type))
          dm_stringFieldMenuItem(f, field);
        else if (eq(File.class, type))
          dm_fileFieldMenuItem(f, field);
      }
    }

    public ReliableSingleThread rstUpdate() {
      if (rstUpdate == null)
        rstUpdate = dm_rst(this, new Runnable() {

          public void run() {
            try {
              AutoCloseable __26 = enter();
              try {
                update();
              } finally {
                _close(__26);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "temp enter(); update();";
          }
        });
      return rstUpdate;
    }

    public Q q() {
      AutoCloseable __27 = enter();
      try {
        if (q == null) {
          Lock __23 = lock;
          lock(__23);
          try {
            if (q == null)
              q = dm_startQ();
          } finally {
            unlock(__23);
          }
        }
        return q;
      } finally {
        _close(__27);
      }
    }

    public <A> A withUpdate(A a) {
      rstUpdate().trigger();
      return a;
    }

    public DynModule module() {
      return this;
    }

    public DynModule me() {
      return this;
    }

    public JComponent visualize() {
      return dm_noVisualisation();
    }

    public String programTitle_cache;

    public String programTitle() {
      if (programTitle_cache == null)
        programTitle_cache = snippetTitle(programID(mainClass(this)));
      return programTitle_cache;
    }

    public void doPersist(String field) {
      _persistenceInfo = mapMinus(_persistenceInfo, field);
    }

    public void dontPersist(String field) {
      _persistenceInfo = mapPlus(_persistenceInfo, "field", false);
    }

    public Appendable _actualPrintLog() {
      return printToModule() ? _printLog : print_log;
    }
  }

  static public void _registerTimer(java.util.Timer timer) {
    _registerTimer_original(timer);
    dm_currentModule().ownTimer(timer);
  }

  abstract static public class DynPrintLog extends DynModule {

    transient public JFastLogView_noWrap printLogView;

    transient public Lock updatePrintLog_lock = lock();

    transient public StringBuffer actualPrintLog;

    transient public int printLogUpdateInterval = 500;

    public JComponent visualize() {
      JComponent section = jSection("Log", jscroll_copyBackground(printLogView = jFastLogView_noWrap(getPrintLog())));
      componentPopupMenuItem(section, "Clear", new Runnable() {

        public void run() {
          try {
            AutoCloseable __34 = enter();
            try {
              dm_clearModulePrintLog();
            } finally {
              _close(__34);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();  dm_clearModulePrintLog();";
        }
      });
      return awtEvery(section, printLogUpdateInterval, new Runnable() {

        public void run() {
          try {
            updatePrintLog();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "updatePrintLog();";
        }
      });
    }

    public void updatePrintLog() {
      swing(new Runnable() {

        public void run() {
          try {
            Lock __31 = updatePrintLog_lock;
            lock(__31);
            try {
              JFastLogView_noWrap _view = printLogView;
              if (_view == null)
                return;
              if (_view.setText(getPrintLog())) {
                scrollAllTheWayDown(_view);
                awtLater(100, new Runnable() {

                  public void run() {
                    try {
                      scrollAllTheWayDown(_view);
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "scrollAllTheWayDown(_view)";
                  }
                });
              }
            } finally {
              unlock(__31);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// TODO: optimize\r\n    Lock __31 = updatePrintLog_lock; lock(__31); try {\r\n  ...";
        }
      });
    }

    public JFastLogView_noWrap myPrintLogComponent() {
      return printLogView;
    }

    public void enableWordWrap() {
    }

    public String getPrintLog() {
      if (actualPrintLog == null) {
        if (printToModule())
          actualPrintLog = _printLog;
        else
          actualPrintLog = liveLocalPrintLog_realMC(this);
      }
      return str(actualPrintLog);
    }
  }

  abstract static public class DynObjectTable<A> extends DynModule {

    public List<A> data = new ArrayList();

    transient public JTable table;

    transient public F1<A, Map> itemToMap;

    transient public VF1<A> defaultAction;

    transient public boolean debug, fieldsInOrder = true, withSearcher;

    transient public TableSearcher searcher;

    transient public List onListChanged;

    transient public Set<String> hideFields;

    transient public boolean useStruct = false;

    public void start() {
      try {
        super.start();
        itemToMap = new F1<A, Map>() {

          public Map get(A a) {
            try {
              if (a instanceof String)
                return litorderedmap("", (String) a);
              Map map = humanizeKeys(fieldsInOrder ? objectToMap_inOrder_withoutFields(a, hideFields) : objectToMap(a));
              if (!useStruct)
                map = mapValues(__70 -> strOrEmpty(__70), map);
              return map;
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (a instanceof S) ret litorderedmap(\"\" := (S) a);\r\n      Map map = humanize...";
          }
        };
        onChange(new Runnable() {

          public void run() {
            try {
              updateTable();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "updateTable();";
          }
        });
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void onListChanged(Runnable r) {
      if (r == null)
        return;
      onListChanged = addDyn_sync(onListChanged, r);
    }

    public void onListChangedAndNow(Runnable r) {
      if (r == null)
        return;
      onListChanged(r);
      r.run();
    }

    public void addCountToName() {
      onListChangedAndNow(new Runnable() {

        public void run() {
          try {
            addCountToNameNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "addCountToNameNow();";
        }
      });
    }

    public void addCountToNameNow() {
      AutoCloseable __38 = enter();
      try {
        setModuleName(programTitle() + " (" + count() + ")");
      } finally {
        _close(__38);
      }
    }

    public JComponent visualize() {
      List<Map> l = map(itemToMap, data);
      table = dataToTable_uneditable(sexyTable(), l);
      onDoubleClickOrEnter(table, new VF1<Integer>() {

        public void get(Integer row) {
          try {
            AutoCloseable __39 = enter();
            try {
              A a = _get(data, row);
              if (a != null)
                onDoubleClick(a);
            } finally {
              _close(__39);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "temp enter();\r\n      A a = _get(data, row);\r\n      if (a != null) onDoubleCli...";
        }
      });
      if (withSearcher)
        return (searcher = tableWithSearcher2(table)).panel;
      return table;
    }

    public void unvisualize() {
      super.unvisualize();
      searcher = null;
    }

    public void onDoubleClick(A line) {
      callF(defaultAction, line);
    }

    public void updateTable() {
      AutoCloseable __40 = enter();
      try {
        if (table != null) {
          swing(new Runnable() {

            public void run() {
              try {
                Point scrollPosition = enclosingViewPosition(table);
                if (debug)
                  print("Scroll position: " + scrollPosition);
                dataToTable_uneditable(table, map(itemToMap, data));
                setEnclosingViewPosition(table, scrollPosition);
                if (searcher != null)
                  searcher.rowIndices = null;
                if (debug)
                  print("dataToTable done, alerting " + n2(onListChanged, "listener"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "Point scrollPosition = enclosingViewPosition(table);\r\n      if (debug) print(...";
            }
          });
        }
        pcallFAll(onListChanged);
      } finally {
        _close(__40);
      }
    }

    public void dontPersist() {
      _persistenceInfo = mapPlus(_persistenceInfo, "data", false);
    }

    public void clear() {
      syncClear(data);
      fireDataChanged();
    }

    public void add(A a) {
      syncAdd(data, a);
      fireDataChanged();
    }

    public A addAndReturn(A a) {
      add(a);
      return a;
    }

    public void add(int idx, A a) {
      syncAdd(data, idx, a);
      fireDataChanged();
    }

    public void addAll(Collection<A> l) {
      if (empty(l))
        return;
      syncAddAll(data, l);
      fireDataChanged();
    }

    public void addAndScrollDown(A a) {
      add(a);
      scrollDown();
    }

    public void remove(A a) {
      syncRemove(data, a);
      fireDataChanged();
    }

    public void removeAll(List<A> a) {
      syncRemoveAll(data, a);
      fireDataChanged();
    }

    public void setList(Iterable<A> data) {
      setData(data);
    }

    public void removeSelected() {
      removeAll(allSelected());
    }

    public void setData(Collection<A> data) {
      setData((Iterable) data);
    }

    public void setData(Iterable<A> data) {
      setData(data, false);
    }

    public void setData(Iterable<A> data, boolean force) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              int[] selection = selectedTableRows_array(table);
              List<A> cloned = cloneList(data);
              if (setField("data", cloned) || force) {
                updateTable();
                dm_vmBus_send("listChanged", module(), cloned);
              }
              if (force)
                change();
              selectTableRows(table, selection);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "//int selection = selectedIndex();\r\n      int[] selection = selectedTableRows...";
          }
        });
      }
    }

    public int count() {
      return syncL(data);
    }

    public void setData_force(Collection<A> data) {
      setData(data, true);
    }

    public void fireDataChanged() {
      setData_force(data);
    }

    public int rowFromSearcher(int i) {
      return searcher == null || searcher.rowIndices == null ? i : or(get(searcher.rowIndices, i), -1);
    }

    public A selected() {
      return syncGet(data, rowFromSearcher(selectedTableRowInModel(table)));
    }

    public List<A> allSelected() {
      return syncListGetMulti(data, selectedIndices());
    }

    public int selectedIndex() {
      return selectedTableRow(table);
    }

    public List<Integer> selectedIndices() {
      return map(i -> rowFromSearcher(i), selectedTableRowsInModel(table));
    }

    public boolean selectItem(A a) {
      int i = indexOf(data, a);
      selectRow(table, i);
      return i >= 0;
    }

    public void doubleClickItem(A a) {
      if (selectItem(a))
        onDoubleClick(a);
    }

    public void popupMenuItem(String text, Object r) {
      tablePopupMenuItemsThreaded(table, text, _convertRunnable(r));
    }

    public void popupMenuItem_top(String text, Object r) {
      tablePopupMenuItemsThreaded_top(table, text, _convertRunnable(r));
    }

    public Object _convertRunnable(final Object r) {
      if (r == null || r instanceof Runnable)
        return r;
      return new VF1<Integer>() {

        public void get(Integer idx) {
          try {
            callF(r, syncGet(data, idx));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r, syncGet(data, idx))";
        }
      };
    }

    public JTable table() {
      return table;
    }

    public void hideFields(String... fields) {
      if (hideFields == null)
        hideFields = new HashSet();
      _addAll(hideFields, fields);
    }

    public A getRow(int row) {
      return get(data, row);
    }

    public void scrollDown() {
      scrollTableDownNow(table);
    }

    public List<A> getData() {
      return data;
    }

    public List<A> data() {
      return getData();
    }

    public List<A> list() {
      return getData();
    }

    public List<A> getList() {
      return getData();
    }

    public List<A> clonedList() {
      return cloneList(data);
    }

    public File quickBackup() {
      File f = programFile("backup-" + ymd_minus_hms_minus_millis() + ".gz");
      saveGZStructToFile(f, module());
      printFileInfo(f);
      return f;
    }
  }

  abstract static public class DynImageSurface extends DynModule {

    transient public ImageSurface imageSurface;

    transient public BufferedImage image;

    transient public String imageID;

    transient public boolean useUpdateHack, zoomToWindowOnSetImage;

    transient public Object onNewImage;

    static public boolean _switchableField_autoSaveToDisk = true;

    public boolean autoSaveToDisk = autoSaveToDiskDefault();

    public JComponent visualize() {
      return _visualize();
    }

    final public JComponent _visualize() {
      imageSurface = imageSurface(image);
      imageSurface.onNewImage = new Runnable() {

        public void run() {
          try {
            newImageFromSurface();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "newImageFromSurface();";
        }
      };
      return jscroll_center(imageSurface);
    }

    public void enableDoubleBuffering() {
      if (imageSurface != null)
        imageSurface.setDoubleBuffered(true);
    }

    public JComponent visualizeWithDoubleBuffering() {
      JComponent c = _visualize();
      enableDoubleBuffering();
      return c;
    }

    public Object _getReloadData() {
      return image;
    }

    public void _setReloadData(BufferedImage image) {
      this.image = image;
    }

    public void start() {
      try {
        super.start();
        if (autoSaveToDisk)
          autoLoadNow();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void autoLoadNow() {
      AutoCloseable __45 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          if (fileExists(f)) {
            print("Auto-loading " + f);
            setImage(loadImage2(f), true);
          }
        } catch (Throwable __e) {
          _handleException(__e);
        }
      } finally {
        _close(__45);
      }
    }

    public void autoSaveNow() {
      AutoCloseable __46 = enter();
      try {
        try {
          File f = autoSaveImageFile();
          savePNG(f, image);
          infoBox("Auto-saved " + renderFileInfo(f));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      } finally {
        _close(__46);
      }
    }

    public boolean autoSaveToDiskDefault() {
      return false;
    }

    public void enhanceFrame(Container f) {
      super.enhanceFrame(f);
      internalFramePopupMenuItem(f, "Auto-save now", runnableThread(new Runnable() {

        public void run() {
          try {
            autoSaveNow();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "autoSaveNow();";
        }
      }));
    }

    public void setImage(MakesBufferedImage image) {
      imageID = null;
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void newImageFromSurface() {
      setImage(imageSurface.getImage());
    }

    public void setImage(BufferedImage image) {
      setImage(image, false);
    }

    public void setImage(BufferedImage image, boolean loadingFromAutoSave) {
      this.image = image;
      imageID = null;
      if (imageSurface != null) {
        AutoCloseable __47 = tempSetField(imageSurface, "onNewImage", null);
        try {
          imageSurface.setImage(image);
          if (zoomToWindowOnSetImage)
            imageSurface.zoomToWindow();
          if (autoSaveToDisk && !loadingFromAutoSave)
            autoSaveNow();
        } finally {
          _close(__47);
        }
      }
      vmBus_send("newImage", this);
      pcallF(onNewImage, image);
    }

    public void setImage(String imageID) {
      if (sameSnippetID(this.imageID, imageID))
        return;
      setImage(loadImage2(imageID));
      this.imageID = imageID;
    }

    public File autoSaveImageFile() {
      String id = dm_moduleID(me());
      return javaxDataDir("Image Autosaves/" + id + "-autosave.png");
    }

    public BufferedImage getImage() {
      if (useUpdateHack) {
        ImageSurface is = imageSurface;
        if (is != null && is.getImage() != image)
          setImage(is.getImage());
      }
      return image;
    }

    public boolean hasImage() {
      return image != null;
    }

    public void setZoom(double zoom) {
      if (imageSurface != null)
        imageSurface.setZoom(zoom);
    }

    public Rect getSelection() {
      return imageSurface == null ? null : toRect(imageSurface.getSelection());
    }

    public void setSelection(Rect r) {
      if (imageSurface != null)
        imageSurface.setSelection(toRectangle(r));
    }

    public int imageWidth() {
      return imageSurface.getImage().getWidth();
    }

    public int imageHeight() {
      return imageSurface.getImage().getHeight();
    }
  }

  abstract static public class DynCalculatedList extends DynModule {

    transient public JList list;

    transient public List<String> results;

    transient public boolean calculateWhenHidden = false;

    public JComponent visualize() {
      return list = jlist(calc());
    }

    public void unvisualize() {
      list = null;
    }

    public void update() {
      AutoCloseable __52 = enter();
      try {
        if (list != null || calculateWhenHidden)
          fillListWithStrings(list, results = calc());
      } finally {
        _close(__52);
      }
    }

    abstract public List<String> calc();

    public void scrollDown() {
      scrollAllTheWayDown(list);
    }

    public String selected() {
      return selectedItem(list);
    }
  }

  static public Object creator() {
    return callOpt(assertNotNull("No real MC", realMC_tl()).get(), "creator");
  }

  static public String programID;

  static public String getProgramID() {
    Object mc = realMC_tl().get();
    if (mc != null)
      return getProgramID(mc);
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  static public String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  static public String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  static public Concepts db_mainConcepts() {
    return (Concepts) call(assertNotNull("No real MC", realMC()), "db_mainConcepts");
  }

  static public List<String> myInnerClasses_list = litlist(null, "Derefable", "Var", "SecretValue", "ImageSurface", "BWImage", "talkToThisVM_IO", "IFieldIndex", "Str", "SingleComponentPanel", "DynModule", "FixedRateTimer", "Rect", "Pt", "AbstractLayoutManager", "IterableIterator", "betterCIComparator_C", "RemoteDB", "MakesBufferedImage", "SynchronizedArrayList", "ScannedBot", "Concepts", "RC", "XRef", "CloseableIterableIterator", "PNGFile", "getOpt_Map", "IFieldsToList", "structure_Data", "IVar", "Matches", "HCRUD_Concepts", "TableWithTooltips", "DynCalculatedList", "Surface", "Q", "OrError", "LongRange", "CriticalAction", "IResourceLoader", "MultiSet", "DynObjectTable", "DialogIO", "HCRUD_Data", "SimpleCRUD", "SynchronizedArrayList_Base", "IntRange", "IConceptCounter", "BetterLabel", "componentPopupMenu_Adapter", "MRUCache", "AlphanumComparator", "PersistableThrowable", "talkToSubBot_IO", "Scored", "RGBImage", "SmartTimerTask", "HasIndex", "Responder", "VF2", "TableSearcher", "JSection", "ValueConverterForField", "TokCondition", "HTML", "RightAlignedLine", "GlobalID", "HCRUD", "listPopupMenu_Maker", "findCodeTokens_Matcher", "ReliableSingleThread", "JFastLogView_noWrap", "ImageSurfaceSelector", "Concept", "IBWImage", "AutoComboBox", "ProgramScan", "F0", "HAbstractRenderable", "Snippet", "F1", "DynImageSurface", "F2", "RGB", "RandomAccessAbstractList", "Flag", "unstructure_Receiver", "ContentsIndexedList", "IF0", "BaseXRef", "DefaultValueConverterForField", "IContentsIndexedList2", "IF2", "Producer", "IF1", "IF3", "tablePopupMenu_Maker", "IVF1", "IVF2", "Cache", "_MethodCache", "talkTo_IO", "structure_ClassInfo", "LiveValue", "IContentsIndexedList", "LetterLayout", "DialogHandler", "Lowest", "proxy_InvocationHandler", "HTMLPaginator", "Pair", "DynPrintLog", "UniqueString", "TransferableImage", "IConceptIndex", "Android3", "DynamicMethods");

  static public List<String> myInnerClasses() {
    return myInnerClasses_list;
  }

  static public DynModule dm_currentModule() {
    return (DynModule) dm_current_generic();
  }

  static public void cancelTimerOrInterruptThread(Object timer) {
    if (timer instanceof Thread && !(timer instanceof AutoCloseable))
      interruptThread((Thread) timer);
    else
      cancelTimer(timer);
  }

  static public RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public RuntimeException rethrow(String msg, Throwable t) {
    throw new RuntimeException(msg, t);
  }

  static public boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  static public boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  static public void _handleError(Error e) {
    call(javax(), "_handleError", e);
  }

  static public boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        print("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) {
      Object arg = args[i];
      if (!(arg == null ? !types[i].isPrimitive() : isInstanceX(types[i], arg))) {
        if (debug)
          print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
        return false;
      }
    }
    return true;
  }

  static public RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  static public RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  static public RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  static public RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  static public RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  static public <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  static public boolean endsWithLetterOrDigit(String s) {
    return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length() - 1));
  }

  static public Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  static public int isAndroid_flag;

  static public boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  static public Boolean isHeadless_cache;

  static public boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (isAndroid())
      return isHeadless_cache = true;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static <A> String join(String glue, Iterable<A> strings) {
    if (strings == null)
      return "";
    if (strings instanceof Collection) {
      if (((Collection) strings).size() == 1)
        return str(first(((Collection) strings)));
    }
    StringBuilder buf = new StringBuilder();
    Iterator<A> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  static public <A> String join(Iterable<A> strings) {
    return join("", strings);
  }

  static public <A> String join(Iterable<A> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  static public String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  static public String joinWithSpace(Iterable c) {
    return join(" ", c);
  }

  static public String joinWithSpace(String... c) {
    return join(" ", c);
  }

  static public <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  static public int javaTok_n, javaTok_elements;

  static public boolean javaTok_opt = false;

  static public List<String> javaTok(String s) {
    ++javaTok_n;
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public List<String> javaTok(List<String> tok) {
    return javaTokWithExisting(join(tok), tok);
  }

  static public void print_append(Appendable buf, String s, int max) {
    try {
      synchronized (buf) {
        buf.append(s);
        if (buf instanceof StringBuffer)
          rotateStringBuffer(((StringBuffer) buf), max);
        else if (buf instanceof StringBuilder)
          rotateStringBuilder(((StringBuilder) buf), max);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  static public Object get(Object o, String field) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        makeAccessible(f);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  static public Object get_raw(String field, Object o) {
    return get_raw(o, field);
  }

  static public Object get_raw(Object o, String field) {
    try {
      if (o == null)
        return null;
      Field f = get_findField(o.getClass(), field);
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      makeAccessible(f);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Object get(String field, Object o) {
    return get(o, field);
  }

  static public Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt(String field, Object o) {
    return getOpt_cached(o, field);
  }

  static public Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(o);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      makeAccessible(f);
      return f.get(null);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public <A> A set(A o, String field, Object value) {
    if (o == null)
      return null;
    if (o instanceof Class)
      set((Class) o, field, value);
    else
      try {
        Field f = set_findField(o.getClass(), field);
        makeAccessible(f);
        smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    return o;
  }

  static public void set(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = set_findStaticField(c, field);
      makeAccessible(f);
      smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field set_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  static public Field set_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  static public Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  static public void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      if (getOpt_cache == null)
        map = getOpt_makeCache(c);
      else
        synchronized (getOpt_cache) {
          map = getOpt_cache.get(c);
          if (map == null)
            map = getOpt_makeCache(c);
        }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null) {
        smartSet(f, o, value);
        return;
      }
      if (o instanceof DynamicObject)
        setDyn(((DynamicObject) o), field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null) {
          makeAccessible(f);
          smartSet(f, o, value);
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null) {
        makeAccessible(f);
        smartSet(f, null, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();

  static public <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callF(VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMCWithVarArgs((String) f, args);
      if (f instanceof Runnable) {
        ((Runnable) f).run();
        return null;
      }
      if (f == null)
        return null;
      Class c = f.getClass();
      ArrayList<Method> methods;
      synchronized (callF_cache) {
        methods = callF_cache.get(c);
        if (methods == null)
          methods = callF_makeCache(c);
      }
      int n = l(methods);
      if (n == 0) {
        throw fail("No get method in " + getClassName(c));
      }
      if (n == 1)
        return invokeMethod(methods.get(0), f, args);
      for (int i = 0; i < n; i++) {
        Method m = methods.get(i);
        if (call_checkArgs(m, args, false))
          return invokeMethod(m, f, args);
      }
      throw fail("No matching get method in " + getClassName(c));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  static public Object call(Object o) {
    return callF(o);
  }

  static public Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  static public Object call(Object o, String method, Object... args) {
    return call_withVarargs(o, method, args);
  }

  static public Object callOpt(Object o) {
    return callF(o);
  }

  static public <A> A callOpt(Object o, String method, Object... args) {
    return (A) callOpt_withVarargs(o, method, args);
  }

  static public String fixNewLines(String s) {
    int i = indexOf(s, '\r');
    if (i < 0)
      return s;
    int l = s.length();
    StringBuilder out = new StringBuilder(l);
    out.append(s, 0, i);
    for (; i < l; i++) {
      char c = s.charAt(i);
      if (c != '\r')
        out.append(c);
      else {
        out.append('\n');
        if (i + 1 < l && s.charAt(i + 1) == '\n')
          ++i;
      }
    }
    return out.toString();
  }

  static public Map<String, UniqueString> uniqueString_map = weakHashMap();

  static public UniqueString uniqueString(String s) {
    if (s == null)
      return null;
    synchronized (uniqueString_map) {
      UniqueString us = uniqueString_map.get(s);
      if (us == null)
        uniqueString_map.put(s, us = new UniqueString(s, true));
      return us;
    }
  }

  static public UniqueString uniqueString(CharSequence s) {
    return s == null ? null : uniqueString(str(s));
  }

  static public FixedRateTimer doEvery(long delay, final Object r) {
    return doEvery(delay, delay, r);
  }

  static public FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
    return vmBus_timerStarted(timer);
  }

  static public FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
  }

  static public FixedRateTimer doEvery(double delaySeconds, final Object r) {
    return doEvery(toMS(delaySeconds), r);
  }

  static public java.util.Timer doLater(long delay, final Object r) {
    ping();
    final java.util.Timer timer = new java.util.Timer();
    timer.schedule(timerTask(r, timer), delay);
    return vmBus_timerStarted(timer);
  }

  static public java.util.Timer doLater(double delaySeconds, final Object r) {
    return doLater(toMS(delaySeconds), r);
  }

  static public boolean hasBot(String searchPattern) {
    try {
      DialogIO io = findBot(searchPattern);
      if (io != null) {
        io.close();
        return true;
      } else
        return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JLabel jlabel(final String text) {
    return swingConstruct(BetterLabel.class, text);
  }

  static public JLabel jlabel() {
    return jlabel(" ");
  }

  static public JTextArea newTypeWriterTextArea() {
    return newTypeWriterTextArea("");
  }

  static public JTextArea newTypeWriterTextArea(String text) {
    return setFont(jTextArea(text), typeWriterFont());
  }

  static public String struct(Object o) {
    return structure(o);
  }

  static public String struct(Object o, structure_Data data) {
    return structure(o, data);
  }

  static public String sfu(Object o) {
    return structureForUser(o);
  }

  static public String loadPageSilentlyWithTimeout(double timeoutSeconds, String url) {
    return loadPageSilentlyWithTimeout(url, toMS_int(timeoutSeconds));
  }

  static public String loadPageSilentlyWithTimeout(int timeout, String url) {
    return loadPageSilentlyWithTimeout(url, timeout);
  }

  static public String loadPageSilentlyWithTimeout(String url, int timeout) {
    try {
      url = loadPage_preprocess(url);
      URL _url = new URL(url);
      return loadPage(setURLConnectionTimeouts(_url.openConnection(), timeout), _url);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean loadPageWithUserAgent_verbose = false;

  static public String loadPageWithUserAgent(String url, String userAgent) {
    try {
      URL tURL = new URL(url);
      URLConnection conn = tURL.openConnection();
      conn.setRequestProperty("User-Agent", userAgent);
      loadPage_anonymous = true;
      if (loadPageWithUserAgent_verbose)
        print("Loading as " + userAgent + ": " + hideCredentials(url));
      return loadPage(conn, tURL);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void db() {
    conceptsAndBot();
  }

  static public void db(Integer autoSaveInterval) {
    conceptsAndBot(autoSaveInterval);
  }

  static public <A> A cget(Object c, String field) {
    Object o = getOpt(c, field);
    if (o instanceof Concept.Ref)
      return (A) ((Concept.Ref) o).get();
    return (A) o;
  }

  static public <A> A cget(String field, Object c) {
    return cget(c, field);
  }

  static public int cset(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_csetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cset(Iterable<? extends Concept> l, Object... values) {
    int changes = 0;
    for (Concept c : unnull(l)) changes += cset(c, values);
    return changes;
  }

  static volatile public StringBuffer local_log = new StringBuffer();

  static volatile public Appendable print_log = local_log;

  static volatile public int print_log_max = 1024 * 1024;

  static volatile public int local_log_max = 100 * 1024;

  static public boolean print_silent = false;

  static public Object print_byThread_lock = new Object();

  static volatile public ThreadLocal<Object> print_byThread;

  static volatile public Object print_allThreads;

  static volatile public Object print_preprocess;

  static public void print() {
    print("");
  }

  static public <A> A print(String s, A o) {
    print((endsWithLetterOrDigit(s) ? s + ": " : s) + o);
    return o;
  }

  static public <A> A print(A o) {
    ping_okInCleanUp();
    if (print_silent)
      return o;
    String s = o + "\n";
    print_noNewLine(s);
    return o;
  }

  static public void print_noNewLine(String s) {
    Object f = getThreadLocal(print_byThread_dontCreate());
    if (f == null)
      f = print_allThreads;
    if (f != null)
      if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
        return;
    print_raw(s);
  }

  static public void print_raw(String s) {
    if (print_preprocess != null)
      s = (String) callF(print_preprocess, s);
    s = fixNewLines(s);
    Appendable loc = local_log;
    Appendable buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
    vmBus_send("printed", mc(), s);
  }

  static public void print_autoRotate() {
  }

  static public ThreadLocal<Object> print_byThread() {
    synchronized (print_byThread_lock) {
      if (print_byThread == null)
        print_byThread = new ThreadLocal();
    }
    return print_byThread;
  }

  static public ThreadLocal<Object> print_byThread_dontCreate() {
    return print_byThread;
  }

  static public List<VF1<Map>> _threadInfo_makers = synchroList();

  static public Object _threadInfo() {
    if (empty(_threadInfo_makers))
      return null;
    HashMap map = new HashMap();
    pcallFAll(_threadInfo_makers, map);
    return map;
  }

  static public List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

  static public void _threadInheritInfo(Object info) {
    if (info == null)
      return;
    pcallFAll(_threadInheritInfo_retrievers, (Map) info);
  }

  static public void _threadInfo_addMakerAndRetriever(VF1<Map> maker, VF1<Map> retriever) {
    _threadInfo_makers.add(maker);
    _threadInheritInfo_retrievers.add(retriever);
  }

  static public boolean match(String pat, String s) {
    return match3(pat, s);
  }

  static public boolean match(String pat, String s, Matches matches) {
    return match3(pat, s, matches);
  }

  static public boolean match(String pat, List<String> toks, Matches matches) {
    return match3(pat, toks, matches);
  }

  static public Field getField(Object o, String field) {
    if (o == null)
      return null;
    return setOpt_findField(_getClass(o), field);
  }

  static public Class fieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getType();
  }

  static public String format3(String pat, Object... args) {
    if (args.length == 0)
      return pat;
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2) if (tok.get(i).equals("*"))
      tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }

  static public String format3_formatArg(Object arg) {
    if (arg == null)
      return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long)
      return String.valueOf(arg);
    return quote(structure(arg));
  }

  static public Set vm_generalIdentityHashSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = syncIdentityHashSet());
      return set;
    }
  }

  static public Map vm_generalHashMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map m = (Map) (vm_generalMap_get(name));
      if (m == null)
        vm_generalMap_put(name, m = syncHashMap());
      return m;
    }
  }

  static public Map vm_generalWeakSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = newWeakMap());
      return map;
    }
  }

  static public <A extends JComponent> A bindToComponent(final A component, final Runnable onShow, final Runnable onUnShow) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final Var<Boolean> flag = new Var<>(false);
            component.addAncestorListener(new AncestorListener() {

              public void ancestorAdded(AncestorEvent event) {
                if (flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(true);
                pcallF(onShow);
              }

              public void ancestorRemoved(AncestorEvent event) {
                if (!flag.get())
                  print("Warning: bindToComponent logic failure");
                flag.set(false);
                pcallF(onUnShow);
              }

              public void ancestorMoved(AncestorEvent event) {
              }
            });
            if (component.isShowing()) {
              flag.set(true);
              pcallF(onShow);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Var<Boolean> flag = new(false);\r\n    component.addAncestorListener(new ...";
        }
      });
    }
    return component;
  }

  static public <A extends JComponent> A bindToComponent(A component, Runnable onShow) {
    return bindToComponent(component, onShow, null);
  }

  static public int loadPage_defaultTimeout = 60000;

  static public ThreadLocal<String> loadPage_charset = new ThreadLocal();

  static public boolean loadPage_allowGzip = true, loadPage_debug;

  static public boolean loadPage_anonymous = false;

  static public int loadPage_verboseness = 100000;

  static public int loadPage_retries = 1;

  static public ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  static volatile public int loadPage_forcedTimeout;

  static public ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal();

  static public ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

  static public ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      if (!networkAllowanceTest(str(url)))
        throw fail("Not allowed: " + url);
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPageThroughProxy_enabled) {
          print("Trying proxy because of: " + e);
          try {
            return loadPageThroughProxy(str(url));
          } catch (Throwable e2) {
            print("  " + exceptionToStringShort(e2));
          }
        } else if (loadPage_debug)
          print(exceptionToStringShort(e));
        if (tries < loadPage_retries - 1)
          sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage_preprocess(String url) {
    if (url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  static public String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        printWithTime("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadPage(URL url) {
    return loadPage(url.toExternalForm());
  }

  static public String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  static public String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
    Long limit = optPar(loadPage_sizeLimit);
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
        for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      } catch (Throwable e) {
      }
    vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
    loadPage_responseHeaders.set(con.getHeaderFields());
    InputStream in = null;
    try {
      in = urlConnection_getInputStream(con);
      if (loadPage_debug)
        print("Put stream in map: " + currentThread());
      String contentType = con.getContentType();
      if (contentType == null) {
        throw new IOException("Page could not be read: " + hideCredentials(url));
      }
      String charset = loadPage_charset == null ? null : loadPage_charset.get();
      if (charset == null)
        charset = loadPage_guessCharset(contentType);
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = newGZIPInputStream(in);
      }
      Reader r;
      try {
        r = new InputStreamReader(in, unquote(charset));
      } catch (UnsupportedEncodingException e) {
        print(toHex(utf8(charset)));
        throw e;
      }
      boolean silent = isTrue(loadPage_silent.get());
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (limit == null || n < limit) {
        ping();
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if (!silent && (n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      if (loadPage_debug)
        print("loadPage done");
      vm_generalSubMap("URLConnection per thread").remove(currentThread());
      if (in != null)
        in.close();
    }
  }

  static public String loadPage_guessCharset(String contentType) {
    Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    return or(match, "UTF-8");
  }

  static public URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    int timeout = toInt(loadPage_forcedTimeout_byThread.get());
    if (timeout == 0)
      timeout = loadPage_forcedTimeout;
    if (timeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    else
      setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
    return con;
  }

  static public String loadPage_utf8(URL url) {
    return loadPage_utf8(url.toString());
  }

  static public String loadPage_utf8(String url) {
    AutoCloseable __1 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(url);
    } finally {
      _close(__1);
    }
  }

  static public String loadPage_utf8(URLConnection con, URL url, boolean addHeaders) throws IOException {
    AutoCloseable __2 = tempSetTL(loadPage_charset, "UTF-8");
    try {
      return loadPage(con, url, addHeaders);
    } finally {
      _close(__2);
    }
  }

  static public boolean preferCached = false;

  static public boolean loadSnippet_debug = false;

  static public ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();

  static public ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();

  static public int loadSnippet_timeout = 30000;

  static public String loadSnippet(Snippet s) {
    return loadSnippet(s.id);
  }

  static public String loadSnippet(String snippetID) {
    try {
      if (snippetID == null)
        return null;
      return loadSnippet(parseSnippetID(snippetID), preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(String snippetID, boolean preferCached) throws IOException {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  }

  static public IF1<Long, String> loadSnippet;

  static public String loadSnippet(long snippetID) {
    return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID);
  }

  final static public String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) {
    return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID);
  }

  static public String loadSnippet_base(long snippetID) {
    try {
      return loadSnippet(snippetID, preferCached);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String loadSnippet(long snippetID, boolean preferCached) throws IOException {
    String text;
    if (isLocalSnippetID(snippetID))
      return loadLocalSnippet(snippetID);
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.loadSnippet(fsI(snippetID));
    initSnippetCache();
    text = DiskSnippetCache_get(snippetID);
    if (preferCached && text != null)
      return text;
    try {
      if (loadSnippet_debug && text != null)
        System.err.println("md5: " + md5(text));
      String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
      if (nempty(text))
        url += "&md5=" + md5(text);
      if (!isTrue(loadSnippet_publicOnly.get()))
        url += standardCredentials();
      String text2 = loadSnippet_loadFromServer(url);
      boolean same = eq(text2, "==*#*==");
      if (loadSnippet_debug)
        print("loadSnippet: same=" + same);
      if (!same)
        text = text2;
    } catch (RuntimeException e) {
      e.printStackTrace();
      throw new IOException("Snippet #" + snippetID + " not found or not public");
    }
    try {
      initSnippetCache();
      DiskSnippetCache_put(snippetID, text);
    } catch (IOException e) {
      System.err.println("Minor warning: Couldn't save snippet to cache (" + DiskSnippetCache_getDir() + ")");
    }
    return text;
  }

  static public File DiskSnippetCache_dir;

  public static void initDiskSnippetCache(File dir) {
    DiskSnippetCache_dir = dir;
    dir.mkdirs();
  }

  public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
    return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
  }

  static public File DiskSnippetCache_getFile(long snippetID) {
    return new File(DiskSnippetCache_dir, "" + snippetID);
  }

  public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
    saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
  }

  public static File DiskSnippetCache_getDir() {
    return DiskSnippetCache_dir;
  }

  public static void initSnippetCache() {
    if (DiskSnippetCache_dir == null)
      initDiskSnippetCache(getGlobalCache());
  }

  static public String loadSnippet_loadFromServer(String url) {
    Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
    try {
      return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
    } finally {
      loadPage_forcedTimeout_byThread.set(oldTimeout);
    }
  }

  static public String loadSnippetQuietly(Snippet s) {
    return loadSnippetQuietly(s.id);
  }

  static public String loadSnippetQuietly(String snippetID) {
    loadSnippet_silent.set(true);
    try {
      return loadSnippet(snippetID);
    } finally {
      loadSnippet_silent.set(null);
    }
  }

  static public String sendToLocalBot(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        print(bot + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(bot + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBot(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        print(port + "> " + shorten(text, 80));
        channel.sendLine(text);
        String s = channel.readLine();
        print(port + "< " + shorten(s, 80));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotOpt(String bot, String text, Object... args) {
    if (bot == null)
      return null;
    text = format(text, args);
    DialogIO channel = findBot(bot);
    try {
      if (channel == null) {
        print(quote(bot) + " not found, skipping send: " + quote(text));
        return null;
      }
      try {
        channel.readLine();
        print(shorten(bot + "> " + text, 200));
        channel.sendLine(text);
        String s = channel.readLine();
        print(shorten(bot + "< " + s, 200));
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(String bot, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = newFindBot2(bot);
    try {
      if (channel == null)
        throw fail(quote(bot) + " not found");
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public String sendToLocalBotQuietly(int port, String text, Object... args) {
    text = format3(text, args);
    DialogIO channel = talkTo(port);
    try {
      try {
        channel.readLine();
        channel.sendLine(text);
        String s = channel.readLine();
        return s;
      } catch (Throwable e) {
        e.printStackTrace();
        return null;
      }
    } finally {
      _close(channel);
    }
  }

  static public JTable sexyTableWithoutDrag() {
    final JTable table = tableWithToolTips();
    tablePopupMenu(table, sexyTableWithoutDrag_popupMenuMaker(table));
    table.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_FOCUSED).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    table.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    ((InputMap) UIManager.get("Table.ancestorInputMap")).put(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, InputEvent.CTRL_MASK), "none");
    return table;
  }

  static public VF2<JPopupMenu, Integer> sexyTableWithoutDrag_popupMenuMaker(JTable t) {
    final WeakReference<JTable> ref = weakRef(t);
    return new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, Integer row) {
        try {
          final JTable table = ref.get();
          final String item = first(getTableLine(table, row));
          MouseEvent e = tablePopupMenu_mouseEvent.get();
          final int col = table.columnAtPoint(e.getPoint());
          final Object value = table.getModel().getValueAt(row, col);
          if (value instanceof ImageIcon) {
            addMenuItem(menu, "Copy image to clipboard", new Runnable() {

              public void run() {
                try {
                  copyImageToClipboard(((ImageIcon) value).getImage());
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyImageToClipboard(((ImageIcon) value).getImage());";
              }
            });
          } else {
            final String text = str(value);
            addMenuItem(menu, "Copy text to clipboard", new Runnable() {

              public void run() {
                try {
                  copyTextToClipboard(text);
                  print("Copied text to clipboard: " + quote(text));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "copyTextToClipboard(text);\r\n        print(\"Copied text to clipboard: \" + quot...";
              }
            });
          }
          addMenuItem(menu, "Set row height...", new Runnable() {

            public void run() {
              try {
                final JTextField tf = jTextField(table.getRowHeight());
                showTitledForm("Set row height", "Pixels", tf, new Runnable() {

                  public void run() {
                    try {
                      table.setRowHeight(parseInt(trim(tf.getText())));
                    } catch (Exception __e) {
                      throw rethrow(__e);
                    }
                  }

                  public String toString() {
                    return "table.setRowHeight(parseInt(trim(tf.getText())))";
                  }
                });
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "final JTextField tf = jTextField(table.getRowHeight());\r\n      showTitledForm...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTable table = ref!;\r\n    final S item = first(getTableLine(table, row)...";
      }
    };
  }

  static public class tablePopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JTable, tablePopupMenu_Maker> tablePopupMenu_map = newWeakHashMap();

  static public ThreadLocal<MouseEvent> tablePopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> tablePopupMenu_first = new ThreadLocal();

  static public void tablePopupMenu(final JTable table, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(tablePopupMenu_first));
    {
      swing(new Runnable() {

        public void run() {
          try {
            tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);
            if (maker == null) {
              tablePopupMenu_map.put(table, maker = new tablePopupMenu_Maker());
              final tablePopupMenu_Maker _maker = maker;
              table.addMouseListener(new MouseAdapter() {

                public void mousePressed(MouseEvent e) {
                  displayMenu(e);
                }

                public void mouseReleased(MouseEvent e) {
                  displayMenu(e);
                }

                public void displayMenu(MouseEvent e) {
                  if (!e.isPopupTrigger())
                    return;
                  JPopupMenu menu = new JPopupMenu();
                  int row = table.rowAtPoint(e.getPoint());
                  if (table.getSelectedRowCount() < 2)
                    table.setRowSelectionInterval(row, row);
                  int modelRow = convertTableRowToModel(table, row);
                  int emptyCount = menu.getComponentCount();
                  tablePopupMenu_mouseEvent.set(e);
                  for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, modelRow);
                  vmBus_send("showingPopupMenu", table, menu);
                  if (menu.getComponentCount() != emptyCount)
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
              });
            }
            if (first)
              maker.menuMakers.add(0, menuMaker);
            else
              maker.menuMakers.add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tablePopupMenu_Maker maker = tablePopupMenu_map.get(table);\r\n    if (maker ==...";
        }
      });
    }
  }

  static public void tablePopupMenuFirst(JTable table, final Object menuMaker) {
    tablePopupMenu_first.set(true);
    tablePopupMenu(table, menuMaker);
  }

  static public ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent;

  static public void componentPopupMenu_init() {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (componentPopupMenu_mouseEvent == null)
              componentPopupMenu_mouseEvent = (ThreadLocal<MouseEvent>) vm_generalMap_get("mouseEvent");
            if (componentPopupMenu_mouseEvent == null)
              vm_generalMap_put("componentPopupMenu_mouseEvent", componentPopupMenu_mouseEvent = new ThreadLocal());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (componentPopupMenu_mouseEvent == null)\r\n      componentPopupMenu_mouseEve...";
        }
      });
    }
  }

  static public void componentPopupMenu(final JComponent component, final Object menuMaker) {
    if (component == null || menuMaker == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) _get(adapter, "maker")).add(menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public Object componentPopupMenu_initForComponent(final JComponent component) {
    return component == null ? null : swing(new F0<Object>() {

      public Object get() {
        try {
          componentPopupMenu_init();
          Object adapter = findComponentPopupMenuListener_gen(component);
          if (adapter == null) {
            componentPopupMenu_Adapter a = new componentPopupMenu_Adapter();
            component.addMouseListener(a);
            adapter = a;
          }
          return adapter;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "componentPopupMenu_init();\r\n    O adapter = findComponentPopupMenuListener_ge...";
      }
    });
  }

  static public class componentPopupMenu_Adapter extends MouseAdapter {

    public List maker = new ArrayList();

    public boolean internalFrameLeftButtonMagic = false;

    public Point pressedAt;

    public void mousePressed(MouseEvent e) {
      displayMenu(e);
      pressedAt = internalFrameLeftButtonMagic && e.getClickCount() == 1 && internalFrameActive(e.getComponent()) ? e.getLocationOnScreen() : null;
    }

    public void mouseReleased(MouseEvent e) {
      if (internalFrameLeftButtonMagic && eq(pressedAt, e.getLocationOnScreen()))
        displayMenu2(e);
      else
        displayMenu(e);
    }

    public void displayMenu(MouseEvent e) {
      if (e.getSource() instanceof JInternalFrame)
        return;
      if (e.isPopupTrigger())
        displayMenu2(e);
    }

    public void displayMenu2(MouseEvent e) {
      JPopupMenu menu = new JPopupMenu();
      int emptyCount = menu.getComponentCount();
      AutoCloseable __1 = tempSetTL(componentPopupMenu_mouseEvent, e);
      try {
        for (Object menuMaker : maker) pcallF(menuMaker, menu);
        vmBus_send("showingPopupMenu", e.getComponent(), menu);
        if (menu.getComponentCount() != emptyCount)
          menu.show(e.getComponent(), e.getX(), e.getY());
      } finally {
        _close(__1);
      }
    }
  }

  static public void componentPopupMenu_top(final JComponent component, final VF1<JPopupMenu> menuMaker) {
    if (component != null && menuMaker != null) {
      swing(new Runnable() {

        public void run() {
          try {
            Object adapter = componentPopupMenu_initForComponent(component);
            ((List) get(adapter, "maker")).add(0, menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object adapter = componentPopupMenu_initForComponent(component);\r\n    ((List)...";
        }
      });
    }
  }

  static public MouseEvent componentPopupMenu_getEvent() {
    return componentPopupMenu_mouseEvent.get();
  }

  static public InheritableThreadLocal<WeakReference> dm_currentModule_value = new InheritableThreadLocal();

  static public Object dm_current_generic() {
    return getWeakRef(dm_currentModule_value.get());
  }

  static public void cleanMeUp_dm_current_generic() {
    dm_currentModule_value = new InheritableThreadLocal();
  }

  static public Object dm_current_mandatory_generic() {
    return assertNotNull("No module set", dm_current_generic());
  }

  static public Object withDBLock(Object r) {
    Lock __0 = db_mainConcepts().lock;
    lock(__0);
    try {
      return callF(r);
    } finally {
      unlock(__0);
    }
  }

  static public <A> A withDBLock(F0<A> r) {
    return (A) withDBLock((Object) r);
  }

  static public Object withDBLock(Concepts concepts, Object r) {
    Lock __1 = concepts.lock;
    lock(__1);
    try {
      return callF(r);
    } finally {
      unlock(__1);
    }
  }

  static public <A> A withDBLock(Concepts concepts, F0<A> r) {
    return (A) withDBLock(concepts, (Object) r);
  }

  static public <A> A withDBLock(Concept concept, IF0<A> r) {
    return (A) withDBLock(concept._concepts, r);
  }

  static public void makePopupMenuConditional(final JComponent c, final F0<Boolean> condition) {
    if (c != null && condition != null) {
      swing(new Runnable() {

        public void run() {
          try {
            final componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListeners(), componentPopupMenu_Adapter.class);
            c.removeMouseListener(adapter);
            c.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                if (!callF(condition))
                  adapter.mousePressed(e);
              }

              public void mouseReleased(MouseEvent e) {
                if (!callF(condition))
                  adapter.mouseReleased(e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final componentPopupMenu_Adapter adapter = firstInstanceOf(c.getMouseListener...";
        }
      });
    }
  }

  static public boolean dynamicObjectIsLoading() {
    return isTrue(getThreadLocal(DynamicObject_loading));
  }

  static public Object interceptPrintInThisThread(Object f) {
    Object old = print_byThread().get();
    print_byThread().set(f);
    return old;
  }

  static public void rowSorter_setComparators(JTable table, final Object... params) {
    setTableModel_fixSorter.put(table, new VF2<JTable, RowSorter>() {

      public void get(JTable table, RowSorter sorter) {
        try {
          if (sorter instanceof TableRowSorter) {
            for (Pair<Integer, Comparator> p : (List<Pair<Integer, Comparator>>) (List) paramsToPairs(params)) ((TableRowSorter) sorter).setComparator(p.a, p.b);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "//print(\"Fixing table sorter\");\r\n    if (sorter cast TableRowSorter) {\r\n     ...";
      }
    });
  }

  static public boolean directNohupJava_loggingOn = true;

  static public File directNohupJavax(String javaxargs) {
    return directNohupJavax(javaxargs, javaxDefaultVMArgs());
  }

  static public File directNohupJavax(final String _javaxargs, final String _vmArgs) {
    if (directNohupJava_loggingOn)
      appendToLocalMechLog("nohupJavax Log", sfu(dropSecondIfEmpty(str(parseFirstInt(_javaxargs)), _vmArgs)));
    String javaxargs = _javaxargs.trim();
    if (javaxargs.startsWith("#"))
      javaxargs = javaxargs.substring(1);
    String snippetID = javaTok(javaxargs).get(1);
    int idx = javaxargs.indexOf(' ');
    String args = idx < 0 ? "" : javaxargs.substring(idx + 1).trim();
    String vmArgs = trim(_vmArgs);
    if (empty(vmArgs) && usePreSpunVMs()) {
      String line;
      if (args.length() != 0)
        line = format3("please start program * with arguments *", snippetID, args);
      else
        line = format3("please start program *", snippetID);
      String answer = sendToLocalBotOpt("A pre-spun VM.", line);
      if (match3("ok", answer)) {
        print("OK, used pre-spun VM.");
        return null;
      }
      if (answer != null)
        print("> " + answer);
      print("Using standard nohup.");
    }
    return classicNohupJavax(javaxargs, vmArgs);
  }

  static public boolean swic(String a, String b) {
    return startsWithIgnoreCase(a, b);
  }

  static public boolean swic(String a, String b, Matches m) {
    if (!swic(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  static public <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
    if (c == null)
      return null;
    {
      swing(new Runnable() {

        public void run() {
          try {
            String s = nullIfEmpty(str(toolTip));
            if (neq(s, c.getToolTipText()))
              c.setToolTipText(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "String s = nullIfEmpty(str(toolTip));\r\n    if (neq(s, c.getToolTipText()))\r\n ...";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setToolTipText(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public String nullIfEmpty(String s) {
    return isEmpty(s) ? null : s;
  }

  static public <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
    return isEmpty(map) ? null : map;
  }

  static public <A> List<A> nullIfEmpty(List<A> l) {
    return isEmpty(l) ? null : l;
  }

  static public void addMenuItem(JPopupMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(JPopupMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public void addMenuItem(JMenu menu, String text, Object action) {
    menu.add(jmenuItem(text, action));
  }

  static public void addMenuItem(Menu menu, String text, Object action) {
    menu.add(menuItem(text, action));
  }

  static public void addMenuItem(JMenu menu, JMenuItem menuItem) {
    menu.add(menuItem);
  }

  static public String copyTextToClipboard(Object _text) {
    String text = str(_text);
    StringSelection selection = new StringSelection(text);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    vmBus_send("newClipboardContents", text);
    return text;
  }

  static public void setComponent(SingleComponentPanel scp, Component c) {
    setSCPComponent(scp, c);
  }

  static public void setComponent(SingleComponentPanel scp, IF0<Component> c) {
    if (scp != null)
      setComponent(scp, callF(c));
  }

  static public Object swing(Object f) {
    return swingAndWait(f);
  }

  static public <A> A swing(F0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> A swing(IF0<A> f) {
    return (A) swingAndWait(f);
  }

  static public <A> void removeAll(Collection<A> a, Collection<A> b) {
    if (a != null && b != null)
      a.removeAll(b);
  }

  static public <A, B> void removeAll(Map<A, B> a, Collection<A> b) {
    if (a != null && b != null)
      for (A x : b) a.remove(x);
  }

  static public void add(BitSet bs, int i) {
    bs.set(i);
  }

  static public <A> boolean add(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public void add(Container c, Component x) {
    addToContainer(c, x);
  }

  static public JComponent wrap(Object swingable) {
    return _recordNewSwingComponent(wrap_2(swingable));
  }

  static public JComponent wrap_2(Object swingable) {
    if (swingable == null)
      return null;
    JComponent c;
    if (swingable instanceof Component)
      c = componentToJComponent(((Component) swingable));
    else
      c = componentToJComponent((Component) callOpt(swingable, "swing"));
    if (c instanceof JTable || c instanceof JList || c instanceof JTextArea || c instanceof JEditorPane || c instanceof JTextPane || c instanceof JTree)
      return jscroll(c);
    return c == null ? jlabel(str(swingable)) : c;
  }

  static public <A extends Component> A _revalidate(A c) {
    return revalidate(c);
  }

  static public void _revalidate(JFrame f) {
    revalidate(f);
  }

  static public void _revalidate(JInternalFrame f) {
    revalidate(f);
  }

  static public Container _getParent(Component c) {
    return getParent(c);
  }

  static public boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  static public int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  static public void fillArrayUnlessZero(byte[] a, byte value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public void fillArrayUnlessZero(int[] a, int value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public void fillArrayUnlessZero(float[] a, float value) {
    if (value != 0)
      Arrays.fill(a, value);
  }

  static public boolean inRange(int x, int n) {
    return x >= 0 && x < n;
  }

  static public boolean inRange(int x, int a, int b) {
    return x >= a && x < b;
  }

  static public int ubyteToInt(byte b) {
    return b & 0x0FF;
  }

  static public double averageBrightness(BufferedImage img) {
    return new BWImage(img).averageBrightness();
  }

  static public int limitToUByte(int i) {
    return max(0, min(255, i));
  }

  static public void lock(Lock lock) {
    try {
      ping();
      if (lock == null)
        return;
      try {
        lock.lockInterruptibly();
      } catch (InterruptedException e) {
        Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
        print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
        printStackTrace(e);
        rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void lock(Lock lock, String msg) {
    print("Locking: " + msg);
    lock(lock);
  }

  static public void lock(Lock lock, String msg, long timeout) {
    print("Locking: " + msg);
    lockOrFail(lock, timeout);
  }

  static public ReentrantLock lock() {
    return fairLock();
  }

  static public boolean hasLock(Lock lock) {
    return ((ReentrantLock) lock).isHeldByCurrentThread();
  }

  static public long sysNow() {
    ping();
    return System.nanoTime() / 1000000;
  }

  static public void unlock(Lock lock, String msg) {
    if (lock == null)
      return;
    lock.unlock();
    print("Unlocked: " + msg);
  }

  static public void unlock(Lock lock) {
    if (lock == null)
      return;
    lock.unlock();
  }

  static public void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  static public void clear(Map map) {
    if (map != null)
      map.clear();
  }

  static public <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }

  static public Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  static public Flag dm_initErrorHandling_flag = new Flag();

  static public void dm_initErrorHandling() {
    raiseFlagAndDo(dm_initErrorHandling_flag, new Runnable() {

      public void run() {
        try {
          _handleException_addHandler("dm_initErrorHandling_handler");
          assertNull(_onRegisterThread);
          _onRegisterThread = new VF1<Thread>() {

            public void get(Thread t) {
              try {
                DynModule m = dm_currentModule();
                if (m == null)
                  printStackTrace("New thread made outside of a module");
                else
                  m.ownTimer(t);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "DynModule m = dm_currentModule();\r\n      if (m == null) printStackTrace(\"New ...";
            }
          };
          _threadInfo_makers.add(new VF1<Map>() {

            public void get(Map map) {
              try {
                mapPut(map, "dm_currentModule_value", dm_currentModule());
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "mapPut(map, 'dm_currentModule_value, dm_currentModule())";
            }
          });
          _threadInheritInfo_retrievers.add(new VF1<Map>() {

            public void get(Map map) {
              try {
                Object mod = map.get("dm_currentModule_value");
                if (mod instanceof DynModule)
                  dm_currentModule_value.set(new WeakReference((DynModule) mod));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "O mod = map.get('dm_currentModule_value);\r\n      if (mod instanceof DynModule...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_handleException_addHandler(f dm_initErrorHandling_handler);\r\n    \r\n    asser...";
      }
    });
  }

  static public void dm_initErrorHandling_handler(Throwable e) {
    DynModule m = dm_currentModule();
    if (m == null)
      print("Weird: Error outside of module");
    else
      m.setField("_error", persistableThrowable(e));
  }

  static public void setMainDesktopPane(JDesktopPane desktop) {
    mainDesktopPane_value = desktop;
  }

  static public <A> A getCreatorOpt(String field) {
    return (A) getOpt(creator(), field);
  }

  static public boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    if (o instanceof ThreadLocal)
      return isTrue(((ThreadLocal) o).get());
    throw fail(getClassName(o));
  }

  static public boolean eq(Object a, Object b) {
    return a == b || a != null && b != null && a.equals(b);
  }

  static public <A extends Component> A possiblyInternalFrameTitle(A c, String title) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      internalFrameTitle(f, title);
    else
      frameTitle(getFrame(c), title);
    return c;
  }

  static public String possiblyInternalFrameTitle(Component c) {
    JInternalFrame f = getInternalFrame(c);
    return f != null ? internalFrameTitle(f) : frameTitle(getFrame(c));
  }

  static public void vmBus_send(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    pcallFAll(vm_busListeners_live(), msg, arg);
    pcallFAll(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public void vmBus_send(String msg) {
    vmBus_send(msg, (Object) null);
  }

  static public void ownResource(AutoCloseable c) {
    _registerAutoCloseable(c);
  }

  static public <A> List<A> getAndClearList(Collection<A> l) {
    if (l == null)
      return emptyList();
    synchronized (collectionMutex(l)) {
      List<A> out = cloneList(l);
      l.clear();
      return out;
    }
  }

  static volatile public PersistableThrowable _handleException_lastException;

  static public List _handleException_onException = synchroList(ll("printStackTrace2"));

  static public void _handleException(Throwable e) {
    _handleException_lastException = persistableThrowable(e);
    Throwable e2 = innerException(e);
    if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException)
      return;
    for (Object f : cloneList(_handleException_onException)) try {
      callF(f, e);
    } catch (Throwable e3) {
      printStackTrace2(e3);
    }
  }

  static public <A, B> Map<A, B> getAndClearMap(Map<A, B> map) {
    if (map == null)
      return emptyMap();
    synchronized (collectionMutex(map)) {
      Map<A, B> out = cloneMap(map);
      map.clear();
      return out;
    }
  }

  static public <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keys(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public Object pcallFInRealOrMyMC(final Object realm, final Object f, final Object... args) {
    try {
      return callFInRealOrMyMC(realm, f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  static public <A> A pcallFInRealOrMyMC(Object realm, F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallFInRealOrMyMC(Object realm, F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public void pcallFAll(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) pcallF(f, args);
  }

  static public void pcallFAll(Iterator it, Object... args) {
    while (it.hasNext()) pcallF(it.next(), args);
  }

  static public boolean isFalse(Object o) {
    return eq(false, o);
  }

  static public <A, B> B mapGet(Map<A, B> map, A a) {
    return map == null || a == null ? null : map.get(a);
  }

  static public <A, B> B mapGet(A a, Map<A, B> map) {
    return map == null || a == null ? null : map.get(a);
  }

  static public void _close(AutoCloseable c) {
    if (c != null)
      try {
        c.close();
      } catch (Throwable e) {
        if (c instanceof javax.imageio.stream.ImageOutputStream)
          return;
        else
          throw rethrow(e);
      }
  }

  static public int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(short[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(long[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(double[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  static public int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  static public int l(Iterator i) {
    return iteratorCount_int_close(i);
  }

  static public int l(Map m) {
    return m == null ? 0 : m.size();
  }

  static public int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  static public long l(File f) {
    return f == null ? 0 : f.length();
  }

  static public int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : o instanceof Object[] ? l((Object[]) o) : o instanceof boolean[] ? l((boolean[]) o) : o instanceof byte[] ? l((byte[]) o) : o instanceof char[] ? l((char[]) o) : o instanceof short[] ? l((short[]) o) : o instanceof int[] ? l((int[]) o) : o instanceof float[] ? l((float[]) o) : o instanceof double[] ? l((double[]) o) : o instanceof long[] ? l((long[]) o) : (Integer) call(o, "size");
  }

  static public int l(MultiSet ms) {
    return ms == null ? 0 : ms.size();
  }

  static public int l(IntRange r) {
    return r == null ? 0 : r.length();
  }

  static public long l(LongRange r) {
    return r == null ? 0 : r.length();
  }

  static public Rect dm_getBounds(Object module) {
    return shallowCloneToClass(Rect.class, call(dm_getStem(module), "getFrameRect"));
  }

  static public Rect dm_getBounds() {
    return dm_getBounds(dm_current_generic());
  }

  static public boolean hasMethod_onTypes(Object o, String method, Class... argTypes) {
    return findMethod_precise_onTypes(o, method, argTypes) != null;
  }

  static public void dm_onTopInput_q(final VF1<String> r) {
    final DynModule m = dm_current_mandatory();
    dm_onTopInput(new VF1<String>() {

      public void get(final String s) {
        try {
          m.q().add(new Runnable() {

            public void run() {
              try {
                callF(r, s);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "callF(r, s);";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "switch to m.q();\r\n    callF(r, s);";
      }
    });
  }

  static public <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
    if (tl == null)
      return null;
    final A prev = setThreadLocal(tl, a);
    return new AutoCloseable() {

      public String toString() {
        return "tl.set(prev);";
      }

      public void close() throws Exception {
        tl.set(prev);
      }
    };
  }

  static public Class getMainClass() {
    return mc();
  }

  static public Class getMainClass(Object o) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class && eq(((Class) o).getName(), "x30"))
        return (Class) o;
      return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable combineAutoCloseables(final AutoCloseable a, final AutoCloseable b) {
    return a == null ? b : b == null ? a : new AutoCloseable() {

      public String toString() {
        return "a.close(); b.close();";
      }

      public void close() throws Exception {
        a.close();
        b.close();
      }
    };
  }

  static public AutoCloseable combineAutoCloseables(AutoCloseable a, AutoCloseable b, AutoCloseable c, AutoCloseable... more) {
    return combineAutoCloseables(concatLists(ll(a, b, c), asList(more)));
  }

  static public AutoCloseable combineAutoCloseables(Iterable<AutoCloseable> l) {
    return foldl(new F2<AutoCloseable, AutoCloseable, AutoCloseable>() {

      public AutoCloseable get(AutoCloseable a, AutoCloseable b) {
        try {
          return combineAutoCloseables(a, b);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "combineAutoCloseables(a,b)";
      }
    }, null, l);
  }

  static public AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
    return print_byThread().get() == null ? tempInterceptPrint(f) : null;
  }

  static public Class mc() {
    return utils.class;
  }

  static public <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
    return tempSetThreadLocal(tl, a);
  }

  static public ThreadLocal realMC_tl_tl = new ThreadLocal();

  static public ThreadLocal realMC_tl() {
    return realMC_tl_tl;
  }

  static public AutoCloseable tempLock(Lock lock) {
    return tempLock("", lock);
  }

  static public AutoCloseable tempLock(String purpose, Lock lock) {
    if (lock == null)
      return null;
    lock(lock);
    return new AutoCloseable() {

      public String toString() {
        return "unlock(lock);";
      }

      public void close() throws Exception {
        unlock(lock);
      }
    };
  }

  static public PersistableThrowable persistableThrowable(Throwable e) {
    return e == null ? null : new PersistableThrowable(e);
  }

  static public <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  static public <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  static public <A> boolean addIfNotThere(Collection<A> c, A a) {
    return setAdd(c, a);
  }

  static public <A extends JSpinner> A onChange(A spinner, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            spinner.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "spinner.addChangeListener(changeListener(r));";
        }
      });
    }
    return spinner;
  }

  static public <A extends AbstractButton> A onChange(A b, Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            b.addItemListener(itemListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addItemListener(itemListener(r));";
        }
      });
    }
    return b;
  }

  static public void onChange(JTextComponent tc, Object r) {
    onUpdate(tc, r);
  }

  static public <A extends JSlider> A onChange(A slider, final Object r) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            slider.addChangeListener(changeListener(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "slider.addChangeListener(changeListener(r));";
        }
      });
    }
    return slider;
  }

  static public JComboBox onChange(Object r, JComboBox cb) {
    return onChange(cb, r);
  }

  static public JComboBox onChange(JComboBox cb, final Object r) {
    if (isEditableComboBox(cb))
      onChange(textFieldFromComboBox(cb), r);
    else
      onSelectedItem(cb, new VF1<String>() {

        public void get(String s) {
          try {
            callF(r);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(r)";
        }
      });
    return cb;
  }

  static public void onUpdateAndNow(JComponent c, final Object r) {
    onUpdate(c, r);
    callF(r);
  }

  static public void onUpdateAndNow(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
    callF(r);
  }

  static public void onUpdate(JComponent c, final Object r) {
    if (c instanceof JTextComponent)
      ((JTextComponent) c).getDocument().addDocumentListener(new DocumentListener() {

        public void insertUpdate(DocumentEvent e) {
          call(r);
        }

        public void removeUpdate(DocumentEvent e) {
          call(r);
        }

        public void changedUpdate(DocumentEvent e) {
          call(r);
        }
      });
    else if (c instanceof ItemSelectable)
      ((ItemSelectable) c).addItemListener(new ItemListener() {

        public void itemStateChanged(ItemEvent e) {
          call(r);
        }
      });
    else
      print("Warning: onUpdate doesn't know " + getClassName(c));
  }

  static public void onUpdate(List<? extends JComponent> l, Object r) {
    for (JComponent c : l) onUpdate(c, r);
  }

  static public void zeroAllFieldsOfTypeExcept(Object o, Class type, String... exceptions) {
    zeroAllFieldsOfTypeExcept(o, type, asSet(exceptions));
  }

  static public void zeroAllFieldsOfTypeExcept(Object o, Class type, Collection<String> exceptions) {
    Set<String> set = asSet(exceptions);
    for (String field : allFields(o)) if (!set.contains(field) && instanceOf(getOpt(o, field), type))
      set(o, field, null);
  }

  static public List<AbstractAction> paramsToAbstractActions(Object... params) {
    List<AbstractAction> l = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) {
      String text = (String) (params[i]);
      Runnable action = (Runnable) (params[i + 1]);
      if (nempty(text))
        l.add(abstractAction(text, action));
    }
    return l;
  }

  static public void internalFramePopupMenuFromActions_threaded(Container f, List<AbstractAction> actions) {
    if (!(f instanceof JInternalFrame))
      return;
    for (final AbstractAction a : unnull(actions)) if (a != null)
      internalFramePopupMenuItem(((JInternalFrame) f), str(a.getValue(Action.NAME)), runnableThread(new Runnable() {

        public void run() {
          try {
            callAction(a);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callAction(a)";
        }
      }));
  }

  static public <A> LinkedHashSet<A> asLinkedHashSet(A[] array) {
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> LinkedHashSet<A> asLinkedHashSet(Collection<A> l) {
    if (l instanceof LinkedHashSet)
      return (LinkedHashSet) l;
    LinkedHashSet<A> set = new LinkedHashSet();
    for (A o : l) if (o != null)
      set.add(o);
    return set;
  }

  static public List<String> splitAtSpace(String s) {
    return empty(s) ? emptyList() : asList(s.split("\\s+"));
  }

  static public Set<String> allFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public boolean startsWith(String a, String b) {
    return a != null && a.startsWith(unnull(b));
  }

  static public boolean startsWith(String a, char c) {
    return nemptyString(a) && a.charAt(0) == c;
  }

  static public boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    m.m = new String[] { substring(a, strL(b)) };
    return true;
  }

  static public boolean startsWith(List a, List b) {
    if (a == null || listL(b) > listL(a))
      return false;
    for (int i = 0; i < listL(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  static public void dm_boolFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    internalFrameTitlePopupMenu(((JInternalFrame) frame), new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          menu.add(jCheckBoxMenuItem(humanized, (boolean) _get(m, field), new VF1<Boolean>() {

            public void get(Boolean b) {
              try {
                m.setField(field, b);
                callF(optPar(__, "onSet"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.setField(field, b);\r\n      callF(optPar(_, 'onSet));";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "menu.add(jCheckBoxMenuItem(humanized, (bool) _get(m, field), voidfunc(bool b)...";
      }
    });
  }

  static public void dm_intFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          final JTextField tf = jtextfield(get(m, field));
          showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

            public void run() {
              try {
                m.setField(field, parseInt(gtt(tf)));
                callF(optPar(__, "onSet"));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "m.setField(field, parseInt(gtt(tf)));\r\n        callF(optPar(__, \"onSet\"));";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTextField tf = jtextfield(get(m, field));\r\n    showFormTitled(or2(stri...";
      }
    });
  }

  static public void dm_doubleFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_doubleFieldSetterDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_doubleFieldSetterDialog(field, __);";
      }
    });
  }

  static public void dm_stringFieldMenuItem(Container frame, final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_stringFieldDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_stringFieldDialog(field, __);";
      }
    });
  }

  static public void dm_fileFieldMenuItem(Container frame, String field, Object... __) {
    DynModule m = dm_current_mandatory();
    internalFramePopupMenuItem(((JInternalFrame) frame), humanizeFormLabel(field) + "...", new Runnable() {

      public void run() {
        try {
          AutoCloseable __1 = m.enter();
          try {
            dm_fileFieldDialog(field, __);
          } finally {
            _close(__1);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "temp m.enter();\r\n    dm_fileFieldDialog(field, __);";
      }
    });
  }

  static public ReliableSingleThread dm_rst(Runnable r) {
    return dm_rst(dm_current_mandatory(), r);
  }

  static public ReliableSingleThread dm_rst(DynModule mod, Runnable r) {
    return dm_rst(mod, new ReliableSingleThread(r));
  }

  static public ReliableSingleThread dm_rst(DynModule mod, ReliableSingleThread rst) {
    rst.enter = dm_rEnter(mod);
    return rst;
  }

  static public Q dm_startQ() {
    return dm_ownQ(startQ());
  }

  static public Q dm_startQ(String name) {
    return dm_ownQ(startQ(name));
  }

  static public JComponent dm_noVisualisation() {
    return setToolTip("Module has no visualization", jimage("#1101480"));
  }

  static public String snippetTitle(String id) {
    return getSnippetTitle(id);
  }

  static public String snippetTitle(long id) {
    return getSnippetTitle(id);
  }

  static public String programID() {
    return getProgramID();
  }

  static public String programID(Object o) {
    return getProgramID(o);
  }

  static public Class mainClass() {
    return getMainClass();
  }

  static public Class mainClass(Object o) {
    return getMainClass(o);
  }

  static public <A, B> Map<A, B> mapMinus(Map<A, B> map, Object... keys) {
    if (empty(keys))
      return map;
    Map<A, B> m2 = cloneMap(map);
    for (Object key : keys) m2.remove(key);
    return m2;
  }

  static public <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
    m = cloneMap(m);
    litmap_impl(m, data);
    return m;
  }

  static public Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

  static public void _registerTimer_original(java.util.Timer timer) {
    _registerTimer_list.add(timer);
  }

  static public void cleanMeUp__registerTimer() {
    cancelTimers(getAndClearList(_registerTimer_list));
  }

  static public JPanel jSection(Component c) {
    return jSection("", c);
  }

  static public JPanel jSection(final String title, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
          border = BorderFactory.createTitledBorder(border, title);
          JSection panel = new JSection(c);
          panel.setBorder(border);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Border border = BorderFactory.createBevelBorder(BevelBorder.LOWERED);\r\n    bo...";
      }
    });
  }

  static public JPanel jSection(String title) {
    return jSection(title, jpanel());
  }

  static public JScrollPane jscroll_copyBackground(Component c) {
    return setScrollPaneBackground(getBackground(c), jscroll(c));
  }

  static public JFastLogView_noWrap jFastLogView_noWrap() {
    return jFastLogView_noWrap("");
  }

  static public JFastLogView_noWrap jFastLogView_noWrap(String text) {
    return withTypeWriterFont(swingNu(JFastLogView_noWrap.class, text));
  }

  static public String getPrintLog() {
    return str(print_log);
  }

  static public <A extends JComponent> A componentPopupMenuItem(A c, final String name, final Object action) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, name, action);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, action);";
      }
    });
    return c;
  }

  static public void componentPopupMenuItem(JComponent c, final JMenuItem menuItem) {
    componentPopupMenu(c, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, menuItem);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, menuItem);";
      }
    });
  }

  static public void dm_clearModulePrintLog() {
    clearStringBuffer_gen(dm_current_mandatory()._actualPrintLog());
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, Object r) {
    swingEvery(component, delay, r);
    return component;
  }

  static public <A extends JComponent> A awtEvery(A component, long delay, long firstDelay, Object r) {
    swingEvery(component, delay, firstDelay, r);
    return component;
  }

  static public void awtEvery(RootPaneContainer frame, long delay, Object r) {
    swingEvery(frame, delay, r);
  }

  static public <A extends JComponent> A awtEvery(A component, double delaySeconds, Object r) {
    return awtEvery(component, toMS(delaySeconds), r);
  }

  static public boolean scrollAllTheWayDown_bruteForce = true;

  static public <A extends JComponent> A scrollAllTheWayDown(A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            int h = c.getHeight() - 1;
            if (scrollAllTheWayDown_bruteForce)
              h = max(h, 100000);
            c.scrollRectToVisible(new Rectangle(0, h, 1, 1));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "int h = c.getHeight()-1;\r\n    if (scrollAllTheWayDown_bruteForce) h = max(h, ...";
        }
      });
    }
    return c;
  }

  static public void awtLater(int delay, final Object r) {
    swingLater(delay, r);
  }

  static public void awtLater(Object r) {
    swingLater(r);
  }

  static public void awtLater(JComponent component, int delay, Object r) {
    installTimer(component, r, delay, delay, false);
  }

  static public void awtLater(JFrame frame, int delay, Object r) {
    awtLater(frame.getRootPane(), delay, r);
  }

  static public StringBuffer liveLocalPrintLog_realMC(Object o) {
    Object realMC = getMainClass(o);
    if (realMC != mc())
      return (StringBuffer) getOpt(realMC, "local_log");
    return liveLocalPrintLog();
  }

  static public String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  static public String str(char[] c) {
    return new String(c);
  }

  static public LinkedHashMap litorderedmap(Object... x) {
    LinkedHashMap map = new LinkedHashMap();
    litmap_impl(map, x);
    return map;
  }

  static public <B> Map<String, B> humanizeKeys(Map<String, B> map) {
    return mapKeys(__71 -> humanizeFormLabel(__71), map);
  }

  static public Map<String, Object> objectToMap_inOrder_withoutFields(Object o, Collection<String> withoutFields) {
    if (o == null)
      return null;
    if (o instanceof Map)
      return (Map) o;
    LinkedHashMap<String, Object> map = new LinkedHashMap();
    for (String field : listWithoutSet(fieldsInOrder(o), withoutFields)) map.put(field, get(o, field));
    return map;
  }

  static public Map<String, Object> objectToMap(Object o) {
    try {
      if (o instanceof Map)
        return (Map) o;
      TreeMap<String, Object> map = new TreeMap();
      Class c = o.getClass();
      while (c != Object.class) {
        Field[] fields = c.getDeclaredFields();
        for (final Field field : fields) {
          if ((field.getModifiers() & Modifier.STATIC) != 0)
            continue;
          field.setAccessible(true);
          final Object value = field.get(o);
          if (value != null)
            map.put(field.getName(), value);
        }
        c = c.getSuperclass();
      }
      if (o instanceof DynamicObject)
        map.putAll(((DynamicObject) o).fieldValues);
      return map;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<Map<String, Object>> objectToMap(Iterable l) {
    if (l == null)
      return null;
    List x = new ArrayList();
    for (Object o : l) x.add(objectToMap(o));
    return x;
  }

  static public Map mapValues(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(key, callF(func, map.get(key)));
    return m;
  }

  static public <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
    return mapValues(f, map);
  }

  static public <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
    return mapValues((Object) f, map);
  }

  static public Map mapValues(Map map, Object func) {
    return mapValues(func, map);
  }

  static public String strOrEmpty(Object o) {
    return o == null ? "" : str(o);
  }

  static public <A> List<A> addDyn_sync(List<A> l, A a) {
    if (l == null)
      l = synchroList();
    l.add(a);
    return l;
  }

  static public String programTitle() {
    return getProgramName();
  }

  static public int count(Collection l, Object o) {
    int count = 0;
    for (Object x : l) if (eq(x, o))
      ++count;
    return count;
  }

  static public List map(Iterable l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map(Iterable<A> l, F1<A, B> f) {
    return map(f, l);
  }

  static public <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(callF(f, o));
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  static public <A, B> List<B> map(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> List<B> map(A[] l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : l) x.add(f.get(o));
    return x;
  }

  static public List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  static public List map(Object[] l, Object f) {
    return map(f, l);
  }

  static public List map(Object f, Map map) {
    return map(map, f);
  }

  static public List map(Map map, Object f) {
    List x = new ArrayList();
    if (map != null)
      for (Object _e : map.entrySet()) {
        Map.Entry e = (Map.Entry) _e;
        x.add(callF(f, e.getKey(), e.getValue()));
      }
    return x;
  }

  static public <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
    return map(map, (Object) f);
  }

  static public JTable dataToTable_uneditable(Object data, final JTable table) {
    return dataToTable_uneditable(table, data);
  }

  static public JTable dataToTable_uneditable(final JTable table, final Object data) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            dataToTable(table, data, true);
            makeTableUneditable(table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "dataToTable(table, data, true);\r\n    makeTableUneditable(table);";
        }
      });
    }
    return table;
  }

  static public JTable dataToTable_uneditable(final Object data) {
    return dataToTable_uneditable(showTable(), data);
  }

  static public JTable dataToTable_uneditable(Object data, String title) {
    return dataToTable_uneditable(showTable(title), data);
  }

  static public boolean sexyTable_drag = false;

  static public JTable sexyTable() {
    final JTable table = sexyTableWithoutDrag();
    if (sexyTable_drag)
      tableEnableTextDrag(table);
    return table;
  }

  static public JTable onDoubleClickOrEnter(final JTable table, final Object runnable) {
    onDoubleClick(table, runnable);
    onEnter(table, runnable);
    return table;
  }

  static public JList onDoubleClickOrEnter(final JList list, final Object runnable) {
    onDoubleClick(list, runnable);
    onEnter(list, runnable);
    return list;
  }

  static public JTable onDoubleClickOrEnter(Object runnable, JTable table) {
    return onDoubleClickOrEnter(table, runnable);
  }

  static public <A> A _get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public Object _get(Object o, String field) {
    return get(o, field);
  }

  static public Object _get(String field, Object o) {
    return get(o, field);
  }

  static public <A> A _get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  static public JList onDoubleClick(final JList list, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            list.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                  int idx = list.locationToIndex(evt.getPoint());
                  Object item = list.getModel().getElementAt(idx);
                  list.setSelectedIndex(idx);
                  callF(runnable, item);
                }
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "list.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(Mous...";
        }
      });
    }
    return list;
  }

  static public JTable onDoubleClick(final JTable table, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            table.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                  int idx = table.rowAtPoint(evt.getPoint());
                  table.setRowSelectionInterval(idx, idx);
                  callF(runnable, idx);
                }
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "table.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(Mou...";
        }
      });
    }
    return table;
  }

  static public void onDoubleClick(final JComponent c, final Object runnable) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2)
                  callF(runnable, evt.getPoint());
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(MouseEv...";
        }
      });
    }
  }

  static public class TableSearcher {

    public JTable table;

    public JTextField tfInput;

    public JComponent searchPanel, panel;

    public F2<String, Map, Boolean> rowTester;

    public List<Integer> rowIndices;

    public String input() {
      return gtt(tfInput);
    }
  }

  static public TableSearcher tableWithSearcher2(final JTable t, Object... __) {
    final TableSearcher s = new TableSearcher();
    final boolean precise = true;
    s.table = t;
    s.tfInput = jtextfield();
    s.rowTester = new F2<String, Map, Boolean>() {

      public Boolean get(String pat, Map row) {
        try {
          return anyValueContainsIgnoreCase(row, pat);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "anyValueContainsIgnoreCase(row, pat)";
      }
    };
    onUpdate(s.tfInput, new Runnable() {

      public List lastFiltered, lastOriginal;

      public void run() {
        String pat = s.input();
        List<Map<String, Object>> data = rawTableData(t);
        if (eq(lastFiltered, data))
          data = lastOriginal;
        List data2 = new ArrayList();
        List<Integer> rowIndices = new ArrayList();
        for (int i = 0; i < l(data); i++) {
          Map<String, Object> map = data.get(i);
          if (isTrue(callF(s.rowTester, pat, map))) {
            data2.add(map);
            rowIndices.add(i);
          }
        }
        lastFiltered = data2;
        lastOriginal = data;
        dataToTable(t, data2);
        if (precise)
          lastFiltered = rawTableData(t);
        s.rowIndices = rowIndices;
      }
    });
    s.searchPanel = withLabel("Search:", s.tfInput);
    JComponent top = s.searchPanel;
    s.panel = boolOptPar(__, "withMargin") ? northAndCenterWithMargin(top, t) : northAndCenter(top, t);
    return s;
  }

  static public Point enclosingViewPosition(Component c) {
    JScrollPane sp = enclosingScrollPane(c);
    return sp == null ? null : swing(new F0<Point>() {

      public Point get() {
        try {
          return sp.getViewport().getViewPosition();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret sp.getViewport().getViewPosition();";
      }
    });
  }

  static public void setEnclosingViewPosition(Component c, Point p) {
    if (p == null)
      return;
    JScrollPane sp = enclosingScrollPane(c);
    if (sp != null) {
      swing(new Runnable() {

        public void run() {
          try {
            sp.getViewport().setViewPosition(p);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "sp.getViewport().setViewPosition(p);";
        }
      });
    }
  }

  static public String n2(long l) {
    return formatWithThousands(l);
  }

  static public String n2(Collection l) {
    return n2(l(l));
  }

  static public String n2(Map map) {
    return n2(l(map));
  }

  static public String n2(double l, String singular) {
    return n2(l, singular, singular + "s");
  }

  static public String n2(double l, String singular, String plural) {
    if (fraction(l) == 0)
      return n2((long) l, singular, plural);
    else
      return l + " " + plural;
  }

  static public String n2(long l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(long l, String singular) {
    return n_fancy2(l, singular, singular + "s");
  }

  static public String n2(Collection l, String singular) {
    return n2(l(l), singular);
  }

  static public String n2(Collection l, String singular, String plural) {
    return n_fancy2(l, singular, plural);
  }

  static public String n2(Map m, String singular, String plural) {
    return n_fancy2(m, singular, plural);
  }

  static public String n2(Map m, String singular) {
    return n2(l(m), singular);
  }

  static public String n2(Object[] a, String singular) {
    return n2(l(a), singular);
  }

  static public String n2(Object[] a, String singular, String plural) {
    return n_fancy2(a, singular, plural);
  }

  static public String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }

  static public <A> void syncClear(Collection<A> c) {
    if (c != null)
      synchronized (collectionMutex(c)) {
        c.clear();
      }
  }

  static public void syncClear(Map map) {
    if (map != null)
      synchronized (collectionMutex(map)) {
        map.clear();
      }
  }

  static public <A> boolean syncAdd(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.add(b);
    }
  }

  static public <A> void syncAdd(List<A> l, int idx, A b) {
    if (l != null)
      synchronized (collectionMutex(l)) {
        l.add(idx, b);
      }
  }

  static public boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean empty(Iterable c) {
    return c == null || !c.iterator().hasNext();
  }

  static public boolean empty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  static public boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    if (o instanceof byte[])
      return empty((byte[]) o);
    if (o == null)
      return true;
    throw fail("unknown type for 'empty': " + getType(o));
  }

  static public boolean empty(Iterator i) {
    return i == null || !i.hasNext();
  }

  static public boolean empty(double[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(short[] a) {
    return a == null || a.length == 0;
  }

  static public boolean empty(MultiSet ms) {
    return ms == null || ms.isEmpty();
  }

  static public boolean empty(File f) {
    return getFileSize(f) == 0;
  }

  static public boolean empty(IntRange r) {
    return r == null || r.empty();
  }

  static public <A> boolean syncAddAll(Collection<A> c, Collection<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (c) {
      return c.addAll(b);
    }
  }

  static public <A> boolean syncRemove(Collection<A> c, A b) {
    if (c == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.remove(b);
    }
  }

  static public <A> A syncRemove(List<A> l, int idx) {
    if (l == null)
      return null;
    synchronized (collectionMutex(l)) {
      return l.remove(idx);
    }
  }

  static public <A, B> B syncRemove(Map<A, B> map, A key) {
    return map == null ? null : map.remove(key);
  }

  static public <A> boolean syncRemoveAll(Collection<A> c, Collection<A> b) {
    if (c == null || b == null)
      return false;
    synchronized (collectionMutex(c)) {
      return c.removeAll(b);
    }
  }

  static public int[] selectedTableRows_array(final JTable table) {
    return table == null ? null : swing(new F0<int[]>() {

      public int[] get() {
        try {
          return table.getSelectedRows();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret table.getSelectedRows();";
      }
    });
  }

  static public <A> ArrayList<A> cloneList(Iterable<A> l) {
    return l instanceof Collection ? cloneList((Collection) l) : asList(l);
  }

  static public <A> ArrayList<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    synchronized (collectionMutex(l)) {
      return new ArrayList<A>(l);
    }
  }

  static public void dm_vmBus_send(String msg, Object... args) {
    vmBus_send(msg, args);
  }

  static public void dm_vmBus_send(String msg) {
    vmBus_send(msg);
  }

  static public void change() {
    callOpt(getOptMC("mainConcepts"), "allChanged");
  }

  static public void selectTableRows(final JTable table, int[] rows) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            ListSelectionModel model = table.getSelectionModel();
            int n = tableRows(table);
            model.clearSelection();
            if (rows != null)
              for (int row : rows) if (row < n)
                model.addSelectionInterval(row, row);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ListSelectionModel model = table.getSelectionModel();\r\n    int n = tableRows(...";
        }
      });
    }
  }

  static public int syncL(Collection l) {
    if (l == null)
      return 0;
    synchronized (l) {
      return l.size();
    }
  }

  static public <A> List<A> syncL() {
    return syncList();
  }

  static public <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  static public <A> A syncGet(List<A> l, int idx) {
    if (l == null || idx < 0)
      return null;
    synchronized (l) {
      return idx < l(l) ? l.get(idx) : null;
    }
  }

  static public <A, B> B syncGet(Map<A, B> map, A a) {
    if (map == null)
      return null;
    synchronized (map) {
      return map.get(a);
    }
  }

  static public int selectedTableRowInModel(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          int i = t.getSelectedRow();
          return i < 0 ? i : t.convertRowIndexToModel(i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "int i = t.getSelectedRow();\r\n    ret i < 0 ? i : t.convertRowIndexToModel(i);";
      }
    });
  }

  static public <A> List<A> syncListGetMulti(final List<A> l, List<Integer> indices) {
    synchronized (collectionMutex(l)) {
      return listGetMulti(l, indices);
    }
  }

  static public int selectedTableRow(final JTable t) {
    return t == null ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.getSelectedRow();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.getSelectedRow();";
      }
    });
  }

  static public List<Integer> selectedTableRowsInModel(final JTable t) {
    return t == null ? emptyList() : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret map(selectedTableRows(t), i -> t.convertRowIndexToModel(i));";
      }
    });
  }

  static public <A> int indexOf(List<A> l, A a, int startIndex) {
    if (l == null)
      return -1;
    int n = l(l);
    for (int i = startIndex; i < n; i++) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public <A> int indexOf(List<A> l, int startIndex, A a) {
    return indexOf(l, a, startIndex);
  }

  static public <A> int indexOf(List<A> l, A a) {
    if (l == null)
      return -1;
    return l.indexOf(a);
  }

  static public int indexOf(String a, String b) {
    return a == null || b == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, String b, int i) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, char b) {
    return a == null ? -1 : a.indexOf(b);
  }

  static public int indexOf(String a, int i, char b) {
    return indexOf(a, b, i);
  }

  static public int indexOf(String a, char b, int i) {
    return a == null ? -1 : a.indexOf(b, i);
  }

  static public int indexOf(String a, int i, String b) {
    return a == null || b == null ? -1 : a.indexOf(b, i);
  }

  static public <A> int indexOf(A[] x, A a) {
    int n = l(x);
    for (int i = 0; i < n; i++) if (eq(x[i], a))
      return i;
    return -1;
  }

  static public void selectRow(final JTable table, final int i) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (i >= 0 && i < table.getRowCount()) {
              table.setRowSelectionInterval(i, i);
              scrollRowToVisible(table, i);
            } else
              table.clearSelection();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (i >= 0 && i < table.getRowCount()) {\r\n      table.setRowSelectionInterval...";
        }
      });
    }
  }

  static public void selectRow(final JList list, final int i) {
    if (list != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (i >= 0 && i < listRowCount(list))
              list.setSelectedIndex(i);
            else
              list.clearSelection();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (i >= 0 && i < listRowCount(list))\r\n      list.setSelectedIndex(i);\r\n    e...";
        }
      });
    }
  }

  static public JComboBox selectItem(final String item, final JComboBox cb) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.setSelectedItem(item);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.setSelectedItem(item);";
        }
      });
    }
    return cb;
  }

  static public JComboBox selectItem(final JComboBox cb, final String item) {
    return selectItem(item, cb);
  }

  static public <A> JList<A> selectItem(JList<A> list, A item) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            selectRow(list, jlist_indexOf(list, item));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "selectRow(list, jlist_indexOf(list, item));";
        }
      });
    }
    return list;
  }

  static public JTable tablePopupMenuItemsThreaded(final JTable table, Object... params) {
    for (int i = 0; i + 1 < l(params); i += 2) {
      final Object action = params[i + 1];
      final Object threadInfo = _threadInfo();
      tablePopupMenuItem(table, str(params[i]), new VF1<Integer>() {

        public void get(final Integer row) {
          try {
            _threadInheritInfo(threadInfo);
            {
              startThread(new Runnable() {

                public void run() {
                  try {
                    try {
                      callF(action, row);
                    } catch (Throwable __e) {
                      messageBox(__e);
                    }
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "try {\r\n        callF(action, row);\r\n      } catch (Throwable __e) { messageBo...";
                }
              });
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "_threadInheritInfo(threadInfo);\r\n      thread-messagebox {\r\n        callF(act...";
        }
      });
    }
    return table;
  }

  static public JTable tablePopupMenuItemsThreaded_top(final JTable table, Object... params) {
    params = reverseParams(params);
    for (int i = 0; i + 1 < l(params); i += 2) {
      final Object action = params[i + 1];
      final Object threadInfo = _threadInfo();
      tablePopupMenuItem_top(table, str(params[i]), new VF1<Integer>() {

        public void get(final Integer row) {
          try {
            _threadInheritInfo(threadInfo);
            {
              startThread(new Runnable() {

                public void run() {
                  try {
                    try {
                      callF(action, row);
                    } catch (Throwable __e) {
                      messageBox(__e);
                    }
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "try {\r\n        callF(action, row);\r\n      } catch (Throwable __e) { messageBo...";
                }
              });
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "_threadInheritInfo(threadInfo);\r\n      thread-messagebox {\r\n        callF(act...";
        }
      });
    }
    return table;
  }

  static public <A, B extends A> void _addAll(Collection<A> c, Iterable<B> b) {
    addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, Collection<B> b) {
    return addAll(c, b);
  }

  static public <A, B extends A> boolean _addAll(Collection<A> c, B... b) {
    return addAll(c, b);
  }

  static public void scrollTableDownNow(final JTable table) {
    if (table != null) {
      swing(new Runnable() {

        public void run() {
          try {
            table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "table.scrollRectToVisible(table.getCellRect(table.getRowCount()-1, 0, true));";
        }
      });
    }
  }

  static public <A extends Concept> List<A> list(Class<A> type) {
    return db_mainConcepts().list(type);
  }

  static public <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
    return concepts.list(type);
  }

  static public List<Concept> list(String type) {
    return db_mainConcepts().list(type);
  }

  static public List<Concept> list(Concepts concepts, String type) {
    return concepts.list(type);
  }

  static public List getList(Map map, Object key) {
    return map == null ? null : (List) map.get(key);
  }

  static public List getList(List l, int idx) {
    return (List) get(l, idx);
  }

  static public List getList(Object o, Object key) {
    if (o instanceof Map)
      return getList((Map) o, key);
    if (key instanceof String)
      return (List) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public List getList(String name, Object o) {
    return getList(o, name);
  }

  static public <A> ArrayList<A> clonedList(Iterable<A> l) {
    return cloneList(l);
  }

  static public <A> ArrayList<A> clonedList(Collection<A> l) {
    return cloneList(l);
  }

  static public File programFile(String name) {
    return prepareProgramFile(name);
  }

  static public File programFile(String progID, String name) {
    return prepareProgramFile(progID, name);
  }

  static public String ymd_minus_hms_minus_millis() {
    return ymd() + "-" + spliceString(replace(hmsWithColonsAndMS(), ":", ""), 6, 6, "-");
  }

  static public void saveGZStructToFile(String file, Object o) {
    saveGZStructureToFile(file, o);
  }

  static public void saveGZStructToFile(File file, Object o) {
    saveGZStructureToFile(file, o);
  }

  static public File printFileInfo(File f) {
    return printFileInfo("", f);
  }

  static public File printFileInfo(String s, File f) {
    print(s, renderFileInfo(f));
    return f;
  }

  static public ImageSurface imageSurface(BufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface(MakesBufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public ImageSurface imageSurface() {
    return swingNu(ImageSurface.class);
  }

  static public JScrollPane jscroll_center(Component c) {
    return jscroll_centered(c);
  }

  static public boolean fileExists(String path) {
    return path != null && new File(path).exists();
  }

  static public boolean fileExists(File f) {
    return f != null && f.exists();
  }

  static public JLabel setImage(final BufferedImage img, final JLabel lbl) {
    if (lbl != null) {
      swing(new Runnable() {

        public void run() {
          try {
            lbl.setIcon(imageIcon(img));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lbl.setIcon(imageIcon(img));";
        }
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, BufferedImage img) {
    return setImage(img, lbl);
  }

  static public JLabel setImage(final String imageID, final JLabel lbl) {
    if (lbl != null) {
      swing(new Runnable() {

        public void run() {
          try {
            lbl.setIcon(imageIcon(imageID));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lbl.setIcon(imageIcon(imageID));";
        }
      });
    }
    return lbl;
  }

  static public JLabel setImage(JLabel lbl, String imageID) {
    return setImage(imageID, lbl);
  }

  static public BufferedImage loadImage2(String snippetIDOrURL) {
    return loadBufferedImage(snippetIDOrURL);
  }

  static public BufferedImage loadImage2(File file) {
    return loadBufferedImage(file);
  }

  static public void savePNG(BufferedImage img, File file) {
    try {
      File tempFile = new File(file.getPath() + "_temp");
      CriticalAction ca = beginCriticalAction("Save " + f2s(file));
      try {
        ImageIO.write(img, "png", mkdirsFor(tempFile));
        file.delete();
        tempFile.renameTo(file);
      } finally {
        ca.done();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void savePNG(File file, BufferedImage img) {
    savePNG(img, file);
  }

  static public void savePNG(File file, RGBImage img) {
    savePNG(file, img.getBufferedImage());
  }

  static public JWindow infoBox(String text) {
    return infoMessage(text);
  }

  static public JWindow infoBox(String text, double seconds) {
    return infoMessage(text, seconds);
  }

  static public JWindow infoBox(Throwable e) {
    return infoMessage(e);
  }

  static public String renderFileInfo(File f) {
    return f == null ? "-" : f2s(f) + " " + (f.isFile() ? "(file, " + n2(fileSize(f)) + " bytes)" : f.isDirectory() ? "(dir)" : "(not found)");
  }

  static public void internalFramePopupMenuItem(Container f, final String name, final Object action) {
    internalFrameTitlePopupMenuItem(((JInternalFrame) f), name, action);
  }

  static public Runnable runnableThread(final Runnable r) {
    return new Runnable() {

      public void run() {
        try {
          startThread(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "startThread(r)";
      }
    };
  }

  static public AutoCloseable tempSetField(final Object o, final String field, Object value) {
    final Object oldValue = get(o, field);
    set(o, field, value);
    return new AutoCloseable() {

      public void close() {
        set(o, field, oldValue);
      }
    };
  }

  static public Object pcallF(Object f, Object... args) {
    return pcallFunction(f, args);
  }

  static public <A> A pcallF(F0<A> f) {
    try {
      return f == null ? null : f.get();
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> B pcallF(F1<A, B> f, A a) {
    try {
      return f == null ? null : f.get(a);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A> void pcallF(VF1<A> f, A a) {
    try {
      if (f != null)
        f.get(a);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  static public String dm_moduleID(Object module) {
    return strOrNull(getOpt(dm_getStem(module), "id"));
  }

  static public String dm_moduleID() {
    return dm_moduleID(dm_current_mandatory_generic());
  }

  static public File javaxDataDir_dir;

  static public File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  static public File javaxDataDir(String... subs) {
    return newFile(javaxDataDir(), subs);
  }

  static public Rect toRect(Rectangle r) {
    return r == null ? null : new Rect(r);
  }

  static public Rect toRect(RectangularShape r) {
    return r == null ? null : toRect(r.getBounds());
  }

  static public Rect toRect(Rect r) {
    return r;
  }

  static public Rectangle toRectangle(Rect r) {
    return r == null ? null : r.getRectangle();
  }

  static public JList jlist(final List<String> l) {
    return (JList) swing(new F0<Object>() {

      public Object get() {
        try {
          JList list = new JList();
          final WeakReference<JList> ref = weakRef(list);
          listPopupMenuItem(list, "Copy text to clipboard", new Runnable() {

            public void run() {
              try {
                copyTextToClipboardIfNotNull(selectedItem(ref.get()));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "copyTextToClipboardIfNotNull(selectedItem(ref.get()))";
            }
          });
          fillListWithStrings(list, l);
          return list;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new JList list;\r\n    final WeakReference<JList> ref = weakRef(list);\r\n    lis...";
      }
    });
  }

  static public JList jlist(String... l) {
    return jlist(asList(l));
  }

  static public void fillListWithStrings(JList list, Collection<String> contents) {
    if (list == null)
      return;
    final DefaultListModel model = new DefaultListModel();
    if (contents != null)
      for (String s : contents) model.addElement(empty(s) ? " " : s);
    {
      swing(new Runnable() {

        public void run() {
          try {
            list.setModel(model);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "list.setModel(model);";
        }
      });
    }
  }

  static public void fillListWithStrings(final JList list, String[] contents) {
    fillListWithStrings(list, asList(contents));
  }

  static public String selectedItem(JList l) {
    return getSelectedItem(l);
  }

  static public String selectedItem(JComboBox cb) {
    return getSelectedItem(cb);
  }

  static public <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  static public <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  static public boolean nempty(Collection c) {
    return !empty(c);
  }

  static public boolean nempty(CharSequence s) {
    return !empty(s);
  }

  static public boolean nempty(Object[] o) {
    return !empty(o);
  }

  static public boolean nempty(byte[] o) {
    return !empty(o);
  }

  static public boolean nempty(int[] o) {
    return !empty(o);
  }

  static public boolean nempty(Map m) {
    return !empty(m);
  }

  static public boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  static public boolean nempty(Object o) {
    return !empty(o);
  }

  static public boolean nempty(IntRange r) {
    return !empty(r);
  }

  static public String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  static public String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  static public String formatSnippetID(long id) {
    return "#" + id;
  }

  static public Object realMC() {
    return getThreadLocal(realMC_tl());
  }

  static public <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  static public class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  static final public Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  static public HashMap getOpt_special;

  static public Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return mapGet2(((DynamicObject) o).fieldValues, field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      if (!reflection_classesNotToScan().contains(c.getName())) {
        Class _c = c;
        do {
          for (Field f : _c.getDeclaredFields()) {
            makeAccessible(f);
            String name = f.getName();
            if (!map.containsKey(name))
              map.put(name, f);
          }
          _c = _c.getSuperclass();
        } while (_c != null);
      }
    }
    if (getOpt_cache != null)
      getOpt_cache.put(c, map);
    return map;
  }

  static public Map<JTable, VF1<JTable>> setTableModel_after = weakHashMap();

  static public Map<JTable, VF2<JTable, RowSorter>> setTableModel_fixSorter = weakHashMap();

  static public void setTableModel(final JTable table, final TableModel model) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Map<String, Integer> widths = tableColumnWidthsByName(table);
            int[] i = table.getSelectedRows();
            TableRowSorter sorter = model.getColumnCount() == tableColumnCount(table) ? (TableRowSorter) table.getRowSorter() : null;
            List<? extends RowSorter.SortKey> sortKeys = sorter == null ? null : sorter.getSortKeys();
            table.setModel(model);
            int n = model.getRowCount();
            ListSelectionModel sel = table.getSelectionModel();
            for (int j = 0; j < i.length; j++) if (i[j] < n)
              sel.addSelectionInterval(i[j], i[j]);
            tableSetColumnPreferredWidths(table, widths);
            if (sorter != null) {
              sorter.setModel(model);
              callF(setTableModel_fixSorter.get(table), table, sorter);
              if (sortKeys != null)
                sorter.setSortKeys(sortKeys);
            }
            table.setRowSorter(sorter);
            callF(setTableModel_after.get(table), table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Map<String, Integer> widths = tableColumnWidthsByName(table);\r\n    int[] i = ...";
        }
      });
    }
  }

  static public Map<Thread, Boolean> _registerThread_threads;

  static public Object _onRegisterThread;

  static public Thread _registerThread(Thread t) {
    if (_registerThread_threads == null)
      _registerThread_threads = newWeakHashMap();
    _registerThread_threads.put(t, true);
    vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
    callF(_onRegisterThread, t);
    return t;
  }

  static public void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  static public Object _onAWTEnter_f;

  static public AutoCloseable _onAWTEnter() {
    return (AutoCloseable) callF(_onAWTEnter_f);
  }

  static public JDesktopPane mainDesktopPane_value;

  static public JDesktopPane mainDesktopPane() {
    return mainDesktopPane_value;
  }

  static public Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  static public void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  static public void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  static public boolean interruptThread_verbose = false;

  static public void interruptThread(Thread t) {
    if (t == null)
      return;
    if (interruptThread_verbose)
      print("Interrupting thread " + t);
    vm_threadInterruptionReasonsMap().put(t, getStackTrace());
    t.interrupt();
    URLConnection c = (URLConnection) (vm_generalSubMap("URLConnection per thread").get(t));
    if (c != null) {
      try {
        print("Closing URLConnection of interrupted thread.");
        call(c, "disconnect");
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public void cancelTimer(javax.swing.Timer timer) {
    if (timer != null)
      timer.stop();
  }

  static public void cancelTimer(java.util.Timer timer) {
    if (timer != null)
      timer.cancel();
  }

  static public void cancelTimer(Object o) {
    if (o instanceof java.util.Timer)
      cancelTimer((java.util.Timer) o);
    else if (o instanceof javax.swing.Timer)
      cancelTimer((javax.swing.Timer) o);
    else if (o instanceof AutoCloseable) {
      try {
        ((AutoCloseable) o).close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public Class javax() {
    return getJavaX();
  }

  static public boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  static public RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  static public Object first(Object list) {
    return first((Iterable) list);
  }

  static public <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  static public <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  static public <A> A first(IterableIterator<A> i) {
    return first((Iterator<A>) i);
  }

  static public <A> A first(Iterator<A> i) {
    return i == null || !i.hasNext() ? null : i.next();
  }

  static public <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  static public Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public Character first(CharSequence s) {
    return empty(s) ? null : s.charAt(0);
  }

  static public <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  static public Byte first(byte[] l) {
    return empty(l) ? null : l[0];
  }

  static public List _registerWeakMap_preList;

  static public <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  static public void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  static public Map synchroMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  static public String javaTok_substringN(String s, int i, int j) {
    if (i == j)
      return "";
    if (j == i + 1 && s.charAt(i) == ' ')
      return " ";
    return s.substring(i, j);
  }

  static public String javaTok_substringC(String s, int i, int j) {
    return s.substring(i, j);
  }

  static public List<String> javaTokWithExisting(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  static public boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && s.regionMatches(i, t, 0, j - i);
  }

  static public void rotateStringBuffer(StringBuffer buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void rotateStringBuilder(StringBuilder buf, int max) {
    try {
      if (buf == null)
        return;
      synchronized (buf) {
        if (buf.length() <= max)
          return;
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
        buf.trimToSize();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  static public Field makeAccessible(Field f) {
    try {
      f.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, f);
    }
    return f;
  }

  static public Method makeAccessible(Method m) {
    try {
      m.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, m);
    }
    return m;
  }

  static public Constructor makeAccessible(Constructor c) {
    try {
      c.setAccessible(true);
    } catch (Throwable e) {
      vmBus_send("makeAccessible_error", e, c);
    }
    return c;
  }

  static public void smartSet(Field f, Object o, Object value) throws Exception {
    try {
      f.set(o, value);
    } catch (Exception e) {
      Class type = f.getType();
      if (type == int.class && value instanceof Long)
        value = ((Long) value).intValue();
      if (type == LinkedHashMap.class && value instanceof Map) {
        f.set(o, asLinkedHashMap((Map) value));
        return;
      }
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {
      }
      throw e;
    }
  }

  static public <A extends DynamicObject> A setDyn(A o, String key, Object value) {
    if (o == null)
      return o;
    setDynObjectValue(o, key, value);
    return o;
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap() {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
  }

  static public <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
    return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
  }

  static public Object callMCWithVarArgs(String method, Object... args) {
    return call_withVarargs(mc(), method, args);
  }

  static public String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  static public Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object call_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findStaticMethod(method, args);
        if (me != null)
          return invokeMethod(me, null, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, null, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        throw fail("Method " + c.getName() + "." + method + "(" + joinWithComma(classNames(args)) + ") not found");
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object callOpt_withVarargs(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me == null) {
          return null;
        }
        if ((me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(method, args);
        if (me != null)
          return invokeMethod(me, o, args);
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          methodSearch: for (Method m : methods) {
            {
              if (!(m.isVarArgs()))
                continue;
            }
            Object[] newArgs = massageArgsForVarArgsCall(m, args);
            if (newArgs != null)
              return invokeMethod(m, o, newArgs);
          }
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A, B> Map<A, B> weakHashMap() {
    return newWeakHashMap();
  }

  static public int shorten_default = 100;

  static public String shorten(CharSequence s) {
    return shorten(s, shorten_default);
  }

  static public String shorten(CharSequence s, int max) {
    return shorten(s, max, "...");
  }

  static public String shorten(CharSequence s, int max, String shortener) {
    if (s == null)
      return "";
    if (max < 0)
      return str(s);
    return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max - l(shortener))) + shortener;
  }

  static public String shorten(int max, CharSequence s) {
    return shorten(s, max);
  }

  static public TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
    return new SmartTimerTask(r, timer, delay, _threadInfo());
  }

  static public class SmartTimerTask extends TimerTask implements IFieldsToList {

    public Object r;

    public java.util.Timer timer;

    public long delay;

    public Object threadInfo;

    public SmartTimerTask() {
    }

    public SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
      this.threadInfo = threadInfo;
      this.delay = delay;
      this.timer = timer;
      this.r = r;
    }

    public String toString() {
      return shortClassName(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")";
    }

    public Object[] _fieldsToList() {
      return new Object[] { r, timer, delay, threadInfo };
    }

    public long lastRun;

    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        _threadInheritInfo(threadInfo);
        AutoCloseable __1 = tempActivity(r);
        try {
          lastRun = fixTimestamp(lastRun);
          long now = now();
          if (now >= lastRun + delay * 0.9) {
            lastRun = now;
            if (eq(false, pcallF(r)))
              timer.cancel();
          }
        } finally {
          _close(__1);
        }
      }
    }
  }

  static public int toInt(Object o) {
    if (o == null)
      return 0;
    if (o instanceof Number)
      return ((Number) o).intValue();
    if (o instanceof String)
      return parseInt(((String) o));
    if (o instanceof Boolean)
      return boolToInt(((Boolean) o));
    throw fail("woot not int: " + getClassName(o));
  }

  static public int toInt(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public <A> A vmBus_timerStarted(A timer) {
    vmBus_send("timerStarted", timer, costCenter());
    return timer;
  }

  static public long toMS(double seconds) {
    return (long) (seconds * 1000);
  }

  static volatile public boolean ping_pauseAll = false;

  static public int ping_sleep = 100;

  static volatile public boolean ping_anyActions = false;

  static public Map<Thread, Object> ping_actions = newWeakHashMap();

  static public ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

  static public boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
    return true;
  }

  static public boolean ping_impl(boolean okInCleanUp) {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
          failIfUnlicensed();
        Object action = null;
        synchronized (ping_actions) {
          if (!ping_actions.isEmpty()) {
            action = ping_actions.get(currentThread());
            if (action instanceof Runnable)
              ping_actions.remove(currentThread());
            if (ping_actions.isEmpty())
              ping_anyActions = false;
          }
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public TimerTask timerTask(final Object r, final java.util.Timer timer) {
    return new TimerTask() {

      public void run() {
        if (!licensed())
          timer.cancel();
        else
          pcallF(r);
      }
    };
  }

  static public Map<String, Integer> findBot_cache = synchroHashMap();

  static public int findBot_timeout = 5000;

  static public DialogIO findBot(String searchPattern) {
    String subBot = null;
    int i = searchPattern.indexOf('/');
    if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
      subBot = searchPattern.substring(i + 1);
      searchPattern = searchPattern.substring(0, i);
      if (!isInteger(searchPattern))
        searchPattern = "Multi-Port at " + searchPattern + ".";
    }
    if (isInteger(searchPattern))
      return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    if (eq(searchPattern, "remote"))
      return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    Integer port = findBot_cache.get(searchPattern);
    if (port != null)
      try {
        DialogIO io = talkTo("localhost", port);
        io.waitForLine();
        String line = io.readLineNoBlock();
        if (indexOfIgnoreCase(line, searchPattern) == 0) {
          call(io, "pushback", line);
          return talkToSubBot(subBot, io);
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    List<ProgramScan.Program> bots = quickBotScan();
    for (ProgramScan.Program p : bots) {
      if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) {
        findBot_cache.put(searchPattern, p.port);
        return talkToSubBot(subBot, talkTo("localhost", p.port));
      }
    }
    for (ProgramScan.Program p : bots) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            String name = subBots.get(vport);
            if (startsWithIgnoreCase(name, searchPattern))
              return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
          }
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
    }
    return null;
  }

  static public <A> A swingConstruct(final Class<A> c, final Object... args) {
    return swing(new F0<A>() {

      public A get() {
        try {
          return nuObject(c, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret nuObject(c, args);";
      }
    });
  }

  static public <A extends JComponent> A setFont(final Font font, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setFont(font);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setFont(font);";
        }
      });
    }
    return a;
  }

  static public <A extends JComponent> A setFont(A a, Font font) {
    return setFont(font, a);
  }

  static public <A extends JComponent> A setFont(final String fontID, float fontSize, final A a) {
    return setFont(loadFont_cached(fontID, fontSize), a);
  }

  static public JTextArea jTextArea() {
    return jTextArea("");
  }

  static public JTextArea jTextArea(final String text) {
    return jTextAreaWithUndo(text);
  }

  static public Font typeWriterFont() {
    return typeWriterFont(iround(14 * getSwingFontScale()));
  }

  static public Font typeWriterFont(int size) {
    return new Font("Courier", Font.PLAIN, size);
  }

  static public boolean structure_showTiming, structure_checkTokenCount;

  static public String structure(Object o) {
    return structure(o, new structure_Data());
  }

  static public String structure(Object o, structure_Data d) {
    StringWriter sw = new StringWriter();
    d.out = new PrintWriter(sw);
    structure_go(o, d);
    String s = str(sw);
    if (structure_checkTokenCount) {
      print("token count=" + d.n);
      assertEquals("token count", l(javaTokC(s)), d.n);
    }
    return s;
  }

  static public void structure_go(Object o, structure_Data d) {
    structure_1(o, d);
    while (nempty(d.stack)) popLast(d.stack).run();
  }

  static public void structureToPrintWriter(Object o, PrintWriter out) {
    structure_Data d = new structure_Data();
    d.out = out;
    structure_go(o, d);
  }

  static public boolean structure_allowShortening = false;

  static public class structure_ClassInfo {

    public List<Field> fields;

    public Method customSerializer;

    public boolean special, nullInstances;
  }

  static public class structure_Data {

    public PrintWriter out;

    public int stringSizeLimit;

    public int shareStringsLongerThan = 20;

    public boolean noStringSharing = false;

    public IdentityHashMap<Object, Integer> seen = new IdentityHashMap();

    public HashMap<String, Integer> strings = new HashMap();

    public HashSet<String> concepts = new HashSet();

    public HashMap<Class, structure_ClassInfo> infoByClass = new HashMap();

    public HashMap<Class, Field> persistenceInfo = new HashMap();

    public int n;

    public List<Runnable> stack = new ArrayList();

    public structure_Data append(String token) {
      out.print(token);
      ++n;
      return this;
    }

    public structure_Data append(int i) {
      out.print(i);
      ++n;
      return this;
    }

    public structure_Data append(String token, int tokCount) {
      out.print(token);
      n += tokCount;
      return this;
    }

    public structure_Data app(String token) {
      out.print(token);
      return this;
    }

    public structure_Data app(int i) {
      out.print(i);
      return this;
    }
  }

  static public void structure_1(final Object o, final structure_Data d) {
    try {
      if (o == null) {
        d.append("null");
        return;
      }
      Class c = o.getClass();
      boolean concept = false;
      concept = o instanceof Concept;
      structure_ClassInfo info = d.infoByClass.get(c);
      if (info == null) {
        d.infoByClass.put(c, info = new structure_ClassInfo());
        if ((info.customSerializer = findMethodNamed(c, "_serialize")) != null)
          info.special = true;
      }
      List<Field> lFields = info.fields;
      if (lFields == null) {
        if (o instanceof Number) {
          PrintWriter out = d.out;
          if (o instanceof Integer) {
            int i = ((Integer) o).intValue();
            out.print(i);
            d.n += i < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Long) {
            long l = ((Long) o).longValue();
            out.print(l);
            out.print("L");
            d.n += l < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Short) {
            short s = ((Short) o).shortValue();
            d.append("sh ");
            out.print(s);
            d.n += s < 0 ? 2 : 1;
            return;
          }
          if (o instanceof Float) {
            d.append("fl ", 2);
            quoteToPrintWriter(str(o), out);
            return;
          }
          if (o instanceof Double) {
            d.append("d(", 3);
            quoteToPrintWriter(str(o), out);
            d.append(")");
            return;
          }
          if (o instanceof BigInteger) {
            out.print("bigint(");
            out.print(o);
            out.print(")");
            d.n += ((BigInteger) o).signum() < 0 ? 5 : 4;
            return;
          }
        }
        if (o instanceof Boolean) {
          d.append(((Boolean) o).booleanValue() ? "t" : "f");
          return;
        }
        if (o instanceof Character) {
          d.append(quoteCharacter((Character) o));
          return;
        }
        if (o instanceof File) {
          d.append("File ").append(quote(((File) o).getPath()));
          return;
        }
        Integer ref = d.seen.get(o);
        if (o instanceof String && ref == null)
          ref = d.strings.get((String) o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        if (!(o instanceof String))
          d.seen.put(o, d.n);
        else {
          String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
          if (!d.noStringSharing) {
            if (d.shareStringsLongerThan == Integer.MAX_VALUE)
              d.seen.put(o, d.n);
            if (l(s) >= d.shareStringsLongerThan)
              d.strings.put(s, d.n);
          }
          quoteToPrintWriter(s, d.out);
          d.n++;
          return;
        }
        if (o instanceof Set) {
          if (((Set) o) instanceof TreeSet) {
            d.append(isCISet_gen(((Set) o)) ? "ciset" : "treeset");
            structure_1(new ArrayList(((Set) o)), d);
            return;
          }
          d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
          structure_1(new ArrayList(((Set) o)), d);
          return;
        }
        String name = c.getName();
        if (o instanceof Collection && !isJavaXClassName(name)) {
          if (name.equals("java.util.Collections$SynchronizedList") || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedList(((List) o)), d);
              return;
            }
          } else if (name.equals("java.util.LinkedList"))
            d.append("ll");
          d.append("[");
          final int l = d.n;
          final Iterator it = ((Collection) o).iterator();
          d.stack.add(new Runnable() {

            public void run() {
              try {
                if (!it.hasNext())
                  d.append("]");
                else {
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(it.next(), d);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta...";
            }
          });
          return;
        }
        if (o instanceof Map && !startsWith(name, "main$")) {
          if (o instanceof LinkedHashMap)
            d.append("lhm");
          else if (o instanceof HashMap)
            d.append("hm");
          else if (o instanceof TreeMap)
            d.append(isCIMap_gen(((TreeMap) o)) ? "cimap" : "tm");
          else if (name.equals("java.util.Collections$SynchronizedMap") || name.equals("java.util.Collections$SynchronizedSortedMap") || name.equals("java.util.Collections$SynchronizedNavigableMap")) {
            d.append("sync ");
            {
              structure_1(unwrapSynchronizedMap(((Map) o)), d);
              return;
            }
          }
          d.append("{");
          final int l = d.n;
          final Iterator it = ((Map) o).entrySet().iterator();
          d.stack.add(new Runnable() {

            public boolean v = false;

            public Map.Entry e;

            public void run() {
              if (v) {
                d.append("=");
                v = false;
                d.stack.add(this);
                structure_1(e.getValue(), d);
              } else {
                if (!it.hasNext())
                  d.append("}");
                else {
                  e = (Map.Entry) it.next();
                  v = true;
                  d.stack.add(this);
                  if (d.n != l)
                    d.append(", ");
                  structure_1(e.getKey(), d);
                }
              }
            }
          });
          return;
        }
        if (c.isArray()) {
          if (o instanceof byte[]) {
            d.append("ba ").append(quote(bytesToHex((byte[]) o)));
            return;
          }
          final int n = Array.getLength(o);
          if (o instanceof boolean[]) {
            String hex = boolArrayToHex((boolean[]) o);
            int i = l(hex);
            while (i > 0 && hex.charAt(i - 1) == '0' && hex.charAt(i - 2) == '0') i -= 2;
            d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i)));
            return;
          }
          String atype = "array";
          if (o instanceof int[]) {
            atype = "intarray";
          } else if (o instanceof double[]) {
            atype = "dblarray";
          }
          d.append(atype).append("{");
          d.stack.add(new Runnable() {

            public int i;

            public void run() {
              if (i >= n)
                d.append("}");
              else {
                d.stack.add(this);
                if (i > 0)
                  d.append(", ");
                structure_1(Array.get(o, i++), d);
              }
            }
          });
          return;
        }
        if (o instanceof Class) {
          d.append("class(", 2).append(quote(((Class) o).getName())).append(")");
          return;
        }
        if (o instanceof Throwable) {
          d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")");
          return;
        }
        if (o instanceof BitSet) {
          BitSet bs = (BitSet) o;
          d.append("bitset{", 2);
          int l = d.n;
          for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i + 1)) {
            if (d.n != l)
              d.append(", ");
            d.append(i);
          }
          d.append("}");
          return;
        }
        if (name.startsWith("java.") || name.startsWith("javax.")) {
          d.append("j ").append(quote(str(o)));
          return;
        }
        if (info.special) {
          if (info.customSerializer != null) {
            Object o2 = invokeMethod(info.customSerializer, o);
            d.append("cu ");
            String shortName = dropPrefix("main$", name);
            d.append(shortName);
            d.out.append(' ');
            structure_1(o2, d);
            return;
          } else if (info.nullInstances) {
            d.append("null");
            return;
          } else
            throw fail("unknown special type");
        }
        String dynName = shortDynamicClassName(o);
        if (concept && !d.concepts.contains(dynName)) {
          d.concepts.add(dynName);
          d.append("c ");
        }
        TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {

          public int compare(Field a, Field b) {
            return stdcompare(a.getName(), b.getName());
          }
        });
        Class cc = c;
        while (cc != Object.class) {
          for (Field field : getDeclaredFields_cached(cc)) {
            String fieldName = field.getName();
            if (fieldName.equals("_persistenceInfo"))
              d.persistenceInfo.put(c, field);
            if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
              continue;
            fields.add(field);
          }
          cc = cc.getSuperclass();
        }
        lFields = asList(fields);
        int n = l(lFields);
        for (int i = 0; i < n; i++) {
          Field f = lFields.get(i);
          if (f.getName().equals("this$1")) {
            lFields.remove(i);
            lFields.add(0, f);
            break;
          }
        }
        info.fields = lFields;
      } else {
        Integer ref = d.seen.get(o);
        if (ref != null) {
          d.append("t").app(ref);
          return;
        }
        d.seen.put(o, d.n);
      }
      Field persistenceInfoField = (Field) (d.persistenceInfo.get(c));
      Map<String, Object> persistenceInfo = persistenceInfoField == null ? null : (Map) persistenceInfoField.get(o);
      LinkedHashMap<String, Object> fv = new LinkedHashMap();
      for (Field f : lFields) {
        Object value;
        try {
          value = f.get(o);
        } catch (Exception e) {
          value = "?";
        }
        if (value != null && (persistenceInfo == null || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
          fv.put(f.getName(), value);
      }
      String name = c.getName();
      String shortName = dropPrefix("main$", name);
      if (startsWithDigit(shortName))
        shortName = name;
      if (concept && eq(fv.get("className"), shortName))
        fv.remove("className");
      if (o instanceof DynamicObject) {
        putAll(fv, (Map) fv.get("fieldValues"));
        fv.remove("fieldValues");
        shortName = shortDynamicClassName(o);
        fv.remove("className");
      }
      String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
      d.append(shortName);
      d.n += countDots(shortName) * 2;
      final int l = d.n;
      final Iterator it = fv.entrySet().iterator();
      d.stack.add(new Runnable() {

        public void run() {
          try {
            if (!it.hasNext()) {
              if (d.n != l)
                d.append(")");
            } else {
              Map.Entry e = (Map.Entry) it.next();
              d.append(d.n == l ? "(" : ", ");
              d.append((String) e.getKey()).append("=");
              d.stack.add(this);
              structure_1(e.getValue(), d);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else...";
        }
      });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String structureForUser(Object o) {
    return beautifyStructure(struct_noStringSharing(o));
  }

  static public int toMS_int(double seconds) {
    return toInt_checked((long) (seconds * 1000));
  }

  static public URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
    con.setConnectTimeout(toInt(timeout));
    con.setReadTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  static public String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  static public String hideCredentials(String url) {
    try {
      if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url)))
        return url;
    } catch (Throwable e) {
      print("HideCredentials", e);
    }
    return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
  }

  static public String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  volatile static public boolean conceptsAndBot_running = false;

  static public boolean conceptsAndBot_thinOnStart = true;

  static public void conceptsAndBot() {
    conceptsAndBot(null);
  }

  static public void conceptsAndBot(Integer autoSaveInterval) {
    if (conceptsAndBot_running)
      return;
    conceptsAndBot_running = true;
    try {
      ensureDBNotRunning(dbBotStandardName());
    } catch (Throwable _e) {
      db_mainConcepts().dontSave = true;
      throw rethrow(_e);
    }
    db_mainConcepts().persist(autoSaveInterval);
    dbBot();
    if (conceptsAndBot_thinOnStart) {
      try {
        thinAProgramsBackups(getDBProgramID(), true);
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  static public <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
    if (l(params) == 1)
      params = new Object[] { singleFieldName(c), params[0] };
    else
      warnIfOddCount(params);
    return params;
  }

  static public boolean _csetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (value instanceof RC)
        value = c._concepts.getConcept((RC) value);
      value = deref(value);
      if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan)
        value = intern((String) value);
      if (f == null) {
        c.fieldValues = syncMapPut2_createLinkedHashMap(c.fieldValues, assertIdentifier(field), value instanceof Concept ? c.new Ref((Concept) value) : value);
        c.change();
      } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
        ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
        c.change();
        return true;
      } else if (isSubtypeOf(f.getType(), Concept.RefL.class)) {
        ((Concept.RefL) f.get(c)).replaceWithList(lmap(__72 -> derefRef(__72), (List) value));
        c.change();
        return true;
      } else {
        Object old = f.get(c);
        if (neq(value, old)) {
          f.set(c, value);
          if (!isTransient(f))
            c.change();
          return true;
        }
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String unnull(String s) {
    return s == null ? "" : s;
  }

  static public <A> Collection<A> unnull(Collection<A> l) {
    return l == null ? emptyList() : l;
  }

  static public <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  static public int[] unnull(int[] l) {
    return l == null ? emptyIntArray() : l;
  }

  static public char[] unnull(char[] l) {
    return l == null ? emptyCharArray() : l;
  }

  static public double[] unnull(double[] l) {
    return l == null ? emptyDoubleArray() : l;
  }

  static public <A, B> Map<A, B> unnull(Map<A, B> l) {
    return l == null ? emptyMap() : l;
  }

  static public <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  static public <A> A[] unnull(A[] a) {
    return a == null ? (A[]) emptyObjectArray() : a;
  }

  static public BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  static public Pt unnull(Pt p) {
    return p == null ? new Pt() : p;
  }

  static public <A, B> Pair<A, B> unnull(Pair<A, B> p) {
    return p != null ? p : new Pair(null, null);
  }

  static public void ping_okInCleanUp() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl(true);
  }

  static public Object getThreadLocal(Object o, String name) {
    ThreadLocal t = (ThreadLocal) (getOpt(o, name));
    return t != null ? t.get() : null;
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl) {
    return tl == null ? null : tl.get();
  }

  static public <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
    return or(getThreadLocal(tl), defaultValue);
  }

  static public boolean match3(String pat, String s) {
    return match3(pat, s, null);
  }

  static public boolean match3(String pat, String s, Matches matches) {
    if (pat == null || s == null)
      return false;
    return match3(pat, parse3_cachedInput(s), matches);
  }

  static public boolean match3(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = parse3_cachedPattern(pat);
    return match3(tokpat, toks, matches);
  }

  static public boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    if (matches != null)
      matches.m = m;
    return true;
  }

  static public Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public List<String> javaTokPlusPeriod(String s) {
    List<String> tok = new ArrayList<String>();
    if (s == null)
      return tok;
    int l = s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      String cc;
      while (j < l) {
        c = s.charAt(j);
        cc = s.substring(j, Math.min(j + 2, l));
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (cc.equals("/*")) {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (cc.equals("//")) {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      cc = s.substring(i, Math.min(i + 2, l));
      if (c == (char) 0x201C || c == (char) 0x201D)
        c = '"';
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          char _c = s.charAt(j);
          if (_c == (char) 0x201C || _c == (char) 0x201D)
            _c = '"';
          if (_c == opener) {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
        if (j - 1 >= i + 1) {
          tok.add(opener + s.substring(i + 1, j - 1) + opener);
          i = j;
          continue;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\''));
      else if (Character.isDigit(c))
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else if (cc.equals("[[")) {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (cc.equals("[=") && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else if (s.substring(j, Math.min(j + 3, l)).equals("..."))
        j += 3;
      else if (c == '$' || c == '#')
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      else
        ++j;
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  static public boolean isNonNegativeInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  static public String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  static public void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else if (c == '\t')
        out.append("\\t");
      else if (c == '\0')
        out.append("\\0");
      else
        out.append(c);
    }
    out.append('"');
  }

  static public Object vm_generalMap_get(Object key) {
    return vm_generalMap().get(key);
  }

  static public Object vm_generalMap_put(Object key, Object value) {
    return mapPutOrRemove(vm_generalMap(), key, value);
  }

  static public <A> Set<A> syncIdentityHashSet() {
    return (Set) synchronizedSet(identityHashSet());
  }

  static public Map syncHashMap() {
    return synchroHashMap();
  }

  static public <A, B> Map<A, B> newWeakMap() {
    return newWeakHashMap();
  }

  static public boolean networkAllowanceTest(String url) {
    return isAllowed("networkAllowanceTest", url);
  }

  static final public boolean loadPageThroughProxy_enabled = false;

  static public String loadPageThroughProxy(String url) {
    return null;
  }

  static public String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = hideCredentials(unnull(e.getMessage()));
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + prependIfNempty(": ", msg);
    else
      return msg;
  }

  static public void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  static public String tb_mainServer_default = "http://code.botcompany.de:8081";

  static public Object tb_mainServer_override;

  static public String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  static public File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  static public boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  static public <A> A printWithTime(A a) {
    return printWithTime("", a);
  }

  static public <A> A printWithTime(String s, A a) {
    print(hmsWithColons() + ": " + s, a);
    return a;
  }

  static public <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
    A a = tl.get();
    tl.set(null);
    return a;
  }

  static public <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
    A a = tl.get();
    if (a != null) {
      tl.set(null);
      return a;
    }
    return defaultValue;
  }

  static public <A> A optPar(ThreadLocal<A> tl) {
    return optPar(tl, null);
  }

  static public Object optPar(Object[] params, String name) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Object[] params) {
    return optParam(params, name);
  }

  static public Object optPar(String name, Map params) {
    return optParam(name, params);
  }

  static public <A> A optPar(Object[] params, String name, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public <A> A optPar(String name, Object[] params, A defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      }
  }

  static public Map vm_generalSubMap(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Map map = (Map) (vm_generalMap_get(name));
      if (map == null)
        vm_generalMap_put(name, map = synchroMap());
      return map;
    }
  }

  static public Thread currentThread() {
    return Thread.currentThread();
  }

  static public InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
    UnknownHostException lastException = null;
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      try {
        if (con instanceof HttpURLConnection)
          if (((HttpURLConnection) con).getResponseCode() == 500)
            throw new IOException(joinNemptiesWithColonSpace("Server code 500", tryToReadErrorStreamFromURLConnection(((HttpURLConnection) con))));
        return con.getInputStream();
      } catch (UnknownHostException e) {
        lastException = e;
        print("Retrying because of: " + e);
        continue;
      }
    }
    throw lastException;
  }

  static public GZIPInputStream newGZIPInputStream(File f) {
    return gzInputStream(f);
  }

  static public GZIPInputStream newGZIPInputStream(InputStream in) {
    return gzInputStream(in);
  }

  static public String unquote(String s) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        StringBuilder sb = new StringBuilder(l - 1);
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                sb.append(Character.toChars(code));
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          sb.append(ch);
        }
        return sb.toString();
      }
    }
    return s;
  }

  static public String toHex(byte[] bytes) {
    return bytesToHex(bytes);
  }

  static public String toHex(byte[] bytes, int ofs, int len) {
    return bytesToHex(bytes, ofs, len);
  }

  static public byte[] utf8(String s) {
    return toUtf8(s);
  }

  static public Matcher regexpMatcher(String pat, String s) {
    return compileRegexp(pat).matcher(unnull(s));
  }

  static public URLConnection openConnection(String url) {
    try {
      return openConnection(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
    if (con.getConnectTimeout() == 0) {
      con.setConnectTimeout(toInt(timeout));
      if (con.getConnectTimeout() != timeout)
        print("Warning: URL connect timeout not set by JDK.");
    }
    if (con.getReadTimeout() == 0) {
      con.setReadTimeout(toInt(timeout));
      if (con.getReadTimeout() != timeout)
        print("Warning: URL read timeout not set by JDK.");
    }
    return con;
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  static public boolean isLocalSnippetID(String snippetID) {
    return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
  }

  static public boolean isLocalSnippetID(long snippetID) {
    return snippetID >= 1000 && snippetID <= 9999;
  }

  static public String loadLocalSnippet(String snippetID) {
    return loadLocalSnippet(psI(snippetID));
  }

  static public String loadLocalSnippet(long snippetID) {
    return loadTextFile(localSnippetFile(snippetID));
  }

  static public IResourceLoader vm_getResourceLoader() {
    return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
  }

  static public String fsI(String id) {
    return formatSnippetID(id);
  }

  static public String fsI(long id) {
    return formatSnippetID(id);
  }

  static public String md5(String text) {
    try {
      if (text == null)
        return "-";
      return bytesToHex(md5_impl(toUtf8(text)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  static public byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String md5(File file) {
    return md5OfFile(file);
  }

  static public String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  static public String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(File f, String defaultContents) {
    return loadTextFile(f, defaultContents, "UTF-8");
  }

  static public String loadTextFile(File f, String defaultContents, String encoding) {
    try {
      checkFileNotTooBigToRead(f);
      if (f == null || !f.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(f);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
      return loadTextFile(inputStreamReader);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  static public String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  static public String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return str(builder);
  }

  static public File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      mkdirsForFile(file);
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      vmBus_send("wroteFile", file);
      return file;
    } finally {
      action.done();
    }
  }

  static public File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  static public <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
    if (tl == null)
      return null;
    A old = tl.get();
    tl.set(value);
    return old;
  }

  static public DialogIO talkTo(int port) {
    return talkTo("localhost", port);
  }

  static public int talkTo_defaultTimeout = 10000;

  static public int talkTo_timeoutForReads = 0;

  static public ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

  static public DialogIO talkTo(String ip, int port) {
    try {
      String full = ip + ":" + port;
      Map<String, DialogIO> map = talkTo_byThread.get();
      if (map != null && map.containsKey(full))
        return map.get(full);
      if (isLocalhost(ip) && port == vmPort())
        return talkToThisVM();
      return new talkTo_IO(ip, port);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public class talkTo_IO extends DialogIO {

    public String ip;

    public int port;

    public Socket s;

    public Writer w;

    public BufferedReader in;

    public talkTo_IO(String ip, int port) {
      this.port = port;
      this.ip = ip;
      try {
        s = new Socket();
        try {
          if (talkTo_timeoutForReads != 0)
            s.setSoTimeout(talkTo_timeoutForReads);
          s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
        } catch (Throwable e) {
          throw fail("Tried talking to " + ip + ":" + port, e);
        }
        w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
        in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }

    public boolean isStillConnected() {
      return !(eos || s.isClosed());
    }

    public void sendLine(String line) {
      try {
        Lock __0 = lock;
        lock(__0);
        try {
          w.write(line + "\n");
          w.flush();
        } finally {
          unlock(__0);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLineImpl() {
      try {
        return in.readLine();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
      try {
        if (!noClose)
          s.close();
      } catch (IOException e) {
      }
    }

    public Socket getSocket() {
      return s;
    }
  }

  static public String format(String pat, Object... args) {
    return format3(pat, args);
  }

  static public Map<String, Integer> newFindBot2_cache = synchroHashMap();

  static public boolean newFindBot2_verbose = false;

  static public DialogIO newFindBot2(String name) {
    Integer port = newFindBot2_cache.get(name);
    if (port != null) {
      if (newFindBot2_verbose)
        print("newFindBot2: testing " + name + " => " + port);
      DialogIO io = talkTo(port);
      String q = format("has bot *", name);
      String s = io.ask(q);
      if (match("yes", s)) {
        io = talkToSubBot(name, io);
        call(io, "pushback", "?");
        return io;
      }
      newFindBot2_cache.remove(name);
      if (newFindBot2_verbose)
        print("newFindBot2: dropping " + name + " => " + port);
    }
    DialogIO io = findBot(name);
    if (io != null) {
      newFindBot2_cache.put(name, io.getPort());
      if (newFindBot2_verbose)
        print("newFindBot2: remembering " + name + " => " + port);
    }
    return io;
  }

  static public TableWithTooltips tableWithToolTips() {
    return tableWithTooltips();
  }

  static public <A> WeakReference<A> weakRef(A a) {
    return newWeakReference(a);
  }

  static public List<String> getTableLine(JTable tbl, int row) {
    if (row >= 0 && row < tbl.getModel().getRowCount()) {
      List<String> l = new ArrayList();
      for (int i = 0; i < tbl.getModel().getColumnCount(); i++) l.add(String.valueOf(tbl.getModel().getValueAt(row, i)));
      return l;
    }
    return null;
  }

  static public void copyImageToClipboard(Image img) {
    TransferableImage trans = new TransferableImage(img);
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    vmBus_send("newClipboardContents", img);
    print("Copied image to clipboard (" + img.getWidth(null) + "*" + img.getHeight(null) + " px)");
  }

  static public JTextField jTextField() {
    return jTextField("");
  }

  static public JTextField jTextField(final String text) {
    return swing(new F0<JTextField>() {

      public JTextField get() {
        try {
          JTextField tf = new JTextField(unnull(text));
          standardTextFieldPopupMenu(tf);
          jenableUndoRedo(tf);
          tf.selectAll();
          return tf;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JTextField tf = new JTextField(unnull(text));\r\n    standardTextFieldPopupMenu...";
      }
    });
  }

  static public JTextField jTextField(Object o) {
    return jTextField(strOrEmpty(o));
  }

  static public JComponent showTitledForm(String title, Object... _parts) {
    return showFormTitled(title, _parts);
  }

  static public int parseInt(String s) {
    return emptyString(s) ? 0 : Integer.parseInt(s);
  }

  static public int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  static public String trim(String s) {
    return s == null ? null : s.trim();
  }

  static public String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  static public String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  static public int convertTableRowToModel(final JTable t, final int viewRow) {
    return t == null || viewRow < 0 ? -1 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.convertRowIndexToModel(viewRow);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.convertRowIndexToModel(viewRow);";
      }
    });
  }

  static public Object findComponentPopupMenuListener_gen(final JComponent c) {
    return c == null ? null : swing(new F0<Object>() {

      public Object get() {
        try {
          return firstWithClassShortNamed("componentPopupMenu_Adapter", c.getMouseListeners());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret firstWithClassShortNamed('componentPopupMenu_Adapter, c.getMouseListeners...";
      }
    });
  }

  static public boolean internalFrameActive(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    return f != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return f.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.isSelected();";
      }
    });
  }

  static public <A> A getWeakRef(Reference<A> ref) {
    return ref == null ? null : ref.get();
  }

  static public <A> A firstInstanceOf(Iterable i, Class<A> c) {
    if (i == null)
      return null;
    c = primitiveToBoxedTypeOpt(c);
    for (Object o : i) if (isInstance(c, o))
      return (A) o;
    return null;
  }

  static public <A> A firstInstanceOf(Class<A> c, Iterable i) {
    return firstInstanceOf(i, c);
  }

  static public <A> A firstInstanceOf(Object[] a, Class<A> c) {
    if (a == null)
      return null;
    c = primitiveToBoxedTypeOpt(c);
    for (Object o : a) if (isInstance(c, o))
      return (A) o;
    return null;
  }

  static public <A> List<Pair<A, A>> paramsToPairs(A... params) {
    List<Pair<A, A>> l = emptyList(l(params) / 2);
    for (int i = 0; i + 1 < l(params); i += 2) l.add(pair(params[i], params[i + 1]));
    return l;
  }

  static public String javaxDefaultVMArgs() {
    File fileNew, fileOld;
    String text = loadTextFile(fileNew = javaxDataDir("default-vm-args"));
    if (text == null) {
      text = loadTextFile(fileOld = programFile("#1005850", "default-vm-args"));
      if (text != null)
        moveFile(fileOld, fileNew);
    }
    return trim(unnull(text));
  }

  static public void appendToLocalMechLog(String listName, String text) {
    logMechListAppendLocally(listName, text);
  }

  static public List<String> dropSecondIfEmpty(String a, String b) {
    return empty(b) ? ll(a) : ll(a, b);
  }

  static public int parseFirstInt(String s) {
    return parseInt(jextract("<int>", s));
  }

  static public int parseFirstInt(Iterable<String> l) {
    return parseInt(firstIntegerString(l));
  }

  static public boolean usePreSpunVMs() {
    return eq("1", trim(loadProgramTextFile("#1005457", "enable-prespun-vms")));
  }

  static public void usePreSpunVMs(boolean flag) {
    saveProgramTextFile("#1005457", "enable-prespun-vms", flag ? "1" : null);
  }

  static public File classicNohupJavax(String javaxargs) {
    return classicNohupJavax(javaxargs, "");
  }

  static public File classicNohupJavax(String javaxargs, String vmArgs) {
    try {
      File jar = pathToJavaxJar();
      if (javaxargs.startsWith("#"))
        javaxargs = javaxargs.substring(1);
      String tempPrefix = takeFirst(30, nohup_sanitize(ymd_minus_hms() + "_" + javaxargs + "_"));
      File outFile;
      try {
        outFile = File.createTempFile(tempPrefix, "");
      } catch (Throwable e) {
        _handleException(e);
        print("Temp file creation failed for " + tempPrefix + ", trying again.");
        outFile = File.createTempFile("", "");
      }
      String cmd = joinWithSpace((platformParseArgs(_javaCommand() + " " + vmArgs))) + " -jar " + (isWindows() ? winQuote(jar) : bashQuote(jar)) + " " + javaxargs;
      nohup(cmd, outFile, false);
      return outFile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean startsWithIgnoreCase(String a, String b) {
    return regionMatchesIC(a, 0, b, 0, b.length());
  }

  static public String substring(String s, int x) {
    return substring(s, x, strL(s));
  }

  static public String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    int n = s.length();
    if (y < x)
      y = x;
    if (y > n)
      y = n;
    if (x >= y)
      return "";
    return s.substring(x, y);
  }

  static public String substring(String s, IntRange r) {
    return r == null ? null : substring(s, r.start, r.end);
  }

  static public String substring(String s, CharSequence l) {
    return substring(s, l(l));
  }

  static public boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  static public boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  static public boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  static public boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(byte[] a) {
    return a == null || a.length == 0;
  }

  static public boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  static public boolean jmenuItem_newThreads = false;

  static public JMenuItem jmenuItem(final String text) {
    return jMenuItem(text, null);
  }

  static public JMenuItem jmenuItem(final String text, final Object r) {
    return swing(new F0<JMenuItem>() {

      public JMenuItem get() {
        try {
          Pair<String, Integer> p = jmenu_autoMnemonic(dropPrefix("[disabled] ", text));
          JMenuItem mi = new JMenuItem(p.a);
          if (startsWith(text, "[disabled] "))
            disableMenuItem(mi);
          if (p.b != 0)
            mi.setMnemonic(p.b);
          mi.addActionListener(jmenuItem_newThreads ? actionListenerInNewThread(r) : actionListener(r));
          return mi;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Pair<S, Int> p = jmenu_autoMnemonic(dropPrefix(\"[disabled] \", text));\r\n    JM...";
      }
    });
  }

  static public MenuItem menuItem(String text, final Object r) {
    MenuItem mi = new MenuItem(text);
    mi.addActionListener(actionListener(r));
    return mi;
  }

  static public void setSCPComponent(SingleComponentPanel scp, Component c) {
    if (scp != null)
      scp.setComponent(c);
  }

  static public void swingAndWait(Runnable r) {
    try {
      if (isAWTThread())
        r.run();
      else
        EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object swingAndWait(final Object f) {
    if (isAWTThread())
      return callF(f);
    else {
      final Var result = new Var();
      swingAndWait(new Runnable() {

        public void run() {
          try {
            result.set(callF(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "result.set(callF(f));";
        }
      });
      return result.get();
    }
  }

  static public void addToContainer(Container a, Component... b) {
    if (a == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component c : unnull(b)) if (c != null)
              a.add(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component c : unnull(b))\r\n      if (c != null) \r\n        a.add(c);";
        }
      });
    }
  }

  static public <A extends Component> A _recordNewSwingComponent(A c) {
    if (c != null)
      callF((Object) vm_generalMap_get("newSwingComponentRegistry"), (Object) c);
    return c;
  }

  static public JComponent componentToJComponent(Component c) {
    if (c instanceof JComponent)
      return (JComponent) c;
    if (c instanceof JFrame)
      return ((JFrame) c).getRootPane();
    if (c == null)
      return null;
    throw fail("boohoo " + getClassName(c));
  }

  static public JScrollPane jscroll(final Component c) {
    return swing(new F0<JScrollPane>() {

      public JScrollPane get() {
        try {
          return new JScrollPane(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JScrollPane(c);";
      }
    });
  }

  static public <A extends Component> A revalidate(final A c) {
    if (c == null || !c.isShowing())
      return c;
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.revalidate();
            c.repaint();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "// magic combo to actually relayout and repaint\r\n    c.revalidate();\r\n    c.r...";
        }
      });
    }
    return c;
  }

  static public void revalidate(JFrame f) {
    revalidate((Component) f);
  }

  static public void revalidate(JInternalFrame f) {
    revalidate((Component) f);
  }

  static public Container getParent(final Component c) {
    return c == null ? null : swing(new F0<Container>() {

      public Container get() {
        try {
          return c.getParent();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getParent();";
      }
    });
  }

  static public int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = boostHashCombine(hash, hashCode(getOpt(a, field)));
    return hash;
  }

  static public String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  static public String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  static public int max(int a, int b) {
    return Math.max(a, b);
  }

  static public int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  static public long max(int a, long b) {
    return Math.max((long) a, b);
  }

  static public long max(long a, long b) {
    return Math.max(a, b);
  }

  static public double max(int a, double b) {
    return Math.max((double) a, b);
  }

  static public float max(float a, float b) {
    return Math.max(a, b);
  }

  static public double max(double a, double b) {
    return Math.max(a, b);
  }

  static public int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  static public double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  static public byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  static public short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  static public int max(int[] c) {
    int x = Integer.MIN_VALUE;
    for (int d : c) if (d > x)
      x = d;
    return x;
  }

  static public int min(int a, int b) {
    return Math.min(a, b);
  }

  static public long min(long a, long b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b) {
    return Math.min(a, b);
  }

  static public float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  static public double min(double a, double b) {
    return Math.min(a, b);
  }

  static public double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  static public float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  static public byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  static public short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  static public int min(int[] c) {
    int x = Integer.MAX_VALUE;
    for (int d : c) if (d < x)
      x = d;
    return x;
  }

  static public Map<Thread, Object> vm_threadInterruptionReasonsMap() {
    return vm_generalWeakSubMap("Thread interruption reasons");
  }

  static public String strOr(Object o, String ifNull) {
    return o == null ? ifNull : str(o);
  }

  static public <A extends Throwable> A printStackTrace(A e) {
    print(getStackTrace(e));
    return e;
  }

  static public void printStackTrace() {
    printStackTrace(new Throwable());
  }

  static public void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  static public void printStackTrace(String msg, Throwable e) {
    printStackTrace(new Throwable(msg, e));
  }

  static public void lockOrFail(Lock lock, long timeout) {
    try {
      ping();
      if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
        String s = "Couldn't acquire lock after " + timeout + " ms.";
        if (lock instanceof ReentrantLock) {
          ReentrantLock l = (ReentrantLock) lock;
          s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
        }
        throw fail(s);
      }
      ping();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ReentrantLock fairLock() {
    return new ReentrantLock(true);
  }

  static public void raiseFlagAndDo(Flag flag, Runnable r) {
    if (flag.raise())
      callF(r);
  }

  static public void _handleException_addHandler(Object handler) {
    addIfNotThere(_handleException_onException, handler);
  }

  static public <A> A assertNull(A a) {
    assertTrue(a == null);
    return a;
  }

  static public <A> A assertNull(String msg, A a) {
    assertTrue(msg, a == null);
    return a;
  }

  static public <A, B> void mapPut(Map<A, B> map, A key, B value) {
    if (map != null && key != null && value != null)
      map.put(key, value);
  }

  static public <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
    if (map != null && p != null)
      map.put(p.a, p.b);
  }

  static public JInternalFrame getInternalFrame(final Object _o) {
    return _o == null ? null : swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JInternalFrame)
              return (JInternalFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public <A extends Component> A internalFrameTitle(A c, final String title) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(unnull(title));
            toolTip(getInternalFrameTitlePaneComponent(f), title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(unnull(title));\r\n    toolTip(getInternalFrameTitlePaneComponent(f)...";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A internalFrameTitle(String title, A c) {
    return internalFrameTitle(c, title);
  }

  static public String internalFrameTitle(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    return f == null ? null : swing(new F0<String>() {

      public String get() {
        try {
          return f.getTitle();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret f.getTitle();";
      }
    });
  }

  static public <A extends Component> A frameTitle(A c, String title) {
    return setFrameTitle(c, title);
  }

  static public <A extends Component> A frameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public String frameTitle(Component c) {
    return getFrameTitle(c);
  }

  static public JFrame getFrame(final Object _o) {
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof JFrame)
              return (JFrame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button...";
      }
    });
  }

  static public Object vmBus_wrapArgs(Object... args) {
    return empty(args) ? null : l(args) == 1 ? args[0] : args;
  }

  static public Set vm_busListeners_live_cache;

  static public Set vm_busListeners_live() {
    if (vm_busListeners_live_cache == null)
      vm_busListeners_live_cache = vm_busListeners_live_load();
    return vm_busListeners_live_cache;
  }

  static public Set vm_busListeners_live_load() {
    return vm_generalIdentityHashSet("busListeners");
  }

  static public Map<String, Set> vm_busListenersByMessage_live_cache;

  static public Map<String, Set> vm_busListenersByMessage_live() {
    if (vm_busListenersByMessage_live_cache == null)
      vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load();
    return vm_busListenersByMessage_live_cache;
  }

  static public Map<String, Set> vm_busListenersByMessage_live_load() {
    return vm_generalHashMap("busListenersByMessage");
  }

  static public Set<AutoCloseable> _registerAutoCloseable_set = synchroHashSet();

  static public void _registerAutoCloseable(AutoCloseable c) {
    addIfNotNull(_registerAutoCloseable_set, c);
  }

  static public void cleanMeUp__registerAutoCloseable() {
    closeAutoCloseables(getAndClearList(_registerAutoCloseable_set));
  }

  static public ArrayList emptyList() {
    return new ArrayList();
  }

  static public ArrayList emptyList(int capacity) {
    return new ArrayList(max(0, capacity));
  }

  static public ArrayList emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  static public ArrayList emptyList(Object[] l) {
    return emptyList(l(l));
  }

  static public <A> ArrayList<A> emptyList(Class<A> c) {
    return new ArrayList();
  }

  static public Object collectionMutex(List l) {
    return l;
  }

  static public Object collectionMutex(Object o) {
    if (o instanceof List)
      return o;
    String c = className(o);
    if (eq(c, "java.util.TreeMap$KeySet"))
      c = className(o = getOpt(o, "m"));
    else if (eq(c, "java.util.HashMap$KeySet"))
      c = className(o = get_raw(o, "this$0"));
    if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
      c = className(o = get_raw(o, "m"));
    return o;
  }

  static public <A> List<A> ll(A... a) {
    ArrayList l = new ArrayList(a.length);
    if (a != null)
      for (A x : a) l.add(x);
    return l;
  }

  static public Throwable innerException(Throwable e) {
    return getInnerException(e);
  }

  static public Map emptyMap() {
    return new HashMap();
  }

  static public <A, B> Map<A, B> cloneMap(Map<A, B> map) {
    if (map == null)
      return new HashMap();
    synchronized (map) {
      return map instanceof TreeMap ? new TreeMap((TreeMap) map) : map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
    }
  }

  static public <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
    List x = emptyList(l);
    if (l != null)
      for (A o : cloneList(l)) x.add(f.get(o));
    return x;
  }

  static public <A> A callFInRealOrMyMC(Object realm, F0<A> f) {
    return f == null ? null : f.get();
  }

  static public <A, B> B callFInRealOrMyMC(Object realm, F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  static public <A, B, C> C callFInRealOrMyMC(Object realm, F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }

  static public <A> void callFInRealOrMyMC(Object realm, VF1<A> f, A a) {
    if (f != null)
      f.get(a);
  }

  static public Object callFInRealOrMyMC(Object realm, Object f, Object... args) {
    if (f instanceof String) {
      Class mc = getMainClass(realm);
      if (hasMethod(mc, ((String) f), args))
        return call(mc, ((String) f), args);
    }
    return callF(f, args);
  }

  static public <A> int iteratorCount_int_close(Iterator<A> i) {
    try {
      int n = 0;
      if (i != null)
        while (i.hasNext()) {
          i.next();
          ++n;
        }
      if (i instanceof AutoCloseable)
        ((AutoCloseable) i).close();
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A shallowCloneToClass(Class<A> c, Object o) {
    if (o == null)
      return null;
    A a = nuInstance(c);
    copyFields(o, a);
    return a;
  }

  static public Object dm_getStem(Object moduleOrID) {
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      moduleOrID = dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_getStemByID(moduleOrID);
    return or(getOpt(dm_getModule(moduleOrID), "_host"), moduleOrID);
  }

  static public Method findMethod_precise_onTypes(Object o, String method, Class... argTypes) {
    try {
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache(((Class) o));
        List<Method> methods = cache.cache.get(method);
        Lowest<Method> best = new Lowest();
        if (methods != null)
          for (Method m : methods) {
            {
              if (!(isStaticMethod(m)))
                continue;
            }
            int score = methodApplicabilityScore_onTypes(m, argTypes);
            if (score < Integer.MAX_VALUE) {
              best.put(m, score);
            }
          }
        return best.get();
      }
      if (o == null)
        return null;
      _MethodCache cache = callOpt_getCache(o.getClass());
      List<Method> methods = cache.cache.get(method);
      Lowest<Method> best = new Lowest();
      if (methods != null)
        for (Method m : methods) {
          int score = methodApplicabilityScore_onTypes(m, argTypes);
          if (score < Integer.MAX_VALUE)
            best.put(m, score);
        }
      return best.get();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public DynModule dm_current_mandatory() {
    return assertNotNull("No module set!", dm_currentModule());
  }

  static public void dm_onTopInput(final VF1<String> r) {
    final DynModule m = dm_current_mandatory();
    dm_ownResource(vmBus_onMessage("topInput", new VF1<String>() {

      public void get(final String s) {
        try {
          m.enter();
          callF(r, s);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.enter();\r\n    callF(r, s)";
      }
    }));
  }

  static public void dm_onTopInput(final Runnable r) {
    final DynModule m = dm_current_mandatory();
    dm_ownResource(vmBus_onMessage("topInput", new VF1<String>() {

      public void get(final String s) {
        try {
          m.enter();
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.enter();\r\n    callF(r)";
      }
    }));
  }

  static public <A> List<A> concatLists(Iterable<A>... lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
    List<A> l = new ArrayList();
    if (lists != null)
      for (Iterable<A> list : lists) addAll(l, list);
    return l;
  }

  static public <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  static public ArrayList<Integer> asList(int[] a) {
    if (a == null)
      return null;
    ArrayList<Integer> l = emptyList(a.length);
    for (int i : a) l.add(i);
    return l;
  }

  static public ArrayList<Float> asList(float[] a) {
    if (a == null)
      return null;
    ArrayList<Float> l = emptyList(a.length);
    for (float i : a) l.add(i);
    return l;
  }

  static public ArrayList<Double> asList(double[] a) {
    if (a == null)
      return null;
    ArrayList<Double> l = emptyList(a.length);
    for (double i : a) l.add(i);
    return l;
  }

  static public <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Producer<A> p) {
    ArrayList l = new ArrayList();
    A a;
    if (p != null)
      while ((a = p.next()) != null) l.add(a);
    return l;
  }

  static public <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, Iterable<B> l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(F2<A, B, A> f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = callF(f, a, b);
    return a;
  }

  static public <A, B> A foldl(Object f, A seed, B[] l) {
    A a = seed;
    if (l != null)
      for (B b : l) a = (A) callF(f, a, b);
    return a;
  }

  static public AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
    return tempSetThreadLocal(print_byThread(), f);
  }

  static public <A> boolean setAdd(Collection<A> c, A a) {
    if (c == null || c.contains(a))
      return false;
    c.add(a);
    return true;
  }

  static public ChangeListener changeListener(final Object r) {
    return new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(r);
      }
    };
  }

  static public ItemListener itemListener(final Object r) {
    return new ItemListener() {

      public void itemStateChanged(ItemEvent e) {
        pcallF(r);
      }
    };
  }

  static public boolean isEditableComboBox(final JComboBox cb) {
    return cb != null && swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return cb.isEditable();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret cb.isEditable();";
      }
    });
  }

  static public JTextField textFieldFromComboBox(JComboBox cb) {
    return (JTextField) cb.getEditor().getEditorComponent();
  }

  static public JComboBox onSelectedItem(final JComboBox cb, final VF1<String> f) {
    addActionListener(cb, new Runnable() {

      public void run() {
        try {
          pcallF(f, selectedItem(cb));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(f, selectedItem(cb))";
      }
    });
    return cb;
  }

  static public Set asSet(Object[] array) {
    HashSet set = new HashSet();
    for (Object o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public Set<String> asSet(String[] array) {
    TreeSet<String> set = new TreeSet();
    for (String o : array) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(Iterable<A> l) {
    if (l instanceof Set)
      return (Set) l;
    HashSet<A> set = new HashSet();
    for (A o : unnull(l)) if (o != null)
      set.add(o);
    return set;
  }

  static public <A> Set<A> asSet(MultiSet<A> ms) {
    return ms == null ? null : ms.asSet();
  }

  static public boolean instanceOf(Object o, String className) {
    if (o == null)
      return false;
    String c = o.getClass().getName();
    return eq(c, className) || eq(c, "main$" + className);
  }

  static public boolean instanceOf(Object o, Class c) {
    if (c == null)
      return false;
    return c.isInstance(o);
  }

  static public boolean instanceOf(Class c, Object o) {
    return instanceOf(o, c);
  }

  static public AbstractAction abstractAction(String name, final Object runnable) {
    return new AbstractAction(name) {

      public void actionPerformed(ActionEvent evt) {
        pcallF(runnable);
      }
    };
  }

  static public void callAction(Action a) {
    if (a != null)
      a.actionPerformed(null);
  }

  static public boolean nemptyString(String s) {
    return s != null && s.length() > 0;
  }

  static public int strL(String s) {
    return s == null ? 0 : s.length();
  }

  static public int listL(Collection l) {
    return l == null ? 0 : l.size();
  }

  static public Map<String, String> humanizeFormLabel_replacements = litmap("id", "ID", "md5", "MD5");

  static public String humanizeFormLabel(String s) {
    if (containsSpace(s))
      return s;
    return firstToUpper(joinWithSpace(replaceElementsUsingMap(splitCamelCase(s), humanizeFormLabel_replacements)).replace("I D", "ID"));
  }

  static public void internalFrameTitlePopupMenu(final JInternalFrame f, final Object... params) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Object menuMaker;
            if (l(params) == 1 && !(params[0] instanceof JMenu))
              menuMaker = params[0];
            else
              menuMaker = new VF1<JPopupMenu>() {

                public void get(JPopupMenu menu) {
                  try {
                    addMenuItems(menu, params);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "addMenuItems(menu, params)";
                }
              };
            Component titleComponent = getInternalFrameTitlePaneComponent(f);
            if (!(titleComponent instanceof JComponent))
              print("Can't add internal frame title popup menu!");
            else {
              componentPopupMenu((JComponent) titleComponent, menuMaker);
              setOpt(componentPopupMenu_initForComponent((JComponent) titleComponent), "internalFrameLeftButtonMagic", isTrue(vm_generalMap_get("internalFramePopupOnLeftButton")));
            }
            componentPopupMenu(f, menuMaker);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Object menuMaker;\r\n    if (l(params) == 1 && !(params[0] instanceof JMenu))\r\n...";
        }
      });
    }
  }

  static public JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
    final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text, checked);
    addActionListener(mi, new Runnable() {

      public void run() {
        try {
          callF(r, isChecked(mi));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(r, isChecked(mi))";
      }
    });
    return mi;
  }

  static public JTextField jtextfield() {
    return jTextField();
  }

  static public JTextField jtextfield(String text) {
    return jTextField(text);
  }

  static public JTextField jtextfield(Object o) {
    return jTextField(o);
  }

  static public int showForm_defaultGap = 4;

  static public int showForm_gapBetweenColumns = 10;

  static public JPanel showFormTitled(final String title, final Object... _parts) {
    JDesktopPane desktop = mainDesktopPane();
    if (desktop != null)
      return showInternalFrameFormTitled(desktop, title, _parts);
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          final Var<JFrame> frame = new Var();
          JPanel panel = showForm_makePanel(false, _parts);
          frame.set(showForm_makeFrame(title, panel));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<JFrame> frame;\r\n    JPanel panel = showForm_makePanel(false, _p...";
      }
    });
  }

  static public JPanel showForm_makePanel(Boolean internalFrame, Object... _parts) {
    List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
    return vstackWithSpacing(out, showForm_defaultGap);
  }

  static public String or2(String a, String b) {
    return nempty(a) ? a : b;
  }

  static public String or2(String a, String b, String c) {
    return or2(or2(a, b), c);
  }

  static public String stringOptPar(Object[] params, String name) {
    return (String) optPar(params, name);
  }

  static public String gtt(JTextComponent c) {
    return getTextTrim(c);
  }

  static public String gtt(JComboBox cb) {
    return getTextTrim(cb);
  }

  static public void dm_doubleFieldSetterDialog(String field, Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    final JTextField tf = jtextfield(get(m, field));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, parseDouble(gtt(tf)));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, parseDouble(gtt(tf)));\r\n      callF(optPar(__, \"onSet\"));";
      }
    });
  }

  static public void dm_stringFieldDialog(final String field, final Object... __) {
    final DynModule m = dm_current_mandatory();
    final String humanized = humanizeFormLabel(field);
    final JTextField tf = jtextfield(get(m, field));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, gtt(tf));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, gtt(tf));\r\n      callF(optPar(__, \"onSet\"));";
      }
    });
  }

  static public void dm_fileFieldDialog(final String field, final Object... __) {
    DynModule m = dm_current_mandatory();
    String humanized = humanizeFormLabel(field);
    JTextField tf = jtextfield(strOrNull(get(m, field)));
    showFormTitled(or2(stringOptPar(__, "formTitle"), "Set " + humanized), humanized + ":", tf, new Runnable() {

      public void run() {
        try {
          m.setField(field, toFile_nullOnEmpty(gtt(tf)));
          callF(optPar(__, "onSet"));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "m.setField(field, toFile_nullOnEmpty(gtt(tf)));\r\n      callF(optPar(__, \"onSe...";
      }
    });
  }

  static public F0<AutoCloseable> dm_rEnter(final DynModule mod) {
    return mod == null ? null : new F0<AutoCloseable>() {

      public AutoCloseable get() {
        try {
          return mod.enter();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mod.enter();";
      }
    };
  }

  static public Q dm_ownQ(Q q) {
    q.rst.enter = dm_rEnter(dm_current_mandatory());
    dm_ownResource(q);
    return q;
  }

  static public Q startQ() {
    return new Q();
  }

  static public Q startQ(String name) {
    return new Q(name);
  }

  static public <A extends JComponent> A setToolTip(A c, Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A setToolTip(Object toolTip, A c) {
    return setToolTipText(c, toolTip);
  }

  static public void setToolTip(TrayIcon trayIcon, String toolTip) {
    setTrayIconToolTip(trayIcon, toolTip);
  }

  static public JLabel jimage(Image img) {
    return jImageLabel(img);
  }

  static public JLabel jimage(String imageID) {
    return jImageLabel(imageID);
  }

  static public String getSnippetTitle(String id) {
    try {
      if (id == null)
        return null;
      if (!isSnippetID(id))
        return "?";
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.getSnippetTitle(id);
      if (isLocalSnippetID(id))
        return localSnippetTitle(id);
      long parsedID = parseSnippetID(id);
      String url;
      if (isImageServerSnippet(parsedID))
        url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
      else if (isGeneralFileServerSnippet(parsedID))
        url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
      else
        url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
      String title = trim(loadPageSilently(url));
      if (title != null)
        try {
          saveTextFileIfChanged(snippetTitle_cacheFile(id), title);
        } catch (Throwable __e) {
          print(exceptionToStringShort(__e));
        }
      return or(title, "?");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getSnippetTitle(long id) {
    return getSnippetTitle(fsI(id));
  }

  static public HashMap litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  static public void litmap_impl(Map map, Object... x) {
    if (x != null)
      for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
        map.put(x[i], x[i + 1]);
  }

  static public <A> Set<A> newWeakHashSet() {
    return synchroWeakHashSet();
  }

  static public void cancelTimers(Collection timers) {
    for (Object timer : timers) cancelTimer(timer);
  }

  static public JPanel jpanel(LayoutManager layout) {
    return swingNu(JPanel.class, layout);
  }

  static public JPanel jpanel() {
    return swingNu(JPanel.class);
  }

  static public JScrollPane setScrollPaneBackground(Color c, JScrollPane sp) {
    if (sp != null && c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            sp.getViewport().setBackground(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "sp.getViewport().setBackground(c);";
        }
      });
    }
    return sp;
  }

  static public Color getBackground(final Component c) {
    return c == null ? null : swing(new F0<Color>() {

      public Color get() {
        try {
          return c.getBackground();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getBackground();";
      }
    });
  }

  static public <A extends JComponent> A withTypeWriterFont(A c) {
    return setFont(c, typeWriterFont());
  }

  static public <A> A swingNu(final Class<A> c, final Object... args) {
    return swingConstruct(c, args);
  }

  static public void clearStringBuffer_gen(Object buf) {
    if (buf != null) {
      call(buf, "setLength", 0);
      call(buf, "trimToSize");
    }
  }

  static public void swingEvery(JComponent component, long delay, Object r) {
    installTimer(component, delay, r);
  }

  static public void swingEvery(JComponent component, long delay, long firstDelay, Object r) {
    installTimer(component, r, delay, firstDelay);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, Object r) {
    installTimer(frame, delay, r);
  }

  static public void swingEvery(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    installTimer(frame, delay, firstDelay, r);
  }

  static public void swingLater(long delay, final Object r) {
    javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
    timer.setRepeats(false);
    timer.start();
  }

  static public void swingLater(Object r) {
    SwingUtilities.invokeLater(toRunnable(r));
  }

  static public Timer installTimer(JComponent component, Object r, long delay) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, Object r) {
    return installTimer(frame.getRootPane(), r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, Object r) {
    return installTimer(component, r, delay, delay);
  }

  static public Timer installTimer(JComponent component, long delay, long firstDelay, Object r) {
    return installTimer(component, r, delay, firstDelay);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay) {
    return installTimer(component, r, delay, firstDelay, true);
  }

  static public Timer installTimer(final JComponent component, final Object r, final long delay, final long firstDelay, final boolean repeats) {
    if (component == null)
      return null;
    return (Timer) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          final Var<Timer> timer = new Var();
          timer.set(new Timer(toInt(delay), new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent _evt) {
              try {
                AutoCloseable __1 = tempActivity(r);
                try {
                  try {
                    if (!allPaused())
                      if (isFalse(callF(r)))
                        cancelTimer(timer.get());
                  } catch (Throwable __e) {
                    _handleException(__e);
                  }
                } finally {
                  _close(__1);
                }
              } catch (Throwable __e) {
                messageBox(__e);
              }
            }
          }));
          timer.get().setInitialDelay(toInt(firstDelay));
          timer.get().setRepeats(repeats);
          bindTimerToComponent(timer.get(), component);
          return timer.get();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final new Var<Timer> timer;\r\n    timer.set(new Timer(toInt(delay), actionList...";
      }
    });
  }

  static public Timer installTimer(RootPaneContainer frame, long delay, long firstDelay, Object r) {
    return installTimer(frame.getRootPane(), delay, firstDelay, r);
  }

  static public StringBuffer liveLocalPrintLog() {
    return local_log;
  }

  static public Map mapKeys(Object func, Map map) {
    Map m = similarEmptyMap(map);
    for (Object key : keys(map)) m.put(callF(func, key), map.get(key));
    return m;
  }

  static public Map mapKeys(Map map, Object func) {
    return mapKeys(func, map);
  }

  static public <A, B, C> Map<B, C> mapKeys(Map<A, C> map, IF1<A, B> func) {
    return mapKeys(map, (Object) func);
  }

  static public <A, B, C> Map<B, C> mapKeys(IF1<A, B> func, Map<A, C> map) {
    return mapKeys(map, func);
  }

  static public <A> List<A> listWithoutSet(Collection<A> l, Collection<A> stuff) {
    return listMinusSet(l, stuff);
  }

  static public Map<Class, List<String>> fieldsInOrder_cache = weakHashMap();

  static public List<String> fieldsInOrder(Object o) {
    return fieldsInOrder(_getClass(o));
  }

  static public List<String> fieldsInOrder(Class c) {
    if (c == null)
      return null;
    synchronized (fieldsInOrder_cache) {
      List<String> fields = fieldsInOrder_cache.get(c);
      if (fields != null)
        return fields;
      String order = toStringOpt(getOpt(c, "_fieldOrder"));
      Set<String> set = asTreeSet(allNonStaticFields(c));
      if (order == null)
        return asList(set);
      fields = splitAtSpace(order);
      setAddAll(fields, set);
      fieldsInOrder_cache.put(c, fields);
      return fields;
    }
  }

  static public Map similarEmptyMap(Map m) {
    if (m instanceof TreeMap)
      return new TreeMap(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashMap();
    return new HashMap();
  }

  static public String getProgramName_cache;

  static public String getProgramName() {
    Lock __0 = downloadLock();
    lock(__0);
    try {
      if (getProgramName_cache == null)
        getProgramName_cache = getSnippetTitleOpt(programID());
      return getProgramName_cache;
    } finally {
      unlock(__0);
    }
  }

  static public void _onLoad_getProgramName() {
    {
      startThread(new Runnable() {

        public void run() {
          try {
            getProgramName();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "getProgramName();";
        }
      });
    }
  }

  static public JTable dataToTable(Object data) {
    return dataToTable(showTable(), data);
  }

  static public JTable dataToTable(Object data, String title) {
    return dataToTable(showTable(title), data);
  }

  static public JTable dataToTable(JTable table, Object data) {
    return dataToTable(table, data, false);
  }

  static public JTable dataToTable(JTable table, Object data, boolean now) {
    List<List> rows = new ArrayList();
    List<String> cols = new ArrayList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrTextForUser(key), structureOrTextForUser(value)));
      }
    } else if (data != null)
      print("Unknown data type: " + data);
    fillTableWithData(table, rows, cols);
    return table;
  }

  static public void makeTableUneditable(JTable table) {
    for (int c = 0; c < table.getColumnCount(); c++) {
      Class<?> col_class = table.getColumnClass(c);
      table.setDefaultEditor(col_class, null);
    }
  }

  static public boolean showTable_searcher = true;

  static public JTable showTable(Object data) {
    return dataToTable_uneditable(data);
  }

  static public JTable showTable(String title, Object data) {
    return showTable(data, title);
  }

  static public JTable showTable(Object data, String title) {
    return dataToTable_uneditable(data, title);
  }

  static public JTable showTable(JTable table, Object data) {
    return showTable(table, data, autoFrameTitle());
  }

  static public JTable showTable(Object data, JTable table) {
    return showTable(table, data);
  }

  static public JTable showTable(JTable table, Object data, String title) {
    if (table == null)
      table = showTable(data, title);
    else {
      setFrameTitle(table, title);
      dataToTable_uneditable(table, data);
    }
    return table;
  }

  static public JTable showTable() {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>());
  }

  static public JTable showTable(String title) {
    return showTable(new ArrayList<List<String>>(), new ArrayList<String>(), title);
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols) {
    return showTable(rows, cols, autoFrameTitle());
  }

  static public JTable showTable(List<List<String>> rows, List<String> cols, String title) {
    JTable tbl = sexyTable();
    fillTableWithStrings(tbl, rows, cols);
    showFrame(title, tbl);
    return tbl;
  }

  static public void tableEnableTextDrag(final JTable table) {
    TransferHandler th = new TransferHandler() {

      @Override
      public int getSourceActions(JComponent c) {
        return COPY;
      }

      @Override
      public Transferable createTransferable(JComponent c) {
        Object o = selectedTableCell(table);
        return new StringSelection(str(o));
      }
    };
    tableEnableDrag(table, th);
  }

  static public JTextField onEnter(final JTextField tf, final Object action) {
    if (action == null || tf == null)
      return tf;
    tf.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          tf.selectAll();
          callF(action);
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    });
    return tf;
  }

  static public JButton onEnter(JButton btn, final Object action) {
    if (action == null || btn == null)
      return btn;
    btn.addActionListener(actionListener(action));
    return btn;
  }

  static public JList onEnter(JList list, Object action) {
    list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
    return list;
  }

  static public JComboBox onEnter(final JComboBox cb, final Object action) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (cb.isEditable()) {
              JTextField text = (JTextField) cb.getEditor().getEditorComponent();
              onEnter(text, action);
            } else {
              cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
              cb.getActionMap().put("enter", abstractAction("", new Runnable() {

                public void run() {
                  try {
                    cb.hidePopup();
                    callF(action);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "cb.hidePopup(); callF(action);";
                }
              }));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (cb.isEditable()) {\r\n      JTextField text = (JTextField) cb.getEditor().g...";
        }
      });
    }
    return cb;
  }

  static public JTable onEnter(final JTable table, final Object action) {
    table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    table.getActionMap().put("Enter", new AbstractAction() {

      public void actionPerformed(ActionEvent e) {
        callF(action, table.getSelectedRow());
      }
    });
    return table;
  }

  static public JTextField onEnter(Object action, JTextField tf) {
    return onEnter(tf, action);
  }

  static public boolean anyValueContainsIgnoreCase(Map map, String pat) {
    for (Object val : values(map)) if (val instanceof String && containsIgnoreCase((String) val, pat))
      return true;
    return false;
  }

  static public List<Map<String, Object>> rawTableData(JTable t) {
    int n = tableRows(t);
    List l = new ArrayList();
    for (int i = 0; i < n; i++) l.add(rawTableLineAsMap(t, i));
    return l;
  }

  public static JComponent withLabel(String label, JComponent component) {
    return westAndCenter(jlabel(label + " "), component);
  }

  static public boolean boolOptPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolOptPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public JPanel northAndCenterWithMargin(Component n, Component c) {
    return northAndCenter(withBottomMargin(n), c);
  }

  static public JPanel northAndCenter(Component n, Component c) {
    return centerAndNorth(c, n);
  }

  static public JScrollPane enclosingScrollPane(Component c) {
    while (c.getParent() != null && !(c.getParent() instanceof JViewport) && c.getParent().getComponentCount() == 1) c = c.getParent();
    if (!(c.getParent() instanceof JViewport))
      return null;
    c = c.getParent().getParent();
    return c instanceof JScrollPane ? (JScrollPane) c : null;
  }

  static public String formatWithThousands(long l) {
    return formatWithThousandsSeparator(l);
  }

  static public double fraction(double d) {
    return d % 1;
  }

  static public String n_fancy2(long l, String singular, String plural) {
    return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
  }

  static public String n_fancy2(Collection l, String singular, String plural) {
    return n_fancy2(l(l), singular, plural);
  }

  static public String n_fancy2(Map m, String singular, String plural) {
    return n_fancy2(l(m), singular, plural);
  }

  static public String n_fancy2(Object[] a, String singular, String plural) {
    return n_fancy2(l(a), singular, plural);
  }

  static public String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }

  static public String getType(Object o) {
    return getClassName(o);
  }

  static public long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  static public long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  static public Object getOptMC(String field) {
    return getOpt(mc(), field);
  }

  static public int tableRows(JTable table) {
    return (int) swingCall(table, "getRowCount");
  }

  static public <A> List<A> syncList() {
    return synchroList();
  }

  static public <A> List<A> syncList(List<A> l) {
    return synchroList(l);
  }

  static public <A> List<A> listGetMulti(final List<A> l, List<Integer> indices) {
    return map(indices, new F1<Integer, A>() {

      public A get(Integer i) {
        try {
          return _get(l, i);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_get(l, i)";
      }
    });
  }

  static public List<Integer> selectedTableRows(final JTable table) {
    return table == null ? null : swing(new F0<List<Integer>>() {

      public List<Integer> get() {
        try {
          return asList(table.getSelectedRows());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret asList(table.getSelectedRows());";
      }
    });
  }

  static public void scrollRowToVisible(JTable t, int rowIndex) {
    int colIndex = 0;
    if (!(t.getParent() instanceof JViewport))
      return;
    JViewport viewport = (JViewport) t.getParent();
    Rectangle rect = t.getCellRect(rowIndex, colIndex, true);
    Rectangle viewRect = viewport.getViewRect();
    int x = viewRect.x;
    int y = viewRect.y;
    if (rect.x >= viewRect.x && rect.x <= (viewRect.x + viewRect.width - rect.width)) {
    } else if (rect.x < viewRect.x) {
      x = rect.x;
    } else if (rect.x > (viewRect.x + viewRect.width - rect.width)) {
      x = rect.x - viewRect.width + rect.width;
    }
    if (rect.y >= viewRect.y && rect.y <= (viewRect.y + viewRect.height - rect.height)) {
    } else if (rect.y < viewRect.y) {
      y = rect.y;
    } else if (rect.y > (viewRect.y + viewRect.height - rect.height)) {
      y = rect.y - viewRect.height + rect.height;
    }
    viewport.setViewPosition(new Point(x, y));
  }

  static public int listRowCount(JList list) {
    return list == null ? 0 : swing(new F0<Integer>() {

      public Integer get() {
        try {
          return list.getModel().getSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret list.getModel().getSize();";
      }
    });
  }

  static public <A> int jlist_indexOf(JList<A> list, A item) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          ListModel<A> model = list.getModel();
          int n = model.getSize();
          for (int i = 0; i < n; i++) if (eq(model.getElementAt(i), item))
            return i;
          return -1;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ListModel<A> model = list.getModel();\r\n    int n = model.getSize();\r\n    for ...";
      }
    });
  }

  static public void tablePopupMenuItem(final JTable table, final String name, final Object action) {
    tablePopupMenu(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, row);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, row)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, row) });";
      }
    });
  }

  static public Thread startThread(Object runnable) {
    return startThread(defaultThreadName(), runnable);
  }

  static public Thread startThread(String name, Object runnable) {
    runnable = wrapAsActivity(runnable);
    return startThread(newThread(toRunnable(runnable), name));
  }

  static public Thread startThread(Thread t) {
    _registerThread(t);
    t.start();
    return t;
  }

  static public void messageBox(final String msg) {
    if (headless())
      print(msg);
    else {
      swing(new Runnable() {

        public void run() {
          try {
            JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MES...";
        }
      });
    }
  }

  static public void messageBox(Throwable e) {
    printStackTrace(e);
    messageBox(hideCredentials(innerException2(e)));
  }

  static public Object[] reverseParams(Object[] params) {
    int n = l(params);
    if (params == null || odd(n))
      return params;
    Object[] a = new Object[n];
    for (int i = 0; i + 1 < n; i += 2) arraycopy(params, i, a, n - i - 2, 2);
    return a;
  }

  static public void tablePopupMenuItem_top(final JTable table, final String name, final Object action) {
    tablePopupMenuFirst(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, row);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, row)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, row) });";
      }
    });
  }

  static public <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
    if (c != null && b != null)
      for (A a : b) c.add(a);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
    return c != null && b != null && c.addAll(b);
  }

  static public <A, B extends A> boolean addAll(Collection<A> c, B... b) {
    return c != null && c.addAll(Arrays.asList(b));
  }

  static public <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null)
      a.putAll(b);
    return a;
  }

  static public File prepareProgramFile(String name) {
    return mkdirsForFile(getProgramFile(name));
  }

  static public File prepareProgramFile(String progID, String name) {
    return mkdirsForFile(getProgramFile(progID, name));
  }

  static public String ymd() {
    return ymd(now());
  }

  static public String ymd(long now) {
    return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
  }

  static public String ymd(long now, TimeZone tz) {
    return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
  }

  static public String spliceString(String a, int from, int to, String b) {
    return takeFirst(a, from) + b + substring(a, max(from, to));
  }

  static public String spliceString(String a, int from, int to, char b) {
    return spliceString(a, from, to, str(b));
  }

  static public <A> List<A> replace(List<A> l, A a, A b) {
    for (int i = 0; i < l(l); i++) if (eq(l.get(i), a))
      l.set(i, b);
    return l;
  }

  static public <A> List<A> replace(A a, A b, List<A> l) {
    return replace(l, a, b);
  }

  static public String replace(String s, String a, String b) {
    return s == null ? null : a == null || b == null ? s : s.replace(a, b);
  }

  static public String replace(String s, char a, char b) {
    return s == null ? null : s.replace(a, b);
  }

  static public String hmsWithColonsAndMS() {
    return hmsWithColonsAndMS(now());
  }

  static public String hmsWithColonsAndMS(long time) {
    return simpleDateFormat_local("HH:mm:ss:SSSS").format(time);
  }

  static public void saveGZStructureToFile(String file, Object o) {
    saveGZStructureToFile(getProgramFile(file), o);
  }

  static public void saveGZStructureToFile(File file, Object o) {
    try {
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      File tempFile = tempFileFor(file);
      if (tempFile.exists())
        try {
          String saveName = tempFile.getPath() + ".saved." + now();
          copyFile(tempFile, new File(saveName));
        } catch (Throwable e) {
          printStackTrace(e);
        }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      try {
        GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        structureToPrintWriter(o, printWriter);
        printWriter.close();
        gos.close();
        fileOutputStream.close();
      } catch (Throwable e) {
        fileOutputStream.close();
        tempFile.delete();
        throw rethrow(e);
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + file.getPath());
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JScrollPane jscroll_centered(Component c) {
    return jscroll(jFullCenter(c));
  }

  static public int imageIcon_cacheSize = 10;

  static public boolean imageIcon_verbose = false;

  static public Map<String, ImageIcon> imageIcon_cache;

  static public Lock imageIcon_lock = lock();

  static public ThreadLocal<Boolean> imageIcon_fixGIF = new ThreadLocal();

  static public ImageIcon imageIcon(String imageID) {
    try {
      if (imageID == null)
        return null;
      Lock __0 = imageIcon_lock;
      lock(__0);
      try {
        if (imageIcon_cache == null)
          imageIcon_cache = new MRUCache(imageIcon_cacheSize);
        imageID = fsI(imageID);
        ImageIcon ii = imageIcon_cache.get(imageID);
        if (ii == null) {
          if (imageIcon_verbose)
            print("Loading image icon: " + imageID);
          File f = loadBinarySnippet(imageID);
          Boolean b = imageIcon_fixGIF.get();
          if (!isFalse(b))
            ii = new ImageIcon(loadBufferedImageFixingGIFs(f));
          else
            ii = new ImageIcon(f.toURI().toURL());
        } else
          imageIcon_cache.remove(imageID);
        imageIcon_cache.put(imageID, ii);
        return ii;
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(File f) {
    try {
      return new ImageIcon(f.toURI().toURL());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ImageIcon imageIcon(Image img) {
    return new ImageIcon(img);
  }

  static public ImageIcon imageIcon(RGBImage img) {
    return imageIcon(img.getBufferedImage());
  }

  static public boolean loadBufferedImage_useImageCache = true;

  static public BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) {
    try {
      ping();
      if (snippetIDOrURLOrFile == null)
        return null;
      if (isURL(snippetIDOrURLOrFile))
        return imageIO_readURL(snippetIDOrURLOrFile);
      if (isAbsolutePath(snippetIDOrURLOrFile))
        return loadBufferedImage(new File(snippetIDOrURLOrFile));
      if (!isSnippetID(snippetIDOrURLOrFile))
        throw fail("Not a URL or snippet ID or file: " + snippetIDOrURLOrFile);
      String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return loadBufferedImage(rl.loadLibrary(snippetID));
      File dir = imageSnippetsCacheDir();
      if (loadBufferedImage_useImageCache) {
        dir.mkdirs();
        File file = new File(dir, snippetID + ".png");
        if (file.exists() && file.length() != 0)
          try {
            return ImageIO.read(file);
          } catch (Throwable e) {
            e.printStackTrace();
          }
      }
      String imageURL = snippetImageURL_http(snippetID);
      print("Loading image: " + imageURL);
      BufferedImage image = imageIO_readURL(imageURL);
      if (loadBufferedImage_useImageCache) {
        File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
        ImageIO.write(image, "png", tempFile);
        tempFile.renameTo(new File(dir, snippetID + ".png"));
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage loadBufferedImage(File file) {
    try {
      return file.isFile() ? ImageIO.read(file) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  static public class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  static public CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  static public void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n2(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  static public String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  static public String f2s(String s) {
    return f2s(newFile(s));
  }

  static public String f2s(java.nio.file.Path p) {
    return p == null ? null : f2s(p.toFile());
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  static public boolean infoMessage_alwaysOnTop = true;

  static public double infoMessage_defaultTime = 5.0;

  static public JWindow infoMessage(String text) {
    return infoMessage(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage(final String text, final double seconds) {
    printHidingCredentials(text);
    return infoMessage_noprint(text, seconds);
  }

  static public JWindow infoMessage_noprint(String text) {
    return infoMessage_noprint(text, infoMessage_defaultTime);
  }

  static public JWindow infoMessage_noprint(final String _text, final double seconds) {
    final String text = hideCredentials(_text);
    if (empty(text))
      return null;
    logQuotedWithDate(infoBoxesLogFile(), text);
    if (isHeadless())
      return null;
    return (JWindow) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          final JWindow window = showWindow(infoMessage_makePanel(text));
          window.setSize(300, 150);
          moveToTopRightCorner(window);
          if (infoMessage_alwaysOnTop)
            window.setAlwaysOnTop(true);
          if (vmBus_noObjections("shouldShowInfoBox", window, text))
            window.setVisible(true);
          if (seconds != 0)
            disposeWindowAfter(iround(seconds * 1000), window);
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JWindow window = showWindow(infoMessage_makePanel(text));\r\n    window.s...";
      }
    });
  }

  static public JWindow infoMessage(Throwable e) {
    printStackTrace(e);
    return infoMessage(exceptionToStringShort(e));
  }

  static public long fileSize(String path) {
    return getFileSize(path);
  }

  static public long fileSize(File f) {
    return getFileSize(f);
  }

  static public void internalFrameTitlePopupMenuItem(JInternalFrame f, final String name, final Object action) {
    internalFrameTitlePopupMenu(f, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          addMenuItem(menu, name, action);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, action)";
      }
    });
  }

  static public Object pcallFunction(Object f, Object... args) {
    try {
      return callFunction(f, args);
    } catch (Throwable __e) {
      _handleException(__e);
    }
    return null;
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  static public String strOrNull(Object o) {
    return o == null ? null : str(o);
  }

  static public String _userHome;

  static public String userHome() {
    if (_userHome == null)
      return actualUserHome();
    return _userHome;
  }

  static public File userHome(String path) {
    return new File(userDir(), path);
  }

  static public File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  static public File newFile(String name) {
    return name == null ? null : new File(name);
  }

  static public File newFile(String base, String... names) {
    return newFile(newFile(base), names);
  }

  static public int iround(double d) {
    return (int) Math.round(d);
  }

  static public int iround(Number n) {
    return iround(toDouble(n));
  }

  static public void listPopupMenuItem(final JList list, final String name, final Object action) {
    listPopupMenu(list, new VF2<JPopupMenu, String>() {

      public void get(JPopupMenu menu, final String item) {
        try {
          addMenuItem(menu, name, new Runnable() {

            public void run() {
              try {
                pcallF(action, item);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "pcallF(action, item)";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, name, r { pcallF(action, item) });";
      }
    });
  }

  static public String copyTextToClipboardIfNotNull(String text) {
    if (text != null)
      copyTextToClipboard(text);
    return text;
  }

  static public String getSelectedItem(JList l) {
    return (String) l.getSelectedValue();
  }

  static public String getSelectedItem(JComboBox cb) {
    return strOrNull(cb.getSelectedItem());
  }

  static public void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  static public boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  static public boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  static public <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  static public <A> void put(List<A> l, int i, A a) {
    if (l != null && i >= 0 && i < l(l))
      l.set(i, a);
  }

  static public List<Pair> _registerDangerousWeakMap_preList;

  static public <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  static public <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) init;
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    call(javax(), "_registerDangerousWeakMap", map, init);
    return map;
  }

  static public void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  static public <A, B> B mapGet2(Map<A, B> map, A a) {
    return map == null ? null : map.get(a);
  }

  static public <A, B> B mapGet2(A a, Map<A, B> map) {
    return map == null ? null : map.get(a);
  }

  static public boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  static public Set<String> reflection_classesNotToScan_value = litset("jdk.internal.loader.URLClassPath");

  static public Set<String> reflection_classesNotToScan() {
    return reflection_classesNotToScan_value;
  }

  static public Map<String, Integer> tableColumnWidthsByName(JTable table) {
    TableColumnModel tcm = table.getColumnModel();
    if (tcm == null)
      return null;
    int n = tcm.getColumnCount();
    TreeMap<String, Integer> map = new TreeMap();
    for (int i = 0; i < n; i++) {
      TableColumn tc = tcm.getColumn(i);
      map.put(str(tc.getHeaderValue()), tc.getWidth());
    }
    return map;
  }

  static public int tableColumnCount(JTable table) {
    return tableNumColumns(table);
  }

  static public boolean tableSetColumnPreferredWidths_debug = false;

  static public void tableSetColumnPreferredWidths(final JTable table, final Map<String, Integer> widths) {
    if (table == null || widths == null)
      return;
    {
      swing(new Runnable() {

        public void run() {
          try {
            try {
              TableColumnModel tcm = table.getColumnModel();
              int n = tcm.getColumnCount();
              for (int i = 0; i < n; i++) {
                TableColumn tc = tcm.getColumn(i);
                Integer w = widths.get(str(tc.getHeaderValue()));
                if (w != null) {
                  tc.setPreferredWidth(w);
                  if (tableSetColumnPreferredWidths_debug)
                    print("Setting preferred width of column " + i + " to " + w);
                }
              }
            } catch (Throwable __e) {
              _handleException(__e);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "pcall {\r\n    TableColumnModel tcm = table.getColumnModel();\r\n    int n = tcm....";
        }
      });
    }
  }

  static public void tableSetColumnPreferredWidths(JTable table, Object... widths) {
    tableSetColumnPreferredWidths(table, litorderedmap(widths));
  }

  static public String getStackTrace2(Throwable e) {
    return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(innerException2(e)))) + "\n");
  }

  static public String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  static public String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  static public String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  static public Class __javax;

  static public Class getJavaX() {
    try {
      return __javax;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A extends Throwable> A printException(A e) {
    printStackTrace(e);
    return e;
  }

  static public <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
    if (map instanceof LinkedHashMap)
      return (LinkedHashMap) map;
    LinkedHashMap<A, B> m = new LinkedHashMap();
    if (map != null)
      synchronized (collectionMutex(map)) {
        m.putAll(map);
      }
    return m;
  }

  static public void setDynObjectValue(DynamicObject o, String field, Object value) {
    o.fieldValues = syncMapPut2_createLinkedHashMap(o.fieldValues, field, value);
  }

  static public List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  static public List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  static final public Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

  static public Object callOpt_cached(Object o, String methodName, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Class c = (Class) o;
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null || (me.getModifiers() & Modifier.STATIC) == 0)
          return null;
        return invokeMethod(me, null, args);
      } else {
        Class c = o.getClass();
        _MethodCache cache = callOpt_getCache(c);
        Method me = cache.findMethod(methodName, args);
        if (me == null)
          return null;
        return invokeMethod(me, o, args);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public _MethodCache callOpt_getCache(Class c) {
    synchronized (callOpt_cache) {
      _MethodCache cache = callOpt_cache.get(c);
      if (cache == null)
        callOpt_cache.put(c, cache = new _MethodCache(c));
      return cache;
    }
  }

  static public boolean isStaticMethod(Method m) {
    return methodIsStatic(m);
  }

  static public Object[] massageArgsForVarArgsCall(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    int n = types.length - 1, nArgs = args.length;
    if (nArgs < n)
      return null;
    for (int i = 0; i < n; i++) if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
    Class varArgType = types[n].getComponentType();
    for (int i = n; i < nArgs; i++) if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
    Object[] newArgs = new Object[n + 1];
    arraycopy(args, 0, newArgs, 0, n);
    Object[] varArgs = arrayOfType(varArgType, nArgs - n);
    arraycopy(args, n, varArgs, 0, nArgs - n);
    newArgs[n] = varArgs;
    return newArgs;
  }

  static public <A> String joinWithComma(Collection<A> c) {
    return join(", ", c);
  }

  static public String joinWithComma(String... c) {
    return join(", ", c);
  }

  static public String joinWithComma(Pair p) {
    return p == null ? "" : joinWithComma(str(p.a), str(p.b));
  }

  static public CharSequence subCharSequence(CharSequence s, int x) {
    return subCharSequence(s, x, s == null ? 0 : s.length());
  }

  static public CharSequence subCharSequence(CharSequence s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.subSequence(x, y);
  }

  static public String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  static volatile public boolean licensed_yes = true;

  static public boolean licensed() {
    if (!licensed_yes)
      return false;
    ping_okInCleanUp();
    return true;
  }

  static public void licensed_off() {
    licensed_yes = false;
  }

  static public AutoCloseable tempActivity(Object r) {
    return null;
  }

  static public long fixTimestamp(long timestamp) {
    return timestamp > now() ? 0 : timestamp;
  }

  static public long now_virtualTime;

  static public long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  static public int boolToInt(boolean b) {
    return b ? 1 : 0;
  }

  static public Object costCenter() {
    return mc();
  }

  static public void failIfUnlicensed() {
    assertTrue("license off", licensed());
  }

  static public boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  static public boolean isInteger(String s) {
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public DialogIO talkToSubBot(final long vport, final DialogIO io) {
    return talkToSubBot(String.valueOf(vport), io);
  }

  static public DialogIO talkToSubBot(final String subBot, final DialogIO io) {
    if (subBot == null)
      return io;
    return new talkToSubBot_IO(subBot, io);
  }

  static public class talkToSubBot_IO extends DialogIO {

    public String subBot;

    public DialogIO io;

    public talkToSubBot_IO(String subBot, DialogIO io) {
      this.io = io;
      this.subBot = subBot;
    }

    public boolean isStillConnected() {
      return io.isStillConnected();
    }

    public String readLineImpl() {
      return io.readLineImpl();
    }

    public boolean isLocalConnection() {
      return io.isLocalConnection();
    }

    public Socket getSocket() {
      return io.getSocket();
    }

    public void close() {
      try {
        io.close();
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void sendLine(String line) {
      io.sendLine(format3("please forward to bot *: *", subBot, line));
    }
  }

  static public int indexOfIgnoreCase(List<String> a, String b) {
    return indexOfIgnoreCase(a, b, 0);
  }

  static public int indexOfIgnoreCase(List<String> a, String b, int i) {
    int n = a == null ? 0 : a.size();
    for (; i < n; i++) if (eqic(a.get(i), b))
      return i;
    return -1;
  }

  static public int indexOfIgnoreCase(String a, String b) {
    return indexOfIgnoreCase_manual(a, b);
  }

  static public int indexOfIgnoreCase(String a, String b, int i) {
    return indexOfIgnoreCase_manual(a, b, i);
  }

  static public List<ProgramScan.Program> quickBotScan() {
    return ProgramScan.quickBotScan();
  }

  static public List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
    return ProgramScan.quickBotScan(preferredPorts);
  }

  static public List<ProgramScan.Program> quickBotScan(String searchPattern) {
    List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
    for (ProgramScan.Program p : ProgramScan.quickBotScan()) if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
    return l;
  }

  static public String firstPartOfHelloString(String s) {
    int i = s.lastIndexOf('/');
    return i < 0 ? s : rtrim(s.substring(0, i));
  }

  static public Object unstructure(String text) {
    return unstructure(text, false);
  }

  static public Object unstructure(String text, final boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  static public int structure_internStringsLongerThan = 50;

  static public int unstructure_unquoteBufSize = 100;

  static public int unstructure_tokrefs;

  abstract static public class unstructure_Receiver {

    abstract public void set(Object o);
  }

  static public Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  static public Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  static public Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      final public Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public String curT;

      public char[] unquoteBuf = new char[unstructure_unquoteBufSize];

      public Class findAClass(String fullClassName) {
        return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
      }

      public String unquote(String s) {
        return unquoteUsingCharArray(s, unquoteBuf);
      }

      public String t() {
        return curT;
      }

      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID = 0;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        }
        final int _refID = refID;
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (_refID != 0)
              refs.put(_refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
        String t = t();
        Class c = classesMap.get(t);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("sh")) {
            consume();
            t = tpp();
            if (t.equals("-")) {
              t = tpp();
              out.set((short) (-parseInt(t)));
              return;
            }
            out.set((short) parseInt(t));
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              throw fail("unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              throw fail("unsatisfied token reference " + ref + " at " + tokIndex);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("lhs")) {
            parseLinkedHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (t.equals("ciset")) {
            parseCISet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("tm")) {
            consume();
            parseMap(new TreeMap(), out);
            return;
          }
          if (t.equals("cimap")) {
            consume();
            parseMap(ciMap(), out);
            return;
          }
          if (t.equals("ll")) {
            consume();
            {
              parseList(new LinkedList(), out);
              return;
            }
          }
          if (t.equals("syncLL")) {
            consume();
            {
              parseList(synchroLinkedList(), out);
              return;
            }
          }
          if (t.equals("sync")) {
            consume();
            {
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  if (value instanceof Map) {
                    if (value instanceof NavigableMap) {
                      out.set(Collections.synchronizedNavigableMap((NavigableMap) value));
                      return;
                    }
                    if (value instanceof SortedMap) {
                      out.set(Collections.synchronizedSortedMap((SortedMap) value));
                      return;
                    }
                    {
                      out.set(Collections.synchronizedMap((Map) value));
                      return;
                    }
                  } else {
                    out.set(Collections.synchronizedList((List) value));
                    return;
                  }
                }
              });
              return;
            }
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            this.parseList(new ArrayList(), out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray") || t.equals("dblarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume();
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
          if (eq(t, "cu")) {
            consume();
            t = tpp();
            assertTrue(isJavaIdentifier(t));
            String fullClassName = "main$" + t;
            Class _c = findAClass(fullClassName);
            if (_c == null)
              throw fail("Class not found: " + fullClassName);
            parse(new unstructure_Receiver() {

              public void set(Object value) {
                out.set(call(_c, "_deserialize", value));
              }
            });
            return;
          }
        }
        if (eq(t, "j")) {
          consume("j");
          out.set(parseJava());
          return;
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + quote(t));
        consume();
        String className, fullClassName;
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = "main$" + t;
        }
        if (c == null) {
          if (allDynamic)
            c = null;
          else
            c = findAClass(fullClassName);
          if (c != null)
            classesMap.put(className, c);
        }
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && eq(t(), "this$1");
        DynamicObject dO = null;
        Object o = null;
        final String thingName = t;
        if (c != null) {
          o = hasOuter ? nuStubInnerObject(c, classFinder) : nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findAClass("main$Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = className;
        }
        if (refID != 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        final LinkedHashMap<String, Object> fields = new LinkedHashMap();
        final Object _o = o;
        final DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ","))
                  consume();
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields, hasOuter);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  String t = tpp();
                  if (!eq(t, "="))
                    throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName);
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())...";
            }
          });
        } else {
          objRead(o, dO, fields, hasOuter);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
        if (o != null) {
          if (dO != null) {
            setOptAllDyn_pcall(dO, fields);
          } else {
            setOptAll_pcall(o, fields);
          }
          if (hasOuter)
            fixOuterRefs(o);
        } else
          for (Map.Entry<String, Object> e : fields.entrySet()) setDynObjectValue(dO, intern(e.getKey()), e.getValue());
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        this.parseList(new ArrayList(), new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        throw fail("class Lisp not included");
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ...";
          }
        });
      }

      public void parseList(final List list, final unstructure_Receiver out) {
        tokrefs.put(i, list);
        consume("[");
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume();
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r...";
          }
        });
      }

      public void parseArray(final unstructure_Receiver out) {
        final String type = tpp();
        consume("{");
        final List list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(type.equals("intarray") ? toIntArray(list) : type.equals("dblarray") ? toDoubleArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(\r\n           ...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        Class c = allDynamic ? null : findAClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        name = dropPrefix("main$", name);
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseLinkedHashSet(unstructure_Receiver out) {
        consume("lhs");
        parseSet(new LinkedHashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseCISet(unstructure_Receiver out) {
        consume("ciset");
        parseSet(ciSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v = false;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              if (!eq(tpp(), "="))
                throw fail("= expected, got " + t() + " in map of size " + l(map));
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          }
        });
      }

      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_initial(unstructure_Receiver out) {
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
    Boolean b = tlLoading.get();
    tlLoading.set(true);
    try {
      final Var v = new Var();
      X x = new X();
      x.parse_initial(new unstructure_Receiver() {

        public void set(Object o) {
          v.set(o);
        }
      });
      unstructure_tokrefs = x.tokrefs.size();
      return v.get();
    } finally {
      tlLoading.set(b);
    }
  }

  static public boolean unstructure_debug = false;

  static public Object nuObject(String className, Object... args) {
    try {
      return nuObject(classForName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObject(Class<A> c, Object... args) {
    try {
      if (args.length == 0)
        return nuObjectWithoutArguments(c);
      Constructor m = nuObject_findConstructor(c, args);
      makeAccessible(m);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  static public boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public Map<String, Font> loadFont_cached_cache = new HashMap();

  static synchronized public Font loadFont_cached(String snippetID) {
    try {
      snippetID = formatSnippetID(snippetID);
      Font f = loadFont_cached_cache.get(snippetID);
      if (f == null)
        loadFont_cached_cache.put(snippetID, f = loadFont(snippetID, 12f));
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static synchronized public Font loadFont_cached(String snippetID, float size) {
    try {
      return loadFont_cached(snippetID).deriveFont(size);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public JTextArea jTextAreaWithUndo() {
    return jTextAreaWithUndo("");
  }

  static public JTextArea jTextAreaWithUndo(final String text) {
    return jenableUndoRedo(swingNu(JTextArea.class, text));
  }

  static public float getSwingFontScale() {
    return or((Float) vm_generalMap_get("swingFontScale_value"), 1f);
  }

  static public <A> A assertEquals(Object x, A y) {
    return assertEquals(null, x, y);
  }

  static public <A> A assertEquals(String msg, Object x, A y) {
    if (assertVerbose())
      return assertEqualsVerbose(msg, x, y);
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  static public List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      i = j;
    }
    return tok;
  }

  static public <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  static public <A> List<A> popLast(int n, List<A> l) {
    return liftLast(n, l);
  }

  static public Method findMethodNamed(Object obj, String method) {
    if (obj == null)
      return null;
    if (obj instanceof Class)
      return findMethodNamed((Class) obj, method);
    return findMethodNamed(obj.getClass(), method);
  }

  static public Method findMethodNamed(Class c, String method) {
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public void quoteToPrintWriter(String s, PrintWriter out) {
    if (s == null) {
      out.print("null");
      return;
    }
    out.print('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"') {
        out.print('\\');
        out.print(c);
      } else if (c == '\r')
        out.print("\\r");
      else if (c == '\n')
        out.print("\\n");
      else if (c == '\0')
        out.print("\\0");
      else
        out.print(c);
    }
    out.print('"');
  }

  static public String quoteCharacter(char c) {
    if (c == '\'')
      return "'\\''";
    if (c == '\\')
      return "'\\\\'";
    if (c == '\r')
      return "'\\r'";
    if (c == '\n')
      return "'\\n'";
    if (c == '\t')
      return "'\\t'";
    return "'" + c + "'";
  }

  static public boolean isCISet_gen(Iterable<String> l) {
    return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
  }

  static public boolean isJavaXClassName(String s) {
    return startsWithOneOf(s, "main$", "loadableUtils.");
  }

  static public <A> List<A> unwrapSynchronizedList(List<A> l) {
    if (eqOneOf(className(l), "java.util.Collections$SynchronizedList", "java.util.Collections$SynchronizedRandomAccessList"))
      return (List) get_raw(l, "list");
    return l;
  }

  static public boolean isCIMap_gen(Map map) {
    return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
  }

  static public <A, B> Map<A, B> unwrapSynchronizedMap(Map<A, B> map) {
    if (eqOneOf(className(map), "java.util.Collections$SynchronizedMap", "java.util.Collections$SynchronizedSortedMap", "java.util.Collections$SynchronizedNavigableMap"))
      return (Map) get_raw(map, "m");
    return map;
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  static public String boolArrayToHex(boolean[] a) {
    return bytesToHex(boolArrayToBytes(a));
  }

  static public Iterator emptyIterator() {
    return Collections.emptyIterator();
  }

  static public String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  static public String shortDynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    return shortClassName(o);
  }

  static public int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  static public int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  static public int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  static public int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  static public Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

  static public Field[] getDeclaredFields_cached(Class c) {
    Field[] fields;
    synchronized (getDeclaredFields_cache) {
      fields = getDeclaredFields_cache.get(c);
      if (fields == null) {
        getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
        for (Field f : fields) makeAccessible(f);
      }
    }
    return fields;
  }

  static public boolean startsWithDigit(String s) {
    return nempty(s) && isDigit(s.charAt(0));
  }

  static public <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A, ? extends B> b) {
    if (a != null && b != null)
      a.putAll(b);
    return a;
  }

  static public int countDots(String s) {
    int n = l(s), count = 0;
    for (int i = 0; i < n; i++) if (s.charAt(i) == '.')
      ++count;
    return count;
  }

  static public String beautifyStructure(String s) {
    List<String> tok = javaTokForStructure(s);
    structure_addTokenMarkers(tok);
    jreplace(tok, "lhm", "");
    return join(tok);
  }

  static public String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  static public int toInt_checked(long l) {
    if (l != (int) l)
      throw fail("Too large for int: " + l);
    return (int) l;
  }

  static public boolean startsWithOneOf(String s, String... l) {
    for (String x : l) if (startsWith(s, x))
      return true;
    return false;
  }

  static public boolean startsWithOneOf(String s, Matches m, String... l) {
    for (String x : l) if (startsWith(s, x, m))
      return true;
    return false;
  }

  static public boolean isAGIBlueDomain(String domain) {
    return domainIsUnder(domain, theAGIBlueDomain());
  }

  static public String hostNameFromURL(String url) {
    try {
      return new URL(url).getHost();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void ensureDBNotRunning(String name) {
    if (hasBot(name)) {
      try {
        String framesBot = dropSuffix(".", name) + " Frames";
        print("Trying to activate frames of running DB: " + framesBot);
        if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
          cleanKill();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      throw fail("Already running: " + name);
    }
  }

  static public void ensureDBNotRunning() {
    ensureDBNotRunning(dbBotStandardName());
  }

  static public String dbBotStandardName() {
    String home = userHome();
    String name = dbBotName(getDBProgramID());
    if (neq(home, actualUserHome()))
      name += " " + quote(home);
    return name + ".";
  }

  static volatile public Android3 dbBot_instance;

  static public Android3 dbBot() {
    return dbBot(dbBotStandardName());
  }

  static public Android3 dbBot(String name) {
    ensureDBNotRunning(name);
    return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
  }

  static public void thinAProgramsBackups(String progID, boolean doIt) {
    List<File> files = new ArrayList();
    Map<File, Double> ageMap = new HashMap();
    java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$");
    File dir = programDir(progID);
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      java.util.regex.Matcher matcher = pat.matcher(s);
      {
        if (!(matcher.find()))
          continue;
      }
      String originalName = matcher.group(1);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      int year = matcherInt(matcher, 2);
      int month = matcherInt(matcher, 3);
      int day = matcherInt(matcher, 4);
      int hour = matcherInt(matcher, 5);
      long time = timestampFromYMDH(year, month, day, hour);
      double age = ((now() - time) / 1000.0 / 60 / 60 / 24);
      ageMap.put(f, age);
      files.add(f);
    }
    int numDeleted = 0;
    sortByMap_inPlace(files, ageMap);
    double lastAge = -1;
    for (File f : files) {
      double age = ageMap.get(f);
      if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
        ++numDeleted;
        if (doIt) {
          print("Deleting: " + f);
          f.delete();
        }
      } else {
        lastAge = age;
      }
    }
    if (numDeleted != 0)
      print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
  }

  static public boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
    return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
  }

  static public String getDBProgramID_id;

  static public String getDBProgramID() {
    return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
  }

  static public boolean odd(int i) {
    return (i & 1) != 0;
  }

  static public boolean odd(long i) {
    return (i & 1) != 0;
  }

  static public boolean odd(BigInteger i) {
    return odd(toInt(i));
  }

  static public String singleFieldName(Class c) {
    Set<String> l = listFields(c);
    if (l(l) != 1)
      throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
    return first(l);
  }

  static public Object deref(Object o) {
    if (o instanceof Derefable)
      o = ((Derefable) o).get();
    return o;
  }

  static public String intern(String s) {
    return fastIntern(s);
  }

  static public <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
    if (key != null)
      if (value != null) {
        if (map == null)
          map = new LinkedHashMap();
        synchronized (collectionMutex(map)) {
          map.put(key, value);
        }
      } else if (map != null)
        synchronized (collectionMutex(map)) {
          map.remove(key);
        }
    return map;
  }

  static public String assertIdentifier(String s) {
    return assertIsIdentifier(s);
  }

  static public String assertIdentifier(String msg, String s) {
    return assertIsIdentifier(msg, s);
  }

  static public Object derefRef(Object o) {
    if (o instanceof Concept.Ref)
      o = ((Concept.Ref) o).get();
    return o;
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
    return lambdaMap(f, l);
  }

  static public <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
    return lambdaMap(f, l);
  }

  static public boolean isTransient(Field f) {
    return (f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) != 0;
  }

  static public int[] emptyIntArray_a = new int[0];

  static public int[] emptyIntArray() {
    return emptyIntArray_a;
  }

  static public char[] emptyCharArray = new char[0];

  static public char[] emptyCharArray() {
    return emptyCharArray;
  }

  static public double[] emptyDoubleArray = new double[0];

  static public double[] emptyDoubleArray() {
    return emptyDoubleArray;
  }

  static public Object[] emptyObjectArray_a = new Object[0];

  static public Object[] emptyObjectArray() {
    return emptyObjectArray_a;
  }

  static public Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

  static public List<String> parse3_cachedInput(String s) {
    List<String> tok = parse3_cachedInput_cache.get(s);
    if (tok == null)
      parse3_cachedInput_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

  static synchronized public List<String> parse3_cachedPattern(String s) {
    List<String> tok = parse3_cachedPattern_cache.get(s);
    if (tok == null)
      parse3_cachedPattern_cache.put(s, tok = parse3(s));
    return tok;
  }

  static public String[] match2(List<String> pat, List<String> tok) {
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  static public String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (!equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  static public Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  static public Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  static public Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  static public Map vm_generalMap_map;

  static public Map vm_generalMap() {
    if (vm_generalMap_map == null)
      vm_generalMap_map = (Map) get(javax(), "generalMap");
    return vm_generalMap_map;
  }

  static public <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
    if (map != null && key != null)
      if (value != null)
        return map.put(key, value);
      else
        return map.remove(key);
    return null;
  }

  static public <A> Set<A> synchronizedSet() {
    return synchroHashSet();
  }

  static public <A> Set<A> synchronizedSet(Set<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public <A> Set<A> identityHashSet() {
    return Collections.newSetFromMap(new IdentityHashMap());
  }

  static volatile public Object isAllowed_function;

  static volatile public boolean isAllowed_all = true;

  static public boolean isAllowed(String askingMethod, Object... args) {
    Object f = vm_generalMap_get("isAllowed_function");
    if (f != null && !isTrue(callF(f, askingMethod, args)))
      return false;
    return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
  }

  static volatile public PersistableThrowable lastException_lastException;

  static public PersistableThrowable lastException() {
    return lastException_lastException;
  }

  static public void lastException(Throwable e) {
    lastException_lastException = persistableThrowable(e);
  }

  static public Throwable getInnerException(Throwable e) {
    if (e == null)
      return null;
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  static public Throwable getInnerException(Runnable r) {
    return getInnerException(getException(r));
  }

  static public String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  static public String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  static public String prependIfNempty(String prefix, String s) {
    return empty(s) ? unnull(s) : prefix + s;
  }

  static volatile public boolean sleep_noSleep = false;

  static public void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static public void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long round(double d) {
    return Math.round(d);
  }

  static public File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  static public File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  static public String hmsWithColons() {
    return hmsWithColons(now());
  }

  static public String hmsWithColons(long time) {
    return new SimpleDateFormat("HH:mm:ss").format(time);
  }

  static public <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
    return optPar(tl, defaultValue);
  }

  static public <A> A optParam(ThreadLocal<A> tl) {
    return optPar(tl);
  }

  static public Object optParam(String name, Map params) {
    return mapGet(params, name);
  }

  static public <A> A optParam(Object[] opt, String name, A defaultValue) {
    int n = l(opt);
    if (n == 1 && opt[0] instanceof Map) {
      Map map = (Map) (opt[0]);
      return map.containsKey(name) ? (A) map.get(name) : defaultValue;
    }
    if (!even(l(opt)))
      throw fail("Odd parameter length");
    for (int i = 0; i < l(opt); i += 2) if (eq(opt[i], name))
      return (A) opt[i + 1];
    return defaultValue;
  }

  static public Object optParam(Object[] opt, String name) {
    return optParam(opt, name, null);
  }

  static public Object optParam(String name, Object[] params) {
    return optParam(params, name);
  }

  static public String getComputerID_quick() {
    return computerID();
  }

  static public String joinNemptiesWithColonSpace(String... strings) {
    return joinNempties(": ", strings);
  }

  static public String joinNemptiesWithColonSpace(Collection<String> strings) {
    return joinNempties(": ", strings);
  }

  static public String tryToReadErrorStreamFromURLConnection(URLConnection conn) {
    try {
      if (conn instanceof HttpURLConnection)
        return stream2string(((HttpURLConnection) conn).getErrorStream());
      return null;
    } catch (Throwable __e) {
      return null;
    }
  }

  static public int gzInputStream_defaultBufferSize = 65536;

  static public GZIPInputStream gzInputStream(File f) {
    try {
      return gzInputStream(new FileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(File f, int bufferSize) {
    try {
      return gzInputStream(new FileInputStream(f), bufferSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public GZIPInputStream gzInputStream(InputStream in) {
    return gzInputStream(in, gzInputStream_defaultBufferSize);
  }

  static public GZIPInputStream gzInputStream(InputStream in, int bufferSize) {
    try {
      return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  static public boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  static public boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b))
      return false;
    m.m = new String[] { dropLast(l(b), a) };
    return true;
  }

  static public byte[] toUtf8(String s) {
    try {
      return s.getBytes(utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

  static public java.util.regex.Pattern compileRegexp(String pat) {
    java.util.regex.Pattern p = compileRegexp_cache.get(pat);
    if (p == null) {
      compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
    }
    return p;
  }

  static public String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  static public long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  static public File localSnippetFile(long snippetID) {
    return localSnippetsDir(snippetID + ".text");
  }

  static public File localSnippetFile(String snippetID) {
    return localSnippetFile(parseSnippetID(snippetID));
  }

  static public <A> A proxy(Class<A> intrface, final Object target) {
    if (target == null)
      return null;
    if (isInstance(intrface, target))
      return (A) target;
    return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(), new Class[] { intrface }, new proxy_InvocationHandler(target));
  }

  static public <A> A proxy(Object target, Class<A> intrface) {
    return proxy(intrface, target);
  }

  static public boolean md5OfFile_verbose = false;

  static public String md5OfFile(String path) {
    return md5OfFile(newFile(path));
  }

  static public String md5OfFile(File f) {
    try {
      if (!f.exists())
        return "-";
      if (md5OfFile_verbose)
        print("Getting MD5 of " + f);
      MessageDigest md5 = MessageDigest.getInstance("MD5");
      FileInputStream in = new FileInputStream(f);
      try {
        byte[] buf = new byte[65536];
        int l;
        while (true) {
          l = in.read(buf);
          if (l <= 0)
            break;
          md5.update(buf, 0, l);
        }
        return bytesToHex(md5.digest());
      } finally {
        _close(in);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String standardCredentialsUser() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-username"), userDir(".tinybrain/username"))));
  }

  static public String standardCredentialsPass() {
    return trim(loadTextFile(oneOfTheFiles(javaxSecretDir("tinybrain-userpass"), userDir(".tinybrain/userpass"))));
  }

  static public String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  static public ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

  static public void checkFileNotTooBigToRead(File f) {
    callF(checkFileNotTooBigToRead_tl.get(), f);
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (dir != null) {
      dir.mkdirs();
      if (!dir.isDirectory())
        if (dir.isFile())
          throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
        else
          throw fail("Unknown IO exception during mkdirs of " + f2s(file));
    }
    return file;
  }

  public static String mkdirsForFile(String path) {
    mkdirsForFile(new File(path));
    return path;
  }

  static public File copyFile(File src, File dest) {
    try {
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
      return dest;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  static public FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  static public FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
    return newFileOutputStream(path.getPath(), append);
  }

  static public FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    mkdirsForFile(path);
    FileOutputStream f = new FileOutputStream(path, append);
    _registerIO(f, path, true);
    return f;
  }

  static public File javaxCachesDir_dir;

  static public File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  static public File javaxCachesDir(String sub) {
    return newFile(javaxCachesDir(), sub);
  }

  static public boolean isLocalhost(String ip) {
    return isLoopbackIP(ip) || eqic(ip, "localhost");
  }

  static public int vmPort() {
    return myVMPort();
  }

  static public DialogIO talkToThisVM() {
    return new talkToThisVM_IO();
  }

  static public class talkToThisVM_IO extends DialogIO {

    public List<String> answers = ll(thisVMGreeting());

    public boolean isLocalConnection() {
      return true;
    }

    public boolean isStillConnected() {
      return true;
    }

    public int getPort() {
      return vmPort();
    }

    public void sendLine(String line) {
      answers.add(or2(sendToThisVM_newThread(line), "?"));
    }

    public String readLineImpl() {
      try {
        return popFirst(answers);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void close() {
    }

    public Socket getSocket() {
      return null;
    }
  }

  static public TableWithTooltips tableWithTooltips() {
    return (TableWithTooltips) swing(new F0<Object>() {

      public Object get() {
        try {
          return new TableWithTooltips();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new TableWithTooltips;";
      }
    });
  }

  static public class TableWithTooltips extends JTable {

    public String getToolTipText(MouseEvent e) {
      String tip = null;
      Point p = e.getPoint();
      int rowIndex = rowAtPoint(p);
      int colIndex = columnAtPoint(p);
      try {
        return str(getValueAt(rowIndex, colIndex));
      } catch (Throwable _e) {
        return null;
      }
    }
  }

  static public <A> WeakReference<A> newWeakReference(A a) {
    return a == null ? null : new WeakReference(a);
  }

  static public JTextField standardTextFieldPopupMenu(final JTextField tf) {
    final WeakReference<JTextField> ref = weakRef(tf);
    componentPopupMenuItem(tf, "Copy text to clipboard", new Runnable() {

      public void run() {
        try {
          copyTextToClipboard(ref.get().getText());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "copyTextToClipboard(ref.get().getText())";
      }
    });
    componentPopupMenuItem(tf, "Paste", new Runnable() {

      public void run() {
        try {
          ref.get().paste();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ref.get().paste()";
      }
    });
    return tf;
  }

  static public <A extends JTextComponent> A jenableUndoRedo(final A textcomp) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            final UndoManager undo = new UndoManager();
            vm_generalWeakSet("Undo Managers").add(undo);
            textcomp.getDocument().addUndoableEditListener(new UndoableEditListener() {

              public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
              }
            });
            textcomp.getActionMap().put("Undo", abstractAction("Undo", new Runnable() {

              public void run() {
                try {
                  if (undo.canUndo())
                    undo.undo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canUndo()) undo.undo()";
              }
            }));
            textcomp.getActionMap().put("Redo", abstractAction("Redo", new Runnable() {

              public void run() {
                try {
                  if (undo.canRedo())
                    undo.redo();
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "if (undo.canRedo()) undo.redo()";
              }
            }));
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
            textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final new UndoManager undo;\r\n    vm_generalWeakSet(\"Undo Managers\").add(undo)...";
        }
      });
    }
    return textcomp;
  }

  static public boolean emptyString(String s) {
    return s == null || s.length() == 0;
  }

  static public <A> A firstWithClassShortNamed(String shortName, Iterable<A> l) {
    if (l != null)
      for (A o : l) if (eq(shortClassName(o), shortName))
        return o;
    return null;
  }

  static public <A> A firstWithClassShortNamed(String shortName, A[] l) {
    if (l != null)
      for (A o : l) if (eq(shortClassName(o), shortName))
        return o;
    return null;
  }

  static public Class primitiveToBoxedTypeOpt(Class type) {
    return or(primitiveToBoxedType(type), type);
  }

  static public boolean isInstance(Class type, Object arg) {
    return type.isInstance(arg);
  }

  static public <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  static public <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  static public void moveFile(File a, File b) {
    if (!renameFile(a, b))
      throw fail("File move failed: " + a + " to " + b);
  }

  static public void logMechListAppendLocally(String listName, String text) {
    if (empty(text))
      return;
    logStructureWithDate(mechListAppendLogFile(listName), litorderedmap("list", listName, "text", text));
    appendToFile(createLocalMechListFile(listName), assureTrailingNewLine(text));
  }

  static public String jextract(String pat, String s) {
    return jextract(pat, javaTok(s));
  }

  static public String jextract(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    jfind_preprocess(tokpat);
    int i = jfind(tok, tokpat);
    if (i < 0)
      return null;
    int j = i + l(tokpat) - 2;
    return joinSubList(tok, i, j);
  }

  static public String firstIntegerString(Iterable<String> c) {
    Iterator<String> it = c.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (isInteger(s))
        return s;
    }
    return null;
  }

  static public String loadProgramTextFile(String name) {
    return loadTextFile(getProgramFile(name));
  }

  static public String loadProgramTextFile(String progID, String name) {
    return loadTextFile(getProgramFile(progID, name));
  }

  static public String loadProgramTextFile(String progID, String name, String defaultText) {
    return loadTextFile(getProgramFile(progID, name), defaultText);
  }

  static public File saveProgramTextFile(String name, String contents) {
    return saveTextFile(getProgramFile(name), contents);
  }

  static public File saveProgramTextFile(String progID, String name, String contents) {
    return saveTextFile(getProgramFile(progID, name), contents);
  }

  static public File pathToJavaxJar() {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.pathToJavaXJar();
      int x = latestInstalledJavaX();
      File xfile = new File(userHome(), ".javax/x" + Math.max(x, 30) + ".jar");
      if (!xfile.isFile()) {
        print("Saving " + f2s(xfile));
        String url = x30JarServerURL();
        byte[] data = loadBinaryPage(url);
        if (data.length < 1000000)
          throw fail("Could not load " + url);
        saveBinaryFile(xfile.getPath(), data);
      }
      return xfile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> List<A> takeFirst(List<A> l, int n) {
    return l(l) <= n ? l : newSubListOrSame(l, 0, n);
  }

  static public <A> List<A> takeFirst(int n, List<A> l) {
    return takeFirst(l, n);
  }

  static public String takeFirst(int n, String s) {
    return substring(s, 0, n);
  }

  static public String takeFirst(String s, int n) {
    return substring(s, 0, n);
  }

  static public CharSequence takeFirst(int n, CharSequence s) {
    return subCharSequence(s, 0, n);
  }

  static public <A> List<A> takeFirst(int n, Iterable<A> i) {
    if (i == null)
      return null;
    List l = new ArrayList();
    Iterator<A> it = i.iterator();
    for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++) {
      if (it.hasNext())
        l.add(it.next());
      else
        break;
    }
    return l;
  }

  static public int[] takeFirst(int n, int[] a) {
    return takeFirstOfIntArray(n, a);
  }

  static public String nohup_sanitize(String s) {
    return empty(s) ? s : takeFirst(50, s.replaceAll("[^.a-zA-Z0-9\\-_]", ""));
  }

  static public String ymd_minus_hms() {
    return ymd() + "-" + hms();
  }

  static public List<String> platformParseArgs(String s) {
    List<String> out = new ArrayList();
    List<String> tok = javaTok(trim(s));
    for (int i = 1; i < l(tok); i += 2) {
      if (isQuoted(tok.get(i))) {
        out.add(tok.get(i));
        continue;
      }
      int j = i;
      while (j + 2 < l(tok) && empty(tok.get(j + 1))) j += 2;
      out.add(joinSubList(tok, i, j + 1));
      i = j;
    }
    return out;
  }

  static public String _javaCommand() {
    String __1 = trim(loadTextFile(javaxDataDir("java-command.txt")));
    if (!empty(__1))
      return __1;
    String javaHome = System.getProperty("java.home");
    if (nempty(javaHome)) {
      File f = new File(javaHome);
      f = oneOfTheFiles(newFile(f, "bin", "java"), newFile(f, "bin", "java.exe"));
      if (f != null)
        return platformQuote(f);
    }
    if (isOnPATH("java"))
      return "java";
    throw fail("No java command found");
  }

  public static boolean isWindows() {
    return System.getProperty("os.name").contains("Windows");
  }

  public static String winQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String winQuote(File f) {
    return winQuote(f.getAbsolutePath());
  }

  static public String bashQuote(String text) {
    if (text == null)
      return null;
    return "\"" + text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + "\"";
  }

  static public String bashQuote(File f) {
    return bashQuote(f.getAbsolutePath());
  }

  static public boolean nohup_debug = false;

  static public boolean nohup_noSlashB = false;

  static public ThreadLocal<Integer> nohup_exitValue = new ThreadLocal();

  public static File nohup(String cmd) {
    try {
      File outFile = File.createTempFile("nohup_" + nohup_sanitize(cmd) + "_", ".out");
      nohup(cmd, outFile, false);
      return outFile;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void nohup(String cmd, File outFile, boolean append) {
    try {
      String command = nohup_makeNohupCommand(cmd, outFile, append);
      File scriptFile = File.createTempFile("_realnohup", isWindows() ? ".bat" : "");
      System.out.println("[Nohup] " + command);
      try {
        if (nohup_debug)
          print("[nohup] Script file: " + scriptFile.getPath());
        saveTextFile(scriptFile.getPath(), command);
        String[] command2;
        if (isWindows())
          if (nohup_noSlashB)
            command2 = new String[] { "cmd", "/c", "start", scriptFile.getPath() };
          else
            command2 = new String[] { "cmd", "/c", "start", "/b", scriptFile.getPath() };
        else
          command2 = new String[] { "/bin/bash", scriptFile.getPath() };
        printStruct("[nohup] ", command2);
        Process process = Runtime.getRuntime().exec(command2);
        try {
          process.waitFor();
        } catch (InterruptedException e) {
          throw new RuntimeException(e);
        }
        int value = process.exitValue();
        nohup_exitValue.set(value);
        if (value != 0)
          warn("nohup exit value != 0: " + value);
      } finally {
        if (!isWindows())
          scriptFile.delete();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String nohup_makeNohupCommand(String cmd, File outFile, boolean append) {
    mkdirsForFile(outFile);
    String command;
    if (isWindows())
      command = cmd + (append ? " >>" : " >") + winQuote(outFile.getPath()) + " 2>&1";
    else
      command = "nohup " + cmd + (append ? " >>" : " >") + bashQuote(outFile.getPath()) + " 2>&1 &";
    return command;
  }

  static public boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  }

  static public JMenuItem jMenuItem(final String text) {
    return jmenuItem(text);
  }

  static public JMenuItem jMenuItem(String text, Object r) {
    return jmenuItem(text, r);
  }

  static public Pair<String, Integer> jmenu_autoMnemonic(String s) {
    int i = indexOf(s, '&');
    if (i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i + 1)))
      return pair(substring(s, 0, i) + substring(s, i + 1), (int) s.charAt(i + 1));
    return pair(s, 0);
  }

  static public JMenuItem disableMenuItem(final JMenuItem mi) {
    if (mi != null) {
      swing(new Runnable() {

        public void run() {
          try {
            mi.setEnabled(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "mi.setEnabled(false);";
        }
      });
    }
    return mi;
  }

  static public ActionListener actionListenerInNewThread(final Object runnable) {
    return actionListenerInNewThread(runnable, null);
  }

  static public ActionListener actionListenerInNewThread(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          startThread("Action Listener", new Runnable() {

            public void run() {
              try {
                AutoCloseable __1 = holdInstance(instanceToHold);
                try {
                  callF(runnable);
                } finally {
                  _close(__1);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "AutoCloseable __1 = holdInstance(instanceToHold); try {\r\n      callF(runnable...";
            }
          });
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public ActionListener actionListener(final Object runnable) {
    return actionListener(runnable, null);
  }

  static public ActionListener actionListener(final Object runnable, final Object instanceToHold) {
    if (runnable instanceof ActionListener)
      return (ActionListener) runnable;
    final Object info = _threadInfo();
    return new java.awt.event.ActionListener() {

      public void actionPerformed(java.awt.event.ActionEvent _evt) {
        try {
          _threadInheritInfo(info);
          AutoCloseable __1 = holdInstance(instanceToHold);
          try {
            callF(runnable);
          } finally {
            _close(__1);
          }
        } catch (Throwable __e) {
          messageBox(__e);
        }
      }
    };
  }

  static public Runnable addThreadInfoToRunnable(final Object r) {
    final Object info = _threadInfo();
    return info == null ? asRunnable(r) : new Runnable() {

      public void run() {
        try {
          _inheritThreadInfo(info);
          callF(r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_inheritThreadInfo(info); callF(r);";
      }
    };
  }

  static public int boostHashCombine(int a, int b) {
    return a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
  }

  static public int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public List<AbstractButton> buttonsInGroup(ButtonGroup g) {
    if (g == null)
      return ll();
    return asList(g.getElements());
  }

  static public <A extends JComponent> A toolTip(A c, final Object toolTip) {
    return setToolTipText(c, toolTip);
  }

  static public <A extends JComponent> A toolTip(Object toolTip, A c) {
    return setToolTipText(toolTip, c);
  }

  static public JComponent getInternalFrameTitlePaneComponent(JInternalFrame f) {
    return (JComponent) childWithClassNameEndingWith(f, "InternalFrameTitlePane");
  }

  static public <A> A setFrameTitle(A c, final String title) {
    final Frame f = getAWTFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.setTitle(title);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setTitle(title);";
        }
      });
    }
    return c;
  }

  static public <A extends Component> A setFrameTitle(String title, A c) {
    return setFrameTitle(c, title);
  }

  static public JFrame setFrameTitle(String title) {
    Object f = getOpt(mc(), "frame");
    if (f instanceof JFrame)
      return setFrameTitle((JFrame) f, title);
    return null;
  }

  static public String getFrameTitle(Component c) {
    JFrame f = getFrame(c);
    return f == null ? null : f.getTitle();
  }

  static public <A> boolean addIfNotNull(Collection<A> l, A a) {
    return a != null && l != null & l.add(a);
  }

  static public <A> void addIfNotNull(MultiSet<A> ms, A a) {
    if (a != null && ms != null)
      ms.add(a);
  }

  static public void closeAutoCloseables(Collection<AutoCloseable> l) {
    if (l != null)
      for (AutoCloseable c : l) {
        try {
          c.close();
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
  }

  static public String className(Object o) {
    return getClassName(o);
  }

  static public boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  static public boolean hasMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args) != null;
  }

  static public <A> A nuInstance(Class<A> c) {
    return nuEmptyObject(c);
  }

  static public <A> A copyFields(Object x, A y, String... fields) {
    if (empty(fields)) {
      Map<String, Object> map = objectToMap(x);
      for (String field : map.keySet()) setOpt(y, field, map.get(field));
    } else
      for (String field : fields) {
        Object o = getOpt(x, field);
        if (o != null)
          setOpt(y, field, o);
      }
    return y;
  }

  static public <A> A copyFields(Object x, A y, Collection<String> fields) {
    return copyFields(x, y, asStringArray(fields));
  }

  static public boolean isString(Object o) {
    return o instanceof String;
  }

  static public Object dm_getService(String serviceName) {
    return empty(serviceName) ? null : dm_getModule(vmBus_query(assertIdentifier(serviceName)));
  }

  static public boolean isStringOrIntOrLong(Object o) {
    return o instanceof String || o instanceof Integer || o instanceof Long;
  }

  static public Object dm_getStemByID(Object id) {
    return dm_callOS("getModuleByID", str(id));
  }

  static public Object dm_getModule(Object moduleOrID) {
    if (moduleOrID == null || eq(moduleOrID, ""))
      return null;
    if (isString(moduleOrID) && isIdentifier(((String) moduleOrID)))
      return dm_getService(((String) moduleOrID));
    if (isStringOrIntOrLong(moduleOrID))
      return dm_callOS("getDynModuleByID", str(moduleOrID));
    return dm_resolveModule(moduleOrID);
  }

  static public int methodApplicabilityScore_onTypes(Method m, Class[] argTypes) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != argTypes.length)
      return Integer.MAX_VALUE;
    int score = 0;
    for (int i = 0; i < types.length; i++) {
      Class a = argTypes[i];
      Class c = types[i];
      if (c == a) {
      } else if (isSubclassOf(a, c))
        ++score;
      else
        return Integer.MAX_VALUE;
    }
    return score;
  }

  static public <A extends AutoCloseable> A dm_ownResource(A resource) {
    dm_currentModuleMandatory().ownResource(resource);
    return resource;
  }

  static public <A> AutoCloseable vmBus_onMessage(final String msg, final VF1<A> onMessage) {
    Map<String, Set> map = vm_busListenersByMessage_live();
    synchronized (map) {
      Set listeners = map.get(msg);
      if (listeners == null)
        map.put(msg, listeners = syncIdentityHashSet());
      return tempAdd(listeners, new VF2<String, Object>() {

        public void get(String _msg, Object arg) {
          try {
            callF(onMessage, arg);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callF(onMessage, arg)";
        }
      });
    }
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public <A, B> AutoCloseable vmBus_onMessage(String msg, final IVF2<A, B> onMessage) {
    return vmBus_onMessage(msg, new VF1<Object[]>() {

      public void get(Object[] o) {
        try {
          callF(onMessage, first(o), second(o));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onMessage, first(o), second(o));";
      }
    });
  }

  static public AutoCloseable vmBus_onMessage(String msg, Runnable onMessage) {
    return vmBus_onMessage(msg, runnableToVF1(onMessage));
  }

  static public void addActionListener(JTextField tf, final Runnable action) {
    onEnter(tf, action);
  }

  static public void addActionListener(final JComboBox cb, final Runnable action) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public void addActionListener(final AbstractButton b, final Runnable action) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            b.addActionListener(actionListener(action));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "b.addActionListener(actionListener(action));";
        }
      });
    }
  }

  static public boolean containsSpace(String s) {
    return containsSpaces(s);
  }

  static public String firstToUpper(String s) {
    if (empty(s))
      return s;
    return Character.toUpperCase(s.charAt(0)) + s.substring(1);
  }

  static public <A> List<A> replaceElementsUsingMap(Iterable<A> l, final Map<A, A> map) {
    return map(l, new F1<A, A>() {

      public A get(A a) {
        try {
          return getOrKeep(map, a);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "getOrKeep(map, a)";
      }
    });
  }

  static public List<String> splitCamelCase(String s) {
    return ai_splitCamelCase(s);
  }

  static public void addMenuItems(JMenu m, Object... x) {
    fillJMenu(m, x);
  }

  static public void addMenuItems(JPopupMenu m, Object... x) {
    fillJPopupMenu(m, x);
  }

  static public boolean isChecked(final JCheckBox checkBox) {
    return checkBox != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return checkBox.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret checkBox.isSelected();";
      }
    });
  }

  static public boolean isChecked(final JCheckBoxMenuItem mi) {
    return mi != null && (boolean) swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          return mi.isSelected();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret mi.isSelected();";
      }
    });
  }

  static public JPanel showInternalFrameFormTitled(final JDesktopPane desktop, final String title, final Object... _parts) {
    JPanel panel = showForm_makePanel(true, _parts);
    showForm_makeInternalFrame(desktop, title, panel);
    return panel;
  }

  static public JFrame showForm_makeFrame(String title, JPanel panel) {
    return handleEscapeKey(minFrameWidth(showPackedFrame(title, withMargin(panel)), 400));
  }

  static public List<JComponent> showForm_arrange1(List<List<JComponent>> l) {
    int minW = showForm_leftWidth(l);
    List<JComponent> out = new ArrayList();
    for (List<JComponent> row : l) out.add(westAndCenter(withRightMargin(showForm_gapBetweenColumns, jMinWidth(minW, first(row))), second(row)));
    return out;
  }

  static public List<List<JComponent>> showForm_makeComponents(final Boolean internalFrame, Object... _parts) {
    List<List<JComponent>> l = new ArrayList();
    List parts = asList(_parts);
    JButton submitButton = null;
    for (int i = 0; i < l(parts); i++) {
      final Object o = parts.get(i), next = get(parts, i + 1);
      if (o instanceof String && next instanceof Component)
        setComponentID((Component) next, (String) o);
      if (o instanceof Component || o instanceof String || next instanceof Component) {
        l.add(mapLL("wrapForSmartAdd", o == null ? new JPanel() : o instanceof String ? humanizeFormLabel((String) o) : o, next));
        if (next instanceof JButton && submitButton == null)
          submitButton = (JButton) next;
        i++;
      } else if (isRunnable(o))
        l.add(mapLL("wrapForSmartAdd", null, submitButton = jbutton(showFormSubmitButtonName(), new Runnable() {

          public void run() {
            try {
              Object result = call(o);
              if (neq(Boolean.FALSE, result)) {
                if (isTrue(internalFrame))
                  disposeInternalFrame(heldInstance(JButton.class));
                else if (isFalse(internalFrame))
                  disposeFrame(heldInstance(JButton.class));
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "Object result = call(o);\r\n        if (neq(Boolean.FALSE, result)) {\r\n        ...";
          }
        })));
      else
        print("showForm: Unknown element type: " + getClassName(o));
    }
    if (submitButton != null) {
      final JButton _submitButton = submitButton;
      onEnterInAllTextFields(concatLists(l), new Runnable() {

        public void run() {
          try {
            clickButton(_submitButton);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "clickButton(_submitButton)";
        }
      });
    }
    for (List<JComponent> row : l) {
      JComponent left = first(row);
      if (left instanceof JLabel)
        makeBold((JLabel) left).setVerticalAlignment(JLabel.TOP);
    }
    return l;
  }

  static public int vstackWithSpacing_default = 10;

  static public JPanel vstackWithSpacing(final List parts) {
    return vstackWithSpacing(parts, vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(final List parts, final int spacing) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          GridBagConstraints gbc = new GridBagConstraints();
          gbc.weightx = 1;
          gbc.fill = GridBagConstraints.HORIZONTAL;
          gbc.gridwidth = GridBagConstraints.REMAINDER;
          gbc.insets = new Insets(spacing / 2, 0, spacing / 2, 0);
          smartAddWithLayout(panel, gbc, toObjectArray(nonNulls(parts)));
          gbc.weighty = 1;
          gbc.insets = new Insets(0, 0, 0, 0);
          panel.add(jrigid(), gbc);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    new GridBagConstraints gbc...";
      }
    });
  }

  static public JPanel vstackWithSpacing(Component... parts) {
    return vstackWithSpacing(asList(parts), vstackWithSpacing_default);
  }

  static public JPanel vstackWithSpacing(int spacing, Component... parts) {
    return vstackWithSpacing(asList(parts), spacing);
  }

  static public String getTextTrim(JTextComponent c) {
    return trim(getText(c));
  }

  static public String getTextTrim(JComboBox cb) {
    return trim(getText(cb));
  }

  static public String getTextTrim(JComponent c) {
    if (c instanceof JLabel)
      return trim(((JLabel) c).getText());
    if (c instanceof JComboBox)
      return getTextTrim((JComboBox) c);
    return getTextTrim((JTextComponent) c);
  }

  static public double parseDouble(String s) {
    return Double.parseDouble(s);
  }

  static public File toFile_nullOnEmpty(String s) {
    return empty(s) ? null : new File(s);
  }

  static public void setTrayIconToolTip(TrayIcon trayIcon, String toolTip) {
    if (trayIcon != null)
      trayIcon.setToolTip(toolTip);
  }

  static public JLabel jImageLabel(Image img) {
    return swingNu(JLabel.class, imageIcon(img));
  }

  static public JLabel jImageLabel(javax.swing.Icon icon) {
    return swingNu(JLabel.class, icon);
  }

  static public JLabel jImageLabel(String imageID) {
    return jImageLabel(imageIcon(imageID));
  }

  static public JLabel jImageLabel(String text, String imageID) {
    final JLabel l = swingNu(JLabel.class, text, imageIcon(imageID), JLabel.CENTER);
    {
      swing(new Runnable() {

        public void run() {
          try {
            l.setVerticalTextPosition(SwingConstants.BOTTOM);
            l.setHorizontalTextPosition(SwingConstants.CENTER);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "l.setVerticalTextPosition(SwingConstants.BOTTOM);\r\n    l.setHorizontalTextPos...";
        }
      });
    }
    return l;
  }

  static public String localSnippetTitle(String snippetID) {
    if (!isLocalSnippetID(snippetID))
      return null;
    File f = localSnippetFile(snippetID);
    if (!f.exists())
      return null;
    return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
  }

  static public boolean isImageServerSnippet(long id) {
    return id >= 1100000 && id < 1200000;
  }

  static public String imageServerURL() {
    return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
  }

  static public String muricaCredentialsQuery() {
    return htmlQuery(muricaCredentials());
  }

  static public boolean isGeneralFileServerSnippet(long id) {
    return id >= 1400000 && id < 1500000;
  }

  static public String standardCredentials_noCookies() {
    return standardCredentials() + "&noCookies=1";
  }

  static public boolean saveTextFileIfChanged(File f, String contents) {
    return saveTextFileIfDifferent(f, contents);
  }

  static public File snippetTitle_cacheFile(String snippetID) {
    return javaxCachesDir("Snippet Titles/" + psI(snippetID));
  }

  static public <A> Set<A> synchroWeakHashSet() {
    return Collections.newSetFromMap((Map) newWeakHashMap());
  }

  static public Runnable wrapAsActivity(Object r) {
    return toRunnable(r);
  }

  static public Runnable toRunnable(final Object o) {
    if (o instanceof Runnable)
      return (Runnable) o;
    return new Runnable() {

      public void run() {
        try {
          callF(o);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(o)";
      }
    };
  }

  static public boolean allPaused() {
    return ping_pauseAll;
  }

  static public void bindTimerToComponent(final Timer timer, JFrame f) {
    bindTimerToComponent(timer, f.getRootPane());
  }

  static public void bindTimerToComponent(final Timer timer, JComponent c) {
    if (c.isShowing())
      timer.start();
    c.addAncestorListener(new AncestorListener() {

      public void ancestorAdded(AncestorEvent event) {
        timer.start();
      }

      public void ancestorRemoved(AncestorEvent event) {
        timer.stop();
      }

      public void ancestorMoved(AncestorEvent event) {
      }
    });
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
    if (l == null)
      return null;
    if (empty(stuff))
      return asList(l);
    Set<? extends A> set = asSet(stuff);
    List<A> l2 = new ArrayList();
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
    return listMinusSet(listMinusSet(l, stuff), stuff2);
  }

  static public String toStringOpt(Object o) {
    return o instanceof String ? ((String) o) : null;
  }

  static public <A> TreeSet<A> asTreeSet(Collection<A> set) {
    return set == null ? null : set instanceof TreeSet ? (TreeSet) set : new TreeSet(set);
  }

  static public Set<String> allNonStaticFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & Modifier.STATIC) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public <A> void setAddAll(Collection<A> a, Collection<A> b) {
    for (A x : b) setAdd(a, x);
  }

  static public Lock downloadLock_lock = fairLock();

  static public Lock downloadLock() {
    return downloadLock_lock;
  }

  static public String getSnippetTitleOpt(String s) {
    return isSnippetID(s) ? getSnippetTitle(s) : s;
  }

  static public void dataToTable_dynSet(List l, int i, Object s) {
    while (i >= l.size()) l.add("");
    l.set(i, s);
  }

  static public List dataToTable_makeRow(Object x, List<String> cols) {
    if (instanceOf(x, "DynamicObject"))
      x = get_raw(x, "fieldValues");
    if (x instanceof Map) {
      Map m = (Map) x;
      List row = new ArrayList();
      for (Object _field : keysWithoutHidden(m)) {
        String field = (String) _field;
        Object value = m.get(field);
        int col = cols.indexOf(field);
        if (col < 0) {
          cols.add(field);
          col = cols.size() - 1;
        }
        dataToTable_dynSet(row, col, dataToTable_wrapValue(value));
      }
      return row;
    }
    if (x instanceof List)
      return allToString(((List) x));
    return litlist(structureOrText(x));
  }

  static public Object dataToTable_wrapValue(Object o) {
    if (o instanceof BufferedImage)
      return o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof RGBImage)
      return o;
    if (o instanceof Boolean)
      return o;
    return structureOrTextForUser(o);
  }

  static public String structureOrTextForUser(Object o) {
    return o == null ? "" : o instanceof String ? (String) o : structureForUser(o);
  }

  static public void fillTableWithData(final JTable table, List<List> rows, List<String> colNames) {
    fillTableWithData(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithData(final JTable table, List<List> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithData_makeModel(rows, colNames);
    setTableModel(table, model);
  }

  static public DefaultTableModel fillTableWithData_makeModel(List<List> rows, String... colNames) {
    Pair<Object[][], Object[]> p = fillTableWithData_makeData(rows, colNames);
    return new DefaultTableModel(p.a, p.b) {

      public Class getColumnClass(int column) {
        return or(_getClass(getValueAt(0, column)), String.class);
      }

      public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
      }
    };
  }

  static public String autoFrameTitle_value;

  static public String autoFrameTitle() {
    return autoFrameTitle_value != null ? autoFrameTitle_value : getProgramTitle();
  }

  static public void autoFrameTitle(Component c) {
    setFrameTitle(getFrame(c), autoFrameTitle());
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, List<String> colNames) {
    fillTableWithStrings(table, rows, toStringArray(colNames));
  }

  static public void fillTableWithStrings(final JTable table, List<List<String>> rows, String... colNames) {
    final DefaultTableModel model = fillTableWithStrings_makeModel(rows, colNames);
    swingNowOrLater(new Runnable() {

      public void run() {
        try {
          setTableModel(table, model);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "setTableModel(table, model);";
      }
    });
  }

  static public DefaultTableModel fillTableWithStrings_makeModel(List<List<String>> rows, String... colNames) {
    Object[][] data = new Object[rows.size()][];
    int w = 0;
    for (int i = 0; i < rows.size(); i++) {
      List<String> l = rows.get(i);
      Object[] r = new Object[l.size()];
      for (int j = 0; j < l.size(); j++) r[j] = l.get(j);
      data[i] = r;
      w = Math.max(w, l.size());
    }
    Object[] columnNames = new Object[w];
    for (int i = 0; i < w; i++) columnNames[i] = i < l(colNames) ? colNames[i] : "?";
    return new DefaultTableModel(data, columnNames);
  }

  static public JFrame showFrame() {
    return makeFrame();
  }

  static public JFrame showFrame(Object content) {
    return makeFrame(content);
  }

  static public JFrame showFrame(String title) {
    return makeFrame(title);
  }

  static public JFrame showFrame(String title, Object content) {
    return makeFrame(title, content);
  }

  static public JFrame showFrame(final JFrame f) {
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (frameTooSmall(f))
              frameStandardSize(f);
            if (!f.isVisible())
              f.setVisible(true);
            if (f.getState() == Frame.ICONIFIED)
              f.setState(Frame.NORMAL);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frameTooSmall(f)) frameStandardSize(f);\r\n    if (!f.isVisible()) f.setVis...";
        }
      });
    }
    return f;
  }

  static public JFrame showFrame(String title, Object content, JFrame frame) {
    if (frame == null)
      return showFrame(title, content);
    else {
      frame.setTitle(title);
      setFrameContents(frame, content);
      return frame;
    }
  }

  static public Object selectedTableCell(JTable t, int col) {
    return getTableCell(t, selectedTableRow(t), col);
  }

  static public Object selectedTableCell(final JTable t) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, t.getSelectedColumn());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret selectedTableCell(t, t.getSelectedColumn());";
      }
    });
  }

  static public Object selectedTableCell(final JTable t, final String colName) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return selectedTableCell(t, tableColumnViewIndex(t, colName));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret selectedTableCell(t, tableColumnViewIndex(t, colName));";
      }
    });
  }

  static public void tableEnableDrag(final JTable table, TransferHandler th) {
    if (table.getDragEnabled()) {
      print("Table drag already enabled");
      return;
    }
    table.setDragEnabled(true);
    table.setTransferHandler(th);
    table.addMouseListener(new MouseAdapter() {

      @Override
      public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 1)
          table.getTransferHandler().exportAsDrag(table, e, TransferHandler.COPY);
      }
    });
  }

  static public KeyListener enterKeyListener(final Object action) {
    return new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == KeyEvent.VK_ENTER)
          pcallF(action);
      }
    };
  }

  static public Runnable rCallOnSelectedListItem(final JList list, final Object action) {
    return new Runnable() {

      public void run() {
        try {
          pcallF(action, getSelectedItem(list));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcallF(action, getSelectedItem(list))";
      }
    };
  }

  static public <A, B> Collection<B> values(Map<A, B> map) {
    return map == null ? emptyList() : map.values();
  }

  static public Collection values(Object map) {
    return values((Map) map);
  }

  static public boolean containsIgnoreCase(Collection<String> l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String[] l, String s) {
    if (l != null)
      for (String x : l) if (eqic(x, s))
        return true;
    return false;
  }

  static public boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  static public boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  static public Map<String, Object> rawTableLineAsMap(JTable tbl, int row) {
    if (row >= 0 && row < tbl.getModel().getRowCount()) {
      Map<String, Object> map = litorderedmap();
      for (int i = 0; i < tbl.getModel().getColumnCount(); i++) mapPut(map, tbl.getModel().getColumnName(i), tbl.getModel().getValueAt(row, i));
      return map;
    }
    return null;
  }

  static public JPanel westAndCenter(final Component w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.WEST, wrap(w));
          panel.add(BorderLayout.CENTER, wrap(c));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.WEST...";
      }
    });
  }

  static public boolean boolOptParam(ThreadLocal<Boolean> tl) {
    return isTrue(optPar(tl));
  }

  static public boolean boolOptParam(Object[] __, String name) {
    return isTrue(optParam(__, name));
  }

  static public boolean boolOptParam(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolOptParam(String name, Map __) {
    return isTrue(optPar(name, __));
  }

  static public int withBottomMargin_defaultWidth = 6;

  static public JPanel withBottomMargin(Component c) {
    return withBottomMargin(withBottomMargin_defaultWidth, c);
  }

  static public JPanel withBottomMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, w, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public JPanel centerAndNorth(final Component c, final Component n) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.NORTH, wrap(n));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public String formatWithThousandsSeparator(long l) {
    return NumberFormat.getInstance(new Locale("en_US")).format(l);
  }

  static public Object swingCall(final Object o, final String method, final Object... args) {
    return swing(new F0<Object>() {

      public Object get() {
        try {
          return call(o, method, args);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret call(o, method, args);";
      }
    });
  }

  static public String defaultThreadName_name;

  static public String defaultThreadName() {
    if (defaultThreadName_name == null)
      defaultThreadName_name = "A thread by " + programID();
    return defaultThreadName_name;
  }

  static public Thread newThread(Object runnable) {
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)));
  }

  static public Thread newThread(Object runnable, String name) {
    if (name == null)
      name = defaultThreadName();
    return new Thread(_topLevelErrorHandling(toRunnable(runnable)), name);
  }

  static public Thread newThread(String name, Object runnable) {
    return newThread(runnable, name);
  }

  static public boolean headless() {
    return isHeadless();
  }

  static public Throwable innerException2(Throwable e) {
    if (e == null)
      return null;
    while (empty(e.getMessage()) && e.getCause() != null) e = e.getCause();
    return e;
  }

  static public void arraycopy(Object[] a, Object[] b) {
    if (a != null && b != null)
      arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
  }

  static public void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
    if (n != 0)
      System.arraycopy(src, srcPos, dest, destPos, n);
  }

  static public int year() {
    return localYear();
  }

  static public int year(long now) {
    return localYear(now);
  }

  static public int year(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("y", tz).format(now));
  }

  static public String formatInt(int i, int digits) {
    return padLeft(str(i), '0', digits);
  }

  static public String formatInt(long l, int digits) {
    return padLeft(str(l), '0', digits);
  }

  static public int month() {
    return localMonth();
  }

  static public int month(long now) {
    return localMonth(now);
  }

  static public int month(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("M", tz).format(now));
  }

  static public int dayOfMonth() {
    return localDayOfMonth();
  }

  static public int dayOfMonth(long now) {
    return localDayOfMonth(now);
  }

  static public int dayOfMonth(long now, TimeZone tz) {
    return parseInt(simpleDateFormat("d", tz).format(now));
  }

  static public SimpleDateFormat simpleDateFormat_local(String format) {
    SimpleDateFormat sdf = new SimpleDateFormat(format);
    sdf.setTimeZone(localTimeZone());
    return sdf;
  }

  static public File tempFileFor(File f) {
    return new File(f.getPath() + "_temp");
  }

  static public JPanel jFullCenter(final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new GridBagLayout());
          panel.add(c);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new GridBagLayout);\r\n    panel.add(c);\r\n    ret panel;";
      }
    });
  }

  static public File loadBinarySnippet(String snippetID) {
    try {
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      long id = parseSnippetID(snippetID);
      if (isImageServerSnippet(id))
        return loadImageAsFile(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean loadBufferedImageFixingGIFs_debug = false;

  static public ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

  static public Image loadBufferedImageFixingGIFs(File file) {
    try {
      if (!file.exists())
        return null;
      if (!isGIF(file))
        return ImageIO.read(file);
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": checking gif");
      ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
      reader.setInput(ImageIO.createImageInputStream(file));
      int numImages = reader.getNumImages(true);
      IIOMetadata imageMetaData = reader.getImageMetadata(0);
      String metaFormatName = imageMetaData.getNativeMetadataFormatName();
      boolean foundBug = false;
      for (int i = 0; i < numImages && !foundBug; i++) {
        IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
        int nNodes = root.getLength();
        for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
            String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
            if (Integer.parseInt(delay) == 0) {
              foundBug = true;
            }
            break;
          }
        }
      }
      if (loadBufferedImageFixingGIFs_debug)
        print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
      Image image;
      if (!foundBug) {
        image = Toolkit.getDefaultToolkit().createImage(f2s(file));
      } else {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        {
          ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream);
          try {
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < numImages; i++) {
              BufferedImage frameIn = reader.read(i);
              IIOMetadataNode root = (IIOMetadataNode) reader.getImageMetadata(i).getAsTree(metaFormatName);
              int nNodes = root.getLength();
              for (int j = 0; j < nNodes; j++) {
                org.w3c.dom.Node node = root.item(j);
                if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  String delay = ((IIOMetadataNode) node).getAttribute("delayTime");
                  if (Integer.parseInt(delay) == 0) {
                    ((IIOMetadataNode) node).setAttribute("delayTime", "10");
                  }
                  break;
                }
              }
              IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
              metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);
              IIOImage frameOut = new IIOImage(frameIn, null, metadata);
              writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
            }
            writer.endWriteSequence();
          } finally {
            _close(ios);
          }
        }
        byte[] data = baoStream.toByteArray();
        setVar(loadBufferedImageFixingGIFs_output.get(), data);
        if (loadBufferedImageFixingGIFs_debug)
          print("Data size: " + l(data));
        image = Toolkit.getDefaultToolkit().createImage(data);
      }
      return image;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isURL(String s) {
    return startsWithOneOf(s, "http://", "https://", "file:");
  }

  static public BufferedImage imageIO_readURL(String url) {
    try {
      return ImageIO.read(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean isAbsolutePath(String s) {
    return s != null && new File(s).isAbsolute();
  }

  static public boolean isAbsolutePath(File f) {
    return f != null && f.isAbsolute();
  }

  static public File imageSnippetsCacheDir() {
    return javaxCachesDir("Image-Snippets");
  }

  static public String snippetImageURL_http(String snippetID) {
    return snippetImageURL_http(snippetID, "png");
  }

  static public String snippetImageURL_http(String snippetID, String contentType) {
    return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
  }

  static public List collect(Iterable c, String field) {
    return collectField(c, field);
  }

  static public List collect(String field, Iterable c) {
    return collectField(c, field);
  }

  static public void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A printHidingCredentials(A o) {
    print(hideCredentials(str(o)));
    return o;
  }

  static public void logQuotedWithDate(String s) {
    logQuotedWithTime(s);
  }

  static public void logQuotedWithDate(String logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public void logQuotedWithDate(File logFile, String s) {
    logQuotedWithTime(logFile, s);
  }

  static public File infoBoxesLogFile() {
    return new File(javaxDataDir(), "Logs/infoBoxes.txt");
  }

  static public JWindow showWindow(Component c) {
    JWindow w = new JWindow();
    w.add(wrap(c));
    return w;
  }

  static public JPanel infoMessage_makePanel(String text) {
    final JTextArea ta = wrappedTextArea(text);
    onClick(ta, new Runnable() {

      public void run() {
        try {
          disposeWindow(ta);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "disposeWindow(ta)";
      }
    });
    int size = 14;
    if (l(text) <= 50)
      size *= 2;
    else if (l(text) < 100)
      size = iround(size * 1.5);
    ta.setFont(typeWriterFont(size));
    JScrollPane sp = jscroll(ta);
    return withMargin(sp);
  }

  static public int moveToTopRightCorner_inset = 20;

  static public <A extends Component> A moveToTopRightCorner(A a) {
    return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
  }

  static public <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
    Window w = getWindow(a);
    if (w != null)
      w.setLocation(getScreenSize().width - w.getWidth() - insetX, insetY);
    return a;
  }

  static public boolean vmBus_noObjections(String msg, Object... args) {
    return !vmBus_anyFalse(msg, args);
  }

  static public <A extends Window> A disposeWindowAfter(int delay, final A w) {
    if (w != null)
      swingLater(delay, new Runnable() {

        public void run() {
          try {
            w.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "w.dispose();";
        }
      });
    return w;
  }

  static public <A extends Window> A disposeWindowAfter(A w, double seconds) {
    return disposeWindowAfter(toMS_int(seconds), w);
  }

  static public <A extends Window> A disposeWindowAfter(double seconds, A w) {
    return disposeWindowAfter(w, seconds);
  }

  static public Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  static public String actualUserHome_value;

  static public String actualUserHome() {
    if (actualUserHome_value == null) {
      if (isAndroid())
        actualUserHome_value = "/storage/emulated/0/";
      else
        actualUserHome_value = System.getProperty("user.home");
    }
    return actualUserHome_value;
  }

  static public File actualUserHome(String sub) {
    return newFile(new File(actualUserHome()), sub);
  }

  static public File userDir() {
    return new File(userHome());
  }

  static public File userDir(String path) {
    return new File(userHome(), path);
  }

  static public double toDouble(Object o) {
    if (o instanceof Number)
      return ((Number) o).doubleValue();
    if (o instanceof BigInteger)
      return ((BigInteger) o).doubleValue();
    if (o instanceof String)
      return parseDouble(((String) o));
    if (o == null)
      return 0.0;
    throw fail(o);
  }

  static public class listPopupMenu_Maker {

    public List menuMakers = new ArrayList();
  }

  static public Map<JList, listPopupMenu_Maker> listPopupMenu_map = new WeakHashMap();

  static public ThreadLocal<MouseEvent> listPopupMenu_mouseEvent = new ThreadLocal();

  static public ThreadLocal<Boolean> listPopupMenu_first = new ThreadLocal();

  static public void listPopupMenu(final JList list, final Object menuMaker) {
    final boolean first = isTrue(getAndClearThreadLocal(listPopupMenu_first));
    swingNowOrLater(new Runnable() {

      public void run() {
        try {
          listPopupMenu_Maker maker = listPopupMenu_map.get(list);
          if (maker == null) {
            listPopupMenu_map.put(list, maker = new listPopupMenu_Maker());
            final listPopupMenu_Maker _maker = maker;
            list.addMouseListener(new MouseAdapter() {

              public void mousePressed(MouseEvent e) {
                displayMenu(e);
              }

              public void mouseReleased(MouseEvent e) {
                displayMenu(e);
              }

              public void displayMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                  JPopupMenu menu = new JPopupMenu();
                  int idx = list.locationToIndex(e.getPoint());
                  Object item = list.getModel().getElementAt(idx);
                  list.setSelectedIndex(idx);
                  int emptyCount = menu.getComponentCount();
                  listPopupMenu_mouseEvent.set(e);
                  for (Object menuMaker : _maker.menuMakers) pcallF(menuMaker, menu, item);
                  if (menu.getComponentCount() == emptyCount)
                    return;
                  vmBus_send("showingPopupMenu", list, menu);
                  menu.show(e.getComponent(), e.getX(), e.getY());
                }
              }
            });
          }
          if (first)
            maker.menuMakers.add(0, menuMaker);
          else
            maker.menuMakers.add(menuMaker);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "listPopupMenu_Maker maker = listPopupMenu_map.get(list);\r\n    if (maker == nu...";
      }
    });
  }

  static public HashMap<String, List<Method>> callMC_cache = new HashMap();

  static public String callMC_key;

  static public Method callMC_value;

  static public Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  static public Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  static public <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  static public int tableNumColumns(final JTable table) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          return table.getColumnCount();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret table.getColumnCount();";
      }
    });
  }

  static public Throwable unwrapTrivialExceptionWraps(Throwable e) {
    if (e == null)
      return e;
    while (e.getClass() == RuntimeException.class && e.getCause() != null && eq(e.getMessage(), str(e.getCause()))) e = e.getCause();
    return e;
  }

  static public String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  static public List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  static public boolean methodIsStatic(Method m) {
    return (m.getModifiers() & Modifier.STATIC) != 0;
  }

  static public boolean argumentCompatibleWithType(Object arg, Class type) {
    return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
  }

  static public <A> A[] arrayOfType(Class<A> type, int n) {
    return makeArray(type, n);
  }

  static public <A> A[] arrayOfType(int n, Class<A> type) {
    return arrayOfType(type, n);
  }

  static public String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  static public boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  static public boolean eqic(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  static public int indexOfIgnoreCase_manual(String a, String b) {
    return indexOfIgnoreCase_manual(a, b, 0);
  }

  static public int indexOfIgnoreCase_manual(String a, String b, int i) {
    int la = strL(a), lb = strL(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    loop: for (; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c1 = a.charAt(i + j), c2 = b.charAt(j);
        if (!eqic(c1, c2))
          continue loop;
      }
      return i;
    }
    return -1;
  }

  public static String rtrim(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t\r\n".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s) {
    return javaTokC_noMLS_iterator(s, 0);
  }

  static public Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
    return new Producer<String>() {

      final public int l = s.length();

      public int i = startIndex;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  static public Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      public StringBuilder buf = new StringBuilder();

      public char c, d, e = 'x';

      public X() {
        nc();
        nc();
        nc();
      }

      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : i == '\0' ? '_' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  static public Object _defaultClassFinder_value = defaultDefaultClassFinder();

  static public Object _defaultClassFinder() {
    return _defaultClassFinder_value;
  }

  static public HashMap<String, Class> findClass_fullName_cache = new HashMap();

  static public Class findClass_fullName(String name) {
    synchronized (findClass_fullName_cache) {
      if (findClass_fullName_cache.containsKey(name))
        return findClass_fullName_cache.get(name);
      Class c;
      try {
        c = Class.forName(name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_fullName_cache.put(name, c);
      return c;
    }
  }

  static public String unquoteUsingCharArray(String s, char[] buf) {
    if (s == null)
      return null;
    if (startsWith(s, '[')) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if (s.length() > 1) {
      char c = s.charAt(0);
      if (c == '\"' || c == '\'') {
        int l = endsWith(s, c) ? s.length() - 1 : s.length();
        if (l > buf.length)
          return unquote(s);
        int n = 0;
        for (int i = 1; i < l; i++) {
          char ch = s.charAt(i);
          if (ch == '\\') {
            char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
            if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
                if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
            }
            switch(nextChar) {
              case '\"':
                ch = '\"';
                break;
              case '\\':
                ch = '\\';
                break;
              case 'b':
                ch = '\b';
                break;
              case 'f':
                ch = '\f';
                break;
              case 'n':
                ch = '\n';
                break;
              case 'r':
                ch = '\r';
                break;
              case 't':
                ch = '\t';
                break;
              case '\'':
                ch = '\'';
                break;
              case 'u':
                if (i >= l - 5) {
                  ch = 'u';
                  break;
                }
                int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
                char[] x = Character.toChars(code);
                int lx = x.length;
                for (int j = 0; j < lx; j++) buf[n++] = x[j];
                i += 5;
                continue;
              default:
                ch = nextChar;
            }
            i++;
          }
          buf[n++] = ch;
        }
        return new String(buf, 0, n);
      }
    }
    return s;
  }

  static public boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  static public String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? intern(s) : s;
  }

  static public char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  static public BigInteger parseBigInt(String s) {
    return new BigInteger(s);
  }

  static public float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  static public boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  static public long parseLong(String s) {
    if (empty(s))
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  static public long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  static public <A> TreeMap<String, A> ciMap() {
    return caseInsensitiveMap();
  }

  static public List parseList(String s) {
    return (List) safeUnstructure(s);
  }

  static public <A> List<A> synchroLinkedList() {
    return Collections.synchronizedList(new LinkedList<A>());
  }

  static public byte[] hexToBytes(String s) {
    if (odd(l(s)))
      throw fail("Hex string has odd length: " + quote(shorten(10, s)));
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      int a = parseHexChar(s.charAt(i * 2));
      int b = parseHexChar(s.charAt(i * 2 + 1));
      if (a < 0 || b < 0)
        throw fail("Bad hex byte: " + quote(substring(s, i * 2, i * 2 + 2)) + " at " + i * 2 + "/" + l(s));
      bytes[i] = (byte) ((a << 4) | b);
    }
    return bytes;
  }

  static public boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  static public <A> A nuStubInnerObject(Class<A> c) {
    return nuStubInnerObject(c, null);
  }

  static public <A> A nuStubInnerObject(Class<A> c, Object classFinder) {
    try {
      Class outerType = getOuterClass(c, classFinder);
      Constructor m = c.getDeclaredConstructor(outerType);
      makeAccessible(m);
      return (A) m.newInstance(new Object[] { null });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

  static public <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          makeAccessible(ctr);
        }
      }
      try {
        return (A) ctr.newInstance();
      } catch (InstantiationException e) {
        if (empty(e.getMessage()))
          if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
            throw fail("Can't instantiate abstract class " + className(c), e);
          else
            throw fail("Can't instantiate " + className(c), e);
        else
          throw rethrow(e);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  static public void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
    if (fields == null)
      return;
    HashMap<String, Field> fieldMap = instanceFieldsMap(o);
    for (Map.Entry<String, Object> e : fields.entrySet()) {
      try {
        String field = e.getKey();
        Object val = e.getValue();
        boolean has = fieldMap.containsKey(field);
        if (has)
          setOpt(o, field, val);
        else {
          o.fieldValues = syncMapPut2_createLinkedHashMap(o.fieldValues, intern(field), val);
        }
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public void setOptAll_pcall(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) try {
      setOpt(o, field, fields.get(field));
    } catch (Throwable __e) {
      print(exceptionToStringShort(__e));
    }
  }

  static public void setOptAll_pcall(Object o, Object... values) {
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      try {
        setOpt(o, field, value);
      } catch (Throwable __e) {
        print(exceptionToStringShort(__e));
      }
    }
  }

  static public void fixOuterRefs(Object o) {
    try {
      if (o == null)
        return;
      Field[] l = thisDollarOneFields(o.getClass());
      if (l.length <= 1)
        return;
      Object father = null;
      for (Field f : l) {
        father = f.get(o);
        if (father != null)
          break;
      }
      if (father == null)
        return;
      for (Field f : l) f.set(o, father);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      _handleException(__e);
    }
  }

  static public <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  static public <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
    return subList(l, startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = Math.max(0, startIndex);
    endIndex = Math.min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return l.subList(startIndex, endIndex);
  }

  static public <A> List<A> subList(List<A> l, IntRange r) {
    return subList(l, r.start, r.end);
  }

  static public int[] toIntArray(Collection<Integer> l) {
    int[] a = new int[l(l)];
    int i = 0;
    if (a.length != 0)
      for (int x : l) a[i++] = x;
    return a;
  }

  static public double[] toDoubleArray(Collection<Double> l) {
    double[] a = new double[l(l)];
    int i = 0;
    if (a.length != 0)
      for (double x : l) a[i++] = x;
    return a;
  }

  static public TreeSet<String> ciSet() {
    return caseInsensitiveSet();
  }

  static public boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  static public boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  static public boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  static public boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  static public boolean warn_on = true;

  static public ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

  static public void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  static public void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
    addToCollection(warn_warnings.get(), s);
  }

  static public ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() {
    return DynamicObject_loading;
  }

  static public Map<String, Class> classForName_cache = synchroHashMap();

  static public Class classForName(String name) {
    try {
      if (classForName_cache == null)
        return Class.forName(name);
      Class c = classForName_cache.get(name);
      if (c == null)
        classForName_cache.put(name, c = Class.forName(name));
      return c;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

  static public Object nuObjectWithoutArguments(String className) {
    try {
      return nuObjectWithoutArguments(classForName(className));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A nuObjectWithoutArguments(Class<A> c) {
    try {
      if (nuObjectWithoutArguments_cache == null)
        return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
      Constructor m = nuObjectWithoutArguments_cache.get(c);
      if (m == null)
        nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
      return (A) m.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Constructor nuObjectWithoutArguments_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
    throw fail("No default constructor found in " + c.getName());
  }

  static public List<Class> getClasses(Object[] array) {
    List<Class> l = emptyList(l(array));
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  static public Font loadFont(String snippetID) {
    try {
      return loadFont(snippetID, 12f);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(String snippetID, float fontSize) {
    return loadFont(loadLibrary(snippetID), fontSize);
  }

  static public Font loadFont(File f, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, f).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Font loadFont(InputStream in, float fontSize) {
    try {
      return Font.createFont(Font.TRUETYPE_FONT, in).deriveFont(fontSize);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

  static public void assertVerbose(boolean b) {
    assertVerbose_value.set(b);
  }

  static public boolean assertVerbose() {
    return isTrue(assertVerbose_value.get());
  }

  static public <A> A assertEqualsVerbose(Object x, A y) {
    assertEqualsVerbose((String) null, x, y);
    return y;
  }

  static public <A> A assertEqualsVerbose(String msg, Object x, A y) {
    if (!eq(x, y)) {
      throw fail((msg != null ? msg + ": " : "") + "expected: " + x + ", got: " + y);
    } else
      print("OK" + (empty(msg) ? "" : " " + msg) + ": " + (x));
    return y;
  }

  static public <A> A liftLast(List<A> l) {
    if (empty(l))
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  static public <A> List<A> liftLast(int n, List<A> l) {
    int i = l(l) - n;
    List<A> part = cloneSubList(l, i);
    removeSubList(l, i);
    return part;
  }

  static public byte[] boolArrayToBytes(boolean[] a) {
    byte[] b = new byte[(l(a) + 7) / 8];
    for (int i = 0; i < l(a); i++) if (a[i])
      b[i / 8] |= 1 << (i & 7);
    return b;
  }

  static public int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  static public int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(int a, int b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(long a, long b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  static public int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  static public boolean isDigit(char c) {
    return Character.isDigit(c);
  }

  static public List<String> javaTokForStructure(String s) {
    return javaTok_noMLS(s);
  }

  static public String structure_addTokenMarkers(String s) {
    return join(structure_addTokenMarkers(javaTokForStructure(s)));
  }

  static public List<String> structure_addTokenMarkers(List<String> tok) {
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return tok;
    for (int i : refs) {
      int idx = i * 2 + 1;
      if (idx >= l(tok))
        continue;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return tok;
  }

  static public String jreplace(String s, String in, String out) {
    return jreplace(s, in, out, null);
  }

  static public String jreplace(String s, String in, String out, Object condition) {
    List<String> tok = javaTok(s);
    return jreplace(tok, in, out, condition) ? join(tok) : s;
  }

  static public boolean jreplace(List<String> tok, String in, String out) {
    return jreplace(tok, in, out, false, true, null);
  }

  static public boolean jreplace(List<String> tok, String in, String out, Object condition) {
    return jreplace(tok, in, out, false, true, condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
    return jreplace(tok, in, out, (Object) condition);
  }

  static public boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
    String[] toks = javaTokForJFind_array(in);
    int lTokin = toks.length * 2 + 1;
    boolean anyChange = false;
    int i = -1;
    for (int n = 0; n < 10000; n++) {
      i = findCodeTokens(tok, i + 1, ignoreCase, toks, condition);
      if (i < 0)
        return anyChange;
      List<String> subList = tok.subList(i - 1, i + lTokin - 1);
      String expansion = jreplaceExpandRefs(out, subList);
      int end = i + lTokin - 2;
      clearAllTokens(tok, i, end);
      tok.set(i, expansion);
      if (reTok)
        reTok(tok, i, end);
      i = end;
      anyChange = true;
    }
    throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
  }

  static public boolean jreplace_debug = false;

  static public boolean domainIsUnder(String domain, String mainDomain) {
    return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
  }

  static public String theAGIBlueDomain() {
    return "agi.blue";
  }

  static public String dropSuffix(String suffix, String s) {
    return s.endsWith(suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean isOK(String s) {
    s = trim(s);
    return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
  }

  static public String sendOpt(String bot, String text, Object... args) {
    return sendToLocalBotOpt(bot, text, args);
  }

  static public boolean isMainProgram() {
    return creator() == null;
  }

  static public void cleanKill() {
    cleanKillVM();
  }

  static public String dbBotName(String progIDWithCase) {
    return fsI_flex(progIDWithCase) + " Concepts";
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
    return methodsBot2(name, receiver, exposedMethods, null);
  }

  static public Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
    Android3 android = new Android3();
    android.greeting = name;
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        return exposeMethods2(receiver, s, exposedMethods, lock);
      }
    };
    return makeBot(android);
  }

  static public List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

  static public List<String> db_standardExposedMethods() {
    return db_standardExposedMethods_list;
  }

  static public Matcher regexp(String pat, String s) {
    return regexp(compileRegexp(pat), unnull(s));
  }

  static public Matcher regexp(java.util.regex.Pattern pat, String s) {
    return pat.matcher(unnull(s));
  }

  static public java.util.regex.Pattern regexp(String pat) {
    return compileRegexp(pat);
  }

  static public File programDir_mine;

  static public File programDir() {
    return programDir(getProgramID());
  }

  static public File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  static public File programDir(String snippetID, String subPath) {
    return new File(programDir(snippetID), subPath);
  }

  static public List<File> listFilesNotDirs(String dir) {
    return listFilesOnly(dir);
  }

  static public List<File> listFilesNotDirs(File... dirs) {
    return listFilesOnly(dirs);
  }

  static public int matcherInt(Matcher m, int i) {
    return parseInt(m.group(i));
  }

  static public long timestampFromYMDH(int y, int m, int d, int h) {
    return new GregorianCalendar(y, m - 1, d, h, 0).getTimeInMillis();
  }

  static public <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
    sort(l, mapComparator(map));
    return l;
  }

  static public String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  static public String n(Collection l, String name) {
    return n(l(l), name);
  }

  static public String n(Map m, String name) {
    return n(l(m), name);
  }

  static public String n(Object[] a, String name) {
    return n(l(a), name);
  }

  static public String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

  static public boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
    if (age <= 0.5)
      return true;
    if (age <= 7 && age >= lastAge + 1)
      return true;
    if (age <= 28 && age >= lastAge + 7)
      return true;
    if (age >= lastAge + 365.0 / 12)
      return true;
    return false;
  }

  static public String programIDWithCase() {
    return nempty(caseID()) ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID()) : programID();
  }

  static public Set<String> listFields(Object c) {
    TreeSet<String> fields = new TreeSet();
    for (Field f : _getClass(c).getDeclaredFields()) fields.add(f.getName());
    return fields;
  }

  static public Method fastIntern_method;

  static public String fastIntern(String s) {
    try {
      if (s == null)
        return null;
      if (fastIntern_method == null) {
        fastIntern_method = findMethodNamed(javax(), "internPerProgram");
        if (fastIntern_method == null)
          upgradeJavaXAndRestart();
      }
      return (String) fastIntern_method.invoke(null, s);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String assertIsIdentifier(String s) {
    if (!isIdentifier(s))
      throw fail("Not an identifier: " + quote(s));
    return s;
  }

  static public String assertIsIdentifier(String msg, String s) {
    if (!isIdentifier(s))
      throw fail(msg + " - Not an identifier: " + quote(s));
    return s;
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
    return map(l, f);
  }

  static public <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
    return map(l, f);
  }

  static public <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
    return synchroMap(new MRUCache(maxSize));
  }

  static public List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }

  static public boolean equalsIgnoreCase(String a, String b) {
    return eqic(a, b);
  }

  static public boolean equalsIgnoreCase(char a, char b) {
    return eqic(a, b);
  }

  static public Throwable getException(Runnable r) {
    try {
      callF(r);
      return null;
    } catch (Throwable e) {
      return e;
    }
  }

  static public Object sleepQuietly_monitor = new Object();

  static public void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File getProgramDir() {
    return programDir();
  }

  static public File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  static public boolean even(int i) {
    return (i & 1) == 0;
  }

  static public boolean even(long i) {
    return (i & 1) == 0;
  }

  static public String _computerID;

  static public Lock computerID_lock = lock();

  public static String computerID() {
    if (_computerID == null) {
      Lock __0 = computerID_lock;
      lock(__0);
      try {
        if (_computerID != null)
          return _computerID;
        File file = computerIDFile();
        _computerID = loadTextFile(file.getPath());
        if (_computerID == null) {
          _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
          if (_computerID == null)
            _computerID = makeRandomID(12, new SecureRandom());
          saveTextFile(file, _computerID);
        }
      } finally {
        unlock(__0);
      }
    }
    return _computerID;
  }

  static public String joinNempties(String sep, String... strings) {
    return joinStrings(sep, strings);
  }

  static public String joinNempties(String sep, Collection<String> strings) {
    return joinStrings(sep, strings);
  }

  static public String stream2string(InputStream in) {
    return utf8streamToString(in);
  }

  static public <A> A _registerIOWrap(A wrapper, Object wrapped) {
    return wrapper;
  }

  static public char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  static public <A> A[] dropLast(A[] a) {
    return dropLast(a, 1);
  }

  static public <A> A[] dropLast(A[] a, int n) {
    if (a == null)
      return null;
    n = Math.min(n, a.length);
    A[] b = arrayOfSameType(a, a.length - n);
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  static public <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  static public <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  static public <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  static public String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  static public String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  static public String dropLast(int n, String s) {
    return dropLast(s, n);
  }

  static public Charset utf8charset_cache;

  static public Charset utf8charset() {
    if (utf8charset_cache == null)
      utf8charset_cache = utf8charset_load();
    return utf8charset_cache;
  }

  static public Charset utf8charset_load() {
    return Charset.forName("UTF-8");
  }

  static public <A, B> Map<A, B> syncMRUCache(int size) {
    return synchroMap(new MRUCache(size));
  }

  static public File localSnippetsDir() {
    return javaxDataDir("Personal Programs");
  }

  static public File localSnippetsDir(String sub) {
    return newFile(localSnippetsDir(), sub);
  }

  static public File oneOfTheFiles(String... paths) {
    if (paths != null)
      for (String path : paths) if (fileExists(path))
        return newFile(path);
    return null;
  }

  static public File oneOfTheFiles(File... files) {
    if (files != null)
      for (File f : files) if (fileExists(f))
        return f;
    return null;
  }

  static public File javaxSecretDir_dir;

  static public File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  static public File javaxSecretDir(String sub) {
    return newFile(javaxSecretDir(), sub);
  }

  static public void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void _registerIO(Object object, String path, boolean opened) {
  }

  static public boolean isLoopbackIP(String ip) {
    return eq(ip, "127.0.0.1");
  }

  static public int myVMPort() {
    List records = (List) (get(getJavaX(), "record_list"));
    Object android = last(records);
    return or0((Integer) get(android, "port"));
  }

  static public String thisVMGreeting() {
    List record_list = (List) (get(getJavaX(), "record_list"));
    Object android = first(record_list);
    return getString(android, "greeting");
  }

  static public String sendToThisVM_newThread(String s, Object... args) {
    final String _s = format(s, args);
    try {
      return (String) evalInNewThread(new F0<Object>() {

        public Object get() {
          try {
            return callStaticAnswerMethod(getJavaX(), _s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ret callStaticAnswerMethod(getJavaX(), _s);";
        }
      });
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      return str(e);
    }
  }

  static public <A> A popFirst(List<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(0);
    return a;
  }

  static public <A> A popFirst(Collection<A> l) {
    if (empty(l))
      return null;
    A a = first(l);
    l.remove(a);
    return a;
  }

  static public <A> List<A> popFirst(int n, List<A> l) {
    List<A> part = cloneSubList(l, 0, n);
    removeSubList(l, 0, n);
    return part;
  }

  static public Set vm_generalWeakSet(Object name) {
    synchronized (get(javax(), "generalMap")) {
      Set set = (Set) (vm_generalMap_get(name));
      if (set == null)
        vm_generalMap_put(name, set = newWeakHashSet());
      return set;
    }
  }

  static public Class primitiveToBoxedType(Class type) {
    if (type == boolean.class)
      return Boolean.class;
    if (type == int.class)
      return Integer.class;
    if (type == long.class)
      return Long.class;
    if (type == float.class)
      return Float.class;
    if (type == short.class)
      return Short.class;
    if (type == char.class)
      return Character.class;
    if (type == byte.class)
      return Byte.class;
    if (type == double.class)
      return Double.class;
    return null;
  }

  static public boolean renameFile(File a, File b) {
    mkdirsForFile(b);
    return a.renameTo(b);
  }

  static public boolean renameFile(File a, String newName) {
    return renameFile(a, fileInSameDir(a, newName));
  }

  static public <A> A logStructureWithDate(File logFile, A o) {
    logQuoted(logFile, now() + " " + structure(o));
    return o;
  }

  static public <A> A logStructureWithDate(String fileName, A o) {
    return logStructureWithDate(getProgramFile(fileName), o);
  }

  static public File mechListAppendLogFile(String listName) {
    return javaxDataDir("Mech List Appends/" + uniqueFileNameUsingMD5_80(listName));
  }

  static public Lock appendToFile_lock = lock();

  static public boolean appendToFile_keepOpen = false;

  static public HashMap<String, Writer> appendToFile_writers = new HashMap();

  static public void appendToFile(String path, String s) {
    try {
      Lock __0 = appendToFile_lock;
      lock(__0);
      try {
        mkdirsForFile(new File(path));
        path = getCanonicalPath(path);
        Writer writer = appendToFile_writers.get(path);
        if (writer == null) {
          writer = new BufferedWriter(new OutputStreamWriter(newFileOutputStream(path, true), "UTF-8"));
          if (appendToFile_keepOpen)
            appendToFile_writers.put(path, writer);
        }
        writer.write(s);
        if (!appendToFile_keepOpen)
          writer.close();
      } finally {
        unlock(__0);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void appendToFile(File path, String s) {
    if (path != null)
      appendToFile(path.getPath(), s);
  }

  static public void cleanMeUp_appendToFile() {
    AutoCloseable __3 = tempCleaningUp();
    try {
      Lock __1 = appendToFile_lock;
      lock(__1);
      try {
        closeAllWriters(values(appendToFile_writers));
        appendToFile_writers.clear();
      } finally {
        unlock(__1);
      }
    } finally {
      _close(__3);
    }
  }

  static public File createLocalMechListFile(String listName) {
    File nameFile = localMechListNameFile(listName);
    if (!nameFile.exists())
      saveTextFile(nameFile, listName);
    return localMechListFile(listName);
  }

  static public String assureTrailingNewLine(String s) {
    return addSuffix(s, "\n");
  }

  static public int jfind(String s, String in) {
    return jfind(javaTok(s), in);
  }

  static public int jfind(List<String> tok, String in) {
    return jfind(tok, 1, in);
  }

  static public int jfind(List<String> tok, int startIdx, String in) {
    return jfind(tok, startIdx, in, null);
  }

  static public int jfind(List<String> tok, String in, Object condition) {
    return jfind(tok, 1, in, condition);
  }

  static public int jfind(List<String> tok, int startIdx, String in, Object condition) {
    return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
  }

  static public int jfind(List<String> tok, List<String> tokin) {
    return jfind(tok, 1, tokin);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin) {
    return jfind(tok, startIdx, tokin, null);
  }

  static public int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
    return findCodeTokens(tok, startIdx, false, tokinC, condition);
  }

  static public int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
    return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
  }

  static public List<String> jfind_preprocess(List<String> tok) {
    for (String type : litlist("quoted", "id", "int")) replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
    replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
    return tok;
  }

  static public String joinSubList(List<String> l, int i, int j) {
    return join(subList(l, i, j));
  }

  static public String joinSubList(List<String> l, int i) {
    return join(subList(l, i));
  }

  static public String joinSubList(List<String> l, IntRange r) {
    return r == null ? null : joinSubList(l, r.start, r.end);
  }

  static public int latestInstalledJavaX() {
    File[] files = new File(userHome(), ".javax").listFiles();
    int v = 0;
    if (files != null)
      for (File f : files) {
        Matcher m = Pattern.compile("x(\\d\\d\\d?)\\.jar").matcher(f.getName());
        if (m.matches())
          v = Math.max(v, Integer.parseInt(m.group(1)));
      }
    return v;
  }

  static public String x30JarServerURL() {
    return "http://botcompany.de:8081/x30.jar";
  }

  static public ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();

  static public ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

  static public byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage(URLConnection con) {
    try {
      Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
      setHeaders(con);
      for (String key : keys(extraHeaders)) con.setRequestProperty(key, extraHeaders.get(key));
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      loadBinaryPage_responseHeaders.set(con.getHeaderFields());
      long len = 0;
      try {
        len = con.getContentLength();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] saveBinaryFile(String fileName, byte[] contents) {
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
      fileOutputStream.write(contents);
      fileOutputStream.close();
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (!new File(tempFileName).renameTo(file))
        throw new IOException("Can't rename " + tempFileName + " to " + fileName);
      vmBus_send("wroteFile", file);
      return contents;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] saveBinaryFile(File fileName, byte[] contents) {
    return saveBinaryFile(fileName.getPath(), contents);
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
    return newSubListOrSame(l, startIndex, l(l));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
    if (l == null)
      return null;
    int n = l(l);
    startIndex = max(0, startIndex);
    endIndex = min(n, endIndex);
    if (startIndex >= endIndex)
      return ll();
    if (startIndex == 0 && endIndex == n)
      return l;
    return cloneList(l.subList(startIndex, endIndex));
  }

  static public <A> List<A> newSubListOrSame(List<A> l, IntRange r) {
    return newSubListOrSame(l, r.start, r.end);
  }

  static public int[] takeFirstOfIntArray(int[] b, int n) {
    return subIntArray(b, 0, n);
  }

  static public int[] takeFirstOfIntArray(int n, int[] b) {
    return takeFirstOfIntArray(b, n);
  }

  static public String hms() {
    return hms(now());
  }

  static public String hms(long time) {
    return new SimpleDateFormat("HHmmss").format(time);
  }

  static public boolean isQuoted(String s) {
    if (isNormalQuoted(s))
      return true;
    return isMultilineQuoted(s);
  }

  static public String platformQuote(String s) {
    return isWindows() ? winQuote(s) : bashQuote(s);
  }

  static public String platformQuote(File f) {
    return platformQuote(f2s(f));
  }

  static public boolean isOnPATH(String cmd) {
    return findCmdOnPATH(cmd) != null;
  }

  static public <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  static public <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  static public boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  static public ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

  static public AutoCloseable holdInstance(Object o) {
    if (o == null)
      return null;
    listThreadLocalAdd(holdInstance_l, o);
    return new AutoCloseable() {

      public void close() {
        listThreadLocalPopLast(holdInstance_l);
      }
    };
  }

  static public Runnable asRunnable(Object o) {
    return toRunnable(o);
  }

  static public void _inheritThreadInfo(Object info) {
    _threadInheritInfo(info);
  }

  static public Component childWithClassNameEndingWith(Component c, String suffix) {
    if (endsWith(className(c), suffix))
      return c;
    Component x;
    for (Component comp : getComponents(c)) if ((x = childWithClassNameEndingWith(comp, suffix)) != null)
      return x;
    return null;
  }

  static public Frame getAWTFrame(final Object _o) {
    return swing(new F0<Frame>() {

      public Frame get() {
        try {
          Object o = _o;
          if (o instanceof ButtonGroup)
            o = first(buttonsInGroup((ButtonGroup) o));
          if (!(o instanceof Component))
            return null;
          Component c = (Component) o;
          while (c != null) {
            if (c instanceof Frame)
              return (Frame) c;
            c = c.getParent();
          }
          return null;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ...";
      }
    });
  }

  static public Method findMethod_cached(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        _MethodCache cache = callOpt_getCache(((Class) o));
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
            return m;
        return null;
      } else {
        _MethodCache cache = callOpt_getCache(o.getClass());
        List<Method> methods = cache.cache.get(method);
        if (methods != null)
          for (Method m : methods) if (findMethod_checkArgs(m, args, false))
            return m;
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String[] asStringArray(Collection<String> c) {
    return toStringArray(c);
  }

  static public String[] asStringArray(Object o) {
    return toStringArray(o);
  }

  static public Object vmBus_query(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    {
      Object __1 = pcallFAll_returnFirstNotNull(vm_busListeners_live(), msg, arg);
      if (__1 != null)
        return __1;
    }
    return pcallFAll_returnFirstNotNull(vm_busListenersByMessage_live().get(msg), msg, arg);
  }

  static public Object vmBus_query(String msg) {
    return vmBus_query(msg, (Object) null);
  }

  static public Object dm_callOS(String functionName, Object... args) {
    return call(dm_os(), functionName, args);
  }

  static public Object dm_resolveModule(Object moduleOrStem) {
    return dm_callOS("resolveModule", moduleOrStem);
  }

  static public boolean isSubclassOf(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public DynModule dm_currentModuleMandatory() {
    return dm_current_mandatory();
  }

  static public <A> AutoCloseable tempAdd(final Collection<A> l, final A a) {
    if (l == null || l.contains(a))
      return null;
    l.add(a);
    return new AutoCloseable() {

      public String toString() {
        return "l.remove(a);";
      }

      public void close() throws Exception {
        l.remove(a);
      }
    };
  }

  static public <A> A second(List<A> l) {
    return get(l, 1);
  }

  static public <A> A second(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    if (!it.hasNext())
      return null;
    it.next();
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A second(A[] bla) {
    return bla == null || bla.length <= 1 ? null : bla[1];
  }

  static public <A, B> B second(Pair<A, B> p) {
    return p == null ? null : p.b;
  }

  static public <A> A second(Producer<A> p) {
    if (p == null)
      return null;
    if (p.next() == null)
      return null;
    return p.next();
  }

  static public char second(String s) {
    return charAt(s, 1);
  }

  static public <A> A third(List<A> l) {
    return _get(l, 2);
  }

  static public <A> A third(Iterable<A> l) {
    if (l == null)
      return null;
    Iterator<A> it = iterator(l);
    for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++) {
      if (!it.hasNext())
        return null;
      it.next();
    }
    return it.hasNext() ? it.next() : null;
  }

  static public <A> A third(Producer<A> p) {
    if (p == null)
      return null;
    for (int _repeat_1 = 0; _repeat_1 < 2; _repeat_1++) {
      if (p.next() == null)
        return null;
    }
    return p.next();
  }

  static public <A> A third(A[] bla) {
    return bla == null || bla.length <= 2 ? null : bla[2];
  }

  static public <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  static public char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  static public int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public double last(double[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  static public <A> A last(A[] a) {
    return l(a) != 0 ? a[l(a) - 1] : null;
  }

  static public <A> A last(Iterator<A> it) {
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(Collection<A> l) {
    if (l == null)
      return null;
    if (l instanceof List)
      return (A) last(((List) l));
    if (l instanceof SortedSet)
      return (A) last(((SortedSet) l));
    Iterator<A> it = iterator(l);
    A a = null;
    while (it.hasNext()) {
      ping();
      a = it.next();
    }
    return a;
  }

  static public <A> A last(SortedSet<A> l) {
    return l == null ? null : l.last();
  }

  static public <A> VF1<A> runnableToVF1(final Runnable r) {
    return r == null ? null : new VF1<A>() {

      public void get(A a) {
        try {
          r.run();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "r.run()";
      }
    };
  }

  static public boolean containsSpaces(String s) {
    return indexOf(s, ' ') >= 0;
  }

  static public <A> A getOrKeep(Map<A, ? extends A> map, A a) {
    if (map == null)
      return a;
    A v = map.get(a);
    return v != null ? v : a;
  }

  static public List<String> ai_splitCamelCase(String s) {
    int j = 0;
    List<String> l = new ArrayList();
    if (isAllUpperCase(s)) {
      l.add(s);
      return l;
    }
    for (int i = 0; i < l(s); i++) if (i > j && isUpperCaseLetter(s.charAt(i))) {
      l.add(substring(s, j, i));
      j = i;
    }
    if (j < l(s))
      l.add(substring(s, j));
    return l;
  }

  static public void fillJMenu(final JMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof List)
        fillJMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o)) {
        if (menuItemCount(m) != 0)
          m.addSeparator();
      } else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem(or2(unCurlyBracket(lv.get()), "..."), y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
              revalidate(m);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv.get();\r\n        if (isCurlyBracketed(s)) {\r\n          setEnable...";
          }
        });
        print("bound live value " + lv + " to menu item " + mi);
        m.add(mi);
        ++i;
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o == null && y instanceof Runnable)
        ++i;
      else
        print("Unknown menu item: " + o);
    }
  }

  static public void fillJPopupMenu(JPopupMenu m, Object... x) {
    if (x == null)
      return;
    for (int i = 0; i < l(x); i++) {
      Object o = x[i], y = get(x, i + 1);
      if (o instanceof IVF1)
        callF(o, m);
      else if (o instanceof List)
        fillJPopupMenu(m, asArray((List) o));
      else if (isMenuSeparatorIndicator(o))
        m.addSeparator();
      else if (o instanceof LiveValue && ((LiveValue) o).getType() == String.class && isRunnableX(y)) {
        final LiveValue<String> lv = (LiveValue<String>) o;
        final JMenuItem mi = jmenuItem("", y);
        bindLiveValueListenerToComponent(mi, lv, new Runnable() {

          public void run() {
            try {
              String s = lv.get();
              if (isCurlyBracketed(s)) {
                setEnabled(mi, false);
                s = unCurlyBracket(s);
              } else
                setEnabled(mi, true);
              setText(mi, s);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "String s = lv.get();\r\n        if (isCurlyBracketed(s)) {\r\n          setEnable...";
          }
        });
        m.add(mi);
      } else if (o instanceof String && isRunnableX(y)) {
        m.add(jmenuItem((String) o, y));
        ++i;
      } else if (o instanceof JMenuItem)
        m.add((JMenuItem) o);
      else if (o instanceof String || o instanceof Action || o instanceof Component)
        call(m, "add", o);
      else if (o != null)
        print("Unknown menu item: " + o);
    }
  }

  static public JInternalFrame showForm_makeInternalFrame(JDesktopPane desktop, String title, JPanel panel) {
    JInternalFrame f = addInternalFrame(desktop, title, withMargin(panel));
    minInternalFrameWidth(f, 400);
    packInternalFrameVertically(f);
    centerInternalFrame(f);
    return f;
  }

  static public JFrame handleEscapeKey(final JFrame frame) {
    KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    frame.getRootPane().registerKeyboardAction(new ActionListener() {

      public void actionPerformed(ActionEvent actionEvent) {
        frame.dispose();
      }
    }, stroke, JComponent.WHEN_IN_FOCUSED_WINDOW);
    return frame;
  }

  static public JFrame minFrameWidth(JFrame frame, int w) {
    if (frame != null && frame.getWidth() < w)
      frame.setSize(w, frame.getHeight());
    return frame;
  }

  static public JFrame minFrameWidth(int w, JFrame frame) {
    return minFrameWidth(frame, w);
  }

  static public JFrame showPackedFrame(String title, Component contents) {
    return packFrame(showFrame(title, contents));
  }

  static public JFrame showPackedFrame(Component contents) {
    return packFrame(showFrame(contents));
  }

  static public int withMargin_defaultWidth = 6;

  static public JPanel withMargin(Component c) {
    return withMargin(withMargin_defaultWidth, c);
  }

  static public JPanel withMargin(int w, Component c) {
    return withMargin(w, w, c);
  }

  static public JPanel withMargin(int w, int h, Component c) {
    return withMargin(w, h, w, h, c);
  }

  static public JPanel withMargin(final int top, final int left, final int bottom, final int right, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public int showForm_leftWidth(List<List<JComponent>> l) {
    int minW = 0;
    for (List<JComponent> row : l) minW = max(minW, getMinimumSize(first(row)).width);
    return minW;
  }

  static public int withRightMargin_defaultWidth = 6;

  static public JPanel withRightMargin(Component c) {
    return withRightMargin(withRightMargin_defaultWidth, c);
  }

  static public JPanel withRightMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, w));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public <A extends Component> A jMinWidth(final int w, final A c) {
    if (c == null)
      return null;
    return swing(new F0<A>() {

      public A get() {
        try {
          Dimension size = c.getMinimumSize();
          c.setMinimumSize(new Dimension(w, size.height));
          return jPreferWidth(w, c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Dimension size = c.getMinimumSize();\r\n    c.setMinimumSize(new Dimension(/*ma...";
      }
    });
  }

  static public void setComponentID(Component c, String id) {
    if (c != null)
      componentID_map.put(c, id);
  }

  static public List mapLL(Object f, Object... data) {
    return map(f, ll(data));
  }

  static public Component wrapForSmartAdd(Object o) {
    if (o == null)
      return jpanel();
    if (o instanceof String)
      return jlabel((String) o);
    return wrap(o);
  }

  static public boolean isRunnable(Object o) {
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public JButton jbutton(String text, Object action) {
    return newButton(text, action);
  }

  static public JButton jbutton(String text) {
    return newButton(text, null);
  }

  static public JButton jbutton(Action action) {
    return swingNu(JButton.class, action);
  }

  static public String showFormSubmitButtonName() {
    return "Submit";
  }

  static public void disposeInternalFrame(Component c) {
    final JInternalFrame f = getInternalFrame(c);
    if (f != null) {
      swing(new Runnable() {

        public void run() {
          try {
            f.dispose();
            setOpt(f, "lastFocusOwner", null);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.dispose();\r\n    setOpt(f, lastFocusOwner := null); // Help GC";
        }
      });
    }
  }

  static public <A> A heldInstance(Class<A> c) {
    List<Object> l = holdInstance_l.get();
    for (int i = l(l) - 1; i >= 0; i--) {
      Object o = l.get(i);
      if (isInstanceOf(o, c))
        return (A) o;
    }
    throw fail("No instance of " + className(c) + " held");
  }

  static public void disposeFrame(final Component c) {
    disposeWindow(c);
  }

  static public void onEnterInAllTextFields(JComponent c, Object action) {
    if (action == null)
      return;
    for (Component tf : allChildren(c)) onEnterIfTextField(tf, action);
  }

  static public void onEnterInAllTextFields(List c, Object action) {
    for (Object o : unnull(c)) if (o instanceof JComponent)
      onEnterInAllTextFields((JComponent) o, action);
  }

  static public void clickButton(final JButton b) {
    if (b != null) {
      swing(new Runnable() {

        public void run() {
          try {
            if (b.isEnabled())
              b.doClick();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (b.isEnabled())\r\n      b.doClick();";
        }
      });
    }
  }

  static public <A extends JComponent> A makeBold(final A c) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setFont(c.getFont().deriveFont(java.awt.Font.BOLD));";
        }
      });
    }
    return c;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, List parts) {
    for (Object o : parts) panel.add(wrapForSmartAdd(o), layout);
    return panel;
  }

  static public JPanel smartAddWithLayout(JPanel panel, Object layout, Object... parts) {
    return smartAddWithLayout(panel, layout, asList(flattenArray2(parts)));
  }

  static public Object[] toObjectArray(Collection c) {
    List l = asList(c);
    return l.toArray(new Object[l.size()]);
  }

  static public <A> List<A> nonNulls(List<A> l) {
    return withoutNulls(l);
  }

  static public <A> List<A> nonNulls(A[] l) {
    return withoutNulls(l);
  }

  static public <A, B> Map<A, B> nonNulls(Map<A, B> map) {
    return withoutNulls(map);
  }

  static public Component jrigid() {
    return javax.swing.Box.createRigidArea(new Dimension(0, 0));
  }

  static public String getText(final AbstractButton c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JTextComponent c) {
    return c == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return c.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getText();";
      }
    });
  }

  static public String getText(final JLabel l) {
    return l == null ? "" : (String) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          return l.getText();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret l.getText();";
      }
    });
  }

  static public String getText(final JComboBox cb) {
    if (cb == null)
      return null;
    if (isEditableComboBox(cb))
      return unnull((String) cb.getEditor().getItem());
    else
      return str(cb.getSelectedItem());
  }

  static public String getFileInfoField(File f, String field) {
    return getOneLineFileInfoField(f, field);
  }

  static public File dropExtension(File f) {
    return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
  }

  static public String dropExtension(String s) {
    return takeFirst(s, smartLastIndexOf(s, '.'));
  }

  static public String htmlQuery(Map params) {
    return empty(params) ? "" : "?" + makePostData(params);
  }

  static public String htmlQuery(Object... data) {
    return empty(data) ? "" : "?" + makePostData(data);
  }

  static public Object[] muricaCredentials() {
    String pass = muricaPassword();
    return nempty(pass) ? new Object[] { "_pass", pass } : new Object[0];
  }

  static public boolean saveTextFileIfDifferent(File f, String contents) {
    if (eq(loadTextFile(f), contents))
      return false;
    {
      saveTextFile(f, contents);
      return true;
    }
  }

  static public <A, B> List<A> keysWithoutHidden(Map<A, B> map) {
    return filter(keys(map), new F1<Object, Boolean>() {

      public Boolean get(Object o) {
        try {
          return !eq(o, "[hidden]") && !isStringStartingWith(o, "[hidden] ");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "!eq(o, \"[hidden]\") && !isStringStartingWith(o, \"[hidden] \")";
      }
    });
  }

  static public List<String> allToString(Iterable c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public List<String> allToString(Object[] c) {
    List<String> l = new ArrayList();
    for (Object o : unnull(c)) l.add(str(o));
    return l;
  }

  static public String structureOrText(Object o) {
    return o instanceof String ? (String) o : structure(o);
  }

  static public Pair<Object[][], Object[]> fillTableWithData_makeData(List<List> rows, List<String> colNames) {
    return fillTableWithData_makeData(rows, asStringArray(colNames));
  }

  static public Pair<Object[][], Object[]> fillTableWithData_makeData(List<List> rows, String... colNames) {
    Object[][] data = new Object[rows.size()][];
    int w = 0;
    for (int i = 0; i < rows.size(); i++) {
      List l = rows.get(i);
      Object[] r = new Object[l.size()];
      for (int j = 0; j < l.size(); j++) {
        Object o = l.get(j);
        if (o instanceof BufferedImage)
          o = imageIcon((BufferedImage) o);
        if (o instanceof RGBImage)
          o = imageIcon((RGBImage) o);
        r[j] = o;
      }
      data[i] = r;
      w = Math.max(w, l.size());
    }
    Object[] columnNames = new Object[w];
    for (int i = 0; i < w; i++) columnNames[i] = i < l(colNames) ? colNames[i] : "?";
    return pair(data, columnNames);
  }

  static public String getProgramTitle() {
    return getProgramName();
  }

  static public void swingNowOrLater(Runnable r) {
    if (isAWTThread())
      r.run();
    else
      swingLater(r);
  }

  static public String makeFrame_defaultIcon;

  static public boolean makeFrame_hideConsole = false;

  static public ThreadLocal<VF1<JFrame>> makeFrame_post = new ThreadLocal();

  static public JFrame makeFrame() {
    return makeFrame((Component) null);
  }

  static public JFrame makeFrame(Object content) {
    return makeFrame(programTitle(), content);
  }

  static public JFrame makeFrame(String title) {
    return makeFrame(title, null);
  }

  static public JFrame makeFrame(String title, Object content) {
    return makeFrame(title, content, true);
  }

  static public JFrame makeFrame(final String title, final Object content, final boolean showIt) {
    final VF1<JFrame> post = optParam(makeFrame_post);
    return swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          if (getFrame(content) != null)
            return getFrame(setFrameTitle((Component) content, title));
          final JFrame frame = new JFrame(title);
          if (makeFrame_defaultIcon != null)
            setFrameIconLater(frame, makeFrame_defaultIcon);
          _initFrame(frame);
          Component wrapped = wrap(content);
          if (wrapped != null)
            frame.getContentPane().add(wrapped);
          frame.setBounds(defaultNewFrameBounds());
          callF(post, frame);
          if (showIt)
            frame.setVisible(true);
          if (showIt && makeFrame_hideConsole) {
            hideConsole();
            makeFrame_hideConsole = false;
          }
          return frame;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ...";
      }
    });
  }

  static public boolean frameTooSmall(JFrame frame) {
    return frame.getWidth() < 100 || frame.getHeight() < 50;
  }

  static public void frameStandardSize(JFrame frame) {
    frame.setBounds(300, 100, 500, 400);
  }

  static public void setFrameContents(final Component c, final Object contents) {
    swing(new Runnable() {

      public void run() {
        try {
          JFrame frame = getFrame(c);
          if (frame == null)
            return;
          frame.getContentPane().removeAll();
          frame.getContentPane().setLayout(new BorderLayout());
          frame.getContentPane().add(wrap(contents));
          revalidate(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JFrame frame = getFrame(c);\r\n  if (frame == null) return;\r\n  frame.getContent...";
      }
    });
  }

  static public Object getTableCell(JTable tbl, int row, int col) {
    if (row >= 0 && row < tbl.getModel().getRowCount())
      return tbl.getModel().getValueAt(row, col);
    return null;
  }

  static public int tableColumnViewIndex(final JTable t, final String colName) {
    return swing(new F0<Integer>() {

      public Integer get() {
        try {
          return t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret t.convertColumnIndexToView(t.getColumn(colName).getModelIndex());";
      }
    });
  }

  static public Runnable _topLevelErrorHandling(final Runnable runnable) {
    final Object info = _threadInfo();
    return new Runnable() {

      public void run() {
        try {
          try {
            _threadInheritInfo(info);
            runnable.run();
          } catch (Throwable __e) {
            _handleException(__e);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "pcall {\r\n      _threadInheritInfo(info);\r\n      runnable.run();\r\n    }";
      }
    };
  }

  static public int localYear() {
    return localYear(now());
  }

  static public int localYear(long time) {
    return parseInt(simpleDateFormat_local("yyyy").format(time));
  }

  static public java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
    java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
    sdf.setTimeZone(timeZone);
    return sdf;
  }

  static public String padLeft(String s, char c, int n) {
    return rep(c, n - l(s)) + s;
  }

  static public String padLeft(String s, int n) {
    return padLeft(s, ' ', n);
  }

  static public int localMonth(long time) {
    return parseInt(simpleDateFormat_local("MM").format(time));
  }

  static public int localMonth() {
    return localMonth(now());
  }

  static public int localDayOfMonth(long time) {
    return parseInt(simpleDateFormat_local("dd").format(time));
  }

  static public int localDayOfMonth() {
    return localDayOfMonth(now());
  }

  static public TimeZone localTimeZone() {
    return getTimeZone(standardTimeZone());
  }

  static public File loadImageAsFile(String snippetIDOrURL) {
    try {
      if (isURL(snippetIDOrURL))
        throw fail("not implemented");
      if (!isSnippetID(snippetIDOrURL))
        throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
      String snippetID = "" + parseSnippetID(snippetIDOrURL);
      File file = imageSnippetCacheFile(snippetID);
      if (fileSize(file) > 0)
        return file;
      String imageURL = snippetImageURL_noHttps(snippetID);
      System.err.println("Loading image: " + imageURL);
      byte[] data = loadBinaryPage(imageURL);
      saveBinaryFile(file, data);
      return file;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  static public byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL(dataSnippetLink(snippetID));
      print("Loading library: " + hideCredentials(url));
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
        print("Loading library: " + hideCredentials(url));
        data = loadBinaryPage(url.openConnection());
      }
      print("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  static public File loadDataSnippetToFile(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      IResourceLoader rl = vm_getResourceLoader();
      if (rl != null)
        return rl.loadLibrary(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      List<URL> urlsTried = new ArrayList();
      List<Throwable> errors = new ArrayList();
      try {
        URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable e) {
          errors.add(e);
          url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
          print(e);
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        errors.add(e);
        throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] isGIF_magic = bytesFromHex("47494638");

  static public boolean isGIF(byte[] data) {
    return byteArrayStartsWith(data, isGIF_magic);
  }

  static public boolean isGIF(File f) {
    return isGIF(loadBeginningOfBinaryFile(f, l(isGIF_magic)));
  }

  static public <A> void setVar(IVar<A> v, A value) {
    if (v != null)
      v.set(value);
  }

  static public String snippetImageURL(long snippetID) {
    return snippetImageURL(fsI(snippetID));
  }

  static public String snippetImageURL(String snippetID) {
    return snippetImageURL(snippetID, "png");
  }

  static public String snippetImageURL(String snippetID, String contentType) {
    if (snippetID == null || isURL(snippetID))
      return snippetID;
    long id = parseSnippetID(snippetID);
    String url;
    if (isImageServerSnippet(id))
      url = imageServerLink(id);
    else
      url = "https://botcompany.de/img/" + id;
    return url;
  }

  static public List collectField(Iterable c, String field) {
    List l = new ArrayList();
    if (c != null)
      for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  static public List collectField(String field, Iterable c) {
    return collectField(c, field);
  }

  static public void logQuotedWithTime(String s) {
    logQuotedWithTime(standardLogFile(), s);
  }

  static public void logQuotedWithTime(File logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public void logQuotedWithTime(String logFile, String s) {
    logQuoted(logFile, logQuotedWithTime_format(s));
  }

  static public String logQuotedWithTime_format(String s) {
    return (now()) + " " + s;
  }

  static public JTextArea wrappedTextArea(final JTextArea ta) {
    enableWordWrapForTextArea(ta);
    return ta;
  }

  static public JTextArea wrappedTextArea() {
    return wrappedTextArea(jtextarea());
  }

  static public JTextArea wrappedTextArea(String text) {
    JTextArea ta = wrappedTextArea();
    setText(ta, text);
    return ta;
  }

  static public <A extends JComponent> A onClick(final A c, final Object runnable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.addMouseListener(new MouseAdapter() {

              public void mouseClicked(MouseEvent e) {
                callF(runnable, e);
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.addMouseListener(new MouseAdapter {\r\n      public void mouseClicked(MouseEv...";
        }
      });
    }
    return c;
  }

  static public void onClick(JButton btn, final Object runnable) {
    onEnter(btn, runnable);
  }

  static public void disposeWindow(final Window window) {
    if (window != null) {
      swing(new Runnable() {

        public void run() {
          try {
            window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING));
            myFrames_list.remove(window);
            window.dispose();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); //...";
        }
      });
    }
  }

  static public void disposeWindow(final Component c) {
    disposeWindow(getWindow(c));
  }

  static public void disposeWindow(Object o) {
    if (o != null)
      disposeWindow(((Component) o));
  }

  static public void disposeWindow() {
    disposeWindow(heldInstance(Component.class));
  }

  static public Window getWindow(Object o) {
    if (!(o instanceof Component))
      return null;
    Component c = (Component) o;
    while (c != null) {
      if (c instanceof Window)
        return (Window) c;
      c = c.getParent();
    }
    return null;
  }

  static public Dimension getScreenSize() {
    return Toolkit.getDefaultToolkit().getScreenSize();
  }

  static public boolean vmBus_anyFalse(String msg, Object... args) {
    return contains(vmBus_queryAll(msg, args), false);
  }

  static public Map<Component, String> componentID_map = weakHashMap();

  static public String componentID(Component c) {
    return c == null ? null : componentID_map.get(c);
  }

  static public Map<JFrame, Boolean> myFrames_list = weakHashMap();

  static public List<JFrame> myFrames() {
    return swing(new F0<List<JFrame>>() {

      public List<JFrame> get() {
        try {
          return keysList(myFrames_list);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret keysList(myFrames_list);";
      }
    });
  }

  static public <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  static public <A> A[] makeArray(Class<A> type, int n) {
    return (A[]) Array.newInstance(type, n);
  }

  static public int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  static public int lastIndexOf(String a, char b) {
    return a == null ? -1 : a.lastIndexOf(b);
  }

  static public <A> int lastIndexOf(List<A> l, int i, A a) {
    if (l == null)
      return -1;
    for (i = min(l(l), i) - 1; i >= 0; i--) if (eq(l.get(i), a))
      return i;
    return -1;
  }

  static public String asString(Object o) {
    return o == null ? null : o.toString();
  }

  static public String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  static public Object defaultDefaultClassFinder() {
    return new F1<String, Class>() {

      public Class get(String name) {
        Class c = findClass_fullName(name);
        if (c != null)
          return c;
        if (name.startsWith("loadableUtils.utils$"))
          return findClass_fullName("main" + name.substring(19));
        return null;
      }
    };
  }

  static public <A> TreeMap<String, A> caseInsensitiveMap() {
    return new TreeMap(caseInsensitiveComparator());
  }

  static public Object safeUnstructure(String s) {
    return unstructure(s, true);
  }

  static public int parseHexChar(char c) {
    if (c >= '0' && c <= '9')
      return charDiff(c, '0');
    if (c >= 'a' && c <= 'f')
      return charDiff(c, 'a') + 10;
    if (c >= 'A' && c <= 'F')
      return charDiff(c, 'A') + 10;
    return -1;
  }

  static public Class getOuterClass(Class c) {
    return getOuterClass(c, null);
  }

  static public Class getOuterClass(Class c, Object classFinder) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      String name = substring(s, 0, i);
      if (classFinder != null)
        return (Class) callF(classFinder, name);
      return Class.forName(name);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Field> instanceFieldsMap(Object o) {
    Class c = o.getClass();
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map;
  }

  static public Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

  static public Field[] thisDollarOneFields(Class c) {
    synchronized (thisDollarOneFields_cache) {
      Field[] l = thisDollarOneFields_cache.get(c);
      if (l == null)
        thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
      return l;
    }
  }

  static public Field[] thisDollarOneFields_uncached(Class c) {
    List<Field> fields = new ArrayList();
    do {
      for (Field f : c.getDeclaredFields()) if (f.getName().equals("this$1"))
        fields.add(makeAccessible(f));
      c = c.getSuperclass();
    } while (c != null);
    return toArray(new Field[l(fields)], fields);
  }

  static public Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

  static public Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0 && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  static public TreeSet<String> caseInsensitiveSet() {
    return caseInsensitiveSet_treeSet();
  }

  static public TreeSet<String> caseInsensitiveSet(Collection<String> c) {
    return caseInsensitiveSet_treeSet(c);
  }

  static public <A> boolean addToCollection(Collection<A> c, A a) {
    return c != null && c.add(a);
  }

  static public File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
    return newSubList(l, startIndex, endIndex);
  }

  static public <A> List<A> cloneSubList(List<A> l, int startIndex) {
    return newSubList(l, startIndex);
  }

  static public void removeSubList(List l, int from, int to) {
    if (l != null)
      subList(l, from, to).clear();
  }

  static public void removeSubList(List l, int from) {
    if (l != null)
      subList(l, from).clear();
  }

  static public List<String> javaTok_noMLS(String s) {
    ArrayList<String> tok = new ArrayList();
    int l = s == null ? 0 : s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      tok.add(javaTok_substringN(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          int c2 = s.charAt(j);
          if (c2 == opener || c2 == '\n' && opener == '\'') {
            ++j;
            break;
          } else if (c2 == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else
        ++j;
      tok.add(javaTok_substringC(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);

  static public String[] javaTokForJFind_array(String s) {
    String[] tok = javaTokForJFind_array_cache.get(s);
    if (tok == null)
      javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
    return tok;
  }

  static public int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  static public int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  static public HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");

  static public int findCodeTokens_bails, findCodeTokens_nonbails;

  static public interface findCodeTokens_Matcher {

    public boolean get(String token);
  }

  static public int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    int end = tok.size() - tokens.length * 2 + 2, nTokens = tokens.length;
    int i = startIdx | 1;
    String firstToken = tokens[0];
    if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
      while (i < end && !firstToken.equals(tok.get(i))) i += 2;
    }
    findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
    for (int j = 0; j < nTokens; j++) {
      String p = tokens[j];
      findCodeTokens_Matcher matcher;
      if (p.equals("*"))
        matcher = t -> true;
      else if (p.equals("<quoted>"))
        matcher = t -> isQuoted(t);
      else if (p.equals("<id>"))
        matcher = t -> isIdentifier(t);
      else if (p.equals("<int>"))
        matcher = t -> isInteger(t);
      else if (p.equals("\\*"))
        matcher = t -> t.equals("*");
      else if (ignoreCase)
        matcher = t -> eqic(p, t);
      else
        matcher = t -> t.equals(p);
      matchers[j] = matcher;
    }
    outer: for (; i < end; i += 2) {
      for (int j = 0; j < nTokens; j++) if (!matchers[j].get(tok.get(i + j * 2)))
        continue outer;
      if (condition == null || checkTokCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  static public String jreplaceExpandRefs(String s, List<String> tokref) {
    if (!contains(s, '$'))
      return s;
    List<String> tok = javaTok(s);
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("$") && isInteger(t.substring(1))) {
        String x = tokref.get(-1 + parseInt(t.substring(1)) * 2);
        tok.set(i, x);
      } else if (t.equals("\\")) {
        tok.set(i, "");
        i += 2;
      }
    }
    return join(tok);
  }

  static public void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++) tok.set(i, "");
  }

  static public void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++) tok.set(i, "");
  }

  static public List<String> reTok(List<String> tok) {
    replaceCollection(tok, javaTok(tok));
    return tok;
  }

  static public List<String> reTok(List<String> tok, int i) {
    return reTok(tok, i, i + 1);
  }

  static public List<String> reTok(List<String> tok, int i, int j) {
    i = max(i & ~1, 0);
    j = min(l(tok), j | 1);
    if (i >= j)
      return tok;
    List<String> t = javaTok(joinSubList(tok, i, j));
    replaceListPart(tok, i, j, t);
    return tok;
  }

  static public List<String> reTok(List<String> tok, IntRange r) {
    if (r != null)
      reTok(tok, r.start, r.end);
    return tok;
  }

  static public boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  static public boolean ewic(String a, String b, Matches m) {
    return endsWithIgnoreCase(a, b, m);
  }

  static public boolean matchStart(String pat, String s) {
    return matchStart(pat, s, null);
  }

  static public boolean matchStart(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return matchStart(pat, parse3_cachedInput(s), matches);
  }

  static public boolean matchStart(String pat, List<String> toks, Matches matches) {
    if (toks == null)
      return false;
    List<String> tokpat = parse3_cachedPattern(pat);
    if (toks.size() < tokpat.size())
      return false;
    String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
    if (m == null)
      return false;
    if (matches != null) {
      matches.m = new String[m.length + 1];
      arraycopy(m, matches.m);
      matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size());
    }
    return true;
  }

  static public void cleanKillVM() {
    try {
      ping();
      assertNotOnAWTThread();
      cleanKillVM_noSleep();
      Object o = new Object();
      synchronized (o) {
        o.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void cleanKillVM_noSleep() {
    call(getJavaX(), "cleanKill");
  }

  static public String fsI_flex(String s) {
    return startsWithDigit(s) ? "#" + s : s;
  }

  static public boolean exposeMethods2_debug = false;

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames) {
    return exposeMethods2(receiver, s, methodNames, null);
  }

  static public String exposeMethods2(Object receiver, String s, List<String> methodNames, Lock lock) {
    Matches m = new Matches();
    if (exposeMethods2_debug)
      print("Received: " + s);
    if (match("call *", s, m)) {
      List l;
      if (isIdentifier(m.unq(0)))
        l = ll(m.unq(0));
      else
        l = (List) unstructure(m.unq(0));
      String method = getString(l, 0);
      if (!contains(methodNames, method))
        throw fail("Method not allowed: " + method);
      if (lock != null)
        lock.lock();
      try {
        if (exposeMethods2_debug)
          print("Calling: " + method);
        Object o = call(receiver, method, asObjectArray(subList(l, 1)));
        if (exposeMethods2_debug)
          print("Got: " + getClassName(o));
        return ok2(structure(o));
      } finally {
        if (lock != null)
          lock.unlock();
      }
    }
    if (match("list methods", s))
      return ok2(structure(methodNames));
    return null;
  }

  static public int makeBot(String greeting) {
    return makeAndroid3(greeting).port;
  }

  static public Android3 makeBot(Android3 a) {
    makeAndroid3(a);
    return a;
  }

  static public Android3 makeBot(String greeting, Object responder) {
    Android3 a = new Android3(greeting);
    a.responder = makeResponder(responder);
    makeBot(a);
    return a;
  }

  static public Android3 makeBot() {
    return makeAndroid3(defaultBotName());
  }

  static volatile public String caseID_caseID;

  static public String caseID() {
    return caseID_caseID;
  }

  static public void caseID(String id) {
    caseID_caseID = id;
  }

  static public List<File> listFilesOnly(String dir) {
    return listFilesOnly(new File(dir));
  }

  static public List<File> listFilesOnly(File... dirs) {
    return concatMap(rcurry("listFilesWithSuffix", ""), dirs);
  }

  static public <T> void sort(T[] a, Comparator<? super T> c) {
    if (a != null)
      Arrays.sort(a, c);
  }

  static public <T> void sort(T[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public void sort(int[] a) {
    if (a != null)
      Arrays.sort(a);
  }

  static public <T> void sort(List<T> a, Comparator<? super T> c) {
    if (a != null)
      Collections.sort(a, c);
  }

  static public void sort(List a) {
    if (a != null)
      Collections.sort(a);
  }

  static public <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(a), map.get(b));
      }
    };
  }

  static public Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  static public Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

  static public String singular(String s) {
    if (s == null)
      return null;
    {
      String __1 = singular_specials.get(s);
      if (!empty(__1))
        return __1;
    }
    if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  static public List<String> getPlural_specials = ll("sheep", "fish");

  static public String getPlural(String s) {
    if (containsIgnoreCase(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewicOneOf(s, "ss", "ch"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  static public String quoteUnlessIdentifierOrInteger(String s) {
    return quoteIfNotIdentifierOrInteger(s);
  }

  static public void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  static public List<String> dropPunctuation_keep = ll("*", "<", ">");

  static public List<String> dropPunctuation(List<String> tok) {
    tok = new ArrayList<String>(tok);
    for (int i = 1; i < tok.size(); i += 2) {
      String t = tok.get(i);
      if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
        tok.set(i - 1, tok.get(i - 1) + tok.get(i + 1));
        tok.remove(i);
        tok.remove(i);
        i -= 2;
      }
    }
    return tok;
  }

  static public String dropPunctuation(String s) {
    return join(dropPunctuation(nlTok(s)));
  }

  static public void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  static public boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  static public boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  static public File computerIDFile() {
    return javaxDataDir("Basic Info/computer-id.txt");
  }

  static public String makeRandomID(int length) {
    return makeRandomID(length, defaultRandomGenerator());
  }

  static public String makeRandomID(int length, Random random) {
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  static public String makeRandomID(Random r, int length) {
    return makeRandomID(length, r);
  }

  static public String joinStrings(String sep, String... strings) {
    return joinStrings(sep, Arrays.asList(strings));
  }

  static public String joinStrings(String sep, Collection<String> strings) {
    StringBuilder buf = new StringBuilder();
    for (String s : unnull(strings)) if (nempty(s)) {
      if (nempty(buf))
        buf.append(sep);
      buf.append(s);
    }
    return str(buf);
  }

  static public String utf8streamToString(InputStream in) {
    return readerToString(utf8bufferedReader(in));
  }

  static public <A> A[] arrayOfSameType(A[] a, int n) {
    return newObjectArrayOfSameType(a, n);
  }

  static public int or0(Integer i) {
    return i == null ? 0 : i;
  }

  static public long or0(Long l) {
    return l == null ? 0L : l;
  }

  static public double or0(Double d) {
    return d == null ? 0.0 : d;
  }

  static public String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  static public String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  static public String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  static public String getString(String key, Object o) {
    return getString(o, (Object) key);
  }

  static public Object evalInNewThread(final Object f) {
    final Flag flag = new Flag();
    final Var var = new Var();
    final Var<Throwable> exception = new Var();
    {
      startThread(new Runnable() {

        public void run() {
          try {
            try {
              var.set(callF(f));
            } catch (Throwable e) {
              exception.set(e);
            }
            flag.raise();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception...";
        }
      });
    }
    flag.waitUntilUp();
    if (exception.has())
      throw rethrow(exception.get());
    return var.get();
  }

  static public String callStaticAnswerMethod(List bots, String s) {
    for (Object c : bots) try {
      String answer = callStaticAnswerMethod(c, s);
      if (!empty(answer))
        return answer;
    } catch (Throwable e) {
      print("Error calling " + getProgramID(c));
      e.printStackTrace();
    }
    return null;
  }

  static public String callStaticAnswerMethod(Object c, String s) {
    String answer = (String) callOpt(c, "answer", s, litlist(s));
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public String callStaticAnswerMethod(String s) {
    return callStaticAnswerMethod(mc(), s);
  }

  static public String callStaticAnswerMethod(String s, List<String> history) {
    return callStaticAnswerMethod(mc(), s, history);
  }

  static public String callStaticAnswerMethod(Object c, String s, List<String> history) {
    String answer = (String) callOpt(c, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(c, "answer", s);
    return emptyToNull(answer);
  }

  static public File fileInSameDir(File f, String newName) {
    return newFile(parentFile(f), newName);
  }

  static public void logQuoted(String logFile, String line) {
    logQuoted(getProgramFile(logFile), line);
  }

  static public void logQuoted(File logFile, String line) {
    appendToFile(logFile, quote(line) + "\n");
  }

  static public String uniqueFileNameUsingMD5_80(String fullName) {
    return md5(fullName) + " " + takeFirst(80 - 33, fileNameEncode(fullName));
  }

  static public String getCanonicalPath(File f) {
    try {
      return f == null ? null : f.getCanonicalPath();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String getCanonicalPath(String path) {
    return getCanonicalPath(newFile(path));
  }

  static public AutoCloseable tempCleaningUp() {
    return tempSetTL(ping_isCleanUpThread, true);
  }

  static public void closeAllWriters(Collection<? extends Writer> l) {
    for (Writer w : unnull(l)) {
      try {
        w.close();
      } catch (Throwable __e) {
        _handleException(__e);
      }
    }
  }

  static public File localMechListNameFile(String listName) {
    return newFile(localMechListsDir(), uniqueFileNameUsingMD5_80_v2(listName) + ".name");
  }

  static public File localMechListFile(String listName) {
    return newFile(localMechListsDir(), uniqueFileNameUsingMD5_80_v2(listName) + ".text");
  }

  static public String addSuffix(String s, String suffix) {
    return s == null || s.endsWith(suffix) ? s : s + suffix;
  }

  static public String[] codeTokensAsStringArray(List<String> tok) {
    int n = max(0, (l(tok) - 1) / 2);
    String[] out = new String[n];
    for (int i = 0; i < n; i++) out[i] = tok.get(i * 2 + 1);
    return out;
  }

  static public <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
    if (x == null)
      return l;
    int i = 0;
    while (true) {
      i = indexOfSubList(l, x, i);
      if (i < 0)
        break;
      replaceSublist(l, i, i + l(x), y);
      i += l(y);
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
    int n = y.size(), toIndex_new = fromIndex + n;
    if (toIndex_new < toIndex) {
      removeSubList(l, toIndex_new, toIndex);
      copyListPart(y, 0, l, fromIndex, n);
    } else {
      copyListPart(y, 0, l, fromIndex, toIndex - fromIndex);
      if (toIndex_new > toIndex)
        l.addAll(toIndex, subList(y, toIndex - fromIndex));
    }
    return l;
  }

  static public <A> List<A> replaceSublist(List<A> l, IntRange r, List<A> y) {
    return replaceSublist(l, r.start, r.end, y);
  }

  static public <A> A println(A a) {
    return print(a);
  }

  static public int[] subIntArray(int[] b, int start) {
    return subIntArray(b, start, l(b));
  }

  static public int[] subIntArray(int[] b, int start, int end) {
    start = max(start, 0);
    end = min(end, l(b));
    if (start == 0 && end == l(b))
      return b;
    if (start >= end)
      return new int[0];
    int[] x = new int[end - start];
    System.arraycopy(b, start, x, 0, end - start);
    return x;
  }

  static public int[] subIntArray(int[] a, IntRange r) {
    return r == null ? null : subIntArray(a, r.start, r.end);
  }

  static public boolean isNormalQuoted(String s) {
    int l = l(s);
    if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"'))
      return false;
    int j = 1;
    while (j < l) if (s.charAt(j) == '"')
      return j == l - 1;
    else if (s.charAt(j) == '\\' && j + 1 < l)
      j += 2;
    else
      ++j;
    return false;
  }

  static public boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  static public File findCmdOnPATH(String cmd) {
    String path = System.getenv("PATH");
    List<String> dirs = splitAt(path, File.pathSeparator);
    String c = isWindows() ? addSuffix(cmd, ".exe") : cmd;
    for (String dir : dirs) {
      File f = new File(dir, c);
      if (f.isFile())
        return f;
    }
    return null;
  }

  static public <A> A printStructure(String prefix, A o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
    return o;
  }

  static public <A> A printStructure(A o) {
    print(structureForUser(o));
    return o;
  }

  static public <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
    List<A> l = tl.get();
    if (l == null)
      tl.set(l = new ArrayList());
    l.add(a);
  }

  static public <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
    List<A> l = tl.get();
    if (l == null)
      return null;
    A a = popLast(l);
    if (empty(l))
      tl.set(null);
    return a;
  }

  static public List<Component> getComponents(final Component c) {
    return !(c instanceof Container) ? emptyList() : asList(swing(new F0<Component[]>() {

      public Component[] get() {
        try {
          return ((Container) c).getComponents();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret ((Container) c).getComponents();";
      }
    }));
  }

  static public Method findMethod(Object o, String method, Object... args) {
    return findMethod_cached(o, method, args);
  }

  static public boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  static public Object pcallFAll_returnFirstNotNull(Collection l, Object... args) {
    if (l != null)
      for (Object f : cloneList(l)) {
        Object __1 = pcallF(f, args);
        if (__1 != null)
          return __1;
      }
    return null;
  }

  static public Object pcallFAll_returnFirstNotNull(Iterator it, Object... args) {
    while (it.hasNext()) {
      Object __2 = pcallF(it.next(), args);
      if (__2 != null)
        return __2;
    }
    return null;
  }

  static public Object dm_os() {
    {
      Object __1 = vm_generalMap_get("stefansOS");
      if (__1 != null)
        return __1;
    }
    return creator();
  }

  static public boolean isSubclass(Class a, Class b) {
    return a != null && b != null && b.isAssignableFrom(a);
  }

  static public <A> Iterator<A> iterator(Iterable<A> c) {
    return c == null ? emptyIterator() : c.iterator();
  }

  static public char charAt(String s, int i) {
    return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
  }

  static public boolean isAllUpperCase(String s) {
    return hasLettersAllUpperCase(s);
  }

  static public boolean isUpperCaseLetter(char c) {
    return Character.isUpperCase(c);
  }

  static public Object[] asArray(List l) {
    return toObjectArray(l);
  }

  static public <A> A[] asArray(Class<A> type, List l) {
    return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
  }

  static public boolean isMenuSeparatorIndicator(Object o) {
    return eqOneOf(o, "***", "---", "===", "");
  }

  static public int menuItemCount(JMenu menu) {
    return menu == null ? 0 : swing(() -> menu.getItemCount());
  }

  static public boolean isRunnableX(Object o) {
    if (o == null)
      return false;
    if (o instanceof String)
      return hasMethod(mc(), (String) o);
    return o instanceof Runnable || hasMethod(o, "get");
  }

  static public String unCurlyBracket(String s) {
    return tok_unCurlyBracket(s);
  }

  static public <A extends JComponent> A bindLiveValueListenerToComponent(A component, final LiveValue lv, final Runnable listener) {
    if (lv != null)
      bindToComponent(component, new Runnable() {

        public void run() {
          try {
            lv.onChangeAndNow(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ifdef bindLiveValueListenerToComponent_debug\r\n          print(\"bindLiveValueL...";
        }
      }, new Runnable() {

        public void run() {
          try {
            lv.removeOnChangeListener(listener);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "lv.removeOnChangeListener(listener)";
        }
      });
    return component;
  }

  static public boolean isCurlyBracketed(String s) {
    return isCurlyBraced(s);
  }

  static public <A extends JComponent> A setEnabled(A c, boolean enable) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            c.setEnabled(enable);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.setEnabled(enable);";
        }
      });
    }
    return c;
  }

  static public <A extends JComponent> A setEnabled(boolean enable, A c) {
    return setEnabled(c, enable);
  }

  static public boolean setText_opt = true;

  static public <A extends JTextComponent> A setText(A c, Object text) {
    setText((JComponent) c, text);
    return c;
  }

  static public <A extends JComboBox> A setText(final A c, Object text) {
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            c.getEditor().setItem(s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.getEditor().setItem(s);";
        }
      });
    }
    return c;
  }

  static public void setText(JLabel c, Object text) {
    setText((JComponent) c, text);
  }

  static public JButton setText(JButton c, Object text) {
    setText((JComponent) c, jlabel_textAsHTML_center_ifNeeded(strUnnull(text)));
    return c;
  }

  static public <A extends JComponent> A setText(final A c, Object text) {
    if (c == null)
      return null;
    final String s = strUnnull(text);
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (!setText_opt || neq(callOpt(c, "getText"), s))
              call(c, "setText", s);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (!setText_opt || neq(callOpt(c, \"getText\"), s))\r\n      call(c, \"setText\", s);";
        }
      });
    }
    return c;
  }

  static public ThreadLocal<Boolean> addInternalFrame_dontSelect = new ThreadLocal();

  static public ThreadLocal<Integer> addInternalFrame_layer = new ThreadLocal();

  static public ThreadLocal<Boolean> addInternalFrame_toBack = new ThreadLocal();

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h) {
    return addInternalFrame(desktop, title, x, y, w, h, null);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final int x, final int y, final int w, final int h, final Component contents) {
    return addInternalFrame(desktop, title, rect(x, y, w, h), contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Component contents) {
    return addInternalFrame(desktop, title, null, contents);
  }

  static public JInternalFrame addInternalFrame(final JDesktopPane desktop, final String title, final Rect r, final Component contents) {
    final boolean dontSelect = isTrue(optParam(addInternalFrame_dontSelect));
    final boolean toBack = isTrue(optParam(addInternalFrame_toBack));
    final Integer layer = optParam(addInternalFrame_layer);
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame frame;
          if (contents instanceof JInternalFrame)
            frame = (JInternalFrame) contents;
          else {
            frame = jInternalFrame(title);
            setInternalFrameContents(frame, contents);
          }
          frame.setVisible(true);
          desktop.add(frame, layer);
          if (r != null)
            setBounds(frame, r);
          else
            internalFrameDefaultPosition(frame);
          if (dontSelect)
            if (toBack)
              frame.toBack();
            else
              frame.toFront();
          else
            frame.setSelected(true);
          return fixInternalFrame(frame);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame frame;\r\n    if (contents instanceof JInternalFrame)\r\n      fra...";
      }
    });
  }

  static public JInternalFrame addInternalFrame(JDesktopPane desktop, String title) {
    return addInternalFrame(desktop, title, jpanel());
  }

  static public JInternalFrame minInternalFrameWidth(final JInternalFrame frame, final int w) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (frame != null && frame.getWidth() < w)
              frame.setSize(w, frame.getHeight());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (frame != null && frame.getWidth() < w)\r\n      frame.setSize(w, frame.getH...";
        }
      });
    }
    return frame;
  }

  static public JInternalFrame minInternalFrameWidth(int w, JInternalFrame frame) {
    return minInternalFrameWidth(frame, w);
  }

  static public <A extends Component> A packInternalFrameVertically(A c) {
    return packInternalFrameVertically(-1, c);
  }

  static public <A extends Component> A packInternalFrameVertically(int width, A c) {
    final JInternalFrame win = getInternalFrame(c);
    if (win == null)
      return c;
    final int w = width < 0 ? win.getWidth() : width;
    {
      swing(new Runnable() {

        public void run() {
          try {
            win.pack();
            win.setSize(w, win.getHeight());
            fixInternalFrame(win);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "win.pack();\r\n    win.setSize(w, win.getHeight());\r\n    fixInternalFrame(win);";
        }
      });
    }
    return c;
  }

  static public JInternalFrame centerInternalFrame(final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Container c = f.getParent();
            if (c != null) {
              f.setLocation((c.getWidth() - f.getWidth()) / 2, (c.getHeight() - f.getHeight()) / 2);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Container c = f.getParent();\r\n    if (c != null) {\r\n      //print(\"Container ...";
        }
      });
    }
    return f;
  }

  static public JInternalFrame centerInternalFrame(final int w, final int h, final JInternalFrame f) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            f.setSize(w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "f.setSize(w, h);";
        }
      });
    }
    return centerInternalFrame(f);
  }

  static public int packFrame_minw = 150, packFrame_minh = 50;

  static public <A extends Component> A packFrame(final A c) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            Window w = getWindow(c);
            if (w != null) {
              w.pack();
              int maxW = getScreenWidth() - 50, maxH = getScreenHeight() - 50;
              w.setSize(min(maxW, max(w.getWidth(), packFrame_minw)), min(maxH, max(w.getHeight(), packFrame_minh)));
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "Window w = getWindow(c);\r\n    if (w != null) {\r\n      w.pack();\r\n      int ma...";
        }
      });
    }
    return c;
  }

  static public JFrame packFrame(ButtonGroup g) {
    return packFrame(getFrame(g));
  }

  static public Dimension getMinimumSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getMinimumSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getMinimumSize();";
      }
    });
  }

  static public <A extends Component> A jPreferWidth(int w, A c) {
    Dimension size = c.getPreferredSize();
    c.setPreferredSize(new Dimension(w, size.height));
    return c;
  }

  static public boolean newButton_autoToolTip = true;

  static public JButton newButton(final String text, final Object action) {
    return swing(new F0<JButton>() {

      public JButton get() {
        try {
          String text2 = dropPrefix("[disabled] ", text);
          final JButton btn = new JButton(text2);
          if (l(text2) < l(text))
            btn.setEnabled(false);
          if (newButton_autoToolTip) {
            btn.setToolTipText(btn.getText());
          }
          if (action != null)
            btn.addActionListener(actionListener(action, btn));
          return btn;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "S text2 = dropPrefix(\"[disabled] \", text);\r\n    final JButton btn = new JButt...";
      }
    });
  }

  static public boolean isInstanceOf(Object o, Class type) {
    return type.isInstance(o);
  }

  static public List<Component> allChildren(Component c) {
    return childrenOfType(c, Component.class);
  }

  static public void onEnterIfTextField(Component c, Object action) {
    if (action == null)
      return;
    if (c instanceof JTextField)
      onEnter((JTextField) c, action);
    else if (c instanceof JComboBox)
      onEnter((JComboBox) c, action);
  }

  static public Object[] flattenArray2(Object... a) {
    List l = new ArrayList();
    if (a != null)
      for (Object x : a) if (x instanceof Object[])
        l.addAll(asList((Object[]) x));
      else if (x instanceof Collection)
        l.addAll((Collection) x);
      else
        l.add(x);
    return asObjectArray(l);
  }

  static public <A> List<A> withoutNulls(List<A> l) {
    if (!containsNulls(l))
      return l;
    List<A> l2 = new ArrayList();
    for (A a : l) if (a != null)
      l2.add(a);
    return l2;
  }

  static public <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
    Map<A, B> map2 = similarEmptyMap(map);
    for (A a : keys(map)) if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
    return map2;
  }

  static public <A> List<A> withoutNulls(A[] l) {
    List<A> l2 = new ArrayList();
    if (l != null)
      for (A a : l) if (a != null)
        l2.add(a);
    return l2;
  }

  static public String getOneLineFileInfoField(File f, String field) {
    File infoFile = associatedInfosFile(f);
    List<String> lines = lines(loadTextFile(infoFile));
    return firstStartingWithIC_drop(lines, field + ": ");
  }

  static public int smartLastIndexOf(String s, char c) {
    if (s == null)
      return 0;
    int i = s.lastIndexOf(c);
    return i >= 0 ? i : l(s);
  }

  static public String makePostData(Map<Object, Object> map) {
    StringBuilder buf = new StringBuilder();
    for (Map.Entry<Object, Object> e : map.entrySet()) {
      String key = (String) (e.getKey());
      Object val = e.getValue();
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static public String makePostData(Object... params) {
    StringBuilder buf = new StringBuilder();
    int n = l(params);
    for (int i = 0; i + 1 < n; i += 2) {
      String key = (String) (params[i]);
      Object val = params[i + 1];
      if (val != null) {
        String value = str(val);
        if (nempty(buf))
          buf.append("&");
        buf.append(urlencode(key)).append("=").append(urlencode((value)));
      }
    }
    return str(buf);
  }

  static volatile public boolean muricaPassword_pretendNotAuthed = false;

  static public String muricaPassword() {
    if (muricaPassword_pretendNotAuthed)
      return null;
    return trim(loadTextFile(muricaPasswordFile()));
  }

  static public <A> List<A> filter(Iterable<A> c, Object pred) {
    if (pred instanceof F1)
      return filter(c, (F1<A, Boolean>) pred);
    List x = new ArrayList();
    if (c != null)
      for (Object o : c) if (isTrue(callF(pred, o)))
        x.add(o);
    return x;
  }

  static public List filter(Object pred, Iterable c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
    List x = new ArrayList();
    if (c != null)
      for (B o : c) if (pred.get(o))
        x.add(o);
    return x;
  }

  static public <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
    return filter(c, pred);
  }

  static public boolean isStringStartingWith(Object o, String prefix) {
    return o instanceof String && ((String) o).startsWith(prefix);
  }

  static public JFrame setFrameIconLater(Component c, final String imageID) {
    final JFrame frame = getFrame(c);
    if (frame != null)
      startThread("Loading Icon", new Runnable() {

        public void run() {
          try {
            final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
            swingLater(new Runnable() {

              public void run() {
                try {
                  frame.setIconImage(i);
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "frame.setIconImage(i);";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "final Image i = imageIcon(or2(imageID, \"#1005557\")).getImage();\r\n      swingL...";
        }
      });
    return frame;
  }

  static public void _initFrame(JFrame f) {
    myFrames_list.put(f, Boolean.TRUE);
    standardTitlePopupMenu(f);
  }

  static public Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

  static public Rectangle defaultNewFrameBounds() {
    return swing(new F0<Rectangle>() {

      public Rectangle get() {
        try {
          defaultNewFrameBounds_r.translate(60, 20);
          if (!screenRectangle().contains(defaultNewFrameBounds_r))
            defaultNewFrameBounds_r.setLocation(30 + random(30), 20 + random(20));
          return new Rectangle(defaultNewFrameBounds_r);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "defaultNewFrameBounds_r.translate(60, 20);\r\n    if (!screenRectangle().contai...";
      }
    });
  }

  static public void hideConsole() {
    final JFrame frame = consoleFrame();
    if (frame != null) {
      autoVMExit();
      swingLater(new Runnable() {

        public void run() {
          try {
            frame.setVisible(false);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "frame.setVisible(false);";
        }
      });
    }
  }

  static public String rep(int n, char c) {
    return repeat(c, n);
  }

  static public String rep(char c, int n) {
    return repeat(c, n);
  }

  static public <A> List<A> rep(A a, int n) {
    return repeat(a, n);
  }

  static public <A> List<A> rep(int n, A a) {
    return repeat(n, a);
  }

  static public TimeZone getTimeZone(String name) {
    return TimeZone.getTimeZone(name);
  }

  static public String standardTimeZone_name = "Europe/Berlin";

  static public String standardTimeZone() {
    return standardTimeZone_name;
  }

  static public File imageSnippetCacheFile(String snippetID) {
    File dir = imageSnippetsCacheDir();
    if (!loadBufferedImage_useImageCache)
      return null;
    return new File(dir, parseSnippetID(snippetID) + ".png");
  }

  static public String snippetImageURL_noHttps(String snippetID) {
    return snippetImageURL_noHttps(snippetID, "png");
  }

  static public String snippetImageURL_noHttps(String snippetID, String contentType) {
    return snippetImageURL(snippetID, contentType).replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/").replace("https://botcompany.de/", "http://botcompany.de/");
  }

  static public String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1100000 && id < 1200000)
      return imageServerURL() + id;
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      return "https://botcompany.de/files/" + id + "?_pass=" + pw;
    }
    return fileServerURL() + "/" + id;
  }

  static public <B, A extends B> A addAndReturn(Collection<B> c, A a) {
    if (c != null)
      c.add(a);
    return a;
  }

  static public void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      try {
        InputStream inputStream = con.getInputStream();
        long len = 0;
        try {
          len = con.getContentLength();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
        copyStreamWithPrints(inputStream, buf, pat);
        inputStream.close();
        buf.close();
        file.delete();
        renameFile_assertTrue(ftemp, file);
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] bytesFromHex(String s) {
    return hexToBytes(s);
  }

  static public boolean byteArrayStartsWith(byte[] a, byte[] b) {
    if (a == null || b == null)
      return false;
    if (a.length < b.length)
      return false;
    for (int i = 0; i < b.length; i++) if (a[i] != b[i])
      return false;
    return true;
  }

  static public byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
    return loadBinaryFilePart(file, 0, maxBytes);
  }

  static public String imageServerLink(String md5OrID) {
    if (possibleMD5(md5OrID))
      return "https://botcompany.de/images/md5/" + md5OrID;
    return imageServerLink(parseSnippetID(md5OrID));
  }

  static public String imageServerLink(long id) {
    return "https://botcompany.de/images/" + id;
  }

  static public File standardLogFile() {
    return getProgramFile("log");
  }

  static public void enableWordWrapForTextArea(JTextArea ta) {
    enableWordWrapForTextArea(ta, true);
  }

  static public void enableWordWrapForTextArea(JTextArea ta, boolean enabled) {
    if (ta != null) {
      swing(new Runnable() {

        public void run() {
          try {
            ta.setLineWrap(enabled);
            ta.setWrapStyleWord(true);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "ta.setLineWrap(enabled);\r\n    ta.setWrapStyleWord(true);\r\n    // Haven't foun...";
        }
      });
    }
  }

  static public JTextArea jtextarea() {
    return jTextArea();
  }

  static public JTextArea jtextarea(String text) {
    return jTextArea(text);
  }

  static public boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  static public boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  static public boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  static public boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  static public boolean contains(BitSet bs, int i) {
    return bs != null && bs.get(i);
  }

  static public <A> boolean contains(Producer<A> p, A a) {
    if (p != null && a != null)
      while (true) {
        A x = p.next();
        if (x == null)
          break;
        if (eq(x, a))
          return true;
      }
    return false;
  }

  static public List vmBus_queryAll(String msg, Object... args) {
    Object arg = vmBus_wrapArgs(args);
    List out = new ArrayList();
    for (Object o : unnull(vm_busListeners_live())) addIfNotNull(out, pcallF(o, msg, arg));
    for (Object o : unnull(vm_busListenersByMessage_live().get(msg))) addIfNotNull(out, pcallF(o, msg, arg));
    return out;
  }

  static public List<File> listFilesWithSuffix(File dir, String suffix) {
    List<File> l = new ArrayList();
    for (File f : listFiles(dir)) if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
    return l;
  }

  static public <A, B> List<A> keysList(Map<A, B> map) {
    return cloneListSynchronizingOn(keys(map), map);
  }

  static public <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }

  static public Comparator<String> caseInsensitiveComparator() {
    return betterCIComparator();
  }

  static public int charDiff(char a, char b) {
    return (int) a - (int) b;
  }

  static public int charDiff(String a, char b) {
    return charDiff(stringToChar(a), b);
  }

  static public Object[] toArray(Collection c) {
    return toObjectArray(c);
  }

  static public <A> A[] toArray(Iterable<A> c, Class<A> type) {
    A[] a = arrayOfType(l(c), type);
    if (a.length == 0)
      return a;
    asList(c).toArray(a);
    return a;
  }

  static public <A> A[] toArray(A[] array, Collection c) {
    if (array == null || c == null)
      return null;
    asList(c).toArray(array);
    return array;
  }

  static public boolean reflection_isForbiddenMethod(Method m) {
    return m.getDeclaringClass() == Object.class && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet() {
    return new TreeSet(caseInsensitiveComparator());
  }

  static public TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
    return toCaseInsensitiveSet_treeSet(c);
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
    return cloneList(subList(l, startIndex, endIndex));
  }

  static public <A> List<A> newSubList(List<A> l, int startIndex) {
    return cloneList(subList(l, startIndex));
  }

  static public boolean checkTokCondition(Object condition, List<String> tok, int i) {
    if (condition instanceof TokCondition)
      return ((TokCondition) condition).get(tok, i);
    return checkCondition(condition, tok, i);
  }

  static public <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
    if (dest == src)
      return;
    dest.clear();
    dest.addAll(src);
  }

  static public void replaceListPart(List l, int i, int j, List l2) {
    replaceSublist(l, i, j, l2);
  }

  static public boolean endsWithIgnoreCase(String a, String b) {
    int la = l(a), lb = l(b);
    return la >= lb && regionMatchesIC(a, la - lb, b, 0, lb);
  }

  static public boolean endsWithIgnoreCase(String a, String b, Matches m) {
    if (!endsWithIgnoreCase(a, b))
      return false;
    m.m = new String[] { substring(a, 0, l(a) - l(b)) };
    return true;
  }

  static public void assertNotOnAWTThread() {
    assertFalse("Can't do this in AWT thread", isAWTThread());
  }

  static public Object[] asObjectArray(Collection l) {
    return toObjectArray(l);
  }

  static public String ok2(String s) {
    return "ok " + s;
  }

  static public boolean makeAndroid3_disable = false;

  static public class Android3 implements AutoCloseable {

    public String greeting;

    public boolean publicOverride = false;

    public int startPort = 5000;

    public Responder responder;

    public boolean console = true;

    public boolean quiet = false;

    public boolean daemon = false;

    public boolean incomingSilent = false;

    public int incomingPrintLimit = 200;

    public boolean useMultiPort = true;

    public boolean recordHistory = false;

    public boolean verbose = false;

    public int answerPrintLimit = 500;

    public boolean newLineAboveAnswer, newLineBelowAnswer;

    public int port;

    public long vport;

    public DialogHandler handler;

    public ServerSocket server;

    public Android3(String greeting) {
      this.greeting = greeting;
    }

    public Android3() {
    }

    public void close() {
      dispose();
    }

    synchronized public void dispose() {
      if (server != null) {
        try {
          server.close();
        } catch (IOException e) {
          print("[internal] " + e);
        }
        server = null;
      }
      if (vport != 0) {
        try {
          print("Disposing " + this);
          removeFromMultiPort(vport);
          vport = 0;
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    }

    public String toString() {
      return "Bot: " + greeting + " [vport " + vport + "]";
    }
  }

  static abstract public class Responder {

    abstract public String answer(String s, List<String> history);
  }

  static public Android3 makeAndroid3(final String greeting) {
    return makeAndroid3(new Android3(greeting));
  }

  static public Android3 makeAndroid3(final String greeting, Responder responder) {
    Android3 android = new Android3(greeting);
    android.responder = responder;
    return makeAndroid3(android);
  }

  static public Android3 makeAndroid3(final Android3 a) {
    if (makeAndroid3_disable)
      return a;
    if (a.responder == null)
      a.responder = new Responder() {

        public String answer(String s, List<String> history) {
          return callStaticAnswerMethod(s, history);
        }
      };
    if (!a.quiet)
      print("[bot] " + a.greeting);
    if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
      a.console = false;
    record(a);
    if (a.useMultiPort)
      a.vport = addToMultiPort(a.greeting, makeAndroid3_verboseResponder(a));
    if (a.console)
      makeAndroid3_handleConsole(a);
    if (a.useMultiPort)
      return a;
    a.handler = makeAndroid3_makeDialogHandler(a);
    if (a.quiet)
      startDialogServer_quiet.set(true);
    try {
      a.port = a.daemon ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler) : startDialogServerOnPortAbove(a.startPort, a.handler);
    } finally {
      startDialogServer_quiet.set(null);
    }
    a.server = startDialogServer_serverSocket;
    return a;
  }

  static public void makeAndroid3_handleConsole(final Android3 a) {
    if (!a.quiet)
      print("You may also type on this console.");
    {
      startThread(new Runnable() {

        public void run() {
          try {
            List<String> history = new ArrayList();
            while (licensed()) {
              String line;
              try {
                line = readLine();
              } catch (Throwable e) {
                print(getInnerMessage(e));
                break;
              }
              if (line == null)
                break;
              {
                history.add(line);
                history.add(makeAndroid3_getAnswer(line, history, a));
              }
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri...";
        }
      });
    }
  }

  static public DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
    return new DialogHandler() {

      public void run(final DialogIO io) {
        if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
          io.sendLine("Sorry, not allowed");
          return;
        }
        String dialogID = randomID(8);
        io.sendLine(a.greeting + " / Your ID: " + dialogID);
        List<String> history = new ArrayList();
        while (io.isStillConnected()) {
          if (io.waitForLine()) {
            final String line = io.readLineNoBlock();
            String s = dialogID + " at " + now() + ": " + quote(line);
            if (!a.incomingSilent)
              print(shorten(s, a.incomingPrintLimit));
            if (eq(line, "bye")) {
              io.sendLine("bye stranger");
              return;
            }
            Matches m = new Matches();
            if (a.recordHistory)
              history.add(line);
            String answer;
            if (match3("this is a continuation of talk *", s, m) || match3("hello bot! this is a continuation of talk *", s, m)) {
              dialogID = unquote(m.m[0]);
              answer = "ok";
            } else
              try {
                makeAndroid3_io.set(io);
                answer = makeAndroid3_getAnswer(line, history, a);
              } finally {
                makeAndroid3_io.set(null);
              }
            if (a.recordHistory)
              history.add(answer);
            io.sendLine(answer);
          }
        }
      }
    };
  }

  static public String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
    String answer, originalAnswer;
    try {
      originalAnswer = a.responder.answer(line, history);
      answer = makeAndroid3_fallback(line, history, originalAnswer);
    } catch (Throwable e) {
      e = getInnerException(e);
      printStackTrace(e);
      originalAnswer = answer = e.toString();
    }
    if (!a.incomingSilent) {
      if (originalAnswer == null)
        originalAnswer = "?";
      if (a.newLineAboveAnswer)
        print();
      print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
      if (a.newLineBelowAnswer)
        print();
    }
    return answer;
  }

  static public String makeAndroid3_fallback(String s, List<String> history, String answer) {
    if (answer == null && match3("what is your pid", s))
      return getPID();
    if (answer == null && match3("what is your program id", s))
      return getProgramID();
    if (match3("get injection id", s))
      return getInjectionID();
    if (answer == null)
      answer = "?";
    if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
      answer = quote(answer);
    return answer;
  }

  static public boolean makeAndroid3_consoleInUse() {
    if (isTrue(vm_generalMap_get("consoleInUse")))
      return true;
    for (Object o : record_list) if (o instanceof Android3 && ((Android3) o).console)
      return true;
    return false;
  }

  static public Responder makeAndroid3_verboseResponder(final Android3 a) {
    return new Responder() {

      public String answer(String s, List<String> history) {
        if (a.verbose)
          print("> " + shorten(s, a.incomingPrintLimit));
        String answer = a.responder.answer(s, history);
        if (a.verbose)
          print("< " + shorten(answer, a.incomingPrintLimit));
        return answer;
      }
    };
  }

  static public ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

  static public Android3 makeAndroid3() {
    return makeAndroid3(getProgramTitle() + ".");
  }

  static public String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
    String answer = (String) callOpt(bot, "answer", s, history);
    if (answer == null)
      answer = (String) callOpt(bot, "answer", s);
    return answer;
  }

  static public Responder makeResponder(final Object bot) {
    if (bot instanceof Responder)
      return (Responder) bot;
    if (bot instanceof String) {
      String f = (String) bot;
      return new Responder() {

        public String answer(String s, List<String> history) {
          String answer = (String) callOptMC((String) bot, s, history);
          if (answer == null)
            answer = (String) callOptMC((String) bot, s);
          return answer;
        }
      };
    }
    return new Responder() {

      public String answer(String s, List<String> history) {
        return makeResponder_callAnswerMethod(bot, s, history);
      }
    };
  }

  static public String defaultBotName() {
    return getProgramTitle() + ".";
  }

  static public List concatMap(Object f, Iterable l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Iterable l, Object f) {
    return concatMap(f, l);
  }

  static public List concatMap(Object f, Object[] l) {
    return concatLists(map(f, l));
  }

  static public List concatMap(Object[] l, Object f) {
    return concatMap(f, l);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
    return concatMap(l, (Object) f);
  }

  static public <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
    return concatMap(l, f);
  }

  static public Object rcurry(final Object f, final Object arg) {
    int n = numberOfFunctionArguments(f);
    if (n == 0)
      throw fail("function takes no arguments");
    if (n == 1)
      return new F0() {

        public Object get() {
          return callF(f, arg);
        }
      };
    if (n == 2)
      return new F1() {

        public Object get(Object a) {
          return callF(f, a, arg);
        }
      };
    throw todo("currying a function with " + n + "arguments");
  }

  static public TreeSet<String> litciset(String... items) {
    TreeSet<String> set = caseInsensitiveSet();
    for (String a : items) set.add(a);
    return set;
  }

  static public String afterLastSpace(String s) {
    return s == null ? null : substring(s, s.lastIndexOf(' ') + 1);
  }

  static public String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public boolean ewicOneOf(String s, String... l) {
    if (s != null)
      for (String x : l) if (ewic(s, x))
        return true;
    return false;
  }

  static public String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  static public Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  static public List<String> nlTok(String s) {
    return javaTokPlusPeriod(s);
  }

  static public Random defaultRandomGenerator() {
    return ThreadLocalRandom.current();
  }

  static public String readerToString(Reader r) {
    try {
      try {
        StringBuilder buf = new StringBuilder();
        int n = 0;
        while (true) {
          int ch = r.read();
          if (ch < 0)
            break;
          buf.append((char) ch);
          ++n;
        }
        return buf.toString();
      } finally {
        r.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(InputStream in) {
    try {
      return bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedReader utf8bufferedReader(File f) {
    try {
      return utf8bufferedReader(newFileInputStream(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> A[] newObjectArrayOfSameType(A[] a, int n) {
    return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
  }

  static public String emptyToNull(String s) {
    return eq(s, "") ? null : s;
  }

  static public <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
    return empty(map) ? null : map;
  }

  static public File parentFile(File f) {
    return dirOfFile(f);
  }

  static public String fileNameEncode_safeChars = " ()[]#,!";

  static public String fileNameEncode(String s) {
    StringBuilder buf = new StringBuilder();
    int n = l(s);
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (contains(fileNameEncode_safeChars, c))
        buf.append(c);
      else
        buf.append(urlencode(str(c)));
    }
    return str(buf);
  }

  static public File localMechListsDir() {
    return javaxDataDir("Mech Lists");
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName) {
    return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
  }

  static public String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
    return takeFirst(80 - 33, fileNameEncode(fullName)) + " - " + md5;
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y) {
    return indexOfSubList(x, y, 0);
  }

  static public <A> int indexOfSubList(List<A> x, List<A> y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y.get(j)))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A> int indexOfSubList(List<A> x, A[] y, int i) {
    outer: for (; i + l(y) <= l(x); i++) {
      for (int j = 0; j < l(y); j++) if (neq(x.get(i + j), y[j]))
        continue outer;
      return i;
    }
    return -1;
  }

  static public <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
    if (a == null || b == null)
      return;
    for (int i = 0; i < n; i++) b.set(i2 + i, a.get(i1 + i));
  }

  static public List<String> splitAt(String s, String splitter) {
    if (empty(splitter))
      return null;
    List<String> parts = new ArrayList();
    int i = 0;
    if (s != null)
      while (i < l(s)) {
        int j = indexOf(s, splitter, i);
        if (j < 0)
          j = l(s);
        parts.add(substring(s, i, j));
        i = j + l(splitter);
      }
    return parts;
  }

  static public boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  static public boolean hasLettersAllUpperCase(String s) {
    return hasLetters(s) && !containsLowerCase(s);
  }

  static public String tok_unCurlyBracket(String s) {
    return isCurlyBraced(s) ? join(dropFirstThreeAndLastThree(javaTok(s))) : s;
  }

  static public boolean isCurlyBraced(String s) {
    List<String> tok = tok_combineCurlyBrackets_keep(javaTok(s));
    return l(tok) == 3 && startsWithAndEndsWith(tok.get(1), "{", "}");
  }

  static public String strUnnull(Object o) {
    return o == null ? "" : str(o);
  }

  static public String jlabel_textAsHTML_center_ifNeeded(String text) {
    if (swic(text, "<html>") && ewic(text, "</html>"))
      return text;
    if (!containsNewLines(text))
      return text;
    return jlabel_textAsHTML_center(text);
  }

  static public Rect rect(int x, int y, int w, int h) {
    return new Rect(x, y, w, h);
  }

  static public boolean jInternalFrame_iconifiable = true;

  static public JInternalFrame jInternalFrame() {
    return jInternalFrame("");
  }

  static public JInternalFrame jInternalFrame(final String title) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame_iconifiable);
          f.setVisible(true);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JInternalFrame f = new JInternalFrame(title, true, true, true, jInternalFrame...";
      }
    });
  }

  static public void setInternalFrameContents(final Component c, final Object contents) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            JInternalFrame frame = getInternalFrame(c);
            if (frame == null)
              return;
            frame.getContentPane().removeAll();
            frame.getContentPane().setLayout(new BorderLayout());
            if (contents != null)
              frame.getContentPane().add(wrap(contents));
            revalidate(frame);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "JInternalFrame frame = getInternalFrame(c);\r\n    if (frame == null) return;\r\n...";
        }
      });
    }
  }

  static public <A extends Component> A setBounds(final int x, final int y, final int w, final int h, final A a) {
    if (a != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(x, y, w, h);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(x, y, w, h);";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(A a, Rect r) {
    if (a != null && r != null) {
      swing(new Runnable() {

        public void run() {
          try {
            a.setBounds(toRectangle(r));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "a.setBounds(toRectangle(r));";
        }
      });
    }
    return a;
  }

  static public <A extends Component> A setBounds(Rect r, A a) {
    return setBounds(a, r);
  }

  static public <A extends Component> A setBounds(A a, int x, int y, int w, int h) {
    return setBounds(x, y, w, h, a);
  }

  static public void internalFrameDefaultPosition(JInternalFrame f) {
    f.setSize(500, 300);
    centerInternalFrame(f);
  }

  static public int fixInternalFrame_borderTopLeft = 0;

  static public int fixInternalFrame_borderBottomRight = 40;

  static public JInternalFrame fixInternalFrame(final JInternalFrame f) {
    return swing(new F0<JInternalFrame>() {

      public JInternalFrame get() {
        try {
          Container c = f.getParent();
          if (c == null)
            return f;
          Rect r = toRect(f.getBounds());
          int a = fixInternalFrame_borderTopLeft, b = fixInternalFrame_borderBottomRight;
          Rect outer = new Rect(a, a, c.getWidth() - b, c.getHeight() - b);
          if (!rectContains(outer, r))
            f.setLocation(max(a, min(r.x, outer.x2())), max(a, min(r.y, outer.y2())));
          if (r.w > c.getWidth() || r.h > c.getHeight())
            f.setSize(c.getWidth() - a, c.getHeight() - a);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Container c = f.getParent();\r\n    if (c == null) ret f;\r\n    Rect r = toRect(...";
      }
    });
  }

  static public int getScreenWidth() {
    return getScreenSize().width;
  }

  static public int getScreenHeight() {
    return getScreenSize().height;
  }

  static public <A> List<A> childrenOfType(Component c, Class<A> theClass) {
    List<A> l = new ArrayList();
    scanForComponents(c, theClass, l);
    return l;
  }

  static public <A> List<A> childrenOfType(Class<A> theClass, Component c) {
    return childrenOfType(c, theClass);
  }

  static public boolean containsNulls(Collection c) {
    return contains(c, null);
  }

  static public File associatedInfosFile(File f) {
    return replaceExtension(f, ".infos");
  }

  static public String lines(Iterable lines) {
    return fromLines(lines);
  }

  static public String lines(Object[] lines) {
    return fromLines(asList(lines));
  }

  static public List<String> lines(String s) {
    return toLines(s);
  }

  static public String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
    for (String s : unnull(l)) if (swic(s, prefix))
      return substring(s, l(prefix));
    return null;
  }

  static public String firstStartingWithIC_drop(String prefix, Collection<String> l) {
    return firstStartingWithIC_drop(l, prefix);
  }

  static public File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  static public void standardTitlePopupMenu(final JFrame frame) {
    if (!isSubstanceLAF())
      return;
    titlePopupMenu(frame, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          boolean alwaysOnTop = frame.isAlwaysOnTop();
          menu.add(jmenuItem("Restart Program", "restart"));
          menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
          menu.add(jmenuItem("Show Console", "showConsole"));
          menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() {

            public void run() {
              try {
                toggleAlwaysOnTop(frame);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "toggleAlwaysOnTop(frame)";
            }
          }));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n    ifndef standardTitlePopupMenu_...";
      }
    });
  }

  static public Rectangle screenRectangle() {
    return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
  }

  static public Rectangle screenRectangle(GraphicsDevice device) {
    if (device == null)
      return null;
    DisplayMode mode = device.getDisplayMode();
    return new Rectangle(0, 0, mode.getWidth(), mode.getHeight());
  }

  static public Random random_random = new Random();

  static public int random(int n) {
    return random(random_random, n);
  }

  static public int random(int n, Random r) {
    return random(r, n);
  }

  static public int random(Random r, int n) {
    return n <= 0 ? 0 : r.nextInt(n);
  }

  static public double random(double max) {
    return random() * max;
  }

  static public double random() {
    return random_random.nextInt(100001) / 100000.0;
  }

  static public double random(double min, double max) {
    return min + random() * (max - min);
  }

  static public int random(int min, int max) {
    return min + random(max - min);
  }

  static public int random(int min, int max, Random r) {
    return random(r, min, max);
  }

  static public int random(Random r, int min, int max) {
    return min + random(r, max - min);
  }

  static public <A> A random(List<A> l) {
    return oneOf(l);
  }

  static public <A> A random(Collection<A> c) {
    if (c instanceof List)
      return random((List<A>) c);
    int i = random(l(c));
    return collectionGet(c, i);
  }

  static public int random(IntRange r) {
    return random(r.start, r.end);
  }

  static public JFrame consoleFrame() {
    return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
  }

  static public void autoVMExit() {
    call(getJavaX(), "autoVMExit");
  }

  static public String repeat(char c, int n) {
    n = Math.max(n, 0);
    char[] chars = new char[n];
    for (int i = 0; i < n; i++) chars[i] = c;
    return new String(chars);
  }

  static public <A> List<A> repeat(A a, int n) {
    n = Math.max(n, 0);
    List<A> l = new ArrayList(n);
    for (int i = 0; i < n; i++) l.add(a);
    return l;
  }

  static public <A> List<A> repeat(int n, A a) {
    return repeat(a, n);
  }

  static public String fileServerURL() {
    return "https://botcompany.de/files";
  }

  static public void copyStreamWithPrints(InputStream in, OutputStream out, String pat) {
    try {
      byte[] buf = new byte[65536];
      int total = 0;
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
        if ((total + n) / 100000 > total / 100000)
          print(pat.replace("{*}", str(roundDownTo(100000, total))));
        total += n;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void renameFile_assertTrue(File a, File b) {
    try {
      if (!a.exists())
        throw fail("Source file not found: " + f2s(a));
      if (b.exists())
        throw fail("Target file exists: " + f2s(b));
      mkdirsForFile(b);
      if (!a.renameTo(b))
        throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] loadBinaryFilePart(File file, long start, long end) {
    try {
      RandomAccessFile raf = new RandomAccessFile(file, "r");
      int n = toInt(min(raf.length(), end - start));
      byte[] buffer = new byte[n];
      try {
        raf.seek(start);
        raf.readFully(buffer, 0, n);
        return buffer;
      } finally {
        raf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean possibleMD5(String s) {
    return isMD5(s);
  }

  static public void duplicateThisProgram() {
    nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
  }

  static public void showConsole() {
    callOpt(get(javax(), "console"), "showConsole");
  }

  static public File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  static public File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  static public <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
    if (l == null)
      return new ArrayList();
    synchronized (mutex) {
      return new ArrayList<A>(l);
    }
  }

  static public betterCIComparator_C betterCIComparator_instance;

  static public betterCIComparator_C betterCIComparator() {
    if (betterCIComparator_instance == null)
      betterCIComparator_instance = new betterCIComparator_C();
    return betterCIComparator_instance;
  }

  final static public class betterCIComparator_C implements Comparator<String> {

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int n1 = s1.length();
      int n2 = s2.length();
      int min = Math.min(n1, n2);
      for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
          c1 = Character.toUpperCase(c1);
          c2 = Character.toUpperCase(c2);
          if (c1 != c2) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
            if (c1 != c2) {
              return c1 - c2;
            }
          }
        }
      }
      return n1 - n2;
    }
  }

  static public char stringToChar(String s) {
    if (l(s) != 1)
      throw fail("bad stringToChar: " + s);
    return firstChar(s);
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
    if (isCISet(c))
      return (TreeSet) c;
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, c);
    return set;
  }

  static public TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
    TreeSet<String> set = caseInsensitiveSet_treeSet();
    addAll(set, x);
    return set;
  }

  static public boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  static public <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
    return isTrue(callF(condition, arg));
  }

  static public void removeFromMultiPort(long vport) {
    if (vport == 0)
      return;
    for (Object port : getMultiPorts()) call(port, "removePort", vport);
  }

  static public List<Object> record_list = synchroList();

  static public void record(Object o) {
    record_list.add(o);
  }

  static public Object addToMultiPort_responder;

  static public long addToMultiPort(final String botName) {
    return addToMultiPort(botName, new Object() {

      public String answer(String s, List<String> history) {
        String answer = (String) (callOpt(getMainClass(), "answer", s, history));
        if (answer != null)
          return answer;
        answer = (String) callOpt(getMainClass(), "answer", s);
        if (answer != null)
          return answer;
        if (match3("get injection id", s))
          return getInjectionID();
        return null;
      }
    });
  }

  static public long addToMultiPort(final String botName, final Object responder) {
    addToMultiPort_responder = responder;
    startMultiPort();
    List ports = getMultiPorts();
    if (ports == null)
      return 0;
    if (ports.isEmpty())
      throw fail("No multiports!");
    if (ports.size() > 1)
      print("Multiple multi-ports. Using last one.");
    Object port = last(ports);
    Object responder2 = new Object() {

      public String answer(String s, List<String> history) {
        if (match3("get injection id", s))
          return getInjectionID();
        if (match3("your name", s))
          return botName;
        return (String) call(responder, "answer", s, history);
      }
    };
    record(responder2);
    return (Long) call(port, "addResponder", botName, responder2);
  }

  static public AtomicInteger dialogServer_clients = new AtomicInteger();

  static public boolean dialogServer_printConnects = false;

  static public ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

  static public Set<String> dialogServer_knownClients = synchroTreeSet();

  static public int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler)) ++port;
    return port;
  }

  static public int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true)) ++port;
    return port;
  }

  static public void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }

  static public ServerSocket startDialogServer_serverSocket;

  static public boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;
    Thread thread = new Thread("Socket accept port " + port) {

      public void run() {
        try {
          while (true) {
            try {
              final Socket s = _serverSocket.accept();
              String client = s.getInetAddress().toString();
              if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
                print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
                dialogServer_knownClients.add(client);
              }
              String threadName = "Handling client " + s.getInetAddress();
              Thread t2 = new Thread(threadName) {

                public void run() {
                  try {
                    final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                    final BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
                    DialogIO io = new DialogIO() {

                      public boolean isLocalConnection() {
                        return s.getInetAddress().isLoopbackAddress();
                      }

                      public boolean isStillConnected() {
                        return !(eos || s.isClosed());
                      }

                      public void sendLine(String line) {
                        try {
                          w.write(line + "\n");
                          w.flush();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String readLineImpl() {
                        try {
                          return in.readLine();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public void close() {
                        try {
                          s.close();
                        } catch (IOException e) {
                        }
                      }

                      public Socket getSocket() {
                        return s;
                      }
                    };
                    try {
                      handler.run(io);
                    } finally {
                      if (!io.noClose)
                        s.close();
                    }
                  } catch (IOException e) {
                    print("[internal] " + e);
                  } finally {
                  }
                }
              };
              t2.setDaemon(true);
              t2.start();
            } catch (SocketTimeoutException e) {
            }
          }
        } catch (IOException e) {
          print("[internal] " + e);
        }
      }
    };
    if (daemon)
      thread.setDaemon(true);
    thread.start();
    if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
      print("Dialog server on port " + port + " started.");
    return true;
  }

  static volatile public boolean readLine_noReadLine = false;

  static public String readLine_lastInput;

  static public String readLine_prefix = "[] ";

  static public String readLine() {
    if (readLine_noReadLine)
      return null;
    String s = readLineHidden();
    if (s != null) {
      readLine_lastInput = s;
      print(readLine_prefix + s);
    }
    return s;
  }

  static public String getInnerMessage(Throwable e) {
    if (e == null)
      return null;
    return getInnerException(e).getMessage();
  }

  static public boolean publicCommOn() {
    return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
  }

  static public int randomID_defaultLength = 12;

  static public String randomID(int length) {
    return makeRandomID(length);
  }

  static public String randomID(Random r, int length) {
    return makeRandomID(r, length);
  }

  static public String randomID() {
    return randomID(randomID_defaultLength);
  }

  static public String randomID(Random r) {
    return randomID(r, randomID_defaultLength);
  }

  static public String[] dropFirst(int n, String[] a) {
    return drop(n, a);
  }

  static public String[] dropFirst(String[] a) {
    return drop(1, a);
  }

  static public Object[] dropFirst(Object[] a) {
    return drop(1, a);
  }

  static public <A> List<A> dropFirst(List<A> l) {
    return dropFirst(1, l);
  }

  static public <A> List<A> dropFirst(int n, Iterable<A> i) {
    return dropFirst(n, toList(i));
  }

  static public <A> List<A> dropFirst(Iterable<A> i) {
    return dropFirst(toList(i));
  }

  static public <A> List<A> dropFirst(int n, List<A> l) {
    return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
  }

  static public <A> List<A> dropFirst(List<A> l, int n) {
    return dropFirst(n, l);
  }

  static public String dropFirst(int n, String s) {
    return substring(s, n);
  }

  static public String dropFirst(String s, int n) {
    return substring(s, n);
  }

  static public String dropFirst(String s) {
    return substring(s, 1);
  }

  static public String indentx(String s) {
    return indentx(indent_default, s);
  }

  static public String indentx(int n, String s) {
    return dropSuffix(repeat(' ', n), indent(n, s));
  }

  static public String indentx(String indent, String s) {
    return dropSuffix(indent, indent(indent, s));
  }

  static public String processID_cached;

  static public String getPID() {
    if (processID_cached == null) {
      String name = ManagementFactory.getRuntimeMXBean().getName();
      processID_cached = name.replaceAll("@.*", "");
    }
    return processID_cached;
  }

  static public String getInjectionID() {
    return (String) call(getJavaX(), "getInjectionID", getMainClass());
  }

  static public Object callOptMC(String method, Object... args) {
    return callOpt(mc(), method, args);
  }

  static public int numberOfFunctionArguments(Object f) {
    if (f instanceof F0)
      return 0;
    if (f instanceof F1)
      return 1;
    if (f instanceof F2)
      return 2;
    if (f instanceof VF1)
      return 1;
    if (f instanceof VF2)
      return 2;
    if (f instanceof String)
      return numberOfMethodArguments(mc(), (String) f);
    return numberOfMethodArguments(f, "get");
  }

  static public RuntimeException todo() {
    throw new RuntimeException("TODO");
  }

  static public RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }

  static public <A> TreeSet<A> treeSet() {
    return new TreeSet();
  }

  static public Class<?> hotwire(String src) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  static public <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  static public void callMain() {
    callMain(mc());
  }

  static public BufferedReader bufferedReader(Reader r) {
    return bufferedReader(r, 8192);
  }

  static public BufferedReader bufferedReader(Reader r, int bufSize) {
    return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
  }

  static public FileInputStream newFileInputStream(File path) throws IOException {
    return newFileInputStream(path.getPath());
  }

  static public FileInputStream newFileInputStream(String path) throws IOException {
    FileInputStream f = new FileInputStream(path);
    _registerIO(f, path, true);
    return f;
  }

  static public File dirOfFile(File f) {
    return f == null ? null : f.getParentFile();
  }

  static public boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  static public boolean hasLetters(String s) {
    for (int i = 0; i < s.length(); i++) if (Character.isLetter(s.charAt(i)))
      return true;
    return false;
  }

  static public boolean containsLowerCase(String s) {
    for (int i = 0; i < l(s); i++) if (isLowerCase(s.charAt(i)))
      return true;
    return false;
  }

  static public <A> List<A> dropFirstThreeAndLastThree(List<A> l) {
    return dropFirstAndLast(3, l);
  }

  static public List<String> tok_combineCurlyBrackets_keep(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && eq(t, "{")) {
        int j = findEndOfCurlyBracketPart(tok, i);
        l.add(joinSubList(tok, i, j));
        i = j - 1;
      } else
        l.add(t);
    }
    return l;
  }

  static public boolean startsWithAndEndsWith(String s, String prefix, String suffix) {
    return startsWith(s, prefix) && endsWith(s, suffix);
  }

  static public boolean containsNewLines(String s) {
    return containsNewLine(s);
  }

  static public String jlabel_textAsHTML_center(String text) {
    return "<html><div style=\"text-align: center;\">" + replace(htmlencode(text), "\n", "<br>") + "</div></html>";
  }

  static public boolean rectContains(int x1, int y1, int w, int h, Pt p) {
    return p.x >= x1 && p.y >= y1 && p.x < x1 + w && p.y < y1 + h;
  }

  static public boolean rectContains(Rect a, Rect b) {
    return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
  }

  static public boolean rectContains(Rect a, int x, int y) {
    return a != null && a.contains(x, y);
  }

  static public <A> void scanForComponents(final Component c, final Class<A> theClass, final List<A> l) {
    if (theClass.isInstance(c))
      l.add((A) c);
    if (c instanceof Container) {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component comp : ((Container) c).getComponents()) scanForComponents(comp, theClass, l);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component comp : ((Container) c).getComponents())\r\n      scanForComponen...";
        }
      });
    }
  }

  static public File replaceExtension(File f, String extOld, String extNew) {
    return newFile(replaceExtension(f2s(f), extOld, extNew));
  }

  static public File replaceExtension(File f, String extNew) {
    return replaceExtension(f, fileExtension(f), extNew);
  }

  static public String replaceExtension(String s, String extOld, String extNew) {
    s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
    return s + addPrefixOptIfNempty(".", extNew);
  }

  static public String replaceExtension(String name, String extNew) {
    return replaceExtension(name, fileExtension(name), extNew);
  }

  static public String fromLines(Iterable lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null)
      for (Object line : lines) buf.append(str(line)).append('\n');
    return buf.toString();
  }

  static public String fromLines(String... lines) {
    return fromLines(asList(lines));
  }

  static public IterableIterator<String> toLines(File f) {
    return linesFromFile(f);
  }

  static public List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  static public int toLines_nextLineBreak(String s, int start) {
    int n = s.length();
    for (int i = start; i < n; i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  static public boolean isSubstanceLAF() {
    return substanceLookAndFeelEnabled();
  }

  static public boolean titlePopupMenu(final Component c, final Object menuMaker) {
    JComponent titleBar = getTitlePaneComponent(getPossiblyInternalFrame(c));
    if (titleBar == null) {
      print("Can't add title right click!");
      return false;
    } else {
      componentPopupMenu(titleBar, menuMaker);
      return true;
    }
  }

  static public void toggleAlwaysOnTop(JFrame frame) {
    frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
  }

  static public <A> A oneOf(List<A> l) {
    return empty(l) ? null : l.get(new Random().nextInt(l.size()));
  }

  static public char oneOf(String s) {
    return empty(s) ? '?' : s.charAt(random(l(s)));
  }

  static public String oneOf(String... l) {
    return oneOf(asList(l));
  }

  static public <A> A collectionGet(Collection<A> c, int idx) {
    if (c == null || idx < 0 || idx >= l(c))
      return null;
    if (c instanceof List)
      return listGet((List<A>) c, idx);
    Iterator<A> it = c.iterator();
    for (int i = 0; i < idx; i++) if (it.hasNext())
      it.next();
    else
      return null;
    return it.hasNext() ? it.next() : null;
  }

  static public int roundDownTo(int n, int x) {
    return x / n * n;
  }

  static public long roundDownTo(long n, long x) {
    return x / n * n;
  }

  static public boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  static public String smartJoin(String[] args) {
    if (empty(args))
      return "";
    if (args.length == 1)
      return args[0];
    String[] a = new String[args.length];
    for (int i = 0; i < a.length; i++) a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
    return join(" ", a);
  }

  static public String smartJoin(List<String> args) {
    return smartJoin(toStringArray(args));
  }

  static public char firstChar(String s) {
    return s.charAt(0);
  }

  static public boolean isCISet(Iterable<String> l) {
    return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
  }

  static public List<Object> getMultiPorts() {
    return (List) callOpt(getJavaX(), "getMultiPorts");
  }

  static public void startMultiPort() {
    List mp = getMultiPorts();
    if (mp != null && mp.isEmpty()) {
      nohupJavax("#1001639");
      throw fail("Upgrading JavaX, please restart this program afterwards.");
    }
  }

  static public <A> Set<A> synchroTreeSet() {
    return Collections.synchronizedSet(new TreeSet<A>());
  }

  static public <A> Set<A> synchroTreeSet(TreeSet<A> set) {
    return Collections.synchronizedSet(set);
  }

  static public boolean forbiddenPort(int port) {
    return port == 5037;
  }

  static public String readLineHidden() {
    try {
      if (get(javax(), "readLine_reader") == null)
        set(javax(), "readLine_reader", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
      try {
        return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
      } finally {
        consoleClearInput();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public String[] drop(int n, String[] a) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public Object[] drop(int n, Object[] a) {
    n = Math.min(n, a.length);
    Object[] b = new Object[a.length - n];
    System.arraycopy(a, n, b, 0, b.length);
    return b;
  }

  static public <A> ArrayList<A> toList(A[] a) {
    return asList(a);
  }

  static public ArrayList<Integer> toList(int[] a) {
    return asList(a);
  }

  static public <A> ArrayList<A> toList(Set<A> s) {
    return asList(s);
  }

  static public <A> ArrayList<A> toList(Iterable<A> s) {
    return asList(s);
  }

  static public int indent_default = 2;

  static public String indent(int indent) {
    return repeat(' ', indent);
  }

  static public String indent(int indent, String s) {
    return indent(repeat(' ', indent), s);
  }

  static public String indent(String indent, String s) {
    return indent + s.replace("\n", "\n" + indent);
  }

  static public String indent(String s) {
    return indent(indent_default, s);
  }

  static public List<String> indent(String indent, List<String> lines) {
    List<String> l = new ArrayList();
    if (lines != null)
      for (String s : lines) l.add(indent + s);
    return l;
  }

  static public int numberOfMethodArguments(Object o, String method) {
    Class c;
    boolean mustBeStatic = false;
    if (o instanceof Class) {
      c = (Class) o;
      mustBeStatic = true;
    } else
      c = o.getClass();
    Class _c = c;
    int n = -1;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if (mustBeStatic && !methodIsStatic(m))
          continue;
        int nn = l(m.getParameterTypes());
        if (n == -1)
          n = nn;
        else if (n != nn)
          throw fail("Variable number of method arguments: " + _c + "." + method);
      }
      c = c.getSuperclass();
    }
    if (n == -1)
      throw fail("Method not found: " + _c + "." + method);
    return n;
  }

  static public boolean _inCore() {
    return false;
  }

  static public List hotwire_copyOver_after = synchroList();

  static public void hotwire_copyOver(Class c) {
    for (String field : ll("print_log", "print_silent", "androidContext", "_userHome")) setOptIfNotNull(c, field, getOpt(mc(), field));
    setOptIfNotNull(c, "mainBot", getMainBot());
    setOpt(c, "creator_class", new WeakReference(mc()));
    pcallFAll(hotwire_copyOver_after, c);
  }

  static public boolean isLowerCase(char c) {
    return Character.isLowerCase(c);
  }

  static public <A> List<A> dropFirstAndLast(int n, List<A> l) {
    return cloneSubList(l, n, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(int m, int n, List<A> l) {
    return cloneSubList(l, m, l(l) - n);
  }

  static public <A> List<A> dropFirstAndLast(List<A> l) {
    return dropFirstAndLast(1, l);
  }

  static public String dropFirstAndLast(String s) {
    return substring(s, 1, l(s) - 1);
  }

  static public int findEndOfCurlyBracketPart(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (eq(cnc.get(j), "{"))
        ++level;
      else if (eq(cnc.get(j), "}"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  static public boolean containsNewLine(String s) {
    return contains(s, '\n');
  }

  static public String htmlencode(Object o) {
    return htmlencode(str(o));
  }

  static public String htmlencode(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String fileExtension(File f) {
    if (f == null)
      return null;
    return fileExtension(f.getName());
  }

  static public String fileExtension(String s) {
    return substring(s, smartLastIndexOf(s, '.'));
  }

  static public String dropSuffixIC(String suffix, String s) {
    return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  static public String addPrefixOptIfNempty(String prefix, String s) {
    return addPrefixIfNotEmpty2(prefix, s);
  }

  static public CloseableIterableIterator<String> linesFromFile(File f) {
    try {
      if (!f.exists())
        return emptyCloseableIterableIterator();
      if (ewic(f.getName(), ".gz"))
        return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
      return linesFromReader(utf8bufferedReader(f));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public CloseableIterableIterator<String> linesFromFile(String path) {
    return linesFromFile(newFile(path));
  }

  static public boolean substanceLookAndFeelEnabled() {
    return startsWith(getLookAndFeel(), "org.pushingpixels.");
  }

  static public JComponent getTitlePaneComponent(RootPaneContainer window) {
    if (window instanceof JInternalFrame)
      return getInternalFrameTitlePaneComponent((JInternalFrame) window);
    if (!substanceLookAndFeelEnabled() || window == null)
      return null;
    JRootPane rootPane = window.getRootPane();
    if (rootPane != null) {
      Object ui = rootPane.getUI();
      return (JComponent) call(ui, "getTitlePane");
    }
    return null;
  }

  static public RootPaneContainer getPossiblyInternalFrame(Component c) {
    JInternalFrame f = getInternalFrame(c);
    if (f != null)
      return f;
    return optCast(RootPaneContainer.class, getWindow(c));
  }

  static public <A> A listGet(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  static public boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      } else
        return false;
    }
    return true;
  }

  static public void consoleClearInput() {
    consoleSetInput("");
  }

  static public void setOptIfNotNull(Object o, String field, Object value) {
    if (value != null)
      setOpt(o, field, value);
  }

  static public Object mainBot;

  static public Object getMainBot() {
    return mainBot;
  }

  static public String intToHex_flexLength(int i) {
    return Integer.toHexString(i);
  }

  static public String addPrefixIfNotEmpty2(String prefix, String s) {
    return empty(s) ? "" : addPrefix(prefix, s);
  }

  static public CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {

    public Object next() {
      throw fail();
    }

    public boolean hasNext() {
      return false;
    }
  };

  static public <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
    return emptyCloseableIterableIterator_instance;
  }

  static public CloseableIterableIterator<String> linesFromReader(Reader r) {
    final BufferedReader br = bufferedReader(r);
    return iteratorFromFunction_f0_autoCloseable(new F0<String>() {

      public String get() {
        try {
          return readLineFromReaderWithClose(br);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret readLineFromReaderWithClose(br);";
      }
    }, _wrapIOCloseable(r));
  }

  static public String getLookAndFeel() {
    return getClassName(UIManager.getLookAndFeel());
  }

  static public <A> A optCast(Class<A> c, Object o) {
    return isInstance(c, o) ? (A) o : null;
  }

  static public void consoleSetInput(final String text) {
    if (headless())
      return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  }

  static public String addPrefix(String prefix, String s) {
    return s.startsWith(prefix) ? s : prefix + s;
  }

  static public <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
    class IFF2 extends CloseableIterableIterator<A> {

      public A a;

      public boolean done = false;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        return _a;
      }

      public void getNext() {
        if (done || a != null)
          return;
        a = f.get();
        done = a == null;
      }

      public void close() throws Exception {
        if (closeable != null)
          closeable.close();
      }
    }
    ;
    return new IFF2();
  }

  static public String readLineFromReaderWithClose(BufferedReader r) {
    try {
      String s = r.readLine();
      if (s == null)
        r.close();
      return s;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
    return c == null ? null : new AutoCloseable() {

      public String toString() {
        return "c.close();\r\n    _registerIO(c, null, false);";
      }

      public void close() throws Exception {
        c.close();
        _registerIO(c, null, false);
      }
    };
  }

  static public JTextField setTextAndSelectAll(final JTextField tf, final String text) {
    if (tf != null) {
      swing(new Runnable() {

        public void run() {
          try {
            tf.setText(text);
            tf.selectAll();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "tf.setText(text);\r\n    tf.selectAll();";
        }
      });
    }
    return tf;
  }

  static public JTextField consoleInputField() {
    Object console = get(getJavaX(), "console");
    return (JTextField) getOpt(console, "tfInput");
  }

  static public void focusConsole(String s) {
    setConsoleInput(s);
    focusConsole();
  }

  static public void focusConsole() {
    JComponent tf = consoleInputFieldOrComboBox();
    if (tf != null) {
      tf.requestFocus();
    }
  }

  static public void setConsoleInput(String text) {
    consoleSetInput(text);
  }

  static public JComponent consoleInputFieldOrComboBox() {
    Object console = get(getJavaX(), "console");
    JComboBox cb = (JComboBox) (getOpt(console, "cbInput"));
    if (cb != null)
      return cb;
    return (JTextField) getOpt(console, "tfInput");
  }

  static abstract public class VF2<A, B> {

    abstract public void get(A a, B b);
  }

  static public class JSection extends SingleComponentPanel {

    public JSection(Component c) {
      super(c);
    }

    public String getTitle() {
      Border border = getBorder();
      if (border instanceof TitledBorder)
        return ((TitledBorder) border).getTitle();
      return null;
    }
  }

  static public class Var<A> implements IVar<A> {

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public A v;

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public synchronized void clear() {
      v = null;
    }

    public String toString() {
      return str(get());
    }
  }

  static abstract public class TokCondition {

    abstract public boolean get(List<String> tok, int i);
  }

  static public class SecretValue<A> extends Var<A> {

    public SecretValue() {
    }

    public SecretValue(A a) {
      super(a);
    }

    public String toString() {
      return "Secret value";
    }
  }

  static public class ImageSurface extends Surface {

    public BufferedImage image;

    public double zoomX = 1, zoomY = 1, zoomFactor = 1.5;

    public Rectangle selection;

    public List tools = new ArrayList();

    public Object overlay;

    public Runnable onSelectionChange;

    static public boolean verbose = false;

    public boolean noMinimumSize = true;

    public String titleForUpload;

    public Object onZoom;

    public boolean specialPurposed = false;

    public boolean zoomable = true;

    public boolean noAlpha = false;

    public Object interpolationMode = RenderingHints.VALUE_INTERPOLATION_BILINEAR;

    public Object onNewImage;

    public BufferedImage imageToDraw;

    public File file;

    public ImageSurface() {
      this(dummyImage());
    }

    static public BufferedImage dummyImage() {
      return new RGBImage(1, 1, new int[] { 0xFFFFFF }).getBufferedImage();
    }

    public ImageSurface(MakesBufferedImage image) {
      this(image != null ? image.getBufferedImage() : dummyImage());
    }

    public ImageSurface(BufferedImage image) {
      setImage(image);
      clearSurface = false;
      componentPopupMenu2(this, ImageSurface_popupMenuMaker());
      new ImageSurfaceSelector(this);
      jHandleFileDrop(this, new VF1<File>() {

        public void get(File f) {
          try {
            setImage(loadBufferedImage(f));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "setImage(loadBufferedImage(f))";
        }
      });
    }

    public ImageSurface(RGBImage image, double zoom) {
      this(image);
      setZoom(zoom);
    }

    public void fillPopupMenu(JPopupMenu menu, final Point point) {
      if (zoomable) {
        JMenuItem miZoomReset = new JMenuItem("Zoom 100%");
        miZoomReset.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            setZoom(1.0);
            centerPoint(point);
          }
        });
        menu.add(miZoomReset);
        JMenuItem miZoomIn = new JMenuItem("Zoom in");
        miZoomIn.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomIn(zoomFactor);
            centerPoint(point);
          }
        });
        menu.add(miZoomIn);
        JMenuItem miZoomOut = new JMenuItem("Zoom out");
        miZoomOut.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomOut(zoomFactor);
            centerPoint(point);
          }
        });
        menu.add(miZoomOut);
        JMenuItem miZoomToWindow = new JMenuItem("Zoom to window");
        miZoomToWindow.addActionListener(new ActionListener() {

          public void actionPerformed(ActionEvent evt) {
            zoomToDisplaySize();
          }
        });
        menu.add(miZoomToWindow);
        addMenuItem(menu, "Show full screen", new Runnable() {

          public void run() {
            try {
              showFullScreen();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "showFullScreen()";
          }
        });
        addMenuItem(menu, "Point: " + point.x + "," + point.y + " (image: " + image.getWidth() + "*" + image.getHeight() + ")", null);
        menu.addSeparator();
      }
      addMenuItem(menu, "Load image...", new Runnable() {

        public void run() {
          try {
            selectFile("Load image", new VF1<File>() {

              public void get(File f) {
                try {
                  setImage(loadImage2(f));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "setImage(loadImage2(f))";
              }
            });
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "selectFile(\"Load image\",\r\n      new VF1<File>() { public void get(File f) cte...";
        }
      });
      addMenuItem(menu, "Save image...", new Runnable() {

        public void run() {
          try {
            saveImage();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "saveImage()";
        }
      });
      addMenuItem(menu, "Upload image...", new Runnable() {

        public void run() {
          try {
            uploadTheImage();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "uploadTheImage()";
        }
      });
      addMenuItem(menu, "Copy image to clipboard", new Runnable() {

        public void run() {
          try {
            copyImageToClipboard(getImage());
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "copyImageToClipboard(getImage())";
        }
      });
      if (!specialPurposed) {
        addMenuItem(menu, "Paste image from clipboard", new Runnable() {

          public void run() {
            try {
              loadFromClipboard();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "loadFromClipboard()";
          }
        });
        addMenuItem(menu, "Load image snippet...", new Runnable() {

          public void run() {
            try {
              selectImageSnippet(new VF1<String>() {

                public void get(String imageID) {
                  try {
                    setImage(loadImage2(imageID));
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "setImage(loadImage2(imageID))";
                }
              });
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "selectImageSnippet(new VF1<String>() { public void get(String imageID) ctex {...";
          }
        });
      }
      if (selection != null)
        addMenuItem(menu, "Crop", new Runnable() {

          public void run() {
            try {
              crop();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "crop()";
          }
        });
      if (!specialPurposed)
        addMenuItem(menu, "No image", new Runnable() {

          public void run() {
            try {
              noImage();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "noImage()";
          }
        });
    }

    public void noImage() {
      setImage((BufferedImage) null);
    }

    public void crop() {
      if (selection == null)
        return;
      BufferedImage img = cloneClipBufferedImage(getImage(), selection);
      selection = null;
      setImage(img);
    }

    public void loadFromClipboard() {
      BufferedImage img = getImageFromClipboard();
      if (img != null)
        setImage(img);
    }

    public void saveImage() {
      RGBImage image = new RGBImage(getImage(), null);
      JFileChooser fileChooser = new JFileChooser(getProgramDir());
      if (fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
        try {
          image.save(file = fileChooser.getSelectedFile());
        } catch (IOException e) {
          popup(e);
        }
      }
    }

    public void render(int w, int h, Graphics2D g) {
      if (verbose)
        _print("render");
      g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationMode);
      g.setColor(Color.white);
      BufferedImage image = or(imageToDraw, this.image);
      if (image == null)
        g.fillRect(0, 0, w, h);
      else {
        int iw = getZoomedWidth(), ih = getZoomedHeight();
        boolean alpha = !noAlpha && hasTransparency(image);
        if (alpha)
          g.fillRect(0, 0, w, h);
        if (eq(interpolationMode, "thumbnailator"))
          g.drawImage(Thumbnailator.createThumbnail(image, iw, ih), 0, 0, null);
        else if (interpolationMode == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || zoomX >= 1 || zoomY >= 1)
          g.drawImage(image, 0, 0, iw, ih, null);
        else
          g.drawImage(resizeImage(image, iw, ih), 0, 0, null);
        if (!alpha) {
          g.fillRect(iw, 0, w - iw, h);
          g.fillRect(0, ih, iw, h - ih);
        }
      }
      if (overlay != null) {
        if (verbose)
          _print("render overlay");
        pcallF(overlay, g);
      }
      if (selection != null) {
        if (verbose)
          _print("render selection");
        drawSelectionRect(g, selection, Color.green, Color.white);
      }
    }

    public void drawSelectionRect(Graphics2D g, Rectangle selection, Color green, Color white) {
      drawSelectionRect(g, selection, green, white, zoomX, zoomY);
    }

    public void drawSelectionRect(Graphics2D g, Rectangle selection, Color green, Color white, double zoomX, double zoomY) {
      g.setColor(green);
      int top = (int) (selection.y * zoomY);
      int bottom = (int) ((selection.y + selection.height) * zoomY);
      int left = (int) (selection.x * zoomX);
      int right = (int) ((selection.x + selection.width) * zoomX);
      g.drawRect(left - 1, top - 1, right - left + 1, bottom - top + 1);
      g.setColor(white);
      g.drawRect(left - 2, top - 2, right - left + 3, bottom - top + 3);
    }

    public ImageSurface setZoom(double zoom) {
      setZoom(zoom, zoom);
      return this;
    }

    public void setZoom(double zoomX, double zoomY) {
      if (this.zoomX == zoomX && this.zoomY == zoomY)
        return;
      if (verbose)
        _print("Setting zoom");
      this.zoomX = zoomX;
      this.zoomY = zoomY;
      revalidate();
      repaint();
      centerPoint(new Point(getImage().getWidth() / 2, getImage().getHeight() / 2));
      pcallF(onZoom);
    }

    public Dimension getMinimumSize() {
      if (noMinimumSize)
        return new Dimension(1, 1);
      int w = getZoomedWidth();
      int h = getZoomedHeight();
      Dimension min = super.getMinimumSize();
      return new Dimension(Math.max(w, min.width), Math.max(h, min.height));
    }

    final public int getZoomedHeight() {
      return (int) (image.getHeight() * zoomY);
    }

    final public int getZoomedWidth() {
      return (int) (image.getWidth() * zoomX);
    }

    public void setImage(MakesBufferedImage image) {
      setImage(image == null ? null : image.getBufferedImage());
    }

    public void setImage(final BufferedImage img) {
      {
        swing(new Runnable() {

          public void run() {
            try {
              BufferedImage newImage = img != null ? img : dummyImage();
              BufferedImage oldImage = image;
              image = newImage;
              if (!imagesHaveSameSize(oldImage, newImage)) {
                if (verbose)
                  _print("New image size");
                revalidate();
              }
              repaint();
              pcallF(onNewImage);
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "BufferedImage newImage = img != null ? img : dummyImage();\r\n      BufferedIma...";
          }
        });
      }
    }

    public void setImageAndZoomToDisplay(BufferedImage img) {
      setImage(img);
      zoomToDisplaySize();
    }

    public BufferedImage getImage() {
      return image;
    }

    public double getZoomX() {
      return zoomX;
    }

    public double getZoomY() {
      return zoomY;
    }

    public Dimension getPreferredSize() {
      return new Dimension(getZoomedWidth(), getZoomedHeight());
    }

    public JScrollPane makeScrollPane() {
      JScrollPane scrollPane = new JScrollPane(this);
      scrollPane.getViewport().setScrollMode(JViewport.BACKINGSTORE_SCROLL_MODE);
      return scrollPane;
    }

    public void zoomToWindow() {
      zoomToDisplaySize();
    }

    public void zoomToDisplaySize() {
      swing(new Runnable() {

        public void run() {
          try {
            if (image == null)
              return;
            Dimension display = getDisplaySize();
            double xRatio = (display.width - 5) / (double) image.getWidth();
            double yRatio = (display.height - 5) / (double) image.getHeight();
            setZoom(min(xRatio, yRatio));
            revalidate();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "if (image == null) return;\r\n    Dimension display = getDisplaySize();\r\n    do...";
        }
      });
    }

    final public Dimension getDisplaySize() {
      Container c = getParent();
      while (c != null) {
        if (c instanceof JScrollPane)
          return c.getSize();
        c = c.getParent();
      }
      return getSize();
    }

    public void setSelection(Rect r) {
      setSelection(toRectangle(r));
    }

    public void setSelection(Rectangle r) {
      if (neq(selection, r)) {
        selection = r;
        pcallF(onSelectionChange);
        repaint();
      }
    }

    public Rectangle getSelection() {
      return selection;
    }

    public RGBImage getRGBImage() {
      return new RGBImage(getImage());
    }

    public void centerPoint(Point p) {
      JScrollPane sp = enclosingScrollPane(this);
      if (sp == null)
        return;
      p = new Point((int) (p.x * getZoomX()), (int) (p.y * getZoomY()));
      final JViewport viewport = sp.getViewport();
      Dimension viewSize = viewport.getExtentSize();
      int x = max(0, p.x - viewSize.width / 2);
      int y = max(0, p.y - viewSize.height / 2);
      p = new Point(x, y);
      final Point _p = p;
      awtLater(new Runnable() {

        public void run() {
          try {
            viewport.setViewPosition(_p);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "viewport.setViewPosition(_p);";
        }
      });
    }

    public Pt pointFromEvent(MouseEvent e) {
      return pointFromComponentCoordinates(new Pt(e.getX(), e.getY()));
    }

    public Pt pointFromComponentCoordinates(Pt p) {
      return new Pt((int) (p.x / zoomX), (int) (p.y / zoomY));
    }

    public Pt pointToComponentCoordinates(double x, double y) {
      return new Pt((int) (x * zoomX), (int) (y * zoomY));
    }

    public void uploadTheImage() {
      call(hotwire("#1016427"), "go", getImage(), titleForUpload);
    }

    public void showFullScreen() {
      showFullScreenImageSurface(getImage());
    }

    public void zoomIn(double f) {
      setZoom(getZoomX() * f, getZoomY() * f);
    }

    public void zoomOut(double f) {
      setZoom(getZoomX() / f, getZoomY() / f);
    }

    public ImageSurface setFile(File f) {
      file = f;
      return this;
    }
  }

  static public VF2<ImageSurface, JPopupMenu> ImageSurface_popupMenuMaker() {
    return new VF2<ImageSurface, JPopupMenu>() {

      public void get(ImageSurface is, JPopupMenu menu) {
        try {
          Point p = is.pointFromEvent(componentPopupMenu_mouseEvent.get()).getPoint();
          is.fillPopupMenu(menu, p);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Point p = is.pointFromEvent(componentPopupMenu_mouseEvent.get()).getPoint();\r...";
      }
    };
  }

  static public class GlobalID implements Comparable<GlobalID> {

    public long a;

    public int b;

    public GlobalID() {
    }

    public GlobalID(String id) {
      assertGlobalID(id);
      BigInteger value = bigint(0);
      for (int i = 0; i < l(id); i++) value = plus(mul(value, 26), charDiff(id.charAt(i), 'a'));
      a = value.longValue();
      value = value.shiftRight(64);
      b = value.shortValue();
    }

    public String toString() {
      BigInteger value = bigint(b);
      value = value.shiftLeft(32);
      value = plus(value, (a >> 32) & 0xFFFFFFFFL);
      value = value.shiftLeft(32);
      value = plus(value, a & 0xFFFFFFFFL);
      return bigintToGlobalID(value);
    }

    public boolean equals(Object o) {
      if (!(o instanceof GlobalID))
        return false;
      return ((GlobalID) o).a == a && ((GlobalID) o).b == b;
    }

    public int hashCode() {
      return (int) a;
    }

    public int compareTo(GlobalID id) {
      int diff = b - id.b;
      return diff != 0 ? diff : Long.compareUnsigned(a, id.a);
    }
  }

  static public class HCRUD extends HAbstractRenderable {

    public HCRUD_Data data;

    public int defaultTextFieldCols = 80;

    public boolean mutationRights = true;

    public boolean allowCreateOrDelete = true;

    public boolean allowCreate = true;

    public boolean allowEdit = true;

    public boolean singleton = false;

    public boolean cmdsLeft = false;

    public String tableClass;

    public String formTableClass;

    public Set<String> unshownFields;

    public Set<String> uneditableFields;

    public Set<String> unlistedFields;

    public boolean showCheckBoxes = false;

    public boolean haveJQuery, haveSelectizeJS;

    public boolean needsJQuery = false;

    public boolean paginate = false;

    public boolean sortable = false;

    public Map<String, String> params;

    public HTMLPaginator paginator = new HTMLPaginator();

    public String sortByField;

    public String sortParameter = "sort";

    public boolean descending = false;

    public Object objectIDToHighlight;

    public HCRUD() {
    }

    public HCRUD(HCRUD_Data data) {
      this.data = data;
    }

    public HCRUD(String baseLink, HCRUD_Data data) {
      this.data = data;
      this.baseLink = baseLink;
    }

    public String newLink() {
      return appendQueryToURL(baseLink, "cmd", "new");
    }

    public String deleteLink(Object id) {
      return appendQueryToURL(baseLink, "delete_" + id, 1);
    }

    public String editLink(Object id) {
      return appendQueryToURL(baseLink, "edit", id);
    }

    public String duplicateLink(Object id) {
      return appendQueryToURL(baseLink, "duplicate", id);
    }

    public String render(boolean withCmds, Map<String, String> params) {
      this.params = params;
      if (!withCmds)
        return renderTable(false);
      {
        String __1 = handleCommands(params);
        if (!empty(__1))
          return __1;
      }
      return renderMsgs(params) + pUnlessEmpty(nav()) + renderTable(withCmds);
    }

    transient public IF0<String> nav;

    public String nav() {
      return nav != null ? nav.get() : nav_base();
    }

    final public String nav_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : nav_base();
    }

    public String nav_base() {
      List<String> l = new ArrayList();
      if (actuallyAllowCreate())
        l.add(ahref(newLink(), "New " + itemName()));
      return joinWithVBar(l);
    }

    public String handleCommands(Map<String, String> params) {
      List<String> msgs = new ArrayList();
      if (eqGet(params, "action", "create")) {
        if (!actuallyAllowCreate())
          throw fail("Creating objects not allowed");
        Object id = data.createObject(subMapStartingWith_dropPrefix(params, "f_"));
        msgs.add(itemName() + " created (ID: " + id + ")");
        objectIDToHighlight = id;
      }
      if (eqGet(params, "action", "update")) {
        if (!actuallyAllowEdit())
          throw fail("Editing objects not allowed");
        String id = params.get("id");
        msgs.add(data.updateObject(id, subMapStartingWith_dropPrefix(params, "f_")));
        objectIDToHighlight = id;
      }
      List<String> toDeleteList = keysDeprefixNemptyValue(params, "delete_");
      if (eq(params.get("bulkAction"), "deleteSelected"))
        toDeleteList.addAll(keysDeprefixNemptyValue(params, "obj_"));
      for (String toDelete : toDeleteList) {
        if (!actuallyAllowDelete())
          throw fail("Deleting objects not allowed");
        msgs.add(data.deleteObject(toDelete));
      }
      return nempty(msgs) ? refreshWithMsgs(msgs, "anchor", objectIDToHighlight != null ? "obj" + objectIDToHighlight : null) : "";
    }

    public String encodeField(String s) {
      return or(data.fieldNameToHTML(s), s);
    }

    transient public IF2<String, Object, String> renderValue;

    public String renderValue(String field, Object value) {
      return renderValue != null ? renderValue.get(field, value) : renderValue_base(field, value);
    }

    final public String renderValue_fallback(IF2<String, Object, String> _f, String field, Object value) {
      return _f != null ? _f.get(field, value) : renderValue_base(field, value);
    }

    public String renderValue_base(String field, Object value) {
      if (value instanceof HTML)
        return ((HTML) value).html;
      value = deref(value);
      if (value instanceof SecretValue)
        return hhiddenStuff(renderValue_inner(((SecretValue) value).get()));
      return renderValue_inner(value);
    }

    transient public IF1<Object, String> renderValue_inner;

    public String renderValue_inner(Object value) {
      return renderValue_inner != null ? renderValue_inner.get(value) : renderValue_inner_base(value);
    }

    final public String renderValue_inner_fallback(IF1<Object, String> _f, Object value) {
      return _f != null ? _f.get(value) : renderValue_inner_base(value);
    }

    public String renderValue_inner_base(Object value) {
      if (value instanceof Boolean)
        return yesNo_short(((Boolean) value));
      return htmlEncode_nlToBr_withIndents(strOrEmpty(value));
    }

    public String renderTable(boolean withCmds) {
      return renderTable(withCmds, data.list());
    }

    public String valueToSortable(Object value) {
      if (value instanceof HTML)
        return ((HTML) value).get();
      return strOrNull(value);
    }

    public String renderTable(boolean withCmds, List<Map<String, Object>> l) {
      if (empty(l))
        return p("No entries");
      if (nempty(sortByField))
        l = sortByTransformedMapKey_alphaNum(__84 -> valueToSortable(__84), l, sortByField);
      if (descending)
        l = reversed(l);
      Map<String, String> keyEncoding = new HashMap();
      List<Map<String, Object>> l2 = map(l, map -> {
        Object id = itemID(map);
        map = mapMinusKeys(map, joinSets(unshownFields, unlistedFields));
        Map<String, Object> map2 = postProcessTableRow(map, mapToMap((key, value) -> pair(mapPut_returnValue(keyEncoding, key, encodeField(key)), renderValue(key, value)), map));
        if (singleton)
          map2.remove(data.fieldNameToHTML(data.idField()));
        if (withCmds)
          map2 = addCmdsToTableRow(map, map2);
        map2.put(firstKey(map2), aname("obj" + id, firstValue(map2)));
        return map2;
      });
      List<String> out = new ArrayList();
      if (paginate) {
        paginator.processParams(params);
        paginator.baseLink = baseLink;
        paginator.max = l(l2);
        out.add(pUnlessEmpty(paginator.renderNav()));
        l2 = subListOrFull(l2, paginator.visibleRange());
      }
      Map<String, String> replaceHeaders = new HashMap();
      if (sortable && !singleton)
        for (String key : keys(keyEncoding)) {
          String html = keyEncoding.get(key);
          boolean sortedByField = eq(sortByField, key);
          boolean showDescendingLink = sortedByField && !descending;
          String htmlOld = html;
          if (sortedByField) {
            String title = showDescendingLink ? "Click here to sort descending" : "Click here to sort ascending";
            String titleSorted = "Sorted by this field (" + (descending ? "descending" : "ascending") + ")";
            title = titleSorted + ". " + title;
            html = span_title(title, unicode_downOrUpPointingTriangle(descending)) + " " + html;
          }
          String sortLink = appendQueryToURL(baseLink, sortParameter, showDescendingLink ? "-" + key : key);
          replaceHeaders.put(htmlOld, ahref(sortLink, html));
        }
      out.add(hpostform(htmlTable2_noHtmlEncode(l2, paramsPlus(tableParams(), "replaceHeaders", replaceHeaders)) + (!withCmds || !showCheckBoxes ? "" : "\n" + pUnlessEmpty(renderBulkCmds())), "action", baseLink));
      return lines_rtrim(out);
    }

    transient public IF0<String> renderBulkCmds;

    public String renderBulkCmds() {
      return renderBulkCmds != null ? renderBulkCmds.get() : renderBulkCmds_base();
    }

    final public String renderBulkCmds_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : renderBulkCmds_base();
    }

    public String renderBulkCmds_base() {
      return "Bulk action: " + hselect("bulkAction", litorderedmap("", "", "deleteSelected", "Delete selected")) + " " + hsubmit("OK", "onclick", "return confirm('Are you sure?')");
    }

    public Map<String, Object> addCmdsToTableRow(Map<String, Object> map, Map<String, Object> map2) {
      if (showCheckBoxes) {
        Object id = itemID(map);
        map2.put(checkBoxKey(), hcheckbox("obj_" + id, false, "title", "Select this object for a bulk action"));
        map2 = putKeysFirst(map2, checkBoxKey());
      }
      map2.put(cmdsKey(), renderCmds(map));
      if (cmdsLeft)
        map2 = putKeysFirst(map2, cmdsKey());
      return map2;
    }

    public Object[] tableParams() {
      return litparams("tdParams", litparams("valign", "top"), "tableParams", litparams("class", tableClass));
    }

    public String renderForm(Map<String, Object> map) {
      map = mapMinusKeys(map, joinSets(unshownFields, uneditableFields));
      List<List<String>> matrix = map(map, (field, value) -> {
        String help = data.fieldHelp(field);
        return ll(encodeField(field), renderInput(field, value) + (empty(help) ? "" : p(small(help), "style", "text-align: right")));
      });
      massageFormMatrix(map, matrix);
      return htableRaw_valignTop(matrix, empty(formTableClass) ? litparams("border", 1, "cellpadding", 4) : litparams("class", formTableClass));
    }

    public String renderInput(String field, Object value) {
      String name = "f_" + field;
      return renderInput(name, data.getRenderer(field), value);
    }

    public String renderInput(String name, HCRUD_Data.Renderer r, Object value) {
      if (r != null)
        value = r.preprocessValue(value);
      if (r instanceof HCRUD_Data.TextArea)
        return htextarea(strOrEmpty(value), "name", name, "cols", ((HCRUD_Data.TextArea) r).cols, "rows", ((HCRUD_Data.TextArea) r).rows);
      if (r instanceof HCRUD_Data.TextField)
        return htextfield(name, strOrEmpty(value), "size", ((HCRUD_Data.TextField) r).cols, "style", "font-family: monospace");
      if (r instanceof HCRUD_Data.ComboBox)
        return renderComboBox(name, ((HCRUD_Data.ComboBox) r).valueToEntry(value), ((HCRUD_Data.ComboBox) r).entries);
      if (r instanceof HCRUD_Data.CheckBox)
        return htrickcheckboxWithText(name, "", isTrue(value));
      if (r instanceof HCRUD_Data.FlexibleLengthList) {
        List list = (List) value;
        List<String> rows = new ArrayList();
        int leeway = 5, n = l(list) + leeway;
        for (int i = 0; i < n; i++) {
          Object item = _get(list, i);
          print("Item: " + item);
          rows.add(tr(td(i + 1 + ".", "align", "right") + td(renderInput(name + "_" + i, ((HCRUD_Data.FlexibleLengthList) r).itemRenderer, item))));
        }
        return htag("table", lines(rows));
      }
      return renderInput_default(name, value);
    }

    public String renderInput_default(String name, Object value) {
      return htextfield(name, strOrEmpty(value), "size", defaultTextFieldCols);
    }

    public String renderNewForm() {
      return renderNewForm(data.emptyObject());
    }

    public String renderNewForm(Map<String, Object> map1) {
      Map<String, Object> map = mapWithoutKey(map1, data.idField());
      return hpostform(hhidden("action", "create") + renderForm(map) + p(hsubmit("Create")), paramsPlus(formParameters(), "action", baseLink));
    }

    transient public IF0<Object[]> formParameters;

    public Object[] formParameters() {
      return formParameters != null ? formParameters.get() : formParameters_base();
    }

    final public Object[] formParameters_fallback(IF0<Object[]> _f) {
      return _f != null ? _f.get() : formParameters_base();
    }

    public Object[] formParameters_base() {
      return null;
    }

    public String renderEditForm(String id) {
      Map<String, Object> map = mapWithoutKey(data.getObject(id), data.idField());
      if (map == null)
        return htmlEncode2("Entry " + id + " not found");
      return hpostform(hhidden("action", "update") + hhidden("id", id) + p("Object ID: " + htmlEncode2(id)) + renderForm(map) + p(hsubmit("Save changes")), paramsPlus(formParameters(), "action", baseLink + "#obj" + id));
    }

    public String renderPage(Map<String, String> params) {
      if (eqGet(params, "cmd", "new"))
        return frame("New " + itemName(), renderNewForm());
      if (nempty(params.get("edit")))
        return frame("Edit " + itemName(), renderEditForm(params.get("edit")));
      if (nempty(params.get("duplicate")))
        return frame("New " + itemName(), renderNewForm(data.getObject(params.get("duplicate"))));
      return frame(ahref(baseLink, firstToUpper(singleton ? data.itemName() : data.itemNamePlural())), render(mutationRights, params));
    }

    public HCRUD makeFrame(MakeFrame makeFrame) {
      super.makeFrame(makeFrame);
      return this;
    }

    public String cmdsKey() {
      return "<!-- cmds -->";
    }

    public String checkBoxKey() {
      return "<!-- checkbox -->";
    }

    public String itemName() {
      return data.itemName();
    }

    transient public IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> postProcessTableRow;

    public Map<String, Object> postProcessTableRow(Map<String, Object> data, Map<String, Object> rendered) {
      return postProcessTableRow != null ? postProcessTableRow.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    final public Map<String, Object> postProcessTableRow_fallback(IF2<Map<String, Object>, Map<String, Object>, Map<String, Object>> _f, Map<String, Object> data, Map<String, Object> rendered) {
      return _f != null ? _f.get(data, rendered) : postProcessTableRow_base(data, rendered);
    }

    public Map<String, Object> postProcessTableRow_base(Map<String, Object> data, Map<String, Object> rendered) {
      return rendered;
    }

    public Object itemID(Map<String, Object> item) {
      return mapGet(item, data.idField());
    }

    transient public IF1<Map<String, Object>, String> renderCmds;

    public String renderCmds(Map<String, Object> item) {
      return renderCmds != null ? renderCmds.get(item) : renderCmds_base(item);
    }

    final public String renderCmds_fallback(IF1<Map<String, Object>, String> _f, Map<String, Object> item) {
      return _f != null ? _f.get(item) : renderCmds_base(item);
    }

    public String renderCmds_base(Map<String, Object> item) {
      Object id = itemID(item);
      return joinNemptiesWithVBar(!actuallyAllowEdit() ? null : ahref(editLink(id), "EDIT"), !actuallyAllowDelete() ? null : !data.objectCanBeDeleted(id) ? span_title("Object can't be deleted, please delete references first", htmlEncode2(unicode_DEL())) : ahrefWithConfirm("Really delete item " + id + "?", deleteLink(id), htmlEncode2(unicode_DEL()), "title", "delete"), !actuallyAllowCreate() ? null : ahref(duplicateLink(id), "dup", "title", "duplicate"));
    }

    public boolean actuallyAllowCreate() {
      return !singleton && allowCreateOrDelete && allowCreate;
    }

    public boolean actuallyAllowEdit() {
      return allowCreateOrDelete && allowEdit;
    }

    public boolean actuallyAllowDelete() {
      return !singleton && allowCreateOrDelete;
    }

    transient public IVF2<Map<String, Object>, List<List<String>>> massageFormMatrix;

    public void massageFormMatrix(Map<String, Object> map, List<List<String>> matrix) {
      if (massageFormMatrix != null)
        massageFormMatrix.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    final public void massageFormMatrix_fallback(IVF2<Map<String, Object>, List<List<String>>> _f, Map<String, Object> map, List<List<String>> matrix) {
      if (_f != null)
        _f.get(map, matrix);
      else
        massageFormMatrix_base(map, matrix);
    }

    public void massageFormMatrix_base(Map<String, Object> map, List<List<String>> matrix) {
    }

    transient public IF3<String, String, List<String>, String> renderComboBox;

    public String renderComboBox(String name, String value, List<String> entries) {
      return renderComboBox != null ? renderComboBox.get(name, value, entries) : renderComboBox_base(name, value, entries);
    }

    final public String renderComboBox_fallback(IF3<String, String, List<String>, String> _f, String name, String value, List<String> entries) {
      return _f != null ? _f.get(name, value, entries) : renderComboBox_base(name, value, entries);
    }

    public String renderComboBox_base(String name, String value, List<String> entries) {
      if (haveSelectizeJS) {
        String id = aGlobalID();
        return hselect_list(entries, value, "name", name, "id", id) + hjs("$('#" + id + "').selectize" + "\r\n          ({\r\n            searchField: 'text',\r\n            openOnFocus: true,\r\n            dropdownParent: 'body'\r\n            /*allowEmptyOption: true*/\r\n          });\r\n        ") + hcss(".selectize-input { min-width: 300px }");
      }
      if (haveJQuery) {
        String id = aGlobalID();
        return tag("datalist", mapToLines("hoption", entries), "id", id) + tag("input", "", "name", name, "list", id);
      }
      return hselect_list(entries, value, "name", name);
    }

    public void processSortParameter(Map<String, String> params) {
      String sort = mapGet(params, sortParameter);
      sortByField = null;
      descending = false;
      if (nempty(sort))
        if (startsWith(sort, "-")) {
          descending = true;
          sortByField = substring(sort, 1);
        } else
          sortByField = sort;
    }
  }

  static public class ReliableSingleThread implements Runnable {

    public boolean _isTransient() {
      return true;
    }

    public Object runnable;

    public String name = "Single Thread";

    public boolean cancelBeforeTrigger = false;

    public F0<AutoCloseable> enter;

    public int cancelTimeOut = 10000;

    public boolean trigger = false;

    public Thread thread;

    public WeakReference<Thread> threadBeingCancelled;

    public ReliableSingleThread(Object runnable) {
      this.runnable = runnable;
    }

    public void trigger() {
      go();
    }

    synchronized public void go() {
      if (cancelBeforeTrigger)
        cancel();
      trigger = true;
      if (!running()) {
        AutoCloseable __1 = callF(enter);
        try {
          thread = startThread(name, new Runnable() {

            public void run() {
              try {
                AutoCloseable __2 = callF(enter);
                try {
                  _run();
                } finally {
                  _close(__2);
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "temp callF(enter);\r\n        _run();";
            }
          });
        } finally {
          _close(__1);
        }
      }
    }

    public void run() {
      go();
    }

    public void get() {
      go();
    }

    synchronized public boolean running() {
      return thread != null;
    }

    public void triggerAndWait() {
      trigger();
      waitUntilDone();
    }

    public void waitUntilDone() {
      while (running()) sleep(1);
    }

    public void _run() {
      try {
        while (licensed()) {
          Thread oldThread;
          synchronized (this) {
            if (!trigger) {
              thread = null;
              break;
            }
            oldThread = getWeakRef(threadBeingCancelled);
            trigger = false;
          }
          if (oldThread != null && oldThread != currentThread())
            oldThread.join(cancelTimeOut);
          pcallF(runnable);
        }
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    synchronized public void cancel() {
      if (thread == null)
        return;
      threadBeingCancelled = new WeakReference(thread);
      cancelAndInterruptThread(thread);
      thread = null;
    }

    public void cancelAndTrigger() {
      cancel();
      trigger();
    }

    synchronized public boolean triggered() {
      return trigger;
    }

    public void cleanMeUp() {
      cancel();
    }

    public ReliableSingleThread cancelBeforeTrigger() {
      cancelBeforeTrigger = true;
      return this;
    }
  }

  static public class JFastLogView_noWrap extends JComponent implements Scrollable {

    public List<String> lines = syncList();

    public boolean endsWithNewLine, verbose;

    public Dimension getPreferredScrollableViewportSize() {
      return getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
      return 20;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
      return (direction == SwingConstants.HORIZONTAL ? visibleRect.width : visibleRect.height) * 5 / 6;
    }

    public boolean getScrollableTracksViewportWidth() {
      return false;
    }

    public boolean getScrollableTracksViewportHeight() {
      return false;
    }

    public void paint(Graphics g) {
      int w = getWidth(), h = getHeight();
      g.setColor(getBackground());
      g.fillRect(0, 0, w, h);
      g.setColor(getForeground());
      FontMetrics fm = componentFontMetrics(this);
      int fh = fm.getHeight();
      Rectangle clip = g.getClipBounds();
      int start, end;
      if (clip == null) {
        start = 0;
        end = l(lines);
      } else {
        start = max(0, clip.y / fh);
        end = min(l(lines), idiv_ceil(clip.y + clip.height, fh));
      }
      int y = fm.getAscent() + start * fh;
      for (int i = start; i < end; i++) {
        String s = get(lines, i);
        if (s != null)
          g.drawString(s, 0, y);
        y += fh;
      }
    }

    public Dimension getPreferredSize() {
      FontMetrics fm = componentFontMetrics(this);
      if (fm == null)
        return new Dimension(50, 50);
      int fh = fm.getHeight();
      int w = 0;
      for (int i = 0; i < l(lines); i++) {
        String s = get(lines, i);
        w = max(w, fm.stringWidth(unnull(s)));
      }
      return new Dimension(w, fh * l(lines));
    }

    public JFastLogView_noWrap() {
    }

    public JFastLogView_noWrap(String text) {
      setText(text);
    }

    {
      componentPopupMenuItem(this, "Copy full text", new Runnable() {

        public void run() {
          try {
            copyFullText();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "copyFullText();";
        }
      });
    }

    public boolean setLines(Collection<String> lines) {
      List<String> newList = asSyncList(lines);
      if (eq(this.lines, newList))
        return false;
      this.lines = newList;
      _revalidate(this);
      return true;
    }

    public boolean setText(String text) {
      endsWithNewLine = endsWithNewLine(text);
      return setLines(lines(text));
    }

    public void append(String text) {
      if (nempty(text))
        setText(getText() + text);
    }

    public String getText() {
      return lines_rtrimIf(!endsWithNewLine, cloneList(lines));
    }

    public void copyFullText() {
      copyTextToClipboard(getText());
    }
  }

  static public class FixedRateTimer extends java.util.Timer {

    public FixedRateTimer() {
      this(false);
    }

    public FixedRateTimer(boolean daemon) {
      this(defaultTimerName(), daemon);
    }

    public FixedRateTimer(String name) {
      this(name, false);
    }

    public FixedRateTimer(String name, boolean daemon) {
      super(name, daemon);
      _registerTimer(this);
    }

    public List<Entry> entries = synchroList();

    static public class Entry implements IFieldsToList {

      public TimerTask task;

      public long firstTime;

      public long period;

      public Entry() {
      }

      public Entry(TimerTask task, long firstTime, long period) {
        this.period = period;
        this.firstTime = firstTime;
        this.task = task;
      }

      public String toString() {
        return shortClassName(this) + "(" + task + ", " + firstTime + ", " + period + ")";
      }

      public Object[] _fieldsToList() {
        return new Object[] { task, firstTime, period };
      }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
      entries.add(new Entry(task, now() + delay, period));
      super.scheduleAtFixedRate(task, delay, period);
    }

    public void cancel() {
      entries.clear();
      super.cancel();
    }

    public int purge() {
      entries.clear();
      return super.purge();
    }

    public FixedRateTimer changeRate(int newPeriod) {
      Object r = ((SmartTimerTask) first(entries).task).r;
      cancel();
      return doEvery(newPeriod, r);
    }
  }

  final static public class Rect {

    public int x, y, w, h;

    public Rect() {
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public Rect(Pt p, int w, int h) {
      this.h = h;
      this.w = w;
      x = p.x;
      y = p.y;
    }

    public Rect(Rect r) {
      x = r.x;
      y = r.y;
      w = r.w;
      h = r.h;
    }

    public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    public int x1() {
      return x;
    }

    public int y1() {
      return y;
    }

    public int x2() {
      return x + w;
    }

    public int y2() {
      return y + h;
    }

    public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    public boolean empty() {
      return w <= 0 || h <= 0;
    }
  }

  static public interface IBWImage {

    public int getWidth();

    public int getHeight();

    public float getFloatPixel(int x, int y);
  }

  static public class Pt {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + ", " + y;
    }
  }

  static public class ProgramScan {

    static public int threads = isWindows() ? 500 : 10;

    static public int timeout = 5000;

    static public String ip = "127.0.0.1";

    static public int quickScanFrom = 10000, quickScanTo = 10999;

    static public int maxNumberOfVMs_android = 4;

    static public int maxNumberOfVMs_nonAndroid = 50;

    static public int maxNumberOfVMs;

    static public boolean verbose = false;

    static public class Program {

      public int port;

      public String helloString;

      public Program(int port, String helloString) {
        this.helloString = helloString;
        this.port = port;
      }
    }

    static public List<Program> scan() {
      try {
        return scan(1, 65535);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public List<Program> scan(int fromPort, int toPort) {
      return scan(fromPort, toPort, new int[0]);
    }

    static public List<Program> scan(int fromPort, int toPort, int[] preferredPorts) {
      try {
        Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
        int scanSize = toPort - fromPort + 1;
        String name = toPort < 10000 ? "bot" : "program";
        int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
        final ExecutorService es = Executors.newFixedThreadPool(threads);
        if (verbose)
          print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
        startTiming();
        List<Future<Program>> futures = new ArrayList();
        List<Integer> ports = new ArrayList();
        for (int port : preferredPorts) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        for (int port = fromPort; port <= toPort; port++) if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
          futures.add(checkPort(es, ip, port, timeout));
          ports.add(port);
        }
        es.shutdown();
        List<Program> programs = new ArrayList();
        long time = now();
        int i = 0;
        for (final Future<Program> f : futures) {
          if (verbose)
            print("Waiting for port " + get(ports, i++) + " at time " + (now() - time));
          Program p = f.get();
          if (p != null)
            programs.add(p);
        }
        if (verbose)
          print("Found " + programs.size() + " " + name + "(s) on " + ip);
        return programs;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    static public Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
      return es.submit(new Callable<Program>() {

        @Override
        public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
      });
    }

    static public List<Program> quickScan() {
      return scan(quickScanFrom, quickScanTo);
    }

    static public List<Program> quickBotScan() {
      return quickBotScan(new int[0]);
    }

    static public List<Program> quickBotScan(int[] preferredPorts) {
      if (maxNumberOfVMs == 0)
        maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
      return scan(4999, 5000 + maxNumberOfVMs - 1, preferredPorts);
    }
  }

  static abstract public class F0<A> {

    abstract public A get();
  }

  static abstract public class F1<A, B> {

    abstract public B get(A a);
  }

  static abstract public class IterableIterator<A> implements Iterator<A>, Iterable<A> {

    public Iterator<A> iterator() {
      return this;
    }

    public void remove() {
      unsupportedOperation();
    }
  }

  static abstract public class F2<A, B, C> {

    abstract public C get(A a, B b);
  }

  static public class RGB {

    public float r, g, b;

    public RGB() {
    }

    public RGB(float r, float g, float b) {
      this.r = r;
      this.g = g;
      this.b = b;
    }

    public RGB(double r, double g, double b) {
      this.r = (float) r;
      this.g = (float) g;
      this.b = (float) b;
    }

    public RGB(int rgb) {
      this(new Color(rgb));
    }

    public RGB(double brightness) {
      this.r = this.g = this.b = max(0f, min(1f, (float) brightness));
    }

    public RGB(Color color) {
      this.r = color.getRed() / 255f;
      this.g = color.getGreen() / 255f;
      this.b = color.getBlue() / 255f;
    }

    public RGB(String hex) {
      int i = l(hex) - 6;
      r = Integer.parseInt(hex.substring(i, i + 2), 16) / 255f;
      g = Integer.parseInt(hex.substring(i + 2, i + 4), 16) / 255f;
      b = Integer.parseInt(hex.substring(i + 4, i + 6), 16) / 255f;
    }

    public float getComponent(int i) {
      return i == 0 ? r : i == 1 ? g : b;
    }

    public Color getColor() {
      return new Color(r, g, b);
    }

    public static RGB newSafe(float r, float g, float b) {
      return new RGB(Math.max(0, Math.min(1, r)), Math.max(0, Math.min(1, g)), Math.max(0, Math.min(1, b)));
    }

    public int asInt() {
      return getColor().getRGB() & 0xFFFFFF;
    }

    public int getInt() {
      return getColor().getRGB() & 0xFFFFFF;
    }

    public float getBrightness() {
      return (r + g + b) / 3.0f;
    }

    public String getHexString() {
      return Integer.toHexString(asInt() | 0xFF000000).substring(2).toUpperCase();
    }

    @Override
    public boolean equals(Object o) {
      if (this == o)
        return true;
      if (!(o instanceof RGB))
        return false;
      RGB rgb = (RGB) o;
      if (Float.compare(rgb.b, b) != 0)
        return false;
      if (Float.compare(rgb.g, g) != 0)
        return false;
      if (Float.compare(rgb.r, r) != 0)
        return false;
      return true;
    }

    @Override
    public int hashCode() {
      int result = (r != +0.0f ? Float.floatToIntBits(r) : 0);
      result = 31 * result + (g != +0.0f ? Float.floatToIntBits(g) : 0);
      result = 31 * result + (b != +0.0f ? Float.floatToIntBits(b) : 0);
      return result;
    }

    public boolean isBlack() {
      return r == 0f && g == 0f && b == 0f;
    }

    public boolean isWhite() {
      return r == 1f && g == 1f && b == 1f;
    }

    public String toString() {
      return getHexString();
    }

    public int redInt() {
      return iround(r * 255);
    }

    public int greenInt() {
      return iround(g * 255);
    }

    public int blueInt() {
      return iround(b * 255);
    }
  }

  static public interface MakesBufferedImage {

    public BufferedImage getBufferedImage();

    public int getWidth();

    public int getHeight();
  }

  static public class SynchronizedArrayList<A> extends SynchronizedArrayList_Base<A> implements RandomAccess, Cloneable {

    static final public int DEFAULT_CAPACITY = 10;

    static final public Object[] EMPTY_ELEMENTDATA = {};

    static final public Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = {};

    transient public Object[] elementData;

    public int size;

    public SynchronizedArrayList(int initialCapacity) {
      if (initialCapacity > 0) {
        this.elementData = new Object[initialCapacity];
      } else if (initialCapacity == 0) {
        this.elementData = EMPTY_ELEMENTDATA;
      } else {
        throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
      }
    }

    public SynchronizedArrayList() {
      this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public SynchronizedArrayList(Collection<? extends A> c) {
      elementData = c.toArray();
      if ((size = elementData.length) != 0) {
        if (elementData.getClass() != Object[].class)
          elementData = Arrays.copyOf(elementData, size, Object[].class);
      } else {
        this.elementData = EMPTY_ELEMENTDATA;
      }
    }

    public synchronized void trimToSize() {
      modCount++;
      if (size < elementData.length) {
        elementData = (size == 0) ? EMPTY_ELEMENTDATA : Arrays.copyOf(elementData, size);
      }
    }

    public synchronized void ensureCapacity(int minCapacity) {
      int minExpand = (elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA) ? 0 : DEFAULT_CAPACITY;
      if (minCapacity > minExpand) {
        ensureExplicitCapacity(minCapacity);
      }
    }

    final public void ensureCapacityInternal(int minCapacity) {
      if (elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
        minCapacity = Math.max(DEFAULT_CAPACITY, minCapacity);
      }
      ensureExplicitCapacity(minCapacity);
    }

    final public void ensureExplicitCapacity(int minCapacity) {
      modCount++;
      if (minCapacity - elementData.length > 0)
        grow(minCapacity);
    }

    static final public int MAX_ARRAY_SIZE = Integer.MAX_VALUE - 8;

    final public void grow(int minCapacity) {
      int oldCapacity = elementData.length;
      int newCapacity = oldCapacity + (oldCapacity >> 1);
      if (newCapacity - minCapacity < 0)
        newCapacity = minCapacity;
      if (newCapacity - MAX_ARRAY_SIZE > 0)
        newCapacity = hugeCapacity(minCapacity);
      elementData = Arrays.copyOf(elementData, newCapacity);
    }

    static public int hugeCapacity(int minCapacity) {
      if (minCapacity < 0)
        throw new OutOfMemoryError();
      return (minCapacity > MAX_ARRAY_SIZE) ? Integer.MAX_VALUE : MAX_ARRAY_SIZE;
    }

    public synchronized int size() {
      return size;
    }

    public synchronized boolean isEmpty() {
      return size == 0;
    }

    public boolean contains(Object o) {
      return indexOf(o) >= 0;
    }

    public synchronized int indexOf(Object o) {
      if (o == null) {
        for (int i = 0; i < size; i++) if (elementData[i] == null)
          return i;
      } else {
        for (int i = 0; i < size; i++) if (o.equals(elementData[i]))
          return i;
      }
      return -1;
    }

    public synchronized int lastIndexOf(Object o) {
      if (o == null) {
        for (int i = size - 1; i >= 0; i--) if (elementData[i] == null)
          return i;
      } else {
        for (int i = size - 1; i >= 0; i--) if (o.equals(elementData[i]))
          return i;
      }
      return -1;
    }

    public synchronized Object clone() {
      return new SynchronizedArrayList(this);
    }

    public synchronized Object[] toArray() {
      return Arrays.copyOf(elementData, size);
    }

    @SuppressWarnings("unchecked")
    public synchronized <T> T[] toArray(T[] a) {
      if (a.length < size)
        return (T[]) Arrays.copyOf(elementData, size, a.getClass());
      System.arraycopy(elementData, 0, a, 0, size);
      if (a.length > size)
        a[size] = null;
      return a;
    }

    @SuppressWarnings("unchecked")
    public A elementData(int index) {
      return (A) elementData[index];
    }

    public synchronized A get(int index) {
      rangeCheck(index);
      return elementData(index);
    }

    public synchronized A set(int index, A element) {
      rangeCheck(index);
      A oldValue = elementData(index);
      elementData[index] = element;
      return oldValue;
    }

    public synchronized boolean add(A e) {
      ensureCapacityInternal(size + 1);
      elementData[size++] = e;
      return true;
    }

    public synchronized void add(int index, A element) {
      rangeCheckForAdd(index);
      ensureCapacityInternal(size + 1);
      System.arraycopy(elementData, index, elementData, index + 1, size - index);
      elementData[index] = element;
      size++;
    }

    public synchronized A remove(int index) {
      rangeCheck(index);
      modCount++;
      A oldValue = elementData(index);
      int numMoved = size - index - 1;
      if (numMoved > 0)
        System.arraycopy(elementData, index + 1, elementData, index, numMoved);
      elementData[--size] = null;
      return oldValue;
    }

    public synchronized boolean remove(Object o) {
      if (o == null) {
        for (int index = 0; index < size; index++) if (elementData[index] == null) {
          fastRemove(index);
          return true;
        }
      } else {
        for (int index = 0; index < size; index++) if (o.equals(elementData[index])) {
          fastRemove(index);
          return true;
        }
      }
      return false;
    }

    final public void fastRemove(int index) {
      modCount++;
      int numMoved = size - index - 1;
      if (numMoved > 0)
        System.arraycopy(elementData, index + 1, elementData, index, numMoved);
      elementData[--size] = null;
    }

    public synchronized void clear() {
      modCount++;
      for (int i = 0; i < size; i++) elementData[i] = null;
      size = 0;
    }

    public synchronized boolean addAll(Collection<? extends A> c) {
      Object[] a = c.toArray();
      int numNew = a.length;
      ensureCapacityInternal(size + numNew);
      System.arraycopy(a, 0, elementData, size, numNew);
      size += numNew;
      return numNew != 0;
    }

    public synchronized boolean addAll(int index, Collection<? extends A> c) {
      rangeCheckForAdd(index);
      Object[] a = c.toArray();
      int numNew = a.length;
      ensureCapacityInternal(size + numNew);
      int numMoved = size - index;
      if (numMoved > 0)
        System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
      System.arraycopy(a, 0, elementData, index, numNew);
      size += numNew;
      return numNew != 0;
    }

    public synchronized void removeRange(int fromIndex, int toIndex) {
      modCount++;
      int numMoved = size - toIndex;
      System.arraycopy(elementData, toIndex, elementData, fromIndex, numMoved);
      int newSize = size - (toIndex - fromIndex);
      for (int i = newSize; i < size; i++) {
        elementData[i] = null;
      }
      size = newSize;
    }

    final public void rangeCheck(int index) {
      if (index >= size)
        throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
    }

    final public void rangeCheckForAdd(int index) {
      if (index > size || index < 0)
        throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
    }

    final public String outOfBoundsMsg(int index) {
      return "Index: " + index + ", Size: " + size;
    }

    public synchronized boolean removeAll(Collection<?> c) {
      Objects.requireNonNull(c);
      return batchRemove(c, false);
    }

    public synchronized boolean retainAll(Collection<?> c) {
      Objects.requireNonNull(c);
      return batchRemove(c, true);
    }

    final public boolean batchRemove(Collection<?> c, boolean complement) {
      final Object[] elementData = this.elementData;
      int r = 0, w = 0;
      boolean modified = false;
      try {
        for (; r < size; r++) if (c.contains(elementData[r]) == complement)
          elementData[w++] = elementData[r];
      } finally {
        if (r != size) {
          System.arraycopy(elementData, r, elementData, w, size - r);
          w += size - r;
        }
        if (w != size) {
          for (int i = w; i < size; i++) elementData[i] = null;
          modCount += size - w;
          size = w;
          modified = true;
        }
      }
      return modified;
    }

    final public void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
      int expectedModCount = modCount;
      s.defaultWriteObject();
      s.writeInt(size);
      for (int i = 0; i < size; i++) {
        s.writeObject(elementData[i]);
      }
      if (modCount != expectedModCount) {
        throw new ConcurrentModificationException();
      }
    }

    final public void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
      elementData = EMPTY_ELEMENTDATA;
      s.defaultReadObject();
      s.readInt();
      if (size > 0) {
        ensureCapacityInternal(size);
        Object[] a = elementData;
        for (int i = 0; i < size; i++) {
          a[i] = s.readObject();
        }
      }
    }

    public synchronized ListIterator<A> listIterator(int index) {
      if (index < 0 || index > size)
        throw new IndexOutOfBoundsException("Index: " + index);
      return new ListItr(index);
    }

    public ListIterator<A> listIterator() {
      return new ListItr(0);
    }

    public Iterator<A> iterator() {
      return concurrentlyIterateList(this);
    }

    public class Itr implements Iterator<A> {

      public int cursor;

      public int lastRet = -1;

      public int expectedModCount = modCount;

      public boolean hasNext() {
        return cursor != size;
      }

      @SuppressWarnings("unchecked")
      public A next() {
        checkForComodification();
        int i = cursor;
        if (i >= size)
          throw new NoSuchElementException();
        Object[] elementData = SynchronizedArrayList.this.elementData;
        if (i >= elementData.length)
          throw new ConcurrentModificationException();
        cursor = i + 1;
        return (A) elementData[lastRet = i];
      }

      public void remove() {
        if (lastRet < 0)
          throw new IllegalStateException();
        checkForComodification();
        try {
          SynchronizedArrayList.this.remove(lastRet);
          cursor = lastRet;
          lastRet = -1;
          expectedModCount = modCount;
        } catch (IndexOutOfBoundsException ex) {
          throw new ConcurrentModificationException();
        }
      }

      final public void checkForComodification() {
        if (modCount != expectedModCount)
          throw new ConcurrentModificationException();
      }
    }

    public class ListItr extends Itr implements ListIterator<A> {

      public ListItr(int index) {
        super();
        cursor = index;
      }

      public boolean hasPrevious() {
        return cursor != 0;
      }

      public int nextIndex() {
        return cursor;
      }

      public int previousIndex() {
        return cursor - 1;
      }

      @SuppressWarnings("unchecked")
      public A previous() {
        checkForComodification();
        int i = cursor - 1;
        if (i < 0)
          throw new NoSuchElementException();
        Object[] elementData = SynchronizedArrayList.this.elementData;
        if (i >= elementData.length)
          throw new ConcurrentModificationException();
        cursor = i;
        return (A) elementData[lastRet = i];
      }

      public void set(A e) {
        if (lastRet < 0)
          throw new IllegalStateException();
        checkForComodification();
        try {
          SynchronizedArrayList.this.set(lastRet, e);
        } catch (IndexOutOfBoundsException ex) {
          throw new ConcurrentModificationException();
        }
      }

      public void add(A e) {
        checkForComodification();
        try {
          int i = cursor;
          SynchronizedArrayList.this.add(i, e);
          cursor = i + 1;
          lastRet = -1;
          expectedModCount = modCount;
        } catch (IndexOutOfBoundsException ex) {
          throw new ConcurrentModificationException();
        }
      }
    }

    public List<A> subList(int fromIndex, int toIndex) {
      subListRangeCheck(fromIndex, toIndex, size);
      return new SubList(this, 0, fromIndex, toIndex);
    }

    static public void subListRangeCheck(int fromIndex, int toIndex, int size) {
      if (fromIndex < 0)
        throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
      if (toIndex > size)
        throw new IndexOutOfBoundsException("toIndex = " + toIndex);
      if (fromIndex > toIndex)
        throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
    }

    public class SubList extends SynchronizedArrayList_Base<A> implements RandomAccess {

      final public SynchronizedArrayList_Base<A> parent;

      final public int parentOffset;

      final public int offset;

      public int size;

      public SubList(SynchronizedArrayList_Base<A> parent, int offset, int fromIndex, int toIndex) {
        this.parent = parent;
        this.parentOffset = fromIndex;
        this.offset = offset + fromIndex;
        this.size = toIndex - fromIndex;
        this.modCount = SynchronizedArrayList.this.modCount;
      }

      public A set(int index, A e) {
        synchronized (SynchronizedArrayList.this) {
          rangeCheck(index);
          checkForComodification();
          A oldValue = SynchronizedArrayList.this.elementData(offset + index);
          SynchronizedArrayList.this.elementData[offset + index] = e;
          return oldValue;
        }
      }

      public A get(int index) {
        synchronized (SynchronizedArrayList.this) {
          rangeCheck(index);
          checkForComodification();
          return SynchronizedArrayList.this.elementData(offset + index);
        }
      }

      public int size() {
        synchronized (SynchronizedArrayList.this) {
          checkForComodification();
          return this.size;
        }
      }

      public void add(int index, A e) {
        synchronized (SynchronizedArrayList.this) {
          rangeCheckForAdd(index);
          checkForComodification();
          parent.add(parentOffset + index, e);
          this.modCount = parent.modCount();
          this.size++;
        }
      }

      public A remove(int index) {
        synchronized (SynchronizedArrayList.this) {
          rangeCheck(index);
          checkForComodification();
          A result = parent.remove(parentOffset + index);
          this.modCount = parent.modCount();
          this.size--;
          return result;
        }
      }

      public void removeRange(int fromIndex, int toIndex) {
        synchronized (SynchronizedArrayList.this) {
          checkForComodification();
          parent.removeRange(parentOffset + fromIndex, parentOffset + toIndex);
          this.modCount = parent.modCount();
          this.size -= toIndex - fromIndex;
        }
      }

      public boolean addAll(Collection<? extends A> c) {
        return addAll(this.size, c);
      }

      public boolean addAll(int index, Collection<? extends A> c) {
        synchronized (SynchronizedArrayList.this) {
          rangeCheckForAdd(index);
          int cSize = c.size();
          if (cSize == 0)
            return false;
          checkForComodification();
          parent.addAll(parentOffset + index, c);
          this.modCount = parent.modCount();
          this.size += cSize;
          return true;
        }
      }

      public Iterator<A> iterator() {
        return listIterator();
      }

      public ListIterator<A> listIterator(final int index) {
        synchronized (SynchronizedArrayList.this) {
          checkForComodification();
          rangeCheckForAdd(index);
          final int offset = this.offset;
          return new ListIterator<A>() {

            public int cursor = index;

            public int lastRet = -1;

            public int expectedModCount = SynchronizedArrayList.this.modCount;

            public boolean hasNext() {
              return cursor != SubList.this.size;
            }

            @SuppressWarnings("unchecked")
            public A next() {
              checkForComodification();
              int i = cursor;
              if (i >= SubList.this.size)
                throw new NoSuchElementException();
              Object[] elementData = SynchronizedArrayList.this.elementData;
              if (offset + i >= elementData.length)
                throw new ConcurrentModificationException();
              cursor = i + 1;
              return (A) elementData[offset + (lastRet = i)];
            }

            public boolean hasPrevious() {
              return cursor != 0;
            }

            @SuppressWarnings("unchecked")
            public A previous() {
              checkForComodification();
              int i = cursor - 1;
              if (i < 0)
                throw new NoSuchElementException();
              Object[] elementData = SynchronizedArrayList.this.elementData;
              if (offset + i >= elementData.length)
                throw new ConcurrentModificationException();
              cursor = i;
              return (A) elementData[offset + (lastRet = i)];
            }

            public int nextIndex() {
              return cursor;
            }

            public int previousIndex() {
              return cursor - 1;
            }

            public void remove() {
              if (lastRet < 0)
                throw new IllegalStateException();
              checkForComodification();
              try {
                SubList.this.remove(lastRet);
                cursor = lastRet;
                lastRet = -1;
                expectedModCount = SynchronizedArrayList.this.modCount;
              } catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
              }
            }

            public void set(A e) {
              if (lastRet < 0)
                throw new IllegalStateException();
              checkForComodification();
              try {
                SynchronizedArrayList.this.set(offset + lastRet, e);
              } catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
              }
            }

            public void add(A e) {
              checkForComodification();
              try {
                int i = cursor;
                SubList.this.add(i, e);
                cursor = i + 1;
                lastRet = -1;
                expectedModCount = SynchronizedArrayList.this.modCount;
              } catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
              }
            }

            final public void checkForComodification() {
              if (expectedModCount != SynchronizedArrayList.this.modCount)
                throw new ConcurrentModificationException();
            }
          };
        }
      }

      public List<A> subList(int fromIndex, int toIndex) {
        synchronized (SynchronizedArrayList.this) {
          subListRangeCheck(fromIndex, toIndex, size);
          return new SubList(parent, offset, fromIndex, toIndex);
        }
      }

      final public void rangeCheck(int index) {
        if (index < 0 || index >= this.size)
          throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
      }

      final public void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size)
          throw new IndexOutOfBoundsException(outOfBoundsMsg(index));
      }

      final public String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
      }

      final public void checkForComodification() {
        if (SynchronizedArrayList.this.modCount != this.modCount)
          throw new ConcurrentModificationException();
      }
    }

    @Override
    @SuppressWarnings("unchecked")
    public synchronized void sort(Comparator<? super A> c) {
      final int expectedModCount = modCount;
      Arrays.sort((A[]) elementData, 0, size, c);
      if (modCount != expectedModCount) {
        throw new ConcurrentModificationException();
      }
      modCount++;
    }
  }

  static public class Flag implements Runnable {

    public boolean up = false;

    public synchronized boolean raise() {
      if (!up) {
        up = true;
        notifyAll();
        return true;
      } else
        return false;
    }

    public synchronized void waitUntilUp() {
      while (!up) {
        try {
          wait();
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
      }
    }

    public synchronized void waitUntilUp(long timeout) {
      if (!up) {
        try {
          wait(timeout);
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
      }
    }

    public synchronized boolean isUp() {
      return up;
    }

    public boolean get() {
      return isUp();
    }

    public String toString() {
      return isUp() ? "up" : "down";
    }

    public void waitForThisOr(Flag otherFlag) {
      try {
        while (!isUp() && !otherFlag.isUp()) Thread.sleep(50);
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public void run() {
      raise();
    }
  }

  static public int concepts_internStringsLongerThan = 10;

  static public ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

  static public boolean concepts_unlistedByDefault = false;

  static public interface Derefable {

    public Concept get();
  }

  static public interface IConceptIndex {

    public void update(Concept c);

    public void remove(Concept c);
  }

  static public interface IFieldIndex<A extends Concept, Val> {

    public Collection<A> getAll(Val val);

    public List<Val> allValues();

    public MultiSet<Val> allValues_multiSet();
  }

  static public class Concepts implements AutoCloseable {

    public Map<Long, Concept> concepts = synchroTreeMap();

    public HashMap<Class, Object> perClassData;

    public Map miscMap;

    transient public String programID;

    public long idCounter;

    transient volatile public long changes, changesWritten, lastChange;

    transient volatile public java.util.Timer autoSaver;

    transient volatile public boolean dontSave = false;

    transient volatile public boolean savingConcepts, noXFullGrab;

    transient public boolean vmBusSend = true;

    transient public boolean initialSave = true;

    transient public int autoSaveInterval = -1000;

    transient public boolean useGZIP = true, quietSave;

    transient public ReentrantLock lock = new ReentrantLock(true);

    transient public ReentrantLock saverLock = new ReentrantLock(true);

    transient public long lastSaveTook = -1, lastSaveWas;

    transient public float maxAutoSavePercentage = 10;

    transient public List<IConceptIndex> conceptIndices;

    transient public Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;

    transient public Map<Class<? extends Concept>, Map<String, IFieldIndex>> ciFieldIndices;

    transient public List saveActions = synchroList();

    transient public Object classFinder = _defaultClassFinder();

    transient public List onAllChanged = synchroList();

    transient public Object saveWrapper;

    public Concepts() {
    }

    public Concepts(String programID) {
      this.programID = programID;
    }

    synchronized public long internalID() {
      do {
        ++idCounter;
      } while (hasConcept(idCounter));
      return idCounter;
    }

    synchronized public HashMap<Class, Object> perClassData() {
      if (perClassData == null)
        perClassData = new HashMap();
      return perClassData;
    }

    public void initProgramID() {
      if (programID == null)
        programID = getDBProgramID();
    }

    public Concepts load() {
      return load(false);
    }

    public Concepts safeLoad() {
      return load(true);
    }

    public Concepts load(boolean allDynamic) {
      initProgramID();
      try {
        if (tryToGrab(allDynamic))
          return this;
      } catch (Throwable e) {
        if (!exceptionMessageContains(e, "no xfullgrab"))
          printShortException(e);
        print("xfullgrab failed - loading DB of " + programID + " from disk");
      }
      return loadFromDisk(allDynamic);
    }

    public Concepts loadFromDisk() {
      return loadFromDisk(false);
    }

    public Concepts loadFromDisk(boolean allDynamic) {
      if (nempty(concepts))
        clearConcepts();
      restoreLatestBackupIfConceptsFileEmpty(programID, "doIt", true);
      long time = now();
      Map<Long, Concept> _concepts = concepts;
      readLocally2_allDynamic.set(allDynamic);
      AutoCloseable __2 = tempSetTL(readLocally2_classFinder, classFinder);
      try {
        readLocally2(this, programID, "concepts");
        Map<Long, Concept> __concepts = concepts;
        concepts = _concepts;
        concepts.putAll(__concepts);
        int l = readLocally_stringLength;
        int tokrefs = unstructure_tokrefs;
        assignConceptsToUs();
        done("Loaded " + n(l(concepts), "concepts"), time);
        try {
          if (fileSize(getProgramFile(programID, "idCounter.structure")) != 0)
            readLocally2(this, programID, "idCounter");
          else
            calcIdCounter();
        } catch (Throwable e) {
          _handleException(e);
          calcIdCounter();
        }
        if (initialSave)
          allChanged();
        return this;
      } finally {
        _close(__2);
      }
    }

    public Concepts loadConcepts() {
      return load();
    }

    public boolean tryToGrab(boolean allDynamic) {
      if (sameSnippetID(programID, getDBProgramID()))
        return false;
      RemoteDB db = connectToDBOpt(programID);
      try {
        if (db != null) {
          loadGrab(db.fullgrab(), allDynamic);
          return true;
        }
        return false;
      } finally {
        _close(db);
      }
    }

    public Concepts load(String grab) {
      return loadGrab(grab, false);
    }

    public Concepts safeLoad(String grab) {
      return loadGrab(grab, true);
    }

    public Concepts loadGrab(String grab, boolean allDynamic) {
      clearConcepts();
      DynamicObject_loading.set(true);
      try {
        Map<Long, Concept> map = (Map) unstructure(grab, allDynamic, classFinder);
        concepts.putAll(map);
        assignConceptsToUs();
        for (long l : map.keySet()) idCounter = max(idCounter, l);
      } finally {
        DynamicObject_loading.set(null);
      }
      allChanged();
      return this;
    }

    public void assignConceptsToUs() {
      for (Pair<Long, Object> p : mapToPairs((Map<Long, Object>) (Map) concepts)) if (!(p.b instanceof Concept)) {
        print("DROPPING non-existant concept " + p.a + ": " + dynShortName(p.b));
        concepts.remove(p.a);
      }
      for (Concept c : values(concepts)) c._concepts = this;
      for (Concept c : values(concepts)) callOpt_noArgs(c, "_doneLoading2");
    }

    public String progID() {
      return programID == null ? getDBProgramID() : programID;
    }

    public Concept getConcept(String id) {
      return empty(id) ? null : getConcept(parseLong(id));
    }

    public Concept getConcept(long id) {
      return (Concept) concepts.get((long) id);
    }

    public Concept getConcept(RC ref) {
      return ref == null ? null : getConcept(ref.longID());
    }

    public boolean hasConcept(long id) {
      return concepts.containsKey((long) id);
    }

    public void deleteConcept(long id) {
      Concept c = getConcept(id);
      if (c == null)
        print("Concept " + id + " not found");
      else
        c.delete();
    }

    public void calcIdCounter() {
      long id_ = 0;
      for (long id : keys(concepts)) id_ = max(id_, id);
      idCounter = id_ + 1;
      saveLocally2(this, programID, "idCounter");
    }

    public void saveConceptsIfDirty() {
      saveConcepts();
    }

    public void save() {
      saveConcepts();
    }

    public void saveConcepts() {
      if (dontSave)
        return;
      initProgramID();
      saverLock.lock();
      savingConcepts = true;
      long start = now(), time;
      try {
        String s = null;
        long _changes = changes;
        if (_changes == changesWritten)
          return;
        final File f = getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
        lock.lock();
        long fullTime = now();
        try {
          saveLocally2(this, programID, "idCounter");
          if (useGZIP) {
            callRunnableWithWrapper(saveWrapper, new Runnable() {

              public void run() {
                try {
                  saveGZStructureToFile(f, cloneMap(concepts));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "saveGZStructureToFile(f, cloneMap(concepts));";
              }
            });
            getProgramFile(programID, "concepts.structure").delete();
          } else
            s = fullStructure();
        } finally {
          lock.unlock();
        }
        while (nempty(saveActions)) pcallF(popFirst(saveActions));
        changesWritten = _changes;
        if (!useGZIP) {
          time = now() - start;
          if (!quietSave)
            print("Saving " + toM(l(s)) + "M chars (" + time + " ms)");
          start = now();
          saveTextFile(f, javaTokWordWrap(s));
          getProgramFile(programID, "concepts.structure.gz").delete();
        }
        copyFile(f, getProgramFile(programID, "backups/concepts.structure" + (useGZIP ? ".gz" : "") + ".backup" + ymd() + "-" + formatInt(hours(), 2)));
        time = now() - start;
        if (!quietSave)
          print(programID + ": Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
        lastSaveWas = fullTime;
        lastSaveTook = now() - fullTime;
      } finally {
        savingConcepts = false;
        saverLock.unlock();
      }
    }

    public void _autoSaveConcepts() {
      if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
        long pivotTime = Math.round(lastSaveWas + lastSaveTook * 100.0 / maxAutoSavePercentage);
        if (now() < pivotTime) {
          return;
        }
      }
      try {
        saveConcepts();
      } catch (Throwable e) {
        print("Concept save failed, will try again: " + e);
      }
    }

    public String fullStructure() {
      return structure(cloneMap(concepts));
    }

    public void clearConcepts() {
      concepts.clear();
      allChanged();
    }

    public void allChanged() {
      synchronized (this) {
        ++changes;
        lastChange = sysNow();
      }
      if (vmBusSend)
        vmBus_send("conceptsChanged", this);
      pcallFAll(onAllChanged);
    }

    synchronized public void autoSaveConcepts() {
      if (autoSaver == null) {
        if (isTransient())
          throw fail("Can't persist transient database");
        autoSaver = doEvery_daemon(abs(autoSaveInterval), new Runnable() {

          public void run() {
            try {
              _autoSaveConcepts();
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "_autoSaveConcepts()";
          }
        });
      }
    }

    public void close() {
      cleanMeUp();
    }

    public void cleanMeUp() {
      boolean shouldSave = autoSaver != null;
      if (autoSaver != null) {
        autoSaver.cancel();
        autoSaver = null;
      }
      while (savingConcepts) sleepInCleanUp(10);
      if (shouldSave)
        saveConceptsIfDirty();
    }

    public Map<Long, String> getIDsAndNames() {
      Map<Long, String> map = new HashMap();
      Map<Long, Concept> cloned = cloneMap(concepts);
      for (long id : keys(cloned)) map.put(id, cloned.get(id).className);
      return map;
    }

    public void deleteConcepts(List l) {
      if (l != null)
        for (Object o : cloneList(l)) if (o instanceof Long) {
          Concept c = concepts.get(o);
          if (c != null)
            c.delete();
        } else if (o instanceof Concept)
          ((Concept) o).delete();
        else
          warn("Can't delete " + getClassName(o));
    }

    public <A extends Concept> A conceptOfType(Class<A> type) {
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (A) first(counter.allConcepts());
      return firstOfType(allConcepts(), type);
    }

    public <A extends Concept> List<A> conceptsOfType(Class<A> type) {
      IConceptCounter counter = conceptCounterForClass(type);
      if (counter != null)
        return (List<A>) cloneList(counter.allConcepts());
      return filterByType(allConcepts(), type);
    }

    public <A extends Concept> List<A> listConcepts(Class<A> type) {
      return conceptsOfType(type);
    }

    public <A extends Concept> List<A> list(Class<A> type) {
      return conceptsOfType(type);
    }

    public List<Concept> list(String type) {
      return conceptsOfType(type);
    }

    public List<Concept> conceptsOfType(String type) {
      return filterByDynamicType(allConcepts(), "main$" + type);
    }

    public boolean hasConceptOfType(Class<? extends Concept> type) {
      return hasType(allConcepts(), type);
    }

    public void persistConcepts() {
      loadConcepts();
      autoSaveConcepts();
    }

    public void conceptPersistence() {
      persistConcepts();
    }

    public Concepts persist() {
      persistConcepts();
      return this;
    }

    public void persist(Integer interval) {
      if (interval != null)
        autoSaveInterval = interval;
      persist();
    }

    public <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
      A a = conceptOfType(c);
      if (a == null) {
        r.run();
        a = conceptOfType(c);
        if (a == null)
          throw fail("Concept not made by " + r + ": " + shortClassName(c));
      }
      return a;
    }

    public void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
      for (Concept a : conceptsOfType(c1)) {
        Concept b = findBackRef(a, c2);
        if (b == null) {
          callF(func, a);
          b = findBackRef(a, c2);
          if (b == null)
            throw fail("Concept not made by " + func + ": " + shortClassName(c2));
        }
      }
    }

    public void forEvery(Class<? extends Concept> type, Object func) {
      for (Concept c : conceptsOfType(type)) callF(func, c);
    }

    public int deleteAll(Class<? extends Concept> type) {
      List<Concept> l = (List) conceptsOfType(type);
      for (Concept c : l) c.delete();
      return l(l);
    }

    public Collection<Concept> allConcepts() {
      synchronized (concepts) {
        return new ArrayList(values(concepts));
      }
    }

    public IConceptCounter conceptCounterForClass(Class<? extends Concept> c) {
      for (IFieldIndex idx : values(mapGet(fieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      for (IFieldIndex idx : values(mapGet(ciFieldIndices, c))) if (idx instanceof IConceptCounter)
        return ((IConceptCounter) idx);
      return null;
    }

    public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
      if (empty(params)) {
        IConceptCounter counter = conceptCounterForClass(c);
        if (counter != null)
          return counter.countConcepts();
        return l(list(c));
      }
      int n = 0;
      for (A x : list(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts(String c, Object... params) {
      if (empty(params))
        return l(list(c));
      int n = 0;
      for (Concept x : list(c)) if (checkConceptFields(x, params))
        ++n;
      return n;
    }

    public int countConcepts() {
      return l(concepts);
    }

    synchronized public void addConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        conceptIndices = new ArrayList();
      conceptIndices.add(index);
    }

    synchronized public void removeConceptIndex(IConceptIndex index) {
      if (conceptIndices == null)
        return;
      conceptIndices.remove(index);
      if (empty(conceptIndices))
        conceptIndices = null;
    }

    synchronized public void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (fieldIndices == null)
        fieldIndices = new HashMap();
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      if (map == null)
        fieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    synchronized public IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
      if (fieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = fieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    synchronized public void addCIFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
      if (ciFieldIndices == null)
        ciFieldIndices = new HashMap();
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      if (map == null)
        ciFieldIndices.put(c, map = new HashMap());
      map.put(field, index);
    }

    synchronized public IFieldIndex getCIFieldIndex(Class<? extends Concept> c, String field) {
      if (ciFieldIndices == null)
        return null;
      Map<String, IFieldIndex> map = ciFieldIndices.get(c);
      return map == null ? null : map.get(field);
    }

    public RC xnew(String name, Object... values) {
      return new RC(cnew(name, values));
    }

    public void xset(long id, String field, Object value) {
      xset(new RC(id), field, value);
    }

    public void xset(RC c, String field, Object value) {
      if (value instanceof RC)
        value = getConcept((RC) value);
      cset(getConcept(c), field, value);
    }

    public Object xget(long id, String field) {
      return xget(new RC(id), field);
    }

    public Object xget(RC c, String field) {
      return xgetPost(cget(getConcept(c), field));
    }

    public Object xgetPost(Object o) {
      o = deref(o);
      if (o instanceof Concept)
        return new RC((Concept) o);
      return o;
    }

    public void xdelete(long id) {
      xdelete(new RC(id));
    }

    public void xdelete(RC c) {
      getConcept(c).delete();
    }

    public void xdelete(List<RC> l) {
      for (RC c : l) xdelete(c);
    }

    public List<RC> xlist() {
      return map("toPassRef", allConcepts());
    }

    public List<RC> xlist(String className) {
      return map("toPassRef", conceptsOfType(className));
    }

    public boolean isTransient() {
      return eq(programID, "-");
    }

    public String xfullgrab() {
      if (noXFullGrab)
        throw fail("no xfullgrab (DB too large)");
      Lock __0 = lock();
      lock(__0);
      try {
        if (changes == changesWritten && !isTransient())
          return loadConceptsStructure(programID);
        return fullStructure();
      } finally {
        unlock(__0);
      }
    }

    public void xshutdown() {
      cleanKillVM();
    }

    public long xchangeCount() {
      return changes;
    }

    public int xcount() {
      return countConcepts();
    }

    public void register(Concept c) {
      if (c._concepts == this)
        return;
      if (c._concepts != null)
        throw fail("Can't re-register");
      c._concepts = this;
      c.id = internalID();
      c.created = now();
      concepts.put((long) c.id, c);
      for (Concept.Ref r : unnull(c.refs)) r.index();
      c.change();
    }

    public void registerKeepingID(Concept c) {
      if (c._concepts == this)
        return;
      if (c._concepts != null)
        throw fail("Can't re-register");
      c._concepts = this;
      concepts.put((long) c.id, c);
      c.change();
    }

    public void conceptChanged(Concept c) {
      allChanged();
      if (conceptIndices != null)
        for (IConceptIndex index : conceptIndices) index.update(c);
    }

    public boolean hasUnsavedData() {
      return changes != changesWritten || savingConcepts;
    }
  }

  static public class Concept extends DynamicObject {

    transient public Concepts _concepts;

    public long id;

    public long created, _modified;

    public List<Ref> refs;

    public List<Ref> backRefs;

    public Concept(String className) {
      super(className);
      _created();
    }

    public Concept() {
      if (!_loading()) {
        _created();
      }
    }

    public Concept(boolean unlisted) {
      if (!unlisted)
        _created();
    }

    public String toString() {
      return shortDynamicClassName(this) + " " + id;
    }

    static public boolean loading() {
      return _loading();
    }

    static public boolean _loading() {
      return dynamicObjectIsLoading();
    }

    public void _created() {
      if (!concepts_unlistedByDefault && !eq(concepts_unlisted.get(), true))
        db_mainConcepts().register(this);
    }

    public class Ref<A extends Concept> implements Derefable {

      public A value;

      public Ref() {
        if (!dynamicObjectIsLoading())
          refs = addDyn_quickSync(refs, this);
      }

      public Ref(A value) {
        this.value = value;
        refs = addDyn_quickSync(refs, this);
        index();
      }

      public Concept concept() {
        return Concept.this;
      }

      public A get() {
        return value;
      }

      public boolean has() {
        return value != null;
      }

      public boolean set(A a) {
        if (a == value)
          return false;
        unindex();
        value = a;
        index();
        return true;
      }

      public void set(Ref<A> ref) {
        set(ref.get());
      }

      public void clear() {
        set((A) null);
      }

      public boolean validRef() {
        return value != null && value._concepts == _concepts;
      }

      public void index() {
        if (validRef())
          value._addBackRef(this);
        change();
      }

      public Ref<A> unindex() {
        if (validRef())
          value._removeBackRef(this);
        return this;
      }

      public void change() {
        Concept.this.change();
      }

      public String toString() {
        return str(value);
      }
    }

    public class RefL<A extends Concept> extends AbstractList<A> {

      public List<Ref<A>> l = new ArrayList();

      public void clear() {
        while (!isEmpty()) removeLast(this);
      }

      public void replaceWithList(List<A> l) {
        clear();
        for (A a : unnull(l)) add(a);
      }

      public A set(int i, A o) {
        Ref<A> ref = syncGet(l, i);
        A prev = ref.get();
        ref.set(o);
        return prev;
      }

      public void add(int i, A o) {
        syncAdd(l, i, new Ref(o));
      }

      public A get(int i) {
        return syncGet(l, i).get();
      }

      public A remove(int i) {
        return syncRemove(l, i).get();
      }

      public int size() {
        return syncL(l);
      }

      public boolean contains(Object o) {
        if (o instanceof Concept)
          for (Ref<A> r : l) if (eq(r.get(), o))
            return true;
        return super.contains(o);
      }
    }

    public void delete() {
      for (Ref r : unnull(refs)) r.unindex();
      refs = null;
      for (Ref r : cloneList(backRefs)) r.set((Concept) null);
      backRefs = null;
      if (_concepts != null) {
        _concepts.concepts.remove((long) id);
        _concepts.allChanged();
        if (_concepts.conceptIndices != null)
          for (IConceptIndex index : _concepts.conceptIndices) index.remove(this);
        _concepts = null;
      }
      id = 0;
    }

    public BaseXRef export() {
      return new BaseXRef(_concepts.progID(), id);
    }

    public void change() {
      _modified = now();
      _change_withoutUpdatingModifiedField();
    }

    public void _change_withoutUpdatingModifiedField() {
      if (_concepts != null)
        _concepts.conceptChanged(this);
    }

    public void _change() {
      change();
    }

    public String _programID() {
      return _concepts == null ? getDBProgramID() : _concepts.progID();
    }

    public void _addBackRef(Concept.Ref ref) {
      backRefs = addDyn_quickSync(backRefs, ref);
    }

    public void _removeBackRef(Concept.Ref ref) {
      backRefs = removeDyn_quickSync(backRefs, ref);
    }

    public void _setField(String field, Object value) {
      cset(this, field, value);
    }

    public void _setFields(Object... values) {
      cset(this, values);
    }

    public Concepts concepts() {
      return _concepts;
    }

    public boolean isDeleted() {
      return id == 0;
    }
  }

  static public class RC {

    transient public Object owner;

    public String id;

    public RC() {
    }

    public RC(long id) {
      this.id = str(id);
    }

    public RC(Object owner, long id) {
      this.id = str(id);
      this.owner = owner;
    }

    public RC(Concept c) {
      this(c.id);
    }

    public long longID() {
      return parseLong(id);
    }

    public String toString() {
      return id;
    }

    transient public RemoteDB db;

    public String getString(String field) {
      return db.xS(this, field);
    }

    public Object get(String field) {
      return db.xget(this, field);
    }

    public void set(String field, Object value) {
      db.xset(this, field, value);
    }
  }

  static public class BaseXRef {

    public String programID;

    public long id;

    public BaseXRef() {
    }

    public BaseXRef(String programID, long id) {
      this.id = id;
      this.programID = programID;
    }

    public boolean equals(Object o) {
      if (!(o instanceof BaseXRef))
        return false;
      BaseXRef r = (BaseXRef) o;
      return eq(programID, r.programID) && eq(id, r.id);
    }

    public int hashCode() {
      return programID.hashCode() + (int) id;
    }
  }

  static public class XRef extends Concept {

    public BaseXRef ref;

    public XRef() {
    }

    public XRef(BaseXRef ref) {
      this.ref = ref;
      _doneLoading2();
    }

    public void _doneLoading2() {
      getIndex().put(ref, this);
    }

    public HashMap<BaseXRef, XRef> getIndex() {
      return getXRefIndex(_concepts);
    }
  }

  static synchronized public HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
    HashMap cache = (HashMap) concepts.perClassData().get(XRef.class);
    if (cache == null)
      concepts.perClassData.put(XRef.class, cache = new HashMap());
    return cache;
  }

  static public XRef lookupOrCreateXRef(BaseXRef ref) {
    XRef xref = getXRefIndex(db_mainConcepts()).get(ref);
    if (xref == null)
      xref = new XRef(ref);
    return xref;
  }

  static public void cleanMeUp_concepts() {
    if (db_mainConcepts() != null)
      db_mainConcepts().cleanMeUp();
  }

  static public void loadAndAutoSaveConcepts() {
    db_mainConcepts().persist();
  }

  static public void loadAndAutoSaveConcepts(int interval) {
    db_mainConcepts().persist(interval);
  }

  static public RC toPassRef(Concept c) {
    return new RC(c);
  }

  static public void concepts_setUnlistedByDefault(boolean b) {
    concepts_unlistedByDefault = b;
  }

  static public interface IF0<A> {

    public A get();
  }

  static public class DefaultValueConverterForField implements ValueConverterForField {

    public OrError<Object> convertValue(Object object, Field field, Object value) {
      Class actualType = field.getType();
      Class type = primitiveToBoxedTypeOpt(actualType);
      if (isInstance(type, value))
        return new OrError(value);
      if (type == Integer.class && !(value instanceof Integer))
        return new OrError(toInt(trimIfString(value)));
      if (type == Double.class && !(value instanceof Double))
        return new OrError(toDouble(trimIfString(value)));
      if (type == Boolean.class && value instanceof String)
        if (actualType == Boolean.class && eq(value, ""))
          return new OrError(null);
        else
          return new OrError(eqicOneOf((String) value, "1", "true", "yes"));
      if (type == GlobalID.class && value instanceof String)
        return new OrError(new GlobalID((String) value));
      return new OrError(value);
    }
  }

  static abstract public class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {

    public void close() throws Exception {
    }
  }

  static public interface IFieldsToList {

    public Object[] _fieldsToList();
  }

  static public interface IF2<A, B, C> {

    public C get(A a, B b);
  }

  static public interface Producer<A> {

    public A next();
  }

  static public interface IF1<A, B> {

    public B get(A a);
  }

  static public interface IVF1<A> {

    public void get(A a);
  }

  static public interface IVF2<A, B> {

    public void get(A a, B b);
  }

  static public interface IVar<A> extends IF0<A> {

    public void set(A a);

    public A get();

    default public boolean has() {
      return get() != null;
    }

    default public void clear() {
      set(null);
    }
  }

  final static public class _MethodCache {

    final public Class c;

    final public HashMap<String, List<Method>> cache = new HashMap();

    public _MethodCache(Class c) {
      this.c = c;
      _init();
    }

    public void _init() {
      Class _c = c;
      while (_c != null) {
        for (Method m : _c.getDeclaredMethods()) if (!isAbstract(m) && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));
        _c = _c.getSuperclass();
      }
      for (Class intf : allInterfacesImplementedBy(c)) for (Method m : intf.getDeclaredMethods()) if (m.isDefault() && !reflection_isForbiddenMethod(m))
        multiMapPut(cache, m.getName(), makeAccessible(m));
    }

    public Method findMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public Method findStaticMethod(String method, Object[] args) {
      try {
        List<Method> m = cache.get(method);
        if (m == null)
          return null;
        int n = m.size();
        for (int i = 0; i < n; i++) {
          Method me = m.get(i);
          if (isStaticMethod(me) && call_checkArgs(me, args, false))
            return me;
        }
        return null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }
  }

  static public class Matches {

    public String[] m;

    public Matches() {
    }

    public Matches(String... m) {
      this.m = m;
    }

    public String get(int i) {
      return i < m.length ? m[i] : null;
    }

    public String unq(int i) {
      return unquote(get(i));
    }

    public String tlc(int i) {
      return unq(i).toLowerCase();
    }

    public boolean bool(int i) {
      return "true".equals(unq(i));
    }

    public String rest() {
      return m[m.length - 1];
    }

    public int psi(int i) {
      return Integer.parseInt(unq(i));
    }

    public String toString() {
      return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")";
    }

    public int hashCode() {
      return _hashCode(toList(m));
    }

    public boolean equals(Object o) {
      return o instanceof Matches && arraysEqual(m, ((Matches) o).m);
    }
  }

  static public class HCRUD_Concepts<A extends Concept> extends HCRUD_Data {

    public Concepts cc = db_mainConcepts();

    public Class<A> cClass;

    public List<IVF1<A>> onCreateOrUpdate = new ArrayList();

    public Map<String, Object> filters;

    public ValueConverterForField valueConverter;

    public boolean referencesBlockDeletion = false;

    public boolean trimAllSingleLineValues = false;

    public HCRUD_Concepts(Class<A> cClass) {
      this.cClass = cClass;
    }

    transient public IF0<String> itemName;

    public String itemName() {
      return itemName != null ? itemName.get() : itemName_base();
    }

    final public String itemName_fallback(IF0<String> _f) {
      return _f != null ? _f.get() : itemName_base();
    }

    public String itemName_base() {
      return humanizeShortName(cClass);
    }

    public List<A> itemsForListing() {
      return defaultSort(asList(listConcepts()));
    }

    @Override
    public List<Map<String, Object>> list() {
      return lambdaMap(__73 -> itemToMapForList(__73), itemsForListing());
    }

    @Override
    public List<Map<String, Object>> list(IntRange range) {
      return lambdaMap(__74 -> itemToMapForList(__74), subListOrFull(itemsForListing(), range));
    }

    public Collection<A> listConcepts() {
      return conceptsWhere(cc, cClass, mapToParams(filters));
    }

    public List<A> defaultSort(List<A> l) {
      return l;
    }

    public Map<String, Object> emptyObject() {
      A c = unlisted(cClass);
      print("fieldOrder", getFieldOrder(c));
      return printStruct("emptyObject", itemToMap(c));
    }

    public Map<String, Object> itemToMap(A c) {
      if (c == null)
        return null;
      return putKeysFirst(getFieldOrder(c), conceptToMap_gen_withNullValues(c));
    }

    public Map<String, Object> itemToMapForList(A c) {
      if (c == null)
        return null;
      Map<String, Object> map = itemToMap(c);
      massageItemMapForList(c, map);
      return map;
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForList;

    public void massageItemMapForList(A c, Map<String, Object> map) {
      if (massageItemMapForList != null)
        massageItemMapForList.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    final public void massageItemMapForList_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForList_base(c, map);
    }

    public void massageItemMapForList_base(A c, Map<String, Object> map) {
    }

    transient public IVF2<A, Map<String, Object>> massageItemMapForUpdate;

    public void massageItemMapForUpdate(A c, Map<String, Object> map) {
      if (massageItemMapForUpdate != null)
        massageItemMapForUpdate.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    final public void massageItemMapForUpdate_fallback(IVF2<A, Map<String, Object>> _f, A c, Map<String, Object> map) {
      if (_f != null)
        _f.get(c, map);
      else
        massageItemMapForUpdate_base(c, map);
    }

    public void massageItemMapForUpdate_base(A c, Map<String, Object> map) {
      for (Field f : nonStaticNonTransientFieldObjectsOfType(Concept.RefL.class, cClass)) {
        TreeMap<Integer, Object> values = new TreeMap();
        Matches m = new Matches();
        {
          final Map<String, Object> __0 = cloneMap(map);
          for (String key : keys(__0)) {
            Object value = __0.get(key);
            if (startsWith(key, f.getName() + "_", m) && isInteger(m.rest())) {
              long conceptID = parseFirstLong((String) value);
              Concept concept = getConcept(cc, conceptID);
              printVars_str("RefL magic", "key", key, "conceptID", conceptID, "concept", concept);
              mapPut(values, parseInt(m.rest()), concept);
              map.remove(key);
            }
            map.put(f.getName(), valuesAsList(values));
          }
        }
      }
      for (Field f : nonStaticNonTransientFieldObjectsOfType(Concept.Ref.class, cClass)) {
        Object value = map.get(f.getName());
        if (value instanceof String) {
          long conceptID = parseFirstLong(((String) value));
          Concept concept = getConcept(cc, conceptID);
          map.put(f.getName(), concept);
        }
      }
      if (trimAllSingleLineValues)
        for (Map.Entry<String, Object> e : map.entrySet()) {
          String val = optCastString(e.getValue());
          if (val != null && isSingleLine(val) && isUntrimmed(val))
            e.setValue(trim(val));
        }
    }

    public Map<String, Object> getObject(Object id) {
      return itemToMap(conceptForID(id));
    }

    public Object createObject(Map<String, String> map) {
      A c = cnew(cc, cClass);
      setValues(c, map);
      cset(c, mapToParams(filters));
      pcallFAll(onCreateOrUpdate, c);
      return c.id;
    }

    public void setValues(A c, Map<String, String> map) {
      Map<String, Object> map2 = (Map) cloneMap(map);
      massageItemMapForUpdate(c, map2);
      if (valueConverter == null)
        cSmartSet(c, mapToParams(map2));
      else
        cSmartSet_withConverter(valueConverter, c, mapToParams(map2));
    }

    public A conceptForID(Object id) {
      return getConcept(cc, cClass, toLong(id));
    }

    public String updateObject(Object id, Map<String, String> map) {
      A c = conceptForID(id);
      if (c == null)
        return "Object " + id + " not found";
      {
        String __2 = checkFilters(c);
        if (!empty(__2))
          return __2;
      }
      setValues(c, map);
      pcallFAll(onCreateOrUpdate, c);
      return "Object " + id + " updated";
    }

    public String deleteObject(Object id) {
      A c = conceptForID(id);
      if (c == null)
        return "Object " + id + " not found";
      {
        String __3 = checkFilters(c);
        if (!empty(__3))
          return __3;
      }
      deleteConcept(c);
      return "Object " + id + " deleted";
    }

    public String checkFilters(A c) {
      return checkConceptFields(c, mapToParams(filters)) ? "" : "Object " + c.id + " not in view";
    }

    public HCRUD_Concepts<A> addFilters(Map<String, Object> map) {
      {
        final Map<String, Object> __4 = unnull(map);
        for (String field : keys(__4)) {
          Object value = __4.get(field);
          addFilter(field, value);
        }
      }
      return this;
    }

    public HCRUD_Concepts<A> addFilter(String field, Object value) {
      filters = orderedMapPutOrCreate(filters, field, value);
      return this;
    }

    public Renderer getRenderer(String field) {
      Class type = fieldType(cClass, field);
      if (eq(type, boolean.class))
        return new CheckBox();
      if (eq(type, Boolean.class))
        return new ComboBox(ll("", "yes", "no"), b -> trueFalseNull((Boolean) b, "yes", "no", ""));
      if (eq(type, Concept.Ref.class)) {
        Class<? extends Concept> c = getTypeArgumentAsClass(genericFieldType(cClass, field));
        return makeConceptsComboBox(comboBoxItemsForConceptClass(c));
      }
      if (eq(type, Concept.RefL.class)) {
        Class<? extends Concept> c = getTypeArgumentAsClass(genericFieldType(cClass, field));
        List<String> items = comboBoxItemsForConceptClass(c);
        return new FlexibleLengthList(makeConceptsComboBox(items));
      }
      return super.getRenderer(field);
    }

    public ComboBox makeConceptsComboBox(List<String> entries) {
      ComboBox cb = new ComboBox(entries);
      cb.valueToEntry = value -> {
        value = deref(value);
        print("ComboBox: value type=" + _getClass(value));
        if (value instanceof Concept) {
          long id = conceptID(((Concept) value));
          String entry = firstWhereFirstLongIs(entries, id);
          print("combobox selected: " + id + " / " + entry);
          return entry;
        }
        return null;
      };
      return cb;
    }

    public List<String> comboBoxItemsForConceptClass(Class<? extends Concept> c) {
      return itemPlus("", map(cc.list(c), val -> shorten(val.id + ": " + val)));
    }

    public boolean objectCanBeDeleted(Object id) {
      return !referencesBlockDeletion || !hasBackRefs(conceptForID(id));
    }
  }

  static abstract public class LiveValue<A> {

    abstract public Class<A> getType();

    abstract public A get();

    abstract public void onChange(Runnable l);

    abstract public void removeOnChangeListener(Runnable l);

    public void onChangeAndNow(Runnable l) {
      onChange(l);
      callF(l);
    }
  }

  static public class Q implements AutoCloseable {

    public String name = "Unnamed Queue";

    public List<Runnable> q = synchroLinkedList();

    public ReliableSingleThread rst = new ReliableSingleThread(new Runnable() {

      public void run() {
        try {
          _run();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "_run()";
      }
    });

    volatile public boolean retired = false;

    public Q() {
    }

    public Q(String name) {
      this.name = name;
    }

    public void add(Runnable r) {
      q.add(r);
      _trigger();
    }

    public void addInFront(Runnable r) {
      q.add(0, r);
      _trigger();
    }

    public void _trigger() {
      rst.name = name;
      rst.go();
    }

    public void add(Object r) {
      add(toRunnable(r));
    }

    public void _run() {
      Runnable r;
      while (licensed() && !retired && (r = syncPopFirst(q)) != null) {
        try {
          r.run();
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    }

    public void close() {
      retired = true;
    }

    public void done() {
    }

    public boolean isEmpty() {
      return q.isEmpty();
    }

    public int size() {
      return q.size();
    }

    public Object mutex() {
      return q;
    }

    public List<Runnable> snapshot() {
      return cloneList(q);
    }
  }

  final static public class LongRange {

    public long start, end;

    public LongRange() {
    }

    public LongRange(long start, long end) {
      this.end = end;
      this.start = start;
    }

    public boolean equals(Object o) {
      if (o instanceof LongRange)
        return start == ((LongRange) o).start && end == ((LongRange) o).end;
      return false;
    }

    public int hashCode() {
      return boostHashCombine(hashOfLong(start), hashOfLong(end));
    }

    public long length() {
      return end - start;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  static public class Lowest<A> {

    public A best;

    public double score;

    transient public Object onChange;

    synchronized public boolean isNewBest(double score) {
      return best == null || score < this.score;
    }

    synchronized public double bestScore() {
      return best == null ? Double.NaN : score;
    }

    public double score() {
      return bestScore();
    }

    synchronized public float floatScore() {
      return best == null ? Float.NaN : (float) score;
    }

    synchronized public float floatScoreOr(float defaultValue) {
      return best == null ? defaultValue : (float) score;
    }

    public boolean put(A a, double score) {
      boolean change = false;
      synchronized (this) {
        if (a != null && isNewBest(score)) {
          best = a;
          this.score = score;
          change = true;
        }
      }
      if (change)
        pcallF(onChange);
      return change;
    }

    synchronized public void clear() {
      best = null;
      score = 0;
    }

    synchronized public A get() {
      return best;
    }

    synchronized public boolean has() {
      return best != null;
    }

    synchronized public Pair<A, Double> pair() {
      return best == null ? null : new Pair(best, bestScore());
    }

    public String toString() {
      return "Score " + formatDouble_significant2(score, 4) + ": " + best;
    }
  }

  static public interface IResourceLoader {

    public String loadSnippet(String snippetID);

    public String getTranspiled(String snippetID);

    public int getSnippetType(String snippetID);

    public String getSnippetTitle(String snippetID);

    public File loadLibrary(String snippetID);

    public File pathToJavaXJar();

    public File getSnippetJar(String snippetID, String transpiledSrc);
  }

  static public class proxy_InvocationHandler implements InvocationHandler {

    public Object target;

    public proxy_InvocationHandler() {
    }

    public proxy_InvocationHandler(Object target) {
      this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
      return call(target, method.getName(), unnull(args));
    }
  }

  static public class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  static abstract public class DialogIO implements AutoCloseable {

    public String line;

    public boolean eos, loud, noClose;

    public Lock lock = lock();

    abstract public String readLineImpl();

    abstract public boolean isStillConnected();

    abstract public void sendLine(String line);

    abstract public boolean isLocalConnection();

    abstract public Socket getSocket();

    public int getPort() {
      Socket s = getSocket();
      return s == null ? 0 : s.getPort();
    }

    public boolean helloRead = false;

    public int shortenOutputTo = 500;

    public String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }

    public boolean waitForLine() {
      try {
        ping();
        if (line != null)
          return true;
        line = readLineImpl();
        if (line == null)
          eos = true;
        return line != null;
      } catch (Exception __e) {
        throw rethrow(__e);
      }
    }

    public String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }

    public String ask(String s, Object... args) {
      if (loud)
        return askLoudly(s, args);
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      sendLine(s);
      return readLine();
    }

    public String askLoudly(String s, Object... args) {
      if (!helloRead)
        readLine();
      if (args.length != 0)
        s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }

    public void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }

  static abstract public class DialogHandler {

    abstract public void run(DialogIO io);
  }

  static public boolean SimpleCRUD_searcher = true;

  static public class SimpleCRUD<A extends Concept> {

    public Class<A> cc;

    public JTable table;

    public JPanel buttons, panel;

    public Object renderer;

    public Object sorter;

    public String hID = "ID";

    public Set<String> excludeFieldsFromEditing;

    public String modifiedField;

    public TableSearcher tableSearcher;

    public Set<String> multiLineFields;

    public Concepts concepts;

    public Set<String> dontDuplicateFields;

    public boolean latestFirst = false;

    public int formFixer = 12;

    public SimpleCRUD(Class<A> cc) {
      this(db_mainConcepts(), cc);
    }

    public SimpleCRUD(Concepts concepts, Class<A> cc) {
      this.cc = cc;
      this.concepts = concepts;
    }

    public SimpleCRUD<A> show(String frameTitle) {
      make();
      showFrame(frameTitle, panel);
      return this;
    }

    public SimpleCRUD<A> show() {
      return show(plural(shortClassName(cc)));
    }

    public SimpleCRUD<A> showMaximized() {
      show();
      maximizeFrame(panel);
      return this;
    }

    public JPanel makePanel() {
      return make();
    }

    public JPanel make() {
      db();
      framesBot();
      return make_dontStartBots();
    }

    public JPanel make_dontStartBots() {
      AutoCloseable __1 = tempSetTL(showConceptsTable_concepts, concepts);
      try {
        AutoCloseable __2 = tempSetTL(showConceptsTable_latestFirst, latestFirst);
        try {
          AutoCloseable __3 = tempSetTL(showConceptsTable_sorter, sorter);
          try {
            table = makeConceptsTable(cc, wrapRenderer(renderer));
            {
              swing(new Runnable() {

                public void run() {
                  try {
                    buttons = jRightAlignedLine(jbutton("Add...", new Runnable() {

                      public void run() {
                        try {
                          newConcept();
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String toString() {
                        return "newConcept()";
                      }
                    }), tableDependButton(table, jbutton("Edit", new Runnable() {

                      public void run() {
                        try {
                          editConcept(selectedConcept());
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String toString() {
                        return "editConcept(selectedConcept())";
                      }
                    })), tableDependButton(table, jbutton("Delete", new Runnable() {

                      public void run() {
                        try {
                          final List<A> l = selectedConcepts();
                          withDBLock(concepts, new Runnable() {

                            public void run() {
                              try {
                                for (A c : l) c.delete();
                              } catch (Exception __e) {
                                throw rethrow(__e);
                              }
                            }

                            public String toString() {
                              return "for (A c : l) c.delete()";
                            }
                          });
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String toString() {
                        return "final List<A> l = selectedConcepts();\r\n          withDBLock(concepts, r { for...";
                      }
                    })), tableDependButton(table, jbutton("Duplicate...", new Runnable() {

                      public void run() {
                        try {
                          duplicateConcept(selectedConcept());
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String toString() {
                        return "duplicateConcept(selectedConcept())";
                      }
                    })));
                    if (SimpleCRUD_searcher) {
                      tableSearcher = tableWithSearcher2(table, "withMargin", true);
                      panel = centerAndSouthWithMargin(tableSearcher.panel, withBottomMargin(buttons));
                    } else
                      panel = centerAndSouthWithMargin(table, withBottomMargin(buttons));
                    Object fEdit = new VF1<Integer>() {

                      public void get(Integer row) {
                        try {
                          editConcept((A) concepts.getConcept(toLong(getTableCell(table, row, 0))));
                        } catch (Exception __e) {
                          throw rethrow(__e);
                        }
                      }

                      public String toString() {
                        return "editConcept((A) concepts.getConcept(toLong(getTableCell(table, row, 0))))";
                      }
                    };
                    tablePopupMenuItem(table, "Edit...", fEdit);
                    onDoubleClick(table, fEdit);
                  } catch (Exception __e) {
                    throw rethrow(__e);
                  }
                }

                public String toString() {
                  return "buttons = jRightAlignedLine(\r\n        jbutton(\"Add...\", r { newConcept() }),\r...";
                }
              });
            }
            return panel;
          } finally {
            _close(__3);
          }
        } finally {
          _close(__2);
        }
      } finally {
        _close(__1);
      }
    }

    public Object wrapRenderer(final Object renderer) {
      return renderer == null ? null : new F1<A, Object>() {

        public Object get(A a) {
          try {
            return putAll(litorderedmap(hID, str(a.id)), (Map) callF(renderer, a));
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "putAll(litorderedmap(hID, str(a.id)), (Map) callF(renderer, a))";
        }
      };
    }

    public void newConcept() {
      duplicateConcept(null);
    }

    public void duplicateConcept(A oldConcept) {
      final A c = unlisted(cc);
      ccopyFieldsExcept(oldConcept, c, dontDuplicateFields);
      final Map<String, JComponent> map = makeComponents(c);
      Runnable r = new Runnable() {

        public void run() {
          try {
            concepts.register(c);
            saveData(c, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "concepts.register(c);\r\n      saveData(c, map);";
        }
      };
      AutoCloseable __4 = tempSetMCOpt("formLayouter1_fixer2", formFixer);
      try {
        showFormTitled2("New " + shortClassName(cc), arrayPlus(mapToObjectArray(map), r));
      } finally {
        _close(__4);
      }
    }

    public void editConcept(final A c) {
      if (c == null)
        return;
      final Map<String, JComponent> map = makeComponents(c);
      Runnable r = new Runnable() {

        public void run() {
          try {
            saveData(c, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "saveData(c, map)";
        }
      };
      AutoCloseable __5 = tempSetMCOpt("formLayouter1_fixer2", formFixer);
      try {
        showFormTitled2("Edit " + shortClassName(cc) + " #" + c.id, arrayPlus(mapToObjectArray(map), r));
      } finally {
        _close(__5);
      }
    }

    public A selectedConcept() {
      return (A) concepts.getConcept(toLong(selectedTableCell(table, 0)));
    }

    public A selected() {
      return selectedConcept();
    }

    public int indexOfConcept(final A c) {
      if (c == null)
        return -1;
      return swing(new F0<Integer>() {

        public Integer get() {
          try {
            int n = tableRowCount(table);
            for (int row = 0; row < n; row++) if (toLong(getTableCell(table, row, 0)) == c.id)
              return row;
            return -1;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "int n = tableRowCount(table);\r\n      for row to n:\r\n        if (toLong(getTab...";
        }
      });
    }

    public List<A> selectedConcepts() {
      int[] rows = table.getSelectedRows();
      List<A> l = new ArrayList();
      for (int row : rows) l.add((A) concepts.getConcept(toLong(getTableCell(table, row, 0))));
      return l;
    }

    public Map<String, JComponent> makeComponents(A c) {
      Map<String, JComponent> map = litorderedmap();
      makeComponents(c, map);
      return map;
    }

    public JComponent fieldComponent(A c, String field) {
      Class type = getFieldType(cc, field);
      Object value = getOpt(c, field);
      if (type == boolean.class)
        return jCenteredCheckBox(isTrue(value));
      else if (contains(multiLineFields, field))
        return typeWriterTextArea((String) value);
      else if (isSubtype(type, Concept.class))
        return jcomboboxFromConcepts_str(concepts, type, (Concept) value);
      else if (type == SecretValue.class)
        return jpassword(strOrEmpty(getVar(((SecretValue) value))));
      else
        try {
          return autoComboBox(structureOrText_crud(value), new TreeSet<String>(map("structureOrText_crud", collect(list(concepts, cc), field))));
        } catch (Throwable e) {
          printException(e);
          return jTextField(structureOrText_crud(value));
        }
    }

    public void saveComponent(A c, String field, JComponent comp) {
      comp = unwrap(comp);
      Class type = fieldType(c, field);
      if (type == SecretValue.class) {
        String text = getTextTrim((JPasswordField) comp);
        cset(c, field, empty(text) ? null : new SecretValue(text));
      } else if (comp instanceof JTextComponent)
        cset(c, field, convertToField(trimIf(!(comp instanceof JTextArea), getText((JTextComponent) comp)), cc, field));
      else if (comp instanceof JComboBox) {
        String text = getTextTrim(((JComboBox) comp));
        if (isSubtype(type, Concept.class))
          cset(c, field, getConcept(concepts, parseFirstLong(text)));
        else
          cset(c, field, convertToField(text, cc, field));
      } else if (comp instanceof JCheckBox)
        cset(c, field, isChecked((JCheckBox) comp));
    }

    public List<String> fields() {
      if (excludeFieldsFromEditing != null && modifiedField != null)
        excludeFieldsFromEditing.add(modifiedField);
      return listWithoutSet(filter(conceptFieldsInOrder(cc), new F1<String, Boolean>() {

        public Boolean get(String field) {
          try {
            return fieldType(cc, field) != Concept.Ref.class;
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "fieldType(cc, field) != Concept.Ref.class";
        }
      }), excludeFieldsFromEditing);
    }

    public void excludeFieldsFromEditing(String... fields) {
      excludeFieldsFromEditing = setPlus(excludeFieldsFromEditing, fields);
    }

    public void makeComponents(A c, Map<String, JComponent> map) {
      for (String field : fields()) map.put(field, fieldComponent(c, field));
    }

    public void saveData(A c, Map<String, JComponent> components) {
      for (String field : keys(components)) saveComponent(c, field, components.get(field));
      if (modifiedField != null)
        cset(c, modifiedField, now());
    }
  }

  static public class IntRange {

    public int start, end;

    public IntRange() {
    }

    public IntRange(int start, int end) {
      this.end = end;
      this.start = start;
    }

    public IntRange(IntRange r) {
      start = r.start;
      end = r.end;
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    final public int length() {
      return end - start;
    }

    final public boolean empty() {
      return start >= end;
    }

    final public boolean isEmpty() {
      return start >= end;
    }

    static public String _fieldOrder = "start end";

    public String toString() {
      return "[" + start + ";" + end + "]";
    }
  }

  static public class UniqueString implements CharSequence {

    public String s;

    public UniqueString() {
    }

    public UniqueString(String s, boolean dummy) {
      this.s = s;
    }

    public String toString() {
      return s;
    }

    public char charAt(int index) {
      return s.charAt(index);
    }

    public int length() {
      return s.length();
    }

    public CharSequence subSequence(int start, int end) {
      return uniqueString(s.substring(start, end));
    }
  }

  static public class MRUCache<A, B> extends LinkedHashMap<A, B> {

    public int maxSize = 10;

    public MRUCache() {
    }

    public MRUCache(int maxSize) {
      this.maxSize = maxSize;
    }

    public boolean removeEldestEntry(Map.Entry eldest) {
      return size() > maxSize;
    }

    public Object _serialize() {
      return ll(maxSize, cloneLinkedHashMap(this));
    }

    static public MRUCache _deserialize(List l) {
      MRUCache m = new MRUCache();
      m.maxSize = (int) first(l);
      m.putAll((LinkedHashMap) second(l));
      return m;
    }
  }

  static public class TransferableImage implements Transferable {

    public Image i;

    public TransferableImage(Image i) {
      this.i = i;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
      if (flavor.equals(DataFlavor.imageFlavor) && i != null) {
        return i;
      } else {
        throw new UnsupportedFlavorException(flavor);
      }
    }

    public DataFlavor[] getTransferDataFlavors() {
      DataFlavor[] flavors = new DataFlavor[1];
      flavors[0] = DataFlavor.imageFlavor;
      return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
      DataFlavor[] flavors = getTransferDataFlavors();
      for (int i = 0; i < flavors.length; i++) {
        if (flavor.equals(flavors[i])) {
          return true;
        }
      }
      return false;
    }
  }

  static public class PersistableThrowable {

    public String className;

    public String msg;

    public String stacktrace;

    public PersistableThrowable() {
    }

    public PersistableThrowable(Throwable e) {
      if (e == null)
        className = "Crazy Null Error";
      else {
        className = getClassName(e).replace('/', '.');
        msg = e.getMessage();
        stacktrace = getStackTrace_noRecord(e);
      }
    }

    public String toString() {
      return nempty(msg) ? className + ": " + msg : className;
    }
  }

  static public class RGBImage implements MakesBufferedImage {

    transient public BufferedImage bufferedImage;

    public File file;

    public int width, height;

    public int[] pixels;

    public RGBImage() {
    }

    public RGBImage(BufferedImage image) {
      this(image, null);
    }

    public RGBImage(BufferedImage image, File file) {
      this.file = file;
      bufferedImage = image;
      width = image.getWidth();
      height = image.getHeight();
      pixels = new int[width * height];
      PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
      try {
        if (!pixelGrabber.grabPixels())
          throw new RuntimeException("Could not grab pixels");
        cleanPixels();
      } catch (InterruptedException e) {
        throw new RuntimeException(e);
      }
    }

    public RGBImage(String file) throws IOException {
      this(new File(file));
    }

    public RGBImage(Dimension size, Color color) {
      this(size.width, size.height, color);
    }

    public RGBImage(Dimension size, RGB color) {
      this(size.width, size.height, color);
    }

    final public void cleanPixels() {
      for (int i = 0; i < pixels.length; i++) pixels[i] &= 0xFFFFFF;
    }

    public RGBImage(int width, int height, int[] pixels) {
      this.width = width;
      this.height = height;
      this.pixels = pixels;
    }

    public RGBImage(int w, int h, RGB[] pixels) {
      this.width = w;
      this.height = h;
      this.pixels = asInts(pixels);
    }

    public static int[] asInts(RGB[] pixels) {
      int[] ints = new int[pixels.length];
      for (int i = 0; i < pixels.length; i++) ints[i] = pixels[i] == null ? 0 : pixels[i].getColor().getRGB();
      return ints;
    }

    public RGBImage(int w, int h) {
      this(w, h, Color.black);
    }

    public RGBImage(int w, int h, RGB rgb) {
      this.width = w;
      this.height = h;
      this.pixels = new int[w * h];
      int col = rgb.asInt();
      if (col != 0)
        for (int i = 0; i < pixels.length; i++) pixels[i] = col;
    }

    public RGBImage(RGBImage image) {
      this(image.width, image.height, copyPixels(image.pixels));
    }

    public RGBImage(int width, int height, Color color) {
      this(width, height, new RGB(color));
    }

    public RGBImage(File file) throws IOException {
      this(javax.imageio.ImageIO.read(file));
    }

    public RGBImage(MakesBufferedImage img) {
      this(toBufferedImage(img));
    }

    static public int[] copyPixels(int[] pixels) {
      int[] copy = new int[pixels.length];
      System.arraycopy(pixels, 0, copy, 0, pixels.length);
      return copy;
    }

    public int getIntPixel(int x, int y) {
      if (inRange(x, y))
        return pixels[y * width + x];
      else
        return 0xFFFFFF;
    }

    public static RGB asRGB(int packed) {
      int r = (packed >> 16) & 0xFF;
      int g = (packed >> 8) & 0xFF;
      int b = packed & 0xFF;
      return new RGB(r / 255f, g / 255f, b / 255f);
    }

    public RGB getRGB(int x, int y) {
      if (inRange(x, y))
        return asRGB(pixels[y * width + x]);
      else
        return new RGB(0xFFFFFF);
    }

    public RGB getPixel(int x, int y) {
      return getRGB(x, y);
    }

    public RGB getPixel(Pt p) {
      return getPixel(p.x, p.y);
    }

    public int getWidth() {
      return width;
    }

    public int getHeight() {
      return height;
    }

    public int w() {
      return width;
    }

    public int h() {
      return height;
    }

    public BufferedImage getBufferedImage() {
      if (bufferedImage == null) {
        bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        for (int y = 0; y < height; y++) for (int x = 0; x < width; x++) bufferedImage.setRGB(x, y, pixels[y * width + x]);
      }
      return bufferedImage;
    }

    public RGBImage clip(Rect r) {
      return r == null ? null : clip(r.getRectangle());
    }

    public RGBImage clip(Rectangle r) {
      r = fixClipRect(r);
      if (r.x == 0 && r.y == 0 && r.width == width && r.height == height)
        return this;
      int[] newPixels;
      try {
        newPixels = new int[r.width * r.height];
      } catch (RuntimeException e) {
        System.out.println(r);
        throw e;
      }
      for (int y = 0; y < r.height; y++) {
        System.arraycopy(pixels, (y + r.y) * width + r.x, newPixels, y * r.width, r.width);
      }
      return new RGBImage(r.width, r.height, newPixels);
    }

    final public Rectangle fixClipRect(Rectangle r) {
      r = r.intersection(new Rectangle(0, 0, width, height));
      if (r.isEmpty())
        r = new Rectangle(r.x, r.y, 0, 0);
      return r;
    }

    public File getFile() {
      return file;
    }

    public static RGBImage load(String fileName) {
      return load(new File(fileName));
    }

    public static RGBImage load(File file) {
      try {
        BufferedImage bufferedImage = javax.imageio.ImageIO.read(file);
        return new RGBImage(bufferedImage);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    public int getInt(int x, int y) {
      return pixels[y * width + x];
    }

    public void save(File file) throws IOException {
      String name = file.getName().toLowerCase();
      String type;
      if (name.endsWith(".png"))
        type = "png";
      else if (name.endsWith(".jpg") || name.endsWith(".jpeg"))
        type = "jpeg";
      else
        throw new IOException("Unknown image extension: " + name);
      javax.imageio.ImageIO.write(getBufferedImage(), type, file);
    }

    public static RGBImage dummyImage() {
      return new RGBImage(1, 1, new int[] { 0xFFFFFF });
    }

    public int[] getPixels() {
      return pixels;
    }

    public void setPixel(int x, int y, int r, int g, int b) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = (limitToUByte(r) << 16) | (limitToUByte(g) << 8) | limitToUByte(b);
    }

    public void setPixel(int x, int y, RGB rgb) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = rgb.asInt();
    }

    public void setPixel(int x, int y, Color color) {
      setPixel(x, y, new RGB(color));
    }

    public void setInt(int x, int y, int rgb) {
      setPixel(x, y, rgb);
    }

    public void setPixel(int x, int y, int rgb) {
      if (x >= 0 && y >= 0 && x < width && y < height)
        pixels[y * width + x] = rgb;
    }

    public void setPixel(Pt p, RGB rgb) {
      setPixel(p.x, p.y, rgb);
    }

    public void setPixel(Pt p, Color color) {
      setPixel(p.x, p.y, color);
    }

    public RGBImage copy() {
      return new RGBImage(this);
    }

    public boolean inRange(int x, int y) {
      return x >= 0 && y >= 0 && x < width && y < height;
    }

    public Dimension getSize() {
      return new Dimension(width, height);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o)
        return true;
      if (o == null || getClass() != o.getClass())
        return false;
      RGBImage rgbImage = (RGBImage) o;
      if (height != rgbImage.height)
        return false;
      if (width != rgbImage.width)
        return false;
      if (!Arrays.equals(pixels, rgbImage.pixels))
        return false;
      return true;
    }

    @Override
    public int hashCode() {
      int result = width;
      result = 31 * result + height;
      result = 31 * result + Arrays.hashCode(pixels);
      return result;
    }

    public String getHex(int x, int y) {
      return getPixel(x, y).getHexString();
    }

    public RGBImage clip(int x, int y, int width, int height) {
      return clip(new Rectangle(x, y, width, height));
    }

    public RGBImage clipLine(int y) {
      return clip(0, y, width, 1);
    }

    public int numPixels() {
      return width * height;
    }

    public void uncacheBufferedImage() {
      bufferedImage = null;
    }
  }

  static public class HCRUD_Data {

    public Map<String, Renderer> renderers = new HashMap();

    public Map<String, String> fieldHelp = new HashMap();

    abstract static public class Renderer {

      transient public IF1<Object, Object> preprocessValue;

      public Object preprocessValue(Object value) {
        return preprocessValue != null ? preprocessValue.get(value) : preprocessValue_base(value);
      }

      final public Object preprocessValue_fallback(IF1<Object, Object> _f, Object value) {
        return _f != null ? _f.get(value) : preprocessValue_base(value);
      }

      public Object preprocessValue_base(Object value) {
        return value;
      }
    }

    static public class TextArea extends Renderer implements IFieldsToList {

      public int cols;

      public int rows;

      public TextArea() {
      }

      public TextArea(int cols, int rows) {
        this.rows = rows;
        this.cols = cols;
      }

      public String toString() {
        return shortClassName(this) + "(" + cols + ", " + rows + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextArea))
          return false;
        TextArea __1 = (TextArea) o;
        return cols == __1.cols && rows == __1.rows;
      }

      public int hashCode() {
        int h = -939552902;
        h = boostHashCombine(h, _hashCode(cols));
        h = boostHashCombine(h, _hashCode(rows));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols, rows };
      }

      public TextArea(int cols, int rows, IF1 preprocessValue) {
        this.cols = cols;
        this.rows = rows;
        this.preprocessValue = preprocessValue;
      }
    }

    static public class TextField extends Renderer implements IFieldsToList {

      public int cols;

      public TextField() {
      }

      public TextField(int cols) {
        this.cols = cols;
      }

      public String toString() {
        return shortClassName(this) + "(" + cols + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof TextField))
          return false;
        TextField __2 = (TextField) o;
        return cols == __2.cols;
      }

      public int hashCode() {
        int h = 942981037;
        h = boostHashCombine(h, _hashCode(cols));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { cols };
      }
    }

    static public class ComboBox extends Renderer implements IFieldsToList {

      public List<String> entries;

      public ComboBox() {
      }

      public ComboBox(List<String> entries) {
        this.entries = entries;
      }

      public String toString() {
        return shortClassName(this) + "(" + entries + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof ComboBox))
          return false;
        ComboBox __3 = (ComboBox) o;
        return eq(entries, __3.entries);
      }

      public int hashCode() {
        int h = -547674755;
        h = boostHashCombine(h, _hashCode(entries));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { entries };
      }

      transient public IF1<Object, String> valueToEntry;

      public String valueToEntry(Object value) {
        return valueToEntry != null ? valueToEntry.get(value) : valueToEntry_base(value);
      }

      final public String valueToEntry_fallback(IF1<Object, String> _f, Object value) {
        return _f != null ? _f.get(value) : valueToEntry_base(value);
      }

      public String valueToEntry_base(Object value) {
        return strOrNull(value);
      }

      public ComboBox(String... entries) {
        this(asList(entries));
      }

      public ComboBox(List<String> entries, IF1<Object, String> valueToEntry) {
        this.entries = entries;
        this.valueToEntry = valueToEntry;
      }
    }

    static public class CheckBox extends Renderer implements IFieldsToList {

      public CheckBox() {
      }

      public String toString() {
        return shortClassName(this) + "(" + ")";
      }

      public boolean equals(Object o) {
        return o instanceof CheckBox;
      }

      public int hashCode() {
        int h = 1601505219;
        return h;
      }

      public Object[] _fieldsToList() {
        return null;
      }
    }

    static public class FlexibleLengthList extends Renderer implements IFieldsToList {

      public Renderer itemRenderer;

      public FlexibleLengthList() {
      }

      public FlexibleLengthList(Renderer itemRenderer) {
        this.itemRenderer = itemRenderer;
      }

      public String toString() {
        return shortClassName(this) + "(" + itemRenderer + ")";
      }

      public boolean equals(Object o) {
        if (!(o instanceof FlexibleLengthList))
          return false;
        FlexibleLengthList __4 = (FlexibleLengthList) o;
        return eq(itemRenderer, __4.itemRenderer);
      }

      public int hashCode() {
        int h = -1874811153;
        h = boostHashCombine(h, _hashCode(itemRenderer));
        return h;
      }

      public Object[] _fieldsToList() {
        return new Object[] { itemRenderer };
      }
    }

    public String itemName() {
      return "object";
    }

    public String itemNamePlural() {
      return plural(itemName());
    }

    public List<Map<String, Object>> list() {
      return null;
    }

    public List<Map<String, Object>> list(IntRange range) {
      return subListOrFull(list(), range);
    }

    public String idField() {
      return "id";
    }

    public Map<String, Object> emptyObject() {
      return null;
    }

    public Map<String, Object> getObject(Object id) {
      return null;
    }

    public Object createObject(Map<String, String> map) {
      throw unimplemented();
    }

    public String deleteObject(Object id) {
      throw unimplemented();
    }

    public boolean objectCanBeDeleted(Object id) {
      return true;
    }

    public String updateObject(Object id, Map<String, String> map) {
      throw unimplemented();
    }

    public Renderer getRenderer(String field) {
      return renderers.get(field);
    }

    public String fieldHelp(String field) {
      return fieldHelp.get(field);
    }

    public HCRUD_Data addRenderer(String field, Renderer renderer) {
      renderers.put(field, renderer);
      return this;
    }

    public HCRUD_Data fieldHelp(String field, String help, String... more) {
      fieldHelp.put(field, help);
      for (int i = 0; i + 1 < l(more); i += 2) fieldHelp.put(more[i], more[i + 1]);
      return this;
    }

    public String fieldNameToHTML(String name) {
      String help = fieldHelp.get(name);
      return spanTitle(help, htmlencode2(humanizeLabel(name)));
    }
  }

  static public interface ValueConverterForField {

    public OrError<Object> convertValue(Object object, Field field, Object value);
  }

  abstract static public class SynchronizedArrayList_Base<A> extends AbstractList<A> {

    final public int modCount() {
      return modCount;
    }

    public void removeRange(int i, int j) {
      super.removeRange(i, j);
    }
  }

  static public interface IConceptCounter {

    public Class<? extends Concept> conceptClass();

    public int countConcepts();

    public Collection<Concept> allConcepts();
  }

  static public class HTML implements IFieldsToList {

    public String html;

    public HTML() {
    }

    public HTML(String html) {
      this.html = html;
    }

    public String toString() {
      return shortClassName(this) + "(" + html + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof HTML))
        return false;
      HTML __1 = (HTML) o;
      return eq(html, __1.html);
    }

    public int hashCode() {
      int h = 2228139;
      h = boostHashCombine(h, _hashCode(html));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { html };
    }

    public String get() {
      return html;
    }
  }

  abstract static public class HAbstractRenderable {

    public String baseLink;

    public MakeFrame makeFrame = (title, contents) -> h1_title(title) + contents;

    static public interface MakeFrame {

      public String makeFrame(String title, String contents);
    }

    public HAbstractRenderable() {
    }

    public HAbstractRenderable(String baseLink) {
      this.baseLink = baseLink;
    }

    public HAbstractRenderable makeFrame(MakeFrame makeFrame) {
      this.makeFrame = makeFrame;
      return this;
    }

    public String baseLinkPlus(String uri) {
      return nempty(uri) ? appendSlash(baseLink) + uri : baseLink;
    }

    public String frame(String title, String contents) {
      return makeFrame.makeFrame(title, contents);
    }

    public String refreshWithMsgs(String... msgs) {
      return refreshWithMsgs(asList(msgs));
    }

    public String refreshWithMsgs(List<String> msgs, Object... __) {
      String anchor = (String) (optPar("anchor", __));
      return hrefresh(addAnchorToURL(appendQueryToURL(baseLink, "msg", htmlEncode_nlToBr(lines_rtrim(msgs))), anchor));
    }

    public String renderMsgs(Map<String, String> params) {
      return pUnlessEmpty(params.get("msg"));
    }
  }

  static public class RemoteDB implements AutoCloseable {

    public DialogIO db;

    public String name;

    public RemoteDB(String s) {
      this(s, false);
    }

    public RemoteDB(String s, boolean autoStart) {
      name = s;
      if (isSnippetID(s))
        name = dbBotName(s);
      db = findBot(name);
      if (db == null)
        if (autoStart) {
          nohupJavax(fsI(s));
          waitForBotStartUp(name);
          assertNotNull("Weird problem", db = findBot(s));
        } else
          throw fail("DB " + s + " not running");
    }

    public boolean functional() {
      return db != null;
    }

    public List<RC> list() {
      return adopt((List<RC>) rpc(db, "xlist"));
    }

    public List<RC> list(String className) {
      return adopt((List<RC>) rpc(db, "xlist", className));
    }

    public List<RC> xlist() {
      return list();
    }

    public List<RC> xlist(String className) {
      return list(className);
    }

    public List<RC> adopt(List<RC> l) {
      if (l != null)
        for (RC rc : l) adopt(rc);
      return l;
    }

    public RC adopt(RC rc) {
      if (rc != null)
        rc.db = this;
      return rc;
    }

    public Object adopt(Object o) {
      if (o instanceof RC)
        return adopt((RC) o);
      return o;
    }

    public String xclass(RC o) {
      return (String) rpc(db, "xclass", o);
    }

    public Object xget(RC o, String field) {
      return adopt(rpc(db, "xget", o, field));
    }

    public String xS(RC o, String field) {
      return (String) xget(o, field);
    }

    public RC xgetref(RC o, String field) {
      return adopt((RC) xget(o, field));
    }

    public void xset(RC o, String field, Object value) {
      rpc(db, "xset", o, field, value);
    }

    public RC uniq(String className) {
      RC ref = first(list(className));
      if (ref == null)
        ref = xnew(className);
      return ref;
    }

    public RC xuniq(String className) {
      return uniq(className);
    }

    public RC xnew(String className, Object... values) {
      return adopt((RC) rpc(db, "xnew", className, values));
    }

    public void xdelete(RC o) {
      rpc(db, "xdelete", o);
    }

    public void xdelete(List<RC> l) {
      rpc(db, "xdelete", l);
    }

    public void close() {
      _close(db);
    }

    public String fullgrab() {
      return (String) rpc(db, "xfullgrab");
    }

    public String xfullgrab() {
      return fullgrab();
    }

    public void xshutdown() {
      rpc(db, "xshutdown");
    }

    public long xchangeCount() {
      return (long) rpc(db, "xchangeCount");
    }

    public int xcount() {
      return (int) rpc(db, "xcount");
    }

    public void reconnect() {
      close();
      db = findBot(name);
    }

    public RC rc(long id) {
      return new RC(this, id);
    }
  }

  abstract static public class Surface extends JPanel {

    public boolean clearSurface = true;

    public boolean clearOnce = false;

    public Surface() {
      setDoubleBuffered(false);
    }

    public Graphics2D createGraphics2D(int width, int height, Graphics g) {
      Graphics2D g2 = (Graphics2D) g;
      g2.setBackground(getBackground());
      if (clearSurface || clearOnce) {
        g2.clearRect(0, 0, width, height);
        clearOnce = false;
      }
      return g2;
    }

    public abstract void render(int w, int h, Graphics2D g);

    public void paintImmediately(int x, int y, int w, int h) {
      RepaintManager repaintManager = null;
      boolean save = true;
      if (!isDoubleBuffered()) {
        repaintManager = RepaintManager.currentManager(this);
        save = repaintManager.isDoubleBufferingEnabled();
        repaintManager.setDoubleBufferingEnabled(false);
      }
      super.paintImmediately(x, y, w, h);
      if (repaintManager != null)
        repaintManager.setDoubleBufferingEnabled(save);
    }

    public void paint(Graphics g) {
      Dimension d = getSize();
      Graphics2D g2 = createGraphics2D(d.width, d.height, g);
      render(d.width, d.height, g2);
      g2.dispose();
    }
  }

  static public class OrError<A> extends Var<A> {

    public Object error;

    public OrError() {
    }

    public OrError(A value) {
      super(value);
    }

    public OrError(boolean dummy, Object error) {
      this.error = error;
      assertNotNull(error);
    }

    public boolean ok() {
      return error == null;
    }

    public Object error() {
      return error;
    }

    public String toString() {
      return ok() ? super.toString() : str(error);
    }
  }

  static public interface IF3<A, B, C, D> {

    public D get(A a, B b, C c);
  }

  static public class MultiSet<A> {

    public Map<A, Integer> map = new HashMap();

    public int size;

    public MultiSet(boolean useTreeMap) {
      if (useTreeMap)
        map = new TreeMap();
    }

    public MultiSet() {
    }

    public MultiSet(Iterable<A> c) {
      addAll(c);
    }

    public MultiSet(MultiSet<A> ms) {
      synchronized (ms) {
        for (A a : ms.keySet()) add(a, ms.get(a));
      }
    }

    synchronized public int add(A key) {
      return add(key, 1);
    }

    synchronized public void addAll(Iterable<A> c) {
      if (c != null)
        for (A a : c) add(a);
    }

    synchronized public void addAll(MultiSet<A> ms) {
      for (A a : ms.keySet()) add(a, ms.get(a));
    }

    synchronized public int add(A key, int count) {
      if (count <= 0)
        return 0;
      size += count;
      Integer i = map.get(key);
      map.put(key, i != null ? (count += i) : count);
      return count;
    }

    synchronized public int get(A key) {
      Integer i = map.get(key);
      return i != null ? i : 0;
    }

    synchronized public boolean contains(A key) {
      return map.containsKey(key);
    }

    synchronized public void remove(A key) {
      Integer i = map.get(key);
      if (i != null) {
        --size;
        if (i > 1)
          map.put(key, i - 1);
        else
          map.remove(key);
      }
    }

    synchronized public List<A> topTen() {
      return getTopTen();
    }

    synchronized public List<A> getTopTen() {
      return getTopTen(10);
    }

    synchronized public List<A> getTopTen(int maxSize) {
      List<A> list = getSortedListDescending();
      return list.size() > maxSize ? list.subList(0, maxSize) : list;
    }

    synchronized public List<A> highestFirst() {
      return getSortedListDescending();
    }

    synchronized public List<A> lowestFirst() {
      return reversedList(getSortedListDescending());
    }

    synchronized public List<A> getSortedListDescending() {
      List<A> list = new ArrayList<A>(map.keySet());
      Collections.sort(list, new Comparator<A>() {

        public int compare(A a, A b) {
          return map.get(b).compareTo(map.get(a));
        }
      });
      return list;
    }

    synchronized public int getNumberOfUniqueElements() {
      return map.size();
    }

    synchronized public int uniqueSize() {
      return map.size();
    }

    synchronized public Set<A> asSet() {
      return map.keySet();
    }

    synchronized public NavigableSet<A> navigableSet() {
      return navigableKeys((NavigableMap) map);
    }

    synchronized public Set<A> keySet() {
      return map.keySet();
    }

    synchronized public A getMostPopularEntry() {
      int max = 0;
      A a = null;
      for (Map.Entry<A, Integer> entry : map.entrySet()) {
        if (entry.getValue() > max) {
          max = entry.getValue();
          a = entry.getKey();
        }
      }
      return a;
    }

    synchronized public void removeAll(A key) {
      size -= get(key);
      map.remove(key);
    }

    synchronized public int size() {
      return size;
    }

    synchronized public MultiSet<A> mergeWith(MultiSet<A> set) {
      MultiSet<A> result = new MultiSet<A>();
      for (A a : set.asSet()) {
        result.add(a, set.get(a));
      }
      return result;
    }

    synchronized public boolean isEmpty() {
      return map.isEmpty();
    }

    synchronized public String toString() {
      return str(map);
    }

    synchronized public void clear() {
      map.clear();
      size = 0;
    }

    synchronized public Map<A, Integer> asMap() {
      return cloneMap(map);
    }
  }

  static public class HTMLPaginator {

    public String startParam = "start";

    public String baseLink;

    public int start, step = 50;

    public int max;

    public void processParams(Map<String, String> params) {
      start = parseInt(mapGet(params, startParam));
    }

    public String renderNav(Object... __) {
      return pageNav2(baseLink, max, start, step, startParam, __);
    }

    public IntRange visibleRange() {
      return intRange(start, min(max, start + step));
    }
  }

  static public class ImageSurfaceSelector extends MouseAdapter {

    public ImageSurface is;

    public Point startingPoint;

    public boolean enabled = true;

    static public boolean verbose = false;

    public ImageSurfaceSelector(ImageSurface is) {
      this.is = is;
      if (containsInstance(is.tools, ImageSurfaceSelector.class))
        return;
      is.tools.add(this);
      is.addMouseListener(this);
      is.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent evt) {
      if (verbose)
        print("mousePressed");
      if (evt.getButton() != MouseEvent.BUTTON1)
        return;
      if (enabled)
        startingPoint = getPoint(evt);
    }

    public void mouseDragged(MouseEvent e) {
      if (verbose)
        print("mouseDragged");
      if (startingPoint != null) {
        Point endPoint = getPoint(e);
        Rectangle r = new Rectangle(startingPoint, new Dimension(endPoint.x - startingPoint.x + 1, endPoint.y - startingPoint.y + 1));
        normalize(r);
        r.width = min(r.width, is.getImage().getWidth() - r.x);
        r.height = min(r.height, is.getImage().getHeight() - r.y);
        is.setSelection(r);
      }
      if (verbose)
        print("mouseDragged done");
    }

    public static void normalize(Rectangle r) {
      if (r.width < 0) {
        r.x += r.width;
        r.width = -r.width;
      }
      if (r.height < 0) {
        r.y += r.height;
        r.height = -r.height;
      }
    }

    public void mouseReleased(MouseEvent e) {
      if (verbose)
        print("mouseReleased");
      mouseDragged(e);
      if (getPoint(e).equals(startingPoint))
        is.setSelection((Rectangle) null);
      startingPoint = null;
    }

    public Point getPoint(MouseEvent e) {
      return new Point((int) (e.getX() / is.getZoomX()), (int) (e.getY() / is.getZoomY()));
    }
  }

  static public Lock dbLock() {
    return db_mainConcepts().lock;
  }

  static public boolean bareDBMode_on = false;

  static public void bareDBMode() {
    bareDBMode(null);
  }

  static public void bareDBMode(Integer autoSaveInterval) {
    bareDBMode_on = true;
    conceptsAndBot(autoSaveInterval);
  }

  static public String structureOrText_crud(Object o) {
    if (o == null)
      return "";
    if (o instanceof Long)
      return str(o);
    if (o instanceof File)
      return ((File) o).getAbsolutePath();
    return str(o);
  }

  static public Border getBorder(final JComponent c) {
    return c == null ? null : swing(new F0<Border>() {

      public Border get() {
        try {
          return c.getBorder();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getBorder();";
      }
    });
  }

  static public <A extends JComponent> void componentPopupMenu2(A component, final VF2<A, JPopupMenu> menuMaker) {
    final WeakReference<A> ref = new WeakReference<>(component);
    componentPopupMenu(component, new VF1<JPopupMenu>() {

      public void get(JPopupMenu menu) {
        try {
          callF(menuMaker, ref.get(), menu);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(menuMaker, ref!, menu);";
      }
    });
  }

  static public <A extends JComponent> A jHandleFileDrop(A c, final Object onDrop) {
    new DropTarget(c, new DropTargetAdapter() {

      public void drop(DropTargetDropEvent e) {
        try {
          Transferable tr = e.getTransferable();
          DataFlavor[] flavors = tr.getTransferDataFlavors();
          for (DataFlavor flavor : flavors) {
            if (flavor.isFlavorJavaFileListType()) {
              e.acceptDrop(e.getDropAction());
              File file = first((List<File>) tr.getTransferData(flavor));
              if (file != null && !isFalse(callF(onDrop, file)))
                e.dropComplete(true);
              return;
            }
          }
        } catch (Throwable __e) {
          _handleException(__e);
        }
        e.rejectDrop();
      }
    });
    return c;
  }

  static public <A extends JComponent> A jHandleFileDrop(Object onDrop, A c) {
    return jHandleFileDrop(c, onDrop);
  }

  static public JFrame showFullScreen(JComponent c) {
    return showFullScreen(defaultFrameTitle(), c);
  }

  static public JFrame showFullScreen(final String title, final JComponent c) {
    return (JFrame) swingAndWait(new F0<Object>() {

      public Object get() {
        try {
          GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
          if (!gd.isFullScreenSupported())
            throw fail("No full-screen mode supported!");
          boolean dec = JFrame.isDefaultLookAndFeelDecorated();
          if (dec)
            JFrame.setDefaultLookAndFeelDecorated(false);
          final JFrame window = new JFrame(title);
          window.setUndecorated(true);
          if (dec)
            JFrame.setDefaultLookAndFeelDecorated(true);
          registerEscape(window, new Runnable() {

            public void run() {
              try {
                disposeWindow(window);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "disposeWindow(window)";
            }
          });
          window.add(wrap(c));
          gd.setFullScreenWindow(window);
          for (int i = 100; i <= 1000; i += 100) awtLater(i, new Runnable() {

            public void run() {
              try {
                window.toFront();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "window.toFront()";
            }
          });
          return window;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment()\r\n      ...";
      }
    });
  }

  static public void selectFile(final String msg, VF1<File> action) {
    selectFile(msg, userDir(), action);
  }

  static public void selectFile(final String msg, final File defaultFile, VF1<File> action) {
    inputFilePath(msg, defaultFile, action);
  }

  static public JComponent selectImageSnippet(VF1<String> onSelect) {
    return selectSnippetID_v1(onSelect);
  }

  static public JComponent selectImageSnippet(String defaultID, VF1<String> onSelect) {
    return selectSnippetID_v1(defaultID, onSelect);
  }

  static public BufferedImage cloneClipBufferedImage(BufferedImage src, Rectangle clip) {
    return cloneBufferedImage(clipBufferedImage(src, clip));
  }

  static public BufferedImage cloneClipBufferedImage(BufferedImage src, Rect r) {
    return cloneBufferedImage(clipBufferedImage(src, r));
  }

  static public BufferedImage cloneClipBufferedImage(BufferedImage src, int x, int y, int w, int h) {
    return cloneBufferedImage(clipBufferedImage(src, x, y, w, h));
  }

  static public BufferedImage getImageFromClipboard() {
    try {
      Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
      if (t == null)
        return null;
      List<File> l = (List<File>) (getTransferData(t, DataFlavor.javaFileListFlavor));
      if (nempty(l))
        return loadImage2(first(l));
      if (t.isDataFlavorSupported(DataFlavor.imageFlavor))
        return (BufferedImage) t.getTransferData(DataFlavor.imageFlavor);
      return imageFromDataURL(getTextFromClipboard());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void popup(final Throwable throwable) {
    popupError(throwable);
  }

  static public void popup(final String msg) {
    print(msg);
    SwingUtilities.invokeLater(new Runnable() {

      public void run() {
        JOptionPane.showMessageDialog(null, msg);
      }
    });
  }

  static public <A> A _print(String s, A a) {
    return print(s, a);
  }

  static public <A> A _print(A a) {
    return print(a);
  }

  static public void _print() {
    print();
  }

  static public boolean hasTransparency(BufferedImage img) {
    return img.getColorModel().hasAlpha();
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW, int newH) {
    return resizeImage(img, newW, newH, Image.SCALE_SMOOTH);
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW, int newH, int scaleType) {
    if (newW == img.getWidth() && newH == img.getHeight())
      return img;
    Image tmp = img.getScaledInstance(newW, newH, scaleType);
    BufferedImage dimg = new BufferedImage(newW, newH, BufferedImage.TYPE_INT_ARGB);
    Graphics2D g2d = dimg.createGraphics();
    g2d.drawImage(tmp, 0, 0, null);
    g2d.dispose();
    return dimg;
  }

  static public BufferedImage resizeImage(BufferedImage img, int newW) {
    int newH = iround(img.getHeight() * (double) newW / img.getWidth());
    return resizeImage(img, newW, newH);
  }

  static public BufferedImage resizeImage(int newW, BufferedImage img) {
    return resizeImage(img, newW);
  }

  static public <A extends Component> A repaint(A c) {
    if (c != null)
      c.repaint();
    return c;
  }

  static public boolean imagesHaveSameSize(BufferedImage a, BufferedImage b) {
    return a != null && b != null && a.getWidth() == b.getWidth() && a.getHeight() == b.getHeight();
  }

  static public Dimension getPreferredSize(final Component c) {
    return c == null ? null : swing(new F0<Dimension>() {

      public Dimension get() {
        try {
          return c.getPreferredSize();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getPreferredSize();";
      }
    });
  }

  static public ImageSurface showFullScreenImageSurface(BufferedImage img) {
    ImageSurface is = jImageSurface(img);
    showFullScreen(jscroll_centered(disposeFrameOnClick(is)));
    return is;
  }

  static public String assertGlobalID(String s) {
    return assertPossibleGlobalID(s);
  }

  static public BigInteger bigint(String s) {
    return new BigInteger(s);
  }

  static public BigInteger bigint(long l) {
    return BigInteger.valueOf(l);
  }

  static public BigInteger plus(BigInteger a, BigInteger b) {
    return a.add(b);
  }

  static public BigInteger plus(BigInteger a, long b) {
    return a.add(bigint(b));
  }

  static public BigInteger mul(BigInteger a, BigInteger b) {
    return a.multiply(b);
  }

  static public BigInteger mul(BigInteger a, long b) {
    return a.multiply(bigint(b));
  }

  static public String bigintToGlobalID(BigInteger value) {
    char[] buf = new char[16];
    for (int i = 16 - 1; i >= 0; i--) {
      buf[i] = charPlus('a', mod(value, 26).intValue());
      value = div(value, 26);
    }
    return str(buf);
  }

  static public String appendQueryToURL(String url, Map params) {
    return url == null ? null : url + (url.contains("?") ? "&" : "?") + makePostData(params);
  }

  static public String appendQueryToURL(String url, Object... data) {
    return appendQueryToURL(url, litmap(data));
  }

  static public String pUnlessEmpty(String s) {
    return empty(s) ? "" : p(s);
  }

  static public String ahref(String link, Object contents, Object... params) {
    return link == null ? str(contents) : href(link, contents, params);
  }

  static public String joinWithVBar(Iterable<String> l) {
    return join(" | ", l);
  }

  static public String joinWithVBar(String... l) {
    return joinWithVBar(asList(l));
  }

  static public boolean eqGet(List l, int i, Object o) {
    return eq(get(l, i), o);
  }

  static public <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
    return eq(mapGet(map, key), o);
  }

  static public <T> Map<String, T> subMapStartingWith_dropPrefix(Map<String, T> map, String prefix) {
    if (map == null)
      return null;
    Map<String, T> map2 = new HashMap();
    for (String key : keys(map)) {
      T value = map.get(key);
      if (startsWith(key, prefix))
        map2.put(substring(key, l(prefix)), value);
    }
    return map2;
  }

  static public List<String> keysDeprefixNemptyValue(Map<String, String> map, String prefix) {
    List<String> l = new ArrayList();
    for (String s : keys(map)) if (startsWith(s, prefix) && nempty(map.get(s)))
      l.add(s.substring(l(prefix)));
    return l;
  }

  static public String hhiddenStuff(String secretHTML) {
    String id = aGlobalID();
    String js = "document.getElementById(" + jsQuote(id) + ").innerHTML = " + jsQuote(secretHTML) + "; return false;";
    return span(ahref("#", "show", "onclick", js), "id", id);
  }

  static public String yesNo_short(boolean b) {
    return b ? "yes" : "no";
  }

  static public String htmlEncode_nlToBr_withIndents(String s) {
    return nlToBr_withIndents(htmlEncode(s));
  }

  static public String p(Object contents, Object... params) {
    return tag("p", contents, params) + "\n";
  }

  static public <B, C, A extends Map<B, C>> List<A> sortByTransformedMapKey_alphaNum(IF1<C, String> transform, Iterable<A> c, B key) {
    List<A> l = cloneList(c);
    sort(l, (a, b) -> cmpAlphaNum(transform.get(mapGet(a, key)), transform.get(mapGet(b, key))));
    return l;
  }

  static public <A> List<A> reversed(Collection<A> l) {
    return reversedList(l);
  }

  static public <A> List<A> reversed(A[] l) {
    return reversedList(asList(l));
  }

  static public String reversed(String s) {
    return reversedString(s);
  }

  static public <A, B> Map<A, B> mapMinusKeys(Map<A, B> map, Collection<A> keys) {
    if (empty(keys) || empty(map))
      return map;
    keys = asSet(keys);
    Map<A, B> m2 = similarEmptyMap(map);
    for (A key : keys(map)) {
      B val = map.get(key);
      if (!keys.contains(key))
        m2.put(key, val);
    }
    return m2;
  }

  static public <A> Set<A> joinSets(Set<A>... l) {
    TreeSet set = new TreeSet();
    for (Set o : l) if (o != null)
      set.addAll(o);
    return set;
  }

  static public Map mapToMap(Object f, Iterable l) {
    Map map = new HashMap();
    for (Object o : unnull(l)) {
      Pair p = (Pair) (callF(f, o));
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> Map<B, C> mapToMap(IF1<A, Pair<B, C>> f, Iterable<A> l) {
    Map<B, C> map = new HashMap();
    for (A o : unnull(l)) {
      Pair<B, C> p = callF(f, o);
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C> Map<B, C> mapToMap(Iterable<A> l, IF1<A, Pair<B, C>> f) {
    return mapToMap(f, l);
  }

  static public <A, B, C, D> Map<C, D> mapToMap(IF2<A, B, Pair<C, D>> f, Map<A, B> m) {
    return mapMapToMap(f, m);
  }

  static public <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
    mapPut(map, key, value);
    return value;
  }

  static public <A, B> A firstKey(Map<A, B> map) {
    return first(keys(map));
  }

  static public String aname(String anchor, Object contents, Object... params) {
    return tag("a", contents, concatArrays(new Object[] { "name", anchor }, params));
  }

  static public <A, B> B firstValue(Map<A, B> map) {
    return first(values(map));
  }

  static public <A> List<A> subListOrFull(List<A> l, IntRange r) {
    return r == null ? l : subList(l, r.start, r.end);
  }

  static public String span_title(String title, Object contents) {
    return spanTitle(title, contents);
  }

  static public String unicode_downOrUpPointingTriangle(boolean down) {
    return down ? unicode_downPointingTriangle() : unicode_upPointingTriangle();
  }

  static public String hpostform(Object contents, Object... params) {
    return tag("form", contents, concatArrays(new Object[] { "method", "POST" }, params));
  }

  static public String htmlTable2_noHtmlEncode(Object data, Object... __) {
    return htmlTable2(data, paramsPlus(__, "htmlEncode", false));
  }

  static public Object[] paramsPlus(Object[] a1, Object... a2) {
    if (a2 == null)
      return a1;
    if (a1 == null)
      return a2;
    if (l(a1) == 1 && a1[0] instanceof Map)
      return new Object[] { mapPlus((Map) a1[0], a2) };
    assertEvenLength(a1);
    assertEvenLength(a2);
    Map map = paramsToOrderedMap(a1);
    int n = l(a2);
    for (int i = 0; i < n; i += 2) {
      Object key = a2[i];
      if (key != null)
        map.put(key, a2[i + 1]);
    }
    return mapToParams(map);
  }

  static public String lines_rtrim(Collection lines) {
    return rtrim_fromLines(lines);
  }

  static public String hselect(String name, Map map, Object... params) {
    return hselect(map, paramsPlus_skipFirst(params, "name", name));
  }

  static public String hselect(Map map, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(map))
      for (Object key : keys(map)) {
        Object value = map.get(key);
        String k = str(key);
        buf.append(tag("option", htmlencode(str(or(value, ""))), "value", k, "selected", eq(selected, k) ? "selected" : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public String hsubmit(String text, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "submit", "value", text }, params));
  }

  static public String hsubmit() {
    return hsubmit("Submit");
  }

  static public String hcheckbox(String name, boolean checked, Object... params) {
    return tag("input", "", arrayPlus(params, "type", "checkbox", "name", name, checked ? "checked" : null, "1"));
  }

  static public String hcheckbox(String name) {
    return hcheckbox(name, false);
  }

  static public Map putKeysFirst(Map map, Object... keys) {
    Map m2 = litorderedmap();
    Map remaining = cloneMap(map);
    for (Object key : keys) {
      if (remaining.containsKey(key)) {
        m2.put(key, remaining.get(key));
        remaining.remove(key);
      }
    }
    m2.putAll(remaining);
    return m2;
  }

  static public Map putKeysFirst(List keys, Map map) {
    return putKeysFirst(map, toObjectArray(keys));
  }

  static public Object[] litparams(Object... l) {
    int n = 0, n1 = l(l);
    for (int i = 0; i < n1; i += 2) if (l[i] != null && l[i + 1] != null)
      ++n;
    if (n == 0)
      return null;
    Object[] params = new Object[n * 2];
    int j = 0;
    for (int i = 0; i < n1; i += 2) {
      Object key = l[i], value = l[i + 1];
      if (key != null && value != null) {
        params[j++] = key;
        params[j++] = value;
      }
    }
    return params;
  }

  static public String small(Object contents, Object... params) {
    return tag("small", contents, params);
  }

  static public String htableRaw_valignTop(List<? extends List> data, Object... params) {
    return htableRaw2(data, asList(params), ll(), ll("valign", "top"));
  }

  static public String htextarea(String text, Object... params) {
    params = html_massageAutofocusParam(params);
    return hopeningTag("textarea", params) + htmlencode2(text) + "</textarea>";
  }

  static public String htextfield(String name, Object... params) {
    return htextinput(name, params);
  }

  static public String htrickcheckboxWithText(String name, String text, boolean checked, Object... params) {
    String id = randomID();
    return hhidden(name, checked ? "1" : "0") + hcheckbox(null, checked, paramsPlus(params, "id", id, "onclick", "this.previousElementSibling.value=this.checked ? 1 : 0")) + " " + hlabelFor(id, htmlEncode2(text));
  }

  static public String htrickcheckboxWithText(String name, String text) {
    return htrickcheckboxWithText(name, text, false);
  }

  static public String tr(Object contents) {
    return tag("tr", contents);
  }

  static public String td(Object contents, Object... params) {
    return tag("td", contents, params);
  }

  static public String htag(String tag) {
    return htag(tag, "");
  }

  static public String htag(String tag, Object contents, Object... params) {
    String openingTag = hopeningTag(tag, params);
    String s = str(contents);
    if (empty(s) && neqic(tag, "script"))
      return dropLast(openingTag) + "/>";
    return openingTag + s + "</" + tag + ">";
  }

  static public <A, B> Map<A, B> mapWithoutKey(Map<A, B> map, A key) {
    if (map == null || !map.containsKey(key))
      return map;
    Map m = cloneMap(map);
    m.remove(key);
    return m;
  }

  static public String hhidden(String name, Object value, Object... params) {
    return tag("input", "", concatArrays(new Object[] { "type", "hidden", "name", name, "value", value }, params));
  }

  static public String htmlEncode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String joinNemptiesWithVBar(String... strings) {
    return joinNempties(" | ", strings);
  }

  static public String joinNemptiesWithVBar(Collection<String> strings) {
    return joinNempties(" | ", strings);
  }

  static public String unicode_DEL() {
    return unicodeFromCodePoint(0x2421);
  }

  static public String ahrefWithConfirm(String msg, String url, Object contents, Object... params) {
    return ahref(url, contents, paramsPlus(params, "onClick", "return confirm(" + jsQuote(msg) + ");"));
  }

  static public String aGlobalID() {
    return randomID(globalIDLength());
  }

  static public String aGlobalID(Random random) {
    return randomID(random, globalIDLength());
  }

  static public String hselect_list(Collection<String> entries, Object... params) {
    StringBuilder buf = new StringBuilder();
    String selected = null;
    if (odd(l(params))) {
      selected = str(first(params));
      params = dropFirst(params);
    }
    int i = indexOf(params, "allowEmpty");
    if (even(i)) {
      buf.append("<option></option>\n");
      params[i] = params[i + 1] = null;
    }
    if (nempty(entries))
      for (String k : entries) {
        String value = k;
        boolean isSelected = eq(selected, k);
        buf.append(hfulltag("option", htmlencode(str(or(value, ""))), "value", k, "selected", isSelected ? html_valueLessParam() : null)).append("\n");
      }
    return tag("select", buf, params) + "\n";
  }

  static public String hjs(String script) {
    return hjavascript(script);
  }

  static public String hcss(Object contents) {
    return htag("style", contents);
  }

  static public String tag(String tag) {
    return htag(tag);
  }

  static public String tag(String tag, Object contents, Object... params) {
    return htag(tag, str(contents), params);
  }

  static public String tag(String tag, StringBuilder contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public String tag(String tag, StringBuffer contents, Object... params) {
    return htag(tag, contents, params);
  }

  static public List<String> mapToLines(Map map) {
    List<String> l = new ArrayList();
    for (Object key : keys(map)) l.add(str(key) + " = " + str(map.get(key)));
    return l;
  }

  static public String mapToLines(Map map, Object f) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Map map) {
    return lines(map(map, f));
  }

  static public String mapToLines(Object f, Iterable l) {
    return lines(map(f, l));
  }

  static public <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
    return mapToLines((Object) f, l);
  }

  static public <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
    return mapToLines((Object) f, l);
  }

  static public <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
    return lines(map(map, f));
  }

  static public String hoption(String text) {
    return tag("option", htmlEncode2(text));
  }

  static public Class _run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  static public void cancelAndInterruptThread(Thread t) {
    if (t == null)
      return;
    cancelThread(t);
    t.interrupt();
  }

  static public int getWidth(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getWidth");
  }

  static public int getHeight(Component c) {
    return c == null ? 0 : (int) swingCall(c, "getHeight");
  }

  static public FontMetrics componentFontMetrics(JComponent c) {
    Font font = getFont(c);
    return font == null ? null : swing(new F0<FontMetrics>() {

      public FontMetrics get() {
        try {
          return c.getFontMetrics(font);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getFontMetrics(font);";
      }
    });
  }

  static public int idiv_ceil(int a, int b) {
    return (a + b - 1) / b;
  }

  static public int idiv_ceil(long a, long b) {
    return toInt_checked((a + b - 1) / b);
  }

  static public <A> List<A> asSyncList(Iterable<A> l) {
    return asSynchroList(l);
  }

  static public boolean endsWithNewLine(String s) {
    return endsWith(s, "\n");
  }

  static public String lines_rtrimIf(boolean rtrim, List<String> lines) {
    return rtrim ? lines_rtrim(lines) : lines(lines);
  }

  static public String defaultTimerName_name;

  static public String defaultTimerName() {
    if (defaultTimerName_name == null)
      defaultTimerName_name = "A timer by " + programID();
    return defaultTimerName_name;
  }

  static public long stopTiming_defaultMin = 10;

  static public long startTiming_startTime;

  static public void startTiming() {
    startTiming_startTime = now();
  }

  static public void stopTiming() {
    stopTiming(null);
  }

  static public void stopTiming(String text) {
    stopTiming(text, stopTiming_defaultMin);
  }

  static public void stopTiming(String text, long minToPrint) {
    long time = now() - startTiming_startTime;
    if (time >= minToPrint) {
      text = or2(text, "Time: ");
      print(text + time + " ms");
    }
  }

  static public UnsupportedOperationException unsupportedOperation() {
    throw new UnsupportedOperationException();
  }

  static public int asInt(Object o) {
    return toInt(o);
  }

  static public void rangeCheck(int i, int n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public void rangeCheck(long i, long n) {
    if (i < 0 || i >= n)
      throw fail("Range check fail: " + i + "/" + n);
  }

  static public <A> ListIterator<A> listIterator(List<A> l) {
    return l == null ? emptyListIterator() : l.listIterator();
  }

  static public <A> IterableIterator<A> concurrentlyIterateList(final List<A> l) {
    return iteratorFromFunction_withEndMarker_f0(new F0<A>() {

      public int i;

      public A get() {
        int _i = i++;
        synchronized (l) {
          if (_i < l(l)) {
            A a = l.get(_i);
            if (a == iteratorFromFunction_endMarker)
              throw fail("no");
            return a;
          }
          return (A) iteratorFromFunction_endMarker;
        }
      }
    });
  }

  static public <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
    return lookupAllOpt(map, l);
  }

  static public <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public NavigableMap synchroTreeMap() {
    return Collections.synchronizedNavigableMap(new TreeMap());
  }

  static public boolean hasConcept(Class<? extends Concept> c, Object... params) {
    return findConceptWhere(c, params) != null;
  }

  static public boolean exceptionMessageContains(Throwable e, String s) {
    return cic(getInnerMessage(e), s);
  }

  static public void printShortException(Throwable e) {
    print(exceptionToStringShort(e));
  }

  static public void printShortException(String s, Throwable e) {
    print(s, exceptionToStringShort(e));
  }

  static public void clearConcepts() {
    db_mainConcepts().clearConcepts();
  }

  static public void clearConcepts(Concepts concepts) {
    concepts.clearConcepts();
  }

  static public void restoreLatestBackupIfConceptsFileEmpty(String dbID, Object... __) {
    boolean doIt = boolPar("doIt", __);
    File file = conceptsFile(dbID);
    if (fileExists(file) && fileSize(file) == 0) {
      print(file + " corrupted, trying to restore");
      File backup = lastThat(__85 -> fileNotEmpty(__85), sortByFileName(conceptBackupFiles(dbID)));
      if (backup == null) {
        print("No usable backup found :(");
        return;
      }
      String msg = "RESTORING: " + backup;
      File log = javaxDataDir("db-restores.log");
      if (doIt)
        logQuotedWithTime(log, msg);
      print(stringIf(!doIt, "[would be] ") + msg);
      if (doIt) {
        clearConceptsOf(dbID);
        copyFile(backup, file);
        print(msg = "DB RESTORED!");
        if (doIt)
          logQuotedWithTime(log, msg);
      }
    }
  }

  static public void readLocally(String progID, String varNames) {
    readLocally2(mc(), progID, varNames);
  }

  static public void readLocally(String varNames) {
    readLocally2(mc(), programID(), varNames);
  }

  static public void readLocally2(Object obj, String varNames) {
    readLocally2(obj, programID(), varNames);
  }

  static public int readLocally_stringLength;

  static public ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

  static public ThreadLocal readLocally2_classFinder = new ThreadLocal();

  static public void readLocally2(Object obj, String progID, String varNames) {
    try {
      boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
      for (String variableName : javaTokC(varNames)) {
        File textFile = new File(programDir(progID), variableName + ".text");
        String value = loadTextFile(textFile);
        if (value != null)
          set(utils.class, variableName, value);
        else {
          File structureFile = new File(programDir(progID), variableName + ".structure");
          value = loadTextFile(structureFile);
          if (value == null) {
            File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
            if (!structureGZFile.isFile())
              return;
            InputStream fis = new FileInputStream(structureGZFile);
            try {
              GZIPInputStream gis = newGZIPInputStream(fis);
              InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
              BufferedReader bufferedReader = new BufferedReader(reader);
              Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, readLocally2_classFinder.get());
              readLocally_set(obj, variableName, o);
              return;
            } finally {
              _close(fis);
            }
          }
          readLocally_stringLength = l(value);
          if (nempty(value))
            readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
        }
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void readLocally_set(Object c, String varName, Object value) {
    Object oldValue = get(c, varName);
    if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
      value = synchroList((List) value);
    }
    set(c, varName, value);
  }

  static public int done_minPrint = 10;

  static public long done(long startTime, String desc) {
    long time = now() - startTime;
    if (time >= done_minPrint)
      print(desc + " [" + time + " ms]");
    return time;
  }

  static public long done(String desc, long startTime) {
    return done(startTime, desc);
  }

  static public long done(long startTime) {
    return done(startTime, "");
  }

  static public RemoteDB connectToDBOpt(String dbNameOrID) {
    try {
      return new RemoteDB(dbNameOrID);
    } catch (Throwable __e) {
      return null;
    }
  }

  static public <A, B> List<Pair<A, B>> mapToPairs(Map<A, B> map) {
    List<Pair<A, B>> l = new ArrayList();
    if (map != null)
      for (Map.Entry<A, B> e : map.entrySet()) l.add(pair(e.getKey(), e.getValue()));
    return l;
  }

  static public String dynShortName(Object o) {
    return shortDynamicClassName(o);
  }

  static public Concept getConcept(long id) {
    return db_mainConcepts().getConcept(id);
  }

  static public Concept getConcept(Concepts concepts, long id) {
    return concepts.getConcept(id);
  }

  static public <A extends Concept> A getConcept(Class<A> cc, long id) {
    return getConcept(db_mainConcepts(), cc, id);
  }

  static public <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
    Concept c = concepts.getConcept(id);
    if (c == null)
      return null;
    if (!isInstance(cc, c))
      throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
    return (A) c;
  }

  static public void saveLocally(String variableName) {
    saveLocally(programID(), variableName);
  }

  static public void saveLocally(String progID, String variableName) {
    saveLocally2(mc(), progID, variableName);
  }

  static public void saveLocally2(Object obj, String variableName) {
    saveLocally2(obj, programID(), variableName);
  }

  static public void saveLocally2(Object obj, String progID, String variableName) {
    Lock __0 = saveLock();
    lock(__0);
    try {
      File textFile = new File(programDir(progID), variableName + ".text");
      File structureFile = new File(programDir(progID), variableName + ".structure");
      Object x = get(obj, variableName);
      if (x == null) {
        textFile.delete();
        structureFile.delete();
      } else if (x instanceof String) {
        saveTextFile(textFile, (String) x);
        structureFile.delete();
      } else {
        saveTextFile(structureFile, javaTokWordWrap(structure(x)));
        textFile.delete();
      }
    } finally {
      unlock(__0);
    }
  }

  static public void callRunnableWithWrapper(Object wrapper, Runnable r) {
    if (wrapper == null)
      callF(r);
    else
      callF(wrapper, r);
  }

  static public long toM(long l) {
    return (l + 1024 * 1024 - 1) / (1024 * 1024);
  }

  static public String toM(long l, int digits) {
    return formatDouble(toM_double(l), digits);
  }

  static public String javaTokWordWrap(String s) {
    return javaTokWordWrap(120, s);
  }

  static public String javaTokWordWrap(int cols, String s) {
    int col = 0;
    List<String> tok = javaTok(s);
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && col >= cols && !containsNewLine(t))
        tok.set(i, t = rtrimSpaces(t) + "\n");
      int idx = t.lastIndexOf('\n');
      if (idx >= 0)
        col = l(t) - (idx + 1);
      else
        col += l(t);
    }
    return join(tok);
  }

  static public int hours() {
    return hours(java.util.Calendar.getInstance());
  }

  static public int hours(java.util.Calendar c) {
    return c.get(java.util.Calendar.HOUR_OF_DAY);
  }

  static public int hours(long time) {
    return hours(calendarFromTime(time));
  }

  static public int hours(long time, TimeZone tz) {
    return hours(calendarFromTime(time, tz));
  }

  static public long toK(long l) {
    return (l + 1023) / 1024;
  }

  static public FixedRateTimer doEvery_daemon(long delay, final Object r) {
    return doEvery_daemon(delay, delay, r);
  }

  static public FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) {
    FixedRateTimer timer = new FixedRateTimer(true);
    timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
    return timer;
  }

  static public FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
    return doEvery_daemon(toMS(delaySeconds), r);
  }

  static public float abs(float f) {
    return Math.abs(f);
  }

  static public int abs(int i) {
    return Math.abs(i);
  }

  static public double abs(double d) {
    return Math.abs(d);
  }

  static public <A> A firstOfType(Collection c, Class<A> type) {
    for (Object x : c) if (isInstanceX(type, x))
      return (A) x;
    return null;
  }

  static public Collection<Concept> allConcepts() {
    return db_mainConcepts().allConcepts();
  }

  static public Collection<Concept> allConcepts(Concepts concepts) {
    return concepts.allConcepts();
  }

  static public List<Concept> conceptsOfType(String type) {
    return db_mainConcepts().conceptsOfType(type);
  }

  static public <A> List<A> filterByType(Iterable c, Class<A> type) {
    List<A> l = new ArrayList();
    if (c != null)
      for (Object x : c) if (isInstanceX(type, x))
        l.add((A) x);
    return l;
  }

  static public <A> List<A> filterByType(Object[] c, Class<A> type) {
    return filterByType(asList(c), type);
  }

  static public <A> List<A> filterByType(Class<A> type, Iterable c) {
    return filterByType(c, type);
  }

  static public <A> List<A> filterByDynamicType(Collection<A> c, String type) {
    List<A> l = new ArrayList();
    for (A x : c) if (eq(dynamicClassName(x), type))
      l.add(x);
    return l;
  }

  static public boolean hasType(Collection c, Class type) {
    for (Object x : c) if (isInstanceX(type, x))
      return true;
    return false;
  }

  static public <A extends Concept> A findBackRef(Concept c, Class<A> type) {
    for (Concept.Ref r : c.backRefs) if (instanceOf(r.concept(), type))
      return (A) r.concept();
    return null;
  }

  static public <A extends Concept> A findBackRef(Class<A> type, Concept c) {
    return findBackRef(c, type);
  }

  static public boolean checkConceptFields(Concept x, Object... data) {
    for (int i = 0; i < l(data); i += 2) if (neq(cget(x, (String) data[i]), deref(data[i + 1])))
      return false;
    return true;
  }

  static public Concept cnew(String name, Object... values) {
    return cnew(db_mainConcepts(), name, values);
  }

  static public Concept cnew(Concepts concepts, String name, Object... values) {
    Class<? extends Concept> cc = findClass(name);
    concepts_unlisted.set(true);
    Concept c;
    try {
      c = cc != null ? nuObject(cc) : new Concept(name);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  static public <A extends Concept> A cnew(Class<A> cc, Object... values) {
    return cnew(db_mainConcepts(), cc, values);
  }

  static public <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
    concepts_unlisted.set(true);
    A c;
    try {
      c = nuObject(cc);
    } finally {
      concepts_unlisted.set(null);
    }
    concepts.register(c);
    csetAll(c, values);
    return c;
  }

  static public String loadConceptsStructure(String progID) {
    return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
  }

  static public String loadConceptsStructure() {
    return loadConceptsStructure(dbProgramID());
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
    return concepts.countConcepts(c, params);
  }

  static public <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    return db_mainConcepts().countConcepts(c, params);
  }

  static public int countConcepts() {
    return db_mainConcepts().countConcepts();
  }

  static public int countConcepts(String className) {
    return db_mainConcepts().countConcepts(className);
  }

  static public <A extends Concept> int countConcepts(Concepts concepts, String className) {
    return concepts.countConcepts(className);
  }

  static public int countConcepts(Concepts concepts) {
    return concepts.countConcepts();
  }

  static public <A> List<A> addDyn_quickSync(List<A> l, A a) {
    if (l == null)
      l = new ArrayList();
    syncAdd(l, a);
    return l;
  }

  static public Str concept(String name) {
    for (Str s : list(Str.class)) if (eqic(s.name, name) || containsIgnoreCase(s.otherNames, name))
      return s;
    return new Str(name);
  }

  static public void removeLast(List l) {
    if (!l.isEmpty())
      l.remove(l(l) - 1);
  }

  static public void removeLast(List l, int n) {
    removeSubList(l, l(l) - n);
  }

  static public void removeLast(int n, List l) {
    removeLast(l, n);
  }

  static public <A> List<A> removeDyn_quickSync(List<A> l, A a) {
    if (l == null)
      return null;
    synchronized (collectionMutex(l)) {
      l.remove(a);
      return empty(l) ? null : l;
    }
  }

  static public Object trimIfString(Object o) {
    return o instanceof String ? trim((String) o) : o;
  }

  static public boolean eqicOneOf(String s, String... l) {
    for (String x : l) if (eqic(s, x))
      return true;
    return false;
  }

  static public boolean isAbstract(Class c) {
    return (c.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public boolean isAbstract(Method m) {
    return (m.getModifiers() & Modifier.ABSTRACT) != 0;
  }

  static public Set<Class> allInterfacesImplementedBy(Class c) {
    if (c == null)
      return null;
    HashSet<Class> set = new HashSet();
    allInterfacesImplementedBy_find(c, set);
    return set;
  }

  static public void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
    if (c.isInterface() && !set.add(c))
      return;
    do {
      for (Class intf : c.getInterfaces()) allInterfacesImplementedBy_find(intf, set);
    } while ((c = c.getSuperclass()) != null);
  }

  static public Method findStaticMethod(Class c, String method, Object... args) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (!m.getName().equals(method))
          continue;
        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static public boolean findStaticMethod_checkArgs(Method m, Object[] args) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length)
      return false;
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
    return true;
  }

  static public List<String> quoteAll(Collection<String> l) {
    List<String> x = new ArrayList();
    for (String s : l) x.add(quote(s));
    return x;
  }

  static public int _hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public boolean arraysEqual(Object[] a, Object[] b) {
    if (a.length != b.length)
      return false;
    for (int i = 0; i < a.length; i++) if (neq(a[i], b[i]))
      return false;
    return true;
  }

  static public String humanizeShortName(Object o) {
    return humanizeLabel(shortName(o));
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public Collection<Concept> conceptsWhere(String c, Object... params) {
    return findConceptsWhere(c, params);
  }

  static public <A extends Concept> Collection<A> conceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    return findConceptsWhere(concepts, c, params);
  }

  static public Object[] mapToParams(Map map) {
    return mapToObjectArray(map);
  }

  static public <A extends Concept> A unlisted(Class<A> c, Object... args) {
    concepts_unlisted.set(true);
    try {
      return nuObject(c, args);
    } finally {
      concepts_unlisted.set(null);
    }
  }

  static public List<String> getFieldOrder(Object o) {
    return getFieldOrder(_getClass(o));
  }

  static public List<String> getFieldOrder(Class c) {
    if (c == null)
      return null;
    return splitAtSpace(toStringOpt(getOpt(c, "_fieldOrder")));
  }

  static public Map conceptToMap_gen_withNullValues(Object c) {
    Map map = litorderedmap("id", str(getLong(c, "id")));
    for (String field : conceptFields_gen(c)) map.put(field, getOpt(c, field));
    return map;
  }

  static public List<Field> nonStaticNonTransientFieldObjectsOfType(Class type, Object o) {
    return filter(nonStaticNonTransientFieldObjects(o), f -> eq(f.getType(), type));
  }

  static public long parseFirstLong(String s) {
    return parseLong(jextract("<int>", s));
  }

  static public void printVars_str(Object... params) {
    String s = "";
    if (odd(l(params))) {
      s = str(first(params));
      if (endsWithLetterOrDigit(s))
        s += ": ";
      params = dropFirst(params);
    }
    print(s + renderVars_str(params));
  }

  static public <A, B> List<B> valuesAsList(Map<A, B> map) {
    return valuesList(map);
  }

  static public String optCastString(Object o) {
    return optCastToString(o);
  }

  static public boolean isSingleLine(String s) {
    return !containsNewLine(s);
  }

  static public boolean isUntrimmed(String s) {
    return neq(s, trim(s));
  }

  static public int cSmartSet(Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (_cSmartSetField(c, (String) values[i], values[i + 1]))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int cSmartSet_withConverter(ValueConverterForField converter, Concept c, Object... values) {
    try {
      if (c == null)
        return 0;
      warnIfOddCount(values = expandParams(c.getClass(), values));
      int changes = 0;
      for (int i = 0; i + 1 < l(values); i += 2) if (cSmartSetField_withConverter(c, (String) values[i], values[i + 1], converter))
        ++changes;
      return changes;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public long toLong(Object o) {
    if (o instanceof Number)
      return ((Number) o).longValue();
    if (o instanceof String)
      return parseLong((String) o);
    return 0;
  }

  static public void deleteConcept(long id) {
    db_mainConcepts().deleteConcept(id);
  }

  static public void deleteConcept(Concepts concepts, long id) {
    concepts.deleteConcept(id);
  }

  static public void deleteConcept(Concept c) {
    if (c != null)
      c.delete();
  }

  static public void deleteConcept(Concept.Ref ref) {
    if (ref != null)
      deleteConcept(ref.get());
  }

  static public <A, B> Map<A, B> orderedMapPutOrCreate(Map<A, B> map, A key, B value) {
    if (key != null && value != null) {
      if (map == null)
        map = new LinkedHashMap();
      map.put(key, value);
    }
    return map;
  }

  static public <A> A trueFalseNull(Boolean b, A onTrue, A onFalse, A onNull) {
    return b == null ? onNull : b.booleanValue() ? onTrue : onFalse;
  }

  static public Class getTypeArgumentAsClass(Type type) {
    if (type instanceof ParameterizedType)
      return typeToClass(first(((ParameterizedType) type).getActualTypeArguments()));
    return null;
  }

  static public Type genericFieldType(Object o, String field) {
    Field f = getField(o, field);
    return f == null ? null : f.getGenericType();
  }

  static public long conceptID(Concept c) {
    return c == null ? 0 : c.id;
  }

  static public String firstWhereFirstLongIs(Collection<String> l, long i) {
    return firstThat(l, s -> parseFirstLong(s) == i);
  }

  static public <A> List<A> itemPlus(A a, Collection<A> l) {
    return itemPlusList(a, l);
  }

  static public boolean hasBackRefs(Concept c) {
    return c != null && syncNempty(c.backRefs);
  }

  static public <A> A syncPopFirst(List<A> l) {
    if (empty(l))
      return null;
    synchronized (l) {
      A a = first(l);
      l.remove(0);
      return a;
    }
  }

  static public int hashOfLong(long l) {
    return Long.hashCode(l);
  }

  static public int length(Object[] array) {
    return array == null ? 0 : array.length;
  }

  static public int length(List list) {
    return list == null ? 0 : list.size();
  }

  static public int length(String s) {
    return s == null ? 0 : s.length();
  }

  static public float score(Scored s) {
    return s == null ? 0 : s.score();
  }

  static public String formatDouble_significant2(double d, int digits) {
    try {
      digits -= max(0, Math.floor(Math.log10(abs(d)) + 1));
      return formatDouble(d, digits);
    } catch (Throwable _e) {
      print("Had number: " + d + ", digits: " + digits);
      throw rethrow(_e);
    }
  }

  static public int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  static public String plural(String s) {
    return getPlural(s);
  }

  static public <A extends Component> A maximizeFrame(A c) {
    JFrame f = swing(new F0<JFrame>() {

      public JFrame get() {
        try {
          JFrame f = getFrame(c);
          if (f != null)
            f.setExtendedState(JFrame.MAXIMIZED_BOTH);
          return f;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JFrame f = getFrame(c);\r\n    if (f != null)\r\n      f.setExtendedState(JFrame....";
      }
    });
    if (f != null && !isAWTThread()) {
      Dimension d = maximumWindowBounds().getSize();
      long start = sysNow();
      while (licensed()) {
        try {
          if (f.getWidth() >= d.getWidth() - 100 && f.getHeight() >= d.getHeight() - 100)
            break;
          if (sysNow() >= start + 100) {
            warn("maximizeFrame timeout");
            break;
          }
        } catch (Throwable __e) {
          _handleException(__e);
        }
        sleep(1);
      }
    }
    return c;
  }

  static volatile public boolean framesBot_has = false;

  static public Android3 framesBot() {
    if (framesBot_has)
      return null;
    framesBot_has = true;
    Android3 android = new Android3();
    android.greeting = programIDPlusHome() + " Frames.";
    android.console = false;
    android.responder = new Responder() {

      public String answer(String s, List<String> history) {
        if (match("activate frames", s)) {
          swingLater(new Runnable() {

            public void run() {
              try {
                activateMyFrames();
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "// prevent blocking when called from same program's AWT thread\r\n          act...";
            }
          });
          return "OK, activating " + programName();
        }
        return null;
      }
    };
    return makeBot(android);
  }

  static public ThreadLocal<List<String>> showConceptsTable_dropFields = new ThreadLocal();

  static public ThreadLocal showConceptsTable_postProcess = new ThreadLocal();

  static public ThreadLocal showConceptsTable_afterUpdate = new ThreadLocal();

  static public ThreadLocal<Concepts> showConceptsTable_concepts = new ThreadLocal();

  static public ThreadLocal<Boolean> showConceptsTable_latestFirst = new ThreadLocal();

  static public ThreadLocal<Object> showConceptsTable_sorter = new ThreadLocal();

  static public int makeConceptsTable_idWidth = 50;

  static public JTable showConceptsTable(Class<? extends Concept> c) {
    JTable table = makeConceptsTable(c);
    showFrame(plural(shortClassName(c)), table);
    return table;
  }

  static public JTable makeConceptsTable(final Class<? extends Concept> c) {
    List<String> dropFields = getAndClearThreadLocal(showConceptsTable_dropFields);
    final Object pp = getAndClearThreadLocal(showConceptsTable_postProcess);
    final Object afterUpdate = optParam(showConceptsTable_afterUpdate);
    final Concepts concepts = optParam(showConceptsTable_concepts, db_mainConcepts());
    final boolean latestFirst = boolParam(showConceptsTable_latestFirst);
    Object sorter = optParam(showConceptsTable_sorter);
    final List<String> fields = listMinusList(concatLists(ll("id"), conceptFieldsInOrder(c)), dropFields);
    final JTable table = sexyTable();
    tablePopupMenu(table, new VF2<JPopupMenu, Integer>() {

      public void get(JPopupMenu menu, final Integer row) {
        try {
          addMenuItem(menu, "Delete", new Runnable() {

            public void run() {
              try {
                final long id = toLong(getTableCell(table, row, 0));
                deleteConcept_sync(concepts, id);
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "final long id = toLong(getTableCell(table, row, 0));\r\n      deleteConcept_syn...";
            }
          });
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "addMenuItem(menu, \"Delete\", r {\r\n      final long id = toLong(getTableCell(ta...";
      }
    });
    AutoCloseable __1 = tempSetTL(awtOnConceptChanges_concepts, concepts);
    try {
      awtOnConceptChanges(table, new Runnable() {

        public void run() {
          try {
            List<List> data = new ArrayList();
            Collection<? extends Concept> l = list(concepts, c);
            if (sorter != null)
              l = (Collection) callF(sorter, l);
            for (Concept cc : l) data.add(map(new F1<String, Object>() {

              public Object get(String field) {
                try {
                  return renderForTable(cget(cc, field));
                } catch (Exception __e) {
                  throw rethrow(__e);
                }
              }

              public String toString() {
                return "renderForTable(cget(cc, field))";
              }
            }, fields));
            if (latestFirst)
              reverseInPlace(data);
            data = (List) postProcess(pp, data);
            fillTableWithData(table, data, map("humanizeFormLabel", fields));
            if (table.getColumnCount() > 0)
              table.getColumnModel().getColumn(0).setMaxWidth(makeConceptsTable_idWidth);
            pcallF(afterUpdate, table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "//print(\"Updating concept table\");\r\n    new List<List> data;\r\n    Collection<...";
        }
      }, true);
      return table;
    } finally {
      _close(__1);
    }
  }

  static public <A extends Concept> JTable makeConceptsTable(final Class<A> cClass, final Object renderer) {
    if (renderer == null)
      return makeConceptsTable(cClass);
    final Object pp = optParam(showConceptsTable_postProcess);
    final Object afterUpdate = optParam(showConceptsTable_afterUpdate);
    final Concepts concepts = optParam(showConceptsTable_concepts, db_mainConcepts());
    final boolean latestFirst = boolParam(showConceptsTable_latestFirst);
    Object sorter = optParam(showConceptsTable_sorter);
    final JTable table = sexyTable();
    AutoCloseable __2 = tempSetTL(awtOnConceptChanges_concepts, concepts);
    try {
      awtOnConceptChanges(table, 1000, new Runnable() {

        public void run() {
          try {
            List<Map> data = new ArrayList();
            Collection<A> l = list(concepts, cClass);
            if (sorter != null)
              l = (Collection) callF(sorter, l);
            for (A c : l) addIfNotNull(data, (Map) pcallF(renderer, c));
            if (latestFirst)
              reverseInPlace(data);
            data = (List) postProcess(pp, data);
            dataToTable_uneditable(data, table);
            pcallF(afterUpdate, table);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "new List<Map> data;\r\n    Collection<A> l = list(concepts, cClass);\r\n    if (s...";
        }
      });
      return table;
    } finally {
      _close(__2);
    }
  }

  static public <A extends Concept> JTable showConceptsTable(final Class<A> c, final Object f) {
    JTable table = makeConceptsTable(c, f);
    showFrame(plural(shortClassName(c)), table);
    return table;
  }

  static public <A extends Concept> JTable showConceptsTable(String title, Class<A> cClass, Object f) {
    return setFrameTitle(title, showConceptsTable(cClass, f));
  }

  static public JPanel jRightAlignedLine(Component... components) {
    return jrightAlignedLine(components);
  }

  static public JPanel jRightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(components);
  }

  static public JButton tableDependButton(JTable tbl, JButton b) {
    tableDependButtons(tbl, ll(b));
    return b;
  }

  static public JButton tableDependButton(JTable tbl, String text, Object action) {
    return tableDependButton(tbl, jbutton(text, action));
  }

  static public <A extends Concept> A selectedConcept(JTable table, Class<A> cc) {
    return (A) getConcept(toLong(selectedTableCell(table, 0)));
  }

  static public JPanel centerAndSouthWithMargin(Component c, Component s) {
    return centerAndSouth(c, withTopMargin(s));
  }

  static public <A extends Concept> A ccopyFieldsExcept(Concept x, A y, Set<String> dontCopyFields) {
    if (x == null || y == null)
      return y;
    return ccopyFields2(x, y, setMinusSet(conceptFields(x), dontCopyFields));
  }

  static public AutoCloseable tempSetMCOpt(final String field, Object value) {
    final Object oldValue = getMCOpt(field);
    setMCOpt(field, value);
    return new AutoCloseable() {

      public String toString() {
        return "setMCOpt(field, oldValue);";
      }

      public void close() throws Exception {
        setMCOpt(field, oldValue);
      }
    };
  }

  static public JPanel showFormTitled2(String title, Object... parts) {
    return showFormTitled_customLayout(formLayouter1(), title, parts);
  }

  static public Object[] arrayPlus(Object[] a1, Object... a2) {
    return concatArrays(a1, a2);
  }

  static public Object[] mapToObjectArray(Map map) {
    List l = new ArrayList();
    for (Object o : keys(map)) {
      l.add(o);
      l.add(map.get(o));
    }
    return toObjectArray(l);
  }

  static public Object[] mapToObjectArray(Object f, Collection l) {
    int n = l(l);
    Object[] array = new Object[n];
    if (n != 0) {
      Iterator it = iterator(l);
      for (int i = 0; i < n; i++) array[i] = callF(f, it.next());
    }
    return array;
  }

  static public Object[] mapToObjectArray(Object f, Object[] l) {
    int n = l(l);
    Object[] array = new Object[n];
    for (int i = 0; i < n; i++) array[i] = callF(f, l[i]);
    return array;
  }

  static public <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
    return mapToObjectArray(f, l);
  }

  static public int tableRowCount(JTable table) {
    return tableRows(table);
  }

  static public Class getFieldType(Object o, String field) {
    return fieldType(o, field);
  }

  static public JCheckBox jCenteredCheckBox() {
    return centerCheckBox(new JCheckBox());
  }

  static public JCheckBox jCenteredCheckBox(boolean checked) {
    return centerCheckBox(new JCheckBox("", checked));
  }

  static public JCheckBox jCenteredCheckBox(String text, boolean checked) {
    return centerCheckBox(new JCheckBox(text, checked));
  }

  static public JCheckBox jCenteredCheckBox(String text) {
    return centerCheckBox(new JCheckBox(text));
  }

  static public JCheckBox jCenteredCheckBox(String text, boolean checked, final Object onChange) {
    return centerCheckBox(jCheckBox(text, checked, onChange));
  }

  static public JCheckBox jCenteredCheckBox(boolean checked, final Object onChange) {
    return centerCheckBox(jCheckBox(checked, onChange));
  }

  static public JTextArea typeWriterTextArea() {
    return newTypeWriterTextArea();
  }

  static public JTextArea typeWriterTextArea(String text) {
    return newTypeWriterTextArea(text);
  }

  static public boolean isSubtype(Class a, Class b) {
    return isSubclass(a, b);
  }

  static public JComboBox jcomboboxFromConcepts_str(Class<? extends Concept> cc) {
    return jcomboboxFromConcepts_str(db_mainConcepts(), cc);
  }

  static public JComboBox jcomboboxFromConcepts_str(Concepts concepts, Class<? extends Concept> cc) {
    return jcomboboxFromConcepts_str(concepts, cc, null);
  }

  static public JComboBox jcomboboxFromConcepts_str(Concepts concepts, Class<? extends Concept> cc, Concept selected) {
    List<String> items = ll("");
    String selectedItem = null;
    for (Concept c : list(concepts, cc)) {
      String item = c.id + " - " + c;
      if (c == selected)
        selectedItem = item;
      items.add(item);
    }
    return jcombobox(items, selectedItem);
  }

  static public JPasswordField jpassword() {
    return jpassword("");
  }

  static public JPasswordField jpassword(final String pw) {
    return swing(new F0<JPasswordField>() {

      public JPasswordField get() {
        try {
          return new JPasswordField(pw);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JPasswordField(pw);";
      }
    });
  }

  static public <A> A getVar(IF0<A> v) {
    return v == null ? null : v.get();
  }

  static public AutoComboBox autoComboBox() {
    return autoComboBox(new ArrayList());
  }

  static public AutoComboBox autoComboBox(final Collection<String> items) {
    return swing(new F0<AutoComboBox>() {

      public AutoComboBox get() {
        try {
          AutoComboBox cb = new AutoComboBox();
          cb.setKeyWord(items);
          return cb;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "new AutoComboBox cb;\r\n    cb.setKeyWord(items);\r\n    ret cb;";
      }
    });
  }

  static public AutoComboBox autoComboBox(String value, Collection<String> items) {
    return setText(autoComboBox(items), value);
  }

  static public JComponent unwrap(JComponent c) {
    return c instanceof JScrollPane ? unwrapScrollPane((JScrollPane) c) : c;
  }

  static public Object convertToField(Object o, Class c, String field) {
    Field f = setOpt_findField(c, field);
    if (f == null)
      return o;
    Class t = f.getType();
    if (t == Long.class || t == long.class)
      return toLong(o);
    else if (t == Integer.class || t == int.class)
      return toInt(o);
    else if (t == Float.class || t == float.class)
      return toFloat(o);
    else if (t == Double.class || t == double.class)
      return toDouble(o);
    else if (t == String.class)
      return o instanceof String ? (String) o : str(o);
    else if (t == File.class) {
      if (o instanceof String)
        return new File((String) o).getAbsoluteFile();
    } else if (t == GlobalID.class && o instanceof String)
      return new GlobalID((String) o);
    return o;
  }

  static public String trimIf(boolean b, String s) {
    return b ? trim(s) : s;
  }

  static public void cUpdatePNGFile(Concept c, String field, BufferedImage image, boolean deleteOldFile) {
    PNGFile png = (PNGFile) (cget(c, field));
    if (image == null && png != null)
      cset(c, field, null);
    else if (image != null && (png == null || !imagesIdentical(png.getImage(), image))) {
      if (png != null && deleteOldFile)
        png.delete();
      cset(c, field, new PNGFile(image));
    }
  }

  static public Set<String> fields(Object c) {
    return listFields(c);
  }

  static public List<String> conceptFieldsInOrder(Concept c) {
    return conceptFieldsInOrder(c.getClass());
  }

  static public List<String> conceptFieldsInOrder(Class<? extends Concept> c) {
    String order = toStringOpt(getOpt(c, "_fieldOrder"));
    Set<String> set = asTreeSet(conceptFields(c));
    if (order == null)
      return asList(set);
    List<String> fields = splitAtSpace(order);
    setAddAll(fields, set);
    return fields;
  }

  static public <A> Set<A> setPlus(Collection<A> l, A... more) {
    Set<A> set = similarEmptySet(l);
    addAll(set, l);
    for (A a : more) set.add(a);
    return set;
  }

  static public <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
    return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
  }

  static public BufferedImage toBufferedImage(Object o) {
    return toBufferedImageOpt(o);
  }

  static public RuntimeException unimplemented() {
    throw fail("TODO");
  }

  static public RuntimeException unimplemented(String msg) {
    throw fail("TODO: " + msg);
  }

  static public String spanTitle(String title, Object contents) {
    return empty(title) ? str(contents) : span(contents, "title", title);
  }

  static public String htmlencode2(String s) {
    return htmlencode_noQuotes(s);
  }

  static public String humanizeLabel(String s) {
    return humanizeFormLabel(s);
  }

  static public String h1_title(String s) {
    return htitle_h1(s);
  }

  static public String appendSlash(String s) {
    return addSlash(s);
  }

  static public String hrefresh(String target) {
    return hrefresh(0, target);
  }

  static public String hrefresh(double seconds) {
    return hrefresh(seconds, "");
  }

  static public String hrefresh(double seconds, String target) {
    return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
  }

  static public String addAnchorToURL(String url, String anchor) {
    int i = smartIndexOf(url, '#');
    url = takeFirst(url, i);
    if (nempty(anchor))
      url += "#" + anchor;
    return url;
  }

  static public String htmlEncode_nlToBr(String s) {
    return nlToBr(htmlEncode2(s));
  }

  static public long waitForBotStartUp_timeoutSeconds = 60;

  static public String waitForBotStartUp(String botName) {
    for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
      sleepSeconds(i == 0 ? 0 : 1);
      String addr = getBotAddress(botName);
      if (addr != null)
        return addr;
    }
    throw fail("Bot not found: " + quote(botName));
  }

  static public Object rpc(String botName, String method, Object... args) {
    return unstructure_matchOK2OrFail(sendToLocalBot(botName, rpc_makeCall(method, args)));
  }

  static public Object rpc(DialogIO bot, String method, Object... args) {
    return unstructure_matchOK2OrFail(bot.ask(rpc_makeCall(method, args)));
  }

  static public String rpc_makeCall(String method, Object... args) {
    if (empty(args))
      return "call " + method;
    return format("call *", concatLists((List) ll(method), asList(args)));
  }

  static public <A extends Concept> A uniq(Class<A> c, Object... params) {
    return uniqueConcept(c, params);
  }

  static public <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
    return uniqueConcept(cc, c, params);
  }

  static public void close(AutoCloseable c) {
    _close(c);
  }

  static public <A extends JComponent> A setDoubleBuffered(A c, boolean b) {
    {
      swing(new Runnable() {

        public void run() {
          try {
            if (c != null)
              c.setDoubleBuffered(b);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c?.setDoubleBuffered(b);";
        }
      });
    }
    return c;
  }

  static public String ok(Object o) {
    return format("ok *", o);
  }

  static public <A> List<A> reversedList(Collection<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  static public <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
    return map == null ? new TreeSet() : map.navigableKeySet();
  }

  static public <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }

  static public <A, B> Set<A> keySet(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  static public Set keySet(Object map) {
    return keys((Map) map);
  }

  static public <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }

  static public String pageNav2(String baseLink, int count, int value, int step, String nVar, Object... __) {
    List<String> l = new ArrayList();
    baseLink = unnull(baseLink) + (contains(baseLink, "?") ? "&" : "?") + urlencode(nVar) + "=";
    if (value > 0)
      l.add(ahref(baseLink + max(0, value - step), stringPar("leftArrow", __, htmlencode(unicode_leftPointingTriangle()))));
    for (int i = 0; i < count; i += step) {
      int n = i / step + 1;
      if (pageNav2_showPage(value, i, step, count))
        if (value == i)
          l.add(b(n));
        else
          l.add(ahref(baseLink + i, n));
    }
    if (value + step < count)
      l.add(ahref(baseLink + (value + step), stringPar("rightArrow", __, htmlencode(unicode_rightPointingTriangle()))));
    return p("Pages: " + lines(l));
  }

  static public boolean pageNav2_showPage(int actual, int i, int step, int count) {
    int diff = abs(actual - i) / step;
    return i == 0 || i >= (count - 1) / step * step || diff <= 10 || diff < 100 && ((i / step) % 10) == 9 || ((i / step) % 100) == 99;
  }

  static public IntRange intRange(int start, int end) {
    return new IntRange(start, end);
  }

  static public boolean containsInstance(Iterable i, Class c) {
    if (i != null)
      for (Object o : i) if (isInstanceX(c, o))
        return true;
    return false;
  }

  static public String defaultFrameTitle() {
    return autoFrameTitle();
  }

  static public void defaultFrameTitle(String title) {
    autoFrameTitle_value = title;
  }

  static public void registerEscape(JFrame frame, final Runnable r) {
    registerEscape_rootPane(frame.getRootPane(), r);
  }

  static public void inputFilePath(final String msg, final Object action) {
    inputFilePath(msg, userDir(), action);
  }

  static public void inputFilePath(final String msg, final File defaultFile, final Object action) {
    swingLater(new Runnable() {

      public void run() {
        try {
          final JTextField tfPath = jtextfield(f2s(or(defaultFile, userDir())));
          String title = joinStrings(" | ", msg, programName());
          JComponent form = showFormTitled(title, unnull(msg), centerAndEast(tfPath, jbutton("Browse...", new Runnable() {

            public void run() {
              try {
                JFileChooser fileChooser = new JFileChooser(getTextTrim(tfPath));
                if (fileChooser.showOpenDialog(tfPath) == JFileChooser.APPROVE_OPTION) {
                  tfPath.setText(fileChooser.getSelectedFile().getAbsolutePath());
                  tfPath.requestFocus();
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "JFileChooser fileChooser = new JFileChooser(getTextTrim(tfPath));\r\n        if...";
            }
          })), new Runnable() {

            public void run() {
              try {
                callF(action, new File(getTextTrim(tfPath)));
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "callF(action, new File(getTextTrim(tfPath)))";
            }
          });
          renameSubmitButton(form, "OK");
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "final JTextField tfPath = jtextfield(f2s(or(defaultFile, userDir())));\r\n    S...";
      }
    });
  }

  static public JComponent selectSnippetID_v1(final VF1<String> onSelect) {
    return selectSnippetID_v1("#", onSelect);
  }

  static public JComponent selectSnippetID_v1(String defaultID, final VF1<String> onSelect) {
    final JTextField tfSnippetID = jtextfield(defaultID);
    if (eq(defaultID, "#"))
      moveCaretToEnd(tfSnippetID);
    JComponent panel;
    renameSubmitButton(panel = showTitledForm("Select Snippet", "Snippet ID:", tfSnippetID, runnableThread(new Runnable() {

      public void run() {
        try {
          callF(onSelect, fsI(getTextTrim(tfSnippetID)));
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "callF(onSelect, fsI(getTextTrim(tfSnippetID)));";
      }
    })), "Select snippet");
    return panel;
  }

  static public BufferedImage cloneBufferedImage(BufferedImage image) {
    return copyImage(image);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rectangle clip) {
    return clipBufferedImage(src, new Rect(clip));
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, Rect r) {
    if (src == null || r == null)
      return null;
    r = intersectRects(r, new Rect(0, 0, src.getWidth(), src.getHeight()));
    if (rectEmpty(r))
      return null;
    return src.getSubimage(r.x, r.y, r.w, r.h);
  }

  static public BufferedImage clipBufferedImage(BufferedImage src, int x, int y, int w, int h) {
    return clipBufferedImage(src, new Rect(x, y, w, h));
  }

  static public Object getTransferData(Transferable t, DataFlavor flavor) {
    try {
      return t != null && t.isDataFlavorSupported(flavor) ? t.getTransferData(flavor) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public BufferedImage imageFromDataURL(String url) {
    String pref = "base64,";
    int i = indexOf(url, pref);
    if (i < 0)
      return null;
    return decodeImage(base64decode(substring(url, i + l(pref))));
  }

  static public String getTextFromClipboard() {
    try {
      Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
      if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor))
        return (String) transferable.getTransferData(DataFlavor.stringFlavor);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public void popupError(final Throwable throwable) {
    throwable.printStackTrace();
    SwingUtilities.invokeLater(new Runnable() {

      public void run() {
        String text = throwable.toString();
        JOptionPane.showMessageDialog(null, text);
      }
    });
  }

  static public ImageSurface jImageSurface() {
    return swingNu(ImageSurface.class);
  }

  static public ImageSurface jImageSurface(MakesBufferedImage img) {
    return swingNu(ImageSurface.class, img.getBufferedImage());
  }

  static public ImageSurface jImageSurface(BufferedImage img) {
    return swingNu(ImageSurface.class, img);
  }

  static public <A extends JComponent> A disposeFrameOnClick(final A c) {
    onClick(c, new Runnable() {

      public void run() {
        try {
          disposeFrame(c);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "disposeFrame(c)";
      }
    });
    return c;
  }

  static public String assertPossibleGlobalID(String s) {
    if (!possibleGlobalID(s))
      throw fail("Not an acceptable global ID: " + s);
    return s;
  }

  static public char charPlus(char a, int b) {
    return (char) (((int) a) + b);
  }

  static public int mod(int n, int m) {
    return (n % m + m) % m;
  }

  static public long mod(long n, long m) {
    return (n % m + m) % m;
  }

  static public BigInteger mod(BigInteger n, int m) {
    return n.mod(bigint(m));
  }

  static public double mod(double n, double m) {
    return (n % m + m) % m;
  }

  static public String div(Object contents, Object... params) {
    return hfulltag("div", contents, params);
  }

  static public BigInteger div(BigInteger a, BigInteger b) {
    return a.divide(b);
  }

  static public BigInteger div(BigInteger a, int b) {
    return a.divide(bigint(b));
  }

  static public String href(String link, Object contents, Object... params) {
    if (link == null)
      return str(contents);
    return tag("a", contents, arrayPlus(params, "href", link));
  }

  static public String jsQuote(String s) {
    return javascriptQuote(s);
  }

  static public String span(Object contents, Object... params) {
    return tag("span", contents, params);
  }

  static public String nlToBr_withIndents(String s) {
    s = nlToBr(s);
    StringBuilder buf = new StringBuilder();
    int i = 0;
    while (i < l(s)) {
      while (charAt(s, i) == ' ') {
        ++i;
        buf.append("&nbsp;");
      }
      int j = smartIndexOf(s, i, '\n') + 1;
      buf.append(substring(s, i, j));
      i = j;
    }
    return str(buf);
  }

  static public String htmlEncode(String s) {
    return htmlencode(s);
  }

  static public int cmpAlphaNum(String a, String b) {
    return alphaNumComparator().compare(a, b);
  }

  static public String reversedString(String s) {
    return reverseString(s);
  }

  static public <A, B, C, D> Map<C, D> mapMapToMap(IF2<A, B, Pair<C, D>> f, Map<A, B> m) {
    if (m == null)
      return null;
    Map<C, D> map = similarEmptyMap(m);
    for (Map.Entry<A, B> e : m.entrySet()) {
      Pair<C, D> p = f.get(e.getKey(), e.getValue());
      map.put(p.a, p.b);
    }
    return map;
  }

  static public <A, B, C, D> Map<C, D> mapMapToMap(Map<A, B> m, IF2<A, B, Pair<C, D>> f) {
    return mapMapToMap(f, m);
  }

  static public Object[] concatArrays(Object[]... arrays) {
    int l = 0;
    for (Object[] a : arrays) l += l(a);
    Object[] x = new Object[l];
    int i = 0;
    for (Object[] a : arrays) if (a != null) {
      System.arraycopy(a, 0, x, i, l(a));
      i += l(a);
    }
    return x;
  }

  static public String unicode_downPointingTriangle() {
    return charToString(0x25BC);
  }

  static public String unicode_upPointingTriangle() {
    return charToString(0x25B2);
  }

  static public ThreadLocal htmlTable2_cellEncoder = new ThreadLocal();

  static public String htmlTable2(Object data, Object... __) {
    boolean htmlEncode = optPar("htmlEncode", __, true);
    boolean useBr = boolPar("useBr", __);
    Map<String, Object[]> paramsByColName = (Map<String, Object[]>) (optPar("paramsByColName", __));
    Object[] tableParams = (Object[]) (optPar("tableParams", __));
    Object[] trParams = (Object[]) (optPar("trParams", __));
    Object[] tdParams = (Object[]) (optPar("tdParams", __));
    Map<String, String> replaceHeaders = (Map<String, String>) (optPar("replaceHeaders", __));
    List<List<String>> rows = new ArrayList();
    List<String> cols = new ContentsIndexedList();
    if (data instanceof List) {
      for (Object x : (List) data) {
        try {
          rows.add(dataToTable_makeRow(x, cols));
        } catch (Throwable __e) {
          _handleException(__e);
        }
      }
    } else if (data instanceof Map) {
      Map map = (Map) data;
      for (Object key : map.keySet()) {
        Object value = map.get(key);
        rows.add(litlist(structureOrText(key), structureOrText(value)));
      }
    } else
      print("Unknown data type: " + data);
    int w = 0;
    for (List<String> row : rows) w = max(w, l(row));
    StringBuilder buf = new StringBuilder();
    buf.append(hopeningtag("table", paramsPlus(tableParams, "border", html_valueLessParam())) + "\n");
    buf.append("<tr>\n");
    for (String cell : padList(cols, w, "")) buf.append("  <th>" + htmlTable2_encodeCell(getOrKeep(replaceHeaders, cell), htmlEncode, useBr) + "</th>\n");
    buf.append("</tr>\n");
    for (List<String> row : rows) {
      buf.append(hopeningtag("tr", trParams));
      int i = 0;
      for (String cell : padList(row, w, "")) {
        String col = get(cols, i++);
        Object[] params = paramsPlus(tdParams, mapGet(paramsByColName, col));
        buf.append("  " + tag("td", htmlTable2_encodeCell(cell, htmlEncode, useBr), params) + "\n");
      }
      buf.append("</tr>\n");
    }
    buf.append("</table>\n");
    return buf.toString();
  }

  static public String htmlTable2_encodeCell(String cell, boolean useHtmlEncode, boolean useBr) {
    if (htmlTable2_cellEncoder.get() != null)
      return (String) callF(htmlTable2_cellEncoder.get(), cell);
    if (useHtmlEncode)
      cell = htmlEncode2(cell);
    if (useBr)
      cell = nlToBr(cell);
    return cell;
  }

  static public Object[] assertEvenLength(Object[] a) {
    assertTrue(even(l(a)));
    return a;
  }

  static public LinkedHashMap paramsToOrderedMap(Object... params) {
    return asLinkedHashMap(paramsToMap(params));
  }

  static public String rtrim_fromLines(Collection lines) {
    StringBuilder buf = new StringBuilder();
    if (lines != null) {
      boolean first = true;
      for (Object line : lines) {
        if (first)
          first = false;
        else
          buf.append('\n');
        buf.append(str(line));
      }
    }
    return buf.toString();
  }

  static public Object[] paramsPlus_skipFirst(Object[] a1, Object... a2) {
    if (odd(l(a1)))
      return itemPlusArray(first(a1), paramsPlus(dropFirst(a1), a2));
    return paramsPlus(a1, a2);
  }

  static public String htableRaw2(List<? extends List> data, List paramsTable, List paramsTR, List paramsTD) {
    StringBuilder buf = new StringBuilder();
    for (List row : data) {
      buf.append(hopeningTag("tr", toObjectArray(paramsTR)));
      for (Object cell : row) buf.append(htd(cell, toObjectArray(paramsTD))).append("\n");
      buf.append("</tr>\n");
    }
    return htag("table", buf, toObjectArray(paramsTable));
  }

  static public Object[] html_massageAutofocusParam(Object[] params) {
    Object autofocus = optPar("autofocus", params);
    return changeParam(params, "autofocus", eqOneOf(autofocus, true, 1, "1", "autofocus") ? html_valueLessParam() : null);
  }

  static public String hopeningTag(String tag, Map params) {
    return hopeningTag(tag, mapToParams(params));
  }

  static public String hopeningTag(String tag, Object... params) {
    StringBuilder buf = new StringBuilder();
    buf.append("<" + tag);
    for (int i = 0; i < l(params); i += 2) {
      String name = (String) get(params, i);
      Object val = get(params, i + 1);
      if (nempty(name) && val != null) {
        if (val == html_valueLessParam())
          buf.append(" " + name);
        else {
          String s = str(val);
          if (!empty(s))
            buf.append(" " + name + "=" + htmlQuote(s));
        }
      }
    }
    buf.append(">");
    return str(buf);
  }

  static public String htextinput(String name, Object... params) {
    Object value = "";
    if (odd(l(params))) {
      value = params[0];
      params = dropFirst(params);
    }
    params = html_massageAutofocusParam(params);
    return tag("input", "", concatArrays(new Object[] { "type", "text", "name", name, "value", value }, params));
  }

  static public String htextinput(String name) {
    return htextinput(name, "");
  }

  static public String hlabelFor(String id, Object contents) {
    return htag("label", contents, "for", id);
  }

  static public boolean neqic(String a, String b) {
    return !eqic(a, b);
  }

  static public boolean neqic(char a, char b) {
    return !eqic(a, b);
  }

  static public String htmlencode_noQuotes(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '<')
        out.append("&lt;");
      else if (c == '>')
        out.append("&gt;");
      else if (c > 127 || c == '&') {
        int cp = s.codePointAt(i);
        out.append("&#x");
        out.append(intToHex_flexLength(cp));
        out.append(';');
        i += Character.charCount(cp) - 1;
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String unicodeFromCodePoint(int codePoint) {
    return codePointToString(codePoint);
  }

  static public int globalIDLength() {
    return 16;
  }

  static public String hfulltag(String tag) {
    return hfulltag(tag, "");
  }

  static public String hfulltag(String tag, Object contents, Object... params) {
    return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
  }

  static public Object html_valueLessParam_cache;

  static public Object html_valueLessParam() {
    if (html_valueLessParam_cache == null)
      html_valueLessParam_cache = html_valueLessParam_load();
    return html_valueLessParam_cache;
  }

  static public Object html_valueLessParam_load() {
    return new Object();
  }

  static public String hjavascript(String script) {
    return tag("script", script, "type", "text/javascript");
  }

  static public void cancelThread(Thread t) {
    if (t == null)
      return;
    ping();
    synchronized (ping_actions) {
      ping_actions.put(t, "cancelled");
      ping_anyActions = true;
    }
  }

  static public Font getFont(JComponent c) {
    return c == null ? null : swing(new F0<Font>() {

      public Font get() {
        try {
          return c.getFont();
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret c.getFont();";
      }
    });
  }

  static public <A> List<A> asSynchroList(Iterable<A> l) {
    return syncList(cloneList(l));
  }

  static public ListIterator emptyListIterator() {
    return Collections.emptyListIterator();
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker_f0(final F0<A> f) {
    class IFF2 extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = f.get();
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF2();
  }

  static public <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
    List<B> out = new ArrayList();
    if (l != null)
      for (A a : l) addIfNotNull(out, map.get(a));
    return out;
  }

  static public <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
    return lookupAllOpt(map, l);
  }

  static public <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
    return findConceptWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          for (A x : index.getAll(params[i + 1])) if (checkConceptFields(x, params))
            return x;
          return null;
        }
      }
    for (A x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public Concept findConceptWhere(Concepts concepts, String c, Object... params) {
    for (Concept x : concepts.list(c)) if (checkConceptFields(x, params))
      return x;
    return null;
  }

  static public boolean cic(Collection<String> l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(String[] l, String s) {
    return containsIgnoreCase(l, s);
  }

  static public boolean cic(String s, char c) {
    return containsIgnoreCase(s, c);
  }

  static public boolean cic(String a, String b) {
    return containsIgnoreCase(a, b);
  }

  static public boolean boolPar(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolPar(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Object[] __) {
    return boolOptParam(__, name);
  }

  static public boolean boolPar(String name, Map __) {
    return boolOptParam(name, __);
  }

  static public boolean boolPar(String name, Object[] params, boolean defaultValue) {
    return optParam(params, name, defaultValue);
  }

  static public File conceptsFile(String progID) {
    return getProgramFile(progID, conceptsFileName());
  }

  static public File conceptsFile() {
    return conceptsFile(dbProgramID());
  }

  static public <A> A lastThat(List<A> l, Object pred) {
    for (int i = l(l) - 1; i >= 0; i--) {
      A a = l.get(i);
      if (checkCondition(pred, a))
        return a;
    }
    return null;
  }

  static public <A> A lastThat(Object pred, List<A> l) {
    return lastThat(l, pred);
  }

  static public <A> A lastThat(IF1<A, Boolean> pred, List<A> l) {
    return lastThat((Object) pred, l);
  }

  static public <A> A lastThat(List<A> l, IF1<A, Boolean> pred) {
    return lastThat(pred, l);
  }

  static public boolean fileNotEmpty(File f) {
    return isFile(f) && fileSize(f) > 0;
  }

  static public List<File> sortByFileName(List<File> l) {
    return sortFilesByName(l);
  }

  static public List<File> conceptBackupFiles(String progID) {
    String regexp = "^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)$";
    File dir = programDir(progID);
    List<File> l = new ArrayList();
    for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
      String s = f.getName();
      String originalName = regexpFirstGroup(regexp, s);
      {
        if (!(eq(originalName, "concepts.structure.gz")))
          continue;
      }
      l.add(f);
    }
    return sortFilesByNameDesc(l);
  }

  static public String stringIf(boolean b, String s) {
    return stringIfTrue(b, s);
  }

  static public void clearConceptsOf(String progID) {
    getProgramFile(progID, "concepts.structure").delete();
    getProgramFile(progID, "concepts.structure.gz").delete();
    getProgramFile(progID, "idCounter.structure").delete();
  }

  static public Lock saveLock_lock = fairLock();

  static public Lock saveLock() {
    return saveLock_lock;
  }

  static public String formatDouble(double d, int digits) {
    String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
    return decimalFormatEnglish(format, d);
  }

  static public double toM_double(long l) {
    return l / (1024 * 1024.0);
  }

  public static String rtrimSpaces(String s) {
    if (s == null)
      return null;
    int i = s.length();
    while (i > 0 && " \t".indexOf(s.charAt(i - 1)) >= 0) --i;
    return i < s.length() ? s.substring(0, i) : s;
  }

  static public java.util.Calendar calendarFromTime(long time, TimeZone tz) {
    java.util.Calendar c = java.util.Calendar.getInstance(tz);
    c.setTimeInMillis(time);
    return c;
  }

  static public java.util.Calendar calendarFromTime(long time) {
    java.util.Calendar c = java.util.Calendar.getInstance();
    c.setTimeInMillis(time);
    return c;
  }

  static public String dynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return "main$" + ((DynamicObject) o).className;
    return className(o);
  }

  static public HashMap<String, Class> findClass_cache = new HashMap();

  static public Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  static public int csetAll(Concept c, Object... values) {
    return cset(c, values);
  }

  static public int csetAll(Iterable<? extends Concept> l, Object... values) {
    int n = 0;
    for (Concept c : unnull(l)) n += cset(c, values);
    return n;
  }

  static public String loadTextFilePossiblyGZipped(String fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
    File gz = new File(fileName + ".gz");
    return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
  }

  static public String loadTextFilePossiblyGZipped(File fileName) {
    return loadTextFilePossiblyGZipped(fileName, null);
  }

  static public String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
    return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
  }

  static public String dbProgramID() {
    return getDBProgramID();
  }

  static public String shortName(Object o) {
    return shortClassName(o);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public Collection<Concept> findConceptsWhere(String c, Object... params) {
    return findConceptsWhere(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
    params = expandParams(c, params);
    if (concepts.fieldIndices != null)
      for (int i = 0; i < l(params); i += 2) {
        IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
        if (index != null) {
          Collection<A> rawList = index.getAll(params[i + 1]);
          params = dropEntryFromParams(params, i);
          if (params == null)
            return rawList;
          List<A> l = new ArrayList();
          for (A x : rawList) if (checkConceptFields(x, params))
            l.add(x);
          return l;
        }
      }
    return filterConcepts(concepts.list(c), params);
  }

  static public Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
    return filterConcepts(concepts.list(c), params);
  }

  static public long getLong(Object o, String field) {
    return toLong(getOpt(o, field));
  }

  static public long getLong(String field, Object o) {
    return getLong(o, field);
  }

  static public String[] conceptFields_gen_drop = { "className", "fieldValues", "id", "created", "_modified", "refs", "backRefs", "_concepts" };

  static public Set<String> conceptFields_gen(Object c) {
    return setMinus(mergeSets(allNonStaticNonTransientFields(c), keys((Map) getOpt_raw(c, "fieldValues"))), conceptFields_gen_drop);
  }

  static public Set<String> conceptFields_gen(Class c) {
    return setMinus(allNonStaticNonTransientFields(c), conceptFields_gen_drop);
  }

  static public List<Field> nonStaticNonTransientFieldObjects(Object o) {
    if (o == null)
      return null;
    List<Field> fields = new ArrayList();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(makeAccessible(f));
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public String renderVars_str(Object... params) {
    List<String> l = new ArrayList();
    for (int i = 0; i + 1 < l(params); i += 2) l.add(params[i] + "=" + params[i + 1]);
    return trim(joinWithComma(l));
  }

  static public <A, B> List<B> valuesList(Map<A, B> map) {
    return cloneListSynchronizingOn(values(map), map);
  }

  static public String optCastToString(Object o) {
    return o instanceof String ? (String) o : null;
  }

  static public boolean _cSmartSetField(Concept c, String field, Object value) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (f != null && value != null) {
        Class actualType = f.getType();
        Class type = primitiveToBoxedTypeOpt(actualType);
        if (type == Integer.class && !(value instanceof Integer)) {
          if (!setField_trueIfChanged(f, c, toInt(trimIfString(value))))
            return false;
          if (!isTransient(f))
            c.change();
          return true;
        }
        if (type == Boolean.class && value instanceof String)
          if (actualType == Boolean.class && eq(value, ""))
            return _csetField(c, field, null);
          else
            return _csetField(c, field, eqicOneOf((String) value, "1", "true", "yes"));
        if (type == GlobalID.class && value instanceof String)
          return _csetField(c, field, new GlobalID((String) value));
      }
      return _csetField(c, field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public boolean cSmartSetField_withConverter(Concept c, String field, Object value, ValueConverterForField converter) {
    try {
      Field f = setOpt_findField(c.getClass(), field);
      if (f != null) {
        if (converter != null && value != null) {
          OrError<Object> result = converter.convertValue(c, f, value);
          if (result == null)
            throw fail("Unknown conversion " + className(value) + " => " + f);
          if (!result.ok())
            throw fail("Unknown conversion " + className(value) + " => " + f + ": " + result.error());
          value = result.get();
        }
        if (value instanceof List && f.getType() == Concept.RefL.class) {
          ((Concept.RefL) f.get(c)).replaceWithList((List) value);
          return true;
        }
        if (value instanceof Concept && f.getType() == Concept.Ref.class)
          return ((Concept.Ref) f.get(c)).set((Concept) value);
      }
      return _csetField(c, field, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Class typeToClass(Type type) {
    if (type == null)
      return null;
    if (type instanceof Class)
      return ((Class) type);
    if (type instanceof ParameterizedType)
      return optCast(Class.class, ((ParameterizedType) type).getRawType());
    return null;
  }

  static public <A> A firstThat(Iterable<A> l, Object pred) {
    if (l != null)
      for (A a : l) if (checkCondition(pred, a))
        return a;
    return null;
  }

  static public <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
    if (l != null)
      for (A a : l) if (pred.get(a))
        return a;
    return null;
  }

  static public <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
    return firstThat(l, (Object) pred);
  }

  static public <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
    return firstThat(l, pred);
  }

  static public <A> List<A> itemPlusList(A a, Collection<A> l) {
    return concatLists(ll(a), l);
  }

  static public <A> boolean syncNempty(Collection<A> l) {
    return !syncEmpty(l);
  }

  static public Rectangle maximumWindowBounds() {
    return maxWindowBounds();
  }

  static public String programIDPlusHome() {
    return programIDPlusHome(programID(), userHomeIfNotActual());
  }

  static public String programIDPlusHome(String programID, File home) {
    return programIDPlusHome(programID, f2s(home));
  }

  static public String programIDPlusHome(String programID, String home) {
    if (home != null)
      programID += " " + quote(home);
    return programID;
  }

  static public List<JFrame> activateMyFrames() {
    final List<JFrame> l = myFrames();
    {
      swing(new Runnable() {

        public void run() {
          try {
            for (JFrame f : l) activateFrame(f);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (JFrame f : l)\r\n      activateFrame(f);";
        }
      });
    }
    return l;
  }

  static public String programName() {
    return getProgramName();
  }

  static public boolean boolParam(ThreadLocal<Boolean> tl) {
    return boolOptParam(tl);
  }

  static public boolean boolParam(Object[] __, String name) {
    return boolOptParam(__, name);
  }

  static public boolean boolParam(String name, Object[] __) {
    return boolOptParam(name, __);
  }

  static public <A> List<A> listMinusList(Collection<A> l, Collection stuff) {
    if (empty(stuff) && l instanceof List)
      return (List) l;
    List<A> l2 = cloneList(l);
    for (Object o : stuff) l2.remove(o);
    return l2;
  }

  static public void deleteConcept_sync(long id) {
    deleteConcept_sync(db_mainConcepts(), id);
  }

  static public void deleteConcept_sync(Concepts concepts, long id) {
    withDBLock(concepts, new Runnable() {

      public void run() {
        try {
          concepts.deleteConcept(id);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "concepts.deleteConcept(id)";
      }
    });
  }

  static public void deleteConcept_sync(Concept c) {
    if (c != null)
      withDBLock(c._concepts, new Runnable() {

        public void run() {
          try {
            c.delete();
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "c.delete()";
        }
      });
  }

  static public void deleteConcept_sync(Concept.Ref ref) {
    if (ref != null)
      deleteConcept_sync(ref.get());
  }

  static public int awtOnConceptChanges_defaultDelay = 1000;

  static public ThreadLocal<Concepts> awtOnConceptChanges_concepts = new ThreadLocal();

  static public void awtOnConceptChanges(Component component, Object runnable) {
    awtOnConceptChanges(componentToJComponent(component), runnable, true);
  }

  static public void awtOnConceptChanges(JComponent component, final Object runnable, boolean runOnFirstTime) {
    awtOnConceptChanges(component, awtOnConceptChanges_defaultDelay, 0, runnable, runOnFirstTime);
  }

  static public void awtOnConceptChanges(JComponent component, int delay, final Object runnable) {
    awtOnConceptChanges(component, delay, delay, runnable);
  }

  static public void awtOnConceptChanges(JComponent component, int delay, int firstDelay, Object runnable) {
    awtOnConceptChanges(component, delay, firstDelay, runnable, true);
  }

  static public boolean awtOnConceptChanges_debug = false;

  static public void awtOnConceptChanges(JComponent component, int delay, int firstDelay, final Object runnable, final boolean runOnFirstTime) {
    final Concepts concepts = or(awtOnConceptChanges_concepts.get(), db_mainConcepts());
    installTimer(component, delay, firstDelay, new Runnable() {

      public long c = runOnFirstTime ? -1 : concepts.changes;

      public void run() {
        long _c = concepts.changes;
        if (awtOnConceptChanges_debug)
          print("awtOnConceptChanges: " + _c + " / " + c);
        if (_c != c) {
          c = _c;
          call(runnable);
        }
      }
    });
  }

  static public Object renderForTable(Object o) {
    {
      Object __1 = toBufferedImageOpt(o);
      if (__1 != null)
        return __1;
    }
    if (o instanceof String && containsNewLine((String) o))
      return escapeNewLines((String) o);
    return o;
  }

  static public <A> List<A> reverseInPlace(List<A> l) {
    return reverseList(l);
  }

  static public <A> A postProcess(Object f, A a) {
    return callPostProcessor(f, a);
  }

  static public JPanel jrightAlignedLine(final Component... components) {
    return swing(new F0<RightAlignedLine>() {

      public RightAlignedLine get() {
        try {
          return new RightAlignedLine(components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret RightAlignedLine(components);";
      }
    });
  }

  static public JPanel jrightAlignedLine(List<? extends Component> components) {
    return jrightAlignedLine(asArray(Component.class, components));
  }

  static public void tableDependButtons(final JTable table, List<? extends Component> buttons) {
    for (Component c : buttons) if (c instanceof JButton) {
      final JButton b = (JButton) c;
      table.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

        public void valueChanged(ListSelectionEvent e) {
          b.setEnabled(table.getSelectedRow() >= 0);
        }
      });
      b.setEnabled(table.getSelectedRow() >= 0);
    }
  }

  static public JPanel centerAndSouth(final Component c, final Component s) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          if (s != null)
            panel.add(BorderLayout.SOUTH, wrap(s));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public int withTopMargin_defaultWidth = 6;

  static public JPanel withTopMargin(Component c) {
    return withTopMargin(withTopMargin_defaultWidth, c);
  }

  static public JPanel withTopMargin(final int w, final Component c) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel p = new JPanel(new BorderLayout());
          p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
          p.add(c);
          return p;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat...";
      }
    });
  }

  static public <A extends Concept> A ccopyFields2(Concept x, A y, Iterable<String> fields) {
    if (x == null || y == null)
      return y;
    for (String field : unnull(fields)) {
      Object o = cget(x, field);
      if (o != null)
        cset(y, field, o);
    }
    return y;
  }

  static public <A, B extends A> Set<A> setMinusSet(Set<A> l, Collection<B> stuff) {
    if (empty(stuff))
      return l;
    Set<B> set = asSet(stuff);
    Set<A> l2 = similarEmptySet(l);
    for (A a : l) if (!set.contains(a))
      l2.add(a);
    return l2;
  }

  static public <A, B extends A> Set<A> setMinusSet(Collection<A> l, Collection<B> stuff) {
    return setMinusSet(asSet(l), stuff);
  }

  static public String[] conceptFields_drop = { "className", "fieldValues", "id", "created", "_modified", "refs", "backRefs", "_concepts" };

  static public Set<String> conceptFields(Concept c) {
    return setMinus(mergeSets(allNonStaticNonTransientFields(c), keys(c.fieldValues)), conceptFields_drop);
  }

  static public Set<String> conceptFields(Class<? extends Concept> c) {
    return setMinus(allNonStaticNonTransientFields(c), conceptFields_drop);
  }

  static public Object getMCOpt(String field) {
    return getOptMC(field);
  }

  static public void setMCOpt(String field, Object value) {
    setOptMC(field, value);
  }

  static public JPanel showFormTitled_customLayout(final F1<Container, Dimension> layouter, final String title, final Object... parts) {
    return showFormTitled_customArrangement(false, new F1<List<JComponent>, JPanel>() {

      public JPanel get(List<JComponent> components) {
        try {
          return customLayoutPanel(layouter, components);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "customLayoutPanel(layouter, components)";
      }
    }, title, parts);
  }

  static public int formLayouter1_yPlus = 5;

  static public int formLayouter1_fixer2 = 0;

  static public F1<Container, Dimension> formLayouter1() {
    final int yplus = formLayouter1_yPlus, fixer2 = formLayouter1_fixer2;
    return new F1<Container, Dimension>() {

      public Dimension get(Container parent) {
        try {
          List<Component> l = getComponents(parent);
          BitSet bigOnes = new BitSet();
          for (int i = 0; i < l(l); i++) if (containsATextArea(l.get(i)))
            add(bigOnes, i);
          int nBigOnes = bigOnes.cardinality();
          int mandatoryHeight = totalPreferredHeight(listWithoutIndicesInBitSet(l, bigOnes));
          int gap = 4, outerSpacing = 5;
          Dimension size = parent.getSize();
          int gapsAndMargins = outerSpacing * 2 - (l(l) - 1) * gap;
          int totalSpace = size.height - gapsAndMargins - fixer2;
          int liberalSpace = totalSpace - mandatoryHeight;
          double perBigOne = doubleRatio(liberalSpace, nBigOnes);
          double y = outerSpacing;
          for (int i = 0; i < l(l); i++) {
            Component c = l.get(i);
            boolean big = contains(bigOnes, i);
            double h = big ? perBigOne : c.getPreferredSize().height;
            int actualY = iround(y);
            c.setBounds(10, actualY, size.width - outerSpacing * 2, iround(y + h) - actualY);
            y += h + gap;
          }
          Dimension pref = componentsBoundingSize(parent, outerSpacing);
          if (parent.getHeight() == 0)
            pref.height = totalPreferredHeight(l) + gapsAndMargins + yplus;
          return pref;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "L<Component> l = getComponents(parent);\r\n    new BitSet bigOnes;\r\n    for i o...";
      }
    };
  }

  static public JCheckBox centerCheckBox(JCheckBox cb) {
    return setHorizontalAlignment(SwingConstants.CENTER, cb);
  }

  static public JCheckBox jCheckBox() {
    return swingNu(JCheckBox.class);
  }

  static public JCheckBox jCheckBox(boolean checked) {
    return swingNu(JCheckBox.class, "", checked);
  }

  static public JCheckBox jCheckBox(String text, boolean checked) {
    return swingNu(JCheckBox.class, text, checked);
  }

  static public JCheckBox jCheckBox(String text) {
    return swingNu(JCheckBox.class, text);
  }

  static public JCheckBox jCheckBox(String text, boolean checked, final Object onChange) {
    JCheckBox cb = jCheckBox(checked, onChange);
    cb.setText(text);
    return cb;
  }

  static public JCheckBox jCheckBox(boolean checked, final Object onChange) {
    final JCheckBox cb = jCheckBox(checked);
    cb.addChangeListener(new ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        pcallF(onChange, cb.isSelected());
      }
    });
    return cb;
  }

  static public JComboBox jcombobox(final String... items) {
    return swing(new F0<JComboBox>() {

      public JComboBox get() {
        try {
          return new JComboBox(items);
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "ret new JComboBox(items);";
      }
    });
  }

  static public JComboBox jcombobox(Collection<String> items) {
    return jcombobox(toStringArray(items));
  }

  static public JComboBox jcombobox(Collection<String> items, String selectedItem) {
    return selectItem(selectedItem, jcombobox(items));
  }

  static public JComponent unwrapScrollPane(JScrollPane sp) {
    return sp == null ? null : (JComponent) sp.getViewport().getView();
  }

  static public float toFloat(Object o) {
    if (o == null)
      return 0f;
    if (o instanceof Number)
      return ((Number) o).floatValue();
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue() ? 1f : 0f;
    throw fail("Not convertible to float: " + _getClass(o));
  }

  static public boolean imagesIdentical(BufferedImage img1, BufferedImage img2) {
    if (img1 == null)
      return img2 == null;
    if (img2 == null)
      return false;
    int w = img1.getWidth(), h = img1.getHeight();
    if (w != img2.getWidth() || h != img2.getHeight())
      return false;
    for (int y = 0; y < h; y++) for (int x = 0; x < w; x++) if (img1.getRGB(x, y) != img2.getRGB(x, y))
      return false;
    return true;
  }

  static public Set similarEmptySet(Iterable m) {
    if (m instanceof TreeSet)
      return new TreeSet(((TreeSet) m).comparator());
    if (m instanceof LinkedHashSet)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public Set similarEmptySet(Map m) {
    if (m instanceof TreeMap)
      return new TreeSet(((TreeMap) m).comparator());
    if (m instanceof LinkedHashMap)
      return new LinkedHashSet();
    return new HashSet();
  }

  static public BufferedImage toBufferedImageOpt(Object o) {
    if (o instanceof BufferedImage)
      return (BufferedImage) o;
    if (o instanceof MakesBufferedImage)
      return ((MakesBufferedImage) o).getBufferedImage();
    if (o instanceof File)
      if (isImageFile(((File) o)))
        return loadImage2(((File) o));
    String c = getClassName(o);
    if (eqOneOf(c, "main$BWImage", "main$RGBImage"))
      return (BufferedImage) call(o, "getBufferedImage");
    if (eq(c, "main$PNGFile"))
      return (BufferedImage) call(o, "getImage");
    return null;
  }

  static public String htitle_h1(String s) {
    return htitle_noEncode(dropTags(s)) + h1(s);
  }

  static public String addSlash(String s) {
    return empty(s) || s.endsWith("/") ? s : s + "/";
  }

  static public int iceil(double d) {
    return (int) Math.ceil(d);
  }

  static public int smartIndexOf(String s, String sub, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(sub, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, int i, char c) {
    return smartIndexOf(s, c, i);
  }

  static public int smartIndexOf(String s, char c, int i) {
    if (s == null)
      return 0;
    i = s.indexOf(c, min(i, l(s)));
    return i >= 0 ? i : l(s);
  }

  static public int smartIndexOf(String s, String sub) {
    return smartIndexOf(s, sub, 0);
  }

  static public int smartIndexOf(String s, char c) {
    return smartIndexOf(s, c, 0);
  }

  static public <A> int smartIndexOf(List<A> l, A sub) {
    return smartIndexOf(l, sub, 0);
  }

  static public <A> int smartIndexOf(List<A> l, int start, A sub) {
    return smartIndexOf(l, sub, start);
  }

  static public <A> int smartIndexOf(List<A> l, A sub, int start) {
    int i = indexOf(l, sub, start);
    return i < 0 ? l(l) : i;
  }

  static public String nlToBr(String s) {
    return s.replace("\n", "<br>\n");
  }

  static public String getBotAddress(String bot) {
    List<ScannedBot> l = fullBotScan(bot);
    return empty(l) ? null : first(l).address;
  }

  static public Object unstructure_matchOK2OrFail(String s) {
    if (swic(s, "ok "))
      return unstructure_startingAtIndex(s, 3);
    else
      throw fail(s);
  }

  static public <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
    return uniqueConcept(db_mainConcepts(), c, params);
  }

  static public <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
    AutoCloseable __1 = tempDBLock(cc);
    try {
      params = expandParams(c, params);
      A x = findConceptWhere(cc, c, params);
      if (x == null) {
        x = unlisted(c);
        csetAll(x, params);
        cc.register(x);
      }
      return x;
    } finally {
      _close(__1);
    }
  }

  static public String stringPar(Object[] params, String name) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Object[] params) {
    return stringOptPar(params, name);
  }

  static public String stringPar(String name, Map params) {
    return (String) optPar(name, params);
  }

  static public String stringPar(String name, Object[] params, String defaultValue) {
    return optPar(name, params, defaultValue);
  }

  static public String unicode_leftPointingTriangle() {
    return unicodeFromCodePoint(0x25C2);
  }

  static public String b(Object contents, Object... params) {
    return tag("b", contents, params);
  }

  static public String unicode_rightPointingTriangle() {
    return charToString(0x25B8);
  }

  static public Object iteratorFromFunction_endMarker = new Object();

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final Object f) {
    class IFF extends IterableIterator<A> {

      public A a;

      public boolean have, done;

      public boolean hasNext() {
        getNext();
        return !done;
      }

      public A next() {
        getNext();
        if (done)
          throw fail();
        A _a = a;
        a = null;
        have = false;
        return _a;
      }

      public void getNext() {
        if (done || have)
          return;
        Object o = callF(f);
        if (o == iteratorFromFunction_endMarker) {
          done = true;
          return;
        }
        a = (A) o;
        have = true;
      }
    }
    ;
    return new IFF();
  }

  static public <A> IterableIterator<A> iteratorFromFunction_withEndMarker(final F0 f) {
    return iteratorFromFunction_withEndMarker_f0(f);
  }

  static public void registerEscape_rootPane(JComponent rootPane, final Runnable r) {
    String name = "Escape";
    Action action = abstractAction(name, r);
    KeyStroke keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    rootPane.getActionMap().put(name, action);
    rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(keyStroke, name);
  }

  static public JPanel centerAndEast(final Component c, final Component e) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          JPanel panel = new JPanel(new BorderLayout());
          panel.add(BorderLayout.CENTER, wrap(c));
          panel.add(BorderLayout.EAST, wrap(e));
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "JPanel panel = new JPanel(new BorderLayout);\r\n    panel.add(BorderLayout.CENT...";
      }
    });
  }

  static public <A extends JComponent> A renameSubmitButton(A form, String newName) {
    renameButton(form, showFormSubmitButtonName(), newName);
    return form;
  }

  static public <A extends JComponent> A renameSubmitButton(String newName, A form) {
    return renameSubmitButton(form, newName);
  }

  static public <A extends JTextComponent> A moveCaretToEnd(A ta) {
    setCaretPosition(ta, textAreaTextLength(ta));
    return ta;
  }

  static public BufferedImage copyImage(BufferedImage bi) {
    if (bi == null)
      return null;
    ColorModel cm = bi.getColorModel();
    boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
    WritableRaster raster = bi.copyData(bi.getRaster().createCompatibleWritableRaster());
    return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
  }

  static public Rect intersectRects(Rect a, Rect b) {
    int x = max(a.x, b.x), y = max(a.y, b.y);
    int x2 = min(a.x + a.w, b.x + b.w), y2 = min(a.y + a.h, b.y + b.h);
    return new Rect(x, y, x2 - x, y2 - y);
  }

  static public boolean rectEmpty(Rect r) {
    return r == null || r.w <= 0 || r.h <= 0;
  }

  static public BufferedImage decodeImage(byte[] data) {
    try {
      return ImageIO.read(new ByteArrayInputStream(data));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public byte[] base64decode(String s) {
    byte[] alphaToInt = base64decode_base64toint;
    int sLen = s.length();
    int numGroups = sLen / 4;
    if (4 * numGroups != sLen)
      throw new IllegalArgumentException("String length must be a multiple of four.");
    int missingBytesInLastGroup = 0;
    int numFullGroups = numGroups;
    if (sLen != 0) {
      if (s.charAt(sLen - 1) == '=') {
        missingBytesInLastGroup++;
        numFullGroups--;
      }
      if (s.charAt(sLen - 2) == '=')
        missingBytesInLastGroup++;
    }
    byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
    int inCursor = 0, outCursor = 0;
    for (int i = 0; i < numFullGroups; i++) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch3 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      result[outCursor++] = (byte) ((ch2 << 6) | ch3);
    }
    if (missingBytesInLastGroup != 0) {
      int ch0 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      int ch1 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
      result[outCursor++] = (byte) ((ch0 << 2) | (ch1 >> 4));
      if (missingBytesInLastGroup == 1) {
        int ch2 = base64decode_base64toint(s.charAt(inCursor++), alphaToInt);
        result[outCursor++] = (byte) ((ch1 << 4) | (ch2 >> 2));
      }
    }
    return result;
  }

  static public int base64decode_base64toint(char c, byte[] alphaToInt) {
    int result = alphaToInt[c];
    if (result < 0)
      throw new IllegalArgumentException("Illegal character " + c);
    return result;
  }

  static final public byte[] base64decode_base64toint = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 };

  static public boolean possibleGlobalID(String s) {
    return l(s) == globalIDLength() && allLowerCaseCharacters(s);
  }

  static public String javascriptQuote(String s) {
    return quote(s);
  }

  static public AlphanumComparator alphaNumComparator_instance;

  static public Comparator<String> alphaNumComparator() {
    if (alphaNumComparator_instance == null)
      alphaNumComparator_instance = new AlphanumComparator();
    return alphaNumComparator_instance;
  }

  static public String reverseString(String s) {
    return new StringBuilder(s).reverse().toString();
  }

  static public String charToString(char c) {
    return String.valueOf(c);
  }

  static public String charToString(int c) {
    return String.valueOf((char) c);
  }

  static public String hopeningtag(String tag, Map params) {
    return hopeningTag(tag, params);
  }

  static public String hopeningtag(String tag, Object... params) {
    return hopeningTag(tag, params);
  }

  static public <A> List<A> padList(List<A> l, int w, A a) {
    if (l(l) >= w)
      return l;
    List<A> x = cloneList(l);
    while (l(x) < w) x.add(a);
    return x;
  }

  static public Map paramsToMap(Object... params) {
    int n = l(params);
    if (l(params) == 1 && params[0] instanceof Map)
      return (Map) params[0];
    LinkedHashMap map = new LinkedHashMap();
    for (int i = 0; i + 1 < n; i += 2) mapPut(map, params[i], params[i + 1]);
    return map;
  }

  static public <A> A[] itemPlusArray(A a, A[] l) {
    return singlePlusArray(a, l);
  }

  static public String htd(Object contents, Object... params) {
    return htag("td", contents, params);
  }

  static public Object[] changeParam(Object[] params, String name, Object value) {
    if (eq(optPar(params, name), value))
      return params;
    Map map = paramsToOrderedMap(params);
    map.put(name, value);
    return mapToParams(map);
  }

  static public String htmlQuote(String s) {
    return "\"" + htmlencode_forParams(s) + "\"";
  }

  static public String codePointToString(int codePoint) {
    return new String(Character.toChars(codePoint));
  }

  static public String conceptsFileName() {
    return "concepts.structure.gz";
  }

  static public boolean isFile(File f) {
    return f != null && f.isFile();
  }

  static public boolean isFile(String path) {
    return isFile(newFile(path));
  }

  static public List<File> sortFilesByName(List<File> l) {
    sort(l, (a, b) -> stdcompare(a.getName(), b.getName()));
    return l;
  }

  static public String regexpFirstGroup(String pat, String s) {
    Matcher m = regexpMatcher(pat, s);
    if (m.find())
      return m.group(1);
    else
      return null;
  }

  static public List<File> sortFilesByNameDesc(List<File> l) {
    sort(l, (a, b) -> stdcompare(b.getName(), a.getName()));
    return l;
  }

  static public String stringIfTrue(boolean b, String s) {
    return b ? s : "";
  }

  static public String decimalFormatEnglish(String format, double d) {
    return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
  }

  static public String loadGZTextFile(File file) {
    try {
      if (!file.isFile())
        return null;
      ping();
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      InputStream fis = new FileInputStream(file);
      try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        byte[] buffer = new byte[1024];
        int len;
        while ((len = gis.read(buffer)) != -1) baos.write(buffer, 0, len);
        baos.close();
        return fromUtf8(baos.toByteArray());
      } finally {
        _close(fis);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public Object[] dropEntryFromParams(Object[] params, int i) {
    int n = l(params);
    if (i < 0 || i >= n)
      return params;
    if (n == 2)
      return null;
    Object[] p = new Object[n - 2];
    System.arraycopy(params, 0, p, 0, i);
    System.arraycopy(params, i + 2, p, i, n - i - 2);
    return p;
  }

  static public <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
    if (empty(params))
      return list;
    List<A> l = new ArrayList();
    for (A x : list) if (checkConceptFields(x, params))
      l.add(x);
    return l;
  }

  static public <A> Set<A> setMinus(Set<A> set, Object... stuff) {
    Set s2 = cloneSet(set);
    for (Object o : stuff) s2.remove(o);
    return s2;
  }

  static public <A> Set<A> mergeSets(Set<A>... l) {
    return joinSets(l);
  }

  static public Set<String> allNonStaticNonTransientFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) if ((f.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0)
        fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  static public boolean setField_trueIfChanged(Field f, Object o, Object value) {
    try {
      if (eq(f.get(o), value))
        return false;
      f.set(o, value);
      return true;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> boolean syncEmpty(Collection<A> l) {
    if (l == null)
      return true;
    synchronized (l) {
      return l.isEmpty();
    }
  }

  static public Rectangle maxWindowBounds() {
    return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
  }

  static public String userHomeIfNotActual() {
    String home = userHome();
    return eq(home, actualUserHome()) ? null : home;
  }

  static public boolean activateFrame(final Component c, Object... __) {
    return swing(new F0<Boolean>() {

      public Boolean get() {
        try {
          Frame f = getAWTFrame(c);
          if (f == null)
            return false;
          if (!f.isVisible())
            f.setVisible(true);
          boolean windowsHack = optPar("windowsHack", __, true);
          boolean iconified = f.getState() == Frame.ICONIFIED;
          boolean maximize = boolPar("maximize", __);
          if (iconified)
            f.setState(maximize ? Frame.MAXIMIZED_BOTH : Frame.NORMAL);
          if (windowsHack && !iconified && isWindows()) {
            boolean fullscreen = f.getExtendedState() == Frame.MAXIMIZED_BOTH;
            f.setExtendedState(JFrame.ICONIFIED);
            f.setExtendedState(fullscreen ? JFrame.MAXIMIZED_BOTH : JFrame.NORMAL);
          }
          f.toFront();
          return true;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "Frame f = getAWTFrame(c);\r\n    if (f == null) false;\r\n    if (!f.isVisible())...";
      }
    });
  }

  static public String escapeNewLines(String s) {
    return s == null ? null : fixNewLines(s).replace("\n", " | ");
  }

  static public <A> List<A> reverseList(List<A> l) {
    Collections.reverse(l);
    return l;
  }

  static public <A> A callPostProcessor(Object f, A a) {
    return f == null ? a : (A) callF(f, a);
  }

  static public void setOptMC(String field, Object value) {
    setOpt(mc(), field, value);
  }

  static public JPanel showFormTitled_customArrangement(final boolean internalFrame, final F1<List<JComponent>, JPanel> arrange, final String title, final Object... _parts) {
    return swing(new F0<JPanel>() {

      public JPanel get() {
        try {
          List<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, _parts));
          JPanel panel = callF(arrange, out);
          showForm_makeFrame(title, panel);
          return panel;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "L<JComponent> out = showForm_arrange1(showForm_makeComponents(internalFrame, ...";
      }
    });
  }

  static public JPanel customLayoutPanel(final Object layouter) {
    return jpanel(layoutManagerFromFunction(layouter));
  }

  static public JPanel customLayoutPanel(final Object layouter, final List<? extends Component> components) {
    return addAllComponents(customLayoutPanel(layouter), components);
  }

  static public boolean containsATextArea(Component c) {
    return childOfType(c, JTextArea.class) != null;
  }

  static public int totalPreferredHeight(List<Component> l) {
    int h = 0;
    for (Component c : unnull(l)) h += c.getPreferredSize().height;
    return h;
  }

  static public <A> List<A> listWithoutIndicesInBitSet(List<A> l, BitSet bs) {
    List<A> out = new ArrayList();
    for (int i = 0; i < l(l); i++) if (!bs.get(i))
      out.add(l.get(i));
    return out;
  }

  static public double doubleRatio(double x, double y) {
    return y == 0 ? 0 : x / y;
  }

  static public Dimension componentsBoundingSize(Container container, int insetBottomRight) {
    Rectangle r = new Rectangle(0, 0, 0, 0);
    for (Component c : container.getComponents()) r = rectangleUnion(r, c.getBounds());
    return new Dimension(r.x + r.width + insetBottomRight, r.y + r.height + insetBottomRight);
  }

  static public <A extends JLabel> A setHorizontalAlignment(final int pos, final A a) {
    swingCall(a, "setHorizontalAlignment", pos);
    return a;
  }

  static public <A extends AbstractButton> A setHorizontalAlignment(final int pos, final A a) {
    swingCall(a, "setHorizontalAlignment", pos);
    return a;
  }

  static public <A extends JTextField> A setHorizontalAlignment(final int pos, final A a) {
    swingCall(a, "setHorizontalAlignment", pos);
    return a;
  }

  static public boolean isImageFile(File f) {
    return isImageFileName(fileName(f));
  }

  static public String htitle_noEncode(String title) {
    return tag("title", title);
  }

  static public String dropTags(String html) {
    return dropAllTags(html);
  }

  static public List<String> dropTags(List<String> tok) {
    return dropAllTags(tok);
  }

  static public String h1(String s, Object... params) {
    return tag("h1", s, params);
  }

  static public class ScannedBot implements IFieldsToList {

    static final public String _fieldOrder = "helloString address";

    public String helloString;

    public String address;

    public ScannedBot() {
    }

    public ScannedBot(String helloString, String address) {
      this.address = address;
      this.helloString = helloString;
    }

    public String toString() {
      return shortClassName(this) + "(" + helloString + ", " + address + ")";
    }

    public boolean equals(Object o) {
      if (!(o instanceof ScannedBot))
        return false;
      ScannedBot __1 = (ScannedBot) o;
      return eq(helloString, __1.helloString) && eq(address, __1.address);
    }

    public int hashCode() {
      int h = 1660478935;
      h = boostHashCombine(h, _hashCode(helloString));
      h = boostHashCombine(h, _hashCode(address));
      return h;
    }

    public Object[] _fieldsToList() {
      return new Object[] { helloString, address };
    }
  }

  static public List<ScannedBot> fullBotScan() {
    return fullBotScan("");
  }

  static public List<ScannedBot> fullBotScan(String searchPattern) {
    List<ScannedBot> bots = new ArrayList();
    for (ProgramScan.Program p : quickBotScan()) {
      String botName = firstPartOfHelloString(p.helloString);
      boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
      boolean shouldRecurse = swic(botName, "Multi-Port") || isVM;
      if (swic(botName, searchPattern))
        bots.add(new ScannedBot(botName, "" + p.port));
      if (shouldRecurse)
        try {
          Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
          for (Number vport : subBots.keySet()) {
            botName = subBots.get(vport);
            if (swic(botName, searchPattern))
              bots.add(new ScannedBot(botName, p.port + "/" + vport));
          }
        } catch (Exception e) {
          e.printStackTrace();
        }
    }
    return bots;
  }

  static public Object unstructure_startingAtIndex(String s, int i) {
    return unstructure_tok(javaTokC_noMLS_iterator(s, i), false, null);
  }

  static public AutoCloseable tempDBLock(Concepts concepts) {
    return tempLock(concepts.lock);
  }

  static public AutoCloseable tempDBLock() {
    return tempDBLock(db_mainConcepts());
  }

  static public JButton renameButton(JComponent c, String name) {
    JButton b = first(childrenOfType(c, JButton.class));
    if (b != null)
      b.setText(name);
    return b;
  }

  static public JButton renameButton(JComponent c, String oldName, String newName) {
    JButton b = findButton(c, oldName);
    if (b != null)
      b.setText(newName);
    return b;
  }

  static public void setCaretPosition(final JTextComponent c, final int pos) {
    if (c != null) {
      swing(new Runnable() {

        public void run() {
          try {
            try {
              int _pos = max(0, min(l(c.getText()), pos));
              c.setCaretPosition(_pos);
            } catch (Throwable __e) {
              _handleException(__e);
            }
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "pcall {\r\n      int _pos = max(0, min(l(c.getText()), pos));\r\n      c.setCaret...";
        }
      });
    }
  }

  static public int textAreaTextLength(JTextComponent ta) {
    return l(getText(ta));
  }

  static public boolean allLowerCaseCharacters(String s) {
    for (int i = 0; i < l(s); i++) if (Character.getType(s.charAt(i)) != Character.LOWERCASE_LETTER)
      return false;
    return true;
  }

  static public <A> A[] singlePlusArray(A a, A[] l) {
    A[] out = newObjectArrayOfSameType(l, l(l) + 1);
    out[0] = a;
    arraycopy(l, 0, out, 1, l(l));
    return out;
  }

  static public String htmlencode_forParams(String s) {
    if (s == null)
      return "";
    StringBuilder out = new StringBuilder(Math.max(16, s.length()));
    for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
        out.append("&#");
        out.append((int) c);
        out.append(';');
      } else
        out.append(c);
    }
    return out.toString();
  }

  static public String fromUtf8(byte[] bytes) {
    try {
      return bytes == null ? null : new String(bytes, utf8charset());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public <A> Set<A> cloneSet(Set<A> set) {
    if (set == null)
      return new HashSet();
    synchronized (collectionMutex(set)) {
      Set<A> s = similarEmptySet(set);
      s.addAll(set);
      return s;
    }
  }

  static public LayoutManager layoutManagerFromFunction(final Object layouter) {
    return new AbstractLayoutManager() {

      public void layoutContainer(Container parent) {
        Dimension size = (Dimension) (pcallF(layouter, parent));
        if (size != null)
          preferredSize = size;
      }
    };
  }

  static public <A extends Container> A addAllComponents(final A c, final List<? extends Component> components) {
    if (nempty(components)) {
      swing(new Runnable() {

        public void run() {
          try {
            for (Component x : components) c.add(x);
            revalidate(c);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "for (Component x : components)\r\n      c.add(x);\r\n    revalidate(c);";
        }
      });
    }
    return c;
  }

  static public <A> A childOfType(Component c, Class<A> theClass) {
    return first(childrenOfType(c, theClass));
  }

  static public <A> A childOfType(Class<A> theClass, Component c) {
    return childOfType(c, theClass);
  }

  static public Rectangle rectangleUnion(Rectangle a, Rectangle b) {
    return a == null ? b : b == null ? a : a.union(b);
  }

  static public boolean isImageFileName(String s) {
    return eqicOneOf(fileExtension(s), ".png", ".jpg", ".jpeg", ".gif");
  }

  static public String fileName(File f) {
    return f == null ? null : f.getName();
  }

  static public List<String> dropAllTags(List<String> tok) {
    List<String> list = new ArrayList();
    for (int i = 0; i < l(tok); i++) {
      String t = tok.get(i);
      if (odd(i) && t.startsWith("<")) {
        list.set(list.size() - 1, list.get(list.size() - 1) + tok.get(i + 1));
        ++i;
      } else
        list.add(t);
    }
    return list;
  }

  static public String dropAllTags(String html) {
    return join(dropAllTags(htmlcoarsetok(html)));
  }

  static public JButton findButton(Component c, String name) {
    for (JButton b : childrenOfType(c, JButton.class)) if (eq(b.getText(), name))
      return b;
    for (JButton b : childrenOfType(getFrame(c), JButton.class)) if (eq(b.getText(), name))
      return b;
    return null;
  }

  static public JButton findButton(Component c) {
    return childOfType(c, JButton.class);
  }

  static public List<String> htmlcoarsetok(String s) {
    List<String> tok = new ArrayList<String>();
    int l = s == null ? 0 : s.length();
    int i = 0;
    while (i < l) {
      int j = i;
      char c;
      while (j < l) {
        if (s.charAt(j) != '<')
          ++j;
        else if (s.substring(j, Math.min(j + 4, l)).equals("<!--")) {
          j = j + 4;
          do ++j; while (j < l && !s.substring(j, Math.min(j + 3, l)).equals("-->"));
          j = Math.min(j + 3, l);
        } else
          break;
      }
      tok.add(s.substring(i, j));
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      if (c == '<') {
        ++j;
        while (j < l && s.charAt(j) != '>') ++j;
        if (j < l)
          ++j;
      }
      tok.add(s.substring(i, j));
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    return tok;
  }

  static public class Str extends Concept {

    public String name;

    public List<String> otherNames = new ArrayList();

    public Str() {
    }

    public Str(String name) {
      this.name = name;
    }

    public String toString() {
      return name;
    }
  }

  static public class AutoComboBox extends JComboBox<Object> {

    public String[] keyWord = { "item1", "item2", "item3" };

    public Vector myVector = new Vector();

    public boolean acceptOnTab = false;

    public AutoComboBox() {
      setModel(new DefaultComboBoxModel(myVector));
      setSelectedIndex(-1);
      setEditable(true);
      JTextField text = (JTextField) this.getEditor().getEditorComponent();
      text.setFocusable(true);
      text.setText("");
      text.addKeyListener(new ComboListener(this, myVector));
      if (acceptOnTab)
        text.setFocusTraversalKeysEnabled(false);
      setMyVector();
    }

    public void setKeyWord(String[] keyWord) {
      this.keyWord = keyWord;
      setMyVector();
    }

    public void setKeyWord(Collection<String> keyWord) {
      setKeyWord(toStringArray(keyWord));
    }

    final public void setMyVector() {
      copyArrayToVector(keyWord, myVector);
    }

    public class ComboListener extends KeyAdapter {

      public JComboBox cb;

      public Vector vector;

      public ComboListener(JComboBox cb, Vector vector) {
        this.vector = vector;
        this.cb = cb;
      }

      public void keyPressed(KeyEvent key) {
        if (key.getKeyCode() == KeyEvent.VK_ENTER)
          return;
        if (key.getKeyCode() == KeyEvent.VK_ESCAPE) {
          cb.hidePopup();
          return;
        }
        if (acceptOnTab && key.getKeyCode() == KeyEvent.VK_TAB) {
          _print("Have tab event (modifiers=" + key.getModifiers() + ")");
          if ((key.getModifiers() & ActionEvent.SHIFT_MASK) == 0 && cb.isPopupVisible()) {
            cb.setSelectedIndex(0);
            cb.hidePopup();
          } else
            swing_standardTabBehavior(key);
          return;
        }
        JTextField tf = (JTextField) (cb.getEditor().getEditorComponent());
        if (tf.getCaretPosition() != l(tf.getText()))
          return;
        String text = ((JTextField) key.getSource()).getText();
        Vector list = getFilteredList(text);
        if (nempty(list)) {
          cb.setModel(new DefaultComboBoxModel(list));
          cb.setSelectedIndex(-1);
          tf.setText(text);
          cb.showPopup();
        } else
          cb.hidePopup();
      }

      public Vector getFilteredList(String text) {
        return new Vector(scoredSearch(text, vector));
      }
    }
  }

  static public class PNGFile extends Concept {

    public String pngPath;

    public Rect r;

    public PNGFile() {
    }

    public PNGFile(String pngPath) {
      this.pngPath = pngPath;
    }

    public PNGFile(RGBImage img) {
      this(img.getBufferedImage());
    }

    public File pngFile() {
      if (pngPath == null) {
        pngPath = _programID() + "/" + id + ".png";
        change();
      }
      return prepareFile(new File(javaxDataDir(), pngPath));
    }

    public PNGFile(BufferedImage img) {
      savePNG(pngFile(), img);
    }

    public BufferedImage loadImage() {
      return loadImage2(pngFile());
    }

    public BufferedImage getImage() {
      return loadImage();
    }

    public BufferedImage getImageSafe() {
      try {
        return loadImage();
      } catch (Throwable __e) {
        _handleException(__e);
      }
      return null;
    }

    public String md5() {
      try {
        return md5OfBufferedImage(getImage());
      } catch (Throwable __e) {
        _handleException(__e);
      }
      return "-";
    }

    public boolean hasImage() {
      return pngFile().exists();
    }
  }

  static public class AlphanumComparator implements Comparator<String> {

    public boolean ignoreCase = false;

    final public boolean isDigit(char ch) {
      return ((ch >= 48) && (ch <= 57));
    }

    final public String getChunk(String s, int slength, int marker) {
      StringBuilder chunk = new StringBuilder();
      char c = s.charAt(marker);
      chunk.append(c);
      marker++;
      if (isDigit(c))
        while (marker < slength) {
          c = s.charAt(marker);
          if (!isDigit(c))
            break;
          chunk.append(c);
          marker++;
        }
      else
        while (marker < slength) {
          c = s.charAt(marker);
          if (isDigit(c))
            break;
          chunk.append(c);
          marker++;
        }
      return chunk.toString();
    }

    public int compare(String s1, String s2) {
      if (s1 == null)
        return s2 == null ? 0 : -1;
      if (s2 == null)
        return 1;
      int thisMarker = 0;
      int thatMarker = 0;
      int s1Length = s1.length();
      int s2Length = s2.length();
      while (thisMarker < s1Length && thatMarker < s2Length) {
        String thisChunk = getChunk(s1, s1Length, thisMarker);
        thisMarker += thisChunk.length();
        String thatChunk = getChunk(s2, s2Length, thatMarker);
        thatMarker += thatChunk.length();
        int result = 0;
        if (isDigit(thisChunk.charAt(0)) && isDigit(thatChunk.charAt(0))) {
          int thisChunkLength = thisChunk.length();
          result = thisChunkLength - thatChunk.length();
          if (result == 0) {
            for (int i = 0; i < thisChunkLength; i++) {
              result = thisChunk.charAt(i) - thatChunk.charAt(i);
              if (result != 0) {
                return result;
              }
            }
          }
        } else {
          result = thisChunk.compareTo(thatChunk);
        }
        if (result != 0)
          return result;
      }
      return s1Length - s2Length;
    }
  }

  abstract static public class AbstractLayoutManager implements LayoutManager {

    public Dimension preferredSize = new Dimension(100, 100);

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
      layoutContainer(parent);
      return preferredSize;
    }

    public Dimension minimumLayoutSize(Container parent) {
      return new Dimension(10, 10);
    }
  }

  static public class Scored<A> extends Var<A> {

    public float score;

    public Scored() {
    }

    public Scored(A a, float score) {
      super(a);
      this.score = score;
    }

    public Scored(A a, double score) {
      super(a);
      this.score = (float) score;
    }

    public float score() {
      return score;
    }

    public String toString() {
      return toIntPercent(score) + "%: " + str(get());
    }
  }

  static public class RightAlignedLine extends JPanel {

    public RightAlignedLine(Component... components) {
      setLayout(LetterLayout.rightAlignedRow());
      for (Component component : components) add(component);
    }

    public void add(String text) {
      add(new JLabel(text));
    }
  }

  final static public class ContentsIndexedList<A> extends RandomAccessAbstractList<A> implements IContentsIndexedList<A>, IContentsIndexedList2<A> {

    public Map<A, TreeSet<Elem<A>>> index = new HashMap();

    final public ArrayList<Elem<A>> list = new ArrayList();

    final static public class Elem<A> extends HasIndex {

      public A s;

      public String toString() {
        return "Elem " + quote(s) + "@" + idx;
      }
    }

    public ContentsIndexedList() {
    }

    public ContentsIndexedList(Map<A, TreeSet<Elem<A>>> index) {
      this.index = index;
    }

    public ContentsIndexedList(Collection<A> l) {
      addAll(l);
    }

    public A get(int i) {
      return list.get(i).s;
    }

    public int size() {
      return list.size();
    }

    public A set(int i, A s) {
      Elem<A> t = list.get(i);
      A old = t.s;
      if (eq(old, s))
        return old;
      removeFromIdx(t);
      t.s = s;
      addToIdx(t);
      return old;
    }

    public boolean add(A s) {
      ++modCount;
      Elem<A> t = new Elem();
      t.s = s;
      t.idx = size();
      list.add(t);
      addToIdx(t);
      return true;
    }

    public void add(int i, A s) {
      ++modCount;
      Elem<A> t = new Elem();
      t.s = s;
      t.idx = i;
      list.add(i, t);
      reorder(i + 1);
      addToIdx(t);
    }

    public boolean addAll(int i, Collection<? extends A> l) {
      int n = l.size();
      if (n == 0)
        return false;
      ++modCount;
      List<Elem<A>> l2 = emptyList(n);
      int j = i;
      for (A s : l) {
        Elem<A> t = new Elem();
        t.s = s;
        t.idx = j++;
        l2.add(t);
      }
      list.addAll(i, l2);
      reorder(i + n);
      for (Elem<A> t : l2) addToIdx(t);
      return true;
    }

    public A remove(int i) {
      ++modCount;
      Elem<A> t = list.get(i);
      removeFromIdx(t);
      list.remove(i);
      reorder(i);
      return t.s;
    }

    public void reorder(int fromIdx) {
      int n = size();
      for (int i = fromIdx; i < n; i++) list.get(i).idx = i;
    }

    public void removeFromIdx(Elem<A> t) {
      TreeSet<Elem<A>> idx = index.get(t.s);
      idx.remove(t);
      if (idx.isEmpty())
        index.remove(t.s);
    }

    public void addToIdx(Elem<A> t) {
      TreeSet<Elem<A>> idx = index.get(t.s);
      if (idx == null)
        index.put(t.s, idx = new TreeSet());
      idx.add(t);
    }

    @Override
    public int indexOf(Object s) {
      TreeSet<Elem<A>> l = index.get(s);
      return l == null ? -1 : first(l).idx;
    }

    @Override
    public int lastIndexOf(Object s) {
      TreeSet<Elem<A>> l = index.get(s);
      return l == null ? -1 : last(l).idx;
    }

    @Override
    public boolean contains(Object s) {
      return index.containsKey(s);
    }

    public void clear() {
      ++modCount;
      index.clear();
      list.clear();
    }

    public void removeRange(int fromIndex, int toIndex) {
      if (fromIndex == toIndex)
        return;
      ++modCount;
      for (int i = fromIndex; i < toIndex; i++) removeFromIdx(list.get(i));
      list.subList(fromIndex, toIndex).clear();
      reorder(fromIndex);
    }

    public int[] indicesOf(Object o) {
      TreeSet<Elem<A>> idx = index.get(o);
      if (idx == null)
        return emptyIntArray();
      int[] a = new int[idx.size()];
      int i = 0;
      for (Elem<A> t : idx) a[i++] = t.idx;
      return a;
    }

    public TreeSet<HasIndex> indicesOf_treeSetOfHasIndex(Object o) {
      return (TreeSet) index.get(o);
    }
  }

  static public interface IContentsIndexedList2<A> extends List<A> {

    public TreeSet<HasIndex> indicesOf_treeSetOfHasIndex(Object o);
  }

  static public interface IContentsIndexedList<A> extends List<A> {

    public int[] indicesOf(Object o);
  }

  abstract static public class RandomAccessAbstractList<A> extends AbstractList<A> implements RandomAccess {
  }

  static public class HasIndex implements Comparable<HasIndex> {

    public int idx;

    public HasIndex() {
    }

    public HasIndex(int idx) {
      this.idx = idx;
    }

    public int compareTo(HasIndex h) {
      return idx - h.idx;
    }
  }

  static public class LetterLayout implements LayoutManager {

    public String[] lines;

    public Map<String, Component> map = new TreeMap<String, Component>();

    public RC[] rows;

    public RC[] cols;

    public Cell[][] cells;

    public int spacingX = 10, spacingY = 10;

    public int insetTop, insetBottom, insetLeft, insetRight;

    public int template;

    public boolean formWideLeftSide, formWideRightSide;

    static final public int STALACTITE = 1, LEFT_ALIGNED_ROW = 2, CENTERED_ROW = 3, FORM = 4, RIGHT_ALIGNED_ROW = 5;

    public boolean debug = false;

    public void setLeftBorder(int border) {
      insetLeft = border;
    }

    public void setRightBorder(int border) {
      insetRight = border;
    }

    public static JComponent withBorder(JComponent component, int border) {
      JPanel panel = new JPanel(new LetterLayout("C").setBorder(border));
      panel.add("C", component);
      return panel;
    }

    public static JPanel panel(String... lines) {
      return new JPanel(new LetterLayout(lines));
    }

    public static JPanel stalactitePanel() {
      return new JPanel(stalactite());
    }

    static public class DummyComponent extends JComponent {
    }

    static public class Cell {

      public boolean aux = false;

      public int minWidth, minHeight;

      public Component component;

      public int colspan, rowspan;

      public double weightX, weightY;
    }

    static public class RC {

      public int min;

      public double weightSum;

      public int start;

      public int minEnd;
    }

    public LetterLayout(int template) {
      this.template = template;
    }

    public LetterLayout(String... lines) {
      this.lines = lines;
    }

    public void removeLayoutComponent(Component component) {
      map.values().remove(component);
    }

    public void layoutContainer(Container container) {
      prepareLayout(container);
      if (debug)
        System.out.println("Container size: " + container.getSize());
      Insets insets = getInsets(container);
      for (int r = 0; r < rows.length; r++) {
        for (int i = 0; i < cols.length; ) {
          Cell cell = cells[i][r];
          if (cell.aux)
            ++i;
          else {
            if (cell.component != null) {
              int x1 = cols[i].start;
              int y1 = rows[r].start;
              int x2 = i + cell.colspan < cols.length ? cols[i + cell.colspan].start - spacingX : container.getWidth() - insets.right;
              int y2 = r + cell.rowspan < rows.length ? rows[r + cell.rowspan].start - spacingY : container.getHeight() - insets.bottom;
              if (debug)
                System.out.println("Layouting (" + i + ", " + r + ", " + cell.component.getClass().getName() + "): " + x1 + " " + y1 + " " + x2 + " " + y2);
              cell.component.setBounds(x1, y1, x2 - x1, y2 - y1);
            }
            i += cells[i][r].colspan;
          }
        }
      }
    }

    final public void prepareLayout(Container container) {
      applyTemplate(container);
      int numRows = lines.length, numCols = lines[0].length();
      for (int i = 1; i < numRows; i++) if (lines[i].length() != numCols)
        throw new IllegalArgumentException("Lines have varying length");
      cells = new Cell[numCols][numRows];
      rows = new RC[numRows];
      cols = new RC[numCols];
      for (int r = 0; r < numRows; r++) rows[r] = new RC();
      for (int i = 0; i < numCols; i++) cols[i] = new RC();
      for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r] = new Cell();
      for (int r = 0; r < numRows; r++) {
        String line = lines[r];
        for (int i = 0; i < numCols; ) {
          Cell cell = cells[i][r];
          if (cell.aux) {
            ++i;
            continue;
          }
          char ch = line.charAt(i);
          int iNext = i;
          do ++iNext; while (iNext < numCols && ch == line.charAt(iNext));
          int rNext = r;
          do ++rNext; while (rNext < numRows && ch == lines[rNext].charAt(i));
          cell.weightX = numCols == 1 || iNext > i + 1 ? 1.0 : 0.0;
          cell.weightY = numRows == 1 || rNext > r + 1 ? 1.0 : 0.0;
          Component c = map.get(String.valueOf(ch));
          cell.component = c;
          if (c != null) {
            cell.minWidth = c.getMinimumSize().width + spacingX;
            cell.minHeight = getMinimumHeight(c) + spacingY;
          }
          cell.colspan = iNext - i;
          cell.rowspan = rNext - r;
          if (cell.colspan == 1)
            cols[i].min = Math.max(cols[i].min, cell.minWidth);
          if (cell.rowspan == 1)
            rows[r].min = Math.max(rows[r].min, cell.minHeight);
          for (int r2 = r; r2 < rNext; r2++) for (int i2 = i; i2 < iNext; i2++) if (r2 != r || i2 != i)
            cells[i2][r2].aux = true;
          i = iNext;
        }
      }
      while (true) {
        for (int i = 0; i < numCols; i++) {
          int minStart = i == 0 ? 0 : cols[i - 1].minEnd;
          double weightStart = i == 0 ? 0.0 : cols[i - 1].weightSum;
          for (int r = 0; r < numRows; r++) {
            Cell cell = cells[i][r];
            if (!cell.aux) {
              RC rc = cols[i + cell.colspan - 1];
              rc.minEnd = Math.max(rc.minEnd, minStart + cell.minWidth);
              rc.weightSum = Math.max(rc.weightSum, weightStart + cell.weightX);
            }
          }
        }
        for (int r = 0; r < numRows; r++) {
          int minStart = r == 0 ? 0 : rows[r - 1].minEnd;
          double weightStart = r == 0 ? 0.0 : rows[r - 1].weightSum;
          for (int i = 0; i < numCols; i++) {
            Cell cell = cells[i][r];
            if (!cell.aux) {
              RC rc = rows[r + cell.rowspan - 1];
              rc.minEnd = Math.max(rc.minEnd, minStart + cell.minHeight);
              rc.weightSum = Math.max(rc.weightSum, weightStart + cell.weightY);
            }
          }
        }
        if (allWeightsZero(cols)) {
          for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r].weightX = 1.0;
          continue;
        }
        if (allWeightsZero(rows)) {
          for (int r = 0; r < numRows; r++) for (int i = 0; i < numCols; i++) cells[i][r].weightY = 1.0;
          continue;
        }
        break;
      }
      Insets insets = getInsets(container);
      determineStarts(cols, insets.left, container.getWidth() - insets.left - insets.right + spacingX, spacingX);
      determineStarts(rows, insets.top, container.getHeight() - insets.top - insets.bottom + spacingY, spacingY);
    }

    final public boolean allWeightsZero(RC[] rcs) {
      for (int i = 0; i < rcs.length; i++) if (rcs[i].weightSum != 0.0)
        return false;
      return true;
    }

    static public int getMinimumHeight(Component c) {
      return c.getMinimumSize().height;
    }

    final public void applyTemplate(Container container) {
      if (template == STALACTITE) {
        Component[] components = container.getComponents();
        lines = new String[components.length + 2];
        map.clear();
        for (int i = 0; i < components.length; i++) {
          String s = String.valueOf(makeIndexChar(i));
          map.put(s, components[i]);
          lines[i] = s;
        }
        lines[components.length] = lines[components.length + 1] = " ";
      } else if (template == FORM) {
        Component[] components = container.getComponents();
        int numRows = components.length / 2;
        lines = new String[numRows + 2];
        map.clear();
        for (int row = 0; row < numRows; row++) {
          String lower = String.valueOf(makeIndexChar(row));
          String upper = String.valueOf(makeAlternateIndexChar(row));
          Component rightComponent = components[row * 2 + 1];
          if (rightComponent instanceof DummyComponent)
            upper = lower;
          lines[row] = (formWideLeftSide ? lower + lower : lower) + (formWideRightSide ? upper + upper : upper);
          map.put(lower, components[row * 2]);
          if (!(rightComponent instanceof DummyComponent))
            map.put(upper, rightComponent);
        }
        lines[numRows] = lines[numRows + 1] = (formWideLeftSide ? "  " : " ") + (formWideRightSide ? "  " : " ");
      } else if (template == LEFT_ALIGNED_ROW) {
        lines = new String[] { makeSingleRow(container) + RIGHT_CHAR + RIGHT_CHAR };
      } else if (template == CENTERED_ROW) {
        lines = new String[] { "" + LEFT_CHAR + LEFT_CHAR + makeSingleRow(container) + RIGHT_CHAR + RIGHT_CHAR };
      } else if (template == RIGHT_ALIGNED_ROW) {
        lines = new String[] { "" + LEFT_CHAR + LEFT_CHAR + makeSingleRow(container) };
      }
    }

    final public String makeSingleRow(Container container) {
      Component[] components = container.getComponents();
      StringBuffer buf = new StringBuffer();
      map.clear();
      for (int i = 0; i < components.length; i++) {
        String s = String.valueOf(makeAlternateIndexChar(i));
        map.put(s, components[i]);
        buf.append(s);
      }
      return buf.toString();
    }

    static public void determineStarts(RC[] rcs, int start, int totalSize, int spacing) {
      int minTotal = rcs[rcs.length - 1].minEnd;
      double weightSum = rcs[rcs.length - 1].weightSum;
      int spare = (int) ((totalSize - minTotal) / (weightSum == 0.0 ? 1.0 : weightSum));
      int x = start, minSum = 0;
      double prevWeightSum = 0.0;
      for (int i = 0; i < rcs.length; i++) {
        int width = rcs[i].minEnd - minSum + (int) ((rcs[i].weightSum - prevWeightSum) * spare) - spacing;
        rcs[i].start = x;
        x += width + spacing;
        prevWeightSum = rcs[i].weightSum;
        minSum = rcs[i].minEnd;
      }
    }

    public void addLayoutComponent(String s, Component component) {
      map.put(s, component);
    }

    public Dimension minimumLayoutSize(Container container) {
      prepareLayout(container);
      Insets insets = getInsets(container);
      Dimension result = new Dimension(insets.left + cols[cols.length - 1].minEnd + insets.right - spacingX, insets.top + rows[rows.length - 1].minEnd + insets.bottom - spacingY);
      return result;
    }

    final public Insets getInsets(Container container) {
      Insets insets = container.getInsets();
      return new Insets(insets.top + insetTop, insets.left + insetLeft, insets.bottom + insetBottom, insets.right + insetRight);
    }

    public Dimension preferredLayoutSize(Container container) {
      return minimumLayoutSize(container);
    }

    public LetterLayout setSpacing(int x, int y) {
      spacingX = x;
      spacingY = y;
      return this;
    }

    public LetterLayout setSpacing(int spacing) {
      return setSpacing(spacing, spacing);
    }

    public LetterLayout setBorder(int top, int left, int bottom, int right) {
      insetTop = top;
      insetLeft = left;
      insetBottom = bottom;
      insetRight = right;
      return this;
    }

    public LetterLayout setBorder(int inset) {
      return setBorder(inset, inset, inset, inset);
    }

    public LetterLayout setTopBorder(int inset) {
      insetTop = inset;
      return this;
    }

    public static LetterLayout stalactite() {
      return new LetterLayout(STALACTITE);
    }

    public static LetterLayout leftAlignedRow() {
      return new LetterLayout(LEFT_ALIGNED_ROW);
    }

    public static LetterLayout leftAlignedRow(int spacing) {
      return leftAlignedRow().setSpacing(spacing);
    }

    public static LetterLayout centeredRow() {
      return new LetterLayout(CENTERED_ROW);
    }

    public static LetterLayout rightAlignedRow() {
      return new LetterLayout(RIGHT_ALIGNED_ROW);
    }

    public static JPanel rightAlignedRowPanel(JComponent... components) {
      return makePanel(new LetterLayout(RIGHT_ALIGNED_ROW), components);
    }

    static public JPanel makePanel(LetterLayout letterLayout, JComponent[] components) {
      JPanel panel = new JPanel(letterLayout);
      for (JComponent component : components) {
        panel.add(component);
      }
      return panel;
    }

    public static LetterLayout form() {
      LetterLayout letterLayout = new LetterLayout(FORM);
      letterLayout.formWideLeftSide = true;
      letterLayout.formWideRightSide = true;
      return letterLayout;
    }

    public static LetterLayout formWideRightSide() {
      LetterLayout letterLayout = new LetterLayout(FORM);
      letterLayout.formWideRightSide = true;
      return letterLayout;
    }

    public static Component getDummyComponent() {
      return new DummyComponent();
    }

    public static JPanel newPanel(String... lines) {
      return new JPanel(new LetterLayout(lines));
    }

    public boolean isDebug() {
      return debug;
    }

    public void setDebug(boolean debug) {
      this.debug = debug;
    }

    public static char makeIndexChar(int idx) {
      return (char) ('a' + idx * 2);
    }

    public static char makeAlternateIndexChar(int idx) {
      return (char) ('b' + idx * 2);
    }

    public static char LEFT_CHAR = ',', RIGHT_CHAR = '.';

    public static void main(String[] args) {
      System.out.println((int) makeIndexChar(0));
      System.out.println((int) makeAlternateIndexChar(0));
      System.out.println((int) makeIndexChar(32000));
      System.out.println((int) makeAlternateIndexChar(32000));
      System.out.println((int) LEFT_CHAR);
      System.out.println((int) RIGHT_CHAR);
    }
  }

  static public void setSelectedIndex(final JList l, final int i) {
    if (l != null) {
      swing(new Runnable() {

        public void run() {
          try {
            l.setSelectedIndex(i);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "l.setSelectedIndex(i);";
        }
      });
    }
  }

  static public void setSelectedIndex(final JComboBox cb, final int i) {
    if (cb != null) {
      swing(new Runnable() {

        public void run() {
          try {
            cb.setSelectedIndex(i);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "cb.setSelectedIndex(i);";
        }
      });
    }
  }

  static public void copyArrayToVector(Object[] array, Vector v) {
    v.clear();
    v.addAll(toList(array));
  }

  static public void swing_standardTabBehavior(KeyEvent key) {
    if ((key.getModifiers() & ActionEvent.SHIFT_MASK) != 0)
      KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
    else
      KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
  }

  static public List<String> scoredSearch(String query, Iterable<String> data) {
    Map<String, Integer> scores = new HashMap();
    List<String> prepared = scoredSearch_prepare(query);
    for (String s : data) {
      int score = scoredSearch_score(s, prepared);
      if (score != 0)
        scores.put(s, score);
    }
    return keysSortedByValuesDesc(scores);
  }

  static public File prepareFile(File file) {
    return mkdirsForFile(file);
  }

  static public File prepareFile(File dir, String name) {
    return mkdirsForFile(newFile(dir, name));
  }

  static public RGBImage loadImage(String snippetIDOrURL) {
    return new RGBImage(loadBufferedImage(snippetIDOrURL));
  }

  static public RGBImage loadImage(File f) {
    return new RGBImage(loadBufferedImage(f));
  }

  static public String md5OfBufferedImage(BufferedImage img) {
    return img == null ? null : rgbMD5(new RGBImage(img));
  }

  static public int toIntPercent(double ratio) {
    return roundToInt(ratio * 100);
  }

  static public int toIntPercent(float ratio) {
    return toIntPercent((double) ratio);
  }

  static public List<String> scoredSearch_prepare(String query) {
    return map("replacePlusWithSpace", splitAtSpace(query));
  }

  static public int scoredSearch_score(Iterable<String> l, List<String> words) {
    int score = 0;
    if (l != null)
      for (String s : l) score += scoredSearch_score(s, words);
    return score;
  }

  static public int scoredSearch_score(String s, List<String> words) {
    int score = 0;
    if (nempty(s))
      for (String word : words) score += scoredSearch_score_single(s, word);
    return score;
  }

  static public int scoredSearch_score(String s, String query) {
    return scoredSearch_score(s, scoredSearch_prepare(query));
  }

  static public <A, B> List<A> keysSortedByValuesDesc(final Map<A, B> map) {
    List<A> l = new ArrayList(map.keySet());
    sort(l, mapComparatorDesc(map));
    return l;
  }

  static public String rgbMD5(RGBImage img) {
    return md5OfRGBImage(img);
  }

  static public int roundToInt(double d) {
    return (int) Math.round(d);
  }

  static public String replacePlusWithSpace(String s) {
    return replace(s, '+', ' ');
  }

  static public int scoredSearch_score_single(String s, String query) {
    int i = indexOfIC_underscore(s, query);
    if (i < 0)
      return 0;
    if (i > 0)
      return 1;
    return l(s) == l(query) ? 3 : 2;
  }

  static public <A, B> Comparator<A> mapComparatorDesc(final Map<A, B> map) {
    return new Comparator<A>() {

      public int compare(A a, A b) {
        return cmp(map.get(b), map.get(a));
      }
    };
  }

  static public String md5OfRGBImage(RGBImage img) {
    try {
      MessageDigest m = MessageDigest.getInstance("MD5");
      m.update(intToBytes(img.getWidth()));
      int[] pixels = img.getPixels();
      for (int i = 0; i < l(pixels); i++) m.update(intToBytes(pixels[i]));
      return bytesToHex(m.digest());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  static public int indexOfIC_underscore(String a, String b) {
    int la = l(a), lb = l(b);
    if (la < lb)
      return -1;
    int n = la - lb;
    elsewhere: for (int i = 0; i <= n; i++) {
      for (int j = 0; j < lb; j++) {
        char c2 = b.charAt(j);
        if (c2 == '_' || eqic(c2, a.charAt(i + j))) {
        } else
          continue elsewhere;
      }
      return i;
    }
    return -1;
  }

  static public byte[] intToBytes(int i) {
    return new byte[] { (byte) (i >>> 24), (byte) (i >>> 16), (byte) (i >>> 8), (byte) i };
  }
}

