
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;


import org.pushingpixels.substance.api.*;
import org.pushingpixels.substance.api.skin.*;
import javax.net.ssl.*;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.text.*;
class main {
public static void main(final String[] args) throws Exception { pExperiment(); 
  print("Shooting");
  BufferedImage img = shootScreenHidingConsole();
  print("Recognizing");
  List<RecognizedText> lines = ocr_recognizeMultiLine_scored(img);
  //lines = [S line : lines | l(getVar(line.text)) > 1];
  pnlStruct(lines);
}
static volatile StringBuffer local_log = new StringBuffer(); // not redirected
static volatile StringBuffer print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;
//static int print_maxLineLength = 0; // 0 = unset

static boolean print_silent; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<Object> print_byThread; // special handling by thread - prefers F1<S, Bool>
static volatile Object print_allThreads;

static void print() {
  print("");
}

static <A> A print(String s, A o) {
  print(s + o);
  return o;
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  
  Object f = print_byThread == null ? null : print_byThread.get();
  if (f == null) f = print_allThreads;
  if (f != null)
    if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s))) return;
  

  print_raw(s);
}

static void print_raw(String s) {
  s = fixNewLines(s);
  // TODO if (print_maxLineLength != 0)
  StringBuffer loc = local_log;
  StringBuffer buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  System.out.print(s);
}

static void print(long l) {
  print(String.valueOf(l));
}

static void print(char c) {
  print(String.valueOf(c));
}

static void print_append(StringBuffer buf, String s, int max) {
  synchronized(buf) {
    buf.append(s);
    max /= 2;
    if (buf.length() > max) try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
  }
}
static void pExperiment() {
  if (!isMain()) return;
  substance();
  autoRestart(5);
  experimentIcon();
  centerHigherConsole();
  tt();
}
static Map<Thread, Boolean> _registerThread_threads = newWeakHashMap();

static Thread _registerThread(Thread t) {
  _registerThread_threads.put(t, true);
  return t;
}

static void _registerThread() { _registerThread(Thread.currentThread()); }
static int shootScreenHidingConsole_delay = 200;

static BufferedImage shootScreenHidingConsole() { try {
  try {
    minimizeConsole();
    Thread.sleep(shootScreenHidingConsole_delay);
    return (BufferedImage) swingAndWait("shootScreen2");
  } finally {
    restoreConsole();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static class RecognizedText {
  Rect r;
  Scored<String> text; // 0 to 1

  RecognizedText() {}
  RecognizedText(Rect r, Scored<String> text) {
  this.text = text;
  this.r = r;}
}

static List<RecognizedText> ocr_recognizeMultiLine_scored(RGBImage img) {
  BWImage bw = new BWImage(img); img = null; return ocr_recognizeMultiLine(bw); 
}

static List<RecognizedText> ocr_recognizeMultiLine_scored(BufferedImage img) {
  BWImage bw = new BWImage(img); img = null; return ocr_recognizeMultiLine(bw);
}

static List<RecognizedText> ocr_recognizeMultiLine(BWImage bw) {
  SimpleRecognizer sr = filledSimpleRecognizer();
  enableFullSearchInSimpleRecognizer(sr);
  
  final List<Rect> rects = autoSegment(bw);
  
  List<RecognizedText> lines = new ArrayList();
  for (Rect r : rects)
    lines.add(new RecognizedText(r, sr.recognizeScored(bw.clip(r))));
    
  return lines;
}


static <A> Collection<A> pnlStruct(Collection<A> l) {
  pnlStruct((Iterable<A>) l);
  return l;
}

static <A> Iterable<A> pnlStruct(Iterable<A> l) {
  int i = 0;
  if (l != null) for (A a : l) print((++i) + ". " + struct_noStringSharing(a));
  return l;
}

static <A> A[] pnlStruct(A[] l) {
  pnlStruct(asList(l));
  return l;
}

static <A, B> Map<A, B> pnlStruct(Map<A, B> map) {
  pnl(map(map, new Object() { Object get(A a, B b) { try { return  sfu(a) + " = " + sfu(b) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "sfu(a) + \" = \" + sfu(b)"; }}));
  return map;
}


static String fixNewLines(String s) {
  return s.replace("\r\n", "\n").replace("\r", "\n");
}
static void tt() {
  typeWriterConsole();
}

static String tt(Object contents, Object... params) {
  return tag("tt", contents, params);
}
static void experimentIcon() {
  consoleAndDefaultFrameIcon("#1101173" /*#1101171*/);
}
static String struct_noStringSharing(Object o) {
  structure_Data d = new structure_Data();
  d.noStringSharing = true;
  return structure(o, d);
}
static String sfu(Object o) { return structureForUser(o); }
static volatile boolean ping_pauseAll;
static int ping_sleep = 100; // poll pauseAll flag every 100

static volatile boolean ping_anyActions;
static Map<Thread, Object> ping_actions = newWeakHashMap();


// always returns true
static boolean ping() {
  if (ping_pauseAll  || ping_anyActions ) ping_impl();
  return true;
}

// returns true when it slept
static boolean ping_impl() { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  
  if (ping_anyActions) {
    Object action;
    synchronized(ping_actions) {
      action = ping_actions.get(currentThread());
      if (action instanceof Runnable)
        ping_actions.remove(currentThread());
      if (ping_actions.isEmpty()) ping_anyActions = false;
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }
  
  
  return false;
} catch (Exception __e) { throw rethrow(__e); } }
static SimpleRecognizer filledSimpleRecognizer() {
  SimpleRecognizer sr = new SimpleRecognizer();
  for (String s : scanLog_iterator(glyphTeachLog()))
    sr.load(afterSquareBracketStuff(s));
  return sr;
}
static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();


  static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }


static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMC((String) f, args);
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) {
    
    throw fail("No get method in " + getClassName(c));
  }
  if (n == 1) return invokeMethod(methods.get(0), f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return invokeMethod(m, f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static <A, B> Map<A, B> newWeakHashMap() {
  return _registerWeakMap(synchroMap(new WeakHashMap()));
}
static <A> ArrayList<A> asList(A[] a) {
  return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  ArrayList<Integer> l = new ArrayList();
  for (int i : a) l.add(i);
  return l;
}

static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}

static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}
static void centerHigherConsole() {
  if (headless()) return;
  setConsoleHeight(600);
  centerConsole();
}
static void restoreConsole() {
  JFrame f = consoleFrame();
  if (f != null)
    f.setState(JFrame.NORMAL);
}
// get purpose 1: access a list/array/map (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

// seems to conflict with other signatures
/*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      return f.get(o);
    }
      
    
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(Object o, String field) {
  try {
    Field f = get_findField(o.getClass(), field);
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static List map(Iterable l, Object f) {
  return map(f, l);
}

static List map(Object f, Iterable l) {
  List x = emptyList(l);
  if (l != null) for (Object o : l)
    x.add(callF(f, o));
  return x;
}


  static List map(F1 f, Iterable l) {
    List x = emptyList(l);
    if (l != null) for (Object o : l)
      x.add(callF(f, o));
    return x;
  }


static List map(Object f, Object[] l) { return map(f, asList(l)); }
static List map(Object[] l, Object f) { return map(f, l); }

static List map(Object f, Map map) {
  return map(map, f);
}

// map: func(key, value) -> list element
static List map(Map map, Object f) {
  List x = new ArrayList();
  if (map != null) for (Object _e : map.entrySet()) {
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}
static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(r);
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() { public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}
static double autoRestart_interval = 10;
static boolean autoRestart_on, autoRestart_debug, autoRestart_simulate;
static java.util.Timer autoRestart_timer;

static void autoRestart(double interval) {
  autoRestart_interval = interval;
  autoRestart();
}

static void autoRestart() {
  if (!isMain() || autoRestart_on) return;
  autoRestart_on = true;
  autoRestart_schedule();
  preloadProgramTitle();
}

static void autoRestart_off() {
  if (!autoRestart_on) return;
  stopTimer(autoRestart_timer);
  autoRestart_timer = null;
}

static void autoRestart_schedule() {
  autoRestart_timer = doLater_daemon(toMS(autoRestart_interval), "autoRestart_check");
}

static void autoRestart_check() {
  try {
    String newMD5;
    try {
      newMD5 = loadPageSilently("http://botcompany.de/1010693/raw?id=" + psI(programID()));
    } catch (Throwable e) {
      return;
    }
    if (!isMD5(newMD5)) { if (autoRestart_debug) print("autoRestart: no server transpilation"); return; }
    if (autoRestart_localMD5 == null)
      autoRestart_localMD5 = md5(loadCachedTranspilation(programID()));

    String localMD5 = autoRestart_localMD5();
    if (neq(localMD5, newMD5)) {
      if (autoRestart_simulate)
        print("Would upgrade now. " + localMD5 + " -> " + newMD5);
      else {
        infoBox("Upgrading " + programTitle());
        restartWithDelay(1000);
        sleep();
      }
    }
  } finally {
    if (autoRestart_debug) print("autoRestart: Done");
    autoRestart_schedule();
  }
}

static RuntimeException rethrow(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static boolean isMain() {
  return isMainProgram();
}
static void substance() {
  substanceLAF();
}

static void substance(String skinName) {
  substanceLAF(skinName);
}
static void minimizeConsole() {
  JFrame f = consoleFrame();
  if (f != null)
    f.setState(JFrame.ICONIFIED);
}
static boolean shootScreen_useScrot = true; // Use program "scrot" to make full-screen screenshots (on Linux); prevents the bug https://bugs.openjdk.java.net/browse/JDK-7168628

static BufferedImage shootScreen2() {
  return shootScreen2(screenRectangle());
}

static BufferedImage shootScreen2(Rectangle area) { try {
  ping();
  if (shootScreen_useScrot && eq(area, screenRectangle())) {
    if (!isOnPATH("scrot")) shootScreen2_fallback();
    if (shootScreen_useScrot) {
      String filename = "screenshot-" + randomID(12) + ".png";
      File f = linux_fileInRamDisk(filename);
      if (f == null) f = prepareProgramFile(filename);
      try {
        String cmd = "scrot " + bashQuote(f);
        String out = backtick(cmd);
        if (f.exists())
          return loadPNG(f);
        shootScreen2_fallback();
      } catch (Throwable e) {
        print(e);
        shootScreen2_fallback();
      } finally {
        f.delete();
      }
    }
  }
  return new Robot().createScreenCapture(area);
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedImage shootScreen2(Rect area) {
  return shootScreen2(area.getRectangle());
}

static BufferedImage shootScreen2(int x, int y, int w, int h) {
  return shootScreen2(new Rectangle(x, y, w, h));
}

// internal
static void shootScreen2_fallback() {
  if (shootScreen_useScrot) {
    if (isLinux()) print("Scrot failed. Reverting to internal screenshots.");
    shootScreen_useScrot = false;
  }
}
static boolean isFalse(Object o) {
  return eq(false, o);
}
static <A extends Iterable> A pnl(A l) {
  printNumberedLines(l);
  return l;
}

static void pnl(Map map) {
  printNumberedLines(map);
}

static void pnl(Object[] a) {
  printNumberedLines(a);
}

static void pnl(String s) {
  printNumberedLines(lines(s));
}
static int autoSegment_g = 3;

// g = grid size - typical values are 3 or 4
static List<Rect> autoSegment(BWImage img, int g) {
  AutoSegmenter as = new AutoSegmenter();
  as.g = g;
  as.go(img);
  return as.clips;
}

static List<Rect> autoSegment(BWImage img) {
  return autoSegment(img, autoSegment_g);
}

static List<Rect> autoSegment(BufferedImage img) {
  return autoSegment(new BWImage(img));
}

static List<Rect> autoSegment(RGBImage img) {
  return autoSegment(new BWImage(img));
}
static void enableFullSearchInSimpleRecognizer(SimpleRecognizer sr) {
  if (sr.fullSearchMap == null)
    sr.fullSearchMap = reverseMap(getLearnedCharacters2());
}


static JFrame consoleFrame() {
  return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
}
// TODO: send hard errors to core

static AtomicLong _handleError_nonVMErrors = new AtomicLong();
static AtomicLong _handleError_vmErrors = new AtomicLong();
static AtomicLong _handleError_outOfMemoryErrors = new AtomicLong();
static volatile long _handleError_lastOutOfMemoryError;
static volatile Error _handleError_lastHardError;

static void _handleError(Error e) {
  if (!(e instanceof VirtualMachineError)) {
    incAtomicLong(_handleError_nonVMErrors);
    return;
  }
  
  print("\nHARD ERROR\n");
  printStackTrace2(e);
  print("\nHARD ERROR\n");
  _handleError_lastHardError = e;
  
  incAtomicLong(_handleError_vmErrors);
  if (e instanceof OutOfMemoryError) {
    incAtomicLong(_handleError_outOfMemoryErrors);
    _handleError_lastOutOfMemoryError = sysNow();
  }
}
static File prepareProgramFile(String name) {
  return mkdirsForFile(getProgramFile(name));
}

static File prepareProgramFile(String progID, String name) {
  return mkdirsForFile(getProgramFile(progID, name));
}
static boolean isOnPATH(String cmd) {
  return findCmdOnPATH(cmd) != null;
}
static HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  if (callMC_cache == null) callMC_cache = new HashMap(); // initializer time workaround
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) try {
    return invokeMethod(me, null, args);
  } catch (IllegalArgumentException e) {
    throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
  }

  List<Method> m;
  synchronized(callMC_cache) {
    m = callMC_cache.get(method);
  }
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    try {
      return invokeMethod(me, null, args);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
    }
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return invokeMethod(me, null, args);
  }
  throw fail("No method called " + method + " with matching arguments found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static void callMC_makeCache() {
  synchronized(callMC_cache) {
    callMC_cache.clear();
    Class _c = (Class) mc(), c = _c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods())
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
      c = c.getSuperclass();
    }
  }
}
static RuntimeException asRuntimeException(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static String tag(String tag) {
  return htag(tag);
}

static String tag(String tag, Object contents, Object... params) {
  return htag(tag, str(contents), params);
}

static String tag(String tag, StringBuilder contents, Object... params) {
  return htag(tag, contents, params);
}

static String tag(String tag, StringBuffer contents, Object... params) {
  return htag(tag, contents, params);
}
static boolean neq(Object a, Object b) {
  return !eq(a, b);
}
static void typeWriterConsole() {
  
  if (isHeadless()) return;
  Font f = typeWriterFont();
  consoleFont(f);
  consoleInputFont(f);
  
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
/** possibly improvable */
static String bashQuote(String text) {
  if (text == null) return null;
  return "\"" + text
    .replace("\\", "\\\\")
    .replace("\"", "\\\"")
    .replace("\n", "\\n")
    .replace("\r", "\\r") + "\"";
}

static String bashQuote(File f) {
  return bashQuote(f.getAbsolutePath());
}
static Thread currentThread() {
  return Thread.currentThread();
}
static String afterSquareBracketStuff(String s) {
  return trimSubstring(s, indexOf(s, ']')+1);
}
static void preloadProgramTitle() {
  { Thread _t_0 = new Thread() {
public void run() { try { programTitle(); } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_0); }
}
static long psI(String snippetID) {
  return parseSnippetID(snippetID);
}
static boolean eq(Object a, Object b) {
  return a == null ? b == null : a == b || a.equals(b);
}


static IterableIterator<String> scanLog_iterator(String progID, String fileName) {
  return scanLog_iterator(getProgramFile(progID, fileName));
}

static IterableIterator<String> scanLog_iterator(String fileName) {
  return scanLog_iterator(getProgramFile(fileName));
}

static IterableIterator<String> scanLog_iterator(File file) {
  // TODO: opens all at once
  final Iterator<String> it = chainIterators(map("linesFromFile",
    concatLists(earlierPartsOfLogFile(file), ll(file))));
  return iteratorFromFunction(new F0<String>() { String get() { try { 
    while (it.hasNext()) {
      String s = it.next();
      if (isProperlyQuoted(s))
        return unquote(s);
    }
    return null;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "while (it.hasNext()) {\r\n      S s = it.next();\r\n      if (isProperlyQuoted(s)..."; }});
}

static void consoleAndDefaultFrameIcon(String icon) {
  consoleIcon(icon);
  setDefaultFrameIcon(icon);
}
static RuntimeException fail() { throw new RuntimeException("fail"); }
static RuntimeException fail(Throwable e) { throw asRuntimeException(e); }
static RuntimeException fail(Object msg) { throw new RuntimeException(String.valueOf(msg)); }
static RuntimeException fail(String msg) { throw new RuntimeException(msg == null ? "" : msg); }
static RuntimeException fail(String msg, Throwable innerException) { throw new RuntimeException(msg, innerException); }

static Object call(Object o) {
  return callFunction(o);
}

// varargs assignment fixer for a single string array argument
static Object call(Object o, String method, String[] arg) {
  return call(o, method, new Object[] {arg});
}

static Object call(Object o, String method, Object... args) {
  try {
    if (o instanceof Class) {
      Method m = call_findStaticMethod((Class) o, method, args, false);
      m.setAccessible(true);
      return invokeMethod(m, null, args);
    } else {
      Method m = call_findMethod(o, method, args, false);
      m.setAccessible(true);
      return invokeMethod(m, o, args);
    }
  } catch (Exception e) {
    throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
  }
}

static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
}

static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && call_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
}

private static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}
static Rectangle screenRectangle() {
  return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
}

static List _registerWeakMap_preList;

static <A> A _registerWeakMap(A map) {
  if (javax() == null) {
    // We're in class init
    if (_registerWeakMap_preList == null) _registerWeakMap_preList = synchroList();
    _registerWeakMap_preList.add(map);
    return map;
  }
  
  try {
    call(javax(), "_registerWeakMap", map);
  } catch (Throwable e) {
    printException(e);
    print("Upgrade JavaX!!");
  }
  return map;
}

static void _onLoad_registerWeakMap() {
  assertNotNull(javax());
  if (_registerWeakMap_preList == null) return;
  for (Object o : _registerWeakMap_preList)
    _registerWeakMap(o);
  _registerWeakMap_preList = null;
}
static String getClassName(Object o) {
  return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
}
static Object invokeMethod(Method m, Object o, Object... args) { try {
  try {
    return m.invoke(o, args);
  } catch (InvocationTargetException e) {
    throw rethrow(getExceptionCause(e));
  } catch (IllegalArgumentException e) {
    throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
  }
} catch (Exception __e) { throw rethrow(__e); } }
static java.util.Timer doLater_daemon(long delay, final Object r) {
  final java.util.Timer timer = new java.util.Timer(true);
  timer.schedule(timerTask(r), delay);
  return timer;
}

static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static void centerConsole() {
  centerConsoleFrame();
}

static void centerConsole(int w, int h) {
  setConsoleSize(w, h);
  centerConsoleFrame();
}
static boolean isMainProgram() {
  return creator() == null;
}
static void restartWithDelay(int delay) {
  Object j = getJavaX();
  call(j, "preKill");
  call(j, "nohupJavax", smartJoin((String[]) get(j, "fullArgs")), call(j, "fullVMArguments"));
  sleep(delay);
  System.exit(0);
  sleep();
}
static <A> List<A> printNumberedLines(List<A> l) {
  printNumberedLines((Collection<A>) l);
  return l;
}

static void printNumberedLines(Map map) {
  printNumberedLines(mapToLines(map));
}

static <A extends Iterable> A printNumberedLines(A l) {
  int i = 0;
  if (l != null) for (Object a : l) print((++i) + ". " + str(a));
  return l;
}

static void printNumberedLines(Object[] l) {
  printNumberedLines(asList(l));
}

static void printNumberedLines(Object o) {
  printNumberedLines(lines(str(o)));
}
static File glyphTeachLog() {
  return javaxDataDir("Image Recognition/glyph-teaching.txt");
}
static JWindow infoBox(String text) {
  return infoMessage(text);
}

static JWindow infoBox(String text, double seconds) {
  return infoMessage(text, seconds);
}

static JWindow infoBox(Throwable e) {
  return infoMessage(e);
}
static String substanceLAF_defaultSkin = "Creme";

static void substanceLAF() {
  substanceLAF(null);
}

static void substanceLAF(String skinName) {
  try {
    enableSubstance_impl(or2(skinName, substanceLAF_defaultSkin));
  } catch (Throwable __e) { printStackTrace2(__e); }
}
static int loadPage_defaultTimeout = 60000;
static ThreadLocal<String> loadPage_charset = new ThreadLocal();
static boolean loadPage_allowGzip = true, loadPage_debug;
static boolean loadPage_anonymous; // don't send computer ID
static int loadPage_verboseness = 100000;
static int loadPage_retries = 1; //60; // seconds
static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();
static volatile int loadPage_forcedTimeout; // ms
static ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal(); // ms
static ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();

public static String loadPageSilently(String url) { try {
  return loadPageSilently(new URL(loadPage_preprocess(url)));
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadPageSilently(URL url) { try {
  if (url.getProtocol().equals("https"))
    disableCertificateValidation();
    
  IOException e = null;
  for (int tries = 0; tries < loadPage_retries; tries++)
    try {
      URLConnection con = loadPage_openConnection(url);
      return loadPage(con, url);
    } catch (IOException _e) {
      e = _e;
      if (loadPageThroughProxy_enabled) {
        print("Trying proxy because of: " + e);
        try {
          return loadPageThroughProxy(str(url));
        } catch (Throwable e2) {
          print("  " + exceptionToStringShort(e2));
        }
      } else if (loadPage_debug)
        print(e);
      if (tries < loadPage_retries-1) sleepSeconds(1);
    }
  throw e;
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage_preprocess(String url) {  
  if (url.startsWith("tb/")) // don't think we use this anymore
    url = tb_mainServer() + "/" + url;
  if (url.indexOf("://") < 0)
    url = "http://" + url;
  return url;
}

static String loadPage(String url) { try {
  url = loadPage_preprocess(url);
  if (!isTrue(loadPage_silent.get()))
    printWithTime("Loading: " + hideCredentials(url));
  return loadPageSilently(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage(URL url) {
  return loadPage(url.toExternalForm());
}

static String loadPage(URLConnection con, URL url) throws IOException {
  return loadPage(con, url, true);
}

static String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
  if (addHeaders) try {
    if (!loadPage_anonymous)
      setHeaders(con);
    if (loadPage_allowGzip)
      con.setRequestProperty("Accept-Encoding", "gzip");
    con.setRequestProperty("X-No-Cookies", "1");
    for (String key : keys(extraHeaders))
      con.setRequestProperty(key, extraHeaders.get(key));
  } catch (Throwable e) {} // fails if within doPost
  loadPage_responseHeaders.set(con.getHeaderFields());
  String contentType = con.getContentType();
  if (contentType == null) {
    //printStruct("Headers: ", con.getHeaderFields());
    throw new IOException("Page could not be read: " + url);
  }
  //print("Content-Type: " + contentType);
  String charset = loadPage_charset == null ? null : loadPage_charset.get();
  if (charset == null) charset = loadPage_guessCharset(contentType);
  
  InputStream in = con.getInputStream();
  try {
    if ("gzip".equals(con.getContentEncoding())) {
      if (loadPage_debug)
        print("loadPage: Using gzip.");
      in = newGZIPInputStream(in);
    }
    Reader r = new InputStreamReader(in, charset);
    
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  } finally { in.close(); }
}

static String loadPage_guessCharset(String contentType) {
  Pattern p = Pattern.compile("text/[a-z]+;\\s*charset=([^\\s]+)\\s*");
  Matcher m = p.matcher(contentType);
  String match = m.matches() ? m.group(1) : null;
  if (loadPage_debug)
    print("loadPage: contentType=" + contentType + ", match: " + match);
  /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
  //return or(match, "ISO-8859-1");
  return or(match, "UTF-8");
}

static URLConnection loadPage_openConnection(URL url) {
  URLConnection con = openConnection(url);
  int timeout = toInt(loadPage_forcedTimeout_byThread.get());
  if (timeout == 0) timeout = loadPage_forcedTimeout;
  if (timeout != 0)
    setURLConnectionTimeouts(con, loadPage_forcedTimeout);
  else
    setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
  return con;
}
static String loadCachedTranspilation(String id) {
  return loadTextFilePossiblyGZipped(new File(getCodeProgramDir(id), "Transpilation"));
}

static volatile boolean sleep_noSleep;

static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  if (sleep_noSleep) throw fail("nosleep");
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }
static List emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}

static List emptyList(int capacity) {
  return new ArrayList(capacity);
}

// Try to match capacity
static List emptyList(Iterable l) {
  return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
}
static void setConsoleHeight(int h) {
  setFrameHeight(consoleFrame(), h);
}
static long toMS(double seconds) {
  return (long) (seconds*1000);
}
static String structureForUser(Object o) {
  return beautifyStructure(struct_noStringSharing(o));
}
static String lines(Collection lines) { return fromLines(lines); }
static List<String> lines(String s) { return toLines(s); }
static String programID() {
  return getProgramID();
}
static boolean isLinux() {
  return !isWindows() && !isMac() && !isAndroid();
}
static boolean isMD5(String s) {
  return l(s) == 32 && isLowerHexString(s);
}
static void stopTimer(java.util.Timer timer) {
  if (timer != null) timer.cancel();
}
static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }
static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); } static long l(File f) { return f == null ? 0 : f.length(); }

static int l(Object o) {
  return o == null ? 0
    : o instanceof String ? l((String) o)
    : o instanceof Map ? l((Map) o)
    : o instanceof Collection ? l((Collection) o)
    : (Integer) call(o, "size");
}




static boolean structure_showTiming, structure_checkTokenCount;

static String structure(Object o) {
  return structure(o, new structure_Data());
}

static String structure(Object o, structure_Data d) {
  StringWriter sw = new StringWriter();
  d.out = new PrintWriter(sw);
  structure_go(o, d);
  String s = str(sw);
  if (structure_checkTokenCount) {
    print("token count=" + d.n);
    assertEquals("token count", l(javaTokC(s)), d.n);
  }
  return s;
}

static void structure_go(Object o, structure_Data d) {
  structure_1(o, d);
  while (nempty(d.stack))
    popLast(d.stack).run();
}

static void structureToPrintWriter(Object o, PrintWriter out) {
  structure_Data d = new structure_Data();
  d.out = out;
  structure_go(o, d);
}

// leave to false, unless unstructure() breaks
static boolean structure_allowShortening = false;

static class structure_Data {
  PrintWriter out;
  int stringSizeLimit;
  int shareStringsLongerThan = 20;
  boolean noStringSharing;

  IdentityHashMap<Object,Integer> seen = new IdentityHashMap();
  //new BitSet refd;
  HashMap<String,Integer> strings = new HashMap();
  HashSet<String> concepts = new HashSet();
  HashMap<Class, List<Field>> fieldsByClass = new HashMap();
  int n; // token count
  List<Runnable> stack = new ArrayList();
  
  // append single token
  structure_Data append(String token) { out.print(token); ++n; return this; }
  structure_Data append(int i) { out.print(i); ++n; return this; }
  
  // append multiple tokens
  structure_Data append(String token, int tokCount) { out.print(token); n += tokCount; return this; }
  
  // extend last token
  structure_Data app(String token) { out.print(token); return this; }
  structure_Data app(int i) { out.print(i); return this; }
}

static void structure_1(final Object o, final structure_Data d) {
  if (o == null) { d.append("null"); return; }
  
  Class c = o.getClass();
  boolean concept = false;
  
  List<Field> lFields = d.fieldsByClass.get(c);
  
  if (lFields == null) {
    // these are never back-referenced (for readability)
    
    if (o instanceof Number) {
      PrintWriter out = d.out;
if (o instanceof Integer) { int i = ((Integer) o).intValue(); out.print(i); d.n += i < 0 ? 2 : 1; return; }
      if (o instanceof Long) { long l = ((Long) o).longValue(); out.print(l); out.print("L"); d.n += l < 0 ? 2 : 1; return; }
      if (o instanceof Short) { short s = ((Short) o).shortValue(); d.append("sh ", 2); out.print(s); d.n += s < 0 ? 2 : 1; return; }
      if (o instanceof Float) { d.append("fl ", 2); quoteToPrintWriter(str(o), out); return; }
      if (o instanceof Double) { d.append("d(", 3); quoteToPrintWriter(str(o), out); d.append(")"); return; }
      if (o instanceof BigInteger) { out.print("bigint("); out.print(o); out.print(")"); d.n += ((BigInteger) o).signum() < 0 ? 5 : 4; return; }
    }
  
    if (o instanceof Boolean) {
      d.append(((Boolean) o).booleanValue() ? "t" : "f"); return;
    }
      
    if (o instanceof Character) {
      d.append(quoteCharacter((Character) o)); return;
    }
      
    if (o instanceof File) {
      d.append("File ").append(quote(((File) o).getPath())); return;
    }
      
    // referencable objects follow
    
    Integer ref = d.seen.get(o);
    if (o instanceof String && ref == null) ref = d.strings.get((String) o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }

    if (!(o instanceof String))
      d.seen.put(o, d.n); // record token number
    else {
      String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
      if (!d.noStringSharing) {
        if (d.shareStringsLongerThan == Integer.MAX_VALUE)
          d.seen.put(o, d.n);
        if (l(s) >= d.shareStringsLongerThan)
          d.strings.put(s, d.n);
      }
      quoteToPrintWriter(s, d.out); d.n++; return;
    }
      
    if (o instanceof HashSet) {
      d.append("hashset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
  
    if (o instanceof TreeSet) {
      d.append("treeset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
    
    String name = c.getName();
    if (o instanceof Collection
      && !startsWith(name, "main$")
      /* && neq(name, "main$Concept$RefL") */) {
      d.append("[");
      final int l = d.n;
      final Iterator it = ((Collection) o).iterator();
      d.stack.add(new Runnable() { public void run() { try { 
        if (!it.hasNext())
          d.append("]");
        else {
          d.stack.add(this);
          if (d.n != l) d.append(", ");
          structure_1(it.next(), d);
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta..."; }});
      return;
    }
    
    if (o instanceof Map && !startsWith(name, "main$")) {
      if (o instanceof LinkedHashMap) d.append("lhm");
      else if (o instanceof HashMap) d.append("hm");
      d.append("{");
      final int l = d.n;
      final Iterator it = ((Map) o).entrySet().iterator();
      
      d.stack.add(new Runnable() {
        boolean v;
        Map.Entry e;
        
        public void run() {
          if (v) {
            d.append("=");
            v = false;
            d.stack.add(this);
            structure_1(e.getValue(), d);
          } else {
            if (!it.hasNext())
              d.append("}");
            else {
              e = (Map.Entry) it.next();
              v = true;
              d.stack.add(this);
              if (d.n != l) d.append(", ");
              structure_1(e.getKey(), d);
            }
          }
        }
      });
      return;
    }
    
    if (c.isArray()) {
      if (o instanceof byte[]) {
        d.append("ba ").append(quote(bytesToHex((byte[]) o))); return;
      }
  
      final int n = Array.getLength(o);
  
      if (o instanceof boolean[]) {
        String hex = boolArrayToHex((boolean[]) o);
        int i = l(hex);
        while (i > 0 && hex.charAt(i-1) == '0' && hex.charAt(i-2) == '0') i -= 2;
        d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i))); return;
      }
      
      String atype = "array", sep = ", ";
  
      if (o instanceof int[]) {
        //ret "intarray " + quote(intArrayToHex((int[]) o));
        atype = "intarray";
        sep = " ";
      }
      
      d.append(atype).append("{");
      d.stack.add(new Runnable() {
        int i;
        public void run() {
          if (i >= n)
            d.append("}");
          else {
            d.stack.add(this);
            if (i > 0) d.append(", ");
            structure_1(Array.get(o, i++), d);
          }
        }
      });
      return;
    }
  
    if (o instanceof Class) {
      d.append("class(", 2).append(quote(((Class) o).getName())).append(")"); return;
    }
      
    if (o instanceof Throwable) {
      d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")"); return;
    }
      
    if (o instanceof BitSet) {
      BitSet bs = (BitSet) o;
      d.append("bitset{", 2);
      int l = d.n;
      for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i+1)) {
        if (d.n != l) d.append(", ");
        d.append(i);
      }
      d.append("}"); return;
    }
      
    // Need more cases? This should cover all library classes...
    if (name.startsWith("java.") || name.startsWith("javax.")) {
      d.append("j ").append(quote(str(o))); return; // Hm. this is not unstructure-able
    }
    
    
      
    /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
    
    String dynName = shortDynamicClassName(o);
    if (concept && !d.concepts.contains(dynName)) {
      d.concepts.add(dynName);
      d.append("c ");
    }
    
    // serialize an object with fields.
    // first, collect all fields and values in fv.
    
    TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {
      public int compare(Field a, Field b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    
    Class cc = c;
    while (cc != Object.class) {
      for (Field field : getDeclaredFields_cached(cc)) {
        if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
          continue;
        String fieldName = field.getName();
        
        fields.add(field);
        
        // put special cases here...
      }
        
      cc = cc.getSuperclass();
    }
    
    lFields = asList(fields);
    
    // Render this$1 first because unstructure needs it for constructor call.
    
    for (int i = 0; i < l(lFields); i++) {
      Field f = lFields.get(i);
      if (f.getName().equals("this$1")) {
        lFields.remove(i);
        lFields.add(0, f);
        break;
      }
    }
  
    
    d.fieldsByClass.put(c, lFields);
  } // << if (lFields == null)
  else { // ref handling for lFields != null
    Integer ref = d.seen.get(o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }
    d.seen.put(o, d.n); // record token number
  }

  LinkedHashMap<String,Object> fv = new LinkedHashMap();
  for (Field f : lFields) {
    Object value;
    try {
      value = f.get(o);
    } catch (Exception e) {
      value = "?";
    }
      
    if (value != null)
      fv.put(f.getName(), value);
    
  }
  
  String name = c.getName();
  String shortName = dropPrefix("main$", name);
    
  // Now we have fields & values. Process fieldValues if it's a DynamicObject.
  
  // omit field "className" if equal to class's name
  if (concept && eq(fv.get("className"), shortName))
    fv.remove("className");
          
  if (o instanceof DynamicObject) {
    fv.putAll((Map) fv.get("fieldValues"));
    fv.remove("fieldValues");
    shortName = shortDynamicClassName(o);
    fv.remove("className");
  }
  
  String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
  
  d.append(shortName);
  
  
  final int l = d.n;
  final Iterator it = fv.entrySet().iterator();
  
  d.stack.add(new Runnable() { public void run() { try { 
    if (!it.hasNext()) {
      if (d.n != l)
        d.append(")");
    } else {
      Map.Entry e = (Map.Entry) it.next();
      d.append(d.n == l ? "(" : ", ");
      d.append((String) e.getKey()).append("=");
      d.stack.add(this);
      structure_1(e.getValue(), d);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else..."; }});
}

static String autoRestart_localMD5;

static String autoRestart_localMD5() { 
  if (autoRestart_localMD5 == null)
    autoRestart_localMD5 = md5(loadCachedTranspilation(programID()));
  return autoRestart_localMD5;
}
static boolean headless() {
  return isHeadless();
}
static String programTitle() {
  return getProgramName();
}
static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}
static BufferedImage loadPNG(File file) {
  return loadBufferedImage(file);
}
static Map<String, BWImage> getLearnedCharacters2() {
  Matches m = new Matches();
  HashSet<String> md5s = new HashSet();
  for (String s : scanLog_iterator(glyphTeachLog()))
    if (find3("the images *", afterSquareBracketStuff(s), m))
      md5s.addAll(splitAtSpace(m.unq(0)));
  //print("MD5s we're looking for: " + struct(md5s));
  
  HashMap<String,BWImage> md5ToImage = new HashMap();
  { final Map<String, File> __57 = screenClipFiles(); for (String md5 : keys( __57)) { File f =__57.get(md5); 
    BWImage img = loadBWImage(f);
    if (md5s.contains(md5))
      md5ToImage.put(md5, img);
    for (BWImage cImg : horizontalAutoSplitToImages(img)) {
      String cMD5 = ocrMD5OfBWImage(cImg);
      if (md5s.contains(cMD5))
        md5ToImage.put(cMD5, cImg);
    }
  }
  
  }int found = l(md5ToImage);
  print("Found character images: " + found + "/" + l(md5s));
  return md5ToImage;
}
static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static File linux_fileInRamDisk(String name) {
  if (!isLinux()) return null;
  File dir = newFile("/dev/shm");
  if (dir.isDirectory()) return newFile(dir, name);
  return null;
}
static <A, B> Map<B, A> reverseMap(Map<A, B> map) {
  Map<B,A> rmap = new HashMap();
  for (A key : keys(map))
    rmap.put(map.get(key), key);
  return rmap;
}
static int backtick_exitValue;
static boolean backtick_verbose, backtick_keepScript;
static ThreadLocal<File> backtick_scriptFile = new ThreadLocal();
static ThreadLocal<Boolean> backtick_uninterruptable = new ThreadLocal(); // Great trick, thanks to Tim Bunce @ http://stackoverflow.com/questions/12856620/how-to-handle-signals-in-bash-during-synchronous-execution

static boolean backtick_win_cmd; // bugfixing

static String backtick(String cmd) { try {
  File outFile = File.createTempFile("_backtick", "");
  backtickToFile(cmd, outFile);
  String result = loadTextFile(outFile.getPath(), "");
  if (backtick_verbose) {
    //print("backtick: script length after=" + backtick_scriptFile->length());
    print("[[\n" + result + "]]");
  }
  outFile.delete();
  return result;
} catch (Exception __e) { throw rethrow(__e); } }

static Process backtickToFile(String cmd, File outFile) { try {
  try {
    Process process = backtickToFile_noWait(cmd, outFile);
    process.waitFor();
    backtick_exitValue = process.exitValue();
    if (backtick_verbose)
      System.out.println("Process return code: " + backtick_exitValue);
    return process;
  } finally {
    if (!backtick_keepScript)
      deleteFile(backtick_scriptFile.get());
    backtick_scriptFile.set(null);
  }
} catch (Exception __e) { throw rethrow(__e); } }

static Process backtickToFile_noWait(String cmd, File outFile) { try {
  File scriptFile = File.createTempFile("_backtick", isWindows() ? ".bat" : "");
  backtick_scriptFile.set(scriptFile);
  if (backtick_verbose)
    print("backtick: scriptFile " + f2s(scriptFile));

  cmd = trim(cmd);
  if (numLines(cmd) > 1) throw fail("No multi-line commands allowed");
  String command = cmd + " >" + bashQuote(outFile.getPath()) + " 2>&1";
  if (!isTrue(backtick_uninterruptable.get()) && !isWindows()) command = fixNewLines("\r\ninterruptable() {\r\n\r\n    # handle options\r\n    local setsid=\"\"\r\n    local debug=false\r\n    while true; do\r\n        case \"${1:-}\" in\r\n            --killall)      setsid=setsid; shift ;;\r\n            --debug)        debug=true; shift ;;\r\n            --*)            echo \"Invalid option: $1\" 1>&2; exit 1;;\r\n            *)              break;; # no more options\r\n        esac\r\n    done\r\n\r\n    # start the specified command\r\n    $setsid \"$@\" &\r\n    local child_pid=$!\r\n\r\n    # arrange to propagate a signal to the child process\r\n    trap '\r\n        exec 1>&2\r\n        set +e\r\n        trap \"\" SIGPIPE # ensure a possible sigpipe from the echo does not prevent the kill\r\n        echo \"${BASH_SOURCE[0]} caught SIGTERM while executing $* (pid $child_pid), sending SIGTERM to it\"\r\n        # (race) child may have exited in which case kill will report an error\r\n        # if setsid is used then prefix the pid with a \"-\" to indicate that the signal\r\n        # should be sent to the entire process group\r\n        kill ${setsid:+-}$child_pid\r\n        exit 143\r\n    ' SIGTERM\r\n    # ensure that the trap doesn't persist after we return\r\n    trap 'trap - SIGTERM' RETURN\r\n\r\n    $debug && echo \"interruptable wait (child $child_pid, self $$) for: $*\"\r\n\r\n    # An error status from the child process will trigger an exception (via set -e)\r\n    # here unless the caller is checking the return status\r\n    wait $child_pid # last command, so status of waited for command is returned\r\n}\r\n\r\ninterruptable ") + command;
  //Log.info("[Backtick] " + command);
  if (backtick_verbose) {
    print("backtick: command " + command);
    print("backtick: saving to " + scriptFile.getPath());
  }
  saveTextFile(scriptFile.getPath(), command);
  if (backtick_verbose)
    print("backtick: command length=" + l(command) + ", file length=" + scriptFile.length());
  String[] command2;
  if (isWindows())
    if (backtick_win_cmd)
      command2 = new String[] { "cmd", "/c", scriptFile.getPath() };
    else
      command2 = new String[] { scriptFile.getPath() };
  else
    command2 = new String[] { "/bin/bash", scriptFile.getPath() };
  if (backtick_verbose)
    print("backtick: command2 " + structure(command2));
  return Runtime.getRuntime().exec(command2);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(String text) { try {
  if (text == null) return "-";
  return bytesToHex(md5_impl(text.getBytes("UTF-8"))); // maybe different than the way PHP does it...
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(byte[] data) {
  if (data == null) return "-";
  return bytesToHex(md5_impl(data));
}

static MessageDigest md5_md;

/*static byte[] md5_impl(byte[] data) ctex {
  if (md5_md == null)
    md5_md = MessageDigest.getInstance("MD5");
  return ((MessageDigest) md5_md.clone()).digest(data);
}*/

static byte[] md5_impl(byte[] data) { try {
  return MessageDigest.getInstance("MD5").digest(data);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(File file) { try {
  return md5(loadBinaryFile(file));
} catch (Exception __e) { throw rethrow(__e); } }


static Font typeWriterFont() {
  return typeWriterFont(14);
}
  
static Font typeWriterFont(int size) {
  return new Font("Courier", Font.PLAIN, size);
}
static String htag(String tag) {
  return htag(tag, "");
}

static String htag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  if (empty(s) && neqic(tag, "script"))
    return dropLast(openingTag) + "/>";
  return openingTag + s + "</" + tag + ">";
}
static Throwable getExceptionCause(Throwable e) {
  Throwable c = e.getCause();
  return c != null ? c : e;
}
static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static String ocrMD5OfBWImage(BWImage img) {
  return rgbMD5(img.toRGB());
}
static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
  out.append('"');
}
static void printWithTime(String s) {
  print(hmsWithColons() + ": " + s);
}
static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }
static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
public static boolean isWindows() {
  return System.getProperty("os.name").contains("Windows");
}
static String quoteCharacter(char c) {
  if (c == '\'') return "'\\''";
  if (c == '\\') return "'\\\\'";
  if (c == '\r') return "'\\r'";
  if (c == '\n') return "'\\n'";
  if (c == '\t') return "'\\t'";
  return "'" + c + "'";
}

static boolean isLowerHexString(String s) {
  for (int i = 0; i < l(s); i++) {
    char c = s.charAt(i);
    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      // ok
    } else
      return false;
  }
  return true;
}
static String shortDynamicClassName(Object o) {
 if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  return shortClassName(o);
}
static boolean infoMessage_alwaysOnTop = true;
static double infoMessage_defaultTime = 5.0;

// automatically switches to AWT thread for you
static JWindow infoMessage(String text) {
  return infoMessage(text, infoMessage_defaultTime);
}

static JWindow infoMessage(final String text, final double seconds) {
  print(text);
  return infoMessage_noprint(text, seconds);
}

static JWindow infoMessage_noprint(String text) {
  return infoMessage_noprint(text, infoMessage_defaultTime);
}

static JWindow infoMessage_noprint(final String text, final double seconds) {
  if (empty(text)) return null;
  logQuotedWithDate(infoBoxesLogFile(), text); 
  if (isHeadless()) return null;
  return (JWindow) swingAndWait(new F0<Object>() { Object get() { try { 
    final JWindow window = showWindow(infoMessage_makePanel(text));
    window.setSize(300, 150);
    moveToTopRightCorner(window);
    if (infoMessage_alwaysOnTop)
      window.setAlwaysOnTop(true);
    window.setVisible(true);
    disposeWindowAfter(iround(seconds*1000), window);
    return window;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "final JWindow window = showWindow(infoMessage_makePanel(text));\r\n    window.s..."; }});
}

static JWindow infoMessage(Throwable e) {
  showConsole();
  printStackTrace(e);
  return infoMessage(exceptionToStringShort(e));
}
static <A> Iterator<A> chainIterators(Collection<Iterator<A>> l) {
  final List<Iterator<A>> _l = new LinkedList(l);
  return iteratorFromFunction(new F0<A>() { A get() { try { 
    while (nempty(_l)) {
      if (first(_l).hasNext())
        return first(_l).next();
      _l.remove(0);
    }
    return null;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "while (nempty(_l)) {\r\n      if (first(_l).hasNext())\r\n        ret first(_l).n..."; }});
}
static boolean isProperlyQuoted(String s) {
  return s.length() >= 2
    && s.startsWith("\"")
    && s.endsWith("\"")
    && (!s.endsWith("\\\"") || s.endsWith("\\\\\""));
}
static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
 // Substance
 // Trident (required by Substance)




static void enableSubstance_impl(final String skinName) {
  if (headless()) return;
  { swing(new Runnable() { public void run() { try { 
    if (!substanceLookAndFeelEnabled())
      enableSubstance_impl_2(skinName);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!substanceLookAndFeelEnabled())\r\n      enableSubstance_impl_2(skinName);"; }}); }
}

static void enableSubstance_impl_2(String skinName) { try {
  boolean wasEnabled = substanceLookAndFeelEnabled();
  ClassLoader cl = main.class.getClassLoader();
  UIManager.getDefaults().put("ClassLoader", cl);
  Thread.currentThread().setContextClassLoader(cl);
  String skinClassName = "org.pushingpixels.substance.api.skin." + addSuffix(skinName, "Skin");
  SubstanceSkin skin = (SubstanceSkin) nuObject(cl.loadClass(skinClassName));
  SubstanceLookAndFeel.setSkin(skin);
  JFrame.setDefaultLookAndFeelDecorated(true);  
  updateLookAndFeelOnAllWindows_noRenew();
  if (!wasEnabled) renewConsoleFrame();
  
  if (substanceLookAndFeelEnabled())
    print("Substance L&F enabled.");
  else
    print("Could not enable Substance L&F?");
} catch (Exception __e) { throw rethrow(__e); } }
  static boolean isMac() {
    return System.getProperty("os.name").toLowerCase().contains("mac");
	}
static String programID;

static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}


// TODO: ask JavaX instead
static String getProgramID(Class c) {
  String id = (String) getOpt(c, "programID");
  if (nempty(id))
    return formatSnippetID(id);
  return "?";
}


static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}
static boolean find3(String pat, String s) {
  return find3(pat, s, null);
}

static boolean find3(String pat, String s, Matches matches) {
  List<String> tokpat = parse3(pat), toks = parse3(s);
  String[] m = find2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}
static String hideCredentials(URL url) { return url == null ? null : hideCredentials(str(url)); }

static String hideCredentials(String url) {
  return url.replaceAll("([&?])_pass=[^&\\s\"]*", "$1_pass=<hidden>");
}

static String hideCredentials(Object o) {
  return hideCredentials(str(o));
}
static void incAtomicLong(AtomicLong l) {
  l.incrementAndGet();
}
static BWImage loadBWImage(String snippetIDOrURL) {
  return new BWImage(loadBufferedImage(snippetIDOrURL));
}

static BWImage loadBWImage(File f) {
  return new BWImage(loadBufferedImage(f));
}
static Class __javax;

static Class getJavaX() {
  return __javax;
}
static void setHeaders(URLConnection con) throws IOException {
  
  String computerID = getComputerID_quick();
  if (computerID != null) try {
    con.setRequestProperty("X-ComputerID", computerID);
    con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
  } catch (Throwable e) {
    //printShortException(e);
  }
  
}
static File findCmdOnPATH(String cmd) {
  String path = System.getenv("PATH");
  List<String> dirs = splitAt(path, File.pathSeparator);
  String c = isWindows() ? cmd + ".exe" : cmd;
  for (String dir : dirs) {
    File f = new File(dir, c);
    if (f.isFile()) return f;
  }
  return null;
}
static String exceptionToStringShort(Throwable e) {
  lastException(e);
  e = getInnerException(e);
  String msg = unnull(e.getMessage());
  if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
    return baseClassName(e) + prependIfNempty(": ", msg);
  else
    return msg;
}
static List<File> earlierPartsOfLogFile(File file) {
  String name = file.getName() + ".part";
  try {
    Matches m = new Matches();
    TreeMap<Integer,File> map = new TreeMap();
    for (File p : listFiles(file.getParent())) try {
      String n = p.getName();
      if (startsWith(n, name, m))
        map.put(parseFirstInt(m.rest()), p);
    } catch (Throwable __e) { printStackTrace2(__e); }
    return valuesList(map);
  } catch (Throwable e) { printException(e);
    return ll();
  }
}
static HashMap<Class, Field[]> getDeclaredFields_cache = new HashMap();

static Field[] getDeclaredFields_cached(Class c) {
  Field[] fields;
  synchronized(getDeclaredFields_cache) {
    fields = getDeclaredFields_cache.get(c);
    if (fields == null) {
      getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
      for (Field f : fields)
        f.setAccessible(true);
    }
  }
  return fields;
}
static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  if (o instanceof ThreadLocal)
    return isTrue(((ThreadLocal) o).get());
  throw fail(getClassName(o));
}
static boolean loadBufferedImage_useImageCache = true;

static BufferedImage loadBufferedImage(String snippetIDOrURL) { try {
  if (snippetIDOrURL == null) return null;
  if (isURL(snippetIDOrURL))
    return ImageIO.read(new URL(snippetIDOrURL));

  if (!isSnippetID(snippetIDOrURL)) throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
  String snippetID = "" + parseSnippetID(snippetIDOrURL);
  
  File dir = getCacheProgramDir("Image-Snippets");
  if (loadBufferedImage_useImageCache) {
    dir.mkdirs();
    File file = new File(dir, snippetID + ".png");
    if (file.exists() && file.length() != 0)
      try {
        return ImageIO.read(file);
      } catch (Throwable e) {
        e.printStackTrace();
        // fall back to loading from sourceforge
      }
  }

  String imageURL = snippetImageURL(snippetID);
  System.err.println("Loading image: " + imageURL);
  BufferedImage image = ImageIO.read(new URL(imageURL));

  if (loadBufferedImage_useImageCache) {
    File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
    ImageIO.write(image, "png", tempFile);
    tempFile.renameTo(new File(dir, snippetID + ".png"));
    //Log.info("Cached image.");
  }

  //Log.info("Loaded image.");
  return image;
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedImage loadBufferedImage(File file) { try {
  return file.isFile() ? ImageIO.read(file) : null;
} catch (Exception __e) { throw rethrow(__e); } }
static String boolArrayToHex(boolean[] a) {
  return bytesToHex(boolArrayToBytes(a));
}
static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (isAndroid()) return isHeadless_cache = true;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static Iterator emptyIterator() {
  return Collections.emptyIterator();
}
static void setDefaultFrameIcon(String icon) {
  makeFrame_defaultIcon = icon;
}
static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
  A a = tl.get();
  tl.set(null);
  return a;
}
  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }

static Class javax() {
  return getJavaX();
}
static File getCodeProgramDir() {
  return getCodeProgramDir(getProgramID());
}

static File getCodeProgramDir(String snippetID) {
  return new File(javaxCodeDir(), formatSnippetID(snippetID));
}

static File getCodeProgramDir(long snippetID) {
  return getCodeProgramDir(formatSnippetID(snippetID));
}
static IterableIterator<String> linesFromFile(File f) { try {
  if (!f.exists()) return emptyIterableIterator();
  if (ewic(f.getName(), ".gz"))
    return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)));
  return linesFromReader(utf8bufferedReader(f));
} catch (Exception __e) { throw rethrow(__e); } }
static URLConnection openConnection(URL url) { try {
  ping();
  
  callOpt(javax(), "recordOpenURLConnection", str(url));
  
  return url.openConnection();
} catch (Exception __e) { throw rethrow(__e); } }
static void printException(Throwable e) {
  printStackTrace(e);
}
static String or2(String a, String b) {
  return nempty(a) ? a : b;
}

static String or2(String a, String b, String c) {
  return or2(or2(a, b), c);
}
/** writes safely (to temp file, then rename) */
static File saveTextFile(String fileName, String contents) throws IOException {
  CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  try {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists()) try {
        String saveName = tempFileName + ".saved." + now();
        copyFile(tempFile, new File(saveName));
      } catch (Throwable e) { printStackTrace(e); }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(contents);
      printWriter.close();
    }
    
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
  
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
        
    return file;
  } finally {
    action.done();
  }
}

static File saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
  return fileName;
} catch (Exception __e) { throw rethrow(__e); } }
static URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
  if (con.getConnectTimeout() == 0) {
    con.setConnectTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout)
      print("Warning: URL connect timeout not set by JDK.");
  }
  if (con.getReadTimeout() == 0) {
    con.setReadTimeout(toInt(timeout));
    if (con.getReadTimeout() != timeout)
      print("Warning: URL read timeout not set by JDK.");
  }
  return con;
}
static String beautifyStructure(String s) {
  return structure_addTokenMarkers(s);
}
public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) // is null if file is in current dir
    dir.mkdirs();
  return file;
}

public static String mkdirsForFile(String path) {
  mkdirsForFile(new File(path));
  return path;
}
static void centerConsoleFrame() {
  centerFrame(consoleFrame());
}
static File newFile(File base, String... names) {
  for (String name : names) base = new File(base, name);
  return base;
}

static File newFile(String name) {
  return name == null ? null : new File(name);
}
// usually L<S>
static String fromLines(Collection lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null)
    for (Object line : lines)
      buf.append(str(line)).append('\n');
  return buf.toString();
}

static String fromLines(String... lines) {
  return fromLines(asList(lines));
}
static String trimSubstring(String s, int x) {
  return trim(substring(s, x));
}

static String trimSubstring(String s, int x, int y) {
  return trim(substring(s, x, y));
}


static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static Thread startThread(Object runnable) {
  return startThread(defaultThreadName(), runnable);
}

static Thread startThread(String name, Object runnable) {
  runnable = wrapAsActivity(runnable);
  return startThread(newThread(toRunnable(runnable), name));
}

static Thread startThread(Thread t) {
  
  _registerThread(t);
  
  t.start();
  return t;
}
static String unquote(String s) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();
    }
  }
    
  return s; // not quoted - return original
}
static boolean deleteFile(File file) {
  return file != null && file.delete();
}
static File getProgramFile(String progID, String fileName) {
  if (new File(fileName).isAbsolute())
    return new File(fileName);
  return new File(getProgramDir(progID), fileName);
}

static File getProgramFile(String fileName) {
  return getProgramFile(getProgramID(), fileName);
}

static boolean nempty(Collection c) {
  return !isEmpty(c);
}

static boolean nempty(CharSequence s) {
  return !isEmpty(s);
}

static boolean nempty(Object[] o) { return !isEmpty(o); }
static boolean nempty(byte[] o) { return !isEmpty(o); }

static boolean nempty(Map m) {
  return !isEmpty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}

static boolean nempty(Object o) { return !empty(o); }
static String makeRandomID(int length) {
  Random random = new Random();
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}
static GZIPInputStream newGZIPInputStream(File f) {
  return gzInputStream(f);
}

static GZIPInputStream newGZIPInputStream(InputStream in) {
  return gzInputStream(in);
}
public static byte[] loadBinaryFile(String fileName) {
 try {
  if (!new File(fileName).exists())
    return null;

  FileInputStream in = new FileInputStream(fileName);

  byte buf[] = new byte[1024];
  ByteArrayOutputStream out = new ByteArrayOutputStream();
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    out.write(buf, 0, l);
  }
  in.close();
  return out.toByteArray();
 } catch (IOException e) { throw new RuntimeException(e); }
}

public static byte[] loadBinaryFile(File file) {
  return loadBinaryFile(file.getPath());
}

static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) {
  try {
    Field f = getOpt_findField(o.getClass(), field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

// access of static fields is not yet optimized
static Object getOpt(Class c, String field) {
  try {
    if (c == null) return null;
    Field f = getOpt_findStaticField(c, field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static <A> A popLast(List<A> l) {
  return liftLast(l);
}
static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}

/*static void printStackTrace2(S indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace2(e));
}*/
static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static String joinWithSpace(Collection<String> c) {
  return join(" ", c);
}

static String joinWithSpace(String... c) {
  return join(" ", c);
}

static List<String> splitAtSpace(String s) {
  return asList(s.split("\\s+"));
}
static List<String> classNames(Collection l) {
  return getClassNames(l);
}

static List<String> classNames(Object[] l) {
  return getClassNames(Arrays.asList(l));
}
static String loadTextFilePossiblyGZipped(String fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}
  
static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
  File gz = new File(fileName + ".gz");
  return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
}

static String loadTextFilePossiblyGZipped(File fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}

static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
  return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
}

static int shorten_default = 100;

static String shorten(String s) { return shorten(s, shorten_default); }

static String shorten(String s, int max) {
  return shorten(s, max, "...");
}

static String shorten(String s, int max, String shortener) {
  if (s == null) return "";
  if (max < 0) return s;
  return s.length() <= max ? s : substring(s, 0, min(s.length(), max-l(shortener))) + shortener;
}

static String shorten(int max, String s) { return shorten(s, max); }
static URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
  con.setConnectTimeout(toInt(timeout));
  con.setReadTimeout(toInt(timeout));
  if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
    print("Warning: Timeouts not set by JDK.");
  return con;
}
static List<BWImage> horizontalAutoSplitToImages(BWImage img) {
  List<BWImage> l = new ArrayList();
  for (Rect r : horizontalAutoSplit2ThenAutoCrop(img))
    l.add(img.clip(r));
  return l;
}
static String dropPrefix(String prefix, String s) {
  return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
}
static int numLines(String s) {
  return countLines(s);
}
static List<String> mapToLines(Map map) {
  List<String> l = new ArrayList();
  for (Object key : keys(map))
    l.add(str(key) + " = " + str(map.get(key)));
  return l;
}
static TimerTask timerTask(final Object r, final java.util.Timer timer) {
  return new TimerTask() {
    public void run() {
      if (!licensed())
        timer.cancel();
      else
        pcallF(r);
    }
  };
}

static TimerTask timerTask(final Object r) {
  return new TimerTask() {
    public void run() {
      ping();
      pcallF(r);
    }
  };
}
static IterableIterator<String> toLines(File f) {
  return linesFromFile(f);
}

static List<String> toLines(String s) {
  List<String> lines = new ArrayList<String>();
  if (s == null) return lines;
  int start = 0;
  while (true) {
    int i = toLines_nextLineBreak(s, start);
    if (i < 0) {
      if (s.length() > start) lines.add(s.substring(start));
      break;
    }

    lines.add(s.substring(start, i));
    if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
      i += 2;
    else
      ++i;

    start = i;
  }
  return lines;
}

static int toLines_nextLineBreak(String s, int start) {
  for (int i = start; i < s.length(); i++) {
    char c = s.charAt(i);
    if (c == '\r' || c == '\n')
      return i;
  }
  return -1;
}
static WeakReference<Class> creator_class;

static Class creator() {
  return creator_class == null ? null : creator_class.get();
}
static JFrame setFrameHeight(JFrame frame, int h) {
  frame.setSize(frame.getWidth(), h);
  return frame;
}

static JFrame setFrameHeight(int h, JFrame frame) {
  return setFrameHeight(frame, h);
}

static List<String> javaTokC(String s) {
  if (s == null) return null;
  int l = s.length();
  ArrayList<String> tok = new ArrayList();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    i = j;
  }
  
  return tok;
}
static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}
static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}




static volatile boolean disableCertificateValidation_attempted;

static void disableCertificateValidation() { try {
  if (disableCertificateValidation_attempted) return;
  disableCertificateValidation_attempted = true;
  
  try {
    // Create a trust manager that does not validate certificate chains
    TrustManager[] trustAllCerts = new TrustManager[] { 
      new X509TrustManager() {
        public X509Certificate[] getAcceptedIssuers() { 
          return new X509Certificate[0]; 
        }
        public void checkClientTrusted(X509Certificate[] certs, String authType) {}
        public void checkServerTrusted(X509Certificate[] certs, String authType) {}
    }};
  
    // Ignore differences between given hostname and certificate hostname
    HostnameVerifier hv = new HostnameVerifier() {
      public boolean verify(String hostname, SSLSession session) { return true; }
    };
  
    // Install the all-trusting trust manager
    SSLContext sc = SSLContext.getInstance("SSL");
    sc.init(null, trustAllCerts, new SecureRandom());
    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    HttpsURLConnection.setDefaultHostnameVerifier(hv);
  } catch (Throwable __e) { printStackTrace2(__e); }
} catch (Exception __e) { throw rethrow(__e); } }
// Try to get the quoting right...

static String smartJoin(String[] args) {
  if (args.length == 1) return args[0];
  
  String[] a = new String[args.length];
  for (int i = 0; i < a.length; i++)
    a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
  return join(" ", a);
}

static String smartJoin(List<String> args) {
  return smartJoin(toStringArray(args));
}
static final boolean loadPageThroughProxy_enabled = false;

static String loadPageThroughProxy(String url) {
  return null;
}
static Object first(Object list) {
  return empty((List) list) ? null : ((List) list).get(0);
}

static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }


static <A, B> A first(Pair<A, B> p) {
  return p == null ? null : p.a;
}

static <A> List<A> ll(A... a) {
  ArrayList l = new ArrayList(a.length);
  for (A x : a) l.add(x);
  return l;
}
static Class mc() {
  return main.class;
}
static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}
static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  for (int i = startIndex; i < l(l); i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, int startIndex, A a) {
  return indexOf(l, a, startIndex);
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b) {
  return a == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, int i, char b) {
  return indexOf(a, b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  if (x == null) return -1;
  for (int i = 0; i < l(x); i++)
    if (eq(x[i], a))
      return i;
  return -1;
}
static void quoteToPrintWriter(String s, PrintWriter out) {
  if (s == null) { out.print("null"); return; }
  out.print('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"') {
      out.print('\\'); out.print(c);
    } else if (c == '\r')
      out.print("\\r");
    else if (c == '\n')
      out.print("\\n");
    else
      out.print(c);
  }
  out.print('"');
}
// extended over Class.isInstance() to handle primitive types
static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static <A> List<A> concatLists(Collection<A>... lists) {
  List<A> l = new ArrayList();
  for (Collection<A> list : lists)
    if (list != null)
      l.addAll(list);
  return l;
}

static <A> List<A> concatLists(Collection<? extends Collection<A>> lists) {
  List<A> l = new ArrayList();
  for (Collection<A> list : lists)
    if (list != null)
      l.addAll(list);
  return l;
}

// f: func -> A (stream ends when f returns null)
static <A> IterableIterator<A> iteratorFromFunction(final Object f) {
  class IFF extends IterableIterator<A> {
    A a;
    boolean done;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = (A) callF(f);
      done = a == null;
    }
  };
  return new IFF();
}

// optimized version for F0 argument
static <A> IterableIterator<A> iteratorFromFunction(final F0<A> f) {
  return iteratorFromFunction_f0(f);
}
static void sleepSeconds(double s) {
  if (s > 0) sleep(round(s*1000));
}
static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}

static File javaxDataDir(String sub) {
  return newFile(javaxDataDir(), sub);
}
static <A, B> Set<A> keys(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

static Set keys(Object map) {
  return keys((Map) map);
}






static String substring(String s, int x) {
  return substring(s, x, l(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x >= s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.substring(x, y);
}


static long sysNow() {
  return System.nanoTime()/1000000;
}
public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}
static Object sleepQuietly_monitor = new Object();

static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(sleepQuietly_monitor) { sleepQuietly_monitor.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }
static void consoleIcon(String imageID) {
  frameIcon(consoleFrame(), or2(imageID, javaxDefaultIcon()));
}
static void setConsoleSize(int w, int h) {
  setFrameSize(consoleFrame(), w, h);
}
static void consoleFont(Font font) {
  callOpt(getConsoleTextArea_gen(), "setFont", font);
}
static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt((String) o);
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}
static <A> A or(A a, A b) {
  return a != null ? a : b;
}
  public static String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }
  
  public static String loadTextFile(File fileName, String defaultContents) {
    ping();
    try {
      if (fileName == null || !fileName.exists())
        return defaultContents;
  
      FileInputStream fileInputStream = new FileInputStream(fileName);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
      return loadTextFile(inputStreamReader);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
  
  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }
  
  public static String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer)))
        builder.append(buffer, 0, n);
        
    } finally {
      reader.close();
    }
    return builder.toString();
  }
static String tb_mainServer_default = "http://tinybrain.de:8080";
static Object tb_mainServer_override; // func -> S

static String tb_mainServer() {
  if (tb_mainServer_override != null) return (String) callF(tb_mainServer_override);
  return trim(loadTextFile(tb_mainServer_file(),
    tb_mainServer_default));
}

static File tb_mainServer_file() {
  return getProgramFile("#1001638", "mainserver.txt");
}

static boolean tb_mainServer_isDefault() {
  return eq(tb_mainServer(), tb_mainServer_default);
}
static Map<String, File> screenClipFiles() {
  Map<String,File> map = new HashMap();
  for (File f : filesEndingWith(screenClipsDir(), ".png"))
    map.put(toLower(dropSuffix(".png", f.getName())), f);
  return map;
}
static String getProgramName_cache;

static synchronized String getProgramName() {
  if (getProgramName_cache == null)
    getProgramName_cache = getSnippetTitleOpt(programID());
  return getProgramName_cache;
}
static void consoleInputFont(final Font f) {
  { swing(new Runnable() { public void run() { try { 
    JTextField input = consoleInputField();
    if (input != null) {
      input.setFont(f);
      revalidateFrame(input);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "JTextField input = consoleInputField();\r\n    if (input != null) {\r\n      inpu..."; }}); }
}
static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}

static int stdcompare(Number a, Number b) {
  return cmp(a, b);
}

static int stdcompare(String a, String b) {
  return cmp(a, b);
}

static int stdcompare(long a, long b) {
  return a < b ? -1 : a > b ? 1 : 0;
}

static int stdcompare(Object a, Object b) {
  return cmp(a, b);
}

static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(b);
}

static boolean startsWith(String a, char c) {
  return nempty(a) && a.charAt(0) == c;
}


  static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b)) return false;
    m.m = new String[] {substring(a, l(b))};
    return true;
  }


static boolean startsWith(List a, List b) {
  if (a == null || l(b) > l(a)) return false;
  for (int i = 0; i < l(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}




static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

static class CriticalAction {
  String description;
  
  CriticalAction() {}
  CriticalAction(String description) {
  this.description = description;}
  
  void done() {
    beginCriticalAction_inFlight.remove(this);
  }
}

static CriticalAction beginCriticalAction(String description) {
  ping();
  CriticalAction c = new CriticalAction(description);
  beginCriticalAction_inFlight.add(c);
  return c;
}

static void cleanMeUp_beginCriticalAction() {
  int n = 0;
  while (nempty(beginCriticalAction_inFlight)) {
    int m = l(beginCriticalAction_inFlight);
    if (m != n) {
      n = m;
      try {
        print("Waiting for " + n(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
      } catch (Throwable __e) { printStackTrace2(__e); }
    }
    sleepInCleanUp(10);
  }
}
static Map<JFrame, Boolean> makeFrame_myFrames = weakHashMap();
static String makeFrame_defaultIcon;

static JFrame makeFrame() {
  return makeFrame((Component) null);
}

static JFrame makeFrame(Object content) {
  return makeFrame(programTitle(), content);
}

static JFrame makeFrame(String title) {
  return makeFrame(title, null);
}

static JFrame makeFrame(String title, Object content) {
  return makeFrame(title, content, true);
}

static JFrame makeFrame(final String title, final Object content, final boolean showIt) {
  return swing(new F0<JFrame>() { JFrame get() { try { 
    if (getFrame(content) != null)
      return getFrame(setFrameTitle((Component) content, title));
    final JFrame frame = new JFrame(title);
    if (makeFrame_defaultIcon != null)
      setFrameIconLater(frame, makeFrame_defaultIcon);
    _initFrame(frame);
    JComponent wrapped = wrap(content);
    if (wrapped != null)
      frame.getContentPane().add(wrapped);
    frame.setBounds(defaultNewFrameBounds());
    if (showIt)
      frame.setVisible(true);
    //callOpt(content, "requestFocus");
    //exitOnFrameClose(frame);
    
    return frame;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "if (getFrame(content) != null)\r\n      ret getFrame(setFrameTitle((Component) ..."; }});
}
static boolean neqic(String a, String b) {
  return !eqic(a, b);
}
static JPanel infoMessage_makePanel(String text) {
  final JTextArea ta = wrappedTextArea(text);
  onClick(ta, new Runnable() { public void run() { try {  disposeWindow(ta) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "disposeWindow(ta)"; }});
  int size = 14;
  if (l(text) <= 50) size *= 2;
  else if (l(text) < 100) size = iround(size*1.5);
  ta.setFont(typeWriterFont(size));
  JScrollPane sp = jscroll(ta);
  return withMargin(sp);
}
static <A extends Window> A disposeWindowAfter(int delay, final A w) {
  if (w != null)
    swingLater(delay, new Runnable() { public void run() { try { 
      w.dispose();
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "w.dispose();"; }});
  return w;
}
static int countLines(String s) {
  return l(toLines(s)); // yeah could be optimized :-)
}
static String[] dropLast(String[] a, int n) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, 0, b, 0, b.length);
  return b;
}

static <A> List<A> dropLast(List<A> l) {
  return subList(l, 0, l(l)-1);
}

static <A> List<A> dropLast(int n, List<A> l) {
  return subList(l, 0, l(l)-n);
}

static <A> List<A> dropLast(Iterable<A> l) {
  return dropLast(asList(l));
}

static String dropLast(String s) {
  return substring(s, 0, l(s)-1);
}

static String dropLast(String s, int n) {
  return substring(s, 0, l(s)-n);
}

static String dropLast(int n, String s) {
  return dropLast(s, n);
}

static class wrapAsActivity_R implements Runnable {
  Object r;
  
  wrapAsActivity_R() {}
  wrapAsActivity_R(Object r) {
  this.r = r;}
  
  public void run() {
     AutoCloseable __238 = tempActivity(r); try {
    callF(r);
  } finally { _close(__238); }}
}

static wrapAsActivity_R wrapAsActivity(final Object r) {
  return r instanceof wrapAsActivity_R ? ((wrapAsActivity_R) r) : new wrapAsActivity_R(r);
}
static boolean isURL(String s) {
  return s.startsWith("http://") || s.startsWith("https://");
}
static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}
static Throwable printStackTrace(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

/*static void printStackTrace(S indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace(e));
}*/
static <A, B> List<B> valuesList(Map<A, B> map) {
  return cloneListSynchronizingOn(values(map), map);
}
static boolean endsWith(String a, String b) {
  return a != null && a.endsWith(b);
}

static boolean endsWith(String a, char c) {
  return nempty(a) && lastChar(a) == c;
}


  static boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b)) return false;
    m.m = new String[] {dropLast(l(b), a)};
    return true;
  }


static void showConsole() {
  showFrame(consoleFrame());
}
// TODO: returns empty first, but not empty last
static List<String> splitAt(String s, String splitter) {
  List<String> parts = new ArrayList();
  int i = 0;
  if (s != null)
    while (i < l(s)) {
      int j = indexOf(s, splitter, i);
      if (j < 0) j = l(s);
      parts.add(substring(s, i, j));
      i = j+l(splitter);
    }
  return parts;
}
// runnable = Runnable or String (method name)
static Thread newThread(Object runnable) {
  return new Thread(_topLevelErrorHandling(toRunnable(runnable)));
}

static Thread newThread(Object runnable, String name) {
  if (name == null) name = defaultThreadName();
  return new Thread(_topLevelErrorHandling(toRunnable(runnable)), name);
}

static Thread newThread(String name, Object runnable) {
  return newThread(runnable, name);
}
static <A> A liftLast(List<A> l) {
  if (l.isEmpty()) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}
static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> List<A> unnull(List<A> l) {
  return l == null ? emptyList() : l;
}

static <A, B> Map<A, B> unnull(Map<A, B> l) {
  return l == null ? emptyMap() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static <A> A[] unnull(A[] a) {
  return a == null ? (A[]) new Object[0] : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}


static Pt unnull(Pt p) {
  return p == null ? new Pt() : p;
}



static <A extends Component> A centerFrame(A c) {
  Window w = getWindow(c);
  if (w != null)
    w.setLocationRelativeTo(null); // magic trick
  return c;
}

static <A extends Component> A centerFrame(int w, int h, A c) {
  return centerFrame(setFrameSize(w, h, c));
}

static IterableIterator emptyIterableIterator_instance = new IterableIterator() {
  public Object next() { throw fail(); }
  public boolean hasNext() { return false; }
};

static <A> IterableIterator<A> emptyIterableIterator() {
  return emptyIterableIterator_instance; 
}
static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}

static int min(int[] c) {
  int x = Integer.MAX_VALUE;
  for (int d : c) if (d < x) x = d;
  return x;
}
// We dropped the "***" support here (use match3 for that)

static String[] find2(List<String> pat, List<String> tok) {
  for (int idx = 0; idx < tok.size(); idx += 2) {
    String[] result = find2(pat, tok, idx);
    if (result != null) return result;
  }
  return null;
}

static String[] find2(List<String> pat, List<String> tok, int idx) {
  if (idx+pat.size() > tok.size())
    return null;
  List<String> result = new ArrayList();
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(idx+i);
    if (eq(p, "*"))
      result.add(t);
    else if (!p.equalsIgnoreCase(t))
      return null;
  }
  return toStringArray(result);
}

static Class getMainClass() {
  return main.class;
}

static Class getMainClass(Object o) { try {
  return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
} catch (Exception __e) { throw rethrow(__e); } }
static String getSnippetTitleOpt(String s) {
  return isSnippetID(s) ? getSnippetTitle(s) : s;
}
static volatile boolean licensed_yes = true;

static boolean licensed() {
  ping();
  return licensed_yes;
}

static void licensed_off() {
  licensed_yes = false;
}
static String[] toStringArray(Collection<String> c) {
  String[] a = new String[l(c)];
  Iterator<String> it = c.iterator();
  for (int i = 0; i < l(a); i++)
    a[i] = it.next();
  return a;
}

static String[] toStringArray(Object o) {
  if (o instanceof String[])
    return (String[]) o;
  else if (o instanceof Collection)
    return toStringArray((Collection<String>) o);
  else
    throw fail("Not a collection or array: " + getClassName(o));
}

static Throwable getInnerException(Throwable e) {
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}
static Object swing(Object f) {
  return swingAndWait(f);
}

static <A> A swing(F0<A> f) {
  return (A) swingAndWait(f);
}
static int parseFirstInt(String s) {
  return parseInt(jextract("<int>", s));
}
static int gzInputStream_defaultBufferSize = 65536;

static GZIPInputStream gzInputStream(File f) { try {
  return gzInputStream(new FileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(File f, int bufferSize) { try {
  return new GZIPInputStream(new FileInputStream(f), bufferSize);
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(InputStream in) { try {
  return new GZIPInputStream(in, gzInputStream_defaultBufferSize);
} catch (Exception __e) { throw rethrow(__e); } }
static void renewConsoleFrame() {
  setConsoleFrame(renewFrame(consoleFrame()));
}
static Runnable toRunnable(final Object o) {
  if (o instanceof Runnable) return (Runnable) o;
  return new Runnable() { public void run() { try {  callF(o) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(o)"; }};
}
static boolean empty(Collection c) { return c == null || c.isEmpty(); }
static boolean empty(String s) { return s == null || s.length() == 0; }
static boolean empty(Map map) { return map == null || map.isEmpty(); }
static boolean empty(Object[] o) { return o == null || o.length == 0; }
static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  if (o instanceof byte[]) return empty((byte[]) o);
  if (o == null) return true;
  throw fail("unknown type for 'empty': " + getType(o));
}

static boolean empty(float[] a) { return a == null || a.length == 0; }
static boolean empty(int[] a) { return a == null || a.length == 0; }
static boolean empty(long[] a) { return a == null || a.length == 0; }
static boolean empty(byte[] a) { return a == null || a.length == 0; }


// supports the usual quotings (", variable length double brackets) except ' quoting
static boolean isQuoted(String s) {
  
  
  if (isNormalQuoted(s)) return true; // use the exact version
  
  return isMultilineQuoted(s);
}
static String structure_addTokenMarkers(String s) {
  List<String> tok = javaTok(s);
  
  // find references
  
  TreeSet<Integer> refs = new TreeSet();
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (t.startsWith("t") && isInteger(t.substring(1)))
      refs.add(parseInt(t.substring(1)));
  }
  
  if (empty(refs)) return s;
  
  // add markers
  for (int i : refs) {
    int idx = i*2+1;
    String t = "";
    if (endsWithLetterOrDigit(tok.get(idx-1))) t = " ";
    tok.set(idx, t + "m" + i + " " + tok.get(idx));
  }
  
  return join(tok);
}
static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}
static String snippetImageURL(String snippetID) {
  return snippetImageURL(snippetID, "png");
}

static String snippetImageURL(String snippetID, String contentType) {
  long id = parseSnippetID(snippetID);
  String url;
  if (id == 1000010 || id == 1000012)
    url = "http://tinybrain.de:8080/tb/show-blobimage.php?id=" + id;
  else if (isImageServerSnippet(id))
    url = imageServerLink(id);
  else
    //url = "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id + "&contentType=image/" + contentType;
    url = "https://www.botcompany.de:8443/img/" + id;
  return url;
}
static String prependIfNempty(String prefix, String s) {
  return empty(s) ? s : prefix + s;
}
static void updateLookAndFeelOnAllWindows_noRenew() {
  for (Window window : Window.getWindows())
    SwingUtilities.updateComponentTreeUI(window);
}
static <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
  class IFF2 extends IterableIterator<A> {
    A a;
    boolean done;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
  };
  return new IFF2();
}
static File infoBoxesLogFile() {
  return new File(javaxDataDir(), "Logs/infoBoxes.txt");
}
static List<Rect> horizontalAutoSplit2ThenAutoCrop(BWImage img) {
  List<Rect> l = new ArrayList();
  for (Rect r : horizontalAutoSplit2(img))
    l.add(translateRect(autoCropOfBWImage(img.clip(r)), r.x, r.y));
  return l;
}
static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}

static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  mkdirsForFile(path);
  FileOutputStream f = new // Line break for ancient translator
    FileOutputStream(path, append);
  
  callJavaX("registerIO", f, path, true);
  
  return f;
}
static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}
static void logQuotedWithDate(String s) {
  logQuotedWithTime(s);
}

static void logQuotedWithDate(String logFile, String s) {
  logQuotedWithTime(logFile, s);
}

static void logQuotedWithDate(File logFile, String s) {
  logQuotedWithTime(logFile, s);
}
static IterableIterator<String> linesFromReader(Reader r) {
  final BufferedReader br = bufferedReader(r);
  return iteratorFromFunction_f0(new F0<String>() { String get() { try { return  readLineFromReaderWithClose(br) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "readLineFromReaderWithClose(br)"; }});
}
static boolean isEmpty(Collection c) {
  return c == null || c.isEmpty();
}

static boolean isEmpty(CharSequence s) {
  return s == null || s.length() == 0;
}

static boolean isEmpty(Object[] a) { return a == null || a.length == 0; }
static boolean isEmpty(byte[] a) { return a == null || a.length == 0; }

static boolean isEmpty(Map map) {
  return map == null || map.isEmpty();
}
static String javaxDefaultIcon() {
  return "#1005557";
}
static JTextField consoleInputField() {
  Object console = get(getJavaX(), "console");
  return (JTextField) getOpt(console, "tfInput");
}
static int parseInt(String s) {
  return empty(s) ? 0 : Integer.parseInt(s);
}

static int parseInt(char c) {
  return Integer.parseInt(str(c));
}
static <A extends Component> A setFrameSize(A c, int w, int h) {
  JFrame f = getFrame(c);
  if (f != null)
    f.setSize(w, h);
  return c;
}

static <A extends Component> A setFrameSize(int w, int h, A c) {
  return setFrameSize(c, w, h);
}
static volatile Throwable lastException_lastException;

static Throwable lastException() {
  return lastException_lastException;
}

static void lastException(Throwable e) {
  lastException_lastException = e;
}
static String javaTok_substringC(String s, int i, int j) {
  return s.substring(i, j);
}
static String getComputerID_quick() {
  return computerID();
}
static File javaxCodeDir_dir; // can be set to work on different base dir

static File javaxCodeDir() {
  return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
}
public static String join(String glue, Iterable<String> strings) {
  if (strings == null) return "";
  StringBuilder buf = new StringBuilder();
  Iterator<String> i = strings.iterator();
  if (i.hasNext()) {
    buf.append(i.next());
    while (i.hasNext())
      buf.append(glue).append(i.next());
  }
  return buf.toString();
}

public static String join(String glue, String... strings) {
  return join(glue, Arrays.asList(strings));
}

static String join(Iterable<String> strings) {
  return join("", strings);
}

static String join(Iterable<String> strings, String glue) {
  return join(glue, strings);
}

public static String join(String[] strings) {
  return join("", strings);
}


static String join(String glue, Pair p) {
  return p == null ? "" : str(p.a) + glue + str(p.b);
}

static String getStackTrace2(Throwable throwable) {
  return hideCredentials(getStackTrace(throwable) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ",
    hideCredentials(str(getInnerException(throwable)))) + "\n");
}
static byte[] boolArrayToBytes(boolean[] a) {
  byte[] b = new byte[(l(a)+7)/8];
  for (int i = 0; i < l(a); i++)
    if (a[i])
      b[i/8] |= 1 << (i & 7);
  return b;
}
static boolean substanceLookAndFeelEnabled() {
  return startsWith(getLookAndFeel(), "org.pushingpixels.");
}
static String defaultThreadName_name;

static String defaultThreadName() {
  if (defaultThreadName_name == null)
    defaultThreadName_name = "A thread by " + programID();
  return defaultThreadName_name;
}
static boolean isJavaIdentifier(String s) {
  if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
    return false;
  for (int i = 1; i < s.length(); i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}
public static void copyFile(File src, File dest) { try {
  mkdirsForFile(dest);
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static String addSuffix(String s, String suffix) {
  return s.endsWith(suffix) ? s : s + suffix;
}
static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(String a, String b) {
  return a == null ? b == null ? 0 : -1 : a.compareTo(b);
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}
  static List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }
static File getCacheProgramDir() {
  return getCacheProgramDir(getProgramID());
}

static File getCacheProgramDir(String snippetID) {
  return new File(userHome(), "JavaX-Caches/" + formatSnippetIDOpt(snippetID));
}
  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }
static String _userHome;
static String userHome() {
  if (_userHome == null) {
    if (isAndroid())
      _userHome = "/storage/sdcard0/";
    else
      _userHome = System.getProperty("user.home");
    //System.out.println("userHome: " + _userHome);
  }
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}
static void assertTrue(Object o) {
  if (!(eq(o, true) /*|| isTrue(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static File screenClipsDir() {
  return newFile(javaxDataDir(), "Screen Clips");
}
static String baseClassName(String className) {
  return substring(className, className.lastIndexOf('.')+1);
}

static String baseClassName(Object o) {
  return baseClassName(getClassName(o));
}
static List<String> getClassNames(Collection l) {
  List<String> out = new ArrayList();
  if (l != null) for (Object o : l)
    out.add(o == null ? null : getClassName(o));
  return out;
}
static int iround(double d) {
  return (int) Math.round(d);
}
static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}

static boolean ewic(String a, String b, Matches m) {
  return endsWithIgnoreCase(a, b, m);
}
static BufferedReader utf8bufferedReader(InputStream in) { try {
  return new BufferedReader(new InputStreamReader(in, "UTF-8"));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader utf8bufferedReader(File f) { try {
  return utf8bufferedReader(newFileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }
static String toLower(String s) {
  return s == null ? null : s.toLowerCase();
}

static char toLower(char c) {
  return Character.toLowerCase(c);
}
static String hopeningTag(String tag, Object... params) {
  StringBuilder buf = new StringBuilder();
  buf.append("<" + tag);
  for (int i = 0; i < l(params); i += 2) {
    String name = (String) get(params, i);
    Object val = get(params, i+1);
    if (nempty(name) && val != null) {
      String s = str(val);
      if (!empty(s))
        buf.append(" " + name + "=" + htmlQuote(s));
    }
  }
  buf.append(">");
  return str(buf);
}
static File getProgramDir() {
  return programDir();
}

static File getProgramDir(String snippetID) {
  return programDir(snippetID);
}
static Object getConsoleTextArea_gen() {
  return getOpt(get(getJavaX(), "console"), "textArea");
}
static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}


static <A, B> B pcallF(F1<A, B> f, A a) { try {
  return f == null ? null : f.get(a);
} catch (Throwable __e) { return null; } }

static JWindow showWindow(Component c) {
  JWindow w = new JWindow();
  w.add(wrap(c));
  return w;
}
static String loadGZTextFile(File file) { try {
  if (!file.isFile()) return null;
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
  InputStream fis = new FileInputStream(file);
  GZIPInputStream gis = newGZIPInputStream(fis);
  try {
    byte[] buffer = new byte[1024];
    int len;
    while((len = gis.read(buffer)) != -1){
        baos.write(buffer, 0, len);
    }
  } finally {
    fis.close();
  }
  baos.close();
  return fromUtf8(baos.toByteArray()); // TODO: use a Reader
} catch (Exception __e) { throw rethrow(__e); } }
static Object nuObject(String className, Object... args) { try {
  return nuObject(classForName(className), args);
} catch (Exception __e) { throw rethrow(__e); } }

// too ambiguous - maybe need to fix some callers
/*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/

static <A> A nuObject(Class<A> c, Object... args) { try {
  if (args.length == 0) return nuObjectWithoutArguments(c); // cached!
  
  Constructor m = nuObject_findConstructor(c, args);
  m.setAccessible(true);
  return (A) m.newInstance(args);
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObject_findConstructor(Class c, Object... args) {
  for (Constructor m : c.getDeclaredConstructors()) {
    if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
      continue;
    return m;
  }
  throw fail("Constructor " + c.getName() + getClasses(args) + " not found"
    + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
}

 static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }
static Object callOpt(Object o) {
  if (o == null) return null;
  return callF(o);
}

static Object callOpt(Object o, String method, Object... args) {
  try {
    if (o == null) return null;
    if (o instanceof Class) {
      Method m = callOpt_findStaticMethod((Class) o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return invokeMethod(m, null, args);
    } else {
      Method m = callOpt_findMethod(o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return invokeMethod(m, o, args);
    }
  } catch (Exception e) {
    //fail(e.getMessage() + " | Method: " + method + ", receiver: " + className(o) + ", args: (" + join(", ", map(f className, args) + ")");
    throw rethrow(e);
  }
}

static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

private static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}


static void assertFalse(Object o) {
  if (!(eq(o, false) /*|| isFalse(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}

//static final Map<Class, HashMap<S, Field>> getOpt_cache = newDangerousWeakHashMap(f getOpt_special_init);

static class getOpt_Map extends WeakHashMap {
  getOpt_Map() {
    if (getOpt_special == null) getOpt_special = new HashMap();
    clear();
  }
  
  public void clear() {
    super.clear();
    //print("getOpt clear");
    put(Class.class, getOpt_special);
    put(String.class, getOpt_special);
  }
}

static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));
//static final Map<Class, HashMap<S, Field>> getOpt_cache = _registerWeakMap(synchroMap(new getOpt_Map));
static HashMap getOpt_special; // just a marker

/*static void getOpt_special_init(Map map) {
  map.put(Class.class, getOpt_special);
  map.put(S.class, getOpt_special);
}*/

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
    if (o instanceof DynamicObject)
      return ((DynamicObject) o).fieldValues.get(field);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) {
        f.setAccessible(true);
        String name = f.getName();
        if (!map.containsKey(name))
          map.put(name, f);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
  }
  getOpt_cache.put(c, map);
  return map;
}
static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}


static String hmsWithColons() {
  return hmsWithColons(now());
}

static String hmsWithColons(long time) {
  return new SimpleDateFormat("HH:mm:ss").format(time);
}

static File[] listFiles(File dir) {
  File[] files = dir.listFiles();
  return files == null ? new File[0] : files;
}

static File[] listFiles(String dir) {
  return listFiles(new File(dir));
}
static String dropSuffix(String suffix, String s) {
  return s.endsWith(suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static void revalidateFrame(Component c) {
  revalidate(getFrame(c));
}
static String rgbMD5(RGBImage img) {
  return md5OfRGBImage(img);
}
static long round(double d) {
  return Math.round(d);
}
static List<File> filesEndingWith(File dir, String suffix) {
  return listFilesWithSuffix(dir, suffix);
}
static int moveToTopRightCorner_inset = 20;

static <A extends Component> A moveToTopRightCorner(A a) {
  return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
}

static <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
  Window w = getWindow(a);
  if (w != null)
    w.setLocation(getScreenSize().width-w.getWidth()-insetX, insetY);
  return a;
}

static JFrame frameIcon(Component c, String imageID) {
  return setFrameIconLater(c, imageID);
}

static JFrame frameIcon(String imageID, Component c) {
  return setFrameIconLater(c, imageID);
}


static float horizontalAutoSplit2_threshold = 0.5f;

static List<Rect> horizontalAutoSplit2(BWImage img) {
  return horizontalAutoSplit2(img, horizontalAutoSplit2_threshold);
}

static List<Rect> horizontalAutoSplit2(BWImage img, float threshold) {
  int w = img.getWidth(), h = img.getHeight();
  float[] f = bwImageColumnMinBrightness(img);
  
  List<Rect> l = new ArrayList();
  int j = -1;
  for (int i = 0; i < l(f); i++)
    if (f[i] < threshold) { // start / continue streak
      if (j < 0) j = i; 
    } else {
      if (j >= 0) { // end streak
        l.add(new Rect(j, 0, i-j, h));
        j = -1;
      }
    }
  if (j >= 0)
    l.add(new Rect(j, 0, w-j, h));
  return l;
}
static JTextArea wrappedTextArea(JTextArea ta) {
  ta.setLineWrap(true);
  ta.setWrapStyleWord(true);
  return ta;
}

static JTextArea wrappedTextArea() {
  return wrappedTextArea(jtextarea());
}

static JTextArea wrappedTextArea(String text) {
  JTextArea ta = wrappedTextArea();
  ta.setText(text);
  return ta;
}
static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}
static <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
  if (l == null) return new ArrayList();
  synchronized(mutex) {
    return new ArrayList<A>(l);
  }
}
static String getType(Object o) {
  return getClassName(o);
}
// TODO: extended multi-line strings

static int javaTok_n, javaTok_elements;
static boolean javaTok_opt;

static List<String> javaTok(String s) {
  ++javaTok_n;
  ArrayList<String> tok = new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    // Special JavaX syntax: 'identifier
    if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
      j += 2;
      while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
        ++j;
    } else if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static List<String> javaTok(List<String> tok) {
  return javaTokWithExisting(join(tok), tok);
}
static boolean isImageServerSnippet(long id) {
  return id >= 1100000 && id < 1200000;
}
static String n(long l, String name) {
  return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
}

static String n(Collection l, String name) {
  return n(l(l), name);
}

static String n(Map m, String name) {
  return n(l(m), name);
}

static String n(Object[] a, String name) {
  return n(l(a), name);
}


static Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

static Object nuObjectWithoutArguments(String className) { try {
  return nuObjectWithoutArguments(classForName(className));
} catch (Exception __e) { throw rethrow(__e); } }

static <A> A nuObjectWithoutArguments(Class<A> c) { try {
  Constructor m;
  m = nuObjectWithoutArguments_cache.get(c);
  if (m == null)
    nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
  return (A) m.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObjectWithoutArguments_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (empty(m.getParameterTypes())) {
      m.setAccessible(true);
      return m;
    }
  throw fail("No default constructor found in " + c.getName());
}

static String readLineFromReaderWithClose(BufferedReader r) { try {
  String s = r.readLine();
  if (s == null) r.close();
  return s;
} catch (Exception __e) { throw rethrow(__e); } }
// c = JComponent or something implementing swing()
static JComponent wrap(Object swingable) {
  if (swingable == null) return null;
  JComponent c = (JComponent) ( swingable instanceof JComponent ? swingable : callOpt(swingable, "swing"));
  if (c instanceof JTable || c instanceof JList
    || c instanceof JTextArea || c instanceof JEditorPane
    || c instanceof JTextPane || c instanceof JTree)
    return jscroll(c);
  return c;
}

static String getStackTrace(Throwable throwable) {
  lastException(throwable);
  return getStackTrace_noRecord(throwable);
}

static String getStackTrace_noRecord(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return hideCredentials(writer.toString());
}

static String getStackTrace() {
  return getStackTrace_noRecord(new Throwable());
}
static int withMargin_defaultWidth = 6;

static JPanel withMargin(Component c) {
  return withMargin(withMargin_defaultWidth, c);
}

static JPanel withMargin(int w, Component c) {
  return withMargin(w, w, c);
}

static JPanel withMargin(final int w, final int h, final Component c) {  return swing(new F0<JPanel>() { JPanel get() { try { 
    JPanel p = new JPanel(new BorderLayout());
    p.setBorder(BorderFactory.createEmptyBorder(h, w, h, w));
    p.add(c);
    return p;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JPanel p = new JPanel(new BorderLayout);\r\n    p.setBorder(BorderFactory.creat..."; }});
}
// This is made for NL parsing.
// It's javaTok extended with "..." token, "$n" and "#n" and
// special quotes (which are converted to normal ones).

static List<String> javaTokPlusPeriod(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    cc = s.substring(i, Math.min(i+2, l));

    // scan for non-whitespace
    if (c == '\u201C' || c == '\u201D') c = '"'; // normalize quotes
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        char _c = s.charAt(j);
        if (_c == '\u201C' || _c == '\u201D') _c = '"'; // normalize quotes
        if (_c == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
      if (j-1 >= i+1) {
        tok.add(opener + s.substring(i+1, j-1) + opener);
        i = j;
        continue;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for things like "this one's"
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else if (cc.equals("[[")) {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (cc.equals("[=") && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else if (s.substring(j, Math.min(j+3, l)).equals("..."))
      j += 3;
    else if (c == '$' || c == '#')
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}

static JFrame setFrameIconLater(Component c, final String imageID) {
  final JFrame frame = getFrame(c);
  if (frame != null)
    { Thread _t_0 = new Thread("Loading Icon") {
public void run() { try {
  
      final Image i = imageIcon(or2(imageID, "#1005557")).getImage();
      swingLater(new Runnable() { public void run() { try { 
        frame.setIconImage(i);
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "frame.setIconImage(i);"; }});
    } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_0); }
  return frame;
}
static Window getWindow(Object o) {
  if (!(o instanceof Component)) return null;
  Component c = (Component) o;
  while (c != null) {
    if (c instanceof Window) return (Window) c;
    c = c.getParent();
  }
  return null;
}
static String md5OfRGBImage(RGBImage img) { try {
  MessageDigest m = MessageDigest.getInstance("MD5");
  m.update(intToBytes(img.getWidth()));
  int[] pixels = img.getPixels();
  for (int i = 0; i < l(pixels); i++)
    m.update(intToBytes(pixels[i]));
  return bytesToHex(m.digest());
} catch (Exception __e) { throw rethrow(__e); } }
static Runnable _topLevelErrorHandling(final Runnable runnable) {
  return new Runnable() { public void run() { try {  try { runnable.run(); } catch (Throwable __e) { printStackTrace2(__e); } 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "pcall { runnable.run(); }"; }};
}
static BufferedReader bufferedReader(Reader r) {
  return r instanceof BufferedReader ? (BufferedReader) r : new BufferedReader(r);
}
static void swingLater(long delay, final Object r) {
  javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
  timer.setRepeats(false);
  timer.start();
}

static void swingLater(Object r) {
  SwingUtilities.invokeLater(toRunnable(r));
}

static List<File> listFilesWithSuffix(File dir, String suffix) {
  List<File> l = new ArrayList();
  for (File f : listFiles(dir))
    if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
  return l;
}
static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}
static boolean endsWithIgnoreCase(String a, String b) {
  int la = l(a), lb = l(b);
  return la >= lb && regionMatchesIC(a, la-lb, b, 0, lb);
}

static boolean endsWithIgnoreCase(String a, String b, Matches m) {
  if (!endsWithIgnoreCase(a, b)) return false;
  m.m = new String[] { substring(a, 0, l(a)-l(b)) };
  return true;
}
static String htmlQuote(String s) {
  return "\"" + htmlencode_forParams(s) + "\"";
}
static <A> A setFrameTitle(A c, String title) {
  Frame f = getAWTFrame(c);
  if (f == null)
    showFrame(title, c);
  else
    f.setTitle(title);
  return c;
}

static <A extends Component> A setFrameTitle(String title, A c) {
  return setFrameTitle(c, title);
}

// magically find a field called "frame" in main class :-)
static JFrame setFrameTitle(String title) {
  Object f = getOpt(mc(), "frame");
  if (f instanceof JFrame)
    return setFrameTitle((JFrame) f, title);
  return null;
}
static void setConsoleFrame(JFrame frame) {
   setOpt(get(getJavaX(), "console"), "frame", frame);
}
static JFrame showFrame() {
  return makeFrame();
}

static JFrame showFrame(Object content) {
  return makeFrame(content);
}

static JFrame showFrame(String title) {
  return makeFrame(title);
}

static JFrame showFrame(String title, Object content) {
  return makeFrame(title, content);
}

static JFrame showFrame(final JFrame f) {
  if (f != null) { swing(new Runnable() { public void run() { try { 
    if (frameTooSmall(f)) frameStandardSize(f);
    f.setVisible(true);
    if (f.getState() == Frame.ICONIFIED) f.setState(Frame.NORMAL);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (frameTooSmall(f)) frameStandardSize(f);\r\n    f.setVisible(true);\r\n    if ..."; }}); }
  return f;
}

// make or update frame
static JFrame showFrame(String title, Object content, JFrame frame) {
  if (frame == null)
    return showFrame(title, content);
  else {
    frame.setTitle(title);
    setFrameContents(frame, content);
    return frame;
  }
}
static long parseLong(String s) {
  if (s == null) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}
static boolean endsWithLetterOrDigit(String s) {
  return nempty(s) && isLetterOrDigit(lastCharacter(s));
}
static String getSnippetTitle(String id) { try {
  if (id == null) return null;
  if (!isSnippetID(id)) return "?";
  long parsedID = parseSnippetID(id);
  String url;
  if (isImageServerSnippet(parsedID))
    url = "http://ai1.space/images/raw/title/" + parsedID;
  else
    url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials();
  return trim(loadPageSilently(url));
} catch (Exception __e) { throw rethrow(__e); } }

static String getSnippetTitle(long id) {
  return getSnippetTitle(fsI(id));
}

static void onClick(JComponent c, final Object runnable) {
  c.addMouseListener(new MouseAdapter() {
    public void mouseClicked(MouseEvent e) {
      callF(runnable, e);
    }
  });
}

// re-interpreted for buttons
static void onClick(JButton btn, final Object runnable) {
  onEnter(btn, runnable);
}
static String getLookAndFeel() {
  return getClassName(UIManager.getLookAndFeel());
}
// returns from C to C
static String jextract(String pat, String s) {
  return jextract(pat, javaTok(s));
}

static String jextract(String pat, List<String> tok) {
  List<String> tokpat = javaTok(pat);
  jfind_preprocess(tokpat);
  int i = jfind(tok, tokpat);
  if (i < 0) return null;
  int j = i + l(tokpat) - 2;
  return join(subList(tok, i, j));
}

static List collect(Collection c, String field) {
  return collectField(c, field);
}

static List collect(String field, Collection c) {
  return collectField(c, field);
}


static List<String> dropPunctuation_keep = litlist("*", "<", ">");

static List<String> dropPunctuation(List<String> tok) {
  tok = new ArrayList<String>(tok);
  for (int i = 1; i < tok.size(); i += 2) {
    String t = tok.get(i);
    if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
      tok.set(i-1, tok.get(i-1) + tok.get(i+1));
      tok.remove(i);
      tok.remove(i);
      i -= 2;
    }
  }
  return tok;
}

static String dropPunctuation(String s) {
  return join(dropPunctuation(nlTok(s)));
}
// can probably be merged with next variant
static void disposeWindow(final Window window) {
  if (window != null) { swing(new Runnable() { public void run() { try { 
    window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); // call listeners
    window.dispose();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); //..."; }}); }
}

static void disposeWindow(final Component c) {
  disposeWindow(getWindow(c));
}

static void disposeWindow(Object o) {
  if (o != null) disposeWindow((Component) o);
}
static void logQuotedWithTime(String s) {
  logQuotedWithTime(standardLogFile(), s);
}

static void logQuotedWithTime(File logFile, String s) {
  logQuoted(logFile, logQuotedWithTime_format(s));
}

static void logQuotedWithTime(String logFile, String s) {
  logQuoted(logFile, logQuotedWithTime_format(s));
}

static String logQuotedWithTime_format(String s) {
  return formatGMTWithDate_24(now()) + " " + s;
}
static class _Activity {
  long started;
  Object r;
  Thread thread;
}

static Set<_Activity> tempActivity_list = synchroHashSet();
static boolean tempActivity_debug;

static <A> AutoCloseable tempActivity(final Object r) {
  if (tempActivity_debug) print("Activity started: " + r);
  final _Activity a = new _Activity();
  a.started = sysNow();
  a.r = r;
  a.thread = currentThread();
  tempActivity_list.add(a);
  return new AutoCloseable() {
    public void close() {
      tempActivity_list.remove(a);
      if (tempActivity_debug) {
        int n = l(tempActivity_list);
        print("Activity ended: " + r
          + (n == 0 ? "" : " - " + n + " remaining"));
      }
    }
  };
}
static float autoCropOfBWImage_threshold = 0.9f;

static Rect autoCropOfBWImage(BWImage img) {
  return autoCropOfBWImage(img, new Rect(0, 0, img.getWidth(), img.getHeight()));
}

static Rect autoCropOfBWImage(BWImage img, Rect r) {
  return autoCropOfBWImage(img, r, autoCropOfBWImage_threshold);
}

// r = initial rectangle
static Rect autoCropOfBWImage(BWImage img, Rect r, float threshold) {
  int x1 = r.x, y1 = r.y, x2 = r.x2(), y2 = r.y2();

  // left side

  end1:
  while (x1 < x2) {
    for (int y = y1; y < y2; y++)
      if (img.getPixel(x1, y) <= threshold)
        break end1;
    x1++;
  }

  // top side

  end2:
  while (y1 < y2) {
    for (int x = x1; x < x2; x++)
      if (img.getPixel(x, y1) <= threshold)
        break end2;
    y1++;
  }

  // right side

  end3:
  while (x2 > x1) {
    for (int y = y1; y < y2; y++)
      if (img.getPixel(x2-1, y) <= threshold)
        break end3;
    x2--;
  }

  // bottom side

  end4:
  while (y2 > y1) {
    for (int x = x1; x < x2; x++)
      if (img.getPixel(x, y2-1) <= threshold)
        break end4;
    y2--;
  }

  if (x2 <= x1 || y2 <= y1)
    return r;
  else
    return new Rect(x1, y1, x2 - x1, y2 - y1);
}

static void _initFrame(JFrame f) {
  makeFrame_myFrames.put(f, Boolean.TRUE);
  standardTitlePopupMenu(f);
}
static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  startIndex = max(0, min(l(l), startIndex));
  endIndex = max(0, min(l(l), endIndex));
  if (startIndex > endIndex) return litlist();
  return l.subList(startIndex, endIndex);
}


static Rectangle defaultNewFrameBounds_r = new Rectangle(300, 100, 500, 400);

static Rectangle defaultNewFrameBounds() {
  return swing(new F0<Rectangle>() { Rectangle get() { try { 
    defaultNewFrameBounds_r.translate(60, 20);
    if (!screenRectangle().contains(defaultNewFrameBounds_r))
      defaultNewFrameBounds_r.setLocation(30+random(30), 20+random(20));
    return new Rectangle(defaultNewFrameBounds_r);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "defaultNewFrameBounds_r.translate(60, 20);\r\n    if (!screenRectangle().contai..."; }});
}
static JFrame renewFrame(final JFrame frame) {
  if (frame == null) return null;
  return (JFrame) swing(new F0<Object>() { Object get() { try { 
    Container content = frame.getContentPane();
    JFrame frame2 = makeFrame(frame.getTitle());
    frame2.setBounds(frame.getBounds());
    try { frame2.setIconImages(frame.getIconImages()); } catch (Throwable __e) { printStackTrace2(__e); }
    frame2.setDefaultCloseOperation(frame.getDefaultCloseOperation());
    for (WindowListener wl : frame.getWindowListeners())
      frame2.addWindowListener(wl);
    frame.setContentPane(new JPanel());
    frame2.setContentPane(content);
    frame2.setVisible(true);
    frame.dispose();
    return frame2;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Container content = frame.getContentPane();\r\n    JFrame frame2 = makeFrame(fr..."; }});
}
static JScrollPane jscroll(final Component c) {
  return swing(new F0<JScrollPane>() { JScrollPane get() { try { return  new JScrollPane(c) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "new JScrollPane(c)"; }});
}
static String _computerID;
public static String computerID() { try {
  if (_computerID == null) {
    File file = new File(userHome(), ".tinybrain/computer-id");
    _computerID = loadTextFile(file.getPath(), null);
    if (_computerID == null) {
      _computerID = makeRandomID(12);
      saveTextFile(file.getPath(), _computerID);
    }
  }
  return _computerID;
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isInteger(String s) {
  if (s == null) return false;
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  if (s.charAt(0) == '-')
    if (++i >= n) return false;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static File programDir_mine; // set this to relocate program's data

static File programDir() {
  return programDir(getProgramID());
}

static File programDir(String snippetID) {
  boolean me = sameSnippetID(snippetID, programID());
  if (programDir_mine != null && me)
    return programDir_mine;
  File dir = new File(javaxDataDir(), formatSnippetID(snippetID));
  if (me) {
    String c = caseID();
    if (nempty(c)) dir = newFile(dir, c);
  }
  return dir;
}

static File programDir(String snippetID, String subPath) {
  return new File(programDir(snippetID), subPath);
}
static void revalidate(final Component c) {
  if (c == null || !c.isShowing()) return;
  { swing(new Runnable() { public void run() { try { 
    // magic combo to actually relayout and repaint
    c.revalidate();
    c.repaint();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "// magic combo to actually relayout and repaint\r\n    c.revalidate();\r\n    c.r..."; }}); }
}
static Object callJavaX(String method, Object... args) {
  return callOpt(getJavaX(), method, args);
}
static boolean eqic(String a, String b) {
  
  
    if ((a == null) != (b == null)) return false;
    if (a == null) return true;
    return a.equalsIgnoreCase(b);
  
}



static boolean eqic(char a, char b) {
  if (a == b) return true;
  
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2) return true;
  
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}
static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static Rect translateRect(int x, int y, Rect r) {
  return translateRect(r, x, y);
}

static Rect translateRect(Rect r, int x, int y) {
  return r == null ? null : new Rect(r.x+x, r.y+y, r.w, r.h);
}
static FileInputStream newFileInputStream(File path) throws IOException {
  return newFileInputStream(path.getPath());
}

static FileInputStream newFileInputStream(String path) throws IOException {
  FileInputStream f = new // Line break for ancient translator
    FileInputStream(path);
  //callJavaX("registerIO", f, path, true);
  return f;
}
static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}
static String imageServerLink(String md5OrID) {
  if (possibleMD5(md5OrID))
    return "http://images.botcompany.de/images/md5/" + md5OrID;
  return imageServerLink(parseSnippetID(md5OrID));
}

static String imageServerLink(long id) {
  return "http://images.botcompany.de/images/" + id;
}
static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}
static List<Pair> _registerDangerousWeakMap_preList;

static <A> A _registerDangerousWeakMap(A map) {
  return _registerDangerousWeakMap(map, null);
}

static <A> A _registerDangerousWeakMap(A map, Object init) {
  callF(init, map);
  
  if (init instanceof String) {
    final String f = (String) ( init);
    init = new VF1<Map>() { void get(Map map) { try {  callMC(f, map) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callMC(f, map)"; }};
  }
    
  if (javax() == null) {
    // We're in class init
    if (_registerDangerousWeakMap_preList == null) _registerDangerousWeakMap_preList = synchroList();
    _registerDangerousWeakMap_preList.add(pair(map, init));
    return map;
  }
  
  try {
    call(javax(), "_registerDangerousWeakMap", map, init);
  } catch (Throwable e) { printException(e);
    upgradeJavaXAndRestart();
  }
  return map;
}

static void _onLoad_registerDangerousWeakMap() {
  assertNotNull(javax());
  if (_registerDangerousWeakMap_preList == null) return;
  for (Pair p : _registerDangerousWeakMap_preList)
    _registerDangerousWeakMap(p.a, p.b);
  _registerDangerousWeakMap_preList = null;
}
static void _close(AutoCloseable c) {
  close(c);
}
static boolean isNormalQuoted(String s) {
  int l = l(s);
  if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"')) return false;
  int j = 1;
  while (j < l)
    if (s.charAt(j) == '"')
      return j == l-1;
    else if (s.charAt(j) == '\\' && j+1 < l)
      j += 2;
    else
      ++j;
  return false;
}
static boolean isMultilineQuoted(String s) {
  if (!startsWith(s, "[")) return false;
  int i = 1;
  while (i < s.length() && s.charAt(i) == '=') ++i;
  return i < s.length() && s.charAt(i) == '[';
}
static Map emptyMap() {
  return new HashMap();
}
static List<Class> getClasses(Object[] array) {
  List<Class> l = new ArrayList();
  for (Object o : array) l.add(_getClass(o));
  return l;
}
static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { printStackTrace2(__e); }
  return null;
}
static String emptySymbol_value;

static String emptySymbol() {
  if (emptySymbol_value == null) emptySymbol_value = symbol("");
  return emptySymbol_value;
}
static JFrame getFrame(final Object _o) {
  return swing(new F0<JFrame>() { JFrame get() { try { 
    Object o = _o;
    if (o instanceof ButtonGroup) o = first(buttonsInGroup((ButtonGroup) o));
    if (!(o instanceof Component)) return null;
    Component c = (Component) o;
    while (c != null) {
      if (c instanceof JFrame) return (JFrame) c;
      c = c.getParent();
    }
    return null;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "O o = _o;\r\n    if (o instanceof ButtonGroup) o = first(buttonsInGroup((Button..."; }});
}
static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}




static Dimension getScreenSize() {
  return Toolkit.getDefaultToolkit().getScreenSize();
}
static void clear(Collection c) {
  if (c != null) c.clear();
}
static String fromUtf8(byte[] bytes) { try {
  return new String(bytes, "UTF-8");
} catch (Exception __e) { throw rethrow(__e); } }
static Map<String, Class> classForName_cache = synchroHashMap();

static Class classForName(String name) { try {
  Class c = classForName_cache.get(name);
  if (c == null)
    classForName_cache.put(name, c = Class.forName(name));
  return c;
} catch (Exception __e) { throw rethrow(__e); } }
static <A, B> Map<A, B> weakHashMap() {
  return newWeakHashMap();
}
static char lastChar(String s) {
  return empty(s) ? '\0' : s.charAt(l(s)-1);
}
static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}


static List<String> getPlural_specials = ll("sheep", "fish");

static String getPlural(String s) {
  if (containsIgnoreCase(getPlural_specials, s)) return s;
  if (ewic(s, "y")) return dropSuffixIgnoreCase("y", s) + "ies";
  if (ewic(s, "ss")) return s + "es";
  if (ewic(s, "s")) return s;
  return s + "s";
}
static List<AbstractButton> buttonsInGroup(ButtonGroup g) {
  if (g == null) return ll();
  return asList(g.getElements());
}
static ActionListener actionListener(final Object runnable) {
  return actionListener(runnable, null);
}

static ActionListener actionListener(final Object runnable, final Object instanceToHold) {
  if (runnable instanceof ActionListener) return (ActionListener) runnable;
  return new java.awt.event.ActionListener() { public void actionPerformed(java.awt.event.ActionEvent _evt) { try {
     AutoCloseable __290 = holdInstance(instanceToHold); try {
    callF(runnable);
  } finally { _close(__290); }} catch (Throwable __e) { messageBox(__e); }}};
}
static void close(AutoCloseable c) { try {
  if (c != null) c.close();
} catch (Exception __e) { throw rethrow(__e); } }
static <A, B> Map<A, B> newDangerousWeakHashMap() {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
}

// initFunction: voidfunc(Map) - is called initially, and after clearing the map
static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
}
static Class<?> _getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null; // could optimize this
  }
}

static Class _getClass(Object o) {
  return o == null ? null
    : o instanceof Class ? (Class) o : o.getClass();
}

static Class _getClass(Object realm, String name) { try {
  return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
} catch (Exception __e) { throw rethrow(__e); } }
static List<String> javaTokWithExisting(String s, List<String> existing) {
  ++javaTok_n;
  int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
  ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    // Special JavaX syntax: 'identifier
    if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
      j += 2;
      while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
        ++j;
    } else if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
  return t.length() == j-i
    && s.regionMatches(i, t, 0, j-i); // << could be left out, but that's brave
}
static void logQuoted(String logFile, String line) {
  logQuoted(getProgramFile(logFile), line);
}

static void logQuoted(File logFile, String line) {
  appendToFile(logFile, quote(line) + "\n");
}
static Random random_random = new Random();

static int random(int n) {
  return n <= 0 ? 0 : random_random.nextInt(n);
}

static double random(double max) {
  return random()*max;
}

static double random() {
  return random_random.nextInt(100001)/100000.0;
}

static double random(double min, double max) {
  return min+random()*(max-min);
}

// min <= value < max
static int random(int min, int max) {
  return min+random(max-min);
}

static <A> A random(List<A> l) {
  return oneOf(l);
}

static <A> A random(Collection<A> c) {
  if (c instanceof List) return random((List<A>) c);
  int i = random(l(c));
  return collectionGet(c, i);
}
static void frameStandardSize(JFrame frame) {
  frame.setBounds(300, 100, 500, 400);
}
static List<String> nlTok(String s) {
  return javaTokPlusPeriod(s);
}
static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    
    // It's probably a subclass of Map. Use raw method
    setOpt_raw(o, field, value);
    return;
  }
  
  Field f = map.get(field);
  if (f != null)
    smartSet(f, o, value); // possible improvement: skip setAccessible
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        f.setAccessible(true);
        return f;
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static String asString(Object o) {
  return o == null ? null : o.toString();
}
static String fsI(String id) {
  return formatSnippetID(id);
}

static String fsI(long id) {
  return formatSnippetID(id);
}
static JTextArea jtextarea() {
  return jTextArea();
}

static JTextArea jtextarea(String text) {
  return jTextArea(text);
}
static int jfind(String s, String in) {
  return jfind(javaTok(s), in);
}

static int jfind(List<String> tok, String in) {
  return jfind(tok, 1, in);
}

static int jfind(List<String> tok, int startIdx, String in) {
  return jfind(tok, startIdx, in, null);
}

static int jfind(List<String> tok, String in, Object condition) {
  return jfind(tok, 1, in, condition);
}

static int jfind(List<String> tok, int startIdx, String in, Object condition) {
  List<String> tokin = javaTok(in);
  jfind_preprocess(tokin);
  return jfind(tok, startIdx, tokin, condition);
}

// assumes you preprocessed tokin
static int jfind(List<String> tok, List<String> tokin) {
  return jfind(tok, 1, tokin);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin) {
  return jfind(tok, startIdx, tokin, null);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
  return findCodeTokens(tok, startIdx, false, toStringArray(codeTokensOnly(tokin)), condition);
}

static List<String> jfind_preprocess(List<String> tok) {
  for (String type : litlist("quoted", "id", "int"))
    replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
  replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
  return tok;
}
static <A> ArrayList<A> litlist(A... a) {
  ArrayList l = new ArrayList(a.length);
  for (A x : a) l.add(x);
  return l;
}
static int max(int a, int b) { return Math.max(a, b); }
static int max(int a, int b, int c) { return max(max(a, b), c); }
static long max(int a, long b) { return Math.max((long) a, b); }
static long max(long a, long b) { return Math.max(a, b); }
static double max(int a, double b) { return Math.max((double) a, b); }
static float max(float a, float b) { return Math.max(a, b); }
static double max(double a, double b) { return Math.max(a, b); }

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}

static int max(int[] c) {
  int x = Integer.MIN_VALUE;
  for (int d : c) if (d > x) x = d;
  return x;
}
static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
  
  
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  
}
static byte[] intToBytes(int i) {
  return new byte[] {
          (byte) (i >>> 24),
          (byte) (i >>> 16),
          (byte) (i >>> 8),
          (byte) i};
}
static boolean isLetterOrDigit(char c) {
  return Character.isLetterOrDigit(c);
}
static <A> Set<A> synchroHashSet() {
  return Collections.synchronizedSet(new HashSet<A>());
}

static void setFrameContents(final Component c, final Object contents) {
  { swing(new Runnable() { public void run() { try { 
    JFrame frame = getFrame(c);
    frame.getContentPane().removeAll();
    frame.getContentPane().setLayout(new BorderLayout());
    frame.getContentPane().add(wrap(contents));
    revalidate(frame);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "JFrame frame = getFrame(c);\r\n    frame.getContentPane().removeAll();\r\n    fra..."; }}); }
}
static String standardCredentials() {
  String user = standardCredentialsUser();
  String pass = standardCredentialsPass();
  if (nempty(user) && nempty(pass))
    return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
  return "";
}
static volatile String caseID_caseID;

static String caseID() { return caseID_caseID; }

static void caseID(String id) {
  caseID_caseID = id;
}
static Map<String, String> singular_specials = litmap(
  "children", "child", "images", "image", "chess", "chess");
  
static Set<String> singular_specials2 = litset("time", "machine", "line");

static String singular(String s) {
  if (s == null) return null;
  { String _a_1190 = singular_specials.get(s); if (!empty(_a_1190)) return _a_1190; }
  { String _a_1191 = hippoSingulars().get(lower(s)); if (!empty(_a_1191)) return _a_1191; }
  if (singular_specials2.contains(dropSuffix("s", lastWord(s))))
    return dropSuffix("s", s);
  if (s.endsWith("ness")) return s;
  if (s.endsWith("ges")) return dropSuffix("s", s);
  if (endsWith(s, "bases")) return dropLast(s);
  s = dropSuffix("es", s);
  s = dropSuffix("s", s);
  return s;
}
static File standardLogFile() {
  return getProgramFile("log");
}
static List collectField(Collection c, String field) {
  List l = new ArrayList();
  for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}

static List collectField(String field, Collection c) {
  return collectField(c, field);
}
static boolean frameTooSmall(JFrame frame) {
  return frame.getWidth() < 100 || frame.getHeight() < 50;
}


static String symbol(String s) {
  
  return s;
  
  
}

static String symbol(CharSequence s) {
  if (s == null) return null;
  
  return str(s);
  
  
}

static String symbol(Object o) {
  return symbol((CharSequence) o);
}
static void standardTitlePopupMenu(final JFrame frame) {
  // standard right-click behavior on titles
  if (isSubstanceLAF())
    titlePopupMenu(frame,
      new VF1<JPopupMenu>() { void get(JPopupMenu menu) { try { 
        boolean alwaysOnTop = frame.isAlwaysOnTop();
        menu.add(jmenuItem("Restart Program", "restart"));
        menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
        menu.add(jmenuItem("Show Console", "showConsole"));
        menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() { public void run() { try { 
          toggleAlwaysOnTop(frame) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "toggleAlwaysOnTop(frame)"; }}));
        menu.add(jMenuItem("Shoot Window", new Runnable() { public void run() { try {  shootWindowGUI_external(frame, 500) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "shootWindowGUI_external(frame, 500)"; }}));
        //addMenuItem(menu, "Bigger fonts", f swingBiggerFonts);
        //addMenuItem(menu, "Smaller fonts", f swingSmallerFonts);
       } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n        menu.add(jmenuItem(\"Restar..."; }});
}

static <A, B> Pair<A, B> pair(A a, B b) {
  return new Pair(a, b);
}

static <A> Pair<A, A> pair(A a) {
  return new Pair(a, a);
}
static String htmlencode_forParams(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      /*if (c >= 0x100)
        out.append("&#x").append(charToHex(c)).append(';');
      else*/ if (c > 127 || c == '"' || c == '<' || c == '>') {
          out.append("&#");
          out.append((int) c);
          out.append(';');
      } else
          out.append(c);
  }
  return out.toString();
}
static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}

static int lastIndexOf(String a, char b) {
  return a == null ? -1 : a.lastIndexOf(b);
}
static boolean possibleMD5(String s) { return isMD5(s); }
static String javaTok_substringN(String s, int i, int j) {
  if (i == j) return "";
  if (j == i+1 && s.charAt(i) == ' ') return " ";
  return s.substring(i, j);
}
static void upgradeJavaXAndRestart() {
  
    run("#1001639");
    restart();
    sleep();
  
  
}
static Frame getAWTFrame(final Object _o) {
  return swing(new F0<Frame>() { Frame get() { try { 
    Object o = _o;
    /*
    ifdef HaveProcessing
      if (o instanceof PApplet) o = ((PApplet) o).getSurface();
    endifdef
    */
    if (o instanceof ButtonGroup) o = first(buttonsInGroup((ButtonGroup) o));
    if (!(o instanceof Component)) return null;
    Component c = (Component) o;
    while (c != null) {
      if (c instanceof Frame) return (Frame) c;
      c = c.getParent();
    }
    return null;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "O o = _o;\r\n    /*\r\n    ifdef HaveProcessing\r\n      if (o instanceof PApplet) ..."; }});
}


static String formatGMTWithDate_24(long time) {
  return simpleDateFormat_GMT("yyyy/MM/dd").format(time) + " " + formatGMT_24(time);
}
static boolean sameSnippetID(String a, String b) {
  if (!isSnippetID(a) || !isSnippetID(b)) return false;
  return parseSnippetID(a) == parseSnippetID(b);
}
static char lastCharacter(String s) {
  return empty(s) ? 0 : s.charAt(l(s)-1);
}
static float[] bwImageColumnMinBrightness(BWImage img) {
  int w = img.getWidth(), h = img.getHeight();
  float[] f = new float[w];
  for (int x = 0; x < w; x++)
    f[x] = (float) img.clip(x, 0, 1, h).minimumBrightness();
  return f;
}

static JTextField onEnter(final JTextField tf, final Object action) {
  if (action == null || tf == null) return tf;
  tf.addActionListener(new java.awt.event.ActionListener() { public void actionPerformed(java.awt.event.ActionEvent _evt) { try {
    tf.selectAll();
    callF(action);
  } catch (Throwable __e) { messageBox(__e); }}});
  return tf;
}

static JButton onEnter(JButton btn, final Object action) {
  if (action == null || btn == null) return btn;
  btn.addActionListener(actionListener(action));
  return btn;
}

static JList onEnter(JList list, Object action) {
  list.addKeyListener(enterKeyListener(action));
  return list;
}

// editable only
static JComboBox onEnter(final JComboBox cb, final Object action) {
  JTextField text = (JTextField) cb.getEditor().getEditorComponent();
  /*onEnter(text, r {
    cb.hidePopup();
    pcallF(action);
  });*/
  onEnter(text, action);
  return cb;
}
static ImageIcon imageIcon(String imageID) { try {
  return new ImageIcon(loadBinarySnippet(imageID).toURI().toURL());
} catch (Exception __e) { throw rethrow(__e); } }

static ImageIcon imageIcon(BufferedImage img) {
  return new ImageIcon(img);
}


  static ImageIcon imageIcon(RGBImage img) {
    return imageIcon(img.getBufferedImage());
  }



static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}
static String dropSuffixIgnoreCase(String suffix, String s) {
  return ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
// menuMaker = voidfunc(JPopupMenu)
static void titlePopupMenu(final Component c, final Object menuMaker) {
  swingNowOrLater(new Runnable() { public void run() { try { 
    if (!isSubstanceLAF())
      print("Can't add title right click!");
    else {
      JComponent titleBar = getTitlePaneComponent(getFrame(c));
      componentPopupMenu(titleBar, menuMaker);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!isSubstanceLAF())\r\n      print(\"Can't add title right click!\");\r\n    els..."; }});
}
static void duplicateThisProgram() {
  nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
}
static <A> A oneOf(List<A> l) {
  return l.isEmpty() ? null : l.get(new Random().nextInt(l.size()));
}

static char oneOf(String s) {
  return empty(s) ? '?' : s.charAt(random(l(s)));
}

static String oneOf(String... l) {
  return oneOf(asList(l));
}
static KeyListener enterKeyListener(final Object action) {
  return new KeyAdapter() {
    public void keyReleased(KeyEvent ke) {
      if (ke.getKeyCode() == KeyEvent.VK_ENTER)
        pcallF(action);
    }
  };
}
static <A> A collectionGet(Collection<A> c, int idx) {
  if (c == null || idx < 0 || idx >= l(c)) return null;
  if (c instanceof List) return listGet((List<A>) c, idx);
  Iterator<A> it = c.iterator();
  for (int i = 0; i < idx; i++) if (it.hasNext()) it.next(); else return null;
  return it.hasNext() ? it.next() : null;
}
static boolean containsIgnoreCase(Collection<String> l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String[] l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String s, char c) {
  return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
}

static boolean containsIgnoreCase(String a, String b) {
  return indexOfIgnoreCase(a, b) >= 0;
}
static String urlencode(String x) {
  try {
    return URLEncoder.encode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}


static SimpleDateFormat simpleDateFormat_GMT(String format) {
  SimpleDateFormat sdf = new SimpleDateFormat(format);
  sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
  return sdf;
}
static boolean isSubstanceLAF() {
  return substanceLookAndFeelEnabled();
}
static String lower(String s) {
  return s == null ? null : s.toLowerCase();
}

static char lower(char c) {
  return Character.toLowerCase(c);
}
static Map litmap(Object... x) {
  HashMap map = new HashMap();
  litmap_impl(map, x);
  return map;
}

static void litmap_impl(Map map, Object... x) {
  for (int i = 0; i < x.length-1; i += 2)
    if (x[i+1] != null)
      map.put(x[i], x[i+1]);
}


static String formatGMT_24(long time) {
  SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
  sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
  return sdf.format(time) + " GMT";
}
static JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
  JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text, checked);
  mi.addActionListener(actionListener(r));
  return mi;
}
static Lock appendToFile_lock = lock();
static boolean appendToFile_keepOpen;
static HashMap<String,Writer> appendToFile_writers = new HashMap();

static void appendToFile(String path, String s) { try {
  Lock __746 = appendToFile_lock; lock(__746); try { // Let's just generally synchronize this to be safe.
  mkdirsForFile(new File(path));
  path = getCanonicalPath(path);
  Writer writer = appendToFile_writers.get(path);
  if (writer == null) {
    //print("[Logging to " + path + "]");
    writer = new BufferedWriter(new OutputStreamWriter(
      newFileOutputStream(path, true), "UTF-8"));
    if (appendToFile_keepOpen)
      appendToFile_writers.put(path, writer);
  }
  writer.write(s);
  if (!appendToFile_keepOpen)
    writer.close();
} finally { unlock(__746); } } catch (Exception __e) { throw rethrow(__e); } }
  
static void appendToFile(File path, String s) {
  if (path != null)
    appendToFile(path.getPath(), s);
}

static void cleanMeUp_appendToFile() {
  Lock __747 = appendToFile_lock; lock(__747); try {
  closeAllWriters(values(appendToFile_writers));
  appendToFile_writers.clear();
} finally { unlock(__747); } }
static JTextArea jTextArea() {
  return jTextArea("");
}

static JTextArea jTextArea(final String text) {
  return swing(new F0<JTextArea>() { JTextArea get() { try { return  new JTextArea(text) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "new JTextArea(text)"; }});
}
static void shootWindowGUI_external(JFrame frame) {
  call(hotwireOnce("#1007178"), "shootWindowGUI", frame);
}

static void shootWindowGUI_external(final JFrame frame, int delay) {
  call(hotwireOnce("#1007178"), "shootWindowGUI", frame, delay);
}

static void smartSet(Field f, Object o, Object value) throws Exception {
  try {
    f.set(o, value);
  } catch (Exception e) {
    Class type = f.getType();
    
    // take care of common case (long to int)
    if (type == int.class && value instanceof Long)
      value = ((Long) value).intValue();
    
    if (type == LinkedHashMap.class && value instanceof Map)
      { f.set(o, asLinkedHashMap((Map) value)); return; }
    
    
    throw e;
  }
}
static File loadBinarySnippet(String snippetID) { try {
  long id = parseSnippetID(snippetID);
  File f = DiskSnippetCache_getLibrary(id);
  if (fileSize(f) == 0)
    f = loadDataSnippetToFile(snippetID);
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static Class run(String progID, String... args) {
  Class main = hotwire(progID);
  callMain(main, args);
  return main;
}
static String classNameToVM(String name) {
  return name.replace(".", "$");
}
static void setOpt_raw(Object o, String field, Object value) { try {
  if (o == null) return;
  if (o instanceof Class) setOpt_raw((Class) o, field, value);
  else {
    Field f = setOpt_raw_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      smartSet(f, o, value);
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt_raw(Class c, String field, Object value) { try {
  if (c == null) return;
  Field f = setOpt_raw_findStaticField(c, field);
  if (f != null) {
    f.setAccessible(true);
    smartSet(f, null, value);
  }
} catch (Exception __e) { throw rethrow(__e); } }
  
static Field setOpt_raw_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field setOpt_raw_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
  if (x == null) return l;
  
  int i = 0;
  while (true) {
    i = indexOfSubList(l, x, i);
    if (i < 0) break;
    
    // It's inefficient :D
    for (int j = 0; j < l(x); j++) l.remove(i);
    l.addAll(i, y);
    i += l(y);
  }
  return l;
}

static <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
  // inefficient
  while (toIndex > fromIndex) l.remove(--toIndex);
  l.addAll(fromIndex, y);
  return l;
}
  static List<String> codeTokensOnly(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 1; i < tok.size(); i += 2)
      l.add(tok.get(i));
    return l;
  }
static JMenuItem jmenuItem(String text, final Object r) {
  JMenuItem mi = new JMenuItem(text);
  mi.addActionListener(actionListener(r));
  return mi;
}
static String standardCredentialsUser() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/username")));
}
static Map<String, String> hippoSingulars() {
  return pairsToMap((List<Pair<String, String>>) scanStructureLog("#1011041", "singulars"));
}
static void restart() {
  Object j = getJavaX();
  call(j, "cleanRestart", get(j, "fullArgs"));
}
static void messageBox(final String msg) {
  if (headless()) print(msg);
  else { swing(new Runnable() { public void run() { try { 
    JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MES..."; }}); }
}

static void messageBox(Throwable e) {
  showConsole();
  printStackTrace(e);
  messageBox(hideCredentials(innerException(e)));
}
static Class<?> getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class getClass(Object o) {
  return o instanceof Class ? (Class) o : o.getClass();
}

static Class getClass(Object realm, String name) { try {
  try {
    return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static ThreadLocal < List < Object > > holdInstance_l = new ThreadLocal();

static AutoCloseable holdInstance(Object o) {
  if (o == null) return null;
  listThreadLocalAdd(holdInstance_l, o);
  return new AutoCloseable() {
    public void close() {
      listThreadLocalPopLast(holdInstance_l);
    }
  };
}
static int findCodeTokens(List<String> tok, String... tokens) {
  return findCodeTokens(tok, 1, false, tokens);
}

static int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, 1, ignoreCase, tokens);
}

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
}

static List<String> findCodeTokens_specials = litlist("*", "<quoted>", "<id>", "<int>", "\\*");
static boolean findCodeTokens_debug;
static int findCodeTokens_indexed, findCodeTokens_unindexed;
static int findCodeTokens_bails, findCodeTokens_nonbails;

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
  if (findCodeTokens_debug) {
    if (eq(getClassName(tok), "main$IndexedList2"))
      findCodeTokens_indexed++;
    else
      findCodeTokens_unindexed++;
  }
  // bail out early if first token not found (works great with IndexedList)
  if (!findCodeTokens_specials.contains(tokens[0])
    && !tok.contains(tokens[0] /*, startIdx << no signature in List for this, unfortunately */)) {
      ++findCodeTokens_bails;
      return -1;
    }
  ++findCodeTokens_nonbails;
  
  outer: for (int i = startIdx | 1; i+tokens.length*2-2 < tok.size(); i += 2) {
    for (int j = 0; j < tokens.length; j++) {
      String p = tokens[j], t = tok.get(i+j*2);
      boolean match;
      if (eq(p, "*")) match = true;
      else if (eq(p, "<quoted>")) match = isQuoted(t);
      else if (eq(p, "<id>")) match = isIdentifier(t);
      else if (eq(p, "<int>")) match = isInteger(t);
      else if (eq(p, "\\*")) match = eq("*", t);
      else match = ignoreCase ? eqic(p, t) : eq(p, t);
      
      if (!match)
        continue outer;
    }
    
    if (condition == null || checkTokCondition(condition, tok, i-1)) // pass N index
      return i;
  }
  return -1;
}
static JMenuItem jMenuItem(String text, Object r) {
  return jmenuItem(text, r);
}
static String lastWord(String s) {
  return lastJavaToken(s);
}
static void toggleAlwaysOnTop(JFrame frame) {
  frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
}
static String standardCredentialsPass() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/userpass")));
}


static <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
  if (map instanceof LinkedHashMap) return (LinkedHashMap) map;
  LinkedHashMap<A,B> m = new LinkedHashMap();
  if (map != null) synchronized(collectionMutex(map)) {
    m.putAll(map);
  }
  return m;
}
static JComponent getTitlePaneComponent(Window window) {
  if (!substanceLookAndFeelEnabled()) return null;
  
	JRootPane rootPane = null;
	if (window instanceof JFrame)
		rootPane = ((JFrame) window).getRootPane();
	if (window instanceof JDialog)
		rootPane = ((JDialog) window).getRootPane();
	if (rootPane != null) {
		Object /*SubstanceRootPaneUI*/ ui = rootPane.getUI();
		return (JComponent) call(ui, "getTitlePane");
	}
	return null;
}

static class componentPopupMenu_Maker {
  List menuMakers = new ArrayList();
}

static Map<JComponent, componentPopupMenu_Maker> componentPopupMenu_map = new WeakHashMap();

static ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent = new ThreadLocal();

// menuMaker = voidfunc(JPopupMenu)
static void componentPopupMenu(final JComponent component, final Object menuMaker) {
  swingNowOrLater(new Runnable() { public void run() { try { 
    componentPopupMenu_Maker maker = componentPopupMenu_map.get(component);
    if (maker == null) {
      componentPopupMenu_map.put(component, maker = new componentPopupMenu_Maker());
      component.addMouseListener(new componentPopupMenu_Adapter(maker));
    }
    maker.menuMakers.add(menuMaker);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "componentPopupMenu_Maker maker = componentPopupMenu_map.get(component);\r\n    ..."; }});
}

static class componentPopupMenu_Adapter extends MouseAdapter {
  componentPopupMenu_Maker maker;
  
  componentPopupMenu_Adapter(componentPopupMenu_Maker maker) {
  this.maker = maker;}
  
  public void mousePressed(MouseEvent e) { displayMenu(e); }
  public void mouseReleased(MouseEvent e) { displayMenu(e); }

  void displayMenu(MouseEvent e) {
    if (e.isPopupTrigger()) displayMenu2(e);
  }
    
  void displayMenu2(MouseEvent e) {
    JPopupMenu menu = new JPopupMenu();
    int emptyCount = menu.getComponentCount();
    
    componentPopupMenu_mouseEvent.set(e);
    for (Object menuMaker : maker.menuMakers)
      pcallF(menuMaker, menu);
    
    // show menu if any items in it
    if (menu.getComponentCount() != emptyCount)
      menu.show(e.getComponent(), e.getX(), e.getY());
  }
}
static String getCanonicalPath(String path) { try {
  return new File(path).getCanonicalPath();
} catch (Exception __e) { throw rethrow(__e); } }
static <A> A callMain(A c, String... args) {
  callOpt(c, "main", new Object[] {args});
  return c;
}

static void callMain() {
  callMain(mc());
}
static boolean checkTokCondition(Object condition, List<String> tok, int i) {
  if (condition instanceof TokCondition)
    return ((TokCondition) condition).get(tok, i);
  return checkCondition(condition, tok, i);
}
static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}
static void lock(Lock lock) { try {
  ping();
  lock.lockInterruptibly();
  ping();
} catch (Exception __e) { throw rethrow(__e); } }

static void lock(Lock lock, String msg) {
  print("Locking: " + msg);
  lock(lock);
}

static void lock(Lock lock, String msg, long timeout) {
  print("Locking: " + msg);
  lockOrFail(lock, timeout);
}

static ReentrantLock lock() {
  return fairLock();
}
static void closeAllWriters(Collection<? extends Writer> l) {
  for (Writer w : unnull(l)) try {
    w.close();
  } catch (Throwable __e) { printStackTrace2(__e); }
}
static String lastJavaToken(String s) {
  return last(javaTokC(s));
}
static void swingNowOrLater(Runnable r) {
  if (isAWTThread())
    r.run();
  else
    swingLater(r);
}
static void nohupJavax(final String javaxargs) {
  { Thread _t_0 = new Thread() {
public void run() { try { call(hotwireOnce("#1008562"), "nohupJavax", javaxargs); } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_0); }
}

static void nohupJavax(final String javaxargs, final String vmArgs) {
  { Thread _t_1 = new Thread() {
public void run() { try { call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs); } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_1); }
}
static boolean isIdentifier(String s) {
  return isJavaIdentifier(s);
}
static List scanStructureLog(String progID, String fileName) {
  return scanStructureLog(getProgramFile(progID, fileName));
}

static List scanStructureLog(String fileName) {
  return scanStructureLog(getProgramFile(fileName));
}

static List scanStructureLog(File file) {
  List l = new ArrayList();
  for (String s : scanLog(file)) try {
    l.add(unstructure(s));
  } catch (Throwable __e) { printStackTrace2(__e); }
  return l;
}
static <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
  List<A> l = tl.get();
  if (l == null) return null;
  A a = popLast(l);
  if (empty(l)) tl.set(null);
  return a;
}
static <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
  List<A> l = tl.get();
  if (l == null) tl.set(l = new ArrayList());
  l.add(a);
}
static <A> int indexOfSubList(List<A> x, List<A> y) {
  return indexOfSubList(x, y, 0);
}

static <A> int indexOfSubList(List<A> x, List<A> y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y.get(j)))
        continue outer;
    return i;
  }
  return -1;
}

static <A> int indexOfSubList(List<A> x, A[] y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y[j]))
        continue outer;
    return i;
  }
  return -1;
}
static <A, B> HashMap<A, B> pairsToMap(Collection<? extends Pair<A, B>> l) {
  HashMap<A,B> map = new HashMap();
  if (l != null) for (Pair<A, B> p : l)
    map.put(p.a, p.b);
  return map;
}
static void unlock(Lock lock, String msg) {
  print("Unlocking: " + msg);
  lock.unlock();
}

static void unlock(Lock lock) {
  lock.unlock();
}
static File loadDataSnippetToFile(String snippetID) { try {
  snippetID = fsI(snippetID);
  File f = DiskSnippetCache_file(parseSnippetID(snippetID));
  List<URL> urlsTried = new ArrayList();
  List<Throwable> errors = new ArrayList();
  try {
    URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
    print("Loading library: " + hideCredentials(url));
    try {
      loadBinaryPageToFile(openConnection(url), f);
      if (fileSize(f) == 0) throw fail();
    } catch (Throwable e) {
      errors.add(e);
      url = addAndReturn(urlsTried, new URL("http://data.tinybrain.de/blobs/"
        + psI(snippetID)));
      print("Trying other server: " + hideCredentials(url));
      loadBinaryPageToFile(openConnection(url), f);
      print("Got bytes: " + fileSize(f));
    }
    // TODO: check if we hit the "LOADING" message
    if (fileSize(f) == 0) throw fail();
    System.err.println("Bytes loaded: " + fileSize(f));
  } catch (Throwable e) {
    printStackTrace(e);
    errors.add(e);
    throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
  }
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static <A> A listGet(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}
static File DiskSnippetCache_file(long snippetID) {
  return new File(getGlobalCache(), "data_" + snippetID + ".jar");
}
  
  // Data files are immutable, use centralized cache
public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
  File file = DiskSnippetCache_file(snippetID);
  return file.exists() ? file : null;
}

public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
  saveBinaryFile(DiskSnippetCache_file(snippetID), data);
}

static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
  byte[] data;
  try {
    URL url = new URL("http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + parseSnippetID(snippetID) + "&contentType=application/binary");
    System.err.println("Loading library: " + url);
    try {
      data = loadBinaryPage(url.openConnection());
    } catch (RuntimeException e) {
      data = null;
    }
    
    if (data == null || data.length == 0) {
      url = new URL("http://data.tinybrain.de/blobs/"
        + parseSnippetID(snippetID));
      System.err.println("Loading library: " + url);
      data = loadBinaryPage(url.openConnection());
    }
    System.err.println("Bytes loaded: " + data.length);
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return data;
}
// works on lists and strings and null

static int indexOfIgnoreCase(List<String> a, String b) {
  return indexOfIgnoreCase(a, b, 0);
}

static int indexOfIgnoreCase(List<String> a, String b, int i) {
  int n = l(a);
  for (; i < n; i++)
    if (eqic(a.get(i), b)) return i;
  return -1;
}

static int indexOfIgnoreCase(String a, String b) {
  return indexOfIgnoreCase_manual(a, b);
  /*Matcher m = Pattern.compile(b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher(a);
  if (m.find()) return m.start(); else ret -1;*/
}
static long fileSize(String path) { return getFileSize(path); }
static long fileSize(File f) { return getFileSize(f); }

static Throwable innerException(Throwable e) {
  return getInnerException(e);
}
static Class<?> hotwire(String src) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    
    
    Class c = (Class) ( call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
    
  }
}
static Class hotwireOnce(String programID) {
  return hotwireCached(programID, false);
}


static TreeMap<String,Class> hotwireCached_cache = new TreeMap();
static Lock hotwireCached_lock = lock();

static Class hotwireCached(String programID) {
  return hotwireCached(programID, true);
}

static Class hotwireCached(String programID, boolean runMain) {
  return hotwireCached(programID, runMain, false);
}

static Class hotwireCached(String programID, boolean runMain, boolean dependent) {
  Lock __1489 = hotwireCached_lock; lock(__1489); try {
  
  programID = formatSnippetID(programID);
  Class c = hotwireCached_cache.get(programID);
  if (c == null) {
    c = hotwire(programID);
    if (dependent)
      makeDependent(c);
    if (runMain)
      callMain(c);
    hotwireCached_cache.put(programID, c);
  }
  return c;
} finally { unlock(__1489); } }
  /** writes safely (to temp file, then rename) */
  public static void saveBinaryFile(String fileName, byte[] contents) throws IOException {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
    fileOutputStream.write(contents);
    fileOutputStream.close();
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);

    if (!new File(tempFileName).renameTo(file))
      throw new IOException("Can't rename " + tempFileName + " to " + fileName);
  }

  static void saveBinaryFile(File fileName, byte[] contents) {
    try {
      saveBinaryFile(fileName.getPath(), contents);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
static String dataSnippetLink(String snippetID) {
  long id = parseSnippetID(snippetID);
  if (id >= 1100000 && id < 1200000)
    return "http://ai1.space/images/raw/" + id;
  if (id >= 1200000 && id < 1300000) { // Woody files, actually
    String pw = muricaPassword();
    if (empty(pw)) throw fail("Please set 'murica password by running #1008829");
    return "http://butter.botcompany.de:8080/1008823/raw/" + id + "?_pass=" + pw; // XXX, although it typically gets hidden when printing
  } else
    return "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + id + "&contentType=application/binary";
}
static long getFileSize(String path) {
  return path == null ? 0 : new File(path).length();
}

static long getFileSize(File f) {
  return f == null ? 0 : f.length();
}
static boolean _inCore() {
  return false;
}
static void loadBinaryPageToFile(String url, File file) { try {
  print("Loading " + url);
  loadBinaryPageToFile(openConnection(new URL(url)), file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile(URLConnection con, File file) { try {
  setHeaders(con);
  loadBinaryPageToFile_noHeaders(con, file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) { try {
  File ftemp = new File(f2s(file) + "_temp");
  FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
  try {
    InputStream inputStream = con.getInputStream();
    long len = 0;
    try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
    String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
    copyStreamWithPrints(inputStream, buf, pat);
    inputStream.close();
    buf.close();
    file.delete();
    renameFile_assertTrue(ftemp, file);
  } finally {
    if (buf != null) buf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

static byte[] loadBinaryPage(String url) { try {
  print("Loading " + url);
  return loadBinaryPage(loadPage_openConnection(new URL(url)));
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage(URLConnection con) { try {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
  setHeaders(con);
  for (String key : keys(extraHeaders))
    con.setRequestProperty(key, extraHeaders.get(key));
  return loadBinaryPage_noHeaders(con);
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage_noHeaders(URLConnection con) { try {
  ByteArrayOutputStream buf = new ByteArrayOutputStream();
  InputStream inputStream = con.getInputStream();
  loadBinaryPage_responseHeaders.set(con.getHeaderFields());
  long len = 0;
  try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
int n = 0;
  while (true) {
    int ch = inputStream.read();
    if (ch < 0)
      break;
    buf.write(ch);
    if (++n % 100000 == 0)
      println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
  }
  inputStream.close();
  return buf.toByteArray();
} catch (Exception __e) { throw rethrow(__e); } }

static Object unstructure(String text) {
  return unstructure(text, false);
}

static Object unstructure(String text, final boolean allDynamic) {
  return unstructure(text, allDynamic, null);
}

static int structure_internStringsLongerThan = 50;
static int unstructure_unquoteBufSize = 100;

static int unstructure_tokrefs; // stats

abstract static class unstructure_Receiver {
  abstract void set(Object o);
}

// classFinder: func(name) -> class (optional)
static Object unstructure(String text, boolean allDynamic,
  Object classFinder) {
  if (text == null) return null;
  return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
}

static Object unstructure_reader(BufferedReader reader) {
  return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
}

static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object classFinder) {
  final boolean debug = unstructure_debug;
  
  final class X {
    int i = -1;
    HashMap<Integer,Object> refs = new HashMap();
    HashMap<Integer,Object> tokrefs = new HashMap();
    HashSet<String> concepts = new HashSet();
    HashMap<String,Class> classesMap = new HashMap();
    List<Runnable> stack = new ArrayList();
    String curT;
    char[] unquoteBuf = new char[unstructure_unquoteBufSize];
    
    String unquote(String s) {
      return unquoteUsingCharArray(s, unquoteBuf); 
    }

    // look at current token
    String t() {
      return curT;
    }
    
    // get current token, move to next
    String tpp() {
      String t = curT;
      consume();
      return t;
    }
    
    void parse(final unstructure_Receiver out) {
      String t = t();
      
      int refID = 0;
      if (structure_isMarker(t, 0, l(t))) {
        refID = parseInt(t.substring(1));
        consume();
      }
      final int _refID = refID;
      
      // if (debug) print("parse: " + quote(t));
      
      final int tokIndex = i;  
      parse_inner(refID, tokIndex, new unstructure_Receiver() {
        void set(Object o) {
          if (_refID != 0)
            refs.put(_refID, o);
          if (o != null)
            tokrefs.put(tokIndex, o);
          out.set(o);
        }
      });
    }
    
    void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
      String t = t();
      
      // if (debug) print("parse_inner: " + quote(t));
      
      Class c = classesMap.get(t);
      if (c == null) {
        if (t.startsWith("\"")) {
          String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
          out.set(s); return;
        }
        
        if (t.startsWith("'")) {
          out.set(unquoteCharacter(tpp())); return;
        }
        if (t.equals("bigint")) {
          out.set(parseBigInt()); return;
        }
        if (t.equals("d")) {
          out.set(parseDouble()); return;
        }
        if (t.equals("fl")) {
          out.set(parseFloat()); return;
        }
        if (t.equals("sh")) {
          consume();
          t = tpp();
          if (t.equals("-")) {
            t = tpp();
            out.set((short) (-parseInt(t))); return;
          }
          out.set((short) parseInt(t)); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          if (debug)
            print("l=" + l + ", isInt: " + isInt);
          out.set(isInt ? (Object) new Integer((int) l) : (Object) new Long(l)); return;
        }
        if (t.equals("false") || t.equals("f")) {
          consume(); out.set(false); return;
        }
        if (t.equals("true") || t.equals("t")) {
          consume(); out.set(true); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          if (debug)
            print("l=" + l + ", isInt: " + isInt);
          out.set(isInt ? (Object) new Integer((int) l) : (Object) new Long(l)); return;
        }
        
        if (t.equals("File")) {
          consume();
          File f = new File(unquote(tpp()));
          out.set(f); return;
        }
        
        if (t.startsWith("r") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = refs.get(ref);
          if (o == null)
            print("Warning: unsatisfied back reference " + ref);
          out.set(o); return;
        }
      
        if (t.startsWith("t") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = tokrefs.get(ref);
          if (o == null)
            print("Warning: unsatisfied token reference " + ref);
          out.set(o); return;
        }
        
        if (t.equals("hashset")) {
          parseHashSet(out); return;
        }
        if (t.equals("treeset")) {
          parseTreeSet(out); return;
        }
        if (eqOneOf(t, "hashmap", "hm")) {
          consume();
          parseMap(new HashMap(), out);
          return;
        }
        if (t.equals("lhm")) {
          consume();
          parseMap(new LinkedHashMap(), out);
          return;
        }
        if (t.equals("{")) {
          parseMap(out); return;
        }
        if (t.equals("[")) {
          parseList(out); return;
        }
        if (t.equals("bitset")) {
          parseBitSet(out); return;
        }
        if (t.equals("array") || t.equals("intarray")) {
          parseArray(out); return;
        }
        if (t.equals("ba")) {
          consume();
          String hex = unquote(tpp());
          out.set(hexToBytes(hex)); return;
        }
        if (t.equals("boolarray")) {
          consume();
          int n = parseInt(tpp());
          String hex = unquote(tpp());
          out.set(boolArrayFromBytes(hexToBytes(hex), n)); return;
        }
        if (t.equals("class")) {
          out.set(parseClass()); return;
        }
        if (t.equals("l")) {
          parseLisp(out); return;
        }
        if (t.equals("null")) {
          consume(); out.set(null); return;
        }
        
        if (eq(t, "c")) {
          consume("c");
          t = t();
          assertTrue(isJavaIdentifier(t));
          concepts.add(t);
        }
      }
      
      if (eq(t, "j")) {
        consume("j");
        out.set(parseJava()); return;
      }

      if (c == null && !isJavaIdentifier(t))
        throw new RuntimeException("Unknown token " + (i+1) + ": " + t);
        
      // any other class name
      if (c == null) {
        // First, find class
        if (allDynamic) c = null;
        else c = classFinder != null ? (Class) callF(classFinder, t) : findClass(t);
        if (c != null)
          classesMap.put(t, c);
      }
          
      // Check if it has an outer reference
      consume();
      boolean hasBracket = eq(t(), "(");
      if (hasBracket) consume();
      boolean hasOuter = hasBracket && eq(t(), "this$1");
      
      DynamicObject dO = null;
      Object o = null;
      if (c != null) {
        o = hasOuter ? nuStubInnerObject(c) : nuEmptyObject(c);
        if (o instanceof DynamicObject) dO = (DynamicObject) o;
      } else {
        if (concepts.contains(t) && (c = findClass("Concept")) != null)
          o = dO = (DynamicObject) nuEmptyObject(c);
        else
          dO = new DynamicObject();
        dO.className = t;
        if (debug) print("Made dynamic object " + t + " " + shortClassName(dO));
      }
      
      // Save in references list early because contents of object
      // might link back to main object
      
      if (refID != 0)
        refs.put(refID, o != null ? o : dO);
      tokrefs.put(tokIndex, o != null ? o : dO);
      
      // NOW parse the fields!
      
      final LinkedHashMap<String,Object> fields = new LinkedHashMap(); // preserve order
      final Object _o = o;
      final DynamicObject _dO = dO;
      if (hasBracket) {
        stack.add(new Runnable() { public void run() { try { 
          if (eq(t(), ")")) {
            consume(")");
            objRead(_o, _dO, fields);
            out.set(_o != null ? _o : _dO);
          } else {
            final String key = unquote(tpp());
            consume("=");
            stack.add(this);
            parse(new unstructure_Receiver() {
              void set(Object value) {
                fields.put(key, value);
                if (eq(t(), ",")) consume();
              }
            });
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, ..."; }});
      } else {
        objRead(o, dO, fields);
        out.set(o != null ? o : dO);
      }
    }
    
    void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
      
      if (o != null)
        if (dO != null) {
          if (debug)
            printStructure("setOptAllDyn", fields);
          setOptAllDyn(dO, fields);
        } else {
          setOptAll_pcall(o, fields);
          
        }
      else for (String field : keys(fields))
        dO.fieldValues.put(intern(field), fields.get(field));

      if (o != null)
        pcallOpt_noArgs(o, "_doneLoading");
    }
    
    void parseSet(final Set set, final unstructure_Receiver out) {
      parseList(new unstructure_Receiver() {
        void set(Object o) {
          set.addAll((List) o);
          out.set(set);
        }
      });
    }
    
    void parseLisp(final unstructure_Receiver out) {
      
      
      throw fail("class Lisp not included");
    }
    
    void parseBitSet(final unstructure_Receiver out) {
      consume("bitset");
      consume("{");
      final BitSet bs = new BitSet();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(bs);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              bs.set((Integer) o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ..."; }});
    }
    
    void parseList(final unstructure_Receiver out) {
      consume("[");
      final ArrayList list = new ArrayList();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "]")) {
          consume("]");
          out.set(list);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              //if (debug) print("List element type: " + getClassName(o));
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n     ..."; }});
    }
    
    void parseArray(final unstructure_Receiver out) {
      final String type = tpp();
      consume("{");
      final List list = new ArrayList();
      
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"..."; }});
    }
    
    Object parseClass() {
      consume("class");
      consume("(");
      String name = unquote(tpp());
      consume(")");
      name = dropPrefix("main$", name);
      Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass(name);
      if (c != null) return c;
      DynamicObject dO = new DynamicObject();
      dO.className = "java.lang.Class";
      dO.fieldValues.put("name", name);
      return dO;
    }
    
    Object parseBigInt() {
      consume("bigint");
      consume("(");
      String val = tpp();
      if (eq(val, "-"))
        val = "-" + tpp();
      consume(")");
      return new BigInteger(val);
    }
    
    Object parseDouble() {
      consume("d");
      consume("(");
      String val = unquote(tpp());
      consume(")");
      return Double.parseDouble(val);
    }
    
    Object parseFloat() {
      consume("fl");
      String val;
      if (eq(t(), "(")) {
        consume("(");
        val = unquote(tpp());
        consume(")");
      } else {
        val = unquote(tpp());
      }
      return Float.parseFloat(val);
    }
    
    void parseHashSet(unstructure_Receiver out) {
      consume("hashset");
      parseSet(new HashSet(), out);
    }
    
    void parseTreeSet(unstructure_Receiver out) {
      consume("treeset");
      parseSet(new TreeSet(), out);
    }
    
    void parseMap(unstructure_Receiver out) {
      parseMap(new TreeMap(), out);
    }
    
    Object parseJava() {
      String j = unquote(tpp());
      Matches m = new Matches();
      if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
        return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
      else {
        warn("Unknown Java object: " + j);
        return null;
      }
    }
    
    void parseMap(final Map map, final unstructure_Receiver out) {
      consume("{");
      stack.add(new Runnable() {
        boolean v;
        Object key;
        
        public void run() { 
          if (v) {
            v = false;
            stack.add(this);
            consume("=");
            parse(new unstructure_Receiver() {
              void set(Object value) {
                map.put(key, value);
                if (debug)
                  print("parseMap: Got value " + getClassName(value) + ", next token: " + quote(t()));
                if (eq(t(), ",")) consume();
              }
            });
          } else {
            if (eq(t(), "}")) {
              consume("}");
              out.set(map);
            } else {
              v = true;
              stack.add(this);
              parse(new unstructure_Receiver() {
                void set(Object o) {
                  key = o;
                }
              });
            }
          } // if v else
        } // run()
      });
    }
    
    /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
    
    void consume() { curT = tok.next(); ++i; }
    
    void consume(String s) {
      if (!eq(t(), s)) {
        /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
        throw fail(quote(s) + " expected, got " + quote(t()));
      }
      consume();
    }
    
    void parse_x(unstructure_Receiver out) {
      consume(); // get first token
      parse(out);
      while (nempty(stack))
        popLast(stack).run();
    }
  }
  
  Boolean b = DynamicObject_loading.get();
  DynamicObject_loading.set(true);
  try {
    final Var v = new Var();
    X x = new X();
    x.parse_x(new unstructure_Receiver() {
      void set(Object o) { v.set(o); }
    });
    unstructure_tokrefs = x.tokrefs.size();
    return v.get();
  } finally {
    DynamicObject_loading.set(b);
  }
}

static boolean unstructure_debug;
static <B, A extends B> A addAndReturn(Collection<B> c, A a) {
  if (c != null) c.add(a);
  return a;
}
static List<String> scanLog(String progID, String fileName) {
  return scanLog(getProgramFile(progID, fileName));
}

static List<String> scanLog(String fileName) {
  return scanLog(getProgramFile(fileName));
}

static List<String> scanLog(File file) {
  List<String> l = new ArrayList();
  for (File f : concatLists(earlierPartsOfLogFile(file), ll(file)))
    for (String s : toLines(file))
      if (isProperlyQuoted(s)) l.add(unquote(s));
  return l;
}
static File getGlobalCache() {
  File file = new File(javaxCachesDir(), "Binary Snippets");
  file.mkdirs();
  return file;
}

static void lockOrFail(Lock lock, long timeout) { try {
  ping();
  if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
    String s = "Couldn't acquire lock after " + timeout + " ms.";
    if (lock instanceof ReentrantLock) {
      ReentrantLock l = (ReentrantLock) ( lock);
      s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
    }
    throw fail(s);
  }
  ping();
} catch (Exception __e) { throw rethrow(__e); } }
static <A> A last(List<A> l) {
  return empty(l) ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static <A> A last(A[] a) {
  return l(a) != 0 ? a[l(a)-1] : null;
}

static <A> A last(Iterator<A> it) {
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}
static boolean checkCondition(Object condition, Object... args) {
  return isTrue(callF(condition, args));
}
static ReentrantLock fairLock() {
  return new ReentrantLock(true);
}
static List<String> allToString(Collection c) {
  List<String> l = new ArrayList();
  for (Object o : c) l.add(str(o));
  return l;
}

static String[] allToString(Object[] c) {
  String[] l = new String[l(c)];
  for (int i = 0; i < l(c); i++) l[i] = str(c[i]);
  return l;
}
static int indexOfIgnoreCase_manual(String a, String b) {
  int la = l(a), lb = l(b);
  if (la < lb) return -1;
  int n = la-lb;
  
  loop: for (int i = 0; i <= n; i++) {
    for (int j = 0; j < lb; j++) {
      char c1 = a.charAt(i+j), c2 = b.charAt(j);
      if (!eqic(c1, c2))
        continue loop;
    }
    return i;
  }
  return -1;
}
static void hotwire_copyOver(Class c) {
  synchronized(StringBuffer.class) {
    for (String field : litlist("print_log", "print_silent", "androidContext")) {
      Object o = getOpt(mc(), field);
      if (o != null)
        setOpt(c, field, o);
    }
      
    Object mainBot = getMainBot();
    if (mainBot != null)
      setOpt(c, "mainBot", mainBot);

    setOpt(c, "creator_class", new WeakReference(mc()));
  }
}
static Object collectionMutex(Object o) {
  String c = className(o);
  if (eq(c, "java.util.TreeMap$KeySet"))
    c = className(o = getOpt(o, "m"));
  else if (eq(c, "java.util.HashMap$KeySet"))
    c = className(o = get_raw(o, "this$0"));

  
  
  if (eqOneOf(c, "java.util.TreeMap$AscendingSubMap", "java.util.TreeMap$DescendingSubMap"))
    c = className(o = get_raw(o, "m"));
    
  
    
  return o;
}


static byte[] hexToBytes(String s) {
  if (odd(l(s))) throw fail("Hex string has odd length: " + quote(shorten(10, s)));
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    int a = parseHexChar(s.charAt(i*2));
    int b = parseHexChar(s.charAt(i*2+1));
    if (a < 0 || b < 0)
      throw fail("Bad hex byte: " + quote(substring(s, i*2, i*2+2)) + " at " + i*2 + "/" + l(s));
    bytes[i] = (byte) ((a << 4) | b);
  }
  return bytes;
}
static HashMap<Class,Constructor> nuEmptyObject_cache = new HashMap();

static <A> A nuEmptyObject(Class<A> c) { try {
  Constructor ctr;
  
  synchronized(nuEmptyObject_cache) {
    ctr = nuEmptyObject_cache.get(c);
    if (ctr == null) {
      nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
      ctr.setAccessible(true);
    }
  }

  return (A) ctr.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuEmptyObject_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (m.getParameterTypes().length == 0)
      return m;
  throw fail("No default constructor declared in " + c.getName());
}

static boolean structure_isMarker(String s, int i, int j) {
  if (i >= j) return false;
  if (s.charAt(i) != 'm') return false;
  ++i;
  while (i < j) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static boolean jmatch(String pat, String s) {
  return jmatch(pat, s, null);
}

static boolean jmatch(String pat, String s, Matches matches) {
  if (s == null) return false;
  return jmatch(pat, javaTok(s), matches);
}

static boolean jmatch(String pat, List<String> toks) {
  return jmatch(pat, toks, null);
}

static boolean jmatch(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = javaTok(pat);
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}
static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
  final class X implements Producer<String> {
    StringBuilder buf = new StringBuilder(); // stores from "i"
    char c, d, e = 'x'; // just not '\0'
    
    X() {
      // fill c, d and e
      nc();
      nc();
      nc();
    }
    
    // get next character(s) into c, d and e
    void nc() { try {
      c = d;
      d = e;
      if (e == '\0') return;
      int i = r.read();
      e = i < 0 ? '\0' : (char) i;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void ncSave() {
      if (c != '\0') {
        buf.append(c);
        nc();
      }
    }
    
    public String next() {
      // scan for whitespace
      while (c != '\0') {
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          nc();
        else if (c == '/' && d == '*') {
          do nc(); while (c != '\0' && !(c == '*' && d == '/'));
          nc(); nc();
        } else if (c == '/' && d == '/') {
          do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
        } else
          break;
      }
      
      if (c == '\0') return null;

      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ncSave();
        while (c != '\0') {
          if (c == opener || c == '\n') { // end at \n to not propagate unclosed string literal errors
            ncSave();
            break;
          } else if (c == '\\') {
            ncSave();
            ncSave();
          } else
            ncSave();
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\''); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ncSave(); while (Character.isDigit(c));
        if (c == 'L') ncSave(); // Long constants like 1L
      } else
        ncSave();
        
      String t = buf.toString();
      buf.setLength(0);
      return t;
    }
  }
  
  return new X();
}

static void copyStreamWithPrints(InputStream in, OutputStream out, String pat) { try {
  byte[] buf = new byte[65536];
  int total = 0;
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
    if ((total+n)/100000 > total/100000)
      print(pat.replace("{*}", str(roundDownTo(total, 100000))));
    total += n;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static void makeDependent(Object c) {
  if (c == null) return;
  assertTrue("Not a class", c instanceof Class);
  hotwire_classes.add(new WeakReference(c));
  
  Object local_log = getOpt(mc(), "local_log");
  if (local_log != null)
    setOpt(c, "local_log", local_log);
    
  Object print_byThread = getOpt(mc(), "print_byThread");
  if (print_byThread != null)
    setOpt(c, "print_byThread", print_byThread);
}

static boolean isLongConstant(String s) {
  if (!s.endsWith("L")) return false;
  s = s.substring(0, l(s)-1);
  return isInteger(s);
}
static void renameFile_assertTrue(File a, File b) { try {
  if (!a.exists()) throw fail("Source file not found: " + f2s(a));
  if (b.exists()) throw fail("Target file exists: " + f2s(b));
  mkdirsForFile(b);
  
  
  if (!a.renameTo(b))
    throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
  
} catch (Exception __e) { throw rethrow(__e); } }
static int[] toIntArray(List<Integer> l) {
  int[] a = new int[l(l)];
  for (int i = 0; i < a.length; i++)
    a[i] = l.get(i);
  return a;
}
static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}
static double parseDouble(String s) {
  return Double.parseDouble(s);
}
static <A> A println(A a) {
  return print(a);
}
public static File mkdirsFor(File file) {
  return mkdirsForFile(file);
}

static void setOptAll_pcall(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    try { setOpt(o, field, fields.get(field)); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
}

static void setOptAll_pcall(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    try { setOpt(o, field, value); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  }
}
static boolean setOptAllDyn_debug;

static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
  if (fields == null) return;
  HashMap<String, Field> fieldMap = instanceFieldsMap(o);
  for (Map.Entry<String, Object> e : fields.entrySet()) {
    String field = e.getKey();
    Object val = e.getValue();
    boolean has = fieldMap.containsKey(field);
    if (has)
      setOpt(o, field, val);
    else {
      o.fieldValues.put(intern(field), val);
      if (setOptAllDyn_debug) print("setOptAllDyn added dyn " + field + " to " + o + " [value: " + val + ", fieldValues = " + systemHashCode(o.fieldValues) + ", " + struct(keys(o.fieldValues)) + "]");
    }
  }
}
static Object mainBot;

static Object getMainBot() {
  return mainBot;
}
static String intern(String s) {
  return fastIntern(s);
}
static Producer<String> javaTokC_noMLS_iterator(final String s) {
  return javaTokC_noMLS_iterator(s, 0);
}

static Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
  return new Producer<String>() {
    final int l = s.length();
    int i = startIndex;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}

static boolean warn_on = true;

static void warn(String s) {
  if (warn_on)
    print("Warning: " + s);
}

static void warn(String s, List<String> warnings) {
  warn(s);
  if (warnings != null)
    warnings.add(s);
}
static String muricaPassword() {
  return trim(loadTextFile(muricaPasswordFile()));
}
static char unquoteCharacter(String s) {
  assertTrue(s.startsWith("'") && s.length() > 1);
  return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length()-1 : s.length()) + "\"").charAt(0);
}
static <A> A nuStubInnerObject(Class<A> c) { try {
  Class outerType = getOuterClass(c);
  Constructor m = c.getDeclaredConstructor(outerType);
  m.setAccessible(true);
  return (A) m.newInstance(new Object[] {null});
} catch (Exception __e) { throw rethrow(__e); } }
static boolean[] boolArrayFromBytes(byte[] a, int n) {
  boolean[] b = new boolean[n];
  int m = min(n, l(a)*8);
  for (int i = 0; i < m; i++)
    b[i] = (a[i/8] & 1 << (i & 7)) != 0;
  return b;
}
static String unquoteUsingCharArray(String s, char[] buf) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      if (l > buf.length) return unquote(s); // fallback
      int n = 0;
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              char[] x = Character.toChars(code);
              int lx = x.length;
              for (int j = 0; j < lx; j++)
                buf[n++] = x[j];
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        buf[n++] = ch;
      }
      return new String(buf, 0, n);
    }
  }
    
  return s; // not quoted - return original
}
static HashMap<String,Class> findClass_cache = new HashMap();

// currently finds only inner classes of class "main"
// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass(String name) {
  synchronized(findClass_cache) {
    if (findClass_cache.containsKey(name))
      return findClass_cache.get(name);
      
    if (!isJavaIdentifier(name)) return null;
    
    Class c;
    try {
      c = Class.forName("main$" + name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_cache.put(name, c);
    return c;
  }
}
static float parseFloat(String s) {
  return Float.parseFloat(s);
}
static List parseList(String s) {
  return (List) safeUnstructure(s);
}
static String className(Object o) {
  return getClassName(o);
}
static File javaxCachesDir_dir; // can be set to work on different base dir

static File javaxCachesDir() {
  return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
}

static File javaxCachesDir(String sub) {
  return newFile(javaxCachesDir(), sub);
}
static String internIfLongerThan(String s, int l) {
  return s == null ? null : l(s) >= l ? intern(s) : s;
}
static void pcallOpt_noArgs(Object o, String method) {
  try { callOpt_noArgs(o, method); } catch (Throwable __e) { printStackTrace2(__e); }
}
static void printStructure(String prefix, Object o) {
  if (endsWithLetter(prefix)) prefix += ": ";
  print(prefix + structureForUser(o));
}

static void printStructure(Object o) {
  print(structureForUser(o));
}



static List<WeakReference<Class>> hotwire_classes = synchroList();

static Class<?> hotwireDependent(String src) {
  Class c = hotwire(src);
  makeDependent(c);
  return c;
}

static String quickSubstring(String s, int i, int j) {
  if (i == j) return "";
  return s.substring(i, j);
}
static HashMap<String, Field> instanceFieldsMap(Object o) {
  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map;
}

static File muricaPasswordFile() {
  return new File(javaxSecretDir(), "murica/muricaPasswordFile");
}
// match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)

static String[] match2(List<String> pat, List<String> tok) {
  // standard case (no ...)
  int i = pat.indexOf("...");
  if (i < 0) return match2_match(pat, tok);
  
  pat = new ArrayList<String>(pat); // We're modifying it, so copy first
  pat.set(i, "*");
  while (pat.size() < tok.size()) {
    pat.add(i, "*");
    pat.add(i+1, ""); // doesn't matter
  }
  
  return match2_match(pat, tok);
}

static String[] match2_match(List<String> pat, List<String> tok) {
  List<String> result = new ArrayList<String>();
  if (pat.size() != tok.size()) {
    
    return null;
  }
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(i);
    
    if (eq(p, "*"))
      result.add(t);
    else if (!equalsIgnoreCase(unquote(p), unquote(t))) // bold change - match quoted and unquoted now
      return null;
  }
  return result.toArray(new String[result.size()]);
}

static void warnIfOddCount(Object... list) {
  if (odd(l(list)))
    printStackTrace("Odd list size: " + list);
}
static String struct(Object o) {
  return structure(o);
}

static String struct(Object o, structure_Data data) {
  return structure(o, data);
}
static Class getOuterClass(Class c) { try {
  String s = c.getName();
  int i = s.lastIndexOf('$');
  return Class.forName(substring(s, 0, i));
} catch (Exception __e) { throw rethrow(__e); } }
static Object safeUnstructure(String s) {
  return unstructure(s, true);
}
static boolean odd(int i) {
  return (i & 1) != 0;
}

static boolean odd(long i) {
  return (i & 1) != 0;
}
static boolean endsWithLetter(String s) {
  return nempty(s) && isLetter(last(s));
}
static int parseHexChar(char c) {
  if (c >= '0' && c <= '9') return charDiff(c, '0');
  if (c >= 'a' && c <= 'f') return charDiff(c, 'a')+10;
  if (c >= 'A' && c <= 'F') return charDiff(c, 'A')+10;
  return -1;
}
static int roundDownTo(int x, int n) {
  return x/n*n;
}

static long roundDownTo(long x, long n) {
  return x/n*n;
}
static Method fastIntern_method;

static String fastIntern(String s) { try {
  if (s == null) return null;
  if (fastIntern_method == null) {
    fastIntern_method = findMethodNamed(javax(), "internPerProgram");
    if (fastIntern_method == null) upgradeJavaXAndRestart();
  }
    
  return (String) fastIntern_method.invoke(null, s);
} catch (Exception __e) { throw rethrow(__e); } }
static int systemHashCode(Object o) {
  return identityHashCode(o);
}
static Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

static Object callOpt_noArgs(Object o, String method) { try {
  if (o == null) return null;
  if (o instanceof Class)
    return callOpt(o, method); // not optimized
  
  Class c = o.getClass();
  HashMap<String, Method> map;
  synchronized(callOpt_noArgs_cache) {
    map = callOpt_noArgs_cache.get(c);
    if (map == null)
      map = callOpt_noArgs_makeCache(c);
  }

  Method m = map.get(method);
  return m != null ? m.invoke(o) : null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
  HashMap<String,Method> map = new HashMap();
  Class _c = c;
  do {
    for (Method m : c.getDeclaredMethods())
      if (m.getParameterTypes().length == 0) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  callOpt_noArgs_cache.put(c, map);
  return map;
}


static File javaxSecretDir_dir; // can be set to work on different base dir

static File javaxSecretDir() {
  return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
}
static int identityHashCode(Object o) {
  return System.identityHashCode(o);
}
// This is a bit rough... finds static and non-static methods.

static Method findMethodNamed(Object obj, String method) {
  if (obj == null) return null;
  if (obj instanceof Class)
    return findMethodNamed((Class) obj, method);
  return findMethodNamed(obj.getClass(), method);
}

static Method findMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method)) {
        m.setAccessible(true);
        return m;
      }
    c = c.getSuperclass();
  }
  return null;
}
static int charDiff(char a, char b) {
  return (int) a-(int) b;
}

static int charDiff(String a, char b) {
  return charDiff(stringToChar(a), b);
}
static boolean equalsIgnoreCase(String a, String b) {
  return eqic(a, b);
}

static boolean equalsIgnoreCase(char a, char b) {
  return eqic(a, b);
}
static boolean isLetter(char c) {
  return Character.isLetter(c);
}


static char stringToChar(String s) {
  if (l(s) != 1) throw fail("bad stringToChar: " + s);
  return firstChar(s);
}


static char firstChar(String s) {
  return s.charAt(0);
}


static abstract class VF1<A> {
  abstract void get(A a);
}static class Rect {
  int x, y, w, h;
  
  Rect() {}
  Rect(Rectangle r) {
    x = r.x;
    y = r.y;
    w = r.width;
    h = r.height;
  }
  Rect(int x, int y, int w, int h) {
  this.h = h;
  this.w = w;
  this.y = y;
  this.x = x;}
  
  Rectangle getRectangle() {
    return new Rectangle(x, y, w, h);
  }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
  
  public String toString() {
    return x + "," + y + " / " + w + "," + h;
  }
  
  int x2() { return x + w; }
  int y2() { return y + h; }
  
  boolean contains(Pt p) {
    return contains(p.x, p.y);
  }
  
  boolean contains(int _x, int _y) {
    return _x >= x && _y >= y && _x < x+w && _y < y+h;
  }
  
  boolean empty() { return w <= 0 || h <= 0; }
}static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  String fsi(int i) { return formatSnippetID(unq(i)); }
  String fsi() { return fsi(0); }
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
}
static class Var<A> implements IVar<A> {
  A v; // you can access this directly if you use one thread
  
  Var() {}
  Var(A v) {
  this.v = v;}
  
  public synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  public synchronized A get() { return v; }
  public synchronized boolean has() { return v != null; }
  public synchronized void clear() { v = null; }
  
  public String toString() { return str(get()); }
}static abstract class TokCondition {
  abstract boolean get(List<String> tok, int i); // i = N Index
}static abstract class F0<A> {
  abstract A get();
}static abstract class F1<A, B> {
  abstract B get(A a);
}static class AutoSegmenter {
  int g = 3;
  List<Rect> clips;
  boolean[] grid;
  int gw, gh;
  boolean diag; // merge diagonally too
  BWImage img;
  // contrastMethod2 = look at local contrast regardless of absolute brightness
  boolean contrastMethod2 = true, blackBG;
  float contrastThreshold = 0.5f, brightnessThreshold = 0.5f;
  int overlap = 1;
  
  AutoSegmenter() {}
  AutoSegmenter(int g) {
  this.g = g;}

  List<Rect> go(RGBImage img) { return go(new BWImage(img)); }
  
  List<Rect> go(BWImage img) {
    this.img = img;
    int w = img.getWidth(), h = img.getHeight();
    gw = w/g;
    gh = h/g; // width & height of grid
    
    step1();
  
    List<String> result = new ArrayList();
    clips = new ArrayList();
  
    for (int y = 0; y < gh; y++)
      for (int x = 0; x < gw; x++)
        if (grid[y*gw+x]) {
          Rect r = fill(x, y);
          r = scaleRect(r, g);
          r = blackBG
            ? autoCropOfBWImage_blackBG(img, r, brightnessThreshold)
            : autoCropOfBWImage(img, r, brightnessThreshold);
          clips.add(r);
        }
      
    return clips;
  }
  
  void step1() {
    int w = img.getWidth(), h = img.getHeight();
    grid = new boolean[gw*gh];
  
    for (int gy = 0; gy <= h- g; gy += g)
      next: for (int gx = 0; gx <= w- g; gx += g) {
        float min = 1, max = 0;
        int y2 = min(h, gy + g + overlap);
        int x2 = min(w, gx + g + overlap);
        for (int y = gy; y < y2; y++)
          for (int x = gx; x < x2; x++) {
            float b = img.getPixel(x, y);
            min = Math.min(min, b);
            max = Math.max(max, b);
            if (contrastMethod2
              ? max-min >= contrastThreshold
              : min < brightnessThreshold && max > brightnessThreshold) {
              grid[(gy / g) * gw + (gx / g)] = true;
              continue next;
            }
          }
      }
  }

  // with virtual stack
  Rect fill(int x, int y) {
    Rect r = null;
    List<Pt> stack = new ArrayList();
    stack.add(new Pt(x, y));
    while (nempty(stack)) {
      Pt p = popLast(stack);
      x = p.x;
      y = p.y;

      if (!(x < 0 || y < 0 || x >= gw || y >= gh)) {
        int idx = y*gw+x;
        
        if (grid[idx]) {
          grid[idx] = false;
          Rect me = new Rect(x, y, 1, 1);
          if (r == null)
            r = me;
          else
            r = rectUnion(r, me);

          stack.add(new Pt(x-1, y));
          stack.add(new Pt(x+1, y));
          stack.add(new Pt(x, y-1));
          stack.add(new Pt(x, y+1));
        }
      }
    }
    return r;
  }

  BWImage visualizeGrid() {
    step1();
    BWImage im = new BWImage(img);
    for (int y = 0; y < gh; y++)
      for (int x = 0; x < gw; x++) {
        if (grid[y*gw+x]) continue;
        darkenBWImagePart(im, new Rect(x*g, y*g, g, g));
      }
    return im;
  }
}// you still need to implement hasNext() and next()
static abstract class IterableIterator<A> implements Iterator<A>, Iterable<A> {
  public Iterator<A> iterator() {
    return this;
  }
  
  public void remove() {
    unsupportedOperation();
  }
}static class BWImage {
  private int width, height;
  private BWImageSimpleStorage storage;

  // color returned when getPixel is called with a position outside the actual image
  private float borderColor = 0.0f;
  
  // for unstructure()
  BWImage() {}

  // BLACK! [Inefficient...]
  public BWImage(int width, int height) {
    this.width = width;
    this.height = height;
    byte[] bytePixels = new byte[width*height];
    storage = makeStorage(width, height, bytePixels);
  }

  public BWImage(int width, int height, float[] pixels) {
    this.width = width;
    this.height = height;
    byte[] bytePixels = new byte[pixels.length];
    for (int i = 0; i < pixels.length; i++)
      bytePixels[i] = toByte(pixels[i]);
    storage = makeStorage(width, height, bytePixels);
  }

  private BWImageSimpleStorage makeStorage(int width, int height, byte[] bytePixels) {
    return new BWImageSimpleStorage(width, height, bytePixels);
  }

  public BWImage(int width, int height, byte[] pixels) {
    this.height = height;
    this.width = width;
    storage = makeStorage(width, height, pixels);
  }

  public BWImage(BWImage image) {
    width = image.getWidth();
    height = image.getHeight();
    byte[] bytePixels = new byte[width*height];
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
        bytePixels[y*width+x] = image.getByte(x, y);
    storage = makeStorage(width, height, bytePixels);
  }

  public BWImage(RGBImage image) {
    width = image.getWidth();
    height = image.getHeight();
    byte[] result = new byte[height*width];
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++) {
        RGB rgb = image.getRGB(x, y);
        result[y*width+x] = BWImage.toByte(rgb.getBrightness());
      }
    storage = makeStorage(width, height, result);
  }

  /*public BWImage(BufferedImage image) {
    this(new RGBImage(image));
  }*/

  BWImage(BufferedImage image) { try {
 width = image.getWidth();
    height = image.getHeight();
    int[] pixels = new int[width*height];
    byte[] bytePixels = new byte[width*height];
    PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
    if (!pixelGrabber.grabPixels())
      throw fail("Could not grab pixels");
    int n = width*height;
    
    for (int i = 0; i < n; i++) {
      //bytePixels[i] = pixelToByte(pixels[i]);
      int packed = pixels[i];
      /*float r = ((packed >> 16) & 0xFF)/255f;
      float g = ((packed >> 8) & 0xFF)/255f;
      float b = (packed & 0xFF)/255f;
      bytePixels[i] = (byte) iround((r+g+b)/3.0f*255f);*/
      int r = ((packed >> 16) & 0xFF);
      int g = ((packed >> 8) & 0xFF);
      int b = (packed & 0xFF);
      bytePixels[i] = (byte) ((r+g+b+1)/3);
    }
    storage = makeStorage(width, height, bytePixels);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  // TODO: does it exactly match the other method? (asRGB+getBrightness+toByte)
  static byte pixelToByte(int packed) {
    /*int r = (packed >> 16) & 0xFF;
    int g = (packed >> 8) & 0xFF;
    int b = packed & 0xFF;
    ret (byte) ((r+g+b)/3.0f);*/
    float r = ((packed >> 16) & 0xFF)/255f;
    float g = ((packed >> 8) & 0xFF)/255f;
    float b = (packed & 0xFF)/255f;
    return (byte) ((r+g+b)/3.0f*255f);
  }

  public byte getByte(int x, int y) {
    return inRange(x, y) ? storage.getByte(x,y ) : toByte(borderColor);
  }

  public BWImage(int width, int height, float brightness) {
    this.width = width;
    this.height = height;
    byte b = toByte(brightness);
    byte[] pixels = new byte[width*height];
    for (int i = 0; i < pixels.length; i++)
      pixels[i] = b;
    storage = makeStorage(width, height, pixels);
  }

  public double averageBrightness() {
    double sum = 0;
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
        sum += getPixel(x, y);
    return (sum/(double) (height*width));
  }

  public float minimumBrightness() {
    float min = 1;
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
        min = Math.min(min, getPixel(x, y));
    return min;
  }

  public float maximumBrightness() {
    float max = 0;
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
        max = Math.max(max, getPixel(x, y));
    return max;
  }

  float getPixel(int x, int y) {
    return inRange(x, y) ? toFloat(storage.getByte(x,y )) : borderColor;
  }
  
  float getPixel(Pt p) { return getPixel(p.x, p.y); }

  public static byte toByte(float pixel) {
    return (byte) (pixel*255f);
  }

  public static float toFloat(byte pixel) {
    return (((int) pixel) & 255)/255f;
  }

  private boolean inRange(int x, int y) {
    return x >= 0 && x < width && y >= 0 && y < height;
  }

  public int getWidth() { return width; }
  int w() { return width; }

  public int getHeight() { return height; }
  int h() { return height; }

  public RGBImage toRGB() {
    RGB[] rgbs = new RGB[width*height];
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++) {
        float p = getPixel(x, y);
        rgbs[y*width+x] = new RGB(p, p, p);
      }
    return new RGBImage(width, height, rgbs);
  }

  public BWImage clip(int x, int y, int w, int h) {
    return clip(new Rectangle(x, y, w, h));
  }

  private Rectangle fixClipRect(Rectangle r) {
    return r.intersection(new Rectangle(0, 0, width, height));
  }

  BWImage clip(Rect r) {
    return clip(r.getRectangle());
  }
  
  /** this should be multithread-safe */
  public BWImage clip(Rectangle r) {
    r = fixClipRect(r);
    byte[] newPixels = new byte[r.height*r.width];
    for (int y = 0; y < r.height; y++)
      for (int x = 0; x < r.width; x++)
        newPixels[y*r.width+x] = getByte(r.x+x, r.y+y);
    return new BWImage(r.width, r.height, newPixels);
  }

  public void setPixel(int x, int y, float brightness) {
    storage.setByte(x, y, toByte(fixPixel(brightness)));
  }

  public void setByte(int x, int y, int brightness) {
    storage.setByte(x, y, (byte) brightness);
  }

  private float fixPixel(float pixel) {
    return Math.max(0, Math.min(1, pixel));
  }

  public float getBorderColor() {
    return borderColor;
  }

  public void setBorderColor(float borderColor) {
    this.borderColor = borderColor;
  }

  public boolean anyPixelBrighterThan(double threshold) {
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
        if (getPixel(x, y) > threshold)
          return true;
    return false;
  }
  
  BufferedImage getBufferedImage() {
    //ret toRGB().getBufferedImage();
    
    // TYPE_BYTE_GRAY is buggy - see #1015235
    BufferedImage bufferedImage = new BufferedImage(width, height, /*BufferedImage.TYPE_BYTE_GRAY*/BufferedImage.TYPE_INT_RGB);
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++) {
        int b = ((int) getByte(x, y) & 0xFF);
        bufferedImage.setRGB(x, y, b*0x010101);
      }
    return bufferedImage; 
  }
  
  byte[] getBytes() {
    return storage.pixels;
  }
}

static final class BWImageSimpleStorage {
  int width, height;
  byte[] pixels;
  
  // for unstructure()
  BWImageSimpleStorage() {}

  public BWImageSimpleStorage(int width, int height, byte[] pixels) {
    this.width = width;
    this.height = height;
    this.pixels = pixels;
  }

  public void setByte(int x, int y, byte b) {
    pixels[y*width+x] = b;
  }

  public byte getByte(int x, int y) {
    return pixels[y*width+x];
  }
}static interface Producer<A> {
  public A next();
}static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

static class DynamicObject {
  String className; // just the name, without the "main$"
  LinkedHashMap<String,Object> fieldValues = new LinkedHashMap();
  
  DynamicObject() {}
  // className = just the name, without the "main$"
  DynamicObject(String className) {
  this.className = className;}
}static class Scored<A> extends Var<A> {
  float score;
  
  Scored() {}
  Scored(A a, float score) { super(a); this.score = score; }
  
  float score() { return score; }
}static class RGBImage {
  transient BufferedImage bufferedImage;
  File file;
  int width, height;
  int[] pixels;

  RGBImage() {}

  RGBImage(BufferedImage image) {
    this(image, null);
  }

  RGBImage(BufferedImage image, File file) {
    this.file = file;
    bufferedImage = image;
    width = image.getWidth();
    height = image.getHeight();
    pixels = new int[width*height];
    PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
    try {
      if (!pixelGrabber.grabPixels())
        throw new RuntimeException("Could not grab pixels");
      cleanPixels(); // set upper byte to 0
    } catch (InterruptedException e) {
      throw new RuntimeException(e);
    }
  }

  /** We assume it's a file name to load from */
  RGBImage(String file) throws IOException {
    this(new File(file));
  }

  RGBImage(Dimension size, Color color) {
    this(size.width, size.height, color);
  }

  RGBImage(Dimension size, RGB color) {
    this(size.width, size.height, color);
  }

  private void cleanPixels() {
    for (int i = 0; i < pixels.length; i++)
      pixels[i] &= 0xFFFFFF;
  }

  RGBImage(int width, int height, int[] pixels) {
    this.width = width;
    this.height = height;
    this.pixels = pixels;
  }

  RGBImage(int w, int h, RGB[] pixels) {
    this.width = w;
    this.height = h;
    this.pixels = asInts(pixels);
  }

  public static int[] asInts(RGB[] pixels) {
    int[] ints = new int[pixels.length];
    for (int i = 0; i < pixels.length; i++)
      ints[i] = pixels[i] == null ? 0 : pixels[i].getColor().getRGB();
    return ints;
  }

  public RGBImage(int w, int h) {
    this(w, h, Color.black);
  }
  
  RGBImage(int w, int h, RGB rgb) {
    this.width = w;
    this.height = h;
    this.pixels = new int[w*h];
    int col = rgb.asInt();
    if (col != 0)
      for (int i = 0; i < pixels.length; i++)
        pixels[i] = col;
  }

  RGBImage(RGBImage image) {
    this(image.width, image.height, copyPixels(image.pixels));
  }

  RGBImage(int width, int height, Color color) {
    this(width, height, new RGB(color));
  }

  RGBImage(File file) throws IOException {
    this(javax.imageio.ImageIO.read(file));
  }

  private static int[] copyPixels(int[] pixels) {
    int[] copy = new int[pixels.length];
    System.arraycopy(pixels, 0, copy, 0, pixels.length);
    return copy;
  }

  public int getIntPixel(int x, int y) {
    if (inRange(x, y))
      return pixels[y * width + x];
    else
      return 0xFFFFFF;
  }

  public static RGB asRGB(int packed) {
    int r = (packed >> 16) & 0xFF;
    int g = (packed >> 8) & 0xFF;
    int b = packed & 0xFF;
    return new RGB(r / 255f, g / 255f, b / 255f);
  }

  public RGB getRGB(int x, int y) {
    if (inRange(x, y))
      return asRGB(pixels[y * width + x]);
    else
      return new RGB(0xFFFFFF);
  }

  /** alias of getRGB - I kept typing getPixel instead of getRGB all the time, so I finally created it */
  RGB getPixel(int x, int y) {
    return getRGB(x, y);
  }
  
  RGB getPixel(Pt p) { return getPixel(p.x, p.y); }

  int getWidth() { return width; }
  int getHeight() { return height; }
  int w() { return width; }
  int h() { return height; }

  /** Attention: cached, i.e. does not change when image itself changes */
  /** @NotNull */
  public BufferedImage getBufferedImage() {
    if (bufferedImage == null) {
      bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      //bufferedImage.setData(Raster.createRaster(new SampleModel()));
      for (int y = 0; y < height; y++)
        for (int x = 0; x < width; x++)
          bufferedImage.setRGB(x, y, pixels[y*width+x]);
    }
    return bufferedImage;
  }

  RGBImage clip(Rect r) {
    return r == null ? null : clip(r.getRectangle());
  }
  
  RGBImage clip(Rectangle r) {
    r = fixClipRect(r);
    int[] newPixels;
    try {
      newPixels = new int[r.width*r.height];
    } catch (RuntimeException e) {
      System.out.println(r);
      throw e;
    }
    for (int y = 0; y < r.height; y++) {
      System.arraycopy(pixels, (y+r.y)*width+r.x, newPixels, y*r.width, r.width);
    }
    return new RGBImage(r.width, r.height, newPixels);
  }

  private Rectangle fixClipRect(Rectangle r) {
    r = r.intersection(new Rectangle(0, 0, width, height));
    if (r.isEmpty())
      r = new Rectangle(r.x, r.y, 0, 0);
    return r;
  }

  public File getFile() {
    return file;
  }

  /** can now also do GIF (not just JPEG) */
  public static RGBImage load(String fileName) {
    return load(new File(fileName));
  }

  /** can now also do GIF (not just JPEG) */
  public static RGBImage load(File file) {
    try {
      BufferedImage bufferedImage = javax.imageio.ImageIO.read(file);
      return new RGBImage(bufferedImage);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public int getInt(int x, int y) {
    return pixels[y * width + x];
  }

  public void save(File file) throws IOException {
    String name = file.getName().toLowerCase();
    String type;
    if (name.endsWith(".png")) type = "png";
    else if (name.endsWith(".jpg") || name.endsWith(".jpeg")) type = "jpeg";
    else throw new IOException("Unknown image extension: " + name);
    javax.imageio.ImageIO.write(getBufferedImage(), type, file);
  }

  public static RGBImage dummyImage() {
    return new RGBImage(1, 1, new int[] {0xFFFFFF});
  }

  public int[] getPixels() {
    return pixels;
  }

  public void setPixel(int x, int y, RGB rgb) {
    if (x >= 0 && y >= 0 && x < width && y < height)
      pixels[y*width+x] = rgb.asInt();
  }

  public void setPixel(int x, int y, Color color) {
    setPixel(x, y, new RGB(color));
  }

  public void setPixel(int x, int y, int rgb) {
    if (x >= 0 && y >= 0 && x < width && y < height)
      pixels[y*width+x] = rgb;
  }
  
  void setPixel(Pt p, RGB rgb) { setPixel(p.x, p.y, rgb); }
  void setPixel(Pt p, Color color) { setPixel(p.x, p.y, color); }

  public RGBImage copy() {
    return new RGBImage(this);
  }

  public boolean inRange(int x, int y) {
    return x >= 0 && y >= 0 && x < width && y < height;
  }

  public Dimension getSize() {
    return new Dimension(width, height);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    RGBImage rgbImage = (RGBImage) o;

    if (height != rgbImage.height) return false;
    if (width != rgbImage.width) return false;
    if (!Arrays.equals(pixels, rgbImage.pixels)) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = width;
    result = 31 * result + height;
    result = 31 * result + Arrays.hashCode(pixels);
    return result;
  }

  public String getHex(int x, int y) {
    return getPixel(x, y).getHexString();
  }

  public RGBImage clip(int x, int y, int width, int height) {
    return clip(new Rectangle(x, y, width, height));
  }

  public RGBImage clipLine(int y) {
    return clip(0, y, width, 1);
  }

  public int numPixels() {
    return width*height;
  }
}

static class SimpleRecognizer {
  String initial = "\r\n  The images \"9176714c9a935fc91e14595dbb3adddf 35731666e72dd0c9448f616ff3a7464a da9bc5a24bd503e898f69ad43bb9b92e\" are the characters \"yet\".\r\n  The images \"412f9e0f8e177817a4fa285415c5a13f 386b289407599f31e3a7c57c3adb2587 6cd2a2284a5a6fda3a7cad3e3a048671 b0c47c014d665ec5b658f510c258dc47 b273ff598fe6afa04cfed9f9e8fb4109\" are the grouped characters \"[Ob]ject\".\r\n  The images \"175116b749670b7b65707c10c935b42c ddaf2b9c198818c49628387ecc2910ed 3777597e39eb0de16c022293c8c91cc0 fad86bda3f716ef4e7fa9d199f6c4383 35731666e72dd0c9448f616ff3a7464a 03b96c30adaaed5b60cea4ab9bc37263\" are the characters \"images\".\r\n  ";
  
  class GlyphInfo {
    String meaning;
    boolean multi; // multiple meanings seen
  }
  
  // key = md5
  Map<String,GlyphInfo> glyphInfos = new HashMap();
  
  // optional for full similarity search - character image to MD5
  Map<BWImage, String> fullSearchMap;
  
  String unknownCharacter = diamond(); // "\u2666" - diamond suit symbol; used for unknown characters
  
  SimpleRecognizer() {
    load(initial);
  }
  
  void load(String info) {
    Matches m = new Matches();
    for (String s : toLinesFullTrim(info)) {
      if (find3("the images * are the characters *", s, m)) {
        List<String> md5s = splitAtSpace(m.unq(0));
        List<String> characters = eachCharAsString(dropSpaces(m.unq(1)));
        saveMeanings(md5s, characters);
      } else if (find3("the images * are the grouped characters *", s, m)) {
        List<String> md5s = splitAtSpace(m.unq(0));
        List<String> characters = ocr_parseGlyphs(dropSpaces(m.unq(1)));
        saveMeanings(md5s, characters);
      } else if (nempty(javaTokC(s))) {
        print("huh? " + s);
      }
    }
    //print("Have " + n(l(glyphInfos), "glyph info"));
    //psl(glyphInfos);
  }
  
  void saveMeaning(String md5, String meaning) {
    GlyphInfo info = getGlyphInfo(md5);
    if (info.multi) return;
    if (hasDifferent(info.meaning, meaning)) {
      //info.meaning = null;
      info.meaning = meaning;
      info.multi = true;
      //print("multi");
    } else
      info.meaning = meaning;
  }
  
  // gets or creates GlyphInfo
  GlyphInfo getGlyphInfo(String md5) {
    GlyphInfo info = glyphInfos.get(md5);
    if (info == null)
      glyphInfos.put(md5, info = new GlyphInfo());
    return info;
  }
  
  void saveMeanings(List<String> md5s, List<String> characters) {
    if (l(md5s) != l(characters)) { print("huh?"); return; }
    for (int i = 0; i < l(md5s); i++)
      saveMeaning(md5s.get(i), characters.get(i));
  }
  
  // lookup stored recognition of whole image
  Scored<String> recognizeCheat(BWImage img) {
    Scored<GlyphInfo> scored = recognizeGlyph(img, false);
    GlyphInfo info = getVar(scored);
    if (info != null && info.meaning != null) return scored(info.meaning, scored);
    return null;
  }
  
  String recognize(BWImage img) {
    return ocr_joinGroups(recognizeGrouped(img));
  }
  
  Scored<String> recognizeScored(BWImage img) {
    Scored<List<String>> s = recognizeGrouped(img, null);
    return scored(ocr_joinGroups(s.get()), s);
  }
  
  List<String> recognizeGrouped(BWImage img) {
    return getVar(recognizeGrouped(img, null));
  }
  
  Scored<List<String>> recognizeGrouped(BWImage img, List<Rect> clips_out) {
    // TODO: auto-crop here?
    Scored<String> s = recognizeCheat(img);
    if (s != null) {
      if (clips_out != null) clips_out.add(new Rect(0, 0, img.w(), img.h()));
      return scored(ll(ocr_escapeMeaning(s.get())), s); // hmm... how to group? does it matter?
    }
    
    List<String> buf = new ArrayList();
    List<Rect> rects = horizontalAutoSplit2ThenAutoCrop(img);
    if (empty(rects)) return scored(ll(unknownCharacter), 0.5);
    List<Scored> scores = new ArrayList();
    iLoop: for (int i = 0; i < l(rects); i++) {
      Rect r = null;
      for (int j = i; j < l(rects); j++) {
        r = rectUnion(r, rects.get(j));
        BWImage cImg = img.clip(r);
        Scored<GlyphInfo> scored = recognizeGlyph(cImg, false);
        GlyphInfo info = getVar(scored);
        if (info != null && info.meaning != null) {
          buf.add(info.meaning);
          buf.addAll(rep("_", j-i));
          if (clips_out != null) clips_out.addAll(rep(r, j-i+1));
          scores.add(scored);
          i = j;
          continue iLoop;
        }
      }
      r = rects.get(i);
      Scored<GlyphInfo> scored = recognizeGlyph(img.clip(r), true);
      GlyphInfo info = getVar(scored);
      if (info != null && info.meaning != null)
        buf.add(info.meaning);
      else
        buf.add(unknownCharacter);
      if (clips_out != null) clips_out.add(r);
      scores.add(scored);
    }
    return scored(buf, averageScore(scores));
  }
  
  Scored<GlyphInfo> recognizeGlyph(BWImage img, boolean fullSearch) {
    String md5 = md5OfBWImage(img);
    GlyphInfo info = glyphInfos.get(md5);
    if (info != null || !fullSearch || fullSearchMap == null) return fullScored(info);
    Best<String> best = new Best();
    for (BWImage cImg : keys(fullSearchMap)) {
      float sim = bwImageSimilarityResized(img, cImg, (float) best.bestScore());
      best.put(fullSearchMap.get(cImg), sim);
    }
    return !best.has() ? null : scored(glyphInfos.get(best.get()), best.score());
  }
}static class Pair<A, B> implements Comparable<Pair<A, B>> {
  A a;
  B b;

  Pair() {}
  Pair(A a, B b) {
  this.b = b;
  this.a = a;}
  
  public int hashCode() {
    return hashCodeFor(a) + 2*hashCodeFor(b);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof Pair)) return false;
    Pair t = (Pair) o;
    return eq(a, t.a) && eq(b, t.b);
  }
  
  public String toString() {
    return "<" + a + ", " + b + ">";
  }
  
  public int compareTo(Pair<A, B> p) {
    if (p == null) return 1;
    int i = ((Comparable<A>) a).compareTo(p.a);
    if (i != 0) return i;
    return ((Comparable<B>) b).compareTo(p.b);
  }
}

static class Pt {
  int x, y;
  
  Pt() {}
  Pt(Point p) {
    x = p.x;
    y = p.y;
  }
  Pt(int x, int y) {
  this.y = y;
  this.x = x;}
  
  Point getPoint() {
    return new Point(x, y);
  }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
  
  public String toString() {
    return x + ", " + y;
  }
}static class Best<A> {
  A best;
  double score;
  transient Object onChange;
  
  synchronized boolean isNewBest(double score) {
    return best == null || !isNaN(score) && score > this.score;
  }
  
  synchronized double bestScore() {
    return best == null ? Double.NaN : score;
  }
  
  double score() { return bestScore(); }
  double getScore() { return bestScore(); }
  
  boolean put(A a, double score) {
    boolean change = false;
    synchronized(this) {
      if (a != null && isNewBest(score)) {
        best = a;
        this.score = score;
        change = true;
      }
      change = true;
    }
    if (change)
      pcallF(onChange);
    return change;
  }
  
  synchronized A get() { return best; }
  synchronized boolean has() { return best != null; }
  
  synchronized Pair<A, Double> pair() { return main.pair(best, bestScore()); }
  
  synchronized A getIfScoreAbove(double x) { return score() >= x ? best : null; }
}static interface IVar<A> {
  void set(A a);
  A get();
  boolean has();
  void clear();
}static class RGB {
  public float r, g, b; // can't be final cause persistence
  
  RGB() {}
  
  public RGB(float r, float g, float b) {
    this.r = r;
    this.g = g;
    this.b = b;
  }

  public RGB(double r, double g, double b) {
    this.r = (float) r;
    this.g = (float) g;
    this.b = (float) b;
  }

  public RGB(int rgb) {
    this(new Color(rgb));
  }
  
  public RGB(double brightness) {
    this.r = this.g = this.b = max(0f, min(1f, (float) brightness));
  }

  public RGB(Color color) {
    this.r = color.getRed()/255f;
    this.g = color.getGreen()/255f;
    this.b = color.getBlue()/255f;
  }

  public RGB(String hex) {
    r = Integer.parseInt(hex.substring(0, 2), 16)/255f;
    g = Integer.parseInt(hex.substring(2, 4), 16)/255f;
    b = Integer.parseInt(hex.substring(4, 6), 16)/255f;
  }

  public float getComponent(int i) {
    return i == 0 ? r : i == 1 ? g : b;
  }

  public Color getColor() {
    return new Color(r, g, b);
  }

  public static RGB newSafe(float r, float g, float b) {
    return new RGB(Math.max(0, Math.min(1, r)), Math.max(0, Math.min(1, g)), Math.max(0, Math.min(1, b)));
  }

  int asInt() { return getColor().getRGB() & 0xFFFFFF; }
  int getInt() { return getColor().getRGB() & 0xFFFFFF; }

  public float getBrightness() {
    return (r+g+b)/3.0f;
  }

  public String getHexString() {
    return Integer.toHexString(asInt() | 0xFF000000).substring(2).toUpperCase();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof RGB)) return false;

    RGB rgb = (RGB) o;

    if (Float.compare(rgb.b, b) != 0) return false;
    if (Float.compare(rgb.g, g) != 0) return false;
    if (Float.compare(rgb.r, r) != 0) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = (r != +0.0f ? Float.floatToIntBits(r) : 0);
    result = 31 * result + (g != +0.0f ? Float.floatToIntBits(g) : 0);
    result = 31 * result + (b != +0.0f ? Float.floatToIntBits(b) : 0);
    return result;
  }

  public boolean isBlack() {
    return r == 0f && g == 0f && b == 0f;
  }

  public boolean isWhite() {
    return r == 1f && g == 1f && b == 1f;
  }

  public String toString() {
    return getHexString();
  }
}

static float autoCropOfBWImage_blackBG_threshold = 0.2f;

static Rect autoCropOfBWImage_blackBG(BWImage img) {
  return autoCropOfBWImage(img, new Rect(0, 0, img.getWidth(), img.getHeight()));
}

static Rect autoCropOfBWImage_blackBG(BWImage img, Rect r) {
  return autoCropOfBWImage(img, r, autoCropOfBWImage_blackBG_threshold);
}

// r = initial rectangle
static Rect autoCropOfBWImage_blackBG(BWImage img, Rect r, float threshold) {
  int x1 = r.x, y1 = r.y, x2 = r.x2(), y2 = r.y2();

  // left side

  end1:
  while (x1 < x2) {
    for (int y = y1; y < y2; y++)
      if (img.getPixel(x1, y) >= threshold)
        break end1;
    x1++;
  }

  // top side

  end2:
  while (y1 < y2) {
    for (int x = x1; x < x2; x++)
      if (img.getPixel(x, y1) >= threshold)
        break end2;
    y1++;
  }

  // right side

  end3:
  while (x2 > x1) {
    for (int y = y1; y < y2; y++)
      if (img.getPixel(x2-1, y) >= threshold)
        break end3;
    x2--;
  }

  // bottom side

  end4:
  while (y2 > y1) {
    for (int x = x1; x < x2; x++)
      if (img.getPixel(x, y2-1) >= threshold)
        break end4;
    y2--;
  }

  if (x2 <= x1 || y2 <= y1)
    return r;
  else
    return new Rect(x1, y1, x2 - x1, y2 - y1);
}

static UnsupportedOperationException unsupportedOperation() {
  throw new UnsupportedOperationException();
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}

static boolean contains(BitSet bs, int i) {
  return bs != null && bs.get(i);
}
static <A> Scored<A> fullScored(A a) {
  return new Scored(a, 1);
}
static String md5OfBWImage(BWImage img) {
  return ocrMD5OfBWImage(img);
}
static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}

static int hashCodeFor(Object a) {
  return a == null ? 0 : a.hashCode();
}
static String ocr_escapeMeaning(String s) {
  return s.replace("_", "\\_")
    .replace("[", "\\[").replace("]", "\\]")
    .replace("{", "\\{").replace("}", "\\}");
}
static boolean stdEq2(Object a, Object b) {
  if (a == null) return b == null;
  if (b == null) return false;
  if (a.getClass() != b.getClass()) return false;
  for (String field : allFields(a))
    if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
  return true;
}
static String fsi(String id) {
  return formatSnippetID(id);
}
static float bwImageSimilarityResized(BWImage a, BWImage b, float similarityRequired) {
  int aw = a.w(), ah = a.h();
  int bw = b.w(), bh = b.h();
  int wp = max(aw, bw), hp = max(ah, bh);
  float ratio1 = ((float) aw)/ah, ratio2 = ((float) bw)/bh;
  float mismatch = ratio1/ratio2;
  if (mismatch < 1f) mismatch = 1f/mismatch;
  float factor = wp*hp/mismatch; // ratio mismatch punishment (greater mismatch => factor smaller => returned difference bigger)
  float maxError = (1f-similarityRequired)*factor;
  float diff = 0;
  for (int y = 0; y < hp; y++)
    for (int x = 0; x < wp; x++) {
      diff += Math.abs(
        a.getPixel(x*aw/wp, y*ah/hp)-
        b.getPixel(x*bw/wp, y*bh/hp));
      if (diff > maxError) return similarityRequired-0.001f;
    }
  return 1f-diff/factor;
}
// Elements returned are still escaped
// " " is returned as a glyph
static List<String> ocr_parseGlyphs(String s) {
  List<String> l = new ArrayList();
  for (int i = 0; i < l(s); i++)
    if (s.charAt(i) == '\\' && i+1 < l(s)) { // parse escaped character
      l.add(substring(s, i, i+2));
      ++i;
    } else if (s.charAt(i) == '[') { // parse group
      int j = i+1;
      StringBuilder buf = new StringBuilder();
      while (j < l(s) && s.charAt(j) != ']') {
        if (s.charAt(j) == '\\' && j+1 < l(s))
          buf.append(s.charAt(j++));
        buf.append(s.charAt(j++));
      }
      l.add(str(buf));
      i = j;
    } else if (s.charAt(i) == '{') { // parse symbol
      int j = i;
      StringBuilder buf = new StringBuilder();
      while (j < l(s) && s.charAt(j) != '}') {
        if (s.charAt(j) == '\\' && j+1 < l(s))
          buf.append(s.charAt(j++));
        buf.append(s.charAt(j++));
      }
      if (j < l(s))
        buf.append(s.charAt(j));
      l.add(str(buf));
      i = j;
    } else
      l.add(substring(s, i, i+1));
  return l;
}
static Rect rectUnion(Rect a, Rect b) {
  if (a == null) return b;
  if (b == null) return a;
  int x = min(a.x, b.x), y = min(a.y, b.y);
  int x2 = max(a.x+a.w, b.x+b.w), y2 = max(a.y+a.h, b.y+b.h);
  return new Rect(x, y, x2-x, y2-y);
}
static String dropSpaces(String s) {
  return unnull(s).replace(" ", "");
}

static void fill(RGBImage img, String col) {
  RGB rgb = new RGB(col);
  int w = img.getWidth(), h = img.getHeight();
  for (int y = 0; y < h; y++)
    for (int x = 0; x < w; x++)
      img.setPixel(x, y, rgb);
}

static int stdHash2(Object a) {
  if (a == null) return 0;
  return stdHash(a, toStringArray(allFields(a)));
}
static boolean inRange(int x, int n) {
  return x >= 0 && x < n;
}
static <A> Scored<A> scored(A a, float score) {
  return new Scored(a, score);
}

static <A> Scored<A> scored(A a, double score) {
  return new Scored(a, (float) score);
}

static <A> Scored<A> scored(A a, Scored scored) {
  return new Scored(a, getScore(scored));
}
static <A> float getScore(Scored<A> s) {
  return s == null ? 0 : s.score;
}
static void darkenBWImagePart(BWImage img, Rect r) {
  int x2 = r.x2(), y2 = r.y2();
  float factor = 0.8f;
  for (int y = r.y; y < y2; y++)
    for (int x = r.x; x < x2; x++)
      img.setPixel(x, y, img.getPixel(x, y)*factor);
}
static <A> Iterator<A> iterator(Iterable<A> c) {
  return c == null ? emptyIterator() : c.iterator();
}
static List<String> toLinesFullTrim(String s) {
  List<String> l = new ArrayList();
  for (String line : toLines(s)) if (nempty(line = trim(line))) l.add(line);
  return l;
}

static List<String> toLinesFullTrim(File f) {
  List<String> l = new ArrayList();
  for (String line : linesFromFile(f)) if (nempty(line = trim(line))) l.add(line);
  return l;
}

static boolean hasDifferent(Object existing, Object nu) {
  return existing != null && neq(existing, nu);
}
static Rect scaleRect(Rect r, double factorX, double factorY) {
  return new Rect(iround(r.x*factorX), iround(r.y*factorY), iround(r.w*factorX), iround(r.h*factorY));
}

static Rect scaleRect(Rect r, double factor) {
  return scaleRect(r, factor, factor);
}

static <A> A getVar(IVar<A> v) {
  return v == null ? null : v.get();
}
static boolean isNaN(double d) {
  return Double.isNaN(d);
}
static String ocr_joinGroups(List<String> l) {
  StringBuilder buf = new StringBuilder();
  for (String s : dropElement(l, "_"))
    buf.append(s.startsWith("[") && s.endsWith("]") ? substring(s, 1, l(s)-1) : s);
  return str(buf);
}
static float averageScore(List<Scored> scores) {
  if (empty(scores)) return 0;
  double sum = 0;
  for (Scored s : scores)
    sum += getScore(s);
  return (float) (sum/l(scores));
}
static List<String> eachCharAsString(String s) {
  List<String> l = new ArrayList();
  for (int i = 0; i < l(s); i++) l.add(substring(s, i, i+1));
  return l;
}
static int asInt(Object o) {
  return toInt(o);
}
static String diamond() {
  return "\u2666"; // diamond suit symbol
}


static Set<String> allFields(Object o) {
  TreeSet<String> fields = new TreeSet();
  Class _c = _getClass(o);
  do {
    for (Field f : _c.getDeclaredFields())
      fields.add(f.getName());
    _c = _c.getSuperclass();
  } while (_c != null);
  return fields;
}
static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  n = Math.max(n, 0);
  List<A> l = new ArrayList(n);
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}
static int stdHash(Object a, String... fields) {
  if (a == null) return 0;
  int hash = getClassName(a).hashCode();
  for (String field : fields)
    hash = hash*2+hashCode(getOpt(a, field));
  return hash;
}
static <A> List<A> dropElement(Collection<A> c, final A element) {
  return filter(c , new F1<A, Boolean>() { Boolean get(A a) { try { return  neq(a, element) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "neq(a, element)"; }});
}


static int hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}
static List filter(Iterable c, Object pred) {
  
  List x = new ArrayList();
  if (c != null) for (Object o : c)
    if (isTrue(callF(pred, o)))
      x.add(o);
  return x;
}

static List filter(Object pred, Iterable c) {
  return filter(c, pred);
}

static <A, B extends A> List filter(Iterable<B> c, F1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o).booleanValue())
      x.add(o);
  return x;
}

static <A, B extends A> List filter(F1<A, Boolean> pred, Iterable<B> c) {
  return filter(c, pred);
}


}




class m1015275{}