
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import processing.core.*;

public class main {

  public static void main(final String[] args) throws Exception {
    pMain(It.class);
  }

  public static class It extends PApplet {

    public int W = 1350;

    public int H = 690;

    public float Pitch;

    public float Bank;

    public float Azimuth;

    public float ArtificialHoizonMagnificationFactor = 0.7f;

    public float CompassMagnificationFactor = 0.85f;

    public float SpanAngle = 120;

    public int NumberOfScaleMajorDivisions;

    public int NumberOfScaleMinorDivisions;

    public PVector v1, v2;

    public void settings() {
      size(W, H);
    }

    public void setup() {
      rectMode(CENTER);
      smooth();
    }

    public void draw() {
      background(0);
      translate(W / 4, H / 2.1f);
      MakeAnglesDependentOnMouse();
      Horizon();
      rotate(-Bank);
      PitchScale();
      Axis();
      rotate(Bank);
      Borders();
      Plane();
      ShowAngles();
      Compass();
      ShowAzimuth();
    }

    public void MakeAnglesDependentOnMouse() {
      v2 = new PVector();
      v1 = new PVector(W / 2, H / 2);
      v2.x = mouseX;
      v2.y = mouseY;
      Bank = PVector.angleBetween(v1, v2);
      Pitch = mouseY - H / 2;
      Azimuth = (180 / PI * 10 * Bank) % 360;
    }

    public void Horizon() {
      scale(ArtificialHoizonMagnificationFactor);
      noStroke();
      fill(0, 180, 255);
      rect(0, -100, 900, 1000);
      fill(95, 55, 40);
      rotate(-Bank);
      rect(0, 400 + Pitch, 900, 800);
      rotate(Bank);
      rotate(-PI - PI / 6);
      SpanAngle = 120;
      NumberOfScaleMajorDivisions = 12;
      NumberOfScaleMinorDivisions = 24;
      CircularScale();
      rotate(PI + PI / 6);
      rotate(-PI / 6);
      CircularScale();
      rotate(PI / 6);
    }

    public void ShowAzimuth() {
      fill(50);
      noStroke();
      rect(20, 470, 440, 50);
      int Azimuth1 = round(Azimuth);
      textAlign(CORNER);
      textSize(35);
      fill(255);
      text("Azimuth:  " + Azimuth1 + " Deg", 80, 477, 500, 60);
    }

    public void Compass() {
      translate(2 * W / 3, 0);
      scale(CompassMagnificationFactor);
      noFill();
      stroke(100);
      strokeWeight(80);
      ellipse(0, 0, 750, 750);
      strokeWeight(50);
      stroke(50);
      fill(0, 0, 40);
      ellipse(0, 0, 610, 610);
      for (int k = 255; k > 0; k = k - 5) {
        noStroke();
        fill(0, 0, 255 - k);
        ellipse(0, 0, 2 * k, 2 * k);
      }
      strokeWeight(20);
      NumberOfScaleMajorDivisions = 18;
      NumberOfScaleMinorDivisions = 36;
      SpanAngle = 180;
      CircularScale();
      rotate(PI);
      SpanAngle = 180;
      CircularScale();
      rotate(-PI);
      fill(255);
      textSize(60);
      textAlign(CENTER);
      text("W", -375, 0, 100, 80);
      text("E", 370, 0, 100, 80);
      text("N", 0, -365, 100, 80);
      text("S", 0, 375, 100, 80);
      textSize(30);
      text("COMPASS-01", 0, -130, 500, 80);
      rotate(PI / 4);
      textSize(40);
      text("NW", -370, 0, 100, 50);
      text("SE", 365, 0, 100, 50);
      text("NE", 0, -355, 100, 50);
      text("SW", 0, 365, 100, 50);
      rotate(-PI / 4);
      CompassPointer();
    }

    public void CompassPointer() {
      rotate(PI + radians(Azimuth));
      stroke(0);
      strokeWeight(4);
      fill(100, 255, 100);
      triangle(-20, -210, 20, -210, 0, 270);
      triangle(-15, 210, 15, 210, 0, 270);
      ellipse(0, 0, 45, 45);
      fill(0, 0, 50);
      noStroke();
      ellipse(0, 0, 10, 10);
      triangle(-20, -213, 20, -213, 0, -190);
      triangle(-15, -215, 15, -215, 0, -200);
      rotate(-PI - radians(Azimuth));
    }

    public void Plane() {
      fill(0);
      strokeWeight(1);
      stroke(0, 255, 0);
      triangle(-20, 0, 20, 0, 0, 25);
      rect(110, 0, 140, 20);
      rect(-110, 0, 140, 20);
    }

    public void CircularScale() {
      float GaugeWidth = 800;
      textSize(GaugeWidth / 30);
      float StrokeWidth = 1;
      float an;
      float DivxPhasorCloser;
      float DivxPhasorDistal;
      float DivyPhasorCloser;
      float DivyPhasorDistal;
      strokeWeight(2 * StrokeWidth);
      stroke(255);
      float DivCloserPhasorLenght = GaugeWidth / 2 - GaugeWidth / 9 - StrokeWidth;
      float DivDistalPhasorLenght = GaugeWidth / 2 - GaugeWidth / 7.5f - StrokeWidth;
      for (int Division = 0; Division < NumberOfScaleMinorDivisions + 1; Division++) {
        an = SpanAngle / 2 + Division * SpanAngle / NumberOfScaleMinorDivisions;
        DivxPhasorCloser = DivCloserPhasorLenght * cos(radians(an));
        DivxPhasorDistal = DivDistalPhasorLenght * cos(radians(an));
        DivyPhasorCloser = DivCloserPhasorLenght * sin(radians(an));
        DivyPhasorDistal = DivDistalPhasorLenght * sin(radians(an));
        line(DivxPhasorCloser, DivyPhasorCloser, DivxPhasorDistal, DivyPhasorDistal);
      }
      DivCloserPhasorLenght = GaugeWidth / 2 - GaugeWidth / 10 - StrokeWidth;
      DivDistalPhasorLenght = GaugeWidth / 2 - GaugeWidth / 7.4f - StrokeWidth;
      for (int Division = 0; Division < NumberOfScaleMajorDivisions + 1; Division++) {
        an = SpanAngle / 2 + Division * SpanAngle / NumberOfScaleMajorDivisions;
        DivxPhasorCloser = DivCloserPhasorLenght * cos(radians(an));
        DivxPhasorDistal = DivDistalPhasorLenght * cos(radians(an));
        DivyPhasorCloser = DivCloserPhasorLenght * sin(radians(an));
        DivyPhasorDistal = DivDistalPhasorLenght * sin(radians(an));
        if (Division == NumberOfScaleMajorDivisions / 2 | Division == 0 | Division == NumberOfScaleMajorDivisions) {
          strokeWeight(15);
          stroke(0);
          line(DivxPhasorCloser, DivyPhasorCloser, DivxPhasorDistal, DivyPhasorDistal);
          strokeWeight(8);
          stroke(100, 255, 100);
          line(DivxPhasorCloser, DivyPhasorCloser, DivxPhasorDistal, DivyPhasorDistal);
        } else {
          strokeWeight(3);
          stroke(255);
          line(DivxPhasorCloser, DivyPhasorCloser, DivxPhasorDistal, DivyPhasorDistal);
        }
      }
    }

    public void Axis() {
      stroke(255, 0, 0);
      strokeWeight(3);
      line(-115, 0, 115, 0);
      line(0, 280, 0, -280);
      fill(100, 255, 100);
      stroke(0);
      triangle(0, -285, -10, -255, 10, -255);
      triangle(0, 285, -10, 255, 10, 255);
    }

    public void ShowAngles() {
      textSize(30);
      fill(50);
      noStroke();
      rect(-150, 400, 280, 40);
      rect(150, 400, 280, 40);
      fill(255);
      Pitch = Pitch / 5;
      int Pitch1 = round(Pitch);
      Bank = Bank * 180 / PI;
      int Bank1 = round(Bank);
      text("Pitch:  " + Pitch1 + " Deg", -20, 411, 500, 60);
      text("Bank:  " + Bank1 + " Deg", 280, 411, 500, 60);
    }

    public void Borders() {
      noFill();
      stroke(0);
      strokeWeight(400);
      rect(0, 0, 1100, 1100);
      strokeWeight(200);
      ellipse(0, 0, 1000, 1000);
      fill(0);
      noStroke();
      rect(4 * W / 5, 0, W, 2 * H);
      rect(-4 * W / 5, 0, W, 2 * H);
    }

    public void PitchScale() {
      stroke(255);
      fill(255);
      strokeWeight(3);
      textSize(24);
      textAlign(CENTER);
      for (int i = -4; i < 5; i++) {
        if ((i == 0) == false) {
          line(110, 50 * i, -110, 50 * i);
        }
        text("" + i * 10, 140, 50 * i, 100, 30);
        text("" + i * 10, -140, 50 * i, 100, 30);
      }
      textAlign(CORNER);
      strokeWeight(2);
      for (int i = -9; i < 10; i++) {
        if ((i == 0) == false) {
          line(25, 25 * i, -25, 25 * i);
        }
      }
    }
  }

  public static Rect rect(int x, int y, int w, int h) {
    return new Rect(x, y, w, h);
  }

  public static long round(double d) {
    return Math.round(d);
  }

  public static double cos(double x) {
    return Math.cos(x);
  }

  public static void pMain(Class<? extends PApplet> c) {
    fixContextClassLoader();
    PApplet.main(c.getName());
  }

  public static void pMain() {
    pMain(mc());
  }

  public static Map<Thread, Boolean> _registerThread_threads = newWeakHashMap();

  public static Thread _registerThread(Thread t) {
    _registerThread_threads.put(t, true);
    return t;
  }

  public static void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  public static double sin(double x) {
    return Math.sin(x);
  }

  public static Class mc() {
    return main.class;
  }

  public static <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  public static void fixContextClassLoader() {
    Thread.currentThread().setContextClassLoader(myClassLoader());
  }

  public static Map synchroMap() {
    return synchroHashMap();
  }

  public static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  public static ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  public static List _registerWeakMap_preList;

  public static <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  public static void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  public static Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void printException(Throwable e) {
    printStackTrace(e);
  }

  public static Object call(Object o) {
    return callFunction(o);
  }

  public static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  public static Object call(Object o, String method, Object... args) {
    try {
      if (o instanceof Class) {
        Method m = call_findStaticMethod((Class) o, method, args, false);
        m.setAccessible(true);
        return invokeMethod(m, null, args);
      } else {
        Method m = call_findMethod(o, method, args, false);
        m.setAccessible(true);
        return invokeMethod(m, o, args);
      }
    } catch (Exception e) {
      throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
    }
  }

  public static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (!m.getName().equals(method)) {
          if (debug)
            System.out.println("Method name mismatch: " + method);
          continue;
        }
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
  }

  public static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (m.getName().equals(method) && call_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
  }

  public static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static volatile StringBuffer local_log = new StringBuffer();

  public static volatile StringBuffer print_log = local_log;

  public static volatile int print_log_max = 1024 * 1024;

  public static volatile int local_log_max = 100 * 1024;

  public static boolean print_silent;

  public static Object print_byThread_lock = new Object();

  public static volatile ThreadLocal<Object> print_byThread;

  public static volatile Object print_allThreads;

  public static void print() {
    print("");
  }

  public static <A> A print(A o) {
    ping();
    if (print_silent)
      return o;
    String s = String.valueOf(o) + "\n";
    print_noNewLine(s);
    return o;
  }

  public static void print_noNewLine(String s) {
    Object f = print_byThread == null ? null : print_byThread.get();
    if (f == null)
      f = print_allThreads;
    if (f != null)
      if (isFalse(f instanceof F1 ? ((F1) f).get(s) : callF(f, s)))
        return;
    print_raw(s);
  }

  public static void print_raw(String s) {
    s = fixNewLines(s);
    StringBuffer loc = local_log;
    StringBuffer buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
  }

  public static void print(long l) {
    print(String.valueOf(l));
  }

  public static void print(char c) {
    print(String.valueOf(c));
  }

  public static void print_append(StringBuffer buf, String s, int max) {
    synchronized (buf) {
      buf.append(s);
      max /= 2;
      if (buf.length() > max)
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
    }
  }

  public static Class javax() {
    return getJavaX();
  }

  public static <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  public static <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  public static Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  public static <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  public static <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  public static String fixNewLines(String s) {
    return s.replace("\r\n", "\n").replace("\r", "\n");
  }

  public static Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static volatile boolean ping_pauseAll;

  public static int ping_sleep = 100;

  public static volatile boolean ping_anyActions;

  public static Map<Thread, Object> ping_actions = newWeakHashMap();

  public static boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl();
    return true;
  }

  public static boolean ping_impl() {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        Object action;
        synchronized (ping_actions) {
          action = ping_actions.get(currentThread());
          if (action instanceof Runnable)
            ping_actions.remove(currentThread());
          if (ping_actions.isEmpty())
            ping_anyActions = false;
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();

  public static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }

  public static Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMC((String) f, args);
      if (f instanceof Runnable) {
        ((Runnable) f).run();
        return null;
      }
      if (f == null)
        return null;
      Class c = f.getClass();
      ArrayList<Method> methods;
      synchronized (callF_cache) {
        methods = callF_cache.get(c);
        if (methods == null)
          methods = callF_makeCache(c);
      }
      int n = l(methods);
      if (n == 0)
        throw fail("No get method in " + getClassName(c));
      if (n == 1)
        return invokeMethod(methods.get(0), f, args);
      for (int i = 0; i < n; i++) {
        Method m = methods.get(i);
        if (call_checkArgs(m, args, false))
          return invokeMethod(m, f, args);
      }
      throw fail("No matching get method in " + getClassName(c));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  public static Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  public static void assertTrue(Object o) {
    if (!(eq(o, true)))
      throw fail(str(o));
  }

  public static boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  public static boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  public static RuntimeException rethrow(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  public static Class __javax;

  public static Class getJavaX() {
    return __javax;
  }

  public static Throwable printStackTrace(Throwable e) {
    print(getStackTrace(e));
    return e;
  }

  public static void printStackTrace() {
    printStackTrace(new Throwable());
  }

  public static void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  public static String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  public static boolean isFalse(Object o) {
    return eq(false, o);
  }

  public static Object invokeMethod(Method m, Object o, Object... args) {
    try {
      try {
        return m.invoke(o, args);
      } catch (InvocationTargetException e) {
        throw rethrow(getExceptionCause(e));
      } catch (IllegalArgumentException e) {
        throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static AtomicLong _handleError_nonVMErrors = new AtomicLong();

  public static AtomicLong _handleError_vmErrors = new AtomicLong();

  public static AtomicLong _handleError_outOfMemoryErrors = new AtomicLong();

  public static volatile long _handleError_lastOutOfMemoryError;

  public static volatile Error _handleError_lastHardError;

  public static void _handleError(Error e) {
    if (!(e instanceof VirtualMachineError)) {
      incAtomicLong(_handleError_nonVMErrors);
      return;
    }
    print("\nHARD ERROR\n");
    printStackTrace2(e);
    print("\nHARD ERROR\n");
    _handleError_lastHardError = e;
    incAtomicLong(_handleError_vmErrors);
    if (e instanceof OutOfMemoryError) {
      incAtomicLong(_handleError_outOfMemoryErrors);
      _handleError_lastOutOfMemoryError = sysNow();
    }
  }

  public static Throwable getExceptionCause(Throwable e) {
    Throwable c = e.getCause();
    return c != null ? c : e;
  }

  public static String joinWithSpace(Collection<String> c) {
    return join(" ", c);
  }

  public static String joinWithSpace(String... c) {
    return join(" ", c);
  }

  public static List<String> classNames(Collection l) {
    return getClassNames(l);
  }

  public static List<String> classNames(Object[] l) {
    return getClassNames(Arrays.asList(l));
  }

  public static HashMap<String, List<Method>> callMC_cache = new HashMap();

  public static String callMC_key;

  public static Method callMC_value;

  public static Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  public static Object callMC(String method, Object... args) {
    try {
      Method me;
      if (callMC_cache == null)
        callMC_cache = new HashMap();
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        try {
          return invokeMethod(me, null, args);
        } catch (IllegalArgumentException e) {
          throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
        }
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return invokeMethod(me, null, args);
      }
      throw fail("No method called " + method + " with matching arguments found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  public static String getStackTrace(Throwable throwable) {
    lastException(throwable);
    return getStackTrace_noRecord(throwable);
  }

  public static String getStackTrace_noRecord(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  public static String getStackTrace() {
    return getStackTrace_noRecord(new Throwable());
  }

  public static boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  public static boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  public static Thread currentThread() {
    return Thread.currentThread();
  }

  public static boolean eq(Object a, Object b) {
    return a == null ? b == null : a == b || a.equals(b);
  }

  public static String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  public static String str(char[] c) {
    return new String(c);
  }

  public static RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  public static RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  public static RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  public static RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  public static RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  public static String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  public static int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  public static int l(Map m) {
    return m == null ? 0 : m.size();
  }

  public static int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  public static long l(File f) {
    return f == null ? 0 : f.length();
  }

  public static int l(Object o) {
    return o == null ? 0 : o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : o instanceof Collection ? l((Collection) o) : (Integer) call(o, "size");
  }

  public static volatile Throwable lastException_lastException;

  public static Throwable lastException() {
    return lastException_lastException;
  }

  public static void lastException(Throwable e) {
    lastException_lastException = e;
  }

  public static Boolean isHeadless_cache;

  public static boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static RuntimeException asRuntimeException(Throwable t) {
    if (t instanceof Error)
      _handleError((Error) t);
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  public static String join(String glue, Iterable<String> strings) {
    if (strings == null)
      return "";
    StringBuilder buf = new StringBuilder();
    Iterator<String> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(Iterable<String> strings) {
    return join("", strings);
  }

  public static String join(Iterable<String> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  public static String join(String glue, Pair p) {
    return p == null ? "" : str(p.a) + glue + str(p.b);
  }

  public static long sysNow() {
    return System.nanoTime() / 1000000;
  }

  public static String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  public static String hideCredentials(String url) {
    return url.replaceAll("([&?])_pass=[^&\\s\"]*", "$1_pass=<hidden>");
  }

  public static String hideCredentials(Object o) {
    return hideCredentials(str(o));
  }

  public static void incAtomicLong(AtomicLong l) {
    l.incrementAndGet();
  }

  public static List<String> getClassNames(Collection l) {
    List<String> out = new ArrayList();
    if (l != null)
      for (Object o : l) out.add(o == null ? null : getClassName(o));
    return out;
  }

  public static Throwable printStackTrace2(Throwable e) {
    print(getStackTrace2(e));
    return e;
  }

  public static void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  public static void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  public static int isAndroid_flag;

  public static boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  public static String getStackTrace2(Throwable throwable) {
    return hideCredentials(getStackTrace(throwable) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(getInnerException(throwable)))) + "\n");
  }

  public static String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  public static Throwable getInnerException(Throwable e) {
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  public static String substring(String s, int x) {
    return substring(s, x, l(s));
  }

  public static String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x >= s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.substring(x, y);
  }

  public static boolean startsWith(String a, String b) {
    return a != null && a.startsWith(b);
  }

  public static boolean startsWith(String a, char c) {
    return nempty(a) && a.charAt(0) == c;
  }

  public static boolean startsWith(List a, List b) {
    if (a == null || l(b) > l(a))
      return false;
    for (int i = 0; i < l(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  public static boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  public static boolean nempty(Collection c) {
    return !isEmpty(c);
  }

  public static boolean nempty(CharSequence s) {
    return !isEmpty(s);
  }

  public static boolean nempty(Object[] o) {
    return !isEmpty(o);
  }

  public static boolean nempty(Map m) {
    return !isEmpty(m);
  }

  public static boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  public static boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  public static boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  public static boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  public static boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  public static class Rect {

    public int x, y, w, h;

    public Rect() {
    }

    public Rect(Rectangle r) {
      x = r.x;
      y = r.y;
      w = r.width;
      h = r.height;
    }

    public Rect(int x, int y, int w, int h) {
      this.h = h;
      this.w = w;
      this.y = y;
      this.x = x;
    }

    public Rectangle getRectangle() {
      return new Rectangle(x, y, w, h);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + "," + y + " / " + w + "," + h;
    }

    public int x2() {
      return x + w;
    }

    public int y2() {
      return y + h;
    }

    public boolean contains(Pt p) {
      return contains(p.x, p.y);
    }

    public boolean contains(int _x, int _y) {
      return _x >= x && _y >= y && _x < x + w && _y < y + h;
    }

    public boolean empty() {
      return w <= 0 || h <= 0;
    }
  }

  public abstract static class F1<A, B> {

    public abstract B get(A a);
  }

  public static class Pt {

    public int x, y;

    public Pt() {
    }

    public Pt(Point p) {
      x = p.x;
      y = p.y;
    }

    public Pt(int x, int y) {
      this.y = y;
      this.x = x;
    }

    public Point getPoint() {
      return new Point(x, y);
    }

    public boolean equals(Object o) {
      return stdEq2(this, o);
    }

    public int hashCode() {
      return stdHash2(this);
    }

    public String toString() {
      return x + ", " + y;
    }
  }

  public static boolean stdEq2(Object a, Object b) {
    if (a == null)
      return b == null;
    if (b == null)
      return false;
    if (a.getClass() != b.getClass())
      return false;
    for (String field : allFields(a)) if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
    return true;
  }

  public static boolean contains(Collection c, Object o) {
    return c != null && c.contains(o);
  }

  public static boolean contains(Object[] x, Object o) {
    if (x != null)
      for (Object a : x) if (eq(a, o))
        return true;
    return false;
  }

  public static boolean contains(String s, char c) {
    return s != null && s.indexOf(c) >= 0;
  }

  public static boolean contains(String s, String b) {
    return s != null && s.indexOf(b) >= 0;
  }

  public static int stdHash2(Object a) {
    if (a == null)
      return 0;
    return stdHash(a, toStringArray(allFields(a)));
  }

  public static <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  public static <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  public static boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  public static Object get(Object o, String field) {
    try {
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        f.setAccessible(true);
        return f.get(o);
      }
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  public static Object get_raw(Object o, String field) {
    try {
      Field f = get_findField(o.getClass(), field);
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  public static Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  public static Set<String> allFields(Object o) {
    TreeSet<String> fields = new TreeSet();
    Class _c = _getClass(o);
    do {
      for (Field f : _c.getDeclaredFields()) fields.add(f.getName());
      _c = _c.getSuperclass();
    } while (_c != null);
    return fields;
  }

  public static int stdHash(Object a, String... fields) {
    if (a == null)
      return 0;
    int hash = getClassName(a).hashCode();
    for (String field : fields) hash = hash * 2 + hashCode(getOpt(a, field));
    return hash;
  }

  public static String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  public static String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  public static Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static class getOpt_Map extends WeakHashMap {

    public getOpt_Map() {
      if (getOpt_special == null)
        getOpt_special = new HashMap();
      clear();
    }

    public void clear() {
      super.clear();
      put(Class.class, getOpt_special);
      put(String.class, getOpt_special);
    }
  }

  public static final Map<Class, HashMap<String, Field>> getOpt_cache = _registerDangerousWeakMap(synchroMap(new getOpt_Map()));

  public static HashMap getOpt_special;

  public static Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) {
          f.setAccessible(true);
          String name = f.getName();
          if (!map.containsKey(name))
            map.put(name, f);
        }
        _c = _c.getSuperclass();
      } while (_c != null);
    }
    getOpt_cache.put(c, map);
    return map;
  }

  public static int hashCode(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static <A, B> void put(Map<A, B> map, A a, B b) {
    if (map != null)
      map.put(a, b);
  }

  public static boolean isSubtypeOf(Class a, Class b) {
    return b.isAssignableFrom(a);
  }

  public static List<Pair> _registerDangerousWeakMap_preList;

  public static <A> A _registerDangerousWeakMap(A map) {
    return _registerDangerousWeakMap(map, null);
  }

  public static <A> A _registerDangerousWeakMap(A map, Object init) {
    callF(init, map);
    if (init instanceof String) {
      final String f = (String) (init);
      init = new VF1<Map>() {

        public void get(Map map) {
          try {
            callMC(f, map);
          } catch (Exception __e) {
            throw rethrow(__e);
          }
        }

        public String toString() {
          return "callMC(f, map)";
        }
      };
    }
    if (javax() == null) {
      if (_registerDangerousWeakMap_preList == null)
        _registerDangerousWeakMap_preList = synchroList();
      _registerDangerousWeakMap_preList.add(pair(map, init));
      return map;
    }
    try {
      call(javax(), "_registerDangerousWeakMap", map, init);
    } catch (Throwable e) {
      printException(e);
      upgradeJavaXAndRestart();
    }
    return map;
  }

  public static void _onLoad_registerDangerousWeakMap() {
    assertNotNull(javax());
    if (_registerDangerousWeakMap_preList == null)
      return;
    for (Pair p : _registerDangerousWeakMap_preList) _registerDangerousWeakMap(p.a, p.b);
    _registerDangerousWeakMap_preList = null;
  }

  public static void clear(Collection c) {
    if (c != null)
      c.clear();
  }

  public static void upgradeJavaXAndRestart() {
    run("#1001639");
    restart();
    sleep();
  }

  public static <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  public static <A> Pair<A, A> pair(A a) {
    return new Pair(a, a);
  }

  public static Class run(String progID, String... args) {
    Class main = hotwire(progID);
    callMain(main, args);
    return main;
  }

  public static volatile boolean sleep_noSleep;

  public static void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void restart() {
    Object j = getJavaX();
    call(j, "cleanRestart", get(j, "fullArgs"));
  }

  public static <A> A callMain(A c, String... args) {
    callOpt(c, "main", new Object[] { args });
    return c;
  }

  public static void callMain() {
    callMain(mc());
  }

  public static Object sleepQuietly_monitor = new Object();

  public static void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Class<?> hotwire(String src) {
    assertFalse(_inCore());
    Class j = getJavaX();
    if (isAndroid()) {
      synchronized (j) {
        List<File> libraries = new ArrayList<File>();
        File srcDir = (File) call(j, "transpileMain", src, libraries);
        if (srcDir == null)
          throw fail("transpileMain returned null (src=" + quote(src) + ")");
        Object androidContext = get(j, "androidContext");
        return (Class) call(j, "loadx2android", srcDir, src);
      }
    } else {
      Class c = (Class) (call(j, "hotwire", src));
      hotwire_copyOver(c);
      return c;
    }
  }

  public static String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  public static String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  public static void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else
        out.append(c);
    }
    out.append('"');
  }

  public static boolean _inCore() {
    return false;
  }

  public static void hotwire_copyOver(Class c) {
    synchronized (StringBuffer.class) {
      for (String field : litlist("print_log", "print_silent", "androidContext")) {
        Object o = getOpt(mc(), field);
        if (o != null)
          setOpt(c, field, o);
      }
      Object mainBot = getMainBot();
      if (mainBot != null)
        setOpt(c, "mainBot", mainBot);
      setOpt(c, "creator_class", new WeakReference(mc()));
    }
  }

  public static Object callOpt(Object o) {
    if (o == null)
      return null;
    return callF(o);
  }

  public static Object callOpt(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Method m = callOpt_findStaticMethod((Class) o, method, args, false);
        if (m == null)
          return null;
        m.setAccessible(true);
        return invokeMethod(m, null, args);
      } else {
        Method m = callOpt_findMethod(o, method, args, false);
        if (m == null)
          return null;
        m.setAccessible(true);
        return invokeMethod(m, o, args);
      }
    } catch (Exception e) {
      throw rethrow(e);
    }
  }

  public static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (!m.getName().equals(method)) {
          if (debug)
            System.out.println("Method name mismatch: " + method);
          continue;
        }
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static void assertFalse(Object o) {
    if (!(eq(o, false)))
      throw fail(str(o));
  }

  public static boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  public static boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  public static Object mainBot;

  public static Object getMainBot() {
    return mainBot;
  }

  public static <A> ArrayList<A> litlist(A... a) {
    ArrayList l = new ArrayList(a.length);
    for (A x : a) l.add(x);
    return l;
  }

  public static Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  public static void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null)
        smartSet(f, o, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static void setOpt_raw(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      if (o instanceof Class)
        setOpt_raw((Class) o, field, value);
      else {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null)
          smartSet(f, o, value);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void setOpt_raw(Class c, String field, Object value) {
    try {
      if (c == null)
        return;
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static void smartSet(Field f, Object o, Object value) throws Exception {
    f.setAccessible(true);
    if (f.getType() == int.class && value instanceof Long)
      value = ((Long) value).intValue();
    try {
      f.set(o, value);
    } catch (Exception e) {
      throw e;
    }
  }

  public abstract static class VF1<A> {

    public abstract void get(A a);
  }

  public static class Pair<A, B> implements Comparable<Pair<A, B>> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }

    public int compareTo(Pair<A, B> p) {
      if (p == null)
        return 1;
      int i = ((Comparable<A>) a).compareTo(p.a);
      if (i != 0)
        return i;
      return ((Comparable<B>) b).compareTo(p.b);
    }
  }

  public static int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }
}

