import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import java.util.function.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.imageio.*;
import java.math.*;


import java.text.SimpleDateFormat;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.awt.geom.*;
import java.text.*;
import java.util.TimeZone;
import javax.imageio.metadata.*;
import javax.imageio.stream.*;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import static x30_pkg.x30_util.DynamicObject;
import java.nio.file.Path;
import java.nio.file.Files;

class main {


static class AIList extends Concept {
  static final String _fieldOrder = "name text botFlag mighty modified status textMD5 lines";
  String name;
  String text;
  boolean botFlag, mighty;
  long modified;
  String status;
  transient String textMD5;
  transient int lines = -1;
  
  boolean isPublicRead() { return cic(status, "PUBLIC READ"); }
}
static ConceptFieldIndexCI<AIList> nameIndex;
static volatile long totalChars = -1;

static class Session extends Concept {
  String cookie;
  String mech_filter;
}

public static void main(final String[] args) throws Exception {
  dbSaveEvery(60);
  dbIndexing(AIList.class, "name");
  nameIndex = indexConceptFieldCI(AIList.class, "name");
  { startThread(new Runnable() {  public void run() { try {  mech_guessLanguage(""); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "mech_guessLanguage(\"\");"; }}); } // preload
  calcOnConceptChanges(10000, new Runnable() {  public void run() { try {  calcTotalSize(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "calcTotalSize();"; }}, true);
  addConceptIndex(new IConceptIndex() {
    public void update(Concept c) {
      try { if (c instanceof AIList) sendToUpdatesBot("mechListChange", ((AIList) c).name); } catch (Throwable __e) { printStackTrace(__e); }
    }
    public void remove(Concept c) {
      try { if (c instanceof AIList) sendToUpdatesBot("removeMechList", ((AIList) c).name); } catch (Throwable __e) { printStackTrace(__e); }
    }
  });
  updateListNamesList();
}

static Object html(String uri, final Map<String, String> params) { try {

   AutoCloseable __13 = countDispatch("html"); try {
  Object response;
  Matches m = new Matches();
  
  String cookie = cookieFromUser();
  String filter = params.get("mech_filter");
  print("cookie=" + cookie + ", filter=" + filter + ", dialogID=" + getDialogID());
  Session session = empty(cookie) ? null : uniq(Session.class, "cookie", cookie);
  if (session != null && filter != null) {
    cset(session, "mech_filter" , filter);
    return hrefresh(rawSelfLink());
  }

  boolean authed = webAuthed(params);
  
  if (eq(uri, "/list-count")) return serveText(countConcepts(AIList.class));
  if ((response = serveListText(uri, params, authed)) != null) return response;
  
  // Append API
  if (swic(uri, "/bot-list-append/", m)) {
    params.put("name" , urldecode(m.rest()));
    uri = "/bot-list-append";
  }

  if (eq(uri, "/bot-list-append")) {
    String mode = params.get("mode");
    Lock __2 = dbLock(); lock(__2); try {
    String name = params.get("name"), text = params.get("text");
    if (!authed)
      name = "Unauthorized Appends | " + name;
    AIList l = getList(name);
    //if (!authed) cset(l, status := "PUBLIC READ");
    
    if (eq(mode, "uniqCI")) {
      text = lines(listMinusSet(tlft(text), asCISet(tlft(l.text))));
      if (empty(text)) return "No change";
    }
        
    if (eq(mode, "uniq")) {
      text = lines(listMinusSet(tlft(text), tlft(l.text)));
      if (empty(text)) return "No change";
    }
    
    listAppendWithLog(l, text);
    return "Changed";
  } finally { unlock(__2); } }

  if (!authed && eq(uri, "/list-names"))
    return serveText(jsonEncode(sortedIC(collect(publicReadLists(), "name"))));
    
  if (!authed && eq(uri, "/list-md5s"))
    return serveText(jsonEncode(map(publicReadLists(), new F1<AIList, List<String>>() { public List<String> get(AIList l) { try {  return ll(l.name, md5OfList(l));  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ll(l.name, md5OfList(l))"; }})));
    
  if (!authed && eq(uri, "/list-md5s-and-statuses"))
    return serveText(jsonEncode(map(publicReadLists(), new F1<AIList, List<String>>() { public List<String> get(AIList l) { try {  return ll(l.name, md5OfList(l), l.status, str(lineCountOfList(l)));  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ll(l.name, md5OfList(l), l.status, str(lineCountOfList(l)))"; }})));
    
  if (eq(uri, "/authed")) return yesno(authed);
  
  // Show list (unauthed)
  if (!authed && startsWith(uri, "/list/", m)) {
    AIList l = getList_noCreate(urldecode(m.get(0)));
    if (l == null || !l.isPublicRead()) return serve404("List not found");
    return htitle_h2(htmlencode(l.name)) + hpre_htmlencode(l.text);
  }
  
  boolean alphabetical = eq(uri, "/alphabetical");
  if (!authed && (eq(uri, "/") || alphabetical)) {
    List<AIList> list = alphabetical
    ? sortedByFieldIC("name", publicReadLists())
    : sortedByFieldDesc("modified", publicReadLists());

    return h3_title("Bot Data")
    + hBoolSelector(alphabetical, "/", "By date", "/alphabetical", "Alphabetical")
    + listLists(list);
  }
  
  // Search results
  String q = params.get("q");
  if (nempty(q)) {
    List<AIList> found = scoredSearch_AIList(q, listsForAuth(authed));
    
    if (eq(uri, "/json-search"))
      return serveText(jsonEncode(collect("name", found)));
      
    return hmobilefix()
      + htitle_h3("mech.botcompany.de: Search results for " + htmlencode(singleQuote(q)))
      + listLists(found);
  }

  if (!authed) return redirectToWebAuth();
  
  // AUTHED FROM HERE ON
  
  { var __12= html_serveDispatches(uri); if (__12 != null) return __12; }

  if (swic(uri, "/list-id/", m)) {
    AIList l = getList_noCreate(urldecode(m.rest()));
    return l == null ? "List not found" : str(l.id);
  }

  if (eq(uri, "/fix-unauth")) {
    for (AIList l : list(AIList.class)) if (swic(l.name, "Unauthorized Appends |"))
      cset(l, "status" , "");
    return "OK";
  }
  
  // API
  if (eq(uri, "/download"))
    return subBot_serveFileWithName("mechlists-" + ymd_minus_hms() + ".gz", conceptsFile()); // TODO: concurrent writes?
  
  if (eq(uri, "/list-names"))
    return serveText(jsonEncode(sortedIC(collect(list(AIList.class), "name"))));

  if (eq(uri, "/list-md5s"))
    return serveText(jsonEncode(map(list(AIList.class), new F1<AIList, List<String>>() { public List<String> get(AIList l) { try {  return ll(l.name, md5OfList(l));  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ll(l.name, md5OfList(l))"; }})));
    
  if (eq(uri, "/list-md5s-and-statuses"))
    return serveText(jsonEncode(map(list(AIList.class), new F1<AIList, List<String>>() { public List<String> get(AIList l) { try {  return ll(l.name, md5OfList(l), l.status, str(lineCountOfList(l)));  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "ll(l.name, md5OfList(l), l.status, str(lineCountOfList(l)))"; }})));
    
  if (eq(uri, "/bot-edited-lists"))
    return serveText(jsonEncode(sortedIC(collect(conceptsWhere(AIList.class, "botFlag" , true), "name"))));

  // Create API
  if (eq(uri, "/bot-list-create")) {
    Lock __3 = dbLock(); lock(__3); try {
    String name = params.get("name");
    getList(name);
    return "OK";
  } finally { unlock(__3); } }

  // Edit API
  if (eq(uri, "/bot-list-edit")) {
    Lock __4 = dbLock(); lock(__4); try {
    String name = params.get("name"), text = params.get("text");
    AIList l = getList(name);
    if (eq(l.text, text)) return "No change";
    listReplaceWithLog(l, text);
    return "Changed";
  } finally { unlock(__4); } }

  // Show list (authed)
  if (startsWith(uri, "/list/", m)) {
    String name = urldecode(m.get(0));
    AIList l = eq("1", params.get("create")) ? getList(name) : getList_noCreate(name);
    if (l == null)
      return "List not found"
        + (!authed ? "" : hpostform(hhidden("create" , 1) + hsubmit("Create")));
    
    boolean delete = eq(params.get("delete"), "1");
    
    // Rename list
    String renameTo = params.get("renameTo");
    if (nempty(renameTo) && !delete) {
      if (neqic(l.name, renameTo) && getList_noCreate(renameTo) != null)
        return "Can't rename - list " + quote(renameTo) + " already exists";
      String oldName = l.name;
      cset(l, "name" , renameTo);
      updateListNamesList();
      return nav() + "List " + quote(oldName) + " renamed to " + quote(renameTo);
    }
    
    if (delete) {
      logStructure("versions.log", litmap("id" , l.id, "status" , "delete me", "date" , now()));
      deleteConcept(l);
      updateListNamesList();
      return nav() + "List deleted";
    }

    // Update text
    String text = params.get("human");
    String status = params.get("status");
    if (text != null) {
      Lock __5 = dbLock(); lock(__5); try {
      //printStruct(ll(+text, +status));
      if (neqAny(text, l.text, status, unnull(l.status))) {
        logStructure("versions.log", litmap("id" , l.id, "text", text, "status", status, "date" , now()));
        if (status != null) cset(l, "status", status);
        cset(l, "text", text, "textMD5" , md5(text), "lines" , -1, "botFlag" , false, "modified" , now());
        listTextChanged(l);
        //printStruct("l.text=" + sfu(text));
      }
      return hrefresh(0, rawLink(uri) + "?random=" + randomID());
    } finally { unlock(__5); } }
    
    String textArea = htextarea(l.text, "name" , "human", "cols" , 80, "rows" , 30);
    
    List<String> tok = javaTok(l.status);
    jreplace(tok, "bb", "iframe 1018300");
    int idx = jfind(tok, "iframe <int>");
    if (idx > 0) {
      String analyzer = tok.get(idx+2);
      String subUri = joinSubList(tok, idx+4, smartIndexOf(tok, idx, ",")-1);
      textArea = htableRaw2_singleRow(ll(textArea, iframe(relativeRawBotLink(analyzer, subUri + "?list=" + urlencode(l.name)), "width" , "500", "height" , "500")),
        null, null, ll("valign" , "top"));
    }
    
    // Serve list text (editable)
    
    return nav() + htitle(l.name)
      + h2(ahref(neatMechListURL(l.name), htmlencode2(l.name)) + " [" + nLines(countLines(l.text)) + "]")
      + hpostform(
        "Status: " + htextinput("status", "value" , l.status)
      + h3("Contents (" + (l.botFlag ? "bot" : "human") + "-edited)")
      + p(hsubmit("Save"))
      + textArea
      + p(hsubmit("Save"))
      )
      + hpostform(
        "New name: " + htextinput("renameTo", "value" , l.name)
        + " "
        + hsubmit("Rename list") + " or " + hbutton("Delete list", "name" , "delete", "type" , "submit", "value" , 1, "onClick" , "return confirm('Really delete?')")
      );
  }
  
  // New list
  String newList = trim(params.get("newList"));
  if (nempty(newList)) {
    AIList l = getList(newList);
    return hrefresh(rawLink("/list/" + urlencode(l.name)));
  }
  
  // Overview
  
  List<AIList> list = alphabetical
    ? sortedByFieldIC("name", list(AIList.class))
    : sortedByFieldDesc("modified", list(AIList.class));
    
  final String prefix = session == null ? null : session.mech_filter;
  if (nempty(prefix))
    list = filter(list , new F1<AIList, Boolean>() { public Boolean get(AIList l) { try {  return swic(l.name, prefix);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "swic(l.name, prefix)"; }});

  return hmobilefix()
    + hcomment("cookie=" + cookie)
    + htitle_h3("mech.botcompany.de [" + n2(l(list), "list")
      + (totalChars >= 0 ? ", " + toK(totalChars) + "K chars" : "")
    + "]")
    + htableRaw_singleRow(ll(
      hform("Search: " + htextinput("q", "style" , "width: 200px") + " " + hsubmit("Search")),
      hpostform("| New list: " + htextinput("newList", "style" , "background-color: yellow") + " " + hsubmit("Create list"))))
    + hBoolSelector(alphabetical, "/", "By date", "/alphabetical", "Alphabetical")
    + listLists(list)
    + hpostform("Only show lists starting with: "
      + htextinput("mech_filter", "value" , prefix)
      + " " + hsubmit("OK"));
} finally { _close(__13); }} catch (Exception __e) { throw rethrow(__e); } }

static String nav() {
  return hmobilefix() + p(ahref(rawLink(), "&lt;&lt; back"));
}

static AIList getList_noCreate(String name) {
  return getList(name, false);
}

static AIList getList(String name) {
  return getList(name, true);
}

static AIList getList(String name, boolean create) {
  Lock __6 = dbLock(); lock(__6); try {
  AIList l = findConcept(AIList.class, "name", name);
  if (l == null) l = nameIndex.get(name);
  if (l == null) if (!create) return null; else {
    l = cnew(AIList.class, "name", name);
    logStructure("versions.log", litmap("id" , l.id, "name", name, "date" , now(), "mode" , "List created"));
    updateListNamesList();
  }
  if (l.modified == 0) cset(l, "modified" , now());
  return l;
} finally { unlock(__6); } }

static String listLists(List<AIList> list) {
  return ul(map(list, new F1<AIList, String>() { public String get(AIList l) { try { 
    int n = lineCountOfList(l);
    List<String> status = new ArrayList();
    boolean german = eq("german", mech_guessLanguage_quick(l.name));
    //if (l.mighty) status.add(german ? "GENUTZT" : "USED");
    addIfNempty(status, htmlencode(l.status));
    if (n != 0) status.add(n2(n, german ? "Zeile" : "line", german ? "Zeilen": "lines"));
    return ahref(rawLink("/list/" + urlencode(l.name)),
        htmlencode(or2(l.name, "[no name]")) + appendBracketed(joinWithComma(status)));
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "int n = lineCountOfList(l);\r\n    new L<S> status;\r\n    bool german = eq('germ..."; }}));
}

static List<AIList> scoredSearch_AIList(String query, Iterable<AIList> data) {
  Map<AIList, Integer> scores = new HashMap();
  List<String> prepared = scoredSearch_prepare(query);
  for (AIList l : data)
    putUnlessZero(scores, l,
        3*scoredSearch_score(l.name, prepared)
      + 2*scoredSearch_score(l.status, prepared)
      +   scoredSearch_score(l.text, prepared));
  return keysSortedByValuesDesc(scores);
}

static void calcTotalSize() {
  long total = 0;
  for (AIList l : list(AIList.class))
    total += l(l.text);
  totalChars = total;
}

static String export_getListText(String listName) {
  AIList l = getList_noCreate(listName);
  return l == null ? "" : l.text;
}

static String export_setListText(String listName, String text) {
  AIList l = getList(listName);
  if (eq(l.text, text)) return "No change";
  logStructure("versions.log", litmap("id" , l.id, "text", text, "date" , now(), "mode" , "bot edit"));
  cset(l, "text", text, "textMD5" , md5(text), "lines" , -1, "botFlag" , true, "modified" , now());
  listTextChanged(l);
  return "Changed";
}

static Object serveListText(String uri, Map<String, String> params, boolean authed) {
  Matches m = new Matches();
  if (startsWith(uri, "/list-text/", m)) {
    boolean opt = eq("1", params.get("opt"));
    boolean withStatus = eq("1", params.get("withStatus"));
    boolean create = authed && eq("1", params.get("create"));
    String md5 = params.get("md5");
    int md5Len = parseIntOpt(params.get("l"));
    String name = urldecode(m.get(0));
    Lock __7 = dbLock(); lock(__7); try {
    AIList l = create ? getList(name) : getList_noCreate(name);
    if (!authed && l != null && !l.isPublicRead())
      l = null;
      //ret subBot_serve404("Not logged in");
    cset(l, "mighty" , true);
    if (l == null)
      if (opt)
        return serveText(jsonEncode(litmap("Text" , "")));
      else
        return serveText(jsonEncode(litmap("Error", ll("List not found", name))));
    else {
      Map map = litmap("Name" , l.name, "Status" , withStatus ? l.status : null);
      if (md5 != null) {
        String actualMD5 = md5OfList(l);
        print("md5: " + md5 + " / " + actualMD5);
        if (eq(actualMD5, md5))
          return serveText(jsonEncode(mapPlus(map, "Same" , true)));
        else if (md5Len != 0 && eq(md5(takeFirst(l.text, md5Len)), md5))
          return serveText(jsonEncode(mapPlus(map, "Appended" , true, "Text" , substring(l.text, md5Len))));
      }
      return serveText(jsonEncode(mapPlus(map, "Text" , l.text)));
    }
  } finally { unlock(__7); } }
  return null;
}

static String md5OfList(AIList l) {
  Lock __8 = dbLock(); lock(__8); try {
  if (l.textMD5 == null) l.textMD5 = md5(l.text);
  return l.textMD5;
} finally { unlock(__8); } }

static int lineCountOfList(AIList l) {
  Lock __9 = dbLock(); lock(__9); try {
  if (l.lines < 0) l.lines = countLines(l.text);
  return l.lines;
} finally { unlock(__9); } }

static List<AIList> publicReadLists() {
  return filter(list(AIList.class) , new F1<AIList, Boolean>() { public Boolean get(AIList l) { try {  return l.isPublicRead();  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "l.isPublicRead()"; }});
}

static void updateListNamesList() {
  Lock __10 = dbLock(); lock(__10); try {
  AIList l = getList("All public-read mech lists");
  TreeSet<String> actual = new TreeSet(collect(publicReadLists(), "name"));
  Set<String> listed = asHashSet(lines(l.text));
  if (nempty(setMinusSet(listed, actual)))
    listReplaceWithLog(l, lines(actual));
  else
    listAppendWithLog(l, lines(setMinusSet(actual, listed)));
} finally { unlock(__10); } }

static void listAppendWithLog(AIList l, String text) {
  if (emptyAfterTrim(text)) return;
  logStructure("versions.log", litmap("id" , l.id, "text", text, "date" , now(), "mode" , "bot append"));
  cset(l, "text" , appendNewLineIfNempty(rtrim(l.text)) + text, "botFlag" , true, "modified" , now(), "textMD5" , null, "lines" , -1);
  listTextChanged(l);
}

static void listReplaceWithLog(AIList l, String text) {
  if (eq(text, l.text)) return;
  logStructure("versions.log", litmap("id" , l.id, "text", text, "date" , now(), "mode" , "bot edit"));
  cset(l, "text", text, "textMD5" , md5(text), "lines" , -1, "botFlag" , true, "modified" , now());
  listTextChanged(l);
}

static ThreadLocal<Boolean> listTextChanged_noRecurse = new ThreadLocal();

static void listTextChanged(AIList l) {
  if (!isTrue(listTextChanged_noRecurse.get()) && cic(l.status, "auto global ids")) { try {
    List<String> entries = splitAtEmptyLines(l.text);
    String text = joinWithEmptyLines(map(__43 -> nlLogic_addGlobalID(__43), entries));
     AutoCloseable __14 = tempSetThreadLocal(listTextChanged_noRecurse, true); try {
    listReplaceWithLog(l, text);
  } finally { _close(__14); }} catch (Throwable __e) { printStackTrace(__e); }}
  
  if (!isTrue(listTextChanged_noRecurse.get()) && cic(l.status, "gazelle ids")) { try {
    List<String> entries = splitAtEmptyLines(l.text);
    String text = joinWithEmptyLines(map(__44 -> gazelle_addGlobalID(__44), entries));
     AutoCloseable __15 = tempSetThreadLocal(listTextChanged_noRecurse, true); try {
    listReplaceWithLog(l, text);
  } finally { _close(__15); }} catch (Throwable __e) { printStackTrace(__e); }}
}

static String mechList_opt_raw_fresh(String name) {
  return export_getListText(name);
}

static List<AIList> listsForAuth(boolean authed) {
  return authed ? list(AIList.class) : publicReadLists();
}
static boolean cic(Collection<String> l, String s) {
  return containsIgnoreCase(l, s);
}


static boolean cic(Collection<Symbol> l, Symbol s) {
  return contains(l, s);
}


static boolean cic(String[] l, String s) {
  return containsIgnoreCase(l, s);
}

static boolean cic(String s, char c) {
  return containsIgnoreCase(s, c);
}

static boolean cic(String a, String b) {
  return containsIgnoreCase(a, b);
}



static void dbSaveEvery(double seconds) {
  db_mainConcepts().autoSaveInterval = toMS_int(seconds);
}


static void dbIndexing(Object... params) {
  db();
  indexConceptFields(params);
}


static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Class<A> c, String field) {
  return indexConceptFieldCI(db_mainConcepts(), c, field);
}

static <A extends Concept> ConceptFieldIndexCI<A> indexConceptFieldCI(Concepts concepts, Class<A> c, String field) {
  ConceptFieldIndexCI<A> idx = getConceptFieldCIIndex(concepts, c, field);
  return idx != null ? idx : new ConceptFieldIndexCI(concepts, c, field);
}


static Thread startThread(Object runnable) {
  return startThread(defaultThreadName(), runnable);
}

static Thread startThread(String name, Runnable runnable) {
  runnable = wrapAsActivity(runnable);
  return startThread(newThread(runnable, name));
}

static Thread startThread(String name, Object runnable) {
  runnable = wrapAsActivity(runnable);
  return startThread(newThread(toRunnable(runnable), name));
}

static Thread startThread(Thread t) {
  
  _registerThread(t);
  
  t.start();
  return t;
}


static String mech_guessLanguage(String s) {
  try {
    String func = first(mechList_opt("List => Language | Best guessing function"));
    
    return (String) callAndMake_extended(func, s);
  } catch (Throwable e) {
    
    return null;
  }
}


static RuntimeException rethrow(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  throw t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}

static RuntimeException rethrow(String msg, Throwable t) {
  throw new RuntimeException(msg, t);
}


static java.util.Timer calcOnConceptChanges(int delay, final Object runnable, final boolean runOnFirstTime) {
  return doEvery_daemon(delay, 0, new Runnable() {
    long c = runOnFirstTime ? -1 : changeCount();
    SingleThread thread = new SingleThread();
    
    public void run() {
      long _c = changeCount();
      if (_c != c && !thread.running()) {
        c = _c;
        thread.go(runnable);
      }
    }
  });
}


static void addConceptIndex(IConceptIndex index) {
  db_mainConcepts().addConceptIndex(index);
}


static void sendToUpdatesBot(String uri, Object... params) {
  sendToSnippetUpdatesBot(uri, params);
}


static <A extends Throwable> A printStackTrace(A e) {
  // we go to system.out now - system.err is nonsense
  if (e != null) print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

static void printStackTrace(String msg, Throwable e) {
  printStackTrace(new Throwable(msg, e));
}


static class countDispatch_Data {
  int running;
  long invocations, totalTime;
}

static Map<String, countDispatch_Data> countDispatch_map = synchroMap();

static Closeable countDispatch(final String methodName) {
  countDispatch_Data data;
  synchronized(countDispatch_map) {
    data = countDispatch_map.get(methodName);
    if (data == null) countDispatch_map.put(methodName, data = new countDispatch_Data());
  }
  data.running++;
  final countDispatch_Data _data = data;
  final long time = sysNow();
  return new Closeable() { public void close() {
    _data.totalTime += sysNow()-time;
    _data.running--;
    _data.invocations++;
  }};
}


static String cookieFromUser() {
  return (String) callOpt(getBot("#1002157"), "cookieFromUser");
}


static volatile StringBuffer local_log = new StringBuffer(); // not redirected




static boolean printAlsoToSystemOut = true;

static volatile Appendable print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;

static boolean print_silent = false; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<Object> print_byThread; // special handling by thread - prefers F1<S, Bool>
static volatile Object print_allThreads;
static volatile Object print_preprocess;

static void print() {
  print("");
}

static <A> A print(String s, A o) {
  print(combinePrintParameters(s, o));
  return o;
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping_okInCleanUp();
  if (print_silent) return o;
  String s = o + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  
  try {
    Object f = getThreadLocal(print_byThread_dontCreate());
    if (f == null) f = print_allThreads;
      if (f != null)
        // We do need the general callF machinery here as print_byThread is sometimes shared between modules
        if (isFalse(
          
            f instanceof F1 ? ((F1) f).get(s) :
          
          callF(f, s))) return;
  } catch (Throwable e) {
    System.out.println(getStackTrace(e));
  }
  

  print_raw(s);
}

static void print_raw(String s) {
  
  if (print_preprocess != null) s = (String) callF(print_preprocess, s);
  s = fixNewLines(s);
  
  Appendable loc = local_log;
  Appendable buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  
  
  if (printAlsoToSystemOut)
    System.out.print(s);
  
  
  vmBus_send("printed", mc(), s);
  
}

static void print_autoRotate() {
  
}


static String getDialogID() {
  return (String) callOpt(getMainBot(), "getDialogID");
}


static boolean empty(Collection c) { return c == null || c.isEmpty(); }
static boolean empty(Iterable c) { return c == null || !c.iterator().hasNext(); }
static boolean empty(CharSequence s) { return s == null || s.length() == 0; }
static boolean empty(Map map) { return map == null || map.isEmpty(); }
static boolean empty(Object[] o) { return o == null || o.length == 0; }
static boolean empty(BitSet bs) { return bs == null || bs.isEmpty(); }


static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  if (o instanceof byte[]) return empty((byte[]) o);
  if (o == null) return true;
  throw fail("unknown type for 'empty': " + getType(o));
}


static boolean empty(Iterator i) { return i == null || !i.hasNext(); }

static boolean empty(double[] a) { return a == null || a.length == 0; }
static boolean empty(float[] a) { return a == null || a.length == 0; }
static boolean empty(int[] a) { return a == null || a.length == 0; }
static boolean empty(long[] a) { return a == null || a.length == 0; }
static boolean empty(byte[] a) { return a == null || a.length == 0; }
static boolean empty(short[] a) { return a == null || a.length == 0; }


static boolean empty(MultiSet ms) { return ms == null || ms.isEmpty(); }



static boolean empty(IMultiMap mm) { return mm == null || mm.size() == 0; }


static boolean empty(File f) { return getFileSize(f) == 0; }










static boolean empty(Rect r) { return !(r != null && r.w != 0 && r.h != 0); }



static boolean empty(Chain c) { return c == null; }



static boolean empty(AppendableChain c) { return c == null; }



static <A extends Concept> A uniq(Class<A> c, Object... params) {
  return uniqueConcept(c, params);
}

static <A extends Concept> A uniq(Concepts cc, Class<A> c, Object... params) {
  return uniqueConcept(cc, c, params);
}


// returns number of changes
static int cset(Concept c, Object... values) { try {
  if (c == null) return 0;
  warnIfOddCount(values = expandParams(c.getClass(), values));
  int changes = 0;
  for (int i = 0; i+1 < l(values); i += 2)
    if (_csetField(c, (String) values[i], values[i+1])) ++changes;
  return changes;
} catch (Exception __e) { throw rethrow(__e); } }

static int cset(Iterable<? extends Concept> l, Object... values) {
  int changes = 0;
  for (Concept c : unnullForIteration(l))
    changes += cset(c, values);
  return changes;
}

static <A extends Concept> int cset(Concept.Ref<A> c, Object... values) {
  return cset(getVar(c), values);
}


static String hrefresh(String target) {
  return hrefresh(0, target);
}

static String hrefresh(double seconds) {
  return hrefresh(seconds, "");
}

static String hrefresh(double seconds, String target) {
  return tag("meta", "", "http-equiv", "refresh", "content", iceil(seconds) + (nempty(target) ? "; url=" + target : ""));
}


static String rawSelfLink(String uri) {
  return relativeRawBotLink(programID(), uri);
}

static String rawSelfLink() {
  return rawSelfLink("");
}


static boolean webAuthed() {
  return eq(Boolean.TRUE, callOpt(getBot("#1002590"), "currentHttpRequestAuthorized"));
}

static boolean webAuthed(Map<String, String> params) {
  return empty(params.get("unauthed")) && (eq(masterPW(), params.get("_pass")) || webAuthed());
}


static boolean eq(Object a, Object b) {
  return a == b || a != null && b != null && a.equals(b);
}


// a little kludge for stuff like eq(symbol, "$X")
static boolean eq(Symbol a, String b) {
  return eq(str(a), b);
}



// TODO: at least convert to UTF-8 on the fly
static Object serveText(Object s) {
  
  return call(getMainBot(), "serveByteArray", toUtf8(str(s)), "text/plain; charset=utf8");
}




static <A extends Concept> int countConcepts(Concepts concepts, Class<A> c, Object... params) {
  return concepts.countConcepts(c, params);
}

static <A extends Concept> int countConcepts(Class<A> c, Object... params) {
  return db_mainConcepts().countConcepts(c, params);
}

static int countConcepts() {
  return db_mainConcepts().countConcepts();
}

static int countConcepts(String className) {
  return db_mainConcepts().countConcepts(className);
}

static <A extends Concept> int countConcepts(Concepts concepts, String className) {
  return concepts.countConcepts(className);
}

static int countConcepts(Concepts concepts) {
  return concepts.countConcepts();
}


static boolean swic(String a, String b) {
  return startsWithIgnoreCase(a, b);
}


  static boolean swic(String a, String b, Matches m) {
    if (!swic(a, b)) return false;
    m.m = new String[] {substring(a, l(b))};
    return true;
  }



static String urldecode(String x) {
  try {
    return URLDecoder.decode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}


static Lock dbLock() {
  return db_mainConcepts().lock;
}

static Lock dbLock(Concepts cc) {
  return cc == null ? null : cc.lock;
}

static Lock dbLock(Concept c) {
  return dbLock(c == null ? null : c._concepts);
}


static void lock(Lock lock) { try {
  ping();
  if (lock == null) return;
  try {
    vmBus_send("locking", lock, "thread" , currentThread());
    lock.lockInterruptibly();
    vmBus_send("locked", lock, "thread" , currentThread());
  } catch (InterruptedException e) {
    Object reason = vm_threadInterruptionReasonsMap().get(currentThread());
    print("Locking interrupted! Reason: " + strOr(reason, "Unknown"));
    printStackTrace(e);
    rethrow(e);
  }
  // NO call to ping here! Make sure lock is always released.
} catch (Exception __e) { throw rethrow(__e); } }

static void lock(Lock lock, String msg) {
  print("Locking: " + msg);
  lock(lock);
}

static void lock(Lock lock, String msg, long timeout) {
  print("Locking: " + msg);
  lockOrFail(lock, timeout);
}

static ReentrantLock lock() {
  return fairLock();
}


static String lines(Iterable lines) { return fromLines(lines); }
static String lines(Object[] lines) { return fromLines(asList(lines)); }
static List<String> lines(String s) { return toLines(s); }

// convenience map call
static <A> String lines(Iterable<A> l, IF1<A, String> f) {
  return mapToLines(l, f);
}


static <A> List<A> listMinusSet(Iterable<A> l, Collection<? extends A> stuff) {
  if (l == null) return null;
  if (empty(stuff)) return asList(l);
  Set<? extends A> set = asSet(stuff);
  List<A> l2 = new ArrayList();
  for (A a : l) if (!set.contains(a)) l2.add(a);
  return l2;
}

static <A> List<A> listMinusSet(Iterable<A> l, Collection<A> stuff, Collection<? extends A> stuff2) {
  return listMinusSet(listMinusSet(l, stuff), stuff2);
}


static List<String> tlft(String s) { return toLinesFullTrim(s); }
static List<String> tlft(File f) { return toLinesFullTrim(f); }



static TreeSet<String> asCISet(Iterable<String> c) {
  return toCaseInsensitiveSet(c);
}

static TreeSet<String> asCISet(String... x) {
  return toCaseInsensitiveSet(x);
}


static void unlock(Lock lock, String msg) {
  if (lock == null) return;
  lock.unlock();
  vmBus_send("unlocked", lock, "thread" , currentThread());
  print("Unlocked: " + msg); // print afterwards to make sure the lock is always unlocked
}

static void unlock(Lock lock) {
  if (lock == null) return;
  lock.unlock();
  vmBus_send("unlocked", lock, "thread" , currentThread());
}


static String jsonEncode(Object o) {
  StringBuilder buf = new StringBuilder();
  jsonEncode(o, buf);
  return str(buf);
}

static void jsonEncode(Object o, StringBuilder buf) {
  if (o == null)
    buf.append("null");
  else if (o instanceof String)
    buf.append(quote((String) o));
  else if (o instanceof Number || o instanceof Boolean)
    buf.append(o);
  else if (o instanceof Map) {
    Map map =  (Map) o;
    buf.append("{");
    boolean first = true;
    for (Object key : keys(map)) {
      if (first) first = false; else buf.append(",");
      buf.append(quote((String) key));
      buf.append(":");
      jsonEncode(map.get(key), buf);
    }
    buf.append("}");
  } else if (o instanceof Collection) {
    Collection l =  (Collection) o;
    buf.append("[");
    boolean first = true;
    for (Object element : l) {
      if (first) first = false; else buf.append(",");
      jsonEncode(element, buf);
    }
    buf.append("]");
  } else
    throw fail("Unknown object for JSON encoding: " + className(o));
}


static List<String> sortedIC(Collection<String> l) {
  return sortedIgnoreCase(l);
}



static List collect(Iterable c, String field) {
  return collectField(c, field);
}

static List collect(String field, Iterable c) {
  return collectField(c, field);
}

/*ifclass Concept
static L collect(Class c, S field) {
  ret collect(list(c), field);
}
endif
TODO: make translator ignore stuff in ifclass until resolved
*/



static List map(Iterable l, Object f) { return map(f, l); }

static List map(Object f, Iterable l) {
  List x = emptyList(l);
  if (l != null) for  (Object o : l)
    { ping(); x.add(callF(f, o)); }
  return x;
}

// map: func(key, value) -> list element
static List map(Map map, Object f) {
  List x = new ArrayList();
  if (map != null) for  (Object _e : map.entrySet()) { ping(); 
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}

static List map(Object f, Object[] l) { return map(f, asList(l)); }
static List map(Object[] l, Object f) { return map(f, l); }

static List map(Object f, Map map) {
  return map(map, f);
}




  static <A, B> List<B> map(Iterable<A> l, F1<A, B> f) { return map(f, l); }

  static <A, B> List<B> map(F1<A, B> f, Iterable<A> l) {
    List x = emptyList(l);
    if (l != null) for  (A o : l)
      { ping(); x.add(callF(f, o)); }
    return x;
  }


static <A, B> List<B> map(IF1<A, B> f, Iterable<A> l) { return map(l, f); }
static <A, B> List<B> map(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for  (A o : l)
    { ping(); x.add(f.get(o)); }
  return x;
}
  
static <A, B> List<B> map(IF1<A, B> f, A[] l) { return map(l, f); }
static <A, B> List<B> map(A[] l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for  (A o : l)
    { ping(); x.add(f.get(o)); }
  return x;
}
  
static <A, B, C> List<C> map(Map<A, B> map, IF2<A, B, C> f) {
  List x = new ArrayList();
  if (map != null) for  (Map.Entry<A, B> e : map.entrySet()) { ping(); 
    x.add(f.get(e.getKey(), e.getValue()));
  }
  return x;
}

// new magic alias for mapLL - does it conflict?

static <A, B> List<A> map(IF1<A, B> f, A data1, A... moreData) {
  List x = emptyList(l(moreData)+1);
  x.add(f.get(data1));
  if (moreData != null) for  (A o : moreData)
    { ping(); x.add(f.get(o)); }
  return x;
}


// get purpose 1: access a list/array/map (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

// seems to conflict with other signatures
/*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o == null) return null;
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      makeAccessible(f);
      return f.get(o);
    }
      
    
      if (o instanceof DynamicObject)
        return getOptDynOnly(((DynamicObject) o), field);
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(String field, Object o) {
  return get_raw(o, field);
}

static Object get_raw(Object o, String field) { try {
  if (o == null) return null;
  Field f = get_findField(o.getClass(), field);
  makeAccessible(f);
  return f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    makeAccessible(f);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static Object get(String field, Object o) {
  return get(o, field);
}

static boolean get(BitSet bs, int idx) {
  return bs != null && bs.get(idx);
}


static <A> List<A> ll(A... a) {
  ArrayList l = new ArrayList(a.length);
  if (a != null) for (A x : a) l.add(x);
  return l;
}


static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}

static String str(char[] c, int offset, int count) {
  return new String(c, offset, count);
}


static String yesno(boolean b) {
  return yesno((Boolean) b);
}

static String yesno(Boolean b) {
  return eq(b, true) ? "Yes. " : eq(b, false) ? "No. " : "Unknown. ";
}


static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(unnull(b));
}

static boolean startsWith(String a, char c) {
  return nemptyString(a) && a.charAt(0) == c;
}


  static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b)) return false;
    if (m != null) m.m = new String[] {substring(a, strL(b))};
    return true;
  }


static boolean startsWith(List a, List b) {
  if (a == null || listL(b) > listL(a)) return false;
  for (int i = 0; i < listL(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}







static Object serve404() {
  return subBot_serve404();
}
static Object serve404(String msg) {
  return subBot_serve404(msg);
}





static String htitle_h2(String s) {
  return htitle_noEncode(dropTags(s)) + h2(s);
}


static String htmlencode(Object o) {
  return htmlencode(str(o));
}

static String htmlencode(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
    char c = s.charAt(i);
    if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
      int cp = s.codePointAt(i);
      out.append("&#x");
      out.append(intToHex_flexLength(cp));
      out.append(';');
      i += Character.charCount(cp)-1;
    } else
      out.append(c);
  }
  return out.toString();
}


static String hpre_htmlencode(Object contents, Object... params) {
  return pre_htmlencode(contents, params);
}


static <A> List<A> sortedByFieldIC(Collection<A> c, final String field) {
  List<A> l = new ArrayList(c);
  sort(l, new Comparator<A>() {
    public int compare(A a, A b) {
      return compareIC((String) getOpt(a, field), (String) getOpt(b, field));
    }
  });
  return l;
}

static <A> List<A> sortedByFieldIC(String field, Collection<A> c) {
  return sortedByFieldIC(c, field);
}


static <A> List<A> sortedByFieldDesc(Collection<A> c, String field) {
  List<A> l = new ArrayList(c);
  sort(l, descFieldComparator(field));
  return l;
}

static <A> List<A> sortedByFieldDesc(String field, Collection<A> c) {
  return sortedByFieldDesc(c, field);
}


static String h3_title(String s) {
  return h3_htitle(s);
}


// params = relative link, HTML, relative link, HTML, ...
static String hBoolSelector(boolean value, String... params) {
  List<String> l = new ArrayList();
  for (int i = 0; i < l(params); i += 2) {
    boolean selected = value != (i == 0);
    String link = params[i], html = params[i+1];
    if (selected)
      l.add(b("[" + html + "]"));
    else
      l.add(ahref(rawSelfLink(link), html));
  }
  return join(" | ", l);
}



static boolean nempty(Collection c) {
  return !empty(c);
}

static boolean nempty(CharSequence s) {
  return !empty(s);
}

static boolean nempty(Object[] o) { return !empty(o); }
static boolean nempty(byte[] o) { return !empty(o); }
static boolean nempty(int[] o) { return !empty(o); }

static boolean nempty(BitSet bs) { return !empty(bs); }

static boolean nempty(Map m) {
  return !empty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}


static boolean nempty(IMultiMap mm) { return mm != null && mm.size() != 0; }



static boolean nempty(Object o) { return !empty(o); }









static boolean nempty(Rect r) { return r != null && r.w != 0 && r.h != 0; }





static boolean nempty(MultiSet ms) { return ms != null && !ms.isEmpty(); }



static String hmobilefix() {
  return "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">";
}

static String hmobilefix(String html) {
  return hAddToHead(html, hmobilefix());
}



static String htitle_h3(String s) {
  return h3_htitle(s);
}


static String singleQuote(Object o) {
  if (o == null) return "null";
  return singleQuote(str(o));
}

static String singleQuote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  singleQuote_impl(s, out);
  return out.toString();
}
  
static void singleQuote_impl(String s, StringBuilder out) {
  out.append('\'');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '\'')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
  out.append('\'');
}


static String redirectToWebAuth() {
  return "Not authed. " + ahref(relativeBotLink("#1002590"), "Authenticate");
}


static Object html_serveDispatches(String uri) {
  if (eq(uri, "/dispatches"))
    return htmlencode(sfu(mapValues(new F1<countDispatch_Data, Map>() { public Map get(countDispatch_Data d) { try { 
      return mapPlus(objectToMap(d), "averageTime" , ratio(d.totalTime, d.invocations));
     } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "mapPlus(objectToMap(d), averageTime := ratio(d.totalTime, d.invocations))"; }}, cloneMap(countDispatch_map))));
  return null;
}


static <A extends Concept> List<A> list(Class<A> type) { return list(type, db_mainConcepts()); }
static <A extends Concept> List<A> list(Class<A> type, Concepts cc) {
  return cc.list(type);
}

static <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
  return concepts.list(type);
}

static List<Concept> list(String type) {
  return db_mainConcepts().list(type);
}

static List<Concept> list(Concepts concepts, String type) {
  return concepts.list(type);
}

static List<Concept> list(Concepts concepts) {
  return asList(concepts.allConcepts());
}



static Object subBot_serveFileWithName(File file) {
  return subBot_serveFileWithName(file, file.getName());
}

static Object subBot_serveFileWithName(File file, String name) {
  return call(getMainBot(), "serveFileWithName", file, name);
}

static Object subBot_serveFileWithName(String name, File file) {
  return subBot_serveFileWithName(file, name);
}

static Object subBot_serveFileWithName(File file, String name, String mimeType) {
  return call(getMainBot(), "serveFileWithName", file, name, mimeType);
}


static String ymd_minus_hms() {
  return ymd() + "-" + hms();
}


static File conceptsFile(String progID) {
  return getProgramFile(progID, conceptsFileName());
}

static File conceptsFile() {
  return conceptsFile(dbProgramID());
}

static File conceptsFile(Concepts concepts) {
  return concepts.conceptsFile();
}


static <A extends Concept> Collection<A> conceptsWhere(Class<A> c, Object... params) {
  return findConceptsWhere(c, params);
}

static Collection<Concept> conceptsWhere(String c, Object... params) {
  return findConceptsWhere(c, params);
}

static <A extends Concept> Collection<A> conceptsWhere(Concepts concepts, Class<A> c, Object... params) {
  return findConceptsWhere(concepts, c, params);
}


static String hpostform(Object contents, Object... params) {
  return tag("form", contents, concatArrays(new Object[] {"method", "POST"}, params));
}


static String hhidden(String name, Object value, Object... params) {
  return tag("input", "", concatArrays(new Object[] {"type", "hidden", "name", name, "value", value}, params));
}

static String hhidden(Map<String, String> map, String... keys) {
  return hiddenFields(map, keys);
}


static String hsubmit(String text, Object... params) {
  return tag("input", "", concatArrays(new Object[] {"type", "submit", "value", text}, params));
}

static String hsubmit() {
  return hsubmit("Submit");
}


static boolean neqic(String a, String b) {
  return !eqic(a, b);
}

static boolean neqic(char a, char b) {
  return !eqic(a, b);
}


static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else if (c == '\t')
      out.append("\\t");
    else if (c == '\0')
      out.append("\\0");
    else
      out.append(c);
  }
  out.append('"');
}


static void logStructure(File logFile, Object o) {
  logQuoted(logFile, structure(o));
}

// quick version - log to file in program directory
static void logStructure(String fileName, Object o) {
  logStructure(getProgramFile(fileName), o);
}

static void logStructure(String progID, String fileName, Object o) {
  logStructure(getProgramFile(progID, fileName), o);
}


static HashMap litmap(Object... x) {
  HashMap map = new HashMap();
  litmap_impl(map, x);
  return map;
}

static void litmap_impl(Map map, Object... x) {
  if (x != null) for (int i = 0; i < x.length-1; i += 2)
    if (x[i+1] != null)
      map.put(x[i], x[i+1]);
}


static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}



static void deleteConcept(long id) {
  db_mainConcepts().deleteConcept(id);
}

static void deleteConcept(Concepts concepts, long id) {
  concepts.deleteConcept(id);
}

static void deleteConcept(Concept c) {
  if (c != null) c.delete();
}

static void deleteConcept(Concept.Ref ref) {
  if (ref != null) deleteConcept(ref.get());
}



static boolean neqAny(Object... l) {
  for (int i = 0; i < l(l); i += 2)
    if (neq(l[i], l[i+1])) return true;
  return false;
}


static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> Collection<A> unnull(Collection<A> l) {
  return l == null ? emptyList() : l;
}

static <A> List<A> unnull(List<A> l) { return l == null ? emptyList() : l; }
static int[] unnull(int[] l) { return l == null ? emptyIntArray() : l; }
static char[] unnull(char[] l) { return l == null ? emptyCharArray() : l; }
static double[] unnull(double[] l) { return l == null ? emptyDoubleArray() : l; }

static <A, B> Map<A, B> unnull(Map<A, B> l) {
  return l == null ? emptyMap() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static <A> A[] unnull(A[] a) {
  return a == null ? (A[]) emptyObjectArray() : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}


static Pt unnull(Pt p) {
  return p == null ? new Pt() : p;
}


//ifclass Symbol

static Symbol unnull(Symbol s) {
  return s == null ? emptySymbol() : s;
}
//endif



static <A, B> Pair<A, B> unnull(Pair<A, B> p) {
  return p != null ? p : new Pair(null, null);
}


static int unnull(Integer i) { return i == null ? 0 : i; }
static long unnull(Long l) { return l == null ? 0L : l; }
static double unnull(Double l) { return l == null ? 0.0 : l; }


static String md5(String text) { try {
  if (text == null) return "-";
  return bytesToHex(md5_impl(toUtf8(text))); // maybe different than the way PHP does it...
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(byte[] data) {
  if (data == null) return "-";
  return bytesToHex(md5_impl(data));
}

static byte[] md5_impl(byte[] data) { try {
  return MessageDigest.getInstance("MD5").digest(data);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(File file) {
  return md5OfFile(file);
}


static String rawLink(String pageName) {
  return "/" + parseSnippetID(getProgramID()) + "/raw" + addPrefix("/", pageName);
}

static String rawLink() {
  return "/" + parseSnippetID(getProgramID()) + "/raw";
}

static String rawLink(String pageName, String contents) {
  return ahref(rawLink(pageName), contents);
}


static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID(Random r, int length) {
  return makeRandomID(r, length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}

static String randomID(Random r) {
  return randomID(r, randomID_defaultLength);
}


static String htextarea(String text, Object... params) {
  params = html_massageAutofocusParam(params);
  return hopeningTag("textarea", params) + htmlencode2(text) + "</textarea>";
}


// TODO: extended multi-line strings

static int javaTok_n, javaTok_elements;
static boolean javaTok_opt = false;

static List<String> javaTok(String s) {
  ++javaTok_n;
  ArrayList<String> tok = new ArrayList();
  int l = s == null ? 0 : s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
        // scan for whitespace
        while (j < l) {
          c = s.charAt(j);
          d = j+1 >= l ? '\0' : s.charAt(j+1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !regionMatches(s, j, "*/"));
            j = Math.min(j+2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        
        tok.add(javaTok_substringN(s, i, j));
        i = j;
        if (i >= l) break;
        c = s.charAt(i);
        d = i+1 >= l ? '\0' : s.charAt(i+1);
    
        // scan for non-whitespace
        
        // Special JavaX syntax: 'identifier
        if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
          j += 2;
          while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
            ++j;
        } else if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            int c2 = s.charAt(j);
            if (c2 == opener || c2 == '\n' && opener == '\'') { // allow multi-line strings, but not for '
              ++j;
              break;
            } else if (c2 == '\\' && j+1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for stuff like "don't"
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
        } else if (c == '[' && d == '[') {
          do ++j; while (j < l && !regionMatches(s, j, "]]"));
          j = Math.min(j+2, l);
        } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
          do ++j; while (j+2 < l && !regionMatches(s, j, "]=]"));
          j = Math.min(j+3, l);
        } else
          ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static List<String> javaTok(List<String> tok) {
  return javaTokWithExisting(join(tok), tok);
}




static String jreplace(String s, String in, String out) {
  return jreplace(s, in, out, null);
}

static String jreplace(String s, String in, String out, Object condition) {
  List<String> tok = javaTok(s);
  return jreplace(tok, in, out, condition) ? join(tok) : s;
}

// leaves tok properly tokenized
// returns true iff anything was replaced
static boolean jreplace(List<String> tok, String in, String out) {
  return jreplace(tok, in, out, false, true, null);
}

static boolean jreplace(List<String> tok, String in, String out, Object condition) {
  return jreplace(tok, in, out, false, true, condition);
}

static boolean jreplace(List<String> tok, String in, String out, IF2<List<String>, Integer, Boolean> condition) {
  return jreplace(tok, in, out, (Object) condition);
}

static boolean jreplace(List<String> tok, String in, String out, boolean ignoreCase, boolean reTok, Object condition) {
  String[] toks = javaTokForJFind_array(in);
  int lTokin = toks.length*2+1;

  boolean anyChange = false;
  int i = -1;
  for (int n = 0; n < 10000; n++) { // TODO: don't need this check anymore
    i = findCodeTokens(tok, i+1, ignoreCase, toks, condition);
    if (i < 0)
      return anyChange;
    List<String> subList = tok.subList(i-1, i+lTokin-1); // N to N
    String expansion = jreplaceExpandRefs(out, subList);
    int end = i+lTokin-2;
    
    clearAllTokens(tok, i, end); // C to C
    tok.set(i, expansion);
    if (reTok) // would this ever be false??
      reTok(tok, i, end);
    i = end;
    anyChange = true;
  }
  throw fail("woot? 10000! " + quote(in) + " => " + quote(out));
}

static boolean jreplace_debug = false;


static int jfind(String s, String in) {
  return jfind(javaTok(s), in);
}

static int jfind(List<String> tok, String in) {
  return jfind(tok, 1, in);
}

static int jfind(List<String> tok, int startIdx, String in) {
  return jfind(tok, startIdx, in, (ITokCondition) null);
}

static int jfind(List<String> tok, String in, Object condition) {
  return jfind(tok, 1, in, condition);
}

static int jfind(List<String> tok, String in, IIntPred condition) { return jfind(tok, 1, in, condition); }
static int jfind(List<String> tok, int startIndex, String in, IIntPred condition) {
  return jfind(tok, startIndex, in, tokCondition(condition));
}

static int jfind(List<String> tok, String in, ITokCondition condition) { return jfind(tok, 1, in, condition); }
static int jfind(List<String> tok, int startIndex, String in, ITokCondition condition) {
  return jfind(tok, startIndex, in, (Object) condition);
}

static int jfind(List<String> tok, int startIdx, String in, Object condition) {
  //LS tokin = jfind_preprocess(javaTok(in));
  return jfind(tok, startIdx, javaTokForJFind_array(in), condition);
}

// assumes you preprocessed tokin
static int jfind(List<String> tok, List<String> tokin) {
  return jfind(tok, 1, tokin);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin) {
  return jfind(tok, startIdx, tokin, null);
}

static int jfind(List<String> tok, int startIdx, String[] tokinC, Object condition) {
  return findCodeTokens(tok, startIdx, false, tokinC, condition);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
  return jfind(tok, startIdx, codeTokensAsStringArray(tokin), condition);
}

static List<String> jfind_preprocess(List<String> tok) {
  for (String type : litlist("quoted", "id", "int"))
    replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
  replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
  return tok;
}


static String joinSubList(List<String> l, int i, int j) {
  return join(subList(l, i, j));
}

static String joinSubList(List<String> l, int i) {
  return join(subList(l, i));
}




// returns l(s) if not found
static int smartIndexOf(String s, String sub, int i) {
  if (s == null) return 0;
  i = s.indexOf(sub, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, int i, char c) {
  return smartIndexOf(s, c, i);
}

static int smartIndexOf(String s, char c, int i) {
  if (s == null) return 0;
  i = s.indexOf(c, min(i, l(s)));
  return i >= 0 ? i : l(s);
}

static int smartIndexOf(String s, String sub) {
  return smartIndexOf(s, sub, 0);
}

static int smartIndexOf(String s, char c) {
  return smartIndexOf(s, c, 0);
}

static <A> int smartIndexOf(List<A> l, A sub) {
  return smartIndexOf(l, sub, 0);
}

static <A> int smartIndexOf(List<A> l, int start, A sub) {
  return smartIndexOf(l, sub, start);
}

static <A> int smartIndexOf(List<A> l, A sub, int start) {
  int i = indexOf(l, sub, start);
  return i < 0 ? l(l) : i;
}


static String htableRaw2_singleRow(List rows, List paramsTable, List paramsTR, List paramsTD) {
  return htableRaw2(ll(rows), paramsTable, paramsTR, paramsTD);
}


static String iframe(String url, Object... params) {
  return hfulltag("iframe", "", arrayPlus(params, "src" , url));
}



static String relativeRawBotLink() {
  return relativeRawBotLink(programID());
}

static String relativeRawBotLink(long botID) {
  return "/" + botID + "/raw";
}

static String relativeRawBotLink(String botID) {
  return relativeRawBotLink(parseSnippetID(botID));
}

static String relativeRawBotLink(long botID, String uri) {
  return "/" + botID + "/raw" + addPrefix("/", uri);
}

static String relativeRawBotLink(String botID, String uri) {
  return relativeRawBotLink(parseSnippetID(botID), uri);
}



static String urlencode(String x) {
  try {
    return URLEncoder.encode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}


static String htitle(String title) {
  return hfulltag("title", htmlencode_noQuotes(title));
}


static String h2(String s, Object... params) {
  return tag("h2", s, params);
}


static String ahref(String link, Object contents, Object... params) {
  return link == null ? str(contents) : href(link, contents, params);
}


static String neatMechListURL(String listName) {
  return "http://botcompany.de/mech/raw/list/" + urlencode(listName);
}


static String htmlencode2(String s) {
  return htmlencode_noQuotes(s);
}


static String nLines(long n) { return n2(n, "line"); }
static String nLines(Collection l) { return nLines(l(l)); }
static String nLines(String s) { return nLines(countLines(s)); }


static int countLines(String s) {
  return l(toLines(s)); // yeah could be optimized :-)
}


// first element of params can be the value
static String htextinput(String name, Object... params) {
  Object value = "";
  if (odd(l(params))) {
    value = params[0];
    params = dropFirst(params);
  }
  params = html_massageAutofocusParam(params);
  return tag("input", "", 
    concatArrays(new Object[] {"type", "text", "name", name, "value", value}, params));
}

static String htextinput(String name) {
  return htextinput(name, "");
}


static String h3(String s, Object... params) {
  return tag("h3", s, params) + "\n";
}


static String p(Object contents, Object... params) {
  return hfulltag("p", contents, params) + "\n";
}

static String p() { return p(""); }


static String hbutton(String text, Object... params) {
  return hfulltag("button", text, params);
}


static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }


static <A> List<A> filter(Iterable<A> c, Object pred) {
  if (pred instanceof F1) return filter(c, (F1<A, Boolean>) pred);

  
  List x = new ArrayList();
  if (c != null) for (Object o : c)
    if (isTrue(callF(pred, o)))
      x.add(o);
  return x;
}

static List filter(Object pred, Iterable c) {
  return filter(c, pred);
}

static <A, B extends A> List<B> filter(Iterable<B> c, F1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o))
      x.add(o);
  return x;
}

static <A, B extends A> List<B> filter(F1<A, Boolean> pred, Iterable<B> c) {
  return filter(c, pred);
}

//ifclass IF1
static <A, B extends A> List<B> filter(Iterable<B> c, IF1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o))
      x.add(o);
  return x;
}

static <A, B extends A> List<B> filter(B[] c, IF1<A, Boolean> pred) {
  List x = new ArrayList();
  if (c != null) for (B o : c)
    if (pred.get(o))
      x.add(o);
  return x;
}

static <A, B extends A> List<B> filter(IF1<A, Boolean> pred, Iterable<B> c) {
  return filter(c, pred);
}
//endif


static String hcomment(String text) {
  return hcommentSafe(text);
}


static String n2(long l) { return formatWithThousands(l); }
static String n2(AtomicLong l) { return n2(l.get()); }
static String n2(Collection l) { return n2(l(l)); }
static String n2(Map map) { return n2(l(map)); }

static String n2(double l, String singular) {
  return empty(singular) ? str(l) : n2(l, singular, singular + "s");
}

static String n2(double l, String singular, String plural) {
  if (fraction(l) == 0)
    return n2((long) l, singular, plural);
  else
    return l + " " + plural;
}

static String n2(long l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(long l, String singular) {
  return empty(singular) ? n2(l) : n_fancy2(l, singular, singular + "s");
}

static String n2(Collection l, String singular) {
  return n2(l(l), singular);
}

static String n2(Collection l, String singular, String plural) {
  return n_fancy2(l, singular, plural);
}

static String n2(Map m, String singular, String plural) {
  return n_fancy2(m, singular, plural);
}

static String n2(Map m, String singular) {
  return n2(l(m), singular);
}

static String n2(long[] a, String singular) { return n2(l(a), singular); }

static String n2(Object[] a, String singular) { return n2(l(a), singular); }
static String n2(Object[] a, String singular, String plural) { return n_fancy2(a, singular, plural); }


  static String n2(MultiSet ms, String singular) { return n2(ms, singular, singular + "s"); }
static String n2(MultiSet ms, String singular, String plural) {
    return n_fancy2(ms, singular, plural);
  }



  static String n2(IMultiMap mm, String singular) { return n2(mm, singular, singular + "s"); }
static String n2(IMultiMap mm, String singular, String plural) {
    return n_fancy2(l(mm), singular, plural);
  }



static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(short[] a) { return a == null ? 0 : a.length; }
static int l(long[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(double[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }

static int l(Iterator i) { return iteratorCount_int_close(i); } // consumes the iterator && closes it if possible

static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); }
static long l(File f) { return f == null ? 0 : f.length(); }




  static int l(MultiSet ms) { return ms == null ? 0 : ms.size(); }



  static int l(IMultiMap mm) { return mm == null ? 0 : mm.size(); }















  static int l(AppendableChain a) { return a == null ? 0 : a.size; }






static long toK(long l) {
  return (l+1023)/1024;
}


static String htableRaw_singleRow(List row, Object... params) {
  return htableRaw(ll(row), params);
}


static String hform(Object contents, Object... params) {
  return htag("form", contents, params);
}


static void _close(AutoCloseable c) {
  if (c != null) try {
    c.close();
  } catch (Throwable e) {
    // Some classes stupidly throw an exception on double-closing
    if (c instanceof javax.imageio.stream.ImageOutputStream)
      return;
    else throw rethrow(e);
  }
}


static <A extends Concept> A findConcept(Class<A> c, Object... params) {
  return findConceptWhere(c, params);
}

static <A extends Concept> A findConcept(Concepts concepts, Class<A> c, Object... params) {
  return findConceptWhere(concepts, c, params);
}


static Concept cnew(String name, Object... values) {
  return cnew(db_mainConcepts(), name, values);
}

static Concept cnew(Concepts concepts, String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  concepts_unlisted.set(true);
  Concept c;
  try {
    c = cc != null ? nuObject(cc) : new Concept(name);
  } finally {
    concepts_unlisted.set(null);
  }
  csetAll(c, values);
  concepts.register(c);
  return c;
}

static <A extends Concept> A cnew(Class<A> cc, Object... values) {
  return cnew(db_mainConcepts(), cc, values);
}

static <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
  concepts_unlisted.set(true);
  A c;
  try {
    c = nuObject(cc);
  } finally {
    concepts_unlisted.set(null);
  }
  csetAll(c, values);
  concepts.register(c);
  return c;
}



static String ul(String... list) {
  return ul(asList(list));
}

static String ul(Collection list, Object... params) {
  StringBuilder buf = new StringBuilder();
  int i = indexOf(params, null); // null separates params for ul from params for li
  if (i == -1) i = l(params);
  for (Object s : withoutNulls(list))
    buf.append(tag("li", s, subArray(params, i+1))).append("\n");
  return containerTag("ul", buf, subArray(params, 0, i)) + "\n";
}


static String mech_guessLanguage_quick(String s) {
  return guessGermanOrEnglish(s);
}


static void addIfNempty(Collection<String> l, String s) {
  if (nempty(s)) l.add(s);
}

static void addIfNempty(Collection l, Map m) {
  if (nempty(m)) l.add(m);
}

static void addIfNempty(Collection l, Collection c) {
  if (nempty(c)) l.add(c);
}


static String or2(String a, String b) {
  return nempty(a) ? a : b;
}

static String or2(String a, String b, String c) {
  return or2(or2(a, b), c);
}


static String appendBracketed(Object o) {
  String b = strOrNull(o);
  return empty(b) ? "" : "" + " (" + b + ")";
}

static String appendBracketed(String a, String b) {
  return a + appendBracketed(b);
}


static <A> String joinWithComma(Collection<A> c) {
  return join(", ", c);
}

static String joinWithComma(Object... c) {
  return join(", ", c);
}

static String joinWithComma(String... c) {
  return join(", ", c);
}


static String joinWithComma(Pair p) {
  return p == null ? "" : joinWithComma(str(p.a), str(p.b));
}



static List<String> scoredSearch_prepare(String query) {
  return map(__45 -> replacePlusWithSpace(__45), splitAtSpace(query));
}


static <A> void putUnlessZero(Map<A, Integer> map, A key, int value) {
  if (map != null && key != null && value != 0) map.put(key, value);
}

static <A> void putUnlessZero(Map<A, Double> map, A key, double value) {
  if (map != null && key != null && value != 0) map.put(key, value);
}


// Search for some words in some texts and return a total score
static int scoredSearch_score(Iterable<String> l, List<String> words) {
  int score = 0;
  if (l != null) for (String s : l)
    score += scoredSearch_score(s, words);
  return score;
}

static int scoredSearch_score(String s, List<String> words) {
  int score = 0;
  if (nempty(s))
    for (String word : unnullForIteration(words))
      score += scoredSearch_score_single(s, word);
  return score;
}

static int scoredSearch_score(String s, String query) {
  return scoredSearch_score(s, scoredSearch_prepare(query));
}


static <A, B> List<A> keysSortedByValuesDesc(final Map<A, B> map) {
  List<A> l = new ArrayList(map.keySet());
  sort(l, mapComparatorDesc(map));
  return l;
}


static int parseIntOpt(String s) { return parseIntOpt(s, 0); }
static int parseIntOpt(String s, int defValue) {
  return isInteger(s) ? parseInt(s) : defValue;
}


static <A, B> Map<A, B> mapPlus(Map<A, B> m, Object... data) {
  m = cloneMap(m);
  litmap_impl(m, data);
  return m;
}


static <A> List<A> takeFirst(List<A> l, int n) {
  return l(l) <= n ? l : newSubListOrSame(l, 0, n);
}

static <A> List<A> takeFirst(int n, List<A> l) {
  return takeFirst(l, n);
}

static String takeFirst(int n, String s) { return substring(s, 0, n); }
static String takeFirst(String s, int n) { return substring(s, 0, n); }

static CharSequence takeFirst(int n, CharSequence s) { return subCharSequence(s, 0, n); }

static <A> List<A> takeFirst(int n, Iterator<A> it) {
  if (it == null) return null;
  List l = new ArrayList();
  for (int _repeat_0 = 0; _repeat_0 < n; _repeat_0++)  { if (it.hasNext()) l.add(it.next()); else break; }
  return l;
}

static <A> List<A> takeFirst(int n, Iterable<A> i) {
  if (i == null) return null;
  return i == null ? null : takeFirst(n, i.iterator());
}

static <A> List<A> takeFirst(int n, IterableIterator<A> i) {
  return takeFirst(n, (Iterator<A>) i);
}

static int[] takeFirst(int n, int[] a) { return takeFirstOfIntArray(n, a); }

static short[] takeFirst(int n, short[] a) { return takeFirstOfShortArray(n, a); }

static byte[] takeFirst(int n, byte[] a) { return takeFirstOfByteArray(n, a); }
static byte[] takeFirst(byte[] a, int n) { return takeFirstOfByteArray(n, a); }

static double[] takeFirst(int n, double[] a) { return takeFirstOfDoubleArray(n, a); }
static double[] takeFirst(double[] a, int n) { return takeFirstOfDoubleArray(n, a); }


static String substring(String s, int x) {
  return substring(s, x, strL(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  int n = s.length();
  if (y < x) y = x;
  if (y > n) y = n;
  if (x >= y) return "";
  return s.substring(x, y);
}



// convenience method for quickly dropping a prefix
static String substring(String s, CharSequence l) {
  return substring(s, lCharSequence(l));
}


static <A> HashSet<A> asHashSet(Collection<A> c) {
  synchronized(collectionMutex(c)) {
    return new HashSet(c);
  }
}

static <A> HashSet<A> asHashSet(A[] a) {
  return a == null ? null : new HashSet(Arrays.asList(a));
}


static <A, B extends A> Set<A> setMinusSet(Set<A> l, Collection<B> stuff) {
  if (empty(stuff)) return l;
  Set<B> set = asSet(stuff);
  Set<A> l2 = similarEmptySet(l);
  for (A a : l) if (!set.contains(a)) l2.add(a);
  return l2;
}

static <A, B extends A> Set<A> setMinusSet(Collection<A> l, Collection<B> stuff) {
  return setMinusSet(asSet(l), stuff);
}



static boolean emptyAfterTrim(String s) {
  return empty(trim(s));
}


static String appendNewLineIfNempty(String s) {
  return empty(s) ? "" : s + "\n";
}


public static String rtrim(String s) {
  if (s == null) return null;
  int i = s.length();
  while (i > 0 && " \t\r\n".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}


static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  if (o instanceof ThreadLocal) // TODO: remove this
    return isTrue(((ThreadLocal) o).get());
  throw fail(getClassName(o));
}

static boolean isTrue(Boolean b) {
  return b != null && b.booleanValue();
}


static List<String> splitAtEmptyLines(String text) {
  List<String> lines = toLines(text);
  int n = l(lines), i = 0;
  List<String> parts = new ArrayList();
  while  (true) { ping(); 
    while (i < n && emptyAfterTrim(lines.get(i))) ++i;
    if (i >= n) break;
    int j = i;
    while (j < n && !emptyAfterTrim(lines.get(j))) ++j;
    parts.add(fromLines(subList(lines, i, j)));
    i = j;
  }
  return parts;
}


static String joinWithEmptyLines(Iterable<String> l) {
  return join("\n\n", map(__46 -> rtrim(__46), l));
}

static String joinWithEmptyLines(String... l) {
  return joinWithEmptyLines(asList(l));
}


static String nlLogic_addGlobalID(String rule) {
  rule = ltrim(rule);
  if (!startsWith(rule, "[id:"))
    rule = "[id: " + aGlobalID() + 
      (rule.startsWith("[") ? ", " + dropPrefix("[", rule) : "] " + rule);
  return rule;
}



static <A> AutoCloseable tempSetThreadLocal(final ThreadLocal<A> tl, A a) {
  if (tl == null) return null;
  final A prev = setThreadLocal(tl, a);
  return new AutoCloseable() { public String toString() { return "tl.set(prev);"; } public void close() throws Exception { tl.set(prev); }};
}


static String gazelle_addGlobalID(String rule) {
  if (!containsStartingWith(lines(rule), "[id:"))
    rule = appendWithNewLine(rule, "[id: " + aGlobalID() + "]");
  return rule;
}





static AutoCloseable tempInterceptPrintIfNotIntercepted(F1<String, Boolean> f) {
  return print_byThread().get() == null ? tempInterceptPrint(f) : null;
}


static boolean containsIgnoreCase(Collection<String> l, String s) {
  if (l != null) for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String[] l, String s) {
  if (l != null) for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String s, char c) {
  return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
}

static boolean containsIgnoreCase(String a, String b) {
  return indexOfIgnoreCase(a, b) >= 0;
}


static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Iterable it, Object a) {
  if (it != null)
    for (Object o : it)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}

static boolean contains(BitSet bs, int i) {
  return bs != null && bs.get(i);
}


static <A> boolean contains(Producer<A> p, A a) {
  if (p != null && a != null) while (true) {
    A x = p.next();
    if (x == null) break;
    if (eq(x, a)) return true;
  }
  return false;
}



static boolean contains(Rect r, Pt p) { return rectContains(r, p); }



static volatile Concepts mainConcepts; // Where we create new concepts

static Concepts db_mainConcepts() {
  if (mainConcepts == null)
    mainConcepts = newConceptsWithClassFinder(getDBProgramID());
  return mainConcepts;
}

static void cleanMeUp_concepts() {
  if (db_mainConcepts() != null) db_mainConcepts().cleanMeUp();
  // mainConcepts = null; // TODO
}



static int toMS_int(double seconds) {
  return toInt_checked((long) (seconds*1000));
}


static void db() {
  conceptsAndBot();
}

// use -10000 for 10 seconds plus slowdown logic
static void db(Integer autoSaveInterval) {
  conceptsAndBot(autoSaveInterval);
}


// first parameter can be Concepts
static void indexConceptFields(Object... params) {
  int i = 0;
  Concepts concepts;
  if (first(params) instanceof Concepts) {
    concepts = (Concepts) first(params);
    ++i;
  } else concepts = db_mainConcepts();
  for (; i < l(params); i += 2)
    indexConceptField(concepts, (Class) params[i], (String) params[i+1]);
}


static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Class<A> c, String field) {
  return getConceptFieldCIIndex(db_mainConcepts(), c, field);
}

static <A extends Concept> ConceptFieldIndexCI<A> getConceptFieldCIIndex(Concepts concepts, Class<A> c, String field) {
  return (ConceptFieldIndexCI) concepts.getCIFieldIndex(c, field);
}


static String defaultThreadName_name;

static String defaultThreadName() {
  if (defaultThreadName_name == null)
    defaultThreadName_name = "A thread by " + programID();
  return defaultThreadName_name;
}


static Runnable wrapAsActivity(Object r) {
  if (r == null) return null;
  Runnable r2 = toRunnable(r);


  Object mod = dm_current_generic();
  if (mod == null) return r2;
  return new Runnable() {  public void run() { try { 
    AutoCloseable c =  (AutoCloseable) (rcall("enter", mod));
     AutoCloseable __1 = c; try {
    r2.run();
  
} finally { _close(__1); }} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "AutoCloseable c =  (AutoCloseable) (rcall enter(mod));\r\n    temp c;\r\n    r2.r..."; }};

}


// runnable = Runnable or String (method name)
static Thread newThread(Object runnable) {
  return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)));
}

static Thread newThread(Object runnable, String name) {
  if (name == null) name = defaultThreadName();
  return new BetterThread(_topLevelErrorHandling(toRunnable(runnable)), name);
}

static Thread newThread(String name, Object runnable) {
  return newThread(runnable, name);
}


static Runnable toRunnable(final Object o) {
  if (o == null) return null;
  if (o instanceof Runnable) return (Runnable) o;
  
  if (o instanceof String) throw fail("callF_legacy");
  
  return new Runnable() {  public void run() { try {  callF(o) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(o)"; }};
}


static Map<Thread, Boolean> _registerThread_threads;
static Object _onRegisterThread; // voidfunc(Thread)

static Thread _registerThread(Thread t) {
  if (_registerThread_threads == null)
    _registerThread_threads = newWeakHashMap();
  _registerThread_threads.put(t, true);
  vm_generalWeakSubMap("thread2mc").put(t, weakRef(mc()));
  callF(_onRegisterThread, t);
  return t;
}

static void _registerThread() {
  _registerThread(Thread.currentThread());
}



static Object first(Object list) {
  return first((Iterable) list);
}


static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}

static <A, B> Pair<A, B> first(Map<A, B> map) {
  return mapEntryToPair(first(entrySet(map)));
}

static <A, B> Pair<A, B> first(MultiMap<A, B> mm) {
  if (mm == null) return null;
  var e = first(mm.data.entrySet());
  if (e == null) return null;
  return pair(e.getKey(), first(e.getValue()));
}


static <A> A first(IterableIterator<A> i) {
  return first((Iterator<A>) i);
}


static <A> A first(Iterator<A> i) {
  return i == null || !i.hasNext() ? null : i.next();
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }
static Character first(CharSequence s) { return empty(s) ? null : s.charAt(0); }


static <A, B> A first(Pair<A, B> p) {
  return p == null ? null : p.a;
}



static <A, B, C> A first(T3<A, B, C> t) {
  return t == null ? null : t.a;
}


static Byte first(byte[] l) { 
  return empty(l) ? null : l[0];
}





static <A> A first(A[] l, IF1<A, Boolean> pred) {
  return firstThat(l, pred);
}

static <A> A first(Iterable<A> l, IF1<A, Boolean> pred) {
  return firstThat(l, pred);
}

static <A> A first(IF1<A, Boolean> pred, Iterable<A> l) {
  return firstThat(pred, l);
}


static <A> A first(AppendableChain<A> a) {
  return a == null ? null : a.element;
}




static List<String> mechList_opt(String name) {
  return mechList_opt_tlft(name);
}


static Object callAndMake_extended(String code, final Object... args) {
  if (code == null) return null;
  code = trim(code);
  if (isQuoted(code)) return unquote(code);
  if (isInteger(code)) return parseInt(code);
  if (isIdentifier(code))
    return eq(code, "x") ? first(args) : callAndMake(code, args);
  List<String> tok = javaTok(code);
  if (lCodeTokens(tok) == 4 && eq(second(tok), "f") && isIdentifier(get(tok, 3)) && eq("/", get(tok, 5)))
    if (eq("1", get(tok, 7)))
      return standardFunctionReference_1(get(tok, 3));
    else if (eq("2", get(tok, 7)))
      return standardFunctionReference_2(get(tok, 3));
  Pair<String, List<String>> p = tok_parseFunctionCall(tok);
  if (p == null) throw fail("Can't parse: " + code);
  return callAndMake(p.a, map_toArray(new F1<String, Object>() { public Object get(String arg) { try {  return callAndMake_extended(arg, args);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callAndMake_extended(arg, args)"; }}, p.b));
}


static void _handleError(Error e) {
  //call(javax(), '_handleError, e);
}


// firstDelay = delay
static FixedRateTimer doEvery_daemon(long delay, final Object r) { return doEvery_daemon(defaultTimerName(), delay, r); }
static FixedRateTimer doEvery_daemon(String timerName, long delay, final Object r) {
  return doEvery_daemon(timerName, delay, delay, r);
}

static FixedRateTimer doEvery_daemon(long delay, long firstDelay, final Object r) { return doEvery_daemon(defaultTimerName(), delay, firstDelay, r); }
static FixedRateTimer doEvery_daemon(String timerName, long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(true);
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
  return timer;
}

static FixedRateTimer doEvery_daemon(double delaySeconds, final Object r) {
  return doEvery_daemon(toMS(delaySeconds), r);
}


static long changeCount() {
  return db_mainConcepts().changes;
}


static void sendToSnippetUpdatesBot(String uri, Object... params) {
  try { loadPageWithParams(butterBotURL("#1019175") + addSlashPrefix(uri), params); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
}


static String getStackTrace(Throwable throwable) {
  lastException(throwable);
  return getStackTrace_noRecord(throwable);
}

static String getStackTrace_noRecord(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return hideCredentials(writer.toString());
}

static String getStackTrace() {
  return getStackTrace_noRecord(new Throwable());
}

static String getStackTrace(String msg) {
  return getStackTrace_noRecord(new Throwable(msg));
}


static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  
    return new SynchronizedMap(map);
  
  
}


static long sysNow() {
  ping();
  return System.nanoTime()/1000000;
}


static Object callOpt(Object o) {
  return callF(o);
}

static Object callOpt(Object o, String method, Object... args) {
  return callOpt_withVarargs(o, method, args);
}


static Object getBot(String botID) {
  return callOpt(getMainBot(), "getBot", botID);
}



static String combinePrintParameters(String s, Object o) {
  return (endsWithLetterOrDigit(s) ? s + ": " : s) + o;
}


static void ping_okInCleanUp() {


  if (ping_pauseAll || ping_anyActions)
    ping_impl(true);


}


// this syntax should be removed...
static Object getThreadLocal(Object o, String name) {
  ThreadLocal t =  (ThreadLocal) (getOpt(o, name));
  return t != null ? t.get() : null;
}

static <A> A getThreadLocal(ThreadLocal<A> tl) {
  return tl == null ? null : tl.get();
}

static <A> A getThreadLocal(ThreadLocal<A> tl, A defaultValue) {
  return or(getThreadLocal(tl), defaultValue);
}


static ThreadLocal<Object> print_byThread_dontCreate() {
  return print_byThread;
}


static boolean isFalse(Object o) {
  return eq(false, o);
}



static Map<Class, ArrayList<Method>> callF_cache = newDangerousWeakHashMap();



  static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }



  static <A> A callF(IF0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }


static <A, B> B callF(A a, IF1<A, B> f) {
  return f == null ? null : f.get(a);
}


  static <A, B, C> C callF(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A, B, C> C callF(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A> void callF(VF1<A> f, A a) {
    if (f != null) f.get(a);
  }


static <A> void callF(A a, IVF1<A> f) {
  if (f != null) f.get(a);
}

static <A> void callF(IVF1<A> f, A a) {
  if (f != null) f.get(a);
}


static Object callF(Runnable r) { { if (r != null) r.run(); } return null; }


static Object callF(Object f, Object... args) {
  
    
  return safeCallF(f, args);
}

static Object safeCallF(Object f, Object... args) {
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) {
    
    
    if (f instanceof String)
      throw fail("Legacy call: " + f);
    
    throw fail("No get method in " + getClassName(c));
  }
  if (n == 1) return invokeMethod(methods.get(0), f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return invokeMethod(m, f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
}

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        makeAccessible(m);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}





static String fixNewLines(String s) {
  int i = indexOf(s, '\r');
  if (i < 0) return s;
  int l = s.length();
  StringBuilder out = new StringBuilder(l);
  out.append(s, 0, i);
  for (; i < l; i++) {
    char c = s.charAt(i);
    if (c != '\r')
      out.append(c);
    else {
      out.append('\n');
      if (i+1 < l && s.charAt(i+1) == '\n') ++i;
    }
  }
  return out.toString();
}


static void print_append(Appendable buf, String s, int max) { try {
  synchronized(buf) {
    buf.append(s);
    if (buf instanceof StringBuffer)
      rotateStringBuffer(((StringBuffer) buf), max);
    else if (buf instanceof StringBuilder)
      rotateStringBuilder(((StringBuilder) buf), max);
  }
} catch (Exception __e) { throw rethrow(__e); } }


static void vmBus_send(String msg, Object... args) {
  Object arg = vmBus_wrapArgs(args);
  pcallFAll_minimalExceptionHandling(vm_busListeners_live(), msg, arg);
  pcallFAll_minimalExceptionHandling(vm_busListenersByMessage_live().get(msg), msg, arg);
}

static void vmBus_send(String msg) {
  vmBus_send(msg, (Object) null);
}


static Class mc() {
  return main.class;
}


static Object mainBot;

static Object getMainBot() {
  return mainBot;
}


static RuntimeException fail() { throw new RuntimeException("fail"); }
static RuntimeException fail(Throwable e) { throw asRuntimeException(e); }
static RuntimeException fail(Object msg) { throw new RuntimeException(String.valueOf(msg)); }


static RuntimeException fail(Object... objects) { throw new Fail(objects); }


static RuntimeException fail(String msg) { throw new RuntimeException(msg == null ? "" : msg); }
static RuntimeException fail(String msg, Throwable innerException) { throw new RuntimeException(msg, innerException); }



static String getType(Object o) {
  return getClassName(o);
}


static long getFileSize(String path) {
  return path == null ? 0 : new File(path).length();
}

static long getFileSize(File f) {
  return f == null ? 0 : f.length();
}


static <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
  return uniqueConcept(db_mainConcepts(), c, params);
}

static <A extends Concept> A uniqueConcept(Concepts cc, Class<A> c, Object... params) {
   AutoCloseable __1 = tempDBLock(cc); try {
  params = expandParams(c, params);
  A x = findConceptWhere(cc, c, params);
  if (x == null) {
    x = unlisted(c);
    
    csetAll(x, params);
    cc.register(x);
  } else {
    
  }
  return x;
} finally { _close(__1); }}


static void warnIfOddCount(Object... list) {
  if (odd(l(list)))
    printStackTrace("Odd list size: " + list);
}


static <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
  if (l(params) == 1)
    params = new Object[] { singleFieldName(c), params[0] };
  else
    warnIfOddCount(params);
  return params;
}



// returns true if change
static boolean _csetField(Concept c, String field, Object value) { try {
  Field f = setOpt_findField(c.getClass(), field);
  //print("cset: " + c.id + " " + field + " " + struct(value) + " " + f);
  if (value instanceof RC) value = c._concepts.getConcept((RC) value);
  value = deref(value);
  
  if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan) value = intern((String) value);
  
  if (f == null) {
    // dynamic field (undeclared)
    
    assertIdentifier(field);
    Object oldVal = mapGet(c.fieldValues, field);
    
    if (value instanceof Concept) {
      if (oldVal instanceof Concept.Ref)
        // change existing reference
        return ((Concept.Ref) oldVal).set((Concept) value);
      else {
        // overwrite non-reference value if any,
        // create new reference
        dynamicObject_setRawFieldValue(c, field, c.new Ref((Concept) value));
        c.change(); return true;
      }
    } else {
      // value is not a concept
      
      // if it was a reference, cleanly delete it
      if (oldVal instanceof Concept.Ref) ((Concept.Ref) oldVal).unindexAndDrop();
    
      if (eq(oldVal, value)) return false;
      
      if (isConceptList(value) && nempty(((List) value))) {
        // TODO: clean-up etc
        dynamicObject_setRawFieldValue(c, field, c.new RefL(((List) value)));
        c.change(); return true;
      }
      
      if (value == null) {
        // delete field
        dynamicObject_dropRawField(c, field);
      } else {
        // update or create field
        if (!isPersistable(value))
          throw fail("Can't persist: " + c + "." + field + " = "+ value);

        dynamicObject_setRawFieldValue(c, field, value);
      }
      c.change(); return true;
    }
  } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
    // Concept.Ref magic
    ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
    c.change(); return true;
  } else if (isSubtypeOf(f.getType(), Concept.RefL.class)) {
    // Concept.RefL magic
    ((Concept.RefL) f.get(c)).replaceWithList(lmap(__47 -> derefRef(__47), (List) value));
    c.change(); return true;
  } else {
    Object old = f.get(c);
    if (neq(value, old)) {
      boolean isTransient = isTransient(f);
      if (!isTransient && !isPersistable(value))
        throw fail("Can't persist: " + c + "." + field + " = "+ value);
      f.set(c, value);
      if (!isTransient) c.change(); 
      return true;
    }
  }
  return false;
} catch (Exception __e) { throw rethrow(__e); } }


static String unnullForIteration(String s) {
  return s == null ? "" : s;
}

static <A> Collection<A> unnullForIteration(Collection<A> l) {
  return l == null ? immutableEmptyList() : l;
}

static <A> List<A> unnullForIteration(List<A> l) { return l == null ? immutableEmptyList() : l; }
static int[] unnullForIteration(int[] l) { return l == null ? emptyIntArray() : l; }
static char[] unnullForIteration(char[] l) { return l == null ? emptyCharArray() : l; }
static double[] unnullForIteration(double[] l) { return l == null ? emptyDoubleArray() : l; }
static short[] unnullForIteration(short[] l) { return l == null ? emptyShortArray() : l; }

static <A, B> Map<A, B> unnullForIteration(Map<A, B> l) {
  return l == null ? immutableEmptyMap() : l;
}

static <A> Iterable<A> unnullForIteration(Iterable<A> i) {
  return i == null ? immutableEmptyList() : i;
}

static <A> A[] unnullForIteration(A[] a) {
  return a == null ? (A[]) emptyObjectArray() : a;
}

static BitSet unnullForIteration(BitSet b) {
  return b == null ? new BitSet() : b;
}


static Pt unnullForIteration(Pt p) {
  return p == null ? new Pt() : p;
}


//ifclass Symbol

static Symbol unnullForIteration(Symbol s) {
  return s == null ? emptySymbol() : s;
}
//endif



static <A, B> Pair<A, B> unnullForIteration(Pair<A, B> p) {
  return p != null ? p : new Pair(null, null);
}


static long unnullForIteration(Long l) { return l == null ? 0L : l; }


static <A> A getVar(IF0<A> v) {
  return v == null ? null : v.get();
}

static <A> A getVar(Optional<A> v) {
  return v == null ? null : v.orElse(null);
}


static String tag(String tag) {
  return htag(tag);
}

static String tag(String tag, Object contents, Object... params) {
  return htag(tag, str(contents), params);
}

static String tag(String tag, StringBuilder contents, Object... params) {
  return htag(tag, contents, params);
}

static String tag(String tag, StringBuffer contents, Object... params) {
  return htag(tag, contents, params);
}


static int iceil(double d) {
  return (int) Math.ceil(d);
}


static String programID() {
  return getProgramID();
}

static String programID(Object o) {
  return getProgramID(o);
}


static String masterPW() {
  return trim(loadTextFile(secretProgramFile("#1002590", "master-pw")));
}



static Object call(Object o) {
  return callF(o);
}

// varargs assignment fixer for a single string array argument
static Object call(Object o, String method, String[] arg) {
  return call(o, method, new Object[] {arg});
}

static Object call(Object o, String method, Object... args) {
  //ret call_cached(o, method, args);
  return call_withVarargs(o, method, args);
}


static byte[] toUtf8(String s) { try {
  return s.getBytes(utf8charset());
} catch (Exception __e) { throw rethrow(__e); } }


static boolean startsWithIgnoreCase(String a, String b) {
  return regionMatchesIC(a, 0, b, 0, b.length());
}




// legacy mode





//sbool ping_actions_shareable = true;
static volatile boolean ping_pauseAll = false;
static int ping_sleep = 100; // poll pauseAll flag every 100
static volatile boolean ping_anyActions = false;
static Map<Thread, Object> ping_actions = newWeakHashMap();
static ThreadLocal<Boolean> ping_isCleanUpThread = new ThreadLocal();

// ignore pingSource if not PingV3
static boolean ping(PingSource pingSource) { return ping(); }

// always returns true
static boolean ping() {
  //ifdef useNewPing
  newPing();
  //endifdef
  if (ping_pauseAll || ping_anyActions) ping_impl(true /* XXX */);
  //ifndef LeanMode ping_impl(); endifndef
  return true;
}

// returns true when it slept
static boolean ping_impl(boolean okInCleanUp) { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  if (ping_anyActions) { // don't allow sharing ping_actions
    if (!okInCleanUp && !isTrue(ping_isCleanUpThread.get()))
      failIfUnlicensed();
    Object action = null;
    synchronized(ping_actions) {
      if (!ping_actions.isEmpty()) {
        action = ping_actions.get(currentThread());
        if (action instanceof Runnable)
          ping_actions.remove(currentThread());
        if (ping_actions.isEmpty()) ping_anyActions = false;
      }
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }

  return false;
} catch (Exception __e) { throw rethrow(__e); } }




static Thread currentThread() {
  return Thread.currentThread();
}


static Map<Thread, Object> vm_threadInterruptionReasonsMap() {
  return vm_generalWeakSubMap("Thread interruption reasons");
}


static String strOr(Object o, String ifNull) {
  return o == null ? ifNull : str(o);
}


static void lockOrFail(Lock lock, long timeout) { try {
  ping();
  vmBus_send("locking", lock, "thread" , currentThread());
  if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
    String s = "Couldn't acquire lock after " + timeout + " ms.";
    if (lock instanceof ReentrantLock) {
      ReentrantLock l =  (ReentrantLock) lock;
      s += " Hold count: " + l.getHoldCount() + ", owner: " + call(l, "getOwner");
    }
    throw fail(s);
  }
  vmBus_send("locked", lock, "thread" , currentThread());
  ping();
} catch (Exception __e) { throw rethrow(__e); } }


static ReentrantLock fairLock() {
  return new ReentrantLock(true);
}


// usually L<S>
static String fromLines(Iterable lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null)
    for (Object line : lines)
      buf.append(str(line)).append('\n');
  return buf.toString();
}

static String fromLines(String... lines) {
  return fromLines(asList(lines));
}


// unclear semantics as to whether return null on null

static <A> ArrayList<A> asList(A[] a) {
  return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  if (a == null) return null;
  ArrayList<Integer> l = emptyList(a.length);
  for (int i : a) l.add(i);
  return l;
}

static ArrayList<Long> asList(long[] a) {
  if (a == null) return null;
  ArrayList<Long> l = emptyList(a.length);
  for (long i : a) l.add(i);
  return l;
}

static ArrayList<Float> asList(float[] a) {
  if (a == null) return null;
  ArrayList<Float> l = emptyList(a.length);
  for (float i : a) l.add(i);
  return l;
}

static ArrayList<Double> asList(double[] a) {
  if (a == null) return null;
  ArrayList<Double> l = emptyList(a.length);
  for (double i : a) l.add(i);
  return l;
}

static ArrayList<Short> asList(short[] a) {
  if (a == null) return null;
  ArrayList<Short> l = emptyList(a.length);
  for (short i : a) l.add(i);
  return l;
}

static <A> ArrayList<A> asList(Iterator<A> it) {
  ArrayList l = new ArrayList();
  if (it != null)
    while (it.hasNext())
      l.add(it.next());
  return l;  
}

// disambiguation
static <A> ArrayList<A> asList(IterableIterator<A> s) {
  return asList((Iterator) s);
}

static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}


static <A> ArrayList<A> asList(Producer<A> p) {
  ArrayList l = new ArrayList();
  A a;
  if (p != null) while ((a = p.next()) != null)
    l.add(a);
  return l;
}


static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}


static <A> ArrayList<A> asList(ReverseChain<A> c) {
  return c == null ? emptyList() : c.toList();
}



static <A> List<A> asList(Pair<A, A> p) {
  return p == null ? null : ll(p.a, p.b);
}



static IterableIterator<String> toLines(File f) {
  return linesFromFile(f);
}

static List<String> toLines(String s) {
  List<String> lines = new ArrayList<String>();
  if (s == null) return lines;
  int start = 0;
  while (true) {
    int i = toLines_nextLineBreak(s, start);
    if (i < 0) {
      if (s.length() > start) lines.add(s.substring(start));
      break;
    }

    lines.add(s.substring(start, i));
    if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
      i += 2;
    else
      ++i;

    start = i;
  }
  return lines;
}

static int toLines_nextLineBreak(String s, int start) {
  int n = s.length();
  for (int i = start; i < n; i++) {
    char c = s.charAt(i);
    if (c == '\r' || c == '\n')
      return i;
  }
  return -1;
}


static List<String> mapToLines(Map map) {
  List<String> l = new ArrayList();
  for (Object key : keys(map))
    l.add(str(key) + " = " + str(map.get(key)));
  return l;
}

static String mapToLines(Map map, Object f) {
  return lines(map(map, f));
}

static String mapToLines(Object f, Map map) {
  return lines(map(map, f));
}

static String mapToLines(Object f, Iterable l) {
  return lines(map(f, l));
}

static <A> String mapToLines(Iterable<A> l, IF1<A, String> f) {
  return mapToLines((Object) f, l);
}

static <A> String mapToLines(IF1<A, String> f, Iterable<A> l) {
  return mapToLines((Object) f, l);
}

static <A, B> String mapToLines(Map<A, B> map, IF2<A, B, String> f) {
  return lines(map(map, f));
}

static <A> String mapToLines(IF1<A, String> f, A data1, A... moreData) {
  return lines(map(f, data1, moreData));
}


static Set asSet(Object[] array) {
  HashSet set = new HashSet();
  for (Object o : array)
    if (o != null)
      set.add(o);
  return set;
}

static Set<String> asSet(String[] array) {
  TreeSet<String> set = new TreeSet();
  for (String o : array)
    if (o != null)
      set.add(o);
  return set;
}

static <A> Set<A> asSet(Iterable<A> l) {
  if (l instanceof Set) return (Set) l;
  HashSet<A> set = new HashSet();
  for (A o : unnull(l))
    if (o != null)
      set.add(o);
  return set;
}


// Note: does not clone the set (keeps multiset alive)
static <A> Set<A> asSet(MultiSet<A> ms) {
  return ms == null ? null : ms.asSet();
}



static List<String> toLinesFullTrim(String s) {
  
  List<String> l = new ArrayList();
  for (String line : toLines(s)) if (nempty(line = trim(line))) l.add(line);
  return l;
}

static List<String> toLinesFullTrim(File f) {
  List<String> l = new ArrayList();
  for (String line : linesFromFile(f)) if (nempty(line = trim(line))) l.add(line);
  return l;
}



static TreeSet<String> toCaseInsensitiveSet(Iterable<String> c) {
  if (isCISet(c)) return (TreeSet) c;
  TreeSet<String> set = caseInsensitiveSet();
  addAll(set, c);
  return set;
}

static TreeSet<String> toCaseInsensitiveSet(String... x) {
  TreeSet<String> set = caseInsensitiveSet();
  addAll(set, x);
  return set;
}


static <A, B> Set<A> keys(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

// convenience shortcut for keys_gen
static Set keys(Object map) {
  return keys((Map) map);
}


  static <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }



  static <A, B> Set<A> keys(IMultiMap<A, B> mm) {
    return mm.keySet();
  }





static String className(Object o) {
  return getClassName(o);
}


static List<String> sortedIgnoreCase(Collection<String> c) {
  List<String> l = cloneList(c);
  Collections.sort(l, caseInsensitiveComparator());
  return l;
}



static List collectField(Iterable c, String field) {
  List l = new ArrayList();
  if (c != null) for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}

static List collectField(String field, Iterable c) {
  return collectField(c, field);
}


static ArrayList emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}

static ArrayList emptyList(int capacity) {
  return new ArrayList(max(0, capacity));
}

// Try to match capacity
static ArrayList emptyList(Iterable l) {
  return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
}

static ArrayList emptyList(Object[] l) {
  return emptyList(l(l));
}

// get correct type at once
static <A> ArrayList<A> emptyList(Class<A> c) {
  return new ArrayList();
}


static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}


static Field makeAccessible(Field f) {
  try {
    f.setAccessible(true);
  } catch (Throwable e) {
    // Note: The error reporting only works with Java VM option --illegal-access=deny
    
    vmBus_send("makeAccessible_error", e, f);
    
  }
  return f;
}

static Method makeAccessible(Method m) {
  try {
    m.setAccessible(true);
  } catch (Throwable e) {
    
    vmBus_send("makeAccessible_error", e, m);
    
  }
  return m;
}

static Constructor makeAccessible(Constructor c) {
  try {
    c.setAccessible(true);
  } catch (Throwable e) {
    
    vmBus_send("makeAccessible_error", e, c);
    
  }
  return c;
}


static Object getOptDynOnly(DynamicObject o, String field) {
  if (o == null || o.fieldValues == null) return null;
  return o.fieldValues.get(field);
}


static RuntimeException asRuntimeException(Throwable t) {
  
  if (t instanceof Error)
    _handleError((Error) t);
  
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}


static boolean nemptyString(String s) {
  return s != null && s.length() > 0;
}


static int strL(String s) {
  return s == null ? 0 : s.length();
}


static int listL(Collection l) {
  return l == null ? 0 : l.size();
}


static boolean neq(Object a, Object b) {
  return !eq(a, b);
}


static Object subBot_serve404() {
  return call(getMainBot(), "serve404");
}

static Object subBot_serve404(String msg) {
  return call(getMainBot(), "serve404", msg);
}


static String htitle_noEncode(String title) {
  return tag("title", title);
}


static String dropTags(String html) {
  return dropAllTags(html);
}

static List<String> dropTags(List<String> tok) {
  return dropAllTags(tok);
}


static String intToHex_flexLength(int i) {
  return Integer.toHexString(i);
}


static String pre_htmlencode(Object contents, Object... params) {
  return pre(htmlencode_noQuotes(str(contents)), params);
}


static <T> void sort(T[] a, Comparator<? super T> c) {
  if (a != null) Arrays.sort(a, c);
}

static <T> void sort(T[] a) {
  if (a != null) Arrays.sort(a);
}

static void sort(int[] a) { if (a != null) Arrays.sort(a); }

static <T> void sort(List<T> a, Comparator<? super T> c) {
  if (a != null) Collections.sort(a, c);
}

static void sort(List a) {
  if (a != null) Collections.sort(a);
}


static int compareIC(String s1, String s2) {
  return compareIgnoreCase_jdk(s1, s2);
}


static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt(String field, Object o) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) { try {
  Field f = getOpt_findField(o.getClass(), field);
  if (f == null) return null;
  makeAccessible(f);
  return f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }

// access of static fields is not yet optimized
static Object getOpt(Class c, String field) { try {
  if (c == null) return null;
  Field f = getOpt_findStaticField(c, field);
  if (f == null) return null;
  makeAccessible(f);
  return f.get(null);
} catch (Exception __e) { throw rethrow(__e); } }

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}



static <A> Comparator<A> descFieldComparator(final String field) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(getOpt(b, field), getOpt(a, field));
    }
  };
}


static String h3_htitle(String s) {
  return htitle(s) + h3(s);
}


static String b(Object contents, Object... params) {
  return tag("b", contents, params);
}


public static <A> String join(String glue, Iterable<A> strings) {
  if (strings == null) return "";
  if (strings instanceof Collection) {
    if (((Collection) strings).size() == 1) return str(first((Collection) strings));
  }
  StringBuilder buf = new StringBuilder();
  Iterator<A> i = strings.iterator();
  if (i.hasNext()) {
    buf.append(i.next());
    while (i.hasNext())
      buf.append(glue).append(i.next());
  }
  return buf.toString();
}

public static String join(String glue, String... strings) {
  return join(glue, Arrays.asList(strings));
}

public static String join(String glue, Object... strings) {
  return join(glue, Arrays.asList(strings));
}

static <A> String join(Iterable<A> strings) {
  return join("", strings);
}

static <A> String join(Iterable<A> strings, String glue) {
  return join(glue, strings);
}

public static String join(String[] strings) {
  return join("", strings);
}


static String join(String glue, Pair p) {
  return p == null ? "" : str(p.a) + glue + str(p.b);
}



// if <head> block exists: put tag after <head>
// if not: add tag in front of the whole HTML
static String hAddToHead(String html, String tag) {
  List<String> tok = htmlTok(html);
  List<String> head = first(findContainerTag(tok, "head"));
  if (head == null) return tag + html;
  head.set(2, addLineBreak(tag) + head.get(2));
  return join(tok);
}


static String relativeBotLink() {
  return relativeBotLink(programID());
}

static String relativeBotLink(String botID) {
  return "/" + parseSnippetID(botID);
}

static String relativeBotLink(String botID, String uri) {
  return "/" + parseSnippetID(botID) + addPrefix("/", uri);
}



static String sfu(Object o) { return structureForUser(o); }


static Map mapValues(Object func, Map map) {
  Map m = similarEmptyMap(map);
  for (Object key : keys(map))
    m.put(key, callF(func, map.get(key)));
  return m;
}

static <A, B, C> Map<A, C> mapValues(Map<A, B> map, IF1<B, C> f) {
  return mapValues(f, map);
}

static <A, B, C> Map<A, C> mapValues(IF1<B, C> f, Map<A, B> map) {
  Map m = similarEmptyMap(map);
  for (Map.Entry<? extends A, ? extends B> __0 : _entrySet( map))
    { A key = __0.getKey(); B val = __0.getValue();  m.put(key, f.get(val)); }
  return m;
}

static Map mapValues(Map map, Object func) {
  return mapValues(func, map);
}


  static <A, B, C> MultiMap<A, C> mapValues(IF1<B, C> func, MultiMap<A, B> mm) {
    return mapMultiMapValues(func, mm);
  }
  
  static <A, B, C> MultiMap<A, C> mapValues(MultiMap<A, B> mm, IF1<B, C> func) {
    return mapValues(func, mm);
  }



// o is either a map already (string->object) or an arbitrary object,
// in which case its fields are converted into a map.
static Map<String, Object> objectToMap(Object o) { try {
  if (o instanceof Map) return (Map) o;
  
  TreeMap<String, Object> map = new TreeMap();
  Class c = o.getClass();
  while (c != Object.class) {
    Field[] fields = c.getDeclaredFields();
    for (final Field field : fields) {
      if ((field.getModifiers() & Modifier.STATIC) != 0)
        continue;
      field.setAccessible(true);
      final Object value = field.get(o);
      if (value != null)
        map.put(field.getName(), value);
    }
    c = c.getSuperclass();
  }
  
  // XXX NEW - hopefully this doesn't break anything
  if (o instanceof DynamicObject)
    putAll(map, ((DynamicObject) o).fieldValues);

  return map;
} catch (Exception __e) { throw rethrow(__e); } }

// same for a collection (convert each element)
static List<Map<String, Object>> objectToMap(Iterable l) {
  if (l == null) return null;
  List x = new ArrayList();
  for (Object o : l)
    x.add(objectToMap(o));
  return x;
}


static long ratio(long x, long y) {
  return y == 0 ? 0 : x/y;
}

static double ratio(double x, double y) {
  return y == 0 ? 0 : x/y;
}


static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
  if (map == null) return new HashMap();
  // assume mutex is equal to map
  synchronized(map) {
    return map instanceof TreeMap ? new TreeMap((TreeMap) map) // copies comparator
      : map instanceof LinkedHashMap ? new LinkedHashMap(map)
      : new HashMap(map);
  }
}

static <A, B> List<B> cloneMap(Iterable<A> l, IF1<A, B> f) {
  List x = emptyList(l);
  if (l != null) for (A o : cloneList(l))
    x.add(f.get(o));
  return x;
}


static String ymd() {
  return ymd(now());
}

static String ymd(long now) {
  return year(now) + formatInt(month(now), 2) + formatInt(dayOfMonth(now), 2);
}

static String ymd(long now, TimeZone tz) {
  return year(now, tz) + formatInt(month(now, tz), 2) + formatInt(dayOfMonth(now, tz), 2);
}




static String hms() {
  return hms(now());
}

static String hms(long time) {
  return new SimpleDateFormat("HHmmss").format(time);
}



static File getProgramFile(String progID, String fileName) {
  if (new File(fileName).isAbsolute())
    return new File(fileName);
  return new File(getProgramDir(progID), fileName);
}

static File getProgramFile(String fileName) {
  return getProgramFile(getProgramID(), fileName);
}



static String conceptsFileName() {
  return "concepts.structure.gz";
}


static String dbProgramID() {
  return getDBProgramID();
}


static <A extends Concept> Collection<A> findConceptsWhere(Class<A> c, Object... params) {
  return findConceptsWhere(db_mainConcepts(), c, params);
}

static Collection<Concept> findConceptsWhere(String c, Object... params) {
  return findConceptsWhere(db_mainConcepts(), c, params);
}

static <A extends Concept> Collection<A> findConceptsWhere(Concepts concepts, Class<A> c, Object... params) {
  ping();
  params = expandParams(c, params);
  
  // indexed
  if (concepts.fieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
      if (index != null) {
        Collection<A> rawList = index.getAll(params[i+1]);
        params = dropEntryFromParams(params, i);
        if (params == null) return rawList;
        List<A> l = new ArrayList();
        for (A x : rawList)
          if (checkConceptFields(x, params)) l.add(x);
        return l;
      }
    }
    
  // table scan
  return filterConcepts(concepts.list(c), params);
}

static Collection<Concept> findConceptsWhere(Concepts concepts, String c, Object... params) {
  return filterConcepts(concepts.list(c), params);
}


static Object[] concatArrays(Object[]... arrays) {
  int l = 0;
  for (Object[] a : arrays) l += l(a);
  Object[] x = new Object[l];
  int i = 0;
  for (Object[] a : arrays) if (a != null) {
    System.arraycopy(a, 0, x, i, l(a));
    i += l(a);
  }
  return x;
}



// grabs only the specified keys from the map.
static String hiddenFields(Map<String, String> map, Collection<String> keys) {
  StringBuilder buf = new StringBuilder();
  for (String key : keys) {
    String value = map.get(key);
    if (!empty(value))
      buf.append(htag("input", "", "type", "hidden", "name", key, "value", value) + "\n");
  }
  return str(buf);
}

static String hiddenFields(Map<String, String> map, String... keys) {
  return hiddenFields(map, asList(keys));
}


static boolean eqic(String a, String b) {
  
  
    if ((a == null) != (b == null)) return false;
    if (a == null) return true;
    return a.equalsIgnoreCase(b);
  
}


static boolean eqic(Symbol a, Symbol b) {
  return eq(a, b);
}

static boolean eqic(Symbol a, String b) {
  return eqic(asString(a), b);
}


static boolean eqic(char a, char b) {
  if (a == b) return true;
  
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2) return true;
  
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}


static void logQuoted(String logFile, String line) {
  logQuoted(getProgramFile(logFile), line);
}

static void logQuoted(File logFile, String line) {
  appendToFile(logFile, quote(line) + "\n");
}


static boolean structure_showTiming, structure_checkTokenCount;

static String structure(Object o) {
  return structure(o, new structure_Data());
}

static String structure(Object o, structure_Data d) {
  StringWriter sw = new StringWriter();
  d.out = new PrintWriter(sw);
  structure_go(o, d);
  String s = str(sw);
  if (structure_checkTokenCount) {
    print("token count=" + d.n);
    assertEquals("token count", l(javaTokC(s)), d.n);
  }
  return s;
}

static void structure_go(Object o, structure_Data d) {
  structure_1(o, d);
  while (nempty(d.stack))
    popLast(d.stack).run();
}

static void structureToPrintWriter(Object o, PrintWriter out) { structureToPrintWriter(o, out, new structure_Data()); }
static void structureToPrintWriter(Object o, PrintWriter out, structure_Data d) {
  d.out = out;
  structure_go(o, d);
}

// leave to false, unless unstructure() breaks
static boolean structure_allowShortening = false;

// info on how to serialize objects of a certain class
static class structure_ClassInfo {
  Class c;
  String shortName;
  List<Field> fields;
  Method customSerializer;
  IVF1<Object> serializeObject; // can be set by caller of structure function
  boolean special = false; // various special classes
  boolean nullInstances = false; // serialize all instances as null (e.g. lambdas/anonymous classes)
}

static class structure_Data {
  PrintWriter out;
  int stringSizeLimit;
  int shareStringsLongerThan = 20;
  boolean noStringSharing = false;
  boolean storeBaseClasses = false;
  boolean honorFieldOrder = true;
  String mcDollar = actualMCDollar();

  IdentityHashMap<Object, Integer> seen = new IdentityHashMap();
  //new BitSet refd;
  HashMap<String, Integer> strings = new HashMap();
  HashSet<String> concepts = new HashSet();
  HashMap<Class, structure_ClassInfo> infoByClass = new HashMap();
  
  // wrapper for _persistenceInfo field or _persistenceInfo method
  // by class (taking the object instance)
  HashMap<Class, IF1<Object, Map>> persistenceInfo = new HashMap();
  
  int n; // token count
  List<Runnable> stack = new ArrayList();
  
  // append single token
  structure_Data append(String token) { out.print(token); ++n; return this; }
  structure_Data append(int i) { out.print(i); ++n; return this; }
  
  // append multiple tokens
  structure_Data append(String token, int tokCount) { out.print(token); n += tokCount; return this; }
  
  // extend last token
  structure_Data app(String token) { out.print(token); return this; }
  structure_Data app(int i) { out.print(i); return this; }

  structure_ClassInfo infoForClass(Class c) {
    structure_ClassInfo info = infoByClass.get(c);
    if (info == null) info = newClass(c);
    return info;
  }
  
  // called when a new class is detected
  // can be overridden by clients
  structure_ClassInfo newClass(Class c) {
    structure_ClassInfo info = new structure_ClassInfo();
    info.c = c;
    infoByClass.put(c, info);
    
    String name = c.getName();
    String shortName = dropPrefix("loadableUtils.utils$", dropPrefix(mcDollar, name));
    if (startsWithDigit(shortName)) shortName = name; // for anonymous classes
    info.shortName = shortName;
    
    try {
      if (isSyntheticOrAnonymous(c)) {
        info.special = info.nullInstances = true;
        return info;
      }
      
      if (c.isEnum()) {
        info.special = true;
        return info;
      }
      
      if ((info.customSerializer = findMethodNamed(c, "_serialize"))
        != null) info.special = true;
        
      if (storeBaseClasses) {
        Class sup = c.getSuperclass();
        if (sup != Object.class) {
          append("bc ");
          append(shortDynClassNameForStructure(c));
          out.print(" ");
          append(shortDynClassNameForStructure(sup));
          out.print(" ");
          infoForClass(sup); // transitively write out superclass relations
        }
      }
      
      if (!isPersistableClass(c))
        warn("Class not persistable: " + c + " (anonymous or no default constructor)");
    } catch (Throwable e) { printStackTrace(e);
      info.nullInstances = true;
    }
    
    return info;
  }
  
  void setFields(structure_ClassInfo info, List<Field> fields) { 
    info.fields = fields;
  }
  
  void writeObject(Object o, String shortName, Map<String, Object> fv) {
    String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
  
    append(shortName);
    n += countDots(shortName)*2; // correct token count
    
  
    int l = n;
    Iterator it = fv.entrySet().iterator();
    
    stack.add(new Runnable() {  public void run() { try { 
      if (!it.hasNext()) {
        if (n != l)
          append(")");
      } else {
        Map.Entry e = (Map.Entry) it.next();
        append(n == l ? "(" : ", ");
        append((String) e.getKey()).append("=");
        stack.add(this);
        structure_1(e.getValue(), structure_Data.this);
      }
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext()) {\r\n        if (n != l)\r\n          append(\")\");\r\n      } el..."; }});
  }
}

static void structure_1(final Object o, final structure_Data d) { try {
  if (o == null) { d.append("null"); return; }
  
  Class c = o.getClass();
  boolean concept = false;
  
    concept = o instanceof Concept;
  
  structure_ClassInfo info = d.infoForClass(c);
  
  List<Field> lFields = info.fields;
  if (lFields == null) {
    // these are never back-referenced (for readability)
    
    if (o instanceof Number) {
      PrintWriter out = d.out;
if (o instanceof Integer) { int i = ((Integer) o).intValue(); out.print(i); d.n += i < 0 ? 2 : 1; return; }
      if (o instanceof Long) { long l = ((Long) o).longValue(); out.print(l); out.print("L"); d.n += l < 0 ? 2 : 1; return; }
      if (o instanceof Short) { short s = ((Short) o).shortValue(); d.append("sh "); out.print(s); d.n += s < 0 ? 2 : 1; return; }
      if (o instanceof Float) { d.append("fl ", 2); quoteToPrintWriter(str(o), out); return; }
      if (o instanceof Double) { d.append("d(", 3); quoteToPrintWriter(str(o), out); d.append(")"); return; }
      if (o instanceof BigInteger) { out.print("bigint("); out.print(o); out.print(")"); d.n += ((BigInteger) o).signum() < 0 ? 5 : 4; return; }
    }
  
    if (o instanceof Boolean) {
      d.append(((Boolean) o).booleanValue() ? "t" : "f"); return;
    }
      
    if (o instanceof Character) {
      d.append(quoteCharacter((Character) o)); return;
    }
      
    if (o instanceof File) {
      d.append("File ").append(quote(((File) o).getPath())); return;
    }
      
    // referencable objects follow
    
    Integer ref = d.seen.get(o);
    if (o instanceof String && ref == null) ref = d.strings.get((String) o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }

    if (!(o instanceof String))
      d.seen.put(o, d.n); // record token number
    else {
      String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
      if (!d.noStringSharing) {
        if (d.shareStringsLongerThan == Integer.MAX_VALUE)
          d.seen.put(o, d.n);
        if (l(s) >= d.shareStringsLongerThan)
          d.strings.put(s, d.n);
      }
      quoteToPrintWriter(s, d.out); d.n++; return;
    }
      
    if (o instanceof Set) {
      /*O set2 = unwrapSynchronizedSet(o);
      if (set2 != o) {
        d.append("sync");
        o = set2;
      } TODO */
      
      if (((Set) o) instanceof TreeSet) {
        d.append(isCISet_gen((Set) o) ? "ciset" : "treeset");
        structure_1(new ArrayList((Set) o), d);
        return;
      }
      
      // assume it's a HashSet or LinkedHashSet
      d.append(((Set) o) instanceof LinkedHashSet ? "lhs" : "hashset");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
    
    String name = c.getName();
    
    if (o instanceof Collection
      && !isJavaXClassName(name)
      /* && neq(name, "main$Concept$RefL") */) {
      
      // it's a list
    
      if (name.equals("java.util.Collections$SynchronizedList")
        || name.equals("java.util.Collections$SynchronizedRandomAccessList")) {
        d.append("sync ");
        { structure_1(unwrapSynchronizedList(((List) o)), d); return; }
      }
      else if (name.equals("java.util.LinkedList")) d.append("ll");
      d.append("[");
      final int l = d.n;
      final Iterator it = cloneList((Collection) o).iterator();
      d.stack.add(new Runnable() {  public void run() { try { 
        if (!it.hasNext())
          d.append("]");
        else {
          d.stack.add(this);
          if (d.n != l) d.append(", ");
          structure_1(it.next(), d);
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.sta..."; }});
      return;
    }
    
    
      if (o instanceof SynchronizedMap) {
        d.append("sync ");
        { structure_1(((SynchronizedMap) o).m, d); return; }
      }
    

    
    if (o instanceof Map && !startsWith(name, d.mcDollar)) {
      if (o instanceof LinkedHashMap) d.append("lhm");
      else if (o instanceof HashMap) d.append("hm");
      else if (o instanceof TreeMap)
        d.append(isCIMap_gen((TreeMap) o) ? "cimap" : "tm");
      else if (name.equals("java.util.Collections$SynchronizedMap")
        || name.equals("java.util.Collections$SynchronizedSortedMap")
        || name.equals("java.util.Collections$SynchronizedNavigableMap")) {
        d.append("sync "); 
        { structure_1(unwrapSynchronizedMap(((Map) o)), d); return; }
      }
      
      d.append("{");
      final int l = d.n;
      final Iterator it = cloneMap((Map) o).entrySet().iterator();
      
      d.stack.add(new Runnable() {
        boolean v = false;
        Map.Entry e;
        
        public void run() {
          if (v) {
            d.append("=");
            v = false;
            d.stack.add(this);
            structure_1(e.getValue(), d);
          } else {
            if (!it.hasNext())
              d.append("}");
            else {
              e = (Map.Entry) it.next();
              v = true;
              d.stack.add(this);
              if (d.n != l) d.append(", ");
              structure_1(e.getKey(), d);
            }
          }
        }
      });
      return;
    }
    
    if (c.isArray()) {
      if (o instanceof byte[]) {
        d.append("ba ").append(quote(bytesToHex((byte[]) o))); return;
      }
  
      final int n = Array.getLength(o);
  
      if (o instanceof boolean[]) {
        String hex = boolArrayToHex((boolean[]) o);
        int i = l(hex);
        while (i > 0 && hex.charAt(i-1) == '0' && hex.charAt(i-2) == '0') i -= 2;
        d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i))); return;
      }
      
      String atype = "array"/*, sep = ", "*/; // sep is not used yet
  
      if (o instanceof int[]) {
        //ret "intarray " + quote(intArrayToHex((int[]) o));
        atype = "intarray";
        //sep = " ";
      } else if (o instanceof double[]) {
        atype = "dblarray";
        //sep = " ";
      } else {
        Pair<Class, Integer> p = arrayTypeAndDimensions(c);
        if (p.a == int.class) atype = "intarray";
        else if (p.a == byte.class) atype = "bytearray";
        else if (p.a == boolean.class) atype = "boolarray";
        else if (p.a == double.class) atype = "dblarray";
        else if (p.a == String.class) { atype = "array S"; d.n++; }
        else atype = "array"; // fail("Unsupported array type: " + p.a);
        if (p.b > 1) {
          atype += "/" + p.b; // add number of dimensions
          d.n += 2; // 2 additional tokens will be written
        }
      }
      
      d.append(atype).append("{");
      d.stack.add(new Runnable() {
        int i;
        public void run() {
          if (i >= n)
            d.append("}");
          else {
            d.stack.add(this);
            if (i > 0) d.append(", ");
            structure_1(Array.get(o, i++), d);
          }
        }
      });
      return;
    }
  
    if (o instanceof Class) {
      d.append("class(", 2).append(quote(((Class) o).getName())).append(")"); return;
    }
      
    if (o instanceof Throwable) {
      d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")"); return;
    }
      
    if (o instanceof BitSet) {
      BitSet bs = (BitSet) o;
      d.append("bitset{", 2);
      int l = d.n;
      for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i+1)) {
        if (d.n != l) d.append(", ");
        d.append(i);
      }
      d.append("}"); return;
    }
      
    // Need more cases? This should cover all library classes...
    if (name.startsWith("java") || name.startsWith("sun")) {
      d.append("j ").append(quote(str(o))); return; // Hm. this is not unstructure-able except for java.awt.Color
    }
    
    
      
    /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
    
    if (info.special) {
      if (c.isEnum()) {
        d.append("enum ");
        d.append(info.shortName);
        d.out.append(' ');
        d.append(((Enum) o).ordinal());
        return;
      }
      
      if (info.customSerializer != null) {
        // custom serialization (_serialize method)
        Object o2 = invokeMethod(info.customSerializer, o);
        d.append("cu ");
        String shortName = dropPrefix(d.mcDollar, name);
        d.append(shortName);
        d.out.append(' ');
        structure_1(o2, d);
        return;
      } else if (info.nullInstances) { d.append("null"); return; }
      else if (info.serializeObject != null)
        { info.serializeObject.get(o); return; }
      else throw fail("unknown special type");
    }
    
    String dynName = shortDynClassNameForStructure(o);
    if (concept && !d.concepts.contains(dynName)) {
      d.concepts.add(dynName);
      d.append("c ");
    }
    
    // serialize an object with fields.
    // first, collect all fields and values in fv.
    
    TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {
      public int compare(Field a, Field b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    
    Class cc = c;
    while (cc != Object.class) {
      for (Field field : getDeclaredFields_cached(cc)) {
        String fieldName = field.getName();
        if (fieldName.equals("_persistenceInfo"))
          d.persistenceInfo.put(c, obj -> (Map) fieldGet(field, obj));
        if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
          continue;

        fields.add(field);
        
        // put special cases here...?
      }
        
      cc = cc.getSuperclass();
    }
    
    Method persistenceInfoMethod = findInstanceMethod(c, "_persistenceInfo");
    if (persistenceInfoMethod != null)
      d.persistenceInfo.put(c, obj -> (Map) invokeMethod(persistenceInfoMethod, obj));
    
    lFields = asList(d.honorFieldOrder ? fieldObjectsInFieldOrder(c, fields) : fields);

    // Render this$0/this$1 first because unstructure needs it for constructor call.
    
    int n = l(lFields);
    for (int i = 0; i < n; i++) {
      Field f = lFields.get(i);
      if (f.getName().startsWith("this$")) {
        lFields.remove(i);
        lFields.add(0, f);
        break;
      }
    }
  
    
    d.setFields(info, lFields);
  } // << if (lFields == null)
  else { // ref handling for lFields != null
    Integer ref = d.seen.get(o);
    if (ref != null) { /*d.refd.set(ref);*/ d.append("t").app(ref); return; }
    d.seen.put(o, d.n); // record token number
  }

  // get _persistenceInfo from field and/or dynamic field
  IF1<Object, Map> piGetter = d.persistenceInfo.get(c);
  Map persistenceInfo = piGetter == null ? null : piGetter.get(o);
  
  if (piGetter == null && o instanceof DynamicObject)
    persistenceInfo = (Map) getOptDynOnly(((DynamicObject) o), "_persistenceInfo");

  
  LinkedHashMap<String, Object> fv = new LinkedHashMap();
  for (Field f : lFields) {
    Object value;
    try {
      value = f.get(o);
    } catch (Exception e) {
      value = "?";
    }
      
    if (value != null && (persistenceInfo == null
      || !Boolean.FALSE.equals(persistenceInfo.get(f.getName()))))
      fv.put(f.getName(), value);
    
  }
  
  String shortName = info.shortName;
    
  // Now we have fields & values. Process fieldValues if it's a DynamicObject.
  
  // omit field "className" if equal to class's name
  if (concept && eq(fv.get("className"), shortName))
    fv.remove("className");
          
  if (o instanceof DynamicObject) {
    putAll(fv, (Map) fv.get("fieldValues"));
    fv.remove("fieldValues");
    if (((DynamicObject) o).className != null) {
      // TODO: this probably doesn't work with inner classes
      shortName = shortDynClassNameForStructure((DynamicObject) o);
      fv.remove("className");
    }
  }
  
  d.writeObject(o, shortName, fv);
} catch (Exception __e) { throw rethrow(__e); } }



static int[] emptyIntArray_a = new int[0];
static int[] emptyIntArray() { return emptyIntArray_a; }


static char[] emptyCharArray = new char[0];
static char[] emptyCharArray() { return emptyCharArray; }


static double[] emptyDoubleArray = new double[0];
static double[] emptyDoubleArray() { return emptyDoubleArray; }


static Map emptyMap() {
  return new HashMap();
}


static Object[] emptyObjectArray_a = new Object[0];
static Object[] emptyObjectArray() { return emptyObjectArray_a; }


static Symbol emptySymbol_value;

static Symbol emptySymbol() {
  if (emptySymbol_value == null) emptySymbol_value = symbol("");
  return emptySymbol_value;
}


  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }



static boolean md5OfFile_verbose = false;

static String md5OfFile(String path) {
  return md5OfFile(newFile(path));
}

static String md5OfFile(File f) { try {
  if (!f.exists()) return "-";
  
  if (md5OfFile_verbose)
    print("Getting MD5 of " + f);
  
  MessageDigest md5 = MessageDigest.getInstance("MD5");
   FileInputStream in = new FileInputStream(f); try {

  byte buf[] = new byte[65536];
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    md5.update(buf, 0, l);
  }
  
  return bytesToHex(md5.digest());
} finally { _close(in); }} catch (Exception __e) { throw rethrow(__e); } }


public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}



static String programID;
static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}


// TODO: ask JavaX instead
static String getProgramID(Class c) {
  String id = (String) getOpt(c, "programID");
  if (nempty(id))
    return formatSnippetID(id);
  return "?";
}


static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}


static String addPrefix(String prefix, String s) {
  return s.startsWith(prefix) ? s : prefix + s;
}


static String makeRandomID(int length) {
  return makeRandomID(length, defaultRandomGenerator());
}

static String makeRandomID(int length, Random random) {
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}

static String makeRandomID(Random r, int length) {
  return makeRandomID(length, r);
}


static Object[] html_massageAutofocusParam(Object[] params) {
  Object autofocus = optPar("autofocus", params);
  return changeParam(params, "autofocus" , eqOneOf(autofocus, html_valueLessParam(), true, 1, "1", "autofocus") ? html_valueLessParam() : null);
}


static String hopeningTag(String tag, Map params) {
  return hopeningTag(tag, mapToParams(params));
}

static String hopeningTag(String tag, Object... params) {
  StringBuilder buf = new StringBuilder();
  buf.append("<" + tag);
  params = unrollParams(params);
  for (int i = 0; i < l(params); i += 2) {
    String name = (String) get(params, i);
    Object val = get(params, i+1);
    if (nempty(name) && val != null) {
      if (eqOneOf(val, html_valueLessParam(), true))
        buf.append(" " + name);
      else {
        String s = str(val);
        if (!empty(s))
          buf.append(" " + name + "=" + htmlQuote(s));
      }
    }
  }
  buf.append(">");
  return str(buf);
}


static boolean regionMatches(String a, int offsetA, String b, int offsetB, int len) {
  return a != null && b != null && a.regionMatches(offsetA, b, offsetB, len);
}

static boolean regionMatches(String a, int offsetA, String b) {
  return regionMatches(a, offsetA, b, 0, l(b));
}


static String javaTok_substringN(String s, int i, int j) {
  if (i == j) return "";
  if (j == i+1 && s.charAt(i) == ' ') return " ";
  return s.substring(i, j);
}


static String javaTok_substringC(String s, int i, int j) {
  return s.substring(i, j);
}


static List<String> javaTokWithExisting(String s, List<String> existing) {
  ++javaTok_n;
  int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
  ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    // Special JavaX syntax: 'identifier
    if (c == '\'' && Character.isJavaIdentifierStart(d) && i+2 < l && "'\\".indexOf(s.charAt(i+2)) < 0) {
      j += 2;
      while (j < l && Character.isJavaIdentifierPart(s.charAt(j)))
        ++j;
    } else if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    if (n < nExisting && javaTokWithExisting_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static boolean javaTokWithExisting_isCopyable(String t, String s, int i, int j) {
  return t.length() == j-i
    && s.regionMatches(i, t, 0, j-i); // << could be left out, but that's brave
}






  static Map<String, String[]> javaTokForJFind_array_cache = synchronizedMRUCache(1000);


static String[] javaTokForJFind_array(String s) {
  String[] tok = javaTokForJFind_array_cache.get(s);
  if (tok == null)
    javaTokForJFind_array_cache.put(s, tok = codeTokensAsStringArray(jfind_preprocess(javaTok(s))));
  return tok;
}




// Note: In the transpiler, this version is used: #1025802

static int findCodeTokens(List<String> tok, String... tokens) {
  return findCodeTokens(tok, 1, false, tokens);
}

static int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, 1, ignoreCase, tokens);
}

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
}

static HashSet<String> findCodeTokens_specials = lithashset("*", "<quoted>", "<id>", "<int>", "\\*");
static int findCodeTokens_bails, findCodeTokens_nonbails;

static interface findCodeTokens_Matcher {
  boolean get(String token);
}

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
  int end = tok.size()-tokens.length*2+2, nTokens = tokens.length;
  int i = startIdx | 1;
  if (i >= end) return -1;
  
  // bail out early if first token not found (works great with IndexedList)
  String firstToken = tokens[0];
  if (!ignoreCase && !findCodeTokens_specials.contains(firstToken)) {
    
    
    // quickly scan for first token
    while (i < end && !firstToken.equals(tok.get(i)))
      i += 2;
  }
  
  findCodeTokens_Matcher[] matchers = new findCodeTokens_Matcher[nTokens];
  for (int j = 0; j < nTokens; j++) {
    String p = tokens[j];
    findCodeTokens_Matcher matcher;
    if (p.equals("*"))
      matcher = t -> true;
    else if (p.equals("<quoted>"))
      matcher = t -> isQuoted(t);
    else if (p.equals("<id>"))
      
      
      matcher = t -> isIdentifier(t);
      
    else if (p.equals("<int>"))
      
      
      matcher = t -> isInteger(t);
      
    else if (p.equals("\\*"))
      matcher = t -> t.equals("*");
    else if (ignoreCase)
      matcher = t -> eqic(p, t);
    else
      matcher = t -> t.equals(p);
    matchers[j] = matcher;
  }
 
  outer: for (; i < end; i += 2) {
    for (int j = 0; j < nTokens; j++)
      if (!matchers[j].get(tok.get(i+j*2)))
        continue outer;

    if (condition == null || checkTokCondition(condition, tok, i-1)) // pass N index
      return i;
  }
  return -1;
}


// "$1" is first code token, "$2" second code token etc.
static String jreplaceExpandRefs(String s, List<String> tokref) {
  if (!contains(s, '$')) return s;
  List<String> tok = javaTok(s);
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (t.startsWith("$") && isInteger(t.substring(1))) {
      String x = tokref.get(-1+parseInt(t.substring(1))*2);
      tok.set(i, x);
    } else if (t.equals("\\")) {
      tok.set(i, "");
      i += 2;
    }
  }
  return join(tok);
}



  static void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++)
      tok.set(i, "");
  }
  
  static void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++)
      tok.set(i, "");
  }


static List<String> reTok(List<String> tok) {
  replaceCollection(tok, javaTok(tok));
  return tok;
}

static List<String> reTok(List<String> tok, int i) {
  return reTok(tok, i, i+1);
}

static List<String> reTok(List<String> tok, int i, int j) {
  // extend i to an "N" token
  // and j to "C" (so j-1 is an "N" token)
  i = max(i & ~1, 0);
  j = min(l(tok), j | 1);
  if (i >= j) return tok;
  
  List<String> t = javaTok(joinSubList(tok, i, j));
  replaceListPart(tok, i, j, t);
  
  // fallback to safety
  // reTok(tok);
  
  return tok;
}




static ITokCondition tokCondition(IIntPred condition) {
  return condition == null ? null : (tok, nIdx) -> condition.get(nIdx);
}


static String[] codeTokensAsStringArray(List<String> tok) {
  int n = max(0, (l(tok)-1)/2);
  String[] out = new String[n];
  for (int i = 0; i < n; i++)
    out[i] = tok.get(i*2+1);
  return out;
}


static <A> ArrayList<A> litlist(A... a) {
  ArrayList l = new ArrayList(a.length);
  for (A x : a) l.add(x);
  return l;
}


// syntax 1: replace all occurrences of x in l with y
static <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
  if (x == null) return l;
  
  int i = 0;
  while (true) {
    i = indexOfSubList(l, x, i);
    if (i < 0) break;
    
    replaceSublist(l, i, i+l(x), y);
    i += l(y);
  }
  return l;
}

// syntax 2: splice l at fromIndex-toIndex and replace middle part with y
static <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
  int n = y.size(), toIndex_new = fromIndex+n;
  if (toIndex_new < toIndex) {
    removeSubList(l, toIndex_new, toIndex);
    copyListPart(y, 0, l, fromIndex, n);
  } else {
    copyListPart(y, 0, l, fromIndex, toIndex-fromIndex);
    if (toIndex_new > toIndex)
      l.addAll(toIndex, subList(y, toIndex-fromIndex));
  }
  return l;
}




static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(int startIndex, List<A> l) {
  return subList(l, startIndex);
}

static <A> List<A> subList(int startIndex, int endIndex, List<A> l) {
  return subList(l, startIndex, endIndex);
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = Math.max(0, startIndex);
  endIndex = Math.min(n, endIndex);
  if (startIndex > endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  
  
    return l.subList(startIndex, endIndex);
  
}




static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}

static int min(int[] c) {
  int x = Integer.MAX_VALUE;
  for (int d : c) if (d < x) x = d;
  return x;
}


static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  int n = l(l);
  for (int i = startIndex; i < n; i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, int startIndex, A a) {
  return indexOf(l, a, startIndex);
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b) {
  return a == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, int i, char b) {
  return indexOf(a, b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  int n = l(x);
  for (int i = 0; i < n; i++)
    if (eq(x[i], a))
      return i;
  return -1;
}

static <A> int indexOf(Iterable<A> l, A a) {
  if (l == null) return -1;
  int i = 0;
  for (A x : l) {
    if (eq(x, a))
      return i;
    i++;
  }
  return -1;
}



// params arrays can also be null
static String htableRaw2(List<? extends List> data, List paramsTable, List paramsTR, List paramsTD) {
  StringBuilder buf = new StringBuilder();
  for (List row : data) {
    buf.append(hopeningTag("tr", toObjectArray(paramsTR)));
    for (Object cell : row)
      buf.append(htd(cell, toObjectArray(paramsTD))).append("\n");
    buf.append("</tr>\n");
  }
  return htag("table", buf, toObjectArray(paramsTable));
}


static String hfulltag(String tag) {
  return hfulltag(tag, "");
}

static String hfulltag(String tag, Object contents, Object... params) {
  return hopeningTag(tag, params) + str(contents) + "</" + tag + ">";
}


// one array plus more elements
static Object[] arrayPlus(Object[] a1, Object... a2) {
  return concatArrays(a1, a2);
}


static String htmlencode_noQuotes(String s) {
  if (s == null) return "";
  int n = s.length();
  StringBuilder out = null;
  
  
  
  for (int i = 0; i < n; i++) {
    char c = s.charAt(i);
    if (c == '<') {
      
    if (out == null) out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
    out
  .append("&lt;");
    }
    else if (c == '>') {
      
    if (out == null) out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
    out
  .append("&gt;");
    }
    else if (c > 127 || c == '&') {
      int cp = s.codePointAt(i);
      
    if (out == null) out = new StringBuilder(Math.max(16, n)).append(takeFirst(i, s));
    out
  .append("&#x");
      out.append(intToHex_flexLength(cp));
      out.append(';');
      i += Character.charCount(cp)-1;
    } else
      { if (out != null) out.append(c); }
  }
  return out == null ? s : out.toString();
}


static String href(String link, Object contents, Object... params) {
  if (link == null) return str(contents);
  return hfulltag("a", contents, arrayPlus(params, "href", link));
}


static boolean odd(int i) {
  return (i & 1) != 0;
}

static boolean odd(long i) {
  return (i & 1) != 0;
}

static boolean odd(BigInteger i) { return odd(toInt(i)); }


static String[] dropFirst(int n, String[] a) {
  return drop(n, a);
}

static String[] dropFirst(String[] a) {
  return drop(1, a);
}

static Object[] dropFirst(Object[] a) {
  return drop(1, a);
}

static <A> List<A> dropFirst(List<A> l) {
  return dropFirst(1, l);
}

static <A> List<A> dropFirst(int n, Iterable<A> i) { return dropFirst(n, toList(i)); }
static <A> List<A> dropFirst(Iterable<A> i) { return dropFirst(toList(i)); }

static <A> List<A> dropFirst(int n, List<A> l) {
  return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
}

static <A> List<A> dropFirst(List<A> l, int n) {
  return dropFirst(n, l);
}

static String dropFirst(int n, String s) { return substring(s, n); }
static String dropFirst(String s, int n) { return substring(s, n); }
static String dropFirst(String s) { return substring(s, 1); }


static <A> Chain<A> dropFirst(Chain<A> c) {
  return c == null ? null : c.next;
}



static String hcommentSafe(String text) {
  return hcomment_unescaped(contains(text, "-->") ? htmlencode(text) : text);
}


static String formatWithThousands(long l) {
  return formatWithThousandsSeparator(l);
}


static double fraction(double d) {
  return d % 1;
}


static String n_fancy2(long l, String singular, String plural) {
  return formatWithThousandsSeparator(l) + " " + trim(l == 1 ? singular : plural);
}

static String n_fancy2(Collection l, String singular, String plural) {
  return n_fancy2(l(l), singular, plural);
}

static String n_fancy2(Map m, String singular, String plural) {
  return n_fancy2(l(m), singular, plural);
}

static String n_fancy2(Object[] a, String singular, String plural) {
  return n_fancy2(l(a), singular, plural);
}


  static String n_fancy2(MultiSet ms, String singular, String plural) {
    return n_fancy2(l(ms), singular, plural);
  }



static <A> int iteratorCount_int_close(Iterator<A> i) { try {
  int n = 0;
  if (i != null) while (i.hasNext()) { i.next(); ++n; }
  if (i instanceof AutoCloseable) ((AutoCloseable) i).close();
  return n;
} catch (Exception __e) { throw rethrow(__e); } }


static String htableRaw(List<? extends List> data, Object... params) {
  StringBuilder buf = new StringBuilder();
  for (List row : data) {
    buf.append("<tr>");
    for (Object cell : row)
      buf.append(htd(cell)).append("\n");
    buf.append("</tr>\n");
  }
  return htag("table", buf, params);
}


static String htag(String tag) {
  return htag(tag, "");
}

static String htag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  if (empty(s) && neqic(tag, "script"))
    return dropLast(openingTag) + "/>";
  return openingTag + s + "</" + tag + ">";
}


// TODO: if field is a Ref<>, you can thoretically use findBackRefs

static <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
  return findConceptWhere(db_mainConcepts(), c, params);
}

static <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
  ping();
  params = expandParams(c, params);
  
  // indexed
  if (concepts.fieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
      if (index != null) {
        for (A x : index.getAll(params[i+1]))
          if (checkConceptFields(x, params)) return x;
        return null;
      }
    }
    
  // table scan
  for (A x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}

static Concept findConceptWhere(Concepts concepts, String c, Object... params) {
  for (Concept x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}



static HashMap<String, Class> findClass_cache = new HashMap();

// currently finds only inner classes of class "main"
// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass(String name) {
  synchronized(findClass_cache) {
    if (findClass_cache.containsKey(name))
      return findClass_cache.get(name);
      
    if (!isJavaIdentifier(name)) return null;
    
    Class c;
    try {
      c = Class.forName("main$" + name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_cache.put(name, c);
    return c;
  }
}


static Object nuObject(String className, Object... args) { try {
  return nuObject(classForName(className), args);
} catch (Exception __e) { throw rethrow(__e); } }

// too ambiguous - maybe need to fix some callers
/*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/

static <A> A nuObject(Class<A> c, Object... args) { try {
  if (args == null || args.length == 0) return nuObjectWithoutArguments(c); // cached!
  
  Constructor m = nuObject_findConstructor(c, args);
  makeAccessible(m);
  return (A) m.newInstance(args);
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObject_findConstructor(Class c, Object... args) {
  for (Constructor m : getDeclaredConstructors_cached(c)) {
    if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
      continue;
    return m;
  }
  throw fail("Constructor " + c.getName() + getClasses(args) + " not found"
    + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
}

 static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }


static int csetAll(Concept c, Object... values) {
  return cset(c, values);
}

static int csetAll(Iterable<? extends Concept> l, Object... values) {
  int n = 0;
  for (Concept c : unnullForIteration(l))
    n += cset(c, values);
  return n;
}

static int csetAll(Concept c, Map<String, Object> values) {
  int n = 0;
  for (Map.Entry<? extends String, ? extends Object> __0 : _entrySet( values))
    { String field = __0.getKey(); Object value = __0.getValue();  n += cset(c, field, value); }
  return n;
}


static <A> List<A> withoutNulls(Iterable<A> l) {
  if (l instanceof List)
    if (!containsNulls((List) l)) return ((List) l);
  List<A> l2 = new ArrayList();
  for (A a : l)
    if (a != null)
      l2.add(a);
  return l2;
}

static <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
  Map<A, B> map2 = similarEmptyMap(map);
  for (A a : keys(map))
    if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
  return map2;
}

static <A> List<A> withoutNulls(A[] l) {
  List<A> l2 = new ArrayList();
  if (l != null) for (A a : l)
    if (a != null)
      l2.add(a);
  return l2;
}


static int[] subArray(int[] b, int start, int end) {
  int[] x = new int[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}

static byte[] subArray(byte[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start >= end) return new byte[0];
  byte[] x = new byte[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}

static short[] subArray(short[] b, int start, int end) {
  if (start <= 0 && end >= l(b)) return b;
  short[] x = new short[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}

static float[] subArray(float[] b, int start, int end) {
  float[] x = new float[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}

static Object[] subArray(Object[] b, int start) {
  return subArray(b, start, l(b));
}

static Object[] subArray(Object[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start >= end) return new Object[0];
  Object[] x = new Object[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}


static String containerTag(String tag) { return containerTag(tag, ""); }

static String containerTag(String tag, Object contents, Object... params) {
  String openingTag = hopeningTag(tag, params);
  String s = str(contents);
  return openingTag + s + "</" + tag + ">";
}


static String guessGermanOrEnglish(String text) {
  Set<String> set1 = mechCISet("English words");
  Set<String> set2 = mechCISet("Deutsche Wörter");
  int score = 0;
  for (String word : words(text))
    score += zeroOne(set1.contains(word))-zeroOne(set2.contains(word));
  return score > 0 ? "english" : score < 0 ? "german" : null;
}


static String strOrNull(Object o) {
  return o == null ? null : str(o);
}


static String replacePlusWithSpace(String s) {
  return replace(s, '+', ' ');
}


static List<String> splitAtSpace(String s) {
  return empty(s) ? emptyList() : asList(s.split("\\s+"));
}


static int scoredSearch_score_single(String s, String query) {
  int i = indexOfIC_underscore(s, query);
  if (i < 0) return 0;
  if (i > 0) return 1;
  return l(s) == l(query) ? 3 : 2;
}


static <A, B> Comparator<A> mapComparatorDesc(final Map<A, B> map) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(map.get(b), map.get(a));
    }
  };
}


static boolean isInteger(String s) {
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  if (s.charAt(0) == '-')
    if (++i >= n) return false;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}


static int parseInt(String s) {
  return emptyString(s) ? 0 : Integer.parseInt(s);
}

static int parseInt(char c) {
  return Integer.parseInt(str(c));
}


static <A> List<A> newSubListOrSame(List<A> l, int startIndex) {
  return newSubListOrSame(l, startIndex, l(l));
}

static <A> List<A> newSubListOrSame(List<A> l, int startIndex, int endIndex) {
  if (l == null) return null;
  int n = l(l);
  startIndex = max(0, startIndex);
  endIndex = min(n, endIndex);
  if (startIndex >= endIndex) return ll();
  if (startIndex == 0 && endIndex == n) return l;
  return cloneList(l.subList(startIndex, endIndex));
}




static CharSequence subCharSequence(CharSequence s, int x) {
  return subCharSequence(s, x, s == null ? 0 : s.length());
}

static CharSequence subCharSequence(CharSequence s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x >= s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.subSequence(x, y);
}


static int[] takeFirstOfIntArray(int[] b, int n) {
  return subIntArray(b, 0, n);
}

static int[] takeFirstOfIntArray(int n, int[] b) {
  return takeFirstOfIntArray(b, n);
}


static short[] takeFirstOfShortArray(short[] b, int n) {
  return subShortArray(b, 0, n);
}

static short[] takeFirstOfShortArray(int n, short[] b) {
  return takeFirstOfShortArray(b, n);
}


static byte[] takeFirstOfByteArray(byte[] b, int n) {
  return subByteArray(b, 0, n);
}

static byte[] takeFirstOfByteArray(int n, byte[] b) {
  return takeFirstOfByteArray(b, n);
}


static double[] takeFirstOfDoubleArray(double[] b, int n) {
  return subDoubleArray(b, 0, n);
}

static double[] takeFirstOfDoubleArray(int n, double[] b) {
  return takeFirstOfDoubleArray(b, n);
}


static int lCharSequence(CharSequence s) {
  return s == null ? 0 : s.length();
}


// TODO: JDK 17!! ?? No! Yes? Yes!!

static Object collectionMutex(List l) {
  return l;
}

static Object collectionMutex(Object o) {
  

  if (o instanceof List) return o;
  
  // TODO: actually use our own maps so we can get the mutex properly
  
  String c = className(o);
  
    
  
    
  
  return o;
}


static Set similarEmptySet(Iterable m) {
  if (m instanceof TreeSet) return new TreeSet(((TreeSet) m).comparator());
  if (m instanceof LinkedHashSet) return new LinkedHashSet();
  
  return new HashSet();
}

static Set similarEmptySet(Map m) {
  if (m instanceof TreeMap) return new TreeSet(((TreeMap) m).comparator());
  if (m instanceof LinkedHashMap) return new LinkedHashSet();
  
  return new HashSet();
}


static String getClassName(Object o) {
  return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
}


static String ltrim(String s) {
  if (s == null) return null;
  int i = 0;
  while (i < s.length() && " \t\r\n".indexOf(s.charAt(i)) >= 0)
    ++i;
  return i > 0 ? substring(s, i) : s;
}


static String aGlobalID() {
  return randomID(globalIDLength());
}

static String aGlobalID(Random random) {
  return randomID(random, globalIDLength());
}


static String dropPrefix(String prefix, String s) {
  return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
}


static <A> A setThreadLocal(ThreadLocal<A> tl, A value) {
  if (tl == null) return null;
  A old = tl.get();
  tl.set(value);
  return old;
}


static boolean containsStartingWith(Collection<String> l, String prefix) {
  for (String s : unnullForIteration(l))
    if (startsWith(s, prefix))
      return true;
  return false;
}


static String appendWithNewLine(String a, String b) {
  if (empty(b)) return a;
  if (empty(a)) return b;
  return addSuffix(a, "\n") + b;
}




static ThreadLocal<Object> print_byThread() {
  synchronized(print_byThread_lock) {
    if (print_byThread == null)
      print_byThread = new ThreadLocal();
  }
  return print_byThread;
}


// f can return false to suppress regular printing
// call print_raw within f to actually print something
static AutoCloseable tempInterceptPrint(F1<String, Boolean> f) {
  return tempSetThreadLocal(print_byThread(), f);
}


// works on lists and strings and null

static int indexOfIgnoreCase(List<String> a, String b) {
  return indexOfIgnoreCase(a, b, 0);
}

static int indexOfIgnoreCase(List<String> a, String b, int i) {
  int n = a == null ? 0 : a.size();
  for (; i < n; i++)
    if (eqic(a.get(i), b)) return i;
  return -1;
}

static int indexOfIgnoreCase(String[] a, String b) { return indexOfIgnoreCase(a, b, 0); }
static int indexOfIgnoreCase(String[] a, String b, int i) {
  int n = a == null ? 0 : a.length;
  for (; i < n; i++)
    if (eqic(a[i], b)) return i;
  return -1;
}

static int indexOfIgnoreCase(String a, String b) {
  return indexOfIgnoreCase_manual(a, b);
  /*Matcher m = Pattern.compile(b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher(a);
  if (m.find()) return m.start(); else ret -1;*/
}

static int indexOfIgnoreCase(String a, String b, int i) {
  return indexOfIgnoreCase_manual(a, b, i);
}


static boolean rectContains(int x1, int y1, int w, int h, Pt p) {
  return p.x >= x1 && p.y >= y1 && p.x < x1+w && p.y < y1+h;
}

static boolean rectContains(Rect a, Rect b) {
  return b.x >= a.x && b.y >= a.y && b.x2() <= a.x2() && b.y2() <= a.y2();
}

static boolean rectContains(Rect a, Rectangle b) {
  return rectContains(a, toRect(b));
}

static boolean rectContains(Rect a, int x, int y) {
  return a != null && a.contains(x, y);
}

static boolean rectContains(Rect a, Pt p) {
  return a != null && p != null && a.contains(p);
}


static Concepts newConceptsWithClassFinder(String progID) {
  Concepts cc = new Concepts(progID);
  cc.classFinder = _defaultClassFinder();
  return cc;
}

static Concepts newConceptsWithClassFinder(File conceptsFile) {
  Concepts cc = new Concepts(assertNotNull(conceptsFile));
  cc.classFinder = _defaultClassFinder();
  return cc;
}

static Concepts newConceptsWithClassFinder(File conceptsFile, IF1<String, Class> classFinder) {
  Concepts cc = new Concepts(assertNotNull(conceptsFile));
  cc.classFinder = classFinder;
  return cc;
}


static String getDBProgramID_id;

static String getDBProgramID() {
  return nempty(getDBProgramID_id) ? getDBProgramID_id : programIDWithCase();
}


static int toInt_checked(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}


volatile static boolean conceptsAndBot_running = false;
static boolean conceptsAndBot_thinOnStart = true;

static void conceptsAndBot() {
  conceptsAndBot(null);
}

static void conceptsAndBot(Integer autoSaveInterval) {
  if (conceptsAndBot_running) return;
  conceptsAndBot_running = true;
  
  Concepts cc = db_mainConcepts();
  cc.programID = getDBProgramID();
  
  try {
    if (cc.useFileLock) {
      if (!cc.fileLock().tryToLock()) {
        ensureDBNotRunning(dbBotStandardName());
        cc.fileLock().forceLock();
      }
    } else
      ensureDBNotRunning(dbBotStandardName());
  } catch (Throwable e) { printStackTrace(e);
    cc.dontSave = true; // SAFETY
  
throw rethrow(e); }
  
  cc.persist(autoSaveInterval);
  dbBot(false);
  
  if (conceptsAndBot_thinOnStart) { try {
    thinAProgramsBackups(getDBProgramID(), true);
  } catch (Throwable __e) { printStackTrace(__e); }}
}


static void indexConceptField(Class<? extends Concept> c, String field) {
  indexConceptField(db_mainConcepts(), c, field);
}

static void indexConceptField(Concepts concepts, Class<? extends Concept> c, String field) {
  if (!isConceptFieldIndexed(concepts, c, field))
    new ConceptFieldIndex(concepts, c, field);
}


static Object dm_current_generic() {
  return getWeakRef(dm_current_generic_tl().get());
}


static Object rcall(String method, Object o, Object... args) {
  return call_withVarargs(o, method, args);
}


static Runnable _topLevelErrorHandling(Runnable r) {


  if (r == null) return null;
  
  // maybe we don't want this anymore. just dm_current_generic()
  Object info = _threadInfo();
  Object mod = dm_current_generic();
  Runnable r2 = r;
  
  if (info != null || mod == null)
    r2 = new Runnable() {  public void run() { try { 
       AutoCloseable __1 =  (AutoCloseable) (rcall("enter", mod)); try {
      _threadInheritInfo(info);
      r.run();
    
} finally { _close(__1); }} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "temp (AutoCloseable) rcall enter(mod);\r\n      _threadInheritInfo(info);\r\n    ..."; }};
  r2 = rPcall(r2);
  return r2;

}


static <A, B> Map<A, B> newWeakHashMap() {
  return _registerWeakMap(synchroMap(new WeakHashMap()));
}


static Map vm_generalWeakSubMap(Object name) {
  synchronized(vm_generalMap()) {
    Map map =  (Map) (vm_generalMap_get(name));
    if (map == null)
      vm_generalMap_put(name, map = newWeakMap());
    return map;
  }
}



static <A> WeakReference<A> weakRef(A a) {
  return newWeakReference(a);
}


static <A, B> Pair<A, B> mapEntryToPair(Map.Entry<A, B> e) {
  return e == null ? null : pair(e.getKey(), e.getValue());
}


static <A, B> Set<Map.Entry<A,B>> entrySet(Map<A, B> map) {
  return _entrySet(map);
}


static <A, B> Pair<A, B> pair(A a, B b) {
  return new Pair(a, b);
}

static <A> Pair<A, A> pair(A a) {
  return new Pair(a, a);
}


static <A> A firstThat(Iterable<A> l, IF1<A, Boolean> pred) {
  for (A a : unnullForIteration(l))
    if (pred.get(a))
      return a;
  return null;
}

static <A> A firstThat(A[] l, IF1<A, Boolean> pred) {
  for (A a : unnullForIteration(l))
    if (pred.get(a))
      return a;
  return null;
}

static <A> A firstThat(IF1<A, Boolean> pred, Iterable<A> l) {
  return firstThat(l, pred);
}

static <A> A firstThat(IF1<A, Boolean> pred, A[] l) {
  return firstThat(l, pred);
}



static List<String> mechList_opt_tlft(String name) {
  return mechList_opt_tlft_cached(name);
}


// supports the usual quotings (", variable length double brackets) except ' quoting
static boolean isQuoted(String s) {
  
  
  if (isNormalQuoted(s)) return true; // use the exact version
  
  return isMultilineQuoted(s);
}


static String unquote(String s) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();
    }
  }
    
  return s; // not quoted - return original
}


static boolean isIdentifier(String s) {
  return isJavaIdentifier(s);
}


static Object callAndMake(String functionName, Object... args) {
  return callAndMake_orDirect(functionName, args);
}


static int lCodeTokens(List<String> tok) {
  return l(tok)/2;
}


static <A> A second(List<A> l) {
  return get(l, 1);
}

static <A> A second(Iterable<A> l) {
  if (l == null) return null;
  Iterator<A> it = iterator(l);
  if (!it.hasNext()) return null;
  it.next();
  return it.hasNext() ? it.next() : null;
}

static <A> A second(A[] bla) {
  return bla == null || bla.length <= 1 ? null : bla[1];
}


static <A, B> B second(Pair<A, B> p) {
  return p == null ? null : p.b;
}



static <A, B, C> B second(T3<A, B, C> t) {
  return t == null ? null : t.b;
}



static <A> A second(Producer<A> p) {
  if (p == null) return null;
  if (p.next() == null) return null;
  return p.next();
}


static char second(String s) {
  return charAt(s, 1);
}




static Object standardFunctionReference_1(final String functionName) {
  if (functionName == null) return null;
  if (hasMethodNamed(mc(), functionName))
    return functionName;
  else {
    final Class c = loadFunctions_cached(functionName);
    return new F1<Object, Object>() { public Object get(Object a) { try {  return call(c, functionName, a);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "call(c, functionName, a)"; }};
  }
}


static Object standardFunctionReference_2(final String functionName) {
  if (functionName == null) return null;
  if (hasMethodNamed(mc(), functionName))
    return functionName;
  else {
    final Class c = loadFunctions_cached(functionName);
    return new F2<Object, Object, Object>() { public Object get(Object a, Object b) { try {  return call(c, functionName, a, b);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "call(c, functionName, a, b)"; }};
  }
}


// returns pair(functionName, args)
static Pair<String, List<String>> tok_parseFunctionCall(String s) {
  return tok_parseFunctionCall(javaTok(s));
}
  
static Pair<String, List<String>> tok_parseFunctionCall(List<String> tok) {
  if (!(isIdentifier(get(tok, 1)) && eqGet(tok, 3, "("))) return null;
  Map<Integer, Integer> bracketMap = getBracketMap(tok);
  Integer iClosing = bracketMap.get(3);
  if (!(eq(iClosing, l(tok)-4) && eqGet(tok, l(tok)-2, ";"))
    && neq(iClosing, l(tok)-2)) return null;
  int i = 5, argStart = 5;
  List<String> args = new ArrayList();
  while (i < iClosing) {
    Integer j = bracketMap.get(i);
    if (j != null) { i = j+2; continue; }
    if (eqGetOneOf(tok, i, ",")) {
      if (i > argStart) args.add(trimJoinSubList(tok, argStart, i));
      argStart = i+2;
    }
    i += 2;
  }
  if (i > argStart) args.add(trimJoinSubList(tok, argStart, i));
  return pair(tok.get(1), args);
}


static Object[] map_toArray(Object f, Collection l) {
  return toArray(map(f, l));
}

static Object[] map_toArray(Object f, Object[] l) {
  return toArray(map(f, l));
}


static String defaultTimerName_name;

static String defaultTimerName() {
  if (defaultTimerName_name == null)
    defaultTimerName_name = "A timer by " + programID();
  return defaultTimerName_name;
}


// r may return false to cancel timer
static TimerTask smartTimerTask(Object r, java.util.Timer timer, long delay) {
  return new SmartTimerTask(r, timer, delay, _threadInfo());
}

static class SmartTimerTask extends TimerTask implements IFieldsToList{
  Object r;
  java.util.Timer timer;
  long delay;
  Object threadInfo;
  SmartTimerTask() {}
  SmartTimerTask(Object r, java.util.Timer timer, long delay, Object threadInfo) {
  this.threadInfo = threadInfo;
  this.delay = delay;
  this.timer = timer;
  this.r = r;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + r + ", " + timer + ", " + delay + ", " + threadInfo + ")"; }public Object[] _fieldsToList() { return new Object[] {r, timer, delay, threadInfo}; }

  long lastRun;
  
  public void run() {
    if (!licensed())
      timer.cancel();
    else {
      _threadInheritInfo(threadInfo);
       AutoCloseable __1 = tempActivity(r); try {
      lastRun = fixTimestamp(lastRun);
      long now = now();
      if (now >= lastRun + delay*0.9) {
        lastRun = now;
        if (eq(false, pcallF(r)))
          timer.cancel();
      }
    } finally { _close(__1); }}
  }
}


static long toMS(double seconds) {
  return (long) (seconds*1000);
}


static String loadPageWithParams(String url, Object... params) {
  return loadPage(appendQueryToURL(url, params));
}

static String loadPageWithParams(String url, Map params) {
  return loadPage(appendQueryToURL(url, params));
}


static String butterBotURL(String botID) {
  return "https://botcompany.de/" + psI(botID) + "/raw";
}


static String addSlashPrefix(String s) {
  return addPrefix("/", s);
}


static String exceptionToStringShort(Throwable e) {
  lastException(e);
  e = getInnerException(e);
  String msg = hideCredentials(unnull(e.getMessage()));
  if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
    return baseClassName(e) + prependIfNempty(": ", msg);
  else
    return msg;
}


// PersistableThrowable doesn't hold GC-disturbing class references in backtrace
static volatile PersistableThrowable lastException_lastException;

static PersistableThrowable lastException() {
  return lastException_lastException;
}

static void lastException(Throwable e) {
  lastException_lastException = persistableThrowable(e);
}


static String hideCredentials(URL url) { return url == null ? null : hideCredentials(str(url)); }

static String hideCredentials(String url) {
  try {
    if (startsWithOneOf(url, "http://", "https://") && isAGIBlueDomain(hostNameFromURL(url))) return url;
  } catch (Throwable e) {
    print("HideCredentials", e);
  }
  return url.replaceAll("([&?])(_pass|key|cookie)=[^&\\s\"]*", "$1$2=<hidden>");
}

static String hideCredentials(Object o) {
  return hideCredentials(str(o));
}


static Map synchroHashMap() {
  return synchronizedMap(new HashMap());
}



static Object callOpt_withVarargs(Object o, String method, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findMethod(method, args);
    if (me == null) {
      // TODO: varargs
      return null;
    }
    if ((me.getModifiers() & Modifier.STATIC) == 0)
      return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(method, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(method);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }


static boolean endsWithLetterOrDigit(String s) {
  return s != null && s.length() > 0 && Character.isLetterOrDigit(s.charAt(s.length()-1));
}


static <A> A or(A a, A b) {
  return a != null ? a : b;
}


static <A, B> Map<A, B> newDangerousWeakHashMap() {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()));
}

// initFunction: voidfunc(Map) - is called initially, and after clearing the map
static <A, B> Map<A, B> newDangerousWeakHashMap(Object initFunction) {
  return _registerDangerousWeakMap(synchroMap(new WeakHashMap()), initFunction);
}


static Object invokeMethod(Method m, Object o, Object... args) { try {
  try {
    return m.invoke(o, args);
  } catch (InvocationTargetException e) {
    throw rethrow(getExceptionCause(e));
  } catch (IllegalArgumentException e) {
    throw new IllegalArgumentException(e.getMessage() + " - was calling: " + m + ", args: " + joinWithSpace(classNames(args)));
  }
} catch (Exception __e) { throw rethrow(__e); } }


static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != l(args)) {
    if (debug)
      print("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++) {
    Object arg = args[i];
    if (!(arg == null ? !types[i].isPrimitive()
      : isInstanceX(types[i], arg))) {
      if (debug)
        print("Bad parameter " + i + ": " + arg + " vs " + types[i]);
      return false;
    }
  }
  return true;
}


static void rotateStringBuffer(StringBuffer buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }


static void rotateStringBuilder(StringBuilder buf, int max) { try {
  if (buf == null) return;
  synchronized(buf) {
    if (buf.length() <= max) return;
    
    try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
    buf.trimToSize();
  }
} catch (Exception __e) { throw rethrow(__e); } }


static Object vmBus_wrapArgs(Object... args) {
  return empty(args) ? null
    : l(args) == 1 ? args[0]
    : args;
}


static void pcallFAll_minimalExceptionHandling(Collection l, Object... args) {
  if (l != null) for  (Object f : cloneList(l)) { ping(); pcallF_minimalExceptionHandling(f, args); }
}

static void pcallFAll_minimalExceptionHandling(Iterator it, Object... args) {
  while  (it.hasNext()) { ping(); pcallF_minimalExceptionHandling(it.next(), args); }
}


static Set vm_busListeners_live_cache;
static Set vm_busListeners_live() { if (vm_busListeners_live_cache == null) vm_busListeners_live_cache = vm_busListeners_live_load(); return vm_busListeners_live_cache;}

static Set vm_busListeners_live_load() {
  return vm_generalIdentityHashSet("busListeners");
}


static Map<String, Set> vm_busListenersByMessage_live_cache;
static Map<String, Set> vm_busListenersByMessage_live() { if (vm_busListenersByMessage_live_cache == null) vm_busListenersByMessage_live_cache = vm_busListenersByMessage_live_load(); return vm_busListenersByMessage_live_cache;}

static Map<String, Set> vm_busListenersByMessage_live_load() {
  return vm_generalHashMap("busListenersByMessage");
}


static AutoCloseable tempDBLock(Concepts concepts) {
  return tempLock(concepts.lock); // NO null propagation this time
}

static AutoCloseable tempDBLock() {
  return tempDBLock(db_mainConcepts());
}


// make concept instance that is not connected to DB
static <A extends Concept> A unlisted(Class<A> c, Object... args) {
  concepts_unlisted.set(true);
  try {
    return nuObject(c, args);
  } finally {
    concepts_unlisted.set(null);
  }
}

static Concept unlisted(String name, Object... args) {
  Class<? extends Concept> cc = findClass(name);
  concepts_unlisted.set(true);
  try {
    return cc != null ? nuObject(cc) : new Concept(name);
  } finally {
    concepts_unlisted.set(null);
  }
}


static String singleFieldName(Class c) {
  Set<String> l = listFields(c);
  if (l(l) != 1)
    throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
  return first(l);
}


static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  if (getOpt_cache == null)
    map = getOpt_makeCache(c); // in class init
  else synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    
    // It's probably a subclass of Map. Use raw method. TODO: huh?
    setOpt_raw(o, field, value);
    return;
  }
  
  Field f = map.get(field);
  
  if (f != null)
    { smartSet(f, o, value); return; } // possible improvement: skip setAccessible
  
    if (o instanceof DynamicObject)
      { setDyn(((DynamicObject) o), field, value); return; }
  
  if (o instanceof IMeta)
    setDyn(((IMeta) o), field, value);
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field); // TODO: optimize
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
        makeAccessible(f);
        return f;
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}


static Object deref(Object o) {
  if (o instanceof IRef) return ((IRef) o).get();
  return o;
}



static String intern(String s) {
  return fastIntern(s);
}


static String assertIdentifier(String s) {
  return assertIsIdentifier(s);
}

static String assertIdentifier(String msg, String s) {
  return assertIsIdentifier(msg, s);
}


static <A, B> B mapGet(Map<A, B> map, A a) {
  return map == null || a == null ? null : map.get(a);
}

static <A, B> B mapGet(A a, Map<A, B> map) {
  return map == null || a == null ? null : map.get(a);
}


static void dynamicObject_setRawFieldValue(DynamicObject o, Object key, Object value) {
  if (o == null) return;
  
  // double sync, but should be OK here because of locking order o > o.fieldValues
  synchronized(o) {
    o.fieldValues = syncMapPut2_createLinkedHashMap((LinkedHashMap) o.fieldValues, key, value);
  }
}


static boolean isConceptList(Object o) {
  if (!(o instanceof List)) return false;
  List l =  (List) o;
  for (Object x : l) if (!(x instanceof Concept)) return false;
  return true;
}


static void dynamicObject_dropRawField(DynamicObject o, Object key) {
  if (o == null) return;
  
  // double sync, but should be OK here because of locking order o > o.fieldValues
  synchronized(o) {
    // can drop the inner synchronization when we migrated all users
    // of fieldValues to synchronizing on the object too
    o.fieldValues = (LinkedHashMap) syncMapRemove_deleteMapIfEmpty((Map) o.fieldValues, key);
  }
}


static boolean isPersistable(Object o) {
  return !isInAnonymousClass(o);
}


static boolean isSubtypeOf(Class a, Class b) {
  return a != null && b != null && b.isAssignableFrom(a); // << always hated that method, let's replace it!
}


static Object derefRef(Object o) {
  if (o instanceof Concept.Ref) o = ((Concept.Ref) o).get();
  return o;
}

static <A extends Concept> A derefRef(Concept.Ref<A> r) {
  return r == null ? null : r.get();
}


static <A, B> List<B> lmap(IF1<A, B> f, Iterable<A> l) {
  return lambdaMap(f, l);
}



static <A, B> List<B> lmap(IF1<A, B> f, A[] l) {
  return lambdaMap(f, l);
}


static boolean isTransient(Field f) {
  return (f.getModifiers() & java.lang.reflect.Modifier.TRANSIENT) != 0;
}


static <A> List<A> immutableEmptyList() {
  return Collections.emptyList();
}


static short[] emptyShortArray = new short[0];
static short[] emptyShortArray() { return emptyShortArray; }


static <A, B> Map<A, B> immutableEmptyMap() {
  return Collections.emptyMap();
}


static String loadTextFile(String fileName) {
  return loadTextFile(fileName, null);
}

static String loadTextFile(File f, String defaultContents) { return loadTextFile(f, defaultContents, "UTF-8"); }
static String loadTextFile(File f, String defaultContents, String encoding) { try {
  
  checkFileNotTooBigToRead(f);
  
  if (f == null || !f.exists()) return defaultContents;

  FileInputStream fileInputStream = new FileInputStream(f);
  InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encoding);
  return loadTextFile(inputStreamReader);
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadTextFile(File fileName) {
  return loadTextFile(fileName, null);
}

static String loadTextFile(String fileName, String defaultContents) {
  return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
}

static String loadTextFile(Reader reader) throws IOException {
  StringBuilder builder = new StringBuilder();
  try {
    char[] buffer = new char[1024];
    int n;
    while (-1 != (n = reader.read(buffer)))
      builder.append(buffer, 0, n);
  } finally {
    reader.close();
  }
  return str(builder);
}


static File secretProgramFile(String progID, String fileName) {
  return new File(getSecretProgramDir(progID), fileName);
}

static File secretProgramFile(String fileName) {
  return secretProgramFile(getProgramID(), fileName);
}



static Object call_withVarargs(Object o, String methodName, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    Method me = cache.findStaticMethod(methodName, args);
    if (me != null)
      return invokeMethod(me, null, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(methodName);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      { if (!(isStaticMethod(m))) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, null, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + methodName + "(" + joinWithComma(classNames(args)) + ") not found");
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(methodName, args);
    if (me != null)
      return invokeMethod(me, o, args);
      
    // try varargs
    List<Method> methods = cache.cache.get(methodName);
    if (methods != null) methodSearch: for (Method m : methods) {
      { if (!(m.isVarArgs())) continue; }
      Object[] newArgs = massageArgsForVarArgsCall(m, args);
      if (newArgs != null)
        return invokeMethod(m, o, newArgs);
    }
    
    throw fail("Method " + c.getName() + "." + methodName + "(" + joinWithComma(classNames(args)) + ") not found");
  }
} catch (Exception __e) { throw rethrow(__e); } }




static Charset utf8charset_cache;
static Charset utf8charset() { if (utf8charset_cache == null) utf8charset_cache = utf8charset_load(); return utf8charset_cache;}

static Charset utf8charset_load() {
  return Charset.forName("UTF-8");
}


static boolean regionMatchesIC(String a, int offsetA, String b, int offsetB, int len) {
  
  
    return a != null && a.regionMatches(true, offsetA, b, offsetB, len);
  
}


static void newPing() {
  var tl = newPing_actionTL();
  Runnable action = tl == null ? null : tl.get();
  { if (action != null) action.run(); }
}


// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}


static void failIfUnlicensed() {
  assertTrue("license off", licensed());
}


static CloseableIterableIterator<String> linesFromFile(File f) { return linesFromFile(f, null); }
static CloseableIterableIterator<String> linesFromFile(File f, IResourceHolder resourceHolder) { try {
  if (!f.exists()) return emptyCloseableIterableIterator();
  
  if (ewic(f.getName(), ".gz"))
    return linesFromReader(utf8bufferedReader(newGZIPInputStream(f)), resourceHolder);
  
  return linesFromReader(utf8bufferedReader(f), resourceHolder);
} catch (Exception __e) { throw rethrow(__e); } }

static CloseableIterableIterator<String> linesFromFile(String path) { return linesFromFile(path, null); }
static CloseableIterableIterator<String> linesFromFile(String path, IResourceHolder resourceHolder) {
  return linesFromFile(newFile(path), resourceHolder);
}


static boolean isCISet(Iterable<String> l) {
  return l instanceof TreeSet && ((TreeSet) l).comparator() == caseInsensitiveComparator();
}


static TreeSet<String> caseInsensitiveSet() {
  return caseInsensitiveSet_treeSet();
}

static TreeSet<String> caseInsensitiveSet(Collection<String> c) {
  return caseInsensitiveSet_treeSet(c);
}


static <A, B extends A> void addAll(Collection<A> c, Iterable<B> b) {
  if (c != null && b != null) for (A a : b) c.add(a);
}

static <A, B extends A> boolean addAll(Collection<A> c, Collection<B> b) {
  return c != null && b != null && c.addAll(b);
}

static <A, B extends A> boolean addAll(Collection<A> c, B... b) {
  return c != null && b != null && c.addAll(Arrays.asList(b));
}



static <A, B> Map<A, B> addAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null && b != null) a.putAll(b);
  return a;
}

static <A extends Container> A addAll(A c, Collection<? extends Component> components) {
  return addComponents(c, components);
}

static <A extends Container> A addAll(A c, Component... components) {
  return addComponents(c, components);
}


static <A> ArrayList<A> cloneList(Iterable<A> l) {
  return l instanceof Collection ? cloneList((Collection) l) : asList(l);
}

static <A> ArrayList<A> cloneList(Collection<A> l) {
  if (l == null) return new ArrayList();
  synchronized(collectionMutex(l)) {
    return new ArrayList<A>(l);
  }
}


static Comparator<String> caseInsensitiveComparator() {
  
  
  return betterCIComparator();
  
}


static int max(int a, int b) { return Math.max(a, b); }
static int max(int a, int b, int c) { return max(max(a, b), c); }
static long max(int a, long b) { return Math.max((long) a, b); }
static long max(long a, long b) { return Math.max(a, b); }
static double max(int a, double b) { return Math.max((double) a, b); }
static float max(float a, float b) { return Math.max(a, b); }
static double max(double a, double b) { return Math.max(a, b); }

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}

static int max(int[] c) {
  int x = Integer.MIN_VALUE;
  for (int d : c) if (d > x) x = d;
  return x;
}

static <A extends Comparable<A>> A max(A a, A b) {
  return cmp(a, b) >= 0 ? a : b;
}


// tok should be the output of htmlcoarsetok
static List<String> dropAllTags(List<String> tok) {
  List<String> list = new ArrayList();
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && t.startsWith("<")) {
      list.set(list.size()-1, list.get(list.size()-1) + tok.get(i+1));
      ++i;
    } else
      list.add(t);
  }
  return list;
}

// alternatively, call this convenient function
static String dropAllTags(String html) {
  if (!contains(html, '<')) return html;
  return join(dropAllTags(htmlcoarsetok(html)));
}


static String pre(Object contents, Object... params) {
  return tag("pre", contents, params);
}


static int compareIgnoreCase_jdk(String s1, String s2) {
  if (s1 == null) return s2 == null ? 0 : -1;
  if (s2 == null) return 1;

  int n1 = s1.length();
  int n2 = s2.length();
  int min = Math.min(n1, n2);
  for (int i = 0; i < min; i++) {
    char c1 = s1.charAt(i);
    char c2 = s2.charAt(i);
    if (c1 != c2) {
      c1 = Character.toUpperCase(c1);
      c2 = Character.toUpperCase(c2);
      if (c1 != c2) {
        c1 = Character.toLowerCase(c1);
        c2 = Character.toLowerCase(c2);
        if (c1 != c2) return c1-c2;
      }
    }
  }
  return n1-n2;
}


//static final Map<Class, HashMap<S, Field>> getOpt_cache = newDangerousWeakHashMap(f getOpt_special_init);

static class getOpt_Map extends WeakHashMap {
  getOpt_Map() {
    if (getOpt_special == null) getOpt_special = new HashMap();
    clear();
  }
  
  public void clear() {
    super.clear();
    //print("getOpt clear");
    put(Class.class, getOpt_special);
    put(String.class, getOpt_special);
  }
}

static final Map<Class, HashMap<String, Field>> getOpt_cache = 
  
  
    _registerDangerousWeakMap(synchroMap(new getOpt_Map()));
  
  
static HashMap getOpt_special; // just a marker

/*static void getOpt_special_init(Map map) {
  map.put(Class.class, getOpt_special);
  map.put(S.class, getOpt_special);
}*/

static Map<String, Field> getOpt_getFieldMap(Object o) {
  Class c = _getClass(o);
  HashMap<String, Field> map = getOpt_cache.get(c);
  if (map == null)
    map = getOpt_makeCache(c);
  return map;
}

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Map<String, Field> map = getOpt_getFieldMap(o);

  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
    if (o instanceof DynamicObject)
      return syncMapGet2(((DynamicObject) o).fieldValues, field);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    if (!reflection_classesNotToScan().contains(c.getName())) {
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) {
          makeAccessible(f);
          String name = f.getName();
          if (!map.containsKey(name))
            map.put(name, f);
        }
        _c = _c.getSuperclass();
      } while (_c != null);
    }
  }
  if (getOpt_cache != null) getOpt_cache.put(c, map);
  return map;
}


static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(int a, int b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(long a, long b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}


static List<String> htmlTok(String s) {
  return htmlcoarsetok(s);
}


// tok must come from htmlTok
// returns all container tags found (including content) as CNC
// should be OK for both HTML and XML
static List<List<String>> findContainerTag(List<String> tok, String tag) {
  List<List<String>> l = new ArrayList();
  for (int i = 1; i < l(tok); i += 2)
    if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i+2; j < tok.size(); j += 2)
        if (isOpeningTag(tok.get(j), tag))
          ++level;
        else if (isTag(tok.get(j), "/" + tag)) {
          --level;
          if (level == 0) {
            l.add(subList(tok, i-1, j+2)); // actual CNC
            break;
          }
        }
      i = j;
    }
  return l;
}

static List<List<String>> findContainerTag(String html, String tag) {
  return findContainerTag(htmlTok(html), tag);
}



static String addLineBreak(String s) {
  return addSuffix(s, "\n");
}


static String structureForUser(Object o) {
  return beautifyStructure(struct_noStringSharing(o));
}


static Map similarEmptyMap(Map m) {
  if (m instanceof TreeMap) return new TreeMap(((TreeMap) m).comparator());
  if (m instanceof LinkedHashMap) return new LinkedHashMap();
  
  // default to a hash map
  return new HashMap();
}

static Map similarEmptyMap(Iterable m) {
  if (m instanceof TreeSet) return new TreeMap(((TreeSet) m).comparator());
  if (m instanceof LinkedHashSet) return new LinkedHashMap();
  
  return new HashMap();
}


static <A, B> Set<Map.Entry<A,B>> _entrySet(Map<A, B> map) {
  return map == null ? Collections.EMPTY_SET : map.entrySet();
}


static MultiMap mapMultiMapValues(Object func, MultiMap mm) {
  MultiMap m = similarEmptyMultiMap(mm);
  for (Object key : keys(mm))
    for (Object value : mm.get(key))
      m.put(key, callF(func, value));
  return m;
}

static MultiMap mapMultiMapValues(MultiMap mm, Object func) {
  return mapMultiMapValues(func, mm);
}

static <A, B, C> MultiMap<A, C> mapMultiMapValues(IF1<B, C> func, MultiMap<A, B> mm) {
  return mapMultiMapValues((Object) func, mm);
}


static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null && b != null) a.putAll(b);
  return a;
}


static <A, B> MultiMap<A, B> putAll(MultiMap<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll((Map) b);
  return a;
}


static <A, B> Map<A, B> putAll(Map<A, B> a, Object... b) {
  if (a != null)
    litmap_impl(a, b);
  return a;
}



static int year() {
  return localYear();
}

static int year(long now) {
  return localYear(now);
}

static int year(long now, TimeZone tz) {
  return parseInt(simpleDateFormat("y", tz).format(now));
}


static String formatInt(int i, int digits) {
  return padLeft(str(i), '0', digits);
}

static String formatInt(long l, int digits) {
  return padLeft(str(l), '0', digits);
}


static int month() {
  return localMonth();
}

static int month(long now) {
  return localMonth(now);
}

static int month(long now, TimeZone tz) {
  return parseInt(simpleDateFormat("M", tz).format(now));
}


static int dayOfMonth() {
  return localDayOfMonth();
}

static int dayOfMonth(long now) {
  return localDayOfMonth(now);
}

static int dayOfMonth(long now, TimeZone tz) {
  return parseInt(simpleDateFormat("d", tz).format(now));
}


static File getProgramDir() {
  return programDir();
}

static File getProgramDir(String snippetID) {
  return programDir(snippetID);
}


static Object[] dropEntryFromParams(Object[] params, int i) {
  int n = l(params);
  if (i < 0 || i >= n) return params;
  if (n == 2) return null;
  Object[] p = new Object[n-2];
  System.arraycopy(params, 0, p, 0, i);
  System.arraycopy(params, i+2, p, i, n-i-2);
  return p;
}


static boolean checkConceptFields(Concept x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(cget(x, (String) data[i]), deref(data[i+1])))
      return false;
  return true;
}


static <A extends Concept> List<A> filterConcepts(List<A> list, Object... params) {
  if (empty(params)) return list;
  List<A> l = new ArrayList();
  for (A x : list)
    if (checkConceptFields(x, params))
      l.add(x);
  return l;
}


static String asString(Object o) {
  return o == null ? null : o.toString();
}


static Lock appendToFile_lock = lock();
static boolean appendToFile_keepOpen = false;
static HashMap<String, Writer> appendToFile_writers = new HashMap();

static void appendToFile(String path, String s) { try {
  Lock __0 = appendToFile_lock; lock(__0); try { // Let's just generally synchronize this to be safe.
  mkdirsForFile(new File(path));
  path = getCanonicalPath(path);
  Writer writer = appendToFile_writers.get(path);
  if (writer == null) {
    //print("[Logging to " + path + "]");
    writer = new BufferedWriter(new OutputStreamWriter(
      newFileOutputStream(path, true), "UTF-8"));
    if (appendToFile_keepOpen)
      appendToFile_writers.put(path, writer);
  }
  writer.write(s);
  if (!appendToFile_keepOpen)
    writer.close();
} finally { unlock(__0); } } catch (Exception __e) { throw rethrow(__e); } }
  
static void appendToFile(File path, String s) {
  if (path != null)
    appendToFile(path.getPath(), s);
}

static void cleanMeUp_appendToFile() {
   AutoCloseable __3 = tempCleaningUp(); try {
  Lock __1 = appendToFile_lock; lock(__1); try {
  closeAllWriters(values(appendToFile_writers));
  appendToFile_writers.clear();
} finally { unlock(__1); } } finally { _close(__3); }}


static <A> A assertEquals(Object x, A y) {
  return assertEquals("", x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (assertVerbose()) return assertEqualsVerbose(msg, x, y);
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}




static List<String> javaTokC(String s) {
  if (s == null) return null;
  int l = s.length();
  ArrayList<String> tok = new ArrayList();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    i = j;
  }
  
  return tok;
}


static <A> A popLast(List<A> l) {
  return liftLast(l);
}

static <A> List<A> popLast(int n, List<A> l) {
  return liftLast(n, l);
}




static String actualMCDollar() {
  return actualMC().getName() + "$";
}


static boolean startsWithDigit(String s) {
  return nempty(s) && isDigit(s.charAt(0));
}


static boolean isSyntheticOrAnonymous(Class c) {
  return c != null && (c.isSynthetic() || isAnonymousClassName(c.getName()));
}


// This is a bit rough... finds static and non-static methods.

static Method findMethodNamed(Object obj, String method) {
  if (obj == null) return null;
  if (obj instanceof Class)
    return findMethodNamed((Class) obj, method);
  return findMethodNamed(obj.getClass(), method);
}

static Method findMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method)) {
        makeAccessible(m);
        return m;
      }
    c = c.getSuperclass();
  }
  return null;
}


// keeps package names for dynamic code (package dyn.*)
static String shortDynClassNameForStructure(Object o) {
   if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return name.startsWith("dyn.") ? classNameToVM(name) : shortenClassName(name);
}


static boolean isPersistableClass(Class c) {
  String name = c.getName();
  if (isAnonymousClassName(name)) return false;
  if (isBoxedType(c)) return true;
  if (isArrayType(c)) return true;
  if (c == Class.class || c == String.class || c == File.class || c == Color.class) return true;
  if (name.startsWith("java.util.Collections$Synchronized")) return true;
  
  if (hasThisDollarFields(c))
    return hasSingleArgumentConstructor(c);
  else
    return getDefaultConstructor(c) != null;
}


static boolean warn_on = true;
static ThreadLocal<List<String>> warn_warnings = new ThreadLocal();

static void warn(String s) {
  if (warn_on)
    print("Warning: " + s);
}

static void warn(String s, List<String> warnings) {
  warn(s);
  if (warnings != null)
    warnings.add(s);
  addToCollection(warn_warnings.get(), s);
}


static int countDots(String s) {
  int n = l(s), count = 0;
  for (int i = 0; i < n; i++) if (s.charAt(i) == '.') ++count;
  return count;
}


static void quoteToPrintWriter(String s, PrintWriter out) {
  if (s == null) { out.print("null"); return; }
  out.print('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"') {
      out.print('\\'); out.print(c);
    } else if (c == '\r')
      out.print("\\r");
    else if (c == '\n')
      out.print("\\n");
    else if (c == '\0')
      out.print("\\0");
    else
      out.print(c);
  }
  out.print('"');
}


static String quoteCharacter(char c) {
  if (c == '\'') return "'\\''";
  if (c == '\\') return "'\\\\'";
  if (c == '\r') return "'\\r'";
  if (c == '\n') return "'\\n'";
  if (c == '\t') return "'\\t'";
  return "'" + c + "'";
}



static int shorten_default = 100;

static String shorten(CharSequence s) { return shorten(s, shorten_default); }

static String shorten(CharSequence s, int max) {
  return shorten(s, max, "...");
}

static String shorten(CharSequence s, int max, String shortener) {
  if (s == null) return "";
  if (max < 0) return str(s);
  return s.length() <= max ? str(s) : subCharSequence(s, 0, min(s.length(), max-l(shortener))) + shortener;
}

static String shorten(int max, CharSequence s) { return shorten(s, max); }


static boolean isCISet_gen(Iterable<String> l) {
  return l instanceof TreeSet && className(((TreeSet) l).comparator()).contains("CIComp");
}


static boolean isJavaXClassName(String s) {
  return startsWithOneOf(s, "main$", "loadableUtils.");
}


static <A> List<A> unwrapSynchronizedList(List<A> l) {
  
    if (l instanceof SynchronizedList) return ((SynchronizedList) l).list;
  
  if (eqOneOf(className(l),
    "java.util.Collections$SynchronizedList",
    "java.util.Collections$SynchronizedRandomAccessList"))
    return (List) get_raw(l, "list");
  return l;
}


static boolean isCIMap_gen(Map map) {
  return map instanceof TreeMap && className(((TreeMap) map).comparator()).contains("CIComp");
}


// works for both java.util-wrapped maps as well as our own
static <A, B> Map<A, B> unwrapSynchronizedMap(Map<A, B> map) {
  if (eqOneOf(shortClassName(map),
    "SynchronizedMap",
    "SynchronizedSortedMap",
    "SynchronizedNavigableMap"))
    return (Map) get_raw(map, "m");
  return map;
}


static String boolArrayToHex(boolean[] a) {
  return bytesToHex(boolArrayToBytes(a));
}


static Pair<Class, Integer> arrayTypeAndDimensions(Object o) {
  return arrayTypeAndDimensions(_getClass(o));
}

static Pair<Class, Integer> arrayTypeAndDimensions(Class c) {
  if (c == null || !c.isArray()) return null;
  Class elem = c.getComponentType();
  if (elem.isArray())
    return mapPairB(arrayTypeAndDimensions(elem), dim -> dim+1);
  return pair(elem, 1);
}


static Iterator emptyIterator() {
  return Collections.emptyIterator();
}


static int stdcompare(Number a, Number b) {
  return cmp(a, b);
}

static int stdcompare(String a, String b) {
  return cmp(a, b);
}

static int stdcompare(long a, long b) {
  return a < b ? -1 : a > b ? 1 : 0;
}

static int stdcompare(Object a, Object b) {
  return cmp(a, b);
}



static Map<Class, Field[]> getDeclaredFields_cache = newDangerousWeakHashMap();

static Field[] getDeclaredFields_cached(Class c) {
  Field[] fields;
  synchronized(getDeclaredFields_cache) {
    fields = getDeclaredFields_cache.get(c);
    if (fields == null) {
      getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
      for (Field f : fields)
        makeAccessible(f);
    }
  }
  return fields;
}


static Object fieldGet(Field f, Object o) { try {
  return f == null ? null : f.get(o);
} catch (Exception __e) { throw rethrow(__e); } }


static Method findInstanceMethod(Class c, String method, Object... args) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method) && findMethod_checkArgs(m, args, false))
        return m;
    c = c.getSuperclass();
  }
  return null;
}



static Set<Field> fieldObjectsInFieldOrder(Class c, Set<Field> fields) {
  try {
    var byName = mapToKey(f -> f.getName(), fields);
    LinkedHashSet<Field> out = new LinkedHashSet();
    for (String name : unnullForIteration(getFieldOrder(c))) {
      Field f = byName.get(name);
      if (f != null) {
        byName.remove(name);
        out.add(f);
      }
    }
    addAll(out, fields);
    return out;
  } catch (Throwable __0) { printStackTrace(__0);
    return fields;
  }
}




static WeakHasherMap<Symbol, Boolean> symbol_map = new WeakHasherMap(new Hasher<Symbol>() {
  public int hashCode(Symbol symbol) { return symbol.text.hashCode(); }
  public boolean equals(Symbol a, Symbol b) {
    if (a == null) return b == null;
    return b != null && eq(a.text, b.text);
  }
});



static Symbol symbol(String s) {
  
  
  if (s == null) return null;
  synchronized(symbol_map) {
    // TODO: avoid object creation by passing the string to findKey
    Symbol symbol = new Symbol(s, true);
    Symbol existingSymbol = symbol_map.findKey(symbol);
    if (existingSymbol == null)
      symbol_map.put(existingSymbol = symbol, true);
    
      
    return existingSymbol;
  }
  
}

static Symbol symbol(CharSequence s) {
  if (s == null) return null;
  
  
  if (s instanceof Symbol) return (Symbol) s;
  if (s instanceof String) return symbol((String) s);
  return symbol(str(s));
  
}

static Symbol symbol(Object o) {
  return symbol((CharSequence) o);
}


static File newFile(File base, String... names) {
  for (String name : names) base = new File(base, name);
  return base;
}

static File newFile(String name) {
  return name == null ? null : new File(name);
}

static File newFile(String base, String... names) {
  return newFile(newFile(base), names);
}


static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}


static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}


static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}


static Class getMainClass() {
  return mc();
}

static Class getMainClass(Object o) { try {
  if (o == null) return null;
  if (o instanceof Class && eq(((Class) o).getName(), "x30")) return (Class) o;
  ClassLoader cl = (o instanceof Class ? (Class) o : o.getClass()).getClassLoader();
  if (cl == null) return null;
  String name = mainClassNameForClassLoader(cl);
  return loadClassFromClassLoader_orNull(cl, name);
} catch (Exception __e) { throw rethrow(__e); } }


static Random defaultRandomGenerator() {
  { Random r = customRandomizerForThisThread(); if (r != null) return r; }
  return ThreadLocalRandom.current();
}


static <A> A optPar(ThreadLocal<A> tl, A defaultValue) {
  A a = tl.get();
  if (a != null) {
    tl.set(null);
    return a;
  }
  return defaultValue;
}

static <A> A optPar(ThreadLocal<A> tl) {
  return optPar(tl, null);
}

static Object optPar(Object[] params, String name) {
  return optParam(params, name);
}

static Object optPar(String name, Object[] params) {
  return optParam(params, name);
}

static Object optPar(String name, Map params) {
  return optParam(name, params);
}

static <A> A optPar(Object[] params, String name, A defaultValue) {
  return optParam(params, name, defaultValue);
}

static <A> A optPar(String name, Object[] params, A defaultValue) {
  return optParam(params, name, defaultValue);
}


static Object[] changeParam(Object[] params, String name, Object value) {
  if (eq(optPar(params, name), value)) return params;
  Map map = paramsToOrderedMap(params);
  map.put(name, value);
  return mapToParams(map);
}


static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}


static Object html_valueLessParam_cache;
static Object html_valueLessParam() { if (html_valueLessParam_cache == null) html_valueLessParam_cache = html_valueLessParam_load(); return html_valueLessParam_cache;}

static Object html_valueLessParam_load() {
  return new Object();
}


static Object[] mapToParams(Map map) {
  return mapToObjectArray(map);
}


static Object[] unrollParams(Object[] params) {
  if (l(params) == 1 && params[0] instanceof Map)
    return mapToParams((Map) params[0]);
  return params;
}


static String htmlQuote(String s) {
  return "\"" + htmlencode_forParams(s) + "\"";
}


static <A, B> Map<A, B> synchronizedMRUCache(int maxSize) {
  return synchroMap(new MRUCache(maxSize));
}


static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}


static boolean checkTokCondition(Object condition, List<String> tok, int i) {
  if (condition instanceof TokCondition)
    return ((TokCondition) condition).get(tok, i);
  return checkCondition(condition, tok, i);
}


static <A> void replaceCollection(Collection<A> dest, Collection<A> src) {
  if (dest == src) return;
  dest.clear();
  if (src != null) dest.addAll(src);
}


static void replaceListPart(List l, int i, int j, List l2) {
  replaceSublist(l, i, j, l2);
}


static <A> int indexOfSubList(List<A> x, List<A> y) {
  return indexOfSubList(x, y, 0);
}

static <A> int indexOfSubList(List<A> x, List<A> y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y.get(j)))
        continue outer;
    return i;
  }
  return -1;
}

static <A> int indexOfSubList(List<A> x, A[] y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y[j]))
        continue outer;
    return i;
  }
  return -1;
}


static void removeSubList(List l, int from, int to) {
  if (l != null) subList(l, from, to).clear();
}

static void removeSubList(List l, int from) {
  if (l != null) subList(l, from).clear();
}


static <A, B extends A> void copyListPart(List<B> a, int i1, List<A> b, int i2, int n) {
  if (a == null || b == null) return;
  for (int i = 0; i < n; i++)
    b.set(i2+i, a.get(i1+i));
}


// binary legacy signature
static Object[] toObjectArray(Collection c) {
  return toObjectArray((Iterable) c);
}

static Object[] toObjectArray(Iterable c) {
  List l = asList(c);
  return l.toArray(new Object[l.size()]);
}



static String htd(Object contents, Object... params) {
  return htag("td", contents, params);
}


static String a(String noun) {
  if (eq(noun, "")) return "?";
  return ("aeiou".indexOf(noun.charAt(0)) >= 0 ? "an " : "a ") + noun;
}

static String a(String contents, Object... params) {
  return hfulltag("a", contents, params);
}



static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt((String) o);
  if (o instanceof Boolean)
    return boolToInt((Boolean) o);
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}


static String[] drop(int n, String[] a) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}

static Object[] drop(int n, Object[] a) {
  n = Math.min(n, a.length);
  Object[] b = new Object[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}


static <A> ArrayList<A> toList(A[] a) { return asList(a); }
static ArrayList<Integer> toList(int[] a) { return asList(a); }
static <A> ArrayList<A> toList(Set<A> s) { return asList(s); }
static <A> ArrayList<A> toList(Iterable<A> s) { return asList(s); }


static String hcomment_unescaped(String text) {
  return "<!-- " + text + " -->";
}




static String formatWithThousandsSeparator(long l) {
  return NumberFormat.getInstance(new Locale("en_US")).format(l);
}


static <A> A[] dropLast(A[] a) { return dropLast(a, 1); }
static <A> A[] dropLast(A[] a, int n) {
  if (a == null) return null;
  n = Math.min(n, a.length);
  A[] b = arrayOfSameType(a, a.length-n);
  System.arraycopy(a, 0, b, 0, b.length);
  return b;
}

static <A> List<A> dropLast(List<A> l) {
  return subList(l, 0, l(l)-1);
}

static <A> List<A> dropLast(int n, List<A> l) {
  return subList(l, 0, l(l)-n);
}

static <A> List<A> dropLast(Iterable<A> l) {
  return dropLast(asList(l));
}

static String dropLast(String s) {
  return substring(s, 0, l(s)-1);
}

static String dropLast(String s, int n) {
  return substring(s, 0, l(s)-n);
}

static String dropLast(int n, String s) {
  return dropLast(s, n);
}



static boolean isJavaIdentifier(String s) {
  if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
    return false;
  for (int i = 1; i < s.length(); i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}


static Map<String, Class> classForName_cache = synchroHashMap();

static Class classForName(String name) { return classForName(name, null); }
static Class classForName(String name, Object classFinder) {
  // first clause is when we're in class init
  if (classForName_cache == null || classFinder != null)
    return classForName_uncached(name, classFinder);
  Class c = classForName_cache.get(name);
  if (c == null)
    classForName_cache.put(name, c = classForName_uncached(name, null));
  return c;
}

static Class classForName_uncached(String name, Object classFinder) { try {
  if (classFinder != null) return (Class) callF(classFinder, name);
  return Class.forName(name);
} catch (Exception __e) { throw rethrow(__e); } }


static Map<Class, Constructor> nuObjectWithoutArguments_cache = newDangerousWeakHashMap();

static Object nuObjectWithoutArguments(String className) { try {
  return nuObjectWithoutArguments(classForName(className));
} catch (Exception __e) { throw rethrow(__e); } }

static <A> A nuObjectWithoutArguments(Class<A> c) { try {
  if (nuObjectWithoutArguments_cache == null)
    // in class init
    return (A) nuObjectWithoutArguments_findConstructor(c).newInstance();
    
  Constructor m = nuObjectWithoutArguments_cache.get(c);
  if (m == null)
    nuObjectWithoutArguments_cache.put(c, m = nuObjectWithoutArguments_findConstructor(c));
  return (A) m.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObjectWithoutArguments_findConstructor(Class c) {
  for (Constructor m : getDeclaredConstructors_cached(c))
    if (empty(m.getParameterTypes())) {
      makeAccessible(m);
      return m;
    }
  throw fail("No default constructor found in " + c.getName());
}





// TODO: convert to regularly cleared normal map
static Map<Class, Constructor[]> cache = newDangerousWeakHashMap();

static Constructor[] getDeclaredConstructors_cached(Class c) {
  Constructor[] ctors;
  synchronized(cache) {
    ctors = cache.get(c);
    if (ctors == null) {
      cache.put(c, ctors = c.getDeclaredConstructors());
      for (var ctor : ctors)
        makeAccessible(ctor);
    }
  }
  return ctors;
}


static List<Class> getClasses(Object[] array) {
  List<Class> l = emptyList(l(array));
  for (Object o : array) l.add(_getClass(o));
  return l;
}


static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}


static boolean containsNulls(Collection c) {
  return contains(c, null);
}




static MechListDependentCaches<TreeSet<String>> mechCISet_cache = new MechListDependentCaches(new F1<String, TreeSet<String>>() { public TreeSet<String> get(String text) { try {  return asCISet(tlft(text));  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "asCISet(tlft(text))"; }});

static TreeSet<String> mechCISet(String name) {
  return mechCISet_cache.get(name);
}




static List<String> words(String s) {
  return codeTokens(dropPunctuation(javaTok(s)));
}


static int zeroOne(boolean b) {
  return b ? 1 : 0;
}


static <A> List<A> replace(List<A> l, A a, A b) {
  for (int i = 0; i < l(l); i++)
    if (eq(l.get(i), a))
      l.set(i, b);
  return l;
}

static <A> List<A> replace(A a, A b, List<A> l) {
  return replace(l, a, b);
}

// replace all occurrences of a in s with b
static String replace(String s, String a, String b) {
  return s == null ? null : a == null || b == null ? s : s.replace(a, b);
}

static String replace(String s, char a, char b) {
  return s == null ? null : s.replace(a, b);
}


static int indexOfIC_underscore(String a, String b) {
  int la = l(a), lb = l(b);
  if (la < lb) return -1;
  int n = la-lb;
  
  elsewhere: for (int i = 0; i <= n; i++) {
    for (int j = 0; j < lb; j++) {
      char c2 = b.charAt(j);
      if (c2 == '_' || eqic(c2, a.charAt(i+j))) { /* matching char */ }
      else continue elsewhere;
    }
    return i;
  }
  return -1;
}


static boolean emptyString(String s) {
  return s == null || s.length() == 0;
}


static int[] subIntArray(int[] b, int start) {
  return subIntArray(b, start, l(b));
}
  
static int[] subIntArray(int[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start == 0 && end == l(b)) return b;
  if (start >= end) return new int[0];
  int[] x = new int[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}




static short[] subShortArray(short[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start == 0 && end == l(b)) return b;
  if (start >= end) return new short[0];
  short[] x = new short[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}


static byte[] subByteArray(byte[] b, int start) {
  return subByteArray(b, start, l(b));
}
  
static byte[] subByteArray(byte[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start == 0 && end == l(b)) return b;
  if (start >= end) return new byte[0];
  byte[] x = new byte[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}




static double[] subDoubleArray(double[] b, int start) { return subDoubleArray(b, start, l(b)); }
static double[] subDoubleArray(double[] b, int start, int end) {
  start = max(start, 0); end = min(end, l(b));
  if (start == 0 && end == l(b)) return b;
  if (start >= end) return new double[0];
  double[] x = new double[end-start];
  System.arraycopy(b, start, x, 0, end-start);
  return x;
}


static int globalIDLength() {
  return 16;
}


static String addSuffix(String s, String suffix) {
  return s == null || s.endsWith(suffix) ? s : s + suffix;
}




static int indexOfIgnoreCase_manual(String a, String b) {
  return indexOfIgnoreCase_manual(a, b, 0);
}

static int indexOfIgnoreCase_manual(String a, String b, int i) {
  int la = strL(a), lb = strL(b);
  if (la < lb) return -1;
  int n = la-lb;
  
  loop: for (; i <= n; i++) {
    for (int j = 0; j < lb; j++) {
      char c1 = a.charAt(i+j), c2 = b.charAt(j);
      if (!eqic(c1, c2))
        continue loop;
    }
    return i;
  }
  return -1;
}




static Rect toRect(Rectangle r) {
  return r == null ? null : new Rect(r);
}

static Rect toRect(RectangularShape r) {
  return r == null ? null : toRect(r.getBounds());
}



static Rect toRect(Rect r) { return r; }


static Object _defaultClassFinder_value = defaultDefaultClassFinder();

static Object _defaultClassFinder() {
  return _defaultClassFinder_value;
}


static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}




static String programIDWithCase() {
  return nempty(caseID())
    ? programID() + "/" + quoteUnlessIdentifierOrInteger(caseID())
    : programID();
}


static void ensureDBNotRunning(String name) {
  if (hasBot(name)) {
    try {
      String framesBot = dropSuffix(".", name) + " Frames";
      print("Trying to activate frames of running DB: " + framesBot);
      if (isOK(sendOpt(framesBot, "activate frames")) && isMainProgram())
        cleanKill();
    } catch (Throwable __e) { printStackTrace(__e); }
    throw fail("Already running: " + name);
  }
}

static void ensureDBNotRunning() {
  ensureDBNotRunning(dbBotStandardName());
}


static String dbBotStandardName() {
  String home = userHome();
  String name = dbBotName(getDBProgramID());
  if (neq(home, actualUserHome()))
    name += " " + quote(home);
  return name + ".";
}


static volatile Android3 dbBot_instance;

static Android3 dbBot() { return dbBot(true); }
static Android3 dbBot(boolean ensureNotRunning) {
  return dbBot(dbBotStandardName(), ensureNotRunning);
}

static Android3 dbBot(String name) { return dbBot(name, true); }
static Android3 dbBot(String name, boolean ensureNotRunning) {
  if (ensureNotRunning)
    ensureDBNotRunning(name);
  return dbBot_instance = methodsBot2(name, assertNotNull(db_mainConcepts()), db_standardExposedMethods(), db_mainConcepts().lock);
}


static void thinAProgramsBackups(String progID, boolean doIt) {
  File dir = programDir(progID);
  thinAProgramsBackups(dir, doIt);
}

static void thinAProgramsBackups(File dir, boolean doIt) {
  List<File> files = new ArrayList();
  Map<File, Double> ageMap = new HashMap();
  
  // minutes (last group) are optional
  java.util.regex.Pattern pat = regexp("^(.*)\\.backup(20\\d\\d)(\\d\\d)(\\d\\d)-(\\d\\d)(\\d*)$");
  print("Processing backups in " + dir);
  
  for (File f : listFilesNotDirs(dir, newFile(dir, "backups"))) {
    String s = f.getName();
    java.util.regex.Matcher matcher = pat.matcher(s);
    { if (!(matcher.find())) continue; }
    String originalName = matcher.group(1);
    { if (!(eq(originalName, "concepts.structure.gz"))) continue; }
    //print("Found backup: " + sfu(matcherGroups(matcher)));
    int year = matcherInt(matcher, 2);
    int month = matcherInt(matcher, 3);
    int day = matcherInt(matcher, 4);
    int hour = matcherInt(matcher, 5);
    int minute = matcherInt(matcher, 6);
    long time = timestampFromYMDHM(year, month, day, hour, minute);
    double age = ((now()-time)/1000.0/60/60/24);
    //print("Age: " + age + " days");
    ageMap.put(f, age);
    files.add(f);
  }
  
  int numDeleted = 0;
  sortByMap_inPlace(files, ageMap);
  double lastAge = -1;
  for (File f : files) {
    double age = ageMap.get(f);
    if (!thinAProgramsBackups_shouldKeep(age, lastAge)) {
      //print("Deleting: " + f);
      ++numDeleted;
      if (doIt) {
        print("Deleting: " + f);
        f.delete();
      }
    } else {
      //print("Keeping: " + f);
      lastAge = age;
    }
  }
  if (numDeleted != 0)
    print((doIt ? "Deleted: " : "Would delete: ") + n(numDeleted, "file"));
}

// age = age in days
static boolean thinAProgramsBackups_shouldKeep(double age, double lastAge) {
  return defaultAgeBasedBackupRetentionStrategy_shouldKeep(age, lastAge);
}


static boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
  return isConceptFieldIndexed(db_mainConcepts(), c, field);
}

static boolean isConceptFieldIndexed(Concepts concepts, Class<? extends Concept> c, String field) {
  return concepts.getFieldIndex(c, field) != null;
}


static <A> A getWeakRef(Reference<A> ref) {
  return ref == null ? null : ref.get();
}


static x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl;

static x30_pkg.x30_util.BetterThreadLocal<WeakReference> dm_current_generic_tl() {
  if (dm_current_generic_tl == null)
    dm_current_generic_tl = vm_generalMap_getOrCreate("currentModule", () -> new x30_pkg.x30_util.BetterThreadLocal());
  return dm_current_generic_tl;
}


static List<VF1<Map>> _threadInfo_makers = synchroList();

static Object _threadInfo() {
  if (empty(_threadInfo_makers)) return null;
  HashMap map = new HashMap();
  pcallFAll(_threadInfo_makers, map);
  return map;
}


static List<VF1<Map>> _threadInheritInfo_retrievers = synchroList();

static void _threadInheritInfo(Object info) {
  if (info == null) return;
  pcallFAll(_threadInheritInfo_retrievers, (Map) info);
}


static Runnable rPcall(Runnable r) {
  return r == null ? null : () -> { try { r.run(); } catch (Throwable __e) { printStackTrace(__e); } };
}


static List _registerWeakMap_preList;

static <A> A _registerWeakMap(A map) {
  if (javax() == null) {
    // We're in class init
    if (_registerWeakMap_preList == null) _registerWeakMap_preList = synchroList();
    _registerWeakMap_preList.add(map);
    return map;
  }
  
  try {
    call(javax(), "_registerWeakMap", map);
  } catch (Throwable e) {
    printException(e);
    print("Upgrade JavaX!!");
  }
  return map;
}

static void _onLoad_registerWeakMap() {
  assertNotNull(javax());
  if (_registerWeakMap_preList == null) return;
  for (Object o : _registerWeakMap_preList)
    _registerWeakMap(o);
  _registerWeakMap_preList = null;
}


static Map vm_generalMap_map;

static Map vm_generalMap() {
  if (vm_generalMap_map == null)
    
    
    
    vm_generalMap_map = (Map) get(javax(), "generalMap");
    
    
  return vm_generalMap_map;
}


static Object vm_generalMap_get(Object key) {
  return vm_generalMap().get(key);
}


static Object vm_generalMap_put(Object key, Object value) {
  return mapPutOrRemove(vm_generalMap(), key, value);
}


static <A, B> Map<A, B> newWeakMap() {
  return newWeakHashMap();
}


static <A> WeakReference<A> newWeakReference(A a) {
  return a == null ? null : new WeakReference(a);
}




static Map<String, MechListDependentCache<List<String>>> mechList_opt_tlft_cached_cache = ciMap();
static Lock mechList_opt_tlft_cached_lock = lock();

static List<String> mechList_opt_tlft_cached(String name) {
  MechListDependentCache<List<String>> listCache;
  {
    Lock __0 = mechList_opt_tlft_cached_lock; lock(__0); try {
    listCache = mechList_opt_tlft_cached_cache.get(name);
    if (listCache == null)
       mechList_opt_tlft_cached_cache.put(name, listCache
        = new MechListDependentCache(name, new F1<String, List < String >>() { public List < String > get(String x) { try {  return tlft(x);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "tlft(x)"; }}));
  } finally { unlock(__0); } }
  return listCache.get();
}




static boolean isNormalQuoted(String s) {
  int l = l(s);
  if (!(l >= 2 && s.charAt(0) == '"' && lastChar(s) == '"')) return false;
  int j = 1;
  while (j < l)
    if (s.charAt(j) == '"')
      return j == l-1;
    else if (s.charAt(j) == '\\' && j+1 < l)
      j += 2;
    else
      ++j;
  return false;
}


static boolean isMultilineQuoted(String s) {
  if (!startsWith(s, "[")) return false;
  int i = 1;
  while (i < s.length() && s.charAt(i) == '=') ++i;
  return i < s.length() && s.charAt(i) == '[';
}


static boolean endsWith(String a, String b) {
  return a != null && a.endsWith(b);
}

static boolean endsWith(String a, char c) {
  return nempty(a) && lastChar(a) == c;
}


  static boolean endsWith(String a, String b, Matches m) {
    if (!endsWith(a, b)) return false;
    m.m = new String[] {dropLast(l(b), a)};
    return true;
  }




static Object callAndMake_orDirect(String functionName, List args) {
  return callAndMake_orDirect(functionName, toObjectArray(args));
}

static Object callAndMake_orDirect(String functionName, Object... args) {
  if (functionName == null) return null;
  if (hasMethod(mc(), functionName, args))
    return callMC(functionName, args);
  else
    return makeAndCall_cached(functionName, args);
}


static <A> Iterator<A> iterator(Iterable<A> c) {
  return c == null ? emptyIterator() : c.iterator();
}


static char charAt(String s, int i) {
  return s != null && i >= 0 && i < s.length() ? s.charAt(i) : '\0';
}


// This is a bit rough... finds static and non-static methods.
// It's usually just for error messages though, so no worries.

static boolean hasMethodNamed(Object obj, String method) {
  if (obj == null) return false;
  if (obj instanceof Class)
    return hasMethodNamed((Class) obj, method);
  return hasMethodNamed(obj.getClass(), method);
}

static boolean hasMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method))
        return true;
    c = c.getSuperclass();
  }
  return false;
}


static HashMap<Set<String>, Class> loadFunctions_cache = new HashMap();
static Lock loadFunctions_cached_lock = lock();

static boolean loadFunctions_preferDiskCache = false; // Note: This may use outdated versions of standard functions

static Class loadFunctions_cached(String... functions) {
  return loadFunctions_cached(asList(functions));
}

static Class loadFunctions_cached(Collection<String> functions) {
  TreeSet<String> functionSet = new TreeSet<String>(functions);
  Lock __0 = loadFunctions_cached_lock; lock(__0); try {
  Class c = loadFunctions_cache.get(functionSet);
  if (c != null) return c;
  String transpilation = null;
  
  // new mode for slow machines (Raspberry Pi): get server transpilation
  if (l(functions) == 1 && isSlowMachine()) {
    String snippetID = stdFunctions_cached().get(first(functions));
    if (nempty(snippetID)) {
      if (!isMD5(getUpToDateSnippetTranspilationMD5(snippetID)))
        print("Slow machine mode: " + snippetID + " transpilation not up to date");
      else {
        transpilation = getServerTranspiledWithoutLibs(snippetID); // TODO: libs?
        print("Loaded server transpilation: " + snippetID);
      }
    }
  }
  
  if (transpilation == null) {
    String cached = getTranspiledStandardFunctionsIfCached(functionSet);
    // TODO: make sure we're using an up-to-date transpiler too
    if (cached != null && (loadFunctions_preferDiskCache || standardFunctionsCacheUpToDate(functionSet)))
      transpilation = cached;
  }
  if (transpilation != null) {
    // TODO: LIBS
    print("Loading " + joinWithPlus(functionSet));
    c = veryQuickJava_finish(transpilation, emptyList());
  }
  
  if (c == null) c = loadFunctions(functionSet);
  
  loadFunctions_cache.put(functionSet, c);
  assertNotNull(loadFunctions_cache.get(functionSet));
  return c;
} finally { unlock(__0); } }

static void loadFunctions_cached_clearCache() {
  Lock __1 = loadFunctions_cached_lock; lock(__1); try {
  loadFunctions_cache.clear();
} finally { unlock(__1); } }

static void _onLoad_loadFunctions_cached() {
  ownResource(vmBus_onMessage("refreshedTranspiler", new Runnable() {  public void run() { try {  loadFunctions_clearCache(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "loadFunctions_clearCache();"; }}));
}


static boolean eqGet(List l, int i, Object o) {
  return eq(get(l, i), o);
}

static <A, B> boolean eqGet(Map<A, B> map, A key, Object o) {
  return eq(mapGet(map, key), o);
}


// map: index of opening bracket -> index of closing bracket
static Map<Integer, Integer> getBracketMap(List tok) {
  return getBracketMap(tok, getBracketMap_opening, getBracketMap_closing);
}

static Map<Integer, Integer> getBracketMap(List tok, Collection<String> opening, Collection<String> closing) {
  return getBracketMap(tok, opening, closing, 0, l(tok));
}

static Map<Integer, Integer> getBracketMap(List tok, Collection<String> opening, Collection<String> closing, int from, int to) {
  TreeMap<Integer, Integer> map = new TreeMap();
  List<Integer> stack = new ArrayList();
  for (int i = from|1; i < to; i+= 2) {
    if (opening.contains(tok.get(i)))
      stack.add(i);
    else if (closing.contains(tok.get(i))) {
      if (!empty(stack))
        map.put(liftLast(stack), i);
    }
  }
  return map;
}

static Set<String> getBracketMap_opening = lithashset("{", "(");
static Set<String> getBracketMap_closing = lithashset("}", ")");


static <A> boolean eqGetOneOf(List<A> l, int i, A... options) {
  return eqOneOf(get(l, i), options);
}


static String trimJoinSubList(List<String> l, int i, int j) {
  return trim(join(subList(l, i, j)));
}

static String trimJoinSubList(List<String> l, int i) {
  return trim(join(subList(l, i)));
}


static Object[] toArray(Collection c) {
  return toObjectArray(c);
}

static <A> A[] toArray(Class<A> type, Iterable<A> c) {
  return toArray(c, type);
}

static <A> A[] toArray(Class<A> type, Collection<A> c) {
  return toArray(c, type);
}

static <A> A[] toArray(Collection<A> c, Class<A> type) {
  A[] a = arrayOfType(l(c), type);
  if (a.length == 0) return a;
  asList(c).toArray(a);
  return a;
}

static <A> A[] toArray(Iterable<A> c, Class<A> type) {
  var c2 = asList(c);
  A[] a = arrayOfType(l(c2), type);
  if (a.length == 0) return a;
  c2.toArray(a);
  return a;
}

// array must have correct length and will be filled
static <A> A[] toArray(A[] array, Collection c) {
  if (array == null || c == null) return null;
  asList(c).toArray(array);
  return array;
}


static String shortClassName_dropNumberPrefix(Object o) {
  return dropNumberPrefix(shortClassName(o));
}


static volatile boolean licensed_yes = true;

static boolean licensed() {
  if (!licensed_yes) return false;
  ping_okInCleanUp();
  return true;
}

static void licensed_off() {
  licensed_yes = false;
}


static AutoCloseable tempActivity(Object r) {
  return null;
}


static long fixTimestamp(long timestamp) {
  return timestamp > now() ? 0 : timestamp;
}


static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}


static <A> A pcallF(F0<A> f) {
  try { return f == null ? null : f.get(); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static <A, B> B pcallF(F1<A, B> f, A a) {
  try { return f == null ? null : f.get(a); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static <A> void pcallF(VF1<A> f, A a) {
  try {
    { if (f != null) f.get(a); }
  } catch (Throwable __e) { printStackTrace(__e); }
}


static Object pcallF(Runnable r) {
  try { { if (r != null) r.run(); } } catch (Throwable __e) { printStackTrace(__e); } return null;
}

static <A> A pcallF(IF0<A> f) {
  try { return f == null ? null : f.get(); } catch (Throwable __e) { printStackTrace(__e); } return null;
}

static <A, B> B pcallF(IF1<A, B> f, A a) {
  try { return f == null ? null : f.get(a); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static int loadPage_defaultTimeout = 60000;
static ThreadLocal<String> loadPage_charset = new ThreadLocal();
static boolean loadPage_allowGzip = true, loadPage_debug;
static boolean loadPage_anonymous = false; // don't send computer ID
static int loadPage_verboseness = 100000;
static int loadPage_retries = 1; //60; // seconds
static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();
static volatile int loadPage_forcedTimeout; // ms
static ThreadLocal<Integer> loadPage_forcedTimeout_byThread = new ThreadLocal(); // ms
static ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadPage_extraHeaders = new ThreadLocal();
static ThreadLocal<Long> loadPage_sizeLimit = new ThreadLocal();

public static String loadPageSilently(String url) { try {
  return loadPageSilently(new URL(loadPage_preprocess(url)));
} catch (Exception __e) { throw rethrow(__e); } }

public static String loadPageSilently(URL url) { try {
  if (!networkAllowanceTest(str(url))) throw fail("Not allowed: " + url);
    
  IOException e = null;
  for (int tries = 0; tries < loadPage_retries; tries++)
    try {
      URLConnection con = loadPage_openConnection(url);
      return loadPage(con, url);
    } catch (IOException _e) {
      e = _e;
      if (loadPage_debug)
        print(exceptionToStringShort(e));
      if (tries < loadPage_retries-1) sleepSeconds(1);
    }
  throw e;
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage_preprocess(String url) {  
  if (url.startsWith("tb/")) // don't think we use this anymore
    url = tb_mainServer() + "/" + url;
  if (url.indexOf("://") < 0)
    url = "http://" + url;
  return url;
}

static String loadPage(String url) { try {
  url = loadPage_preprocess(url);
  if (!isTrue(loadPage_silent.get()))
    printWithTime("Loading: " + hideCredentials(url));
  return loadPageSilently(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static String loadPage(URL url) {
  return loadPage(url.toExternalForm());
}

static String loadPage(URLConnection con, URL url) throws IOException {
  return loadPage(con, url, true);
}

static String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadPage_extraHeaders);
  Long limit = optPar(loadPage_sizeLimit);
  if (addHeaders) try {
    if (!loadPage_anonymous)
      setHeaders(con);
    if (loadPage_allowGzip)
      con.setRequestProperty("Accept-Encoding", "gzip");
    con.setRequestProperty("X-No-Cookies", "1");
    for (String key : keys(extraHeaders))
      con.setRequestProperty(key, extraHeaders.get(key));
  } catch (Throwable e) {} // fails if within doPost
  
  
  vm_generalSubMap("URLConnection per thread").put(currentThread(), con);
  
  loadPage_responseHeaders.set(con.getHeaderFields());
  InputStream in = null;
  try {
    in = urlConnection_getInputStream(con);
  //vm_generalSubMap("InputStream per thread").put(currentThread(), in);
  if (loadPage_debug)
    print("Put stream in map: " + currentThread());
    String contentType = con.getContentType();
    if (contentType == null) {
      //printStruct("Headers: ", con.getHeaderFields());
      throw new IOException("Page could not be read: " + hideCredentials(url));
    }
    //print("Content-Type: " + contentType);
    String charset = loadPage_charset == null ? null : loadPage_charset.get();
    if (charset == null) charset = loadPage_guessCharset(contentType);
    
    if ("gzip".equals(con.getContentEncoding())) {
      if (loadPage_debug)
        print("loadPage: Using gzip.");
      in = newGZIPInputStream(in);
    }
    Reader r;
    try {
      r = new InputStreamReader(in, unquote(charset));
    } catch (UnsupportedEncodingException e) {
      print(toHex(utf8(charset)));
      throw e;
    }
    
    boolean silent = isTrue(loadPage_silent.get());
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (limit == null || n < limit) {
      ping();
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      if (!silent && (n % loadPage_verboseness) == 0)
        print("  " + n + " chars read");
    }
    return buf.toString();
  } finally {
    if (loadPage_debug)
      print("loadPage done");
    //vm_generalSubMap("InputStream per thread").remove(currentThread());
    
    vm_generalSubMap("URLConnection per thread").remove(currentThread());
    
    if (in != null) in.close();
  }
}

static String loadPage_guessCharset(String contentType) {
  Matcher m = regexpMatcher("text/[a-z]+;\\s*charset=([^\\s]+)\\s*", contentType);
  String match = m.matches() ? m.group(1) : null;
  if (loadPage_debug)
    print("loadPage: contentType=" + contentType + ", match: " + match);
  /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
  //return or(match, "ISO-8859-1");
  return or(match, "UTF-8");
}

static URLConnection loadPage_openConnection(URL url) {
  URLConnection con = openConnection(url);
  int timeout = toInt(loadPage_forcedTimeout_byThread.get());
  if (timeout == 0) timeout = loadPage_forcedTimeout;
  if (timeout != 0)
    setURLConnectionTimeouts(con, loadPage_forcedTimeout);
  else
    setURLConnectionDefaultTimeouts(con, loadPage_defaultTimeout);
  return con;
}


static String appendQueryToURL(String url, Map params) {
  if (url == null) return null;
  String data = makePostData(params);
  if (empty(data)) return url;
  int idx = smartIndexOf(url, '#');
  String url2 = takeFirst(url, idx);
  return url2 + (url2.contains("?") ? "&" : "?") + data + substring(url, idx);
}

static String appendQueryToURL(String url, Object... data) {
  return appendQueryToURL(url, paramsToMap(data));
}


static long psI(String snippetID) {
  return parseSnippetID(snippetID);
}


static Throwable getInnerException(Throwable e) {
  if (e == null) return null;
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}

static Throwable getInnerException(Runnable r) {
  return getInnerException(getException(r));
}


static String baseClassName(String className) {
  return substring(className, className.lastIndexOf('.')+1);
}

static String baseClassName(Object o) {
  return baseClassName(getClassName(o));
}


static String prependIfNempty(String prefix, String s) {
  return empty(s) ? unnull(s) : prefix + s;
}


static PersistableThrowable persistableThrowable(Throwable e) {
  return e == null ? null : new PersistableThrowable(e);
}


static boolean startsWithOneOf(String s, String... l) {
  for (String x : l) if (startsWith(s, x)) return true; return false;
}

static boolean startsWithOneOf(String s, Matches m, String... l) {
  for (String x : l) if (startsWith(s, x, m)) return true; return false;
}


static boolean isAGIBlueDomain(String domain) {
  return domainIsUnder(domain, theAGIBlueDomain());
}


static String hostNameFromURL(String url) { try {
  return empty(url) ? null : new URL(url).getHost();
} catch (Exception __e) { throw rethrow(__e); } }


static Map synchronizedMap() {
  return synchroMap();
}

static <A, B> Map<A, B> synchronizedMap(Map<A, B> map) {
  return synchroMap(map);
}


static final Map<Class, _MethodCache> callOpt_cache = newDangerousWeakHashMap();

static Object callOpt_cached(Object o, String methodName, Object... args) { try {
  if (o == null) return null;
  
  if (o instanceof Class) {
    Class c = (Class) o;
    _MethodCache cache = callOpt_getCache(c);
    
    // TODO: (super-rare) case where method exists static and non-static
    // with different args
    
    Method me = cache.findMethod(methodName, args);
    if (me == null || (me.getModifiers() & Modifier.STATIC) == 0) return null;
    return invokeMethod(me, null, args);
  } else {
    Class c = o.getClass();
    _MethodCache cache = callOpt_getCache(c);

    Method me = cache.findMethod(methodName, args);
    if (me == null) return null;
    return invokeMethod(me, o, args);
  }
} catch (Exception __e) { throw rethrow(__e); } }

// no longer synchronizes! (see #1102990)
static _MethodCache callOpt_getCache(Class c) {
  _MethodCache cache = callOpt_cache.get(c);
  if (cache == null)
    callOpt_cache.put(c, cache = new _MethodCache(c));
  return cache;
}


static Object[] massageArgsForVarArgsCall(Executable m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  int n = types.length-1, nArgs = l(args);
  if (nArgs < n) return null;
  for (int i = 0; i < n; i++)
    if (!argumentCompatibleWithType(args[i], types[i]))
      return null;
  Class varArgType = types[n].getComponentType();
  for (int i = n; i < nArgs; i++)
    if (!argumentCompatibleWithType(args[i], varArgType))
      return null;
  Object[] newArgs = new Object[n+1];
  arraycopy(args, 0, newArgs, 0, n);
  
  // TODO: optimize
  
  int nVarArgs = nArgs-n;
  Object varArgs = Array.newInstance(varArgType, nVarArgs);
  for (int i = 0; i < nVarArgs; i++)
    Array.set(varArgs, i, args[n+i]);
    
  newArgs[n] = varArgs;
  return newArgs;
}


static List<Pair> _registerDangerousWeakMap_preList;

static <A> A _registerDangerousWeakMap(A map) {
  return _registerDangerousWeakMap(map, null);
}

static <A> A _registerDangerousWeakMap(A map, Object init) {
  
  callF(init, map);
  
  if (init instanceof String) {
    final String f =  (String) init;
    init = new VF1<Map>() { public void get(Map map) { try {  callMC(f, map) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callMC(f, map)"; }};
  }
    
  if (javax() == null) {
    // We're in class init
    if (_registerDangerousWeakMap_preList == null) _registerDangerousWeakMap_preList = synchroList();
    _registerDangerousWeakMap_preList.add(pair(map, init));
    return map;
  }
  
  call(javax(), "_registerDangerousWeakMap", map, init);
  
  return map;
}

static void _onLoad_registerDangerousWeakMap() {
  
  assertNotNull(javax());
  if (_registerDangerousWeakMap_preList == null) return;
  for (Pair p : _registerDangerousWeakMap_preList)
    _registerDangerousWeakMap(p.a, p.b);
  _registerDangerousWeakMap_preList = null;
  
}


static Throwable getExceptionCause(Throwable e) {
  Throwable c = e.getCause();
  return c != null ? c : e;
}


static String joinWithSpace(Iterable c) {
  return join(" ", c);
}

static String joinWithSpace(String... c) {
  return join(" ", c);
}



static List<String> classNames(Collection l) {
  return getClassNames(l);
}

static List<String> classNames(Object[] l) {
  return getClassNames(asList(l));
}


static Object pcallF_minimalExceptionHandling(Object f, Object... args) {
  try {
    return callFunction(f, args);
  } catch (Throwable e) {
    System.out.println(getStackTrace(e));
    _storeException(e);
  }
  return null;
}


static Set vm_generalIdentityHashSet(Object name) {
  synchronized(vm_generalMap()) {
    Set set =  (Set) (vm_generalMap_get(name));
    if (set == null)
      vm_generalMap_put(name, set = syncIdentityHashSet());
    return set;
  }
}



static Map vm_generalHashMap(Object name) {
  synchronized(vm_generalMap()) {
    Map m =  (Map) (vm_generalMap_get(name));
    if (m == null)
      vm_generalMap_put(name, m = syncHashMap());
    return m;
  }
}



// accept purpose argument so we are a drop-in for tempVerboseLock
static AutoCloseable tempLock(Lock lock) { return tempLock("", lock); }
static AutoCloseable tempLock(String purpose, Lock lock) {
  if (lock == null) return null;
  lock(lock);
  return new AutoCloseable() { public String toString() { return "unlock(lock);"; } public void close() throws Exception { unlock(lock); }};
}


// This is for main classes that are all static.
// (We don't go to base classes.)
static Set<String> listFields(Object c) {
  TreeSet<String> fields = new TreeSet();
  for (Field f : _getClass(c).getDeclaredFields())
    fields.add(f.getName());
  return fields;
}


static String n(long l, String name) {
  return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
}

static String n(Collection l, String name) {
  return n(l(l), name);
}

static String n(Map m, String name) {
  return n(l(m), name);
}

static String n(Object[] a, String name) {
  return n(l(a), name);
}


  static String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }



// TODO: optimize (use getOpt_cache)
static void setOpt_raw(Object o, String field, Object value) { try {
  if (o == null) return;
  if (o instanceof Class) setOpt_raw((Class) o, field, value);
  else {
    Field f = setOpt_raw_findField(o.getClass(), field);
    if (f != null) {
      makeAccessible(f);
      smartSet(f, o, value);
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt_raw(Class c, String field, Object value) { try {
  if (c == null) return;
  Field f = setOpt_raw_findStaticField(c, field);
  if (f != null) {
    makeAccessible(f);
    smartSet(f, null, value);
  }
} catch (Exception __e) { throw rethrow(__e); } }
  
static Field setOpt_raw_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field setOpt_raw_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}


static void smartSet(Field f, Object o, Object value) throws Exception {
  try {
    f.set(o, value);
  } catch (Exception e) {
    Class type = f.getType();
    
    // take care of common case (long to int)
    if (type == int.class && value instanceof Long)
      { f.set(o, ((Long) value).intValue()); return; }
      
    if (type == boolean.class && value instanceof String)
      { f.set(o, isTrueOrYes(((String) value))); return; }
    
    if (type == LinkedHashMap.class && value instanceof Map)
      { f.set(o, asLinkedHashMap((Map) value)); return; }
    
    
      try {
        if (f.getType() == Concept.Ref.class)
          { f.set(o, ((Concept) o).new Ref((Concept) value)); return; }
        if (o instanceof Concept.Ref)
          { f.set(o, ((Concept.Ref) o).get()); return; }
      } catch (Throwable _e) {}
    
    throw e;
  }
}


static <A extends DynamicObject> A setDyn(A o, String key, Object value) {
  setDynObjectValue(o, key, value);
  return o;
}

static void setDyn(IMeta o, String key, Object value) {
  metaMapPut(o, key, value);
}


static Method fastIntern_method;

static String fastIntern(String s) { try {
  if (s == null) return null;
  if (fastIntern_method == null) {
    fastIntern_method = findMethodNamed(javax(), "internPerProgram");
    if (fastIntern_method == null) upgradeJavaXAndRestart();
  }
    
  return (String) fastIntern_method.invoke(null, s);
} catch (Exception __e) { throw rethrow(__e); } }


static String assertIsIdentifier(String s) {
  if (!isIdentifier(s))
    throw fail("Not an identifier: " + quote(s));
  return s;
}

static String assertIsIdentifier(String msg, String s) {
  if (!isIdentifier(s))
    throw fail(msg + " - Not an identifier: " + quote(s));
  return s;
}


static <A, B> LinkedHashMap<A, B> syncMapPut2_createLinkedHashMap(LinkedHashMap<A, B> map, A key, B value) {
  if (key != null)
    if (value != null) {
      if (map == null) map = new LinkedHashMap();
      synchronized(collectionMutex(map)) { map.put(key, value); }
    } else if (map != null) synchronized(collectionMutex(map)) { map.remove(key); }
  return map;
}


static <A, B, C extends Map<A, B>> C syncMapRemove_deleteMapIfEmpty(C map, A key) {
  if (map != null && key != null)
    synchronized(collectionMutex(map)) {
      map.remove(key);
      if (map.isEmpty())
        return null;
    }
  return map;
}


static boolean isInAnonymousClass(Object o) {
  if (o == null) return false;
  return isAnonymousClassName(className(o));
}


static <A, B> List<B> lambdaMap(IF1<A, B> f, Iterable<A> l) {
  return map(l, f);
}

static <A, B> List<B> lambdaMap(IF1<A, B> f, A[] l) {
  return map(l, f);
}


static ThreadLocal<VF1<File>> checkFileNotTooBigToRead_tl = new ThreadLocal();

static void checkFileNotTooBigToRead(File f) {
  callF(checkFileNotTooBigToRead_tl.get(), f);
}


static File getSecretProgramDir() {
  return getSecretProgramDir(actualProgramID());
}

static File getSecretProgramDir(String snippetID) {
  if (empty(snippetID)) return javaxSecretDir();
  return newFile(javaxSecretDir(), formatSnippetID(snippetID));
}


static boolean isStaticMethod(Method m) {
  return methodIsStatic(m);
}


static x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL;

static x30_pkg.x30_util.BetterThreadLocal<Runnable> newPing_actionTL() {
  if (newPing_actionTL == null)
    newPing_actionTL = vm_generalMap_getOrCreate("newPing_actionTL",
      () -> {
        Runnable value =  (Runnable) (callF_gen(vm_generalMap_get("newPing_valueForNewThread")));
        var tl = new x30_pkg.x30_util.BetterThreadLocal<Runnable>();
        tl.set(value);
        return tl;
      });
  return newPing_actionTL;
}



static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}



static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (isAndroid()) return isHeadless_cache = true;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}


static void assertTrue(Object o) {
  if (!(eq(o, true) /*|| isTrue(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}


static CloseableIterableIterator emptyCloseableIterableIterator_instance = new CloseableIterableIterator() {
  public Object next() { throw fail(); }
  public boolean hasNext() { return false; }
};

static <A> CloseableIterableIterator<A> emptyCloseableIterableIterator() {
  return emptyCloseableIterableIterator_instance; 
}


static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}


static boolean ewic(String a, String b, Matches m) {
  return endsWithIgnoreCase(a, b, m);
}



static CloseableIterableIterator<String> linesFromReader(Reader r) { return linesFromReader(r, null); }
static CloseableIterableIterator<String> linesFromReader(Reader r, IResourceHolder resourceHolder) {
  final BufferedReader br = bufferedReader(r);
  return holdResource(resourceHolder, iteratorFromFunction_f0_autoCloseable(new F0<String>() { public String get() { try {  return readLineFromReaderWithClose(br);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "return readLineFromReaderWithClose(br);"; }}, _wrapIOCloseable(r)));
}


static BufferedReader utf8bufferedReader(InputStream in) { try {
  return in == null ? null : bufferedReader(_registerIOWrap(new InputStreamReader(in, "UTF-8"), in));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedReader utf8bufferedReader(File f) { try {
  return utf8bufferedReader(newFileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }


static GZIPInputStream newGZIPInputStream(File f) {
  return gzInputStream(f);
}

static GZIPInputStream newGZIPInputStream(InputStream in) {
  return gzInputStream(in);
}


static TreeSet<String> caseInsensitiveSet_treeSet() {
  return new TreeSet(caseInsensitiveComparator());
}

static TreeSet<String> caseInsensitiveSet_treeSet(Collection<String> c) {
  return toCaseInsensitiveSet_treeSet(c);
}


static <A extends Container> A addComponents(A c, Collection<? extends Component> components) {
  if (nempty(components)) { swing(() -> { 
    for (Component comp : components)
      if (comp != null)
        c.add(comp);
    revalidate(c);
  }); }
  return c;
}

static <A extends Container> A addComponents(A c, Component... components) {
  return addComponents(c, asList(components));
}


static betterCIComparator_C betterCIComparator_instance;

static betterCIComparator_C betterCIComparator() {
  if (betterCIComparator_instance == null)
    betterCIComparator_instance = new betterCIComparator_C();
  return betterCIComparator_instance;
}

final static class betterCIComparator_C implements Comparator<String> {
  public int compare(String s1, String s2) {
    if (s1 == null) return s2 == null ? 0 : -1;
    if (s2 == null) return 1;
  
    int n1 = s1.length();
    int n2 = s2.length();
    int min = Math.min(n1, n2);
    for (int i = 0; i < min; i++) {
        char c1 = s1.charAt(i);
        char c2 = s2.charAt(i);
        if (c1 != c2) {
            c1 = Character.toUpperCase(c1);
            c2 = Character.toUpperCase(c2);
            if (c1 != c2) {
                c1 = Character.toLowerCase(c1);
                c2 = Character.toLowerCase(c2);
                if (c1 != c2) {
                    // No overflow because of numeric promotion
                    return c1 - c2;
                }
            }
        }
    }
    return n1 - n2;
  }
}


// TODO: process CDATA, scripts

static List<String> htmlcoarsetok(String s) {
  List<String> tok = new ArrayList();
  int l = s == null ? 0 : s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c;
    
    // scan for non-tags
    while (j < l) {
      if (s.charAt(j) != '<')
        // regular character
        ++j;
      else if (s.substring(j, Math.min(j+4, l)).equals("<!--")) {
        // HTML comment
        j = j+3;
        do ++j; while (j < l && !s.substring(j, Math.min(j+3, l)).equals("-->"));
        j = Math.min(j+3, l);
      } else {
        char d = charAt(s, j+1); // character after <
        if (d == '/' || isLetter(d))
          // it's a tag
          break;
        else
          ++j;
      }
    }
    
    tok.add(s.substring(i, j)); // add non-tag content
    i = j;
    if (i >= l) break;
    c = s.charAt(i);

    // scan over tag
    if (c == '<') {
      ++j;
      
      while (j < l && s.charAt(j) != '>') ++j; // TODO: strings in tag?
      if (j < l) ++j;
    }

    tok.add(s.substring(i, j)); // add tag
    i = j;
  }
  
  if ((tok.size() & 1) == 0) tok.add("");
  return tok;
}


static void clear(Collection c) {
  if (c != null) c.clear();
}

static void clear(Map map) {
  if (map != null) map.clear();
}


static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}

static <A> void put(List<A> l, int i, A a) {
  if (l != null && i >= 0 && i < l(l)) l.set(i, a);
}


static Class<?> _getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null; // could optimize this
  }
}

static Class _getClass(Object o) {
  return o == null ? null
    : o instanceof Class ? (Class) o : o.getClass();
}

static Class _getClass(Object realm, String name) {
  try {
    return classLoaderForObject(realm).loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null; // could optimize this
  }
}


static <A, B> B syncMapGet2(Map<A, B> map, A a) {
  if (map == null) return null;
  synchronized(collectionMutex(map)) {
    return map.get(a);
  }
}

static <A, B> B syncMapGet2(A a, Map<A, B> map) {
  return syncMapGet2(map, a);
}


static Set<String> reflection_classesNotToScan_value = litset(
  "jdk.internal.loader.URLClassPath"
);

static Set<String> reflection_classesNotToScan() {
  return reflection_classesNotToScan_value;
}


static boolean isOpeningTag(String token, String tag) {
  return isTag(token, tag) && !token.endsWith("/>");
}

static boolean isOpeningTag(String token) {
  return token.startsWith("<")
    && token.endsWith(">")
    && !token.endsWith("/>")
    && isLetter(token.charAt(1));
}    



static boolean isTag(String token, String tag) {
  return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length()+2)
    || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length()+2);
}


static String beautifyStructure(String s) {
  List<String> tok = javaTokForStructure(s);
  structure_addTokenMarkers(tok);
  jreplace(tok, "lhm", "");
  return join(tok);
}


static String struct_noStringSharing(Object o) {
  structure_Data d = new structure_Data();
  d.noStringSharing = true;
  return structure(o, d);
}


// TODO: comparators!?
static MultiMap similarEmptyMultiMap(MultiMap m) {
  if (m instanceof TreeMultiMap)
    return new TreeMultiMap((TreeMultiMap) m);
  return similarEmptyMultiMap(m == null ? null : m.data);
}

static MultiMap similarEmptyMultiMap(Map m) {
  MultiMap mm = new MultiMap();
  if (m != null)
    mm.data = similarEmptyMap(m);
  return mm;
}


static int localYear() {
  return localYear(now());
}

static int localYear(long time) {
  return parseInt(simpleDateFormat_local("yyyy").format(time));
}


static java.text.SimpleDateFormat simpleDateFormat(String format, TimeZone timeZone) {
  java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(format);
  sdf.setTimeZone(timeZone);
  return sdf;
}


static String padLeft(String s, char c, int n) {
  return rep(c, n-l(s)) + s;
}

// default to space
static String padLeft(String s, int n) {
  return padLeft(s, ' ', n);
}


static int localMonth(long time) {
  return parseInt(simpleDateFormat_local("MM").format(time));
}

static int localMonth() {
  return localMonth(now());
}


static int localDayOfMonth(long time) {
  return parseInt(simpleDateFormat_local("dd").format(time));
}

static int localDayOfMonth() {
  return localDayOfMonth(now());
}


static File programDir_mine; // set this to relocate program's data

static File programDir() {
  return programDir(getProgramID());
}

static File programDir(String snippetID) {
  boolean me = sameSnippetID(snippetID, programID());
  if (programDir_mine != null && me)
    return programDir_mine;
  File dir = new File(javaxDataDir(), formatSnippetIDOpt(snippetID));
  if (me) {
    String c = caseID();
    if (nempty(c)) dir = newFile(dir, c);
  }
  return dir;
}

static File programDir(String snippetID, String subPath) {
  return new File(programDir(snippetID), subPath);
}


static Object cget(Object c, String field) {
  c = derefRef(c);
  Object o = getOpt(c, field);
  return derefRef(o);
}

static Object cget(String field, Object c) {
  return cget(c, field);
}


public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) { // is null if file is in current dir
    dir.mkdirs();
    if (!dir.isDirectory())
      if (dir.isFile()) throw fail("Please delete the file " + f2s(dir) + " - it is supposed to be a directory!");
      else throw fail("Unknown IO exception during mkdirs of " + f2s(file));
  }
  return file;
}

public static String mkdirsForFile(String path) {
  mkdirsForFile(new File(path));
  return path;
}


static String getCanonicalPath(File f) { try {
  return f == null ? null : f.getCanonicalPath();
} catch (Exception __e) { throw rethrow(__e); } }

static String getCanonicalPath(String path) {
  return getCanonicalPath(newFile(path));
}


static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(File path, boolean append) throws IOException {
  return newFileOutputStream(path.getPath(), append);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  mkdirsForFile(path);
  FileOutputStream f = new FileOutputStream(path, append);
  
  _registerIO(f, path, true);
  
  return f;
}


static AutoCloseable tempCleaningUp() {
  AutoCloseable result = null;
  
  
  result = tempSetTL(ping_isCleanUpThread, true);
  
  
  return result;
}


static void closeAllWriters(Collection<? extends Writer> l) {
  for (Writer w : unnull(l)) { try {
    w.close();
  } catch (Throwable __e) { printStackTrace(__e); }}
}


static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}

// convenience shortcut for values_gen
static Collection values(Object map) {
  return values((Map) map);
}


static <A, B> Collection<B> values(MultiMap<A, B> mm) {
  return mm == null ? emptyList() : concatLists(values(mm.data));
}





static ThreadLocal<Boolean> assertVerbose_value = new ThreadLocal();

static void assertVerbose(boolean b) {
  assertVerbose_value.set(b);
}

static boolean assertVerbose() { return isTrue(assertVerbose_value.get()); }


static <A> A assertEqualsVerbose(Object x, A y) {
  assertEqualsVerbose((String) null, x, y);
  return y;
}

// x = expected, y = actual
static <A> A assertEqualsVerbose(String msg, Object x, A y) {
  if (!eq(x, y)) {
    

    throw fail((nempty(msg) ? msg + ": " : "") + "expected: "+ x + ", got: " + y);
  } else
    print("OK" + (empty(msg) ? "" : " " + msg) + ": " + /*sfu*/(x));
  return y;
}




static String nullIfEmpty(String s) {
  return isEmpty(s) ? null : s;
}

static <A, B> Map<A, B> nullIfEmpty(Map<A, B> map) {
  return isEmpty(map) ? null : map;
}

static <A> List<A> nullIfEmpty(List<A> l) {
  return isEmpty(l) ? null : l;
}


static <A> A liftLast(List<A> l) {
  if (empty(l)) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}

static <A> List<A> liftLast(int n, List<A> l) {
  int i = l(l)-n;
  List<A> part = cloneSubList(l, i);
  removeSubList(l, i);
  return part;
}


static Class actualMC() {
  return or((Class) realMC(), mc());
}


static boolean isDigit(char c) {
  return Character.isDigit(c);
}


static boolean isAnonymousClassName(String s) {
  for (int i = 0; i < l(s); i++)
    if (s.charAt(i) == '$' && Character.isDigit(s.charAt(i+1)))
      return true;
  return false;
}


// Note: This is actually broken. Inner classes must stay with a $ separator
static String classNameToVM(String name) {
  return name.replace(".", "$");
}


static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}


static boolean isBoxedType(Class type) {
  return type == Boolean.class
    || type == Integer.class
    || type == Long.class
    || type == Float.class
    || type == Short.class
    || type == Character.class
    || type == Byte.class
    || type == Double.class;
}


static boolean isArrayType(Class type) {
  return type != null && type.isArray();
}


static boolean hasThisDollarFields(Object o) {
  Matches m = new Matches();
  for (var f : allFieldObjects_dontMakeAccessible(o))
    if (startsWith(f.getName(), "this$", m) && isInteger(m.rest()))
      return true;
  return false;
}


static boolean hasSingleArgumentConstructor(Class c) {
  if (c != null)
    for (Constructor m : getDeclaredConstructors_cached(c))
      if (l(m.getParameterTypes()) == 1)
        return true;
  return false;
}


static Constructor getDefaultConstructor(Class c) {
  if (c != null)
    for (Constructor m : getDeclaredConstructors_cached(c))
      if (empty(m.getParameterTypes()))
        return m;
  return null;
}


static <A> boolean addToCollection(Collection<A> c, A a) {
  return c != null && c.add(a);
}


static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}


static byte[] boolArrayToBytes(boolean[] a) {
  byte[] b = new byte[(l(a)+7)/8];
  for (int i = 0; i < l(a); i++)
    if (a[i])
      b[i/8] |= 1 << (i & 7);
  return b;
}


static <A, B, C> List<Pair<A, C>> mapPairB(final Object f, Iterable<Pair<A, B>> l) {
  return map(l, new F1<Pair<A, B>, Pair<A, C>>() { public Pair<A, C> get(Pair<A, B> p) { try { 
    return p == null ? null : pair(p.a, (C) callF(f, p.b));
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "p == null ? null : pair(p.a, (C) callF(f, p.b))"; }});
}

static <A, B, C> List<Pair<A, C>> mapPairB(final F1<B, C> f, Iterable<Pair<A, B>> l) {
  return mapPairB((Object) f, l);
}

static <A, B, C> List<Pair<A, C>> mapPairB(final IF1<B, C> f, Iterable<Pair<A, B>> l) {
  return mapPairB((Object) f, l);
}

static <A, B, C> List<Pair<A, C>> mapPairB(Iterable<Pair<A, B>> l, IF1<B, C> f) {
  return mapPairB((Object) f, l);
}

static <A, B, C> Pair<A, C> mapPairB(IF1<B, C> f, Pair<A, B> p) {
  return pairMapB(f, p);
}

static <A, B, C> Pair<A, C> mapPairB(Pair<A, B> p, IF1<B, C> f) {
  return pairMapB(f, p);
}


static Method findMethod(Object o, String method, Object... args) {
  return findMethod_cached(o, method, args);
}

static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}


static <A, B> Map<B, A> mapToKey(Iterable<A> l, IF1<A, B> f) {
  return mapToKeys(l, f);
}



static <A, B> Map<B, A> mapToKey(IF1<A, B> f, Iterable<A> l) {
  return mapToKeys(f, l);
}


static Map<Class, List<String>> getFieldOrder_cache = weakMap();

static List<String> getFieldOrder(Object o) {
  return getFieldOrder(_getClass(o));
}

static List<String> getFieldOrder(Class c) {
  if (c == null) return null;
  return getOrCreate(getFieldOrder_cache, c,
    () -> splitAtSpace(toStringOpt(getOpt(c, "_fieldOrder"))));
}


static long parseLong(String s) {
  if (empty(s)) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}


  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }


static String mainClassNameForClassLoader(ClassLoader cl) {
  return or((String) callOpt(cl, "mainClassName"), "main");
}


static Class loadClassFromClassLoader_orNull(ClassLoader cl, String name) {
  try {
    return cl == null ? null : cl.loadClass(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}


static Random customRandomizerForThisThread() {
  return customRandomizerForThisThread_tl().get();
}


static <A> A optParam(ThreadLocal<A> tl, A defaultValue) {
  return optPar(tl, defaultValue);
}

static <A> A optParam(ThreadLocal<A> tl) {
  return optPar(tl);
}

static Object optParam(String name, Map params) {
  return mapGet(params, name);
}

// now also takes a map as single array entry
static <A> A optParam(Object[] opt, String name, A defaultValue) {
  int n = l(opt);
  if (n == 1 && opt[0] instanceof Map) {
    Map map =  (Map) (opt[0]);
    return map.containsKey(name) ? (A) map.get(name) : defaultValue;
  }
  if (!even(l(opt))) throw fail("Odd parameter length");
  for (int i = 0; i < l(opt); i += 2)
    if (eq(opt[i], name))
      return (A) opt[i+1];
  return defaultValue;
}

static Object optParam(Object[] opt, String name) {
  return optParam(opt, name, null);
}

static Object optParam(String name, Object[] params) {
  return optParam(params, name);
}


static LinkedHashMap paramsToOrderedMap(Object... params) {
  return asLinkedHashMap(paramsToMap(params));
}


static Object[] mapToObjectArray(Map map) {
  List l = new ArrayList();
  for (Object o : keys(map)) {
    l.add(o);
    l.add(map.get(o));
  }
  return toObjectArray(l);
}

static Object[] mapToObjectArray(Object f, Collection l) {
  int n = l(l);
  Object[] array = new Object[n];
  if (n != 0) {
    Iterator it = iterator(l);
    for (int i = 0; i < n; i++)
      array[i] = callF(f, it.next());
  }
  return array;
}

static Object[] mapToObjectArray(Object f, Object[] l) {
  int n = l(l);
  Object[] array = new Object[n];
  for (int i = 0; i < n; i++)
    array[i] = callF(f, l[i]);
  return array;
}

static <A> Object[] mapToObjectArray(Collection<A> l, IF1<A, Object> f) {
  return mapToObjectArray(f, l);
}

static <A> Object[] mapToObjectArray(A[] l, IF1<A, Object> f) {
  return mapToObjectArray(f, l);
}

static <A> Object[] mapToObjectArray(IF1<A, Object> f, A[] l) {
  int n = l(l);
  Object[] array = new Object[n];
  for (int i = 0; i < n; i++)
    array[i] = f.get(l[i]);
  return array;
}

static <A> Object[] mapToObjectArray(IF1<A, Object> f, Collection<A> l) {
  int n = l(l);
  Object[] array = new Object[n];
  if (n != 0) {
    Iterator it = iterator(l);
    for (int i = 0; i < n; i++)
      array[i] = callF(f, it.next());
  }
  return array;
}


// this should be on by default now I think, but it may break
// legacy code...
static ThreadLocal<Boolean> htmlencode_forParams_useV2 = new ThreadLocal();

static String htmlencode_forParams(String s) {
  if (s == null) return "";
  if (isTrue(htmlencode_forParams_useV2.get()))
    return htmlencode_forParams_v2(s);
    
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>') {
          out.append("&#");
          out.append((int) c);
          out.append(';');
      } else
          out.append(c);
  }
  return out.toString();
}


static boolean checkCondition(Object condition, Object... args) {
  return isTrue(callF(condition, args));
}

static <A> boolean checkCondition(IF1<A, Boolean> condition, A arg) {
  return isTrue(callF(condition, arg));
}


static int boolToInt(boolean b) {
  return b ? 1 : 0;
}


static <A> A[] arrayOfSameType(A[] a, int n) {
  return newObjectArrayOfSameType(a, n);
}


static List<String> codeTokens(List<String> tok) {
  return codeTokensOnly(tok);
}


static List<String> dropPunctuation_keep = ll("*", "<", ">");

static List<String> dropPunctuation(List<String> tok) {
  tok = new ArrayList<String>(tok);
  for (int i = 1; i < tok.size(); i += 2) {
    String t = tok.get(i);
    if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
      tok.set(i-1, tok.get(i-1) + tok.get(i+1));
      tok.remove(i);
      tok.remove(i);
      i -= 2;
    }
  }
  return tok;
}

static String dropPunctuation(String s) {
  return join(dropPunctuation(nlTok(s)));
}




static int iround(double d) {
  return (int) Math.round(d);
}


static int iround(Number n) {
  return iround(toDouble(n));
}



static Object defaultDefaultClassFinder() {
  return new F1<String, Class>() {
    public Class get(String name) {
      // Fix some buggy concepts files out there
      name = replacePrefix("main$main$", "main$", name);
      
      Class c = get2(name);
      
      return c;
    }
      
    Class get2(String name) {
      // special invocation to find main class irrelevant of name
      if (eq(name, "<main>")) return mc();
      
      { Class c = findClass_fullName(name); if (c != null) return c; }
      
      if (startsWithAny(name, "loadableUtils.utils$", "main$", mcDollar()))
        for (String pkg : ll("loadableUtils.utils$", mcDollar())) {
          String newName = pkg + afterDollar(name);
          
          { Class c = findClass_fullName(newName); if (c != null) return c; }
        }
      return null;
    }
  };
}


static volatile String caseID_caseID;

static String caseID() { return caseID_caseID; }

static void caseID(String id) {
  caseID_caseID = id;
}


static String quoteUnlessIdentifierOrInteger(String s) {
  return quoteIfNotIdentifierOrInteger(s);
}


static boolean hasBot(String searchPattern) { try {
  DialogIO io = findBot(searchPattern);
  if (io != null) {
    io.close();
    return true;
  } else
    return false;
} catch (Exception __e) { throw rethrow(__e); } }


static String dropSuffix(String suffix, String s) {
  return nempty(suffix) && endsWith(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}


static boolean isOK(String s) {
  s = trim(s);
  return swic(s, "ok ") || eqic(s, "ok") || matchStart("ok", s);
}


static String sendOpt(String bot, String text, Object... args) {
  return sendToLocalBotOpt(bot, text, args);
}


static boolean isMainProgram() {
  return creator() == null;
}


static void cleanKill() {
  cleanKillVM();
}


static String _userHome;
static String userHome() {
  if (_userHome == null)
    return actualUserHome();
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}


static String dbBotName(String progIDWithCase) {
  return fsI_flex(progIDWithCase) + " Concepts";
}


static String actualUserHome_value;
static String actualUserHome() {
  if (actualUserHome_value == null) {
    if (isAndroid())
      actualUserHome_value = "/storage/emulated/0/";
    else
      actualUserHome_value = System.getProperty("user.home");
  }
  return actualUserHome_value;
}

static File actualUserHome(String sub) {
  return newFile(new File(actualUserHome()), sub);
}


static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
  return methodsBot2(name, receiver, exposedMethods, null);
}

static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
  Android3 android = new Android3();
  android.greeting = name;
  android.console = false;
  android.responder = new Responder() {
    String answer(String s, List<String> history) {
      return exposeMethods2(receiver, s, exposedMethods, lock);
    }
  };
  return makeBot(android);
}


static List<String> db_standardExposedMethods_list = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

static List<String> db_standardExposedMethods() {
  return db_standardExposedMethods_list;
}


static Matcher regexp(String pat, String s) {
  return regexp(compileRegexp(pat), unnull(s));
}

static Matcher regexp(java.util.regex.Pattern pat, String s) {
  return pat.matcher(unnull(s));
}

static java.util.regex.Pattern regexp(String pat) {
  return compileRegexp(pat);
}


static List<File> listFilesNotDirs(String dir) {
  return listFilesOnly(dir);
}

static List<File> listFilesNotDirs(File... dirs) {
  return listFilesOnly(dirs);
}


static int matcherInt(Matcher m, int i) {
  return parseInt(m.group(i));
}


// month = 1 to 12
static long timestampFromYMDHM(int y, int m, int d, int h, int minutes) {
  return new GregorianCalendar(y, m-1, d, h, minutes).getTimeInMillis();
}


static <A> List<A> sortByMap_inPlace(List<A> l, Map<A, ?> map) {
  sort(l, mapComparator(map));
  return l;
}


// age = age in days, lastAge = age of last (more recent) file kept (also in days)
static boolean defaultAgeBasedBackupRetentionStrategy_shouldKeep(double age, double lastAge) {
  if (age <= 1/12.0) return true; // keep all backups within last hour
  if (age <= 0.5 && age >= lastAge+1/12.0) return true; // keep hourly backups within last 12 hours
  if (age <= 7 && age >= lastAge+1) return true; // keep every daily backup from this week
  if (age <= 28 && age >= lastAge+7) return true; // weekly backups for 3 more weeks
  if (age >= lastAge+365.0/12) return true; // after 4 weeks, switch to monthly (roundabout)
  return false;
}


static <A> A vm_generalMap_getOrCreate(Object key, F0<A> create) {
  return vm_generalMap_getOrCreate(key, f0ToIF0(create));
}

static <A> A vm_generalMap_getOrCreate(Object key, IF0<A> create) {
  Map generalMap = vm_generalMap();
  if (generalMap == null) return null; // must be x30 init
  
  synchronized(generalMap) { // should switch to locks here
    A a =  (A) (vm_generalMap_get(key));
    if (a == null)
      vm_generalMap_put(key, a = create == null ? null : create.get());
    return a;
  }
}



static <A> List<A> synchroList() {
  return synchroList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  
    return new SynchronizedList(l);
  
  
}



static void pcallFAll(Collection l, Object... args) {
  if (l != null) for (Object f : cloneList(l)) pcallF(f, args);
}

static void pcallFAll(Iterator it, Object... args) {
  while (it.hasNext()) pcallF(it.next(), args);
}


static Class javax() {
  return getJavaX();
}


static <A extends Throwable> A printException(A e) {
  printStackTrace(e);
  return e;
}


static <A, B> B mapPutOrRemove(Map<A, B> map, A key, B value) {
  if (map != null && key != null)
    if (value != null) return map.put(key, value);
    else return map.remove(key);
  return null;
}


static <A> TreeMap<String, A> ciMap() {
  return caseInsensitiveMap();
}


static char lastChar(String s) {
  return empty(s) ? '\0' : s.charAt(l(s)-1);
}


static boolean hasMethod(Object o, String method, Object... args) {
  return findMethod_cached(o, method, args) != null;
}


static HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  if (callMC_cache == null) callMC_cache = new HashMap(); // initializer time workaround
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) try {
    return invokeMethod(me, null, args);
  } catch (IllegalArgumentException e) {
    throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
  }

  List<Method> m;
  synchronized(callMC_cache) {
    m = callMC_cache.get(method);
  }
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    try {
      return invokeMethod(me, null, args);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException("Can't call " + me + " with arguments " + classNames(args), e);
    }
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return invokeMethod(me, null, args);
  }
  throw fail("No method called " + method + " with arguments (" + joinWithComma(getClasses(args)) + ") found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static void callMC_makeCache() {
  synchronized(callMC_cache) {
    callMC_cache.clear();
    Class _c = (Class) mc(), c = _c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods())
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          makeAccessible(m);
          multiMapPut(callMC_cache, m.getName(), m);
        }
      c = c.getSuperclass();
    }
  }
}


// contains voidfunc(childClass)
static ThreadLocal makeAndCall_initChild = new ThreadLocal();

static Object makeAndCall_cached(String functionName, Object... args) {
  Class c = loadFunctions_cached(functionName);
  AutoCloseable closer =  (AutoCloseable) (callF(makeAndCall_initChild.get(), c));
   AutoCloseable __1 = closer; try {
  return preciseCall(c, functionName, args);
} finally { _close(__1); }}


static boolean isSlowMachine() {
  return eq("1", trimLoadTextFile(javaxDataDir("is-slow-machine.txt")));
}


static Map<String, String> stdFunctions_cached_map; // name -> snippet ID
static Lock stdFunctions_cached_lock = lock();

static Map<String, String> stdFunctions_cached() {
  Lock __0 = stdFunctions_cached_lock; lock(__0); try {
  if (stdFunctions_cached_map == null)
    stdFunctions_cached_map = stdFunctions_uncached();
  return stdFunctions_cached_map;
} finally { unlock(__0); } }

static synchronized void stdFunctions_clearCache() {
  stdFunctions_cached_map = null;
}


static boolean isMD5(String s) {
  return l(s) == 32 && isLowerHexString(s);
}


static String getUpToDateSnippetTranspilationMD5(String snippetID) { try {
  return loadPageSilently(tb_mainServer() + "/tb-int/get-transpilation-md5.php?id=" + psI(snippetID)
    + standardCredentials_noCookies());
} catch (Exception __e) { throw rethrow(__e); } }


static String getServerTranspiledWithoutLibs(String snippetID) {
  return dropFirstLine(getServerTranspiled2(snippetID));
}


static String getTranspiledStandardFunctionsIfCached(TreeSet<String> functionSet) { try {
  File f = transpiledStandardFunctions_file(functionSet);
  //printFileStatus(f);
  return loadTextFile(f);
} catch (Throwable __e) { return null; } }


static boolean standardFunctionsCacheUpToDate(TreeSet<String> functionSet) {
  File f = transpiledStandardFunctions_file(functionSet);
  long date = recommendedTranspilationDateForStandardFunctions(functionSet);
  return date != 0 && f.lastModified() >= date;
}


static String joinWithPlus(Collection<String> c) {
  return join("+", c);
}

static String joinWithPlus(String... c) {
  return join("+", c);
}



static Class veryQuickJava_finish(String src, List<String> libs) {
  libs = cloneList(libs);
  src = findTranslators2(src, libs);
  //print("Libs found: " + struct(libs));
  
  String dehlibs = join(" ", libs);
  File bytecode = null;
  //try {
    bytecode = javaCompile_overInternalBot(src, dehlibs);
  /*} on fail {
    print("Was compiling: " + src + "\n");
  }*/

  return hotwireCore(concatLists(ll(bytecode), loadLibraries(libs)));
}


static boolean loadFunctions_debug = false;
static Object loadFunctions_veryQuickJava;

static Class loadFunctions(String... functions) {
  return loadFunctions(asList(functions));
}

static Class loadFunctions(Collection<String> functions, Object... __) {
  print("Compiling " + joinWithPlus(functions));
  TreeSet<String> functionSet = new TreeSet<String>(functions);
  StringBuilder buf = stringBuilder(appendNewLineIfNempty(stringPar("header", __)));
  for (String s : functionSet)
    buf.append("please include function " + assertIdentifier(s) + ".\n");
  long time = sysNow();
  Class c;
  if (loadFunctions_veryQuickJava != null)
    c = (Class) callF(loadFunctions_veryQuickJava, str(buf));
  else {
    veryQuickJava_transpiled.set(""); // request transpilation
    c = veryQuickJava(str(buf));
    saveTranspiledStandardFunctions(functionSet, getAndClearThreadLocal(veryQuickJava_transpiled));
  }
  if (loadFunctions_debug)
    done2_always(time, "loadFunctions: " + join(" ", functions));
  return c;
}




static void ownResource(AutoCloseable c) {
  _registerAutoCloseable(c);
}


static <A> AutoCloseable vmBus_onMessage(String msg, IVF1<A> onMessage) {
  return vmBus_onMessage(msg, ivf1ToVF1(onMessage));
}

static <A> AutoCloseable vmBus_onMessage(final String msg, final VF1<A> onMessage) {
  Map<String, Set> map = vm_busListenersByMessage_live();
  synchronized(map) {
    Set listeners = map.get(msg);
    if (listeners == null) map.put(msg, listeners = syncIdentityHashSet());
    // We're technically violating the one-synchronized-object-per-thread rule,
    // but it should be OK here.
    // TODO: remove empty sets from map
    return tempAdd(listeners, new VF2<String, Object>() { public void get(String _msg, Object arg) { try { 
      callF(onMessage, arg)
    ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callF(onMessage, arg)"; }});
  }
}


static <A, B> AutoCloseable vmBus_onMessage(String msg, final VF2<A, B> onMessage) {
  return vmBus_onMessage(msg, new VF1<Object[]>() { public void get(Object[] o) { try { 
    callF(onMessage, first(o), second(o));
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callF(onMessage, first(o), second(o));"; }});
}


static <A, B> AutoCloseable vmBus_onMessage(String msg, final IVF2<A, B> onMessage) {
  return vmBus_onMessage(msg, new VF1<Object[]>() { public void get(Object[] o) { try { 
    callF(onMessage, first(o), second(o));
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callF(onMessage, first(o), second(o));"; }});
}





static AutoCloseable vmBus_onMessage(String msg, Runnable onMessage) {
  return vmBus_onMessage(msg, runnableToVF1(onMessage));
}


static void loadFunctions_clearCache() {
  callOptMC("loadFunctions_cached_clearCache");
}


static <A> A[] arrayOfType(Class<A> type, int n) {
  return makeArray(type, n);
}

static <A> A[] arrayOfType(int n, Class<A> type) {
  return arrayOfType(type, n);
}


static String dropNumberPrefix(String s) {
  return dropFirst(s, indexOfNonDigit(s));
}


static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { printStackTrace(__e); }
  return null;
}


static boolean networkAllowanceTest(String url) {
  
  
  return isAllowed("networkAllowanceTest", url);
  
}


static void sleepSeconds(double s) {
  if (s > 0) sleep(round(s*1000));
}


static String tb_mainServer_default = "https://code.botcompany.de:9898";
static Object tb_mainServer_override; // func -> S

static String tb_mainServer() {
  if (tb_mainServer_override != null) return (String) callF(tb_mainServer_override);
  return trim(loadTextFile(tb_mainServer_file(),
    tb_mainServer_default));
}

static File tb_mainServer_file() {
  return getProgramFile("#1001638", "mainserver.txt");
}

static boolean tb_mainServer_isDefault() {
  return eq(tb_mainServer(), tb_mainServer_default);
}


static <A> A printWithTime(A a) {
  return printWithTime("", a);
}

static <A> A printWithTime(String s, A a) {
  print(hmsWithColons() + ": " + s, a);
  return a;
}


static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
  A a = tl.get();
  tl.set(null);
  return a;
}


static void setHeaders(URLConnection con) throws IOException {
  
  String computerID = getComputerID_quick();
  if (computerID != null) try {
    con.setRequestProperty("X-ComputerID", computerID);
    con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
  } catch (Throwable e) {
    //printShortException(e);
  }
  
}


static Map vm_generalSubMap(Object name) {
  synchronized(vm_generalMap()) {
    Map map =  (Map) (vm_generalMap_get(name));
    if (map == null)
      vm_generalMap_put(name, map = synchroMap());
    return map;
  }
}



static InputStream urlConnection_getInputStream(URLConnection con) throws IOException {
  return con.getInputStream();
}


static String toHex(byte[] bytes) {
  return bytesToHex(bytes);
}

static String toHex(byte[] bytes, int ofs, int len) {
  return bytesToHex(bytes, ofs, len);
}



static byte[] utf8(String s) {
  return toUtf8(s);
}


static Matcher regexpMatcher(String pat, String s) {
  return compileRegexp(pat).matcher(unnull(s));
}

static Matcher regexpMatcher(java.util.regex.Pattern pat, String s) {
  return pat.matcher(unnull(s));
}


static URLConnection openConnection(String url) { try {
  return openConnection(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }

static URLConnection openConnection(URL url) { try {
  ping();
  
  callOpt(javax(), "recordOpenURLConnection", str(url));
  
  return url.openConnection();
} catch (Exception __e) { throw rethrow(__e); } }


static URLConnection setURLConnectionTimeouts(URLConnection con, long timeout) {
  con.setConnectTimeout(toInt(timeout));
  con.setReadTimeout(toInt(timeout));
  if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
    print("Warning: Timeouts not set by JDK.");
  return con;
}


static URLConnection setURLConnectionDefaultTimeouts(URLConnection con, long timeout) {
  if (con.getConnectTimeout() == 0) {
    con.setConnectTimeout(toInt(timeout));
    if (con.getConnectTimeout() != timeout)
      print("Warning: URL connect timeout not set by JDK.");
  }
  if (con.getReadTimeout() == 0) {
    con.setReadTimeout(toInt(timeout));
    if (con.getReadTimeout() != timeout)
      print("Warning: URL read timeout not set by JDK.");
  }
  return con;
}


static String makePostData(Map map) {
  StringBuilder buf = new StringBuilder();
  for (Map.Entry<Object, Object> e : castMapToMapO(map).entrySet()) {
    String key =  (String) (e.getKey());
    Object val = e.getValue();
    if (val != null) {
      String value = str(val);
      if (nempty(buf)) buf.append("&");
      buf.append(urlencode(key)).append("=").append(urlencode(/*escapeMultichars*/(value)));
    }
  }
  return str(buf);
}

static String makePostData(Object... params) {
  StringBuilder buf = new StringBuilder();
  int n = l(params);
  for (int i = 0; i+1 < n; i += 2) {
    String key =  (String) (params[i]);
    Object val = params[i+1];
    if (val != null) {
      String value = str(val);
      if (nempty(buf)) buf.append("&");
      buf.append(urlencode(key)).append("=").append(urlencode(/*escapeMultichars*/(value)));
    }
  }
  return str(buf);

}



static Map paramsToMap(Object... params) {
  int n = l(params);
  if (l(params) == 1 && params[0] instanceof Map) return (Map) params[0];
  LinkedHashMap map = new LinkedHashMap();
  for (int i = 0; i+1 < n; i += 2)
    mapPut(map, params[i], params[i+1]);
  return map;
}


static Throwable getException(Runnable r) {
  try {
    callF(r);
    return null;
  } catch (Throwable e) {
    return e;
  }
}


static boolean domainIsUnder(String domain, String mainDomain) {
  return eqic(domain, mainDomain) || ewic(domain, "." + mainDomain);
}


static String theAGIBlueDomain() {
  return "agi.blue";
}


static boolean argumentCompatibleWithType(Object arg, Class type) {
  return arg == null ? !type.isPrimitive() : isInstanceX(type, arg);
}


static void arraycopy(Object[] a, Object[] b) {
  if (a != null && b != null)
    arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
}

static void arraycopy(Object src, int srcPos, int destPos, int n) { arraycopy(src, srcPos, src, destPos, n); }
static void arraycopy(Object src, int srcPos, Object dest, int destPos, int n) {
  if (n != 0)
    System.arraycopy(src, srcPos, dest, destPos, n);
}


static List<String> getClassNames(Collection l) {
  List<String> out = new ArrayList();
  if (l != null) for (Object o : l)
    out.add(o == null ? null : getClassName(o));
  return out;
}


static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}


static Throwable _storeException_value;

static void _storeException(Throwable e) {
  _storeException_value = e;
}


static <A> Set<A> syncIdentityHashSet() {
  return (Set) synchronizedSet(identityHashSet());
}


static Map syncHashMap() {
  return synchroHashMap();
}


static Map<String, String> singular_specials = litmap(
  "children", "child", "images", "image", "chess", "chess");
  
static Set<String> singular_specials2 = litciset("time", "machine", "line", "rule");

static String singular(String s) {
  if (s == null) return null;
  { String __1 = singular_specials.get(s); if (!empty(__1)) return __1; }
  //try answer hippoSingulars().get(lower(s));
  if (singular_specials2.contains(dropSuffix("s", afterLastSpace(s))))
    return dropSuffix("s", s);
  if (s.endsWith("ness")) return s;
  if (s.endsWith("ges")) return dropSuffix("s", s);
  if (endsWith(s, "bases")) return dropLast(s);
  s = dropSuffix("es", s);
  s = dropSuffix("s", s);
  return s;
}


static Set<String> getPlural_specials = litciset("sheep", "fish");

static String getPlural(String s) {
  if (contains(getPlural_specials, s)) return s;
  if (ewic(s, "y")) return dropSuffixIgnoreCase("y", s) + "ies";
  if (ewicOneOf(s, "ss", "ch")) return s + "es";
  if (ewic(s, "s")) return s;
  return s + "s";
}


static boolean isTrueOrYes(Object o) {
  return isTrueOpt(o) || o instanceof String && (eqicOneOf(((String) o), "1", "t", "true") || isYes(((String) o)));
}


static <A, B> LinkedHashMap<A, B> asLinkedHashMap(Map<A, B> map) {
  if (map instanceof LinkedHashMap) return (LinkedHashMap) map;
  LinkedHashMap<A, B> m = new LinkedHashMap();
  if (map != null) synchronized(collectionMutex(map)) {
    m.putAll(map);
  }
  return m;
}


static void setDynObjectValue(DynamicObject o, String field, Object value) {
  dynamicObject_setRawFieldValue(o, field, value);
}


static void metaMapPut(IMeta o, Object key, Object value) {
  { if (o != null) o.metaPut(key, value); }
}

static void metaMapPut(Object o, Object key, Object value) {
  var meta = initIMeta(o);
  { if (meta != null) meta.metaPut(key, value); }
}


static void upgradeJavaXAndRestart() {
  
    run("#1001639");
    restart();
    sleep();
  
  
}


static String actualProgramID() {
  //try answer getProgramIDOrNull(realMC());
  return programID();
}


static File javaxSecretDir_dir; // can be set to work on different base dir

static File javaxSecretDir() {
  return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
}

static File javaxSecretDir(String sub) {
  return newFile(javaxSecretDir(), sub);
}


static boolean methodIsStatic(Method m) {
  return (m.getModifiers() & Modifier.STATIC) != 0;
}



  static <A> A callF_gen(F0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF_gen(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }



  static <A> A callF_gen(IF0<A> f) {
    return f == null ? null : f.get();
  }



  static <A, B> B callF_gen(IF1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }


static <A, B> B callF_gen(A a, IF1<A, B> f) {
  return f == null ? null : f.get(a);
}


  static <A, B, C> C callF_gen(F2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A, B, C> C callF_gen(IF2<A, B, C> f, A a, B b) {
    return f == null ? null : f.get(a, b);
  }



  static <A> void callF_gen(VF1<A> f, A a) {
    { if (f != null) f.get(a); }
  }


static <A> void callF_gen(A a, IVF1<A> f) {
  { if (f != null) f.get(a); }
}

static <A> void callF_gen(IVF1<A> f, A a) {
  { if (f != null) f.get(a); }
}

static Object callF_gen(Runnable r) { { if (r != null) r.run(); } return null; }

static Object callF_gen(Object f, Object... args) {
  return callF(f, args);
}


static boolean endsWithIgnoreCase(String a, String b) {
  int la = l(a), lb = l(b);
  return la >= lb && regionMatchesIC(a, la-lb, b, 0, lb);
}


static boolean endsWithIgnoreCase(String a, String b, Matches m) {
  if (!endsWithIgnoreCase(a, b)) return false;
  if (m != null)
    m.m = new String[] { substring(a, 0, l(a)-l(b)) };
  return true;
}



static BufferedReader bufferedReader(Reader r) { return bufferedReader(r, 8192); }
static BufferedReader bufferedReader(Reader r, int bufSize) {
  if (r == null) return null;
  return r instanceof BufferedReader ? (BufferedReader) r : _registerIOWrap(new BufferedReader(r, bufSize), r);
}


static <A extends AutoCloseable> A holdResource(IResourceHolder holder, A a) {
  { if (holder != null) holder.add(a); }
  return a;
}


static <A> CloseableIterableIterator<A> iteratorFromFunction_f0_autoCloseable(final F0<A> f, final AutoCloseable closeable) {
  class IFF2 extends CloseableIterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
    
    public void close() throws Exception {
      if (closeable != null) closeable.close();
    }
  };
  return new IFF2();
}


static String readLineFromReaderWithClose(BufferedReader r) { try {
  String s = r.readLine();
  if (s == null) r.close();
  return s;
} catch (Exception __e) { throw rethrow(__e); } }


static AutoCloseable _wrapIOCloseable(final AutoCloseable c) {
  return c == null ? null : new AutoCloseable() { public String toString() { return "c.close();\r\n    _registerIO(c, null, false);"; } public void close() throws Exception { c.close();
    _registerIO(c, null, false);
  }};
}



static <A> A _registerIOWrap(A wrapper, Object wrapped) {
  return wrapper;
}


static FileInputStream newFileInputStream(File path) throws IOException {
  return newFileInputStream(path.getPath());
}

static FileInputStream newFileInputStream(String path) throws IOException {
  FileInputStream f = new FileInputStream(path);
  _registerIO(f, path, true);
  return f;
}


static int gzInputStream_defaultBufferSize = 65536;

static GZIPInputStream gzInputStream(File f) { try {
  return gzInputStream(new FileInputStream(f));
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(File f, int bufferSize) { try {
  return gzInputStream(new FileInputStream(f), bufferSize);
} catch (Exception __e) { throw rethrow(__e); } }

static GZIPInputStream gzInputStream(InputStream in) {
  return gzInputStream(in, gzInputStream_defaultBufferSize);
}

static GZIPInputStream gzInputStream(InputStream in, int bufferSize) { try {
  return _registerIOWrap(new GZIPInputStream(in, gzInputStream_defaultBufferSize), in);
} catch (Exception __e) { throw rethrow(__e); } }


static TreeSet<String> toCaseInsensitiveSet_treeSet(Iterable<String> c) {
  if (isCISet(c)) return (TreeSet) c;
  TreeSet<String> set = caseInsensitiveSet_treeSet();
  addAll(set, c);
  return set;
}

static TreeSet<String> toCaseInsensitiveSet_treeSet(String... x) {
  TreeSet<String> set = caseInsensitiveSet_treeSet();
  addAll(set, x);
  return set;
}


static Object swing(Object f) {
  return swingAndWait(f);
}

static void swing(Runnable f) {
  swingAndWait(f);
}

static <A> A swing(F0<A> f) {
  return (A) swingAndWait(f);
}

static <A> A swing(IF0<A> f) {
  return (A) swingAndWait(f);
}


static <A extends Component> A revalidate(final A c) {
  if (c == null || !c.isShowing()) return c;
  { swing(() -> { 
    // magic combo to actually relayout and repaint
    c.revalidate();
    c.repaint();
  }); }
  return c;
}

static void revalidate(JFrame f) { revalidate((Component) f); }
static void revalidate(JInternalFrame f) { revalidate((Component) f); }


static boolean isLetter(char c) {
  return Character.isLetter(c);
}


static ClassLoader classLoaderForObject(Object o) {
  if (o instanceof ClassLoader) return ((ClassLoader) o);
  if (o == null) return null;
  return _getClass(o).getClassLoader();
}


static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}


static List<String> javaTokForStructure(String s) {
  return javaTok_noMLS(s);
}


static String structure_addTokenMarkers(String s) {
  return join(structure_addTokenMarkers(javaTokForStructure(s)));
}
  
static List<String> structure_addTokenMarkers(List<String> tok) {
  // find references
  
  TreeSet<Integer> refs = new TreeSet();
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (t.startsWith("t") && isInteger(t.substring(1)))
      refs.add(parseInt(t.substring(1)));
  }
  
  if (empty(refs)) return tok;
  
  // add markers
  for (int i : refs) {
    int idx = i*2+1;
    if (idx >= l(tok)) continue; // broken structure
    String t = "";
    if (endsWithLetterOrDigit(tok.get(idx-1))) t = " ";
    tok.set(idx, t + "m" + i + " " + tok.get(idx));
  }
  
  return tok;
}




static SimpleDateFormat simpleDateFormat_local(String format) {
  SimpleDateFormat sdf = new SimpleDateFormat(format);
  sdf.setTimeZone(localTimeZone());
  return sdf;
}


static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}



static boolean sameSnippetID(String a, String b) {
  if (!isSnippetID(a) || !isSnippetID(b)) return false;
  return parseSnippetID(a) == parseSnippetID(b);
}


static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}

static File javaxDataDir(String... subs) {
  return newFile(javaxDataDir(), subs);
}


static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}

static String f2s(String s) { return f2s(newFile(s)); }


 static String f2s(java.nio.file.Path p) {
  return p == null ? null : f2s(p.toFile());
}



static void _registerIO(Object object, String path, boolean opened) {
}


static <A> AutoCloseable tempSetTL(ThreadLocal<A> tl, A a) {
  return tempSetThreadLocal(tl, a);
}


static <A> AutoCloseable tempSetTL(BetterThreadLocal<A> tl, A a) {
  return tempSetThreadLocalIfNecessary(tl, a);
}



static <A> List<A> concatLists(Iterable<A>... lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Iterable<A> list : lists)
    addAll(l, list);
  return l;
}

static <A> List<A> concatLists(Collection<? extends Iterable<A>> lists) {
  List<A> l = new ArrayList();
  if (lists != null) for (Iterable<A> list : lists)
    addAll(l, list);
  return l;
}



static String appendColonIfNempty(String s) {
  return empty(s) ? "" : s + ": ";
}


static boolean isEmpty(Collection c) {
  return c == null || c.isEmpty();
}

static boolean isEmpty(CharSequence s) {
  return s == null || s.length() == 0;
}

static boolean isEmpty(Object[] a) { return a == null || a.length == 0; }
static boolean isEmpty(byte[] a) { return a == null || a.length == 0; }

static boolean isEmpty(Map map) {
  return map == null || map.isEmpty();
}




static boolean isEmpty(AppendableChain c) { return c == null; }



static <A> List<A> cloneSubList(List<A> l, int startIndex, int endIndex) {
  return newSubList(l, startIndex, endIndex);
}

static <A> List<A> cloneSubList(List<A> l, int startIndex) {
  return newSubList(l, startIndex);
}


static Object realMC() {
  return getThreadLocal(realMC_tl());
}


static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}

static int lastIndexOf(String a, char b) {
  return a == null ? -1 : a.lastIndexOf(b);
}

// starts searching from i-1
static <A> int lastIndexOf(List<A> l, int i, A a) {
  if (l == null) return -1;
  for (i = min(l(l), i)-1; i >= 0; i--)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int lastIndexOf(List<A> l, A a) {
  if (l == null) return -1;
  for (int i = l(l)-1; i >= 0; i--)
    if (eq(l.get(i), a))
      return i;
  return -1;
}


static List<Field> allFieldObjects_dontMakeAccessible(Object o) {
  List<Field> fields = new ArrayList();
  Class _c = _getClass(o);
  do {
    addAll(fields, _c.getDeclaredFields());
    _c = _c.getSuperclass();
  } while (_c != null);
  return fields;
}


static Pair pairMapB(Object f, Pair p) {
  return p == null ? null : pair(p.a, callF(f, p.b));
}

static <A, B, C> Pair<A, C> pairMapB(IF1<B, C> f, Pair<A, B> p) {
  return p == null ? null : pair(p.a, f.get(p.b));
}

static Pair pairMapB(Pair p, Object f) {
  return pairMap(f, p);
}



static Method findMethod_cached(Object o, String method, Object... args) { try {
  if (o == null) return null;
  if (o instanceof Class) {
    _MethodCache cache = callOpt_getCache((Class) o);
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (isStaticMethod(m) && findMethod_checkArgs(m, args, false))
        return m;
    return null;
  } else {
    _MethodCache cache = callOpt_getCache(o.getClass());
    List<Method> methods = cache.cache.get(method);
    if (methods != null) for (Method m : methods)
      if (findMethod_checkArgs(m, args, false))
        return m;
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }



static <A, B> Map<B, A> mapToKeys(Iterable<A> l, IF1<A, B> f) {
  if (l == null) return null;
  HashMap<B, A> map = new HashMap();
  for (A a : l)
    map.put(f.get(a), a);
  return map;
}

static <A, B> Map<B, A> mapToKeys(IF1<A, B> f, A[] l) { return mapToKeys(f, asList(l)); }
static <A, B> Map<B, A> mapToKeys(IF1<A, B> f, Iterable<A> l) {
  return mapToKeys(l, f);
}


static <A, B> Map<A, B> weakMap() {
  return newWeakHashMap();
}


// allows null keys but not null values

static <A, B> B getOrCreate(Map<A, B> map, A key, Class<? extends B> c) { try {
  B b = map.get(key);
  if (b == null)
    map.put(key, b = c.newInstance());
  return b;
} catch (Exception __e) { throw rethrow(__e); } }

// f : func -> B
static <A, B> B getOrCreate(Map<A, B> map, A key, Object f) { try {
  B b = map.get(key);
  if (b == null)
    map.put(key, b = (B) callF(f));
  return b;
} catch (Exception __e) { throw rethrow(__e); } }

static <A, B> B getOrCreate(IF0<B> f, Map<A, B> map, A key) {
  return getOrCreate(map, key, f);
}

static <A, B> B getOrCreate(Map<A, B> map, A key, IF0<B> f) {
  B b = map.get(key);
  if (b == null)
    map.put(key, b = f.get());
  return b;
}

static <A, B> B getOrCreate(Class<? extends B> c, Map<A, B> map, A key) {
  return getOrCreate(map, key, c);
}


static String toStringOpt(Object o) {
  return o instanceof String ? ((String) o) : null;
}


static ThreadLocal<Random> customRandomizerForThisThread_tl = new ThreadLocal();

static ThreadLocal<Random> customRandomizerForThisThread_tl() {
  return customRandomizerForThisThread_tl;
}


static boolean even(int i) {
  return (i & 1) == 0;
}

static boolean even(long i) {
  return (i & 1) == 0;
}

static boolean even(BigInteger n) {
  return even(n.intValue());
}


static String htmlencode_forParams_v2(String s) {
  if (s == null) return "";
  StringBuilder out = new StringBuilder(Math.max(16, s.length()));
  for (int i = 0; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c > 127 || c == '"' || c == '<' || c == '>' || c == '&') {
          out.append("&#");
          out.append((int) c);
          out.append(';');
      } else
          out.append(c);
  }
  return out.toString();
}


static <A> A[] newObjectArrayOfSameType(A[] a) { return newObjectArrayOfSameType(a, a.length); }
static <A> A[] newObjectArrayOfSameType(A[] a, int n) {
  return (A[]) Array.newInstance(a.getClass().getComponentType(), n);
}


static List<String> codeTokensOnly(List<String> tok) {
  int n = l(tok);
  List<String> l = emptyList(n/2);
  for (int i = 1; i < n; i += 2)
    l.add(tok.get(i));
  return l;
}


static List<String> nlTok(String s) {
  return javaTokPlusPeriod(s);
}




static double toDouble(Object o) {
  if (o instanceof Number)
    return ((Number) o).doubleValue();
  if (o instanceof BigInteger)
    return ((BigInteger) o).doubleValue();
  if (o instanceof String)
    return parseDouble((String) o);
  if (o == null) return 0.0;
  throw fail(o);
}


static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}


static Object get2(Object o, String field1, String field2) {
  return get(get(o, field1), field2);
}


static HashMap<String, Class> findClass_fullName_cache = new HashMap();

// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass_fullName(String name) {
  synchronized(findClass_fullName_cache) {
    if (findClass_fullName_cache.containsKey(name))
      return findClass_fullName_cache.get(name);
      
    Class c;
    try {
      c = Class.forName(name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_fullName_cache.put(name, c);
    return c;
  }
}


static boolean startsWithAny(String a, Collection<String> b) {
  for (String prefix : unnullForIteration(b))
    if (startsWith(a, prefix))
      return true;
  return false;
}

static boolean startsWithAny(String a, String... b) {
  if (b != null)
    for (String prefix : unnullForIteration(b))
      if (startsWith(a, prefix))
        return true;
  return false;
}


static boolean startsWithAny(String a, Collection<String> b, Matches m) {
  for (String prefix : unnullForIteration(b))
    if (startsWith(a, prefix, m))
      return true;
  return false;
}



static String mcDollar() {
  return mcName() + "$";
}


static String afterDollar(String s) {
  return substring(s, smartIndexOf(s, '$')+1);
}


static String quoteIfNotIdentifierOrInteger(String s) {
  if (s == null) return null;
  return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
}


static Map<String, Integer> findBot_cache = synchroHashMap();
static int findBot_timeout = 5000;

static DialogIO findBot(String searchPattern) {
  // first split off sub-bot suffix
  String subBot = null;
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i+1);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    
  if (eq(searchPattern, "remote"))
    return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    io.waitForLine(/*findBot_timeout*/); // TODO: implement
    String line = io.readLineNoBlock();
    if (indexOfIgnoreCase(line, searchPattern) == 0) {
      call(io, "pushback", line); // put hello string back in
      return talkToSubBot(subBot, io);
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      findBot_cache.put(searchPattern, p.port);
      return talkToSubBot(subBot, talkTo("localhost", p.port));
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
      }
    } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  }
        
  return null;
}


static boolean matchStart(String pat, String s) {
  return matchStart(pat, s, null);
}

// matches are as you expect, plus an extra item for the rest string
static boolean matchStart(String pat, String s, Matches matches) {
  if (s == null) return false;
  return matchStart(pat, parse3_cachedInput(s), matches);
}
  
static boolean matchStart(String pat, List<String> toks, Matches matches) {
  if (toks == null) return false;
  List<String> tokpat = parse3_cachedPattern(pat);
  if (toks.size() < tokpat.size()) return false;
  String[] m = match2(tokpat, toks.subList(0, tokpat.size()));
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) {
    matches.m = new String[m.length+1];
    arraycopy(m, matches.m);
    matches.m[m.length] = joinSubList(toks, tokpat.size(), toks.size()); // for Matches.rest()
  }
  return true;
}


static String sendToLocalBotOpt(String bot, String text, Object... args) {
  if (bot == null) return null;
  text = format(text, args);
   DialogIO channel = findBot(bot); try {
  if (channel == null) {
    print(quote(bot) + " not found, skipping send: " + quote(text));
    return null;
  }
  try {
    channel.readLine();
    print(shorten(bot + "> " + text, 200));
    channel.sendLine(text);
    String s = channel.readLine();
    print(shorten(bot + "< " + s, 200));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}


static WeakReference<Object> creator_class;

static Object creator() {
  return creator_class == null ? null : creator_class.get();
}


static void cleanKillVM() { try {
  ping();
  assertNotOnAWTThread();
  cleanKillVM_noSleep();
  Object o = new Object();
  synchronized(o) { o.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }

static void cleanKillVM_noSleep() {
  call(getJavaX(), "cleanKill");
}


static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}


static String fsI_flex(String s) {
  return startsWithDigit(s) ? "#" + s : s;
}


static boolean exposeMethods2_debug = false;

static String exposeMethods2(Object receiver, String s, List<String> methodNames) {
  return exposeMethods2(receiver, s, methodNames, null);
}

static String exposeMethods2(Object receiver, String s, List<String> methodNames,
  Lock lock) {
  Matches m = new Matches();
  if (exposeMethods2_debug) print("Received: " + s);
  if (match("call *", s, m)) {
    List l;
    if (isIdentifier(m.unq(0)))
      l = ll(m.unq(0));
    else
      l = (List) unstructure(m.unq(0)); // we used to have safeUnstructure here
    String method = getString(l, 0);
    if (!contains(methodNames, method))
      throw fail("Method not allowed: " + method);
    if (lock != null) lock.lock();
    try {
      if (exposeMethods2_debug) print("Calling: " + method);
      Object o = call(receiver, method, asObjectArray(subList(l, 1)));
      if (exposeMethods2_debug) print("Got: " + getClassName(o));
      return ok2(structure(o));
    } finally {
      if (lock != null) lock.unlock();
    }
  }
  if (match("list methods", s))
    return ok2(structure(methodNames));
  return null;
}


static int makeBot(String greeting) {
  return makeAndroid3(greeting).port;
}

static Android3 makeBot(Android3 a) {
  makeAndroid3(a);
  return a;
}

static Android3 makeBot(String greeting, Object responder) {
  Android3 a = new Android3(greeting);
  a.responder = makeResponder(responder);
  makeBot(a);
  return a;
}

static Android3 makeBot() {
  return makeAndroid3(defaultBotName());
}


static Map<String, java.util.regex.Pattern> compileRegexp_cache = syncMRUCache(10);

static java.util.regex.Pattern compileRegexp(String pat) {
  java.util.regex.Pattern p = compileRegexp_cache.get(pat);
  if (p == null) {
    
    compileRegexp_cache.put(pat, p = java.util.regex.Pattern.compile(pat));
  }
  return p;
}


static List<File> listFilesOnly(String dir) {
  return listFilesOnly(new File(dir));
}

static List<File> listFilesOnly(File... dirs) {
  return concatMap(dir -> listFilesWithSuffix("", dir), dirs);
}


static <A, B> Comparator<A> mapComparator(final Map<A, B> map) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(map.get(a), map.get(b));
    }
  };
}


static <A> IF0<A> f0ToIF0(F0<A> f) {
  return f == null ? null : () -> f.get();
}


static Class __javax;

static Class getJavaX() { try {
  
  return __javax;
} catch (Exception __e) { throw rethrow(__e); } }

static void __setJavaX(Class j) {
  __javax = j;
  _onJavaXSet();
}


static <A> TreeMap<String, A> caseInsensitiveMap() {
  return new TreeMap(caseInsensitiveComparator());
}


static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}


static <A, B> void multiMapPut(MultiMap<A, B> mm, A key, B value) {
  if (mm != null && key != null && value != null) mm.put(key, value);
}



static boolean preciseCall_debug = false;

static Object preciseCall(Object o, String method, Object... args) { try {
  if (o instanceof Class) {
    _MethodCache cache = callOpt_getCache((Class) o);
    List<Method> methods = cache.cache.get(method);
    //L<Method> methods = findMethodsNamed2(o, method, true);
    Lowest<Method> best = new Lowest();
    if (methods != null) for (Method m : methods) {
      { if (!(isStaticMethod(m))) continue; }
      int score = methodApplicabilityScore(m, args);
      if (score < Integer.MAX_VALUE) {
        if (preciseCall_debug)
          print("Method score: " + m + " " + score);
        best.put(m, score);
      }
    }
    Method m = best.get();
    if (m != null) 
      return invokeMethod(m, null, args);
    
    return call_withVarargs(((Class) o), method, args); // TODO: make this precise too
  } else
    throw todo();
} catch (Exception __e) { throw rethrow(__e); } }



static String trimLoadTextFile(String fileName) {
  return loadTextFile_trim(fileName);
}



static String trimLoadTextFile(File f, String defaultContents) {
  return loadTextFile_trim(f, defaultContents);
}



static String trimLoadTextFile(File fileName) {
  return loadTextFile_trim(fileName);
}



static String trimLoadTextFile(String fileName, String defaultContents) {
  return loadTextFile_trim(fileName, defaultContents);
}


static Map<String, String> stdFunctions_uncached() {
  return stdFunctions_uncached(new HashMap());
}

static Map<String, String> stdFunctions_uncached(Map<String, String> map) {
  for (var snippetID : stdFunctionListSnippetIDs())
    parseStdFunctionsList(loadSnippet(snippetID), map);
  return map;
}


static boolean isLowerHexString(String s) {
  for (int i = 0; i < l(s); i++) {
    char c = s.charAt(i);
    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      // ok
    } else
      return false;
  }
  return true;
}


static String standardCredentials_noCookies() {
  return standardCredentials() + "&noCookies=1";
}


static String dropFirstLine(String text) {
  if (text == null) return null;
  int i = text.indexOf('\n');
  return i >= 0 ? text.substring(i+1) : "";
}




static boolean getServerTranspiled2_allowLocalFallback = true, getServerTranspiled2_localFallbackVerbose = true;

// to avoid checking server for transpilations too often when booting OS
static Map<String, String> getServerTranspiled2_tempCache;

static String getServerTranspiled2(String id) {
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.getTranspiled(id);
  
  
  return getServerTranspiled2_noResourceLoader(id);
}
  
static String getServerTranspiled2_noResourceLoader(String id) {
  id = fsIOpt(id);
  
  String transpiled = mapGet(getServerTranspiled2_tempCache, id);
  if (transpiled != null) return transpiled;
  //if (getServerTranspiled2_tempCache != null) print("CACHE FAIL on " + id);
  
  transpiled = loadCachedTranspilation(id);
  String md5 = null;
  if (machineIsOffline() || isOfflineMode() || isLocalSnippet(id)) return transpiled;
  if (transpiled != null)
    md5 = md5(transpiled);
  String transpiledSrc;
  try {
    transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
  } catch (Throwable e) {
    if (!getServerTranspiled2_allowLocalFallback) rethrow(e);
    printExceptionShort(e);
    if (getServerTranspiled2_localFallbackVerbose) print("Fallback to local code");
    return transpiled;
  }
  if (eq(transpiledSrc, "SAME")) {
    if (!isTrue(loadPage_silent.get())) printWithMS("SAME");
    return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiled);
  }
  return mapPut_returnValue(getServerTranspiled2_tempCache, id, transpiledSrc);
}




static File transpiledStandardFunctions_file(TreeSet<String> functionSet) {
  String name = uniqueFileNameUsingMD5_80_v2(join("+", functionSet));
  File dir = javaxCachesDir("Transpiled Standard Functions");
  saveTextFileUnlessExists(newFile(dir, name + ".functions"), lines(functionSet));
  return newFile(dir, name + ".java");
}


static long recommendedTranspilationDateForStandardFunctions(Collection<String> sfNames) {
  long date = 0;
  for (String name : sfNames) {
    long d = recommendedTranspilationDateForStandardFunction(name);
    if (d == 0) return 0; // unknown, retranspile
    date = max(date, d);
  }
  return date;
}


// probably better than findTranslators (uses tokens)
// removes invocations from src
static String findTranslators2(String src, List<String> libsOut) {
  return join(findTranslators2(javaTok(src), libsOut));
}

// modifies original tok
static List<String> findTranslators2(List<String> tok, List<String> libsOut) {
  int i;
  while ((i = jfind(tok, "!<int>")) >= 0) {
    setAdd(libsOut, tok.get(i+2));
    clearTokens(tok, i, i+3);
  }
  return tok;
}


static File javaCompile_overInternalBot(String src) {
  return javaCompile_overInternalBot(src, "");
}

// returns path to jar
static synchronized File javaCompile_overInternalBot(String src, String dehlibs) {
  return CompilerBot.compile(src, dehlibs);
}



static Class hotwireCore(List<File> files) { try {
  // make class loader
  JavaXClassLoader classLoader = hotwire_makeClassLoader(files);

  // load & return main class
  Class<?> theClass = classLoader.loadClass("main");
  
  setOpt(theClass, "__javax", getJavaX());
  if (getOpt(theClass, "programID") == null)
    setOpt(theClass, "programID", "#3999999");
  
  if (!_inCore())
    hotwire_copyOver(theClass);
  
  return theClass;
} catch (Exception __e) { throw rethrow(__e); } }


static List<File> loadLibraries(List<String> snippetIDs) {
  return map(__48 -> loadLibrary(__48), snippetIDs);
}


static StringBuilder stringBuilder(String s) {
  return new StringBuilder(unnull(s));
}


static String stringPar(Object[] params, String name) {
  return stringOptPar(params, name);
}

static String stringPar(String name, Object[] params) {
  return stringOptPar(params, name);
}

static String stringPar(String name, Map params) {
  return (String) optPar(name, params);
}

static String stringPar(String name, Object[] params, String defaultValue) {
  return optPar(name, params, defaultValue);
}


// mainJava is a complete program, but without the !752/!759 at the top
// returns link to main class
static Class veryQuickJava(CharSequence mainJava) {
  return veryQuickJava3(str(mainJava)); // Latest version with internal compiler bot.
}


static void saveTranspiledStandardFunctions(TreeSet<String> functionSet, String transpiledSrc) {
  try {
    saveTextFile(transpiledStandardFunctions_file(functionSet), transpiledSrc);
  } catch (Throwable __e) { printStackTrace(__e); }
}


static long done2_always(long startTime, String desc) {
  long time = sysNow()-startTime;
  
  // BREAKING CHANGE: Now stores result for lastTiming()
  saveTiming_noPrint(time);
  
  print(desc + " [" + time + " ms]");
  return time;
}

static long done2_always(String desc, long startTime) {
  return done2_always(startTime, desc);
}

static long done2_always(long startTime) {
  return done2_always(startTime, "");
}


static Set<AutoCloseable> _registerAutoCloseable_set = synchroHashSet();

static void _registerAutoCloseable(AutoCloseable c) {
  addIfNotNull(_registerAutoCloseable_set, c);
}

static void cleanMeUp__registerAutoCloseable() {
  closeAutoCloseables(getAndClearList(_registerAutoCloseable_set));
}


static <A> VF1<A> ivf1ToVF1(IVF1<A> f) {
  return f == null ? null : new VF1<A>() { public void get(A a) { try {  f.get(a) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "f.get(a)"; }};
}


static <A> AutoCloseable tempAdd(Collection<A> l, A a) {
  if (l == null || l.contains(a)) return null;
  l.add(a);
  return new AutoCloseable() { public String toString() { return "l.remove(a);"; } public void close() throws Exception { l.remove(a); }};
}


static <A> A third(List<A> l) {
  return _get(l, 2);
}

static <A> A third(Iterable<A> l) {
  if (l == null) return null;
  Iterator<A> it = iterator(l);
  for (int _repeat_0 = 0; _repeat_0 < 2; _repeat_0++)  {
    if (!it.hasNext()) return null;
    it.next();
  }
  return it.hasNext() ? it.next() : null;
}


static <A> A third(Producer<A> p) {
  if (p == null) return null;
  for (int _repeat_1 = 0; _repeat_1 < 2; _repeat_1++)  {
    if (p.next() == null) return null;
  }
  return p.next();
}


static <A> A third(A[] bla) {
  return bla == null || bla.length <= 2 ? null : bla[2];
}


static <A, B, C> C third(T3<A, B, C> t) {
  return t == null ? null : t.c;
}



static <A> A last(List<A> l) {
  return empty(l) ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static byte last(byte[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static double last(double[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}

static <A> A last(A[] a) {
  return l(a) != 0 ? a[l(a)-1] : null;
}

static <A> A last(Iterator<A> it) {
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}

static <A> A last(Collection<A> l) {
  if (l == null) return null;
  if (l instanceof List) return (A) last((List) l);
  if (l instanceof SortedSet) return (A) last((SortedSet) l);
  Iterator<A> it = iterator(l);
  A a = null;
  while  (it.hasNext()) { ping(); a = it.next(); }
  return a;
}

static <A> A last(SortedSet<A> l) {
  return l == null ? null : l.last();
}


static <A> A last(ReverseChain<A> l) {
  return l == null ? null : l.element;
}









static <A> A last(CompactLinkedHashSet<A> set) {
  return set == null ? null : set.last();
}



static <A> VF1<A> runnableToVF1(final Runnable r) {
  return r == null ? null : new VF1<A>() { public void get(A a) { try {  r.run() ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "r.run()"; }};
}


static Object callOptMC(String method, Object... args) {
  return callOpt(mc(), method, args);
}


static <A> A[] makeArray(Class<A> type, int n) {
  return (A[]) Array.newInstance(type, n);
}


static int indexOfNonDigit(String s) {
  int n = l(s);
  for (int i = 0; i < n; i++)
    if (!isDigit(s.charAt(i)))
      return i;
  return -1;
}


static volatile Object isAllowed_function; // func(S, O[]) -> bool
static volatile boolean isAllowed_all = true;

static boolean isAllowed(String askingMethod, Object... args) {
  // check on VM level
  Object f = vm_generalMap_get("isAllowed_function");
  if (f != null && !isTrue(callF(f, askingMethod, args))) return false;
  
  // check locally
  return isAllowed_all || isTrue(callF(isAllowed_function, askingMethod, args));
}


static volatile boolean sleep_noSleep = false;

static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  if (sleep_noSleep) throw fail("nosleep");
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }


static long round(double d) {
  return Math.round(d);
}

static String round(String s) {
  return roundBracket(s);
}






static String hmsWithColons() {
  return hmsWithColons(now());
}

static String hmsWithColons(long time) {
  return new SimpleDateFormat("HH:mm:ss").format(time);
}



static String getComputerID_quick() {
  return computerID();
}


static Map<Object, Object> castMapToMapO(Map map) {
  return map;
}


static <A, B> void mapPut(Map<A, B> map, A key, B value) {
  if (map != null && key != null && value != null) map.put(key, value);
}


static <A, B> void mapPut(Map<A, B> map, Pair<A, B> p) {
  if (map != null && p != null) map.put(p.a, p.b);
}



static <A> Set<A> synchronizedSet() {
  return synchroHashSet();
}

static <A> Set<A> synchronizedSet(Set<A> set) {
  
    return new SynchronizedSet(set);
  
  
}


static <A> Set<A> identityHashSet() {
  return Collections.newSetFromMap(new IdentityHashMap());
}


static TreeSet<String> litciset(String... items) {
  TreeSet<String> set = caseInsensitiveSet();
  for (String a : items) set.add(a);
  return set;
}


static TreeSet<Symbol> litciset(Symbol... items) {
  TreeSet<Symbol> set = treeSet(); // HashSet would also do, but we might have the return type fixed somewhere, and they might want a NavigableMap.
  for (Symbol a : items) set.add(a);
  return set;
}



static String afterLastSpace(String s) {
  return s == null ? null : substring(s, s.lastIndexOf(' ')+1);
}


static String dropSuffixIgnoreCase(String suffix, String s) {
  return ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}


static boolean ewicOneOf(String s, String... l) {
  if (s != null) for (String x : l) if (ewic(s, x)) return true; return false;
}


static boolean isTrueOpt(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  return false;
}

static boolean isTrueOpt(String field, Object o) {
  return isTrueOpt(getOpt(field, o));
}


static boolean eqicOneOf(String s, String... l) {
  for (String x : l) if (eqic(s, x)) return true; return false;
}


static List<String> isYes_yesses = litlist("y", "yes", "yeah", "y", "yup", "yo", "corect", "sure", "ok", "afirmative"); // << collapsed words, so "corect" means "correct"

static boolean isYes(String s) {
  return isYes_yesses.contains(collapseWord(toLowerCase(firstWord2(s))));
}


static IMeta initIMeta(Object o) {
  if (o == null) return null;
  if (o instanceof IMeta) return ((IMeta) o);
  if (o instanceof JComponent) return initMetaOfJComponent((JComponent) o);
  
  // This is not really used. Try to use BufferedImageWithMeta instead
  if (o instanceof BufferedImage) return optCast(IMeta.class, ((BufferedImage) o).getProperty("meta"));
  return null;
}


static Class run(String progID, String... args) {
  Class main = hotwire(progID);
  
  callMain(main, args);
  return main;
}


static void restart() {
  Object j = getJavaX();
  call(j, "cleanRestart", get(j, "fullArgs"));
}


static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(addThreadInfoToRunnable(r));
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() {  public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}


static List<String> javaTok_noMLS(String s) {
  ArrayList<String> tok = new ArrayList();
  int l = s == null ? 0 : s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(javaTok_substringN(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        int c2 = s.charAt(j);
        if (c2 == opener || c2 == '\n' && opener == '\'') { // allow multi-line strings, but not for '
          ++j;
          break;
        } else if (c2 == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else
      ++j;
      
    tok.add(javaTok_substringC(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}


static TimeZone localTimeZone() {
  return getTimeZone(standardTimeZone());
  // TimeZone.getDefault()?
}


static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  n = Math.max(n, 0);
  List<A> l = new ArrayList(n);
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}


static <A> AutoCloseable tempSetThreadLocalIfNecessary(ThreadLocal<A> tl, A a) {
  if (tl == null) return null;
  A prev = tl.get();
  if (eq(prev, a)) return null;
  tl.set(a);
  return new AutoCloseable() { public String toString() { return "tl.set(prev);"; } public void close() throws Exception { tl.set(prev); }};
}


static <A> AutoCloseable tempSetThreadLocalIfNecessary(BetterThreadLocal<A> tl, A a) {
  if (tl == null) return null;
  A prev = tl.get();
  if (eq(prev, a)) return null;
  tl.set(a);
  return new AutoCloseable() { public String toString() { return "tl.set(prev);"; } public void close() throws Exception { tl.set(prev); }};
}



static <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
  return cloneList(subList(l, startIndex, endIndex));
}

static <A> List<A> newSubList(List<A> l, int startIndex) {
  return cloneList(subList(l, startIndex));
}


static ThreadLocal realMC_tl_tl = new ThreadLocal();

static ThreadLocal realMC_tl() {
  return realMC_tl_tl;
}


static Pair pairMap(Object f, Pair p) {
  return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
}

static <A> Pair<A, A> pairMap(IF1<A, A> f, Pair<A, A> p) {
  return p == null ? null : pair(callF(f, p.a), callF(f, p.b));
}

static Pair pairMap(Pair p, Object f) {
  return pairMap(f, p);
}



// This is made for NL parsing.
// It's javaTok extended with "..." token, "$n" and "#n" and
// special quotes (which are converted to normal ones).

static List<String> javaTokPlusPeriod(String s) {
  List<String> tok = new ArrayList<String>();
  if (s == null) return tok;
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    cc = s.substring(i, Math.min(i+2, l));

    // scan for non-whitespace
    if (c == (char) 0x201C || c == (char) 0x201D) c = '"'; // normalize quotes
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        char _c = s.charAt(j);
        if (_c == (char) 0x201C || _c == (char) 0x201D) _c = '"'; // normalize quotes
        if (_c == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
      if (j-1 >= i+1) {
        tok.add(opener + s.substring(i+1, j-1) + opener);
        i = j;
        continue;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for things like "this one's"
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else if (cc.equals("[[")) {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (cc.equals("[=") && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else if (s.substring(j, Math.min(j+3, l)).equals("..."))
      j += 3;
    else if (c == '$' || c == '#')
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}





static double parseDouble(String s) {
  return empty(s) ? 0.0 : Double.parseDouble(s);
}


static String mcName() {
  return mc().getName();
}


static DialogIO talkToSubBot(final long vport, final DialogIO io) {
  return talkToSubBot(String.valueOf(vport), io);
}

static DialogIO talkToSubBot(final String subBot, final DialogIO io) {
  if (subBot == null) return io;
  return new talkToSubBot_IO(subBot, io);
}

static class talkToSubBot_IO extends DialogIO {
  String subBot;
  DialogIO io;
  
  talkToSubBot_IO(String subBot, DialogIO io) {
  this.io = io;
  this.subBot = subBot;}
  
  // delegate all but sendLine
  boolean isStillConnected() { return io.isStillConnected(); }
  String readLineImpl() { return io.readLineImpl(); }
  boolean isLocalConnection() { return io.isLocalConnection(); }
  Socket getSocket() { return io.getSocket(); }
  public void close() { try { io.close(); } catch (Exception __e) { throw rethrow(__e); } }

  void sendLine(String line) {
    io.sendLine(format3("please forward to bot *: *", subBot, line));
  }
}


static DialogIO talkTo(int port) {
  return talkTo("localhost", port);
}

static int talkTo_defaultTimeout = 10000; // This is the CONNECT timeout
static int talkTo_timeoutForReads = 0; // Timeout waiting for answers (0 = no timeout)

static ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

static DialogIO talkTo(String ip, int port) { try {
  String full = ip + ":" + port;
  Map<String, DialogIO> map = talkTo_byThread.get();
  if (map != null && map.containsKey(full)) return map.get(full);
  
  if (isLocalhost(ip) && port == vmPort()) return talkToThisVM();

  return new talkTo_IO(ip, port);
} catch (Exception __e) { throw rethrow(__e); } }

static class talkTo_IO extends DialogIO { 
  String ip;
  int port;
  Socket s;
  Writer w;
  BufferedReader in;
  
  talkTo_IO(String ip, int port) {
  this.port = port;
  this.ip = ip; try {
    s = new Socket();
    try {
      if (talkTo_timeoutForReads != 0)
        s.setSoTimeout(talkTo_timeoutForReads);
      s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
    } catch (Throwable e) {
      throw fail("Tried talking to " + ip + ":" + port, e);
    }
  
    w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
    in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    Lock __0 = lock; lock(__0); try {
    w.write(line + "\n");
    w.flush();
  } finally { unlock(__0); } } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {
    try {
      if (!noClose) s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
}


static List<ProgramScan.Program> quickBotScan() {
  return ProgramScan.quickBotScan();
}

static List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
  return ProgramScan.quickBotScan(preferredPorts);
}

static List<ProgramScan.Program> quickBotScan(String searchPattern) {
  List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
  for (ProgramScan.Program p : ProgramScan.quickBotScan())
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
  return l;
}



static String firstPartOfHelloString(String s) {
  int i = s.lastIndexOf('/');
  return i < 0 ? s : rtrim(s.substring(0, i));
}




// TODO: cyclic structures involving certain lists & sets



static Object unstructure(String text) {
  return unstructure(text, false);
}

static Object unstructure(String text, boolean allDynamic) {
  return unstructure(text, allDynamic, null);
}

static Object unstructure(String text, IF1<String, Class> classFinder) {
  return unstructure(text, false, classFinder);
}

static int structure_internStringsLongerThan = 50;
static int unstructure_unquoteBufSize = 100;

static int unstructure_tokrefs; // stats

abstract static class unstructure_Receiver {
  abstract void set(Object o);
}

// classFinder: func(name) -> class (optional)
static Object unstructure(String text, boolean allDynamic,
  Object classFinder) {
  if (text == null) return null;
  return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
}

static Object unstructure_reader(BufferedReader reader) {
  return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
}

interface unstructure_Handler {
  void parse(int refID, int tokIndex, unstructure_Receiver out);
}
  
static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object _classFinder) {
  final boolean debug = unstructure_debug;
  
  final class X {
    int i = -1;
    final Object classFinder = _classFinder != null ? _classFinder : _defaultClassFinder();
    String mcDollar = actualMCDollar();

    // use Eclipse primitive collection if possible (smaller & hopefully faster?)
    
    
    HashMap<Integer, Object> refs = new HashMap();
    HashMap<Integer, Object> tokrefs = new HashMap();
    
    
    HashSet<String> concepts = new HashSet();
    List<Runnable> stack = new ArrayList();
    Map<String, String> baseClassMap = new HashMap();
    HashMap<Class, Constructor> innerClassConstructors = new HashMap();
    String curT;
    char[] unquoteBuf = new char[unstructure_unquoteBufSize];
    
    // value is a class or a Handler
    final HashMap<String, Object> handlers = new HashMap();
    
    X() {
      try {
        Class mc =  (Class) (callF(_classFinder, "<main>"));
        if (mc != null) mcDollar = mc.getName() + "$";
      } catch (Throwable __e) { printStackTrace(__e); }
      
      makeHandlers();
    }
    
    
    
    void makeHandlers() {
      unstructure_Handler h;
      
      handlers.put("bigint", (unstructure_Handler) (refID, tokIndex, out)
        -> out.set(parseBigInt()));
        
      handlers.put("d", (unstructure_Handler) (refID, tokIndex, out)
        -> out.set(parseDouble()));
        
      handlers.put("fl", (unstructure_Handler) (refID, tokIndex, out)
        -> out.set(parseFloat()));
        
      handlers.put("sh", (unstructure_Handler) (refID, tokIndex, out) -> {
        consume();
        String t = tpp();
        if (t.equals("-")) {
          t = tpp();
          out.set((short) (-parseInt(t))); return;
        }
        out.set((short) parseInt(t));
      });
      
      handlers.put("enum", (unstructure_Handler) (refID, tokIndex, out) -> {
        consume();
        String t = tpp();
        assertTrue(isJavaIdentifier(t));
        String fullClassName = mcDollar + t;
        Class _c = findAClass(fullClassName);
        if (_c == null) throw fail("Enum class not found: " + fullClassName);
        int ordinal = parseInt(tpp());
        out.set(_c.getEnumConstants()[ordinal]);
      });

      handlers.put("false", h = (unstructure_Handler) (refID, tokIndex, out) -> {
        consume(); out.set(false);
      });
      handlers.put("f", h);
      
      handlers.put("true", h = (unstructure_Handler) (refID, tokIndex, out) -> {
        consume(); out.set(true);
      });
      handlers.put("t", h);
      
      handlers.put("{", (unstructure_Handler) (refID, tokIndex, out) -> parseMap(out));
      
      handlers.put("[", (unstructure_Handler) (refID, tokIndex, out) -> {
        ArrayList l = new ArrayList();
        if (refID >= 0) refs.put(refID, l);
        this.parseList(l, out);
      });
      
      handlers.put("bitset", (unstructure_Handler) (refID, tokIndex, out) -> parseBitSet(out));
      
      handlers.put("array", h = (unstructure_Handler) (refID, tokIndex, out) -> parseArray(out));
      handlers.put("intarray", h);
      handlers.put("dblarray", h);
      
    } // end of makeHandlers - add more handlers here

    Class findAClass(String fullClassName) { try {
      return classFinder != null ? (Class) callF(classFinder, fullClassName) : findClass_fullName(fullClassName);
    } catch (Throwable __e) { return null; } }
    
    String unquote(String s) {
      return unquoteUsingCharArray(s, unquoteBuf); 
    }

    // look at current token
    String t() {
      return curT;
    }
    
    // get current token, move to next
    String tpp() {
      String t = curT;
      consume();
      return t;
    }
    
    void parse(final unstructure_Receiver out) {
      String t = t();
      
      int refID;
      if (structure_isMarker(t, 0, l(t))) {
        refID = parseInt(t.substring(1));
        consume();
      } else refID = -1;
      
      // if (debug) print("parse: " + quote(t));
      
      final int tokIndex = i;  
      parse_inner(refID, tokIndex, new unstructure_Receiver() {
        void set(Object o) {
          if (refID >= 0)
            refs.put(refID, o);
          if (o != null)
            tokrefs.put(tokIndex, o);
          out.set(o);
        }
      });
    }
    
    void parse_inner(int refID, int tokIndex, unstructure_Receiver out) {
      String t = t();
      
      // if (debug) print("parse_inner: " + quote(t));
      
      Object handler = handlers.get(t);
      if (handler instanceof unstructure_Handler)
        { ((unstructure_Handler) handler).parse(refID, tokIndex, out); return; }
        
      Class c =  (Class) handler;
      if (c == null) {
        if (t.startsWith("\"")) {
          String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
          out.set(s); return;
        }
        
        if (t.startsWith("'")) {
          out.set(unquoteCharacter(tpp())); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          
          out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l)); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          
          out.set(isInt ? (Object) Integer.valueOf((int) l) : (Object) Long.valueOf(l)); return;
        }
        
        if (t.equals("File")) {
          consume();
          File f = new File(unquote(tpp()));
          out.set(f); return;
        }
        
        if (t.startsWith("r") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = refs.get(ref);
          if (o == null)
            warn("unsatisfied back reference " + ref);
          out.set(o); return;
        }
      
        if (t.startsWith("t") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = tokrefs.get(ref);
          if (o == null)
            warn("unsatisfied token reference " + ref + " at " + tokIndex);
          out.set(o); return;
        }
        
        if (t.equals("hashset")) { parseHashSet(out); return; }
        if (t.equals("lhs")) { parseLinkedHashSet(out); return; }
        if (t.equals("treeset")) { parseTreeSet(out); return; }
        if (t.equals("ciset")) { parseCISet(out); return; }
        
        if (eqOneOf(t, "hashmap", "hm")) {
          consume();
          parseMap(new HashMap(), out);
          return;
        }
        if (t.equals("lhm")) {
          consume();
          parseMap(new LinkedHashMap(), out);
          return;
        }
        if (t.equals("tm")) {
          consume();
          parseMap(new TreeMap(), out);
          return;
        }
        if (t.equals("cimap")) {
          consume();
          parseMap(ciMap(), out);
          return;
        }
        
        if (t.equals("ll")) {
          consume();
          LinkedList l = new LinkedList();
          if (refID >= 0) refs.put(refID, l);
          { parseList(l, out); return; }
        }

        if (t.equals("syncLL")) { // legacy
          consume();
          { parseList(synchroLinkedList(), out); return; }
        }

        if (t.equals("sync")) {
          consume();
          { parse(new unstructure_Receiver() {
            void set(Object value) {
              if (value instanceof Map) {
                 // Java 7
                if (value instanceof NavigableMap)
                  { out.set(synchroNavigableMap((NavigableMap) value)); return; }
                
                if (value instanceof SortedMap)
                  { out.set(synchroSortedMap((SortedMap) value)); return; }
                { out.set(synchroMap((Map) value)); return; }
              } else
                { out.set(synchroList((List) value)); return; }
            }
          }); return; }
        }
        
        if (t.equals("ba")) {
          consume();
          String hex = unquote(tpp());
          out.set(hexToBytes(hex)); return;
        }
        if (t.equals("boolarray")) {
          consume();
          int n = parseInt(tpp());
          String hex = unquote(tpp());
          out.set(boolArrayFromBytes(hexToBytes(hex), n)); return;
        }
        if (t.equals("class")) {
          out.set(parseClass()); return;
        }
        if (t.equals("l")) {
          parseLisp(out); return;
        }
        if (t.equals("null")) {
          consume(); out.set(null); return;
        }
        
        if (eq(t, "c")) {
          consume();
          t = t();
          assertTrue(isJavaIdentifier(t));
          concepts.add(t);
        }
        
        // custom deserialization (new static method method)
        if (eq(t, "cu")) {
          consume();
          t = tpp();
          assertTrue(isJavaIdentifier(t));
          String fullClassName = mcDollar + t;
          Class _c = findAClass(fullClassName);
          if (_c == null) throw fail("Class not found: " + fullClassName);
          parse(new unstructure_Receiver() {
            void set(Object value) {
              
              out.set(call(_c, "_deserialize", value));
            }
          });
          return;
        }
      }
      
      if (eq(t, "j")) {
        consume();
        out.set(parseJava()); return;
      }
      
      if (eq(t, "bc")) {
        consume();
        String c1 = tpp();
        String c2 = tpp();
        baseClassMap.put(c1, c2);
        { parse_inner(refID, i, out); return; }
      }
      
      // add more tokens here

      // Now we want to find our target class c
      // Have we failed to look up the class before?
      //bool seenBefore = handlers.containsKey(cname);

      // If we have seen the class before, we skip all of this
      // and simply leave c as null
      // TODO - how do we fill className?
      //if (!seenBefore) {
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i+1) + ": " + quote(t));
          
        // any other class name (or package name)
        consume();
        String className, fullClassName;
        
        // Is it a package name?
        if (eq(t(), ".")) {
          consume();
          className = fullClassName = t + "." + assertIdentifier(tpp());
        } else {
          className = t;
          fullClassName = mcDollar + t;
        }
        
        if (c == null && !allDynamic) {
          // First, find class
          c = findAClass(fullClassName);
          handlers.put(className, c);
        }
        
        // check for existing base class
        if (c == null && !allDynamic) {
          Set<String> seen = new HashSet();
          String parent = className;
          while (true) {
            String baseName = baseClassMap.get(parent);
            if (baseName == null)
              break;
            if (!seen.add(baseName))
              throw fail("Cyclic superclass info: " + baseName);
            c = findAClass(mcDollar + baseName);
            if (c == null)
              print("Base class " + baseName + " of " + parent +  " doesn't exist either");
            else if (isAbstract(c))
              print("Can't instantiate abstract base class: " + c);
            else {
              printVars_str("Reverting to base class", "className", className, "baseName", baseName, "c", c);
              handlers.put(className, c);
              break;
            }
            parent = baseName;
          }
        }
      //}
          
      // Check if it has an outer reference
      boolean hasBracket = eq(t(), "(");
      if (hasBracket) consume();
      boolean hasOuter = hasBracket && startsWith(t(), "this$");
      
      DynamicObject dO = null;
      Object o = null;
      final String thingName = t;
      if (c != null) {
        if (hasOuter) try {
          Constructor ctor = innerClassConstructors.get(c);
          if (ctor == null)
            innerClassConstructors.put(c, ctor = nuStubInnerObject_findConstructor(c, classFinder));
          o = ctor.newInstance(new Object[] {null});
        } catch (Exception e) {
          print("Error deserializing " + c + ": " + e);
          o = nuEmptyObject(c);
        } else
          o = nuEmptyObject(c);
        if (o instanceof DynamicObject) dO = (DynamicObject) o;
      } else {
        if (concepts.contains(t) && (c = findAClass(mcDollar + "Concept")) != null)
          o = dO = (DynamicObject) nuEmptyObject(c);
        else
          dO = new DynamicObject();
        dO.className = className;
        
      }
      
      // Save in references list early because contents of object
      // might link back to main object
      
      if (refID >= 0)
        refs.put(refID, o != null ? o : dO);
      tokrefs.put(tokIndex, o != null ? o : dO);
      
      // NOW parse the fields!
      
      HashMap<String, Object> fields = new HashMap(); // no longer preserving order (why did we do this?)
      Object _o = o;
      DynamicObject _dO = dO;
      if (hasBracket) {
        stack.add(new Runnable() {  public void run() { try { 
          
          if (eq(t(), ",")) consume();
          if (eq(t(), ")")) {
            consume(")");
            objRead(_o, _dO, fields, hasOuter);
            out.set(_o != null ? _o : _dO);
          } else {
            final String key = unquote(tpp());
            String t = tpp();
            if (!eq(t, "="))
              throw fail("= expected, got " + t + " after " + quote(key) + " in object " + thingName /*+ " " + sfu(fields)*/);
            stack.add(this);
            parse(new unstructure_Receiver() {
              void set(Object value) {
                fields.put(key, value);
                /*ifdef unstructure_debug
                  print("Got field value " + value + ", next token: " + t());
                endifdef*/
                //if (eq(t(), ",")) consume();
              }
            });
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "ifdef unstructure_debug\r\n            print(\"in object values, token: \" + t())..."; }});
      } else {
        objRead(o, dO, fields, hasOuter);
        out.set(o != null ? o : dO);
      }
    }
    
    void objRead(Object o, DynamicObject dO, Map<String, Object> fields, boolean hasOuter) {
      
      
      // translate between diferent compilers (this$0 vs this$1)
      Object outer = fields.get("this$0");
      if (outer != null) fields.put("this$1", outer);
      else {
        outer = fields.get("this$1");
        if (outer != null) fields.put("this$0", outer);
      }
      
      if (o != null) {
        if (dO != null) {
          
          setOptAllDyn_pcall(dO, fields);
        } else {
          setOptAll_pcall(o, fields);
          
        }
        if (hasOuter)
          fixOuterRefs(o);
      } else for (Map.Entry<String, Object> e : fields.entrySet())
        setDynObjectValue(dO, intern(e.getKey()), e.getValue());

      if (o != null)
        pcallOpt_noArgs(o, "_doneLoading");
    }
    
    void parseSet(final Set set, final unstructure_Receiver out) {
      this.parseList(new ArrayList(), new unstructure_Receiver() {
        void set(Object o) {
          set.addAll((List) o);
          out.set(set);
        }
      });
    }
    
    void parseLisp(final unstructure_Receiver out) {
      
      
      throw fail("class Lisp not included");
    }
    
    void parseBitSet(final unstructure_Receiver out) {
      consume("bitset");
      consume("{");
      final BitSet bs = new BitSet();
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(bs);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              bs.set((Integer) o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n       ..."; }});
    }
    
    void parseList(final List list, final unstructure_Receiver out) {
      tokrefs.put(i, list);
      consume("[");
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "]")) {
          consume();
          
          out.set(list);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              //if (debug) print("List element type: " + getClassName(o));
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"]\")) {\r\n          consume();\r\n          ifdef unstructure_debug\r..."; }});
    }
    
    void parseArray(unstructure_Receiver out) {
      String _type = tpp();
      int dims;

      if (eq(t(), "S")) { // string array
        _type = "S";
        consume();
      }
      
      if (eq(t(), "/")) { // multi-dimensional array
        consume();
        dims = parseInt(tpp());
      } else
        dims = 1;
      
      consume("{");
      List list = new ArrayList();
      String type = _type;
      
      stack.add(new Runnable() {  public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          if (dims > 1) {
            Class atype;
            if (type.equals("intarray")) atype = int.class;
            else if (type.equals("S")) atype = String.class;
            else throw todo("multi-dimensional arrays of other types");
            
            out.set(list.toArray((Object[]) newMultiDimensionalOuterArray(atype, dims, l(list))));
          } else
            out.set(
              type.equals("intarray") ? toIntArray(list)
              : type.equals("dblarray") ? toDoubleArray(list)
              : type.equals("S") ? toStringArray(list)
              : list.toArray());
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          if (dims > 1) {\r\n    ..."; }});
    }
    
    Object parseClass() {
      consume("class");
      consume("(");
      String name = unquote(tpp());
      consume(")");
      Class c = allDynamic ? null : findAClass(name);
      if (c != null) return c;
      DynamicObject dO = new DynamicObject();
      dO.className = "java.lang.Class";
      name = dropPrefix(mcDollar, name);
      dO.fieldValues.put("name", name);
      return dO;
    }
    
    Object parseBigInt() {
      consume("bigint");
      consume("(");
      String val = tpp();
      if (eq(val, "-"))
        val = "-" + tpp();
      consume(")");
      return new BigInteger(val);
    }
    
    Object parseDouble() {
      consume("d");
      consume("(");
      String val = unquote(tpp());
      consume(")");
      return Double.parseDouble(val);
    }
    
    Object parseFloat() {
      consume("fl");
      String val;
      if (eq(t(), "(")) {
        consume("(");
        val = unquote(tpp());
        consume(")");
      } else {
        val = unquote(tpp());
      }
      return Float.parseFloat(val);
    }
    
    void parseHashSet(unstructure_Receiver out) {
      consume("hashset");
      parseSet(new HashSet(), out);
    }
    
    void parseLinkedHashSet(unstructure_Receiver out) {
      consume("lhs");
      parseSet(new LinkedHashSet(), out);
    }
    
    void parseTreeSet(unstructure_Receiver out) {
      consume("treeset");
      parseSet(new TreeSet(), out);
    }
    
    void parseCISet(unstructure_Receiver out) {
      consume("ciset");
      parseSet(ciSet(), out);
    }
    
    void parseMap(unstructure_Receiver out) {
      parseMap(new TreeMap(), out);
    }
    
    Object parseJava() {
      String j = unquote(tpp());
      Matches m = new Matches();
      if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
        return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
      else {
        warn("Unknown Java object: " + j);
        return null;
      }
    }
    
    void parseMap(final Map map, final unstructure_Receiver out) {
      consume("{");
      stack.add(new Runnable() {
        boolean v = false;
        Object key;
        
        public void run() { 
          if (v) {
            v = false;
            stack.add(this);
            if (!eq(tpp(), "="))
              throw fail("= expected, got " + t() + " in map of size " + l(map));

            parse(new unstructure_Receiver() {
              void set(Object value) {
                map.put(key, value);
                
                if (eq(t(), ",")) consume();
              }
            });
          } else {
            if (eq(t(), "}")) {
              consume("}");
              out.set(map);
            } else {
              v = true;
              stack.add(this);
              parse(new unstructure_Receiver() {
                void set(Object o) {
                  key = o;
                }
              });
            }
          } // if v else
        } // run()
      });
    }
    
    /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
    
    void consume() { curT = tok.next(); ++i; }
    
    void consume(String s) {
      if (!eq(t(), s)) {
        /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
        throw fail(quote(s) + " expected, got " + quote(t()));
      }
      consume();
    }
    
    // outer wrapper function getting first token and unwinding the stack
    void parse_initial(unstructure_Receiver out) {
      consume(); // get first token
      parse(out);
      while (nempty(stack))
        popLast(stack).run();
    }
  }
  
  ThreadLocal<Boolean> tlLoading = dynamicObjectIsLoading_threadLocal();
  Boolean b = tlLoading.get();
  tlLoading.set(true);
  try {
    final Var v = new Var();
    X x = new X();
    x.parse_initial(new unstructure_Receiver() {
      void set(Object o) { v.set(o); }
    });
    unstructure_tokrefs = x.tokrefs.size();
    return v.get();
  } finally {
    tlLoading.set(b);
  }
}

static boolean unstructure_debug = false;


static String sendToLocalBotQuietly(String bot, String text, Object... args) {
  text = format3(text, args);
  
   DialogIO channel = newFindBot2(bot); try {
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}

static String sendToLocalBotQuietly(int port, String text, Object... args) {
  text = format3(text, args);
   DialogIO channel = talkTo(port); try {
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}




static Map<String, List<String>> parse3_cachedInput_cache = synchronizedMRUCache(1000);

static List<String> parse3_cachedInput(String s) {
  List<String> tok = parse3_cachedInput_cache.get(s);
  if (tok == null) parse3_cachedInput_cache.put(s, tok = parse3(s));
  return tok;
}






static Map<String, List<String>> parse3_cachedPattern_cache = synchronizedMRUCache(1000);

static synchronized List<String> parse3_cachedPattern(String s) {
  List<String> tok = parse3_cachedPattern_cache.get(s);
  if (tok == null) parse3_cachedPattern_cache.put(s, tok = parse3(s));
  return tok;
}




// match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)

static String[] match2(List<String> pat, List<String> tok) {
  // standard case (no ...)
  int i = pat.indexOf("...");
  if (i < 0) return match2_match(pat, tok);
  
  pat = new ArrayList<String>(pat); // We're modifying it, so copy first
  pat.set(i, "*");
  while (pat.size() < tok.size()) {
    pat.add(i, "*");
    pat.add(i+1, ""); // doesn't matter
  }
  
  return match2_match(pat, tok);
}

static String[] match2_match(List<String> pat, List<String> tok) {
  List<String> result = new ArrayList<String>();
  if (pat.size() != tok.size()) {
    
    return null;
  }
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(i);
    
    if (eq(p, "*"))
      result.add(t);
    else if (!equalsIgnoreCase(unquote(p), unquote(t))) // bold change - match quoted and unquoted now. TODO: should remove
      return null;
  }
  return result.toArray(new String[result.size()]);
}



  static String format(String pat, Object... args) {
    return format3(pat, args);
  }



static void assertNotOnAWTThread() {
  assertFalse("Can't do this in AWT thread", isAWTThread());
}
  


static boolean match(String pat, String s) {
  return match3(pat, s);
}

static boolean match(String pat, String s, Matches matches) {
  return match3(pat, s, matches);
}

static boolean match(String pat, List<String> toks, Matches matches) {
  return match3(pat, toks, matches);
}


static String getString(Map map, Object key) {
  return map == null ? null : (String) map.get(key);
}

static String getString(List l, int idx) {
  return (String) get(l, idx);
}

static String getString(Object o, Object key) {
  if (o instanceof Map) return getString((Map) o, key);
  if (key instanceof String)
    return (String) getOpt(o, (String) key);
  throw fail("Not a string key: " + getClassName(key));
}

static String getString(String key, Object o) {
  return getString(o, (Object) key);
}


static Object[] asObjectArray(Collection l) {
  return toObjectArray(l);
}


static String ok2(String s) {
  return "ok " + s;
}


// An "Android" is a program that accepts text questions (on console or TCP) and outputs one response text per question

//please include function myJavaSource. // for getting my known commands

static boolean makeAndroid3_disable = false; // disable all android making

static class Android3 implements AutoCloseable {
  String greeting;
  boolean publicOverride = false; // optionally set this in client
  int startPort = 5000; // optionally set this in client
  Responder responder;
  boolean console = true;
  boolean quiet = false; // no messages on console
  boolean daemon = false;
  boolean incomingSilent = false;
  int incomingPrintLimit = 200;
  boolean useMultiPort = true;
  boolean recordHistory = false;
  boolean verbose = false;
  int answerPrintLimit = 500;
  boolean newLineAboveAnswer, newLineBelowAnswer;
  
  // set by system
  int port;
  long vport;
  DialogHandler handler;
  ServerSocket server;
  
  Android3(String greeting) {
  this.greeting = greeting;}
  Android3() {}
  
  public void close() { dispose(); }
  
  synchronized void dispose() {
    if (server != null) {
      try {
        server.close();
      } catch (IOException e) {
        print("[internal] " + e);
      }
      server = null;
    }
    if (vport != 0) { try {
      print("Disposing " + this);
      removeFromMultiPort(vport);
      vport = 0;
    } catch (Throwable __e) { printStackTrace(__e); }}
  }
  
  public String toString() { return "Bot: " + greeting + " [vport " + vport + "]"; }
}

static abstract class Responder {
  abstract String answer(String s, List<String> history);
}

static Android3 makeAndroid3(final String greeting) {
  return makeAndroid3(new Android3(greeting));
}

static Android3 makeAndroid3(final String greeting, Responder responder) {
  Android3 android = new Android3(greeting);
  android.responder = responder;
  return makeAndroid3(android);
}

static Android3 makeAndroid3(final Android3 a) {
  if (makeAndroid3_disable) return a;
  
  if (a.responder == null)
    a.responder = new Responder() {
      String answer(String s, List<String> history) {
        return callStaticAnswerMethod(s, history);
      }
    };
    
  if (!a.quiet)
    print("[bot] " + a.greeting);
  
  if (a.console && (readLine_noReadLine || makeAndroid3_consoleInUse()))
    a.console = false;
  
  record(a);
  
  if (a.useMultiPort)
    a.vport = addToMultiPort(a.greeting,
      makeAndroid3_verboseResponder(a));
      
  if (a.console)
    makeAndroid3_handleConsole(a);

  if (a.useMultiPort) return a;

  a.handler = makeAndroid3_makeDialogHandler(a);
  if (a.quiet) startDialogServer_quiet.set(true);
  try {
    a.port = a.daemon
      ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler)
      : startDialogServerOnPortAbove(a.startPort, a.handler);
  } finally {
    startDialogServer_quiet.set(null);
  }
  a.server = startDialogServer_serverSocket;

  return a;
}

static void makeAndroid3_handleConsole(final Android3 a) {
  // Console handling stuff
  if (!a.quiet)
    print("You may also type on this console.");
  { startThread(new Runnable() {  public void run() { try {  List<String> history = new ArrayList();
    while (licensed()) {
      String line;
      try {
        line = readLine();
      } catch (Throwable e) {
        print(getInnerMessage(e));
        break;
      }
      if (line == null) break;
      /*if (eq(line, "bye")) {
        print("> bye stranger");
        history = new ArrayList<S>();
      } else*/ {
        history.add(line);
        history.add(makeAndroid3_getAnswer(line, history, a)); // prints answer on console too
      }
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "List<String> history = new ArrayList();\r\n    while (licensed()) {\r\n      Stri..."; }}); }
}

static DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
  return new DialogHandler() {
public void run(final DialogIO io) {
    if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
      io.sendLine("Sorry, not allowed");
      return;
    }
    
    String dialogID = randomID(8);
    
    io.sendLine(a.greeting + " / Your ID: " + dialogID);
    
    List<String> history = new ArrayList();
    
    while (io.isStillConnected()) {
      if (io.waitForLine()) {
        final String line = io.readLineNoBlock();
        String s = dialogID + " at " + now() + ": " + quote(line);
        if (!a.incomingSilent)
          print(shorten(s, a.incomingPrintLimit));
        if (eq(line, "bye")) {
          io.sendLine("bye stranger");
          return;
        }
        Matches m = new Matches();
        if (a.recordHistory)
          history.add(line);
        String answer;
        if (match3("this is a continuation of talk *", s, m)
          || match3("hello bot! this is a continuation of talk *", s, m)) {
          dialogID = unquote(m.m[0]);
          answer = "ok";
        } else try {
          makeAndroid3_io.set(io);
          answer = makeAndroid3_getAnswer(line, history, a);
        } finally {
          makeAndroid3_io.set(null);
        }
        if (a.recordHistory)
          history.add(answer);
        io.sendLine(answer);
        //appendToLog(logFile, s);
      }
    }
  }};
}

static String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
  String answer, originalAnswer;
  try {
    originalAnswer = a.responder.answer(line, history);
    answer = makeAndroid3_fallback(line, history, originalAnswer);
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    originalAnswer = answer = e.toString();
  }
  if (!a.incomingSilent) {
    if (originalAnswer == null) originalAnswer = "?";
    if (a.newLineAboveAnswer) print();
    print(">" + dropFirst(indentx(2, shorten(rtrim(originalAnswer), a.answerPrintLimit))));
    if (a.newLineBelowAnswer) print();
  }
  return answer;
}

static String makeAndroid3_fallback(String s, List<String> history, String answer) {
  // Now we only do the safe thing instead of VM inspection - give out our process ID
  if (answer == null && match3("what is your pid", s))
    return getPID();
    
  if (answer == null && match3("what is your program id", s)) // should be fairly safe, right?
    return getProgramID();
    
  if (match3("get injection id", s))
    return getInjectionID();
    
  if (answer == null) answer = "?";
  if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
    answer = quote(answer);
  return answer;
}

static boolean makeAndroid3_consoleInUse() {
  if (isTrue(vm_generalMap_get("consoleInUse"))) return true;
  for (Object o : record_list)
    if (o instanceof Android3 && ((Android3) o).console)
      return true;
  return false;
}

static Responder makeAndroid3_verboseResponder(final Android3 a) {
  return new Responder() {
    String answer(String s, List<String> history) {
      if (a.verbose)
        print("> " + shorten(s, a.incomingPrintLimit));
      String answer = a.responder.answer(s, history);
      if (a.verbose)
        print("< " + shorten(answer, a.incomingPrintLimit));
      return answer;
    }
  };
}

static ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

static Android3 makeAndroid3() {
  return makeAndroid3(getProgramTitle() + ".");
}


static String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
  String answer = (String) callOpt(bot, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(bot, "answer", s);
  return answer;
}

static Responder makeResponder(final Object bot) {
  if (bot instanceof Responder) return (Responder) bot;
  
  if (bot instanceof String) {
    String f =  (String) bot;
    return new Responder() {
      String answer(String s, List<String> history) {
        String answer = (String) callOptMC((String) bot, s, history);
        if (answer == null)
          answer = (String) callOptMC((String) bot, s);
        return answer;
      }
    };
  }
  
  return new Responder() {
    String answer(String s, List<String> history) {
      return makeResponder_callAnswerMethod(bot, s, history);
    }
  };
}


static String defaultBotName() {
  return getProgramTitle() + ".";
}


static <A, B> Map<A, B> syncMRUCache(int size) {
  return synchroMap(new MRUCache(size));
}


// f must return a list
static List concatMap(Object f, Iterable l) {
  return concatLists(map(f, l));
}

static List concatMap(Iterable l, Object f) {
  return concatMap(f, l);
}

static List concatMap(Object f, Object[] l) {
  return concatLists(map(f, l));
}

static List concatMap(Object[] l, Object f) {
  return concatMap(f, l);
}

static <A, B, C extends Iterable<B>> List<B> concatMap(Iterable<A> l, IF1<A, C> f) {
  return concatMap(l, (Object) f);
}

static <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, Iterable<A> l) {
  return concatMap(l, f);
}

static <A, B, C extends Iterable<B>> List<B> concatMap(IF1<A, C> f, A[] l) {
  return concatMap((Object) f, l);
}


static List<File> listFilesWithSuffix(File dir, String suffix) {
  List<File> l = new ArrayList();
  for (File f : listFiles(dir))
    if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      l.add(f);
  return l;
}

static List<File> listFilesWithSuffix(String suffix, File dir) {
  return listFilesWithSuffix(dir, suffix);
}


static void _onJavaXSet() {}


// return Int.MAX_VALUE if not applicable
// Lower score is better
static int methodApplicabilityScore(Method m, Object[] args) {
   Class<?>[] types = m.getParameterTypes();
   if (types.length != args.length) return Integer.MAX_VALUE;
   int score = 0;
   for (int i = 0; i < types.length; i++) {
     Object a = args[i];
     Class c = types[i];
     if (a == null) ++score;
     else if (c == a.getClass()) {} // perfect match
     else if (isInstanceX(c, a)) ++score;
     else return Integer.MAX_VALUE;
  }
  return score;
}


  static RuntimeException todo() {
    throw new RuntimeException("TODO");
  }
  
  static RuntimeException todo(Object msg) {
    throw new RuntimeException("TODO: " + msg);
  }


static String loadTextFile_trim(String fileName) {
  return trim(loadTextFile(fileName));
}

static String loadTextFile_trim(File f, String defaultContents) {
  return trim(loadTextFile(f, defaultContents));
}

static String loadTextFile_trim(File fileName) {
  return trim(loadTextFile(fileName));
}

static String loadTextFile_trim(String fileName, String defaultContents) {
  return trim(loadTextFile(fileName, defaultContents));
}


static List<String> stdFunctionListSnippetIDs() {
  return ll("#1006654", "#761");
}


// map contains function name -> snippet id
static Map<String, String> parseStdFunctionsList(String snippetSrc) {
  return parseStdFunctionsList(snippetSrc, new LinkedHashMap());
}

static Map<String, String> parseStdFunctionsList(String snippetSrc, Map<String, String> map) {
  List<String> tok = javaTok(snippetSrc);
  int i = findCodeTokens(tok, "standardFunctions", "=", "litlist", "(");
  int opening = i+6;
  int closing = indexOf(tok, ")", opening)-1;
  for (i = opening+2; i < closing; i += 4) {
    String[] f = unquote(tok.get(i)).split("/");
    map.put(f[1], f[0]);
  }
  return map;
}


static boolean preferCached = false;
static boolean loadSnippet_debug = false;
static ThreadLocal<Boolean> loadSnippet_silent = new ThreadLocal();
static ThreadLocal<Boolean> loadSnippet_publicOnly = new ThreadLocal();
static int loadSnippet_timeout = 30000;



static String loadSnippet(String snippetID) { try {
  if (snippetID == null) return null;
  return loadSnippet(parseSnippetID(snippetID), preferCached);
} catch (Exception __e) { throw rethrow(__e); } }

static String loadSnippet(String snippetID, boolean preferCached) throws IOException {
  return loadSnippet(parseSnippetID(snippetID), preferCached);
}

static  IF1<Long, String> loadSnippet;
static String loadSnippet(long snippetID) { return loadSnippet != null ? loadSnippet.get(snippetID) : loadSnippet_base(snippetID); }
final static String loadSnippet_fallback(IF1<Long, String> _f, long snippetID) { return _f != null ? _f.get(snippetID) : loadSnippet_base(snippetID); }
static String loadSnippet_base(long snippetID) { try {
  return loadSnippet(snippetID, preferCached);
} catch (Exception __e) { throw rethrow(__e); } }

static String loadSnippet(long snippetID, boolean preferCached) throws IOException {
  if (isLocalSnippetID(snippetID))
    return loadLocalSnippet(snippetID);
    
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadSnippet(fsI(snippetID));
  
  
  return loadSnippet_noResourceLoader(snippetID, preferCached);
}

static String loadSnippet_noResourceLoader(long snippetID, boolean preferCached) throws IOException {
  String text;
  
  // boss bot (old concept)
  /*text = getSnippetFromBossBot(snippetID);
  if (text != null) return text;*/
  
  initSnippetCache();
  text = DiskSnippetCache_get(snippetID);
  
  if (preferCached && text != null)
    return text;
  
  try {
    if (loadSnippet_debug && text != null) System.err.println("md5: " + md5(text));
    String url = tb_mainServer() + "/getraw.php?id=" + snippetID + "&utf8=1";
    if (nempty(text)) url += "&md5=" + md5(text);
    if (!isTrue(loadSnippet_publicOnly.get()))
      url += standardCredentials();
    
    String text2 = loadSnippet_loadFromServer(url);
    
    boolean same = eq(text2, "==*#*==");
    if (loadSnippet_debug) print("loadSnippet: same=" + same);
    if (!same) text = text2;
  } catch (RuntimeException e) {
    e.printStackTrace();
    throw new IOException("Snippet #" + snippetID + " not found or not public");
  }

  try {
    initSnippetCache();
    DiskSnippetCache_put(snippetID, text);
  } catch (IOException e) {
    System.err.println("Minor warning: Couldn't save snippet to cache ("  + DiskSnippetCache_getDir() + ")");
  }

  return text;
}

static File DiskSnippetCache_dir;

public static void initDiskSnippetCache(File dir) {
  DiskSnippetCache_dir = dir;
  dir.mkdirs();
}

public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
  return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
}

private static File DiskSnippetCache_getFile(long snippetID) {
  return new File(DiskSnippetCache_dir, "" + snippetID);
}

public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
  saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
}

public static File DiskSnippetCache_getDir() {
  return DiskSnippetCache_dir;
}

public static void initSnippetCache() {
  if (DiskSnippetCache_dir == null)
    initDiskSnippetCache(getGlobalCache());
}

static String loadSnippet_loadFromServer(String url) {
  Integer oldTimeout = setThreadLocal(loadPage_forcedTimeout_byThread, loadSnippet_timeout);
  try {
    return isTrue(loadSnippet_silent.get()) ? loadPageSilently(url) : loadPage(url);
  } finally {
    loadPage_forcedTimeout_byThread.set(oldTimeout);
  }
}



static String standardCredentials() {
  String user = standardCredentialsUser();
  String pass = standardCredentialsPass();
  if (nempty(user) && nempty(pass))
    return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
  return "";
}


static IResourceLoader vm_getResourceLoader() {
  return proxy(IResourceLoader.class, vm_generalMap_get("_officialResourceLoader"));
}


static String fsIOpt(String s) {
  return formatSnippetIDOpt(s);
}


static String loadCachedTranspilation(String id) { try {
  return loadTextFilePossiblyGZipped(getCachedTranspilationFile(id));
} catch (Throwable __e) { return null; } }



static boolean machineIsOffline() {
  return isFalse(callF(vmGeneralMap_get("areWeOnline")));
}


static boolean isOfflineMode() {
  return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
}


static boolean isLocalSnippet(String snippetID) {
  return isLocalSnippetID(snippetID);
}



static boolean isLocalSnippet(long snippetID) {
  return isLocalSnippetID(snippetID);
}


static String getServerTranspiled(String snippetID) {
  return getServerTranspiled(snippetID, null);
}

static boolean getServerTranspiled_printStackTrace = false;

// returns "SAME" if md5 matches
static String getServerTranspiled(String snippetID, String expectedMD5) { try {
  if (getServerTranspiled_printStackTrace) printStackTrace();
  long id = parseSnippetID(snippetID);
  /*S t = getTranspilationFromBossBot(id);
  if (t != null) return t;*/
  
  String text = loadPage_utf8(tb_mainServer() + "/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1"
    + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "")
    + standardCredentials());
  if (nempty(text) && neq(text, "SAME"))
    saveTranspiledCode(snippetID, text);
  return text;
} catch (Exception __e) { throw rethrow(__e); } }


static void printExceptionShort(Throwable e) { printExceptionShort("", e); }
static void printExceptionShort(String prefix, Throwable e) {
  print(prefix, exceptionToStringShort(e));
}


static void printWithMS(String s) {
  printWithMSTime(s);
}


static <A, B> B mapPut_returnValue(Map<A, B> map, A key, B value) {
  mapPut(map, key, value);
  return value;
}


static String uniqueFileNameUsingMD5_80_v2(String fullName) {
  return uniqueFileNameUsingMD5_80_v2(fullName, md5(fullName));
}

static String uniqueFileNameUsingMD5_80_v2(String fullName, String md5) {
  return takeFirst(80-33, fileNameEncode(fullName)) + " - " + md5;
}


static File javaxCachesDir_dir; // can be set to work on different base dir

static File javaxCachesDir() {
  return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
}

static File javaxCachesDir(String sub) {
  return newFile(javaxCachesDir(), sub);
}


static void saveTextFileUnlessExists(File f, String contents) {
  if (f != null && !f.exists())
    saveTextFile(f, contents);
}


static long recommendedTranspilationDateForStandardFunction(String sfName) {
  return toLong(mechMap("Recommended SF Transpilation Date").get(sfName));
}


static <A> boolean setAdd(Collection<A> c, A a) {
  if (c == null || c.contains(a)) return false;
  c.add(a);
  return true;
}


static void clearTokens(List<String> tok) {
  clearAllTokens(tok);
}

static void clearTokens(List<String> tok, int i, int j) {
  clearAllTokens(tok, i, j);
}




static JavaXClassLoader hotwire_makeClassLoader(List<File> files) {
  Collection<String> toShare = hotwire_classesToShare();
  return nempty(toShare)
    ? new JavaXClassLoaderWithParent2(null, files, myClassLoader(), cloneList(toShare))
    : new JavaXClassLoader(null, files);
}


static boolean _inCore() {
  return false;
}


static List hotwire_copyOver_after = synchroList();

static void hotwire_copyOver(Class c) {
  // TODO: make a mechanism for making such "inheritable" fields
  for (String field : ll("print_log", "print_silent", "androidContext", "_userHome"))
    setOptIfNotNull(c, field, getOpt(mc(), field));
    
  
  
  setOptIfNotNull(c, "mainBot" , getMainBot());
  setOpt(c, "creator_class" , new WeakReference(mc()));
  pcallFAll(hotwire_copyOver_after, c);
}


static File loadLibrary(String snippetID) {
  return loadBinarySnippet(snippetID);
}


static String stringOptPar(Object[] params, String name) {
  return (String) optPar(params, name);
}




static boolean veryQuickJava_silent = true;
static boolean veryQuickJava_useCompilerBot = true; // we always use it now
static ThreadLocal<String> veryQuickJava_transpiled = new ThreadLocal();
static Object veryQuickJava3_cacheFunction; // func(S, LS) -> Class
static ThreadLocal<IVF1<String>> veryQuickJava_onJavaSource = new ThreadLocal();

// mainJava is a complete program, but without the !752/!759 at the top
// returns link to main class
static Class veryQuickJava3(String mainJava) {
  return veryQuickJava3(mainJava, emptyList());
}

static Class veryQuickJava3(String mainJava, List<String> libs) {
  Class c =  (Class) (callF(veryQuickJava3_cacheFunction, mainJava, libs));
  
  if (c != null) return c;
  transpileRaw_silent = veryQuickJava_silent;
  String src = transpileRaw(mainJava); // transpiled, with lib references
  if (empty(src)) {
    printWithIndent("JAVAX> ", mainJava);
    throw fail("Transpiler returned empty result");
  }
  if (veryQuickJava_transpiled.get() != null)
    veryQuickJava_transpiled.set(src);
  callF(veryQuickJava_onJavaSource.get(), src);
  
  return veryQuickJava_finish(src, libs);
}


/** writes safely (to temp file, then rename) */
static File saveTextFile(String fileName, String contents) throws IOException {
  /*ifdef CriticalActions
  temp beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  endifdef*/
  
  File file = new File(fileName);
  mkdirsForFile(file);
  String tempFileName = fileName + "_temp";
  File tempFile = new File(tempFileName);
  if (contents != null) {
    if (tempFile.exists()) try {
      String saveName = tempFileName + ".saved." + now();
      copyFile(tempFile, new File(saveName));
    } catch (Throwable e) { printStackTrace(e); }
    FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
    printWriter.print(contents);
    printWriter.close();
  }
  
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + fileName);

  if (contents != null)
    if (!tempFile.renameTo(file))
      throw new IOException("Can't rename " + tempFile + " to " + file);
      
  
  vmBus_send("wroteFile", file);
  
  return file;
}

static File saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
  return fileName;
} catch (Exception __e) { throw rethrow(__e); } }


static ThreadLocal<Long> saveTiming_last = new ThreadLocal();

static void saveTiming(long ms) {
  print(ms + " ms");
  saveTiming_noPrint(ms);
}

static void saveTiming_noPrint(long ms) {
  saveTiming_last.set(ms);
}

static ThreadLocal<Long> saveTiming_tl() {
  return saveTiming_last;
}


static <A> Set<A> synchroHashSet() {
  return synchronizedSet(new HashSet<A>());
}



static <A> boolean addIfNotNull(Collection<A> l, A a) {
  return a != null && l != null & l.add(a);
}


static <A> void addIfNotNull(MultiSet<A> ms, A a) {
  if (a != null && ms != null) ms.add(a);
}



static void closeAutoCloseables(Collection<AutoCloseable> l) {
  if (l != null) for (AutoCloseable c : l) { try { c.close(); } catch (Throwable __e) { printStackTrace(__e); }}
}


static <A> List<A> getAndClearList(Collection<A> l) {
  if (l == null) return emptyList();
  synchronized(collectionMutex(l)) {
    List<A> out = cloneList(l);
    l.clear();
    return out;
  }
}


static <A> A _get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

static Object _get(Object o, String field) {
  return get(o, field);
}

static Object _get(String field, Object o) {
  return get(o, field);
}
static <A> A _get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}


static Object sleepQuietly_monitor = new Object();

static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(sleepQuietly_monitor) { sleepQuietly_monitor.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }


static String roundBracket(String s) {
  return "(" + s + ")";
}

static String roundBracket(Object s) {
  return roundBracket(str(s));
}


static String _computerID;
static Lock computerID_lock = lock();

public static String computerID() {
  if (_computerID == null) {
    Lock __0 = computerID_lock; lock(__0); try {
    if (_computerID != null) return _computerID;
    File file = computerIDFile();
    _computerID = loadTextFile(file.getPath());
    if (_computerID == null) {
      // legacy load
      _computerID = loadTextFile(userDir(".tinybrain/computer-id"));
      if (_computerID == null)
        _computerID = makeRandomID(12, new SecureRandom());
      saveTextFile(file, _computerID);
    }
  } finally { unlock(__0); } }
  return _computerID;
}


static <A> TreeSet<A> treeSet() {
  return new TreeSet();
}


static String collapseWord(String s) {
  if (s == null) return "";
  StringBuilder buf = new StringBuilder();
  for (int i = 0; i < l(s); i++)
    if (i == 0 || !charactersEqualIC(s.charAt(i), s.charAt(i-1)))
      buf.append(s.charAt(i));
  return buf.toString();
}


static List<String> toLowerCase(List<String> strings) {
  List<String> x = new ArrayList();
  for (String s : strings)
    x.add(s.toLowerCase());
  return x;
}

static String[] toLowerCase(String[] strings) {
  String[] x = new String[l(strings)];
  for (int i = 0; i < l(strings); i++)
    x[i] = strings[i].toLowerCase();
  return x;
}

static String toLowerCase(String s) {
  return s == null ? "" : s.toLowerCase();
}


static String firstWord2(String s) {
  s = xltrim(s);
  if (empty(s)) return "";
  if (isLetterOrDigit(first(s)))
    return takeCharsWhile(__49 -> isLetterOrDigit(__49), s);
  else return "" + first(s);
}


static IMeta initMetaOfJComponent(JComponent c) {
  if (c == null) return null;
  IMeta meta =  (IMeta) (c.getClientProperty(IMeta.class));
  if (meta == null)
    c.putClientProperty(IMeta.class, meta = new Meta());
  
  return meta;
}


static <A> A optCast(Class<A> c, Object o) {
  return isInstance(c, o) ? (A) o : null;
}


// custom mainClass only works with hotwire_here
static Class<?> hotwire(String src) { return hotwire(src, __1 -> mainClassNameForClassLoader(__1)); }
static Class<?> hotwire(String src, IF1<ClassLoader, String> calculateMainClass) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    
    
    Class c =  (Class) (call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
    
  }
}


static <A> A callMain(A c, String... args) {
  callOpt(c, "main", new Object[] {args});
  return c;
}

static void callMain() {
  callMain(mc());
}


static Runnable addThreadInfoToRunnable(final Object r) {
  final Object info = _threadInfo();
  return info == null ? asRunnable(r) : new Runnable() {  public void run() { try {  _inheritThreadInfo(info); callF(r); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_inheritThreadInfo(info); callF(r);"; }};
}




static TimeZone getTimeZone(String name) {
  return TimeZone.getTimeZone(name);
}


static String standardTimeZone_name = "Europe/Berlin";

static String standardTimeZone() {
  return standardTimeZone_name;
}




  static String format3(String pat, Object... args) {
    if (args.length == 0) return pat;
    
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2)
      if (tok.get(i).equals("*"))
        tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }
  
  static String format3_formatArg(Object arg) {
    if (arg == null) return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long) return String.valueOf(arg);
    return quote(structure(arg));
  }
  



static boolean isLocalhost(String ip) {
  return isLoopbackIP(ip) || eqic(ip, "localhost");
}


static int vmPort() {
  return myVMPort();
}


static DialogIO talkToThisVM() {
  return new talkToThisVM_IO();
}

static class talkToThisVM_IO extends DialogIO { 
  List<String> answers = ll(thisVMGreeting());
  
  boolean isLocalConnection() { return true; }
  boolean isStillConnected() { return true; }
  int getPort() { return vmPort(); }
  
  void sendLine(String line) {
    answers.add(or2(sendToThisVM_newThread(line), "?"));
  }
  
  String readLineImpl() { try {
    return popFirst(answers);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {}
  Socket getSocket() { return null; }
}


static Producer<String> javaTokC_noMLS_iterator(final String s) {
  return javaTokC_noMLS_iterator(s, 0);
}

static Producer<String> javaTokC_noMLS_iterator(final String s, final int startIndex) {
  return new Producer<String>() {
    final int l = s.length();
    int i = startIndex;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && Character.isJavaIdentifierPart(s.charAt(j)));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}



static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
  final class X implements Producer<String> {
    StringBuilder buf = new StringBuilder(); // stores from "i"
    char c, d, e = 'x'; // just not '\0'
    
    X() {
      // fill c, d and e
      nc();
      nc();
      nc();
    }
    
    // get next character(s) into c, d and e
    void nc() { try {
      c = d;
      d = e;
      if (e == '\0') return;
      int i = r.read();
      e = i < 0 ? '\0'
        : i == '\0' ? '_' // shouldn't happen anymore
        : (char) i;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void ncSave() {
      if (c != '\0') {
        buf.append(c);
        nc();
      }
    }
    
    public String next() {
      // scan for whitespace
      while (c != '\0') {
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          nc();
        else if (c == '/' && d == '*') {
          do nc(); while (c != '\0' && !(c == '*' && d == '/'));
          nc(); nc();
        } else if (c == '/' && d == '/') {
          do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
        } else
          break;
      }
      
      if (c == '\0') return null;

      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ncSave();
        while (c != '\0') {
          if (c == opener || c == '\n') { // end at \n to not propagate unclosed string literal errors
            ncSave();
            break;
          } else if (c == '\\') {
            ncSave();
            ncSave();
          } else
            ncSave();
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\''); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ncSave(); while (Character.isDigit(c));
        if (c == 'L') ncSave(); // Long constants like 1L
      } else
        ncSave();
        
      String t = buf.toString();
      buf.setLength(0);
      return t;
    }
  }
  
  return new X();
}



static BigInteger parseBigInt(String s) {
  return new BigInteger(s);
}


static float parseFloat(String s) {
  return Float.parseFloat(s);
}


static String unquoteUsingCharArray(String s, char[] buf) {
  if (s == null) return null;
  if (startsWith(s, '[')) {
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    if (i < s.length() && s.charAt(i) == '[') {
      String m = s.substring(1, i);
      if (s.endsWith("]" + m + "]"))
        return s.substring(i+1, s.length()-i-1);
    }
  }
  
  if (s.length() > 1) {
    char c = s.charAt(0);
    if (c == '\"' || c == '\'') {
      int l = endsWith(s, c) ? s.length()-1 : s.length();
      if (l > buf.length) return unquote(s); // fallback
      int n = 0;
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              buf[n++] = (char) Integer.parseInt(code, 8);
              continue;
          }
          switch (nextChar) {
          case '\"': ch = '\"'; break;
          case '\\': ch = '\\'; break;
          case 'b': ch = '\b'; break;
          case 'f': ch = '\f'; break;
          case 'n': ch = '\n'; break;
          case 'r': ch = '\r'; break;
          case 't': ch = '\t'; break;
          case '\'': ch = '\''; break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              char[] x = Character.toChars(code);
              int lx = x.length;
              for (int j = 0; j < lx; j++)
                buf[n++] = x[j];
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        buf[n++] = ch;
      }
      return new String(buf, 0, n);
    }
  }
    
  return s; // not quoted - return original
}


static boolean structure_isMarker(String s, int i, int j) {
  if (i >= j) return false;
  if (s.charAt(i) != 'm') return false;
  ++i;
  while (i < j) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}


static String internIfLongerThan(String s, int l) {
  return s == null ? null : l(s) >= l ? intern(s) : s;
}


static char unquoteCharacter(String s) {
  assertTrue(s.startsWith("'") && s.length() > 1);
  return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length()-1 : s.length()) + "\"").charAt(0);
}


static boolean isLongConstant(String s) {
  if (!s.endsWith("L")) return false;
  s = s.substring(0, l(s)-1);
  return isInteger(s);
}


static List parseList(String s) {
  return (List) safeUnstructure(s);
}


static <A> List<A> synchroLinkedList() {
  return synchroList(new LinkedList<A>());
}



static <A, B> NavigableMap<A, B> synchroNavigableMap(NavigableMap<A, B> map) {
  
    return new SynchronizedNavigableMap(map);
  
  
}


static <A, B> SortedMap<A, B> synchroSortedMap(SortedMap<A, B> map) {
  
    return new SynchronizedSortedMap(map);
  
  
}


static byte[] hexToBytes(String s) {
  if (odd(l(s))) throw fail("Hex string has odd length: " + quote(shorten(10, s)));
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    int a = parseHexChar(s.charAt(i*2));
    int b = parseHexChar(s.charAt(i*2+1));
    if (a < 0 || b < 0)
      throw fail("Bad hex byte: " + quote(substring(s, i*2, i*2+2)) + " at " + i*2 + "/" + l(s));
    bytes[i] = (byte) ((a << 4) | b);
  }
  return bytes;
}


static boolean[] boolArrayFromBytes(byte[] a, int n) {
  boolean[] b = new boolean[n];
  int m = min(n, l(a)*8);
  for (int i = 0; i < m; i++)
    b[i] = (a[i/8] & 1 << (i & 7)) != 0;
  return b;
}


static boolean isAbstract(Class c) {
  return (c.getModifiers() & Modifier.ABSTRACT) != 0;
}

static boolean isAbstract(Method m) {
  return (m.getModifiers() & Modifier.ABSTRACT) != 0;
}


// Use like this: printVars_str(+x, +y);
// Or: printVars("bla", +x);
// Or: printVars bla(+x);
static void printVars_str(Object... params) {
  print(renderVars_str(params));
}


static <A> Constructor nuStubInnerObject_findConstructor(Class<A> c) { return nuStubInnerObject_findConstructor(c, null); }
static <A> Constructor nuStubInnerObject_findConstructor(Class<A> c, Object classFinder) { try {
  Class outerType = getOuterClass(c, classFinder);
  Constructor m = c.getDeclaredConstructor(outerType);
  makeAccessible(m);
  return m;
} catch (Exception __e) { throw rethrow(__e); } }


static Map<Class, Constructor> nuEmptyObject_cache = newDangerousWeakHashMap();

static <A> A nuEmptyObject(Class<A> c) { try {
  Constructor ctr;
  
  synchronized(nuEmptyObject_cache) {
    ctr = nuEmptyObject_cache.get(c);
    if (ctr == null) {
      nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
      makeAccessible(ctr);
    }
  }

  try {
    return (A) ctr.newInstance();
  } catch (InstantiationException e) {
    if (empty(e.getMessage()))
      if ((c.getModifiers() & Modifier.ABSTRACT) != 0)
        throw fail("Can't instantiate abstract class " + className(c), e);
      else
        throw fail("Can't instantiate " + className(c), e);  
    else throw rethrow(e);
  }
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuEmptyObject_findConstructor(Class c) {
  for (Constructor m : getDeclaredConstructors_cached(c))
    if (m.getParameterTypes().length == 0)
      return m;
  throw fail("No default constructor declared in " + c.getName());
}



static void setOptAllDyn_pcall(DynamicObject o, Map<String, Object> fields) {
  if (fields == null || o == null) return;
  HashMap<String, Field> fieldMap = instanceFieldsMap(o);
  for (Map.Entry<String, Object> e : fields.entrySet()) { try {
    String field = e.getKey();
    Object val = e.getValue();
    Field f = fieldMap.get(field);
    if (f != null)
      smartSet(f, o, val);
    else {
      dynamicObject_setRawFieldValue(o, intern(field), val);
      
    }
  } catch (Throwable __e) { printStackTrace(__e); }}
}


static void setOptAll_pcall(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    try { setOpt(o, field, fields.get(field)); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
}

static void setOptAll_pcall(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    try { setOpt(o, field, value); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  }
}


static void fixOuterRefs(Object o) { try {
  if (o == null) return;
  Field[] l = thisDollarOneFields(o.getClass());
  if (l.length <= 1) return;
  Object father = null;
  for (Field f : l) {
    father = f.get(o);
    if (father != null) break;
  }
  if (father == null) return;
  for (Field f : l)
    f.set(o, father);
} catch (Exception __e) { throw rethrow(__e); } }


static void pcallOpt_noArgs(Object o, String method) {
  try { callOpt_noArgs(o, method); } catch (Throwable __e) { printStackTrace(__e); }
}


static Object newMultiDimensionalOuterArray(Class elementType, int dimensions, int length) {
  int[] dims = new int[dimensions];
  dims[0] = length;
  return Array.newInstance(elementType, dims);
}


static int[] toIntArray(Collection<Integer> l) {
  int[] a = new int[l(l)];
  int i = 0;
  if (a.length != 0) for (int x : l)
    a[i++] = x;
  return a;
}


static double[] toDoubleArray(Collection<Double> l) {
  double[] a = new double[l(l)];
  int i = 0;
  if (a.length != 0) for (double x : l)
    a[i++] = x;
  return a;
}




static String[] toStringArray(Collection<String> c) {
  String[] a = new String[l(c)];
  Iterator<String> it = c.iterator();
  for (int i = 0; i < l(a); i++)
    a[i] = it.next();
  return a;
}

static String[] toStringArray(Object o) {
  if (o instanceof String[])
    return (String[]) o;
  else if (o instanceof Collection)
    return toStringArray((Collection<String>) o);
  else
    throw fail("Not a collection or array: " + getClassName(o));
}



static TreeSet<String> ciSet() {
  return caseInsensitiveSet();
}


// DIFFERENCES to jfind: always ignores case, doesn't recognize <id> etc
// You probably want jmatch2

static boolean jmatch(String pat, String s) {
  return jmatch(pat, s, null);
}

static boolean jmatch(String pat, String s, Matches matches) {
  if (s == null) return false;
  return jmatch(pat, javaTok(s), matches);
}

static boolean jmatch(String pat, List<String> toks) {
  return jmatch(pat, toks, null);
}

static boolean jmatch(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = javaTok(pat);
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}


static ThreadLocal<Boolean> DynamicObject_loading = or((ThreadLocal) get(getClass("x30_pkg.x30_util"), "DynamicObject_loading"), new ThreadLocal());

static ThreadLocal<Boolean> dynamicObjectIsLoading_threadLocal() { 
  return DynamicObject_loading;
}


static Map<String, Integer> newFindBot2_cache = synchroHashMap();
static boolean newFindBot2_verbose = false;

static DialogIO newFindBot2(String name) {
  Integer port = newFindBot2_cache.get(name);
  if (port != null) {
    if (newFindBot2_verbose)
      print("newFindBot2: testing " + name + " => " + port);
    DialogIO io = talkTo(port);
    String q = format("has bot *", name);
    String s = io.ask(q);
    if (match("yes", s)) {
      io = talkToSubBot(name, io);
      call(io, "pushback", "?"); // put some hello string in (yes, this should be improved.)
      return io;
    }
    // bot not there anymore - remove cache entry
    newFindBot2_cache.remove(name);
    if (newFindBot2_verbose)
      print("newFindBot2: dropping " + name + " => " + port);
  }
  
  DialogIO io = findBot(name);
  if (io != null) {
    newFindBot2_cache.put(name, io.getPort());
    if (newFindBot2_verbose)
      print("newFindBot2: remembering " + name + " => " + port);
  }
  return io;
}


static List<String> parse3(String s) {
  return dropPunctuation(javaTokPlusPeriod(s));
}


static boolean equalsIgnoreCase(String a, String b) {
  return eqic(a, b);
}

static boolean equalsIgnoreCase(char a, char b) {
  return eqic(a, b);
}


static void assertFalse(Object o) {
  if (!(eq(o, false) /*|| isFalse(pcallF(o))*/))
    throw fail(str(o));
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}



static boolean match3(String pat, String s) {
  return match3(pat, s, null);
}

static boolean match3(String pat, String s, Matches matches) {
  if (pat == null || s == null) return false;
  return match3(pat, parse3_cachedInput(s), matches);
}
  
static boolean match3(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = parse3_cachedPattern(pat);
  return match3(tokpat, toks, matches);
}

static boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) matches.m = m; return true;
}


static void removeFromMultiPort(long vport) {
  if (vport == 0) return;
  for (Object port : getMultiPorts())
    call(port, "removePort", vport);
}


static String callStaticAnswerMethod(List bots, String s) {
  for (Object c : bots) try {
    String answer = callStaticAnswerMethod(c, s);
    if (!empty(answer)) return answer;
  } catch (Throwable e) {
    print("Error calling " + getProgramID(c));
    e.printStackTrace();
  }
  return null;
}

static String callStaticAnswerMethod(Object c, String s) {
  String answer = (String) callOpt(c, "answer", s, litlist(s));
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}

static String callStaticAnswerMethod(String s) {
  return callStaticAnswerMethod(mc(), s);
}

static String callStaticAnswerMethod(String s, List<String> history) {
  return callStaticAnswerMethod(mc(), s, history);
}

static String callStaticAnswerMethod(Object c, String s, List<String> history) {
  String answer = (String) callOpt(c, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}


static List<Object> record_list = synchroList();

static void record(Object o) {
  record_list.add(o);
}


static Object addToMultiPort_responder;

static long addToMultiPort(final String botName) {
  return addToMultiPort(botName, new Object() {
    public String answer(String s, List<String> history) {
      String answer =  (String) (callOpt(getMainClass(), "answer", s, history));
      if (answer != null) return answer;
      answer = (String) callOpt(getMainClass(), "answer", s);
      if (answer != null) return answer;
      if (match3("get injection id", s))
        return getInjectionID();
      return null;
    }
  });
}

static long addToMultiPort(final String botName, final Object responder) {
  //print(botName);
  addToMultiPort_responder = responder;
  startMultiPort();
  List ports = getMultiPorts();
  if (ports == null) return 0;
  if (ports.isEmpty())
    throw fail("No multiports!");
  if (ports.size() > 1)
    print("Multiple multi-ports. Using last one.");
  Object port = last(ports);
  Object responder2 = new Object() {
    public String answer(String s, List<String> history) {
      if (match3("get injection id", s))
        return getInjectionID();
      if (match3("your name", s))
        return botName;
      return (String) call(responder, "answer", s, history);
    }
  };
  record(responder2);
  return (Long) call(port, "addResponder", botName, responder2);
}



static AtomicInteger dialogServer_clients = new AtomicInteger();
static boolean dialogServer_printConnects = false;
static ThreadLocal<Boolean> startDialogServer_quiet = new ThreadLocal();

static Set<String> dialogServer_knownClients = synchroTreeSet();

static int startDialogServerOnPortAbove(int port, DialogHandler handler) {
  while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler))
    ++port;
  return port;
}

static int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
  while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true))
    ++port;
  return port;
}

static void startDialogServer(int port, DialogHandler handler) {
  if (!startDialogServerIfPortAvailable(port, handler))
    throw fail("Can't start dialog server on port " + port);
}

static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
  return startDialogServerIfPortAvailable(port, handler, false);
}

static ServerSocket startDialogServer_serverSocket;
  
static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
  ServerSocket serverSocket = null;
  try {
    serverSocket = new ServerSocket(port);
  } catch (IOException e) {
    // probably the port number is used - let's assume there already is a chat server.
    return false;
  }
  final ServerSocket _serverSocket = serverSocket;
  startDialogServer_serverSocket = serverSocket;

  Thread thread = new Thread("Socket accept port " + port) { public void run() {
   try {
    while (true) {
      try {
        final Socket s = _serverSocket.accept();
        
        String client = s.getInetAddress().toString();
        if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
          print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
          dialogServer_knownClients.add(client);
        }
        
        String threadName = "Handling client " + s.getInetAddress();

        Thread t2 = new Thread(threadName) {
         public void run() {
          try {
            final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
            final BufferedReader in = new BufferedReader(
              new InputStreamReader(s.getInputStream(), "UTF-8"));
              
            DialogIO io = new DialogIO() {
            
              // This should be the same as #1001076 (talkTo)
            
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    w.write(line + "\n");
    w.flush();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void close() {
    try {
      s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
  };
            
            try {
              handler.run(io);
            } finally {
              if (!io.noClose)
                s.close();
            }
          } catch (IOException e) {
            print("[internal] " + e);
          } finally {
            //print("client disconnect - " + dialogServer_clients.decrementAndGet() + " remaining");
          }
         }
        }; // Thread t2
        t2.setDaemon(true); // ?
        t2.start();
      } catch (SocketTimeoutException e) {
      }
    }   
   } catch (IOException e) {
     print("[internal] " + e);
   }
  }};
  if (daemon) thread.setDaemon(true);
  thread.start();
 
  if (!isTrue(getAndClearThreadLocal(startDialogServer_quiet)))
    print("Dialog server on port " + port + " started."); 
  return true;
}


static volatile boolean readLine_noReadLine = false;

static String readLine_lastInput;
static String readLine_prefix = "[] ";

static String readLine() {
  if (readLine_noReadLine) return null;
  String s = readLineHidden();
  if (s != null) {
    readLine_lastInput = s;
    print(readLine_prefix + s);
  }
  return s;
}


static String getInnerMessage(Throwable e) {
  if (e == null) return null;
  return getInnerException(e).getMessage();
}


static boolean publicCommOn() {
  return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
}


static String indentx(String s) {
  return indentx(indent_default, s);
}

static String indentx(int n, String s) {
  return dropSuffix(repeat(' ', n), indent(n, s));
}

static String indentx(String indent, String s) {
  return dropSuffix(indent, indent(indent, s));
}


static String processID_cached;

// try to get our current process ID
static String getPID() {
  if (processID_cached == null) {
    String name = ManagementFactory.getRuntimeMXBean().getName();
    processID_cached = name.replaceAll("@.*", "");
  }
  return processID_cached;
}


static String getInjectionID() {
  return (String) call(getJavaX(), "getInjectionID", getMainClass());
}


static String getProgramTitle() {
  return getProgramName();
}


static File[] listFiles(File dir) {
  File[] files = dir.listFiles();
  return files == null ? new File[0] : files;
}

static File[] listFiles(String dir) {
  return listFiles(new File(dir));
}


static boolean isLocalSnippetID(String snippetID) {
  return isSnippetID(snippetID) && isLocalSnippetID(psI(snippetID));
}

static boolean isLocalSnippetID(long snippetID) {
  return snippetID >= 1000 && snippetID <= 9999;
}


static String loadLocalSnippet(String snippetID) {
  return loadLocalSnippet(psI(snippetID));
}

static String loadLocalSnippet(long snippetID) {
  return loadTextFile(localSnippetFile(snippetID));
}


static String fsI(String id) {
  return formatSnippetID(id);
}

static String fsI(long id) {
  return formatSnippetID(id);
}


static File getGlobalCache() {
  File file = new File(javaxCachesDir(), "Binary Snippets");
  file.mkdirs();
  return file;
}



static String standardCredentialsUser() {
  return trim(loadTextFile(
    oneOfTheFiles(
      javaxSecretDir("tinybrain-username"),
      userDir(".tinybrain/username"))));
}


static String standardCredentialsPass() {
  return trim(loadTextFile(
    oneOfTheFiles(
      javaxSecretDir("tinybrain-userpass"),
      userDir(".tinybrain/userpass"))));
}


static <A> A proxy(Class<A> intrface, final Object target) {
  if (target == null) return null;
  if (isInstance(intrface, target)) return (A) target;
  return (A) java.lang.reflect.Proxy.newProxyInstance(intrface.getClassLoader(),
    new Class[] { intrface },
    new proxy_InvocationHandler(target));
}

static <A> A proxy(Object target, Class<A> intrface) {
  return proxy(intrface, target);
}


static String loadTextFilePossiblyGZipped(String fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}
  
static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
  File gz = new File(fileName + ".gz");
  return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
}

static String loadTextFilePossiblyGZipped(File fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}

static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
  return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
}



static File getCachedTranspilationFile(String id) {
  return newFile(getCodeProgramDir(id), "Transpilation");
}



static Object vmGeneralMap_get(Object key) {
  return vm_generalMap_get(key);
}


static String loadProgramTextFile(String name) {
  return loadTextFile(getProgramFile(name));
}

static String loadProgramTextFile(String progID, String name) {
  return loadTextFile(getProgramFile(progID, name));
}

static String loadProgramTextFile(String progID, String name, String defaultText) {
  return loadTextFile(getProgramFile(progID, name), defaultText);
}


static String loadPage_utf8(URL url) {
  return loadPage_utf8(url.toString());
}

static String loadPage_utf8(String url) {
   AutoCloseable __1 = tempSetTL(loadPage_charset, "UTF-8"); try {
  return loadPage(url);
} finally { _close(__1); }}

static String loadPage_utf8(URLConnection con, URL url, boolean addHeaders) throws IOException {
   AutoCloseable __2 = tempSetTL(loadPage_charset, "UTF-8"); try {
  return loadPage(con, url, addHeaders);
} finally { _close(__2); }}


static void saveTranspiledCode(String progID, String code) {
  File dir = getCodeProgramDir(progID);
  new File(dir, "Transpilation").delete();
  saveGZTextFile(new File(dir, "Transpilation.gz"), code);
}


static void printWithMSTime(String s) {
  print(hmsWithColonsAndMS() + ": " + s);
}


static String fileNameEncode_safeChars = " "; //" ()[]#";

static String fileNameEncode(String s) {
  s = dropLeadingDots(s); // don't produce file names starting with a dot!
  StringBuilder buf = new StringBuilder();
  int n = l(s);
  for (int i = 0; i < n; i++) {
    char c = s.charAt(i);
    if (contains(fileNameEncode_safeChars, c))
      buf.append(c);
    else
      buf.append(urlencode(str(c)));
  }
  return str(buf);
}


static long toLong(Object o) {
  if (o instanceof Number)
    return ((Number) o).longValue();
  if (o instanceof String)
    return parseLong((String) o);
  return 0;
}


static Map<String, String> mechMap(String listName) {
  return mechMapCI(listName);
}


static Set<String> hotwire_classesToShare = synchroSet();

static Set<String> hotwire_classesToShare() {
  return hotwire_classesToShare;
}


static ClassLoader myClassLoader() {
  return _getClass(mc()).getClassLoader();
}


static void setOptIfNotNull(Object o, String field, Object value) {
  if (value != null) setOpt(o, field, value);
}


static File loadBinarySnippet(String snippetID) {
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadLibrary(snippetID);
  
  
  return loadBinarySnippet_noResourceLoader(snippetID);
}
  
static File loadBinarySnippet_noResourceLoader(String snippetID) { try {
  long id = parseSnippetID(snippetID);
  if (isImageServerSnippet(id)) return loadImageAsFile(snippetID);
  File f = DiskSnippetCache_getLibrary(id);
  if (fileSize(f) == 0)
    f = loadDataSnippetToFile_noResourceLoader(snippetID);
  return f;
} catch (Exception __e) { throw rethrow(__e); } }


static boolean transpileRaw_silent = true;
static boolean transpileRaw_useDiskCache = false;




static Class transpileRaw_trans;
static boolean transpileRaw_mine = true;
static boolean transpileRaw_verySilent = false;
static boolean transpileRaw_dontCopyFromCreator = false;
static Lock transpileRaw_lock = lock();

static ThreadLocal<Boolean> transpileRaw_asInclude = new ThreadLocal();
static ThreadLocal<String> transpileRaw_progID = new ThreadLocal();

static String transpileRaw(String mainJava) {
  return transpileRaw(mainJava, false, transpileRaw_useDiskCache);
}

static String transpileRaw(String mainJava, boolean fragment) {
  return transpileRaw(mainJava, fragment, transpileRaw_useDiskCache);
}

static String transpileRaw(String mainJava, boolean fragment, boolean useDiskCache) {
  mainJava = dropTranslators(mainJava);
  if (!transpileRaw_dontCopyFromCreator)
    transpileRaw_copyFromCreator();
  Lock __0 = transpileRaw_lock; lock(__0); try {
  
  File cacheFile = null;
  if (useDiskCache) {
    cacheFile = new File(javaxCodeDir(), "Transpilations/" + uniqueFileNameUsingMD5_80_v2(mainJava) + ".java");
    { String __3 = loadTextFile(cacheFile); if (!empty(__3)) return __3; }
  }
  
   AutoCloseable __4 = transpileRaw_verySilent ? null : tempLoadingAnim("Transpiling..."); try {
  
  transpileRaw_translator();
 
  //setOpt(transpileRaw_trans, dontPrintSource := true);
  setOpt(transpileRaw_trans, "localStuffOnly" , fragment);
  setOpt(transpileRaw_trans, "asInclude" , isTrue(transpileRaw_asInclude.get()));
  setOpt(transpileRaw_trans, "mainSnippetID" , transpileRaw_progID.get());
  set(transpileRaw_trans, "mainJava", mainJava);
  // TODO: setOpt(transpileRaw_trans, transpilingSnippetID := );
  set(transpileRaw_trans, "print_byThread", print_byThread);
  if (!transpileRaw_verySilent)
    print("Running translator " + getOpt(transpileRaw_trans, "programID"));
  callMain(transpileRaw_trans);
  //print("Ran translator " + identityHashCode(transpileRaw_trans));
  String main =  (String) (get(transpileRaw_trans, "mainJava"));
  if (useDiskCache) {
    saveTextFile(new File(cacheFile.getPath() + "x"), mainJava);
    saveTextFile(cacheFile, main);
  }
  return main;
} finally { _close(__4); }} finally { unlock(__0); } }

static  IF0<Class> transpileRaw_translator;
static Class transpileRaw_translator() { return transpileRaw_translator != null ? transpileRaw_translator.get() : transpileRaw_translator_base(); }
final static Class transpileRaw_translator_fallback(IF0<Class> _f) { return _f != null ? _f.get() : transpileRaw_translator_base(); }
static Class transpileRaw_translator_base() {
  if (transpileRaw_trans == null) {
    //print("Loading translator.");
    transpileRaw_trans = transpileRaw_makeTranslator();
    transpileRaw_mine = true;
    makeDependent(transpileRaw_trans);
    //print("Loaded translator: " + identityHashCode(transpileRaw_trans));
  }
  setOpt(transpileRaw_trans, "print_silent", transpileRaw_silent);
  return transpileRaw_trans;
}

static  IF0<Class> transpileRaw_makeTranslator;
static Class transpileRaw_makeTranslator() { return transpileRaw_makeTranslator != null ? transpileRaw_makeTranslator.get() : transpileRaw_makeTranslator_base(); }
final static Class transpileRaw_makeTranslator_fallback(IF0<Class> _f) { return _f != null ? _f.get() : transpileRaw_makeTranslator_base(); }
static Class transpileRaw_makeTranslator_base() {
  return hotwireSharingLibraries_silently(defaultJavaXTranslatorID());
}

static void transpileRaw_copyFromCreator() {
  Lock __1 = transpileRaw_lock; lock(__1); try {
  if (transpileRaw_trans != null) return;
  Object c = creator();
  if (c == null) return;
  Class trans =  (Class) (getOpt(c, "transpileRaw_trans"));
  Lock lock =  (Lock) (getOpt(c, "transpileRaw_lock"));
  if (trans != null && lock != null) {
    print("Using creator's transpiler: " + getProgramID(c) + " => " + programID());
    transpileRaw_lock = lock;
    transpileRaw_trans = trans;
    transpileRaw_mine = false;
  }
} finally { unlock(__1); } }

static void cleanMeUp_transpileRaw() {
  if (transpileRaw_mine)
    cleanUp(transpileRaw_trans);
  transpileRaw_trans = null; // release proactively (it's big)
}



static <A> A printWithIndent(A o) {
  return printIndent(o);
}



static <A> A printWithIndent(String indent, A o) {
  return printIndent(indent, o);
}



static void printWithIndent(int indent, Object o) {
  printIndent(indent, o);
}


static File copyFile(File src, File dest) { try {
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
  return dest;
} catch (Exception __e) { throw rethrow(__e); } }


static File computerIDFile() {
  return javaxDataDir("Basic Info/computer-id.txt");
}


static boolean charactersEqualIC(char c1, char c2) {
  if (c1 == c2) return true;
  char u1 = Character.toUpperCase(c1);
  char u2 = Character.toUpperCase(c2);
  if (u1 == u2) return true;
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}



static String xltrim(String s) {
  int i = 0, n = l(s);
  while (i < n && contains(" \t\r\n", s.charAt(i)))
    ++i;
  return substr(s, i);
}


static boolean isLetterOrDigit(char c) {
  return Character.isLetterOrDigit(c);
}


// pred: char -> bool
static String takeCharsWhile(String s, Object pred) {
  int i = 0;
  while (i < l(s) && isTrue(callF(pred, s.charAt(i)))) ++i;
  return substring(s, 0, i);
}

static String takeCharsWhile(IF1<Character, Boolean> f, String s) {
  return takeCharsWhile(s, f);
}


static boolean isInstance(Class type, Object arg) {
  return type.isInstance(arg);
}


static Runnable asRunnable(Object o) {
  return toRunnable(o);
}




static void _inheritThreadInfo(Object info) {
  _threadInheritInfo(info);
}




static boolean isNonNegativeInteger(String s) {
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}


static boolean isLoopbackIP(String ip) {
  return eq(ip, "127.0.0.1");
}


static int myVMPort() {
  List records =  (List) (get(getJavaX(), "record_list"));
  Object android = last(records);
  return or0((Integer) get(android, "port"));
}


static String thisVMGreeting() {
  List record_list =  (List) (get(getJavaX(), "record_list"));
  Object android = first(record_list); // Should be of class Android3
  return getString(android, "greeting");
}


static String sendToThisVM_newThread(String s, Object... args) {
  final String _s = format(s, args);
  try {
    return (String) evalInNewThread(new F0<Object>() { public Object get() { try { 
      return callStaticAnswerMethod(getJavaX(), _s);
     } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "return callStaticAnswerMethod(getJavaX(), _s);"; }});
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    return str(e);
  }
}


static <A> A popFirst(List<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(0);
  return a;
}

static <A> A popFirst(Collection<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(a);
  return a;
}

static <A, B> Pair<A, B> popFirst(Map<A, B> map) {
  if (map == null) return null;
  var it = map.entrySet().iterator();
  if (!it.hasNext()) return null;
  var p = mapEntryToPair(it.next());
  it.remove();
  return p;
}

static <A> List<A> popFirst(int n, List<A> l) {
  List<A> part = cloneSubList(l, 0, n);
  removeSubList(l, 0, n);
  return part;
}

static <A> AppendableChain<A> popFirst(AppendableChain<A> a) {
  return a == null ? null : a.popFirst();
}


static String quickSubstring(String s, int i, int j) {
  if (i >= j) return "";
  return s.substring(i, j);
}


static Object safeUnstructure(String s) {
  return unstructure(s, true);
}

static Object safeUnstructure(File f) {
  return safeUnstructureGZFile(f);
}


static int parseHexChar(char c) {
  if (c >= '0' && c <= '9') return charDiff(c, '0');
  if (c >= 'a' && c <= 'f') return charDiff(c, 'a')+10;
  if (c >= 'A' && c <= 'F') return charDiff(c, 'A')+10;
  return -1;
}


// Use like this: renderVars(+x, +y)
// Or like this: renderVars("bla", +x, +y)
static String renderVars_str(Object... params) {
  List<String> l = new ArrayList();
  int i = 0;
  if (odd(l(params))) {
    l.add(strOrNull(first(params)));
    ++i;
  }
  for (; i+1 < l(params); i += 2)
    l.add(params[i] + "=" + params[i+1]);
  return trim(joinWithComma(l));
}


static Class getOuterClass(Class c) { return getOuterClass(c, null); }
static Class getOuterClass(Class c, Object classFinder) { try {
  String s = c.getName();
  int i = s.lastIndexOf('$');
  String name = substring(s, 0, i);
  return classForName(name, classFinder);
} catch (Exception __e) { throw rethrow(__e); } }

static Class getOuterClass(Object o) { return getOuterClass(o, null); }
static Class getOuterClass(Object o, Object classFinder) {
  return getOuterClass(_getClass(o), classFinder);
}


static HashMap<String, Field> instanceFieldsMap(Object o) {
  return (HashMap) getOpt_getFieldMap(o);
}





static Map<Class, Field[]> thisDollarOneFields_cache = newDangerousWeakHashMap();

static Field[] thisDollarOneFields(Class c) {
  synchronized(thisDollarOneFields_cache) {
    Field[] l = thisDollarOneFields_cache.get(c);
    if (l == null)
      thisDollarOneFields_cache.put(c, l = thisDollarOneFields_uncached(c));
    return l;
  }
}

static Field[] thisDollarOneFields_uncached(Class c) {
  List<Field> fields = new ArrayList();
  do {
    for (Field f : c.getDeclaredFields())
      if (f.getName().startsWith("this$"))
        fields.add(makeAccessible(f));
    c = c.getSuperclass();
  } while (c != null);
  return toArray(new Field[l(fields)], fields);
}




static Map<Class, HashMap<String, Method>> callOpt_noArgs_cache = newDangerousWeakHashMap();

static Object callOpt_noArgs(Object o, String method) { try {
  if (o == null) return null;
  if (o instanceof Class)
    return callOpt(o, method); // not optimized
  
  Class c = o.getClass();
  HashMap<String, Method> map;
  synchronized(callOpt_noArgs_cache) {
    map = callOpt_noArgs_cache.get(c);
    if (map == null)
      map = callOpt_noArgs_makeCache(c);
  }

  Method m = map.get(method);
  return m != null ? m.invoke(o) : null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
  HashMap<String, Method> map = new HashMap();
  Class _c = c;
  do {
    for (Method m : c.getDeclaredMethods())
      if (m.getParameterTypes().length == 0 
        && !reflection_isForbiddenMethod(m)) {
        makeAccessible(m);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  callOpt_noArgs_cache.put(c, map);
  return map;
}


static Class<?> getClass(String name) {
  return _getClass(name);
}

static Class getClass(Object o) {
  return _getClass(o);
}

static Class getClass(Object realm, String name) {
  return _getClass(realm, name);
}


static List<Object> getMultiPorts() {
  return (List) callOpt(getJavaX(), "getMultiPorts");
}


static String emptyToNull(String s) {
  return eq(s, "") ? null : s;
}

static <A, B> Map<A, B> emptyToNull(Map<A, B> map) {
  return empty(map) ? null : map;
}


// start multi-port if none exists in current VM.
static void startMultiPort() {
  List mp = getMultiPorts();
  if (mp != null && mp.isEmpty()) {
    nohupJavax("#1001639");
    throw fail("Upgrading JavaX, please restart this program afterwards.");
    //callMain(hotwire("#1001672"));
  }
}


static <A> Set<A> synchroTreeSet() {
  return Collections.synchronizedSet(new TreeSet<A>());
}

static <A> Set<A> synchroTreeSet(TreeSet<A> set) {
  return Collections.synchronizedSet(set);
}


static boolean forbiddenPort(int port) {
  return port == 5037; // adb
}



static String readLineHidden() { try {
  if (get(javax(), "readLine_reader") == null)
    set(javax(), "readLine_reader" , new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
  try {
    return ((BufferedReader) get(javax(), "readLine_reader")).readLine();
  } finally {
    consoleClearInput();
  }
} catch (Exception __e) { throw rethrow(__e); } }


static int indent_default = 2;

static String indent(int indent) {
  return repeat(' ', indent);
}

static String indent(int indent, String s) {
  return indent(repeat(' ', indent), s);
}

static String indent(String indent, String s) {
  return indent + replace(unnull(s), "\n", "\n" + indent);
}

static String indent(String s) {
  return indent(indent_default, s);
}

static List<String> indent(String indent, List<String> lines) {
  List<String> l = new ArrayList();
  if (lines != null) for (String s : lines)
    l.add(indent + s);
  return l;
}


static String getProgramName_cache;

static String getProgramName() {
  Lock __0 = downloadLock(); lock(__0); try {
  if (getProgramName_cache == null)
    getProgramName_cache = getSnippetTitleOpt(programID());
  return getProgramName_cache;
} finally { unlock(__0); } }

static void _onLoad_getProgramName() {
  { startThread(new Runnable() {  public void run() { try {  getProgramName(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "getProgramName();"; }}); }
}


static File localSnippetFile(long snippetID) {
  return localSnippetsDir(snippetID + ".text");
}

static File localSnippetFile(String snippetID) {
  return localSnippetFile(parseSnippetID(snippetID));
}


static File oneOfTheFiles(String... paths) {
  if (paths != null) for (String path : paths)
    if (fileExists(path))
      return newFile(path);
  return null;
}

static File oneOfTheFiles(File... files) {
  return oneOfTheFiles(asList(files));
}

static File oneOfTheFiles(Iterable<File> files) {
  if (files != null) for (File f : files)
    if (fileExists(f))
      return f;
  return null;
}


static String loadGZTextFile(File file) { try {
  if (!file.isFile()) return null;
  ping();
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
   InputStream fis = new FileInputStream(file); try {
  GZIPInputStream gis = newGZIPInputStream(fis);
  byte[] buffer = new byte[1024];
  int len;
  while ((len = gis.read(buffer)) != -1) baos.write(buffer, 0, len);
  baos.close();
  return fromUtf8(baos.toByteArray()); // TODO: use a Reader
} finally { _close(fis); }} catch (Exception __e) { throw rethrow(__e); } }


static File getCodeProgramDir() {
  return getCodeProgramDir(getProgramID());
}

static File getCodeProgramDir(String snippetID) {
  return new File(javaxCodeDir(), formatSnippetID(snippetID));
}

static File getCodeProgramDir(long snippetID) {
  return getCodeProgramDir(formatSnippetID(snippetID));
}


static void saveGZTextFile(File file, String contents) { saveGZTextFile(file, contents, "UTF-8"); }
static void saveGZTextFile(File file, String contents, String encoding) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  String tempFileName = file.getPath() + "_temp";
  File tempFile = new File(tempFileName);
  if (contents != null) {
    if (tempFile.exists()) try {
      String saveName = tempFileName + ".saved." + now();
      copyFile(tempFile, new File(saveName));
    } catch (Throwable e) { printStackTrace(e); }
    FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
    GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, encoding);
    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
    printWriter.print(contents);
    printWriter.close();
    gos.close();
    fileOutputStream.close();
  }
  
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (contents != null)
    if (!tempFile.renameTo(file))
      throw new IOException("Can't rename " + tempFile + " to " + file);
} catch (Exception __e) { throw rethrow(__e); } }




static String hmsWithColonsAndMS() {
  return hmsWithColonsAndMS(now());
}

static String hmsWithColonsAndMS(long time) {
  return simpleDateFormat_local("HH:mm:ss:SSSS").format(time);
}



static String dropLeadingDots(String s) {
  int i = 0;
  while (charAt(s, i) == '.') ++i;
  return dropFirst(s, i);
}



// name -> (name, parsed map)
static Map<String, Pair<String, Map<String, String>>> mechMapCI_cache = synchroMap();

static Map<String, String> mechMapCI(String listName) {
  Pair<String, Map<String, String>> p = mechMapCI_cache.get(listName);
  String text = mechList_raw(listName);
  if (p != null && eq(p.a, text)) return p.b;
  String parsing = first(mechList_opt(listName + " | Parsing"));
  Map<String, String> map;
  if (parsing == null)
    map = parseDoubleArrowMapCI(tlft(text));
  else
    
    
      map = asCIMap((Map<String, String>) callMC(parsing, text));
    
  p = pair(text, map);
  mechMapCI_cache.put(listName, p);
  return p.b;
}


static <A> Set<A> synchroSet() {
  return synchroHashSet();
}

static <A> Set<A> synchroSet(Set<A> set) {
  return Collections.synchronizedSet(set);
}


static boolean isImageServerSnippet(long id) {
  return id >= 1100000 && id < 1200000;
}



static File loadImageAsFile(String snippetIDOrURL) { try {
  if (isURL(snippetIDOrURL))
    throw fail("not implemented");

  if (!isSnippetID(snippetIDOrURL)) throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
  String snippetID = "" + parseSnippetID(snippetIDOrURL);
  
  File file = imageSnippetCacheFile(snippetID);
  if (fileSize(file) > 0) return file;

  String imageURL = snippetImageURL_noHttps(snippetID);
  System.err.println("Loading image: " + imageURL);
  byte[] data = loadBinaryPage(imageURL);

  saveBinaryFile(file, data);
  return file;
} catch (Exception __e) { throw rethrow(__e); } }



// If you change this, also change DiskSnippetCache_fileToLibID
static File DiskSnippetCache_file(long snippetID) {
  return new File(getGlobalCache(), "data_" + snippetID + ".jar");
}
  
// Data files are immutable, use centralized cache
public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
  File file = DiskSnippetCache_file(snippetID);
  return file.exists() ? file : null;
}

public static File DiskSnippetCache_getLibrary(String snippetID) { try {
  return DiskSnippetCache_getLibrary(psI(snippetID));
} catch (Exception __e) { throw rethrow(__e); } }

public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
  saveBinaryFile(DiskSnippetCache_file(snippetID), data);
}

static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
  byte[] data;
  try {
    URL url = new URL(dataSnippetLink(snippetID));
    print("Loading library: " + hideCredentials(url));
    try {
      data = loadBinaryPage(url.openConnection());
    } catch (RuntimeException e) {
      data = null;
    }
    
    if (data == null || data.length == 0) {
      url = new URL(tb_mainServer() + "/blobs/" + parseSnippetID(snippetID));
      print("Loading library: " + hideCredentials(url));
      data = loadBinaryPage(url.openConnection());
    }
    print("Bytes loaded: " + data.length);
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return data;
}


static long fileSize(String path) { return getFileSize(path); }
static long fileSize(File f) { return getFileSize(f); }



static File loadDataSnippetToFile(String snippetID) { try {
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.loadLibrary(snippetID);
  
  
  return loadDataSnippetToFile_noResourceLoader(snippetID);
} catch (Exception __e) { throw rethrow(__e); } }
  
static File loadDataSnippetToFile_noResourceLoader(String snippetID) { try {
  snippetID = fsI(snippetID);
  
  File f = DiskSnippetCache_file(parseSnippetID(snippetID));
  List<URL> urlsTried = new ArrayList();
  List<Throwable> errors = new ArrayList();
  try {
    URL url = addAndReturn(urlsTried, new URL(dataSnippetLink(snippetID)));
    print("Loading library: " + hideCredentials(url));
    try {
      loadBinaryPageToFile(openConnection(url), f);
      if (fileSize(f) == 0) throw fail();
    } catch (Throwable e) {
      errors.add(e);
      url = addAndReturn(urlsTried, new URL(tb_mainServer() + "/blobs/" + psI(snippetID)));
      print(e);
      print("Trying other server: " + hideCredentials(url));
      loadBinaryPageToFile(openConnection(url), f);
      print("Got bytes: " + fileSize(f));
    }
    // TODO: check if we hit the "LOADING" message
    if (fileSize(f) == 0) throw fail();
    System.err.println("Bytes loaded: " + fileSize(f));
  } catch (Throwable e) {
    //printStackTrace(e);
    errors.add(e);
    throw fail("Binary snippet " + snippetID + " not found or not public. URLs tried: " + allToString(urlsTried) + ", errors: " + allToString(errors));
  }
  return f;
} catch (Exception __e) { throw rethrow(__e); } }


static String dropTranslators(String src) {
  return findTranslators2(src, null);
}

// modifies original tok
static List<String> dropTranslators(List<String> tok) {
  return findTranslators2(tok, null);
}


static File javaxCodeDir_dir; // can be set to work on different base dir

static File javaxCodeDir() {
  return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
}

static File javaxCodeDir(String sub) {
  return newFile(javaxCodeDir(), sub);
}


static <A> AutoCloseable tempLoadingAnim(String msg) {
  return tempDisposeWindow(loadingAnim(msg));
}


static <A> A set(A o, String field, Object value) {
  if (o == null) return null;
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    makeAccessible(f);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
  return o;
}

static void set(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = set_findStaticField(c, field);
    makeAccessible(f);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static void set(BitSet bs, int idx) {
  { if (bs != null) bs.set(idx); }
}


static Object makeDependent_postProcess;

static void makeDependent(Object c) {
  if (c == null) return;
  assertTrue("Not a class", c instanceof Class);
  dependentClasses(); // cleans up the list
  hotwire_classes.add(new WeakReference(c));
  
  Object local_log = getOpt(mc(), "local_log");
  if (local_log != null)
    setOpt(c, "local_log", local_log);
    
  /*if (isTrue(getOpt(c, 'ping_actions_shareable)))
    setOpt(c, +ping_actions);*/
    
  Object print_byThread = getOpt(mc(), "print_byThread");
  if (print_byThread != null)
    setOpt(c, "print_byThread", print_byThread);
    
  callF(makeDependent_postProcess, c);
}



static Class<?> hotwireSharingLibraries_silently(String progID) {
   AutoCloseable __1 = temp_loadPage_silent(); try {
  return hotwireSharingLibraries(progID);
} finally { _close(__1); }}


static String defaultJavaXTranslatorID_value = "#759";

static String defaultJavaXTranslatorID() {
  return defaultJavaXTranslatorID_value;
}


static boolean cleanUp_interruptThreads = false; // experimental

static void cleanUp(Object c) {
  if (c == null) return;
  
  if (c instanceof AutoCloseable) { close_pcall((AutoCloseable) c); return; }
  
  if (c instanceof java.util.Timer) { ((java.util.Timer) c).cancel(); return; }
  
  if (c instanceof Collection) { cleanUp((Collection) c); return; }
  if (c instanceof Map) {
    for (Object o : keys((Map) c)) cleanUp(o);
    for (Object o : values((Map) c)) cleanUp(o);
    ((Map) c).clear();
    return;
  }
  //if (!(c instanceof Class)) ret;
  
  try {
    // revoke license
    
    preCleanUp(c);
    
    // unpause
    
    setOpt_raw(c, "ping_pauseAll", false);
    
    // call custom cleanMeUp() and cleanMeUp_*() functions
    
    innerCleanUp(c);
        
    // Java spec says finalize should only be called by GC,
    // but we care to differ.
    // Edit: Not anymore (illegal access warnings)
    /*if (isTrue(vmMap_get('callFinalize)))
      pcallOpt(c, "finalize");*/

    // remove all virtual bots (hope this works)
    
    List androids = (List) getOpt(c, "record_list");
    for (Object android : unnull(androids))
      pcallOpt(android, "dispose"); // heck we'll dispose anything

    // sub-cleanup
    
    List<WeakReference> classes =  (List<WeakReference>) (getOpt(c, "hotwire_classes"));
    if (classes != null)
      for (WeakReference cc : classes) { try {
        cleanUp(cc.get());
      } catch (Throwable __e) { printStackTrace(__e); }}
      
    // interrupt all threads (experimental, they might be doing cleanup?)
    
    if (cleanUp_interruptThreads) {
      List<Thread> threads = registeredThreads(c);
      if (nempty(threads)) {
        print("cleanUp: Interrupting " + n2(threads, "thread") + ": " + joinWithComma(allToString(threads)));
        interruptThreads(threads);
      }
    }
  } catch (Throwable __e) { printStackTrace(__e); }
  
  setOpt_raw(c, "cleaningUp_flag" , false);
  if (c instanceof Class && ((Class) c).getName().equals("main"))
    retireClassLoader(((Class) c).getClassLoader());
 }

static void cleanUp(Collection l) {
  if (l == null) return;
  for (Object c : l)
    cleanUp(c);
  l.clear();
}


static <A> A printIndent(A o) {
  print(indentx(str(o)));
  return o;
}

static <A> A printIndent(String indent, A o) {
  print(indentx(indent, str(o)));
  return o;
}

static void printIndent(int indent, Object o) {
  print(indentx(indent, str(o)));
}


static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }


static String substr(String s, int x) {
  return substring(s, x);
}

static String substr(String s, int x, int y) {
  return substring(s, x, y);
}




static Map<String, String> parseDoubleLeftArrowMapCI_tlft(String s) {
  return parseDoubleLeftArrowMapCI(tlft(s));
}


static boolean loadBufferedImage_useImageCache = true;

static BufferedImage loadBufferedImage(String snippetIDOrURLOrFile) { try {
  ping();
  if (snippetIDOrURLOrFile == null) return null;
  if (isURL(snippetIDOrURLOrFile))
    return imageIO_readURL(snippetIDOrURLOrFile);

  if (isSnippetID(snippetIDOrURLOrFile)) {
    String snippetID = "" + parseSnippetID(snippetIDOrURLOrFile);
    
    
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return loadBufferedImage(rl.loadLibrary(snippetID));
    
    
    File dir = imageSnippetsCacheDir();
    if (loadBufferedImage_useImageCache) {
      dir.mkdirs();
      File file = new File(dir, snippetID + ".png");
      if (file.exists() && file.length() != 0)
        try {
          return ImageIO.read(file);
        } catch (Throwable e) {
          e.printStackTrace();
          // fall back to loading from sourceforge
        }
    }
  
    String imageURL = snippetImageURL_http(snippetID);
    print("Loading image: " + imageURL);
    BufferedImage image = imageIO_readURL(imageURL);
  
    if (loadBufferedImage_useImageCache) {
      File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
      ImageIO.write(image, "png", tempFile);
      tempFile.renameTo(new File(dir, snippetID + ".png"));
      //Log.info("Cached image.");
    }
  
    //Log.info("Loaded image.");
    return image;
  } else
    return loadBufferedImage(new File(snippetIDOrURLOrFile));
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedImage loadBufferedImage(File file) {
  return loadBufferedImageFile(file);
}


static int or0(Integer i) { return i == null ? 0 : i; }
static long or0(Long l) { return l == null ? 0L : l; }
static double or0(Double d) { return d == null ? 0.0 : d; }


static Object evalInNewThread(final Object f) {
  final Flag flag = new Flag();
  final Var var = new Var();
  final Var<Throwable> exception = new Var();
  { startThread(new Runnable() {  public void run() { try {  try {
      var.set(callF(f));
    } catch (Throwable e) {
      exception.set(e);
    }
    flag.raise();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "try {\r\n      var.set(callF(f));\r\n    } catch (Throwable e) {\r\n      exception..."; }}); }
  flag.waitUntilUp();
  if (exception.has()) throw rethrow(exception.get());
  return var.get();
}


static Object safeUnstructureGZFile(File f) { try {
  if (!fileExists(f)) return null;
  BufferedReader reader = utf8BufferedReader(gzInputStream(f));
  return unstructure_tok(javaTokC_noMLS_onReader(reader), true, null);
} catch (Exception __e) { throw rethrow(__e); } }


static int charDiff(char a, char b) {
  return (int) a-(int) b;
}

static int charDiff(String a, char b) {
  return charDiff(stringToChar(a), b);
}


static boolean reflection_isForbiddenMethod(Method m) {
  return m.getDeclaringClass() == Object.class
    && eqOneOf(m.getName(), "finalize", "clone", "registerNatives");
}


static void nohupJavax(final String javaxargs) {
  { startThread(new Runnable() {  public void run() { try {  call(hotwireOnce("#1008562"), "nohupJavax", javaxargs); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs);"; }}); }
}

static void nohupJavax(final String javaxargs, final String vmArgs) {
  { startThread(new Runnable() {  public void run() { try {  call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "call(hotwireOnce(\"#1008562\"), \"nohupJavax\", javaxargs, vmArgs);"; }}); }
}


static void consoleClearInput() {
  consoleSetInput("");
}


static Lock downloadLock_lock = fairLock();

static Lock downloadLock() {
  return downloadLock_lock;
}


static String getSnippetTitleOpt(String s) {
  try {
    return isSnippetID(s) ? getSnippetTitle(s) : s;
  } catch (Throwable __e) { printStackTrace(__e); }
  return s;
}


static File localSnippetsDir() {
  return javaxDataDir("Personal Programs");
}

static File localSnippetsDir(String sub) {
  return newFile(localSnippetsDir(), sub);
}


static boolean fileExists(String path) {
  return path != null && new File(path).exists();
}

static boolean fileExists(File f) {
  return f != null && f.exists();
}


static String fromUtf8(byte[] bytes) { try {
  return bytes == null ? null : new String(bytes, utf8charset());
} catch (Exception __e) { throw rethrow(__e); } }


static ExpiringMap2<String, String> mechList_raw_cache = new ExpiringMap2(10000).setMap(ciMap());
static Lock mechList_raw_lock = lock();

// timeout for loading
static int mechList_raw_timeout = 60000;

static String mechList_raw(String name) { try {
  Lock __0 = mechList_raw_lock; lock(__0); try {
  
  if (empty(name)) return "";
  
  // get from cache
  String src = mechList_raw_cache.get(name);
  if (src != null) return src;
  
  // load & put in cache - TODO: make postPage honor this
  //temp tempSetThreadLocal(loadPage_forcedTimeout_byThread, mechList_raw_timeout);
  src = mechList_raw_fresh(name);
  if (src != null)
    mechList_raw_cache.put(name, src);
  return src;
} finally { unlock(__0); } } catch (Exception __e) { throw rethrow(__e); } }

static void _onLoad_mechList_raw() {
  ownResource(vmBus_onMessage("mechChange", 
    listName -> mechList_raw_cache.remove((String) listName)));
}


static Map<String, String> parseDoubleArrowMapCI(List<String> l) {
  return parseDoubleArrowMap((Map) ciMap(), l);
}

static Map<String, String> parseDoubleArrowMapCI(String s) {
  return parseDoubleArrowMapCI_tlft(s);
}


static <B> TreeMap<String, B> asCIMap(Map<String, B> map) {
  return asCaseInsensitiveMap(map);
}


static boolean isURL(String s) {
  return startsWithOneOf(s, "http://", "https://", "file:");
}


static File imageSnippetCacheFile(String snippetID) {
  File dir = imageSnippetsCacheDir();
  
  if (!loadBufferedImage_useImageCache) return null;
  
  return new File(dir, parseSnippetID(snippetID) + ".png");
}


static String snippetImageURL_noHttps(String snippetID) {
  return snippetImageURL_noHttps(snippetID, "png");
}

static String snippetImageURL_noHttps(String snippetID, String contentType) {
  return snippetImageURL(snippetID, contentType)
    .replace("https://www.botcompany.de:8443/", "http://www.botcompany.de:8080/")
    .replace("https://botcompany.de/", "http://botcompany.de/");
}


static ThreadLocal<Map<String, List<String>>> loadBinaryPage_responseHeaders = new ThreadLocal();
static ThreadLocal<Map<String, String>> loadBinaryPage_extraHeaders = new ThreadLocal();

static byte[] loadBinaryPage(String url) { try {
  print("Loading " + url);
  return loadBinaryPage(loadPage_openConnection(new URL(url)));
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage(URLConnection con) { try {
  Map<String, String> extraHeaders = getAndClearThreadLocal(loadBinaryPage_extraHeaders);
  setHeaders(con);
  for (String key : keys(extraHeaders))
    con.setRequestProperty(key, extraHeaders.get(key));
  return loadBinaryPage_noHeaders(con);
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage_noHeaders(URLConnection con) { try {
  ByteArrayOutputStream buf = new ByteArrayOutputStream();
  InputStream inputStream = con.getInputStream();
  loadBinaryPage_responseHeaders.set(con.getHeaderFields());
  long len = 0;
  try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
int n = 0;
  while (true) {
    int ch = inputStream.read();
    if (ch < 0)
      break;
    buf.write(ch);
    if (++n % 100000 == 0)
      println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
  }
  inputStream.close();
  return buf.toByteArray();
} catch (Exception __e) { throw rethrow(__e); } }



/** writes safely (to temp file, then rename) */
public static byte[] saveBinaryFile(String fileName, byte[] contents) { try {
  File file = new File(fileName);
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  String tempFileName = fileName + "_temp";
  FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
  fileOutputStream.write(contents);
  fileOutputStream.close();
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + fileName);

  if (!new File(tempFileName).renameTo(file))
    throw new IOException("Can't rename " + tempFileName + " to " + fileName);
    
  
  vmBus_send("wroteFile", file);
  
  return contents;
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] saveBinaryFile(File fileName, byte[] contents) {
  return saveBinaryFile(fileName.getPath(), contents);
}


static String dataSnippetLink(String snippetID) {
  long id = parseSnippetID(snippetID);
  if (id >= 1100000 && id < 1200000)
    return imageServerURL() + id;
  if (id >= 1200000 && id < 1300000) { // Woody files, actually
    String pw = muricaPassword();
    if (empty(pw)) throw fail("Please set 'murica password by running #1008829");
    return "https://botcompany.de/files/" + id + "?_pass=" + pw; // XXX, although it typically gets hidden when printing
  }
  return fileServerURL() + "/" + id /*+ "?_pass=" + muricaPassword()*/;
}


static <B, A extends B> A addAndReturn(Collection<B> c, A a) {
  if (c != null) c.add(a);
  return a;
}


static void loadBinaryPageToFile(String url, File file) { try {
  print("Loading " + url);
  loadBinaryPageToFile(openConnection(new URL(url)), file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile(URLConnection con, File file) { try {
  setHeaders(con);
  loadBinaryPageToFile_noHeaders(con, file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) { try {
  File ftemp = new File(f2s(file) + "_temp");
  FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
  try {
    InputStream inputStream = con.getInputStream();
    long len = 0;
    try { len = con.getContentLength/*Long*/(); } catch (Throwable e) { printStackTrace(e); }
    String pat = "  {*}" + (len != 0 ? "/" + len : "") + " bytes loaded.";
    copyStreamWithPrints(inputStream, buf, pat);
    inputStream.close();
    buf.close();
    file.delete();
    renameFile_assertTrue(ftemp, file);
  } finally {
    if (buf != null) buf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }



static List<String> allToString(Iterable c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}

static List<String> allToString(Object[] c) {
  List<String> l = new ArrayList();
  for (Object o : unnull(c)) l.add(str(o));
  return l;
}


static <A> AutoCloseable tempDisposeWindow(final Window w) {
  return new AutoCloseable() {
    public void close() {
      disposeWindow(w);
    }
  };
}


static JWindow loadingAnim() {
  return showLoadingAnimation();
}

static JWindow loadingAnim(String text) {
  return showLoadingAnimation(text);
}


static List<Class> dependentClasses() {
  return cleanUpAndGetWeakReferencesList(hotwire_classes);
}


static AutoCloseable temp_loadPage_silent() {
  return tempSetThreadLocal(loadPage_silent, true);
}


static Class<?> hotwireSharingLibraries(String progID) { try {
  Pair<File, String> p = CompilerBot.compileSnippet2(progID);
  File jar = p.a;
  assertTrue(f2s(jar), jar.isFile());
  
  // collect files (program + libraries)
  
  List<File> files = ll(jar);
  String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
  
  List<File> myLibraries = myLibraryFiles();
  //print("My libraries: " + myLibraries);
  
  Matcher matcher = Pattern.compile("\\d+").matcher(dehlibs);
  while (matcher.find()) {
    String libID = matcher.group();
    File lib = loadLibrary(libID);
    if (myLibraries.contains(lib)) {
      //print("Skipping lib " + lib);
    } else {
      //print("Adding lib " + lib);
      files.add(lib);
    }
  }

  // make class loader
  JavaXClassLoaderWithParent classLoader = new JavaXClassLoaderWithParent(progID, files, myClassLoader());
  
  return hotwire_finish(classLoader, progID, p.b);
} catch (Exception __e) { throw rethrow(__e); } }


static void close_pcall(AutoCloseable c) {
  if (c != null) { try { c.close(); } catch (Throwable __e) { printStackTrace(__e); }}
}


static void preCleanUp(Object c) {
  if (c instanceof Collection) { for (Object o : ((Collection) c)) preCleanUp(o); return; }
  callOpt(c, "licensed_off");
  setOpt_raw(c, "ping_anyActions" , true); // so ping notices
  setOpt_raw(c, "cleaningUp_flag" , true);
}


static void innerCleanUp(Object c) {
  // call custom cleanMeUp() and cleanMeUp_*() functions
  
  if (!isFalse(pcallOpt(c, "cleanMeUp")))
    for (String name : sorted(methodsStartingWith(c, "cleanMeUp_"))) try {
      callOpt(c, name);
    } catch (Throwable e) {
      print("Error cleaning up: " + programID(c));
      _handleException(e);
    }
}

static void innerCleanUp() {
  innerCleanUp(mc());
}


static Object pcallOpt(Object o, String method, Object... args) {
  try { return callOpt(o, method, args); } catch (Throwable __e) { printStackTrace(__e); }
  return null;
}


static List<Thread> registeredThreads(Object o) {
  Map<Thread, Boolean> map =  (Map<Thread, Boolean>) (getOpt(o, "_registerThread_threads"));
  if (map == null) return ll();
  map.size(); // force clean-up
  synchronized(map) { return asList(keys(map)); }
}

static List<Thread> registeredThreads() {
  _registerThread_threads.size(); // force clean-up
  return asList(keys(_registerThread_threads));
}


static void interruptThreads(Collection<Thread> threads) {
  for (Thread t : unnull(threads))
    interruptThread(t);
}

static void interruptThreads(Class mainClass) {
  interruptThreads(registeredThreads(mainClass));
}


static void retireClassLoader(ClassLoader cl) {
  if (isJavaXClassLoader(cl))
    setOptAll(cl, "retired" , true, "retiredMarker" , new DefunctClassLoader());
}





static List<WeakReference<Class>> hotwire_classes = synchroList();

static Class<?> hotwireDependent(String src) {
  Class c = hotwire(src);
  makeDependent(c);
  return c;
}



static Map<String, String> parseDoubleLeftArrowMapCI(List<String> l) {
  return parseDoubleLeftArrowMap((Map) ciMap(), l);
}


static BufferedImage imageIO_readURL(String url) { try {
  return ImageIO.read(new URL(url));
} catch (Exception __e) { throw rethrow(__e); } }



static File imageSnippetsCacheDir() {
  return javaxCachesDir("Image-Snippets");
}


static String snippetImageURL_http(String snippetID) {
  return snippetImageURL_http(snippetID, "png");
}

static String snippetImageURL_http(String snippetID, String contentType) {
  return replacePrefix("https://", "http://", snippetImageURL(snippetID, contentType)).replace(":8443", ":8080");
}


static BufferedImage loadBufferedImageFile(File file) { try {
  return isFile(file) ? ImageIO.read(file) : null;
} catch (Exception __e) { throw rethrow(__e); } }


static BufferedReader utf8BufferedReader(InputStream in) {
  return utf8bufferedReader(in);
}

static BufferedReader utf8BufferedReader(File f) {
  return utf8bufferedReader(f);
}


static char stringToChar(String s) {
  if (l(s) != 1) throw fail("bad stringToChar: " + s);
  return firstChar(s);
}


static Class hotwireOnce(String programID) {
  return hotwireCached(programID, false);
}


static void consoleSetInput(final String text) {
  
    if (headless()) return;
    setTextAndSelectAll(consoleInputField(), text);
    focusConsole();
  
}


static String getSnippetTitle(String id) {
  if (id == null) return null;
  if (!isSnippetID(id)) return "?";
  
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return rl.getSnippetTitle(id);
  
  
  return getSnippetTitle_noResourceLoader(id);
}
  
static String getSnippetTitle_noResourceLoader(String id) { try {
  if (isLocalSnippetID(id)) return localSnippetTitle(id);
  long parsedID = parseSnippetID(id);
  String url;
  if (isImageServerSnippet(parsedID))
    url = imageServerURL() + "title/" + parsedID + muricaCredentialsQuery();
  else if (isGeneralFileServerSnippet(parsedID))
    url = "http://butter.botcompany.de:8080/files/name/" + parsedID;
  else
    url = tb_mainServer() + "/tb-int/getfield.php?id=" + parsedID + "&field=title" + standardCredentials_noCookies();
  String title = trim(loadPageSilently(url));
  if (title != null)
    try { saveTextFileIfChanged(snippetTitle_cacheFile(id), title); } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
  return or(title, "?");
} catch (Exception __e) { throw rethrow(__e); } }

static String getSnippetTitle(long id) {
  return getSnippetTitle(fsI(id));
}



static String mechList_raw_fresh(String name) {
  return mechList_opt_raw_fresh(name);
}


static Map<String, String> parseDoubleArrowMap(Map<String, String> map, List<String> l) {
  for (String s : l) {
    List<String> x = splitAtDoubleArrow_bothDirections(s);
    if (l(x) == 2) map.put(first(x), second(x));
  }
  return map;
}


static Map<String, String> parseDoubleArrowMapCI_tlft(String s) {
  return parseDoubleArrowMapCI(tlft(s));
}


static <B> TreeMap<String, B> asCaseInsensitiveMap(Map<String, B> map) {
  if (isCIMap(map)) return (TreeMap) map;
  TreeMap<String, B> m = ciMap();
  putAll(m, map);
  return m;
}


static String snippetImageURL(long snippetID) {
  return snippetImageURL(fsI(snippetID));
}

static String snippetImageURL(String snippetID) {
  return snippetImageURL(snippetID, "png");
}

static String snippetImageURL(String snippetID, String contentType) {
  if (snippetID == null || isURL(snippetID)) return snippetID;
  long id = parseSnippetID(snippetID);
  String url;
  if (isImageServerSnippet(id))
    url = imageServerLink(id);
  else
    //url = "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id + "&contentType=image/" + contentType;
    url = "https://botcompany.de/img/" + id;
  return url;
}


static <A> A println(A a) {
  return print(a);
}


static String imageServerURL() {
  return or2(trim(loadTextFile(javaxDataDir("image-server-url.txt"))), "http://botcompany.de/images/raw/");
}


static volatile boolean muricaPassword_pretendNotAuthed = false;

static String muricaPassword() {
  if (muricaPassword_pretendNotAuthed) return null;
  return trim(loadTextFile(muricaPasswordFile()));
}


static String fileServerURL() {
  return "https://botcompany.de/files";
}


public static File mkdirsFor(File file) {
  return mkdirsForFile(file);
}



static void copyStreamWithPrints(InputStream in, OutputStream out, String pat) { try {
  byte[] buf = new byte[65536];
  int total = 0;
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
    if ((total+n)/100000 > total/100000)
      print(pat.replace("{*}", str(roundDownTo(100000, total))));
    total += n;
  }
} catch (Exception __e) { throw rethrow(__e); } }


static File renameFile_assertTrue(File a, File b) { try {
  if (a.equals(b)) return b; // no rename necessary
  if (!a.exists()) throw fail("Source file not found: " + f2s(a));
  if (b.exists()) throw fail("Target file exists: " + f2s(b));
  mkdirsForFile(b);
  
  
  if (!a.renameTo(b))
    throw fail("Can't rename " + f2s(a) + " to " + f2s(b));
  
  return b;
} catch (Exception __e) { throw rethrow(__e); } }


static void disposeWindow(final Window window) {
  if (window != null) { swing(() -> { 
    window.dispatchEvent(new WindowEvent(window, WindowEvent.WINDOW_CLOSING)); // call listeners
    myFrames_list.remove(window);
    window.dispose();
  }); }
}

static void disposeWindow(final Component c) {
  disposeWindow(getWindow(c));
}

static void disposeWindow(Object o) {
  if (o != null) disposeWindow(((Component) o));
}

static void disposeWindow() {
  disposeWindow(heldInstance(Component.class));
}


static JWindow showLoadingAnimation() {
  return showLoadingAnimation("Hold on user...");
}

static JWindow showLoadingAnimation(String text) { try {
  return showAnimationInTopRightCorner("#1003543", text);
} catch (Throwable __e) { return null; } }


static <A> List<A> cleanUpAndGetWeakReferencesList(List<WeakReference<A>> l) {
  if (l == null) return null;
  synchronized(l) {
    List<A> out = new ArrayList();
    for (int i = 0; i < l(l); i++) {
      A a = l.get(i).get();
      if (a == null)
        l.remove(i--);
      else
        out.add(a);
    }
    return out;
  }
}


static String loadTextFileFromZip(File inZip, String fileName) {
  return loadTextFileFromZipFile(inZip, fileName);
}


static List<File> myLibraryFiles() {
  Collection<File> files =  (Collection<File>) (getOpt(myClassLoader(), "files"));
  if (files != null) return asList(files);
  return ll(getBytecodePathForClass(mc()));
}


static Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource) {
  return hotwire_finish(classLoader, progID, javaSource, "main");
}

static Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource, String mainClass) { try {
  // load & return main class
  Class<?> theClass = classLoader.loadClass(mainClass);
  
  Class j = getJavaX();
  
  setOpt(theClass, "myJavaSource_code", javaSource);
  
  synchronized(j) { // hopefully this goes well...
    call(j, "setVars", theClass, progID);
    callOpt(j, "addInstance", progID, theClass);
  }
  
  hotwire_copyOver(theClass);
  vmBus_send("hotwireFinished", theClass, mc());
  return theClass;
} catch (Exception __e) { throw rethrow(__e); } }


static <A> List<A> sorted(Collection<A> c, Object comparator) {
  List<A> l = cloneList(c);
  sort(l, makeComparator(comparator));
  return l;
}

static <A> List<A> sorted(Collection<A> c) {
  List<A> l = cloneList(c);
  sort(l);
  return l;
}

static <A> List<A> sorted(Comparator<A> comparator, Collection<A> c) {
  List<A> l = cloneList(c);
  sort(l, comparator);
  return l;
}


static List<String> methodsStartingWith(Object o, final String prefix) {
  return filter(allMethodNames(o), new F1<String, Object>() { public Object get(String s) { try {  return startsWith(s, prefix);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "startsWith(s, prefix)"; }});
}


static volatile PersistableThrowable _handleException_lastException;
static List _handleException_onException = synchroList(ll((IVF1<Throwable>) (__1 -> printStackTrace2(__1))));
static boolean _handleException_showThreadCancellations = false;

static void _handleException(Throwable e) {
  _handleException_lastException = persistableThrowable(e);
  
  Throwable e2 = innerException(e);
  if (e2.getClass() == RuntimeException.class && eq(e2.getMessage(), "Thread cancelled.") || e2 instanceof InterruptedException) {
    if (_handleException_showThreadCancellations)
      System.out.println(getStackTrace_noRecord(e2));
    return;
  }

  for (Object f : cloneList(_handleException_onException)) try {
    callF(f, e);
  } catch (Throwable e3) {
    try {
      printStackTrace2(e3); // not using pcall here - it could lead to endless loops
    } catch (Throwable e4) {
      System.out.println(getStackTrace(e3));
      System.out.println(getStackTrace(e4));
    }
  }
}


static boolean interruptThread_verbose = false;

static void interruptThread(Thread t) {
  if (t == null) return;
  if (interruptThread_verbose) print("Interrupting thread " + t);
  
  // note reason in global map
  
  vm_threadInterruptionReasonsMap().put(t, getStackTrace());
  
  t.interrupt();
  URLConnection c =  (URLConnection) (vm_generalSubMap("URLConnection per thread").get(t));
  if (c != null) { try {
    print("Closing URLConnection of interrupted thread.");
    call(c, "disconnect");
  } catch (Throwable __e) { printStackTrace(__e); }}
}


static boolean isJavaXClassLoader(ClassLoader cl) {
  return startsWithOneOf(className(cl), "main$JavaXClassLoader", "x30$JavaXClassLoader");
}


static void setOptAll(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    setOpt/*_flex*/(o, field, fields.get(field));
}

static void setOptAll(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    setOpt(o, field, value);
  }
}




static Map<JFrame, Boolean> myFrames_list = weakHashMap();

static List<JFrame> myFrames() {
  return swing(new F0<List<JFrame>>() { public List<JFrame> get() { try {  return keysList(myFrames_list);  } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "return keysList(myFrames_list);"; }});
}



static Map<String, String> parseDoubleLeftArrowMap(Map<String, String> map, List<String> l) {
  for (String s : l) {
    List<String> x = splitAtDoubleLeftArrow(s);
    if (l(x) == 2) map.put(second(x), first(x));
  }
  return map;
}


static boolean isFile(File f) {
  return f != null && f.isFile();
}

static boolean isFile(String path) {
  return isFile(newFile(path));
}


static char firstChar(String s) {
  return s.charAt(0);
}


static TreeMap<String, Class> hotwireCached_cache = new TreeMap();
static Lock hotwireCached_lock = lock();

static Class hotwireCached(String programID) {
  return hotwireCached(programID, true);
}

static Class hotwireCached(String programID, boolean runMain) {
  return hotwireCached(programID, runMain, false);
}

static Class hotwireCached(String programID, boolean runMain, boolean dependent) {
  Lock __0 = hotwireCached_lock; lock(__0); try {
  
  programID = formatSnippetID(programID);
  Class c = hotwireCached_cache.get(programID);
  if (c == null) {
    c = hotwire(programID);
    if (dependent)
      makeDependent(c);
    if (runMain)
      callMain(c);
    hotwireCached_cache.put(programID, c);
  }
  return c;
} finally { unlock(__0); } }


static boolean headless() {
  return isHeadless();
}


static JTextField setTextAndSelectAll(final JTextField tf, final String text) {
  if (tf != null) { swing(() -> { 
    tf.setText(text);
    tf.selectAll();
  }); }
  return tf;
}


static JTextField consoleInputField() {
  Object console = get(getJavaX(), "console");
  return (JTextField) getOpt(console, "tfInput");
}


static void focusConsole(String s) {
  setConsoleInput(s);
  focusConsole();
}

static void focusConsole() {
  JComponent tf = consoleInputFieldOrComboBox();
  if (tf != null) {
    //print("Focusing console");
    tf.requestFocus();
  }
}


static String localSnippetTitle(String snippetID) {
  if (!isLocalSnippetID(snippetID)) return null;
  File f = localSnippetFile(snippetID);
  if (!f.exists()) return null;
  return or2(getFileInfoField(dropExtension(f), "Title"), "Unnamed");
}


static String muricaCredentialsQuery() {
  return htmlQuery(muricaCredentials());
}


static boolean isGeneralFileServerSnippet(long id) {
  return id >= 1400000 && id < 1500000;
}


static boolean saveTextFileIfChanged(File f, String contents) {
  return saveTextFileIfDifferent(f, contents);
}


static File snippetTitle_cacheFile(String snippetID) {
  return javaxCachesDir("Snippet Titles/" + psI(snippetID));
}


static List<String> splitAtDoubleArrow_bothDirections(String s) {
  return splitAtDoubleArrow_bothDirections(javaTok(s));
}

static List<String> splitAtDoubleArrow_bothDirections(List<String> tok) {
  List<String> l = splitAtDoubleArrow(tok);
  if (l(l) != 2) l = reversedList(splitAtDoubleLeftArrow(tok));
  return l;
}


static boolean isCIMap(Map m) {
  return m instanceof TreeMap && ((TreeMap) m).comparator() == caseInsensitiveComparator();
}


static String imageServerLink(String md5OrID) {
  if (possibleMD5(md5OrID))
    return "https://botcompany.de/images/md5/" + md5OrID;
  return imageServerLink(parseSnippetID(md5OrID));
}

static String imageServerLink(long id) {
  return "https://botcompany.de/images/" + id;
}


static File muricaPasswordFile() {
  return new File(javaxSecretDir(), "murica/muricaPasswordFile");
}


// TODO: optimize to x-(x%n) in case that's the same thing
// (or x-mod(x,n)?)
static int roundDownTo(int n, int x) {
  return x/n*n;
}

static long roundDownTo(long n, long x) {
  return x/n*n;
}


static Window getWindow(Object o) {
  if (!(o instanceof Component)) return null;
  return swing(() -> {
    Component c =  (Component) o;
    while (c != null) {
      if (c instanceof Window) return ((Window) c);
      c = c.getParent();
    }
    return null;
  });
}


static <A> A heldInstance(Class<A> c) {
  List<Object> l = holdInstance_l.get();
  for (int i = l(l)-1; i >= 0; i--) {
    Object o = l.get(i);
    if (isInstanceOf(o, c))
      return (A) o;
  }
  throw fail("No instance of " + className(c) + " held");
}


static boolean showAnimationInTopRightCorner_alwaysOnTop = true;
static boolean showAnimationInTopRightCorner_on = true;

// automatically switches to AWT thread for you
// text is optional text below image
static JWindow showAnimationInTopRightCorner(String imageID, String text) {
  if (isHeadless() || !showAnimationInTopRightCorner_on) return null;
  return showAnimationInTopRightCorner(imageIcon(imageID), text);
}

static JWindow showAnimationInTopRightCorner(final Image image, final String text) {
  if (image == null || isHeadless() || !showAnimationInTopRightCorner_on) return null;
  return showAnimationInTopRightCorner(imageIcon(image), text);
}

static JWindow showAnimationInTopRightCorner(final ImageIcon imageIcon, final String text) {
  if (isHeadless() || !showAnimationInTopRightCorner_on) return null;
  return (JWindow) swingAndWait(new F0<Object>() { public Object get() { try { 
    JLabel label = new JLabel(imageIcon);
    if (nempty(text)) {
      label.setText(text);
      label.setVerticalTextPosition(SwingConstants.BOTTOM);
      label.setHorizontalTextPosition(SwingConstants.CENTER);
    }
    final JWindow window = showInTopRightCorner(label);
    onClick(label, new Runnable() {  public void run() { try {  window.dispose() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "window.dispose()"; }});
    if (showAnimationInTopRightCorner_alwaysOnTop)
      window.setAlwaysOnTop(true);
    return window;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JLabel label = new JLabel(imageIcon);\r\n    if (nempty(text)) {\r\n      label.s..."; }});
}

static JWindow showAnimationInTopRightCorner(final String imageID) {
  return showAnimationInTopRightCorner(imageID, "");
}

static JWindow showAnimationInTopRightCorner(String imageID, double seconds) {
  return showAnimationInTopRightCorner(imageID, "", seconds);
}

static JWindow showAnimationInTopRightCorner(String imageID, String text, double seconds) {
  if (isHeadless()) return null;
  return disposeWindowAfter(iround(seconds*1000), showAnimationInTopRightCorner(imageID, text));
}

static JWindow showAnimationInTopRightCorner(BufferedImage img, String text, double seconds) {
  return disposeWindowAfter(iround(seconds*1000), showAnimationInTopRightCorner(img, text));
}



static String loadTextFileFromZipFile(File inZip, String fileName) { try {
  if (!fileExists(inZip)) return null;
  try {
     ZipFile zip = new ZipFile(inZip); try {
    return loadTextFileFromZipFile(zip, fileName);
  } finally { _close(zip); }} catch (Throwable e) {
    throw fail(f2s(inZip), e);
  }
} catch (Exception __e) { throw rethrow(__e); } }
    
static String loadTextFileFromZipFile(ZipFile zip, String fileName) { try {
  ZipEntry entry = zip.getEntry(fileName);
  if (entry == null) return null;
   InputStream fin = zip.getInputStream(entry); try {
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
  copyStream(fin, baos);
  return fromUTF8(baos.toByteArray());
} finally { _close(fin); }} catch (Exception __e) { throw rethrow(__e); } }


static File getBytecodePathForClass(Object o) {
  return getBytecodePathForClass(_getClass(o));
}

static File getBytecodePathForClass(Class c) { try {
  return c == null ? null : new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
} catch (Exception __e) { throw rethrow(__e); } }


static Comparator makeComparator(final Object f) {
  if (f instanceof Comparator) return (Comparator) f;
  return new Comparator() {
    public int compare(Object a, Object b) {
      return (Integer) callF(f, a, b);
    }
  };
}



static List<String> allMethodNames(Object o) {
  Class c = _getClass(o);
  TreeSet<String> names = new TreeSet();
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      names.add(m.getName());
    c = c.getSuperclass();
  }
  return asList(names);
}


static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}



static Throwable innerException(Throwable e) {
  return getInnerException(e);
}




static ThreadLocal<List<Object>> holdInstance_l = new ThreadLocal();

static AutoCloseable holdInstance(Object o) {
  if (o == null) return null;
  listThreadLocalAdd(holdInstance_l, o);
  return new AutoCloseable() {
    public void close() {
      listThreadLocalPopLast(holdInstance_l);
    }
  };
}


static <A, B> Map<A, B> weakHashMap() {
  return newWeakHashMap();
}


static <A, B> List<A> keysList(Map<A, B> map) {
  return cloneListSynchronizingOn(keys(map), map);
}


  static <A> List<A> keysList(MultiSet<A> ms) {
    return ms == null ? null : keysList(ms.map);
  }



static List<String> splitAtDoubleLeftArrow(String s) {
  return splitAtDoubleLeftArrow(javaTok(s));
}

static List<String> splitAtDoubleLeftArrow(List<String> tok) {
  List<String> l = new ArrayList();
  int i = 0;
  while (i < l(tok)) {
    int j = indexOfSubList(tok, ll("<", "", "="), i);
    if (i >= l(tok)) break;
    if (j < 0) j = l(tok);
    l.add(trimJoin(tok.subList(i, j)));
    i = j+3;
  }
  return l;
}


static void setConsoleInput(String text) {
  consoleSetInput(text);
}


static JComponent consoleInputFieldOrComboBox() {
  Object console = get(getJavaX(), "console");
  JComboBox cb =  (JComboBox) (getOpt(console, "cbInput"));
  if (cb != null) return cb;
  return (JTextField) getOpt(console, "tfInput");
}


static String getFileInfoField(File f, String field) {
  return getOneLineFileInfoField(f, field);
}


static File dropExtension(File f) {
  return f == null ? null : fileInSameDir(f, dropExtension(f.getName()));
}

static String dropExtension(String s) {
  return takeFirst(s, smartLastIndexOf(s, '.'));
}


static String htmlQuery(Map params) {
  return empty(params) ? "" : "?" + makePostData(params);
}

static String htmlQuery(Object... data) {
  return empty(data) ? "" : "?" + makePostData(data);
}


static Object[] muricaCredentials() {
  String pass = muricaPassword();
  return nempty(pass) ? new Object[] {"_pass", pass } : new Object[0];
}


static boolean saveTextFileIfDifferent(File f, String contents) {
  if (eq(loadTextFile(f), contents)) return false; // TODO: optimize
  { saveTextFile(f, contents); return true; }
}


static List<String> splitAtDoubleArrow(String s) {
  return splitAtDoubleArrow(javaTok(s));
}

static List<String> splitAtDoubleArrow(List<String> tok) {
  List<String> l = new ArrayList();
  int i = 0;
  while (i < l(tok)) {
    int j = indexOfSubList(tok, splitAtDoubleArrow_tok(), i);
    if (j < 0) j = l(tok);
    l.add(trimJoin(tok.subList(i, j)));
    i = j+3;
  }
  return l;
}


static <A> List<A> reversedList(Iterable<A> l) {
  List<A> x = cloneList(l);
  Collections.reverse(x);
  return x;
}


static boolean possibleMD5(String s) { return isMD5(s); }


static boolean isInstanceOf(Object o, Class type) {
  return type.isInstance(o);
}


static int imageIcon_cacheSize = 10;
static boolean imageIcon_verbose = false;
static Map<String, ImageIcon> imageIcon_cache;
static Lock imageIcon_lock = lock();
static ThreadLocal<Boolean> imageIcon_fixGIF = new ThreadLocal();

// not going through BufferedImage preserves animations
static ImageIcon imageIcon(String imageID) { try {
  if (imageID == null) return null;
  Lock __0 = imageIcon_lock; lock(__0); try {
  if (imageIcon_cache == null)
    imageIcon_cache = new MRUCache(imageIcon_cacheSize);
  imageID = fsI(imageID);
  ImageIcon ii = imageIcon_cache.get(imageID);
  if (ii == null) {
    if (imageIcon_verbose) print("Loading image icon: " + imageID);
    File f = loadBinarySnippet(imageID);
    
      Boolean b = imageIcon_fixGIF.get();
      if (!isFalse(b))
        ii = new ImageIcon(loadBufferedImageFixingGIFs(f));
      else
    
    ii = new ImageIcon(f.toURI().toURL());
  } else
    imageIcon_cache.remove(imageID); // move to front of cache on access
  imageIcon_cache.put(imageID, ii);
  return ii;
} finally { unlock(__0); } } catch (Exception __e) { throw rethrow(__e); } }

// doesn't fix GIFs
static ImageIcon imageIcon(File f) { try {
  return new ImageIcon(f.toURI().toURL());
} catch (Exception __e) { throw rethrow(__e); } }

static ImageIcon imageIcon(Image img) {
  return img == null ? null : new ImageIcon(img);
}




static JWindow showInTopRightCorner(Component c) {
  return swing(() -> {
    JWindow w = new JWindow();
    w.add(c);
    w.pack();
    moveToTopRightCorner(w);
    w.setVisible(true);
    return w;
  });
}


static <A extends JComponent> A onClick(final A c, final Object runnable) {
  if (c != null) { swing(() -> { 
    c.addMouseListener(new MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        callF(runnable, e);
      }
    });
  }); }
  return c;
}

// re-interpreted for buttons
static void onClick(JButton btn, final Object runnable) {
  onEnter(btn, runnable);
}


static <A extends Window> A disposeWindowAfter(int delay, final A w) {
  if (w != null)
    swingLater(delay, new Runnable() {  public void run() { try { 
      w.dispose();
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "w.dispose();"; }});
  return w;
}

static <A extends Window> A disposeWindowAfter(A w, double seconds) {
  return disposeWindowAfter(toMS_int(seconds), w);
}

static <A extends Window> A disposeWindowAfter(double seconds, A w) {
  return disposeWindowAfter(w, seconds);
}


static String fromUTF8(byte[] bytes) {
  return fromUtf8(bytes);
}


static String getStackTrace2(Throwable e) {
  return hideCredentials(getStackTrace(unwrapTrivialExceptionWraps(e)) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ",
    hideCredentials(str(innerException2(e)))) + "\n");
}




static <A> void listThreadLocalAdd(ThreadLocal<List<A>> tl, A a) {
  List<A> l = tl.get();
  if (l == null) tl.set(l = new ArrayList());
  l.add(a);
}


static <A> A listThreadLocalPopLast(ThreadLocal<List<A>> tl) {
  List<A> l = tl.get();
  if (l == null) return null;
  A a = popLast(l);
  if (empty(l)) tl.set(null);
  return a;
}


static <A> ArrayList<A> cloneListSynchronizingOn(Collection<A> l, Object mutex) {
  if (l == null) return new ArrayList();
  synchronized(mutex) {
    return new ArrayList<A>(l);
  }
}


static String trimJoin(List<String> s) {
  return trim(join(s));
}


static String getOneLineFileInfoField(File f, String field) {
  File infoFile = associatedInfosFile(f);
  List<String> lines = lines(loadTextFile(infoFile));
  return firstStartingWithIC_drop(lines, field + ": ");
}


static File fileInSameDir(File f, String newName) {
  return newFile(parentFile(f), newName);
}


static int smartLastIndexOf(String s, char c) {
  if (s == null) return 0;
  int i = s.lastIndexOf(c);
  return i >= 0 ? i : l(s);
}

static <A> int smartLastIndexOf(List<A> l, A sub) {
  int i = lastIndexOf(l, sub);
  return i < 0 ? l(l) : i;
}


static List<String> splitAtDoubleArrow_tok;

static List<String> splitAtDoubleArrow_tok() {
  // initialize on demand to allow use in static initializers
  if (splitAtDoubleArrow_tok == null)
    splitAtDoubleArrow_tok = ll("=", "", ">");
  return splitAtDoubleArrow_tok;
}







static boolean loadBufferedImageFixingGIFs_debug = false;
static ThreadLocal<Var<byte[]>> loadBufferedImageFixingGIFs_output = new ThreadLocal();

static Image loadBufferedImageFixingGIFs(File file) { try {
  if (!file.exists()) return null;

  // Load anything but GIF the normal way
  if (!isGIF(file))
    return ImageIO.read(file);
    
  if (loadBufferedImageFixingGIFs_debug) print("loadBufferedImageFixingGIFs" + ": checking gif");

  // Get GIF reader
  ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
  // Give it the stream to decode from
  reader.setInput(ImageIO.createImageInputStream(file));

  int numImages = reader.getNumImages(true);

  // Get 'metaFormatName'. Need first frame for that.
  IIOMetadata imageMetaData = reader.getImageMetadata(0);
  String metaFormatName = imageMetaData.getNativeMetadataFormatName();

  // Find out if GIF is bugged
  boolean foundBug = false;
  for (int i = 0; i < numImages && !foundBug; i++) {
      // Get metadata
      IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree(metaFormatName);

      // Find GraphicControlExtension node
      int nNodes = root.getLength();
      for (int j = 0; j < nNodes; j++) {
          org.w3c.dom.Node node = root.item(j);
          if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
              // Get delay value
              String delay = ((IIOMetadataNode)node).getAttribute("delayTime");

              // Check if delay is bugged
              if (Integer.parseInt(delay) == 0) {
                  foundBug = true;
              }

              break;
          }
      }
  }

  if (loadBufferedImageFixingGIFs_debug) print("loadBufferedImageFixingGIFs" + ": " + f2s(file) + " foundBug=" + foundBug);
  
  // Load non-bugged GIF the normal way
  Image image;
  if (!foundBug) {
    image = Toolkit.getDefaultToolkit().createImage(f2s(file));
  } else {
    // Prepare streams for image encoding
    ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
    {
       ImageOutputStream ios = ImageIO.createImageOutputStream(baoStream); try {
      // Get GIF writer that's compatible with reader
      ImageWriter writer = ImageIO.getImageWriter(reader);
      // Give it the stream to encode to
      writer.setOutput(ios);

      writer.prepareWriteSequence(null);

      for (int i = 0; i < numImages; i++) {
          // Get input image
          BufferedImage frameIn = reader.read(i);

          // Get input metadata
          IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree(metaFormatName);

          // Find GraphicControlExtension node
          int nNodes = root.getLength();
          for (int j = 0; j < nNodes; j++) {
              org.w3c.dom.Node node = root.item(j);
              if (node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) {
                  // Get delay value
                  String delay = ((IIOMetadataNode)node).getAttribute("delayTime");

                  // Check if delay is bugged
                  if (Integer.parseInt(delay) == 0) {
                      // Overwrite with a valid delay value
                      ((IIOMetadataNode)node).setAttribute("delayTime", "10");
                  }

                  break;
              }
          }

          // Create output metadata
          IIOMetadata metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(frameIn), null);
          // Copy metadata to output metadata
          metadata.setFromTree(metadata.getNativeMetadataFormatName(), root);

          // Create output image
          IIOImage frameOut = new IIOImage(frameIn, null, metadata);

          // Encode output image
          writer.writeToSequence(frameOut, writer.getDefaultWriteParam());
      }

      writer.endWriteSequence();
    } finally { _close(ios); }}

    // Create image using encoded data
    byte[] data = baoStream.toByteArray();
    setVar(loadBufferedImageFixingGIFs_output.get(), data);
    if (loadBufferedImageFixingGIFs_debug) print("Data size: " + l(data));
    image = Toolkit.getDefaultToolkit().createImage(data);
  }

  return image;
} catch (Exception __e) { throw rethrow(__e); } }




static int moveToTopRightCorner_inset = 20;

static <A extends Component> A moveToTopRightCorner(A a) {
  return moveToTopRightCorner(moveToTopRightCorner_inset, moveToTopRightCorner_inset, a);
}

static <A extends Component> A moveToTopRightCorner(int insetX, int insetY, A a) {
  { swing(() -> { 
    Window w = getWindow(a);
    if (w != null) {
      var bounds = preferredScreenBounds();
      w.setLocation(bounds.x2()-w.getWidth()-insetX, bounds.y1()+insetY);
    }
  }); }
  return a;
}



static JTextField onEnter(JTextField tf, JButton btn) {
  if (btn != null)
    onEnter(tf, new Runnable() {  public void run() { try {  clickButton(btn) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "clickButton(btn)"; }});
  return tf;
}

static JTextField onEnter(JTextField tf, Object action) {
  if (action == null || tf == null) return tf;
  tf.addActionListener(new java.awt.event.ActionListener() { public void actionPerformed(java.awt.event.ActionEvent _evt) { try {
    tf.selectAll();
    callF(action);
  } catch (Throwable __e) { messageBox(__e); }}});
  return tf;
}

static JButton onEnter(JButton btn, final Object action) {
  if (action == null || btn == null) return btn;
  btn.addActionListener(actionListener(action));
  return btn;
}

static JList onEnter(JList list, Object action) {
  list.addKeyListener(enterKeyListener(rCallOnSelectedListItem(list, action)));
  return list;
}

static JComboBox onEnter(final JComboBox cb, Runnable action) {
  { swing(() -> { 
    if (cb.isEditable()) {
      JTextField text = (JTextField) cb.getEditor().getEditorComponent();
      onEnter(text, action);
    } else {
      cb.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
      cb.getActionMap().put("enter", abstractAction("", new Runnable() {  public void run() { try {  cb.hidePopup(); callF(action); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "cb.hidePopup(); callF(action);"; }}));
    }
  }); }
  return cb;
}

static JTable onEnter(final JTable table, final Object action) {  
  table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
    .put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Enter");
    
  table.getActionMap().put("Enter", new AbstractAction() {
    public void actionPerformed(ActionEvent e) {
      callF(action, table.getSelectedRow());
    }
  });
  return table;
}

/*static JTextArea onEnter(final JTextArea ta, fO action) {
  addKeyListener(ta, enterKeyListener(action));
  ret ta;
}*/

static JTextField onEnter(Runnable action, JTextField tf) {
  return onEnter(tf, action);
}


static void swingLater(long delay, final Object r) {
  javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(wrapAsActivity(r)));
  timer.setRepeats(false);
  timer.start();
}

static void swingLater(Object r) {
  SwingUtilities.invokeLater(toRunnable(r));
}



static Throwable unwrapTrivialExceptionWraps(Throwable e) {
  if (e == null) return e;
  while (e.getClass() == RuntimeException.class
    && e.getCause() != null && eq(e.getMessage(), str(e.getCause())))
    e = e.getCause();
  return e;
}


static Throwable innerException2(Throwable e) {
  if (e == null) return null;
  while (empty(e.getMessage()) && e.getCause() != null)
    e = e.getCause();
  return e;
}




static File associatedInfosFile(File f) {
  return replaceExtension(f, ".infos");
}


static String firstStartingWithIC_drop(Collection<String> l, final String prefix) {
  for (String s : unnull(l))
    if (swic(s, prefix))
      return substring(s, l(prefix));
  return null;
}

static String firstStartingWithIC_drop(String prefix, Collection<String> l) {
  return firstStartingWithIC_drop(l, prefix);
}


static File parentFile(File f) {
  return dirOfFile(f);
}


static byte[] isGIF_magic = bytesFromHex("47494638"); // Actual signature is longer, but we're lazy

static boolean isGIF(byte[] data) {
  return byteArrayStartsWith(data, isGIF_magic);
}

static boolean isGIF(File f) {
  return isGIF(loadBeginningOfBinaryFile(f, l(isGIF_magic)));
}


static <A> void setVar(IVar<A> v, A value) {
  if (v != null) v.set(value);
}

static <A> IVF1<A> setVar(IVar<A> v) {
  return a -> { if (v != null) v.set(a); };
}


static Rect preferredScreenBounds() {
  return screenBounds_safe(preferredScreen());
}


static void clickButton(final JButton b) {
  if (b != null) { swing(() -> { 
    if (b.isEnabled())
      b.doClick();
  }); }
}


static void messageBox(final String msg) {
  print(msg);
  { swing(() -> { 
    JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
  }); }
}

static void messageBox(Throwable e) {
  //showConsole();
  printStackTrace(e);
  messageBox(hideCredentials(innerException2(e)));
}


static ActionListener actionListener(final Object runnable) {
  return actionListener(runnable, null);
}

static ActionListener actionListener(final Object runnable, final Object instanceToHold) {
  if (runnable instanceof ActionListener) return (ActionListener) runnable;
  final Object info = _threadInfo();
  return new java.awt.event.ActionListener() { public void actionPerformed(java.awt.event.ActionEvent _evt) { try {
    _threadInheritInfo(info);
     AutoCloseable __1 = holdInstance(instanceToHold); try {
    pcallF(runnable);
  } finally { _close(__1); }} catch (Throwable __e) { messageBox(__e); }}};
}


static KeyListener enterKeyListener(final Object action) {
  return new KeyAdapter() {
    public void keyPressed(KeyEvent ke) {
      if (ke.getKeyCode() == KeyEvent.VK_ENTER)
        pcallF(action);
    }
  };
}


static Runnable rCallOnSelectedListItem(final JList list, final Object action) {
  return new Runnable() {  public void run() { try {  pcallF(action, getSelectedItem(list)) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "pcallF(action, getSelectedItem(list))"; }};
}


static AbstractAction abstractAction(String name, final Object runnable) {
  return new AbstractAction(name) {
    public void actionPerformed(ActionEvent evt) {
      pcallF(runnable);
    }
  };
}




static File replaceExtension(File f, String extOld, String extNew) {
  return newFile(replaceExtension(f2s(f), extOld, extNew));
}

static File replaceExtension(File f, String extNew) {
  return replaceExtension(f, fileExtension(f), extNew);
}

static String replaceExtension(String s, String extOld, String extNew) {
  s = dropSuffixIC(addPrefixOptIfNempty(".", extOld), s);
  return s + addPrefixOptIfNempty(".", extNew);
}

static String replaceExtension(String name, String extNew) {
  return replaceExtension(name, fileExtension(name), extNew);
}


static File dirOfFile(File f) {
  return f == null ? null : f.getParentFile();
}


static byte[] bytesFromHex(String s) {
  return hexToBytes(s);
}


static boolean byteArrayStartsWith(byte[] a, byte[] b) {
  if (a == null || b == null) return false;
  if (a.length < b.length) return false;
  for (int i = 0; i < b.length; i++)
    if (a[i] != b[i])
      return false;
  return true;
}


static byte[] loadBeginningOfBinaryFile(File file, int maxBytes) {
  return loadBinaryFilePart(file, 0, maxBytes);
}


static Rect screenBounds_safe(int iScreen) {
  return screenBounds(min(iScreen, screenCount()-1));
}


static  IF0<Integer> preferredScreen;
static int preferredScreen() { return preferredScreen != null ? preferredScreen.get() : preferredScreen_base(); }
final static int preferredScreen_fallback(IF0<Integer> _f) { return _f != null ? _f.get() : preferredScreen_base(); }
static int preferredScreen_base() {
  return 0;
}


static String getSelectedItem(JList l) {
  return (String) l.getSelectedValue();
}

static String getSelectedItem(JComboBox cb) {
  return strOrNull(cb.getSelectedItem());
}




static String fileExtension(File f) {
  if (f == null) return null;
  return fileExtension(f.getName());
}

static String fileExtension(String s) {
  return substring(s, smartLastIndexOf(s, '.'));
}


static String dropSuffixIC(String suffix, String s) {
  return s == null ? null : ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}


static String addPrefixOptIfNempty(String prefix, String s) {
  return addPrefixIfNotEmpty2(prefix, s);
}


static byte[] loadBinaryFilePart(File file, long start, long end) { try {
  RandomAccessFile raf = new RandomAccessFile(file, "r");
  int n = toInt(min(raf.length(), end-start));
  byte[] buffer = new byte[n];
  try {
    raf.seek(start);
    raf.readFully(buffer, 0, n);
    return buffer;
  } finally {
    raf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }


static Rect screenBounds(GraphicsDevice screen) {
  return screen == null ? null : toRect(screen.getDefaultConfiguration().getBounds());
}

static Rect screenBounds(int iScreen) {
  return screenBounds(get(screenDevices(), iScreen));
}


static int screenCount() {
  return l(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices());
}




static String addPrefixIfNotEmpty2(String prefix, String s) {
  return empty(s) ? "" : addPrefix(prefix, s);
}


static List<GraphicsDevice> screenDevices() {
  return asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices());
}




static abstract class VF1<A> implements IVF1<A> {
  public abstract void get(A a);
}
// Meta - a "minimal" approach to adding meta-level to Java objects

static class Meta implements IMeta {
  
// Meta - a "minimal" approach to adding meta-level to Java objects
// (implementing the interface IMeta)

// We allocate one extra field for each Java object to make it
// reasoning-compatible (reasoning-compatible = extensible with
// fields of any name at runtime).
//
// We couldn't go for 0 extra fields (meta values must be linked
// directly from the object) and there are no half fields in
// Java... so there you go.
//
// Also, if you don't use any meta data, you are probably not
// reasoning about anything. The point of reasoning in JavaX is
// to attach information to objects directly used in the program.

// Possible information contained in the meta field:
//   Origin, destination, security level, sender, cost center,
//   purpose, list of reifications, ...

// So here it is. THE FIELD YOU HAVE BEEN WAITING FOR!

// [We also have IMeta to retrofit foreign classes (rare but
// probably useful).]

//////////////////////
// The "meta" field //
//////////////////////

// Generic meta value of any kind, but the typical case is it's a
// Map with extra field values for the object etc.
// "meta" is volatile to avoid synchronization; but you can also synchronize on
// _tempMetaMutex() which is usually the object itself. Collections
// and maps are exempt from using the collections's monitor as the meta
// mutex because their monitor tends to be held for long operations
// (e.g. cloneList). For those we use a substantially more complex
// algorithm using a weakMap. Probably overkill. I may reconsider.

volatile Object meta;

// The meta field is not transient, thus by default it will be
// persisted like anything else unless you customize your object
// to suppress or modulate this.

// ...and the interface methods

public void _setMeta(Object meta) { this.meta = meta; }
public Object _getMeta() { return meta; }

// MOST functions are implemented in IMeta (default implementations)

// Scaffolding convenience functions

final boolean scaffolding(){ return scaffoldingEnabled(); }
boolean scaffoldingEnabled() { return main.scaffoldingEnabled(this); }
boolean scaffoldingEnabled(Object o) { return main.scaffoldingEnabled(o); }
}
static abstract class VF2<A, B> {
  abstract void get(A a, B b);
}
static class SingleThread {
  boolean running = false;
  Thread thread;
  
  void run(Object r) { go(r); }
  
  synchronized boolean go(final Object runnable) {
    if (running) return false;
    running = true;
    thread = startThread("Single Thread", new Runnable() {  public void run() { try { 
      try {
        callF(runnable);
      } finally {
        _done();
      }
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "try {\r\n        callF(runnable);\r\n      } finally {\r\n        _done();\r\n      }"; }});
    return true;
  }
  
  synchronized void _done() {
    running = false;
    thread = null;
  }
  
  synchronized boolean running() { return running; }
  
  synchronized Thread getThread() { return thread; }
}
static class Var<A> implements IVar<A>, ISetter<A> {
  Var() {}
  Var(A v) {
  this.v = v;}

  
  
  A v; // you can access this directly if you use one thread
  
  public synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  public synchronized A get() { return v; }
  public synchronized boolean has() { return v != null; }
  public void clear() { set(null); }

public String toString() { return str(this.get()); }
}
static class DefunctClassLoader {}
static interface ITokCondition {
  boolean get(List<String> tok, int i); // i = N Index
}
static abstract class TokCondition implements ITokCondition {
  public abstract boolean get(List<String> tok, int i); // i = N Index
}
// In the newest pinging system (with flag PingV3), a ping source
// is the object that "allows" some code to run.
// When that code calls ping(), the ping source's action (if defined)
// is triggered.

// This allows randomly interrupting code execution, for example.

static class PingSource {
  // returns true if it slept
   final public PingSource setAction(IF0<Boolean> action){ return action(action); }
public PingSource action(IF0<Boolean> action) { this.action = action; return this; }  final public IF0<Boolean> getAction(){ return action(); }
public IF0<Boolean> action() { return action; }
volatile IF0<Boolean> action;
  
  // optional description of this ping source
  String text;
  
  // optional thread pool that this ping source likes to run in
  ThreadPool threadPool;
  
  PingSource() {}
  PingSource(ThreadPool threadPool) {
  this.threadPool = threadPool;}
  PingSource(ThreadPool threadPool, String text) {
  this.text = text;
  this.threadPool = threadPool;}
  PingSource(IF0<Boolean> action) {
  this.action = action;}

  // returns true if it slept
  final boolean get() {
    var a = action;
    return a != null && a.get();
  }
  
  final void ping() { 
    var a = action;
    if (a != null) a.get();
  }
  
  void cancel() {
    action = new Cancelled();
  }
  
  class Cancelled implements IF0<Boolean> {
    public Boolean get() { throw new PingSourceCancelledException(PingSource.this); }
  }
  
  class Encapsulated implements Runnable , IFieldsToList{
  Runnable r;
  Encapsulated() {}
  Encapsulated(Runnable r) {
  this.r = r;}public Object[] _fieldsToList() { return new Object[] {r}; }

    public void run() { try {
      //System.out.println("Encapsulated running: " + r);
      try {
        pingSource_tl().set(PingSource.this);
        //System.out.println("Ping source set");
        ping();
        r.run();
        //System.out.println("Done running");
      } finally {
        //System.out.println("Finally");
        pingSource_tl().set(null);
      }
    } catch (Exception __e) { throw rethrow(__e); } }
    
    public String toString() { return PingSource.this + ": " + r; }
  }
  
  void dO(Runnable r) {
    if (r == null) return;
    threadPool.acquireThreadOrQueue(new Encapsulated(r));
  }
  
  public String toString() { String t = text; return nempty(t) ? t : super.toString(); }
  
  ISleeper_v2 sleeper() { return threadPool.sleeper(); }
}
// A database system for only slightly modified Java objects.

// Recent changes:
// -minimal crash recovery disabled for now (could reenable)
// -idCounter.structure file no longer used
// -allDynamic/safeLoad disabled, it doesn't really make any sense
// -conceptsFile can be in any directory now

// Functions that should always be there for child processes:
static int concepts_internStringsLongerThan = 10;

static ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

// BREAKING CHANGE 2021/6/7 set to true
static boolean concepts_unlistedByDefault = true; // true = we can create instances of concepts with "new" without registering them automatically

interface IConceptIndex {
  void update(Concept c); // also for adding
  void remove(Concept c);
}

interface IFieldIndex<A extends Concept, Val> {
  Collection<A> getAll(Val val);
  List<Val> allValues(); // returns a cloned list
  MultiSet<Val> allValues_multiSet();
  IterableIterator<A> objectIterator();
}

// Approach to persisting the Concepts object itself (in normal
// DB operation, this is not done): For simplification, speed and
// compactness, we make almost all the fields transient and store only // the concepts and the idCounter. To unstructure the Concepts object,
// use unstructureConcepts() or postUnstructureConcepts(), then
// re-set up any indices, listeners etc.

// base class indicating nothing
static class ConceptsChange {}

// change of a single concept
static class ConceptCreate extends ConceptsChange implements IFieldsToList{
  Concept c;
  ConceptCreate() {}
  ConceptCreate(Concept c) {
  this.c = c;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + c + ")"; }

public boolean equals(Object o) {
if (!(o instanceof ConceptCreate)) return false;
    ConceptCreate __3 =  (ConceptCreate) o;
    return eq(c, __3.c);
}

  public int hashCode() {
    int h = -1751266972;
    h = boostHashCombine(h, _hashCode(c));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {c}; }
}

// change of a single concept
static class ConceptChange extends ConceptsChange implements IFieldsToList{
  Concept c;
  ConceptChange() {}
  ConceptChange(Concept c) {
  this.c = c;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + c + ")"; }

public boolean equals(Object o) {
if (!(o instanceof ConceptChange)) return false;
    ConceptChange __4 =  (ConceptChange) o;
    return eq(c, __4.c);
}

  public int hashCode() {
    int h = -1760609256;
    h = boostHashCombine(h, _hashCode(c));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {c}; }
}

// removal of a single concept
// c.id is going to become 0 at some point, so we pass the
// id separately
static class ConceptDelete extends ConceptsChange implements IFieldsToList{
  static final String _fieldOrder = "id c";
  long id;
  Concept c;
  ConceptDelete() {}
  ConceptDelete(long id, Concept c) {
  this.c = c;
  this.id = id;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + id + ", " + c + ")"; }

public boolean equals(Object o) {
if (!(o instanceof ConceptDelete)) return false;
    ConceptDelete __5 =  (ConceptDelete) o;
    return id == __5.id && eq(c, __5.c);
}

  public int hashCode() {
    int h = -1734431213;
    h = boostHashCombine(h, _hashCode(id));
    h = boostHashCombine(h, _hashCode(c));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {id, c}; }
}

// unknown change anywhere in concepts; consider it all dirty
// (this one should not be used except for batch jobs)
static class FullChange extends ConceptsChange implements IFieldsToList{
  FullChange() {}
  public String toString() { return shortClassName_dropNumberPrefix(this); }

public boolean equals(Object o) {
return o instanceof FullChange;
}

  public int hashCode() {
    int h = 733452095;
    return h;
  }
  public Object[] _fieldsToList() { return null; }
}

static class Concepts implements AutoCloseable {
  SortedMap<Long, Concept> concepts = synchroTreeMap();
  long idCounter;
  
  transient HashMap<Class, Object> perClassData;
  transient Map miscMap; // don't use directly, call miscMap... methods to access
  
  // set to "-" for non-persistent (possibly not implemented)
  // also, can include a case ID ("#123/1")
  // TODO: phase out (we have conceptsFile field now)
  transient String programID;
  transient File conceptsFile;
  
  transient Concepts parent; // new mechanism
  transient volatile long changes, changesWritten, lastChange;
  transient volatile java.util.Timer autoSaver;
  transient volatile boolean dontSave = false;
  transient volatile boolean savingConcepts, noXFullGrab;
  transient boolean vmBusSend = true;
  transient boolean initialSave = false; // set to false to avoid initial useless saving
  transient int autoSaveInterval = -1000; // 1 second + wait logic
  transient boolean useGZIP = true, quietSave;
  transient ReentrantLock lock = new ReentrantLock(true);
  transient ReentrantLock saverLock = new ReentrantLock(true);
  transient long lastSaveTook = -1, lastSaveWas, loadTook, uncompressedSize;
  transient float maxAutoSavePercentage = 10;
  transient List<IConceptIndex> conceptIndices;
  transient Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;
  transient Map<Class<? extends Concept>, Map<String, IFieldIndex>> ciFieldIndices;
  //transient L saveActions = synchroList();
  transient List<Runnable> preSave;
  transient Object classFinder = _defaultClassFinder();
  transient List onAllChanged = synchroList(); // list of runnables
  transient Set<IVF1> onChange = new HashSet();
  transient Object saveWrapper; // VF1<Runnable>, to profile saving
  transient boolean modifyOnCreate = false; // set _modified == created initially
  transient boolean modifyOnBackRef = false; // set modified if back refs change
  transient boolean useFileLock = true; // instead of locking by bot
  // OLD - not done anymore. transient bool collectForwardRefs
  transient FileBasedLock fileLock;
  transient boolean storeBaseClassesInStructure = false; // helps with schema evolution when concept subclasses disappear
  transient boolean useBackRefsForSearches = false; // assume backRefs are sane in order to speed up searches
  transient boolean defunct = false;
  transient int newBackupEveryXMinutes = 60;
  
  // add more fields for Concepts here
  
  Concepts() {}
  Concepts(String programID) {
  this.programID = programID;}
  Concepts(File conceptsFile) {
  this.conceptsFile = conceptsFile;}
  
  synchronized long internalID() {
    do {
      ++idCounter;
    } while (hasConcept(idCounter));
    return idCounter;
  }
  
  synchronized HashMap<Class, Object> perClassData() {
    if (perClassData == null) perClassData = new HashMap();
    return perClassData;
  }
  
  void initProgramID() {
    if (programID == null)
      programID = getDBProgramID();
  }
  
  // load from structure
  Concepts load(String structure) { return load(structure, false); }
Concepts load(String structure, boolean allDynamic) {
    clearConcepts();
    Map<Long, Concept> map = unstructureMap(structure, allDynamic, classFinder);
    concepts.putAll(map);
    assignConceptsToUs();
    calcIdCounter();
    return this;
  }
  
  Concepts load() {
    initProgramID();
    
    // try custom grabber
    Object dbGrabber = miscMapGet("dbGrabber");
    if (dbGrabber != null && !isFalse(callF(dbGrabber)))
      return this;

    try {
      if (tryToGrab()) return this;
    } catch (Throwable e) {
      if (!exceptionMessageContains(e, "no xfullgrab"))
        printShortException(e);
      print("xfullgrab failed - loading DB of " + programID + " from disk");
    }
    return loadFromDisk();
  }
  
  Concepts loadFromDisk() {
    if (nempty(concepts)) clearConcepts();
    
    // minimal crash recovery (disabled for now)
    //restoreLatestBackupIfConceptsFileEmpty(programID, doIt := true);

    long time = now();
    Map<Long, Concept> _concepts =  (Map<Long, Concept>) (unstructureGZFile(conceptsFile(), toIF1(classFinder)));
    putAll(concepts, _concepts);
    assignConceptsToUs();
    loadTook = now()-time;
    done("Loaded " + n2(l(concepts), "concept"), time);
    calcIdCounter();
    return this;
  }
  
  Concepts loadConcepts() { return load(); }
  
  boolean tryToGrab() {
    if (sameSnippetID(programID, getDBProgramID())) return false;
     RemoteDB db = connectToDBOpt(programID); try {
    if (db != null) {
      loadGrab(db.fullgrab());
      return true;
    }
    return false;
  } finally { _close(db); }}
  
  Concepts loadGrab(String grab) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      Map<Long, Concept> map = (Map) unstructure(grab, false, classFinder);
      concepts.putAll(map);
      assignConceptsToUs();
      for (long l : map.keySet())
        idCounter = max(idCounter, l);
    } finally {
      DynamicObject_loading.set(null);
    }
    //XXX allChanged(); // Nobody is listening at this point anyway
    return this;
  }
  
  void assignConceptsToUs() {
    // fix unstructure bugs
    
    for (Pair<Long, Object> p: mapToPairs((Map<Long, Object>) (Map) concepts))
      if (!(p.b instanceof Concept)) {
       print("DROPPING non-existant concept " + p.a + ": " + dynShortName(p.b));
       concepts.remove(p.a);
    }
    
    for (Concept c : values(concepts)) c._concepts = this;
    for (Concept c : values(concepts))
      c._doneLoading2(); // doneLoading2 is called on all concepts after all concepts are loaded
  }

  String progID() {
    return programID == null ? getDBProgramID() : programID;
  }
  
  Concept getConcept(String id) {
    return empty(id) ? null : getConcept(parseLong(id));
  }
  
  Concept getConcept(long id) {
    return (Concept) concepts.get((long) id);
  }
  
  Concept getConcept(RC ref) {
    return ref == null ? null : getConcept(ref.longID());
  }
  
  boolean hasConcept(long id) {
    return concepts.containsKey((long) id);
  }
  
  void deleteConcept(long id) {
    Concept c = getConcept(id);
    if (c == null)
      print("Concept " + id + " not found");
    else
      c.delete();
  }
  
  void calcIdCounter() {
    Long lastID = lastKey(concepts);
    idCounter = lastID == null ? 1 : lastID+1;
  }
  
  File conceptsDir() { return dirOfFile(conceptsFile()); }
  
  Concepts conceptsFile(File conceptsFile) { this.conceptsFile = conceptsFile; return this; }
  
  File conceptsFile() {
    if (conceptsFile != null) return conceptsFile;
    
    return getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
  }
  
  // used for locking when useFileLock is activated
  File lockFile() {
    return newFile(conceptsDir(), "concepts.lock");
  }
  
  FileBasedLock fileLock() {
    if (fileLock == null)
      fileLock = new FileBasedLock(lockFile());
    return fileLock;
  }
  
  void saveConceptsIfDirty() { saveConcepts(); }
  void save() { saveConcepts(); }

  void saveConcepts() {
    vmBus_send("saveConceptsCalled", Concepts.this);
    if (dontSave) return;
    initProgramID();
    saverLock.lock();
    savingConcepts = true;
    long start = now(), time;
    try {
      String s = null;
      //synchronized(main.class) {
      long _changes = changes;
      if (_changes == changesWritten) return;
      
      File f = conceptsFile();
      
      lock.lock();
      long fullTime = now();
      try {
        if (useGZIP) {
          vmBus_send("callingSaveWrapper", Concepts.this, saveWrapper);
          callRunnableWithWrapper(saveWrapper, new Runnable() {  public void run() { try { 
            vmBus_send("callingPreSave", Concepts.this, preSave);
            callFAll(preSave);
            vmBus_send("writingFile", Concepts.this, f);
            uncompressedSize = saveGZStructureToFile(f, cloneMap(concepts), makeStructureData());
            vmBus_send("gzFileSaved", Concepts.this, f, uncompressedSize);
          
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "vmBus_send callingPreSave(Concepts.this, preSave);\r\n            callFAll(preS..."; }});
          newFile(conceptsDir(), "concepts.structure").delete();
        } else
          s = fullStructure();
      } finally {
        lock.unlock();
      }
      
      /*while (nempty(saveActions))
        pcallF(popFirst(saveActions));*/

      changesWritten = _changes; // only update when structure didn't fail
      
      if (!useGZIP) {
        time = now()-start;
        if (!quietSave)
          print("Saving " + toM(l(s)) + "M chars (" /*+ changesWritten + ", "*/ + time + " ms)");
        start = now();
        saveTextFile(f, javaTokWordWrap(s));
        newFile(conceptsDir(), "concepts.structure.gz").delete();
      }
      
      File conceptsFile = conceptsFile();
      File backupFile = newFile(conceptsDir(), "backups/" + fileName(conceptsFile) + ".backup" + ymd() + "-" + formatInt(hours(), 2)
        + (newBackupEveryXMinutes >= 60 ? "" : formatInt(roundDownTo_rev(minutes(), newBackupEveryXMinutes), 2)));
      // TODO: get rid of this
      copyFile(f, backupFile);
      
      time = now()-start;
      if (!quietSave)
        print("Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
      lastSaveWas = fullTime;
      lastSaveTook = now()-fullTime;
    } finally {
      savingConcepts = false;
      saverLock.unlock();
    }
  }
  
  void _autoSaveConcepts() {
    if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
      long pivotTime = Math.round(lastSaveWas+lastSaveTook*100.0/maxAutoSavePercentage);
      if (now() < pivotTime) {
        //print("Skipping auto-save (last save took " + lastSaveTook + ")");
        return;
      }
    }
    try {
      saveConcepts();
    } catch (Throwable e) {
      print("Concept save failed, will try again");
      printStackTrace(e);
    }
  }
  
  String fullStructure() {
    return structure(cloneMap(concepts), makeStructureData());
  }
  
  transient  IF0<structure_Data> makeStructureData;
structure_Data makeStructureData() { return makeStructureData != null ? makeStructureData.get() : makeStructureData_base(); }
final structure_Data makeStructureData_fallback(IF0<structure_Data> _f) { return _f != null ? _f.get() : makeStructureData_base(); }
structure_Data makeStructureData_base() {
    return finishStructureData(new structure_Data());
  }
  
  structure_Data finishStructureData(structure_Data data) {
    if (storeBaseClassesInStructure)
      data.storeBaseClasses = true;
    return data;
  }
  
  void clearConcepts() {
    for (Concept c : allConcepts()) c.delete();
    //concepts.clear();
    //allChanged();
  }
  
  void fireLegacyChangeEvent() {
    synchronized(this) { ++changes; lastChange = sysNow(); }
    if (vmBusSend) vmBus_send("conceptsChanged", this);
    pcallFAll(onAllChanged);
  }
  
  // auto-save every second if dirty
  synchronized void autoSaveConcepts() {
    if (autoSaver == null) {
      if (isTransient()) throw fail("Can't persist transient database");
      autoSaver = doEvery_daemon("Concepts Saver for " + conceptsDir(),
        abs(autoSaveInterval), new Runnable() {  public void run() { try {  _autoSaveConcepts() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_autoSaveConcepts()"; }});
      // print("Installed auto-saver (" + autoSaveInterval + " ms, " + progID() + ")");
    }
  }
  
  public void close() { cleanMeUp(); }
  
  void cleanMeUp() {
    try {
      defunct = true;
      boolean shouldSave = autoSaver != null;
      if (autoSaver != null) {
        autoSaver.cancel();
        autoSaver = null;
      }
      while (savingConcepts) sleepInCleanUp(10);
      if (shouldSave)
        saveConceptsIfDirty();
    } catch (Throwable __e) { printStackTrace(__e); }
    { cleanUp(fileLock); fileLock = null; }
  }
  
  Map<Long, String> getIDsAndNames() {
    Map<Long, String> map = new HashMap();
    Map<Long, Concept> cloned = cloneMap(concepts);
    for (long id : keys(cloned)) 
      map.put(id, cloned.get(id).className);
    return map;
  }
  
  void deleteConcepts(List l) {
    ping();
    if (l != null) for (Object o : cloneList(l))
      if (o instanceof Long) {
        Concept c = concepts.get(o);
        if (c != null) c.delete();
      } else if (o instanceof Concept)
        ((Concept) o).delete();
      else
        warn("Can't delete " + getClassName(o));
  }
  
  <A extends Concept> A conceptOfType(Class<A> type) {
    IConceptCounter counter = conceptCounterForClass(type);
    if (counter != null) return (A) first(counter.allConcepts());
    return firstOfType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> conceptsOfType(Class<A> type) {
    List<A> l = conceptsOfType_noParent(type);
    if (parent == null) return l;
    return concatLists_conservative(l, parent.conceptsOfType(type));
  }
  
  <A extends Concept> List<A> conceptsOfType_noParent(Class<A> type) {
    ping();
    IConceptCounter counter = conceptCounterForClass(type);
    if (counter != null) return (List<A>) cloneList(counter.allConcepts());
    return filterByType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> listConcepts(Class<A> type) {
    return conceptsOfType(type);
  }
  
  <A extends Concept> List<A> list(Class<A> type) {
    return conceptsOfType(type);
  }
  
  <A extends Concept> List<A> list_noParent(Class<A> type) {
    return conceptsOfType_noParent(type);
  }
  
  // TODO: would be better to make this Cl (indices may return sets)
  List<Concept> list(String type) {
    return conceptsOfType(type);
  }
  
  List<Concept> conceptsOfType(String type) {
    return filterByDynamicType(allConcepts(), "main$" + type);
  }
  
  boolean hasConceptOfType(Class<? extends Concept> type) {
    return hasType(allConcepts(), type);
  }
  
  void persistConcepts() {
    loadConcepts();
    autoSaveConcepts();
  }
  
  // We love synonyms
  void conceptPersistence() { persistConcepts(); }
  
  Concepts persist() { persistConcepts(); return this; }
  void persist(Integer interval) {
    if (interval != null) autoSaveInterval = interval;
    persist();
  }
    
  // Runs r if there is no concept of that type
  <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
    A a = conceptOfType(c);
    if (a == null) {
      r.run();
      a = conceptOfType(c);
      if (a == null)
        throw fail("Concept not made by " + r + ": " + shortClassName(c));
    }
    return a;
  }
  
  // Ensures that every concept of type c1 is ref'd by a concept of
  // type c2.
  // Type of func: voidfunc(concept)
  void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
    for (Concept a : conceptsOfType(c1)) {
      Concept b = findBackRef(a, c2);
      if (b == null) {
        callF(func, a);
        b = findBackRef(a, c2);
        if (b == null)
          throw fail("Concept not made by " + func + ": " + shortClassName(c2));
      }
    }
  }
  
  // Type of func: voidfunc(concept)
  void forEvery(Class<? extends Concept> type, Object func) {
    for (Concept c : conceptsOfType(type))
      callF(func, c);
  }
  
  int deleteAll(Class<? extends Concept> type) {
    List<Concept> l = (List) conceptsOfType(type);
    for (Concept c : l) c.delete();
    return l(l);
  }
  
  // always returns a new list (callers depend on this)
  Collection<Concept> allConcepts() {
    synchronized(concepts) {
      return new ArrayList(values(concepts));
    }
  }
  
  IConceptCounter conceptCounterForClass(Class<? extends Concept> c) {
    for (IFieldIndex idx : values(mapGet(fieldIndices, c)))
      if (idx instanceof IConceptCounter) return ((IConceptCounter) idx);
    for (IFieldIndex idx : values(mapGet(ciFieldIndices, c)))
      if (idx instanceof IConceptCounter) return ((IConceptCounter) idx);
    return null;
  }
  

  <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    int n = countConcepts_noParent(c, params);
    if (parent == null) return n;
    return n+parent.countConcepts(c, params);
  }
  
  <A extends Concept> int countConcepts_noParent(Class<A> c, Object... params) {
    ping();
    if (empty(params)) {
      IConceptCounter counter = conceptCounterForClass(c);
      if (counter != null) return counter.countConcepts();
      return l(list_noParent(c));
    }
    int n = 0;
    for (A x : list_noParent(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts(String c, Object... params) {
    ping();
    if (empty(params)) return l(list(c));
    int n = 0;
    for (Concept x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts() {
    return l(concepts);
  }
  
  synchronized List<IConceptIndex> clonedConceptIndices() {
    return cloneList(conceptIndices);
  }
  
  synchronized void addConceptIndex(IConceptIndex index) {
    if (conceptIndices == null)
      conceptIndices = new ArrayList();
    conceptIndices.add(index);
  }
  
  synchronized void removeConceptIndex(IConceptIndex index) {
    if (conceptIndices == null) return;
    conceptIndices.remove(index);
    if (empty(conceptIndices)) conceptIndices = null;
  }
  
  synchronized void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    if (fieldIndices == null)
      fieldIndices = new HashMap();
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    if (map == null)
      fieldIndices.put(c, map = new HashMap());
    map.put(field, index);
  }
  
  synchronized void removeFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    Map<String, IFieldIndex> map = mapGet(fieldIndices, c);
    mapRemove(map, field);
  }
  
  synchronized IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
    if (fieldIndices == null) return null;
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    return map == null ? null : map.get(field);
  }
  
  synchronized IFieldIndex getAnyIndexForClass(Class<? extends Concept> c) {
    return firstValue(fieldIndices == null ? null : fieldIndices.get(c));
  }
  
  synchronized void addCIFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    if (ciFieldIndices == null)
      ciFieldIndices = new HashMap();
    Map<String, IFieldIndex> map = ciFieldIndices.get(c);
    if (map == null)
      ciFieldIndices.put(c, map = new HashMap());
    map.put(field, index);
  }
  
  synchronized void removeCIFieldIndex(Class<? extends Concept> c, String field) {
    Map<String, IFieldIndex> map = mapGet(ciFieldIndices, c);
    mapRemove(map, field);
  }
  
  synchronized IFieldIndex getCIFieldIndex(Class<? extends Concept> c, String field) {
    if (ciFieldIndices == null) return null;
    Map<String, IFieldIndex> map = ciFieldIndices.get(c);
    return map == null ? null : map.get(field);
  }
  
  // inter-process methods
  
  RC xnew(String name, Object... values) {
    return new RC(cnew(name, values));
  }
  
  void xset(long id, String field, Object value) {
    xset(new RC(id), field, value);
  }
  
  void xset(RC c, String field, Object value) {
    if (value instanceof RC)
      value = getConcept((RC) value);
    cset(getConcept(c), field, value);
  }
  
  Object xget(long id, String field) {
    return xget(new RC(id), field);
  }
  
  Object xget(RC c, String field) {
    return xgetPost(cget(getConcept(c), field));
  }
  
  Object xgetPost(Object o) {
    o = deref(o);
    if (o instanceof Concept)
      return new RC((Concept) o);
    return o;
  }
  
  void xdelete(long id) {
    xdelete(new RC(id));
  }
  
  void xdelete(RC c) {
    getConcept(c).delete();
  }
  
  void xdelete(List<RC> l) {
    for (RC c : l)
      xdelete(c);
  }
  
  List<RC> xlist() {
    return map("toPassRef", allConcepts());
  }
  
  List<RC> xlist(String className) {
    return map("toPassRef", conceptsOfType(className));
  }
  
  boolean isTransient() { return eq(programID, "-"); }
  
  String xfullgrab() {
    if (noXFullGrab) throw fail("no xfullgrab (DB too large)");
    Lock __1 = lock(); lock(__1); try {
    if (changes == changesWritten && !isTransient())
      return loadConceptsStructure(programID);
    return fullStructure();
  } finally { unlock(__1); } }
  
  /* dev.
  Either<File, byte[]> xfullgrabGZipped() {
    lock lock();
    if (changes == changesWritten && !isTransient())
      ret loadConceptsStructure(programID);
    ret fullStructure();
  }*/
  
  void xshutdown() {
    // Killing whole VM if someone wants this DB to shut down
    cleanKillVM();
  }
  
  long xchangeCount() { return changes; }
  int xcount() { return countConcepts(); }
  
  void register(Concept c) {
    ping();
    if (c._concepts == this) return;
    if (c._concepts != null) throw fail("Can't re-register");
    c.id = internalID();
    c.created = now();
    if (modifyOnCreate) c._setModified(c.created);
    register_phase2(c);
    vmBus_send("conceptCreated", c);
    fireChange(new ConceptCreate(c));
  }
  
  // also called by replaceConceptAndUpdateRefs
  void register_phase2(Concept c) {
    c._concepts = this;
    concepts.put((long) c.id, c);
    for (Concept.Ref r : c._refs())
      r.index();
    c.change();
    c._onRegistered();
  }
  
  void registerKeepingID(Concept c) {
    if (c._concepts == this) return;
    if (c._concepts != null) throw fail("Can't re-register");
    c._concepts = this;
    concepts.put((long) c.id, c);
    c.change();
  }
  
  void conceptChanged(Concept c) {
    fireChange(new ConceptChange(c));
    if (conceptIndices != null)
      for (IConceptIndex index : clonedConceptIndices())
        index.update(c);
  }
  
  boolean hasUnsavedData() {
    return changes != changesWritten || savingConcepts;
  }
  
  synchronized Object miscMapGet(Object key) {
    return mapGet(miscMap, key);
  }
  
  synchronized Object miscMapPut(Object key, Object value) {
    if (miscMap == null) miscMap = new HashMap();
    return miscMap.put(key, value);
  }
  
  synchronized void miscMapRemove(Object key) {
    mapRemove(miscMap, key);
  }
  
  // Note: auto-typing can fool you, make sure create returns
  // a wide enough type
  synchronized <A> A miscMapGetOrCreate(Object key, IF0<A> create) {
    if (containsKey(miscMap, key)) return (A) miscMap.get(key);
    A value = create.get();
    miscMapPut(key, value);
    return value;
  }
  
  void setParent(Concepts parent) {
    this.parent = parent;
  }
  
  void fireChange(ConceptsChange change) {
    if (change == null) return;
    pcallFAll(onChange, change);
    fireLegacyChangeEvent();
  }
  
  final void onChange(IVF1<ConceptsChange> l){ addChangeListener(l); }
void addChangeListener(IVF1<ConceptsChange> l) {
    syncAdd(onChange, l);
  }
  
  void removeChangeListener(IVF1<ConceptsChange> l) {
    syncRemove(onChange, l);
  }
  
  void addPreSave(Runnable r) {
    preSave = syncAddOrCreate(preSave, r);
  }
  
  public String toString() {
    return nConcepts(concepts) + " (" + conceptsDir() + ", hash: " + identityHashCode(this) + ")";
  }
} // end of Concepts

// TODO: Move everyone over to this so we can have concepts that
// don't subclass Concept. It's hard though because of Concept.Ref
interface IConcept {
  public long _conceptID();
  public Concepts concepts();
}

static class Concept extends DynamicObject implements IConcept, ChangeTriggerable {
  transient Concepts _concepts; // Where we belong
  long id;
  long created, _modified;
  
  List<Ref> backRefs;
  
  // used only internally (cnew)
  Concept(String className) {
    super(className);
    _created();
  }
  
  Concept() {
    if (!_loading()) {
      //className = shortClassName(this); // XXX - necessary?
      //print("New concept of type " + className);
      _created();
    }
  }
  
  Concept(boolean unlisted) {
    if (!unlisted) _created();
  }
  
  boolean includeZeroIDInToString() { return false; }
  
  public String toString() {
    String s = shortDynamicClassName(this);
    long id = this.id;
    if (id != 0 || includeZeroIDInToString())
      s += " " + id;
    return s;
  }
  
  static boolean loading() { return _loading(); }
  static boolean _loading() { return dynamicObjectIsLoading(); }

  void _created() {
    if (!concepts_unlistedByDefault && !eq(concepts_unlisted.get(), true))
      db_mainConcepts().register(this);
  }
  
  // base class + required interface. experimental
  class TypedRef<A extends Concept, B> extends Ref<A> {
  TypedRef() {}
    //Class<B> aType;
    Class<B> bType;
    
    TypedRef(Class<B> bType) {
  this.bType = bType;}
    TypedRef(Class<B> bType, B value) {
  this.bType = bType; set((A) value); }
    TypedRef(B value) { set((A) value); }
    
    public boolean set(A a) {
      return super.set(checkValue(a));
    }
    
    void check() { checkValue(get()); }
    
    <C> C checkValue(C a) {
      if (bType != null && a != null)
        assertIsInstance(a, bType);
      return a;
    }
    
    B b() { return (B) value; }
  }
  
  class Ref<A extends Concept> implements IRef<A> {
    A value;
    
    Ref() {
      if (!dynamicObjectIsLoading())
        registerRef();
    }
    
    void registerRef() {
      vmBus_send("registeringConceptRef", this);
    }
    
    Ref(A value) {
  this.value = value;
      registerRef();
      index();
    }
    
    // get owning concept (source)
    Concept concept() {
      return Concept.this;
    }
    
    // get target
    public A get() { return value; }
    public boolean has() { return value != null; }
    
    boolean set(A a) {
      if (a == value) return false;
      unindex();
      value = a;
      index();
      change();
      return true;
    }
    
    void setIfEmpty(A a) {
      if (!has()) set(a);
    }
    
    public void set(Ref<A> ref) { set(ref.get()); }
    public void clear() { set((A) null); }
    
    boolean validRef() {
      return value != null && _concepts != null && _concepts == value._concepts;
    }
    
    // TODO: sync all the indexing and unindexing!?
    void index() { 
      if (validRef()) {
        value._addBackRef(this);
        change();
      }
    }

    Ref<A> unindex() {
      if (validRef()) {
        value._removeBackRef(this);
        change();
      }
      return this;
    }
    
    void unindexAndDrop() {
      unindex();
      _removeRef(this);
    }
    
    void change() {
      Concept.this.change();
    }
    
    public String toString() { return 
    str(value); }
  }
  
  class RefL<A extends Concept> extends AbstractList<A> {
    List<Ref<A>> l = new ArrayList();
    
    RefL() {}
    RefL(List<A> l) { replaceWithList(l); }
    
    public void clear() {
      while (!isEmpty()) removeLast(this);
    }
    
    public void replaceWithList(List<A> l) {
      clear();
      for (A a : unnullForIteration(l)) add(a);
    }
    
    public A set(int i, A o) {
      Ref<A> ref = syncGet(l, i);
      A prev = ref.get();
      ref.set(o);
      return prev;
    }
    
    public void add(int i, A o) {
      syncAdd(l, i, new Ref(o));
    }
    
    public A get(int i) {
      return syncGet(l, i).get();
    }
    
    public A remove(int i) {
      return syncRemove(l, i).get();
    }
    
    public int size() {
      return syncL(l);
    }
    
    public boolean contains(Object o) {
      if (o instanceof Concept)
        for (Ref<A> r : l) if (eq(r.get(), o)) return true;
      return super.contains(o);
    }
  }
  
  void delete() {
    //name = "[defunct " + name + "]";
    //defunct = true;
    //energy = 0;
    
    // clean refs
    
    for (Ref r : unnullForIteration(_refs()))
      r.unindex();
    
    
    // set back refs to null
    
    for (Ref r : cloneList(backRefs))
      r.set((Concept) null);
    backRefs = null;
    
    var _concepts = this._concepts;
    if (_concepts != null) {
      _concepts.concepts.remove(id);
      _concepts.fireChange(new ConceptDelete(id, this));
      if (_concepts.conceptIndices != null)
        for (IConceptIndex index : _concepts.conceptIndices)
          index.remove(this);
      this._concepts = null;
    }
    id = 0;
  }
  
  BaseXRef export() {
    return new BaseXRef(_concepts.progID(), id);
  }
  
  // notice system of a change in this object
  final public void _change(){ change(); }
public void change() {
    _setModified(now());
    _change_withoutUpdatingModifiedField();
  }
  
  void _setModified(long modified) {
    _modified = modified;
  }
  
  final void _change_withoutUpdatingModifiedField() {
    _onChange();
    if (_concepts != null) _concepts.conceptChanged(this);
  }
  
  // overridable
  void _onChange() {}
  
  String _programID() {
    return _concepts == null ? getDBProgramID() : _concepts.progID();
  }
  
  // overridable
  
  void _addBackRef(Concept.Ref ref) {
    backRefs = addDyn_quickSync(backRefs, ref);
    _backRefsModified();
  }
  
  void _backRefsModified() {
    if (_concepts != null && _concepts.modifyOnBackRef) change();
  }
  
  void _removeBackRef(Concept.Ref ref) {
    backRefs = removeDyn_quickSync(backRefs, ref);
    _backRefsModified();
  }
  
  void _removeRef(Concept.Ref ref) {
    
  }
  
  int _backRefCount() { return syncL(backRefs); }
  
  // convenience methods
  
  final void setField(String field, Object value){ _setField(field, value); }
void _setField(String field, Object value) {
    cset(this, field, value);
  }
  
  boolean setField_trueIfChanged(String field, Object value) {
    return cset(this, field, value) != 0;
  }
  
  <A> A setFieldAndReturn(String field, A value) {
    setField(field, value);
    return value;
  }
  
  final void setFields(Object... values){ _setFields(values); }
void _setFields(Object... values) {
    cset(this, values);
  }
  
  public Concepts concepts() { return _concepts; }
  
  boolean isDeleted() { return id == 0; }
  
  void _doneLoading2() {
    Map<String, FieldMigration> map = _fieldMigrations();
    if (map != null) for (Map.Entry<? extends String, ? extends FieldMigration> __0 : _entrySet( map))
      { String oldField = __0.getKey(); FieldMigration m = __0.getValue();  crenameField_noOverwrite(this, oldField, m.newField); }
  }
  
  static class FieldMigration implements IFieldsToList{
  String newField;
  FieldMigration() {}
  FieldMigration(String newField) {
  this.newField = newField;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + newField + ")"; }

public boolean equals(Object o) {
if (!(o instanceof FieldMigration)) return false;
    FieldMigration __6 =  (FieldMigration) o;
    return eq(newField, __6.newField);
}

  public int hashCode() {
    int h = 558692372;
    h = boostHashCombine(h, _hashCode(newField));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {newField}; }
}
  
  // value is 
  Map<String, FieldMigration> _fieldMigrations() { return null; }
  
  // new wrapper to get a copy of the refs list
  // so we can eventually drop the refs field
  Collection<Ref> _refs() {
    return scanConceptForRefs(this);
  }
  
  
  
  Concepts _concepts() { return _concepts; }
  
  boolean _conceptsDefunct() { return _concepts != null && _concepts.defunct; }
  boolean _conceptsDefunctOrUnregistered() { return _concepts == null || _concepts.defunct; }
  
  // allow refs to do magic stuff?
  void _onRegistered() {
    /*for (Ref ref : _refs())
      refs._onRegistered();*/
  }
  
  
<A> boolean addAndChange(Collection<A> cl, A a) {
  if (cl == null || !cl.add(a)) return false;
  change();
  return true;
}

<A> void clearAndChange(Collection<A> cl) {
  if (cl == null) return;
  cl.clear();
  change();
}


File conceptsDir() {
    var concepts = concepts();
    return concepts == null ? null : concepts.conceptsDir();
  }
  
  File fileInConceptsDir(String name) {
    var dir = conceptsDir();
    return dir == null ? null : newFile(dir, name);
  }
  
  public long _conceptID() { return id; }
} // end of Concept

// remote reference (for inter-process communication or
// external databases). Formerly "PassRef".
// prepared for string ids if we do them later
static class RC {
  transient Object owner;
  String id;
  
  RC() {} // make serialisation happy
  RC(long id) { this.id = str(id); }
  RC(Object owner, long id) { this.id = str(id); this.owner = owner; }
  RC(Concept c) { this(c.id); }
  long longID() { return parseLong(id); }
  
  public String toString() {
    return id;
  }

  transient RemoteDB db;
  
  String getString(String field) { return db.xS(this, field); }
  Object get(String field) { return db.xget(this, field); }
  void set(String field, Object value) { db.xset(this, field, value); }

} // end of RC

// Reference to a concept in another program
static class BaseXRef {
  String programID;
  long id;
    
  BaseXRef() {}
  BaseXRef(String programID, long id) {
  this.id = id;
  this.programID = programID;}
  
  public boolean equals(Object o) {
    if (!(o instanceof BaseXRef)) return false;
    BaseXRef r =  (BaseXRef) o;
    return eq(programID, r.programID) && eq(id, r.id);
  }
  
  public int hashCode() {
    return programID.hashCode() + (int) id;
  }
}

// BaseXRef as a concept
static class XRef extends Concept {
  BaseXRef ref;
  
  XRef() {}
  XRef(BaseXRef ref) {
  this.ref = ref; _doneLoading2(); }
  
  // after we have been added to concepts
  void _doneLoading2() {
    getIndex().put(ref, this);
  }
    
  HashMap<BaseXRef, XRef> getIndex() {
    return getXRefIndex(_concepts);
  }
}

static synchronized HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
  HashMap cache = (HashMap) concepts.perClassData().get(XRef.class);
  if (cache == null)
    concepts.perClassData.put(XRef.class, cache = new HashMap());
  return cache;
}

// uses mainConcepts
static XRef lookupOrCreateXRef(BaseXRef ref) {
  XRef xref = getXRefIndex(db_mainConcepts()).get(ref);
  if (xref == null)
    xref = new XRef(ref);
  return xref;
}

// define standard concept functions to use main concepts

// Now in db_mainConcepts()
/*static void cleanMeUp_concepts() {
  if (db_mainConcepts() != null) db_mainConcepts().cleanMeUp();
  // mainConcepts = null; // TODO
}*/

static void loadAndAutoSaveConcepts() {
  db_mainConcepts().persist();
}

static void loadAndAutoSaveConcepts(int interval) {
  db_mainConcepts().persist(interval);
}

static RC toPassRef(Concept c) {
  return new RC(c);
}

// so we can instantiate the program to run as a bare DB bot
static void concepts_setUnlistedByDefault(boolean b) {
  concepts_unlistedByDefault = b;
}
// AppendableChain has one "smart" head element (with size counter
// and pointer to the chain's last element), all the other nodes are
// maximally simple (MinimalChain).
// This allows O(1) front insertion, front removal and back insertion
// (not removal at the back though) which is fine for what I need this
// for (event queues).
//
// Stefan Reich, Oct 21

static class AppendableChain<A> extends MinimalChain<A> implements Iterable<A> {
  MinimalChain<A> last; // pointer to last element in chain (which may be us)
  int size; // total length of chain

  AppendableChain() {} // only used internally
  AppendableChain(A element) {
  this.element = element; size = 1; last = this; }
  
  // intermediate constructor called by itemPlusChain()
  AppendableChain(A element, AppendableChain<A> next) {
  this.next = next;
  this.element = element;
    if (next == null) return;
    
    MinimalChain<A> b = new MinimalChain();
    b.element = next.element;
    b.next = next.next;
    this.next = b;
    last = next.last;
    size = next.size+1;
  }
  
  public String toString() { return str(toList()); }
  
  // append at the end
  boolean add(A a) {
    MinimalChain newLast = new MinimalChain(a);
    last.next = newLast;
    last = newLast;
    ++size;
    return true;
  }
  
  // drop first element
  AppendableChain<A> popFirst() {
    if (next == null) return null;
    element = next.element;
    if (last == next) last = this;
    next = next.next;
    --size;
    return this;
  }
  
  ArrayList<A> toList() {
    ArrayList<A> l = emptyList(size);
    MinimalChain<A> c = this;
    while (c != null) {
      l.add(c.element);
      c = c.next;
    }
    return l;
  }
  
  //public Iterator<A> iterator() { ret toList().iterator(); }
  
  class ACIt extends IterableIterator  < A > {
    MinimalChain<A> c = AppendableChain.this;
    
    public boolean hasNext() {
      return c != null;
    }
    
    public A next() {
      var a = c.element;
      c = c.next;
      return a;
    }
  }
  
  public IterableIterator<A> iterator() {
    return new ACIt();
  }
}
static class FixedRateTimer extends java.util.Timer implements AutoCloseable {
  FixedRateTimer() { this(false); }
  FixedRateTimer(boolean daemon) { this(defaultTimerName(), daemon); }
  FixedRateTimer(String name) { this(name, false); }
  FixedRateTimer(String name, boolean daemon) {
    super(name, daemon);
    _registerTimer(this);
  }
  
  List<Entry> entries = synchroList();
  
  static class Entry implements IFieldsToList{
  TimerTask task;
  long firstTime;
  long period;
  Entry() {}
  Entry(TimerTask task, long firstTime, long period) {
  this.period = period;
  this.firstTime = firstTime;
  this.task = task;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + task + ", " + firstTime + ", " + period + ")"; }public Object[] _fieldsToList() { return new Object[] {task, firstTime, period}; }
}
  
  // Note: not all methods overridden; only use these ones
  
  public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
    entries.add(new Entry(task, now()+delay, period));
    super.scheduleAtFixedRate(task, delay, period);
  }
  
  public void cancel() {
    entries.clear();
    super.cancel();
  }
  
  public int purge() {
    entries.clear();
    return super.purge();
  }
  
  FixedRateTimer changeRate(int newPeriod) {
    Object r = ((SmartTimerTask) first(entries).task).r;
    cancel();
    return doEvery(newPeriod, r);
  }
  
  public void close() { try { cancel(); } catch (Exception __e) { throw rethrow(__e); } }
}
static class Fail extends RuntimeException implements IFieldsToList{
  Object[] objects;
  Fail() {}
  Fail(Object... objects) {
  this.objects = objects;}public Object[] _fieldsToList() { return new Object[] {objects}; }

  Fail(Throwable cause, Object... objects) {
    super(cause);
  this.objects = objects;
  }
  
  public String toString() { return joinNemptiesWithColon("Fail", commaCombine(getCause(), objects)); }
}
final static class Rect implements IFieldsToList{
  static final String _fieldOrder = "x y w h";
  int x;
  int y;
  int w;
  int h;
  Rect() {}
  Rect(int x, int y, int w, int h) {
  this.h = h;
  this.w = w;
  this.y = y;
  this.x = x;}

public boolean equals(Object o) {
if (!(o instanceof Rect)) return false;
    Rect __1 =  (Rect) o;
    return x == __1.x && y == __1.y && w == __1.w && h == __1.h;
}

  public int hashCode() {
    int h = 2543108;
    h = boostHashCombine(h, _hashCode(x));
    h = boostHashCombine(h, _hashCode(y));
    h = boostHashCombine(h, _hashCode(w));
    h = boostHashCombine(h, _hashCode(h));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {x, y, w, h}; }

  Rect(Rectangle r) {
    x = r.x;
    y = r.y;
    w = r.width;
    h = r.height;
  }
  
  Rect(Pt p, int w, int h) {
  this.h = h;
  this.w = w; x = p.x; y = p.y; }
  Rect(Rect r) { x = r.x; y = r.y; w = r.w; h = r.h; }
  
  Rectangle getRectangle() {
    return new Rectangle(x, y, w, h);
  }
  
  public String toString() {
    return x + "," + y + " / " + w + "," + h;
  }
  
  int x1() { return x; }
  int y1() { return y; }
  int x2() { return x + w; }
  int y2() { return y + h; }
  
  boolean contains(Pt p) {
    return contains(p.x, p.y);
  }
  
  boolean contains(int _x, int _y) {
    return _x >= x && _y >= y && _x < x+w && _y < y+h;
  }
  
  boolean contains(Rectangle r) {
    return rectContains(this, r);
  }
  
  boolean empty() { return w <= 0 || h <= 0; }
  
  int getWidth() { return w; }
  int getHeight() { return h; }
}
static class ProgramScan {
  static int threads = isWindows() ? 500 : 10;
  static int timeout = 5000; // hmm...
  static String ip = "127.0.0.1";
  
  // This range is not used anymore anyway
  static int quickScanFrom = 10000, quickScanTo = 10999;

  static int maxNumberOfVMs_android = 4; // Android will always only have one if we don't screw up
  static int maxNumberOfVMs_nonAndroid = 50; // 100;
  static int maxNumberOfVMs;
  
  static boolean verbose = false;
  
  static class Program {
    int port;
    String helloString;
    
    Program(int port, String helloString) {
  this.helloString = helloString;
  this.port = port;}
  }
  
  static List<Program> scan() { try {
    return scan(1, 65535);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  static List<Program> scan(int fromPort, int toPort) {
    return scan(fromPort, toPort, new int[0]);
  }
  
  static List<Program> scan(int fromPort, int toPort, int[] preferredPorts) { try {
    Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
    int scanSize = toPort-fromPort+1;
    String name = toPort < 10000 ? "bot" : "program";
    int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
    final ExecutorService es = Executors.newFixedThreadPool(threads);
    if (verbose) print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
    startTiming();
    List<Future<Program>> futures = new ArrayList();
    List<Integer> ports = new ArrayList();
    for (int port : preferredPorts) {
      futures.add(checkPort(es, ip, port, timeout));
      ports.add(port);
    }
    for (int port = fromPort; port <= toPort; port++)
      if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
        futures.add(checkPort(es, ip, port, timeout));
        ports.add(port);
      }
    es.shutdown();
    List<Program> programs = new ArrayList();
    long time = now();
    int i = 0;
    for (final Future<Program> f : futures) {
      if (verbose) print("Waiting for port " + get(ports, i++) + " at time " + (now()-time));
      Program p = f.get();
      if (p != null)
        programs.add(p);
    }
    //stopTiming("Port Scan " + scanSize + ", " + n(threads, "threads") + ": ", 250);
    if (verbose) print("Found " + programs.size() + " " + name + "(s) on " + ip);
    return programs;
  } catch (Exception __e) { throw rethrow(__e); } }

  static Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
    return es.submit(new Callable<Program>() {
        @Override public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              //if (verbose) print("Connected to " + ip + ":" + port);
              BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
     });
  }
  
  static List<Program> quickScan() {
    return scan(quickScanFrom, quickScanTo);
  }
  
  static List<Program> quickBotScan() {
    return quickBotScan(new int[0]);
  }
  
  static List<Program> quickBotScan(int[] preferredPorts) {
    if (maxNumberOfVMs == 0)
      maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
    return scan(4999, 5000+maxNumberOfVMs-1, preferredPorts);
  }
}
static class Pt implements Comparable<Pt>, IDoublePt {
  int x, y;
  
  Pt() {}
  Pt(Point p) {
    x = p.x;
    y = p.y;
  }
  Pt(int x, int y) {
  this.y = y;
  this.x = x;}
  
  Point getPoint() {
    return new Point(x, y);
  }
  
  public boolean equals(Object o) {
    return o instanceof Pt && x == ((Pt) o).x && y == ((Pt) o).y;
  }
  
  public int hashCode() {
    return boostHashCombine(x, y);
  }
  
  // compare in scan order
  public int compareTo(Pt p) {
    if (y != p.y) return cmp(y, p.y);
    return cmp(x, p.x);
  }
  
  public String toString() {
    return x + ", " + y;
  }
  
  double length() { return sqrt(x*x+y*y); }
  
  public Pt minus(Pt p) { return ptMinus(this, p); }
  
  public double x_double() { return x; }
  public double y_double() { return y; }
}
static class ConceptFieldIndex<A extends Concept, Val> extends ConceptFieldIndexBase<A, Val> {
  ConceptFieldIndex(Class<A> cc, String field) { super(cc, field); }
  ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) { super(concepts, cc, field); }

  void init() {
    valueToObject = new MultiSetMap();
  }
  
  void register() {
    concepts.addFieldIndex(cc, field, this);
  }
}
// could almost add IVar<A> here - but void set() and bool set() are incompatible in some places
static interface IRef<A> extends IF0<A> {
  // called by the referencee to atomically replace itself
  // Passing oldValue to avoid race conditions
  public default void replaceValue(A oldValue, A newValue) {}
}
static abstract class F0<A> {
  abstract A get();
}
static abstract class F1<A, B> {
  abstract B get(A a);
}
// you still need to implement hasNext() and next()
static abstract class IterableIterator<A> implements Iterator<A>, Iterable<A> {
  public Iterator<A> iterator() {
    return this;
  }
  
  public void remove() {
    unsupportedOperation();
  }
}
static class TreeMultiMap<A, B> extends MultiMap<A, B> {
  TreeMultiMap() { super(true); }
  TreeMultiMap(MultiMap<A, B> map) { this(); putAll(map); }
}
static abstract class F2<A, B, C> {
  abstract C get(A a, B b);
}
/** this class is fully thread-safe */
static class Flag implements Runnable {
  private boolean up = false;

  /** returns true if flag was down before (i.e. flag was actually raised right now) */
  public synchronized boolean raise() {
    if (!up) {
      up = true;
      notifyAll();
      return true;
    } else
      return false;
  }

  public synchronized void waitUntilUp() { try {
    while (!up) {
      //try {
        wait();
      /*} catch (InterruptedException e) {
        e.printStackTrace();
      }*/
    }
  } catch (Exception __e) { throw rethrow(__e); } }

  public boolean waitUntilUp(double timeout) {
    if (timeout == infinity()) {
      waitUntilUp();
      return isUp();
    } else
      return waitUntilUp(toMS(timeout));
  }
  
  public synchronized boolean waitUntilUp(long timeout) { try {
    if (!up) {
      //try {
        wait(timeout);
      /*} catch (InterruptedException e) {
        e.printStackTrace();
      }*/
    }
    return isUp();
  } catch (Exception __e) { throw rethrow(__e); } }

  public synchronized boolean isUp() {
    return up;
  }
  
  boolean get() { return isUp(); }

  public String toString() {
    return isUp() ? "up" : "down";
  }

  // currently does a semi-active wait with latency = 50 ms
  public void waitForThisOr(Flag otherFlag) { try {
    while (!isUp() && !otherFlag.isUp())
      Thread.sleep(50);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public void run() { raise(); }
}
static class SynchronizedNavigableMap<K,V> extends SynchronizedSortedMap<K,V> implements NavigableMap<K,V>
{
  SynchronizedNavigableMap() {}
    NavigableMap<K, V> innerMap() { return (NavigableMap) m; }

    SynchronizedNavigableMap(NavigableMap<K,V> m) {
        super(m);
    }
    SynchronizedNavigableMap(NavigableMap<K,V> m, Object mutex) {
        super(m, mutex);
    }

    public Entry<K, V> lowerEntry(K key)
                    { synchronized (mutex) { return innerMap().lowerEntry(key); } }
    public K lowerKey(K key)
                      { synchronized (mutex) { return innerMap().lowerKey(key); } }
    public Entry<K, V> floorEntry(K key)
                    { synchronized (mutex) { return innerMap().floorEntry(key); } }
    public K floorKey(K key)
                      { synchronized (mutex) { return innerMap().floorKey(key); } }
    public Entry<K, V> ceilingEntry(K key)
                  { synchronized (mutex) { return innerMap().ceilingEntry(key); } }
    public K ceilingKey(K key)
                    { synchronized (mutex) { return innerMap().ceilingKey(key); } }
    public Entry<K, V> higherEntry(K key)
                   { synchronized (mutex) { return innerMap().higherEntry(key); } }
    public K higherKey(K key)
                     { synchronized (mutex) { return innerMap().higherKey(key); } }
    public Entry<K, V> firstEntry()
                       { synchronized (mutex) { return innerMap().firstEntry(); } }
    public Entry<K, V> lastEntry()
                        { synchronized (mutex) { return innerMap().lastEntry(); } }
    public Entry<K, V> pollFirstEntry()
                   { synchronized (mutex) { return innerMap().pollFirstEntry(); } }
    public Entry<K, V> pollLastEntry()
                    { synchronized (mutex) { return innerMap().pollLastEntry(); } }

    public NavigableMap<K, V> descendingMap() {
        synchronized (mutex) {
            return
                new SynchronizedNavigableMap<>(innerMap().descendingMap(), mutex);
        }
    }

    public NavigableSet<K> keySet() {
        return navigableKeySet();
    }

    public NavigableSet<K> navigableKeySet() {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(innerMap().navigableKeySet(), mutex);
        }
    }

    public NavigableSet<K> descendingKeySet() {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(innerMap().descendingKeySet(), mutex);
        }
    }


    public SortedMap<K,V> subMap(K fromKey, K toKey) {
        synchronized (mutex) {
            return new SynchronizedNavigableMap<>(
                innerMap().subMap(fromKey, true, toKey, false), mutex);
        }
    }
    public SortedMap<K,V> headMap(K toKey) {
        synchronized (mutex) {
            return new SynchronizedNavigableMap<>(innerMap().headMap(toKey, false), mutex);
        }
    }
    public SortedMap<K,V> tailMap(K fromKey) {
        synchronized (mutex) {
    return new SynchronizedNavigableMap<>(innerMap().tailMap(fromKey, true),mutex);
        }
    }

    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableMap<>(
                innerMap().subMap(fromKey, fromInclusive, toKey, toInclusive), mutex);
        }
    }

    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableMap<>(
                    innerMap().headMap(toKey, inclusive), mutex);
        }
    }

    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableMap<>(
                innerMap().tailMap(fromKey, inclusive), mutex);
        }
    }
}

public static interface IF0<A> {
  A get();
}
static interface Hasher<A> {
  int hashCode(A a);
  boolean equals(A a, A b);
}
static class ExpiringMap2<A, B> extends AbstractMap<A, B> {
  Map<A, Pair<Long, B>> byKey = new HashMap();      // key -> pair(expiry sys time, value)
  PriorityBlockingQueue<Pair<Long, A>> queue = new PriorityBlockingQueue(); // queue(pair(expiry sys time, key))
  long standardExpiryTime; // ms
  boolean renewOnOverwrite = true, renewOnGet;
  Object onChange;
  boolean useCountdown = true;
  RestartableCountdown countdown = new RestartableCountdown();

  ExpiringMap2() {}
  ExpiringMap2(long standardExpiryTime) {
  this.standardExpiryTime = standardExpiryTime;}
  ExpiringMap2(long standardExpiryTime, Object onChange) {
  this.onChange = onChange;
  this.standardExpiryTime = standardExpiryTime;}
  ExpiringMap2(double standardExpirySeconds) { standardExpiryTime = toMS(standardExpirySeconds); }
  
  synchronized boolean clean() {
    boolean changes = false;
    Pair<Long, A> p;
    long time = sysTime();
    while ((p = queue.peek()) != null && time >= p.a) {
      if (useCountdown) countdown.stop();
      
      p = queue.poll();
      
      Pair<Long, B> v = byKey.get(p.b);
      if (v != null /*&& v.a == p.a*/) {
        
        byKey.remove(p.b);
        changes = true;
        change();
      }
    }
    if (useCountdown) 
      countdown.setTargetTime(p != null ? p.a : 0, new Runnable() {  public void run() { try {  clean(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "clean();"; }});
    return changes;
  }
  
  void change() { callF(onChange); }
  
  synchronized public B put(A a, B b) {
    clean();
    long timeout = sysTime()+standardExpiryTime;
    Pair<Long, B> p = byKey.get(a);
    if (p != null && renewOnOverwrite)
      queue.remove(new Pair(p.a, a));
    byKey.put(a, pair(timeout, b));
    change();
    if (p == null || renewOnOverwrite)
      queue.add(new Pair(timeout, a));
    return pairB(p);
  }
  
  synchronized public B remove(Object a) {
    clean();
    Pair<Long, B> p = byKey.get(a);
    if (p == null) return null;
    queue.remove(new Pair(p.a, a));
    byKey.remove(a);
    change();
    return p.b;
  }
  
  synchronized public B get(Object a) {
    clean();
    Pair<Long, B> p = byKey.get(a);
    if (renewOnGet && p != null) {
      queue.remove(new Pair(p.a, a));
      long timeout = sysTime()+standardExpiryTime;
      byKey.put((A) a, pair(timeout, p.b));
      queue.add(new Pair(timeout, a));
    }
    return pairB(p);
  }
  
  synchronized public Set<Map.Entry<A,B>> entrySet() {
    clean();
    // TODO: mutex
    return synchronizedSet(mapValues(__50 -> pairB(__50), byKey).entrySet());
  }
  
  synchronized public Set<A> keySet() {
    clean();
    return synchronizedSet(byKey.keySet());
  }
  
  synchronized public int size() {
    clean();
    return byKey.size();
  }
  
  void setStandardExpiryTime(long ms) { standardExpiryTime = ms; }
  
  synchronized ExpiringMap2<A, B> setMap(Map innerMap) {
    byKey = innerMap;
    return this;
  }
}
static abstract class CloseableIterableIterator<A> extends IterableIterator<A> implements AutoCloseable {
  public void close() throws Exception {}
}
static interface IFieldsToList {
  Object[] _fieldsToList();
}
static class ConceptFieldIndexCI<A extends Concept>  extends ConceptFieldIndexBase<A, Object> {
  ConceptFieldIndexCI(Class<A> cc, String field) { super(cc, field); }
  ConceptFieldIndexCI(Concepts concepts, Class<A> cc, String field) { super(concepts, cc, field); }

  void init() {
    valueToObject = generalizedCIMultiSetMap();
  }
  
  void register() {
    concepts.addCIFieldIndex(cc, field, this);
  }
}
static interface IF2<A, B, C> {
  C get(A a, B b);
}
static interface Producer<A> {
  public A next(); // null when end
}
static interface IF1<A, B> {
  B get(A a);
}
static interface IVF1<A> {
  void get(A a);
}
static interface IVF2<A, B> {
  void get(A a, B b);
}
static interface IVar<A> extends IF0<A> {
  void set(A a);
  A get();
  
  // reified type of value (if available)
  default Class<A> getType() { return null; }
  
  
  default boolean has() { return get() != null; }
  default void clear() { set(null); }
  
}
static interface IIntPred {
  boolean get(int a);
}
static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
  SynchronizedList() {}
    /*final*/ List<E> list;

    SynchronizedList(List<E> list) {
        super(list);
        this.list = list;
    }
    SynchronizedList(List<E> list, Object mutex) {
        super(list, mutex);
        this.list = list;
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;
        synchronized (mutex) {return list.equals(o);}
    }
    public int hashCode() {
        synchronized (mutex) {return list.hashCode();}
    }

    public E get(int index) {
        synchronized (mutex) {return list.get(index);}
    }
    public E set(int index, E element) {
        synchronized (mutex) {return list.set(index, element);}
    }
    public void add(int index, E element) {
        synchronized (mutex) {list.add(index, element);}
    }
    public E remove(int index) {
        synchronized (mutex) {return list.remove(index);}
    }

    public int indexOf(Object o) {
        synchronized (mutex) {return list.indexOf(o);}
    }
    public int lastIndexOf(Object o) {
        synchronized (mutex) {return list.lastIndexOf(o);}
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        synchronized (mutex) {return list.addAll(index, c);}
    }

    public ListIterator<E> listIterator() {
        return list.listIterator(); // Must be manually synched by user
    }

    public ListIterator<E> listIterator(int index) {
        return list.listIterator(index); // Must be manually synched by user
    }

    public List<E> subList(int fromIndex, int toIndex) {
        synchronized (mutex) {
            return new SynchronizedList<>(list.subList(fromIndex, toIndex),
                                        mutex);
        }
    }

    @Override
    public void replaceAll(java.util.function.UnaryOperator<E> operator) {
        synchronized (mutex) {list.replaceAll(operator);}
    }
    @Override
    public void sort(Comparator<? super E> c) {
        synchronized (mutex) {list.sort(c);}
    }

    /**
     * SynchronizedRandomAccessList instances are serialized as
     * SynchronizedList instances to allow them to be deserialized
     * in pre-1.4 JREs (which do not have SynchronizedRandomAccessList).
     * This method inverts the transformation.  As a beneficial
     * side-effect, it also grafts the RandomAccess marker onto
     * SynchronizedList instances that were serialized in pre-1.4 JREs.
     *
     * Note: Unfortunately, SynchronizedRandomAccessList instances
     * serialized in 1.4.1 and deserialized in 1.4 will become
     * SynchronizedList instances, as this method was missing in 1.4.
     */
    @java.io.Serial
    private Object readResolve() {
        return (list instanceof RandomAccess
                ? new SynchronizedRandomAccessList<>(list)
                : this);
    }
}

// immutable, has strong refs
// Do not run in a synchronized block - it goes wrong in the presence
// of elaborate classloaders (like in Gazelle BEA)
// see #1102990 and #1102991

final static class _MethodCache {
  final Class c;
  final HashMap<String, List<Method>> cache = new HashMap();
  
  _MethodCache(Class c) {
  this.c = c; _init(); }
  
  void _init() {
    Class _c = c;
    java.lang.Module myModule = getClass().getModule();
    boolean anyHiddenClasses = false;
    
    while (_c != null) {
      boolean exported = classIsExportedTo(_c, myModule);
       
      
      if (!exported)
        anyHiddenClasses = true;
      else
        for (Method m : _c.getDeclaredMethods())
          if ((anyHiddenClasses || !isAbstract(m))
            && !reflection_isForbiddenMethod(m))
            multiMapPut(cache, m.getName(), makeAccessible(m));

      _c = _c.getSuperclass();
    }
    
    // add default methods - this might lead to a duplication
    // because the overridden method is also added, but it's not
    // a problem except for minimal performance loss.
    // If any classes in the hierarchy were inaccessible, we add
    // all interface methods (see test_callForbiddenMethodByReflection for a test)
    
    for (Class intf : allInterfacesImplementedBy(c))
      for (Method m : intf.getDeclaredMethods())
        if ((anyHiddenClasses || m.isDefault()) && !reflection_isForbiddenMethod(m))
          multiMapPut(cache, m.getName(), makeAccessible(m));

     
  }
  
  // Returns only matching methods
  Method findMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
     
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Method findStaticMethod(String method, Object[] args) { try {
    List<Method> m = cache.get(method);
    if (m == null) return null;
    int n = m.size();
    for (int i = 0; i < n; i++) {
      Method me = m.get(i);
      if (isStaticMethod(me) && call_checkArgs(me, args, false))
        return me;
    }
    return null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  //Cl<Method> allMethods() { ret allValues(cache); }
}
static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
  
  public String toString() { return "Matches(" + joinWithComma(quoteAll(asList(m))) + ")"; }
  
  public int hashCode() { return _hashCode(toList(m)); }
  public boolean equals(Object o) { return o instanceof Matches && arraysEqual(m, ((Matches) o).m); }
}

// for the version with MasterSymbol (used WAY back in "Smart Bot"!) see #1010608

static class Symbol implements CharSequence {
  String text;
  
  Symbol() {}
  Symbol(String text, boolean dummy) {
  this.text = text;} // weird signature to prevent accidental calling
  
  public int hashCode() { return _hashCode(text); }
  public String toString() { return text; }
  public boolean equals(Object o) {
    return this == o;
  }

  // implementation of CharSequence methods
  
  public int length() { return text.length(); }
  public char charAt(int index) { return text.charAt(index); }
  public CharSequence subSequence(int start, int end) {
    return text.substring(start, end);
  }
}

static class MechListDependentCache<A> extends Cache<A> {
  // maker is now F1<S, A>
  String listName, lastListContents;
  
  MechListDependentCache() {}
  MechListDependentCache(String listName, Object maker) {
  this.maker = maker;
  this.listName = listName;}
  
  A make() { return (A) callF(maker, lastListContents); }
  
  A get() {
    if (hasLock(lock)) return value; // Must be called from within maker
    {
      String listContents = mL_raw(listName);
      Lock __0 = lock; lock(__0); try {
      if (!eqOrSame(listContents, lastListContents))
        clear();
      lastListContents = listContents;
    } finally { unlock(__0); } }
    return super.get();
  }
}
static interface IMeta {
  // see class "Meta" for the bla bla
  
  public void _setMeta(Object meta);
  public Object _getMeta();
  default public IAutoCloseableF0 _tempMetaMutex() {
    return new IAutoCloseableF0() {
      public Object get() { return IMeta.this; }
      public void close() {}
    };
  }
  
  // actually query another object
  default public Object getMeta(Object obj, Object key){ return metaGet(obj, key); }
default public Object metaGet(Object obj, Object key) {
    // call global function
    return metaMapGet(obj, key);
  }
  
  default public Object metaGet(String key, Object obj) {
    // call global function
    return metaMapGet(obj, key);
  }
  
  default public Object getMeta(Object key){ return metaGet(key); }
default public Object metaGet(Object key) {
    if (key == null) return null;
    Object meta = _getMeta();
    if (meta instanceof Map) return ((Map) meta).get(key);
    return null;
  }
  
  default public void metaSet(IMeta obj, Object key, Object value){ metaPut(obj, key, value); }
default public void metaPut(IMeta obj, Object key, Object value) {
    // call global function
    metaMapPut(obj, key, value);
  }
  
  default public void metaSet(Object key, Object value){ metaPut(key, value); }
default public void metaPut(Object key, Object value) {
    if (key == null) return;
    Map map = convertObjectMetaToMap(this);
    syncMapPutOrRemove(map, key, value);
  }
}
// a variant of thread where you can get the Runnable target later.
// Also notes its existence on the VM bus.
// We should use this exclusively instead of Thread.

static class BetterThread extends Thread {
  Runnable target;
  
  BetterThread(Runnable target) {
  this.target = target; _created(); }
  BetterThread(Runnable target, String name) { super(name);
  this.target = target; _created(); }
  
  void _created() { vmBus_send("threadCreated", this); }
  
  public void run() { try {
    try {
      vmBus_send("threadStarted", this);
      if (target != null) target.run();
    } finally {
      vmBus_send("threadEnded", this); 
    }
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Runnable getTarget() { return target; }
}
static class MechListDependentCaches<A> {
  Map<String, MechListDependentCache<A>> byList = ciMap();
  Object maker; // func(S) -> A
  transient Lock lock = lock();
  
  MechListDependentCaches(Object maker) {
  this.maker = maker;}

  A get(String name) {
    MechListDependentCache<A> listCache;
    {
      Lock __0 = lock; lock(__0); try {
      listCache = byList.get(name);
      if (listCache == null)
        byList.put(name, listCache
          = new MechListDependentCache(name, maker));
    } finally { unlock(__0); } }
    return listCache.get();
  }
}
static class MultiMap<A,B> implements IMultiMap<A, B> {
  Map<A, List<B>> data = new HashMap<A, List<B>>();
  int fullSize;
  
  MultiMap() {}
  MultiMap(boolean useTreeMap) { if (useTreeMap) data = new TreeMap(); }
  MultiMap(MultiMap<A, B> map) { putAll(map); }
  MultiMap(Map<A, List<B>> data) {
  this.data = data;}

  void put(A key, B value) { synchronized(data) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = _makeEmptyList());
    list.add(value);
    ++fullSize;
  }}

  void add(A key, B value) { put(key, value); }

  void addAll(A key, Collection<B> values) { putAll(key, values); }
  
  void addAllIfNotThere(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      setPut(key, value);
  }}
  
  void setPut(A key, B value) { synchronized(data) {
    if (!containsPair(key, value))
      put(key, value);
  }}
  
  boolean containsPair(A key, B value) { synchronized(data) {
    return get(key).contains(value);
  }}
  
  void putAll(Collection<A> keys, B value) { synchronized(data) {
    for (A key : unnullForIteration(keys))
      put(key, value);
  }}

  void putAll(A key, Collection<B> values) { synchronized(data) {
    if (nempty(values)) getActual(key).addAll(values);
  }}

  void putAll(Iterable<Pair<A, B>> pairs) { synchronized(data) {
    for (Pair<A, B> p : unnullForIteration(pairs))
      put(p.a, p.b);
  }}
  
  void removeAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      remove(key, value);
  }}
  
  public List<B> get(A key) { synchronized(data) {
    List<B> list = data.get(key);
    return list == null ? Collections.<B> emptyList() : list;
  }}
  
  List<B> getOpt(A key) { synchronized(data) {
    return data.get(key);
  }}

  List<B> getAndClear(A key) { synchronized(data) {
    List<B> l = cloneList(data.get(key));
    remove(key);
    return l;
  }}
  
  // returns actual mutable live list
  // creates the list if not there
  List<B> getActual(A key) { synchronized(data) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = _makeEmptyList());
    return list;
  }}
 
  void clean(A key) { synchronized(data) {
    List<B> list = data.get(key);
    if (list != null && list.isEmpty()) {
      fullSize -= l(list);
      data.remove(key);
    }
  }}

  final public Set<A> keys(){ return keySet(); }
public Set<A> keySet() { synchronized(data) {
    return data.keySet();
  }}

  void remove(A key) { synchronized(data) {
    fullSize -= l(this.getOpt(key));
    data.remove(key);
  }}
  
  final void remove(Pair<A, B> p){ removePair(p); }
void removePair(Pair<A, B> p) {
    if (p != null) remove(p.a, p.b);
  }

  void remove(A key, B value) { synchronized(data) {
    List<B> list = data.get(key);
    if (list != null) {
      if (list.remove(value))
        fullSize--;
      if (list.isEmpty())
        data.remove(key);
    }
  }}

  void clear() { synchronized(data) {
    data.clear();
  }}

  boolean containsKey(A key) { synchronized(data) {
    return data.containsKey(key);
  }}

  B getFirst(A key) { synchronized(data) {
    List<B> list = get(key);
    return list.isEmpty() ? null : list.get(0);
  }}
  
  void addAll(MultiMap<A, B> map) { putAll(map); }
  
  void putAll(MultiMap<A, B> map) { synchronized(data) {
    for (A key : map.keySet())
      putAll(key, map.get(key));
  }}
  
  void putAll(Map<A, B> map) { synchronized(data) {
    if (map != null) for (Map.Entry<A, B> e : map.entrySet())
      put(e.getKey(), e.getValue());
  }}
  
  final public int keyCount(){ return keysSize(); }
public int keysSize() { synchronized(data) { return l(data); }}
  
  // full size - note: expensive operation
  final public int fullSize(){ return size(); }
public int size() { synchronized(data) {
    return fullSize;
  }}
  
  // expensive operation
  List<A> reverseGet(B b) { synchronized(data) {
    List<A> l = new ArrayList();
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        l.add(key);
    return l;
  }}
  
  Map<A, List<B>> asMap() { synchronized(data) {
    return cloneMap(data);
  }}
  
  boolean isEmpty() { synchronized(data) { return data.isEmpty(); }}
  
  // override in subclasses
  List<B> _makeEmptyList() {
    return new ArrayList();
  }
  
  // returns live lists
  Collection<List<B>> allLists() {
    synchronized(data) {
      return new ArrayList(data.values());
    }
  }
  Collection<List<B>> values() { return allLists(); }
  
  List<B> allValues() {
    return concatLists(data.values());
  }
  
  Object mutex() { return data; }
  
  public String toString() { return "mm" + str(data); }
}
static class SynchronizedSet<E>
      extends SynchronizedCollection<E>
      implements Set<E> {
  SynchronizedSet() {}
    SynchronizedSet(Set<E> s) {
        super(s);
    }
    SynchronizedSet(Set<E> s, Object mutex) {
        super(s, mutex);
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;
        synchronized (mutex) {return c.equals(o);}
    }
    public int hashCode() {
        synchronized (mutex) {return c.hashCode();}
    }
}




static class SynchronizedMap<K,V> implements Map<K,V>, Serializable {
  SynchronizedMap() {}
    /*final*/ Map<K,V> m;     // Backing Map
    /*final*/ Object      mutex;        // Object on which to synchronize

    SynchronizedMap(Map<K,V> m) {
        this.m = Objects.requireNonNull(m);
        mutex = this;
    }

    SynchronizedMap(Map<K,V> m, Object mutex) {
        this.m = m;
        this.mutex = mutex;
    }
    
    Map<K, V> innerMap() { return m; }

    public int size() {
        synchronized (mutex) {return m.size();}
    }
    public boolean isEmpty() {
        synchronized (mutex) {return m.isEmpty();}
    }
    public boolean containsKey(Object key) {
        synchronized (mutex) {return m.containsKey(key);}
    }
    public boolean containsValue(Object value) {
        synchronized (mutex) {return m.containsValue(value);}
    }
    public V get(Object key) {
        synchronized (mutex) {return m.get(key);}
    }

    public V put(K key, V value) {
        synchronized (mutex) {return m.put(key, value);}
    }
    public V remove(Object key) {
        synchronized (mutex) {return m.remove(key);}
    }
    public void putAll(Map<? extends K, ? extends V> map) {
        synchronized (mutex) {m.putAll(map);}
    }
    public void clear() {
        synchronized (mutex) {m.clear();}
    }

    private transient Set<K> keySet;
    private transient Set<Map.Entry<K,V>> entrySet;
    private transient Collection<V> values;

    public Set<K> keySet() {
        synchronized (mutex) {
            if (keySet==null)
                keySet = new SynchronizedSet<>(m.keySet(), mutex);
            return keySet;
        }
    }

    public Set<Map.Entry<K,V>> entrySet() {
        synchronized (mutex) {
            if (entrySet==null)
                entrySet = new SynchronizedSet<>(m.entrySet(), mutex);
            return entrySet;
        }
    }

    public Collection<V> values() {
        synchronized (mutex) {
            if (values==null)
                values = new SynchronizedCollection<>(m.values(), mutex);
            return values;
        }
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;
        synchronized (mutex) {return m.equals(o);}
    }
    public int hashCode() {
        synchronized (mutex) {return m.hashCode();}
    }
    public String toString() {
        synchronized (mutex) {return m.toString();}
    }

    // Override default methods in Map
    @Override
    public V getOrDefault(Object k, V defaultValue) {
        synchronized (mutex) {return m.getOrDefault(k, defaultValue);}
    }
    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        synchronized (mutex) {m.forEach(action);}
    }
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        synchronized (mutex) {m.replaceAll(function);}
    }
    @Override
    public V putIfAbsent(K key, V value) {
        synchronized (mutex) {return m.putIfAbsent(key, value);}
    }
    @Override
    public boolean remove(Object key, Object value) {
        synchronized (mutex) {return m.remove(key, value);}
    }
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        synchronized (mutex) {return m.replace(key, oldValue, newValue);}
    }
    @Override
    public V replace(K key, V value) {
        synchronized (mutex) {return m.replace(key, value);}
    }
    @Override
    public V computeIfAbsent(K key,
            java.util.function.Function<? super K, ? extends V> mappingFunction) {
        synchronized (mutex) {return m.computeIfAbsent(key, mappingFunction);}
    }
    @Override
    public V computeIfPresent(K key,
            BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        synchronized (mutex) {return m.computeIfPresent(key, remappingFunction);}
    }
    @Override
    public V compute(K key,
            BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        synchronized (mutex) {return m.compute(key, remappingFunction);}
    }
    @Override
    public V merge(K key, V value,
            BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        synchronized (mutex) {return m.merge(key, value, remappingFunction);}
    }

    @java.io.Serial
    private void writeObject(ObjectOutputStream s) throws IOException {
        synchronized (mutex) {s.defaultWriteObject();}
    }
}

static class Lowest<A> {
  A best;
  double score;
  transient Object onChange;
  
  synchronized boolean isNewBest(double score) {
    return best == null || score < this.score;
  }
  
  synchronized double bestScore() {
    return best == null ? Double.NaN : score;
  }
  
  double score() { return bestScore(); }
  
  synchronized float floatScore() {
    return best == null ? Float.NaN : (float) score;
  }
  
  synchronized float floatScoreOr(float defaultValue) {
    return best == null ? defaultValue : (float) score;
  }
  
  boolean put(A a, double score) {
    boolean change = false;
    synchronized(this) {
      if (a != null && isNewBest(score)) {
        best = a;
        this.score = score;
        change = true;
      }
    }
    if (change)
      pcallF(onChange);
    return change;
  }
  
  synchronized void clear() { best = null; score = 0; }
  
  synchronized A get() { return best; }
  synchronized boolean has() { return best != null; }
  synchronized Pair<A, Double> pair() { return best == null ? null : new Pair(best, bestScore()); }
  
  public String toString() {
    return "Score " + formatDouble_significant2(score, 4) + ": " + best;
  }
}
static interface IResourceLoader {
  String loadSnippet(String snippetID);
  String getTranspiled(String snippetID); // with libs
  int getSnippetType(String snippetID);
  String getSnippetTitle(String snippetID);
  File loadLibrary(String snippetID);
  
  //ifndef NoJavaXJar
  default File pathToJavaXJar() { return pathToJavaxJar_noResourceLoader(); }
  //endifndef

  // may return null, then caller compiles themselves
  default File getSnippetJar(String snippetID, String transpiledSrc) { return null; }
}
/*
 * @(#)WeakHashMap.java 1.5 98/09/30
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
 
// From https://github.com/mernst/plume-lib/blob/df0bfafc3c16848d88f4ea0ef3c8bf3367ae085e/java/src/plume/WeakHasherMap.java

static final class WeakHasherMap<K,V> extends AbstractMap<K,V> implements Map<K,V> {

    private Hasher hasher = null;
    /*@Pure*/
    private boolean keyEquals(Object k1, Object k2) {
  return (hasher==null ? k1.equals(k2)
           : hasher.equals(k1, k2));
    }
    /*@Pure*/
    private int keyHashCode(Object k1) {
  return (hasher==null ? k1.hashCode()
           : hasher.hashCode(k1));
    }

    // The WeakKey class can't be static because it depends on the hasher.
    // That in turn means that its methods can't be static.
    // However, I need to be able to call the methods such as create() that
    // were static in the original version of this code.
    // This finesses that.

    private /*@Nullable*/ WeakKey WeakKeyCreate(K k) {
  if (k == null) return null;
  else return new WeakKey(k);
    }
    private /*@Nullable*/ WeakKey WeakKeyCreate(K k, ReferenceQueue<? super K> q) {
  if (k == null) return null;
  else return new WeakKey(k, q);
    }

    // Cannot be a static class: uses keyHashCode() and keyEquals()
    private final class WeakKey extends WeakReference<K> {
  private int hash; /* Hashcode of key, stored here since the key
           may be tossed by the GC */

  private WeakKey(K k) {
      super(k);
      hash = keyHashCode(k);
  }

  private /*@Nullable*/ WeakKey create(K k) {
      if (k == null) return null;
      else return new WeakKey(k);
  }

  private WeakKey(K k, ReferenceQueue<? super K> q) {
      super(k, q);
      hash = keyHashCode(k);
  }

  private /*@Nullable*/ WeakKey create(K k, ReferenceQueue<? super K> q) {
      if (k == null) return null;
      else return new WeakKey(k, q);
  }

        /* A WeakKey is equal to another WeakKey iff they both refer to objects
     that are, in turn, equal according to their own equals methods */
  /*@Pure*/
  @Override
  public boolean equals(/*@Nullable*/ Object o) {
            if (o == null) return false; // never happens
      if (this == o) return true;
            // This test is illegal because WeakKey is a generic type,
            // so use the getClass hack below instead.
      // if (!(o instanceof WeakKey)) return false;
            if (!(o.getClass().equals(WeakKey.class))) return false;
      Object t = this.get();
            @SuppressWarnings("unchecked")
      Object u = ((WeakKey)o).get();
      if ((t == null) || (u == null)) return false;
      if (t == u) return true;
      return keyEquals(t, u);
  }

  /*@Pure*/
  @Override
  public int hashCode() {
      return hash;
  }

    }


    /* Hash table mapping WeakKeys to values */
    private HashMap<WeakKey,V> hash;

    /* Reference queue for cleared WeakKeys */
    private ReferenceQueue<? super K> queue = new ReferenceQueue<K>();


    /* Remove all invalidated entries from the map, that is, remove all entries
       whose keys have been discarded.  This method should be invoked once by
       each public mutator in this class.  We don't invoke this method in
       public accessors because that can lead to surprising
       ConcurrentModificationExceptions. */
    @SuppressWarnings("unchecked")
    private void processQueue() {
  WeakKey wk;
  while ((wk = (WeakKey)queue.poll()) != null) { // unchecked cast
      hash.remove(wk);
  }
    }


    /* -- Constructors -- */

    /**
     * Constructs a new, empty <code>WeakHashMap</code> with the given
     * initial capacity and the given load factor.
     *
     * @param  initialCapacity  the initial capacity of the
     *                          <code>WeakHashMap</code>
     *
     * @param  loadFactor       the load factor of the <code>WeakHashMap</code>
     *
     * @throws IllegalArgumentException  If the initial capacity is less than
     *                                   zero, or if the load factor is
     *                                   nonpositive
     */
    public WeakHasherMap(int initialCapacity, float loadFactor) {
  hash = new HashMap<WeakKey,V>(initialCapacity, loadFactor);
    }

    /**
     * Constructs a new, empty <code>WeakHashMap</code> with the given
     * initial capacity and the default load factor, which is
     * <code>0.75</code>.
     *
     * @param  initialCapacity  the initial capacity of the
     *                          <code>WeakHashMap</code>
     *
     * @throws IllegalArgumentException  If the initial capacity is less than
     *                                   zero
     */
    public WeakHasherMap(int initialCapacity) {
  hash = new HashMap<WeakKey,V>(initialCapacity);
    }

    /**
     * Constructs a new, empty <code>WeakHashMap</code> with the default
     * capacity and the default load factor, which is <code>0.75</code>.
     */
    public WeakHasherMap() {
  hash = new HashMap<WeakKey,V>();
    }

    /**
     * Constructs a new, empty <code>WeakHashMap</code> with the default
     * capacity and the default load factor, which is <code>0.75</code>.
     * The <code>WeakHashMap</code> uses the specified hasher for hashing
     * keys and comparing them for equality.
     * @param h the Hasher to use when hashing values for this map
     */
    public WeakHasherMap(Hasher h) {
  hash = new HashMap<WeakKey,V>();
  hasher = h;
    }


    /* -- Simple queries -- */

    /**
     * Returns the number of key-value mappings in this map.
     * <strong>Note:</strong> <em>In contrast to most implementations of the
     * <code>Map</code> interface, the time required by this operation is
     * linear in the size of the map.</em>
     */
    /*@Pure*/
    @Override
    public int size() {
  return entrySet().size();
    }

    /**
     * Returns <code>true</code> if this map contains no key-value mappings.
     */
    /*@Pure*/
    @Override
    public boolean isEmpty() {
  return entrySet().isEmpty();
    }

    /**
     * Returns <code>true</code> if this map contains a mapping for the
     * specified key.
     *
     * @param   key   the key whose presence in this map is to be tested
     */
    /*@Pure*/
    @Override
    public boolean containsKey(Object key) {
        @SuppressWarnings("unchecked")
        K kkey = (K) key;
  return hash.containsKey(WeakKeyCreate(kkey));
    }


    /* -- Lookup and modification operations -- */

    /**
     * Returns the value to which this map maps the specified <code>key</code>.
     * If this map does not contain a value for this key, then return
     * <code>null</code>.
     *
     * @param  key  the key whose associated value, if any, is to be returned
     */
    /*@Pure*/
    @Override
    public /*@Nullable*/ V get(Object key) {  // type of argument is Object, not K
        @SuppressWarnings("unchecked")
        K kkey = (K) key;
  return hash.get(WeakKeyCreate(kkey));
    }

    /**
     * Updates this map so that the given <code>key</code> maps to the given
     * <code>value</code>.  If the map previously contained a mapping for
     * <code>key</code> then that mapping is replaced and the previous value is
     * returned.
     *
     * @param  key    the key that is to be mapped to the given
     *                <code>value</code>
     * @param  value  the value to which the given <code>key</code> is to be
     *                mapped
     *
     * @return  the previous value to which this key was mapped, or
     *          <code>null</code> if if there was no mapping for the key
     */
    @Override
    public V put(K key, V value) {
  processQueue();
  return hash.put(WeakKeyCreate(key, queue), value);
    }

    /**
     * Removes the mapping for the given <code>key</code> from this map, if
     * present.
     *
     * @param  key  the key whose mapping is to be removed
     *
     * @return  the value to which this key was mapped, or <code>null</code> if
     *          there was no mapping for the key
     */
    @Override
    public V remove(Object key) { // type of argument is Object, not K
  processQueue();
        @SuppressWarnings("unchecked")
        K kkey = (K) key;
  return hash.remove(WeakKeyCreate(kkey));
    }

    /**
     * Removes all mappings from this map.
     */
    @Override
    public void clear() {
  processQueue();
  hash.clear();
    }


    /* -- Views -- */


    /* Internal class for entries */
    // This can't be static, again because of dependence on hasher.
    @SuppressWarnings("TypeParameterShadowing")
    private final class Entry<K,V> implements Map.Entry<K,V> {
  private Map.Entry<WeakKey,V> ent;
  private K key;  /* Strong reference to key, so that the GC
           will leave it alone as long as this Entry
           exists */

  Entry(Map.Entry<WeakKey,V> ent, K key) {
      this.ent = ent;
      this.key = key;
  }

  /*@Pure*/
  @Override
  public K getKey() {
      return key;
  }

  /*@Pure*/
  @Override
  public V getValue() {
      return ent.getValue();
  }

  @Override
  public V setValue(V value) {
      return ent.setValue(value);
  }

        /*@Pure*/
        private boolean keyvalEquals(K o1, K o2) {
      return (o1 == null) ? (o2 == null) : keyEquals(o1, o2);
  }

        /*@Pure*/
        private boolean valEquals(V o1, V o2) {
      return (o1 == null) ? (o2 == null) : o1.equals(o2);
  }

        /*@Pure*/
        @SuppressWarnings("NonOverridingEquals")
        public boolean equals(Map.Entry<K,V> e /* Object o*/) {
            // if (! (o instanceof Map.Entry)) return false;
            // Map.Entry<K,V> e = (Map.Entry<K,V>)o;
      return (keyvalEquals(key, e.getKey())
        && valEquals(getValue(), e.getValue()));
  }

  /*@Pure*/
  @Override
  public int hashCode() {
      V v;
      return (((key == null) ? 0 : keyHashCode(key))
        ^ (((v = getValue()) == null) ? 0 : v.hashCode()));
  }

    }


    /* Internal class for entry sets */
    private final class EntrySet extends AbstractSet<Map.Entry<K,V>> {
  Set<Map.Entry<WeakKey,V>> hashEntrySet = hash.entrySet();

  @Override
  public Iterator<Map.Entry<K,V>> iterator() {

      return new Iterator<Map.Entry<K,V>>() {
    Iterator<Map.Entry<WeakKey,V>> hashIterator = hashEntrySet.iterator();
    Map.Entry<K,V> next = null;

    @Override
    public boolean hasNext() {
        while (hashIterator.hasNext()) {
      Map.Entry<WeakKey,V> ent = hashIterator.next();
      WeakKey wk = ent.getKey();
      K k = null;
      if ((wk != null) && ((k = wk.get()) == null)) {
          /* Weak key has been cleared by GC */
          continue;
      }
      next = new Entry<K,V>(ent, k);
      return true;
        }
        return false;
    }

    @Override
    public Map.Entry<K,V> next() {
        if ((next == null) && !hasNext())
      throw new NoSuchElementException();
        Map.Entry<K,V> e = next;
        next = null;
        return e;
    }

    @Override
    public void remove() {
        hashIterator.remove();
    }

      };
  }

  /*@Pure*/
  @Override
  public boolean isEmpty() {
      return !(iterator().hasNext());
  }

  /*@Pure*/
  @Override
  public int size() {
      int j = 0;
      for (Iterator<Map.Entry<K,V>> i = iterator(); i.hasNext(); i.next()) j++;
      return j;
  }

  @Override
  public boolean remove(Object o) {
      processQueue();
      if (!(o instanceof Map.Entry<?,?>)) return false;
            @SuppressWarnings("unchecked")
      Map.Entry<K,V> e = (Map.Entry<K,V>)o; // unchecked cast
      Object ev = e.getValue();
      WeakKey wk = WeakKeyCreate(e.getKey());
      Object hv = hash.get(wk);
      if ((hv == null)
    ? ((ev == null) && hash.containsKey(wk)) : hv.equals(ev)) {
    hash.remove(wk);
    return true;
      }
      return false;
  }

  /*@Pure*/
  @Override
  public int hashCode() {
      int h = 0;
      for (Iterator<Map.Entry<WeakKey,V>> i = hashEntrySet.iterator(); i.hasNext(); ) {
    Map.Entry<WeakKey,V> ent = i.next();
    WeakKey wk = ent.getKey();
    Object v;
    if (wk == null) continue;
    h += (wk.hashCode()
          ^ (((v = ent.getValue()) == null) ? 0 : v.hashCode()));
      }
      return h;
  }

    }


    private /*@Nullable*/ Set<Map.Entry<K,V>> entrySet = null;

    /**
     * Returns a <code>Set</code> view of the mappings in this map.
     */
    /*@SideEffectFree*/
    @Override
    public Set<Map.Entry<K,V>> entrySet() {
  if (entrySet == null) entrySet = new EntrySet();
  return entrySet;
    }

    // find matching key
    K findKey(Object key) {
      processQueue();
      K kkey = (K) key;
      // TODO: use replacement for HashMap to avoid reflection
      WeakKey wkey = WeakKeyCreate(kkey);
      WeakKey found = hashMap_findKey(hash, wkey);
      return found == null ? null : found.get();
    }
}
static class proxy_InvocationHandler implements InvocationHandler {
  Object target;
  
  proxy_InvocationHandler() {}
  proxy_InvocationHandler(Object target) {
  this.target = target;}
  
  public Object invoke(Object proxy, Method method, Object[] args) {
    return call(target, method.getName(), unnull(args));
  }
}
static class Pair<A, B> implements Comparable<Pair<A, B>> {
  A a;
  B b;

  Pair() {}
  Pair(A a, B b) {
  this.b = b;
  this.a = a;}
  
  public int hashCode() {
    return hashCodeFor(a) + 2*hashCodeFor(b);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof Pair)) return false;
    Pair t = (Pair) o;
    return eq(a, t.a) && eq(b, t.b);
  }
  
  public String toString() {
    return "<" + a + ", " + b + ">";
  }
  
  public int compareTo(Pair<A, B> p) {
    if (p == null) return 1;
    int i = ((Comparable<A>) a).compareTo(p.a);
    if (i != 0) return i;
    return ((Comparable<B>) b).compareTo(p.b);
  }
}
static class CompilerBot {
  static boolean verbose = false;

  static File compileSnippet(String snippetID) {
    return compileSnippet(snippetID, "");
  }
  
  static Pair<File, String> compileSnippet2(String snippetID) {
    return compileSnippet2(snippetID, "");
  }
  
  // returns jar path
  static File compileSnippet(String snippetID, String javaTarget) {
    return compileSnippet2(snippetID, javaTarget).a;
  }
  
  // returns jar path, Java source
  static Pair<File, String> compileSnippet2(String snippetID, String javaTarget) {
    String transpiledSrc = getServerTranspiled2(snippetID);
    if (transpiledSrc == null) throw fail("Snippet not found or not public: " + snippetID);
    int i = transpiledSrc.indexOf('\n');
    String libs = transpiledSrc.substring(0, Math.max(0, i));
    if (verbose)
      print("Compiling snippet: " + snippetID + ". Libs: " + libs);
    transpiledSrc = transpiledSrc.substring(i+1);
    return pair(compile(transpiledSrc, libs, javaTarget, snippetID), transpiledSrc);
  }

  static File compile(String src) {
    return compile(src, "");
  }
  
  static File compile(String src, String libs) {
    return compile(src, libs, null);
  }

  static File compile(String src, String dehlibs, String javaTarget) {
    return compile(src, dehlibs, javaTarget, null);
  }
  
  static File compile(String src, String dehlibs, String javaTarget, String progID) {
    if (verbose)
      print("Compiling " + l(src) + " chars");
      
    // Note: This is different from the calculation in x30
    // (might lead to programs being compiled twice)
    String md5 = md5(dehlibs + "\n" + src + "\n" + fsIOpt(progID));
    File jar = getJarFile(md5);
    if (jar == null || jar.length() <= 22) {
      // have to compile
      
      //print("Have to compile: " + progID + " / " + md5);
      
      List<String> tok = javaTok(src);
      List<String> mainClass = findMainClass(tok);
      boolean canRename = mainClass != null && useDummyMainClasses() && isSnippetID(progID) && !tok_classHasModifier(mainClass, "public");
      if (verbose)
        print("useRenaming: " + useDummyMainClasses() + ", canRename: " + canRename + ", progID: " + progID);
        
      String mainClassName = joinNemptiesWithDot(tok_packageName(tok), or(getClassDeclarationName(mainClass), "main"));
      
       AutoCloseable __1 = tempSetTL(javaCompileToJar_addMoreFiles, 
        dir -> {
          if (!eq(mainClassName, "main"))
            saveTextFile(newFile(dir, "main-class"), mainClassName);
          saveTextFile(newFile(dir, manifestPathInJar()), manifestTextForMainClass(mainClassName));
        }); try {

      javaCompileToJar_optionalRename(src, dehlibs, jar, canRename ? progID : null, progID);
    } finally { _close(__1); }} else {
      if (verbose)
        print("Getting classes from cache (" + jar.getAbsolutePath() + ", " + jar.length() + " bytes)");
      touchFile(jar); // so we can find the unused ones easier
    }
    
    return jar;
  }

  // look in non-virtual JavaX-Caches first (important for packaged programs)
  // Edit: Huh? This is strange.
  static File getJarFile(String md5) {
    assertTrue(isMD5(md5));
    String fileName = md5 + ".jar";
    File f = newFile(destDir(), fileName);
    return fileExists(f) ? f : userDir(appendSlash(compilerBotDestDirSubName()) + fileName);
  }
  
  /*swappable*/ static File destDir() {
    return compilerBotDestDir();
  }
}
static interface IResourceHolder {
  <A extends AutoCloseable> A add(A a);
  Collection<AutoCloseable> takeAll();
}
// progID is just for information
static class JavaXClassLoader extends URLClassLoader {
  String progID;
  Set<File> files = syncLinkedHashSet();
  Set<String> libraryIDs = syncLinkedHashSet();
  Set<String> triedToLoad = synchroSet();
  Set<Class> loadedClasses = synchroSet();
  boolean retired = false;
  Object retiredMarker;
  IF1<String, Class> findClass_extension;
  String mainClassName;
  boolean verbose = false;
  
  JavaXClassLoader(String progID, List<File> files) {
    this(progID, files, getSystemClassLoader());
  }
  
  JavaXClassLoader(String progID, List<File> files, ClassLoader parent) {
    // sadly can't see this constructor
    //super(progID, new URL[0], parent, vm_globalACC());
    super(new URL[0], parent);
    this.progID = progID;

    for (File f : unnullForIteration(files))
      addFile(f);
      
    // TODO: how to get around this
    fixACCInClassLoader(this);
  }
  
  Class<?> super_findClass(String name) throws ClassNotFoundException {
    return super.findClass(name);
  }
  
  protected Class<?> findClass(String name) throws ClassNotFoundException {
    if (verbose) System.out.println(this + " findClass: " + name);
    if (findClass_extension != null) {
      Class<?> c = findClass_extension.get(name);
      if (verbose) System.out.println("extension returned: " + c);
      if (c != null) return c;
    }
    boolean triedBefore = !triedToLoad.add(name);
    try {
      Class<?> c = super.findClass(name);
      if (verbose) System.out.println("super.findClass returned: " + c);
      loadedClasses.add(c);
      if (eq(name, mainClassName()))
        callOpt(javax(), "registerAMainClass", c);
      return c;
    } catch (ClassNotFoundException e) {
      if (verbose) System.out.println(getStackTrace(e));
      throw new ClassNotFoundException("Class " + name + " not found in " + joinWithComma(map(__51 -> f2s(__51), files)) + " (progID=" + progID + ")"
        + (triedBefore ? ", tried to load before" : ""), e);
    }
  }
  
  public String toString() {
    return shortClassName(this) + "[" + systemHashCodeHex(this) + "] - " + progID;
  }
  
  String mainClassName() {
    if (mainClassName == null) {
      mainClassName = "main";
      try {
        mainClassName = or2(trim(loadTextFileResource(this, "main-class")), mainClassName);
      } catch (Throwable __e) { printStackTrace(__e); }
    }
    return mainClassName;
  }
  
  boolean addFile(File f, String libraryID) {
    if (nempty(libraryID))
      if (!libraryIDs.add(libraryID))
        return false;
    return addFile(f);
  }
  
  boolean addFile(File f) { try {
    if (!files.add(f)) return false;
    addURL(f.toURI().toURL());
    mainClassName(); // calculate early. no good loading text files later
    return true;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  Set<String> libraryIDs() { return libraryIDs; }
  
  boolean hasLibraryID(String libraryID) { return libraryIDs.contains(libraryID); }
  
  protected transient  IF1<String, String> findLibrary;
protected String findLibrary(String libname) { return findLibrary != null ? findLibrary.get(libname) : findLibrary_base(libname); }
final protected String findLibrary_fallback(IF1<String, String> _f, String libname) { return _f != null ? _f.get(libname) : findLibrary_base(libname); }
protected String findLibrary_base(String libname) { return super.findLibrary(libname); }
  
  // make public
  public void addURL(URL url) {
    super.addURL(url);
  }
}
static abstract class DialogIO implements AutoCloseable {
  String line;
  boolean eos, loud, noClose;
  Lock lock = lock();
  
  abstract String readLineImpl();
  abstract boolean isStillConnected();
  abstract void sendLine(String line);
  abstract boolean isLocalConnection();
  abstract Socket getSocket();

  int getPort() { Socket s = getSocket(); return s == null ? 0 : s.getPort(); }
  
  boolean helloRead = false;
  int shortenOutputTo = 500;
  
  String readLineNoBlock() {
    String l = line;
    line = null;
    return l;
  }
  
  boolean waitForLine() { try {
    ping();
    if (line != null) return true;
    //print("Readline");
    line = readLineImpl();
    //print("Readline done: " + line);
    if (line == null) eos = true;
    return line != null;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLine() {
    waitForLine();
    helloRead = true;
    return readLineNoBlock();
  }
  
  String ask(String s, Object... args) {
    if (loud) return askLoudly(s, args);
    if (!helloRead) readLine();
    if (args.length != 0) s = format3(s, args);
    sendLine(s);
    return readLine();
  }
  
  String askLoudly(String s, Object... args) {
    if (!helloRead) readLine();
    if (args.length != 0) s = format3(s, args);
    print("> " + shorten(s, shortenOutputTo));
    sendLine(s);
    String answer = readLine();
    print("< " + shorten(answer, shortenOutputTo));
    return answer;
  }
  
  void pushback(String l) {
    if (line != null)
      throw fail();
    line = l;
    helloRead = false;
  }
}

static abstract class DialogHandler {
  abstract void run(DialogIO io);
}
static class JavaXClassLoaderWithParent extends JavaXClassLoader {
  ClassLoader virtualParent;

  JavaXClassLoaderWithParent(String progID, List<File> files, ClassLoader virtualParent) {
    super(progID, files);
    this.virtualParent = virtualParent;
  }
  
  protected Class<?> findClass(String name) throws ClassNotFoundException {
    if (virtualParent != null && !eq(name, "main") && !name.startsWith("main$")) {
      try {
        return virtualParent.loadClass(name);
      } catch (ClassNotFoundException e) {}
    }
    return super.findClass(name);
  }
  
  public URL findResource(String name) {
    if (virtualParent != null) {
      URL url = virtualParent.getResource(name);
      if (url != null) return url;
    }
    return super.findResource(name);
  }
  
  ClassLoader getVirtualParent() { return virtualParent; }
}
    
// elements are put to front when added (not when accessed)
static class MRUCache<A, B> extends LinkedHashMap<A, B> {
  int maxSize = 10;

  MRUCache() {}
  MRUCache(int maxSize) {
  this.maxSize = maxSize;}
  
  protected boolean removeEldestEntry(Map.Entry eldest) {
    return size() > maxSize;
  }
  
  Object _serialize() {
    return ll(maxSize, cloneLinkedHashMap(this));
  }
  
  static MRUCache _deserialize(List l) {
    MRUCache m = new MRUCache();
    m.maxSize = (int) first(l);
    m.putAll((LinkedHashMap) second(l));
    return m;
  }
}
static class JavaXClassLoaderWithParent2 extends JavaXClassLoader {
  ClassLoader virtualParent;
  List<String> classesToSkip; // classes that should be taken from parent

  JavaXClassLoaderWithParent2(String progID, List<File> files, ClassLoader virtualParent, List<String> classesToSkip) {
    super(progID, files);
    this.virtualParent = virtualParent;
    this.classesToSkip = classesToSkip;
  }
  
  protected Class<?> findClass(String name) throws ClassNotFoundException {
    if (shouldDelegate(name)) {
      Class<?> c = virtualParent.loadClass(name);
      if (c != null) return c;
    }
    return super.findClass(name);
  }
    
  boolean shouldDelegate(String name) {
    for (String s : classesToSkip)
      if (eq(name, s) || startsWith(name, s + "$"))
        return true;
    return false;
  }
}

static class PersistableThrowable extends DynamicObject {
  String className;
  String msg;
  String stacktrace;
  
  PersistableThrowable() {}
  PersistableThrowable(Throwable e) {
    if (e == null)
      className = "Crazy Null Error";
    else {
      className = getClassName(e).replace('/', '.');
      msg = e.getMessage();
      stacktrace = getStackTrace_noRecord(e);
    }
  }
  
  public String toString() {
    return nempty(msg) ? className + ": " + msg : className;
  }
  
  RuntimeException asRuntimeException() {
    return new Fail(this);
  }
}
static class SynchronizedSortedMap<K,V>
    extends SynchronizedMap<K,V>
    implements SortedMap<K,V>
{
  SynchronizedSortedMap() {}
    SortedMap<K, V> innerMap() { return (SortedMap) m; }

    SynchronizedSortedMap(SortedMap<K,V> m) {
        super(m);
    }
    SynchronizedSortedMap(SortedMap<K,V> m, Object mutex) {
        super(m, mutex);
    }

    public Comparator<? super K> comparator() {
        synchronized (mutex) {return innerMap().comparator();}
    }

    public SortedMap<K,V> subMap(K fromKey, K toKey) {
        synchronized (mutex) {
            return new SynchronizedSortedMap<>(
                innerMap().subMap(fromKey, toKey), mutex);
        }
    }
    public SortedMap<K,V> headMap(K toKey) {
        synchronized (mutex) {
            return new SynchronizedSortedMap<>(innerMap().headMap(toKey), mutex);
        }
    }
    public SortedMap<K,V> tailMap(K fromKey) {
        synchronized (mutex) {
           return new SynchronizedSortedMap<>(innerMap().tailMap(fromKey),mutex);
        }
    }

    public K firstKey() {
        synchronized (mutex) {return innerMap().firstKey();}
    }
    public K lastKey() {
        synchronized (mutex) {return innerMap().lastKey();}
    }
}



static class PingSourceCancelledException extends RuntimeException implements IFieldsToList{
  PingSource pingSource;
  PingSourceCancelledException() {}
  PingSourceCancelledException(PingSource pingSource) {
  this.pingSource = pingSource;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + pingSource + ")"; }public Object[] _fieldsToList() { return new Object[] {pingSource}; }

}
// uses hash sets as inner sets unless subclassed
// uses a hash map as the outer map by default
static class MultiSetMap<A, B>implements IMultiMap<A, B> {
  Map<A, Set<B>> data = new HashMap<A, Set<B>>();
  int size; // number of values
  
  MultiSetMap() {}
  MultiSetMap(boolean useTreeMap) { if (useTreeMap) data = new TreeMap(); }
  MultiSetMap(MultiSetMap<A, B> map) { putAll(map); }
  MultiSetMap(Map<A, Set<B>> data) {
  this.data = data;}

  boolean put(A key, B value) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set == null)
      data.put(key, set = _makeEmptySet());
    if (!set.add(value)) return false;
    { ++size; return true; }
  }}

  boolean add(A key, B value) { return put(key, value); }

  void addAll(A key, Collection<B> values) { synchronized(data) {
    putAll(key, values);
  }}
  
  void addAllIfNotThere(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      setPut(key, value);
  }}
  
  void setPut(A key, B value) { synchronized(data) {
    if (!containsPair(key, value))
      put(key, value);
  }}
  
  final boolean contains(A key, B value){ return containsPair(key, value); }
boolean containsPair(A key, B value) { synchronized(data) {
    return get(key).contains(value);
  }}
  
  void putAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      put(key, value);
  }}

  void removeAll(A key, Collection<B> values) { synchronized(data) {
    for (B value : values)
      remove(key, value);
  }}
  
  public Set<B> get(A key) { synchronized(data) {
    Set<B> set = data.get(key);
    return set == null ? Collections.<B> emptySet() : set;
  }}
  
  List<B> getAndClear(A key) { synchronized(data) {
    List<B> l = cloneList(data.get(key));
    remove(key);
    return l;
  }}

  // return null if empty
  Set<B> getOpt(A key) { synchronized(data) {
    return data.get(key);
  }}

  // returns actual mutable live set
  // creates the set if not there
  Set<B> getActual(A key) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set == null)
      data.put(key, set = _makeEmptySet());
    return set;
  }}
 
  // TODO: this looks unnecessary
  void clean(A key) { synchronized(data) {
    Set<B> list = data.get(key);
    if (list != null && list.isEmpty())
      data.remove(key);
  }}

  final public Set<A> keys(){ return keySet(); }
public Set<A> keySet() { synchronized(data) {
    return data.keySet();
  }}

  void remove(A key) { synchronized(data) {
    size -= l(data.get(key));
    data.remove(key);
  }}

  void remove(A key, B value) { synchronized(data) {
    Set<B> set = data.get(key);
    if (set != null) {
      if (set.remove(value)) {
        --size;
        if (set.isEmpty())
          data.remove(key);
      }
    }
  }}

  void clear() { synchronized(data) {
    data.clear();
    size = 0;
  }}

  boolean containsKey(A key) { synchronized(data) {
    return data.containsKey(key);
  }}

  B getFirst(A key) { synchronized(data) {
    return first(get(key));
  }}
  
  void addAll(MultiSetMap<A, B> map) { putAll(map); }
  
  void putAll(MultiSetMap<A, B> map) { synchronized(data) {
    for (A key : map.keySet())
      putAll(key, map.get(key));
  }}
  
  void putAll(Map<A, B> map) { synchronized(data) {
    if (map != null) for (Map.Entry<A, B> e : map.entrySet())
      put(e.getKey(), e.getValue());
  }}
  
  final public int keyCount(){ return keysSize(); }
public int keysSize() { synchronized(data) { return l(data); }}
  
  // full size
  public int size() { synchronized(data) {
    return size;
  }}
  
  // count values for key
  int getSize(A key) { return l(data.get(key)); }
  int count(A key) { return getSize(key); }
  
  // expensive operation
  Set<A> reverseGet(B b) { synchronized(data) {
    Set<A> l = new HashSet();
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        l.add(key);
    return l;
  }}
  
  // expensive operation
  A keyForValue(B b) { synchronized(data) {
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        return key;
    return null;
  }}
  
  Map<A, Set<B>> asMap() { synchronized(data) {
    return cloneMap(data);
  }}
  
  boolean isEmpty() { synchronized(data) { return data.isEmpty(); }}
  
  // override in subclasses
  Set<B> _makeEmptySet() {
    return new HashSet();
  }
  
  Collection<Set<B>> allLists() {
    synchronized(data) {
      return new HashSet(data.values());
    }
  }
  
  List<B> allValues() {
    return concatLists(values(data));
  }
  
  List<Pair<A, B>> allEntries() { synchronized(data) {
    List<Pair<A, B>> l = emptyList(size);
    for (Map.Entry<? extends A, ? extends Set<B>> __0 : _entrySet( data))
      { A a = __0.getKey(); Set<B> set = __0.getValue();  for (B b : set)
        l.add(pair(a, b)); }
    return l;
  }}
  
  Object mutex() { return data; }
  
  public String toString() { return "mm" + str(data); }
  
  Pair<A, B> firstEntry() { synchronized(data) {
    if (empty(data)) return null;
    Map.Entry<A, Set<B>> entry = data.entrySet().iterator().next();
    return pair(entry.getKey(), first(entry.getValue()));
  }}
  
  A firstKey() { synchronized(data) { return main.firstKey(data); }}
  A lastKey() { synchronized(data) { return (A) ((NavigableMap) data).lastKey(); }}
  
  A higherKey(Object a) { synchronized(data) { return (A) ((NavigableMap) data).higherKey(a); }}
}
static class MinimalChain<A> implements Iterable<A> {
  A element;
  MinimalChain<A> next;

  MinimalChain() {}
  MinimalChain(A element) {
  this.element = element;}
  MinimalChain(A element, MinimalChain<A> next) {
  this.next = next;
  this.element = element;}
  
  public String toString() { return str(toList()); }
  
  ArrayList<A> toList() {
    ArrayList<A> l = new ArrayList();
    MinimalChain<A> c = this;
    while (c != null) {
      l.add(c.element);
      c = c.next;
    }
    return l;
  }
  
  void setElement(A a) { element = a; }
  void setNext(MinimalChain<A> next) { this.next = next; }
  
  // TODO: optimize
  public Iterator<A> iterator() { return toList().iterator(); }
  
  A get() { return element; }
}
// the lockFile must be a file separate from any data files.
// It is created & deleted by this class, and will always have
// size 0.
static class FileBasedLock implements AutoCloseable {
  File lockFile;
  double timeout = 60.0; // in seconds. refresh happens twice as often
  boolean verbose = false;
  boolean haveLock = false;
  java.util.Timer touchTimer;
  
  FileBasedLock() {}
  FileBasedLock(File lockFile) {
  this.lockFile = lockFile;}
  FileBasedLock(File lockFile, double timeout) {
  this.timeout = timeout;
  this.lockFile = lockFile;}
  
  // returns true iff lock was acquired (or kept)
  synchronized boolean tryToLock() {
    if (haveLock) return true;
    
    if (fileExists(lockFile)) {
      double age = fileAgeInSeconds(lockFile);
      double remaining = timeout-age;
      print("Lock file age: " + lockFile + ": " + iround(age) + " s"
        + (remaining <= 0 ? " - old, deleting" : "- please start again in " + nSeconds(iceil(remaining))));
        
      if (remaining <= 0) {
        print("Deleting old lock file (program crashed?): " + lockFile + " (age: " + iround(age) + " seconds)");
        deleteFile(lockFile);
      }
    }
    
    try {
      mkdirsForFile(lockFile);
      java.nio.file.Files.createFile(toPath(lockFile));
      acquired();
      return true;
    } catch (Throwable e) {
      printExceptionShort("Can't lock", e);
      return false;
    }
  }
  
  private void acquired() {
    haveLock = true;
    startTouchTimer();
  }
  
  void forceLock() { try {
    print("Force-locking " + lockFile);
    touchFile(lockFile); // make or touch file
    acquired();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String lockError() {
    return "Couldn't aquire lock file: " + lockFile;
  }
  
  void lockOrFail() {
    if (!tryToLock())
      throw fail(lockError());
  }
  
  synchronized void startTouchTimer() {
    if (touchTimer != null) return;
    double interval = timeout/2;
    touchTimer = doEvery(interval, new Runnable() {  public void run() { try {  doTouch(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "doTouch();"; }});
    if (verbose) print("Touch timer started for " + lockFile +  " (" + interval + "s)");
  }

  synchronized void doTouch() { try {
    if (haveLock) {
      if (verbose) print("Touching lock file: " + lockFile);
      touchExistingFile(lockFile);
    }
  } catch (Throwable __e) { printStackTrace(__e); }}
     
  public synchronized void close() { try {
    { cleanUp(touchTimer); touchTimer = null; }
    if (haveLock) {
      haveLock = false;
      if (verbose) print("Deleting lock file: " + lockFile);
      deleteFile(lockFile);
    }
  } catch (Throwable __e) { printStackTrace(__e); }}
  
  synchronized void _simulateCrash() {
    { cleanUp(touchTimer); touchTimer = null; }
  }
  
  void deleteOnExit() {
    if (haveLock)
      lockFile.deleteOnExit();
  }
}
static interface ISetter<A> {
 void set(A a);
}

static interface IConceptCounter {
  Class<? extends Concept> conceptClass();
  int countConcepts();
  Collection<Concept> allConcepts();
}
// The idea is to leave max as the actual number of cores the system
// has (numberOfCores()), and in case of being fully booked, raise an
// alert (customerMustWaitAlert) which can be handled by a strategy
// object (different reactions are possible).
// If nothing is done in such an event, clients are processed serially
// (no guarantees of order), split up among the available threads.

/* SYNChronisation order:
      1. PooledThread
      2. ThreadPool */

static class ThreadPool implements AutoCloseable {
  int max = numberOfCores();
  List<PooledThread> all = new ArrayList();
  Set<PooledThread> used = new HashSet();
  Set<PooledThread> free = new HashSet();
  boolean verbose, retired;
  
  // our own ping surce so we can start threads & keep them running
  class InternalPingSource extends PingSource {}
  InternalPingSource internalPingSource = new InternalPingSource();
  
  MultiSleeper sleeper = new MultiSleeper();
  
  ThreadPool() {}
  ThreadPool(int max) {
  this.max = max;}
  
  synchronized int maxSize() { return max; }
  synchronized int total() { return l(used)+l(free); }
  
  transient Set<Runnable> onCustomerMustWaitAlert;
public ThreadPool onCustomerMustWaitAlert(Runnable r) { onCustomerMustWaitAlert = createOrAddToSyncLinkedHashSet(onCustomerMustWaitAlert, r); return this; }
public ThreadPool removeCustomerMustWaitAlertListener(Runnable r) { main.remove(onCustomerMustWaitAlert, r); return this; }
public void customerMustWaitAlert() {  if (onCustomerMustWaitAlert != null) for (var listener : onCustomerMustWaitAlert) pcallF_typed(listener); }
  
  void fireCustomerMustWaitAlert() {
    vmBus_send("customerMustWaitAlert", this, currentThread());
    customerMustWaitAlert();
  }

  // DOESN'T WAIT. adds action to a thread's queue if nothing is
  // available immediately.
  PooledThread acquireThreadOrQueue(Runnable action) {
    if (action == null) return null;
    PooledThread t;
    synchronized(this) {
      if (_hasFreeAfterCreating()) {
        t = _firstFreeThread();
        markUsed(t);
      } else
        t = _anyThread();
    }
    
    t.addWork(action); // will move it from free to used
    return t;
  }
  
  // run in synchronized block
  boolean _hasFreeAfterCreating() {
    checkNotRetired();
    if (nempty(free)) return true;
    if (total() < max) {
      PooledThread t = newThread();
      all.add(t);
      free.add(t);
      return true;
    }
    return false;
  }
  
  // WAITS until thread is available
  PooledThread acquireThreadOrWait(Runnable action) { try {
    if (action == null) return null;
    PooledThread t;
    while (true) {
      synchronized(this) {
        if (_hasFreeAfterCreating()) {
          t = _firstFreeThread();
          break;
        } else
          _waitWaitWait();
      }
    }
    t.addWork(action);
    return t;
  } catch (Exception __e) { throw rethrow(__e); } }
  
  PooledThread _firstFreeThread() {
    return first(free);
  }
  
  PooledThread _anyThread() {
    return random(used);
  }
  
  class PooledThread extends Thread {
    PooledThread(String name) { super(name); }
    
    AppendableChain<Runnable> q;
    
    synchronized Runnable _grabWorkOrSleep() { try {
      Runnable r = first(q);
      if (r == null) {
        markFree(this);
        if (verbose) print("Thread sleeps");
        synchronized(this) { wait(); }
        if (verbose) print("Thread woke up");
        return null;
      }
      q = popFirst(q);
      return r;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    public void run() { try {
      pingSource_tl().set(internalPingSource);
      while  (!retired()) { ping(); 
        Runnable r = _grabWorkOrSleep();
        if (verbose) print(this + " work: " + r);
        if (r != null)
          try {
            if (verbose) print(this + " running: " + r);
            r.run();
            pingSource_tl().set(internalPingSource);
            if (verbose) print(this + " done");
          } catch (Throwable e) {
            pingSource_tl().set(internalPingSource);
            if (verbose) print(this + " error");
            printStackTrace(e);
          } finally {
            pingSource_tl().set(internalPingSource);          
            if (verbose) print("ThreadPool finally");
          }
      }
    } catch (Exception __e) { throw rethrow(__e); } }
    
    synchronized boolean isEmpty() { return empty(q); }
    
    // append to q (do later)
    void addWork(Runnable r) {
      if (verbose) print("Added work to " + this + ": " + r);
      synchronized(this) {
        q = chainPlus(q, r);
        notifyAll();
      }
    }  
  }
  
  PooledThread newThread() {
    PooledThread t = new PooledThread("Thread Pool Inhabitant " + n2(total()+1));
    t.start();
    return t;
  }
  
  synchronized void markFree(PooledThread t) {
    used.remove(t);
    free.add(t);
    notifyAll();
  }
  
  synchronized void markUsed(PooledThread t) {
    free.remove(t);
    used.add(t);
  }
  
  synchronized public String toString() {
    return retired()
      ? "Retired ThreadPool"
      : "ThreadPool " + roundBracket(commaCombine(
        n2(used) + " used out of " + n2(total()),
        max <= total() ? null : "could grow to " + n2(max)));
  }
  
  synchronized boolean retired() { return retired; }
  synchronized void retire() {
    if (verbose) print("ThreadPool Retiring");
    retired = true;
    for (var thread : free) syncNotifyAll(thread); // wake it up so it exits
  }
  void checkNotRetired() {   
    if (retired()) throw fail("retired");
  }
 
  // We could do a soft-close here (stop the idle threads, let running threads finish, then end those too, stop accepting new orders)
  // or a hard close (interrupt all threads, stop accepting new orders)
  synchronized public void close() { try {
    retire();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  // run in synchronized block
  void _waitWaitWait() { try {
    do {
      fireCustomerMustWaitAlert();
      wait();
      checkNotRetired();
    } while (empty(free));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  void dO(String text, Runnable r) {
    if (r == null) return;
    new PingSource(this, text).dO(r);
  }
  
  ISleeper_v2 sleeper() { return sleeper; }
}
static interface IAutoCloseableF0<A> extends IF0<A>, AutoCloseable {}
static class RemoteDB implements AutoCloseable {
  DialogIO db;
  String name;
  
  // s = bot name or snippet ID
  RemoteDB(String s) {
    this(s, false);
  }
  
  RemoteDB(String s, boolean autoStart) {
    name = s;
    if (isSnippetID(s)) name = dbBotName(s);
    db = findBot(name);
    if (db == null)
      if (autoStart) {
        nohupJavax(fsI(s));
        waitForBotStartUp(name);
        assertNotNull("Weird problem", db = findBot(s));
      } else
        throw fail("DB " + s + " not running");
  }

  boolean functional() { return db != null; } // now always true
  
  List<RC> list() { return adopt((List<RC>) rpc(db, "xlist")); }
  List<RC> list(String className) { return adopt((List<RC>) rpc(db, "xlist", className)); }
  List<RC> xlist() { return list(); }
  List<RC> xlist(String className) { return list(className); }
  
  // adopt is an internal method
  List<RC> adopt(List<RC> l) {
    if (l != null) for (RC rc : l) adopt(rc);
    return l;
  }
  
  RC adopt(RC rc) { if (rc != null) rc.db = this; return rc; }
  
  Object adopt(Object o) {
    if (o instanceof RC) return adopt((RC) o);
    return o;
  }
  
  String xclass(RC o) {
    return (String) rpc(db, "xclass", o);
  }
  
  Object xget(RC o, String field) {
    return adopt(rpc(db, "xget", o, field));
  }
  
  String xS(RC o, String field) {
    return (String) xget(o, field);
  }
  
  RC xgetref(RC o, String field) {
    return adopt((RC) xget(o, field));
  }
  
  void xset(RC o, String field, Object value) {
    rpc(db, "xset", o, field, value);
  }
  
  RC uniq(String className) {
    RC ref = first(list(className));
    if (ref == null)
      ref = xnew(className);
    return ref;
  }
  RC xuniq(String className) { return uniq(className); }
  
  RC xnew(String className, Object... values) {
    return adopt((RC) rpc(db, "xnew", className, values));
  }
  
  void xdelete(RC o) {
    rpc(db, "xdelete", o);
  }
  
  void xdelete(List<RC> l) {
    rpc(db, "xdelete", l);
  }

  public void close() {
    _close(db);
  }
  
  String fullgrab() { return (String) rpc(db, "xfullgrab"); }
  String xfullgrab() { return fullgrab(); }
  
  void xshutdown() { rpc(db, "xshutdown"); }
  
  long xchangeCount() { return (long) rpc(db, "xchangeCount"); }
  int xcount() { return (int) rpc(db, "xcount"); }

  void reconnect() {
    close();
    db = findBot(name);
  }
  
  RC rc(long id) { return new RC(this, id); }
}
interface ChangeTriggerable {
  public void change();
}
abstract static class ConceptFieldIndexBase<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val>, IConceptCounter, AutoCloseable {
  Concepts concepts;
  Class<A> cc;
  String field;
  Map<A, Val> objectToValue = syncHashMap();
  MultiSetMap<Val, A> valueToObject; // initialized in subclass
  // bool indexNulls = true; // set this only when there are few null values in this field in the db. or when the point is to index a non-existing field (for singletons)
  
  ConceptFieldIndexBase() { init(); }
  ConceptFieldIndexBase(Class<A> cc, String field) { this(db_mainConcepts(), cc, field); }
  ConceptFieldIndexBase(Concepts concepts, Class<A> cc, String field) {
    this();
  this.field = field;
  this.cc = cc;
  this.concepts = concepts;
    concepts.addConceptIndex(this);
    updateAll();
    register();
    updateAll();
  }
  
  void updateAll() {
    for (A c : setToIndex())
      updateImpl(c);
  }
  
  Collection<A> setToIndex() {
    return list(concepts, cc);
  }
  
  abstract void init();
  abstract void register();

  public void update(Concept c) {
    if (!isInstance(cc, c)) return;
    updateImpl((A) c);
  }
  
  synchronized void updateImpl(A c) {
    Val newValue =  (Val) (cget(c, field));
    Val oldValue = objectToValue.get(c);
    if (newValue == oldValue && (oldValue != null || objectToValue.containsKey(c))) return;
    valueToObject.remove(oldValue, c);
    valueToObject.put(newValue, c);
    put(objectToValue, c, newValue);
  }
  
  public synchronized void remove(Concept c) {
    if (!isInstance(cc, c)) return;
    if (!objectToValue.containsKey(c)) return;
    Val value = objectToValue.get(c);
    objectToValue.remove(c);
    valueToObject.remove(value, (A) c);
  }
  
  synchronized A get(Val value) {
    return valueToObject.getFirst(value);
  }
  
  // older version - may return empty list as null
  // should be phased out everywhere!
  public synchronized Collection<A> getAll(Val value) {
    return valueToObject.get(value);
  }
  
  public synchronized List<Val> allValues() { return cloneKeys_noSync(valueToObject.data); }
  
  public IterableIterator<A> objectIterator() {
    return navigableMultiSetMapValuesIterator_concurrent(valueToObject, this);
  }
  
  public synchronized MultiSet<Val> allValues_multiSet() {
    return multiSetMapToMultiSet(valueToObject);
  }
  
  public Class<? extends Concept> conceptClass() { return cc; }
  public int countConcepts() { return l(objectToValue); }
  public Collection<Concept> allConcepts() { return (Collection) keys(objectToValue); }
  
  Object mutex() { return this; }
  
  public void close() { try {
    concepts.removeConceptIndex(this);
  } catch (Exception __e) { throw rethrow(__e); } }
}
static class SynchronizedCollection<E> implements Collection<E>, Serializable {
  SynchronizedCollection() {}
    @java.io.Serial
    private static final long serialVersionUID = 3053995032091335093L;

    @SuppressWarnings("serial") // Conditionally serializable
    /*final*/ Collection<E> c;  // Backing Collection
    @SuppressWarnings("serial") // Conditionally serializable
    /*final*/ Object mutex;     // Object on which to synchronize

    SynchronizedCollection(Collection<E> c) {
        this.c = Objects.requireNonNull(c);
        mutex = this;
    }

    SynchronizedCollection(Collection<E> c, Object mutex) {
        this.c = Objects.requireNonNull(c);
        this.mutex = Objects.requireNonNull(mutex);
    }

    public int size() {
        synchronized (mutex) {return c.size();}
    }
    public boolean isEmpty() {
        synchronized (mutex) {return c.isEmpty();}
    }
    public boolean contains(Object o) {
        synchronized (mutex) {return c.contains(o);}
    }
    public Object[] toArray() {
        synchronized (mutex) {return c.toArray();}
    }
    public <T> T[] toArray(T[] a) {
        synchronized (mutex) {return c.toArray(a);}
    }
    public <T> T[] toArray(java.util.function.IntFunction<T[]> f) {
        synchronized (mutex) {return c.toArray(f);}
    }

    public Iterator<E> iterator() {
        return c.iterator(); // Must be manually synched by user!
    }

    public boolean add(E e) {
        synchronized (mutex) {return c.add(e);}
    }
    public boolean remove(Object o) {
        synchronized (mutex) {return c.remove(o);}
    }

    public boolean containsAll(Collection<?> coll) {
        synchronized (mutex) {return c.containsAll(coll);}
    }
    public boolean addAll(Collection<? extends E> coll) {
        synchronized (mutex) {return c.addAll(coll);}
    }
    public boolean removeAll(Collection<?> coll) {
        synchronized (mutex) {return c.removeAll(coll);}
    }
    public boolean retainAll(Collection<?> coll) {
        synchronized (mutex) {return c.retainAll(coll);}
    }
    public void clear() {
        synchronized (mutex) {c.clear();}
    }
    public String toString() {
        synchronized (mutex) {return c.toString();}
    }
    // Override default methods in Collection
    @Override
    public void forEach(java.util.function.Consumer<? super E> consumer) {
        synchronized (mutex) {c.forEach(consumer);}
    }
    @Override
    public boolean removeIf(java.util.function.Predicate<? super E> filter) {
        synchronized (mutex) {return c.removeIf(filter);}
    }
    @Override
    public Spliterator<E> spliterator() {
        return c.spliterator(); // Must be manually synched by user!
    }
    @Override
    public java.util.stream.Stream<E> stream() {
        return c.stream(); // Must be manually synched by user!
    }
    @Override
    public java.util.stream.Stream<E> parallelStream() {
        return c.parallelStream(); // Must be manually synched by user!
    }
    @java.io.Serial
    private void writeObject(ObjectOutputStream s) throws IOException {
        synchronized (mutex) {s.defaultWriteObject();}
    }
}

static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
  SynchronizedRandomAccessList() {}

    SynchronizedRandomAccessList(List<E> list) {
        super(list);
    }

    SynchronizedRandomAccessList(List<E> list, Object mutex) {
        super(list, mutex);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        synchronized (mutex) {
            return new SynchronizedRandomAccessList<>(
                list.subList(fromIndex, toIndex), mutex);
        }
    }

    @java.io.Serial
    private static final long serialVersionUID = 1530674583602358482L;

    /**
     * Allows instances to be deserialized in pre-1.4 JREs (which do
     * not have SynchronizedRandomAccessList).  SynchronizedList has
     * a readResolve method that inverts this transformation upon
     * deserialization.
     */
    @java.io.Serial
    private Object writeReplace() {
        return new SynchronizedList<>(list);
    }
}

static interface ISleeper_v2 {
  Sleeping doLater(Timestamp targetTime, Runnable r);
  
  public default Sleeping doAfter(double seconds, Runnable r) {
    return doLater(tsNow().plusSeconds(seconds), r);
  }
}
static class RestartableCountdown implements AutoCloseable {
  java.util.Timer timer;
  long targetTime; // in sys time

  
  long /*firings,*/ totalSleepTime; // stats
  
  
  synchronized void setTargetTime(long targetTime, Runnable action) {
    if (targetTime <= 0)
      stop();
    else if (targetTime != this.targetTime) {
      start(targetTime-sysNow(), action);
      this.targetTime = targetTime;
    }
  }
  
  // stops the countdown and restarts it
  synchronized void start(long delayMS, Object action) {
    stop();
    if (delayMS <= 0)
      { startThread(new Runnable() {  public void run() { try {  callF(action); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(action);"; }}); }
    else {
      
        totalSleepTime += delayMS;
      
      timer = doLater_daemon(delayMS, action);
      targetTime = sysNow()+delayMS;
    }
  }
  
  void start(double delaySeconds, Object action) {
    start(toMS(delaySeconds), action);
  }
  
  synchronized void stop() {
    cancelTimer(timer);
    timer = null;
    targetTime = 0;
  }
  
  public void close() { stop(); }
}
interface IMultiMap<A, B> {
  public Set<A> keySet();
  public Collection<B> get(A a);
  public int size();
  public int keyCount();
}
// uses HashMap by default
static class MultiSet<A> implements IMultiSet<A> {
  Map<A, Integer> map = new HashMap();
  int size; // now maintaining a size counter
  
  MultiSet(boolean useTreeMap) {
    if (useTreeMap) map = new TreeMap();
  }
  MultiSet(TreeMap map) {
  this.map = map;}
  
  MultiSet() {}
  MultiSet(Iterable<A> c) { addAll(c); }
  MultiSet(MultiSet<A> ms) { synchronized(ms) {
    for (A a : ms.keySet()) add(a, ms.get(a));
  }}
  
  // returns new count
  public synchronized int add(A key) { return add(key, 1); }
  
  synchronized void addAll(Iterable<A> c) {
    if (c != null) for (A a : c) add(a);
  }

  synchronized void addAll(MultiSet<A> ms) {
    for (A a : ms.keySet()) add(a, ms.get(a));
  }
  
  synchronized int add(A key, int count) {
    if (count <= 0) return 0; // don't calculate return value in this case
    size += count;
    Integer i = map.get(key);
    map.put(key, i != null ? (count += i) : count);
    return count;
  }

  synchronized void put(A key, int count) {
    int oldCount = get(key);
    if (count == oldCount) return;
    size += count-oldCount;
    if (count != 0)
      map.put(key, count);
    else
      map.remove(key);
  }

  public synchronized int get(A key) {
    Integer i = map.get(key);
    return i != null ? i : 0;
  }
  
  synchronized boolean contains(A key) {
    return map.containsKey(key);
  }

  synchronized void remove(A key) {
    Integer i = map.get(key);
    if (i != null) {
      --size;
      if (i > 1)
        map.put(key, i - 1);
      else
        map.remove(key);
    }
  }

  synchronized List<A> topTen() { return getTopTen(); }
  
  synchronized List<A> getTopTen() { return getTopTen(10); }
  synchronized List<A> getTopTen(int maxSize) {
    List<A> list = getSortedListDescending();
    return list.size() > maxSize ? list.subList(0, maxSize) : list;
  }
  
  synchronized List<A> highestFirst() {
    return getSortedListDescending();
  }

  synchronized List<A> lowestFirst() {
    return reversedList(getSortedListDescending());
  }

  synchronized List<A> getSortedListDescending() {
    List<A> list = new ArrayList<A>(map.keySet());
    Collections.sort(list, new Comparator<A>() {
      public int compare(A a, A b) {
        return map.get(b).compareTo(map.get(a));
      }
    });
    return list;
  }

  synchronized int getNumberOfUniqueElements() {
    return map.size();
  }
  
  synchronized int uniqueSize() {
    return map.size();
  }

  synchronized Set<A> asSet() {
    return map.keySet();
  }

  synchronized NavigableSet<A> navigableSet() {
    return navigableKeys((NavigableMap) map);
  }

  synchronized Set<A> keySet() {
    return map.keySet();
  }
  
  synchronized A getMostPopularEntry() {
    int max = 0;
    A a = null;
    for (Map.Entry<A,Integer> entry : map.entrySet()) {
      if (entry.getValue() > max) {
        max = entry.getValue();
        a = entry.getKey();
      }
    }
    return a;
  }

  synchronized void removeAll(A key) {
    size -= get(key);
    map.remove(key);
  }

  synchronized int size() {
    return size;
  }

  synchronized MultiSet<A> mergeWith(MultiSet<A> set) {
    MultiSet<A> result = new MultiSet<A>();
    for (A a : set.asSet()) {
      result.add(a, set.get(a));
    }
    return result;
  }
  
  synchronized boolean isEmpty() {
    return map.isEmpty();
  }
  
  synchronized public String toString() { // hmm. sync this?
    return str(map);
  }
  
  synchronized void clear() {
    map.clear();
    size = 0;
  }
  
  final  Map<A, Integer> toMap(){ return asMap(); }
synchronized Map<A, Integer> asMap() {
    return cloneMap(map);
  }
}
interface IDoublePt {
  public double x_double();
  public double y_double();
}
static class SynchronizedNavigableSet<E>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E>
{
  SynchronizedNavigableSet() {}
    @java.io.Serial
    private static final long serialVersionUID = -5505529816273629798L;

    @SuppressWarnings("serial") // Conditionally serializable
    /*private final*/ NavigableSet<E> ns;

    SynchronizedNavigableSet(NavigableSet<E> s) {
        super(s);
        ns = s;
    }

    SynchronizedNavigableSet(NavigableSet<E> s, Object mutex) {
        super(s, mutex);
        ns = s;
    }
    public E lower(E e)      { synchronized (mutex) {return ns.lower(e);} }
    public E floor(E e)      { synchronized (mutex) {return ns.floor(e);} }
    public E ceiling(E e)  { synchronized (mutex) {return ns.ceiling(e);} }
    public E higher(E e)    { synchronized (mutex) {return ns.higher(e);} }
    public E pollFirst()  { synchronized (mutex) {return ns.pollFirst();} }
    public E pollLast()    { synchronized (mutex) {return ns.pollLast();} }

    public NavigableSet<E> descendingSet() {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.descendingSet(), mutex);
        }
    }

    public Iterator<E> descendingIterator()
             { synchronized (mutex) { return descendingSet().iterator(); } }

    public NavigableSet<E> subSet(E fromElement, E toElement) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.subSet(fromElement, true, toElement, false), mutex);
        }
    }
    public NavigableSet<E> headSet(E toElement) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.headSet(toElement, false), mutex);
        }
    }
    public NavigableSet<E> tailSet(E fromElement) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.tailSet(fromElement, true), mutex);
        }
    }

    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.subSet(fromElement, fromInclusive, toElement, toInclusive), mutex);
        }
    }

    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.headSet(toElement, inclusive), mutex);
        }
    }

    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        synchronized (mutex) {
            return new SynchronizedNavigableSet<>(ns.tailSet(fromElement, inclusive), mutex);
        }
    }
}

static class Cache<A> {
  Object maker; // func -> A
  A value;
  long loaded;
  static boolean debug = false;
  long changeCount;
  Lock lock = lock();
  
  Cache() {}
  Cache(Object maker) {
  this.maker = maker;}
  Cache(IF0<A> maker) {
  this.maker = maker;}

  A get() {
    if (hasLock(lock)) return value; // Must be called from within maker
    Lock __0 = lock; lock(__0); try {
    if (loaded == 0) {
      value = make();
      changeCount++;
      loaded = sysNow();
    }
    return value;
  } finally { unlock(__0); } }

  void clear() {
    Lock __1 = lock; lock(__1); try {
    if (debug && loaded != 0)
      print("Clearing cache");
    value = null;
    changeCount++;
    loaded = 0;
  } finally { unlock(__1); } }

  // clear if older than x seconds
  // 0 does not do anything
  void clear(double seconds) {
    Lock __2 = lock; lock(__2); try {
    if (seconds != 0 && loaded != 0 && sysNow() >= loaded+seconds*1000)
      clear();
  } finally { unlock(__2); } }
  
  // override
  void set(A a) {
    Lock __3 = lock; lock(__3); try {
    value = a;
    ++changeCount;
    loaded = sysNow();
  } finally { unlock(__3); } }
  
  A make() {
    return (A) callF(maker);
  }
}


static interface IMultiSet<A> {
  // returns new count
  int add(A key);
  
  /*void addAll(Iterable<A> c) {
    if (c != null) for (A a : c) add(a);
  }

  void addAll(MultiSet<A> ms) {
    for (A a : ms.keySet()) add(a, ms.get(a));
  }*/
  
  //int add(A key, int count);

  //void put(A key, int count);

  int get(A key);
  //bool contains(A key);

  //void remove(A key);

  /*List<A> topTen();
  
  synchronized List<A> getTopTen() { ret getTopTen(10); }
  synchronized List<A> getTopTen(int maxSize) {
    List<A> list = getSortedListDescending();
    return list.size() > maxSize ? list.subList(0, maxSize) : list;
  }
  
  synchronized L<A> highestFirst() {
    ret getSortedListDescending();
  }

  synchronized L<A> lowestFirst() {
    ret reversedList(getSortedListDescending());
  }

  synchronized L<A> getSortedListDescending() {
    List<A> list = new ArrayList<A>(map.keySet());
    Collections.sort(list, new Comparator<A>() {
      public int compare(A a, A b) {
        return map.get(b).compareTo(map.get(a));
      }
    });
    ret list;
  }

  synchronized int getNumberOfUniqueElements() {
    return map.size();
  }
  
  synchronized int uniqueSize() {
    ret map.size();
  }

  synchronized Set<A> asSet() {
    return map.keySet();
  }

  synchronized NavigableSet<A> navigableSet() {
    return navigableKeys((NavigableMap) map);
  }

  synchronized Set<A> keySet() {
    return map.keySet();
  }
  
  synchronized A getMostPopularEntry() {
    int max = 0;
    A a = null;
    for (Map.Entry<A,Integer> entry : map.entrySet()) {
      if (entry.getValue() > max) {
        max = entry.getValue();
        a = entry.getKey();
      }
    }
    return a;
  }

  synchronized void removeAll(A key) {
    size -= get(key);
    map.remove(key);
  }

  synchronized int size() {
    ret size;
  }

  synchronized MultiSet<A> mergeWith(MultiSet<A> set) {
    MultiSet<A> result = new MultiSet<A>();
    for (A a : set.asSet()) {
      result.add(a, set.get(a));
    }
    return result;
  }
  
  synchronized boolean isEmpty() {
    return map.isEmpty();
  }
  
  synchronized public String toString() { // hmm. sync this?
    return str(map);
  }
  
  synchronized void clear() {
    map.clear();
    size = 0;
  }
  
  synchronized Map<A, Int> asMap() {
    ret cloneMap(map);
  }*/
}
abstract static class Sleeping implements AutoCloseable , IFieldsToList{
  Timestamp targetTime;
  Runnable action;
  Sleeping() {}
  Sleeping(Timestamp targetTime, Runnable action) {
  this.action = action;
  this.targetTime = targetTime;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + targetTime + ", " + action + ")"; }public Object[] _fieldsToList() { return new Object[] {targetTime, action}; }

  long remainingMS() { return targetTime.minus(tsNow()); }
}
static class MultiSleeper extends RestartableCountdown implements ISleeper_v2 {
  TreeMultiMap<Timestamp, Runnable> entries = new TreeMultiMap();
  
  void check() {
    var time = nextWakeUpTime();
    var action = firstValue(entries);
    setTargetTime(time == null ? 0 : time.sysTime(), new Runnable() {  public void run() { try { 
      List<Runnable> toCall;
      synchronized(MultiSleeper.this) {
        toCall = entries.get(time);
        entries.remove(time);
      }
      check();
      pcallFAll(toCall);
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "List<Runnable> toCall;\r\n      synchronized(MultiSleeper.this) {\r\n        toCa..."; }});
  }
  
  synchronized void removeEntry(Timestamp targetTime, Runnable action) {
    entries.remove(targetTime, action);
  }
  
  // API
  
  synchronized Timestamp nextWakeUpTime() {
    return firstKey(entries);
  }
  
  public synchronized Sleeping doLater(Timestamp targetTime, Runnable r) {
    if (r == null || targetTime == null) return null;
    targetTime = max(targetTime, tsNow());
    entries.put(targetTime, r);
    check();
    return new Sleeping(targetTime, r) {
      public void close() { try {
        removeEntry(targetTime, r);
      } catch (Exception __e) { throw rethrow(__e); } }
    };
  }
}
static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E>
{
  SynchronizedSortedSet() {}
    @java.io.Serial
    private static final long serialVersionUID = 8695801310862127406L;

    @SuppressWarnings("serial") // Conditionally serializable
    /*private final*/ SortedSet<E> ss;

    SynchronizedSortedSet(SortedSet<E> s) {
        super(s);
        ss = s;
    }
    SynchronizedSortedSet(SortedSet<E> s, Object mutex) {
        super(s, mutex);
        ss = s;
    }

    public Comparator<? super E> comparator() {
        synchronized (mutex) {return ss.comparator();}
    }

    public SortedSet<E> subSet(E fromElement, E toElement) {
        synchronized (mutex) {
            return new SynchronizedSortedSet<>(
                ss.subSet(fromElement, toElement), mutex);
        }
    }
    public SortedSet<E> headSet(E toElement) {
        synchronized (mutex) {
            return new SynchronizedSortedSet<>(ss.headSet(toElement), mutex);
        }
    }
    public SortedSet<E> tailSet(E fromElement) {
        synchronized (mutex) {
           return new SynchronizedSortedSet<>(ss.tailSet(fromElement),mutex);
        }
    }

    public E first() {
        synchronized (mutex) {return ss.first();}
    }
    public E last() {
        synchronized (mutex) {return ss.last();}
    }
}

static class Timestamp implements Comparable<Timestamp> , IFieldsToList{
  long date;
  Timestamp(long date) {
  this.date = date;}

public boolean equals(Object o) {
if (!(o instanceof Timestamp)) return false;
    Timestamp __1 =  (Timestamp) o;
    return date == __1.date;
}

  public int hashCode() {
    int h = 2059094262;
    h = boostHashCombine(h, _hashCode(date));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {date}; }

  Timestamp() { date = now(); }
  
  long unixDate() { return date; }
  
  public String toString() { return formatLocalDateWithSeconds(date); }
  
  // Hmm. Should Timestamp(0) be equal to null? Question, questions...
  public int compareTo(Timestamp t) {
    return t == null ? 1 : cmp(date, t.date);
  }
  
  Timestamp plus(Seconds seconds) {
    return plus(seconds == null ? null : seconds.getDouble());
  }
  
  final Timestamp plusSeconds(double seconds){ return plus(seconds); }
Timestamp plus(double seconds) {
    return new Timestamp(date+toMS(seconds));
  }
  
  // returns milliseconds
  long minus(Timestamp ts) {
    return unixDate()-ts.unixDate();
  }
  
  long sysTime() {
    return clockTimeToSystemTime(date);
  }
}


static class Seconds implements Comparable<Seconds> , IFieldsToList{
  double seconds;
  Seconds() {}
  Seconds(double seconds) {
  this.seconds = seconds;}

public boolean equals(Object o) {
if (!(o instanceof Seconds)) return false;
    Seconds __1 =  (Seconds) o;
    return seconds == __1.seconds;
}

  public int hashCode() {
    int h = -660217249;
    h = boostHashCombine(h, _hashCode(seconds));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {seconds}; }

  final double get(){ return seconds(); }
final double getDouble(){ return seconds(); }
double seconds() { return seconds; }
  
  public String toString() { return formatDouble(seconds, 3) + " s"; }
  
  public int compareTo(Seconds s) {
    return cmp(seconds, s.seconds);
  }
  
  Seconds div(double x) { return new Seconds(get()/x); }
  Seconds minus(Seconds x) { return new Seconds(get()-x.get()); }
}


static boolean bareDBMode_on = false;

static void bareDBMode() {
  bareDBMode(null); // default autoSaveInterval
}

static void bareDBMode(Integer autoSaveInterval) {
  bareDBMode_on = true;
  conceptsAndBot(autoSaveInterval);
}




static BetterThreadLocal<PingSource> pingSource_tl_var = new BetterThreadLocal<PingSource>() {
  @Override
  public PingSource initialValue() {
    return ping_v3_pingSourceMaker().get(); 
  }
};

static BetterThreadLocal<PingSource> pingSource_tl() {
  return pingSource_tl_var;
}


static <A, B> List<B> getAll(Map<A, B> map, Collection<A> l) {
  return lookupAllOpt(map, l);
}

static <A, B> List<B> getAll(Collection<A> l, Map<A, B> map) {
  return lookupAllOpt(map, l);
}

static <A, B extends IF0<A>> List<A> getAll(Iterable<B> l) {
  return getVars(l);
}


static <A, B, C extends Collection<B>> List<B> allValues(Map<A, C> map) {
  List<B> out = new ArrayList();
  for (var l : values(map))
    addAll(out, l);
  return out;
}


static int boostHashCombine(int a, int b) {
  return a ^ (b + 0x9e3779b9 + (a << 6) + (a >>> 2));
  
  // OLD (changed) 2022/3/10: ret a ^ (b + 0x9e3779b9 + (a << 6) + (a >> 2));
}


static int _hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}


static NavigableMap synchroTreeMap() {
  return synchroNavigableMap(new TreeMap());
}



static boolean hasConcept(Class<? extends Concept> c, Object... params) {
  return findConceptWhere(c, params) != null;
}


static Object load(String varName) {
  readLocally(varName);
  return get(mc(), varName);
}

static Object load(String progID, String varName) {
  readLocally(progID, varName);
  return get(mc(), varName);
}


static void clearConcepts() {
  db_mainConcepts().clearConcepts();
}

static void clearConcepts(Concepts concepts) {
  concepts.clearConcepts();
}


static Map unstructureMap(String s) {
  return (Map) unstructure(s);
}

static Map unstructureMap(String text, boolean allDynamic, Object classFinder) {
  return (Map) unstructure(text, allDynamic, classFinder);
}


static boolean exceptionMessageContains(Throwable e, String s) {
  return cic(getInnerMessage(e), s);
}


static void printShortException(Throwable e) {
  print(exceptionToStringShort(e));
}

static void printShortException(String s, Throwable e) {
  print(s, exceptionToStringShort(e));
}


static Object unstructureGZFile(File f) { return unstructureGZFile(f, null); }
static Object unstructureGZFile(File f, IF1<String, Class> classFinder) { try {
  if (!fileExists(f)) return null;
  BufferedReader reader = utf8BufferedReader(gzInputStream(f));
  return unstructure_tok(javaTokC_noMLS_onReader(reader), false, classFinder);
} catch (Exception __e) { throw rethrow(__e); } }


static IF1 toIF1(final Object f) {
  if (f == null) return null;
  if (f instanceof IF1) return (IF1) f;
  if (isString(f)) {
    
      throw fail("callF_legacy");
    
    
  }
  return new IF1() {
    public Object get(Object a) { return callF(f, a); }
  };
}


static int done_minPrint = 10;

static long done(long startTime, String desc) {
  long time = now()-startTime;
  if (time >= done_minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done(String desc, long startTime) {
  return done(startTime, desc);
}

static long done(long startTime) {
  return done(startTime, "");
}


static RemoteDB connectToDBOpt(String dbNameOrID) { try {
  return new RemoteDB(dbNameOrID);
} catch (Throwable __e) { return null; } }


static <A, B> List<Pair<A, B>> mapToPairs(Map<A, B> map) {
  List<Pair<A, B>> l = emptyList(l(map));
  if (map != null) for (Map.Entry<A, B> e : map.entrySet())
    l.add(pair(e.getKey(), e.getValue()));
  return l;
}


static String dynShortName(Object o) {
  return shortDynamicClassName(o);
}


static Concept getConcept(long id) {
  return db_mainConcepts().getConcept(id);
}

static Concept getConcept(Concepts concepts, long id) {
  return concepts.getConcept(id);
}
 
static <A extends Concept> A getConcept(Class<A> cc, long id) {
  return getConcept(db_mainConcepts(), cc, id);
}

static <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
  Concept c = concepts.getConcept(id);
  if (c == null) return null;
  if (!isInstance(cc, c))
    throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
  return (A) c;
}



static <A, B> A lastKey(SortedMap<A, B> map) {
  return empty(map) ? null : map.lastKey();
}


static File conceptsDir() { return conceptsDir(db_mainConcepts()); }
static File conceptsDir(Concepts cc) {
  return cc.conceptsDir();
}

static File conceptsDir(String subName) { return conceptsDir(db_mainConcepts(), subName); }
static File conceptsDir(Concepts cc, String subName) {
  return newFile(conceptsDir(cc), subName);
}


// wrapper: VF1<Runnable> or null
static void callRunnableWithWrapper(Object wrapper, Runnable r) {
  if (wrapper == null) callF(r);
  else callF(wrapper, r);
}



static List callFAll(Collection l, Object... args) {
  return callF_all(l, args);
}


static long saveGZStructureToFile(String file, Object o) {
  return saveGZStructureToFile(getProgramFile(file), o);
}
  
// returns number of uncompressed bytes written
static long saveGZStructureToFile(File file, Object o) { return saveGZStructureToFile(file, o, new structure_Data()); }
static long saveGZStructureToFile(File file, Object o, structure_Data data) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  File tempFile = tempFileFor(file);
  if (tempFile.exists()) try {
    String saveName = tempFile.getPath() + ".saved." + now();
    copyFile(tempFile, new File(saveName));
  } catch (Throwable e) { printStackTrace(e); }
  
  FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
  CountingOutputStream cos;
  try {
    GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
    cos = new CountingOutputStream(gos);
    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(cos, "UTF-8");
    PrintWriter printWriter = new PrintWriter(outputStreamWriter);
    structureToPrintWriter(o, printWriter, data);
    printWriter.close();
    gos.close();
    fileOutputStream.close();
  } catch (Throwable e) {
    fileOutputStream.close();
    tempFile.delete();
    throw rethrow(e);
  }
  
  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (!tempFile.renameTo(file))
    throw new IOException("Can't rename " + tempFile + " to " + file);
    
  return cos.getFilePointer();
} catch (Exception __e) { throw rethrow(__e); } }


static long toM(long l) {
  return (l+1024*1024-1)/(1024*1024);
}

static String toM(long l, int digits) {
  return formatDouble(toM_double(l), digits);
}


static String javaTokWordWrap(String s) {
  return javaTokWordWrap(120, s);
}

// TODO: complete trimming
static String javaTokWordWrap(int cols, String s) {
  int col = 0;
  List<String> tok = javaTok(s);
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && col >= cols && !containsNewLine(t))
      tok.set(i, t = rtrimSpaces(t) + "\n");
    int idx = t.lastIndexOf('\n');
    if (idx >= 0) col = l(t)-(idx+1);
    else col += l(t);
  }
  return join(tok);
}


static String fileName(File f) {
  return f == null ? null : f.getName();
}


static int hours() {
  return hours(java.util.Calendar.getInstance());
}

static int hours(java.util.Calendar c) {
  return c.get(java.util.Calendar.HOUR_OF_DAY);
}

static int hours(long time) {
  return hours(calendarFromTime(time));
}

static int hours(long time, TimeZone tz) {
  return hours(calendarFromTime(time, tz));
}


static int roundDownTo_rev(int x, int n) {
  return roundDownTo(n, x);
}

static long roundDownTo_rev(long x, long n) {
  return roundDownTo(n, x);
}


static int minutes() {
  return minutes(Calendar.getInstance());
}

static int minutes(Calendar c) {
  return c.get(Calendar.MINUTE);
}


static Collection<Concept> allConcepts() {
  return db_mainConcepts().allConcepts();
}

static Collection<Concept> allConcepts(Concepts concepts) {
  return concepts.allConcepts();
}



static float abs(float f) { return Math.abs(f); }
static int abs(int i) { return Math.abs(i); }
static double abs(double d) { return Math.abs(d); }




static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }


static <A> A firstOfType(Collection c, Class<A> type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return (A) x;
  return null;
}


static List<Concept> conceptsOfType(String type) {
  return db_mainConcepts().conceptsOfType(type);
}


static <A> List<A> concatLists_conservative(List<A> a, List<A> b) {
  if (empty(a)) return b;
  if (empty(b)) return a;
  return concatLists(a, b);
}

static <A> List<A> concatLists_conservative(Collection<A> a, Collection<A> b) {
  if (empty(a) && b instanceof List) return ((List) b);
  if (empty(b) && a instanceof List) return ((List) a);
  return concatLists(a, b);
}


static <A> List<A> filterByType(Iterable c, Class<A> type) {
  List<A> l = new ArrayList();
  if (c != null) for (Object x : c)
    if (isInstanceX(type, x))
      l.add((A) x);
  return l;
}

static <A> List<A> filterByType(Object[] c, Class<A> type) {
  return filterByType(asList(c), type);
}

static <A> List<A> filterByType(Class<A> type, Iterable c) {
  return filterByType(c, type);
}


static <A> List<A> filterByDynamicType(Collection<A> c, String type) {
  List<A> l = new ArrayList();
  for (A x : c)
    if (eq(dynamicClassName(x), type))
      l.add(x);
  return l;
}


static boolean hasType(Collection c, Class type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return true;
  return false;
}


static <A extends Concept> A findBackRef(Concept c, Class<A> type) {
  for (Concept.Ref r : c.backRefs)
    if (instanceOf(r.concept(), type))
      return (A) r.concept();
  return null;
}

static <A extends Concept> A findBackRef(Class<A> type, Concept c) {
  return findBackRef(c, type);
}


static <A, B> void mapRemove(Map<A, B> map, A key) {
  if (map != null && key != null)
    map.remove(key);
}


static <A, B> B firstValue(Map<A, B> map) {
  return first(values(map));
}


static <A, B> B firstValue(MultiSetMap<A, B> map) {
  return map == null ? null : first(firstValue(map.data));
}



static <A, B> B firstValue(MultiMap<A, B> map) {
  return map == null ? null : first(firstValue(map.data));
}



static String loadConceptsStructure(String progID) {
  return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
}

static String loadConceptsStructure() {
  return loadConceptsStructure(dbProgramID());
}


static <A, B> boolean containsKey(Map<A, B> map, A key) {
  return map != null && map.containsKey(key);
}


static <A> boolean syncAdd(Collection<A> c, A b) {
  if (c == null) return false;
  synchronized(collectionMutex(c)) { return c.add(b); }
}

static <A> void syncAdd(List<A> l, int idx, A b) {
  if (l != null) synchronized(collectionMutex(l)) { l.add(idx, b); }
}


static <A> boolean syncRemove(Collection<A> c, A b) {
  if (c == null) return false;
  synchronized(collectionMutex(c)) { return c.remove(b); }
}

static <A> A syncRemove(List<A> l, int idx) {
  if (l == null) return null;
  synchronized(collectionMutex(l)) { return l.remove(idx); }
}

static <A, B> B syncRemove(Map<A, B> map, A key) {
  return map == null ? null : map.remove(key);
}


static <A> List<A> syncAddOrCreate(List<A> l, A a) {
  if (l == null) l = syncList();
  l.add(a);
  return l;
}


static String nConcepts(long n) { return n2(n, "concept"); }
static String nConcepts(Collection l) { return nConcepts(l(l)); }
static String nConcepts(Map map) { return nConcepts(l(map)); }


static int identityHashCode(Object o) {
  return System.identityHashCode(o);
}


static String shortDynamicClassName(Object o) {
 if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  return shortClassName(o);
}


static boolean dynamicObjectIsLoading() { 
  return isUnstructuring();
}


static void assertIsInstance(Class type, Object o) {
  if (!isInstance(type, o))
    throw fail(_getClass(o) + " is not a subclass of " + type);
}

static void assertIsInstance(Object o, Class type) {
  assertIsInstance(type, o);
}


static void change() {
  //mainConcepts.allChanged();
  // safe version for now cause function is sometimes included unnecessarily (e.g. by EGDiff)
  callOpt(getOptMC("mainConcepts"), "allChanged");
}


static boolean has(String a, String b, String c) {
  
  return false;
}

static boolean has(T3<String, String, String> t) {
  
  return false;
}


static void removeLast(List l) {
  if (!l.isEmpty())
    l.remove(l(l)-1);
}

static void removeLast(List l, int n) {
  removeSubList(l, l(l)-n);
}

static void removeLast(int n, List l) {
  removeLast(l, n);
}


static void add(BitSet bs, int i) {
  bs.set(i);
}

static <A> boolean add(Collection<A> c, A a) {
  return c != null && c.add(a);
}


static void add(Container c, Component x) {
  addToContainer(c, x);
}


static long add(AtomicLong l, long b) {
  return l.addAndGet(b);
}


static <A> A syncGet(List<A> l, int idx) {
  if (l == null || idx < 0) return null;
  synchronized(l) {
    return idx < l(l) ? l.get(idx) : null;
  }
}

static <A, B> B syncGet(Map<A, B> map, A a) {
  if (map == null) return null;
  synchronized(map) {
    return map.get(a);
  }
}


static int syncL(Collection l) {
  if (l == null) return 0;
  synchronized(collectionMutex(l)) { return l.size(); }
}

static int syncL(Map map) {
  if (map == null) return 0;
  synchronized(collectionMutex(map)) { return map.size(); }
}

static <A> List<A> syncL() {
  return syncList();
}


static <A> List<A> addDyn_quickSync(List<A> l, A a) {
  if (l == null) l = new ArrayList();
  syncAdd(l, a);
  return l;
}


static <A> List<A> removeDyn_quickSync(List<A> l, A a) {
  if (l == null) return null;
  synchronized(collectionMutex(l)) {
    l.remove(a);
    return empty(l) ? null : l;
  }
}


static void crenameField_noOverwrite(Concept c, String oldField, String newField) {
  if (c == null || eq(oldField, newField)) return;
  Object value = cget(c, oldField);
  if (newField != null && cget(c, newField) == null) cset(c, newField, value);
  cset(c, oldField, null);
}


static Collection<Concept.Ref> scanConceptForRefs(Concept c) {
  Set<Concept.Ref> refs = new HashSet();
  if (c != null) for (Object o : values(objectToMap(c))) {
    if (o instanceof Concept.Ref)
      refs.add((Concept.Ref) o);
    else if (o instanceof Concept.RefL)
      addAll(refs, ((Concept.RefL) o).l);
  }
  return refs;
}


static Set<java.util.Timer> _registerTimer_list = newWeakHashSet();

static void _registerTimer(java.util.Timer timer) {
  _registerTimer_list.add(timer);
}

static void cleanMeUp__registerTimer() {
  cancelTimers(getAndClearList(_registerTimer_list));
}


// firstDelay = delay
static FixedRateTimer doEvery(long delay, final Object r) {
  return doEvery(delay, delay, r);
}

static FixedRateTimer doEvery(long delay, long firstDelay, final Object r) {
  FixedRateTimer timer = new FixedRateTimer(shorten(programID() + ": " + r, 80));
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, toInt(delay)), toInt(firstDelay), toInt(delay));
  return vmBus_timerStarted(timer);
}

// reversed argument order for fun
static FixedRateTimer doEvery(double initialSeconds, double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), toMS(initialSeconds), r);
}

static FixedRateTimer doEvery(double delaySeconds, final Object r) {
  return doEvery(toMS(delaySeconds), r);
}



static String joinNemptiesWithColon(String... strings) {
  return joinNempties(": ", strings);
}

static String joinNemptiesWithColon(Collection<String> strings) {
  return joinNempties(": ", strings);
}


static String commaCombine(Object... l) {
  return joinNemptiesWithComma(flattenCollectionsAndArrays(ll(l)));
}


public static boolean isWindows() {
  return System.getProperty("os.name").contains("Windows");
}


static String firstToUpper(String s) {
  if (empty(s)) return s;
  return Character.toUpperCase(s.charAt(0)) + s.substring(1);
}


static long stopTiming_defaultMin = 10;

static long startTiming_startTime;
static void startTiming() {
  startTiming_startTime = now();
}

static void stopTiming() {
  stopTiming(null);
}

static void stopTiming(String text) {
  stopTiming(text, stopTiming_defaultMin);
}

static void stopTiming(String text, long minToPrint) {
  long time = now()-startTiming_startTime;
  if (time >= minToPrint) {
    text = or2(text, "Time: ");
    print(text + time + " ms");
  }
}


static double sqrt(double x) {
  return Math.sqrt(x);
}


static Pt ptMinus(Pt a, Pt b) {
  if (b == null) return a;
  return new Pt(a.x-b.x, a.y-b.y);
}


static UnsupportedOperationException unsupportedOperation() {
  throw new UnsupportedOperationException();
}


static double infinity() {
  return positiveInfinity();
}


static <A, B> A floorKey(NavigableMap<A, B> map, A key) {
  if (map == null) return null;
  return map.floorKey(key);
}


static <A, B> Map.Entry<A, B> higherEntry(NavigableMap<A, B> map, A key) {
  return map == null ? null : map.higherEntry(key);
}


static <A, B> Map.Entry<A, B> firstEntry(Map<A, B> map) {
  return empty(map) ? null : first(map.entrySet());
}


static <A, B> Map.Entry<A, B> lastEntry(NavigableMap<A, B> map) {
  return map == null ? null : map.lastEntry();
}


static <A, B> Set<A> keySet(Map<A, B> map) {
  return map == null ? new HashSet() : map.keySet();
}

static Set keySet(Object map) {
  return keys((Map) map);
}


  static <A> Set<A> keySet(MultiSet<A> ms) {
    return ms.keySet();
  }



  static <A, B> Set<A> keySet(MultiMap<A, B> mm) {
    return mm.keySet();
  }





// fromKey = inclusive, toKey = exclusive
static <A, B> SortedMap<A, B> subMap(SortedMap<A, B> map, A fromKey, A toKey) {
  return map == null ? null : map.subMap(fromKey, toKey);
}


static long sysTime() {
  return sysNow();
}


static <A, B> B pairB(Pair<A, B> p) {
  return p == null ? null : p.b;
}


static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}

static <A> void remove(Collection<A> l, A a) {
  if (l != null) l.remove(a);
}

static <A, B> B remove(Map<A, B> map, Object a) {
  return map == null ? null : map.remove(a);
}

static void remove(BitSet bs, int i) {
  bs.clear(i);
}


static <A> MultiSetMap<Object, A> generalizedCIMultiSetMap() {
  MultiSetMap<Object, A> mm = new MultiSetMap();
  mm.data = generalizedCIMap();
  return mm;
}


static <A> ListIterator<A> listIterator(List<A> l) {
  return l == null ? emptyListIterator() : l.listIterator();
}


static boolean classIsExportedTo(Class c, java.lang.Module destModule) {
  if (c == null || destModule == null) return false;
  
  java.lang.Module srcModule = c.getModule();
  String packageName = c.getPackageName();
  return srcModule.isExported(packageName, destModule);
}


static Set<Class> allInterfacesImplementedBy(Class c) {
  if (c == null) return null;
  HashSet<Class> set = new HashSet();
  allInterfacesImplementedBy_find(c, set);
  return set;
}

static void allInterfacesImplementedBy_find(Class c, Set<Class> set) {
  if (c.isInterface() && !set.add(c)) return;
  do {
    for (Class intf : c.getInterfaces())
      allInterfacesImplementedBy_find(intf, set);
  } while ((c = c.getSuperclass()) != null);
}


static Method findStaticMethod(Class c, String method, Object... args) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (!m.getName().equals(method))
        continue;

      if ((m.getModifiers() & Modifier.STATIC) == 0 || !findStaticMethod_checkArgs(m, args))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static boolean findStaticMethod_checkArgs(Method m, Object[] args) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length)
    return false;
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i])))
      return false;
  return true;
}



static List<String> quoteAll(String[] l) {
  return quoteAll(asList(l));
}

static List<String> quoteAll(Collection<String> l) {
  List<String> x = new ArrayList();
  for (String s : l)
    x.add(quote(s));
  return x;
}


static boolean arraysEqual(Object[] a, Object[] b) {
  if (a.length != b.length) return false;
  for (int i = 0; i < a.length; i++)
    if (neq(a[i], b[i])) return false;
  return true;
}


static boolean hasLock(Lock lock) {
  return ((ReentrantLock) lock).isHeldByCurrentThread();
}




static String mL_raw(String name) {
  return mechList_raw(name);
}


static boolean eqOrSame(Object a, Object b) {
  return a == null ? b == null : a == b || b != null && a.equals(b);
}


static Object metaGet(IMeta o, Object key) {
  return metaMapGet(o, key);
}

static Object metaGet(Object o, Object key) {
  return metaMapGet(o, key);
}

static Object metaGet(String key, IMeta o) {
  return metaMapGet(o, key);
}

static Object metaGet(String key, Object o) {
  return metaMapGet(o, key);
}


static Object metaMapGet(IMeta o, Object key) {
  return o == null ? null : o.metaGet(key); // We now let the object itself do it (overridable!)
}

static Object metaMapGet(Object o, Object key) {
  return metaMapGet(toIMeta(o), key);
}


static void metaPut(IMeta o, Object key, Object value) {
  metaMapPut(o, key, value);
}



static void metaPut(Object o, Object key, Object value) {
  metaMapPut(o, key, value);
}


static Map convertObjectMetaToMap(IMeta o) { return convertObjectMetaToMap(o, () -> makeObjectMetaMap()); }
static Map convertObjectMetaToMap(IMeta o, IF0<Map> createEmptyMap) {
  if (o == null) return null;
  
  // The following shortcut depends on the assumption that a meta field never reverts
  // to null when it was a map
  
    Object meta = o._getMeta();
    if (meta instanceof Map) return ((Map) meta);
  
  
  // non-shortcut path (create meta)
   var mutex = tempMetaMutex(o); try {
  var actualMutex = mutex.get();
  synchronized(actualMutex) {
    meta = o._getMeta();
    if (meta instanceof Map) return ((Map) meta);
    Map map = createEmptyMap.get();
    if (meta != null) map.put("previousMeta" , meta);
    o._setMeta(map);
    return map;
  }
} finally { _close(mutex); }}


static <A, B> void syncMapPutOrRemove(Map<A, B> map, A key, B value) {
  syncMapPut2(map, key, value);
}


static <A> A getAndClear(IVar<A> v) {
  A a = v.get();
  v.set(null);
  return a;
}


static <A, B> int keysSize(MultiMap<A, B> mm) {
  return lKeys(mm);
}


static <A> A reverseGet(List<A> l, int idx) {
  if (l == null || idx < 0) return null;
  int n = l(l);
  return idx < n ? l.get(n-1-idx) : null;
}


static String formatDouble_significant2(double d, int digits) {
  try {
    digits -= max(0, Math.floor(Math.log10(abs(d))+1));
    return formatDouble(d, digits);
  } catch (Throwable _e) {
    print("Had number: " + d + ", digits: " + digits);
  
throw rethrow(_e); }
}


// TODO: use actualUserHome()?
// (there was a problem with onLocallyInferiorJavaX() always triggering inside #1013896)

static File pathToJavaxJar() {
  
    
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null)
      return rl.pathToJavaXJar();
    
    
    return pathToJavaxJar_noResourceLoader();
  
  
}
    
static File pathToJavaxJar_noResourceLoader() { try {
  
    int x = latestInstalledJavaX();
    File xfile = new File(userHome(), ".javax/x" + Math.max(x, 30) + ".jar");
    if (!xfile.isFile()) {
      print("Saving " + f2s(xfile));
      String url = x30JarServerURL();
      byte[] data = loadBinaryPage(url);
      if (data.length < 1000000)
        throw fail("Could not load " + url);
      saveBinaryFile(xfile.getPath(), data);
    }
    return xfile;
  
  
  
} catch (Exception __e) { throw rethrow(__e); } }


static Method hashMap_findKey_method;

static <A, B> A hashMap_findKey(HashMap<A, B> map, Object key) { try {
  if (hashMap_findKey_method == null)
    hashMap_findKey_method = findMethodNamed(HashMap.class, "getNode");
  Map.Entry<A, B> entry = (Map.Entry) hashMap_findKey_method.invoke(map, hashMap_internalHash(key), key);
  // java.util.Map.Entry<A, B> entry = (java.util.Map.Entry) call(hash, 'getNode, hashMap_internalHash(key), wkey);
  return entry == null ? null : entry.getKey();
} catch (Exception __e) { throw rethrow(__e); } }


static int hashCodeFor(Object a) {
  return a == null ? 0 : a.hashCode();
}


// assumes main class is last declared class
// returns actual CNC
static List<String> findMainClass(List<String> tok) {
  for (List<String> c : reversedList(allClasses(tok))) {
    String name = getClassDeclarationName(c);
    if (eq(name, "main") || name.startsWith("x"))
      return c;
  }
  return findBlock("m {", tok);
}


static boolean useDummyMainClasses() {
  return true;
  //ret eq("1", trim(loadTextFile(getProgramFile(#1008755, "use-dummy-main-classes"))));
}


static boolean tok_classHasModifier(List<String> classDecl, String modifier) {
  if (classDecl == null) return false;
  int i = classDecl.indexOf("class");
  return subList(classDecl, 0, i).contains(modifier);
}


static String joinNemptiesWithDot(Object... strings) {
  return joinNempties(".", strings);
}

static String joinNemptiesWithDot(Iterable strings) {
  return joinNempties(".", strings);
}


static String tok_packageName(List<String> tok) {
  int i = jfind(tok, "package");
  if (i < 0) return "";
  i += 2;
  int j = jfind(tok, i, ";");
  if (j < 0) return "";
  return join(codeTokensOnly(subList(tok, i-1, j)));
}

static String tok_packageName(String src) {
  Producer<String> p = javaTokC_producer(src);
  String t = p.next();
  if (!eq(t, "package")) return "";
  StringBuilder buf = new StringBuilder();
  while (!eqOneOf(t = p.next(), null, ";"))
    buf.append(t);
  return str(buf);
}


static String getClassDeclarationName(List<String> tok) {
  if (tok != null)
    for (int i = 1; i+2 < tok.size(); i += 2)
      if (allClasses_keywords.contains(tok.get(i)) && isIdentifier(tok.get(i+2))) {
        while (contains(getClassDeclarationName_skippables(), get(tok, i+2)))
          i += 2;
        return tok.get(i+2);
      }
  return null;
}



static String manifestPathInJar() {
  return "META-INF/MANIFEST.MF";
}


static String manifestTextForMainClass(String mainClass) {
  return "Manifest-Version: 1.0\n" +
    "Main-Class: " + mainClass + "\n\n";
}


// before you use this, add a RAM disk cleaner
static boolean javaCompileToJar_useRAMDisk = false;

static ThreadLocal<List<File>> javaCompileToJar_localLibraries = new ThreadLocal();
static ThreadLocal<IVF1<File>> javaCompileToJar_addMoreFiles = new ThreadLocal();

static File javaCompileToJar_optionalRename(String src, File destJar, String progIDForRename) {
  return javaCompileToJar_optionalRename(src, "", destJar, progIDForRename);
}

static synchronized File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename) {
  return javaCompileToJar_optionalRename(src, dehlibs, destJar, progIDForRename, null);
}

// returns path to jar
static synchronized File javaCompileToJar_optionalRename(String src, String dehlibs, File destJar, String progIDForRename, String progID) {
  String javaTarget = null; // use default target
  
  //print("Compiling " + l(src) + " chars");
  String dummyClass = "main";
  if (progIDForRename != null) {
    dummyClass = dummyMainClassName(progIDForRename);
    src += "\nclass " + dummyClass + "{}";
  }
  String md5 = md5(src);
  File jar = destJar;

  Class j = getJavaX();
  if (javaTarget != null)
    setOpt(j, "javaTarget", javaTarget);
  //setOpt(j, "verbose", true);
  File srcDir = tempDir();
  String fileName = dummyClass + ".java";
  
  // deriver name of main Java file from source
  List<String> tok = javaTok(src);
  String packageName = tok_packageName(tok);
  if (packageName != null)
    fileName = packageName.replace(".", "/") + "/" + tok_firstClassName(tok) + ".java";
  File mainJava = new File(srcDir, fileName);
  
  //print("main java: " + mainJava.getAbsolutePath());
  saveTextFile(mainJava, src);
  File classesDir = javaCompileToJar_useRAMDisk ? tempDirPossiblyInRAMDisk() : tempDir();
  //print("Compiling to " + f2s(classesDir));
  try {
    List<File> libraries = cloneList(getAndClearTL(javaCompileToJar_localLibraries));
    
    Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
    while (m.find()) {
      String libID = m.group();
      //print("libID=" + quote(libID));
      assertTrue(isSnippetID(libID));
      print("Adding library " + libID);
      libraries.add(loadLibraryOrSrcLib(libID));
    }
    
    libraries.add(pathToJavaxJar());
      
    String compilerOutput;
    try {
      compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
    } catch (Throwable e) {
      compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
      //fail("Compile Error. " + cleanJavaCompilerOutput(compilerOutput) + " " + e);
      //compilerOutput = indentx("> ", cleanJavaCompilerOutput(compilerOutput));
      //throw JavaCompilerException(compilerOutput, e);
      if (!swic(e.getMessage(), "Java compiler returned errors."))
        compilerOutput = appendWithNewLine(compilerOutput, str(e));
      //printStackTrace(e);
      throw fail(compilerOutput, e);
    }
    
    compilerOutput = cleanJavaCompilerOutput("Annotation processing got disabled, since it requires a 1.6 compliant JVM");

    if (nempty(compilerOutput)) {
      print("Compiler said: " + compilerOutput);
      //fail("Compile Error. " + compilerOutput);
    }
  
    // sanity test
    if (!anyFileWithExtensionInDir(classesDir, ".class")) {
      printWithIndent("SRC> ", src);
      throw fail("No classes generated (was compiling " + nChars(src) + ")");
    }
        
    // add sources to .jar
    saveTextFile(new File(classesDir, "main.java"), src);
    
    // add information about libraries to jar
    if (nempty(dehlibs))
      saveTextFile(new File(classesDir, "libraries"), dehlibs);
      
    // add prog id to jar
    saveTextFile(new File(classesDir, "progID"), progID);

    // save pointer to main Java source    
    //saveTextFile(new File(classesDir, "main-src"), fileName);
    
    callF(javaCompileToJar_addMoreFiles.get(), classesDir);
  
    print("Zipping: " + classesDir.getAbsolutePath() + " to " + jar.getAbsolutePath());
    dir2zip_recurse_verbose = false;
    int n = dir2zip_recurse(classesDir, jar); // cache on success only
    print("Files zipped: " + n);
  
    return jar;
  } finally {
    if (isInRAMDisk(classesDir)) deleteDirectory(classesDir);
  }
}



// will create the file or update its last modified timestamp
static File touchFile(File file) { try {
  closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
  return file;
} catch (Exception __e) { throw rethrow(__e); } }


static String appendSlash(String s) {
  return addSlash(s);
}


static String compilerBotDestDirSubName() {
  return "JavaX-Caches/Compilations";
}


static File compilerBotDestDir() {
  return actualUserDir(compilerBotDestDirSubName());
}

static File compilerBotDestDir(String sub) {
  return newFile(compilerBotDestDir(), sub);
}


static <A> Set<A> syncLinkedHashSet() {
  return synchroLinkedHashSet();
}


// I believe this was meant to mitigate memory leaks.
// Disabled now because JDK 17 doesn't allow it anyways.
static void fixACCInClassLoader(Object o) {
  /*pcall {
    AccessControlContext acc = vm_globalACC();
    if (acc != null)
      replaceACCInClassLoader(o, acc);
  }*/
}


static String systemHashCodeHex(Object o) {
  return intToHex(identityHashCode(o));
}


static String loadTextFileResource(ClassLoader cl, String name) {
  return inputStreamToString(cl.getResourceAsStream(name));
}


static ClassLoader getVirtualParent(ClassLoader cl) {
  return (ClassLoader) rcallOpt("getVirtualParent", cl);
}


static <A, B> LinkedHashMap<A, B> cloneLinkedHashMap(Map<A, B> map) {
  return map == null ? new LinkedHashMap() : new LinkedHashMap(map);
}


static <A, B> A firstKey(Map<A, B> map) {
  return first(keys(map));
}


static <A, B> A firstKey(IMultiMap<A, B> map) {
  return map == null ? null : first(map.keySet());
}



static Set emptySet() {
  return new HashSet();
}


static double fileAgeInSeconds(File f) {
  return f == null ? -1 : msToSeconds(now()-fileModificationTime(f));
}


static String nSeconds(long n) { return n2(n, "second"); }
static String nSeconds(Collection l) { return nSeconds(l(l)); }


static boolean deleteFile(File file) {
  return file != null && file.delete();
}




static Path toPath(File f) {
  return f == null ? null : f.toPath();
}


static void touchExistingFile(File file) { try {
  if (file == null) return;
  java.nio.file.Files.setLastModifiedTime(toPath(file),
    java.nio.file.attribute.FileTime.from(java.time.Instant.now()));
} catch (Exception __e) { throw rethrow(__e); } }


static volatile int numberOfCores_value;

static int numberOfCores() {
  if (numberOfCores_value == 0)
    numberOfCores_value = Runtime.getRuntime().availableProcessors();
  return numberOfCores_value;
}


static <A> Set<A> createOrAddToSyncLinkedHashSet(Set<A> set, A a) {
  if (set == null) set = syncLinkedHashSet();
  set.add(a);
  return set;
}



static <A> A pcallF_typed(F0<A> f) {
  try { return f == null ? null : f.get(); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static <A, B> B pcallF_typed(F1<A, B> f, A a) {
  try { return f == null ? null : f.get(a); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static <A> void pcallF_typed(VF1<A> f, A a) {
  try {
    { if (f != null) f.get(a); }
  } catch (Throwable __e) { printStackTrace(__e); }
}


static <A> void pcallF_typed(IVF1<A> f, A a) {
  try {
    { if (f != null) f.get(a); }
  } catch (Throwable __e) { printStackTrace(__e); }
}

static <A, B> void pcallF_typed(IVF2<A, B> f, A a, B b) {
  try {
    { if (f != null) f.get(a, b); }
  } catch (Throwable __e) { printStackTrace(__e); }
}

static Object pcallF_typed(Runnable r) {
  try { { if (r != null) r.run(); } } catch (Throwable __e) { printStackTrace(__e); } return null;
}

static <A> A pcallF_typed(IF0<A> f) {
  try { return f == null ? null : f.get(); } catch (Throwable __e) { printStackTrace(__e); } return null;
}

static <A, B> B pcallF_typed(IF1<A, B> f, A a) {
  try { return f == null ? null : f.get(a); } catch (Throwable __e) { printStackTrace(__e); } return null;
}



static int random(int n) { return random(n, defaultRandomGenerator()); }
static int random(int n, Random r) {
  return random(r, n);
}

static int random(Random r, int n) {
  return n <= 0 ? 0 : getRandomizer(r).nextInt(n);
}

static double random(double max) {
  return random()*max;
}

static double random() {
  return defaultRandomGenerator().nextInt(100001)/100000.0;
}

static double random(double min, double max) {
  return min+random()*(max-min);
}

// min <= value < max
static int random(int min, int max) {
  return min+random(max-min);
}

static int random(int min, int max, Random r) {
  return random(r, min, max);
}

static int random(Random r, int min, int max) {
  return min+random(r, max-min);
}

static <A> A random(List<A> l) {
  return oneOf(l);
}

static <A> A random(Collection<A> c) {
  if (c instanceof List) return random((List<A>) c);
  int i = random(l(c));
  return collectionGet(c, i);
}



static <A, B> Pair<A, B> random(Map<A, B> map) {
  return entryToPair(random(entries(map)));
}


// Yes the nomenclature is a bit illogical

static <A> Chain<A> chainPlus(Chain<A> chain, A a) {
  return new Chain<A>(a, chain);
}

static <A> Chain<A> chainPlus(Chain<A> chain, A... l) {
  for (A a : unnullForIteration(l))
    chain = chainPlus(chain, a);
  return chain;
}

static <A> ReverseChain<A> chainPlus(ReverseChain<A> chain, A a) {
  return new ReverseChain<A>(chain, a);
}

static <A> ReverseChain<A> chainPlus(ReverseChain<A> chain, A... l) {
  for (A a : unnullForIteration(l))
    chain = chainPlus(chain, a);
  return chain;
}


static <A> AppendableChain<A> chainPlus(AppendableChain<A> chain, A a) {
  if (chain == null) return new AppendableChain<A>(a);
  chain.add(a);
  return chain;
}

static <A> AppendableChain<A> chainPlus(AppendableChain<A> chain, A... l) {
  for (A a : unnullForIteration(l))
    chain = chainPlus(chain, a);
  return chain;
}




static void syncNotifyAll(Object o) {
  if (o != null) synchronized(o) { o.notifyAll(); }
}


static long waitForBotStartUp_timeoutSeconds = 60;

// returns address or fails
static String waitForBotStartUp(String botName) {
  for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
    sleepSeconds(i == 0 ? 0 : 1);
    String addr = getBotAddress(botName);
    if (addr != null)
      return addr;
  }
  throw fail("Bot not found: " + quote(botName));
}


static Object rpc(String botName, String method, Object... args) {
  return unstructure_matchOK2OrFail(
    sendToLocalBot(botName, rpc_makeCall(method, args)));
}

static Object rpc(DialogIO bot, String method, Object... args) {
  return unstructure_matchOK2OrFail(
    bot.ask(rpc_makeCall(method, args)));
}

static String rpc_makeCall(String method, Object... args) {
  if (empty(args))
    return "call " + method;
  return format("call *", concatLists((List) ll(method), asList(args)));
}


static void close(AutoCloseable c) {
  _close(c);
}


static void register(Concept c) {
  registerConcept(c);
}


static <A, B> List<A> cloneKeys_noSync(Map<A, B> map) {
  return cloneList_noSync(keys(map));
}


static <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm) {
  return navigableMultiSetMapValuesIterator_concurrent(mm, mm.data);
}
  
static <A, B> IterableIterator<B> navigableMultiSetMapValuesIterator_concurrent(final MultiSetMap<A, B> mm, Object mutex) {
  return iteratorFromFunction(new F0<B>() {
    Iterator<Set<B>> it = concurrentlyIterateValues((NavigableMap) mm.data, mutex);
    Iterator<B> it2;
    
    public B get() {
      while (it2 == null || !it2.hasNext()) {
        if (!it.hasNext()) return null;
        it2 = iterator(asList(it.next()));
      }
      return it2.next();
    }
  });
}


static <A, B> MultiSet<A> multiSetMapToMultiSet(MultiSetMap<A, B> mm) {
  MultiSet<A> ms = new MultiSet();
  for (A a : keys(mm))
    ms.add(a, l(mm.get(a)));
  return ms;
}


static java.util.Timer doLater(long delay, final Object r) {
  ping();
  final java.util.Timer timer = new java.util.Timer();
  timer.schedule(timerTask(r, timer), delay);
  return vmBus_timerStarted(timer);
}

static java.util.Timer doLater(double delaySeconds, final Object r) {
  return doLater(toMS(delaySeconds), r);
}


static Timestamp tsNow() {
  return new Timestamp();
}


static java.util.Timer doLater_daemon(long delay, final Object r) {
  final java.util.Timer timer = new java.util.Timer(true);
  timer.schedule(timerTask(r, timer), delay);
  return timer;
}

static java.util.Timer doLater_daemon(double delaySeconds, final Object r) {
  return doLater_daemon(toMS(delaySeconds), r);
}



static void cancelTimer(javax.swing.Timer timer) {
  if (timer != null) timer.stop();
}


static void cancelTimer(java.util.Timer timer) {
  if (timer != null) timer.cancel();
}

static void cancelTimer(Object o) {
  if (o instanceof java.util.Timer) cancelTimer((java.util.Timer) o);
  
  else if (o instanceof javax.swing.Timer) cancelTimer((javax.swing.Timer) o);
  
  else if (o instanceof AutoCloseable) { try { ((AutoCloseable) o).close(); } catch (Throwable __e) { printStackTrace(__e); }}
}


static <A, B> NavigableSet<A> navigableKeys(NavigableMap<A, B> map) {
  return map == null ? new TreeSet() : map.navigableKeySet();
}


  static <A> NavigableSet<A> navigableKeys(MultiSet<A> ms) {
    return ((NavigableMap) ms.map).navigableKeySet();
  }



  static <A, B> NavigableSet<A> navigableKeys(MultiMap<A, B> mm) {
    return ((NavigableMap) mm.data).navigableKeySet();
  }



static <A, B> Map<A, List<B>> toMap(MultiMap<A, B> m) {
  return multiMapToMap(m);
}


static String lower(String s) {
  return s == null ? null : s.toLowerCase();
}

static char lower(char c) {
  return Character.toLowerCase(c);
}


static double floor(double d) {
  return Math.floor(d);
}




static String formatLocalDateWithSeconds(long time) {
  return localDateWithSeconds(time);
}



static String formatLocalDateWithSeconds() {
  return localDateWithSeconds();
}


static BigInteger plus(BigInteger a, BigInteger b) {
  return a.add(b);
}

static BigInteger plus(BigInteger a, long b) {
  return a.add(bigint(b));
}

static long plus(long a, long b) { return a+b; }
static int plus(int a, int b) { return a+b; }
static float plus(float a, float b) { return a+b; }
static double plus(double a, double b) { return a+b; }


static long clockTimeToSystemTime(long now) {
  return now == 0 ? 0 : now + clockToSysTimeDiff();
}


static int seconds() {
  return seconds(Calendar.getInstance());
}

static int seconds(Calendar c) {
  return c.get(Calendar.SECOND);
}


static String formatDouble(double d, int digits) {
  String format = digits <= 0 ? "0" : "0." + rep(digits, '#');
  return decimalFormatEnglish(format, d);
}

static String formatDouble(double d) {
  return str(d);
}






static HashSet<String> allClasses_keywords = lithashset("class", "interface", "enum", "sclass", "sinterface", "record", "srecord", "strecord", "asclass", "concept");

// lists returned are actual CNC (N/C/N/.../C/N) - and connected to
// original list
// only returns the top level classes
static List<List<String>> allClasses(List<String> tok) {
  List<List<String>> l = new ArrayList();
  int n = tok.size();
  HashSet<String> _allClasses_keywords = allClasses_keywords;
  for (int i = 1; i < n; i += 2) {
    String t = tok.get(i);
    if ("{".equals(t)) // skip functions
      i = findEndOfBlock(tok, i)-1;
    else if (_allClasses_keywords.contains(t)
      && (tok_isJavaxMetaCommandLeftOf(tok, i) ||
        !(eqGetOneOf(tok, i-2, ".", "include")
          && !containsNewLine(tok.get(i-1))))) {
      int j = i;
      while (j < n && !tok.get(j).equals("{"))
        j += 2;
      j = findEndOfBlock(tok, j)+1;
      i = leftScanModifiers(tok, i);
      l.add(subList(tok, i-1, Math.min(n, j)));
      i = j-2;
    }
  }
  return l;
}

static List<List<String>> allClasses(String text) {
  return allClasses(javaTok(text));
}


static IF0<PingSource> ping_v3_pingSourceMaker_cache;
static IF0<PingSource> ping_v3_pingSourceMaker() { if (ping_v3_pingSourceMaker_cache == null) ping_v3_pingSourceMaker_cache = ping_v3_pingSourceMaker_load(); return ping_v3_pingSourceMaker_cache;}

static IF0<PingSource> ping_v3_pingSourceMaker_load() {
  return or((IF0) vm_generalMap_get("ping_v3_pingSourceMaker"), () -> null);
}



static <A, B> List<B> lookupAllOpt(Map<A, B> map, Collection<A> l) {
  List<B> out = new ArrayList();
  if (l != null) for (A a : l)
    addIfNotNull(out, map.get(a));
  return out; 
}

static <A, B> List<B> lookupAllOpt(Collection<A> l, Map<A, B> map) {
  return lookupAllOpt(map, l);
}


static <A, B extends IF0<A>> List<A> getVars(Iterable<B> l) {
  return lambdaMap(__69 -> getVar(__69), l);
}


static void readLocally(String progID, String varNames) {
  readLocally2(mc(), progID, varNames);
}

static void readLocally(String varNames) {
  readLocally2(mc(), programID(), varNames);
}

static void readLocally2(Object obj, String varNames) {
  readLocally2(obj, programID(), varNames);
}

static int readLocally_stringLength;

static ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();
static ThreadLocal readLocally2_classFinder = new ThreadLocal();

// read a string variable from standard storage
// does not overwrite variable contents if there is no file
static void readLocally2(Object obj, String progID, String varNames) { try {
  boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
  for (String variableName : javaTokC(varNames)) {
    File textFile = new File(programDir(progID), variableName + ".text");
    
    String value = loadTextFile(textFile);
    if (value != null)
      set(main.class, variableName, value);
    else {
      File structureFile = new File(programDir(progID), variableName + ".structure");
      value = loadTextFile(structureFile);
      
      if (value == null) {
        File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
        if (!structureGZFile.isFile()) return;
        //value = loadGZTextFile(structureGZFile);
         InputStream fis = new FileInputStream(structureGZFile); try {
        GZIPInputStream gis = newGZIPInputStream(fis);
        InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(reader);
        //O o = unstructure_reader(bufferedReader);
        Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, readLocally2_classFinder.get());
        readLocally_set(obj, variableName, o);
        return;
      } finally { _close(fis); }}
      
      readLocally_stringLength = l(value);
      if (nempty(value))
        readLocally_set(obj, variableName, unstructure(value, allDynamic, readLocally2_classFinder.get()));
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void readLocally_set(Object c, String varName, Object value) {
  Object oldValue = get(c, varName);
  if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
    // Assume it's a synchroList.
    value = synchroList((List) value);
  }
  set(c, varName, value);
}



static boolean isString(Object o) {
  return o instanceof String;
}


static List callF_all(Collection l, Object... args) {
  return map(l, f -> callF(f, args));
}


static File tempFileFor(File f) {
  return new File(f.getPath() + "_temp");
}


static double toM_double(long l) {
  return l/(1024*1024.0);
}


static boolean containsNewLine(String s) {
  return contains(s, '\n'); // screw \r, nobody needs it
}


public static String rtrimSpaces(String s) {
  if (s == null) return null;
  int i = s.length();
  while (i > 0 && " \t".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}


static java.util.Calendar calendarFromTime(long time, TimeZone tz) {
  java.util.Calendar c = java.util.Calendar.getInstance(tz);
  c.setTimeInMillis(time);
  return c;
}

static java.util.Calendar calendarFromTime(long time) {
  java.util.Calendar c = java.util.Calendar.getInstance();
  c.setTimeInMillis(time);
  return c;
}


static String dynamicClassName(Object o) {
  if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return "main$" + ((DynamicObject) o).className;
  return className(o);
}


// not a very good one
static boolean instanceOf(Object o, String className) {
  if (o == null) return false;
  String c = o.getClass().getName();
  return eq(c, className) || eq(c, "main$" + className);
}

// better
static boolean instanceOf(Object o, Class c) {
  if (c == null) return false;
  return c.isInstance(o);
}

static boolean instanceOf(Class c, Object o) {
  return instanceOf(o, c);
}


static <A> List<A> syncList() {
  return synchroList();
}



static <A> List<A> syncList(List<A> l) {
  return synchroList(l);
}


static boolean isUnstructuring() {
  return isTrue(getTL(dynamicObjectIsLoading_threadLocal()));
}


static Object getOptMC(String field) {
  return getOpt(mc(), field);
}


static void addToContainer(Container a, Component... b) {
  if (a == null) return;
  { swing(() -> { 
    for (Component c : unnullForIteration(b))
      if (c != null) 
        a.add(c);
  }); }
}


static <A> Set<A> newWeakHashSet() {
  return synchroWeakHashSet();
}


static void cancelTimers(Collection timers) {
  for (Object timer : timers) cancelTimer(timer);
}


static <A> A vmBus_timerStarted(A timer) {
  vmBus_send("timerStarted", timer, costCenter());
  return timer;
}


static String joinNempties(String sep, Object... strings) {
  return joinStrings(sep, strings);
}

static String joinNempties(String sep, Iterable strings) {
  return joinStrings(sep, strings);
}


static String joinNemptiesWithComma(Object... strings) {
  return joinNempties(", ", strings);
}

static String joinNemptiesWithComma(Iterable strings) {
  return joinNempties(", ", strings);
}


static List flattenCollectionsAndArrays(Iterable a) {
  List l = new ArrayList();
  for (Object x : a)
    if (x instanceof Collection)
      l.addAll(flattenCollectionsAndArrays((Collection) x));
    else if (x instanceof Object[])
      l.addAll(flattenCollectionsAndArrays(asList((Object[]) x)));
    else
      l.add(x);
  return l;
}


static double positiveInfinity() {
  return Double.POSITIVE_INFINITY;
}


static <A> TreeMap<Object, A> generalizedCIMap() {
  return new TreeMap(generalizedCIComparator());
}


static ListIterator emptyListIterator() {
  return Collections.emptyListIterator();
}


static IMeta toIMeta(Object o) {
  return initIMeta(o);
}


static Map makeObjectMetaMap() {
  //ret synchroLinkedHashMap();
  return new CompactHashMap();
}


static IAutoCloseableF0 tempMetaMutex(IMeta o) {
  return o == null ? null : o._tempMetaMutex();
}


static <A, B> void syncMapPut2(Map<A, B> map, A key, B value) {
  if (map != null && key != null) synchronized(collectionMutex(map)) {
    if (value != null) map.put(key, value);
    else map.remove(key);
  }
}


static <A, B> int lKeys(MultiMap<A, B> mm) {
  return mm == null ? 0 : mm.keysSize();
}


static int latestInstalledJavaX() {
  File[] files = new File(userHome(), ".javax").listFiles();
  int v = 0;
  if (files != null) for (File f : files) {
    Matcher m = regexpMatcher("x(\\d\\d\\d?)\\.jar", f.getName());
    if (m.matches())
      v = Math.max(v, Integer.parseInt(m.group(1)));
  }
  return v;
}


static String x30JarServerURL() {
  return "http://botcompany.de:8081/x30.jar";
}


static int hashMap_internalHash(Object key) {
  int h;
  return (key == null) ? 0 : (h = key.hashCode()) ^ (h >>> 16);
}


static List<String> findBlock(String pat, List<String> tok) {
  List<String> tokpat = javaTok(pat);
  int i = findCodeTokens(tok, toStringArray(codeTokensOnly(tokpat)));
  //print("index of block " + quote(pat) + ": " + i);
  if (i < 0) return null;
  int bracketIdx = i+tokpat.size()-3;
  assertEquals("{", tok.get(bracketIdx));
  int endIdx = findEndOfBlock(tok, bracketIdx);
  return subList(tok, i-1, endIdx+1); // make it actual CNC
}


static Producer<String> javaTokC_producer(String s) {
  return javaTokC_iterator(s);
}


static Set<String> getClassDeclarationName_skippables_cache;
static Set<String> getClassDeclarationName_skippables() { if (getClassDeclarationName_skippables_cache == null) getClassDeclarationName_skippables_cache = getClassDeclarationName_skippables_load(); return getClassDeclarationName_skippables_cache;}

static Set<String> getClassDeclarationName_skippables_load() {
  return litset("noeq", "mapMethodLike");
}



static String dummyMainClassName(String progID) {
  return "m" + psI(progID);
}


  static File tempDir() {
    return makeTempDir();
  }


static String tok_firstClassName(List<String> tok) {
  int i = jfind(tok, "class <id>");
  return i < 0 ? null : tok.get(i+2);
}


static File tempDirPossiblyInRAMDisk() {
  File f = linux_fileInRamDisk(aGlobalID());
  if (f != null) { f.mkdirs(); return f; }
  return makeTempDir();
}


static <A> A getAndClearTL(ThreadLocal<A> tl) {
  return getAndClearThreadLocal(tl);
}




static boolean loadLibraryOrSrcLib_srcLibsEnabled = true;

// to avoid checking src libs too often when booting OS
static ThreadLocal<Map<Long, File>> loadLibraryOrSrcLib_tempCache = new ThreadLocal();
static ThreadLocal<IF1<String, File>> loadLibraryOrSrcLib_compiler = new ThreadLocal();

static File loadLibraryOrSrcLib(String snippetID) { return loadLibraryOrSrcLib(snippetID, loadLibraryOrSrcLib_compiler.get()); }
static File loadLibraryOrSrcLib(String snippetID, IF1<String, File> compiler) { try {
  vmBus_send("loadLibraryOrSrcLib", snippetID);
  long id = parseSnippetID(snippetID);
  
  if (loadLibraryOrSrcLib_tempCache.get() != null) {
    File f = loadLibraryOrSrcLib_tempCache.get().get(id);
    if (f != null)
      { print(snippetID + " from tempCache: " + f); return f; }
  }
  
  boolean srcLib = loadLibraryOrSrcLib_srcLibsEnabled && isMarkedAsSrcLib(snippetID);
  if (srcLib) {
    print(snippetID + " marked as src lib, compiling");
    File f;
    if (compiler != null)
      f = compiler.get(snippetID);
    else
      f = pairA(hotwire_compile(snippetID));
    print("Src lib: " + f);
    mapPut(loadLibraryOrSrcLib_tempCache.get(), id, f);
    return f;
  }
    
  File f = DiskSnippetCache_getLibrary(id);
  if (fileSize(f) != 0) return f/* with print(snippetID + " from disk cache: " + f)*/;
  try {
    print("Trying " + snippetID + " as binary library");
    return loadDataSnippetToFile(snippetID);
  } catch (Throwable e) {
    if (loadLibraryOrSrcLib_srcLibsEnabled) {
      print("Trying " + snippetID + " as src lib");
      if (nempty(loadSnippet(snippetID))) {
        print("Is src lib.");
        markAsSrcLib(snippetID);
        return pairA(hotwire_compile(snippetID));
      }
    }
    throw rethrow(e);
  }
} catch (Exception __e) { throw rethrow(__e); } }


static String cleanJavaCompilerOutput(String s) {
  return dropPrefixTrim("Annotation processing got disabled, since it requires a 1.6 compliant JVM", s);
}



static boolean anyFileWithExtensionInDir(File dir, String ext) {
  return nempty(filesWithExtension(ext, findAllFiles_noDirs(dir)));
}


static String nChars(long n) { return n2(n, "char"); }
static String nChars(String s) { return nChars(l(s)); }


static boolean dir2zip_recurse_verbose = false;

static int dir2zip_recurse(File inDir, File zip) {
  return dir2zip_recurse(inDir, zip, "");
}

// TODO: the zero files case?
static int dir2zip_recurse(File inDir, File zip, String outPrefix) { try {
  mkdirsForFile(zip);
  FileOutputStream fout = newFileOutputStream(zip);
  ZipOutputStream outZip = new ZipOutputStream(fout);
  try {
    return dir2zip_recurse(inDir, outZip, outPrefix, 0);
  } finally {
    outZip.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static int dir2zip_recurse(File inDir, ZipOutputStream outZip) {
  return dir2zip_recurse(inDir, outZip, "", 0);
}

static int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) { try {
  if (++level >= 20) throw fail("woot? 20 levels in zip?");
  
  List<File> files = new ArrayList();
  for (File f : listFiles(inDir))
    files.add(f);

  int n = 0;
  sortFilesByName(files);
  for (File f : files) {
    if (f.isDirectory()) {
      if (dir2zip_recurse_verbose) print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
      n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
    } else {
      if (dir2zip_recurse_verbose) print("Copying " + f.getName());
      outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
      InputStream fin = new FileInputStream(f);
      copyStream(fin, outZip);
      fin.close();
      ++n;
    }
  }
  return n;
} catch (Exception __e) { throw rethrow(__e); } }



static boolean isInRAMDisk(File f) {
  return startsWithOneOf(f2s(f), "/dev/shm/", "/run/shm/");
}


static void deleteDirectory(File dir) {
  deleteDirectory(dir, false, false);
}

static void deleteDirectory(File dir, boolean verbose, boolean testRun) {
  deleteAllFilesInDirectory(dir, verbose, testRun);
  if (verbose) print((testRun ? "Would delete " : "Deleting ") + dir.getAbsolutePath());
  if (!testRun)
    dir.delete();
}



static void closeRandomAccessFile(RandomAccessFile f) {
  if (f != null) try {
    f.close();
    callJavaX("dropIO", f);
  } catch (Throwable e) {
    printStackTrace(e);
  }
}


static RandomAccessFile newRandomAccessFile(File path, String mode) { try {
  boolean forWrite = mode.indexOf('w') >= 0;
  if (forWrite) mkdirsForFile(path);
  RandomAccessFile f = new RandomAccessFile(path, mode);
  
  callJavaX("registerIO", f, path, forWrite);
  
  return f;
} catch (Exception __e) { throw rethrow(__e); } }


static String addSlash(String s) {
  return empty(s) || s.endsWith("/") ? s : s + "/";
}


static File actualUserDir() {
  return new File(actualUserHome());
}

static File actualUserDir(String path) {
  return new File(actualUserHome(), path);
}


// BREAKING CHANGE!
// Also NOTE: Iterators of these sync-wrapped collections
// after generally NOT thread-safe!
// TODO: change that?
static <A> Set<A> synchroLinkedHashSet() {
  
  
  return Collections.synchronizedSet(new CompactLinkedHashSet());
  
}


static String intToHex(int i) {
  return bytesToHex(intToBytes(i));
}


static String inputStreamToString(InputStream in) {
  return utf8streamToString(in);
}


static Object rcallOpt(String method, Object o, Object... args) {
  return callOpt_withVarargs(o, method, args);
}


static double msToSeconds(long ms) {
  return toSeconds(ms);
}

static double msToSeconds(double ms) {
  return toSeconds(ms);
}


static long fileModificationTime(File f) {
  return f == null ? 0 : f.lastModified();
}


static Random getRandomizer(Random r) {
  return r != null ? r : defaultRandomGenerator();
}


static <A> A oneOf(List<A> l) {
  if (empty(l)) return null;
  int n = l.size();
  return n == 1 ? first(l) : l.get(defaultRandomizer().nextInt(n));
}

static char oneOf(String s) {
  return empty(s) ? '?' : s.charAt(random(l(s)));
}

static String oneOf(String... l) {
  return oneOf(asList(l));
}


static <A> A collectionGet(Collection<A> c, int idx) {
  if (c == null || idx < 0 || idx >= l(c)) return null;
  if (c instanceof List) return listGet((List<A>) c, idx);
  Iterator<A> it = c.iterator();
  for (int i = 0; i < idx; i++) if (it.hasNext()) it.next(); else return null;
  return it.hasNext() ? it.next() : null;
}


static <A, B> Pair<A, B> entryToPair(Map.Entry<A, B> e) {
  return mapEntryToPair(e);
}


static <A, B> Set<Map.Entry<A,B>> entries(Map<A, B> map) {
  return _entrySet(map);
}


static String getBotAddress(String bot) {
  List<ScannedBot> l = fullBotScan(bot);
  return empty(l) ? null : first(l).address;
}


static Object unstructure_matchOK2OrFail(String s) {
  if (swic(s, "ok "))
    return unstructure_startingAtIndex(s, 3);
  else
    throw fail(s);
}


static String sendToLocalBot(String bot, String text, Object... args) {
  text = format3(text, args);
  
   DialogIO channel = findBot(bot); try {
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    print(bot + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(bot + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}

static String sendToLocalBot(int port, String text, Object... args) {
  text = format3(text, args);
   DialogIO channel = talkTo(port); try {
  try {
    channel.readLine();
    print(port + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(port + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  }
} finally { _close(channel); }}


static <A extends Concept> A registerConcept(A c) { return registerConcept(db_mainConcepts(), c); }
static <A extends Concept> A registerConcept(Concepts cc, A c) {
  { if (cc != null) cc.register(c); }
  return c;
}


static <A> ArrayList<A> cloneList_noSync(Iterable<A> l) {
  return l instanceof Collection ? cloneList_noSync((Collection) l) : asList(l);
}

static <A> ArrayList<A> cloneList_noSync(Collection<A> l) {
  if (l == null) return new ArrayList();
  return new ArrayList<A>(l);
}


// f: func -> A (stream ends when f returns null)
static <A> IterableIterator<A> iteratorFromFunction(final Object f) {
  class IFF extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = (A) callF(f);
      done = a == null;
    }
  };
  return new IFF();
}

// optimized version for F0 argument

static <A> IterableIterator<A> iteratorFromFunction(F0<A> f) {
  return iteratorFromFunction_f0(f);
}


static <A> IterableIterator<A> iteratorFromFunction(IF0<A> f) {
  return iteratorFromFunction_if0(f);
}


// iterate safely (& quickly) in the face of concurrent modifications
static <A, B> IterableIterator<B> concurrentlyIterateValues(NavigableMap<A, B> map) {
  return concurrentlyIterateValues(map, map);
}

static <A, B> IterableIterator<B> concurrentlyIterateValues(final NavigableMap<A, B> map, Object mutex) {
  return iteratorFromFunction(new F0<B>() {
    Iterator<A> it = keys(map).iterator();
    A key;
    
    B get() {
      synchronized(mutex) {
        try {
          if (!it.hasNext()) return null;
          return map.get(key = it.next());
        } catch (ConcurrentModificationException e) {
          print("Re-iterating");
          it = map.tailMap(key, false).keySet().iterator();
          if (!it.hasNext()) return null;
          return map.get(key = it.next()); // Can't throw another exception
        }
      }
    }
  });
}


static TimerTask timerTask(final Object r, final java.util.Timer timer) {
  return new TimerTask() {
    public void run() {
      
      if (!licensed())
        timer.cancel();
      else
        pcallF(r);
    }
  };
}


static <A, B> Map<A, List<B>> multiMapToMap(MultiMap<A, B> m) {
  return m == null ? null : m.data;
}




static String localDateWithSeconds(long time) {
  SimpleDateFormat format = simpleDateFormat_local("yyyy/MM/dd HH:mm:ss");
  return format.format(time);
}

static String localDateWithSeconds() {
  return localDateWithSeconds(now());
}


static BigInteger bigint(String s) {
  return new BigInteger(s);
}

static BigInteger bigint(long l) {
  return BigInteger.valueOf(l);
}


static long clockToSysTimeDiff() {
  return sysNow()-now();
}


static String decimalFormatEnglish(String format, double d) {
  return decimalFormatEnglish(format).format(d);
}

static java.text.DecimalFormat decimalFormatEnglish(String format) {
  return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH));
}




// i must point at the (possibly imaginary) opening bracket ("{")
// index returned is index of closing bracket + 1 (or l(tok))
static int findEndOfBlock(List<String> tok, int i) {
  return tok_findEndOfBlock(tok, i);
}


// i points at C token after suspected meta command
static boolean tok_isJavaxMetaCommandLeftOf(List<String> tok, int i) {
  int j = i-2*4-1;
  if (j >= 0 && jfind(subList(tok, j, i), "set flag <id> .") == 1) return true;
  return false;
}


static int leftScanModifiers(List<String> tok, int i) { return leftScanModifiers(tok, i, getJavaModifiers()); }
static int leftScanModifiers(List<String> tok, int i, Collection<String> modifiers) {
  while (i > 1 && contains(modifiers, tok.get(i-2)))
    i -= 2;
  return i;
}



static Object getTL(Object o, String name) {
  return getThreadLocal(o, name);
}

static <A> A getTL(ThreadLocal<A> tl) {
  return getThreadLocal(tl);
}

static <A> A getTL(ThreadLocal<A> tl, A defaultValue) {
  return getThreadLocal(tl, defaultValue);
}


static <A> Set<A> synchroWeakHashSet() {
  return Collections.newSetFromMap((Map) newWeakHashMap());
}


static Object costCenter() { return mc(); }


static String joinStrings(String sep, Object... strings) {
  return joinStrings(sep, Arrays.asList(strings));
}

static String joinStrings(String sep, Iterable strings) {
  StringBuilder buf = new StringBuilder();
  for (Object o : unnull(strings)) { 
    String s = strOrNull(o);
    if (nempty(s)) {
      if (nempty(buf)) buf.append(sep);
      buf.append(s);
    }
  }
  return str(buf);
}




// non-strings must be Comparable to each other
// probably this is not that useful after all

static generalizedCIComparator_C generalizedCIComparator_cache;
static generalizedCIComparator_C generalizedCIComparator() { if (generalizedCIComparator_cache == null) generalizedCIComparator_cache = generalizedCIComparator_load(); return generalizedCIComparator_cache;}

static generalizedCIComparator_C generalizedCIComparator_load() {
  return new generalizedCIComparator_C();
}

final static class generalizedCIComparator_C implements Comparator<Object> {
  public int compare(Object o1, Object o2) {
    if (o1 instanceof String)
      if (o2 instanceof String)
        return betterCIComparator().compare(((String) o1), ((String) o2));
      else
        return -1;
    else
      if (o2 instanceof String)
        return 1;
    else
      return cmp(o1, o2);
  }
}


static Producer<String> javaTokC_iterator(String s) {
  return new Producer<String>() {
    final int l = strL(s);
    int i = 0;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else if (c == '[' && d == '[') {
        do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
        j = Math.min(j+2, l);
      } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
        do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
        j = Math.min(j+3, l);
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}



  static File makeTempDir() {
    return (File) call(getJavaX(), "TempDirMaker_make");
  }


static File linux_fileInRamDisk(String name) {
  if (!isLinux()) return null;
  File dir = newFile("/dev/shm");
  if (dir.isDirectory()) return newFile(dir, name);
  return null;
}


static boolean isMarkedAsSrcLib(String snippetID) {
  if (snippetID == null) return false;
  
  
  IResourceLoader rl = vm_getResourceLoader();
  if (rl != null)
    return isJavaxCompilableSnippetType(rl.getSnippetType(snippetID));
  
  
  return fileExists(javaxCodeDir("srclibs/" + psI(snippetID)));
}


static <A, B> A pairA(Pair<A, B> p) {
  return p == null ? null : p.a;
}


static Object hotwire_onCompile; // voidfunc(Pair<jarFile, transpiledSource>)
static boolean hotwire_serially = false;
static Lock hotwire_overInternalBot_lock = lock();
static boolean hotwire_compileOnServer = false;

static Class<?> hotwire_overInternalBot(String progID) {
  return hotwire_overInternalBot(progID, "main");
}

static Class<?> hotwire_overInternalBot(String progID, String mainClass) {
  return hotwire_overInternalBot(progID, __ -> mainClass);
}

static Class<?> hotwire_overInternalBot(String progID, IF1<ClassLoader, String> calculateMainClass) { try {
  Pair<File, String> p;
  try {
    p = hotwire_compile(progID);
  } catch (Throwable e) {
    throw rethrow("Error hotwiring " + progID, e);
  }
  File jar = p.a;
  assertTrue(jar.getAbsolutePath(), jar.isFile());
  
  List<File> files = hotwire_collectJars(jar);

  // make class loader
  JavaXClassLoader classLoader = hotwire_makeClassLoader(files);
  classLoader.progID = progID;
  
  String mainClass = calculateMainClass == null ? "main" : calculateMainClass.get(classLoader);
  return hotwire_finish(classLoader, progID, p.b, mainClass);
} catch (Exception __e) { throw rethrow(__e); } }

// returns pair(jar, transpiled src)
static Pair<File, String> hotwire_compile(String progID) {
  Pair<File, String> p = hotwire_compileOnServer && !isLocalSnippetID(progID)
    ? compileSnippetThroughServer(progID)
    : CompilerBot.compileSnippet2(progID);
  Lock __0 = hotwire_serially ? hotwire_overInternalBot_lock : null; lock(__0); try {
  callF(hotwire_onCompile, p);
  return p;
} finally { unlock(__0); } }


static void markAsSrcLib(String snippetID) {
  saveTextFile(javaxCodeDir("srclibs/" + psI(snippetID)), "");
}


static String dropPrefixTrim(String prefix, String s) {
  return trim(dropPrefix(prefix, s));
}


static List<File> filesWithExtension(String ext, List<File> files) {
  return filesEndingWith(files, addPrefixIfNotEmpty2(".", ext));
}


static List<File> findAllFiles_noDirs(List dirs) {
  return findAllFiles_noDirs(asObjectArray(dirs));
}

// dirs are String's or File's
static List<File> findAllFiles_noDirs(Object... dirs) {
  List<File> l = new ArrayList();
  for  (Object dir : dirs) { ping(); 
    if (dir instanceof String && ((String) dir).endsWith("/.")) {
      // "/." means non-recurse
      for  (File f : listFiles(dropSuffix("/.", ((String) dir))))
        { ping(); if (f.isFile()) l.add(f); }
    } else
      findAllFiles_noDirs_impl(toFile(dir), l);
  }
  return l;
}

static void findAllFiles_noDirs_impl(File dir, List<File> l) {
  for  (File f : listFiles(dir)) { ping(); 
    if (f.isDirectory())
      findAllFiles_noDirs_impl(f, l);
    else
      l.add(f);
  }
}



static List<File> sortFilesByName(List<File> l) {
  sort(l, (a, b) -> stdcompare(a.getName(), b.getName()));
  return l;
}


static int deleteAllFilesInDirectory_minPathLength = 10;

static void deleteAllFilesInDirectory(File dir) {
  deleteAllFilesInDirectory(dir, false, false);
}

static void deleteAllFilesInDirectory(File dir, boolean verbose, boolean testRun) {
  dir = getCanonicalFile(dir);
  assertTrue(f2s(dir), l(f2s(dir)) >= deleteAllFilesInDirectory_minPathLength);
  File[] files = dir.listFiles();
  if (files == null) return;
  for (File f : files) {
    if (!isSymLink(f) && f.isDirectory()) // just delete the symlink, don't follow it
      deleteDirectory(f, verbose, testRun);
    else {
      if (verbose)
        print((testRun ? "Would delete " : "Deleting ") + f.getAbsolutePath());
      if (!testRun)
        f.delete();
    }
  }
}



static Object callJavaX(String method, Object... args) {
  return callOpt(getJavaX(), method, args);
}


static byte[] intToBytes(int i) {
  return new byte[] {
          (byte) (i >>> 24),
          (byte) (i >>> 16),
          (byte) (i >>> 8),
          (byte) i};
}


static String utf8streamToString(InputStream in) {
  return readerToString(utf8bufferedReader(in));
}


static double toSeconds(long ms) {
  return ms/1000.0;
}

static String toSeconds(long ms, int digits) {
  return formatDouble(toSeconds(ms), digits);
}

static double toSeconds(double ms) {
  return ms/1000.0;
}

static String toSeconds(double ms, int digits) {
  return formatDouble(toSeconds(ms), digits);
}


static Random defaultRandomizer() {
  return defaultRandomGenerator();
}


static <A> A listGet(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}


static class ScannedBot implements IFieldsToList{
  static final String _fieldOrder = "helloString address";
  String helloString;
  String address;
  ScannedBot() {}
  ScannedBot(String helloString, String address) {
  this.address = address;
  this.helloString = helloString;}
  public String toString() { return shortClassName_dropNumberPrefix(this) + "(" + helloString + ", " + address + ")"; }

public boolean equals(Object o) {
if (!(o instanceof ScannedBot)) return false;
    ScannedBot __1 =  (ScannedBot) o;
    return eq(helloString, __1.helloString) && eq(address, __1.address);
}

  public int hashCode() {
    int h = 1660478935;
    h = boostHashCombine(h, _hashCode(helloString));
    h = boostHashCombine(h, _hashCode(address));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {helloString, address}; }
}

static List<ScannedBot> fullBotScan() {
  return fullBotScan("");
}

static List<ScannedBot> fullBotScan(String searchPattern) {
  List<ScannedBot> bots = new ArrayList();
  for (ProgramScan.Program p : quickBotScan()) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = swic(botName, "Multi-Port") || isVM;
    
    if (swic(botName, searchPattern)) bots.add(new ScannedBot(botName, "" + p.port));

    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        botName = subBots.get(vport);
        if (swic(botName, searchPattern)) 
          bots.add(new ScannedBot(botName, p.port + "/" + vport));
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
  return bots;
}


static Object unstructure_startingAtIndex(String s, int i) {
  return unstructure_tok(javaTokC_noMLS_iterator(s, i), false, null);
}


static <A> IterableIterator<A> iteratorFromFunction_f0(final F0<A> f) {
  class IFF2 extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
  };
  return new IFF2();
}


static <A> IterableIterator<A> iteratorFromFunction_if0(final IF0<A> f) {
  class IFF2 extends IterableIterator<A> {
    A a;
    boolean done = false;
    
    public boolean hasNext() {
      getNext();
      return !done;
    }
    
    public A next() {
      getNext();
      if (done) throw fail();
      A _a = a;
      a = null;
      return _a;
    }
    
    void getNext() {
      if (done || a != null) return;
      a = f.get();
      done = a == null;
    }
  };
  return new IFF2();
}




// i must point at the (possibly imaginary) opening bracket ("{")
// index returned is index of closing bracket + 1 (or l(tok))
static int tok_findEndOfBlock(List<String> tok, int i) {
  
    if (tok instanceof IContentsIndexedList2)
      return tok_findEndOfBlock_IContentsIndexedList2_v2(((IContentsIndexedList2) tok), i);
  

  int j = i+2, level = 1, n = l(tok);
  while (j < n) {
    String t = tok.get(j);
    if ("{".equals(t)) ++level;
    else if ("}".equals(t)) --level;
    if (level == 0)
      return j+1;
    j += 2;
  }
  return n;
}


static List<String> getJavaModifiers_list = litlist("static", "abstract", "public", "private", "protected", "final", "native", "volatile", "synchronized", "transient", "default");

static List<String> getJavaModifiers() {
  return getJavaModifiers_list;
}


static Cache<Boolean> isLinux_cache = new Cache<>(() -> isLinux_load());
static boolean isLinux() { return isLinux_cache.get(); }

static Boolean isLinux_load() {
  return !isWindows() && !isMac() && !isAndroid();
}


static boolean isJavaxCompilableSnippetType(int type) {
  return isJavaxCompilableSnippetTypeExceptInclude(type)
    || type == javaxIncludeSnippetType();
}


static List<File> hotwire_collectJars(File jar) {
  List<String> libIDs = hotwire_libraryIDsFromJar_deleteJarOnFail(jar);
  List<File> files = ll(jar); // main program has to be first entry! (e.g. for hotwire_makeClassLoader_stickyAndSrcLibs)
  for (String libID : libIDs)
    files.add(loadLibraryOrSrcLib(libID));
  return files;
}


// returns (jar, transpiled src)
static Pair<File, String> compileSnippetThroughServer(String progID) {
  String transpiledSrc = getServerTranspiled2(progID);
  String md5 = md5(transpiledSrc + "\n" + progID);
  File jar = CompilerBot.getJarFile(md5);
  if (jar == null || jar.length() <= 22) {
    byte[] jarData = null;
    boolean dontLoad = false;
    
    
    IResourceLoader rl = vm_getResourceLoader();
    if (rl != null) {
      dontLoad = true;
      File jar2 = rl.getSnippetJar(progID, transpiledSrc);
      if (jar2 != null) return pair(jar2, transpiledSrc); 
    }
    
    if (!dontLoad) { try {
      jarData = loadBinaryPage("https://botcompany.de/jar/" + psI(progID) + "?md5=" + md5(transpiledSrc));
    } catch (Throwable __e) { printStackTrace(__e); }}
      
    if (!isJAR(jarData)) {
      if (jarData != null) {
        print(bytesToHex(takeFirstOfByteArray(8, jarData)));
        print("fallback to CompilerBot: " + fromUtf8(takeFirstOfByteArray(80, jarData)));
      }
      return CompilerBot.compileSnippet2(progID);
    }
    saveBinaryFile(jar, jarData);
  }
  return pair(jar, transpiledSrc);
}


static List<File> filesEndingWith(File dir, String suffix) {
  return listFilesWithSuffix(dir, suffix);
}

static List<File> filesEndingWith(List<File> l, String suffix) {
  List<File> out = new ArrayList();
  for (File f : unnull(l))
    if (!f.isDirectory() && (empty(suffix) || endsWithIgnoreCase(f.getName(), suffix)))
      out.add(f);
  return out;
}

static List<File> filesEndingWith(String suffix, File dir) {
  return filesEndingWith(dir, suffix);
}


static File toFile(Object o) {
  if (o instanceof File) return (File) o;
  if (o instanceof String) return new File((String) o);
  throw fail("Not a file: " + o);
}


static File getCanonicalFile(File f) { try {
  return f == null ? null : f.getCanonicalFile();
} catch (Exception __e) { throw rethrow(__e); } }



static boolean isSymLink(File f) {
  
  
  
  return f != null && Files.isSymbolicLink(toPath(f));
  
}


static String readerToString(Reader r) { try {
  if (r == null) return null;
  try {
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      //if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  } finally {
    r.close();
  }  
} catch (Exception __e) { throw rethrow(__e); } }




// i must point at the (possibly imaginary) opening bracket ("{")
// index returned is index of closing bracket + 1 (or l(tok))

// version using iterator (much faster than v1!)

static int tok_findEndOfBlock_IContentsIndexedList2_v2(IContentsIndexedList2<String> tok, int i) {
  int n = l(tok);
  
  // find opening & closing brackets after start index
  
  HasIndex start = new HasIndex(i);
  TreeSet<HasIndex> openers = tok.indicesOf_treeSetOfHasIndex("{");
  Iterator<HasIndex> iOpener = openers == null ? null : openers.tailSet(start, false).iterator();
  TreeSet<HasIndex> closers = tok.indicesOf_treeSetOfHasIndex("}");
  Iterator<HasIndex> iCloser = closers == null ? null : closers.tailSet(start, false).iterator();

  // now step through both sets
  
  int level = 1;
  HasIndex nextOpener = iOpener != null && iOpener.hasNext() ? iOpener.next() : null;
  HasIndex nextCloser = iCloser != null && iCloser.hasNext() ? iCloser.next() : null;

  while (true) {
    if (nextCloser == null) return n; // block isn't closed
    
    if (nextOpener != null && nextOpener.idx < nextCloser.idx) {
      // process opener
      ++level;
      nextOpener = iOpener.hasNext() ? iOpener.next() : null;
    } else {
      // process closer
      if (--level == 0)
        return nextCloser.idx+1;
      nextCloser = iCloser.hasNext() ? iCloser.next() : null;
    }
  }
}


  static boolean isMac() {
    return System.getProperty("os.name").toLowerCase().contains("mac");
	}


static boolean isJavaxCompilableSnippetTypeExceptInclude(int type) {
  return isJavaxApplicationSnippetType(type)
    || isJavaxModuleSnippetType(type)
    || type == snippetType_dynModule();
}


static int javaxIncludeSnippetType() {
  return 42;
}


static List<String> hotwire_libraryIDsFromJar_deleteJarOnFail(File jar) {
  try {
    return hotwire_libraryIDsFromJar(jar);
  } catch (Throwable _e) {
    jar.delete();
  
throw rethrow(_e); }
}


static byte[] isJAR_magic = bytesFromHex("504B0304");

static boolean isJAR(byte[] data) {
  return byteArrayStartsWith(data, isJAR_magic);
}

static boolean isJAR(File f) {
  return isJAR(loadBeginningOfBinaryFile(f, l(isJAR_magic)));
}




static boolean isJavaxApplicationSnippetType(int type) {
  return type == snippetType_javaxSource() || type == snippetType_JavaXDesktop();
}


static boolean isJavaxModuleSnippetType(int type) {
  return type == snippetType_javaxModule() || type == snippetType_javaxDesktopModule();
}


static int snippetType_dynModule() {
  return 57;
}


static List<String> hotwire_libraryIDsFromJar(File jar) {
  String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
  return regexpExtractAll("\\d+", dehlibs);
}




static int snippetType_javaxSource() {
  return 34;
}


static int snippetType_JavaXDesktop() {
  return 55;
}


static int snippetType_javaxModule() {
  return 54;
}


static int snippetType_javaxDesktopModule() {
  return 58;
}


static List<String> regexpExtractAll(String pat, String s) {
  if (s == null) return null;
  Matcher m = regexpMatcher(pat, s);
  List<String> out = new ArrayList();
  while (m.find())
    out.add(m.group());
  return out;
}




static class Chain<A> implements Iterable<A> {
  A element;
  Chain<A> next;
  int size;
  
  Chain() {}
  Chain(A element) {
  this.element = element; size = 1; }
  Chain(A element, Chain<A> next) {
  this.next = next;
  this.element = element;
    size = next != null ? next.size+1 : 1;
  }
  
  public String toString() { return str(toList()); }
  
  ArrayList<A> toList() {
    ArrayList<A> l = emptyList(size);
    Chain<A> c = this;
    while (c != null) {
      l.add(c.element);
      c = c.next;
    }
    return l;
  }
  
  // TODO: optimize
  public Iterator<A> iterator() { return toList().iterator(); }
}
static class CountingOutputStream extends FilterOutputStream {
  long counter;
  
  CountingOutputStream(OutputStream out) { super(out); }
  
  @Override
  public void write(int b) throws IOException {
    ++counter;
    out.write(b);
  }

  @Override
  public void write(byte[] b) throws IOException {
    counter += b.length;
    out.write(b, 0, b.length);
  }

  @Override
  public void write(byte[] b, int off, int len) throws IOException {
    if (len == 0) return;
    counter += len;
    out.write(b, off, len);
  }
  
  long getFilePointer() { return counter; }
}
static interface IContentsIndexedList2<A> extends List<A> {
  TreeSet<HasIndex> indicesOf_treeSetOfHasIndex(A o);
}
// Note: This does have the values problem (complicated values can cause memory leaks)
static class BetterThreadLocal<A> {
  Map<Thread, A> map = newWeakHashMap();
  
  BetterThreadLocal() {}
  BetterThreadLocal(A value) { set(value); }
  
  boolean isSet() { return map.containsKey(currentThread()); }
  
  A get() {
    if (map.containsKey(currentThread()))
      return map.get(currentThread());
    A value = initialValue();
    set(value);
    return value;
  }
  
  A get(Thread thread) {
    return thread == null ? null : map.get(thread);
  }
  
  void set(A a) {
    map.put(currentThread(), a);
  }
  
  public A initialValue() { return null; }
}
// size:
// 64 bytes for 0 to 1 elements
// 96 bytes for 2 to 4 elements

/*
 * #!
 * Ontopia Engine
 * #-
 * Copyright (C) 2001 - 2013 The Ontopia Project
 * #-
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * !#
 */

static class CompactHashMap<K, V> extends CompactAbstractMap<K, V> {
  final static int INITIAL_SIZE = 3;
  final static double LOAD_FACTOR = 0.6;

  // This object is used to represent null, should clients use that as
  final static Object nullObject = new Object();
  
  /**
   * When a key is deleted this object is put into the hashtable in
   * its place, so that other entries with the same key (collisions)
   * further down the hashtable are not lost after we delete an object
   * in the collision chain.
   */
  final static Object deletedObject = new Object();
  int elements;
  int freecells;
  Object[] table; // key, value, key, value, ...
  //int modCount;

  CompactHashMap() {
    this(INITIAL_SIZE);
  }

  CompactHashMap(int size) {
    table = new Object[(size==0 ? 1 : size)*2];
    elements = 0;
    freecells = tableSize();
    //modCount = 0;
  }
  
  // TODO: allocate smarter
  CompactHashMap(Map<K, V> map) {
    this(0);
    if (map != null) putAll(map);
  }

  // ===== MAP IMPLEMENTATION =============================================

  /**
   * Returns the number of key/value mappings in this map.
   */
  public synchronized int size() {
    return elements;
  }
  
  /**
   * Returns <tt>true</tt> if this map contains no mappings.
   */
  public synchronized boolean isEmpty() {
    return elements == 0;
  }

  /**
   * Removes all key/value mappings in the map.
   */
  public synchronized void clear() {
    elements = 0;
    for (int ix = 0; ix < tableSize(); ix++) {
      key(ix, null);
      value(ix, null);
    }
    freecells = tableSize();
    //modCount++;
  }
  
  /**
   * Returns <tt>true</tt> if this map contains the specified key.
   */
  public synchronized boolean containsKey(Object k) {
    return key(findKeyIndex(k)) != null;
  }
  
  /**
   * Returns <tt>true</tt> if this map contains the specified value.
   */
  public synchronized boolean containsValue(Object v) {
    if (v == null)
      v = (V)nullObject;

    for (int ix = 0; ix < tableSize(); ix++)
      if (value(ix) != null && value(ix).equals(v))
        return true;

    return false;
  }

  /**
   * Returns a read-only set view of the map's keys.
   */
  public synchronized Set<Entry<K, V>> entrySet() {
    throw new UnsupportedOperationException();
  }

  /**
   * Removes the mapping with key k, if there is one, and returns its
   * value, if there is one, and null if there is none.
   */
  public synchronized V remove(Object k) {
    int index = findKeyIndex(k);

    // we found the right position, now do the removal
    if (key(index) != null) {
      // we found the object

      // same problem here as with put
      V v = value(index);
      key(index, deletedObject);
      value(index, deletedObject);
      //modCount++;
      elements--;
      return v;
    } else
      // we did not find the key
      return null;
  }

  /**
   * Adds the specified mapping to this map, returning the old value for
   * the mapping, if there was one.
   */
  public synchronized V put(K k, V v) {
    if (k == null)
      k = (K)nullObject;

    int hash = k.hashCode();
    int index = (hash & 0x7FFFFFFF) % tableSize();
    int offset = 1;
    int deletedix = -1;
    
    // search for the key (continue while !null and !this key)
    while(key(index) != null &&
          !(key(index).hashCode() == hash &&
            key(index).equals(k))) {

      // if there's a deleted mapping here we can put this mapping here,
      // provided it's not in here somewhere else already
      if (key(index) == deletedObject)
        deletedix = index;
      
      index = ((index + offset) & 0x7FFFFFFF) % tableSize();
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }
    
    if (key(index) == null) { // wasn't present already
      if (deletedix != -1) // reusing a deleted cell
        index = deletedix;
      else
        freecells--;

      //modCount++;
      elements++;

      key(index, k);
      value(index, v);
      
      // rehash with increased capacity
      if (1 - (freecells / (double) tableSize()) > LOAD_FACTOR)
        rehash(tableSize()*2 + 1);
      return null;
    } else { // was there already
      //modCount++;
      V oldv = value(index);
      value(index, v);
      return oldv;
    }
  }

  /**
   * INTERNAL: Rehashes the hashmap to a bigger size.
   */
  void rehash(int newCapacity) {
    int oldCapacity = tableSize();
    Object[] newTable = new Object[newCapacity*2];

    for (int ix = 0; ix < oldCapacity; ix++) {
      Object k = key(ix);
      if (k == null || k == deletedObject)
        continue;
      
      int hash = k.hashCode();
      int index = (hash & 0x7FFFFFFF) % newCapacity;
      int offset = 1;

      // search for the key
      while(newTable[index*2] != null) { // no need to test for duplicates
        index = ((index + offset) & 0x7FFFFFFF) % newCapacity;
        offset = offset*2 + 1;

        if (offset == -1)
          offset = 2;
      }

      newTable[index*2] = k;
      newTable[index*2+1] = value(ix);
    }

    table = newTable;
    freecells = tableSize() - elements;
  }

  /**
   * Returns the value for the key k, if there is one, and null if
   * there is none.
   */
  public synchronized V get(Object k) {
    return value(findKeyIndex(k));
  }

  /**
   * Returns a virtual read-only collection containing all the values
   * in the map.
   */
  public synchronized Collection<V> values() {
    return new ValueCollection();
  }

  /**
   * Returns a virtual read-only set of all the keys in the map.
   */
  public synchronized Set<K> keySet() {
    return new KeySet();
  }

  // --- Internal utilities

  final int findKeyIndex(Object k) {
    if (k == null)
      k = nullObject;

    int hash = k.hashCode();
    int index = (hash & 0x7FFFFFFF) % tableSize();
    int offset = 1;

    // search for the key (continue while !null and !this key)
    while(key(index) != null &&
          !(key(index).hashCode() == hash &&
            key(index).equals(k))) {
      index = ((index + offset) & 0x7FFFFFFF) % tableSize();
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }
    return index;
  }
  
  // --- Key set

  class KeySet<K> extends AbstractSet<K> {
    public synchronized int size() {
      return elements;
    }

    public synchronized boolean contains(Object k) {
      return containsKey(k);
    }

    public synchronized Iterator<K> iterator() {
      return new KeyIterator();
    }
  }

  class KeyIterator<K> implements Iterator<K> {
    private int ix;
    
    private KeyIterator() {
      // walk up to first value, so that hasNext() and next() return
      // correct results
      for (; ix < tableSize(); ix++)
        if (value(ix) != null && key(ix) != deletedObject)
          break;
    }

    public synchronized boolean hasNext() {
      return ix < tableSize();
    }

    public synchronized void remove() {
      throw new UnsupportedOperationException("Collection is read-only");
    }

    public synchronized K next() {
      if (ix >= tableSize())
        throw new NoSuchElementException();
      K key = (K) key(ix++);
      
      // walk up to next value
      for (; ix < tableSize(); ix++)
        if (key(ix) != null && key(ix) != deletedObject)
          break;
      
      // ix now either points to next key, or outside array (if no next)
      return key;
    }
  }
  
  // --- Value collection

  class ValueCollection<V> extends AbstractCollection<V> {
    public synchronized int size() {
      return elements;
    }

    public synchronized Iterator<V> iterator() {
      return new ValueIterator();
    }

    public synchronized boolean contains(Object v) {
      return containsValue(v);
    }
  }

  class ValueIterator<V> implements Iterator<V> {
    private int ix;
    
    private ValueIterator() {
      // walk up to first value, so that hasNext() and next() return
      // correct results
      for (; ix < table.length/2; ix++)
        if (value(ix) != null && value(ix) != deletedObject)
          break;
    }

    public synchronized boolean hasNext() {
      return ix < tableSize();
    }

    public synchronized void remove() {
      throw new UnsupportedOperationException("Collection is read-only");
    }

    public synchronized V next() {
      if (ix >= tableSize())
        throw new NoSuchElementException();
      V value = (V) value(ix++);
      
      // walk up to next value
      for (; ix < tableSize(); ix++)
        if (value(ix) != null && value(ix) != deletedObject)
          break;
      
      // ix now either points to next value, or outside array (if no next)
      return value;
    }
  }
  
  K key(int i) { return (K) table[i*2]; }
  void key(int i, Object key) { table[i*2] = key; }
  V value(int i) { return (V) table[i*2+1]; }
  void value(int i, Object value) { table[i*2+1] = value; }
  
  int tableSize() { return table.length/2; }
}
static class ReverseChain<A> implements Iterable<A> {
  A element;
  ReverseChain<A> prev;
  int size;
  
  ReverseChain() {}
  ReverseChain(ReverseChain<A> prev, A element) {
  this.element = element;
  this.prev = prev;
    if (prev == null) size = 1;
    else {
      prev.check();
      size = prev.size+1;
    }
  }
  
  void check() {
    if (size < 1) throw fail("You called the ReverseChain default constructor. Don't do that");
  }
  
  public String toString() {
    return str(toList());
  }
  
  ArrayList<A> toList() {
    check();
    ArrayList<A> l = emptyList(size);
    for (int i = 0; i < size; i++) l.add(null);
    int i = size;
    ReverseChain<A> c = this;
    while (c != null) {
      l.set(--i, c.element);
      c = c.prev;
    }
    return l;
  }
  
  public Iterator<A> iterator() { return toList().iterator(); }
}
// -has fast nextElement() and prevElement()
// -design allows for more functions like reordering the list
// -Saves up to 34% in space over LinkedHashSet
//    (e.g. 22% for a set of 1,000 Ints)
static class CompactLinkedHashSet<A> extends AbstractSet<A> {
  UnsynchronizedCompactHashSet<Entry<A>> entries = new UnsynchronizedCompactHashSet();
  Entry<A> head, tail;
  
  static class Entry<A> {
    A value;
    Entry<A> prev, next;
    
    public int hashCode() {
      return _hashCode(value);
    }
    
    // "magic" equals function for CompactHashSet lookup without temp object
    public boolean equals(Object o) {
      return o == this || eq(value, o);
    }
  }
  
  public boolean add(A a) {
    if (entries.contains(a)) return false;
    Entry<A> n = new Entry();
    n.value = a;
    n.prev = tail;
    if (tail != null) tail.next = n;
    tail = n;
    if (head == null) head = n;
    entries.add(n);
    return true;
  }
  
  public boolean remove(Object a) {
    return remove(entries.find(a));
  }
  
  public boolean remove(Entry<A> node) {
    if (node == null) return false;
    if (node.next != null) node.next.prev = node.prev; else tail = node.prev;
    if (node.prev != null) node.prev.next = node.next; else head = node.next;
    entries.remove(node);
    return true;
  }
  
  public int size() { return entries.size(); }
  
  public IterableIterator<A> iterator() {
    return new IterableIterator<A>() {
      Entry<A> entry = head, prev = null;
      public boolean hasNext() { return entry != null; }
      public A next() {
        A a = entry.value;
        prev = entry;
        entry = entry.next;
        return a;
      }
      
      // untested
      public void remove() {
        if (prev == null) throw new IllegalStateException();
        CompactLinkedHashSet.this.remove(prev);
        prev = null;
      }
    };
  }
  
  public void clear() {
    entries.clear();
    head = tail = null;
  }
  
  public boolean contains(Object a) {
    return entries.contains(a);
  }
  
  public A find(Object o) {
    Entry<A> e = entries.find(o);
    return e == null ? null : e.value;
  }
  
  public A prevElement(A a) {
    Entry<A> e = entries.find(a);
    if (e == null || e.prev == null) return null;
    return e.prev.value;
  }
  
  public A nextElement(A a) {
    Entry<A> e = entries.find(a);
    if (e == null || e.next == null) return null;
    return e.next.value;
  }
  
  public A first() { return head == null ? null : head.value; }
  public A last() { return tail == null ? null : tail.value; }
  
  boolean removeIfSame(Object o) {
    A value = find(o);
    if (value == o) {
      remove(value);
      return true;
    }
    return false;
  }
}
static class HasIndex implements Comparable<HasIndex> {
  int idx;
  
  HasIndex() {}
  HasIndex(int idx) {
  this.idx = idx;}
  
  public int compareTo(HasIndex h) {
    return idx-h.idx;
  }
  
  final int get() { return idx; }
}
static class T3<A, B, C> {
  A a;
  B b;
  C c;
  
  T3() {}
  T3(A a, B b, C c) {
  this.c = c;
  this.b = b;
  this.a = a;}
  T3(T3<A, B, C> t) { a = t.a; b = t.b; c = t.c; }
  
  public int hashCode() {
    return _hashCode(a) + 2*_hashCode(b) - 4*_hashCode(c);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof T3)) return false;
    T3 t = (T3) o;
    return eq(a, t.a) && eq(b, t.b) && eq(c, t.c);
  }
  
  public String toString() {
    return "(" + quoteBorderless(a) + ", " + quoteBorderless(b) + ", " + quoteBorderless(c) + ")";
  }
}


abstract static class CompactAbstractMap<K, V> implements Map<K, V> {
  public int size() {
      return entrySet().size();
  }

  public boolean isEmpty() {
      return size() == 0;
  }

  public boolean containsValue(Object value) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (value == null) {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (e.getValue() == null)
                  return true;
          }
      } else {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (value.equals(e.getValue()))
                  return true;
          }
      }
      return false;
  }

  public boolean containsKey(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (key == null) {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (e.getKey() == null)
                  return true;
          }
      } else {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (key.equals(e.getKey()))
                  return true;
          }
      }
      return false;
  }

  public V get(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (key == null) {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (e.getKey() == null)
                  return e.getValue();
          }
      } else {
          while (i.hasNext()) {
              Entry<K, V> e = i.next();
              if (key.equals(e.getKey()))
                  return e.getValue();
          }
      }
      return null;
  }

  public V put(K key, V value) {
      throw new UnsupportedOperationException();
  }

  public V remove(Object key) {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      Entry<K, V> correctEntry = null;
      if (key == null) {
          while (correctEntry == null && i.hasNext()) {
              Entry<K, V> e = i.next();
              if (e.getKey() == null)
                  correctEntry = e;
          }
      } else {
          while (correctEntry == null && i.hasNext()) {
              Entry<K, V> e = i.next();
              if (key.equals(e.getKey()))
                  correctEntry = e;
          }
      }

      V oldValue = null;
      if (correctEntry != null) {
          oldValue = correctEntry.getValue();
          i.remove();
      }
      return oldValue;
  }

  public void putAll(Map<? extends K, ? extends V> m) {
      for (Entry<? extends K, ? extends V> e : m.entrySet())
          put(e.getKey(), e.getValue());
  }

  public void clear() {
      entrySet().clear();
  }

  public Set<K> keySet() {
      return new AbstractSet<K>() {
          public Iterator<K> iterator() {
              return new Iterator<K>() {
                  private Iterator<Entry<K, V>> i = entrySet().iterator();

                  public boolean hasNext() {
                      return i.hasNext();
                  }

                  public K next() {
                      return i.next().getKey();
                  }

                  public void remove() {
                      i.remove();
                  }
              };
          }

          public int size() {
              return CompactAbstractMap.this.size();
          }

          public boolean isEmpty() {
              return CompactAbstractMap.this.isEmpty();
          }

          public void clear() {
              CompactAbstractMap.this.clear();
          }

          public boolean contains(Object k) {
              return CompactAbstractMap.this.containsKey(k);
          }
      };
  }

  public Collection<V> values() {
      return new AbstractCollection<V>() {
          public Iterator<V> iterator() {
              return new Iterator<V>() {
                  private Iterator<Entry<K, V>> i = entrySet().iterator();

                  public boolean hasNext() {
                      return i.hasNext();
                  }

                  public V next() {
                      return i.next().getValue();
                  }

                  public void remove() {
                      i.remove();
                  }
              };
          }

          public int size() {
              return CompactAbstractMap.this.size();
          }

          public boolean isEmpty() {
              return CompactAbstractMap.this.isEmpty();
          }

          public void clear() {
              CompactAbstractMap.this.clear();
          }

          public boolean contains(Object v) {
              return CompactAbstractMap.this.containsValue(v);
          }
      };
  }

  public abstract Set<Entry<K, V>> entrySet();

  public boolean equals(Object o) {
      if (o == this)
          return true;

      if (!(o instanceof Map))
          return false;
      Map<?, ?> m = (Map<?, ?>) o;
      if (m.size() != size())
          return false;

      try {
          for (Entry<K, V> e : entrySet()) {
              K key = e.getKey();
              V value = e.getValue();
              if (value == null) {
                  if (!(m.get(key) == null && m.containsKey(key)))
                      return false;
              } else {
                  if (!value.equals(m.get(key)))
                      return false;
              }
          }
      } catch (ClassCastException unused) {
          return false;
      } catch (NullPointerException unused) {
          return false;
      }

      return true;
  }

  public int hashCode() {
      int h = 0;
      for (Entry<K, V> entry : entrySet())
          h += entry.hashCode();
      return h;
  }

  public String toString() {
      Iterator<Entry<K, V>> i = entrySet().iterator();
      if (!i.hasNext())
          return "{}";

      StringBuilder sb = new StringBuilder();
      sb.append('{');
      for (; ; ) {
          Entry<K, V> e = i.next();
          K key = e.getKey();
          V value = e.getValue();
          sb.append(key == this ? "(this Map)" : key);
          sb.append('=');
          sb.append(value == this ? "(this Map)" : value);
          if (!i.hasNext())
              return sb.append('}').toString();
          sb.append(',').append(' ');
      }
  }

  protected Object clone() throws CloneNotSupportedException {
      CompactAbstractMap<?, ?> result = (CompactAbstractMap<?, ?>) super.clone();
      return result;
  }

  public static class SimpleEntry<K, V>
          implements Entry<K, V>, java.io.Serializable {
      @java.io.Serial
      private static final long serialVersionUID = -8499721149061103585L;

      @SuppressWarnings("serial")
      private final K key;
      @SuppressWarnings("serial")
      private V value;

      public SimpleEntry(K key, V value) {
          this.key = key;
          this.value = value;
      }

      public SimpleEntry(Entry<? extends K, ? extends V> entry) {
          this.key = entry.getKey();
          this.value = entry.getValue();
      }

      public K getKey() {
          return key;
      }

      public V getValue() {
          return value;
      }

      public V setValue(V value) {
          V oldValue = this.value;
          this.value = value;
          return oldValue;
      }

      public boolean equals(Object o) {
          if (!(o instanceof Map.Entry))
              return false;
          Entry<?, ?> e = (Entry<?, ?>) o;
          return eq(key, e.getKey()) && eq(value, e.getValue());
      }

      public int hashCode() {
          return (key == null ? 0 : key.hashCode()) ^
                  (value == null ? 0 : value.hashCode());
      }

      public String toString() {
          return key + "=" + value;
      }

  }

  public static class SimpleImmutableEntry<K, V>
          implements Entry<K, V>, java.io.Serializable {
      @java.io.Serial
      private static final long serialVersionUID = 7138329143949025153L;

      @SuppressWarnings("serial")
      private final K key;
      @SuppressWarnings("serial")
      private final V value;

      public SimpleImmutableEntry(K key, V value) {
          this.key = key;
          this.value = value;
      }

      public SimpleImmutableEntry(Entry<? extends K, ? extends V> entry) {
          this.key = entry.getKey();
          this.value = entry.getValue();
      }

      public K getKey() {
          return key;
      }

      public V getValue() {
          return value;
      }

      public V setValue(V value) {
          throw new UnsupportedOperationException();
      }

      public boolean equals(Object o) {
          if (!(o instanceof Map.Entry))
              return false;
          Entry<?, ?> e = (Entry<?, ?>) o;
          return eq(key, e.getKey()) && eq(value, e.getValue());
      }

      public int hashCode() {
          return (key == null ? 0 : key.hashCode()) ^
                  (value == null ? 0 : value.hashCode());
      }

      public String toString() {
          return key + "=" + value;
      }
  }
}
/*
 * #!
 * Ontopia Engine
 * #-
 * Copyright (C) 2001 - 2013 The Ontopia Project
 * #-
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * !#
 */

// modified by Stefan Reich

// Implements the Set interface more compactly than
// java.util.HashSet by using a closed hashtable.

// Note: equals is always called on the _stored_ object, not the one
// passed as an argument to find(), contains() etc.
// (In case you want to put special magic in your equals() function)

static class UnsynchronizedCompactHashSet<A> extends java.util.AbstractSet<A> {
  protected final static int INITIAL_SIZE = 3;
  public final static double LOAD_FACTOR = 0.75;

  protected final static Object nullObject = new Object();
  protected final static Object deletedObject = new Object();
  protected int elements;
  protected int freecells;
  protected A[] objects;
  
  protected int modCount;
  
  
  UnsynchronizedCompactHashSet() {
    this(INITIAL_SIZE);
  }

  UnsynchronizedCompactHashSet(int size) {
    // NOTE: If array size is 0, we get a
    // "java.lang.ArithmeticException: / by zero" in add(Object).
    objects = (A[]) new Object[(size==0 ? 1 : size)];
    elements = 0;
    freecells = objects.length;
    
      modCount = 0;
    
  }

  UnsynchronizedCompactHashSet(Collection<A> c) {
    this(c.size());
    addAll(c);
  }

  @Override
  public Iterator<A> iterator() {
    return new CompactHashIterator<A>();
  }

  @Override
  public int size() {
    return elements;
  }

  @Override
  public boolean isEmpty() {
    return elements == 0;
  }

  @Override
  public boolean contains(Object o) {
    return find(o) != null;
  }
  
  A find(Object o) {
    if (o == null) o = nullObject;
    
    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;

    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }

    return objects[index];
  }
  
  boolean removeIfSame(Object o) {
    A value = find(o);
    if (value == o) {
      remove(value);
      return true;
    }
    return false;
  }

  @Override
  public boolean add(Object o) {
    if (o == null) o = nullObject;

    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;
    int deletedix = -1;
    
    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {

      // if there's a deleted object here we can put this object here,
      // provided it's not in here somewhere else already
      if (objects[index] == deletedObject)
        deletedix = index;
      
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }
    
    if (objects[index] == null) { // wasn't present already
      if (deletedix != -1) // reusing a deleted cell
        index = deletedix;
      else
        freecells--;

      
        modCount++;
      
      elements++;

      // here we face a problem regarding generics:
      // add(A o) is not possible because of the null Object. We cant do 'new A()' or '(A) new Object()'
      // so adding an empty object is a problem here
      // If (! o instanceof A) : This will cause a class cast exception
      // If (o instanceof A) : This will work fine

      objects[index] = (A) o;
      
      // do we need to rehash?
      if (1 - (freecells / (double) objects.length) > LOAD_FACTOR)
        rehash();
      return true;
    } else // was there already 
      return false;
  }
  
  @Override
  public boolean remove(Object o) {
    if (o == null) o = nullObject;
    
    int hash = o.hashCode();
    int index = (hash & 0x7FFFFFFF) % objects.length;
    int offset = 1;
    
    // search for the object (continue while !null and !this object)
    while(objects[index] != null &&
          !(objects[index].hashCode() == hash &&
            objects[index].equals(o))) {
      index = ((index + offset) & 0x7FFFFFFF) % objects.length;
      offset = offset*2 + 1;

      if (offset == -1)
        offset = 2;
    }

    // we found the right position, now do the removal
    if (objects[index] != null) {
      // we found the object

      // same problem here as with add
      objects[index] = (A) deletedObject;
      
        modCount++;
      
      elements--;
      return true;
    } else
      // we did not find the object
      return false;
  }
  
  @Override
  public void clear() {
    elements = 0;
    for (int ix = 0; ix < objects.length; ix++)
      objects[ix] = null;
    freecells = objects.length;
    
      modCount++;
    
  }

  @Override
  public Object[] toArray() {
    Object[] result = new Object[elements];
    Object[] objects = this.objects;
    int pos = 0;
    for (int i = 0; i < objects.length; i++)
      if (objects[i] != null && objects[i] != deletedObject) {
        if (objects[i] == nullObject)
          result[pos++] = null;
        else
          result[pos++] = objects[i];
      }
    // unchecked because it should only contain A
    return result;
  }

  // not sure if this needs to have generics
  @Override
  public <T> T[] toArray(T[] a) {
    int size = elements;
    if (a.length < size)
      a = (T[])java.lang.reflect.Array.newInstance(
                                 a.getClass().getComponentType(), size);
    A[] objects = this.objects;
    int pos = 0;
    for (int i = 0; i < objects.length; i++)
      if (objects[i] != null && objects[i] != deletedObject) {
        if (objects[i] == nullObject)
          a[pos++] = null;
        else
          a[pos++] = (T) objects[i];
      }
    return a;
  }
  
  protected void rehash() {
    int garbagecells = objects.length - (elements + freecells);
    if (garbagecells / (double) objects.length > 0.05)
      // rehash with same size
      rehash(objects.length);
    else
      // rehash with increased capacity
      rehash(objects.length*2 + 1);
  }
  
  protected void rehash(int newCapacity) {
    int oldCapacity = objects.length;
    @SuppressWarnings("unchecked")
    A[] newObjects = (A[]) new Object[newCapacity];

    for (int ix = 0; ix < oldCapacity; ix++) {
      Object o = objects[ix];
      if (o == null || o == deletedObject)
        continue;
      
      int hash = o.hashCode();
      int index = (hash & 0x7FFFFFFF) % newCapacity;
      int offset = 1;

      // search for the object
      while(newObjects[index] != null) { // no need to test for duplicates
        index = ((index + offset) & 0x7FFFFFFF) % newCapacity;
        offset = offset*2 + 1;

        if (offset == -1)
          offset = 2;
      }

      newObjects[index] = (A) o;
    }

    objects = newObjects;
    freecells = objects.length - elements;
  }
  
  private class CompactHashIterator<T> implements Iterator<T> {
    private int index;
    private int lastReturned = -1;

    
      private int expectedModCount;
    

    @SuppressWarnings("empty-statement")
    public CompactHashIterator() {
        for (index = 0; index < objects.length &&
                        (objects[index] == null ||
                        objects[index] == deletedObject); index++)
          ;
        
          expectedModCount = modCount;
        
    }

    @Override
    public boolean hasNext() {
        return index < objects.length;
    }

    @SuppressWarnings("empty-statement")
    @Override
    public T next() {
        /*if (modCount != expectedModCount)
          throw new ConcurrentModificationException();*/
        int length = objects.length;
        if (index >= length) {
          lastReturned = -2;
          throw new NoSuchElementException();
        }
  
        lastReturned = index;
        for (index += 1; index < length &&
                         (objects[index] == null ||
                          objects[index] == deletedObject); index++)
          ;
        if (objects[lastReturned] == nullObject)
          return null;
        else
          return (T) objects[lastReturned];
    }

    @Override
    public void remove() {
        
          if (modCount != expectedModCount)
            throw new ConcurrentModificationException();
        
        if (lastReturned == -1 || lastReturned == -2)
          throw new IllegalStateException();
        // delete object
        if (objects[lastReturned] != null && objects[lastReturned] != deletedObject) {
          objects[lastReturned] = (A) deletedObject;
          elements--;
          
            modCount++;
            expectedModCount = modCount; // this is expected; we made the change
          
        }
    }
  }
  
  int capacity() { return objects.length; }
  
  // returns true if there was a shrink
  boolean shrinkToFactor(double factor) {
    if (factor > LOAD_FACTOR)
      throw fail("Shrink factor must be equal to or smaller than load factor: " + factor + " / " + LOAD_FACTOR);
    int newCapacity = max(INITIAL_SIZE, iround(size()/factor));
    if (newCapacity >= capacity()) return false;
    rehash(newCapacity);
    return true;
  }
}


static boolean scaffoldingEnabled(Object o) {
  return metaGet(o, "scaffolding") != null;
}


static <A> Value<A> value(A a) {
  return new Value<A>(a);
}


static String find(String pattern, String text) {
  Matcher matcher = Pattern.compile(pattern).matcher(text);
  if (matcher.find())
    return matcher.group(1);
  return null;
}

static <A> A find(Collection<A> c, Object... data) {
  for (A x : c)
    if (checkFields(x, data))
      return x;
  return null;
}


static String quoteBorderless(Object o) {
  if (o == null) return "null";
  return quoteBorderless(str(o));
}

static String quoteBorderless(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5));
  quoteBorderless_impl(s, out);
  return out.toString();
}
  
static void quoteBorderless_impl(String s, StringBuilder out) {
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
}




static boolean checkFields(Object x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(getOpt(x, (String) data[i]), data[i+1]))
      return false;
  return true;
}




static class Value<A> implements IF0<A> , IFieldsToList{
  A value;
  Value() {}
  Value(A value) {
  this.value = value;}

public boolean equals(Object o) {
if (!(o instanceof Value)) return false;
    Value __1 =  (Value) o;
    return eq(value, __1.value);
}

  public int hashCode() {
    int h = 82420049;
    h = boostHashCombine(h, _hashCode(value));
    return h;
  }
  public Object[] _fieldsToList() { return new Object[] {value}; }

  public A get() { return value; }
  
  public String toString() { return str(get()); }
}

}
class m1013927{}