import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;


class main {
public static void main(final String[] args) throws Exception {
  List<String> l = repF("aGlobalID", 1000);
  
  int n = 1000;
  for (int _repeat_0 = 0; _repeat_0 < 10; _repeat_0++)  {
    long _startTime_5 = sysNow(); 
      for (int _repeat_1 = 0; _repeat_1 < n; _repeat_1++)  { for (String s : l) s.intern(); }
     done2("String.intern", _startTime_5); 
    long _startTime_6 = sysNow(); 
      for (int _repeat_2 = 0; _repeat_2 < n; _repeat_2++)  { for (String s : l) internPerProgram(s); }
     done2("internPerProgram", _startTime_6); 
    long _startTime_7 = sysNow(); 
      for (int _repeat_3 = 0; _repeat_3 < n; _repeat_3++)  { for (String s : l) fastIntern(s); }
     done2("fastIntern", _startTime_7); 
    long _startTime_8 = sysNow(); 
      for (int _repeat_4 = 0; _repeat_4 < n; _repeat_4++)  { for (String s : l) intern(s); }
     done2("intern(S)", _startTime_8); 
  }
  
  //printBenchResult(n);
}
static String aGlobalID() {
  return randomID(16);
}
static long sysNow() {
  return System.nanoTime()/1000000;
}
static String intern(String s) {
  return fastIntern(s);
}
static RuntimeException asRuntimeException(Throwable t) {
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static WeakHashMap2 internPerProgram_map = new WeakHashMap2();

static String internPerProgram(String s) {
  if (s == null) return null;
   synchronized(internPerProgram_map) {
    WeakHashMap2.Entry<String, Boolean> e = internPerProgram_map.getEntry(s);
    String sym = e == null ? null : (String) e.get();
    if (sym == null)
      internPerProgram_map.put(sym = s, Boolean.TRUE);
    return sym;
  }
}

static int done2_minPrint = 10;

static long done2(long startTime, String desc) {
  return done2(startTime, desc, done2_minPrint);
}

static long done2(long startTime, String desc, int minPrint) {
  long time = sysNow()-startTime;
  saveTiming_noPrint(time);
  if (time >= minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done2(String desc, long startTime) {
  return done2(startTime, desc);
}

static long done2(long startTime) {
  return done2(startTime, "");
}
static Map<Thread, Boolean> _registerThread_threads = Collections.synchronizedMap(new WeakHashMap());

static Thread _registerThread(Thread t) {
  _registerThread_threads.put(t, true);
  return t;
}

static void _registerThread() { _registerThread(Thread.currentThread()); }
static List repF(int n, Object f, Object... args) {
  List l = new ArrayList();
  for (int i = 0; i < n; i++)
    l.add(callF(f, args));
  return l;
}

static List repF(Object f, int n) {
  return repF(n, f);
}
static Method fastIntern_method;

static String fastIntern(String s) { try {
  if (s == null) return null;
  if (fastIntern_method == null) {
    fastIntern_method = findMethodNamed(javax(), "internPerProgram");
    if (fastIntern_method == null) upgradeJavaXAndRestart();
  }
    
  return (String) fastIntern_method.invoke(null, s);
} catch (Exception __e) { throw rethrow(__e); } }


static RuntimeException rethrow(Throwable e) {
  throw asRuntimeException(e);
}
static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();




  static <A, B> B callF(F1<A, B> f, A a) {
    return f == null ? null : f.get(a);
  }


static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMC((String) f, args);
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) throw fail("No get method in " + getClassName(c));
  if (n == 1) return methods.get(0).invoke(f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return m.invoke(f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static void upgradeJavaXAndRestart() {
  run("#1001639");
  restart();
  sleep();
}
static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}
static volatile StringBuffer local_log = new StringBuffer(); // not redirected
static volatile StringBuffer print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;
//static int print_maxLineLength = 0; // 0 = unset

static boolean print_silent; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<F1<String, Boolean>> print_byThread; // special handling by thread

static void print() {
  print("");
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  if (print_byThread != null) {
    F1<String, Boolean> f = print_byThread.get();
    if (f != null)
      if (isFalse(f.get(s))) return;
  }

  print_raw(s);
}

static void print_raw(String s) {
  s = fixNewLines(s);
  // TODO if (print_maxLineLength != 0)
  StringBuffer loc = local_log;
  StringBuffer buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  System.out.print(s);
}

static void print(long l) {
  print(String.valueOf(l));
}

static void print(char c) {
  print(String.valueOf(c));
}

static void print_append(StringBuffer buf, String s, int max) {
  synchronized(buf) {
    buf.append(s);
    max /= 2;
    if (buf.length() > max) try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
  }
}
static Class javax() {
  return getJavaX();
}
static ThreadLocal<Long> saveTiming_last = new ThreadLocal();

static void saveTiming(long ms) {
  print(ms + " ms");
  saveTiming_noPrint(ms);
}

static void saveTiming_noPrint(long ms) {
  saveTiming_last.set(ms);
}
// This is a bit rough... finds static and non-static methods.

static Method findMethodNamed(Object obj, String method) {
  if (obj == null) return null;
  if (obj instanceof Class)
    return findMethodNamed((Class) obj, method);
  return findMethodNamed(obj.getClass(), method);
}

static Method findMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method)) {
        m.setAccessible(true);
        return m;
      }
    c = c.getSuperclass();
  }
  return null;
}


static String fixNewLines(String s) {
  return s.replace("\r\n", "\n").replace("\r", "\n");
}
static volatile boolean ping_pauseAll;
static int ping_sleep = 100; // poll pauseAll flag every 100
static volatile boolean ping_anyActions;
static Map<Thread, Object> ping_actions = (Map) synchroMap(newWeakHashMap());

// always returns true
static boolean ping() {
  if (ping_pauseAll || ping_anyActions) ping_impl();
  return true;
}

// returns true when it slept
static boolean ping_impl() { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  if (ping_anyActions) {
    Object action;
    synchronized(ping_actions) {
      action = ping_actions.get(currentThread());
      if (action instanceof Runnable)
        ping_actions.remove(currentThread());
      if (ping_actions.isEmpty()) ping_anyActions = false;
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }
  
  return false;
} catch (Exception __e) { throw rethrow(__e); } }
static Class run(String progID, String... args) {
  Class main = hotwire(progID);
  callMain(main, args);
  return main;
}
static final HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) return callMC_value.invoke(null, args);

  List<Method> m;
  synchronized(callMC_cache) {
    m = callMC_cache.get(method);
  }
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    try {
      return me.invoke(null, args);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException("Can't call " + method + " with " + l(args) + " argument(s)", e);
    }
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return me.invoke(null, args);
  }
  throw fail("No method called " + method + " with matching arguments found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static void callMC_makeCache() {
  synchronized(callMC_cache) {
    callMC_cache.clear();
    Class _c = (Class) mc(), c = _c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods())
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
      c = c.getSuperclass();
    }
  }
}
static volatile boolean sleep_noSleep;

static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  if (sleep_noSleep) throw fail("nosleep");
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }
static Class __javax;

static Class getJavaX() {
  return __javax;
}
static void restart() {
  Object j = getJavaX();
  call(j, "cleanRestart", get(j, "fullArgs"));
}
static String makeRandomID(int length) {
  Random random = new Random();
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}
static boolean isFalse(Object o) {
  return eq(false, o);
}
static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }
static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); } static long l(File f) { return f == null ? 0 : f.length(); }

static int l(Object o) {
  return o instanceof String ? l((String) o)
    : o instanceof Map ? l((Map) o)
    : l((Collection) o); // incomplete
}




static RuntimeException fail() { throw new RuntimeException("fail"); }
static RuntimeException fail(Throwable e) { throw asRuntimeException(e); }
static RuntimeException fail(Object msg) { throw new RuntimeException(String.valueOf(msg)); }
static RuntimeException fail(String msg) { throw new RuntimeException(msg == null ? "" : msg); }
static RuntimeException fail(String msg, Throwable innerException) { throw new RuntimeException(msg, innerException); }

static Object call(Object o) {
  return callFunction(o);
}

// varargs assignment fixer for a single string array argument
static Object call(Object o, String method, String[] arg) {
  return call(o, method, new Object[] {arg});
}

static Object call(Object o, String method, Object... args) {
  try {
    if (o instanceof Class) {
      Method m = call_findStaticMethod((Class) o, method, args, false);
      m.setAccessible(true);
      return m.invoke(null, args);
    } else {
      Method m = call_findMethod(o, method, args, false);
      m.setAccessible(true);
      return m.invoke(o, args);
    }
  } catch (Exception e) {
    throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
  }
}

static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
}

static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && call_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
}

private static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}
static String getClassName(Object o) {
  return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
}


static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static <A> A callMain(A c, String... args) {
  callOpt(c, "main", new Object[] {args});
  return c;
}

static void callMain() {
  callMain(mc());
}
static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static <A, B> Map<A, B> newWeakHashMap() {
  return _registerWeakMap(synchroMap(new WeakHashMap()));
}
static Class mc() {
  return main.class;
}
static Object sleepQuietly_monitor = new Object();

static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(sleepQuietly_monitor) { sleepQuietly_monitor.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }
// get purpose 1: access a list/array/map (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

// seems to conflict with other signatures
/*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      return f.get(o);
    }
      
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(Object o, String field) {
  try {
    Field f = get_findField(o.getClass(), field);
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
static Class<?> hotwire(String src) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    // ret hotwire_overInternalBot(src);
    Class c = (Class) ( call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
  }
}
// extended over Class.isInstance() to handle primitive types
static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static Thread currentThread() {
  return Thread.currentThread();
}
static boolean eq(Object a, Object b) {
  return a == null ? b == null : a == b || a.equals(b);
}


static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static void hotwire_copyOver(Class c) {
  synchronized(StringBuffer.class) {
    for (String field : litlist("print_log", "print_silent", "androidContext")) {
      Object o = getOpt(mc(), field);
      if (o != null)
        setOpt(c, field, o);
    }
      
    Object mainBot = getMainBot();
    if (mainBot != null)
      setOpt(c, "mainBot", mainBot);

    setOpt(c, "creator_class", new WeakReference(mc()));
  }
}
static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
  out.append('"');
}
static List _registerWeakMap_preList;

static <A> A _registerWeakMap(A map) {
  if (javax() == null) {
    // We're in class init
    if (_registerWeakMap_preList == null) _registerWeakMap_preList = synchroList();
    _registerWeakMap_preList.add(map);
    return map;
  }
  
  try {
    call(javax(), "_registerWeakMap", map);
  } catch (Throwable e) {
    printException(e);
    print("Upgrade JavaX!!");
  }
  return map;
}

static void _onLoad_registerWeakMap() {
  assertNotNull(javax());
  if (_registerWeakMap_preList == null) return;
  for (Object o : _registerWeakMap_preList)
    _registerWeakMap(o);
  _registerWeakMap_preList = null;
}
static Object callOpt(Object o) {
  if (o == null) return null;
  return callF(o);
}

static Object callOpt(Object o, String method, Object... args) {
  try {
    if (o == null) return null;
    if (o instanceof Class) {
      Method m = callOpt_findStaticMethod((Class) o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(null, args);
    } else {
      Method m = callOpt_findMethod(o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(o, args);
    }
  } catch (Exception e) {
    //fail(e.getMessage() + " | Method: " + method + ", receiver: " + className(o) + ", args: (" + join(", ", map(f className, args) + ")");
    throw new RuntimeException(e);
  }
}

static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

private static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}


static void assertFalse(Object o) {
  assertEquals(false, o);
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}

static boolean _inCore() {
  return false;
}
static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}



static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
static void printException(Throwable e) {
  printStackTrace(e);
}
static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
static Object mainBot;

static Object getMainBot() {
  return mainBot;
}
static <A> ArrayList<A> litlist(A... a) {
  return new ArrayList<A>(Arrays.asList(a));
}
static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}
static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    
    // It's probably a subclass of Map. Use raw method
    setOpt_raw(o, field, value);
    return;
  }
  
  Field f = map.get(field);
  if (f != null)
    smartSet(f, o, value); // possible improvement: skip setAccessible
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) {
  try {
    Field f = getOpt_findField(o.getClass(), field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

// access of static fields is not yet optimized
static Object getOpt(Class c, String field) {
  try {
    if (c == null) return null;
    Field f = getOpt_findStaticField(c, field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}



static void setOpt_raw(Object o, String field, Object value) {
  if (o == null) return;
  if (o instanceof Class) setOpt_raw((Class) o, field, value);
  else try {
    Field f = setOpt_raw_findField(o.getClass(), field);
    if (f != null)
      smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static void setOpt_raw(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_raw_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_raw_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field setOpt_raw_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static Throwable printStackTrace(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

/*static void printStackTrace(S indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace(e));
}*/
static final Map<Class, HashMap<String, Field>> getOpt_cache = newWeakHashMap();
static final HashMap getOpt_special = new HashMap(); // just a marker

static {
  getOpt_cache.put(Class.class, getOpt_special);
  getOpt_cache.put(String.class, getOpt_special);
}

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) {
        f.setAccessible(true);
        String name = f.getName();
        if (!map.containsKey(name))
          map.put(name, f);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
  }
  getOpt_cache.put(c, map);
  return map;
}
static void assertTrue(Object o) {
  assertEquals(true, o);
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static void smartSet(Field f, Object o, Object value) throws Exception {
  f.setAccessible(true);
  
  // take care of common case (long to int)
  if (f.getType() == int.class && value instanceof Long)
    value = ((Long) value).intValue();
    
  try {
    f.set(o, value);
  } catch (Exception e) {
    
    throw e;
  }
}


static String getStackTrace(Throwable throwable) {
  lastException(throwable);
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return hideCredentials(writer.toString());
}
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}


static volatile Throwable lastException_lastException;

static Throwable lastException() {
  return lastException_lastException;
}

static void lastException(Throwable e) {
  lastException_lastException = e;
}
static String hideCredentials(URL url) { return url == null ? null : hideCredentials(str(url)); }

static String hideCredentials(String url) {
  return url.replaceAll("([&?])_pass=[^&\\s\"]*", "$1_pass=<hidden>");
}


static class WeakHashMap2<K,V> extends AbstractMap<K,V> implements Map<K,V> {

  /**
   * The default initial capacity -- MUST be a power of two.
   */
  private static final int DEFAULT_INITIAL_CAPACITY = 16;

  /**
   * The maximum capacity, used if a higher value is implicitly specified
   * by either of the constructors with arguments.
   * MUST be a power of two <= 1<<30.
   */
  private static final int MAXIMUM_CAPACITY = 1 << 30;

  /**
   * The load factor used when none specified in constructor.
   */
  private static final float DEFAULT_LOAD_FACTOR = 0.75f;

  /**
   * The table, resized as necessary. Length MUST Always be a power of two.
   */
  Entry<K,V>[] table;

  /**
   * The number of key-value mappings contained in this weak hash map.
   */
  private int size;

  /**
   * The next size value at which to resize (capacity * load factor).
   */
  private int threshold;

  /**
   * The load factor for the hash table.
   */
  private final float loadFactor;

  /**
   * Reference queue for cleared WeakEntries
   */
  private final ReferenceQueue<Object> queue = new ReferenceQueue<>();

  int modCount;

  @SuppressWarnings("unchecked")
  Entry<K,V>[] newTable(int n) {
      return (Entry<K,V>[]) new Entry<?,?>[n];
  }

  WeakHashMap2(int initialCapacity, float loadFactor) {
      if (initialCapacity < 0)
          throw new IllegalArgumentException("Illegal Initial Capacity: "+
                                             initialCapacity);
      if (initialCapacity > MAXIMUM_CAPACITY)
          initialCapacity = MAXIMUM_CAPACITY;

      if (loadFactor <= 0 || Float.isNaN(loadFactor))
          throw new IllegalArgumentException("Illegal Load factor: "+
                                             loadFactor);
      int capacity = 1;
      while (capacity < initialCapacity)
          capacity <<= 1;
      table = newTable(capacity);
      this.loadFactor = loadFactor;
      threshold = (int)(capacity * loadFactor);
  }

  /**
   * Constructs a new, empty <tt>WeakHashMap</tt> with the given initial
   * capacity and the default load factor (0.75).
   *
   * @param  initialCapacity The initial capacity of the <tt>WeakHashMap</tt>
   * @throws IllegalArgumentException if the initial capacity is negative
   */
  WeakHashMap2(int initialCapacity) {
      this(initialCapacity, DEFAULT_LOAD_FACTOR);
  }

  /**
   * Constructs a new, empty <tt>WeakHashMap</tt> with the default initial
   * capacity (16) and load factor (0.75).
   */
  WeakHashMap2() {
      this(DEFAULT_INITIAL_CAPACITY, DEFAULT_LOAD_FACTOR);
  }

  /**
   * Constructs a new <tt>WeakHashMap</tt> with the same mappings as the
   * specified map.  The <tt>WeakHashMap</tt> is created with the default
   * load factor (0.75) and an initial capacity sufficient to hold the
   * mappings in the specified map.
   *
   * @param   m the map whose mappings are to be placed in this map
   * @throws  NullPointerException if the specified map is null
   * @since   1.3
   */
  WeakHashMap2(Map<? extends K, ? extends V> m) {
      this(Math.max((int) (m.size() / DEFAULT_LOAD_FACTOR) + 1,
              DEFAULT_INITIAL_CAPACITY),
           DEFAULT_LOAD_FACTOR);
      putAll(m);
  }

  // internal utilities

  /**
   * Value representing null keys inside tables.
   */
  private static final Object NULL_KEY = new Object();

  /**
   * Use NULL_KEY for key if it is null.
   */
  private static Object maskNull(Object key) {
      return (key == null) ? NULL_KEY : key;
  }

  /**
   * Returns internal representation of null key back to caller as null.
   */
  static Object unmaskNull(Object key) {
      return (key == NULL_KEY) ? null : key;
  }

  /**
   * Retrieve object hash code and applies a supplemental hash function to the
   * result hash, which defends against poor quality hash functions.  This is
   * critical because HashMap uses power-of-two length hash tables, that
   * otherwise encounter collisions for hashCodes that do not differ
   * in lower bits.
   */
  final int hash(Object k) {
      int h = k.hashCode();

      // This function ensures that hashCodes that differ only by
      // constant multiples at each bit position have a bounded
      // number of collisions (approximately 8 at default load factor).
      h ^= (h >>> 20) ^ (h >>> 12);
      return h ^ (h >>> 7) ^ (h >>> 4);
  }

  /**
   * Returns index for hash code h.
   */
  private static int indexFor(int h, int length) {
      return h & (length-1);
  }

  /**
   * Expunges stale entries from the table.
   */
  private void expungeStaleEntries() {
      for (Object x; (x = queue.poll()) != null; ) {
          synchronized (queue) {
              @SuppressWarnings("unchecked")
                  Entry<K,V> e = (Entry<K,V>) x;
              int i = indexFor(e.hash, table.length);

              Entry<K,V> prev = table[i];
              Entry<K,V> p = prev;
              while (p != null) {
                  Entry<K,V> next = p.next;
                  if (p == e) {
                      if (prev == e)
                          table[i] = next;
                      else
                          prev.next = next;
                      // Must not null out e.next;
                      // stale entries may be in use by a HashIterator
                      e.value = null; // Help GC
                      size--;
                      break;
                  }
                  prev = p;
                  p = next;
              }
          }
      }
  }

  /**
   * Returns the table after first expunging stale entries.
   */
  private Entry<K,V>[] getTable() {
      expungeStaleEntries();
      return table;
  }

  /**
   * Returns the number of key-value mappings in this map.
   * This result is a snapshot, and may not reflect unprocessed
   * entries that will be removed before next attempted access
   * because they are no longer referenced.
   */
  public int size() {
      if (size == 0)
          return 0;
      expungeStaleEntries();
      return size;
  }

  /**
   * Returns <tt>true</tt> if this map contains no key-value mappings.
   * This result is a snapshot, and may not reflect unprocessed
   * entries that will be removed before next attempted access
   * because they are no longer referenced.
   */
  public boolean isEmpty() {
      return size() == 0;
  }

  /**
   * Returns the value to which the specified key is mapped,
   * or {@code null} if this map contains no mapping for the key.
   *
   * <p>More formally, if this map contains a mapping from a key
   * {@code k} to a value {@code v} such that {@code (key==null ? k==null :
   * key.equals(k))}, then this method returns {@code v}; otherwise
   * it returns {@code null}.  (There can be at most one such mapping.)
   *
   * <p>A return value of {@code null} does not <i>necessarily</i>
   * indicate that the map contains no mapping for the key; it's also
   * possible that the map explicitly maps the key to {@code null}.
   * The {@link #containsKey containsKey} operation may be used to
   * distinguish these two cases.
   *
   * @see #put(Object, Object)
   */
  public V get(Object key) {
      Object k = maskNull(key);
      int h = hash(k);
      Entry<K,V>[] tab = getTable();
      int index = indexFor(h, tab.length);
      Entry<K,V> e = tab[index];
      while (e != null) {
          if (e.hash == h && eq(k, e.get()))
              return e.value;
          e = e.next;
      }
      return null;
  }

  /**
   * Returns <tt>true</tt> if this map contains a mapping for the
   * specified key.
   *
   * @param  key   The key whose presence in this map is to be tested
   * @return <tt>true</tt> if there is a mapping for <tt>key</tt>;
   *         <tt>false</tt> otherwise
   */
  public boolean containsKey(Object key) {
      return getEntry(key) != null;
  }

  /**
   * Returns the entry associated with the specified key in this map.
   * Returns null if the map contains no mapping for this key.
   */
  Entry<K,V> getEntry(Object key) {
      Object k = maskNull(key);
      int h = hash(k);
      Entry<K,V>[] tab = getTable();
      int index = indexFor(h, tab.length);
      Entry<K,V> e = tab[index];
      while (e != null && !(e.hash == h && eq(k, e.get())))
          e = e.next;
      return e;
  }

  /**
   * Associates the specified value with the specified key in this map.
   * If the map previously contained a mapping for this key, the old
   * value is replaced.
   *
   * @param key key with which the specified value is to be associated.
   * @param value value to be associated with the specified key.
   * @return the previous value associated with <tt>key</tt>, or
   *         <tt>null</tt> if there was no mapping for <tt>key</tt>.
   *         (A <tt>null</tt> return can also indicate that the map
   *         previously associated <tt>null</tt> with <tt>key</tt>.)
   */
  public V put(K key, V value) {
      Object k = maskNull(key);
      int h = hash(k);
      Entry<K,V>[] tab = getTable();
      int i = indexFor(h, tab.length);

      for (Entry<K,V> e = tab[i]; e != null; e = e.next) {
          if (h == e.hash && eq(k, e.get())) {
              V oldValue = e.value;
              if (value != oldValue)
                  e.value = value;
              return oldValue;
          }
      }

      modCount++;
      Entry<K,V> e = tab[i];
      tab[i] = new Entry<>(k, value, queue, h, e);
      if (++size >= threshold)
          resize(tab.length * 2);
      return null;
  }

  /**
   * Rehashes the contents of this map into a new array with a
   * larger capacity.  This method is called automatically when the
   * number of keys in this map reaches its threshold.
   *
   * If current capacity is MAXIMUM_CAPACITY, this method does not
   * resize the map, but sets threshold to Integer.MAX_VALUE.
   * This has the effect of preventing future calls.
   *
   * @param newCapacity the new capacity, MUST be a power of two;
   *        must be greater than current capacity unless current
   *        capacity is MAXIMUM_CAPACITY (in which case value
   *        is irrelevant).
   */
  void resize(int newCapacity) {
      Entry<K,V>[] oldTable = getTable();
      int oldCapacity = oldTable.length;
      if (oldCapacity == MAXIMUM_CAPACITY) {
          threshold = Integer.MAX_VALUE;
          return;
      }

      Entry<K,V>[] newTable = newTable(newCapacity);
      transfer(oldTable, newTable);
      table = newTable;

      /*
       * If ignoring null elements and processing ref queue caused massive
       * shrinkage, then restore old table.  This should be rare, but avoids
       * unbounded expansion of garbage-filled tables.
       */
      if (size >= threshold / 2) {
          threshold = (int)(newCapacity * loadFactor);
      } else {
          expungeStaleEntries();
          transfer(newTable, oldTable);
          table = oldTable;
      }
  }

  /** Transfers all entries from src to dest tables */
  private void transfer(Entry<K,V>[] src, Entry<K,V>[] dest) {
      for (int j = 0; j < src.length; ++j) {
          Entry<K,V> e = src[j];
          src[j] = null;
          while (e != null) {
              Entry<K,V> next = e.next;
              Object key = e.get();
              if (key == null) {
                  e.next = null;  // Help GC
                  e.value = null; //  "   "
                  size--;
              } else {
                  int i = indexFor(e.hash, dest.length);
                  e.next = dest[i];
                  dest[i] = e;
              }
              e = next;
          }
      }
  }

  /**
   * Copies all of the mappings from the specified map to this map.
   * These mappings will replace any mappings that this map had for any
   * of the keys currently in the specified map.
   *
   * @param m mappings to be stored in this map.
   * @throws  NullPointerException if the specified map is null.
   */
  public void putAll(Map<? extends K, ? extends V> m) {
      int numKeysToBeAdded = m.size();
      if (numKeysToBeAdded == 0)
          return;

      /*
       * Expand the map if the map if the number of mappings to be added
       * is greater than or equal to threshold.  This is conservative; the
       * obvious condition is (m.size() + size) >= threshold, but this
       * condition could result in a map with twice the appropriate capacity,
       * if the keys to be added overlap with the keys already in this map.
       * By using the conservative calculation, we subject ourself
       * to at most one extra resize.
       */
      if (numKeysToBeAdded > threshold) {
          int targetCapacity = (int)(numKeysToBeAdded / loadFactor + 1);
          if (targetCapacity > MAXIMUM_CAPACITY)
              targetCapacity = MAXIMUM_CAPACITY;
          int newCapacity = table.length;
          while (newCapacity < targetCapacity)
              newCapacity <<= 1;
          if (newCapacity > table.length)
              resize(newCapacity);
      }

      for (Map.Entry<? extends K, ? extends V> e : m.entrySet())
          put(e.getKey(), e.getValue());
  }

  /**
   * Removes the mapping for a key from this weak hash map if it is present.
   * More formally, if this map contains a mapping from key <tt>k</tt> to
   * value <tt>v</tt> such that <code>(key==null ?  k==null :
   * key.equals(k))</code>, that mapping is removed.  (The map can contain
   * at most one such mapping.)
   *
   * <p>Returns the value to which this map previously associated the key,
   * or <tt>null</tt> if the map contained no mapping for the key.  A
   * return value of <tt>null</tt> does not <i>necessarily</i> indicate
   * that the map contained no mapping for the key; it's also possible
   * that the map explicitly mapped the key to <tt>null</tt>.
   *
   * <p>The map will not contain a mapping for the specified key once the
   * call returns.
   *
   * @param key key whose mapping is to be removed from the map
   * @return the previous value associated with <tt>key</tt>, or
   *         <tt>null</tt> if there was no mapping for <tt>key</tt>
   */
  public V remove(Object key) {
      Object k = maskNull(key);
      int h = hash(k);
      Entry<K,V>[] tab = getTable();
      int i = indexFor(h, tab.length);
      Entry<K,V> prev = tab[i];
      Entry<K,V> e = prev;

      while (e != null) {
          Entry<K,V> next = e.next;
          if (h == e.hash && eq(k, e.get())) {
              modCount++;
              size--;
              if (prev == e)
                  tab[i] = next;
              else
                  prev.next = next;
              return e.value;
          }
          prev = e;
          e = next;
      }

      return null;
  }

  /** Special version of remove needed by Entry set */
  boolean removeMapping(Object o) {
      if (!(o instanceof Map.Entry))
          return false;
      Entry<K,V>[] tab = getTable();
      Map.Entry<?,?> entry = (Map.Entry<?,?>)o;
      Object k = maskNull(entry.getKey());
      int h = hash(k);
      int i = indexFor(h, tab.length);
      Entry<K,V> prev = tab[i];
      Entry<K,V> e = prev;

      while (e != null) {
          Entry<K,V> next = e.next;
          if (h == e.hash && e.equals(entry)) {
              modCount++;
              size--;
              if (prev == e)
                  tab[i] = next;
              else
                  prev.next = next;
              return true;
          }
          prev = e;
          e = next;
      }

      return false;
  }

  /**
   * Removes all of the mappings from this map.
   * The map will be empty after this call returns.
   */
  public void clear() {
      // clear out ref queue. We don't need to expunge entries
      // since table is getting cleared.
      while (queue.poll() != null)
          ;

      modCount++;
      Arrays.fill(table, null);
      size = 0;

      // Allocation of array may have caused GC, which may have caused
      // additional entries to go stale.  Removing these entries from the
      // reference queue will make them eligible for reclamation.
      while (queue.poll() != null)
          ;
  }

  /**
   * Returns <tt>true</tt> if this map maps one or more keys to the
   * specified value.
   *
   * @param value value whose presence in this map is to be tested
   * @return <tt>true</tt> if this map maps one or more keys to the
   *         specified value
   */
  public boolean containsValue(Object value) {
      if (value==null)
          return containsNullValue();

      Entry<K,V>[] tab = getTable();
      for (int i = tab.length; i-- > 0;)
          for (Entry<K,V> e = tab[i]; e != null; e = e.next)
              if (value.equals(e.value))
                  return true;
      return false;
  }

  /**
   * Special-case code for containsValue with null argument
   */
  private boolean containsNullValue() {
      Entry<K,V>[] tab = getTable();
      for (int i = tab.length; i-- > 0;)
          for (Entry<K,V> e = tab[i]; e != null; e = e.next)
              if (e.value==null)
                  return true;
      return false;
  }

  /**
   * The entries in this hash table extend WeakReference, using its main ref
   * field as the key.
   */
  static class Entry<K,V> extends WeakReference<Object> implements Map.Entry<K,V> {
      V value;
      final int hash;
      Entry<K,V> next;

      /**
       * Creates new entry.
       */
      Entry(Object key, V value,
            ReferenceQueue<Object> queue,
            int hash, Entry<K,V> next) {
          super(key, queue);
          this.value = value;
          this.hash  = hash;
          this.next  = next;
      }

      @SuppressWarnings("unchecked")
      public K getKey() {
          return (K) WeakHashMap2.unmaskNull(get());
      }

      public V getValue() {
          return value;
      }

      public V setValue(V newValue) {
          V oldValue = value;
          value = newValue;
          return oldValue;
      }

      public boolean equals(Object o) {
          if (!(o instanceof Map.Entry))
              return false;
          Map.Entry<?,?> e = (Map.Entry<?,?>)o;
          K k1 = getKey();
          Object k2 = e.getKey();
          if (k1 == k2 || (k1 != null && k1.equals(k2))) {
              V v1 = getValue();
              Object v2 = e.getValue();
              if (v1 == v2 || (v1 != null && v1.equals(v2)))
                  return true;
          }
          return false;
      }

      public int hashCode() {
          K k = getKey();
          V v = getValue();
          return Objects.hashCode(k) ^ Objects.hashCode(v);
      }

      public String toString() {
          return getKey() + "=" + getValue();
      }
  }

  private abstract class HashIterator<T> implements Iterator<T> {
      private int index;
      private Entry<K,V> entry;
      private Entry<K,V> lastReturned;
      private int expectedModCount = modCount;

      /**
       * Strong reference needed to avoid disappearance of key
       * between hasNext and next
       */
      private Object nextKey;

      /**
       * Strong reference needed to avoid disappearance of key
       * between nextEntry() and any use of the entry
       */
      private Object currentKey;

      HashIterator() {
          index = isEmpty() ? 0 : table.length;
      }

      public boolean hasNext() {
          Entry<K,V>[] t = table;

          while (nextKey == null) {
              Entry<K,V> e = entry;
              int i = index;
              while (e == null && i > 0)
                  e = t[--i];
              entry = e;
              index = i;
              if (e == null) {
                  currentKey = null;
                  return false;
              }
              nextKey = e.get(); // hold on to key in strong ref
              if (nextKey == null)
                  entry = entry.next;
          }
          return true;
      }

      /** The common parts of next() across different types of iterators */
      protected Entry<K,V> nextEntry() {
          if (modCount != expectedModCount)
              throw new ConcurrentModificationException();
          if (nextKey == null && !hasNext())
              throw new NoSuchElementException();

          lastReturned = entry;
          entry = entry.next;
          currentKey = nextKey;
          nextKey = null;
          return lastReturned;
      }

      public void remove() {
          if (lastReturned == null)
              throw new IllegalStateException();
          if (modCount != expectedModCount)
              throw new ConcurrentModificationException();

          WeakHashMap2.this.remove(currentKey);
          expectedModCount = modCount;
          lastReturned = null;
          currentKey = null;
      }

  }

  private class ValueIterator extends HashIterator<V> {
      public V next() {
          return nextEntry().value;
      }
  }

  private class KeyIterator extends HashIterator<K> {
      public K next() {
          return nextEntry().getKey();
      }
  }

  private class EntryIterator extends HashIterator<Map.Entry<K,V>> {
      public Map.Entry<K,V> next() {
          return nextEntry();
      }
  }

  // Views

  private transient Set<Map.Entry<K,V>> entrySet;

  /**
   * Returns a {@link Set} view of the keys contained in this map.
   * The set is backed by the map, so changes to the map are
   * reflected in the set, and vice-versa.  If the map is modified
   * while an iteration over the set is in progress (except through
   * the iterator's own <tt>remove</tt> operation), the results of
   * the iteration are undefined.  The set supports element removal,
   * which removes the corresponding mapping from the map, via the
   * <tt>Iterator.remove</tt>, <tt>Set.remove</tt>,
   * <tt>removeAll</tt>, <tt>retainAll</tt>, and <tt>clear</tt>
   * operations.  It does not support the <tt>add</tt> or <tt>addAll</tt>
   * operations.
   */
  public Set<K> keySet() {
      Set<K> ks = (Set) _get(this, "keySet");
      if (ks == null) {
          ks = new KeySet();
          set(this, "keySet", ks);
      }
      return ks;
  }

  private class KeySet extends AbstractSet<K> {
      public Iterator<K> iterator() {
          return new KeyIterator();
      }

      public int size() {
          return WeakHashMap2.this.size();
      }

      public boolean contains(Object o) {
          return containsKey(o);
      }

      public boolean remove(Object o) {
          if (containsKey(o)) {
              WeakHashMap2.this.remove(o);
              return true;
          }
          else
              return false;
      }

      public void clear() {
          WeakHashMap2.this.clear();
      }
  }

  /**
   * Returns a {@link Collection} view of the values contained in this map.
   * The collection is backed by the map, so changes to the map are
   * reflected in the collection, and vice-versa.  If the map is
   * modified while an iteration over the collection is in progress
   * (except through the iterator's own <tt>remove</tt> operation),
   * the results of the iteration are undefined.  The collection
   * supports element removal, which removes the corresponding
   * mapping from the map, via the <tt>Iterator.remove</tt>,
   * <tt>Collection.remove</tt>, <tt>removeAll</tt>,
   * <tt>retainAll</tt> and <tt>clear</tt> operations.  It does not
   * support the <tt>add</tt> or <tt>addAll</tt> operations.
   */
  public Collection<V> values() {
      Collection<V> vs = (Collection) _get(this, "values");
      if (vs == null) {
          vs = new Values();
          set(this, "values", vs);
      }
      return vs;
  }

  private class Values extends AbstractCollection<V> {
      public Iterator<V> iterator() {
          return new ValueIterator();
      }

      public int size() {
          return WeakHashMap2.this.size();
      }

      public boolean contains(Object o) {
          return containsValue(o);
      }

      public void clear() {
          WeakHashMap2.this.clear();
      }
  }

  public Set<Map.Entry<K,V>> entrySet() {
      Set<Map.Entry<K,V>> es = entrySet;
      return es != null ? es : (entrySet = new EntrySet());
  }

  private class EntrySet extends AbstractSet<Map.Entry<K,V>> {
      public Iterator<Map.Entry<K,V>> iterator() {
          return new EntryIterator();
      }

      public boolean contains(Object o) {
          if (!(o instanceof Map.Entry))
              return false;
          Map.Entry<?,?> e = (Map.Entry<?,?>)o;
          Entry<K,V> candidate = getEntry(e.getKey());
          return candidate != null && candidate.equals(e);
      }

      public boolean remove(Object o) {
          return removeMapping(o);
      }

      public int size() {
          return WeakHashMap2.this.size();
      }

      public void clear() {
          WeakHashMap2.this.clear();
      }

      private List<Map.Entry<K,V>> deepCopy() {
          List<Map.Entry<K,V>> list = new ArrayList<>(size());
          for (Map.Entry<K,V> e : this)
              list.add(new AbstractMap.SimpleEntry<>(e));
          return list;
      }

      public Object[] toArray() {
          return deepCopy().toArray();
      }

      public <T> T[] toArray(T[] a) {
          return deepCopy().toArray(a);
      }
  }
}


static abstract class F1<A, B> {
  abstract B get(A a);
}

static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}
static <A> Iterator<A> iterator(Collection<A> c) {
  return c == null ? emptyIterator() : c.iterator();
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}
static <A> A _get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

static Object _get(Object o, String field) {
  return get(o, field);
}

static <A> A _get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}
static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}


static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}

static <A> void remove(Collection<A> l, A a) {
  if (l != null) l.remove(a);
}
static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll(b);
  return a;
}
static void set(Object o, String field, Object value) {
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static void set(Class c, String field, Object value) {
  try {
    Field f = set_findStaticField(c, field);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
static boolean isEmpty(Collection c) {
  return c == null || c.isEmpty();
}

static boolean isEmpty(CharSequence s) {
  return s == null || s.length() == 0;
}

static boolean isEmpty(Object[] a) {
  return a == null || a.length == 0;
}

static boolean isEmpty(Map map) {
  return map == null || map.isEmpty();
}
static boolean equals(Object a, Object b) {
  return a == null ? b == null : a.equals(b);
}


static Iterator emptyIterator() {
  return Collections.emptyIterator();
}
  static <A> List<A> concatLists(Collection<A>... lists) {
    List<A> l = new ArrayList();
    for (Collection<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

  static <A> List<A> concatLists(Collection<List<A>> lists) {
    List<A> l = new ArrayList();
    for (List<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

static List emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}

static List emptyList(int capacity) {
  return new ArrayList(capacity);
}

// Try to match capacity
static List emptyList(Iterable l) {
  return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
}

}

class m1011727{}