import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;

public class main {

  public static Class module;

  public static void main(final String[] args) throws Exception {
    Lisp l = lisp("hello", "world!");
    module = hotwireSharingClasses("#1011218", Lisp.class);
    call(module, "test", l);
  }

  public static Object call(Object o) {
    return callFunction(o);
  }

  // varargs assignment fixer for a single string array argument
  public static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] { arg });
  }

  public static Object call(Object o, String method, Object... args) {
    try {
      if (o instanceof Class) {
        Method m = call_findStaticMethod((Class) o, method, args, false);
        m.setAccessible(true);
        return m.invoke(null, args);
      } else {
        Method m = call_findMethod(o, method, args, false);
        m.setAccessible(true);
        return m.invoke(o, args);
      }
    } catch (Exception e) {
      throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
    }
  }

  public static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (!m.getName().equals(method)) {
          if (debug)
            System.out.println("Method name mismatch: " + method);
          continue;
        }
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
  }

  public static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (m.getName().equals(method) && call_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
  }

  public static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static RuntimeException asRuntimeException(Throwable t) {
    return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
  }

  public static Class<?> hotwireSharingClasses(String progID, Class... classesToShare) {
    try {
      Pair<File, String> p = CompilerBot.compileSnippet2(progID);
      File jar = p.a;
      assertTrue(f2s(jar), jar.isFile());
      // collect files (program + libraries)
      List<File> files = ll(jar);
      String dehlibs = unnull(loadTextFileFromZip(jar, "libraries"));
      List<File> myLibraries = myLibraryFiles();
      Matcher matcher = Pattern.compile("\\d+").matcher(dehlibs);
      while (matcher.find()) files.add(loadLibrary(matcher.group()));
      // make class loader
      JavaXClassLoaderWithParent2 classLoader = new JavaXClassLoaderWithParent2(progID, files, myClassLoader(), map("className", classesToShare));
      return hotwire_finish(classLoader, progID, p.b);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Map<Thread, Boolean> _registerThread_threads = Collections.synchronizedMap(new WeakHashMap());

  public static Thread _registerThread(Thread t) {
    _registerThread_threads.put(t, true);
    return t;
  }

  public static void _registerThread() {
    _registerThread(Thread.currentThread());
  }

  // make a lisp form
  public static Lisp lisp(String head, Object... args) {
    Lisp l = new Lisp(head);
    for (Object o : args) l.add(o);
    return l;
  }

  public static Lisp lisp(String head, Collection args) {
    return new Lisp(head, args);
  }

  // extended over Class.isInstance() to handle primitive types
  public static boolean isInstanceX(Class type, Object arg) {
    if (type == boolean.class)
      return arg instanceof Boolean;
    if (type == int.class)
      return arg instanceof Integer;
    if (type == long.class)
      return arg instanceof Long;
    if (type == float.class)
      return arg instanceof Float;
    if (type == short.class)
      return arg instanceof Short;
    if (type == char.class)
      return arg instanceof Character;
    if (type == byte.class)
      return arg instanceof Byte;
    if (type == double.class)
      return arg instanceof Double;
    return type.isInstance(arg);
  }

  public static <A> List<A> ll(A... a) {
    return litlist(a);
  }

  public static Class hotwire_finish(ClassLoader classLoader, String progID, String javaSource) {
    try {
      // load & return main class
      Class<?> theClass = classLoader.loadClass("main");
      Class j = getJavaX();
      setOpt(theClass, "myJavaSource_code", javaSource);
      synchronized (j) {
        // hopefully this goes well...
        call(j, "setVars", theClass, progID);
        callOpt(j, "addInstance", progID, theClass);
      }
      hotwire_copyOver(theClass);
      return theClass;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static RuntimeException rethrow(Throwable e) {
    throw asRuntimeException(e);
  }

  public static File loadLibrary(String snippetID) {
    return loadBinarySnippet(snippetID);
  }

  public static String loadTextFileFromZip(File inZip, String fileName) {
    return loadTextFileFromZipFile(inZip, fileName);
  }

  public static String f2s(File f) {
    return f == null ? null : f.getAbsolutePath();
  }

  public static String unnull(String s) {
    return s == null ? "" : s;
  }

  public static <A> List<A> unnull(List<A> l) {
    return l == null ? emptyList() : l;
  }

  public static <A> Iterable<A> unnull(Iterable<A> i) {
    return i == null ? emptyList() : i;
  }

  public static <A> A[] unnull(A[] a) {
    return a == null ? (A[]) new Object[0] : a;
  }

  public static BitSet unnull(BitSet b) {
    return b == null ? new BitSet() : b;
  }

  public static Object callFunction(Object f, Object... args) {
    return callF(f, args);
  }

  public static String className(Object o) {
    return getClassName(o);
  }

  public static ClassLoader myClassLoader() {
    return _getClass(mc()).getClassLoader();
  }

  public static List<File> myLibraryFiles() {
    return (List<File>) get(myClassLoader(), "files");
  }

  public static void assertTrue(Object o) {
    assertEquals(true, o);
  }

  public static boolean assertTrue(String msg, boolean b) {
    if (!b)
      throw fail(msg);
    return b;
  }

  public static boolean assertTrue(boolean b) {
    if (!b)
      throw fail("oops");
    return b;
  }

  public static List map(Iterable l, Object f) {
    return map(f, l);
  }

  public static List map(Object f, Iterable l) {
    List x = emptyList(l);
    if (l != null)
      for (Object o : l) x.add(callF(f, o));
    return x;
  }

  public static List map(Object f, Object[] l) {
    return map(f, asList(l));
  }

  public static List map(Object[] l, Object f) {
    return map(f, l);
  }

  public static List map(Object f, Map map) {
    return map(map, f);
  }

  public static List map(Map map, Object f) {
    List x = new ArrayList();
    for (Object _e : map.entrySet()) {
      Map.Entry e = (Map.Entry) _e;
      x.add(callF(f, e.getKey(), e.getValue()));
    }
    return x;
  }

  public static void hotwire_copyOver(Class c) {
    synchronized (StringBuffer.class) {
      for (String field : litlist("print_log", "print_silent", "androidContext")) {
        Object o = getOpt(mc(), field);
        if (o != null)
          setOpt(c, field, o);
      }
      Object mainBot = getMainBot();
      if (mainBot != null)
        setOpt(c, "mainBot", mainBot);
      setOpt(c, "creator_class", new WeakReference(mc()));
    }
  }

  public static Object callOpt(Object o) {
    if (o == null)
      return null;
    return callF(o);
  }

  public static Object callOpt(Object o, String method, Object... args) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class) {
        Method m = callOpt_findStaticMethod((Class) o, method, args, false);
        if (m == null)
          return null;
        m.setAccessible(true);
        return m.invoke(null, args);
      } else {
        Method m = callOpt_findMethod(o, method, args, false);
        if (m == null)
          return null;
        m.setAccessible(true);
        return m.invoke(o, args);
      }
    } catch (Exception e) {
      //fail(e.getMessage() + " | Method: " + method + ", receiver: " + className(o) + ", args: (" + join(", ", map(f className, args) + ")");
      throw new RuntimeException(e);
    }
  }

  public static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (!m.getName().equals(method)) {
          if (debug)
            System.out.println("Method name mismatch: " + method);
          continue;
        }
        if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
          continue;
        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
        ;
        if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  public static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();

  public static <A> A callF(F0<A> f) {
    return f == null ? null : f.get();
  }

  public static Object callF(Object f, Object... args) {
    try {
      if (f instanceof String)
        return callMC((String) f, args);
      if (f instanceof Runnable) {
        ((Runnable) f).run();
        return null;
      }
      if (f == null)
        return null;
      Class c = f.getClass();
      ArrayList<Method> methods;
      synchronized (callF_cache) {
        methods = callF_cache.get(c);
        if (methods == null)
          methods = callF_makeCache(c);
      }
      int n = l(methods);
      if (n == 0)
        throw fail("No get method in " + getClassName(c));
      if (n == 1)
        return methods.get(0).invoke(f, args);
      for (int i = 0; i < n; i++) {
        Method m = methods.get(i);
        if (call_checkArgs(m, args, false))
          return m.invoke(f, args);
      }
      throw fail("No matching get method in " + getClassName(c));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  // used internally
  public static ArrayList<Method> callF_makeCache(Class c) {
    ArrayList<Method> l = new ArrayList();
    Class _c = c;
    do {
      for (Method m : _c.getDeclaredMethods()) if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
      if (!l.isEmpty())
        break;
      _c = _c.getSuperclass();
    } while (_c != null);
    callF_cache.put(c, l);
    return l;
  }

  public static Class<?> _getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      // could optimize this
      return null;
    }
  }

  public static Class _getClass(Object o) {
    return o == null ? null : o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class _getClass(Object realm, String name) {
    try {
      return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static <A> ArrayList<A> asList(A[] a) {
    return a == null ? new ArrayList<A>() : new ArrayList<A>(Arrays.asList(a));
  }

  public static ArrayList<Integer> asList(int[] a) {
    ArrayList<Integer> l = new ArrayList();
    for (int i : a) l.add(i);
    return l;
  }

  public static <A> ArrayList<A> asList(Iterable<A> s) {
    if (s instanceof ArrayList)
      return (ArrayList) s;
    ArrayList l = new ArrayList();
    if (s != null)
      for (A a : s) l.add(a);
    return l;
  }

  public static <A> ArrayList<A> asList(Enumeration<A> e) {
    ArrayList l = new ArrayList();
    if (e != null)
      while (e.hasMoreElements()) l.add(e.nextElement());
    return l;
  }

  public static List emptyList() {
    return new ArrayList();
  //ret Collections.emptyList();
  }

  public static List emptyList(int capacity) {
    return new ArrayList(capacity);
  }

  // Try to match capacity
  public static List emptyList(Iterable l) {
    return l instanceof Collection ? emptyList(((Collection) l).size()) : emptyList();
  }

  public static <A> ArrayList<A> litlist(A... a) {
    return new ArrayList<A>(Arrays.asList(a));
  }

  public static Class mc() {
    return main.class;
  }

  // get purpose 1: access a list/array/map (safer version of x.get(y))
  public static <A> A get(List<A> l, int idx) {
    return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
  }

  // seems to conflict with other signatures
  /*static <A, B> B get(Map<A, B> map, A key) {
  ret map != null ? map.get(key) : null;
}*/
  public static <A> A get(A[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : null;
  }

  // default to false
  public static boolean get(boolean[] l, int idx) {
    return idx >= 0 && idx < l(l) ? l[idx] : false;
  }

  // get purpose 2: access a field by reflection or a map
  public static Object get(Object o, String field) {
    try {
      if (o instanceof Class)
        return get((Class) o, field);
      if (o instanceof Map)
        return ((Map) o).get(field);
      Field f = getOpt_findField(o.getClass(), field);
      if (f != null) {
        f.setAccessible(true);
        return f.get(o);
      }
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    } catch (Exception e) {
      throw asRuntimeException(e);
    }
    throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
  }

  public static Object get_raw(Object o, String field) {
    try {
      Field f = get_findField(o.getClass(), field);
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Object get(Class c, String field) {
    try {
      Field f = get_findStaticField(c, field);
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field get_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
  }

  public static Field get_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
  }

  public static Class __javax;

  public static Class getJavaX() {
    return __javax;
  }

  public static <A> A assertEquals(Object x, A y) {
    return assertEquals(null, x, y);
  }

  public static <A> A assertEquals(String msg, Object x, A y) {
    if (!(x == null ? y == null : x.equals(y)))
      throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
    return y;
  }

  public static String loadTextFileFromZipFile(File inZip, String fileName) {
    try {
      ZipFile zip = new ZipFile(inZip);
      try {
        return loadTextFileFromZipFile(zip, fileName);
      } finally {
        zip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadTextFileFromZipFile(ZipFile zip, String fileName) {
    try {
      ZipEntry entry = zip.getEntry(fileName);
      if (entry == null)
        return null;
      InputStream fin = zip.getInputStream(entry);
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      copyStream(fin, baos);
      fin.close();
      return fromUTF8(baos.toByteArray());
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static RuntimeException fail() {
    throw new RuntimeException("fail");
  }

  public static RuntimeException fail(Throwable e) {
    throw asRuntimeException(e);
  }

  public static RuntimeException fail(Object msg) {
    throw new RuntimeException(String.valueOf(msg));
  }

  public static RuntimeException fail(String msg) {
    throw new RuntimeException(msg == null ? "" : msg);
  }

  public static RuntimeException fail(String msg, Throwable innerException) {
    throw new RuntimeException(msg, innerException);
  }

  public static Field setOpt_findField(Class c, String field) {
    HashMap<String, Field> map;
    synchronized (getOpt_cache) {
      map = getOpt_cache.get(c);
      if (map == null)
        map = getOpt_makeCache(c);
    }
    return map.get(field);
  }

  public static void setOpt(Object o, String field, Object value) {
    try {
      if (o == null)
        return;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class) {
          setOpt((Class) o, field, value);
          return;
        }
        // It's probably a subclass of Map. Use raw method
        setOpt_raw(o, field, value);
        return;
      }
      Field f = map.get(field);
      if (f != null)
        // possible improvement: skip setAccessible
        smartSet(f, o, value);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void setOpt(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field setOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static String getClassName(Object o) {
    return o == null ? "null" : o instanceof Class ? ((Class) o).getName() : o.getClass().getName();
  }

  public static File loadBinarySnippet(String snippetID) {
    try {
      long id = parseSnippetID(snippetID);
      File f = DiskSnippetCache_getLibrary(id);
      if (fileSize(f) == 0)
        f = loadDataSnippetToFile(snippetID);
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Class<?> getClass(String name) {
    try {
      return Class.forName(name);
    } catch (ClassNotFoundException e) {
      return null;
    }
  }

  public static Class getClass(Object o) {
    return o instanceof Class ? (Class) o : o.getClass();
  }

  public static Class getClass(Object realm, String name) {
    try {
      try {
        return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
      } catch (ClassNotFoundException e) {
        return null;
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static File DiskSnippetCache_file(long snippetID) {
    return new File(getGlobalCache(), "data_" + snippetID + ".jar");
  }

  // Data files are immutable, use centralized cache
  public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
    File file = DiskSnippetCache_file(snippetID);
    return file.exists() ? file : null;
  }

  public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
    saveBinaryFile(DiskSnippetCache_file(snippetID), data);
  }

  public static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
    byte[] data;
    try {
      URL url = new URL("http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + parseSnippetID(snippetID) + "&contentType=application/binary");
      System.err.println("Loading library: " + url);
      try {
        data = loadBinaryPage(url.openConnection());
      } catch (RuntimeException e) {
        data = null;
      }
      if (data == null || data.length == 0) {
        url = new URL("http://data.tinybrain.de/blobs/" + parseSnippetID(snippetID));
        System.err.println("Loading library: " + url);
        data = loadBinaryPage(url.openConnection());
      }
      System.err.println("Bytes loaded: " + data.length);
    } catch (FileNotFoundException e) {
      throw new IOException("Binary snippet #" + snippetID + " not found or not public");
    }
    return data;
  }

  public static final HashMap<String, List<Method>> callMC_cache = new HashMap();

  public static String callMC_key;

  public static Method callMC_value;

  // varargs assignment fixer for a single string array argument
  public static Object callMC(String method, String[] arg) {
    return callMC(method, new Object[] { arg });
  }

  public static Object callMC(String method, Object... args) {
    try {
      Method me;
      synchronized (callMC_cache) {
        me = method == callMC_key ? callMC_value : null;
      }
      if (me != null)
        return callMC_value.invoke(null, args);
      List<Method> m;
      synchronized (callMC_cache) {
        m = callMC_cache.get(method);
      }
      if (m == null) {
        if (callMC_cache.isEmpty()) {
          callMC_makeCache();
          m = callMC_cache.get(method);
        }
        if (m == null)
          throw fail("Method named " + method + " not found in main");
      }
      int n = m.size();
      if (n == 1) {
        me = m.get(0);
        synchronized (callMC_cache) {
          callMC_key = method;
          callMC_value = me;
        }
        return me.invoke(null, args);
      }
      for (int i = 0; i < n; i++) {
        me = m.get(i);
        if (call_checkArgs(me, args, false))
          return me.invoke(null, args);
      }
      throw fail("No method called " + method + " with matching arguments found in main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void callMC_makeCache() {
    synchronized (callMC_cache) {
      callMC_cache.clear();
      Class _c = (Class) mc(), c = _c;
      while (c != null) {
        for (Method m : c.getDeclaredMethods()) if ((m.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
        c = c.getSuperclass();
      }
    }
  }

  public static void setOpt_raw(Object o, String field, Object value) {
    if (o == null)
      return;
    if (o instanceof Class)
      setOpt_raw((Class) o, field, value);
    else
      try {
        Field f = setOpt_raw_findField(o.getClass(), field);
        if (f != null)
          smartSet(f, o, value);
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
  }

  public static void setOpt_raw(Class c, String field, Object value) {
    if (c == null)
      return;
    try {
      Field f = setOpt_raw_findStaticField(c, field);
      if (f != null)
        smartSet(f, null, value);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field setOpt_raw_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field setOpt_raw_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static String classNameToVM(String name) {
    return name.replace(".", "$");
  }

  public static long fileSize(String path) {
    return getFileSize(path);
  }

  public static long fileSize(File f) {
    return getFileSize(f);
  }

  public static File loadDataSnippetToFile(String snippetID) {
    try {
      snippetID = fsI(snippetID);
      File f = DiskSnippetCache_file(parseSnippetID(snippetID));
      try {
        URL url = new URL(dataSnippetLink(snippetID));
        print("Loading library: " + hideCredentials(url));
        try {
          loadBinaryPageToFile(openConnection(url), f);
          if (fileSize(f) == 0)
            throw fail();
        } catch (Throwable _e) {
          url = new URL("http://data.tinybrain.de/blobs/" + psI(snippetID));
          print("Trying other server: " + hideCredentials(url));
          loadBinaryPageToFile(openConnection(url), f);
          print("Got bytes: " + fileSize(f));
        }
        // TODO: check if we hit the "LOADING" message
        if (fileSize(f) == 0)
          throw fail();
        System.err.println("Bytes loaded: " + fileSize(f));
      } catch (Throwable e) {
        printStackTrace(e);
        throw fail("Binary snippet " + snippetID + " not found or not public");
      }
      return f;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Object mainBot;

  public static Object getMainBot() {
    return mainBot;
  }

  public static final WeakHashMap<Class, HashMap<String, Field>> getOpt_cache = new WeakHashMap();

  // just a marker
  public static final HashMap getOpt_special = new HashMap();

  static {
    getOpt_cache.put(Class.class, getOpt_special);
    getOpt_cache.put(String.class, getOpt_special);
  }

  public static Object getOpt_cached(Object o, String field) {
    try {
      if (o == null)
        return null;
      Class c = o.getClass();
      HashMap<String, Field> map;
      synchronized (getOpt_cache) {
        map = getOpt_cache.get(c);
        if (map == null)
          map = getOpt_makeCache(c);
      }
      if (map == getOpt_special) {
        if (o instanceof Class)
          return getOpt((Class) o, field);
        /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
        if (o instanceof Map)
          return ((Map) o).get(field);
      }
      Field f = map.get(field);
      if (f != null)
        return f.get(o);
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
      return null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  // used internally - we are in synchronized block
  public static HashMap<String, Field> getOpt_makeCache(Class c) {
    HashMap<String, Field> map;
    if (isSubtypeOf(c, Map.class))
      map = getOpt_special;
    else {
      map = new HashMap();
      Class _c = c;
      do {
        for (Field f : _c.getDeclaredFields()) {
          f.setAccessible(true);
          String name = f.getName();
          if (!map.containsKey(name))
            map.put(name, f);
        }
        _c = _c.getSuperclass();
      } while (_c != null);
    }
    getOpt_cache.put(c, map);
    return map;
  }

  public static long parseSnippetID(String snippetID) {
    long id = Long.parseLong(shortenSnippetID(snippetID));
    if (id == 0)
      throw fail("0 is not a snippet ID");
    return id;
  }

  public static void smartSet(Field f, Object o, Object value) throws Exception {
    f.setAccessible(true);
    // take care of common case (long to int)
    if (f.getType() == int.class && value instanceof Long)
      value = ((Long) value).intValue();
    try {
      f.set(o, value);
    } catch (Exception e) {
      throw e;
    }
  }

  public static String fromUTF8(byte[] bytes) {
    return fromUtf8(bytes);
  }

  public static int l(Object[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(boolean[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(byte[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(int[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(float[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(char[] a) {
    return a == null ? 0 : a.length;
  }

  public static int l(Collection c) {
    return c == null ? 0 : c.size();
  }

  public static int l(Map m) {
    return m == null ? 0 : m.size();
  }

  public static int l(CharSequence s) {
    return s == null ? 0 : s.length();
  }

  public static long l(File f) {
    return f == null ? 0 : f.length();
  }

  public static int l(Object o) {
    return o instanceof String ? l((String) o) : o instanceof Map ? l((Map) o) : // incomplete
    l((Collection) o);
  }

  public static int l(Lisp l) {
    return l == null ? 0 : l.size();
  }

  // not redirected
  public static volatile StringBuffer local_log = new StringBuffer();

  // might be redirected, e.g. to main bot
  public static volatile StringBuffer print_log = local_log;

  // in bytes - will cut to half that
  public static volatile int print_log_max = 1024 * 1024;

  public static volatile int local_log_max = 100 * 1024;

  //static int print_maxLineLength = 0; // 0 = unset
  // total mute if set
  public static boolean print_silent;

  public static Object print_byThread_lock = new Object();

  // special handling by thread
  public static volatile ThreadLocal<F1<String, Boolean>> print_byThread;

  public static void print() {
    print("");
  }

  // slightly overblown signature to return original object...
  public static <A> A print(A o) {
    ping();
    if (print_silent)
      return o;
    String s = String.valueOf(o) + "\n";
    print_noNewLine(s);
    return o;
  }

  public static void print_noNewLine(String s) {
    if (print_byThread != null) {
      F1<String, Boolean> f = print_byThread.get();
      if (f != null)
        if (isFalse(f.get(s)))
          return;
    }
    print_raw(s);
  }

  public static void print_raw(String s) {
    s = fixNewLines(s);
    // TODO if (print_maxLineLength != 0)
    StringBuffer loc = local_log;
    StringBuffer buf = print_log;
    int loc_max = print_log_max;
    if (buf != loc && buf != null) {
      print_append(buf, s, print_log_max);
      loc_max = local_log_max;
    }
    if (loc != null)
      print_append(loc, s, loc_max);
    System.out.print(s);
  }

  public static void print(long l) {
    print(String.valueOf(l));
  }

  public static void print(char c) {
    print(String.valueOf(c));
  }

  public static void print_append(StringBuffer buf, String s, int max) {
    synchronized (buf) {
      buf.append(s);
      max /= 2;
      if (buf.length() > max)
        try {
          int newLength = max / 2;
          int ofs = buf.length() - newLength;
          String newString = buf.substring(ofs);
          buf.setLength(0);
          buf.append("[...] ").append(newString);
        } catch (Exception e) {
          buf.setLength(0);
        }
    }
  }

  public static Object getOpt(Object o, String field) {
    return getOpt_cached(o, field);
  }

  public static Object getOpt_raw(Object o, String field) {
    try {
      Field f = getOpt_findField(o.getClass(), field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(o);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  // access of static fields is not yet optimized
  public static Object getOpt(Class c, String field) {
    try {
      if (c == null)
        return null;
      Field f = getOpt_findStaticField(c, field);
      if (f == null)
        return null;
      f.setAccessible(true);
      return f.get(null);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static Field getOpt_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static void copyStream(InputStream in, OutputStream out) {
    try {
      byte[] buf = new byte[65536];
      while (true) {
        int n = in.read(buf);
        if (n <= 0)
          return;
        out.write(buf, 0, n);
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Field getOpt_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static void loadBinaryPageToFile(String url, File file) {
    try {
      print("Loading " + url);
      loadBinaryPageToFile(openConnection(new URL(url)), file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void loadBinaryPageToFile(URLConnection con, File file) {
    try {
      setHeaders(con);
      loadBinaryPageToFile_noHeaders(con, file);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) {
    try {
      File ftemp = new File(f2s(file) + "_temp");
      FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
      InputStream inputStream = con.getInputStream();
      try {
        long len = 0;
        try {
          len = con.getContentLengthLong();
        } catch (Throwable e) {
          printStackTrace(e);
        }
        int n = 0;
        while (true) {
          int ch = inputStream.read();
          if (ch < 0)
            break;
          buf.write(ch);
          if (++n % 100000 == 0)
            println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
        }
        buf.close();
        buf = null;
        file.delete();
        ftemp.renameTo(file);
        inputStream.close();
      } finally {
        if (buf != null)
          buf.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static long getFileSize(String path) {
    return path == null ? 0 : new File(path).length();
  }

  public static long getFileSize(File f) {
    return f == null ? 0 : f.length();
  }

  public static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
    List<B> l = map.get(a);
    if (l == null)
      map.put(a, l = new ArrayList());
    l.add(b);
  }

  public static String fsI(String id) {
    return formatSnippetID(id);
  }

  public static String fsI(long id) {
    return formatSnippetID(id);
  }

  public static String shortenSnippetID(String snippetID) {
    if (snippetID.startsWith("#"))
      snippetID = snippetID.substring(1);
    String httpBlaBla = "http://tinybrain.de/";
    if (snippetID.startsWith(httpBlaBla))
      snippetID = snippetID.substring(httpBlaBla.length());
    return "" + parseLong(snippetID);
  }

  public static Throwable printStackTrace(Throwable e) {
    // we go to system.out now - system.err is nonsense
    print(getStackTrace(e));
    return e;
  }

  public static void printStackTrace() {
    printStackTrace(new Throwable());
  }

  public static void printStackTrace(String msg) {
    printStackTrace(new Throwable(msg));
  }

  /*static void printStackTrace(S indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace(e));
}*/
  public static URLConnection openConnection(URL url) {
    try {
      ping();
      callOpt(javax(), "recordOpenURLConnection", str(url));
      return url.openConnection();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static long psI(String snippetID) {
    return parseSnippetID(snippetID);
  }

  public static boolean isFalse(Object o) {
    return eq(false, o);
  }

  public static boolean isSubtypeOf(Class a, Class b) {
    // << always hated that method, let's replace it!
    return b.isAssignableFrom(a);
  }

  public static String fixNewLines(String s) {
    return s.replace("\r\n", "\n").replace("\r", "\n");
  }

  public static volatile boolean ping_pauseAll;

  // poll pauseAll flag every 100
  public static int ping_sleep = 100;

  public static volatile boolean ping_anyActions;

  public static Map<Thread, Object> ping_actions = (Map) synchroMap(newWeakHashMap());

  // always returns true
  public static boolean ping() {
    if (ping_pauseAll || ping_anyActions)
      ping_impl();
    return true;
  }

  // returns true when it slept
  public static boolean ping_impl() {
    try {
      if (ping_pauseAll && !isAWTThread()) {
        do Thread.sleep(ping_sleep); while (ping_pauseAll);
        return true;
      }
      if (ping_anyActions) {
        Object action;
        synchronized (ping_actions) {
          action = ping_actions.get(currentThread());
          if (action instanceof Runnable)
            ping_actions.remove(currentThread());
          if (ping_actions.isEmpty())
            ping_anyActions = false;
        }
        if (action instanceof Runnable)
          ((Runnable) action).run();
        else if (eq(action, "cancelled"))
          throw fail("Thread cancelled.");
      }
      return false;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  /** writes safely (to temp file, then rename) */
  public static void saveBinaryFile(String fileName, byte[] contents) throws IOException {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
    fileOutputStream.write(contents);
    fileOutputStream.close();
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
    if (!new File(tempFileName).renameTo(file))
      throw new IOException("Can't rename " + tempFileName + " to " + fileName);
  }

  public static void saveBinaryFile(File fileName, byte[] contents) {
    try {
      saveBinaryFile(fileName.getPath(), contents);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public static String hideCredentials(URL url) {
    return url == null ? null : hideCredentials(str(url));
  }

  public static String hideCredentials(String url) {
    return url.replaceAll("([&?])_pass=[^&\\s\"]*", "$1_pass=<hidden>");
  }

  public static byte[] loadBinaryPage(String url) {
    try {
      print("Loading " + url);
      return loadBinaryPage(loadPage_openConnection(new URL(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] loadBinaryPage(URLConnection con) {
    try {
      setHeaders(con);
      return loadBinaryPage_noHeaders(con);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static byte[] loadBinaryPage_noHeaders(URLConnection con) {
    try {
      ByteArrayOutputStream buf = new ByteArrayOutputStream();
      InputStream inputStream = con.getInputStream();
      long len = 0;
      try {
        len = con.getContentLengthLong();
      } catch (Throwable e) {
        printStackTrace(e);
      }
      int n = 0;
      while (true) {
        int ch = inputStream.read();
        if (ch < 0)
          break;
        buf.write(ch);
        if (++n % 100000 == 0)
          println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
      }
      inputStream.close();
      return buf.toByteArray();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String fromUtf8(byte[] bytes) {
    try {
      return new String(bytes, "UTF-8");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static File getGlobalCache() {
    File file = new File(javaxCachesDir(), "Binary Snippets");
    file.mkdirs();
    return file;
  }

  public static String dataSnippetLink(String snippetID) {
    long id = parseSnippetID(snippetID);
    if (id >= 1200000 && id < 1300000) {
      String pw = muricaPassword();
      if (empty(pw))
        throw fail("Please set 'murica password by running #1008829");
      // XXX, although it typically gets hidden when printing
      return "http://ai1.lol/1008823/raw/" + id + "?_pass=" + pw;
    } else
      return "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id + "&contentType=application/binary";
  }

  public static <A, B> Map<A, B> newWeakHashMap() {
    return _registerWeakMap(synchroMap(new WeakHashMap()));
  }

  public static boolean empty(Collection c) {
    return c == null || c.isEmpty();
  }

  public static boolean empty(String s) {
    return s == null || s.length() == 0;
  }

  public static boolean empty(Map map) {
    return map == null || map.isEmpty();
  }

  public static boolean empty(Object[] o) {
    return o == null || o.length == 0;
  }

  public static boolean empty(Object o) {
    if (o instanceof Collection)
      return empty((Collection) o);
    if (o instanceof String)
      return empty((String) o);
    if (o instanceof Map)
      return empty((Map) o);
    if (o instanceof Object[])
      return empty((Object[]) o);
    throw fail("unknown type for 'empty': " + getType(o));
  }

  public static boolean empty(float[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(int[] a) {
    return a == null || a.length == 0;
  }

  public static boolean empty(long[] a) {
    return a == null || a.length == 0;
  }

  public static String getStackTrace(Throwable throwable) {
    lastException(throwable);
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    return hideCredentials(writer.toString());
  }

  public static Class javax() {
    return getJavaX();
  }

  public static String formatSnippetID(String id) {
    return "#" + parseSnippetID(id);
  }

  public static String formatSnippetID(long id) {
    return "#" + id;
  }

  // TODO: test if android complains about this
  public static boolean isAWTThread() {
    if (isAndroid())
      return false;
    if (isHeadless())
      return false;
    return isAWTThread_awt();
  }

  public static boolean isAWTThread_awt() {
    return SwingUtilities.isEventDispatchThread();
  }

  public static Thread currentThread() {
    return Thread.currentThread();
  }

  public static boolean eq(Object a, Object b) {
    return a == null ? b == null : a == b || a.equals(b);
  }

  public static String str(Object o) {
    return o == null ? "null" : o.toString();
  }

  public static String str(char[] c) {
    return new String(c);
  }

  public static Map synchroMap() {
    return synchroHashMap();
  }

  public static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
    return Collections.synchronizedMap(map);
  }

  public static String muricaPassword() {
    return trim(loadTextFile(muricaPasswordFile()));
  }

  public static <A> A println(A a) {
    return print(a);
  }

  // can be set to work on different base dir
  public static File javaxCachesDir_dir;

  public static File javaxCachesDir() {
    return javaxCachesDir_dir != null ? javaxCachesDir_dir : new File(userHome(), "JavaX-Caches");
  }

  public static FileOutputStream newFileOutputStream(File path) throws IOException {
    return newFileOutputStream(path.getPath());
  }

  public static FileOutputStream newFileOutputStream(String path) throws IOException {
    return newFileOutputStream(path, false);
  }

  public static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
    FileOutputStream f = new // Line break for ancient translator
    FileOutputStream(path, append);
    callJavaX("registerIO", f, path, true);
    return f;
  }

  public static File mkdirsFor(File file) {
    return mkdirsForFile(file);
  }

  public static void setHeaders(URLConnection con) throws IOException {
    String computerID = getComputerID_quick();
    if (computerID != null)
      try {
        con.setRequestProperty("X-ComputerID", computerID);
        con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
      } catch (Throwable e) {
      //printShortException(e);
      }
  }

  public static ThreadLocal<String> loadPage_charset = new ThreadLocal();

  public static boolean loadPage_allowGzip = true, loadPage_debug;

  // don't send computer ID
  public static boolean loadPage_anonymous;

  public static int loadPage_verboseness = 100000;

  //60; // seconds
  public static int loadPage_retries = 1;

  public static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  // ms
  public static volatile int loadPage_forcedTimeout;

  public static ThreadLocal<Map<String, List<String>>> loadPage_responseHeaders = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPageSilently(URL url) {
    try {
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++) try {
        URLConnection con = loadPage_openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPageThroughProxy_enabled) {
          print("Trying proxy because of: " + e);
          try {
            return loadPageThroughProxy(str(url));
          } catch (Throwable e2) {
            print("  " + exceptionToStringShort(e2));
          }
        } else if (loadPage_debug)
          print(e);
        sleepSeconds(1);
      }
      throw e;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPage_preprocess(String url) {
    if (// don't think we use this anymore
    url.startsWith("tb/"))
      url = tb_mainServer() + "/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }

  public static String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        print("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadPage(URL url) {
    print("Loading: " + hideCredentials(url.toExternalForm()));
    return loadPageSilently(url);
  }

  public static String loadPage(URLConnection con, URL url) throws IOException {
    return loadPage(con, url, true);
  }

  public static String loadPage(URLConnection con, URL url, boolean addHeaders) throws IOException {
    if (addHeaders)
      try {
        if (!loadPage_anonymous)
          setHeaders(con);
        if (loadPage_allowGzip)
          con.setRequestProperty("Accept-Encoding", "gzip");
        con.setRequestProperty("X-No-Cookies", "1");
      }// fails if within doPost
       catch (Throwable e) {
      }
    String contentType = con.getContentType();
    if (contentType == null) {
      printStruct("Headers: ", con.getHeaderFields());
      throw new IOException("Page could not be read: " + url);
    }
    //print("Content-Type: " + contentType);
    String charset = loadPage_charset == null ? null : loadPage_charset.get();
    if (charset == null)
      charset = loadPage_guessCharset(contentType);
    InputStream in = con.getInputStream();
    try {
      loadPage_responseHeaders.set(con.getHeaderFields());
      if ("gzip".equals(con.getContentEncoding())) {
        if (loadPage_debug)
          print("loadPage: Using gzip.");
        in = new GZIPInputStream(in);
      }
      Reader r = new InputStreamReader(in, charset);
      StringBuilder buf = new StringBuilder();
      int n = 0;
      while (true) {
        int ch = r.read();
        if (ch < 0)
          break;
        buf.append((char) ch);
        ++n;
        if ((n % loadPage_verboseness) == 0)
          print("  " + n + " chars read");
      }
      return buf.toString();
    } finally {
      in.close();
    }
  }

  public static String loadPage_guessCharset(String contentType) {
    Pattern p = Pattern.compile("text/[a-z]+;\\s*charset=([^\\s]+)\\s*");
    Matcher m = p.matcher(contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
    return or(match, "ISO-8859-1");
  }

  public static URLConnection loadPage_openConnection(URL url) {
    URLConnection con = openConnection(url);
    if (loadPage_forcedTimeout != 0)
      setURLConnectionTimeouts(con, loadPage_forcedTimeout);
    return con;
  }

  public static long parseLong(String s) {
    if (s == null)
      return 0;
    return Long.parseLong(dropSuffix("L", s));
  }

  public static long parseLong(Object s) {
    return Long.parseLong((String) s);
  }

  public static volatile Throwable lastException_lastException;

  public static Throwable lastException() {
    return lastException_lastException;
  }

  public static void lastException(Throwable e) {
    lastException_lastException = e;
  }

  public static String getComputerID_quick() {
    return computerID();
  }

  public static String trim(String s) {
    return s == null ? null : s.trim();
  }

  public static String trim(StringBuilder buf) {
    return buf.toString().trim();
  }

  public static String trim(StringBuffer buf) {
    return buf.toString().trim();
  }

  public static URLConnection setURLConnectionTimeouts(URLConnection con, int timeout) {
    con.setConnectTimeout(timeout);
    con.setReadTimeout(timeout);
    if (con.getConnectTimeout() != timeout || con.getReadTimeout() != timeout)
      print("Warning: Timeouts not set by JDK.");
    return con;
  }

  public static String getType(Object o) {
    return getClassName(o);
  }

  public static List _registerWeakMap_preList;

  public static <A> A _registerWeakMap(A map) {
    if (javax() == null) {
      // We're in class init
      if (_registerWeakMap_preList == null)
        _registerWeakMap_preList = synchroList();
      _registerWeakMap_preList.add(map);
      return map;
    }
    try {
      call(javax(), "_registerWeakMap", map);
    } catch (Throwable e) {
      printException(e);
      print("Upgrade JavaX!!");
    }
    return map;
  }

  public static void _onLoad_registerWeakMap() {
    assertNotNull(javax());
    if (_registerWeakMap_preList == null)
      return;
    for (Object o : _registerWeakMap_preList) _registerWeakMap(o);
    _registerWeakMap_preList = null;
  }

  public static String _userHome;

  public static String userHome() {
    if (_userHome == null) {
      if (isAndroid())
        _userHome = "/storage/sdcard0/";
      else
        _userHome = System.getProperty("user.home");
    //System.out.println("userHome: " + _userHome);
    }
    return _userHome;
  }

  public static File userHome(String path) {
    return new File(userDir(), path);
  }

  public static String exceptionToStringShort(Throwable e) {
    lastException(e);
    e = getInnerException(e);
    String msg = unnull(e.getMessage());
    if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
      return baseClassName(e) + ": " + msg;
    else
      return msg;
  }

  public static boolean isTrue(Object o) {
    if (o instanceof Boolean)
      return ((Boolean) o).booleanValue();
    if (o == null)
      return false;
    throw fail(getClassName(o));
  }

  public static File muricaPasswordFile() {
    return new File(javaxSecretDir(), "murica/muricaPasswordFile");
  }

  public static final boolean loadPageThroughProxy_enabled = false;

  public static String loadPageThroughProxy(String url) {
    return null;
  }

  public static Boolean isHeadless_cache;

  public static boolean isHeadless() {
    if (isHeadless_cache != null)
      return isHeadless_cache;
    if (GraphicsEnvironment.isHeadless())
      return isHeadless_cache = true;
    try {
      SwingUtilities.isEventDispatchThread();
      return isHeadless_cache = false;
    } catch (Throwable e) {
      return isHeadless_cache = true;
    }
  }

  public static <A> A printStruct(String prefix, A a) {
    printStructure(prefix, a);
    return a;
  }

  public static <A> A printStruct(A a) {
    printStructure(a);
    return a;
  }

  public static void sleepSeconds(double s) {
    if (s > 0)
      sleep(round(s * 1000));
  }

  public static File mkdirsForFile(File file) {
    File dir = file.getParentFile();
    if (// is null if file is in current dir
    dir != null)
      dir.mkdirs();
    return file;
  }

  public static Object callJavaX(String method, Object... args) {
    return callOpt(getJavaX(), method, args);
  }

  public static String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(File fileName, String defaultContents) {
    ping();
    try {
      if (fileName == null || !fileName.exists())
        return defaultContents;
      FileInputStream fileInputStream = new FileInputStream(fileName);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
      return loadTextFile(inputStreamReader);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(String fileName, String defaultContents) {
    return fileName == null ? defaultContents : loadTextFile(newFile(fileName), defaultContents);
  }

  public static String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer))) builder.append(buffer, 0, n);
    } finally {
      reader.close();
    }
    return builder.toString();
  }

  public static <A> A or(A a, A b) {
    return a != null ? a : b;
  }

  public static String dropSuffix(String suffix, String s) {
    return s.endsWith(suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  public static String tb_mainServer_default = "http://tinybrain.de:8080";

  // func -> S
  public static Object tb_mainServer_override;

  public static String tb_mainServer() {
    if (tb_mainServer_override != null)
      return (String) callF(tb_mainServer_override);
    return trim(loadTextFile(tb_mainServer_file(), tb_mainServer_default));
  }

  public static File tb_mainServer_file() {
    return getProgramFile("#1001638", "mainserver.txt");
  }

  public static boolean tb_mainServer_isDefault() {
    return eq(tb_mainServer(), tb_mainServer_default);
  }

  public static Map synchroHashMap() {
    return Collections.synchronizedMap(new HashMap());
  }

  public static int isAndroid_flag;

  public static boolean isAndroid() {
    if (isAndroid_flag == 0)
      isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
    return isAndroid_flag > 0;
  }

  // can be set to work on different base dir
  public static File javaxSecretDir_dir;

  public static File javaxSecretDir() {
    return javaxSecretDir_dir != null ? javaxSecretDir_dir : new File(userHome(), "JavaX-Secret");
  }

  public static <A> A assertNotNull(A a) {
    assertTrue(a != null);
    return a;
  }

  public static <A> A assertNotNull(String msg, A a) {
    assertTrue(msg, a != null);
    return a;
  }

  public static volatile boolean sleep_noSleep;

  public static void sleep(long ms) {
    ping();
    if (ms < 0)
      return;
    // allow spin locks
    if (isAWTThread() && ms > 100)
      throw fail("Should not sleep on AWT thread");
    try {
      Thread.sleep(ms);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public static void sleep() {
    try {
      if (sleep_noSleep)
        throw fail("nosleep");
      print("Sleeping.");
      sleepQuietly();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String baseClassName(String className) {
    return substring(className, className.lastIndexOf('.') + 1);
  }

  public static String baseClassName(Object o) {
    return baseClassName(getClassName(o));
  }

  public static Throwable getInnerException(Throwable e) {
    while (e.getCause() != null) e = e.getCause();
    return e;
  }

  public static String _computerID;

  public static String computerID() {
    try {
      if (_computerID == null) {
        File file = new File(userHome(), ".tinybrain/computer-id");
        _computerID = loadTextFile(file.getPath(), null);
        if (_computerID == null) {
          _computerID = makeRandomID(12);
          saveTextFile(file.getPath(), _computerID);
        }
      }
      return _computerID;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void printStructure(String prefix, Object o) {
    if (endsWithLetter(prefix))
      prefix += ": ";
    print(prefix + structureForUser(o));
  }

  public static void printStructure(Object o) {
    print(structureForUser(o));
  }

  public static void printException(Throwable e) {
    printStackTrace(e);
  }

  public static File newFile(File base, String... names) {
    for (String name : names) base = new File(base, name);
    return base;
  }

  public static File newFile(String name) {
    return name == null ? null : new File(name);
  }

  public static <A> List<A> synchroList() {
    return Collections.synchronizedList(new ArrayList<A>());
  }

  public static <A> List<A> synchroList(List<A> l) {
    return Collections.synchronizedList(l);
  }

  public static File getProgramFile(String progID, String fileName) {
    if (new File(fileName).isAbsolute())
      return new File(fileName);
    return new File(getProgramDir(progID), fileName);
  }

  public static File getProgramFile(String fileName) {
    return getProgramFile(getProgramID(), fileName);
  }

  public static long round(double d) {
    return Math.round(d);
  }

  public static File userDir() {
    return new File(userHome());
  }

  public static File userDir(String path) {
    return new File(userHome(), path);
  }

  public static String programID;

  public static String getProgramID() {
    return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
  }

  // TODO: ask JavaX instead
  public static String getProgramID(Class c) {
    String id = (String) getOpt(c, "programID");
    if (nempty(id))
      return formatSnippetID(id);
    return "?";
  }

  public static String getProgramID(Object o) {
    return getProgramID(getMainClass(o));
  }

  public static boolean endsWithLetter(String s) {
    return nempty(s) && isLetter(last(s));
  }

  public static File getProgramDir() {
    return programDir();
  }

  public static File getProgramDir(String snippetID) {
    return programDir(snippetID);
  }

  /** writes safely (to temp file, then rename) */
  public static File saveTextFile(String fileName, String contents) throws IOException {
    CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
    try {
      File file = new File(fileName);
      File parentFile = file.getParentFile();
      if (parentFile != null)
        parentFile.mkdirs();
      String tempFileName = fileName + "_temp";
      File tempFile = new File(tempFileName);
      if (contents != null) {
        if (tempFile.exists())
          try {
            String saveName = tempFileName + ".saved." + now();
            copyFile(tempFile, new File(saveName));
          } catch (Throwable e) {
            printStackTrace(e);
          }
        FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.print(contents);
        printWriter.close();
      }
      if (file.exists() && !file.delete())
        throw new IOException("Can't delete " + fileName);
      if (contents != null)
        if (!tempFile.renameTo(file))
          throw new IOException("Can't rename " + tempFile + " to " + file);
      return file;
    } finally {
      action.done();
    }
  }

  public static File saveTextFile(File fileName, String contents) {
    try {
      saveTextFile(fileName.getPath(), contents);
      return fileName;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String substring(String s, int x) {
    return substring(s, x, l(s));
  }

  public static String substring(String s, int x, int y) {
    if (s == null)
      return null;
    if (x < 0)
      x = 0;
    if (x > s.length())
      return "";
    if (y < x)
      y = x;
    if (y > s.length())
      y = s.length();
    return s.substring(x, y);
  }

  public static Object sleepQuietly_monitor = new Object();

  public static void sleepQuietly() {
    try {
      assertFalse(isAWTThread());
      synchronized (sleepQuietly_monitor) {
        sleepQuietly_monitor.wait();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String structureForUser(Object o) {
    return beautifyStructure(struct_noStringSharing(o));
  }

  public static String makeRandomID(int length) {
    Random random = new Random();
    char[] id = new char[length];
    for (int i = 0; i < id.length; i++) id[i] = (char) ((int) 'a' + random.nextInt(26));
    return new String(id);
  }

  public static String struct_noStringSharing(Object o) {
    structure_Data d = new structure_Data();
    d.noStringSharing = true;
    return structure(o, d);
  }

  public static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

  public static class CriticalAction {

    public String description;

    public CriticalAction() {
    }

    public CriticalAction(String description) {
      this.description = description;
    }

    public void done() {
      beginCriticalAction_inFlight.remove(this);
    }
  }

  public static CriticalAction beginCriticalAction(String description) {
    ping();
    CriticalAction c = new CriticalAction(description);
    beginCriticalAction_inFlight.add(c);
    return c;
  }

  public static void cleanMeUp_beginCriticalAction() {
    int n = 0;
    while (nempty(beginCriticalAction_inFlight)) {
      int m = l(beginCriticalAction_inFlight);
      if (m != n) {
        n = m;
        try {
          print("Waiting for " + n(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
        } catch (Throwable __e) {
          printStackTrace2(__e);
        }
      }
      sleepInCleanUp(10);
    }
  }

  public static void copyFile(File src, File dest) {
    try {
      mkdirsForFile(dest);
      FileInputStream inputStream = new FileInputStream(src.getPath());
      FileOutputStream outputStream = newFileOutputStream(dest.getPath());
      try {
        copyStream(inputStream, outputStream);
        inputStream.close();
      } finally {
        outputStream.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Class getMainClass() {
    return main.class;
  }

  public static Class getMainClass(Object o) {
    try {
      return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  // set this to relocate program's data
  public static File programDir_mine;

  public static File programDir() {
    return programDir(getProgramID());
  }

  public static File programDir(String snippetID) {
    boolean me = sameSnippetID(snippetID, programID());
    if (programDir_mine != null && me)
      return programDir_mine;
    File dir = new File(javaxDataDir(), formatSnippetID(snippetID));
    if (me) {
      String c = caseID();
      if (nempty(c))
        dir = newFile(dir, c);
    }
    return dir;
  }

  public static <A> A last(List<A> l) {
    return empty(l) ? null : l.get(l.size() - 1);
  }

  public static char last(String s) {
    return empty(s) ? '#' : s.charAt(l(s) - 1);
  }

  public static int last(int[] a) {
    return l(a) != 0 ? a[l(a) - 1] : 0;
  }

  public static String beautifyStructure(String s) {
    return structure_addTokenMarkers(s);
  }

  public static void assertFalse(Object o) {
    assertEquals(false, o);
  }

  public static boolean assertFalse(boolean b) {
    if (b)
      throw fail("oops");
    return b;
  }

  public static boolean assertFalse(String msg, boolean b) {
    if (b)
      throw fail(msg);
    return b;
  }

  public static boolean isLetter(char c) {
    return Character.isLetter(c);
  }

  public static long now_virtualTime;

  public static long now() {
    return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
  }

  public static String formatSnippetIDOpt(String s) {
    return isSnippetID(s) ? formatSnippetID(s) : s;
  }

  public static boolean nempty(Collection c) {
    return !isEmpty(c);
  }

  public static boolean nempty(CharSequence s) {
    return !isEmpty(s);
  }

  public static boolean nempty(Object[] o) {
    return !isEmpty(o);
  }

  public static boolean nempty(Map m) {
    return !isEmpty(m);
  }

  public static boolean nempty(Iterator i) {
    return i != null && i.hasNext();
  }

  public static String join(String glue, Iterable<String> strings) {
    if (strings == null)
      return "";
    StringBuilder buf = new StringBuilder();
    Iterator<String> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext()) buf.append(glue).append(i.next());
    }
    return buf.toString();
  }

  public static String join(String glue, String... strings) {
    return join(glue, Arrays.asList(strings));
  }

  public static String join(Iterable<String> strings) {
    return join("", strings);
  }

  public static String join(Iterable<String> strings, String glue) {
    return join(glue, strings);
  }

  public static String join(String[] strings) {
    return join("", strings);
  }

  public static void sleepInCleanUp(long ms) {
    try {
      if (ms < 0)
        return;
      Thread.sleep(ms);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static volatile String caseID_caseID;

  public static String caseID() {
    return caseID_caseID;
  }

  public static void caseID(String id) {
    caseID_caseID = id;
  }

  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }

  public static String n(long l, String name) {
    return l + " " + trim(l == 1 ? singular(name) : getPlural(name));
  }

  public static String n(Collection l, String name) {
    return n(l(l), name);
  }

  public static String n(Map m, String name) {
    return n(l(m), name);
  }

  public static String n(Object[] a, String name) {
    return n(l(a), name);
  }

  public static boolean sameSnippetID(String a, String b) {
    if (!isSnippetID(a) || !isSnippetID(b))
      return false;
    return parseSnippetID(a) == parseSnippetID(b);
  }

  public static String structure_addTokenMarkers(String s) {
    List<String> tok = javaTok(s);
    // find references
    TreeSet<Integer> refs = new TreeSet();
    for (int i = 1; i < l(tok); i += 2) {
      String t = tok.get(i);
      if (t.startsWith("t") && isInteger(t.substring(1)))
        refs.add(parseInt(t.substring(1)));
    }
    if (empty(refs))
      return s;
    // add markers
    for (int i : refs) {
      int idx = i * 2 + 1;
      String t = "";
      if (endsWithLetterOrDigit(tok.get(idx - 1)))
        t = " ";
      tok.set(idx, t + "m" + i + " " + tok.get(idx));
    }
    return join(tok);
  }

  public static List collect(Collection c, String field) {
    return collectField(c, field);
  }

  public static List collect(String field, Collection c) {
    return collectField(c, field);
  }

  // can be set to work on different base dir
  public static File javaxDataDir_dir;

  public static File javaxDataDir() {
    return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
  }

  public static String programID() {
    return getProgramID();
  }

  public static boolean isEmpty(Collection c) {
    return c == null || c.isEmpty();
  }

  public static boolean isEmpty(CharSequence s) {
    return s == null || s.length() == 0;
  }

  public static boolean isEmpty(Object[] a) {
    return a == null || a.length == 0;
  }

  public static boolean isEmpty(Map map) {
    return map == null || map.isEmpty();
  }

  public static boolean structure_showTiming, structure_checkTokenCount;

  public static String structure(Object o) {
    return structure(o, new structure_Data());
  }

  public static String structure(Object o, structure_Data d) {
    StringWriter sw = new StringWriter();
    d.out = new PrintWriter(sw);
    structure_go(o, d);
    String s = str(sw);
    if (structure_checkTokenCount) {
      print("token count=" + d.n);
      assertEquals("token count", l(javaTokC(s)), d.n);
    }
    return s;
  }

  public static void structure_go(Object o, structure_Data d) {
    structure_1(o, d);
    while (nempty(d.stack)) popLast(d.stack).run();
  }

  public static void structureToPrintWriter(Object o, PrintWriter out) {
    structure_Data d = new structure_Data();
    d.out = out;
    structure_go(o, d);
  }

  // leave to false, unless unstructure() breaks
  public static boolean structure_allowShortening = false;

  public static class structure_Data {

    public PrintWriter out;

    public int stringSizeLimit;

    public int shareStringsLongerThan = 20;

    public boolean noStringSharing;

    public IdentityHashMap<Object, Integer> seen = new IdentityHashMap();

    //new BitSet refd;
    public HashMap<String, Integer> strings = new HashMap();

    public HashSet<String> concepts = new HashSet();

    public HashMap<Class, List<Field>> fieldsByClass = new HashMap();

    // token count
    public int n;

    public List<Runnable> stack = new ArrayList();

    // append single token
    public structure_Data append(String token) {
      out.print(token);
      ++n;
      return this;
    }

    public structure_Data append(int i) {
      out.print(i);
      ++n;
      return this;
    }

    // append multiple tokens
    public structure_Data append(String token, int tokCount) {
      out.print(token);
      n += tokCount;
      return this;
    }

    // extend last token
    public structure_Data app(String token) {
      out.print(token);
      return this;
    }

    public structure_Data app(int i) {
      out.print(i);
      return this;
    }
  }

  public static void structure_1(final Object o, final structure_Data d) {
    if (o == null) {
      d.append("null");
      return;
    }
    Class c = o.getClass();
    boolean concept = false;
    List<Field> lFields = d.fieldsByClass.get(c);
    if (lFields == null) {
      if (o instanceof Number) {
        PrintWriter out = d.out;
        if (o instanceof Integer) {
          int i = ((Integer) o).intValue();
          out.print(i);
          d.n += i < 0 ? 2 : 1;
          return;
        }
        if (o instanceof Long) {
          long l = ((Long) o).longValue();
          out.print(l);
          out.print("L");
          d.n += l < 0 ? 2 : 1;
          return;
        }
        if (o instanceof Float) {
          d.append("fl ", 2);
          quoteToPrintWriter(str(o), out);
          return;
        }
        if (o instanceof Double) {
          d.append("d(", 3);
          quoteToPrintWriter(str(o), out);
          d.append(")");
          return;
        }
        if (o instanceof BigInteger) {
          out.print("bigint(");
          out.print(o);
          out.print(")");
          d.n += ((BigInteger) o).signum() < 0 ? 5 : 4;
          return;
        }
      }
      if (o instanceof Boolean) {
        d.append(((Boolean) o).booleanValue() ? "t" : "f");
        return;
      }
      if (o instanceof Character) {
        d.append(quoteCharacter((Character) o));
        return;
      }
      if (o instanceof File) {
        d.append("File ").append(quote(((File) o).getPath()));
        return;
      }
      // referencable objects follow
      Integer ref = d.seen.get(o);
      if (o instanceof String && ref == null)
        ref = d.strings.get((String) o);
      if (ref != null) {
        /*d.refd.set(ref);*/
        d.append("t").app(ref);
        return;
      }
      if (!(o instanceof String))
        // record token number
        d.seen.put(o, d.n);
      else {
        String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
        if (!d.noStringSharing) {
          if (d.shareStringsLongerThan == Integer.MAX_VALUE)
            d.seen.put(o, d.n);
          if (l(s) >= d.shareStringsLongerThan)
            d.strings.put(s, d.n);
        }
        quoteToPrintWriter(s, d.out);
        d.n++;
        return;
      }
      if (o instanceof HashSet) {
        d.append("hashset ");
        structure_1(new ArrayList((Set) o), d);
        return;
      }
      if (o instanceof TreeSet) {
        d.append("treeset ");
        structure_1(new ArrayList((Set) o), d);
        return;
      }
      String name = c.getName();
      if (o instanceof Collection && !startsWith(name, "main$")) /* && neq(name, "main$Concept$RefL") */
      {
        d.append("[");
        final int l = d.n;
        final Iterator it = ((Collection) o).iterator();
        d.stack.add(new Runnable() {

          public void run() {
            try {
              if (!it.hasNext())
                d.append("]");
              else {
                d.stack.add(this);
                if (d.n != l)
                  d.append(", ");
                structure_1(it.next(), d);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.stack....";
          }
        });
        return;
      }
      if (o instanceof Map && !startsWith(name, "main$")) {
        if (o instanceof LinkedHashMap)
          d.append("lhm");
        else if (o instanceof HashMap)
          d.append("hm");
        d.append("{");
        final int l = d.n;
        final Iterator it = ((Map) o).entrySet().iterator();
        d.stack.add(new Runnable() {

          public boolean v;

          public Map.Entry e;

          public void run() {
            if (v) {
              d.append("=");
              v = false;
              d.stack.add(this);
              structure_1(e.getValue(), d);
            } else {
              if (!it.hasNext())
                d.append("}");
              else {
                e = (Map.Entry) it.next();
                v = true;
                d.stack.add(this);
                if (d.n != l)
                  d.append(", ");
                structure_1(e.getKey(), d);
              }
            }
          }
        });
        return;
      }
      if (c.isArray()) {
        if (o instanceof byte[]) {
          d.append("ba ").append(quote(bytesToHex((byte[]) o)));
          return;
        }
        final int n = Array.getLength(o);
        if (o instanceof boolean[]) {
          String hex = boolArrayToHex((boolean[]) o);
          int i = l(hex);
          while (i > 0 && hex.charAt(i - 1) == '0' && hex.charAt(i - 2) == '0') i -= 2;
          d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i)));
          return;
        }
        String atype = "array", sep = ", ";
        if (o instanceof int[]) {
          //ret "intarray " + quote(intArrayToHex((int[]) o));
          atype = "intarray";
          sep = " ";
        }
        d.append(atype).append("{");
        d.stack.add(new Runnable() {

          public int i;

          public void run() {
            if (i >= n)
              d.append("}");
            else {
              d.stack.add(this);
              if (i > 0)
                d.append(", ");
              structure_1(Array.get(o, i++), d);
            }
          }
        });
        return;
      }
      if (o instanceof Class) {
        d.append("class(", 2).append(quote(((Class) o).getName())).append(")");
        return;
      }
      if (o instanceof Throwable) {
        d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")");
        return;
      }
      if (o instanceof BitSet) {
        BitSet bs = (BitSet) o;
        d.append("bitset{", 2);
        int l = d.n;
        for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i + 1)) {
          if (d.n != l)
            d.append(", ");
          d.append(i);
        }
        d.append("}");
        return;
      }
      // Need more cases? This should cover all library classes...
      if (name.startsWith("java.") || name.startsWith("javax.")) {
        // Hm. this is not unstructure-able
        d.append("j ").append(quote(str(o)));
        // Hm. this is not unstructure-able
        return;
      }
      if (o instanceof Lisp) {
        d.append("l(", 2);
        final Lisp lisp = (Lisp) (o);
        structure_1(lisp.head, d);
        final Iterator it = lisp.args.iterator();
        d.stack.add(new Runnable() {

          public void run() {
            try {
              if (!it.hasNext())
                d.append(")");
              else {
                d.stack.add(this);
                d.append(", ");
                structure_1(it.next(), d);
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (!it.hasNext())\r\n            d.append(\")\");\r\n          else {\r\n            d....";
          }
        });
        return;
      }
      /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
      String dynName = shortDynamicClassName(o);
      if (concept && !d.concepts.contains(dynName)) {
        d.concepts.add(dynName);
        d.append("c ");
      }
      // serialize an object with fields.
      // first, collect all fields and values in fv.
      TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {

        public int compare(Field a, Field b) {
          return stdcompare(a.getName(), b.getName());
        }
      });
      Class cc = c;
      while (cc != Object.class) {
        for (Field field : getDeclaredFields_cached(cc)) {
          if ((field.getModifiers() & (java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.TRANSIENT)) != 0)
            continue;
          String fieldName = field.getName();
          fields.add(field);
        // put special cases here...
        }
        cc = cc.getSuperclass();
      }
      lFields = asList(fields);
      for (int i = 0; i < l(lFields); i++) {
        Field f = lFields.get(i);
        if (f.getName().equals("this$1")) {
          lFields.remove(i);
          lFields.add(0, f);
          break;
        }
      }
      d.fieldsByClass.put(c, lFields);
    } else // << if (lFields == null)
    {
      // ref handling for lFields != null
      Integer ref = d.seen.get(o);
      if (ref != null) {
        /*d.refd.set(ref);*/
        d.append("t").app(ref);
        return;
      }
      // record token number
      d.seen.put(o, d.n);
    }
    LinkedHashMap<String, Object> fv = new LinkedHashMap();
    for (Field f : lFields) {
      Object value;
      try {
        value = f.get(o);
      } catch (Exception e) {
        value = "?";
      }
      if (value != null)
        fv.put(f.getName(), value);
    }
    String name = c.getName();
    String shortName = dropPrefix("main$", name);
    // omit field "className" if equal to class's name
    if (concept && eq(fv.get("className"), shortName))
      fv.remove("className");
    if (o instanceof DynamicObject) {
      fv.putAll((Map) fv.get("fieldValues"));
      fv.remove("fieldValues");
      shortName = shortDynamicClassName(o);
      fv.remove("className");
    }
    String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
    d.append(shortName);
    final int l = d.n;
    final Iterator it = fv.entrySet().iterator();
    d.stack.add(new Runnable() {

      public void run() {
        try {
          if (!it.hasNext()) {
            if (d.n != l)
              d.append(")");
          } else {
            Map.Entry e = (Map.Entry) it.next();
            d.append(d.n == l ? "(" : ", ");
            d.append((String) e.getKey()).append("=");
            d.stack.add(this);
            structure_1(e.getValue(), d);
          }
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public String toString() {
        return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else {\r...";
      }
    });
  }

  public static Throwable printStackTrace2(Throwable e) {
    // we go to system.out now - system.err is nonsense
    print(getStackTrace2(e));
    return e;
  }

  public static void printStackTrace2() {
    printStackTrace2(new Throwable());
  }

  public static void printStackTrace2(String msg) {
    printStackTrace2(new Throwable(msg));
  }

  /*static void printStackTrace2(S indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace2(e));
}*/
  public static String quote(Object o) {
    if (o == null)
      return "null";
    return quote(str(o));
  }

  public static String quote(String s) {
    if (s == null)
      return "null";
    StringBuilder out = new StringBuilder((int) (l(s) * 1.5 + 2));
    quote_impl(s, out);
    return out.toString();
  }

  public static void quote_impl(String s, StringBuilder out) {
    out.append('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"')
        out.append('\\').append(c);
      else if (c == '\r')
        out.append("\\r");
      else if (c == '\n')
        out.append("\\n");
      else
        out.append(c);
    }
    out.append('"');
  }

  public static int shorten_default = 100;

  public static String shorten(String s) {
    return shorten(s, shorten_default);
  }

  public static String shorten(String s, int max) {
    if (s == null)
      return "";
    if (max < 0)
      return s;
    return s.length() <= max ? s : s.substring(0, Math.min(s.length(), max)) + "...";
  }

  public static String shorten(int max, String s) {
    return shorten(s, max);
  }

  public static String quoteCharacter(char c) {
    if (c == '\'')
      return "'\\''";
    if (c == '\\')
      return "'\\\\'";
    if (c == '\r')
      return "'\\r'";
    if (c == '\n')
      return "'\\n'";
    if (c == '\t')
      return "'\\t'";
    return "'" + c + "'";
  }

  public static String getStackTrace2(Throwable throwable) {
    return hideCredentials(getStackTrace(throwable) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ", hideCredentials(str(getInnerException(throwable)))) + "\n");
  }

  public static String shortDynamicClassName(Object o) {
    if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
      return ((DynamicObject) o).className;
    return shortClassName(o);
  }

  public static String dropPrefix(String prefix, String s) {
    return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
  }

  public static List<String> getPlural_specials = ll("sheep", "fish");

  public static String getPlural(String s) {
    if (containsIgnoreCase(getPlural_specials, s))
      return s;
    if (ewic(s, "y"))
      return dropSuffixIgnoreCase("y", s) + "ies";
    if (ewic(s, "ss"))
      return s + "es";
    if (ewic(s, "s"))
      return s;
    return s + "s";
  }

  public static Map<String, String> singular_specials = litmap("children", "child", "images", "image", "chess", "chess");

  public static Set<String> singular_specials2 = litset("time", "machine");

  public static String singular(String s) {
    if (s == null)
      return null;
    {
      String _a_306 = singular_specials.get(s);
      if (!empty(_a_306))
        return _a_306;
    }
    {
      String _a_307 = hippoSingulars().get(lower(s));
      if (!empty(_a_307))
        return _a_307;
    }
    if (singular_specials2.contains(dropSuffix("s", s)))
      return dropSuffix("s", s);
    if (s.endsWith("ness"))
      return s;
    if (s.endsWith("ges"))
      return dropSuffix("s", s);
    if (endsWith(s, "bases"))
      return dropLast(s);
    s = dropSuffix("es", s);
    s = dropSuffix("s", s);
    return s;
  }

  // replacement for class JavaTok
  // maybe incomplete, might want to add floating point numbers
  // todo also: extended multi-line strings
  public static int javaTok_n, javaTok_elements;

  public static boolean javaTok_opt;

  public static List<String> javaTok(String s) {
    return javaTok(s, null);
  }

  public static List<String> javaTok(String s, List<String> existing) {
    ++javaTok_n;
    int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
    ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
    int l = s.length();
    int i = 0, n = 0;
    while (i < l) {
      int j = i;
      char c, d;
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(quickSubstring(s, i, j));
      ++n;
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      // Special JavaX syntax: 'identifier
      if (c == '\'' && Character.isJavaIdentifierStart(d) && i + 2 < l && "'\\".indexOf(s.charAt(i + 2)) < 0) {
        j += 2;
        while (j < l && Character.isJavaIdentifierPart(s.charAt(j))) ++j;
      } else if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener) /*|| s.charAt(j) == '\n'*/
          {
            // allow multi-line strings
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        // for stuff like "don't"
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        // Long constants like 1L
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
        tok.add(existing.get(n));
      else
        tok.add(quickSubstring(s, i, j));
      ++n;
      i = j;
    }
    if ((tok.size() % 2) == 0)
      tok.add("");
    javaTok_elements += tok.size();
    return tok;
  }

  public static List<String> javaTok(List<String> tok) {
    return javaTok(join(tok), tok);
  }

  public static boolean javaTok_isCopyable(String t, String s, int i, int j) {
    return t.length() == j - i && // << could be left out, but that's brave
    s.regionMatches(i, t, 0, j - i);
  }

  public static List collectField(Collection c, String field) {
    List l = new ArrayList();
    for (Object a : c) l.add(getOpt(a, field));
    return l;
  }

  public static List<String> javaTokC(String s) {
    if (s == null)
      return null;
    int l = s.length();
    ArrayList<String> tok = new ArrayList();
    int i = 0;
    while (i < l) {
      int j = i;
      char c, d;
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j + 1 >= l ? '\0' : s.charAt(j + 1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
          j = Math.min(j + 2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      i = j;
      if (i >= l)
        break;
      c = s.charAt(i);
      d = i + 1 >= l ? '\0' : s.charAt(i + 1);
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') {
            // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j + 1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        // for stuff like "don't"
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        // Long constants like 1L
        if (j < l && s.charAt(j) == 'L')
          ++j;
      } else if (c == '[' && d == '[') {
        do ++j; while (j + 1 < l && !s.substring(j, j + 2).equals("]]"));
        j = Math.min(j + 2, l);
      } else if (c == '[' && d == '=' && i + 2 < l && s.charAt(i + 2) == '[') {
        do ++j; while (j + 2 < l && !s.substring(j, j + 3).equals("]=]"));
        j = Math.min(j + 3, l);
      } else
        ++j;
      tok.add(quickSubstring(s, i, j));
      i = j;
    }
    return tok;
  }

  public static HashMap<Class, Field[]> getDeclaredFields_cache = new HashMap();

  public static Field[] getDeclaredFields_cached(Class c) {
    Field[] fields;
    synchronized (getDeclaredFields_cache) {
      fields = getDeclaredFields_cache.get(c);
      if (fields == null) {
        getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
        for (Field f : fields) f.setAccessible(true);
      }
    }
    return fields;
  }

  public static String boolArrayToHex(boolean[] a) {
    return bytesToHex(boolArrayToBytes(a));
  }

  public static boolean endsWithLetterOrDigit(String s) {
    return nempty(s) && isLetterOrDigit(lastCharacter(s));
  }

  public static Object first(Object list) {
    return empty((List) list) ? null : ((List) list).get(0);
  }

  public static <A> A first(List<A> list) {
    return empty(list) ? null : list.get(0);
  }

  public static <A> A first(A[] bla) {
    return bla == null || bla.length == 0 ? null : bla[0];
  }

  public static <A> A first(Iterable<A> i) {
    if (i == null)
      return null;
    Iterator<A> it = i.iterator();
    return it.hasNext() ? it.next() : null;
  }

  public static Character first(String s) {
    return empty(s) ? null : s.charAt(0);
  }

  public static <A, B> A first(Pair<A, B> p) {
    return p == null ? null : p.a;
  }

  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len * 2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs + i]);
      stringBuilder.append(s.substring(s.length() - 2, s.length()));
    }
    return stringBuilder.toString();
  }

  public static boolean isInteger(String s) {
    if (s == null)
      return false;
    int n = l(s);
    if (n == 0)
      return false;
    int i = 0;
    if (s.charAt(0) == '-')
      if (++i >= n)
        return false;
    while (i < n) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  public static void quoteToPrintWriter(String s, PrintWriter out) {
    if (s == null) {
      out.print("null");
      return;
    }
    out.print('"');
    int l = s.length();
    for (int i = 0; i < l; i++) {
      char c = s.charAt(i);
      if (c == '\\' || c == '"') {
        out.print('\\');
        out.print(c);
      } else if (c == '\r')
        out.print("\\r");
      else if (c == '\n')
        out.print("\\n");
      else
        out.print(c);
    }
    out.print('"');
  }

  public static <A> ArrayList<A> list(A[] a) {
    return asList(a);
  }

  public static ArrayList<Integer> list(int[] a) {
    return asList(a);
  }

  public static <A> ArrayList<A> list(Set<A> s) {
    return asList(s);
  }

  public static int parseInt(String s) {
    return empty(s) ? 0 : Integer.parseInt(s);
  }

  public static int parseInt(char c) {
    return Integer.parseInt(str(c));
  }

  public static <A> A popLast(List<A> l) {
    return liftLast(l);
  }

  public static int stdcompare(Number a, Number b) {
    return cmp(a, b);
  }

  public static int stdcompare(String a, String b) {
    return cmp(a, b);
  }

  public static int stdcompare(long a, long b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }

  public static int stdcompare(Object a, Object b) {
    return cmp(a, b);
  }

  public static boolean startsWith(String a, String b) {
    return a != null && a.startsWith(b);
  }

  public static boolean startsWith(String a, char c) {
    return nempty(a) && a.charAt(0) == c;
  }

  public static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b))
      return false;
    m.m = new String[] { substring(a, l(b)) };
    return true;
  }

  public static boolean startsWith(List a, List b) {
    if (a == null || l(b) > l(a))
      return false;
    for (int i = 0; i < l(b); i++) if (neq(a.get(i), b.get(i)))
      return false;
    return true;
  }

  public static String[] dropLast(String[] a, int n) {
    n = Math.min(n, a.length);
    String[] b = new String[a.length - n];
    System.arraycopy(a, 0, b, 0, b.length);
    return b;
  }

  public static <A> List<A> dropLast(List<A> l) {
    return subList(l, 0, l(l) - 1);
  }

  public static <A> List<A> dropLast(int n, List<A> l) {
    return subList(l, 0, l(l) - n);
  }

  public static <A> List<A> dropLast(Iterable<A> l) {
    return dropLast(asList(l));
  }

  public static String dropLast(String s) {
    return substring(s, 0, l(s) - 1);
  }

  public static String dropLast(String s, int n) {
    return substring(s, 0, l(s) - n);
  }

  public static <A> HashSet<A> litset(A... items) {
    return lithashset(items);
  }

  public static String replacePrefix(String prefix, String replacement, String s) {
    if (!startsWith(s, prefix))
      return s;
    return replacement + substring(s, l(prefix));
  }

  public static boolean endsWith(String a, String b) {
    return a != null && a.endsWith(b);
  }

  public static boolean endsWith(String a, char c) {
    return nempty(a) && lastChar(a) == c;
  }

  public static String quickSubstring(String s, int i, int j) {
    if (i == j)
      return "";
    return s.substring(i, j);
  }

  public static <A> A liftLast(List<A> l) {
    if (l.isEmpty())
      return null;
    int i = l(l) - 1;
    A a = l.get(i);
    l.remove(i);
    return a;
  }

  public static String dropSuffixIgnoreCase(String suffix, String s) {
    return ewic(s, suffix) ? s.substring(0, l(s) - l(suffix)) : s;
  }

  public static String shortClassName(Object o) {
    if (o == null)
      return null;
    Class c = o instanceof Class ? (Class) o : o.getClass();
    String name = c.getName();
    return shortenClassName(name);
  }

  public static boolean containsIgnoreCase(Collection<String> l, String s) {
    for (String x : l) if (eqic(x, s))
      return true;
    return false;
  }

  public static boolean containsIgnoreCase(String[] l, String s) {
    for (String x : l) if (eqic(x, s))
      return true;
    return false;
  }

  public static boolean containsIgnoreCase(String s, char c) {
    return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
  }

  public static boolean containsIgnoreCase(String a, String b) {
    return indexOfIgnoreCase(a, b) >= 0;
  }

  public static byte[] boolArrayToBytes(boolean[] a) {
    byte[] b = new byte[(l(a) + 7) / 8];
    for (int i = 0; i < l(a); i++) if (a[i])
      b[i / 8] |= 1 << (i & 7);
    return b;
  }

  public static String lower(String s) {
    return s == null ? null : s.toLowerCase();
  }

  public static char lower(char c) {
    return Character.toLowerCase(c);
  }

  public static Map litmap(Object... x) {
    HashMap map = new HashMap();
    litmap_impl(map, x);
    return map;
  }

  public static void litmap_impl(Map map, Object... x) {
    for (int i = 0; i < x.length - 1; i += 2) if (x[i + 1] != null)
      map.put(x[i], x[i + 1]);
  }

  public static int cmp(Number a, Number b) {
    return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
  }

  public static int cmp(double a, double b) {
    return a < b ? -1 : a == b ? 0 : 1;
  }

  public static int cmp(String a, String b) {
    return a == null ? b == null ? 0 : -1 : a.compareTo(b);
  }

  public static int cmp(Object a, Object b) {
    if (a == null)
      return b == null ? 0 : -1;
    if (b == null)
      return 1;
    return ((Comparable) a).compareTo(b);
  }

  public static Map<String, String> hippoSingulars() {
    return pairsToMap((List<Pair<String, String>>) scanStructureLog("#1011041", "singulars"));
  }

  public static boolean ewic(String a, String b) {
    return endsWithIgnoreCase(a, b);
  }

  public static char lastCharacter(String s) {
    return empty(s) ? 0 : s.charAt(l(s) - 1);
  }

  public static boolean neq(Object a, Object b) {
    return !eq(a, b);
  }

  public static boolean isLetterOrDigit(char c) {
    return Character.isLetterOrDigit(c);
  }

  public static <A> List<A> subList(List<A> l, int startIndex) {
    return subList(l, startIndex, l(l));
  }

  public static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
    startIndex = max(0, min(l(l), startIndex));
    endIndex = max(0, min(l(l), endIndex));
    if (startIndex > endIndex)
      return litlist();
    return l.subList(startIndex, endIndex);
  }

  public static <A, B> HashMap<A, B> pairsToMap(Collection<? extends Pair<A, B>> l) {
    HashMap<A, B> map = new HashMap();
    if (l != null)
      for (Pair<A, B> p : l) map.put(p.a, p.b);
    return map;
  }

  public static <A> HashSet<A> lithashset(A... items) {
    HashSet<A> set = new HashSet();
    for (A a : items) set.add(a);
    return set;
  }

  public static boolean eqic(String a, String b) {
    if ((a == null) != (b == null))
      return false;
    if (a == null)
      return true;
    return a.equalsIgnoreCase(b);
  }

  public static String shortenClassName(String name) {
    if (name == null)
      return null;
    int i = lastIndexOf(name, "$");
    if (i < 0)
      i = lastIndexOf(name, ".");
    return i < 0 ? name : substring(name, i + 1);
  }

  public static boolean endsWithIgnoreCase(String a, String b) {
    return a != null && l(a) >= l(b) && a.regionMatches(true, l(a) - l(b), b, 0, l(b));
  }

  // works on lists and strings and null
  public static int indexOfIgnoreCase(Object a, Object b) {
    if (a == null)
      return -1;
    if (a instanceof String) {
      Matcher m = Pattern.compile((String) b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher((String) a);
      if (m.find())
        return m.start();
      else
        return -1;
    }
    if (a instanceof List) {
      for (int i = 0; i < ((List) a).size(); i++) {
        Object o = ((List) a).get(i);
        if (o != null && ((String) o).equalsIgnoreCase((String) b))
          return i;
      }
      return -1;
    }
    throw fail("Unknown type: " + a);
  }

  public static List scanStructureLog(String progID, String fileName) {
    return scanStructureLog(getProgramFile(progID, fileName));
  }

  public static List scanStructureLog(String fileName) {
    return scanStructureLog(getProgramFile(fileName));
  }

  public static List scanStructureLog(File file) {
    List l = new ArrayList();
    for (String s : scanLog(file)) try {
      l.add(unstructure(s));
    } catch (Throwable __e) {
      printStackTrace2(__e);
    }
    return l;
  }

  public static char lastChar(String s) {
    return empty(s) ? '\0' : s.charAt(l(s) - 1);
  }

  public static Object unstructure(String text) {
    return unstructure(text, false);
  }

  public static Object unstructure(String text, final boolean allDynamic) {
    return unstructure(text, allDynamic, null);
  }

  public static int structure_internStringsLongerThan = 50;

  // stats
  public static int unstructure_tokrefs;

  public abstract static class unstructure_Receiver {

    public abstract void set(Object o);
  }

  // classFinder: func(name) -> class (optional)
  public static Object unstructure(String text, boolean allDynamic, Object classFinder) {
    if (text == null)
      return null;
    return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
  }

  public static Object unstructure_reader(BufferedReader reader) {
    return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
  }

  public static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object classFinder) {
    final boolean debug = unstructure_debug;
    final class X {

      public int i = -1;

      public HashMap<Integer, Object> refs = new HashMap();

      public HashMap<Integer, Object> tokrefs = new HashMap();

      public HashSet<String> concepts = new HashSet();

      public HashMap<String, Class> classesMap = new HashMap();

      public List<Runnable> stack = new ArrayList();

      public String curT;

      // look at current token
      public String t() {
        return curT;
      }

      // get current token, move to next
      public String tpp() {
        String t = curT;
        consume();
        return t;
      }

      public void parse(final unstructure_Receiver out) {
        String t = t();
        int refID = 0;
        if (structure_isMarker(t, 0, l(t))) {
          refID = parseInt(t.substring(1));
          consume();
        }
        final int _refID = refID;
        // if (debug) print("parse: " + quote(t));
        final int tokIndex = i;
        parse_inner(refID, tokIndex, new unstructure_Receiver() {

          public void set(Object o) {
            if (_refID != 0)
              refs.put(_refID, o);
            if (o != null)
              tokrefs.put(tokIndex, o);
            out.set(o);
          }
        });
      }

      public void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
        String t = t();
        // if (debug) print("parse_inner: " + quote(t));
        Class c = classesMap.get(t);
        if (c == null) {
          if (t.startsWith("\"")) {
            String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
            out.set(s);
            return;
          }
          if (t.startsWith("'")) {
            out.set(unquoteCharacter(tpp()));
            return;
          }
          if (t.equals("bigint")) {
            out.set(parseBigInt());
            return;
          }
          if (t.equals("d")) {
            out.set(parseDouble());
            return;
          }
          if (t.equals("fl")) {
            out.set(parseFloat());
            return;
          }
          if (t.equals("false") || t.equals("f")) {
            consume();
            out.set(false);
            return;
          }
          if (t.equals("true") || t.equals("t")) {
            consume();
            out.set(true);
            return;
          }
          if (t.equals("-")) {
            consume();
            t = tpp();
            out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t)));
            return;
          }
          if (isInteger(t) || isLongConstant(t)) {
            consume();
            //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
            if (isLongConstant(t)) {
              out.set(parseLong(t));
              return;
            }
            long l = parseLong(t);
            boolean isInt = l == (int) l;
            if (debug)
              print("l=" + l + ", isInt: " + isInt);
            out.set(isInt ? (Object) new Integer((int) l) : (Object) new Long(l));
            return;
          }
          if (t.equals("File")) {
            consume();
            File f = new File(unquote(tpp()));
            out.set(f);
            return;
          }
          if (t.startsWith("r") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = refs.get(ref);
            if (o == null)
              print("Warning: unsatisfied back reference " + ref);
            out.set(o);
            return;
          }
          if (t.startsWith("t") && isInteger(t.substring(1))) {
            consume();
            int ref = Integer.parseInt(t.substring(1));
            Object o = tokrefs.get(ref);
            if (o == null)
              print("Warning: unsatisfied token reference " + ref);
            out.set(o);
            return;
          }
          if (t.equals("hashset")) {
            parseHashSet(out);
            return;
          }
          if (t.equals("treeset")) {
            parseTreeSet(out);
            return;
          }
          if (eqOneOf(t, "hashmap", "hm")) {
            consume();
            parseMap(new HashMap(), out);
            return;
          }
          if (t.equals("lhm")) {
            consume();
            parseMap(new LinkedHashMap(), out);
            return;
          }
          if (t.equals("{")) {
            parseMap(out);
            return;
          }
          if (t.equals("[")) {
            parseList(out);
            return;
          }
          if (t.equals("bitset")) {
            parseBitSet(out);
            return;
          }
          if (t.equals("array") || t.equals("intarray")) {
            parseArray(out);
            return;
          }
          if (t.equals("ba")) {
            consume();
            String hex = unquote(tpp());
            out.set(hexToBytes(hex));
            return;
          }
          if (t.equals("boolarray")) {
            consume();
            int n = parseInt(tpp());
            String hex = unquote(tpp());
            out.set(boolArrayFromBytes(hexToBytes(hex), n));
            return;
          }
          if (t.equals("class")) {
            out.set(parseClass());
            return;
          }
          if (t.equals("l")) {
            parseLisp(out);
            return;
          }
          if (t.equals("null")) {
            consume();
            out.set(null);
            return;
          }
          if (eq(t, "c")) {
            consume("c");
            t = t();
            assertTrue(isJavaIdentifier(t));
            concepts.add(t);
          }
        }
        if (eq(t, "j")) {
          consume("j");
          out.set(parseJava());
          return;
        }
        if (c == null && !isJavaIdentifier(t))
          throw new RuntimeException("Unknown token " + (i + 1) + ": " + t);
        // any other class name
        if (c == null) {
          // First, find class
          if (allDynamic)
            c = null;
          else
            c = classFinder != null ? (Class) callF(classFinder, t) : findClass(t);
          if (c != null)
            classesMap.put(t, c);
        }
        // Check if it has an outer reference
        consume();
        boolean hasBracket = eq(t(), "(");
        if (hasBracket)
          consume();
        boolean hasOuter = hasBracket && eq(t(), "this$1");
        DynamicObject dO = null;
        Object o = null;
        if (c != null) {
          o = hasOuter ? nuStubInnerObject(c) : nuEmptyObject(c);
          if (o instanceof DynamicObject)
            dO = (DynamicObject) o;
        } else {
          if (concepts.contains(t) && (c = findClass("Concept")) != null)
            o = dO = (DynamicObject) nuEmptyObject(c);
          else
            dO = new DynamicObject();
          dO.className = t;
          if (debug)
            print("Made dynamic object " + t + " " + shortClassName(dO));
        }
        if (refID != 0)
          refs.put(refID, o != null ? o : dO);
        tokrefs.put(tokIndex, o != null ? o : dO);
        // NOW parse the fields!
        // preserve order
        final LinkedHashMap<String, Object> fields = new LinkedHashMap();
        final Object _o = o;
        final DynamicObject _dO = dO;
        if (hasBracket) {
          stack.add(new Runnable() {

            public void run() {
              try {
                if (eq(t(), ")")) {
                  consume(")");
                  objRead(_o, _dO, fields);
                  out.set(_o != null ? _o : _dO);
                } else {
                  final String key = unquote(tpp());
                  consume("=");
                  stack.add(this);
                  parse(new unstructure_Receiver() {

                    public void set(Object value) {
                      fields.put(key, value);
                      if (eq(t(), ","))
                        consume();
                    }
                  });
                }
              } catch (Exception __e) {
                throw rethrow(__e);
              }
            }

            public String toString() {
              return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, fie...";
            }
          });
        } else {
          objRead(o, dO, fields);
          out.set(o != null ? o : dO);
        }
      }

      public void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
        if (o != null)
          if (dO != null) {
            if (debug)
              printStructure("setOptAllDyn", fields);
            setOptAllDyn(dO, fields);
          } else {
            setOptAll(o, fields);
          }
        else
          for (String field : keys(fields)) dO.fieldValues.put(field.intern(), fields.get(field));
        if (o != null)
          pcallOpt_noArgs(o, "_doneLoading");
      }

      public void parseSet(final Set set, final unstructure_Receiver out) {
        parseList(new unstructure_Receiver() {

          public void set(Object o) {
            set.addAll((List) o);
            out.set(set);
          }
        });
      }

      public void parseLisp(final unstructure_Receiver out) {
        consume("l");
        consume("(");
        final ArrayList list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), ")")) {
                consume(")");
                out.set(newObject("main$Lisp", (String) list.get(0), subList(list, 1)));
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \")\")) {\r\n          consume(\")\");\r\n          out.set(newObject(\"main$...";
          }
        });
      }

      public void parseBitSet(final unstructure_Receiver out) {
        consume("bitset");
        consume("{");
        final BitSet bs = new BitSet();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(bs);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    bs.set((Integer) o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n        } ...";
          }
        });
      }

      public void parseList(final unstructure_Receiver out) {
        consume("[");
        final ArrayList list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "]")) {
                consume("]");
                out.set(list);
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    //if (debug) print("List element type: " + getClassName(o));
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n        ...";
          }
        });
      }

      public void parseArray(final unstructure_Receiver out) {
        final String type = tpp();
        consume("{");
        final List list = new ArrayList();
        stack.add(new Runnable() {

          public void run() {
            try {
              if (eq(t(), "}")) {
                consume("}");
                out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
              } else {
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    list.add(o);
                    if (eq(t(), ","))
                      consume();
                  }
                });
              }
            } catch (Exception __e) {
              throw rethrow(__e);
            }
          }

          public String toString() {
            return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"int...";
          }
        });
      }

      public Object parseClass() {
        consume("class");
        consume("(");
        String name = unquote(tpp());
        consume(")");
        name = dropPrefix("main$", name);
        Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass(name);
        if (c != null)
          return c;
        DynamicObject dO = new DynamicObject();
        dO.className = "java.lang.Class";
        dO.fieldValues.put("name", name);
        return dO;
      }

      public Object parseBigInt() {
        consume("bigint");
        consume("(");
        String val = tpp();
        if (eq(val, "-"))
          val = "-" + tpp();
        consume(")");
        return new BigInteger(val);
      }

      public Object parseDouble() {
        consume("d");
        consume("(");
        String val = unquote(tpp());
        consume(")");
        return Double.parseDouble(val);
      }

      public Object parseFloat() {
        consume("fl");
        String val;
        if (eq(t(), "(")) {
          consume("(");
          val = unquote(tpp());
          consume(")");
        } else {
          val = unquote(tpp());
        }
        return Float.parseFloat(val);
      }

      public void parseHashSet(unstructure_Receiver out) {
        consume("hashset");
        parseSet(new HashSet(), out);
      }

      public void parseTreeSet(unstructure_Receiver out) {
        consume("treeset");
        parseSet(new TreeSet(), out);
      }

      public void parseMap(unstructure_Receiver out) {
        parseMap(new TreeMap(), out);
      }

      public Object parseJava() {
        String j = unquote(tpp());
        Matches m = new Matches();
        if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
          return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
        else {
          warn("Unknown Java object: " + j);
          return null;
        }
      }

      public void parseMap(final Map map, final unstructure_Receiver out) {
        consume("{");
        stack.add(new Runnable() {

          public boolean v;

          public Object key;

          public void run() {
            if (v) {
              v = false;
              stack.add(this);
              consume("=");
              parse(new unstructure_Receiver() {

                public void set(Object value) {
                  map.put(key, value);
                  if (debug)
                    print("parseMap: Got value " + getClassName(value) + ", next token: " + quote(t()));
                  if (eq(t(), ","))
                    consume();
                }
              });
            } else {
              if (eq(t(), "}")) {
                consume("}");
                out.set(map);
              } else {
                v = true;
                stack.add(this);
                parse(new unstructure_Receiver() {

                  public void set(Object o) {
                    key = o;
                  }
                });
              }
            }
          // if v else
          }
        });
      }

      /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
      public void consume() {
        curT = tok.next();
        ++i;
      }

      public void consume(String s) {
        if (!eq(t(), s)) {
          /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
          throw fail(quote(s) + " expected, got " + quote(t()));
        }
        consume();
      }

      public void parse_x(unstructure_Receiver out) {
        // get first token
        consume();
        parse(out);
        while (nempty(stack)) popLast(stack).run();
      }
    }
    final Var v = new Var();
    X x = new X();
    x.parse_x(new unstructure_Receiver() {

      public void set(Object o) {
        v.set(o);
      }
    });
    unstructure_tokrefs = x.tokrefs.size();
    return v.get();
  }

  public static boolean unstructure_debug;

  public static int min(int a, int b) {
    return Math.min(a, b);
  }

  public static long min(long a, long b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b) {
    return Math.min(a, b);
  }

  public static float min(float a, float b, float c) {
    return min(min(a, b), c);
  }

  public static double min(double a, double b) {
    return Math.min(a, b);
  }

  public static double min(double[] c) {
    double x = Double.MAX_VALUE;
    for (double d : c) x = Math.min(x, d);
    return x;
  }

  public static float min(float[] c) {
    float x = Float.MAX_VALUE;
    for (float d : c) x = Math.min(x, d);
    return x;
  }

  public static byte min(byte[] c) {
    byte x = 127;
    for (byte d : c) if (d < x)
      x = d;
    return x;
  }

  public static short min(short[] c) {
    short x = 0x7FFF;
    for (short d : c) if (d < x)
      x = d;
    return x;
  }

  public static List<String> scanLog(String progID, String fileName) {
    return scanLog(getProgramFile(progID, fileName));
  }

  public static List<String> scanLog(String fileName) {
    return scanLog(getProgramFile(fileName));
  }

  public static List<String> scanLog(File file) {
    List<String> l = new ArrayList();
    for (String s : toLines(file)) if (isProperlyQuoted(s))
      l.add(unquote(s));
    return l;
  }

  public static int lastIndexOf(String a, String b) {
    return a == null || b == null ? -1 : a.lastIndexOf(b);
  }

  public static int max(int a, int b) {
    return Math.max(a, b);
  }

  public static int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  public static long max(int a, long b) {
    return Math.max((long) a, b);
  }

  public static long max(long a, long b) {
    return Math.max(a, b);
  }

  public static double max(int a, double b) {
    return Math.max((double) a, b);
  }

  public static float max(float a, float b) {
    return Math.max(a, b);
  }

  public static double max(double a, double b) {
    return Math.max(a, b);
  }

  public static int max(Collection<Integer> c) {
    int x = Integer.MIN_VALUE;
    for (int i : c) x = max(x, i);
    return x;
  }

  public static double max(double[] c) {
    if (c.length == 0)
      return Double.MIN_VALUE;
    double x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static float max(float[] c) {
    if (c.length == 0)
      return Float.MAX_VALUE;
    float x = c[0];
    for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
    return x;
  }

  public static byte max(byte[] c) {
    byte x = -128;
    for (byte d : c) if (d > x)
      x = d;
    return x;
  }

  public static short max(short[] c) {
    short x = -0x8000;
    for (short d : c) if (d > x)
      x = d;
    return x;
  }

  public static byte[] hexToBytes(String s) {
    int n = l(s) / 2;
    byte[] bytes = new byte[n];
    for (int i = 0; i < n; i++) {
      String hex = substring(s, i * 2, i * 2 + 2);
      try {
        bytes[i] = (byte) parseHexByte(hex);
      } catch (Throwable _e) {
        throw fail("Bad hex byte: " + quote(hex) + " at " + i * 2 + "/" + l(s));
      }
    }
    return bytes;
  }

  public static boolean isProperlyQuoted(String s) {
    return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"") && (!s.endsWith("\\\"") || s.endsWith("\\\\\""));
  }

  public static HashMap<Class, Constructor> nuEmptyObject_cache = new HashMap();

  public static <A> A nuEmptyObject(Class<A> c) {
    try {
      Constructor ctr;
      synchronized (nuEmptyObject_cache) {
        ctr = nuEmptyObject_cache.get(c);
        if (ctr == null) {
          nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
          ctr.setAccessible(true);
        }
      }
      return (A) ctr.newInstance();
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Constructor nuEmptyObject_findConstructor(Class c) {
    for (Constructor m : c.getDeclaredConstructors()) if (m.getParameterTypes().length == 0)
      return m;
    throw fail("No default constructor declared in " + c.getName());
  }

  public static boolean setOptAllDyn_debug;

  public static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) {
      Object val = fields.get(field);
      boolean has = hasField(o, field);
      if (has)
        setOpt(o, field, val);
      else {
        o.fieldValues.put(field.intern(), val);
        if (setOptAllDyn_debug)
          print("setOptAllDyn added dyn " + field + " to " + o + " [value: " + val + ", fieldValues = " + systemHashCode(o.fieldValues) + ", " + struct(keys(o.fieldValues)) + "]");
      }
    }
  }

  public static boolean structure_isMarker(String s, int i, int j) {
    if (i >= j)
      return false;
    if (s.charAt(i) != 'm')
      return false;
    ++i;
    while (i < j) {
      char c = s.charAt(i);
      if (c < '0' || c > '9')
        return false;
      ++i;
    }
    return true;
  }

  public static Object newObject(Class c, Object... args) {
    return nuObject(c, args);
  }

  public static Object newObject(String className, Object... args) {
    return nuObject(className, args);
  }

  public static boolean jmatch(String pat, String s) {
    return jmatch(pat, s, null);
  }

  public static boolean jmatch(String pat, String s, Matches matches) {
    if (s == null)
      return false;
    return jmatch(pat, javaTok(s), matches);
  }

  public static boolean jmatch(String pat, List<String> toks) {
    return jmatch(pat, toks, null);
  }

  public static boolean jmatch(String pat, List<String> toks, Matches matches) {
    List<String> tokpat = javaTok(pat);
    String[] m = match2(tokpat, toks);
    //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
    if (m == null)
      return false;
    else {
      if (matches != null)
        matches.m = m;
      return true;
    }
  }

  public static Producer<String> javaTokC_noMLS_iterator(final String s) {
    return new Producer<String>() {

      public final int l = s.length();

      public int i = 0;

      public String next() {
        if (i >= l)
          return null;
        int j = i;
        char c, d;
        // scan for whitespace
        while (j < l) {
          c = s.charAt(j);
          d = j + 1 >= l ? '\0' : s.charAt(j + 1);
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            ++j;
          else if (c == '/' && d == '*') {
            do ++j; while (j < l && !s.substring(j, Math.min(j + 2, l)).equals("*/"));
            j = Math.min(j + 2, l);
          } else if (c == '/' && d == '/') {
            do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
          } else
            break;
        }
        i = j;
        if (i >= l)
          return null;
        c = s.charAt(i);
        d = i + 1 >= l ? '\0' : s.charAt(i + 1);
        // scan for non-whitespace
        if (c == '\'' || c == '"') {
          char opener = c;
          ++j;
          while (j < l) {
            if (s.charAt(j) == opener || s.charAt(j) == '\n') {
              // end at \n to not propagate unclosed string literal errors
              ++j;
              break;
            } else if (s.charAt(j) == '\\' && j + 1 < l)
              j += 2;
            else
              ++j;
          }
        } else if (Character.isJavaIdentifierStart(c))
          // for stuff like "don't"
          do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0));
        else if (Character.isDigit(c)) {
          do ++j; while (j < l && Character.isDigit(s.charAt(j)));
          // Long constants like 1L
          if (j < l && s.charAt(j) == 'L')
            ++j;
        } else
          ++j;
        String t = quickSubstring(s, i, j);
        i = j;
        return t;
      }
    };
  }

  public static boolean warn_on = true;

  public static void warn(String s) {
    if (warn_on)
      print("Warning: " + s);
  }

  public static void warn(String s, List<String> warnings) {
    warn(s);
    if (warnings != null)
      warnings.add(s);
  }

  public static String unquote(String s) {
    if (s == null)
      return null;
    if (s.startsWith("[")) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i + 1, s.length() - i - 1);
      }
    }
    if ((s.startsWith("\"") || s.startsWith("\'")) && s.length() > 1) {
      int l = s.endsWith(substring(s, 0, 1)) ? s.length() - 1 : s.length();
      StringBuilder sb = new StringBuilder(l - 1);
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
            String code = "" + nextChar;
            i++;
            if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
              code += s.charAt(i + 1);
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                code += s.charAt(i + 1);
                i++;
              }
            }
            sb.append((char) Integer.parseInt(code, 8));
            continue;
          }
          switch(nextChar) {
            case '\\':
              ch = '\\';
              break;
            case 'b':
              ch = '\b';
              break;
            case 'f':
              ch = '\f';
              break;
            case 'n':
              ch = '\n';
              break;
            case 'r':
              ch = '\r';
              break;
            case 't':
              ch = '\t';
              break;
            case '\"':
              ch = '\"';
              break;
            case '\'':
              ch = '\'';
              break;
            // Hex Unicode: u????
            case 'u':
              if (i >= l - 5) {
                ch = 'u';
                break;
              }
              int code = Integer.parseInt("" + s.charAt(i + 2) + s.charAt(i + 3) + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
            default:
              // added by Stefan
              ch = nextChar;
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();
    }
    // not quoted - return original
    return s;
  }

  public static void setOptAll(Object o, Map<String, Object> fields) {
    if (fields == null)
      return;
    for (String field : keys(fields)) setOpt(o, field, fields.get(field));
  }

  public static void setOptAll(Object o, Object... values) {
    //values = expandParams(c.getClass(), values);
    warnIfOddCount(values);
    for (int i = 0; i + 1 < l(values); i += 2) {
      String field = (String) values[i];
      Object value = values[i + 1];
      setOpt(o, field, value);
    }
  }

  public static char unquoteCharacter(String s) {
    assertTrue(s.startsWith("'") && s.length() > 1);
    return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length() - 1 : s.length()) + "\"").charAt(0);
  }

  public static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
    final class X implements Producer<String> {

      // stores from "i"
      public StringBuilder buf = new StringBuilder();

      // just not '\0'
      public char c, d, e = 'x';

      public X() {
        // fill c, d and e
        nc();
        nc();
        nc();
      }

      // get next character(s) into c, d and e
      public void nc() {
        try {
          c = d;
          d = e;
          if (e == '\0')
            return;
          int i = r.read();
          e = i < 0 ? '\0' : (char) i;
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }

      public void ncSave() {
        if (c != '\0') {
          buf.append(c);
          nc();
        }
      }

      public String next() {
        // scan for whitespace
        while (c != '\0') {
          if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
            nc();
          else if (c == '/' && d == '*') {
            do nc(); while (c != '\0' && !(c == '*' && d == '/'));
            nc();
            nc();
          } else if (c == '/' && d == '/') {
            do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
          } else
            break;
        }
        if (c == '\0')
          return null;
        // scan for non-whitespace
        if (c == '\'' || c == '"') {
          char opener = c;
          ncSave();
          while (c != '\0') {
            if (c == opener || c == '\n') {
              // end at \n to not propagate unclosed string literal errors
              ncSave();
              break;
            } else if (c == '\\') {
              ncSave();
              ncSave();
            } else
              ncSave();
          }
        } else if (Character.isJavaIdentifierStart(c))
          // for stuff like "don't"
          do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\'');
        else if (Character.isDigit(c)) {
          do ncSave(); while (Character.isDigit(c));
          // Long constants like 1L
          if (c == 'L')
            ncSave();
        } else
          ncSave();
        String t = buf.toString();
        buf.setLength(0);
        return t;
      }
    }
    return new X();
  }

  public static <A> A nuStubInnerObject(Class<A> c) {
    try {
      Class outerType = getOuterClass(c);
      Constructor m = c.getDeclaredConstructor(outerType);
      m.setAccessible(true);
      return (A) m.newInstance(new Object[] { null });
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean[] boolArrayFromBytes(byte[] a, int n) {
    boolean[] b = new boolean[n];
    int m = min(n, l(a) * 8);
    for (int i = 0; i < m; i++) b[i] = (a[i / 8] & 1 << (i & 7)) != 0;
    return b;
  }

  public static HashMap<String, Class> findClass_cache = new HashMap();

  // currently finds only inner classes of class "main"
  // returns null on not found
  // this is the simple version that is not case-tolerant
  public static Class findClass(String name) {
    synchronized (findClass_cache) {
      if (findClass_cache.containsKey(name))
        return findClass_cache.get(name);
      if (!isJavaIdentifier(name))
        return null;
      Class c;
      try {
        c = Class.forName("main$" + name);
      } catch (ClassNotFoundException e) {
        c = null;
      }
      findClass_cache.put(name, c);
      return c;
    }
  }

  public static boolean isJavaIdentifier(String s) {
    if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
      return false;
    for (int i = 1; i < s.length(); i++) if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
    return true;
  }

  public static float parseFloat(String s) {
    return Float.parseFloat(s);
  }

  public static boolean isLongConstant(String s) {
    if (!s.endsWith("L"))
      return false;
    s = s.substring(0, l(s) - 1);
    return isInteger(s);
  }

  public static List<String> toLines(File f) {
    return toLines(loadTextFile(f));
  }

  public static List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null)
      return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start)
          lines.add(s.substring(start));
        break;
      }
      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i + 1 < s.length() && s.charAt(i + 1) == '\n')
        i += 2;
      else
        ++i;
      start = i;
    }
    return lines;
  }

  public static int toLines_nextLineBreak(String s, int start) {
    for (int i = start; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }

  public static String internIfLongerThan(String s, int l) {
    return s == null ? null : l(s) >= l ? s.intern() : s;
  }

  public static void pcallOpt_noArgs(Object o, String method) {
    try {
      callOpt_noArgs(o, method);
    } catch (Throwable __e) {
      printStackTrace2(__e);
    }
  }

  public static int[] toIntArray(List<Integer> l) {
    int[] a = new int[l(l)];
    for (int i = 0; i < a.length; i++) a[i] = l.get(i);
    return a;
  }

  public static boolean eqOneOf(Object o, Object... l) {
    for (Object x : l) if (eq(o, x))
      return true;
    return false;
  }

  public static Object nuObject(String className, Object... args) {
    try {
      return nuObject(Class.forName(className), args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  // too ambiguous - maybe need to fix some callers
  /*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/
  public static <A> A nuObject(Class<A> c, Object... args) {
    try {
      Constructor m = nuObject_findConstructor(c, args);
      m.setAccessible(true);
      return (A) m.newInstance(args);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static Constructor nuObject_findConstructor(Class c, Object... args) {
    for (Constructor m : c.getDeclaredConstructors()) {
      if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
        continue;
      return m;
    }
    throw fail("Constructor " + c.getName() + getClasses(args) + " not found" + (args.length == 0 && (c.getModifiers() & java.lang.reflect.Modifier.STATIC) == 0 ? " - hint: it's a non-static class!" : ""));
  }

  public static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++) if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
    return true;
  }

  public static <A, B> Set<A> keys(Map<A, B> map) {
    return map == null ? new HashSet() : map.keySet();
  }

  public static Set keys(Object map) {
    return keys((Map) map);
  }

  public static double parseDouble(String s) {
    return Double.parseDouble(s);
  }

  public static boolean hasField(Object o, String field) {
    return findField2(o, field) != null;
  }

  // match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)
  public static String[] match2(List<String> pat, List<String> tok) {
    // standard case (no ...)
    int i = pat.indexOf("...");
    if (i < 0)
      return match2_match(pat, tok);
    // We're modifying it, so copy first
    pat = new ArrayList<String>(pat);
    pat.set(i, "*");
    while (pat.size() < tok.size()) {
      pat.add(i, "*");
      // doesn't matter
      pat.add(i + 1, "");
    }
    return match2_match(pat, tok);
  }

  public static String[] match2_match(List<String> pat, List<String> tok) {
    List<String> result = new ArrayList<String>();
    if (pat.size() != tok.size()) {
      return null;
    }
    for (int i = 1; i < pat.size(); i += 2) {
      String p = pat.get(i), t = tok.get(i);
      if (eq(p, "*"))
        result.add(t);
      else if (// bold change - match quoted and unquoted now
      !equalsIgnoreCase(unquote(p), unquote(t)))
        return null;
    }
    return result.toArray(new String[result.size()]);
  }

  public static int systemHashCode(Object o) {
    return identityHashCode(o);
  }

  public static void warnIfOddCount(Object... list) {
    if (odd(l(list)))
      printStackTrace("Odd list size: " + list);
  }

  public static String struct(Object o) {
    return structure(o);
  }

  public static String struct(Object o, structure_Data data) {
    return structure(o, data);
  }

  public static Class getOuterClass(Class c) {
    try {
      String s = c.getName();
      int i = s.lastIndexOf('$');
      return Class.forName(substring(s, 0, i));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static List<Class> getClasses(Object[] array) {
    List<Class> l = new ArrayList();
    for (Object o : array) l.add(_getClass(o));
    return l;
  }

  public static WeakHashMap<Class, HashMap<String, Method>> callOpt_noArgs_cache = new WeakHashMap();

  public static Object callOpt_noArgs(Object o, String method) {
    try {
      if (o == null)
        return null;
      if (o instanceof Class)
        // not optimized
        return callOpt(o, method);
      Class c = o.getClass();
      HashMap<String, Method> map;
      synchronized (callOpt_noArgs_cache) {
        map = callOpt_noArgs_cache.get(c);
        if (map == null)
          map = callOpt_noArgs_makeCache(c);
      }
      Method m = map.get(method);
      return m != null ? m.invoke(o) : null;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  // used internally - we are in synchronized block
  public static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
    HashMap<String, Method> map = new HashMap();
    Class _c = c;
    do {
      for (Method m : c.getDeclaredMethods()) if (m.getParameterTypes().length == 0) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
    callOpt_noArgs_cache.put(c, map);
    return map;
  }

  public static int parseHexByte(String s) {
    return Integer.parseInt(s, 16);
  }

  public static boolean equalsIgnoreCase(String a, String b) {
    return a == null ? b == null : a.equalsIgnoreCase(b);
  }

  public static boolean equalsIgnoreCase(char a, char b) {
    if (a == b)
      return true;
    char u1 = Character.toUpperCase(a);
    char u2 = Character.toUpperCase(b);
    if (u1 == u2)
      return true;
    return Character.toLowerCase(u1) == Character.toLowerCase(u2);
  }

  public static Field findField2(Object o, String field) {
    if (o instanceof Class)
      return findField2_findStaticField((Class) o, field);
    return findField2_findField(o.getClass(), field);
  }

  public static Field findField2_findStaticField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field) && (f.getModifiers() & java.lang.reflect.Modifier.STATIC) != 0)
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static Field findField2_findField(Class<?> c, String field) {
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) if (f.getName().equals(field))
        return f;
      _c = _c.getSuperclass();
    } while (_c != null);
    return null;
  }

  public static int identityHashCode(Object o) {
    return System.identityHashCode(o);
  }

  public static boolean odd(int i) {
    return (i & 1) != 0;
  }

  public static boolean odd(long i) {
    return (i & 1) != 0;
  }

  public static class JavaXClassLoaderWithParent2 extends JavaXClassLoader {

    public ClassLoader virtualParent;

    public List<String> classesToSkip;

    public JavaXClassLoaderWithParent2(String progID, List<File> files, ClassLoader virtualParent, List<String> classesToSkip) {
      super(progID, files);
      this.virtualParent = virtualParent;
      this.classesToSkip = classesToSkip;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
      if (shouldDelegate(name)) {
        Class<?> c = virtualParent.loadClass(name);
        if (c != null)
          return c;
      }
      return super.findClass(name);
    }

    public boolean shouldDelegate(String name) {
      for (String s : classesToSkip) if (eq(name, s) || startsWith(name, s + "$"))
        return true;
      return false;
    }
  }

  public abstract static class F0<A> {

    public abstract A get();
  }

  public abstract static class F1<A, B> {

    public abstract B get(A a);
  }

  public static interface Producer<A> {

    public A next();
  }

  public static class CompilerBot {

    public static boolean verbose;

    public static File compileSnippet(String snippetID) {
      return compileSnippet(snippetID, "");
    }

    public static Pair<File, String> compileSnippet2(String snippetID) {
      return compileSnippet2(snippetID, "");
    }

    // returns jar path
    public static File compileSnippet(String snippetID, String javaTarget) {
      return compileSnippet2(snippetID, javaTarget).a;
    }

    // returns jar path, Java source
    public static Pair<File, String> compileSnippet2(String snippetID, String javaTarget) {
      String transpiledSrc = getServerTranspiled2(snippetID);
      int i = transpiledSrc.indexOf('\n');
      String libs = transpiledSrc.substring(0, Math.max(0, i));
      if (verbose)
        print("Compiling snippet: " + snippetID + ". Libs: " + libs);
      transpiledSrc = transpiledSrc.substring(i + 1);
      return pair(compile(transpiledSrc, libs, javaTarget, snippetID), transpiledSrc);
    }

    public static File compile(String src) {
      return compile(src, "");
    }

    public static File compile(String src, String libs) {
      return compile(src, libs, null);
    }

    public static File compile(String src, String dehlibs, String javaTarget) {
      return compile(src, dehlibs, javaTarget, null);
    }

    public static File compile(String src, String dehlibs, String javaTarget, String progID) {
      if (verbose)
        print("Compiling " + l(src) + " chars");
      // Note: This is different from the calculation in x30
      // (might lead to programs being compiled twice)
      String md5 = md5(dehlibs + "\n" + src + "\n" + progID);
      File jar = getJarFile(md5);
      if (jar == null || jar.length() <= 22) {
        // have to compile
        boolean canRename = useDummyMainClasses() && isSnippetID(progID) && !tok_classHasModifier(findMainClass(javaTok(src)), "public");
        if (verbose)
          print("useRenaming: " + useDummyMainClasses() + ", canRename: " + canRename + ", progID: " + progID);
        if (canRename)
          javaCompileToJar_rename(src, dehlibs, jar, progID);
        else
          javaCompileToJar_standard(src, dehlibs, jar);
      } else {
        if (verbose)
          print("Getting classes from cache (" + jar.getAbsolutePath() + ", " + jar.length() + " bytes)");
        // so we can find the unused ones easier
        touchFile(jar);
      }
      return jar;
    }

    public static File getJarFile(String md5) {
      assertTrue(isMD5(md5));
      return new File(getCacheProgramDir("#1002203"), md5 + ".jar");
    }
  }

  public static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

  public static class DynamicObject {

    // just the name, without the "main$"
    public String className;

    public LinkedHashMap<String, Object> fieldValues = new LinkedHashMap();

    public DynamicObject() {
    }

    // className = just the name, without the "main$"
    public DynamicObject(String className) {
      this.className = className;
    }
  }

  public static class Pair<A, B> {

    public A a;

    public B b;

    public Pair() {
    }

    public Pair(A a, B b) {
      this.b = b;
      this.a = a;
    }

    public int hashCode() {
      return hashCodeFor(a) + 2 * hashCodeFor(b);
    }

    public boolean equals(Object o) {
      if (o == this)
        return true;
      if (!(o instanceof Pair))
        return false;
      Pair t = (Pair) o;
      return eq(a, t.a) && eq(b, t.b);
    }

    public String toString() {
      return "<" + a + ", " + b + ">";
    }
  }

  public static class Var<A> implements IVar<A> {

    // you can access this directly if you use one thread
    public A v;

    public Var() {
    }

    public Var(A v) {
      this.v = v;
    }

    public synchronized void set(A a) {
      if (v != a) {
        v = a;
        notifyAll();
      }
    }

    public synchronized A get() {
      return v;
    }

    public synchronized boolean has() {
      return v != null;
    }

    public synchronized void clear() {
      v = null;
    }

    public String toString() {
      return str(get());
    }
  }

  // a Lisp-like form
  public static class Lisp implements Iterable<Lisp> {

    public String head;

    public List<Lisp> args = new ArrayList();

    public Lisp() {
    }

    public Lisp(String head) {
      this.head = head;
    }

    public Lisp(String head, Lisp... args) {
      this.head = head;
      this.args.addAll(asList(args));
    }

    public Lisp(String head, Collection args) {
      this.head = head;
      for (Object arg : args) add(arg);
    }

    // INEFFICIENT
    public String toString() {
      if (args.isEmpty())
        return quoteIfNotIdentifierOrInteger(head);
      List<String> bla = new ArrayList();
      for (Lisp a : args) bla.add(a.toString());
      String inner = join(", ", bla);
      if (head.equals(""))
        // list
        return "{" + inner + "}";
      else
        return quoteIfNotIdentifier(head) + "(" + inner + ")";
    }

    public String raw() {
      if (!isEmpty())
        throw fail("not raw: " + this);
      return head;
    }

    public Lisp add(Lisp l) {
      args.add(l);
      return this;
    }

    public Lisp add(String s) {
      args.add(new Lisp(s));
      return this;
    }

    public Lisp add(Object o) {
      if (o instanceof Lisp)
        add((Lisp) o);
      else if (o instanceof String)
        add((String) o);
      else
        throw fail("Bad argument type: " + structure(o));
      return this;
    }

    public int size() {
      return args.size();
    }

    public boolean empty() {
      return args.isEmpty();
    }

    public boolean isEmpty() {
      return args.isEmpty();
    }

    public boolean isLeaf() {
      return args.isEmpty();
    }

    public Lisp get(int i) {
      return main.get(args, i);
    }

    public String getString(int i) {
      Lisp a = get(i);
      return a == null ? null : a.head;
    }

    public String s(int i) {
      return getString(i);
    }

    public String rawOrNull(int i) {
      Lisp a = get(i);
      return a != null && a.isLeaf() ? a.head : null;
    }

    public String raw(int i) {
      return assertNotNull(rawOrNull(i));
    }

    public boolean isLeaf(int i) {
      return rawOrNull(i) != null;
    }

    public boolean isA(String head) {
      return eq(head, this.head);
    }

    public boolean is(String head, int size) {
      return isA(head) && size() == size;
    }

    public boolean is(String head) {
      return isA(head);
    }

    public boolean headIs(String head) {
      return isA(head);
    }

    public boolean is(String... heads) {
      return asList(heads).contains(head);
    }

    // check head for one of these (ignore case)
    public boolean isic(String... heads) {
      return containsIgnoreCase(heads, head);
    }

    public Iterator<Lisp> iterator() {
      return args.iterator();
    }

    public Lisp subList(int fromIndex, int toIndex) {
      Lisp l = new Lisp(head);
      // better to copy here I guess - safe
      l.args.addAll(args.subList(fromIndex, toIndex));
      return l;
    }

    public boolean equals(Object o) {
      if (o == null || o.getClass() != Lisp.class)
        return false;
      Lisp l = (Lisp) (o);
      return eq(head, l.head) && eq(args, l.args);
    }

    public int hashCode() {
      return head.hashCode() + args.hashCode();
    }

    public Lisp addAll(List args) {
      for (Object arg : args) add(arg);
      return this;
    }

    public String unquoted() {
      return unquote(raw());
    }

    public String unq() {
      return unquoted();
    }

    public String unq(int i) {
      return get(i).unq();
    }

    // heads of arguments
    public List<String> heads() {
      return collect(args, "head");
    }
  }

  public static class Matches {

    public String[] m;

    public Matches() {
    }

    public Matches(String... m) {
      this.m = m;
    }

    public String get(int i) {
      return i < m.length ? m[i] : null;
    }

    public String unq(int i) {
      return unquote(get(i));
    }

    public String fsi(int i) {
      return formatSnippetID(unq(i));
    }

    public String fsi() {
      return fsi(0);
    }

    public String tlc(int i) {
      return unq(i).toLowerCase();
    }

    public boolean bool(int i) {
      return "true".equals(unq(i));
    }

    // for matchStart
    public String rest() {
      return m[m.length - 1];
    }

    public int psi(int i) {
      return Integer.parseInt(unq(i));
    }
  }

  public static String quoteIfNotIdentifier(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) ? s : quote(s);
  }

  public static String getServerTranspiled2(String id) {
    String transpiled = loadCachedTranspilation(id);
    String md5 = null;
    if (isOfflineMode())
      return transpiled;
    if (transpiled != null)
      md5 = md5(transpiled);
    String transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
    if (eq(transpiledSrc, "SAME")) {
      if (!isTrue(loadPage_silent.get()))
        print("SAME");
      return transpiled;
    }
    return transpiledSrc;
  }

  // returns actual CNC
  public static List<String> findMainClass(List<String> tok) {
    for (List<String> c : reversedList(allClasses(tok))) {
      String name = getClassDeclarationName(c);
      if (eq(name, "main") || name.startsWith("x"))
        return c;
    }
    return findBlock("m {", tok);
  }

  public static <A> void addAll(Collection<A> c, Collection<A> b) {
    if (c != null && b != null)
      c.addAll(b);
  }

  public static <A> void addAll(Collection<A> c, A... b) {
    if (c != null)
      c.addAll(Arrays.asList(b));
  }

  public static File javaCompileToJar_rename(String src, File destJar, String progID) {
    return javaCompileToJar_rename(src, "", destJar, progID);
  }

  // returns path to jar
  public static synchronized File javaCompileToJar_rename(String src, String dehlibs, File destJar, String progID) {
    // use default target
    String javaTarget = null;
    print("Compiling " + l(src) + " chars");
    String dummyClass = dummyMainClassName(progID);
    src += "\nclass " + dummyClass + "{}";
    String md5 = md5(src);
    File jar = destJar;
    Class j = getJavaX();
    if (javaTarget != null)
      setOpt(j, "javaTarget", javaTarget);
    //setOpt(j, "verbose", true);
    File srcDir = (File) (call(j, "TempDirMaker_make"));
    String className = "main";
    String fileName = dummyClass + ".java";
    File mainJava = new File(srcDir, fileName);
    //print("main java: " + mainJava.getAbsolutePath());
    saveTextFile(mainJava, src);
    File classesDir = (File) call(j, "TempDirMaker_make");
    List<File> libraries = new ArrayList();
    Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
    while (m.find()) {
      String libID = m.group();
      //print("libID=" + quote(libID));
      assertTrue(isSnippetID(libID));
      libraries.add(loadLibrary(libID));
    }
    String compilerOutput;
    try {
      compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
    } catch (Throwable e) {
      compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
      throw fail("Compile Error. " + compilerOutput + " " + e);
    }
    if (nempty(compilerOutput)) {
      print("Compiler said: " + compilerOutput);
    //fail("Compile Error. " + compilerOutput);
    }
    // sanity test
    if (!new File(classesDir, className + ".class").exists())
      throw fail("No class generated (" + className + ")");
    // add sources to .jar
    saveTextFile(new File(classesDir, "main.java"), src);
    // add information about libraries to jar
    if (nempty(dehlibs))
      saveTextFile(new File(classesDir, "libraries"), dehlibs);
    //print("Zipping: " + classesDir.getAbsolutePath() + " to " + jar.getAbsolutePath());
    dir2zip_recurse_verbose = false;
    // cache on success only
    int n = dir2zip_recurse(classesDir, jar);
    return jar;
  }

  public static String getString(Map map, Object key) {
    return map == null ? null : (String) map.get(key);
  }

  public static String getString(List l, int idx) {
    return (String) get(l, idx);
  }

  public static String getString(Object o, Object key) {
    if (o instanceof Map)
      return getString((Map) o, key);
    if (key instanceof String)
      return (String) getOpt(o, (String) key);
    throw fail("Not a string key: " + getClassName(key));
  }

  public static <A, B> Pair<A, B> pair(A a, B b) {
    return new Pair(a, b);
  }

  // will create the file or update its last modified timestamp
  public static void touchFile(File file) {
    try {
      closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean tok_classHasModifier(List<String> classDecl, String modifier) {
    int i = classDecl.indexOf("class");
    return subList(classDecl, 0, i).contains(modifier);
  }

  public static int hashCodeFor(Object a) {
    return a == null ? 0 : a.hashCode();
  }

  public static boolean useDummyMainClasses() {
    return eq("1", trim(loadTextFile(getProgramFile("#1008755", "use-dummy-main-classes"))));
  }

  public static String fsi(String id) {
    return formatSnippetID(id);
  }

  public static File getCacheProgramDir() {
    return getCacheProgramDir(getProgramID());
  }

  public static File getCacheProgramDir(String snippetID) {
    return new File(userHome(), "JavaX-Caches/" + formatSnippetIDOpt(snippetID));
  }

  public static String quoteIfNotIdentifierOrInteger(String s) {
    if (s == null)
      return null;
    return isJavaIdentifier(s) || isInteger(s) ? s : quote(s);
  }

  public static boolean equals(Object a, Object b) {
    return a == null ? b == null : a.equals(b);
  }

  public static String md5(String text) {
    try {
      if (text == null)
        return "-";
      // maybe different than the way PHP does it...
      return bytesToHex(md5_impl(text.getBytes("UTF-8")));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String md5(byte[] data) {
    if (data == null)
      return "-";
    return bytesToHex(md5_impl(data));
  }

  public static MessageDigest md5_md;

  /*static byte[] md5_impl(byte[] data) ctex {
  if (md5_md == null)
    md5_md = MessageDigest.getInstance("MD5");
  return ((MessageDigest) md5_md.clone()).digest(data);
}*/
  public static byte[] md5_impl(byte[] data) {
    try {
      return MessageDigest.getInstance("MD5").digest(data);
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String md5(File file) {
    try {
      return md5(loadBinaryFile(file));
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static boolean isMD5(String s) {
    return l(s) == 32 && isLowerHexString(s);
  }

  public static File javaCompileToJar_standard(String src, File destJar) {
    return javaCompileToJar_standard(src, "", destJar);
  }

  // returns path to jar
  public static synchronized File javaCompileToJar_standard(String src, String dehlibs, File destJar) {
    // use default target
    String javaTarget = null;
    print("Compiling " + l(src) + " chars");
    String md5 = md5(src);
    File jar = destJar;
    Class j = getJavaX();
    if (javaTarget != null)
      setOpt(j, "javaTarget", javaTarget);
    //setOpt(j, "verbose", true);
    File srcDir = (File) (call(j, "TempDirMaker_make"));
    String className = "main";
    String fileName = className + ".java";
    File mainJava = new File(srcDir, fileName);
    //print("main java: " + mainJava.getAbsolutePath());
    saveTextFile(mainJava, src);
    File classesDir = (File) call(j, "TempDirMaker_make");
    List<File> libraries = new ArrayList();
    Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
    while (m.find()) {
      String libID = m.group();
      //print("libID=" + quote(libID));
      assertTrue(isSnippetID(libID));
      libraries.add(loadLibrary(libID));
    }
    String compilerOutput;
    try {
      compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
    } catch (Throwable e) {
      compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
      throw fail("Compile Error. " + compilerOutput + " " + e);
    }
    if (nempty(compilerOutput)) {
      print("Compiler said: " + compilerOutput);
    //fail("Compile Error. " + compilerOutput);
    }
    // sanity test
    if (!new File(classesDir, className + ".class").exists())
      throw fail("No class generated (" + className + ")");
    // add sources to .jar
    saveTextFile(new File(classesDir, "main.java"), src);
    // add information about libraries to jar
    if (nempty(dehlibs))
      saveTextFile(new File(classesDir, "libraries"), dehlibs);
    //print("Zipping: " + classesDir.getAbsolutePath() + " to " + jar.getAbsolutePath());
    dir2zip_recurse_verbose = false;
    // cache on success only
    int n = dir2zip_recurse(classesDir, jar);
    return jar;
  }

  public static boolean isLowerHexString(String s) {
    for (int i = 0; i < l(s); i++) {
      char c = s.charAt(i);
      if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      // ok
      } else
        return false;
    }
    return true;
  }

  public static String getClassDeclarationName(List<String> c) {
    if (c != null)
      for (int i = 1; i + 2 < c.size(); i += 2) if (eqOneOf(c.get(i), "class", "interface", "enum"))
        return c.get(i + 2);
    return null;
  }

  public static List<String> findBlock(String pat, List<String> tok) {
    List<String> tokpat = javaTok(pat);
    int i = findCodeTokens(tok, toStringArray(codeTokensOnly(tokpat)));
    //print("index of block " + quote(pat) + ": " + i);
    if (i < 0)
      return null;
    int bracketIdx = i + tokpat.size() - 3;
    assertEquals("{", tok.get(bracketIdx));
    int endIdx = findEndOfBlock(tok, bracketIdx);
    // make it actual CNC
    return subList(tok, i - 1, endIdx + 1);
  }

  public static <A> List<A> reversedList(Collection<A> l) {
    List<A> x = cloneList(l);
    Collections.reverse(x);
    return x;
  }

  public static boolean dir2zip_recurse_verbose;

  public static int dir2zip_recurse(File inDir, File zip) {
    return dir2zip_recurse(inDir, zip, "");
  }

  // TODO: the zero files case?
  public static int dir2zip_recurse(File inDir, File zip, String outPrefix) {
    try {
      mkdirsForFile(zip);
      FileOutputStream fout = newFileOutputStream(zip);
      ZipOutputStream outZip = new ZipOutputStream(fout);
      try {
        return dir2zip_recurse(inDir, outZip, outPrefix, 0);
      } finally {
        outZip.close();
      }
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) {
    try {
      if (++level >= 20)
        throw fail("woot? 20 levels in zip?");
      List<File> files = new ArrayList();
      for (File f : listFiles(inDir)) files.add(f);
      int n = 0;
      sortFilesByName(files);
      for (File f : files) {
        if (f.isDirectory()) {
          print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
          n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
        } else {
          if (dir2zip_recurse_verbose)
            print("Copying " + f.getName());
          outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
          InputStream fin = new FileInputStream(f);
          copyStream(fin, outZip);
          fin.close();
          ++n;
        }
      }
      return n;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static void closeRandomAccessFile(RandomAccessFile f) {
    if (f != null)
      try {
        f.close();
        callJavaX("dropIO", f);
      } catch (Throwable e) {
        printStackTrace(e);
      }
  }

  // lists returned are actual CNC (N/C/N/.../C/N) - and connected to
  // original list
  // only returns the top level classes
  public static List<List<String>> allClasses(List<String> tok) {
    List<List<String>> l = new ArrayList();
    for (int i = 1; i < tok.size(); i += 2) {
      if (// skip functions
      eq(tok.get(i), "{"))
        i = findEndOfBlock(tok, i) - 1;
      else if (eqOneOf(tok.get(i), "class", "interface", "enum") && (i == 1 || !tok.get(i - 2).equals("."))) {
        int j = i;
        while (j < tok.size() && !tok.get(j).equals("{")) j += 2;
        j = findEndOfBlock(tok, j) + 1;
        i = leftScanModifiers(tok, i);
        l.add(tok.subList(i - 1, Math.min(tok.size(), j)));
        i = j - 2;
      }
    }
    return l;
  }

  public static List<List<String>> allClasses(String text) {
    return allClasses(javaTok(text));
  }

  public static String getServerTranspiled(String snippetID) {
    return getServerTranspiled(snippetID, null);
  }

  // returns "SAME" if md5 matches
  public static String getServerTranspiled(String snippetID, String expectedMD5) {
    try {
      long id = parseSnippetID(snippetID);
      /*S t = getTranspilationFromBossBot(id);
  if (t != null) return t;*/
      String text = loadPage_utf8(tb_mainServer() + "/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1" + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "") + standardCredentials());
      if (nempty(text) && neq(text, "SAME"))
        saveTranspiledCode(snippetID, text);
      return text;
    } catch (Exception __e) {
      throw rethrow(__e);
    }
  }

  public static String loadCachedTranspilation(String id) {
    return loadTextFile(new File(getCodeProgramDir(id), "Transpilation"));
  }

  public static RandomAccessFile newRandomAccessFile(File path, String mode) throws IOException {
    RandomAccessFile f = new RandomAccessFile(path, mode);
    callJavaX("registerIO", f, path, mode.indexOf('w') >= 0);
    return f;
  }

  public static boolean isOfflineMode() {
    return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
  }

  public static byte[] loadBinaryFile(String fileName) {
    try {
      if (!new File(fileName).exists())
        return null;
      FileInputStream in = new FileInputStream(fileName);
      byte[] buf = new byte[1024];
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      int l;
      while (true) {
        l = in.read(buf);
        if (l <= 0)
          break;
        out.write(buf, 0, l);
      }
      in.close();
      return out.toByteArray();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public static byte[] loadBinaryFile(File file) {
    return loadBinaryFile(file.getPath());
  }

  public static String dummyMainClassName(String progID) {
    return "m" + psI(progID);
  }

  public static String loadPage_utf8(URL url) {
    return loadPage_utf8(url.toString());
  }

  public static String loadPage_utf8(String url) {
    loadPage_charset.set("UTF-8");
    try {
      return loadPage(url);
    } finally {
      loadPage_charset.set(null);
    }
  }

  public static String standardCredentials() {
    String user = standardCredentialsUser();
    String pass = standardCredentialsPass();
    if (nempty(user) && nempty(pass))
      return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
    return "";
  }

  public static String[] toStringArray(Collection<String> c) {
    String[] a = new String[l(c)];
    Iterator<String> it = c.iterator();
    for (int i = 0; i < l(a); i++) a[i] = it.next();
    return a;
  }

  public static String[] toStringArray(Object o) {
    if (o instanceof String[])
      return (String[]) o;
    else if (o instanceof Collection)
      return toStringArray((Collection<String>) o);
    else
      throw fail("Not a collection or array: " + getClassName(o));
  }

  public static void saveTranspiledCode(String progID, String code) {
    saveTextFile(new File(getCodeProgramDir(progID), "Transpilation"), code);
  }

  public static File getCodeProgramDir() {
    return getCodeProgramDir(getProgramID());
  }

  public static File getCodeProgramDir(String snippetID) {
    return new File(javaxCodeDir(), formatSnippetID(snippetID));
  }

  public static File getCodeProgramDir(long snippetID) {
    return getCodeProgramDir(formatSnippetID(snippetID));
  }

  public static String loadProgramTextFile(String name) {
    return loadTextFile(getProgramFile(name));
  }

  public static String loadProgramTextFile(String progID, String name) {
    return loadTextFile(getProgramFile(progID, name));
  }

  public static String loadProgramTextFile(String progID, String name, String defaultText) {
    return loadTextFile(getProgramFile(progID, name), defaultText);
  }

  public static String urlencode(String x) {
    try {
      return URLEncoder.encode(unnull(x), "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  public static int leftScanModifiers(List<String> tok, int i) {
    List<String> mod = getJavaModifiers();
    while (i > 1 && mod.contains(tok.get(i - 2))) i -= 2;
    return i;
  }

  public static List<String> codeTokensOnly(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 1; i < tok.size(); i += 2) l.add(tok.get(i));
    return l;
  }

  public static <A> List<A> cloneList(Collection<A> l) {
    if (l == null)
      return new ArrayList();
    // assume collection's mutex is equal to collection, which will be true unless you explicitly pass a mutex to synchronizedList() which no one ever does.
    synchronized (l) {
      return new ArrayList<A>(l);
    }
  }

  public static void sortFilesByName(List<File> l) {
    sort(l, new Comparator<File>() {

      public int compare(File a, File b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
  }

  public static int findCodeTokens(List<String> tok, String... tokens) {
    return findCodeTokens(tok, 1, false, tokens);
  }

  public static int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, 1, ignoreCase, tokens);
  }

  public static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
    return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
  }

  public static List<String> findCodeTokens_specials = litlist("*", "<quoted>", "<id>", "<int>", "\\*");

  public static boolean findCodeTokens_debug;

  public static int findCodeTokens_indexed, findCodeTokens_unindexed;

  public static int findCodeTokens_bails, findCodeTokens_nonbails;

  public static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
    if (findCodeTokens_debug) {
      if (eq(getClassName(tok), "main$IndexedList2"))
        findCodeTokens_indexed++;
      else
        findCodeTokens_unindexed++;
    }
    // bail out early if first token not found (works great with IndexedList)
    if (!findCodeTokens_specials.contains(tokens[0]) && !tok.contains(tokens[0])) {
      ++findCodeTokens_bails;
      return -1;
    }
    ++findCodeTokens_nonbails;
    outer: for (int i = startIdx | 1; i + tokens.length * 2 - 2 < tok.size(); i += 2) {
      for (int j = 0; j < tokens.length; j++) {
        String p = tokens[j], t = tok.get(i + j * 2);
        boolean match;
        if (eq(p, "*"))
          match = true;
        else if (eq(p, "<quoted>"))
          match = isQuoted(t);
        else if (eq(p, "<id>"))
          match = isIdentifier(t);
        else if (eq(p, "<int>"))
          match = isInteger(t);
        else if (eq(p, "\\*"))
          match = eq("*", t);
        else
          match = ignoreCase ? eqic(p, t) : eq(p, t);
        if (!match)
          continue outer;
      }
      if (// pass N index
      condition == null || checkCondition(condition, tok, i - 1))
        return i;
    }
    return -1;
  }

  public static File[] listFiles(File dir) {
    File[] files = dir.listFiles();
    return files == null ? new File[0] : files;
  }

  public static File[] listFiles(String dir) {
    return listFiles(new File(dir));
  }

  // i must point at the (possibly imaginary) opening bracket ("{")
  // index returned is index of closing bracket + 1
  public static int findEndOfBlock(List<String> cnc, int i) {
    int j = i + 2, level = 1;
    while (j < cnc.size()) {
      if (cnc.get(j).equals("{"))
        ++level;
      else if (cnc.get(j).equals("}"))
        --level;
      if (level == 0)
        return j + 1;
      ++j;
    }
    return cnc.size();
  }

  // supports the usual quotings (', ", variable length double brackets)
  public static boolean isQuoted(String s) {
    if (startsWith(s, "'") || startsWith(s, "\""))
      return true;
    return isMultilineQuoted(s);
  }

  public static boolean checkCondition(Object condition, Object... args) {
    return isTrue(callF(condition, args));
  }

  // can be set to work on different base dir
  public static File javaxCodeDir_dir;

  public static File javaxCodeDir() {
    return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
  }

  public static String standardCredentialsUser() {
    return trim(loadTextFile(new File(userHome(), ".tinybrain/username")));
  }

  public static boolean isIdentifier(String s) {
    return isJavaIdentifier(s);
  }

  public static List<String> getJavaModifiers_list = litlist("static", "abstract", "public", "private", "protected", "final", "native", "volatile", "synchronized", "transient");

  public static List<String> getJavaModifiers() {
    return getJavaModifiers_list;
  }

  public static <T> void sort(T[] a, Comparator<? super T> c) {
    Arrays.sort(a, c);
  }

  public static <T> void sort(T[] a) {
    Arrays.sort(a);
  }

  public static <T> void sort(List<T> a, Comparator<? super T> c) {
    Collections.sort(a, c);
  }

  public static void sort(List a) {
    Collections.sort(a);
  }

  public static String standardCredentialsPass() {
    return trim(loadTextFile(new File(userHome(), ".tinybrain/userpass")));
  }

  public static boolean isMultilineQuoted(String s) {
    if (!startsWith(s, "["))
      return false;
    int i = 1;
    while (i < s.length() && s.charAt(i) == '=') ++i;
    return i < s.length() && s.charAt(i) == '[';
  }

  public static interface IVar<A> {

    public void set(A a);

    public A get();

    public boolean has();

    public void clear();
  }

  public static class JavaXClassLoader extends URLClassLoader {

    public String progID;

    public List<File> files;

    public Set<Class> loadedClasses = synchroSet();

    public JavaXClassLoader(String progID, List<File> files) {
      this(progID, files, null);
    }

    public JavaXClassLoader(String progID, List<File> files, ClassLoader parent) {
      super(new URL[0], parent);
      this.progID = progID;
      this.files = files;
      {
        try {
          for (File f : files) addURL(f.toURI().toURL());
        } catch (Exception __e) {
          throw rethrow(__e);
        }
      }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
      try {
        Class<?> c = super.findClass(name);
        loadedClasses.add(c);
        if (eq(name, "main"))
          callOpt(javax(), "registerAMainClass", c);
        return c;
      } catch (ClassNotFoundException e) {
        throw new ClassNotFoundException("Class " + name + " not found in " + joinWithComma(map("f2s", files)) + " (progID=" + progID + ")");
      }
    }
  }

  public static String joinWithComma(Collection<String> c) {
    return join(", ", c);
  }

  public static String joinWithComma(String... c) {
    return join(", ", c);
  }

  public static <A> Set<A> synchroSet() {
    return synchroHashSet();
  }

  public static <A> Set<A> synchroHashSet() {
    return Collections.synchronizedSet(new HashSet<A>());
  }
}
