
import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
import java.awt.datatransfer.StringSelection;
import javax.swing.undo.UndoManager;
import org.pushingpixels.substance.api.*;
import org.pushingpixels.substance.api.skin.*;
class main {


static int perPage = 8;
static List<String> guessPrograms = ll("#1008721", "#1008696", "#1008704", "#1008723");

static SingleComponentPanel scp;
static JTextArea detailTextArea;
static int startIndex;
static List guessModules = new ArrayList();
static ReliableSingleThread relearnThread = new ReliableSingleThread("relearn");
static TreeSet<String> keys = new TreeSet();

static class Sentence extends Concept {
  static String _fieldOrder = "text data";
  String text;
  Map<String,String> data = new HashMap();
  
  String getPart(IntRange r) { return substring(text, r); }
}

public static void main(final String[] args) throws Exception { { swingAndWait(new Runnable() { public void run() { try {  substance();
  { Thread _t_0 = new Thread() {
public void run() { try {
    db(); 
    indexConceptField(Sentence.class, "text");
    gatherKeys();
    List<String> sentences = toLinesFullTrim(loadSnippet("#1008606"));
    sentences = notStartingWith("\"", sentences);
    { long _startTime_0 = sysNow(); try {   makeUniqueConcepts(Sentence.class, "text", sentences); } finally { _startTime_0 = sysNow()-_startTime_0; saveTiming(_startTime_0); } }
    for (String id : guessPrograms)
      try { guessModules.add(runDependent(id)); } catch (Throwable __e) { printStackTrace2(__e); }
   swingLater(new Runnable() { public void run() { try { 
  JSplitPane split;
  showFrame(centerAndSouth(
    split = jvsplit(
      scp = new SingleComponentPanel(),
      detailTextArea = jtypewritertextarea()),
    withTopMargin(20, jcenteredline(
      textActionButton("Mark as...", "mark"),
      jbutton("Prev", new Runnable() { public void run() { try {  makePanel(max(startIndex-perPage, 0)) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "makePanel(max(startIndex-perPage, 0))"; }}),
      jbutton("Next", "nextPage"),
      jbutton("Random", new Runnable() { public void run() { try {  makePanel(random(countConcepts(Sentence.class))/perPage*perPage) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "makePanel(random(countConcepts(Sentence.class))/perPage*perPage)"; }}),
      jbutton("All OK", new Runnable() { public void run() { try {  clickButtons(findButtons(scp, "OK")); nextPage(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "clickButtons(findButtons(scp, \"OK\")); nextPage();"; }}),
      jbutton("Add sentence...", "addSentence")))));
  addMenu(scp, "Actions",
    "Rename key...", "renameKey",
    "Load sentences from web bot...", "fromWebBot",
    "Load text2tag snippet...", "loadText2Tag",
    "Apply splittings", "applySplittings");
  setFrameSize(scp, 1000, 600);
  setSplitPaneLater(split, 0.8); // try it again
  centerFrame(scp);
  makePanel(0);

} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "JSplitPane split;\n  showFrame(centerAndSouth(\n    split = jvsplit(\n      scp = n..."; }});} catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_0); }
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "substance();\n  thread {\n    db(); \n    indexConceptField(Sentence.class, \"text\")..."; }}); }}

static void makePanel(int startIndex) {
  main.startIndex = startIndex;
  makePanel();
}

static void makePanel() {
  JPanel panel = gridLayoutPanel_trackWidth_evenlySpacedCols(2);
  panel.add(jlabel("Sentence"));
  panel.add(jlabel("Analysis"));
  for (final Sentence s : takeFirst(perPage, dropFirst(startIndex, orderByFieldDesc("created", list(Sentence.class))))) {
    final JTextField tfText = jtextfield_caretLeft(s.text);
    tfText.setCaret(new DefaultCaret() {
      @Override
      public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
      }
    });
    panel.add(tfText);

    final JTextField tf = jtextfield_caretLeft(dataMapToString(s.data));
    onFocus(tf, new Runnable() { public void run() { try {  updateDetail(tf) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "updateDetail(tf)"; }});
    final JTextField tfGuess = jtextfield_caretLeft(dataMapToString(makeGuess(s.text)));
    onFocus(tfGuess, new Runnable() { public void run() { try {  updateDetail(tfGuess) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "updateDetail(tfGuess)"; }});
    
    final Var<JButton> reviseBtn = new Var(), okBtn = new Var();
    okBtn.set(jbutton("OK", new Runnable() { public void run() { try { 
      try {
        cset(s, "data" , dataMapFromString(getTextTrim(tf)));
        disableTextField(tf);
        replaceComponent(okBtn.get(), reviseBtn.get());
        relearnThread.trigger();
      } catch (Throwable __e) { messageBox(__e); }
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "pcall-messagebox {\n        cset(s, \"data\" , dataMapFromString(getTextTrim(tf)));..."; }}));
    reviseBtn.set(jbutton("Revise", new Runnable() { public void run() { try { 
      cset(s, "data" , new HashMap());
      enableTextField(tf);
      replaceComponent(reviseBtn.get(), okBtn.get());
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "cset(s, \"data\" , new HashMap);\n      enableTextField(tf);\n      replaceComponent..."; }}));
    onUpdateAndNow(tf, new Runnable() { public void run() { try {  okBtn.get().setEnabled(nempty(getTextTrim(tf))) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "okBtn.get().setEnabled(nempty(getTextTrim(tf)))"; }});
    
    boolean hasData = nempty(s.data);
    if (hasData) disableTextField(tf);
    panel.add(vstack(
      centerAndEast(withLabel("Saved:", tf), hasData ? reviseBtn.get() : okBtn.get()),
      centerAndEast(withLabel("Guess:", tfGuess), jbutton("OK", new Runnable() { public void run() { try { 
        try {
          s.data.putAll(dataMapFromString(getTextTrim(tfGuess)));
          s.change();
          disableTextField(tf);
          replaceComponent(okBtn.get(), reviseBtn.get());
          relearnThread.trigger();
        } catch (Throwable __e) { messageBox(__e); }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "pcall-messagebox {\n          s.data.putAll(dataMapFromString(getTextTrim(tfGuess..."; }}))));
  }
  scp.setComponent(jscroll(panel));
}

static void relearn() {
  for (Object guessModule : guessModules) try { callMain(guessModule); } catch (Throwable __e) { printStackTrace2(__e); }
  { swingAndWait(new Runnable() { public void run() { try {  makePanel(); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "makePanel();"; }}); }
}

static void nextPage() {
  if (startIndex+perPage < countConcepts(Sentence.class)) makePanel(startIndex+perPage);
}

static String dataMapToString(Map<String, String> data) {
  return dataMapToString(data, ". ");
}

static String dataMapToString(Map<String, String> data, String glue) {
  return join(glue, mapMapToList(withoutNulls(data), new Object() { Object get(String a, String b) { try { return 
    a + "=" + b ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "a + \"=\" + b"; }}));
}

static Map<String, String> dataMapFromString(String input) {
  Map<String,String> data = new HashMap();
  for (String s : trimAll(splitByJavaToken(input, "."))) {
    List<String> tok = javaTok(s);
    int i = tok.indexOf("=");
    if (i < 0) continue;
    data.put(trimJoinSubList(tok, 0, i), trimJoinSubList(tok, i+1));
  }
  return data;
}

static Map<String, String> makeGuess(String sentence) {
  Map<String,String> data = new HashMap();
  for (Object guessModule : guessModules)
    if (hasMethodNamed(guessModule, "guess"))
      pcall(guessModule, "guess", sentence, data); // new way
    else
      pcall(guessModule, "callGuesser", get(guessModule, "best"), sentence, data);
  return data;
}

static void mark(JTextComponent c) {
  final IntRange r = textComponentSelection(c);
  final String selection = c.getSelectedText();
  final String text = c.getText();
  //final JTextField tf = jtextfield("verb");
  final AutoComboBox cb = autoComboBox(keys);
  showFormTitled("Mark sentence part",
    "Text", selection + " (" + r.start + "/" + r.length() + ")",
    "Mark as", cb,
    new Object() { Object get() { try { 
      try {
        String as = getTextTrim(cb);
        Sentence s = findConcept(Sentence.class, "text", text);
        s.data.put(as, ai_renderAction(text, r));
        s.change();
        gatherKeys(s);
        relearnThread.trigger();
        return null;
      } catch (Throwable __e) { infoBox(__e); }
      return false;
     } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "pcall-infobox {\n        S as = getTextTrim(cb);\n        Sentence s = findConcept..."; }});
}

static void addSentence() {
  final JTextField tf = jtextfield();
  showFormTitled("Add sentence", "Sentence", tf, new Runnable() { public void run() { try { 
    uniq(Sentence.class, "text" , getTextTrim(tf));
    makePanel(0);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "uniq(Sentence.class, \"text\" , getTextTrim(tf));\n    makePanel(0);"; }});
}

static void renameKey() {
  final AutoComboBox tf1 = autoComboBox(keys);
  final JTextField tf2 = jtextfield();
  showFormTitled("Rename key",
    "Old key name", tf1,
    "New key name", tf2,
    new Runnable() { public void run() { try { 
      String oldKey = getTextTrim(tf1);
      String newKey = getTextTrim(tf2);
      int n = 0;
      for (Sentence s : list(Sentence.class)) {
        String value = s.data.get(oldKey);
        if (value != null) {
          s.data.remove(oldKey);
          s.data.put(newKey, value);
          s.change();
          ++n;
        }
      }
      infoBox(n(n, "changes") + " made");
      keys.clear(); gatherKeys();
      makePanel();
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "String oldKey = getTextTrim(tf1);\n      String newKey = getTextTrim(tf2);\n      ..."; }});
}

static void gatherKeys() {
  keys.clear();
  for (Sentence s : list(Sentence.class)) gatherKeys(s);
}

static void gatherKeys(Sentence s) {
  keys.addAll(keys(s.data));
}

static void fromWebBot() {
  final JTextField tf = jtextfield("#1008316");
  showFormTitled("Load sentences from web bot", "Chat Bot ID", tf, new Runnable() { public void run() { try { 
    Collection<String> sentences = keys(getSentencesFromWebBotLog(getTextTrim(tf)));
    makeUniqueConcepts(Sentence.class, "text", sentences);
    makePanel(0);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "Collection<String> sentences = keys(getSentencesFromWebBotLog(getTextTrim(tf)));..."; }});
}

static void loadText2Tag() {
  final JTextField tf = jtextfield("#1008363");
  showFormTitled("Load text 2 tag snippet", "Snippet ID", tf, new Runnable() { public void run() { try { 
    Pair<Map<String,String>, Map<String,String>> p = tok_dropAsterisks_pair(parseText2Tag("#1008363"));
    Collection<String> sentences = concatLists(keys(p.a), keys(p.b));
    makeUniqueConcepts(Sentence.class, "text", sentences);
    for (String tag : values(p.a)) {
      Sentence s = uniq(Sentence.class, "text" , tag);
      s.data.put("isTag", "t");
      s.change();
    }
    makePanel(0);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "Pair<Map<String, String>> p = tok_dropAsterisks_pair(parseText2Tag(\"#1008363\"));..."; }});
}

static void applySplittings() {
  boolean change = false;
  for (Sentence s : list(Sentence.class)) {
    IntRange firstPart = ai_parseAction(s.data.get("firstPart"));
    if (firstPart != null) {
      if (makeUniqueConcepts(Sentence.class, "text",
        ll(trim(s.getPart(firstPart)), trim(substring(s.text, firstPart.end))))
        != 0)
        change = true;
    }
  }
  if (change) makePanel(0);
}

static void updateDetail(JTextField tf) {
  try {
    Map<String, String> data = dataMapFromString(getTextTrim(tf));
    detailTextArea.setText(dataMapToString(data, "\n"));
  } catch (Throwable __e) { print(exceptionToStringShort(__e)); }
}


static <A> List<A> ll(A... a) {
  return litlist(a);
}
static JPanel centerAndEast(Component c, Component e) {
  JPanel panel = new JPanel(new BorderLayout());
  panel.add(BorderLayout.CENTER, wrap(c));
  panel.add(BorderLayout.EAST, wrap(e));
  return panel;
}
// action = runnable or method name
static void onUpdateAndNow(JComponent c, final Object r) {
  onUpdate(c, r);
  callF(r);
}

static void onUpdateAndNow(List<? extends JComponent> l, Object r) {
  for (JComponent c : l)
    onUpdate(c, r);
  callF(r);
}
static <A> List<A> orderByFieldDesc(Collection<A> c, final String field) {
  return sortedByFieldDesc(c, field);
}

static <A> List<A> orderByFieldDesc(String field, Collection<A> c) {
  return sortedByFieldDesc(field, c);
}
static void callMain(Object c, String... args) {
  callOpt(c, "main", new Object[] {args});
}

static void callMain() {
  callMain(mc());
}
static JPanel gridLayoutPanel_trackWidth_evenlySpacedCols(final int cols) {
  return customLayoutPanel_trackWidth(new Object() { Object get(Container parent) { try { 
    int gap = 10;
    Dimension size = parent.getSize();
    int w = max(100, size.width)-gap*2;
    int y = gap;
    List<List<Component>> rows = groupInFixedSizeRows(parent.getComponents(), cols);
    List<Integer> colWidths = new ArrayList();
    for (int i = 0; i < cols; i++)
      colWidths.add((i+1)*w/cols-i*w/cols);
      
    for (List<Component> row : rows) {
      int h = 0, x = gap;
      for (Component c : row) h = max(h, c.getPreferredSize().height);
      for (int i = 0; i < l(row); i++) {
        row.get(i).setBounds(x, y, colWidths.get(i)-gap, h);
        x += colWidths.get(i);
      }
      y += h + gap;
    }
    
    return componentsBoundingSize(parent, gap);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "int gap = 10;\r\n    Dimension size = parent.getSize();\r\n    int w = max(100, size..."; }});
}
static JScrollPane jscroll(Component c) {
  return new JScrollPane(c);
}
static AutoComboBox autoComboBox(Collection<String> items) {
  AutoComboBox cb = new AutoComboBox();
  cb.setKeyWord(items);
  return cb;
}
static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }
static Throwable pcall(Runnable r) {
  try {
    r.run();
    return null;
  } catch (Throwable e) {
    return e;
  }
}

static Object pcall(Object o, String method, Object... args) { try {
  return call(o, method, args);
} catch (Throwable __e) { return null; } }
  public static String join(String glue, Iterable<String> strings) {
    if (strings == null) return "";
    StringBuilder buf = new StringBuilder();
    Iterator<String> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext())
        buf.append(glue).append(i.next());
    }
    return buf.toString();
  }
  
  public static String join(String glue, String[] strings) {
    return join(glue, Arrays.asList(strings));
  }
  
  public static String join(Iterable<String> strings) {
    return join("", strings);
  }
  
  public static String join(String[] strings) {
    return join("", strings);
  }

public static JComponent withLabel(String label, JComponent component) {
  JPanel panel = new JPanel(new BorderLayout());
  panel.add(BorderLayout.WEST, new JLabel(label + " "));
  panel.add(BorderLayout.CENTER, component);
  return panel;
}

// f: func(key, value) -> entry
static List mapMapToList(Map map, Object f) {
  List l = new ArrayList();
  if (map != null)
    for (Map.Entry e : (Set<Map.Entry>) map.entrySet())
      l.add(callF(f, e.getKey(), e.getValue()));
  return l;
}
static <A> List<A> takeFirst(List<A> l, int n) {
  return newSubList(l, 0, n);
}

static <A> List<A> takeFirst(int n, List<A> l) {
  return takeFirst(l, n);
}

static <A> List<A> withoutNulls(List<A> l) {
  if (!containsNulls(l)) return l;
  List<A> l2 = new ArrayList();
  for (A a : l)
    if (a != null)
      l2.add(a);
  return l2;
}

static <A, B> Map<A, B> withoutNulls(Map<A, B> map) {
  Map<A, B> map2 = similarEmptyMap(map);
  for (A a : keys(map))
    if (a != null) {
      B b = map.get(a);
      if (b != null)
        map2.put(a, b);
    }
  return map2;
}
static void clickButtons(List<JButton> l) {
  for (JButton b : l)
    if (b.isEnabled())
      b.doClick();
}
static void enableTextField(JTextField tf) {
  if (tf != null) tf.setEnabled(true);
}
static JMenu addMenu(JComponent c, String menuName, Object... items) {
  return addMenu(getFrame(c), menuName, items);
}

static JMenu addMenu(final JFrame frame, final String menuName, final Object... items) {
  return (JMenu) swing(new Object() { Object get() { try { 
    JMenuBar bar = addMenuBar(frame);
    JMenu menu = getMenuNamed(bar, menuName);
    boolean isNew = menu == null;
    if (isNew)
      menu = new JMenu(menuName);
    else
      menu.removeAll();
    fillJMenu(menu, items);
    if (isNew) {
      bar.add(menu);
      revalidateFrame(frame);
    }
    return menu;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JMenuBar bar = addMenuBar(frame);\r\n    JMenu menu = getMenuNamed(bar, menuName);..."; }});
}
static IntRange textComponentSelection(JTextComponent c) {
  return new IntRange(c.getSelectionStart(), c.getSelectionEnd());
}
static JButton jbutton(String text, Object action) {
  return newButton(text, action);
}

// button without action
static JButton jbutton(String text) {
  return newButton(text, null);
}

static JButton jbutton(BufferedImage img, Object action) {
  return setButtonImage(img, jbutton("", action));
}

static JButton jbutton(Action action) {
  return new JButton(action);
}
static <A> ArrayList<A> list(A[] a) {
  return asList(a);
}

static ArrayList<Integer> list(int[] a) {
  return asList(a);
}

static <A> ArrayList<A> list(Set<A> s) {
  return asList(s);
}
static JTextField jtextfield() {
  return jTextField();
}

static JTextField jtextfield(String text) {
  return jTextField(text);
}

static JTextField jtextfield(Object o) {
  return jTextField(o);
}

static IntRange ai_parseAction(String action) { try {
  Matches m = new Matches();
  if (jmatch("* (* / *)", action, m))
    return intRangeFromStartAndLength(parseInt(m.unq(1)), parseInt(m.unq(2)));
  return null;
} catch (Throwable __e) { return null; } }
static void onFocus(JComponent c, final Object action) {
  c.addFocusListener(new FocusAdapter() {
    public void focusGained(FocusEvent evt) {
      pcallF(action);
    }
  });
}
static void disableTextField(JTextField tf) {
  if (tf != null) tf.setEnabled(false);
}
static Class<?> runDependent(String src) {
  Class c = hotwireDependent(src);
  callMain(c);
  return c;
}

static List<String> toLinesFullTrim(String s) {
  List<String> l = toLines(s);
  for (ListIterator<String> i = l.listIterator(); i.hasNext(); ) {
    String line = i.next().trim();
    if (line.length() == 0)
      i.remove();
    else
      i.set(line);
  }
  return l;
}

static List<String> toLinesFullTrim(File f) {
  return toLinesFullTrim(loadTextFile(f));
}

static JPanel vstack(Object... parts) {
  return vstack2(parts);
}

static JPanel vstack(List parts) {
  return vstack(toObjectArray(parts));
}
  static <A> List<A> concatLists(Collection<A>... lists) {
    List<A> l = new ArrayList();
    for (Collection<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

  static <A> List<A> concatLists(Collection<List<A>> lists) {
    List<A> l = new ArrayList();
    for (List<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

static <A extends Concept> A uniq(Class<A> c, Object... params) {
  return uniqueConcept(c, params);
}
static JTextArea jtypewritertextarea() {
  return newTypeWriterTextArea();
}

static JTextArea jtypewritertextarea(String text) {
  return newTypeWriterTextArea(text);
}
// makeNewComponent: func(Component) -> Component
//                   or Component
static Component replaceComponent(Component c, Object makeNewComponent) {
  return awtReplaceComponent(c, makeNewComponent);
}
static JPanel jcenteredline(Component... components) {
  //ret new CenteredLine(components);
  return jFullCenter(hstackWithSpacing(components));
}

static JPanel jcenteredline(List<? extends Component> components) {
  return jcenteredline(asArray(Component.class, components));
}
static List<JButton> findButtons(Component c, String name) {
  List<JButton> l = new ArrayList();
  for (JButton b : childrenOfType(c, JButton.class))
    if (eq(b.getText(), name))
      l.add(b);
  return l;
}
static List<String> notStartingWith(Collection<String> l, final String prefix) {
  return filter(unnull(l) , new Object() { Object get(String s) { try { return  !startsWith(s, prefix) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "!startsWith(s, prefix)"; }});
}

static List<String> notStartingWith(String prefix, Collection<String> l) {
  return notStartingWith(l, prefix);
}
static int withTopMargin_defaultWidth = 6;

static JPanel withTopMargin(Component c) {
  return withTopMargin(withTopMargin_defaultWidth, c);
}

static JPanel withTopMargin(int w, Component c) {
  JPanel p = new JPanel(new BorderLayout());
  p.setBorder(BorderFactory.createEmptyBorder(w, 0, 0, 0));
  p.add(c);
  return p;
}
static <A, B> Set<A> keys(Map<A, B> map) {
  return map.keySet();
}

static Set keys(Object map) {
  return keys((Map) map);
}


  static <A> Set<A> keys(MultiSet<A> ms) {
    return ms.keySet();
  }

static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}

static JPanel centerAndSouth(Component c, Component s) {
  JPanel panel = new JPanel(new BorderLayout());
  panel.add(BorderLayout.CENTER, wrap(c));
  if (s != null) panel.add(BorderLayout.SOUTH, wrap(s));
  return panel;
}
// replacement for class JavaTok
// maybe incomplete, might want to add floating point numbers
// todo also: extended multi-line strings

static int javaTok_n, javaTok_elements;
static boolean javaTok_opt;

static List<String> javaTok(String s) {
  return javaTok(s, null);
}

static List<String> javaTok(String s, List<String> existing) {
  ++javaTok_n;
  int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
  ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(quickSubstring(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(quickSubstring(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static List<String> javaTok(List<String> tok) {
  return javaTok(join(tok), tok);
}

static boolean javaTok_isCopyable(String t, String s, int i, int j) {
  return t.length() == j-i
    && s.regionMatches(i, t, 0, j-i); // << could be left out, but that's brave
}
static JWindow infoBox(String text) {
  return infoMessage(text);
}

static JWindow infoBox(String text, double seconds) {
  return infoMessage(text, seconds);
}

static JWindow infoBox(Throwable e) {
  return infoMessage(e);
}
static List<String> trimAll(List<String> l) {
  List<String> l2 = new ArrayList();
  for (String s : l)
    l2.add(trim(s));
  return l2;
}
static JLabel jlabel(String text) {
  final JLabel l = new JLabel(text) {
    @Override
    public void setText(String text) {
      super.setText(text);
      setToolTipText(text);
    }
  };
  componentPopupMenu(l, new Object() { void get(JPopupMenu menu) { try { 
    addMenuItem(menu, "Copy text to clipboard", new Runnable() { public void run() { try { 
      copyTextToClipboard(l.getText());
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "copyTextToClipboard(l.getText());"; }});
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "addMenuItem(menu, \"Copy text to clipboard\", r {\r\n      copyTextToClipboard(l.get..."; }});
  return l;
}

static JLabel jlabel() {
  return jlabel(" ");
}
static String substring(String s, int x) {
  return substring(s, x, l(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x > s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.substring(x, y);
}


static String substring(String s, IntRange r) {
  return r == null ? null : substring(s, r.start, r.end);
}

static JFrame centerFrame(Component c) {
  JFrame frame = getFrame(c);
  if (frame != null)
    frame.setLocationRelativeTo(null); // magic trick
  return frame;
}
static Random random_random = new Random();

static int random(int n) {
  return n <= 0 ? 0 : random_random.nextInt(n);
}

static double random(double max) {
  return random()*max;
}

static double random() {
  return random_random.nextInt(100001)/100000.0;
}

static double random(double min, double max) {
  return min+random()*(max-min);
}

// min <= value < max
static int random(int min, int max) {
  return min+random(max-min);
}

static <A> A random(List<A> l) {
  return oneOf(l);
}

static <A> A random(Collection<A> c) {
  return oneOf(asList(c));
}
static void indexConceptField(Class<? extends Concept> c, String field) {
  if (!isConceptFieldIndexed(c, field))
    new ConceptFieldIndex(c, field);
}
static Pair<Map<String, String>, Map<String, String>> tok_dropAsterisks_pair(Map<String, String> map) {
  Map<String, String> a = mapKeysAndValues_litOrderedMap("tok_dropAsterisks", map);
  Map<String, String> b = mapKeysAndValues_litOrderedMap("asteriskPartsOnly", "tok_dropAsterisks", map);
  b.remove("");
  return pair(a, b);
}
// get purpose 1: access a list/array (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      return f.get(o);
    }
      
    
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(Object o, String field) {
  try {
    Field f = get_findField(o.getClass(), field);
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}

//please include function withMargin.

static int showForm_defaultGap = 4;

static JPanel showFormTitled(String title, Object... _parts) {
  final Var<JFrame> frame = new Var();
  JPanel panel = showForm_makePanel(frame, _parts);
  frame.set(minFrameWidth(showPackedFrame(title, withMargin(panel)), 400));
  return panel;
}

static JPanel showForm_makePanel(final Var<JFrame> frame, Object... _parts) {
  List<List> l = new ArrayList();
  List parts = asList(_parts);
  Runnable submit = null;
  for (int i = 0; i < l(parts); i++) {
    final Object o = parts.get(i), next = get(parts, i+1);
    if (o instanceof Component || o instanceof String || next instanceof Component) { // smartAdd accepts strings
      l.add(ll(o == null ? new JPanel() : o, next));
      if (next instanceof JButton && submit == null)
        submit = new Runnable() { public void run() { try {  ((JButton) next).doClick() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "((JButton) next).doClick()"; }};
      i++;
    } else if (isRunnable(o))
      l.add(ll(null, jbutton(showFormSubmitButtonName(), submit = new Runnable() { public void run() { try { 
        Object result = call(o);
        if (neq(Boolean.FALSE, result))
          disposeFrame(frame.get());
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "Object result = call(o);\r\n        if (neq(Boolean.FALSE, result))\r\n          dis..."; }})));
    else print("showForm: Unknown element type: " + getClassName(o));
  }
  JPanel panel = hvgrid((List) l, showForm_defaultGap);
  if (submit != null)
    for (JTextField textField : childrenOfType(panel, JTextField.class))
      onEnter(textField, submit);
  return panel;
}
static <A extends Concept> int countConcepts(Class<A> c, Object... params) {
  return mainConcepts.countConcepts(c, params);
}

static int countConcepts() {
  return mainConcepts.countConcepts();
}

static int countConcepts(String className) {
  return mainConcepts.countConcepts(className);
}

static <A extends Concept> int countConcepts(Concepts concepts, String className) {
  return concepts.countConcepts(className);
}
static boolean preferCached = false;
static boolean loadSnippet_debug = false;

public static String loadSnippet(String snippetID) {
  try {
    return loadSnippet(parseSnippetID(snippetID), preferCached);
  } catch (IOException e) {
    throw new RuntimeException(e);
  }
}

public static String loadSnippet(String snippetID, boolean preferCached) throws IOException {
  return loadSnippet(parseSnippetID(snippetID), preferCached);
}

public static String loadSnippet(long snippetID) {
  try {
    return loadSnippet(snippetID, preferCached);
  } catch (IOException e) {
    throw new RuntimeException(e);
  }
}

public static String loadSnippet(long snippetID, boolean preferCached) throws IOException {
  String text;
  
  // boss bot disabled for now for shorter transpilations
  
  /*text = getSnippetFromBossBot(snippetID);
  if (text != null) return text;*/
  
  initSnippetCache();
  text = DiskSnippetCache_get(snippetID);
  
  if (preferCached && text != null)
    return text;
  
  try {
    if (loadSnippet_debug && text != null) System.err.println("md5: " + md5(text));
    String url = "http://tinybrain.de:8080/getraw.php?id=" + snippetID + "&utf8=1";
    if (nempty(text)) url += "&md5=" + md5(text);
    String text2 = loadPage(url + standardCredentials());
    boolean same = eq(text2, "==*#*==");
    if (loadSnippet_debug) print("loadSnippet: same=" + same);
    if (!same) text = text2;
  } catch (RuntimeException e) {
    e.printStackTrace();
    throw new IOException("Snippet #" + snippetID + " not found or not public");
  }

  try {
    initSnippetCache();
    DiskSnippetCache_put(snippetID, text);
  } catch (IOException e) {
    System.err.println("Minor warning: Couldn't save snippet to cache ("  + DiskSnippetCache_getDir() + ")");
  }

  return text;
}

static File DiskSnippetCache_dir;

public static void initDiskSnippetCache(File dir) {
  DiskSnippetCache_dir = dir;
  dir.mkdirs();
}

public static synchronized String DiskSnippetCache_get(long snippetID) throws IOException {
  return loadTextFile(DiskSnippetCache_getFile(snippetID).getPath(), null);
}

private static File DiskSnippetCache_getFile(long snippetID) {
  return new File(DiskSnippetCache_dir, "" + snippetID);
}

public static synchronized void DiskSnippetCache_put(long snippetID, String snippet) throws IOException {
  saveTextFile(DiskSnippetCache_getFile(snippetID).getPath(), snippet);
}

public static File DiskSnippetCache_getDir() {
  return DiskSnippetCache_dir;
}

public static void initSnippetCache() {
  if (DiskSnippetCache_dir == null)
    initDiskSnippetCache(getGlobalCache());
}

static JFrame showFrame() {
  return makeFrame();
}

static JFrame showFrame(Object content) {
  return makeFrame(content);
}

static JFrame showFrame(String title) {
  return makeFrame(title);
}

static JFrame showFrame(String title, Object content) {
  return makeFrame(title, content);
}

static JFrame showFrame(final JFrame frame) {
  if (frame != null) { swingAndWait(new Runnable() { public void run() { try { 
    if (frameTooSmall(frame)) frameStandardSize(frame);
    frame.setVisible(true);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (frameTooSmall(frame)) frameStandardSize(frame);\r\n    frame.setVisible(true);"; }}); }
  return frame;
}

// make or update frame
static JFrame showFrame(String title, Object content, JFrame frame) {
  if (frame == null)
    return showFrame(title, content);
  else {
    frame.setTitle(title);
    setFrameContents(frame, content);
    return frame;
  }
}
static String trimJoinSubList(List<String> l, int i, int j) {
  return trim(join(subList(l, i, j)));
}

static String trimJoinSubList(List<String> l, int i) {
  return trim(join(subList(l, i)));
}
// This is a bit rough... finds static and non-static methods.
// It's usually just for error messages though, so no worries.

static boolean hasMethodNamed(Object obj, String method) {
  if (obj == null) return false;
  if (obj instanceof Class)
    return hasMethodNamed((Class) obj, method);
  return hasMethodNamed(obj.getClass(), method);
}

static boolean hasMethodNamed(Class c, String method) {
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method))
        return true;
    c = c.getSuperclass();
  }
  return false;
}
static int makeUniqueConcepts(Class<? extends Concept> c, String field, Collection values) {
  int n = 0;
  for (Object value : unnull(values))
    if (uniq3(c, field, value)) ++n;
  return n;
}
static int max(int a, int b) { return Math.max(a, b); }
static int max(int a, int b, int c) { return max(max(a, b), c); }
static long max(int a, long b) { return Math.max((long) a, b); }
static long max(long a, long b) { return Math.max(a, b); }
static double max(int a, double b) { return Math.max((double) a, b); }
static float max(float a, float b) { return Math.max(a, b); }

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}
static JTextField jtextfield_caretLeft() {
  return jtextfield_caretLeft("");
}

static JTextField jtextfield_caretLeft(String text) {
  JTextField tf = jTextField(text);
  tf.setCaretPosition(0);
  return tf;
}

static JTextField jtextfield_caretLeft(Object o) {
  return jtextfield_caretLeft(strOrEmpty(o));
}

static MultiSet<String> getSentencesFromWebBotLog(String botID) {
  String html = loadPage("http://ai1.lol/" + psI(botID) + "/raw/logs");
  MultiSet<String> sentences = new MultiSet();
  for (List<String> li : html_contentsOfLIs(html)) {
    String dialogID = trim(first(li));
    for (List<String> li2 : html_contentsOfLIs(li)) {
      String msg = htmldecode(join(li2));
      sentences.add(trim(dropPrefix("<", dropPrefix(">", msg))));
    }
  }
  return sentences;
}
static Map<Thread, Boolean> _registerThread_threads = synchroMap(new WeakHashMap());

static Thread _registerThread(Thread t) {
  _registerThread_threads.put(t, true);
  return t;
}
static boolean nempty(Collection c) {
  return !isEmpty(c);
}

static boolean nempty(CharSequence s) {
  return !isEmpty(s);
}

static boolean nempty(Object[] o) {
  return !isEmpty(o);
}

static boolean nempty(Map m) {
  return !isEmpty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}
static <A extends Concept> A findConcept(Class<A> c, Object... params) {
  return findConceptWhere(c, params);
}

static <A extends Concept> A findConcept(Concepts concepts, Class<A> c, Object... params) {
  return findConceptWhere(concepts, c, params);
}
// value = 0 to 1
static JSplitPane setSplitPaneLater(final Component c, final double value) {
  final JSplitPane sp = first(childrenOfType(c, JSplitPane.class));
  if (sp != null)
    swingLater(new Runnable() { public void run() { try {  sp.setDividerLocation(value); 
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "sp.setDividerLocation(value);"; }});
  return sp;
}
static String getTextTrim(JTextComponent c) {
  return trim(getText(c));
}

// tested for editable combo box - returns the contents of text field
static String getTextTrim(JComboBox cb) {
  return trim(getText(cb));
}
static String n(long l, String name) {
  return l + " " + (l == 1 ? singular(name) : getPlural(name));
}

static String n(Collection l, String name) {
  return n(l(l), name);
}

static String n(Map m, String name) {
  return n(l(m), name);
}

static String n(Object[] a, String name) {
  return n(l(a), name);
}


  static String n(MultiSet ms, String name) {
    return n(l(ms), name);
  }

// action: voidfunc(JTextComponent)
static JButton textActionButton(String text, final Object action) {
  return new JButton(new TextAction(text) {
    public void actionPerformed(ActionEvent e) {
      pcallF(action, getFocusedComponent());
    }
  });
}
static String ai_renderAction(String text, IntRange r) {
  if (r == null) return null;
  int i = trimIndexRight(text, r.start);
  int j = trimIndexLeft(text, r.end);
  return j <= i ? null : quote(substring(text, i, j)) + " (" + i + "/" + (j-i) + ")";
}
static <A extends Component> A setFrameSize(A c, int w, int h) {
  JFrame f = getFrame(c);
  if (f != null)
    f.setSize(w, h);
  return c;
}
static List<String> splitByJavaToken(String s, String splitToken) {
  List<String> tok = javaTok(s);
  List<String> l = new ArrayList();
  int i = 1;
  while (i < l(tok)) {
    int j = i;
    while (i < l(tok)) {
      j = indexOf(tok, splitToken, i);
      if (j == i) i += 2; else break;
    }
    if (i >= l(tok)) break;
    if (j < 0) j = l(tok);
    l.add(join(tok.subList(i, j-1)));
    i = j+2;
  }
  return l;
}
static JSplitPane jvsplit(Component north, Component south) {
  return jvsplit(north, south, 0.5);
}

static JSplitPane jvsplit(Component north, Component south, double splitPoint) {
  return setSplitPaneLater(
    new JSplitPane(JSplitPane.VERTICAL_SPLIT, wrap(north), wrap(south)),
    splitPoint);
}
static Map<String, String> parseText2Tag(String snippetID) {
  Map<String, String> map = new LinkedHashMap();
  for (String s : toLinesFullTrim(loadSnippet(snippetID))) {
    List<String> tok = javaTok(s);
    String text = get(tok, 1);
    if (isQuoted(text)) {
      String tag = trimDropPrefixTrim(",", join(dropFirst(tok, 2)));
      map.put(unquote(text), tag);
    }
  }
  return map;
}
static void db() {
  conceptsAndBot();
}
static String[] dropFirst(int n, String[] a) {
  return drop(n, a);
}

static String[] dropFirst(String[] a) {
  return drop(1, a);
}

static Object[] dropFirst(Object[] a) {
  return drop(1, a);
}

static <A> List<A> dropFirst(List<A> l) {
  return dropFirst(1, l);
}

static <A> List<A> dropFirst(Iterable<A> i) {
  return dropFirst(toList(i));
}

static <A> List<A> dropFirst(int n, List<A> l) {
  return n <= 0 ? l : new ArrayList(l.subList(Math.min(n, l.size()), l.size()));
}

static <A> List<A> dropFirst(List<A> l, int n) {
  return dropFirst(n, l);
}

static String dropFirst(int n, String s) {
  return substring(s, n);
}


static List<WeakReference> hotwire_classes = new ArrayList();

static Class<?> hotwireDependent(String src) {
  Class c = hotwire(src);
  makeDependent(c);
  return c;
}

static Object[] asArray(List l) {
  return toObjectArray(l);
}

static <A> A[] asArray(Class<A> type, List l) {
  return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
}
static WeakHashMap<JFrame,Boolean> makeFrame_myFrames = new WeakHashMap();

static JFrame makeFrame() {
  return makeFrame((Component) null);
}

static JFrame makeFrame(Object content) {
  return makeFrame(programTitle(), content);
}

static JFrame makeFrame(String title) {
  return makeFrame(title, null);
}

static JFrame makeFrame(String title, Object content) {
  return makeFrame(title, content, true);
}

static JFrame makeFrame(final String title, final Object content, final boolean showIt) {
  return (JFrame) swing(new Object() { Object get() { try { 
    if (getFrame(content) != null)
      return setFrameTitle((Component) content, title);
    final JFrame frame = new JFrame(title);
    makeFrame_myFrames.put(frame, Boolean.TRUE);
    JComponent wrapped = wrap(content);
    if (wrapped != null)
      frame.getContentPane().add(wrapped);
    frame.setBounds(300, 100, 500, 400);
    if (showIt)
      frame.setVisible(true);
    //callOpt(content, "requestFocus");
    //exitOnFrameClose(frame);
    
    standardTitlePopupMenu(frame);
    return frame;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "if (getFrame(content) != null)\r\n      ret setFrameTitle((Component) content, tit..."; }});
}
static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();

static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMC((String) f, args);
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) throw fail("No get method in " + getClassName(c));
  if (n == 1) return methods.get(0).invoke(f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return m.invoke(f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static <A> ArrayList<A> asList(A[] a) {
  return new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  ArrayList<Integer> l = new ArrayList();
  for (int i : a) l.add(i);
  return l;
}

static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}

static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}
static JMenu getMenuNamed(JMenuBar bar, String name) {
  int n = bar.getMenuCount();
  for (int i = 0; i < n; i++) {
    JMenu m = bar.getMenu(i);
    if (m != null && eq(m.getText(), name))
      return m;
  }
  return null;
}
static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder((int) (l(s)*1.5+2));
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
  out.append('"');
}
static void disposeFrame(final Component c) {
  swingNowOrLater(new Runnable() { public void run() { try { 
    Frame f = getFrame(c);
    if (f != null)
      f.dispose();
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "Frame f = getFrame(c);\n    if (f != null)\n      f.dispose();"; }});
}
static <A> List<List<A>> groupInFixedSizeRows(List<A> l, int rowSize) {
  List < List < A > > matrix = new ArrayList();
  for (int i = 0; i < l(l); i += rowSize)
    matrix.add(subList(l, i, i+rowSize));
  return matrix;
}

static <A> List<List<A>> groupInFixedSizeRows(A[] l, int rowSize) {
  return groupInFixedSizeRows(asList(l), rowSize);
}
static void setFrameContents(JFrame frame, Object contents) {
  frame.getContentPane().removeAll();
  frame.getContentPane().add(wrap(contents));
  revalidate(frame);
}
static JTextField jTextField() {
  return jTextField("");
}

static JTextField jTextField(String text) {
  JTextField tf = new JTextField(unnull(text));
  jenableUndoRedo(tf);
  tf.selectAll();
  return tf;
}

static JTextField jTextField(Object o) {
  return jTextField(strOrEmpty(o));
}

static String dropPrefix(String prefix, String s) {
  return s == null ? null : s.startsWith(prefix) ? s.substring(l(prefix)) : s;
}
static boolean infoMessage_alwaysOnTop = true;
static double infoMessage_defaultTime = 5.0;

// automatically switches to AWT thread for you
static JWindow infoMessage(String text) {
  return infoMessage(text, infoMessage_defaultTime);
}

static JWindow infoMessage(final String text, final double seconds) {
  print(text);
  return infoMessage_noprint(text, seconds);
}

static JWindow infoMessage_noprint(String text) {
  return infoMessage_noprint(text, infoMessage_defaultTime);
}

static JWindow infoMessage_noprint(final String text, final double seconds) {
  if (isHeadless()) return null;
  return (JWindow) swingAndWait(new Object() { Object get() { try { 
    JTextArea ta = wrappedTextArea(text);
    ta.setFont(typeWriterFont());
    JScrollPane sp = jscroll(ta);
    final JWindow window = showWindow(withMargin(sp));
    window.setSize(300, 150);
    moveToTopRightCorner(window);
    onClick(ta, new Runnable() { public void run() { try {  window.dispose() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "window.dispose()"; }});
    if (infoMessage_alwaysOnTop)
      window.setAlwaysOnTop(true);
    window.setVisible(true);
    disposeWindowAfter(iround(seconds*1000), window);
    return window;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JTextArea ta = wrappedTextArea(text);\r\n    ta.setFont(typeWriterFont());\r\n    JS..."; }});
}

static JWindow infoMessage(Throwable e) {
  showConsole();
  printStackTrace(e);
  return infoMessage(str(e));
}
static <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhere(c, params);
  if (x == null) {
    x = nuObject(c);
    csetAll(x, params);
  }
  return x;
}
static List<String> getPlural_specials = ll("sheep", "fish");

static String getPlural(String s) {
  if (containsIgnoreCase(getPlural_specials, s)) return s;
  if (ewic(s, "y")) return dropSuffixIgnoreCase("y", s) + "ies";
  if (ewic(s, "ss")) return s + "es";
  if (ewic(s, "s")) return s;
  return s + "s";
}
static String getText(final JTextComponent c) {
  return c == null ? "" : (String) swingAndWait(new Object() { Object get() { try { return  c.getText() ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "c.getText()"; }});
}

static String getText(final JLabel l) {
  return l == null ? "" : (String) swingAndWait(new Object() { Object get() { try { return  l.getText() ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "l.getText()"; }});
}

// tested for editable combo box - returns the contents of text field
static String getText(final JComboBox cb) {
  return unnull((String) cb.getEditor().getItem());
}
static int trimIndexLeft(String s, int i) {
  while (i > 0 && s.charAt(i-1) == ' ') --i;
  return i;
}
static <A> List<A> newSubList(List<A> l, int startIndex, int endIndex) {
  return cloneList(subList(l, startIndex, endIndex));
}

static <A> List<A> newSubList(List<A> l, int startIndex) {
  return cloneList(subList(l, startIndex));
}
static JMenuBar addMenuBar(JFrame f) {
  JMenuBar bar = f.getJMenuBar();
  if (bar == null) {
    f.setJMenuBar(bar = new JMenuBar());
    revalidateFrame(f);
  }
  return bar;
}
static String standardCredentials() {
  String user = standardCredentialsUser();
  String pass = standardCredentialsPass();
  if (nempty(user) && nempty(pass))
    return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
  return "";
}
static void addMenuItem(JPopupMenu menu, String text, Object action) {
  menu.add(jmenuItem(text, action));
}

static void addMenuItem(JPopupMenu menu, JMenuItem menuItem) {
  menu.add(menuItem);
}
static Map<String, String> singular_specials = litmap(
  "children", "child", "images", "image", "chess", "chess");
  
static Set<String> singular_specials2 = litset("time", "machine");

static String singular(String s) {
  if (s == null) return null;
  { String _a_2 = singular_specials.get(s); if (!empty(_a_2)) return _a_2; }
  if (singular_specials2.contains(dropSuffix("s", s)))
    return dropSuffix("s", s);
  if (s.endsWith("ness")) return s;
  if (s.endsWith("ges")) return dropSuffix("s", s);
  s = dropSuffix("es", s);
  s = dropSuffix("s", s);
  return s;
}
static String quickSubstring(String s, int i, int j) {
  if (i == j) return "";
  return s.substring(i, j);
}
static Dimension componentsBoundingSize(Container container, int insetBottomRight) {
  Rectangle r = new Rectangle(0, 0, 0, 0);
  for (Component c : container.getComponents())
    r = rectangleUnion(r, c.getBounds());
  return new Dimension(r.x+r.width+insetBottomRight, r.y+r.height+insetBottomRight);
}
static boolean isRunnable(Object o) {
  return o instanceof Runnable || hasMethod(o, "get");
}
static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> List<A> unnull(List<A> l) {
  return l == null ? emptyList() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static Object[] unnull(Object[] a) {
  return a == null ? new Object[0] : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}
static <A> List<A> childrenOfType(Component c, Class<A> theClass) {
  List<A> l = new ArrayList();
  scanForComponents(c, theClass, l);
  return l;
}
static JPanel vstack2(Object... parts) {
  JPanel panel = new JPanel(new GridBagLayout());
  GridBagConstraints gbc = new GridBagConstraints();
  gbc.weightx = 1;
  gbc.fill = GridBagConstraints.HORIZONTAL;
  gbc.gridwidth = GridBagConstraints.REMAINDER;
  smartAddWithLayout(panel, gbc, parts);
  //gbc = (GridBagConstraints) gbc.clone();
  //gbc.fill = GridBagConstraints.BOTH;
  gbc.weighty = 1;
  panel.add(Box.createRigidArea(new Dimension(0, 0)), gbc);
  return panel;
}
static <A> List<A> sortedByFieldDesc(Collection<A> c, String field) {
  return reversedList(sortedByField(c, field));
}

static <A> List<A> sortedByFieldDesc(String field, Collection<A> c) {
  return sortedByFieldDesc(c, field);
}
static class componentPopupMenu_Maker {
  List menuMakers = new ArrayList();
}

static Map<JComponent, componentPopupMenu_Maker> componentPopupMenu_map = new WeakHashMap();

static ThreadLocal<MouseEvent> componentPopupMenu_mouseEvent = new ThreadLocal();

// menuMaker = voidfunc(JPopupMenu)
static void componentPopupMenu(final JComponent component, final Object menuMaker) {
  swingNowOrLater(new Runnable() { public void run() { try { 
    componentPopupMenu_Maker maker = componentPopupMenu_map.get(component);
    if (maker == null) {
      componentPopupMenu_map.put(component, maker = new componentPopupMenu_Maker());
      component.addMouseListener(new componentPopupMenu_Adapter(maker));
    }
    maker.menuMakers.add(menuMaker);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "componentPopupMenu_Maker maker = componentPopupMenu_map.get(component);\n    if (..."; }});
}

static class componentPopupMenu_Adapter extends MouseAdapter {
  componentPopupMenu_Maker maker;
  
  componentPopupMenu_Adapter(componentPopupMenu_Maker maker) {
  this.maker = maker;}
  
  public void mousePressed(MouseEvent e) { displayMenu(e); }
  public void mouseReleased(MouseEvent e) { displayMenu(e); }

  void displayMenu(MouseEvent e) {
    if (e.isPopupTrigger()) displayMenu2(e);
  }
    
  void displayMenu2(MouseEvent e) {
    JPopupMenu menu = new JPopupMenu();
    int emptyCount = menu.getComponentCount();
    
    componentPopupMenu_mouseEvent.set(e);
    for (Object menuMaker : maker.menuMakers)
      pcallF(menuMaker, menu);
    
    // show menu if any items in it
    if (menu.getComponentCount() != emptyCount)
      menu.show(e.getComponent(), e.getX(), e.getY());
  }
}
static <A> ArrayList<A> litlist(A... a) {
  return new ArrayList<A>(Arrays.asList(a));
}
static List<String> toLines(File f) {
  return toLines(loadTextFile(f));
}

  public static List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null) return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start) lines.add(s.substring(start));
        break;
      }

      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
        i += 2;
      else
        ++i;

      start = i;
    }
    return lines;
  }

  private static int toLines_nextLineBreak(String s, int start) {
    for (int i = start; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }
// layouter: voidfunc(Container) or func(Container) -> Dimension
// (return value is preferred size)
static JPanel customLayoutPanel_trackWidth(final Object layouter) {
  class P extends JPanel implements Scrollable {
    P() { super(layoutManagerFromFunction(layouter)); }
    
    @Override
    public Dimension getPreferredScrollableViewportSize() { return getPreferredSize(); }
    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) { return 20; }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
      return (direction == SwingConstants.HORIZONTAL ? visibleRect.width : visibleRect.height)*5/6;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() { return true; }

    @Override
    public boolean getScrollableTracksViewportHeight() { return false; }
  }
  return new P();
}
static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  startIndex = max(0, min(l(l), startIndex));
  endIndex = max(0, min(l(l), endIndex));
  if (startIndex > endIndex) return litlist();
  return l.subList(startIndex, endIndex);
}


static <A> List<A> subList(List<A> l, IntRange r) {
  return subList(l, r.start, r.end);
}

static String htmldecode(final String input) {
  if (input == null) return null;
  
  final int MIN_ESCAPE = 2;
  final int MAX_ESCAPE = 6;

  StringWriter writer = null;
  int len = input.length();
  int i = 1;
  int st = 0;
  while (true) {
      // look for '&'
      while (i < len && input.charAt(i-1) != '&')
          i++;
      if (i >= len)
          break;

      // found '&', look for ';'
      int j = i;
      while (j < len && j < i + MAX_ESCAPE + 1 && input.charAt(j) != ';')
          j++;
      if (j == len || j < i + MIN_ESCAPE || j == i + MAX_ESCAPE + 1) {
          i++;
          continue;
      }

      // found escape 
      if (input.charAt(i) == '#') {
          // numeric escape
          int k = i + 1;
          int radix = 10;

          final char firstChar = input.charAt(k);
          if (firstChar == 'x' || firstChar == 'X') {
              k++;
              radix = 16;
          }

          try {
              int entityValue = Integer.parseInt(input.substring(k, j), radix);

              if (writer == null) 
                  writer = new StringWriter(input.length());
              writer.append(input.substring(st, i - 1));

              if (entityValue > 0xFFFF) {
                  final char[] chrs = Character.toChars(entityValue);
                  writer.write(chrs[0]);
                  writer.write(chrs[1]);
              } else {
                  writer.write(entityValue);
              }

          } catch (NumberFormatException ex) { 
              i++;
              continue;
          }
      }
      else {
          // named escape
          CharSequence value = htmldecode_lookupMap.get(input.substring(i, j));
          if (value == null) {
              i++;
              continue;
          }

          if (writer == null) 
              writer = new StringWriter(input.length());
          writer.append(input.substring(st, i - 1));

          writer.append(value);
      }

      // skip escape
      st = j + 1;
      i = st;
  }

  if (writer != null) {
      writer.append(input.substring(st, len));
      return writer.toString();
  }
  return input;
}

private static final String[][] htmldecode_ESCAPES = {
    {"\"",     "quot"}, // " - double-quote
    {"&",      "amp"}, // & - ampersand
    {"<",      "lt"}, // < - less-than
    {">",      "gt"}, // > - greater-than

    // Mapping to escape ISO-8859-1 characters to their named HTML 3.x equivalents.
    {"\u00A0", "nbsp"}, // non-breaking space
    {"\u00A1", "iexcl"}, // inverted exclamation mark
    {"\u00A2", "cent"}, // cent sign
    {"\u00A3", "pound"}, // pound sign
    {"\u00A4", "curren"}, // currency sign
    {"\u00A5", "yen"}, // yen sign = yuan sign
    {"\u00A6", "brvbar"}, // broken bar = broken vertical bar
    {"\u00A7", "sect"}, // section sign
    {"\u00A8", "uml"}, // diaeresis = spacing diaeresis
    {"\u00A9", "copy"}, // copyright sign
    {"\u00AA", "ordf"}, // feminine ordinal indicator
    {"\u00AB", "laquo"}, // left-pointing double angle quotation mark = left pointing guillemet
    {"\u00AC", "not"}, // not sign
    {"\u00AD", "shy"}, // soft hyphen = discretionary hyphen
    {"\u00AE", "reg"}, // registered trademark sign
    {"\u00AF", "macr"}, // macron = spacing macron = overline = APL overbar
    {"\u00B0", "deg"}, // degree sign
    {"\u00B1", "plusmn"}, // plus-minus sign = plus-or-minus sign
    {"\u00B2", "sup2"}, // superscript two = superscript digit two = squared
    {"\u00B3", "sup3"}, // superscript three = superscript digit three = cubed
    {"\u00B4", "acute"}, // acute accent = spacing acute
    {"\u00B5", "micro"}, // micro sign
    {"\u00B6", "para"}, // pilcrow sign = paragraph sign
    {"\u00B7", "middot"}, // middle dot = Georgian comma = Greek middle dot
    {"\u00B8", "cedil"}, // cedilla = spacing cedilla
    {"\u00B9", "sup1"}, // superscript one = superscript digit one
    {"\u00BA", "ordm"}, // masculine ordinal indicator
    {"\u00BB", "raquo"}, // right-pointing double angle quotation mark = right pointing guillemet
    {"\u00BC", "frac14"}, // vulgar fraction one quarter = fraction one quarter
    {"\u00BD", "frac12"}, // vulgar fraction one half = fraction one half
    {"\u00BE", "frac34"}, // vulgar fraction three quarters = fraction three quarters
    {"\u00BF", "iquest"}, // inverted question mark = turned question mark
    {"\u00C0", "Agrave"}, // ? - uppercase A, grave accent
    {"\u00C1", "Aacute"}, // ? - uppercase A, acute accent
    {"\u00C2", "Acirc"}, // ? - uppercase A, circumflex accent
    {"\u00C3", "Atilde"}, // ? - uppercase A, tilde
    {"\u00C4", "Auml"}, // ? - uppercase A, umlaut
    {"\u00C5", "Aring"}, // ? - uppercase A, ring
    {"\u00C6", "AElig"}, // ? - uppercase AE
    {"\u00C7", "Ccedil"}, // ? - uppercase C, cedilla
    {"\u00C8", "Egrave"}, // ? - uppercase E, grave accent
    {"\u00C9", "Eacute"}, // ? - uppercase E, acute accent
    {"\u00CA", "Ecirc"}, // ? - uppercase E, circumflex accent
    {"\u00CB", "Euml"}, // ? - uppercase E, umlaut
    {"\u00CC", "Igrave"}, // ? - uppercase I, grave accent
    {"\u00CD", "Iacute"}, // ? - uppercase I, acute accent
    {"\u00CE", "Icirc"}, // ? - uppercase I, circumflex accent
    {"\u00CF", "Iuml"}, // ? - uppercase I, umlaut
    {"\u00D0", "ETH"}, // ? - uppercase Eth, Icelandic
    {"\u00D1", "Ntilde"}, // ? - uppercase N, tilde
    {"\u00D2", "Ograve"}, // ? - uppercase O, grave accent
    {"\u00D3", "Oacute"}, // ? - uppercase O, acute accent
    {"\u00D4", "Ocirc"}, // ? - uppercase O, circumflex accent
    {"\u00D5", "Otilde"}, // ? - uppercase O, tilde
    {"\u00D6", "Ouml"}, // ? - uppercase O, umlaut
    {"\u00D7", "times"}, // multiplication sign
    {"\u00D8", "Oslash"}, // ? - uppercase O, slash
    {"\u00D9", "Ugrave"}, // ? - uppercase U, grave accent
    {"\u00DA", "Uacute"}, // ? - uppercase U, acute accent
    {"\u00DB", "Ucirc"}, // ? - uppercase U, circumflex accent
    {"\u00DC", "Uuml"}, // ? - uppercase U, umlaut
    {"\u00DD", "Yacute"}, // ? - uppercase Y, acute accent
    {"\u00DE", "THORN"}, // ? - uppercase THORN, Icelandic
    {"\u00DF", "szlig"}, // ? - lowercase sharps, German
    {"\u00E0", "agrave"}, // ? - lowercase a, grave accent
    {"\u00E1", "aacute"}, // ? - lowercase a, acute accent
    {"\u00E2", "acirc"}, // ? - lowercase a, circumflex accent
    {"\u00E3", "atilde"}, // ? - lowercase a, tilde
    {"\u00E4", "auml"}, // ? - lowercase a, umlaut
    {"\u00E5", "aring"}, // ? - lowercase a, ring
    {"\u00E6", "aelig"}, // ? - lowercase ae
    {"\u00E7", "ccedil"}, // ? - lowercase c, cedilla
    {"\u00E8", "egrave"}, // ? - lowercase e, grave accent
    {"\u00E9", "eacute"}, // ? - lowercase e, acute accent
    {"\u00EA", "ecirc"}, // ? - lowercase e, circumflex accent
    {"\u00EB", "euml"}, // ? - lowercase e, umlaut
    {"\u00EC", "igrave"}, // ? - lowercase i, grave accent
    {"\u00ED", "iacute"}, // ? - lowercase i, acute accent
    {"\u00EE", "icirc"}, // ? - lowercase i, circumflex accent
    {"\u00EF", "iuml"}, // ? - lowercase i, umlaut
    {"\u00F0", "eth"}, // ? - lowercase eth, Icelandic
    {"\u00F1", "ntilde"}, // ? - lowercase n, tilde
    {"\u00F2", "ograve"}, // ? - lowercase o, grave accent
    {"\u00F3", "oacute"}, // ? - lowercase o, acute accent
    {"\u00F4", "ocirc"}, // ? - lowercase o, circumflex accent
    {"\u00F5", "otilde"}, // ? - lowercase o, tilde
    {"\u00F6", "ouml"}, // ? - lowercase o, umlaut
    {"\u00F7", "divide"}, // division sign
    {"\u00F8", "oslash"}, // ? - lowercase o, slash
    {"\u00F9", "ugrave"}, // ? - lowercase u, grave accent
    {"\u00FA", "uacute"}, // ? - lowercase u, acute accent
    {"\u00FB", "ucirc"}, // ? - lowercase u, circumflex accent
    {"\u00FC", "uuml"}, // ? - lowercase u, umlaut
    {"\u00FD", "yacute"}, // ? - lowercase y, acute accent
    {"\u00FE", "thorn"}, // ? - lowercase thorn, Icelandic
    {"\u00FF", "yuml"}, // ? - lowercase y, umlaut
    {"\u2013", "ndash"},
    {"\u2018", "lsquo"},
    {"\u2019", "rsquo"},
    {"\u201D", "rdquo"},
    {"\u201C", "ldquo"},
    {"\u2014", "mdash"},
    
    {"'", "apos"}, // the controversial (but who cares!) &apos;
      // stackoverflow.com/questions/2083754/why-shouldnt-apos-be-used-to-escape-single-quotes
  };

private static final HashMap<String, CharSequence> htmldecode_lookupMap;
static {
    htmldecode_lookupMap = new HashMap<String, CharSequence>();
    for (final CharSequence[] seq : htmldecode_ESCAPES) 
        htmldecode_lookupMap.put(seq[1].toString(), seq[0]);
}
static String strOrEmpty(Object o) {
  return o == null ? "" : str(o);
}
static void fillJMenu(JMenu m, Object... x) {
  if (x == null) return;
  for (int i = 0; i < l(x); i++) {
    Object o = x[i], y = get(x, i+1);
    if (o instanceof List)
      fillJMenu(m, asArray((List) o));
    else if (eqOneOf(o, "***", "---", "===", ""))
      m.addSeparator();
    else if (o instanceof String && isRunnableX(y)) {
      m.add(jmenuItem((String) o, y));
      ++i;
    } else if (o instanceof JMenuItem)
      m.add((JMenuItem) o); // "call" might use wrong method
    else if (o instanceof String || o instanceof Action || o instanceof Component)
      call(m, "add", o);
    else
      print("Unknown menu item: " + o);
  }
}
  static ThreadLocal<String> loadPage_charset = new ThreadLocal();
  static boolean loadPage_allowGzip = true, loadPage_debug;
  static boolean loadPage_anonymous; // don't send computer ID
  static int loadPage_verboseness = 100000;
  static int loadPage_retries = 60; // seconds
  static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  public static String loadPageSilently(String url) { try {
    return loadPageSilently(new URL(loadPage_preprocess(url)));
  } catch (Exception __e) { throw rethrow(__e); } }

  public static String loadPageSilently(URL url) { try {
    IOException e = null;
    for (int tries = 0; tries < loadPage_retries; tries++)
      try {
        URLConnection con = openConnection(url);
        return loadPage(con, url);
      } catch (IOException _e) {
        e = _e;
        if (loadPageThroughProxy_enabled) {
          print("Trying proxy because of: " + e);
          try {
            return loadPageThroughProxy(str(url));
          } catch (Throwable e2) {
            print("  " + exceptionToStringShort(e2));
          }
        } else if (loadPage_debug)
          print(e);
        sleepSeconds(1);
      }
    throw e;
  } catch (Exception __e) { throw rethrow(__e); } }

  static String loadPage_preprocess(String url) {  
    if (url.startsWith("tb/"))
      url = "tinybrain.de:8080/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }
  
  public static String loadPage(String url) { try {
    url = loadPage_preprocess(url);
    if (!isTrue(loadPage_silent.get()))
      print("Loading: " + hideCredentials(url));
    return loadPageSilently(new URL(url));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  public static String loadPage(URL url) {
    print("Loading: " + hideCredentials(url.toExternalForm()));
    return loadPageSilently(url);
  }

  public static String loadPage(URLConnection con, URL url) throws IOException {
    try {
      if (!loadPage_anonymous)
        setHeaders(con);
      if (loadPage_allowGzip)
        con.setRequestProperty("Accept-Encoding", "gzip");
    } catch (Throwable e) {} // fails if within doPost
    String contentType = con.getContentType();
    if (contentType == null)
      throw new IOException("Page could not be read: " + url);
    //print("Content-Type: " + contentType);
    String charset = loadPage_charset == null ? null : loadPage_charset.get();
    if (charset == null) charset = loadPage_guessCharset(contentType);
    
    InputStream in = con.getInputStream();
    if ("gzip".equals(con.getContentEncoding())) {
      if (loadPage_debug)
        print("loadPage: Using gzip.");
      in = new GZIPInputStream(in);
    }
    Reader r = new InputStreamReader(in, charset);
    
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  }
  
  static String loadPage_guessCharset(String contentType) {
    Pattern p = Pattern.compile("text/[a-z]+;\\s*charset=([^\\s]+)\\s*");
    Matcher m = p.matcher(contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
    return or(match, "ISO-8859-1");
  }

// makeNewComponent: func(Component) -> Component
//                   or Component
static Component awtReplaceComponent(final Component c, final Object makeNewComponent) {
  return (Component) swing(new Object() { Object get() { try {  
    Container parent = c.getParent();
    if (parent == null) return null;
    Component[] l = parent.getComponents();
    LayoutManager layout = parent.getLayout();
    if (!(layout instanceof BorderLayout || layout instanceof ViewportLayout))
      warn("awtReplaceComponent only tested for BorderLayout/ViewportLayout. Have: " + layout);
    int idx = indexOf(l, c);
    if (idx < 0) throw fail("component not found in parent");
    //print("idx: " + idx);
    //print("Parent: " + parent);
    Object constraints = callOpt(layout, "getConstraints", c);
    //print("Constraints: " + constraints);
    
    // remove
    parent.remove(c);
  
    // add new component  
    Component newComponent = (Component) (makeNewComponent instanceof Component ? makeNewComponent :  callF(makeNewComponent, c));
    parent.add(newComponent, constraints, idx);
    validateFrame(parent);
    return newComponent;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Container parent = c.getParent();\r\n    if (parent == null) null;\r\n    Component[..."; }});
}
static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }
static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); } static long l(File f) { return f == null ? 0 : f.length(); }

static int l(Object o) {
  return o instanceof String ? l((String) o)
    : o instanceof Map ? l((Map) o)
    : l((Collection) o); // incomplete
}


  static int l(MultiSet ms) { return ms == null ? 0 : ms.size(); }



static JFrame minFrameWidth(JFrame frame, int w) {
  if (frame != null && frame.getWidth() < w)
    frame.setSize(w, frame.getHeight());
  return frame;
}

static JFrame minFrameWidth(int w, JFrame frame) {
  return minFrameWidth(frame, w);
}

  static Object call(Object o) {
    return callFunction(o);
  }
  
  // varargs assignment fixer for a single string array argument
  static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] {arg});
  }
  
  static Object call(Object o, String method, Object... args) {
    try {
      if (o instanceof Class) {
        Method m = call_findStaticMethod((Class) o, method, args, false);
        m.setAccessible(true);
        return m.invoke(null, args);
      } else {
        Method m = call_findMethod(o, method, args, false);
        m.setAccessible(true);
        return m.invoke(o, args);
      }
    } catch (Exception e) {
      throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
    }
  }

  static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (!m.getName().equals(method)) {
          if (debug) System.out.println("Method name mismatch: " + method);
          continue;
        }

        if ((m.getModifiers() & Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
          continue;

        return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
  }

  static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (m.getName().equals(method) && call_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
  }

  private static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }


static Object swing(Object f) {
  return swingAndWait(f);
}

static <A> A swing(F0<A> f) {
  return (A) swingAndWait(f);
}
// TODO: all the fringe cases (?)
static <A> JPanel hvgrid(List<List<A>> components) {
  if (empty(components)) return new JPanel();
  int h = l(components), w = l(first(components));
  JPanel panel = new JPanel();
  panel.setLayout(new GridLayout(h, w));
  for (List<A> row : components)
    smartAdd(panel, row);
  return panel;  
}

static <A> JPanel hvgrid(List<List<A>> components, int gap) {
  JPanel panel = hvgrid(components);
  GridLayout g = (GridLayout) ( panel.getLayout());
  g.setHgap(gap);
  g.setVgap(gap);
  return panel;
}
static File getGlobalCache() {
  File file = new File(userHome(), ".tinybrain/snippet-cache");
  file.mkdirs();
  return file;
}

static boolean uniq3(Class<? extends Concept> c, Object... params) {
  return uniq2(c, params).b;
}
static IntRange intRangeFromStartAndLength(int start, int length) {
  return new IntRange(start, start+length);
}
static boolean isConceptFieldIndexed(Class<? extends Concept> c, String field) {
  return mainConcepts.getFieldIndex(c, field) != null;
}

static String copyTextToClipboard(String text) {
  StringSelection selection = new StringSelection(text);
  Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
  return text;
}
static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
// action can be Runnable or a function name
static JButton newButton(final String text, final Object action) {
  return swing(new F0<JButton>() { JButton get() { try { 
    JButton btn = new JButton(text);
    if (action != null)
      btn.addActionListener(actionListener(action));
    return btn;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JButton btn = new JButton(text);\r\n    if (action != null)\r\n      btn.addActionLi..."; }});
}
static <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
  return findConceptWhere(mainConcepts, c, params);
}

static <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  
  // indexed
  if (concepts.fieldIndices != null)
    for (int i = 0; i < l(params); i += 2) {
      IFieldIndex<A, Object> index = concepts.getFieldIndex(c, (String) params[i]);
      if (index != null)
        for (A x : index.getAll(params[i+1]))
          if (checkConceptFields(x, params)) return x;
    }
    
  // table scan
  for (A x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}

static Concept findConceptWhere(Concepts concepts, String c, Object... params) {
  for (Concept x : concepts.list(c)) if (checkConceptFields(x, params)) return x;
  return null;
}

// c = JComponent or something implementing swing()
static JComponent wrap(Object swingable) {
  if (swingable == null) return null;
  JComponent c = (JComponent) ( swingable instanceof JComponent ? swingable : callOpt(swingable, "swing"));
  if (c instanceof JTable || c instanceof JList
    || c instanceof JTextArea || c instanceof JEditorPane
    || c instanceof JTextPane || c instanceof JTree)
    return new JScrollPane(c);
  return c;
}

// action = runnable or method name
static void onUpdate(JComponent c, final Object r) {
  if (c instanceof JTextComponent)
    ((JTextComponent) c).getDocument().addDocumentListener(new DocumentListener() {
      public void insertUpdate(DocumentEvent e) {
        call(r);
      }
      public void removeUpdate(DocumentEvent e) {
        call(r);
      }
      public void changedUpdate(DocumentEvent e) {
        call(r);
      }
    });
  else if (c instanceof ItemSelectable) // JCheckBox and others
    ((ItemSelectable) c).addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        call(r);
      }
    });
  else
    print("Warning: onUpdate doesn't know " + getClassName(c));
}

static void onUpdate(List<? extends JComponent> l, Object r) {
  for (JComponent c : l)
    onUpdate(c, r);
}
static JTextArea newTypeWriterTextArea() {
  JTextArea textArea = new JTextArea();
  textArea.setFont(typeWriterFont());
  return textArea;
}

static JTextArea newTypeWriterTextArea(String text) {
  JTextArea textArea = newTypeWriterTextArea();
  textArea.setText(text);
  return textArea;
}
static Object first(Object list) {
  return empty((List) list) ? null : ((List) list).get(0);
}

static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }

static String md5(String text) { try {
  if (text == null) return "-";
  return bytesToHex(md5_impl(text.getBytes("UTF-8"))); // maybe different than the way PHP does it...
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(byte[] data) {
  if (data == null) return "-";
  return bytesToHex(md5_impl(data));
}

static MessageDigest md5_md;

/*static byte[] md5_impl(byte[] data) ctex {
  if (md5_md == null)
    md5_md = MessageDigest.getInstance("MD5");
  return ((MessageDigest) md5_md.clone()).digest(data);
}*/

static byte[] md5_impl(byte[] data) { try {
  return MessageDigest.getInstance("MD5").digest(data);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(File file) { try {
  return md5(loadBinaryFile(file));
} catch (Exception __e) { throw rethrow(__e); } }
static boolean frameTooSmall(JFrame frame) {
  return frame.getWidth() < 100 || frame.getHeight() < 50;
}
static <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
  if (c == null) return null;
  { swingAndWait(new Runnable() { public void run() { try { 
    String s = nullIfEmpty(str(toolTip));
    if (neq(s, c.getToolTipText()))
      c.setToolTipText(s);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "String s = nullIfEmpty(str(toolTip));\r\n    if (neq(s, c.getToolTipText()))\r\n    ..."; }}); }
  return c;
}
static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}


static <A, B> B pcallF(F1<A, B> f, A a) { try {
  return f == null ? null : f.get(a);
} catch (Throwable __e) { return null; } }

static JPanel jFullCenter(Component c) {
  JPanel panel = new JPanel(new GridBagLayout());
  panel.add(c);
  return panel;
}
static <A> ArrayList<A> toList(A[] a) { return asList(a); }
static ArrayList<Integer> toList(int[] a) { return asList(a); }
static <A> ArrayList<A> toList(Set<A> s) { return asList(s); }
static <A> ArrayList<A> toList(Iterable<A> s) { return asList(s); }
static <A> A oneOf(List<A> l) {
  return l.isEmpty() ? null : l.get(new Random().nextInt(l.size()));
}

static char oneOf(String s) {
  return empty(s) ? '?' : s.charAt(random(l(s)));
}

static String oneOf(String... l) {
  return oneOf(asList(l));
}
static RuntimeException asRuntimeException(Throwable t) {
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static boolean jmatch(String pat, String s) {
  return jmatch(pat, s, null);
}

static boolean jmatch(String pat, String s, Matches matches) {
  if (s == null) return false;
  return jmatch(pat, javaTok(s), matches);
}

static boolean jmatch(String pat, List<String> toks) {
  return jmatch(pat, toks, null);
}

static boolean jmatch(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = javaTok(pat);
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}
static Object mc() {
  return getMainClass();
}
// supports the usual quotings (', ", variable length double brackets)
static boolean isQuoted(String s) {
  if (s.startsWith("'") || s.startsWith("\"")) return true;
  if (!s.startsWith("[")) return false;
  int i = 1;
  while (i < s.length() && s.charAt(i) == '=') ++i;
  return i < s.length() && s.charAt(i) == '[';
  //return Pattern.compile("^\\[=*\\[").matcher(s).find();
}
static boolean neq(Object a, Object b) {
  return !eq(a, b);
}
static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  for (int i = startIndex; i < l(l); i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  if (x == null) return -1;
  for (int i = 0; i < l(x); i++)
    if (eq(x[i], a))
      return i;
  return -1;
}
static List<List<String>> html_contentsOfLIs(List<String> tok) {
  return map("contentsOfContainerTag", html_findLIs(tok));
}

static List<List<String>> html_contentsOfLIs(String html) {
  return html_contentsOfLIs(htmlTok(html));
}
static int trimIndexRight(String s, int i) {
  while (i < l(s) && s.charAt(i) == ' ') ++i;
  return i;
}
static Map mapKeysAndValues_litOrderedMap(Object f, Map map) {
  return mapKeysAndValues_litOrderedMap(f, f, map);
}

static Map mapKeysAndValues_litOrderedMap(Object fKey, Object fValue, Map map) {
  LinkedHashMap m = new LinkedHashMap();
  for (Object key : keys(map))
    m.put(callF(fKey, key), callF(fValue, map.get(key)));
  return m;
}
static String trimDropPrefixTrim(String prefix, String s) {
  return trim(dropPrefix(prefix, trim(s)));
}
static int withMargin_defaultWidth = 6;

static JPanel withMargin(Component c) {
  JPanel p = new JPanel(new BorderLayout());
  int w = withMargin_defaultWidth;
  p.setBorder(BorderFactory.createEmptyBorder(w, w, w, w));
  p.add(c);
  return p;
}
static JButton setButtonImage(BufferedImage img, JButton btn) {
  btn.setIcon(imageIcon(img));
  return btn;
}
static long psI(String snippetID) {
  return parseSnippetID(snippetID);
}
static boolean eq(Object a, Object b) {
  return a == null ? b == null : a == b || a.equals(b);
}
static JTextField onEnter(JTextField tf, final Object action) {
  if (action == null || tf == null) return tf;
  tf.addActionListener(actionListener(action));
  return tf;
}

static JButton onEnter(JButton btn, final Object action) {
  if (action == null || btn == null) return btn;
  btn.addActionListener(actionListener(action));
  return btn;
}

static JList onEnter(JList list, final Object action) {
  list.addKeyListener(new KeyAdapter() {
    public void keyReleased(KeyEvent ke) {
      if (ke.getKeyCode() == KeyEvent.VK_ENTER)
        pcallF(action);
    }
  });
  return list;
}

static Map similarEmptyMap(Map m) {
  if (m instanceof TreeMap) return new TreeMap();
  if (m instanceof LinkedHashMap) return new LinkedHashMap();
  
  // default to a hash map
  return new HashMap();
}
/** writes safely (to temp file, then rename) */
static void saveTextFile(String fileName, String contents) throws IOException {
  CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  try {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists()) try {
        String saveName = tempFileName + ".saved." + now();
        copyFile(tempFile, new File(saveName));
      } catch (Throwable e) { printStackTrace(e); }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(contents);
      printWriter.close();
    }
    
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
  
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
  } finally {
    action.done();
  }
}

static void saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
} catch (Exception __e) { throw rethrow(__e); } }

volatile static boolean conceptsAndBot_running;

static void conceptsAndBot() {
  conceptsAndBot(null);
}

static void conceptsAndBot(Integer autoSaveInterval) {
  if (conceptsAndBot_running) return;
  conceptsAndBot_running = true;
  
  ensureBotIsNotAlreadyRunning(dbBotStandardName());
  if (autoSaveInterval != null)
    loadAndAutoSaveConcepts(autoSaveInterval);
  else
    loadAndAutoSaveConcepts();
  dbBot();
}
static String getClassName(Object o) {
  return o == null ? "null" : o.getClass().getName();
}
static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static String[] drop(int n, String[] a) {
  n = Math.min(n, a.length);
  String[] b = new String[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}

static Object[] drop(int n, Object[] a) {
  n = Math.min(n, a.length);
  Object[] b = new Object[a.length-n];
  System.arraycopy(a, n, b, 0, b.length);
  return b;
}
static Object callOpt(Object o) {
  if (o == null) return null;
  return callF(o);
}

static Object callOpt(Object o, String method, Object... args) {
  try {
    if (o == null) return null;
    if (o instanceof Class) {
      Method m = callOpt_findStaticMethod((Class) o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(null, args);
    } else {
      Method m = callOpt_findMethod(o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(o, args);
    }
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

private static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}


static JFrame getFrame(Object o) {
  if (o instanceof ButtonGroup) o = first(buttonsInGroup((ButtonGroup) o));
  if (!(o instanceof Component)) return null;
  Component c = (Component) o;
  while (c != null) {
    if (c instanceof JFrame) return (JFrame) c;
    c = c.getParent();
  }
  return null;
}
static List emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}
public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}
static void frameStandardSize(JFrame frame) {
  frame.setBounds(300, 100, 500, 400);
}
static int hstackWithSpacing_spacing = 10;

// first part can be spacing value
static JPanel hstackWithSpacing(Object... parts) {
  int spacing = hstackWithSpacing_spacing;
  int i = 0;
  if (first(parts) instanceof Integer) {
    spacing = toInt(first(parts));
    ++i;
  }
  JPanel panel = new JPanel(new GridBagLayout());
  GridBagConstraints gbc = new GridBagConstraints();
  gbc.weighty = 1;
  gbc.fill = GridBagConstraints.VERTICAL;
  gbc.gridheight = GridBagConstraints.REMAINDER;
  for (; i < l(parts); i++) {
    if (i != 0)
      panel.add(Box.createRigidArea(new Dimension(spacing, 0)), gbc);
    panel.add(wrapForSmartAdd(parts[i]), gbc);
  }
  gbc.weightx = 1;
  panel.add(Box.createRigidArea(new Dimension(0, 0)), gbc);
  return panel;
}
static Object[] toObjectArray(Collection c) {
  List l = asList(c);
  return l.toArray(new Object[l.size()]);
}

static boolean containsNulls(Collection c) {
  return contains(c, null);
}
static String showFormSubmitButtonName() {
  return "Submit";
}
  public static String unquote(String s) {
    if (s == null) return null;
    if (s.startsWith("[")) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i+1, s.length()-i-1);
      }
    }
    
    if ((s.startsWith("\"") || s.startsWith("\'")) && s.length() > 1) {
      int l = s.endsWith(substring(s, 0, 1)) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\\':
              ch = '\\';
              break;
          case 'b':
              ch = '\b';
              break;
          case 'f':
              ch = '\f';
              break;
          case 'n':
              ch = '\n';
              break;
          case 'r':
              ch = '\r';
              break;
          case 't':
              ch = '\t';
              break;
          case '\"':
              ch = '\"';
              break;
          case '\'':
              ch = '\'';
              break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();   
    }
    
    return s; // not quoted - return original
  }
static JFrame showPackedFrame(String title, Component contents) {
  return packFrame(showFrame(title, contents));
}

static JFrame showPackedFrame(Component contents) {
  return packFrame(showFrame(contents));
}
  public static String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }
  
  public static String loadTextFile(String fileName, String defaultContents) {
    try {
      if (!new File(fileName).exists())
        return defaultContents;
  
      FileInputStream fileInputStream = new FileInputStream(fileName);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
      return loadTextFile(inputStreamReader);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
  
  public static String loadTextFile(File fileName) {
    return loadTextFile(fileName, null);
  }

  public static String loadTextFile(File f, String defaultContents) {
    return f == null ? defaultContents : loadTextFile(f.getPath(), defaultContents);
  }
  
  public static String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer)))
        builder.append(buffer, 0, n);
        
    } finally {
      reader.close();
    }
    return builder.toString();
  }
static boolean isEmpty(Collection c) {
  return c == null || c.isEmpty();
}

static boolean isEmpty(CharSequence s) {
  return s == null || s.length() == 0;
}

static boolean isEmpty(Object[] a) {
  return a == null || a.length == 0;
}

static boolean isEmpty(Map map) {
  return map == null || map.isEmpty();
}
static void revalidateFrame(Component c) {
  revalidate(getFrame(c));
}
static <A, B> Pair<A, B> pair(A a, B b) {
  return new Pair(a, b);
}
static int parseInt(String s) {
  return empty(s) ? 0 : Integer.parseInt(s);
}
static volatile StringBuffer local_log = new StringBuffer(); // not redirected
static volatile StringBuffer print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;
//static int print_maxLineLength = 0; // 0 = unset

static boolean print_silent; // total mute if set

static Object print_byThread_lock = new Object();
static volatile ThreadLocal<F1<String, Boolean>> print_byThread; // special handling by thread

static void print() {
  print("");
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  if (print_byThread != null) {
    F1<String, Boolean> f = print_byThread.get();
    if (f != null)
      if (isFalse(f.get(s))) return;
  }

  print_raw(s);
}

static void print_raw(String s) {
  s = fixNewLines(s);
  // TODO if (print_maxLineLength != 0)
  StringBuffer loc = local_log;
  StringBuffer buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  System.out.print(s);
}

static void print(long l) {
  print(String.valueOf(l));
}

static void print(char c) {
  print(String.valueOf(c));
}

static void print_append(StringBuffer buf, String s, int max) {
  synchronized(buf) {
    buf.append(s);
    max /= 2;
    if (buf.length() > max) try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
  }
}
static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(b);
}


  static boolean startsWith(String a, String b, Matches m) {
    if (!startsWith(a, b)) return false;
    m.m = new String[] {substring(a, l(b))};
    return true;
  }


static boolean startsWith(List a, List b) {
  if (a == null || l(b) > l(a)) return false;
  for (int i = 0; i < l(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}




static Font typeWriterFont() {
  return typeWriterFont(14);
}
  
static Font typeWriterFont(int size) {
  return new Font("Courier", Font.PLAIN, size);
}
static void ensureBotIsNotAlreadyRunning(String name) {
  if (hasBot(name))
    throw fail("Bot already running [" + name + "]");
}
static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

static class CriticalAction {
  String description;
  
  CriticalAction() {}
  CriticalAction(String description) {
  this.description = description;}
  
  void done() {
    beginCriticalAction_inFlight.remove(this);
  }
}

static CriticalAction beginCriticalAction(String description) {
  ping();
  CriticalAction c = new CriticalAction(description);
  beginCriticalAction_inFlight.add(c);
  return c;
}

static void cleanMeUp_beginCriticalAction() {
  int n = 0;
  while (nempty(beginCriticalAction_inFlight)) {
    int m = l(beginCriticalAction_inFlight);
    if (m != n) {
      n = m;
      try {
        print("Waiting for " + n(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
      } catch (Throwable __e) { printStackTrace2(__e); }
    }
    sleepInCleanUp(10);
  }
}
static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static List<String> htmlTok(String s) {
  return htmlcoarsetok(s);
}
static <A extends Window> A disposeWindowAfter(int delay, final A w) {
  if (w != null)
    swingLater(delay, new Runnable() { public void run() { try { 
      w.dispose();
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "w.dispose();"; }});
  return w;
}
static final HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) return callMC_value.invoke(null, args);

  List<Method> m;
  synchronized(callMC_cache) {
    m = callMC_cache.get(method);
  }
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    return me.invoke(null, args);
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return me.invoke(null, args);
  }
  throw fail("No method called " + method + " with matching arguments found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static void callMC_makeCache() {
  synchronized(callMC_cache) {
    callMC_cache.clear();
    Class _c = (Class) mc(), c = _c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods())
        if ((m.getModifiers() & Modifier.STATIC) != 0) {
          m.setAccessible(true);
          multiMapPut(callMC_cache, m.getName(), m);
        }
      c = c.getSuperclass();
    }
  }
}
static List<List<String>> html_findLIs(List<String> tok) {
  return findContainerTag(tok, "li");
}
static boolean isRunnableX(Object o) {
  if (o == null) return false;
  if (o instanceof String) return hasMethod(mc(), (String) o);
  return o instanceof Runnable || hasMethod(o, "get");
}
static JTextArea wrappedTextArea(JTextArea ta) {
  ta.setLineWrap(true);
  ta.setWrapStyleWord(true);
  return ta;
}

static JTextArea wrappedTextArea() {
  return wrappedTextArea(new JTextArea());
}

static JTextArea wrappedTextArea(String text) {
  JTextArea ta = wrappedTextArea();
  ta.setText(text);
  return ta;
}
static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}
static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}
static Throwable printStackTrace(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

static void printStackTrace(String indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace(e));
}
static JPanel smartAdd(JPanel panel, List parts) {
  for (Object o : parts)
    panel.add(wrapForSmartAdd(o));
  return panel;
}

static JPanel smartAdd(JPanel panel, Object... parts) {
  return smartAdd(panel, asList(parts));
}

static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}
static String fixNewLines(String s) {
  return s.replace("\r\n", "\n").replace("\r", "\n");
}
static void showConsole() {
  showFrame(consoleFrame());
}
static String dropSuffixIgnoreCase(String suffix, String s) {
  return ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static List<AbstractButton> buttonsInGroup(ButtonGroup g) {
  if (g == null) return ll();
  return asList(g.getElements());
}
static ActionListener actionListener(final Object runnable) {
  if (runnable instanceof ActionListener) return (ActionListener) runnable;
  return new java.awt.event.ActionListener() { public void actionPerformed(java.awt.event.ActionEvent _evt) { pcallF(runnable); }};
}
static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}
static String hideCredentials(String url) {
  return url.replaceAll("&_pass=[^&]*", "&_pass=<hidden>");
}
static Rectangle rectangleUnion(Rectangle a, Rectangle b) {
  return a == null ? b : b == null ? a : a.union(b);
}
static <A> List<A> reversedList(Collection<A> l) {
  List<A> x = cloneList(l);
  Collections.reverse(x);
  return x;
}
static void setHeaders(URLConnection con) throws IOException {
  String computerID = getComputerID_quick();
  if (computerID != null) try {
    con.setRequestProperty("X-ComputerID", computerID);
    con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
  } catch (Throwable e) {
    //printShortException(e);
  }
}
static Class getMainClass() {
  return main.class;
}

static Class getMainClass(Object o) { try {
  return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
} catch (Exception __e) { throw rethrow(__e); } }
static String exceptionToStringShort(Throwable e) {
  e = getInnerException(e);
  String msg = unnull(e.getMessage());
  if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
    return baseClassName(e) + ": " + msg;
  else
    return msg;
}
static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  throw fail(getClassName(o));
}
static <A extends Concept> Pair<A, Boolean> uniq2(Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhere(c, params);
  if (x == null) {
    x = nuObject(c);
    csetAll(x, params);
    return pair(x, true);
  }
  return pair(x, false);
}
// layouter: voidfunc(Container) or func(Container) -> Dimension
// (return value is preferred size)
static LayoutManager layoutManagerFromFunction(final Object layouter) {
  return new AbstractLayoutManager() {
    public void layoutContainer(Container parent) {
      Dimension size = (Dimension) ( callF(layouter, parent));
      if (size != null) preferredSize = size;
    }
  };
}
// match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)

static String[] match2(List<String> pat, List<String> tok) {
  // standard case (no ...)
  int i = pat.indexOf("...");
  if (i < 0) return match2_match(pat, tok);
  
  pat = new ArrayList<String>(pat); // We're modifying it, so copy first
  pat.set(i, "*");
  while (pat.size() < tok.size()) {
    pat.add(i, "*");
    pat.add(i+1, ""); // doesn't matter
  }
  
  return match2_match(pat, tok);
}

static String[] match2_match(List<String> pat, List<String> tok) {
  List<String> result = new ArrayList<String>();
  if (pat.size() != tok.size()) {
    
    return null;
  }
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(i);
    
    if (eq(p, "*"))
      result.add(t);
    else if (!equalsIgnoreCase(unquote(p), unquote(t))) // bold change - match quoted and unquoted now
      return null;
  }
  return result.toArray(new String[result.size()]);
}

static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static boolean empty(Collection c) {
  return isEmpty(c);
}

static boolean empty(String s) {
  return isEmpty(s);
}

static boolean empty(Map map) {
  return map == null || map.isEmpty();
}

static boolean empty(Object[] o) {
  return o == null || o.length == 0;
}

static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  throw fail("unknown type for 'empty': " + getType(o));
}

static boolean empty(float[] a) { return a == null || a.length == 0; }
  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }

static URLConnection openConnection(URL url) { try {
  ping();
  return url.openConnection();
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isFalse(Object o) {
  return eq(false, o);
}
static boolean hasMethod(Object o, String method, Object... args) {
  return findMethod(o, method, args) != null;
}
static boolean warn_on = true;

static void warn(String s) {
  if (warn_on)
    print("Warning: " + s);
}

static void warn(String s, List<String> warnings) {
  warn(s);
  if (warnings != null)
    warnings.add(s);
}
static void revalidate(Component c) {
  if (c == null || !c.isShowing()) return;
  // magic combo to actually relayout and repaint
  c.revalidate();
  c.repaint();
}
static void standardTitlePopupMenu(final JFrame frame) {
  // standard right-click behavior on titles
  if (isSubstanceLAF())
    titlePopupMenu(frame,
      new Object() { void get(JPopupMenu menu) { try { 
        boolean alwaysOnTop = frame.isAlwaysOnTop();
        menu.add(jmenuItem("Restart Program", "restart"));
        menu.add(jmenuItem("Duplicate Program", "duplicateThisProgram"));
        menu.add(jmenuItem("Show Console", "showConsole"));
        menu.add(jCheckBoxMenuItem("Always On Top", alwaysOnTop, new Runnable() { public void run() { try { 
          toggleAlwaysOnTop(frame) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "toggleAlwaysOnTop(frame)"; }}));
        menu.add(jMenuItem("Shoot Window", new Runnable() { public void run() { try {  shootWindowGUI_external(frame, 500) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "shootWindowGUI_external(frame, 500)"; }}));
       } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "bool alwaysOnTop = frame.isAlwaysOnTop();\r\n        menu.add(jmenuItem(\"Restart P..."; }});
}
static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}

static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  FileOutputStream f = new // Line break for ancient translator
    FileOutputStream(path, append);
  callJavaX("registerIO", f, path, true);
  return f;
}
static boolean checkConceptFields(Concept x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(cget(x, (String) data[i]), deref(data[i+1])))
      return false;
  return true;
}
static boolean containsIgnoreCase(List<String> l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String[] l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String s, char c) {
  return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
}

static boolean containsIgnoreCase(String a, String b) {
  return indexOfIgnoreCase(a, b) >= 0;
}
static void validateFrame(Component c) {
  revalidateFrame(c);
}
public static byte[] loadBinaryFile(String fileName) {
 try {
  if (!new File(fileName).exists())
    return null;

  FileInputStream in = new FileInputStream(fileName);

  byte buf[] = new byte[1024];
  ByteArrayOutputStream out = new ByteArrayOutputStream();
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    out.write(buf, 0, l);
  }
  in.close();
  return out.toByteArray();
 } catch (IOException e) { throw new RuntimeException(e); }
}

public static byte[] loadBinaryFile(File file) {
  return loadBinaryFile(file.getPath());
}

static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static String urlencode(String x) {
  try {
    return URLEncoder.encode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}
static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(r);
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() { public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}
static int packFrame_minw = 150, packFrame_minh = 50;

static JFrame packFrame(final Component c) {
  return (JFrame) swing(new Object() { Object get() { try { 
    JFrame frame = getFrame(c);
    if (frame == null) return null;
    frame.pack();
    int maxW = getScreenWidth()-50, maxH = getScreenHeight()-50;
    frame.setSize(
      min(maxW, max(frame.getWidth(), packFrame_minw)),
      min(maxH, max(frame.getHeight(), packFrame_minh)));
    return frame;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "JFrame frame = getFrame(c);\r\n    if (frame == null) null;\r\n    frame.pack();\r\n  ..."; }});
}

static JFrame packFrame(ButtonGroup g) {
  return packFrame(getFrame(g));
}
static JMenuItem jmenuItem(String text, final Object r) {
  JMenuItem mi = new JMenuItem(text);
  mi.addActionListener(actionListener(r));
  return mi;
}
static <A> List<A> cloneList(Collection<A> l) {
  if (l == null) return new ArrayList();
  // assume collection's mutex is equal to collection, which will be true unless you explicitly pass a mutex to synchronizedList() which no one ever does.
  synchronized(l) {
    return new ArrayList<A>(l);
  }
}
static String standardCredentialsUser() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/username")));
}
static Map litmap(Object... x) {
  TreeMap map = new TreeMap();
  litmap_impl(map, x);
  return map;
}

static void litmap_impl(Map map, Object... x) {
  for (int i = 0; i < x.length-1; i += 2)
    if (x[i+1] != null)
      map.put(x[i], x[i+1]);
}
static RuntimeException fail() {
  throw new RuntimeException("fail");
}

static RuntimeException fail(Throwable e) {
  throw asRuntimeException(e);
}

static RuntimeException fail(Object msg) {
  throw new RuntimeException(String.valueOf(msg));
}

static RuntimeException fail(String msg) {
  throw new RuntimeException(unnull(msg));
}
 
static RuntimeException fail(String msg, Throwable innerException) {
  throw new RuntimeException(msg, innerException);
}

public static void copyFile(File src, File dest) { try {
  mkdirsForFile(dest);
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static volatile boolean ping_pauseAll;
static int ping_sleep = 100; // poll pauseAll flag every 100
static volatile boolean ping_anyActions;
static Map<Thread, Object> ping_actions = synchroMap(new WeakHashMap());

// always returns true
static boolean ping() {
  if (ping_pauseAll || ping_anyActions) ping_impl();
  return true;
}

// returns true when it slept
static boolean ping_impl() { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  if (ping_anyActions) {
    Object action;
    synchronized(mc()) {
      action = ping_actions.get(currentThread());
      if (action instanceof Runnable)
        ping_actions.remove(currentThread());
      if (ping_actions.isEmpty()) ping_anyActions = false;
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }
  
  return false;
} catch (Exception __e) { throw rethrow(__e); } }
static <A extends Component> A setFrameTitle(A c, String title) {
  JFrame f = getFrame(c);
  if (f == null)
    showFrame(title, c);
  else
    f.setTitle(title);
  return c;
}

static <A extends Component> A setFrameTitle(String title, A c) {
  return setFrameTitle(c, title);
}

// magically find a field called "frame" in main class :-)
static JFrame setFrameTitle(String title) {
  Object f = getOpt(mc(), "frame");
  if (f instanceof JFrame)
    return setFrameTitle((JFrame) f, title);
  return null;
}
static void makeDependent(Object c) {
  if (c == null) return;
  assertTrue("Not a class", c instanceof Class);
  hotwire_classes.add(new WeakReference(c));
  
  Object local_log = getOpt(mc(), "local_log");
  if (local_log != null)
    setOpt(c, "local_log", local_log);
}

static String _userHome;
static String userHome() {
  if (_userHome == null) {
    if (isAndroid())
      _userHome = "/storage/sdcard0/";
    else
      _userHome = System.getProperty("user.home");
    //System.out.println("userHome: " + _userHome);
  }
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}
static Component wrapForSmartAdd(Object o) {
  if (o == null) return new JPanel();
  if (o instanceof String) return jlabel((String) o);
  return wrap(o);
}
static List map(Iterable l, Object f) {
  return map(f, l);
}

static List map(Object f, Iterable l) {
  List x = new ArrayList();
  Object mc = mc();
  for (Object o : unnull(l))
    x.add(callF(f, o));
  return x;
}

static List map(Object f, Object[] l) {
  return map(f, asList(l));
}

static List map(Object f, Map map) {
  return map(map, f);
}

static List map(Map map, Object f) {
  List x = new ArrayList();
  for (Object _e : map.entrySet()) {
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}
static int iround(double d) {
  return (int) Math.round(d);
}
static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}
static String programTitle() {
  return getProgramName();
}
static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { printStackTrace2(__e); }
  return null;
}
static final boolean loadPageThroughProxy_enabled = false;

static String loadPageThroughProxy(String url) {
  return null;
}
static void onClick(JComponent c, final Object runnable) {
  c.addMouseListener(new MouseAdapter() {
    public void mouseClicked(MouseEvent e) {
      callF(runnable, e);
    }
  });
}

// re-interpreted for buttons
static void onClick(JButton btn, final Object runnable) {
  onEnter(btn, runnable);
}

static <A extends JTextComponent> A jenableUndoRedo(A textcomp) {
  final UndoManager undo = new UndoManager();
  textcomp.getDocument().addUndoableEditListener(new UndoableEditListener() {
    public void undoableEditHappened(UndoableEditEvent evt) {
      undo.addEdit(evt.getEdit());
    }
  });
  
  textcomp.getActionMap().put("Undo", abstractAction("Undo", new Runnable() { public void run() { try { 
    if (undo.canUndo()) undo.undo()
  ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (undo.canUndo()) undo.undo()"; }}));
  textcomp.getActionMap().put("Redo", abstractAction("Redo", new Runnable() { public void run() { try { 
    if (undo.canRedo()) undo.redo()
  ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (undo.canRedo()) undo.redo()"; }}));
  textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
  textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
  return textcomp;
}
// extended over Class.isInstance() to handle primitive types
static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}
static JWindow showWindow(Component c) {
  JWindow w = new JWindow();
  w.add(wrap(c));
  return w;
}
static Object nuObject(String className, Object... args) { try {
  return nuObject(Class.forName(className), args);
} catch (Exception __e) { throw rethrow(__e); } }

// too ambiguous - maybe need to fix some callers
/*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/

static <A> A nuObject(Class<A> c, Object... args) { try {
  Constructor m = nuObject_findConstructor(c, args);
  m.setAccessible(true);
  return (A) m.newInstance(args);
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObject_findConstructor(Class c, Object... args) {
  for (Constructor m : c.getDeclaredConstructors()) {
    if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
      continue;
    return m;
  }
  throw new RuntimeException("Constructor " + c.getName() + getClasses(args) + " not found");
}

 static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }
static <A> void scanForComponents(Component c, Class<A> theClass, List<A> l) {
  if (theClass.isInstance(c))
    l.add((A) c);
  if (c instanceof Container)
  for (Component comp : ((Container) c).getComponents())
    scanForComponents(comp, theClass, l);
}
static <A> List<A> sortedByField(Collection<A> c, final String field) {
  List<A> l = new ArrayList(c);
  sort(l, new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(getOpt(a, field), getOpt(b, field));
    }
  });
  return l;
}

static <A> List<A> sortedByField(String field, Collection<A> c) {
  return sortedByField(c, field);
}
static String nullIfEmpty(String s) {
  return isEmpty(s) ? null : s;
}
static void sleepSeconds(double s) {
  if (s > 0) sleep(round(s*1000));
}
static Android3 dbBot() {
  return dbBot(dbBotStandardName());
}

static Android3 dbBot(String name) {
  ensureBotIsNotAlreadyRunning(name);
  assertNotNull(mainConcepts);
  return methodsBot2(name, mainConcepts, exposedDBMethods, mainConcepts.lock);
}
static String dbBotStandardName() {
  return dbBotName(getDBProgramID()) + ".";
}
static ImageIcon imageIcon(String imageID) { try {
  return new ImageIcon(loadBinarySnippet(imageID).toURI().toURL());
} catch (Exception __e) { throw rethrow(__e); } }

static ImageIcon imageIcon(BufferedImage img) {
  return new ImageIcon(img);
}


static <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
  if (l(params) == 1)
    params = new Object[] { singleFieldName(c), params[0] };
  else
    warnIfOddCount(params);
  return params;
}

static Class<?> hotwire(String src) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    // ret hotwire_overInternalBot(src);
    Class c = (Class) ( call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
  }
}
static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt((String) o);
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}
static <A> A or(A a, A b) {
  return a != null ? a : b;
}
static JPanel smartAddWithLayout(JPanel panel, Object layout, List parts) {
  for (Object o : parts)
    panel.add(wrapForSmartAdd(o), layout);
  return panel;
}

static JPanel smartAddWithLayout(JPanel panel, Object layout, Object... parts) {
  return smartAddWithLayout(panel, layout, asList(parts));
}

static String dropSuffix(String suffix, String s) {
  return s.endsWith(suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static String standardCredentialsPass() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/userpass")));
}
static int moveToTopRightCorner_inset = 20;

static <A extends Component> A moveToTopRightCorner(A a) {
  Window w = getWindow(a);
  if (w != null)
    w.setLocation(getScreenSize().width-w.getWidth()-moveToTopRightCorner_inset, moveToTopRightCorner_inset);
  return a;
}



static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
static boolean equalsIgnoreCase(String a, String b) {
  return a == null ? b == null : a.equalsIgnoreCase(b);
}

static boolean equalsIgnoreCase(char a, char b) {
  if (a == b) return true;
  char u1 = Character.toUpperCase(a);
  char u2 = Character.toUpperCase(b);
  if (u1 == u2) return true;
  return Character.toLowerCase(u1) == Character.toLowerCase(u2);
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
static Thread currentThread() {
  return Thread.currentThread();
}
static String getType(Object o) {
  return getClassName(o);
}
static File loadBinarySnippet(String snippetID) { try {
  long id = parseSnippetID(snippetID);
  File f = DiskSnippetCache_getLibrary(id);
  if (f == null)
    f = loadDataSnippetToFile(snippetID);
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static Object cget(Object c, String field) {
  Object o = getOpt(c, field);
  if (o instanceof Concept.Ref) return ((Concept.Ref) o).get();
  return o;
}
static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }
// menuMaker = voidfunc(JPopupMenu)
static void titlePopupMenu(final Component c, final Object menuMaker) {
  swingNowOrLater(new Runnable() { public void run() { try { 
    if (!isSubstanceLAF())
      print("Can't add title right click!");
    else {
      JComponent titleBar = getTitlePaneComponent(getFrame(c));
      componentPopupMenu(titleBar, menuMaker);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!isSubstanceLAF())\n      print(\"Can't add title right click!\");\n    else {\n ..."; }});
}
static Class __javax;

static Class getJavaX() {
  return __javax;
}
static Throwable getInnerException(Throwable e) {
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}
static int getScreenHeight() {
  return getScreenSize().height;
}
static String getStackTrace(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return writer.toString();
}
static String dbBotName(String progID) {
  return fsI(progID) + " Concepts";
}
static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}
// tok must come from htmlTok
// returns all container tags found (including content) as CNC
// honors nested tags correctly
static List<List<String>> findContainerTag(List<String> tok, String tag) {
  List < List < String > > l = new ArrayList();
  for (int i = 1; i < l(tok); i += 2)
    if (isOpeningTag(tok.get(i), tag)) {
      int j, level = 1;
      for (j = i+2; j < tok.size(); j += 2)
        if (isOpeningTag(tok.get(j), tag))
          ++level;
        else if (isTag(tok.get(j), "/" + tag)) {
          --level;
          if (level == 0) {
            l.add(tok.subList(i-1, j+2)); // actual CNC
            break;
          }
        }
      i = j;
    }
  return l;
}

static List<List<String>> findContainerTag(String html, String tag) {
  return findContainerTag(htmlTok(html), tag);
}

public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) // is null if file is in current dir
    dir.mkdirs();
  return file;
}

static Window getWindow(Object o) {
  if (!(o instanceof Component)) return null;
  Component c = (Component) o;
  while (c != null) {
    if (c instanceof Window) return (Window) c;
    c = c.getParent();
  }
  return null;
}
static void warnIfOddCount(Object... list) {
  if (odd(l(list)))
    printStackTrace("Odd list size: " + list);
}
static Object callJavaX(String method, Object... args) {
  return callOpt(getJavaX(), method, args);
}
  static Method findMethod(Object o, String method, Object... args) {
    try {
      if (o == null) return null;
      if (o instanceof Class) {
        Method m = findMethod_static((Class) o, method, args, false);
        if (m == null) return null;
        m.setAccessible(true);
        return m;
      } else {
        Method m = findMethod_instance(o, method, args, false);
        if (m == null) return null;
        m.setAccessible(true);
        return m;
      }
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  static Method findMethod_static(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (!m.getName().equals(method)) {
          if (debug) System.out.println("Method name mismatch: " + method);
          continue;
        }

        if ((m.getModifiers() & Modifier.STATIC) == 0 || !findMethod_checkArgs(m, args, debug))
          continue;

        return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static Method findMethod_instance(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (m.getName().equals(method) && findMethod_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    return null;
  }

  static boolean findMethod_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }


static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static boolean eqic(String a, String b) {
  if ((a == null) != (b == null)) return false;
  if (a == null) return true;
  return a.equalsIgnoreCase(b);
}
static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    return;
  }
  
  Field f = map.get(field);
  if (f != null)
    smartSet(f, o, value); // possible improvement: skip setAccessible
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) {
  try {
    Field f = getOpt_findField(o.getClass(), field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object getOpt(Class c, String field) {
  try {
    if (c == null) return null;
    Field f = getOpt_findStaticField(c, field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static JFrame consoleFrame() {
  return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
}
static String getComputerID_quick() {
  File file = new File(userHome(), ".tinybrain/computer-id");
  return assertNempty(loadTextFile(file.getPath(), null));
}
static void printIndent(Object o) {
  print(indentx(str(o)));
}

static void printIndent(String indent, Object o) {
  print(indentx(indent, str(o)));
}

static void printIndent(int indent, Object o) {
  print(indentx(indent, str(o)));
}
static void swingLater(long delay, final Object r) {
  javax.swing.Timer timer = new javax.swing.Timer(toInt(delay), actionListener(r));
  timer.setRepeats(false);
  timer.start();
}

static void swingLater(Object r) {
  SwingUtilities.invokeLater(toRunnable(r));
}

static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isSubstanceLAF() {
  return substanceLookAndFeelEnabled();
}
static boolean endsWithIgnoreCase(String a, String b) {
  return a != null && l(a) >= l(b) && a.regionMatches(true, l(a)-l(b), b, 0, l(b));
}
static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(String a, String b) {
  return a == null ? b == null ? 0 : -1 : a.compareTo(b);
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}
static boolean _inCore() {
  return false;
}
static int getScreenWidth() {
  return getScreenSize().width;
}
static void assertTrue(Object o) {
  assertEquals(true, o);
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static String baseClassName(String className) {
  return substring(className, className.lastIndexOf('.')+1);
}

static String baseClassName(Object o) {
  return baseClassName(getClassName(o));
}
static List<Class> getClasses(Object[] array) {
  List<Class> l = new ArrayList();
  for (Object o : array) l.add(_getClass(o));
  return l;
}
static boolean endsWithLetter(String s) {
  return nempty(s) && isLetter(last(s));
}
static String getDBProgramID_id;

static String getDBProgramID() {
  return nempty(getDBProgramID_id) ? getDBProgramID_id : programID();
}
static long parseLong(String s) {
  if (s == null) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}
// works on lists and strings and null

static int indexOfIgnoreCase(Object a, Object b) {
  if (a == null) return -1;
  if (a instanceof String) {
     Matcher m = Pattern.compile((String) b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher((String) a);
     if (m.find()) return m.start(); else return -1;
  }
  if (a instanceof List) {
    for (int i = 0; i < ((List) a).size(); i++) {
      Object o = ((List) a).get(i);
      if (o != null && ((String) o).equalsIgnoreCase((String) b))
        return i;
    }
    return -1;
  }
  throw fail("Unknown type: " + a);
}
// TODO: process CDATA?

static List<String> htmlcoarsetok(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c;
    
    // scan for non-tags
    while (j < l) {
      if (s.charAt(j) != '<')
        // regular character
        ++j;
      else if (s.substring(j, Math.min(j+4, l)).equals("<!--")) {
        // HTML comment
        j = j+4;
        do ++j; while (j < l && !s.substring(j, Math.min(j+3, l)).equals("-->"));
        j = Math.min(j+3, l);
      } else
        // it's a tag
        break;
    }
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);

    // scan for tags
    if (c == '<') {
      ++j;
      
      while (j < l && s.charAt(j) != '>') ++j; // TODO: strings?
      if (j < l) ++j;
    }

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}
static void hotwire_copyOver(Class c) {
  synchronized(StringBuffer.class) {
    for (String field : litlist("print_log", "print_silent", "androidContext")) {
      Object o = getOpt(mc(), field);
      if (o != null)
        setOpt(c, field, o);
    }
      
    Object mainBot = getMainBot();
    if (mainBot != null)
      setOpt(c, "mainBot", mainBot);

    setOpt(c, "creator_class", new WeakReference(mc()));
  }
}
static JCheckBoxMenuItem jCheckBoxMenuItem(String text, boolean checked, final Object r) {
  JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text, checked);
  mi.addActionListener(actionListener(r));
  return mi;
}
static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}
static String singleFieldName(Class c) {
  Set<String> l = listFields(c);
  if (l(l) != 1)
    throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
  return first(l);
}
static <T> void sort(T[] a, Comparator<? super T> c) {
  Arrays.sort(a, c);
}

static <T> void sort(T[] a) {
  Arrays.sort(a);
}

static <T> void sort(List<T> a, Comparator<? super T> c) {
  Collections.sort(a, c);
}

static void sort(List a) {
  Collections.sort(a);
}
static JMenuItem jMenuItem(String text, Object r) {
  return jmenuItem(text, r);
}
static List collect(Collection c, String field) {
  return collectField(c, field);
}
static Object deref(Object o) {
  if (o instanceof Derefable) o = ((Derefable) o).get();
  return o;
}

static AbstractAction abstractAction(String name, final Object runnable) {
  return new AbstractAction(name) {
    public void actionPerformed(ActionEvent evt) {
      pcallF(runnable);
    }
  };
}
static void assertFalse(Object o) {
  assertEquals(false, o);
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}

static boolean hasBot(String searchPattern) {
  DialogIO io = findBot(searchPattern);
  if (io != null) {
    io.close();
    return true;
  } else
    return false;
}
static void toggleAlwaysOnTop(JFrame frame) {
  frame.setAlwaysOnTop(!frame.isAlwaysOnTop());
}
static void shootWindowGUI_external(JFrame frame) {
  call(hotwireOnce("#1007178"), "shootWindowGUI", frame);
}

static void shootWindowGUI_external(final JFrame frame, int delay) {
  call(hotwireOnce("#1007178"), "shootWindowGUI", frame, delay);
}

static Dimension getScreenSize() {
  return Toolkit.getDefaultToolkit().getScreenSize();
}
static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
  return methodsBot2(name, receiver, exposedMethods, null);
}

static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
  Android3 android = new Android3();
  android.greeting = name;
  android.console = false;
  android.responder = new Responder() {
    String answer(String s, List<String> history) {
      return exposeMethods2(receiver, s, exposedMethods, lock);
    }
  };
  return makeBot(android);
}
static long round(double d) {
  return Math.round(d);
}
static String getProgramName_cache;

static synchronized String getProgramName() {
  if (getProgramName_cache == null)
    getProgramName_cache = getSnippetTitleOpt(programID());
  return getProgramName_cache;
}
static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}
static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}



// This is for main classes that are all static.
// (We don't go to base classes.)
static Set<String> listFields(Object c) {
  TreeSet<String> fields = new TreeSet();
  for (Field f : _getClass(c).getDeclaredFields())
    fields.add(f.getName());
  return fields;
}
static JComponent getTitlePaneComponent(Window window) {
  if (!substanceLookAndFeelEnabled()) return null;
  
	JRootPane rootPane = null;
	if (window instanceof JFrame)
		rootPane = ((JFrame) window).getRootPane();
	if (window instanceof JDialog)
		rootPane = ((JDialog) window).getRootPane();
	if (rootPane != null) {
		Object /*SubstanceRootPaneUI*/ ui = rootPane.getUI();
		return (JComponent) call(ui, "getTitlePane");
	}
	return null;
}

static Object mainBot;

static Object getMainBot() {
  return mainBot;
}
static String getSnippetTitleOpt(String s) {
  return isSnippetID(s) ? getSnippetTitle(s) : s;
}
static List collectField(Collection c, String field) {
  List l = new ArrayList();
  for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}
static Map<String, Integer> findBot_cache = synchroHashMap();
static int findBot_timeout = 5000;

static DialogIO findBot(String searchPattern) {
  // first split off sub-bot suffix
  String subBot = null;
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i+1);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    
  if (eq(searchPattern, "remote"))
    return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    io.waitForLine(/*findBot_timeout*/); // TODO: implement
    String line = io.readLineNoBlock();
    if (indexOfIgnoreCase(line, searchPattern) == 0) {
      call(io, "pushback", line); // put hello string back in
      return talkToSubBot(subBot, io);
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      findBot_cache.put(searchPattern, p.port);
      return talkToSubBot(subBot, talkTo("localhost", p.port));
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
        
  return null;
}
static Runnable toRunnable(final Object o) {
  if (o instanceof Runnable) return (Runnable) o;
  return new Runnable() { public void run() { try {  callF(o) ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "callF(o)"; }};
}
static Class<?> _getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class _getClass(Object o) {
  return o == null ? null
    : o instanceof Class ? (Class) o : o.getClass();
}

static Class _getClass(Object realm, String name) { try {
  return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
} catch (Exception __e) { throw rethrow(__e); } }
static boolean isOpeningTag(String token, String tag) {
  return isTag(token, tag) && !token.endsWith("/>");
}

static boolean isOpeningTag(String token) {
  return token.startsWith("<")
    && token.endsWith(">")
    && !token.endsWith("/>")
    && isLetter(token.charAt(1));
}    

static String indentx(String s) {
  return indentx(indent_default, s);
}

static String indentx(int n, String s) {
  return dropSuffix(repeat(' ', n), indent(n, s));
}

static String indentx(String indent, String s) {
  return dropSuffix(indent, indent(indent, s));
}
static boolean exposeMethods2_debug;

static String exposeMethods2(Object receiver, String s, List<String> methodNames) {
  return exposeMethods2(receiver, s, methodNames, null);
}

static String exposeMethods2(Object receiver, String s, List<String> methodNames,
  Lock lock) {
  Matches m = new Matches();
  if (exposeMethods2_debug) print("Received: " + s);
  if (match("call *", s, m)) {
    List l;
    if (isIdentifier(m.unq(0)))
      l = ll(m.unq(0));
    else
      l = (List) unstructure(m.unq(0)); // we used to have safeUnstructure here
    String method = getString(l, 0);
    if (!contains(methodNames, method))
      throw fail("Method not allowed: " + method);
    if (lock != null) lock.lock();
    try {
      if (exposeMethods2_debug) print("Calling: " + method);
      Object o = call(receiver, method, asObjectArray(subList(l, 1)));
      if (exposeMethods2_debug) print("Got: " + getClassName(o));
      return ok2(structure(o));
    } finally {
      if (lock != null) lock.unlock();
    }
  }
  if (match("list methods", s))
    return ok2(structure(methodNames));
  return null;
}
static <A> A last(List<A> l) {
  return l.isEmpty() ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}
static File loadDataSnippetToFile(String snippetID) { try {
  File f = DiskSnippetCache_file(parseSnippetID(snippetID));
  try {
    URL url = new URL("http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + parseSnippetID(snippetID) + "&contentType=application/binary");
    System.err.println("Loading library: " + url);
    try {
      loadBinaryPageToFile(url.openConnection(), f);
    } catch (Throwable _e) {
      url = new URL("http://data.tinybrain.de/blobs/"
        + parseSnippetID(snippetID));
      loadBinaryPageToFile(url.openConnection(), f);
    }
    System.err.println("Bytes loaded: " + fileSize(f));
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static String programID() {
  return getProgramID();
}
static <A> A assertNempty(A a) {
  if (empty(a))
    throw fail("empty: " + a);
  return a;
}
static File DiskSnippetCache_file(long snippetID) {
  return new File(getGlobalCache(), "data_" + snippetID + ".jar");
}
  
  // Data files are immutable, use centralized cache
public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
  File file = DiskSnippetCache_file(snippetID);
  return file.exists() ? file : null;
}

public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
  saveBinaryFile(DiskSnippetCache_file(snippetID), data);
}

static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
  byte[] data;
  try {
    URL url = new URL("http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + parseSnippetID(snippetID) + "&contentType=application/binary");
    System.err.println("Loading library: " + url);
    try {
      data = loadBinaryPage(url.openConnection());
    } catch (RuntimeException e) {
      data = null;
    }
    
    if (data == null || data.length == 0) {
      url = new URL("http://data.tinybrain.de/blobs/"
        + parseSnippetID(snippetID));
      System.err.println("Loading library: " + url);
      data = loadBinaryPage(url.openConnection());
    }
    System.err.println("Bytes loaded: " + data.length);
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return data;
}
static String fsI(String id) {
  return formatSnippetID(id);
}

static String fsI(long id) {
  return formatSnippetID(id);
}
static boolean substanceLookAndFeelEnabled() {
  return startsWith(getLookAndFeel(), "org.pushingpixels.");
}
static boolean odd(int i) {
  return (i & 1) != 0;
}
static int makeBot(String greeting) {
  return makeAndroid3(greeting).port;
}

static Android3 makeBot(Android3 a) {
  makeAndroid3(a);
  return a;
}

static Android3 makeBot(String greeting, Object responder) {
  Android3 a = new Android3(greeting);
  a.responder = makeResponder(responder);
  makeBot(a);
  return a;
}

static Android3 makeBot() {
  return makeAndroid3(getProgramTitle() + ".");
}
static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}
static boolean isLetter(char c) {
  return Character.isLetter(c);
}
static final WeakHashMap<Class, HashMap<String, Field>> getOpt_cache = new WeakHashMap();
static final HashMap getOpt_special = new HashMap(); // just a marker

static {
  getOpt_cache.put(Class.class, getOpt_special);
  getOpt_cache.put(String.class, getOpt_special);
}

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
    if (o instanceof DynamicObject)
      return ((DynamicObject) o).fieldValues.get(field);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) {
        f.setAccessible(true);
        String name = f.getName();
        if (!map.containsKey(name))
          map.put(name, f);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
  }
  getOpt_cache.put(c, map);
  return map;
}
static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(main.class) { main.class.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }
static void smartSet(Field f, Object o, Object value) throws Exception {
  f.setAccessible(true);
  
  // take care of common case (long to int)
  if (f.getType() == int.class && value instanceof Long)
    value = ((Long) value).intValue();
    
  try {
    f.set(o, value);
  } catch (Exception e) {
    
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {}
    
    throw e;
  }
}
static Class hotwireOnce(String programID) {
  return hotwireCached(programID, false);
}
static boolean isTag(String token, String tag) {
  return token.regionMatches(true, 0, "<" + tag + " ", 0, tag.length()+2)
    || token.regionMatches(true, 0, "<" + tag + ">", 0, tag.length()+2);
}


static TreeMap<String,Class> hotwireCached_cache = new TreeMap();

static Class hotwireCached(String programID) {
  return hotwireCached(programID, true);
}

static synchronized Class hotwireCached(String programID, boolean runMain) {
  programID = formatSnippetID(programID);
  Class c = hotwireCached_cache.get(programID);
  if (c == null) {
    c = hotwire(programID);
    if (runMain)
      callMain(c);
    hotwireCached_cache.put(programID, c);
  }
  return c;
}
static boolean startsWithIgnoreCase(String a, String b) {
  return a != null && a.regionMatches(true, 0, b, 0, b.length());
}
static boolean makeAndroid3_disable; // disable all android making

static class Android3 {
  String greeting;
  boolean publicOverride; // optionally set this in client
  int startPort = 5000; // optionally set this in client
  Responder responder;
  boolean console = true;
  boolean quiet; // no messages on console
  boolean daemon = false;
  boolean incomingSilent = false;
  int incomingPrintLimit = 200;
  boolean useMultiPort = true;
  boolean recordHistory;
  boolean verbose;
  int answerPrintLimit = 500;
  
  // set by system
  int port;
  long vport;
  DialogHandler handler;
  ServerSocket server;
  
  Android3(String greeting) {
  this.greeting = greeting;}
  Android3() {}
  
  synchronized void dispose() {
    if (server != null) {
      try {
        server.close();
      } catch (IOException e) {
        print("[internal] " + e);
      }
      server = null;
    }
    if (vport != 0) try {
      print("Disposing " + this);
      removeFromMultiPort(vport);
      vport = 0;
    } catch (Throwable __e) { printStackTrace2(__e); }
  }
  
  public String toString() { return "Bot: " + greeting + " [vport " + vport + "]"; }
}

static abstract class Responder {
  abstract String answer(String s, List<String> history);
}

static Android3 makeAndroid3(final String greeting) {
  return makeAndroid3(new Android3(greeting));
}

static Android3 makeAndroid3(final String greeting, Responder responder) {
  Android3 android = new Android3(greeting);
  android.responder = responder;
  return makeAndroid3(android);
}

static Android3 makeAndroid3(final Android3 a) {
  if (makeAndroid3_disable) return a;
  
  if (a.responder == null)
    a.responder = new Responder() {
      String answer(String s, List<String> history) {
        return callStaticAnswerMethod(s, history);
      }
    };
    
  if (!a.quiet)
    print("[bot] " + a.greeting);
  
  if (a.console && makeAndroid3_consoleInUse()) a.console = false;
  
  record(a);
  
  if (a.useMultiPort)
    a.vport = addToMultiPort(a.greeting,
      makeAndroid3_verboseResponder(a));
      
  if (a.console)
    makeAndroid3_handleConsole(a);

  if (a.useMultiPort) return a;

  a.handler = makeAndroid3_makeDialogHandler(a);
  a.port = a.daemon
    ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler)
    : startDialogServerOnPortAbove(a.startPort, a.handler);
  a.server = startDialogServer_serverSocket;

  return a;
}

static void makeAndroid3_handleConsole(final Android3 a) {
  // Console handling stuff
  if (!a.quiet)
    print("You may also type on this console.");
  { Thread _t_1 = new Thread() {
public void run() { try {
    List<String> history = new ArrayList();
    String line;
    while ((line = readLine()) != null) {
      /*if (eq(line, "bye")) {
        print("> bye stranger");
        history = new ArrayList<S>();
      } else*/ {
        history.add(line);
        history.add(makeAndroid3_getAnswer(line, history, a)); // prints answer on console too
      }
    }
  } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_1); }
}

static DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
  return new DialogHandler() {
public void run(final DialogIO io) {
    if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
      io.sendLine("Sorry, not allowed");
      return;
    }
    
    String dialogID = randomID(8);
    
    io.sendLine(a.greeting + " / Your ID: " + dialogID);
    
    List<String> history = new ArrayList();
    
    while (io.isStillConnected()) {
      if (io.waitForLine()) {
        final String line = io.readLineNoBlock();
        String s = dialogID + " at " + now() + ": " + quote(line);
        if (!a.incomingSilent)
          print(shorten(s, a.incomingPrintLimit));
        if (eq(line, "bye")) {
          io.sendLine("bye stranger");
          return;
        }
        Matches m = new Matches();
        if (a.recordHistory)
          history.add(line);
        String answer;
        if (match3("this is a continuation of talk *", s, m)
          || match3("hello bot! this is a continuation of talk *", s, m)) {
          dialogID = unquote(m.m[0]);
          answer = "ok";
        } else try {
          makeAndroid3_io.set(io);
          answer = makeAndroid3_getAnswer(line, history, a);
        } finally {
          makeAndroid3_io.set(null);
        }
        if (a.recordHistory)
          history.add(answer);
        io.sendLine(answer);
        //appendToLog(logFile, s);
      }
    }
  }};
}

static String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
  String answer, originalAnswer;
  try {
    originalAnswer = a.responder.answer(line, history);
    answer = makeAndroid3_fallback(line, history, originalAnswer);
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    originalAnswer = answer = e.toString();
  }
  if (!a.incomingSilent) {
    if (originalAnswer == null) originalAnswer = "?";
    print("> " + shorten(originalAnswer, a.answerPrintLimit));
  }
  return answer;
}

static String makeAndroid3_fallback(String s, List<String> history, String answer) {
  // Now we only do the safe thing instead of VM inspection - give out our process ID
  if (answer == null && match3("what is your pid", s))
    return getPID();
    
  if (answer == null && match3("what is your program id", s)) // should be fairly safe, right?
    return getProgramID();
    
  if (match3("get injection id", s))
    return getInjectionID();
    
  if (answer == null) answer = "?";
  if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
    answer = quote(answer);
  return answer;
}

static boolean makeAndroid3_consoleInUse() {
  for (Object o : record_list)
    if (o instanceof Android3 && ((Android3) o).console)
      return true;
  return false;
}

static Responder makeAndroid3_verboseResponder(final Android3 a) {
  return new Responder() {
    String answer(String s, List<String> history) {
      if (a.verbose)
        print("> " + shorten(s, a.incomingPrintLimit));
      String answer = a.responder.answer(s, history);
      if (a.verbose)
        print("< " + shorten(answer, a.incomingPrintLimit));
      return answer;
    }
  };
}

static ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

static Android3 makeAndroid3() {
  return makeAndroid3(getProgramTitle() + ".");
}
static String getProgramTitle() {
  return getProgramName();
}
static String sendToLocalBotQuietly(String bot, String text, Object... args) {
  text = format3(text, args);
  
  DialogIO channel = newFindBot2(bot);
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    channel.close();
  }
}

static String sendToLocalBotQuietly(int port, String text, Object... args) {
  text = format3(text, args);
  DialogIO channel = talkTo(port);
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    if (channel != null)
      channel.close();
  }
}
  /** writes safely (to temp file, then rename) */
  public static void saveBinaryFile(String fileName, byte[] contents) throws IOException {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
    fileOutputStream.write(contents);
    fileOutputStream.close();
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);

    if (!new File(tempFileName).renameTo(file))
      throw new IOException("Can't rename " + tempFileName + " to " + fileName);
  }

  static void saveBinaryFile(File fileName, byte[] contents) {
    try {
      saveBinaryFile(fileName.getPath(), contents);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
static Object[] asObjectArray(List l) {
  return toObjectArray(l);
}
static String getString(Map map, Object key) {
  return map == null ? null : (String) map.get(key);
}

static String getString(List l, int idx) {
  return (String) get(l, idx);
}

static String getString(Object o, Object key) {
  if (o instanceof Map) return getString((Map) o, key);
  if (key instanceof String)
    return (String) getOpt(o, (String) key);
  throw fail("Not a string key: " + getClassName(key));
}
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}
static boolean isJavaIdentifier(String s) {
  if (empty(s) || !Character.isJavaIdentifierStart(s.charAt(0)))
    return false;
  for (int i = 1; i < s.length(); i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}
static boolean isIdentifier(String s) {
  return isJavaIdentifier(s);
}
static String getSnippetTitle(String id) { try {
  if (!isSnippetID(id)) return "?";
  return trim(loadPageSilently(new URL("http://tinybrain.de:8080/tb-int/getfield.php?id=" + parseSnippetID(id) + "&field=title" + standardCredentials())));
} catch (Exception __e) { throw rethrow(__e); } }

static String getSnippetTitle(long id) {
  return getSnippetTitle(fsI(id));
}

static void loadBinaryPageToFile(String url, File file) { try {
  print("Loading " + url);
  loadBinaryPageToFile(new URL(url).openConnection(), file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile(URLConnection con, File file) { try {
  setHeaders(con);
  loadBinaryPageToFile_noHeaders(con, file);
} catch (Exception __e) { throw rethrow(__e); } }

static void loadBinaryPageToFile_noHeaders(URLConnection con, File file) { try {
  File ftemp = new File(f2s(file) + "_temp");
  FileOutputStream buf = newFileOutputStream(mkdirsFor(ftemp));
  InputStream inputStream = con.getInputStream();
  try {
    long len = 0;
    try { len = con.getContentLengthLong(); } catch (Throwable e) { printStackTrace(e); }
    int n = 0;
    while (true) {
      int ch = inputStream.read();
      if (ch < 0)
        break;
      buf.write(ch);
      if (++n % 100000 == 0)
        println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
    }
    buf.close();
    buf = null;
    file.delete();
    ftemp.renameTo(file);
    inputStream.close();
  } finally {
    if (buf != null) buf.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static String getLookAndFeel() {
  return getClassName(UIManager.getLookAndFeel());
}
static int indent_default = 2;

static String indent(int indent) {
  return repeat(' ', indent);
}

static String indent(int indent, String s) {
  return indent(repeat(' ', indent), s);
}

static String indent(String indent, String s) {
  return indent + s.replace("\n", "\n" + indent);
}

static String indent(String s) {
  return indent(indent_default, s);
}

static List<String> indent(String indent, List<String> lines) {
  List<String> l = new ArrayList();
  for (String s : lines)
    l.add(indent + s);
  return l;
}
static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  List<A> l = new ArrayList();
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}
static String ok2(String s) {
  return "ok " + s;
}
static byte[] loadBinaryPage(String url) { try {
  print("Loading " + url);
  return loadBinaryPage(new URL(url).openConnection());
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage(URLConnection con) { try {
  setHeaders(con);
  return loadBinaryPage_noHeaders(con);
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage_noHeaders(URLConnection con) { try {
  ByteArrayOutputStream buf = new ByteArrayOutputStream();
  InputStream inputStream = con.getInputStream();
  long len = 0;
  try { len = con.getContentLengthLong(); } catch (Throwable e) { printStackTrace(e); }
  int n = 0;
  while (true) {
    int ch = inputStream.read();
    if (ch < 0)
      break;
    buf.write(ch);
    if (++n % 100000 == 0)
      println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
  }
  inputStream.close();
  return buf.toByteArray();
} catch (Exception __e) { throw rethrow(__e); } }

static boolean structure_showTiming, structure_checkTokenCount;

static String structure(Object o) {
  return structure(o, new structure_Data());
}

static String structure(Object o, structure_Data d) {
  StringWriter sw = new StringWriter();
  d.out = new PrintWriter(sw);
  structure_go(o, d);
  String s = str(sw);
  if (structure_checkTokenCount) {
    print("token count=" + d.n);
    assertEquals("token count", l(javaTokC(s)), d.n);
  }
  return s;
}

static void structure_go(Object o, structure_Data d) {
  structure_1(o, d);
  while (nempty(d.stack))
    popLast(d.stack).run();
}

static void structureToPrintWriter(Object o, PrintWriter out) {
  structure_Data d = new structure_Data();
  d.out = out;
  structure_go(o, d);
}

// leave to false, unless unstructure() breaks
static boolean structure_allowShortening = false;

static class structure_Data {
  PrintWriter out;
  int stringSizeLimit;
  int shareStringsLongerThan = 20;

  IdentityHashMap<Object,Integer> seen = new IdentityHashMap();
  BitSet refd = new BitSet();
  HashMap<String,Integer> strings = new HashMap();
  HashSet<String> concepts = new HashSet();
  HashMap<Class, List<Field>> fieldsByClass = new HashMap();
  Class conceptClass = findClass("Concept");
  int n; // token count
  List<Runnable> stack = new ArrayList();
  
  // append single token
  structure_Data append(String token) { out.print(token); ++n; return this; }
  structure_Data append(int i) { out.print(i); ++n; return this; }
  
  // append multiple tokens
  structure_Data append(String token, int tokCount) { out.print(token); n += tokCount; return this; }
  
  // extend last token
  structure_Data app(String token) { out.print(token); return this; }
  structure_Data app(int i) { out.print(i); return this; }
}

static void structure_1(final Object o, final structure_Data d) {
  final PrintWriter out = d.out;
  
  if (o == null) { d.append("null"); return; }
  
  Class c = o.getClass();
  String name = c.getName();
  String dynName = shortDynamicClassName(o);
  boolean concept = d.conceptClass != null && d.conceptClass.isInstance(o);
  List<Field> lFields = d.fieldsByClass.get(c);
  
  if (lFields == null) {
    // these are never back-referenced (for readability)
    
    if (o instanceof Number) {
      if (o instanceof Integer) { int i = ((Integer) o).intValue(); out.print(i); d.n += i < 0 ? 2 : 1; return; }
      if (o instanceof Long) { long l = ((Long) o).longValue(); out.print(l); out.print("L"); d.n += l < 0 ? 2 : 1; return; }
      if (o instanceof Float) { d.append("fl ", 2); quoteToPrintWriter(str(o), out); return; }
      if (o instanceof Double) { d.append("d(", 3); quoteToPrintWriter(str(o), out); d.append(")"); return; }
      if (o instanceof BigInteger) { out.print("bigint("); out.print(o); out.print(")"); d.n += ((BigInteger) o).signum() < 0 ? 5 : 4; return; }
    }
  
    if (o instanceof Boolean) {
      d.append(((Boolean) o).booleanValue() ? "t" : "f"); return;
    }
      
    if (o instanceof Character) {
      d.append(quoteCharacter((Character) o)); return;
    }
      
    if (o instanceof File) {
      d.append("File ").append(quote(((File) o).getPath())); return;
    }
      
    // referencable objects follow
    
    Integer ref = d.seen.get(o);
    if (o instanceof String && ref == null)
      ref = d.strings.get((String) o);
      
    if (ref != null) {
      d.refd.set(ref);
      d.append("t").app(ref); return;
    }
    
    ref = d.n; //d.seen.size()+1;
    if (d.shareStringsLongerThan < Integer.MAX_VALUE || !(o instanceof String))
      d.seen.put(o, ref);
    //d.append("m").app(ref).app(" "); // marker
    
    if (o instanceof String) {
      String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
      if (l(s) >= d.shareStringsLongerThan)
        d.strings.put(s, ref);
      quoteToPrintWriter(s, out); d.n++; return;
    }
      
    if (o instanceof HashSet) {
      d.append("hashset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
  
    if (o instanceof TreeSet) {
      d.append("treeset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
    
    if (o instanceof Collection && neq(name, "main$Concept$RefL")) {
      d.append("[");
      final int l = d.n;
      final Iterator it = ((Collection) o).iterator();
      d.stack.add(new Runnable() { public void run() { try { 
        if (!it.hasNext())
          d.append("]");
        else {
          d.stack.add(this);
          if (d.n != l) d.append(", ");
          structure_1(it.next(), d);
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.stack...."; }});
      return;
    }
    
    if (o instanceof Map) {
      if (o instanceof LinkedHashMap) d.append("lhm");
      else if (o instanceof HashMap) d.append("hm");
      d.append("{");
      final int l = d.n;
      final Iterator it = ((Map) o).entrySet().iterator();
      
      d.stack.add(new Runnable() {
        boolean v;
        Map.Entry e;
        
        public void run() {
          if (v) {
            d.append("=");
            v = false;
            d.stack.add(this);
            structure_1(e.getValue(), d);
          } else {
            if (!it.hasNext())
              d.append("}");
            else {
              e = (Map.Entry) it.next();
              v = true;
              d.stack.add(this);
              if (d.n != l) d.append(", ");
              structure_1(e.getKey(), d);
            }
          }
        }
      });
      return;
    }
    
    if (c.isArray()) {
      if (o instanceof byte[]) {
        d.append("ba ").append(quote(bytesToHex((byte[]) o))); return;
      }
  
      final int n = Array.getLength(o);
  
      if (o instanceof boolean[]) {
        String hex = boolArrayToHex((boolean[]) o);
        int i = l(hex);
        while (i > 0 && hex.charAt(i-1) == '0' && hex.charAt(i-2) == '0') i -= 2;
        d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i))); return;
      }
      
      String atype = "array", sep = ", ";
  
      if (o instanceof int[]) {
        //ret "intarray " + quote(intArrayToHex((int[]) o));
        atype = "intarray";
        sep = " ";
      }
      
      d.append(atype).append("{");
      d.stack.add(new Runnable() {
        int i;
        public void run() {
          if (i >= n)
            d.append("}");
          else {
            d.stack.add(this);
            if (i > 0) d.append(", ");
            structure_1(Array.get(o, i++), d);
          }
        }
      });
      return;
    }
  
    if (o instanceof Class) {
      d.append("class(", 2).append(quote(((Class) o).getName())).append(")"); return;
    }
      
    if (o instanceof Throwable) {
      d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")"); return;
    }
      
    if (o instanceof BitSet) {
      BitSet bs = (BitSet) o;
      d.append("bitset{", 2);
      int l = d.n;
      for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i+1)) {
        if (d.n != l) d.append(", ");
        d.append(i);
      }
      d.append("}"); return;
    }
      
    // Need more cases? This should cover all library classes...
    if (name.startsWith("java.") || name.startsWith("javax.")) {
      d.append("j ").append(quote(str(o))); return; // Hm. this is not unstructure-able
    }
    
    
      
    /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
    
    if (concept && !d.concepts.contains(dynName)) {
      d.concepts.add(dynName);
      d.append("c ");
    }
    
    // serialize an object with fields.
    // first, collect all fields and values in fv.
    
    TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {
      public int compare(Field a, Field b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    
    while (c != Object.class) {
      for (Field field : getDeclaredFields_cached(c)) {
        if ((field.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) != 0)
          continue;
        String fieldName = field.getName();
        
        fields.add(field);
        
        // put special cases here...
      }
        
      c = c.getSuperclass();
    }
    
    lFields = asList(fields);
    
    // Render this$1 first because unstructure needs it for constructor call.
    
    for (int i = 0; i < l(lFields); i++) {
      Field f = lFields.get(i);
      if (f.getName().equals("this$1")) {
        lFields.remove(i);
        lFields.add(0, f);
        break;
      }
    }
  
    d.fieldsByClass.put(c, lFields);
  }

  LinkedHashMap<String,Object> fv = new LinkedHashMap();
  for (Field f : lFields) {
    Object value;
    try {
      value = f.get(o);
    } catch (Exception e) {
      value = "?";
    }
      
    if (value != null)
      fv.put(f.getName(), value);
  }
  
  String shortName = dropPrefix("main$", name);
    
  // Now we have fields & values. Process fieldValues if it's a DynamicObject.
  
  // omit field "className" if equal to class's name
  if (concept && eq(fv.get("className"), shortName))
    fv.remove("className");
          
  if (o instanceof DynamicObject) {
    fv.putAll((Map) fv.get("fieldValues"));
    fv.remove("fieldValues");
    shortName = dynName;
    fv.remove("className");
  }
  
  String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
  
  d.append(shortName);

  final int l = d.n;
  final Iterator it = fv.entrySet().iterator();
  
  d.stack.add(new Runnable() { public void run() { try { 
    if (!it.hasNext()) {
      if (d.n != l)
        d.append(")");
    } else {
      Map.Entry e = (Map.Entry) it.next();
      d.append(d.n == l ? "(" : ", ");
      d.append((String) e.getKey()).append("=");
      d.stack.add(this);
      structure_1(e.getValue(), d);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else {\r..."; }});
}

static DialogIO talkToSubBot(final long vport, final DialogIO io) {
  return talkToSubBot(String.valueOf(vport), io);
}

static DialogIO talkToSubBot(final String subBot, final DialogIO io) {
  if (subBot == null) return io;
  return new talkToSubBot_IO(subBot, io);
}

static class talkToSubBot_IO extends DialogIO {
  String subBot;
  DialogIO io;
  
  talkToSubBot_IO(String subBot, DialogIO io) {
  this.io = io;
  this.subBot = subBot;}
  
  // delegate all but sendLine
  boolean isStillConnected() { return io.isStillConnected(); }
  String readLineImpl() { return io.readLineImpl(); }
  boolean isLocalConnection() { return io.isLocalConnection(); }
  Socket getSocket() { return io.getSocket(); }
  void close() { io.close(); }

  void sendLine(String line) {
    io.sendLine(format3("please forward to bot *: *", subBot, line));
  }
}
static String programID;

static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}

// TODO: ask JavaX instead
static String getProgramID(Class c) {
  String id = (String) getOpt(c, "programID");
  if (nempty(id))
    return formatSnippetID(id);
  return "?";
}

static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}
static Object unstructure(String text) {
  return unstructure(text, false);
}

static Object unstructure(String text, final boolean allDynamic) {
  return unstructure(text, allDynamic, null);
}

static int structure_internStringsLongerThan = 50;

static int unstructure_tokrefs; // stats

abstract static class unstructure_Receiver {
  abstract void set(Object o);
}

// classFinder: func(name) -> class (optional)
static Object unstructure(String text, boolean allDynamic,
  Object classFinder) {
  if (text == null) return null;
  return unstructure_tok(javaTokC_noMLS_iterator(text), allDynamic, classFinder);
}

static Object unstructure_reader(BufferedReader reader) {
  return unstructure_tok(javaTokC_noMLS_onReader(reader), false, null);
}

static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object classFinder) {
  final boolean debug = unstructure_debug;
  
  final class X {
    int i = -1;
    HashMap<Integer,Object> refs = new HashMap();
    HashMap<Integer,Object> tokrefs = new HashMap();
    HashSet<String> concepts = new HashSet();
    HashMap<String,Class> classesMap = new HashMap();
    List<Runnable> stack = new ArrayList();
    String curT;
    
    // look at current token
    String t() {
      return curT;
    }
    
    // get current token, move to next
    String tpp() {
      String t = curT;
      consume();
      return t;
    }
    
    void parse(final unstructure_Receiver out) {
      String t = t();
      
      int refID = 0;
      if (structure_isMarker(t, 0, l(t))) {
        refID = parseInt(t.substring(1));
        consume();
      }
      final int _refID = refID;
      
      // if (debug) print("parse: " + quote(t));
      
      final int tokIndex = i;  
      parse_inner(refID, tokIndex, new unstructure_Receiver() {
        void set(Object o) {
          if (_refID != 0)
            refs.put(_refID, o);
          if (o != null)
            tokrefs.put(tokIndex, o);
          out.set(o);
        }
      });
    }
    
    void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
      String t = t();
      
      // if (debug) print("parse_inner: " + quote(t));
      
      Class c = classesMap.get(t);
      if (c == null) {
        if (t.startsWith("\"")) {
          String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
          out.set(s); return;
        }
        
        if (t.startsWith("'")) {
          out.set(unquoteCharacter(tpp())); return;
        }
        if (t.equals("bigint")) {
          out.set(parseBigInt()); return;
        }
        if (t.equals("d")) {
          out.set(parseDouble()); return;
        }
        if (t.equals("fl")) {
          out.set(parseFloat()); return;
        }
        if (t.equals("false") || t.equals("f")) {
          consume(); out.set(false); return;
        }
        if (t.equals("true") || t.equals("t")) {
          consume(); out.set(true); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          if (debug)
            print("l=" + l + ", isInt: " + isInt);
          out.set(isInt ? (Object) new Integer((int) l) : (Object) new Long(l)); return;
        }
        
        if (t.equals("File")) {
          consume();
          File f = new File(unquote(tpp()));
          out.set(f); return;
        }
        
        if (t.startsWith("r") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = refs.get(ref);
          if (o == null)
            print("Warning: unsatisfied back reference " + ref);
          out.set(o); return;
        }
      
        if (t.startsWith("t") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = tokrefs.get(ref);
          if (o == null)
            print("Warning: unsatisfied token reference " + ref);
          out.set(o); return;
        }
        
        if (t.equals("hashset")) {
          parseHashSet(out); return;
        }
        if (t.equals("treeset")) {
          parseTreeSet(out); return;
        }
        if (eqOneOf(t, "hashmap", "hm")) {
          consume();
          parseMap(new HashMap(), out);
          return;
        }
        if (t.equals("lhm")) {
          consume();
          parseMap(new LinkedHashMap(), out);
          return;
        }
        if (t.equals("{")) {
          parseMap(out); return;
        }
        if (t.equals("[")) {
          parseList(out); return;
        }
        if (t.equals("bitset")) {
          parseBitSet(out); return;
        }
        if (t.equals("array") || t.equals("intarray")) {
          parseArray(out); return;
        }
        if (t.equals("ba")) {
          consume();
          String hex = unquote(tpp());
          out.set(hexToBytes(hex)); return;
        }
        if (t.equals("boolarray")) {
          consume();
          int n = parseInt(tpp());
          String hex = unquote(tpp());
          out.set(boolArrayFromBytes(hexToBytes(hex), n)); return;
        }
        if (t.equals("class")) {
          out.set(parseClass()); return;
        }
        if (t.equals("l")) {
          parseLisp(out); return;
        }
        if (t.equals("null")) {
          consume(); out.set(null); return;
        }
        
        if (eq(t, "c")) {
          consume("c");
          t = t();
          assertTrue(isJavaIdentifier(t));
          concepts.add(t);
        }
      }
      
      if (eq(t, "j")) {
        consume("j");
        out.set(parseJava()); return;
      }

      if (c == null && !isJavaIdentifier(t))
        throw new RuntimeException("Unknown token " + (i+1) + ": " + t);
        
      // any other class name
      if (c == null) {
        // First, find class
        if (allDynamic) c = null;
        else c = classFinder != null ? (Class) callF(classFinder, t) : findClass(t);
        if (c != null)
          classesMap.put(t, c);
      }
          
      // Check if it has an outer reference
      consume();
      boolean hasBracket = eq(t(), "(");
      if (hasBracket) consume();
      boolean hasOuter = hasBracket && eq(t(), "this$1");
      
      DynamicObject dO = null;
      Object o = null;
      if (c != null)
        o = hasOuter ? nuStubInnerObject(c) : nuEmptyObject(c);
      else {
        if (concepts.contains(t) && (c = findClass("Concept")) != null)
          o = dO = (DynamicObject) nuEmptyObject(c);
        else
          dO = new DynamicObject();
        dO.className = t;
        if (debug) print("Made dynamic object " + t + " " + shortClassName(dO));
      }
      
      // Save in references list early because contents of object
      // might link back to main object
      
      if (refID != 0)
        refs.put(refID, o != null ? o : dO);
      tokrefs.put(tokIndex, o != null ? o : dO);
      
      // NOW parse the fields!
      
      final LinkedHashMap<String,Object> fields = new LinkedHashMap(); // preserve order
      final Object _o = o;
      final DynamicObject _dO = dO;
      if (hasBracket) {
        stack.add(new Runnable() { public void run() { try { 
          if (eq(t(), ")")) {
            consume(")");
            objRead(_o, _dO, fields);
            out.set(_o != null ? _o : _dO);
          } else {
            final String key = unquote(tpp());
            consume("=");
            stack.add(this);
            parse(new unstructure_Receiver() {
              void set(Object value) {
                fields.put(key, value);
                if (eq(t(), ",")) consume();
              }
            });
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, fie..."; }});
      } else {
        objRead(o, dO, fields);
        out.set(o != null ? o : dO);
      }
    }
    
    void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
      if (o != null)
        if (dO != null) {
          if (debug)
            printStructure("setOptAllDyn", fields);
          setOptAllDyn(dO, fields);
        } else
          setOptAll(o, fields);
      else for (String field : keys(fields))
        dO.fieldValues.put(field.intern(), fields.get(field));

      if (o != null)
        pcallOpt_noArgs(o, "_doneLoading");
    }
    
    void parseSet(final Set set, final unstructure_Receiver out) {
      parseList(new unstructure_Receiver() {
        void set(Object o) {
          set.addAll((List) o);
          out.set(set);
        }
      });
    }
    
    void parseLisp(final unstructure_Receiver out) {
      consume("l");
      consume("(");
      final ArrayList list = new ArrayList();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), ")")) {
          consume(")");
          out.set(newObject("main$Lisp", (String) list.get(0), subList(list, 1)));
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n          consume(\")\");\r\n          out.set(newObject(\"main$..."; }});
    }
    
    void parseBitSet(final unstructure_Receiver out) {
      consume("bitset");
      consume("{");
      final BitSet bs = new BitSet();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(bs);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              bs.set((Integer) o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n        } ..."; }});
    }
    
    void parseList(final unstructure_Receiver out) {
      consume("[");
      final ArrayList list = new ArrayList();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "]")) {
          consume("]");
          out.set(list);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              //if (debug) print("List element type: " + getClassName(o));
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n        ..."; }});
    }
    
    void parseArray(final unstructure_Receiver out) {
      final String type = tpp();
      consume("{");
      final List list = new ArrayList();
      
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"int..."; }});
    }
    
    Object parseClass() {
      consume("class");
      consume("(");
      String name = unquote(tpp());
      consume(")");
      name = dropPrefix("main$", name);
      Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass(name);
      if (c != null) return c;
      DynamicObject dO = new DynamicObject();
      dO.className = "java.lang.Class";
      dO.fieldValues.put("name", name);
      return dO;
    }
    
    Object parseBigInt() {
      consume("bigint");
      consume("(");
      String val = tpp();
      if (eq(val, "-"))
        val = "-" + tpp();
      consume(")");
      return new BigInteger(val);
    }
    
    Object parseDouble() {
      consume("d");
      consume("(");
      String val = unquote(tpp());
      consume(")");
      return Double.parseDouble(val);
    }
    
    Object parseFloat() {
      consume("fl");
      String val;
      if (eq(t(), "(")) {
        consume("(");
        val = unquote(tpp());
        consume(")");
      } else {
        val = unquote(tpp());
      }
      return Float.parseFloat(val);
    }
    
    void parseHashSet(unstructure_Receiver out) {
      consume("hashset");
      parseSet(new HashSet(), out);
    }
    
    void parseTreeSet(unstructure_Receiver out) {
      consume("treeset");
      parseSet(new TreeSet(), out);
    }
    
    void parseMap(unstructure_Receiver out) {
      parseMap(new TreeMap(), out);
    }
    
    Object parseJava() {
      String j = unquote(tpp());
      Matches m = new Matches();
      if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
        return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
      else throw fail("Unknown Java object: " + j);
    }
    
    void parseMap(final Map map, final unstructure_Receiver out) {
      consume("{");
      stack.add(new Runnable() {
        boolean v;
        Object key;
        
        public void run() { 
          if (v) {
            v = false;
            stack.add(this);
            consume("=");
            parse(new unstructure_Receiver() {
              void set(Object value) {
                map.put(key, value);
                if (debug)
                  print("parseMap: Got value " + getClassName(value) + ", next token: " + quote(t()));
                if (eq(t(), ",")) consume();
              }
            });
          } else {
            if (eq(t(), "}")) {
              consume("}");
              out.set(map);
            } else {
              v = true;
              stack.add(this);
              parse(new unstructure_Receiver() {
                void set(Object o) {
                  key = o;
                }
              });
            }
          } // if v else
        } // run()
      });
    }
    
    /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
    
    void consume() { curT = tok.next(); ++i; }
    
    void consume(String s) {
      if (!eq(t(), s)) {
        /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
        throw fail(quote(s) + " expected, got " + quote(t()));
      }
      consume();
    }
    
    void parse_x(unstructure_Receiver out) {
      consume(); // get first token
      parse(out);
      while (nempty(stack))
        popLast(stack).run();
    }
  }
  
  final Var v = new Var();
  X x = new X();
  x.parse_x(new unstructure_Receiver() {
    void set(Object o) { v.set(o); }
  });
  unstructure_tokrefs = x.tokrefs.size();
  return v.get();
}

static boolean unstructure_debug;
static String firstPartOfHelloString(String s) {
  int i = s.lastIndexOf('/');
  return i < 0 ? s : rtrim(s.substring(0, i));
}
static boolean isInteger(String s) {
  if (s == null) return false;
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  if (s.charAt(0) == '-')
    if (++i >= n) return false;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}
static String classNameToVM(String name) {
  return name.replace(".", "$");
}
static List<ProgramScan.Program> quickBotScan() {
  return ProgramScan.quickBotScan();
}

static List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
  return ProgramScan.quickBotScan(preferredPorts);
}

static List<ProgramScan.Program> quickBotScan(String searchPattern) {
  List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
  for (ProgramScan.Program p : ProgramScan.quickBotScan())
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
  return l;
}

static String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
  String answer = (String) callOpt(bot, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(bot, "answer", s);
  return answer;
}

static Responder makeResponder(final Object bot) {
  if (bot instanceof Responder) return (Responder) bot;
  
  return new Responder() {
    String answer(String s, List<String> history) {
      return makeResponder_callAnswerMethod(bot, s, history);
    }
  };
}
static DialogIO talkTo(int port) {
  return talkTo("localhost", port);
}

static int talkTo_defaultTimeout = 10000; // This is the CONNECT timeout
static int talkTo_timeoutForReads = 0; // Timeout waiting for answers (0 = no timeout)

static ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

static DialogIO talkTo(String ip, int port) { try {
  String full = ip + ":" + port;
  Map<String, DialogIO> map = talkTo_byThread.get();
  if (map != null && map.containsKey(full)) return map.get(full);
  
  if (isLocalhost(ip) && port == vmPort()) return talkToThisVM();

  return new talkTo_IO(ip, port);
} catch (Exception __e) { throw rethrow(__e); } }

static class talkTo_IO extends DialogIO { 
  String ip;
  int port;
  Socket s;
  Writer w;
  BufferedReader in;
  
  talkTo_IO(String ip, int port) { try {
  this.port = port;
  this.ip = ip;
    s = new Socket();
    try {
      if (talkTo_timeoutForReads != 0)
        s.setSoTimeout(talkTo_timeoutForReads);
      s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
    } catch (Throwable e) {
      throw fail("Tried talking to " + ip + ":" + port, e);
    }
  
    w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
    in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    w.write(line + "\n");
    w.flush();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  void close() {
    try {
      if (!noClose) s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
}
  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }
static Class<?> getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class getClass(Object o) {
  return o instanceof Class ? (Class) o : o.getClass();
}

static Class getClass(Object realm, String name) { try {
  try {
    return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static long fileSize(String path) { return getFileSize(path); }
static long fileSize(File f) { return getFileSize(f); }



static Map<String, Integer> newFindBot2_cache = synchroHashMap();
static boolean newFindBot2_verbose;

static DialogIO newFindBot2(String name) {
  Integer port = newFindBot2_cache.get(name);
  if (port != null) {
    if (newFindBot2_verbose)
      print("newFindBot2: testing " + name + " => " + port);
    DialogIO io = talkTo(port);
    String q = format("has bot *", name);
    String s = io.ask(q);
    if (match("yes", s)) {
      io = talkToSubBot(name, io);
      call(io, "pushback", "?"); // put some hello string in (yes, this should be improved.)
      return io;
    }
    // bot not there anymore - remove cache entry
    newFindBot2_cache.remove(name);
    if (newFindBot2_verbose)
      print("newFindBot2: dropping " + name + " => " + port);
  }
  
  DialogIO io = findBot(name);
  if (io != null) {
    newFindBot2_cache.put(name, io.getPort());
    if (newFindBot2_verbose)
      print("newFindBot2: remembering " + name + " => " + port);
  }
  return io;
}
static List<Object> record_list = synchroList();

static void record(Object o) {
  record_list.add(o);
}
static String quoteCharacter(char c) {
  if (c == '\'') return "'\\''";
  if (c == '\\') return "'\\\\'";
  if (c == '\r') return "'\\r'";
  if (c == '\n') return "'\\n'";
  if (c == '\t') return "'\\t'";
  return "'" + c + "'";
}

static byte[] hexToBytes(String s) {
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    String hex = substring(s, i*2, i*2+2);
    try {
      bytes[i] = (byte) parseHexByte(hex);
    } catch (Throwable _e) {
      throw fail("Bad hex byte: " + quote(hex) + " at " + i*2 + "/" + l(s));
    }
  }
  return bytes;
}
static HashMap<Class,Constructor> nuEmptyObject_cache = new HashMap();

static <A> A nuEmptyObject(Class<A> c) { try {
  Constructor ctr;
  
  synchronized(nuEmptyObject_cache) {
    ctr = nuEmptyObject_cache.get(c);
    if (ctr == null) {
      nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
      ctr.setAccessible(true);
    }
  }

  return (A) ctr.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuEmptyObject_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (m.getParameterTypes().length == 0)
      return m;
  throw fail("No default constructor declared in " + c.getName());
}

static boolean structure_isMarker(String s, int i, int j) {
  if (i >= j) return false;
  if (s.charAt(i) != 'm') return false;
  ++i;
  while (i < j) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static Object newObject(Class c, Object... args) {
  return nuObject(c, args);
}

static Object newObject(String className, Object... args) {
  return nuObject(className, args);
}

static int vmPort() {
  return myVMPort();
}
static String boolArrayToHex(boolean[] a) {
  return bytesToHex(boolArrayToBytes(a));
}
static boolean match3(String pat, String s) {
  return match3(pat, s, null);
}

static boolean match3(String pat, String s, Matches matches) {
  if (s == null) return false;
  return match3(pat, parse3_cached(s), matches);
}
  
static boolean match3(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = parse3(pat);
  return match3(tokpat,toks,matches);
}

static boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) matches.m = m; return true;
}
  static String format3(String pat, Object... args) {
    if (args.length == 0) return pat;
    
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2)
      if (tok.get(i).equals("*"))
        tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }
  
  static String format3_formatArg(Object arg) {
    if (arg == null) return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long) return String.valueOf(arg);
    return quote(structure(arg));
  }
  

  static AtomicInteger dialogServer_clients = new AtomicInteger();
  static boolean dialogServer_printConnects;
  
  static Set<String> dialogServer_knownClients = synchroTreeSet();
  
  static int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler))
      ++port;
    return port;
  }
  
  static int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true))
      ++port;
    return port;
  }
  
  static void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }
  
  static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }
  
  static ServerSocket startDialogServer_serverSocket;
    
  static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      // probably the port number is used - let's assume there already is a chat server.
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;

    Thread thread = new Thread("Socket accept port " + port) { public void run() {
     try {
      while (true) {
        try {
          final Socket s = _serverSocket.accept();
          
          String client = s.getInetAddress().toString();
          if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
            print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
            dialogServer_knownClients.add(client);
          }
          
          String threadName = "Handling client " + s.getInetAddress();

          Thread t2 = new Thread(threadName) {
           public void run() {
            try {
              final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
              final BufferedReader in = new BufferedReader(
                new InputStreamReader(s.getInputStream(), "UTF-8"));
                
              DialogIO io = new DialogIO() {
              
                // This should be the same as #1001076 (talkTo)
              
    boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }
    
    boolean isStillConnected() {
      return !(eos || s.isClosed());
    }
    
    void sendLine(String line) { try {
      w.write(line + "\n");
      w.flush();
    } catch (Exception __e) { throw rethrow(__e); } }
    
    String readLineImpl() { try {
      return in.readLine();
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void close() {
      try {
        s.close();
      } catch (IOException e) {
        // whatever
      }
    }
    
    Socket getSocket() {
      return s;
    }
    };
              
              try {
                handler.run(io);
              } finally {
                s.close();
              }
            } catch (IOException e) {
              print("[internal] " + e);
            } finally {
              //print("client disconnect - " + dialogServer_clients.decrementAndGet() + " remaining");
            }
           }
          }; // Thread t2
          t2.setDaemon(true); // ?
          t2.start();
        } catch (SocketTimeoutException e) {
        }
      }   
     } catch (IOException e) {
       print("[internal] " + e);
     }
    }};
    if (daemon) thread.setDaemon(true);
    thread.start();
   
    print("Dialog server on port " + port + " started."); 
    return true;
  }
static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}
static void setOptAll(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    setOpt(o, field, fields.get(field));
}

static void setOptAll(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    setOpt(o, field, value);
  }
}
static Producer<String> javaTokC_noMLS_onReader(final BufferedReader r) {
  final class X implements Producer<String> {
    StringBuilder buf = new StringBuilder(); // stores from "i"
    char c, d, e = 'x'; // just not '\0'
    
    X() {
      // fill c, d and e
      nc();
      nc();
      nc();
    }
    
    // get next character(s) into c, d and e
    void nc() { try {
      c = d;
      d = e;
      if (e == '\0') return;
      int i = r.read();
      e = i < 0 ? '\0' : (char) i;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void ncSave() {
      if (c != '\0') {
        buf.append(c);
        nc();
      }
    }
    
    public String next() {
      // scan for whitespace
      while (c != '\0') {
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          nc();
        else if (c == '/' && d == '*') {
          do nc(); while (c != '\0' && !(c == '*' && d == '/'));
          nc(); nc();
        } else if (c == '/' && d == '/') {
          do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
        } else
          break;
      }
      
      if (c == '\0') return null;

      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ncSave();
        while (c != '\0') {
          if (c == opener || c == '\n') { // end at \n to not propagate unclosed string literal errors
            ncSave();
            break;
          } else if (c == '\\') {
            ncSave();
            ncSave();
          } else
            ncSave();
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\''); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ncSave(); while (Character.isDigit(c));
        if (c == 'L') ncSave(); // Long constants like 1L
      } else
        ncSave();
        
      String t = buf.toString();
      buf.setLength(0);
      return t;
    }
  }
  
  return new X();
}

static <A> A popLast(List<A> l) {
  return liftLast(l);
}
static long getFileSize(String path) {
  return path == null ? 0 : new File(path).length();
}

static long getFileSize(File f) {
  return f == null ? 0 : f.length();
}
static int shorten_default = 100;

static String shorten(String s) { return shorten(s, shorten_default); }

static String shorten(String s, int max) {
  if (s == null) return "";
  if (max < 0) return s;
  return s.length() <= max ? s : s.substring(0, Math.min(s.length(), max)) + "...";
}

static String shorten(int max, String s) { return shorten(s, max); }
static DialogIO talkToThisVM() {
  return new talkToThisVM_IO();
}

static class talkToThisVM_IO extends DialogIO { 
  List<String> answers = ll(thisVMGreeting());
  
  boolean isLocalConnection() { return true; }
  boolean isStillConnected() { return true; }
  int getPort() { return vmPort(); }
  
  void sendLine(String line) {
    answers.add(or2(sendToThisVM_newThread(line), "?"));
  }
  
  String readLineImpl() { try {
    return popFirst(answers);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  void close() {}
  Socket getSocket() { return null; }
}
static boolean isLongConstant(String s) {
  if (!s.endsWith("L")) return false;
  s = s.substring(0, l(s)-1);
  return isInteger(s);
}
static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}
static boolean publicCommOn() {
  return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
}
static int[] toIntArray(List<Integer> l) {
  int[] a = new int[l(l)];
  for (int i = 0; i < a.length; i++)
    a[i] = l.get(i);
  return a;
}
static void quoteToPrintWriter(String s, PrintWriter out) {
  if (s == null) { out.print("null"); return; }
  out.print('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"') {
      out.print('\\'); out.print(c);
    } else if (c == '\r')
      out.print("\\r");
    else if (c == '\n')
      out.print("\\n");
    else
      out.print(c);
  }
  out.print('"');
}
static double parseDouble(String s) {
  return Double.parseDouble(s);
}
static <A> A println(A a) {
  return print(a);
}
public static File mkdirsFor(File file) {
  return mkdirsForFile(file);
}

public static String rtrim(String s) {
  int i = s.length();
  while (i > 0 && " \t\r\n".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}
static String callStaticAnswerMethod(List bots, String s) {
  for (Object c : bots) try {
    String answer = callStaticAnswerMethod(c, s);
    if (!empty(answer)) return answer;
  } catch (Throwable e) {
    print("Error calling " + getProgramID(c));
    e.printStackTrace();
  }
  return null;
}

static String callStaticAnswerMethod(Object c, String s) {
  String answer = (String) callOpt(c, "answer", s, litlist(s));
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}

static String callStaticAnswerMethod(String s) {
  return callStaticAnswerMethod(mc(), s);
}

static String callStaticAnswerMethod(String s, List<String> history) {
  return callStaticAnswerMethod(mc(), s, history);
}

static String callStaticAnswerMethod(Object c, String s, List<String> history) {
  String answer = (String) callOpt(c, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}
static int stdcompare(Number a, Number b) {
  return cmp(a, b);
}

static int stdcompare(String a, String b) {
  return cmp(a, b);
}

static int stdcompare(long a, long b) {
  return a < b ? -1 : a > b ? 1 : 0;
}

static int stdcompare(Object a, Object b) {
  return cmp(a, b);
}

static String shortDynamicClassName(Object o) {
 if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  return shortClassName(o);
}
static void removeFromMultiPort(long vport) {
  if (vport == 0) return;
  for (Object port : getMultiPorts())
    call(port, "removePort", vport);
}
static boolean setOptAllDyn_debug;

static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields)) {
    Object val = fields.get(field);
    boolean has = hasField(o, field);
    if (has)
      setOpt(o, field, val);
    else {
      o.fieldValues.put(field.intern(), val);
      if (setOptAllDyn_debug) print("setOptAllDyn added dyn " + field + " to " + o + " [value: " + val + ", fieldValues = " + systemHashCode(o.fieldValues) + ", " + struct(keys(o.fieldValues)) + "]");
    }
  }
}
static Object addToMultiPort_responder;

static long addToMultiPort(final String botName) {
  return addToMultiPort(botName, new Object() {
    public String answer(String s, List<String> history) {
      String answer = (String) ( callOpt(getMainClass(), "answer", s, history));
      if (answer != null) return answer;
      answer = (String) callOpt(getMainClass(), "answer", s);
      if (answer != null) return answer;
      if (match3("get injection id", s))
        return getInjectionID();
      return null;
    }
  });
}

static long addToMultiPort(final String botName, final Object responder) {
  //print(botName);
  addToMultiPort_responder = responder;
  startMultiPort();
  List ports = getMultiPorts();
  if (ports == null) return 0;
  if (ports.isEmpty())
    throw fail("No multiports!");
  if (ports.size() > 1)
    print("Multiple multi-ports. Using last one.");
  Object port = last(ports);
  Object responder2 = new Object() {
    public String answer(String s, List<String> history) {
      if (match3("get injection id", s))
        return getInjectionID();
      if (match3("your name", s))
        return botName;
      return (String) call(responder, "answer", s, history);
    }
  };
  record(responder2);
  return (Long) call(port, "addResponder", botName, responder2);
}

static HashMap<Class, Field[]> getDeclaredFields_cache = new HashMap();

static Field[] getDeclaredFields_cached(Class c) {
  Field[] fields;
  synchronized(getDeclaredFields_cache) {
    fields = getDeclaredFields_cache.get(c);
    if (fields == null) {
      getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
      for (Field f : fields)
        f.setAccessible(true);
    }
  }
  return fields;
}
static Producer<String> javaTokC_noMLS_iterator(final String s) {
  return new Producer<String>() {
    final int l = s.length();
    int i = 0;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}

static String getInjectionID() {
  return (String) call(getJavaX(), "getInjectionID", getMainClass());
}
static BufferedReader readLine_reader;

static String readLine() {
  return (String) call(getJavaX(), "readLine");
}
static char unquoteCharacter(String s) {
  assertTrue(s.startsWith("'") && s.length() > 1);
  return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length()-1 : s.length()) + "\"").charAt(0);
}
static <A> A nuStubInnerObject(Class<A> c) { try {
  Class outerType = getOuterClass(c);
  Constructor m = c.getDeclaredConstructor(outerType);
  m.setAccessible(true);
  return (A) m.newInstance(new Object[] {null});
} catch (Exception __e) { throw rethrow(__e); } }
static boolean[] boolArrayFromBytes(byte[] a, int n) {
  boolean[] b = new boolean[n];
  int m = min(n, l(a)*8);
  for (int i = 0; i < m; i++)
    b[i] = (a[i/8] & 1 << (i & 7)) != 0;
  return b;
}
static HashMap<String,Class> findClass_cache = new HashMap();

// currently finds only inner classes of class "main"
// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass(String name) {
  synchronized(findClass_cache) {
    if (findClass_cache.containsKey(name))
      return findClass_cache.get(name);
      
    if (!isJavaIdentifier(name)) return null;
    
    Class c;
    try {
      c = Class.forName("main$" + name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_cache.put(name, c);
    return c;
  }
}
static float parseFloat(String s) {
  return Float.parseFloat(s);
}
static String internIfLongerThan(String s, int l) {
  return s == null ? null : l(s) >= l ? s.intern() : s;
}
static void pcallOpt_noArgs(Object o, String method) {
  try { callOpt_noArgs(o, method); } catch (Throwable __e) { printStackTrace2(__e); }
}
static List<String> javaTokC(String s) {
  int l = s.length();
  ArrayList<String> tok = new ArrayList();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(quickSubstring(s, i, j));
    i = j;
  }
  
  return tok;
}

static void printStructure(String prefix, Object o) {
  if (endsWithLetter(prefix)) prefix += ": ";
  print(prefix + structureForUser(o));
}

static void printStructure(Object o) {
  print(structureForUser(o));
}

static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}
static String processID_cached;

// try to get our current process ID
static String getPID() {
  if (processID_cached == null) {
    String name = ManagementFactory.getRuntimeMXBean().getName();
    processID_cached = name.replaceAll("@.*", "");
  }
  return processID_cached;
}
static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}
static boolean isLocalhost(String ip) {
  return isLoopbackIP(ip) || eqic(ip, "localhost");
}


static <A> Set<A> synchroTreeSet() {
  return Collections.synchronizedSet(new TreeSet<A>());
}

static boolean hasField(Object o, String field) {
  return findField2(o, field) != null;
}
static String thisVMGreeting() {
  List record_list = (List) ( get(getJavaX(), "record_list"));
  Object android = first(record_list); // Should be of class Android3
  return getString(android, "greeting");
}
static boolean isNonNegativeInteger(String s) {
  return s != null && Pattern.matches("\\d+", s);
}
static boolean forbiddenPort(int port) {
  return port == 5037; // adb
}

// This is made for NL parsing.
// It's javaTok extended with "..." token, "$n" and "#n" and
// special quotes (which are converted to normal ones).

static List<String> javaTokPlusPeriod(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    cc = s.substring(i, Math.min(i+2, l));

    // scan for non-whitespace
    if (c == '\u201C' || c == '\u201D') c = '"'; // normalize quotes
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        char _c = s.charAt(j);
        if (_c == '\u201C' || _c == '\u201D') _c = '"'; // normalize quotes
        if (_c == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
      if (j-1 >= i+1) {
        tok.add(opener + s.substring(i+1, j-1) + opener);
        i = j;
        continue;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for things like "this one's"
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else if (cc.equals("[[")) {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (cc.equals("[=") && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else if (s.substring(j, Math.min(j+3, l)).equals("..."))
      j += 3;
    else if (c == '$' || c == '#')
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}

static String makeRandomID(int length) {
  Random random = new Random();
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}
static String struct(Object o) {
  return structure(o);
}
static Class getOuterClass(Class c) { try {
  String s = c.getName();
  int i = s.lastIndexOf('$');
  return Class.forName(substring(s, 0, i));
} catch (Exception __e) { throw rethrow(__e); } }
static String parse3_cached_s;
static List<String> parse3_cached_l;

  static synchronized List<String> parse3_cached(String s) {
    if (neq(s, parse3_cached_s))
      parse3_cached_l = parse3(parse3_cached_s = s);
    return parse3_cached_l;
  }
static List<Object> getMultiPorts() {
  return (List) callOpt(getJavaX(), "getMultiPorts");
}
static String emptyToNull(String s) {
  return eq(s, "") ? null : s;
}
static String structureForUser(Object o) {
  structure_Data data = new structure_Data();
  data.shareStringsLongerThan = Integer.MAX_VALUE;
  return structure(o, data);
}
// start multi-port if none exists in current VM.
static void startMultiPort() {
  List mp = getMultiPorts();
  if (mp != null && mp.isEmpty()) {
    nohupJavax("#1001639");
    throw fail("Upgrading JavaX, please restart this program afterwards.");
    //callMain(hotwire("#1001672"));
  }
}
static <A> A liftLast(List<A> l) {
  if (l.isEmpty()) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}
static int myVMPort() {
  List records = (List) ( get(getJavaX(), "record_list"));
  Object android = records.get(records.size()-1);
  return (Integer) get(android, "port");
}
static boolean isLoopbackIP(String ip) {
  return eq(ip, "127.0.0.1");
}
static int systemHashCode(Object o) {
  return identityHashCode(o);
}
static String or2(String a, String b) {
  return nempty(a) ? a : b;
}
static byte[] boolArrayToBytes(boolean[] a) {
  byte[] b = new byte[(l(a)+7)/8];
  for (int i = 0; i < l(a); i++)
    if (a[i])
      b[i/8] |= 1 << (i & 7);
  return b;
}
static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}
static String sendToThisVM_newThread(String s, Object... args) {
  final String _s = format(s, args);
  try {
    return (String) evalInNewThread(new Object() { Object get() { try { return 
      callStaticAnswerMethod(getJavaX(), _s)
    ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callStaticAnswerMethod(getJavaX(), _s)"; }});
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    return str(e);
  }
}
  static List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }
static <A> A popFirst(List<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(0);
  return a;
}
static WeakHashMap<Class, HashMap<String, Method>> callOpt_noArgs_cache = new WeakHashMap();

static Object callOpt_noArgs(Object o, String method) { try {
  if (o == null) return null;
  if (o instanceof Class)
    return callOpt(o, method); // not optimized
  
  Class c = o.getClass();
  HashMap<String, Method> map;
  synchronized(callOpt_noArgs_cache) {
    map = callOpt_noArgs_cache.get(c);
    if (map == null)
      map = callOpt_noArgs_makeCache(c);
  }

  Method m = map.get(method);
  return m != null ? m.invoke(o) : null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
  HashMap<String,Method> map = new HashMap();
  Class _c = c;
  do {
    for (Method m : c.getDeclaredMethods())
      if (m.getParameterTypes().length == 0) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  callOpt_noArgs_cache.put(c, map);
  return map;
}
  static String format(String pat, Object... args) {
    return format3(pat, args);
  }

static boolean match(String pat, String s) {
  return match3(pat, s);
}

static boolean match(String pat, String s, Matches matches) {
  return match3(pat, s, matches);
}

static int parseHexByte(String s) {
  return Integer.parseInt(s, 16);
}


static int identityHashCode(Object o) {
  return System.identityHashCode(o);
}
static void nohupJavax(final String javaxargs) {
  { Thread _t_2 = new Thread() {
public void run() { try { call(hotwireOnce("#1008562"), "nohupJavax", javaxargs); } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_2); }
}

static void nohupJavax(final String javaxargs, final String vmArgs) {
  { Thread _t_3 = new Thread() {
public void run() { try { call(hotwireOnce("#1008562"), "nohupJavax", javaxargs, vmArgs); } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_3); }
}
static Object evalInNewThread(final Object f) {
  final Flag flag = new Flag();
  final Var var = new Var();
  final Var<Throwable> exception = new Var();
  { Thread _t_4 = new Thread() {
public void run() { try {
    try {
      var.set(callF(f));
    } catch (Throwable e) {
      exception.set(e);
    }
    flag.raise();
  } catch (Throwable __e) { printStackTrace2(__e); } }
};
startThread(_t_4); }
  flag.waitUntilUp();
  if (exception.has()) throw rethrow(exception.get());
  return var.get();
}
static List<String> dropPunctuation_keep = litlist("*", "<", ">");

static List<String> dropPunctuation(List<String> tok) {
  tok = new ArrayList<String>(tok);
  for (int i = 1; i < tok.size(); i += 2) {
    String t = tok.get(i);
    if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
      tok.set(i-1, tok.get(i-1) + tok.get(i+1));
      tok.remove(i);
      tok.remove(i);
      i -= 2;
    }
  }
  return tok;
}

static String dropPunctuation(String s) {
  return join(dropPunctuation(nlTok(s)));
}
static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}
static Field findField2(Object o, String field) {
  if (o instanceof Class) return findField2_findStaticField((Class) o, field);
  return findField2_findField(o.getClass(), field);
}

static Field findField2_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field findField2_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}


static List<String> nlTok(String s) {
  return javaTokPlusPeriod(s);
}
static RuntimeException rethrow(Throwable e) {
  throw asRuntimeException(e);
}


final static class IntRange {
  int start, end;
  
  IntRange() {}
  IntRange(int start, int end) {
  this.end = end;
  this.start = start;}
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
  
  int length() { return end-start; }
}

static class ConceptFieldIndex<A extends Concept, Val> implements IConceptIndex, IFieldIndex<A, Val> {
  Class<A> cc;
  String field;
  HashMap<A,Val> objectToValue = new HashMap();
  MultiMap<Val,A> valueToObject = new MultiMap();
  
  ConceptFieldIndex() {}
  ConceptFieldIndex(Class<A> cc, String field) { this(mainConcepts, cc, field); }
  ConceptFieldIndex(Concepts concepts, Class<A> cc, String field) {
  this.field = field;
  this.cc = cc;
    concepts.addConceptIndex(this);
    for (A c : list(concepts, cc))
      update(c);
    concepts.addFieldIndex(cc, field, this);
  }
  
  public synchronized void update(Concept c) {
    Val newValue = (Val) ( cget(c, field));
    Val oldValue = objectToValue.get(c);
    if (newValue == null || newValue != oldValue) {
      valueToObject.remove(oldValue, (A) c);
      valueToObject.put(newValue, (A) c);
      objectToValue.put((A) c, newValue);
    }
  }
  
  public synchronized void remove(Concept c) {
    Val value = (Val) ( cget(c, field));
    objectToValue.remove(c);
    valueToObject.remove(value, (A) c);
  }
  
  synchronized A get(Val value) {
    return valueToObject.getFirst(value);
  }
  
  public synchronized List<A> getAll(Val value) {
    
    
      return valueToObject.get(value);
    
  }
}

abstract static class AbstractLayoutManager implements LayoutManager {
  Dimension preferredSize = new Dimension(100, 100);

  public void addLayoutComponent(String name, Component comp) {}
  public void removeLayoutComponent(Component comp) {}
  
  public Dimension preferredLayoutSize(Container parent) {
    layoutContainer(parent);
    return preferredSize;
  }
  
  public Dimension minimumLayoutSize(Container parent) {
    return new Dimension(10, 10);
  }
}

static abstract class F0<A> {
  abstract A get();
}

static abstract class F1<A, B> {
  abstract B get(A a);
}

static class AutoComboBox extends JComboBox<Object> {
  String keyWord[] = {"item1", "item2", "item3"};
  Vector myVector = new Vector();
  
  public AutoComboBox() {
      setModel(new DefaultComboBoxModel(myVector));
      setSelectedIndex(-1);
      setEditable(true);
      JTextField text = (JTextField) this.getEditor().getEditorComponent();
      text.setFocusable(true);
      text.setText("");
      text.addKeyListener(new ComboListener(this, myVector));
      setMyVector();
  }
  
  /**
   * set the item list of the AutoComboBox
   * @param keyWord an String array
   */
  void setKeyWord(String[] keyWord) {
      this.keyWord = keyWord;
      setMyVectorInitial();
  }
  
  void setKeyWord(Collection<String> keyWord) {
    setKeyWord(toStringArray(keyWord));
  }
  
  private void setMyVector() {
      int a;
      for (a = 0; a < keyWord.length; a++)
          myVector.add(keyWord[a]);
  }
  
  private void setMyVectorInitial() {
      myVector.clear();
      int a;
      for (a = 0; a < keyWord.length; a++)
          myVector.add(keyWord[a]);
  }
}

static class ComboListener extends KeyAdapter {
  JComboBox cbListener;
  Vector vector;
  
  public ComboListener(JComboBox cbListenerParam, Vector vectorParam)
  {
      cbListener = cbListenerParam;
      vector = vectorParam;
  }
  
  public void keyReleased(KeyEvent key)
  {
    JTextField tf = (JTextField) ( cbListener.getEditor().getEditorComponent());
    
    if (tf.getCaretPosition() != l(tf.getText())) return;
    
    String text = ((JTextField)key.getSource()).getText();

    cbListener.setModel(new DefaultComboBoxModel(getFilteredList(text)));
    cbListener.setSelectedIndex(-1);
    tf.setText(text);
    cbListener.showPopup();
  }
  
  
  public Vector getFilteredList(String text)
  {
      return new Vector(scoredSearch(text, vector));
  }
}

static class ReliableSingleThread {
  Object runnable;
  boolean running, trigger;
  
  ReliableSingleThread(Object runnable) {
  this.runnable = runnable;}
  
  void trigger() { go(); }
  synchronized void go() {
    trigger = true;
    if (!running) {
      running = true;
      { /*nt*/ Thread _t_0 = new Thread("Single Thread") {
public void run() { /* in run */ try { /* in thread */ 
   _run(); /* in thread */ } catch (Throwable __e) { printStackTrace2(__e); } /* in run */ }
};
startThread(_t_0); }
    }
  }
  
  boolean running() { return running; }
  
  void _run() {
    while (licensed()) {
      synchronized(this) {
        if (!trigger) {
          running = false;
          break;
        }
        trigger = false;
      }
      pcallF(runnable);
    }
  }
}

static interface Producer<A> {
  public A next();
}

static class SingleComponentPanel extends JPanel {
  SingleComponentPanel() { super(new BorderLayout()); }

  SingleComponentPanel(Component component) {
    this();
    setComponent(component);
  }

  void setComponent(Component component) {
    removeAll();
    if (component != null)
      add(BorderLayout.CENTER, wrap(component));
    main.revalidate(this);
  }
  
  void noComponent() { setComponent(null); }
}

static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

static class DynamicObject {
  String className; // just the name, without the "main$"
  LinkedHashMap<String,Object> fieldValues = new LinkedHashMap();
  
  DynamicObject() {}
  // className = just the name, without the "main$"
  DynamicObject(String className) {
  this.className = className;}
}

/** this class is fully thread-safe */
static class Flag {
  private boolean up;

  /** returns true if flag was down before */
  public synchronized boolean raise() {
    if (!up) {
      up = true;
      notifyAll();
      return true;
    } else
      return false;
  }

  public synchronized void waitUntilUp() {
    while (!up) {
      try {
        wait();
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized void waitUntilUp(long timeout) {
    if (!up) {
      try {
        wait(timeout);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized boolean isUp() {
    return up;
  }

  public String toString() {
    return isUp() ? "up" : "down";
  }

  // currently does a semi-active wait with latency = 50 ms
  public void waitForThisOr(Flag otherFlag) { try {
    while (!isUp() && !otherFlag.isUp())
      Thread.sleep(50);
  } catch (Exception __e) { throw rethrow(__e); } }
}

static class Pair<A, B> {
  A a;
  B b;

  Pair() {}
  Pair(A a, B b) {
  this.b = b;
  this.a = a;}
  
  public int hashCode() {
    return main.hashCode(a) + 2*main.hashCode(b);
  }
  
  public boolean equals(Object o) {
    if (o == this) return true;
    if (!(o instanceof Pair)) return false;
    Pair t = (Pair) o;
    return eq(a, t.a) && eq(b, t.b);
  }
}

static class Var<A> {
  A v; // you can access this directly if you use one thread
  
  Var() {}
  Var(A v) {
  this.v = v;}
  
  synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  synchronized A get() { return v; }
  synchronized boolean has() { return v != null; }
  synchronized void clear() { v = null; }
}

static class ProgramScan {
  static int threads = isWindows() ? 500 : 10;
  static int timeout = 5000; // hmm...
  static String ip = "127.0.0.1";
  
  // This range is not used anymore anyway
  static int quickScanFrom = 10000, quickScanTo = 10999;

  static int maxNumberOfVMs_android = 4; // Android will always only have one if we don't screw up
  static int maxNumberOfVMs_nonAndroid = 50; // 100;
  static int maxNumberOfVMs;
  
  static boolean verbose;
  
  static class Program {
    int port;
    String helloString;
    
    Program(int port, String helloString) {
  this.helloString = helloString;
  this.port = port;}
  }
  
  static List<Program> scan() { try {
    return scan(1, 65535);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  static List<Program> scan(int fromPort, int toPort) {
    return scan(fromPort, toPort, new int[0]);
  }
  
  static List<Program> scan(int fromPort, int toPort, int[] preferredPorts) { try {
    Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
    int scanSize = toPort-fromPort+1;
    String name = toPort < 10000 ? "bot" : "program";
    int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
    final ExecutorService es = Executors.newFixedThreadPool(threads);
    if (verbose) print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
    startTiming();
    List < Future < Program > > futures = new ArrayList();
    List<Integer> ports = new ArrayList();
    for (int port : preferredPorts) {
      futures.add(checkPort(es, ip, port, timeout));
      ports.add(port);
    }
    for (int port = fromPort; port <= toPort; port++)
      if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
        futures.add(checkPort(es, ip, port, timeout));
        ports.add(port);
      }
    es.shutdown();
    List<Program> programs = new ArrayList();
    long time = now();
    int i = 0;
    for (final Future<Program> f : futures) {
      if (verbose) print("Waiting for port " + get(ports, i++) + " at time " + (now()-time));
      Program p = f.get();
      if (p != null)
        programs.add(p);
    }
    //stopTiming("Port Scan " + scanSize + ", " + n(threads, "threads") + ": ", 250);
    if (verbose) print("Found " + programs.size() + " " + name + "(s) on " + ip);
    return programs;
  } catch (Exception __e) { throw rethrow(__e); } }

  static Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
    return es.submit(new Callable<Program>() {
        @Override public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              //if (verbose) print("Connected to " + ip + ":" + port);
              BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
     });
  }
  
  static List<Program> quickScan() {
    return scan(quickScanFrom, quickScanTo);
  }
  
  static List<Program> quickBotScan() {
    return quickBotScan(new int[0]);
  }
  
  static List<Program> quickBotScan(int[] preferredPorts) {
    if (maxNumberOfVMs == 0)
      maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
    return scan(4999, 5000+maxNumberOfVMs-1, preferredPorts);
  }
}

  static abstract class DialogIO {
    String line;
    boolean eos, loud, noClose;
    
    abstract String readLineImpl();
    abstract boolean isStillConnected();
    abstract void sendLine(String line);
    abstract boolean isLocalConnection();
    abstract Socket getSocket();
    abstract void close();
    
    int getPort() { Socket s = getSocket(); return s == null ? 0 : s.getPort(); }
    
    boolean helloRead;
    int shortenOutputTo = 500;
    
    String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }
    
    boolean waitForLine() { try {
      if (line != null) return true;
      //print("Readline");
      line = readLineImpl();
      //print("Readline done: " + line);
      if (line == null) eos = true;
      return line != null;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }
    
    String ask(String s, Object... args) {
      if (loud) return askLoudly(s, args);
      if (!helloRead) readLine();
      if (args.length != 0) s = format3(s, args);
      sendLine(s);
      return readLine();
    }
    
    String askLoudly(String s, Object... args) {
      if (!helloRead) readLine();
      if (args.length != 0) s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }
    
    void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }
  
  static abstract class DialogHandler {
    abstract void run(DialogIO io);
  }

static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  String fsi(int i) { return formatSnippetID(unq(i)); }
  String fsi() { return fsi(0); }
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
}


// uses HashMap by default
static class MultiSet<A> {
  Map<A, Integer> map = new HashMap();
  
  public MultiSet(boolean useTreeMap) {
    if (useTreeMap)
      map = new TreeMap();
  }
  
  public MultiSet() {
  }
  
  public MultiSet(Collection<A> c) {
    addAll(c);
  }

  public void add(A key) {
    add(key, 1);
  }
  
  public void addAll(Collection<A> c) {
    if (c != null) for (A a : c)
      add(a);
  }

  void addAll(MultiSet<A> ms) {
    for (A a : ms.keySet())
      add(a, ms.get(a));
  }
  
  public void add(A key, int count) {
    if (map.containsKey(key))
      map.put(key, map.get(key)+count);
    else
      map.put(key, count);
  }

  public int get(A key) {
    return key != null && map.containsKey(key) ? map.get(key) : 0;
  }
  
  public boolean contains(A key) {
    return map.containsKey(key);
  }

  public void remove(A key) {
    Integer i = map.get(key);
    if (i != null && i > 1)
      map.put(key, i - 1);
    else
      map.remove(key);
  }

  public List<A> getTopTen() {
    return getTopTen(10);
  }
  
  public List<A> getTopTen(int maxSize) {
    List<A> list = getSortedListDescending();
    return list.size() > maxSize ? list.subList(0, maxSize) : list;
  }
  
  List<A> highestFirst() {
    return getSortedListDescending();
  }

  List<A> lowestFirst() {
    return reversedList(getSortedListDescending());
  }

  public List<A> getSortedListDescending() {
    List<A> list = new ArrayList<A>(map.keySet());
    Collections.sort(list, new Comparator<A>() {
      public int compare(A a, A b) {
        return map.get(b).compareTo(map.get(a));
      }
    });
    return list;
  }

  public int getNumberOfUniqueElements() {
    return map.size();
  }
  
  int uniqueSize() {
    return map.size();
  }

  public Set<A> asSet() {
    return map.keySet();
  }

  Set<A> keySet() { // synonym for idiots
    return map.keySet();
  }
  
  public A getMostPopularEntry() {
    int max = 0;
    A a = null;
    for (Map.Entry<A,Integer> entry : map.entrySet()) {
      if (entry.getValue() > max) {
        max = entry.getValue();
        a = entry.getKey();
      }
    }
    return a;
  }

  public void removeAll(A key) {
    map.remove(key);
  }

  public int size() {
    int size = 0;
    for (int i : map.values())
      size += i;
    return size;
  }

  public MultiSet<A> mergeWith(MultiSet<A> set) {
    MultiSet<A> result = new MultiSet<A>();
    for (A a : set.asSet()) {
      result.add(a, set.get(a));
    }
    return result;
  }
  
  public boolean isEmpty() {
    return map.isEmpty();
  }
  
  public String toString() {
    return str(map);
  }
  
  public void clear() {
    map.clear();
  }
  
  Map<A, Integer> asMap() {
    return cloneMap(map);
  }
}


// A concept should be an object, not just a string.

static int concepts_internStringsLongerThan = 10;
static ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

static interface Derefable {
  Concept get();
}

static interface IConceptIndex {
  void update(Concept c); // also for adding
  void remove(Concept c);
}

static interface IFieldIndex<A extends Concept, Val> {
  List<A> getAll(Val val);
}

static class Concepts {
  Map<Long, Concept> concepts = synchroTreeMap();
  HashMap<Class,Object> perClassData = new HashMap();
  String programID; // set to "-" for non-persistent (possibly not implemented)
  long idCounter;
  volatile long changes = 1, changesWritten;
  volatile java.util.Timer autoSaver;
  volatile boolean savingConcepts;
  int autoSaveInterval = -1000; // 1 second + wait logic
  boolean useGZIP = true, quietSave;
  ReentrantLock lock = new ReentrantLock(true);
  ReentrantLock saverLock = new ReentrantLock(true);
  long lastSaveTook, lastSaveWas;
  float maxAutoSavePercentage = 10;
  List<IConceptIndex> conceptIndices;
  Map<Class<? extends Concept>, Map<String, IFieldIndex>> fieldIndices;
  
  Concepts() {}
  Concepts(String programID) {
  this.programID = programID;}
  
  synchronized long internalID() {
    do {
      ++idCounter;
    } while (hasConcept(idCounter));
    return idCounter;
  }
  
  void initProgramID() {
    if (programID == null)
      programID = getDBProgramID();
  }
  
  // Now tries to load from bot first, then go to disk.
  Concepts load() {
    return load(false);
  }
  
  Concepts safeLoad() {
    return load(true);
  }
  
  Concepts load(boolean allDynamic) {
    initProgramID();
    if (tryToGrab(allDynamic)) return this;
    return loadFromDisk(allDynamic);
  }
  
  Concepts loadFromDisk() { return loadFromDisk(false); }
  
  Concepts loadFromDisk(boolean allDynamic) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      long time = now();
      Map<Long, Concept> _concepts = concepts; // empty map
      readLocally2_allDynamic.set(allDynamic);
      readLocally2(this, programID, "concepts");
      Map<Long, Concept> __concepts = concepts;
      concepts = _concepts;
      concepts.putAll(__concepts);
      int l = readLocally_stringLength;
      int tokrefs = unstructure_tokrefs;
      assignConceptsToUs();
      done("Loaded " + n(l(concepts), "concepts"), time);
      if (fileSize(getProgramFile(programID, "idCounter.structure")) != 0)
        readLocally2(this, programID, "idCounter");
      else
        calcIdCounter();
    } finally {
      DynamicObject_loading.set(null);
    }
    allChanged();
    return this;
  }
  
  Concepts loadConcepts() { return load(); }
  
  boolean tryToGrab(boolean allDynamic) {
    if (sameSnippetID(programID, getDBProgramID())) return false;
    RemoteDB db = connectToDBOpt(programID);
    try {
      if (db != null) {
        loadGrab(db.fullgrab(), allDynamic);
        return true;
      }
    } finally {
      if (db != null) db.close();
    }
    return false;
  }
  
  Concepts load(String grab) {
    return loadGrab(grab, false);
  }
  
  Concepts safeLoad(String grab) {
    return loadGrab(grab, true);
  }
  
  Concepts loadGrab(String grab, boolean allDynamic) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      Map<Long, Concept> map = (Map)
        (allDynamic ? safeUnstructure(grab) : unstructure(grab));
      concepts.putAll(map);
      assignConceptsToUs();
      for (long l : map.keySet())
        idCounter = max(idCounter, l);
    } finally {
      DynamicObject_loading.set(null);
    }
    allChanged();
    return this;
  }
  
  void assignConceptsToUs() {
    for (Concept c : values(concepts)) {
      c._concepts = this;
      callOpt_noArgs(c, "_doneLoading2");
    }
  }

  String progID() {
    return programID == null ? getDBProgramID() : programID;
  }
  
  Concept getConcept(String id) {
    return empty(id) ? null : getConcept(parseLong(id));
  }
  
  Concept getConcept(long id) {
    return (Concept) concepts.get((long) id);
  }
  
  Concept getConcept(RC ref) {
    return ref == null ? null : getConcept(ref.longID());
  }
  
  boolean hasConcept(long id) {
    return concepts.containsKey((long) id);
  }
  
  void deleteConcept(long id) {
    Concept c = getConcept(id);
    if (c == null)
      print("Concept " + id + " not found");
    else
      c.delete();
  }
  
  void calcIdCounter() {
    long id_ = 0;
    for (long id : keys(concepts))
      id_ = max(id_, id);
    idCounter = id_+1;
    saveLocally2(this, programID, "idCounter");
  }
  
  void saveConceptsIfDirty() { saveConcepts(); }
  void save() { saveConcepts(); }

  void saveConcepts() {
    initProgramID();
    saverLock.lock();
    savingConcepts = true;
    long start = now(), time;
    try {
      String s = null;
      //synchronized(main.class) {
      File f = getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
      long _changes = changes;
      if (_changes == changesWritten) return;
      
      lock.lock();
      long fullTime = now();
      try {
        saveLocally2(this, programID, "idCounter");
        
        if (useGZIP) {
          saveGZStructureToFile(f, cloneMap(concepts));
          getProgramFile(programID, "concepts.structure").delete();
        } else
          s = structure(cloneMap(concepts));
      } finally {
        lock.unlock();
      }

      changesWritten = _changes; // only update when structure didn't fail
      
      if (!useGZIP) {
        time = now()-start;
        if (!quietSave)
          print("Saving " + toM(l(s)) + "M chars (" /*+ changesWritten + ", "*/ + time + " ms)");
        start = now();
        saveTextFile(f, javaTokWordWrap(s));
        getProgramFile(programID, "concepts.structure.gz").delete();
      }
      
      copyFile(f, getProgramFile(programID, "concepts.structure" + (useGZIP ? ".gz" : "") + ".backup" + ymd() + "-" + formatInt(hours(), 2)));
      time = now()-start;
      if (!quietSave)
        print(programID + ": Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
      lastSaveWas = fullTime;
      lastSaveTook = now()-fullTime;
    } finally {
      savingConcepts = false;
      saverLock.unlock();
    }
  }
  
  void _autoSaveConcepts() {
    if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
      long pivotTime = Math.round(lastSaveWas+lastSaveTook*100.0/maxAutoSavePercentage);
      if (now() < pivotTime) {
        //print("Skipping auto-save (last save took " + lastSaveTook + ")");
        return;
      }
    }
    saveConcepts();
  }
  
  void clearConcepts() {
    concepts.clear();
    allChanged();
  }
  
  synchronized void allChanged() {
    ++changes;
  }
  
  // auto-save every second if dirty
  synchronized void autoSaveConcepts() {
    if (autoSaver == null) {
      if (isTransient()) throw fail("Can't persist transient database");
      autoSaver = doEvery_daemon(abs(autoSaveInterval), new Runnable() { public void run() { try {  _autoSaveConcepts() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_autoSaveConcepts()"; }});
      // print("Installed auto-saver (" + autoSaveInterval + " ms, " + progID() + ")");
    }
  }
  
  void cleanMeUp() {
    if (autoSaver != null) {
      autoSaver.cancel();
      autoSaver = null;
      while (savingConcepts) sleepInCleanUp(10);
      saveConceptsIfDirty();
    }
  }
  
  Map<Long, String> getIDsAndNames() {
    Map<Long,String> map = new HashMap();
    Map<Long, Concept> cloned = cloneMap(concepts);
    for (long id : keys(cloned)) 
      map.put(id, cloned.get(id).className);
    return map;
  }
  
  void deleteConcepts(List l) {
    for (Object o : l)
      if (o instanceof Long)
        concepts.remove((Long) o);
      else if (o instanceof Concept)
        ((Concept) o).delete();
      else
        warn("Can't delete " + getClassName(o));
  }
  
  <A extends Concept> A conceptOfType(Class<A> type) {
    return firstOfType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> conceptsOfType(Class<A> type) {
    return filterByType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> listConcepts(Class<A> type) {
    return conceptsOfType(type);
  }
  
  <A extends Concept> List<A> list(Class<A> type) {
    return conceptsOfType(type);
  }
  
  List<Concept> list(String type) {
    return conceptsOfType(type);
  }
  
  List<Concept> conceptsOfType(String type) {
    return filterByDynamicType(allConcepts(), "main$" + type);
  }
  
  boolean hasConceptOfType(Class<? extends Concept> type) {
    return hasType(allConcepts(), type);
  }
  
  void persistConcepts() {
    loadConcepts();
    autoSaveConcepts();
  }
  
  // We love synonyms
  void conceptPersistence() {
    persistConcepts();
  }
  
  void persist() { persistConcepts(); }
  void persist(int interval) { autoSaveInterval = interval; persist(); }
    
  // Runs r if there is no concept of that type
  <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
    A a = conceptOfType(c);
    if (a == null) {
      r.run();
      a = conceptOfType(c);
      if (a == null)
        throw fail("Concept not made by " + r + ": " + shortClassName(c));
    }
    return a;
  }
  
  // Ensures that every concept of type c1 is ref'd by a concept of
  // type c2.
  // Type of func: voidfunc(concept)
  void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
    for (Concept a : conceptsOfType(c1)) {
      Concept b = findBackRef(a, c2);
      if (b == null) {
        callF(func, a);
        b = findBackRef(a, c2);
        if (b == null)
          throw fail("Concept not made by " + func + ": " + shortClassName(c2));
      }
    }
  }
  
  // Type of func: voidfunc(concept)
  void forEvery(Class<? extends Concept> type, Object func) {
    for (Concept c : conceptsOfType(type))
      callF(func, c);
  }
  
  int deleteAll(Class<? extends Concept> type) {
    List<Concept> l = (List) conceptsOfType(type);
    for (Concept c : l) c.delete();
    return l(l);
  }
  
  Collection<Concept> allConcepts() {
    synchronized(concepts) {
      return new ArrayList(values(concepts));
    }
  }
  
  <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    int n = 0;
    for (A x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts(String c, Object... params) {
    int n = 0;
    for (Concept x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts() {
    return l(concepts);
  }
  
  synchronized void addConceptIndex(IConceptIndex index) {
    if (conceptIndices == null)
      conceptIndices = new ArrayList();
    conceptIndices.add(index);
  }
  
  synchronized void addFieldIndex(Class<? extends Concept> c, String field, IFieldIndex index) {
    if (fieldIndices == null)
      fieldIndices = new HashMap();
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    if (map == null)
      fieldIndices.put(c, map = new HashMap());
    map.put(field, index);
  }
  
  synchronized IFieldIndex getFieldIndex(Class<? extends Concept> c, String field) {
    if (fieldIndices == null) return null;
    Map<String, IFieldIndex> map = fieldIndices.get(c);
    return map == null ? null : map.get(field);
  }
  
  // inter-process methods
  
  RC xnew(String name, Object... values) {
    return new RC(cnew(name, values));
  }
  
  void xset(long id, String field, Object value) {
    xset(new RC(id), field, value);
  }
  
  void xset(RC c, String field, Object value) {
    if (value instanceof RC)
      value = getConcept((RC) value);
    cset(getConcept(c), field, value);
  }
  
  Object xget(long id, String field) {
    return xget(new RC(id), field);
  }
  
  Object xget(RC c, String field) {
    return xgetPost(cget(getConcept(c), field));
  }
  
  Object xgetPost(Object o) {
    o = deref(o);
    if (o instanceof Concept)
      return new RC((Concept) o);
    return o;
  }
  
  void xdelete(long id) {
    xdelete(new RC(id));
  }
  
  void xdelete(RC c) {
    getConcept(c).delete();
  }
  
  void xdelete(List<RC> l) {
    for (RC c : l)
      xdelete(c);
  }
  
  List<RC> xlist() {
    return map("toPassRef", allConcepts());
  }
  
  List<RC> xlist(String className) {
    return map("toPassRef", conceptsOfType(className));
  }
  
  boolean isTransient() { return eq(programID, "-"); }
  
  String xfullgrab() {
    lock.lock();
    try {
      if (changes == changesWritten && !isTransient())
        return loadConceptsStructure(programID);
      return structure(cloneMap(concepts));
    } finally {
      lock.unlock();
    }
  }
  
  void xshutdown() {
    // Killing whole VM if someone wants this DB to shut down
    cleanKillVM();
  }
  
  long xchangeCount() { return changes; }
  int xcount() { return countConcepts(); }
  
  void register(Concept c) {
    if (c._concepts == this) return;
    if (c._concepts != null) throw fail("Can't re-register");
    c._concepts = this;
    c.id = internalID();
    c.created = now();
    concepts.put((long) c.id, c);
    c.change();
  }
  
} // class Concepts

static volatile Concepts mainConcepts = new Concepts(); // Where we create new concepts

static class Concept extends DynamicObject {
  transient Concepts _concepts; // Where we belong
  long id;
  //O madeBy;
  //double energy;
  //bool defunct;
  long created;
  
  // used only internally (cnew)
  Concept(String className) {
    super(className);
    _created();
  }
  
  Concept() {
    if (!_loading()) {
      //className = shortClassName(this); // XXX - necessary?
      //print("New concept of type " + className);
      _created();
    }
  }
  
  List<Ref> refs;
  List<Ref> backRefs;
  
  static boolean loading() { return _loading(); }
  static boolean _loading() { return isTrue(DynamicObject_loading.get()); }

  void _created() {
    if (!isTrue(concepts_unlisted.get()))
      mainConcepts.register(this);
  }
  
  /*void put(S field, O value) {
    fieldValues.put(field, value);
    change();
  }
  
  O get(S field) {
    ret fieldValues.get(field);
  }*/
  
  class Ref<A extends Concept> {
    A value;
    
    Ref() {
      if (!isTrue(DynamicObject_loading.get())) refs = addDyn(refs, this);
    }
    
    Ref(A value) {
  this.value = value;
      refs = addDyn(refs, this);
      index();
    }
    
    // get owning concept (source)
    Concept concept() {
      return Concept.this;
    }
    
    // get target
    A get() { return value; }
    boolean has() { return value != null; }
    
    void set(A a) {
      if (a == value) return;
      unindex();
      value = a;
      index();
    }
    
    void set(Ref<A> ref) { set(ref.get()); }
    void clear() { set((A) null); }
    
    void index() { 
      if (value != null)
        value.backRefs = addDyn(value.backRefs, this);
      change();
    }
    
    void unindex() {
      if (value != null)
        value.backRefs = removeDyn(value.backRefs, this);
    }
    
    void change() {
      Concept.this.change();
    }
  }
  
  class RefL<A extends Concept> extends AbstractList<A> {
    List < Ref < A > > l = new ArrayList();
    
    public A set(int i, A o) {
      A prev = l.get(i).get();
      l.get(i).set(o);
      return prev;
    }
    
    public void add(int i, A o) {
      l.add(i, new Ref(o));
    }
    
    public A get(int i) {
      return l.get(i).get();
    }
    
    public A remove(int i) {
      return l.remove(i).get();
    }
    
    public int size() {
      return l.size();
    }
    
    public boolean contains(Object o) {
      if (o instanceof Concept)
        for (Ref<A> r : l) if (eq(r.get(), o)) return true;
      return super.contains(o);
    }
  }
  
  void delete() {
    //name = "[defunct " + name + "]";
    //defunct = true;
    //energy = 0;
    for (Ref r : unnull(refs))
      r.unindex();
    refs = null;
    for (Ref r : cloneList(backRefs))
      r.set((Concept) null);
    backRefs = null;
    
    if (_concepts != null) {
      _concepts.concepts.remove((long) id);
      _concepts.allChanged();
      if (_concepts.conceptIndices != null)
        for (IConceptIndex index : _concepts.conceptIndices)
          index.remove(this);
      _concepts = null;
    }
    id = 0;
  }
  
  BaseXRef export() {
    return new BaseXRef(_concepts.progID(), id);
  }
  
  // notice system of a change in this object
  void change() {
    if (_concepts != null) {
      _concepts.allChanged();
      if (_concepts.conceptIndices != null)
        for (IConceptIndex index : _concepts.conceptIndices)
          index.update(this);
    }
  }
  
  String _programID() {
    return _concepts == null ? getDBProgramID() : _concepts.progID();
  }
} // class Concept

// remote reference (for inter-process communication or
// external databases). Formerly "PassRef".
// prepared for string ids if we do them later
static class RC {
  transient Object owner;
  String id;
  
  RC() {} // make serialisation happy
  RC(long id) { this.id = str(id); }
  RC(Object owner, long id) { this.id = str(id); this.owner = owner; }
  RC(Concept c) { this(c.id); }
  long longID() { return parseLong(id); }
  
  public String toString() {
    return id;
  }

  transient RemoteDB db;
  
  String getString(String field) { return db.xS(this, field); }
  Object get(String field) { return db.xget(this, field); }
  void set(String field, Object value) { db.xset(this, field, value); }

}

// Reference to a concept in another program
static class BaseXRef {
  String programID;
  long id;
    
  BaseXRef() {}
  BaseXRef(String programID, long id) {
  this.id = id;
  this.programID = programID;}
  
  public boolean equals(Object o) {
    if (!(o instanceof BaseXRef)) return false;
    BaseXRef r = (BaseXRef) ( o);
    return eq(programID, r.programID) && eq(id, r.id);
  }
  
  public int hashCode() {
    return programID.hashCode() + (int) id;
  }
}

// BaseXRef as a concept
static class XRef extends Concept {
  BaseXRef ref;
  
  XRef() {}
  XRef(BaseXRef ref) {
  this.ref = ref; _doneLoading2(); }
  
  // after we have been added to concepts
  void _doneLoading2() {
    getIndex().put(ref, this);
  }
    
  HashMap<BaseXRef, XRef> getIndex() {
    return getXRefIndex(_concepts);
  }
}

static synchronized HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
  HashMap cache = (HashMap) concepts.perClassData.get(XRef.class);
  if (cache == null)
    concepts.perClassData.put(XRef.class, cache = new HashMap());
  return cache;
}

// uses mainConcepts
static XRef lookupOrCreateXRef(BaseXRef ref) {
  XRef xref = getXRefIndex(mainConcepts).get(ref);
  if (xref == null)
    xref = new XRef(ref);
  return xref;
}

// define standard concept functions to use main concepts

static <A extends Concept> List<A> list(Class<A> type) {
  return mainConcepts.list(type);
}

static <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
  return concepts.list(type);
}

static List<Concept> list(String type) {
  return mainConcepts.list(type);
}

static List<Concept> list(Concepts concepts, String type) {
  return concepts.list(type);
}

static int csetAll(Concept c, Object... values) {
  return cset(c, values);
}

// returns number of changes
static int cset(Concept c, Object... values) { try {
  int changes = 0;
  values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    Field f = setOpt_findField(c.getClass(), field);
    //print("cset: " + c.id + " " + field + " " + struct(value) + " " + f);
    if (value instanceof RC) value = c._concepts.getConcept((RC) value);
    value = deref(value);
    
    if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan) value = ((String) value).intern();
    
    if (f == null) {
      // TODO: keep ref if it exists
      mapPut2(c.fieldValues, field, value instanceof Concept ? c.new Ref((Concept) value) : value);
      c.change();
    } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
      ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
      c.change(); ++changes;
    } else {
      Object old = f.get(c);
      if (neq(value, old)) {
        f.set(c, value);
        c.change(); ++changes;
      }
    }
  }
  return changes;
} catch (Exception __e) { throw rethrow(__e); } }

static void cleanMeUp_concepts() {
  mainConcepts.cleanMeUp();
}

static void loadAndAutoSaveConcepts() {
  mainConcepts.persist();
}

static void loadAndAutoSaveConcepts(int interval) {
  mainConcepts.persist(interval);
}

static void loadConceptsFrom(String progID) {
  mainConcepts.programID = progID;
  mainConcepts.load();
}

static List<Concept> conceptsOfType(String type) {
  return mainConcepts.conceptsOfType(type);
}

static long changeCount() {
  return mainConcepts.changes;
}

static List<String> exposedDBMethods = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

static RC toPassRef(Concept c) {
  return new RC(c);
}

// so we can instantiate the program to run as a bare DB bot
public static boolean isWindows() {
  return System.getProperty("os.name").contains("Windows");
}
static void duplicateThisProgram() {
  nohupJavax(trim(programID() + " " + smartJoin((String[]) get(getJavaX(), "fullArgs"))));
}
static volatile boolean licensed_yes = true;

static boolean licensed() {
  ping();
  return licensed_yes;
}

static void licensed_off() {
  licensed_yes = false;
}
// drop opening and closing tag, return new CNC
static List<String> contentsOfContainerTag(List<String> tok) {
  return tok == null ? null : subList(tok, 2, l(tok)-2);
}

static List<String> contentsOfContainerTag(List<String> tok, String tagName) {
  return contentsOfContainerTag(first(findContainerTag(tok, tagName)));
}
static int hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}
static Thread startThread(String name, Runnable r) {
  return startThread(new Thread(r, name));
}

static Thread startThread(Thread t) {
  _registerThread(t);
  t.start();
  return t;
}
static List<String> scoredSearch(String query, Collection<String> data) {
  Map<String,Integer> scores = new HashMap();
  for (String s : data) {
    int score = scoredSearch_score(s, query);
    if (score != 0)
      scores.put(s, score);
  }
  return keysSortedByValuesDesc(scores);
}

static int scoredSearch_score(String s, String query) {
  int score = 0;
  if (swic(s, query)) score += l(s) == l(query) ? 3 : 2;
  else if (containsIgnoreCase(s, query)) ++score;
  return score;
}
static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}

static void printStackTrace2(String indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace2(e));
}
static ThreadLocal<Long> saveTiming_last = new ThreadLocal();

static void saveTiming(long ms) {
  print(ms + " ms");
  saveTiming_last.set(ms);
}
static String tok_dropAsterisks(String s) {
  return join(replace(javaTok(s), "*", ""));
}
static void swingNowOrLater(Runnable r) {
  if (isAWTThread())
    r.run();
  else
    swingLater(r);
}
static String fsi(String id) {
  return formatSnippetID(id);
}
static boolean equals(Object a, Object b) {
  return a == null ? b == null : a.equals(b);
}
static Class _run(String progID, String... args) {
  Class main = hotwire(progID);
  callMain(main, args);
  return main;
}
static String asteriskPartsOnly(String s) {
  List<String> tok = javaTokC(s);
  replaceSubList(tok, ll("*", "*"), ll("*"));
  List<String> words = new ArrayList();
  int i = 0;
  while ((i = indexOf(tok, "*", i)) >= 0) {
    int j = indexOf(tok, "*", ++i);
    if (j < 0) break;
    words.addAll(subList(tok, i, j));
    i = j+1;
  }
  return joinWithSpace(words);
}
static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
  if (map == null) return litmap();
  // assume mutex is equal to collection, which will be true unless you explicitly pass a mutex to synchronizedList() which no one ever does.
  synchronized(map) {
    return map instanceof TreeMap ? new TreeMap(map)
      : map instanceof LinkedHashMap ? new LinkedHashMap(map)
      : new HashMap(map);
  }
}
static String[] toStringArray(Collection<String> c) {
  String[] a = new String[l(c)];
  Iterator<String> it = c.iterator();
  for (int i = 0; i < l(a); i++)
    a[i] = it.next();
  return a;
}

static String[] toStringArray(Object o) {
  if (o instanceof String[])
    return (String[]) o;
  else if (o instanceof Collection)
    return toStringArray((Collection<String>) o);
  else
    throw fail("Not a collection or array: " + getClassName(o));
}

static <A> void addAll(Collection<A> c, Collection<A> b) {
  if (c != null && b != null) c.addAll(b);
}

static <A> void addAll(Collection<A> c, A... b) {
  if (c != null) c.addAll(Arrays.asList(b));
}
static long stopTiming_defaultMin = 10;

static long startTiming_startTime;
static void startTiming() {
  startTiming_startTime = now();
}

static void stopTiming() {
  stopTiming(null);
}

static void stopTiming(String text) {
  stopTiming(text, stopTiming_defaultMin);
}

static void stopTiming(String text, long minToPrint) {
  long time = now()-startTiming_startTime;
  if (time >= minToPrint) {
    text = or2(text, "Time: ");
    print(text + time + " ms");
  }
}
static void substance() {
  substanceLAF();
}

static void substance(String skinName) {
  substanceLAF(skinName);
}
static Set asSet(Object[] array) {
  HashSet set = new HashSet();
  for (Object o : array)
    if (o != null)
      set.add(o);
  return set;
}

static Set<String> asSet(String[] array) {
  TreeSet<String> set = new TreeSet();
  for (String o : array)
    if (o != null)
      set.add(o);
  return set;
}

static <A> Set<A> asSet(Collection<A> l) {
  if (l instanceof Set) return (Set) l;
  HashSet<A> set = new HashSet();
  for (A o : l)
    if (o != null)
      set.add(o);
  return set;
}
static void restart() {
  Object j = getJavaX();
  call(j, "cleanRestart", get(j, "fullArgs"));
}
static List filter(Iterable c, Object pred) {
  List x = new ArrayList();
  for (Object o : c)
    if (isTrue(callF(pred, o)))
      x.add(o);
  return x;
}

static List filter(Object pred, Iterable c) {
  return filter(c, pred);
}

static void messageBox(final String msg) {
  if (headless()) print(msg);
  else { swingAndWait(new Runnable() { public void run() { try { 
    JOptionPane.showMessageDialog(null, msg, "JavaX", JOptionPane.INFORMATION_MESSAGE);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "JOptionPane.showMessageDialog(null, msg, \"JavaX\", JOptionPane.INFORMATION_MESSAG..."; }}); }
}

static void messageBox(Throwable e) {
  showConsole();
  printStackTrace(e);
  messageBox(str(e));
}
static long sysNow() {
  return System.nanoTime()/1000000;
}
static String firstToUpper(String s) {
  if (s.length() == 0) return s;
  return Character.toUpperCase(s.charAt(0)) + s.substring(1);
}


static String substanceLAF_defaultSkin = "Creme";

static void substanceLAF() {
  substanceLAF(null);
}

static void substanceLAF(String skinName) {
  try {
    enableSubstance_impl(or2(skinName, substanceLAF_defaultSkin));
  } catch (Throwable __e) { printStackTrace2(__e); }
}
static boolean swic(String a, String b) {
  return startsWithIgnoreCase(a, b);
}


  static boolean swic(String a, String b, Matches m) {
    if (!swic(a, b)) return false;
    m.m = new String[] {substring(a, l(b))};
    return true;
  }

static boolean headless() {
  return isHeadless();
}
static String joinWithSpace(Collection<String> c) {
  return join(" ", c);
}

static String joinWithSpace(String... c) {
  return join(" ", c);
}

static String getStackTrace2(Throwable throwable) {
  return getStackTrace(throwable) + replacePrefix("java.lang.RuntimeException: ", "FAIL: ",
    str(getInnerException(throwable))) + "\n";
}
static <A, B> List<A> keysSortedByValuesDesc(final Map<A, B> map) {
  List<A> l = new ArrayList(map.keySet());
  sort(l, mapComparatorDesc(map));
  return l;
}
static List<String> replaceSubList(List<String> l, List<String> x, List<String> y) {
  return replaceSublist(l, x, y);
}
// Try to get the quoting right...

static String smartJoin(String[] args) {
  if (args.length == 1) return args[0];
  
  String[] a = new String[args.length];
  for (int i = 0; i < a.length; i++)
    a[i] = !isJavaIdentifier(args[i]) && !isQuoted(args[i]) ? quote(args[i]) : args[i];
  return join(" ", a);
}

static String smartJoin(List<String> args) {
  return smartJoin(toStringArray(args));
}
static <A> List<A> replace(List<A> l, A a, A b) {
  for (int i = 0; i < l(l); i++)
    if (eq(l.get(i), a))
      l.set(i, b);
  return l;
}

static String replace(String s, String a, String b) {
  return s == null ? null : a == null || b == null ? s : s.replace(a, b);
}


static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}
static <A, B> Comparator<A> mapComparatorDesc(final Map<A, B> map) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(map.get(b), map.get(a));
    }
  };
}
 // Substance
 // Trident (required by Substance)


static void enableSubstance_impl(final String skinName) { swingAndWait(new Runnable() { public void run() { try { 
  if (!substanceLookAndFeelEnabled())
    enableSubstance_impl_2(skinName);

} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!substanceLookAndFeelEnabled())\r\n    enableSubstance_impl_2(skinName);"; }}); }

static void enableSubstance_impl_2(String skinName) { try {
  ClassLoader cl = main.class.getClassLoader();
  UIManager.getDefaults().put("ClassLoader", cl);
  Thread.currentThread().setContextClassLoader(cl);
  String skinClassName = "org.pushingpixels.substance.api.skin." + addSuffix(skinName, "Skin");
  SubstanceSkin skin = (SubstanceSkin) nuObject(cl.loadClass(skinClassName));
  SubstanceLookAndFeel.setSkin(skin);
  JFrame.setDefaultLookAndFeelDecorated(true);  
  updateLookAndFeelOnAllWindows();
  
  if (substanceLookAndFeelEnabled())
    print("Substance L&F enabled.");
  else
    print("Could not enable Substance L&F?");
} catch (Exception __e) { throw rethrow(__e); } }
static <A> List<A> replaceSublist(List<A> l, List<A> x, List<A> y) {
  if (x == null) return l;
  
  int i = 0;
  while (true) {
    i = indexOfSubList(l, x, i);
    if (i < 0) break;
    
    // It's inefficient :D
    for (int j = 0; j < l(x); j++) l.remove(i);
    l.addAll(i, y);
    i += l(y);
  }
  return l;
}

static <A> List<A> replaceSublist(List<A> l, int fromIndex, int toIndex, List<A> y) {
  // inefficient
  while (toIndex > fromIndex) l.remove(--toIndex);
  l.addAll(fromIndex, y);
  return l;
}


static <A> int indexOfSubList(List<A> x, List<A> y) {
  return indexOfSubList(x, y, 0);
}

static <A> int indexOfSubList(List<A> x, List<A> y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y.get(j)))
        continue outer;
    return i;
  }
  return -1;
}

static <A> int indexOfSubList(List<A> x, A[] y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y[j]))
        continue outer;
    return i;
  }
  return -1;
}
static String addSuffix(String s, String suffix) {
  return s.endsWith(suffix) ? s : s + suffix;
}
static void updateLookAndFeelOnAllWindows() {
  for (Window window : Window.getWindows())
    SwingUtilities.updateComponentTreeUI(window);
  renewConsoleFrame();
}


static void renewConsoleFrame() {
  setConsoleFrame(renewFrame(consoleFrame()));
}


static void setConsoleFrame(JFrame frame) {
   setOpt(get(getJavaX(), "console"), "frame", frame);
}
static JFrame renewFrame(final JFrame frame) {
  if (frame == null) return null;
  return (JFrame) swing(new Object() { Object get() { try { 
    Container content = frame.getContentPane();
    JFrame frame2 = makeFrame(frame.getTitle());
    frame2.setBounds(frame.getBounds());
    try { frame2.setIconImages(frame.getIconImages()); } catch (Throwable __e) { printStackTrace2(__e); }
    frame2.setDefaultCloseOperation(frame.getDefaultCloseOperation());
    for (WindowListener wl : frame.getWindowListeners())
      frame2.addWindowListener(wl);
    frame.setContentPane(new JPanel());
    frame2.setContentPane(content);
    frame2.setVisible(true);
    frame.dispose();
    return frame2;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Container content = frame.getContentPane();\r\n    JFrame frame2 = makeFrame(frame..."; }});
}


static class RemoteDB {
  DialogIO db;
  String name;
  
  // s = bot name or snippet ID
  RemoteDB(String s) {
    this(s, false);
  }
  
  RemoteDB(String s, boolean autoStart) {
    name = s;
    if (isSnippetID(s)) name = dbBotName(s);
    db = findBot(name);
    if (db == null)
      if (autoStart) {
        nohupJavax(fsI(s));
        waitForBotStartUp(name);
        assertNotNull("Weird problem", db = findBot(s));
      } else
        throw fail("DB " + s + " not running");
  }

  boolean functional() { return db != null; } // now always true
  
  List<RC> list() { return adopt((List<RC>) rpc(db, "xlist")); }
  List<RC> list(String className) { return adopt((List<RC>) rpc(db, "xlist", className)); }
  List<RC> xlist() { return list(); }
  List<RC> xlist(String className) { return list(className); }
  
  // adopt is an internal method
  List<RC> adopt(List<RC> l) {
    if (l != null) for (RC rc : l) adopt(rc);
    return l;
  }
  
  RC adopt(RC rc) { if (rc != null) rc.db = this; return rc; }
  
  Object adopt(Object o) {
    if (o instanceof RC) return adopt((RC) o);
    return o;
  }
  
  String xclass(RC o) {
    return (String) rpc(db, "xclass", o);
  }
  
  Object xget(RC o, String field) {
    return adopt(rpc(db, "xget", o, field));
  }
  
  String xS(RC o, String field) {
    return (String) xget(o, field);
  }
  
  RC xgetref(RC o, String field) {
    return adopt((RC) xget(o, field));
  }
  
  void xset(RC o, String field, Object value) {
    rpc(db, "xset", o, field, value);
  }
  
  RC uniq(String className) {
    RC ref = first(list(className));
    if (ref == null)
      ref = xnew(className);
    return ref;
  }
  RC xuniq(String className) { return uniq(className); }
  
  RC xnew(String className, Object... values) {
    return adopt((RC) rpc(db, "xnew", className, values));
  }
  
  void xdelete(RC o) {
    rpc(db, "xdelete", o);
  }
  
  void xdelete(List<RC> l) {
    rpc(db, "xdelete", l);
  }

  void close() {
    if (db != null)
      db.close();
  }
  
  String fullgrab() { return (String) rpc(db, "xfullgrab"); }
  String xfullgrab() { return fullgrab(); }
  
  void xshutdown() { rpc(db, "xshutdown"); }
  
  long xchangeCount() { return (long) rpc(db, "xchangeCount"); }
  int xcount() { return (int) rpc(db, "xcount"); }

  void reconnect() {
    close();
    db = findBot(name);
  }
  
  RC rc(long id) { return new RC(this, id); }
}

static class MultiMap<A,B> {
  Map<A, List<B>> data = new HashMap<A, List<B>>();
  
  MultiMap() {}
  MultiMap(boolean useTreeMap) { if (useTreeMap) data = new TreeMap(); }
  MultiMap(MultiMap<A, B> map) { putAll(map); }

  synchronized void put(A key, B value) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = new ArrayList<B>());
    list.add(value);
  }

  synchronized void addAll(A key, Collection<B> values) {
    putAll(key, values);
  }
  
  synchronized void addAllIfNotThere(A key, Collection<B> values) {
    for (B value : values)
      setPut(key, value);
  }
  
  synchronized void setPut(A key, B value) {
    if (!containsPair(key, value))
      put(key, value);
  }
  
  synchronized boolean containsPair(A key, B value) {
    return get(key).contains(value);
  }
  
  synchronized void putAll(A key, Collection<B> values) {
    for (B value : values)
      put(key, value);
  }

  synchronized void removeAll(A key, Collection<B> values) {
    for (B value : values)
      remove(key, value);
  }
  
  synchronized List<B> get(A key) {
    List<B> list = data.get(key);
    return list == null ? Collections.<B> emptyList() : list;
  }

  // returns actual mutable live list
  // creates the list if not there
  synchronized List<B> getActual(A key) {
    List<B> list = data.get(key);
    if (list == null)
      data.put(key, list = smallEmptyList());
    return list;
  }
 
  synchronized void clean(A key) {
    List<B> list = data.get(key);
    if (list != null && list.isEmpty())
      data.remove(key);
  }

  synchronized Set<A> keySet() {
    return data.keySet();
  }

  synchronized Set<A> keys() {
    return data.keySet();
  }

  synchronized void remove(A key) {
    data.remove(key);
  }

  synchronized void remove(A key, B value) {
    List<B> list = data.get(key);
    if (list != null) {
      list.remove(value);
      if (list.isEmpty())
        data.remove(key);
    }
  }

  synchronized void clear() {
    data.clear();
  }

  synchronized boolean containsKey(A key) {
    return data.containsKey(key);
  }

  synchronized B getFirst(A key) {
    List<B> list = get(key);
    return list.isEmpty() ? null : list.get(0);
  }
  
  synchronized void putAll(MultiMap<A, B> map) {
    for (A key : map.keySet())
      putAll(key, map.get(key));
  }
  
  // note: expensive operation
  synchronized int size() {
    int n = 0;
    for (List l : data.values())
      n += l(l);
    return n;
  }
  
  // expensive operation
  synchronized List<A> reverseGet(B b) {
    List<A> l = new ArrayList();
    for (A key : data.keySet())
      if (data.get(key).contains(b))
        l.add(key);
    return l;
  }
  
  synchronized Map<A, List<B>> asMap() {
    return cloneMap(data);
  }
  
  boolean isEmpty() { return data.isEmpty(); }
}

static Concept getConcept(long id) {
  return mainConcepts.getConcept(id);
}

static <A extends Concept> A getConcept(Class<A> cc, long id) {
  return getConcept(mainConcepts, cc, id);
}

static <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
  Concept c = concepts.getConcept(id);
  if (c == null) return null;
  if (!isInstance(cc, c))
    throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
  return (A) c;
}
static Collection<Concept> allConcepts() {
  return mainConcepts.allConcepts();
}

static Collection<Concept> allConcepts(Concepts concepts) {
  return concepts.allConcepts();
}

static void set(Object o, String field, Object value) {
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static void set(Class c, String field, Object value) {
  try {
    Field f = set_findStaticField(c, field);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
// firstDelay = delay
static java.util.Timer doEvery_daemon(int delay, final Object r) {
  return doEvery_daemon(delay, delay, r);
}

static java.util.Timer doEvery_daemon(int delay, int firstDelay, final Object r) {
  final java.util.Timer timer = new java.util.Timer(true);
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
  return timer;
}

static float abs(float f) { return Math.abs(f); }
static int abs(int i) { return Math.abs(i); }
static double abs(double d) { return Math.abs(d); }
static String loadConceptsStructure(String progID) {
  return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
}
static void saveGZStructureToFile(File file, Object o) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  File tempFile = tempFileFor(file);
  if (tempFile.exists()) try {
    String saveName = tempFile.getPath() + ".saved." + now();
    copyFile(tempFile, new File(saveName));
  } catch (Throwable e) { printStackTrace(e); }
  
  FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
  GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
  OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
  PrintWriter printWriter = new PrintWriter(outputStreamWriter);
  structureToPrintWriter(o, printWriter);
  printWriter.close();
  gos.close();
  fileOutputStream.close();

  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (!tempFile.renameTo(file))
    throw new IOException("Can't rename " + tempFile + " to " + file);
} catch (Exception __e) { throw rethrow(__e); } }
static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}
static void load(String varName) {
  readLocally(varName);
}

static void load(String progID, String varName) {
  readLocally(progID, varName);
}
static void saveLocally(String variableName) {
  saveLocally(programID(), variableName);
}

static void saveLocally(String progID, String variableName) {
  saveLocally2(mc(), progID, variableName);
}

static void saveLocally2(Object obj, String variableName) {
  saveLocally2(obj, programID(), variableName);
}

static synchronized void saveLocally2(Object obj, String progID, String variableName) {
  File textFile = new File(programDir(progID), variableName + ".text");
  File structureFile = new File(programDir(progID), variableName + ".structure");
  Object x = get(obj, variableName);
  
  if (x == null) {
    textFile.delete();
    structureFile.delete();
  } else if (x instanceof String) {
    saveTextFile(textFile, (String) x);
    structureFile.delete();
  } else {
    saveTextFile(structureFile, javaTokWordWrap(structure(x)));
    textFile.delete();
  }
}
static RemoteDB connectToDBOpt(String dbNameOrID) { try {
  return new RemoteDB(dbNameOrID);
} catch (Throwable __e) { return null; } }
static boolean stdEq2(Object a, Object b) {
  if (a == null) return b == null;
  if (b == null) return false;
  if (a.getClass() != b.getClass()) return false;
  for (String field : allFields(a))
    if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
  return true;
}
static Object safeUnstructure(String s) {
  return unstructure(s, true);
}
static <A> List<A> addDyn(List<A> l, A a) {
  if (l == null) l = new ArrayList();
  l.add(a);
  return l;
}
static long toK(long l) {
  return (l+1023)/1024;
}
static long toM(long l) {
  return (l+1024*1024-1)/(1024*1024);
}

static String toM(long l, int digits) {
  return formatDouble(toM_double(l), digits);
}
static void clearConcepts() {
  mainConcepts.clearConcepts();
}

static void clearConcepts(Concepts concepts) {
  concepts.clearConcepts();
}
static SortedMap synchroTreeMap() {
  return Collections.synchronizedSortedMap(new TreeMap());
}

static boolean hasType(Collection c, Class type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return true;
  return false;
}
static void cleanKillVM() {
  call(getJavaX(), "cleanKill");
}
static String javaTokWordWrap(String s) {
  int cols = 120, col = 0;
  List<String> tok = javaTok(s);
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && col >= cols && !containsNewLine(t))
      tok.set(i, t += "\n");
    int idx = t.lastIndexOf('\n');
    if (idx >= 0) col = l(t)-(idx+1);
    else col += l(t);
  }
  return join(tok);
}
static int stdHash2(Object a) {
  if (a == null) return 0;
  return stdHash(a, toStringArray(allFields(a)));
}
static Object derefRef(Object o) {
  if (o instanceof Concept.Ref) o = ((Concept.Ref) o).get();
  return o;
}

static <A, B> Map<A, B> putAll(Map<A, B> a, Map<? extends A,? extends B> b) {
  if (a != null) a.putAll(b);
  return a;
}
static Object rpc(String botName, String method, Object... args) {
  return unstructure_debug(matchOK2OrFail(
    sendToLocalBot(botName, rpc_makeCall(method, args))));
}

static Object rpc(DialogIO bot, String method, Object... args) {
  return unstructure_debug(matchOK2OrFail(
    bot.ask(rpc_makeCall(method, args))));
}

static String rpc_makeCall(String method, Object... args) {
  if (empty(args))
    return "call " + method;
  return format("call *", concatLists((List) ll(method), asList(args)));
}
static <A> List<A> filterByDynamicType(Collection<A> c, String type) {
  List<A> l = new ArrayList();
  for (A x : c)
    if (eq(dynamicClassName(x), type))
      l.add(x);
  return l;
}
static long waitForBotStartUp_timeoutSeconds = 60;

// returns address or fails
static String waitForBotStartUp(String botName) {
  for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
    sleepSeconds(i == 0 ? 0 : 1);
    String addr = getBotAddress(botName);
    if (addr != null)
      return addr;
  }
  throw fail("Bot not found: " + quote(botName));
}
static <A> A firstOfType(Collection c, Class<A> type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return (A) x;
  return null;
}
static Concept cnew(String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  Concept c = cc != null ? nuObject(cc) : new Concept(name);
  csetAll(c, values);
  return c;
}

static Concept cnew(Concepts concepts, String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  concepts_unlisted.set(true);
  Concept c;
  try {
    c = cc != null ? nuObject(cc) : new Concept(name);
  } finally {
    concepts_unlisted.set(null);
  }
  concepts.register(c);
  csetAll(c, values);
  return c;
}

static <A extends Concept> A cnew(Class<A> cc, Object... values) {
  A c = nuObject(cc);
  csetAll(c, values);
  return c;
}

static <A extends Concept> A cnew(Concepts concepts, Class<A> cc, Object... values) {
  concepts_unlisted.set(true);
  A c;
  try {
    c = nuObject(cc);
  } finally {
    concepts_unlisted.set(null);
  }
  concepts.register(c);
  csetAll(c, values);
  return c;
}

static boolean bareDBMode_on;

static void bareDBMode() {
  bareDBMode(null); // default autoSaveInterval
}

static void bareDBMode(Integer autoSaveInterval) {
  bareDBMode_on = true;
  conceptsAndBot(autoSaveInterval);
}
static ArrayList smallEmptyList() {
  return new ArrayList(0);
}
static Str concept(String name) {
  for (Str s : list(Str.class))
    if (eqic(s.name, name) || containsIgnoreCase(s.otherNames, name))
      return s;
  return new Str(name);
}
static File getProgramFile(String progID, String fileName) {
  if (new File(fileName).isAbsolute())
    return new File(fileName);
  return new File(getProgramDir(progID), fileName);
}

static File getProgramFile(String fileName) {
  return getProgramFile(getProgramID(), fileName);
}

static int hours() {
  return Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
}
static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}
static <A extends Concept> A findBackRef(Concept c, Class<A> type) {
  for (Concept.Ref r : c.backRefs)
    if (instanceOf(r.concept(), type))
      return (A) r.concept();
  return null;
}

static <A extends Concept> A findBackRef(Class<A> type, Concept c) {
  return findBackRef(c, type);
}
static <A> List<A> removeDyn(List<A> l, A a) {
  if (l == null) return null;
  l.remove(a);
  return empty(l) ? null : l;
}
static boolean sameSnippetID(String a, String b) {
  return a != null && b != null && parseSnippetID(a) == parseSnippetID(b);
}
static String formatInt(int i, int digits) {
  return padLeft(str(i), '0', digits);
}

static <A, B> void mapPut2(Map<A, B> map, A key, B value) {
  if (map != null && key != null)
    if (value != null) map.put(key, value);
    else map.remove(key);
}
static <A> List<A> filterByType(Collection c, Class<A> type) {
  List<A> l = new ArrayList();
  for (Object x : c)
    if (isInstanceX(type, x))
      l.add((A) x);
  return l;
}

static <A> List<A> filterByType(Object[] c, Class<A> type) {
  return filterByType(asList(c), type);
}

static int done_minPrint = 10;

static long done(long startTime, String desc) {
  long time = now()-startTime;
  if (time >= done_minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done(String desc, long startTime) {
  return done(startTime, desc);
}

static long done(long startTime) {
  return done(startTime, "");
}
static void readLocally(String progID, String varNames) {
  readLocally2(mc(), progID, varNames);
}

static void readLocally(String varNames) {
  readLocally2(mc(), programID(), varNames);
}

static void readLocally2(Object obj, String varNames) {
  readLocally2(obj, programID(), varNames);
}

static int readLocally_stringLength;

static ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

// read a string variable from standard storage
// does not overwrite variable contents if there is no file
static void readLocally2(Object obj, String progID, String varNames) { try {
  boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
  for (String variableName : javaTokC(varNames)) {
    File textFile = new File(programDir(progID), variableName + ".text");
    
    String value = loadTextFile(textFile);
    if (value != null)
      set(main.class, variableName, value);
    else {
      File structureFile = new File(programDir(progID), variableName + ".structure");
      value = loadTextFile(structureFile);
      
      if (value == null) {
        File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
        if (!structureGZFile.isFile()) return;
        //value = loadGZTextFile(structureGZFile);
        InputStream fis = new FileInputStream(structureGZFile);
        try {
          GZIPInputStream gis = new GZIPInputStream(fis);
          InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
          BufferedReader bufferedReader = new BufferedReader(reader);
          //O o = unstructure_reader(bufferedReader);
          Object o = unstructure_tok(javaTokC_noMLS_onReader(bufferedReader), allDynamic, null);
          readLocally_set(obj, variableName, o);
        } finally {
          fis.close();
        }
        return;
      }
      
      readLocally_stringLength = l(value);
      if (value != null)
        readLocally_set(obj, variableName, allDynamic ? safeUnstructure(value) : unstructure(value));
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void readLocally_set(Object c, String varName, Object value) {
  Object oldValue = get(c, varName);
  if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
    // Assume it's a synchroList.
    value = synchroList((List) value);
  }
  set(c, varName, value);
}

static boolean hasConcept(Class<? extends Concept> c, Object... params) {
  return findConceptWhere(c, params) != null;
}
static String ymd() {
  return year() + formatInt(month(), 2) + formatInt(dayOfMonth(), 2);
}


static int year() {
  return Calendar.getInstance().get(Calendar.YEAR);
}
static Object unstructure_debug(String s) {
  try {
    return unstructure(s);
  } catch (Throwable _e) {
    print("Was unstructuring: " + s);
  
throw rethrow(_e); }
}
static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
  A a = tl.get();
  tl.set(null);
  return a;
}
static boolean instanceOf(Object o, String className) {
  if (o == null) return false;
  String c = o.getClass().getName();
  return eq(c, className) || eq(c, "main$" + className);
}

static boolean instanceOf(Object o, Class c) {
  if (c == null) return false;
  return c.isInstance(o);
}
static int month() {
  return Calendar.getInstance().get(Calendar.MONTH)+1;
}
static int getBotAddress_timeout = 5000;

static String getBotAddress(String searchPattern) {
  String subBot = "";
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return searchPattern + subBot;
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    try {
      io.waitForLine(/*getBotAddress_timeout*/); // TODO: implement
      String line = io.readLineNoBlock();
      if (startsWithIgnoreCase(line, searchPattern))
        return port + subBot;
    } finally {
      io.close();
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      return p.port + subBot;
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = unstructureMap_verboseError(sendToLocalBot(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return p.port + "/" + vport;
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
        
  return null;
}
static Set<String> allFields(Object o) {
  TreeSet<String> fields = new TreeSet();
  Class _c = _getClass(o);
  do {
    for (Field f : _c.getDeclaredFields())
      fields.add(f.getName());
    _c = _c.getSuperclass();
  } while (_c != null);
  return fields;
}
static String padLeft(String s, char c, int n) {
  return rep(c, n-l(s)) + s;
}

// default to space
static String padLeft(String s, int n) {
  return padLeft(s, ' ', n);
}
static String matchOK2OrFail(String s) {
  Matches m = new Matches();
  if (swic(s, "ok "))
    return substring(s, 3);
  else if (eqic(s, "ok"))
    return "ok";
  else
    throw fail(s);
}
static String dynamicClassName(Object o) {
  if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return "main$" + ((DynamicObject) o).className;
  return className(o);
}
static String sendToLocalBot(String bot, String text, Object... args) {
  text = format3(text, args);
  
  DialogIO channel = findBot(bot);
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    print(bot + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(bot + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    channel.close();
  }
}

static String sendToLocalBot(int port, String text, Object... args) {
  text = format3(text, args);
  DialogIO channel = talkTo(port);
  try {
    channel.readLine();
    print(port + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(port + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    if (channel != null)
      channel.close();
  }
}
static boolean isInstance(Class type, Object arg) {
  return type.isInstance(arg);
}
static int dayOfMonth() {
  return days();
}
static String formatDouble(double d, int digits) {
  String format = "0." + rep(digits, '#');
  return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
}

static File programDir_mine; // set this to relocate program's data

static File programDir() {
  return programDir(getProgramID());
}

static File programDir(String snippetID) {
  if (programDir_mine != null && sameSnippetID(snippetID, programID()))
    return programDir_mine;
  return new File(javaxDataDir(), formatSnippetID(snippetID));
}

static int stdHash(Object a, String... fields) {
  if (a == null) return 0;
  int hash = getClassName(a).hashCode();
  for (String field : fields)
    hash = hash*2+hashCode(getOpt(a, field));
  return hash;
}
static TimerTask smartTimerTask(final Object r, final java.util.Timer timer, final int delay) {
  return new TimerTask() {
    long lastRun;
    
    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        lastRun = fixTimestamp(lastRun);
        long now = now();
        if (now >= lastRun + delay*0.9) {
          lastRun = now;
          pcallF(r);
        }
      }
    }
  };
}
static String loadTextFilePossiblyGZipped(String fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}
  
static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
  File gz = new File(fileName + ".gz");
  return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
}

static String loadTextFilePossiblyGZipped(File fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}

static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
  return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
}

static double toM_double(long l) {
  return l/(1024*1024.0);
}
static File getProgramDir() {
  return programDir();
}

static File getProgramDir(String snippetID) {
  return programDir(snippetID);
}
static File tempFileFor(File f) {
  return new File(f.getPath() + "_temp");
}
static boolean containsNewLine(String s) {
  return contains(s, '\n'); // screw \r, nobody needs it
}


static int days() {
  return Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
}
static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}

static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}
static Map unstructureMap_verboseError(String s) {
  try {
    return unstructureMap(s);
  } catch (Throwable _e) {
    print(">> " + s);
  
throw rethrow(_e); }
}
static long fixTimestamp(long timestamp) {
  return timestamp > now() ? 0 : timestamp;
}
static String className(Object o) {
  return getClassName(o);
}
static String loadGZTextFile(File file) { try {
  if (!file.isFile()) return null;
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
  InputStream fis = new FileInputStream(file);
  GZIPInputStream gis = new GZIPInputStream(fis);
  try {
    byte[] buffer = new byte[1024];
    int len;
    while((len = gis.read(buffer)) != -1){
        baos.write(buffer, 0, len);
    }
  } finally {
    fis.close();
  }
  baos.close();
  return fromUtf8(baos.toByteArray()); // TODO: use a Reader
} catch (Exception __e) { throw rethrow(__e); } }


static Map unstructureMap(String s) {
  return (Map) unstructure(s);
}
static String fromUtf8(byte[] bytes) { try {
  return new String(bytes, "UTF-8");
} catch (Exception __e) { throw rethrow(__e); } }


static class Str extends Concept {
  String name;
  List<String> otherNames = new ArrayList();
  
  Str() {}
  Str(String name) {
  this.name = name;}
  
  public String toString() { return name; }
}
}


class m1008692{}