import java.util.*;
import java.util.zip.*;
import java.util.List;
import java.util.regex.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.ref.*;
import java.lang.management.*;
import java.security.*;
import java.security.spec.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;
import java.math.*;
public class main {


// We can parse and evaluate ALL THIS:

static String stuffToParse = "\n  1\n  1 - 2\n  1 - 2 - 3\n  1 - (2 - 3)\n  -5 - 4\n  (4 - 3) - 2\n  100 / (10 * 2)\n  100 / 10 / 10\n";

static String concepts = "\n  // ...just by giving a few parsing concepts (w/increasing binding power):\n  \n  [\"jcnbmtmfzktxhzyf\", \"X + Y\"],\n  [\"jxcubqjtqykhfvyo\", \"X - Y\", \"as in minus\"],\n  [\"erdirznfvsrbtfns\", \"X / Y\", \"division\"],\n  [\"bwqhmnorjpyomdbv\", \"X * Y\", \"multiplication\"],\n  \n  // ...and a bit of meta-level stuff:\n  [\"mcoswmplpqlieruo\", \"(X)\"],\n  [\"olphazqzxxnvtjcx\", \"X evaluates through standard function Y.\"],\n  [\"wwaprwlmqzqeaikp\", \"A leaf satisfying standard function X evaluates through standard function Y.\"],\n  [\"hkihrqgdlkdayxzn\", \"X is just bracketing.\"],\n";

// ...and finally linking everything together by relating concepts
// to JavaX standard functions.

static String statements = "\n  olphazqzxxnvtjcx jcnbmtmfzktxhzyf \"plus\"\n  olphazqzxxnvtjcx jxcubqjtqykhfvyo \"minus\"\n  olphazqzxxnvtjcx bwqhmnorjpyomdbv \"multiply\"\n  olphazqzxxnvtjcx erdirznfvsrbtfns \"divide\"\n  hkihrqgdlkdayxzn mcoswmplpqlieruo\n  wwaprwlmqzqeaikp \"isInteger\" \"bigint\"\n";

// The rest is boilerplate.

public static void main(final String[] args) throws Exception { typeWriterConsole();
  centerHigherConsole();
  testLispEval(concepts, statements, stuffToParse);
}


static void centerHigherConsole() {
  setConsoleHeight(600);
  centerConsole();
}
static void testLispEval(String concepts, String statements, String stuffToParse) {
  useConceptsAndCLStatements(concepts, statements);
  map("testParse", toLinesFullTrim(stuffToParse));
}

static void testParse(String s) {
  print("  Parsing: " + s);
  Lisp l = hygienicParse1(s);
  if (l != null) printIndent("Parsed as: " + l);
  String result = null;
  try {
    if (l != null) result = str(eval(l));
  } catch (Throwable __e) { printStackTrace2(__e); }
  printIndent(s + " = " + or(result, "?"));
  print();
}

static Object eval(Lisp l) { return generalLispEval(l); }


static void centerConsole() {
  centerConsoleFrame();
}
static <A> A or(A a, A b) {
  return a != null ? a : b;
}
static void printIndent(Object o) {
  print(indentx(str(o)));
}

static void printIndent(String indent, Object o) {
  print(indentx(indent, str(o)));
}

static void printIndent(int indent, Object o) {
  print(indentx(indent, str(o)));
}
static boolean hygienicParse1_debug;

static Lisp hygienicParse1(String s) {
  if (hygienicParse1_debug)
    print("Parsing: " + s);
  List<Lisp> parses = englishToLisp_multi(s);
  if (hygienicParse1_debug) {
    int i = 0;
    for (Lisp l : sortByArgumentHygiene(parses))
      printIndent((++i) + ". " + l + " [" + lisp_roundBracketHygieneScore(l) + "]");
  }
  Lisp l = chooseBestArgumentHygiene(parses);
  return l == null ? lisp(s) : hygienicParse1_sub(l);
}

// parse the arguments which are original strings 
static Lisp hygienicParse1_sub(Lisp l) {
  if (l == null || l.isLeaf()) return l;
  Lisp x = lisp(l.head);
  for (Lisp a : l.args)
    x.add(or(hygienicParse1(a.raw()), a));
  return x;
}

static String str(Object o) {
  return o == null ? "null" : o.toString();
}

static String str(char[] c) {
  return new String(c);
}
static volatile StringBuffer local_log = new StringBuffer(); // not redirected
static volatile StringBuffer print_log = local_log; // might be redirected, e.g. to main bot

// in bytes - will cut to half that
static volatile int print_log_max = 1024*1024;
static volatile int local_log_max = 100*1024;
//static int print_maxLineLength = 0; // 0 = unset

static boolean print_silent; // total mute if set

static volatile ThreadLocal<F1<String, Boolean>> print_byThread; // special handling by thread

static void print() {
  print("");
}

// slightly overblown signature to return original object...
static <A> A print(A o) {
  ping();
  if (print_silent) return o;
  String s = String.valueOf(o) + "\n";
  print_noNewLine(s);
  return o;
}

static void print_noNewLine(String s) {
  if (print_byThread != null) {
    F1<String, Boolean> f = print_byThread.get();
    if (f != null)
      if (isFalse(f.get(s))) return;
  }

  print_raw(s);
}

static void print_raw(String s) {
  s = fixNewLines(s);
  // TODO if (print_maxLineLength != 0)
  StringBuffer loc = local_log;
  StringBuffer buf = print_log;
  int loc_max = print_log_max;
  if (buf != loc && buf != null) {
    print_append(buf, s, print_log_max);
    loc_max = local_log_max;
  }
  if (loc != null) 
    print_append(loc, s, loc_max);
  System.out.print(s);
}

static void print(long l) {
  print(String.valueOf(l));
}

static void print(char c) {
  print(String.valueOf(c));
}

static void print_append(StringBuffer buf, String s, int max) {
  synchronized(buf) {
    buf.append(s);
    max /= 2;
    if (buf.length() > max) try {
      int newLength = max/2;
      int ofs = buf.length()-newLength;
      String newString = buf.substring(ofs);
      buf.setLength(0);
      buf.append("[...] ").append(newString);
    } catch (Exception e) {
      buf.setLength(0);
    }
  }
}
static List<String> toLinesFullTrim(String s) {
  List<String> l = toLines(s);
  for (ListIterator<String> i = l.listIterator(); i.hasNext(); ) {
    String line = i.next().trim();
    if (line.length() == 0)
      i.remove();
    else
      i.set(line);
  }
  return l;
}

static List<String> toLinesFullTrim(File f) {
  return toLinesFullTrim(loadTextFile(f));
}

static void setConsoleHeight(int h) {
  setFrameHeight(consoleFrame(), h);
}
static void useConceptsAndCLStatements(String concepts, String statements) {
  useConcepts(concepts);
  useStatements_cl(statements);
}
static Object generalLispEval(Lisp l) {
  if (l == null) return null;
  
  if (l.size() == 1 && lispTrue("hkihrqgdlkdayxzn", l.head))
    return generalLispEval(l.get(0));
  
  String evaluator = first(followForwardRelation_raw("mssmzemxxztdpphw", l.head));
  if (evaluator != null)
    return conceptCall(evaluator, map("generalLispEval", l));
    
  String sf = first(followForwardRelation_raw("olphazqzxxnvtjcx", l.head));
  if (sf != null)
    return makeAndCall_cached(sf, asObjectArray(map("generalLispEval", l)));
    
  if (l.isLeaf()) {
    for (Lisp rule : lispTruth2("yrxfddfomyzlqwri"))
      if (isTrue(callConcept(rule.raw(0), l.head)))
        return callConcept(rule.get(1), l.head);
        
    for (Lisp rule : lispTruth2("wwaprwlmqzqeaikp"))
      if (isTrue(makeAndCall_cached(rule.raw(0), l.head)))
        return makeAndCall_cached(rule.raw(1), l.head);
  }
        
  throw fail("Can't evaluate " + l);
}
static List map(Iterable l, Object f) {
  return map(f, l);
}

static List map(Object f, Iterable l) {
  List x = new ArrayList();
  Object mc = mc();
  for (Object o : unnull(l))
    x.add(callF(f, o));
  return x;
}

static List map(Object f, Object[] l) {
  return map(f, asList(l));
}

static List map(Object f, Map map) {
  return map(map, f);
}

static List map(Map map, Object f) {
  List x = new ArrayList();
  for (Object _e : map.entrySet()) {
    Map.Entry e = (Map.Entry) _e;
    x.add(callF(f, e.getKey(), e.getValue()));
  }
  return x;
}


static int lisp_roundBracketHygieneScore(Lisp l) {
  if (l == null) return 0;
  int score = 0;
  for (Lisp arg : l)
    if (arg.isLeaf() && hasRoundBracketHygiene(arg.unq()))
      ++score;
  return score;
}
static String fixNewLines(String s) {
  return s.replace("\r\n", "\n").replace("\r", "\n");
}
static JFrame consoleFrame() {
  return (JFrame) getOpt(get(getJavaX(), "console"), "frame");
}
static volatile boolean ping_pauseAll;
static int ping_sleep = 100; // poll pauseAll flag every 100
static volatile boolean ping_anyActions;
static Map<Thread, Object> ping_actions = synchroMap(new WeakHashMap());

// returns true if it did anything
static boolean ping() { try {
  if (ping_pauseAll && !isAWTThread()) {
    do
      Thread.sleep(ping_sleep);
    while (ping_pauseAll);
    return true;
  }
  
  if (ping_anyActions) {
    Object action;
    synchronized(mc()) {
      action = ping_actions.get(currentThread());
      if (action instanceof Runnable)
        ping_actions.remove(currentThread());
      if (ping_actions.isEmpty()) ping_anyActions = false;
    }
    
    if (action instanceof Runnable)
      ((Runnable) action).run();
    else if (eq(action, "cancelled"))
      throw fail("Thread cancelled.");
  }
  
  return false;
} catch (Exception __e) { throw rethrow(__e); } }
static String unnull(String s) {
  return s == null ? "" : s;
}

static <A> List<A> unnull(List<A> l) {
  return l == null ? emptyList() : l;
}

static <A> Iterable<A> unnull(Iterable<A> i) {
  return i == null ? emptyList() : i;
}

static Object[] unnull(Object[] a) {
  return a == null ? new Object[0] : a;
}

static BitSet unnull(BitSet b) {
  return b == null ? new BitSet() : b;
}
static WeakHashMap<Class, ArrayList<Method>> callF_cache = new WeakHashMap();

static Object callF(Object f, Object... args) { try {
  if (f instanceof String)
    return callMC((String) f, args);
  if (f instanceof Runnable) {
    ((Runnable) f).run();
    return null;
  }
  if (f == null) return null;
  
  Class c = f.getClass();
  ArrayList<Method> methods;
  synchronized(callF_cache) {
    methods = callF_cache.get(c);
    if (methods == null)
      methods = callF_makeCache(c);
  }
  
  int n = l(methods);
  if (n == 0) throw fail("No get method in " + getClassName(c));
  if (n == 1) return methods.get(0).invoke(f, args);
  for (int i = 0; i < n; i++) {
    Method m = methods.get(i);
    if (call_checkArgs(m, args, false))
      return m.invoke(f, args);
  }
  throw fail("No matching get method in " + getClassName(c));
} catch (Exception __e) { throw rethrow(__e); } }

// used internally
static ArrayList<Method> callF_makeCache(Class c) {
  ArrayList<Method> l = new ArrayList();
  Class _c = c;
  do {
    for (Method m : _c.getDeclaredMethods())
      if (m.getName().equals("get")) {
        m.setAccessible(true);
        l.add(m);
      }
    if (!l.isEmpty()) break;
    _c = _c.getSuperclass();
  } while (_c != null);
  callF_cache.put(c, l);
  return l;
}
static void centerConsoleFrame() {
  centerFrame(consoleFrame());
}
static Set<String> followForwardRelation_raw(String relation, String argument) {
  return rawOnly(followForwardRelation(relation, argument));
}

static Set<String> followForwardRelation_raw(String relation, Lisp argument) {
  return rawOnly(followForwardRelation(relation, argument));
}
static <A> ArrayList<A> asList(A[] a) {
  return new ArrayList<A>(Arrays.asList(a));
}

static ArrayList<Integer> asList(int[] a) {
  ArrayList<Integer> l = new ArrayList();
  for (int i : a) l.add(i);
  return l;
}

static <A> ArrayList<A> asList(Iterable<A> s) {
  if (s instanceof ArrayList) return (ArrayList) s;
  ArrayList l = new ArrayList();
  if (s != null)
    for (A a : s)
      l.add(a);
  return l;
}

static <A> ArrayList<A> asList(Enumeration<A> e) {
  ArrayList l = new ArrayList();
  if (e != null)
    while (e.hasMoreElements())
      l.add(e.nextElement());
  return l;
}
static boolean englishToLisp_multi_debug;
static boolean englishToLisp_multi_left = true;

static ThreadLocal<Integer> englishToLisp_multi_level = new ThreadLocal();

static List<Lisp> englishToLisp_multi(String s) {
  return englishToLisp_multi(s, null);
}

static List<Lisp> englishToLisp_multi(String s, Object preprocess) {
  List<Lisp> c = new ArrayList();
  englishToLisp_multi(listCollector(c), s, preprocess);
  return c;
}

static void englishToLisp_multi(Collector<Lisp> out, String s, Object preprocess) {
  assertNotNull("Input", s);
  /*int level = englishToLisp_multi_level.get();
  if (level >= englishToLisp_multi_maxLevel) fail("max level");
  englishToLisp_multi_level.set(level+1);
  try {*/
  s = postProcess(preprocess, s);
  
  // pattern matching all concepts against full string
  for (AIConcept c : englishToConceptLanguage_concepts()) {
    if (empty(c.name)) {
      print("Warning, empty name: " + c.globalID);
      continue;
    }
    String name = postProcess(preprocess, c.name);
    englishToLisp_multi_with(out, c.globalID, name, s);
    if (out.full()) return;
  }
  
  // no full string match. go word by word
  /*
  L<S> tok = javaTok(s);
  if (l(tok) <= 3) ret;
  for (int i = 1; i < l(tok); i += 2) {
    S x = englishToLisp(unquote(tok.get(i)));
    if (nempty(x)) tok.set(i, conceptQuote(x));
  }
  S x = join(tok);
  if (neq(x, s)) out.add(x);
  */
}

static void englishToLisp_multi_with(Collector<Lisp> out, String id, String name, String s) {
  List<String> originalTok = javaTok(name), tok = cloneList(originalTok);
  if (l(tok) < 5) return; // need 2 code tokens
  /*if (englishToLisp_multi_debug)
    print("xyz name " + name + " originalTok1 " + struct(originalTok));*/
  boolean stars = tok.contains("*");
  if (stars)
    tok = replace(tok, "*", "**");
  /*if (englishToLisp_multi_debug)
    print("xyz name " + name + " originalTok2 " + struct(originalTok));*/
  int n = numberOfXYZVars(tok);
  if (n == 0) return;
  tok = formatXYZ(tok, rep(n, "*"));
  List<String> toks = javaTok_cached(s);
  if (stars)
    toks = replace(cloneList(toks), "*", "**");
  for (Matches m : flexMatchIC2_left_multi(tok, toks)) {
    if (englishToLisp_multi_debug)
      print("xyz: " + n + " " + struct(tok) + " - " + struct(toks) + " => " + struct(m));
    if (n != l(m.m)) return; // that's really wrong
    TreeMap<Integer,String> map = new TreeMap();
    if (englishToLisp_multi_debug)
      print("xyz originalTok " + struct(originalTok));
    for (int i = 1; i < l(originalTok); i += 2) {
      String t = originalTok.get(i);
      int x = xyzVarToIndex(t);
      if (englishToLisp_multi_debug)
        print("xyz " + t + " => " + x);
      if (x != 0) {
        //S sub = english+ToConceptLanguage_multi_sub(name, s, m.m[x-1]);
        String sub = m.m[x-1];
        map.put(i, sub);
      }
    }
    if (out.add(aiUsing(lisp(id, values(map))))) return;
  }
}
static Object mc() {
  return getMainClass();
}
static String indentx(String s) {
  return indentx(indent_default, s);
}

static String indentx(int n, String s) {
  return dropSuffix(repeat(' ', n), indent(n, s));
}

static String indentx(String indent, String s) {
  return dropSuffix(indent, indent(indent, s));
}
static List<String> toLines(File f) {
  return toLines(loadTextFile(f));
}

  public static List<String> toLines(String s) {
    List<String> lines = new ArrayList<String>();
    if (s == null) return lines;
    int start = 0;
    while (true) {
      int i = toLines_nextLineBreak(s, start);
      if (i < 0) {
        if (s.length() > start) lines.add(s.substring(start));
        break;
      }

      lines.add(s.substring(start, i));
      if (s.charAt(i) == '\r' && i+1 < s.length() && s.charAt(i+1) == '\n')
        i += 2;
      else
        ++i;

      start = i;
    }
    return lines;
  }

  private static int toLines_nextLineBreak(String s, int start) {
    for (int i = start; i < s.length(); i++) {
      char c = s.charAt(i);
      if (c == '\r' || c == '\n')
        return i;
    }
    return -1;
  }
static Object[] asObjectArray(List l) {
  return toObjectArray(l);
}
static Object conceptCall(String conceptID, Object... args) {
  String funcName = first(followForwardRelation_raw("ghwqkbpspivlalrb", conceptID));
  if (funcName == null) throw fail("Don't know how to call " + conceptID);
  return makeAndCall_cached(funcName, args);
}

static Object conceptCall(String conceptID, List args) {
  return conceptCall(conceptID, asObjectArray(args));
}
static Object callConcept(Lisp conceptID, Object... args) {
  return callConcept(conceptID.raw(), args);
}

static Object callConcept(String conceptID, Object... args) {
  return conceptCall(conceptID, args);
}

static Object callConcept(String conceptID, List args) {
  return conceptCall(conceptID, args);
}
static JFrame setFrameHeight(JFrame frame, int h) {
  frame.setSize(frame.getWidth(), h);
  return frame;
}

static JFrame setFrameHeight(int h, JFrame frame) {
  return setFrameHeight(frame, h);
}

  public static String loadTextFile(String fileName) {
    return loadTextFile(fileName, null);
  }
  
  public static String loadTextFile(String fileName, String defaultContents) {
    try {
      if (!new File(fileName).exists())
        return defaultContents;
  
      FileInputStream fileInputStream = new FileInputStream(fileName);
      InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
      return loadTextFile(inputStreamReader);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
  
  public static String loadTextFile(File fileName) {
      return loadTextFile(fileName, null);
  }

  public static String loadTextFile(File fileName, String defaultContents) {
      return loadTextFile(fileName.getPath(), defaultContents);
  }
  
  public static String loadTextFile(Reader reader) throws IOException {
    StringBuilder builder = new StringBuilder();
    try {
      char[] buffer = new char[1024];
      int n;
      while (-1 != (n = reader.read(buffer)))
        builder.append(buffer, 0, n);
        
    } finally {
      reader.close();
    }
    return builder.toString();
  }
static List<Lisp> lispTruth2(String... heads) {
  List<Lisp> out = new ArrayList();
  for (Lisp l : lispTruthByHead(heads))
    if (l.size() == 2) out.add(l);
  return out;
}
// make a lisp form
static Lisp lisp(String head, Object... args) {
  Lisp l = new Lisp(head);
  for (Object o : args)
    l.add(o);
  return l;
}

static Lisp lisp(String head, Collection args) {
  return new Lisp(head, args);
}

static boolean isFalse(Object o) {
  return eq(false, o);
}
static List<Lisp> sortByArgumentHygiene(List<Lisp> l) {
  IdentityHashMap<Lisp,Integer> scores = new IdentityHashMap();
  for (Lisp x : l)
    scores.put(x, lisp_roundBracketHygieneScore(x));
  return sortByDescScore(l, scores);
}
static Object makeAndCall_cached(String functionName, Object... args) {
  return preciseCall(loadFunctions_cached(functionName), functionName, args);
}
static void useConcepts(String concepts) {
  useConceptsDump(concepts);
}
static boolean isTrue(Object o) {
  if (o instanceof Boolean)
    return ((Boolean) o).booleanValue();
  if (o == null) return false;
  throw fail(getClassName(o));
}
static RuntimeException fail() {
  throw new RuntimeException("fail");
}

static RuntimeException fail(Throwable e) {
  throw asRuntimeException(e);
}

static RuntimeException fail(Object msg) {
  throw new RuntimeException(String.valueOf(msg));
}

static RuntimeException fail(String msg) {
  throw new RuntimeException(unnull(msg));
}
 
static RuntimeException fail(String msg, Throwable innerException) {
  throw new RuntimeException(msg, innerException);
}

static Lisp chooseBestArgumentHygiene(List<Lisp> l) {
  Best<Lisp> best = new Best();
  for (Lisp x : l)
    best.put(x, lisp_roundBracketHygieneScore(x));
  return best.get();
}
static boolean lispTrue(String head, Object... args) {
  Lisp l = lisp(head, args);
  for (Lisp x : lispTruthByHead(head))
    if (eq(x, l)) return true;
  return false;
}
// use facts in CL
static void useStatements_cl(List<String> statements) {
  useFacts_cl(statements);
}

static void useStatements_cl(String statements) {
  useFacts_cl(statements);
}
static Object first(Object list) {
  return empty((List) list) ? null : ((List) list).get(0);
}

static <A> A first(List<A> list) {
  return empty(list) ? null : list.get(0);
}

static <A> A first(A[] bla) {
  return bla == null || bla.length == 0 ? null : bla[0];
}

static <A> A first(Iterable<A> i) {
  if (i == null) return null;
  Iterator<A> it = i.iterator();
  return it.hasNext() ? it.next() : null;
}

static Character first(String s) { return empty(s) ? null : s.charAt(0); }



static String struct(Object o) {
  return structure(o);
}
static int xyzVarToIndex(String s) { return formatXYZ_varToIndex(s); }
static void useConceptsDump(String concepts) {
  List<AIConcept> usedConcepts = conceptsFromDump(concepts);
  //dumpConcepts2(findAIConcepts(conceptsUsed));
  //printAIConcepts(usedConcepts);
  setOpt(mc(), "englishToConceptLanguage_concepts_global", usedConcepts);
  aiConceptsMap_cached_autoClearInterval = 0;
  aiConceptsMap_cached_cache.set(indexByField(usedConcepts, "globalID"));
  ai();
}
static <A> List<A> replace(List<A> l, A a, A b) {
  for (int i = 0; i < l(l); i++)
    if (eq(l.get(i), a))
      l.set(i, b);
  return l;
}
static Set<Lisp> followForwardRelation(String relation, String argument) {
  return followForwardRelation(relation, lisp(argument));
}

static Set<Lisp> followForwardRelation(String relation, Lisp argument) {
  HashSet<Lisp> out = new HashSet();
  for (Lisp l : lispTruthByHead(relation))
    if (eq(l.get(0), argument))
      out.add(l.get(1));
  return out;
}
static <A> List<A> sortByDescScore(Collection<A> c, Map<A, ?> map) {
  List<A> l = cloneList(c);
  sort(l, mapComparatorDesc(map));
  return l;
}
static final HashMap<String, List<Method>> callMC_cache = new HashMap();
static String callMC_key;
static Method callMC_value;

// varargs assignment fixer for a single string array argument
static Object callMC(String method, String[] arg) {
  return callMC(method, new Object[] {arg});
}

static Object callMC(String method, Object... args) { try {
  Method me;
  synchronized(callMC_cache) {
    me = method == callMC_key ? callMC_value : null;
  }
  if (me != null) return callMC_value.invoke(null, args);

  List<Method> m = callMC_cache.get(method);
  if (m == null) {
    if (callMC_cache.isEmpty()) {
      callMC_makeCache();
      m = callMC_cache.get(method);
    }
    if (m == null) throw fail("Method named " + method + " not found in main");
  }
  int n = m.size();
  if (n == 1) {
    me = m.get(0);
    synchronized(callMC_cache) {
      callMC_key = method;
      callMC_value = me;
    }
    return me.invoke(null, args);
  }
  for (int i = 0; i < n; i++) {
    me = m.get(i);
    if (call_checkArgs(me, args, false))
      return me.invoke(null, args);
  }
  throw fail("No method called " + method + " with matching arguments found in main");
} catch (Exception __e) { throw rethrow(__e); } }

static synchronized void callMC_makeCache() {
  callMC_cache.clear();
  Class _c = (Class) mc(), c = _c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if ((m.getModifiers() & Modifier.STATIC) != 0) {
        m.setAccessible(true);
        multiMapPut(callMC_cache, m.getName(), m);
      }
    c = c.getSuperclass();
  }
}
static boolean empty(Collection c) {
  return isEmpty(c);
}

static boolean empty(String s) {
  return isEmpty(s);
}

static boolean empty(Map map) {
  return map == null || map.isEmpty();
}

static boolean empty(Object[] o) {
  return o == null || o.length == 0;
}

static boolean empty(Object o) {
  if (o instanceof Collection) return empty((Collection) o);
  if (o instanceof String) return empty((String) o);
  if (o instanceof Map) return empty((Map) o);
  if (o instanceof Object[]) return empty((Object[]) o);
  throw fail("unknown type for 'empty': " + getType(o));
}

static boolean empty(float[] a) { return a == null || a.length == 0; }
static int numberOfXYZVars(String s) {
  return numberOfXYZVars_c(javaTokC(s));
}

static int numberOfXYZVars_c(List<String> ctok) {
  int m = 0;
  for (String t : ctok) m = max(m, xyzVarToIndex(t));
  return m;
}

static int numberOfXYZVars(List<String> tok) {
  int m = 0;
  for (int i = 1; i < l(tok); i += 2)
    m = max(m, xyzVarToIndex(tok.get(i)));
  return m;
}
static void useFacts(String facts) {
  List<String> statements = linesToCL(facts);
  useFacts_cl(statements);
}
  
// use facts in CL
static void useFacts_cl(List<String> statements) {
  ai();
  // trueStatements_cached_autoClearInterval = 0;
  trueStatements_cached_cache.set(new LinkedHashSet(statements));
  loadTruth_cached_cache.set(aiMakeStatements(statements));
}

static void useFacts_cl(String statements) {
  useFacts_cl(toLinesFullTrim(statements));
}
static RuntimeException asRuntimeException(Throwable t) {
  return t instanceof RuntimeException ? (RuntimeException) t : new RuntimeException(t);
}
static <A> A assertNotNull(A a) {
  assertTrue(a != null);
  return a;
}

static <A> A assertNotNull(String msg, A a) {
  assertTrue(msg, a != null);
  return a;
}
// TODO: test if android complains about this
static boolean isAWTThread() {
  if (isAndroid()) return false;
  if (isHeadless()) return false;
  return isAWTThread_awt();
}

static boolean isAWTThread_awt() {
  return SwingUtilities.isEventDispatchThread();
}
static String rep(int n, char c) {
  return repeat(c, n);
}

static String rep(char c, int n) {
  return repeat(c, n);
}

static <A> List<A> rep(A a, int n) {
  return repeat(a, n);
}

static <A> List<A> rep(int n, A a) {
  return repeat(n, a);
}

static Thread currentThread() {
  return Thread.currentThread();
}
static <A> List<A> cloneList(Collection<A> l) {
  if (l == null) return new ArrayList();
  //O mutex = getOpt(l, "mutex");
  /*if (mutex != null)
    synchronized(mutex) {
      ret new ArrayList<A>(l);
    }
  else
    ret new ArrayList<A>(l);*/
  // assume mutex is equal to collection, which will be true unless you explicitly pass a mutex to synchronizedList() which no one ever does.
  synchronized(l) {
    return new ArrayList<A>(l);
  }
}
static boolean eq(Object a, Object b) {
  if (a == null) return b == null;
  if (a == b) return true;
  if (a.equals(b)) return true;
  if (a instanceof BigInteger) {
    if (b instanceof Integer) return a.equals(BigInteger.valueOf((Integer) b));
    if (b instanceof Long) return a.equals(BigInteger.valueOf((Long) b));
  }
  return false;
}
  static Object call(Object o) {
    return callFunction(o);
  }
  
  // varargs assignment fixer for a single string array argument
  static Object call(Object o, String method, String[] arg) {
    return call(o, method, new Object[] {arg});
  }
  
  static Object call(Object o, String method, Object... args) {
    try {
      if (o instanceof Class) {
        Method m = call_findStaticMethod((Class) o, method, args, false);
        m.setAccessible(true);
        return m.invoke(null, args);
      } else {
        Method m = call_findMethod(o, method, args, false);
        m.setAccessible(true);
        return m.invoke(o, args);
      }
    } catch (Exception e) {
      throw e instanceof RuntimeException ? (RuntimeException) e : new RuntimeException(e);
    }
  }

  static Method call_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
    Class _c = c;
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (!m.getName().equals(method)) {
          if (debug) System.out.println("Method name mismatch: " + method);
          continue;
        }

        if ((m.getModifiers() & Modifier.STATIC) == 0 || !call_checkArgs(m, args, debug))
          continue;

        return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (static) with " + args.length + " parameter(s) not found in " + _c.getName());
  }

  static Method call_findMethod(Object o, String method, Object[] args, boolean debug) {
    Class c = o.getClass();
    while (c != null) {
      for (Method m : c.getDeclaredMethods()) {
        if (debug)
          System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
        if (m.getName().equals(method) && call_checkArgs(m, args, debug))
          return m;
      }
      c = c.getSuperclass();
    }
    throw new RuntimeException("Method '" + method + "' (non-static) with " + args.length + " parameter(s) not found in " + o.getClass().getName());
  }

  private static boolean call_checkArgs(Method m, Object[] args, boolean debug) {
    Class<?>[] types = m.getParameterTypes();
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }


static List<Lisp> lispTruthByHead(String... heads) {
  return collect(lispStatementsByHead(heads), "term");
}
static String getClassName(Object o) {
  return o == null ? "null" : o.getClass().getName();
}
static Map synchroMap() {
  return synchroHashMap();
}

static <A, B> Map<A, B> synchroMap(Map<A, B> map) {
  return Collections.synchronizedMap(map);
}
static int indent_default = 2;

static String indent(int indent) {
  return repeat(' ', indent);
}

static String indent(int indent, String s) {
  return indent(repeat(' ', indent), s);
}

static String indent(String indent, String s) {
  return indent + s.replace("\n", "\n" + indent);
}

static String indent(String s) {
  return indent(indent_default, s);
}

static List<String> indent(String indent, List<String> lines) {
  List<String> l = new ArrayList();
  for (String s : lines)
    l.add(indent + s);
  return l;
}
static <A, B> Collection<B> values(Map<A, B> map) {
  return map == null ? emptyList() : map.values();
}

// replacement for class JavaTok
// maybe incomplete, might want to add floating point numbers
// todo also: extended multi-line strings

static int javaTok_n, javaTok_elements;
static boolean javaTok_opt;

static List<String> javaTok(String s) {
  return javaTok(s, null);
}

static List<String> javaTok(String s, List<String> existing) {
  ++javaTok_n;
  int nExisting = javaTok_opt && existing != null ? existing.size() : 0;
  ArrayList<String> tok = existing != null ? new ArrayList(nExisting) : new ArrayList();
  int l = s.length();
  
  int i = 0, n = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(quickSubstring(s, i, j));
    ++n;
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener /*|| s.charAt(j) == '\n'*/) { // allow multi-line strings
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    if (n < nExisting && javaTok_isCopyable(existing.get(n), s, i, j))
      tok.add(existing.get(n));
    else
      tok.add(quickSubstring(s, i, j));
    ++n;
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  javaTok_elements += tok.size();
  return tok;
}

static List<String> javaTok(List<String> tok) {
  return javaTok(join(tok), tok);
}

static boolean javaTok_isCopyable(String t, String s, int i, int j) {
  return t.length() == j-i
    && s.regionMatches(i, t, 0, j-i); // << could be left out, but that's brave
}
static Set<String> rawOnly(Set<Lisp> l) {
  Set<String> out = similarEmptySet(l);
  for (Lisp x : l)
    if (x != null && x.isLeaf())
      out.add(x.head);
  return out;
}
static HashMap<Set<String>, Class> loadFunctions_cache = new HashMap();

static Class loadFunctions_cached(String... functions) {
  return loadFunctions_cached(asList(functions));
}

static Class loadFunctions_cached(List<String> functions) {
  Set<String> functionSet = new TreeSet<String>(functions);
  synchronized(loadFunctions_cache) {
    Class c = loadFunctions_cache.get(functionSet);
    if (c == null) {
      loadFunctions_cache.put(functionSet, c = loadFunctions(functionSet));
      assertNotNull(loadFunctions_cache.get(functionSet));
    }
    return c;
  }
}
static JFrame centerFrame(JFrame frame) {
  frame.setLocationRelativeTo(null); // magic trick
  return frame;
}
static List emptyList() {
  return new ArrayList();
  //ret Collections.emptyList();
}
// collects into l
// 1 billion entries are enough for everyone
static <A> Collector<A> listCollector(final Collection<A> l) {
  return limitedListCollector(l, 1024*1024*1024);
}
// get purpose 1: access a list/array (safer version of x.get(y))

static <A> A get(List<A> l, int idx) {
  return l != null && idx >= 0 && idx < l(l) ? l.get(idx) : null;
}

static <A> A get(A[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : null;
}

// default to false
static boolean get(boolean[] l, int idx) {
  return idx >= 0 && idx < l(l) ? l[idx] : false;
}

// get purpose 2: access a field by reflection or a map

static Object get(Object o, String field) {
  try {
    if (o instanceof Class) return get((Class) o, field);
    
    if (o instanceof Map)
      return ((Map) o).get(field);
      
    Field f = getOpt_findField(o.getClass(), field);
    if (f != null) {
      f.setAccessible(true);
      return f.get(o);
    }
      
    
      if (o instanceof DynamicObject)
        return ((DynamicObject) o).fieldValues.get(field);
    
  } catch (Exception e) {
    throw asRuntimeException(e);
  }
  throw new RuntimeException("Field '" + field + "' not found in " + o.getClass().getName());
}

static Object get_raw(Object o, String field) {
  try {
    Field f = get_findField(o.getClass(), field);
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object get(Class c, String field) {
  try {
    Field f = get_findStaticField(c, field);
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field get_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field get_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
static String repeat(char c, int n) {
  n = Math.max(n, 0);
  char[] chars = new char[n];
  for (int i = 0; i < n; i++)
    chars[i] = c;
  return new String(chars);
}

static <A> List<A> repeat(A a, int n) {
  List<A> l = new ArrayList();
  for (int i = 0; i < n; i++)
    l.add(a);
  return l;
}

static <A> List<A> repeat(int n, A a) {
  return repeat(a, n);
}
static String formatXYZ(String pattern, List<String> args) {
  return join(formatXYZ(javaTok(pattern), args));
}

// modifies tok!
static List<String> formatXYZ(List<String> tok, List<String> args) {
  for (int i = 1; i < l(tok); i += 2) {
    String t = tok.get(i);
    int idx = formatXYZ_varToIndex(t)-1;
    if (idx >= 0 && l(args) > idx)
      tok.set(i, args.get(idx));
  }
  return tok;
}

static String formatXYZ(String pattern, String... args) {
  return formatXYZ(pattern, asList(args));
}

static Object[] toObjectArray(Collection c) {
  List l = asList(c);
  return l.toArray(new Object[l.size()]);
}

static boolean hasRoundBracketHygiene(String s) {
  return hasBracketHygiene(s, "(", ")");
}
static <A> A postProcess(Object f, A a) {
  return callPostProcessor(f, a);
}
static Class __javax;

static Class getJavaX() {
  return __javax;
}
static Class getMainClass() {
  return main.class;
}

static Class getMainClass(Object o) { try {
  return (o instanceof Class ? (Class) o : o.getClass()).getClassLoader().loadClass("main");
} catch (Exception __e) { throw rethrow(__e); } }
static String dropSuffix(String suffix, String s) {
  return s.endsWith(suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static boolean preciseCall_debug;

static Object preciseCall(Object o, String method, Object... args) { try {
  if (o instanceof Class) {
    List<Method> methods = findMethodsNamed2((Class) o, method, true);
    Lowest<Method> best = new Lowest();
    for (Method m : methods) {
      int score = methodApplicabilityScore(m, args);
      if (score < Integer.MAX_VALUE) {
        if (preciseCall_debug)
          print("Method score: " + m + " " + score);
        best.put(m, score);
      }
    }
    Method m = best.get();
    if (m == null) throw fail("No suitable method found: " + methodSignature(method, args));
    return m.invoke(null, args);
  } else {
    throw todo();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static int l(Object[] a) { return a == null ? 0 : a.length; }
static int l(boolean[] a) { return a == null ? 0 : a.length; }
static int l(byte[] a) { return a == null ? 0 : a.length; }
static int l(int[] a) { return a == null ? 0 : a.length; }
static int l(float[] a) { return a == null ? 0 : a.length; }
static int l(char[] a) { return a == null ? 0 : a.length; }
static int l(Collection c) { return c == null ? 0 : c.size(); }
static int l(Map m) { return m == null ? 0 : m.size(); }
static int l(CharSequence s) { return s == null ? 0 : s.length(); } static long l(File f) { return f == null ? 0 : f.length(); }

static int l(Object o) {
  return o instanceof String ? l((String) o)
    : l((Collection) o); // incomplete
}




  static int l(Lisp l) { return l == null ? 0 : l.size(); }

static Set<String> aiUsing_set = synchroTreeSet();

static String aiUsing(String s) {
  aiUsing_set.addAll(aggressivelyCollectPossibleGlobalIDs(s));
  return s;
}

static void aiUsing(Object o) {
  // TODO
}

static <A> List<A> aiUsing(List<A> l) {
  for (Object li : unnull(l)) aiUsing(li);
  return l;
}

static Lisp aiUsing(Lisp l) {
  if (l != null) {
    aiUsing(l.head);
    for (Lisp sub : l) aiUsing(sub);
  }
  return l;
}

static void aiUsing_print() {
  aiUsing_print(null);
}

static void aiUsing_print(List<String> priorityConcepts) {
  //print("\nAI concepts used: " + aiUsing_set);
  print("\nAI concepts used: ");
  dumpConcepts2(findAIConcepts(prioritizeList(aiUsing_set, priorityConcepts)));
}
static ThreadLocal < List < AIConcept > > englishToConceptLanguage_concepts = new ThreadLocal();
static volatile List<AIConcept> englishToConceptLanguage_concepts_global;

static List<AIConcept> englishToConceptLanguage_concepts() {
  List<AIConcept> l = englishToConceptLanguage_concepts.get();
  if (l != null) return l;
  l = englishToConceptLanguage_concepts_global;
  if (l != null) return l;
  return aiConceptsPrioritized();
}
static Object getOpt(Object o, String field) {
  return getOpt_cached(o, field);
}

static Object getOpt_raw(Object o, String field) {
  try {
    Field f = getOpt_findField(o.getClass(), field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(o);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Object getOpt(Class c, String field) {
  try {
    if (c == null) return null;
    Field f = getOpt_findStaticField(c, field);
    if (f == null) return null;
    f.setAccessible(true);
    return f.get(null);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Field getOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static List<Matches> flexMatchIC2_left_multi(List<String> tokpat, List<String> toks) {
  List<Matches> out = new ArrayList();
  if (l(tokpat) == 7 && eq(tokpat.get(1), "*") && neq(tokpat.get(3), "*") && eq(tokpat.get(5), "*")) {
    String middle = tokpat.get(3);
    for (int i : reverseIndexesOf(toks, middle))
      if (i > 1 && i < l(toks)-2)
        out.add(new Matches(join(subList(toks, 1, i-1)), join(subList(toks, i+2, l(toks)-1))));
  } else {
    Matches m = new Matches();
    if (flexMatchIC2_left(tokpat, toks, m, false))
      out.add(m);
  }
  return out;
}
static String javaTok_cached_s;
static List<String> javaTok_cached_l;

static synchronized List<String> javaTok_cached(String s) {
  if (neq(s, javaTok_cached_s))
    javaTok_cached_l = javaTok(javaTok_cached_s = s);
  return javaTok_cached_l;
}


static Object callFunction(Object f, Object... args) {
  return callF(f, args);
}
static String methodSignature(String name, Object[] args) {
  StringBuilder buf = new StringBuilder(name + "(");
  for (int i = 0; i < l(args); i++) {
    if (i != 0) buf.append(", ");
    buf.append(getClassName(args[i]));
  }
  buf.append(")");
  return str(buf);
}
  public static String join(String glue, Iterable<String> strings) {
    StringBuilder buf = new StringBuilder();
    Iterator<String> i = strings.iterator();
    if (i.hasNext()) {
      buf.append(i.next());
      while (i.hasNext())
        buf.append(glue).append(i.next());
    }
    return buf.toString();
  }
  
  public static String join(String glue, String[] strings) {
    return join(glue, Arrays.asList(strings));
  }
  
  public static String join(Iterable<String> strings) {
    return join("", strings);
  }
  
  public static String join(String[] strings) {
    return join("", strings);
  }

// TODO: WeakAssoc from loadTruth_cached()
static Cache<Set<String>> trueStatements_cached_cache = new Cache(new Object() { Object get() { try { return  collectTreeSet(loadTruth_cached(), "text") ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "collectTreeSet(loadTruth_cached(), \"text\")"; }});

static Set<String> trueStatements_cached() {
  return trueStatements_cached_cache.get();
}

static void trueStatements_clearCache() {
  trueStatements_cached_cache.clear();
}

// clear cache if older than x seconds
static void trueStatements_clearCache(double seconds) {
  trueStatements_cached_cache.clear(seconds);
}
static List<Method> findMethodsNamed2(Object obj, String method, boolean staticOnly) {
  if (obj == null) return null;
  return findMethodsNamed2(_getClass(obj), method, staticOnly);
}

static List<Method> findMethodsNamed2(Class c, String method, boolean staticOnly) {
  List<Method> l = new ArrayList();
  while (c != null) {
    for (Method m : c.getDeclaredMethods())
      if (m.getName().equals(method) &&
        (!staticOnly || (m.getModifiers() & Modifier.STATIC) != 0)) {
        m.setAccessible(true);
        l.add(m);
      }
    c = c.getSuperclass();
  }
  return l;
}
static void ai() {
  aiEnhancements();
}
static boolean aiConceptsMap_fastLoad, aiConceptsMap_silent;
static List<AIConcept> aiConceptsMap_list;

static Map<String, AIConcept> aiConceptsMap() {
  long time = sysNow();
  List<AIConcept> concepts = aiConceptsMap_fastLoad ? fastLoadAIConcepts() : loadAIConcepts();
  aiConceptsMap_list = concepts;
  Map<String, AIConcept> map = indexByField(concepts, "globalID");
  if (!aiConceptsMap_silent)
    sysDone(time, "load ai concepts");
  return map;
}
static String getType(Object o) {
  return getClassName(o);
}
static String quickSubstring(String s, int i, int j) {
  if (i == j) return "";
  return s.substring(i, j);
}
static List<String> linesToCL(String text) {
  return listToCL(linesToCL_prepare(text));
}

static List<String> linesToCL_prepare(String text) {
  return toLinesFullTrim(joinLines(map("javaDropComments", toLinesFullTrim(text))));
}
static <A> Set<A> synchroTreeSet() {
  return Collections.synchronizedSet(new TreeSet<A>());
}

static boolean hasBracketHygiene(String s, String op, String close, Var<String> msg) {
  return testBracketHygiene(s, op, close, msg);
}

static boolean hasBracketHygiene(String s, String op, String close) {
  return testBracketHygiene(s, op, close, null);
}

static List<LispStatement> lispStatementsByHead(final String... heads) {
  return aiUsing(filter(values(lispStatements_cached()) , new Object() { Object get(LispStatement s) { try { return  s.term.is(heads) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "s.term.is(heads)"; }}));
}
static <A> A callPostProcessor(Object f, A a) {
  return f == null ? a : (A) callF(f, a);
}
static void assertTrue(Object o) {
  assertEquals(true, o);
}
  
static boolean assertTrue(String msg, boolean b) {
  if (!b)
    throw fail(msg);
  return b;
}

static boolean assertTrue(boolean b) {
  if (!b)
    throw fail("oops");
  return b;
}
static boolean flexMatchIC2_left_debug;

static boolean flexMatchIC2_left(String pat, String s) {
  return flexMatchIC2_left(pat, s, null);
}

static boolean flexMatchIC2_left(String pat, String s, Matches m) {
  return flexMatchIC2_left(javaTok(pat), javaTok_cached(unnull(s)), m);
}

static boolean flexMatchIC2_left(String pat, String s, Matches m, boolean joinBrackets) {
  return flexMatchIC2_left(javaTok(pat), javaTok_cached(unnull(s)), m, joinBrackets);
}

static boolean flexMatchIC2_left(List<String> tokpat, List<String> tokfull, Matches m) {
  return flexMatchIC2_left(tokpat, tokfull, m, true);
}

static boolean flexMatchIC2_left(List<String> tokpat, List<String> tokfull, Matches m, boolean joinBrackets) {
  tokpat = codeTokens(joinBrackets ? joinBrackets(tokpat) : tokpat);
  for (int i = 0; i < l(tokpat); i++)
    if (eq(tokpat.get(i), "*"))
      tokpat.add(i++, "!*"); // insert single-token wildcard in front to avoid empty matches
  if (joinBrackets) tokfull = joinBrackets(tokfull);
  List<String> tok = codeTokens(tokfull);
  BitSet bla = new BitSet();
  BitSet bla2 = new BitSet();
  if (!flexMatchIC2_left_impl(tokpat, 0, tok, 0, bla, bla2)) return false;
  if (m != null) {
    List<String> l = new ArrayList();
    for (int i = 1; i < l(tokfull); i += 2) {
      if (bla.get(i/2)) {
        int j = i;
        while (j < l(tokfull) && bla.get(j/2)) j += 2;
        l.add(join(subList(tokfull, i, j-1)));
        i = j-2;
      } else if (bla2.get(i/2))
        l.add(tokfull.get(i));
    }
    m.m = toStringArray(l);
  }
  return true;
}

static boolean flexMatchIC2_left_impl(List<String> pat, int ipat, List<String> tok, int itok, BitSet bla, BitSet bla2) {
  if (flexMatchIC2_left_debug)
    print("flexMatchIC2_left pat=" + structure(subList(pat, ipat)) + " tok=" + structure(subList(tok, itok)) + " " + structure(bla));
  if (ipat >= l(pat))
    return itok >= l(tok);
  String t = pat.get(ipat);
  
  if (eq(t, "*")) { // the flex wildcard (0 or more tokens)
    bla.set(itok);
    if (itok < l(tok)) {
      if (flexMatchIC2_left_debug) print("Trying one or more tokens");
      if (flexMatchIC2_left_impl(pat, ipat, tok, itok+1, bla, bla2)) {
        if (flexMatchIC2_left_debug) print("Success!");
        return true; // success, leave mark
      }
    }
    bla.clear(itok); // fail, undo marking
    
    if (flexMatchIC2_left_debug) print("Trying zero tokens");
    if (flexMatchIC2_left_impl(pat, ipat+1, tok, itok, bla, bla2)) {
      if (flexMatchIC2_left_debug) print("Success!");
      return true;
    }
    
    if (flexMatchIC2_left_debug) print("Failed * matching");
    return false;
  }
  if (itok >= l(tok)) {
    if (flexMatchIC2_left_debug)
      print("too much pattern");
    return false;
  }
  if (eq(t, "!*")) { // the single-token wildcard
    bla.set(itok);
    if (flexMatchIC2_left_impl(pat, ipat+1, tok, itok+1, bla, bla2))
      return true; // success, leave mark
    bla.clear(itok); // fail, undo marking
    return false;
  }
  String realt = tok.get(itok);
  if (t.startsWith("(") && t.endsWith(")")) {
    // quick pre-check
    if (flexMatchIC2_left_debug)
      print("flexMatchIC2_left precheck " + t + " " + realt);
    if (!containsIgnoreCase(t, realt)) return false;
    // real check
    List<String> list = splitAt(dropFirstAndLast(t), "|");
    if (flexMatchIC2_left_debug)
      print("flexMatchIC2_left real check " + struct(list));
    if (!containsIgnoreCase(list, realt)) return false;
    bla2.set(itok);
  } else if (neqic(realt, t)) {
    if (flexMatchIC2_left_debug)
      print("mismatch");
    return false;
  }
  
  // it is a token match. consume and proceed
  if (flexMatchIC2_left_impl(pat, ipat+1, tok, itok+1, bla, bla2))
    return true;
  else {
    bla2.clear(itok);
    return false;
  }
}
// return Int.MAX_VALUE if not applicable
// Lower score is better
static int methodApplicabilityScore(Method m, Object[] args) {
   Class<?>[] types = m.getParameterTypes();
   if (types.length != args.length) return Integer.MAX_VALUE;
   int score = 0;
   for (int i = 0; i < types.length; i++) {
     Object a = args[i];
     Class c = types[i];
     if (a == null) ++score;
     else if (c == a.getClass()) {} // perfect match
     else if (isInstanceX(c, a)) ++score;
     else return Integer.MAX_VALUE;
  }
  return score;
}
static <A> List<A> subList(List<A> l, int startIndex) {
  return subList(l, startIndex, l(l));
}

static <A> List<A> subList(List<A> l, int startIndex, int endIndex) {
  startIndex = max(0, min(l(l), startIndex));
  endIndex = max(0, min(l(l), endIndex));
  if (startIndex > endIndex) return litlist();
  return l.subList(startIndex, endIndex);
}
static int max(int a, int b) {
  return Math.max(a, b);
}

static int max(int a, int b, int c) {
  return max(max(a, b), c);
}

static long max(int a, long b) {
  return Math.max((long) a, b);
}

static long max(long a, long b) {
  return Math.max(a, b);
}

static double max(int a, double b) {
  return Math.max((double) a, b);
}

static float max(float a, float b) {
  return Math.max(a, b);
}

static int max(Collection<Integer> c) {
  int x = Integer.MIN_VALUE;
  for (int i : c) x = max(x, i);
  return x;
}

static double max(double[] c) {
  if (c.length == 0) return Double.MIN_VALUE;
  double x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static float max(float[] c) {
  if (c.length == 0) return Float.MAX_VALUE;
  float x = c[0];
  for (int i = 1; i < c.length; i++) x = Math.max(x, c[i]);
  return x;
}

static byte max(byte[] c) {
  byte x = -128;
  for (byte d : c) if (d > x) x = d;
  return x;
}

static short max(short[] c) {
  short x = -0x8000;
  for (short d : c) if (d > x) x = d;
  return x;
}
static List<String> javaTokC(String s) {
  int l = s.length();
  ArrayList<String> tok = new ArrayList();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c, d;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      d = j+1 >= l ? '\0' : s.charAt(j+1);
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (c == '/' && d == '*') {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (c == '/' && d == '/') {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    d = i+1 >= l ? '\0' : s.charAt(i+1);

    // scan for non-whitespace
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
    else if (Character.isDigit(c)) {
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
      if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
    } else if (c == '[' && d == '[') {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else
      ++j;
      
    tok.add(quickSubstring(s, i, j));
    i = j;
  }
  
  return tok;
}

  static RuntimeException todo() {
    throw new RuntimeException("todo");
  }
  
  static RuntimeException todo(String msg) {
    throw new RuntimeException(msg);
  }
static Field getOpt_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static <A> List<A> prioritizeList(Collection<A> c, List<A> prioritizer) {
  List<A> l = new ArrayList();
  Set<A> set = asSet(c);
  for (A a : prioritizer) {
    if (set.contains(a)) {
      set.remove(a);
      l.add(a);
    }
  }
  l.addAll(set);
  return l;
}
static Boolean isHeadless_cache;

static boolean isHeadless() {
  if (isHeadless_cache != null) return isHeadless_cache;
  if (GraphicsEnvironment.isHeadless()) return isHeadless_cache = true;
  
  // Also check if AWT actually works.
  // If DISPLAY variable is set but no X server up, this will notice.
  
  try {
    SwingUtilities.isEventDispatchThread();
    return isHeadless_cache = false;
  } catch (Throwable e) { return isHeadless_cache = true; }
}
static Cache<List<Statement>> loadTruth_cached_cache = new Cache("loadTruth");

static List<Statement> loadTruth_cached() {
  return loadTruth_cached_cache.get();
}

static void loadTruth_clearCache() {
  loadTruth_cached_cache.clear();
}

static void loadTruth_clearCache(double seconds) {
  loadTruth_cached_cache.clear(seconds);
}
static Set similarEmptySet(Set m) {
  if (m instanceof TreeSet) return new TreeSet();
  if (m instanceof LinkedHashSet) return new LinkedHashSet();
  return new HashSet();
}
static <A, B> void multiMapPut(Map<A, List<B>> map, A a, B b) {
  List<B> l = map.get(a);
  if (l == null)
    map.put(a, l = new ArrayList());
  l.add(b);
}
static boolean neq(Object a, Object b) {
  return !eq(a, b);
}
static int formatXYZ_varToIndex(String t) {
  if (l(t) == 1 && eqOneOf(t, "X", "Y", "Z"))
    return 1 + charDiff(t.charAt(0), 'X');
  else if (l(t) == 2 && t.startsWith("A")) {
    char c = t.charAt(1);
    if (c >= 'A' && c <= 'Z')
      return 4 + charDiff(t.charAt(1), 'A');
  }
  return 0;
}
// extended over Class.isInstance() to handle primitive types
static boolean isInstanceX(Class type, Object arg) {
  if (type == boolean.class) return arg instanceof Boolean;
  if (type == int.class) return arg instanceof Integer;
  if (type == long.class) return arg instanceof Long;
  if (type == float.class) return arg instanceof Float;
  if (type == short.class) return arg instanceof Short;
  if (type == char.class) return arg instanceof Character;
  if (type == byte.class) return arg instanceof Byte;
  if (type == double.class) return arg instanceof Double;
  return type.isInstance(arg);
}
static List<Statement> aiMakeStatements(List<String> statements) {
  return map(new Object() { Object get(String s) { try { 
    Statement st = unlisted(Statement.class);
    st.globalID = aGlobalID();
    st.text = s;
    return st;
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Statement st = unlisted(Statement);\r\n    st.globalID = aGlobalID();\r\n    st.text..."; }}, statements);
}
static Set<String> aggressivelyCollectPossibleGlobalIDs(String s) {
  LinkedHashSet<String> ids = new LinkedHashSet();
  if (s == null) return ids;
  for (int i = 0; i < l(s); i++) {
    int j = i;
    while (j < l(s) && Character.isLowerCase(s.charAt(j))) ++j;
    if (j-i == 16)
      ids.add(substring(s, i, j));
    i = j;
  }
  return ids;
}
static <T> void sort(T[] a, Comparator<? super T> c) {
  Arrays.sort(a, c);
}

static <T> void sort(T[] a) {
  Arrays.sort(a);
}

static <T> void sort(List<T> a, Comparator<? super T> c) {
  Collections.sort(a, c);
}

static void sort(List a) {
  Collections.sort(a);
}
static <A> List<Integer> reverseIndexesOf(List<A> l, A a) {
  return reverseList(indexesOf(l, a));
}
// collects into l
static <A> Collector<A> limitedListCollector(final Collection<A> l, final int max) {
  return new Collector<A>() {
    boolean full() {
      return l(l) >= max;
    }
    
    boolean add(A a) {
      if (full()) return false;
      l.add(a);
      return full();
    }
    
    boolean contains(A a) {
      return l.contains(a);
    }
  };
}
static List<AIConcept> aiConceptsPrioritized() {
  return aiConceptsByAge();
}
static List<AIConcept> conceptsFromDump(String s) {
  List<List<String>> l = (List) safeUnstructure("[" + s + "]");
  List<AIConcept> out = new ArrayList();
  for (List<String> x : l) {
    AIConcept c = unlisted(AIConcept.class);
    String id = makeNewID(get(x, 0));
    cset(c, "globalID" , id, "name" , unnull(get(x, 1)), "comment" , unnull(get(x, 2)));
    out.add(c);
  }
  return out;
}
static List collect(Collection c, String field) {
  return collectField(c, field);
}
static List<AIConcept> findAIConcepts(String ids) {
  return findAIConcepts(javaTokC(ids));
}

static List<AIConcept> findAIConcepts(Iterable ids) {
  List<AIConcept> l = new ArrayList();
  for (Object id : ids)
    if (id instanceof String)
      addIfNotNull(l, aiConceptsMap_cached().get((String) id));
    else if (id instanceof AIConcept)
      l.add((AIConcept) id);
  return l;
}
static final WeakHashMap<Class, HashMap<String, Field>> getOpt_cache = new WeakHashMap();
static final HashMap getOpt_special = new HashMap(); // just a marker

static {
  getOpt_cache.put(Class.class, getOpt_special);
  getOpt_cache.put(String.class, getOpt_special);
}

static Object getOpt_cached(Object o, String field) { try {
  if (o == null) return null;

  Class c = o.getClass();
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class)
      return getOpt((Class) o, field);
    /*if (o instanceof S)
      ret getOpt(getBot((S) o), field);*/
    if (o instanceof Map)
      return ((Map) o).get(field);
  }
    
  Field f = map.get(field);
  if (f != null) return f.get(o);
  
    if (o instanceof DynamicObject)
      return ((DynamicObject) o).fieldValues.get(field);
  
  return null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Field> getOpt_makeCache(Class c) {
  HashMap<String, Field> map;
  if (isSubtypeOf(c, Map.class))
    map = getOpt_special;
  else {
    map = new HashMap();
    Class _c = c;
    do {
      for (Field f : _c.getDeclaredFields()) {
        f.setAccessible(true);
        String name = f.getName();
        if (!map.containsKey(name))
          map.put(name, f);
      }
      _c = _c.getSuperclass();
    } while (_c != null);
  }
  getOpt_cache.put(c, map);
  return map;
}
static boolean loadFunctions_debug;

static Class loadFunctions(String... functions) {
  return loadFunctions(asList(functions));
}

static Class loadFunctions(Collection<String> functions) {
  StringBuilder buf = new StringBuilder();
  for (String s : asSet(functions))
    buf.append("please include function " + assertIdentifier(s) + ".\n");
  long time = sysNow();
  Class c = veryQuickJava(str(buf));
  if (loadFunctions_debug)
    done2_always(time, "loadFunctions: " + join(" ", functions));
  return c;
}
static <A, B> Comparator<A> mapComparatorDesc(final Map<A, B> map) {
  return new Comparator<A>() {
    public int compare(A a, A b) {
      return cmp(map.get(b), map.get(a));
    }
  };
}
static boolean isEmpty(Collection c) {
  return c == null || c.isEmpty();
}

static boolean isEmpty(CharSequence s) {
  return s == null || s.length() == 0;
}

static boolean isEmpty(Object[] a) {
  return a == null || a.length == 0;
}

static boolean isEmpty(Map map) {
  return map == null || map.isEmpty();
}
static boolean structure_showTiming, structure_checkTokenCount;

static String structure(Object o) {
  structure_Data d = new structure_Data();
  StringWriter sw = new StringWriter();
  d.out = new PrintWriter(sw);
  structure_go(o, d);
  String s = str(sw);
  if (structure_checkTokenCount) {
    print("token count=" + d.n);
    assertEquals("token count", l(javaTokC(s)), d.n);
  }
  return s;
}

static void structure_go(Object o, structure_Data d) {
  structure_1(o, d);
  while (nempty(d.stack))
    popLast(d.stack).run();
}

static void structureToPrintWriter(Object o, PrintWriter out) {
  structure_Data d = new structure_Data();
  d.out = out;
  structure_go(o, d);
}

// leave to false, unless unstructure() breaks
static boolean structure_allowShortening = false;

static int structure_shareStringsLongerThan = 20;

static class structure_Data {
  PrintWriter out;
  int stringSizeLimit;
  IdentityHashMap<Object,Integer> seen = new IdentityHashMap();
  BitSet refd = new BitSet();
  HashMap<String,Integer> strings = new HashMap();
  HashSet<String> concepts = new HashSet();
  HashMap<Class, List<Field>> fieldsByClass = new HashMap();
  Class conceptClass = findClass("Concept");
  int n; // token count
  List<Runnable> stack = new ArrayList();
  
  // append single token
  structure_Data append(String token) { out.print(token); ++n; return this; }
  structure_Data append(int i) { out.print(i); ++n; return this; }
  
  // append multiple tokens
  structure_Data append(String token, int tokCount) { out.print(token); n += tokCount; return this; }
  
  // extend last token
  structure_Data app(String token) { out.print(token); return this; }
  structure_Data app(int i) { out.print(i); return this; }
}

static void structure_1(final Object o, final structure_Data d) {
  final PrintWriter out = d.out;
  
  if (o == null) { d.append("null"); return; }
  
  Class c = o.getClass();
  String name = c.getName();
  String dynName = shortDynamicClassName(o);
  boolean concept = d.conceptClass != null && d.conceptClass.isInstance(o);
  List<Field> lFields = d.fieldsByClass.get(c);
  
  if (lFields == null) {
    // these are never back-referenced (for readability)
    
    if (o instanceof Number) {
      if (o instanceof Integer) { int i = ((Integer) o).intValue(); out.print(i); d.n += i < 0 ? 2 : 1; return; }
      if (o instanceof Long) { long l = ((Long) o).longValue(); out.print(l); out.print("L"); d.n += l < 0 ? 2 : 1; return; }
      if (o instanceof Float) { d.append("fl ", 2); quoteToPrintWriter(str(o), out); return; }
      if (o instanceof Double) { d.append("d(", 3); quoteToPrintWriter(str(o), out); d.append(")"); return; }
      if (o instanceof BigInteger) { out.print("bigint("); out.print(o); out.print(")"); d.n += ((BigInteger) o).signum() < 0 ? 5 : 4; return; }
    }
  
    if (o instanceof Boolean) {
      d.append(((Boolean) o).booleanValue() ? "t" : "f"); return;
    }
      
    if (o instanceof Character) {
      d.append(quoteCharacter((Character) o)); return;
    }
      
    if (o instanceof File) {
      d.append("File ").append(quote(((File) o).getPath())); return;
    }
      
    // referencable objects follow
    
    Integer ref = d.seen.get(o);
    if (o instanceof String && ref == null)
      ref = d.strings.get((String) o);
      
    if (ref != null) {
      d.refd.set(ref);
      d.append("t").app(ref); return;
    }
    
    ref = d.n; //d.seen.size()+1;
    d.seen.put(o, ref);
    //d.append("m").app(ref).app(" "); // marker
    
    if (o instanceof String) {
      String s = d.stringSizeLimit != 0 ? shorten((String) o, d.stringSizeLimit) : (String) o;
      if (l(s) >= structure_shareStringsLongerThan)
        d.strings.put(s, ref);
      quoteToPrintWriter(s, out); d.n++; return;
    }
      
    if (o instanceof HashSet) {
      d.append("hashset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
  
    if (o instanceof TreeSet) {
      d.append("treeset ");
      structure_1(new ArrayList((Set) o), d);
      return;
    }
    
    if (o instanceof Collection && neq(name, "main$Concept$RefL")) {
      d.append("[");
      final int l = d.n;
      final Iterator it = ((Collection) o).iterator();
      d.stack.add(new Runnable() { public void run() { try { 
        if (!it.hasNext())
          d.append("]");
        else {
          d.stack.add(this);
          if (d.n != l) d.append(", ");
          structure_1(it.next(), d);
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n          d.append(\"]\");\r\n        else {\r\n          d.stack...."; }});
      return;
    }
    
    if (o instanceof Map) {
      if (o instanceof LinkedHashMap) d.append("lhm");
      else if (o instanceof HashMap) d.append("hm");
      d.append("{");
      final int l = d.n;
      final Iterator it = ((Map) o).entrySet().iterator();
      
      d.stack.add(new Runnable() {
        boolean v;
        Map.Entry e;
        
        public void run() {
          if (v) {
            d.append("=");
            v = false;
            d.stack.add(this);
            structure_1(e.getValue(), d);
          } else {
            if (!it.hasNext())
              d.append("}");
            else {
              e = (Map.Entry) it.next();
              v = true;
              d.stack.add(this);
              if (d.n != l) d.append(", ");
              structure_1(e.getKey(), d);
            }
          }
        }
      });
      return;
    }
    
    if (c.isArray()) {
      if (o instanceof byte[]) {
        d.append("ba ").append(quote(bytesToHex((byte[]) o))); return;
      }
  
      final int n = Array.getLength(o);
  
      if (o instanceof boolean[]) {
        String hex = boolArrayToHex((boolean[]) o);
        int i = l(hex);
        while (i > 0 && hex.charAt(i-1) == '0' && hex.charAt(i-2) == '0') i -= 2;
        d.append("boolarray ").append(n).app(" ").append(quote(substring(hex, 0, i))); return;
      }
      
      String atype = "array", sep = ", ";
  
      if (o instanceof int[]) {
        //ret "intarray " + quote(intArrayToHex((int[]) o));
        atype = "intarray";
        sep = " ";
      }
      
      d.append(atype).append("{");
      d.stack.add(new Runnable() {
        int i;
        public void run() {
          if (i >= n)
            d.append("}");
          else {
            d.stack.add(this);
            if (i > 0) d.append(", ");
            structure_1(Array.get(o, i++), d);
          }
        }
      });
      return;
    }
  
    if (o instanceof Class) {
      d.append("class(", 2).append(quote(((Class) o).getName())).append(")"); return;
    }
      
    if (o instanceof Throwable) {
      d.append("exception(", 2).append(quote(((Throwable) o).getMessage())).append(")"); return;
    }
      
    if (o instanceof BitSet) {
      BitSet bs = (BitSet) o;
      d.append("bitset{", 2);
      int l = d.n;
      for (int i = bs.nextSetBit(0); i >= 0; i = bs.nextSetBit(i+1)) {
        if (d.n != l) d.append(", ");
        d.append(i);
      }
      d.append("}"); return;
    }
      
    // Need more cases? This should cover all library classes...
    if (name.startsWith("java.") || name.startsWith("javax.")) {
      d.append("j ").append(quote(str(o))); return; // Hm. this is not unstructure-able
    }
    
    
      if (o instanceof Lisp) {
        d.append("l(", 2);
        final Lisp lisp = (Lisp) ( o);
        structure_1(lisp.head, d);
        final Iterator it = lisp.args.iterator();
        d.stack.add(new Runnable() { public void run() { try { 
          if (!it.hasNext())
            d.append(")");
          else {
            d.stack.add(this);
            d.append(", ");
            structure_1(it.next(), d);
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext())\r\n            d.append(\")\");\r\n          else {\r\n            d...."; }});
        return;
      }
    
      
    /*if (name.equals("main$Lisp")) {
      fail("lisp not supported right now");
    }*/
    
    if (concept && !d.concepts.contains(dynName)) {
      d.concepts.add(dynName);
      d.append("c ");
    }
    
    // serialize an object with fields.
    // first, collect all fields and values in fv.
    
    TreeSet<Field> fields = new TreeSet<Field>(new Comparator<Field>() {
      public int compare(Field a, Field b) {
        return stdcompare(a.getName(), b.getName());
      }
    });
    
    while (c != Object.class) {
      for (Field field : getDeclaredFields_cached(c)) {
        if ((field.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) != 0)
          continue;
        String fieldName = field.getName();
        
        fields.add(field);
        
        // put special cases here...
      }
        
      c = c.getSuperclass();
    }
    
    lFields = asList(fields);
    
    // Render this$1 first because unstructure needs it for constructor call.
    
    for (int i = 0; i < l(lFields); i++) {
      Field f = lFields.get(i);
      if (f.getName().equals("this$1")) {
        lFields.remove(i);
        lFields.add(0, f);
        break;
      }
    }
  
    d.fieldsByClass.put(c, lFields);
  }

  LinkedHashMap<String,Object> fv = new LinkedHashMap();
  for (Field f : lFields) {
    Object value;
    try {
      value = f.get(o);
    } catch (Exception e) {
      value = "?";
    }
      
    if (value != null)
      fv.put(f.getName(), value);
  }
  
  String shortName = dropPrefix("main$", name);
    
  // Now we have fields & values. Process fieldValues if it's a DynamicObject.
  
  // omit field "className" if equal to class's name
  if (concept && eq(fv.get("className"), shortName))
    fv.remove("className");
          
  if (o instanceof DynamicObject) {
    fv.putAll((Map) fv.get("fieldValues"));
    fv.remove("fieldValues");
    shortName = dynName;
    fv.remove("className");
  }
  
  String singleField = fv.size() == 1 ? first(fv.keySet()) : null;
  
  d.append(shortName);

  final int l = d.n;
  final Iterator it = fv.entrySet().iterator();
  
  d.stack.add(new Runnable() { public void run() { try { 
    if (!it.hasNext()) {
      if (d.n != l)
        d.append(")");
    } else {
      Map.Entry e = (Map.Entry) it.next();
      d.append(d.n == l ? "(" : ", ");
      d.append((String) e.getKey()).append("=");
      d.stack.add(this);
      structure_1(e.getValue(), d);
    }
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (!it.hasNext()) {\r\n      if (d.n != l)\r\n        d.append(\")\");\r\n    } else {\r..."; }});
}

// does not store null values
static Map indexByField(Collection c, String field) {
  HashMap map = new HashMap();
  for (Object a : c) {
    Object val = getOpt(a, field);
    if (val != null)
      map.put(val, a);
  }
  return map;
}
static Field setOpt_findField(Class c, String field) {
  HashMap<String, Field> map;
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  return map.get(field);
}

static void setOpt(Object o, String field, Object value) { try {
  if (o == null) return;
  
  Class c = o.getClass();
  HashMap<String, Field> map;
  
  synchronized(getOpt_cache) {
    map = getOpt_cache.get(c);
    if (map == null)
      map = getOpt_makeCache(c);
  }
  
  if (map == getOpt_special) {
    if (o instanceof Class) {
      setOpt((Class) o, field, value);
      return;
    }
    return;
  }
  
  Field f = map.get(field);
  if (f != null)
    smartSet(f, o, value); // possible improvement: skip setAccessible
} catch (Exception __e) { throw rethrow(__e); } }

static void setOpt(Class c, String field, Object value) {
  if (c == null) return;
  try {
    Field f = setOpt_findStaticField(c, field);
    if (f != null)
      smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field setOpt_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static Map synchroHashMap() {
  return Collections.synchronizedMap(new HashMap());
}

static int isAndroid_flag;

static boolean isAndroid() {
  if (isAndroid_flag == 0)
    isAndroid_flag = System.getProperty("java.vendor").toLowerCase().indexOf("android") >= 0 ? 1 : -1;
  return isAndroid_flag > 0;
}

static String dumpConcepts2(List<AIConcept> concepts) {
  List<String> l = new ArrayList();
  for (AIConcept c : concepts) {
    List x = ll(c.globalID, c.name);
    addIfNempty(x, c.comment);
    l.add("  " + struct(x));
  }
  return print("[[\n" + join(",\n", l) + "\n]]");
}


static String aGlobalID() {
  return randomID(16);
}
static long done2_always(long startTime, String desc) {
  long time = sysNow()-startTime;
  print(desc + " [" + time + " ms]");
  return time;
}

static long done2_always(String desc, long startTime) {
  return done2_always(startTime, desc);
}

static long done2_always(long startTime) {
  return done2_always(startTime, "");
}
static boolean neqic(String a, String b) {
  return !eqic(a, b);
}
static <A> List<A> reverseList(List<A> l) {
  Collections.reverse(l);
  return l;
}
static String quote(Object o) {
  if (o == null) return "null";
  return quote(str(o));
}

static String quote(String s) {
  if (s == null) return "null";
  StringBuilder out = new StringBuilder();
  quote_impl(s, out);
  return out.toString();
}
  
static void quote_impl(String s, StringBuilder out) {
  out.append('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"')
      out.append('\\').append(c);
    else if (c == '\r')
      out.append("\\r");
    else if (c == '\n')
      out.append("\\n");
    else
      out.append(c);
  }
  out.append('"');
}
static Cache<Map<String, AIConcept>> aiConceptsMap_cached_cache = new Cache("aiConceptsMap");
static double aiConceptsMap_cached_autoClearInterval = 30;

static Map<String, AIConcept> aiConceptsMap_cached() {
  aiConceptsMap_cached_cache.clear(aiConceptsMap_cached_autoClearInterval);
  return aiConceptsMap_cached_cache.get();
}

static void aiConceptsMap_clearCache() {
  aiConceptsMap_cached_cache.clear();
}

// clear cache if older than x seconds
static void aiConceptsMap_clearCache(double seconds) {
  aiConceptsMap_cached_cache.clear(seconds);
}
static String quoteCharacter(char c) {
  if (c == '\'') return "'\\''";
  if (c == '\\') return "'\\\\'";
  return "'" + c + "'";
}

static <A> List<A> dropFirstAndLast(int n, List<A> l) {
  return new ArrayList(subList(l, n, l(l)-n));
}

static String dropFirstAndLast(String s) {
  return substring(s, 1, l(s)-1);
}
static String shortDynamicClassName(Object o) {
 if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return ((DynamicObject) o).className;
  return shortClassName(o);
}
static boolean contains(Collection c, Object o) {
  return c != null && c.contains(o);
}

static boolean contains(Object[] x, Object o) {
  if (x != null)
    for (Object a : x)
      if (eq(a, o))
        return true;
  return false;
}

static boolean contains(String s, char c) {
  return s != null && s.indexOf(c) >= 0;
}

static boolean contains(String s, String b) {
  return s != null && s.indexOf(b) >= 0;
}
static List<AIConcept> fastLoadAIConcepts() {
  print("fast-loading ai concepts");
  Class main = getBotMainClass(dbBotName(aiConceptsProgram()));
  Object concepts = get(main, "mainConcepts");
  return map("fastLoadAIConcept", (List) call(concepts, "list", "AIConcept"));
}
// TODO: returns empty first, but not empty last
static List<String> splitAt(String s, String splitter) {
  List<String> parts = new ArrayList();
  int i = 0;
  if (s != null)
    while (i < l(s)) {
      int j = indexOf(s, splitter, i);
      if (j < 0) j = l(s);
      parts.add(substring(s, i, j));
      i = j+l(splitter);
    }
  return parts;
}
static int min(int a, int b) {
  return Math.min(a, b);
}

static long min(long a, long b) {
  return Math.min(a, b);
}

static float min(float a, float b) { return Math.min(a, b); }
static float min(float a, float b, float c) { return min(min(a, b), c); }

static double min(double a, double b) {
  return Math.min(a, b);
}

static double min(double[] c) {
  double x = Double.MAX_VALUE;
  for (double d : c) x = Math.min(x, d);
  return x;
}

static float min(float[] c) {
  float x = Float.MAX_VALUE;
  for (float d : c) x = Math.min(x, d);
  return x;
}

static byte min(byte[] c) {
  byte x = 127;
  for (byte d : c) if (d < x) x = d;
  return x;
}

static short min(short[] c) {
  short x = 0x7FFF;
  for (short d : c) if (d < x) x = d;
  return x;
}
static List collectField(Collection c, String field) {
  List l = new ArrayList();
  for (Object a : c)
    l.add(getOpt(a, field));
  return l;
}
static String[] toStringArray(Collection<String> c) {
  String[] a = new String[l(c)];
  Iterator<String> it = c.iterator();
  for (int i = 0; i < l(a); i++)
    a[i] = it.next();
  return a;
}

static String[] toStringArray(Object o) {
  if (o instanceof String[])
    return (String[]) o;
  else if (o instanceof Collection)
    return toStringArray((Collection<String>) o);
  else
    throw fail("Not a collection or array: " + getClassName(o));
}

static HashMap<Class, Field[]> getDeclaredFields_cache = new HashMap();

static Field[] getDeclaredFields_cached(Class c) {
  Field[] fields;
  synchronized(getDeclaredFields_cache) {
    fields = getDeclaredFields_cache.get(c);
    if (fields == null) {
      getDeclaredFields_cache.put(c, fields = c.getDeclaredFields());
      for (Field f : fields)
        f.setAccessible(true);
    }
  }
  return fields;
}
static String boolArrayToHex(boolean[] a) {
  return bytesToHex(boolArrayToBytes(a));
}
static Class<?> _getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class _getClass(Object o) {
  return o == null ? null
    : o instanceof Class ? (Class) o : o.getClass();
}

static Class _getClass(Object realm, String name) { try {
  return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
} catch (Exception __e) { throw rethrow(__e); } }
static String joinLines(List<String> lines) {
  return fromLines(lines);
}

static String joinLines(String glue, String text) {
  return join(glue, toLines(text));
}
static List<AIConcept> aiConceptsByAge() {
  return sortByCalculatedFieldDesc(values(aiConceptsMap_cached()),
    new Object() { Object get(AIConcept c) { try { return  max(c.touched, c.created) ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "max(c.touched, c.created)"; }});
}
  public static String bytesToHex(byte[] bytes) {
    return bytesToHex(bytes, 0, bytes.length);
  }

  public static String bytesToHex(byte[] bytes, int ofs, int len) {
    StringBuilder stringBuilder = new StringBuilder(len*2);
    for (int i = 0; i < len; i++) {
      String s = "0" + Integer.toHexString(bytes[ofs+i]);
      stringBuilder.append(s.substring(s.length()-2, s.length()));
    }
    return stringBuilder.toString();
  }

// make concept instance that is not connected to DB
static <A extends Concept> A unlisted(Class<A> c, Object... args) {
  concepts_unlisted.set(true);
  try {
    return nuObject(c, args);
  } finally {
    concepts_unlisted.set(null);
  }
}
static <A> void addIfNotNull(Collection<A> l, A a) {
  if (a != null)
    l.add(a);
}
static boolean nempty(Collection c) {
  return !isEmpty(c);
}

static boolean nempty(CharSequence s) {
  return !isEmpty(s);
}

static boolean nempty(Object[] o) {
  return !isEmpty(o);
}

static boolean nempty(Map m) {
  return !isEmpty(m);
}

static boolean nempty(Iterator i) {
  return i != null && i.hasNext();
}
static boolean containsIgnoreCase(List<String> l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String[] l, String s) {
  for (String x : l)
    if (eqic(x, s))
      return true;
  return false;
}

static boolean containsIgnoreCase(String s, char c) {
  return indexOfIgnoreCase(s, String.valueOf(c)) >= 0;
}

static boolean containsIgnoreCase(String a, String b) {
  return indexOfIgnoreCase(a, b) >= 0;
}
static <A> A popLast(List<A> l) {
  return liftLast(l);
}
static <A> List<Integer> indexesOf(List<A> l, A a) {
  List<Integer> x = new ArrayList();
  for (int i = 0; i < l(l); i++)
    if (eq(l.get(i), a))
      x.add(i);
  return x;
}
static String shorten(String s, int max) {
  if (s == null) return "";
  if (max < 0) return s;
  return s.length() <= max ? s : s.substring(0, Math.min(s.length(), max)) + "...";
}

static String shorten(int max, String s) { return shorten(s, max); }
static TreeSet collectTreeSet(Collection c, String field) {
  TreeSet set = new TreeSet();
  for (Object a : c) {
    Object val = getOpt(a, field);
    if (val != null)
      set.add(val);
  }
  return set;
}
static String dropPrefix(String prefix, String s) {
  return s.startsWith(prefix) ? s.substring(l(prefix)) : s;
}
static WeakAssoc<List<Statement>, Map<String, LispStatement>> lispStatements_cache = new WeakAssoc("statementsToLisp");

static Map<String, LispStatement> lispStatements_cached() {
  return lispStatements_cache.get(loadTruth_cached());
}
static void aiEnhancements() {
  conceptLanguageToolTips();
}
static HashMap<String,Class> findClass_cache = new HashMap();

// currently finds only inner classes of class "main"
// returns null on not found
// this is the simple version that is not case-tolerant
static Class findClass(String name) {
  synchronized(findClass_cache) {
    if (findClass_cache.containsKey(name))
      return findClass_cache.get(name);
      
    if (!isJavaIdentifier(name)) return null;
    
    Class c;
    try {
      c = Class.forName("main$" + name);
    } catch (ClassNotFoundException e) {
      c = null;
    }
    findClass_cache.put(name, c);
    return c;
  }
}
static Object safeUnstructure(String s) {
  return unstructure(s, true);
}
static boolean isSubtypeOf(Class a, Class b) {
  return b.isAssignableFrom(a); // << always hated that method, let's replace it!
}
static void addIfNempty(Collection<String> l, String s) {
  if (nempty(s)) l.add(s);
}

static void addIfNempty(Collection l, Map m) {
  if (nempty(m)) l.add(m);
}
static int cmp(Number a, Number b) {
  return a == null ? b == null ? 0 : -1 : cmp(a.doubleValue(), b.doubleValue());
}

static int cmp(double a, double b) {
  return a < b ? -1 : a == b ? 0 : 1;
}

static int cmp(String a, String b) {
  return a == null ? b == null ? 0 : -1 : a.compareTo(b);
}

static int cmp(Object a, Object b) {
  if (a == null) return b == null ? 0 : -1;
  if (b == null) return 1;
  return ((Comparable) a).compareTo(b);
}
static <A> ArrayList<A> litlist(A... a) {
  return new ArrayList<A>(Arrays.asList(a));
}
static Set asSet(Object[] array) {
  HashSet set = new HashSet();
  for (Object o : array)
    if (o != null)
      set.add(o);
  return set;
}

static Set<String> asSet(String[] array) {
  TreeSet<String> set = new TreeSet();
  for (String o : array)
    if (o != null)
      set.add(o);
  return set;
}

static <A> Set<A> asSet(Collection<A> l) {
  if (l instanceof Set) return (Set) l;
  HashSet<A> set = new HashSet();
  for (A o : l)
    if (o != null)
      set.add(o);
  return set;
}
static List<String> codeTokens(List<String> tok) {
  return codeTokensOnly(tok);
}
static <A> A assertEquals(Object x, A y) {
  return assertEquals(null, x, y);
}

static <A> A assertEquals(String msg, Object x, A y) {
  if (!(x == null ? y == null : x.equals(y)))
    throw fail((msg != null ? msg + ": " : "") + y + " != " + x);
  return y;
}
static <A> List<A> ll(A... a) {
  return litlist(a);
}
// not including <> as they are ambiguous (< is also a comparison operator)
static String testBracketHygiene_op    = "([{";
static String testBracketHygiene_close = ")]}";

static boolean testBracketHygiene(String s) {
  return testBracketHygiene(s, testBracketHygiene_op, testBracketHygiene_close, null);
}

static boolean testBracketHygiene(String s, Var<String> msg) {
  return testBracketHygiene(s, testBracketHygiene_op, testBracketHygiene_close, msg);
}

static boolean testBracketHygiene(String s, String op, String close, Var<String> msg) {
  List<String> tok = javaTok(s);
  Map<Integer,Integer> map = new HashMap();
  List<Integer> stack = getBracketMap2(tok, map, op, close);
  if (nempty(stack)) {
    if (msg != null)
      msg.set("Bad hygiene - " + n(l(stack), "bracket") + " not closed");
    return false;
  }
  
  if (map.containsKey(0)) {
    if (msg != null)
      msg.set("Bad hygiene - bracket not opened (" + quote(tok.get(map.get(0))) + ")");
    return false;
  }
  
  for (int i : keys(map)) {
    int j = map.get(i);
    String a = tok.get(i), b = tok.get(j);
    int ai = op.indexOf(a), bi = close.indexOf(b);
    if (ai != bi) {
      if (msg != null)
        msg.set("Bad hygiene - brackets don't match (" + quote(a) + " vs " + quote(b) + ")");
      return false;
    }
  }
  
  if (msg != null)
    msg.set("Hygiene OK!");
  return true;
}
static void quoteToPrintWriter(String s, PrintWriter out) {
  if (s == null) { out.print("null"); return; }
  out.print('"');
  int l = s.length();
  for (int i = 0; i < l; i++) {
    char c = s.charAt(i);
    if (c == '\\' || c == '"') {
      out.print('\\'); out.print(c);
    } else if (c == '\r')
      out.print("\\r");
    else if (c == '\n')
      out.print("\\n");
    else
      out.print(c);
  }
  out.print('"');
}
static boolean eqOneOf(Object o, Object... l) {
  for (Object x : l) if (eq(o, x)) return true; return false;
}
static long sysDone(long startTime, String desc) {
  return done2(startTime, desc);
}

static long sysDone(String desc, long startTime) {
  return done2(desc, startTime);
}

static long sysDone(long startTime) {
  return done2(startTime);
}
static String substring(String s, int x) {
  return substring(s, x, l(s));
}

static String substring(String s, int x, int y) {
  if (s == null) return null;
  if (x < 0) x = 0;
  if (x > s.length()) return "";
  if (y < x) y = x;
  if (y > s.length()) y = s.length();
  return s.substring(x, y);
}
static String assertIdentifier(String s) {
  return assertIsIdentifier(s);
}
static long sysNow() {
  return System.nanoTime()/1000000;
}
static List<String> listToCL(List<String> l) {
  return map("englishToConceptLanguage", l);
}

// mainJava is a complete program, but without the !752/!759 at the top
// returns link to main class
static Class veryQuickJava(String mainJava) {
  return veryQuickJava3(mainJava); // Latest version with internal compiler bot.
}
static String makeNewID(String id) {
  return empty(id) || eq(id, "?") ? aGlobalID() : id;
}
static void smartSet(Field f, Object o, Object value) throws Exception {
  f.setAccessible(true);
  
  // take care of common case (long to int)
  if (f.getType() == int.class && value instanceof Long)
    value = ((Long) value).intValue();
    
  try {
    f.set(o, value);
  } catch (Exception e) {
    
      try {
        if (f.getType() == Concept.Ref.class) {
          f.set(o, ((Concept) o).new Ref((Concept) value));
          return;
        }
        if (o instanceof Concept.Ref) {
          f.set(o, ((Concept.Ref) o).get());
          return;
        }
      } catch (Throwable _e) {}
    
    throw e;
  }
}
static List<String> joinBrackets(List<String> tok) {
  List<String> t = new ArrayList();
  Map<Integer, Integer> map = getBracketMap(tok);
  for (int i = 0; i < l(tok); i++) {
    Integer dest = map.get(i);
    if (dest != null) {
      t.add(join(subList(tok, i, dest+1)));
      i = dest;
    } else
      t.add(tok.get(i));
  }
  return t;
}
static boolean loadAIConcepts_alwaysFromDisk;

static List<AIConcept> loadAIConcepts() {
  Concepts c = new Concepts("#1006463");
  if (loadAIConcepts_alwaysFromDisk) c.loadFromDisk(); else c.load();
  return list(c, AIConcept.class);
}
static int charDiff(char a, char b) {
  return (int) a-(int) b;
}
static int stdcompare(Number a, Number b) {
  return cmp(a, b);
}

static int stdcompare(String a, String b) {
  return cmp(a, b);
}

static int stdcompare(long a, long b) {
  return a < b ? -1 : a > b ? 1 : 0;
}

static int stdcompare(Object a, Object b) {
  return cmp(a, b);
}



static <A> A liftLast(List<A> l) {
  if (l.isEmpty()) return null;
  int i = l(l)-1;
  A a = l.get(i);
  l.remove(i);
  return a;
}
static Object unstructure(String text) {
  return unstructure(text, false);
}

static Object unstructure(String text, final boolean allDynamic) {
  return unstructure(text, allDynamic, null);
}

static int structure_internStringsLongerThan = 50;

static int unstructure_tokrefs; // stats

abstract static class unstructure_Receiver {
  abstract void set(Object o);
}

// classFinder: func(name) -> class (optional)
static Object unstructure(String text, boolean allDynamic,
  Object classFinder) {
  if (text == null) return null;
  return unstructure_tok(javaTokC_iterator(text), allDynamic, classFinder);
}

static Object unstructure_reader(BufferedReader reader) {
  return unstructure_tok(javaTokC_onReader(reader), false, null);
}

static Object unstructure_tok(final Producer<String> tok, final boolean allDynamic, final Object classFinder) {
  final boolean debug = unstructure_debug;
  
  final class X {
    int i = -1;
    HashMap<Integer,Object> refs = new HashMap();
    HashMap<Integer,Object> tokrefs = new HashMap();
    HashSet<String> concepts = new HashSet();
    HashMap<String,Class> classesMap = new HashMap();
    List<Runnable> stack = new ArrayList();
    String curT;
    
    // look at current token
    String t() {
      return curT;
    }
    
    // get current token, move to next
    String tpp() {
      String t = curT;
      consume();
      return t;
    }
    
    void parse(final unstructure_Receiver out) {
      String t = t();
      
      int refID = 0;
      if (structure_isMarker(t, 0, l(t))) {
        refID = parseInt(t.substring(1));
        consume();
      }
      final int _refID = refID;
      
      // if (debug) print("parse: " + quote(t));
      
      final int tokIndex = i;  
      parse_inner(refID, tokIndex, new unstructure_Receiver() {
        void set(Object o) {
          if (_refID != 0)
            refs.put(_refID, o);
          if (o != null)
            tokrefs.put(tokIndex, o);
          out.set(o);
        }
      });
    }
    
    void parse_inner(int refID, int tokIndex, final unstructure_Receiver out) {
      String t = t();
      
      // if (debug) print("parse_inner: " + quote(t));
      
      Class c = classesMap.get(t);
      if (c == null) {
        if (t.startsWith("\"")) {
          String s = internIfLongerThan(unquote(tpp()), structure_internStringsLongerThan);
          out.set(s); return;
        }
        
        if (t.startsWith("'")) {
          out.set(unquoteCharacter(tpp())); return;
        }
        if (t.equals("bigint")) {
          out.set(parseBigInt()); return;
        }
        if (t.equals("d")) {
          out.set(parseDouble()); return;
        }
        if (t.equals("fl")) {
          out.set(parseFloat()); return;
        }
        if (t.equals("false") || t.equals("f")) {
          consume(); out.set(false); return;
        }
        if (t.equals("true") || t.equals("t")) {
          consume(); out.set(true); return;
        }
        if (t.equals("-")) {
          consume();
          t = tpp();
          out.set(isLongConstant(t) ? (Object) (-parseLong(t)) : (Object) (-parseInt(t))); return;
        }
        if (isInteger(t) || isLongConstant(t)) {
          consume();
          //if (debug) print("isLongConstant " + quote(t) + " => " + isLongConstant(t));
          if (isLongConstant(t)) {
            out.set(parseLong(t)); return;
          }
          long l = parseLong(t);
          boolean isInt = l == (int) l;
          if (debug)
            print("l=" + l + ", isInt: " + isInt);
          out.set(isInt ? (Object) new Integer((int) l) : (Object) new Long(l)); return;
        }
        
        if (t.equals("File")) {
          consume();
          File f = new File(unquote(tpp()));
          out.set(f); return;
        }
        
        if (t.startsWith("r") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = refs.get(ref);
          if (o == null)
            print("Warning: unsatisfied back reference " + ref);
          out.set(o); return;
        }
      
        if (t.startsWith("t") && isInteger(t.substring(1))) {
          consume();
          int ref = Integer.parseInt(t.substring(1));
          Object o = tokrefs.get(ref);
          if (o == null)
            print("Warning: unsatisfied token reference " + ref);
          out.set(o); return;
        }
        
        if (t.equals("hashset")) {
          parseHashSet(out); return;
        }
        if (t.equals("treeset")) {
          parseTreeSet(out); return;
        }
        if (eqOneOf(t, "hashmap", "hm")) {
          consume();
          parseMap(new HashMap(), out);
          return;
        }
        if (t.equals("lhm")) {
          consume();
          parseMap(new LinkedHashMap(), out);
          return;
        }
        if (t.equals("{")) {
          parseMap(out); return;
        }
        if (t.equals("[")) {
          parseList(out); return;
        }
        if (t.equals("bitset")) {
          parseBitSet(out); return;
        }
        if (t.equals("array") || t.equals("intarray")) {
          parseArray(out); return;
        }
        if (t.equals("ba")) {
          consume();
          String hex = unquote(tpp());
          out.set(hexToBytes(hex)); return;
        }
        if (t.equals("boolarray")) {
          consume();
          int n = parseInt(tpp());
          String hex = unquote(tpp());
          out.set(boolArrayFromBytes(hexToBytes(hex), n)); return;
        }
        if (t.equals("class")) {
          out.set(parseClass()); return;
        }
        if (t.equals("l")) {
          parseLisp(out); return;
        }
        if (t.equals("null")) {
          consume(); out.set(null); return;
        }
        
        if (eq(t, "c")) {
          consume("c");
          t = t();
          assertTrue(isJavaIdentifier(t));
          concepts.add(t);
        }
      }
      
      if (eq(t, "j")) {
        consume("j");
        out.set(parseJava()); return;
      }

      if (c == null && !isJavaIdentifier(t))
        throw new RuntimeException("Unknown token " + (i+1) + ": " + t);
        
      // any other class name
      if (c == null) {
        // First, find class
        if (allDynamic) c = null;
        else c = classFinder != null ? (Class) callF(classFinder, t) : findClass(t);
        if (c != null)
          classesMap.put(t, c);
      }
          
      // Check if it has an outer reference
      consume();
      boolean hasBracket = eq(t(), "(");
      if (hasBracket) consume();
      boolean hasOuter = hasBracket && eq(t(), "this$1");
      
      DynamicObject dO = null;
      Object o = null;
      if (c != null)
        o = hasOuter ? nuStubInnerObject(c) : nuEmptyObject(c);
      else {
        if (concepts.contains(t) && (c = findClass("Concept")) != null)
          o = dO = (DynamicObject) nuEmptyObject(c);
        else
          dO = new DynamicObject();
        dO.className = t;
        if (debug) print("Made dynamic object " + t + " " + shortClassName(dO));
      }
      
      // Save in references list early because contents of object
      // might link back to main object
      
      if (refID != 0)
        refs.put(refID, o != null ? o : dO);
      tokrefs.put(tokIndex, o != null ? o : dO);
      
      // NOW parse the fields!
      
      final LinkedHashMap<String,Object> fields = new LinkedHashMap(); // preserve order
      final Object _o = o;
      final DynamicObject _dO = dO;
      if (hasBracket) {
        stack.add(new Runnable() { public void run() { try { 
          if (eq(t(), ")")) {
            consume(")");
            objRead(_o, _dO, fields);
            out.set(_o != null ? _o : _dO);
          } else {
            final String key = unquote(tpp());
            consume("=");
            stack.add(this);
            parse(new unstructure_Receiver() {
              void set(Object value) {
                fields.put(key, value);
                if (eq(t(), ",")) consume();
              }
            });
          }
        
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n            consume(\")\");\r\n            objRead(_o, _dO, fie..."; }});
      } else {
        objRead(o, dO, fields);
        out.set(o != null ? o : dO);
      }
    }
    
    void objRead(Object o, DynamicObject dO, Map<String, Object> fields) {
      if (o != null)
        if (dO != null) {
          if (debug)
            printStructure("setOptAllDyn", fields);
          setOptAllDyn(dO, fields);
        } else
          setOptAll(o, fields);
      else for (String field : keys(fields))
        dO.fieldValues.put(field.intern(), fields.get(field));

      if (o != null)
        pcallOpt_noArgs(o, "_doneLoading");
    }
    
    void parseSet(final Set set, final unstructure_Receiver out) {
      parseList(new unstructure_Receiver() {
        void set(Object o) {
          set.addAll((List) o);
          out.set(set);
        }
      });
    }
    
    void parseLisp(final unstructure_Receiver out) {
      consume("l");
      consume("(");
      final ArrayList list = new ArrayList();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), ")")) {
          consume(")");
          out.set(newObject("main$Lisp", (String) list.get(0), subList(list, 1)));
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \")\")) {\r\n          consume(\")\");\r\n          out.set(newObject(\"main$..."; }});
    }
    
    void parseBitSet(final unstructure_Receiver out) {
      consume("bitset");
      consume("{");
      final BitSet bs = new BitSet();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(bs);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              bs.set((Integer) o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(bs);\r\n        } ..."; }});
    }
    
    void parseList(final unstructure_Receiver out) {
      consume("[");
      final ArrayList list = new ArrayList();
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "]")) {
          consume("]");
          out.set(list);
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              //if (debug) print("List element type: " + getClassName(o));
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"]\")) {\r\n          consume(\"]\");\r\n          out.set(list);\r\n        ..."; }});
    }
    
    void parseArray(final unstructure_Receiver out) {
      final String type = tpp();
      consume("{");
      final List list = new ArrayList();
      
      stack.add(new Runnable() { public void run() { try { 
        if (eq(t(), "}")) {
          consume("}");
          out.set(type.equals("intarray") ? toIntArray(list) : list.toArray());
        } else {
          stack.add(this);
          parse(new unstructure_Receiver() {
            void set(Object o) {
              list.add(o);
              if (eq(t(), ",")) consume();
            }
          });
        }
      
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (eq(t(), \"}\")) {\r\n          consume(\"}\");\r\n          out.set(type.equals(\"int..."; }});
    }
    
    Object parseClass() {
      consume("class");
      consume("(");
      String name = unquote(tpp());
      consume(")");
      name = dropPrefix("main$", name);
      Class c = allDynamic ? null : classFinder != null ? (Class) callF(classFinder, name) : findClass(name);
      if (c != null) return c;
      DynamicObject dO = new DynamicObject();
      dO.className = "java.lang.Class";
      dO.fieldValues.put("name", name);
      return dO;
    }
    
    Object parseBigInt() {
      consume("bigint");
      consume("(");
      String val = tpp();
      if (eq(val, "-"))
        val = "-" + tpp();
      consume(")");
      return new BigInteger(val);
    }
    
    Object parseDouble() {
      consume("d");
      consume("(");
      String val = unquote(tpp());
      consume(")");
      return Double.parseDouble(val);
    }
    
    Object parseFloat() {
      consume("fl");
      String val;
      if (eq(t(), "(")) {
        consume("(");
        val = unquote(tpp());
        consume(")");
      } else {
        val = unquote(tpp());
      }
      return Float.parseFloat(val);
    }
    
    void parseHashSet(unstructure_Receiver out) {
      consume("hashset");
      parseSet(new HashSet(), out);
    }
    
    void parseTreeSet(unstructure_Receiver out) {
      consume("treeset");
      parseSet(new TreeSet(), out);
    }
    
    void parseMap(unstructure_Receiver out) {
      parseMap(new TreeMap(), out);
    }
    
    Object parseJava() {
      String j = unquote(tpp());
      Matches m = new Matches();
      if (jmatch("java.awt.Color[r=*,g=*,b=*]", j, m))
        return nuObject("java.awt.Color", parseInt(m.unq(0)), parseInt(m.unq(1)), parseInt(m.unq(2)));
      else throw fail("Unknown Java object: " + j);
    }
    
    void parseMap(final Map map, final unstructure_Receiver out) {
      consume("{");
      stack.add(new Runnable() {
        boolean v;
        Object key;
        
        public void run() { 
          if (v) {
            v = false;
            stack.add(this);
            consume("=");
            parse(new unstructure_Receiver() {
              void set(Object value) {
                map.put(key, value);
                if (debug)
                  print("parseMap: Got value " + getClassName(value) + ", next token: " + quote(t()));
                if (eq(t(), ",")) consume();
              }
            });
          } else {
            if (eq(t(), "}")) {
              consume("}");
              out.set(map);
            } else {
              v = true;
              stack.add(this);
              parse(new unstructure_Receiver() {
                void set(Object o) {
                  key = o;
                }
              });
            }
          } // if v else
        } // run()
      });
    }
    
    /*void parseSub(unstructure_Receiver out) {
      int n = l(stack);
      parse(out);
      while (l(stack) > n)
        stack
    }*/
    
    void consume() { curT = tok.next(); ++i; }
    
    void consume(String s) {
      if (!eq(t(), s)) {
        /*S prevToken = i-1 >= 0 ? tok.get(i-1) : "";
        S nextTokens = join(tok.subList(i, Math.min(i+2, tok.size())));
        fail(quote(s) + " expected: " + prevToken + " " + nextTokens + " (" + i + "/" + tok.size() + ")");*/
        throw fail(quote(s) + " expected, got " + quote(t()));
      }
      consume();
    }
    
    void parse_x(unstructure_Receiver out) {
      consume(); // get first token
      parse(out);
      while (nempty(stack))
        popLast(stack).run();
    }
  }
  
  final Var v = new Var();
  X x = new X();
  x.parse_x(new unstructure_Receiver() {
    void set(Object o) { v.set(o); }
  });
  unstructure_tokrefs = x.tokrefs.size();
  return v.get();
}

static boolean unstructure_debug;
static String n(long l, String name) {
  return l + " " + (l == 1 ? singular(name) : getPlural(name));
}

static String n(Collection l, String name) {
  return n(l(l), name);
}

static String n(Map m, String name) {
  return n(l(m), name);
}

static String n(Object[] a, String name) {
  return n(l(a), name);
}


static String aiConceptsProgram() {
  return "#1006463";
}
static String classNameToVM(String name) {
  return name.replace(".", "$");
}
static <A> ArrayList<A> list(A[] a) {
  return asList(a);
}

static ArrayList<Integer> list(int[] a) {
  return asList(a);
}

static <A> ArrayList<A> list(Set<A> s) {
  return asList(s);
}
static String dbBotName(String progID) {
  return fsI(progID) + " Concepts";
}
// usually L<S>
static String fromLines(List lines) {
  StringBuilder buf = new StringBuilder();
  if (lines != null)
    for (Object line : lines)
      buf.append(str(line)).append('\n');
  return buf.toString();
}

static String fromLines(String... lines) {
  return fromLines(asList(lines));
}
static String shortClassName(Object o) {
  if (o == null) return null;
  Class c = o instanceof Class ? (Class) o : o.getClass();
  String name = c.getName();
  return shortenClassName(name);
}
static List<Integer> getBracketMap2(List<String> tok, Map<Integer, Integer> map, String openingBrackets, String closingBrackets) {
  map.clear();
  List<Integer> stack = new ArrayList();
  for (int i = 1; i < l(tok); i+= 2) {
    String t = tok.get(i);
    if (l(t) == 1)
      if (openingBrackets.contains(t))
        stack.add(i);
      else if (closingBrackets.contains(tok.get(i)))
        map.put(empty(stack) ? 0 : liftLast(stack), i);
  }
  return stack;
}
static boolean veryQuickJava_silent = true;
static boolean veryQuickJava_useCompilerBot = true; // we always use it now

// mainJava is a complete program, but without the !752/!759 at the top
// returns link to main class
static Class veryQuickJava3(String mainJava) {
  transpileRaw_silent = veryQuickJava_silent;
  String src = transpileRaw(mainJava); // transpiled, with lib references
  List<String> libs = new ArrayList();
  src = findTranslators2(src, libs);
  //print("Libs found: " + struct(libs));
  
  String dehlibs = join(" ", libs);
  File bytecode = null;
  bytecode = javaCompile_overInternalBot(src, dehlibs);

  return hotwireCore(concatLists(ll(bytecode), loadLibraries(libs)));
}
static boolean eqic(String a, String b) {
  if ((a == null) != (b == null)) return false;
  if (a == null) return true;
  return a.equalsIgnoreCase(b);
}
static Map<Integer, Integer> getBracketMap(List<String> tok) {
  Map<Integer,Integer> map = new HashMap();
  List<Integer> stack = new ArrayList();
  for (int i = 1; i < l(tok); i+= 2) {
    if (litlist("{", "(").contains(tok.get(i)))
      stack.add(i);
    else if (litlist("}", ")").contains(tok.get(i))) {
      if (!empty(stack))
        map.put(liftLast(stack), i);
    }
  }
  return map;
}
// f: A -> Comparable
static <A> List<A> sortByCalculatedFieldDesc(Collection<A> c, final Object f) {
  List<A> l = cloneList(c);
  sort(l, new Comparator<A>() {
    public int compare(A b, A a) {
      return stdcompare(callF(f, a), callF(f, b));
    }
  });
  return l;
}
static byte[] boolArrayToBytes(boolean[] a) {
  byte[] b = new byte[(l(a)+7)/8];
  for (int i = 0; i < l(a); i++)
    if (a[i])
      b[i/8] |= 1 << (i & 7);
  return b;
}
  static List<String> codeTokensOnly(List<String> tok) {
    List<String> l = new ArrayList();
    for (int i = 1; i < tok.size(); i += 2)
      l.add(tok.get(i));
    return l;
  }
static boolean isJavaIdentifier(String s) {
  if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0)))
    return false;
  for (int i = 1; i < s.length(); i++)
    if (!Character.isJavaIdentifierPart(s.charAt(i)))
      return false;
  return true;
}
static int done2_minPrint = 10;

static long done2(long startTime, String desc) {
  long time = sysNow()-startTime;
  if (time >= done2_minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done2(String desc, long startTime) {
  return done2(startTime, desc);
}

static long done2(long startTime) {
  return done2(startTime, "");
}
static String assertIsIdentifier(String s) {
  if (!isIdentifier(s))
    throw fail("Not an identifier: " + quote(s));
  return s;
}
static boolean conceptLanguageToolTips_enabled;

static void conceptLanguageToolTips() { swingAndWait(new Runnable() { public void run() { try { 
  if (conceptLanguageToolTips_enabled) return;
  conceptLanguageToolTips_enabled = true;
  
  { /*nt*/ Thread _t_0 = new Thread("conceptLanguageToolTips") {
public void run() { /* in run */ try { /* in thread */ 
  
    while (licensed()) { try {
      Component c = componentAtMouse();
      if (c instanceof JComponent) {
        String word = wordAtMouse(), msg = "";
        if (possibleGlobalID(word)) {
          String name = conceptToName(word); // This reloads AI concepts
          if (neq(name, word))
            msg = word + ": " + name;
        }
        setToolTipText((JComponent) c, msg);
      }
    } catch (Throwable __e) { printStackTrace2(__e); } sleep(500); }
  /* in thread */ } catch (Throwable __e) { printStackTrace2(__e); } /* in run */ }
};
_t_0.start(); }

} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "if (conceptLanguageToolTips_enabled) return;\r\n  conceptLanguageToolTips_enabled ..."; }}); }
// works on lists and strings and null

static int indexOfIgnoreCase(Object a, Object b) {
  if (a == null) return -1;
  if (a instanceof String) {
     Matcher m = Pattern.compile((String) b, Pattern.CASE_INSENSITIVE + Pattern.LITERAL).matcher((String) a);
     if (m.find()) return m.start(); else return -1;
  }
  if (a instanceof List) {
    for (int i = 0; i < ((List) a).size(); i++) {
      Object o = ((List) a).get(i);
      if (o != null && ((String) o).equalsIgnoreCase((String) b))
        return i;
    }
    return -1;
  }
  throw fail("Unknown type: " + a);
}
static Class<?> getClass(String name) {
  try {
    return Class.forName(name);
  } catch (ClassNotFoundException e) {
    return null;
  }
}

static Class getClass(Object o) {
  return o instanceof Class ? (Class) o : o.getClass();
}

static Class getClass(Object realm, String name) { try {
  try {
    return getClass(realm).getClassLoader().loadClass(classNameToVM(name));
  } catch (ClassNotFoundException e) {
    return null;
  }
} catch (Exception __e) { throw rethrow(__e); } }
static <A> int indexOf(List<A> l, A a, int startIndex) {
  if (l == null) return -1;
  for (int i = startIndex; i < l(l); i++)
    if (eq(l.get(i), a))
      return i;
  return -1;
}

static <A> int indexOf(List<A> l, A a) {
  if (l == null) return -1;
  return l.indexOf(a);
}

static int indexOf(String a, String b) {
  return a == null || b == null ? -1 : a.indexOf(b);
}

static int indexOf(String a, String b, int i) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, char b, int i) {
  return a == null ? -1 : a.indexOf(b, i);
}

static int indexOf(String a, int i, String b) {
  return a == null || b == null ? -1 : a.indexOf(b, i);
}

static <A> int indexOf(A[] x, A a) {
  if (x == null) return -1;
  for (int i = 0; i < l(x); i++)
    if (eq(x[i], a))
      return i;
  return -1;
}
static Object nuObject(String className, Object... args) { try {
  return nuObject(Class.forName(className), args);
} catch (Exception __e) { throw rethrow(__e); } }

// too ambiguous - maybe need to fix some callers
/*static O nuObject(O realm, S className, O... args) {
  ret nuObject(_getClass(realm, className), args);
}*/

static <A> A nuObject(Class<A> c, Object... args) { try {
  Constructor m = nuObject_findConstructor(c, args);
  m.setAccessible(true);
  return (A) m.newInstance(args);
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuObject_findConstructor(Class c, Object... args) {
  for (Constructor m : c.getDeclaredConstructors()) {
    if (!nuObject_checkArgs(m.getParameterTypes(), args, false))
      continue;
    return m;
  }
  throw new RuntimeException("Constructor " + c.getName() + getClasses(args) + " not found");
}

 static boolean nuObject_checkArgs(Class[] types, Object[] args, boolean debug) {
    if (types.length != args.length) {
      if (debug)
        System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
      return false;
    }
    for (int i = 0; i < types.length; i++)
      if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
        if (debug)
          System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
        return false;
      }
    return true;
  }
static <A, B> Set<A> keys(Map<A, B> map) {
  return map.keySet();
}

static Set keys(Object map) {
  return keys((Map) map);
}


static int randomID_defaultLength = 12;

static String randomID(int length) {
  return makeRandomID(length);
}

static String randomID() {
  return randomID(randomID_defaultLength);
}
static Class getBotMainClass(String botName) {
  Object multiPort = first(getMultiPorts());
  Object resp = call(multiPort, "findResponder", botName);
  return getMainClass(resp);
}


static File javaCompile_overInternalBot(String src) {
  return javaCompile_overInternalBot(src, "");
}

// returns path to jar
static synchronized File javaCompile_overInternalBot(String src, String dehlibs) {
  return CompilerBot.compile(src, dehlibs);
}

static List<String> getPlural_specials = ll("sheep", "fish");

static String getPlural(String s) {
  if (containsIgnoreCase(getPlural_specials, s)) return s;
  if (ewic(s, "y")) return dropSuffixIgnoreCase("y", s) + "ies";
  if (ewic(s, "ss")) return s + "es";
  if (ewic(s, "s")) return s;
  return s + "s";
}
static byte[] hexToBytes(String s) {
  int n = l(s) / 2;
  byte[] bytes = new byte[n];
  for (int i = 0; i < n; i++) {
    String hex = substring(s, i*2, i*2+2);
    try {
      bytes[i] = (byte) parseHexByte(hex);
    } catch (Throwable _e) {
      throw fail("Bad hex byte: " + quote(hex) + " at " + i*2 + "/" + l(s));
    }
  }
  return bytes;
}
static Object transpileRaw_trans;
static Object transpileRaw_silent = true;
static boolean transpileRaw_useDiskCache;

static synchronized String transpileRaw(String mainJava) {
  File cacheFile = null;
  if (transpileRaw_useDiskCache) {
    String md5 = md5(mainJava);
    cacheFile = new File(javaxCodeDir(), "Transpilations/" + md5 + ".java");
    { String _a_1 = loadTextFile(cacheFile); if (!empty(_a_1)) return _a_1; }
  }
  
  if (transpileRaw_trans == null)
    // Note: we sync the whole main class on this
    // todo: hotwire this one centrally (if we are in spontaneous code in Random v10 etc)
    transpileRaw_trans = hotwireSilently("#759");
    
  setOpt(transpileRaw_trans, "print_silent", transpileRaw_silent);

  set(transpileRaw_trans, "mainJava", mainJava);
  callMain(transpileRaw_trans);
  String main = (String) ( get(transpileRaw_trans, "mainJava"));
  if (transpileRaw_useDiskCache)
    saveTextFile(cacheFile, main);
  return main;
}
static HashMap<Class,Constructor> nuEmptyObject_cache = new HashMap();

static <A> A nuEmptyObject(Class<A> c) { try {
  Constructor ctr;
  
  synchronized(nuEmptyObject_cache) {
    ctr = nuEmptyObject_cache.get(c);
    if (ctr == null) {
      nuEmptyObject_cache.put(c, ctr = nuEmptyObject_findConstructor(c));
      ctr.setAccessible(true);
    }
  }

  return (A) ctr.newInstance();
} catch (Exception __e) { throw rethrow(__e); } }

static Constructor nuEmptyObject_findConstructor(Class c) {
  for (Constructor m : c.getDeclaredConstructors())
    if (m.getParameterTypes().length == 0)
      return m;
  throw fail("No default constructor declared in " + c.getName());
}

static boolean setOptAllDyn_debug;

static void setOptAllDyn(DynamicObject o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields)) {
    Object val = fields.get(field);
    boolean has = hasField(o, field);
    if (has)
      setOpt(o, field, val);
    else {
      o.fieldValues.put(field.intern(), val);
      if (setOptAllDyn_debug) print("setOptAllDyn added dyn " + field + " to " + o + " [value: " + val + ", fieldValues = " + systemHashCode(o.fieldValues) + ", " + struct(keys(o.fieldValues)) + "]");
    }
  }
}
static Map<String, String> singular_specials = litmap(
  "children", "child", "images", "image", "chess", "chess");
  
static Set<String> singular_specials2 = litset("time", "machine");

static String singular(String s) {
  if (s == null) return null;
  { String _a_2 = singular_specials.get(s); if (!empty(_a_2)) return _a_2; }
  if (singular_specials2.contains(dropSuffix("s", s)))
    return dropSuffix("s", s);
  if (s.endsWith("ness")) return s;
  if (s.endsWith("ges")) return dropSuffix("s", s);
  s = dropSuffix("es", s);
  s = dropSuffix("s", s);
  return s;
}
// probably better than findTranslators (uses tokens)
// removes invocations from src
static String findTranslators2(String src, List<String> libsOut) {
  List<String> tok = javaTok(src);
  int i;
  while ((i = jfind(tok, "!<int>")) >= 0) {
    setAdd(libsOut, tok.get(i+2));
    clearTokens(tok, i, i+3);
  }
  return join(tok);
}
static boolean structure_isMarker(String s, int i, int j) {
  if (i >= j) return false;
  if (s.charAt(i) != 'm') return false;
  ++i;
  while (i < j) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static Object newObject(Class c, Object... args) {
  return nuObject(c, args);
}

static Object newObject(String className, Object... args) {
  return nuObject(className, args);
}

static <A extends JComponent> A setToolTipText(final A c, final Object toolTip) {
  if (c == null) return null;
  { swingAndWait(new Runnable() { public void run() { try { 
    String s = nullIfEmpty(str(toolTip));
    if (neq(s, c.getToolTipText()))
      c.setToolTipText(s);
  
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "String s = nullIfEmpty(str(toolTip));\r\n    if (neq(s, c.getToolTipText()))\r\n    ..."; }}); }
  return c;
}
static boolean isInteger(String s) {
  if (s == null) return false;
  int n = l(s);
  if (n == 0) return false;
  int i = 0;
  if (s.charAt(0) == '-')
    if (++i >= n) return false;
  while (i < n) {
    char c = s.charAt(i);
    if (c < '0' || c > '9') return false;
    ++i;
  }
  return true;
}
static boolean jmatch(String pat, String s) {
  return jmatch(pat, s, null);
}

static boolean jmatch(String pat, String s, Matches matches) {
  if (s == null) return false;
  return jmatch(pat, javaTok(s), matches);
}

static boolean jmatch(String pat, List<String> toks) {
  return jmatch(pat, toks, null);
}

static boolean jmatch(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = javaTok(pat);
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null)
    return false;
  else {
    if (matches != null) matches.m = m;
    return true;
  }
}
static String wordAtMouse() {
  return (String) swing(new Object() { Object get() { try { 
    Component c = componentAtMouse();
    if (c instanceof JTextComponent) {
      JTextComponent tc = (JTextComponent) ( c);
      Point d = mouseToComponent(c);
      int idx = tc.viewToModel(d);
      String text = tc.getText();
      return wordAroundIndex(text, idx);
    }
    return "";
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Component c = componentAtMouse();\r\n    if (c instanceof JTextComponent) {\r\n     ..."; }});
}
static List<File> loadLibraries(List<String> snippetIDs) {
  return map("loadLibrary", snippetIDs);
}
  public static String unquote(String s) {
    if (s == null) return null;
    if (s.startsWith("[")) {
      int i = 1;
      while (i < s.length() && s.charAt(i) == '=') ++i;
      if (i < s.length() && s.charAt(i) == '[') {
        String m = s.substring(1, i);
        if (s.endsWith("]" + m + "]"))
          return s.substring(i+1, s.length()-i-1);
      }
    }
    
    if ((s.startsWith("\"") || s.startsWith("\'")) && s.length() > 1) {
      int l = s.endsWith(substring(s, 0, 1)) ? s.length()-1 : s.length();
      StringBuilder sb = new StringBuilder(l-1);
  
      for (int i = 1; i < l; i++) {
        char ch = s.charAt(i);
        if (ch == '\\') {
          char nextChar = (i == l - 1) ? '\\' : s.charAt(i + 1);
          // Octal escape?
          if (nextChar >= '0' && nextChar <= '7') {
              String code = "" + nextChar;
              i++;
              if ((i < l - 1) && s.charAt(i + 1) >= '0'
                      && s.charAt(i + 1) <= '7') {
                  code += s.charAt(i + 1);
                  i++;
                  if ((i < l - 1) && s.charAt(i + 1) >= '0'
                          && s.charAt(i + 1) <= '7') {
                      code += s.charAt(i + 1);
                      i++;
                  }
              }
              sb.append((char) Integer.parseInt(code, 8));
              continue;
          }
          switch (nextChar) {
          case '\\':
              ch = '\\';
              break;
          case 'b':
              ch = '\b';
              break;
          case 'f':
              ch = '\f';
              break;
          case 'n':
              ch = '\n';
              break;
          case 'r':
              ch = '\r';
              break;
          case 't':
              ch = '\t';
              break;
          case '\"':
              ch = '\"';
              break;
          case '\'':
              ch = '\'';
              break;
          // Hex Unicode: u????
          case 'u':
              if (i >= l - 5) {
                  ch = 'u';
                  break;
              }
              int code = Integer.parseInt(
                      "" + s.charAt(i + 2) + s.charAt(i + 3)
                         + s.charAt(i + 4) + s.charAt(i + 5), 16);
              sb.append(Character.toChars(code));
              i += 5;
              continue;
          default:
            ch = nextChar; // added by Stefan
          }
          i++;
        }
        sb.append(ch);
      }
      return sb.toString();   
    }
    
    return s; // not quoted - return original
  }
static String conceptToName(String s) {
  AIConcept c = aiConceptsMap_cached().get(s);
  return c == null || empty(c.name) ? s : c.name;
}
static void setOptAll(Object o, Map<String, Object> fields) {
  if (fields == null) return;
  for (String field : keys(fields))
    setOpt(o, field, fields.get(field));
}

static void setOptAll(Object o, Object... values) {
  //values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    setOpt(o, field, value);
  }
}
static boolean possibleGlobalID(String s) {
  return l(s) == 16 && allLowerCaseCharacters(s);
}
static String makeRandomID(int length) {
  Random random = new Random();
  char[] id = new char[length];
  for (int i = 0; i < id.length; i++)
    id[i] = (char) ((int) 'a' + random.nextInt(26));
  return new String(id);
}
static char unquoteCharacter(String s) {
  assertTrue(s.startsWith("'") && s.length() > 1);
  return unquote("\"" + s.substring(1, s.endsWith("'") ? s.length()-1 : s.length()) + "\"").charAt(0);
}
static int parseInt(String s) {
  return empty(s) ? 0 : Integer.parseInt(s);
}
static <A> A nuStubInnerObject(Class<A> c) { try {
  Class outerType = getOuterClass(c);
  Constructor m = c.getDeclaredConstructor(outerType);
  m.setAccessible(true);
  return (A) m.newInstance(new Object[] {null});
} catch (Exception __e) { throw rethrow(__e); } }
static Class hotwireCore(List urlsOrFiles) {
  List<URL> urls = map("toURL", urlsOrFiles);
  return hotwireCore((URL[]) asArray(URL.class, urls));
}

static Class hotwireCore(URL... urls) { try {
  // make class loader
  URLClassLoader classLoader = new URLClassLoader(urls);

  // load & return main class
  Class<?> theClass = classLoader.loadClass("main");
  
  setOpt(theClass, "__javax", getJavaX());
  setOpt(theClass, "programID", "#3999999");
  
  if (!_inCore())
    hotwire_copyOver(theClass);
  
  return theClass;
} catch (Exception __e) { throw rethrow(__e); } }
static boolean[] boolArrayFromBytes(byte[] a, int n) {
  boolean[] b = new boolean[n];
  int m = min(n, l(a)*8);
  for (int i = 0; i < m; i++)
    b[i] = (a[i/8] & 1 << (i & 7)) != 0;
  return b;
}
static String fsI(String id) {
  return formatSnippetID(id);
}

static String fsI(long id) {
  return formatSnippetID(id);
}
static String shortenClassName(String name) {
  if (name == null) return null;
  int i = lastIndexOf(name, "$");
  if (i < 0) i = lastIndexOf(name, ".");
  return i < 0 ? name : substring(name, i+1);
}
static float parseFloat(String s) {
  return Float.parseFloat(s);
}
static Producer<String> javaTokC_iterator(final String s) {
  return new Producer<String>() {
    final int l = s.length();
    int i = 0;
    
    public String next() {
      if (i >= l) return null;
      
      int j = i;
      char c, d;
      
      // scan for whitespace
      while (j < l) {
        c = s.charAt(j);
        d = j+1 >= l ? '\0' : s.charAt(j+1);
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          ++j;
        else if (c == '/' && d == '*') {
          do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
          j = Math.min(j+2, l);
        } else if (c == '/' && d == '/') {
          do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
        } else
          break;
      }
      
      i = j;
      if (i >= l) return null;
      c = s.charAt(i);
      d = i+1 >= l ? '\0' : s.charAt(i+1);
  
      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ++j;
        while (j < l) {
          if (s.charAt(j) == opener || s.charAt(j) == '\n') { // end at \n to not propagate unclosed string literal errors
            ++j;
            break;
          } else if (s.charAt(j) == '\\' && j+1 < l)
            j += 2;
          else
            ++j;
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || "'".indexOf(s.charAt(j)) >= 0)); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ++j; while (j < l && Character.isDigit(s.charAt(j)));
        if (j < l && s.charAt(j) == 'L') ++j; // Long constants like 1L
      } else if (c == '[' && d == '[') {
        do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
        j = Math.min(j+2, l);
      } else if (c == '[' && d == '=' && i+2 < l && s.charAt(i+2) == '[') {
        do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
        j = Math.min(j+3, l);
      } else
        ++j;
        
      String t = quickSubstring(s, i, j);
      i = j;
      return t;
    }
  };
}

static boolean isLongConstant(String s) {
  if (!s.endsWith("L")) return false;
  s = s.substring(0, l(s)-1);
  return isInteger(s);
}
static List<Class> getClasses(Object[] array) {
  List<Class> l = new ArrayList();
  for (Object o : array) l.add(_getClass(o));
  return l;
}
static String internIfLongerThan(String s, int l) {
  return s == null ? null : l(s) >= l ? s.intern() : s;
}
static void pcallOpt_noArgs(Object o, String method) {
  try { callOpt_noArgs(o, method); } catch (Throwable __e) { printStackTrace2(__e); }
}
static Producer<String> javaTokC_onReader(final BufferedReader r) {
  final class X implements Producer<String> {
    StringBuilder buf = new StringBuilder(); // stores from "i"
    char c, d, e = 'x'; // just not '\0'
    
    X() {
      // fill c, d and e
      nc();
      nc();
      nc();
    }
    
    // get next character(s) into c, d and e
    void nc() { try {
      c = d;
      d = e;
      if (e == '\0') return;
      int i = r.read();
      e = i < 0 ? '\0' : (char) i;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void ncSave() {
      if (c != '\0') {
        buf.append(c);
        nc();
      }
    }
    
    public String next() {
      // scan for whitespace
      while (c != '\0') {
        if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
          nc();
        else if (c == '/' && d == '*') {
          do nc(); while (c != '\0' && !(c == '*' && d == '/'));
          nc(); nc();
        } else if (c == '/' && d == '/') {
          do nc(); while (c != '\0' && "\r\n".indexOf(c) < 0);
        } else
          break;
      }
      
      if (c == '\0') return null;

      // scan for non-whitespace
      if (c == '\'' || c == '"') {
        char opener = c;
        ncSave();
        while (c != '\0') {
          if (c == opener || c == '\n') { // end at \n to not propagate unclosed string literal errors
            ncSave();
            break;
          } else if (c == '\\') {
            ncSave();
            ncSave();
          } else
            ncSave();
        }
      } else if (Character.isJavaIdentifierStart(c))
        do ncSave(); while (Character.isJavaIdentifierPart(c) || c == '\''); // for stuff like "don't"
      else if (Character.isDigit(c)) {
        do ncSave(); while (Character.isDigit(c));
        if (c == 'L') ncSave(); // Long constants like 1L
      } else if (c == '[' && d == '[') {
        do ncSave(); while (c != '\0' && !(c == ']' && d == ']'));
        ncSave(); ncSave();
      } else if (c == '[' && d == '=' && e == '[') {
        do ncSave(); while (c != '\0' && !(c == ']' && d == '=' && e == ']'));
        ncSave(); ncSave(); ncSave();
      } else
        ncSave();
        
      String t = buf.toString();
      buf.setLength(0);
      return t;
    }
  }
  
  return new X();
}

static long parseLong(String s) {
  if (s == null) return 0;
  return Long.parseLong(dropSuffix("L", s));
}

static long parseLong(Object s) {
  return Long.parseLong((String) s);
}
static boolean isIdentifier(String s) {
  return isJavaIdentifier(s);
}
static int[] toIntArray(List<Integer> l) {
  int[] a = new int[l(l)];
  for (int i = 0; i < a.length; i++)
    a[i] = l.get(i);
  return a;
}
static void printStructure(String prefix, Object o) {
  if (endsWithLetter(prefix)) prefix += ": ";
  print(prefix + structure(o));
}

static void printStructure(Object o) {
  print(structure(o));
}

static List<Object> getMultiPorts() {
  return (List) callOpt(getJavaX(), "getMultiPorts");
}
static Component componentAtMouse() {
  return (Component) swing(new Object() { Object get() { try { 
    Point p = MouseInfo.getPointerInfo().getLocation();
    Window window = locationToWindow(p);
    if (window == null) return null;
    SwingUtilities.convertPointFromScreen(p, window);
    return SwingUtilities.getDeepestComponentAt(window, p.x, p.y);
   } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "Point p = MouseInfo.getPointerInfo().getLocation();\r\n    Window window = locatio..."; }});
}
  static <A> List<A> concatLists(Collection<A>... lists) {
    List<A> l = new ArrayList();
    for (Collection<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

  static <A> List<A> concatLists(Collection<List<A>> lists) {
    List<A> l = new ArrayList();
    for (List<A> list : lists)
      if (list != null)
        l.addAll(list);
    return l;
  }

static double parseDouble(String s) {
  return Double.parseDouble(s);
}


static Object[] asArray(List l) {
  return toObjectArray(l);
}

static <A> A[] asArray(Class<A> type, List l) {
  return (A[]) l.toArray((Object[]) Array.newInstance(type, l.size()));
}
static <A> HashSet<A> litset(A... items) {
  return lithashset(items);
}
static String dropSuffixIgnoreCase(String suffix, String s) {
  return ewic(s, suffix) ? s.substring(0, l(s)-l(suffix)) : s;
}
static Class hotwireSilently(String src) {
  Object j = getJavaX();
  Boolean b = (Boolean) ( getThreadLocalOpt(j, "loadPage_silent"));
  setThreadLocalOpt(j, "loadPage_silent", true);
  try {
    return hotwire(src);
  } finally {
    setThreadLocalOpt(j, "loadPage_silent", b);
  }
}
static URL toURL(Object o) { try {
  if (o instanceof URL) return (URL) o;
  if (o instanceof String) return new URL((String) o);
  if (o instanceof File) return fileToURL((File) o);
  throw fail("Can't convert to URL: " + o);
} catch (Exception __e) { throw rethrow(__e); } }
static void set(Object o, String field, Object value) {
  if (o instanceof Class) set((Class) o, field, value);
  else try {
    Field f = set_findField(o.getClass(), field);
    smartSet(f, o, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static void set(Class c, String field, Object value) {
  try {
    Field f = set_findStaticField(c, field);
    smartSet(f, null, value);
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}
  
static Field set_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Static field '" + field + "' not found in " + c.getName());
}

static Field set_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  throw new RuntimeException("Field '" + field + "' not found in " + c.getName());
}
static Object swing(Object f) {
  return swingAndWait(f);
}
static boolean hasField(Object o, String field) {
  return findField2(o, field) != null;
}
// match2 matches multiple "*" (matches a single token) wildcards and zero or one "..." wildcards (matches multiple tokens)

static String[] match2(List<String> pat, List<String> tok) {
  // standard case (no ...)
  int i = pat.indexOf("...");
  if (i < 0) return match2_match(pat, tok);
  
  pat = new ArrayList<String>(pat); // We're modifying it, so copy first
  pat.set(i, "*");
  while (pat.size() < tok.size()) {
    pat.add(i, "*");
    pat.add(i+1, ""); // doesn't matter
  }
  
  return match2_match(pat, tok);
}

static String[] match2_match(List<String> pat, List<String> tok) {
  List<String> result = new ArrayList<String>();
  if (pat.size() != tok.size()) {
    /*if (debug)
      print("Size mismatch: " + structure(pat) + " vs " + structure(tok));*/
    return null;
  }
  for (int i = 1; i < pat.size(); i += 2) {
    String p = pat.get(i), t = tok.get(i);
    /*if (debug)
      print("Checking " + p + " against " + t);*/
    if (eq(p, "*"))
      result.add(t);
    else if (!equalsIgnoreCase(unquote(p), unquote(t))) // bold change - match quoted and unquoted now
      return null;
  }
  return result.toArray(new String[result.size()]);
}

static void callMain(Object c, String... args) {
  callOpt(c, "main", new Object[] {args});
}

static void callMain() {
  callMain(mc());
}
static String formatSnippetID(String id) {
  return "#" + parseSnippetID(id);
}

static String formatSnippetID(long id) {
  return "#" + id;
}
static int systemHashCode(Object o) {
  return identityHashCode(o);
}
static Point mouseToComponent(Component c) {
  Point d = mouseLocation();
  SwingUtilities.convertPointFromScreen(d, c);
  return d;
}

  static void clearTokens(List<String> tok) {
    clearAllTokens(tok);
  }
  
  static void clearTokens(List<String> tok, int i, int j) {
    clearAllTokens(tok, i, j);
  }
/** writes safely (to temp file, then rename) */
static void saveTextFile(String fileName, String contents) throws IOException {
  CriticalAction action = beginCriticalAction("Saving file " + fileName + " (" + l(contents) + " chars)");
  try {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    File tempFile = new File(tempFileName);
    if (contents != null) {
      if (tempFile.exists()) try {
        String saveName = tempFileName + ".saved." + now();
        copyFile(tempFile, new File(saveName));
      } catch (Throwable e) { printStackTrace(e); }
      FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
      OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
      PrintWriter printWriter = new PrintWriter(outputStreamWriter);
      printWriter.print(contents);
      printWriter.close();
    }
    
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);
  
    if (contents != null)
      if (!tempFile.renameTo(file))
        throw new IOException("Can't rename " + tempFile + " to " + file);
  } finally {
    action.done();
  }
}

static void saveTextFile(File fileName, String contents) { try {
  saveTextFile(fileName.getPath(), contents);
} catch (Exception __e) { throw rethrow(__e); } }

static void warnIfOddCount(Object... list) {
  if (odd(l(list)))
    printStackTrace("Odd list size: " + list);
}
static <A> boolean setAdd(Collection<A> c, A a) {
  if (c.contains(a)) return false;
  c.add(a);
  return true;
}
// TODO: z-order?
static Window locationToWindow(Point p) {
  for (Window window : Window.getWindows())
    if (window.isShowing() && boundsOnScreen(window).contains(p))
      return window;
  return null;
}

static int lastIndexOf(String a, String b) {
  return a == null || b == null ? -1 : a.lastIndexOf(b);
}
static boolean allLowerCaseCharacters(String s) {
  for (int i = 0; i < l(s); i++)
    if (Character.getType(s.charAt(i)) != Character.LOWERCASE_LETTER) return false;
  return true;
}
static File javaxCodeDir_dir; // can be set to work on different base dir

static File javaxCodeDir() {
  return javaxCodeDir_dir != null ? javaxCodeDir_dir : new File(userHome(), "JavaX-Code");
}
static Class getOuterClass(Class c) { try {
  String s = c.getName();
  int i = s.lastIndexOf('$');
  return Class.forName(substring(s, 0, i));
} catch (Exception __e) { throw rethrow(__e); } }
static int jfind(List<String> tok, String in) {
  return jfind(tok, 1, in);
}

static int jfind(List<String> tok, int startIdx, String in) {
  return jfind(tok, startIdx, in, null);
}

static int jfind(List<String> tok, String in, Object condition) {
  return jfind(tok, 1, in, condition);
}

static int jfind(List<String> tok, int startIdx, String in, Object condition) {
  List<String> tokin = javaTok(in);
  jfind_preprocess(tokin);
  return jfind(tok, startIdx, tokin, condition);
}

// assumes you preprocessed tokin
static int jfind(List<String> tok, List<String> tokin) {
  return jfind(tok, 1, tokin);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin) {
  return jfind(tok, startIdx, tokin, null);
}

static int jfind(List<String> tok, int startIdx, List<String> tokin, Object condition) {
  return findCodeTokens(tok, startIdx, false, toStringArray(codeTokensOnly(tokin)), condition);
}

static void jfind_preprocess(List<String> tok) {
  for (String type : litlist("quoted", "id", "int"))
    replaceSublist(tok, ll("<", "", type, "", ">"), ll("<" + type + ">"));
  replaceSublist(tok, ll("\\", "", "*"), ll("\\*"));
}
static Map litmap(Object... x) {
  TreeMap map = new TreeMap();
  litmap_impl(map, x);
  return map;
}

static void litmap_impl(Map map, Object... x) {
  for (int i = 0; i < x.length-1; i += 2)
    if (x[i+1] != null)
      map.put(x[i], x[i+1]);
}
static boolean _inCore() {
  return false;
}
static boolean endsWithLetter(String s) {
  return nempty(s) && isLetter(last(s));
}
static boolean ewic(String a, String b) {
  return endsWithIgnoreCase(a, b);
}
static String md5(String text) { try {
  if (text == null) return "-";
  return bytesToHex(md5_impl(text.getBytes("UTF-8"))); // maybe different than the way PHP does it...
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(byte[] data) {
  if (data == null) return "-";
  return bytesToHex(md5_impl(data));
}

static MessageDigest md5_md;

/*static byte[] md5_impl(byte[] data) ctex {
  if (md5_md == null)
    md5_md = MessageDigest.getInstance("MD5");
  return ((MessageDigest) md5_md.clone()).digest(data);
}*/

static byte[] md5_impl(byte[] data) { try {
  return MessageDigest.getInstance("MD5").digest(data);
} catch (Exception __e) { throw rethrow(__e); } }

static String md5(File file) { try {
  return md5(loadBinaryFile(file));
} catch (Exception __e) { throw rethrow(__e); } }
static void hotwire_copyOver(Class c) {
  synchronized(StringBuffer.class) {
    for (String field : litlist("print_log", "print_silent", "androidContext")) {
      Object o = getOpt(mc(), field);
      if (o != null)
        setOpt(c, field, o);
    }
      
    Object mainBot = getMainBot();
    if (mainBot != null)
      setOpt(c, "mainBot", mainBot);

    setOpt(c, "creator_class", new WeakReference(mc()));
  }
}
static WeakHashMap<Class, HashMap<String, Method>> callOpt_noArgs_cache = new WeakHashMap();

static Object callOpt_noArgs(Object o, String method) { try {
  if (o == null) return null;
  if (o instanceof Class)
    return callOpt(o, method); // not optimized
  
  Class c = o.getClass();
  HashMap<String, Method> map;
  synchronized(callOpt_noArgs_cache) {
    map = callOpt_noArgs_cache.get(c);
    if (map == null)
      map = callOpt_noArgs_makeCache(c);
  }

  Method m = map.get(method);
  return m != null ? m.invoke(o) : null;
} catch (Exception __e) { throw rethrow(__e); } }

// used internally - we are in synchronized block
static HashMap<String, Method> callOpt_noArgs_makeCache(Class c) {
  HashMap<String,Method> map = new HashMap();
  Class _c = c;
  do {
    for (Method m : c.getDeclaredMethods())
      if (m.getParameterTypes().length == 0) {
        m.setAccessible(true);
        String name = m.getName();
        if (!map.containsKey(name))
          map.put(name, m);
      }
    _c = _c.getSuperclass();
  } while (_c != null);
  callOpt_noArgs_cache.put(c, map);
  return map;
}
static String wordAroundIndex(String s, int i) {
  if (!(i >= 0 && i < l(s) && isLetterOrDigit(s.charAt(i)))) return "";
  int j = i;
  while (i > 0 && isLetterOrDigit(s.charAt(i-1))) --i;
  while (j < l(s) && isLetterOrDigit(s.charAt(j))) ++j;
  return substring(s, i, j);
}
static File loadLibrary(String snippetID) {
  return loadBinarySnippet(snippetID);
}
static String nullIfEmpty(String s) {
  return isEmpty(s) ? null : s;
}
static Object callOpt(Object o) {
  if (o == null) return null;
  return callF(o);
}

static Object callOpt(Object o, String method, Object... args) {
  try {
    if (o == null) return null;
    if (o instanceof Class) {
      Method m = callOpt_findStaticMethod((Class) o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(null, args);
    } else {
      Method m = callOpt_findMethod(o, method, args, false);
      if (m == null) return null;
      m.setAccessible(true);
      return m.invoke(o, args);
    }
  } catch (Exception e) {
    throw new RuntimeException(e);
  }
}

static Method callOpt_findStaticMethod(Class c, String method, Object[] args, boolean debug) {
  Class _c = c;
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (!m.getName().equals(method)) {
        if (debug) System.out.println("Method name mismatch: " + method);
        continue;
      }

      if ((m.getModifiers() & Modifier.STATIC) == 0 || !callOpt_checkArgs(m, args, debug))
        continue;

      return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

static Method callOpt_findMethod(Object o, String method, Object[] args, boolean debug) {
  Class c = o.getClass();
  while (c != null) {
    for (Method m : c.getDeclaredMethods()) {
      if (debug)
        System.out.println("Checking method " + m.getName() + " with " + m.getParameterTypes().length + " parameters");;
      if (m.getName().equals(method) && callOpt_checkArgs(m, args, debug))
        return m;
    }
    c = c.getSuperclass();
  }
  return null;
}

private static boolean callOpt_checkArgs(Method m, Object[] args, boolean debug) {
  Class<?>[] types = m.getParameterTypes();
  if (types.length != args.length) {
    if (debug)
      System.out.println("Bad parameter length: " + args.length + " vs " + types.length);
    return false;
  }
  for (int i = 0; i < types.length; i++)
    if (!(args[i] == null || isInstanceX(types[i], args[i]))) {
      if (debug)
        System.out.println("Bad parameter " + i + ": " + args[i] + " vs " + types[i]);
      return false;
    }
  return true;
}


static int parseHexByte(String s) {
  return Integer.parseInt(s, 16);
}


static List<CriticalAction> beginCriticalAction_inFlight = synchroList();

static class CriticalAction {
  String description;
  
  CriticalAction() {}
  CriticalAction(String description) {
  this.description = description;}
  
  void done() {
    beginCriticalAction_inFlight.remove(this);
  }
}

static CriticalAction beginCriticalAction(String description) {
  ping();
  CriticalAction c = new CriticalAction(description);
  beginCriticalAction_inFlight.add(c);
  return c;
}

static void cleanMeUp_beginCriticalAction() {
  int n = 0;
  while (nempty(beginCriticalAction_inFlight)) {
    int m = l(beginCriticalAction_inFlight);
    if (m != n) {
      n = m;
      try {
        print("Waiting for " + n(n, "critical actions") + ": " + join(", ", collect(beginCriticalAction_inFlight, "description")));
      } catch (Throwable __e) { printStackTrace2(__e); }
    }
    sleepInCleanUp(10);
  }
}
static Point mouseLocation() {
  return getMouseLocation();
}

static boolean equalsIgnoreCase(String a, String b) {
  return a == null ? b == null : a.equalsIgnoreCase(b);
}
static Throwable printStackTrace(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace(e));
  return e;
}

static void printStackTrace() {
  printStackTrace(new Throwable());
}

static void printStackTrace(String msg) {
  printStackTrace(new Throwable(msg));
}

static void printStackTrace(String indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace(e));
}
static URL fileToURL(File f) { try {
  return f.toURI().toURL();
} catch (Exception __e) { throw rethrow(__e); } }
static File loadBinarySnippet(String snippetID) { try {
  long id = parseSnippetID(snippetID);
  File f = DiskSnippetCache_getLibrary(id);
  if (f == null) {
    byte[] data = loadDataSnippetImpl(snippetID);
    DiskSnippetCache_putLibrary(id, data);
    f = DiskSnippetCache_getLibrary(id);
  }
  return f;
} catch (Exception __e) { throw rethrow(__e); } }
static Object mainBot;

static Object getMainBot() {
  return mainBot;
}
static <A> A last(List<A> l) {
  return l.isEmpty() ? null : l.get(l.size()-1);
}

static char last(String s) {
  return empty(s) ? '#' : s.charAt(l(s)-1);
}

static int last(int[] a) {
  return l(a) != 0 ? a[l(a)-1] : 0;
}
static <A> HashSet<A> lithashset(A... items) {
  HashSet<A> set = new HashSet();
  for (A a : items) set.add(a);
  return set;
}
static long now_virtualTime;
static long now() {
  return now_virtualTime != 0 ? now_virtualTime : System.currentTimeMillis();
}

static FileOutputStream newFileOutputStream(File path) throws IOException {
  return newFileOutputStream(path.getPath());
}

static FileOutputStream newFileOutputStream(String path) throws IOException {
  return newFileOutputStream(path, false);
}

static FileOutputStream newFileOutputStream(String path, boolean append) throws IOException {
  FileOutputStream f = new // Line break for ancient translator
    FileOutputStream(path, append);
  callJavaX("registerIO", f, path, true);
  return f;
}
public static byte[] loadBinaryFile(String fileName) {
 try {
  if (!new File(fileName).exists())
    return null;

  FileInputStream in = new FileInputStream(fileName);

  byte buf[] = new byte[1024];
  ByteArrayOutputStream out = new ByteArrayOutputStream();
  int l;
  while (true) {
    l = in.read(buf);
    if (l <= 0) break;
    out.write(buf, 0, l);
  }
  in.close();
  return out.toByteArray();
 } catch (IOException e) { throw new RuntimeException(e); }
}

public static byte[] loadBinaryFile(File file) {
  return loadBinaryFile(file.getPath());
}

static Field findField2(Object o, String field) {
  if (o instanceof Class) return findField2_findStaticField((Class) o, field);
  return findField2_findField(o.getClass(), field);
}

static Field findField2_findStaticField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field) && (f.getModifiers() & Modifier.STATIC) != 0)
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}

static Field findField2_findField(Class<?> c, String field) {
  Class _c = c;
  do {
    for (Field f : _c.getDeclaredFields())
      if (f.getName().equals(field))
        return f;
    _c = _c.getSuperclass();
  } while (_c != null);
  return null;
}
static int identityHashCode(Object o) {
  return System.identityHashCode(o);
}
static void swingAndWait(Runnable r) { try {
  if (isAWTThread())
    r.run();
  else
    EventQueue.invokeAndWait(r);
} catch (Exception __e) { throw rethrow(__e); } }

static Object swingAndWait(final Object f) {
  if (isAWTThread())
    return callF(f);
  else {
    final Var result = new Var();
    swingAndWait(new Runnable() { public void run() { try { 
      result.set(callF(f));
    
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "result.set(callF(f));"; }});
    return result.get();
  }
}
static List<String> replaceSublist(List<String> l, List<String> x, List<String> y) {
  if (x == null) return l;
  
  int i = 0;
  while (true) {
    i = indexOfSubList(l, x, i);
    if (i < 0) break;
    
    // It's inefficient :D
    for (int j = 0; j < l(x); j++) l.remove(i);
    l.addAll(i, y);
    i += l(y);
  }
  return l;
}
static void setThreadLocalOpt(Object o, String name, Object value) {
  ThreadLocal t = (ThreadLocal) ( getOpt(o, name));
  if (t != null) t.set(value);
}
static boolean odd(int i) {
  return (i & 1) != 0;
}
static Object getThreadLocalOpt(Object o, String name) {
  ThreadLocal t = (ThreadLocal) ( getOpt(o, name));
  return t != null ? t.get() : null;
}
public static void copyFile(File src, File dest) { try {
  mkdirsForFile(dest);
  FileInputStream inputStream = new FileInputStream(src.getPath());
  FileOutputStream outputStream = newFileOutputStream(dest.getPath());
  try {
    copyStream(inputStream, outputStream);
    inputStream.close();
  } finally {
    outputStream.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }
static boolean endsWithIgnoreCase(String a, String b) {
  return a != null && l(a) >= l(b) && a.regionMatches(true, l(a)-l(b), b, 0, l(b));
}
static Rectangle boundsOnScreen(Component c) {
  if (c.getParent() instanceof JViewport
    && c.getParent().getParent() instanceof JScrollPane)
    c = c.getParent().getParent();
  return new Rectangle(c.getLocationOnScreen(), c.getSize());
}
static String _userHome;
static String userHome() {
  if (_userHome == null) {
    if (isAndroid())
      _userHome = "/storage/sdcard0/";
    else
      _userHome = System.getProperty("user.home");
    //System.out.println("userHome: " + _userHome);
  }
  return _userHome;
}

static File userHome(String path) {
  return new File(userDir(), path);
}
  static void clearAllTokens(List<String> tok) {
    for (int i = 0; i < tok.size(); i++)
      tok.set(i, "");
  }
  
  static void clearAllTokens(List<String> tok, int i, int j) {
    for (; i < j; i++)
      tok.set(i, "");
  }
static int findCodeTokens(List<String> tok, String... tokens) {
  return findCodeTokens(tok, 1, false, tokens);
}

static int findCodeTokens(List<String> tok, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, 1, ignoreCase, tokens);
}

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String... tokens) {
  return findCodeTokens(tok, startIdx, ignoreCase, tokens, null);
}

static List<String> findCodeTokens_specials = litlist("*", "<quoted>", "<id>", "<int>", "\\*");
static boolean findCodeTokens_debug;
static int findCodeTokens_indexed, findCodeTokens_unindexed;
static int findCodeTokens_bails, findCodeTokens_nonbails;

static int findCodeTokens(List<String> tok, int startIdx, boolean ignoreCase, String[] tokens, Object condition) {
  if (findCodeTokens_debug) {
    if (eq(getClassName(tok), "main$IndexedList2"))
      findCodeTokens_indexed++;
    else
      findCodeTokens_unindexed++;
  }
  // bail out early if first token not found (works great with IndexedList)
  if (!findCodeTokens_specials.contains(tokens[0])
    && !tok.contains(tokens[0] /*, startIdx << no signature in List for this, unfortunately */)) {
      ++findCodeTokens_bails;
      return -1;
    }
  ++findCodeTokens_nonbails;
  
  outer: for (int i = startIdx | 1; i+tokens.length*2-2 < tok.size(); i += 2) {
    for (int j = 0; j < tokens.length; j++) {
      String p = tokens[j], t = tok.get(i+j*2);
      boolean match;
      if (eq(p, "*")) match = true;
      else if (eq(p, "<quoted>")) match = isQuoted(t);
      else if (eq(p, "<id>")) match = isIdentifier(t);
      else if (eq(p, "<int>")) match = isInteger(t);
      else if (eq(p, "\\*")) match = eq("*", t);
      else match = ignoreCase ? eqic(p, t) : eq(p, t);
      
      if (!match)
        continue outer;
    }
    
    if (condition == null || checkCondition(condition, tok, i-1)) // pass N index
      return i;
  }
  return -1;
}
static boolean isLetterOrDigit(char c) {
  return Character.isLetterOrDigit(c);
}
static boolean isLetter(char c) {
  return Character.isLetter(c);
}
public static long parseSnippetID(String snippetID) {
  long id = Long.parseLong(shortenSnippetID(snippetID));
  if (id == 0) throw fail("0 is not a snippet ID");
  return id;
}
static Class<?> hotwire(String src) {
  assertFalse(_inCore());
  Class j = getJavaX();
  if (isAndroid()) {
    synchronized(j) { // hopefully this goes well...
      List<File> libraries = new ArrayList<File>();
      File srcDir = (File) call(j, "transpileMain", src, libraries);
      if (srcDir == null)
        throw fail("transpileMain returned null (src=" + quote(src) + ")");
    
      Object androidContext = get(j, "androidContext");
      return (Class) call(j, "loadx2android", srcDir, src);
    }
  } else {
    // ret hotwire_overInternalBot(src);
    Class c = (Class) ( call(j, "hotwire", src));
    hotwire_copyOver(c);
    return c;
  }
}


static String shortenSnippetID(String snippetID) {
  if (snippetID.startsWith("#"))
    snippetID = snippetID.substring(1);
  String httpBlaBla = "http://tinybrain.de/";
  if (snippetID.startsWith(httpBlaBla))
    snippetID = snippetID.substring(httpBlaBla.length());
  return "" + parseLong(snippetID);
}
  
  // Data files are immutable, use centralized cache
public static File DiskSnippetCache_getLibrary(long snippetID) throws IOException {
  File file = new File(getGlobalCache(), "data_" + snippetID + ".jar");
  return file.exists() ? file : null;
}

public static void DiskSnippetCache_putLibrary(long snippetID, byte[] data) throws IOException {
  saveBinaryFile(new File(getGlobalCache(), "data_" + snippetID).getPath() + ".jar", data);
}

static byte[] loadDataSnippetImpl(String snippetID) throws IOException {
  byte[] data;
  try {
    URL url = new URL("http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_"
      + parseSnippetID(snippetID) + "&contentType=application/binary");
    System.err.println("Loading library: " + url);
    try {
      data = loadBinaryPage(url.openConnection());
    } catch (RuntimeException e) {
      data = null;
    }
    
    if (data == null || data.length == 0) {
      url = new URL("http://data.tinybrain.de/blobs/"
        + parseSnippetID(snippetID));
      System.err.println("Loading library: " + url);
      data = loadBinaryPage(url.openConnection());
    }
    System.err.println("Bytes loaded: " + data.length);
  } catch (FileNotFoundException e) {
    throw new IOException("Binary snippet #" + snippetID + " not found or not public");
  }
  return data;
}
static <A> int indexOfSubList(List<A> x, List<A> y) {
  return indexOfSubList(x, y, 0);
}

static <A> int indexOfSubList(List<A> x, List<A> y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y.get(j)))
        continue outer;
    return i;
  }
  return -1;
}

static <A> int indexOfSubList(List<A> x, A[] y, int i) {
  outer: for (; i+l(y) <= l(x); i++) {
    for (int j = 0; j < l(y); j++)
      if (neq(x.get(i+j), y[j]))
        continue outer;
    return i;
  }
  return -1;
}
static String getStackTrace(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  return writer.toString();
}
// supports the usual quotings (', ", variable length double brackets)
static boolean isQuoted(String s) {
  if (s.startsWith("'") || s.startsWith("\"")) return true;
  if (!s.startsWith("[")) return false;
  int i = 1;
  while (i < s.length() && s.charAt(i) == '=') ++i;
  return i < s.length() && s.charAt(i) == '[';
  //return Pattern.compile("^\\[=*\\[").matcher(s).find();
}
static boolean checkCondition(Object condition, Object... args) {
  return isTrue(call(condition, "get", args));
}
public static File mkdirsForFile(File file) {
  File dir = file.getParentFile();
  if (dir != null) // is null if file is in current dir
    dir.mkdirs();
  return file;
}

static Object callJavaX(String method, Object... args) {
  return callOpt(getJavaX(), method, args);
}
static <A> List<A> synchroList() {
  return Collections.synchronizedList(new ArrayList<A>());
}

static <A> List<A> synchroList(List<A> l) {
  return Collections.synchronizedList(l);
}

static void copyStream(InputStream in, OutputStream out) { try {
  byte[] buf = new byte[65536];
  while (true) {
    int n = in.read(buf);
    if (n <= 0) return;
    out.write(buf, 0, n);
  }
} catch (Exception __e) { throw rethrow(__e); } }
static Point getMouseLocation() {
  return MouseInfo.getPointerInfo().getLocation();
}

static void sleepInCleanUp(long ms) { try {
  if (ms < 0) return;
  Thread.sleep(ms);
} catch (Exception __e) { throw rethrow(__e); } }
static void assertFalse(Object o) {
  assertEquals(false, o);
}
  
static boolean assertFalse(boolean b) {
  if (b) throw fail("oops");
  return b;
}

static boolean assertFalse(String msg, boolean b) {
  if (b) throw fail(msg);
  return b;
}

static File userDir() {
  return new File(userHome());
}

static File userDir(String path) {
  return new File(userHome(), path);
}


static File getGlobalCache() {
  File file = new File(userHome(), ".tinybrain/snippet-cache");
  file.mkdirs();
  return file;
}

  /** writes safely (to temp file, then rename) */
  public static void saveBinaryFile(String fileName, byte[] contents) throws IOException {
    File file = new File(fileName);
    File parentFile = file.getParentFile();
    if (parentFile != null)
      parentFile.mkdirs();
    String tempFileName = fileName + "_temp";
    FileOutputStream fileOutputStream = newFileOutputStream(tempFileName);
    fileOutputStream.write(contents);
    fileOutputStream.close();
    if (file.exists() && !file.delete())
      throw new IOException("Can't delete " + fileName);

    if (!new File(tempFileName).renameTo(file))
      throw new IOException("Can't rename " + tempFileName + " to " + fileName);
  }

  static void saveBinaryFile(File fileName, byte[] contents) {
    try {
      saveBinaryFile(fileName.getPath(), contents);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
static byte[] loadBinaryPage(String url) { try {
  print("Loading " + url);
  return loadBinaryPage(new URL(url).openConnection());
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage(URLConnection con) { try {
  setHeaders(con);
  return loadBinaryPage_noHeaders(con);
} catch (Exception __e) { throw rethrow(__e); } }

static byte[] loadBinaryPage_noHeaders(URLConnection con) { try {
  setHeaders(con);
  ByteArrayOutputStream buf = new ByteArrayOutputStream();
  InputStream inputStream = con.getInputStream();
  long len = 0;
  try { len = con.getContentLengthLong(); } catch (Throwable e) { printStackTrace(e); }
  int n = 0;
  while (true) {
    int ch = inputStream.read();
    if (ch < 0)
      break;
    buf.write(ch);
    if (++n % 100000 == 0)
      println("  " + n + (len != 0 ? "/" + len : "") + " bytes loaded.");
  }
  inputStream.close();
  return buf.toByteArray();
} catch (Exception __e) { throw rethrow(__e); } }



static void setHeaders(URLConnection con) throws IOException {
  String computerID = getComputerID_quick();
  if (computerID != null) try {
    con.setRequestProperty("X-ComputerID", computerID);
    con.setRequestProperty("X-OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
  } catch (Throwable e) {
    //printShortException(e);
  }
}
static <A> A println(A a) {
  return print(a);
}


static String getComputerID_quick() {
  File file = new File(userHome(), ".tinybrain/computer-id");
  return assertNempty(loadTextFile(file.getPath(), null));
}


static <A> A assertNempty(A a) {
  if (empty(a))
    throw fail("empty: " + a);
  return a;
}


static abstract class F1<A, B> {
  abstract B get(A a);
}

static class LispStatement {
  String globalID;
  Lisp term;
  
  LispStatement() {}
  LispStatement(String globalID, Lisp term) {
  this.term = term;
  this.globalID = globalID;}
}

static class Statement extends Node {
  String text;
  String possibleEnglishTranslation; // for humans
}

static class Cache<A> {
  Object maker; // func -> A
  A value;
  long loaded;
  static boolean debug;
  
  Cache() {}
  Cache(Object maker) {
  this.maker = maker;}

  synchronized A get() {
    if (loaded == 0) {
      value = (A) callF(maker);
      loaded = sysNow();
    }
    return value;
  }

  synchronized void clear() {
    if (debug && loaded != 0)
      print("Clearing cache");
    value = null;
    loaded = 0;
  }

  // clear if older than x seconds
  // 0 does not do anything
  synchronized void clear(double seconds) {
    if (seconds != 0 && loaded != 0 && sysNow() >= loaded+seconds*1000)
      clear();
  }
  
  // override
  synchronized void set(A a) {
    value = a;
    loaded = sysNow();
  }
}

// uses identity to compare a and new value
static class WeakAssoc<A, B> {
  Object f; // func(A) -> B
  WeakReference<A> a;
  B b;
  
  WeakAssoc() {}
  WeakAssoc(Object f) {
  this.f = f;}

  synchronized B get(A a) {
    if (a != (this.a != null ? this.a.get() : null)) {
      b = (B) callF(f, a);
      this.a = new WeakReference(a);
    }
    return b;
  }
}

static class Node extends Concept {
  String globalID = isTrue(DynamicObject_loading.get()) ? null : aGlobalID();
  String importedFrom; // computer or snippet ID
  String originatingUniverse; // global ID of "universe" concept was created in
  boolean exportable = true;
  Ref<PNGFile> pngFile = new Ref();
  String imageMD5, suggestedImageMD5;
  Ref<PNGFile> suggestedImage = new Ref();
  boolean searchedForSuggestedImage;
  long imported, touched; // timestamps
  long dataLength; // length of optional byte data (wherever it is stored)
  boolean dataIsText; // can optional data be shown as text
}

static class AIConcept extends Node {
  String name;
  String comment;
}

static class Lowest<A> {
  A best;
  double score;
  transient Object onChange;
  
  boolean isNewBest(double score) {
    return best == null || score < this.score;
  }
  
  double bestScore() {
    return best == null ? Double.NaN : score;
  }
  
  float floatScore() {
    return best == null ? Float.NaN : (float) score;
  }
  
  float floatScoreOr(float defaultValue) {
    return best == null ? defaultValue : (float) score;
  }
  
  boolean put(A a, double score) {
    if (a != null && isNewBest(score)) {
      best = a;
      this.score = score;
      pcallF(onChange);
      return true;
    }
    return false;
  }
  
  A get() { return best; }
  boolean has() { return best != null; }
}

static class Best<A> {
  A best;
  double score;
  transient Object onChange;
  
  boolean isNewBest(double score) {
    return best == null || score > this.score;
  }
  
  double bestScore() {
    return best == null ? Double.NaN : score;
  }
  
  double score() { return bestScore(); }
  
  boolean put(A a, double score) {
    if (a != null && isNewBest(score)) {
      best = a;
      this.score = score;
      pcallF(onChange);
      return true;
    }
    return false;
  }
  
  A get() { return best; }
  boolean has() { return best != null; }
}

static interface Producer<A> {
  public A next();
}

static class CompilerBot {
  static boolean verbose;

  // returns jar path
  static File compileSnippet(String snippetID) {
    String transpiledSrc = getServerTranspiled2(snippetID);
    int i = transpiledSrc.indexOf('\n');
    String libs = transpiledSrc.substring(0, Math.max(0, i));
    if (verbose)
      print("Compiling snippet: " + snippetID + ". Libs: " + libs);
    transpiledSrc = transpiledSrc.substring(i+1);
    return compile(transpiledSrc, libs);
  }

  static File compile(String src) {
    return compile(src, "");
  }
  
  static File compile(String src, String libs) {
    return compile(src, libs, null);
  }

  static File compile(String src, String dehlibs, String javaTarget) {
    if (verbose)
      print("Compiling " + l(src) + " chars");
    String md5 = md5(dehlibs + "\n" + src);
    File jar = getJarFile(md5);
    if (jar == null || jar.length() <= 22) {
      // have to compile
      
      javaCompileToJar_standard(src, dehlibs, jar);
    } else {
      if (verbose)
        print("Getting classes from cache (" + jar.getAbsolutePath() + ", " + jar.length() + " bytes)");
      touchFile(jar); // so we can find the unused ones easier
    }
    
    return jar;
  }

  static File getJarFile(String md5) {
    assertTrue(isMD5(md5));
    return new File(getCacheProgramDir("#1002203"), md5 + ".jar");
  }
}

static abstract class Collector<A> {
  abstract boolean add(A a); // return true if full after this
  boolean full() { return false; }
  boolean contains(A a) { return false; }
}

static ThreadLocal<Boolean> DynamicObject_loading = new ThreadLocal();

static class DynamicObject {
  String className; // just the name, without the "main$"
  LinkedHashMap<String,Object> fieldValues = new LinkedHashMap();
  
  DynamicObject() {}
  // className = just the name, without the "main$"
  DynamicObject(String className) {
  this.className = className;}
}

static class Var<A> {
  A v; // you can access this directly if you use one thread
  
  Var() {}
  Var(A v) {
  this.v = v;}
  
  synchronized void set(A a) {
    if (v != a) {
      v = a;
      notifyAll();
    }
  }
  
  synchronized A get() { return v; }
  synchronized boolean has() { return v != null; }
  synchronized void clear() { v = null; }
}

// a Lisp-like form
static class Lisp implements Iterable<Lisp> {
  String head;
  List<Lisp> args = new ArrayList();
  
  Object more; // additional info, user-defined
  
  Lisp() {}
  Lisp(String head) {
  this.head = head;}
  Lisp(String head, Lisp... args) {
  this.head = head;
    this.args.addAll(asList(args));
  }
  Lisp(String head, Collection args) {
  this.head = head;
    for (Object arg : args) add(arg);
  }
  
  // INEFFICIENT
  public String toString() {
    if (args.isEmpty())
      return quoteIfNotIdentifier(head);
    List<String> bla = new ArrayList();
    for (Lisp a : args)
      bla.add(a.toString());
    String inner = join(", ", bla);
    if (head.equals(""))
      return "{" + inner + "}"; // list
    else
      return quoteIfNotIdentifier(head) + "(" + inner + ")";
  }

  String raw() {
    if (!isEmpty ()) throw fail("not raw: " + this);
    return head;
  }
  
  Lisp add(Lisp l) {
    args.add(l);
    return this;
  }
  
  Lisp add(String s) {
    args.add(new Lisp(s));
    return this;
  }
  
  Lisp add(Object o) {
    if (o instanceof Lisp) add((Lisp) o);
    else if (o instanceof String) add((String) o);
    else throw fail("Bad argument type: " + structure(o));
    return this;
  }
  
  int size() {
    return args.size();
  }
  
  boolean empty() { return args.isEmpty(); }
  boolean isEmpty() { return args.isEmpty(); }
  boolean isLeaf() { return args.isEmpty(); }
  
  Lisp get(int i) {
    return main.get(args, i);
  }
  
  String getString(int i) { Lisp a = get(i); return a == null ? null : a.head; }
  
  String s(int i) { return getString(i); }
  String rawOrNull(int i) {
    Lisp a = get(i); return a != null && a.isLeaf() ? a.head : null;
  }
  String raw(int i) { return assertNotNull(rawOrNull(i)); }
  boolean isLeaf(int i) { return rawOrNull(i) != null; }
  
  boolean isA(String head) {
    return eq(head, this.head);
  }

  boolean is(String head, int size) {
    return isA(head) && size() == size;
  }
  
  boolean is(String head) { return isA(head); }
  boolean headIs(String head) { return isA(head); }
  
  boolean is(String... heads) {
    return asList(heads).contains(head);
  }
  
  // check head for one of these (ignore case)
  boolean isic(String... heads) {
    return containsIgnoreCase(heads, head);
  }
  
  public Iterator<Lisp> iterator() {
    return args.iterator();
  }
  
  Lisp subList(int fromIndex, int toIndex) {
    Lisp l = new Lisp(head);
    l.args.addAll(args.subList(fromIndex, toIndex)); // better to copy here I guess - safe
    return l;
  }

  public boolean equals(Object o) {
    if (o == null || o.getClass() != Lisp.class) return false;
    Lisp l = (Lisp) ( o);
    return eq(head, l.head) && eq(args, l.args);
  }
  
  public int hashCode() {
    return head.hashCode() + args.hashCode();
  }
  
  Lisp addAll(List args) {
    for (Object arg : args) add(arg);
    return this;
  }
  
  String unquoted() { return unquote(raw()); }
  String unq() { return unquoted(); }
  
  // heads of arguments
  List<String> heads() { return collect(args, "head"); }
}


static class Matches {
  String[] m;
  
  Matches() {}
  Matches(String... m) {
  this.m = m;}
  
  String get(int i) { return i < m.length ? m[i] : null; }
  String unq(int i) { return unquote(get(i)); }
  String fsi(int i) { return formatSnippetID(unq(i)); }
  String fsi() { return fsi(0); }
  String tlc(int i) { return unq(i).toLowerCase(); }
  boolean bool(int i) { return "true".equals(unq(i)); }
  String rest() { return m[m.length-1]; } // for matchStart
  int psi(int i) { return Integer.parseInt(unq(i)); }
}



// A concept should be an object, not just a string.

static int concepts_internStringsLongerThan = 10;
static ThreadLocal<Boolean> concepts_unlisted = new ThreadLocal();

static interface Derefable {
  Concept get();
}

static class Concepts {
  Map<Long, Concept> concepts = synchroTreeMap();
  HashMap<Class,Object> perClassData = new HashMap();
  String programID; // set to "-" for non-persistent (possibly not implemented)
  long idCounter;
  volatile long changes = 1, changesWritten;
  volatile java.util.Timer autoSaver;
  volatile boolean savingConcepts;
  int autoSaveInterval = -1000; // 1 second + wait logic
  boolean useGZIP = true, quietSave;
  ReentrantLock lock = new ReentrantLock(true);
  ReentrantLock saverLock = new ReentrantLock(true);
  long lastSaveTook, lastSaveWas;
  float maxAutoSavePercentage = 10;
  
  Concepts() {}
  Concepts(String programID) {
  this.programID = programID;}
  
  synchronized long internalID() {
    do {
      ++idCounter;
    } while (hasConcept(idCounter));
    return idCounter;
  }
  
  void initProgramID() {
    if (programID == null)
      programID = getDBProgramID();
  }
  
  // Now tries to load from bot first, then go to disk.
  Concepts load() {
    return load(false);
  }
  
  Concepts safeLoad() {
    return load(true);
  }
  
  Concepts load(boolean allDynamic) {
    initProgramID();
    if (tryToGrab(allDynamic)) return this;
    return loadFromDisk(allDynamic);
  }
  
  Concepts loadFromDisk() { return loadFromDisk(false); }
  
  Concepts loadFromDisk(boolean allDynamic) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      long time = now();
      Map<Long, Concept> _concepts = concepts; // empty map
      readLocally2_allDynamic.set(allDynamic);
      readLocally2(this, programID, "concepts");
      Map<Long, Concept> __concepts = concepts;
      concepts = _concepts;
      concepts.putAll(__concepts);
      int l = readLocally_stringLength;
      int tokrefs = unstructure_tokrefs;
      assignConceptsToUs();
      done("Loaded " + n(l(concepts), "concepts"), time);
      readLocally2(this, programID, "idCounter");
    } finally {
      DynamicObject_loading.set(null);
    }
    allChanged();
    return this;
  }
  
  Concepts loadConcepts() { return load(); }
  
  boolean tryToGrab(boolean allDynamic) {
    if (sameSnippetID(programID, getDBProgramID())) return false;
    RemoteDB db = connectToDBOpt(programID);
    try {
      if (db != null) {
        loadGrab(db.fullgrab(), allDynamic);
        return true;
      }
    } finally {
      if (db != null) db.close();
    }
    return false;
  }
  
  Concepts load(String grab) {
    return loadGrab(grab, false);
  }
  
  Concepts safeLoad(String grab) {
    return loadGrab(grab, true);
  }
  
  Concepts loadGrab(String grab, boolean allDynamic) {
    clearConcepts();
    DynamicObject_loading.set(true);
    try {
      Map<Long, Concept> map = (Map)
        (allDynamic ? safeUnstructure(grab) : unstructure(grab));
      concepts.putAll(map);
      assignConceptsToUs();
      for (long l : map.keySet())
        idCounter = max(idCounter, l);
    } finally {
      DynamicObject_loading.set(null);
    }
    allChanged();
    return this;
  }
  
  void assignConceptsToUs() {
    for (Concept c : values(concepts)) {
      c._concepts = this;
      callOpt_noArgs(c, "_doneLoading2");
    }
  }

  String progID() {
    return programID == null ? getDBProgramID() : programID;
  }
  
  Concept getConcept(String id) {
    return empty(id) ? null : getConcept(parseLong(id));
  }
  
  Concept getConcept(long id) {
    return (Concept) concepts.get((long) id);
  }
  
  Concept getConcept(RC ref) {
    return ref == null ? null : getConcept(ref.longID());
  }
  
  boolean hasConcept(long id) {
    return concepts.containsKey((long) id);
  }
  
  void deleteConcept(long id) {
    Concept c = getConcept(id);
    if (c == null)
      print("Concept " + id + " not found");
    else
      c.delete();
  }
  
  void saveConceptsIfDirty() { saveConcepts(); }
  void save() { saveConcepts(); }

  void saveConcepts() {
    initProgramID();
    saverLock.lock();
    savingConcepts = true;
    long start = now(), time;
    try {
      String s = null;
      //synchronized(main.class) {
      File f = getProgramFile(programID, useGZIP ? "concepts.structure.gz" : "concepts.structure");
      long _changes = changes;
      if (_changes == changesWritten) return;
      
      lock.lock();
      long fullTime = now();
      try {
        saveLocally2(this, programID, "idCounter");
        
        if (useGZIP) {
          saveGZStructureToFile(f, cloneMap(concepts));
          getProgramFile(programID, "concepts.structure").delete();
        } else
          s = structure(cloneMap(concepts));
      } finally {
        lock.unlock();
      }

      changesWritten = _changes; // only update when structure didn't fail
      
      if (!useGZIP) {
        time = now()-start;
        if (!quietSave)
          print("Saving " + toM(l(s)) + "M chars (" /*+ changesWritten + ", "*/ + time + " ms)");
        start = now();
        saveTextFile(f, javaTokWordWrap(s));
        getProgramFile(programID, "concepts.structure.gz").delete();
      }
      
      copyFile(f, getProgramFile(programID, "concepts.structure" + (useGZIP ? ".gz" : "") + ".backup" + ymd() + "-" + formatInt(hours(), 2)));
      time = now()-start;
      if (!quietSave)
        print(programID + ": Saved " + toK(f.length()) + " K, " + n(concepts, "concepts") + " (" + time + " ms)");
      lastSaveWas = fullTime;
      lastSaveTook = now()-fullTime;
    } finally {
      savingConcepts = false;
      saverLock.unlock();
    }
  }
  
  void _autoSaveConcepts() {
    if (autoSaveInterval < 0 && maxAutoSavePercentage != 0) {
      long pivotTime = Math.round(lastSaveWas+lastSaveTook*100.0/maxAutoSavePercentage);
      if (now() < pivotTime) {
        //print("Skipping auto-save (last save took " + lastSaveTook + ")");
        return;
      }
    }
    saveConcepts();
  }
  
  void clearConcepts() {
    concepts.clear();
    allChanged();
  }
  
  synchronized void allChanged() {
    ++changes;
  }
  
  // auto-save every second if dirty
  synchronized void autoSaveConcepts() {
    if (autoSaver == null) {
      if (isTransient()) throw fail("Can't persist transient database");
      autoSaver = doEvery_daemon(abs(autoSaveInterval), new Runnable() { public void run() { try {  _autoSaveConcepts() ;
} catch (Exception __e) { throw rethrow(__e); } }  public String toString() { return "_autoSaveConcepts()"; }});
      // print("Installed auto-saver (" + autoSaveInterval + " ms, " + progID() + ")");
    }
  }
  
  void cleanMeUp() {
    if (autoSaver != null) {
      autoSaver.cancel();
      autoSaver = null;
      while (savingConcepts) sleepInCleanUp(10);
      saveConceptsIfDirty();
    }
  }
  
  Map<Long, String> getIDsAndNames() {
    Map<Long,String> map = new HashMap();
    Map<Long, Concept> cloned = cloneMap(concepts);
    for (long id : keys(cloned)) 
      map.put(id, cloned.get(id).className);
    return map;
  }
  
  void deleteConcepts(List l) {
    for (Object o : l)
      if (o instanceof Long)
        concepts.remove((Long) o);
      else if (o instanceof Concept)
        ((Concept) o).delete();
      else
        warn("Can't delete " + getClassName(o));
  }
  
  <A extends Concept> A conceptOfType(Class<A> type) {
    return firstOfType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> conceptsOfType(Class<A> type) {
    return filterByType(allConcepts(), type);
  }
  
  <A extends Concept> List<A> listConcepts(Class<A> type) {
    return conceptsOfType(type);
  }
  
  <A extends Concept> List<A> list(Class<A> type) {
    return conceptsOfType(type);
  }
  
  List<Concept> list(String type) {
    return conceptsOfType(type);
  }
  
  List<Concept> conceptsOfType(String type) {
    return filterByDynamicType(allConcepts(), "main$" + type);
  }
  
  boolean hasConceptOfType(Class<? extends Concept> type) {
    return hasType(allConcepts(), type);
  }
  
  void persistConcepts() {
    loadConcepts();
    autoSaveConcepts();
  }
  
  // We love synonyms
  void conceptPersistence() {
    persistConcepts();
  }
  
  void persist() { persistConcepts(); }
  void persist(int interval) { autoSaveInterval = interval; persist(); }
    
  // Runs r if there is no concept of that type
  <A extends Concept> A ensureHas(Class<A> c, Runnable r) {
    A a = conceptOfType(c);
    if (a == null) {
      r.run();
      a = conceptOfType(c);
      if (a == null)
        throw fail("Concept not made by " + r + ": " + shortClassName(c));
    }
    return a;
  }
  
  // Ensures that every concept of type c1 is ref'd by a concept of
  // type c2.
  // Type of func: voidfunc(concept)
  void ensureHas(Class<? extends Concept> c1, Class<? extends Concept> c2, Object func) {
    for (Concept a : conceptsOfType(c1)) {
      Concept b = findBackRef(a, c2);
      if (b == null) {
        callF(func, a);
        b = findBackRef(a, c2);
        if (b == null)
          throw fail("Concept not made by " + func + ": " + shortClassName(c2));
      }
    }
  }
  
  // Type of func: voidfunc(concept)
  void forEvery(Class<? extends Concept> type, Object func) {
    for (Concept c : conceptsOfType(type))
      callF(func, c);
  }
  
  int deleteAll(Class<? extends Concept> type) {
    List<Concept> l = (List) conceptsOfType(type);
    for (Concept c : l) c.delete();
    return l(l);
  }
  
  Collection<Concept> allConcepts() {
    synchronized(concepts) {
      return new ArrayList(values(concepts));
    }
  }
  
  <A extends Concept> int countConcepts(Class<A> c, Object... params) {
    int n = 0;
    for (A x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts(String c, Object... params) {
    int n = 0;
    for (Concept x : list(c)) if (checkConceptFields(x, params)) ++n;
    return n;
  }

  int countConcepts() {
    return l(concepts);
  }  
  
  // inter-process methods
  
  RC xnew(String name, Object... values) {
    return new RC(cnew(name, values));
  }
  
  void xset(long id, String field, Object value) {
    xset(new RC(id), field, value);
  }
  
  void xset(RC c, String field, Object value) {
    if (value instanceof RC)
      value = getConcept((RC) value);
    cset(getConcept(c), field, value);
  }
  
  Object xget(long id, String field) {
    return xget(new RC(id), field);
  }
  
  Object xget(RC c, String field) {
    return xgetPost(cget(getConcept(c), field));
  }
  
  Object xgetPost(Object o) {
    o = deref(o);
    if (o instanceof Concept)
      return new RC((Concept) o);
    return o;
  }
  
  void xdelete(long id) {
    xdelete(new RC(id));
  }
  
  void xdelete(RC c) {
    getConcept(c).delete();
  }
  
  void xdelete(List<RC> l) {
    for (RC c : l)
      xdelete(c);
  }
  
  List<RC> xlist() {
    return map("toPassRef", allConcepts());
  }
  
  List<RC> xlist(String className) {
    return map("toPassRef", conceptsOfType(className));
  }
  
  boolean isTransient() { return eq(programID, "-"); }
  
  String xfullgrab() {
    lock.lock();
    try {
      if (changes == changesWritten && !isTransient())
        return loadConceptsStructure(programID);
      return structure(cloneMap(concepts));
    } finally {
      lock.unlock();
    }
  }
  
  void xshutdown() {
    // Killing whole VM if someone wants this DB to shut down
    cleanKillVM();
  }
  
  long xchangeCount() { return changes; }
  int xcount() { return countConcepts(); }
  
  void register(Concept c) {
    if (c._concepts == this) return;
    if (c._concepts != null) throw fail("Can't re-register");
    c._concepts = this;
    c.id = internalID();
    c.created = now();
    concepts.put((long) c.id, c);
    c.change();
  }
  
} // class Concepts

static volatile Concepts mainConcepts = new Concepts(); // Where we create new concepts

static class Concept extends DynamicObject {
  transient Concepts _concepts; // Where we belong
  long id;
  //O madeBy;
  //double energy;
  //bool defunct;
  long created;
  
  // used only internally (cnew)
  Concept(String className) {
    super(className);
    _created();
  }
  
  Concept() {
    if (!_loading()) {
      //className = shortClassName(this); // XXX - necessary?
      //print("New concept of type " + className);
      _created();
    }
  }
  
  List<Ref> refs;
  List<Ref> backRefs;
  
  static boolean loading() { return _loading(); }
  static boolean _loading() { return isTrue(DynamicObject_loading.get()); }

  void _created() {
    if (!isTrue(concepts_unlisted.get())) mainConcepts.register(this);
  }
  
  void put(String field, Object value) {
    fieldValues.put(field, value);
    change();
  }
  
  Object get(String field) {
    return fieldValues.get(field);
  }
  
  class Ref<A extends Concept> {
    A value;
    
    Ref() {
      if (!isTrue(DynamicObject_loading.get())) refs = addDyn(refs, this);
    }
    
    Ref(A value) {
  this.value = value;
      refs = addDyn(refs, this);
      index();
    }
    
    // get owning concept (source)
    Concept concept() {
      return Concept.this;
    }
    
    // get target
    A get() { return value; }
    boolean has() { return value != null; }
    
    void set(A a) {
      if (a == value) return;
      unindex();
      value = a;
      index();
    }
    
    void set(Ref<A> ref) { set(ref.get()); }
    void clear() { set((A) null); }
    
    void index() { 
      if (value != null)
        value.backRefs = addDyn(value.backRefs, this);
      change();
    }
    
    void unindex() {
      if (value != null)
        value.backRefs = removeDyn(value.backRefs, this);
    }
    
    void change() {
      Concept.this.change();
    }
  }
  
  class RefL<A extends Concept> extends AbstractList<A> {
    List < Ref < A > > l = new ArrayList();
    
    public A set(int i, A o) {
      A prev = l.get(i).get();
      l.get(i).set(o);
      return prev;
    }
    
    public void add(int i, A o) {
      l.add(i, new Ref(o));
    }
    
    public A get(int i) {
      return l.get(i).get();
    }
    
    public A remove(int i) {
      return l.remove(i).get();
    }
    
    public int size() {
      return l.size();
    }
    
    public boolean contains(Object o) {
      if (o instanceof Concept)
        for (Ref<A> r : l) if (eq(r.get(), o)) return true;
      return super.contains(o);
    }
  }
  
  void delete() {
    //name = "[defunct " + name + "]";
    //defunct = true;
    //energy = 0;
    for (Ref r : refs)
      r.unindex();
    refs = null;
    for (Ref r : cloneList(backRefs))
      r.set((Concept) null);
    backRefs = null;
    
    if (_concepts != null) {
      _concepts.concepts.remove((long) id);
      change();
      _concepts = null;
    }
    id = 0;
  }
  
  BaseXRef export() {
    return new BaseXRef(_concepts.progID(), id);
  }
  
  // notice system of a change in this object
  void change() {
    if (_concepts != null) _concepts.allChanged();
  }
  
  String _programID() {
    return _concepts == null ? getDBProgramID() : _concepts.progID();
  }
} // class Concept

// remote reference (for inter-process communication or
// external databases). Formerly "PassRef".
// prepared for string ids if we do them later
static class RC {
  transient Object owner;
  String id;
  
  RC() {} // make serialisation happy
  RC(long id) { this.id = str(id); }
  RC(Object owner, long id) { this.id = str(id); this.owner = owner; }
  RC(Concept c) { this(c.id); }
  long longID() { return parseLong(id); }
  
  public String toString() {
    return id;
  }

  transient RemoteDB db;
  
  String getString(String field) { return db.xS(this, field); }
  Object get(String field) { return db.xget(this, field); }
  void set(String field, Object value) { db.xset(this, field, value); }

}

// Reference to a concept in another program
static class BaseXRef {
  String programID;
  long id;
    
  BaseXRef() {}
  BaseXRef(String programID, long id) {
  this.id = id;
  this.programID = programID;}
  
  public boolean equals(Object o) {
    if (!(o instanceof BaseXRef)) return false;
    BaseXRef r = (BaseXRef) ( o);
    return eq(programID, r.programID) && eq(id, r.id);
  }
  
  public int hashCode() {
    return programID.hashCode() + (int) id;
  }
}

// BaseXRef as a concept
static class XRef extends Concept {
  BaseXRef ref;
  
  XRef() {}
  XRef(BaseXRef ref) {
  this.ref = ref; _doneLoading2(); }
  
  // after we have been added to concepts
  void _doneLoading2() {
    getIndex().put(ref, this);
  }
    
  HashMap<BaseXRef, XRef> getIndex() {
    return getXRefIndex(_concepts);
  }
}

static synchronized HashMap<BaseXRef, XRef> getXRefIndex(Concepts concepts) {
  HashMap cache = (HashMap) concepts.perClassData.get(XRef.class);
  if (cache == null)
    concepts.perClassData.put(XRef.class, cache = new HashMap());
  return cache;
}

// uses mainConcepts
static XRef lookupOrCreateXRef(BaseXRef ref) {
  XRef xref = getXRefIndex(mainConcepts).get(ref);
  if (xref == null)
    xref = new XRef(ref);
  return xref;
}

// define standard concept functions to use main concepts

static <A extends Concept> List<A> list(Class<A> type) {
  return mainConcepts.list(type);
}

static <A extends Concept> List<A> list(Concepts concepts, Class<A> type) {
  return concepts.list(type);
}

static List<Concept> list(String type) {
  return mainConcepts.list(type);
}

static List<Concept> list(Concepts concepts, String type) {
  return concepts.list(type);
}

static int csetAll(Concept c, Object... values) {
  return cset(c, values);
}

// returns number of changes
static int cset(Concept c, Object... values) { try {
  int changes = 0;
  values = expandParams(c.getClass(), values);
  warnIfOddCount(values);
  for (int i = 0; i+1 < l(values); i += 2) {
    String field = (String) values[i];
    Object value = values[i+1];
    Field f = setOpt_findField(c.getClass(), field);
    //print("cset: " + c.id + " " + field + " " + struct(value) + " " + f);
    if (value instanceof RC) value = c._concepts.getConcept((RC) value);
    value = deref(value);
    
    if (value instanceof String && l((String) value) >= concepts_internStringsLongerThan) value = ((String) value).intern();
    
    if (f == null) {
      // TODO: keep ref if it exists
      c.fieldValues.put(field, value instanceof Concept ? c.new Ref((Concept) value) : value);
      c.change();
    } else if (isSubtypeOf(f.getType(), Concept.Ref.class)) {
      ((Concept.Ref) f.get(c)).set((Concept) derefRef(value));
      c.change(); ++changes;
    } else {
      Object old = f.get(c);
      if (neq(value, old)) {
        f.set(c, value);
        c.change(); ++changes;
      }
    }
  }
  return changes;
} catch (Exception __e) { throw rethrow(__e); } }

static void cleanMeUp_concepts() {
  mainConcepts.cleanMeUp();
}

static void loadAndAutoSaveConcepts() {
  mainConcepts.persist();
}

static void loadAndAutoSaveConcepts(int interval) {
  mainConcepts.persist(interval);
}

static void loadConceptsFrom(String progID) {
  mainConcepts.programID = progID;
  mainConcepts.load();
}

static List<Concept> conceptsOfType(String type) {
  return mainConcepts.conceptsOfType(type);
}

static Collection<Concept> allConcepts() {
  return mainConcepts.allConcepts();
}

static long changeCount() {
  return mainConcepts.changes;
}

static List<String> exposedDBMethods = ll("xlist", "xnew", "xset", "xdelete", "xget", "xclass", "xfullgrab", "xshutdown", "xchangeCount", "xcount");

static RC toPassRef(Concept c) {
  return new RC(c);
}

// so we can instantiate the program to run as a bare DB bot
static void sleep(long ms) {
  ping();
  if (ms < 0) return;
  // allow spin locks
  if (isAWTThread() && ms > 100) throw fail("Should not sleep on AWT thread");
  try {
    Thread.sleep(ms);
  } catch (Exception e) { throw new RuntimeException(e); }
}

static void sleep() { try {
  print("Sleeping.");
  sleepQuietly();
} catch (Exception __e) { throw rethrow(__e); } }
static String quoteIfNotIdentifier(String s) {
  if (s == null) return null;
  return isJavaIdentifier(s) ? s : quote(s);
}
static boolean englishToConceptLanguage_dropPunctuation;

static String englishToConceptLanguage(String s) {
  { String _a_4 = englishToConceptLanguage_simple(s); if (!empty(_a_4)) return _a_4; }
  { String _a_5 = englishToConceptLanguage_xyz(s, null); if (!empty(_a_5)) return _a_5; }
  if (englishToConceptLanguage_dropPunctuation)
    { String _a_6 = englishToConceptLanguage_xyz(s, "dropPunctuation"); if (!empty(_a_6)) return _a_6; }
  return s;
}

static String javaDropComments(String s) {
  List<String> tok = javaTok(s);
  replaceLastElement(tok, "");
  return join(tok);
}
static String getServerTranspiled2(String id) {
  String transpiled = loadCachedTranspilation(id);
  String md5 = null;
  if (isOfflineMode()) return transpiled;
  if (transpiled != null)
    md5 = md5(transpiled);
  String transpiledSrc = getServerTranspiled(formatSnippetID(id), md5);
  if (eq(transpiledSrc, "SAME")) {
    if (!isTrue(loadPage_silent.get())) print("SAME");
    return transpiled;
  }
  return transpiledSrc;
}
static <A> void addAll(Collection<A> c, Collection<A> b) {
  c.addAll(b);
}

static <A> void addAll(Collection<A> c, A... b) {
  c.addAll(Arrays.asList(b));
}
static String getString(Map map, Object key) {
  return map == null ? null : (String) map.get(key);
}

static String getString(List l, int idx) {
  return (String) get(l, idx);
}

static String getString(Object o, Object key) {
  if (o instanceof Map) return getString((Map) o, key);
  if (key instanceof String)
    return (String) getOpt(o, (String) key);
  throw fail("Not a string key: " + getClassName(key));
}
// will create the file or update its last modified timestamp
static void touchFile(File file) { try {
  closeRandomAccessFile(newRandomAccessFile(mkdirsForFile(file), "rw"));
} catch (Exception __e) { throw rethrow(__e); } }
static Throwable printStackTrace2(Throwable e) {
  // we go to system.out now - system.err is nonsense
  print(getStackTrace2(e));
  return e;
}

static void printStackTrace2() {
  printStackTrace2(new Throwable());
}

static void printStackTrace2(String msg) {
  printStackTrace2(new Throwable(msg));
}

static void printStackTrace2(String indent, Throwable e) {
  if (endsWithLetter(indent)) indent += " ";
  printIndent(indent, getStackTrace2(e));
}
static <A, B> void put(Map<A, B> map, A a, B b) {
  if (map != null) map.put(a, b);
}
static boolean loadTruth_fastLoad;

static List<Statement> loadTruth() {
  if (loadTruth_fastLoad) return fastLoadStatements();
  return list(new Concepts("#1007236").load(), Statement.class);
}
static void typeWriterConsole() {
  if (isHeadless()) return;
  Font f = typeWriterFont();
  consoleFont(f);
  consoleInputFont(f);
}
static AIConcept fastLoadAIConcept(Object o) {
  AIConcept c = unlisted(AIConcept.class);
  copyFields(o, c, "id", "globalID", "importedFrom", "originatingUniverse", "exportable", "imageMD5", "suggestedImageMD5", "searchedForSuggestedImage", "imported", "touched", "created", "name", "comment");
  c.pngFile.set(fastLoadPNGFile(get(get(o, "pngFile"), "value")));
  c.suggestedImage.set(fastLoadPNGFile(get(get(o, "suggestedImage"), "value")));
  return c;
}
static String fsi(String id) {
  return formatSnippetID(id);
}
static File getCacheProgramDir() {
  return getCacheProgramDir(getProgramID());
}

static File getCacheProgramDir(String snippetID) {
  return new File(userHome(), "JavaX-Caches/" + formatSnippetIDOpt(snippetID));
}
static List filter(Iterable c, Object pred) {
  List x = new ArrayList();
  for (Object o : c)
    if (isTrue(callF(pred, o)))
      x.add(o);
  return x;
}

static List filter(Object pred, Iterable c) {
  return filter(c, pred);
}

static boolean equals(Object a, Object b) {
  return a == null ? b == null : a.equals(b);
}
static Map<String, LispStatement> statementsToLisp(List<Statement> l) {
  Map<String,LispStatement> map = new HashMap();
  for (Statement s : l)
    map.put(s.globalID, new LispStatement(s.globalID, clParse(s.text)));
  return map;
}
static Object pcallF(Object f, Object... args) {
  return pcallFunction(f, args);
}
static RuntimeException rethrow(Throwable e) {
  throw asRuntimeException(e);
}
static boolean isMD5(String s) {
  return l(s) == 32 && isLowerHexString(s);
}
static File javaCompileToJar_standard(String src, File destJar) {
  return javaCompileToJar_standard(src, "", destJar);
}

// returns path to jar
static synchronized File javaCompileToJar_standard(String src, String dehlibs, File destJar) {
  String javaTarget = null; // use default target
  
  print("Compiling " + l(src) + " chars");
  String md5 = md5(src);
  File jar = destJar;

  Class j = getJavaX();
  if (javaTarget != null)
    setOpt(j, "javaTarget", javaTarget);
  //setOpt(j, "verbose", true);
  File srcDir = (File) ( call(j, "TempDirMaker_make"));
  String className = "main";
  String fileName = className + ".java";
  File mainJava = new File(srcDir, fileName);
  //print("main java: " + mainJava.getAbsolutePath());
  saveTextFile(mainJava, src);
  File classesDir = (File) call(j, "TempDirMaker_make");
  List<File> libraries = new ArrayList();
  
  Matcher m = Pattern.compile("\\d+").matcher(dehlibs);
  while (m.find()) {
    String libID = m.group();
    //print("libID=" + quote(libID));
    assertTrue(isSnippetID(libID));
    libraries.add(loadLibrary(libID));
  }
    
  String compilerOutput;
  try {
    compilerOutput = (String) call(j, "compileJava", srcDir, libraries, classesDir);
  } catch (Throwable e) {
    compilerOutput = (String) get(getJavaX(), "javaCompilerOutput");
    throw fail("Compile Error. " + compilerOutput + " " + e);
  }
  
  if (nempty(compilerOutput)) {
    print("Compiler said: " + compilerOutput);
    //fail("Compile Error. " + compilerOutput);
  }

  // sanity test
  if (!new File(classesDir, className + ".class").exists())
    throw fail("No class generated (" + className + ")");
      
  // add sources to .jar
  saveTextFile(new File(classesDir, "main.java"), src);
  
  // add information about libraries to jar
  if (nempty(dehlibs))
    saveTextFile(new File(classesDir, "libraries"), dehlibs);

  //print("Zipping: " + classesDir.getAbsolutePath() + " to " + jar.getAbsolutePath());
  dir2zip_recurse_verbose = false;
  int n = dir2zip_recurse(classesDir, jar); // cache on success only
  //print("Files zipped: " + n);

  return jar;
}



static Font typeWriterFont() {
  return typeWriterFont(14);
}
  
static Font typeWriterFont(int size) {
  return new Font("Courier", Font.PLAIN, size);
}
static boolean isLowerHexString(String s) {
  for (int i = 0; i < l(s); i++) {
    char c = s.charAt(i);
    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
      // ok
    } else
      return false;
  }
  return true;
}
static String englishToConceptLanguage_simple(String s) {
  for (AIConcept c : englishToConceptLanguage_concepts())
    if (!javaTokC(c.name).contains("*") && match_noEllipsis(c.name, s))
      return c.globalID;
  return null;
}

static void copyFields(Object x, Object y, String... fields) {
  if (empty(fields)) { // assume we should copy all fields
    Map<String, Object> map = objectToMap(x);
    for (String field : map.keySet())
      setOpt(y, field, map.get(field));
  } else 
    for (String field : fields) {
      Object o = getOpt(x, field);
      if (o != null)
        setOpt(y, field, o);
    }
}
static void closeRandomAccessFile(RandomAccessFile f) {
  if (f != null) try {
    f.close();
    callJavaX("dropIO", f);
  } catch (Throwable e) {
    printStackTrace(e);
  }
}
static boolean englishToConceptLanguage_xyz_debug, englishToConceptLanguage_useBrackets = true;

static ThreadLocal<Integer> englishToConceptLanguage_xyz_level = new ThreadLocal();

static String englishToConceptLanguage_xyz(String s, Object preprocess) {
  assertNotNull("Input", s);
  /*int level = englishToConceptLanguage_xyz_level.get();
  if (level >= englishToConceptLanguage_xyz_maxLevel) fail("max level");
  englishToConceptLanguage_xyz_level.set(level+1);
  try {*/
  s = postProcess(preprocess, s);
  
  // pattern matching all concepts against full string
  for (AIConcept c : englishToConceptLanguage_concepts()) {
    if (empty(c.name)) {
      print("Warning, empty name: " + c.globalID);
      continue;
    }
    String name = postProcess(preprocess, c.name);
    { String _a_7 = englishToConceptLanguage_xyz_with(c.globalID, name, s); if (!empty(_a_7)) return _a_7; }
  }
  
  // no full string match. go word by word
  List<String> tok = javaTok(s);
  if (l(tok) <= 3) return null;
  for (int i = 1; i < l(tok); i += 2) {
    String x = englishToConceptLanguage(unquote(tok.get(i)));
    if (nempty(x)) tok.set(i, conceptQuote(x));
  }
  String x = join(tok);
  return eq(x, s) ? null : x;
}

static String englishToConceptLanguage_xyz_sub(String name, String original, String s) {
  if (l(s) >= l(original)) throw fail("Bad sub: " + quote(name) + " " + quote(s));
  String s2 = or2(englishToConceptLanguage(s), s);
  if (englishToConceptLanguage_xyz_debug)
    print("xyz_sub " + quote(s) + " => " + quote(s2));
  if (englishToConceptLanguage_useBrackets)
    return isIdentifier(s2) || isInteger(s2) || isProperlyQuoted(s2) ? s2 : "(" + s2 + ")";
  return conceptQuote(s2);
}

static String englishToConceptLanguage_xyz_with(String id, String s) {
  return englishToConceptLanguage_xyz_with(getAIConcept(id), s);
}

static String englishToConceptLanguage_xyz_with(AIConcept c, String s) {
  if (c == null) return null;
  return englishToConceptLanguage_xyz_with(c.globalID, c.name, s);
}

static String englishToConceptLanguage_xyz_with(String id, String name, String s) {
  Matches m = new Matches();
  List<String> tok = javaTokC(name);
  if (l(tok) < 2) return null;
  //replace(tok, "*", "\\*");
  if (tok.contains("*")) return null;
  int n = numberOfXYZVars_c(tok);
  if (n == 0) return null;
  String pat = formatXYZ(name, rep(n, "*"));
  boolean yes = flexMatchIC2(pat, s, m, false);
  if (englishToConceptLanguage_xyz_debug && yes)
    print("xyz: " + n + " " + pat + " - " + s + " => " + (yes ? struct(m) : "-"));
  if (!yes) return null;
  if (n != l(m.m)) return null;
  TreeMap<Integer,String> map = new TreeMap();
  for (int i = 0; i < l(tok); i++) {
    int x = xyzVarToIndex(tok.get(i));
    if (x != 0)
      map.put(i, englishToConceptLanguage_xyz_sub(name, s, m.m[x-1]));
  }
  return aiUsing(id) + " " + join(" ", values(map));
}
static String loadCachedTranspilation(String id) {
  return loadTextFile(new File(getCodeProgramDir(id), "Transpilation"));
}

static RandomAccessFile newRandomAccessFile(File path, String mode) throws IOException {
  RandomAccessFile f = new RandomAccessFile(path, mode);
  callJavaX("registerIO", f, path, mode.indexOf('w') >= 0);
  return f;
}
static boolean isOfflineMode() {
  return eq("1", trim(loadProgramTextFile("#1005806", "offline-mode")));
}
static List<Statement> fastLoadStatements() {
  Class main = getBotMainClass("Truth Table");
  Object concepts = get(main, "mainConcepts");
  return map("fastLoadStatement", (List) call(concepts, "list", "Statement"));
}
  static ThreadLocal<String> loadPage_charset = new ThreadLocal();
  static boolean loadPage_allowGzip = true, loadPage_debug;
  static boolean loadPage_anonymous; // don't send computer ID
  static int loadPage_verboseness = 100000;
  static int loadPage_retries = 60; // seconds
  static ThreadLocal<Boolean> loadPage_silent = new ThreadLocal();

  public static String loadPageSilently(String url) {
    try {
      return loadPageSilently(new URL(loadPage_preprocess(url)));
    } catch (IOException e) { throw new RuntimeException(e); }
  }

  public static String loadPageSilently(URL url) {
    try {
      IOException e = null;
      for (int tries = 0; tries < loadPage_retries; tries++)
        try {
          URLConnection con = openConnection(url);
          return loadPage(con, url);
        } catch (IOException _e) {
          e = _e;
          if (loadPageThroughProxy_enabled) {
            print("Trying proxy because of: " + e);
            try {
              return loadPageThroughProxy(str(url));
            } catch (Throwable e2) {
              print("  " + exceptionToStringShort(e2));
            }
          }
          sleepSeconds(1);
        }
      throw e;
    } catch (IOException e) { throw new RuntimeException(e); }
  }

  static String loadPage_preprocess(String url) {  
    if (url.startsWith("tb/"))
      url = "tinybrain.de:8080/" + url;
    if (url.indexOf("://") < 0)
      url = "http://" + url;
    return url;
  }
  
  public static String loadPage(String url) {
    try {
      url = loadPage_preprocess(url);
      if (!isTrue(loadPage_silent.get()))
        print("Loading: " + hideCredentials(url));
      return loadPageSilently(new URL(url));
    } catch (IOException e) { throw new RuntimeException(e); }
  }
  
  public static String loadPage(URL url) {
    print("Loading: " + hideCredentials(url.toExternalForm()));
    return loadPageSilently(url);
  }

  public static String loadPage(URLConnection con, URL url) throws IOException {
    try {
      if (!loadPage_anonymous)
        setHeaders(con);
      if (loadPage_allowGzip)
        con.setRequestProperty("Accept-Encoding", "gzip");
    } catch (Throwable e) {} // fails if within doPost
    String contentType = con.getContentType();
    if (contentType == null)
      throw new IOException("Page could not be read: " + url);
    //print("Content-Type: " + contentType);
    String charset = loadPage_charset == null ? null : loadPage_charset.get();
    if (charset == null) charset = loadPage_guessCharset(contentType);
    
    InputStream in = con.getInputStream();
    if ("gzip".equals(con.getContentEncoding())) {
      if (loadPage_debug)
        print("loadPage: Using gzip.");
      in = new GZIPInputStream(in);
    }
    Reader r = new InputStreamReader(in, charset);
    
    StringBuilder buf = new StringBuilder();
    int n = 0;
    while (true) {
      int ch = r.read();
      if (ch < 0)
        break;
      buf.append((char) ch);
      ++n;
      if ((n % loadPage_verboseness) == 0) print("  " + n + " chars read");
    }
    return buf.toString();
  }
  
  static String loadPage_guessCharset(String contentType) {
    Pattern p = Pattern.compile("text/[a-z]+;\\s+charset=([^\\s]+)\\s*");
    Matcher m = p.matcher(contentType);
    String match = m.matches() ? m.group(1) : null;
    if (loadPage_debug)
      print("loadPage: contentType=" + contentType + ", match: " + match);
    /* If Content-Type doesn't match this pre-conception, choose default and hope for the best. */
    return or(match, "ISO-8859-1");
  }

static void sleepQuietly() { try {
  assertFalse(isAWTThread());
  synchronized(main.class) { main.class.wait(); }
} catch (Exception __e) { throw rethrow(__e); } }
static Lisp clParse(String s) {
  List<String> tok = tok_groupRoundBrackets(s);
  if (l(tok) == 1) return null;
  Lisp l = lisp(unquote(tok.get(1)));
  for (int i = 3; i < l(tok); i += 2) {
    String t = tok.get(i);
    if (t.startsWith("(") && t.endsWith(")"))
      l.add(assertNotNull(clParse(dropFirstAndLast(t))));
    else
      l.add(lisp(aiUsing(unquote(t))));
  }
  return l;
}

static List<Lisp> clParse(List<String> l) {
  return map("clParse", l);
}
static String programID;

static String getProgramID() {
  return nempty(programID) ? formatSnippetIDOpt(programID) : "?";
}

// TODO: ask JavaX instead
static String getProgramID(Class c) {
  String id = (String) getOpt(c, "programID");
  if (nempty(id))
    return formatSnippetID(id);
  return "?";
}

static String getProgramID(Object o) {
  return getProgramID(getMainClass(o));
}
static boolean dir2zip_recurse_verbose;

static int dir2zip_recurse(File inDir, File zip) {
  return dir2zip_recurse(inDir, zip, "");
}

// TODO: the zero files case?
static int dir2zip_recurse(File inDir, File zip, String outPrefix) { try {
  mkdirsForFile(zip);
  FileOutputStream fout = newFileOutputStream(zip);
  ZipOutputStream outZip = new ZipOutputStream(fout);
  try {
    return dir2zip_recurse(inDir, outZip, outPrefix, 0);
  } finally {
    outZip.close();
  }
} catch (Exception __e) { throw rethrow(__e); } }

static int dir2zip_recurse(File inDir, ZipOutputStream outZip, String outPrefix, int level) { try {
  if (++level >= 20) throw fail("woot? 20 levels in zip?");
  
  List<File> files = new ArrayList();
  for (File f : listFiles(inDir))
    files.add(f);

  int n = 0;
  sortFilesByName(files);
  for (File f : files) {
    if (f.isDirectory()) {
      print("dir2zip_recurse: Scanning " + f.getAbsolutePath());
      n += dir2zip_recurse(f, outZip, outPrefix + f.getName() + "/", level);
    } else {
      if (dir2zip_recurse_verbose) print("Copying " + f.getName());
      outZip.putNextEntry(new ZipEntry(outPrefix + f.getName()));
      InputStream fin = new FileInputStream(f);
      copyStream(fin, outZip);
      fin.close();
      ++n;
    }
  }
  return n;
} catch (Exception __e) { throw rethrow(__e); } }

static String getServerTranspiled(String snippetID) {
  return getServerTranspiled(snippetID, null);
}

// returns "SAME" if md5 matches
static String getServerTranspiled(String snippetID, String expectedMD5) { try {
  long id = parseSnippetID(snippetID);
  /*S t = getTranspilationFromBossBot(id);
  if (t != null) return t;*/
  
  String text = loadPage_utf8("http://tinybrain.de:8080/tb-int/get-transpiled.php?raw=1&withlibs=1&id=" + id + "&utf8=1"
    + (l(expectedMD5) > 1 ? "&md5=" + urlencode(expectedMD5) : "")
    + standardCredentials());
  if (nempty(text) && neq(text, "SAME"))
    saveTranspiledCode(snippetID, text);
  return text;
} catch (Exception __e) { throw rethrow(__e); } }
static PNGFile fastLoadPNGFile(Object o) {
  if (o == null) return null;
  PNGFile p = unlisted(PNGFile.class);
  p.pngPath = getString(o, "pngPath");
  // TODO: p.rect
  return p;
}
static String getStackTrace2(Throwable throwable) {
  StringWriter writer = new StringWriter();
  throwable.printStackTrace(new PrintWriter(writer));
  List<String> lines = toLines(str(writer));
  lines.add(replacePrefix("java.lang.RuntimeException: ", "FAIL: ", first(lines)));
  lines.remove(0);
  return fromLines(lines);
}
  public static boolean isSnippetID(String s) {
    try {
      parseSnippetID(s);
      return true;
    } catch (RuntimeException e) {
      return false;
    }
  }
static Object pcallFunction(Object f, Object... args) {
  try { return callFunction(f, args); } catch (Throwable __e) { printStackTrace2(__e); }
  return null;
}
static String formatSnippetIDOpt(String s) {
  return isSnippetID(s) ? formatSnippetID(s) : s;
}
static void consoleFont(Font font) {
  callOpt(getConsoleTextArea_gen(), "setFont", font);
}
static <A> void replaceLastElement(List<A> l, A a) {
  if (nempty(l))
    l.set(l(l)-1, a);
}
static void consoleInputFont(Font f) {
  JTextField input = consoleInputField();
  if (input != null) {
    input.setFont(f);
    revalidateFrame(input);
  }
}


static String trim(String s) { return s == null ? null : s.trim(); }
static String trim(StringBuilder buf) { return buf.toString().trim(); }
static String trim(StringBuffer buf) { return buf.toString().trim(); }
static String loadPage_utf8(URL url) {
  return loadPage_utf8(url.toString());
}

static String loadPage_utf8(String url) {
  loadPage_charset.set("UTF-8");
  try {
    return loadPage(url);
  } finally {
    loadPage_charset.set(null);
  }
}
static boolean isProperlyQuoted(String s) {
  return s.length() >= 2
    && s.startsWith("\"")
    && s.endsWith("\"")
    && (!s.endsWith("\\\"") || s.endsWith("\\\\\""));
}
static String replacePrefix(String prefix, String replacement, String s) {
  if (!startsWith(s, prefix)) return s;
  return replacement + substring(s, l(prefix));
}
static String exceptionToStringShort(Throwable e) {
  e = getInnerException(e);
  String msg = unnull(e.getMessage());
  if (msg.indexOf("Error") < 0 && msg.indexOf("Exception") < 0)
    return baseClassName(e) + ": " + msg;
  else
    return msg;
}
static void saveTranspiledCode(String progID, String code) {
  saveTextFile(new File(getCodeProgramDir(progID), "Transpilation"), code);
}
static File getCodeProgramDir() {
  return getCodeProgramDir(getProgramID());
}

static File getCodeProgramDir(String snippetID) {
  return new File(javaxCodeDir(), formatSnippetID(snippetID));
}

static File getCodeProgramDir(long snippetID) {
  return getCodeProgramDir(formatSnippetID(snippetID));
}
static URLConnection openConnection(URL url) { try {
  ping();
  return url.openConnection();
} catch (Exception __e) { throw rethrow(__e); } }
static String urlencode(String x) {
  try {
    return URLEncoder.encode(unnull(x), "UTF-8");
  } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
}
static Object getConsoleTextArea_gen() {
  return getOpt(get(getJavaX(), "console"), "textArea");
}
static boolean match_noEllipsis(String pat, String s) {
  return match_noEllipsis(pat, s, null);
}

static boolean match_noEllipsis(String pat, String s, Matches matches) {
  String[] m = match2_match(parse3(pat), parse3_cached(s));
  if (m == null) return false;
  if (matches != null) matches.m = m; return true;
}
static File[] listFiles(File dir) {
  File[] files = dir.listFiles();
  return files == null ? new File[0] : files;
}

static File[] listFiles(String dir) {
  return listFiles(new File(dir));
}
static String standardCredentials() {
  String user = standardCredentialsUser();
  String pass = standardCredentialsPass();
  if (nempty(user) && nempty(pass))
    return "&_user=" + urlencode(user) + "&_pass=" + urlencode(pass);
  return "";
}
static boolean flexMatchIC2_debug;

static boolean flexMatchIC2(String pat, String s) {
  return flexMatchIC2(pat, s, null);
}

static boolean flexMatchIC2(String pat, String s, Matches m) {
  return flexMatchIC2(javaTok(pat), javaTok_cached(unnull(s)), m);
}

static boolean flexMatchIC2(String pat, String s, Matches m, boolean joinBrackets) {
  return flexMatchIC2(javaTok(pat), javaTok_cached(unnull(s)), m, joinBrackets);
}

static boolean flexMatchIC2(List<String> tokpat, List<String> tokfull, Matches m) {
  return flexMatchIC2(tokpat, tokfull, m, true);
}

static boolean flexMatchIC2(List<String> tokpat, List<String> tokfull, Matches m, boolean joinBrackets) {
  tokpat = codeTokens(joinBrackets ? joinBrackets(tokpat) : tokpat);
  for (int i = 0; i < l(tokpat); i++)
    if (eq(tokpat.get(i), "*"))
      tokpat.add(i++, "!*"); // insert single-token wildcard in front to avoid empty matches
  if (joinBrackets) tokfull = joinBrackets(tokfull);
  List<String> tok = codeTokens(tokfull);
  BitSet bla = new BitSet();
  BitSet bla2 = new BitSet();
  if (!flexMatchIC2_impl(tokpat, 0, tok, 0, bla, bla2)) return false;
  if (m != null) {
    List<String> l = new ArrayList();
    for (int i = 1; i < l(tokfull); i += 2) {
      if (bla.get(i/2)) {
        int j = i;
        while (j < l(tokfull) && bla.get(j/2)) j += 2;
        l.add(join(subList(tokfull, i, j-1)));
        i = j-2;
      } else if (bla2.get(i/2))
        l.add(tokfull.get(i));
    }
    m.m = toStringArray(l);
  }
  return true;
}

static boolean flexMatchIC2_impl(List<String> pat, int ipat, List<String> tok, int itok, BitSet bla, BitSet bla2) {
  if (flexMatchIC2_debug)
    print("flexMatchIC2 pat=" + structure(subList(pat, ipat)) + " tok=" + structure(subList(tok, itok)) + " " + structure(bla));
  if (ipat >= l(pat))
    return itok >= l(tok);
  String t = pat.get(ipat);
  
  if (eq(t, "*")) { // the flex wildcard (0 or more tokens)
    if (flexMatchIC2_debug) print("Trying zero tokens");
    if (flexMatchIC2_impl(pat, ipat+1, tok, itok, bla, bla2)) {
      if (flexMatchIC2_debug) print("Success!");
      return true;
    }
    
    bla.set(itok);
    if (itok < l(tok)) {
      if (flexMatchIC2_debug) print("Trying one or more tokens");
      if (flexMatchIC2_impl(pat, ipat, tok, itok+1, bla, bla2)) {
        if (flexMatchIC2_debug) print("Success!");
        return true; // success, leave mark
      }
    }
    
    if (flexMatchIC2_debug) print("Failed * matching");
    bla.clear(itok); // fail, undo marking
    return false;
  }
  if (itok >= l(tok)) {
    if (flexMatchIC2_debug)
      print("too much pattern");
    return false;
  }
  if (eq(t, "!*")) { // the single-token wildcard
    bla.set(itok);
    if (flexMatchIC2_impl(pat, ipat+1, tok, itok+1, bla, bla2))
      return true; // success, leave mark
    bla.clear(itok); // fail, undo marking
    return false;
  }
  String realt = tok.get(itok);
  if (t.startsWith("(") && t.endsWith(")")) {
    // quick pre-check
    if (flexMatchIC2_debug)
      print("flexMatchIC2 precheck " + t + " " + realt);
    if (!containsIgnoreCase(t, realt)) return false;
    // real check
    List<String> list = splitAt(dropFirstAndLast(t), "|");
    if (flexMatchIC2_debug)
      print("flexMatchIC2 real check " + struct(list));
    if (!containsIgnoreCase(list, realt)) return false;
    bla2.set(itok);
  } else if (neqic(realt, t)) {
    if (flexMatchIC2_debug)
      print("mismatch");
    return false;
  }
  
  // it is a token match. consume and proceed
  if (flexMatchIC2_impl(pat, ipat+1, tok, itok+1, bla, bla2))
    return true;
  else {
    bla2.clear(itok);
    return false;
  }
}
static String hideCredentials(String url) {
  return url.replaceAll("&_pass=[^&]*", "&_pass=<hidden>");
}
static String or2(String a, String b) {
  return nempty(a) ? a : b;
}
static List<String> tok_groupRoundBrackets(String s) {
  List<String> tok = javaTok(s);
  while (true) {
    int i = tok.lastIndexOf("(");
    if (i < 0) return tok;
    int j = indexOf(tok, ")", i);
    if (j < 0) return tok;
    tok.set(i, join(subList(tok, i, j+1)));
    tok.subList(i+1, j+1).clear();
    assertTrue(odd(l(tok)));
  }
}
static String loadProgramTextFile(String name) {
  return loadTextFile(getProgramFile(name));
}

static String loadProgramTextFile(String progID, String name) {
  return loadTextFile(getProgramFile(progID, name));
}

static String loadProgramTextFile(String progID, String name, String defaultText) {
  return loadTextFile(getProgramFile(progID, name), defaultText);
}
static String conceptQuote(String s) {
  if (isIdentifier(s) || isInteger(s) || isProperlyQuoted(s)) return s;
  return quote(s);
}
static JTextField consoleInputField() {
  return (JTextField) getOpt(get(getJavaX(), "console"), "tfInput");
}
static AIConcept getAIConcept(String id) {
  return aiConceptsMap_cached().get(id);
}
static final boolean loadPageThroughProxy_enabled = false;

static String loadPageThroughProxy(String url) {
  return null;
}
static void sortFilesByName(List<File> l) {
  sort(l, new Comparator<File>() {
    public int compare(File a, File b) {
      return stdcompare(a.getName(), b.getName());
    }
  });
}
// o is either a map already (string->object) or an arbitrary object,
// in which case its fields are converted into a map.
static Map<String, Object> objectToMap(Object o) { try {
  if (o instanceof Map) return (Map) o;
  
  TreeMap<String,Object> map = new TreeMap();
  Class c = o.getClass();
  while (c != Object.class) {
    Field[] fields = c.getDeclaredFields();
    for (final Field field : fields) {
      if ((field.getModifiers() & Modifier.STATIC) != 0)
        continue;
      field.setAccessible(true);
      final Object value = field.get(o);
      if (value != null)
        map.put(field.getName(), value);
    }
    c = c.getSuperclass();
  }
  return map;
} catch (Exception __e) { throw rethrow(__e); } }

// same for a collection (convert each element)
static List<Map<String, Object>> objectToMap(Collection l) {
  List x = new ArrayList();
  for (Object o : l)
    x.add(objectToMap(o));
  return x;
}
static void sleepSeconds(double s) {
  if (s > 0) sleep(round(s*1000));
}
static void revalidateFrame(Component c) {
  revalidate(getFrame(c));
}


static Throwable getInnerException(Throwable e) {
  while (e.getCause() != null)
    e = e.getCause();
  return e;
}
static String parse3_cached_s;
static List<String> parse3_cached_l;

  static synchronized List<String> parse3_cached(String s) {
    if (neq(s, parse3_cached_s))
      parse3_cached_l = parse3(parse3_cached_s = s);
    return parse3_cached_l;
  }
static void revalidate(Component c) {
  if (c == null || !c.isShowing()) return;
  // magic combo to actually relayout and repaint
  c.revalidate();
  c.repaint();
}
static File getProgramFile(String progID, String fileName) {
  if (new File(fileName).isAbsolute())
    return new File(fileName);
  return new File(getProgramDir(progID), fileName);
}

static File getProgramFile(String fileName) {
  return getProgramFile(getProgramID(), fileName);
}

static String standardCredentialsUser() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/username")));
}
  static List<String> parse3(String s) {
    return dropPunctuation(javaTokPlusPeriod(s));
  }
static String baseClassName(String className) {
  return substring(className, className.lastIndexOf('.')+1);
}

static String baseClassName(Object o) {
  return baseClassName(getClassName(o));
}
static JFrame getFrame(Object o) {
  if (o instanceof ButtonGroup) o = first(buttonsInGroup((ButtonGroup) o));
  if (!(o instanceof Component)) return null;
  Component c = (Component) o;
  while (c != null) {
    if (c instanceof JFrame) return (JFrame) c;
    c = c.getParent();
  }
  return null;
}
static String standardCredentialsPass() {
  return trim(loadTextFile(new File(userHome(), ".tinybrain/userpass")));
}
static long round(double d) {
  return Math.round(d);
}
static boolean startsWith(String a, String b) {
  return a != null && a.startsWith(b);
}

static boolean startsWith(List a, List b) {
  if (a == null || l(b) > l(a)) return false;
  for (int i = 0; i < l(b); i++)
    if (neq(a.get(i), b.get(i)))
      return false;
  return true;
}


static List<AbstractButton> buttonsInGroup(ButtonGroup g) {
  if (g == null) return ll();
  return asList(g.getElements());
}
// This is made for NL parsing.
// It's javaTok extended with "..." token, "$n" and "#n" and
// special quotes (which are converted to normal ones).

static List<String> javaTokPlusPeriod(String s) {
  List<String> tok = new ArrayList<String>();
  int l = s.length();
  
  int i = 0;
  while (i < l) {
    int j = i;
    char c; String cc;
    
    // scan for whitespace
    while (j < l) {
      c = s.charAt(j);
      cc = s.substring(j, Math.min(j+2, l));
      if (c == ' ' || c == '\t' || c == '\r' || c == '\n')
        ++j;
      else if (cc.equals("/*")) {
        do ++j; while (j < l && !s.substring(j, Math.min(j+2, l)).equals("*/"));
        j = Math.min(j+2, l);
      } else if (cc.equals("//")) {
        do ++j; while (j < l && "\r\n".indexOf(s.charAt(j)) < 0);
      } else
        break;
    }
    
    tok.add(s.substring(i, j));
    i = j;
    if (i >= l) break;
    c = s.charAt(i);
    cc = s.substring(i, Math.min(i+2, l));

    // scan for non-whitespace
    if (c == '\u201C' || c == '\u201D') c = '"'; // normalize quotes
    if (c == '\'' || c == '"') {
      char opener = c;
      ++j;
      while (j < l) {
        char _c = s.charAt(j);
        if (_c == '\u201C' || _c == '\u201D') _c = '"'; // normalize quotes
        if (_c == opener) {
          ++j;
          break;
        } else if (s.charAt(j) == '\\' && j+1 < l)
          j += 2;
        else
          ++j;
      }
      if (j-1 >= i+1) {
        tok.add(opener + s.substring(i+1, j-1) + opener);
        i = j;
        continue;
      }
    } else if (Character.isJavaIdentifierStart(c))
      do ++j; while (j < l && (Character.isJavaIdentifierPart(s.charAt(j)) || s.charAt(j) == '\'')); // for things like "this one's"
    else if (Character.isDigit(c))
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else if (cc.equals("[[")) {
      do ++j; while (j+1 < l && !s.substring(j, j+2).equals("]]"));
      j = Math.min(j+2, l);
    } else if (cc.equals("[=") && i+2 < l && s.charAt(i+2) == '[') {
      do ++j; while (j+2 < l && !s.substring(j, j+3).equals("]=]"));
      j = Math.min(j+3, l);
    } else if (s.substring(j, Math.min(j+3, l)).equals("..."))
      j += 3;
    else if (c == '$' || c == '#')
      do ++j; while (j < l && Character.isDigit(s.charAt(j)));
    else
      ++j;

    tok.add(s.substring(i, j));
    i = j;
  }
  
  if ((tok.size() % 2) == 0) tok.add("");
  return tok;
}

static List<String> dropPunctuation_keep = litlist("*", "<", ">");

static List<String> dropPunctuation(List<String> tok) {
  tok = new ArrayList<String>(tok);
  for (int i = 1; i < tok.size(); i += 2) {
    String t = tok.get(i);
    if (t.length() == 1 && !Character.isLetter(t.charAt(0)) && !Character.isDigit(t.charAt(0)) && !dropPunctuation_keep.contains(t)) {
      tok.set(i-1, tok.get(i-1) + tok.get(i+1));
      tok.remove(i);
      tok.remove(i);
      i -= 2;
    }
  }
  return tok;
}

static String dropPunctuation(String s) {
  return join(dropPunctuation(nlTok(s)));
}
static File getProgramDir() {
  return programDir();
}

static File getProgramDir(String snippetID) {
  return programDir(snippetID);
}


static List<String> nlTok(String s) {
  return javaTokPlusPeriod(s);
}
static File programDir_mine; // set this to relocate program's data

static File programDir() {
  return programDir(getProgramID());
}

static File programDir(String snippetID) {
  if (programDir_mine != null && sameSnippetID(snippetID, programID()))
    return programDir_mine;
  return new File(javaxDataDir(), formatSnippetID(snippetID));
}



static String programID() {
  return getProgramID();
}
static File javaxDataDir_dir; // can be set to work on different base dir

static File javaxDataDir() {
  return javaxDataDir_dir != null ? javaxDataDir_dir : new File(userHome(), "JavaX-Data");
}
static boolean sameSnippetID(String a, String b) {
  return a != null && b != null && parseSnippetID(a) == parseSnippetID(b);
}


static class PNGFile extends Concept {
  String pngPath; // program ID + "/" + file name
  Rect r; // optional, rectangle that was shot
  
  PNGFile() {} // for persistance
  PNGFile(String pngPath) {
  this.pngPath = pngPath;}
  PNGFile(BufferedImage img) {
    savePNG(pngFile(), img);
  }
  
    PNGFile(RGBImage img) { this(img.getBufferedImage()); }
  

  File pngFile() {
    if (pngPath == null) {
      pngPath = _programID() + "/" + id + ".png";
      change();
    }
    return prepareFile(new File(javaxDataDir(), pngPath));
  }
  
  BufferedImage loadImage() { return loadImage2(pngFile()); }
  BufferedImage getImage() { return loadImage(); }
  BufferedImage getImageSafe() { try { return loadImage(); } catch (Throwable __e) { printStackTrace2(__e); } return null; }
  String md5() { try { return md5OfBufferedImage(getImage()); } catch (Throwable __e) { printStackTrace2(__e); } return "-"; }
  
  boolean hasImage() {
    return pngFile().exists();
  }
}


static class RemoteDB {
  DialogIO db;
  String name;
  
  // s = bot name or snippet ID
  RemoteDB(String s) {
    this(s, false);
  }
  
  RemoteDB(String s, boolean autoStart) {
    name = s;
    if (isSnippetID(s)) name = dbBotName(s);
    db = findBot(name);
    if (db == null)
      if (autoStart) {
        nohupJavax(fsI(s));
        waitForBotStartUp(name);
        assertNotNull("Weird problem", db = findBot(s));
      } else
        throw fail("DB " + s + " not running");
  }

  boolean functional() { return db != null; } // now always true
  
  List<RC> list() { return adopt((List<RC>) rpc(db, "xlist")); }
  List<RC> list(String className) { return adopt((List<RC>) rpc(db, "xlist", className)); }
  List<RC> xlist() { return list(); }
  List<RC> xlist(String className) { return list(className); }
  
  // adopt is an internal method
  List<RC> adopt(List<RC> l) {
    if (l != null) for (RC rc : l) adopt(rc);
    return l;
  }
  
  RC adopt(RC rc) { if (rc != null) rc.db = this; return rc; }
  
  Object adopt(Object o) {
    if (o instanceof RC) return adopt((RC) o);
    return o;
  }
  
  String xclass(RC o) {
    return (String) rpc(db, "xclass", o);
  }
  
  Object xget(RC o, String field) {
    return adopt(rpc(db, "xget", o, field));
  }
  
  String xS(RC o, String field) {
    return (String) xget(o, field);
  }
  
  RC xgetref(RC o, String field) {
    return adopt((RC) xget(o, field));
  }
  
  void xset(RC o, String field, Object value) {
    rpc(db, "xset", o, field, value);
  }
  
  RC uniq(String className) {
    RC ref = first(list(className));
    if (ref == null)
      ref = xnew(className);
    return ref;
  }
  RC xuniq(String className) { return uniq(className); }
  
  RC xnew(String className, Object... values) {
    return adopt((RC) rpc(db, "xnew", className, values));
  }
  
  void xdelete(RC o) {
    rpc(db, "xdelete", o);
  }
  
  void xdelete(List<RC> l) {
    rpc(db, "xdelete", l);
  }

  void close() {
    if (db != null)
      db.close();
  }
  
  String fullgrab() { return (String) rpc(db, "xfullgrab"); }
  String xfullgrab() { return fullgrab(); }
  
  void xshutdown() { rpc(db, "xshutdown"); }
  
  long xchangeCount() { return (long) rpc(db, "xchangeCount"); }
  int xcount() { return (int) rpc(db, "xcount"); }

  void reconnect() {
    close();
    db = findBot(name);
  }
  
  RC rc(long id) { return new RC(this, id); }
}

static Object cget(Object c, String field) {
  Object o = getOpt(c, field);
  if (o instanceof Concept.Ref) return ((Concept.Ref) o).get();
  return o;
}
static Concept getConcept(long id) {
  return mainConcepts.getConcept(id);
}

static <A extends Concept> A getConcept(Class<A> cc, long id) {
  return getConcept(mainConcepts, cc, id);
}

static <A extends Concept> A getConcept(Concepts concepts, Class<A> cc, long id) {
  Concept c = concepts.getConcept(id);
  if (c == null) return null;
  if (!isInstance(cc, c))
    throw fail("Can't convert concept: " + getClassName(c) + " -> " + getClassName(cc) + " (" + id + ")");
  return (A) c;
}
static volatile boolean licensed_yes = true;

static boolean licensed() {
  ping();
  return licensed_yes;
}

static void licensed_off() {
  licensed_yes = false;
}
// firstDelay = delay
static java.util.Timer doEvery_daemon(int delay, final Object r) {
  return doEvery_daemon(delay, delay, r);
}

static java.util.Timer doEvery_daemon(int delay, int firstDelay, final Object r) {
  final java.util.Timer timer = new java.util.Timer(true);
  timer.scheduleAtFixedRate(smartTimerTask(r, timer, delay), firstDelay, delay);
  return timer;
}

static Map<String, Integer> findBot_cache = synchroHashMap();
static int findBot_timeout = 5000;

static DialogIO findBot(String searchPattern) {
  // first split off sub-bot suffix
  String subBot = null;
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i+1);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return talkToSubBot(subBot, talkTo(parseInt(searchPattern)));
    
  if (eq(searchPattern, "remote"))
    return talkToSubBot(subBot, talkTo("second.tinybrain.de", 4999));
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    io.waitForLine(/*findBot_timeout*/); // TODO: implement
    String line = io.readLineNoBlock();
    if (indexOfIgnoreCase(line, searchPattern) == 0) {
      call(io, "pushback", line); // put hello string back in
      return talkToSubBot(subBot, io);
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      findBot_cache.put(searchPattern, p.port);
      return talkToSubBot(subBot, talkTo("localhost", p.port));
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = (Map) unstructure(sendToLocalBotQuietly(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return talkToSubBot(vport.longValue(), talkTo("localhost", p.port));
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
        
  return null;
}
static float abs(float f) { return Math.abs(f); }
static int abs(int i) { return Math.abs(i); }
static double abs(double d) { return Math.abs(d); }
static String loadConceptsStructure(String progID) {
  return loadTextFilePossiblyGZipped(getProgramFile(progID, "concepts.structure"));
}
static void saveGZStructureToFile(File file, Object o) { try {
  File parentFile = file.getParentFile();
  if (parentFile != null)
    parentFile.mkdirs();
  File tempFile = tempFileFor(file);
  if (tempFile.exists()) try {
    String saveName = tempFile.getPath() + ".saved." + now();
    copyFile(tempFile, new File(saveName));
  } catch (Throwable e) { printStackTrace(e); }
  
  FileOutputStream fileOutputStream = newFileOutputStream(tempFile.getPath());
  GZIPOutputStream gos = new GZIPOutputStream(fileOutputStream);
  OutputStreamWriter outputStreamWriter = new OutputStreamWriter(gos, "UTF-8");
  PrintWriter printWriter = new PrintWriter(outputStreamWriter);
  structureToPrintWriter(o, printWriter);
  printWriter.close();
  gos.close();
  fileOutputStream.close();

  if (file.exists() && !file.delete())
    throw new IOException("Can't delete " + file.getPath());

  if (!tempFile.renameTo(file))
    throw new IOException("Can't rename " + tempFile + " to " + file);
} catch (Exception __e) { throw rethrow(__e); } }
static void savePNG(BufferedImage img, File file) { try {
  File tempFile = new File(file.getPath() + "_temp");
  CriticalAction ca = beginCriticalAction("Save " + f2s(file));
  try {
    ImageIO.write(img, "png", mkdirsFor(tempFile));
    file.delete();
    tempFile.renameTo(file);
  } finally {
    ca.done();
  }
} catch (Exception __e) { throw rethrow(__e); } }

// gotta love convenience & program-smartness
static void savePNG(File file, BufferedImage img) {
  savePNG(img, file);
}
static <A> void remove(List<A> l, int i) {
  if (l != null && i >= 0 && i < l(l))
    l.remove(i);
}
static void load(String varName) {
  readLocally(varName);
}

static void load(String progID, String varName) {
  readLocally(progID, varName);
}
static boolean checkConceptFields(Concept x, Object... data) {
  for (int i = 0; i < l(data); i += 2)
    if (neq(cget(x, (String) data[i]), deref(data[i+1])))
      return false;
  return true;
}
static void saveLocally(String variableName) {
  saveLocally(programID(), variableName);
}

static void saveLocally(String progID, String variableName) {
  saveLocally2(mc(), progID, variableName);
}

static void saveLocally2(Object obj, String variableName) {
  saveLocally2(obj, programID(), variableName);
}

static synchronized void saveLocally2(Object obj, String progID, String variableName) {
  File textFile = new File(programDir(progID), variableName + ".text");
  File structureFile = new File(programDir(progID), variableName + ".structure");
  Object x = get(obj, variableName);
  
  if (x == null) {
    textFile.delete();
    structureFile.delete();
  } else if (x instanceof String) {
    saveTextFile(textFile, (String) x);
    structureFile.delete();
  } else {
    saveTextFile(structureFile, javaTokWordWrap(structure(x)));
    textFile.delete();
  }
}
static RemoteDB connectToDBOpt(String dbNameOrID) { try {
  return new RemoteDB(dbNameOrID);
} catch (Throwable __e) { return null; } }
static <A> List<A> addDyn(List<A> l, A a) {
  if (l == null) l = new ArrayList();
  l.add(a);
  return l;
}
static long toK(long l) {
  return (l+1023)/1024;
}
static long toM(long l) {
  return (l+1024*1024-1)/(1024*1024);
}

static String toM(long l, int digits) {
  return formatDouble(toM_double(l), digits);
}
static Map synchroTreeMap() {
  return Collections.synchronizedMap(new TreeMap());
}

static void nohupJavax(String javaxargs) {
  nohupJavax(javaxargs, javaxDefaultVMArgs());
}

// not using pre-spun VM if vmArgs present
static void nohupJavax(String javaxargs, String vmArgs) {
  javaxargs = javaxargs.trim();
  if (javaxargs.startsWith("#")) javaxargs = javaxargs.substring(1);
  String snippetID = javaTok(javaxargs).get(1);
  int idx = javaxargs.indexOf(' ');
  String args = idx < 0 ? "" : javaxargs.substring(idx+1).trim();
  
  vmArgs = trim(vmArgs);
  if (empty(vmArgs) && usePreSpunVMs()) {
    String line;
    if (args.length() != 0)
      line = format3("please start program * with arguments *", snippetID, args);
    else
      line = format3("please start program *", snippetID);
    String answer = sendToLocalBotOpt("A pre-spun VM.", line);
    if (match3("ok", answer)) {
      print("OK, used pre-spun VM.");
      return;
    }
    if (answer != null)
      print("> " + answer);
    print("Using standard nohup.");
  }
  
  classicNohupJavax(javaxargs, vmArgs);
}
static Statement fastLoadStatement(Object o) {
  Statement s = unlisted(Statement.class);
  copyFields(o, s, "id", "globalID", "importedFrom", "originatingUniverse", "exportable", "imageMD5", "suggestedImageMD5", "searchedForSuggestedImage", "imported", "touched", "created", "text", "possibleEnglishTranslation");
  return s;
}
static String getDBProgramID_id;

static String getDBProgramID() {
  return nempty(getDBProgramID_id) ? getDBProgramID_id : programID();
}
static boolean hasType(Collection c, Class type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return true;
  return false;
}
  static RGBImage loadImage(String snippetIDOrURL) {
    return new RGBImage(loadBufferedImage(snippetIDOrURL));
  }

static void cleanKillVM() {
  call(getJavaX(), "cleanKill");
}
static <A extends Concept> A uniq(Class<A> c, Object... params) {
  return uniqueConcept(c, params);
}
static String javaTokWordWrap(String s) {
  int cols = 120, col = 0;
  List<String> tok = javaTok(s);
  for (int i = 0; i < l(tok); i++) {
    String t = tok.get(i);
    if (odd(i) && col >= cols && !containsNewLine(t))
      tok.set(i, t += "\n");
    int idx = t.lastIndexOf('\n');
    if (idx >= 0) col = l(t)-(idx+1);
    else col += l(t);
  }
  return join(tok);
}
static Object deref(Object o) {
  if (o instanceof Derefable) o = ((Derefable) o).get();
  return o;
}

static Object derefRef(Object o) {
  if (o instanceof Concept.Ref) o = ((Concept.Ref) o).get();
  return o;
}

static <A extends Concept> Object[] expandParams(Class<A> c, Object[] params) {
  if (l(params) == 1)
    params = new Object[] { singleFieldName(c), params[0] };
  else
    warnIfOddCount(params);
  return params;
}

static Object rpc(String botName, String method, Object... args) {
  return unstructure_debug(matchOK2OrFail(
    sendToLocalBot(botName, rpc_makeCall(method, args))));
}

static Object rpc(DialogIO bot, String method, Object... args) {
  return unstructure_debug(matchOK2OrFail(
    bot.ask(rpc_makeCall(method, args))));
}

static String rpc_makeCall(String method, Object... args) {
  if (empty(args))
    return "call " + method;
  return format("call *", concatLists((List) ll(method), asList(args)));
}
static <A> List<A> filterByDynamicType(Collection<A> c, String type) {
  List<A> l = new ArrayList();
  for (A x : c)
    if (eq(dynamicClassName(x), type))
      l.add(x);
  return l;
}
static long waitForBotStartUp_timeoutSeconds = 60;

// returns address or fails
static String waitForBotStartUp(String botName) {
  for (int i = 0; i < waitForBotStartUp_timeoutSeconds; i++) {
    sleepSeconds(i == 0 ? 0 : 1);
    String addr = getBotAddress(botName);
    if (addr != null)
      return addr;
  }
  throw fail("Bot not found: " + quote(botName));
}
static <A> A firstOfType(Collection c, Class<A> type) {
  for (Object x : c)
    if (isInstanceX(type, x))
      return (A) x;
  return null;
}
static <A, B> Map<A, B> cloneMap(Map<A, B> map) {
  if (map == null) return litmap();
  // assume mutex is equal to collection, which will be true unless you explicitly pass a mutex to synchronizedList() which no one ever does.
  synchronized(map) {
    return map instanceof TreeMap ? new TreeMap(map)
      : map instanceof LinkedHashMap ? new LinkedHashMap(map)
      : new HashMap(map);
  }
}
static Concept cnew(String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  Concept c = cc != null ? nuObject(cc) : new Concept(name);
  csetAll(c, values);
  return c;
}

static Concept cnew(Concepts concepts, String name, Object... values) {
  Class<? extends Concept> cc = findClass(name);
  concepts_unlisted.set(true);
  Concept c;
  try {
    c = cc != null ? nuObject(cc) : new Concept(name);
  } finally {
    concepts_unlisted.set(null);
  }
  concepts.register(c);
  csetAll(c, values);
  return c;
}

static <A extends Concept> A cnew(Class<A> cc, Object... values) {
  A c = nuObject(cc);
  csetAll(c, values);
  return c;
}

static boolean bareDBMode_on;

static void bareDBMode() {
  bareDBMode(null); // default autoSaveInterval
}

static void bareDBMode(Integer autoSaveInterval) {
  bareDBMode_on = true;
  conceptsAndBot(autoSaveInterval);
}
static File prepareFile(File file) {
  return mkdirsForFile(file);
}

static boolean warn_on = true;

static void warn(String s) {
  if (warn_on)
    print("Warning: " + s);
}

static void warn(String s, List<String> warnings) {
  warn(s);
  if (warnings != null)
    warnings.add(s);
}
static Str concept(String name) {
  for (Str s : list(Str.class))
    if (eqic(s.name, name) || containsIgnoreCase(s.otherNames, name))
      return s;
  return new Str(name);
}
static int hours() {
  return Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
}
static <A extends Concept> A findBackRef(Concept c, Class<A> type) {
  for (Concept.Ref r : c.backRefs)
    if (instanceOf(r.concept(), type))
      return (A) r.concept();
  return null;
}

static <A extends Concept> A findBackRef(Class<A> type, Concept c) {
  return findBackRef(c, type);
}
static BufferedImage loadImage2(String snippetIDOrURL) {
  return loadBufferedImage(snippetIDOrURL);
}

static BufferedImage loadImage2(File file) {
  return loadBufferedImage(file);
}
static <A> List<A> removeDyn(List<A> l, A a) {
  if (l == null) return null;
  l.remove(a);
  return empty(l) ? null : l;
}
static String formatInt(int i, int digits) {
  return padLeft(str(i), '0', digits);
}

static <A> List<A> filterByType(Collection c, Class<A> type) {
  List<A> l = new ArrayList();
  for (Object x : c)
    if (isInstanceX(type, x))
      l.add((A) x);
  return l;
}

static <A> List<A> filterByType(Object[] c, Class<A> type) {
  return filterByType(asList(c), type);
}

static int done_minPrint = 10;

static long done(long startTime, String desc) {
  long time = now()-startTime;
  if (time >= done_minPrint)
    print(desc + " [" + time + " ms]");
  return time;
}

static long done(String desc, long startTime) {
  return done(startTime, desc);
}

static long done(long startTime) {
  return done(startTime, "");
}
static void readLocally(String progID, String varNames) {
  readLocally2(mc(), progID, varNames);
}

static void readLocally(String varNames) {
  readLocally2(mc(), programID(), varNames);
}

static void readLocally2(Object obj, String varNames) {
  readLocally2(obj, programID(), varNames);
}

static int readLocally_stringLength;

static ThreadLocal<Boolean> readLocally2_allDynamic = new ThreadLocal();

// read a string variable from standard storage
// does not overwrite variable contents if there is no file
static void readLocally2(Object obj, String progID, String varNames) { try {
  boolean allDynamic = isTrue(getAndClearThreadLocal(readLocally2_allDynamic));
  for (String variableName : javaTokC(varNames)) {
    File textFile = new File(programDir(progID), variableName + ".text");
    
    String value = loadTextFile(textFile);
    if (value != null)
      set(main.class, variableName, value);
    else {
      File structureFile = new File(programDir(progID), variableName + ".structure");
      value = loadTextFile(structureFile);
      
      if (value == null) {
        File structureGZFile = new File(programDir(progID), variableName + ".structure.gz");
        if (!structureGZFile.isFile()) return;
        //value = loadGZTextFile(structureGZFile);
        InputStream fis = new FileInputStream(structureGZFile);
        try {
          GZIPInputStream gis = new GZIPInputStream(fis);
          InputStreamReader reader = new InputStreamReader(gis, "UTF-8");
          BufferedReader bufferedReader = new BufferedReader(reader);
          //O o = unstructure_reader(bufferedReader);
          Object o = unstructure_tok(javaTokC_onReader(bufferedReader), allDynamic, null);
          readLocally_set(obj, variableName, o);
        } finally {
          fis.close();
        }
        return;
      }
      
      readLocally_stringLength = l(value);
      if (value != null)
        readLocally_set(obj, variableName, allDynamic ? safeUnstructure(value) : unstructure(value));
    }
  }
} catch (Exception __e) { throw rethrow(__e); } }

static void readLocally_set(Object c, String varName, Object value) {
  Object oldValue = get(c, varName);
  if (oldValue instanceof List && !(oldValue instanceof ArrayList) && value != null) {
    // Assume it's a synchroList.
    value = synchroList((List) value);
  }
  set(c, varName, value);
}

static boolean hasConcept(Class<? extends Concept> c, Object... params) {
  return findConceptWhere(c, params) != null;
}
static String ymd() {
  return year() + formatInt(month(), 2) + formatInt(dayOfMonth(), 2);
}
static String md5OfBufferedImage(BufferedImage img) {
  return img == null ? null : rgbMD5(new RGBImage(img));
}
static <A extends Concept> int countConcepts(Class<A> c, Object... params) {
  return mainConcepts.countConcepts(c, params);
}

static int countConcepts() {
  return mainConcepts.countConcepts();
}

static int countConcepts(String className) {
  return mainConcepts.countConcepts(className);
}

static <A extends Concept> int countConcepts(Concepts concepts, String className) {
  return concepts.countConcepts(className);
}


static int year() {
  return Calendar.getInstance().get(Calendar.YEAR);
}
static String javaxDefaultVMArgs() {
  return trim(loadProgramTextFile("#1005850", "default-vm-args", ""));
}
static Object unstructure_debug(String s) {
  try {
    return unstructure(s);
  } catch (Throwable _e) {
    print("Was unstructuring: " + s);
  
throw rethrow(_e); }
}
static <A extends Concept> A uniqueConcept(Class<A> c, Object... params) {
  params = expandParams(c, params);
  A x = findConceptWhere(c, params);
  if (x == null) {
    x = nuObject(c);
    for (int i = 0; i+1 < l(params); i += 2)
      cset(x, (String) params[i], params[i+1]);
  }
  return x;
}
static <A extends Concept> A findConceptWhere(Class<A> c, Object... params) {
  return findConceptWhere(mainConcepts, c, params);
}

static <A extends Concept> A findConceptWhere(Concepts concepts, Class<A> c, Object... params) {
  params = expandParams(c, params);
  for (A x : concepts.list(c))
    if (checkConceptFields(x, params))
      return x;
  return null;
}

static boolean startsWithIgnoreCase(String a, String b) {
  return a != null && a.regionMatches(true, 0, b, 0, b.length());
}
  static String format3(String pat, Object... args) {
    if (args.length == 0) return pat;
    
    List<String> tok = javaTokPlusPeriod(pat);
    int argidx = 0;
    for (int i = 1; i < tok.size(); i += 2)
      if (tok.get(i).equals("*"))
        tok.set(i, format3_formatArg(argidx < args.length ? args[argidx++] : "null"));
    return join(tok);
  }
  
  static String format3_formatArg(Object arg) {
    if (arg == null) return "null";
    if (arg instanceof String) {
      String s = (String) arg;
      return isIdentifier(s) || isNonNegativeInteger(s) ? s : quote(s);
    }
    if (arg instanceof Integer || arg instanceof Long) return String.valueOf(arg);
    return quote(structure(arg));
  }
  

// class Matches is added by #752

static boolean match3(String pat, String s) {
  return match3(pat, s, null);
}

static boolean match3(String pat, String s, Matches matches) {
  if (s == null) return false;
  return match3(pat, parse3_cached(s), matches);
}
  
static boolean match3(String pat, List<String> toks, Matches matches) {
  List<String> tokpat = parse3(pat);
  return match3(tokpat,toks,matches);
}

static boolean match3(List<String> tokpat, List<String> toks, Matches matches) {
  String[] m = match2(tokpat, toks);
  //print(structure(tokpat) + " on " + structure(toks) + " => " + structure(m));
  if (m == null) return false;
  if (matches != null) matches.m = m; return true;
}
static <A> A getAndClearThreadLocal(ThreadLocal<A> tl) {
  A a = tl.get();
  tl.set(null);
  return a;
}
static boolean instanceOf(Object o, String className) {
  if (o == null) return false;
  String c = o.getClass().getName();
  return eq(c, className) || eq(c, "main$" + className);
}

static boolean instanceOf(Object o, Class c) {
  if (c == null) return false;
  return c.isInstance(o);
}
static int month() {
  return Calendar.getInstance().get(Calendar.MONTH)+1;
}
volatile static boolean conceptsAndBot_running;

static void conceptsAndBot() {
  conceptsAndBot(null);
}

static void conceptsAndBot(Integer autoSaveInterval) {
  if (conceptsAndBot_running) return;
  conceptsAndBot_running = true;
  
  ensureBotIsNotAlreadyRunning(dbBotStandardName());
  if (autoSaveInterval != null)
    loadAndAutoSaveConcepts(autoSaveInterval);
  else
    loadAndAutoSaveConcepts();
  dbBot();
}
static String sendToLocalBotQuietly(String bot, String text, Object... args) {
  text = format3(text, args);
  
  DialogIO channel = newFindBot2(bot);
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    channel.close();
  }
}

static String sendToLocalBotQuietly(int port, String text, Object... args) {
  text = format3(text, args);
  DialogIO channel = talkTo(port);
  try {
    channel.readLine();
    channel.sendLine(text);
    String s = channel.readLine();
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    if (channel != null)
      channel.close();
  }
}
static int getBotAddress_timeout = 5000;

static String getBotAddress(String searchPattern) {
  String subBot = "";
  int i = searchPattern.indexOf('/');
  if (i >= 0 && (isJavaIdentifier(searchPattern.substring(0, i)) || isInteger(searchPattern.substring(0, i)))) {
    subBot = searchPattern.substring(i);
    searchPattern = searchPattern.substring(0, i);
    if (!isInteger(searchPattern))
      searchPattern = "Multi-Port at " + searchPattern + ".";
  }
  
  // assume it's a port if it's an integer
  if (isInteger(searchPattern))
    return searchPattern + subBot;
    
  Integer port = findBot_cache.get(searchPattern);
  if (port != null) try {
    DialogIO io = talkTo("localhost", port);
    try {
      io.waitForLine(/*getBotAddress_timeout*/); // TODO: implement
      String line = io.readLineNoBlock();
      if (startsWithIgnoreCase(line, searchPattern))
        return port + subBot;
    } finally {
      io.close();
    }
  } catch (Exception e) {
    e.printStackTrace();
  }
  
  List<ProgramScan.Program> bots = quickBotScan();
  
  // find top-level bots
  for (ProgramScan.Program p : bots) {
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0) { // strict matching - start of hello string only, but case-insensitive
      return p.port + subBot;
    }
  }
  
  // find sub-bots
  for (ProgramScan.Program p : bots) {
    String botName = firstPartOfHelloString(p.helloString);
    boolean isVM = startsWithIgnoreCase(p.helloString, "This is a JavaX VM.");
    boolean shouldRecurse = startsWithIgnoreCase(botName, "Multi-Port") || isVM;
        
    if (shouldRecurse) try {
      Map<Number, String> subBots = unstructureMap_verboseError(sendToLocalBot(p.port, "list bots"));
      for (Number vport : subBots.keySet()) {
        String name = subBots.get(vport);
        if (startsWithIgnoreCase(name, searchPattern))
          return p.port + "/" + vport;
      }
    } catch (Exception e) { e.printStackTrace(); }
  }
        
  return null;
}
static String padLeft(String s, char c, int n) {
  return rep(c, n-l(s)) + s;
}

// default to space
static String padLeft(String s, int n) {
  return padLeft(s, ' ', n);
}
static String matchOK2OrFail(String s) {
  Matches m = new Matches();
  if (swic(s, "ok "))
    return substring(s, 3);
  else if (eqic(s, "ok"))
    return "ok";
  else
    throw fail(s);
}
static String dynamicClassName(Object o) {
  if (o instanceof DynamicObject && ((DynamicObject) o).className != null)
    return "main$" + ((DynamicObject) o).className;
  return className(o);
}
static void classicNohupJavax(String javaxargs) {
  classicNohupJavax(javaxargs, "");
}

static void classicNohupJavax(String javaxargs, String vmArgs) { try {
  int x = latestInstalledJavaX();
  File xfile = new File(userHome(), ".javax/x" + Math.max(x, 30) + ".jar");
  if (!xfile.isFile()) {
    String url = "http://tinybrain.de/x30.jar";
    byte[] data = loadBinaryPage(url);
    if (data.length < 1000000)
      throw fail("Could not load " + url);
    saveBinaryFile(xfile.getPath(), data);
  }
  String jarPath = xfile.getPath();
  if (javaxargs.startsWith("#")) javaxargs = javaxargs.substring(1);
  nohup("java " + vmArgs + " -jar " + (isWindows() ? winQuote(jarPath) : bashQuote(jarPath)) + " " + javaxargs);
} catch (Exception __e) { throw rethrow(__e); } }
static String f2s(File f) {
  return f == null ? null : f.getAbsolutePath();
}
static String sendToLocalBot(String bot, String text, Object... args) {
  text = format3(text, args);
  
  DialogIO channel = findBot(bot);
  if (channel == null)
    throw fail(quote(bot) + " not found");
  try {
    channel.readLine();
    print(bot + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(bot + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    channel.close();
  }
}

static String sendToLocalBot(int port, String text, Object... args) {
  text = format3(text, args);
  DialogIO channel = talkTo(port);
  try {
    channel.readLine();
    print(port + "> " + shorten(text, 80));
    channel.sendLine(text);
    String s = channel.readLine();
    print(port + "< " + shorten(s, 80));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    if (channel != null)
      channel.close();
  }
}
static boolean usePreSpunVMs() {
  return eq("1", trim(loadProgramTextFile("#1005457", "enable-prespun-vms")));
}
static String singleFieldName(Class c) {
  Set<String> l = listFields(c);
  if (l(l) != 1)
    throw fail("No single field found in " + c + " (have " + n(l(l), "fields") + ")");
  return first(l);
}
public static File mkdirsFor(File file) {
  return mkdirsForFile(file);
}

static String rgbMD5(RGBImage img) {
  return md5OfRGBImage(img);
}
static boolean isInstance(Class type, Object arg) {
  return type.isInstance(arg);
}
static int dayOfMonth() {
  return days();
}
static DialogIO talkToSubBot(final long vport, final DialogIO io) {
  return talkToSubBot(String.valueOf(vport), io);
}

static DialogIO talkToSubBot(final String subBot, final DialogIO io) {
  if (subBot == null) return io;
  return new talkToSubBot_IO(subBot, io);
}

static class talkToSubBot_IO extends DialogIO {
  String subBot;
  DialogIO io;
  
  talkToSubBot_IO(String subBot, DialogIO io) {
  this.io = io;
  this.subBot = subBot;}
  
  // delegate all but sendLine
  boolean isStillConnected() { return io.isStillConnected(); }
  String readLineImpl() { return io.readLineImpl(); }
  boolean isLocalConnection() { return io.isLocalConnection(); }
  Socket getSocket() { return io.getSocket(); }
  void close() { io.close(); }

  void sendLine(String line) {
    io.sendLine(format3("please forward to bot *: *", subBot, line));
  }
}
static String formatDouble(double d, int digits) {
  String format = "0." + rep(digits, '#');
  return new java.text.DecimalFormat(format, new java.text.DecimalFormatSymbols(Locale.ENGLISH)).format(d);
}

static boolean loadBufferedImage_useImageCache = true;

static BufferedImage loadBufferedImage(String snippetIDOrURL) { try {
  if (snippetIDOrURL == null) return null;
  if (isURL(snippetIDOrURL))
    return ImageIO.read(new URL(snippetIDOrURL));

  if (!isSnippetID(snippetIDOrURL)) throw fail("Not a URL or snippet ID: " + snippetIDOrURL);
  String snippetID = "" + parseSnippetID(snippetIDOrURL);
  
try {
  File dir = getCacheProgramDir("Image-Snippets");
  if (loadBufferedImage_useImageCache) {
    dir.mkdirs();
    File file = new File(dir, snippetID + ".png");
    if (file.exists() && file.length() != 0)
      try {
        return ImageIO.read(file);
      } catch (Throwable e) {
        e.printStackTrace();
        // fall back to loading from sourceforge
      }
  }

  String imageURL = snippetImageURL(snippetID);
  System.err.println("Loading image: " + imageURL);
  BufferedImage image = ImageIO.read(new URL(imageURL));

  if (loadBufferedImage_useImageCache) {
    File tempFile = new File(dir, snippetID + ".tmp." + System.currentTimeMillis());
    ImageIO.write(image, "png", tempFile);
    tempFile.renameTo(new File(dir, snippetID + ".png"));
    //Log.info("Cached image.");
  }

  //Log.info("Loaded image.");
  return image;
 } catch (IOException e) {
  throw new RuntimeException(e);
 }
} catch (Exception __e) { throw rethrow(__e); } }

static BufferedImage loadBufferedImage(File file) { try {
  return file.isFile() ? ImageIO.read(file) : null;
} catch (Exception __e) { throw rethrow(__e); } }
static String firstPartOfHelloString(String s) {
  int i = s.lastIndexOf('/');
  return i < 0 ? s : rtrim(s.substring(0, i));
}
static List<ProgramScan.Program> quickBotScan() {
  return ProgramScan.quickBotScan();
}

static List<ProgramScan.Program> quickBotScan(int[] preferredPorts) {
  return ProgramScan.quickBotScan(preferredPorts);
}

static List<ProgramScan.Program> quickBotScan(String searchPattern) {
  List<ProgramScan.Program> l = new ArrayList<ProgramScan.Program>();
  for (ProgramScan.Program p : ProgramScan.quickBotScan())
    if (indexOfIgnoreCase(p.helloString, searchPattern) == 0)
      l.add(p);
  return l;
}

static TimerTask smartTimerTask(final Object r, final java.util.Timer timer, final int delay) {
  return new TimerTask() {
    long lastRun;
    
    public void run() {
      if (!licensed())
        timer.cancel();
      else {
        lastRun = fixTimestamp(lastRun);
        long now = now();
        if (now >= lastRun + delay*0.9) {
          lastRun = now;
          pcallF(r);
        }
      }
    }
  };
}
static String loadTextFilePossiblyGZipped(String fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}
  
static String loadTextFilePossiblyGZipped(String fileName, String defaultContents) {
  File gz = new File(fileName + ".gz");
  return gz.exists() ? loadGZTextFile(gz) : loadTextFile(fileName, defaultContents);
}

static String loadTextFilePossiblyGZipped(File fileName) {
  return loadTextFilePossiblyGZipped(fileName, null);
}

static String loadTextFilePossiblyGZipped(File fileName, String defaultContents) {
  return loadTextFilePossiblyGZipped(fileName.getPath(), defaultContents);
}

static DialogIO talkTo(int port) {
  return talkTo("localhost", port);
}

static int talkTo_defaultTimeout = 10000; // This is the CONNECT timeout
static int talkTo_timeoutForReads = 0; // Timeout waiting for answers (0 = no timeout)

static ThreadLocal<Map<String, DialogIO>> talkTo_byThread = new ThreadLocal();

static DialogIO talkTo(String ip, int port) { try {
  String full = ip + ":" + port;
  Map<String, DialogIO> map = talkTo_byThread.get();
  if (map != null && map.containsKey(full)) return map.get(full);
  
  if (isLocalhost(ip) && port == vmPort()) return talkToThisVM();

  return new talkTo_IO(ip, port);
} catch (Exception __e) { throw rethrow(__e); } }

static class talkTo_IO extends DialogIO { 
  String ip;
  int port;
  Socket s;
  Writer w;
  BufferedReader in;
  
  talkTo_IO(String ip, int port) { try {
  this.port = port;
  this.ip = ip;
    s = new Socket();
    try {
      if (talkTo_timeoutForReads != 0)
        s.setSoTimeout(talkTo_timeoutForReads);
      s.connect(new InetSocketAddress(ip, port), talkTo_defaultTimeout);
    } catch (Throwable e) {
      throw fail("Tried talking to " + ip + ":" + port, e);
    }
  
    w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
    in = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
  } catch (Exception __e) { throw rethrow(__e); } }
  
  boolean isLocalConnection() {
    return s.getInetAddress().isLoopbackAddress();
  }
  
  boolean isStillConnected() {
    return !(eos || s.isClosed());
  }
  
  void sendLine(String line) { try {
    w.write(line + "\n");
    w.flush();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  String readLineImpl() { try {
    return in.readLine();
  } catch (Exception __e) { throw rethrow(__e); } }
  
  void close() {
    try {
      if (!noClose) s.close();
    } catch (IOException e) {
      // whatever
    }
  }
  
  Socket getSocket() {
    return s;
  }
}
static double toM_double(long l) {
  return l/(1024*1024.0);
}
  static String format(String pat, Object... args) {
    return format3(pat, args);
  }

static File tempFileFor(File f) {
  return new File(f.getPath() + "_temp");
}
static boolean containsNewLine(String s) {
  return contains(s, '\n'); // screw \r, nobody needs it
}
static String sendToLocalBotOpt(String bot, String text, Object... args) {
  if (bot == null) return null;
  text = format(text, args);
  DialogIO channel = findBot(bot);
  if (channel == null) {
    print(quote(bot) + " not found, skipping send: " + quote(text));
    return null;
  }
  try {
    channel.readLine();
    print(shorten(bot + "> " + text, 200));
    channel.sendLine(text);
    String s = channel.readLine();
    print(shorten(bot + "< " + s, 200));
    return s;
  } catch (Throwable e) {
    e.printStackTrace();
    return null;
  } finally {
    channel.close();
  }
}


static Map<String, Integer> newFindBot2_cache = synchroHashMap();
static boolean newFindBot2_verbose;

static DialogIO newFindBot2(String name) {
  Integer port = newFindBot2_cache.get(name);
  if (port != null) {
    if (newFindBot2_verbose)
      print("newFindBot2: testing " + name + " => " + port);
    DialogIO io = talkTo(port);
    String q = format("has bot *", name);
    String s = io.ask(q);
    if (match("yes", s)) {
      io = talkToSubBot(name, io);
      call(io, "pushback", "?"); // put some hello string in (yes, this should be improved.)
      return io;
    }
    // bot not there anymore - remove cache entry
    newFindBot2_cache.remove(name);
    if (newFindBot2_verbose)
      print("newFindBot2: dropping " + name + " => " + port);
  }
  
  DialogIO io = findBot(name);
  if (io != null) {
    newFindBot2_cache.put(name, io.getPort());
    if (newFindBot2_verbose)
      print("newFindBot2: remembering " + name + " => " + port);
  }
  return io;
}
public static boolean isWindows() {
  return System.getProperty("os.name").contains("Windows");
}
/** possibly improvable */
static String bashQuote(String text) {
  if (text == null) return null;
  return "\"" + text
    .replace("\\", "\\\\")
    .replace("\"", "\\\"")
    .replace("\n", "\\n")
    .replace("\r", "\\r") + "\"";
}

static String bashQuote(File f) {
  return bashQuote(f.getAbsolutePath());
}
static int vmPort() {
  return myVMPort();
}
static int days() {
  return Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
}
/** possibly improvable */
public static String winQuote(String text) {
  if (text == null) return null;
  return "\"" + text
    .replace("\\", "\\\\")
    .replace("\"", "\\\"")
    .replace("\n", "\\n")
    .replace("\r", "\\r") + "\"";
}

static boolean isNonNegativeInteger(String s) {
  return s != null && Pattern.matches("\\d+", s);
}
static String md5OfRGBImage(RGBImage img) { try {
  MessageDigest m = MessageDigest.getInstance("MD5");
  m.update(intToBytes(img.getWidth()));
  int[] pixels = img.getPixels();
  for (int i = 0; i < l(pixels); i++)
    m.update(intToBytes(pixels[i]));
  return bytesToHex(m.digest());
} catch (Exception __e) { throw rethrow(__e); } }
static DialogIO talkToThisVM() {
  return new talkToThisVM_IO();
}

static class talkToThisVM_IO extends DialogIO { 
  List<String> answers = ll(thisVMGreeting());
  
  boolean isLocalConnection() { return true; }
  boolean isStillConnected() { return true; }
  int getPort() { return vmPort(); }
  
  void sendLine(String line) {
    answers.add(or2(sendToThisVM_newThread(line), "?"));
  }
  
  String readLineImpl() { try {
    return popFirst(answers);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  void close() {}
  Socket getSocket() { return null; }
}
static Android3 dbBot() {
  return dbBot(dbBotStandardName());
}

static Android3 dbBot(String name) {
  ensureBotIsNotAlreadyRunning(name);
  assertNotNull(mainConcepts);
  return methodsBot2(name, mainConcepts, exposedDBMethods, mainConcepts.lock);
}
static String dbBotStandardName() {
  return dbBotName(getDBProgramID()) + ".";
}
public static File nohup(String cmd) { try {
  File outFile = File.createTempFile("nohup_" + nohup_sanitize(cmd), ".out");
  nohup(cmd, outFile, false);
  return outFile;
} catch (Exception __e) { throw rethrow(__e); } }

static String nohup_sanitize(String s) {
  return s.replaceAll("[^a-zA-Z0-9\\-_]", "");
}

/** outFile takes stdout and stderr. */
public static void nohup(String cmd, File outFile, boolean append) { try {
  String command = nohup_makeNohupCommand(cmd, outFile, append);

  File scriptFile = File.createTempFile("_realnohup", isWindows() ? ".bat" : "");
  System.out.println("[Nohup] " + command);
  try {
    //System.out.println("[RealNohup] Script file: " + scriptFile.getPath());
    saveTextFile(scriptFile.getPath(), command);
    String[] command2;
    if (isWindows())
      command2 = new String[] {"cmd", "/c", "start", "/b", scriptFile.getPath() };
    else
      command2 = new String[] {"/bin/bash", scriptFile.getPath() };
      
    Process process = Runtime.getRuntime().exec(command2);
    try {
      process.waitFor();
    } catch (InterruptedException e) {
      throw new RuntimeException(e);
    }
    int value = process.exitValue();
    //System.out.println("exit value: " + value);
  } finally {
    if (!isWindows())
      scriptFile.delete();
  }
} catch (Exception __e) { throw rethrow(__e); } }

public static String nohup_makeNohupCommand(String cmd, File outFile, boolean append) {
  mkdirsForFile(outFile);

  String command;
  if (isWindows())
    command = cmd + (append ? " >>" : " >") + winQuote(outFile.getPath()) + " 2>&1";
  else
    command = "nohup " + cmd + (append ? " >>" : " >") + bashQuote(outFile.getPath()) + " 2>&1 &";
  return command;
}

public static String rtrim(String s) {
  int i = s.length();
  while (i > 0 && " \t\r\n".indexOf(s.charAt(i-1)) >= 0)
    --i;
  return i < s.length() ? s.substring(0, i) : s;
}
static void ensureBotIsNotAlreadyRunning(String name) {
  if (hasBot(name))
    throw fail("Bot already running [" + name + "]");
}
// This is for main classes that are all static.
// (We don't go to base classes.)
static Set<String> listFields(Object c) {
  TreeSet<String> fields = new TreeSet();
  for (Field f : _getClass(c).getDeclaredFields())
    fields.add(f.getName());
  return fields;
}
static boolean isURL(String s) {
  return s.startsWith("http://") || s.startsWith("https://");
}
static boolean swic(String a, String b) {
  return startsWithIgnoreCase(a, b);
}
static String snippetImageURL(String snippetID) {
  return snippetImageURL(snippetID, "png");
}

static String snippetImageURL(String snippetID, String contentType) {
  long id = parseSnippetID(snippetID);
  String url;
  if (id == 1000010 || id == 1000012)
    url = "http://tinybrain.de:8080/tb/show-blobimage.php?id=" + id;
  else
    url = "http://eyeocr.sourceforge.net/filestore/filestore.php?cmd=serve&file=blob_" + id
      + "&contentType=image/" + contentType;
  return url;
}
static Map unstructureMap_verboseError(String s) {
  try {
    return unstructureMap(s);
  } catch (Throwable _e) {
    print(">> " + s);
  
throw rethrow(_e); }
}
static long fixTimestamp(long timestamp) {
  return timestamp > now() ? 0 : timestamp;
}
static String className(Object o) {
  return getClassName(o);
}
static String loadGZTextFile(File file) { try {
  if (!file.isFile()) return null;
  ByteArrayOutputStream baos = new ByteArrayOutputStream();
  InputStream fis = new FileInputStream(file);
  GZIPInputStream gis = new GZIPInputStream(fis);
  try {
    byte[] buffer = new byte[1024];
    int len;
    while((len = gis.read(buffer)) != -1){
        baos.write(buffer, 0, len);
    }
  } finally {
    fis.close();
  }
  baos.close();
  return fromUtf8(baos.toByteArray()); // TODO: use a Reader
} catch (Exception __e) { throw rethrow(__e); } }
static int latestInstalledJavaX() {
  File[] files = new File(userHome(), ".javax").listFiles();
  int v = 0;
  if (files != null) for (File f : files) {
    Matcher m = Pattern.compile("x(\\d\\d\\d?)\\.jar").matcher(f.getName());
    if (m.matches())
      v = Math.max(v, Integer.parseInt(m.group(1)));
  }
  return v;
}
static boolean isLocalhost(String ip) {
  return isLoopbackIP(ip) || eqic(ip, "localhost");
}


static String thisVMGreeting() {
  List record_list = (List) ( get(getJavaX(), "record_list"));
  Object android = first(record_list); // Should be of class Android3
  return getString(android, "greeting");
}
static Map unstructureMap(String s) {
  return (Map) unstructure(s);
}
static byte[] intToBytes(int i) {
  return new byte[] {
          (byte) (i >>> 24),
          (byte) (i >>> 16),
          (byte) (i >>> 8),
          (byte) i};
}
static int myVMPort() {
  List records = (List) ( get(getJavaX(), "record_list"));
  Object android = records.get(records.size()-1);
  return (Integer) get(android, "port");
}
static boolean isLoopbackIP(String ip) {
  return eq(ip, "127.0.0.1");
}
static String sendToThisVM_newThread(String s, Object... args) {
  final String _s = format(s, args);
  try {
    return (String) evalInNewThread(new Object() { Object get() { try { return 
      callStaticAnswerMethod(getJavaX(), _s)
    ; } catch (Exception __e) { throw rethrow(__e); } }
  public String toString() { return "callStaticAnswerMethod(getJavaX(), _s)"; }});
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    return str(e);
  }
}
static <A> A popFirst(List<A> l) {
  if (empty(l)) return null;
  A a = first(l);
  l.remove(0);
  return a;
}
static boolean hasBot(String searchPattern) {
  DialogIO io = findBot(searchPattern);
  if (io != null) {
    io.close();
    return true;
  } else
    return false;
}
static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods) {
  return methodsBot2(name, receiver, exposedMethods, null);
}

static Android3 methodsBot2(String name, final Object receiver, final List<String> exposedMethods, final Lock lock) {
  Android3 android = new Android3();
  android.greeting = name;
  android.console = false;
  android.responder = new Responder() {
    String answer(String s, List<String> history) {
      return exposeMethods2(receiver, s, exposedMethods, lock);
    }
  };
  return makeBot(android);
}
static boolean match(String pat, String s) {
  return match3(pat, s);
}

static boolean match(String pat, String s, Matches matches) {
  return match3(pat, s, matches);
}

static String fromUtf8(byte[] bytes) { try {
  return new String(bytes, "UTF-8");
} catch (Exception __e) { throw rethrow(__e); } }


static int makeBot(String greeting) {
  return makeAndroid3(greeting).port;
}

static Android3 makeBot(Android3 a) {
  makeAndroid3(a);
  return a;
}

static Android3 makeBot(String greeting, Object responder) {
  Android3 a = new Android3(greeting);
  a.responder = makeResponder(responder);
  makeBot(a);
  return a;
}

static Android3 makeBot() {
  return makeAndroid3(getProgramTitle() + ".");
}
static Object evalInNewThread(final Object f) {
  final Flag flag = new Flag();
  final Var var = new Var();
  final Var<Throwable> exception = new Var();
  { Thread _t_0 = new Thread() {
public void run() { try {
    try {
      var.set(callF(f));
    } catch (Throwable e) {
      exception.set(e);
    }
    flag.raise();
  } catch (Throwable __e) { printStackTrace2(__e); } }
};
_t_0.start(); }
  flag.waitUntilUp();
  if (exception.has()) throw rethrow(exception.get());
  return var.get();
}
static String callStaticAnswerMethod(List bots, String s) {
  for (Object c : bots) try {
    String answer = callStaticAnswerMethod(c, s);
    if (!empty(answer)) return answer;
  } catch (Throwable e) {
    print("Error calling " + getProgramID(c));
    e.printStackTrace();
  }
  return null;
}

static String callStaticAnswerMethod(Object c, String s) {
  String answer = (String) callOpt(c, "answer", s, litlist(s));
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}

static String callStaticAnswerMethod(String s) {
  return callStaticAnswerMethod(mc(), s);
}

static String callStaticAnswerMethod(String s, List<String> history) {
  return callStaticAnswerMethod(mc(), s, history);
}

static String callStaticAnswerMethod(Object c, String s, List<String> history) {
  String answer = (String) callOpt(c, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(c, "answer", s);
  return emptyToNull(answer);
}
static boolean exposeMethods2_debug;

static String exposeMethods2(Object receiver, String s, List<String> methodNames) {
  return exposeMethods2(receiver, s, methodNames, null);
}

static String exposeMethods2(Object receiver, String s, List<String> methodNames,
  Lock lock) {
  Matches m = new Matches();
  if (exposeMethods2_debug) print("Received: " + s);
  if (match("call *", s, m)) {
    List l;
    if (isIdentifier(m.unq(0)))
      l = ll(m.unq(0));
    else
      l = (List) unstructure(m.unq(0)); // we used to have safeUnstructure here
    String method = getString(l, 0);
    if (!contains(methodNames, method))
      throw fail("Method not allowed: " + method);
    if (lock != null) lock.lock();
    try {
      if (exposeMethods2_debug) print("Calling: " + method);
      Object o = call(receiver, method, asObjectArray(subList(l, 1)));
      if (exposeMethods2_debug) print("Got: " + getClassName(o));
      return ok2(structure(o));
    } finally {
      if (lock != null) lock.unlock();
    }
  }
  if (match("list methods", s))
    return ok2(structure(methodNames));
  return null;
}


static boolean makeAndroid3_disable; // disable all android making

static class Android3 {
  String greeting;
  boolean publicOverride; // optionally set this in client
  int startPort = 5000; // optionally set this in client
  Responder responder;
  boolean console = true;
  boolean quiet; // no messages on console
  boolean daemon = false;
  boolean incomingSilent = false;
  int incomingPrintLimit = 200;
  boolean useMultiPort = true;
  boolean recordHistory;
  boolean verbose;
  int answerPrintLimit = 500;
  
  // set by system
  int port;
  long vport;
  DialogHandler handler;
  ServerSocket server;
  
  Android3(String greeting) {
  this.greeting = greeting;}
  Android3() {}
  
  synchronized void dispose() {
    if (server != null) {
      try {
        server.close();
      } catch (IOException e) {
        print("[internal] " + e);
      }
      server = null;
    }
    if (vport != 0) try {
      print("Disposing " + this);
      removeFromMultiPort(vport);
      vport = 0;
    } catch (Throwable __e) { printStackTrace2(__e); }
  }
  
  public String toString() { return "Bot: " + greeting + " [vport " + vport + "]"; }
}

static abstract class Responder {
  abstract String answer(String s, List<String> history);
}

static Android3 makeAndroid3(final String greeting) {
  return makeAndroid3(new Android3(greeting));
}

static Android3 makeAndroid3(final String greeting, Responder responder) {
  Android3 android = new Android3(greeting);
  android.responder = responder;
  return makeAndroid3(android);
}

static Android3 makeAndroid3(final Android3 a) {
  if (makeAndroid3_disable) return a;
  
  if (a.responder == null)
    a.responder = new Responder() {
      String answer(String s, List<String> history) {
        return callStaticAnswerMethod(s, history);
      }
    };
    
  if (!a.quiet)
    print("[bot] " + a.greeting);
  
  if (a.console && makeAndroid3_consoleInUse()) a.console = false;
  
  record(a);
  
  if (a.useMultiPort)
    a.vport = addToMultiPort(a.greeting,
      makeAndroid3_verboseResponder(a));
      
  if (a.console)
    makeAndroid3_handleConsole(a);

  if (a.useMultiPort) return a;

  a.handler = makeAndroid3_makeDialogHandler(a);
  a.port = a.daemon
    ? startDialogServerOnPortAboveDaemon(a.startPort, a.handler)
    : startDialogServerOnPortAbove(a.startPort, a.handler);
  a.server = startDialogServer_serverSocket;

  return a;
}

static void makeAndroid3_handleConsole(final Android3 a) {
  // Console handling stuff
  if (!a.quiet)
    print("You may also type on this console.");
  { Thread _t_1 = new Thread() {
public void run() { try {
    List<String> history = new ArrayList();
    String line;
    while ((line = readLine()) != null) {
      /*if (eq(line, "bye")) {
        print("> bye stranger");
        history = new ArrayList<S>();
      } else*/ {
        history.add(line);
        history.add(makeAndroid3_getAnswer(line, history, a)); // prints answer on console too
      }
    }
  } catch (Throwable __e) { printStackTrace2(__e); } }
};
_t_1.start(); }
}

static DialogHandler makeAndroid3_makeDialogHandler(final Android3 a) {
  return new DialogHandler() {
public void run(final DialogIO io) {
    if (!a.publicOverride && !(publicCommOn() || io.isLocalConnection())) {
      io.sendLine("Sorry, not allowed");
      return;
    }
    
    String dialogID = randomID(8);
    
    io.sendLine(a.greeting + " / Your ID: " + dialogID);
    
    List<String> history = new ArrayList();
    
    while (io.isStillConnected()) {
      if (io.waitForLine()) {
        final String line = io.readLineNoBlock();
        String s = dialogID + " at " + now() + ": " + quote(line);
        if (!a.incomingSilent)
          print(shorten(s, a.incomingPrintLimit));
        if (eq(line, "bye")) {
          io.sendLine("bye stranger");
          return;
        }
        Matches m = new Matches();
        if (a.recordHistory)
          history.add(line);
        String answer;
        if (match3("this is a continuation of talk *", s, m)
          || match3("hello bot! this is a continuation of talk *", s, m)) {
          dialogID = unquote(m.m[0]);
          answer = "ok";
        } else try {
          makeAndroid3_io.set(io);
          answer = makeAndroid3_getAnswer(line, history, a);
        } finally {
          makeAndroid3_io.set(null);
        }
        if (a.recordHistory)
          history.add(answer);
        io.sendLine(answer);
        //appendToLog(logFile, s);
      }
    }
  }};
}

static String makeAndroid3_getAnswer(String line, List<String> history, Android3 a) {
  String answer, originalAnswer;
  try {
    originalAnswer = a.responder.answer(line, history);
    answer = makeAndroid3_fallback(line, history, originalAnswer);
  } catch (Throwable e) {
    e = getInnerException(e);
    printStackTrace(e);
    originalAnswer = answer = e.toString();
  }
  if (!a.incomingSilent) {
    if (originalAnswer == null) originalAnswer = "?";
    print("> " + shorten(originalAnswer, a.answerPrintLimit));
  }
  return answer;
}

static String makeAndroid3_fallback(String s, List<String> history, String answer) {
  // Now we only do the safe thing instead of VM inspection - give out our process ID
  if (answer == null && match3("what is your pid", s))
    return getPID();
    
  if (answer == null && match3("what is your program id", s)) // should be fairly safe, right?
    return getProgramID();
    
  if (match3("get injection id", s))
    return getInjectionID();
    
  if (answer == null) answer = "?";
  if (answer.indexOf('\n') >= 0 || answer.indexOf('\r') >= 0)
    answer = quote(answer);
  return answer;
}

static boolean makeAndroid3_consoleInUse() {
  for (Object o : record_list)
    if (o instanceof Android3 && ((Android3) o).console)
      return true;
  return false;
}

static Responder makeAndroid3_verboseResponder(final Android3 a) {
  return new Responder() {
    String answer(String s, List<String> history) {
      if (a.verbose)
        print("> " + shorten(s, a.incomingPrintLimit));
      String answer = a.responder.answer(s, history);
      if (a.verbose)
        print("< " + shorten(answer, a.incomingPrintLimit));
      return answer;
    }
  };
}

static ThreadLocal<DialogIO> makeAndroid3_io = new ThreadLocal();

static Android3 makeAndroid3() {
  return makeAndroid3(getProgramTitle() + ".");
}
static String getProgramTitle() {
  return getProgramName();
}
static String emptyToNull(String s) {
  return eq(s, "") ? null : s;
}
static String ok2(String s) {
  return "ok " + s;
}
static String makeResponder_callAnswerMethod(Object bot, String s, List<String> history) {
  String answer = (String) callOpt(bot, "answer", s, history);
  if (answer == null)
    answer = (String) callOpt(bot, "answer", s);
  return answer;
}

static Responder makeResponder(final Object bot) {
  if (bot instanceof Responder) return (Responder) bot;
  
  return new Responder() {
    String answer(String s, List<String> history) {
      return makeResponder_callAnswerMethod(bot, s, history);
    }
  };
}


static List<Object> record_list = synchroList();

static void record(Object o) {
  record_list.add(o);
}
  static AtomicInteger dialogServer_clients = new AtomicInteger();
  static boolean dialogServer_printConnects;
  
  static Set<String> dialogServer_knownClients = synchroTreeSet();
  
  static int startDialogServerOnPortAbove(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler))
      ++port;
    return port;
  }
  
  static int startDialogServerOnPortAboveDaemon(int port, DialogHandler handler) {
    while (!forbiddenPort(port) && !startDialogServerIfPortAvailable(port, handler, true))
      ++port;
    return port;
  }
  
  static void startDialogServer(int port, DialogHandler handler) {
    if (!startDialogServerIfPortAvailable(port, handler))
      throw fail("Can't start dialog server on port " + port);
  }
  
  static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler) {
    return startDialogServerIfPortAvailable(port, handler, false);
  }
  
  static ServerSocket startDialogServer_serverSocket;
    
  static boolean startDialogServerIfPortAvailable(int port, final DialogHandler handler, boolean daemon) {
    ServerSocket serverSocket = null;
    try {
      serverSocket = new ServerSocket(port);
    } catch (IOException e) {
      // probably the port number is used - let's assume there already is a chat server.
      return false;
    }
    final ServerSocket _serverSocket = serverSocket;
    startDialogServer_serverSocket = serverSocket;

    Thread thread = new Thread("Socket accept port " + port) { public void run() {
     try {
      while (true) {
        try {
          final Socket s = _serverSocket.accept();
          
          String client = s.getInetAddress().toString();
          if (!dialogServer_knownClients.contains(client) && neq(client, "/127.0.0.1")) {
            print("connect from " + client + " - clients: " + dialogServer_clients.incrementAndGet());
            dialogServer_knownClients.add(client);
          }
          
          String threadName = "Handling client " + s.getInetAddress();

          Thread t2 = new Thread(threadName) {
           public void run() {
            try {
              final Writer w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
              final BufferedReader in = new BufferedReader(
                new InputStreamReader(s.getInputStream(), "UTF-8"));
                
              DialogIO io = new DialogIO() {
              
                // This should be the same as #1001076 (talkTo)
              
    boolean isLocalConnection() {
      return s.getInetAddress().isLoopbackAddress();
    }
    
    boolean isStillConnected() {
      return !(eos || s.isClosed());
    }
    
    void sendLine(String line) { try {
      w.write(line + "\n");
      w.flush();
    } catch (Exception __e) { throw rethrow(__e); } }
    
    String readLineImpl() { try {
      return in.readLine();
    } catch (Exception __e) { throw rethrow(__e); } }
    
    void close() {
      try {
        s.close();
      } catch (IOException e) {
        // whatever
      }
    }
    
    Socket getSocket() {
      return s;
    }
    };
              
              try {
                handler.run(io);
              } finally {
                s.close();
              }
            } catch (IOException e) {
              print("[internal] " + e);
            } finally {
              //print("client disconnect - " + dialogServer_clients.decrementAndGet() + " remaining");
            }
           }
          }; // Thread t2
          t2.setDaemon(true); // ?
          t2.start();
        } catch (SocketTimeoutException e) {
        }
      }   
     } catch (IOException e) {
       print("[internal] " + e);
     }
    }};
    if (daemon) thread.setDaemon(true);
    thread.start();
   
    print("Dialog server on port " + port + " started."); 
    return true;
  }
static boolean publicCommOn() {
  return "1".equals(loadTextFile(new File(userHome(), ".javax/public-communication")));
}
static void removeFromMultiPort(long vport) {
  if (vport == 0) return;
  for (Object port : getMultiPorts())
    call(port, "removePort", vport);
}
static Object addToMultiPort_responder;

static long addToMultiPort(final String botName) {
  return addToMultiPort(botName, new Object() {
    public String answer(String s, List<String> history) {
      String answer = (String) ( callOpt(getMainClass(), "answer", s, history));
      if (answer != null) return answer;
      answer = (String) callOpt(getMainClass(), "answer", s);
      if (answer != null) return answer;
      if (match3("get injection id", s))
        return getInjectionID();
      return null;
    }
  });
}

static long addToMultiPort(final String botName, final Object responder) {
  //print(botName);
  addToMultiPort_responder = responder;
  startMultiPort();
  List ports = getMultiPorts();
  if (ports == null) return 0;
  if (ports.isEmpty())
    throw fail("No multiports!");
  if (ports.size() > 1)
    print("Multiple multi-ports. Using last one.");
  Object port = last(ports);
  Object responder2 = new Object() {
    public String answer(String s, List<String> history) {
      if (match3("get injection id", s))
        return getInjectionID();
      if (match3("your name", s))
        return botName;
      return (String) call(responder, "answer", s, history);
    }
  };
  record(responder2);
  return (Long) call(port, "addResponder", botName, responder2);
}

static String getInjectionID() {
  return (String) call(getJavaX(), "getInjectionID", getMainClass());
}
static BufferedReader readLine_reader;

static String readLine() {
  return (String) call(getJavaX(), "readLine");
}
static String processID_cached;

// try to get our current process ID
static String getPID() {
  if (processID_cached == null) {
    String name = ManagementFactory.getRuntimeMXBean().getName();
    processID_cached = name.replaceAll("@.*", "");
  }
  return processID_cached;
}
static String getProgramName_cache;

static synchronized String getProgramName() {
  if (getProgramName_cache == null)
    getProgramName_cache = getSnippetTitleOpt(programID());
  return getProgramName_cache;
}


static boolean forbiddenPort(int port) {
  return port == 5037; // adb
}

// start multi-port if none exists in current VM.
static void startMultiPort() {
  List mp = getMultiPorts();
  if (mp != null && mp.isEmpty()) {
    nohupJavax("#1001639");
    throw fail("Upgrading JavaX, please restart this program afterwards.");
    //callMain(hotwire("#1001672"));
  }
}
static String getSnippetTitleOpt(String s) {
  return isSnippetID(s) ? getSnippetTitle(s) : s;
}


static String getSnippetTitle(String id) { try {
  if (!isSnippetID(id)) return "?";
  return trim(loadPageSilently(new URL("http://tinybrain.de:8080/tb-int/getfield.php?id=" + parseSnippetID(id) + "&field=title" + standardCredentials())));
} catch (Exception __e) { throw rethrow(__e); } }

static String getSnippetTitle(long id) {
  return getSnippetTitle(fsI(id));
}



static class Str extends Concept {
  String name;
  List<String> otherNames = new ArrayList();
  
  Str() {}
  Str(String name) {
  this.name = name;}
  
  public String toString() { return name; }
}

static class Rect {
  int x, y, w, h;
  
  Rect() {}
  Rect(Rectangle r) {
    x = r.x;
    y = r.y;
    w = r.width;
    h = r.height;
  }
  Rect(int x, int y, int w, int h) {
  this.h = h;
  this.w = w;
  this.y = y;
  this.x = x;}
  
  Rectangle getRectangle() {
    return new Rectangle(x, y, w, h);
  }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
  
  public String toString() {
    return x + "," + y + " / " + w + "," + h;
  }
  
  int x2() { return x + w; }
  int y2() { return y + h; }
  
  boolean contains(Pt p) {
    return contains(p.x, p.y);
  }
  
  boolean contains(int _x, int _y) {
    return _x >= x && _y >= y && _x < x+w && _y < y+h;
  }
  
  boolean empty() { return w <= 0 || h <= 0; }
}

/** this class is fully thread-safe */
static class Flag {
  private boolean up;

  /** returns true if flag was down before */
  public synchronized boolean raise() {
    if (!up) {
      up = true;
      notifyAll();
      return true;
    } else
      return false;
  }

  public synchronized void waitUntilUp() {
    while (!up) {
      try {
        wait();
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized void waitUntilUp(long timeout) {
    if (!up) {
      try {
        wait(timeout);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
    }
  }

  public synchronized boolean isUp() {
    return up;
  }

  public String toString() {
    return isUp() ? "up" : "down";
  }

  // currently does a semi-active wait with latency = 50 ms
  public void waitForThisOr(Flag otherFlag) { try {
    while (!isUp() && !otherFlag.isUp())
      Thread.sleep(50);
  } catch (Exception __e) { throw rethrow(__e); } }
}

static class ProgramScan {
  static int threads = isWindows() ? 500 : 10;
  static int timeout = 5000; // hmm...
  static String ip = "127.0.0.1";
  
  // This range is not used anymore anyway
  static int quickScanFrom = 10000, quickScanTo = 10999;

  static int maxNumberOfVMs_android = 4; // Android will always only have one if we don't screw up
  static int maxNumberOfVMs_nonAndroid = 50; // 100;
  static int maxNumberOfVMs;
  
  static boolean verbose;
  
  static class Program {
    int port;
    String helloString;
    
    Program(int port, String helloString) {
  this.helloString = helloString;
  this.port = port;}
  }
  
  static List<Program> scan() { try {
    return scan(1, 65535);
  } catch (Exception __e) { throw rethrow(__e); } }
  
  static List<Program> scan(int fromPort, int toPort) {
    return scan(fromPort, toPort, new int[0]);
  }
  
  static List<Program> scan(int fromPort, int toPort, int[] preferredPorts) { try {
    Set<Integer> preferredPortsSet = new HashSet<Integer>(asList(preferredPorts));
    int scanSize = toPort-fromPort+1;
    String name = toPort < 10000 ? "bot" : "program";
    int threads = isWindows() ? min(500, scanSize) : min(scanSize, 10);
    final ExecutorService es = Executors.newFixedThreadPool(threads);
    if (verbose) print(firstToUpper(name) + "-scanning " + ip + " with timeout " + timeout + " ms in " + threads + " threads.");
    startTiming();
    List < Future < Program > > futures = new ArrayList();
    List<Integer> ports = new ArrayList();
    for (int port : preferredPorts) {
      futures.add(checkPort(es, ip, port, timeout));
      ports.add(port);
    }
    for (int port = fromPort; port <= toPort; port++)
      if (!preferredPortsSet.contains(port) && !forbiddenPort(port)) {
        futures.add(checkPort(es, ip, port, timeout));
        ports.add(port);
      }
    es.shutdown();
    List<Program> programs = new ArrayList();
    long time = now();
    int i = 0;
    for (final Future<Program> f : futures) {
      if (verbose) print("Waiting for port " + get(ports, i++) + " at time " + (now()-time));
      Program p = f.get();
      if (p != null)
        programs.add(p);
    }
    //stopTiming("Port Scan " + scanSize + ", " + n(threads, "threads") + ": ", 250);
    if (verbose) print("Found " + programs.size() + " " + name + "(s) on " + ip);
    return programs;
  } catch (Exception __e) { throw rethrow(__e); } }

  static Future<Program> checkPort(final ExecutorService es, final String ip, final int port, final int timeout) {
    return es.submit(new Callable<Program>() {
        @Override public Program call() {
          try {
            Socket socket = new Socket();
            try {
              socket.setSoTimeout(timeout);
              socket.connect(new InetSocketAddress(ip, port), timeout);
              //if (verbose) print("Connected to " + ip + ":" + port);
              BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream(), "UTF-8"));
              String hello = or(in.readLine(), "?");
              return new Program(port, hello);
            } finally {
              socket.close();
            }
          } catch (Exception ex) {
            return null;
          }
        }
     });
  }
  
  static List<Program> quickScan() {
    return scan(quickScanFrom, quickScanTo);
  }
  
  static List<Program> quickBotScan() {
    return quickBotScan(new int[0]);
  }
  
  static List<Program> quickBotScan(int[] preferredPorts) {
    if (maxNumberOfVMs == 0)
      maxNumberOfVMs = isAndroid() ? maxNumberOfVMs_android : maxNumberOfVMs_nonAndroid;
    return scan(4999, 5000+maxNumberOfVMs-1, preferredPorts);
  }
}

  static abstract class DialogIO {
    String line;
    boolean eos, loud, noClose;
    
    abstract String readLineImpl();
    abstract boolean isStillConnected();
    abstract void sendLine(String line);
    abstract boolean isLocalConnection();
    abstract Socket getSocket();
    abstract void close();
    
    int getPort() { Socket s = getSocket(); return s == null ? 0 : s.getPort(); }
    
    boolean helloRead;
    int shortenOutputTo = 500;
    
    String readLineNoBlock() {
      String l = line;
      line = null;
      return l;
    }
    
    boolean waitForLine() { try {
      if (line != null) return true;
      //print("Readline");
      line = readLineImpl();
      //print("Readline done: " + line);
      if (line == null) eos = true;
      return line != null;
    } catch (Exception __e) { throw rethrow(__e); } }
    
    String readLine() {
      waitForLine();
      helloRead = true;
      return readLineNoBlock();
    }
    
    String ask(String s, Object... args) {
      if (loud) return askLoudly(s, args);
      if (!helloRead) readLine();
      if (args.length != 0) s = format3(s, args);
      sendLine(s);
      return readLine();
    }
    
    String askLoudly(String s, Object... args) {
      if (!helloRead) readLine();
      if (args.length != 0) s = format3(s, args);
      print("> " + shorten(s, shortenOutputTo));
      sendLine(s);
      String answer = readLine();
      print("< " + shorten(answer, shortenOutputTo));
      return answer;
    }
    
    void pushback(String l) {
      if (line != null)
        throw fail();
      line = l;
      helloRead = false;
    }
  }
  
  static abstract class DialogHandler {
    abstract void run(DialogIO io);
  }

static class RGB {
  public float r, g, b; // can't be final cause persistence
  
  RGB() {}
  
  public RGB(float r, float g, float b) {
    this.r = r;
    this.g = g;
    this.b = b;
  }

  public RGB(double r, double g, double b) {
    this.r = (float) r;
    this.g = (float) g;
    this.b = (float) b;
  }

  public RGB(int rgb) {
    this(new Color(rgb));
  }
  
  public RGB(double brightness) {
    this.r = this.g = this.b = max(0f, min(1f, (float) brightness));
  }

  public RGB(Color color) {
    this.r = color.getRed()/255f;
    this.g = color.getGreen()/255f;
    this.b = color.getBlue()/255f;
  }

  public RGB(String hex) {
    r = Integer.parseInt(hex.substring(0, 2), 16)/255f;
    g = Integer.parseInt(hex.substring(2, 4), 16)/255f;
    b = Integer.parseInt(hex.substring(4, 6), 16)/255f;
  }

  public float getComponent(int i) {
    return i == 0 ? r : i == 1 ? g : b;
  }

  public Color getColor() {
    return new Color(r, g, b);
  }

  public static RGB newSafe(float r, float g, float b) {
    return new RGB(Math.max(0, Math.min(1, r)), Math.max(0, Math.min(1, g)), Math.max(0, Math.min(1, b)));
  }

  int asInt() { return getColor().getRGB() & 0xFFFFFF; }
  int getInt() { return getColor().getRGB() & 0xFFFFFF; }

  public float getBrightness() {
    return (r+g+b)/3.0f;
  }

  public String getHexString() {
    return Integer.toHexString(asInt() | 0xFF000000).substring(2).toUpperCase();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof RGB)) return false;

    RGB rgb = (RGB) o;

    if (Float.compare(rgb.b, b) != 0) return false;
    if (Float.compare(rgb.g, g) != 0) return false;
    if (Float.compare(rgb.r, r) != 0) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = (r != +0.0f ? Float.floatToIntBits(r) : 0);
    result = 31 * result + (g != +0.0f ? Float.floatToIntBits(g) : 0);
    result = 31 * result + (b != +0.0f ? Float.floatToIntBits(b) : 0);
    return result;
  }

  public boolean isBlack() {
    return r == 0f && g == 0f && b == 0f;
  }

  public boolean isWhite() {
    return r == 1f && g == 1f && b == 1f;
  }

  public String toString() {
    return getHexString();
  }
}

static class RGBImage {
  transient BufferedImage bufferedImage;
  File file;
  int width, height;
  int[] pixels;

  RGBImage() {}

  RGBImage(BufferedImage image) {
    this(image, null);
  }

  RGBImage(BufferedImage image, File file) {
    this.file = file;
    bufferedImage = image;
    width = image.getWidth();
    height = image.getHeight();
    pixels = new int[width*height];
    PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
    try {
      if (!pixelGrabber.grabPixels())
        throw new RuntimeException("Could not grab pixels");
      cleanPixels(); // set upper byte to 0
    } catch (InterruptedException e) {
      throw new RuntimeException(e);
    }
  }

  /** We assume it's a file name to load from */
  RGBImage(String file) throws IOException {
    this(new File(file));
  }

  RGBImage(Dimension size, Color color) {
    this(size.width, size.height, color);
  }

  RGBImage(Dimension size, RGB color) {
    this(size.width, size.height, color);
  }

  private void cleanPixels() {
    for (int i = 0; i < pixels.length; i++)
      pixels[i] &= 0xFFFFFF;
  }

  RGBImage(int width, int height, int[] pixels) {
    this.width = width;
    this.height = height;
    this.pixels = pixels;
  }

  RGBImage(int w, int h, RGB[] pixels) {
    this.width = w;
    this.height = h;
    this.pixels = asInts(pixels);
  }

  public static int[] asInts(RGB[] pixels) {
    int[] ints = new int[pixels.length];
    for (int i = 0; i < pixels.length; i++)
      ints[i] = pixels[i] == null ? 0 : pixels[i].getColor().getRGB();
    return ints;
  }

  public RGBImage(int w, int h) {
    this(w, h, Color.black);
  }
  
  RGBImage(int w, int h, RGB rgb) {
    this.width = w;
    this.height = h;
    this.pixels = new int[w*h];
    int col = rgb.asInt();
    if (col != 0)
      for (int i = 0; i < pixels.length; i++)
        pixels[i] = col;
  }

  RGBImage(RGBImage image) {
    this(image.width, image.height, copyPixels(image.pixels));
  }

  RGBImage(int width, int height, Color color) {
    this(width, height, new RGB(color));
  }

  RGBImage(File file) throws IOException {
    this(javax.imageio.ImageIO.read(file));
  }

  private static int[] copyPixels(int[] pixels) {
    int[] copy = new int[pixels.length];
    System.arraycopy(pixels, 0, copy, 0, pixels.length);
    return copy;
  }

  public int getIntPixel(int x, int y) {
    if (inRange(x, y))
      return pixels[y * width + x];
    else
      return 0xFFFFFF;
  }

  public static RGB asRGB(int packed) {
    int r = (packed >> 16) & 0xFF;
    int g = (packed >> 8) & 0xFF;
    int b = packed & 0xFF;
    return new RGB(r / 255f, g / 255f, b / 255f);
  }

  public RGB getRGB(int x, int y) {
    if (inRange(x, y))
      return asRGB(pixels[y * width + x]);
    else
      return new RGB(0xFFFFFF);
  }

  /** alias of getRGB - I kept typing getPixel instead of getRGB all the time, so I finally created it */
  RGB getPixel(int x, int y) {
    return getRGB(x, y);
  }
  
  RGB getPixel(Pt p) { return getPixel(p.x, p.y); }

  int getWidth() { return width; }
  int getHeight() { return height; }
  int w() { return width; }
  int h() { return height; }

  /** Attention: cached, i.e. does not change when image itself changes */
  /** @NotNull */
  public BufferedImage getBufferedImage() {
    if (bufferedImage == null) {
      bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      //bufferedImage.setData(Raster.createRaster(new SampleModel()));
      for (int y = 0; y < height; y++)
        for (int x = 0; x < width; x++)
          bufferedImage.setRGB(x, y, pixels[y*width+x]);
    }
    return bufferedImage;
  }

  RGBImage clip(Rect r) {
    return r == null ? null : clip(r.getRectangle());
  }
  
  RGBImage clip(Rectangle r) {
    r = fixClipRect(r);
    int[] newPixels;
    try {
      newPixels = new int[r.width*r.height];
    } catch (RuntimeException e) {
      System.out.println(r);
      throw e;
    }
    for (int y = 0; y < r.height; y++) {
      System.arraycopy(pixels, (y+r.y)*width+r.x, newPixels, y*r.width, r.width);
    }
    return new RGBImage(r.width, r.height, newPixels);
  }

  private Rectangle fixClipRect(Rectangle r) {
    r = r.intersection(new Rectangle(0, 0, width, height));
    if (r.isEmpty())
      r = new Rectangle(r.x, r.y, 0, 0);
    return r;
  }

  public File getFile() {
    return file;
  }

  /** can now also do GIF (not just JPEG) */
  public static RGBImage load(String fileName) {
    return load(new File(fileName));
  }

  /** can now also do GIF (not just JPEG) */
  public static RGBImage load(File file) {
    try {
      BufferedImage bufferedImage = javax.imageio.ImageIO.read(file);
      return new RGBImage(bufferedImage);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public int getInt(int x, int y) {
    return pixels[y * width + x];
  }

  public void save(File file) throws IOException {
    String name = file.getName().toLowerCase();
    String type;
    if (name.endsWith(".png")) type = "png";
    else if (name.endsWith(".jpg") || name.endsWith(".jpeg")) type = "jpeg";
    else throw new IOException("Unknown image extension: " + name);
    javax.imageio.ImageIO.write(getBufferedImage(), type, file);
  }

  public static RGBImage dummyImage() {
    return new RGBImage(1, 1, new int[] {0xFFFFFF});
  }

  public int[] getPixels() {
    return pixels;
  }

  public void setPixel(int x, int y, RGB rgb) {
    if (x >= 0 && y >= 0 && x < width && y < height)
      pixels[y*width+x] = rgb.asInt();
  }

  public void setPixel(int x, int y, Color color) {
    setPixel(x, y, new RGB(color));
  }

  public void setPixel(int x, int y, int rgb) {
    if (x >= 0 && y >= 0 && x < width && y < height)
      pixels[y*width+x] = rgb;
  }
  
  void setPixel(Pt p, RGB rgb) { setPixel(p.x, p.y, rgb); }
  void setPixel(Pt p, Color color) { setPixel(p.x, p.y, color); }

  public RGBImage copy() {
    return new RGBImage(this);
  }

  public boolean inRange(int x, int y) {
    return x >= 0 && y >= 0 && x < width && y < height;
  }

  public Dimension getSize() {
    return new Dimension(width, height);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    RGBImage rgbImage = (RGBImage) o;

    if (height != rgbImage.height) return false;
    if (width != rgbImage.width) return false;
    if (!Arrays.equals(pixels, rgbImage.pixels)) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = width;
    result = 31 * result + height;
    result = 31 * result + Arrays.hashCode(pixels);
    return result;
  }

  public String getHex(int x, int y) {
    return getPixel(x, y).getHexString();
  }

  public RGBImage clip(int x, int y, int width, int height) {
    return clip(new Rectangle(x, y, width, height));
  }

  public RGBImage clipLine(int y) {
    return clip(0, y, width, 1);
  }

  public int numPixels() {
    return width*height;
  }
}



static boolean inRange(int x, int n) {
  return x >= 0 && x < n;
}
static long stopTiming_defaultMin = 10;

static long startTiming_startTime;
static void startTiming() {
  startTiming_startTime = now();
}

static void stopTiming() {
  stopTiming(null);
}

static void stopTiming(String text) {
  stopTiming(text, stopTiming_defaultMin);
}

static void stopTiming(String text, long minToPrint) {
  long time = now()-startTiming_startTime;
  if (time >= minToPrint) {
    text = or2(text, "Time: ");
    print(text + time + " ms");
  }
}
static int asInt(Object o) {
  return toInt(o);
}
static String firstToUpper(String s) {
  if (s.length() == 0) return s;
  return Character.toUpperCase(s.charAt(0)) + s.substring(1);
}


static int toInt(Object o) {
  if (o == null) return 0;
  if (o instanceof Number)
    return ((Number) o).intValue();
  if (o instanceof String)
    return parseInt((String) o);
  throw fail("woot not int: " + getClassName(o));
}

static int toInt(long l) {
  if (l != (int) l) throw fail("Too large for int: " + l);
  return (int) l;
}


static class Pt {
  int x, y;
  
  Pt() {}
  Pt(Point p) {
    x = p.x;
    y = p.y;
  }
  Pt(int x, int y) {
  this.y = y;
  this.x = x;}
  
  Point getPoint() {
    return new Point(x, y);
  }
  
  public boolean equals(Object o) { return stdEq2(this, o); }
public int hashCode() { return stdHash2(this); }
  
  public String toString() {
    return x + ", " + y;
  }
}

static boolean stdEq2(Object a, Object b) {
  if (a == null) return b == null;
  if (b == null) return false;
  if (a.getClass() != b.getClass()) return false;
  for (String field : allFields(a))
    if (neq(getOpt(a, field), getOpt(b, field)))
      return false;
  return true;
}
static int stdHash2(Object a) {
  if (a == null) return 0;
  return stdHash(a, toStringArray(allFields(a)));
}


static Set<String> allFields(Object o) {
  TreeSet<String> fields = new TreeSet();
  Class _c = _getClass(o);
  do {
    for (Field f : _c.getDeclaredFields())
      fields.add(f.getName());
    _c = _c.getSuperclass();
  } while (_c != null);
  return fields;
}
static int stdHash(Object a, String... fields) {
  if (a == null) return 0;
  int hash = getClassName(a).hashCode();
  for (String field : fields)
    hash = hash*2+hashCode(getOpt(a, field));
  return hash;
}


static int hashCode(Object a) {
  return a == null ? 0 : a.hashCode();
}

}


